
/*
    Copyright 2025 Picovoice Inc.

    You may not use this file except in compliance with the license. A copy of the license is located in the "LICENSE"
    file accompanying this source.

    Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
    specific language governing permissions and limitations under the License.
*/

#ifndef PV_PARAMS_H
#define PV_PARAMS_H

#include <stdint.h>

// wake-word = hola computadora 
static const uint8_t KEYWORD_ARRAY[] = {
        0xa8, 0xe7, 0x54, 0x5d, 0xce, 0x2f, 0x24, 0x1a, 0xd0, 0x8f, 0xcb, 0xe1, 0x2a, 0x52, 0x03, 0x88, 0x07, 0xbf,
        0x2d, 0xca, 0x30, 0x5f, 0xfc, 0xe6, 0x08, 0x9b, 0xca, 0xa2, 0x76, 0xdf, 0xb6, 0x80, 0x1e, 0xb4, 0xb7, 0x34,
        0x1f, 0x44, 0x41, 0x33, 0x15, 0x18, 0x38, 0x5b, 0x86, 0x48, 0x65, 0x58, 0xb0, 0x65, 0xb7, 0xb2, 0xdd, 0x9e,
        0x30, 0x31, 0x70, 0x1a, 0xe6, 0x5a, 0x67, 0x9d, 0xd2, 0xa5, 0x7d, 0x57, 0x5e, 0x0f, 0x78, 0x75, 0x70, 0xcc,
        0xd3, 0xf9, 0x83, 0xe9, 0x81, 0x3a, 0xd1, 0x19, 0xbd, 0x07, 0x08, 0x3a, 0xf8, 0x82, 0x3c, 0x03, 0x10, 0xf8,
        0xe9, 0x84, 0xcd, 0xcb, 0xc5, 0xba, 0xcc, 0x96, 0xda, 0xe4, 0x7b, 0x03, 0x5b, 0xe3, 0x06, 0xe4, 0x5f, 0x15,
        0x35, 0xc0, 0x35, 0x91, 0x37, 0x8d, 0x17, 0x17, 0xe0, 0x9c, 0xfa, 0xe2, 0x95, 0x39, 0x2e, 0x62, 0xee, 0x96,
        0x1c, 0x41, 0x9a, 0x09, 0x20, 0xfb, 0xdb, 0x3f, 0x6c, 0x66, 0x7d, 0xef, 0x54, 0xd2, 0xb6, 0x45, 0xdc, 0xc5,
        0x26, 0xbb, 0xb4, 0xc8, 0xfc, 0xa9, 0x23, 0xc4, 0x84, 0x87, 0x5a, 0x93, 0x77, 0x5d, 0x7b, 0xc3, 0xe7, 0x12,
        0x08, 0xff, 0x5b, 0x3e, 0x14, 0xb2, 0x18, 0xf1, 0x0a, 0x9f, 0xf5, 0xcb, 0x97, 0x9b, 0xfa, 0x5d, 0xb9, 0x56,
        0x2d, 0x26, 0x3f, 0x6b, 0x5f, 0x25, 0x9d, 0x44, 0x87, 0xbc, 0xd5, 0x94, 0x13, 0xbe, 0x4c, 0xab, 0x10, 0xb2,
        0xde, 0xcb, 0x47, 0x69, 0x8c, 0x1d, 0xbd, 0xfa, 0xb1, 0x41, 0x73, 0x1a, 0x71, 0x0b, 0x10, 0x9a, 0x60, 0xc1,
        0x30, 0x7d, 0xca, 0x31, 0xe9, 0xf1, 0x65, 0x0e, 0x6b, 0x58, 0x4d, 0x67, 0x75, 0x62, 0x26, 0x8c, 0xab, 0xdc,
        0x89, 0xec, 0x1f, 0x20, 0x4f, 0x45, 0xcb, 0x84, 0x54, 0xf2, 0x77, 0xd1, 0x80, 0x10, 0xc2, 0x3a, 0xcd, 0x5c,
        0x40, 0x50, 0x0b, 0x7f, 0x51, 0x3a, 0xf3, 0xc7, 0x16, 0x2a, 0x93, 0xdf, 0x52, 0xdd, 0x68, 0x5d, 0x63, 0xe6,
        0x9b, 0xe7, 0x26, 0x50, 0xd7, 0x7d, 0xcb, 0xb7, 0xe7, 0xbd, 0x60, 0xbe, 0x2e, 0xdd, 0x41, 0xcb, 0x19, 0x1a,
        0x56, 0x02, 0xbe, 0x1f, 0xdd, 0xe9, 0x60, 0x3f, 0xe4, 0xc4, 0x5e, 0xf5, 0x3c, 0x87, 0x60, 0xdf, 0x84, 0xf9,
        0x6c, 0x9c, 0x3d, 0xbd, 0x08, 0x15, 0x70, 0xe5, 0x95, 0x9f, 0xfb, 0xd1, 0xcc, 0x61, 0x55, 0x93, 0xf2, 0xf8,
        0x32, 0x6b, 0xc5, 0xcd, 0xf7, 0x83, 0x84, 0x2a, 0x9e, 0x1f, 0x5e, 0xd7, 0xdd, 0x52, 0xb3, 0x27, 0x39, 0x15,
        0x26, 0x2f, 0xc2, 0x2c, 0x85, 0xb6, 0x38, 0x4e, 0x64, 0x6e, 0xdd, 0x68, 0x96, 0x29, 0xbe, 0x0c, 0xbe, 0x8d,
        0x5a, 0x4b, 0x87, 0x85, 0x5c, 0xd8, 0x62, 0xc3, 0x9b, 0x6f, 0x29, 0xf0, 0x18, 0x83, 0x13, 0x11, 0x07, 0x0c,
        0xa6, 0xb0, 0x9a, 0x0b, 0x9c, 0x49, 0x5d, 0xc2, 0x8a, 0x02, 0xd5, 0x28, 0x16, 0xb9, 0xae, 0xd4, 0xf7, 0x41,
        0x5c, 0x0b, 0x76, 0xf9, 0x9d, 0xc2, 0x14, 0x92, 0x12, 0x34, 0x3c, 0x46, 0x5d, 0xcc, 0x97, 0x19, 0x86, 0x52,
        0x51, 0xd7, 0xa0, 0x27, 0x1d, 0xa2, 0xb9, 0xc6, 0x7d, 0x65, 0x9e, 0x8c, 0x3b, 0xd5, 0xff, 0x60, 0xf1, 0x10,
        0x64, 0xf3, 0xd7, 0x5c, 0x3a, 0xa6, 0x06, 0xe1, 0x9f, 0x85, 0x18, 0x3a, 0x28, 0x3b, 0x35, 0x7e, 0x09, 0x94,
        0x84, 0x4c, 0x57, 0x33, 0x3d, 0xda, 0xe3, 0x03, 0xdd, 0x21, 0xa8, 0x46, 0x61, 0xc7, 0x19, 0xac, 0x42, 0xc1,
        0x7a, 0x58, 0xa0, 0x92, 0x12, 0xd0, 0x8d, 0x44, 0xb0, 0x09, 0xe7, 0xea, 0xeb, 0xdc, 0xc8, 0xe4, 0xd5, 0x03,
        0xd6, 0x29, 0xeb, 0xd0, 0x42, 0x1d, 0x3d, 0xcc, 0xd4, 0x13, 0xb8, 0x44, 0xf8, 0xa5, 0xac, 0x91, 0x29, 0x02,
        0x23, 0xd9, 0x6b, 0xce, 0x16, 0x20, 0x6e, 0xc2, 0xe3, 0xb2, 0xa1, 0x54, 0x68, 0x5b, 0x7e, 0x56, 0xfd, 0x2e,
        0xc8, 0xbc, 0x74, 0x00, 0xbb, 0x4a, 0x3d, 0xa3, 0x97, 0xb2, 0xfe, 0x5f, 0x5d, 0xfe, 0x2d, 0x42, 0xfc, 0x6c,
        0x44, 0xca, 0xfb, 0xd0, 0x29, 0x8f, 0x92, 0x38, 0xf3, 0x91, 0x2e, 0xc0, 0x8a, 0x99, 0x75, 0xc5, 0x16, 0xfb,
        0xb9, 0xcd, 0x38, 0xcf, 0x0a, 0xc0, 0x81, 0xb9, 0xba, 0xf5, 0x35, 0xa3, 0x90, 0x11, 0xa5, 0x77, 0x99, 0x60,
        0x7e, 0x66, 0x8f, 0x30, 0x4e, 0x27, 0xfa, 0x4e, 0x22, 0x09, 0xcc, 0xed, 0x41, 0x05, 0xa5, 0x99, 0xda, 0xd4,
        0xba, 0x14, 0x90, 0xec, 0x0b, 0x4b, 0x21, 0xc7, 0x31, 0xd9, 0xfc, 0x66, 0x2d, 0x17, 0x80, 0x75, 0x9b, 0x16,
        0x54, 0xe9, 0x6b, 0xcb, 0xb5, 0x2c, 0x77, 0x7a, 0x73, 0x72, 0x4e, 0x84, 0x40, 0xd1, 0xce, 0x39, 0x19, 0xba,
        0x1d, 0x39, 0xe3, 0x8e, 0xfb, 0x58, 0xd8, 0xb1, 0xa9, 0x82, 0x1e, 0xbd, 0x65, 0x82, 0xf5, 0x0f, 0xce, 0xfa,
        0xb0, 0x60, 0x22, 0x38
};

// context = iluminación_inteligente 
static const uint8_t CONTEXT_ARRAY[] = {
        0x72, 0x68, 0x69, 0x6e, 0x6f, 0x34, 0x2e, 0x30, 0x2e, 0x30, 0x00, 0x00, 0x00, 0x00, 0x65, 0x73, 0x00, 0x09,
        0x00, 0x00, 0x00, 0x70, 0x69, 0x63, 0x6f, 0x76, 0x6f, 0x69, 0x63, 0x65, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xa8, 0x0c, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x6f,
        0x6e, 0x74, 0x65, 0x78, 0x74, 0x3a, 0x0a, 0x20, 0x20, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
        0x6e, 0x73, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x43, 0x6f, 0x6c, 0x6f,
        0x72, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x68, 0x61, 0x7a, 0x20, 0x71, 0x75, 0x65,
        0x20, 0x6c, 0x61, 0x73, 0x20, 0x6c, 0x75, 0x63, 0x65, 0x73, 0x20, 0x73, 0x65, 0x61, 0x6e, 0x20, 0x24, 0x63,
        0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d,
        0x20, 0x63, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x20, 0x6c, 0x61, 0x73, 0x20, 0x6c, 0x75, 0x63, 0x65, 0x73, 0x20,
        0x61, 0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x0a, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x2d, 0x20, 0x68, 0x61, 0x7a, 0x20, 0x71, 0x75, 0x65, 0x20, 0x5b, 0x6c, 0x61, 0x2c, 0x20,
        0x6c, 0x61, 0x73, 0x5d, 0x20, 0x5b, 0x6c, 0x75, 0x7a, 0x2c, 0x20, 0x6c, 0x75, 0x63, 0x65, 0x73, 0x5d, 0x20,
        0x5b, 0x64, 0x65, 0x6c, 0x2c, 0x20, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x2c, 0x20, 0x65, 0x6e, 0x20, 0x65, 0x6c,
        0x2c, 0x20, 0x65, 0x6e, 0x20, 0x6c, 0x61, 0x5d, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24,
        0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
        0x5b, 0x73, 0x65, 0x61, 0x2c, 0x20, 0x73, 0x65, 0x61, 0x6e, 0x5d, 0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f, 0x72,
        0x3a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x63, 0x61, 0x6d,
        0x62, 0x69, 0x61, 0x20, 0x5b, 0x6c, 0x61, 0x2c, 0x20, 0x6c, 0x61, 0x73, 0x5d, 0x20, 0x5b, 0x6c, 0x75, 0x7a,
        0x2c, 0x20, 0x6c, 0x75, 0x63, 0x65, 0x73, 0x5d, 0x20, 0x5b, 0x64, 0x65, 0x6c, 0x2c, 0x20, 0x64, 0x65, 0x20,
        0x6c, 0x61, 0x2c, 0x20, 0x65, 0x6e, 0x20, 0x65, 0x6c, 0x2c, 0x20, 0x65, 0x6e, 0x20, 0x6c, 0x61, 0x5d, 0x0a,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a,
        0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61, 0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a,
        0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x68, 0x61, 0x7a, 0x20,
        0x71, 0x75, 0x65, 0x20, 0x5b, 0x73, 0x65, 0x61, 0x2c, 0x20, 0x73, 0x65, 0x61, 0x6e, 0x5d, 0x20, 0x24, 0x63,
        0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x20, 0x5b, 0x6c, 0x61, 0x2c, 0x20, 0x6c, 0x61,
        0x73, 0x5d, 0x20, 0x5b, 0x6c, 0x75, 0x7a, 0x2c, 0x20, 0x6c, 0x75, 0x63, 0x65, 0x73, 0x5d, 0x20, 0x5b, 0x64,
        0x65, 0x6c, 0x2c, 0x20, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x2c, 0x20, 0x65, 0x6e, 0x0a, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x65, 0x6c, 0x2c, 0x20, 0x65, 0x6e, 0x20, 0x6c, 0x61, 0x5d, 0x20, 0x24, 0x6c, 0x6f,
        0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x0a, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x63, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x20, 0x61, 0x20, 0x24, 0x63, 0x6f,
        0x6c, 0x6f, 0x72, 0x3a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x20, 0x5b, 0x6c, 0x61, 0x2c, 0x20, 0x6c, 0x61, 0x73,
        0x5d, 0x20, 0x5b, 0x6c, 0x75, 0x7a, 0x2c, 0x20, 0x6c, 0x75, 0x63, 0x65, 0x73, 0x5d, 0x20, 0x5b, 0x64, 0x65,
        0x6c, 0x2c, 0x20, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x2c, 0x20, 0x65, 0x6e, 0x20, 0x65, 0x6c, 0x2c, 0x20, 0x65,
        0x6e, 0x20, 0x6c, 0x61, 0x5d, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24, 0x6c, 0x6f, 0x63,
        0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x0a, 0x20, 0x20, 0x20,
        0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4c, 0x69, 0x67, 0x68, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x3a,
        0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x24, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x61,
        0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x28, 0x74, 0x6f, 0x64, 0x61, 0x73, 0x29, 0x20, 0x6c, 0x61, 0x73, 0x20,
        0x6c, 0x75, 0x63, 0x65, 0x73, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x24, 0x61, 0x63, 0x74,
        0x69, 0x6f, 0x6e, 0x3a, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x28, 0x6c, 0x61, 0x2c, 0x20, 0x6c, 0x61,
        0x73, 0x29, 0x20, 0x5b, 0x6c, 0x75, 0x7a, 0x2c, 0x20, 0x6c, 0x75, 0x63, 0x65, 0x73, 0x5d, 0x20, 0x5b, 0x64,
        0x65, 0x6c, 0x2c, 0x20, 0x64, 0x65, 0x20, 0x6c, 0x61, 0x2c, 0x20, 0x65, 0x6e, 0x20, 0x65, 0x6c, 0x2c, 0x20,
        0x65, 0x6e, 0x20, 0x6c, 0x61, 0x5d, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x24, 0x6c, 0x6f,
        0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x0a, 0x20, 0x20,
        0x73, 0x6c, 0x6f, 0x74, 0x73, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x0a,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x7a, 0x75, 0x6c, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x2d, 0x20, 0x76, 0x65, 0x72, 0x64, 0x65, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x72,
        0x6f, 0x73, 0x61, 0x64, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x6d, 0x6f, 0x72, 0x61,
        0x64, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x72, 0x6f, 0x6a, 0x6f, 0x0a, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x62, 0x6c, 0x61, 0x6e, 0x63, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x2d, 0x20, 0x61, 0x6d, 0x61, 0x72, 0x69, 0x6c, 0x6c, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x6c, 0x6f,
        0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x62, 0x61,
        0xc3, 0xb1, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x72, 0x6d, 0x61, 0x72, 0x69,
        0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x63, 0x6f, 0x63, 0x69, 0x6e, 0x61, 0x0a, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x73, 0x61, 0x6c, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x2d, 0x20, 0x64, 0x65, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d,
        0x20, 0x64, 0x6f, 0x72, 0x6d, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x2d, 0x20, 0x68, 0x61, 0x62, 0x69, 0x74, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x0a, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x2d, 0x20, 0x70, 0x61, 0x73, 0x69, 0x6c, 0x6c, 0x6f, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x61, 0x63,
        0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x65, 0x6e, 0x63, 0x69,
        0x65, 0x6e, 0x64, 0x61, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x61, 0x70, 0x61, 0x67, 0x61,
        0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
        0x17, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x2b, 0x00,
        0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, 0x00,
        0x4c, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5d, 0x00, 0x00, 0x00, 0x63, 0x00, 0x00, 0x00, 0x6c, 0x00,
        0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x83, 0x00, 0x00, 0x00,
        0x89, 0x00, 0x00, 0x00, 0x8d, 0x00, 0x00, 0x00, 0x94, 0x00, 0x00, 0x00, 0x9c, 0x00, 0x00, 0x00, 0xa0, 0x00,
        0x00, 0x00, 0xa5, 0x00, 0x00, 0x00, 0xac, 0x00, 0x00, 0x00, 0xb1, 0x00, 0x00, 0x00, 0xb6, 0x00, 0x00, 0x00,
        0xba, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0xc6, 0x00, 0x00, 0x00, 0x61, 0x6d, 0x61, 0x72, 0x69, 0x6c,
        0x6c, 0x6f, 0x00, 0x61, 0x70, 0x61, 0x67, 0x61, 0x00, 0x61, 0x72, 0x6d, 0x61, 0x72, 0x69, 0x6f, 0x00, 0x61,
        0x7a, 0x75, 0x6c, 0x00, 0x61, 0x00, 0x62, 0x61, 0xc3, 0xb1, 0x6f, 0x00, 0x62, 0x6c, 0x61, 0x6e, 0x63, 0x6f,
        0x00, 0x63, 0x61, 0x6d, 0x62, 0x69, 0x61, 0x00, 0x63, 0x6f, 0x63, 0x69, 0x6e, 0x61, 0x00, 0x64, 0x65, 0x20,
        0x6c, 0x61, 0x00, 0x64, 0x65, 0x6c, 0x00, 0x64, 0x65, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x00, 0x64, 0x6f,
        0x72, 0x6d, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6f, 0x00, 0x65, 0x6e, 0x20, 0x65, 0x6c, 0x00, 0x65, 0x6e, 0x20,
        0x6c, 0x61, 0x00, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x6e, 0x64, 0x61, 0x00, 0x68, 0x61, 0x62, 0x69, 0x74, 0x61,
        0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x00, 0x68, 0x61, 0x7a, 0x00, 0x6c, 0x61, 0x73, 0x00, 0x6c, 0x61, 0x00, 0x6c,
        0x75, 0x63, 0x65, 0x73, 0x00, 0x6c, 0x75, 0x7a, 0x00, 0x6d, 0x6f, 0x72, 0x61, 0x64, 0x6f, 0x00, 0x70, 0x61,
        0x73, 0x69, 0x6c, 0x6c, 0x6f, 0x00, 0x71, 0x75, 0x65, 0x00, 0x72, 0x6f, 0x6a, 0x6f, 0x00, 0x72, 0x6f, 0x73,
        0x61, 0x64, 0x6f, 0x00, 0x73, 0x61, 0x6c, 0x61, 0x00, 0x73, 0x65, 0x61, 0x6e, 0x00, 0x73, 0x65, 0x61, 0x00,
        0x74, 0x6f, 0x64, 0x61, 0x73, 0x00, 0x76, 0x65, 0x72, 0x64, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x05, 0x00,
        0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x0e, 0x00,
        0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
        0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x17, 0x00,
        0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00,
        0x1c, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x20, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00,
        0x17, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x28, 0x00,
        0x00, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00,
        0x47, 0x00, 0x00, 0x00, 0x4b, 0x00, 0x00, 0x00, 0x4f, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x60, 0x00,
        0x00, 0x00, 0x62, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00,
        0x6f, 0x00, 0x00, 0x00, 0x75, 0x00, 0x00, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x7d, 0x00, 0x00, 0x00, 0x81, 0x00,
        0x00, 0x00, 0x87, 0x00, 0x00, 0x00, 0x8b, 0x00, 0x00, 0x00, 0x8f, 0x00, 0x00, 0x00, 0x92, 0x00, 0x00, 0x00,
        0x97, 0x00, 0x00, 0x00, 0x9c, 0x00, 0x00, 0x00, 0x01, 0x0b, 0x01, 0x1b, 0x07, 0x1c, 0x0d, 0x01, 0x0e, 0x01,
        0x18, 0x01, 0x01, 0x1b, 0x0b, 0x01, 0x1b, 0x08, 0x0d, 0x01, 0x20, 0x12, 0x0a, 0x01, 0x02, 0x01, 0x1a, 0x0d,
        0x02, 0x0a, 0x01, 0x17, 0x09, 0x0d, 0x09, 0x01, 0x0b, 0x02, 0x08, 0x01, 0x09, 0x0d, 0x20, 0x07, 0x0c, 0x01,
        0x03, 0x04, 0x0a, 0x01, 0x03, 0x04, 0x0a, 0x03, 0x04, 0x10, 0x0e, 0x04, 0x0c, 0x10, 0x01, 0x03, 0x0d, 0x1b,
        0x0b, 0x07, 0x11, 0x0d, 0x1b, 0x08, 0x0d, 0x04, 0x0c, 0x04, 0x0a, 0x04, 0x0c, 0x0a, 0x01, 0x04, 0x0c, 0x20,
        0x08, 0x04, 0x0c, 0x03, 0x01, 0x01, 0x1f, 0x07, 0x11, 0x01, 0x20, 0x08, 0x0d, 0x0c, 0x01, 0x20, 0x0a, 0x01,
        0x10, 0x0a, 0x01, 0x0a, 0x12, 0x20, 0x04, 0x10, 0x0a, 0x12, 0x20, 0x0b, 0x0d, 0x1b, 0x01, 0x16, 0x0d, 0x0e,
        0x01, 0x10, 0x07, 0x1c, 0x0d, 0x09, 0x04, 0x0f, 0x0d, 0x14, 0x0d, 0x0f, 0x0d, 0x10, 0x01, 0x16, 0x0d, 0x10,
        0x01, 0x0a, 0x01, 0x10, 0x04, 0x01, 0x0c, 0x10, 0x04, 0x01, 0x11, 0x0d, 0x16, 0x01, 0x10, 0x02, 0x04, 0x1b,
        0x16, 0x04, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
        0x11, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x15, 0x00,
        0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00,
        0x1d, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0x16, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
        0x10, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x07, 0x00,
        0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
        0x1c, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x0d, 0x00,
        0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
        0x15, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
        0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
        0x19, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1d, 0x00,
        0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00,
        0x22, 0x00, 0x00, 0x00, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x00, 0x6c,
        0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x16, 0x00,
        0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00,
        0x1b, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00,
        0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x61, 0x63, 0x74, 0x69,
        0x6f, 0x6e, 0x00, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x00, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
        0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x00, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4c, 0x69, 0x67, 0x68, 0x74, 0x53,
        0x74, 0x61, 0x74, 0x65, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00,
        0xd0, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x03, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x0c, 0x01, 0x00, 0x00, 0x30, 0x00,
        0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00,
        0x4c, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x74, 0x00,
        0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0x88, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0xac, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0xac, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0xd4, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xe8, 0x00, 0x00, 0x00, 0xd4, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0xe8, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x0c, 0x01, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x34, 0x01, 0x00, 0x00, 0x20, 0x01, 0x00, 0x00,
        0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x48, 0x01, 0x00, 0x00, 0x34, 0x01,
        0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x5c, 0x01, 0x00, 0x00,
        0x48, 0x01, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x70, 0x01,
        0x00, 0x00, 0x5c, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x9c, 0x01,
        0x00, 0x00, 0xe8, 0x01, 0x00, 0x00, 0x5c, 0x02, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xb0, 0x01, 0x00, 0x00, 0x9c, 0x01, 0x00, 0x00, 0x07, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xc4, 0x01, 0x00, 0x00, 0xb0, 0x01, 0x00, 0x00,
        0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xd8, 0x01, 0x00, 0x00, 0xc4, 0x01,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00,
        0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xfc, 0x01, 0x00, 0x00, 0xe8, 0x01,
        0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x10, 0x02, 0x00, 0x00,
        0xfc, 0x01, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x24, 0x02,
        0x00, 0x00, 0x10, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0x38, 0x02, 0x00, 0x00, 0x24, 0x02, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x4c, 0x02, 0x00, 0x00, 0x38, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x70, 0x02, 0x00, 0x00, 0x5c, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0x84, 0x02, 0x00, 0x00, 0x70, 0x02, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x98, 0x02, 0x00, 0x00, 0x84, 0x02, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xac, 0x02, 0x00, 0x00, 0x98, 0x02, 0x00, 0x00, 0x0b, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x02, 0x00, 0x00, 0xac, 0x02, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x04, 0x00, 0x00, 0x00, 0xf0, 0x02, 0x00, 0x00, 0x28, 0x03, 0x00, 0x00,
        0x4c, 0x03, 0x00, 0x00, 0x98, 0x03, 0x00, 0x00, 0xd0, 0x02, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x00, 0xf0, 0x02, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x18, 0x03, 0x00, 0x00, 0x04, 0x03, 0x00, 0x00, 0x07, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0x02, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x3c, 0x03, 0x00, 0x00, 0x28, 0x03, 0x00, 0x00, 0x07, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0x02, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x60, 0x03, 0x00, 0x00, 0x4c, 0x03, 0x00, 0x00, 0x0d, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x74, 0x03, 0x00, 0x00, 0x60, 0x03, 0x00, 0x00,
        0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x88, 0x03, 0x00, 0x00, 0x74, 0x03,
        0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0x02, 0x00, 0x00,
        0x0d, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xac, 0x03, 0x00, 0x00, 0x98, 0x03,
        0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00,
        0xac, 0x03, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00
};


#endif // PV_PARAMS_H

