
/*
    Copyright 2025 Picovoice Inc.

    You may not use this file except in compliance with the license. A copy of the license is located in the "LICENSE"
    file accompanying this source.

    Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
    an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
    specific language governing permissions and limitations under the License.
*/

#ifndef PV_PARAMS_H
#define PV_PARAMS_H

#include <stdint.h>

// wake-word = picovoice 
static const uint8_t KEYWORD_ARRAY[] = {
        0x5b, 0x64, 0xf5, 0x3c, 0x3f, 0x2e, 0xe3, 0x1f, 0xd5, 0xe4, 0x98, 0x80, 0xa7, 0x9c, 0xaf, 0xad, 0xf7, 0x45,
        0xda, 0x47, 0x80, 0xc1, 0x10, 0x8b, 0x4b, 0x58, 0xd3, 0x09, 0x48, 0x91, 0x40, 0x7c, 0x59, 0xe2, 0x89, 0x47,
        0xfe, 0x24, 0x2e, 0xb5, 0xf1, 0x74, 0x39, 0x64, 0x81, 0xe2, 0xea, 0x66, 0xa7, 0xc5, 0x63, 0x98, 0x82, 0xe4,
        0xac, 0x05, 0xc5, 0x6c, 0x04, 0x30, 0x72, 0xea, 0xda, 0x67, 0xf2, 0xc0, 0x46, 0x4e, 0xd5, 0x10, 0xec, 0xcd,
        0x5d, 0x1e, 0xd2, 0x0f, 0xdc, 0x64, 0x97, 0xeb, 0x01, 0x3e, 0x7a, 0x9f, 0xf7, 0xed, 0x15, 0x4b, 0x67, 0x06,
        0xed, 0x8a, 0x74, 0xde, 0xb6, 0x54, 0x30, 0x2f, 0x44, 0x04, 0xac, 0x3e, 0x0c, 0x4a, 0x11, 0xd6, 0x95, 0x37,
        0xce, 0x43, 0xe1, 0xc7, 0xdb, 0xaa, 0xef, 0x48, 0x3a, 0x79, 0xa2, 0xb8, 0x24, 0x54, 0x1f, 0xe2, 0x8e, 0x8c,
        0x58, 0xaf, 0xaf, 0x73, 0x55, 0x53, 0x7a, 0x35, 0x57, 0x2f, 0x4d, 0xbe, 0x09, 0xad, 0xae, 0x13, 0x38, 0x78,
        0x56, 0xc1, 0xd4, 0xe6, 0x7d, 0x7b, 0xc4, 0x79, 0x4c, 0x60, 0x40, 0x0f, 0x96, 0x52, 0x26, 0xa5, 0xe6, 0x59,
        0x6d, 0x55, 0x68, 0x4e, 0x41, 0x5f, 0xfc, 0x97, 0x95, 0x2b, 0x4d, 0x3c, 0x85, 0xbe, 0xc0, 0x37, 0x3b, 0x3c,
        0x48, 0xdd, 0xf6, 0x06, 0x5f, 0x89, 0xd7, 0x12, 0x8a, 0xe4, 0xa7, 0x7f, 0x23, 0x92, 0x03, 0xb0, 0x78, 0xed,
        0x88, 0x9f, 0x8f, 0xaa, 0x0e, 0xb5, 0x2a, 0xce, 0x6a, 0x62, 0x37, 0xf2, 0x82, 0x54, 0xac, 0xd0, 0x56, 0xb9,
        0x7c, 0x45, 0x1d, 0xee, 0xe0, 0x97, 0x95, 0xe8, 0x34, 0x1d, 0xb8, 0x7d, 0x46, 0x08, 0xea, 0x44, 0x92, 0x9c,
        0xb1, 0x3a, 0x5a, 0xb0, 0x74, 0x52, 0xf1, 0x32, 0x5e, 0xa6, 0x4a, 0x37, 0x5e, 0x9c, 0xa4, 0xa2, 0xa6, 0x86,
        0x31, 0x84, 0x5e, 0xe2, 0x8d, 0xec, 0x90, 0xb2, 0x6f, 0x19, 0x9a, 0xaa, 0xe7, 0xed, 0x08, 0x72, 0xc2, 0xff,
        0x4e, 0x38, 0xdb, 0x5a, 0x6d, 0x46, 0xcb, 0x69, 0x9d, 0xbe, 0x99, 0x7b, 0xee, 0xae, 0xf0, 0x19, 0x32, 0x7a,
        0x6e, 0xbe, 0x98, 0xb7, 0xde, 0x6b, 0xa5, 0x51, 0x3b, 0x30, 0x8e, 0x97, 0x4c, 0xac, 0xd5, 0x08, 0xd1, 0x26,
        0x19, 0x0d, 0xa2, 0x22, 0x8e, 0x86, 0xe9, 0x4b, 0xdb, 0x43, 0xb9, 0x4d, 0x2c, 0x60, 0x2b, 0x36, 0x3e, 0xa8,
        0x9f, 0x0b, 0xe3, 0x59, 0xee, 0x7f, 0x3d, 0x6f, 0xc0, 0xec, 0xad, 0xd2, 0x5b, 0x43, 0x9b, 0x2d, 0x13, 0xd1,
        0x17, 0x89, 0xa0, 0x27, 0x32, 0x14, 0x2d, 0x97, 0x4b, 0x88, 0xf2, 0xe0, 0x0c, 0xf1, 0x8f, 0xc1, 0x4b, 0x11,
        0x1f, 0xe2, 0xb1, 0xf0, 0x1d, 0x18, 0xf4, 0xee, 0xf3, 0xc5, 0xcd, 0x07, 0x86, 0xc2, 0x08, 0xdb, 0x01, 0xd9,
        0xdd, 0xf5, 0x7a, 0x95, 0xff, 0x1e, 0xa2, 0xdf, 0x67, 0x94, 0x3b, 0x09, 0x07, 0x30, 0xbd, 0x9c, 0x5d, 0xd6,
        0x4b, 0x1b, 0xb4, 0x66, 0x45, 0x4b, 0xcf, 0xd4, 0xe0, 0x22, 0xbd, 0xc5, 0x97, 0x27, 0x3e, 0x36, 0x3a, 0xb2,
        0xfd, 0xbb, 0x0f, 0x63, 0x41, 0xc1, 0xc9, 0x1e, 0xff, 0x6c, 0x2e, 0xf6, 0xee, 0x9e, 0xb9, 0x23, 0x89, 0xaf,
        0x74, 0xf4, 0xbe, 0xf4, 0x60, 0x00, 0x89, 0xb6, 0x7e, 0xd2, 0x97, 0x27, 0x8f, 0x37, 0x52, 0x68, 0xad, 0xd9,
        0x2f, 0x99, 0xc9, 0xc1, 0x00, 0xf4, 0xd4, 0x4d, 0x64, 0x58, 0xa5, 0x4b, 0x8e, 0xfd, 0xcb, 0xe4, 0xe5, 0xa8,
        0x19, 0x7c, 0xdc, 0x59, 0x5a, 0x35, 0xb6, 0xe7, 0x4e, 0x15, 0xd7, 0xd3, 0xdb, 0xd7, 0x5f, 0x1e, 0xd4, 0xe7,
        0x2e, 0x37, 0x96, 0xcd, 0xa6, 0xce, 0x39, 0x98, 0x71, 0xb8, 0x38, 0x1c, 0xc9, 0xe6, 0x3c, 0x6b, 0x54, 0x60,
        0x65, 0xaa, 0x7d, 0xf8, 0x85, 0x40, 0xa2, 0x89, 0x6d, 0xe4, 0x17, 0x5f, 0x71, 0x04, 0x22, 0xec, 0xaf, 0xf2,
        0xb5, 0x51, 0x77, 0xbb, 0x94, 0xc5, 0x26, 0xa8, 0xd3, 0xd9, 0x77, 0xd7, 0xbb, 0x69, 0x09, 0x93, 0x1c, 0x7a,
        0x30, 0x42, 0x4d, 0x54, 0x54, 0x40, 0xb6, 0x3b, 0xc2, 0x6a, 0x86, 0x80, 0x7b, 0xbe, 0x21, 0xcb, 0x75, 0x43,
        0x40, 0xca, 0xf2, 0x78, 0x75, 0x74, 0x64, 0x78, 0x03, 0xff, 0xf2, 0x6b, 0x42, 0xab, 0x2a, 0x97, 0x0d, 0xcc,
        0xec, 0x05, 0xf1, 0x52, 0x0e, 0xad, 0xc4, 0x35, 0xe8, 0xc4, 0xed, 0xcf, 0x65, 0x11, 0x0f, 0x61, 0x60, 0xe5,
        0x79, 0x05, 0x26, 0x67, 0x34, 0xa0, 0xc6, 0x4d, 0x83, 0x5e, 0x24, 0x54, 0x0a, 0x74, 0xa4, 0x65, 0xe1, 0xf3,
        0x1c, 0x51, 0x8c, 0x3f, 0xec, 0x97, 0x59, 0x47, 0x4b, 0x4a, 0x80, 0x28, 0x33, 0xf0, 0x6b, 0x9c, 0x30, 0x37,
        0x8d, 0x9b, 0x36, 0xdb, 0xe3, 0x92, 0x6f, 0xe7, 0x20, 0x7f, 0xe3, 0x74, 0x4d, 0x60, 0x81, 0xc1, 0xd4, 0x72,
        0x0c, 0x1e, 0x20, 0xbf, 0xef, 0x32, 0x9d, 0x59, 0xdc, 0x00, 0x0d, 0x58, 0xe1, 0x0f, 0xdb, 0x7c, 0xda, 0x24,
        0xc3, 0x6b, 0xcd, 0xf2, 0xa5, 0xb8, 0xe6, 0xe7, 0x5d, 0x1c, 0xab, 0x10, 0x63, 0x39, 0xb2, 0x76, 0xb4, 0x08,
        0xef, 0xb1, 0xed, 0x1f, 0xd1, 0xa1, 0x68, 0xe8, 0x94, 0x47, 0xc7, 0xd5, 0x8a, 0x27, 0xcf, 0xaa, 0xe6, 0x18,
        0x06, 0x53, 0xc2, 0x69, 0x1d, 0x0c, 0x75, 0x5b, 0x50, 0x56, 0x98, 0x7f, 0x54, 0x3e, 0x51, 0xba, 0x98, 0x93,
        0xdd, 0x2c, 0x0c, 0x62, 0xea, 0x32, 0xab, 0xc7, 0x25, 0x74, 0x9a, 0x68, 0x0f, 0x00, 0xb6, 0xe8, 0x89, 0x75,
        0xf7, 0x60, 0xfe, 0xe3, 0x97, 0xac, 0x62, 0xe0, 0x59, 0xdf, 0x2c, 0x8d, 0x28, 0x7c, 0xc3, 0x65, 0xa4, 0xad,
        0xbd, 0x78, 0x60, 0xcf, 0xbe, 0x5a, 0x26, 0xd8, 0x0a, 0xb1, 0x68, 0xf5, 0xea, 0xf6, 0x8f, 0xa9, 0x83, 0x95,
        0xda, 0x2b, 0xc5, 0x3a, 0x72, 0xd6, 0x5b, 0xbc, 0xc2, 0xbc, 0x26, 0xa5, 0x60, 0x8a, 0xb7, 0xab, 0xe6, 0xea,
        0x59, 0x67, 0x45, 0xaf, 0x2b, 0x4d, 0xf2, 0x0e, 0xbd, 0xa9, 0xc4, 0xa6, 0x21, 0x0e, 0x88, 0x86, 0x86, 0xc8,
        0x01, 0x2e, 0x50, 0xe2, 0x3f, 0xa2, 0x2d, 0x43, 0xa4, 0xb6, 0xa8, 0x83, 0x26, 0x51, 0xf8, 0x88, 0xf2, 0xd5,
        0xa7, 0x5b, 0x08, 0xa0, 0x64, 0x4e, 0xb6, 0x3d, 0x81, 0xa8, 0x8f, 0x92, 0x6d, 0x97, 0xbd, 0xe5, 0x7c, 0xea,
        0x4a, 0xde, 0xbe, 0xdf, 0x81, 0x8c, 0xac, 0xea, 0x6b, 0x9d, 0xd0, 0xa7, 0xa4, 0x11, 0x19, 0xaf, 0xe1, 0xa8,
        0xad, 0x4b, 0xd3, 0x83, 0x33, 0x15, 0x2d, 0x76, 0x0f, 0x41, 0xca, 0xb7, 0x67, 0x98, 0x43, 0x85, 0x2d, 0x97,
        0x11, 0x88, 0x1e, 0xad, 0xcb, 0x6b, 0xa5, 0x61, 0x37, 0x1b, 0xc1, 0x8a, 0x83, 0x78, 0x13, 0x5b, 0x20, 0xf0,
        0xbc, 0xff, 0x40, 0xef, 0xd8, 0x94, 0xec, 0x1a, 0x10, 0xd5, 0xa0, 0x0c, 0xf3, 0x50, 0x97, 0x10, 0x02, 0x2b,
        0xa8, 0x07, 0x10, 0x57, 0x87, 0xaf, 0x80, 0x64, 0xa8, 0x28, 0x18, 0xb2, 0x6d, 0x3f, 0xe0, 0x89, 0x9c, 0x01,
        0xeb, 0xbb, 0x13, 0x8a, 0x49, 0x59, 0x32, 0x31, 0xf2, 0xa1, 0xea, 0x61, 0xd9, 0x82, 0xc5, 0x30, 0xe4, 0x63,
        0xec, 0x06
};

// context = smart_lighting 
static const uint8_t CONTEXT_ARRAY[] = {
        0x72, 0x68, 0x69, 0x6e, 0x6f, 0x34, 0x2e, 0x30, 0x2e, 0x30, 0x00, 0x00, 0x00, 0x00, 0x65, 0x6e, 0x00, 0x09,
        0x00, 0x00, 0x00, 0x70, 0x69, 0x63, 0x6f, 0x76, 0x6f, 0x69, 0x63, 0x65, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x98, 0x1b, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x63, 0x6f,
        0x6e, 0x74, 0x65, 0x78, 0x74, 0x3a, 0x0a, 0x20, 0x20, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
        0x6e, 0x73, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x43, 0x6f, 0x6c, 0x6f,
        0x72, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x74, 0x75, 0x72, 0x6e, 0x2c,
        0x20, 0x6d, 0x61, 0x6b, 0x65, 0x5d, 0x20, 0x28, 0x61, 0x6c, 0x6c, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x29, 0x20,
        0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x63, 0x6f, 0x6c, 0x6f,
        0x72, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x63, 0x68, 0x61, 0x6e, 0x67,
        0x65, 0x2c, 0x20, 0x73, 0x65, 0x74, 0x2c, 0x20, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x5d, 0x20, 0x28, 0x61,
        0x6c, 0x6c, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x29, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x20, 0x74, 0x6f,
        0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x22, 0x0a, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x74, 0x75, 0x72, 0x6e, 0x2c, 0x20, 0x6d, 0x61, 0x6b, 0x65, 0x5d,
        0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c,
        0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x28, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2c, 0x20, 0x6c, 0x69,
        0x67, 0x68, 0x74, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x29, 0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f,
        0x72, 0x3a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22,
        0x5b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2c, 0x20, 0x73, 0x65, 0x74, 0x2c, 0x20, 0x73, 0x77, 0x69, 0x74,
        0x63, 0x68, 0x5d, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
        0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x28, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2c,
        0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x29, 0x20, 0x74, 0x6f,
        0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x22, 0x0a, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x74, 0x75, 0x72, 0x6e, 0x2c, 0x20, 0x6d, 0x61, 0x6b, 0x65, 0x5d,
        0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x5b, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2c, 0x20, 0x6c, 0x69, 0x67,
        0x68, 0x74, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5d, 0x20, 0x5b, 0x61, 0x74, 0x2c, 0x20, 0x69,
        0x6e, 0x5d, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
        0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x63,
        0x6f, 0x6c, 0x6f, 0x72, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x63, 0x68,
        0x61, 0x6e, 0x67, 0x65, 0x2c, 0x20, 0x73, 0x65, 0x74, 0x2c, 0x20, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x5d,
        0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x5b, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2c, 0x20, 0x6c, 0x69, 0x67,
        0x68, 0x74, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5d, 0x20, 0x5b, 0x61, 0x74, 0x2c, 0x20, 0x69,
        0x6e, 0x5d, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
        0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f,
        0x72, 0x3a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22,
        0x5b, 0x74, 0x75, 0x72, 0x6e, 0x2c, 0x20, 0x6d, 0x61, 0x6b, 0x65, 0x5d, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29,
        0x20, 0x5b, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2c, 0x20, 0x6c, 0x69,
        0x67, 0x68, 0x74, 0x73, 0x5d, 0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x63, 0x6f, 0x6c, 0x6f, 0x72,
        0x20, 0x5b, 0x61, 0x74, 0x2c, 0x20, 0x69, 0x6e, 0x5d, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x24, 0x6c,
        0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x0a,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2c, 0x20,
        0x73, 0x65, 0x74, 0x2c, 0x20, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x5d, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29,
        0x20, 0x5b, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2c, 0x20, 0x6c, 0x69,
        0x67, 0x68, 0x74, 0x73, 0x5d, 0x20, 0x74, 0x6f, 0x20, 0x24, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x63, 0x6f,
        0x6c, 0x6f, 0x72, 0x20, 0x5b, 0x61, 0x74, 0x2c, 0x20, 0x69, 0x6e, 0x5d, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29,
        0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
        0x6e, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x4c, 0x69, 0x67, 0x68, 0x74,
        0x53, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x73,
        0x77, 0x69, 0x74, 0x63, 0x68, 0x2c, 0x20, 0x74, 0x75, 0x72, 0x6e, 0x5d, 0x20, 0x24, 0x73, 0x74, 0x61, 0x74,
        0x65, 0x3a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x20, 0x28, 0x61, 0x6c, 0x6c, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x29,
        0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22,
        0x5b, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2c, 0x20, 0x74, 0x75, 0x72, 0x6e, 0x5d, 0x20, 0x28, 0x61, 0x6c,
        0x6c, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x29, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x20, 0x24, 0x73, 0x74,
        0x61, 0x74, 0x65, 0x3a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d,
        0x20, 0x22, 0x5b, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2c, 0x20, 0x74, 0x75, 0x72, 0x6e, 0x5d, 0x20, 0x24,
        0x73, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20,
        0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
        0x20, 0x28, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x29, 0x22, 0x0a,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2c, 0x20,
        0x74, 0x75, 0x72, 0x6e, 0x5d, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74,
        0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x5b, 0x6c, 0x69, 0x67, 0x68,
        0x74, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5d, 0x20, 0x24, 0x73, 0x74, 0x61, 0x74, 0x65, 0x3a,
        0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x5b, 0x73,
        0x77, 0x69, 0x74, 0x63, 0x68, 0x2c, 0x20, 0x74, 0x75, 0x72, 0x6e, 0x5d, 0x20, 0x24, 0x73, 0x74, 0x61, 0x74,
        0x65, 0x3a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x5b, 0x6c, 0x69, 0x67,
        0x68, 0x74, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5d, 0x20, 0x5b, 0x61, 0x74, 0x2c, 0x20, 0x69,
        0x6e, 0x5d, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
        0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d,
        0x20, 0x22, 0x5b, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x2c, 0x20, 0x74, 0x75, 0x72, 0x6e, 0x5d, 0x20, 0x28,
        0x74, 0x68, 0x65, 0x29, 0x20, 0x5b, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74,
        0x73, 0x5d, 0x20, 0x5b, 0x69, 0x6e, 0x2c, 0x20, 0x61, 0x74, 0x5d, 0x20, 0x74, 0x68, 0x65, 0x20, 0x24, 0x6c,
        0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x24,
        0x73, 0x74, 0x61, 0x74, 0x65, 0x3a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x63,
        0x68, 0x61, 0x6e, 0x67, 0x65, 0x4c, 0x69, 0x67, 0x68, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66,
        0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x73, 0x68, 0x75, 0x74, 0x20, 0x6f, 0x66,
        0x66, 0x20, 0x28, 0x61, 0x6c, 0x6c, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x29, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74,
        0x73, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x73, 0x68, 0x75, 0x74, 0x20, 0x28,
        0x61, 0x6c, 0x6c, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x29, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x20, 0x6f,
        0x66, 0x66, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x73, 0x68, 0x75, 0x74, 0x20,
        0x6f, 0x66, 0x66, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
        0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x28, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2c,
        0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x29, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20,
        0x22, 0x73, 0x68, 0x75, 0x74, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74,
        0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x28, 0x6c, 0x69, 0x67, 0x68,
        0x74, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x29, 0x20, 0x6f, 0x66, 0x66, 0x22, 0x0a, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x73, 0x68, 0x75, 0x74, 0x20, 0x6f, 0x66, 0x66, 0x20, 0x28, 0x74,
        0x68, 0x65, 0x29, 0x20, 0x5b, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73,
        0x5d, 0x20, 0x5b, 0x61, 0x74, 0x2c, 0x20, 0x69, 0x6e, 0x5d, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x24,
        0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
        0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x73, 0x68, 0x75, 0x74, 0x20, 0x28, 0x74, 0x68,
        0x65, 0x29, 0x20, 0x5b, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5d,
        0x20, 0x6f, 0x66, 0x66, 0x20, 0x5b, 0x61, 0x74, 0x2c, 0x20, 0x69, 0x6e, 0x5d, 0x20, 0x28, 0x74, 0x68, 0x65,
        0x29, 0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
        0x6f, 0x6e, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x73, 0x68, 0x75, 0x74, 0x20,
        0x28, 0x74, 0x68, 0x65, 0x29, 0x20, 0x5b, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x2c, 0x20, 0x6c, 0x69, 0x67, 0x68,
        0x74, 0x73, 0x5d, 0x20, 0x5b, 0x61, 0x74, 0x2c, 0x20, 0x69, 0x6e, 0x5d, 0x20, 0x28, 0x74, 0x68, 0x65, 0x29,
        0x20, 0x24, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
        0x6e, 0x20, 0x6f, 0x66, 0x66, 0x22, 0x0a, 0x20, 0x20, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x3a, 0x0a, 0x20, 0x20,
        0x20, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22,
        0x62, 0x6c, 0x75, 0x65, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x67, 0x72, 0x65,
        0x65, 0x6e, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x6f, 0x72, 0x61, 0x6e, 0x67,
        0x65, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x70, 0x69, 0x6e, 0x6b, 0x22, 0x0a,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x70, 0x75, 0x72, 0x70, 0x6c, 0x65, 0x22, 0x0a, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x72, 0x65, 0x64, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x2d, 0x20, 0x22, 0x77, 0x68, 0x69, 0x74, 0x65, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d,
        0x20, 0x22, 0x79, 0x65, 0x6c, 0x6c, 0x6f, 0x77, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x73, 0x74, 0x61, 0x74,
        0x65, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x6f, 0x66, 0x66, 0x22, 0x0a, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x6f, 0x6e, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x6c, 0x6f,
        0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x62,
        0x61, 0x74, 0x68, 0x72, 0x6f, 0x6f, 0x6d, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22,
        0x62, 0x65, 0x64, 0x72, 0x6f, 0x6f, 0x6d, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22,
        0x63, 0x6c, 0x6f, 0x73, 0x65, 0x74, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x68,
        0x61, 0x6c, 0x6c, 0x77, 0x61, 0x79, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x6b,
        0x69, 0x74, 0x63, 0x68, 0x65, 0x6e, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x22, 0x6c,
        0x69, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x72, 0x6f, 0x6f, 0x6d, 0x22, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x2d, 0x20, 0x22, 0x70, 0x61, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x0a, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
        0x1d, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x2b, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x37, 0x00,
        0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x4a, 0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00,
        0x57, 0x00, 0x00, 0x00, 0x63, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x6f, 0x00,
        0x00, 0x00, 0x76, 0x00, 0x00, 0x00, 0x7d, 0x00, 0x00, 0x00, 0x82, 0x00, 0x00, 0x00, 0x89, 0x00, 0x00, 0x00,
        0x8d, 0x00, 0x00, 0x00, 0x91, 0x00, 0x00, 0x00, 0x96, 0x00, 0x00, 0x00, 0x9d, 0x00, 0x00, 0x00, 0xa1, 0x00,
        0x00, 0x00, 0xa4, 0x00, 0x00, 0x00, 0xa9, 0x00, 0x00, 0x00, 0xaf, 0x00, 0x00, 0x00, 0xb6, 0x00, 0x00, 0x00,
        0x61, 0x6c, 0x6c, 0x00, 0x61, 0x74, 0x00, 0x62, 0x61, 0x74, 0x68, 0x72, 0x6f, 0x6f, 0x6d, 0x00, 0x62, 0x65,
        0x64, 0x72, 0x6f, 0x6f, 0x6d, 0x00, 0x62, 0x6c, 0x75, 0x65, 0x00, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x00,
        0x63, 0x6c, 0x6f, 0x73, 0x65, 0x74, 0x00, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x00, 0x67, 0x72, 0x65, 0x65, 0x6e,
        0x00, 0x68, 0x61, 0x6c, 0x6c, 0x77, 0x61, 0x79, 0x00, 0x69, 0x6e, 0x00, 0x6b, 0x69, 0x74, 0x63, 0x68, 0x65,
        0x6e, 0x00, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x73, 0x00, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x00, 0x6c, 0x69, 0x76,
        0x69, 0x6e, 0x67, 0x20, 0x72, 0x6f, 0x6f, 0x6d, 0x00, 0x6d, 0x61, 0x6b, 0x65, 0x00, 0x6f, 0x66, 0x66, 0x00,
        0x6f, 0x6e, 0x00, 0x6f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x00, 0x70, 0x61, 0x6e, 0x74, 0x72, 0x79, 0x00, 0x70,
        0x69, 0x6e, 0x6b, 0x00, 0x70, 0x75, 0x72, 0x70, 0x6c, 0x65, 0x00, 0x72, 0x65, 0x64, 0x00, 0x73, 0x65, 0x74,
        0x00, 0x73, 0x68, 0x75, 0x74, 0x00, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x00, 0x74, 0x68, 0x65, 0x00, 0x74,
        0x6f, 0x00, 0x74, 0x75, 0x72, 0x6e, 0x00, 0x77, 0x68, 0x69, 0x74, 0x65, 0x00, 0x79, 0x65, 0x6c, 0x6c, 0x6f,
        0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00,
        0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
        0x09, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00,
        0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
        0x12, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x18, 0x00,
        0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
        0x1d, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x23, 0x00, 0x00, 0x00, 0x25, 0x00,
        0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
        0x0a, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x1d, 0x00,
        0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x00, 0x00,
        0x30, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x44, 0x00,
        0x00, 0x00, 0x47, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4b, 0x00, 0x00, 0x00, 0x4d, 0x00, 0x00, 0x00,
        0x52, 0x00, 0x00, 0x00, 0x57, 0x00, 0x00, 0x00, 0x5d, 0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x66, 0x00,
        0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00, 0x73, 0x00, 0x00, 0x00,
        0x75, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x7d, 0x00,
        0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x84, 0x00, 0x00, 0x00, 0x87, 0x00, 0x00, 0x00, 0x8b, 0x00, 0x00, 0x00,
        0x04, 0x15, 0x02, 0x1f, 0x07, 0x02, 0x20, 0x1c, 0x22, 0x16, 0x07, 0x0b, 0x09, 0x1c, 0x22, 0x16, 0x07, 0x15,
        0x22, 0x08, 0x0d, 0x17, 0x13, 0x14, 0x15, 0x01, 0x26, 0x03, 0x1f, 0x14, 0x03, 0x15, 0x0c, 0x14, 0x04, 0x15,
        0x0c, 0x0f, 0x1c, 0x12, 0x17, 0x10, 0x04, 0x15, 0x24, 0x0d, 0x11, 0x17, 0x14, 0x11, 0x08, 0x03, 0x17, 0x15,
        0x06, 0x1f, 0x1d, 0x15, 0x06, 0x1f, 0x15, 0x11, 0x23, 0x11, 0x18, 0x1c, 0x22, 0x16, 0x16, 0x0d, 0x14, 0x04,
        0x0e, 0x01, 0x17, 0x04, 0x17, 0x04, 0x1c, 0x03, 0x17, 0x13, 0x04, 0x1c, 0x11, 0x17, 0x13, 0x1b, 0x02, 0x17,
        0x1f, 0x1c, 0x12, 0x1b, 0x11, 0x18, 0x14, 0x1b, 0x0c, 0x1b, 0x03, 0x15, 0x1c, 0x0b, 0x09, 0x1d, 0x0b, 0x1f,
        0x1e, 0x03, 0x1f, 0x1d, 0x24, 0x11, 0x08, 0x0a, 0x03, 0x0a, 0x12, 0x1f, 0x03, 0x1f, 0x11, 0x1f, 0x22, 0x1f,
        0x0c, 0x17, 0x10, 0x24, 0x06, 0x1f, 0x24, 0x06, 0x1f, 0x25, 0x0b, 0x15, 0x19, 0x00, 0x0f, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x12, 0x00,
        0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00,
        0x18, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x22, 0x00,
        0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
        0x12, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x1d, 0x00,
        0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0x09, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x10, 0x00,
        0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00,
        0x1a, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00,
        0x07, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x0d, 0x00,
        0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x16, 0x00,
        0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00,
        0x1b, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00,
        0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x00, 0x6c, 0x6f,
        0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x73, 0x74, 0x61, 0x74, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0x0f, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x18, 0x00,
        0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00,
        0x1d, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x21, 0x00,
        0x00, 0x00, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x00, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x73,
        0x74, 0x61, 0x74, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00,
        0x31, 0x00, 0x00, 0x00, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x00, 0x63, 0x68,
        0x61, 0x6e, 0x67, 0x65, 0x4c, 0x69, 0x67, 0x68, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x00, 0x63, 0x68, 0x61,
        0x6e, 0x67, 0x65, 0x4c, 0x69, 0x67, 0x68, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x66, 0x66, 0x00, 0x00,
        0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x28, 0x03, 0x00, 0x00, 0x20, 0x07, 0x00, 0x00, 0x64, 0x0a,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x05, 0x00, 0x00, 0x00,
        0x44, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0x3c, 0x02,
        0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0x58, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00,
        0x00, 0x00, 0xb8, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0xd0, 0x00, 0x00, 0x00, 0xf4, 0x00, 0x00, 0x00, 0xb8, 0x00,
        0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xe4, 0x00, 0x00, 0x00,
        0xd0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00,
        0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x1c, 0x01, 0x00, 0x00, 0x90, 0x01,
        0x00, 0x00, 0x04, 0x01, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00,
        0x34, 0x01, 0x00, 0x00, 0x6c, 0x01, 0x00, 0x00, 0x1c, 0x01, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x48, 0x01, 0x00, 0x00, 0x34, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x5c, 0x01, 0x00, 0x00, 0x48, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x6c, 0x01, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xa4, 0x01, 0x00, 0x00, 0x90, 0x01, 0x00, 0x00, 0x09, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0xbc, 0x01, 0x00, 0x00, 0xe0, 0x01, 0x00, 0x00,
        0xa4, 0x01, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xd0, 0x01,
        0x00, 0x00, 0xbc, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0xa4, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x08, 0x02, 0x00, 0x00,
        0x2c, 0x02, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x1c, 0x02, 0x00, 0x00, 0x08, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0xf0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00,
        0x54, 0x02, 0x00, 0x00, 0xc8, 0x02, 0x00, 0x00, 0x3c, 0x02, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x6c, 0x02, 0x00, 0x00, 0xa4, 0x02, 0x00, 0x00, 0x54, 0x02, 0x00, 0x00,
        0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x80, 0x02, 0x00, 0x00, 0x6c, 0x02,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x94, 0x02, 0x00, 0x00,
        0x80, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x02,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xb8, 0x02, 0x00, 0x00,
        0xa4, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x02,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xdc, 0x02, 0x00, 0x00,
        0xc8, 0x02, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0xf4, 0x02,
        0x00, 0x00, 0x18, 0x03, 0x00, 0x00, 0xdc, 0x02, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0x08, 0x03, 0x00, 0x00, 0xf4, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x05, 0x00,
        0x00, 0x00, 0x4c, 0x03, 0x00, 0x00, 0x98, 0x03, 0x00, 0x00, 0xd0, 0x03, 0x00, 0x00, 0x84, 0x05, 0x00, 0x00,
        0xf8, 0x05, 0x00, 0x00, 0x28, 0x03, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x60, 0x03, 0x00, 0x00, 0x4c, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0x74, 0x03, 0x00, 0x00, 0x60, 0x03, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x88, 0x03, 0x00, 0x00, 0x74, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xac, 0x03, 0x00, 0x00, 0x98, 0x03, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0xac, 0x03, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x03, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0xe8, 0x03, 0x00, 0x00, 0x5c, 0x04, 0x00, 0x00, 0xd0, 0x03,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
        0x38, 0x04, 0x00, 0x00, 0xe8, 0x03, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x14, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0x28, 0x04, 0x00, 0x00, 0x14, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe8, 0x03, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0x4c, 0x04, 0x00, 0x00, 0x38, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0x03, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x02, 0x00, 0x00, 0x00, 0x74, 0x04, 0x00, 0x00, 0x10, 0x05, 0x00, 0x00, 0x5c, 0x04, 0x00, 0x00, 0x09, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x8c, 0x04, 0x00, 0x00, 0xd8, 0x04, 0x00, 0x00,
        0x74, 0x04, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xa0, 0x04,
        0x00, 0x00, 0x8c, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0xb4, 0x04, 0x00, 0x00, 0xa0, 0x04, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0xc8, 0x04, 0x00, 0x00, 0xb4, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x74, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0xec, 0x04, 0x00, 0x00, 0xd8, 0x04, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0xec, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x04, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0x24, 0x05, 0x00, 0x00, 0x10, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x38, 0x05, 0x00, 0x00, 0x24, 0x05, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x50, 0x05, 0x00, 0x00, 0x74, 0x05, 0x00, 0x00, 0x38, 0x05,
        0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x64, 0x05, 0x00, 0x00,
        0x50, 0x05, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x05,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x03, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x9c, 0x05, 0x00, 0x00, 0xd4, 0x05,
        0x00, 0x00, 0x84, 0x05, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0xb0, 0x05, 0x00, 0x00, 0x9c, 0x05, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0xc4, 0x05, 0x00, 0x00, 0xb0, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x84, 0x05, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0xe8, 0x05, 0x00, 0x00, 0xd4, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x28, 0x03, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00,
        0x00, 0x00, 0x10, 0x06, 0x00, 0x00, 0xac, 0x06, 0x00, 0x00, 0xf8, 0x05, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x28, 0x06, 0x00, 0x00, 0x74, 0x06, 0x00, 0x00, 0x10, 0x06,
        0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x3c, 0x06, 0x00, 0x00,
        0x28, 0x06, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x50, 0x06,
        0x00, 0x00, 0x3c, 0x06, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0x64, 0x06, 0x00, 0x00, 0x50, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x10, 0x06, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0x88, 0x06, 0x00, 0x00, 0x74, 0x06, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x9c, 0x06, 0x00, 0x00, 0x88, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0xf8, 0x05, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0xc0, 0x06, 0x00, 0x00, 0xac, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0xd4, 0x06, 0x00, 0x00, 0xc0, 0x06, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0xec, 0x06, 0x00, 0x00, 0x10, 0x07, 0x00, 0x00, 0xd4, 0x06, 0x00, 0x00,
        0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0xec, 0x06,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0x06, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00, 0x48, 0x07, 0x00, 0x00, 0xc0, 0x08, 0x00, 0x00,
        0xf8, 0x08, 0x00, 0x00, 0x1c, 0x09, 0x00, 0x00, 0xcc, 0x09, 0x00, 0x00, 0x04, 0x0a, 0x00, 0x00, 0x20, 0x07,
        0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x05, 0x00, 0x00, 0x00, 0x6c, 0x07, 0x00, 0x00,
        0x90, 0x07, 0x00, 0x00, 0xa0, 0x07, 0x00, 0x00, 0x3c, 0x08, 0x00, 0x00, 0x60, 0x08, 0x00, 0x00, 0x48, 0x07,
        0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00,
        0x6c, 0x07, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x07,
        0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x07, 0x00, 0x00,
        0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0xb8, 0x07, 0x00, 0x00, 0xdc, 0x07,
        0x00, 0x00, 0xa0, 0x07, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0xcc, 0x07, 0x00, 0x00, 0xb8, 0x07, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0xa0, 0x07, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0xf0, 0x07, 0x00, 0x00, 0xdc, 0x07, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00,
        0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x2c, 0x08, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x1c, 0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x07, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x50, 0x08, 0x00, 0x00, 0x3c, 0x08, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x07, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x74, 0x08, 0x00, 0x00, 0x60, 0x08, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x8c, 0x08, 0x00, 0x00, 0xb0, 0x08, 0x00, 0x00, 0x74, 0x08,
        0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xa0, 0x08, 0x00, 0x00,
        0x8c, 0x08, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x08,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x07, 0x00, 0x00,
        0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xd4, 0x08, 0x00, 0x00, 0xc0, 0x08,
        0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xe8, 0x08, 0x00, 0x00,
        0xd4, 0x08, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x07,
        0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x0c, 0x09, 0x00, 0x00,
        0xf8, 0x08, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x07,
        0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x34, 0x09, 0x00, 0x00,
        0x6c, 0x09, 0x00, 0x00, 0x1c, 0x09, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x48, 0x09, 0x00, 0x00, 0x34, 0x09, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0x5c, 0x09, 0x00, 0x00, 0x48, 0x09, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x09, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0x80, 0x09, 0x00, 0x00, 0x6c, 0x09, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0xff, 0xff,
        0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x94, 0x09, 0x00, 0x00, 0x80, 0x09, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xa8, 0x09, 0x00, 0x00, 0x94, 0x09, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xbc, 0x09, 0x00, 0x00, 0xa8, 0x09, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x07, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xe0, 0x09, 0x00, 0x00, 0xcc, 0x09, 0x00, 0x00,
        0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xf4, 0x09, 0x00, 0x00, 0xe0, 0x09,
        0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x07, 0x00, 0x00,
        0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x18, 0x0a, 0x00, 0x00, 0x04, 0x0a,
        0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x2c, 0x0a, 0x00, 0x00,
        0x18, 0x0a, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x40, 0x0a,
        0x00, 0x00, 0x2c, 0x0a, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
        0x54, 0x0a, 0x00, 0x00, 0x40, 0x0a, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x06, 0x00, 0x00, 0x00,
        0x8c, 0x0a, 0x00, 0x00, 0x04, 0x0c, 0x00, 0x00, 0x3c, 0x0c, 0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 0xb0, 0x0d,
        0x00, 0x00, 0xfc, 0x0d, 0x00, 0x00, 0x64, 0x0a, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x05, 0x00, 0x00, 0x00, 0xb0, 0x0a, 0x00, 0x00, 0xd4, 0x0a, 0x00, 0x00, 0xe4, 0x0a, 0x00, 0x00, 0x80, 0x0b,
        0x00, 0x00, 0xa4, 0x0b, 0x00, 0x00, 0x8c, 0x0a, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0xc4, 0x0a, 0x00, 0x00, 0xb0, 0x0a, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x0a, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x8c, 0x0a, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00,
        0x00, 0x00, 0xfc, 0x0a, 0x00, 0x00, 0x20, 0x0b, 0x00, 0x00, 0xe4, 0x0a, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x0b, 0x00, 0x00, 0xfc, 0x0a, 0x00, 0x00, 0x0c, 0x00,
        0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0x0a, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x34, 0x0b, 0x00, 0x00, 0x20, 0x0b, 0x00, 0x00, 0x09, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x4c, 0x0b, 0x00, 0x00, 0x70, 0x0b, 0x00, 0x00,
        0x34, 0x0b, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x60, 0x0b,
        0x00, 0x00, 0x4c, 0x0b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x34, 0x0b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x0a,
        0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x94, 0x0b, 0x00, 0x00,
        0x80, 0x0b, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x0a,
        0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xb8, 0x0b, 0x00, 0x00,
        0xa4, 0x0b, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0xd0, 0x0b,
        0x00, 0x00, 0xf4, 0x0b, 0x00, 0x00, 0xb8, 0x0b, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0xe4, 0x0b, 0x00, 0x00, 0xd0, 0x0b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0x0b, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x64, 0x0a, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0x18, 0x0c, 0x00, 0x00, 0x04, 0x0c, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0x2c, 0x0c, 0x00, 0x00, 0x18, 0x0c, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0a, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0x50, 0x0c, 0x00, 0x00, 0x3c, 0x0c, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0a, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x02, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x00, 0x00, 0xc4, 0x0c, 0x00, 0x00, 0x60, 0x0c, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x90, 0x0c, 0x00, 0x00, 0xb4, 0x0c, 0x00, 0x00,
        0x78, 0x0c, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xa4, 0x0c,
        0x00, 0x00, 0x90, 0x0c, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x78, 0x0c, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x0c,
        0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0xdc, 0x0c, 0x00, 0x00,
        0x3c, 0x0d, 0x00, 0x00, 0xc4, 0x0c, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0xf0, 0x0c, 0x00, 0x00, 0xdc, 0x0c, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x02, 0x00, 0x00, 0x00, 0x08, 0x0d, 0x00, 0x00, 0x2c, 0x0d, 0x00, 0x00, 0xf0, 0x0c, 0x00, 0x00, 0x06, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x1c, 0x0d, 0x00, 0x00, 0x08, 0x0d, 0x00, 0x00,
        0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x0c, 0x00, 0x00, 0x01, 0x00,
        0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0x0c, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x54, 0x0d, 0x00, 0x00, 0x8c, 0x0d, 0x00, 0x00, 0x3c, 0x0d,
        0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x68, 0x0d, 0x00, 0x00,
        0x54, 0x0d, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x7c, 0x0d,
        0x00, 0x00, 0x68, 0x0d, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x3c, 0x0d, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0xa0, 0x0d,
        0x00, 0x00, 0x8c, 0x0d, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x64, 0x0a, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0xc8, 0x0d,
        0x00, 0x00, 0xec, 0x0d, 0x00, 0x00, 0xb0, 0x0d, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0xdc, 0x0d, 0x00, 0x00, 0xc8, 0x0d, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0x0d, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x64, 0x0a, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00,
        0x00, 0x00, 0x14, 0x0e, 0x00, 0x00, 0x74, 0x0e, 0x00, 0x00, 0xfc, 0x0d, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
        0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x28, 0x0e, 0x00, 0x00, 0x14, 0x0e, 0x00, 0x00, 0x09, 0x00,
        0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x40, 0x0e, 0x00, 0x00, 0x64, 0x0e, 0x00, 0x00,
        0x28, 0x0e, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x54, 0x0e,
        0x00, 0x00, 0x40, 0x0e, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x28, 0x0e, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x0d,
        0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x00, 0x00, 0x00, 0x8c, 0x0e, 0x00, 0x00,
        0xc4, 0x0e, 0x00, 0x00, 0x74, 0x0e, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00,
        0x00, 0x00, 0xa0, 0x0e, 0x00, 0x00, 0x8c, 0x0e, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0xb4, 0x0e, 0x00, 0x00, 0xa0, 0x0e, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x0e, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
        0x01, 0x00, 0x00, 0x00, 0xd8, 0x0e, 0x00, 0x00, 0xc4, 0x0e, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


#endif // PV_PARAMS_H

