# Pervasive Displays Library Suite - Driver for screens with wide temperature and embedded fast update

The driver is specifically designed for the [Pervasive Displays](https://www.pervasivedisplays.com) e-paper screens, extension boards and evaluation kits.

![](https://pdls.pervasivedisplays.com/userguide/img/Logo_PDI_text_320.png)

The **Pervasive_Wide_Medium** supports the screens

* Pervasive Displays iTC monochrome [with wide temperature and embedded fast update](https://www.pervasivedisplays.com/products-e-ink-display/?_sft_etc_itc=pu&_sft_temperature_range=m15c-to-p60c&_sft_product_colour=black-white) (film `K`) with sizes of 3.4", 5.81 and 7.41"; 

the extension board

* Pervasive Displays [EPD Extension Kit Gen 3 (EXT3 or EXT3.1)](https://www.pervasivedisplays.com/product/epd-extension-kit-gen-3-EXT3/);

the development kits

* [EPD Pico Kit (EPDK)](https://www.pervasivedisplays.com/product/epd-pico-kit-epdk/), which includes a Raspberry Pi Pico RP2040, an EXT3-1 extension board and a 2.66" monochrome panel.

## Features

The driver library can be used stand-alone or with the [Pervasive Displays Library Suite](https://pdls.pervasivedisplays.com/userguide/index.html). 

**Note**: This library requires [PDLS Common](https://github.com/PervasiveDisplays/PDLS_Common).

## Documentation

* [ApplicationNote_SingleChip_wideTemperature_EPD_v01_20230720]()
* [Pervasive Displays Technical Wiki](https://docs.pervasivedisplays.com/) 
* [Pervasive Displays, Inc. (龍亭新技股份有限公司)](https://www.pervasivedisplays.com/)
* [Product line](https://www.pervasivedisplays.com/products/)

## Support

* Please refer to the [Support Service](https://www.pervasivedisplays.com/technical-support/).

## Installation

Software

* [Arduino IDE](https://www.arduino.cc/en/software) or [Arduino CLI](https://arduino.github.io/arduino-cli/)
* [Installing Additional Arduino Libraries](https://www.arduino.cc/en/guide/libraries)

    + Using the Library Manager
    + Importing a `.zip` Library

Hardware

* [Connecting the Pervasive Displays e-Paper EPD Extension Kit Gen 3](https://embeddedcomputing.weebly.com/connecting-the-e-paper-epd-extension-kit-gen-3.html)

## Configuration

Software

* Arduino SDK
* SPI library
* Wire library

Hardware

* Pervasive Displays EPD Extension Kit Gen 3 (EXT3 or EXT3.1)
* Pervasive Displays iTC screens wide temperature and embedded fast update (film `K`)

## Licence

**Copyright** &copy; Pervasive Displays, 2010-2025

*For exclusive use with Pervasive Displays screens*

**Licence** [Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)](./LICENCE.md)

**Portions** &copy; Rei Vilo, 2010-2025

