# Brasilino

_Uma **biblioteca** que permite programar em linguagem **Arduino** utilizando comandos facilitados em **PT-BR**._

De acordo com um estudo realizado pela Education First, o EF EPI (EF English Proficiency Index) 6° edição, publicado em Novembro de 2016, o Brasil aparece como **40°** colocado em **nível de proficiência em língua inglesa**, de um estudo realizado com **72 países**, com pontuação de 50,66, o que é considerada como **"Baixa"** pelo estudo. Tal deficiência em língua inglesa acentua-se ainda mais nas classes sociais menos privilegiadas.

Com o baixo índice de proficiência em língua inglesa apresentado pelo Brasil, muitos brasileiros sentem dificuldade em programar, devido ao fato da língua nativa em que os comandos são inscritos ser o inglês, muitas vezes, **não conseguindo associar a palavra _"if"_ ao _"se"_**, criando-se assim uma barreira, que muitas vezes afasta o brasileiro do ambiente de desenvolvimento tecnológico.

Nós do Brasilino acreditamos que **quebrando esta barreira inicial, criamos o incentivo** para que estes brasileros possam **ter o primeiro contato com a plataforma Arduino**, desenvolvendo assim suas próprias soluções, e a partir deste primeiro contato, os mesmos possam **quebrar o paradigma de que programar é difícil**, e quando apenas o idioma for a última barreira, através de uma **migração gradual**, da programação em Brasilino para a programaçao em Arduino, a barreira do idioma possa por fim ser removida.

A brasilino é uma **biblioteca aberta** e conta com a **participação de toda a comunidade**, através das necessidades encontradas pelos usuários, poderemos cada vez mais **criar comandos mais intuitivos e simplificados** de utilizar, promovendo-se assim que a biblioteca facilite cada vez mais a inserção de novos brasileiros.

## Documentação

[1. Como utilizar:](/INSTALACAO.md)

- Instalação através do gerenciador de biblioteca
- Instalação manual (Alternativa)
- Exemplos

[2. Tabela de instruções:](/TABELA_DE_INSTRUCOES.md) <br>

- Estrutura Geral
- Estruturas de Controle
- Tipos de Dados Comuns
- Tipos de Dados Lógicos
- Funções

## A Equipe Brasilino:

|                 **Otacilio Maia**                  |                    **Thiago Augusto**                    |                   **Erick Simoes**                   |             **Rômulo César**              |
| :------------------------------------------------: | :------------------------------------------------------: | :--------------------------------------------------: | :---------------------------------------: |
| ![](https://github.com/OtacilioN.png?size=140)<br> | ![](https://github.com/ThiagoAugustoSM.png?size=140)<br> | ![](https://github.com/ErickSimoes.png?size=140)<br> | ![](/docs/images/romulo.png?size=100)<br> |
|           **Idelização e Implementação**           |              **Validação e Implementação**               |     **Consultor de formatação e Implementação**      |         **Orientador Acadêmico**          |

Veja a lista completa de [colaboradores](https://github.com/OtacilioN/Brasilino/graphs/contributors).

## Artigos Relacionados:

A biblioteca foi apresentada na Mostra Nacional de Robótica em 2016, o que gerou um artigo publicado na [mostra virtual](http://www.mnr.org.br/mostravirtual/interna.php?id=15321).

"Aprenda a programar o arduino em português" por Saulo Alexandre na [Autocore Robótica](http://autocorerobotica.blog.br/aprenda-programar-o-arduino-em-portugues/amp/)

"Como uma biblioteca permite a inclusão de brasileiros dentro do universo Arduino" por Otacilio Maia no [Medium](https://medium.com/banana-digital/brasilino-a3957af2041d)

O Brasilino encontra-se aberto para ser utilizado em todo tipo de pesquisa e desenvolvimento científico-acadêmico.

## Apoio:

A biblioteca Brasilino é apoiada pelo Makerama, uma comunidade Maker que apoia o desenvolvimento de ideias criativas no estado de Pernambuco. Mais informações disponíveis em: http://makerama.com.br

![](http://makerama.com.br/wp-content/uploads/2016/03/makerama_100.png)<br>

## Licença:

Brasilino está licenciado sob a licença GPL-3.0, e tem seus exemplos baseados no trabalho do projeto [Arduino](https://github.com/arduino/Arduino).
Veja a [licença](https://github.com/OtacilioN/Brasilino/blob/master/LICENSE) para mais informações.

Sinta-se livre para enviar um email para: brasilino@otaciliomaia.com
