## Tabela de instruções:

### Estrutura Geral

As estruturas ``configurar`` e ``repetir`` são obrigatórias para o funcionamento do código.

| Instrução        | Descrição                                                                                                                                                                                                         | Exemplo                                                                                                                                                                                                                      |
|------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| configurar       | Função principal do programa. Só será executada uma única vez.                                                                                                                                                    | funcao configurar( ) { <br> /\* Bloco de uma única execução. \*/ <br> }                                                                                                                                                      |
| repetir          | Função secundária do programa que ficará repetindo enquanto o Arduino estiver ligado.                                                                                                                             | funcao repetir( ) { <br> /\* Bloco que ficará repetindo. Esta função vem logo após a função configurar. \*/ <br> }                                                                                                           |


### Estruturas de Controle

Estruturas de controle são estruturas do tipo condicional, que irão analisar uma condição especificada e executar uma ação se a condição for verdadeira.

| Instrução        | Descrição                                                                                                                                                                                                         | Exemplo                                                                                                                                                                                                                      |
|------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| se               | Analisa se a condição dentro do parâmetro é verdadeira e executa uma ação.                                                                                                                                        | se(a == b) { <br> // ação caso "a = b" <br> }                                                                                                                                                                                |
| senao            | Executa uma ação se o parâmetro da condição ``se`` for falso.                                                                                                                                                     | se(a == b) { <br> // ação caso "a = b" <br> } <br> senao { <br> // ação caso "a ≠ b" <br> }                                                                                                                                  |
| para             | Executa um bloco de instruções enquanto uma condição for satisfeita. É utilizado um contador para incrementar, ou decrementar, e terminar o loop.                                                                 | para(x = 0; x < 2; x = x+1) { <br> /\* executa este bloco enquanto "x" for menor que 2 \*/ <br> }                                                                                                                            |
| contarAte        | Aplicação da função ``para`` onde se escolhe o número de iterações.                                                                                                                                               | contarAte(5) { <br> /\* executa este bloco de instruções 5 vezes \*/ <br> }                                                                                                                                                  |
| enquanto         | Esta função executa continuamente enquanto o teste do parâmetro for verdadeiro.                                                                                                                                   | enquanto(x == 2) { <br> /\* ações a serem executadas enquanto o parâmetro for verdadeiro, ou seja, enquanto "x = 2" \*/ <br> }                                                                                               |
| comparar....caso | Compara o parâmetro da função com os casos definidos. No exemplo, "x" é comparado com os valores 1 e 2. É utilizado a instrução ``sair`` para que não se realize os próximos testes se algum já for o verdadeiro. | comparar(x) { <br><br> caso 1: <br> /\* ação caso "x = 1" \*/ <br> sair; <br><br> caso 2: <br> /\* ação caso "x = 2" \*/ <br> sair; <br><br> padrao: <br> /\* executa se não for nenhum dos casos \*/ <br> sair; <br> }      |


### Tipos de Dados Comuns

São estruturas de dados que conseguem armazenar diferentes tipos de dados.

| Instrução        | Descrição                                                                                                                                                                                                         | Exemplo                                                                                                                                                                                                                      |
|------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| inteiro          | Declara uma variável do tipo inteiro.                                                                                                                                                                             | inteiro idade = 13;                                                                                                                                                                                                          |
| decimal          | Declara uma variável do tipo decimal.                                                                                                                                                                             | decimal saldo = 3.45;                                                                                                                                                                                                        |
| dobro            | Declara uma variável do tipo dobro. Esta tem o dobro de bits de armazenamento quanto a variável decimal.                                                                                                          | dobro  lucro = 3.87909;                                                                                                                                                                                                      |
| caractere        | Declara uma variável do tipo caractere.                                                                                                                                                                           | caractere  entrada = 'c';                                                                                                                                                                                                    |
| constante        | Declara uma constante.                                                                                                                                                                                            | constante  tamanho = 4;                                                                                                                                                                                                      |
| logico           | Declara uma variável do tipo logico, podendo ser "verdadeiro" ou "falso".                                                                                                                                         | logico  dinheiro = verdadeiro;                                                                                                                                                                                               |
| nulo             | Declara uma variável do tipo nulo.                                                                                                                                                                                | nulo  sapatos;                                                                                                                                                                                                               |


### Tipos de Dados Lógicos

São estruturas de dados que conseguem assumir apenas dois valores.

| Instrução        | Descrição                                                                                                                                                                                                         | Exemplo                                                                                                                                                                                                                      |
|------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| verdadeiro       | Parâmetro lógico utilizado para operações digitais.                                                                                                                                                               | se(a == verdadeiro){ <br> // ação caso "a" seja verdadeiro <br> }                                                                                                                                                            |
| falso            | Parâmetro lógico utilizado para operações digitais.                                                                                                                                                               | se(a == falso){ <br> // ação caso "a" seja falso <br> }                                                                                                                                                                      |
| BAIXO            | Parâmetro que indica estado baixo no pino (0v).                                                                                                                                                                   | escreverDigital(10, BAIXO);                                                                                                                                                                                                  |
| ALTO             | Parâmetro que indica o estado alto no pino (5v).                                                                                                                                                                  | escreverDigital(10, ALTO);                                                                                                                                                                                                   |
| ENTRADA          | Parâmetro que indica tratar-se de uma entrada.                                                                                                                                                                    | definirPino(12, ENTRADA);                                                                                                                                                                                                    |
| SAIDA            | Parâmetro que indica tratar-se de uma saída.                                                                                                                                                                      | definirPino(11, SAIDA);                                                                                                                                                                                                      |
| PRESSIONADO      | Parâmetro para botão pressionado.                                                                                                                                                                                 | se(estadoBotao == PRESSIONADO)                                                                                                                                                                                               |
| LIBERADO         | Parâmetro para botão liberado.                                                                                                                                                                                    | se(estadoBotao == LIBERADO)                                                                                                                                                                                                  |


### Funções

Quando chamadas, as funções são responsáveis por executar alguma ação pré-determinada.

| Instrução        | Descrição                                                                                                                                                                                                         | Exemplo                                                                                                                                                                                                                      |
|------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| definir          | Associa um valor constante a um nome.                                                                                                                                                                             | #definir PINO 13                                                                                                                                                                                                             |
| usar             | Libera uma macro para uma nova função.                                                                                                                                                                            | #usar BAUD                                                                                                                                                                                                                   |
| definirPino      | Função que define o valor do pino como ``ENTRADA`` ou ``SAIDA``.                                                                                                                                                  | definirPino(PINO, TIPO);                                                                                                                                                                                                     |
| escrever         | Escreve o valor colocado como parâmetro no Monitor Serial.                                                                                                                                                        | Serial.escrever(10);                                                                                                                                                                                                         |
| escreverSerial   | Mostra no Monitor Serial o valor colocado como parâmetro.                                                                                                                                                        | escreverSerial(“BR”);                                                                                                                                                                                                       |
| escreverSerialn   | Mostra no Monitor Serial o valor colocado como parâmetro e dá um `\n` (enter).                                                                                                                                  | escreverSerialn(“BR”);                                                                                                                                                                                                       |
| escreverSerialEspecial | Mostra no Monitor Serial o valor colocado como parâmetro e escreve                                                                                     em um formato específico (**BIN**ário, **HEX**adecimal, **OCT**al e **DEC**imal).                 |                                                      escreverSerialEspecial(42, BIN); <br>                                                                                                                   escreverSerialEspecial(42, HEX); <br>                                                                                                                   escreverSerialEspecial(42, OCT);                                                                  |
| escreverSerialnEspecial | Mostra no Monitor Serial o valor colocado como parâmetro e escreve                                                                                     em um formato específico (**BIN**ário, **HEX**adecimal, **OCT**al e **DEC**imal) dá um `\n` (enter). |                                                               escreverSerialnEspecial(42, BIN); <br>                                                                                                                 escreverSerialnEspecial(42, HEX); <br>                                                                                                                  escreverSerialnEspecial(42, OCT);                                                                 |
| lerSerial        | Lê o valor recebido pelo Monitor Serial.                                                                                                                                                                          | lerSerial();                                                                                                                                                                                                                 |
| esperar          | Espera durante o tempo determinado, no seu parâmetro, para executar a próxima instrução.                                                                                                                          | esperar(1); <br> /\* O parâmetro deve ser escrito na unidade de segundos, podendo ser um valor decimal \*/                                                                                                                   |
| escreverDigital  | Função que escreve o valor ``ALTO`` ou ``BAIXO`` nos pinos digitais.                                                                                                                                              | escreverDigital(PINO, VALOR);                                                                                                                                                                                                |
| Entrada          | Define o pino como uma entrada.                                                                                                                                                                                   | entrada(12); <br> /\* Pino digital 12 definido como entrada \*/                                                                                                                                                              |
| Saida            | Define o pino como uma saída.                                                                                                                                                                                     | saida(13); <br> /\* Pino digital 13 definido como saída. \*/                                                                                                                                                                 |
| Ligar            | Função que escreve o valor ``ALTO`` no pino.                                                                                                                                                                      | Ligar(PINO);                                                                                                                                                                                                                 |
| Desligar         | Função que escreve o valor ``BAIXO`` no pino.                                                                                                                                                                     | Desligar(PINO);                                                                                                                                                                                                              |
