#include "../src/nodepp/tuple.h"

namespace TEST { namespace TUPLE {

    void TEST_RUNNER(){
        ptr_t<uint> totl = new uint(0);
        ptr_t<uint> done = new uint(0);
        ptr_t<uint> err  = new uint(0);
        ptr_t<uint> skp  = new uint(0);

        auto test = TEST_CREATE();

        TEST_ADD( test, "TEST 1 | tuple initialization", [](){
            tuple_t<int,float,string_t> tp ( 10, 10.50, "hello world!" );
            if ( tuple::get<0>(tp) != 10 )/*--------*/{ TEST_FAIL(); }
            if ( tuple::get<1>(tp) != 10.50 )/*-----*/{ TEST_FAIL(); }
            if ( tuple::get<2>(tp) != "hello world!" ){ TEST_FAIL(); } TEST_DONE();
        });

        test.onClose.once([=](){
            console::log("\nRESULT | total:", *totl, "| passed:", *done, "| error:", *err, "| skipped:", *skp );
        });

        test.onDone([=](){ (*done)++; (*totl)++; });
        test.onFail([=](){ (*err)++;  (*totl)++; });
        test.onSkip([=](){ (*skp)++;  (*totl)++; });

        TEST_AWAIT( test );

    }

}}