#pragma once

#include <Arduino.h>
#include "internal/wch_usbhid_internal.h"

#define MOUSE_LEFT    1
#define MOUSE_RIGHT   2
#define MOUSE_MIDDLE  4
#define MOUSE_ALL     (MOUSE_LEFT | MOUSE_RIGHT | MOUSE_MIDDLE)

// HID Mouse Report Structure (4 Bytes)
typedef struct {
  uint8_t buttons;
  int8_t x;
  int8_t y;
  int8_t wheel;
} MouseReport;

class USBMouse_ {
public:
  USBMouse_(void);
  void begin(void);
  void end(void);
  
  void click(uint8_t b = MOUSE_LEFT);
  void move(signed char x, signed char y, signed char wheel = 0);
  void press(uint8_t b = MOUSE_LEFT);
  void release(uint8_t b = MOUSE_LEFT);
  bool isPressed(uint8_t b = MOUSE_LEFT);
  
  // New: Speed Control (Consistent with Keyboard lib)
  void setDelay(uint32_t ms) { _delay = ms; }
  
  // Raw Report Access
  void sendReport(MouseReport* report);

private:
  MouseReport _mouseReport;
  uint32_t _delay;
};

extern USBMouse_ Mouse;