#include "USBMouse.h"
#include <string.h>

USBMouse_ Mouse;

USBMouse_::USBMouse_(void) {
  _delay = 0;
  memset(&_mouseReport, 0, sizeof(_mouseReport));
}

void USBMouse_::begin(void) {
    memset(&_mouseReport, 0, sizeof(_mouseReport));
    USB_init();
}

void USBMouse_::end(void) {
    memset(&_mouseReport, 0, sizeof(_mouseReport));
    sendReport(&_mouseReport);
}

void USBMouse_::sendReport(MouseReport* report) {
  USB_write((uint8_t*)report, sizeof(MouseReport));
  if (_delay > 0) delay(_delay);
}

void USBMouse_::click(uint8_t b) {
  press(b);
  release(b);
}

void USBMouse_::move(signed char x, signed char y, signed char wheel) {
  _mouseReport.x = x;
  _mouseReport.y = y;
  _mouseReport.wheel = wheel;
  
  sendReport(&_mouseReport);
  
  // Explicitly send a "Stop" report (0,0,0) immediately.
  // This prevents cursor drift if the host repeats the last packet 
  // or if there are signal integrity issues.
  _mouseReport.x = 0;
  _mouseReport.y = 0;
  _mouseReport.wheel = 0;
  
  sendReport(&_mouseReport);
}

void USBMouse_::press(uint8_t b) {
  if ((_mouseReport.buttons & b) != b) {
      _mouseReport.buttons |= b;
      sendReport(&_mouseReport);
  }
}

void USBMouse_::release(uint8_t b) {
  if ((_mouseReport.buttons & b) != 0) {
      _mouseReport.buttons &= ~b;
      sendReport(&_mouseReport);
  }
}

bool USBMouse_::isPressed(uint8_t b) {
  if ((_mouseReport.buttons & b) == b)
    return true;
  return false;
}
