#include <USBMouse.h>

void setup() {
  Mouse.begin();
  
  // Wait for the host to enumerate the USB device
  delay(1000);
}

void loop() {
  // Move in a smaller, controlled square pattern
  // We use smaller steps and longer delays to avoid triggering OS mouse acceleration.
  
  int steps = 40;     // Number of packets per side
  int distance = 2;   // Pixels per packet (Total side length approx 80 pixels)
  int speed = 25;     // Delay in ms between packets (slower = more precise, less acceleration)

  // 1. Move Right
  for(int i=0; i<steps; i++) {
    Mouse.move(distance, 0, 0); 
    delay(speed);
  }
  delay(500);

  // 2. Move Down
  for(int i=0; i<steps; i++) {
    Mouse.move(0, distance, 0);
    delay(speed);
  }
  delay(500);

  // 3. Move Left
  for(int i=0; i<steps; i++) {
    Mouse.move(-distance, 0, 0);
    delay(speed);
  }
  delay(500);

  // 4. Move Up
  for(int i=0; i<steps; i++) {
    Mouse.move(0, -distance, 0);
    delay(speed);
  }
  delay(1000);
  
  // Right Click test (context menu)
  Mouse.click(MOUSE_RIGHT);
  
  // Wait before repeating
  delay(3000);
}