#include <USBMouse.h>

// Fast Continuous Mouse Jiggler
// Moves the cursor constantly in a pattern to keep the PC awake.

void setup() {
  Mouse.begin();
  
  // Wait for the host to enumerate the USB device
  delay(1000);
}

void loop() {
  // Continuous Diamond Pattern (X and Y movement)
  int step = 2;   // Distance in pixels
  int speed = 30;  // Delay in ms (lower is faster)

  // 1. Move Down-Right
  Mouse.move(step, step, 0);
  delay(speed);

  // 2. Move Down-Left
  Mouse.move(-step, step, 0);
  delay(speed);

  // 3. Move Up-Left
  Mouse.move(-step, -step, 0);
  delay(speed);

  // 4. Move Up-Right
  Mouse.move(step, -step, 0);
  delay(speed);
  
  // No long delay here - keep moving forever!
}
