#include <USBGamepad.h>

// Complete Independent Gamepad Test
// This example tests every single axis and button independently 
// using the optimized sendReport() method for maximum performance.

void setup() {
  Gamepad.begin();
  
  // Wait for the host to enumerate the USB device
  delay(1000);
}

void loop() {
  // 1. TEST ALL BUTTONS
  for (int i = 0; i < 16; i++) {
    Gamepad.press(i); 
    Gamepad.sendReport(); 
    delay(50);
    Gamepad.release(i); 
    Gamepad.sendReport();
  }
  delay(500);

  // 2. TEST LEFT STICK X (Horizontal)
  for (int x = -127; x <= 127; x++) { 
    Gamepad.setLeftStick(x, 0); 
    Gamepad.sendReport(); 
    delay(4); 
  }
  Gamepad.setLeftStick(0, 0); 
  Gamepad.sendReport(); 
  delay(200);

  // 3. TEST LEFT STICK Y (Vertical)
  for (int y = -127; y <= 127; y++) { 
    Gamepad.setLeftStick(0, y); 
    Gamepad.sendReport(); 
    delay(4); 
  }
  Gamepad.setLeftStick(0, 0); 
  Gamepad.sendReport(); 
  delay(200);

  // 4. TEST RIGHT STICK X (Horizontal - Z Axis)
  for (int x = -127; x <= 127; x++) { 
    Gamepad.setRightStick(x, 0); 
    Gamepad.sendReport(); 
    delay(4); 
  }
  Gamepad.setRightStick(0, 0); 
  Gamepad.sendReport(); 
  delay(200);

  // 5. TEST RIGHT STICK Y (Vertical - Rz Axis)
  for (int y = -127; y <= 127; y++) { 
    Gamepad.setRightStick(0, y); 
    Gamepad.sendReport(); 
    delay(4); 
  }
  Gamepad.setRightStick(0, 0); 
  Gamepad.sendReport(); 
  delay(200);

  // 6. TEST ANALOG TRIGGERS (Independent Fade)
  // Left Trigger
  for (int val = 0; val <= 255; val++) { 
    Gamepad.setTriggers(val, 0); 
    Gamepad.sendReport(); 
    delay(3); 
  }
  // Right Trigger
  for (int val = 0; val <= 255; val++) { 
    Gamepad.setTriggers(0, val); 
    Gamepad.sendReport(); 
    delay(3); 
  }
  Gamepad.setTriggers(0, 0); 
  Gamepad.sendReport(); 
  delay(500);

  // 7. TEST D-PAD
  uint8_t directions[] = {DPAD_UP, DPAD_RIGHT, DPAD_DOWN, DPAD_LEFT};
  for (int i = 0; i < 4; i++) {
    Gamepad.setHat(directions[i]);
    Gamepad.sendReport();
    delay(400);
  }
  Gamepad.setHat(DPAD_CENTERED);
  Gamepad.sendReport();
  
  delay(3000);
}