#pragma once

#include <Arduino.h>
#include "internal/wch_usbhid_internal.h"

// D-Pad (Hat Switch) Directions
#define DPAD_UP         0
#define DPAD_UP_RIGHT   1
#define DPAD_RIGHT      2
#define DPAD_DOWN_RIGHT 3
#define DPAD_DOWN       4
#define DPAD_DOWN_LEFT  5
#define DPAD_LEFT       6
#define DPAD_UP_LEFT    7
#define DPAD_CENTERED   8

// HID Gamepad Report Structure (9 Bytes)
typedef struct __attribute__((packed)) {
  int8_t  axisX;        // Left Stick X
  int8_t  axisY;        // Left Stick Y
  int8_t  axisZ;        // Right Stick X
  int8_t  axisRz;       // Right Stick Y
  uint8_t triggerL;     // Left Trigger (Rx)
  uint8_t triggerR;     // Right Trigger (Ry)
  uint16_t buttons;     // 16 Buttons
  uint8_t hatSwitch;    // D-Pad (Low nibble)
} GamepadReport;

class USBGamepad_ {
public:
  USBGamepad_(void);
  void begin(void);
  void end(void);
  
  void setLeftStick(int8_t x, int8_t y);
  void setRightStick(int8_t x, int8_t y);
  
  void setTriggers(uint8_t left, uint8_t right);
  
  void press(uint8_t button);
  void release(uint8_t button);
  void releaseAll();
  bool isPressed(uint8_t button);
  
  void setHat(uint8_t direction);
  
  void sendReport();

private:
  GamepadReport _report;
};

extern USBGamepad_ Gamepad;
