#include <Arduino.h>

#include "DUE_ADC_Oversampler.h"


void setup()
{
  Serial.begin (115200) ; 

  // ADC_OS.begin() Parameter:
  //  -(float)sample frequency in Hz,
  //  -oversampler resolution(12 to 16),
  //  - ... list of channel to enabled

  /*
    The sample frequency that the Due can scan is divided by the number of anable channel and the oversampling level.
    Theoretically, the ADC could sample 1 channel at 4Mh.
    If you enable 4 channel, you must devide by 4.
    Oversample take many reading by conversion:
    -12 bits = 1 sample (no oversample)
    -13 bits = 4 samples
    -14 bits = 16 samples
    -15 bits = 64 samples
    -15 bits = 256 samples

    So the bigger the oversampler, the slower the sampler will be.
    The programmer should enable only the needed pins.
  */

  ADC_OS.begin(50, ADC_OS_16BITS);  //Enable all standar DUE analog pins (A0 to A11)

  //ADC_OS.begin(50, ADC_OS_16BITS, A0,A2,A3,A5,A6,A7,A9,A10,A11, 52);  //Enable selected pin

  //ADC_OS.begin(50, ADC_OS_16BITS, ANALOG_PINS_ALL); //Enable all 15 analog pins and internal temp channel 
  
  delay(1000);
}


void loop() {
  //use ADC_OS.read(), like analogRead(), to get the latest converted value:

//Usual arduino DUE analog pins
  Serial.print("Pin  A0: "); Serial.println(ADC_OS.read(0));
  Serial.print("Pin  A1: "); Serial.println(ADC_OS.read(A1));
  Serial.print("Pin  A2: "); Serial.println(ADC_OS.read(A2));
  Serial.print("Pin  A3: "); Serial.println(ADC_OS.read(A3));
  Serial.print("Pin  A4: "); Serial.println(ADC_OS.read(A4));
  Serial.print("Pin  A5: "); Serial.println(ADC_OS.read(A5));
  Serial.print("Pin  A6: "); Serial.println(ADC_OS.read(A6));
  Serial.print("Pin  A7: "); Serial.println(ADC_OS.read(A7));
  Serial.print("Pin  A8: "); Serial.println(ADC_OS.read(A8));
  Serial.print("Pin  A9: "); Serial.println(ADC_OS.read(A9));
  Serial.print("Pin A10: "); Serial.println(ADC_OS.read(A10));
  Serial.print("Pin A11: "); Serial.println(ADC_OS.read(A11));
//Others analog pins
  Serial.print("Pin  20: "); Serial.println(ADC_OS.read(20)); //If an disabled channel is read, it return -1
  Serial.print("Pin  21: "); Serial.println(ADC_OS.read(21));
  Serial.print("Pin  52: "); Serial.println(ADC_OS.read(52));
//Internal temp sensor, converted in celcius  
  Serial.print("internal temp : "); Serial.print(internalTemp()); Serial.println("°C");
  

  delay(1000);
}

