# Neza74HC595

**Author:** Emmanuel Mugwaneza  
**Email:** nezaemmy1@gmail.com  
**Platform:** ESP32  
**Category:** Signal Input/Output

## Description

**Neza74HC595** is a lightweight and efficient Arduino library designed for ESP32 to control one or more 74HC595 shift registers. It provides a simple interface to set individual pins, update all outputs, and manage digital states with interrupt safety.

This library is ideal for expanding digital outputs when working with limited GPIO pins on microcontrollers.

---

## Features

- Control multiple 74HC595 shift registers
- Set individual or all output pins
- Efficient memory usage with templated design
- Optional interrupt-safe register updates
- Designed for ESP32

---

## Installation

1. Download or clone the repository.
2. Place the `Neza74HC595` folder in your Arduino `libraries` directory.
3. Restart the Arduino IDE.

---

## Example Usage

```cpp
#include <Neza74HC595.hpp>

// Create a shift register object for 2 cascaded 74HC595 chips
Neza74HC595<2> shift(23, 5, 18); // Serial data, clock, latch pins

void setup() {
    // Set all outputs HIGH for 1 second
    shift.setAllHigh();
    delay(1000);

    // Set all outputs LOW
    shift.setAllLow();
}

void loop() {
    // Blink pin 5 on the shift register
    shift.set(5, HIGH);
    delay(500);
    shift.set(5, LOW);
    delay(500);
}
