

#pragma once

#include <Arduino.h>

template<uint8_t Size>
class Neza74HC595 {
public:
    Neza74HC595(const uint8_t serialDataPin, const uint8_t clockPin, const uint8_t latchPin);

    void setAll(const uint8_t* digitalValues);
    uint8_t* getAll();
    void set(const uint8_t pin, const uint8_t value);
    void setNoUpdate(const uint8_t pin, uint8_t value);
    void updateRegisters();
    void setAllLow();
    void setAllHigh();
    uint8_t get(const uint8_t pin);

private:
    uint8_t _clockPin;
    uint8_t _serialDataPin;
    uint8_t _latchPin;
    uint8_t _digitalValues[Size];
};

