// all known networks
#include "Networks.h"

const Network Neurai = {
    0x35, // p2pkh
    0x75, // p2sh
    "",  // no bech32 prefix in Neurai
    0x80, // wif
    { 0x04, 0x88, 0xad, 0xe4 }, // xprv
    { 0x04, 0x9d, 0x78, 0x78 }, // yprv
    { 0x04, 0xb2, 0x43, 0x0c }, // zprv
    { 0x02, 0x95, 0xb0, 0x05 }, // Yprv
    { 0x02, 0xaa, 0x7a, 0x99 }, // Zprv
    { 0x04, 0x88, 0xb2, 0x1e }, // xpub
    { 0x04, 0x9d, 0x7c, 0xb2 }, // ypub
    { 0x04, 0xb2, 0x47, 0x46 }, // zpub
    { 0x02, 0x95, 0xb4, 0x3f }, // Ypub
    { 0x02, 0xaa, 0x7e, 0xd3 }, // Zpub
    0 // bip32 coin type
};

const Network NeuraiHW = {
    0x35, // p2pkh
    0x75, // p2sh
    "",  // no bech32 prefix in Neurai
    0x80, // wif
    { 0x04, 0x88, 0xad, 0xe4 }, // xprv
    { 0x04, 0x9d, 0x78, 0x78 }, // yprv
    { 0x04, 0xb2, 0x43, 0x0c }, // zprv
    { 0x02, 0x95, 0xb0, 0x05 }, // Yprv
    { 0x02, 0xaa, 0x7a, 0x99 }, // Zprv
    { 0x04, 0x88, 0xb2, 0x1e }, // xpub
    { 0x04, 0x9d, 0x7c, 0xb2 }, // ypub
    { 0x04, 0xb2, 0x47, 0x46 }, // zpub
    { 0x02, 0x95, 0xb4, 0x3f }, // Ypub
    { 0x02, 0xaa, 0x7e, 0xd3 }, // Zpub
    1900 // bip32 coin type for hardware targets
};

const Network NeuraiTest = {
    0x7f, // p2pkh
    0xc4, // p2sh
    "",  // no bech32 prefix in Neurai
    0x80, // wif
    { 0x04, 0x35, 0x83, 0x94 }, // tprv equivalent
    { 0x04, 0x4a, 0x4e, 0x28 }, // uprv equivalent
    { 0x04, 0x5f, 0x18, 0xbc }, // vprv equivalent
    { 0x02, 0x42, 0x85, 0xb5 }, // Uprv equivalent
    { 0x02, 0x57, 0x50, 0x48 }, // Vprv equivalent
    { 0x04, 0x35, 0x87, 0xcf }, // tpub equivalent
    { 0x04, 0x4a, 0x52, 0x62 }, // upub equivalent
    { 0x04, 0x5f, 0x1c, 0xf6 }, // vpub equivalent
    { 0x02, 0x42, 0x89, 0xef }, // Upub equivalent
    { 0x02, 0x57, 0x54, 0x83 }, // Vpub equivalent
    0 // bip32 coin type
};

const Network * networks[3] = { &Neurai, &NeuraiHW, &NeuraiTest };
const uint8_t networks_len = 3;
