#include "Arduino.h"
#include "NaiPot.h"
Pot::Pot() {}

Pot::Pot(int pin, int min, int max) : _pin(pin), _min(min), _max(max) {}

void Pot::init(int pin, int min, int max) {
    _pin = pin;
    _min = min;
    _max = max;
}

int Pot::get() {
    return analogRead(_pin);
}

void Pot::print() {
    Serial.println(analogRead(_pin));
}

int Pot::Map(int outMin, int outMax) {
    return map(analogRead(_pin), _min, _max, outMin, outMax);
}

void Pot::printMap(int outMin, int outMax) {
    Serial.println(map(analogRead(_pin), _min, _max, outMin, outMax));
}