# Библиотека NaiPot для Arduino

Простая библиотека для работы с потенциометрами. Позволяет легко считывать и преобразовывать значения с потенциометров.

## Особенности

- Чтение "сырых" аналоговых значений с потенциометра
- Преобразование значений в произвольные диапазоны
- Вывод значений в Serial
- Простота использования и малый вес

## Установка

1. Скачайте библиотеку в формате ZIP
2. В Arduino IDE: Скетч > Подключить библиотеку > Добавить .ZIP библиотеку...
3. Выберите скачанный ZIP-файл

## Использование

```cpp
#include <NaiPot.h>

// Создание объекта потенциометра
// Параметры: номер пина, минимальное и максимальное значение
Pot myPot(A0, 0, 1023); 

void setup() {
  Serial.begin(9600);
}

void loop() {
  // Получение "сырого" значения
  int value = myPot.get();
  
  // Преобразование значения в диапазон 0-255
  int mapped = myPot.Map(0, 255);
  
  // Вывод преобразованного значения в Serial
  myPot.printMap(0, 255);
  
  delay(100);
}
```

## Подробное описание методов

### Конструкторы
```cpp
Pot() // Пустой конструктор
Pot(int pin, int min, int max) // С параметрами: пин, мин, макс значения
```
Создает объект потенциометра. Если используется пустой конструктор, необходимо позже вызвать метод `init()`.

### Метод init()
```cpp
void init(int pin, int min, int max)
```
Инициализирует потенциометр с указанными параметрами:
- `pin` - аналоговый пин Arduino
- `min` - минимальное ожидаемое значение (обычно 0)
- `max` - максимальное ожидаемое значение (обычно 1023)

### Метод get()
```cpp
int get()
```
Возвращает текущее "сырое" значение с потенциометра (0-1023 для 10-битного АЦП).

### Метод print()
```cpp
void print()
```
Выводит текущее "сырое" значение в Serial (с переносом строки).

### Метод Map()
```cpp
int Map(int outMin, int outMax)
```
Преобразует текущее значение потенциометра в указанный диапазон:
- `outMin` - минимальное значение выходного диапазона
- `outMax` - максимальное значение выходного диапазона

Возвращает преобразованное значение.

### Метод printMap()
```cpp
void printMap(int outMin, int outMax)
```
Выводит преобразованное значение в Serial (с переносом строки). Параметры аналогичны методу `Map()`.

## Примеры применения

1. Управление яркостью светодиода:
```cpp
Pot pot(A0, 0, 1023);
int ledPin = 9;

void setup() {
  pinMode(ledPin, OUTPUT);
}

void loop() {
  analogWrite(ledPin, pot.Map(0, 255));
}
```

2. Выбор пункта меню (0-4):
```cpp
Pot menuPot(A1, 0, 1023);

void loop() {
  int menuItem = menuPot.Map(0, 4);
  Serial.print("Выбран пункт: ");
  Serial.println(menuItem);
}
```

## Лицензия

MIT License