# Arduino, ESP8266, STM32, ESP32 and others uEEPROMLib

![Arduino CI](https://github.com/Naguissa/uEEPROMLib/workflows/arduino_ci/badge.svg)


## What is this repository for?

I2C EEPROM library. Split from uRTCLib https://github.com/Naguissa/uRTCLib

This library controls any I2C EEPROM, independent ones or incorporated on DS1307 or DS3231 RTCs.

*Note: On ATTiny, you need TnyWireM library in order to compile. It's available on Library manager.

## How do I get set up?

You can get it from Arduino libraries directly, searching by uEEPROMLib.

For manual installation:

 * Get the ZIP.
 * Rename to uEEPROMLib.zip
 * Install library on Arduino



## Documentation and extras

You can find all documentation and extras in this repository: https://github.com/Naguissa/uEEPROMLib_doc_and_extras

You can read documentation online here: https://naguissa.github.io/uEEPROMLib_doc_and_extras/

IMPORTANT NOTE: It's a little bit hidden, but you can set your EEPROM page size changing public variable uEEPROMLIBVariable.page_size



## Examples

Included on example folder, available on Arduino IDE.




## Who do I talk to?

 * [Naguissa](https://github.com/Naguissa)
 * https://www.foroelectro.net/librerias-arduino-ide-f29/ueepromlib-arduino-libreria-simple-y-eficaz-para-e-t225.html
 * https://www.naguissa.com



## Contribute

Any code contribution, report or comment are always welcome. Don't hesitate to use GitHub for that.


 * You can sponsor this project using GitHub's Sponsor button: https://github.com/Naguissa/uEEPROMLib
 * You can make a donation via PayPal: https://paypal.me/foroelectro


Thanks for your support.


Contributors hall of fame: https://www.foroelectro.net/hall-of-fame-f32/contributors-contribuyentes-t271.html
