#include <InfiniteFunctionButton.h>

/*!
  @brief      The class constructor.
  @param[in]  gpio The gpio to use.
  @param[in]  debounceTime The debounce time, in milliseconds.
  @param[in]  activeHigh Specify if the button is wired to output a HIGH state when pressed.
  @details    Pick a pin that supports interrupts on your microcontroller (2 or 3 for Arduino Uno).
              I found 25ms debounce time to work well with my test 6x6mm push button switch.
              When activeHigh is false or not specified, the pin will be set up as INPUT_PULLUP
              and the button should be connected to short it to ground when pressed.
              Likewise, when activeHigh is true, the pin will be set up as INPUT
              and a HIGH state will represent the button being pressed.
              Remember to provide your own pulldown resistor in this setting.
*/
InfiniteFunctionButton button(2, 25);

void testISR() { // add IRAM_ATTR if using ESP!
  button.onInterrupt();
}

void setup() {
  Serial.begin(115200);

  button.addIntermediateFunction(1000, []() {
    Serial.println("The button has been released in less than 1 second.");
    Serial.println("Function A activated.");
  }, NULL);

  button.addIntermediateFunction(2000, []() {
    Serial.println("The button has been released in less than 2 seconds.");
    Serial.println("Function B activated.");
  }, []() {
    Serial.println("Please release the button to activate function B.");
    // This callback can be used to light up an LED, sound a buzzer, change text on a display, etc.
  });

  button.setEndingFunction([]() {
    Serial.println("You've held the button for over 2 seconds... That's some tough finger!");
  });

  button.begin(testISR);
}

void loop() {
  button.handleInterruptAndFunctions();
}