/**
 * \file rnwf_mqtt.h
 * \brief This header file contains APIs for configuring the MQTT Parameters.
 */
/*
© 2025 Microchip Technology Inc. and its subsidiaries. All rights reserved.

Subject to your compliance with these terms, you may use this Microchip software and any derivatives 
exclusively with Microchip products. You are responsible for complying with third party license terms 
applicable to your use of third party software (including open source software) that may accompany this 
Microchip software. SOFTWARE IS “AS IS.” NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR 
STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED WARRANTIES OF NON-INFRINGEMENT,
MERCHANTABILITY, OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL 
MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL OR CONSEQUENTIAL LOSS, 
DAMAGE, COST OR EXPENSE OF ANY KIND WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER 
CAUSED, EVEN IF MICROCHIP HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE 
FORESEEABLE. TO THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP’S TOTAL LIABILITY ON ALL 
CLAIMS RELATED TO THE SOFTWARE WILL NOT EXCEED AMOUNT OF FEES, IF ANY, YOU PAID DIRECTLY 
TO MICROCHIP FOR THIS SOFTWARE
*/

#ifndef RNWF_MQTT_H
#define RNWF_MQTT_H

#include <Arduino.h>
#include <stdbool.h>
#include <stdint.h>
#include <stddef.h>
#include "rnwf_interface.h"

/*MQTT buffer max length*/
#define SYS_RNWF_MQTT_BUF_LEN_MAX	4096

/* MQTT Configuration Commands */
#define SYS_RNWF_MQTT_SET_BROKER_URL    "AT+MQTTC=1,\"%s\"\r\n"
#define SYS_RNWF_MQTT_SET_BROKER_PORT   "AT+MQTTC=2,%d\r\n"
#define SYS_RNWF_MQTT_SET_CLIENT_ID     "AT+MQTTC=3,\"%s\"\r\n"
#define SYS_RNWF_MQTT_SET_USERNAME      "AT+MQTTC=4,\"%s\"\r\n"
#define SYS_RNWF_MQTT_SET_PASSWORD      "AT+MQTTC=5,\"%s\"\r\n"
#define SYS_RNWF_MQTT_SET_KEEPALIVE     "AT+MQTTC=6,%d\r\n"
#define SYS_RNWF_MQTT_SET_TLS_CONF      "AT+MQTTC=7,%d\r\n"
#define SYS_RNWF_MQTT_SET_PROTO_VER     "AT+MQTTC=8,%d\r\n"

/* MQTT Connection Commands */
#define SYS_RNWF_MQTT_CMD_CONNECT      "AT+MQTTCONN=1\r\n"
#define SYS_RNWF_MQTT_CMD_RECONNECT    "AT+MQTTCONN=0\r\n"

/* MQTT Disconnection Commands */
#define SYS_RNWF_MQTT_CMD_DISCONNECT        "AT+MQTTDISCONN=0\r\n"

/* MQTT Subscribe Commands */
#define SYS_RNWF_MQTT_CMD_SUBSCRIBE_QOS    "AT+MQTTSUB=\"%s\",%d\r\n"
#define SYS_RNWF_MQTT_CMD_UNSUBSCRIBE       "AT+MQTTUNSUB=%s\r\n"

/* MQTT Publish Commands */
#define SYS_RNWF_MQTT_CMD_PUBLISH           "AT+MQTTPUB=%d,%d,%d,\"%s\",\"%s\"\r\n"

/* MQTT LWT Commands */
#define SYS_RNWF_MQTT_LWT_CMD               "AT+MQTTLWT=%d,%d,\"%s\",\"%s\"\r\n"

/* MQTT Transmit Properties  Commands */
#define SYS_RNWF_MQTT_SET_TX_PAYLOD_FORMAT_IND      "AT+MQTTPROPTX=1,%d\r\n"
#define SYS_RNWF_MQTT_SET_TX_MSG_EXPIRY            "AT+MQTTPROPTX=2,%d\r\n"
#define SYS_RNWF_MQTT_SET_TX_CONTENT_TYPE           "AT+MQTTPROPTX=3,\"%s\"\r\n"         
#define SYS_RNWF_MQTT_SET_TX_SESSION_EXPIRY         "AT+MQTTPROPTX=17,%d\r\n"
#define SYS_RNWF_MQTT_SET_TX_USER_PROP              "AT+MQTTPROPTX=38,\"%s\",\"%s\"\r\n"

/* MQTT Transmit Properties Select Commands */
#define SYS_RNWF_MQTT_SET_TX_PAYLOD_FORMAT_IND_SEC      "AT+MQTTPROPTXS=1,1\r\n"
#define SYS_RNWF_MQTT_SET_TX_MSG_EXPIRY_SEC             "AT+MQTTPROPTXS=2,1\r\n"
#define SYS_RNWF_MQTT_SET_TX_CONTENT_TYPE_SEC           "AT+MQTTPROPTXS=3,1\r\n"         
#define SYS_RNWF_MQTT_SET_TX_SESSION_EXPIRY_SEC         "AT+MQTTPROPTXS=17,1\r\n"
#define SYS_RNWF_MQTT_SET_TX_USER_PROP_SEC              "AT+MQTTPROPTXS=38,1\r\n"

/* MQTT Receive Properties  Commands */
#define SYS_RNWF_MQTT_SET_RX_SESSION_EXPIRY     "AT+MQTTPROPRX=17,%d\r\n"
#define SYS_RNWF_MQTT_SET_RX_TOP_ALIAS_MAX      "AT+MQTTPROPRX=34,%s\r\n"
#define SYS_RNWF_MQTT_SET_RX_TOP_USER_PROP      "AT+MQTTPROPRX=38,%s\r\n"


#define SYS_RNWF_MQTT_CLR_TX_PROP_ID            "AT+MQTTPROPTXS=%d,0"
#define SYS_RNWF_MQTT_SET_TX_PROP_ID            "AT+MQTTPROPTXS=%d,1"


#define SYS_RNWF_MQTT_PORT_NO_ECN_NO_AUTH        1883
#define SYS_RNWF_MQTT_PORT_NO_ECN_AUTH           1884
#define SYS_RNWF_MQTT_PORT_ECN_NO_AUTH           8883

/*MQTT Service max callback service*/
#define SYS_RNWF_MQTT_SERVICE_CB_MAX        2

class MQTT {
  private:

  public:

bool RNWF_WifiMqttProtocol(const char *cmd);

bool RNWF_WifiMqttBrokerUrl(const char *cmd);

bool RNWF_WifiMqttBrokerPort(const char *cmd);

bool RNWF_WifiMqttBrokerClientId(const char *cmd);

bool RNWF_WifiMqttBrokerUsername(const char *cmd);

bool RNWF_WifiMqttBrokerPassword(const char *cmd);

bool RNWF_WifiMqttBrokerKeepalive(const char *cmd);

bool RNWF_WifiMqttBrokerPublish(const char *cmd);

bool RNWF_WifiMqttBrokerSubscribe(const char *cmd);

bool RNWF_WifiMqttConnect(void);

bool RNWF_WifiMqttReconnect(void);

bool RNWF_WifiMqttDisconnect(void);

};

#endif /* RNWF_MQTT_H */