/**
 * \file rnwf_mqtt.cpp
 * \brief This source file contains APIs for configuring the MQTT Parameters.
 */
/*
© 2025 Microchip Technology Inc. and its subsidiaries. All rights reserved.

Subject to your compliance with these terms, you may use this Microchip software and any derivatives 
exclusively with Microchip products. You are responsible for complying with third party license terms 
applicable to your use of third party software (including open source software) that may accompany this 
Microchip software. SOFTWARE IS “AS IS.” NO WARRANTIES, WHETHER EXPRESS, IMPLIED OR 
STATUTORY, APPLY TO THIS SOFTWARE, INCLUDING ANY IMPLIED WARRANTIES OF NON-INFRINGEMENT,
MERCHANTABILITY, OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL 
MICROCHIP BE LIABLE FOR ANY INDIRECT, SPECIAL, PUNITIVE, INCIDENTAL OR CONSEQUENTIAL LOSS, 
DAMAGE, COST OR EXPENSE OF ANY KIND WHATSOEVER RELATED TO THE SOFTWARE, HOWEVER 
CAUSED, EVEN IF MICROCHIP HAS BEEN ADVISED OF THE POSSIBILITY OR THE DAMAGES ARE 
FORESEEABLE. TO THE FULLEST EXTENT ALLOWED BY LAW, MICROCHIP’S TOTAL LIABILITY ON ALL 
CLAIMS RELATED TO THE SOFTWARE WILL NOT EXCEED AMOUNT OF FEES, IF ANY, YOU PAID DIRECTLY 
TO MICROCHIP FOR THIS SOFTWARE
*/

#include <Arduino.h>
#include "rnwf_mqtt.h"


bool MQTT::RNWF_WifiMqttProtocol(const char *cmd) {
  RNWF_SendCmd(cmd);
  return true; 
}

bool MQTT::RNWF_WifiMqttBrokerUrl(const char *cmd) {
  RNWF_SendCmd(cmd);
  return true; 
}

bool MQTT::RNWF_WifiMqttBrokerPort(const char *cmd) {
  RNWF_SendCmd(cmd);
  return true; 
}

bool MQTT::RNWF_WifiMqttBrokerClientId(const char *cmd) {
  RNWF_SendCmd(cmd);
  return true; 
}

bool MQTT::RNWF_WifiMqttBrokerUsername(const char *cmd) {
  RNWF_SendCmd(cmd);
  return true; 
}

bool MQTT::RNWF_WifiMqttBrokerPassword(const char *cmd) {
  RNWF_SendCmd(cmd);
  return true; 
}

bool MQTT::RNWF_WifiMqttBrokerKeepalive(const char *cmd) {
  RNWF_SendCmd(cmd);
  return true; 
}

bool MQTT::RNWF_WifiMqttBrokerPublish(const char *cmd) {
  RNWF_SendCmd(cmd);
  return true; 
}

bool MQTT::RNWF_WifiMqttBrokerSubscribe(const char *cmd) {
  RNWF_SendCmd(cmd);
  return true; 
}

bool MQTT::RNWF_WifiMqttConnect(void) {
  RNWF_SendCmd(SYS_RNWF_MQTT_CMD_CONNECT);
  return true; 
}

bool MQTT::RNWF_WifiMqttReconnect(void) {
  RNWF_SendCmd(SYS_RNWF_MQTT_CMD_RECONNECT);
  return true; 
}

bool MQTT::RNWF_WifiMqttDisconnect(void) {
  RNWF_SendCmd(SYS_RNWF_MQTT_CMD_DISCONNECT);
  return true; 
}
