MegunoLink library for Arduino
============================== 

![example build test](https://github.com/github/docs/actions/workflows/githubci.yml/badge.svg?event=push)

An [Arduino library](http://www.megunolink.com/documentation/arduino-libraries/) for sending data and commands to [MegunoLink](https://www.MegunoLink.com) visualizers including:

* [Interface panel](https://www.megunolink.com/documentation/interface-panel/)
* [XY-Plots](https://www.megunolink.com/documentation/plotting/xy-plot/)
* [Time plots](https://www.megunolink.com/documentation/plotting/time-plot/)
* [Property tables](https://www.megunolink.com/documentation/table/property-table/)
* [Record tables](https://www.megunolink.com/documentation/table/record-table/)
* [Message stream](https://www.megunolink.com/documentation/serial-monitors/message-monitor-visualizer/)
* [Message monkey](https://www.megunolink.com/documentation/message-monkey/)
* [Maps](https://www.megunolink.com/documentation/mapping/)
* [Test reports](https://www.megunolink.com/documentation/program-device/test-monitor-panel/)
* [Scheduled reporting](https://www.megunolink.com/documentation/reporting/scheduled-reporting/)
* [Playing audio clips and speech](https://www.megunolink.com/documentation/play-sounds/)

The library also supports:

* A [command handler for serial commands](http://www.megunolink.com/documentation/arduino-libraries/serial-command-handler/)
* A class to make it easier to write [timer driven code](http://www.megunolink.com/documentation/arduino-libraries/arduino-timer/) with Arduino millis() timer
* A template for [storing data in the eeprom](https://www.megunolink.com/documentation/arduino-libraries/eepromstore/)
* An [exponential filter](https://www.megunolink.com/documentation/arduino-libraries/exponential-filter/)
* A [circular buffer template](https://www.megunolink.com/documentation/arduino-libraries/circular-buffer/)
* A command processor for dispatching commands

Visit [www.MegunoLink.com](https://www.MegunoLink.com) to [download MegunoLink](http://www.MegunoLink.com/download) and learn more. 

Arduino Installation
--------------------
Install the library into the `libraries` folder of your Arduino installation or use [MegunoLink's Arduino integration setup](https://www.megunolink.com/documentation/install/arduino-integration-setup/) tool.


Library dependecies: none.

License Information
--------------------------
The hardware is released under the GNU Lesser General Public License (LGPL)

Distributed as-is; no warranty is given.
