[![Arduino IDE](https://img.shields.io/badge/Arduino-Library%20Manager-00979d.svg?logo=data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz48c3ZnIHZlcnNpb249IjEuMSIgaWQ9InN2ZzIiIGlua3NjYXBlOnZlcnNpb249IjAuNDguMiByOTgxOSIgc29kaXBvZGk6ZG9jbmFtZT0iYXJkdWluby1sb2dvLnN2ZyIgeG1sbnM6Y2M9Imh0dHA6Ly9jcmVhdGl2ZWNvbW1vbnMub3JnL25zIyIgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIiB4bWxuczppbmtzY2FwZT0iaHR0cDovL3d3dy5pbmtzY2FwZS5vcmcvbmFtZXNwYWNlcy9pbmtzY2FwZSIgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIiB4bWxuczpzb2RpcG9kaT0iaHR0cDovL3NvZGlwb2RpLnNvdXJjZWZvcmdlLm5ldC9EVEQvc29kaXBvZGktMC5kdGQiIHhtbG5zOnN2Zz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHg9IjBweCIgeT0iMHB4IiB2aWV3Qm94PSIwIDAgNzIxLjEgMzQwLjMiIHN0eWxlPSJlbmFibGUtYmFja2dyb3VuZDpuZXcgMCAwIDcyMS4xIDM0MC4zOyIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+PHN0eWxlIHR5cGU9InRleHQvY3NzIj4uc3Qwe2ZpbGw6bm9uZTtzdHJva2U6I0ZGRkZGRjtzdHJva2Utd2lkdGg6NjA7fS5zdDF7ZmlsbDojMDA5NzlDO3N0cm9rZTojRkZGRkZGO3N0cm9rZS13aWR0aDoyMDt9LnN0MntmaWxsOiMwMDk3OUM7c3Ryb2tlOiNGRkZGRkY7c3Ryb2tlLXdpZHRoOjIzLjYxOTt9PC9zdHlsZT48ZyBpZD0iZzQiPjxwYXRoIGlkPSJwYXRoNiIgY2xhc3M9InN0MCIgZD0iTTE3NS41LDMwQzk1LjIsMzAsMzAsOTIuNywzMCwxNzBzNjUuMiwxNDAsMTQ1LjUsMTQwYzE5MCwxMCwxNzAtMjgwLDM3MC0yODBDNjI1LjksMzAsNjkxLDkyLjcsNjkxLDE3MHMtNjUuMiwxNDAtMTQ1LjUsMTQwQzM1NS41LDMyMCwzNzUuNSwzMCwxNzUuNSwzMCIvPjwvZz48ZyBpZD0iZzgiIHRyYW5zZm9ybT0idHJhbnNsYXRlKDAsMTApIj48ZyBpZD0idGV4dDEwIj48cGF0aCBpZD0icGF0aDMwNzUiIGNsYXNzPSJzdDEiIGQ9Ik01MjkuNiwxOTQuN3YtMzIuOGgtMzIuNXYtMTMuN2gzMi41di0zMi41aDEzLjl2MzIuNUg1NzZ2MTMuN2gtMzIuNXYzMi44SDUyOS42eiIvPjwvZz48L2c+PGcgaWQ9Imc4LTEiIHRyYW5zZm9ybT0idHJhbnNsYXRlKC0zNjUuNzk0NTIsMC41Mjc3MzQ0NikiPjxnIGlkPSJ0ZXh0MTAtNyIgdHJhbnNmb3JtPSJzY2FsZSgxLjU2NDU5NzQsMC42MzkxNDIwNikiPjxwYXRoIGlkPSJwYXRoMzA3OCIgY2xhc3M9InN0MiIgZD0iTTMyMi40LDI2Ni4zdi0xNy40aDUzLjN2MTcuNEgzMjIuNHoiLz48L2c+PGcgaWQ9InRleHQxMi00Ij48L2c+PC9nPjwvc3ZnPg==)](https://www.arduino.cc/en/Guide/Libraries#toc3)
[![GitHub version](https://img.shields.io/github/release/MattFryer/Smoothed.svg?logo=github&logoColor=ffffff)](https://github.com/MattFryer/Smoothed/releases/latest)
[![GitHub Release Date](https://img.shields.io/github/release-date/MattFryer/Smoothed.svg?logo=github&logoColor=ffffff)](https://github.com/MattFryer/Smoothed/releases/latest)
[![GitHub download](https://img.shields.io/github/downloads/MattFryer/Smoothed/total.svg?logo=github&logoColor=ffffff)](https://github.com/MattFryer/Smoothed/releases/latest)
[![GitHub stars](https://img.shields.io/github/stars/MattFryer/Smoothed.svg?logo=github&logoColor=ffffff)](https://github.com/MattFryer/Smoothed/stargazers)
[![GitHub issues](https://img.shields.io/github/issues/MattFryer/Smoothed.svg?logo=github&logoColor=ffffff)](https://github.com/MattFryer/Smoothed/issues)
[![Codacy grade](https://img.shields.io/codacy/grade/d19ea847574d443a8433655ee1d17843.svg?logo=codacy&logoColor=ffffff)](https://www.codacy.com/app/MattFryer/Smoothed)
[![GitHub license](https://img.shields.io/github/license/MattFryer/Smoothed.svg?logo=gnu&logoColor=ffffff)](https://github.com/MattFryer/Smoothed/blob/master/LICENSE)

# Smoothed
An Arduino library to store and smooth sensor inputs using various methods including:
*  a simple moving average of the last x sensor readings
*  a simple linear recursive exponential filter

Unlike many other smoothing/filtering libraries, Smoothed uses a template class to ensure sensor readings in any numerical data type can be handled. This makes it both lightweight and flexible.

## How to Install
Smoothed can be installed from the Arduino IDE Library Manager. For more details on how to install libraries in the Arduino IDE, please see the [Arduino website](https://www.arduino.cc/en/Guide/Libraries).

## How to Use
A full example of using each smoothing method is provided with the library and can be found in the Arduino IDE under "File->Examples->Smoothed".

Firstly, you must include the library in your sketch:
```cpp
#include <Smoothed.h>
```

Next, create an instance of the class defining what data type to use. The example below uses a type of float:
```cpp
Smoothed <float> mySensor;
```
You can replace float with any numeric data type to suit your sensor readings and desired accuracy. See the included library example for a full list of supported data types.

Within the setup function, initialize the instance, defining the smoothing method and accuracy:
```cpp
mySensor.begin(SMOOTHED_AVERAGE, 10);
```
In the above example we are using a simple average of the last 10 sensor readings.

And finally, write in a new sensor value and read the smoothed result:
```cpp
// Read a sensor value from analogue pin 0
mySensor.add(analogRead(SENSOR_PIN));

// Output the smoothed sensor value to the serial
Serial.println(mySensor.get());
```

## Planned Improvements/Changes
1.  Add a multi-sample method. Calls a passed function to obtain the sensor value x times and averages out.
2.  Add a Savitzky Golay filter.
3.  Add a running median filter. Best method to eliminate random spikes in an otherwise stable signal. Need to work out how to handle different data types. Rounding maybe??
4.  Publishing to the Arduino IDE Library list.
