# MatrixR4 Arduino Library
![image](https://github.com/user-attachments/assets/dec8c30b-74de-4f48-a31c-385b24e0a427)

MATRIX R4 (Mini R4) is an Arduino Uno R4 WiFi based robot controller for MA300, MAFI900 Series.
The Matrix R4 integrates STM32 processing, compact 6-axis IMU Gyro and advanced motor contol, providing a versatile platform for quickly building Arduino-based robots. From simple line-followers to omni-directional platforms, it makes turning ideas into robots fast and easy.

## Features
- Built-in STM32 for motor control and 6-axis IMU processing<br>
- Built-in WiFi and Bluetooth support<br>
- Support 4 channel/360 angle RC Servo control.<br>
- Support 4 channel/8-bit full-bridge DC motor control with encoder feedback.<br>
- Support 4 channel Digital I/O.<br>
- Support 3 channel Analog I/O.<br>
- Support 4 channel independent I2C Interface.<br>
- Support 2 channel UART Interface (USB Serial and UART Serial).<br>
- Support 2 buttons and OLED Screen.<br>
- Battery voltage monitor status LED.<br>

## Repository Contents
* [**/docs**](./docs) - Library API documentation.
* [**/examples**](./examples) - Example sketches for the library (.ino). Run these by Arduino IDE.
* [**/src**](./src) - Source files for the library (.cpp, .h).

## Documentation
[MatrixMiniR4 Library API documentation](https://matrix-robotics.github.io/Programming-API-Docs/MiniR4_Arduino_Lib_API_Docs/)

[MATRIX Official Website](https://matrixrobotics.com/)

## License
MIT
