/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

/**
 * u8g_font_data.c
 */

#include "u8g.h"

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--20-200-75-75-C-100-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 5, '1' Height: 13
  Calculated Max Values w=10 h=20 x= 9 y=13 dx=10 dy= 0 ascent=16 len=40
  Font Bounding box     w=10 h=20 x= 0 y=-4
  Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
  Pure Font   ascent = 5 descent= 0
  X Font      ascent =13 descent= 0
  Max Font    ascent =16 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_10x20_67_75[4734] U8G_FONT_SECTION("u8g_font_10x20_67_75") = {
  0, 10, 20, 0, 252, 5, 2, 211, 5, 193, 32, 255, 0, 16, 252, 13,
  0, 9, 6, 12, 10, 0, 3, 54, 0, 27, 0, 255, 128, 255, 128, 27,
  0, 54, 0, 8, 13, 13, 10, 1, 0, 24, 24, 24, 24, 153, 219, 126,
  60, 153, 219, 126, 60, 24, 9, 8, 16, 10, 0, 2, 25, 128, 51, 0,
  102, 0, 252, 0, 252, 0, 102, 0, 51, 0, 25, 128, 9, 8, 16, 10,
  0, 2, 204, 0, 102, 0, 51, 0, 31, 128, 31, 128, 51, 0, 102, 0,
  204, 0, 9, 8, 16, 10, 0, 2, 25, 128, 49, 128, 97, 128, 255, 128,
  255, 128, 97, 128, 49, 128, 25, 128, 8, 13, 13, 10, 1, 0, 24, 60,
  126, 219, 153, 24, 24, 24, 24, 24, 24, 255, 255, 9, 8, 16, 10, 0,
  2, 204, 0, 198, 0, 195, 0, 255, 128, 255, 128, 195, 0, 198, 0, 204,
  0, 8, 13, 13, 10, 1, 0, 255, 255, 24, 24, 24, 24, 24, 24, 153,
  219, 126, 60, 24, 8, 13, 13, 10, 1, 0, 24, 60, 126, 219, 153, 24,
  153, 219, 126, 60, 24, 255, 255, 9, 8, 16, 10, 0, 2, 27, 0, 51,
  128, 97, 128, 255, 128, 255, 0, 96, 0, 48, 0, 24, 0, 9, 8, 16,
  10, 0, 2, 108, 0, 230, 0, 195, 0, 255, 128, 127, 128, 3, 0, 6,
  0, 12, 0, 9, 8, 16, 10, 0, 2, 25, 0, 51, 128, 98, 128, 255,
  128, 255, 0, 98, 0, 50, 0, 24, 0, 9, 8, 16, 10, 0, 2, 76,
  0, 230, 0, 163, 0, 255, 128, 127, 128, 35, 0, 38, 0, 12, 0, 10,
  8, 16, 10, 0, 2, 18, 0, 51, 0, 109, 128, 255, 192, 243, 192, 97,
  128, 51, 0, 18, 0, 10, 8, 16, 10, 0, 2, 18, 0, 55, 0, 101,
  128, 255, 192, 255, 192, 105, 128, 59, 0, 18, 0, 10, 15, 30, 10, 0,
  0, 1, 192, 3, 128, 7, 0, 14, 0, 28, 0, 63, 192, 127, 192, 3,
  128, 7, 0, 206, 0, 220, 0, 248, 0, 240, 0, 252, 0, 252, 0, 8,
  13, 13, 10, 1, 0, 48, 96, 255, 255, 99, 51, 3, 3, 3, 3, 3,
  3, 3, 8, 13, 13, 10, 1, 0, 12, 6, 255, 255, 198, 204, 192, 192,
  192, 192, 192, 192, 192, 8, 13, 13, 10, 1, 0, 3, 3, 3, 3, 3,
  3, 3, 51, 99, 255, 255, 96, 48, 8, 13, 13, 10, 1, 0, 192, 192,
  192, 192, 192, 192, 192, 204, 198, 255, 255, 6, 12, 8, 13, 13, 10, 1,
  0, 252, 252, 12, 12, 12, 12, 12, 12, 12, 45, 63, 30, 12, 8, 9,
  9, 10, 1, 1, 3, 3, 3, 51, 99, 255, 255, 96, 48, 9, 8, 16,
  10, 0, 0, 14, 0, 31, 0, 59, 128, 49, 128, 181, 128, 253, 128, 121,
  128, 49, 128, 9, 8, 16, 10, 0, 0, 56, 0, 124, 0, 238, 0, 198,
  0, 214, 128, 223, 128, 207, 0, 198, 0, 9, 13, 26, 10, 0, 0, 255,
  128, 255, 128, 32, 0, 124, 0, 127, 0, 122, 0, 216, 0, 204, 0, 140,
  0, 6, 0, 6, 0, 3, 0, 3, 0, 9, 13, 26, 10, 0, 0, 204,
  0, 216, 0, 255, 128, 255, 128, 216, 0, 204, 0, 0, 0, 25, 128, 13,
  128, 255, 128, 255, 128, 13, 128, 25, 128, 9, 10, 20, 10, 0, 2, 31,
  0, 31, 0, 30, 0, 31, 0, 219, 128, 193, 128, 193, 128, 227, 128, 127,
  0, 62, 0, 9, 10, 20, 10, 0, 2, 124, 0, 124, 0, 60, 0, 124,
  0, 237, 128, 193, 128, 193, 128, 227, 128, 127, 0, 62, 0, 9, 5, 10,
  10, 0, 5, 24, 0, 48, 0, 96, 0, 255, 128, 255, 128, 9, 5, 10,
  10, 0, 2, 255, 128, 255, 128, 96, 0, 48, 0, 24, 0, 5, 13, 13,
  10, 4, 0, 192, 224, 240, 216, 200, 192, 192, 192, 192, 192, 192, 192, 192,
  5, 13, 13, 10, 1, 0, 24, 56, 120, 216, 152, 24, 24, 24, 24, 24,
  24, 24, 24, 9, 5, 10, 10, 0, 5, 12, 0, 6, 0, 3, 0, 255,
  128, 255, 128, 9, 5, 10, 10, 0, 2, 255, 128, 255, 128, 3, 0, 6,
  0, 12, 0, 5, 13, 13, 10, 4, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 200, 216, 240, 224, 192, 5, 13, 13, 10, 1, 0, 24, 24, 24, 24,
  24, 24, 24, 24, 152, 216, 120, 56, 24, 9, 11, 22, 10, 0, 1, 6,
  0, 3, 0, 255, 128, 255, 128, 3, 0, 54, 0, 96, 0, 255, 128, 255,
  128, 96, 0, 48, 0, 10, 13, 26, 10, 0, 0, 51, 0, 123, 0, 255,
  0, 183, 0, 51, 0, 51, 0, 51, 0, 51, 0, 51, 0, 59, 64, 63,
  192, 55, 128, 51, 0, 9, 11, 22, 10, 0, 1, 48, 0, 96, 0, 255,
  128, 255, 128, 96, 0, 54, 0, 3, 0, 255, 128, 255, 128, 3, 0, 6,
  0, 9, 11, 22, 10, 0, 1, 48, 0, 96, 0, 255, 128, 255, 128, 96,
  0, 48, 0, 96, 0, 255, 128, 255, 128, 96, 0, 48, 0, 9, 13, 26,
  10, 0, 0, 34, 0, 119, 0, 170, 128, 34, 0, 34, 0, 34, 0, 34,
  0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 9, 11, 22,
  10, 0, 1, 6, 0, 3, 0, 255, 128, 255, 128, 3, 0, 6, 0, 3,
  0, 255, 128, 255, 128, 3, 0, 6, 0, 9, 13, 26, 10, 0, 0, 34,
  0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 34,
  0, 34, 0, 170, 128, 119, 0, 34, 0, 8, 9, 9, 10, 1, 2, 48,
  96, 255, 255, 0, 255, 255, 6, 12, 8, 9, 9, 10, 1, 2, 12, 6,
  255, 255, 0, 255, 255, 96, 48, 8, 7, 7, 10, 1, 2, 2, 34, 127,
  132, 127, 40, 8, 10, 7, 14, 10, 0, 2, 4, 0, 37, 0, 127, 128,
  140, 64, 127, 128, 41, 0, 8, 0, 8, 7, 7, 10, 1, 2, 16, 20,
  254, 33, 254, 68, 64, 9, 9, 18, 10, 0, 2, 12, 0, 24, 0, 63,
  128, 127, 128, 192, 0, 127, 128, 63, 128, 24, 0, 12, 0, 9, 13, 26,
  10, 0, 0, 8, 0, 28, 0, 54, 0, 119, 0, 247, 128, 182, 128, 54,
  0, 54, 0, 54, 0, 54, 0, 54, 0, 54, 0, 54, 0, 9, 9, 18,
  10, 0, 2, 24, 0, 12, 0, 254, 0, 255, 0, 1, 128, 255, 0, 254,
  0, 12, 0, 24, 0, 9, 13, 26, 10, 0, 0, 54, 0, 54, 0, 54,
  0, 54, 0, 54, 0, 54, 0, 54, 0, 182, 128, 247, 128, 119, 0, 54,
  0, 28, 0, 8, 0, 10, 9, 18, 10, 0, 2, 18, 0, 51, 0, 127,
  128, 255, 192, 128, 192, 255, 192, 127, 128, 51, 0, 18, 0, 9, 13, 26,
  10, 0, 0, 8, 0, 28, 0, 54, 0, 119, 0, 247, 128, 182, 128, 54,
  0, 182, 128, 247, 128, 119, 0, 54, 0, 28, 0, 8, 0, 9, 9, 18,
  10, 0, 2, 254, 0, 254, 0, 204, 0, 198, 0, 227, 0, 241, 128, 216,
  128, 12, 0, 6, 0, 9, 9, 18, 10, 0, 2, 63, 128, 63, 128, 25,
  128, 49, 128, 99, 128, 199, 128, 141, 128, 24, 0, 48, 0, 9, 9, 18,
  10, 0, 2, 48, 0, 24, 0, 141, 128, 199, 128, 99, 128, 49, 128, 25,
  128, 63, 128, 63, 128, 9, 9, 18, 10, 0, 2, 6, 0, 12, 0, 216,
  128, 241, 128, 227, 0, 198, 0, 204, 0, 254, 0, 254, 0, 9, 11, 22,
  10, 0, 1, 4, 0, 8, 0, 16, 0, 63, 128, 64, 0, 255, 128, 64,
  0, 63, 128, 16, 0, 8, 0, 4, 0, 9, 11, 22, 10, 0, 1, 16,
  0, 8, 0, 4, 0, 254, 0, 1, 0, 255, 128, 1, 0, 254, 0, 4,
  0, 8, 0, 16, 0, 9, 5, 10, 10, 0, 3, 32, 0, 66, 0, 245,
  128, 72, 0, 32, 0, 9, 5, 10, 10, 0, 3, 2, 0, 33, 0, 215,
  128, 9, 0, 2, 0, 8, 13, 13, 10, 1, 0, 24, 60, 126, 219, 153,
  24, 126, 126, 24, 126, 126, 24, 24, 8, 13, 13, 10, 1, 0, 24, 24,
  126, 126, 24, 126, 126, 24, 153, 219, 126, 60, 24, 9, 8, 16, 10, 0,
  2, 24, 0, 48, 0, 96, 0, 237, 128, 237, 128, 96, 0, 48, 0, 24,
  0, 8, 13, 13, 10, 1, 0, 24, 60, 126, 219, 129, 24, 24, 0, 24,
  24, 0, 24, 24, 9, 8, 16, 10, 0, 2, 12, 0, 6, 0, 3, 0,
  219, 128, 219, 128, 3, 0, 6, 0, 12, 0, 8, 13, 13, 10, 1, 0,
  24, 24, 0, 24, 24, 0, 24, 24, 129, 219, 126, 60, 24, 9, 8, 16,
  10, 0, 2, 198, 0, 204, 0, 216, 0, 255, 128, 255, 128, 216, 0, 204,
  0, 198, 0, 9, 8, 16, 10, 0, 2, 49, 128, 25, 128, 13, 128, 255,
  128, 255, 128, 13, 128, 25, 128, 49, 128, 9, 8, 16, 10, 0, 2, 24,
  0, 40, 0, 79, 128, 128, 128, 128, 128, 79, 128, 40, 0, 24, 0, 8,
  13, 13, 10, 1, 0, 24, 36, 66, 129, 231, 36, 36, 36, 36, 36, 36,
  36, 60, 9, 8, 16, 10, 0, 2, 12, 0, 10, 0, 249, 0, 128, 128,
  128, 128, 249, 0, 10, 0, 12, 0, 8, 13, 13, 10, 1, 0, 60, 36,
  36, 36, 36, 36, 36, 36, 231, 129, 66, 36, 24, 8, 13, 13, 10, 1,
  0, 24, 36, 66, 129, 231, 36, 36, 60, 0, 60, 36, 36, 60, 8, 13,
  13, 10, 1, 0, 24, 36, 66, 129, 231, 36, 36, 36, 36, 36, 231, 129,
  255, 8, 13, 13, 10, 1, 0, 24, 36, 126, 129, 231, 36, 36, 36, 36,
  36, 231, 129, 255, 9, 14, 28, 10, 0, 0, 8, 0, 28, 0, 42, 0,
  73, 0, 136, 128, 235, 128, 42, 0, 42, 0, 42, 0, 42, 0, 42, 0,
  235, 128, 136, 128, 255, 128, 8, 13, 13, 10, 1, 0, 24, 36, 90, 231,
  66, 231, 36, 36, 36, 36, 36, 36, 60, 8, 13, 13, 10, 1, 0, 24,
  36, 90, 231, 66, 231, 36, 36, 36, 36, 231, 129, 255, 9, 8, 16, 10,
  0, 2, 236, 0, 170, 0, 185, 0, 128, 128, 128, 128, 185, 0, 170, 0,
  236, 0, 8, 8, 8, 10, 1, 2, 255, 128, 188, 168, 184, 164, 130, 129,
  8, 8, 8, 10, 1, 2, 129, 65, 37, 29, 21, 61, 1, 255, 8, 13,
  13, 10, 1, 0, 24, 36, 66, 231, 36, 36, 36, 36, 36, 231, 66, 36,
  24, 9, 6, 12, 10, 0, 3, 38, 0, 83, 0, 255, 128, 255, 128, 83,
  0, 38, 0, 10, 13, 26, 10, 0, 0, 51, 0, 55, 128, 63, 192, 59,
  64, 51, 0, 51, 0, 51, 0, 51, 0, 51, 0, 183, 0, 255, 0, 123,
  0, 51, 0, 9, 16, 32, 10, 0, 254, 6, 0, 3, 0, 255, 128, 255,
  128, 3, 0, 6, 0, 3, 0, 255, 128, 255, 128, 3, 0, 6, 0, 3,
  0, 255, 128, 255, 128, 3, 0, 6, 0, 9, 8, 16, 10, 0, 2, 22,
  0, 54, 0, 102, 0, 255, 128, 255, 128, 102, 0, 54, 0, 22, 0, 9,
  8, 16, 10, 0, 2, 52, 0, 54, 0, 51, 0, 255, 128, 255, 128, 51,
  0, 54, 0, 52, 0, 10, 6, 12, 10, 0, 3, 45, 0, 109, 128, 255,
  192, 255, 192, 109, 128, 45, 0, 9, 6, 12, 10, 0, 3, 42, 0, 106,
  0, 255, 128, 255, 128, 106, 0, 42, 0, 9, 6, 12, 10, 0, 3, 42,
  0, 43, 0, 255, 128, 255, 128, 43, 0, 42, 0, 9, 6, 12, 10, 0,
  3, 85, 0, 213, 128, 255, 128, 255, 128, 213, 128, 85, 0, 9, 8, 16,
  10, 0, 2, 16, 0, 48, 0, 112, 0, 223, 128, 223, 128, 112, 0, 48,
  0, 16, 0, 9, 8, 16, 10, 0, 2, 4, 0, 6, 0, 7, 0, 253,
  128, 253, 128, 7, 0, 6, 0, 4, 0, 10, 8, 16, 10, 0, 2, 18,
  0, 51, 0, 115, 128, 222, 192, 222, 192, 115, 128, 51, 0, 18, 0, 10,
  10, 20, 10, 0, 6, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 255, 192, 10, 3, 6, 10, 0, 252, 255,
  192, 255, 192, 255, 192, 10, 5, 10, 10, 0, 252, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 10, 8, 16, 10, 0, 252, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 10, 10, 20, 10, 0,
  252, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 10, 12, 24, 10, 0, 252, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 10, 15, 30, 10, 0, 252, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 10, 17, 34, 10, 0, 252, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 10,
  20, 40, 10, 0, 252, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 9, 20, 40,
  10, 0, 252, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255,
  128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255,
  128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 7, 20, 20, 10, 0,
  252, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 6, 20, 20, 10, 0, 252, 252, 252, 252, 252, 252,
  252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 5,
  20, 20, 10, 0, 252, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 4, 20, 20, 10, 0, 252, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 3, 20, 20, 10, 0, 252, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 1, 20, 20,
  10, 0, 252, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 5, 20, 20, 10, 5, 252, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
  248, 10, 19, 38, 10, 0, 253, 85, 64, 0, 0, 170, 128, 0, 0, 85,
  64, 0, 0, 170, 128, 0, 0, 85, 64, 0, 0, 170, 128, 0, 0, 85,
  64, 0, 0, 170, 128, 0, 0, 85, 64, 0, 0, 170, 128, 10, 20, 40,
  10, 0, 252, 85, 64, 170, 128, 85, 64, 170, 128, 85, 64, 170, 128, 85,
  64, 170, 128, 85, 64, 170, 128, 85, 64, 170, 128, 85, 64, 170, 128, 85,
  64, 170, 128, 85, 64, 170, 128, 85, 64, 170, 128, 10, 20, 40, 10, 0,
  252, 85, 64, 255, 192, 170, 128, 255, 192, 85, 64, 255, 192, 170, 128, 255,
  192, 85, 64, 255, 192, 170, 128, 255, 192, 85, 64, 255, 192, 170, 128, 255,
  192, 85, 64, 255, 192, 170, 128, 255, 192, 10, 3, 6, 10, 0, 13, 255,
  192, 255, 192, 255, 192, 1, 20, 20, 10, 9, 252, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 5,
  10, 10, 10, 0, 252, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 5,
  10, 10, 10, 5, 252, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 5,
  10, 10, 10, 0, 6, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 10,
  20, 40, 10, 0, 252, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 10, 20, 40,
  10, 0, 252, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 7, 192, 7, 192, 7, 192, 7, 192, 7,
  192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 10, 20, 40, 10, 0,
  252, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 10, 20, 40, 10, 0, 252, 255,
  192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7,
  192, 7, 192, 7, 192, 7, 192, 5, 10, 10, 10, 5, 6, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 10, 20, 40, 10, 0, 252, 7, 192, 7,
  192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7,
  192, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 10, 20, 40, 10, 0, 252, 7, 192, 7, 192, 7,
  192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 8, 8, 8, 10, 1, 1, 255, 255, 255, 255, 255, 255, 255,
  255, 8, 8, 8, 10, 1, 1, 255, 129, 129, 129, 129, 129, 129, 255, 8,
  8, 8, 10, 1, 1, 126, 129, 129, 129, 129, 129, 129, 126, 8, 8, 8,
  10, 1, 1, 255, 129, 189, 189, 189, 189, 129, 255, 9, 9, 18, 10, 0,
  0, 255, 128, 128, 128, 255, 128, 128, 128, 255, 128, 128, 128, 255, 128, 128,
  128, 255, 128, 9, 9, 18, 10, 0, 0, 255, 128, 170, 128, 170, 128, 170,
  128, 170, 128, 170, 128, 170, 128, 170, 128, 255, 128, 9, 9, 18, 10, 0,
  0, 255, 128, 170, 128, 255, 128, 170, 128, 255, 128, 170, 128, 255, 128, 170,
  128, 255, 128, 8, 8, 8, 10, 1, 1, 255, 201, 165, 147, 201, 165, 147,
  255, 8, 8, 8, 10, 1, 1, 255, 147, 165, 201, 147, 165, 201, 255, 8,
  8, 8, 10, 1, 1, 255, 171, 197, 171, 145, 171, 197, 255, 4, 4, 4,
  10, 3, 3, 240, 240, 240, 240, 4, 4, 4, 10, 3, 3, 240, 144, 144,
  240, 8, 6, 6, 10, 1, 3, 255, 255, 255, 255, 255, 255, 8, 6, 6,
  10, 1, 3, 255, 129, 129, 129, 129, 255, 6, 13, 13, 10, 2, 0, 252,
  252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 6, 13, 13, 10,
  2, 0, 252, 132, 132, 132, 132, 132, 132, 132, 132, 132, 132, 132, 252, 8,
  4, 4, 10, 1, 3, 31, 62, 124, 248, 8, 4, 4, 10, 1, 3, 31,
  34, 68, 248, 8, 8, 8, 10, 1, 2, 24, 24, 60, 60, 126, 126, 255,
  255, 8, 8, 8, 10, 1, 2, 24, 24, 36, 36, 66, 66, 129, 255, 5,
  5, 5, 10, 3, 3, 32, 112, 112, 248, 248, 5, 5, 5, 10, 3, 3,
  32, 80, 80, 136, 248, 8, 8, 8, 10, 1, 2, 192, 240, 252, 255, 255,
  252, 240, 192, 8, 8, 8, 10, 1, 2, 192, 176, 140, 131, 131, 140, 176,
  192, 5, 5, 5, 10, 3, 3, 192, 240, 248, 240, 192, 5, 5, 5, 10,
  3, 3, 192, 176, 136, 176, 192, 8, 5, 5, 10, 1, 4, 224, 252, 255,
  252, 224, 8, 5, 5, 10, 1, 4, 224, 156, 131, 156, 224, 8, 8, 8,
  10, 1, 2, 255, 255, 126, 126, 60, 60, 24, 24, 8, 8, 8, 10, 1,
  2, 255, 129, 66, 66, 36, 36, 24, 24, 5, 5, 5, 10, 3, 3, 248,
  248, 112, 112, 32, 5, 5, 5, 10, 3, 3, 248, 136, 80, 80, 32, 8,
  8, 8, 10, 1, 2, 3, 15, 63, 255, 255, 63, 15, 3, 8, 8, 8,
  10, 1, 2, 3, 13, 49, 193, 193, 49, 13, 3, 5, 5, 5, 10, 3,
  3, 24, 120, 248, 120, 24, 5, 5, 5, 10, 3, 3, 24, 104, 136, 104,
  24, 8, 5, 5, 10, 1, 4, 7, 63, 255, 63, 7, 8, 5, 5, 10,
  1, 4, 7, 57, 193, 57, 7, 8, 8, 8, 10, 1, 2, 24, 60, 126,
  255, 255, 126, 60, 24, 8, 8, 8, 10, 1, 2, 24, 36, 66, 129, 129,
  66, 36, 24, 8, 8, 8, 10, 1, 2, 24, 36, 90, 189, 189, 90, 36,
  24, 8, 8, 8, 10, 1, 1, 60, 66, 153, 189, 189, 153, 66, 60, 9,
  15, 30, 10, 1, 255, 8, 0, 20, 0, 20, 0, 34, 0, 34, 0, 65,
  0, 65, 0, 128, 128, 65, 0, 65, 0, 34, 0, 34, 0, 20, 0, 20,
  0, 8, 0, 8, 8, 8, 10, 1, 1, 60, 66, 129, 129, 129, 129, 66,
  60, 7, 7, 7, 10, 1, 2, 40, 0, 130, 0, 130, 0, 40, 7, 7,
  7, 10, 1, 2, 56, 108, 170, 170, 170, 108, 56, 8, 8, 8, 10, 1,
  1, 60, 66, 153, 165, 165, 153, 66, 60, 8, 8, 8, 10, 1, 1, 60,
  126, 255, 255, 255, 255, 126, 60, 8, 8, 8, 10, 1, 1, 60, 114, 241,
  241, 241, 241, 114, 60, 8, 8, 8, 10, 1, 1, 60, 78, 143, 143, 143,
  143, 78, 60, 8, 8, 8, 10, 1, 1, 60, 66, 129, 129, 255, 255, 126,
  60, 8, 8, 8, 10, 1, 1, 60, 126, 255, 255, 129, 129, 66, 60, 8,
  8, 8, 10, 1, 1, 60, 78, 143, 143, 129, 129, 66, 60, 8, 8, 8,
  10, 1, 1, 60, 78, 143, 143, 255, 255, 126, 60, 4, 8, 8, 10, 1,
  1, 48, 112, 240, 240, 240, 240, 112, 48, 4, 8, 8, 10, 5, 1, 192,
  224, 240, 240, 240, 240, 224, 192, 10, 20, 40, 10, 0, 252, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 255, 192, 225, 192, 192, 192, 128, 64, 128,
  64, 128, 64, 128, 64, 192, 192, 225, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 10, 20, 40, 10, 0, 252, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 225, 192, 222, 192, 191, 64, 191, 64, 191,
  64, 191, 64, 222, 192, 225, 192, 255, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 10, 10, 20, 10, 0, 6, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 225, 192, 222, 192, 191, 64, 191, 64, 10, 10, 20,
  10, 0, 252, 191, 64, 191, 64, 222, 192, 225, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 4, 4, 4, 10, 1, 5, 48, 64, 128,
  128, 4, 4, 4, 10, 5, 5, 192, 32, 16, 16, 4, 4, 4, 10, 5,
  1, 16, 16, 32, 192, 4, 4, 4, 10, 1, 1, 128, 128, 64, 48, 8,
  4, 4, 10, 1, 5, 60, 66, 129, 129, 8, 4, 4, 10, 1, 1, 129,
  129, 66, 60, 10, 19, 38, 10, 0, 252, 0, 64, 0, 64, 0, 192, 0,
  192, 1, 192, 1, 192, 3, 192, 3, 192, 7, 192, 7, 192, 15, 192, 15,
  192, 31, 192, 31, 192, 63, 192, 63, 192, 127, 192, 127, 192, 255, 192, 10,
  19, 38, 10, 0, 252, 128, 0, 128, 0, 192, 0, 192, 0, 224, 0, 224,
  0, 240, 0, 240, 0, 248, 0, 248, 0, 252, 0, 252, 0, 254, 0, 254,
  0, 255, 0, 255, 0, 255, 128, 255, 128, 255, 192, 10, 19, 38, 10, 0,
  253, 255, 192, 255, 128, 255, 128, 255, 0, 255, 0, 254, 0, 254, 0, 252,
  0, 252, 0, 248, 0, 248, 0, 240, 0, 240, 0, 224, 0, 224, 0, 192,
  0, 192, 0, 128, 0, 128, 0, 10, 19, 38, 10, 0, 253, 255, 192, 127,
  192, 127, 192, 63, 192, 63, 192, 31, 192, 31, 192, 15, 192, 15, 192, 7,
  192, 7, 192, 3, 192, 3, 192, 1, 192, 1, 192, 0, 192, 0, 192, 0,
  64, 0, 64, 5, 5, 5, 10, 3, 4, 112, 136, 136, 136, 112, 8, 8,
  8, 10, 1, 1, 255, 241, 241, 241, 241, 241, 241, 255, 8, 8, 8, 10,
  1, 1, 255, 143, 143, 143, 143, 143, 143, 255, 8, 8, 8, 10, 1, 1,
  255, 253, 249, 241, 225, 193, 129, 255, 8, 8, 8, 10, 1, 1, 255, 129,
  131, 135, 143, 159, 191, 255, 9, 9, 18, 10, 0, 0, 255, 128, 136, 128,
  136, 128, 136, 128, 136, 128, 136, 128, 136, 128, 136, 128, 255, 128, 8, 8,
  8, 10, 1, 2, 24, 24, 36, 36, 90, 90, 129, 255, 8, 8, 8, 10,
  1, 2, 24, 24, 52, 52, 114, 114, 241, 255, 8, 8, 8, 10, 1, 2,
  24, 24, 44, 44, 78, 78, 143, 255, 10, 10, 20, 10, 0, 0, 30, 0,
  33, 0, 64, 128, 128, 64, 128, 64, 128, 64, 128, 64, 64, 128, 33, 0,
  30, 0, 9, 9, 18, 10, 0, 0, 255, 128, 136, 128, 136, 128, 136, 128,
  248, 128, 128, 128, 128, 128, 128, 128, 255, 128, 9, 9, 18, 10, 0, 0,
  255, 128, 128, 128, 128, 128, 128, 128, 248, 128, 136, 128, 136, 128, 136, 128,
  255, 128, 9, 9, 18, 10, 0, 0, 255, 128, 128, 128, 128, 128, 128, 128,
  143, 128, 136, 128, 136, 128, 136, 128, 255, 128, 9, 9, 18, 10, 0, 0,
  255, 128, 136, 128, 136, 128, 136, 128, 143, 128, 128, 128, 128, 128, 128, 128,
  255, 128, 9, 9, 18, 10, 0, 0, 62, 0, 73, 0, 136, 128, 136, 128,
  248, 128, 128, 128, 128, 128, 65, 0, 62, 0, 9, 9, 18, 10, 0, 0,
  62, 0, 65, 0, 128, 128, 128, 128, 248, 128, 136, 128, 136, 128, 73, 0,
  62, 0, 9, 9, 18, 10, 0, 0, 62, 0, 65, 0, 128, 128, 128, 128,
  143, 128, 136, 128, 136, 128, 73, 0, 62, 0, 9, 9, 18, 10, 0, 0,
  62, 0, 73, 0, 136, 128, 136, 128, 143, 128, 128, 128, 128, 128, 65, 0,
  62, 0, 6, 6, 6, 10, 2, 2, 252, 136, 144, 160, 192, 128, 6, 6,
  6, 10, 2, 2, 252, 68, 36, 20, 12, 4, 6, 6, 6, 10, 2, 2,
  128, 192, 160, 144, 136, 252, 6, 6, 6, 10, 2, 2, 252, 132, 132, 132,
  132, 252, 6, 6, 6, 10, 2, 2, 252, 252, 252, 252, 252, 252, 4, 4,
  4, 10, 3, 3, 240, 144, 144, 240, 4, 4, 4, 10, 3, 3, 240, 240,
  240, 240, 6, 6, 6, 10, 2, 2, 4, 12, 20, 36, 68, 252
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--20-200-75-75-C-100-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 8, '1' Height: 4
  Calculated Max Values w= 9 h=15 x= 3 y= 4 dx=10 dy= 0 ascent=14 len=30
  Font Bounding box     w=10 h=20 x= 0 y=-4
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 8 descent= 0
  X Font      ascent = 9 descent= 0
  Max Font    ascent =14 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_10x20_75r[693] U8G_FONT_SECTION("u8g_font_10x20_75r") = {
  0, 10, 20, 0, 252, 8, 1, 219, 0, 0, 32, 79, 0, 14, 255, 9,
  0, 8, 8, 8, 10, 1, 1, 255, 255, 255, 255, 255, 255, 255, 255, 8,
  8, 8, 10, 1, 1, 255, 129, 129, 129, 129, 129, 129, 255, 8, 8, 8,
  10, 1, 1, 126, 129, 129, 129, 129, 129, 129, 126, 8, 8, 8, 10, 1,
  1, 255, 129, 189, 189, 189, 189, 129, 255, 9, 9, 18, 10, 0, 0, 255,
  128, 128, 128, 255, 128, 128, 128, 255, 128, 128, 128, 255, 128, 128, 128, 255,
  128, 9, 9, 18, 10, 0, 0, 255, 128, 170, 128, 170, 128, 170, 128, 170,
  128, 170, 128, 170, 128, 170, 128, 255, 128, 9, 9, 18, 10, 0, 0, 255,
  128, 170, 128, 255, 128, 170, 128, 255, 128, 170, 128, 255, 128, 170, 128, 255,
  128, 8, 8, 8, 10, 1, 1, 255, 201, 165, 147, 201, 165, 147, 255, 8,
  8, 8, 10, 1, 1, 255, 147, 165, 201, 147, 165, 201, 255, 8, 8, 8,
  10, 1, 1, 255, 171, 197, 171, 145, 171, 197, 255, 4, 4, 4, 10, 3,
  3, 240, 240, 240, 240, 4, 4, 4, 10, 3, 3, 240, 144, 144, 240, 8,
  6, 6, 10, 1, 3, 255, 255, 255, 255, 255, 255, 8, 6, 6, 10, 1,
  3, 255, 129, 129, 129, 129, 255, 6, 13, 13, 10, 2, 0, 252, 252, 252,
  252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 6, 13, 13, 10, 2, 0,
  252, 132, 132, 132, 132, 132, 132, 132, 132, 132, 132, 132, 252, 8, 4, 4,
  10, 1, 3, 31, 62, 124, 248, 8, 4, 4, 10, 1, 3, 31, 34, 68,
  248, 8, 8, 8, 10, 1, 2, 24, 24, 60, 60, 126, 126, 255, 255, 8,
  8, 8, 10, 1, 2, 24, 24, 36, 36, 66, 66, 129, 255, 5, 5, 5,
  10, 3, 3, 32, 112, 112, 248, 248, 5, 5, 5, 10, 3, 3, 32, 80,
  80, 136, 248, 8, 8, 8, 10, 1, 2, 192, 240, 252, 255, 255, 252, 240,
  192, 8, 8, 8, 10, 1, 2, 192, 176, 140, 131, 131, 140, 176, 192, 5,
  5, 5, 10, 3, 3, 192, 240, 248, 240, 192, 5, 5, 5, 10, 3, 3,
  192, 176, 136, 176, 192, 8, 5, 5, 10, 1, 4, 224, 252, 255, 252, 224,
  8, 5, 5, 10, 1, 4, 224, 156, 131, 156, 224, 8, 8, 8, 10, 1,
  2, 255, 255, 126, 126, 60, 60, 24, 24, 8, 8, 8, 10, 1, 2, 255,
  129, 66, 66, 36, 36, 24, 24, 5, 5, 5, 10, 3, 3, 248, 248, 112,
  112, 32, 5, 5, 5, 10, 3, 3, 248, 136, 80, 80, 32, 8, 8, 8,
  10, 1, 2, 3, 15, 63, 255, 255, 63, 15, 3, 8, 8, 8, 10, 1,
  2, 3, 13, 49, 193, 193, 49, 13, 3, 5, 5, 5, 10, 3, 3, 24,
  120, 248, 120, 24, 5, 5, 5, 10, 3, 3, 24, 104, 136, 104, 24, 8,
  5, 5, 10, 1, 4, 7, 63, 255, 63, 7, 8, 5, 5, 10, 1, 4,
  7, 57, 193, 57, 7, 8, 8, 8, 10, 1, 2, 24, 60, 126, 255, 255,
  126, 60, 24, 8, 8, 8, 10, 1, 2, 24, 36, 66, 129, 129, 66, 36,
  24, 8, 8, 8, 10, 1, 2, 24, 36, 90, 189, 189, 90, 36, 24, 8,
  8, 8, 10, 1, 1, 60, 66, 153, 189, 189, 153, 66, 60, 9, 15, 30,
  10, 1, 255, 8, 0, 20, 0, 20, 0, 34, 0, 34, 0, 65, 0, 65,
  0, 128, 128, 65, 0, 65, 0, 34, 0, 34, 0, 20, 0, 20, 0, 8,
  0, 8, 8, 8, 10, 1, 1, 60, 66, 129, 129, 129, 129, 66, 60, 7,
  7, 7, 10, 1, 2, 40, 0, 130, 0, 130, 0, 40, 7, 7, 7, 10,
  1, 2, 56, 108, 170, 170, 170, 108, 56, 8, 8, 8, 10, 1, 1, 60,
  66, 153, 165, 165, 153, 66, 60, 8, 8, 8, 10, 1, 1, 60, 126, 255,
  255, 255, 255, 126, 60
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--20-200-75-75-C-100-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 0, '1' Height: 9
  Calculated Max Values w=10 h=13 x= 4 y= 5 dx=10 dy= 0 ascent=13 len=24
  Font Bounding box     w=10 h=20 x= 0 y=-4
  Calculated Min Values           x= 0 y= 0 dx= 0 dy= 0
  Pure Font   ascent = 9 descent= 0
  X Font      ascent =11 descent= 0
  Max Font    ascent =13 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_10x20_78_79[2638] U8G_FONT_SECTION("u8g_font_10x20_78_79") = {
  0, 10, 20, 0, 252, 9, 1, 212, 2, 205, 32, 255, 0, 13, 0, 11,
  0, 9, 9, 18, 10, 0, 0, 54, 0, 28, 0, 136, 128, 201, 128, 119,
  0, 201, 128, 136, 128, 28, 0, 54, 0, 9, 9, 18, 10, 0, 0, 8,
  0, 20, 0, 255, 128, 162, 128, 65, 0, 162, 128, 255, 128, 20, 0, 8,
  0, 9, 9, 18, 10, 0, 0, 8, 0, 28, 0, 8, 0, 73, 0, 255,
  128, 73, 0, 8, 0, 28, 0, 8, 0, 9, 9, 18, 10, 0, 0, 8,
  0, 28, 0, 28, 0, 107, 0, 255, 128, 107, 0, 28, 0, 28, 0, 8,
  0, 9, 9, 18, 10, 0, 0, 8, 0, 28, 0, 28, 0, 107, 0, 255,
  128, 107, 0, 28, 0, 28, 0, 8, 0, 9, 9, 18, 10, 0, 0, 8,
  0, 28, 0, 28, 0, 107, 0, 255, 128, 107, 0, 28, 0, 28, 0, 8,
  0, 9, 9, 18, 10, 0, 0, 8, 0, 28, 0, 28, 0, 127, 0, 255,
  128, 127, 0, 28, 0, 28, 0, 8, 0, 9, 9, 18, 10, 0, 0, 8,
  0, 20, 0, 20, 0, 99, 0, 128, 128, 99, 0, 20, 0, 20, 0, 8,
  0, 255, 9, 9, 18, 10, 0, 0, 8, 0, 8, 0, 20, 0, 247, 128,
  65, 0, 34, 0, 73, 0, 85, 0, 99, 0, 9, 10, 20, 10, 0, 0,
  127, 0, 247, 128, 247, 128, 227, 128, 0, 0, 128, 128, 193, 128, 201, 128,
  156, 128, 127, 0, 9, 9, 18, 10, 0, 0, 8, 0, 8, 0, 28, 0,
  227, 128, 99, 0, 34, 0, 127, 0, 119, 0, 99, 0, 255, 255, 255, 255,
  255, 8, 9, 9, 10, 0, 0, 24, 219, 255, 126, 24, 126, 255, 219, 24,
  8, 9, 9, 10, 0, 0, 24, 219, 255, 102, 36, 102, 255, 219, 24, 9,
  9, 18, 10, 0, 0, 8, 0, 73, 0, 42, 0, 28, 0, 255, 128, 28,
  0, 42, 0, 73, 0, 8, 0, 9, 9, 18, 10, 0, 0, 8, 0, 73,
  0, 62, 0, 62, 0, 255, 128, 62, 0, 62, 0, 73, 0, 8, 0, 7,
  7, 7, 10, 1, 0, 16, 146, 124, 56, 124, 146, 16, 9, 9, 18, 10,
  0, 0, 34, 0, 20, 0, 148, 128, 127, 0, 28, 0, 127, 0, 148, 128,
  20, 0, 34, 0, 255, 255, 255, 255, 9, 11, 22, 10, 0, 0, 28, 0,
  28, 0, 201, 128, 201, 128, 62, 0, 28, 0, 62, 0, 201, 128, 201, 128,
  28, 0, 28, 0, 9, 11, 22, 10, 0, 0, 28, 0, 28, 0, 201, 128,
  201, 128, 62, 0, 28, 0, 62, 0, 201, 128, 201, 128, 28, 0, 28, 0,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  9, 8, 16, 10, 0, 1, 62, 0, 67, 0, 129, 128, 129, 128, 129, 128,
  129, 128, 67, 0, 62, 0, 255, 9, 9, 18, 10, 0, 0, 254, 0, 130,
  0, 131, 128, 131, 128, 131, 128, 131, 128, 255, 128, 63, 128, 63, 128, 9,
  9, 18, 10, 0, 0, 63, 128, 63, 128, 255, 128, 131, 128, 131, 128, 131,
  128, 131, 128, 130, 0, 254, 0, 8, 8, 8, 10, 0, 0, 254, 131, 131,
  131, 131, 131, 255, 127, 8, 8, 8, 10, 0, 0, 127, 255, 131, 131, 131,
  131, 131, 254, 255, 255, 255, 9, 9, 18, 10, 0, 0, 8, 0, 28, 0,
  28, 0, 107, 0, 247, 128, 107, 0, 28, 0, 28, 0, 8, 0, 255, 1,
  10, 10, 10, 4, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 2,
  10, 10, 10, 3, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 3,
  10, 10, 10, 3, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 4,
  6, 6, 10, 3, 5, 112, 128, 224, 240, 240, 96, 4, 6, 6, 10, 3,
  5, 96, 240, 240, 112, 16, 224, 9, 6, 12, 10, 0, 5, 115, 128, 132,
  0, 231, 0, 247, 128, 247, 128, 99, 0, 9, 6, 12, 10, 0, 5, 99,
  0, 247, 128, 247, 128, 115, 128, 16, 128, 231, 0, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 9, 9, 18, 10, 0, 0, 127, 0, 247, 128, 231, 128, 247, 128,
  247, 128, 247, 128, 247, 128, 227, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 227, 128, 221, 128, 253, 128, 251, 128, 247, 128, 237, 128, 193, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 227, 128, 221, 128, 253, 128,
  243, 128, 253, 128, 221, 128, 227, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 243, 128, 235, 128, 219, 128, 193, 128, 251, 128, 251, 128, 241, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 193, 128, 223, 128, 223, 128,
  195, 128, 253, 128, 253, 128, 195, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 225, 128, 223, 128, 223, 128, 195, 128, 221, 128, 221, 128, 227, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 193, 128, 253, 128, 251, 128,
  251, 128, 247, 128, 247, 128, 247, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 227, 128, 221, 128, 221, 128, 227, 128, 221, 128, 221, 128, 227, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 225, 128, 221, 128, 221, 128,
  225, 128, 253, 128, 253, 128, 227, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 219, 128, 213, 128, 213, 128, 213, 128, 213, 128, 213, 128, 219, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 128, 128, 136, 128, 152, 128,
  136, 128, 136, 128, 156, 128, 128, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 128, 128, 152, 128, 132, 128, 132, 128, 136, 128, 156, 128, 128, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 128, 128, 152, 128, 132, 128,
  136, 128, 132, 128, 152, 128, 128, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 128, 128, 136, 128, 152, 128, 168, 128, 188, 128, 136, 128, 128, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 128, 128, 156, 128, 144, 128,
  152, 128, 132, 128, 152, 128, 128, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 128, 128, 140, 128, 144, 128, 152, 128, 148, 128, 136, 128, 128, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 128, 128, 156, 128, 132, 128,
  136, 128, 136, 128, 136, 128, 128, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 128, 128, 136, 128, 148, 128, 136, 128, 148, 128, 136, 128, 128, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 128, 128, 136, 128, 148, 128,
  140, 128, 132, 128, 136, 128, 128, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 128, 128, 164, 128, 170, 128, 170, 128, 170, 128, 164, 128, 128, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 247, 128, 231, 128, 247, 128,
  247, 128, 247, 128, 247, 128, 247, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 227, 128, 221, 128, 253, 128, 251, 128, 247, 128, 239, 128, 193, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 227, 128, 221, 128, 253, 128,
  243, 128, 253, 128, 221, 128, 227, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 243, 128, 235, 128, 219, 128, 193, 128, 251, 128, 251, 128, 251, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 193, 128, 223, 128, 223, 128,
  195, 128, 253, 128, 253, 128, 195, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 225, 128, 223, 128, 223, 128, 195, 128, 221, 128, 221, 128, 227, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 193, 128, 253, 128, 251, 128,
  251, 128, 247, 128, 247, 128, 247, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 227, 128, 221, 128, 221, 128, 227, 128, 221, 128, 221, 128, 227, 128,
  127, 0, 9, 9, 18, 10, 0, 0, 127, 0, 225, 128, 221, 128, 221, 128,
  225, 128, 253, 128, 253, 128, 227, 128, 127, 0, 9, 9, 18, 10, 0, 0,
  127, 0, 219, 128, 213, 128, 213, 128, 213, 128, 213, 128, 213, 128, 219, 128,
  127, 0, 7, 8, 8, 10, 1, 1, 48, 24, 12, 254, 254, 12, 24, 48,
  255, 255, 255, 7, 5, 5, 10, 1, 1, 224, 250, 62, 14, 30, 8, 7,
  7, 10, 1, 1, 8, 12, 230, 255, 230, 12, 8, 7, 5, 5, 10, 1,
  1, 30, 14, 62, 250, 224, 9, 7, 14, 10, 0, 0, 48, 0, 28, 0,
  31, 0, 255, 128, 31, 0, 28, 0, 48, 0, 9, 9, 18, 10, 0, 0,
  28, 0, 30, 0, 15, 0, 255, 128, 255, 128, 255, 128, 15, 0, 30, 0,
  28, 0, 9, 5, 10, 10, 0, 1, 2, 0, 3, 0, 255, 128, 3, 0,
  2, 0, 9, 7, 14, 10, 0, 0, 4, 0, 6, 0, 255, 0, 255, 128,
  255, 0, 6, 0, 4, 0, 9, 5, 10, 10, 0, 1, 2, 0, 183, 0,
  183, 128, 183, 0, 2, 0, 9, 5, 10, 10, 0, 1, 2, 0, 171, 0,
  171, 128, 171, 0, 2, 0, 9, 5, 10, 10, 0, 1, 2, 0, 255, 0,
  255, 128, 255, 0, 2, 0, 9, 8, 16, 10, 0, 1, 128, 0, 112, 0,
  78, 0, 33, 128, 31, 128, 62, 0, 112, 0, 128, 0, 9, 8, 16, 10,
  0, 1, 128, 0, 112, 0, 62, 0, 31, 128, 33, 128, 78, 0, 112, 0,
  128, 0, 9, 8, 16, 10, 0, 1, 128, 0, 112, 0, 62, 0, 31, 128,
  31, 128, 62, 0, 112, 0, 128, 0, 9, 7, 14, 10, 0, 0, 132, 0,
  134, 0, 255, 0, 255, 128, 127, 0, 6, 0, 4, 0, 9, 7, 14, 10,
  0, 0, 4, 0, 6, 0, 127, 0, 255, 128, 255, 0, 134, 0, 132, 0,
  6, 9, 9, 10, 2, 0, 16, 16, 248, 248, 252, 248, 248, 16, 16, 8,
  9, 9, 10, 0, 1, 4, 4, 254, 254, 255, 254, 254, 4, 4, 9, 9,
  18, 10, 0, 0, 24, 0, 28, 0, 22, 0, 243, 0, 129, 128, 243, 0,
  22, 0, 28, 0, 24, 0, 9, 9, 18, 10, 0, 0, 24, 0, 28, 0,
  26, 0, 249, 0, 192, 128, 249, 0, 26, 0, 28, 0, 24, 0, 9, 9,
  18, 10, 0, 0, 0, 128, 1, 128, 62, 128, 64, 128, 129, 128, 243, 0,
  238, 0, 60, 0, 56, 0, 9, 9, 18, 10, 0, 0, 56, 0, 60, 0,
  238, 0, 243, 0, 129, 128, 64, 128, 62, 128, 1, 128, 0, 128, 8, 9,
  9, 10, 0, 1, 16, 24, 20, 242, 129, 243, 118, 28, 24, 8, 9, 9,
  10, 0, 1, 24, 28, 118, 243, 129, 242, 20, 24, 16, 9, 8, 16, 10,
  0, 1, 4, 0, 250, 0, 129, 0, 64, 128, 129, 128, 251, 0, 6, 0,
  4, 0, 255, 9, 8, 16, 10, 0, 2, 4, 0, 6, 0, 251, 0, 129,
  128, 64, 128, 129, 0, 250, 0, 4, 0, 9, 9, 18, 10, 0, 1, 28,
  0, 127, 0, 251, 128, 1, 128, 0, 128, 1, 128, 251, 128, 127, 0, 28,
  0, 9, 5, 10, 10, 0, 3, 210, 0, 43, 0, 127, 128, 43, 0, 210,
  0, 9, 9, 18, 10, 0, 0, 16, 0, 56, 0, 92, 0, 236, 0, 116,
  0, 60, 0, 2, 128, 1, 128, 3, 128, 9, 5, 10, 10, 0, 2, 242,
  0, 123, 0, 7, 128, 123, 0, 242, 0, 9, 9, 18, 10, 0, 0, 3,
  128, 1, 128, 2, 128, 60, 0, 116, 0, 236, 0, 92, 0, 56, 0, 16,
  0, 9, 9, 18, 10, 0, 0, 16, 0, 24, 0, 28, 0, 252, 0, 124,
  0, 60, 0, 2, 128, 1, 128, 3, 128, 9, 5, 10, 10, 0, 2, 242,
  0, 123, 0, 127, 128, 123, 0, 242, 0, 9, 9, 18, 10, 0, 0, 3,
  128, 1, 128, 2, 128, 60, 0, 124, 0, 252, 0, 28, 0, 24, 0, 16,
  0, 255, 255, 255, 255, 9, 7, 14, 10, 0, 1, 20, 0, 10, 0, 253,
  0, 0, 128, 253, 0, 10, 0, 20, 0, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 9,
  12, 24, 10, 0, 0, 224, 128, 49, 128, 49, 128, 42, 128, 42, 128, 36,
  128, 36, 128, 42, 128, 42, 128, 49, 128, 49, 128, 224, 128, 9, 12, 24,
  10, 0, 0, 131, 128, 198, 0, 198, 0, 170, 0, 170, 0, 146, 0, 146,
  0, 170, 0, 170, 0, 198, 0, 198, 0, 131, 128, 9, 12, 24, 10, 0,
  0, 193, 128, 99, 0, 99, 0, 85, 0, 85, 0, 73, 0, 73, 0, 85,
  0, 85, 0, 99, 0, 99, 0, 193, 128, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 8, 13, 13, 10, 1, 0, 255, 216, 216,
  216, 216, 216, 216, 216, 216, 216, 216, 216, 255, 8, 13, 13, 10, 1, 0,
  255, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 255, 4, 13, 13,
  10, 4, 0, 16, 48, 32, 96, 64, 192, 128, 192, 64, 96, 32, 48, 16,
  4, 13, 13, 10, 4, 0, 128, 192, 64, 96, 32, 48, 16, 48, 32, 96,
  64, 192, 128, 7, 13, 13, 10, 1, 0, 18, 54, 36, 108, 72, 216, 144,
  216, 72, 108, 36, 54, 18, 7, 13, 13, 10, 2, 0, 144, 216, 72, 108,
  36, 54, 18, 54, 36, 108, 72, 216, 144, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 10, 8, 16, 10, 0, 2, 24, 0, 48, 0, 96, 0, 255, 192,
  255, 192, 96, 0, 48, 0, 24, 0, 10, 8, 16, 10, 0, 2, 6, 0,
  3, 0, 1, 128, 255, 192, 255, 192, 1, 128, 3, 0, 6, 0, 10, 8,
  16, 10, 0, 2, 18, 0, 51, 0, 97, 128, 255, 192, 255, 192, 97, 128,
  51, 0, 18, 0, 10, 9, 18, 10, 0, 2, 12, 0, 24, 0, 63, 192,
  127, 192, 192, 0, 127, 192, 63, 192, 24, 0, 12, 0, 10, 9, 18, 10,
  0, 2, 12, 0, 6, 0, 255, 0, 255, 128, 0, 192, 255, 128, 255, 0,
  6, 0, 12, 0, 10, 9, 18, 10, 0, 2, 18, 0, 51, 0, 127, 128,
  255, 192, 128, 192, 255, 192, 127, 128, 51, 0, 18, 0, 10, 8, 16, 10,
  0, 2, 24, 192, 48, 192, 96, 192, 255, 192, 255, 192, 96, 192, 48, 192,
  24, 192, 10, 8, 16, 10, 0, 2, 198, 0, 195, 0, 193, 128, 255, 192,
  255, 192, 193, 128, 195, 0, 198, 0, 10, 9, 18, 10, 0, 2, 12, 64,
  24, 64, 63, 192, 127, 192, 192, 64, 127, 192, 63, 192, 24, 64, 12, 64,
  10, 9, 18, 10, 0, 2, 140, 0, 134, 0, 255, 0, 255, 128, 128, 192,
  255, 128, 255, 0, 134, 0, 140, 0, 10, 8, 16, 10, 0, 2, 6, 0,
  3, 0, 171, 128, 170, 192, 85, 192, 85, 128, 3, 0, 6, 0
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--20-200-75-75-C-100-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 13, '1' Height: 13
  Calculated Max Values w= 9 h=17 x= 4 y=16 dx=10 dy= 0 ascent=16 len=26
  Font Bounding box     w=10 h=20 x= 0 y=-4
  Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
  Pure Font   ascent =13 descent=-4
  X Font      ascent =13 descent=-4
  Max Font    ascent =16 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_10x20[3453] U8G_FONT_SECTION("u8g_font_10x20") = {
  0, 10, 20, 0, 252, 13, 2, 74, 4, 153, 32, 255, 252, 16, 252, 13,
  252, 0, 0, 0, 10, 0, 16, 2, 13, 13, 10, 4, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 0, 192, 192, 6, 4, 4, 10, 2, 9,
  204, 204, 204, 72, 9, 11, 22, 10, 1, 1, 27, 0, 27, 0, 27, 0,
  127, 128, 54, 0, 54, 0, 54, 0, 255, 0, 108, 0, 108, 0, 108, 0,
  8, 13, 13, 10, 1, 0, 24, 126, 219, 216, 216, 216, 126, 27, 27, 27,
  219, 126, 24, 9, 12, 24, 10, 1, 0, 115, 0, 219, 0, 222, 0, 118,
  0, 12, 0, 12, 0, 24, 0, 24, 0, 55, 0, 61, 128, 109, 128, 103,
  0, 9, 13, 26, 10, 1, 0, 56, 0, 108, 0, 108, 0, 108, 0, 120,
  0, 48, 0, 112, 0, 216, 0, 205, 128, 199, 0, 198, 0, 239, 0, 121,
  128, 2, 5, 5, 10, 4, 8, 192, 192, 192, 192, 128, 5, 13, 13, 10,
  3, 0, 24, 48, 96, 96, 192, 192, 192, 192, 192, 96, 96, 48, 24, 5,
  13, 13, 10, 2, 0, 192, 96, 48, 48, 24, 24, 24, 24, 24, 48, 48,
  96, 192, 8, 7, 7, 10, 1, 3, 102, 102, 60, 255, 60, 102, 102, 8,
  7, 7, 10, 1, 3, 24, 24, 24, 255, 24, 24, 24, 4, 3, 3, 10,
  3, 255, 112, 112, 224, 8, 1, 1, 10, 1, 6, 255, 3, 3, 3, 10,
  4, 0, 224, 224, 224, 7, 12, 12, 10, 2, 0, 6, 6, 12, 12, 24,
  24, 48, 48, 96, 96, 192, 192, 8, 13, 13, 10, 1, 0, 24, 60, 102,
  102, 195, 195, 195, 195, 195, 102, 102, 60, 24, 8, 13, 13, 10, 1, 0,
  24, 56, 120, 216, 24, 24, 24, 24, 24, 24, 24, 24, 255, 8, 13, 13,
  10, 1, 0, 60, 102, 195, 195, 3, 3, 6, 28, 48, 96, 192, 192, 255,
  8, 13, 13, 10, 1, 0, 60, 102, 195, 195, 3, 6, 28, 6, 3, 195,
  195, 102, 60, 8, 13, 13, 10, 1, 0, 2, 6, 14, 30, 54, 102, 198,
  198, 255, 6, 6, 6, 6, 8, 13, 13, 10, 1, 0, 255, 192, 192, 192,
  192, 220, 230, 3, 3, 3, 195, 102, 60, 8, 13, 13, 10, 1, 0, 60,
  102, 194, 192, 192, 220, 230, 195, 195, 195, 195, 102, 60, 8, 13, 13, 10,
  1, 0, 255, 3, 3, 6, 6, 12, 12, 24, 24, 48, 48, 96, 96, 8,
  13, 13, 10, 1, 0, 60, 102, 195, 195, 195, 102, 60, 102, 195, 195, 195,
  102, 60, 8, 13, 13, 10, 1, 0, 60, 102, 195, 195, 195, 195, 103, 59,
  3, 3, 67, 102, 60, 3, 8, 8, 10, 4, 0, 224, 224, 0, 0, 0,
  0, 224, 224, 4, 9, 9, 10, 3, 255, 112, 112, 0, 0, 0, 0, 112,
  112, 224, 7, 13, 13, 10, 1, 0, 2, 6, 12, 24, 48, 96, 192, 96,
  48, 24, 12, 6, 2, 8, 6, 6, 10, 1, 3, 255, 0, 0, 0, 0,
  255, 7, 13, 13, 10, 2, 0, 128, 192, 96, 48, 24, 12, 6, 12, 24,
  48, 96, 192, 128, 8, 13, 13, 10, 1, 0, 60, 102, 195, 195, 195, 6,
  12, 24, 24, 24, 0, 24, 24, 8, 13, 13, 10, 1, 0, 60, 102, 195,
  207, 223, 219, 219, 219, 222, 204, 192, 99, 62, 8, 13, 13, 10, 1, 0,
  24, 60, 102, 102, 195, 195, 195, 255, 195, 195, 195, 195, 195, 8, 13, 13,
  10, 1, 0, 248, 204, 198, 198, 198, 204, 252, 198, 195, 195, 195, 198, 252,
  8, 13, 13, 10, 1, 0, 60, 102, 195, 192, 192, 192, 192, 192, 192, 192,
  195, 102, 60, 8, 13, 13, 10, 1, 0, 252, 198, 195, 195, 195, 195, 195,
  195, 195, 195, 195, 198, 252, 8, 13, 13, 10, 1, 0, 255, 192, 192, 192,
  192, 192, 252, 192, 192, 192, 192, 192, 255, 8, 13, 13, 10, 1, 0, 255,
  192, 192, 192, 192, 192, 252, 192, 192, 192, 192, 192, 192, 8, 13, 13, 10,
  1, 0, 60, 102, 195, 192, 192, 192, 207, 195, 195, 195, 195, 103, 61, 8,
  13, 13, 10, 1, 0, 195, 195, 195, 195, 195, 195, 255, 195, 195, 195, 195,
  195, 195, 8, 13, 13, 10, 1, 0, 255, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 255, 9, 13, 26, 10, 1, 0, 31, 128, 6, 0, 6,
  0, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 198, 0, 198,
  0, 108, 0, 56, 0, 8, 13, 13, 10, 1, 0, 195, 195, 198, 198, 204,
  204, 248, 204, 204, 198, 198, 195, 195, 8, 13, 13, 10, 1, 0, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 8, 13, 13, 10, 1,
  0, 195, 195, 231, 231, 255, 219, 219, 219, 219, 195, 195, 195, 195, 8, 13,
  13, 10, 1, 0, 195, 227, 227, 243, 243, 219, 219, 207, 207, 199, 199, 195,
  195, 8, 13, 13, 10, 1, 0, 60, 102, 195, 195, 195, 195, 195, 195, 195,
  195, 195, 102, 60, 8, 13, 13, 10, 1, 0, 252, 198, 195, 195, 195, 195,
  198, 252, 192, 192, 192, 192, 192, 8, 14, 14, 10, 1, 255, 60, 102, 195,
  195, 195, 195, 195, 195, 195, 219, 207, 102, 62, 3, 8, 13, 13, 10, 1,
  0, 252, 198, 195, 195, 195, 195, 198, 252, 204, 198, 198, 195, 195, 8, 13,
  13, 10, 1, 0, 60, 102, 195, 192, 192, 96, 60, 6, 3, 3, 195, 102,
  60, 8, 13, 13, 10, 1, 0, 255, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 8, 13, 13, 10, 1, 0, 195, 195, 195, 195, 195, 195,
  195, 195, 195, 195, 195, 102, 60, 8, 13, 13, 10, 1, 0, 195, 195, 195,
  195, 102, 102, 102, 60, 60, 60, 24, 24, 24, 8, 13, 13, 10, 1, 0,
  195, 195, 195, 195, 195, 219, 219, 219, 219, 231, 231, 195, 195, 8, 13, 13,
  10, 1, 0, 195, 195, 102, 102, 60, 60, 24, 60, 60, 102, 102, 195, 195,
  8, 13, 13, 10, 1, 0, 195, 195, 102, 102, 60, 60, 24, 24, 24, 24,
  24, 24, 24, 8, 13, 13, 10, 1, 0, 255, 3, 3, 6, 12, 12, 24,
  48, 48, 96, 192, 192, 255, 6, 13, 13, 10, 2, 0, 252, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 252, 7, 12, 12, 10, 2, 0, 192,
  192, 96, 96, 48, 48, 24, 24, 12, 12, 6, 6, 6, 13, 13, 10, 2,
  0, 252, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 252, 8, 4,
  4, 10, 1, 9, 24, 60, 102, 195, 9, 1, 2, 10, 1, 255, 255, 128,
  4, 3, 3, 10, 3, 10, 192, 96, 48, 8, 8, 8, 10, 1, 0, 62,
  99, 3, 127, 195, 195, 195, 125, 8, 13, 13, 10, 1, 0, 192, 192, 192,
  192, 192, 220, 230, 195, 195, 195, 195, 230, 220, 8, 8, 8, 10, 1, 0,
  62, 99, 192, 192, 192, 192, 99, 62, 8, 13, 13, 10, 1, 0, 3, 3,
  3, 3, 3, 59, 103, 195, 195, 195, 195, 103, 59, 8, 8, 8, 10, 1,
  0, 60, 102, 195, 255, 192, 192, 99, 62, 8, 13, 13, 10, 1, 0, 30,
  51, 51, 48, 48, 252, 48, 48, 48, 48, 48, 48, 48, 8, 12, 12, 10,
  1, 252, 125, 199, 198, 198, 198, 124, 192, 126, 195, 195, 195, 126, 8, 13,
  13, 10, 1, 0, 192, 192, 192, 192, 192, 220, 230, 195, 195, 195, 195, 195,
  195, 8, 11, 11, 10, 1, 0, 24, 24, 0, 120, 24, 24, 24, 24, 24,
  24, 255, 7, 15, 15, 10, 2, 252, 6, 6, 0, 30, 6, 6, 6, 6,
  6, 6, 6, 198, 198, 198, 124, 8, 13, 13, 10, 1, 0, 192, 192, 192,
  192, 192, 198, 204, 216, 240, 248, 204, 198, 195, 8, 13, 13, 10, 1, 0,
  120, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 255, 8, 8, 8,
  10, 1, 0, 182, 255, 219, 219, 219, 219, 219, 219, 8, 8, 8, 10, 1,
  0, 220, 230, 195, 195, 195, 195, 195, 195, 8, 8, 8, 10, 1, 0, 60,
  102, 195, 195, 195, 195, 102, 60, 8, 12, 12, 10, 1, 252, 220, 230, 195,
  195, 195, 195, 230, 220, 192, 192, 192, 192, 8, 12, 12, 10, 1, 252, 59,
  103, 195, 195, 195, 195, 103, 59, 3, 3, 3, 3, 8, 8, 8, 10, 1,
  0, 222, 115, 96, 96, 96, 96, 96, 96, 8, 8, 8, 10, 1, 0, 126,
  195, 192, 126, 3, 3, 195, 126, 8, 11, 11, 10, 1, 0, 48, 48, 48,
  252, 48, 48, 48, 48, 48, 51, 30, 8, 8, 8, 10, 1, 0, 195, 195,
  195, 195, 195, 195, 103, 59, 8, 8, 8, 10, 1, 0, 195, 195, 102, 102,
  60, 60, 24, 24, 8, 8, 8, 10, 1, 0, 195, 195, 195, 219, 219, 219,
  255, 102, 8, 8, 8, 10, 1, 0, 195, 102, 60, 24, 24, 60, 102, 195,
  8, 12, 12, 10, 1, 252, 195, 195, 195, 195, 195, 195, 103, 59, 3, 195,
  102, 60, 7, 8, 8, 10, 2, 0, 254, 6, 12, 24, 48, 96, 192, 254,
  8, 13, 13, 10, 1, 0, 15, 24, 24, 24, 24, 24, 240, 24, 24, 24,
  24, 24, 15, 2, 13, 13, 10, 4, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 8, 13, 13, 10, 1, 0, 240, 24, 24, 24,
  24, 24, 15, 24, 24, 24, 24, 24, 240, 8, 3, 3, 10, 1, 10, 115,
  219, 206, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 0, 0, 0, 10, 0, 16, 2, 13, 13, 10, 4, 0, 192,
  192, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 7, 12, 12, 10,
  1, 0, 24, 24, 60, 102, 194, 192, 192, 194, 102, 60, 24, 24, 9, 12,
  24, 10, 1, 0, 30, 0, 51, 0, 51, 0, 48, 0, 48, 0, 252, 0,
  48, 0, 48, 0, 48, 0, 248, 0, 173, 128, 231, 0, 9, 9, 18, 10,
  0, 1, 128, 128, 221, 128, 127, 0, 99, 0, 99, 0, 99, 0, 127, 0,
  221, 128, 128, 128, 8, 11, 11, 10, 1, 0, 129, 195, 102, 60, 126, 24,
  126, 24, 24, 24, 24, 2, 13, 13, 10, 4, 0, 192, 192, 192, 192, 192,
  0, 0, 0, 192, 192, 192, 192, 192, 8, 13, 13, 10, 1, 0, 60, 102,
  198, 96, 120, 204, 102, 51, 30, 6, 99, 102, 60, 6, 2, 2, 10, 2,
  11, 204, 204, 8, 11, 11, 10, 1, 0, 60, 102, 195, 189, 165, 161, 165,
  189, 195, 102, 60, 8, 9, 9, 10, 1, 4, 62, 67, 3, 127, 195, 195,
  125, 0, 255, 9, 11, 22, 10, 0, 0, 4, 128, 13, 128, 27, 0, 54,
  0, 108, 0, 216, 0, 108, 0, 54, 0, 27, 0, 13, 128, 4, 128, 8,
  4, 4, 10, 1, 4, 255, 255, 3, 3, 6, 1, 1, 10, 2, 6, 252,
  8, 11, 11, 10, 1, 0, 60, 102, 195, 189, 165, 189, 169, 173, 195, 102,
  60, 8, 1, 1, 10, 1, 13, 255, 6, 6, 6, 10, 2, 7, 48, 120,
  204, 204, 120, 48, 8, 7, 7, 10, 1, 2, 24, 24, 255, 24, 24, 0,
  255, 5, 7, 7, 10, 2, 6, 112, 216, 24, 48, 96, 192, 248, 5, 7,
  7, 10, 2, 6, 112, 216, 24, 48, 24, 216, 112, 4, 3, 3, 10, 3,
  10, 48, 96, 192, 7, 10, 10, 10, 1, 253, 198, 198, 198, 198, 198, 238,
  250, 192, 192, 192, 8, 13, 13, 10, 1, 0, 127, 255, 251, 251, 251, 123,
  27, 27, 27, 27, 27, 27, 27, 3, 3, 3, 10, 4, 5, 224, 224, 224,
  5, 4, 4, 10, 2, 252, 48, 24, 216, 112, 4, 7, 7, 10, 2, 6,
  96, 224, 96, 96, 96, 96, 240, 7, 9, 9, 10, 1, 4, 56, 108, 198,
  198, 198, 108, 56, 0, 254, 9, 11, 22, 10, 1, 0, 144, 0, 216, 0,
  108, 0, 54, 0, 27, 0, 13, 128, 27, 0, 54, 0, 108, 0, 216, 0,
  144, 0, 8, 12, 12, 10, 1, 1, 64, 192, 65, 66, 228, 8, 18, 38,
  74, 158, 2, 2, 8, 12, 12, 10, 1, 1, 64, 192, 65, 66, 228, 8,
  22, 41, 65, 130, 4, 15, 8, 12, 12, 10, 1, 1, 224, 16, 97, 18,
  228, 8, 18, 38, 74, 159, 2, 2, 8, 13, 13, 10, 1, 0, 24, 24,
  0, 24, 24, 24, 48, 96, 195, 195, 195, 102, 60, 8, 15, 15, 10, 1,
  0, 96, 48, 24, 0, 24, 60, 102, 195, 195, 195, 255, 195, 195, 195, 195,
  8, 15, 15, 10, 1, 0, 6, 12, 24, 0, 24, 60, 102, 195, 195, 195,
  255, 195, 195, 195, 195, 8, 15, 15, 10, 1, 0, 24, 60, 102, 0, 24,
  60, 102, 195, 195, 195, 255, 195, 195, 195, 195, 8, 15, 15, 10, 1, 0,
  50, 126, 76, 0, 24, 60, 102, 195, 195, 195, 255, 195, 195, 195, 195, 8,
  15, 15, 10, 1, 0, 102, 102, 0, 24, 60, 102, 102, 195, 195, 195, 255,
  195, 195, 195, 195, 8, 16, 16, 10, 1, 0, 60, 102, 102, 60, 0, 24,
  60, 102, 195, 195, 195, 255, 195, 195, 195, 195, 8, 13, 13, 10, 1, 0,
  31, 60, 108, 108, 204, 204, 255, 204, 204, 204, 204, 204, 207, 8, 17, 17,
  10, 1, 252, 60, 102, 195, 192, 192, 192, 192, 192, 192, 192, 195, 102, 60,
  24, 12, 108, 56, 8, 15, 15, 10, 1, 0, 96, 48, 24, 0, 255, 192,
  192, 192, 192, 252, 192, 192, 192, 192, 255, 8, 15, 15, 10, 1, 0, 12,
  24, 48, 0, 255, 192, 192, 192, 192, 252, 192, 192, 192, 192, 255, 8, 15,
  15, 10, 1, 0, 24, 60, 102, 0, 255, 192, 192, 192, 192, 252, 192, 192,
  192, 192, 255, 8, 15, 15, 10, 1, 0, 102, 102, 0, 0, 255, 192, 192,
  192, 192, 252, 192, 192, 192, 192, 255, 6, 15, 15, 10, 2, 0, 96, 48,
  24, 0, 252, 48, 48, 48, 48, 48, 48, 48, 48, 48, 252, 6, 15, 15,
  10, 2, 0, 24, 48, 96, 0, 252, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 252, 6, 15, 15, 10, 2, 0, 48, 120, 204, 0, 252, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 252, 6, 15, 15, 10, 2, 0, 204, 204, 0,
  252, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 252, 9, 13, 26, 10,
  0, 0, 126, 0, 99, 0, 97, 128, 97, 128, 97, 128, 97, 128, 249, 128,
  97, 128, 97, 128, 97, 128, 97, 128, 99, 0, 126, 0, 8, 15, 15, 10,
  1, 0, 50, 126, 76, 0, 195, 227, 243, 243, 219, 219, 207, 207, 199, 195,
  195, 8, 15, 15, 10, 1, 0, 48, 24, 12, 0, 60, 102, 195, 195, 195,
  195, 195, 195, 195, 102, 60, 8, 15, 15, 10, 1, 0, 12, 24, 48, 0,
  60, 102, 195, 195, 195, 195, 195, 195, 195, 102, 60, 8, 15, 15, 10, 1,
  0, 24, 60, 102, 0, 60, 102, 195, 195, 195, 195, 195, 195, 195, 102, 60,
  8, 15, 15, 10, 1, 0, 50, 126, 76, 0, 60, 102, 195, 195, 195, 195,
  195, 195, 195, 102, 60, 8, 15, 15, 10, 1, 0, 102, 102, 0, 60, 102,
  195, 195, 195, 195, 195, 195, 195, 195, 102, 60, 7, 8, 8, 10, 1, 0,
  130, 198, 108, 56, 56, 108, 198, 130, 8, 15, 15, 10, 1, 255, 1, 62,
  102, 199, 199, 203, 203, 203, 211, 211, 211, 227, 102, 124, 128, 8, 15, 15,
  10, 1, 0, 48, 24, 12, 0, 195, 195, 195, 195, 195, 195, 195, 195, 195,
  102, 60, 8, 15, 15, 10, 1, 0, 12, 24, 48, 0, 195, 195, 195, 195,
  195, 195, 195, 195, 195, 102, 60, 8, 15, 15, 10, 1, 0, 24, 60, 102,
  0, 195, 195, 195, 195, 195, 195, 195, 195, 195, 102, 60, 8, 15, 15, 10,
  1, 0, 102, 102, 0, 195, 195, 195, 195, 195, 195, 195, 195, 195, 195, 102,
  60, 8, 15, 15, 10, 1, 0, 12, 24, 48, 0, 195, 195, 102, 102, 60,
  60, 24, 24, 24, 24, 24, 7, 13, 13, 10, 2, 0, 192, 192, 192, 252,
  198, 198, 198, 198, 198, 252, 192, 192, 192, 8, 13, 13, 10, 1, 0, 28,
  54, 99, 99, 102, 236, 108, 102, 99, 99, 99, 102, 108, 8, 12, 12, 10,
  1, 0, 48, 24, 12, 0, 126, 195, 3, 127, 195, 195, 195, 125, 8, 12,
  12, 10, 1, 0, 12, 24, 48, 0, 126, 195, 3, 127, 195, 195, 195, 125,
  8, 12, 12, 10, 1, 0, 24, 60, 102, 0, 126, 195, 3, 127, 195, 195,
  195, 125, 8, 12, 12, 10, 1, 0, 50, 126, 76, 0, 126, 195, 3, 127,
  195, 195, 195, 125, 8, 11, 11, 10, 1, 0, 102, 102, 0, 126, 195, 3,
  127, 195, 195, 195, 125, 8, 13, 13, 10, 1, 0, 60, 102, 102, 60, 0,
  126, 195, 3, 127, 195, 195, 195, 125, 8, 8, 8, 10, 1, 0, 118, 155,
  27, 30, 120, 216, 217, 110, 8, 12, 12, 10, 1, 252, 62, 99, 192, 192,
  192, 192, 99, 62, 24, 12, 108, 56, 8, 12, 12, 10, 1, 0, 96, 48,
  24, 0, 60, 102, 195, 255, 192, 192, 99, 62, 8, 12, 12, 10, 1, 0,
  6, 12, 24, 0, 60, 102, 195, 255, 192, 192, 99, 62, 8, 12, 12, 10,
  1, 0, 24, 60, 102, 0, 60, 102, 195, 255, 192, 192, 99, 62, 8, 11,
  11, 10, 1, 0, 102, 102, 0, 60, 102, 195, 255, 192, 192, 99, 62, 8,
  12, 12, 10, 1, 0, 96, 48, 24, 0, 120, 24, 24, 24, 24, 24, 24,
  255, 8, 12, 12, 10, 1, 0, 12, 24, 48, 0, 120, 24, 24, 24, 24,
  24, 24, 255, 8, 12, 12, 10, 1, 0, 24, 60, 102, 0, 120, 24, 24,
  24, 24, 24, 24, 255, 8, 11, 11, 10, 1, 0, 102, 102, 0, 120, 24,
  24, 24, 24, 24, 24, 255, 8, 13, 13, 10, 1, 0, 136, 216, 112, 112,
  216, 140, 62, 103, 195, 195, 195, 102, 60, 8, 12, 12, 10, 1, 0, 50,
  126, 76, 0, 220, 230, 195, 195, 195, 195, 195, 195, 8, 12, 12, 10, 1,
  0, 96, 48, 24, 0, 60, 102, 195, 195, 195, 195, 102, 60, 8, 12, 12,
  10, 1, 0, 6, 12, 24, 0, 60, 102, 195, 195, 195, 195, 102, 60, 8,
  12, 12, 10, 1, 0, 24, 60, 102, 0, 60, 102, 195, 195, 195, 195, 102,
  60, 8, 12, 12, 10, 1, 0, 50, 126, 76, 0, 60, 102, 195, 195, 195,
  195, 102, 60, 8, 11, 11, 10, 1, 0, 102, 102, 0, 60, 102, 195, 195,
  195, 195, 102, 60, 8, 10, 10, 10, 1, 1, 24, 24, 0, 0, 255, 255,
  0, 0, 24, 24, 8, 10, 10, 10, 1, 255, 1, 62, 102, 203, 203, 211,
  211, 102, 124, 128, 8, 12, 12, 10, 1, 0, 48, 24, 12, 0, 195, 195,
  195, 195, 195, 195, 103, 59, 8, 12, 12, 10, 1, 0, 6, 12, 24, 0,
  195, 195, 195, 195, 195, 195, 103, 59, 8, 12, 12, 10, 1, 0, 24, 60,
  102, 0, 195, 195, 195, 195, 195, 195, 103, 59, 8, 11, 11, 10, 1, 0,
  102, 102, 0, 195, 195, 195, 195, 195, 195, 103, 59, 8, 16, 16, 10, 1,
  252, 12, 24, 48, 0, 195, 195, 195, 195, 195, 195, 103, 59, 3, 195, 102,
  60, 7, 17, 17, 10, 2, 252, 192, 192, 192, 192, 192, 192, 248, 204, 198,
  198, 198, 204, 248, 192, 192, 192, 192, 8, 15, 15, 10, 1, 252, 102, 102,
  0, 195, 195, 195, 195, 195, 195, 103, 59, 3, 195, 102, 60
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--20-200-75-75-C-100-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 13, '1' Height: 13
  Calculated Max Values w= 9 h=15 x= 4 y=16 dx=10 dy= 0 ascent=16 len=26
  Font Bounding box     w=10 h=20 x= 0 y=-4
  Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
  Pure Font   ascent =13 descent=-4
  X Font      ascent =13 descent=-4
  Max Font    ascent =16 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_10x20r[1667] U8G_FONT_SECTION("u8g_font_10x20r") = {
  0, 10, 20, 0, 252, 13, 2, 74, 4, 153, 32, 127, 252, 16, 252, 13,
  252, 0, 0, 0, 10, 0, 16, 2, 13, 13, 10, 4, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 0, 192, 192, 6, 4, 4, 10, 2, 9,
  204, 204, 204, 72, 9, 11, 22, 10, 1, 1, 27, 0, 27, 0, 27, 0,
  127, 128, 54, 0, 54, 0, 54, 0, 255, 0, 108, 0, 108, 0, 108, 0,
  8, 13, 13, 10, 1, 0, 24, 126, 219, 216, 216, 216, 126, 27, 27, 27,
  219, 126, 24, 9, 12, 24, 10, 1, 0, 115, 0, 219, 0, 222, 0, 118,
  0, 12, 0, 12, 0, 24, 0, 24, 0, 55, 0, 61, 128, 109, 128, 103,
  0, 9, 13, 26, 10, 1, 0, 56, 0, 108, 0, 108, 0, 108, 0, 120,
  0, 48, 0, 112, 0, 216, 0, 205, 128, 199, 0, 198, 0, 239, 0, 121,
  128, 2, 5, 5, 10, 4, 8, 192, 192, 192, 192, 128, 5, 13, 13, 10,
  3, 0, 24, 48, 96, 96, 192, 192, 192, 192, 192, 96, 96, 48, 24, 5,
  13, 13, 10, 2, 0, 192, 96, 48, 48, 24, 24, 24, 24, 24, 48, 48,
  96, 192, 8, 7, 7, 10, 1, 3, 102, 102, 60, 255, 60, 102, 102, 8,
  7, 7, 10, 1, 3, 24, 24, 24, 255, 24, 24, 24, 4, 3, 3, 10,
  3, 255, 112, 112, 224, 8, 1, 1, 10, 1, 6, 255, 3, 3, 3, 10,
  4, 0, 224, 224, 224, 7, 12, 12, 10, 2, 0, 6, 6, 12, 12, 24,
  24, 48, 48, 96, 96, 192, 192, 8, 13, 13, 10, 1, 0, 24, 60, 102,
  102, 195, 195, 195, 195, 195, 102, 102, 60, 24, 8, 13, 13, 10, 1, 0,
  24, 56, 120, 216, 24, 24, 24, 24, 24, 24, 24, 24, 255, 8, 13, 13,
  10, 1, 0, 60, 102, 195, 195, 3, 3, 6, 28, 48, 96, 192, 192, 255,
  8, 13, 13, 10, 1, 0, 60, 102, 195, 195, 3, 6, 28, 6, 3, 195,
  195, 102, 60, 8, 13, 13, 10, 1, 0, 2, 6, 14, 30, 54, 102, 198,
  198, 255, 6, 6, 6, 6, 8, 13, 13, 10, 1, 0, 255, 192, 192, 192,
  192, 220, 230, 3, 3, 3, 195, 102, 60, 8, 13, 13, 10, 1, 0, 60,
  102, 194, 192, 192, 220, 230, 195, 195, 195, 195, 102, 60, 8, 13, 13, 10,
  1, 0, 255, 3, 3, 6, 6, 12, 12, 24, 24, 48, 48, 96, 96, 8,
  13, 13, 10, 1, 0, 60, 102, 195, 195, 195, 102, 60, 102, 195, 195, 195,
  102, 60, 8, 13, 13, 10, 1, 0, 60, 102, 195, 195, 195, 195, 103, 59,
  3, 3, 67, 102, 60, 3, 8, 8, 10, 4, 0, 224, 224, 0, 0, 0,
  0, 224, 224, 4, 9, 9, 10, 3, 255, 112, 112, 0, 0, 0, 0, 112,
  112, 224, 7, 13, 13, 10, 1, 0, 2, 6, 12, 24, 48, 96, 192, 96,
  48, 24, 12, 6, 2, 8, 6, 6, 10, 1, 3, 255, 0, 0, 0, 0,
  255, 7, 13, 13, 10, 2, 0, 128, 192, 96, 48, 24, 12, 6, 12, 24,
  48, 96, 192, 128, 8, 13, 13, 10, 1, 0, 60, 102, 195, 195, 195, 6,
  12, 24, 24, 24, 0, 24, 24, 8, 13, 13, 10, 1, 0, 60, 102, 195,
  207, 223, 219, 219, 219, 222, 204, 192, 99, 62, 8, 13, 13, 10, 1, 0,
  24, 60, 102, 102, 195, 195, 195, 255, 195, 195, 195, 195, 195, 8, 13, 13,
  10, 1, 0, 248, 204, 198, 198, 198, 204, 252, 198, 195, 195, 195, 198, 252,
  8, 13, 13, 10, 1, 0, 60, 102, 195, 192, 192, 192, 192, 192, 192, 192,
  195, 102, 60, 8, 13, 13, 10, 1, 0, 252, 198, 195, 195, 195, 195, 195,
  195, 195, 195, 195, 198, 252, 8, 13, 13, 10, 1, 0, 255, 192, 192, 192,
  192, 192, 252, 192, 192, 192, 192, 192, 255, 8, 13, 13, 10, 1, 0, 255,
  192, 192, 192, 192, 192, 252, 192, 192, 192, 192, 192, 192, 8, 13, 13, 10,
  1, 0, 60, 102, 195, 192, 192, 192, 207, 195, 195, 195, 195, 103, 61, 8,
  13, 13, 10, 1, 0, 195, 195, 195, 195, 195, 195, 255, 195, 195, 195, 195,
  195, 195, 8, 13, 13, 10, 1, 0, 255, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 255, 9, 13, 26, 10, 1, 0, 31, 128, 6, 0, 6,
  0, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 198, 0, 198,
  0, 108, 0, 56, 0, 8, 13, 13, 10, 1, 0, 195, 195, 198, 198, 204,
  204, 248, 204, 204, 198, 198, 195, 195, 8, 13, 13, 10, 1, 0, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 8, 13, 13, 10, 1,
  0, 195, 195, 231, 231, 255, 219, 219, 219, 219, 195, 195, 195, 195, 8, 13,
  13, 10, 1, 0, 195, 227, 227, 243, 243, 219, 219, 207, 207, 199, 199, 195,
  195, 8, 13, 13, 10, 1, 0, 60, 102, 195, 195, 195, 195, 195, 195, 195,
  195, 195, 102, 60, 8, 13, 13, 10, 1, 0, 252, 198, 195, 195, 195, 195,
  198, 252, 192, 192, 192, 192, 192, 8, 14, 14, 10, 1, 255, 60, 102, 195,
  195, 195, 195, 195, 195, 195, 219, 207, 102, 62, 3, 8, 13, 13, 10, 1,
  0, 252, 198, 195, 195, 195, 195, 198, 252, 204, 198, 198, 195, 195, 8, 13,
  13, 10, 1, 0, 60, 102, 195, 192, 192, 96, 60, 6, 3, 3, 195, 102,
  60, 8, 13, 13, 10, 1, 0, 255, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 8, 13, 13, 10, 1, 0, 195, 195, 195, 195, 195, 195,
  195, 195, 195, 195, 195, 102, 60, 8, 13, 13, 10, 1, 0, 195, 195, 195,
  195, 102, 102, 102, 60, 60, 60, 24, 24, 24, 8, 13, 13, 10, 1, 0,
  195, 195, 195, 195, 195, 219, 219, 219, 219, 231, 231, 195, 195, 8, 13, 13,
  10, 1, 0, 195, 195, 102, 102, 60, 60, 24, 60, 60, 102, 102, 195, 195,
  8, 13, 13, 10, 1, 0, 195, 195, 102, 102, 60, 60, 24, 24, 24, 24,
  24, 24, 24, 8, 13, 13, 10, 1, 0, 255, 3, 3, 6, 12, 12, 24,
  48, 48, 96, 192, 192, 255, 6, 13, 13, 10, 2, 0, 252, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 252, 7, 12, 12, 10, 2, 0, 192,
  192, 96, 96, 48, 48, 24, 24, 12, 12, 6, 6, 6, 13, 13, 10, 2,
  0, 252, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 252, 8, 4,
  4, 10, 1, 9, 24, 60, 102, 195, 9, 1, 2, 10, 1, 255, 255, 128,
  4, 3, 3, 10, 3, 10, 192, 96, 48, 8, 8, 8, 10, 1, 0, 62,
  99, 3, 127, 195, 195, 195, 125, 8, 13, 13, 10, 1, 0, 192, 192, 192,
  192, 192, 220, 230, 195, 195, 195, 195, 230, 220, 8, 8, 8, 10, 1, 0,
  62, 99, 192, 192, 192, 192, 99, 62, 8, 13, 13, 10, 1, 0, 3, 3,
  3, 3, 3, 59, 103, 195, 195, 195, 195, 103, 59, 8, 8, 8, 10, 1,
  0, 60, 102, 195, 255, 192, 192, 99, 62, 8, 13, 13, 10, 1, 0, 30,
  51, 51, 48, 48, 252, 48, 48, 48, 48, 48, 48, 48, 8, 12, 12, 10,
  1, 252, 125, 199, 198, 198, 198, 124, 192, 126, 195, 195, 195, 126, 8, 13,
  13, 10, 1, 0, 192, 192, 192, 192, 192, 220, 230, 195, 195, 195, 195, 195,
  195, 8, 11, 11, 10, 1, 0, 24, 24, 0, 120, 24, 24, 24, 24, 24,
  24, 255, 7, 15, 15, 10, 2, 252, 6, 6, 0, 30, 6, 6, 6, 6,
  6, 6, 6, 198, 198, 198, 124, 8, 13, 13, 10, 1, 0, 192, 192, 192,
  192, 192, 198, 204, 216, 240, 248, 204, 198, 195, 8, 13, 13, 10, 1, 0,
  120, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 255, 8, 8, 8,
  10, 1, 0, 182, 255, 219, 219, 219, 219, 219, 219, 8, 8, 8, 10, 1,
  0, 220, 230, 195, 195, 195, 195, 195, 195, 8, 8, 8, 10, 1, 0, 60,
  102, 195, 195, 195, 195, 102, 60, 8, 12, 12, 10, 1, 252, 220, 230, 195,
  195, 195, 195, 230, 220, 192, 192, 192, 192, 8, 12, 12, 10, 1, 252, 59,
  103, 195, 195, 195, 195, 103, 59, 3, 3, 3, 3, 8, 8, 8, 10, 1,
  0, 222, 115, 96, 96, 96, 96, 96, 96, 8, 8, 8, 10, 1, 0, 126,
  195, 192, 126, 3, 3, 195, 126, 8, 11, 11, 10, 1, 0, 48, 48, 48,
  252, 48, 48, 48, 48, 48, 51, 30, 8, 8, 8, 10, 1, 0, 195, 195,
  195, 195, 195, 195, 103, 59, 8, 8, 8, 10, 1, 0, 195, 195, 102, 102,
  60, 60, 24, 24, 8, 8, 8, 10, 1, 0, 195, 195, 195, 219, 219, 219,
  255, 102, 8, 8, 8, 10, 1, 0, 195, 102, 60, 24, 24, 60, 102, 195,
  8, 12, 12, 10, 1, 252, 195, 195, 195, 195, 195, 195, 103, 59, 3, 195,
  102, 60, 7, 8, 8, 10, 2, 0, 254, 6, 12, 24, 48, 96, 192, 254,
  8, 13, 13, 10, 1, 0, 15, 24, 24, 24, 24, 24, 240, 24, 24, 24,
  24, 24, 15, 2, 13, 13, 10, 4, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 8, 13, 13, 10, 1, 0, 240, 24, 24, 24,
  24, 24, 15, 24, 24, 24, 24, 24, 240, 8, 3, 3, 10, 1, 10, 115,
  219, 206, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--6-60-75-75-C-40-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 4 h= 6 x= 1 y= 5 dx= 4 dy= 0 ascent= 5 len= 6
  Font Bounding box     w= 4 h= 6 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-1
  X Font      ascent = 5 descent=-1
  Max Font    ascent = 5 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_4x6[1500] U8G_FONT_SECTION("u8g_font_4x6") = {
  1, 4, 6, 0, 255, 5, 1, 3, 1, 250, 32, 255, 255, 5, 255, 5,
  255, 7, 0, 64, 18, 21, 69, 128, 128, 128, 0, 128, 5, 50, 66, 160,
  160, 2, 69, 69, 160, 240, 160, 240, 160, 1, 54, 70, 64, 224, 192, 32,
  224, 64, 2, 53, 69, 128, 32, 64, 128, 32, 2, 69, 69, 64, 160, 64,
  160, 80, 21, 18, 66, 128, 128, 17, 38, 70, 64, 128, 128, 128, 128, 64,
  1, 38, 70, 128, 64, 64, 64, 64, 128, 2, 53, 69, 160, 64, 224, 64,
  160, 2, 53, 69, 64, 64, 224, 64, 64, 1, 34, 66, 64, 128, 4, 49,
  65, 224, 18, 17, 65, 128, 2, 53, 69, 32, 32, 64, 128, 128, 2, 53,
  69, 64, 160, 224, 160, 64, 2, 53, 69, 64, 192, 64, 64, 224, 2, 53,
  69, 64, 160, 32, 64, 224, 2, 53, 69, 224, 32, 64, 32, 192, 2, 53,
  69, 160, 160, 224, 32, 32, 2, 53, 69, 224, 128, 192, 32, 192, 2, 53,
  69, 96, 128, 192, 160, 64, 2, 53, 69, 224, 32, 64, 128, 128, 2, 53,
  69, 96, 160, 64, 160, 192, 2, 53, 69, 64, 160, 96, 32, 192, 18, 20,
  68, 128, 0, 0, 128, 1, 37, 69, 64, 0, 0, 64, 128, 2, 53, 69,
  32, 64, 128, 64, 32, 3, 51, 67, 224, 0, 224, 2, 53, 69, 128, 64,
  32, 64, 128, 2, 53, 69, 192, 32, 64, 0, 64, 2, 53, 69, 96, 160,
  160, 128, 96, 2, 53, 69, 64, 160, 224, 160, 160, 2, 53, 69, 192, 160,
  192, 160, 192, 2, 53, 69, 64, 160, 128, 160, 64, 2, 53, 69, 192, 160,
  160, 160, 192, 2, 53, 69, 224, 128, 192, 128, 224, 2, 53, 69, 224, 128,
  192, 128, 128, 2, 53, 69, 96, 128, 160, 160, 96, 2, 53, 69, 160, 160,
  224, 160, 160, 2, 53, 69, 224, 64, 64, 64, 224, 2, 53, 69, 32, 32,
  32, 160, 64, 2, 53, 69, 160, 160, 192, 160, 160, 2, 53, 69, 128, 128,
  128, 128, 224, 2, 53, 69, 160, 224, 224, 160, 160, 2, 53, 69, 32, 160,
  224, 160, 128, 2, 53, 69, 64, 160, 160, 160, 64, 2, 53, 69, 192, 160,
  192, 128, 128, 1, 54, 70, 64, 160, 160, 160, 64, 32, 2, 53, 69, 192,
  160, 192, 160, 160, 2, 53, 69, 96, 128, 64, 32, 192, 2, 53, 69, 224,
  64, 64, 64, 64, 2, 53, 69, 160, 160, 160, 160, 224, 2, 53, 69, 160,
  160, 160, 224, 64, 2, 53, 69, 160, 160, 224, 224, 160, 2, 53, 69, 160,
  160, 64, 160, 160, 2, 53, 69, 160, 160, 64, 64, 64, 2, 53, 69, 224,
  32, 64, 128, 224, 18, 37, 69, 192, 128, 128, 128, 192, 2, 53, 69, 128,
  128, 64, 32, 32, 2, 37, 69, 192, 64, 64, 64, 192, 5, 50, 66, 64,
  160, 1, 49, 65, 224, 21, 34, 66, 128, 64, 2, 52, 68, 96, 160, 160,
  96, 2, 53, 69, 128, 192, 160, 160, 192, 2, 52, 68, 96, 128, 128, 96,
  2, 53, 69, 32, 96, 160, 160, 96, 2, 52, 68, 64, 160, 192, 96, 2,
  53, 69, 32, 64, 224, 64, 64, 1, 53, 69, 96, 160, 96, 32, 192, 2,
  53, 69, 128, 192, 160, 160, 160, 2, 53, 69, 64, 0, 192, 64, 224, 1,
  54, 70, 32, 0, 32, 32, 32, 192, 2, 53, 69, 128, 160, 192, 160, 160,
  2, 53, 69, 192, 64, 64, 64, 224, 2, 52, 68, 160, 224, 160, 160, 2,
  52, 68, 192, 160, 160, 160, 2, 52, 68, 64, 160, 160, 64, 1, 53, 69,
  192, 160, 192, 128, 128, 1, 53, 69, 96, 160, 160, 96, 32, 2, 52, 68,
  160, 192, 128, 128, 2, 52, 68, 96, 192, 32, 192, 2, 53, 69, 64, 224,
  64, 64, 32, 2, 52, 68, 160, 160, 160, 96, 2, 52, 68, 160, 160, 160,
  64, 2, 52, 68, 160, 160, 224, 160, 2, 52, 68, 160, 64, 64, 160, 1,
  53, 69, 160, 160, 96, 32, 192, 2, 52, 68, 224, 32, 64, 224, 1, 54,
  70, 32, 64, 192, 64, 64, 32, 18, 21, 69, 128, 128, 128, 128, 128, 1,
  54, 70, 128, 64, 96, 64, 64, 128, 5, 66, 66, 80, 160, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 7, 0,
  64, 18, 21, 69, 128, 0, 128, 128, 128, 2, 53, 69, 64, 224, 128, 224,
  64, 2, 53, 69, 32, 64, 96, 64, 160, 2, 68, 68, 144, 96, 96, 144,
  2, 53, 69, 160, 64, 224, 64, 64, 18, 21, 69, 128, 128, 0, 128, 128,
  1, 54, 70, 96, 192, 160, 96, 32, 192, 6, 49, 65, 160, 1, 70, 70,
  96, 144, 208, 208, 144, 96, 2, 53, 69, 96, 160, 96, 0, 224, 3, 67,
  67, 80, 160, 80, 3, 50, 66, 224, 32, 4, 49, 65, 224, 3, 68, 68,
  96, 240, 208, 96, 6, 49, 65, 224, 4, 51, 67, 64, 160, 64, 2, 53,
  69, 64, 224, 64, 0, 224, 3, 36, 68, 192, 64, 128, 192, 2, 37, 69,
  192, 64, 128, 64, 128, 21, 34, 66, 64, 128, 1, 53, 69, 160, 160, 160,
  192, 128, 2, 69, 69, 112, 208, 208, 80, 80, 20, 17, 65, 128, 18, 34,
  66, 64, 128, 3, 36, 68, 64, 192, 64, 64, 2, 53, 69, 64, 160, 64,
  0, 224, 3, 67, 67, 160, 80, 160, 1, 70, 70, 128, 128, 128, 80, 112,
  16, 1, 70, 70, 128, 128, 176, 16, 32, 48, 1, 70, 70, 192, 64, 128,
  80, 176, 16, 2, 53, 69, 64, 0, 64, 128, 96, 2, 53, 69, 128, 64,
  160, 224, 160, 2, 53, 69, 32, 64, 160, 224, 160, 2, 53, 69, 192, 64,
  160, 224, 160, 2, 53, 69, 96, 192, 160, 224, 160, 2, 53, 69, 160, 64,
  160, 224, 160, 2, 53, 69, 64, 64, 160, 224, 160, 2, 69, 69, 112, 160,
  240, 160, 176, 1, 54, 70, 64, 160, 128, 160, 64, 128, 2, 53, 69, 128,
  224, 192, 128, 224, 2, 53, 69, 32, 224, 192, 128, 224, 2, 53, 69, 96,
  224, 192, 128, 224, 2, 53, 69, 160, 224, 192, 128, 224, 2, 53, 69, 128,
  224, 64, 64, 224, 2, 53, 69, 32, 224, 64, 64, 224, 2, 53, 69, 64,
  224, 64, 64, 224, 2, 53, 69, 160, 64, 64, 64, 224, 2, 69, 69, 224,
  80, 208, 80, 224, 2, 69, 69, 80, 160, 224, 224, 160, 2, 53, 69, 128,
  64, 160, 160, 64, 2, 53, 69, 32, 64, 160, 160, 64, 2, 53, 69, 64,
  64, 160, 160, 64, 2, 69, 69, 112, 224, 160, 160, 64, 2, 53, 69, 160,
  64, 160, 160, 64, 3, 51, 67, 160, 64, 160, 2, 53, 69, 96, 160, 224,
  160, 192, 2, 53, 69, 128, 64, 160, 160, 224, 2, 53, 69, 32, 64, 160,
  160, 224, 2, 53, 69, 64, 0, 160, 160, 224, 2, 53, 69, 160, 0, 160,
  160, 224, 2, 53, 69, 32, 0, 160, 64, 64, 2, 53, 69, 128, 192, 160,
  192, 128, 1, 54, 70, 64, 160, 192, 160, 224, 128, 2, 53, 69, 128, 64,
  96, 160, 96, 2, 53, 69, 32, 64, 96, 160, 96, 2, 53, 69, 96, 0,
  96, 160, 96, 2, 69, 69, 80, 160, 96, 160, 96, 2, 53, 69, 160, 0,
  96, 160, 96, 2, 53, 69, 64, 0, 96, 160, 96, 2, 68, 68, 112, 176,
  160, 112, 1, 53, 69, 64, 160, 128, 96, 64, 2, 53, 69, 128, 64, 160,
  192, 96, 2, 53, 69, 32, 64, 160, 192, 96, 2, 53, 69, 192, 64, 160,
  192, 96, 2, 53, 69, 160, 64, 160, 192, 96, 2, 53, 69, 128, 64, 64,
  64, 224, 2, 53, 69, 32, 192, 64, 64, 224, 2, 53, 69, 64, 160, 64,
  64, 224, 2, 53, 69, 160, 0, 192, 64, 224, 2, 53, 69, 160, 64, 96,
  160, 64, 2, 69, 69, 80, 160, 192, 160, 160, 2, 53, 69, 128, 64, 64,
  160, 64, 2, 53, 69, 32, 64, 64, 160, 64, 2, 53, 69, 64, 0, 64,
  160, 64, 2, 53, 69, 224, 0, 64, 160, 64, 2, 53, 69, 160, 0, 64,
  160, 64, 2, 53, 69, 64, 0, 224, 0, 64, 2, 52, 68, 96, 160, 160,
  192, 2, 53, 69, 128, 64, 160, 160, 96, 2, 53, 69, 32, 64, 160, 160,
  96, 2, 53, 69, 64, 0, 160, 160, 96, 2, 53, 69, 160, 0, 160, 160,
  96, 1, 54, 70, 32, 64, 160, 224, 32, 192, 1, 54, 70, 128, 128, 192,
  160, 192, 128, 1, 54, 70, 160, 0, 160, 224, 32, 192
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--6-60-75-75-C-40-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 4 h= 6 x= 1 y= 5 dx= 4 dy= 0 ascent= 5 len= 6
  Font Bounding box     w= 4 h= 6 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-1
  X Font      ascent = 5 descent=-1
  Max Font    ascent = 5 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_4x6r[734] U8G_FONT_SECTION("u8g_font_4x6r") = {
  1, 4, 6, 0, 255, 5, 1, 3, 1, 250, 32, 127, 255, 5, 255, 5,
  255, 7, 0, 64, 18, 21, 69, 128, 128, 128, 0, 128, 5, 50, 66, 160,
  160, 2, 69, 69, 160, 240, 160, 240, 160, 1, 54, 70, 64, 224, 192, 32,
  224, 64, 2, 53, 69, 128, 32, 64, 128, 32, 2, 69, 69, 64, 160, 64,
  160, 80, 21, 18, 66, 128, 128, 17, 38, 70, 64, 128, 128, 128, 128, 64,
  1, 38, 70, 128, 64, 64, 64, 64, 128, 2, 53, 69, 160, 64, 224, 64,
  160, 2, 53, 69, 64, 64, 224, 64, 64, 1, 34, 66, 64, 128, 4, 49,
  65, 224, 18, 17, 65, 128, 2, 53, 69, 32, 32, 64, 128, 128, 2, 53,
  69, 64, 160, 224, 160, 64, 2, 53, 69, 64, 192, 64, 64, 224, 2, 53,
  69, 64, 160, 32, 64, 224, 2, 53, 69, 224, 32, 64, 32, 192, 2, 53,
  69, 160, 160, 224, 32, 32, 2, 53, 69, 224, 128, 192, 32, 192, 2, 53,
  69, 96, 128, 192, 160, 64, 2, 53, 69, 224, 32, 64, 128, 128, 2, 53,
  69, 96, 160, 64, 160, 192, 2, 53, 69, 64, 160, 96, 32, 192, 18, 20,
  68, 128, 0, 0, 128, 1, 37, 69, 64, 0, 0, 64, 128, 2, 53, 69,
  32, 64, 128, 64, 32, 3, 51, 67, 224, 0, 224, 2, 53, 69, 128, 64,
  32, 64, 128, 2, 53, 69, 192, 32, 64, 0, 64, 2, 53, 69, 96, 160,
  160, 128, 96, 2, 53, 69, 64, 160, 224, 160, 160, 2, 53, 69, 192, 160,
  192, 160, 192, 2, 53, 69, 64, 160, 128, 160, 64, 2, 53, 69, 192, 160,
  160, 160, 192, 2, 53, 69, 224, 128, 192, 128, 224, 2, 53, 69, 224, 128,
  192, 128, 128, 2, 53, 69, 96, 128, 160, 160, 96, 2, 53, 69, 160, 160,
  224, 160, 160, 2, 53, 69, 224, 64, 64, 64, 224, 2, 53, 69, 32, 32,
  32, 160, 64, 2, 53, 69, 160, 160, 192, 160, 160, 2, 53, 69, 128, 128,
  128, 128, 224, 2, 53, 69, 160, 224, 224, 160, 160, 2, 53, 69, 32, 160,
  224, 160, 128, 2, 53, 69, 64, 160, 160, 160, 64, 2, 53, 69, 192, 160,
  192, 128, 128, 1, 54, 70, 64, 160, 160, 160, 64, 32, 2, 53, 69, 192,
  160, 192, 160, 160, 2, 53, 69, 96, 128, 64, 32, 192, 2, 53, 69, 224,
  64, 64, 64, 64, 2, 53, 69, 160, 160, 160, 160, 224, 2, 53, 69, 160,
  160, 160, 224, 64, 2, 53, 69, 160, 160, 224, 224, 160, 2, 53, 69, 160,
  160, 64, 160, 160, 2, 53, 69, 160, 160, 64, 64, 64, 2, 53, 69, 224,
  32, 64, 128, 224, 18, 37, 69, 192, 128, 128, 128, 192, 2, 53, 69, 128,
  128, 64, 32, 32, 2, 37, 69, 192, 64, 64, 64, 192, 5, 50, 66, 64,
  160, 1, 49, 65, 224, 21, 34, 66, 128, 64, 2, 52, 68, 96, 160, 160,
  96, 2, 53, 69, 128, 192, 160, 160, 192, 2, 52, 68, 96, 128, 128, 96,
  2, 53, 69, 32, 96, 160, 160, 96, 2, 52, 68, 64, 160, 192, 96, 2,
  53, 69, 32, 64, 224, 64, 64, 1, 53, 69, 96, 160, 96, 32, 192, 2,
  53, 69, 128, 192, 160, 160, 160, 2, 53, 69, 64, 0, 192, 64, 224, 1,
  54, 70, 32, 0, 32, 32, 32, 192, 2, 53, 69, 128, 160, 192, 160, 160,
  2, 53, 69, 192, 64, 64, 64, 224, 2, 52, 68, 160, 224, 160, 160, 2,
  52, 68, 192, 160, 160, 160, 2, 52, 68, 64, 160, 160, 64, 1, 53, 69,
  192, 160, 192, 128, 128, 1, 53, 69, 96, 160, 160, 96, 32, 2, 52, 68,
  160, 192, 128, 128, 2, 52, 68, 96, 192, 32, 192, 2, 53, 69, 64, 224,
  64, 64, 32, 2, 52, 68, 160, 160, 160, 96, 2, 52, 68, 160, 160, 160,
  64, 2, 52, 68, 160, 160, 224, 160, 2, 52, 68, 160, 64, 64, 160, 1,
  53, 69, 160, 160, 96, 32, 192, 2, 52, 68, 224, 32, 64, 224, 1, 54,
  70, 32, 64, 192, 64, 64, 32, 18, 21, 69, 128, 128, 128, 128, 128, 1,
  54, 70, 128, 64, 96, 64, 64, 128, 5, 66, 66, 80, 160, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--7-70-75-75-C-50-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 6, '1' Height: 6
  Calculated Max Values w= 5 h= 7 x= 2 y= 6 dx= 5 dy= 0 ascent= 6 len= 7
  Font Bounding box     w= 5 h= 7 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 6 descent=-1
  X Font      ascent = 6 descent=-1
  Max Font    ascent = 6 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_5x7[1624] U8G_FONT_SECTION("u8g_font_5x7") = {
  1, 5, 7, 0, 255, 6, 1, 21, 2, 39, 32, 255, 255, 6, 255, 6,
  255, 8, 0, 80, 34, 22, 86, 128, 128, 128, 128, 0, 128, 21, 51, 83,
  160, 160, 160, 2, 85, 85, 80, 248, 80, 248, 80, 2, 85, 85, 112, 160,
  112, 40, 112, 2, 70, 86, 128, 144, 32, 64, 144, 16, 2, 69, 85, 64,
  160, 64, 160, 80, 37, 19, 83, 128, 128, 128, 18, 38, 86, 64, 128, 128,
  128, 128, 64, 18, 38, 86, 128, 64, 64, 64, 64, 128, 18, 53, 85, 160,
  64, 224, 64, 160, 2, 85, 85, 32, 32, 248, 32, 32, 17, 51, 83, 96,
  64, 128, 4, 65, 81, 240, 18, 34, 82, 192, 192, 3, 68, 84, 16, 32,
  64, 128, 18, 54, 86, 64, 160, 160, 160, 160, 64, 18, 54, 86, 64, 192,
  64, 64, 64, 224, 2, 70, 86, 96, 144, 16, 32, 64, 240, 2, 70, 86,
  240, 16, 96, 16, 144, 96, 2, 70, 86, 32, 96, 160, 240, 32, 32, 2,
  70, 86, 240, 128, 224, 16, 144, 96, 2, 70, 86, 96, 128, 224, 144, 144,
  96, 2, 70, 86, 240, 16, 32, 32, 64, 64, 2, 70, 86, 96, 144, 96,
  144, 144, 96, 2, 70, 86, 96, 144, 144, 112, 16, 96, 18, 37, 85, 192,
  192, 0, 192, 192, 1, 54, 86, 96, 96, 0, 96, 64, 128, 18, 53, 85,
  32, 64, 128, 64, 32, 3, 67, 83, 240, 0, 240, 18, 53, 85, 128, 64,
  32, 64, 128, 18, 54, 86, 64, 160, 32, 64, 0, 64, 2, 70, 86, 96,
  144, 176, 176, 128, 96, 2, 70, 86, 96, 144, 144, 240, 144, 144, 2, 70,
  86, 224, 144, 224, 144, 144, 224, 2, 70, 86, 96, 144, 128, 128, 144, 96,
  2, 70, 86, 224, 144, 144, 144, 144, 224, 2, 70, 86, 240, 128, 224, 128,
  128, 240, 2, 70, 86, 240, 128, 224, 128, 128, 128, 2, 70, 86, 96, 144,
  128, 176, 144, 112, 2, 70, 86, 144, 144, 240, 144, 144, 144, 18, 54, 86,
  224, 64, 64, 64, 64, 224, 2, 70, 86, 16, 16, 16, 16, 144, 96, 2,
  70, 86, 144, 160, 192, 192, 160, 144, 2, 70, 86, 128, 128, 128, 128, 128,
  240, 2, 70, 86, 144, 240, 240, 144, 144, 144, 2, 70, 86, 144, 208, 208,
  176, 176, 144, 2, 70, 86, 96, 144, 144, 144, 144, 96, 2, 70, 86, 224,
  144, 144, 224, 128, 128, 1, 71, 87, 96, 144, 144, 144, 208, 96, 16, 2,
  70, 86, 224, 144, 144, 224, 160, 144, 2, 70, 86, 96, 144, 64, 32, 144,
  96, 18, 54, 86, 224, 64, 64, 64, 64, 64, 2, 70, 86, 144, 144, 144,
  144, 144, 96, 2, 70, 86, 144, 144, 144, 144, 96, 96, 2, 70, 86, 144,
  144, 144, 240, 240, 144, 2, 70, 86, 144, 144, 96, 96, 144, 144, 18, 54,
  86, 160, 160, 160, 64, 64, 64, 2, 70, 86, 240, 16, 32, 64, 128, 240,
  18, 54, 86, 224, 128, 128, 128, 128, 224, 3, 68, 84, 128, 64, 32, 16,
  18, 54, 86, 224, 32, 32, 32, 32, 224, 22, 50, 82, 64, 160, 2, 65,
  81, 240, 22, 34, 82, 128, 64, 2, 68, 84, 112, 144, 176, 80, 2, 70,
  86, 128, 128, 224, 144, 144, 224, 2, 52, 84, 96, 128, 128, 96, 2, 70,
  86, 16, 16, 112, 144, 144, 112, 2, 68, 84, 96, 176, 192, 96, 2, 70,
  86, 32, 80, 64, 224, 64, 64, 1, 69, 85, 112, 144, 96, 128, 112, 2,
  70, 86, 128, 128, 224, 144, 144, 144, 18, 54, 86, 64, 0, 192, 64, 64,
  224, 17, 55, 87, 32, 0, 32, 32, 32, 160, 64, 2, 70, 86, 128, 128,
  160, 192, 160, 144, 18, 54, 86, 192, 64, 64, 64, 64, 224, 2, 68, 84,
  160, 240, 144, 144, 2, 68, 84, 224, 144, 144, 144, 2, 68, 84, 96, 144,
  144, 96, 1, 69, 85, 224, 144, 144, 224, 128, 1, 69, 85, 112, 144, 144,
  112, 16, 2, 68, 84, 224, 144, 128, 128, 2, 68, 84, 112, 192, 48, 224,
  2, 70, 86, 64, 64, 224, 64, 64, 48, 2, 68, 84, 144, 144, 144, 112,
  18, 52, 84, 160, 160, 160, 64, 2, 68, 84, 144, 144, 240, 240, 2, 68,
  84, 144, 96, 96, 144, 1, 69, 85, 144, 144, 80, 32, 64, 2, 68, 84,
  240, 32, 64, 240, 18, 54, 86, 32, 64, 192, 64, 64, 32, 34, 22, 86,
  128, 128, 128, 128, 128, 128, 18, 54, 86, 128, 64, 96, 64, 64, 128, 6,
  66, 82, 80, 160, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 8, 0, 80, 34, 22, 86, 128, 0, 128, 128, 128,
  128, 1, 70, 86, 32, 112, 160, 160, 112, 32, 2, 69, 85, 48, 64, 224,
  64, 176, 2, 85, 85, 136, 112, 80, 112, 136, 18, 54, 86, 160, 160, 64,
  224, 64, 64, 34, 21, 85, 128, 128, 0, 128, 128, 17, 55, 87, 96, 128,
  192, 160, 96, 32, 192, 23, 49, 81, 160, 1, 87, 87, 112, 136, 168, 200,
  168, 136, 112, 5, 51, 83, 96, 160, 96, 3, 83, 83, 72, 144, 72, 3,
  66, 82, 240, 16, 20, 49, 81, 224, 1, 87, 87, 112, 136, 232, 200, 200,
  136, 112, 7, 65, 81, 240, 21, 51, 83, 64, 160, 64, 2, 86, 86, 32,
  32, 248, 32, 32, 248, 20, 36, 84, 192, 64, 128, 192, 20, 36, 84, 192,
  192, 64, 192, 22, 34, 82, 64, 128, 1, 69, 85, 144, 144, 144, 224, 128,
  2, 70, 86, 112, 208, 208, 80, 80, 80, 20, 34, 82, 192, 192, 17, 34,
  82, 64, 128, 20, 52, 84, 64, 192, 64, 224, 5, 51, 83, 64, 160, 64,
  3, 83, 83, 144, 72, 144, 1, 71, 87, 128, 128, 128, 144, 48, 112, 16,
  1, 71, 87, 128, 128, 128, 176, 16, 32, 48, 1, 71, 87, 192, 192, 64,
  208, 48, 112, 16, 18, 54, 86, 64, 0, 64, 128, 160, 64, 2, 70, 86,
  96, 144, 144, 240, 144, 144, 2, 70, 86, 96, 144, 144, 240, 144, 144, 2,
  70, 86, 96, 144, 144, 240, 144, 144, 2, 70, 86, 96, 144, 144, 240, 144,
  144, 2, 70, 86, 144, 96, 144, 240, 144, 144, 2, 70, 86, 96, 96, 144,
  240, 144, 144, 2, 70, 86, 112, 160, 176, 224, 160, 176, 1, 71, 87, 96,
  144, 128, 128, 144, 96, 64, 2, 70, 86, 240, 128, 224, 128, 128, 240, 2,
  70, 86, 240, 128, 224, 128, 128, 240, 2, 70, 86, 240, 128, 224, 128, 128,
  240, 2, 70, 86, 240, 128, 224, 128, 128, 240, 18, 54, 86, 224, 64, 64,
  64, 64, 224, 18, 54, 86, 224, 64, 64, 64, 64, 224, 18, 54, 86, 224,
  64, 64, 64, 64, 224, 18, 54, 86, 224, 64, 64, 64, 64, 224, 2, 70,
  86, 224, 80, 208, 80, 80, 224, 2, 70, 86, 176, 144, 208, 176, 176, 144,
  2, 70, 86, 96, 144, 144, 144, 144, 96, 2, 70, 86, 96, 144, 144, 144,
  144, 96, 2, 70, 86, 96, 144, 144, 144, 144, 96, 2, 70, 86, 96, 144,
  144, 144, 144, 96, 2, 70, 86, 144, 96, 144, 144, 144, 96, 2, 68, 84,
  144, 96, 96, 144, 2, 70, 86, 112, 176, 176, 208, 208, 224, 2, 70, 86,
  144, 144, 144, 144, 144, 96, 2, 70, 86, 144, 144, 144, 144, 144, 96, 2,
  70, 86, 144, 144, 144, 144, 144, 96, 2, 70, 86, 144, 0, 144, 144, 144,
  96, 18, 54, 86, 160, 160, 160, 64, 64, 64, 2, 70, 86, 128, 224, 144,
  224, 128, 128, 2, 70, 86, 96, 144, 160, 144, 144, 160, 2, 70, 86, 64,
  32, 112, 144, 176, 80, 2, 70, 86, 32, 64, 112, 144, 176, 80, 2, 70,
  86, 32, 80, 112, 144, 176, 80, 2, 70, 86, 80, 160, 112, 144, 176, 80,
  2, 70, 86, 80, 0, 112, 144, 176, 80, 2, 70, 86, 96, 96, 112, 144,
  176, 80, 2, 68, 84, 112, 176, 160, 112, 17, 53, 85, 96, 128, 128, 96,
  64, 2, 70, 86, 64, 32, 96, 176, 192, 96, 2, 70, 86, 32, 64, 96,
  176, 192, 96, 2, 70, 86, 64, 160, 96, 176, 192, 96, 2, 70, 86, 160,
  0, 96, 176, 192, 96, 18, 54, 86, 128, 64, 192, 64, 64, 224, 18, 54,
  86, 64, 128, 192, 64, 64, 224, 18, 54, 86, 64, 160, 192, 64, 64, 224,
  18, 54, 86, 160, 0, 192, 64, 64, 224, 2, 70, 86, 64, 48, 96, 144,
  144, 96, 2, 70, 86, 80, 160, 224, 144, 144, 144, 2, 70, 86, 64, 32,
  96, 144, 144, 96, 2, 70, 86, 32, 64, 96, 144, 144, 96, 2, 70, 86,
  96, 0, 96, 144, 144, 96, 2, 70, 86, 80, 160, 96, 144, 144, 96, 2,
  70, 86, 80, 0, 96, 144, 144, 96, 2, 69, 85, 96, 0, 240, 0, 96,
  2, 68, 84, 112, 176, 208, 224, 2, 70, 86, 64, 32, 144, 144, 144, 112,
  2, 70, 86, 32, 64, 144, 144, 144, 112, 2, 70, 86, 96, 0, 144, 144,
  144, 112, 2, 70, 86, 80, 0, 144, 144, 144, 112, 1, 71, 87, 32, 64,
  144, 144, 80, 32, 64, 1, 70, 86, 128, 224, 144, 144, 224, 128, 1, 71,
  87, 80, 0, 144, 144, 80, 32, 64
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--7-70-75-75-C-50-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 6, '1' Height: 6
  Calculated Max Values w= 5 h= 7 x= 2 y= 6 dx= 5 dy= 0 ascent= 6 len= 7
  Font Bounding box     w= 5 h= 7 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 6 descent=-1
  X Font      ascent = 6 descent=-1
  Max Font    ascent = 6 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_5x7r[789] U8G_FONT_SECTION("u8g_font_5x7r") = {
  1, 5, 7, 0, 255, 6, 1, 21, 2, 39, 32, 127, 255, 6, 255, 6,
  255, 8, 0, 80, 34, 22, 86, 128, 128, 128, 128, 0, 128, 21, 51, 83,
  160, 160, 160, 2, 85, 85, 80, 248, 80, 248, 80, 2, 85, 85, 112, 160,
  112, 40, 112, 2, 70, 86, 128, 144, 32, 64, 144, 16, 2, 69, 85, 64,
  160, 64, 160, 80, 37, 19, 83, 128, 128, 128, 18, 38, 86, 64, 128, 128,
  128, 128, 64, 18, 38, 86, 128, 64, 64, 64, 64, 128, 18, 53, 85, 160,
  64, 224, 64, 160, 2, 85, 85, 32, 32, 248, 32, 32, 17, 51, 83, 96,
  64, 128, 4, 65, 81, 240, 18, 34, 82, 192, 192, 3, 68, 84, 16, 32,
  64, 128, 18, 54, 86, 64, 160, 160, 160, 160, 64, 18, 54, 86, 64, 192,
  64, 64, 64, 224, 2, 70, 86, 96, 144, 16, 32, 64, 240, 2, 70, 86,
  240, 16, 96, 16, 144, 96, 2, 70, 86, 32, 96, 160, 240, 32, 32, 2,
  70, 86, 240, 128, 224, 16, 144, 96, 2, 70, 86, 96, 128, 224, 144, 144,
  96, 2, 70, 86, 240, 16, 32, 32, 64, 64, 2, 70, 86, 96, 144, 96,
  144, 144, 96, 2, 70, 86, 96, 144, 144, 112, 16, 96, 18, 37, 85, 192,
  192, 0, 192, 192, 1, 54, 86, 96, 96, 0, 96, 64, 128, 18, 53, 85,
  32, 64, 128, 64, 32, 3, 67, 83, 240, 0, 240, 18, 53, 85, 128, 64,
  32, 64, 128, 18, 54, 86, 64, 160, 32, 64, 0, 64, 2, 70, 86, 96,
  144, 176, 176, 128, 96, 2, 70, 86, 96, 144, 144, 240, 144, 144, 2, 70,
  86, 224, 144, 224, 144, 144, 224, 2, 70, 86, 96, 144, 128, 128, 144, 96,
  2, 70, 86, 224, 144, 144, 144, 144, 224, 2, 70, 86, 240, 128, 224, 128,
  128, 240, 2, 70, 86, 240, 128, 224, 128, 128, 128, 2, 70, 86, 96, 144,
  128, 176, 144, 112, 2, 70, 86, 144, 144, 240, 144, 144, 144, 18, 54, 86,
  224, 64, 64, 64, 64, 224, 2, 70, 86, 16, 16, 16, 16, 144, 96, 2,
  70, 86, 144, 160, 192, 192, 160, 144, 2, 70, 86, 128, 128, 128, 128, 128,
  240, 2, 70, 86, 144, 240, 240, 144, 144, 144, 2, 70, 86, 144, 208, 208,
  176, 176, 144, 2, 70, 86, 96, 144, 144, 144, 144, 96, 2, 70, 86, 224,
  144, 144, 224, 128, 128, 1, 71, 87, 96, 144, 144, 144, 208, 96, 16, 2,
  70, 86, 224, 144, 144, 224, 160, 144, 2, 70, 86, 96, 144, 64, 32, 144,
  96, 18, 54, 86, 224, 64, 64, 64, 64, 64, 2, 70, 86, 144, 144, 144,
  144, 144, 96, 2, 70, 86, 144, 144, 144, 144, 96, 96, 2, 70, 86, 144,
  144, 144, 240, 240, 144, 2, 70, 86, 144, 144, 96, 96, 144, 144, 18, 54,
  86, 160, 160, 160, 64, 64, 64, 2, 70, 86, 240, 16, 32, 64, 128, 240,
  18, 54, 86, 224, 128, 128, 128, 128, 224, 3, 68, 84, 128, 64, 32, 16,
  18, 54, 86, 224, 32, 32, 32, 32, 224, 22, 50, 82, 64, 160, 2, 65,
  81, 240, 22, 34, 82, 128, 64, 2, 68, 84, 112, 144, 176, 80, 2, 70,
  86, 128, 128, 224, 144, 144, 224, 2, 52, 84, 96, 128, 128, 96, 2, 70,
  86, 16, 16, 112, 144, 144, 112, 2, 68, 84, 96, 176, 192, 96, 2, 70,
  86, 32, 80, 64, 224, 64, 64, 1, 69, 85, 112, 144, 96, 128, 112, 2,
  70, 86, 128, 128, 224, 144, 144, 144, 18, 54, 86, 64, 0, 192, 64, 64,
  224, 17, 55, 87, 32, 0, 32, 32, 32, 160, 64, 2, 70, 86, 128, 128,
  160, 192, 160, 144, 18, 54, 86, 192, 64, 64, 64, 64, 224, 2, 68, 84,
  160, 240, 144, 144, 2, 68, 84, 224, 144, 144, 144, 2, 68, 84, 96, 144,
  144, 96, 1, 69, 85, 224, 144, 144, 224, 128, 1, 69, 85, 112, 144, 144,
  112, 16, 2, 68, 84, 224, 144, 128, 128, 2, 68, 84, 112, 192, 48, 224,
  2, 70, 86, 64, 64, 224, 64, 64, 48, 2, 68, 84, 144, 144, 144, 112,
  18, 52, 84, 160, 160, 160, 64, 2, 68, 84, 144, 144, 240, 240, 2, 68,
  84, 144, 96, 96, 144, 1, 69, 85, 144, 144, 80, 32, 64, 2, 68, 84,
  240, 32, 64, 240, 18, 54, 86, 32, 64, 192, 64, 64, 32, 34, 22, 86,
  128, 128, 128, 128, 128, 128, 18, 54, 86, 128, 64, 96, 64, 64, 128, 6,
  66, 82, 80, 160, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--8-80-75-75-C-50-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 6, '1' Height: 6
  Calculated Max Values w= 5 h= 8 x= 2 y= 7 dx= 5 dy= 0 ascent= 7 len= 8
  Font Bounding box     w= 5 h= 8 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 6 descent=-1
  X Font      ascent = 6 descent=-1
  Max Font    ascent = 7 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_5x8[1693] U8G_FONT_SECTION("u8g_font_5x8") = {
  1, 5, 8, 0, 255, 6, 1, 33, 2, 53, 32, 255, 255, 7, 255, 6,
  255, 9, 0, 80, 34, 22, 86, 128, 128, 128, 128, 0, 128, 21, 51, 83,
  160, 160, 160, 2, 87, 87, 80, 80, 248, 80, 248, 80, 80, 2, 87, 87,
  32, 112, 160, 112, 40, 112, 32, 19, 53, 85, 128, 160, 64, 160, 32, 2,
  71, 87, 64, 160, 160, 64, 160, 160, 80, 37, 19, 83, 128, 128, 128, 18,
  38, 86, 64, 128, 128, 128, 128, 64, 18, 38, 86, 128, 64, 64, 64, 64,
  128, 2, 69, 85, 144, 96, 240, 96, 144, 2, 85, 85, 32, 32, 248, 32,
  32, 17, 51, 83, 96, 64, 128, 4, 65, 81, 240, 17, 51, 83, 64, 224,
  64, 2, 70, 86, 16, 16, 32, 64, 128, 128, 18, 54, 86, 64, 160, 160,
  160, 160, 64, 18, 54, 86, 64, 192, 64, 64, 64, 224, 2, 70, 86, 96,
  144, 16, 96, 128, 240, 2, 70, 86, 240, 32, 96, 16, 144, 96, 2, 70,
  86, 32, 96, 160, 240, 32, 32, 2, 70, 86, 240, 128, 224, 16, 144, 96,
  2, 70, 86, 96, 128, 224, 144, 144, 96, 2, 70, 86, 240, 16, 32, 32,
  64, 64, 2, 70, 86, 96, 144, 96, 144, 144, 96, 2, 70, 86, 96, 144,
  144, 112, 16, 96, 18, 37, 85, 192, 192, 0, 192, 192, 17, 54, 86, 96,
  96, 0, 96, 64, 128, 18, 54, 86, 32, 64, 128, 128, 64, 32, 3, 67,
  83, 240, 0, 240, 18, 54, 86, 128, 64, 32, 32, 64, 128, 18, 54, 86,
  64, 160, 32, 64, 0, 64, 1, 88, 88, 48, 72, 152, 168, 168, 144, 64,
  48, 2, 70, 86, 96, 144, 144, 240, 144, 144, 2, 70, 86, 224, 144, 224,
  144, 144, 224, 2, 70, 86, 96, 144, 128, 128, 144, 96, 2, 70, 86, 224,
  144, 144, 144, 144, 224, 2, 70, 86, 240, 128, 224, 128, 128, 240, 2, 70,
  86, 240, 128, 224, 128, 128, 128, 2, 70, 86, 96, 144, 128, 176, 144, 96,
  2, 70, 86, 144, 144, 240, 144, 144, 144, 18, 54, 86, 224, 64, 64, 64,
  64, 224, 2, 70, 86, 112, 32, 32, 32, 160, 64, 2, 70, 86, 144, 160,
  192, 160, 160, 144, 2, 70, 86, 128, 128, 128, 128, 128, 240, 2, 70, 86,
  144, 240, 240, 144, 144, 144, 2, 70, 86, 144, 208, 240, 176, 176, 144, 2,
  70, 86, 96, 144, 144, 144, 144, 96, 2, 70, 86, 224, 144, 144, 224, 128,
  128, 1, 71, 87, 96, 144, 144, 208, 176, 96, 16, 2, 70, 86, 224, 144,
  144, 224, 144, 144, 2, 70, 86, 96, 144, 64, 32, 144, 96, 18, 54, 86,
  224, 64, 64, 64, 64, 64, 2, 70, 86, 144, 144, 144, 144, 144, 96, 2,
  70, 86, 144, 144, 144, 144, 96, 96, 2, 70, 86, 144, 144, 144, 240, 240,
  144, 2, 70, 86, 144, 144, 96, 96, 144, 144, 2, 86, 86, 136, 136, 80,
  32, 32, 32, 2, 70, 86, 240, 16, 32, 64, 128, 240, 18, 54, 86, 224,
  128, 128, 128, 128, 224, 2, 70, 86, 128, 128, 64, 32, 16, 16, 18, 54,
  86, 224, 32, 32, 32, 32, 224, 22, 50, 82, 64, 160, 1, 65, 81, 240,
  22, 34, 82, 128, 64, 2, 68, 84, 112, 144, 144, 112, 2, 70, 86, 128,
  128, 224, 144, 144, 224, 18, 52, 84, 96, 128, 128, 96, 2, 70, 86, 16,
  16, 112, 144, 144, 112, 2, 68, 84, 96, 176, 192, 96, 2, 70, 86, 32,
  80, 64, 224, 64, 64, 1, 69, 85, 96, 144, 112, 16, 96, 2, 70, 86,
  128, 128, 224, 144, 144, 144, 18, 54, 86, 64, 0, 192, 64, 64, 224, 17,
  55, 87, 32, 0, 32, 32, 32, 160, 64, 2, 70, 86, 128, 128, 144, 224,
  144, 144, 18, 54, 86, 192, 64, 64, 64, 64, 224, 2, 84, 84, 208, 168,
  168, 168, 2, 68, 84, 224, 144, 144, 144, 2, 68, 84, 96, 144, 144, 96,
  1, 69, 85, 224, 144, 224, 128, 128, 1, 69, 85, 112, 144, 112, 16, 16,
  2, 68, 84, 160, 208, 128, 128, 18, 52, 84, 96, 192, 32, 192, 2, 70,
  86, 64, 64, 224, 64, 80, 32, 2, 68, 84, 144, 144, 144, 112, 18, 52,
  84, 160, 160, 160, 64, 2, 84, 84, 136, 168, 168, 80, 2, 68, 84, 144,
  96, 96, 144, 1, 69, 85, 144, 144, 112, 144, 96, 2, 68, 84, 240, 32,
  64, 240, 2, 71, 87, 48, 64, 32, 192, 32, 64, 48, 34, 22, 86, 128,
  128, 128, 128, 128, 128, 2, 71, 87, 192, 32, 64, 48, 64, 32, 192, 6,
  66, 82, 80, 160, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 9, 0, 80, 34, 22, 86, 128, 0, 128, 128, 128,
  128, 1, 70, 86, 32, 112, 160, 160, 112, 32, 2, 70, 86, 32, 80, 224,
  64, 80, 160, 2, 85, 85, 136, 112, 80, 112, 136, 2, 86, 86, 136, 80,
  248, 32, 248, 32, 34, 23, 87, 128, 128, 128, 0, 128, 128, 128, 2, 71,
  87, 112, 128, 224, 144, 112, 16, 224, 23, 49, 81, 160, 2, 86, 86, 112,
  168, 200, 200, 168, 112, 20, 53, 85, 96, 160, 96, 0, 224, 3, 67, 83,
  80, 160, 80, 18, 51, 83, 224, 32, 32, 20, 49, 81, 224, 2, 86, 86,
  112, 232, 216, 232, 216, 112, 23, 49, 81, 224, 21, 51, 83, 64, 160, 64,
  18, 53, 85, 64, 224, 64, 0, 224, 20, 53, 85, 64, 160, 32, 64, 224,
  20, 53, 85, 192, 32, 192, 32, 192, 22, 34, 82, 64, 128, 1, 69, 85,
  144, 144, 144, 224, 128, 2, 86, 86, 120, 232, 232, 104, 40, 40, 36, 17,
  81, 128, 17, 34, 82, 64, 128, 20, 53, 85, 64, 192, 64, 64, 224, 20,
  53, 85, 64, 160, 64, 0, 224, 3, 67, 83, 160, 80, 160, 2, 71, 87,
  128, 128, 128, 160, 96, 240, 32, 2, 71, 87, 128, 128, 160, 208, 16, 32,
  112, 2, 71, 87, 128, 64, 128, 96, 160, 240, 32, 18, 54, 86, 64, 0,
  64, 128, 160, 64, 2, 71, 87, 64, 32, 96, 144, 240, 144, 144, 2, 71,
  87, 32, 64, 96, 144, 240, 144, 144, 2, 71, 87, 96, 144, 96, 144, 240,
  144, 144, 2, 71, 87, 80, 160, 96, 144, 240, 144, 144, 2, 71, 87, 144,
  0, 96, 144, 240, 144, 144, 2, 71, 87, 96, 144, 96, 144, 240, 144, 144,
  2, 70, 86, 112, 160, 160, 240, 160, 176, 1, 71, 87, 96, 144, 128, 128,
  144, 96, 64, 2, 71, 87, 64, 32, 240, 128, 224, 128, 240, 2, 71, 87,
  32, 64, 240, 128, 224, 128, 240, 2, 71, 87, 96, 144, 240, 128, 224, 128,
  240, 2, 71, 87, 144, 0, 240, 128, 224, 128, 240, 18, 55, 87, 128, 64,
  224, 64, 64, 64, 224, 18, 55, 87, 32, 64, 224, 64, 64, 64, 224, 18,
  55, 87, 64, 160, 224, 64, 64, 64, 224, 18, 55, 87, 160, 0, 224, 64,
  64, 64, 224, 2, 86, 86, 112, 72, 232, 72, 72, 112, 2, 71, 87, 80,
  160, 144, 208, 176, 144, 144, 2, 71, 87, 64, 32, 96, 144, 144, 144, 96,
  2, 71, 87, 32, 64, 96, 144, 144, 144, 96, 2, 71, 87, 96, 144, 96,
  144, 144, 144, 96, 2, 71, 87, 80, 160, 96, 144, 144, 144, 96, 2, 71,
  87, 144, 0, 96, 144, 144, 144, 96, 18, 51, 83, 160, 64, 160, 2, 70,
  86, 112, 176, 176, 208, 208, 224, 2, 71, 87, 64, 32, 144, 144, 144, 144,
  96, 2, 71, 87, 32, 64, 144, 144, 144, 144, 96, 2, 71, 87, 96, 144,
  144, 144, 144, 144, 96, 2, 71, 87, 144, 0, 144, 144, 144, 144, 96, 2,
  87, 87, 16, 32, 136, 80, 32, 32, 32, 2, 70, 86, 128, 224, 144, 144,
  224, 128, 2, 70, 86, 96, 144, 160, 160, 144, 160, 2, 71, 87, 64, 32,
  0, 112, 144, 144, 112, 2, 71, 87, 32, 64, 0, 112, 144, 144, 112, 2,
  71, 87, 32, 80, 0, 112, 144, 144, 112, 2, 71, 87, 80, 160, 0, 112,
  144, 144, 112, 2, 70, 86, 80, 0, 112, 144, 144, 112, 2, 71, 87, 96,
  144, 96, 112, 144, 144, 112, 2, 84, 84, 240, 104, 176, 120, 17, 53, 85,
  96, 128, 128, 96, 64, 2, 71, 87, 64, 32, 0, 96, 176, 192, 96, 2,
  71, 87, 32, 64, 0, 96, 176, 192, 96, 2, 71, 87, 96, 144, 0, 96,
  176, 192, 96, 2, 70, 86, 80, 0, 96, 176, 192, 96, 18, 55, 87, 128,
  64, 0, 192, 64, 64, 224, 18, 55, 87, 32, 64, 0, 192, 64, 64, 224,
  18, 55, 87, 64, 160, 0, 192, 64, 64, 224, 18, 54, 86, 160, 0, 192,
  64, 64, 224, 2, 71, 87, 160, 64, 160, 16, 112, 144, 96, 2, 71, 87,
  80, 160, 0, 224, 144, 144, 144, 2, 71, 87, 64, 32, 0, 96, 144, 144,
  96, 2, 71, 87, 32, 64, 0, 96, 144, 144, 96, 2, 71, 87, 96, 144,
  0, 96, 144, 144, 96, 2, 71, 87, 80, 160, 0, 96, 144, 144, 96, 2,
  70, 86, 144, 0, 96, 144, 144, 96, 18, 53, 85, 64, 0, 224, 0, 64,
  2, 68, 84, 112, 176, 208, 224, 2, 71, 87, 64, 32, 0, 144, 144, 144,
  112, 2, 71, 87, 32, 64, 0, 144, 144, 144, 112, 2, 71, 87, 96, 144,
  0, 144, 144, 144, 112, 2, 70, 86, 144, 0, 144, 144, 144, 112, 1, 72,
  88, 32, 64, 0, 144, 144, 112, 144, 96, 1, 71, 87, 128, 128, 224, 144,
  224, 128, 128, 1, 71, 87, 144, 0, 144, 144, 112, 144, 96
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--8-80-75-75-C-50-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 6, '1' Height: 6
  Calculated Max Values w= 5 h= 8 x= 2 y= 7 dx= 5 dy= 0 ascent= 7 len= 8
  Font Bounding box     w= 5 h= 8 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 6 descent=-1
  X Font      ascent = 6 descent=-1
  Max Font    ascent = 7 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_5x8r[805] U8G_FONT_SECTION("u8g_font_5x8r") = {
  1, 5, 8, 0, 255, 6, 1, 33, 2, 53, 32, 127, 255, 7, 255, 6,
  255, 9, 0, 80, 34, 22, 86, 128, 128, 128, 128, 0, 128, 21, 51, 83,
  160, 160, 160, 2, 87, 87, 80, 80, 248, 80, 248, 80, 80, 2, 87, 87,
  32, 112, 160, 112, 40, 112, 32, 19, 53, 85, 128, 160, 64, 160, 32, 2,
  71, 87, 64, 160, 160, 64, 160, 160, 80, 37, 19, 83, 128, 128, 128, 18,
  38, 86, 64, 128, 128, 128, 128, 64, 18, 38, 86, 128, 64, 64, 64, 64,
  128, 2, 69, 85, 144, 96, 240, 96, 144, 2, 85, 85, 32, 32, 248, 32,
  32, 17, 51, 83, 96, 64, 128, 4, 65, 81, 240, 17, 51, 83, 64, 224,
  64, 2, 70, 86, 16, 16, 32, 64, 128, 128, 18, 54, 86, 64, 160, 160,
  160, 160, 64, 18, 54, 86, 64, 192, 64, 64, 64, 224, 2, 70, 86, 96,
  144, 16, 96, 128, 240, 2, 70, 86, 240, 32, 96, 16, 144, 96, 2, 70,
  86, 32, 96, 160, 240, 32, 32, 2, 70, 86, 240, 128, 224, 16, 144, 96,
  2, 70, 86, 96, 128, 224, 144, 144, 96, 2, 70, 86, 240, 16, 32, 32,
  64, 64, 2, 70, 86, 96, 144, 96, 144, 144, 96, 2, 70, 86, 96, 144,
  144, 112, 16, 96, 18, 37, 85, 192, 192, 0, 192, 192, 17, 54, 86, 96,
  96, 0, 96, 64, 128, 18, 54, 86, 32, 64, 128, 128, 64, 32, 3, 67,
  83, 240, 0, 240, 18, 54, 86, 128, 64, 32, 32, 64, 128, 18, 54, 86,
  64, 160, 32, 64, 0, 64, 1, 88, 88, 48, 72, 152, 168, 168, 144, 64,
  48, 2, 70, 86, 96, 144, 144, 240, 144, 144, 2, 70, 86, 224, 144, 224,
  144, 144, 224, 2, 70, 86, 96, 144, 128, 128, 144, 96, 2, 70, 86, 224,
  144, 144, 144, 144, 224, 2, 70, 86, 240, 128, 224, 128, 128, 240, 2, 70,
  86, 240, 128, 224, 128, 128, 128, 2, 70, 86, 96, 144, 128, 176, 144, 96,
  2, 70, 86, 144, 144, 240, 144, 144, 144, 18, 54, 86, 224, 64, 64, 64,
  64, 224, 2, 70, 86, 112, 32, 32, 32, 160, 64, 2, 70, 86, 144, 160,
  192, 160, 160, 144, 2, 70, 86, 128, 128, 128, 128, 128, 240, 2, 70, 86,
  144, 240, 240, 144, 144, 144, 2, 70, 86, 144, 208, 240, 176, 176, 144, 2,
  70, 86, 96, 144, 144, 144, 144, 96, 2, 70, 86, 224, 144, 144, 224, 128,
  128, 1, 71, 87, 96, 144, 144, 208, 176, 96, 16, 2, 70, 86, 224, 144,
  144, 224, 144, 144, 2, 70, 86, 96, 144, 64, 32, 144, 96, 18, 54, 86,
  224, 64, 64, 64, 64, 64, 2, 70, 86, 144, 144, 144, 144, 144, 96, 2,
  70, 86, 144, 144, 144, 144, 96, 96, 2, 70, 86, 144, 144, 144, 240, 240,
  144, 2, 70, 86, 144, 144, 96, 96, 144, 144, 2, 86, 86, 136, 136, 80,
  32, 32, 32, 2, 70, 86, 240, 16, 32, 64, 128, 240, 18, 54, 86, 224,
  128, 128, 128, 128, 224, 2, 70, 86, 128, 128, 64, 32, 16, 16, 18, 54,
  86, 224, 32, 32, 32, 32, 224, 22, 50, 82, 64, 160, 1, 65, 81, 240,
  22, 34, 82, 128, 64, 2, 68, 84, 112, 144, 144, 112, 2, 70, 86, 128,
  128, 224, 144, 144, 224, 18, 52, 84, 96, 128, 128, 96, 2, 70, 86, 16,
  16, 112, 144, 144, 112, 2, 68, 84, 96, 176, 192, 96, 2, 70, 86, 32,
  80, 64, 224, 64, 64, 1, 69, 85, 96, 144, 112, 16, 96, 2, 70, 86,
  128, 128, 224, 144, 144, 144, 18, 54, 86, 64, 0, 192, 64, 64, 224, 17,
  55, 87, 32, 0, 32, 32, 32, 160, 64, 2, 70, 86, 128, 128, 144, 224,
  144, 144, 18, 54, 86, 192, 64, 64, 64, 64, 224, 2, 84, 84, 208, 168,
  168, 168, 2, 68, 84, 224, 144, 144, 144, 2, 68, 84, 96, 144, 144, 96,
  1, 69, 85, 224, 144, 224, 128, 128, 1, 69, 85, 112, 144, 112, 16, 16,
  2, 68, 84, 160, 208, 128, 128, 18, 52, 84, 96, 192, 32, 192, 2, 70,
  86, 64, 64, 224, 64, 80, 32, 2, 68, 84, 144, 144, 144, 112, 18, 52,
  84, 160, 160, 160, 64, 2, 84, 84, 136, 168, 168, 80, 2, 68, 84, 144,
  96, 96, 144, 1, 69, 85, 144, 144, 112, 144, 96, 2, 68, 84, 240, 32,
  64, 240, 2, 71, 87, 48, 64, 32, 192, 32, 64, 48, 34, 22, 86, 128,
  128, 128, 128, 128, 128, 2, 71, 87, 192, 32, 64, 48, 64, 32, 192, 6,
  66, 82, 80, 160, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--10-100-75-75-C-60-ISO10646-1
  Copyright: Public domain terminal emulator font.  Share and enjoy.
  Capital A Height: 7, '1' Height: 7
  Calculated Max Values w= 6 h= 9 x= 2 y= 8 dx= 6 dy= 0 ascent= 8 len= 9
  Font Bounding box     w= 6 h=10 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 7 descent=-2
  X Font      ascent = 7 descent=-2
  Max Font    ascent = 8 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x10[1866] U8G_FONT_SECTION("u8g_font_6x10") = {
  1, 6, 10, 0, 254, 7, 1, 54, 2, 104, 32, 255, 254, 8, 254, 7,
  254, 10, 0, 96, 34, 23, 103, 128, 128, 128, 128, 128, 0, 128, 22, 51,
  99, 160, 160, 160, 2, 87, 103, 80, 80, 248, 80, 248, 80, 80, 2, 87,
  103, 32, 112, 160, 112, 40, 112, 32, 2, 87, 103, 72, 168, 80, 32, 80,
  168, 144, 2, 87, 103, 64, 160, 160, 64, 168, 144, 104, 38, 19, 99, 128,
  128, 128, 18, 55, 103, 32, 64, 128, 128, 128, 64, 32, 18, 55, 103, 128,
  64, 32, 32, 32, 64, 128, 3, 85, 101, 136, 80, 248, 80, 136, 3, 85,
  101, 32, 32, 248, 32, 32, 17, 51, 99, 96, 64, 128, 5, 81, 97, 248,
  17, 51, 99, 64, 224, 64, 2, 87, 103, 8, 8, 16, 32, 64, 128, 128,
  2, 87, 103, 32, 80, 136, 136, 136, 80, 32, 2, 87, 103, 32, 96, 160,
  32, 32, 32, 248, 2, 87, 103, 112, 136, 8, 48, 64, 128, 248, 2, 87,
  103, 248, 8, 16, 48, 8, 136, 112, 2, 87, 103, 16, 48, 80, 144, 248,
  16, 16, 2, 87, 103, 248, 128, 176, 200, 8, 136, 112, 2, 87, 103, 48,
  64, 128, 176, 200, 136, 112, 2, 87, 103, 248, 8, 16, 16, 32, 64, 64,
  2, 87, 103, 112, 136, 136, 112, 136, 136, 112, 2, 87, 103, 112, 136, 152,
  104, 8, 16, 96, 17, 55, 103, 64, 224, 64, 0, 64, 224, 64, 17, 55,
  103, 64, 224, 64, 0, 96, 64, 128, 18, 71, 103, 16, 32, 64, 128, 64,
  32, 16, 4, 83, 99, 248, 0, 248, 18, 71, 103, 128, 64, 32, 16, 32,
  64, 128, 2, 87, 103, 112, 136, 16, 32, 32, 0, 32, 2, 87, 103, 112,
  136, 152, 168, 176, 128, 112, 2, 87, 103, 32, 80, 136, 136, 248, 136, 136,
  2, 87, 103, 240, 72, 72, 112, 72, 72, 240, 2, 87, 103, 112, 136, 128,
  128, 128, 136, 112, 2, 87, 103, 240, 72, 72, 72, 72, 72, 240, 2, 87,
  103, 248, 128, 128, 240, 128, 128, 248, 2, 87, 103, 248, 128, 128, 240, 128,
  128, 128, 2, 87, 103, 112, 136, 128, 128, 152, 136, 112, 2, 87, 103, 136,
  136, 136, 248, 136, 136, 136, 18, 55, 103, 224, 64, 64, 64, 64, 64, 224,
  2, 87, 103, 56, 16, 16, 16, 16, 144, 96, 2, 87, 103, 136, 144, 160,
  192, 160, 144, 136, 2, 87, 103, 128, 128, 128, 128, 128, 128, 248, 2, 87,
  103, 136, 136, 216, 168, 136, 136, 136, 2, 87, 103, 136, 136, 200, 168, 152,
  136, 136, 2, 87, 103, 112, 136, 136, 136, 136, 136, 112, 2, 87, 103, 240,
  136, 136, 240, 128, 128, 128, 1, 88, 104, 112, 136, 136, 136, 136, 168, 112,
  8, 2, 87, 103, 240, 136, 136, 240, 160, 144, 136, 2, 87, 103, 112, 136,
  128, 112, 8, 136, 112, 2, 87, 103, 248, 32, 32, 32, 32, 32, 32, 2,
  87, 103, 136, 136, 136, 136, 136, 136, 112, 2, 87, 103, 136, 136, 136, 80,
  80, 80, 32, 2, 87, 103, 136, 136, 136, 168, 168, 216, 136, 2, 87, 103,
  136, 136, 80, 32, 80, 136, 136, 2, 87, 103, 136, 136, 80, 32, 32, 32,
  32, 2, 87, 103, 248, 8, 16, 32, 64, 128, 248, 18, 55, 103, 224, 128,
  128, 128, 128, 128, 224, 2, 87, 103, 128, 128, 64, 32, 16, 8, 8, 18,
  55, 103, 224, 32, 32, 32, 32, 32, 224, 6, 83, 99, 32, 80, 136, 1,
  81, 97, 248, 40, 34, 98, 128, 64, 2, 85, 101, 112, 8, 120, 136, 120,
  2, 87, 103, 128, 128, 176, 200, 136, 200, 176, 2, 85, 101, 112, 136, 128,
  136, 112, 2, 87, 103, 8, 8, 104, 152, 136, 152, 104, 2, 85, 101, 112,
  136, 248, 128, 112, 2, 87, 103, 48, 72, 64, 240, 64, 64, 64, 0, 87,
  103, 120, 136, 136, 120, 8, 136, 112, 2, 87, 103, 128, 128, 176, 200, 136,
  136, 136, 18, 55, 103, 64, 0, 192, 64, 64, 64, 224, 16, 73, 105, 16,
  0, 48, 16, 16, 16, 144, 144, 96, 2, 87, 103, 128, 128, 136, 144, 224,
  144, 136, 18, 55, 103, 192, 64, 64, 64, 64, 64, 224, 2, 85, 101, 208,
  168, 168, 168, 136, 2, 85, 101, 176, 200, 136, 136, 136, 2, 85, 101, 112,
  136, 136, 136, 112, 0, 87, 103, 176, 200, 136, 200, 176, 128, 128, 0, 87,
  103, 104, 152, 136, 152, 104, 8, 8, 2, 85, 101, 176, 200, 128, 128, 128,
  2, 85, 101, 112, 128, 112, 8, 240, 2, 87, 103, 64, 64, 240, 64, 64,
  72, 48, 2, 85, 101, 136, 136, 136, 152, 104, 2, 85, 101, 136, 136, 80,
  80, 32, 2, 85, 101, 136, 136, 168, 168, 80, 2, 85, 101, 136, 80, 32,
  80, 136, 0, 87, 103, 136, 136, 152, 104, 8, 136, 112, 2, 85, 101, 248,
  16, 32, 64, 248, 18, 71, 103, 48, 64, 32, 192, 32, 64, 48, 34, 23,
  103, 128, 128, 128, 128, 128, 128, 128, 18, 71, 103, 192, 32, 64, 48, 64,
  32, 192, 6, 83, 99, 72, 168, 144, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 10, 0, 96, 34, 23, 103, 128,
  0, 128, 128, 128, 128, 128, 1, 87, 103, 32, 120, 160, 160, 160, 120, 32,
  2, 87, 103, 48, 72, 64, 224, 64, 72, 176, 2, 85, 101, 136, 112, 80,
  112, 136, 1, 88, 104, 136, 136, 80, 32, 248, 32, 32, 32, 34, 23, 103,
  128, 128, 128, 0, 128, 128, 128, 1, 88, 104, 112, 128, 224, 144, 72, 56,
  8, 112, 25, 49, 97, 160, 2, 87, 103, 112, 136, 168, 200, 168, 136, 112,
  19, 70, 102, 112, 144, 176, 80, 0, 240, 2, 101, 101, 36, 72, 144, 72,
  36, 20, 66, 98, 240, 16, 21, 65, 97, 240, 2, 87, 103, 112, 136, 232,
  200, 200, 136, 112, 9, 81, 97, 248, 22, 51, 99, 64, 160, 64, 2, 86,
  102, 32, 32, 248, 32, 32, 248, 21, 69, 101, 96, 144, 32, 64, 240, 21,
  69, 101, 224, 16, 96, 16, 224, 40, 34, 98, 64, 128, 1, 86, 102, 136,
  136, 136, 200, 176, 128, 2, 87, 103, 120, 232, 232, 104, 40, 40, 40, 37,
  17, 97, 128, 32, 34, 98, 64, 128, 21, 53, 101, 64, 192, 64, 64, 224,
  19, 70, 102, 96, 144, 144, 96, 0, 240, 2, 101, 101, 144, 72, 36, 72,
  144, 1, 105, 105, 64, 192, 64, 64, 228, 12, 20, 60, 4, 1, 105, 105,
  64, 192, 64, 64, 232, 20, 4, 8, 28, 1, 89, 105, 192, 32, 64, 32,
  200, 24, 40, 120, 8, 2, 87, 103, 32, 0, 32, 32, 64, 136, 112, 2,
  88, 104, 64, 32, 112, 136, 136, 248, 136, 136, 2, 88, 104, 16, 32, 112,
  136, 136, 248, 136, 136, 2, 88, 104, 32, 80, 112, 136, 136, 248, 136, 136,
  2, 88, 104, 72, 176, 112, 136, 136, 248, 136, 136, 2, 88, 104, 80, 0,
  112, 136, 136, 248, 136, 136, 2, 88, 104, 32, 80, 112, 136, 136, 248, 136,
  136, 2, 103, 103, 60, 80, 144, 156, 240, 144, 156, 0, 89, 105, 112, 136,
  128, 128, 128, 136, 112, 32, 64, 2, 88, 104, 64, 248, 128, 128, 240, 128,
  128, 248, 2, 88, 104, 16, 248, 128, 128, 240, 128, 128, 248, 2, 88, 104,
  32, 248, 128, 128, 240, 128, 128, 248, 2, 88, 104, 80, 248, 128, 128, 240,
  128, 128, 248, 18, 56, 104, 128, 64, 224, 64, 64, 64, 64, 224, 18, 56,
  104, 32, 64, 224, 64, 64, 64, 64, 224, 18, 56, 104, 64, 160, 224, 64,
  64, 64, 64, 224, 18, 56, 104, 160, 0, 224, 64, 64, 64, 64, 224, 2,
  87, 103, 240, 72, 72, 232, 72, 72, 240, 2, 88, 104, 40, 80, 136, 200,
  168, 152, 136, 136, 2, 88, 104, 64, 32, 112, 136, 136, 136, 136, 112, 2,
  88, 104, 16, 32, 112, 136, 136, 136, 136, 112, 2, 88, 104, 32, 80, 112,
  136, 136, 136, 136, 112, 2, 88, 104, 40, 80, 112, 136, 136, 136, 136, 112,
  2, 88, 104, 80, 0, 112, 136, 136, 136, 136, 112, 2, 85, 101, 136, 80,
  32, 80, 136, 2, 87, 103, 112, 152, 152, 168, 200, 200, 112, 2, 88, 104,
  64, 32, 136, 136, 136, 136, 136, 112, 2, 88, 104, 16, 32, 136, 136, 136,
  136, 136, 112, 2, 88, 104, 32, 80, 0, 136, 136, 136, 136, 112, 2, 88,
  104, 80, 0, 136, 136, 136, 136, 136, 112, 2, 88, 104, 16, 32, 136, 136,
  80, 32, 32, 32, 2, 87, 103, 128, 240, 136, 240, 128, 128, 128, 2, 87,
  103, 112, 136, 144, 160, 144, 136, 176, 2, 88, 104, 64, 32, 0, 112, 8,
  120, 136, 120, 2, 88, 104, 16, 32, 0, 112, 8, 120, 136, 120, 2, 88,
  104, 32, 80, 0, 112, 8, 120, 136, 120, 2, 88, 104, 40, 80, 0, 112,
  8, 120, 136, 120, 2, 87, 103, 80, 0, 112, 8, 120, 136, 120, 2, 88,
  104, 32, 80, 32, 112, 8, 120, 136, 120, 2, 101, 101, 120, 20, 124, 144,
  124, 0, 87, 103, 112, 136, 128, 136, 112, 32, 64, 2, 88, 104, 64, 32,
  0, 112, 136, 248, 128, 112, 2, 88, 104, 16, 32, 0, 112, 136, 248, 128,
  112, 2, 88, 104, 32, 80, 0, 112, 136, 248, 128, 112, 2, 87, 103, 80,
  0, 112, 136, 248, 128, 112, 18, 56, 104, 128, 64, 0, 192, 64, 64, 64,
  224, 18, 56, 104, 64, 128, 0, 192, 64, 64, 64, 224, 18, 56, 104, 64,
  160, 0, 192, 64, 64, 64, 224, 18, 55, 103, 160, 0, 192, 64, 64, 64,
  224, 2, 87, 103, 192, 48, 112, 136, 136, 136, 112, 2, 88, 104, 40, 80,
  0, 176, 200, 136, 136, 136, 2, 88, 104, 64, 32, 0, 112, 136, 136, 136,
  112, 2, 88, 104, 16, 32, 0, 112, 136, 136, 136, 112, 2, 88, 104, 32,
  80, 0, 112, 136, 136, 136, 112, 2, 88, 104, 40, 80, 0, 112, 136, 136,
  136, 112, 2, 87, 103, 80, 0, 112, 136, 136, 136, 112, 3, 85, 101, 32,
  0, 248, 0, 32, 2, 85, 101, 120, 152, 168, 200, 240, 2, 88, 104, 64,
  32, 0, 136, 136, 136, 152, 104, 2, 88, 104, 16, 32, 0, 136, 136, 136,
  152, 104, 2, 88, 104, 32, 80, 0, 136, 136, 136, 152, 104, 2, 87, 103,
  80, 0, 136, 136, 136, 152, 104, 0, 89, 105, 16, 32, 136, 136, 152, 104,
  8, 136, 112, 0, 88, 104, 128, 240, 136, 136, 136, 240, 128, 128, 0, 89,
  105, 80, 0, 136, 136, 152, 104, 8, 136, 112
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--10-100-75-75-C-60-ISO10646-1
  Copyright: Public domain terminal emulator font.  Share and enjoy.
  Capital A Height: 7, '1' Height: 7
  Calculated Max Values w= 5 h= 9 x= 2 y= 8 dx= 6 dy= 0 ascent= 8 len= 9
  Font Bounding box     w= 6 h=10 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 7 descent=-2
  X Font      ascent = 7 descent=-2
  Max Font    ascent = 8 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x10r[889] U8G_FONT_SECTION("u8g_font_6x10r") = {
  1, 6, 10, 0, 254, 7, 1, 54, 2, 104, 32, 127, 254, 8, 254, 7,
  254, 10, 0, 96, 34, 23, 103, 128, 128, 128, 128, 128, 0, 128, 22, 51,
  99, 160, 160, 160, 2, 87, 103, 80, 80, 248, 80, 248, 80, 80, 2, 87,
  103, 32, 112, 160, 112, 40, 112, 32, 2, 87, 103, 72, 168, 80, 32, 80,
  168, 144, 2, 87, 103, 64, 160, 160, 64, 168, 144, 104, 38, 19, 99, 128,
  128, 128, 18, 55, 103, 32, 64, 128, 128, 128, 64, 32, 18, 55, 103, 128,
  64, 32, 32, 32, 64, 128, 3, 85, 101, 136, 80, 248, 80, 136, 3, 85,
  101, 32, 32, 248, 32, 32, 17, 51, 99, 96, 64, 128, 5, 81, 97, 248,
  17, 51, 99, 64, 224, 64, 2, 87, 103, 8, 8, 16, 32, 64, 128, 128,
  2, 87, 103, 32, 80, 136, 136, 136, 80, 32, 2, 87, 103, 32, 96, 160,
  32, 32, 32, 248, 2, 87, 103, 112, 136, 8, 48, 64, 128, 248, 2, 87,
  103, 248, 8, 16, 48, 8, 136, 112, 2, 87, 103, 16, 48, 80, 144, 248,
  16, 16, 2, 87, 103, 248, 128, 176, 200, 8, 136, 112, 2, 87, 103, 48,
  64, 128, 176, 200, 136, 112, 2, 87, 103, 248, 8, 16, 16, 32, 64, 64,
  2, 87, 103, 112, 136, 136, 112, 136, 136, 112, 2, 87, 103, 112, 136, 152,
  104, 8, 16, 96, 17, 55, 103, 64, 224, 64, 0, 64, 224, 64, 17, 55,
  103, 64, 224, 64, 0, 96, 64, 128, 18, 71, 103, 16, 32, 64, 128, 64,
  32, 16, 4, 83, 99, 248, 0, 248, 18, 71, 103, 128, 64, 32, 16, 32,
  64, 128, 2, 87, 103, 112, 136, 16, 32, 32, 0, 32, 2, 87, 103, 112,
  136, 152, 168, 176, 128, 112, 2, 87, 103, 32, 80, 136, 136, 248, 136, 136,
  2, 87, 103, 240, 72, 72, 112, 72, 72, 240, 2, 87, 103, 112, 136, 128,
  128, 128, 136, 112, 2, 87, 103, 240, 72, 72, 72, 72, 72, 240, 2, 87,
  103, 248, 128, 128, 240, 128, 128, 248, 2, 87, 103, 248, 128, 128, 240, 128,
  128, 128, 2, 87, 103, 112, 136, 128, 128, 152, 136, 112, 2, 87, 103, 136,
  136, 136, 248, 136, 136, 136, 18, 55, 103, 224, 64, 64, 64, 64, 64, 224,
  2, 87, 103, 56, 16, 16, 16, 16, 144, 96, 2, 87, 103, 136, 144, 160,
  192, 160, 144, 136, 2, 87, 103, 128, 128, 128, 128, 128, 128, 248, 2, 87,
  103, 136, 136, 216, 168, 136, 136, 136, 2, 87, 103, 136, 136, 200, 168, 152,
  136, 136, 2, 87, 103, 112, 136, 136, 136, 136, 136, 112, 2, 87, 103, 240,
  136, 136, 240, 128, 128, 128, 1, 88, 104, 112, 136, 136, 136, 136, 168, 112,
  8, 2, 87, 103, 240, 136, 136, 240, 160, 144, 136, 2, 87, 103, 112, 136,
  128, 112, 8, 136, 112, 2, 87, 103, 248, 32, 32, 32, 32, 32, 32, 2,
  87, 103, 136, 136, 136, 136, 136, 136, 112, 2, 87, 103, 136, 136, 136, 80,
  80, 80, 32, 2, 87, 103, 136, 136, 136, 168, 168, 216, 136, 2, 87, 103,
  136, 136, 80, 32, 80, 136, 136, 2, 87, 103, 136, 136, 80, 32, 32, 32,
  32, 2, 87, 103, 248, 8, 16, 32, 64, 128, 248, 18, 55, 103, 224, 128,
  128, 128, 128, 128, 224, 2, 87, 103, 128, 128, 64, 32, 16, 8, 8, 18,
  55, 103, 224, 32, 32, 32, 32, 32, 224, 6, 83, 99, 32, 80, 136, 1,
  81, 97, 248, 40, 34, 98, 128, 64, 2, 85, 101, 112, 8, 120, 136, 120,
  2, 87, 103, 128, 128, 176, 200, 136, 200, 176, 2, 85, 101, 112, 136, 128,
  136, 112, 2, 87, 103, 8, 8, 104, 152, 136, 152, 104, 2, 85, 101, 112,
  136, 248, 128, 112, 2, 87, 103, 48, 72, 64, 240, 64, 64, 64, 0, 87,
  103, 120, 136, 136, 120, 8, 136, 112, 2, 87, 103, 128, 128, 176, 200, 136,
  136, 136, 18, 55, 103, 64, 0, 192, 64, 64, 64, 224, 16, 73, 105, 16,
  0, 48, 16, 16, 16, 144, 144, 96, 2, 87, 103, 128, 128, 136, 144, 224,
  144, 136, 18, 55, 103, 192, 64, 64, 64, 64, 64, 224, 2, 85, 101, 208,
  168, 168, 168, 136, 2, 85, 101, 176, 200, 136, 136, 136, 2, 85, 101, 112,
  136, 136, 136, 112, 0, 87, 103, 176, 200, 136, 200, 176, 128, 128, 0, 87,
  103, 104, 152, 136, 152, 104, 8, 8, 2, 85, 101, 176, 200, 128, 128, 128,
  2, 85, 101, 112, 128, 112, 8, 240, 2, 87, 103, 64, 64, 240, 64, 64,
  72, 48, 2, 85, 101, 136, 136, 136, 152, 104, 2, 85, 101, 136, 136, 80,
  80, 32, 2, 85, 101, 136, 136, 168, 168, 80, 2, 85, 101, 136, 80, 32,
  80, 136, 0, 87, 103, 136, 136, 152, 104, 8, 136, 112, 2, 85, 101, 248,
  16, 32, 64, 248, 18, 71, 103, 48, 64, 32, 192, 32, 64, 48, 34, 23,
  103, 128, 128, 128, 128, 128, 128, 128, 18, 71, 103, 192, 32, 64, 48, 64,
  32, 192, 6, 83, 99, 72, 168, 144, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-SemiCondensed--12-110-75-75-C-60-ISO10646-1
  Copyright: Public domain terminal emulator font.  Share and enjoy.
  Capital A Height: 3, '1' Height: 8
  Calculated Max Values w= 6 h=12 x= 5 y= 8 dx= 6 dy= 0 ascent=10 len=12
  Font Bounding box     w= 6 h=12 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 3 descent= 0
  X Font      ascent = 8 descent= 0
  Max Font    ascent =10 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x12_67_75[2382] U8G_FONT_SECTION("u8g_font_6x12_67_75") = {
  1, 6, 12, 0, 254, 3, 2, 41, 3, 99, 0, 255, 0, 10, 254, 8,
  0, 2, 87, 103, 168, 0, 136, 0, 136, 0, 168, 2, 87, 103, 240, 136,
  232, 168, 232, 136, 240, 2, 87, 103, 112, 168, 248, 168, 248, 168, 112, 2,
  87, 103, 112, 136, 8, 8, 8, 136, 112, 18, 69, 101, 96, 144, 16, 144,
  96, 1, 88, 104, 112, 136, 128, 128, 136, 120, 8, 8, 2, 87, 103, 32,
  32, 32, 32, 168, 112, 32, 2, 103, 103, 248, 252, 252, 156, 252, 252, 248,
  2, 87, 103, 112, 248, 248, 168, 248, 248, 112, 255, 255, 255, 255, 255, 255,
  255, 3, 85, 101, 32, 64, 248, 64, 32, 2, 87, 103, 32, 112, 168, 32,
  32, 32, 32, 3, 85, 101, 32, 16, 248, 16, 32, 2, 87, 103, 32, 32,
  32, 32, 168, 112, 32, 4, 83, 99, 80, 248, 80, 2, 87, 103, 32, 112,
  168, 32, 168, 112, 32, 2, 89, 105, 192, 240, 224, 160, 32, 16, 16, 8,
  8, 2, 89, 105, 24, 120, 56, 40, 32, 64, 64, 128, 128, 2, 89, 105,
  128, 128, 64, 64, 32, 40, 56, 120, 24, 2, 89, 105, 8, 8, 16, 16,
  32, 160, 224, 240, 192, 3, 101, 101, 40, 72, 252, 80, 48, 3, 101, 101,
  48, 40, 252, 72, 80, 4, 99, 99, 192, 216, 100, 4, 99, 99, 12, 108,
  152, 3, 101, 101, 40, 80, 252, 80, 40, 2, 88, 104, 32, 112, 168, 112,
  168, 32, 32, 32, 3, 101, 101, 80, 40, 252, 40, 80, 2, 88, 104, 32,
  32, 32, 168, 112, 168, 112, 32, 3, 101, 101, 36, 72, 240, 72, 36, 3,
  101, 101, 144, 72, 60, 72, 144, 3, 85, 101, 40, 72, 248, 72, 40, 2,
  87, 103, 32, 112, 168, 32, 32, 32, 248, 3, 85, 101, 160, 144, 248, 144,
  160, 2, 87, 103, 248, 32, 32, 32, 168, 112, 32, 2, 87, 103, 32, 112,
  168, 32, 168, 112, 248, 3, 101, 101, 40, 68, 248, 64, 32, 3, 101, 101,
  80, 136, 124, 8, 16, 3, 101, 101, 32, 76, 252, 72, 40, 3, 101, 101,
  16, 200, 252, 72, 80, 3, 100, 100, 72, 220, 236, 72, 3, 101, 101, 8,
  88, 252, 104, 64, 2, 87, 103, 128, 144, 176, 208, 144, 56, 16, 2, 88,
  104, 32, 64, 248, 72, 40, 8, 8, 8, 2, 88, 104, 32, 16, 248, 144,
  160, 128, 128, 128, 2, 88, 104, 8, 8, 8, 40, 72, 248, 64, 32, 2,
  87, 103, 128, 128, 160, 144, 248, 16, 32, 3, 84, 100, 240, 16, 56, 16,
  3, 85, 101, 8, 8, 72, 248, 64, 3, 85, 101, 48, 72, 72, 232, 72,
  3, 85, 101, 96, 144, 144, 184, 16, 2, 88, 104, 248, 128, 224, 192, 160,
  32, 16, 16, 2, 89, 105, 160, 192, 248, 192, 168, 24, 248, 24, 40, 2,
  86, 102, 56, 48, 168, 136, 136, 112, 2, 86, 102, 224, 96, 168, 136, 136,
  112, 5, 83, 99, 32, 64, 248, 3, 83, 99, 248, 64, 32, 34, 56, 104,
  128, 192, 160, 128, 128, 128, 128, 128, 2, 56, 104, 32, 96, 160, 32, 32,
  32, 32, 32, 5, 83, 99, 32, 16, 248, 3, 83, 99, 248, 16, 32, 34,
  56, 104, 128, 128, 128, 128, 128, 160, 192, 128, 2, 56, 104, 32, 32, 32,
  32, 32, 160, 96, 32, 2, 89, 105, 32, 16, 248, 16, 32, 64, 248, 64,
  32, 2, 88, 104, 80, 240, 80, 80, 80, 80, 120, 80, 2, 89, 105, 32,
  64, 248, 64, 32, 16, 248, 16, 32, 2, 89, 105, 32, 64, 248, 64, 32,
  64, 248, 64, 32, 2, 88, 104, 80, 248, 80, 80, 80, 80, 80, 80, 2,
  89, 105, 32, 16, 248, 16, 32, 16, 248, 16, 32, 2, 88, 104, 80, 80,
  80, 80, 80, 80, 248, 80, 2, 87, 103, 32, 64, 248, 0, 248, 16, 32,
  2, 87, 103, 32, 16, 248, 0, 248, 64, 32, 2, 103, 103, 20, 40, 124,
  144, 124, 32, 80, 2, 103, 103, 8, 88, 252, 164, 252, 104, 64, 2, 103,
  103, 160, 80, 248, 36, 248, 16, 40, 3, 85, 101, 32, 120, 128, 120, 32,
  2, 87, 103, 32, 80, 216, 80, 80, 80, 80, 3, 85, 101, 32, 240, 8,
  240, 32, 2, 87, 103, 80, 80, 80, 80, 216, 80, 32, 3, 101, 101, 72,
  252, 132, 252, 72, 2, 88, 104, 32, 80, 216, 80, 80, 216, 80, 32, 2,
  102, 102, 248, 160, 208, 168, 148, 8, 2, 102, 102, 124, 20, 44, 84, 164,
  64, 2, 102, 102, 64, 164, 84, 44, 20, 124, 2, 102, 102, 8, 148, 168,
  208, 160, 248, 2, 103, 103, 16, 60, 64, 252, 64, 60, 16, 2, 103, 103,
  32, 240, 8, 252, 8, 240, 32, 3, 100, 100, 64, 232, 212, 64, 3, 100,
  100, 8, 92, 172, 8, 2, 88, 104, 32, 112, 168, 32, 112, 32, 112, 32,
  2, 88, 104, 32, 112, 32, 112, 32, 168, 112, 32, 3, 101, 101, 32, 64,
  212, 64, 32, 2, 88, 104, 32, 112, 136, 32, 0, 32, 0, 32, 3, 101,
  101, 16, 8, 172, 8, 16, 2, 88, 104, 32, 0, 32, 0, 32, 136, 112,
  32, 3, 85, 101, 160, 192, 248, 192, 160, 3, 85, 101, 40, 24, 248, 24,
  40, 3, 85, 101, 32, 120, 136, 120, 32, 2, 88, 104, 32, 80, 216, 80,
  80, 80, 80, 112, 3, 85, 101, 32, 240, 136, 240, 32, 2, 88, 104, 112,
  80, 80, 80, 80, 216, 80, 32, 2, 89, 105, 32, 80, 216, 80, 112, 0,
  112, 80, 112, 2, 89, 105, 32, 80, 216, 80, 80, 80, 216, 136, 248, 2,
  89, 105, 32, 80, 248, 136, 80, 80, 216, 136, 248, 2, 89, 105, 32, 112,
  248, 112, 112, 112, 248, 168, 248, 2, 89, 105, 32, 80, 216, 80, 216, 80,
  80, 80, 112, 2, 89, 105, 32, 80, 216, 80, 216, 80, 216, 136, 248, 3,
  85, 101, 160, 240, 136, 240, 160, 2, 88, 104, 248, 128, 176, 160, 144, 16,
  8, 8, 2, 88, 104, 128, 128, 64, 72, 40, 104, 8, 248, 2, 88, 104,
  32, 80, 216, 80, 80, 216, 80, 32, 3, 101, 101, 16, 104, 252, 104, 16,
  2, 88, 104, 80, 120, 80, 80, 80, 80, 240, 80, 2, 89, 105, 16, 248,
  16, 16, 248, 16, 16, 248, 16, 3, 101, 101, 40, 72, 252, 72, 40, 3,
  101, 101, 80, 72, 252, 72, 80, 3, 101, 101, 48, 120, 252, 120, 48, 3,
  101, 101, 56, 88, 252, 88, 56, 3, 101, 101, 112, 104, 252, 104, 112, 3,
  101, 101, 48, 120, 252, 120, 48, 3, 85, 101, 32, 96, 184, 96, 32, 3,
  85, 101, 32, 48, 232, 48, 32, 3, 101, 101, 48, 120, 180, 120, 48, 6,
  102, 102, 252, 252, 252, 252, 252, 252, 0, 98, 98, 252, 252, 0, 99, 99,
  252, 252, 252, 0, 101, 101, 252, 252, 252, 252, 252, 0, 102, 102, 252, 252,
  252, 252, 252, 252, 0, 104, 104, 252, 252, 252, 252, 252, 252, 252, 252, 0,
  105, 105, 252, 252, 252, 252, 252, 252, 252, 252, 252, 0, 107, 107, 252, 252,
  252, 252, 252, 252, 252, 252, 252, 252, 252, 0, 108, 108, 252, 252, 252, 252,
  252, 252, 252, 252, 252, 252, 252, 252, 0, 92, 108, 248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 0, 76, 108, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 0, 76, 108, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 0, 60, 108, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 0, 44, 108, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 0, 44, 108, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 0, 28, 108, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 48, 60, 108, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  1, 107, 107, 168, 0, 84, 0, 168, 0, 84, 0, 168, 0, 84, 0, 108,
  108, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 0, 108, 108,
  84, 252, 168, 252, 84, 252, 168, 252, 84, 252, 168, 252, 10, 98, 98, 252,
  252, 80, 28, 108, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  0, 54, 102, 224, 224, 224, 224, 224, 224, 48, 54, 102, 224, 224, 224, 224,
  224, 224, 6, 54, 102, 224, 224, 224, 224, 224, 224, 0, 108, 108, 224, 224,
  224, 224, 224, 224, 252, 252, 252, 252, 252, 252, 0, 108, 108, 224, 224, 224,
  224, 224, 224, 28, 28, 28, 28, 28, 28, 0, 108, 108, 252, 252, 252, 252,
  252, 252, 224, 224, 224, 224, 224, 224, 0, 108, 108, 252, 252, 252, 252, 252,
  252, 28, 28, 28, 28, 28, 28, 54, 54, 102, 224, 224, 224, 224, 224, 224,
  0, 108, 108, 28, 28, 28, 28, 28, 28, 224, 224, 224, 224, 224, 224, 0,
  108, 108, 28, 28, 28, 28, 28, 28, 252, 252, 252, 252, 252, 252, 2, 85,
  101, 248, 248, 248, 248, 248, 2, 85, 101, 248, 136, 136, 136, 248, 2, 85,
  101, 112, 136, 136, 136, 112, 2, 85, 101, 248, 136, 168, 136, 248, 2, 85,
  101, 248, 136, 248, 136, 248, 2, 85, 101, 248, 168, 168, 168, 248, 2, 85,
  101, 248, 168, 248, 168, 248, 2, 85, 101, 248, 200, 168, 152, 248, 2, 85,
  101, 248, 152, 168, 200, 248, 2, 85, 101, 248, 216, 168, 216, 248, 20, 51,
  99, 224, 224, 224, 20, 51, 99, 224, 160, 224, 3, 101, 101, 252, 252, 252,
  252, 252, 3, 101, 101, 252, 132, 132, 132, 252, 17, 74, 106, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 17, 74, 106, 240, 144, 144, 144, 144, 144,
  144, 144, 144, 240, 4, 99, 99, 60, 120, 240, 4, 99, 99, 60, 72, 240,
  2, 87, 103, 32, 32, 112, 112, 248, 248, 248, 2, 87, 103, 32, 32, 80,
  80, 136, 136, 248, 3, 85, 101, 32, 32, 112, 112, 248, 3, 85, 101, 32,
  32, 80, 80, 248, 18, 71, 103, 128, 192, 224, 240, 224, 192, 128, 18, 71,
  103, 128, 192, 160, 144, 160, 192, 128, 19, 53, 101, 128, 192, 224, 192, 128,
  19, 53, 101, 128, 192, 160, 192, 128, 3, 101, 101, 192, 240, 252, 240, 192,
  3, 101, 101, 192, 176, 140, 176, 192, 2, 87, 103, 248, 248, 248, 112, 112,
  32, 32, 2, 87, 103, 248, 136, 136, 80, 80, 32, 32, 2, 85, 101, 248,
  112, 112, 32, 32, 2, 85, 101, 248, 80, 80, 32, 32, 18, 71, 103, 16,
  48, 112, 240, 112, 48, 16, 18, 71, 103, 16, 48, 80, 144, 80, 48, 16,
  19, 53, 101, 32, 96, 224, 96, 32, 19, 53, 101, 32, 96, 160, 96, 32,
  3, 101, 101, 12, 60, 252, 60, 12, 3, 101, 101, 12, 52, 196, 52, 12,
  3, 85, 101, 32, 112, 248, 112, 32, 3, 85, 101, 32, 80, 136, 80, 32,
  3, 85, 101, 32, 80, 168, 80, 32, 2, 102, 102, 48, 72, 180, 180, 72,
  48, 2, 87, 103, 32, 80, 80, 136, 80, 80, 32, 2, 102, 102, 48, 72,
  132, 132, 72, 48, 2, 102, 102, 32, 8, 128, 4, 64, 16, 2, 85, 101,
  112, 168, 168, 168, 112, 2, 87, 103, 112, 136, 168, 216, 168, 136, 112, 2,
  102, 102, 48, 120, 252, 252, 120, 48, 2, 102, 102, 48, 104, 228, 228, 104,
  48, 2, 102, 102, 48, 88, 156, 156, 88, 48, 2, 102, 102, 48, 72, 132,
  252, 120, 48, 2, 102, 102, 48, 120, 252, 132, 72, 48, 2, 102, 102, 48,
  88, 156, 132, 72, 48, 2, 102, 102, 48, 104, 228, 132, 72, 48, 18, 89,
  105, 8, 56, 120, 120, 248, 120, 120, 56, 8, 2, 89, 105, 128, 224, 240,
  240, 248, 240, 240, 224, 128, 0, 108, 108, 252, 252, 252, 252, 204, 132, 132,
  204, 252, 252, 252, 252, 0, 108, 108, 252, 252, 252, 204, 180, 120, 120, 180,
  204, 252, 252, 252, 6, 102, 102, 252, 252, 252, 204, 180, 120, 0, 102, 102,
  120, 180, 204, 252, 252, 252, 5, 51, 99, 32, 64, 128, 53, 51, 99, 128,
  64, 32, 50, 51, 99, 32, 64, 128, 2, 51, 99, 128, 64, 32, 5, 99,
  99, 48, 72, 132, 2, 99, 99, 132, 72, 48, 2, 85, 101, 8, 24, 56,
  120, 248, 2, 85, 101, 128, 192, 224, 240, 248, 2, 85, 101, 248, 240, 224,
  192, 128, 2, 85, 101, 248, 120, 56, 24, 8, 2, 85, 101, 112, 136, 136,
  136, 112, 2, 85, 101, 248, 232, 232, 232, 248, 2, 85, 101, 248, 184, 184,
  184, 248, 2, 85, 101, 248, 248, 232, 200, 248, 2, 85, 101, 248, 152, 184,
  248, 248, 2, 85, 101, 248, 168, 168, 168, 248, 2, 87, 103, 32, 32, 80,
  112, 168, 136, 248, 2, 87, 103, 32, 32, 112, 112, 232, 232, 248, 2, 87,
  103, 32, 32, 112, 112, 184, 184, 248, 2, 103, 103, 48, 72, 132, 132, 132,
  72, 48, 2, 85, 101, 248, 168, 232, 136, 248, 2, 85, 101, 248, 136, 232,
  168, 248, 2, 85, 101, 248, 136, 184, 168, 248, 2, 85, 101, 248, 168, 184,
  136, 248, 2, 85, 101, 112, 168, 232, 136, 112, 2, 85, 101, 112, 136, 232,
  168, 112, 2, 85, 101, 112, 136, 184, 168, 112, 2, 85, 101, 112, 168, 184,
  136, 112, 3, 85, 101, 248, 144, 160, 192, 128, 3, 85, 101, 248, 72, 40,
  24, 8, 3, 85, 101, 128, 192, 160, 144, 248, 20, 68, 100, 240, 144, 144,
  240, 19, 68, 100, 240, 240, 240, 240, 20, 68, 100, 240, 144, 144, 240, 20,
  68, 100, 240, 240, 240, 240, 3, 85, 101, 8, 24, 40, 72, 248
};

/*
  Fontname: -Misc-Fixed-Medium-R-SemiCondensed--12-110-75-75-C-60-ISO10646-1
  Copyright: Public domain terminal emulator font.  Share and enjoy.
  Capital A Height: 7, '1' Height: 3
  Calculated Max Values w= 6 h=10 x= 1 y= 2 dx= 6 dy= 0 ascent= 9 len=10
  Font Bounding box     w= 6 h=12 x= 0 y=-2
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 7 descent= 0
  X Font      ascent = 7 descent= 0
  Max Font    ascent = 9 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_6x12_75r[427] U8G_FONT_SECTION("u8g_font_6x12_75r") = {
  1, 6, 12, 0, 254, 7, 1, 41, 0, 0, 32, 79, 0, 9, 255, 7,
  0, 2, 85, 101, 248, 248, 248, 248, 248, 2, 85, 101, 248, 136, 136, 136,
  248, 2, 85, 101, 112, 136, 136, 136, 112, 2, 85, 101, 248, 136, 168, 136,
  248, 2, 85, 101, 248, 136, 248, 136, 248, 2, 85, 101, 248, 168, 168, 168,
  248, 2, 85, 101, 248, 168, 248, 168, 248, 2, 85, 101, 248, 200, 168, 152,
  248, 2, 85, 101, 248, 152, 168, 200, 248, 2, 85, 101, 248, 216, 168, 216,
  248, 20, 51, 99, 224, 224, 224, 20, 51, 99, 224, 160, 224, 3, 101, 101,
  252, 252, 252, 252, 252, 3, 101, 101, 252, 132, 132, 132, 252, 17, 74, 106,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 17, 74, 106, 240, 144, 144,
  144, 144, 144, 144, 144, 144, 240, 4, 99, 99, 60, 120, 240, 4, 99, 99,
  60, 72, 240, 2, 87, 103, 32, 32, 112, 112, 248, 248, 248, 2, 87, 103,
  32, 32, 80, 80, 136, 136, 248, 3, 85, 101, 32, 32, 112, 112, 248, 3,
  85, 101, 32, 32, 80, 80, 248, 18, 71, 103, 128, 192, 224, 240, 224, 192,
  128, 18, 71, 103, 128, 192, 160, 144, 160, 192, 128, 19, 53, 101, 128, 192,
  224, 192, 128, 19, 53, 101, 128, 192, 160, 192, 128, 3, 101, 101, 192, 240,
  252, 240, 192, 3, 101, 101, 192, 176, 140, 176, 192, 2, 87, 103, 248, 248,
  248, 112, 112, 32, 32, 2, 87, 103, 248, 136, 136, 80, 80, 32, 32, 2,
  85, 101, 248, 112, 112, 32, 32, 2, 85, 101, 248, 80, 80, 32, 32, 18,
  71, 103, 16, 48, 112, 240, 112, 48, 16, 18, 71, 103, 16, 48, 80, 144,
  80, 48, 16, 19, 53, 101, 32, 96, 224, 96, 32, 19, 53, 101, 32, 96,
  160, 96, 32, 3, 101, 101, 12, 60, 252, 60, 12, 3, 101, 101, 12, 52,
  196, 52, 12, 3, 85, 101, 32, 112, 248, 112, 32, 3, 85, 101, 32, 80,
  136, 80, 32, 3, 85, 101, 32, 80, 168, 80, 32, 2, 102, 102, 48, 72,
  180, 180, 72, 48, 2, 87, 103, 32, 80, 80, 136, 80, 80, 32, 2, 102,
  102, 48, 72, 132, 132, 72, 48, 2, 102, 102, 32, 8, 128, 4, 64, 16,
  2, 85, 101, 112, 168, 168, 168, 112, 2, 87, 103, 112, 136, 168, 216, 168,
  136, 112, 2, 102, 102, 48, 120, 252, 252, 120, 48
};

/*
  Fontname: -Misc-Fixed-Medium-R-SemiCondensed--12-110-75-75-C-60-ISO10646-1
  Copyright: Public domain terminal emulator font.  Share and enjoy.
  Capital A Height: 6, '1' Height: 6
  Calculated Max Values w= 6 h=12 x= 2 y= 4 dx= 6 dy= 0 ascent=10 len=12
  Font Bounding box     w= 6 h=12 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 6 descent= 0
  X Font      ascent = 9 descent= 0
  Max Font    ascent =10 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x12_78_79[2316] U8G_FONT_SECTION("u8g_font_6x12_78_79") = {
  1, 6, 12, 0, 254, 6, 2, 80, 3, 53, 0, 255, 0, 10, 254, 9,
  0, 2, 87, 103, 168, 0, 136, 0, 136, 0, 168, 3, 101, 101, 144, 252,
  32, 64, 96, 3, 101, 101, 196, 200, 48, 200, 196, 3, 101, 101, 96, 64,
  32, 252, 144, 2, 103, 103, 204, 148, 232, 48, 232, 148, 204, 255, 1, 105,
  105, 120, 132, 180, 180, 164, 180, 180, 132, 120, 1, 105, 105, 120, 132, 180,
  132, 180, 132, 204, 132, 120, 3, 101, 101, 32, 176, 252, 176, 32, 2, 101,
  101, 252, 204, 180, 132, 252, 255, 255, 18, 72, 104, 144, 144, 80, 112, 240,
  240, 240, 112, 3, 102, 102, 4, 56, 124, 124, 64, 128, 2, 102, 102, 64,
  224, 80, 40, 20, 12, 3, 99, 99, 248, 140, 248, 2, 102, 102, 12, 20,
  40, 80, 224, 64, 3, 100, 100, 248, 132, 132, 248, 4, 99, 99, 248, 244,
  248, 2, 87, 103, 8, 8, 16, 16, 160, 224, 64, 2, 103, 103, 12, 12,
  28, 216, 248, 112, 48, 2, 85, 101, 136, 80, 32, 80, 136, 3, 85, 101,
  216, 248, 32, 248, 216, 2, 86, 102, 136, 80, 32, 80, 136, 128, 1, 103,
  103, 204, 204, 120, 112, 252, 204, 192, 1, 103, 103, 120, 204, 164, 244, 164,
  204, 120, 2, 102, 102, 48, 48, 252, 252, 48, 48, 3, 85, 101, 32, 32,
  216, 32, 32, 2, 102, 102, 48, 48, 204, 204, 48, 48, 2, 87, 103, 32,
  32, 248, 32, 32, 32, 32, 1, 90, 106, 112, 80, 216, 136, 216, 80, 80,
  80, 80, 112, 2, 105, 105, 120, 220, 188, 220, 88, 88, 88, 120, 120, 2,
  87, 103, 112, 32, 168, 248, 168, 32, 112, 2, 87, 103, 32, 248, 80, 80,
  80, 248, 32, 3, 85, 101, 32, 32, 248, 32, 32, 3, 102, 102, 48, 48,
  252, 252, 48, 48, 2, 104, 104, 48, 120, 48, 252, 252, 48, 120, 48, 2,
  87, 103, 32, 112, 168, 248, 168, 112, 32, 3, 85, 101, 32, 112, 248, 112,
  32, 3, 85, 101, 32, 112, 216, 112, 32, 255, 3, 85, 101, 32, 216, 80,
  32, 80, 2, 87, 103, 112, 216, 136, 216, 168, 248, 112, 3, 86, 102, 32,
  32, 248, 80, 112, 136, 3, 86, 102, 32, 32, 216, 32, 80, 136, 3, 86,
  102, 32, 32, 248, 112, 112, 136, 3, 86, 102, 32, 32, 248, 112, 112, 136,
  3, 86, 102, 32, 32, 232, 48, 80, 136, 2, 102, 102, 48, 88, 140, 88,
  172, 88, 2, 86, 102, 32, 168, 112, 112, 168, 32, 2, 87, 103, 32, 168,
  112, 80, 112, 168, 32, 2, 87, 103, 32, 168, 112, 248, 112, 168, 32, 2,
  87, 103, 32, 168, 112, 248, 112, 168, 32, 2, 87, 103, 32, 168, 112, 248,
  112, 168, 32, 2, 86, 102, 32, 168, 112, 112, 168, 32, 1, 88, 104, 80,
  32, 168, 112, 112, 168, 32, 80, 1, 88, 104, 80, 32, 168, 112, 112, 168,
  32, 80, 2, 103, 103, 80, 248, 124, 248, 124, 248, 80, 2, 103, 103, 80,
  168, 116, 248, 116, 168, 80, 2, 86, 102, 32, 168, 112, 112, 168, 32, 2,
  87, 103, 32, 168, 112, 80, 112, 168, 32, 2, 86, 102, 32, 168, 112, 112,
  168, 32, 2, 103, 103, 168, 216, 80, 168, 116, 168, 32, 3, 87, 103, 32,
  112, 248, 216, 112, 248, 216, 3, 87, 103, 32, 112, 216, 168, 80, 248, 216,
  3, 86, 102, 32, 112, 216, 112, 248, 32, 2, 87, 103, 112, 248, 168, 216,
  168, 248, 112, 2, 86, 102, 32, 168, 112, 112, 168, 32, 2, 86, 102, 32,
  168, 112, 112, 168, 32, 2, 86, 102, 32, 168, 112, 112, 168, 32, 2, 86,
  102, 32, 168, 112, 112, 168, 32, 2, 87, 103, 32, 168, 112, 248, 112, 168,
  32, 2, 87, 103, 32, 168, 112, 248, 112, 168, 32, 2, 87, 103, 32, 168,
  112, 248, 112, 168, 32, 2, 87, 103, 32, 168, 112, 248, 112, 168, 32, 2,
  87, 103, 32, 168, 112, 248, 112, 168, 32, 255, 3, 101, 101, 120, 140, 140,
  140, 120, 255, 2, 102, 102, 248, 140, 140, 140, 252, 124, 2, 102, 102, 124,
  252, 140, 140, 140, 248, 2, 102, 102, 248, 140, 140, 140, 252, 124, 2, 102,
  102, 124, 252, 140, 140, 140, 248, 255, 255, 255, 2, 103, 103, 16, 56, 84,
  236, 84, 56, 16, 255, 34, 23, 103, 128, 128, 128, 128, 128, 128, 128, 18,
  39, 103, 192, 192, 192, 192, 192, 192, 192, 18, 71, 103, 240, 240, 240, 240,
  240, 240, 240, 22, 69, 101, 96, 128, 224, 240, 96, 22, 69, 101, 96, 240,
  112, 16, 96, 6, 101, 101, 72, 144, 216, 252, 72, 6, 101, 101, 72, 252,
  108, 36, 72, 255, 255, 1, 106, 106, 8, 124, 200, 200, 200, 120, 8, 200,
  136, 112, 2, 89, 105, 112, 248, 248, 112, 32, 0, 32, 112, 32, 2, 88,
  104, 216, 248, 112, 32, 0, 32, 112, 32, 2, 85, 101, 216, 248, 248, 112,
  32, 2, 87, 103, 96, 240, 240, 120, 240, 240, 96, 2, 104, 104, 100, 184,
  32, 216, 248, 240, 228, 120, 2, 102, 102, 128, 88, 120, 220, 152, 64, 18,
  56, 104, 32, 64, 192, 192, 192, 192, 64, 32, 18, 56, 104, 128, 64, 96,
  96, 96, 96, 64, 128, 18, 40, 104, 64, 192, 192, 192, 192, 192, 192, 64,
  18, 40, 104, 128, 192, 192, 192, 192, 192, 192, 128, 17, 73, 105, 48, 48,
  96, 96, 192, 96, 96, 48, 48, 17, 73, 105, 192, 192, 96, 96, 48, 96,
  96, 192, 192, 2, 87, 103, 24, 48, 96, 192, 96, 48, 24, 2, 87, 103,
  192, 96, 48, 24, 48, 96, 192, 1, 89, 105, 56, 56, 112, 112, 224, 112,
  112, 56, 56, 1, 89, 105, 224, 224, 112, 112, 56, 112, 112, 224, 224, 17,
  57, 105, 32, 64, 128, 128, 128, 128, 128, 64, 32, 17, 57, 105, 128, 64,
  32, 32, 32, 32, 32, 64, 128, 17, 73, 105, 48, 96, 96, 96, 192, 96,
  96, 96, 48, 17, 73, 105, 192, 96, 96, 96, 48, 96, 96, 96, 192, 2,
  89, 105, 112, 248, 216, 152, 216, 216, 136, 248, 112, 2, 89, 105, 112, 248,
  216, 168, 232, 216, 136, 248, 112, 2, 89, 105, 112, 248, 152, 232, 216, 232,
  152, 248, 112, 2, 89, 105, 112, 248, 184, 184, 152, 136, 216, 248, 112, 2,
  89, 105, 112, 248, 136, 184, 152, 232, 152, 248, 112, 2, 89, 105, 112, 248,
  200, 184, 152, 168, 216, 248, 112, 2, 89, 105, 112, 248, 136, 232, 216, 216,
  216, 248, 112, 2, 89, 105, 112, 248, 216, 168, 216, 168, 216, 248, 112, 2,
  89, 105, 112, 248, 216, 168, 200, 232, 152, 248, 112, 2, 105, 105, 120, 252,
  172, 148, 148, 148, 172, 252, 120, 2, 89, 105, 112, 136, 168, 232, 168, 168,
  248, 136, 112, 2, 89, 105, 112, 136, 168, 216, 152, 168, 248, 136, 112, 2,
  89, 105, 112, 136, 232, 152, 168, 152, 232, 136, 112, 2, 89, 105, 112, 136,
  200, 200, 232, 248, 168, 136, 112, 2, 89, 105, 112, 136, 248, 200, 232, 152,
  232, 136, 112, 2, 89, 105, 112, 136, 184, 200, 232, 216, 168, 136, 112, 2,
  89, 105, 112, 136, 248, 152, 168, 168, 168, 136, 112, 2, 89, 105, 112, 136,
  168, 216, 168, 216, 168, 136, 112, 2, 89, 105, 112, 136, 168, 216, 184, 152,
  232, 136, 112, 2, 105, 105, 120, 132, 212, 236, 236, 236, 212, 132, 120, 2,
  89, 105, 112, 248, 216, 152, 216, 216, 216, 248, 112, 2, 89, 105, 112, 248,
  216, 168, 232, 216, 136, 248, 112, 2, 89, 105, 112, 248, 152, 232, 216, 232,
  152, 248, 112, 2, 89, 105, 112, 248, 184, 184, 152, 136, 216, 248, 112, 2,
  89, 105, 112, 248, 136, 184, 152, 232, 152, 248, 112, 2, 89, 105, 112, 248,
  200, 184, 152, 168, 216, 248, 112, 2, 89, 105, 112, 248, 136, 232, 216, 216,
  216, 248, 112, 2, 89, 105, 112, 248, 216, 168, 216, 168, 216, 248, 112, 2,
  89, 105, 112, 248, 216, 168, 200, 232, 152, 248, 112, 2, 105, 105, 120, 252,
  172, 148, 148, 148, 172, 252, 120, 3, 101, 101, 48, 24, 252, 24, 48, 255,
  255, 255, 2, 85, 101, 128, 64, 40, 24, 56, 3, 85, 101, 32, 48, 248,
  48, 32, 2, 85, 101, 56, 24, 40, 64, 128, 3, 101, 101, 64, 48, 252,
  48, 64, 2, 102, 102, 48, 56, 252, 252, 56, 48, 4, 99, 99, 8, 252,
  8, 2, 102, 102, 16, 24, 252, 252, 24, 16, 3, 99, 99, 8, 188, 8,
  2, 102, 102, 16, 24, 188, 188, 24, 16, 3, 101, 101, 16, 248, 252, 248,
  16, 2, 103, 103, 192, 176, 72, 60, 120, 240, 192, 2, 103, 103, 192, 240,
  120, 60, 72, 176, 192, 3, 101, 101, 224, 120, 60, 120, 224, 3, 102, 102,
  128, 144, 248, 252, 120, 16, 2, 102, 102, 16, 120, 252, 248, 144, 128, 2,
  103, 103, 32, 240, 248, 252, 248, 240, 32, 3, 101, 101, 32, 240, 252, 240,
  32, 3, 101, 101, 16, 232, 132, 232, 16, 3, 101, 101, 16, 232, 132, 232,
  16, 3, 101, 101, 16, 232, 132, 232, 16, 3, 101, 101, 16, 232, 132, 232,
  16, 2, 102, 102, 16, 232, 132, 132, 232, 16, 2, 102, 102, 16, 232, 132,
  132, 232, 16, 3, 101, 101, 16, 232, 132, 232, 16, 255, 3, 101, 101, 16,
  232, 132, 232, 16, 2, 103, 103, 120, 220, 12, 4, 12, 220, 120, 3, 99,
  99, 232, 124, 232, 2, 102, 102, 64, 224, 96, 16, 12, 12, 3, 99, 99,
  232, 124, 232, 2, 102, 102, 12, 12, 16, 96, 224, 64, 2, 102, 102, 96,
  224, 224, 20, 12, 28, 2, 101, 101, 192, 232, 124, 232, 192, 2, 102, 102,
  28, 12, 20, 224, 224, 96, 2, 101, 101, 16, 200, 252, 200, 16, 2, 101,
  101, 16, 200, 252, 200, 16, 3, 99, 99, 232, 124, 232, 3, 100, 100, 232,
  252, 252, 232, 2, 101, 101, 80, 232, 4, 232, 80, 255, 2, 85, 101, 136,
  144, 160, 192, 248, 2, 86, 102, 32, 32, 80, 112, 168, 248, 2, 86, 102,
  32, 32, 32, 32, 32, 248, 2, 87, 103, 120, 128, 144, 168, 144, 128, 120,
  2, 87, 103, 240, 8, 72, 168, 72, 8, 240, 18, 73, 105, 64, 160, 160,
  32, 32, 64, 64, 64, 48, 18, 73, 105, 32, 80, 80, 64, 64, 32, 32,
  32, 192, 2, 87, 103, 136, 168, 136, 80, 80, 32, 32, 2, 104, 104, 128,
  156, 160, 160, 160, 92, 64, 64, 2, 104, 104, 4, 228, 20, 20, 20, 232,
  8, 8, 18, 55, 103, 64, 64, 64, 224, 64, 64, 64, 255, 2, 103, 103,
  252, 64, 32, 32, 32, 32, 64, 255, 255, 255, 3, 85, 101, 32, 80, 168,
  80, 32, 2, 87, 103, 32, 32, 80, 80, 136, 168, 136, 2, 87, 103, 168,
  168, 168, 168, 168, 168, 112, 3, 85, 101, 8, 8, 40, 8, 248, 3, 85,
  101, 248, 128, 160, 128, 128, 3, 101, 101, 196, 108, 84, 108, 196, 3, 101,
  101, 140, 216, 168, 216, 140, 2, 101, 101, 204, 120, 72, 120, 204, 2, 87,
  103, 32, 32, 32, 32, 32, 32, 248, 2, 87, 103, 248, 32, 32, 32, 32,
  32, 32, 3, 85, 101, 80, 216, 80, 216, 80, 3, 85, 101, 80, 80, 216,
  80, 80, 4, 99, 99, 64, 188, 64, 4, 99, 99, 128, 252, 128, 4, 99,
  99, 4, 252, 4, 18, 55, 103, 64, 160, 64, 64, 64, 64, 224, 3, 85,
  101, 32, 80, 248, 80, 32, 3, 85, 101, 32, 80, 136, 80, 32, 3, 101,
  101, 16, 40, 196, 40, 16, 3, 101, 101, 32, 80, 140, 80, 32, 3, 101,
  101, 124, 68, 196, 68, 124, 3, 101, 101, 248, 136, 140, 136, 248, 1, 90,
  106, 248, 160, 160, 160, 160, 160, 160, 160, 160, 248, 1, 90, 106, 248, 40,
  40, 40, 40, 40, 40, 40, 40, 248, 17, 57, 105, 32, 32, 64, 64, 128,
  64, 64, 32, 32, 17, 57, 105, 128, 128, 64, 64, 32, 64, 64, 128, 128,
  0, 107, 107, 20, 40, 40, 80, 80, 160, 80, 80, 40, 40, 20, 0, 107,
  107, 160, 80, 80, 40, 40, 20, 40, 40, 80, 80, 160, 16, 75, 107, 16,
  32, 96, 160, 160, 160, 160, 160, 96, 32, 16, 16, 76, 108, 128, 64, 96,
  80, 80, 80, 80, 80, 80, 96, 64, 128, 17, 41, 105, 128, 64, 64, 64,
  64, 64, 64, 64, 128, 17, 41, 105, 64, 128, 128, 128, 128, 128, 128, 128,
  64, 2, 87, 103, 32, 112, 168, 168, 168, 168, 168, 2, 87, 103, 168, 168,
  168, 168, 168, 112, 32, 2, 103, 103, 56, 68, 228, 68, 4, 68, 56, 2,
  103, 103, 112, 136, 156, 136, 128, 136, 112, 4, 99, 99, 104, 252, 104, 3,
  101, 101, 32, 64, 252, 64, 32, 3, 101, 101, 16, 8, 252, 8, 16, 4,
  99, 99, 72, 252, 72, 2, 103, 103, 16, 32, 124, 128, 124, 32, 16, 2,
  103, 103, 32, 16, 248, 4, 248, 16, 32, 3, 101, 101, 72, 252, 132, 252,
  72, 3, 101, 101, 36, 68, 252, 68, 36, 3, 101, 101, 144, 136, 252, 136,
  144, 2, 103, 103, 20, 36, 124, 132, 124, 36, 20, 2, 103, 103, 160, 144,
  248, 132, 248, 144, 160, 3, 100, 100, 8, 92, 172, 8
};

/*
  Fontname: -Misc-Fixed-Medium-R-SemiCondensed--12-110-75-75-C-60-ISO10646-1
  Copyright: Public domain terminal emulator font.  Share and enjoy.
  Capital A Height: 7, '1' Height: 7
  Calculated Max Values w= 6 h=10 x= 2 y=10 dx= 6 dy= 0 ascent=10 len=10
  Font Bounding box     w= 6 h=12 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 7 descent=-2
  X Font      ascent = 8 descent=-2
  Max Font    ascent =10 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x12[1933] U8G_FONT_SECTION("u8g_font_6x12") = {
  1, 6, 12, 0, 254, 7, 1, 53, 2, 107, 32, 255, 254, 10, 254, 8,
  254, 12, 0, 96, 34, 23, 103, 128, 128, 128, 128, 128, 0, 128, 23, 51,
  99, 160, 160, 160, 2, 86, 102, 80, 248, 80, 80, 248, 80, 1, 89, 105,
  32, 112, 168, 160, 112, 40, 168, 112, 32, 2, 87, 103, 200, 200, 16, 32,
  64, 152, 152, 2, 87, 103, 64, 160, 160, 64, 168, 144, 104, 39, 19, 99,
  128, 128, 128, 17, 57, 105, 32, 64, 64, 128, 128, 128, 64, 64, 32, 17,
  57, 105, 128, 64, 64, 32, 32, 32, 64, 64, 128, 2, 87, 103, 32, 168,
  112, 32, 112, 168, 32, 3, 85, 101, 32, 32, 248, 32, 32, 1, 51, 99,
  96, 96, 192, 5, 81, 97, 248, 18, 34, 98, 192, 192, 2, 87, 103, 8,
  16, 16, 32, 64, 64, 128, 18, 71, 103, 96, 144, 144, 144, 144, 144, 96,
  18, 55, 103, 64, 192, 64, 64, 64, 64, 224, 2, 87, 103, 112, 136, 8,
  16, 32, 64, 248, 2, 87, 103, 248, 8, 16, 48, 8, 136, 112, 2, 87,
  103, 16, 48, 80, 144, 248, 16, 16, 2, 87, 103, 248, 128, 240, 8, 8,
  136, 112, 2, 87, 103, 48, 64, 128, 240, 136, 136, 112, 2, 87, 103, 248,
  8, 16, 16, 32, 32, 32, 2, 87, 103, 112, 136, 136, 112, 136, 136, 112,
  2, 87, 103, 112, 136, 136, 120, 8, 16, 96, 18, 37, 101, 192, 192, 0,
  192, 192, 1, 54, 102, 96, 96, 0, 96, 96, 192, 19, 53, 101, 32, 64,
  128, 64, 32, 4, 83, 99, 248, 0, 248, 19, 53, 101, 128, 64, 32, 64,
  128, 2, 87, 103, 112, 136, 16, 32, 32, 0, 32, 2, 87, 103, 112, 136,
  184, 168, 184, 128, 112, 2, 87, 103, 112, 136, 136, 248, 136, 136, 136, 2,
  87, 103, 240, 72, 72, 112, 72, 72, 240, 2, 87, 103, 112, 136, 128, 128,
  128, 136, 112, 2, 87, 103, 240, 72, 72, 72, 72, 72, 240, 2, 87, 103,
  248, 128, 128, 240, 128, 128, 248, 2, 87, 103, 248, 128, 128, 240, 128, 128,
  128, 2, 87, 103, 112, 136, 128, 128, 152, 136, 112, 2, 87, 103, 136, 136,
  136, 248, 136, 136, 136, 18, 55, 103, 224, 64, 64, 64, 64, 64, 224, 2,
  87, 103, 56, 16, 16, 16, 16, 144, 96, 2, 87, 103, 136, 144, 160, 192,
  160, 144, 136, 2, 87, 103, 128, 128, 128, 128, 128, 128, 248, 2, 87, 103,
  136, 216, 168, 136, 136, 136, 136, 2, 87, 103, 136, 136, 200, 168, 152, 136,
  136, 2, 87, 103, 112, 136, 136, 136, 136, 136, 112, 2, 87, 103, 240, 136,
  136, 240, 128, 128, 128, 2, 87, 103, 112, 136, 136, 136, 168, 144, 104, 2,
  87, 103, 240, 136, 136, 240, 160, 144, 136, 2, 87, 103, 112, 136, 128, 112,
  8, 136, 112, 2, 87, 103, 248, 32, 32, 32, 32, 32, 32, 2, 87, 103,
  136, 136, 136, 136, 136, 136, 112, 2, 87, 103, 136, 136, 136, 136, 80, 80,
  32, 2, 87, 103, 136, 136, 136, 136, 168, 168, 80, 2, 87, 103, 136, 136,
  80, 32, 80, 136, 136, 2, 87, 103, 136, 136, 80, 32, 32, 32, 32, 2,
  87, 103, 248, 8, 16, 32, 64, 128, 248, 17, 57, 105, 224, 128, 128, 128,
  128, 128, 128, 128, 224, 2, 87, 103, 128, 64, 64, 32, 16, 16, 8, 17,
  57, 105, 224, 32, 32, 32, 32, 32, 32, 32, 224, 7, 83, 99, 32, 80,
  136, 0, 81, 97, 248, 23, 51, 99, 128, 64, 32, 2, 85, 101, 112, 8,
  120, 136, 120, 2, 87, 103, 128, 128, 240, 136, 136, 136, 240, 2, 85, 101,
  112, 136, 128, 136, 112, 2, 87, 103, 8, 8, 120, 136, 136, 136, 120, 2,
  85, 101, 112, 136, 240, 128, 112, 2, 87, 103, 48, 72, 64, 224, 64, 64,
  64, 0, 87, 103, 112, 136, 136, 136, 120, 8, 112, 2, 87, 103, 128, 128,
  240, 136, 136, 136, 136, 18, 55, 103, 64, 0, 192, 64, 64, 64, 224, 16,
  73, 105, 16, 0, 48, 16, 16, 16, 16, 144, 96, 2, 87, 103, 128, 128,
  136, 144, 224, 144, 136, 18, 55, 103, 192, 64, 64, 64, 64, 64, 224, 2,
  85, 101, 208, 168, 168, 168, 168, 2, 85, 101, 176, 200, 136, 136, 136, 2,
  85, 101, 112, 136, 136, 136, 112, 0, 87, 103, 240, 136, 136, 136, 240, 128,
  128, 0, 87, 103, 120, 136, 136, 136, 120, 8, 8, 2, 85, 101, 176, 200,
  128, 128, 128, 2, 85, 101, 120, 128, 112, 8, 240, 2, 87, 103, 32, 32,
  248, 32, 32, 32, 24, 2, 85, 101, 136, 136, 136, 152, 104, 2, 85, 101,
  136, 136, 136, 80, 32, 2, 85, 101, 136, 136, 168, 168, 80, 2, 85, 101,
  136, 80, 32, 80, 136, 0, 87, 103, 136, 136, 136, 80, 32, 64, 128, 2,
  85, 101, 248, 16, 32, 64, 248, 17, 57, 105, 32, 64, 64, 64, 128, 64,
  64, 64, 32, 33, 25, 105, 128, 128, 128, 128, 128, 128, 128, 128, 128, 17,
  57, 105, 128, 64, 64, 64, 32, 64, 64, 64, 128, 4, 83, 99, 72, 168,
  144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 12, 0, 96, 34, 23, 103, 128, 0, 128, 128, 128, 128, 128, 1,
  87, 103, 32, 112, 168, 160, 168, 112, 32, 2, 87, 103, 48, 72, 64, 224,
  64, 72, 176, 2, 85, 101, 168, 80, 136, 80, 168, 2, 87, 103, 136, 80,
  248, 32, 248, 32, 32, 34, 23, 103, 128, 128, 128, 0, 128, 128, 128, 18,
  72, 104, 112, 128, 96, 144, 144, 96, 16, 224, 25, 49, 97, 160, 2, 103,
  103, 120, 132, 148, 164, 148, 132, 120, 22, 53, 101, 96, 160, 96, 0, 224,
  2, 85, 101, 40, 80, 160, 80, 40, 3, 83, 99, 248, 8, 8, 21, 49,
  97, 224, 2, 103, 103, 120, 132, 180, 164, 164, 132, 120, 9, 81, 97, 248,
  23, 68, 100, 96, 144, 144, 96, 2, 87, 103, 32, 32, 248, 32, 32, 0,
  248, 23, 53, 101, 64, 160, 32, 64, 224, 23, 53, 101, 192, 32, 64, 32,
  192, 23, 51, 99, 32, 64, 128, 0, 87, 103, 136, 136, 136, 152, 232, 128,
  128, 2, 88, 104, 120, 232, 232, 232, 104, 40, 40, 40, 37, 34, 98, 192,
  192, 16, 50, 98, 32, 192, 23, 53, 101, 64, 192, 64, 64, 224, 23, 53,
  101, 64, 160, 64, 0, 224, 2, 85, 101, 160, 80, 40, 80, 160, 2, 90,
  106, 64, 192, 64, 64, 80, 48, 80, 120, 16, 16, 2, 90, 106, 64, 192,
  64, 64, 80, 40, 8, 16, 32, 56, 2, 90, 106, 192, 32, 64, 32, 208,
  48, 80, 120, 16, 16, 2, 87, 103, 32, 0, 32, 32, 64, 136, 112, 2,
  90, 106, 64, 32, 0, 112, 136, 136, 248, 136, 136, 136, 2, 90, 106, 16,
  32, 0, 112, 136, 136, 248, 136, 136, 136, 2, 90, 106, 32, 80, 0, 112,
  136, 136, 248, 136, 136, 136, 2, 90, 106, 104, 176, 0, 112, 136, 136, 248,
  136, 136, 136, 2, 89, 105, 80, 0, 112, 136, 136, 248, 136, 136, 136, 2,
  90, 106, 32, 80, 32, 112, 136, 136, 248, 136, 136, 136, 2, 87, 103, 120,
  160, 160, 240, 160, 160, 184, 0, 89, 105, 112, 136, 128, 128, 128, 136, 112,
  16, 96, 2, 90, 106, 64, 32, 0, 248, 128, 128, 240, 128, 128, 248, 2,
  90, 106, 16, 32, 0, 248, 128, 128, 240, 128, 128, 248, 2, 90, 106, 32,
  80, 0, 248, 128, 128, 240, 128, 128, 248, 2, 89, 105, 80, 0, 248, 128,
  128, 240, 128, 128, 248, 18, 58, 106, 128, 64, 0, 224, 64, 64, 64, 64,
  64, 224, 18, 58, 106, 32, 64, 0, 224, 64, 64, 64, 64, 64, 224, 18,
  58, 106, 64, 160, 0, 224, 64, 64, 64, 64, 64, 224, 18, 57, 105, 160,
  0, 224, 64, 64, 64, 64, 64, 224, 2, 87, 103, 112, 72, 72, 232, 72,
  72, 112, 2, 90, 106, 104, 176, 0, 136, 136, 200, 168, 152, 136, 136, 2,
  90, 106, 64, 32, 0, 112, 136, 136, 136, 136, 136, 112, 2, 90, 106, 16,
  32, 0, 112, 136, 136, 136, 136, 136, 112, 2, 90, 106, 32, 80, 0, 112,
  136, 136, 136, 136, 136, 112, 2, 90, 106, 104, 176, 0, 112, 136, 136, 136,
  136, 136, 112, 2, 89, 105, 80, 0, 112, 136, 136, 136, 136, 136, 112, 3,
  85, 101, 136, 80, 32, 80, 136, 1, 89, 105, 8, 112, 152, 168, 168, 168,
  200, 112, 128, 2, 90, 106, 64, 32, 0, 136, 136, 136, 136, 136, 136, 112,
  2, 90, 106, 16, 32, 0, 136, 136, 136, 136, 136, 136, 112, 2, 90, 106,
  32, 80, 0, 136, 136, 136, 136, 136, 136, 112, 2, 89, 105, 80, 0, 136,
  136, 136, 136, 136, 136, 112, 2, 90, 106, 16, 32, 0, 136, 136, 80, 32,
  32, 32, 32, 18, 71, 103, 128, 224, 144, 144, 144, 224, 128, 2, 87, 103,
  112, 136, 144, 160, 144, 136, 176, 2, 88, 104, 64, 32, 0, 112, 8, 120,
  136, 120, 2, 88, 104, 16, 32, 0, 112, 8, 120, 136, 120, 2, 88, 104,
  32, 80, 0, 112, 8, 120, 136, 120, 2, 88, 104, 104, 176, 0, 112, 8,
  120, 136, 120, 2, 87, 103, 80, 0, 112, 8, 120, 136, 120, 2, 88, 104,
  32, 80, 32, 112, 8, 120, 136, 120, 2, 85, 101, 112, 40, 112, 160, 120,
  0, 87, 103, 112, 136, 128, 136, 112, 16, 96, 2, 88, 104, 64, 32, 0,
  112, 136, 240, 128, 112, 2, 88, 104, 16, 32, 0, 112, 136, 240, 128, 112,
  2, 88, 104, 32, 80, 0, 112, 136, 240, 128, 112, 2, 87, 103, 80, 0,
  112, 136, 240, 128, 112, 18, 56, 104, 128, 64, 0, 192, 64, 64, 64, 224,
  18, 56, 104, 32, 64, 0, 192, 64, 64, 64, 224, 18, 56, 104, 64, 160,
  0, 192, 64, 64, 64, 224, 18, 55, 103, 160, 0, 192, 64, 64, 64, 224,
  2, 89, 105, 80, 32, 80, 8, 120, 136, 136, 136, 112, 2, 88, 104, 104,
  176, 0, 176, 200, 136, 136, 136, 2, 88, 104, 64, 32, 0, 112, 136, 136,
  136, 112, 2, 88, 104, 16, 32, 0, 112, 136, 136, 136, 112, 2, 88, 104,
  32, 80, 0, 112, 136, 136, 136, 112, 2, 88, 104, 104, 176, 0, 112, 136,
  136, 136, 112, 2, 87, 103, 80, 0, 112, 136, 136, 136, 112, 3, 85, 101,
  32, 0, 248, 0, 32, 2, 85, 101, 120, 152, 168, 200, 240, 2, 88, 104,
  64, 32, 0, 136, 136, 136, 136, 112, 2, 88, 104, 16, 32, 0, 136, 136,
  136, 136, 112, 2, 88, 104, 32, 80, 0, 136, 136, 136, 136, 112, 2, 87,
  103, 80, 0, 136, 136, 136, 136, 112, 0, 90, 106, 16, 32, 0, 136, 136,
  136, 80, 32, 64, 128, 0, 89, 105, 128, 128, 240, 136, 136, 136, 240, 128,
  128, 0, 89, 105, 80, 0, 136, 136, 136, 80, 32, 64, 128
};

/*
  Fontname: -Misc-Fixed-Medium-R-SemiCondensed--12-110-75-75-C-60-ISO10646-1
  Copyright: Public domain terminal emulator font.  Share and enjoy.
  Capital A Height: 7, '1' Height: 7
  Calculated Max Values w= 5 h= 9 x= 2 y=10 dx= 6 dy= 0 ascent=10 len= 9
  Font Bounding box     w= 6 h=12 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 7 descent=-2
  X Font      ascent = 8 descent=-2
  Max Font    ascent =10 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x12r[898] U8G_FONT_SECTION("u8g_font_6x12r") = {
  1, 6, 12, 0, 254, 7, 1, 53, 2, 107, 32, 127, 254, 10, 254, 8,
  254, 12, 0, 96, 34, 23, 103, 128, 128, 128, 128, 128, 0, 128, 23, 51,
  99, 160, 160, 160, 2, 86, 102, 80, 248, 80, 80, 248, 80, 1, 89, 105,
  32, 112, 168, 160, 112, 40, 168, 112, 32, 2, 87, 103, 200, 200, 16, 32,
  64, 152, 152, 2, 87, 103, 64, 160, 160, 64, 168, 144, 104, 39, 19, 99,
  128, 128, 128, 17, 57, 105, 32, 64, 64, 128, 128, 128, 64, 64, 32, 17,
  57, 105, 128, 64, 64, 32, 32, 32, 64, 64, 128, 2, 87, 103, 32, 168,
  112, 32, 112, 168, 32, 3, 85, 101, 32, 32, 248, 32, 32, 1, 51, 99,
  96, 96, 192, 5, 81, 97, 248, 18, 34, 98, 192, 192, 2, 87, 103, 8,
  16, 16, 32, 64, 64, 128, 18, 71, 103, 96, 144, 144, 144, 144, 144, 96,
  18, 55, 103, 64, 192, 64, 64, 64, 64, 224, 2, 87, 103, 112, 136, 8,
  16, 32, 64, 248, 2, 87, 103, 248, 8, 16, 48, 8, 136, 112, 2, 87,
  103, 16, 48, 80, 144, 248, 16, 16, 2, 87, 103, 248, 128, 240, 8, 8,
  136, 112, 2, 87, 103, 48, 64, 128, 240, 136, 136, 112, 2, 87, 103, 248,
  8, 16, 16, 32, 32, 32, 2, 87, 103, 112, 136, 136, 112, 136, 136, 112,
  2, 87, 103, 112, 136, 136, 120, 8, 16, 96, 18, 37, 101, 192, 192, 0,
  192, 192, 1, 54, 102, 96, 96, 0, 96, 96, 192, 19, 53, 101, 32, 64,
  128, 64, 32, 4, 83, 99, 248, 0, 248, 19, 53, 101, 128, 64, 32, 64,
  128, 2, 87, 103, 112, 136, 16, 32, 32, 0, 32, 2, 87, 103, 112, 136,
  184, 168, 184, 128, 112, 2, 87, 103, 112, 136, 136, 248, 136, 136, 136, 2,
  87, 103, 240, 72, 72, 112, 72, 72, 240, 2, 87, 103, 112, 136, 128, 128,
  128, 136, 112, 2, 87, 103, 240, 72, 72, 72, 72, 72, 240, 2, 87, 103,
  248, 128, 128, 240, 128, 128, 248, 2, 87, 103, 248, 128, 128, 240, 128, 128,
  128, 2, 87, 103, 112, 136, 128, 128, 152, 136, 112, 2, 87, 103, 136, 136,
  136, 248, 136, 136, 136, 18, 55, 103, 224, 64, 64, 64, 64, 64, 224, 2,
  87, 103, 56, 16, 16, 16, 16, 144, 96, 2, 87, 103, 136, 144, 160, 192,
  160, 144, 136, 2, 87, 103, 128, 128, 128, 128, 128, 128, 248, 2, 87, 103,
  136, 216, 168, 136, 136, 136, 136, 2, 87, 103, 136, 136, 200, 168, 152, 136,
  136, 2, 87, 103, 112, 136, 136, 136, 136, 136, 112, 2, 87, 103, 240, 136,
  136, 240, 128, 128, 128, 2, 87, 103, 112, 136, 136, 136, 168, 144, 104, 2,
  87, 103, 240, 136, 136, 240, 160, 144, 136, 2, 87, 103, 112, 136, 128, 112,
  8, 136, 112, 2, 87, 103, 248, 32, 32, 32, 32, 32, 32, 2, 87, 103,
  136, 136, 136, 136, 136, 136, 112, 2, 87, 103, 136, 136, 136, 136, 80, 80,
  32, 2, 87, 103, 136, 136, 136, 136, 168, 168, 80, 2, 87, 103, 136, 136,
  80, 32, 80, 136, 136, 2, 87, 103, 136, 136, 80, 32, 32, 32, 32, 2,
  87, 103, 248, 8, 16, 32, 64, 128, 248, 17, 57, 105, 224, 128, 128, 128,
  128, 128, 128, 128, 224, 2, 87, 103, 128, 64, 64, 32, 16, 16, 8, 17,
  57, 105, 224, 32, 32, 32, 32, 32, 32, 32, 224, 7, 83, 99, 32, 80,
  136, 0, 81, 97, 248, 23, 51, 99, 128, 64, 32, 2, 85, 101, 112, 8,
  120, 136, 120, 2, 87, 103, 128, 128, 240, 136, 136, 136, 240, 2, 85, 101,
  112, 136, 128, 136, 112, 2, 87, 103, 8, 8, 120, 136, 136, 136, 120, 2,
  85, 101, 112, 136, 240, 128, 112, 2, 87, 103, 48, 72, 64, 224, 64, 64,
  64, 0, 87, 103, 112, 136, 136, 136, 120, 8, 112, 2, 87, 103, 128, 128,
  240, 136, 136, 136, 136, 18, 55, 103, 64, 0, 192, 64, 64, 64, 224, 16,
  73, 105, 16, 0, 48, 16, 16, 16, 16, 144, 96, 2, 87, 103, 128, 128,
  136, 144, 224, 144, 136, 18, 55, 103, 192, 64, 64, 64, 64, 64, 224, 2,
  85, 101, 208, 168, 168, 168, 168, 2, 85, 101, 176, 200, 136, 136, 136, 2,
  85, 101, 112, 136, 136, 136, 112, 0, 87, 103, 240, 136, 136, 136, 240, 128,
  128, 0, 87, 103, 120, 136, 136, 136, 120, 8, 8, 2, 85, 101, 176, 200,
  128, 128, 128, 2, 85, 101, 120, 128, 112, 8, 240, 2, 87, 103, 32, 32,
  248, 32, 32, 32, 24, 2, 85, 101, 136, 136, 136, 152, 104, 2, 85, 101,
  136, 136, 136, 80, 32, 2, 85, 101, 136, 136, 168, 168, 80, 2, 85, 101,
  136, 80, 32, 80, 136, 0, 87, 103, 136, 136, 136, 80, 32, 64, 128, 2,
  85, 101, 248, 16, 32, 64, 248, 17, 57, 105, 32, 64, 64, 64, 128, 64,
  64, 64, 32, 33, 25, 105, 128, 128, 128, 128, 128, 128, 128, 128, 128, 17,
  57, 105, 128, 64, 64, 64, 32, 64, 64, 64, 128, 4, 83, 99, 72, 168,
  144, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-SemiCondensed--13-120-75-75-C-60-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 3, '1' Height: 9
  Calculated Max Values w= 6 h=13 x= 5 y= 9 dx= 6 dy= 0 ascent=11 len=13
  Font Bounding box     w= 6 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 3 descent= 0
  X Font      ascent = 9 descent= 0
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x13_67_75[2236] U8G_FONT_SECTION("u8g_font_6x13_67_75") = {
  1, 6, 13, 0, 254, 3, 1, 73, 2, 147, 32, 255, 0, 11, 254, 9,
  0, 3, 101, 101, 80, 40, 252, 40, 80, 2, 89, 105, 32, 32, 32, 32,
  168, 112, 168, 112, 32, 3, 101, 101, 36, 72, 240, 72, 36, 3, 101, 101,
  144, 72, 60, 72, 144, 3, 85, 101, 32, 72, 248, 72, 32, 2, 89, 105,
  32, 112, 168, 32, 32, 32, 32, 32, 248, 3, 85, 101, 32, 144, 248, 144,
  32, 2, 89, 105, 248, 32, 32, 32, 32, 32, 168, 112, 32, 2, 89, 105,
  32, 112, 168, 32, 32, 168, 112, 32, 248, 3, 101, 101, 40, 68, 248, 64,
  32, 3, 101, 101, 80, 136, 124, 8, 16, 3, 101, 101, 32, 76, 252, 72,
  40, 3, 101, 101, 16, 200, 252, 72, 80, 4, 100, 100, 72, 220, 236, 72,
  3, 101, 101, 8, 88, 252, 104, 64, 2, 89, 105, 128, 128, 144, 176, 208,
  144, 16, 56, 16, 2, 89, 105, 32, 64, 248, 72, 40, 8, 8, 8, 8,
  2, 89, 105, 32, 16, 248, 144, 160, 128, 128, 128, 128, 2, 89, 105, 8,
  8, 8, 8, 40, 72, 248, 64, 32, 2, 89, 105, 128, 128, 128, 128, 160,
  144, 248, 16, 32, 3, 85, 101, 240, 16, 16, 56, 16, 3, 86, 102, 8,
  8, 8, 72, 248, 64, 3, 85, 101, 48, 72, 72, 232, 72, 3, 85, 101,
  96, 144, 144, 184, 144, 2, 89, 105, 248, 128, 224, 192, 160, 32, 16, 16,
  8, 2, 89, 105, 160, 192, 248, 192, 168, 24, 248, 24, 40, 3, 86, 102,
  56, 48, 168, 136, 136, 112, 3, 86, 102, 224, 96, 168, 136, 136, 112, 5,
  83, 99, 32, 64, 248, 3, 83, 99, 248, 64, 32, 34, 57, 105, 128, 192,
  160, 128, 128, 128, 128, 128, 128, 2, 57, 105, 32, 96, 160, 32, 32, 32,
  32, 32, 32, 5, 83, 99, 32, 16, 248, 3, 83, 99, 248, 16, 32, 34,
  57, 105, 128, 128, 128, 128, 128, 128, 160, 192, 128, 2, 57, 105, 32, 32,
  32, 32, 32, 32, 160, 96, 32, 2, 89, 105, 32, 16, 248, 16, 32, 64,
  248, 64, 32, 2, 89, 105, 80, 240, 80, 80, 80, 80, 80, 120, 80, 2,
  89, 105, 32, 64, 248, 64, 32, 16, 248, 16, 32, 2, 89, 105, 32, 64,
  248, 64, 32, 64, 248, 64, 32, 2, 89, 105, 80, 248, 80, 80, 80, 80,
  80, 80, 80, 2, 89, 105, 32, 16, 248, 16, 32, 16, 248, 16, 32, 2,
  89, 105, 80, 80, 80, 80, 80, 80, 80, 248, 80, 2, 87, 103, 32, 64,
  248, 0, 248, 16, 32, 2, 87, 103, 32, 16, 248, 0, 248, 64, 32, 2,
  103, 103, 20, 40, 124, 144, 124, 32, 80, 2, 103, 103, 8, 88, 252, 164,
  252, 104, 64, 2, 103, 103, 160, 80, 248, 36, 248, 16, 40, 2, 103, 103,
  16, 32, 124, 128, 124, 32, 16, 2, 89, 105, 32, 80, 216, 80, 80, 80,
  80, 80, 80, 2, 103, 103, 32, 16, 248, 4, 248, 16, 32, 2, 89, 105,
  80, 80, 80, 80, 80, 80, 216, 80, 32, 3, 101, 101, 72, 252, 132, 252,
  72, 2, 89, 105, 32, 80, 216, 80, 80, 80, 216, 80, 32, 3, 102, 102,
  248, 160, 208, 168, 148, 8, 3, 102, 102, 124, 20, 44, 84, 164, 64, 3,
  102, 102, 64, 164, 84, 44, 20, 124, 3, 102, 102, 8, 148, 168, 208, 160,
  248, 2, 103, 103, 16, 60, 64, 252, 64, 60, 16, 2, 103, 103, 32, 240,
  8, 252, 8, 240, 32, 4, 100, 100, 64, 232, 212, 64, 4, 100, 100, 8,
  92, 172, 8, 2, 89, 105, 32, 112, 168, 32, 112, 32, 112, 32, 32, 2,
  89, 105, 32, 32, 112, 32, 112, 32, 168, 112, 32, 3, 85, 101, 32, 64,
  168, 64, 32, 2, 89, 105, 32, 112, 168, 0, 32, 32, 0, 32, 32, 3,
  85, 101, 32, 16, 168, 16, 32, 2, 89, 105, 32, 32, 0, 32, 32, 0,
  168, 112, 32, 3, 85, 101, 160, 192, 248, 192, 160, 3, 85, 101, 40, 24,
  248, 24, 40, 3, 85, 101, 32, 120, 136, 120, 32, 2, 89, 105, 32, 80,
  216, 80, 80, 80, 80, 80, 112, 3, 85, 101, 32, 240, 136, 240, 32, 2,
  89, 105, 112, 80, 80, 80, 80, 80, 216, 80, 32, 2, 90, 106, 32, 80,
  216, 80, 80, 112, 0, 112, 80, 112, 2, 89, 105, 32, 80, 216, 80, 80,
  80, 216, 136, 248, 2, 89, 105, 32, 80, 248, 136, 80, 80, 216, 136, 248,
  2, 89, 105, 32, 112, 248, 112, 112, 112, 248, 168, 248, 2, 89, 105, 32,
  80, 216, 80, 216, 80, 80, 80, 112, 2, 89, 105, 32, 80, 216, 80, 216,
  80, 216, 136, 248, 3, 85, 101, 160, 240, 136, 240, 160, 3, 88, 104, 248,
  128, 176, 224, 144, 16, 8, 8, 2, 88, 104, 128, 128, 64, 72, 56, 104,
  8, 248, 2, 89, 105, 32, 80, 216, 80, 80, 80, 216, 80, 32, 3, 101,
  101, 16, 104, 252, 104, 16, 2, 89, 105, 80, 120, 80, 80, 80, 80, 80,
  240, 80, 2, 89, 105, 16, 248, 16, 16, 248, 16, 16, 248, 16, 3, 101,
  101, 40, 72, 252, 72, 40, 3, 101, 101, 80, 72, 252, 72, 80, 4, 101,
  101, 48, 120, 252, 120, 48, 3, 101, 101, 56, 88, 252, 88, 56, 3, 101,
  101, 112, 104, 252, 104, 112, 4, 101, 101, 48, 120, 252, 120, 48, 3, 85,
  101, 32, 96, 184, 96, 32, 3, 85, 101, 32, 48, 232, 48, 32, 4, 101,
  101, 48, 120, 180, 120, 48, 7, 102, 102, 252, 252, 252, 252, 252, 252, 0,
  98, 98, 252, 252, 0, 99, 99, 252, 252, 252, 0, 101, 101, 252, 252, 252,
  252, 252, 0, 103, 103, 252, 252, 252, 252, 252, 252, 252, 0, 104, 104, 252,
  252, 252, 252, 252, 252, 252, 252, 0, 106, 106, 252, 252, 252, 252, 252, 252,
  252, 252, 252, 252, 0, 107, 107, 252, 252, 252, 252, 252, 252, 252, 252, 252,
  252, 252, 0, 109, 109, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252,
  252, 252, 0, 93, 109, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
  248, 248, 0, 77, 109, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 0, 77, 109, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 0, 61, 109, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 0, 45, 109, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 0, 45, 109, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 0, 29, 109, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 48, 61, 109, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 0, 109, 109, 168, 0, 84, 0, 168, 0, 84, 0, 168, 0, 84,
  0, 168, 0, 109, 109, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168,
  84, 168, 0, 109, 109, 84, 252, 168, 252, 84, 252, 168, 252, 84, 252, 168,
  252, 84, 11, 98, 98, 252, 252, 80, 29, 109, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 0, 55, 103, 224, 224, 224, 224, 224, 224,
  224, 48, 55, 103, 224, 224, 224, 224, 224, 224, 224, 7, 54, 102, 224, 224,
  224, 224, 224, 224, 0, 109, 109, 224, 224, 224, 224, 224, 224, 252, 252, 252,
  252, 252, 252, 252, 0, 109, 109, 224, 224, 224, 224, 224, 224, 28, 28, 28,
  28, 28, 28, 28, 0, 109, 109, 252, 252, 252, 252, 252, 252, 224, 224, 224,
  224, 224, 224, 224, 0, 109, 109, 252, 252, 252, 252, 252, 252, 28, 28, 28,
  28, 28, 28, 28, 55, 54, 102, 224, 224, 224, 224, 224, 224, 0, 109, 109,
  28, 28, 28, 28, 28, 28, 224, 224, 224, 224, 224, 224, 224, 0, 109, 109,
  28, 28, 28, 28, 28, 28, 252, 252, 252, 252, 252, 252, 252, 3, 85, 101,
  248, 248, 248, 248, 248, 3, 85, 101, 248, 136, 136, 136, 248, 3, 85, 101,
  112, 136, 136, 136, 112, 3, 85, 101, 248, 136, 168, 136, 248, 2, 85, 101,
  248, 136, 248, 136, 248, 2, 85, 101, 248, 168, 168, 168, 248, 2, 85, 101,
  248, 168, 248, 168, 248, 2, 85, 101, 248, 200, 168, 152, 248, 2, 85, 101,
  248, 152, 168, 200, 248, 2, 85, 101, 248, 216, 168, 216, 248, 21, 51, 99,
  224, 224, 224, 21, 51, 99, 224, 160, 224, 4, 101, 101, 252, 252, 252, 252,
  252, 4, 101, 101, 252, 132, 132, 132, 252, 17, 75, 107, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 17, 75, 107, 240, 144, 144, 144, 144, 144,
  144, 144, 144, 144, 240, 5, 99, 99, 60, 120, 240, 5, 99, 99, 60, 72,
  240, 2, 89, 105, 32, 32, 32, 112, 112, 112, 248, 248, 248, 2, 89, 105,
  32, 32, 32, 80, 80, 80, 136, 136, 248, 4, 85, 101, 32, 32, 112, 112,
  248, 4, 85, 101, 32, 32, 80, 80, 248, 2, 89, 105, 128, 192, 224, 240,
  248, 240, 224, 192, 128, 2, 89, 105, 128, 192, 160, 144, 136, 144, 160, 192,
  128, 20, 53, 101, 128, 192, 224, 192, 128, 20, 53, 101, 128, 192, 160, 192,
  128, 4, 101, 101, 192, 240, 252, 240, 192, 4, 101, 101, 192, 176, 140, 176,
  192, 2, 89, 105, 248, 248, 248, 112, 112, 112, 32, 32, 32, 2, 89, 105,
  248, 136, 136, 80, 80, 80, 32, 32, 32, 3, 85, 101, 248, 112, 112, 32,
  32, 3, 85, 101, 248, 80, 80, 32, 32, 2, 89, 105, 8, 24, 56, 120,
  248, 120, 56, 24, 8, 2, 89, 105, 8, 24, 40, 72, 136, 72, 40, 24,
  8, 20, 53, 101, 32, 96, 224, 96, 32, 20, 53, 101, 32, 96, 160, 96,
  32, 4, 101, 101, 12, 60, 252, 60, 12, 4, 101, 101, 12, 52, 196, 52,
  12, 4, 85, 101, 32, 112, 248, 112, 32, 4, 85, 101, 32, 80, 136, 80,
  32, 4, 85, 101, 32, 80, 168, 80, 32, 3, 102, 102, 48, 72, 180, 180,
  72, 48, 2, 89, 105, 32, 32, 80, 80, 136, 80, 80, 32, 32, 3, 102,
  102, 48, 72, 132, 132, 72, 48, 3, 102, 102, 32, 8, 128, 4, 64, 16,
  2, 85, 101, 112, 168, 168, 168, 112, 2, 87, 103, 112, 136, 168, 216, 168,
  136, 112, 3, 102, 102, 48, 120, 252, 252, 120, 48, 3, 102, 102, 48, 104,
  228, 228, 104, 48, 3, 102, 102, 48, 88, 156, 156, 88, 48, 3, 102, 102,
  48, 72, 132, 252, 120, 48, 3, 102, 102, 48, 120, 252, 132, 72, 48, 3,
  102, 102, 48, 88, 156, 132, 72, 48, 3, 102, 102, 48, 88, 156, 252, 120,
  48, 18, 90, 106, 8, 56, 120, 120, 248, 248, 120, 120, 56, 8, 2, 90,
  106, 128, 224, 240, 240, 248, 248, 240, 240, 224, 128, 0, 109, 109, 252, 252,
  252, 252, 252, 204, 132, 132, 204, 252, 252, 252, 252, 0, 109, 109, 252, 252,
  252, 252, 204, 180, 120, 120, 180, 204, 252, 252, 252, 6, 103, 103, 252, 252,
  252, 252, 204, 180, 120, 0, 102, 102, 120, 180, 204, 252, 252, 252, 6, 51,
  99, 32, 64, 128, 54, 51, 99, 128, 64, 32, 51, 51, 99, 32, 64, 128,
  3, 51, 99, 128, 64, 32, 6, 99, 99, 48, 72, 132, 3, 99, 99, 132,
  72, 48, 3, 85, 101, 8, 24, 56, 120, 248, 3, 85, 101, 128, 192, 224,
  240, 248, 3, 85, 101, 248, 240, 224, 192, 128, 3, 85, 101, 248, 120, 56,
  24, 8, 4, 85, 101, 112, 136, 136, 136, 112, 3, 85, 101, 248, 232, 232,
  232, 248, 3, 85, 101, 248, 184, 184, 184, 248, 3, 85, 101, 248, 248, 232,
  200, 248, 3, 85, 101, 248, 152, 184, 248, 248, 3, 85, 101, 248, 168, 168,
  168, 248, 2, 89, 105, 32, 32, 32, 80, 80, 112, 168, 136, 248, 2, 89,
  105, 32, 32, 32, 112, 112, 112, 232, 232, 248, 2, 89, 105, 32, 32, 32,
  112, 112, 112, 184, 184, 248, 2, 103, 103, 48, 72, 132, 132, 132, 72, 48,
  3, 85, 101, 248, 168, 232, 136, 248, 3, 85, 101, 248, 136, 232, 168, 248,
  3, 85, 101, 248, 136, 184, 168, 248, 3, 85, 101, 248, 168, 184, 136, 248,
  3, 85, 101, 112, 168, 232, 136, 112, 3, 85, 101, 112, 136, 232, 168, 112,
  3, 85, 101, 112, 136, 184, 168, 112, 3, 85, 101, 112, 168, 184, 136, 112,
  3, 85, 101, 248, 144, 160, 192, 128, 3, 85, 101, 248, 72, 40, 24, 8,
  3, 85, 101, 128, 192, 160, 144, 248, 20, 68, 100, 240, 144, 144, 240, 20,
  68, 100, 240, 240, 240, 240, 20, 68, 100, 240, 144, 144, 240, 20, 68, 100,
  240, 240, 240, 240, 3, 85, 101, 8, 24, 40, 72, 248
};

/*
  Fontname: -Misc-Fixed-Medium-R-SemiCondensed--13-120-75-75-C-60-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 3
  Calculated Max Values w= 6 h=11 x= 1 y= 3 dx= 6 dy= 0 ascent=10 len=11
  Font Bounding box     w= 6 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 9 descent= 0
  X Font      ascent = 9 descent= 0
  Max Font    ascent =10 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_6x13_75r[447] U8G_FONT_SECTION("u8g_font_6x13_75r") = {
  1, 6, 13, 0, 254, 9, 1, 57, 0, 0, 32, 79, 0, 10, 255, 9,
  0, 3, 85, 101, 248, 248, 248, 248, 248, 3, 85, 101, 248, 136, 136, 136,
  248, 3, 85, 101, 112, 136, 136, 136, 112, 3, 85, 101, 248, 136, 168, 136,
  248, 2, 85, 101, 248, 136, 248, 136, 248, 2, 85, 101, 248, 168, 168, 168,
  248, 2, 85, 101, 248, 168, 248, 168, 248, 2, 85, 101, 248, 200, 168, 152,
  248, 2, 85, 101, 248, 152, 168, 200, 248, 2, 85, 101, 248, 216, 168, 216,
  248, 21, 51, 99, 224, 224, 224, 21, 51, 99, 224, 160, 224, 4, 101, 101,
  252, 252, 252, 252, 252, 4, 101, 101, 252, 132, 132, 132, 252, 17, 75, 107,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 17, 75, 107, 240, 144,
  144, 144, 144, 144, 144, 144, 144, 144, 240, 5, 99, 99, 60, 120, 240, 5,
  99, 99, 60, 72, 240, 2, 89, 105, 32, 32, 32, 112, 112, 112, 248, 248,
  248, 2, 89, 105, 32, 32, 32, 80, 80, 80, 136, 136, 248, 4, 85, 101,
  32, 32, 112, 112, 248, 4, 85, 101, 32, 32, 80, 80, 248, 2, 89, 105,
  128, 192, 224, 240, 248, 240, 224, 192, 128, 2, 89, 105, 128, 192, 160, 144,
  136, 144, 160, 192, 128, 20, 53, 101, 128, 192, 224, 192, 128, 20, 53, 101,
  128, 192, 160, 192, 128, 4, 101, 101, 192, 240, 252, 240, 192, 4, 101, 101,
  192, 176, 140, 176, 192, 2, 89, 105, 248, 248, 248, 112, 112, 112, 32, 32,
  32, 2, 89, 105, 248, 136, 136, 80, 80, 80, 32, 32, 32, 3, 85, 101,
  248, 112, 112, 32, 32, 3, 85, 101, 248, 80, 80, 32, 32, 2, 89, 105,
  8, 24, 56, 120, 248, 120, 56, 24, 8, 2, 89, 105, 8, 24, 40, 72,
  136, 72, 40, 24, 8, 20, 53, 101, 32, 96, 224, 96, 32, 20, 53, 101,
  32, 96, 160, 96, 32, 4, 101, 101, 12, 60, 252, 60, 12, 4, 101, 101,
  12, 52, 196, 52, 12, 4, 85, 101, 32, 112, 248, 112, 32, 4, 85, 101,
  32, 80, 136, 80, 32, 4, 85, 101, 32, 80, 168, 80, 32, 3, 102, 102,
  48, 72, 180, 180, 72, 48, 2, 89, 105, 32, 32, 80, 80, 136, 80, 80,
  32, 32, 3, 102, 102, 48, 72, 132, 132, 72, 48, 3, 102, 102, 32, 8,
  128, 4, 64, 16, 2, 85, 101, 112, 168, 168, 168, 112, 2, 87, 103, 112,
  136, 168, 216, 168, 136, 112, 3, 102, 102, 48, 120, 252, 252, 120, 48
};

/*
  Fontname: -Misc-Fixed-Medium-R-SemiCondensed--13-120-75-75-C-60-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 0, '1' Height: 7
  Calculated Max Values w= 6 h=13 x= 2 y= 5 dx= 6 dy= 0 ascent=11 len=13
  Font Bounding box     w= 6 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 7 descent= 0
  X Font      ascent =10 descent= 0
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x13_78_79[1470] U8G_FONT_SECTION("u8g_font_6x13_78_79") = {
  1, 6, 13, 0, 254, 7, 1, 42, 2, 11, 32, 255, 0, 11, 254, 10,
  0, 2, 87, 103, 112, 32, 168, 248, 168, 32, 112, 255, 2, 104, 104, 48,
  48, 48, 252, 252, 48, 48, 48, 2, 89, 105, 32, 112, 32, 168, 248, 168,
  32, 112, 32, 2, 89, 105, 32, 112, 32, 168, 248, 168, 32, 112, 32, 2,
  89, 105, 32, 112, 32, 168, 248, 168, 32, 112, 32, 4, 85, 101, 32, 112,
  248, 112, 32, 4, 85, 101, 32, 80, 136, 80, 32, 255, 4, 86, 102, 32,
  32, 248, 80, 112, 136, 2, 89, 105, 112, 216, 216, 0, 136, 136, 112, 248,
  112, 4, 86, 102, 32, 32, 248, 80, 112, 136, 4, 86, 102, 32, 32, 248,
  112, 112, 136, 4, 86, 102, 32, 32, 248, 112, 112, 136, 4, 86, 102, 32,
  32, 248, 112, 112, 136, 4, 86, 102, 32, 32, 248, 112, 112, 136, 4, 102,
  102, 48, 48, 252, 88, 120, 204, 3, 87, 103, 32, 168, 112, 112, 112, 168,
  32, 3, 87, 103, 32, 168, 112, 80, 112, 168, 32, 3, 87, 103, 32, 168,
  112, 248, 112, 168, 32, 3, 87, 103, 32, 168, 112, 248, 112, 168, 32, 3,
  87, 103, 32, 168, 112, 248, 112, 168, 32, 3, 87, 103, 32, 168, 112, 112,
  112, 168, 32, 3, 87, 103, 80, 80, 248, 32, 248, 80, 80, 3, 87, 103,
  80, 112, 248, 112, 248, 112, 80, 255, 255, 3, 87, 103, 32, 168, 168, 112,
  168, 168, 32, 3, 87, 103, 32, 168, 168, 80, 168, 168, 32, 3, 87, 103,
  32, 168, 168, 112, 168, 168, 32, 3, 87, 103, 32, 168, 168, 80, 168, 168,
  32, 4, 85, 101, 32, 248, 80, 112, 216, 255, 255, 255, 3, 87, 103, 32,
  168, 168, 112, 168, 168, 32, 3, 87, 103, 32, 168, 168, 112, 168, 168, 32,
  3, 87, 103, 32, 168, 168, 112, 168, 168, 32, 3, 87, 103, 32, 168, 168,
  112, 168, 168, 32, 3, 87, 103, 32, 168, 112, 248, 112, 168, 32, 3, 87,
  103, 32, 168, 112, 248, 112, 168, 32, 3, 87, 103, 32, 168, 168, 112, 168,
  168, 32, 3, 87, 103, 32, 168, 112, 248, 112, 168, 32, 3, 87, 103, 32,
  168, 112, 248, 112, 168, 32, 255, 2, 102, 102, 120, 140, 140, 140, 140, 120,
  255, 2, 102, 102, 248, 136, 140, 140, 252, 60, 2, 102, 102, 60, 252, 140,
  140, 136, 248, 2, 102, 102, 248, 140, 140, 140, 252, 124, 2, 102, 102, 124,
  252, 140, 140, 140, 248, 255, 255, 255, 2, 89, 105, 32, 112, 32, 80, 248,
  80, 32, 112, 32, 255, 34, 25, 105, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 18, 57, 105, 224, 224, 224, 224, 224, 224, 224, 224, 224, 2, 89, 105,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 23, 53, 101, 96, 128, 224, 224,
  64, 23, 53, 101, 64, 224, 224, 32, 192, 7, 101, 101, 108, 144, 252, 252,
  72, 7, 101, 101, 72, 252, 252, 36, 216, 255, 255, 2, 106, 106, 8, 124,
  232, 232, 120, 8, 104, 104, 72, 48, 18, 57, 105, 64, 224, 224, 64, 64,
  0, 64, 224, 64, 2, 89, 105, 80, 248, 248, 112, 32, 0, 32, 112, 32,
  2, 87, 103, 80, 248, 248, 248, 112, 32, 32, 2, 103, 103, 96, 240, 248,
  124, 248, 240, 96, 2, 89, 105, 104, 176, 16, 216, 248, 240, 96, 104, 48,
  2, 104, 104, 64, 144, 184, 124, 92, 188, 184, 80, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 2, 89, 105, 112, 248, 216, 152,
  216, 216, 136, 248, 112, 2, 89, 105, 112, 248, 216, 168, 232, 216, 136, 248,
  112, 2, 89, 105, 112, 248, 216, 168, 216, 232, 152, 248, 112, 2, 89, 105,
  112, 248, 184, 184, 152, 136, 216, 248, 112, 2, 89, 105, 112, 248, 136, 184,
  152, 232, 152, 248, 112, 2, 89, 105, 112, 248, 200, 184, 152, 168, 216, 248,
  112, 2, 89, 105, 112, 248, 136, 232, 216, 216, 216, 248, 112, 2, 89, 105,
  112, 248, 216, 168, 216, 168, 216, 248, 112, 2, 89, 105, 112, 248, 216, 168,
  200, 232, 152, 248, 112, 2, 105, 105, 120, 252, 172, 148, 148, 148, 172, 252,
  120, 2, 89, 105, 112, 136, 168, 232, 168, 168, 168, 136, 112, 2, 89, 105,
  112, 136, 168, 216, 152, 168, 248, 136, 112, 2, 89, 105, 112, 136, 168, 216,
  168, 152, 232, 136, 112, 2, 89, 105, 112, 136, 200, 200, 232, 248, 168, 136,
  112, 2, 89, 105, 112, 136, 248, 200, 232, 152, 232, 136, 112, 2, 89, 105,
  112, 136, 184, 200, 232, 216, 168, 136, 112, 2, 89, 105, 112, 136, 248, 152,
  168, 168, 168, 136, 112, 2, 89, 105, 112, 136, 168, 216, 168, 216, 168, 136,
  112, 2, 89, 105, 112, 136, 168, 216, 184, 152, 232, 136, 112, 2, 105, 105,
  120, 132, 212, 236, 236, 236, 212, 132, 120, 2, 89, 105, 112, 248, 216, 152,
  216, 216, 216, 248, 112, 2, 89, 105, 112, 248, 216, 168, 232, 216, 136, 248,
  112, 2, 89, 105, 112, 248, 216, 168, 216, 232, 152, 248, 112, 2, 89, 105,
  112, 248, 184, 184, 152, 136, 216, 248, 112, 2, 89, 105, 112, 248, 136, 184,
  152, 232, 152, 248, 112, 2, 89, 105, 112, 248, 200, 184, 152, 168, 216, 248,
  112, 2, 89, 105, 112, 248, 136, 232, 216, 216, 216, 248, 112, 2, 89, 105,
  112, 248, 216, 168, 216, 168, 216, 248, 112, 2, 89, 105, 112, 248, 216, 168,
  200, 232, 152, 248, 112, 2, 105, 105, 120, 252, 172, 148, 148, 148, 172, 252,
  120, 4, 102, 102, 48, 24, 252, 252, 24, 48, 255, 255, 255, 4, 85, 101,
  128, 64, 40, 24, 56, 4, 85, 101, 32, 48, 248, 48, 32, 4, 85, 101,
  56, 24, 40, 64, 128, 3, 103, 103, 64, 32, 48, 252, 48, 32, 64, 3,
  104, 104, 32, 48, 24, 252, 252, 24, 48, 32, 4, 101, 101, 16, 24, 252,
  24, 16, 4, 102, 102, 16, 24, 252, 252, 24, 16, 4, 102, 102, 16, 24,
  188, 188, 24, 16, 3, 103, 103, 32, 48, 184, 188, 184, 48, 32, 3, 103,
  103, 32, 48, 248, 252, 248, 48, 32, 255, 255, 4, 101, 101, 192, 112, 60,
  112, 192, 3, 103, 103, 32, 176, 248, 252, 120, 48, 32, 3, 103, 103, 32,
  48, 120, 252, 248, 176, 32, 0, 109, 109, 32, 32, 48, 240, 248, 248, 252,
  248, 248, 240, 48, 32, 32, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  1, 107, 107, 120, 252, 220, 204, 4, 0, 4, 204, 220, 248, 120, 255, 4,
  102, 102, 32, 32, 224, 20, 12, 28, 4, 101, 101, 144, 200, 124, 200, 144,
  4, 102, 102, 28, 12, 20, 224, 32, 32, 4, 102, 102, 32, 32, 224, 20,
  12, 28, 4, 101, 101, 144, 200, 124, 200, 144, 4, 102, 102, 28, 12, 20,
  224, 32, 32, 4, 101, 101, 16, 8, 252, 8, 16, 4, 101, 101, 16, 200,
  252, 200, 16, 5, 99, 99, 232, 124, 232, 4, 101, 101, 208, 216, 124, 216,
  208, 2, 105, 105, 160, 80, 40, 244, 4, 244, 40, 80, 160, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 1, 91, 107, 248, 160, 160, 160, 160, 160, 160, 160, 160,
  160, 248, 1, 91, 107, 248, 40, 40, 40, 40, 40, 40, 40, 40, 40, 248,
  17, 75, 107, 16, 32, 32, 64, 64, 128, 64, 64, 32, 32, 16, 17, 75,
  107, 128, 64, 64, 32, 32, 16, 32, 32, 64, 64, 128, 1, 107, 107, 20,
  40, 40, 80, 80, 160, 80, 80, 40, 40, 20, 1, 107, 107, 160, 80, 80,
  40, 40, 20, 40, 40, 80, 80, 160, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 3, 101, 101, 32, 64, 252, 64, 32, 3, 101, 101, 16, 8, 252, 8,
  16, 4, 99, 99, 72, 252, 72, 2, 103, 103, 16, 32, 124, 128, 124, 32,
  16, 2, 103, 103, 32, 16, 248, 4, 248, 16, 32, 3, 101, 101, 72, 252,
  132, 252, 72, 3, 101, 101, 36, 68, 252, 68, 36, 3, 101, 101, 144, 136,
  252, 136, 144, 2, 103, 103, 20, 36, 124, 132, 124, 36, 20, 2, 103, 103,
  160, 144, 248, 132, 248, 144, 160, 4, 100, 100, 8, 92, 172, 8
};

/*
  Fontname: -Misc-Fixed-Bold-R-SemiCondensed--13-120-75-75-C-60-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 6 h=11 x= 2 y=11 dx= 6 dy= 0 ascent=11 len=11
  Font Bounding box     w= 6 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent =10 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x13B[2171] U8G_FONT_SECTION("u8g_font_6x13B") = {
  1, 6, 13, 0, 254, 9, 1, 99, 2, 211, 32, 255, 254, 11, 254, 10,
  254, 13, 0, 96, 34, 41, 105, 192, 192, 192, 192, 192, 192, 192, 0, 192,
  8, 83, 99, 216, 216, 216, 3, 103, 103, 120, 120, 252, 120, 252, 120, 120,
  3, 103, 103, 48, 120, 240, 120, 60, 120, 48, 2, 105, 105, 108, 252, 120,
  24, 48, 96, 120, 252, 216, 2, 103, 103, 96, 240, 240, 96, 252, 216, 124,
  40, 35, 99, 192, 192, 192, 17, 75, 107, 48, 96, 96, 192, 192, 192, 192,
  192, 96, 96, 48, 17, 75, 107, 192, 96, 96, 48, 48, 48, 48, 48, 96,
  96, 192, 4, 101, 101, 204, 120, 252, 120, 204, 4, 101, 101, 48, 48, 252,
  48, 48, 17, 67, 99, 112, 96, 192, 6, 97, 97, 252, 17, 67, 99, 96,
  240, 96, 2, 105, 105, 12, 12, 24, 24, 48, 96, 96, 192, 192, 2, 105,
  105, 48, 120, 204, 204, 204, 204, 204, 120, 48, 2, 105, 105, 48, 112, 240,
  48, 48, 48, 48, 48, 252, 2, 105, 105, 120, 204, 204, 12, 24, 48, 96,
  192, 252, 2, 105, 105, 252, 12, 24, 48, 120, 12, 12, 204, 120, 2, 105,
  105, 24, 24, 56, 120, 88, 216, 252, 24, 24, 2, 105, 105, 252, 192, 192,
  248, 236, 12, 12, 204, 120, 2, 105, 105, 56, 96, 192, 192, 248, 236, 204,
  204, 120, 2, 105, 105, 252, 12, 24, 24, 48, 48, 96, 96, 96, 2, 105,
  105, 120, 204, 204, 204, 120, 204, 204, 204, 120, 2, 105, 105, 120, 204, 204,
  220, 124, 12, 12, 24, 112, 18, 72, 104, 96, 240, 96, 0, 0, 96, 240,
  96, 17, 72, 104, 96, 240, 96, 0, 0, 112, 96, 192, 2, 105, 105, 12,
  24, 48, 96, 192, 96, 48, 24, 12, 4, 100, 100, 252, 0, 0, 252, 2,
  105, 105, 192, 96, 48, 24, 12, 24, 48, 96, 192, 2, 105, 105, 120, 204,
  204, 12, 24, 48, 48, 0, 48, 2, 105, 105, 120, 204, 204, 220, 252, 252,
  248, 192, 124, 2, 105, 105, 48, 120, 204, 204, 204, 252, 204, 204, 204, 2,
  105, 105, 248, 108, 108, 108, 120, 108, 108, 108, 248, 2, 105, 105, 120, 204,
  192, 192, 192, 192, 192, 204, 120, 2, 105, 105, 248, 108, 108, 108, 108, 108,
  108, 108, 248, 2, 105, 105, 252, 192, 192, 192, 248, 192, 192, 192, 252, 2,
  105, 105, 252, 192, 192, 192, 248, 192, 192, 192, 192, 2, 105, 105, 120, 204,
  192, 192, 192, 220, 204, 204, 120, 2, 105, 105, 204, 204, 204, 204, 252, 204,
  204, 204, 204, 18, 73, 105, 240, 96, 96, 96, 96, 96, 96, 96, 240, 2,
  105, 105, 60, 12, 12, 12, 12, 12, 12, 204, 120, 2, 105, 105, 204, 204,
  216, 240, 224, 240, 216, 204, 204, 2, 105, 105, 192, 192, 192, 192, 192, 192,
  192, 192, 252, 2, 105, 105, 204, 204, 252, 252, 252, 204, 204, 204, 204, 2,
  105, 105, 204, 236, 236, 252, 252, 220, 220, 204, 204, 2, 105, 105, 120, 204,
  204, 204, 204, 204, 204, 204, 120, 2, 105, 105, 248, 204, 204, 204, 248, 192,
  192, 192, 192, 1, 106, 106, 120, 204, 204, 204, 204, 204, 204, 252, 120, 12,
  2, 105, 105, 248, 204, 204, 204, 248, 240, 216, 204, 204, 2, 105, 105, 120,
  204, 192, 192, 120, 12, 12, 204, 120, 2, 105, 105, 252, 48, 48, 48, 48,
  48, 48, 48, 48, 2, 105, 105, 204, 204, 204, 204, 204, 204, 204, 204, 120,
  2, 105, 105, 204, 204, 204, 204, 120, 120, 120, 48, 48, 2, 105, 105, 204,
  204, 204, 204, 252, 252, 252, 252, 204, 2, 105, 105, 204, 204, 120, 120, 48,
  120, 120, 204, 204, 2, 105, 105, 204, 204, 120, 120, 48, 48, 48, 48, 48,
  2, 105, 105, 252, 12, 24, 24, 48, 96, 96, 192, 252, 17, 75, 107, 240,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 240, 2, 105, 105, 192, 192, 96,
  96, 48, 24, 24, 12, 12, 17, 75, 107, 240, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 240, 8, 99, 99, 48, 120, 204, 1, 97, 97, 252, 26, 50,
  98, 192, 96, 2, 102, 102, 120, 12, 124, 204, 220, 108, 2, 105, 105, 192,
  192, 192, 216, 236, 204, 204, 236, 216, 2, 102, 102, 120, 204, 192, 192, 204,
  120, 2, 105, 105, 12, 12, 12, 108, 220, 204, 204, 220, 108, 2, 102, 102,
  120, 204, 252, 192, 192, 120, 2, 105, 105, 56, 108, 96, 96, 248, 96, 96,
  96, 96, 0, 104, 104, 124, 216, 216, 112, 192, 120, 204, 120, 2, 105, 105,
  192, 192, 192, 216, 236, 204, 204, 204, 204, 18, 73, 105, 96, 96, 0, 224,
  96, 96, 96, 96, 240, 0, 91, 107, 24, 24, 0, 56, 24, 24, 24, 24,
  216, 216, 112, 2, 105, 105, 192, 192, 192, 216, 240, 224, 240, 216, 204, 18,
  73, 105, 224, 96, 96, 96, 96, 96, 96, 96, 240, 2, 102, 102, 248, 252,
  252, 252, 252, 204, 2, 102, 102, 216, 236, 204, 204, 204, 204, 2, 102, 102,
  120, 204, 204, 204, 204, 120, 0, 104, 104, 216, 236, 204, 236, 216, 192, 192,
  192, 0, 104, 104, 108, 220, 204, 220, 108, 12, 12, 12, 2, 102, 102, 216,
  236, 192, 192, 192, 192, 2, 102, 102, 120, 204, 112, 24, 204, 120, 2, 104,
  104, 96, 96, 248, 96, 96, 96, 108, 56, 2, 102, 102, 204, 204, 204, 204,
  220, 108, 2, 102, 102, 204, 204, 204, 120, 120, 48, 2, 102, 102, 204, 204,
  252, 252, 252, 72, 2, 102, 102, 204, 120, 48, 48, 120, 204, 0, 104, 104,
  204, 204, 204, 220, 108, 12, 204, 120, 2, 102, 102, 252, 24, 48, 96, 192,
  252, 1, 91, 107, 56, 96, 96, 96, 48, 224, 48, 96, 96, 96, 56, 34,
  41, 105, 192, 192, 192, 192, 192, 192, 192, 192, 192, 1, 91, 107, 224, 48,
  48, 48, 96, 56, 96, 48, 48, 48, 224, 8, 83, 99, 104, 248, 144, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  13, 0, 96, 34, 42, 106, 192, 192, 0, 192, 192, 192, 192, 192, 192, 192,
  3, 104, 104, 16, 120, 212, 208, 208, 212, 120, 16, 2, 105, 105, 56, 108,
  96, 96, 248, 96, 96, 100, 248, 3, 102, 102, 204, 252, 72, 72, 252, 204,
  2, 105, 105, 204, 204, 120, 120, 252, 48, 252, 48, 48, 34, 42, 106, 192,
  192, 192, 192, 0, 0, 192, 192, 192, 192, 2, 106, 106, 120, 204, 192, 120,
  204, 204, 120, 12, 204, 120, 9, 98, 98, 204, 204, 2, 105, 105, 120, 204,
  180, 236, 228, 236, 180, 204, 120, 4, 103, 103, 248, 12, 252, 140, 252, 0,
  252, 3, 103, 103, 52, 104, 208, 160, 208, 104, 52, 4, 100, 100, 252, 252,
  4, 4, 22, 65, 97, 240, 2, 105, 105, 120, 204, 188, 172, 188, 180, 172,
  204, 120, 9, 82, 98, 248, 248, 7, 100, 100, 120, 204, 204, 120, 2, 105,
  105, 48, 48, 252, 252, 48, 48, 0, 252, 252, 6, 70, 102, 224, 176, 48,
  96, 192, 240, 6, 70, 102, 224, 176, 96, 48, 176, 224, 26, 50, 98, 96,
  192, 0, 104, 104, 204, 204, 204, 204, 204, 252, 128, 128, 2, 105, 105, 124,
  252, 244, 244, 244, 116, 52, 52, 52, 38, 34, 98, 192, 192, 16, 50, 98,
  96, 192, 6, 70, 102, 96, 224, 96, 96, 96, 240, 5, 87, 103, 112, 248,
  136, 248, 112, 0, 248, 3, 103, 103, 176, 88, 44, 20, 44, 88, 176, 2,
  106, 106, 96, 224, 96, 96, 100, 252, 28, 52, 60, 12, 2, 106, 106, 96,
  224, 96, 96, 120, 236, 12, 24, 48, 60, 2, 106, 106, 224, 176, 96, 48,
  180, 236, 28, 52, 60, 12, 2, 106, 106, 48, 48, 0, 48, 48, 96, 192,
  204, 204, 120, 2, 106, 106, 96, 48, 0, 48, 120, 204, 204, 252, 204, 204,
  2, 106, 106, 24, 48, 0, 48, 120, 204, 204, 252, 204, 204, 2, 106, 106,
  56, 108, 0, 48, 120, 204, 204, 252, 204, 204, 2, 106, 106, 52, 88, 0,
  48, 120, 204, 204, 252, 204, 204, 2, 106, 106, 204, 204, 0, 48, 120, 204,
  204, 252, 204, 204, 2, 106, 106, 48, 72, 120, 48, 120, 204, 204, 252, 204,
  204, 2, 105, 105, 124, 176, 176, 176, 184, 240, 240, 176, 188, 0, 107, 107,
  120, 204, 192, 192, 192, 192, 192, 204, 120, 48, 96, 2, 106, 106, 96, 48,
  0, 252, 192, 192, 248, 192, 192, 252, 2, 106, 106, 24, 48, 0, 252, 192,
  192, 248, 192, 192, 252, 2, 106, 106, 56, 108, 0, 252, 192, 192, 248, 192,
  192, 252, 2, 106, 106, 204, 204, 0, 252, 192, 192, 248, 192, 192, 252, 18,
  74, 106, 192, 96, 0, 240, 96, 96, 96, 96, 96, 240, 18, 74, 106, 48,
  96, 0, 240, 96, 96, 96, 96, 96, 240, 2, 90, 106, 112, 216, 0, 120,
  48, 48, 48, 48, 48, 120, 2, 106, 106, 204, 204, 0, 120, 48, 48, 48,
  48, 48, 120, 2, 105, 105, 248, 108, 108, 108, 236, 108, 108, 108, 248, 2,
  106, 106, 52, 88, 0, 204, 236, 236, 252, 220, 220, 204, 2, 106, 106, 96,
  48, 0, 120, 204, 204, 204, 204, 204, 120, 2, 106, 106, 24, 48, 0, 120,
  204, 204, 204, 204, 204, 120, 2, 106, 106, 56, 108, 0, 120, 204, 204, 204,
  204, 204, 120, 2, 106, 106, 52, 88, 0, 120, 204, 204, 204, 204, 204, 120,
  2, 106, 106, 204, 204, 0, 120, 204, 204, 204, 204, 204, 120, 3, 101, 101,
  204, 120, 48, 120, 204, 1, 105, 105, 4, 120, 220, 220, 204, 236, 236, 120,
  128, 2, 106, 106, 96, 48, 0, 204, 204, 204, 204, 204, 204, 120, 2, 106,
  106, 24, 48, 0, 204, 204, 204, 204, 204, 204, 120, 2, 106, 106, 56, 108,
  0, 204, 204, 204, 204, 204, 204, 120, 2, 106, 106, 108, 108, 0, 204, 204,
  204, 204, 204, 204, 120, 2, 106, 106, 24, 48, 0, 204, 72, 120, 48, 48,
  48, 48, 2, 105, 105, 192, 248, 204, 204, 204, 248, 192, 192, 192, 1, 105,
  105, 120, 204, 204, 248, 204, 204, 204, 248, 128, 2, 105, 105, 96, 48, 0,
  120, 12, 124, 204, 220, 108, 2, 105, 105, 24, 48, 0, 120, 12, 124, 204,
  220, 108, 2, 105, 105, 56, 108, 0, 120, 12, 124, 204, 220, 108, 2, 105,
  105, 52, 88, 0, 120, 12, 124, 204, 220, 108, 2, 105, 105, 108, 108, 0,
  120, 12, 124, 204, 220, 108, 2, 106, 106, 56, 40, 56, 0, 120, 12, 124,
  204, 220, 108, 2, 102, 102, 120, 52, 120, 176, 180, 104, 0, 104, 104, 120,
  204, 192, 192, 204, 120, 48, 96, 2, 105, 105, 96, 48, 0, 120, 204, 252,
  192, 192, 120, 2, 105, 105, 24, 48, 0, 120, 204, 252, 192, 192, 120, 2,
  105, 105, 56, 108, 0, 120, 204, 252, 192, 192, 120, 2, 105, 105, 108, 108,
  0, 120, 204, 252, 192, 192, 120, 18, 73, 105, 192, 96, 0, 224, 96, 96,
  96, 96, 240, 18, 73, 105, 48, 96, 0, 224, 96, 96, 96, 96, 240, 2,
  89, 105, 112, 216, 0, 112, 48, 48, 48, 48, 120, 2, 89, 105, 216, 216,
  0, 112, 48, 48, 48, 48, 120, 2, 106, 106, 216, 112, 240, 152, 120, 204,
  204, 204, 204, 120, 2, 105, 105, 52, 88, 0, 216, 236, 204, 204, 204, 204,
  2, 105, 105, 96, 48, 0, 120, 204, 204, 204, 204, 120, 2, 105, 105, 24,
  48, 0, 120, 204, 204, 204, 204, 120, 2, 105, 105, 56, 108, 0, 120, 204,
  204, 204, 204, 120, 2, 105, 105, 52, 88, 0, 120, 204, 204, 204, 204, 120,
  2, 105, 105, 204, 204, 0, 120, 204, 204, 204, 204, 120, 3, 103, 103, 48,
  48, 0, 252, 0, 48, 48, 1, 105, 105, 4, 120, 204, 220, 204, 236, 204,
  120, 128, 2, 105, 105, 96, 48, 0, 204, 204, 204, 204, 220, 108, 2, 105,
  105, 24, 48, 0, 204, 204, 204, 204, 220, 108, 2, 105, 105, 56, 108, 0,
  204, 204, 204, 204, 220, 108, 2, 105, 105, 204, 204, 0, 204, 204, 204, 204,
  220, 108, 0, 107, 107, 24, 48, 0, 204, 204, 204, 220, 108, 12, 204, 120,
  0, 106, 106, 192, 192, 216, 236, 204, 236, 216, 192, 192, 192, 0, 107, 107,
  204, 204, 0, 204, 204, 204, 220, 108, 12, 204, 120
};

/*
  Fontname: -Misc-Fixed-Bold-R-SemiCondensed--13-120-75-75-C-60-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 6 h=11 x= 2 y=11 dx= 6 dy= 0 ascent=11 len=11
  Font Bounding box     w= 6 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent =10 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x13Br[1040] U8G_FONT_SECTION("u8g_font_6x13Br") = {
  1, 6, 13, 0, 254, 9, 1, 99, 2, 211, 32, 127, 254, 11, 254, 10,
  254, 13, 0, 96, 34, 41, 105, 192, 192, 192, 192, 192, 192, 192, 0, 192,
  8, 83, 99, 216, 216, 216, 3, 103, 103, 120, 120, 252, 120, 252, 120, 120,
  3, 103, 103, 48, 120, 240, 120, 60, 120, 48, 2, 105, 105, 108, 252, 120,
  24, 48, 96, 120, 252, 216, 2, 103, 103, 96, 240, 240, 96, 252, 216, 124,
  40, 35, 99, 192, 192, 192, 17, 75, 107, 48, 96, 96, 192, 192, 192, 192,
  192, 96, 96, 48, 17, 75, 107, 192, 96, 96, 48, 48, 48, 48, 48, 96,
  96, 192, 4, 101, 101, 204, 120, 252, 120, 204, 4, 101, 101, 48, 48, 252,
  48, 48, 17, 67, 99, 112, 96, 192, 6, 97, 97, 252, 17, 67, 99, 96,
  240, 96, 2, 105, 105, 12, 12, 24, 24, 48, 96, 96, 192, 192, 2, 105,
  105, 48, 120, 204, 204, 204, 204, 204, 120, 48, 2, 105, 105, 48, 112, 240,
  48, 48, 48, 48, 48, 252, 2, 105, 105, 120, 204, 204, 12, 24, 48, 96,
  192, 252, 2, 105, 105, 252, 12, 24, 48, 120, 12, 12, 204, 120, 2, 105,
  105, 24, 24, 56, 120, 88, 216, 252, 24, 24, 2, 105, 105, 252, 192, 192,
  248, 236, 12, 12, 204, 120, 2, 105, 105, 56, 96, 192, 192, 248, 236, 204,
  204, 120, 2, 105, 105, 252, 12, 24, 24, 48, 48, 96, 96, 96, 2, 105,
  105, 120, 204, 204, 204, 120, 204, 204, 204, 120, 2, 105, 105, 120, 204, 204,
  220, 124, 12, 12, 24, 112, 18, 72, 104, 96, 240, 96, 0, 0, 96, 240,
  96, 17, 72, 104, 96, 240, 96, 0, 0, 112, 96, 192, 2, 105, 105, 12,
  24, 48, 96, 192, 96, 48, 24, 12, 4, 100, 100, 252, 0, 0, 252, 2,
  105, 105, 192, 96, 48, 24, 12, 24, 48, 96, 192, 2, 105, 105, 120, 204,
  204, 12, 24, 48, 48, 0, 48, 2, 105, 105, 120, 204, 204, 220, 252, 252,
  248, 192, 124, 2, 105, 105, 48, 120, 204, 204, 204, 252, 204, 204, 204, 2,
  105, 105, 248, 108, 108, 108, 120, 108, 108, 108, 248, 2, 105, 105, 120, 204,
  192, 192, 192, 192, 192, 204, 120, 2, 105, 105, 248, 108, 108, 108, 108, 108,
  108, 108, 248, 2, 105, 105, 252, 192, 192, 192, 248, 192, 192, 192, 252, 2,
  105, 105, 252, 192, 192, 192, 248, 192, 192, 192, 192, 2, 105, 105, 120, 204,
  192, 192, 192, 220, 204, 204, 120, 2, 105, 105, 204, 204, 204, 204, 252, 204,
  204, 204, 204, 18, 73, 105, 240, 96, 96, 96, 96, 96, 96, 96, 240, 2,
  105, 105, 60, 12, 12, 12, 12, 12, 12, 204, 120, 2, 105, 105, 204, 204,
  216, 240, 224, 240, 216, 204, 204, 2, 105, 105, 192, 192, 192, 192, 192, 192,
  192, 192, 252, 2, 105, 105, 204, 204, 252, 252, 252, 204, 204, 204, 204, 2,
  105, 105, 204, 236, 236, 252, 252, 220, 220, 204, 204, 2, 105, 105, 120, 204,
  204, 204, 204, 204, 204, 204, 120, 2, 105, 105, 248, 204, 204, 204, 248, 192,
  192, 192, 192, 1, 106, 106, 120, 204, 204, 204, 204, 204, 204, 252, 120, 12,
  2, 105, 105, 248, 204, 204, 204, 248, 240, 216, 204, 204, 2, 105, 105, 120,
  204, 192, 192, 120, 12, 12, 204, 120, 2, 105, 105, 252, 48, 48, 48, 48,
  48, 48, 48, 48, 2, 105, 105, 204, 204, 204, 204, 204, 204, 204, 204, 120,
  2, 105, 105, 204, 204, 204, 204, 120, 120, 120, 48, 48, 2, 105, 105, 204,
  204, 204, 204, 252, 252, 252, 252, 204, 2, 105, 105, 204, 204, 120, 120, 48,
  120, 120, 204, 204, 2, 105, 105, 204, 204, 120, 120, 48, 48, 48, 48, 48,
  2, 105, 105, 252, 12, 24, 24, 48, 96, 96, 192, 252, 17, 75, 107, 240,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 240, 2, 105, 105, 192, 192, 96,
  96, 48, 24, 24, 12, 12, 17, 75, 107, 240, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 240, 8, 99, 99, 48, 120, 204, 1, 97, 97, 252, 26, 50,
  98, 192, 96, 2, 102, 102, 120, 12, 124, 204, 220, 108, 2, 105, 105, 192,
  192, 192, 216, 236, 204, 204, 236, 216, 2, 102, 102, 120, 204, 192, 192, 204,
  120, 2, 105, 105, 12, 12, 12, 108, 220, 204, 204, 220, 108, 2, 102, 102,
  120, 204, 252, 192, 192, 120, 2, 105, 105, 56, 108, 96, 96, 248, 96, 96,
  96, 96, 0, 104, 104, 124, 216, 216, 112, 192, 120, 204, 120, 2, 105, 105,
  192, 192, 192, 216, 236, 204, 204, 204, 204, 18, 73, 105, 96, 96, 0, 224,
  96, 96, 96, 96, 240, 0, 91, 107, 24, 24, 0, 56, 24, 24, 24, 24,
  216, 216, 112, 2, 105, 105, 192, 192, 192, 216, 240, 224, 240, 216, 204, 18,
  73, 105, 224, 96, 96, 96, 96, 96, 96, 96, 240, 2, 102, 102, 248, 252,
  252, 252, 252, 204, 2, 102, 102, 216, 236, 204, 204, 204, 204, 2, 102, 102,
  120, 204, 204, 204, 204, 120, 0, 104, 104, 216, 236, 204, 236, 216, 192, 192,
  192, 0, 104, 104, 108, 220, 204, 220, 108, 12, 12, 12, 2, 102, 102, 216,
  236, 192, 192, 192, 192, 2, 102, 102, 120, 204, 112, 24, 204, 120, 2, 104,
  104, 96, 96, 248, 96, 96, 96, 108, 56, 2, 102, 102, 204, 204, 204, 204,
  220, 108, 2, 102, 102, 204, 204, 204, 120, 120, 48, 2, 102, 102, 204, 204,
  252, 252, 252, 72, 2, 102, 102, 204, 120, 48, 48, 120, 204, 0, 104, 104,
  204, 204, 204, 220, 108, 12, 204, 120, 2, 102, 102, 252, 24, 48, 96, 192,
  252, 1, 91, 107, 56, 96, 96, 96, 48, 224, 48, 96, 96, 96, 56, 34,
  41, 105, 192, 192, 192, 192, 192, 192, 192, 192, 192, 1, 91, 107, 224, 48,
  48, 48, 96, 56, 96, 48, 48, 48, 224, 8, 83, 99, 104, 248, 144, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-SemiCondensed--13-120-75-75-C-60-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 5 h=11 x= 2 y=11 dx= 6 dy= 0 ascent=11 len=11
  Font Bounding box     w= 6 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent =10 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x13[2160] U8G_FONT_SECTION("u8g_font_6x13") = {
  1, 6, 13, 0, 254, 9, 1, 102, 2, 214, 32, 255, 254, 11, 254, 10,
  254, 13, 0, 96, 34, 25, 105, 128, 128, 128, 128, 128, 128, 128, 0, 128,
  24, 51, 99, 160, 160, 160, 3, 87, 103, 80, 80, 248, 80, 248, 80, 80,
  2, 89, 105, 32, 120, 160, 160, 112, 40, 40, 240, 32, 2, 89, 105, 72,
  168, 80, 16, 32, 64, 80, 168, 144, 2, 88, 104, 64, 160, 160, 64, 160,
  152, 144, 104, 40, 19, 99, 128, 128, 128, 17, 59, 107, 32, 64, 64, 128,
  128, 128, 128, 128, 64, 64, 32, 17, 59, 107, 128, 64, 64, 32, 32, 32,
  32, 32, 64, 64, 128, 6, 85, 101, 32, 168, 112, 168, 32, 4, 85, 101,
  32, 32, 248, 32, 32, 17, 51, 99, 96, 64, 128, 6, 81, 97, 248, 17,
  51, 99, 64, 224, 64, 2, 89, 105, 8, 8, 16, 16, 32, 64, 64, 128,
  128, 2, 89, 105, 32, 80, 136, 136, 136, 136, 136, 80, 32, 2, 89, 105,
  32, 96, 160, 32, 32, 32, 32, 32, 248, 2, 89, 105, 112, 136, 136, 8,
  16, 32, 64, 128, 248, 2, 89, 105, 248, 8, 16, 32, 112, 8, 8, 136,
  112, 2, 89, 105, 16, 16, 48, 80, 80, 144, 248, 16, 16, 2, 89, 105,
  248, 128, 128, 176, 200, 8, 8, 136, 112, 2, 89, 105, 112, 136, 128, 128,
  240, 136, 136, 136, 112, 2, 89, 105, 248, 8, 16, 16, 32, 32, 64, 64,
  64, 2, 89, 105, 112, 136, 136, 136, 112, 136, 136, 136, 112, 2, 89, 105,
  112, 136, 136, 136, 120, 8, 8, 136, 112, 17, 56, 104, 64, 224, 64, 0,
  0, 64, 224, 64, 17, 56, 104, 64, 224, 64, 0, 0, 96, 64, 128, 2,
  89, 105, 8, 16, 32, 64, 128, 64, 32, 16, 8, 4, 84, 100, 248, 0,
  0, 248, 2, 89, 105, 128, 64, 32, 16, 8, 16, 32, 64, 128, 2, 89,
  105, 112, 136, 136, 8, 16, 32, 32, 0, 32, 2, 89, 105, 112, 136, 136,
  152, 168, 168, 176, 128, 120, 2, 89, 105, 32, 80, 136, 136, 136, 248, 136,
  136, 136, 2, 89, 105, 240, 72, 72, 72, 112, 72, 72, 72, 240, 2, 89,
  105, 112, 136, 128, 128, 128, 128, 128, 136, 112, 2, 89, 105, 240, 72, 72,
  72, 72, 72, 72, 72, 240, 2, 89, 105, 248, 128, 128, 128, 240, 128, 128,
  128, 248, 2, 89, 105, 248, 128, 128, 128, 240, 128, 128, 128, 128, 2, 89,
  105, 112, 136, 128, 128, 128, 152, 136, 136, 112, 2, 89, 105, 136, 136, 136,
  136, 248, 136, 136, 136, 136, 18, 57, 105, 224, 64, 64, 64, 64, 64, 64,
  64, 224, 2, 89, 105, 56, 16, 16, 16, 16, 16, 16, 144, 96, 2, 89,
  105, 136, 136, 144, 160, 192, 160, 144, 136, 136, 2, 89, 105, 128, 128, 128,
  128, 128, 128, 128, 128, 248, 2, 89, 105, 136, 136, 216, 168, 168, 136, 136,
  136, 136, 2, 89, 105, 136, 200, 200, 168, 168, 152, 152, 136, 136, 2, 89,
  105, 112, 136, 136, 136, 136, 136, 136, 136, 112, 2, 89, 105, 240, 136, 136,
  136, 240, 128, 128, 128, 128, 1, 90, 106, 112, 136, 136, 136, 136, 136, 136,
  168, 112, 8, 2, 89, 105, 240, 136, 136, 136, 240, 160, 144, 136, 136, 2,
  89, 105, 112, 136, 128, 128, 112, 8, 8, 136, 112, 2, 89, 105, 248, 32,
  32, 32, 32, 32, 32, 32, 32, 2, 89, 105, 136, 136, 136, 136, 136, 136,
  136, 136, 112, 2, 89, 105, 136, 136, 136, 136, 80, 80, 80, 32, 32, 2,
  89, 105, 136, 136, 136, 136, 168, 168, 168, 168, 80, 2, 89, 105, 136, 136,
  80, 80, 32, 80, 80, 136, 136, 2, 89, 105, 136, 136, 80, 80, 32, 32,
  32, 32, 32, 2, 89, 105, 248, 8, 16, 16, 32, 64, 64, 128, 248, 17,
  59, 107, 224, 128, 128, 128, 128, 128, 128, 128, 128, 128, 224, 2, 89, 105,
  128, 128, 64, 64, 32, 16, 16, 8, 8, 17, 59, 107, 224, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 224, 8, 83, 99, 32, 80, 136, 1, 81, 97,
  248, 42, 34, 98, 128, 64, 2, 86, 102, 112, 8, 120, 136, 152, 104, 2,
  89, 105, 128, 128, 128, 240, 136, 136, 136, 136, 240, 2, 86, 102, 112, 136,
  128, 128, 136, 112, 2, 89, 105, 8, 8, 8, 120, 136, 136, 136, 136, 120,
  2, 86, 102, 112, 136, 248, 128, 136, 112, 2, 89, 105, 48, 72, 64, 64,
  240, 64, 64, 64, 64, 0, 88, 104, 112, 136, 136, 136, 120, 8, 136, 112,
  2, 89, 105, 128, 128, 128, 176, 200, 136, 136, 136, 136, 18, 56, 104, 64,
  0, 192, 64, 64, 64, 64, 224, 0, 74, 106, 16, 0, 48, 16, 16, 16,
  16, 144, 144, 96, 2, 89, 105, 128, 128, 128, 144, 160, 192, 160, 144, 136,
  18, 57, 105, 192, 64, 64, 64, 64, 64, 64, 64, 224, 2, 86, 102, 208,
  168, 168, 168, 168, 136, 2, 86, 102, 176, 200, 136, 136, 136, 136, 2, 86,
  102, 112, 136, 136, 136, 136, 112, 0, 88, 104, 240, 136, 136, 136, 240, 128,
  128, 128, 0, 88, 104, 120, 136, 136, 136, 120, 8, 8, 8, 2, 86, 102,
  176, 200, 128, 128, 128, 128, 2, 86, 102, 112, 136, 96, 16, 136, 112, 2,
  88, 104, 64, 64, 240, 64, 64, 64, 72, 48, 2, 86, 102, 136, 136, 136,
  136, 152, 104, 2, 86, 102, 136, 136, 136, 80, 80, 32, 2, 86, 102, 136,
  136, 168, 168, 168, 80, 2, 86, 102, 136, 80, 32, 32, 80, 136, 0, 88,
  104, 136, 136, 136, 152, 104, 8, 136, 112, 2, 86, 102, 248, 16, 32, 64,
  128, 248, 1, 91, 107, 24, 32, 32, 32, 32, 192, 32, 32, 32, 32, 24,
  34, 25, 105, 128, 128, 128, 128, 128, 128, 128, 128, 128, 1, 91, 107, 192,
  32, 32, 32, 32, 24, 32, 32, 32, 32, 192, 8, 83, 99, 72, 168, 144,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 13, 0, 96, 34, 25, 105, 128, 0, 128, 128, 128, 128, 128, 128, 128,
  3, 88, 104, 32, 112, 168, 160, 160, 168, 112, 32, 2, 89, 105, 48, 72,
  64, 64, 224, 64, 64, 72, 176, 3, 86, 102, 136, 112, 80, 80, 112, 136,
  2, 89, 105, 136, 136, 80, 80, 248, 32, 248, 32, 32, 34, 25, 105, 128,
  128, 128, 128, 0, 128, 128, 128, 128, 18, 74, 106, 96, 144, 128, 96, 144,
  144, 96, 16, 144, 96, 26, 50, 98, 160, 160, 3, 89, 105, 112, 136, 168,
  216, 200, 216, 168, 136, 112, 4, 87, 103, 112, 8, 120, 136, 120, 0, 248,
  3, 86, 102, 40, 80, 160, 160, 80, 40, 4, 83, 99, 248, 8, 8, 22,
  49, 97, 224, 3, 89, 105, 112, 136, 232, 216, 216, 232, 216, 136, 112, 10,
  81, 97, 248, 23, 68, 100, 96, 144, 144, 96, 3, 87, 103, 32, 32, 248,
  32, 32, 0, 248, 7, 53, 101, 64, 160, 32, 64, 224, 7, 53, 101, 64,
  160, 64, 32, 192, 42, 34, 98, 64, 128, 0, 88, 104, 136, 136, 136, 136,
  152, 232, 128, 128, 2, 89, 105, 120, 232, 232, 232, 232, 104, 40, 40, 40,
  38, 33, 97, 192, 32, 34, 98, 64, 128, 7, 53, 101, 64, 192, 64, 64,
  224, 4, 87, 103, 112, 136, 136, 136, 112, 0, 248, 3, 86, 102, 160, 80,
  40, 40, 80, 160, 2, 90, 106, 64, 192, 64, 64, 224, 8, 24, 40, 56,
  8, 2, 90, 106, 64, 192, 64, 64, 224, 16, 40, 8, 16, 56, 2, 90,
  106, 64, 160, 64, 32, 160, 72, 24, 40, 56, 8, 2, 89, 105, 32, 0,
  32, 32, 64, 128, 136, 136, 112, 2, 90, 106, 64, 32, 0, 32, 80, 136,
  136, 248, 136, 136, 2, 90, 106, 16, 32, 0, 32, 80, 136, 136, 248, 136,
  136, 2, 90, 106, 48, 72, 0, 32, 80, 136, 136, 248, 136, 136, 2, 90,
  106, 40, 80, 0, 32, 80, 136, 136, 248, 136, 136, 2, 90, 106, 80, 80,
  0, 32, 80, 136, 136, 248, 136, 136, 2, 90, 106, 32, 80, 32, 32, 80,
  136, 136, 248, 136, 136, 2, 89, 105, 88, 160, 160, 160, 176, 224, 160, 160,
  184, 0, 91, 107, 112, 136, 128, 128, 128, 128, 128, 136, 112, 32, 64, 2,
  90, 106, 64, 32, 0, 248, 128, 128, 240, 128, 128, 248, 2, 90, 106, 16,
  32, 0, 248, 128, 128, 240, 128, 128, 248, 2, 90, 106, 48, 72, 0, 248,
  128, 128, 240, 128, 128, 248, 2, 90, 106, 80, 80, 0, 248, 128, 128, 240,
  128, 128, 248, 18, 58, 106, 128, 64, 0, 224, 64, 64, 64, 64, 64, 224,
  18, 58, 106, 32, 64, 0, 224, 64, 64, 64, 64, 64, 224, 18, 74, 106,
  96, 144, 0, 224, 64, 64, 64, 64, 64, 224, 18, 58, 106, 160, 160, 0,
  224, 64, 64, 64, 64, 64, 224, 2, 89, 105, 240, 72, 72, 72, 232, 72,
  72, 72, 240, 2, 90, 106, 40, 80, 0, 136, 136, 200, 168, 152, 136, 136,
  2, 90, 106, 64, 32, 0, 112, 136, 136, 136, 136, 136, 112, 2, 90, 106,
  16, 32, 0, 112, 136, 136, 136, 136, 136, 112, 2, 90, 106, 48, 72, 0,
  112, 136, 136, 136, 136, 136, 112, 2, 90, 106, 40, 80, 0, 112, 136, 136,
  136, 136, 136, 112, 2, 90, 106, 80, 80, 0, 112, 136, 136, 136, 136, 136,
  112, 3, 85, 101, 136, 80, 32, 80, 136, 1, 91, 107, 8, 112, 152, 152,
  168, 168, 168, 200, 200, 112, 128, 2, 90, 106, 64, 32, 0, 136, 136, 136,
  136, 136, 136, 112, 2, 90, 106, 16, 32, 0, 136, 136, 136, 136, 136, 136,
  112, 2, 90, 106, 48, 72, 0, 136, 136, 136, 136, 136, 136, 112, 2, 90,
  106, 80, 80, 0, 136, 136, 136, 136, 136, 136, 112, 2, 90, 106, 16, 32,
  0, 136, 136, 80, 32, 32, 32, 32, 2, 89, 105, 128, 240, 136, 136, 136,
  240, 128, 128, 128, 2, 89, 105, 96, 144, 144, 160, 160, 144, 136, 136, 176,
  2, 89, 105, 64, 32, 0, 112, 8, 120, 136, 152, 104, 2, 89, 105, 16,
  32, 0, 112, 8, 120, 136, 152, 104, 2, 89, 105, 48, 72, 0, 112, 8,
  120, 136, 152, 104, 2, 89, 105, 40, 80, 0, 112, 8, 120, 136, 152, 104,
  2, 89, 105, 80, 80, 0, 112, 8, 120, 136, 152, 104, 2, 90, 106, 48,
  72, 48, 0, 112, 8, 120, 136, 152, 104, 2, 86, 102, 112, 40, 112, 160,
  168, 80, 0, 88, 104, 112, 136, 128, 128, 136, 112, 32, 64, 2, 89, 105,
  64, 32, 0, 112, 136, 248, 128, 136, 112, 2, 89, 105, 16, 32, 0, 112,
  136, 248, 128, 136, 112, 2, 89, 105, 48, 72, 0, 112, 136, 248, 128, 136,
  112, 2, 89, 105, 80, 80, 0, 112, 136, 248, 128, 136, 112, 18, 57, 105,
  128, 64, 0, 192, 64, 64, 64, 64, 224, 18, 57, 105, 32, 64, 0, 192,
  64, 64, 64, 64, 224, 18, 73, 105, 96, 144, 0, 192, 64, 64, 64, 64,
  224, 18, 57, 105, 160, 160, 0, 192, 64, 64, 64, 64, 224, 2, 90, 106,
  80, 32, 96, 16, 112, 136, 136, 136, 136, 112, 2, 89, 105, 40, 80, 0,
  176, 200, 136, 136, 136, 136, 2, 89, 105, 64, 32, 0, 112, 136, 136, 136,
  136, 112, 2, 89, 105, 16, 32, 0, 112, 136, 136, 136, 136, 112, 2, 89,
  105, 48, 72, 0, 112, 136, 136, 136, 136, 112, 2, 89, 105, 40, 80, 0,
  112, 136, 136, 136, 136, 112, 2, 89, 105, 80, 80, 0, 112, 136, 136, 136,
  136, 112, 3, 87, 103, 32, 32, 0, 248, 0, 32, 32, 1, 88, 104, 8,
  112, 152, 168, 168, 200, 112, 128, 2, 89, 105, 64, 32, 0, 136, 136, 136,
  136, 152, 104, 2, 89, 105, 16, 32, 0, 136, 136, 136, 136, 152, 104, 2,
  89, 105, 48, 72, 0, 136, 136, 136, 136, 152, 104, 2, 89, 105, 80, 80,
  0, 136, 136, 136, 136, 152, 104, 0, 91, 107, 16, 32, 0, 136, 136, 136,
  152, 104, 8, 136, 112, 0, 90, 106, 128, 128, 176, 200, 136, 136, 200, 176,
  128, 128, 0, 91, 107, 80, 80, 0, 136, 136, 136, 152, 104, 8, 136, 112
};

/*
  Fontname: -Misc-Fixed-Medium-O-SemiCondensed--13-120-75-75-C-60-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 6 h=11 x= 3 y=11 dx= 6 dy= 0 ascent=11 len=11
  Font Bounding box     w= 6 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent =10 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x13O[2162] U8G_FONT_SECTION("u8g_font_6x13O") = {
  1, 6, 13, 0, 254, 9, 1, 104, 2, 216, 32, 255, 254, 11, 254, 10,
  254, 13, 0, 96, 34, 41, 105, 64, 64, 64, 64, 128, 128, 128, 0, 128,
  40, 67, 99, 80, 80, 160, 3, 103, 103, 40, 40, 124, 40, 248, 80, 80,
  2, 105, 105, 16, 60, 80, 80, 56, 36, 40, 240, 32, 2, 105, 105, 36,
  84, 40, 8, 16, 32, 80, 168, 144, 2, 104, 104, 16, 40, 40, 48, 80,
  148, 152, 104, 56, 35, 99, 64, 64, 128, 17, 75, 107, 16, 32, 64, 64,
  128, 128, 128, 128, 64, 64, 32, 17, 75, 107, 64, 32, 32, 16, 16, 16,
  16, 32, 32, 64, 128, 3, 103, 103, 16, 84, 124, 56, 124, 168, 32, 20,
  69, 101, 32, 32, 240, 64, 64, 17, 51, 99, 96, 64, 128, 22, 65, 97,
  240, 17, 51, 99, 64, 224, 64, 2, 105, 105, 4, 4, 8, 16, 16, 32,
  64, 128, 128, 2, 105, 105, 16, 40, 68, 68, 68, 136, 136, 80, 32, 2,
  89, 105, 16, 48, 80, 16, 16, 32, 32, 32, 248, 2, 105, 105, 56, 68,
  68, 8, 16, 32, 64, 128, 248, 2, 105, 105, 124, 4, 8, 16, 56, 4,
  8, 136, 112, 2, 89, 105, 8, 8, 24, 40, 40, 72, 248, 16, 16, 2,
  105, 105, 124, 64, 64, 88, 100, 4, 8, 136, 112, 2, 105, 105, 56, 68,
  64, 64, 112, 136, 136, 136, 112, 18, 89, 105, 248, 8, 16, 16, 32, 64,
  64, 128, 128, 2, 105, 105, 56, 68, 68, 68, 120, 136, 136, 136, 112, 2,
  105, 105, 56, 68, 68, 68, 56, 8, 8, 136, 112, 17, 72, 104, 32, 112,
  32, 0, 0, 64, 224, 64, 17, 72, 104, 32, 112, 32, 0, 0, 96, 64,
  128, 18, 89, 105, 8, 16, 32, 64, 128, 64, 64, 32, 16, 4, 100, 100,
  124, 0, 0, 248, 2, 105, 105, 64, 32, 16, 8, 4, 8, 48, 64, 128,
  18, 89, 105, 112, 136, 136, 8, 16, 32, 64, 0, 64, 2, 105, 105, 56,
  68, 68, 88, 168, 168, 144, 128, 120, 2, 105, 105, 16, 40, 68, 68, 68,
  248, 136, 136, 136, 2, 105, 105, 120, 36, 36, 36, 56, 72, 72, 72, 240,
  2, 105, 105, 56, 68, 64, 64, 64, 128, 128, 136, 112, 2, 105, 105, 120,
  36, 36, 36, 36, 72, 72, 72, 240, 2, 105, 105, 124, 64, 64, 64, 120,
  128, 128, 128, 248, 2, 105, 105, 124, 64, 64, 64, 120, 128, 128, 128, 128,
  2, 105, 105, 56, 68, 64, 64, 64, 152, 136, 136, 112, 2, 105, 105, 68,
  68, 68, 68, 124, 136, 136, 136, 136, 18, 73, 105, 112, 32, 32, 32, 32,
  64, 64, 64, 224, 2, 105, 105, 28, 8, 8, 8, 8, 16, 16, 144, 96,
  2, 105, 105, 68, 68, 72, 80, 96, 160, 144, 136, 136, 2, 89, 105, 64,
  64, 64, 64, 64, 128, 128, 128, 248, 2, 105, 105, 68, 68, 108, 84, 84,
  136, 136, 136, 136, 2, 105, 105, 68, 100, 100, 84, 84, 152, 136, 136, 136,
  2, 105, 105, 56, 68, 68, 68, 68, 136, 136, 136, 112, 2, 105, 105, 120,
  68, 68, 68, 120, 128, 128, 128, 128, 1, 106, 106, 56, 68, 68, 68, 68,
  136, 136, 168, 112, 8, 2, 105, 105, 120, 68, 68, 68, 120, 144, 144, 136,
  136, 2, 105, 105, 56, 68, 64, 64, 48, 8, 8, 136, 112, 18, 89, 105,
  248, 32, 32, 32, 32, 64, 64, 64, 64, 2, 105, 105, 68, 68, 68, 68,
  68, 136, 136, 136, 112, 18, 89, 105, 136, 136, 136, 136, 144, 144, 160, 160,
  64, 2, 105, 105, 68, 68, 68, 68, 168, 168, 168, 168, 80, 2, 105, 105,
  68, 68, 40, 40, 16, 48, 72, 136, 136, 18, 89, 105, 136, 136, 80, 80,
  32, 32, 64, 64, 64, 2, 105, 105, 124, 4, 8, 8, 16, 32, 64, 128,
  248, 1, 91, 107, 56, 32, 32, 32, 64, 64, 64, 128, 128, 128, 224, 18,
  73, 105, 128, 128, 64, 64, 64, 32, 32, 16, 16, 1, 91, 107, 56, 8,
  8, 8, 16, 16, 16, 32, 32, 32, 224, 24, 83, 99, 32, 80, 136, 1,
  81, 97, 248, 58, 34, 98, 128, 64, 2, 102, 102, 56, 4, 124, 136, 152,
  104, 2, 105, 105, 64, 64, 64, 120, 68, 136, 136, 136, 240, 2, 102, 102,
  56, 68, 128, 128, 136, 112, 2, 105, 105, 4, 4, 4, 60, 68, 136, 136,
  136, 120, 2, 102, 102, 56, 68, 124, 128, 136, 112, 18, 89, 105, 48, 72,
  64, 64, 240, 64, 128, 128, 128, 0, 104, 104, 56, 68, 68, 136, 120, 8,
  136, 112, 2, 105, 105, 32, 32, 32, 88, 100, 68, 136, 136, 136, 18, 56,
  104, 32, 0, 96, 32, 32, 64, 64, 224, 0, 90, 106, 8, 0, 24, 8,
  8, 16, 16, 144, 144, 96, 2, 89, 105, 32, 32, 32, 72, 80, 96, 160,
  144, 136, 18, 73, 105, 48, 16, 16, 32, 32, 32, 64, 64, 224, 2, 102,
  102, 104, 84, 84, 168, 168, 136, 2, 102, 102, 88, 100, 68, 136, 136, 136,
  2, 102, 102, 56, 68, 68, 136, 136, 112, 0, 104, 104, 120, 68, 68, 136,
  240, 128, 128, 128, 0, 104, 104, 60, 68, 132, 136, 120, 8, 16, 16, 2,
  102, 102, 88, 100, 64, 128, 128, 128, 2, 102, 102, 56, 68, 32, 16, 136,
  112, 18, 72, 104, 32, 32, 240, 64, 64, 128, 144, 96, 2, 102, 102, 68,
  68, 136, 136, 152, 104, 18, 86, 102, 136, 136, 136, 144, 160, 64, 2, 102,
  102, 68, 68, 84, 168, 168, 80, 2, 102, 102, 68, 40, 16, 32, 80, 136,
  0, 104, 104, 68, 68, 136, 152, 104, 8, 144, 96, 2, 102, 102, 124, 8,
  16, 96, 128, 248, 1, 91, 107, 24, 32, 32, 32, 32, 192, 32, 64, 64,
  64, 48, 34, 41, 105, 64, 64, 64, 64, 64, 128, 128, 128, 128, 1, 107,
  107, 96, 16, 16, 16, 16, 12, 16, 32, 32, 32, 192, 24, 83, 99, 72,
  168, 144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 13, 0, 96, 34, 41, 105, 64, 0, 64, 64, 64, 128, 128,
  128, 128, 3, 104, 104, 16, 56, 84, 80, 160, 168, 112, 32, 2, 105, 105,
  24, 36, 32, 32, 112, 32, 64, 72, 176, 3, 102, 102, 68, 56, 40, 80,
  112, 136, 2, 105, 105, 68, 68, 40, 40, 124, 32, 248, 32, 32, 34, 41,
  105, 64, 64, 64, 64, 0, 128, 128, 128, 128, 18, 90, 106, 48, 72, 64,
  48, 72, 72, 48, 16, 144, 96, 58, 50, 98, 160, 160, 2, 105, 105, 56,
  68, 84, 108, 100, 216, 168, 136, 112, 4, 103, 103, 56, 4, 124, 136, 120,
  0, 248, 19, 86, 102, 40, 80, 160, 160, 160, 80, 20, 83, 99, 248, 8,
  16, 38, 49, 97, 224, 3, 105, 105, 56, 68, 116, 108, 108, 232, 216, 136,
  112, 26, 81, 97, 248, 23, 68, 100, 96, 144, 144, 96, 19, 71, 103, 32,
  32, 240, 64, 64, 0, 240, 23, 69, 101, 32, 80, 32, 64, 224, 23, 69,
  101, 96, 16, 96, 32, 192, 58, 34, 98, 64, 128, 0, 104, 104, 36, 36,
  68, 72, 88, 168, 128, 128, 18, 89, 105, 120, 232, 232, 232, 232, 80, 80,
  80, 80, 54, 33, 97, 192, 32, 34, 98, 64, 128, 23, 53, 101, 32, 96,
  64, 64, 224, 4, 103, 103, 56, 68, 68, 136, 112, 0, 248, 19, 86, 102,
  80, 40, 40, 40, 80, 160, 18, 90, 106, 32, 96, 64, 64, 224, 8, 56,
  80, 112, 16, 18, 90, 106, 32, 96, 64, 64, 224, 16, 40, 16, 32, 112,
  18, 90, 106, 96, 16, 96, 32, 192, 8, 56, 80, 112, 16, 2, 89, 105,
  16, 0, 16, 16, 32, 64, 136, 136, 112, 2, 106, 106, 32, 16, 0, 16,
  40, 68, 68, 248, 136, 136, 2, 106, 106, 8, 16, 0, 16, 40, 68, 68,
  248, 136, 136, 2, 106, 106, 24, 36, 0, 16, 40, 68, 68, 248, 136, 136,
  2, 106, 106, 20, 40, 0, 16, 40, 68, 68, 248, 136, 136, 2, 106, 106,
  40, 40, 0, 16, 40, 68, 68, 248, 136, 136, 2, 106, 106, 16, 40, 16,
  16, 40, 68, 68, 248, 136, 136, 2, 105, 105, 44, 80, 80, 80, 88, 224,
  160, 160, 184, 0, 107, 107, 56, 68, 64, 64, 64, 128, 128, 136, 112, 32,
  64, 2, 106, 106, 32, 16, 0, 124, 64, 64, 120, 128, 128, 248, 2, 106,
  106, 8, 16, 0, 124, 64, 64, 120, 128, 128, 248, 2, 106, 106, 24, 36,
  0, 124, 64, 64, 120, 128, 128, 248, 2, 106, 106, 40, 40, 0, 124, 64,
  64, 120, 128, 128, 248, 18, 74, 106, 64, 32, 0, 112, 32, 32, 32, 64,
  64, 224, 18, 74, 106, 16, 32, 0, 112, 32, 32, 32, 64, 64, 224, 18,
  90, 106, 48, 72, 0, 112, 32, 32, 32, 64, 64, 224, 18, 74, 106, 80,
  80, 0, 112, 32, 32, 32, 64, 64, 224, 2, 105, 105, 120, 36, 36, 36,
  116, 36, 72, 72, 240, 2, 106, 106, 20, 40, 0, 68, 68, 100, 88, 136,
  136, 136, 2, 106, 106, 32, 16, 0, 56, 68, 68, 68, 136, 136, 112, 2,
  106, 106, 8, 16, 0, 56, 68, 68, 68, 136, 136, 112, 2, 106, 106, 24,
  36, 0, 56, 68, 68, 68, 136, 136, 112, 2, 106, 106, 20, 40, 0, 56,
  68, 68, 68, 136, 136, 112, 2, 106, 106, 40, 40, 0, 56, 68, 68, 68,
  136, 136, 112, 3, 101, 101, 68, 40, 48, 80, 136, 1, 107, 107, 4, 60,
  76, 76, 84, 84, 168, 232, 232, 112, 128, 2, 106, 106, 32, 16, 0, 68,
  68, 68, 136, 136, 136, 112, 2, 106, 106, 8, 16, 0, 68, 68, 68, 136,
  136, 136, 112, 2, 106, 106, 24, 36, 0, 68, 68, 68, 136, 136, 136, 112,
  2, 106, 106, 40, 40, 0, 68, 68, 68, 136, 136, 136, 112, 18, 90, 106,
  16, 32, 0, 136, 136, 80, 32, 64, 64, 64, 2, 105, 105, 64, 120, 68,
  68, 72, 240, 128, 128, 128, 2, 89, 105, 48, 72, 72, 80, 80, 144, 136,
  136, 176, 2, 105, 105, 32, 16, 0, 56, 4, 124, 136, 152, 104, 2, 105,
  105, 8, 16, 0, 56, 4, 124, 136, 152, 104, 2, 105, 105, 24, 36, 0,
  56, 4, 124, 136, 152, 104, 2, 105, 105, 20, 40, 0, 56, 4, 124, 136,
  152, 104, 2, 105, 105, 40, 40, 0, 56, 4, 124, 136, 152, 104, 2, 106,
  106, 24, 36, 24, 0, 56, 4, 124, 136, 152, 104, 2, 102, 102, 56, 20,
  120, 160, 168, 80, 0, 104, 104, 56, 68, 64, 128, 136, 112, 32, 64, 2,
  105, 105, 32, 16, 0, 56, 68, 124, 128, 136, 112, 2, 105, 105, 8, 16,
  0, 56, 68, 124, 128, 136, 112, 2, 105, 105, 24, 36, 0, 56, 68, 124,
  128, 136, 112, 2, 105, 105, 40, 40, 0, 56, 68, 124, 128, 136, 112, 18,
  57, 105, 64, 32, 0, 96, 32, 32, 64, 64, 224, 18, 73, 105, 16, 32,
  0, 96, 32, 32, 64, 64, 224, 18, 89, 105, 48, 72, 0, 96, 32, 32,
  64, 64, 224, 18, 73, 105, 80, 80, 0, 96, 32, 32, 64, 64, 224, 2,
  106, 106, 32, 24, 48, 8, 56, 68, 68, 136, 136, 112, 2, 105, 105, 20,
  40, 0, 88, 100, 68, 136, 136, 136, 2, 105, 105, 32, 16, 0, 56, 68,
  68, 136, 136, 112, 2, 105, 105, 8, 16, 0, 56, 68, 68, 136, 136, 112,
  2, 105, 105, 24, 36, 0, 56, 68, 68, 136, 136, 112, 2, 105, 105, 20,
  40, 0, 56, 68, 68, 136, 136, 112, 2, 105, 105, 40, 40, 0, 56, 68,
  68, 136, 136, 112, 19, 87, 103, 32, 32, 0, 248, 0, 64, 64, 1, 104,
  104, 4, 56, 76, 84, 168, 200, 112, 128, 2, 105, 105, 32, 16, 0, 68,
  68, 68, 136, 152, 104, 2, 105, 105, 8, 16, 0, 68, 68, 68, 136, 152,
  104, 2, 105, 105, 24, 36, 0, 68, 68, 68, 136, 152, 104, 2, 105, 105,
  40, 40, 0, 68, 68, 68, 136, 152, 104, 0, 107, 107, 8, 16, 0, 68,
  68, 136, 152, 104, 8, 144, 96, 0, 106, 106, 64, 64, 88, 100, 68, 136,
  200, 176, 128, 128, 0, 107, 107, 40, 40, 0, 68, 68, 136, 152, 104, 8,
  144, 96
};

/*
  Fontname: -Misc-Fixed-Medium-O-SemiCondensed--13-120-75-75-C-60-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 6 h=11 x= 3 y=11 dx= 6 dy= 0 ascent=11 len=11
  Font Bounding box     w= 6 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent =10 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x13Or[1043] U8G_FONT_SECTION("u8g_font_6x13Or") = {
  1, 6, 13, 0, 254, 9, 1, 104, 2, 216, 32, 127, 254, 11, 254, 10,
  254, 13, 0, 96, 34, 41, 105, 64, 64, 64, 64, 128, 128, 128, 0, 128,
  40, 67, 99, 80, 80, 160, 3, 103, 103, 40, 40, 124, 40, 248, 80, 80,
  2, 105, 105, 16, 60, 80, 80, 56, 36, 40, 240, 32, 2, 105, 105, 36,
  84, 40, 8, 16, 32, 80, 168, 144, 2, 104, 104, 16, 40, 40, 48, 80,
  148, 152, 104, 56, 35, 99, 64, 64, 128, 17, 75, 107, 16, 32, 64, 64,
  128, 128, 128, 128, 64, 64, 32, 17, 75, 107, 64, 32, 32, 16, 16, 16,
  16, 32, 32, 64, 128, 3, 103, 103, 16, 84, 124, 56, 124, 168, 32, 20,
  69, 101, 32, 32, 240, 64, 64, 17, 51, 99, 96, 64, 128, 22, 65, 97,
  240, 17, 51, 99, 64, 224, 64, 2, 105, 105, 4, 4, 8, 16, 16, 32,
  64, 128, 128, 2, 105, 105, 16, 40, 68, 68, 68, 136, 136, 80, 32, 2,
  89, 105, 16, 48, 80, 16, 16, 32, 32, 32, 248, 2, 105, 105, 56, 68,
  68, 8, 16, 32, 64, 128, 248, 2, 105, 105, 124, 4, 8, 16, 56, 4,
  8, 136, 112, 2, 89, 105, 8, 8, 24, 40, 40, 72, 248, 16, 16, 2,
  105, 105, 124, 64, 64, 88, 100, 4, 8, 136, 112, 2, 105, 105, 56, 68,
  64, 64, 112, 136, 136, 136, 112, 18, 89, 105, 248, 8, 16, 16, 32, 64,
  64, 128, 128, 2, 105, 105, 56, 68, 68, 68, 120, 136, 136, 136, 112, 2,
  105, 105, 56, 68, 68, 68, 56, 8, 8, 136, 112, 17, 72, 104, 32, 112,
  32, 0, 0, 64, 224, 64, 17, 72, 104, 32, 112, 32, 0, 0, 96, 64,
  128, 18, 89, 105, 8, 16, 32, 64, 128, 64, 64, 32, 16, 4, 100, 100,
  124, 0, 0, 248, 2, 105, 105, 64, 32, 16, 8, 4, 8, 48, 64, 128,
  18, 89, 105, 112, 136, 136, 8, 16, 32, 64, 0, 64, 2, 105, 105, 56,
  68, 68, 88, 168, 168, 144, 128, 120, 2, 105, 105, 16, 40, 68, 68, 68,
  248, 136, 136, 136, 2, 105, 105, 120, 36, 36, 36, 56, 72, 72, 72, 240,
  2, 105, 105, 56, 68, 64, 64, 64, 128, 128, 136, 112, 2, 105, 105, 120,
  36, 36, 36, 36, 72, 72, 72, 240, 2, 105, 105, 124, 64, 64, 64, 120,
  128, 128, 128, 248, 2, 105, 105, 124, 64, 64, 64, 120, 128, 128, 128, 128,
  2, 105, 105, 56, 68, 64, 64, 64, 152, 136, 136, 112, 2, 105, 105, 68,
  68, 68, 68, 124, 136, 136, 136, 136, 18, 73, 105, 112, 32, 32, 32, 32,
  64, 64, 64, 224, 2, 105, 105, 28, 8, 8, 8, 8, 16, 16, 144, 96,
  2, 105, 105, 68, 68, 72, 80, 96, 160, 144, 136, 136, 2, 89, 105, 64,
  64, 64, 64, 64, 128, 128, 128, 248, 2, 105, 105, 68, 68, 108, 84, 84,
  136, 136, 136, 136, 2, 105, 105, 68, 100, 100, 84, 84, 152, 136, 136, 136,
  2, 105, 105, 56, 68, 68, 68, 68, 136, 136, 136, 112, 2, 105, 105, 120,
  68, 68, 68, 120, 128, 128, 128, 128, 1, 106, 106, 56, 68, 68, 68, 68,
  136, 136, 168, 112, 8, 2, 105, 105, 120, 68, 68, 68, 120, 144, 144, 136,
  136, 2, 105, 105, 56, 68, 64, 64, 48, 8, 8, 136, 112, 18, 89, 105,
  248, 32, 32, 32, 32, 64, 64, 64, 64, 2, 105, 105, 68, 68, 68, 68,
  68, 136, 136, 136, 112, 18, 89, 105, 136, 136, 136, 136, 144, 144, 160, 160,
  64, 2, 105, 105, 68, 68, 68, 68, 168, 168, 168, 168, 80, 2, 105, 105,
  68, 68, 40, 40, 16, 48, 72, 136, 136, 18, 89, 105, 136, 136, 80, 80,
  32, 32, 64, 64, 64, 2, 105, 105, 124, 4, 8, 8, 16, 32, 64, 128,
  248, 1, 91, 107, 56, 32, 32, 32, 64, 64, 64, 128, 128, 128, 224, 18,
  73, 105, 128, 128, 64, 64, 64, 32, 32, 16, 16, 1, 91, 107, 56, 8,
  8, 8, 16, 16, 16, 32, 32, 32, 224, 24, 83, 99, 32, 80, 136, 1,
  81, 97, 248, 58, 34, 98, 128, 64, 2, 102, 102, 56, 4, 124, 136, 152,
  104, 2, 105, 105, 64, 64, 64, 120, 68, 136, 136, 136, 240, 2, 102, 102,
  56, 68, 128, 128, 136, 112, 2, 105, 105, 4, 4, 4, 60, 68, 136, 136,
  136, 120, 2, 102, 102, 56, 68, 124, 128, 136, 112, 18, 89, 105, 48, 72,
  64, 64, 240, 64, 128, 128, 128, 0, 104, 104, 56, 68, 68, 136, 120, 8,
  136, 112, 2, 105, 105, 32, 32, 32, 88, 100, 68, 136, 136, 136, 18, 56,
  104, 32, 0, 96, 32, 32, 64, 64, 224, 0, 90, 106, 8, 0, 24, 8,
  8, 16, 16, 144, 144, 96, 2, 89, 105, 32, 32, 32, 72, 80, 96, 160,
  144, 136, 18, 73, 105, 48, 16, 16, 32, 32, 32, 64, 64, 224, 2, 102,
  102, 104, 84, 84, 168, 168, 136, 2, 102, 102, 88, 100, 68, 136, 136, 136,
  2, 102, 102, 56, 68, 68, 136, 136, 112, 0, 104, 104, 120, 68, 68, 136,
  240, 128, 128, 128, 0, 104, 104, 60, 68, 132, 136, 120, 8, 16, 16, 2,
  102, 102, 88, 100, 64, 128, 128, 128, 2, 102, 102, 56, 68, 32, 16, 136,
  112, 18, 72, 104, 32, 32, 240, 64, 64, 128, 144, 96, 2, 102, 102, 68,
  68, 136, 136, 152, 104, 18, 86, 102, 136, 136, 136, 144, 160, 64, 2, 102,
  102, 68, 68, 84, 168, 168, 80, 2, 102, 102, 68, 40, 16, 32, 80, 136,
  0, 104, 104, 68, 68, 136, 152, 104, 8, 144, 96, 2, 102, 102, 124, 8,
  16, 96, 128, 248, 1, 91, 107, 24, 32, 32, 32, 32, 192, 32, 64, 64,
  64, 48, 34, 41, 105, 64, 64, 64, 64, 64, 128, 128, 128, 128, 1, 107,
  107, 96, 16, 16, 16, 16, 12, 16, 32, 32, 32, 192, 24, 83, 99, 72,
  168, 144, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-SemiCondensed--13-120-75-75-C-60-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 5 h=11 x= 2 y=11 dx= 6 dy= 0 ascent=11 len=11
  Font Bounding box     w= 6 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent =10 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_6x13r[1041] U8G_FONT_SECTION("u8g_font_6x13r") = {
  1, 6, 13, 0, 254, 9, 1, 102, 2, 214, 32, 127, 254, 11, 254, 10,
  254, 13, 0, 96, 34, 25, 105, 128, 128, 128, 128, 128, 128, 128, 0, 128,
  24, 51, 99, 160, 160, 160, 3, 87, 103, 80, 80, 248, 80, 248, 80, 80,
  2, 89, 105, 32, 120, 160, 160, 112, 40, 40, 240, 32, 2, 89, 105, 72,
  168, 80, 16, 32, 64, 80, 168, 144, 2, 88, 104, 64, 160, 160, 64, 160,
  152, 144, 104, 40, 19, 99, 128, 128, 128, 17, 59, 107, 32, 64, 64, 128,
  128, 128, 128, 128, 64, 64, 32, 17, 59, 107, 128, 64, 64, 32, 32, 32,
  32, 32, 64, 64, 128, 6, 85, 101, 32, 168, 112, 168, 32, 4, 85, 101,
  32, 32, 248, 32, 32, 17, 51, 99, 96, 64, 128, 6, 81, 97, 248, 17,
  51, 99, 64, 224, 64, 2, 89, 105, 8, 8, 16, 16, 32, 64, 64, 128,
  128, 2, 89, 105, 32, 80, 136, 136, 136, 136, 136, 80, 32, 2, 89, 105,
  32, 96, 160, 32, 32, 32, 32, 32, 248, 2, 89, 105, 112, 136, 136, 8,
  16, 32, 64, 128, 248, 2, 89, 105, 248, 8, 16, 32, 112, 8, 8, 136,
  112, 2, 89, 105, 16, 16, 48, 80, 80, 144, 248, 16, 16, 2, 89, 105,
  248, 128, 128, 176, 200, 8, 8, 136, 112, 2, 89, 105, 112, 136, 128, 128,
  240, 136, 136, 136, 112, 2, 89, 105, 248, 8, 16, 16, 32, 32, 64, 64,
  64, 2, 89, 105, 112, 136, 136, 136, 112, 136, 136, 136, 112, 2, 89, 105,
  112, 136, 136, 136, 120, 8, 8, 136, 112, 17, 56, 104, 64, 224, 64, 0,
  0, 64, 224, 64, 17, 56, 104, 64, 224, 64, 0, 0, 96, 64, 128, 2,
  89, 105, 8, 16, 32, 64, 128, 64, 32, 16, 8, 4, 84, 100, 248, 0,
  0, 248, 2, 89, 105, 128, 64, 32, 16, 8, 16, 32, 64, 128, 2, 89,
  105, 112, 136, 136, 8, 16, 32, 32, 0, 32, 2, 89, 105, 112, 136, 136,
  152, 168, 168, 176, 128, 120, 2, 89, 105, 32, 80, 136, 136, 136, 248, 136,
  136, 136, 2, 89, 105, 240, 72, 72, 72, 112, 72, 72, 72, 240, 2, 89,
  105, 112, 136, 128, 128, 128, 128, 128, 136, 112, 2, 89, 105, 240, 72, 72,
  72, 72, 72, 72, 72, 240, 2, 89, 105, 248, 128, 128, 128, 240, 128, 128,
  128, 248, 2, 89, 105, 248, 128, 128, 128, 240, 128, 128, 128, 128, 2, 89,
  105, 112, 136, 128, 128, 128, 152, 136, 136, 112, 2, 89, 105, 136, 136, 136,
  136, 248, 136, 136, 136, 136, 18, 57, 105, 224, 64, 64, 64, 64, 64, 64,
  64, 224, 2, 89, 105, 56, 16, 16, 16, 16, 16, 16, 144, 96, 2, 89,
  105, 136, 136, 144, 160, 192, 160, 144, 136, 136, 2, 89, 105, 128, 128, 128,
  128, 128, 128, 128, 128, 248, 2, 89, 105, 136, 136, 216, 168, 168, 136, 136,
  136, 136, 2, 89, 105, 136, 200, 200, 168, 168, 152, 152, 136, 136, 2, 89,
  105, 112, 136, 136, 136, 136, 136, 136, 136, 112, 2, 89, 105, 240, 136, 136,
  136, 240, 128, 128, 128, 128, 1, 90, 106, 112, 136, 136, 136, 136, 136, 136,
  168, 112, 8, 2, 89, 105, 240, 136, 136, 136, 240, 160, 144, 136, 136, 2,
  89, 105, 112, 136, 128, 128, 112, 8, 8, 136, 112, 2, 89, 105, 248, 32,
  32, 32, 32, 32, 32, 32, 32, 2, 89, 105, 136, 136, 136, 136, 136, 136,
  136, 136, 112, 2, 89, 105, 136, 136, 136, 136, 80, 80, 80, 32, 32, 2,
  89, 105, 136, 136, 136, 136, 168, 168, 168, 168, 80, 2, 89, 105, 136, 136,
  80, 80, 32, 80, 80, 136, 136, 2, 89, 105, 136, 136, 80, 80, 32, 32,
  32, 32, 32, 2, 89, 105, 248, 8, 16, 16, 32, 64, 64, 128, 248, 17,
  59, 107, 224, 128, 128, 128, 128, 128, 128, 128, 128, 128, 224, 2, 89, 105,
  128, 128, 64, 64, 32, 16, 16, 8, 8, 17, 59, 107, 224, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 224, 8, 83, 99, 32, 80, 136, 1, 81, 97,
  248, 42, 34, 98, 128, 64, 2, 86, 102, 112, 8, 120, 136, 152, 104, 2,
  89, 105, 128, 128, 128, 240, 136, 136, 136, 136, 240, 2, 86, 102, 112, 136,
  128, 128, 136, 112, 2, 89, 105, 8, 8, 8, 120, 136, 136, 136, 136, 120,
  2, 86, 102, 112, 136, 248, 128, 136, 112, 2, 89, 105, 48, 72, 64, 64,
  240, 64, 64, 64, 64, 0, 88, 104, 112, 136, 136, 136, 120, 8, 136, 112,
  2, 89, 105, 128, 128, 128, 176, 200, 136, 136, 136, 136, 18, 56, 104, 64,
  0, 192, 64, 64, 64, 64, 224, 0, 74, 106, 16, 0, 48, 16, 16, 16,
  16, 144, 144, 96, 2, 89, 105, 128, 128, 128, 144, 160, 192, 160, 144, 136,
  18, 57, 105, 192, 64, 64, 64, 64, 64, 64, 64, 224, 2, 86, 102, 208,
  168, 168, 168, 168, 136, 2, 86, 102, 176, 200, 136, 136, 136, 136, 2, 86,
  102, 112, 136, 136, 136, 136, 112, 0, 88, 104, 240, 136, 136, 136, 240, 128,
  128, 128, 0, 88, 104, 120, 136, 136, 136, 120, 8, 8, 8, 2, 86, 102,
  176, 200, 128, 128, 128, 128, 2, 86, 102, 112, 136, 96, 16, 136, 112, 2,
  88, 104, 64, 64, 240, 64, 64, 64, 72, 48, 2, 86, 102, 136, 136, 136,
  136, 152, 104, 2, 86, 102, 136, 136, 136, 80, 80, 32, 2, 86, 102, 136,
  136, 168, 168, 168, 80, 2, 86, 102, 136, 80, 32, 32, 80, 136, 0, 88,
  104, 136, 136, 136, 152, 104, 8, 136, 112, 2, 86, 102, 248, 16, 32, 64,
  128, 248, 1, 91, 107, 24, 32, 32, 32, 32, 192, 32, 32, 32, 32, 24,
  34, 25, 105, 128, 128, 128, 128, 128, 128, 128, 128, 128, 1, 91, 107, 192,
  32, 32, 32, 32, 24, 32, 32, 32, 32, 192, 8, 83, 99, 72, 168, 144,
  255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--13-120-75-75-C-70-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 3, '1' Height: 10
  Calculated Max Values w= 7 h=13 x= 6 y= 9 dx= 7 dy= 0 ascent=11 len=13
  Font Bounding box     w= 7 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 3 descent= 0
  X Font      ascent =10 descent= 0
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_7x13_67_75[2197] U8G_FONT_SECTION("u8g_font_7x13_67_75") = {
  1, 7, 13, 0, 254, 3, 1, 91, 2, 178, 32, 255, 0, 11, 254, 10,
  0, 4, 117, 117, 72, 36, 254, 36, 72, 18, 89, 121, 32, 32, 32, 168,
  112, 32, 168, 112, 32, 4, 101, 117, 36, 72, 248, 72, 36, 4, 101, 117,
  144, 72, 124, 72, 144, 4, 101, 117, 36, 68, 252, 68, 36, 18, 89, 121,
  32, 112, 168, 32, 32, 32, 32, 32, 248, 4, 101, 117, 144, 136, 252, 136,
  144, 18, 89, 121, 248, 32, 32, 32, 32, 32, 168, 112, 32, 18, 89, 121,
  32, 112, 168, 32, 32, 168, 112, 32, 248, 4, 117, 117, 36, 66, 252, 64,
  32, 4, 117, 117, 72, 132, 126, 4, 8, 4, 117, 117, 36, 74, 252, 72,
  40, 4, 117, 117, 72, 164, 126, 36, 40, 4, 117, 117, 40, 84, 238, 68,
  40, 4, 117, 117, 40, 84, 254, 84, 40, 2, 106, 122, 64, 64, 128, 152,
  104, 8, 16, 84, 56, 16, 2, 106, 122, 32, 64, 252, 68, 36, 4, 4,
  4, 4, 4, 2, 106, 122, 16, 8, 252, 136, 144, 128, 128, 128, 128, 128,
  2, 106, 122, 4, 4, 4, 4, 4, 36, 68, 252, 64, 32, 2, 106, 122,
  128, 128, 128, 128, 128, 144, 136, 252, 8, 16, 2, 104, 120, 240, 16, 16,
  16, 16, 84, 56, 16, 2, 90, 122, 8, 8, 8, 8, 8, 40, 72, 248,
  64, 32, 4, 119, 119, 28, 34, 34, 34, 170, 112, 32, 4, 119, 119, 112,
  136, 136, 136, 170, 28, 8, 2, 120, 120, 254, 0, 224, 192, 160, 16, 8,
  4, 2, 121, 121, 144, 160, 254, 160, 146, 10, 254, 10, 18, 4, 119, 119,
  72, 156, 170, 136, 136, 136, 112, 4, 119, 119, 36, 114, 170, 34, 34, 34,
  28, 6, 99, 115, 32, 64, 252, 4, 99, 115, 252, 64, 32, 50, 57, 121,
  128, 192, 160, 128, 128, 128, 128, 128, 128, 18, 57, 121, 32, 96, 160, 32,
  32, 32, 32, 32, 32, 6, 99, 115, 16, 8, 252, 4, 99, 115, 252, 8,
  16, 50, 57, 121, 128, 128, 128, 128, 128, 128, 160, 192, 128, 18, 57, 121,
  32, 32, 32, 32, 32, 32, 160, 96, 32, 2, 105, 121, 16, 8, 252, 8,
  48, 64, 252, 64, 32, 2, 122, 122, 40, 120, 168, 40, 40, 40, 40, 42,
  60, 40, 2, 105, 121, 32, 64, 252, 64, 48, 8, 252, 8, 16, 2, 105,
  121, 32, 64, 252, 64, 32, 64, 252, 64, 32, 2, 121, 121, 68, 238, 68,
  68, 68, 68, 68, 68, 68, 2, 105, 121, 16, 8, 252, 8, 16, 8, 252,
  8, 16, 2, 122, 122, 68, 68, 68, 68, 68, 68, 68, 68, 238, 68, 3,
  103, 119, 32, 64, 252, 0, 252, 8, 16, 3, 103, 119, 16, 8, 252, 0,
  252, 64, 32, 3, 119, 119, 16, 34, 126, 132, 126, 40, 16, 4, 117, 117,
  40, 124, 146, 124, 40, 3, 119, 119, 16, 40, 252, 66, 252, 136, 16, 3,
  119, 119, 16, 32, 126, 128, 126, 32, 16, 2, 121, 121, 16, 40, 108, 170,
  40, 40, 40, 40, 40, 3, 119, 119, 16, 8, 252, 2, 252, 8, 16, 2,
  121, 121, 40, 40, 40, 40, 40, 170, 108, 40, 16, 4, 117, 117, 40, 124,
  130, 124, 40, 2, 122, 122, 16, 40, 108, 170, 40, 40, 170, 108, 40, 16,
  2, 119, 119, 252, 144, 136, 196, 162, 144, 8, 2, 119, 119, 126, 18, 34,
  70, 138, 18, 32, 2, 119, 119, 32, 18, 138, 70, 34, 18, 126, 2, 119,
  119, 8, 144, 162, 196, 136, 144, 252, 2, 121, 121, 8, 16, 62, 64, 254,
  64, 62, 16, 8, 2, 121, 121, 32, 16, 248, 4, 254, 4, 248, 16, 32,
  4, 117, 117, 32, 72, 254, 68, 32, 4, 117, 117, 8, 36, 254, 68, 8,
  18, 89, 121, 32, 112, 168, 32, 248, 32, 248, 32, 32, 18, 89, 121, 32,
  32, 248, 32, 248, 32, 168, 112, 32, 3, 119, 119, 16, 32, 64, 182, 64,
  32, 16, 2, 122, 122, 16, 40, 84, 146, 0, 16, 16, 0, 16, 16, 3,
  119, 119, 16, 8, 4, 218, 4, 8, 16, 2, 122, 122, 16, 16, 0, 16,
  16, 0, 146, 84, 40, 16, 4, 117, 117, 144, 160, 254, 160, 144, 4, 117,
  117, 18, 10, 254, 10, 18, 3, 119, 119, 16, 48, 94, 130, 94, 48, 16,
  2, 121, 121, 16, 40, 68, 238, 40, 40, 40, 40, 56, 3, 119, 119, 16,
  24, 244, 130, 244, 24, 16, 2, 121, 121, 56, 40, 40, 40, 40, 238, 68,
  40, 16, 1, 124, 124, 16, 40, 68, 238, 40, 40, 40, 56, 0, 56, 40,
  56, 1, 122, 122, 16, 40, 68, 238, 40, 40, 40, 108, 68, 124, 1, 122,
  122, 16, 40, 68, 254, 40, 40, 40, 108, 68, 124, 1, 122, 122, 16, 40,
  68, 254, 56, 56, 56, 124, 68, 124, 2, 121, 121, 16, 40, 68, 238, 68,
  238, 40, 40, 56, 1, 122, 122, 16, 40, 68, 238, 68, 238, 40, 108, 68,
  124, 3, 119, 119, 144, 152, 244, 130, 244, 152, 144, 2, 119, 119, 254, 128,
  188, 176, 168, 164, 130, 2, 119, 119, 130, 74, 42, 26, 122, 2, 254, 2,
  121, 121, 16, 40, 68, 238, 40, 238, 68, 40, 16, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 7, 118, 118, 254, 254, 254, 254, 254, 254,
  0, 114, 114, 254, 254, 0, 115, 115, 254, 254, 254, 0, 117, 117, 254, 254,
  254, 254, 254, 0, 119, 119, 254, 254, 254, 254, 254, 254, 254, 0, 120, 120,
  254, 254, 254, 254, 254, 254, 254, 254, 0, 122, 122, 254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 0, 123, 123, 254, 254, 254, 254, 254, 254, 254, 254,
  254, 254, 254, 0, 125, 125, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254,
  254, 254, 254, 0, 109, 125, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252,
  252, 252, 252, 0, 93, 125, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
  248, 248, 248, 0, 77, 125, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 0, 77, 125, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 0, 61, 125, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 0, 45, 125, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 0, 29, 125, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 64, 61, 125, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 1, 123, 123, 84, 0, 170, 0, 84, 0, 170, 0, 84, 0,
  170, 0, 125, 125, 170, 84, 170, 84, 170, 84, 170, 84, 170, 84, 170, 84,
  170, 0, 125, 125, 254, 84, 254, 170, 254, 84, 254, 170, 254, 84, 254, 170,
  254, 11, 114, 114, 254, 254, 96, 29, 125, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 0, 71, 119, 240, 240, 240, 240, 240, 240, 240,
  64, 55, 119, 224, 224, 224, 224, 224, 224, 224, 7, 70, 118, 240, 240, 240,
  240, 240, 240, 0, 125, 125, 240, 240, 240, 240, 240, 240, 254, 254, 254, 254,
  254, 254, 254, 0, 125, 125, 240, 240, 240, 240, 240, 240, 14, 14, 14, 14,
  14, 14, 14, 0, 125, 125, 254, 254, 254, 254, 254, 254, 240, 240, 240, 240,
  240, 240, 240, 0, 125, 125, 254, 254, 254, 254, 254, 254, 14, 14, 14, 14,
  14, 14, 14, 71, 54, 118, 224, 224, 224, 224, 224, 224, 0, 125, 125, 14,
  14, 14, 14, 14, 14, 240, 240, 240, 240, 240, 240, 240, 0, 125, 125, 14,
  14, 14, 14, 14, 14, 254, 254, 254, 254, 254, 254, 254, 3, 119, 119, 254,
  254, 254, 254, 254, 254, 254, 3, 119, 119, 254, 130, 130, 130, 130, 130, 254,
  3, 119, 119, 124, 130, 130, 130, 130, 130, 124, 3, 119, 119, 254, 130, 186,
  186, 186, 130, 254, 3, 119, 119, 254, 130, 254, 130, 254, 130, 254, 3, 119,
  119, 254, 170, 170, 170, 170, 170, 254, 3, 119, 119, 254, 170, 254, 170, 254,
  170, 254, 3, 119, 119, 254, 146, 138, 198, 162, 146, 254, 3, 119, 119, 254,
  146, 162, 198, 138, 146, 254, 3, 119, 119, 254, 214, 170, 214, 170, 214, 254,
  20, 85, 117, 248, 248, 248, 248, 248, 20, 85, 117, 248, 136, 136, 136, 248,
  4, 117, 117, 254, 254, 254, 254, 254, 4, 117, 117, 254, 130, 130, 130, 254,
  19, 87, 119, 248, 248, 248, 248, 248, 248, 248, 19, 87, 119, 248, 136, 136,
  136, 136, 136, 248, 4, 117, 117, 62, 126, 254, 252, 248, 4, 117, 117, 62,
  66, 130, 132, 248, 2, 120, 120, 16, 16, 56, 56, 124, 124, 254, 254, 2,
  120, 120, 16, 16, 40, 40, 68, 68, 130, 254, 19, 86, 118, 32, 32, 112,
  112, 248, 248, 19, 86, 118, 32, 32, 80, 80, 136, 248, 3, 119, 119, 128,
  224, 248, 254, 248, 224, 128, 3, 119, 119, 128, 224, 152, 134, 152, 224, 128,
  4, 101, 117, 192, 240, 252, 240, 192, 4, 101, 117, 192, 176, 140, 176, 192,
  4, 117, 117, 128, 240, 254, 240, 128, 4, 117, 117, 128, 240, 142, 240, 128,
  2, 120, 120, 254, 254, 124, 124, 56, 56, 16, 16, 2, 120, 120, 254, 130,
  68, 68, 40, 40, 16, 16, 19, 86, 118, 248, 248, 112, 112, 32, 32, 19,
  86, 118, 248, 136, 80, 80, 32, 32, 3, 119, 119, 2, 14, 62, 254, 62,
  14, 2, 3, 119, 119, 2, 14, 50, 194, 50, 14, 2, 4, 101, 117, 12,
  60, 252, 60, 12, 4, 101, 117, 12, 52, 196, 52, 12, 4, 117, 117, 2,
  30, 254, 30, 2, 4, 117, 117, 2, 30, 226, 30, 2, 2, 119, 119, 16,
  56, 124, 254, 124, 56, 16, 2, 119, 119, 16, 40, 68, 130, 68, 40, 16,
  2, 119, 119, 16, 40, 84, 186, 84, 40, 16, 3, 119, 119, 56, 68, 146,
  186, 146, 68, 56, 18, 89, 121, 32, 32, 80, 80, 136, 80, 80, 32, 32,
  3, 119, 119, 56, 68, 130, 130, 130, 68, 56, 3, 119, 119, 40, 0, 130,
  0, 130, 0, 40, 3, 119, 119, 56, 108, 170, 170, 170, 108, 56, 3, 119,
  119, 56, 68, 146, 170, 146, 68, 56, 3, 119, 119, 56, 124, 254, 254, 254,
  124, 56, 3, 119, 119, 56, 116, 242, 242, 242, 116, 56, 3, 119, 119, 56,
  92, 158, 158, 158, 92, 56, 3, 119, 119, 56, 68, 130, 254, 254, 124, 56,
  3, 119, 119, 56, 124, 254, 254, 130, 68, 56, 3, 119, 119, 56, 92, 158,
  158, 130, 68, 56, 3, 119, 119, 56, 76, 142, 142, 254, 124, 56, 51, 71,
  119, 192, 224, 240, 240, 240, 224, 192, 3, 71, 119, 48, 112, 240, 240, 240,
  112, 48, 0, 125, 125, 254, 254, 254, 254, 198, 130, 130, 130, 198, 254, 254,
  254, 254, 0, 125, 125, 254, 254, 254, 254, 198, 186, 186, 186, 198, 254, 254,
  254, 254, 6, 119, 119, 254, 254, 254, 254, 198, 186, 186, 0, 119, 119, 186,
  186, 198, 254, 254, 254, 254, 6, 68, 116, 48, 64, 128, 128, 54, 68, 116,
  192, 32, 16, 16, 51, 68, 116, 16, 16, 32, 192, 3, 68, 116, 128, 128,
  64, 48, 6, 116, 116, 56, 68, 130, 130, 3, 116, 116, 130, 130, 68, 56,
  3, 119, 119, 2, 6, 14, 30, 62, 126, 254, 3, 119, 119, 128, 192, 224,
  240, 248, 252, 254, 3, 119, 119, 254, 252, 248, 240, 224, 192, 128, 3, 119,
  119, 254, 126, 62, 30, 14, 6, 2, 20, 85, 117, 112, 136, 136, 136, 112,
  3, 119, 119, 254, 226, 226, 226, 226, 226, 254, 3, 119, 119, 254, 142, 142,
  142, 142, 142, 254, 3, 119, 119, 254, 254, 250, 242, 226, 194, 254, 3, 119,
  119, 254, 134, 142, 158, 190, 254, 254, 3, 119, 119, 254, 146, 146, 146, 146,
  146, 254, 2, 120, 120, 16, 16, 40, 40, 84, 124, 146, 254, 2, 120, 120,
  16, 16, 56, 56, 116, 116, 242, 254, 2, 120, 120, 16, 16, 56, 56, 92,
  92, 158, 254, 3, 119, 119, 56, 68, 130, 130, 130, 68, 56, 2, 119, 119,
  254, 146, 146, 242, 130, 130, 254, 2, 119, 119, 254, 130, 130, 242, 146, 146,
  254, 2, 119, 119, 254, 130, 130, 158, 146, 146, 254, 2, 119, 119, 254, 146,
  146, 158, 130, 130, 254, 2, 119, 119, 56, 84, 146, 242, 130, 68, 56, 2,
  119, 119, 56, 68, 130, 242, 146, 84, 56, 2, 119, 119, 56, 68, 130, 158,
  146, 84, 56, 2, 119, 119, 56, 84, 146, 158, 130, 68, 56, 255, 255, 255,
  255, 255, 255, 255, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--13-120-75-75-C-70-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 7, '1' Height: 5
  Calculated Max Values w= 7 h= 9 x= 1 y= 2 dx= 7 dy= 0 ascent= 9 len= 9
  Font Bounding box     w= 7 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y= 0 dx= 0 dy= 0
  Pure Font   ascent = 7 descent= 0
  X Font      ascent = 8 descent= 0
  Max Font    ascent = 9 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_7x13_75r[471] U8G_FONT_SECTION("u8g_font_7x13_75r") = {
  1, 7, 13, 0, 254, 7, 1, 71, 0, 0, 32, 79, 0, 9, 0, 8,
  0, 3, 119, 119, 254, 254, 254, 254, 254, 254, 254, 3, 119, 119, 254, 130,
  130, 130, 130, 130, 254, 3, 119, 119, 124, 130, 130, 130, 130, 130, 124, 3,
  119, 119, 254, 130, 186, 186, 186, 130, 254, 3, 119, 119, 254, 130, 254, 130,
  254, 130, 254, 3, 119, 119, 254, 170, 170, 170, 170, 170, 254, 3, 119, 119,
  254, 170, 254, 170, 254, 170, 254, 3, 119, 119, 254, 146, 138, 198, 162, 146,
  254, 3, 119, 119, 254, 146, 162, 198, 138, 146, 254, 3, 119, 119, 254, 214,
  170, 214, 170, 214, 254, 20, 85, 117, 248, 248, 248, 248, 248, 20, 85, 117,
  248, 136, 136, 136, 248, 4, 117, 117, 254, 254, 254, 254, 254, 4, 117, 117,
  254, 130, 130, 130, 254, 19, 87, 119, 248, 248, 248, 248, 248, 248, 248, 19,
  87, 119, 248, 136, 136, 136, 136, 136, 248, 4, 117, 117, 62, 126, 254, 252,
  248, 4, 117, 117, 62, 66, 130, 132, 248, 2, 120, 120, 16, 16, 56, 56,
  124, 124, 254, 254, 2, 120, 120, 16, 16, 40, 40, 68, 68, 130, 254, 19,
  86, 118, 32, 32, 112, 112, 248, 248, 19, 86, 118, 32, 32, 80, 80, 136,
  248, 3, 119, 119, 128, 224, 248, 254, 248, 224, 128, 3, 119, 119, 128, 224,
  152, 134, 152, 224, 128, 4, 101, 117, 192, 240, 252, 240, 192, 4, 101, 117,
  192, 176, 140, 176, 192, 4, 117, 117, 128, 240, 254, 240, 128, 4, 117, 117,
  128, 240, 142, 240, 128, 2, 120, 120, 254, 254, 124, 124, 56, 56, 16, 16,
  2, 120, 120, 254, 130, 68, 68, 40, 40, 16, 16, 19, 86, 118, 248, 248,
  112, 112, 32, 32, 19, 86, 118, 248, 136, 80, 80, 32, 32, 3, 119, 119,
  2, 14, 62, 254, 62, 14, 2, 3, 119, 119, 2, 14, 50, 194, 50, 14,
  2, 4, 101, 117, 12, 60, 252, 60, 12, 4, 101, 117, 12, 52, 196, 52,
  12, 4, 117, 117, 2, 30, 254, 30, 2, 4, 117, 117, 2, 30, 226, 30,
  2, 2, 119, 119, 16, 56, 124, 254, 124, 56, 16, 2, 119, 119, 16, 40,
  68, 130, 68, 40, 16, 2, 119, 119, 16, 40, 84, 186, 84, 40, 16, 3,
  119, 119, 56, 68, 146, 186, 146, 68, 56, 18, 89, 121, 32, 32, 80, 80,
  136, 80, 80, 32, 32, 3, 119, 119, 56, 68, 130, 130, 130, 68, 56, 3,
  119, 119, 40, 0, 130, 0, 130, 0, 40, 3, 119, 119, 56, 108, 170, 170,
  170, 108, 56, 3, 119, 119, 56, 68, 146, 170, 146, 68, 56, 3, 119, 119,
  56, 124, 254, 254, 254, 124, 56
};

/*
  Fontname: -Misc-Fixed-Bold-R-Normal--13-120-75-75-C-70-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 6 h=11 x= 2 y=11 dx= 7 dy= 0 ascent=11 len=11
  Font Bounding box     w= 7 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent = 9 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_7x13B[2172] U8G_FONT_SECTION("u8g_font_7x13B") = {
  1, 7, 13, 0, 254, 9, 1, 105, 2, 216, 32, 255, 254, 11, 254, 9,
  254, 13, 0, 112, 34, 41, 121, 192, 192, 192, 192, 192, 192, 0, 192, 192,
  24, 83, 115, 216, 216, 216, 18, 89, 121, 80, 80, 248, 248, 80, 248, 248,
  80, 80, 2, 105, 121, 48, 120, 180, 176, 120, 52, 180, 120, 48, 2, 105,
  121, 228, 172, 232, 24, 48, 96, 92, 212, 156, 2, 105, 121, 112, 216, 216,
  216, 112, 212, 220, 216, 116, 39, 36, 116, 192, 192, 192, 192, 18, 73, 121,
  48, 96, 96, 192, 192, 192, 96, 96, 48, 18, 73, 121, 192, 96, 96, 48,
  48, 48, 96, 96, 192, 3, 102, 118, 72, 48, 252, 252, 48, 72, 3, 102,
  118, 48, 48, 252, 252, 48, 48, 17, 68, 116, 112, 112, 96, 192, 5, 97,
  113, 252, 17, 67, 115, 96, 240, 96, 2, 105, 121, 12, 12, 24, 24, 48,
  96, 96, 192, 192, 2, 105, 121, 48, 72, 204, 204, 204, 204, 204, 72, 48,
  2, 105, 121, 48, 112, 176, 48, 48, 48, 48, 48, 252, 2, 105, 121, 120,
  204, 204, 12, 56, 96, 192, 192, 252, 2, 105, 121, 252, 12, 24, 48, 120,
  12, 12, 204, 120, 2, 105, 121, 12, 28, 60, 108, 204, 204, 252, 12, 12,
  2, 105, 121, 252, 192, 192, 248, 204, 12, 12, 204, 120, 2, 105, 121, 120,
  204, 192, 192, 248, 204, 204, 204, 120, 2, 105, 121, 252, 12, 12, 24, 24,
  48, 48, 96, 96, 2, 105, 121, 120, 204, 204, 204, 120, 204, 204, 204, 120,
  2, 105, 121, 120, 204, 204, 204, 124, 12, 12, 204, 120, 17, 72, 120, 96,
  240, 96, 0, 0, 96, 240, 96, 17, 72, 120, 96, 240, 96, 0, 112, 112,
  96, 192, 2, 105, 121, 12, 24, 48, 96, 192, 96, 48, 24, 12, 4, 100,
  116, 252, 0, 0, 252, 2, 105, 121, 192, 96, 48, 24, 12, 24, 48, 96,
  192, 2, 105, 121, 120, 204, 204, 12, 56, 48, 0, 48, 48, 2, 105, 121,
  120, 140, 140, 188, 172, 188, 128, 140, 120, 2, 105, 121, 120, 204, 204, 204,
  252, 204, 204, 204, 204, 2, 105, 121, 248, 204, 204, 204, 248, 204, 204, 204,
  248, 2, 105, 121, 120, 204, 192, 192, 192, 192, 192, 204, 120, 2, 105, 121,
  248, 204, 204, 204, 204, 204, 204, 204, 248, 2, 105, 121, 252, 192, 192, 192,
  248, 192, 192, 192, 252, 2, 105, 121, 252, 192, 192, 192, 248, 192, 192, 192,
  192, 2, 105, 121, 120, 204, 192, 192, 220, 204, 204, 204, 124, 2, 105, 121,
  204, 204, 204, 204, 252, 204, 204, 204, 204, 2, 105, 121, 252, 48, 48, 48,
  48, 48, 48, 48, 252, 2, 105, 121, 12, 12, 12, 12, 12, 12, 12, 204,
  120, 2, 105, 121, 196, 204, 216, 240, 224, 240, 216, 204, 196, 2, 105, 121,
  192, 192, 192, 192, 192, 192, 192, 192, 252, 2, 105, 121, 132, 204, 252, 252,
  204, 204, 204, 204, 204, 2, 105, 121, 204, 204, 236, 236, 252, 220, 220, 204,
  204, 2, 105, 121, 120, 204, 204, 204, 204, 204, 204, 204, 120, 2, 105, 121,
  248, 204, 204, 204, 248, 192, 192, 192, 192, 1, 106, 122, 120, 204, 204, 204,
  204, 204, 236, 220, 120, 12, 2, 105, 121, 248, 204, 204, 204, 248, 240, 216,
  204, 196, 2, 105, 121, 120, 204, 192, 192, 120, 12, 12, 204, 120, 2, 105,
  121, 252, 48, 48, 48, 48, 48, 48, 48, 48, 2, 105, 121, 204, 204, 204,
  204, 204, 204, 204, 204, 120, 2, 105, 121, 204, 204, 204, 72, 72, 120, 48,
  48, 48, 2, 105, 121, 204, 204, 204, 204, 204, 252, 252, 204, 132, 2, 105,
  121, 132, 204, 72, 120, 48, 120, 72, 204, 132, 2, 105, 121, 204, 204, 120,
  120, 48, 48, 48, 48, 48, 2, 105, 121, 252, 12, 12, 24, 48, 96, 192,
  192, 252, 18, 73, 121, 240, 192, 192, 192, 192, 192, 192, 192, 240, 2, 105,
  121, 192, 192, 96, 96, 48, 24, 24, 12, 12, 18, 73, 121, 240, 48, 48,
  48, 48, 48, 48, 48, 240, 7, 100, 116, 48, 120, 204, 132, 1, 98, 114,
  252, 252, 25, 67, 115, 192, 96, 48, 2, 102, 118, 120, 12, 124, 204, 204,
  124, 2, 105, 121, 192, 192, 192, 248, 204, 204, 204, 204, 248, 2, 102, 118,
  120, 204, 192, 192, 204, 120, 2, 105, 121, 12, 12, 12, 124, 204, 204, 204,
  204, 124, 2, 102, 118, 120, 204, 252, 192, 204, 120, 2, 105, 121, 56, 108,
  96, 96, 240, 96, 96, 96, 96, 0, 104, 120, 116, 204, 204, 120, 192, 120,
  204, 120, 2, 105, 121, 192, 192, 192, 248, 204, 204, 204, 204, 204, 2, 105,
  121, 48, 48, 0, 112, 48, 48, 48, 48, 252, 0, 107, 123, 12, 12, 0,
  12, 12, 12, 12, 12, 12, 204, 120, 2, 105, 121, 192, 192, 192, 204, 216,
  240, 240, 216, 204, 2, 105, 121, 112, 48, 48, 48, 48, 48, 48, 48, 252,
  2, 102, 118, 216, 252, 252, 204, 204, 204, 2, 102, 118, 248, 204, 204, 204,
  204, 204, 2, 102, 118, 120, 204, 204, 204, 204, 120, 0, 104, 120, 248, 204,
  204, 204, 248, 192, 192, 192, 0, 104, 120, 124, 204, 204, 204, 124, 12, 12,
  12, 2, 102, 118, 248, 204, 192, 192, 192, 192, 2, 102, 118, 120, 204, 96,
  24, 204, 120, 2, 104, 120, 96, 96, 248, 96, 96, 96, 108, 56, 2, 102,
  118, 204, 204, 204, 204, 204, 124, 2, 102, 118, 204, 204, 204, 120, 120, 48,
  2, 102, 118, 204, 204, 204, 252, 252, 72, 2, 102, 118, 204, 204, 120, 120,
  204, 204, 0, 104, 120, 204, 204, 204, 204, 124, 12, 204, 120, 2, 102, 118,
  252, 12, 24, 96, 192, 252, 18, 73, 121, 112, 192, 192, 96, 192, 96, 192,
  192, 112, 34, 41, 121, 192, 192, 192, 192, 192, 192, 192, 192, 192, 18, 73,
  121, 224, 48, 48, 96, 48, 96, 48, 48, 224, 8, 99, 115, 100, 252, 152,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 13, 0, 112, 34, 42, 122, 192, 192, 0, 192, 192, 192, 192, 192, 192,
  192, 3, 104, 120, 16, 124, 212, 208, 208, 212, 124, 16, 2, 105, 121, 56,
  108, 96, 96, 248, 96, 96, 108, 184, 3, 102, 118, 204, 252, 72, 72, 252,
  204, 2, 105, 121, 204, 204, 120, 120, 252, 48, 252, 48, 48, 34, 42, 122,
  192, 192, 192, 192, 0, 0, 192, 192, 192, 192, 2, 106, 122, 120, 204, 192,
  120, 204, 204, 120, 12, 204, 120, 26, 82, 114, 216, 216, 2, 106, 122, 120,
  204, 132, 180, 228, 228, 180, 132, 204, 120, 20, 87, 119, 240, 24, 248, 152,
  248, 0, 248, 3, 103, 119, 52, 104, 208, 160, 208, 104, 52, 3, 100, 116,
  252, 12, 12, 12, 21, 65, 113, 240, 2, 106, 122, 120, 204, 132, 188, 172,
  188, 180, 172, 204, 120, 27, 81, 113, 248, 7, 100, 116, 120, 204, 204, 120,
  3, 103, 119, 48, 48, 252, 48, 48, 0, 252, 6, 70, 118, 224, 176, 48,
  96, 192, 240, 6, 70, 118, 224, 176, 96, 48, 176, 224, 25, 67, 115, 48,
  96, 192, 1, 103, 119, 204, 204, 204, 204, 204, 252, 128, 2, 105, 121, 124,
  252, 244, 244, 244, 116, 52, 52, 52, 38, 34, 114, 192, 192, 16, 50, 114,
  96, 192, 6, 70, 118, 96, 224, 96, 96, 96, 240, 21, 87, 119, 112, 248,
  136, 248, 112, 0, 248, 3, 103, 119, 176, 88, 44, 20, 44, 88, 176, 2,
  106, 122, 96, 224, 96, 96, 100, 252, 28, 52, 60, 12, 2, 106, 122, 96,
  224, 96, 96, 120, 236, 12, 24, 48, 60, 2, 106, 122, 224, 176, 96, 48,
  180, 236, 28, 52, 60, 12, 2, 106, 122, 48, 48, 0, 48, 48, 96, 192,
  204, 204, 120, 2, 106, 122, 96, 48, 0, 48, 120, 204, 204, 252, 204, 204,
  2, 106, 122, 24, 48, 0, 48, 120, 204, 204, 252, 204, 204, 2, 106, 122,
  56, 108, 0, 48, 120, 204, 204, 252, 204, 204, 2, 106, 122, 52, 88, 0,
  48, 120, 204, 204, 252, 204, 204, 2, 106, 122, 204, 204, 0, 48, 120, 204,
  204, 252, 204, 204, 2, 106, 122, 120, 72, 120, 48, 120, 204, 204, 252, 204,
  204, 2, 105, 121, 124, 248, 216, 216, 220, 248, 216, 216, 220, 0, 107, 123,
  120, 204, 192, 192, 192, 192, 192, 204, 120, 48, 96, 2, 106, 122, 96, 48,
  0, 252, 192, 192, 240, 192, 192, 252, 2, 106, 122, 24, 48, 0, 252, 192,
  192, 240, 192, 192, 252, 2, 106, 122, 56, 108, 0, 252, 192, 192, 240, 192,
  192, 252, 2, 106, 122, 204, 204, 0, 252, 192, 192, 240, 192, 192, 252, 2,
  106, 122, 96, 48, 0, 252, 48, 48, 48, 48, 48, 252, 2, 106, 122, 24,
  48, 0, 252, 48, 48, 48, 48, 48, 252, 2, 106, 122, 56, 108, 0, 252,
  48, 48, 48, 48, 48, 252, 2, 106, 122, 204, 204, 0, 252, 48, 48, 48,
  48, 48, 252, 2, 105, 121, 248, 108, 108, 108, 236, 108, 108, 108, 248, 2,
  106, 122, 52, 88, 0, 204, 204, 236, 252, 220, 204, 204, 2, 106, 122, 96,
  48, 0, 120, 204, 204, 204, 204, 204, 120, 2, 106, 122, 24, 48, 0, 120,
  204, 204, 204, 204, 204, 120, 2, 106, 122, 56, 108, 0, 120, 204, 204, 204,
  204, 204, 120, 2, 106, 122, 52, 88, 0, 120, 204, 204, 204, 204, 204, 120,
  2, 106, 122, 204, 204, 0, 120, 204, 204, 204, 204, 204, 120, 3, 101, 117,
  204, 120, 48, 120, 204, 1, 106, 122, 4, 120, 220, 220, 220, 236, 236, 236,
  120, 128, 2, 106, 122, 96, 48, 0, 204, 204, 204, 204, 204, 204, 120, 2,
  106, 122, 24, 48, 0, 204, 204, 204, 204, 204, 204, 120, 2, 106, 122, 56,
  108, 0, 204, 204, 204, 204, 204, 204, 120, 2, 106, 122, 204, 204, 0, 204,
  204, 204, 204, 204, 204, 120, 2, 106, 122, 24, 48, 0, 204, 72, 120, 48,
  48, 48, 48, 2, 105, 121, 192, 248, 204, 204, 204, 248, 192, 192, 192, 2,
  105, 121, 120, 204, 204, 216, 216, 204, 204, 204, 216, 2, 105, 121, 48, 24,
  0, 120, 12, 124, 204, 220, 124, 2, 105, 121, 24, 48, 0, 120, 12, 124,
  204, 220, 124, 2, 105, 121, 56, 108, 0, 120, 12, 124, 204, 220, 124, 2,
  105, 121, 52, 88, 0, 120, 12, 124, 204, 220, 124, 2, 105, 121, 108, 108,
  0, 120, 12, 124, 204, 220, 124, 2, 106, 122, 56, 40, 56, 0, 120, 12,
  124, 204, 220, 124, 2, 102, 118, 120, 52, 124, 176, 180, 104, 0, 104, 120,
  120, 204, 192, 192, 204, 120, 48, 96, 2, 105, 121, 48, 24, 0, 120, 204,
  252, 192, 204, 120, 2, 105, 121, 24, 48, 0, 120, 204, 252, 192, 204, 120,
  2, 105, 121, 56, 108, 0, 120, 204, 252, 192, 204, 120, 2, 105, 121, 108,
  108, 0, 120, 204, 252, 192, 204, 120, 18, 73, 121, 192, 96, 0, 224, 96,
  96, 96, 96, 240, 18, 73, 121, 48, 96, 0, 224, 96, 96, 96, 96, 240,
  2, 89, 121, 112, 216, 0, 112, 48, 48, 48, 48, 120, 18, 89, 121, 216,
  216, 0, 224, 96, 96, 96, 96, 240, 2, 106, 122, 104, 48, 120, 12, 124,
  204, 204, 204, 204, 120, 2, 105, 121, 52, 88, 0, 248, 236, 204, 204, 204,
  204, 2, 105, 121, 96, 48, 0, 120, 204, 204, 204, 204, 120, 2, 105, 121,
  24, 48, 0, 120, 204, 204, 204, 204, 120, 2, 105, 121, 56, 108, 0, 120,
  204, 204, 204, 204, 120, 2, 105, 121, 52, 88, 0, 120, 204, 204, 204, 204,
  120, 2, 105, 121, 108, 108, 0, 120, 204, 204, 204, 204, 120, 3, 103, 119,
  48, 48, 0, 252, 0, 48, 48, 1, 105, 121, 4, 120, 204, 220, 204, 236,
  204, 120, 128, 2, 105, 121, 96, 48, 0, 204, 204, 204, 204, 220, 124, 2,
  105, 121, 24, 48, 0, 204, 204, 204, 204, 220, 124, 2, 105, 121, 56, 108,
  0, 204, 204, 204, 204, 220, 124, 2, 105, 121, 108, 108, 0, 204, 204, 204,
  204, 220, 124, 0, 107, 123, 24, 48, 0, 204, 204, 204, 220, 124, 12, 204,
  120, 0, 106, 122, 192, 192, 216, 236, 204, 204, 236, 216, 192, 192, 0, 107,
  123, 108, 108, 0, 204, 204, 204, 220, 108, 12, 204, 120
};

/*
  Fontname: -Misc-Fixed-Bold-R-Normal--13-120-75-75-C-70-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 6 h=11 x= 2 y=11 dx= 7 dy= 0 ascent=11 len=11
  Font Bounding box     w= 7 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent = 9 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_7x13Br[1041] U8G_FONT_SECTION("u8g_font_7x13Br") = {
  1, 7, 13, 0, 254, 9, 1, 105, 2, 216, 32, 127, 254, 11, 254, 9,
  254, 13, 0, 112, 34, 41, 121, 192, 192, 192, 192, 192, 192, 0, 192, 192,
  24, 83, 115, 216, 216, 216, 18, 89, 121, 80, 80, 248, 248, 80, 248, 248,
  80, 80, 2, 105, 121, 48, 120, 180, 176, 120, 52, 180, 120, 48, 2, 105,
  121, 228, 172, 232, 24, 48, 96, 92, 212, 156, 2, 105, 121, 112, 216, 216,
  216, 112, 212, 220, 216, 116, 39, 36, 116, 192, 192, 192, 192, 18, 73, 121,
  48, 96, 96, 192, 192, 192, 96, 96, 48, 18, 73, 121, 192, 96, 96, 48,
  48, 48, 96, 96, 192, 3, 102, 118, 72, 48, 252, 252, 48, 72, 3, 102,
  118, 48, 48, 252, 252, 48, 48, 17, 68, 116, 112, 112, 96, 192, 5, 97,
  113, 252, 17, 67, 115, 96, 240, 96, 2, 105, 121, 12, 12, 24, 24, 48,
  96, 96, 192, 192, 2, 105, 121, 48, 72, 204, 204, 204, 204, 204, 72, 48,
  2, 105, 121, 48, 112, 176, 48, 48, 48, 48, 48, 252, 2, 105, 121, 120,
  204, 204, 12, 56, 96, 192, 192, 252, 2, 105, 121, 252, 12, 24, 48, 120,
  12, 12, 204, 120, 2, 105, 121, 12, 28, 60, 108, 204, 204, 252, 12, 12,
  2, 105, 121, 252, 192, 192, 248, 204, 12, 12, 204, 120, 2, 105, 121, 120,
  204, 192, 192, 248, 204, 204, 204, 120, 2, 105, 121, 252, 12, 12, 24, 24,
  48, 48, 96, 96, 2, 105, 121, 120, 204, 204, 204, 120, 204, 204, 204, 120,
  2, 105, 121, 120, 204, 204, 204, 124, 12, 12, 204, 120, 17, 72, 120, 96,
  240, 96, 0, 0, 96, 240, 96, 17, 72, 120, 96, 240, 96, 0, 112, 112,
  96, 192, 2, 105, 121, 12, 24, 48, 96, 192, 96, 48, 24, 12, 4, 100,
  116, 252, 0, 0, 252, 2, 105, 121, 192, 96, 48, 24, 12, 24, 48, 96,
  192, 2, 105, 121, 120, 204, 204, 12, 56, 48, 0, 48, 48, 2, 105, 121,
  120, 140, 140, 188, 172, 188, 128, 140, 120, 2, 105, 121, 120, 204, 204, 204,
  252, 204, 204, 204, 204, 2, 105, 121, 248, 204, 204, 204, 248, 204, 204, 204,
  248, 2, 105, 121, 120, 204, 192, 192, 192, 192, 192, 204, 120, 2, 105, 121,
  248, 204, 204, 204, 204, 204, 204, 204, 248, 2, 105, 121, 252, 192, 192, 192,
  248, 192, 192, 192, 252, 2, 105, 121, 252, 192, 192, 192, 248, 192, 192, 192,
  192, 2, 105, 121, 120, 204, 192, 192, 220, 204, 204, 204, 124, 2, 105, 121,
  204, 204, 204, 204, 252, 204, 204, 204, 204, 2, 105, 121, 252, 48, 48, 48,
  48, 48, 48, 48, 252, 2, 105, 121, 12, 12, 12, 12, 12, 12, 12, 204,
  120, 2, 105, 121, 196, 204, 216, 240, 224, 240, 216, 204, 196, 2, 105, 121,
  192, 192, 192, 192, 192, 192, 192, 192, 252, 2, 105, 121, 132, 204, 252, 252,
  204, 204, 204, 204, 204, 2, 105, 121, 204, 204, 236, 236, 252, 220, 220, 204,
  204, 2, 105, 121, 120, 204, 204, 204, 204, 204, 204, 204, 120, 2, 105, 121,
  248, 204, 204, 204, 248, 192, 192, 192, 192, 1, 106, 122, 120, 204, 204, 204,
  204, 204, 236, 220, 120, 12, 2, 105, 121, 248, 204, 204, 204, 248, 240, 216,
  204, 196, 2, 105, 121, 120, 204, 192, 192, 120, 12, 12, 204, 120, 2, 105,
  121, 252, 48, 48, 48, 48, 48, 48, 48, 48, 2, 105, 121, 204, 204, 204,
  204, 204, 204, 204, 204, 120, 2, 105, 121, 204, 204, 204, 72, 72, 120, 48,
  48, 48, 2, 105, 121, 204, 204, 204, 204, 204, 252, 252, 204, 132, 2, 105,
  121, 132, 204, 72, 120, 48, 120, 72, 204, 132, 2, 105, 121, 204, 204, 120,
  120, 48, 48, 48, 48, 48, 2, 105, 121, 252, 12, 12, 24, 48, 96, 192,
  192, 252, 18, 73, 121, 240, 192, 192, 192, 192, 192, 192, 192, 240, 2, 105,
  121, 192, 192, 96, 96, 48, 24, 24, 12, 12, 18, 73, 121, 240, 48, 48,
  48, 48, 48, 48, 48, 240, 7, 100, 116, 48, 120, 204, 132, 1, 98, 114,
  252, 252, 25, 67, 115, 192, 96, 48, 2, 102, 118, 120, 12, 124, 204, 204,
  124, 2, 105, 121, 192, 192, 192, 248, 204, 204, 204, 204, 248, 2, 102, 118,
  120, 204, 192, 192, 204, 120, 2, 105, 121, 12, 12, 12, 124, 204, 204, 204,
  204, 124, 2, 102, 118, 120, 204, 252, 192, 204, 120, 2, 105, 121, 56, 108,
  96, 96, 240, 96, 96, 96, 96, 0, 104, 120, 116, 204, 204, 120, 192, 120,
  204, 120, 2, 105, 121, 192, 192, 192, 248, 204, 204, 204, 204, 204, 2, 105,
  121, 48, 48, 0, 112, 48, 48, 48, 48, 252, 0, 107, 123, 12, 12, 0,
  12, 12, 12, 12, 12, 12, 204, 120, 2, 105, 121, 192, 192, 192, 204, 216,
  240, 240, 216, 204, 2, 105, 121, 112, 48, 48, 48, 48, 48, 48, 48, 252,
  2, 102, 118, 216, 252, 252, 204, 204, 204, 2, 102, 118, 248, 204, 204, 204,
  204, 204, 2, 102, 118, 120, 204, 204, 204, 204, 120, 0, 104, 120, 248, 204,
  204, 204, 248, 192, 192, 192, 0, 104, 120, 124, 204, 204, 204, 124, 12, 12,
  12, 2, 102, 118, 248, 204, 192, 192, 192, 192, 2, 102, 118, 120, 204, 96,
  24, 204, 120, 2, 104, 120, 96, 96, 248, 96, 96, 96, 108, 56, 2, 102,
  118, 204, 204, 204, 204, 204, 124, 2, 102, 118, 204, 204, 204, 120, 120, 48,
  2, 102, 118, 204, 204, 204, 252, 252, 72, 2, 102, 118, 204, 204, 120, 120,
  204, 204, 0, 104, 120, 204, 204, 204, 204, 124, 12, 204, 120, 2, 102, 118,
  252, 12, 24, 96, 192, 252, 18, 73, 121, 112, 192, 192, 96, 192, 96, 192,
  192, 112, 34, 41, 121, 192, 192, 192, 192, 192, 192, 192, 192, 192, 18, 73,
  121, 224, 48, 48, 96, 48, 96, 48, 48, 224, 8, 99, 115, 100, 252, 152,
  255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--13-120-75-75-C-70-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 6 h=11 x= 3 y=11 dx= 7 dy= 0 ascent=11 len=11
  Font Bounding box     w= 7 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent =10 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_7x13[2157] U8G_FONT_SECTION("u8g_font_7x13") = {
  1, 7, 13, 0, 254, 9, 1, 95, 2, 207, 32, 255, 254, 11, 254, 10,
  254, 13, 0, 112, 50, 25, 121, 128, 128, 128, 128, 128, 128, 128, 0, 128,
  40, 51, 115, 160, 160, 160, 19, 87, 119, 80, 80, 248, 80, 248, 80, 80,
  19, 87, 119, 32, 120, 160, 112, 40, 240, 32, 2, 105, 121, 68, 164, 72,
  16, 16, 32, 72, 148, 136, 2, 103, 119, 96, 144, 144, 96, 148, 136, 116,
  56, 19, 115, 128, 128, 128, 34, 57, 121, 32, 64, 64, 128, 128, 128, 64,
  64, 32, 34, 57, 121, 128, 64, 64, 32, 32, 32, 64, 64, 128, 4, 101,
  117, 72, 48, 252, 48, 72, 20, 85, 117, 32, 32, 248, 32, 32, 17, 67,
  115, 112, 96, 128, 22, 81, 113, 248, 33, 51, 115, 64, 224, 64, 18, 89,
  121, 8, 8, 16, 16, 32, 64, 64, 128, 128, 2, 105, 121, 48, 72, 132,
  132, 132, 132, 132, 72, 48, 18, 89, 121, 32, 96, 160, 32, 32, 32, 32,
  32, 248, 2, 105, 121, 120, 132, 132, 4, 8, 48, 64, 128, 252, 2, 105,
  121, 252, 4, 8, 16, 56, 4, 4, 132, 120, 2, 105, 121, 8, 24, 40,
  72, 136, 136, 252, 8, 8, 2, 105, 121, 252, 128, 128, 184, 196, 4, 4,
  132, 120, 2, 105, 121, 56, 64, 128, 128, 184, 196, 132, 132, 120, 2, 105,
  121, 252, 4, 8, 16, 16, 32, 32, 64, 64, 2, 105, 121, 120, 132, 132,
  132, 120, 132, 132, 132, 120, 2, 105, 121, 120, 132, 132, 140, 116, 4, 4,
  8, 112, 33, 56, 120, 64, 224, 64, 0, 0, 64, 224, 64, 17, 72, 120,
  32, 112, 32, 0, 0, 112, 96, 128, 18, 89, 121, 8, 16, 32, 64, 128,
  64, 32, 16, 8, 4, 100, 116, 252, 0, 0, 252, 18, 89, 121, 128, 64,
  32, 16, 8, 16, 32, 64, 128, 2, 105, 121, 120, 132, 132, 4, 8, 16,
  16, 0, 16, 2, 105, 121, 120, 132, 132, 156, 164, 172, 148, 128, 120, 2,
  105, 121, 48, 72, 132, 132, 132, 252, 132, 132, 132, 2, 105, 121, 248, 68,
  68, 68, 120, 68, 68, 68, 248, 2, 105, 121, 120, 132, 128, 128, 128, 128,
  128, 132, 120, 2, 105, 121, 248, 68, 68, 68, 68, 68, 68, 68, 248, 2,
  105, 121, 252, 128, 128, 128, 240, 128, 128, 128, 252, 2, 105, 121, 252, 128,
  128, 128, 240, 128, 128, 128, 128, 2, 105, 121, 120, 132, 128, 128, 128, 156,
  132, 140, 116, 2, 105, 121, 132, 132, 132, 132, 252, 132, 132, 132, 132, 18,
  89, 121, 248, 32, 32, 32, 32, 32, 32, 32, 248, 2, 105, 121, 28, 8,
  8, 8, 8, 8, 8, 136, 112, 2, 105, 121, 132, 136, 144, 160, 192, 160,
  144, 136, 132, 2, 105, 121, 128, 128, 128, 128, 128, 128, 128, 128, 252, 2,
  105, 121, 132, 204, 204, 180, 180, 132, 132, 132, 132, 2, 105, 121, 132, 132,
  196, 164, 148, 140, 132, 132, 132, 2, 105, 121, 120, 132, 132, 132, 132, 132,
  132, 132, 120, 2, 105, 121, 248, 132, 132, 132, 248, 128, 128, 128, 128, 1,
  106, 122, 120, 132, 132, 132, 132, 132, 164, 148, 120, 4, 2, 105, 121, 248,
  132, 132, 132, 248, 160, 144, 136, 132, 2, 105, 121, 120, 132, 128, 128, 120,
  4, 4, 132, 120, 18, 89, 121, 248, 32, 32, 32, 32, 32, 32, 32, 32,
  2, 105, 121, 132, 132, 132, 132, 132, 132, 132, 132, 120, 2, 105, 121, 132,
  132, 132, 72, 72, 72, 48, 48, 48, 2, 105, 121, 132, 132, 132, 132, 180,
  180, 204, 204, 132, 2, 105, 121, 132, 132, 72, 72, 48, 72, 72, 132, 132,
  18, 89, 121, 136, 136, 80, 80, 32, 32, 32, 32, 32, 2, 105, 121, 252,
  4, 8, 16, 48, 32, 64, 128, 252, 17, 75, 123, 240, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 240, 18, 89, 121, 128, 128, 64, 64, 32, 16, 16,
  8, 8, 17, 75, 123, 240, 16, 16, 16, 16, 16, 16, 16, 16, 16, 240,
  24, 83, 115, 32, 80, 136, 1, 97, 113, 252, 42, 34, 114, 128, 64, 2,
  102, 118, 120, 4, 124, 132, 140, 116, 2, 105, 121, 128, 128, 128, 184, 196,
  132, 132, 196, 184, 2, 102, 118, 120, 132, 128, 128, 132, 120, 2, 105, 121,
  4, 4, 4, 116, 140, 132, 132, 140, 116, 2, 102, 118, 120, 132, 252, 128,
  132, 120, 2, 105, 121, 56, 68, 64, 64, 240, 64, 64, 64, 64, 0, 104,
  120, 116, 136, 136, 112, 128, 120, 132, 120, 2, 105, 121, 128, 128, 128, 184,
  196, 132, 132, 132, 132, 18, 88, 120, 32, 0, 96, 32, 32, 32, 32, 248,
  16, 90, 122, 8, 0, 24, 8, 8, 8, 8, 136, 136, 112, 2, 105, 121,
  128, 128, 128, 136, 144, 224, 144, 136, 132, 18, 89, 121, 96, 32, 32, 32,
  32, 32, 32, 32, 248, 18, 86, 118, 208, 168, 168, 168, 168, 136, 2, 102,
  118, 184, 196, 132, 132, 132, 132, 2, 102, 118, 120, 132, 132, 132, 132, 120,
  0, 104, 120, 184, 196, 132, 196, 184, 128, 128, 128, 0, 104, 120, 116, 140,
  132, 140, 116, 4, 4, 4, 2, 102, 118, 184, 68, 64, 64, 64, 64, 2,
  102, 118, 120, 132, 96, 24, 132, 120, 2, 104, 120, 64, 64, 240, 64, 64,
  64, 68, 56, 2, 102, 118, 132, 132, 132, 132, 140, 116, 18, 86, 118, 136,
  136, 136, 80, 80, 32, 18, 86, 118, 136, 136, 168, 168, 168, 80, 2, 102,
  118, 132, 72, 48, 48, 72, 132, 0, 104, 120, 132, 132, 132, 140, 116, 4,
  132, 120, 2, 102, 118, 252, 8, 16, 32, 64, 252, 17, 91, 123, 56, 64,
  64, 64, 32, 192, 32, 64, 64, 64, 56, 50, 25, 121, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 17, 91, 123, 224, 16, 16, 16, 32, 24, 32, 16,
  16, 16, 224, 24, 83, 115, 72, 168, 144, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 13, 0, 112, 50, 25, 121,
  128, 0, 128, 128, 128, 128, 128, 128, 128, 19, 88, 120, 32, 112, 168, 160,
  160, 168, 112, 32, 2, 105, 121, 56, 68, 64, 64, 224, 64, 64, 68, 184,
  3, 102, 118, 132, 120, 72, 72, 120, 132, 2, 89, 121, 136, 136, 80, 80,
  248, 32, 248, 32, 32, 50, 25, 121, 128, 128, 128, 128, 0, 128, 128, 128,
  128, 18, 74, 122, 96, 144, 128, 96, 144, 144, 96, 16, 144, 96, 25, 66,
  114, 144, 144, 2, 105, 121, 120, 132, 180, 164, 164, 164, 180, 132, 120, 20,
  87, 119, 112, 8, 120, 136, 120, 0, 248, 3, 103, 119, 20, 40, 80, 160,
  80, 40, 20, 20, 83, 115, 248, 8, 8, 22, 65, 113, 240, 2, 105, 121,
  120, 132, 180, 172, 172, 180, 172, 132, 120, 26, 81, 113, 248, 23, 68, 116,
  96, 144, 144, 96, 19, 87, 119, 32, 32, 248, 32, 32, 0, 248, 22, 54,
  118, 64, 160, 32, 64, 128, 224, 22, 54, 118, 224, 32, 64, 32, 160, 64,
  42, 34, 114, 64, 128, 1, 103, 119, 132, 132, 132, 132, 204, 180, 128, 2,
  105, 121, 124, 232, 232, 232, 104, 40, 40, 40, 40, 38, 33, 113, 192, 32,
  34, 114, 64, 128, 22, 54, 118, 64, 192, 64, 64, 64, 224, 21, 70, 118,
  96, 144, 144, 96, 0, 240, 3, 103, 119, 160, 80, 40, 20, 40, 80, 160,
  2, 106, 122, 64, 192, 64, 64, 68, 236, 20, 20, 28, 4, 2, 106, 122,
  64, 192, 64, 64, 72, 244, 4, 8, 16, 28, 2, 106, 122, 224, 32, 64,
  32, 164, 76, 20, 20, 28, 4, 2, 105, 121, 32, 0, 32, 32, 64, 128,
  132, 132, 120, 2, 106, 122, 32, 16, 0, 48, 72, 132, 132, 252, 132, 132,
  2, 106, 122, 16, 32, 0, 48, 72, 132, 132, 252, 132, 132, 2, 106, 122,
  48, 72, 0, 48, 72, 132, 132, 252, 132, 132, 2, 106, 122, 100, 152, 0,
  48, 72, 132, 132, 252, 132, 132, 2, 106, 122, 72, 72, 0, 48, 72, 132,
  132, 252, 132, 132, 2, 106, 122, 48, 72, 48, 48, 72, 132, 132, 252, 132,
  132, 2, 105, 121, 92, 160, 160, 160, 184, 224, 160, 160, 188, 0, 107, 123,
  120, 132, 128, 128, 128, 128, 128, 132, 120, 16, 32, 2, 106, 122, 32, 16,
  0, 252, 128, 128, 240, 128, 128, 252, 2, 106, 122, 16, 32, 0, 252, 128,
  128, 240, 128, 128, 252, 2, 106, 122, 48, 72, 0, 252, 128, 128, 240, 128,
  128, 252, 2, 106, 122, 72, 72, 0, 252, 128, 128, 240, 128, 128, 252, 18,
  90, 122, 64, 32, 0, 248, 32, 32, 32, 32, 32, 248, 18, 90, 122, 32,
  64, 0, 248, 32, 32, 32, 32, 32, 248, 18, 90, 122, 32, 80, 0, 248,
  32, 32, 32, 32, 32, 248, 18, 90, 122, 136, 136, 0, 248, 32, 32, 32,
  32, 32, 248, 2, 105, 121, 248, 68, 68, 68, 228, 68, 68, 68, 248, 2,
  106, 122, 100, 152, 0, 132, 196, 164, 164, 148, 140, 132, 2, 106, 122, 32,
  16, 0, 120, 132, 132, 132, 132, 132, 120, 2, 106, 122, 16, 32, 0, 120,
  132, 132, 132, 132, 132, 120, 2, 106, 122, 48, 72, 0, 120, 132, 132, 132,
  132, 132, 120, 2, 106, 122, 100, 152, 0, 120, 132, 132, 132, 132, 132, 120,
  2, 106, 122, 72, 72, 0, 120, 132, 132, 132, 132, 132, 120, 3, 102, 118,
  132, 72, 48, 48, 72, 132, 1, 107, 123, 4, 120, 140, 148, 148, 164, 164,
  164, 196, 120, 128, 2, 106, 122, 32, 16, 0, 132, 132, 132, 132, 132, 132,
  120, 2, 106, 122, 16, 32, 0, 132, 132, 132, 132, 132, 132, 120, 2, 106,
  122, 48, 72, 0, 132, 132, 132, 132, 132, 132, 120, 2, 106, 122, 72, 72,
  0, 132, 132, 132, 132, 132, 132, 120, 18, 90, 122, 16, 32, 0, 136, 136,
  80, 32, 32, 32, 32, 2, 105, 121, 128, 248, 132, 132, 132, 248, 128, 128,
  128, 18, 89, 121, 96, 144, 144, 160, 160, 144, 136, 136, 176, 2, 105, 121,
  32, 16, 0, 120, 4, 124, 132, 140, 116, 2, 105, 121, 16, 32, 0, 120,
  4, 124, 132, 140, 116, 2, 105, 121, 48, 72, 0, 120, 4, 124, 132, 140,
  116, 2, 105, 121, 100, 152, 0, 120, 4, 124, 132, 140, 116, 2, 105, 121,
  72, 72, 0, 120, 4, 124, 132, 140, 116, 2, 106, 122, 48, 72, 48, 0,
  120, 4, 124, 132, 140, 116, 2, 102, 118, 104, 20, 124, 144, 148, 104, 0,
  104, 120, 120, 132, 128, 128, 132, 120, 16, 32, 2, 105, 121, 32, 16, 0,
  120, 132, 252, 128, 132, 120, 2, 105, 121, 16, 32, 0, 120, 132, 252, 128,
  132, 120, 2, 105, 121, 48, 72, 0, 120, 132, 252, 128, 132, 120, 2, 105,
  121, 72, 72, 0, 120, 132, 252, 128, 132, 120, 18, 89, 121, 64, 32, 0,
  96, 32, 32, 32, 32, 248, 18, 89, 121, 32, 64, 0, 96, 32, 32, 32,
  32, 248, 18, 89, 121, 96, 144, 0, 96, 32, 32, 32, 32, 248, 18, 89,
  121, 144, 144, 0, 96, 32, 32, 32, 32, 248, 2, 106, 122, 72, 48, 80,
  8, 120, 132, 132, 132, 132, 120, 2, 105, 121, 100, 152, 0, 184, 196, 132,
  132, 132, 132, 2, 105, 121, 32, 16, 0, 120, 132, 132, 132, 132, 120, 2,
  105, 121, 16, 32, 0, 120, 132, 132, 132, 132, 120, 2, 105, 121, 48, 72,
  0, 120, 132, 132, 132, 132, 120, 2, 105, 121, 100, 152, 0, 120, 132, 132,
  132, 132, 120, 2, 105, 121, 72, 72, 0, 120, 132, 132, 132, 132, 120, 19,
  87, 119, 32, 32, 0, 248, 0, 32, 32, 1, 104, 120, 4, 120, 140, 148,
  164, 196, 120, 128, 2, 105, 121, 32, 16, 0, 132, 132, 132, 132, 140, 116,
  2, 105, 121, 16, 32, 0, 132, 132, 132, 132, 140, 116, 2, 105, 121, 48,
  72, 0, 132, 132, 132, 132, 140, 116, 2, 105, 121, 72, 72, 0, 132, 132,
  132, 132, 140, 116, 0, 107, 123, 16, 32, 0, 132, 132, 132, 140, 116, 4,
  132, 120, 0, 106, 122, 128, 128, 184, 196, 132, 132, 196, 184, 128, 128, 0,
  107, 123, 72, 72, 0, 132, 132, 132, 140, 116, 4, 132, 120
};

/*
  Fontname: -Misc-Fixed-Medium-O-Normal--13-120-75-75-C-70-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 7 h=11 x= 3 y=11 dx= 7 dy= 0 ascent=11 len=11
  Font Bounding box     w= 7 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent =10 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_7x13O[2158] U8G_FONT_SECTION("u8g_font_7x13O") = {
  1, 7, 13, 0, 254, 9, 1, 96, 2, 208, 32, 255, 254, 11, 254, 10,
  254, 13, 0, 112, 34, 41, 121, 64, 64, 64, 64, 128, 128, 128, 0, 128,
  40, 51, 115, 160, 160, 160, 3, 103, 119, 40, 40, 124, 40, 248, 80, 80,
  3, 103, 119, 16, 60, 80, 56, 40, 240, 32, 2, 121, 121, 34, 82, 36,
  8, 16, 32, 72, 148, 136, 2, 104, 120, 24, 36, 36, 56, 80, 148, 136,
  116, 56, 19, 115, 128, 128, 128, 18, 73, 121, 16, 32, 64, 64, 128, 128,
  64, 64, 32, 18, 73, 121, 64, 32, 32, 16, 16, 32, 32, 64, 128, 20,
  85, 117, 72, 48, 248, 96, 144, 20, 69, 117, 32, 32, 240, 64, 64, 17,
  67, 115, 112, 96, 128, 22, 81, 113, 248, 33, 51, 115, 64, 224, 64, 2,
  105, 121, 4, 4, 8, 16, 16, 32, 64, 128, 128, 2, 121, 121, 24, 36,
  66, 66, 66, 132, 132, 72, 48, 18, 89, 121, 16, 48, 80, 16, 16, 32,
  32, 32, 248, 2, 121, 121, 60, 66, 66, 2, 12, 48, 64, 128, 252, 2,
  121, 121, 126, 2, 4, 8, 24, 4, 4, 132, 120, 2, 105, 121, 4, 12,
  20, 36, 72, 136, 252, 8, 8, 2, 121, 121, 62, 32, 32, 92, 98, 2,
  4, 132, 120, 2, 105, 121, 28, 32, 64, 64, 120, 132, 132, 132, 120, 2,
  105, 121, 252, 4, 8, 16, 32, 64, 64, 128, 128, 2, 121, 121, 60, 66,
  66, 66, 124, 132, 132, 132, 120, 2, 105, 121, 120, 132, 132, 140, 116, 8,
  8, 16, 224, 17, 72, 120, 32, 112, 32, 0, 0, 64, 224, 64, 17, 88,
  120, 16, 56, 16, 0, 0, 112, 96, 128, 18, 89, 121, 8, 16, 32, 64,
  128, 128, 64, 32, 16, 4, 116, 116, 126, 0, 0, 252, 18, 89, 121, 64,
  32, 16, 8, 8, 16, 32, 64, 128, 2, 105, 121, 120, 132, 132, 8, 16,
  32, 32, 0, 32, 2, 121, 121, 60, 66, 66, 78, 82, 172, 148, 128, 120,
  2, 121, 121, 24, 36, 66, 66, 66, 124, 132, 132, 132, 2, 121, 121, 124,
  34, 34, 34, 60, 68, 68, 68, 248, 2, 121, 121, 60, 66, 64, 64, 64,
  128, 128, 132, 120, 2, 121, 121, 124, 34, 34, 34, 34, 68, 68, 68, 248,
  2, 121, 121, 126, 64, 64, 64, 120, 128, 128, 128, 252, 2, 121, 121, 126,
  64, 64, 64, 120, 128, 128, 128, 128, 2, 121, 121, 60, 66, 64, 64, 64,
  156, 132, 140, 116, 2, 121, 121, 66, 66, 66, 66, 124, 132, 132, 132, 132,
  2, 105, 121, 124, 16, 16, 16, 16, 32, 32, 32, 248, 2, 121, 121, 14,
  4, 4, 4, 4, 8, 8, 136, 112, 2, 121, 121, 66, 68, 72, 80, 96,
  160, 144, 136, 132, 2, 105, 121, 64, 64, 64, 64, 64, 128, 128, 128, 252,
  2, 121, 121, 66, 102, 102, 90, 90, 132, 132, 132, 132, 2, 121, 121, 66,
  66, 98, 82, 74, 140, 132, 132, 132, 2, 121, 121, 60, 66, 66, 66, 66,
  132, 132, 132, 120, 2, 121, 121, 124, 66, 66, 66, 124, 128, 128, 128, 128,
  1, 122, 122, 60, 66, 66, 66, 66, 132, 164, 148, 120, 4, 2, 121, 121,
  124, 66, 66, 66, 124, 160, 144, 136, 132, 2, 121, 121, 60, 66, 64, 64,
  56, 4, 4, 132, 120, 18, 89, 121, 248, 32, 32, 32, 32, 64, 64, 64,
  64, 2, 121, 121, 66, 66, 66, 66, 66, 132, 132, 132, 120, 2, 105, 121,
  132, 132, 136, 136, 80, 80, 96, 96, 96, 2, 121, 121, 66, 66, 66, 66,
  90, 180, 204, 204, 132, 2, 121, 121, 66, 68, 36, 40, 16, 40, 72, 68,
  132, 18, 89, 121, 136, 136, 80, 80, 32, 32, 64, 64, 64, 2, 121, 121,
  126, 2, 4, 8, 16, 32, 64, 128, 252, 17, 91, 123, 120, 64, 64, 64,
  64, 64, 128, 128, 128, 128, 240, 18, 73, 121, 128, 128, 64, 64, 32, 32,
  32, 16, 16, 17, 91, 123, 120, 8, 8, 8, 8, 8, 16, 16, 16, 16,
  240, 24, 83, 115, 32, 80, 136, 1, 97, 113, 252, 42, 34, 114, 128, 64,
  2, 118, 118, 60, 2, 124, 132, 140, 116, 2, 121, 121, 64, 64, 64, 92,
  98, 66, 132, 196, 184, 2, 118, 118, 60, 66, 128, 128, 132, 120, 2, 121,
  121, 2, 2, 2, 58, 68, 132, 132, 140, 116, 2, 118, 118, 60, 66, 124,
  128, 132, 120, 2, 105, 121, 56, 68, 64, 64, 240, 64, 128, 128, 128, 0,
  120, 120, 58, 68, 136, 112, 128, 120, 132, 120, 2, 121, 121, 32, 32, 64,
  92, 98, 66, 132, 132, 132, 18, 88, 120, 16, 0, 48, 16, 16, 32, 32,
  248, 0, 106, 122, 4, 0, 12, 4, 4, 8, 8, 136, 136, 112, 2, 105,
  121, 64, 64, 64, 68, 88, 96, 144, 136, 132, 18, 89, 121, 48, 16, 16,
  16, 16, 32, 32, 32, 248, 2, 102, 118, 104, 84, 84, 168, 168, 136, 2,
  118, 118, 92, 98, 66, 132, 132, 132, 2, 118, 118, 60, 66, 66, 132, 132,
  120, 0, 120, 120, 92, 98, 66, 196, 184, 128, 128, 128, 0, 120, 120, 58,
  70, 130, 140, 116, 4, 4, 4, 2, 102, 118, 184, 68, 64, 128, 128, 128,
  2, 118, 118, 60, 66, 32, 24, 132, 120, 18, 88, 120, 64, 64, 240, 64,
  128, 128, 136, 112, 2, 118, 118, 66, 66, 66, 132, 140, 116, 18, 86, 118,
  136, 136, 144, 144, 160, 64, 2, 102, 118, 68, 68, 84, 168, 168, 80, 2,
  118, 118, 66, 36, 24, 48, 72, 132, 0, 120, 120, 66, 66, 132, 140, 116,
  4, 132, 120, 2, 118, 118, 126, 4, 24, 32, 64, 252, 17, 91, 123, 56,
  64, 64, 64, 32, 192, 64, 128, 128, 128, 112, 34, 41, 121, 64, 64, 64,
  64, 64, 128, 128, 128, 128, 1, 107, 123, 112, 8, 8, 8, 16, 28, 32,
  16, 16, 16, 224, 24, 83, 115, 72, 168, 144, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 13, 0, 112, 34, 41,
  121, 64, 0, 64, 64, 64, 128, 128, 128, 128, 3, 104, 120, 16, 56, 84,
  80, 160, 168, 112, 32, 2, 121, 121, 28, 34, 32, 32, 112, 32, 64, 68,
  184, 3, 118, 118, 66, 60, 36, 72, 120, 132, 2, 105, 121, 68, 68, 40,
  40, 124, 16, 248, 32, 32, 34, 41, 121, 64, 64, 64, 64, 0, 128, 128,
  128, 128, 2, 106, 122, 24, 36, 32, 48, 72, 72, 48, 16, 144, 96, 25,
  66, 114, 144, 144, 2, 121, 121, 60, 66, 90, 82, 82, 164, 180, 132, 120,
  4, 103, 119, 56, 4, 60, 68, 60, 0, 248, 3, 103, 119, 20, 40, 80,
  160, 160, 80, 40, 20, 83, 115, 248, 16, 16, 22, 65, 113, 240, 2, 121,
  121, 60, 66, 90, 86, 172, 180, 172, 132, 120, 26, 81, 113, 248, 23, 68,
  116, 96, 144, 144, 96, 19, 87, 119, 16, 16, 120, 32, 32, 0, 248, 22,
  70, 118, 32, 80, 16, 96, 128, 224, 22, 70, 118, 96, 16, 96, 32, 160,
  64, 42, 34, 114, 64, 128, 1, 119, 119, 66, 66, 66, 132, 204, 180, 128,
  2, 105, 121, 124, 232, 232, 232, 40, 80, 80, 80, 80, 38, 33, 113, 192,
  32, 34, 114, 64, 128, 38, 54, 118, 32, 96, 32, 64, 64, 224, 21, 86,
  118, 48, 72, 72, 48, 0, 240, 3, 103, 119, 80, 40, 20, 20, 40, 80,
  160, 2, 106, 122, 32, 96, 32, 64, 68, 236, 20, 40, 56, 8, 2, 106,
  122, 32, 96, 32, 64, 72, 244, 4, 24, 32, 56, 2, 106, 122, 96, 16,
  96, 32, 164, 76, 20, 40, 56, 8, 2, 105, 121, 16, 0, 16, 16, 32,
  64, 132, 132, 120, 2, 122, 122, 16, 8, 0, 24, 36, 66, 66, 124, 132,
  132, 2, 122, 122, 8, 16, 0, 24, 36, 66, 66, 124, 132, 132, 2, 122,
  122, 24, 36, 0, 24, 36, 66, 66, 124, 132, 132, 2, 122, 122, 50, 76,
  0, 24, 36, 66, 66, 124, 132, 132, 2, 122, 122, 36, 36, 0, 24, 36,
  66, 66, 124, 132, 132, 2, 122, 122, 24, 36, 24, 24, 36, 66, 66, 124,
  132, 132, 2, 121, 121, 46, 80, 80, 80, 124, 160, 160, 160, 188, 0, 123,
  123, 60, 66, 64, 64, 64, 128, 128, 132, 120, 16, 32, 2, 122, 122, 16,
  8, 0, 126, 64, 64, 112, 128, 128, 252, 2, 122, 122, 8, 16, 0, 126,
  64, 64, 112, 128, 128, 252, 2, 122, 122, 24, 36, 0, 126, 64, 64, 112,
  128, 128, 252, 2, 122, 122, 36, 36, 0, 126, 64, 64, 112, 128, 128, 252,
  2, 106, 122, 32, 16, 0, 124, 16, 16, 32, 32, 32, 248, 2, 106, 122,
  16, 32, 0, 124, 16, 16, 32, 32, 32, 248, 2, 106, 122, 16, 40, 0,
  124, 16, 16, 32, 32, 32, 248, 2, 106, 122, 68, 68, 0, 124, 16, 16,
  32, 32, 32, 248, 2, 121, 121, 124, 34, 34, 34, 242, 68, 68, 68, 248,
  2, 122, 122, 50, 76, 0, 66, 98, 82, 82, 140, 140, 132, 2, 122, 122,
  16, 8, 0, 60, 66, 66, 132, 132, 132, 120, 2, 122, 122, 8, 16, 0,
  60, 66, 66, 132, 132, 132, 120, 2, 122, 122, 24, 36, 0, 60, 66, 66,
  132, 132, 132, 120, 2, 122, 122, 50, 76, 0, 60, 66, 66, 132, 132, 132,
  120, 2, 122, 122, 36, 36, 0, 60, 66, 66, 132, 132, 132, 120, 3, 118,
  118, 66, 36, 24, 48, 72, 132, 1, 123, 123, 2, 60, 70, 74, 74, 82,
  164, 164, 196, 120, 128, 2, 122, 122, 16, 8, 0, 66, 66, 66, 132, 132,
  132, 120, 2, 122, 122, 8, 16, 0, 66, 66, 66, 132, 132, 132, 120, 2,
  122, 122, 24, 36, 0, 66, 66, 66, 132, 132, 132, 120, 2, 122, 122, 36,
  36, 0, 66, 66, 66, 132, 132, 132, 120, 18, 90, 122, 16, 32, 0, 136,
  136, 80, 32, 32, 64, 64, 2, 121, 121, 64, 124, 66, 66, 66, 124, 128,
  128, 128, 18, 89, 121, 48, 72, 72, 80, 80, 144, 136, 136, 176, 2, 121,
  121, 16, 8, 0, 60, 2, 124, 132, 140, 116, 2, 121, 121, 8, 16, 0,
  60, 2, 124, 132, 140, 116, 2, 121, 121, 24, 36, 0, 60, 2, 124, 132,
  140, 116, 2, 121, 121, 50, 76, 0, 60, 2, 124, 132, 140, 116, 2, 121,
  121, 36, 36, 0, 60, 2, 124, 132, 140, 116, 2, 122, 122, 24, 36, 24,
  0, 60, 2, 124, 132, 140, 116, 2, 118, 118, 52, 10, 124, 144, 148, 104,
  0, 120, 120, 60, 66, 128, 128, 132, 120, 16, 32, 2, 121, 121, 16, 8,
  0, 60, 66, 124, 128, 132, 120, 2, 121, 121, 8, 16, 0, 60, 66, 124,
  128, 132, 120, 2, 121, 121, 24, 36, 0, 60, 66, 124, 128, 132, 120, 2,
  121, 121, 36, 36, 0, 60, 66, 124, 128, 132, 120, 18, 89, 121, 32, 16,
  0, 48, 16, 32, 32, 32, 248, 18, 89, 121, 16, 32, 0, 48, 16, 32,
  32, 32, 248, 18, 89, 121, 48, 72, 0, 48, 16, 32, 32, 32, 248, 18,
  89, 121, 72, 72, 0, 48, 16, 32, 32, 32, 248, 2, 122, 122, 36, 24,
  40, 4, 60, 66, 66, 132, 132, 120, 2, 121, 121, 50, 76, 0, 92, 98,
  66, 132, 132, 132, 2, 121, 121, 16, 8, 0, 60, 66, 66, 132, 132, 120,
  2, 121, 121, 8, 16, 0, 60, 66, 66, 132, 132, 120, 2, 121, 121, 24,
  36, 0, 60, 66, 66, 132, 132, 120, 2, 121, 121, 50, 76, 0, 60, 66,
  66, 132, 132, 120, 2, 121, 121, 36, 36, 0, 60, 66, 66, 132, 132, 120,
  19, 71, 119, 32, 32, 0, 240, 0, 64, 64, 1, 120, 120, 2, 60, 74,
  82, 164, 196, 120, 128, 2, 121, 121, 16, 8, 0, 66, 66, 66, 132, 140,
  116, 2, 121, 121, 8, 16, 0, 66, 66, 66, 132, 140, 116, 2, 121, 121,
  24, 36, 0, 66, 66, 66, 132, 140, 116, 2, 121, 121, 36, 36, 0, 66,
  66, 66, 132, 140, 116, 0, 123, 123, 8, 16, 0, 66, 66, 132, 140, 116,
  4, 132, 120, 0, 122, 122, 64, 64, 92, 98, 66, 132, 196, 184, 128, 128,
  0, 123, 123, 36, 36, 0, 66, 66, 132, 140, 116, 4, 132, 120
};

/*
  Fontname: -Misc-Fixed-Medium-O-Normal--13-120-75-75-C-70-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 7 h=11 x= 3 y=11 dx= 7 dy= 0 ascent=11 len=11
  Font Bounding box     w= 7 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent =10 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_7x13Or[1035] U8G_FONT_SECTION("u8g_font_7x13Or") = {
  1, 7, 13, 0, 254, 9, 1, 96, 2, 208, 32, 127, 254, 11, 254, 10,
  254, 13, 0, 112, 34, 41, 121, 64, 64, 64, 64, 128, 128, 128, 0, 128,
  40, 51, 115, 160, 160, 160, 3, 103, 119, 40, 40, 124, 40, 248, 80, 80,
  3, 103, 119, 16, 60, 80, 56, 40, 240, 32, 2, 121, 121, 34, 82, 36,
  8, 16, 32, 72, 148, 136, 2, 104, 120, 24, 36, 36, 56, 80, 148, 136,
  116, 56, 19, 115, 128, 128, 128, 18, 73, 121, 16, 32, 64, 64, 128, 128,
  64, 64, 32, 18, 73, 121, 64, 32, 32, 16, 16, 32, 32, 64, 128, 20,
  85, 117, 72, 48, 248, 96, 144, 20, 69, 117, 32, 32, 240, 64, 64, 17,
  67, 115, 112, 96, 128, 22, 81, 113, 248, 33, 51, 115, 64, 224, 64, 2,
  105, 121, 4, 4, 8, 16, 16, 32, 64, 128, 128, 2, 121, 121, 24, 36,
  66, 66, 66, 132, 132, 72, 48, 18, 89, 121, 16, 48, 80, 16, 16, 32,
  32, 32, 248, 2, 121, 121, 60, 66, 66, 2, 12, 48, 64, 128, 252, 2,
  121, 121, 126, 2, 4, 8, 24, 4, 4, 132, 120, 2, 105, 121, 4, 12,
  20, 36, 72, 136, 252, 8, 8, 2, 121, 121, 62, 32, 32, 92, 98, 2,
  4, 132, 120, 2, 105, 121, 28, 32, 64, 64, 120, 132, 132, 132, 120, 2,
  105, 121, 252, 4, 8, 16, 32, 64, 64, 128, 128, 2, 121, 121, 60, 66,
  66, 66, 124, 132, 132, 132, 120, 2, 105, 121, 120, 132, 132, 140, 116, 8,
  8, 16, 224, 17, 72, 120, 32, 112, 32, 0, 0, 64, 224, 64, 17, 88,
  120, 16, 56, 16, 0, 0, 112, 96, 128, 18, 89, 121, 8, 16, 32, 64,
  128, 128, 64, 32, 16, 4, 116, 116, 126, 0, 0, 252, 18, 89, 121, 64,
  32, 16, 8, 8, 16, 32, 64, 128, 2, 105, 121, 120, 132, 132, 8, 16,
  32, 32, 0, 32, 2, 121, 121, 60, 66, 66, 78, 82, 172, 148, 128, 120,
  2, 121, 121, 24, 36, 66, 66, 66, 124, 132, 132, 132, 2, 121, 121, 124,
  34, 34, 34, 60, 68, 68, 68, 248, 2, 121, 121, 60, 66, 64, 64, 64,
  128, 128, 132, 120, 2, 121, 121, 124, 34, 34, 34, 34, 68, 68, 68, 248,
  2, 121, 121, 126, 64, 64, 64, 120, 128, 128, 128, 252, 2, 121, 121, 126,
  64, 64, 64, 120, 128, 128, 128, 128, 2, 121, 121, 60, 66, 64, 64, 64,
  156, 132, 140, 116, 2, 121, 121, 66, 66, 66, 66, 124, 132, 132, 132, 132,
  2, 105, 121, 124, 16, 16, 16, 16, 32, 32, 32, 248, 2, 121, 121, 14,
  4, 4, 4, 4, 8, 8, 136, 112, 2, 121, 121, 66, 68, 72, 80, 96,
  160, 144, 136, 132, 2, 105, 121, 64, 64, 64, 64, 64, 128, 128, 128, 252,
  2, 121, 121, 66, 102, 102, 90, 90, 132, 132, 132, 132, 2, 121, 121, 66,
  66, 98, 82, 74, 140, 132, 132, 132, 2, 121, 121, 60, 66, 66, 66, 66,
  132, 132, 132, 120, 2, 121, 121, 124, 66, 66, 66, 124, 128, 128, 128, 128,
  1, 122, 122, 60, 66, 66, 66, 66, 132, 164, 148, 120, 4, 2, 121, 121,
  124, 66, 66, 66, 124, 160, 144, 136, 132, 2, 121, 121, 60, 66, 64, 64,
  56, 4, 4, 132, 120, 18, 89, 121, 248, 32, 32, 32, 32, 64, 64, 64,
  64, 2, 121, 121, 66, 66, 66, 66, 66, 132, 132, 132, 120, 2, 105, 121,
  132, 132, 136, 136, 80, 80, 96, 96, 96, 2, 121, 121, 66, 66, 66, 66,
  90, 180, 204, 204, 132, 2, 121, 121, 66, 68, 36, 40, 16, 40, 72, 68,
  132, 18, 89, 121, 136, 136, 80, 80, 32, 32, 64, 64, 64, 2, 121, 121,
  126, 2, 4, 8, 16, 32, 64, 128, 252, 17, 91, 123, 120, 64, 64, 64,
  64, 64, 128, 128, 128, 128, 240, 18, 73, 121, 128, 128, 64, 64, 32, 32,
  32, 16, 16, 17, 91, 123, 120, 8, 8, 8, 8, 8, 16, 16, 16, 16,
  240, 24, 83, 115, 32, 80, 136, 1, 97, 113, 252, 42, 34, 114, 128, 64,
  2, 118, 118, 60, 2, 124, 132, 140, 116, 2, 121, 121, 64, 64, 64, 92,
  98, 66, 132, 196, 184, 2, 118, 118, 60, 66, 128, 128, 132, 120, 2, 121,
  121, 2, 2, 2, 58, 68, 132, 132, 140, 116, 2, 118, 118, 60, 66, 124,
  128, 132, 120, 2, 105, 121, 56, 68, 64, 64, 240, 64, 128, 128, 128, 0,
  120, 120, 58, 68, 136, 112, 128, 120, 132, 120, 2, 121, 121, 32, 32, 64,
  92, 98, 66, 132, 132, 132, 18, 88, 120, 16, 0, 48, 16, 16, 32, 32,
  248, 0, 106, 122, 4, 0, 12, 4, 4, 8, 8, 136, 136, 112, 2, 105,
  121, 64, 64, 64, 68, 88, 96, 144, 136, 132, 18, 89, 121, 48, 16, 16,
  16, 16, 32, 32, 32, 248, 2, 102, 118, 104, 84, 84, 168, 168, 136, 2,
  118, 118, 92, 98, 66, 132, 132, 132, 2, 118, 118, 60, 66, 66, 132, 132,
  120, 0, 120, 120, 92, 98, 66, 196, 184, 128, 128, 128, 0, 120, 120, 58,
  70, 130, 140, 116, 4, 4, 4, 2, 102, 118, 184, 68, 64, 128, 128, 128,
  2, 118, 118, 60, 66, 32, 24, 132, 120, 18, 88, 120, 64, 64, 240, 64,
  128, 128, 136, 112, 2, 118, 118, 66, 66, 66, 132, 140, 116, 18, 86, 118,
  136, 136, 144, 144, 160, 64, 2, 102, 118, 68, 68, 84, 168, 168, 80, 2,
  118, 118, 66, 36, 24, 48, 72, 132, 0, 120, 120, 66, 66, 132, 140, 116,
  4, 132, 120, 2, 118, 118, 126, 4, 24, 32, 64, 252, 17, 91, 123, 56,
  64, 64, 64, 32, 192, 64, 128, 128, 128, 112, 34, 41, 121, 64, 64, 64,
  64, 64, 128, 128, 128, 128, 1, 107, 123, 112, 8, 8, 8, 16, 28, 32,
  16, 16, 16, 224, 24, 83, 115, 72, 168, 144, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--13-120-75-75-C-70-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 6 h=11 x= 3 y=11 dx= 7 dy= 0 ascent=11 len=11
  Font Bounding box     w= 7 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent =10 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_7x13r[1034] U8G_FONT_SECTION("u8g_font_7x13r") = {
  1, 7, 13, 0, 254, 9, 1, 95, 2, 207, 32, 127, 254, 11, 254, 10,
  254, 13, 0, 112, 50, 25, 121, 128, 128, 128, 128, 128, 128, 128, 0, 128,
  40, 51, 115, 160, 160, 160, 19, 87, 119, 80, 80, 248, 80, 248, 80, 80,
  19, 87, 119, 32, 120, 160, 112, 40, 240, 32, 2, 105, 121, 68, 164, 72,
  16, 16, 32, 72, 148, 136, 2, 103, 119, 96, 144, 144, 96, 148, 136, 116,
  56, 19, 115, 128, 128, 128, 34, 57, 121, 32, 64, 64, 128, 128, 128, 64,
  64, 32, 34, 57, 121, 128, 64, 64, 32, 32, 32, 64, 64, 128, 4, 101,
  117, 72, 48, 252, 48, 72, 20, 85, 117, 32, 32, 248, 32, 32, 17, 67,
  115, 112, 96, 128, 22, 81, 113, 248, 33, 51, 115, 64, 224, 64, 18, 89,
  121, 8, 8, 16, 16, 32, 64, 64, 128, 128, 2, 105, 121, 48, 72, 132,
  132, 132, 132, 132, 72, 48, 18, 89, 121, 32, 96, 160, 32, 32, 32, 32,
  32, 248, 2, 105, 121, 120, 132, 132, 4, 8, 48, 64, 128, 252, 2, 105,
  121, 252, 4, 8, 16, 56, 4, 4, 132, 120, 2, 105, 121, 8, 24, 40,
  72, 136, 136, 252, 8, 8, 2, 105, 121, 252, 128, 128, 184, 196, 4, 4,
  132, 120, 2, 105, 121, 56, 64, 128, 128, 184, 196, 132, 132, 120, 2, 105,
  121, 252, 4, 8, 16, 16, 32, 32, 64, 64, 2, 105, 121, 120, 132, 132,
  132, 120, 132, 132, 132, 120, 2, 105, 121, 120, 132, 132, 140, 116, 4, 4,
  8, 112, 33, 56, 120, 64, 224, 64, 0, 0, 64, 224, 64, 17, 72, 120,
  32, 112, 32, 0, 0, 112, 96, 128, 18, 89, 121, 8, 16, 32, 64, 128,
  64, 32, 16, 8, 4, 100, 116, 252, 0, 0, 252, 18, 89, 121, 128, 64,
  32, 16, 8, 16, 32, 64, 128, 2, 105, 121, 120, 132, 132, 4, 8, 16,
  16, 0, 16, 2, 105, 121, 120, 132, 132, 156, 164, 172, 148, 128, 120, 2,
  105, 121, 48, 72, 132, 132, 132, 252, 132, 132, 132, 2, 105, 121, 248, 68,
  68, 68, 120, 68, 68, 68, 248, 2, 105, 121, 120, 132, 128, 128, 128, 128,
  128, 132, 120, 2, 105, 121, 248, 68, 68, 68, 68, 68, 68, 68, 248, 2,
  105, 121, 252, 128, 128, 128, 240, 128, 128, 128, 252, 2, 105, 121, 252, 128,
  128, 128, 240, 128, 128, 128, 128, 2, 105, 121, 120, 132, 128, 128, 128, 156,
  132, 140, 116, 2, 105, 121, 132, 132, 132, 132, 252, 132, 132, 132, 132, 18,
  89, 121, 248, 32, 32, 32, 32, 32, 32, 32, 248, 2, 105, 121, 28, 8,
  8, 8, 8, 8, 8, 136, 112, 2, 105, 121, 132, 136, 144, 160, 192, 160,
  144, 136, 132, 2, 105, 121, 128, 128, 128, 128, 128, 128, 128, 128, 252, 2,
  105, 121, 132, 204, 204, 180, 180, 132, 132, 132, 132, 2, 105, 121, 132, 132,
  196, 164, 148, 140, 132, 132, 132, 2, 105, 121, 120, 132, 132, 132, 132, 132,
  132, 132, 120, 2, 105, 121, 248, 132, 132, 132, 248, 128, 128, 128, 128, 1,
  106, 122, 120, 132, 132, 132, 132, 132, 164, 148, 120, 4, 2, 105, 121, 248,
  132, 132, 132, 248, 160, 144, 136, 132, 2, 105, 121, 120, 132, 128, 128, 120,
  4, 4, 132, 120, 18, 89, 121, 248, 32, 32, 32, 32, 32, 32, 32, 32,
  2, 105, 121, 132, 132, 132, 132, 132, 132, 132, 132, 120, 2, 105, 121, 132,
  132, 132, 72, 72, 72, 48, 48, 48, 2, 105, 121, 132, 132, 132, 132, 180,
  180, 204, 204, 132, 2, 105, 121, 132, 132, 72, 72, 48, 72, 72, 132, 132,
  18, 89, 121, 136, 136, 80, 80, 32, 32, 32, 32, 32, 2, 105, 121, 252,
  4, 8, 16, 48, 32, 64, 128, 252, 17, 75, 123, 240, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 240, 18, 89, 121, 128, 128, 64, 64, 32, 16, 16,
  8, 8, 17, 75, 123, 240, 16, 16, 16, 16, 16, 16, 16, 16, 16, 240,
  24, 83, 115, 32, 80, 136, 1, 97, 113, 252, 42, 34, 114, 128, 64, 2,
  102, 118, 120, 4, 124, 132, 140, 116, 2, 105, 121, 128, 128, 128, 184, 196,
  132, 132, 196, 184, 2, 102, 118, 120, 132, 128, 128, 132, 120, 2, 105, 121,
  4, 4, 4, 116, 140, 132, 132, 140, 116, 2, 102, 118, 120, 132, 252, 128,
  132, 120, 2, 105, 121, 56, 68, 64, 64, 240, 64, 64, 64, 64, 0, 104,
  120, 116, 136, 136, 112, 128, 120, 132, 120, 2, 105, 121, 128, 128, 128, 184,
  196, 132, 132, 132, 132, 18, 88, 120, 32, 0, 96, 32, 32, 32, 32, 248,
  16, 90, 122, 8, 0, 24, 8, 8, 8, 8, 136, 136, 112, 2, 105, 121,
  128, 128, 128, 136, 144, 224, 144, 136, 132, 18, 89, 121, 96, 32, 32, 32,
  32, 32, 32, 32, 248, 18, 86, 118, 208, 168, 168, 168, 168, 136, 2, 102,
  118, 184, 196, 132, 132, 132, 132, 2, 102, 118, 120, 132, 132, 132, 132, 120,
  0, 104, 120, 184, 196, 132, 196, 184, 128, 128, 128, 0, 104, 120, 116, 140,
  132, 140, 116, 4, 4, 4, 2, 102, 118, 184, 68, 64, 64, 64, 64, 2,
  102, 118, 120, 132, 96, 24, 132, 120, 2, 104, 120, 64, 64, 240, 64, 64,
  64, 68, 56, 2, 102, 118, 132, 132, 132, 132, 140, 116, 18, 86, 118, 136,
  136, 136, 80, 80, 32, 18, 86, 118, 136, 136, 168, 168, 168, 80, 2, 102,
  118, 132, 72, 48, 48, 72, 132, 0, 104, 120, 132, 132, 132, 140, 116, 4,
  132, 120, 2, 102, 118, 252, 8, 16, 32, 64, 252, 17, 91, 123, 56, 64,
  64, 64, 32, 192, 32, 64, 64, 64, 56, 50, 25, 121, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 17, 91, 123, 224, 16, 16, 16, 32, 24, 32, 16,
  16, 16, 224, 24, 83, 115, 72, 168, 144, 255
};

/*
  Fontname: -Misc-Fixed-Bold-R-Normal--14-130-75-75-C-70-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 7 h=14 x= 2 y=12 dx= 7 dy= 0 ascent=12 len=14
  Font Bounding box     w= 7 h=14 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-2
  X Font      ascent =11 descent=-2
  Max Font    ascent =12 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_7x14B[2390] U8G_FONT_SECTION("u8g_font_7x14B") = {
  1, 7, 14, 0, 254, 10, 1, 137, 3, 30, 32, 255, 254, 12, 254, 11,
  254, 14, 0, 112, 34, 42, 122, 192, 192, 192, 192, 192, 192, 192, 0, 192,
  192, 25, 84, 116, 216, 216, 216, 216, 2, 106, 122, 120, 120, 120, 252, 120,
  120, 252, 120, 120, 120, 1, 107, 123, 48, 120, 180, 180, 112, 56, 52, 180,
  180, 120, 48, 2, 106, 122, 108, 220, 216, 112, 16, 32, 56, 108, 236, 216,
  2, 106, 122, 56, 108, 108, 108, 56, 108, 220, 216, 216, 108, 41, 36, 116,
  192, 192, 192, 192, 16, 93, 125, 24, 48, 96, 96, 192, 192, 192, 192, 192,
  96, 96, 48, 24, 16, 93, 125, 192, 96, 48, 48, 24, 24, 24, 24, 24,
  48, 48, 96, 192, 5, 103, 119, 180, 180, 120, 48, 120, 180, 180, 3, 103,
  119, 48, 48, 48, 252, 48, 48, 48, 32, 52, 116, 224, 96, 96, 192, 6,
  97, 113, 252, 34, 34, 114, 192, 192, 0, 109, 125, 12, 12, 12, 24, 24,
  48, 48, 48, 96, 96, 192, 192, 192, 2, 106, 122, 120, 204, 204, 204, 204,
  204, 204, 204, 204, 120, 2, 106, 122, 48, 112, 240, 48, 48, 48, 48, 48,
  48, 252, 2, 106, 122, 120, 204, 204, 12, 24, 24, 48, 96, 192, 252, 2,
  106, 122, 120, 204, 204, 12, 56, 12, 12, 204, 204, 120, 2, 106, 122, 8,
  24, 24, 56, 120, 216, 216, 252, 24, 24, 2, 106, 122, 252, 192, 192, 248,
  204, 12, 12, 204, 204, 120, 2, 106, 122, 56, 108, 204, 192, 248, 204, 204,
  204, 204, 120, 2, 106, 122, 252, 204, 216, 24, 48, 48, 48, 48, 48, 48,
  2, 106, 122, 120, 204, 204, 204, 120, 120, 204, 204, 204, 120, 2, 106, 122,
  120, 204, 204, 204, 204, 124, 12, 204, 216, 112, 35, 39, 119, 192, 192, 0,
  0, 0, 192, 192, 33, 57, 121, 96, 96, 0, 0, 0, 224, 96, 96, 192,
  2, 105, 121, 12, 24, 48, 96, 192, 96, 48, 24, 12, 4, 100, 116, 252,
  0, 0, 252, 2, 105, 121, 192, 96, 48, 24, 12, 24, 48, 96, 192, 2,
  106, 122, 120, 204, 204, 24, 48, 48, 48, 0, 48, 48, 2, 106, 122, 56,
  108, 220, 244, 244, 244, 244, 220, 96, 60, 2, 106, 122, 120, 252, 204, 204,
  204, 204, 252, 204, 204, 204, 2, 106, 122, 248, 204, 204, 200, 248, 204, 204,
  204, 204, 248, 2, 106, 122, 120, 204, 204, 192, 192, 192, 192, 204, 204, 120,
  2, 106, 122, 240, 216, 204, 204, 204, 204, 204, 204, 216, 240, 2, 106, 122,
  252, 192, 192, 192, 248, 192, 192, 192, 192, 252, 2, 106, 122, 252, 192, 192,
  192, 248, 192, 192, 192, 192, 192, 2, 106, 122, 120, 204, 204, 192, 192, 220,
  204, 204, 204, 120, 2, 106, 122, 204, 204, 204, 204, 252, 204, 204, 204, 204,
  204, 2, 106, 122, 252, 48, 48, 48, 48, 48, 48, 48, 48, 252, 2, 106,
  122, 12, 12, 12, 12, 12, 12, 12, 204, 216, 112, 2, 106, 122, 204, 216,
  240, 224, 224, 240, 240, 216, 204, 204, 2, 106, 122, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 252, 2, 106, 122, 132, 204, 204, 252, 252, 204, 204, 204,
  204, 204, 2, 106, 122, 204, 204, 236, 236, 236, 220, 220, 220, 204, 204, 2,
  106, 122, 120, 204, 204, 204, 204, 204, 204, 204, 204, 120, 2, 106, 122, 248,
  204, 204, 204, 204, 248, 192, 192, 192, 192, 0, 108, 124, 120, 204, 204, 204,
  204, 204, 236, 220, 204, 120, 12, 4, 2, 106, 122, 248, 204, 204, 204, 248,
  216, 204, 204, 204, 204, 2, 106, 122, 120, 204, 204, 96, 48, 48, 24, 204,
  204, 120, 2, 106, 122, 252, 48, 48, 48, 48, 48, 48, 48, 48, 48, 2,
  106, 122, 204, 204, 204, 204, 204, 204, 204, 204, 204, 120, 2, 106, 122, 204,
  204, 204, 204, 204, 204, 204, 120, 120, 48, 2, 106, 122, 204, 204, 204, 204,
  204, 252, 252, 252, 252, 72, 2, 106, 122, 204, 204, 120, 120, 48, 48, 120,
  120, 204, 204, 2, 106, 122, 204, 204, 204, 120, 120, 48, 48, 48, 48, 48,
  2, 106, 122, 252, 12, 24, 24, 48, 48, 96, 96, 192, 252, 16, 93, 125,
  248, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 248, 0, 109, 125,
  192, 192, 192, 96, 96, 48, 48, 48, 24, 24, 12, 12, 12, 16, 93, 125,
  248, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 248, 11, 99, 115,
  48, 120, 204, 0, 98, 114, 252, 252, 26, 67, 115, 192, 96, 48, 2, 103,
  119, 120, 204, 28, 108, 204, 204, 124, 2, 106, 122, 192, 192, 192, 248, 204,
  204, 204, 204, 204, 248, 2, 103, 119, 120, 204, 192, 192, 192, 204, 120, 2,
  106, 122, 12, 12, 12, 124, 204, 204, 204, 204, 204, 124, 2, 103, 119, 120,
  204, 204, 252, 192, 204, 120, 2, 106, 122, 24, 60, 48, 48, 252, 48, 48,
  48, 48, 48, 0, 105, 121, 116, 220, 216, 216, 112, 64, 248, 204, 120, 2,
  106, 122, 192, 192, 192, 248, 204, 204, 204, 204, 204, 204, 34, 42, 122, 192,
  192, 0, 192, 192, 192, 192, 192, 192, 192, 16, 92, 124, 24, 24, 0, 24,
  24, 24, 24, 24, 24, 24, 216, 112, 2, 106, 122, 192, 192, 192, 200, 216,
  240, 240, 216, 204, 196, 34, 42, 122, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 2, 103, 119, 216, 252, 252, 252, 252, 252, 204, 2, 103, 119, 248,
  204, 204, 204, 204, 204, 204, 2, 103, 119, 120, 204, 204, 204, 204, 204, 120,
  0, 105, 121, 248, 204, 204, 204, 204, 204, 248, 192, 192, 0, 105, 121, 124,
  204, 204, 204, 204, 204, 124, 12, 12, 2, 103, 119, 248, 204, 204, 192, 192,
  192, 192, 2, 103, 119, 120, 204, 96, 48, 24, 204, 120, 2, 106, 122, 48,
  48, 48, 252, 48, 48, 48, 48, 48, 28, 2, 103, 119, 204, 204, 204, 204,
  204, 204, 124, 2, 103, 119, 204, 204, 204, 120, 120, 48, 48, 2, 103, 119,
  204, 204, 252, 252, 252, 252, 72, 2, 103, 119, 204, 204, 120, 48, 120, 204,
  204, 0, 105, 121, 204, 204, 108, 108, 56, 56, 24, 216, 112, 2, 103, 119,
  252, 12, 24, 48, 96, 192, 252, 16, 93, 125, 56, 96, 96, 96, 96, 96,
  192, 96, 96, 96, 96, 96, 56, 32, 45, 125, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 16, 93, 125, 224, 48, 48, 48, 48, 48,
  24, 48, 48, 48, 48, 48, 224, 9, 100, 116, 68, 244, 188, 136, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 14,
  0, 112, 34, 42, 122, 192, 192, 0, 192, 192, 192, 192, 192, 192, 192, 1,
  105, 121, 48, 124, 180, 176, 176, 176, 180, 124, 48, 2, 105, 121, 56, 108,
  96, 96, 240, 96, 96, 248, 108, 4, 102, 118, 204, 120, 104, 88, 120, 204,
  2, 106, 122, 132, 204, 120, 252, 48, 48, 252, 48, 48, 48, 34, 42, 122,
  192, 192, 192, 192, 0, 0, 192, 192, 192, 192, 2, 107, 123, 120, 204, 96,
  48, 120, 204, 120, 48, 24, 204, 120, 27, 82, 114, 216, 216, 2, 107, 123,
  120, 204, 252, 236, 236, 236, 236, 236, 252, 204, 120, 21, 88, 120, 112, 216,
  120, 216, 216, 120, 0, 248, 2, 103, 119, 28, 60, 120, 240, 120, 60, 28,
  2, 101, 117, 252, 252, 12, 12, 12, 22, 65, 113, 240, 2, 107, 123, 120,
  204, 252, 236, 236, 252, 236, 236, 236, 204, 120, 28, 81, 113, 248, 25, 84,
  116, 112, 216, 216, 112, 2, 102, 118, 48, 48, 252, 48, 48, 252, 22, 87,
  119, 112, 216, 24, 48, 96, 192, 248, 22, 87, 119, 112, 216, 24, 112, 24,
  216, 112, 26, 67, 115, 48, 96, 192, 0, 104, 120, 204, 204, 204, 204, 220,
  252, 192, 192, 0, 108, 124, 124, 236, 236, 236, 236, 108, 44, 44, 44, 44,
  44, 60, 39, 34, 114, 192, 192, 32, 51, 115, 96, 96, 192, 22, 54, 118,
  96, 224, 96, 96, 96, 96, 22, 86, 118, 112, 216, 216, 112, 0, 248, 2,
  103, 119, 224, 112, 56, 28, 56, 112, 224, 2, 106, 122, 100, 236, 104, 120,
  120, 52, 108, 92, 220, 140, 2, 106, 122, 100, 236, 104, 120, 120, 56, 116,
  76, 216, 156, 2, 106, 122, 196, 108, 232, 120, 240, 60, 108, 220, 156, 12,
  0, 107, 123, 96, 96, 0, 96, 96, 96, 96, 96, 204, 204, 120, 2, 108,
  124, 96, 48, 0, 120, 252, 204, 204, 204, 252, 204, 204, 204, 2, 108, 124,
  24, 48, 0, 120, 252, 204, 204, 204, 252, 204, 204, 204, 2, 108, 124, 48,
  120, 0, 120, 252, 204, 204, 204, 252, 204, 204, 204, 2, 108, 124, 104, 176,
  0, 120, 252, 204, 204, 204, 252, 204, 204, 204, 2, 108, 124, 204, 204, 0,
  120, 252, 204, 204, 204, 252, 204, 204, 204, 2, 108, 124, 48, 72, 48, 0,
  120, 252, 204, 204, 252, 204, 204, 204, 2, 122, 122, 126, 216, 216, 216, 220,
  248, 216, 216, 216, 222, 0, 108, 124, 120, 204, 204, 192, 192, 192, 192, 204,
  204, 120, 48, 96, 2, 108, 124, 96, 48, 0, 252, 192, 192, 192, 248, 192,
  192, 192, 252, 2, 108, 124, 24, 48, 0, 252, 192, 192, 192, 248, 192, 192,
  192, 252, 2, 108, 124, 48, 120, 0, 252, 192, 192, 192, 248, 192, 192, 192,
  252, 2, 108, 124, 204, 204, 0, 252, 192, 192, 192, 248, 192, 192, 192, 252,
  2, 108, 124, 96, 48, 0, 252, 48, 48, 48, 48, 48, 48, 48, 252, 2,
  108, 124, 24, 48, 0, 252, 48, 48, 48, 48, 48, 48, 48, 252, 2, 108,
  124, 48, 120, 0, 252, 48, 48, 48, 48, 48, 48, 48, 252, 2, 108, 124,
  204, 204, 0, 252, 48, 48, 48, 48, 48, 48, 48, 252, 2, 122, 122, 120,
  108, 102, 102, 254, 102, 102, 102, 108, 120, 2, 108, 124, 104, 176, 0, 204,
  236, 236, 236, 220, 220, 220, 204, 204, 2, 108, 124, 96, 48, 0, 120, 204,
  204, 204, 204, 204, 204, 204, 120, 2, 108, 124, 24, 48, 0, 120, 204, 204,
  204, 204, 204, 204, 204, 120, 2, 108, 124, 48, 120, 0, 120, 204, 204, 204,
  204, 204, 204, 204, 120, 2, 108, 124, 104, 176, 0, 120, 204, 204, 204, 204,
  204, 204, 204, 120, 2, 108, 124, 204, 204, 0, 120, 204, 204, 204, 204, 204,
  204, 204, 120, 2, 119, 119, 198, 108, 56, 56, 108, 198, 130, 0, 110, 126,
  4, 4, 120, 220, 220, 220, 220, 236, 236, 236, 236, 120, 128, 128, 2, 108,
  124, 96, 48, 0, 204, 204, 204, 204, 204, 204, 204, 204, 120, 2, 108, 124,
  24, 48, 0, 204, 204, 204, 204, 204, 204, 204, 204, 120, 2, 108, 124, 48,
  120, 0, 204, 204, 204, 204, 204, 204, 204, 204, 120, 2, 108, 124, 204, 204,
  0, 204, 204, 204, 204, 204, 204, 204, 204, 120, 2, 108, 124, 24, 48, 0,
  204, 204, 204, 120, 120, 120, 48, 48, 48, 2, 106, 122, 192, 192, 248, 204,
  204, 204, 204, 248, 192, 192, 2, 106, 122, 56, 108, 108, 108, 120, 108, 108,
  108, 108, 248, 2, 106, 122, 96, 48, 0, 120, 204, 60, 108, 204, 204, 124,
  2, 106, 122, 24, 48, 0, 120, 204, 60, 108, 204, 204, 124, 2, 106, 122,
  48, 120, 0, 120, 204, 60, 108, 204, 204, 124, 2, 106, 122, 104, 176, 0,
  120, 204, 60, 108, 204, 204, 124, 2, 106, 122, 204, 204, 0, 120, 204, 60,
  108, 204, 204, 124, 2, 107, 123, 48, 72, 48, 0, 120, 204, 60, 108, 204,
  204, 124, 2, 119, 119, 124, 218, 58, 94, 216, 222, 124, 0, 105, 121, 120,
  204, 192, 192, 192, 204, 120, 48, 96, 2, 106, 122, 96, 48, 0, 120, 204,
  204, 252, 192, 204, 120, 2, 106, 122, 24, 48, 0, 120, 204, 204, 252, 192,
  204, 120, 2, 106, 122, 48, 120, 0, 120, 204, 204, 252, 192, 204, 120, 2,
  106, 122, 204, 204, 0, 120, 204, 204, 252, 192, 204, 120, 34, 58, 122, 192,
  96, 0, 96, 96, 96, 96, 96, 96, 96, 34, 58, 122, 96, 192, 0, 192,
  192, 192, 192, 192, 192, 192, 18, 74, 122, 96, 240, 0, 96, 96, 96, 96,
  96, 96, 96, 2, 106, 122, 204, 204, 0, 48, 48, 48, 48, 48, 48, 48,
  2, 107, 123, 216, 112, 240, 152, 12, 124, 204, 204, 204, 204, 120, 2, 106,
  122, 104, 176, 0, 248, 204, 204, 204, 204, 204, 204, 2, 106, 122, 96, 48,
  0, 120, 204, 204, 204, 204, 204, 120, 2, 106, 122, 24, 48, 0, 120, 204,
  204, 204, 204, 204, 120, 2, 106, 122, 48, 120, 0, 120, 204, 204, 204, 204,
  204, 120, 2, 106, 122, 104, 176, 0, 120, 204, 204, 204, 204, 204, 120, 2,
  106, 122, 204, 204, 0, 120, 204, 204, 204, 204, 204, 120, 2, 104, 120, 48,
  48, 0, 252, 252, 0, 48, 48, 0, 107, 123, 4, 8, 120, 220, 220, 236,
  236, 204, 120, 128, 128, 2, 106, 122, 96, 48, 0, 204, 204, 204, 204, 204,
  204, 124, 2, 106, 122, 24, 48, 0, 204, 204, 204, 204, 204, 204, 124, 2,
  106, 122, 48, 120, 0, 204, 204, 204, 204, 204, 204, 124, 2, 106, 122, 204,
  204, 0, 204, 204, 204, 204, 204, 204, 124, 0, 108, 124, 24, 48, 0, 204,
  204, 204, 120, 56, 56, 48, 240, 96, 0, 108, 124, 192, 192, 192, 248, 204,
  204, 204, 204, 204, 248, 192, 192, 0, 108, 124, 204, 204, 0, 204, 204, 204,
  120, 56, 56, 48, 240, 96
};

/*
  Fontname: -Misc-Fixed-Bold-R-Normal--14-130-75-75-C-70-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 6 h=13 x= 2 y=12 dx= 7 dy= 0 ascent=12 len=13
  Font Bounding box     w= 7 h=14 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-2
  X Font      ascent =11 descent=-2
  Max Font    ascent =12 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_7x14Br[1151] U8G_FONT_SECTION("u8g_font_7x14Br") = {
  1, 7, 14, 0, 254, 10, 1, 137, 3, 30, 32, 127, 254, 12, 254, 11,
  254, 14, 0, 112, 34, 42, 122, 192, 192, 192, 192, 192, 192, 192, 0, 192,
  192, 25, 84, 116, 216, 216, 216, 216, 2, 106, 122, 120, 120, 120, 252, 120,
  120, 252, 120, 120, 120, 1, 107, 123, 48, 120, 180, 180, 112, 56, 52, 180,
  180, 120, 48, 2, 106, 122, 108, 220, 216, 112, 16, 32, 56, 108, 236, 216,
  2, 106, 122, 56, 108, 108, 108, 56, 108, 220, 216, 216, 108, 41, 36, 116,
  192, 192, 192, 192, 16, 93, 125, 24, 48, 96, 96, 192, 192, 192, 192, 192,
  96, 96, 48, 24, 16, 93, 125, 192, 96, 48, 48, 24, 24, 24, 24, 24,
  48, 48, 96, 192, 5, 103, 119, 180, 180, 120, 48, 120, 180, 180, 3, 103,
  119, 48, 48, 48, 252, 48, 48, 48, 32, 52, 116, 224, 96, 96, 192, 6,
  97, 113, 252, 34, 34, 114, 192, 192, 0, 109, 125, 12, 12, 12, 24, 24,
  48, 48, 48, 96, 96, 192, 192, 192, 2, 106, 122, 120, 204, 204, 204, 204,
  204, 204, 204, 204, 120, 2, 106, 122, 48, 112, 240, 48, 48, 48, 48, 48,
  48, 252, 2, 106, 122, 120, 204, 204, 12, 24, 24, 48, 96, 192, 252, 2,
  106, 122, 120, 204, 204, 12, 56, 12, 12, 204, 204, 120, 2, 106, 122, 8,
  24, 24, 56, 120, 216, 216, 252, 24, 24, 2, 106, 122, 252, 192, 192, 248,
  204, 12, 12, 204, 204, 120, 2, 106, 122, 56, 108, 204, 192, 248, 204, 204,
  204, 204, 120, 2, 106, 122, 252, 204, 216, 24, 48, 48, 48, 48, 48, 48,
  2, 106, 122, 120, 204, 204, 204, 120, 120, 204, 204, 204, 120, 2, 106, 122,
  120, 204, 204, 204, 204, 124, 12, 204, 216, 112, 35, 39, 119, 192, 192, 0,
  0, 0, 192, 192, 33, 57, 121, 96, 96, 0, 0, 0, 224, 96, 96, 192,
  2, 105, 121, 12, 24, 48, 96, 192, 96, 48, 24, 12, 4, 100, 116, 252,
  0, 0, 252, 2, 105, 121, 192, 96, 48, 24, 12, 24, 48, 96, 192, 2,
  106, 122, 120, 204, 204, 24, 48, 48, 48, 0, 48, 48, 2, 106, 122, 56,
  108, 220, 244, 244, 244, 244, 220, 96, 60, 2, 106, 122, 120, 252, 204, 204,
  204, 204, 252, 204, 204, 204, 2, 106, 122, 248, 204, 204, 200, 248, 204, 204,
  204, 204, 248, 2, 106, 122, 120, 204, 204, 192, 192, 192, 192, 204, 204, 120,
  2, 106, 122, 240, 216, 204, 204, 204, 204, 204, 204, 216, 240, 2, 106, 122,
  252, 192, 192, 192, 248, 192, 192, 192, 192, 252, 2, 106, 122, 252, 192, 192,
  192, 248, 192, 192, 192, 192, 192, 2, 106, 122, 120, 204, 204, 192, 192, 220,
  204, 204, 204, 120, 2, 106, 122, 204, 204, 204, 204, 252, 204, 204, 204, 204,
  204, 2, 106, 122, 252, 48, 48, 48, 48, 48, 48, 48, 48, 252, 2, 106,
  122, 12, 12, 12, 12, 12, 12, 12, 204, 216, 112, 2, 106, 122, 204, 216,
  240, 224, 224, 240, 240, 216, 204, 204, 2, 106, 122, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 252, 2, 106, 122, 132, 204, 204, 252, 252, 204, 204, 204,
  204, 204, 2, 106, 122, 204, 204, 236, 236, 236, 220, 220, 220, 204, 204, 2,
  106, 122, 120, 204, 204, 204, 204, 204, 204, 204, 204, 120, 2, 106, 122, 248,
  204, 204, 204, 204, 248, 192, 192, 192, 192, 0, 108, 124, 120, 204, 204, 204,
  204, 204, 236, 220, 204, 120, 12, 4, 2, 106, 122, 248, 204, 204, 204, 248,
  216, 204, 204, 204, 204, 2, 106, 122, 120, 204, 204, 96, 48, 48, 24, 204,
  204, 120, 2, 106, 122, 252, 48, 48, 48, 48, 48, 48, 48, 48, 48, 2,
  106, 122, 204, 204, 204, 204, 204, 204, 204, 204, 204, 120, 2, 106, 122, 204,
  204, 204, 204, 204, 204, 204, 120, 120, 48, 2, 106, 122, 204, 204, 204, 204,
  204, 252, 252, 252, 252, 72, 2, 106, 122, 204, 204, 120, 120, 48, 48, 120,
  120, 204, 204, 2, 106, 122, 204, 204, 204, 120, 120, 48, 48, 48, 48, 48,
  2, 106, 122, 252, 12, 24, 24, 48, 48, 96, 96, 192, 252, 16, 93, 125,
  248, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 248, 0, 109, 125,
  192, 192, 192, 96, 96, 48, 48, 48, 24, 24, 12, 12, 12, 16, 93, 125,
  248, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 248, 11, 99, 115,
  48, 120, 204, 0, 98, 114, 252, 252, 26, 67, 115, 192, 96, 48, 2, 103,
  119, 120, 204, 28, 108, 204, 204, 124, 2, 106, 122, 192, 192, 192, 248, 204,
  204, 204, 204, 204, 248, 2, 103, 119, 120, 204, 192, 192, 192, 204, 120, 2,
  106, 122, 12, 12, 12, 124, 204, 204, 204, 204, 204, 124, 2, 103, 119, 120,
  204, 204, 252, 192, 204, 120, 2, 106, 122, 24, 60, 48, 48, 252, 48, 48,
  48, 48, 48, 0, 105, 121, 116, 220, 216, 216, 112, 64, 248, 204, 120, 2,
  106, 122, 192, 192, 192, 248, 204, 204, 204, 204, 204, 204, 34, 42, 122, 192,
  192, 0, 192, 192, 192, 192, 192, 192, 192, 16, 92, 124, 24, 24, 0, 24,
  24, 24, 24, 24, 24, 24, 216, 112, 2, 106, 122, 192, 192, 192, 200, 216,
  240, 240, 216, 204, 196, 34, 42, 122, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 2, 103, 119, 216, 252, 252, 252, 252, 252, 204, 2, 103, 119, 248,
  204, 204, 204, 204, 204, 204, 2, 103, 119, 120, 204, 204, 204, 204, 204, 120,
  0, 105, 121, 248, 204, 204, 204, 204, 204, 248, 192, 192, 0, 105, 121, 124,
  204, 204, 204, 204, 204, 124, 12, 12, 2, 103, 119, 248, 204, 204, 192, 192,
  192, 192, 2, 103, 119, 120, 204, 96, 48, 24, 204, 120, 2, 106, 122, 48,
  48, 48, 252, 48, 48, 48, 48, 48, 28, 2, 103, 119, 204, 204, 204, 204,
  204, 204, 124, 2, 103, 119, 204, 204, 204, 120, 120, 48, 48, 2, 103, 119,
  204, 204, 252, 252, 252, 252, 72, 2, 103, 119, 204, 204, 120, 48, 120, 204,
  204, 0, 105, 121, 204, 204, 108, 108, 56, 56, 24, 216, 112, 2, 103, 119,
  252, 12, 24, 48, 96, 192, 252, 16, 93, 125, 56, 96, 96, 96, 96, 96,
  192, 96, 96, 96, 96, 96, 56, 32, 45, 125, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 16, 93, 125, 224, 48, 48, 48, 48, 48,
  24, 48, 48, 48, 48, 48, 224, 9, 100, 116, 68, 244, 188, 136, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--14-130-75-75-C-70-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 7 h=14 x= 3 y=12 dx= 7 dy= 0 ascent=12 len=14
  Font Bounding box     w= 7 h=14 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-2
  X Font      ascent =11 descent=-2
  Max Font    ascent =12 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_7x14[2374] U8G_FONT_SECTION("u8g_font_7x14") = {
  1, 7, 14, 0, 254, 10, 1, 138, 3, 30, 32, 255, 254, 12, 254, 11,
  254, 14, 0, 112, 50, 26, 122, 128, 128, 128, 128, 128, 128, 128, 0, 128,
  128, 41, 52, 116, 160, 160, 160, 160, 18, 90, 122, 80, 80, 80, 248, 80,
  80, 248, 80, 80, 80, 1, 107, 123, 16, 120, 148, 148, 80, 56, 20, 148,
  148, 120, 16, 2, 106, 122, 100, 148, 152, 112, 16, 32, 56, 100, 164, 152,
  2, 106, 122, 48, 72, 72, 72, 48, 100, 148, 136, 152, 100, 57, 20, 116,
  128, 128, 128, 128, 32, 77, 125, 16, 32, 64, 64, 128, 128, 128, 128, 128,
  64, 64, 32, 16, 16, 77, 125, 128, 64, 32, 32, 16, 16, 16, 16, 16,
  32, 32, 64, 128, 19, 87, 119, 32, 168, 112, 32, 112, 168, 32, 19, 87,
  119, 32, 32, 32, 248, 32, 32, 32, 32, 36, 116, 192, 64, 64, 128, 22,
  81, 113, 248, 33, 51, 115, 64, 224, 64, 0, 109, 125, 4, 4, 8, 8,
  16, 16, 16, 32, 32, 64, 64, 128, 128, 2, 106, 122, 48, 72, 132, 132,
  132, 132, 132, 132, 72, 48, 18, 90, 122, 32, 96, 160, 32, 32, 32, 32,
  32, 32, 248, 2, 106, 122, 120, 132, 132, 4, 8, 8, 16, 32, 64, 252,
  2, 106, 122, 252, 4, 8, 16, 56, 4, 4, 132, 132, 120, 2, 106, 122,
  8, 24, 40, 40, 72, 72, 136, 252, 8, 8, 2, 106, 122, 252, 128, 128,
  248, 132, 4, 4, 132, 132, 120, 2, 106, 122, 56, 64, 128, 128, 184, 196,
  132, 132, 132, 120, 2, 106, 122, 252, 4, 8, 8, 16, 16, 32, 32, 64,
  64, 2, 106, 122, 120, 132, 132, 72, 48, 72, 132, 132, 132, 120, 2, 106,
  122, 120, 132, 132, 132, 140, 116, 4, 132, 136, 112, 34, 56, 120, 64, 224,
  64, 0, 0, 64, 224, 64, 33, 40, 120, 192, 192, 0, 0, 192, 64, 64,
  128, 18, 89, 121, 8, 16, 32, 64, 128, 64, 32, 16, 8, 5, 100, 116,
  252, 0, 0, 252, 18, 89, 121, 128, 64, 32, 16, 8, 16, 32, 64, 128,
  2, 106, 122, 120, 132, 132, 8, 16, 16, 16, 0, 16, 16, 2, 106, 122,
  56, 68, 156, 164, 164, 164, 164, 156, 64, 60, 2, 106, 122, 48, 72, 132,
  132, 132, 252, 132, 132, 132, 132, 2, 106, 122, 240, 136, 132, 136, 240, 136,
  132, 132, 136, 240, 2, 106, 122, 120, 132, 132, 128, 128, 128, 128, 132, 132,
  120, 2, 106, 122, 240, 136, 132, 132, 132, 132, 132, 132, 136, 240, 2, 106,
  122, 252, 128, 128, 128, 240, 128, 128, 128, 128, 252, 2, 106, 122, 252, 128,
  128, 128, 240, 128, 128, 128, 128, 128, 2, 106, 122, 120, 132, 132, 128, 128,
  156, 132, 132, 140, 116, 2, 106, 122, 132, 132, 132, 132, 252, 132, 132, 132,
  132, 132, 18, 90, 122, 248, 32, 32, 32, 32, 32, 32, 32, 32, 248, 2,
  106, 122, 28, 8, 8, 8, 8, 8, 8, 136, 136, 112, 2, 106, 122, 132,
  136, 144, 160, 192, 160, 144, 136, 132, 132, 2, 106, 122, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 252, 2, 106, 122, 132, 204, 204, 180, 180, 132, 132,
  132, 132, 132, 2, 106, 122, 132, 132, 196, 196, 164, 148, 140, 140, 132, 132,
  2, 106, 122, 120, 132, 132, 132, 132, 132, 132, 132, 132, 120, 2, 106, 122,
  248, 132, 132, 132, 132, 248, 128, 128, 128, 128, 0, 108, 124, 120, 132, 132,
  132, 132, 132, 228, 148, 140, 120, 8, 4, 2, 106, 122, 248, 132, 132, 132,
  132, 248, 144, 136, 132, 132, 2, 106, 122, 120, 132, 132, 128, 96, 24, 4,
  132, 132, 120, 2, 122, 122, 254, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  2, 106, 122, 132, 132, 132, 132, 132, 132, 132, 132, 132, 120, 2, 106, 122,
  132, 132, 132, 132, 72, 72, 72, 48, 48, 48, 18, 90, 122, 136, 136, 136,
  136, 136, 136, 168, 168, 168, 80, 2, 106, 122, 132, 132, 72, 72, 48, 48,
  72, 72, 132, 132, 18, 90, 122, 136, 136, 136, 80, 80, 32, 32, 32, 32,
  32, 2, 106, 122, 252, 4, 8, 16, 16, 32, 64, 64, 128, 252, 32, 77,
  125, 240, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 240, 0, 109,
  125, 128, 128, 64, 64, 32, 32, 32, 16, 16, 8, 8, 4, 4, 16, 77,
  125, 240, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 240, 10, 99,
  115, 48, 72, 132, 0, 97, 113, 252, 42, 51, 115, 128, 64, 32, 2, 103,
  119, 120, 132, 4, 124, 132, 132, 124, 2, 106, 122, 128, 128, 128, 184, 196,
  132, 132, 132, 196, 184, 2, 103, 119, 120, 132, 128, 128, 128, 132, 120, 2,
  106, 122, 4, 4, 4, 116, 140, 132, 132, 132, 140, 116, 2, 103, 119, 120,
  132, 132, 252, 128, 132, 120, 2, 106, 122, 24, 36, 32, 32, 248, 32, 32,
  32, 32, 32, 0, 105, 121, 116, 136, 136, 136, 112, 64, 184, 132, 120, 2,
  106, 122, 128, 128, 128, 184, 196, 132, 132, 132, 132, 132, 18, 90, 122, 32,
  32, 0, 96, 32, 32, 32, 32, 32, 248, 16, 92, 124, 8, 8, 0, 24,
  8, 8, 8, 8, 8, 136, 136, 112, 2, 106, 122, 128, 128, 128, 136, 144,
  160, 224, 144, 136, 132, 18, 90, 122, 96, 32, 32, 32, 32, 32, 32, 32,
  32, 248, 18, 87, 119, 208, 168, 168, 168, 168, 168, 136, 2, 103, 119, 184,
  196, 132, 132, 132, 132, 132, 2, 103, 119, 120, 132, 132, 132, 132, 132, 120,
  0, 105, 121, 184, 196, 132, 132, 132, 196, 184, 128, 128, 0, 105, 121, 116,
  140, 132, 132, 132, 140, 116, 4, 4, 2, 103, 119, 184, 196, 132, 128, 128,
  128, 128, 2, 103, 119, 120, 132, 64, 48, 8, 132, 120, 2, 106, 122, 32,
  32, 32, 248, 32, 32, 32, 32, 36, 24, 2, 103, 119, 132, 132, 132, 132,
  132, 140, 116, 18, 87, 119, 136, 136, 136, 80, 80, 32, 32, 18, 87, 119,
  136, 136, 168, 168, 168, 168, 80, 2, 103, 119, 132, 132, 72, 48, 72, 132,
  132, 0, 105, 121, 132, 132, 132, 132, 140, 116, 4, 132, 120, 2, 103, 119,
  252, 8, 16, 32, 32, 64, 252, 32, 77, 125, 48, 64, 64, 64, 64, 64,
  128, 64, 64, 64, 64, 64, 48, 48, 29, 125, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 16, 77, 125, 192, 32, 32, 32, 32, 32,
  16, 32, 32, 32, 32, 32, 192, 9, 100, 116, 64, 164, 148, 8, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 14,
  0, 112, 50, 26, 122, 128, 128, 0, 128, 128, 128, 128, 128, 128, 128, 1,
  105, 121, 32, 120, 164, 160, 160, 160, 164, 120, 32, 18, 89, 121, 48, 72,
  64, 64, 240, 64, 64, 240, 72, 4, 102, 118, 132, 120, 72, 72, 120, 132,
  18, 90, 122, 136, 80, 80, 32, 248, 32, 248, 32, 32, 32, 50, 26, 122,
  128, 128, 128, 128, 0, 0, 128, 128, 128, 128, 2, 107, 123, 120, 132, 64,
  48, 72, 132, 72, 48, 8, 132, 120, 27, 66, 114, 144, 144, 2, 107, 123,
  120, 132, 180, 204, 196, 196, 196, 204, 180, 132, 120, 21, 88, 120, 112, 136,
  120, 136, 152, 104, 0, 248, 2, 103, 119, 20, 40, 80, 160, 80, 40, 20,
  18, 84, 116, 248, 8, 8, 8, 22, 65, 113, 240, 2, 107, 123, 120, 132,
  244, 204, 204, 244, 204, 204, 204, 132, 120, 27, 81, 113, 248, 25, 68, 116,
  96, 144, 144, 96, 18, 86, 118, 32, 32, 248, 32, 32, 248, 22, 71, 119,
  96, 144, 16, 32, 64, 128, 240, 22, 71, 119, 96, 144, 16, 96, 16, 144,
  96, 42, 51, 115, 32, 64, 128, 16, 88, 120, 136, 136, 136, 136, 216, 168,
  128, 128, 16, 92, 124, 120, 168, 168, 168, 168, 104, 40, 40, 40, 40, 40,
  56, 55, 17, 113, 128, 32, 35, 115, 64, 64, 128, 38, 55, 119, 64, 192,
  64, 64, 64, 64, 224, 22, 70, 118, 96, 144, 144, 96, 0, 240, 2, 103,
  119, 160, 80, 40, 20, 40, 80, 160, 2, 106, 122, 64, 196, 72, 72, 80,
  36, 44, 84, 156, 132, 2, 106, 122, 64, 196, 72, 72, 80, 40, 52, 68,
  136, 156, 2, 106, 122, 196, 36, 72, 48, 208, 36, 76, 84, 156, 4, 0,
  107, 123, 32, 32, 0, 32, 32, 32, 32, 64, 132, 132, 120, 2, 108, 124,
  32, 16, 0, 48, 72, 132, 132, 252, 132, 132, 132, 132, 2, 108, 124, 16,
  32, 0, 48, 72, 132, 132, 252, 132, 132, 132, 132, 2, 108, 124, 48, 72,
  0, 48, 72, 132, 132, 252, 132, 132, 132, 132, 2, 108, 124, 100, 152, 0,
  48, 72, 132, 132, 252, 132, 132, 132, 132, 2, 107, 123, 72, 0, 48, 72,
  132, 132, 252, 132, 132, 132, 132, 2, 107, 123, 48, 72, 48, 72, 132, 132,
  252, 132, 132, 132, 132, 2, 106, 122, 60, 80, 144, 144, 252, 144, 144, 144,
  144, 156, 0, 108, 124, 120, 132, 132, 128, 128, 128, 128, 132, 132, 120, 16,
  32, 2, 108, 124, 32, 16, 0, 252, 128, 128, 128, 248, 128, 128, 128, 252,
  2, 108, 124, 16, 32, 0, 252, 128, 128, 128, 248, 128, 128, 128, 252, 2,
  108, 124, 48, 72, 0, 252, 128, 128, 128, 248, 128, 128, 128, 252, 2, 107,
  123, 72, 0, 252, 128, 128, 128, 248, 128, 128, 128, 252, 18, 92, 124, 64,
  32, 0, 248, 32, 32, 32, 32, 32, 32, 32, 248, 18, 92, 124, 16, 32,
  0, 248, 32, 32, 32, 32, 32, 32, 32, 248, 18, 92, 124, 32, 80, 0,
  248, 32, 32, 32, 32, 32, 32, 32, 248, 18, 91, 123, 80, 0, 248, 32,
  32, 32, 32, 32, 32, 32, 248, 2, 122, 122, 120, 68, 66, 66, 242, 66,
  66, 66, 68, 120, 2, 108, 124, 100, 152, 0, 196, 196, 164, 164, 148, 148,
  148, 140, 140, 2, 108, 124, 32, 16, 0, 120, 132, 132, 132, 132, 132, 132,
  132, 120, 2, 108, 124, 16, 32, 0, 120, 132, 132, 132, 132, 132, 132, 132,
  120, 2, 108, 124, 48, 72, 0, 120, 132, 132, 132, 132, 132, 132, 132, 120,
  2, 108, 124, 100, 152, 0, 120, 132, 132, 132, 132, 132, 132, 132, 120, 2,
  107, 123, 72, 0, 120, 132, 132, 132, 132, 132, 132, 132, 120, 2, 119, 119,
  130, 68, 40, 16, 40, 68, 130, 0, 110, 126, 4, 4, 120, 140, 148, 148,
  148, 164, 164, 164, 196, 120, 128, 128, 2, 108, 124, 32, 16, 0, 132, 132,
  132, 132, 132, 132, 132, 132, 120, 2, 108, 124, 16, 32, 0, 132, 132, 132,
  132, 132, 132, 132, 132, 120, 2, 108, 124, 48, 72, 0, 132, 132, 132, 132,
  132, 132, 132, 132, 120, 2, 107, 123, 72, 0, 132, 132, 132, 132, 132, 132,
  132, 132, 120, 18, 92, 124, 16, 32, 0, 136, 136, 80, 80, 32, 32, 32,
  32, 32, 2, 106, 122, 128, 128, 248, 132, 132, 132, 132, 248, 128, 128, 2,
  106, 122, 48, 72, 72, 72, 112, 72, 68, 68, 68, 248, 2, 106, 122, 32,
  16, 0, 120, 132, 4, 124, 132, 132, 124, 2, 106, 122, 8, 16, 0, 120,
  132, 4, 124, 132, 132, 124, 2, 106, 122, 48, 72, 0, 120, 132, 4, 124,
  132, 132, 124, 2, 106, 122, 100, 152, 0, 120, 132, 4, 124, 132, 132, 124,
  2, 105, 121, 72, 0, 120, 132, 4, 124, 132, 132, 124, 2, 107, 123, 48,
  72, 48, 0, 120, 132, 4, 124, 132, 132, 124, 2, 119, 119, 124, 146, 50,
  94, 144, 146, 124, 0, 105, 121, 120, 132, 128, 128, 128, 132, 120, 16, 32,
  2, 106, 122, 32, 16, 0, 120, 132, 132, 252, 128, 132, 120, 2, 106, 122,
  16, 32, 0, 120, 132, 132, 252, 128, 132, 120, 2, 106, 122, 48, 72, 0,
  120, 132, 132, 252, 128, 132, 120, 2, 105, 121, 72, 0, 120, 132, 132, 252,
  128, 132, 120, 18, 90, 122, 64, 32, 0, 96, 32, 32, 32, 32, 32, 248,
  18, 90, 122, 16, 32, 0, 96, 32, 32, 32, 32, 32, 248, 18, 90, 122,
  96, 144, 0, 96, 32, 32, 32, 32, 32, 248, 18, 89, 121, 80, 0, 96,
  32, 32, 32, 32, 32, 248, 18, 91, 123, 80, 32, 80, 8, 120, 136, 136,
  136, 136, 136, 112, 2, 106, 122, 100, 152, 0, 184, 196, 132, 132, 132, 132,
  132, 2, 106, 122, 32, 16, 0, 120, 132, 132, 132, 132, 132, 120, 2, 106,
  122, 16, 32, 0, 120, 132, 132, 132, 132, 132, 120, 2, 106, 122, 48, 72,
  0, 120, 132, 132, 132, 132, 132, 120, 2, 106, 122, 100, 152, 0, 120, 132,
  132, 132, 132, 132, 120, 2, 105, 121, 72, 0, 120, 132, 132, 132, 132, 132,
  120, 2, 101, 117, 48, 0, 252, 0, 48, 0, 107, 123, 4, 8, 120, 148,
  148, 164, 164, 196, 120, 128, 128, 2, 106, 122, 32, 16, 0, 132, 132, 132,
  132, 132, 140, 116, 2, 106, 122, 16, 32, 0, 132, 132, 132, 132, 132, 140,
  116, 2, 106, 122, 48, 72, 0, 132, 132, 132, 132, 132, 140, 116, 2, 105,
  121, 72, 0, 132, 132, 132, 132, 132, 140, 116, 0, 108, 124, 16, 32, 0,
  132, 132, 68, 72, 40, 56, 16, 144, 96, 0, 108, 124, 128, 128, 128, 184,
  196, 132, 132, 132, 196, 184, 128, 128, 0, 107, 123, 72, 0, 132, 132, 68,
  72, 40, 56, 16, 144, 96
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--14-130-75-75-C-70-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 7 h=13 x= 3 y=12 dx= 7 dy= 0 ascent=12 len=13
  Font Bounding box     w= 7 h=14 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-2
  X Font      ascent =11 descent=-2
  Max Font    ascent =12 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_7x14r[1151] U8G_FONT_SECTION("u8g_font_7x14r") = {
  1, 7, 14, 0, 254, 10, 1, 138, 3, 30, 32, 127, 254, 12, 254, 11,
  254, 14, 0, 112, 50, 26, 122, 128, 128, 128, 128, 128, 128, 128, 0, 128,
  128, 41, 52, 116, 160, 160, 160, 160, 18, 90, 122, 80, 80, 80, 248, 80,
  80, 248, 80, 80, 80, 1, 107, 123, 16, 120, 148, 148, 80, 56, 20, 148,
  148, 120, 16, 2, 106, 122, 100, 148, 152, 112, 16, 32, 56, 100, 164, 152,
  2, 106, 122, 48, 72, 72, 72, 48, 100, 148, 136, 152, 100, 57, 20, 116,
  128, 128, 128, 128, 32, 77, 125, 16, 32, 64, 64, 128, 128, 128, 128, 128,
  64, 64, 32, 16, 16, 77, 125, 128, 64, 32, 32, 16, 16, 16, 16, 16,
  32, 32, 64, 128, 19, 87, 119, 32, 168, 112, 32, 112, 168, 32, 19, 87,
  119, 32, 32, 32, 248, 32, 32, 32, 32, 36, 116, 192, 64, 64, 128, 22,
  81, 113, 248, 33, 51, 115, 64, 224, 64, 0, 109, 125, 4, 4, 8, 8,
  16, 16, 16, 32, 32, 64, 64, 128, 128, 2, 106, 122, 48, 72, 132, 132,
  132, 132, 132, 132, 72, 48, 18, 90, 122, 32, 96, 160, 32, 32, 32, 32,
  32, 32, 248, 2, 106, 122, 120, 132, 132, 4, 8, 8, 16, 32, 64, 252,
  2, 106, 122, 252, 4, 8, 16, 56, 4, 4, 132, 132, 120, 2, 106, 122,
  8, 24, 40, 40, 72, 72, 136, 252, 8, 8, 2, 106, 122, 252, 128, 128,
  248, 132, 4, 4, 132, 132, 120, 2, 106, 122, 56, 64, 128, 128, 184, 196,
  132, 132, 132, 120, 2, 106, 122, 252, 4, 8, 8, 16, 16, 32, 32, 64,
  64, 2, 106, 122, 120, 132, 132, 72, 48, 72, 132, 132, 132, 120, 2, 106,
  122, 120, 132, 132, 132, 140, 116, 4, 132, 136, 112, 34, 56, 120, 64, 224,
  64, 0, 0, 64, 224, 64, 33, 40, 120, 192, 192, 0, 0, 192, 64, 64,
  128, 18, 89, 121, 8, 16, 32, 64, 128, 64, 32, 16, 8, 5, 100, 116,
  252, 0, 0, 252, 18, 89, 121, 128, 64, 32, 16, 8, 16, 32, 64, 128,
  2, 106, 122, 120, 132, 132, 8, 16, 16, 16, 0, 16, 16, 2, 106, 122,
  56, 68, 156, 164, 164, 164, 164, 156, 64, 60, 2, 106, 122, 48, 72, 132,
  132, 132, 252, 132, 132, 132, 132, 2, 106, 122, 240, 136, 132, 136, 240, 136,
  132, 132, 136, 240, 2, 106, 122, 120, 132, 132, 128, 128, 128, 128, 132, 132,
  120, 2, 106, 122, 240, 136, 132, 132, 132, 132, 132, 132, 136, 240, 2, 106,
  122, 252, 128, 128, 128, 240, 128, 128, 128, 128, 252, 2, 106, 122, 252, 128,
  128, 128, 240, 128, 128, 128, 128, 128, 2, 106, 122, 120, 132, 132, 128, 128,
  156, 132, 132, 140, 116, 2, 106, 122, 132, 132, 132, 132, 252, 132, 132, 132,
  132, 132, 18, 90, 122, 248, 32, 32, 32, 32, 32, 32, 32, 32, 248, 2,
  106, 122, 28, 8, 8, 8, 8, 8, 8, 136, 136, 112, 2, 106, 122, 132,
  136, 144, 160, 192, 160, 144, 136, 132, 132, 2, 106, 122, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 252, 2, 106, 122, 132, 204, 204, 180, 180, 132, 132,
  132, 132, 132, 2, 106, 122, 132, 132, 196, 196, 164, 148, 140, 140, 132, 132,
  2, 106, 122, 120, 132, 132, 132, 132, 132, 132, 132, 132, 120, 2, 106, 122,
  248, 132, 132, 132, 132, 248, 128, 128, 128, 128, 0, 108, 124, 120, 132, 132,
  132, 132, 132, 228, 148, 140, 120, 8, 4, 2, 106, 122, 248, 132, 132, 132,
  132, 248, 144, 136, 132, 132, 2, 106, 122, 120, 132, 132, 128, 96, 24, 4,
  132, 132, 120, 2, 122, 122, 254, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  2, 106, 122, 132, 132, 132, 132, 132, 132, 132, 132, 132, 120, 2, 106, 122,
  132, 132, 132, 132, 72, 72, 72, 48, 48, 48, 18, 90, 122, 136, 136, 136,
  136, 136, 136, 168, 168, 168, 80, 2, 106, 122, 132, 132, 72, 72, 48, 48,
  72, 72, 132, 132, 18, 90, 122, 136, 136, 136, 80, 80, 32, 32, 32, 32,
  32, 2, 106, 122, 252, 4, 8, 16, 16, 32, 64, 64, 128, 252, 32, 77,
  125, 240, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 240, 0, 109,
  125, 128, 128, 64, 64, 32, 32, 32, 16, 16, 8, 8, 4, 4, 16, 77,
  125, 240, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 240, 10, 99,
  115, 48, 72, 132, 0, 97, 113, 252, 42, 51, 115, 128, 64, 32, 2, 103,
  119, 120, 132, 4, 124, 132, 132, 124, 2, 106, 122, 128, 128, 128, 184, 196,
  132, 132, 132, 196, 184, 2, 103, 119, 120, 132, 128, 128, 128, 132, 120, 2,
  106, 122, 4, 4, 4, 116, 140, 132, 132, 132, 140, 116, 2, 103, 119, 120,
  132, 132, 252, 128, 132, 120, 2, 106, 122, 24, 36, 32, 32, 248, 32, 32,
  32, 32, 32, 0, 105, 121, 116, 136, 136, 136, 112, 64, 184, 132, 120, 2,
  106, 122, 128, 128, 128, 184, 196, 132, 132, 132, 132, 132, 18, 90, 122, 32,
  32, 0, 96, 32, 32, 32, 32, 32, 248, 16, 92, 124, 8, 8, 0, 24,
  8, 8, 8, 8, 8, 136, 136, 112, 2, 106, 122, 128, 128, 128, 136, 144,
  160, 224, 144, 136, 132, 18, 90, 122, 96, 32, 32, 32, 32, 32, 32, 32,
  32, 248, 18, 87, 119, 208, 168, 168, 168, 168, 168, 136, 2, 103, 119, 184,
  196, 132, 132, 132, 132, 132, 2, 103, 119, 120, 132, 132, 132, 132, 132, 120,
  0, 105, 121, 184, 196, 132, 132, 132, 196, 184, 128, 128, 0, 105, 121, 116,
  140, 132, 132, 132, 140, 116, 4, 4, 2, 103, 119, 184, 196, 132, 128, 128,
  128, 128, 2, 103, 119, 120, 132, 64, 48, 8, 132, 120, 2, 106, 122, 32,
  32, 32, 248, 32, 32, 32, 32, 36, 24, 2, 103, 119, 132, 132, 132, 132,
  132, 140, 116, 18, 87, 119, 136, 136, 136, 80, 80, 32, 32, 18, 87, 119,
  136, 136, 168, 168, 168, 168, 80, 2, 103, 119, 132, 132, 72, 48, 72, 132,
  132, 0, 105, 121, 132, 132, 132, 132, 140, 116, 4, 132, 120, 2, 103, 119,
  252, 8, 16, 32, 32, 64, 252, 32, 77, 125, 48, 64, 64, 64, 64, 64,
  128, 64, 64, 64, 64, 64, 48, 48, 29, 125, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 16, 77, 125, 192, 32, 32, 32, 32, 32,
  16, 32, 32, 32, 32, 32, 192, 9, 100, 116, 64, 164, 148, 8, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--13-120-75-75-C-80-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 3, '1' Height: 10
  Calculated Max Values w= 8 h=13 x= 7 y= 9 dx= 8 dy= 0 ascent=11 len=13
  Font Bounding box     w= 8 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 3 descent= 0
  X Font      ascent =10 descent= 0
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_8x13_67_75[2420] U8G_FONT_SECTION("u8g_font_8x13_67_75") = {
  1, 8, 13, 0, 254, 3, 1, 94, 2, 193, 32, 255, 0, 11, 254, 10,
  0, 3, 133, 133, 36, 18, 255, 18, 36, 18, 88, 136, 32, 32, 168, 112,
  32, 168, 112, 32, 2, 119, 135, 16, 34, 68, 248, 68, 34, 16, 18, 119,
  135, 16, 136, 68, 62, 68, 136, 16, 3, 133, 133, 32, 65, 255, 65, 32,
  18, 89, 137, 32, 112, 168, 32, 32, 32, 32, 32, 112, 3, 133, 133, 4,
  130, 255, 130, 4, 18, 89, 137, 112, 32, 32, 32, 32, 32, 168, 112, 32,
  2, 122, 138, 16, 56, 84, 16, 16, 16, 84, 56, 16, 254, 3, 133, 133,
  34, 65, 254, 64, 32, 3, 133, 133, 68, 130, 127, 2, 4, 3, 133, 133,
  34, 69, 254, 68, 36, 3, 133, 133, 68, 162, 127, 34, 36, 3, 133, 133,
  36, 90, 231, 66, 36, 3, 133, 133, 36, 82, 255, 82, 36, 18, 106, 138,
  64, 64, 128, 152, 104, 8, 16, 84, 56, 16, 18, 106, 138, 32, 64, 252,
  68, 36, 4, 4, 4, 4, 4, 18, 106, 138, 16, 8, 252, 136, 144, 128,
  128, 128, 128, 128, 18, 106, 138, 4, 4, 4, 4, 4, 36, 68, 252, 64,
  32, 18, 106, 138, 128, 128, 128, 128, 128, 144, 136, 252, 8, 16, 18, 104,
  136, 240, 16, 16, 16, 16, 84, 56, 16, 18, 90, 138, 8, 8, 8, 8,
  8, 40, 72, 248, 64, 32, 4, 135, 135, 12, 18, 33, 33, 169, 112, 32,
  4, 135, 135, 48, 72, 132, 132, 149, 14, 4, 2, 136, 136, 255, 0, 112,
  96, 80, 8, 4, 2, 2, 136, 136, 136, 144, 190, 144, 9, 125, 9, 17,
  4, 135, 135, 100, 142, 149, 132, 132, 72, 48, 4, 135, 135, 38, 113, 169,
  33, 33, 18, 12, 5, 131, 131, 32, 64, 255, 3, 131, 131, 255, 64, 32,
  50, 57, 137, 128, 192, 160, 128, 128, 128, 128, 128, 128, 34, 57, 137, 32,
  96, 160, 32, 32, 32, 32, 32, 32, 5, 131, 131, 4, 2, 255, 3, 131,
  131, 255, 2, 4, 50, 57, 137, 128, 128, 128, 128, 128, 128, 160, 192, 128,
  34, 57, 137, 32, 32, 32, 32, 32, 32, 160, 96, 32, 2, 121, 137, 8,
  4, 254, 4, 40, 64, 254, 64, 32, 2, 138, 138, 36, 116, 172, 36, 36,
  36, 36, 53, 46, 36, 2, 121, 137, 32, 64, 254, 64, 40, 4, 254, 4,
  8, 2, 139, 139, 32, 64, 255, 64, 32, 0, 32, 64, 255, 64, 32, 2,
  122, 138, 68, 238, 68, 68, 68, 68, 68, 68, 68, 68, 2, 139, 139, 4,
  2, 255, 2, 4, 0, 4, 2, 255, 2, 4, 2, 122, 138, 68, 68, 68,
  68, 68, 68, 68, 68, 238, 68, 2, 119, 135, 32, 64, 254, 0, 254, 4,
  8, 2, 119, 135, 8, 4, 254, 0, 254, 64, 32, 2, 135, 135, 16, 33,
  127, 130, 127, 36, 16, 3, 133, 133, 36, 126, 153, 126, 36, 2, 135, 135,
  8, 36, 254, 65, 254, 132, 8, 2, 135, 135, 16, 32, 127, 128, 127, 32,
  16, 18, 121, 137, 16, 40, 108, 170, 40, 40, 40, 40, 40, 2, 135, 135,
  8, 4, 254, 1, 254, 4, 8, 2, 121, 137, 40, 40, 40, 40, 40, 170,
  108, 40, 16, 3, 133, 133, 36, 126, 129, 126, 36, 2, 123, 139, 16, 40,
  108, 170, 40, 40, 40, 170, 108, 40, 16, 2, 119, 135, 252, 144, 136, 196,
  162, 144, 8, 18, 119, 135, 126, 18, 34, 70, 138, 18, 32, 18, 119, 135,
  32, 18, 138, 70, 34, 18, 126, 2, 119, 135, 8, 144, 162, 196, 136, 144,
  252, 2, 137, 137, 8, 16, 63, 64, 255, 64, 63, 16, 8, 2, 137, 137,
  16, 8, 252, 2, 255, 2, 252, 8, 16, 2, 135, 135, 16, 32, 72, 245,
  66, 32, 16, 2, 135, 135, 8, 4, 18, 175, 66, 4, 8, 2, 122, 138,
  16, 56, 84, 146, 16, 124, 16, 124, 16, 16, 2, 122, 138, 16, 16, 124,
  16, 124, 16, 146, 84, 56, 16, 2, 119, 135, 16, 32, 64, 182, 64, 32,
  16, 2, 122, 138, 16, 40, 84, 146, 0, 16, 16, 0, 16, 16, 18, 119,
  135, 16, 8, 4, 218, 4, 8, 16, 2, 122, 138, 16, 16, 0, 16, 16,
  0, 146, 84, 40, 16, 3, 117, 133, 144, 160, 254, 160, 144, 19, 117, 133,
  18, 10, 254, 10, 18, 2, 135, 135, 16, 48, 95, 129, 95, 48, 16, 2,
  121, 137, 16, 40, 68, 238, 40, 40, 40, 40, 56, 2, 135, 135, 8, 12,
  250, 129, 250, 12, 8, 2, 121, 137, 56, 40, 40, 40, 40, 238, 68, 40,
  16, 1, 123, 139, 16, 40, 68, 238, 40, 40, 56, 0, 56, 40, 56, 1,
  122, 138, 16, 40, 68, 238, 40, 40, 40, 108, 68, 124, 1, 122, 138, 16,
  40, 68, 254, 40, 40, 40, 108, 68, 124, 1, 122, 138, 16, 40, 68, 254,
  56, 56, 56, 124, 68, 124, 2, 121, 137, 16, 40, 68, 238, 68, 238, 40,
  40, 56, 1, 122, 138, 16, 40, 68, 238, 68, 238, 40, 108, 68, 124, 2,
  135, 135, 136, 140, 250, 129, 250, 140, 136, 2, 119, 135, 254, 128, 188, 176,
  168, 164, 130, 2, 119, 135, 130, 74, 42, 26, 122, 2, 254, 2, 121, 137,
  16, 40, 68, 238, 40, 238, 68, 40, 16, 4, 133, 133, 36, 82, 255, 82,
  36, 2, 138, 138, 36, 46, 53, 36, 36, 36, 36, 172, 116, 36, 0, 141,
  141, 4, 2, 255, 2, 4, 2, 255, 2, 4, 2, 255, 2, 4, 4, 117,
  133, 40, 72, 254, 72, 40, 20, 117, 133, 40, 36, 254, 36, 40, 4, 117,
  133, 16, 84, 254, 84, 16, 4, 133, 133, 42, 74, 255, 74, 42, 4, 133,
  133, 84, 82, 255, 82, 84, 4, 133, 133, 24, 90, 255, 90, 24, 3, 135,
  135, 16, 48, 80, 159, 80, 48, 16, 3, 135, 135, 8, 12, 10, 249, 10,
  12, 8, 4, 133, 133, 36, 102, 189, 102, 36, 7, 134, 134, 255, 255, 255,
  255, 255, 255, 0, 130, 130, 255, 255, 0, 131, 131, 255, 255, 255, 0, 133,
  133, 255, 255, 255, 255, 255, 0, 135, 135, 255, 255, 255, 255, 255, 255, 255,
  0, 136, 136, 255, 255, 255, 255, 255, 255, 255, 255, 0, 138, 138, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 0, 139, 139, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 0, 141, 141, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 0, 125, 141, 254, 254, 254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 0, 109, 141, 252, 252, 252, 252, 252, 252, 252,
  252, 252, 252, 252, 252, 252, 0, 93, 141, 248, 248, 248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 0, 77, 141, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 0, 61, 141, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 0, 45, 141, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 0, 29, 141, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 64, 77, 141, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 1, 139, 139, 85, 0, 170, 0, 85, 0, 170,
  0, 85, 0, 170, 0, 141, 141, 170, 85, 170, 85, 170, 85, 170, 85, 170,
  85, 170, 85, 170, 0, 141, 141, 255, 85, 255, 170, 255, 85, 255, 170, 255,
  85, 255, 170, 255, 11, 130, 130, 255, 255, 112, 29, 141, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 0, 71, 135, 240, 240, 240, 240,
  240, 240, 240, 64, 71, 135, 240, 240, 240, 240, 240, 240, 240, 7, 70, 134,
  240, 240, 240, 240, 240, 240, 0, 141, 141, 240, 240, 240, 240, 240, 240, 255,
  255, 255, 255, 255, 255, 255, 0, 141, 141, 240, 240, 240, 240, 240, 240, 15,
  15, 15, 15, 15, 15, 15, 0, 141, 141, 255, 255, 255, 255, 255, 255, 240,
  240, 240, 240, 240, 240, 240, 0, 141, 141, 255, 255, 255, 255, 255, 255, 15,
  15, 15, 15, 15, 15, 15, 71, 70, 134, 240, 240, 240, 240, 240, 240, 0,
  141, 141, 15, 15, 15, 15, 15, 15, 240, 240, 240, 240, 240, 240, 240, 0,
  141, 141, 15, 15, 15, 15, 15, 15, 255, 255, 255, 255, 255, 255, 255, 2,
  119, 135, 254, 254, 254, 254, 254, 254, 254, 2, 119, 135, 254, 130, 130, 130,
  130, 130, 254, 2, 119, 135, 124, 130, 130, 130, 130, 130, 124, 2, 119, 135,
  254, 130, 186, 186, 186, 130, 254, 2, 119, 135, 254, 130, 254, 130, 254, 130,
  254, 2, 119, 135, 254, 170, 170, 170, 170, 170, 254, 2, 119, 135, 254, 170,
  254, 170, 254, 170, 254, 2, 119, 135, 254, 146, 138, 198, 162, 146, 254, 2,
  119, 135, 254, 146, 162, 198, 138, 146, 254, 2, 119, 135, 254, 214, 170, 214,
  170, 214, 254, 37, 51, 131, 224, 224, 224, 37, 51, 131, 224, 160, 224, 21,
  100, 132, 252, 252, 252, 252, 21, 100, 132, 252, 132, 132, 252, 18, 89, 137,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 18, 89, 137, 248, 136, 136, 136,
  136, 136, 136, 136, 248, 5, 132, 132, 31, 62, 124, 248, 5, 132, 132, 31,
  34, 68, 248, 2, 136, 136, 24, 24, 60, 60, 126, 126, 255, 255, 2, 136,
  136, 24, 24, 36, 36, 66, 66, 129, 255, 18, 102, 134, 48, 48, 120, 120,
  252, 252, 18, 102, 134, 48, 48, 72, 72, 132, 252, 18, 107, 139, 128, 192,
  224, 240, 248, 252, 248, 240, 224, 192, 128, 18, 107, 139, 128, 192, 160, 144,
  136, 132, 136, 144, 160, 192, 128, 20, 101, 133, 192, 240, 252, 240, 192, 20,
  101, 133, 192, 176, 140, 176, 192, 3, 119, 135, 128, 224, 248, 254, 248, 224,
  128, 3, 119, 135, 128, 224, 152, 134, 152, 224, 128, 2, 136, 136, 255, 255,
  126, 126, 60, 60, 24, 24, 2, 136, 136, 255, 129, 66, 66, 36, 36, 24,
  24, 18, 102, 134, 252, 252, 120, 120, 48, 48, 18, 102, 134, 252, 132, 72,
  72, 48, 48, 18, 107, 139, 4, 12, 28, 60, 124, 252, 124, 60, 28, 12,
  4, 18, 107, 139, 4, 12, 20, 36, 68, 132, 68, 36, 20, 12, 4, 20,
  101, 133, 12, 60, 252, 60, 12, 20, 101, 133, 12, 52, 196, 52, 12, 3,
  119, 135, 2, 14, 62, 254, 62, 14, 2, 3, 119, 135, 2, 14, 50, 194,
  50, 14, 2, 3, 119, 135, 16, 56, 124, 254, 124, 56, 16, 3, 119, 135,
  16, 40, 68, 130, 68, 40, 16, 3, 119, 135, 16, 40, 84, 186, 84, 40,
  16, 3, 119, 135, 56, 68, 146, 186, 146, 68, 56, 18, 105, 137, 48, 48,
  72, 72, 132, 72, 72, 48, 48, 2, 136, 136, 60, 66, 129, 129, 129, 129,
  66, 60, 2, 136, 136, 24, 66, 0, 129, 129, 0, 66, 24, 2, 136, 136,
  60, 106, 171, 171, 171, 171, 106, 60, 2, 136, 136, 60, 66, 153, 165, 165,
  153, 66, 60, 2, 136, 136, 60, 126, 255, 255, 255, 255, 126, 60, 2, 136,
  136, 60, 114, 241, 241, 241, 241, 114, 60, 2, 136, 136, 60, 78, 143, 143,
  143, 143, 78, 60, 2, 136, 136, 60, 66, 129, 129, 255, 255, 126, 60, 2,
  136, 136, 60, 126, 255, 255, 129, 129, 66, 60, 2, 136, 136, 60, 78, 143,
  143, 129, 129, 66, 60, 2, 136, 136, 60, 78, 143, 143, 255, 255, 126, 60,
  2, 72, 136, 48, 112, 240, 240, 240, 240, 112, 48, 66, 72, 136, 192, 224,
  240, 240, 240, 240, 224, 192, 0, 141, 141, 255, 255, 255, 255, 195, 129, 129,
  129, 129, 195, 255, 255, 255, 0, 141, 141, 255, 255, 255, 255, 195, 153, 189,
  189, 153, 195, 255, 255, 255, 6, 135, 135, 255, 255, 255, 255, 195, 153, 189,
  0, 134, 134, 189, 153, 195, 255, 255, 255, 6, 68, 132, 48, 64, 128, 128,
  70, 68, 132, 192, 32, 16, 16, 66, 68, 132, 16, 16, 32, 192, 2, 68,
  132, 128, 128, 64, 48, 6, 132, 132, 60, 66, 129, 129, 2, 132, 132, 129,
  129, 66, 60, 2, 136, 136, 1, 3, 7, 15, 31, 63, 127, 255, 2, 136,
  136, 128, 192, 224, 240, 248, 252, 254, 255, 2, 136, 136, 255, 254, 252, 248,
  240, 224, 192, 128, 2, 136, 136, 255, 127, 63, 31, 15, 7, 3, 1, 20,
  85, 133, 112, 136, 136, 136, 112, 2, 120, 136, 254, 226, 226, 226, 226, 226,
  226, 254, 2, 120, 136, 254, 142, 142, 142, 142, 142, 142, 254, 2, 120, 136,
  254, 254, 250, 242, 226, 194, 130, 254, 2, 120, 136, 254, 130, 134, 142, 158,
  190, 254, 254, 2, 120, 136, 254, 146, 146, 146, 146, 146, 146, 254, 2, 122,
  138, 16, 16, 40, 40, 68, 84, 124, 146, 130, 254, 2, 122, 138, 16, 16,
  56, 56, 116, 116, 116, 242, 242, 254, 2, 122, 138, 16, 16, 56, 56, 92,
  92, 92, 158, 158, 254, 2, 136, 136, 60, 66, 129, 129, 129, 129, 66, 60,
  2, 119, 135, 254, 146, 146, 242, 130, 130, 254, 2, 119, 135, 254, 130, 130,
  242, 146, 146, 254, 2, 119, 135, 254, 130, 130, 158, 146, 146, 254, 2, 119,
  135, 254, 146, 146, 158, 130, 130, 254, 2, 119, 135, 124, 146, 146, 242, 130,
  130, 124, 2, 119, 135, 124, 130, 130, 242, 146, 146, 124, 2, 119, 135, 124,
  130, 130, 158, 146, 146, 124, 2, 119, 135, 124, 146, 146, 158, 130, 130, 124,
  19, 102, 134, 252, 136, 144, 160, 192, 128, 19, 102, 134, 252, 68, 36, 20,
  12, 4, 19, 102, 134, 128, 192, 160, 144, 136, 252, 19, 102, 134, 252, 132,
  132, 132, 132, 252, 19, 102, 134, 252, 252, 252, 252, 252, 252, 37, 68, 132,
  240, 144, 144, 240, 37, 68, 132, 240, 240, 240, 240, 19, 102, 134, 4, 12,
  20, 36, 68, 252
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--13-120-75-75-C-80-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 11, '1' Height: 4
  Calculated Max Values w= 8 h=11 x= 2 y= 3 dx= 8 dy= 0 ascent=11 len=11
  Font Bounding box     w= 8 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y= 0 dx= 0 dy= 0
  Pure Font   ascent =11 descent= 0
  X Font      ascent =11 descent= 0
  Max Font    ascent =11 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_8x13_75r[496] U8G_FONT_SECTION("u8g_font_8x13_75r") = {
  1, 8, 13, 0, 254, 11, 1, 83, 0, 0, 32, 79, 0, 11, 0, 11,
  0, 2, 119, 135, 254, 254, 254, 254, 254, 254, 254, 2, 119, 135, 254, 130,
  130, 130, 130, 130, 254, 2, 119, 135, 124, 130, 130, 130, 130, 130, 124, 2,
  119, 135, 254, 130, 186, 186, 186, 130, 254, 2, 119, 135, 254, 130, 254, 130,
  254, 130, 254, 2, 119, 135, 254, 170, 170, 170, 170, 170, 254, 2, 119, 135,
  254, 170, 254, 170, 254, 170, 254, 2, 119, 135, 254, 146, 138, 198, 162, 146,
  254, 2, 119, 135, 254, 146, 162, 198, 138, 146, 254, 2, 119, 135, 254, 214,
  170, 214, 170, 214, 254, 37, 51, 131, 224, 224, 224, 37, 51, 131, 224, 160,
  224, 21, 100, 132, 252, 252, 252, 252, 21, 100, 132, 252, 132, 132, 252, 18,
  89, 137, 248, 248, 248, 248, 248, 248, 248, 248, 248, 18, 89, 137, 248, 136,
  136, 136, 136, 136, 136, 136, 248, 5, 132, 132, 31, 62, 124, 248, 5, 132,
  132, 31, 34, 68, 248, 2, 136, 136, 24, 24, 60, 60, 126, 126, 255, 255,
  2, 136, 136, 24, 24, 36, 36, 66, 66, 129, 255, 18, 102, 134, 48, 48,
  120, 120, 252, 252, 18, 102, 134, 48, 48, 72, 72, 132, 252, 18, 107, 139,
  128, 192, 224, 240, 248, 252, 248, 240, 224, 192, 128, 18, 107, 139, 128, 192,
  160, 144, 136, 132, 136, 144, 160, 192, 128, 20, 101, 133, 192, 240, 252, 240,
  192, 20, 101, 133, 192, 176, 140, 176, 192, 3, 119, 135, 128, 224, 248, 254,
  248, 224, 128, 3, 119, 135, 128, 224, 152, 134, 152, 224, 128, 2, 136, 136,
  255, 255, 126, 126, 60, 60, 24, 24, 2, 136, 136, 255, 129, 66, 66, 36,
  36, 24, 24, 18, 102, 134, 252, 252, 120, 120, 48, 48, 18, 102, 134, 252,
  132, 72, 72, 48, 48, 18, 107, 139, 4, 12, 28, 60, 124, 252, 124, 60,
  28, 12, 4, 18, 107, 139, 4, 12, 20, 36, 68, 132, 68, 36, 20, 12,
  4, 20, 101, 133, 12, 60, 252, 60, 12, 20, 101, 133, 12, 52, 196, 52,
  12, 3, 119, 135, 2, 14, 62, 254, 62, 14, 2, 3, 119, 135, 2, 14,
  50, 194, 50, 14, 2, 3, 119, 135, 16, 56, 124, 254, 124, 56, 16, 3,
  119, 135, 16, 40, 68, 130, 68, 40, 16, 3, 119, 135, 16, 40, 84, 186,
  84, 40, 16, 3, 119, 135, 56, 68, 146, 186, 146, 68, 56, 18, 105, 137,
  48, 48, 72, 72, 132, 72, 72, 48, 48, 2, 136, 136, 60, 66, 129, 129,
  129, 129, 66, 60, 2, 136, 136, 24, 66, 0, 129, 129, 0, 66, 24, 2,
  136, 136, 60, 106, 171, 171, 171, 171, 106, 60, 2, 136, 136, 60, 66, 153,
  165, 165, 153, 66, 60, 2, 136, 136, 60, 126, 255, 255, 255, 255, 126, 60
};

/*
  Fontname: -Misc-Fixed-Bold-R-Normal--13-120-75-75-C-80-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 7 h=12 x= 3 y=11 dx= 8 dy= 0 ascent=11 len=12
  Font Bounding box     w= 8 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-2
  X Font      ascent =10 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_8x13B[2302] U8G_FONT_SECTION("u8g_font_8x13B") = {
  1, 8, 13, 0, 254, 10, 1, 127, 3, 12, 32, 255, 254, 11, 254, 10,
  254, 13, 0, 128, 50, 42, 138, 192, 192, 192, 192, 192, 192, 192, 0, 192,
  192, 24, 84, 132, 216, 216, 216, 216, 2, 121, 137, 108, 108, 254, 254, 108,
  254, 254, 108, 108, 1, 123, 139, 16, 124, 214, 208, 240, 124, 30, 22, 214,
  124, 16, 2, 122, 138, 230, 166, 236, 24, 24, 48, 48, 110, 202, 206, 2,
  119, 135, 120, 204, 204, 120, 206, 204, 126, 56, 36, 132, 192, 192, 192, 192,
  17, 91, 139, 24, 48, 96, 96, 192, 192, 192, 96, 96, 48, 24, 17, 91,
  139, 192, 96, 48, 48, 24, 24, 24, 48, 48, 96, 192, 3, 119, 135, 16,
  16, 254, 56, 56, 108, 68, 20, 102, 134, 48, 48, 252, 252, 48, 48, 33,
  69, 133, 240, 112, 112, 96, 192, 22, 97, 129, 252, 34, 67, 131, 96, 240,
  96, 2, 122, 138, 2, 6, 6, 12, 24, 48, 96, 192, 192, 128, 2, 122,
  138, 56, 108, 198, 198, 198, 198, 198, 198, 108, 56, 18, 106, 138, 48, 112,
  240, 48, 48, 48, 48, 48, 48, 252, 2, 122, 138, 124, 198, 198, 6, 12,
  24, 48, 96, 192, 254, 2, 122, 138, 254, 6, 12, 24, 60, 6, 6, 6,
  198, 124, 2, 122, 138, 12, 28, 60, 108, 204, 204, 254, 12, 12, 12, 2,
  122, 138, 254, 192, 192, 252, 230, 6, 6, 6, 198, 124, 2, 122, 138, 60,
  96, 192, 192, 252, 230, 198, 198, 230, 124, 2, 122, 138, 254, 6, 6, 12,
  24, 24, 48, 48, 48, 48, 2, 122, 138, 124, 198, 198, 198, 124, 198, 198,
  198, 198, 124, 2, 122, 138, 124, 206, 198, 198, 206, 126, 6, 6, 12, 120,
  34, 72, 136, 96, 240, 96, 0, 0, 96, 240, 96, 33, 73, 137, 96, 240,
  96, 0, 240, 112, 112, 96, 192, 18, 105, 137, 12, 24, 48, 96, 192, 96,
  48, 24, 12, 20, 100, 132, 252, 0, 0, 252, 18, 105, 137, 192, 96, 48,
  24, 12, 24, 48, 96, 192, 2, 122, 138, 124, 198, 198, 6, 12, 24, 24,
  0, 24, 24, 2, 121, 137, 124, 254, 206, 222, 210, 210, 222, 224, 126, 2,
  122, 138, 56, 124, 198, 198, 198, 254, 198, 198, 198, 198, 2, 122, 138, 252,
  102, 102, 102, 124, 102, 102, 102, 102, 252, 2, 122, 138, 124, 230, 198, 192,
  192, 192, 192, 198, 230, 124, 2, 122, 138, 252, 102, 102, 102, 102, 102, 102,
  102, 102, 252, 2, 122, 138, 254, 192, 192, 192, 248, 192, 192, 192, 192, 254,
  2, 122, 138, 254, 192, 192, 192, 248, 192, 192, 192, 192, 192, 2, 122, 138,
  124, 198, 198, 192, 192, 192, 206, 198, 198, 124, 2, 122, 138, 198, 198, 198,
  198, 254, 198, 198, 198, 198, 198, 34, 74, 138, 240, 96, 96, 96, 96, 96,
  96, 96, 96, 240, 2, 122, 138, 14, 6, 6, 6, 6, 6, 6, 198, 198,
  124, 2, 122, 138, 198, 198, 204, 216, 240, 240, 216, 204, 198, 198, 2, 122,
  138, 192, 192, 192, 192, 192, 192, 192, 192, 194, 254, 2, 122, 138, 198, 198,
  238, 254, 214, 198, 198, 198, 198, 198, 2, 122, 138, 198, 198, 230, 230, 246,
  222, 206, 206, 198, 198, 2, 122, 138, 124, 198, 198, 198, 198, 198, 198, 198,
  198, 124, 2, 122, 138, 252, 198, 198, 198, 198, 252, 192, 192, 192, 192, 1,
  123, 139, 124, 198, 198, 198, 198, 198, 198, 198, 222, 124, 6, 2, 122, 138,
  252, 198, 198, 198, 252, 248, 204, 204, 198, 198, 2, 122, 138, 124, 198, 198,
  192, 124, 6, 6, 198, 198, 124, 18, 106, 138, 252, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 2, 122, 138, 198, 198, 198, 198, 198, 198, 198, 198, 198,
  124, 2, 122, 138, 198, 198, 198, 198, 68, 108, 108, 56, 56, 16, 2, 122,
  138, 198, 198, 198, 198, 198, 198, 214, 214, 254, 108, 2, 122, 138, 198, 198,
  108, 108, 56, 56, 108, 108, 198, 198, 18, 106, 138, 204, 204, 204, 120, 120,
  48, 48, 48, 48, 48, 2, 122, 138, 254, 6, 6, 12, 24, 48, 96, 192,
  192, 254, 17, 91, 139, 248, 192, 192, 192, 192, 192, 192, 192, 192, 192, 248,
  2, 122, 138, 128, 192, 192, 96, 48, 24, 12, 6, 6, 2, 17, 91, 139,
  248, 24, 24, 24, 24, 24, 24, 24, 24, 24, 248, 8, 116, 132, 16, 56,
  108, 198, 1, 113, 129, 254, 41, 67, 131, 192, 96, 48, 2, 119, 135, 124,
  6, 126, 198, 198, 206, 118, 2, 122, 138, 192, 192, 192, 220, 230, 198, 198,
  198, 230, 220, 2, 119, 135, 124, 230, 192, 192, 192, 230, 124, 2, 122, 138,
  6, 6, 6, 118, 206, 198, 198, 198, 206, 118, 2, 119, 135, 124, 198, 198,
  254, 192, 198, 124, 2, 122, 138, 60, 102, 96, 96, 96, 252, 96, 96, 96,
  96, 0, 121, 137, 126, 204, 204, 204, 120, 240, 124, 198, 124, 2, 122, 138,
  192, 192, 192, 220, 230, 198, 198, 198, 198, 198, 34, 73, 137, 96, 96, 0,
  224, 96, 96, 96, 96, 240, 0, 123, 139, 6, 6, 0, 14, 6, 6, 6,
  6, 198, 198, 124, 2, 122, 138, 192, 192, 192, 204, 216, 240, 240, 216, 204,
  198, 34, 74, 138, 224, 96, 96, 96, 96, 96, 96, 96, 96, 240, 2, 119,
  135, 108, 254, 214, 214, 198, 198, 198, 2, 119, 135, 220, 230, 198, 198, 198,
  198, 198, 2, 119, 135, 124, 198, 198, 198, 198, 198, 124, 0, 121, 137, 220,
  230, 198, 198, 198, 230, 220, 192, 192, 0, 121, 137, 118, 206, 198, 198, 198,
  206, 118, 6, 6, 2, 119, 135, 220, 230, 192, 192, 192, 192, 192, 2, 119,
  135, 124, 198, 96, 56, 12, 198, 124, 2, 122, 138, 96, 96, 96, 96, 252,
  96, 96, 96, 102, 60, 2, 119, 135, 198, 198, 198, 198, 198, 206, 118, 2,
  119, 135, 198, 198, 198, 198, 108, 108, 56, 2, 119, 135, 198, 198, 198, 214,
  214, 254, 108, 2, 119, 135, 198, 198, 108, 56, 108, 198, 198, 0, 121, 137,
  198, 198, 198, 198, 206, 118, 6, 198, 124, 2, 119, 135, 254, 12, 24, 48,
  96, 192, 254, 17, 107, 139, 60, 96, 96, 96, 48, 224, 48, 96, 96, 96,
  60, 50, 42, 138, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 17, 107,
  139, 240, 24, 24, 24, 48, 28, 48, 24, 24, 24, 240, 8, 115, 131, 114,
  254, 156, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 13, 0, 128, 50, 42, 138, 192, 192, 0, 192, 192, 192, 192,
  192, 192, 192, 3, 104, 136, 16, 124, 212, 208, 208, 212, 124, 16, 1, 123,
  139, 60, 102, 96, 96, 252, 96, 96, 96, 240, 190, 224, 3, 119, 135, 198,
  254, 108, 68, 108, 254, 198, 18, 106, 138, 204, 204, 204, 120, 120, 252, 48,
  252, 48, 48, 50, 42, 138, 192, 192, 192, 192, 0, 0, 192, 192, 192, 192,
  18, 106, 138, 120, 204, 192, 120, 204, 204, 120, 12, 204, 120, 26, 82, 130,
  216, 216, 3, 121, 137, 124, 198, 186, 234, 226, 234, 186, 198, 124, 21, 87,
  135, 240, 24, 248, 152, 248, 0, 248, 3, 119, 135, 54, 108, 216, 176, 216,
  108, 54, 3, 101, 133, 252, 252, 4, 4, 4, 22, 81, 129, 248, 3, 121,
  137, 124, 198, 186, 170, 186, 178, 170, 198, 124, 28, 97, 129, 252, 24, 100,
  132, 120, 204, 204, 120, 19, 103, 135, 48, 48, 252, 48, 48, 0, 252, 22,
  70, 134, 224, 176, 48, 96, 192, 240, 22, 70, 134, 224, 176, 96, 48, 176,
  224, 41, 67, 131, 48, 96, 192, 0, 121, 137, 198, 198, 198, 198, 198, 238,
  252, 192, 192, 1, 123, 139, 62, 122, 202, 202, 202, 122, 58, 10, 10, 10,
  14, 54, 34, 130, 192, 192, 16, 67, 131, 48, 144, 96, 22, 70, 134, 96,
  224, 96, 96, 96, 240, 21, 87, 135, 112, 248, 136, 248, 112, 0, 248, 3,
  119, 135, 216, 108, 54, 26, 54, 108, 216, 2, 122, 138, 96, 224, 96, 96,
  98, 246, 14, 26, 30, 6, 2, 122, 138, 96, 224, 96, 96, 124, 246, 6,
  12, 24, 30, 2, 122, 138, 224, 176, 96, 48, 178, 230, 14, 26, 30, 6,
  18, 106, 138, 48, 48, 0, 48, 48, 96, 192, 204, 204, 120, 2, 122, 138,
  48, 24, 0, 56, 124, 198, 198, 254, 198, 198, 2, 122, 138, 24, 48, 0,
  56, 124, 198, 198, 254, 198, 198, 2, 122, 138, 56, 108, 0, 56, 124, 198,
  198, 254, 198, 198, 2, 122, 138, 52, 88, 0, 56, 124, 198, 198, 254, 198,
  198, 2, 122, 138, 108, 108, 0, 56, 124, 198, 198, 254, 198, 198, 2, 123,
  139, 24, 36, 24, 0, 56, 124, 198, 198, 254, 198, 198, 2, 122, 138, 126,
  248, 216, 216, 216, 252, 216, 216, 216, 222, 0, 124, 140, 124, 230, 192, 192,
  192, 192, 192, 230, 124, 24, 72, 48, 2, 122, 138, 48, 24, 0, 254, 192,
  192, 248, 192, 192, 254, 2, 122, 138, 24, 48, 0, 254, 192, 192, 248, 192,
  192, 254, 2, 122, 138, 56, 108, 0, 254, 192, 192, 248, 192, 192, 254, 2,
  122, 138, 108, 108, 0, 254, 192, 192, 248, 192, 192, 254, 34, 74, 138, 192,
  96, 0, 240, 96, 96, 96, 96, 96, 240, 34, 74, 138, 48, 96, 0, 240,
  96, 96, 96, 96, 96, 240, 34, 90, 138, 112, 216, 0, 240, 96, 96, 96,
  96, 96, 240, 34, 90, 138, 216, 216, 0, 240, 96, 96, 96, 96, 96, 240,
  2, 120, 136, 252, 102, 102, 246, 102, 102, 102, 252, 2, 122, 138, 52, 88,
  0, 198, 230, 246, 214, 222, 206, 198, 2, 123, 139, 48, 24, 0, 124, 198,
  198, 198, 198, 198, 198, 124, 2, 123, 139, 24, 48, 0, 124, 198, 198, 198,
  198, 198, 198, 124, 2, 123, 139, 56, 108, 0, 124, 198, 198, 198, 198, 198,
  198, 124, 2, 123, 139, 52, 88, 0, 124, 198, 198, 198, 198, 198, 198, 124,
  2, 123, 139, 108, 108, 0, 124, 198, 198, 198, 198, 198, 198, 124, 2, 119,
  135, 198, 198, 124, 56, 124, 198, 198, 1, 122, 138, 2, 124, 206, 214, 214,
  214, 214, 230, 124, 128, 2, 122, 138, 48, 24, 0, 198, 198, 198, 198, 198,
  198, 124, 2, 122, 138, 24, 48, 0, 198, 198, 198, 198, 198, 198, 124, 2,
  122, 138, 56, 108, 0, 198, 198, 198, 198, 198, 198, 124, 2, 122, 138, 108,
  108, 0, 198, 198, 198, 198, 198, 198, 124, 18, 106, 138, 24, 48, 0, 204,
  72, 120, 48, 48, 48, 48, 2, 121, 137, 192, 252, 198, 198, 198, 252, 192,
  192, 192, 2, 122, 138, 60, 102, 102, 108, 236, 108, 102, 102, 102, 108, 2,
  122, 138, 48, 24, 0, 124, 6, 126, 198, 198, 206, 118, 2, 122, 138, 24,
  48, 0, 124, 6, 126, 198, 198, 206, 118, 2, 122, 138, 56, 108, 0, 124,
  6, 126, 198, 198, 206, 118, 2, 122, 138, 52, 88, 0, 124, 6, 126, 198,
  198, 206, 118, 2, 122, 138, 108, 108, 0, 124, 6, 126, 198, 198, 206, 118,
  2, 123, 139, 24, 36, 24, 0, 124, 6, 126, 198, 198, 206, 118, 2, 119,
  135, 108, 218, 26, 124, 216, 218, 108, 0, 122, 138, 124, 230, 192, 192, 192,
  230, 124, 24, 72, 48, 2, 122, 138, 48, 24, 0, 124, 198, 198, 254, 192,
  198, 124, 2, 122, 138, 24, 48, 0, 124, 198, 198, 254, 192, 198, 124, 2,
  122, 138, 56, 108, 0, 124, 198, 198, 254, 192, 198, 124, 2, 122, 138, 108,
  108, 0, 124, 198, 198, 254, 192, 198, 124, 34, 74, 138, 192, 96, 0, 224,
  96, 96, 96, 96, 96, 240, 34, 74, 138, 96, 192, 0, 224, 96, 96, 96,
  96, 96, 240, 18, 90, 138, 112, 216, 0, 112, 48, 48, 48, 48, 48, 120,
  18, 90, 138, 216, 216, 0, 112, 48, 48, 48, 48, 48, 120, 2, 122, 138,
  108, 56, 120, 12, 126, 198, 198, 198, 198, 124, 2, 122, 138, 52, 88, 0,
  220, 230, 198, 198, 198, 198, 198, 2, 122, 138, 48, 24, 0, 124, 198, 198,
  198, 198, 198, 124, 2, 122, 138, 24, 48, 0, 124, 198, 198, 198, 198, 198,
  124, 2, 122, 138, 56, 108, 0, 124, 198, 198, 198, 198, 198, 124, 2, 122,
  138, 52, 88, 0, 124, 198, 198, 198, 198, 198, 124, 2, 122, 138, 108, 108,
  0, 124, 198, 198, 198, 198, 198, 124, 19, 103, 135, 48, 48, 0, 252, 0,
  48, 48, 1, 121, 137, 2, 124, 206, 214, 214, 214, 230, 124, 128, 2, 122,
  138, 48, 24, 0, 198, 198, 198, 198, 198, 206, 118, 2, 122, 138, 24, 48,
  0, 198, 198, 198, 198, 198, 206, 118, 2, 122, 138, 56, 108, 0, 198, 198,
  198, 198, 198, 206, 118, 2, 122, 138, 108, 108, 0, 198, 198, 198, 198, 198,
  206, 118, 0, 124, 140, 24, 48, 0, 198, 198, 198, 198, 206, 118, 6, 198,
  124, 0, 123, 139, 192, 192, 220, 230, 198, 198, 198, 230, 220, 192, 192, 0,
  124, 140, 108, 108, 0, 198, 198, 198, 198, 206, 118, 6, 198, 124
};

/*
  Fontname: -Misc-Fixed-Bold-R-Normal--13-120-75-75-C-80-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 7 h=11 x= 3 y=11 dx= 8 dy= 0 ascent=11 len=11
  Font Bounding box     w= 8 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-2
  X Font      ascent =10 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_8x13Br[1123] U8G_FONT_SECTION("u8g_font_8x13Br") = {
  1, 8, 13, 0, 254, 10, 1, 127, 3, 12, 32, 127, 254, 11, 254, 10,
  254, 13, 0, 128, 50, 42, 138, 192, 192, 192, 192, 192, 192, 192, 0, 192,
  192, 24, 84, 132, 216, 216, 216, 216, 2, 121, 137, 108, 108, 254, 254, 108,
  254, 254, 108, 108, 1, 123, 139, 16, 124, 214, 208, 240, 124, 30, 22, 214,
  124, 16, 2, 122, 138, 230, 166, 236, 24, 24, 48, 48, 110, 202, 206, 2,
  119, 135, 120, 204, 204, 120, 206, 204, 126, 56, 36, 132, 192, 192, 192, 192,
  17, 91, 139, 24, 48, 96, 96, 192, 192, 192, 96, 96, 48, 24, 17, 91,
  139, 192, 96, 48, 48, 24, 24, 24, 48, 48, 96, 192, 3, 119, 135, 16,
  16, 254, 56, 56, 108, 68, 20, 102, 134, 48, 48, 252, 252, 48, 48, 33,
  69, 133, 240, 112, 112, 96, 192, 22, 97, 129, 252, 34, 67, 131, 96, 240,
  96, 2, 122, 138, 2, 6, 6, 12, 24, 48, 96, 192, 192, 128, 2, 122,
  138, 56, 108, 198, 198, 198, 198, 198, 198, 108, 56, 18, 106, 138, 48, 112,
  240, 48, 48, 48, 48, 48, 48, 252, 2, 122, 138, 124, 198, 198, 6, 12,
  24, 48, 96, 192, 254, 2, 122, 138, 254, 6, 12, 24, 60, 6, 6, 6,
  198, 124, 2, 122, 138, 12, 28, 60, 108, 204, 204, 254, 12, 12, 12, 2,
  122, 138, 254, 192, 192, 252, 230, 6, 6, 6, 198, 124, 2, 122, 138, 60,
  96, 192, 192, 252, 230, 198, 198, 230, 124, 2, 122, 138, 254, 6, 6, 12,
  24, 24, 48, 48, 48, 48, 2, 122, 138, 124, 198, 198, 198, 124, 198, 198,
  198, 198, 124, 2, 122, 138, 124, 206, 198, 198, 206, 126, 6, 6, 12, 120,
  34, 72, 136, 96, 240, 96, 0, 0, 96, 240, 96, 33, 73, 137, 96, 240,
  96, 0, 240, 112, 112, 96, 192, 18, 105, 137, 12, 24, 48, 96, 192, 96,
  48, 24, 12, 20, 100, 132, 252, 0, 0, 252, 18, 105, 137, 192, 96, 48,
  24, 12, 24, 48, 96, 192, 2, 122, 138, 124, 198, 198, 6, 12, 24, 24,
  0, 24, 24, 2, 121, 137, 124, 254, 206, 222, 210, 210, 222, 224, 126, 2,
  122, 138, 56, 124, 198, 198, 198, 254, 198, 198, 198, 198, 2, 122, 138, 252,
  102, 102, 102, 124, 102, 102, 102, 102, 252, 2, 122, 138, 124, 230, 198, 192,
  192, 192, 192, 198, 230, 124, 2, 122, 138, 252, 102, 102, 102, 102, 102, 102,
  102, 102, 252, 2, 122, 138, 254, 192, 192, 192, 248, 192, 192, 192, 192, 254,
  2, 122, 138, 254, 192, 192, 192, 248, 192, 192, 192, 192, 192, 2, 122, 138,
  124, 198, 198, 192, 192, 192, 206, 198, 198, 124, 2, 122, 138, 198, 198, 198,
  198, 254, 198, 198, 198, 198, 198, 34, 74, 138, 240, 96, 96, 96, 96, 96,
  96, 96, 96, 240, 2, 122, 138, 14, 6, 6, 6, 6, 6, 6, 198, 198,
  124, 2, 122, 138, 198, 198, 204, 216, 240, 240, 216, 204, 198, 198, 2, 122,
  138, 192, 192, 192, 192, 192, 192, 192, 192, 194, 254, 2, 122, 138, 198, 198,
  238, 254, 214, 198, 198, 198, 198, 198, 2, 122, 138, 198, 198, 230, 230, 246,
  222, 206, 206, 198, 198, 2, 122, 138, 124, 198, 198, 198, 198, 198, 198, 198,
  198, 124, 2, 122, 138, 252, 198, 198, 198, 198, 252, 192, 192, 192, 192, 1,
  123, 139, 124, 198, 198, 198, 198, 198, 198, 198, 222, 124, 6, 2, 122, 138,
  252, 198, 198, 198, 252, 248, 204, 204, 198, 198, 2, 122, 138, 124, 198, 198,
  192, 124, 6, 6, 198, 198, 124, 18, 106, 138, 252, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 2, 122, 138, 198, 198, 198, 198, 198, 198, 198, 198, 198,
  124, 2, 122, 138, 198, 198, 198, 198, 68, 108, 108, 56, 56, 16, 2, 122,
  138, 198, 198, 198, 198, 198, 198, 214, 214, 254, 108, 2, 122, 138, 198, 198,
  108, 108, 56, 56, 108, 108, 198, 198, 18, 106, 138, 204, 204, 204, 120, 120,
  48, 48, 48, 48, 48, 2, 122, 138, 254, 6, 6, 12, 24, 48, 96, 192,
  192, 254, 17, 91, 139, 248, 192, 192, 192, 192, 192, 192, 192, 192, 192, 248,
  2, 122, 138, 128, 192, 192, 96, 48, 24, 12, 6, 6, 2, 17, 91, 139,
  248, 24, 24, 24, 24, 24, 24, 24, 24, 24, 248, 8, 116, 132, 16, 56,
  108, 198, 1, 113, 129, 254, 41, 67, 131, 192, 96, 48, 2, 119, 135, 124,
  6, 126, 198, 198, 206, 118, 2, 122, 138, 192, 192, 192, 220, 230, 198, 198,
  198, 230, 220, 2, 119, 135, 124, 230, 192, 192, 192, 230, 124, 2, 122, 138,
  6, 6, 6, 118, 206, 198, 198, 198, 206, 118, 2, 119, 135, 124, 198, 198,
  254, 192, 198, 124, 2, 122, 138, 60, 102, 96, 96, 96, 252, 96, 96, 96,
  96, 0, 121, 137, 126, 204, 204, 204, 120, 240, 124, 198, 124, 2, 122, 138,
  192, 192, 192, 220, 230, 198, 198, 198, 198, 198, 34, 73, 137, 96, 96, 0,
  224, 96, 96, 96, 96, 240, 0, 123, 139, 6, 6, 0, 14, 6, 6, 6,
  6, 198, 198, 124, 2, 122, 138, 192, 192, 192, 204, 216, 240, 240, 216, 204,
  198, 34, 74, 138, 224, 96, 96, 96, 96, 96, 96, 96, 96, 240, 2, 119,
  135, 108, 254, 214, 214, 198, 198, 198, 2, 119, 135, 220, 230, 198, 198, 198,
  198, 198, 2, 119, 135, 124, 198, 198, 198, 198, 198, 124, 0, 121, 137, 220,
  230, 198, 198, 198, 230, 220, 192, 192, 0, 121, 137, 118, 206, 198, 198, 198,
  206, 118, 6, 6, 2, 119, 135, 220, 230, 192, 192, 192, 192, 192, 2, 119,
  135, 124, 198, 96, 56, 12, 198, 124, 2, 122, 138, 96, 96, 96, 96, 252,
  96, 96, 96, 102, 60, 2, 119, 135, 198, 198, 198, 198, 198, 206, 118, 2,
  119, 135, 198, 198, 198, 198, 108, 108, 56, 2, 119, 135, 198, 198, 198, 214,
  214, 254, 108, 2, 119, 135, 198, 198, 108, 56, 108, 198, 198, 0, 121, 137,
  198, 198, 198, 198, 206, 118, 6, 198, 124, 2, 119, 135, 254, 12, 24, 48,
  96, 192, 254, 17, 107, 139, 60, 96, 96, 96, 48, 224, 48, 96, 96, 96,
  60, 50, 42, 138, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 17, 107,
  139, 240, 24, 24, 24, 48, 28, 48, 24, 24, 24, 240, 8, 115, 131, 114,
  254, 156, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--13-120-75-75-C-80-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 7 h=11 x= 3 y=11 dx= 8 dy= 0 ascent=11 len=11
  Font Bounding box     w= 8 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent = 9 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_8x13[2152] U8G_FONT_SECTION("u8g_font_8x13") = {
  1, 8, 13, 0, 254, 9, 1, 97, 2, 205, 32, 255, 254, 11, 254, 9,
  254, 13, 0, 128, 50, 25, 137, 128, 128, 128, 128, 128, 128, 128, 0, 128,
  40, 67, 131, 144, 144, 144, 19, 103, 135, 72, 72, 252, 72, 252, 72, 72,
  18, 89, 137, 32, 120, 160, 160, 112, 40, 40, 240, 32, 18, 105, 137, 68,
  164, 72, 16, 16, 32, 72, 84, 136, 18, 103, 135, 96, 144, 144, 96, 148,
  136, 116, 56, 19, 131, 128, 128, 128, 50, 57, 137, 32, 64, 64, 128, 128,
  128, 64, 64, 32, 34, 57, 137, 128, 64, 64, 32, 32, 32, 64, 64, 128,
  22, 101, 133, 72, 48, 252, 48, 72, 20, 85, 133, 32, 32, 248, 32, 32,
  17, 67, 131, 112, 96, 128, 22, 81, 129, 248, 33, 51, 131, 64, 224, 64,
  2, 121, 137, 2, 2, 4, 8, 16, 32, 64, 128, 128, 18, 105, 137, 48,
  72, 132, 132, 132, 132, 132, 72, 48, 18, 89, 137, 32, 96, 160, 32, 32,
  32, 32, 32, 248, 18, 105, 137, 120, 132, 132, 4, 8, 48, 64, 128, 252,
  18, 105, 137, 252, 4, 8, 16, 56, 4, 4, 132, 120, 18, 105, 137, 8,
  24, 40, 72, 136, 136, 252, 8, 8, 18, 105, 137, 252, 128, 128, 184, 196,
  4, 4, 132, 120, 18, 105, 137, 56, 64, 128, 128, 184, 196, 132, 132, 120,
  18, 105, 137, 252, 4, 8, 16, 16, 32, 32, 64, 64, 18, 105, 137, 120,
  132, 132, 132, 120, 132, 132, 132, 120, 18, 105, 137, 120, 132, 132, 140, 116,
  4, 4, 8, 112, 33, 56, 136, 64, 224, 64, 0, 0, 64, 224, 64, 17,
  72, 136, 32, 112, 32, 0, 0, 112, 96, 128, 34, 89, 137, 8, 16, 32,
  64, 128, 64, 32, 16, 8, 20, 100, 132, 252, 0, 0, 252, 18, 89, 137,
  128, 64, 32, 16, 8, 16, 32, 64, 128, 18, 105, 137, 120, 132, 132, 4,
  8, 16, 16, 0, 16, 18, 105, 137, 120, 132, 132, 156, 164, 172, 148, 128,
  120, 18, 105, 137, 48, 72, 132, 132, 132, 252, 132, 132, 132, 18, 105, 137,
  240, 136, 132, 136, 240, 136, 132, 136, 240, 18, 105, 137, 120, 132, 128, 128,
  128, 128, 128, 132, 120, 18, 105, 137, 240, 136, 132, 132, 132, 132, 132, 136,
  240, 18, 105, 137, 252, 128, 128, 128, 240, 128, 128, 128, 252, 18, 105, 137,
  252, 128, 128, 128, 240, 128, 128, 128, 128, 18, 105, 137, 120, 132, 128, 128,
  128, 156, 132, 140, 116, 18, 105, 137, 132, 132, 132, 132, 252, 132, 132, 132,
  132, 18, 89, 137, 248, 32, 32, 32, 32, 32, 32, 32, 248, 18, 121, 137,
  62, 8, 8, 8, 8, 8, 8, 136, 112, 18, 105, 137, 132, 136, 144, 160,
  192, 160, 144, 136, 132, 18, 105, 137, 128, 128, 128, 128, 128, 128, 128, 128,
  252, 2, 121, 137, 130, 130, 198, 170, 146, 146, 130, 130, 130, 18, 105, 137,
  132, 132, 196, 164, 148, 140, 132, 132, 132, 18, 105, 137, 120, 132, 132, 132,
  132, 132, 132, 132, 120, 18, 105, 137, 248, 132, 132, 132, 248, 128, 128, 128,
  128, 17, 106, 138, 120, 132, 132, 132, 132, 132, 164, 148, 120, 4, 18, 105,
  137, 248, 132, 132, 132, 248, 160, 144, 136, 132, 18, 105, 137, 120, 132, 128,
  128, 120, 4, 4, 132, 120, 2, 121, 137, 254, 16, 16, 16, 16, 16, 16,
  16, 16, 18, 105, 137, 132, 132, 132, 132, 132, 132, 132, 132, 120, 2, 121,
  137, 130, 130, 68, 68, 68, 40, 40, 40, 16, 2, 121, 137, 130, 130, 130,
  130, 146, 146, 146, 170, 68, 2, 121, 137, 130, 130, 68, 40, 16, 40, 68,
  130, 130, 2, 121, 137, 130, 130, 68, 40, 16, 16, 16, 16, 16, 18, 105,
  137, 252, 4, 8, 16, 32, 64, 128, 128, 252, 34, 73, 137, 240, 128, 128,
  128, 128, 128, 128, 128, 240, 2, 121, 137, 128, 128, 64, 32, 16, 8, 4,
  2, 2, 18, 73, 137, 240, 16, 16, 16, 16, 16, 16, 16, 240, 24, 83,
  131, 32, 80, 136, 1, 113, 129, 254, 58, 34, 130, 128, 64, 18, 102, 134,
  120, 4, 124, 132, 140, 116, 18, 105, 137, 128, 128, 128, 184, 196, 132, 132,
  196, 184, 18, 102, 134, 120, 132, 128, 128, 132, 120, 18, 105, 137, 4, 4,
  4, 116, 140, 132, 132, 140, 116, 18, 102, 134, 120, 132, 252, 128, 132, 120,
  18, 105, 137, 56, 68, 64, 64, 248, 64, 64, 64, 64, 16, 104, 136, 116,
  136, 136, 112, 128, 120, 132, 120, 18, 105, 137, 128, 128, 128, 184, 196, 132,
  132, 132, 132, 18, 88, 136, 32, 0, 96, 32, 32, 32, 32, 248, 16, 90,
  138, 8, 0, 24, 8, 8, 8, 8, 136, 136, 112, 18, 105, 137, 128, 128,
  128, 136, 144, 224, 144, 136, 132, 18, 89, 137, 96, 32, 32, 32, 32, 32,
  32, 32, 248, 2, 118, 134, 236, 146, 146, 146, 146, 130, 18, 102, 134, 184,
  196, 132, 132, 132, 132, 18, 102, 134, 120, 132, 132, 132, 132, 120, 16, 104,
  136, 184, 196, 132, 196, 184, 128, 128, 128, 16, 104, 136, 116, 140, 132, 140,
  116, 4, 4, 4, 18, 102, 134, 184, 68, 64, 64, 64, 64, 18, 102, 134,
  120, 132, 96, 24, 132, 120, 18, 104, 136, 64, 64, 248, 64, 64, 64, 68,
  56, 18, 102, 134, 136, 136, 136, 136, 136, 116, 18, 86, 134, 136, 136, 136,
  80, 80, 32, 2, 118, 134, 130, 130, 146, 146, 170, 68, 18, 102, 134, 132,
  72, 48, 48, 72, 132, 16, 104, 136, 132, 132, 132, 140, 116, 4, 132, 120,
  18, 102, 134, 252, 8, 16, 32, 64, 252, 34, 89, 137, 56, 64, 64, 32,
  192, 32, 64, 64, 56, 50, 25, 137, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 18, 89, 137, 224, 16, 16, 32, 24, 32, 16, 16, 224, 24, 83, 131,
  72, 168, 144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 13, 0, 128, 50, 25, 137, 128, 0, 128, 128, 128, 128,
  128, 128, 128, 19, 88, 136, 32, 112, 168, 160, 160, 168, 112, 32, 2, 121,
  137, 28, 34, 32, 112, 32, 32, 32, 98, 220, 19, 102, 134, 132, 120, 72,
  72, 120, 132, 2, 121, 137, 130, 130, 68, 40, 124, 16, 124, 16, 16, 50,
  25, 137, 128, 128, 128, 128, 0, 128, 128, 128, 128, 34, 74, 138, 96, 144,
  128, 96, 144, 144, 96, 16, 144, 96, 42, 66, 130, 144, 144, 3, 121, 137,
  56, 68, 146, 170, 162, 170, 146, 68, 56, 20, 87, 135, 112, 8, 120, 136,
  120, 0, 248, 3, 119, 135, 18, 36, 72, 144, 72, 36, 18, 19, 100, 132,
  252, 4, 4, 4, 38, 65, 129, 240, 3, 121, 137, 56, 68, 146, 170, 170,
  178, 170, 68, 56, 26, 97, 129, 252, 39, 68, 132, 96, 144, 144, 96, 19,
  87, 135, 32, 32, 248, 32, 32, 0, 248, 22, 70, 134, 96, 144, 16, 96,
  128, 240, 22, 70, 134, 96, 144, 32, 16, 144, 96, 58, 34, 130, 64, 128,
  17, 103, 135, 132, 132, 132, 132, 204, 180, 128, 18, 105, 137, 124, 232, 232,
  232, 104, 40, 40, 40, 40, 54, 33, 129, 192, 48, 34, 130, 64, 192, 22,
  54, 134, 64, 192, 64, 64, 64, 224, 21, 70, 134, 96, 144, 144, 96, 0,
  240, 3, 119, 135, 144, 72, 36, 18, 36, 72, 144, 2, 122, 138, 64, 192,
  64, 64, 66, 230, 10, 18, 26, 6, 2, 122, 138, 64, 192, 64, 64, 76,
  242, 2, 12, 16, 30, 2, 122, 138, 96, 144, 32, 16, 146, 102, 10, 18,
  26, 6, 18, 105, 137, 32, 0, 32, 32, 64, 128, 132, 132, 120, 18, 106,
  138, 32, 16, 0, 48, 72, 132, 132, 252, 132, 132, 18, 106, 138, 16, 32,
  0, 48, 72, 132, 132, 252, 132, 132, 18, 106, 138, 48, 72, 0, 48, 72,
  132, 132, 252, 132, 132, 18, 106, 138, 100, 152, 0, 48, 72, 132, 132, 252,
  132, 132, 18, 106, 138, 72, 72, 0, 48, 72, 132, 132, 252, 132, 132, 18,
  106, 138, 48, 72, 48, 48, 72, 132, 132, 252, 132, 132, 2, 121, 137, 110,
  144, 144, 144, 156, 240, 144, 144, 158, 16, 107, 139, 120, 132, 128, 128, 128,
  128, 128, 132, 120, 16, 32, 18, 106, 138, 32, 16, 0, 252, 128, 128, 240,
  128, 128, 252, 18, 106, 138, 16, 32, 0, 252, 128, 128, 240, 128, 128, 252,
  18, 106, 138, 48, 72, 0, 252, 128, 128, 240, 128, 128, 252, 18, 106, 138,
  72, 72, 0, 252, 128, 128, 240, 128, 128, 252, 18, 90, 138, 64, 32, 0,
  248, 32, 32, 32, 32, 32, 248, 18, 90, 138, 16, 32, 0, 248, 32, 32,
  32, 32, 32, 248, 18, 90, 138, 48, 72, 0, 248, 32, 32, 32, 32, 32,
  248, 18, 90, 138, 136, 136, 0, 248, 32, 32, 32, 32, 32, 248, 2, 121,
  137, 120, 68, 66, 66, 226, 66, 66, 68, 120, 2, 122, 138, 100, 152, 0,
  130, 194, 162, 146, 138, 134, 130, 2, 122, 138, 32, 16, 0, 124, 130, 130,
  130, 130, 130, 124, 2, 122, 138, 8, 16, 0, 124, 130, 130, 130, 130, 130,
  124, 2, 122, 138, 24, 36, 0, 124, 130, 130, 130, 130, 130, 124, 2, 122,
  138, 100, 152, 0, 124, 130, 130, 130, 130, 130, 124, 2, 122, 138, 68, 68,
  0, 124, 130, 130, 130, 130, 130, 124, 19, 102, 134, 132, 72, 48, 48, 72,
  132, 17, 107, 139, 4, 120, 140, 148, 148, 164, 164, 164, 196, 120, 128, 18,
  106, 138, 64, 32, 0, 132, 132, 132, 132, 132, 132, 120, 18, 106, 138, 16,
  32, 0, 132, 132, 132, 132, 132, 132, 120, 18, 106, 138, 48, 72, 0, 132,
  132, 132, 132, 132, 132, 120, 18, 106, 138, 72, 72, 0, 132, 132, 132, 132,
  132, 132, 120, 18, 90, 138, 16, 32, 0, 136, 136, 80, 32, 32, 32, 32,
  18, 105, 137, 128, 248, 132, 132, 132, 248, 128, 128, 128, 18, 105, 137, 112,
  136, 136, 144, 160, 152, 132, 132, 184, 18, 105, 137, 32, 16, 0, 120, 4,
  124, 132, 140, 116, 18, 105, 137, 8, 16, 0, 120, 4, 124, 132, 140, 116,
  18, 105, 137, 48, 72, 0, 120, 4, 124, 132, 140, 116, 18, 105, 137, 100,
  152, 0, 120, 4, 124, 132, 140, 116, 18, 105, 137, 72, 72, 0, 120, 4,
  124, 132, 140, 116, 18, 106, 138, 48, 72, 48, 0, 120, 4, 124, 132, 140,
  116, 2, 118, 134, 108, 18, 124, 144, 146, 108, 16, 104, 136, 120, 132, 128,
  128, 132, 120, 16, 32, 18, 105, 137, 32, 16, 0, 120, 132, 252, 128, 132,
  120, 18, 105, 137, 16, 32, 0, 120, 132, 252, 128, 132, 120, 18, 105, 137,
  48, 72, 0, 120, 132, 252, 128, 132, 120, 18, 105, 137, 72, 72, 0, 120,
  132, 252, 128, 132, 120, 18, 89, 137, 64, 32, 0, 96, 32, 32, 32, 32,
  248, 18, 89, 137, 32, 64, 0, 96, 32, 32, 32, 32, 248, 18, 89, 137,
  96, 144, 0, 96, 32, 32, 32, 32, 248, 18, 89, 137, 144, 144, 0, 96,
  32, 32, 32, 32, 248, 18, 106, 138, 72, 48, 80, 8, 120, 132, 132, 132,
  132, 120, 18, 105, 137, 100, 152, 0, 184, 196, 132, 132, 132, 132, 18, 105,
  137, 64, 32, 0, 120, 132, 132, 132, 132, 120, 18, 105, 137, 16, 32, 0,
  120, 132, 132, 132, 132, 120, 18, 105, 137, 48, 72, 0, 120, 132, 132, 132,
  132, 120, 18, 105, 137, 100, 152, 0, 120, 132, 132, 132, 132, 120, 18, 105,
  137, 72, 72, 0, 120, 132, 132, 132, 132, 120, 19, 87, 135, 32, 32, 0,
  248, 0, 32, 32, 17, 104, 136, 4, 120, 140, 148, 164, 196, 120, 128, 18,
  105, 137, 64, 32, 0, 136, 136, 136, 136, 136, 116, 18, 105, 137, 16, 32,
  0, 136, 136, 136, 136, 136, 116, 18, 105, 137, 48, 72, 0, 136, 136, 136,
  136, 136, 116, 18, 105, 137, 80, 80, 0, 136, 136, 136, 136, 136, 116, 16,
  107, 139, 16, 32, 0, 132, 132, 132, 140, 116, 4, 132, 120, 16, 106, 138,
  128, 128, 184, 196, 132, 132, 196, 184, 128, 128, 16, 107, 139, 72, 72, 0,
  132, 132, 132, 140, 116, 4, 132, 120
};

/*
  Fontname: -Misc-Fixed-Medium-O-Normal--13-120-75-75-C-80-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 8 h=11 x= 3 y=11 dx= 8 dy= 0 ascent=11 len=11
  Font Bounding box     w= 8 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent = 9 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_8x13O[2153] U8G_FONT_SECTION("u8g_font_8x13O") = {
  1, 8, 13, 0, 254, 9, 1, 98, 2, 206, 32, 255, 254, 11, 254, 9,
  254, 13, 0, 128, 50, 41, 137, 64, 64, 64, 64, 128, 128, 128, 0, 128,
  40, 67, 131, 144, 144, 144, 3, 119, 135, 36, 36, 126, 36, 252, 72, 72,
  18, 105, 137, 16, 60, 80, 80, 56, 40, 40, 240, 32, 2, 121, 137, 34,
  82, 36, 8, 16, 32, 72, 148, 136, 18, 104, 136, 24, 36, 40, 48, 84,
  136, 152, 100, 56, 19, 131, 128, 128, 128, 34, 73, 137, 16, 32, 64, 64,
  128, 128, 64, 64, 32, 34, 73, 137, 64, 32, 32, 16, 16, 32, 32, 64,
  128, 20, 101, 133, 72, 48, 252, 96, 144, 20, 85, 133, 32, 32, 248, 64,
  64, 33, 67, 131, 112, 96, 128, 22, 81, 129, 248, 33, 51, 131, 64, 224,
  64, 2, 137, 137, 1, 1, 2, 4, 24, 32, 64, 128, 128, 2, 121, 137,
  24, 36, 66, 66, 66, 132, 132, 72, 48, 18, 89, 137, 16, 48, 80, 16,
  16, 32, 32, 32, 248, 2, 121, 137, 60, 66, 66, 2, 12, 48, 64, 128,
  252, 2, 121, 137, 126, 2, 4, 8, 24, 4, 4, 132, 120, 18, 105, 137,
  4, 12, 20, 36, 72, 136, 252, 16, 16, 2, 121, 137, 62, 32, 32, 92,
  98, 2, 4, 132, 120, 2, 121, 137, 28, 34, 64, 64, 120, 132, 132, 132,
  120, 18, 105, 137, 252, 4, 8, 16, 32, 64, 64, 128, 128, 2, 121, 137,
  60, 66, 66, 66, 124, 132, 132, 132, 120, 18, 105, 137, 120, 132, 132, 140,
  116, 8, 8, 16, 224, 33, 72, 136, 32, 112, 32, 0, 0, 64, 224, 64,
  17, 88, 136, 16, 56, 16, 0, 0, 112, 96, 128, 18, 89, 137, 8, 16,
  32, 64, 128, 128, 64, 32, 16, 4, 116, 132, 126, 0, 0, 252, 18, 89,
  137, 64, 32, 16, 8, 8, 16, 32, 64, 128, 18, 105, 137, 56, 68, 132,
  8, 16, 32, 32, 0, 32, 2, 121, 137, 60, 66, 66, 78, 82, 166, 152,
  128, 120, 2, 121, 137, 24, 36, 66, 66, 66, 252, 132, 132, 132, 2, 121,
  137, 120, 68, 66, 68, 120, 136, 132, 136, 240, 2, 121, 137, 60, 66, 64,
  64, 64, 128, 128, 132, 120, 2, 121, 137, 120, 68, 66, 66, 66, 132, 132,
  136, 240, 2, 121, 137, 126, 64, 64, 64, 120, 128, 128, 128, 252, 2, 121,
  137, 126, 64, 64, 64, 120, 128, 128, 128, 128, 2, 121, 137, 60, 66, 64,
  64, 64, 156, 132, 140, 116, 2, 121, 137, 66, 66, 66, 66, 124, 132, 132,
  132, 132, 18, 105, 137, 124, 16, 16, 16, 16, 32, 32, 32, 248, 2, 121,
  137, 30, 4, 4, 4, 4, 8, 8, 136, 112, 2, 121, 137, 66, 68, 72,
  80, 96, 160, 144, 136, 132, 18, 105, 137, 64, 64, 64, 64, 64, 128, 128,
  128, 252, 2, 137, 137, 65, 65, 99, 85, 73, 130, 130, 130, 130, 2, 121,
  137, 66, 66, 98, 82, 74, 140, 132, 132, 132, 2, 121, 137, 60, 66, 66,
  66, 66, 132, 132, 132, 120, 2, 121, 137, 124, 66, 66, 66, 124, 128, 128,
  128, 128, 1, 122, 138, 60, 66, 66, 66, 132, 132, 164, 148, 120, 4, 2,
  121, 137, 124, 66, 66, 66, 124, 160, 144, 136, 132, 2, 121, 137, 60, 66,
  64, 64, 56, 4, 4, 132, 120, 2, 121, 137, 254, 16, 16, 16, 16, 32,
  32, 32, 32, 2, 121, 137, 66, 66, 66, 66, 132, 132, 132, 132, 120, 2,
  121, 137, 130, 130, 132, 68, 72, 72, 80, 80, 32, 2, 137, 137, 65, 65,
  65, 65, 73, 146, 146, 170, 68, 2, 137, 137, 65, 65, 34, 20, 24, 40,
  68, 130, 130, 2, 121, 137, 130, 130, 68, 40, 16, 16, 32, 32, 32, 2,
  121, 137, 126, 2, 4, 8, 16, 32, 64, 128, 252, 18, 89, 137, 120, 64,
  64, 64, 64, 128, 128, 128, 240, 18, 105, 137, 128, 128, 64, 32, 16, 16,
  8, 4, 4, 18, 89, 137, 120, 8, 8, 8, 8, 16, 16, 16, 240, 24,
  83, 131, 32, 80, 136, 1, 113, 129, 254, 58, 34, 130, 128, 64, 2, 118,
  134, 60, 2, 124, 132, 140, 116, 2, 121, 137, 64, 64, 64, 92, 98, 66,
  132, 196, 184, 2, 118, 134, 60, 66, 128, 128, 132, 120, 2, 121, 137, 2,
  2, 2, 58, 68, 132, 132, 140, 116, 2, 118, 134, 60, 66, 124, 128, 132,
  120, 18, 105, 137, 56, 68, 64, 64, 248, 64, 128, 128, 128, 0, 120, 136,
  58, 68, 136, 112, 128, 120, 132, 120, 2, 121, 137, 32, 32, 64, 92, 98,
  66, 132, 132, 132, 18, 88, 136, 16, 0, 48, 16, 16, 32, 32, 248, 16,
  106, 138, 4, 0, 12, 4, 4, 8, 8, 136, 136, 112, 18, 105, 137, 64,
  64, 64, 68, 88, 96, 144, 136, 132, 18, 89, 137, 48, 16, 16, 16, 16,
  32, 32, 32, 248, 2, 134, 134, 118, 73, 73, 146, 146, 130, 2, 118, 134,
  92, 98, 66, 132, 132, 132, 2, 118, 134, 60, 66, 66, 132, 132, 120, 0,
  136, 136, 46, 49, 33, 98, 92, 64, 128, 128, 0, 120, 136, 58, 70, 132,
  140, 116, 4, 8, 8, 18, 102, 134, 184, 68, 64, 128, 128, 128, 2, 118,
  134, 60, 66, 32, 24, 132, 120, 18, 88, 136, 64, 64, 248, 64, 128, 128,
  136, 112, 18, 102, 134, 68, 68, 68, 136, 136, 116, 18, 86, 134, 136, 136,
  144, 160, 160, 64, 2, 134, 134, 65, 65, 146, 146, 170, 68, 2, 118, 134,
  66, 36, 24, 48, 72, 132, 0, 120, 136, 66, 66, 132, 140, 116, 4, 132,
  120, 2, 118, 134, 126, 4, 24, 32, 64, 252, 18, 89, 137, 56, 64, 64,
  32, 192, 64, 128, 128, 112, 50, 41, 137, 64, 64, 64, 64, 64, 128, 128,
  128, 128, 18, 89, 137, 112, 8, 8, 16, 24, 32, 16, 16, 224, 24, 83,
  131, 72, 168, 144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 13, 0, 128, 50, 41, 137, 64, 0, 64, 64, 64,
  128, 128, 128, 128, 19, 104, 136, 16, 56, 84, 80, 160, 168, 112, 32, 2,
  137, 137, 14, 17, 16, 56, 16, 32, 32, 98, 220, 3, 118, 134, 66, 60,
  36, 72, 120, 132, 2, 121, 137, 130, 130, 68, 40, 124, 16, 248, 32, 32,
  50, 41, 137, 64, 64, 64, 64, 0, 128, 128, 128, 128, 18, 90, 138, 48,
  72, 64, 48, 72, 144, 96, 16, 144, 96, 42, 66, 130, 144, 144, 2, 137,
  137, 28, 34, 73, 85, 162, 170, 146, 68, 56, 20, 103, 135, 56, 4, 120,
  136, 120, 0, 248, 3, 119, 135, 18, 36, 72, 144, 144, 72, 36, 19, 100,
  132, 252, 4, 8, 8, 38, 65, 129, 240, 2, 137, 137, 28, 34, 89, 85,
  170, 178, 170, 68, 56, 26, 97, 129, 252, 39, 68, 132, 96, 144, 144, 96,
  19, 103, 135, 16, 16, 124, 32, 32, 0, 248, 22, 86, 134, 48, 72, 8,
  112, 128, 240, 22, 86, 134, 112, 8, 48, 16, 144, 96, 58, 34, 130, 64,
  128, 1, 119, 135, 66, 66, 66, 132, 204, 180, 128, 18, 105, 137, 124, 232,
  232, 232, 104, 80, 80, 80, 80, 54, 33, 129, 192, 48, 34, 130, 64, 192,
  38, 54, 134, 32, 96, 32, 64, 64, 224, 21, 102, 134, 24, 36, 72, 48,
  0, 240, 3, 119, 135, 72, 36, 18, 18, 36, 72, 144, 18, 106, 138, 32,
  96, 32, 64, 68, 236, 20, 40, 60, 8, 2, 122, 138, 32, 96, 32, 64,
  76, 242, 4, 24, 32, 60, 18, 106, 138, 112, 8, 48, 16, 148, 108, 20,
  40, 60, 8, 18, 105, 137, 16, 0, 16, 16, 32, 64, 132, 136, 112, 2,
  122, 138, 16, 8, 0, 24, 36, 66, 66, 124, 132, 132, 2, 122, 138, 8,
  16, 0, 24, 36, 66, 66, 124, 132, 132, 2, 122, 138, 24, 36, 0, 24,
  36, 66, 66, 124, 132, 132, 2, 122, 138, 50, 76, 0, 24, 36, 66, 66,
  124, 132, 132, 2, 122, 138, 36, 36, 0, 24, 36, 66, 66, 124, 132, 132,
  2, 122, 138, 24, 36, 24, 24, 36, 66, 66, 124, 132, 132, 2, 137, 137,
  55, 72, 72, 72, 78, 112, 144, 144, 158, 0, 123, 139, 60, 66, 64, 64,
  64, 128, 128, 132, 120, 16, 32, 2, 122, 138, 16, 8, 0, 126, 64, 64,
  112, 128, 128, 252, 2, 122, 138, 8, 16, 0, 126, 64, 64, 112, 128, 128,
  252, 2, 122, 138, 24, 36, 0, 126, 64, 64, 112, 128, 128, 252, 2, 122,
  138, 36, 36, 0, 126, 64, 64, 112, 128, 128, 252, 18, 106, 138, 32, 16,
  0, 124, 16, 16, 32, 32, 32, 248, 18, 106, 138, 8, 16, 0, 124, 16,
  16, 32, 32, 32, 248, 18, 106, 138, 24, 36, 0, 124, 16, 16, 32, 32,
  32, 248, 18, 106, 138, 68, 68, 0, 124, 16, 16, 32, 32, 32, 248, 2,
  121, 137, 120, 68, 66, 66, 226, 68, 132, 136, 240, 2, 138, 138, 50, 76,
  0, 65, 97, 81, 146, 138, 134, 130, 2, 138, 138, 16, 8, 0, 62, 65,
  65, 130, 130, 130, 124, 2, 138, 138, 4, 8, 0, 62, 65, 65, 130, 130,
  130, 124, 2, 138, 138, 12, 18, 0, 62, 65, 65, 130, 130, 130, 124, 2,
  138, 138, 50, 76, 0, 62, 65, 65, 130, 130, 130, 124, 2, 138, 138, 34,
  34, 0, 62, 65, 65, 130, 130, 130, 124, 3, 118, 134, 66, 36, 24, 48,
  72, 132, 1, 123, 139, 2, 60, 70, 74, 74, 82, 164, 164, 196, 120, 128,
  2, 122, 138, 32, 16, 0, 66, 66, 66, 132, 132, 132, 120, 2, 122, 138,
  8, 16, 0, 66, 66, 66, 132, 132, 132, 120, 2, 122, 138, 24, 36, 0,
  66, 66, 66, 132, 132, 132, 120, 2, 122, 138, 36, 36, 0, 66, 66, 66,
  132, 132, 132, 120, 18, 90, 138, 16, 32, 0, 136, 136, 80, 96, 64, 64,
  64, 2, 121, 137, 64, 124, 66, 66, 66, 124, 128, 128, 128, 18, 105, 137,
  56, 68, 68, 72, 80, 136, 132, 132, 184, 2, 121, 137, 16, 8, 0, 60,
  2, 124, 132, 140, 116, 2, 121, 137, 4, 8, 0, 60, 2, 124, 132, 140,
  116, 2, 121, 137, 24, 36, 0, 60, 2, 124, 132, 140, 116, 2, 121, 137,
  50, 76, 0, 60, 2, 124, 132, 140, 116, 2, 121, 137, 36, 36, 0, 60,
  2, 124, 132, 140, 116, 2, 122, 138, 24, 36, 24, 0, 60, 2, 124, 132,
  140, 116, 2, 134, 134, 54, 9, 126, 144, 146, 108, 0, 120, 136, 60, 66,
  128, 128, 132, 120, 16, 32, 2, 121, 137, 16, 8, 0, 60, 66, 124, 128,
  132, 120, 2, 121, 137, 8, 16, 0, 60, 66, 124, 128, 132, 120, 2, 121,
  137, 24, 36, 0, 60, 66, 124, 128, 132, 120, 2, 121, 137, 36, 36, 0,
  60, 66, 124, 128, 132, 120, 18, 89, 137, 32, 16, 0, 48, 16, 16, 32,
  32, 248, 18, 89, 137, 16, 32, 0, 48, 16, 16, 32, 32, 248, 18, 89,
  137, 48, 72, 0, 48, 16, 16, 32, 32, 248, 18, 89, 137, 72, 72, 0,
  48, 16, 16, 32, 32, 248, 2, 122, 138, 36, 24, 40, 4, 60, 66, 66,
  132, 132, 120, 2, 121, 137, 50, 76, 0, 92, 98, 66, 132, 132, 132, 2,
  121, 137, 32, 16, 0, 60, 66, 66, 132, 132, 120, 2, 121, 137, 8, 16,
  0, 60, 66, 66, 132, 132, 120, 2, 121, 137, 24, 36, 0, 60, 66, 66,
  132, 132, 120, 2, 121, 137, 50, 76, 0, 60, 66, 66, 132, 132, 120, 2,
  121, 137, 36, 36, 0, 60, 66, 66, 132, 132, 120, 19, 103, 135, 16, 16,
  0, 252, 0, 32, 32, 1, 120, 136, 2, 60, 70, 90, 164, 196, 120, 128,
  18, 105, 137, 32, 16, 0, 68, 68, 68, 136, 136, 116, 18, 105, 137, 8,
  16, 0, 68, 68, 68, 136, 136, 116, 18, 105, 137, 24, 36, 0, 68, 68,
  68, 136, 136, 116, 18, 105, 137, 40, 40, 0, 68, 68, 68, 136, 136, 116,
  0, 123, 139, 8, 16, 0, 66, 66, 132, 140, 116, 4, 132, 120, 0, 122,
  138, 64, 64, 92, 98, 66, 132, 196, 184, 128, 128, 0, 123, 139, 36, 36,
  0, 66, 66, 132, 140, 116, 4, 132, 120
};

/*
  Fontname: -Misc-Fixed-Medium-O-Normal--13-120-75-75-C-80-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 8 h=10 x= 3 y=11 dx= 8 dy= 0 ascent=11 len=10
  Font Bounding box     w= 8 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent = 9 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_8x13Or[1029] U8G_FONT_SECTION("u8g_font_8x13Or") = {
  1, 8, 13, 0, 254, 9, 1, 98, 2, 206, 32, 127, 254, 11, 254, 9,
  254, 13, 0, 128, 50, 41, 137, 64, 64, 64, 64, 128, 128, 128, 0, 128,
  40, 67, 131, 144, 144, 144, 3, 119, 135, 36, 36, 126, 36, 252, 72, 72,
  18, 105, 137, 16, 60, 80, 80, 56, 40, 40, 240, 32, 2, 121, 137, 34,
  82, 36, 8, 16, 32, 72, 148, 136, 18, 104, 136, 24, 36, 40, 48, 84,
  136, 152, 100, 56, 19, 131, 128, 128, 128, 34, 73, 137, 16, 32, 64, 64,
  128, 128, 64, 64, 32, 34, 73, 137, 64, 32, 32, 16, 16, 32, 32, 64,
  128, 20, 101, 133, 72, 48, 252, 96, 144, 20, 85, 133, 32, 32, 248, 64,
  64, 33, 67, 131, 112, 96, 128, 22, 81, 129, 248, 33, 51, 131, 64, 224,
  64, 2, 137, 137, 1, 1, 2, 4, 24, 32, 64, 128, 128, 2, 121, 137,
  24, 36, 66, 66, 66, 132, 132, 72, 48, 18, 89, 137, 16, 48, 80, 16,
  16, 32, 32, 32, 248, 2, 121, 137, 60, 66, 66, 2, 12, 48, 64, 128,
  252, 2, 121, 137, 126, 2, 4, 8, 24, 4, 4, 132, 120, 18, 105, 137,
  4, 12, 20, 36, 72, 136, 252, 16, 16, 2, 121, 137, 62, 32, 32, 92,
  98, 2, 4, 132, 120, 2, 121, 137, 28, 34, 64, 64, 120, 132, 132, 132,
  120, 18, 105, 137, 252, 4, 8, 16, 32, 64, 64, 128, 128, 2, 121, 137,
  60, 66, 66, 66, 124, 132, 132, 132, 120, 18, 105, 137, 120, 132, 132, 140,
  116, 8, 8, 16, 224, 33, 72, 136, 32, 112, 32, 0, 0, 64, 224, 64,
  17, 88, 136, 16, 56, 16, 0, 0, 112, 96, 128, 18, 89, 137, 8, 16,
  32, 64, 128, 128, 64, 32, 16, 4, 116, 132, 126, 0, 0, 252, 18, 89,
  137, 64, 32, 16, 8, 8, 16, 32, 64, 128, 18, 105, 137, 56, 68, 132,
  8, 16, 32, 32, 0, 32, 2, 121, 137, 60, 66, 66, 78, 82, 166, 152,
  128, 120, 2, 121, 137, 24, 36, 66, 66, 66, 252, 132, 132, 132, 2, 121,
  137, 120, 68, 66, 68, 120, 136, 132, 136, 240, 2, 121, 137, 60, 66, 64,
  64, 64, 128, 128, 132, 120, 2, 121, 137, 120, 68, 66, 66, 66, 132, 132,
  136, 240, 2, 121, 137, 126, 64, 64, 64, 120, 128, 128, 128, 252, 2, 121,
  137, 126, 64, 64, 64, 120, 128, 128, 128, 128, 2, 121, 137, 60, 66, 64,
  64, 64, 156, 132, 140, 116, 2, 121, 137, 66, 66, 66, 66, 124, 132, 132,
  132, 132, 18, 105, 137, 124, 16, 16, 16, 16, 32, 32, 32, 248, 2, 121,
  137, 30, 4, 4, 4, 4, 8, 8, 136, 112, 2, 121, 137, 66, 68, 72,
  80, 96, 160, 144, 136, 132, 18, 105, 137, 64, 64, 64, 64, 64, 128, 128,
  128, 252, 2, 137, 137, 65, 65, 99, 85, 73, 130, 130, 130, 130, 2, 121,
  137, 66, 66, 98, 82, 74, 140, 132, 132, 132, 2, 121, 137, 60, 66, 66,
  66, 66, 132, 132, 132, 120, 2, 121, 137, 124, 66, 66, 66, 124, 128, 128,
  128, 128, 1, 122, 138, 60, 66, 66, 66, 132, 132, 164, 148, 120, 4, 2,
  121, 137, 124, 66, 66, 66, 124, 160, 144, 136, 132, 2, 121, 137, 60, 66,
  64, 64, 56, 4, 4, 132, 120, 2, 121, 137, 254, 16, 16, 16, 16, 32,
  32, 32, 32, 2, 121, 137, 66, 66, 66, 66, 132, 132, 132, 132, 120, 2,
  121, 137, 130, 130, 132, 68, 72, 72, 80, 80, 32, 2, 137, 137, 65, 65,
  65, 65, 73, 146, 146, 170, 68, 2, 137, 137, 65, 65, 34, 20, 24, 40,
  68, 130, 130, 2, 121, 137, 130, 130, 68, 40, 16, 16, 32, 32, 32, 2,
  121, 137, 126, 2, 4, 8, 16, 32, 64, 128, 252, 18, 89, 137, 120, 64,
  64, 64, 64, 128, 128, 128, 240, 18, 105, 137, 128, 128, 64, 32, 16, 16,
  8, 4, 4, 18, 89, 137, 120, 8, 8, 8, 8, 16, 16, 16, 240, 24,
  83, 131, 32, 80, 136, 1, 113, 129, 254, 58, 34, 130, 128, 64, 2, 118,
  134, 60, 2, 124, 132, 140, 116, 2, 121, 137, 64, 64, 64, 92, 98, 66,
  132, 196, 184, 2, 118, 134, 60, 66, 128, 128, 132, 120, 2, 121, 137, 2,
  2, 2, 58, 68, 132, 132, 140, 116, 2, 118, 134, 60, 66, 124, 128, 132,
  120, 18, 105, 137, 56, 68, 64, 64, 248, 64, 128, 128, 128, 0, 120, 136,
  58, 68, 136, 112, 128, 120, 132, 120, 2, 121, 137, 32, 32, 64, 92, 98,
  66, 132, 132, 132, 18, 88, 136, 16, 0, 48, 16, 16, 32, 32, 248, 16,
  106, 138, 4, 0, 12, 4, 4, 8, 8, 136, 136, 112, 18, 105, 137, 64,
  64, 64, 68, 88, 96, 144, 136, 132, 18, 89, 137, 48, 16, 16, 16, 16,
  32, 32, 32, 248, 2, 134, 134, 118, 73, 73, 146, 146, 130, 2, 118, 134,
  92, 98, 66, 132, 132, 132, 2, 118, 134, 60, 66, 66, 132, 132, 120, 0,
  136, 136, 46, 49, 33, 98, 92, 64, 128, 128, 0, 120, 136, 58, 70, 132,
  140, 116, 4, 8, 8, 18, 102, 134, 184, 68, 64, 128, 128, 128, 2, 118,
  134, 60, 66, 32, 24, 132, 120, 18, 88, 136, 64, 64, 248, 64, 128, 128,
  136, 112, 18, 102, 134, 68, 68, 68, 136, 136, 116, 18, 86, 134, 136, 136,
  144, 160, 160, 64, 2, 134, 134, 65, 65, 146, 146, 170, 68, 2, 118, 134,
  66, 36, 24, 48, 72, 132, 0, 120, 136, 66, 66, 132, 140, 116, 4, 132,
  120, 2, 118, 134, 126, 4, 24, 32, 64, 252, 18, 89, 137, 56, 64, 64,
  32, 192, 64, 128, 128, 112, 50, 41, 137, 64, 64, 64, 64, 64, 128, 128,
  128, 128, 18, 89, 137, 112, 8, 8, 16, 24, 32, 16, 16, 224, 24, 83,
  131, 72, 168, 144, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--13-120-75-75-C-80-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 7 h=10 x= 3 y=11 dx= 8 dy= 0 ascent=11 len=10
  Font Bounding box     w= 8 h=13 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-2
  X Font      ascent = 9 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_8x13r[1028] U8G_FONT_SECTION("u8g_font_8x13r") = {
  1, 8, 13, 0, 254, 9, 1, 97, 2, 205, 32, 127, 254, 11, 254, 9,
  254, 13, 0, 128, 50, 25, 137, 128, 128, 128, 128, 128, 128, 128, 0, 128,
  40, 67, 131, 144, 144, 144, 19, 103, 135, 72, 72, 252, 72, 252, 72, 72,
  18, 89, 137, 32, 120, 160, 160, 112, 40, 40, 240, 32, 18, 105, 137, 68,
  164, 72, 16, 16, 32, 72, 84, 136, 18, 103, 135, 96, 144, 144, 96, 148,
  136, 116, 56, 19, 131, 128, 128, 128, 50, 57, 137, 32, 64, 64, 128, 128,
  128, 64, 64, 32, 34, 57, 137, 128, 64, 64, 32, 32, 32, 64, 64, 128,
  22, 101, 133, 72, 48, 252, 48, 72, 20, 85, 133, 32, 32, 248, 32, 32,
  17, 67, 131, 112, 96, 128, 22, 81, 129, 248, 33, 51, 131, 64, 224, 64,
  2, 121, 137, 2, 2, 4, 8, 16, 32, 64, 128, 128, 18, 105, 137, 48,
  72, 132, 132, 132, 132, 132, 72, 48, 18, 89, 137, 32, 96, 160, 32, 32,
  32, 32, 32, 248, 18, 105, 137, 120, 132, 132, 4, 8, 48, 64, 128, 252,
  18, 105, 137, 252, 4, 8, 16, 56, 4, 4, 132, 120, 18, 105, 137, 8,
  24, 40, 72, 136, 136, 252, 8, 8, 18, 105, 137, 252, 128, 128, 184, 196,
  4, 4, 132, 120, 18, 105, 137, 56, 64, 128, 128, 184, 196, 132, 132, 120,
  18, 105, 137, 252, 4, 8, 16, 16, 32, 32, 64, 64, 18, 105, 137, 120,
  132, 132, 132, 120, 132, 132, 132, 120, 18, 105, 137, 120, 132, 132, 140, 116,
  4, 4, 8, 112, 33, 56, 136, 64, 224, 64, 0, 0, 64, 224, 64, 17,
  72, 136, 32, 112, 32, 0, 0, 112, 96, 128, 34, 89, 137, 8, 16, 32,
  64, 128, 64, 32, 16, 8, 20, 100, 132, 252, 0, 0, 252, 18, 89, 137,
  128, 64, 32, 16, 8, 16, 32, 64, 128, 18, 105, 137, 120, 132, 132, 4,
  8, 16, 16, 0, 16, 18, 105, 137, 120, 132, 132, 156, 164, 172, 148, 128,
  120, 18, 105, 137, 48, 72, 132, 132, 132, 252, 132, 132, 132, 18, 105, 137,
  240, 136, 132, 136, 240, 136, 132, 136, 240, 18, 105, 137, 120, 132, 128, 128,
  128, 128, 128, 132, 120, 18, 105, 137, 240, 136, 132, 132, 132, 132, 132, 136,
  240, 18, 105, 137, 252, 128, 128, 128, 240, 128, 128, 128, 252, 18, 105, 137,
  252, 128, 128, 128, 240, 128, 128, 128, 128, 18, 105, 137, 120, 132, 128, 128,
  128, 156, 132, 140, 116, 18, 105, 137, 132, 132, 132, 132, 252, 132, 132, 132,
  132, 18, 89, 137, 248, 32, 32, 32, 32, 32, 32, 32, 248, 18, 121, 137,
  62, 8, 8, 8, 8, 8, 8, 136, 112, 18, 105, 137, 132, 136, 144, 160,
  192, 160, 144, 136, 132, 18, 105, 137, 128, 128, 128, 128, 128, 128, 128, 128,
  252, 2, 121, 137, 130, 130, 198, 170, 146, 146, 130, 130, 130, 18, 105, 137,
  132, 132, 196, 164, 148, 140, 132, 132, 132, 18, 105, 137, 120, 132, 132, 132,
  132, 132, 132, 132, 120, 18, 105, 137, 248, 132, 132, 132, 248, 128, 128, 128,
  128, 17, 106, 138, 120, 132, 132, 132, 132, 132, 164, 148, 120, 4, 18, 105,
  137, 248, 132, 132, 132, 248, 160, 144, 136, 132, 18, 105, 137, 120, 132, 128,
  128, 120, 4, 4, 132, 120, 2, 121, 137, 254, 16, 16, 16, 16, 16, 16,
  16, 16, 18, 105, 137, 132, 132, 132, 132, 132, 132, 132, 132, 120, 2, 121,
  137, 130, 130, 68, 68, 68, 40, 40, 40, 16, 2, 121, 137, 130, 130, 130,
  130, 146, 146, 146, 170, 68, 2, 121, 137, 130, 130, 68, 40, 16, 40, 68,
  130, 130, 2, 121, 137, 130, 130, 68, 40, 16, 16, 16, 16, 16, 18, 105,
  137, 252, 4, 8, 16, 32, 64, 128, 128, 252, 34, 73, 137, 240, 128, 128,
  128, 128, 128, 128, 128, 240, 2, 121, 137, 128, 128, 64, 32, 16, 8, 4,
  2, 2, 18, 73, 137, 240, 16, 16, 16, 16, 16, 16, 16, 240, 24, 83,
  131, 32, 80, 136, 1, 113, 129, 254, 58, 34, 130, 128, 64, 18, 102, 134,
  120, 4, 124, 132, 140, 116, 18, 105, 137, 128, 128, 128, 184, 196, 132, 132,
  196, 184, 18, 102, 134, 120, 132, 128, 128, 132, 120, 18, 105, 137, 4, 4,
  4, 116, 140, 132, 132, 140, 116, 18, 102, 134, 120, 132, 252, 128, 132, 120,
  18, 105, 137, 56, 68, 64, 64, 248, 64, 64, 64, 64, 16, 104, 136, 116,
  136, 136, 112, 128, 120, 132, 120, 18, 105, 137, 128, 128, 128, 184, 196, 132,
  132, 132, 132, 18, 88, 136, 32, 0, 96, 32, 32, 32, 32, 248, 16, 90,
  138, 8, 0, 24, 8, 8, 8, 8, 136, 136, 112, 18, 105, 137, 128, 128,
  128, 136, 144, 224, 144, 136, 132, 18, 89, 137, 96, 32, 32, 32, 32, 32,
  32, 32, 248, 2, 118, 134, 236, 146, 146, 146, 146, 130, 18, 102, 134, 184,
  196, 132, 132, 132, 132, 18, 102, 134, 120, 132, 132, 132, 132, 120, 16, 104,
  136, 184, 196, 132, 196, 184, 128, 128, 128, 16, 104, 136, 116, 140, 132, 140,
  116, 4, 4, 4, 18, 102, 134, 184, 68, 64, 64, 64, 64, 18, 102, 134,
  120, 132, 96, 24, 132, 120, 18, 104, 136, 64, 64, 248, 64, 64, 64, 68,
  56, 18, 102, 134, 136, 136, 136, 136, 136, 116, 18, 86, 134, 136, 136, 136,
  80, 80, 32, 2, 118, 134, 130, 130, 146, 146, 170, 68, 18, 102, 134, 132,
  72, 48, 48, 72, 132, 16, 104, 136, 132, 132, 132, 140, 116, 4, 132, 120,
  18, 102, 134, 252, 8, 16, 32, 64, 252, 34, 89, 137, 56, 64, 64, 32,
  192, 32, 64, 64, 56, 50, 25, 137, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 18, 89, 137, 224, 16, 16, 32, 24, 32, 16, 16, 224, 24, 83, 131,
  72, 168, 144, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--15-140-75-75-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 4, '1' Height: 10
  Calculated Max Values w= 9 h=15 x= 8 y=10 dx= 9 dy= 0 ascent=12 len=30
  Font Bounding box     w= 9 h=15 x= 0 y=-3
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent = 4 descent= 0
  X Font      ascent =10 descent= 0
  Max Font    ascent =12 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_9x15_67_75[3804] U8G_FONT_SECTION("u8g_font_9x15_67_75") = {
  0, 9, 15, 0, 253, 4, 1, 255, 4, 34, 32, 255, 0, 12, 253, 10,
  0, 8, 7, 7, 9, 0, 1, 72, 36, 18, 255, 18, 36, 72, 7, 10,
  10, 9, 1, 0, 16, 16, 16, 146, 84, 56, 146, 84, 56, 16, 7, 7,
  7, 9, 1, 1, 16, 34, 68, 248, 68, 34, 16, 7, 7, 7, 9, 1,
  1, 16, 136, 68, 62, 68, 136, 16, 7, 7, 7, 9, 1, 1, 16, 34,
  66, 254, 66, 34, 16, 7, 10, 10, 9, 1, 0, 16, 56, 84, 146, 16,
  16, 16, 16, 16, 124, 7, 7, 7, 9, 1, 1, 16, 136, 132, 254, 132,
  136, 16, 7, 10, 10, 9, 1, 0, 124, 16, 16, 16, 16, 16, 146, 84,
  56, 16, 7, 10, 10, 9, 1, 0, 16, 56, 84, 146, 16, 146, 84, 56,
  16, 254, 8, 7, 7, 9, 0, 1, 16, 34, 65, 254, 64, 32, 16, 8,
  7, 7, 9, 0, 1, 8, 68, 130, 127, 2, 4, 8, 8, 7, 7, 9,
  0, 1, 16, 34, 69, 254, 68, 36, 16, 8, 7, 7, 9, 0, 1, 8,
  68, 162, 127, 34, 36, 8, 9, 5, 10, 9, 0, 2, 34, 0, 73, 0,
  247, 128, 65, 0, 34, 0, 9, 5, 10, 9, 0, 2, 34, 0, 73, 0,
  255, 128, 73, 0, 34, 0, 5, 10, 10, 9, 2, 0, 32, 64, 72, 184,
  200, 16, 16, 160, 120, 32, 6, 10, 10, 9, 1, 0, 32, 64, 252, 68,
  36, 4, 4, 4, 4, 4, 7, 10, 10, 9, 1, 0, 8, 4, 254, 132,
  136, 128, 128, 128, 128, 128, 6, 10, 10, 9, 1, 0, 4, 4, 4, 4,
  4, 36, 68, 252, 64, 32, 7, 10, 10, 9, 1, 0, 128, 128, 128, 128,
  128, 136, 132, 254, 4, 8, 7, 8, 8, 9, 1, 0, 248, 8, 8, 8,
  8, 42, 28, 8, 7, 8, 8, 9, 1, 1, 2, 2, 2, 34, 66, 254,
  64, 32, 9, 7, 14, 9, 0, 2, 14, 0, 17, 0, 32, 128, 32, 128,
  168, 128, 112, 0, 32, 0, 9, 7, 14, 9, 0, 2, 56, 0, 68, 0,
  130, 0, 130, 0, 138, 128, 7, 0, 2, 0, 7, 10, 10, 9, 1, 0,
  254, 64, 112, 96, 80, 8, 8, 4, 2, 2, 7, 9, 9, 9, 1, 0,
  144, 160, 254, 160, 146, 10, 254, 10, 18, 9, 7, 14, 9, 0, 1, 50,
  0, 71, 0, 138, 128, 130, 0, 130, 0, 68, 0, 56, 0, 9, 7, 14,
  9, 0, 1, 38, 0, 113, 0, 168, 128, 32, 128, 32, 128, 17, 0, 14,
  0, 7, 4, 4, 9, 1, 3, 16, 32, 64, 254, 7, 4, 4, 9, 1,
  0, 254, 64, 32, 16, 4, 10, 10, 9, 4, 0, 128, 192, 160, 144, 128,
  128, 128, 128, 128, 128, 4, 10, 10, 9, 1, 0, 16, 48, 80, 144, 16,
  16, 16, 16, 16, 16, 7, 4, 4, 9, 1, 3, 16, 8, 4, 254, 7,
  4, 4, 9, 1, 0, 254, 4, 8, 16, 4, 10, 10, 9, 4, 0, 128,
  128, 128, 128, 128, 128, 144, 160, 192, 128, 4, 10, 10, 9, 1, 0, 16,
  16, 16, 16, 16, 16, 144, 80, 48, 16, 7, 9, 9, 9, 1, 0, 8,
  4, 254, 4, 40, 64, 254, 64, 32, 9, 10, 20, 9, 0, 0, 34, 0,
  114, 0, 170, 0, 34, 0, 34, 0, 34, 0, 34, 0, 42, 128, 39, 0,
  34, 0, 7, 9, 9, 9, 1, 0, 32, 64, 254, 64, 40, 4, 254, 4,
  8, 7, 10, 10, 9, 1, 0, 32, 64, 254, 64, 32, 32, 64, 254, 64,
  32, 9, 10, 20, 9, 0, 0, 34, 0, 119, 0, 170, 128, 34, 0, 34,
  0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 7, 10, 10, 9, 1,
  0, 8, 4, 254, 4, 8, 8, 4, 254, 4, 8, 9, 10, 20, 9, 0,
  0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 170,
  128, 119, 0, 34, 0, 7, 7, 7, 9, 1, 1, 32, 64, 254, 0, 254,
  4, 8, 7, 7, 7, 9, 1, 1, 8, 4, 254, 0, 254, 64, 32, 9,
  7, 14, 9, 0, 1, 16, 0, 33, 0, 127, 128, 130, 0, 127, 128, 36,
  0, 16, 0, 9, 7, 14, 9, 0, 1, 20, 0, 34, 0, 127, 0, 136,
  128, 127, 0, 34, 0, 20, 0, 9, 7, 14, 9, 0, 1, 4, 0, 18,
  0, 255, 0, 32, 128, 255, 0, 66, 0, 4, 0, 9, 7, 14, 9, 0,
  1, 16, 0, 32, 0, 127, 128, 128, 0, 127, 128, 32, 0, 16, 0, 7,
  10, 10, 9, 1, 0, 16, 40, 108, 170, 40, 40, 40, 40, 40, 40, 9,
  7, 14, 9, 0, 1, 4, 0, 2, 0, 255, 0, 0, 128, 255, 0, 2,
  0, 4, 0, 7, 10, 10, 9, 1, 0, 40, 40, 40, 40, 40, 40, 170,
  108, 40, 16, 9, 7, 14, 9, 0, 1, 20, 0, 34, 0, 127, 0, 128,
  128, 127, 0, 34, 0, 20, 0, 7, 10, 10, 9, 1, 0, 16, 40, 108,
  170, 40, 40, 170, 108, 40, 16, 7, 7, 7, 9, 1, 1, 252, 144, 136,
  196, 162, 144, 8, 7, 7, 7, 9, 1, 1, 126, 18, 34, 70, 138, 18,
  32, 7, 7, 7, 9, 1, 1, 32, 18, 138, 70, 34, 18, 126, 7, 7,
  7, 9, 1, 1, 8, 144, 162, 196, 136, 144, 252, 9, 9, 18, 9, 0,
  0, 8, 0, 16, 0, 63, 128, 64, 0, 255, 128, 64, 0, 63, 128, 16,
  0, 8, 0, 9, 9, 18, 9, 0, 0, 8, 0, 4, 0, 254, 0, 1,
  0, 255, 128, 1, 0, 254, 0, 4, 0, 8, 0, 8, 7, 7, 9, 0,
  1, 16, 32, 72, 245, 66, 32, 16, 8, 7, 7, 9, 0, 1, 8, 4,
  18, 175, 66, 4, 8, 7, 10, 10, 9, 1, 0, 16, 56, 84, 146, 16,
  124, 16, 124, 16, 16, 7, 10, 10, 9, 1, 0, 16, 16, 124, 16, 124,
  16, 146, 84, 56, 16, 7, 7, 7, 9, 1, 1, 16, 32, 64, 182, 64,
  32, 16, 7, 10, 10, 9, 1, 0, 16, 40, 84, 146, 0, 16, 16, 0,
  16, 16, 7, 7, 7, 9, 1, 1, 16, 8, 4, 218, 4, 8, 16, 7,
  10, 10, 9, 1, 0, 16, 16, 0, 16, 16, 0, 146, 84, 40, 16, 7,
  5, 5, 9, 1, 2, 144, 160, 254, 160, 144, 7, 5, 5, 9, 1, 2,
  18, 10, 254, 10, 18, 9, 7, 14, 9, 0, 1, 16, 0, 48, 0, 95,
  128, 128, 128, 95, 128, 48, 0, 16, 0, 7, 10, 10, 9, 1, 0, 16,
  40, 68, 238, 40, 40, 40, 40, 40, 56, 9, 7, 14, 9, 0, 1, 4,
  0, 6, 0, 253, 0, 128, 128, 253, 0, 6, 0, 4, 0, 7, 10, 10,
  9, 1, 0, 56, 40, 40, 40, 40, 40, 238, 68, 40, 16, 7, 11, 11,
  9, 1, 0, 16, 40, 68, 238, 40, 40, 56, 0, 56, 40, 56, 7, 11,
  11, 9, 1, 255, 16, 40, 68, 238, 40, 40, 40, 40, 108, 68, 124, 7,
  11, 11, 9, 1, 255, 16, 40, 68, 254, 40, 40, 40, 40, 108, 68, 124,
  7, 11, 11, 9, 1, 255, 16, 40, 68, 254, 56, 56, 56, 56, 124, 68,
  124, 7, 11, 11, 9, 1, 255, 16, 40, 68, 238, 68, 238, 40, 40, 40,
  40, 56, 7, 11, 11, 9, 1, 255, 16, 40, 68, 238, 68, 238, 40, 40,
  108, 68, 124, 9, 7, 14, 9, 0, 1, 132, 0, 134, 0, 253, 0, 128,
  128, 253, 0, 134, 0, 132, 0, 7, 7, 7, 9, 1, 0, 254, 128, 188,
  176, 168, 164, 130, 7, 7, 7, 9, 1, 0, 130, 74, 42, 26, 122, 2,
  254, 7, 11, 11, 9, 1, 255, 16, 40, 68, 238, 40, 40, 40, 238, 68,
  40, 16, 9, 7, 14, 9, 0, 1, 4, 0, 50, 0, 73, 0, 255, 128,
  73, 0, 50, 0, 4, 0, 9, 10, 20, 9, 0, 0, 34, 0, 39, 0,
  42, 128, 34, 0, 34, 0, 34, 0, 34, 0, 170, 0, 114, 0, 34, 0,
  7, 13, 13, 9, 1, 254, 8, 4, 254, 4, 8, 4, 254, 4, 8, 4,
  254, 4, 8, 8, 5, 5, 9, 0, 2, 36, 68, 255, 68, 36, 8, 5,
  5, 9, 0, 2, 36, 34, 255, 34, 36, 9, 5, 10, 9, 0, 2, 42,
  0, 73, 0, 255, 128, 73, 0, 42, 0, 8, 5, 5, 9, 0, 2, 42,
  74, 255, 74, 42, 8, 5, 5, 9, 0, 2, 84, 82, 255, 82, 84, 9,
  5, 10, 9, 0, 2, 85, 0, 148, 128, 255, 128, 148, 128, 85, 0, 7,
  7, 7, 9, 1, 1, 16, 48, 80, 158, 80, 48, 16, 7, 7, 7, 9,
  1, 1, 16, 24, 20, 242, 20, 24, 16, 8, 5, 5, 9, 0, 2, 36,
  102, 189, 102, 36, 9, 7, 14, 9, 0, 5, 255, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 9, 2, 4, 9, 0, 253, 255, 128,
  255, 128, 9, 4, 8, 9, 0, 253, 255, 128, 255, 128, 255, 128, 255, 128,
  9, 6, 12, 9, 0, 253, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128,
  255, 128, 9, 8, 16, 9, 0, 253, 255, 128, 255, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 9, 9, 18, 9, 0, 253, 255, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128,
  9, 11, 22, 9, 0, 253, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 9, 13, 26, 9,
  0, 253, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 9, 15, 30, 9,
  0, 253, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128,
  8, 15, 15, 9, 0, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 7, 15, 15, 9, 0, 253, 254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 6, 15, 15, 9, 0, 253,
  252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 5,
  15, 15, 9, 0, 253, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
  248, 248, 248, 248, 3, 15, 15, 9, 0, 253, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 2, 15, 15, 9, 0, 253, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 1, 15,
  15, 9, 0, 253, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 4, 15, 15, 9, 5, 253, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 9, 15, 30, 9, 0, 253, 170, 128,
  0, 0, 85, 0, 0, 0, 170, 128, 0, 0, 85, 0, 0, 0, 170, 128,
  0, 0, 85, 0, 0, 0, 170, 128, 0, 0, 85, 0, 9, 15, 30, 9,
  0, 253, 170, 128, 85, 0, 170, 128, 85, 0, 170, 128, 85, 0, 170, 128,
  85, 0, 170, 128, 85, 0, 170, 128, 85, 0, 170, 128, 85, 0, 170, 128,
  9, 15, 30, 9, 0, 253, 255, 128, 85, 0, 255, 128, 170, 128, 255, 128,
  85, 0, 255, 128, 170, 128, 255, 128, 85, 0, 255, 128, 170, 128, 255, 128,
  85, 0, 255, 128, 9, 2, 4, 9, 0, 10, 255, 128, 255, 128, 1, 15,
  15, 9, 8, 253, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 5, 8, 8, 9, 0, 253, 248, 248, 248, 248, 248, 248, 248,
  248, 4, 8, 8, 9, 5, 253, 240, 240, 240, 240, 240, 240, 240, 240, 5,
  7, 7, 9, 0, 5, 248, 248, 248, 248, 248, 248, 248, 9, 15, 30, 9,
  0, 253, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128,
  9, 15, 30, 9, 0, 253, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 9, 15, 30, 9, 0, 253, 255, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 9, 15, 30, 9, 0, 253, 255, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 4, 7, 7, 9,
  5, 5, 240, 240, 240, 240, 240, 240, 240, 9, 15, 30, 9, 0, 253, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 9, 15, 30,
  9, 0, 253, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255,
  128, 7, 7, 7, 9, 1, 1, 254, 254, 254, 254, 254, 254, 254, 7, 7,
  7, 9, 1, 1, 254, 130, 130, 130, 130, 130, 254, 7, 7, 7, 9, 1,
  1, 124, 130, 130, 130, 130, 130, 124, 7, 7, 7, 9, 1, 1, 254, 130,
  186, 186, 186, 130, 254, 7, 7, 7, 9, 1, 1, 254, 130, 254, 130, 254,
  130, 254, 7, 7, 7, 9, 1, 1, 254, 170, 170, 170, 170, 170, 254, 7,
  7, 7, 9, 1, 1, 254, 170, 254, 170, 254, 170, 254, 7, 7, 7, 9,
  1, 1, 254, 146, 138, 198, 162, 146, 254, 7, 7, 7, 9, 1, 1, 254,
  146, 162, 198, 138, 146, 254, 7, 7, 7, 9, 1, 1, 254, 214, 138, 214,
  162, 214, 254, 3, 3, 3, 9, 3, 3, 224, 224, 224, 3, 3, 3, 9,
  3, 3, 224, 160, 224, 9, 5, 10, 9, 0, 2, 255, 128, 255, 128, 255,
  128, 255, 128, 255, 128, 9, 5, 10, 9, 0, 2, 255, 128, 128, 128, 128,
  128, 128, 128, 255, 128, 5, 9, 9, 9, 2, 0, 248, 248, 248, 248, 248,
  248, 248, 248, 248, 5, 9, 9, 9, 2, 0, 248, 136, 136, 136, 136, 136,
  136, 136, 248, 9, 5, 10, 9, 0, 2, 127, 128, 127, 128, 255, 128, 255,
  0, 255, 0, 9, 5, 10, 9, 0, 2, 127, 128, 64, 128, 128, 128, 129,
  0, 255, 0, 9, 10, 20, 9, 0, 0, 8, 0, 8, 0, 28, 0, 28,
  0, 62, 0, 62, 0, 127, 0, 127, 0, 255, 128, 255, 128, 9, 10, 20,
  9, 0, 0, 8, 0, 8, 0, 20, 0, 20, 0, 34, 0, 34, 0, 65,
  0, 65, 0, 128, 128, 255, 128, 7, 7, 7, 9, 1, 1, 16, 16, 56,
  56, 124, 124, 254, 7, 7, 7, 9, 1, 1, 16, 16, 40, 40, 68, 68,
  254, 9, 9, 18, 9, 0, 0, 192, 0, 240, 0, 252, 0, 255, 0, 255,
  128, 255, 0, 252, 0, 240, 0, 192, 0, 9, 9, 18, 9, 0, 0, 192,
  0, 176, 0, 140, 0, 131, 0, 128, 128, 131, 0, 140, 0, 176, 0, 192,
  0, 7, 7, 7, 9, 1, 1, 128, 224, 248, 254, 248, 224, 128, 7, 7,
  7, 9, 1, 1, 128, 224, 152, 134, 152, 224, 128, 9, 5, 10, 9, 0,
  2, 224, 0, 252, 0, 255, 128, 252, 0, 224, 0, 9, 5, 10, 9, 0,
  2, 224, 0, 156, 0, 131, 128, 156, 0, 224, 0, 9, 10, 20, 9, 0,
  0, 255, 128, 255, 128, 127, 0, 127, 0, 62, 0, 62, 0, 28, 0, 28,
  0, 8, 0, 8, 0, 9, 10, 20, 9, 0, 0, 255, 128, 128, 128, 65,
  0, 65, 0, 34, 0, 34, 0, 20, 0, 20, 0, 8, 0, 8, 0, 7,
  7, 7, 9, 1, 1, 254, 124, 124, 56, 56, 16, 16, 7, 7, 7, 9,
  1, 1, 254, 68, 68, 40, 40, 16, 16, 9, 9, 18, 9, 0, 0, 1,
  128, 7, 128, 31, 128, 127, 128, 255, 128, 127, 128, 31, 128, 7, 128, 1,
  128, 9, 9, 18, 9, 0, 0, 1, 128, 6, 128, 24, 128, 96, 128, 128,
  128, 96, 128, 24, 128, 6, 128, 1, 128, 7, 7, 7, 9, 1, 1, 2,
  14, 62, 254, 62, 14, 2, 7, 7, 7, 9, 1, 1, 2, 14, 50, 194,
  50, 14, 2, 9, 5, 10, 9, 0, 2, 3, 128, 31, 128, 255, 128, 31,
  128, 3, 128, 9, 5, 10, 9, 0, 2, 3, 128, 28, 128, 224, 128, 28,
  128, 3, 128, 9, 9, 18, 9, 0, 0, 8, 0, 28, 0, 62, 0, 127,
  0, 255, 128, 127, 0, 62, 0, 28, 0, 8, 0, 9, 9, 18, 9, 0,
  0, 8, 0, 20, 0, 34, 0, 65, 0, 128, 128, 65, 0, 34, 0, 20,
  0, 8, 0, 9, 9, 18, 9, 0, 0, 8, 0, 20, 0, 34, 0, 73,
  0, 156, 128, 73, 0, 34, 0, 20, 0, 8, 0, 7, 7, 7, 9, 1,
  1, 56, 68, 146, 186, 146, 68, 56, 5, 9, 9, 9, 2, 0, 32, 32,
  80, 80, 136, 80, 80, 32, 32, 7, 7, 7, 9, 1, 1, 56, 68, 130,
  130, 130, 68, 56, 7, 7, 7, 9, 1, 1, 16, 68, 0, 130, 0, 68,
  16, 7, 7, 7, 9, 1, 1, 56, 108, 170, 170, 170, 108, 56, 7, 7,
  7, 9, 1, 1, 56, 68, 146, 170, 146, 68, 56, 7, 7, 7, 9, 1,
  1, 56, 124, 254, 254, 254, 124, 56, 7, 7, 7, 9, 1, 1, 56, 116,
  242, 242, 242, 116, 56, 7, 7, 7, 9, 1, 1, 56, 92, 158, 158, 158,
  92, 56, 7, 7, 7, 9, 1, 1, 56, 68, 130, 254, 254, 124, 56, 7,
  7, 7, 9, 1, 1, 56, 124, 254, 254, 130, 68, 56, 7, 7, 7, 9,
  1, 1, 56, 92, 158, 158, 130, 68, 56, 7, 7, 7, 9, 1, 1, 56,
  92, 158, 254, 254, 124, 56, 4, 7, 7, 9, 1, 1, 48, 112, 240, 240,
  240, 112, 48, 4, 7, 7, 9, 4, 1, 192, 224, 240, 240, 240, 224, 192,
  9, 15, 30, 9, 0, 253, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128,
  227, 128, 193, 128, 193, 128, 193, 128, 227, 128, 255, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 9, 15, 30, 9, 0, 253, 255, 128, 255, 128, 255, 128,
  255, 128, 227, 128, 221, 128, 190, 128, 190, 128, 190, 128, 221, 128, 227, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 9, 8, 16, 9, 0, 4, 255, 128,
  255, 128, 255, 128, 255, 128, 227, 128, 221, 128, 190, 128, 190, 128, 9, 8,
  16, 9, 0, 253, 190, 128, 190, 128, 221, 128, 227, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 4, 4, 4, 9, 1, 4, 48, 64, 128, 128, 4, 4,
  4, 9, 4, 4, 192, 32, 16, 16, 4, 4, 4, 9, 4, 1, 16, 16,
  32, 192, 4, 4, 4, 9, 1, 1, 128, 128, 64, 48, 7, 4, 4, 9,
  1, 4, 56, 68, 130, 130, 7, 4, 4, 9, 1, 1, 130, 130, 68, 56,
  7, 7, 7, 9, 1, 1, 2, 6, 14, 30, 62, 126, 254, 7, 7, 7,
  9, 1, 1, 128, 192, 224, 240, 248, 252, 254, 7, 7, 7, 9, 1, 1,
  254, 252, 248, 240, 224, 192, 128, 7, 7, 7, 9, 1, 1, 254, 126, 62,
  30, 14, 6, 2, 5, 5, 5, 9, 2, 2, 112, 136, 136, 136, 112, 7,
  7, 7, 9, 1, 1, 254, 242, 242, 242, 242, 242, 254, 7, 7, 7, 9,
  1, 1, 254, 158, 158, 158, 158, 158, 254, 7, 7, 7, 9, 1, 1, 254,
  254, 250, 242, 226, 194, 254, 7, 7, 7, 9, 1, 1, 254, 134, 142, 158,
  190, 254, 254, 7, 7, 7, 9, 1, 1, 254, 146, 146, 146, 146, 146, 254,
  9, 10, 20, 9, 0, 0, 8, 0, 8, 0, 20, 0, 20, 0, 34, 0,
  42, 0, 93, 0, 73, 0, 128, 128, 255, 128, 9, 10, 20, 9, 0, 0,
  8, 0, 8, 0, 28, 0, 28, 0, 58, 0, 58, 0, 121, 0, 121, 0,
  248, 128, 255, 128, 9, 10, 20, 9, 0, 0, 8, 0, 8, 0, 28, 0,
  28, 0, 46, 0, 46, 0, 79, 0, 79, 0, 143, 128, 255, 128, 9, 9,
  18, 9, 0, 0, 62, 0, 65, 0, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 65, 0, 62, 0, 7, 7, 7, 9, 1, 1, 254, 146, 146, 242,
  130, 130, 254, 7, 7, 7, 9, 1, 1, 254, 130, 130, 242, 146, 146, 254,
  7, 7, 7, 9, 1, 1, 254, 130, 130, 158, 146, 146, 254, 7, 7, 7,
  9, 1, 1, 254, 146, 146, 158, 130, 130, 254, 7, 7, 7, 9, 1, 1,
  124, 146, 146, 242, 130, 130, 124, 7, 7, 7, 9, 1, 1, 124, 130, 130,
  242, 146, 146, 124, 7, 7, 7, 9, 1, 1, 124, 130, 130, 158, 146, 146,
  124, 7, 7, 7, 9, 1, 1, 124, 146, 146, 158, 130, 130, 124, 6, 6,
  6, 9, 1, 1, 252, 136, 144, 160, 192, 128, 6, 6, 6, 9, 1, 1,
  252, 68, 36, 20, 12, 4, 6, 6, 6, 9, 1, 1, 128, 192, 160, 144,
  136, 252, 6, 6, 6, 9, 1, 1, 252, 132, 132, 132, 132, 252, 6, 6,
  6, 9, 1, 1, 252, 252, 252, 252, 252, 252, 5, 5, 5, 9, 2, 1,
  248, 136, 136, 136, 248, 5, 5, 5, 9, 2, 1, 248, 248, 248, 248, 248,
  6, 6, 6, 9, 1, 1, 4, 12, 20, 36, 68, 252
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--15-140-75-75-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 5
  Calculated Max Values w= 9 h=10 x= 3 y= 3 dx= 9 dy= 0 ascent=10 len=20
  Font Bounding box     w= 9 h=15 x= 0 y=-3
  Calculated Min Values           x= 0 y= 0 dx= 0 dy= 0
  Pure Font   ascent = 9 descent= 0
  X Font      ascent = 9 descent= 0
  Max Font    ascent =10 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_9x15_75r[792] U8G_FONT_SECTION("u8g_font_9x15_75r") = {
  0, 9, 15, 0, 253, 9, 2, 33, 0, 0, 32, 79, 0, 10, 0, 9,
  0, 7, 7, 7, 9, 1, 1, 254, 254, 254, 254, 254, 254, 254, 7, 7,
  7, 9, 1, 1, 254, 130, 130, 130, 130, 130, 254, 7, 7, 7, 9, 1,
  1, 124, 130, 130, 130, 130, 130, 124, 7, 7, 7, 9, 1, 1, 254, 130,
  186, 186, 186, 130, 254, 7, 7, 7, 9, 1, 1, 254, 130, 254, 130, 254,
  130, 254, 7, 7, 7, 9, 1, 1, 254, 170, 170, 170, 170, 170, 254, 7,
  7, 7, 9, 1, 1, 254, 170, 254, 170, 254, 170, 254, 7, 7, 7, 9,
  1, 1, 254, 146, 138, 198, 162, 146, 254, 7, 7, 7, 9, 1, 1, 254,
  146, 162, 198, 138, 146, 254, 7, 7, 7, 9, 1, 1, 254, 214, 138, 214,
  162, 214, 254, 3, 3, 3, 9, 3, 3, 224, 224, 224, 3, 3, 3, 9,
  3, 3, 224, 160, 224, 9, 5, 10, 9, 0, 2, 255, 128, 255, 128, 255,
  128, 255, 128, 255, 128, 9, 5, 10, 9, 0, 2, 255, 128, 128, 128, 128,
  128, 128, 128, 255, 128, 5, 9, 9, 9, 2, 0, 248, 248, 248, 248, 248,
  248, 248, 248, 248, 5, 9, 9, 9, 2, 0, 248, 136, 136, 136, 136, 136,
  136, 136, 248, 9, 5, 10, 9, 0, 2, 127, 128, 127, 128, 255, 128, 255,
  0, 255, 0, 9, 5, 10, 9, 0, 2, 127, 128, 64, 128, 128, 128, 129,
  0, 255, 0, 9, 10, 20, 9, 0, 0, 8, 0, 8, 0, 28, 0, 28,
  0, 62, 0, 62, 0, 127, 0, 127, 0, 255, 128, 255, 128, 9, 10, 20,
  9, 0, 0, 8, 0, 8, 0, 20, 0, 20, 0, 34, 0, 34, 0, 65,
  0, 65, 0, 128, 128, 255, 128, 7, 7, 7, 9, 1, 1, 16, 16, 56,
  56, 124, 124, 254, 7, 7, 7, 9, 1, 1, 16, 16, 40, 40, 68, 68,
  254, 9, 9, 18, 9, 0, 0, 192, 0, 240, 0, 252, 0, 255, 0, 255,
  128, 255, 0, 252, 0, 240, 0, 192, 0, 9, 9, 18, 9, 0, 0, 192,
  0, 176, 0, 140, 0, 131, 0, 128, 128, 131, 0, 140, 0, 176, 0, 192,
  0, 7, 7, 7, 9, 1, 1, 128, 224, 248, 254, 248, 224, 128, 7, 7,
  7, 9, 1, 1, 128, 224, 152, 134, 152, 224, 128, 9, 5, 10, 9, 0,
  2, 224, 0, 252, 0, 255, 128, 252, 0, 224, 0, 9, 5, 10, 9, 0,
  2, 224, 0, 156, 0, 131, 128, 156, 0, 224, 0, 9, 10, 20, 9, 0,
  0, 255, 128, 255, 128, 127, 0, 127, 0, 62, 0, 62, 0, 28, 0, 28,
  0, 8, 0, 8, 0, 9, 10, 20, 9, 0, 0, 255, 128, 128, 128, 65,
  0, 65, 0, 34, 0, 34, 0, 20, 0, 20, 0, 8, 0, 8, 0, 7,
  7, 7, 9, 1, 1, 254, 124, 124, 56, 56, 16, 16, 7, 7, 7, 9,
  1, 1, 254, 68, 68, 40, 40, 16, 16, 9, 9, 18, 9, 0, 0, 1,
  128, 7, 128, 31, 128, 127, 128, 255, 128, 127, 128, 31, 128, 7, 128, 1,
  128, 9, 9, 18, 9, 0, 0, 1, 128, 6, 128, 24, 128, 96, 128, 128,
  128, 96, 128, 24, 128, 6, 128, 1, 128, 7, 7, 7, 9, 1, 1, 2,
  14, 62, 254, 62, 14, 2, 7, 7, 7, 9, 1, 1, 2, 14, 50, 194,
  50, 14, 2, 9, 5, 10, 9, 0, 2, 3, 128, 31, 128, 255, 128, 31,
  128, 3, 128, 9, 5, 10, 9, 0, 2, 3, 128, 28, 128, 224, 128, 28,
  128, 3, 128, 9, 9, 18, 9, 0, 0, 8, 0, 28, 0, 62, 0, 127,
  0, 255, 128, 127, 0, 62, 0, 28, 0, 8, 0, 9, 9, 18, 9, 0,
  0, 8, 0, 20, 0, 34, 0, 65, 0, 128, 128, 65, 0, 34, 0, 20,
  0, 8, 0, 9, 9, 18, 9, 0, 0, 8, 0, 20, 0, 34, 0, 73,
  0, 156, 128, 73, 0, 34, 0, 20, 0, 8, 0, 7, 7, 7, 9, 1,
  1, 56, 68, 146, 186, 146, 68, 56, 5, 9, 9, 9, 2, 0, 32, 32,
  80, 80, 136, 80, 80, 32, 32, 7, 7, 7, 9, 1, 1, 56, 68, 130,
  130, 130, 68, 56, 7, 7, 7, 9, 1, 1, 16, 68, 0, 130, 0, 68,
  16, 7, 7, 7, 9, 1, 1, 56, 108, 170, 170, 170, 108, 56, 7, 7,
  7, 9, 1, 1, 56, 68, 146, 170, 146, 68, 56, 7, 7, 7, 9, 1,
  1, 56, 124, 254, 254, 254, 124, 56
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--15-140-75-75-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 0, '1' Height: 9
  Calculated Max Values w= 9 h=13 x= 4 y= 5 dx= 9 dy= 0 ascent=12 len=26
  Font Bounding box     w= 9 h=15 x= 0 y=-3
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 9 descent= 0
  X Font      ascent =11 descent= 0
  Max Font    ascent =12 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_9x15_78_79[3795] U8G_FONT_SECTION("u8g_font_9x15_78_79") = {
  0, 9, 15, 0, 253, 9, 2, 231, 4, 175, 32, 255, 0, 12, 254, 11,
  0, 9, 9, 18, 9, 0, 0, 62, 0, 28, 0, 136, 128, 201, 128, 247,
  128, 201, 128, 136, 128, 28, 0, 62, 0, 9, 9, 18, 9, 0, 0, 8,
  0, 20, 0, 255, 128, 162, 128, 65, 0, 162, 128, 255, 128, 20, 0, 8,
  0, 9, 9, 18, 9, 0, 0, 8, 0, 28, 0, 8, 0, 73, 0, 255,
  128, 73, 0, 8, 0, 28, 0, 8, 0, 9, 9, 18, 9, 0, 0, 8,
  0, 28, 0, 28, 0, 107, 0, 255, 128, 107, 0, 28, 0, 28, 0, 8,
  0, 9, 9, 18, 9, 0, 0, 8, 0, 28, 0, 28, 0, 107, 0, 255,
  128, 107, 0, 28, 0, 28, 0, 8, 0, 9, 9, 18, 9, 0, 0, 8,
  0, 28, 0, 28, 0, 107, 0, 255, 128, 107, 0, 28, 0, 28, 0, 8,
  0, 9, 9, 18, 9, 0, 0, 8, 0, 8, 0, 28, 0, 62, 0, 255,
  128, 62, 0, 28, 0, 8, 0, 8, 0, 9, 9, 18, 9, 0, 0, 8,
  0, 20, 0, 20, 0, 99, 0, 128, 128, 99, 0, 20, 0, 20, 0, 8,
  0, 255, 9, 9, 18, 9, 0, 0, 8, 0, 8, 0, 20, 0, 247, 128,
  65, 0, 34, 0, 73, 0, 85, 0, 99, 0, 9, 10, 20, 9, 0, 0,
  127, 0, 247, 128, 247, 128, 227, 128, 0, 0, 128, 128, 193, 128, 201, 128,
  156, 128, 127, 0, 9, 9, 18, 9, 0, 0, 8, 0, 8, 0, 28, 0,
  227, 128, 99, 0, 34, 0, 62, 0, 119, 0, 65, 0, 9, 9, 18, 9,
  0, 0, 8, 0, 8, 0, 20, 0, 235, 128, 93, 0, 42, 0, 34, 0,
  127, 0, 65, 0, 9, 9, 18, 9, 0, 0, 8, 0, 8, 0, 20, 0,
  235, 128, 93, 0, 42, 0, 34, 0, 127, 0, 65, 0, 9, 9, 18, 9,
  0, 0, 8, 0, 8, 0, 20, 0, 235, 128, 93, 0, 42, 0, 34, 0,
  127, 0, 65, 0, 9, 9, 18, 9, 0, 0, 8, 0, 8, 0, 20, 0,
  247, 128, 73, 0, 54, 0, 42, 0, 127, 0, 65, 0, 8, 7, 7, 9,
  0, 2, 24, 24, 44, 199, 46, 60, 102, 8, 9, 9, 9, 0, 0, 24,
  219, 255, 126, 24, 126, 255, 219, 24, 8, 9, 9, 9, 0, 0, 24, 219,
  255, 102, 36, 102, 255, 219, 24, 9, 9, 18, 9, 0, 0, 8, 0, 73,
  0, 42, 0, 28, 0, 255, 128, 28, 0, 42, 0, 73, 0, 8, 0, 9,
  9, 18, 9, 0, 0, 8, 0, 73, 0, 62, 0, 62, 0, 255, 128, 62,
  0, 62, 0, 73, 0, 8, 0, 9, 9, 18, 9, 0, 0, 8, 0, 73,
  0, 54, 0, 62, 0, 213, 128, 62, 0, 54, 0, 73, 0, 8, 0, 9,
  9, 18, 9, 0, 0, 8, 0, 136, 128, 107, 0, 62, 0, 28, 0, 62,
  0, 107, 0, 136, 128, 8, 0, 9, 9, 18, 9, 0, 0, 34, 0, 20,
  0, 148, 128, 127, 0, 28, 0, 127, 0, 148, 128, 20, 0, 34, 0, 9,
  9, 18, 9, 0, 0, 34, 0, 54, 0, 255, 128, 127, 0, 62, 0, 127,
  0, 255, 128, 54, 0, 34, 0, 9, 9, 18, 9, 0, 0, 42, 0, 42,
  0, 221, 128, 62, 0, 255, 128, 62, 0, 221, 128, 42, 0, 42, 0, 9,
  9, 18, 9, 0, 0, 42, 0, 42, 0, 221, 128, 42, 0, 255, 128, 42,
  0, 221, 128, 42, 0, 42, 0, 9, 11, 22, 9, 0, 0, 28, 0, 28,
  0, 201, 128, 201, 128, 34, 0, 8, 0, 34, 0, 201, 128, 201, 128, 28,
  0, 28, 0, 9, 11, 22, 9, 0, 0, 28, 0, 28, 0, 201, 128, 201,
  128, 62, 0, 20, 0, 62, 0, 201, 128, 201, 128, 28, 0, 28, 0, 9,
  11, 22, 9, 0, 0, 28, 0, 28, 0, 201, 128, 201, 128, 62, 0, 28,
  0, 62, 0, 201, 128, 201, 128, 28, 0, 28, 0, 9, 11, 22, 9, 0,
  0, 28, 0, 20, 0, 201, 128, 201, 128, 62, 0, 20, 0, 127, 0, 170,
  128, 201, 128, 28, 0, 28, 0, 8, 9, 9, 9, 0, 0, 24, 24, 219,
  255, 36, 36, 126, 231, 66, 255, 255, 255, 8, 9, 9, 9, 0, 0, 24,
  203, 189, 110, 24, 118, 189, 211, 24, 9, 12, 24, 9, 0, 0, 8, 0,
  42, 0, 93, 0, 170, 128, 107, 0, 221, 128, 221, 128, 107, 0, 170, 128,
  93, 0, 42, 0, 8, 0, 9, 12, 24, 9, 0, 0, 8, 0, 42, 0,
  93, 0, 170, 128, 107, 0, 221, 128, 221, 128, 107, 0, 170, 128, 93, 0,
  42, 0, 8, 0, 9, 12, 24, 9, 0, 0, 8, 0, 42, 0, 93, 0,
  170, 128, 107, 0, 221, 128, 221, 128, 107, 0, 170, 128, 93, 0, 42, 0,
  8, 0, 9, 9, 18, 9, 0, 0, 8, 0, 73, 0, 42, 0, 20, 0,
  235, 128, 20, 0, 42, 0, 73, 0, 8, 0, 9, 9, 18, 9, 0, 0,
  8, 0, 73, 0, 42, 0, 20, 0, 235, 128, 20, 0, 42, 0, 73, 0,
  8, 0, 8, 9, 9, 9, 0, 0, 24, 219, 203, 60, 24, 60, 211, 219,
  24, 9, 9, 18, 9, 0, 0, 8, 0, 73, 0, 42, 0, 0, 0, 235,
  128, 0, 0, 42, 0, 73, 0, 8, 0, 9, 9, 18, 9, 0, 0, 8,
  0, 73, 0, 42, 0, 28, 0, 255, 128, 28, 0, 42, 0, 73, 0, 8,
  0, 255, 9, 8, 16, 9, 0, 1, 62, 0, 67, 0, 129, 128, 129, 128,
  129, 128, 129, 128, 67, 0, 62, 0, 255, 9, 9, 18, 9, 0, 0, 254,
  0, 130, 0, 131, 128, 131, 128, 131, 128, 131, 128, 255, 128, 63, 128, 63,
  128, 9, 9, 18, 9, 0, 0, 63, 128, 63, 128, 255, 128, 131, 128, 131,
  128, 131, 128, 131, 128, 130, 0, 254, 0, 8, 8, 8, 9, 0, 0, 254,
  131, 131, 131, 131, 131, 255, 127, 8, 8, 8, 9, 0, 0, 127, 255, 131,
  131, 131, 131, 131, 254, 255, 255, 255, 9, 9, 18, 9, 0, 0, 8, 0,
  28, 0, 8, 0, 65, 0, 227, 128, 65, 0, 8, 0, 28, 0, 8, 0,
  255, 1, 10, 10, 9, 4, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 2, 10, 10, 9, 3, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 3, 10, 10, 9, 3, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 4, 6, 6, 9, 3, 5, 112, 128, 224, 240, 240, 96, 4, 6, 6,
  9, 3, 5, 96, 240, 240, 112, 16, 224, 9, 6, 12, 9, 0, 5, 115,
  128, 132, 0, 231, 0, 247, 128, 247, 128, 99, 0, 9, 6, 12, 9, 0,
  5, 99, 0, 247, 128, 247, 128, 115, 128, 16, 128, 231, 0, 255, 255, 7,
  10, 10, 9, 1, 0, 4, 126, 228, 228, 228, 124, 4, 100, 104, 48, 5,
  10, 10, 9, 2, 0, 112, 248, 248, 112, 32, 32, 0, 32, 112, 32, 5,
  10, 10, 9, 2, 0, 80, 248, 248, 112, 32, 32, 0, 32, 112, 32, 9,
  9, 18, 9, 0, 0, 99, 0, 247, 128, 255, 128, 255, 128, 127, 0, 62,
  0, 28, 0, 8, 0, 8, 0, 9, 9, 18, 9, 0, 0, 112, 0, 248,
  0, 252, 0, 126, 0, 63, 128, 126, 0, 252, 0, 248, 0, 112, 0, 9,
  12, 24, 9, 0, 0, 8, 0, 116, 128, 149, 0, 14, 0, 4, 0, 107,
  0, 247, 128, 255, 128, 127, 0, 62, 0, 28, 0, 8, 0, 9, 12, 24,
  9, 0, 0, 16, 0, 41, 0, 82, 0, 156, 0, 32, 0, 88, 0, 124,
  0, 60, 0, 254, 0, 254, 128, 255, 0, 126, 0, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 9, 9, 18, 9, 0, 0, 127,
  0, 247, 128, 231, 128, 247, 128, 247, 128, 247, 128, 247, 128, 227, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 227, 128, 221, 128, 253, 128, 251,
  128, 247, 128, 237, 128, 193, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 227, 128, 221, 128, 253, 128, 243, 128, 253, 128, 221, 128, 227, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 243, 128, 235, 128, 219, 128, 193,
  128, 251, 128, 251, 128, 251, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 193, 128, 223, 128, 223, 128, 195, 128, 253, 128, 253, 128, 195, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 225, 128, 223, 128, 223, 128, 195,
  128, 221, 128, 221, 128, 227, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 193, 128, 253, 128, 251, 128, 251, 128, 247, 128, 247, 128, 247, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 227, 128, 221, 128, 221, 128, 227,
  128, 221, 128, 221, 128, 227, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 225, 128, 221, 128, 221, 128, 225, 128, 253, 128, 253, 128, 227, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 219, 128, 213, 128, 213, 128, 213,
  128, 213, 128, 213, 128, 219, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 128, 128, 136, 128, 152, 128, 136, 128, 136, 128, 136, 128, 128, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 128, 128, 152, 128, 132, 128, 132,
  128, 136, 128, 156, 128, 128, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 128, 128, 152, 128, 132, 128, 136, 128, 132, 128, 152, 128, 128, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 128, 128, 136, 128, 152, 128, 168,
  128, 188, 128, 136, 128, 128, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 128, 128, 156, 128, 144, 128, 152, 128, 132, 128, 152, 128, 128, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 128, 128, 140, 128, 144, 128, 152,
  128, 148, 128, 136, 128, 128, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 128, 128, 156, 128, 132, 128, 136, 128, 136, 128, 136, 128, 128, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 128, 128, 136, 128, 148, 128, 136,
  128, 148, 128, 136, 128, 128, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 128, 128, 136, 128, 148, 128, 140, 128, 132, 128, 136, 128, 128, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 128, 128, 164, 128, 170, 128, 170,
  128, 170, 128, 164, 128, 128, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 247, 128, 231, 128, 247, 128, 247, 128, 247, 128, 247, 128, 247, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 227, 128, 221, 128, 253, 128, 251,
  128, 247, 128, 239, 128, 193, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 227, 128, 221, 128, 253, 128, 243, 128, 253, 128, 221, 128, 227, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 243, 128, 235, 128, 219, 128, 193,
  128, 251, 128, 251, 128, 251, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 193, 128, 223, 128, 223, 128, 195, 128, 253, 128, 253, 128, 195, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 225, 128, 223, 128, 223, 128, 195,
  128, 221, 128, 221, 128, 227, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 193, 128, 253, 128, 251, 128, 251, 128, 247, 128, 247, 128, 247, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 227, 128, 221, 128, 221, 128, 227,
  128, 221, 128, 221, 128, 227, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 225, 128, 221, 128, 221, 128, 225, 128, 253, 128, 253, 128, 227, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 219, 128, 213, 128, 213, 128, 213,
  128, 213, 128, 213, 128, 219, 128, 127, 0, 7, 8, 8, 9, 1, 1, 48,
  24, 12, 254, 254, 12, 24, 48, 255, 255, 255, 7, 5, 5, 9, 1, 1,
  224, 250, 62, 14, 30, 8, 7, 7, 9, 1, 1, 8, 12, 230, 255, 230,
  12, 8, 7, 5, 5, 9, 1, 1, 30, 14, 62, 250, 224, 9, 7, 14,
  9, 0, 0, 48, 0, 28, 0, 31, 0, 255, 128, 31, 0, 28, 0, 48,
  0, 9, 9, 18, 9, 0, 0, 28, 0, 30, 0, 15, 0, 255, 128, 255,
  128, 255, 128, 15, 0, 30, 0, 28, 0, 9, 5, 10, 9, 0, 1, 2,
  0, 3, 0, 255, 128, 3, 0, 2, 0, 9, 7, 14, 9, 0, 0, 4,
  0, 6, 0, 255, 0, 255, 128, 255, 0, 6, 0, 4, 0, 9, 5, 10,
  9, 0, 1, 2, 0, 183, 0, 183, 128, 183, 0, 2, 0, 9, 5, 10,
  9, 0, 1, 2, 0, 171, 0, 171, 128, 171, 0, 2, 0, 9, 5, 10,
  9, 0, 1, 2, 0, 255, 0, 255, 128, 255, 0, 2, 0, 9, 8, 16,
  9, 0, 1, 128, 0, 112, 0, 78, 0, 33, 128, 31, 128, 62, 0, 112,
  0, 128, 0, 9, 8, 16, 9, 0, 1, 128, 0, 112, 0, 62, 0, 31,
  128, 33, 128, 78, 0, 112, 0, 128, 0, 9, 8, 16, 9, 0, 1, 128,
  0, 112, 0, 62, 0, 31, 128, 31, 128, 62, 0, 112, 0, 128, 0, 9,
  7, 14, 9, 0, 0, 132, 0, 134, 0, 255, 0, 255, 128, 127, 0, 6,
  0, 4, 0, 9, 7, 14, 9, 0, 0, 4, 0, 6, 0, 127, 0, 255,
  128, 255, 0, 134, 0, 132, 0, 6, 9, 9, 9, 2, 0, 16, 16, 248,
  248, 252, 248, 248, 16, 16, 8, 9, 9, 9, 0, 1, 4, 4, 254, 254,
  255, 254, 254, 4, 4, 9, 9, 18, 9, 0, 0, 24, 0, 28, 0, 22,
  0, 243, 0, 129, 128, 243, 0, 22, 0, 28, 0, 24, 0, 9, 9, 18,
  9, 0, 0, 24, 0, 28, 0, 26, 0, 249, 0, 192, 128, 249, 0, 26,
  0, 28, 0, 24, 0, 9, 9, 18, 9, 0, 0, 0, 128, 1, 128, 62,
  128, 64, 128, 129, 128, 243, 0, 238, 0, 60, 0, 56, 0, 9, 9, 18,
  9, 0, 0, 56, 0, 60, 0, 238, 0, 243, 0, 129, 128, 64, 128, 62,
  128, 1, 128, 0, 128, 8, 9, 9, 9, 0, 1, 16, 24, 20, 242, 129,
  243, 118, 28, 24, 8, 9, 9, 9, 0, 1, 24, 28, 118, 243, 129, 242,
  20, 24, 16, 9, 7, 14, 9, 0, 2, 4, 0, 250, 0, 129, 0, 64,
  128, 129, 128, 251, 0, 6, 0, 255, 9, 7, 14, 9, 0, 2, 6, 0,
  251, 0, 129, 128, 64, 128, 129, 0, 250, 0, 4, 0, 9, 9, 18, 9,
  0, 1, 28, 0, 127, 0, 251, 128, 1, 128, 0, 128, 1, 128, 251, 128,
  127, 0, 28, 0, 9, 5, 10, 9, 0, 3, 210, 0, 43, 0, 127, 128,
  43, 0, 210, 0, 9, 9, 18, 9, 0, 0, 16, 0, 56, 0, 92, 0,
  236, 0, 116, 0, 60, 0, 2, 128, 1, 128, 3, 128, 9, 5, 10, 9,
  0, 2, 242, 0, 123, 0, 7, 128, 123, 0, 242, 0, 9, 9, 18, 9,
  0, 0, 3, 128, 1, 128, 2, 128, 60, 0, 116, 0, 236, 0, 92, 0,
  56, 0, 16, 0, 9, 9, 18, 9, 0, 0, 16, 0, 24, 0, 28, 0,
  252, 0, 124, 0, 60, 0, 2, 128, 1, 128, 3, 128, 9, 5, 10, 9,
  0, 2, 242, 0, 123, 0, 127, 128, 123, 0, 242, 0, 9, 9, 18, 9,
  0, 0, 3, 128, 1, 128, 2, 128, 60, 0, 124, 0, 252, 0, 28, 0,
  24, 0, 16, 0, 9, 7, 14, 9, 0, 1, 3, 0, 3, 0, 113, 0,
  255, 128, 113, 0, 3, 0, 3, 0, 9, 7, 14, 9, 0, 1, 2, 0,
  115, 0, 121, 0, 255, 128, 121, 0, 115, 0, 2, 0, 9, 5, 10, 9,
  0, 2, 242, 0, 123, 0, 63, 128, 123, 0, 242, 0, 9, 7, 14, 9,
  0, 1, 226, 0, 242, 0, 123, 0, 63, 128, 123, 0, 242, 0, 226, 0,
  9, 7, 14, 9, 0, 1, 20, 0, 10, 0, 253, 0, 0, 128, 253, 0,
  10, 0, 20, 0, 255, 7, 7, 7, 9, 1, 0, 130, 132, 136, 144, 160,
  192, 254, 9, 10, 20, 9, 0, 0, 8, 0, 8, 0, 20, 0, 20, 0,
  42, 0, 42, 0, 85, 0, 93, 0, 128, 128, 255, 128, 7, 10, 10, 9,
  1, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 254, 7, 7, 7, 9,
  1, 1, 62, 64, 132, 138, 132, 64, 62, 7, 7, 7, 9, 1, 1, 248,
  4, 66, 162, 66, 4, 248, 5, 12, 12, 9, 2, 255, 112, 136, 136, 16,
  16, 32, 32, 64, 64, 128, 128, 112, 5, 12, 12, 9, 2, 255, 112, 136,
  136, 64, 64, 32, 32, 16, 16, 8, 8, 112, 7, 8, 8, 9, 1, 0,
  130, 146, 84, 68, 40, 40, 16, 16, 8, 10, 10, 9, 0, 255, 128, 143,
  144, 80, 80, 80, 80, 47, 32, 32, 8, 10, 10, 9, 0, 255, 1, 241,
  9, 10, 10, 10, 10, 244, 4, 4, 3, 10, 10, 9, 3, 0, 64, 64,
  64, 64, 224, 64, 64, 64, 64, 64, 255, 255, 255, 255, 255, 9, 9, 18,
  9, 0, 0, 8, 0, 20, 0, 34, 0, 65, 0, 136, 128, 65, 0, 34,
  0, 20, 0, 8, 0, 7, 8, 8, 9, 1, 0, 16, 16, 40, 40, 68,
  84, 146, 130, 7, 7, 7, 9, 1, 1, 146, 146, 146, 146, 146, 84, 56,
  7, 7, 7, 9, 1, 1, 2, 2, 2, 18, 2, 2, 254, 7, 7, 7,
  9, 1, 1, 254, 128, 128, 144, 128, 128, 128, 8, 11, 11, 9, 0, 255,
  193, 99, 99, 85, 85, 73, 85, 85, 99, 99, 193, 8, 11, 11, 9, 1,
  255, 131, 198, 198, 170, 170, 146, 170, 170, 198, 198, 131, 9, 11, 22, 9,
  0, 255, 193, 128, 99, 0, 99, 0, 85, 0, 85, 0, 73, 0, 85, 0,
  85, 0, 99, 0, 99, 0, 193, 128, 9, 13, 26, 9, 0, 254, 8, 0,
  8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0,
  8, 0, 8, 0, 8, 0, 255, 128, 9, 13, 26, 9, 0, 254, 255, 128,
  8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0,
  8, 0, 8, 0, 8, 0, 8, 0, 7, 7, 7, 9, 1, 1, 40, 40,
  238, 40, 238, 40, 40, 7, 7, 7, 9, 1, 1, 40, 40, 40, 238, 40,
  40, 40, 7, 3, 3, 9, 1, 3, 64, 190, 64, 9, 5, 10, 9, 0,
  2, 128, 0, 128, 0, 255, 128, 128, 0, 128, 0, 9, 5, 10, 9, 0,
  2, 0, 128, 0, 128, 255, 128, 0, 128, 0, 128, 5, 10, 10, 9, 2,
  0, 32, 80, 32, 32, 32, 32, 32, 32, 32, 248, 5, 9, 9, 9, 2,
  0, 32, 32, 80, 80, 248, 80, 80, 32, 32, 7, 9, 9, 9, 1, 0,
  16, 16, 16, 40, 198, 40, 16, 16, 16, 8, 9, 9, 9, 0, 0, 8,
  8, 8, 20, 227, 20, 8, 8, 8, 8, 9, 9, 9, 1, 0, 16, 16,
  16, 40, 199, 40, 16, 16, 16, 8, 7, 7, 9, 0, 1, 127, 65, 65,
  193, 65, 65, 127, 8, 7, 7, 9, 1, 1, 254, 130, 130, 131, 130, 130,
  254, 5, 12, 12, 9, 2, 255, 248, 160, 160, 160, 160, 160, 160, 160, 160,
  160, 160, 248, 5, 12, 12, 9, 2, 255, 248, 40, 40, 40, 40, 40, 40,
  40, 40, 40, 40, 248, 3, 10, 10, 9, 3, 0, 32, 32, 64, 64, 128,
  128, 64, 64, 32, 32, 3, 10, 10, 9, 3, 0, 128, 128, 64, 64, 32,
  32, 64, 64, 128, 128, 6, 10, 10, 9, 1, 0, 36, 36, 72, 72, 144,
  144, 72, 72, 36, 36, 6, 10, 10, 9, 2, 0, 144, 144, 72, 72, 36,
  36, 72, 72, 144, 144, 255, 255, 255, 255, 9, 11, 22, 9, 0, 0, 8,
  0, 20, 0, 54, 0, 85, 0, 213, 128, 85, 0, 85, 0, 85, 0, 85,
  0, 85, 0, 85, 0, 9, 11, 22, 9, 0, 255, 85, 0, 85, 0, 85,
  0, 85, 0, 85, 0, 85, 0, 213, 128, 85, 0, 54, 0, 20, 0, 8,
  0, 8, 8, 8, 9, 0, 0, 28, 34, 169, 113, 33, 1, 34, 28, 8,
  8, 8, 9, 0, 0, 56, 68, 149, 142, 132, 128, 68, 56, 9, 5, 10,
  9, 0, 2, 114, 0, 169, 0, 255, 128, 169, 0, 114, 0, 9, 5, 10,
  9, 0, 2, 32, 0, 64, 0, 255, 128, 64, 0, 32, 0, 9, 5, 10,
  9, 0, 2, 2, 0, 1, 0, 255, 128, 1, 0, 2, 0, 9, 5, 10,
  9, 0, 2, 34, 0, 65, 0, 255, 128, 65, 0, 34, 0, 9, 7, 14,
  9, 0, 1, 16, 0, 32, 0, 127, 128, 128, 0, 127, 128, 32, 0, 16,
  0, 9, 7, 14, 9, 0, 1, 4, 0, 2, 0, 255, 0, 0, 128, 255,
  0, 2, 0, 4, 0, 9, 7, 14, 9, 0, 1, 20, 0, 34, 0, 127,
  0, 128, 128, 127, 0, 34, 0, 20, 0, 9, 5, 10, 9, 0, 2, 32,
  128, 64, 128, 255, 128, 64, 128, 32, 128, 9, 5, 10, 9, 0, 2, 130,
  0, 129, 0, 255, 128, 129, 0, 130, 0, 9, 7, 14, 9, 0, 1, 16,
  128, 32, 128, 127, 128, 128, 128, 127, 128, 32, 128, 16, 128, 9, 7, 14,
  9, 0, 1, 132, 0, 130, 0, 255, 0, 128, 128, 255, 0, 130, 0, 132,
  0, 9, 6, 12, 9, 0, 1, 2, 0, 1, 0, 85, 128, 170, 128, 1,
  0, 2, 0
};

/*
  Fontname: -Misc-Fixed-Bold-R-Normal--15-140-75-75-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 9 h=14 x= 4 y=12 dx= 9 dy= 0 ascent=12 len=20
  Font Bounding box     w= 9 h=15 x= 0 y=-3
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =12 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_9x15B[2990] U8G_FONT_SECTION("u8g_font_9x15B") = {
  0, 9, 15, 0, 253, 10, 1, 232, 3, 214, 32, 255, 253, 12, 253, 11,
  253, 0, 0, 0, 9, 0, 12, 2, 10, 10, 9, 3, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 0, 192, 5, 3, 3, 9, 2, 7, 216, 216, 216,
  7, 8, 8, 9, 1, 1, 108, 108, 254, 108, 108, 254, 108, 108, 7, 11,
  11, 9, 1, 255, 16, 124, 214, 208, 240, 124, 30, 22, 214, 124, 16, 8,
  10, 10, 9, 0, 0, 67, 230, 230, 76, 24, 24, 50, 103, 103, 194, 8,
  10, 10, 9, 0, 0, 56, 108, 108, 120, 48, 121, 207, 198, 206, 123, 2,
  4, 4, 9, 3, 6, 192, 192, 192, 192, 5, 12, 12, 9, 2, 255, 24,
  48, 96, 96, 192, 192, 192, 192, 96, 96, 48, 24, 5, 12, 12, 9, 2,
  255, 192, 96, 48, 48, 24, 24, 24, 24, 48, 48, 96, 192, 7, 5, 5,
  9, 1, 2, 108, 56, 254, 56, 108, 8, 7, 7, 9, 0, 1, 24, 24,
  24, 255, 24, 24, 24, 3, 5, 5, 9, 3, 253, 224, 224, 96, 96, 192,
  8, 1, 1, 9, 0, 4, 255, 4, 3, 3, 9, 2, 255, 96, 240, 96,
  8, 10, 10, 9, 0, 0, 3, 6, 6, 12, 24, 24, 48, 96, 96, 192,
  8, 10, 10, 9, 0, 0, 24, 60, 102, 195, 195, 195, 195, 102, 60, 24,
  6, 10, 10, 9, 1, 0, 48, 112, 240, 48, 48, 48, 48, 48, 48, 252,
  8, 10, 10, 9, 0, 0, 60, 102, 195, 3, 6, 12, 24, 48, 96, 255,
  8, 10, 10, 9, 0, 0, 124, 198, 3, 6, 28, 6, 3, 3, 198, 124,
  8, 10, 10, 9, 0, 0, 6, 14, 30, 54, 102, 198, 255, 6, 6, 6,
  8, 10, 10, 9, 0, 0, 254, 192, 192, 220, 230, 3, 3, 195, 102, 60,
  8, 10, 10, 9, 0, 0, 60, 102, 194, 192, 220, 230, 195, 195, 102, 60,
  8, 10, 10, 9, 0, 0, 255, 3, 3, 6, 12, 12, 24, 24, 24, 24,
  8, 10, 10, 9, 0, 0, 60, 102, 195, 102, 60, 102, 195, 195, 102, 60,
  8, 10, 10, 9, 0, 0, 60, 102, 195, 195, 103, 59, 3, 67, 102, 60,
  4, 8, 8, 9, 2, 255, 96, 240, 96, 0, 0, 96, 240, 96, 4, 10,
  10, 9, 2, 253, 96, 240, 96, 0, 0, 112, 112, 48, 48, 96, 6, 10,
  10, 9, 1, 0, 12, 24, 48, 96, 192, 192, 96, 48, 24, 12, 8, 4,
  4, 9, 0, 2, 255, 0, 0, 255, 6, 10, 10, 9, 1, 0, 192, 96,
  48, 24, 12, 12, 24, 48, 96, 192, 7, 10, 10, 9, 1, 0, 124, 198,
  198, 6, 12, 24, 48, 0, 48, 48, 8, 10, 10, 9, 0, 0, 60, 102,
  195, 207, 219, 219, 206, 192, 99, 62, 8, 10, 10, 9, 0, 0, 24, 60,
  102, 195, 195, 195, 255, 195, 195, 195, 8, 10, 10, 9, 0, 0, 252, 198,
  195, 198, 252, 198, 195, 195, 198, 252, 8, 10, 10, 9, 0, 0, 62, 99,
  193, 192, 192, 192, 192, 193, 99, 62, 8, 10, 10, 9, 0, 0, 252, 198,
  195, 195, 195, 195, 195, 195, 198, 252, 7, 10, 10, 9, 1, 0, 254, 192,
  192, 192, 252, 192, 192, 192, 192, 254, 8, 10, 10, 9, 0, 0, 255, 192,
  192, 192, 252, 192, 192, 192, 192, 192, 8, 10, 10, 9, 0, 0, 62, 99,
  192, 192, 192, 199, 195, 195, 99, 62, 8, 10, 10, 9, 0, 0, 195, 195,
  195, 195, 255, 195, 195, 195, 195, 195, 6, 10, 10, 9, 1, 0, 252, 48,
  48, 48, 48, 48, 48, 48, 48, 252, 6, 10, 10, 9, 1, 0, 60, 12,
  12, 12, 12, 12, 12, 140, 216, 112, 8, 10, 10, 9, 0, 0, 195, 198,
  204, 216, 240, 240, 216, 204, 198, 195, 7, 10, 10, 9, 1, 0, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 254, 8, 10, 10, 9, 0, 0, 195, 231,
  255, 219, 219, 219, 195, 195, 195, 195, 8, 10, 10, 9, 0, 0, 195, 227,
  243, 243, 219, 219, 207, 199, 199, 195, 8, 10, 10, 9, 0, 0, 60, 102,
  195, 195, 195, 195, 195, 195, 102, 60, 8, 10, 10, 9, 0, 0, 254, 195,
  195, 195, 254, 192, 192, 192, 192, 192, 8, 10, 10, 9, 0, 0, 60, 102,
  195, 195, 195, 195, 219, 207, 102, 61, 8, 10, 10, 9, 0, 0, 254, 195,
  195, 195, 254, 248, 204, 198, 195, 195, 8, 10, 10, 9, 0, 0, 126, 195,
  192, 192, 126, 3, 3, 3, 195, 126, 8, 10, 10, 9, 0, 0, 255, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 8, 10, 10, 9, 0, 0, 195, 195,
  195, 195, 195, 195, 195, 195, 102, 60, 8, 10, 10, 9, 0, 0, 195, 195,
  195, 102, 102, 102, 60, 60, 24, 24, 8, 10, 10, 9, 0, 0, 195, 195,
  195, 195, 219, 219, 219, 255, 231, 195, 8, 10, 10, 9, 0, 0, 195, 195,
  102, 60, 24, 24, 60, 102, 195, 195, 8, 10, 10, 9, 0, 0, 195, 195,
  102, 60, 24, 24, 24, 24, 24, 24, 7, 10, 10, 9, 1, 0, 254, 6,
  6, 12, 24, 48, 96, 192, 192, 254, 5, 12, 12, 9, 2, 255, 248, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 248, 8, 10, 10, 9, 0, 0,
  192, 96, 96, 48, 24, 24, 12, 6, 6, 3, 5, 12, 12, 9, 2, 255,
  248, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 248, 6, 4, 4, 9,
  1, 6, 48, 120, 204, 132, 8, 1, 1, 9, 0, 255, 255, 4, 3, 3,
  9, 2, 8, 192, 96, 48, 8, 7, 7, 9, 0, 0, 62, 99, 3, 127,
  195, 199, 123, 8, 10, 10, 9, 0, 0, 192, 192, 192, 220, 230, 195, 195,
  195, 230, 220, 8, 7, 7, 9, 0, 0, 62, 99, 192, 192, 192, 99, 62,
  8, 10, 10, 9, 0, 0, 3, 3, 3, 59, 103, 195, 195, 195, 103, 59,
  8, 7, 7, 9, 0, 0, 60, 102, 195, 255, 192, 99, 62, 8, 10, 10,
  9, 0, 0, 30, 51, 51, 48, 48, 252, 48, 48, 48, 48, 8, 10, 10,
  9, 0, 253, 125, 199, 198, 198, 124, 192, 126, 195, 195, 126, 8, 10, 10,
  9, 0, 0, 192, 192, 192, 220, 230, 195, 195, 195, 195, 195, 6, 10, 10,
  9, 1, 0, 48, 48, 0, 112, 48, 48, 48, 48, 48, 252, 7, 13, 13,
  9, 1, 253, 6, 6, 0, 30, 6, 6, 6, 6, 6, 198, 198, 198, 124,
  7, 10, 10, 9, 1, 0, 192, 192, 192, 204, 216, 240, 240, 216, 204, 198,
  6, 10, 10, 9, 1, 0, 112, 48, 48, 48, 48, 48, 48, 48, 48, 252,
  8, 7, 7, 9, 0, 0, 182, 219, 219, 219, 219, 219, 219, 8, 7, 7,
  9, 0, 0, 220, 230, 195, 195, 195, 195, 195, 8, 7, 7, 9, 0, 0,
  60, 102, 195, 195, 195, 102, 60, 8, 10, 10, 9, 0, 253, 220, 230, 195,
  195, 195, 230, 220, 192, 192, 192, 8, 10, 10, 9, 0, 253, 59, 103, 195,
  195, 195, 103, 59, 3, 3, 3, 8, 7, 7, 9, 0, 0, 222, 115, 96,
  96, 96, 96, 96, 8, 7, 7, 9, 0, 0, 126, 195, 192, 126, 3, 195,
  126, 8, 9, 9, 9, 0, 0, 48, 48, 252, 48, 48, 48, 48, 51, 30,
  8, 7, 7, 9, 0, 0, 195, 195, 195, 195, 195, 103, 59, 8, 7, 7,
  9, 0, 0, 195, 195, 102, 102, 60, 60, 24, 8, 7, 7, 9, 0, 0,
  195, 195, 219, 219, 219, 255, 102, 8, 7, 7, 9, 0, 0, 195, 102, 60,
  24, 60, 102, 195, 8, 10, 10, 9, 0, 253, 195, 195, 195, 195, 195, 103,
  59, 3, 198, 124, 6, 7, 7, 9, 1, 0, 252, 12, 24, 48, 96, 192,
  252, 5, 12, 12, 9, 2, 255, 56, 96, 96, 96, 96, 192, 192, 96, 96,
  96, 96, 56, 2, 10, 10, 9, 3, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 5, 12, 12, 9, 2, 255, 224, 48, 48, 48, 48, 24, 24,
  48, 48, 48, 48, 224, 8, 3, 3, 9, 0, 7, 115, 219, 206, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,
  0, 0, 9, 0, 12, 2, 10, 10, 9, 4, 0, 192, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 7, 8, 8, 9, 1, 0, 4, 124, 206, 208, 208,
  230, 124, 64, 8, 10, 10, 9, 0, 255, 30, 51, 48, 48, 124, 48, 48,
  248, 191, 224, 7, 7, 7, 9, 1, 2, 198, 254, 108, 68, 108, 254, 198,
  8, 10, 10, 9, 0, 0, 195, 195, 102, 60, 126, 24, 126, 24, 24, 24,
  2, 11, 11, 9, 4, 255, 192, 192, 192, 192, 192, 0, 0, 192, 192, 192,
  192, 6, 11, 11, 9, 1, 255, 120, 204, 192, 120, 204, 204, 204, 120, 12,
  204, 120, 6, 2, 2, 9, 1, 9, 204, 204, 8, 11, 11, 9, 0, 0,
  60, 126, 195, 189, 165, 161, 165, 189, 195, 126, 60, 5, 7, 7, 9, 1,
  3, 240, 24, 248, 152, 248, 0, 248, 8, 8, 8, 9, 0, 1, 27, 54,
  108, 216, 216, 108, 54, 27, 7, 5, 5, 9, 1, 2, 254, 254, 6, 6,
  6, 6, 1, 1, 9, 1, 4, 252, 8, 11, 11, 9, 0, 0, 60, 126,
  195, 189, 165, 189, 169, 173, 195, 126, 60, 6, 2, 2, 9, 1, 9, 252,
  252, 6, 4, 4, 9, 2, 6, 120, 204, 204, 120, 8, 10, 10, 9, 0,
  0, 24, 24, 24, 255, 255, 24, 24, 24, 255, 255, 5, 7, 7, 9, 1,
  4, 112, 152, 24, 48, 96, 192, 248, 5, 7, 7, 9, 1, 4, 112, 152,
  24, 48, 24, 152, 112, 4, 3, 3, 9, 2, 8, 48, 96, 192, 7, 10,
  10, 9, 1, 253, 198, 198, 198, 198, 198, 238, 250, 192, 192, 192, 7, 10,
  10, 9, 1, 0, 126, 254, 246, 246, 246, 118, 54, 54, 54, 54, 3, 3,
  3, 9, 3, 3, 64, 224, 64, 5, 3, 3, 9, 2, 253, 24, 216, 112,
  4, 7, 7, 9, 1, 4, 96, 224, 96, 96, 96, 96, 240, 5, 6, 6,
  9, 1, 4, 112, 216, 216, 112, 0, 248, 8, 8, 8, 9, 0, 1, 216,
  108, 54, 27, 27, 54, 108, 216, 8, 11, 11, 9, 0, 0, 96, 224, 96,
  96, 97, 99, 247, 15, 27, 31, 3, 8, 11, 11, 9, 0, 0, 96, 224,
  96, 96, 110, 115, 243, 6, 12, 24, 31, 8, 11, 11, 9, 0, 0, 112,
  152, 24, 48, 25, 155, 119, 15, 27, 31, 3, 7, 10, 10, 9, 1, 0,
  24, 24, 0, 24, 48, 96, 192, 198, 198, 124, 8, 12, 12, 9, 0, 0,
  96, 48, 24, 0, 60, 102, 195, 195, 255, 195, 195, 195, 8, 12, 12, 9,
  0, 0, 6, 12, 24, 0, 60, 102, 195, 195, 255, 195, 195, 195, 8, 12,
  12, 9, 0, 0, 24, 60, 102, 0, 60, 102, 195, 195, 255, 195, 195, 195,
  8, 12, 12, 9, 0, 0, 50, 126, 76, 0, 60, 102, 195, 195, 255, 195,
  195, 195, 8, 11, 11, 9, 0, 0, 102, 102, 0, 60, 102, 195, 195, 255,
  195, 195, 195, 8, 12, 12, 9, 0, 0, 24, 36, 36, 24, 60, 102, 195,
  195, 255, 195, 195, 195, 8, 10, 10, 9, 0, 0, 31, 60, 108, 108, 204,
  255, 204, 204, 204, 207, 8, 13, 13, 9, 0, 253, 62, 99, 193, 192, 192,
  192, 192, 193, 99, 62, 12, 108, 56, 7, 12, 12, 9, 1, 0, 96, 48,
  24, 0, 254, 192, 192, 252, 192, 192, 192, 254, 7, 12, 12, 9, 1, 0,
  12, 24, 48, 0, 254, 192, 192, 252, 192, 192, 192, 254, 7, 12, 12, 9,
  1, 0, 24, 60, 102, 0, 254, 192, 192, 252, 192, 192, 192, 254, 7, 11,
  11, 9, 1, 0, 102, 102, 0, 254, 192, 192, 252, 192, 192, 192, 254, 6,
  12, 12, 9, 1, 0, 192, 96, 48, 0, 252, 48, 48, 48, 48, 48, 48,
  252, 6, 12, 12, 9, 1, 0, 24, 48, 96, 0, 252, 48, 48, 48, 48,
  48, 48, 252, 6, 12, 12, 9, 1, 0, 48, 120, 204, 0, 252, 48, 48,
  48, 48, 48, 48, 252, 6, 11, 11, 9, 1, 0, 204, 204, 0, 252, 48,
  48, 48, 48, 48, 48, 252, 9, 10, 20, 9, 0, 0, 126, 0, 99, 0,
  97, 128, 97, 128, 249, 128, 249, 128, 97, 128, 97, 128, 99, 0, 126, 0,
  8, 12, 12, 9, 0, 0, 50, 126, 76, 0, 195, 227, 243, 251, 223, 207,
  199, 195, 8, 12, 12, 9, 0, 0, 96, 48, 24, 0, 60, 102, 195, 195,
  195, 195, 102, 60, 8, 12, 12, 9, 0, 0, 6, 12, 24, 0, 60, 102,
  195, 195, 195, 195, 102, 60, 8, 12, 12, 9, 0, 0, 24, 60, 102, 0,
  60, 102, 195, 195, 195, 195, 102, 60, 8, 12, 12, 9, 0, 0, 50, 126,
  76, 0, 60, 102, 195, 195, 195, 195, 102, 60, 8, 11, 11, 9, 0, 0,
  102, 102, 0, 60, 102, 195, 195, 195, 195, 102, 60, 7, 8, 8, 9, 1,
  0, 130, 198, 108, 56, 56, 108, 198, 130, 8, 12, 12, 9, 0, 255, 1,
  63, 102, 199, 203, 203, 211, 211, 227, 102, 252, 128, 8, 12, 12, 9, 0,
  0, 96, 48, 24, 0, 195, 195, 195, 195, 195, 195, 102, 60, 8, 12, 12,
  9, 0, 0, 6, 12, 24, 0, 195, 195, 195, 195, 195, 195, 102, 60, 8,
  12, 12, 9, 0, 0, 24, 60, 102, 0, 195, 195, 195, 195, 195, 195, 102,
  60, 8, 11, 11, 9, 0, 0, 102, 102, 0, 195, 195, 195, 195, 195, 195,
  102, 60, 8, 12, 12, 9, 0, 0, 6, 12, 24, 0, 195, 102, 60, 24,
  24, 24, 24, 24, 7, 10, 10, 9, 1, 0, 240, 96, 124, 102, 102, 102,
  124, 96, 96, 240, 7, 10, 10, 9, 1, 0, 60, 102, 198, 204, 216, 204,
  198, 198, 198, 220, 8, 11, 11, 9, 0, 0, 96, 48, 24, 0, 62, 67,
  3, 127, 195, 199, 123, 8, 11, 11, 9, 0, 0, 12, 24, 48, 0, 62,
  67, 3, 127, 195, 199, 123, 8, 11, 11, 9, 0, 0, 24, 60, 102, 0,
  62, 67, 3, 127, 195, 199, 123, 8, 11, 11, 9, 0, 0, 50, 126, 76,
  0, 62, 67, 3, 127, 195, 199, 123, 8, 10, 10, 9, 0, 0, 102, 102,
  0, 62, 67, 3, 127, 195, 199, 123, 8, 11, 11, 9, 0, 0, 24, 36,
  36, 24, 62, 67, 3, 127, 195, 199, 123, 8, 7, 7, 9, 0, 0, 118,
  155, 27, 126, 216, 217, 110, 8, 10, 10, 9, 0, 253, 62, 99, 192, 192,
  192, 99, 62, 12, 108, 56, 8, 11, 11, 9, 0, 0, 96, 48, 24, 0,
  60, 102, 195, 255, 192, 99, 62, 8, 11, 11, 9, 0, 0, 12, 24, 48,
  0, 60, 102, 195, 255, 192, 99, 62, 8, 11, 11, 9, 0, 0, 24, 60,
  102, 0, 60, 102, 195, 255, 192, 99, 62, 8, 10, 10, 9, 0, 0, 102,
  102, 0, 60, 102, 195, 255, 192, 99, 62, 6, 11, 11, 9, 1, 0, 192,
  96, 48, 0, 112, 48, 48, 48, 48, 48, 252, 6, 11, 11, 9, 1, 0,
  24, 48, 96, 0, 112, 48, 48, 48, 48, 48, 252, 6, 11, 11, 9, 1,
  0, 48, 120, 204, 0, 112, 48, 48, 48, 48, 48, 252, 6, 10, 10, 9,
  1, 0, 204, 204, 0, 112, 48, 48, 48, 48, 48, 252, 8, 12, 12, 9,
  0, 0, 136, 216, 112, 112, 216, 140, 62, 103, 195, 195, 102, 60, 8, 11,
  11, 9, 0, 0, 50, 126, 76, 0, 220, 230, 195, 195, 195, 195, 195, 8,
  11, 11, 9, 0, 0, 96, 48, 24, 0, 60, 102, 195, 195, 195, 102, 60,
  8, 11, 11, 9, 0, 0, 12, 24, 48, 0, 60, 102, 195, 195, 195, 102,
  60, 8, 11, 11, 9, 0, 0, 24, 60, 102, 0, 60, 102, 195, 195, 195,
  102, 60, 8, 11, 11, 9, 0, 0, 50, 126, 76, 0, 60, 102, 195, 195,
  195, 102, 60, 8, 10, 10, 9, 0, 0, 102, 102, 0, 60, 102, 195, 195,
  195, 102, 60, 8, 10, 10, 9, 0, 0, 24, 24, 0, 0, 255, 255, 0,
  0, 24, 24, 8, 9, 9, 9, 0, 255, 1, 63, 102, 207, 219, 243, 102,
  252, 128, 8, 11, 11, 9, 0, 0, 96, 48, 24, 0, 195, 195, 195, 195,
  195, 103, 59, 8, 11, 11, 9, 0, 0, 12, 24, 48, 0, 195, 195, 195,
  195, 195, 103, 59, 8, 11, 11, 9, 0, 0, 24, 60, 102, 0, 195, 195,
  195, 195, 195, 103, 59, 8, 10, 10, 9, 0, 0, 102, 102, 0, 195, 195,
  195, 195, 195, 103, 59, 8, 14, 14, 9, 0, 253, 12, 24, 48, 0, 195,
  195, 195, 195, 195, 103, 59, 3, 198, 124, 7, 12, 12, 9, 1, 253, 224,
  96, 96, 124, 102, 102, 102, 102, 124, 96, 96, 224, 8, 13, 13, 9, 0,
  253, 102, 102, 0, 195, 195, 195, 195, 195, 103, 59, 3, 198, 124
};

/*
  Fontname: -Misc-Fixed-Bold-R-Normal--15-140-75-75-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 8 h=13 x= 3 y=12 dx= 9 dy= 0 ascent=12 len=13
  Font Bounding box     w= 9 h=15 x= 0 y=-3
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =12 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_9x15Br[1423] U8G_FONT_SECTION("u8g_font_9x15Br") = {
  0, 9, 15, 0, 253, 10, 1, 232, 3, 214, 32, 127, 253, 12, 253, 11,
  253, 0, 0, 0, 9, 0, 12, 2, 10, 10, 9, 3, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 0, 192, 5, 3, 3, 9, 2, 7, 216, 216, 216,
  7, 8, 8, 9, 1, 1, 108, 108, 254, 108, 108, 254, 108, 108, 7, 11,
  11, 9, 1, 255, 16, 124, 214, 208, 240, 124, 30, 22, 214, 124, 16, 8,
  10, 10, 9, 0, 0, 67, 230, 230, 76, 24, 24, 50, 103, 103, 194, 8,
  10, 10, 9, 0, 0, 56, 108, 108, 120, 48, 121, 207, 198, 206, 123, 2,
  4, 4, 9, 3, 6, 192, 192, 192, 192, 5, 12, 12, 9, 2, 255, 24,
  48, 96, 96, 192, 192, 192, 192, 96, 96, 48, 24, 5, 12, 12, 9, 2,
  255, 192, 96, 48, 48, 24, 24, 24, 24, 48, 48, 96, 192, 7, 5, 5,
  9, 1, 2, 108, 56, 254, 56, 108, 8, 7, 7, 9, 0, 1, 24, 24,
  24, 255, 24, 24, 24, 3, 5, 5, 9, 3, 253, 224, 224, 96, 96, 192,
  8, 1, 1, 9, 0, 4, 255, 4, 3, 3, 9, 2, 255, 96, 240, 96,
  8, 10, 10, 9, 0, 0, 3, 6, 6, 12, 24, 24, 48, 96, 96, 192,
  8, 10, 10, 9, 0, 0, 24, 60, 102, 195, 195, 195, 195, 102, 60, 24,
  6, 10, 10, 9, 1, 0, 48, 112, 240, 48, 48, 48, 48, 48, 48, 252,
  8, 10, 10, 9, 0, 0, 60, 102, 195, 3, 6, 12, 24, 48, 96, 255,
  8, 10, 10, 9, 0, 0, 124, 198, 3, 6, 28, 6, 3, 3, 198, 124,
  8, 10, 10, 9, 0, 0, 6, 14, 30, 54, 102, 198, 255, 6, 6, 6,
  8, 10, 10, 9, 0, 0, 254, 192, 192, 220, 230, 3, 3, 195, 102, 60,
  8, 10, 10, 9, 0, 0, 60, 102, 194, 192, 220, 230, 195, 195, 102, 60,
  8, 10, 10, 9, 0, 0, 255, 3, 3, 6, 12, 12, 24, 24, 24, 24,
  8, 10, 10, 9, 0, 0, 60, 102, 195, 102, 60, 102, 195, 195, 102, 60,
  8, 10, 10, 9, 0, 0, 60, 102, 195, 195, 103, 59, 3, 67, 102, 60,
  4, 8, 8, 9, 2, 255, 96, 240, 96, 0, 0, 96, 240, 96, 4, 10,
  10, 9, 2, 253, 96, 240, 96, 0, 0, 112, 112, 48, 48, 96, 6, 10,
  10, 9, 1, 0, 12, 24, 48, 96, 192, 192, 96, 48, 24, 12, 8, 4,
  4, 9, 0, 2, 255, 0, 0, 255, 6, 10, 10, 9, 1, 0, 192, 96,
  48, 24, 12, 12, 24, 48, 96, 192, 7, 10, 10, 9, 1, 0, 124, 198,
  198, 6, 12, 24, 48, 0, 48, 48, 8, 10, 10, 9, 0, 0, 60, 102,
  195, 207, 219, 219, 206, 192, 99, 62, 8, 10, 10, 9, 0, 0, 24, 60,
  102, 195, 195, 195, 255, 195, 195, 195, 8, 10, 10, 9, 0, 0, 252, 198,
  195, 198, 252, 198, 195, 195, 198, 252, 8, 10, 10, 9, 0, 0, 62, 99,
  193, 192, 192, 192, 192, 193, 99, 62, 8, 10, 10, 9, 0, 0, 252, 198,
  195, 195, 195, 195, 195, 195, 198, 252, 7, 10, 10, 9, 1, 0, 254, 192,
  192, 192, 252, 192, 192, 192, 192, 254, 8, 10, 10, 9, 0, 0, 255, 192,
  192, 192, 252, 192, 192, 192, 192, 192, 8, 10, 10, 9, 0, 0, 62, 99,
  192, 192, 192, 199, 195, 195, 99, 62, 8, 10, 10, 9, 0, 0, 195, 195,
  195, 195, 255, 195, 195, 195, 195, 195, 6, 10, 10, 9, 1, 0, 252, 48,
  48, 48, 48, 48, 48, 48, 48, 252, 6, 10, 10, 9, 1, 0, 60, 12,
  12, 12, 12, 12, 12, 140, 216, 112, 8, 10, 10, 9, 0, 0, 195, 198,
  204, 216, 240, 240, 216, 204, 198, 195, 7, 10, 10, 9, 1, 0, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 254, 8, 10, 10, 9, 0, 0, 195, 231,
  255, 219, 219, 219, 195, 195, 195, 195, 8, 10, 10, 9, 0, 0, 195, 227,
  243, 243, 219, 219, 207, 199, 199, 195, 8, 10, 10, 9, 0, 0, 60, 102,
  195, 195, 195, 195, 195, 195, 102, 60, 8, 10, 10, 9, 0, 0, 254, 195,
  195, 195, 254, 192, 192, 192, 192, 192, 8, 10, 10, 9, 0, 0, 60, 102,
  195, 195, 195, 195, 219, 207, 102, 61, 8, 10, 10, 9, 0, 0, 254, 195,
  195, 195, 254, 248, 204, 198, 195, 195, 8, 10, 10, 9, 0, 0, 126, 195,
  192, 192, 126, 3, 3, 3, 195, 126, 8, 10, 10, 9, 0, 0, 255, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 8, 10, 10, 9, 0, 0, 195, 195,
  195, 195, 195, 195, 195, 195, 102, 60, 8, 10, 10, 9, 0, 0, 195, 195,
  195, 102, 102, 102, 60, 60, 24, 24, 8, 10, 10, 9, 0, 0, 195, 195,
  195, 195, 219, 219, 219, 255, 231, 195, 8, 10, 10, 9, 0, 0, 195, 195,
  102, 60, 24, 24, 60, 102, 195, 195, 8, 10, 10, 9, 0, 0, 195, 195,
  102, 60, 24, 24, 24, 24, 24, 24, 7, 10, 10, 9, 1, 0, 254, 6,
  6, 12, 24, 48, 96, 192, 192, 254, 5, 12, 12, 9, 2, 255, 248, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 248, 8, 10, 10, 9, 0, 0,
  192, 96, 96, 48, 24, 24, 12, 6, 6, 3, 5, 12, 12, 9, 2, 255,
  248, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 248, 6, 4, 4, 9,
  1, 6, 48, 120, 204, 132, 8, 1, 1, 9, 0, 255, 255, 4, 3, 3,
  9, 2, 8, 192, 96, 48, 8, 7, 7, 9, 0, 0, 62, 99, 3, 127,
  195, 199, 123, 8, 10, 10, 9, 0, 0, 192, 192, 192, 220, 230, 195, 195,
  195, 230, 220, 8, 7, 7, 9, 0, 0, 62, 99, 192, 192, 192, 99, 62,
  8, 10, 10, 9, 0, 0, 3, 3, 3, 59, 103, 195, 195, 195, 103, 59,
  8, 7, 7, 9, 0, 0, 60, 102, 195, 255, 192, 99, 62, 8, 10, 10,
  9, 0, 0, 30, 51, 51, 48, 48, 252, 48, 48, 48, 48, 8, 10, 10,
  9, 0, 253, 125, 199, 198, 198, 124, 192, 126, 195, 195, 126, 8, 10, 10,
  9, 0, 0, 192, 192, 192, 220, 230, 195, 195, 195, 195, 195, 6, 10, 10,
  9, 1, 0, 48, 48, 0, 112, 48, 48, 48, 48, 48, 252, 7, 13, 13,
  9, 1, 253, 6, 6, 0, 30, 6, 6, 6, 6, 6, 198, 198, 198, 124,
  7, 10, 10, 9, 1, 0, 192, 192, 192, 204, 216, 240, 240, 216, 204, 198,
  6, 10, 10, 9, 1, 0, 112, 48, 48, 48, 48, 48, 48, 48, 48, 252,
  8, 7, 7, 9, 0, 0, 182, 219, 219, 219, 219, 219, 219, 8, 7, 7,
  9, 0, 0, 220, 230, 195, 195, 195, 195, 195, 8, 7, 7, 9, 0, 0,
  60, 102, 195, 195, 195, 102, 60, 8, 10, 10, 9, 0, 253, 220, 230, 195,
  195, 195, 230, 220, 192, 192, 192, 8, 10, 10, 9, 0, 253, 59, 103, 195,
  195, 195, 103, 59, 3, 3, 3, 8, 7, 7, 9, 0, 0, 222, 115, 96,
  96, 96, 96, 96, 8, 7, 7, 9, 0, 0, 126, 195, 192, 126, 3, 195,
  126, 8, 9, 9, 9, 0, 0, 48, 48, 252, 48, 48, 48, 48, 51, 30,
  8, 7, 7, 9, 0, 0, 195, 195, 195, 195, 195, 103, 59, 8, 7, 7,
  9, 0, 0, 195, 195, 102, 102, 60, 60, 24, 8, 7, 7, 9, 0, 0,
  195, 195, 219, 219, 219, 255, 102, 8, 7, 7, 9, 0, 0, 195, 102, 60,
  24, 60, 102, 195, 8, 10, 10, 9, 0, 253, 195, 195, 195, 195, 195, 103,
  59, 3, 198, 124, 6, 7, 7, 9, 1, 0, 252, 12, 24, 48, 96, 192,
  252, 5, 12, 12, 9, 2, 255, 56, 96, 96, 96, 96, 192, 192, 96, 96,
  96, 96, 56, 2, 10, 10, 9, 3, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 5, 12, 12, 9, 2, 255, 224, 48, 48, 48, 48, 24, 24,
  48, 48, 48, 48, 224, 8, 3, 3, 9, 0, 7, 115, 219, 206, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--15-140-75-75-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 8 h=14 x= 4 y=12 dx= 9 dy= 0 ascent=12 len=14
  Font Bounding box     w= 9 h=15 x= 0 y=-3
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =12 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_9x15[2959] U8G_FONT_SECTION("u8g_font_9x15") = {
  0, 9, 15, 0, 253, 10, 1, 232, 3, 216, 32, 255, 253, 12, 253, 11,
  253, 0, 0, 0, 9, 0, 12, 1, 11, 11, 9, 4, 0, 128, 128, 128,
  128, 128, 128, 128, 0, 0, 128, 128, 4, 3, 3, 9, 3, 7, 144, 144,
  144, 6, 8, 8, 9, 1, 1, 72, 72, 252, 72, 72, 252, 72, 72, 7,
  11, 11, 9, 1, 255, 16, 124, 146, 144, 80, 56, 20, 18, 146, 124, 16,
  7, 10, 10, 9, 1, 0, 66, 164, 164, 72, 16, 16, 36, 74, 74, 132,
  7, 10, 10, 9, 1, 0, 96, 144, 144, 144, 96, 98, 148, 136, 148, 98,
  1, 3, 3, 9, 4, 7, 128, 128, 128, 3, 12, 12, 9, 3, 255, 32,
  64, 64, 128, 128, 128, 128, 128, 128, 64, 64, 32, 3, 12, 12, 9, 3,
  255, 128, 64, 64, 32, 32, 32, 32, 32, 32, 64, 64, 128, 7, 7, 7,
  9, 1, 3, 16, 146, 84, 56, 84, 146, 16, 7, 7, 7, 9, 1, 1,
  16, 16, 16, 254, 16, 16, 16, 2, 5, 5, 9, 4, 253, 192, 192, 64,
  64, 128, 7, 1, 1, 9, 1, 4, 254, 2, 2, 2, 9, 4, 0, 192,
  192, 7, 10, 10, 9, 1, 0, 2, 4, 4, 8, 16, 16, 32, 64, 64,
  128, 7, 10, 10, 9, 1, 0, 56, 68, 130, 130, 130, 130, 130, 130, 68,
  56, 7, 10, 10, 9, 1, 0, 16, 48, 80, 144, 16, 16, 16, 16, 16,
  254, 7, 10, 10, 9, 1, 0, 124, 130, 130, 4, 8, 16, 32, 64, 128,
  254, 7, 10, 10, 9, 1, 0, 254, 2, 4, 8, 28, 2, 2, 2, 130,
  124, 7, 10, 10, 9, 1, 0, 4, 12, 20, 36, 68, 132, 254, 4, 4,
  4, 7, 10, 10, 9, 1, 0, 254, 128, 128, 188, 194, 2, 2, 2, 130,
  124, 7, 10, 10, 9, 1, 0, 60, 64, 128, 128, 188, 194, 130, 130, 130,
  124, 7, 10, 10, 9, 1, 0, 254, 2, 4, 4, 8, 8, 16, 16, 32,
  32, 7, 10, 10, 9, 1, 0, 56, 68, 130, 68, 56, 68, 130, 130, 68,
  56, 7, 10, 10, 9, 1, 0, 124, 130, 130, 130, 134, 122, 2, 2, 4,
  120, 2, 7, 7, 9, 4, 0, 192, 192, 0, 0, 0, 192, 192, 2, 10,
  10, 9, 4, 253, 192, 192, 0, 0, 0, 192, 192, 64, 64, 128, 5, 10,
  10, 9, 2, 0, 8, 16, 32, 64, 128, 128, 64, 32, 16, 8, 7, 4,
  4, 9, 1, 2, 254, 0, 0, 254, 5, 10, 10, 9, 2, 0, 128, 64,
  32, 16, 8, 8, 16, 32, 64, 128, 7, 10, 10, 9, 1, 0, 124, 130,
  130, 2, 4, 8, 16, 16, 0, 16, 7, 10, 10, 9, 1, 0, 124, 130,
  130, 158, 162, 166, 154, 128, 128, 124, 7, 10, 10, 9, 1, 0, 16, 40,
  68, 130, 130, 130, 254, 130, 130, 130, 7, 10, 10, 9, 1, 0, 248, 132,
  130, 132, 248, 132, 130, 130, 132, 248, 7, 10, 10, 9, 1, 0, 124, 130,
  128, 128, 128, 128, 128, 128, 130, 124, 7, 10, 10, 9, 1, 0, 248, 132,
  130, 130, 130, 130, 130, 130, 132, 248, 7, 10, 10, 9, 1, 0, 254, 128,
  128, 128, 248, 128, 128, 128, 128, 254, 7, 10, 10, 9, 1, 0, 254, 128,
  128, 128, 248, 128, 128, 128, 128, 128, 7, 10, 10, 9, 1, 0, 124, 130,
  128, 128, 128, 142, 130, 130, 130, 124, 7, 10, 10, 9, 1, 0, 130, 130,
  130, 130, 254, 130, 130, 130, 130, 130, 5, 10, 10, 9, 2, 0, 248, 32,
  32, 32, 32, 32, 32, 32, 32, 248, 8, 10, 10, 9, 1, 0, 31, 4,
  4, 4, 4, 4, 4, 4, 132, 120, 7, 10, 10, 9, 1, 0, 130, 132,
  136, 144, 224, 160, 144, 136, 132, 130, 7, 10, 10, 9, 1, 0, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 254, 7, 10, 10, 9, 1, 0, 130, 130,
  198, 170, 170, 146, 146, 130, 130, 130, 7, 10, 10, 9, 1, 0, 130, 130,
  194, 162, 146, 138, 134, 130, 130, 130, 7, 10, 10, 9, 1, 0, 124, 130,
  130, 130, 130, 130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 0, 252, 130,
  130, 130, 252, 128, 128, 128, 128, 128, 7, 12, 12, 9, 1, 254, 124, 130,
  130, 130, 130, 130, 130, 162, 146, 124, 8, 6, 7, 10, 10, 9, 1, 0,
  252, 130, 130, 130, 252, 144, 136, 132, 130, 130, 7, 10, 10, 9, 1, 0,
  124, 130, 130, 128, 112, 12, 2, 130, 130, 124, 7, 10, 10, 9, 1, 0,
  254, 16, 16, 16, 16, 16, 16, 16, 16, 16, 7, 10, 10, 9, 1, 0,
  130, 130, 130, 130, 130, 130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 0,
  130, 130, 130, 68, 68, 68, 40, 40, 40, 16, 7, 10, 10, 9, 1, 0,
  130, 130, 130, 130, 146, 146, 146, 146, 170, 68, 7, 10, 10, 9, 1, 0,
  130, 130, 68, 40, 16, 16, 40, 68, 130, 130, 7, 10, 10, 9, 1, 0,
  130, 130, 68, 40, 16, 16, 16, 16, 16, 16, 7, 10, 10, 9, 1, 0,
  254, 2, 4, 8, 16, 32, 64, 128, 128, 254, 4, 12, 12, 9, 3, 255,
  240, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 240, 7, 10, 10, 9,
  1, 0, 128, 64, 64, 32, 16, 16, 8, 4, 4, 2, 4, 12, 12, 9,
  2, 255, 240, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 240, 7, 4,
  4, 9, 1, 6, 16, 40, 68, 130, 8, 1, 1, 9, 0, 255, 255, 3,
  3, 3, 9, 3, 8, 128, 64, 32, 7, 7, 7, 9, 1, 0, 124, 2,
  2, 126, 130, 134, 122, 7, 10, 10, 9, 1, 0, 128, 128, 128, 188, 194,
  130, 130, 130, 194, 188, 7, 7, 7, 9, 1, 0, 124, 130, 128, 128, 128,
  130, 124, 7, 10, 10, 9, 1, 0, 2, 2, 2, 122, 134, 130, 130, 130,
  134, 122, 7, 7, 7, 9, 1, 0, 124, 130, 130, 254, 128, 128, 124, 7,
  10, 10, 9, 1, 0, 28, 34, 34, 32, 32, 248, 32, 32, 32, 32, 7,
  10, 10, 9, 1, 253, 122, 132, 132, 132, 120, 128, 124, 130, 130, 124, 7,
  10, 10, 9, 1, 0, 128, 128, 128, 188, 194, 130, 130, 130, 130, 130, 5,
  10, 10, 9, 2, 0, 96, 0, 0, 224, 32, 32, 32, 32, 32, 248, 6,
  13, 13, 9, 1, 253, 12, 0, 0, 28, 4, 4, 4, 4, 4, 132, 132,
  132, 120, 7, 10, 10, 9, 1, 0, 128, 128, 128, 130, 140, 176, 192, 176,
  140, 130, 5, 10, 10, 9, 2, 0, 224, 32, 32, 32, 32, 32, 32, 32,
  32, 248, 7, 7, 7, 9, 1, 0, 236, 146, 146, 146, 146, 146, 130, 7,
  7, 7, 9, 1, 0, 188, 194, 130, 130, 130, 130, 130, 7, 7, 7, 9,
  1, 0, 124, 130, 130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 253, 188,
  194, 130, 130, 130, 194, 188, 128, 128, 128, 7, 10, 10, 9, 1, 253, 122,
  134, 130, 130, 130, 134, 122, 2, 2, 2, 7, 7, 7, 9, 1, 0, 156,
  98, 66, 64, 64, 64, 64, 7, 7, 7, 9, 1, 0, 124, 130, 128, 124,
  2, 130, 124, 7, 9, 9, 9, 1, 0, 32, 32, 252, 32, 32, 32, 32,
  34, 28, 7, 7, 7, 9, 1, 0, 132, 132, 132, 132, 132, 132, 122, 7,
  7, 7, 9, 1, 0, 130, 130, 68, 68, 40, 40, 16, 7, 7, 7, 9,
  1, 0, 130, 130, 146, 146, 146, 170, 68, 7, 7, 7, 9, 1, 0, 130,
  68, 40, 16, 40, 68, 130, 6, 10, 10, 9, 1, 253, 132, 132, 132, 132,
  132, 140, 116, 4, 132, 120, 7, 7, 7, 9, 1, 0, 254, 4, 8, 16,
  32, 64, 254, 5, 12, 12, 9, 3, 255, 56, 64, 64, 64, 32, 192, 192,
  32, 64, 64, 64, 56, 1, 12, 12, 9, 4, 255, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 5, 12, 12, 9, 1, 255, 224, 16, 16,
  16, 32, 24, 24, 32, 16, 16, 16, 224, 7, 3, 3, 9, 1, 7, 98,
  146, 140, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 0, 0, 0, 9, 0, 12, 1, 11, 11, 9, 4, 0, 128,
  128, 0, 0, 128, 128, 128, 128, 128, 128, 128, 6, 8, 8, 9, 1, 0,
  8, 120, 148, 144, 160, 164, 120, 64, 7, 10, 10, 9, 1, 0, 28, 34,
  32, 32, 248, 32, 32, 96, 162, 92, 7, 6, 6, 9, 1, 3, 130, 124,
  68, 68, 124, 130, 7, 10, 10, 9, 1, 0, 130, 130, 68, 40, 124, 16,
  124, 16, 16, 16, 1, 11, 11, 9, 4, 255, 128, 128, 128, 128, 128, 0,
  128, 128, 128, 128, 128, 4, 11, 11, 9, 2, 255, 96, 144, 128, 96, 144,
  144, 144, 96, 16, 144, 96, 5, 2, 2, 9, 2, 9, 136, 136, 8, 9,
  9, 9, 0, 1, 60, 66, 153, 165, 161, 165, 153, 66, 60, 5, 7, 7,
  9, 1, 3, 96, 144, 112, 144, 120, 0, 248, 7, 8, 8, 9, 1, 1,
  18, 36, 72, 144, 144, 72, 36, 18, 6, 4, 4, 9, 1, 2, 252, 4,
  4, 4, 5, 1, 1, 9, 2, 4, 248, 8, 9, 9, 9, 0, 1, 60,
  66, 185, 165, 185, 169, 165, 66, 60, 6, 1, 1, 9, 1, 9, 252, 4,
  4, 4, 9, 3, 6, 96, 144, 144, 96, 7, 9, 9, 9, 1, 1, 16,
  16, 16, 254, 16, 16, 16, 0, 254, 4, 6, 6, 9, 1, 4, 96, 144,
  16, 96, 128, 240, 4, 6, 6, 9, 1, 4, 96, 144, 32, 16, 144, 96,
  3, 3, 3, 9, 3, 8, 32, 64, 128, 7, 9, 9, 9, 1, 254, 130,
  130, 130, 130, 130, 198, 186, 128, 128, 7, 10, 10, 9, 1, 0, 126, 138,
  138, 138, 122, 10, 10, 10, 10, 10, 2, 2, 2, 9, 4, 4, 192, 192,
  4, 3, 3, 9, 2, 253, 48, 144, 96, 3, 6, 6, 9, 1, 4, 64,
  192, 64, 64, 64, 224, 5, 6, 6, 9, 1, 4, 112, 136, 136, 112, 0,
  248, 7, 8, 8, 9, 1, 1, 144, 72, 36, 18, 18, 36, 72, 144, 7,
  10, 10, 9, 1, 0, 64, 192, 64, 64, 66, 230, 10, 18, 26, 6, 7,
  10, 10, 9, 1, 0, 64, 192, 64, 64, 76, 242, 2, 12, 16, 30, 7,
  10, 10, 9, 1, 0, 96, 144, 32, 16, 146, 102, 10, 18, 26, 6, 7,
  10, 10, 9, 1, 0, 16, 0, 16, 16, 32, 64, 128, 130, 130, 124, 7,
  12, 12, 9, 1, 0, 64, 32, 16, 0, 56, 68, 130, 130, 254, 130, 130,
  130, 7, 12, 12, 9, 1, 0, 4, 8, 16, 0, 56, 68, 130, 130, 254,
  130, 130, 130, 7, 12, 12, 9, 1, 0, 16, 40, 68, 0, 56, 68, 130,
  130, 254, 130, 130, 130, 7, 11, 11, 9, 1, 0, 98, 156, 0, 56, 68,
  130, 130, 254, 130, 130, 130, 7, 11, 11, 9, 1, 0, 68, 68, 0, 56,
  68, 130, 130, 254, 130, 130, 130, 7, 11, 11, 9, 1, 0, 56, 68, 56,
  40, 68, 130, 130, 254, 130, 130, 130, 7, 10, 10, 9, 1, 0, 110, 144,
  144, 144, 144, 252, 144, 144, 144, 158, 7, 13, 13, 9, 1, 253, 124, 130,
  128, 128, 128, 128, 128, 128, 130, 124, 24, 72, 48, 7, 12, 12, 9, 1,
  0, 64, 32, 16, 0, 254, 64, 64, 120, 64, 64, 64, 254, 7, 12, 12,
  9, 1, 0, 4, 8, 16, 0, 254, 64, 64, 120, 64, 64, 64, 254, 7,
  12, 12, 9, 1, 0, 16, 40, 68, 0, 254, 64, 64, 120, 64, 64, 64,
  254, 7, 11, 11, 9, 1, 0, 68, 68, 0, 254, 64, 64, 120, 64, 64,
  64, 254, 5, 12, 12, 9, 2, 0, 128, 64, 32, 0, 248, 32, 32, 32,
  32, 32, 32, 248, 5, 12, 12, 9, 2, 0, 8, 16, 32, 0, 248, 32,
  32, 32, 32, 32, 32, 248, 5, 12, 12, 9, 2, 0, 32, 80, 136, 0,
  248, 32, 32, 32, 32, 32, 32, 248, 5, 11, 11, 9, 2, 0, 136, 136,
  0, 248, 32, 32, 32, 32, 32, 32, 248, 8, 10, 10, 9, 0, 0, 124,
  66, 65, 65, 225, 65, 65, 65, 66, 124, 7, 11, 11, 9, 1, 0, 98,
  156, 0, 130, 194, 162, 146, 146, 138, 134, 130, 7, 12, 12, 9, 1, 0,
  64, 32, 16, 0, 124, 130, 130, 130, 130, 130, 130, 124, 7, 12, 12, 9,
  1, 0, 4, 8, 16, 0, 124, 130, 130, 130, 130, 130, 130, 124, 7, 12,
  12, 9, 1, 0, 16, 40, 68, 0, 124, 130, 130, 130, 130, 130, 130, 124,
  7, 11, 11, 9, 1, 0, 98, 156, 0, 124, 130, 130, 130, 130, 130, 130,
  124, 7, 11, 11, 9, 1, 0, 68, 68, 0, 124, 130, 130, 130, 130, 130,
  130, 124, 7, 7, 7, 9, 1, 1, 130, 68, 40, 16, 40, 68, 130, 7,
  12, 12, 9, 1, 255, 2, 124, 134, 138, 138, 146, 146, 162, 162, 194, 124,
  128, 7, 12, 12, 9, 1, 0, 64, 32, 16, 0, 130, 130, 130, 130, 130,
  130, 130, 124, 7, 12, 12, 9, 1, 0, 4, 8, 16, 0, 130, 130, 130,
  130, 130, 130, 130, 124, 7, 12, 12, 9, 1, 0, 16, 40, 68, 0, 130,
  130, 130, 130, 130, 130, 130, 124, 7, 11, 11, 9, 1, 0, 68, 68, 0,
  130, 130, 130, 130, 130, 130, 130, 124, 7, 12, 12, 9, 1, 0, 4, 8,
  16, 0, 130, 130, 68, 40, 16, 16, 16, 16, 7, 10, 10, 9, 1, 0,
  128, 128, 252, 130, 130, 130, 252, 128, 128, 128, 6, 10, 10, 9, 1, 0,
  56, 68, 68, 72, 208, 72, 68, 68, 68, 88, 7, 11, 11, 9, 1, 0,
  32, 16, 8, 0, 124, 2, 2, 126, 130, 134, 122, 7, 11, 11, 9, 1,
  0, 4, 8, 16, 0, 124, 2, 2, 126, 130, 134, 122, 7, 11, 11, 9,
  1, 0, 16, 40, 68, 0, 124, 2, 2, 126, 130, 134, 122, 7, 10, 10,
  9, 1, 0, 50, 76, 0, 124, 2, 2, 126, 130, 134, 122, 7, 10, 10,
  9, 1, 0, 68, 68, 0, 124, 2, 2, 126, 130, 134, 122, 7, 11, 11,
  9, 1, 0, 24, 36, 24, 0, 124, 2, 2, 126, 130, 134, 122, 7, 7,
  7, 9, 1, 0, 108, 146, 18, 124, 144, 146, 110, 7, 10, 10, 9, 1,
  253, 124, 130, 128, 128, 128, 130, 124, 24, 72, 48, 7, 11, 11, 9, 1,
  0, 64, 32, 16, 0, 124, 130, 130, 254, 128, 128, 124, 7, 11, 11, 9,
  1, 0, 4, 8, 16, 0, 124, 130, 130, 254, 128, 128, 124, 7, 11, 11,
  9, 1, 0, 16, 40, 68, 0, 124, 130, 130, 254, 128, 128, 124, 7, 10,
  10, 9, 1, 0, 68, 68, 0, 124, 130, 130, 254, 128, 128, 124, 5, 11,
  11, 9, 2, 0, 128, 64, 32, 0, 224, 32, 32, 32, 32, 32, 248, 5,
  11, 11, 9, 2, 0, 16, 32, 64, 0, 224, 32, 32, 32, 32, 32, 248,
  6, 11, 11, 9, 1, 0, 32, 80, 136, 0, 112, 16, 16, 16, 16, 16,
  124, 5, 10, 10, 9, 2, 0, 144, 144, 0, 224, 32, 32, 32, 32, 32,
  248, 7, 11, 11, 9, 1, 0, 72, 48, 80, 8, 124, 130, 130, 130, 130,
  130, 124, 7, 10, 10, 9, 1, 0, 98, 156, 0, 188, 194, 130, 130, 130,
  130, 130, 7, 11, 11, 9, 1, 0, 64, 32, 16, 0, 124, 130, 130, 130,
  130, 130, 124, 7, 11, 11, 9, 1, 0, 4, 8, 16, 0, 124, 130, 130,
  130, 130, 130, 124, 7, 11, 11, 9, 1, 0, 16, 40, 68, 0, 124, 130,
  130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 0, 98, 156, 0, 124, 130,
  130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 0, 68, 68, 0, 124, 130,
  130, 130, 130, 130, 124, 7, 9, 9, 9, 1, 0, 16, 56, 16, 0, 254,
  0, 16, 56, 16, 7, 9, 9, 9, 1, 255, 2, 124, 138, 138, 146, 162,
  162, 124, 128, 7, 11, 11, 9, 1, 0, 64, 32, 16, 0, 132, 132, 132,
  132, 132, 132, 122, 7, 11, 11, 9, 1, 0, 4, 8, 16, 0, 132, 132,
  132, 132, 132, 132, 122, 7, 11, 11, 9, 1, 0, 16, 40, 68, 0, 132,
  132, 132, 132, 132, 132, 122, 7, 10, 10, 9, 1, 0, 72, 72, 0, 132,
  132, 132, 132, 132, 132, 122, 6, 14, 14, 9, 1, 253, 8, 16, 32, 0,
  132, 132, 132, 132, 132, 140, 116, 4, 132, 120, 7, 12, 12, 9, 1, 253,
  128, 128, 128, 188, 194, 130, 130, 194, 188, 128, 128, 128, 6, 13, 13, 9,
  1, 253, 72, 72, 0, 132, 132, 132, 132, 132, 140, 116, 4, 132, 120
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--15-140-75-75-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 8 h=13 x= 4 y=12 dx= 9 dy= 0 ascent=12 len=13
  Font Bounding box     w= 9 h=15 x= 0 y=-3
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =12 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_9x15r[1427] U8G_FONT_SECTION("u8g_font_9x15r") = {
  0, 9, 15, 0, 253, 10, 1, 232, 3, 216, 32, 127, 253, 12, 253, 11,
  253, 0, 0, 0, 9, 0, 12, 1, 11, 11, 9, 4, 0, 128, 128, 128,
  128, 128, 128, 128, 0, 0, 128, 128, 4, 3, 3, 9, 3, 7, 144, 144,
  144, 6, 8, 8, 9, 1, 1, 72, 72, 252, 72, 72, 252, 72, 72, 7,
  11, 11, 9, 1, 255, 16, 124, 146, 144, 80, 56, 20, 18, 146, 124, 16,
  7, 10, 10, 9, 1, 0, 66, 164, 164, 72, 16, 16, 36, 74, 74, 132,
  7, 10, 10, 9, 1, 0, 96, 144, 144, 144, 96, 98, 148, 136, 148, 98,
  1, 3, 3, 9, 4, 7, 128, 128, 128, 3, 12, 12, 9, 3, 255, 32,
  64, 64, 128, 128, 128, 128, 128, 128, 64, 64, 32, 3, 12, 12, 9, 3,
  255, 128, 64, 64, 32, 32, 32, 32, 32, 32, 64, 64, 128, 7, 7, 7,
  9, 1, 3, 16, 146, 84, 56, 84, 146, 16, 7, 7, 7, 9, 1, 1,
  16, 16, 16, 254, 16, 16, 16, 2, 5, 5, 9, 4, 253, 192, 192, 64,
  64, 128, 7, 1, 1, 9, 1, 4, 254, 2, 2, 2, 9, 4, 0, 192,
  192, 7, 10, 10, 9, 1, 0, 2, 4, 4, 8, 16, 16, 32, 64, 64,
  128, 7, 10, 10, 9, 1, 0, 56, 68, 130, 130, 130, 130, 130, 130, 68,
  56, 7, 10, 10, 9, 1, 0, 16, 48, 80, 144, 16, 16, 16, 16, 16,
  254, 7, 10, 10, 9, 1, 0, 124, 130, 130, 4, 8, 16, 32, 64, 128,
  254, 7, 10, 10, 9, 1, 0, 254, 2, 4, 8, 28, 2, 2, 2, 130,
  124, 7, 10, 10, 9, 1, 0, 4, 12, 20, 36, 68, 132, 254, 4, 4,
  4, 7, 10, 10, 9, 1, 0, 254, 128, 128, 188, 194, 2, 2, 2, 130,
  124, 7, 10, 10, 9, 1, 0, 60, 64, 128, 128, 188, 194, 130, 130, 130,
  124, 7, 10, 10, 9, 1, 0, 254, 2, 4, 4, 8, 8, 16, 16, 32,
  32, 7, 10, 10, 9, 1, 0, 56, 68, 130, 68, 56, 68, 130, 130, 68,
  56, 7, 10, 10, 9, 1, 0, 124, 130, 130, 130, 134, 122, 2, 2, 4,
  120, 2, 7, 7, 9, 4, 0, 192, 192, 0, 0, 0, 192, 192, 2, 10,
  10, 9, 4, 253, 192, 192, 0, 0, 0, 192, 192, 64, 64, 128, 5, 10,
  10, 9, 2, 0, 8, 16, 32, 64, 128, 128, 64, 32, 16, 8, 7, 4,
  4, 9, 1, 2, 254, 0, 0, 254, 5, 10, 10, 9, 2, 0, 128, 64,
  32, 16, 8, 8, 16, 32, 64, 128, 7, 10, 10, 9, 1, 0, 124, 130,
  130, 2, 4, 8, 16, 16, 0, 16, 7, 10, 10, 9, 1, 0, 124, 130,
  130, 158, 162, 166, 154, 128, 128, 124, 7, 10, 10, 9, 1, 0, 16, 40,
  68, 130, 130, 130, 254, 130, 130, 130, 7, 10, 10, 9, 1, 0, 248, 132,
  130, 132, 248, 132, 130, 130, 132, 248, 7, 10, 10, 9, 1, 0, 124, 130,
  128, 128, 128, 128, 128, 128, 130, 124, 7, 10, 10, 9, 1, 0, 248, 132,
  130, 130, 130, 130, 130, 130, 132, 248, 7, 10, 10, 9, 1, 0, 254, 128,
  128, 128, 248, 128, 128, 128, 128, 254, 7, 10, 10, 9, 1, 0, 254, 128,
  128, 128, 248, 128, 128, 128, 128, 128, 7, 10, 10, 9, 1, 0, 124, 130,
  128, 128, 128, 142, 130, 130, 130, 124, 7, 10, 10, 9, 1, 0, 130, 130,
  130, 130, 254, 130, 130, 130, 130, 130, 5, 10, 10, 9, 2, 0, 248, 32,
  32, 32, 32, 32, 32, 32, 32, 248, 8, 10, 10, 9, 1, 0, 31, 4,
  4, 4, 4, 4, 4, 4, 132, 120, 7, 10, 10, 9, 1, 0, 130, 132,
  136, 144, 224, 160, 144, 136, 132, 130, 7, 10, 10, 9, 1, 0, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 254, 7, 10, 10, 9, 1, 0, 130, 130,
  198, 170, 170, 146, 146, 130, 130, 130, 7, 10, 10, 9, 1, 0, 130, 130,
  194, 162, 146, 138, 134, 130, 130, 130, 7, 10, 10, 9, 1, 0, 124, 130,
  130, 130, 130, 130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 0, 252, 130,
  130, 130, 252, 128, 128, 128, 128, 128, 7, 12, 12, 9, 1, 254, 124, 130,
  130, 130, 130, 130, 130, 162, 146, 124, 8, 6, 7, 10, 10, 9, 1, 0,
  252, 130, 130, 130, 252, 144, 136, 132, 130, 130, 7, 10, 10, 9, 1, 0,
  124, 130, 130, 128, 112, 12, 2, 130, 130, 124, 7, 10, 10, 9, 1, 0,
  254, 16, 16, 16, 16, 16, 16, 16, 16, 16, 7, 10, 10, 9, 1, 0,
  130, 130, 130, 130, 130, 130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 0,
  130, 130, 130, 68, 68, 68, 40, 40, 40, 16, 7, 10, 10, 9, 1, 0,
  130, 130, 130, 130, 146, 146, 146, 146, 170, 68, 7, 10, 10, 9, 1, 0,
  130, 130, 68, 40, 16, 16, 40, 68, 130, 130, 7, 10, 10, 9, 1, 0,
  130, 130, 68, 40, 16, 16, 16, 16, 16, 16, 7, 10, 10, 9, 1, 0,
  254, 2, 4, 8, 16, 32, 64, 128, 128, 254, 4, 12, 12, 9, 3, 255,
  240, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 240, 7, 10, 10, 9,
  1, 0, 128, 64, 64, 32, 16, 16, 8, 4, 4, 2, 4, 12, 12, 9,
  2, 255, 240, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 240, 7, 4,
  4, 9, 1, 6, 16, 40, 68, 130, 8, 1, 1, 9, 0, 255, 255, 3,
  3, 3, 9, 3, 8, 128, 64, 32, 7, 7, 7, 9, 1, 0, 124, 2,
  2, 126, 130, 134, 122, 7, 10, 10, 9, 1, 0, 128, 128, 128, 188, 194,
  130, 130, 130, 194, 188, 7, 7, 7, 9, 1, 0, 124, 130, 128, 128, 128,
  130, 124, 7, 10, 10, 9, 1, 0, 2, 2, 2, 122, 134, 130, 130, 130,
  134, 122, 7, 7, 7, 9, 1, 0, 124, 130, 130, 254, 128, 128, 124, 7,
  10, 10, 9, 1, 0, 28, 34, 34, 32, 32, 248, 32, 32, 32, 32, 7,
  10, 10, 9, 1, 253, 122, 132, 132, 132, 120, 128, 124, 130, 130, 124, 7,
  10, 10, 9, 1, 0, 128, 128, 128, 188, 194, 130, 130, 130, 130, 130, 5,
  10, 10, 9, 2, 0, 96, 0, 0, 224, 32, 32, 32, 32, 32, 248, 6,
  13, 13, 9, 1, 253, 12, 0, 0, 28, 4, 4, 4, 4, 4, 132, 132,
  132, 120, 7, 10, 10, 9, 1, 0, 128, 128, 128, 130, 140, 176, 192, 176,
  140, 130, 5, 10, 10, 9, 2, 0, 224, 32, 32, 32, 32, 32, 32, 32,
  32, 248, 7, 7, 7, 9, 1, 0, 236, 146, 146, 146, 146, 146, 130, 7,
  7, 7, 9, 1, 0, 188, 194, 130, 130, 130, 130, 130, 7, 7, 7, 9,
  1, 0, 124, 130, 130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 253, 188,
  194, 130, 130, 130, 194, 188, 128, 128, 128, 7, 10, 10, 9, 1, 253, 122,
  134, 130, 130, 130, 134, 122, 2, 2, 2, 7, 7, 7, 9, 1, 0, 156,
  98, 66, 64, 64, 64, 64, 7, 7, 7, 9, 1, 0, 124, 130, 128, 124,
  2, 130, 124, 7, 9, 9, 9, 1, 0, 32, 32, 252, 32, 32, 32, 32,
  34, 28, 7, 7, 7, 9, 1, 0, 132, 132, 132, 132, 132, 132, 122, 7,
  7, 7, 9, 1, 0, 130, 130, 68, 68, 40, 40, 16, 7, 7, 7, 9,
  1, 0, 130, 130, 146, 146, 146, 170, 68, 7, 7, 7, 9, 1, 0, 130,
  68, 40, 16, 40, 68, 130, 6, 10, 10, 9, 1, 253, 132, 132, 132, 132,
  132, 140, 116, 4, 132, 120, 7, 7, 7, 9, 1, 0, 254, 4, 8, 16,
  32, 64, 254, 5, 12, 12, 9, 3, 255, 56, 64, 64, 64, 32, 192, 192,
  32, 64, 64, 64, 56, 1, 12, 12, 9, 4, 255, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 5, 12, 12, 9, 1, 255, 224, 16, 16,
  16, 32, 24, 24, 32, 16, 16, 16, 224, 7, 3, 3, 9, 1, 7, 98,
  146, 140, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--18-120-100-100-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 4, '1' Height: 10
  Calculated Max Values w= 9 h=18 x= 8 y=12 dx= 9 dy= 0 ascent=14 len=36
  Font Bounding box     w= 9 h=18 x= 0 y=-4
  Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
  Pure Font   ascent = 4 descent= 0
  X Font      ascent =10 descent= 0
  Max Font    ascent =14 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_9x18_67_75[3936] U8G_FONT_SECTION("u8g_font_9x18_67_75") = {
  0, 9, 18, 0, 252, 4, 1, 255, 4, 34, 32, 255, 0, 14, 252, 10,
  0, 8, 7, 7, 9, 0, 1, 72, 36, 18, 255, 18, 36, 72, 7, 10,
  10, 9, 1, 0, 16, 16, 16, 146, 84, 56, 146, 84, 56, 16, 7, 7,
  7, 9, 1, 1, 16, 34, 68, 248, 68, 34, 16, 7, 7, 7, 9, 1,
  1, 16, 136, 68, 62, 68, 136, 16, 7, 7, 7, 9, 1, 1, 16, 34,
  66, 254, 66, 34, 16, 7, 10, 10, 9, 1, 0, 16, 56, 84, 146, 16,
  16, 16, 16, 16, 124, 7, 7, 7, 9, 1, 1, 16, 136, 132, 254, 132,
  136, 16, 7, 10, 10, 9, 1, 0, 124, 16, 16, 16, 16, 16, 146, 84,
  56, 16, 7, 10, 10, 9, 1, 0, 16, 56, 84, 146, 16, 146, 84, 56,
  16, 254, 8, 7, 7, 9, 0, 1, 16, 34, 65, 254, 64, 32, 16, 8,
  7, 7, 9, 0, 1, 8, 68, 130, 127, 2, 4, 8, 8, 7, 7, 9,
  0, 1, 16, 34, 69, 254, 68, 36, 16, 8, 7, 7, 9, 0, 1, 8,
  68, 162, 127, 34, 36, 8, 9, 5, 10, 9, 0, 2, 34, 0, 73, 0,
  247, 128, 65, 0, 34, 0, 9, 5, 10, 9, 0, 2, 34, 0, 73, 0,
  255, 128, 73, 0, 34, 0, 5, 10, 10, 9, 2, 0, 32, 64, 72, 184,
  200, 16, 16, 160, 120, 32, 6, 10, 10, 9, 1, 0, 32, 64, 252, 68,
  36, 4, 4, 4, 4, 4, 7, 10, 10, 9, 1, 0, 8, 4, 254, 132,
  136, 128, 128, 128, 128, 128, 6, 10, 10, 9, 1, 0, 4, 4, 4, 4,
  4, 36, 68, 252, 64, 32, 7, 10, 10, 9, 1, 0, 128, 128, 128, 128,
  128, 136, 132, 254, 4, 8, 7, 8, 8, 9, 1, 0, 248, 8, 8, 8,
  8, 42, 28, 8, 7, 8, 8, 9, 1, 1, 2, 2, 2, 34, 66, 254,
  64, 32, 9, 7, 14, 9, 0, 2, 14, 0, 17, 0, 32, 128, 32, 128,
  168, 128, 112, 0, 32, 0, 9, 7, 14, 9, 0, 2, 56, 0, 68, 0,
  130, 0, 130, 0, 138, 128, 7, 0, 2, 0, 7, 10, 10, 9, 1, 0,
  254, 64, 112, 96, 80, 8, 8, 4, 2, 2, 7, 9, 9, 9, 1, 0,
  144, 160, 254, 160, 146, 10, 254, 10, 18, 9, 7, 14, 9, 0, 1, 50,
  0, 71, 0, 138, 128, 130, 0, 130, 0, 68, 0, 56, 0, 9, 7, 14,
  9, 0, 1, 38, 0, 113, 0, 168, 128, 32, 128, 32, 128, 17, 0, 14,
  0, 7, 4, 4, 9, 1, 3, 16, 32, 64, 254, 7, 4, 4, 9, 1,
  0, 254, 64, 32, 16, 4, 10, 10, 9, 4, 0, 128, 192, 160, 144, 128,
  128, 128, 128, 128, 128, 4, 10, 10, 9, 1, 0, 16, 48, 80, 144, 16,
  16, 16, 16, 16, 16, 7, 4, 4, 9, 1, 3, 16, 8, 4, 254, 7,
  4, 4, 9, 1, 0, 254, 4, 8, 16, 4, 10, 10, 9, 4, 0, 128,
  128, 128, 128, 128, 128, 144, 160, 192, 128, 4, 10, 10, 9, 1, 0, 16,
  16, 16, 16, 16, 16, 144, 80, 48, 16, 7, 9, 9, 9, 1, 0, 8,
  4, 254, 4, 40, 64, 254, 64, 32, 9, 10, 20, 9, 0, 0, 34, 0,
  114, 0, 170, 0, 34, 0, 34, 0, 34, 0, 34, 0, 42, 128, 39, 0,
  34, 0, 7, 9, 9, 9, 1, 0, 32, 64, 254, 64, 40, 4, 254, 4,
  8, 7, 10, 10, 9, 1, 0, 32, 64, 254, 64, 32, 32, 64, 254, 64,
  32, 9, 10, 20, 9, 0, 0, 34, 0, 119, 0, 170, 128, 34, 0, 34,
  0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 7, 10, 10, 9, 1,
  0, 8, 4, 254, 4, 8, 8, 4, 254, 4, 8, 9, 10, 20, 9, 0,
  0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 170,
  128, 119, 0, 34, 0, 7, 7, 7, 9, 1, 1, 32, 64, 254, 0, 254,
  4, 8, 7, 7, 7, 9, 1, 1, 8, 4, 254, 0, 254, 64, 32, 9,
  7, 14, 9, 0, 1, 16, 0, 33, 0, 127, 128, 130, 0, 127, 128, 36,
  0, 16, 0, 9, 7, 14, 9, 0, 1, 20, 0, 34, 0, 127, 0, 136,
  128, 127, 0, 34, 0, 20, 0, 9, 7, 14, 9, 0, 1, 4, 0, 18,
  0, 255, 0, 32, 128, 255, 0, 66, 0, 4, 0, 9, 7, 14, 9, 0,
  1, 16, 0, 32, 0, 127, 128, 128, 0, 127, 128, 32, 0, 16, 0, 7,
  10, 10, 9, 1, 0, 16, 40, 108, 170, 40, 40, 40, 40, 40, 40, 9,
  7, 14, 9, 0, 1, 4, 0, 2, 0, 255, 0, 0, 128, 255, 0, 2,
  0, 4, 0, 7, 10, 10, 9, 1, 0, 40, 40, 40, 40, 40, 40, 170,
  108, 40, 16, 9, 7, 14, 9, 0, 1, 20, 0, 34, 0, 127, 0, 128,
  128, 127, 0, 34, 0, 20, 0, 7, 10, 10, 9, 1, 0, 16, 40, 108,
  170, 40, 40, 170, 108, 40, 16, 7, 7, 7, 9, 1, 1, 252, 144, 136,
  196, 162, 144, 8, 7, 7, 7, 9, 1, 1, 126, 18, 34, 70, 138, 18,
  32, 7, 7, 7, 9, 1, 1, 32, 18, 138, 70, 34, 18, 126, 7, 7,
  7, 9, 1, 1, 8, 144, 162, 196, 136, 144, 252, 9, 9, 18, 9, 0,
  0, 8, 0, 16, 0, 63, 128, 64, 0, 255, 128, 64, 0, 63, 128, 16,
  0, 8, 0, 9, 9, 18, 9, 0, 0, 8, 0, 4, 0, 254, 0, 1,
  0, 255, 128, 1, 0, 254, 0, 4, 0, 8, 0, 8, 7, 7, 9, 0,
  1, 16, 32, 72, 245, 66, 32, 16, 8, 7, 7, 9, 0, 1, 8, 4,
  18, 175, 66, 4, 8, 7, 10, 10, 9, 1, 0, 16, 56, 84, 146, 16,
  124, 16, 124, 16, 16, 7, 10, 10, 9, 1, 0, 16, 16, 124, 16, 124,
  16, 146, 84, 56, 16, 7, 7, 7, 9, 1, 1, 16, 32, 64, 182, 64,
  32, 16, 7, 10, 10, 9, 1, 0, 16, 40, 84, 146, 0, 16, 16, 0,
  16, 16, 7, 7, 7, 9, 1, 1, 16, 8, 4, 218, 4, 8, 16, 7,
  10, 10, 9, 1, 0, 16, 16, 0, 16, 16, 0, 146, 84, 40, 16, 7,
  5, 5, 9, 1, 2, 144, 160, 254, 160, 144, 7, 5, 5, 9, 1, 2,
  18, 10, 254, 10, 18, 9, 7, 14, 9, 0, 1, 16, 0, 48, 0, 95,
  128, 128, 128, 95, 128, 48, 0, 16, 0, 7, 10, 10, 9, 1, 0, 16,
  40, 68, 238, 40, 40, 40, 40, 40, 56, 9, 7, 14, 9, 0, 1, 4,
  0, 6, 0, 253, 0, 128, 128, 253, 0, 6, 0, 4, 0, 7, 10, 10,
  9, 1, 0, 56, 40, 40, 40, 40, 40, 238, 68, 40, 16, 7, 11, 11,
  9, 1, 0, 16, 40, 68, 238, 40, 40, 56, 0, 56, 40, 56, 7, 11,
  11, 9, 1, 255, 16, 40, 68, 238, 40, 40, 40, 40, 108, 68, 124, 7,
  11, 11, 9, 1, 255, 16, 40, 68, 254, 40, 40, 40, 40, 108, 68, 124,
  7, 11, 11, 9, 1, 255, 16, 40, 68, 254, 56, 56, 56, 56, 124, 68,
  124, 7, 10, 10, 9, 1, 0, 16, 40, 68, 238, 68, 238, 40, 40, 40,
  56, 7, 11, 11, 9, 1, 255, 16, 40, 68, 238, 68, 238, 40, 40, 108,
  68, 124, 9, 7, 14, 9, 0, 1, 132, 0, 134, 0, 253, 0, 128, 128,
  253, 0, 134, 0, 132, 0, 7, 7, 7, 9, 1, 0, 252, 128, 184, 176,
  168, 132, 2, 7, 7, 7, 9, 1, 0, 128, 66, 42, 26, 58, 2, 126,
  7, 11, 11, 9, 1, 255, 16, 40, 68, 238, 40, 40, 40, 238, 68, 40,
  16, 9, 7, 14, 9, 0, 1, 4, 0, 50, 0, 73, 0, 255, 128, 73,
  0, 50, 0, 4, 0, 9, 10, 20, 9, 0, 0, 34, 0, 39, 0, 42,
  128, 34, 0, 34, 0, 34, 0, 34, 0, 170, 0, 114, 0, 34, 0, 7,
  13, 13, 9, 1, 254, 8, 4, 254, 4, 8, 4, 254, 4, 8, 4, 254,
  4, 8, 8, 5, 5, 9, 0, 2, 36, 68, 255, 68, 36, 8, 5, 5,
  9, 0, 2, 36, 34, 255, 34, 36, 9, 5, 10, 9, 0, 2, 42, 0,
  73, 0, 255, 128, 73, 0, 42, 0, 8, 5, 5, 9, 0, 2, 42, 74,
  255, 74, 42, 8, 5, 5, 9, 0, 2, 84, 82, 255, 82, 84, 9, 5,
  10, 9, 0, 2, 85, 0, 148, 128, 255, 128, 148, 128, 85, 0, 7, 7,
  7, 9, 1, 1, 16, 48, 80, 158, 80, 48, 16, 7, 7, 7, 9, 1,
  1, 16, 24, 20, 242, 20, 24, 16, 8, 5, 5, 9, 0, 2, 36, 102,
  189, 102, 36, 9, 9, 18, 9, 0, 5, 255, 128, 255, 128, 255, 128, 255,
  128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 9, 2, 4, 9, 0,
  252, 255, 128, 255, 128, 9, 4, 8, 9, 0, 252, 255, 128, 255, 128, 255,
  128, 255, 128, 9, 7, 14, 9, 0, 252, 255, 128, 255, 128, 255, 128, 255,
  128, 255, 128, 255, 128, 255, 128, 9, 9, 18, 9, 0, 252, 255, 128, 255,
  128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 9,
  11, 22, 9, 0, 252, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255,
  128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 9, 14, 28, 9, 0,
  252, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255,
  128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 9, 16, 32,
  9, 0, 252, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255,
  128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255,
  128, 255, 128, 9, 18, 36, 9, 0, 252, 255, 128, 255, 128, 255, 128, 255,
  128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255,
  128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 8, 18, 18,
  9, 0, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 7, 18, 18, 9, 0, 252, 254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 6, 18, 18,
  9, 0, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252,
  252, 252, 252, 252, 252, 5, 18, 18, 9, 0, 252, 248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 3, 18, 18,
  9, 0, 252, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 2, 18, 18, 9, 0, 252, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 1, 18, 18,
  9, 0, 252, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 4, 18, 18, 9, 5, 252, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 9, 17, 34,
  9, 0, 253, 85, 0, 0, 0, 170, 128, 0, 0, 85, 0, 0, 0, 170,
  128, 0, 0, 85, 0, 0, 0, 170, 128, 0, 0, 85, 0, 0, 0, 170,
  128, 0, 0, 85, 0, 9, 18, 36, 9, 0, 252, 170, 128, 85, 0, 170,
  128, 85, 0, 170, 128, 85, 0, 170, 128, 85, 0, 170, 128, 85, 0, 170,
  128, 85, 0, 170, 128, 85, 0, 170, 128, 85, 0, 170, 128, 85, 0, 9,
  18, 36, 9, 0, 252, 255, 128, 170, 128, 255, 128, 85, 0, 255, 128, 170,
  128, 255, 128, 85, 0, 255, 128, 170, 128, 255, 128, 85, 0, 255, 128, 170,
  128, 255, 128, 85, 0, 255, 128, 170, 128, 9, 2, 4, 9, 0, 12, 255,
  128, 255, 128, 1, 18, 18, 9, 8, 252, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 5, 9, 9, 9, 0,
  252, 248, 248, 248, 248, 248, 248, 248, 248, 248, 4, 9, 9, 9, 5, 252,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 5, 9, 9, 9, 0, 5, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 9, 18, 36, 9, 0, 252, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128,
  255, 128, 9, 18, 36, 9, 0, 252, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 7, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 9, 18, 36, 9,
  0, 252, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 9, 18, 36, 9, 0, 252, 255, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128,
  4, 9, 9, 9, 5, 5, 240, 240, 240, 240, 240, 240, 240, 240, 240, 9,
  18, 36, 9, 0, 252, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 9, 18, 36, 9, 0, 252, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255,
  128, 255, 128, 7, 7, 7, 9, 1, 1, 254, 254, 254, 254, 254, 254, 254,
  7, 7, 7, 9, 1, 1, 254, 130, 130, 130, 130, 130, 254, 7, 7, 7,
  9, 1, 1, 124, 130, 130, 130, 130, 130, 124, 7, 7, 7, 9, 1, 1,
  254, 130, 186, 186, 186, 130, 254, 7, 7, 7, 9, 1, 1, 254, 130, 254,
  130, 254, 130, 254, 7, 7, 7, 9, 1, 1, 254, 170, 170, 170, 170, 170,
  254, 7, 7, 7, 9, 1, 1, 254, 170, 254, 170, 254, 170, 254, 7, 7,
  7, 9, 1, 1, 254, 146, 138, 198, 162, 146, 254, 7, 7, 7, 9, 1,
  1, 254, 146, 162, 198, 138, 146, 254, 7, 7, 7, 9, 1, 1, 254, 214,
  138, 214, 162, 214, 254, 3, 3, 3, 9, 3, 3, 224, 224, 224, 3, 3,
  3, 9, 3, 3, 224, 160, 224, 9, 5, 10, 9, 0, 2, 255, 128, 255,
  128, 255, 128, 255, 128, 255, 128, 9, 5, 10, 9, 0, 2, 255, 128, 128,
  128, 128, 128, 128, 128, 255, 128, 5, 9, 9, 9, 2, 0, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 5, 9, 9, 9, 2, 0, 248, 136, 136, 136,
  136, 136, 136, 136, 248, 9, 5, 10, 9, 0, 2, 127, 128, 127, 128, 255,
  128, 255, 0, 255, 0, 9, 5, 10, 9, 0, 2, 127, 128, 64, 128, 128,
  128, 129, 0, 255, 0, 9, 10, 20, 9, 0, 0, 8, 0, 8, 0, 28,
  0, 28, 0, 62, 0, 62, 0, 127, 0, 127, 0, 255, 128, 255, 128, 9,
  10, 20, 9, 0, 0, 8, 0, 8, 0, 20, 0, 20, 0, 34, 0, 34,
  0, 65, 0, 65, 0, 128, 128, 255, 128, 7, 7, 7, 9, 1, 1, 16,
  16, 56, 56, 124, 124, 254, 7, 7, 7, 9, 1, 1, 16, 16, 40, 40,
  68, 68, 254, 9, 9, 18, 9, 0, 0, 192, 0, 240, 0, 252, 0, 255,
  0, 255, 128, 255, 0, 252, 0, 240, 0, 192, 0, 9, 9, 18, 9, 0,
  0, 192, 0, 176, 0, 140, 0, 131, 0, 128, 128, 131, 0, 140, 0, 176,
  0, 192, 0, 7, 7, 7, 9, 1, 1, 128, 224, 248, 254, 248, 224, 128,
  7, 7, 7, 9, 1, 1, 128, 224, 152, 134, 152, 224, 128, 9, 5, 10,
  9, 0, 2, 224, 0, 252, 0, 255, 128, 252, 0, 224, 0, 9, 5, 10,
  9, 0, 2, 224, 0, 156, 0, 131, 128, 156, 0, 224, 0, 9, 10, 20,
  9, 0, 0, 255, 128, 255, 128, 127, 0, 127, 0, 62, 0, 62, 0, 28,
  0, 28, 0, 8, 0, 8, 0, 9, 10, 20, 9, 0, 0, 255, 128, 128,
  128, 65, 0, 65, 0, 34, 0, 34, 0, 20, 0, 20, 0, 8, 0, 8,
  0, 7, 7, 7, 9, 1, 1, 254, 124, 124, 56, 56, 16, 16, 7, 7,
  7, 9, 1, 1, 254, 68, 68, 40, 40, 16, 16, 9, 9, 18, 9, 0,
  0, 1, 128, 7, 128, 31, 128, 127, 128, 255, 128, 127, 128, 31, 128, 7,
  128, 1, 128, 9, 9, 18, 9, 0, 0, 1, 128, 6, 128, 24, 128, 96,
  128, 128, 128, 96, 128, 24, 128, 6, 128, 1, 128, 7, 7, 7, 9, 1,
  1, 2, 14, 62, 254, 62, 14, 2, 7, 7, 7, 9, 1, 1, 2, 14,
  50, 194, 50, 14, 2, 9, 5, 10, 9, 0, 2, 3, 128, 31, 128, 255,
  128, 31, 128, 3, 128, 9, 5, 10, 9, 0, 2, 3, 128, 28, 128, 224,
  128, 28, 128, 3, 128, 9, 9, 18, 9, 0, 0, 8, 0, 28, 0, 62,
  0, 127, 0, 255, 128, 127, 0, 62, 0, 28, 0, 8, 0, 9, 9, 18,
  9, 0, 0, 8, 0, 20, 0, 34, 0, 65, 0, 128, 128, 65, 0, 34,
  0, 20, 0, 8, 0, 9, 9, 18, 9, 0, 0, 8, 0, 20, 0, 34,
  0, 73, 0, 156, 128, 73, 0, 34, 0, 20, 0, 8, 0, 7, 7, 7,
  9, 1, 1, 56, 68, 146, 186, 146, 68, 56, 5, 9, 9, 9, 2, 0,
  32, 32, 80, 80, 136, 80, 80, 32, 32, 7, 7, 7, 9, 1, 1, 56,
  68, 130, 130, 130, 68, 56, 7, 7, 7, 9, 1, 1, 16, 68, 0, 130,
  0, 68, 16, 7, 7, 7, 9, 1, 1, 56, 108, 170, 170, 170, 108, 56,
  7, 7, 7, 9, 1, 1, 56, 68, 146, 170, 146, 68, 56, 7, 7, 7,
  9, 1, 1, 56, 124, 254, 254, 254, 124, 56, 7, 7, 7, 9, 1, 1,
  56, 116, 242, 242, 242, 116, 56, 7, 7, 7, 9, 1, 1, 56, 92, 158,
  158, 158, 92, 56, 7, 7, 7, 9, 1, 1, 56, 68, 130, 254, 254, 124,
  56, 7, 7, 7, 9, 1, 1, 56, 124, 254, 254, 130, 68, 56, 7, 7,
  7, 9, 1, 1, 56, 92, 158, 158, 130, 68, 56, 7, 7, 7, 9, 1,
  1, 56, 92, 158, 254, 254, 124, 56, 4, 7, 7, 9, 1, 1, 48, 112,
  240, 240, 240, 112, 48, 4, 7, 7, 9, 4, 1, 192, 224, 240, 240, 240,
  224, 192, 9, 18, 36, 9, 0, 252, 255, 128, 255, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 227, 128, 193, 128, 193, 128, 193, 128, 227, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 9, 18, 36, 9,
  0, 252, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 227, 128,
  221, 128, 190, 128, 190, 128, 190, 128, 221, 128, 227, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 9, 10, 20, 9, 0, 4, 255, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 227, 128, 221, 128, 190, 128, 190, 128,
  9, 9, 18, 9, 0, 252, 190, 128, 190, 128, 221, 128, 227, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 255, 128, 4, 4, 4, 9, 1, 4, 48, 64,
  128, 128, 4, 4, 4, 9, 4, 4, 192, 32, 16, 16, 4, 4, 4, 9,
  4, 1, 16, 16, 32, 192, 4, 4, 4, 9, 1, 1, 128, 128, 64, 48,
  7, 4, 4, 9, 1, 4, 56, 68, 130, 130, 7, 4, 4, 9, 1, 1,
  130, 130, 68, 56, 7, 7, 7, 9, 1, 1, 2, 6, 14, 30, 62, 126,
  254, 7, 7, 7, 9, 1, 1, 128, 192, 224, 240, 248, 252, 254, 7, 7,
  7, 9, 1, 1, 254, 252, 248, 240, 224, 192, 128, 7, 7, 7, 9, 1,
  1, 254, 126, 62, 30, 14, 6, 2, 5, 5, 5, 9, 2, 2, 112, 136,
  136, 136, 112, 7, 7, 7, 9, 1, 1, 254, 242, 242, 242, 242, 242, 254,
  7, 7, 7, 9, 1, 1, 254, 158, 158, 158, 158, 158, 254, 7, 7, 7,
  9, 1, 1, 254, 254, 250, 242, 226, 194, 254, 7, 7, 7, 9, 1, 1,
  254, 134, 142, 158, 190, 254, 254, 7, 7, 7, 9, 1, 1, 254, 146, 146,
  146, 146, 146, 254, 9, 10, 20, 9, 0, 0, 8, 0, 8, 0, 20, 0,
  20, 0, 34, 0, 42, 0, 93, 0, 73, 0, 128, 128, 255, 128, 9, 10,
  20, 9, 0, 0, 8, 0, 8, 0, 28, 0, 28, 0, 58, 0, 58, 0,
  121, 0, 121, 0, 248, 128, 255, 128, 9, 10, 20, 9, 0, 0, 8, 0,
  8, 0, 28, 0, 28, 0, 46, 0, 46, 0, 79, 0, 79, 0, 143, 128,
  255, 128, 9, 9, 18, 9, 0, 0, 62, 0, 65, 0, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 65, 0, 62, 0, 7, 7, 7, 9, 1, 1,
  254, 146, 146, 242, 130, 130, 254, 7, 7, 7, 9, 1, 1, 254, 130, 130,
  242, 146, 146, 254, 7, 7, 7, 9, 1, 1, 254, 130, 130, 158, 146, 146,
  254, 7, 7, 7, 9, 1, 1, 254, 146, 146, 158, 130, 130, 254, 7, 7,
  7, 9, 1, 1, 124, 146, 146, 242, 130, 130, 124, 7, 7, 7, 9, 1,
  1, 124, 130, 130, 242, 146, 146, 124, 7, 7, 7, 9, 1, 1, 124, 130,
  130, 158, 146, 146, 124, 7, 7, 7, 9, 1, 1, 124, 146, 146, 158, 130,
  130, 124, 6, 6, 6, 9, 1, 1, 252, 136, 144, 160, 192, 128, 6, 6,
  6, 9, 1, 1, 252, 68, 36, 20, 12, 4, 6, 6, 6, 9, 1, 1,
  128, 192, 160, 144, 136, 252, 6, 6, 6, 9, 1, 1, 252, 132, 132, 132,
  132, 252, 6, 6, 6, 9, 1, 1, 252, 252, 252, 252, 252, 252, 5, 5,
  5, 9, 2, 1, 248, 136, 136, 136, 248, 5, 5, 5, 9, 2, 1, 248,
  248, 248, 248, 248, 6, 6, 6, 9, 1, 1, 4, 12, 20, 36, 68, 252
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--18-120-100-100-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 9, '1' Height: 5
  Calculated Max Values w= 9 h=10 x= 3 y= 3 dx= 9 dy= 0 ascent=10 len=20
  Font Bounding box     w= 9 h=18 x= 0 y=-4
  Calculated Min Values           x= 0 y= 0 dx= 0 dy= 0
  Pure Font   ascent = 9 descent= 0
  X Font      ascent = 9 descent= 0
  Max Font    ascent =10 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_9x18_75r[792] U8G_FONT_SECTION("u8g_font_9x18_75r") = {
  0, 9, 18, 0, 252, 9, 2, 33, 0, 0, 32, 79, 0, 10, 0, 9,
  0, 7, 7, 7, 9, 1, 1, 254, 254, 254, 254, 254, 254, 254, 7, 7,
  7, 9, 1, 1, 254, 130, 130, 130, 130, 130, 254, 7, 7, 7, 9, 1,
  1, 124, 130, 130, 130, 130, 130, 124, 7, 7, 7, 9, 1, 1, 254, 130,
  186, 186, 186, 130, 254, 7, 7, 7, 9, 1, 1, 254, 130, 254, 130, 254,
  130, 254, 7, 7, 7, 9, 1, 1, 254, 170, 170, 170, 170, 170, 254, 7,
  7, 7, 9, 1, 1, 254, 170, 254, 170, 254, 170, 254, 7, 7, 7, 9,
  1, 1, 254, 146, 138, 198, 162, 146, 254, 7, 7, 7, 9, 1, 1, 254,
  146, 162, 198, 138, 146, 254, 7, 7, 7, 9, 1, 1, 254, 214, 138, 214,
  162, 214, 254, 3, 3, 3, 9, 3, 3, 224, 224, 224, 3, 3, 3, 9,
  3, 3, 224, 160, 224, 9, 5, 10, 9, 0, 2, 255, 128, 255, 128, 255,
  128, 255, 128, 255, 128, 9, 5, 10, 9, 0, 2, 255, 128, 128, 128, 128,
  128, 128, 128, 255, 128, 5, 9, 9, 9, 2, 0, 248, 248, 248, 248, 248,
  248, 248, 248, 248, 5, 9, 9, 9, 2, 0, 248, 136, 136, 136, 136, 136,
  136, 136, 248, 9, 5, 10, 9, 0, 2, 127, 128, 127, 128, 255, 128, 255,
  0, 255, 0, 9, 5, 10, 9, 0, 2, 127, 128, 64, 128, 128, 128, 129,
  0, 255, 0, 9, 10, 20, 9, 0, 0, 8, 0, 8, 0, 28, 0, 28,
  0, 62, 0, 62, 0, 127, 0, 127, 0, 255, 128, 255, 128, 9, 10, 20,
  9, 0, 0, 8, 0, 8, 0, 20, 0, 20, 0, 34, 0, 34, 0, 65,
  0, 65, 0, 128, 128, 255, 128, 7, 7, 7, 9, 1, 1, 16, 16, 56,
  56, 124, 124, 254, 7, 7, 7, 9, 1, 1, 16, 16, 40, 40, 68, 68,
  254, 9, 9, 18, 9, 0, 0, 192, 0, 240, 0, 252, 0, 255, 0, 255,
  128, 255, 0, 252, 0, 240, 0, 192, 0, 9, 9, 18, 9, 0, 0, 192,
  0, 176, 0, 140, 0, 131, 0, 128, 128, 131, 0, 140, 0, 176, 0, 192,
  0, 7, 7, 7, 9, 1, 1, 128, 224, 248, 254, 248, 224, 128, 7, 7,
  7, 9, 1, 1, 128, 224, 152, 134, 152, 224, 128, 9, 5, 10, 9, 0,
  2, 224, 0, 252, 0, 255, 128, 252, 0, 224, 0, 9, 5, 10, 9, 0,
  2, 224, 0, 156, 0, 131, 128, 156, 0, 224, 0, 9, 10, 20, 9, 0,
  0, 255, 128, 255, 128, 127, 0, 127, 0, 62, 0, 62, 0, 28, 0, 28,
  0, 8, 0, 8, 0, 9, 10, 20, 9, 0, 0, 255, 128, 128, 128, 65,
  0, 65, 0, 34, 0, 34, 0, 20, 0, 20, 0, 8, 0, 8, 0, 7,
  7, 7, 9, 1, 1, 254, 124, 124, 56, 56, 16, 16, 7, 7, 7, 9,
  1, 1, 254, 68, 68, 40, 40, 16, 16, 9, 9, 18, 9, 0, 0, 1,
  128, 7, 128, 31, 128, 127, 128, 255, 128, 127, 128, 31, 128, 7, 128, 1,
  128, 9, 9, 18, 9, 0, 0, 1, 128, 6, 128, 24, 128, 96, 128, 128,
  128, 96, 128, 24, 128, 6, 128, 1, 128, 7, 7, 7, 9, 1, 1, 2,
  14, 62, 254, 62, 14, 2, 7, 7, 7, 9, 1, 1, 2, 14, 50, 194,
  50, 14, 2, 9, 5, 10, 9, 0, 2, 3, 128, 31, 128, 255, 128, 31,
  128, 3, 128, 9, 5, 10, 9, 0, 2, 3, 128, 28, 128, 224, 128, 28,
  128, 3, 128, 9, 9, 18, 9, 0, 0, 8, 0, 28, 0, 62, 0, 127,
  0, 255, 128, 127, 0, 62, 0, 28, 0, 8, 0, 9, 9, 18, 9, 0,
  0, 8, 0, 20, 0, 34, 0, 65, 0, 128, 128, 65, 0, 34, 0, 20,
  0, 8, 0, 9, 9, 18, 9, 0, 0, 8, 0, 20, 0, 34, 0, 73,
  0, 156, 128, 73, 0, 34, 0, 20, 0, 8, 0, 7, 7, 7, 9, 1,
  1, 56, 68, 146, 186, 146, 68, 56, 5, 9, 9, 9, 2, 0, 32, 32,
  80, 80, 136, 80, 80, 32, 32, 7, 7, 7, 9, 1, 1, 56, 68, 130,
  130, 130, 68, 56, 7, 7, 7, 9, 1, 1, 16, 68, 0, 130, 0, 68,
  16, 7, 7, 7, 9, 1, 1, 56, 108, 170, 170, 170, 108, 56, 7, 7,
  7, 9, 1, 1, 56, 68, 146, 170, 146, 68, 56, 7, 7, 7, 9, 1,
  1, 56, 124, 254, 254, 254, 124, 56
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--18-120-100-100-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 0, '1' Height: 9
  Calculated Max Values w= 9 h=12 x= 4 y= 5 dx= 9 dy= 0 ascent=12 len=24
  Font Bounding box     w= 9 h=18 x= 0 y=-4
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 9 descent= 0
  X Font      ascent =11 descent= 0
  Max Font    ascent =12 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_9x18_78_79[3336] U8G_FONT_SECTION("u8g_font_9x18_78_79") = {
  0, 9, 18, 0, 252, 9, 2, 231, 4, 175, 32, 255, 0, 12, 255, 11,
  0, 9, 9, 18, 9, 0, 0, 62, 0, 28, 0, 136, 128, 201, 128, 247,
  128, 201, 128, 136, 128, 28, 0, 62, 0, 9, 9, 18, 9, 0, 0, 8,
  0, 20, 0, 255, 128, 162, 128, 65, 0, 162, 128, 255, 128, 20, 0, 8,
  0, 9, 9, 18, 9, 0, 0, 8, 0, 28, 0, 8, 0, 73, 0, 255,
  128, 73, 0, 8, 0, 28, 0, 8, 0, 9, 9, 18, 9, 0, 0, 8,
  0, 28, 0, 28, 0, 107, 0, 255, 128, 107, 0, 28, 0, 28, 0, 8,
  0, 9, 9, 18, 9, 0, 0, 8, 0, 28, 0, 28, 0, 107, 0, 255,
  128, 107, 0, 28, 0, 28, 0, 8, 0, 9, 9, 18, 9, 0, 0, 8,
  0, 28, 0, 28, 0, 107, 0, 255, 128, 107, 0, 28, 0, 28, 0, 8,
  0, 9, 9, 18, 9, 0, 0, 8, 0, 8, 0, 28, 0, 62, 0, 255,
  128, 62, 0, 28, 0, 8, 0, 8, 0, 9, 9, 18, 9, 0, 0, 8,
  0, 20, 0, 20, 0, 99, 0, 128, 128, 99, 0, 20, 0, 20, 0, 8,
  0, 255, 9, 9, 18, 9, 0, 0, 8, 0, 8, 0, 20, 0, 247, 128,
  65, 0, 34, 0, 73, 0, 85, 0, 99, 0, 9, 10, 20, 9, 0, 0,
  127, 0, 247, 128, 247, 128, 227, 128, 0, 0, 128, 128, 193, 128, 201, 128,
  156, 128, 127, 0, 9, 9, 18, 9, 0, 0, 8, 0, 8, 0, 28, 0,
  227, 128, 99, 0, 34, 0, 62, 0, 119, 0, 65, 0, 9, 9, 18, 9,
  0, 0, 8, 0, 8, 0, 20, 0, 235, 128, 93, 0, 42, 0, 34, 0,
  127, 0, 65, 0, 9, 9, 18, 9, 0, 0, 8, 0, 8, 0, 20, 0,
  235, 128, 93, 0, 42, 0, 34, 0, 127, 0, 65, 0, 9, 9, 18, 9,
  0, 0, 8, 0, 8, 0, 20, 0, 235, 128, 93, 0, 42, 0, 34, 0,
  127, 0, 65, 0, 9, 9, 18, 9, 0, 0, 8, 0, 8, 0, 20, 0,
  247, 128, 73, 0, 54, 0, 42, 0, 127, 0, 65, 0, 8, 7, 7, 9,
  0, 2, 24, 24, 44, 199, 46, 60, 102, 8, 9, 9, 9, 0, 0, 24,
  219, 255, 126, 24, 126, 255, 219, 24, 8, 9, 9, 9, 0, 0, 24, 219,
  255, 102, 36, 102, 255, 219, 24, 9, 9, 18, 9, 0, 0, 8, 0, 73,
  0, 42, 0, 28, 0, 255, 128, 28, 0, 42, 0, 73, 0, 8, 0, 9,
  9, 18, 9, 0, 0, 8, 0, 73, 0, 62, 0, 62, 0, 255, 128, 62,
  0, 62, 0, 73, 0, 8, 0, 9, 9, 18, 9, 0, 0, 8, 0, 73,
  0, 54, 0, 62, 0, 213, 128, 62, 0, 54, 0, 73, 0, 8, 0, 9,
  9, 18, 9, 0, 0, 8, 0, 136, 128, 107, 0, 62, 0, 28, 0, 62,
  0, 107, 0, 136, 128, 8, 0, 9, 9, 18, 9, 0, 0, 34, 0, 20,
  0, 148, 128, 127, 0, 28, 0, 127, 0, 148, 128, 20, 0, 34, 0, 9,
  9, 18, 9, 0, 0, 34, 0, 54, 0, 255, 128, 127, 0, 62, 0, 127,
  0, 255, 128, 54, 0, 34, 0, 9, 9, 18, 9, 0, 0, 42, 0, 42,
  0, 221, 128, 62, 0, 255, 128, 62, 0, 221, 128, 42, 0, 42, 0, 9,
  9, 18, 9, 0, 0, 42, 0, 42, 0, 221, 128, 42, 0, 255, 128, 42,
  0, 221, 128, 42, 0, 42, 0, 9, 11, 22, 9, 0, 0, 28, 0, 28,
  0, 201, 128, 201, 128, 34, 0, 8, 0, 34, 0, 201, 128, 201, 128, 28,
  0, 28, 0, 9, 11, 22, 9, 0, 0, 28, 0, 28, 0, 201, 128, 201,
  128, 62, 0, 20, 0, 62, 0, 201, 128, 201, 128, 28, 0, 28, 0, 9,
  11, 22, 9, 0, 0, 28, 0, 28, 0, 201, 128, 201, 128, 62, 0, 28,
  0, 62, 0, 201, 128, 201, 128, 28, 0, 28, 0, 9, 11, 22, 9, 0,
  0, 28, 0, 20, 0, 201, 128, 201, 128, 62, 0, 20, 0, 127, 0, 170,
  128, 201, 128, 28, 0, 28, 0, 8, 9, 9, 9, 0, 0, 24, 24, 219,
  255, 36, 36, 126, 231, 66, 255, 255, 255, 8, 9, 9, 9, 0, 0, 24,
  203, 189, 110, 24, 118, 189, 211, 24, 9, 12, 24, 9, 0, 0, 8, 0,
  42, 0, 93, 0, 170, 128, 107, 0, 221, 128, 221, 128, 107, 0, 170, 128,
  93, 0, 42, 0, 8, 0, 9, 12, 24, 9, 0, 0, 8, 0, 42, 0,
  93, 0, 170, 128, 107, 0, 221, 128, 221, 128, 107, 0, 170, 128, 93, 0,
  42, 0, 8, 0, 9, 12, 24, 9, 0, 0, 8, 0, 42, 0, 93, 0,
  170, 128, 107, 0, 221, 128, 221, 128, 107, 0, 170, 128, 93, 0, 42, 0,
  8, 0, 9, 9, 18, 9, 0, 0, 8, 0, 73, 0, 42, 0, 20, 0,
  235, 128, 20, 0, 42, 0, 73, 0, 8, 0, 9, 9, 18, 9, 0, 0,
  8, 0, 73, 0, 42, 0, 20, 0, 235, 128, 20, 0, 42, 0, 73, 0,
  8, 0, 8, 9, 9, 9, 0, 0, 24, 219, 203, 60, 24, 60, 211, 219,
  24, 9, 9, 18, 9, 0, 0, 8, 0, 73, 0, 42, 0, 0, 0, 235,
  128, 0, 0, 42, 0, 73, 0, 8, 0, 9, 9, 18, 9, 0, 0, 8,
  0, 73, 0, 42, 0, 28, 0, 255, 128, 28, 0, 42, 0, 73, 0, 8,
  0, 255, 9, 8, 16, 9, 0, 1, 62, 0, 67, 0, 129, 128, 129, 128,
  129, 128, 129, 128, 67, 0, 62, 0, 255, 9, 9, 18, 9, 0, 0, 254,
  0, 130, 0, 131, 128, 131, 128, 131, 128, 131, 128, 255, 128, 63, 128, 63,
  128, 9, 9, 18, 9, 0, 0, 63, 128, 63, 128, 255, 128, 131, 128, 131,
  128, 131, 128, 131, 128, 130, 0, 254, 0, 8, 8, 8, 9, 0, 0, 254,
  131, 131, 131, 131, 131, 255, 127, 8, 8, 8, 9, 0, 0, 127, 255, 131,
  131, 131, 131, 131, 254, 255, 255, 255, 9, 9, 18, 9, 0, 0, 8, 0,
  28, 0, 8, 0, 65, 0, 227, 128, 65, 0, 8, 0, 28, 0, 8, 0,
  255, 1, 10, 10, 9, 4, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 2, 10, 10, 9, 3, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 3, 10, 10, 9, 3, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 4, 6, 6, 9, 3, 5, 112, 128, 224, 240, 240, 96, 4, 6, 6,
  9, 3, 5, 96, 240, 240, 112, 16, 224, 9, 6, 12, 9, 0, 5, 115,
  128, 132, 0, 231, 0, 247, 128, 247, 128, 99, 0, 9, 6, 12, 9, 0,
  5, 99, 0, 247, 128, 247, 128, 115, 128, 16, 128, 231, 0, 255, 255, 7,
  10, 10, 9, 1, 0, 4, 126, 228, 228, 228, 124, 4, 100, 104, 48, 5,
  10, 10, 9, 2, 0, 112, 248, 248, 112, 32, 32, 0, 32, 112, 32, 5,
  10, 10, 9, 2, 0, 80, 248, 248, 112, 32, 32, 0, 32, 112, 32, 9,
  9, 18, 9, 0, 0, 99, 0, 247, 128, 255, 128, 255, 128, 127, 0, 62,
  0, 28, 0, 8, 0, 8, 0, 9, 9, 18, 9, 0, 0, 112, 0, 248,
  0, 252, 0, 126, 0, 63, 128, 126, 0, 252, 0, 248, 0, 112, 0, 9,
  12, 24, 9, 0, 0, 8, 0, 116, 128, 149, 0, 14, 0, 4, 0, 107,
  0, 247, 128, 255, 128, 127, 0, 62, 0, 28, 0, 8, 0, 9, 12, 24,
  9, 0, 0, 16, 0, 41, 0, 82, 0, 156, 0, 32, 0, 88, 0, 124,
  0, 60, 0, 254, 0, 254, 128, 255, 0, 126, 0, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 9, 9, 18, 9, 0, 0, 127,
  0, 247, 128, 231, 128, 247, 128, 247, 128, 247, 128, 247, 128, 227, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 227, 128, 221, 128, 253, 128, 251,
  128, 247, 128, 237, 128, 193, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 227, 128, 221, 128, 253, 128, 243, 128, 253, 128, 221, 128, 227, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 243, 128, 235, 128, 219, 128, 193,
  128, 251, 128, 251, 128, 251, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 193, 128, 223, 128, 223, 128, 195, 128, 253, 128, 253, 128, 195, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 225, 128, 223, 128, 223, 128, 195,
  128, 221, 128, 221, 128, 227, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 193, 128, 253, 128, 251, 128, 251, 128, 247, 128, 247, 128, 247, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 227, 128, 221, 128, 221, 128, 227,
  128, 221, 128, 221, 128, 227, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 225, 128, 221, 128, 221, 128, 225, 128, 253, 128, 253, 128, 227, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 219, 128, 213, 128, 213, 128, 213,
  128, 213, 128, 213, 128, 219, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 128, 128, 136, 128, 152, 128, 136, 128, 136, 128, 136, 128, 128, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 128, 128, 152, 128, 132, 128, 132,
  128, 136, 128, 156, 128, 128, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 128, 128, 152, 128, 132, 128, 136, 128, 132, 128, 152, 128, 128, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 128, 128, 136, 128, 152, 128, 168,
  128, 188, 128, 136, 128, 128, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 128, 128, 156, 128, 144, 128, 152, 128, 132, 128, 152, 128, 128, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 128, 128, 140, 128, 144, 128, 152,
  128, 148, 128, 136, 128, 128, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 128, 128, 156, 128, 132, 128, 136, 128, 136, 128, 136, 128, 128, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 128, 128, 136, 128, 148, 128, 136,
  128, 148, 128, 136, 128, 128, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 128, 128, 136, 128, 148, 128, 140, 128, 132, 128, 136, 128, 128, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 128, 128, 164, 128, 170, 128, 170,
  128, 170, 128, 164, 128, 128, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 247, 128, 231, 128, 247, 128, 247, 128, 247, 128, 247, 128, 247, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 227, 128, 221, 128, 253, 128, 251,
  128, 247, 128, 239, 128, 193, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 227, 128, 221, 128, 253, 128, 243, 128, 253, 128, 221, 128, 227, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 243, 128, 235, 128, 219, 128, 193,
  128, 251, 128, 251, 128, 251, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 193, 128, 223, 128, 223, 128, 195, 128, 253, 128, 253, 128, 195, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 225, 128, 223, 128, 223, 128, 195,
  128, 221, 128, 221, 128, 227, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 193, 128, 253, 128, 251, 128, 251, 128, 247, 128, 247, 128, 247, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 227, 128, 221, 128, 221, 128, 227,
  128, 221, 128, 221, 128, 227, 128, 127, 0, 9, 9, 18, 9, 0, 0, 127,
  0, 225, 128, 221, 128, 221, 128, 225, 128, 253, 128, 253, 128, 227, 128, 127,
  0, 9, 9, 18, 9, 0, 0, 127, 0, 219, 128, 213, 128, 213, 128, 213,
  128, 213, 128, 213, 128, 219, 128, 127, 0, 7, 8, 8, 9, 1, 1, 48,
  24, 12, 254, 254, 12, 24, 48, 255, 255, 255, 7, 5, 5, 9, 1, 1,
  224, 250, 62, 14, 30, 8, 7, 7, 9, 1, 1, 8, 12, 230, 255, 230,
  12, 8, 7, 5, 5, 9, 1, 1, 30, 14, 62, 250, 224, 9, 7, 14,
  9, 0, 0, 48, 0, 28, 0, 31, 0, 255, 128, 31, 0, 28, 0, 48,
  0, 9, 9, 18, 9, 0, 0, 28, 0, 30, 0, 15, 0, 255, 128, 255,
  128, 255, 128, 15, 0, 30, 0, 28, 0, 9, 5, 10, 9, 0, 1, 2,
  0, 3, 0, 255, 128, 3, 0, 2, 0, 9, 7, 14, 9, 0, 0, 4,
  0, 6, 0, 255, 0, 255, 128, 255, 0, 6, 0, 4, 0, 9, 5, 10,
  9, 0, 1, 2, 0, 183, 0, 183, 128, 183, 0, 2, 0, 9, 5, 10,
  9, 0, 1, 2, 0, 171, 0, 171, 128, 171, 0, 2, 0, 9, 5, 10,
  9, 0, 1, 2, 0, 255, 0, 255, 128, 255, 0, 2, 0, 9, 8, 16,
  9, 0, 1, 128, 0, 112, 0, 78, 0, 33, 128, 31, 128, 62, 0, 112,
  0, 128, 0, 9, 8, 16, 9, 0, 1, 128, 0, 112, 0, 62, 0, 31,
  128, 33, 128, 78, 0, 112, 0, 128, 0, 9, 8, 16, 9, 0, 1, 128,
  0, 112, 0, 62, 0, 31, 128, 31, 128, 62, 0, 112, 0, 128, 0, 9,
  7, 14, 9, 0, 0, 132, 0, 134, 0, 255, 0, 255, 128, 127, 0, 6,
  0, 4, 0, 9, 7, 14, 9, 0, 0, 4, 0, 6, 0, 127, 0, 255,
  128, 255, 0, 134, 0, 132, 0, 6, 9, 9, 9, 2, 0, 16, 16, 248,
  248, 252, 248, 248, 16, 16, 8, 9, 9, 9, 0, 1, 4, 4, 254, 254,
  255, 254, 254, 4, 4, 9, 9, 18, 9, 0, 0, 24, 0, 28, 0, 22,
  0, 243, 0, 129, 128, 243, 0, 22, 0, 28, 0, 24, 0, 9, 9, 18,
  9, 0, 0, 24, 0, 28, 0, 26, 0, 249, 0, 192, 128, 249, 0, 26,
  0, 28, 0, 24, 0, 9, 9, 18, 9, 0, 0, 0, 128, 1, 128, 62,
  128, 64, 128, 129, 128, 243, 0, 238, 0, 60, 0, 56, 0, 9, 9, 18,
  9, 0, 0, 56, 0, 60, 0, 238, 0, 243, 0, 129, 128, 64, 128, 62,
  128, 1, 128, 0, 128, 8, 9, 9, 9, 0, 1, 16, 24, 20, 242, 129,
  243, 118, 28, 24, 8, 9, 9, 9, 0, 1, 24, 28, 118, 243, 129, 242,
  20, 24, 16, 9, 7, 14, 9, 0, 2, 4, 0, 250, 0, 129, 0, 64,
  128, 129, 128, 251, 0, 6, 0, 255, 9, 7, 14, 9, 0, 2, 6, 0,
  251, 0, 129, 128, 64, 128, 129, 0, 250, 0, 4, 0, 9, 9, 18, 9,
  0, 1, 28, 0, 127, 0, 251, 128, 1, 128, 0, 128, 1, 128, 251, 128,
  127, 0, 28, 0, 9, 5, 10, 9, 0, 3, 210, 0, 43, 0, 127, 128,
  43, 0, 210, 0, 9, 9, 18, 9, 0, 0, 16, 0, 56, 0, 92, 0,
  236, 0, 116, 0, 60, 0, 2, 128, 1, 128, 3, 128, 9, 5, 10, 9,
  0, 2, 242, 0, 123, 0, 7, 128, 123, 0, 242, 0, 9, 9, 18, 9,
  0, 0, 3, 128, 1, 128, 2, 128, 60, 0, 116, 0, 236, 0, 92, 0,
  56, 0, 16, 0, 9, 9, 18, 9, 0, 0, 16, 0, 24, 0, 28, 0,
  252, 0, 124, 0, 60, 0, 2, 128, 1, 128, 3, 128, 9, 5, 10, 9,
  0, 2, 242, 0, 123, 0, 127, 128, 123, 0, 242, 0, 9, 9, 18, 9,
  0, 0, 3, 128, 1, 128, 2, 128, 60, 0, 124, 0, 252, 0, 28, 0,
  24, 0, 16, 0, 9, 7, 14, 9, 0, 1, 3, 0, 3, 0, 113, 0,
  255, 128, 113, 0, 3, 0, 3, 0, 9, 7, 14, 9, 0, 1, 2, 0,
  115, 0, 121, 0, 255, 128, 121, 0, 115, 0, 2, 0, 9, 5, 10, 9,
  0, 2, 242, 0, 123, 0, 63, 128, 123, 0, 242, 0, 9, 7, 14, 9,
  0, 1, 226, 0, 242, 0, 123, 0, 63, 128, 123, 0, 242, 0, 226, 0,
  9, 7, 14, 9, 0, 1, 20, 0, 10, 0, 253, 0, 0, 128, 253, 0,
  10, 0, 20, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 8, 11, 11, 9, 0, 255,
  193, 99, 99, 85, 85, 73, 85, 85, 99, 99, 193, 8, 11, 11, 9, 1,
  255, 131, 198, 198, 170, 170, 146, 170, 170, 198, 198, 131, 9, 11, 22, 9,
  0, 255, 193, 128, 99, 0, 99, 0, 85, 0, 85, 0, 73, 0, 85, 0,
  85, 0, 99, 0, 99, 0, 193, 128, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 5, 12, 12, 9, 2, 255, 248, 160, 160, 160,
  160, 160, 160, 160, 160, 160, 160, 248, 5, 12, 12, 9, 2, 255, 248, 40,
  40, 40, 40, 40, 40, 40, 40, 40, 40, 248, 3, 10, 10, 9, 3, 0,
  32, 32, 64, 64, 128, 128, 64, 64, 32, 32, 3, 10, 10, 9, 3, 0,
  128, 128, 64, 64, 32, 32, 64, 64, 128, 128, 6, 10, 10, 9, 1, 0,
  36, 36, 72, 72, 144, 144, 72, 72, 36, 36, 6, 10, 10, 9, 2, 0,
  144, 144, 72, 72, 36, 36, 72, 72, 144, 144, 255, 255, 255, 255, 9, 11,
  22, 9, 0, 0, 8, 0, 20, 0, 54, 0, 85, 0, 213, 128, 85, 0,
  85, 0, 85, 0, 85, 0, 85, 0, 85, 0, 9, 11, 22, 9, 0, 255,
  85, 0, 85, 0, 85, 0, 85, 0, 85, 0, 85, 0, 213, 128, 85, 0,
  54, 0, 20, 0, 8, 0, 8, 8, 8, 9, 0, 0, 28, 34, 169, 113,
  33, 1, 34, 28, 8, 8, 8, 9, 0, 0, 56, 68, 149, 142, 132, 128,
  68, 56, 9, 5, 10, 9, 0, 2, 114, 0, 169, 0, 255, 128, 169, 0,
  114, 0, 9, 5, 10, 9, 0, 2, 32, 0, 64, 0, 255, 128, 64, 0,
  32, 0, 9, 5, 10, 9, 0, 2, 2, 0, 1, 0, 255, 128, 1, 0,
  2, 0, 9, 5, 10, 9, 0, 2, 34, 0, 65, 0, 255, 128, 65, 0,
  34, 0, 9, 7, 14, 9, 0, 1, 16, 0, 32, 0, 127, 128, 128, 0,
  127, 128, 32, 0, 16, 0, 9, 7, 14, 9, 0, 1, 4, 0, 2, 0,
  255, 0, 0, 128, 255, 0, 2, 0, 4, 0, 9, 7, 14, 9, 0, 1,
  20, 0, 34, 0, 127, 0, 128, 128, 127, 0, 34, 0, 20, 0, 9, 5,
  10, 9, 0, 2, 32, 128, 64, 128, 255, 128, 64, 128, 32, 128, 9, 5,
  10, 9, 0, 2, 130, 0, 129, 0, 255, 128, 129, 0, 130, 0, 9, 7,
  14, 9, 0, 1, 16, 128, 32, 128, 127, 128, 128, 128, 127, 128, 32, 128,
  16, 128, 9, 7, 14, 9, 0, 1, 132, 0, 130, 0, 255, 0, 128, 128,
  255, 0, 130, 0, 132, 0, 9, 6, 12, 9, 0, 1, 2, 0, 1, 0,
  85, 128, 170, 128, 1, 0, 2, 0
};

/*
  Fontname: -Misc-Fixed-Bold-R-Normal--18-120-100-100-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 9 h=14 x= 4 y=14 dx= 9 dy= 0 ascent=14 len=20
  Font Bounding box     w= 9 h=18 x= 0 y=-4
  Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =14 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_9x18B[3026] U8G_FONT_SECTION("u8g_font_9x18B") = {
  0, 9, 18, 0, 252, 10, 1, 242, 3, 225, 32, 255, 253, 14, 252, 11,
  253, 0, 0, 0, 9, 0, 14, 2, 11, 11, 9, 3, 0, 192, 192, 192,
  192, 192, 192, 192, 0, 0, 192, 192, 5, 4, 4, 9, 2, 7, 216, 216,
  216, 216, 7, 10, 10, 9, 1, 0, 108, 108, 108, 254, 108, 108, 254, 108,
  108, 108, 8, 11, 11, 9, 0, 255, 24, 126, 219, 216, 120, 60, 30, 27,
  219, 126, 24, 8, 10, 10, 9, 0, 0, 115, 222, 222, 108, 24, 24, 54,
  123, 123, 206, 8, 10, 10, 9, 0, 0, 112, 216, 216, 216, 112, 115, 222,
  204, 222, 115, 2, 4, 4, 9, 3, 7, 192, 192, 192, 192, 4, 12, 12,
  9, 2, 255, 48, 96, 96, 192, 192, 192, 192, 192, 192, 96, 96, 48, 4,
  12, 12, 9, 2, 255, 192, 96, 96, 48, 48, 48, 48, 48, 48, 96, 96,
  192, 8, 7, 7, 9, 0, 1, 24, 219, 126, 60, 126, 219, 24, 8, 7,
  7, 9, 0, 1, 24, 24, 24, 255, 24, 24, 24, 3, 4, 4, 9, 3,
  254, 224, 224, 96, 192, 7, 1, 1, 9, 1, 4, 254, 3, 2, 2, 9,
  3, 0, 224, 224, 8, 10, 10, 9, 0, 0, 3, 6, 6, 12, 24, 24,
  48, 96, 96, 192, 7, 10, 10, 9, 1, 0, 56, 108, 198, 198, 198, 198,
  198, 198, 108, 56, 8, 10, 10, 9, 0, 0, 24, 56, 120, 216, 24, 24,
  24, 24, 24, 255, 7, 10, 10, 9, 1, 0, 56, 108, 198, 6, 6, 12,
  24, 48, 96, 254, 7, 10, 10, 9, 1, 0, 254, 6, 12, 24, 56, 12,
  6, 6, 204, 120, 7, 10, 10, 9, 1, 0, 12, 28, 60, 108, 204, 204,
  254, 12, 12, 12, 7, 10, 10, 9, 1, 0, 254, 192, 192, 192, 248, 12,
  6, 6, 204, 120, 7, 10, 10, 9, 1, 0, 60, 96, 192, 192, 248, 204,
  198, 198, 108, 56, 7, 10, 10, 9, 1, 0, 254, 6, 12, 12, 24, 24,
  48, 48, 48, 48, 7, 10, 10, 9, 1, 0, 56, 108, 198, 108, 56, 108,
  198, 198, 108, 56, 7, 10, 10, 9, 1, 0, 56, 108, 198, 198, 110, 62,
  6, 6, 12, 120, 3, 7, 7, 9, 3, 0, 224, 224, 0, 0, 0, 224,
  224, 3, 9, 9, 9, 3, 254, 224, 224, 0, 0, 0, 224, 224, 96, 192,
  6, 9, 9, 9, 1, 0, 12, 24, 48, 96, 192, 96, 48, 24, 12, 7,
  4, 4, 9, 1, 2, 254, 0, 0, 254, 6, 9, 9, 9, 1, 0, 192,
  96, 48, 24, 12, 24, 48, 96, 192, 7, 10, 10, 9, 1, 0, 56, 108,
  198, 6, 12, 24, 48, 48, 0, 48, 9, 10, 20, 9, 0, 0, 62, 0,
  99, 0, 205, 128, 213, 128, 213, 128, 213, 128, 213, 128, 207, 0, 96, 0,
  62, 0, 7, 10, 10, 9, 1, 0, 16, 56, 56, 56, 108, 124, 108, 198,
  198, 198, 7, 10, 10, 9, 1, 0, 252, 198, 198, 198, 252, 198, 198, 198,
  198, 252, 7, 10, 10, 9, 1, 0, 60, 102, 192, 192, 192, 192, 192, 192,
  102, 60, 7, 10, 10, 9, 1, 0, 248, 204, 198, 198, 198, 198, 198, 198,
  204, 248, 7, 10, 10, 9, 1, 0, 254, 192, 192, 192, 248, 192, 192, 192,
  192, 254, 7, 10, 10, 9, 1, 0, 254, 192, 192, 192, 248, 192, 192, 192,
  192, 192, 7, 10, 10, 9, 1, 0, 56, 108, 198, 192, 192, 206, 198, 198,
  108, 56, 7, 10, 10, 9, 1, 0, 198, 198, 198, 198, 254, 198, 198, 198,
  198, 198, 6, 10, 10, 9, 1, 0, 252, 48, 48, 48, 48, 48, 48, 48,
  48, 252, 7, 10, 10, 9, 1, 0, 30, 12, 12, 12, 12, 12, 12, 204,
  204, 120, 7, 10, 10, 9, 1, 0, 198, 204, 216, 240, 224, 240, 216, 204,
  198, 198, 7, 10, 10, 9, 1, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 254, 7, 10, 10, 9, 1, 0, 198, 238, 254, 214, 198, 198, 198, 198,
  198, 198, 7, 10, 10, 9, 1, 0, 198, 198, 230, 246, 222, 206, 198, 198,
  198, 198, 7, 10, 10, 9, 1, 0, 124, 198, 198, 198, 198, 198, 198, 198,
  198, 124, 7, 10, 10, 9, 1, 0, 248, 204, 198, 198, 204, 248, 192, 192,
  192, 192, 8, 11, 11, 9, 1, 255, 56, 108, 198, 198, 198, 198, 198, 222,
  108, 62, 3, 7, 10, 10, 9, 1, 0, 252, 198, 198, 198, 198, 252, 216,
  204, 198, 198, 7, 10, 10, 9, 1, 0, 124, 198, 192, 192, 124, 6, 6,
  6, 198, 124, 6, 10, 10, 9, 1, 0, 252, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 7, 10, 10, 9, 1, 0, 198, 198, 198, 198, 198, 198, 198,
  198, 108, 56, 7, 10, 10, 9, 1, 0, 198, 198, 198, 108, 108, 108, 56,
  56, 56, 16, 7, 10, 10, 9, 1, 0, 198, 198, 198, 198, 214, 214, 214,
  254, 238, 68, 7, 10, 10, 9, 1, 0, 198, 198, 108, 56, 16, 16, 56,
  108, 198, 198, 8, 10, 10, 9, 0, 0, 195, 195, 102, 60, 24, 24, 24,
  24, 24, 24, 7, 10, 10, 9, 1, 0, 254, 6, 6, 12, 24, 48, 96,
  192, 192, 254, 5, 12, 12, 9, 2, 255, 248, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 248, 8, 10, 10, 9, 0, 0, 192, 96, 96, 48, 24,
  24, 12, 6, 6, 3, 4, 12, 12, 9, 2, 255, 240, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 240, 8, 4, 4, 9, 0, 6, 24, 60, 102,
  195, 8, 1, 1, 9, 0, 255, 255, 4, 3, 3, 9, 2, 10, 192, 96,
  48, 7, 7, 7, 9, 1, 0, 124, 6, 6, 126, 198, 198, 126, 7, 10,
  10, 9, 1, 0, 192, 192, 192, 252, 198, 198, 198, 198, 198, 252, 7, 7,
  7, 9, 1, 0, 124, 198, 192, 192, 192, 198, 124, 7, 10, 10, 9, 1,
  0, 6, 6, 6, 126, 198, 198, 198, 198, 198, 126, 7, 7, 7, 9, 1,
  0, 124, 198, 198, 254, 192, 198, 124, 6, 10, 10, 9, 1, 0, 56, 108,
  108, 96, 96, 240, 96, 96, 96, 96, 7, 10, 10, 9, 1, 253, 126, 204,
  204, 204, 120, 192, 124, 198, 198, 124, 7, 10, 10, 9, 1, 0, 192, 192,
  192, 252, 198, 198, 198, 198, 198, 198, 6, 10, 10, 9, 1, 0, 48, 48,
  0, 240, 48, 48, 48, 48, 48, 252, 5, 13, 13, 9, 2, 253, 24, 24,
  0, 56, 24, 24, 24, 24, 24, 24, 216, 216, 112, 7, 10, 10, 9, 1,
  0, 192, 192, 192, 204, 216, 240, 240, 216, 204, 198, 6, 10, 10, 9, 1,
  0, 240, 48, 48, 48, 48, 48, 48, 48, 48, 252, 8, 7, 7, 9, 0,
  0, 254, 219, 219, 219, 219, 219, 195, 7, 7, 7, 9, 1, 0, 220, 230,
  198, 198, 198, 198, 198, 7, 7, 7, 9, 1, 0, 56, 108, 198, 198, 198,
  108, 56, 7, 10, 10, 9, 1, 253, 248, 204, 198, 198, 198, 204, 248, 192,
  192, 192, 7, 10, 10, 9, 1, 253, 62, 102, 198, 198, 198, 102, 62, 6,
  6, 6, 7, 7, 7, 9, 1, 0, 220, 118, 96, 96, 96, 96, 96, 7,
  7, 7, 9, 1, 0, 124, 198, 192, 124, 6, 198, 124, 7, 9, 9, 9,
  1, 0, 48, 48, 252, 48, 48, 48, 48, 54, 28, 7, 7, 7, 9, 1,
  0, 198, 198, 198, 198, 198, 198, 126, 7, 7, 7, 9, 1, 0, 198, 198,
  108, 108, 56, 56, 16, 8, 7, 7, 9, 0, 0, 195, 195, 219, 219, 219,
  255, 102, 7, 7, 7, 9, 1, 0, 198, 108, 56, 16, 56, 108, 198, 7,
  10, 10, 9, 1, 253, 198, 198, 108, 108, 108, 56, 56, 48, 176, 96, 6,
  7, 7, 9, 1, 0, 252, 12, 24, 48, 96, 192, 252, 6, 11, 11, 9,
  1, 0, 60, 96, 96, 96, 96, 192, 96, 96, 96, 96, 60, 2, 12, 12,
  9, 3, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 6,
  11, 11, 9, 1, 0, 224, 48, 48, 48, 48, 28, 48, 48, 48, 48, 224,
  8, 3, 3, 9, 0, 7, 115, 219, 206, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 9, 0, 14,
  2, 10, 10, 9, 4, 0, 192, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  7, 8, 8, 9, 1, 0, 4, 124, 206, 208, 208, 230, 124, 64, 8, 10,
  10, 9, 0, 255, 30, 51, 48, 48, 124, 48, 48, 248, 191, 224, 7, 7,
  7, 9, 1, 2, 198, 254, 108, 68, 108, 254, 198, 8, 10, 10, 9, 0,
  0, 195, 195, 102, 60, 126, 24, 126, 24, 24, 24, 2, 11, 11, 9, 3,
  255, 192, 192, 192, 192, 192, 0, 192, 192, 192, 192, 192, 6, 11, 11, 9,
  1, 255, 120, 204, 192, 120, 204, 204, 204, 120, 12, 204, 120, 5, 2, 2,
  9, 2, 11, 216, 216, 8, 11, 11, 9, 0, 0, 60, 126, 195, 189, 165,
  161, 165, 189, 195, 126, 60, 5, 7, 7, 9, 1, 3, 112, 24, 120, 216,
  120, 0, 248, 8, 8, 8, 9, 0, 1, 27, 54, 108, 216, 216, 108, 54,
  27, 7, 5, 5, 9, 1, 2, 254, 254, 6, 6, 6, 6, 1, 1, 9,
  1, 4, 252, 8, 11, 11, 9, 0, 0, 60, 126, 195, 189, 165, 189, 169,
  173, 195, 126, 60, 6, 2, 2, 9, 1, 9, 252, 252, 5, 4, 4, 9,
  1, 8, 112, 216, 216, 112, 6, 9, 9, 9, 1, 1, 48, 48, 48, 252,
  48, 48, 48, 0, 252, 5, 6, 6, 9, 1, 4, 112, 216, 24, 48, 96,
  248, 5, 6, 6, 9, 1, 4, 112, 216, 48, 24, 216, 112, 4, 3, 3,
  9, 2, 10, 48, 96, 192, 7, 9, 9, 9, 1, 254, 198, 198, 198, 198,
  206, 222, 246, 192, 192, 7, 10, 10, 9, 1, 0, 126, 246, 246, 246, 118,
  54, 54, 54, 54, 54, 3, 2, 2, 9, 3, 4, 224, 224, 6, 3, 3,
  9, 1, 253, 24, 204, 120, 4, 6, 6, 9, 1, 4, 96, 224, 96, 96,
  96, 240, 5, 7, 7, 9, 1, 3, 112, 216, 216, 216, 112, 0, 248, 8,
  8, 8, 9, 0, 1, 216, 108, 54, 27, 27, 54, 108, 216, 8, 11, 11,
  9, 0, 0, 96, 224, 96, 96, 97, 99, 247, 15, 27, 31, 3, 8, 11,
  11, 9, 0, 0, 96, 224, 96, 96, 110, 115, 243, 6, 12, 24, 31, 8,
  11, 11, 9, 0, 0, 112, 152, 24, 48, 25, 155, 119, 15, 27, 31, 3,
  7, 10, 10, 9, 1, 0, 24, 24, 0, 24, 48, 96, 192, 198, 198, 124,
  7, 14, 14, 9, 1, 0, 96, 48, 24, 0, 16, 56, 56, 56, 108, 124,
  108, 198, 198, 198, 7, 14, 14, 9, 1, 0, 12, 24, 48, 0, 16, 56,
  56, 56, 108, 124, 108, 198, 198, 198, 7, 14, 14, 9, 1, 0, 16, 56,
  108, 0, 16, 56, 56, 56, 108, 124, 108, 198, 198, 198, 7, 13, 13, 9,
  1, 0, 118, 220, 0, 16, 56, 56, 56, 108, 124, 108, 198, 198, 198, 7,
  13, 13, 9, 1, 0, 108, 108, 0, 16, 56, 56, 56, 108, 124, 108, 198,
  198, 198, 7, 14, 14, 9, 1, 0, 56, 108, 108, 56, 16, 56, 56, 56,
  108, 124, 108, 198, 198, 198, 7, 10, 10, 9, 1, 0, 62, 60, 108, 108,
  110, 252, 204, 204, 204, 206, 7, 14, 14, 9, 1, 252, 60, 102, 192, 192,
  192, 192, 192, 192, 102, 60, 24, 12, 108, 56, 7, 14, 14, 9, 1, 0,
  96, 48, 24, 0, 254, 192, 192, 192, 248, 192, 192, 192, 192, 254, 7, 14,
  14, 9, 1, 0, 12, 24, 48, 0, 254, 192, 192, 192, 248, 192, 192, 192,
  192, 254, 7, 14, 14, 9, 1, 0, 16, 56, 108, 0, 254, 192, 192, 192,
  248, 192, 192, 192, 192, 254, 7, 13, 13, 9, 1, 0, 108, 108, 0, 254,
  192, 192, 192, 248, 192, 192, 192, 192, 254, 6, 14, 14, 9, 1, 0, 96,
  48, 24, 0, 252, 48, 48, 48, 48, 48, 48, 48, 48, 252, 6, 14, 14,
  9, 1, 0, 12, 24, 48, 0, 252, 48, 48, 48, 48, 48, 48, 48, 48,
  252, 6, 14, 14, 9, 1, 0, 16, 56, 108, 0, 252, 48, 48, 48, 48,
  48, 48, 48, 48, 252, 6, 13, 13, 9, 1, 0, 108, 108, 0, 252, 48,
  48, 48, 48, 48, 48, 48, 48, 252, 8, 10, 10, 9, 0, 0, 124, 102,
  99, 99, 243, 99, 99, 99, 102, 124, 7, 13, 13, 9, 1, 0, 118, 220,
  0, 198, 198, 230, 246, 222, 206, 198, 198, 198, 198, 7, 14, 14, 9, 1,
  0, 96, 48, 24, 0, 124, 198, 198, 198, 198, 198, 198, 198, 198, 124, 7,
  14, 14, 9, 1, 0, 12, 24, 48, 0, 124, 198, 198, 198, 198, 198, 198,
  198, 198, 124, 7, 14, 14, 9, 1, 0, 16, 56, 108, 0, 124, 198, 198,
  198, 198, 198, 198, 198, 198, 124, 7, 13, 13, 9, 1, 0, 118, 220, 0,
  124, 198, 198, 198, 198, 198, 198, 198, 198, 124, 7, 13, 13, 9, 1, 0,
  108, 108, 0, 124, 198, 198, 198, 198, 198, 198, 198, 198, 124, 8, 7, 7,
  9, 0, 1, 195, 102, 60, 24, 60, 102, 195, 7, 12, 12, 9, 1, 255,
  6, 126, 206, 206, 222, 222, 246, 246, 230, 230, 252, 192, 7, 14, 14, 9,
  1, 0, 96, 48, 24, 0, 198, 198, 198, 198, 198, 198, 198, 198, 108, 56,
  7, 14, 14, 9, 1, 0, 12, 24, 48, 0, 198, 198, 198, 198, 198, 198,
  198, 198, 108, 56, 7, 14, 14, 9, 1, 0, 16, 56, 108, 0, 198, 198,
  198, 198, 198, 198, 198, 198, 108, 56, 7, 13, 13, 9, 1, 0, 108, 108,
  0, 198, 198, 198, 198, 198, 198, 198, 198, 108, 56, 8, 14, 14, 9, 0,
  0, 12, 24, 48, 0, 195, 195, 102, 60, 24, 24, 24, 24, 24, 24, 7,
  10, 10, 9, 1, 0, 192, 192, 252, 198, 198, 198, 252, 192, 192, 192, 7,
  10, 10, 9, 1, 0, 60, 102, 102, 102, 236, 102, 102, 102, 102, 108, 7,
  11, 11, 9, 1, 0, 96, 48, 24, 0, 124, 6, 6, 126, 198, 198, 126,
  7, 11, 11, 9, 1, 0, 12, 24, 48, 0, 124, 6, 6, 126, 198, 198,
  126, 7, 11, 11, 9, 1, 0, 16, 56, 108, 0, 124, 6, 6, 126, 198,
  198, 126, 7, 10, 10, 9, 1, 0, 118, 220, 0, 124, 6, 6, 126, 198,
  198, 126, 7, 10, 10, 9, 1, 0, 108, 108, 0, 124, 6, 6, 126, 198,
  198, 126, 7, 11, 11, 9, 1, 0, 56, 108, 56, 0, 124, 6, 6, 126,
  198, 198, 126, 8, 7, 7, 9, 0, 0, 118, 27, 27, 127, 216, 219, 118,
  7, 11, 11, 9, 1, 252, 124, 198, 192, 192, 192, 198, 124, 24, 12, 108,
  56, 7, 11, 11, 9, 1, 0, 96, 48, 24, 0, 124, 198, 198, 254, 192,
  198, 124, 7, 11, 11, 9, 1, 0, 12, 24, 48, 0, 124, 198, 198, 254,
  192, 198, 124, 7, 11, 11, 9, 1, 0, 16, 56, 108, 0, 124, 198, 198,
  254, 192, 198, 124, 7, 10, 10, 9, 1, 0, 108, 108, 0, 124, 198, 198,
  254, 192, 198, 124, 6, 11, 11, 9, 1, 0, 192, 96, 48, 0, 240, 48,
  48, 48, 48, 48, 252, 6, 11, 11, 9, 1, 0, 12, 24, 48, 0, 240,
  48, 48, 48, 48, 48, 252, 6, 11, 11, 9, 1, 0, 32, 112, 216, 0,
  240, 48, 48, 48, 48, 48, 252, 6, 10, 10, 9, 1, 0, 108, 108, 0,
  240, 48, 48, 48, 48, 48, 252, 7, 11, 11, 9, 1, 0, 108, 56, 56,
  108, 12, 126, 198, 198, 198, 198, 124, 7, 10, 10, 9, 1, 0, 118, 220,
  0, 220, 230, 198, 198, 198, 198, 198, 7, 11, 11, 9, 1, 0, 96, 48,
  24, 0, 56, 108, 198, 198, 198, 108, 56, 7, 11, 11, 9, 1, 0, 12,
  24, 48, 0, 56, 108, 198, 198, 198, 108, 56, 7, 11, 11, 9, 1, 0,
  16, 56, 108, 0, 56, 108, 198, 198, 198, 108, 56, 7, 10, 10, 9, 1,
  0, 118, 220, 0, 56, 108, 198, 198, 198, 108, 56, 7, 10, 10, 9, 1,
  0, 108, 108, 0, 56, 108, 198, 198, 198, 108, 56, 8, 7, 7, 9, 0,
  1, 24, 24, 0, 255, 0, 24, 24, 8, 9, 9, 9, 0, 255, 1, 63,
  102, 207, 219, 243, 102, 252, 128, 7, 11, 11, 9, 1, 0, 96, 48, 24,
  0, 198, 198, 198, 198, 198, 198, 126, 7, 11, 11, 9, 1, 0, 12, 24,
  48, 0, 198, 198, 198, 198, 198, 198, 126, 7, 11, 11, 9, 1, 0, 16,
  56, 108, 0, 198, 198, 198, 198, 198, 198, 126, 7, 10, 10, 9, 1, 0,
  108, 108, 0, 198, 198, 198, 198, 198, 198, 126, 7, 14, 14, 9, 1, 253,
  12, 24, 48, 0, 198, 198, 108, 108, 108, 56, 56, 48, 176, 96, 7, 11,
  11, 9, 1, 254, 192, 192, 248, 204, 198, 198, 198, 204, 248, 192, 192, 7,
  13, 13, 9, 1, 253, 108, 108, 0, 198, 198, 108, 108, 108, 56, 56, 48,
  176, 96
};

/*
  Fontname: -Misc-Fixed-Bold-R-Normal--18-120-100-100-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 9 h=13 x= 3 y=14 dx= 9 dy= 0 ascent=14 len=20
  Font Bounding box     w= 9 h=18 x= 0 y=-4
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =14 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_9x18Br[1434] U8G_FONT_SECTION("u8g_font_9x18Br") = {
  0, 9, 18, 0, 252, 10, 1, 242, 3, 225, 32, 127, 253, 14, 253, 11,
  253, 0, 0, 0, 9, 0, 14, 2, 11, 11, 9, 3, 0, 192, 192, 192,
  192, 192, 192, 192, 0, 0, 192, 192, 5, 4, 4, 9, 2, 7, 216, 216,
  216, 216, 7, 10, 10, 9, 1, 0, 108, 108, 108, 254, 108, 108, 254, 108,
  108, 108, 8, 11, 11, 9, 0, 255, 24, 126, 219, 216, 120, 60, 30, 27,
  219, 126, 24, 8, 10, 10, 9, 0, 0, 115, 222, 222, 108, 24, 24, 54,
  123, 123, 206, 8, 10, 10, 9, 0, 0, 112, 216, 216, 216, 112, 115, 222,
  204, 222, 115, 2, 4, 4, 9, 3, 7, 192, 192, 192, 192, 4, 12, 12,
  9, 2, 255, 48, 96, 96, 192, 192, 192, 192, 192, 192, 96, 96, 48, 4,
  12, 12, 9, 2, 255, 192, 96, 96, 48, 48, 48, 48, 48, 48, 96, 96,
  192, 8, 7, 7, 9, 0, 1, 24, 219, 126, 60, 126, 219, 24, 8, 7,
  7, 9, 0, 1, 24, 24, 24, 255, 24, 24, 24, 3, 4, 4, 9, 3,
  254, 224, 224, 96, 192, 7, 1, 1, 9, 1, 4, 254, 3, 2, 2, 9,
  3, 0, 224, 224, 8, 10, 10, 9, 0, 0, 3, 6, 6, 12, 24, 24,
  48, 96, 96, 192, 7, 10, 10, 9, 1, 0, 56, 108, 198, 198, 198, 198,
  198, 198, 108, 56, 8, 10, 10, 9, 0, 0, 24, 56, 120, 216, 24, 24,
  24, 24, 24, 255, 7, 10, 10, 9, 1, 0, 56, 108, 198, 6, 6, 12,
  24, 48, 96, 254, 7, 10, 10, 9, 1, 0, 254, 6, 12, 24, 56, 12,
  6, 6, 204, 120, 7, 10, 10, 9, 1, 0, 12, 28, 60, 108, 204, 204,
  254, 12, 12, 12, 7, 10, 10, 9, 1, 0, 254, 192, 192, 192, 248, 12,
  6, 6, 204, 120, 7, 10, 10, 9, 1, 0, 60, 96, 192, 192, 248, 204,
  198, 198, 108, 56, 7, 10, 10, 9, 1, 0, 254, 6, 12, 12, 24, 24,
  48, 48, 48, 48, 7, 10, 10, 9, 1, 0, 56, 108, 198, 108, 56, 108,
  198, 198, 108, 56, 7, 10, 10, 9, 1, 0, 56, 108, 198, 198, 110, 62,
  6, 6, 12, 120, 3, 7, 7, 9, 3, 0, 224, 224, 0, 0, 0, 224,
  224, 3, 9, 9, 9, 3, 254, 224, 224, 0, 0, 0, 224, 224, 96, 192,
  6, 9, 9, 9, 1, 0, 12, 24, 48, 96, 192, 96, 48, 24, 12, 7,
  4, 4, 9, 1, 2, 254, 0, 0, 254, 6, 9, 9, 9, 1, 0, 192,
  96, 48, 24, 12, 24, 48, 96, 192, 7, 10, 10, 9, 1, 0, 56, 108,
  198, 6, 12, 24, 48, 48, 0, 48, 9, 10, 20, 9, 0, 0, 62, 0,
  99, 0, 205, 128, 213, 128, 213, 128, 213, 128, 213, 128, 207, 0, 96, 0,
  62, 0, 7, 10, 10, 9, 1, 0, 16, 56, 56, 56, 108, 124, 108, 198,
  198, 198, 7, 10, 10, 9, 1, 0, 252, 198, 198, 198, 252, 198, 198, 198,
  198, 252, 7, 10, 10, 9, 1, 0, 60, 102, 192, 192, 192, 192, 192, 192,
  102, 60, 7, 10, 10, 9, 1, 0, 248, 204, 198, 198, 198, 198, 198, 198,
  204, 248, 7, 10, 10, 9, 1, 0, 254, 192, 192, 192, 248, 192, 192, 192,
  192, 254, 7, 10, 10, 9, 1, 0, 254, 192, 192, 192, 248, 192, 192, 192,
  192, 192, 7, 10, 10, 9, 1, 0, 56, 108, 198, 192, 192, 206, 198, 198,
  108, 56, 7, 10, 10, 9, 1, 0, 198, 198, 198, 198, 254, 198, 198, 198,
  198, 198, 6, 10, 10, 9, 1, 0, 252, 48, 48, 48, 48, 48, 48, 48,
  48, 252, 7, 10, 10, 9, 1, 0, 30, 12, 12, 12, 12, 12, 12, 204,
  204, 120, 7, 10, 10, 9, 1, 0, 198, 204, 216, 240, 224, 240, 216, 204,
  198, 198, 7, 10, 10, 9, 1, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 254, 7, 10, 10, 9, 1, 0, 198, 238, 254, 214, 198, 198, 198, 198,
  198, 198, 7, 10, 10, 9, 1, 0, 198, 198, 230, 246, 222, 206, 198, 198,
  198, 198, 7, 10, 10, 9, 1, 0, 124, 198, 198, 198, 198, 198, 198, 198,
  198, 124, 7, 10, 10, 9, 1, 0, 248, 204, 198, 198, 204, 248, 192, 192,
  192, 192, 8, 11, 11, 9, 1, 255, 56, 108, 198, 198, 198, 198, 198, 222,
  108, 62, 3, 7, 10, 10, 9, 1, 0, 252, 198, 198, 198, 198, 252, 216,
  204, 198, 198, 7, 10, 10, 9, 1, 0, 124, 198, 192, 192, 124, 6, 6,
  6, 198, 124, 6, 10, 10, 9, 1, 0, 252, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 7, 10, 10, 9, 1, 0, 198, 198, 198, 198, 198, 198, 198,
  198, 108, 56, 7, 10, 10, 9, 1, 0, 198, 198, 198, 108, 108, 108, 56,
  56, 56, 16, 7, 10, 10, 9, 1, 0, 198, 198, 198, 198, 214, 214, 214,
  254, 238, 68, 7, 10, 10, 9, 1, 0, 198, 198, 108, 56, 16, 16, 56,
  108, 198, 198, 8, 10, 10, 9, 0, 0, 195, 195, 102, 60, 24, 24, 24,
  24, 24, 24, 7, 10, 10, 9, 1, 0, 254, 6, 6, 12, 24, 48, 96,
  192, 192, 254, 5, 12, 12, 9, 2, 255, 248, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 248, 8, 10, 10, 9, 0, 0, 192, 96, 96, 48, 24,
  24, 12, 6, 6, 3, 4, 12, 12, 9, 2, 255, 240, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 240, 8, 4, 4, 9, 0, 6, 24, 60, 102,
  195, 8, 1, 1, 9, 0, 255, 255, 4, 3, 3, 9, 2, 10, 192, 96,
  48, 7, 7, 7, 9, 1, 0, 124, 6, 6, 126, 198, 198, 126, 7, 10,
  10, 9, 1, 0, 192, 192, 192, 252, 198, 198, 198, 198, 198, 252, 7, 7,
  7, 9, 1, 0, 124, 198, 192, 192, 192, 198, 124, 7, 10, 10, 9, 1,
  0, 6, 6, 6, 126, 198, 198, 198, 198, 198, 126, 7, 7, 7, 9, 1,
  0, 124, 198, 198, 254, 192, 198, 124, 6, 10, 10, 9, 1, 0, 56, 108,
  108, 96, 96, 240, 96, 96, 96, 96, 7, 10, 10, 9, 1, 253, 126, 204,
  204, 204, 120, 192, 124, 198, 198, 124, 7, 10, 10, 9, 1, 0, 192, 192,
  192, 252, 198, 198, 198, 198, 198, 198, 6, 10, 10, 9, 1, 0, 48, 48,
  0, 240, 48, 48, 48, 48, 48, 252, 5, 13, 13, 9, 2, 253, 24, 24,
  0, 56, 24, 24, 24, 24, 24, 24, 216, 216, 112, 7, 10, 10, 9, 1,
  0, 192, 192, 192, 204, 216, 240, 240, 216, 204, 198, 6, 10, 10, 9, 1,
  0, 240, 48, 48, 48, 48, 48, 48, 48, 48, 252, 8, 7, 7, 9, 0,
  0, 254, 219, 219, 219, 219, 219, 195, 7, 7, 7, 9, 1, 0, 220, 230,
  198, 198, 198, 198, 198, 7, 7, 7, 9, 1, 0, 56, 108, 198, 198, 198,
  108, 56, 7, 10, 10, 9, 1, 253, 248, 204, 198, 198, 198, 204, 248, 192,
  192, 192, 7, 10, 10, 9, 1, 253, 62, 102, 198, 198, 198, 102, 62, 6,
  6, 6, 7, 7, 7, 9, 1, 0, 220, 118, 96, 96, 96, 96, 96, 7,
  7, 7, 9, 1, 0, 124, 198, 192, 124, 6, 198, 124, 7, 9, 9, 9,
  1, 0, 48, 48, 252, 48, 48, 48, 48, 54, 28, 7, 7, 7, 9, 1,
  0, 198, 198, 198, 198, 198, 198, 126, 7, 7, 7, 9, 1, 0, 198, 198,
  108, 108, 56, 56, 16, 8, 7, 7, 9, 0, 0, 195, 195, 219, 219, 219,
  255, 102, 7, 7, 7, 9, 1, 0, 198, 108, 56, 16, 56, 108, 198, 7,
  10, 10, 9, 1, 253, 198, 198, 108, 108, 108, 56, 56, 48, 176, 96, 6,
  7, 7, 9, 1, 0, 252, 12, 24, 48, 96, 192, 252, 6, 11, 11, 9,
  1, 0, 60, 96, 96, 96, 96, 192, 96, 96, 96, 96, 60, 2, 12, 12,
  9, 3, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 6,
  11, 11, 9, 1, 0, 224, 48, 48, 48, 48, 28, 48, 48, 48, 48, 224,
  8, 3, 3, 9, 0, 7, 115, 219, 206, 255
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--18-120-100-100-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 8 h=14 x= 4 y=14 dx= 9 dy= 0 ascent=14 len=14
  Font Bounding box     w= 9 h=18 x= 0 y=-4
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =14 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_9x18[3011] U8G_FONT_SECTION("u8g_font_9x18") = {
  0, 9, 18, 0, 252, 10, 1, 232, 3, 215, 32, 255, 253, 14, 253, 11,
  253, 0, 0, 0, 9, 0, 14, 1, 11, 11, 9, 4, 0, 128, 128, 128,
  128, 128, 128, 128, 0, 0, 128, 128, 4, 4, 4, 9, 3, 7, 144, 144,
  144, 144, 8, 10, 10, 9, 0, 0, 36, 36, 36, 255, 36, 36, 255, 36,
  36, 36, 7, 11, 11, 9, 1, 255, 16, 124, 146, 144, 80, 56, 20, 18,
  146, 124, 16, 7, 10, 10, 9, 1, 0, 66, 164, 164, 72, 16, 16, 36,
  74, 74, 132, 7, 10, 10, 9, 1, 0, 96, 144, 144, 144, 96, 98, 148,
  136, 148, 98, 1, 4, 4, 9, 4, 7, 128, 128, 128, 128, 3, 12, 12,
  9, 3, 255, 32, 64, 64, 128, 128, 128, 128, 128, 128, 64, 64, 32, 3,
  12, 12, 9, 3, 255, 128, 64, 64, 32, 32, 32, 32, 32, 32, 64, 64,
  128, 7, 7, 7, 9, 1, 3, 16, 146, 84, 56, 84, 146, 16, 7, 7,
  7, 9, 1, 1, 16, 16, 16, 254, 16, 16, 16, 2, 4, 4, 9, 4,
  254, 192, 192, 64, 128, 7, 1, 1, 9, 1, 4, 254, 2, 2, 2, 9,
  4, 0, 192, 192, 7, 10, 10, 9, 1, 0, 2, 4, 4, 8, 16, 16,
  32, 64, 64, 128, 7, 10, 10, 9, 1, 0, 56, 68, 130, 130, 130, 130,
  130, 130, 68, 56, 7, 10, 10, 9, 1, 0, 16, 48, 80, 144, 16, 16,
  16, 16, 16, 254, 7, 10, 10, 9, 1, 0, 56, 68, 130, 2, 4, 8,
  16, 32, 64, 254, 7, 10, 10, 9, 1, 0, 254, 2, 4, 8, 24, 4,
  2, 2, 132, 120, 7, 10, 10, 9, 1, 0, 4, 12, 20, 36, 68, 132,
  254, 4, 4, 4, 7, 10, 10, 9, 1, 0, 254, 128, 128, 128, 248, 4,
  2, 2, 132, 120, 7, 10, 10, 9, 1, 0, 60, 64, 128, 128, 184, 196,
  130, 130, 68, 56, 7, 10, 10, 9, 1, 0, 254, 2, 4, 4, 8, 8,
  16, 16, 16, 16, 7, 10, 10, 9, 1, 0, 56, 68, 130, 68, 56, 68,
  130, 130, 68, 56, 7, 10, 10, 9, 1, 0, 56, 68, 130, 130, 70, 58,
  2, 2, 4, 120, 2, 7, 7, 9, 4, 0, 192, 192, 0, 0, 0, 192,
  192, 2, 9, 9, 9, 4, 254, 192, 192, 0, 0, 0, 192, 192, 64, 128,
  5, 9, 9, 9, 2, 0, 8, 16, 32, 64, 128, 64, 32, 16, 8, 7,
  4, 4, 9, 1, 2, 254, 0, 0, 254, 5, 9, 9, 9, 2, 0, 128,
  64, 32, 16, 8, 16, 32, 64, 128, 7, 10, 10, 9, 1, 0, 56, 68,
  130, 2, 4, 8, 16, 16, 0, 16, 7, 10, 10, 9, 1, 0, 56, 68,
  154, 170, 170, 170, 170, 156, 64, 60, 7, 10, 10, 9, 1, 0, 16, 40,
  40, 40, 68, 124, 68, 130, 130, 130, 7, 10, 10, 9, 1, 0, 248, 132,
  130, 132, 248, 132, 130, 130, 132, 248, 7, 10, 10, 9, 1, 0, 60, 66,
  128, 128, 128, 128, 128, 128, 66, 60, 7, 10, 10, 9, 1, 0, 248, 132,
  130, 130, 130, 130, 130, 130, 132, 248, 7, 10, 10, 9, 1, 0, 254, 128,
  128, 128, 248, 128, 128, 128, 128, 254, 7, 10, 10, 9, 1, 0, 254, 128,
  128, 128, 248, 128, 128, 128, 128, 128, 7, 10, 10, 9, 1, 0, 56, 68,
  130, 128, 128, 142, 130, 130, 68, 56, 7, 10, 10, 9, 1, 0, 130, 130,
  130, 130, 254, 130, 130, 130, 130, 130, 5, 10, 10, 9, 2, 0, 248, 32,
  32, 32, 32, 32, 32, 32, 32, 248, 7, 10, 10, 9, 1, 0, 62, 8,
  8, 8, 8, 8, 8, 136, 136, 112, 7, 10, 10, 9, 1, 0, 130, 132,
  136, 144, 160, 208, 136, 132, 130, 130, 7, 10, 10, 9, 1, 0, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 254, 7, 10, 10, 9, 1, 0, 130, 130,
  198, 170, 146, 130, 130, 130, 130, 130, 7, 10, 10, 9, 1, 0, 130, 130,
  194, 162, 146, 138, 134, 130, 130, 130, 7, 10, 10, 9, 1, 0, 124, 130,
  130, 130, 130, 130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 0, 248, 132,
  130, 130, 132, 248, 128, 128, 128, 128, 8, 11, 11, 9, 1, 255, 56, 68,
  130, 130, 130, 130, 130, 138, 68, 58, 1, 7, 10, 10, 9, 1, 0, 248,
  132, 130, 130, 132, 248, 144, 136, 132, 130, 7, 10, 10, 9, 1, 0, 124,
  130, 128, 128, 124, 2, 2, 2, 130, 124, 7, 10, 10, 9, 1, 0, 254,
  16, 16, 16, 16, 16, 16, 16, 16, 16, 7, 10, 10, 9, 1, 0, 130,
  130, 130, 130, 130, 130, 130, 130, 68, 56, 7, 10, 10, 9, 1, 0, 130,
  130, 130, 68, 68, 68, 40, 40, 40, 16, 7, 10, 10, 9, 1, 0, 130,
  130, 130, 130, 146, 146, 146, 146, 170, 68, 7, 10, 10, 9, 1, 0, 130,
  130, 68, 40, 16, 16, 40, 68, 130, 130, 7, 10, 10, 9, 1, 0, 130,
  130, 68, 40, 16, 16, 16, 16, 16, 16, 7, 10, 10, 9, 1, 0, 254,
  2, 4, 8, 16, 32, 64, 128, 128, 254, 4, 12, 12, 9, 3, 255, 240,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 240, 7, 10, 10, 9, 1,
  0, 128, 64, 64, 32, 16, 16, 8, 4, 4, 2, 4, 12, 12, 9, 2,
  255, 240, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 240, 7, 4, 4,
  9, 1, 6, 16, 40, 68, 130, 8, 1, 1, 9, 0, 255, 255, 3, 3,
  3, 9, 3, 10, 128, 64, 32, 7, 7, 7, 9, 1, 0, 124, 2, 2,
  126, 130, 134, 122, 7, 10, 10, 9, 1, 0, 128, 128, 128, 188, 194, 130,
  130, 130, 194, 188, 7, 7, 7, 9, 1, 0, 124, 130, 128, 128, 128, 130,
  124, 7, 10, 10, 9, 1, 0, 2, 2, 2, 122, 134, 130, 130, 130, 134,
  122, 7, 7, 7, 9, 1, 0, 124, 130, 130, 254, 128, 130, 124, 7, 10,
  10, 9, 1, 0, 28, 34, 34, 32, 32, 248, 32, 32, 32, 32, 7, 10,
  10, 9, 1, 253, 122, 132, 132, 132, 120, 128, 124, 130, 130, 124, 7, 10,
  10, 9, 1, 0, 128, 128, 128, 188, 194, 130, 130, 130, 130, 130, 5, 10,
  10, 9, 2, 0, 96, 0, 0, 224, 32, 32, 32, 32, 32, 248, 5, 13,
  13, 9, 2, 253, 24, 0, 0, 56, 8, 8, 8, 8, 8, 8, 136, 136,
  112, 7, 10, 10, 9, 1, 0, 128, 128, 128, 132, 136, 144, 176, 200, 132,
  130, 5, 10, 10, 9, 2, 0, 224, 32, 32, 32, 32, 32, 32, 32, 32,
  248, 7, 7, 7, 9, 1, 0, 236, 146, 146, 146, 146, 146, 130, 7, 7,
  7, 9, 1, 0, 188, 194, 130, 130, 130, 130, 130, 7, 7, 7, 9, 1,
  0, 124, 130, 130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 253, 184, 196,
  130, 130, 130, 196, 184, 128, 128, 128, 7, 10, 10, 9, 1, 253, 58, 70,
  130, 130, 130, 70, 58, 2, 2, 2, 7, 7, 7, 9, 1, 0, 156, 98,
  66, 64, 64, 64, 64, 7, 7, 7, 9, 1, 0, 124, 130, 128, 124, 2,
  130, 124, 7, 9, 9, 9, 1, 0, 32, 32, 252, 32, 32, 32, 32, 34,
  28, 7, 7, 7, 9, 1, 0, 130, 130, 130, 130, 130, 134, 122, 7, 7,
  7, 9, 1, 0, 130, 130, 68, 68, 40, 40, 16, 7, 7, 7, 9, 1,
  0, 130, 130, 146, 146, 146, 170, 68, 7, 7, 7, 9, 1, 0, 130, 68,
  40, 16, 40, 68, 130, 7, 10, 10, 9, 1, 253, 66, 66, 36, 36, 36,
  24, 24, 16, 144, 96, 7, 7, 7, 9, 1, 0, 254, 4, 8, 16, 32,
  64, 254, 6, 11, 11, 9, 2, 0, 28, 32, 32, 32, 32, 192, 32, 32,
  32, 32, 28, 1, 12, 12, 9, 4, 255, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 6, 11, 11, 9, 1, 0, 224, 16, 16, 16, 16,
  12, 16, 16, 16, 16, 224, 7, 3, 3, 9, 1, 7, 98, 146, 140, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  0, 0, 0, 9, 0, 14, 1, 11, 11, 9, 4, 0, 128, 128, 0, 0,
  128, 128, 128, 128, 128, 128, 128, 6, 8, 8, 9, 1, 0, 8, 120, 148,
  144, 160, 164, 120, 64, 7, 10, 10, 9, 1, 0, 28, 34, 32, 32, 248,
  32, 32, 96, 162, 92, 7, 6, 6, 9, 1, 3, 130, 124, 68, 68, 124,
  130, 7, 10, 10, 9, 1, 0, 130, 130, 68, 40, 124, 16, 124, 16, 16,
  16, 1, 11, 11, 9, 4, 255, 128, 128, 128, 128, 128, 0, 128, 128, 128,
  128, 128, 4, 11, 11, 9, 2, 255, 96, 144, 128, 96, 144, 144, 144, 96,
  16, 144, 96, 3, 2, 2, 9, 3, 11, 160, 160, 8, 9, 9, 9, 0,
  1, 60, 66, 153, 165, 161, 165, 153, 66, 60, 5, 7, 7, 9, 1, 3,
  96, 144, 112, 144, 120, 0, 248, 7, 8, 8, 9, 1, 1, 18, 36, 72,
  144, 144, 72, 36, 18, 6, 4, 4, 9, 1, 2, 252, 4, 4, 4, 5,
  1, 1, 9, 2, 4, 248, 8, 9, 9, 9, 0, 1, 60, 66, 185, 165,
  189, 169, 165, 66, 60, 6, 1, 1, 9, 1, 9, 252, 4, 4, 4, 9,
  3, 6, 96, 144, 144, 96, 7, 9, 9, 9, 1, 1, 16, 16, 16, 254,
  16, 16, 16, 0, 254, 4, 6, 6, 9, 1, 4, 96, 144, 16, 96, 128,
  240, 4, 6, 6, 9, 1, 4, 96, 144, 32, 16, 144, 96, 3, 3, 3,
  9, 3, 10, 32, 64, 128, 7, 9, 9, 9, 1, 254, 130, 130, 130, 130,
  130, 198, 186, 128, 128, 7, 10, 10, 9, 1, 0, 126, 138, 138, 138, 122,
  10, 10, 10, 10, 10, 2, 2, 2, 9, 4, 4, 192, 192, 4, 3, 3,
  9, 2, 253, 32, 144, 96, 3, 6, 6, 9, 1, 4, 64, 192, 64, 64,
  64, 224, 5, 6, 6, 9, 1, 4, 112, 136, 136, 112, 0, 248, 7, 8,
  8, 9, 1, 1, 144, 72, 36, 18, 18, 36, 72, 144, 7, 10, 10, 9,
  1, 0, 64, 192, 64, 64, 66, 230, 10, 18, 26, 6, 7, 10, 10, 9,
  1, 0, 64, 192, 64, 64, 76, 242, 2, 12, 16, 30, 7, 10, 10, 9,
  1, 0, 96, 144, 32, 16, 146, 102, 10, 18, 26, 6, 7, 10, 10, 9,
  1, 0, 16, 0, 16, 16, 32, 64, 128, 130, 130, 124, 7, 14, 14, 9,
  1, 0, 32, 16, 8, 0, 16, 40, 40, 40, 68, 124, 68, 130, 130, 130,
  7, 14, 14, 9, 1, 0, 8, 16, 32, 0, 16, 40, 40, 40, 68, 124,
  68, 130, 130, 130, 7, 14, 14, 9, 1, 0, 16, 40, 68, 0, 16, 40,
  40, 40, 68, 124, 68, 130, 130, 130, 7, 13, 13, 9, 1, 0, 52, 88,
  0, 16, 40, 40, 40, 68, 124, 68, 130, 130, 130, 7, 13, 13, 9, 1,
  0, 40, 40, 0, 16, 40, 40, 40, 68, 124, 68, 130, 130, 130, 7, 14,
  14, 9, 1, 0, 16, 40, 40, 16, 16, 40, 40, 40, 68, 124, 68, 130,
  130, 130, 7, 10, 10, 9, 1, 0, 30, 40, 40, 40, 78, 120, 72, 136,
  136, 142, 7, 13, 13, 9, 1, 253, 60, 66, 128, 128, 128, 128, 128, 128,
  66, 60, 8, 36, 24, 7, 14, 14, 9, 1, 0, 32, 16, 8, 0, 254,
  128, 128, 128, 248, 128, 128, 128, 128, 254, 7, 14, 14, 9, 1, 0, 8,
  16, 32, 0, 254, 128, 128, 128, 248, 128, 128, 128, 128, 254, 7, 14, 14,
  9, 1, 0, 16, 40, 68, 0, 254, 128, 128, 128, 248, 128, 128, 128, 128,
  254, 7, 13, 13, 9, 1, 0, 40, 40, 0, 254, 128, 128, 128, 248, 128,
  128, 128, 128, 254, 5, 14, 14, 9, 2, 0, 64, 32, 16, 0, 248, 32,
  32, 32, 32, 32, 32, 32, 32, 248, 5, 14, 14, 9, 2, 0, 16, 32,
  64, 0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 248, 5, 14, 14, 9,
  2, 0, 32, 80, 136, 0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 248,
  5, 13, 13, 9, 2, 0, 80, 80, 0, 248, 32, 32, 32, 32, 32, 32,
  32, 32, 248, 7, 10, 10, 9, 1, 0, 120, 68, 66, 66, 242, 66, 66,
  66, 68, 120, 7, 13, 13, 9, 1, 0, 52, 88, 0, 130, 130, 194, 162,
  146, 138, 134, 130, 130, 130, 7, 14, 14, 9, 1, 0, 32, 16, 8, 0,
  124, 130, 130, 130, 130, 130, 130, 130, 130, 124, 7, 14, 14, 9, 1, 0,
  8, 16, 32, 0, 124, 130, 130, 130, 130, 130, 130, 130, 130, 124, 7, 14,
  14, 9, 1, 0, 16, 40, 68, 0, 124, 130, 130, 130, 130, 130, 130, 130,
  130, 124, 7, 13, 13, 9, 1, 0, 52, 88, 0, 124, 130, 130, 130, 130,
  130, 130, 130, 130, 124, 7, 13, 13, 9, 1, 0, 40, 40, 0, 124, 130,
  130, 130, 130, 130, 130, 130, 130, 124, 7, 7, 7, 9, 1, 1, 130, 68,
  40, 16, 40, 68, 130, 7, 12, 12, 9, 1, 255, 2, 124, 134, 138, 138,
  146, 146, 162, 162, 194, 124, 128, 7, 14, 14, 9, 1, 0, 32, 16, 8,
  0, 130, 130, 130, 130, 130, 130, 130, 130, 68, 56, 7, 14, 14, 9, 1,
  0, 8, 16, 32, 0, 130, 130, 130, 130, 130, 130, 130, 130, 68, 56, 7,
  14, 14, 9, 1, 0, 16, 40, 68, 0, 130, 130, 130, 130, 130, 130, 130,
  130, 68, 56, 7, 13, 13, 9, 1, 0, 40, 40, 0, 130, 130, 130, 130,
  130, 130, 130, 130, 68, 56, 7, 14, 14, 9, 1, 0, 8, 16, 32, 0,
  130, 130, 68, 40, 16, 16, 16, 16, 16, 16, 7, 10, 10, 9, 1, 0,
  128, 128, 252, 130, 130, 130, 252, 128, 128, 128, 6, 10, 10, 9, 1, 0,
  56, 68, 68, 72, 208, 72, 68, 68, 68, 88, 7, 11, 11, 9, 1, 0,
  32, 16, 8, 0, 124, 2, 2, 126, 130, 134, 122, 7, 11, 11, 9, 1,
  0, 8, 16, 32, 0, 124, 2, 2, 126, 130, 134, 122, 7, 11, 11, 9,
  1, 0, 16, 40, 68, 0, 124, 2, 2, 126, 130, 134, 122, 7, 10, 10,
  9, 1, 0, 52, 88, 0, 124, 2, 2, 126, 130, 134, 122, 7, 10, 10,
  9, 1, 0, 40, 40, 0, 124, 2, 2, 126, 130, 134, 122, 7, 12, 12,
  9, 1, 0, 16, 40, 40, 16, 0, 124, 2, 2, 126, 130, 134, 122, 7,
  7, 7, 9, 1, 0, 108, 18, 18, 126, 144, 146, 108, 7, 10, 10, 9,
  1, 253, 124, 130, 128, 128, 128, 130, 124, 16, 72, 48, 7, 11, 11, 9,
  1, 0, 32, 16, 8, 0, 124, 130, 130, 254, 128, 130, 124, 7, 11, 11,
  9, 1, 0, 8, 16, 32, 0, 124, 130, 130, 254, 128, 130, 124, 7, 11,
  11, 9, 1, 0, 16, 40, 68, 0, 124, 130, 130, 254, 128, 130, 124, 7,
  10, 10, 9, 1, 0, 40, 40, 0, 124, 130, 130, 254, 128, 130, 124, 5,
  12, 12, 9, 2, 0, 128, 64, 32, 0, 0, 224, 32, 32, 32, 32, 32,
  248, 5, 12, 12, 9, 2, 0, 16, 32, 64, 0, 0, 224, 32, 32, 32,
  32, 32, 248, 5, 12, 12, 9, 2, 0, 32, 80, 136, 0, 0, 224, 32,
  32, 32, 32, 32, 248, 5, 11, 11, 9, 2, 0, 80, 80, 0, 0, 224,
  32, 32, 32, 32, 32, 248, 7, 11, 11, 9, 1, 0, 72, 48, 80, 8,
  60, 68, 130, 130, 130, 68, 56, 7, 10, 10, 9, 1, 0, 52, 88, 0,
  188, 194, 130, 130, 130, 130, 130, 7, 11, 11, 9, 1, 0, 32, 16, 8,
  0, 124, 130, 130, 130, 130, 130, 124, 7, 11, 11, 9, 1, 0, 8, 16,
  32, 0, 124, 130, 130, 130, 130, 130, 124, 7, 11, 11, 9, 1, 0, 16,
  40, 68, 0, 124, 130, 130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 0,
  52, 88, 0, 124, 130, 130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 0,
  40, 40, 0, 124, 130, 130, 130, 130, 130, 124, 7, 9, 9, 9, 1, 0,
  16, 56, 16, 0, 254, 0, 16, 56, 16, 7, 9, 9, 9, 1, 255, 2,
  124, 138, 138, 146, 162, 162, 124, 128, 7, 11, 11, 9, 1, 0, 64, 32,
  16, 0, 130, 130, 130, 130, 130, 134, 122, 7, 11, 11, 9, 1, 0, 8,
  16, 32, 0, 130, 130, 130, 130, 130, 134, 122, 7, 11, 11, 9, 1, 0,
  16, 40, 68, 0, 130, 130, 130, 130, 130, 134, 122, 7, 10, 10, 9, 1,
  0, 40, 40, 0, 130, 130, 130, 130, 130, 134, 122, 7, 14, 14, 9, 1,
  253, 4, 8, 16, 0, 66, 66, 36, 36, 36, 24, 24, 16, 144, 96, 7,
  11, 11, 9, 1, 254, 128, 128, 184, 196, 130, 130, 130, 196, 184, 128, 128,
  7, 13, 13, 9, 1, 253, 36, 36, 0, 66, 66, 36, 36, 36, 24, 24,
  16, 144, 96
};

/*
  Fontname: -Misc-Fixed-Medium-R-Normal--18-120-100-100-C-90-ISO10646-1
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 8 h=13 x= 4 y=14 dx= 9 dy= 0 ascent=14 len=13
  Font Bounding box     w= 9 h=18 x= 0 y=-4
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =14 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_9x18r[1424] U8G_FONT_SECTION("u8g_font_9x18r") = {
  0, 9, 18, 0, 252, 10, 1, 232, 3, 215, 32, 127, 253, 14, 253, 11,
  253, 0, 0, 0, 9, 0, 14, 1, 11, 11, 9, 4, 0, 128, 128, 128,
  128, 128, 128, 128, 0, 0, 128, 128, 4, 4, 4, 9, 3, 7, 144, 144,
  144, 144, 8, 10, 10, 9, 0, 0, 36, 36, 36, 255, 36, 36, 255, 36,
  36, 36, 7, 11, 11, 9, 1, 255, 16, 124, 146, 144, 80, 56, 20, 18,
  146, 124, 16, 7, 10, 10, 9, 1, 0, 66, 164, 164, 72, 16, 16, 36,
  74, 74, 132, 7, 10, 10, 9, 1, 0, 96, 144, 144, 144, 96, 98, 148,
  136, 148, 98, 1, 4, 4, 9, 4, 7, 128, 128, 128, 128, 3, 12, 12,
  9, 3, 255, 32, 64, 64, 128, 128, 128, 128, 128, 128, 64, 64, 32, 3,
  12, 12, 9, 3, 255, 128, 64, 64, 32, 32, 32, 32, 32, 32, 64, 64,
  128, 7, 7, 7, 9, 1, 3, 16, 146, 84, 56, 84, 146, 16, 7, 7,
  7, 9, 1, 1, 16, 16, 16, 254, 16, 16, 16, 2, 4, 4, 9, 4,
  254, 192, 192, 64, 128, 7, 1, 1, 9, 1, 4, 254, 2, 2, 2, 9,
  4, 0, 192, 192, 7, 10, 10, 9, 1, 0, 2, 4, 4, 8, 16, 16,
  32, 64, 64, 128, 7, 10, 10, 9, 1, 0, 56, 68, 130, 130, 130, 130,
  130, 130, 68, 56, 7, 10, 10, 9, 1, 0, 16, 48, 80, 144, 16, 16,
  16, 16, 16, 254, 7, 10, 10, 9, 1, 0, 56, 68, 130, 2, 4, 8,
  16, 32, 64, 254, 7, 10, 10, 9, 1, 0, 254, 2, 4, 8, 24, 4,
  2, 2, 132, 120, 7, 10, 10, 9, 1, 0, 4, 12, 20, 36, 68, 132,
  254, 4, 4, 4, 7, 10, 10, 9, 1, 0, 254, 128, 128, 128, 248, 4,
  2, 2, 132, 120, 7, 10, 10, 9, 1, 0, 60, 64, 128, 128, 184, 196,
  130, 130, 68, 56, 7, 10, 10, 9, 1, 0, 254, 2, 4, 4, 8, 8,
  16, 16, 16, 16, 7, 10, 10, 9, 1, 0, 56, 68, 130, 68, 56, 68,
  130, 130, 68, 56, 7, 10, 10, 9, 1, 0, 56, 68, 130, 130, 70, 58,
  2, 2, 4, 120, 2, 7, 7, 9, 4, 0, 192, 192, 0, 0, 0, 192,
  192, 2, 9, 9, 9, 4, 254, 192, 192, 0, 0, 0, 192, 192, 64, 128,
  5, 9, 9, 9, 2, 0, 8, 16, 32, 64, 128, 64, 32, 16, 8, 7,
  4, 4, 9, 1, 2, 254, 0, 0, 254, 5, 9, 9, 9, 2, 0, 128,
  64, 32, 16, 8, 16, 32, 64, 128, 7, 10, 10, 9, 1, 0, 56, 68,
  130, 2, 4, 8, 16, 16, 0, 16, 7, 10, 10, 9, 1, 0, 56, 68,
  154, 170, 170, 170, 170, 156, 64, 60, 7, 10, 10, 9, 1, 0, 16, 40,
  40, 40, 68, 124, 68, 130, 130, 130, 7, 10, 10, 9, 1, 0, 248, 132,
  130, 132, 248, 132, 130, 130, 132, 248, 7, 10, 10, 9, 1, 0, 60, 66,
  128, 128, 128, 128, 128, 128, 66, 60, 7, 10, 10, 9, 1, 0, 248, 132,
  130, 130, 130, 130, 130, 130, 132, 248, 7, 10, 10, 9, 1, 0, 254, 128,
  128, 128, 248, 128, 128, 128, 128, 254, 7, 10, 10, 9, 1, 0, 254, 128,
  128, 128, 248, 128, 128, 128, 128, 128, 7, 10, 10, 9, 1, 0, 56, 68,
  130, 128, 128, 142, 130, 130, 68, 56, 7, 10, 10, 9, 1, 0, 130, 130,
  130, 130, 254, 130, 130, 130, 130, 130, 5, 10, 10, 9, 2, 0, 248, 32,
  32, 32, 32, 32, 32, 32, 32, 248, 7, 10, 10, 9, 1, 0, 62, 8,
  8, 8, 8, 8, 8, 136, 136, 112, 7, 10, 10, 9, 1, 0, 130, 132,
  136, 144, 160, 208, 136, 132, 130, 130, 7, 10, 10, 9, 1, 0, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 254, 7, 10, 10, 9, 1, 0, 130, 130,
  198, 170, 146, 130, 130, 130, 130, 130, 7, 10, 10, 9, 1, 0, 130, 130,
  194, 162, 146, 138, 134, 130, 130, 130, 7, 10, 10, 9, 1, 0, 124, 130,
  130, 130, 130, 130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 0, 248, 132,
  130, 130, 132, 248, 128, 128, 128, 128, 8, 11, 11, 9, 1, 255, 56, 68,
  130, 130, 130, 130, 130, 138, 68, 58, 1, 7, 10, 10, 9, 1, 0, 248,
  132, 130, 130, 132, 248, 144, 136, 132, 130, 7, 10, 10, 9, 1, 0, 124,
  130, 128, 128, 124, 2, 2, 2, 130, 124, 7, 10, 10, 9, 1, 0, 254,
  16, 16, 16, 16, 16, 16, 16, 16, 16, 7, 10, 10, 9, 1, 0, 130,
  130, 130, 130, 130, 130, 130, 130, 68, 56, 7, 10, 10, 9, 1, 0, 130,
  130, 130, 68, 68, 68, 40, 40, 40, 16, 7, 10, 10, 9, 1, 0, 130,
  130, 130, 130, 146, 146, 146, 146, 170, 68, 7, 10, 10, 9, 1, 0, 130,
  130, 68, 40, 16, 16, 40, 68, 130, 130, 7, 10, 10, 9, 1, 0, 130,
  130, 68, 40, 16, 16, 16, 16, 16, 16, 7, 10, 10, 9, 1, 0, 254,
  2, 4, 8, 16, 32, 64, 128, 128, 254, 4, 12, 12, 9, 3, 255, 240,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 240, 7, 10, 10, 9, 1,
  0, 128, 64, 64, 32, 16, 16, 8, 4, 4, 2, 4, 12, 12, 9, 2,
  255, 240, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 240, 7, 4, 4,
  9, 1, 6, 16, 40, 68, 130, 8, 1, 1, 9, 0, 255, 255, 3, 3,
  3, 9, 3, 10, 128, 64, 32, 7, 7, 7, 9, 1, 0, 124, 2, 2,
  126, 130, 134, 122, 7, 10, 10, 9, 1, 0, 128, 128, 128, 188, 194, 130,
  130, 130, 194, 188, 7, 7, 7, 9, 1, 0, 124, 130, 128, 128, 128, 130,
  124, 7, 10, 10, 9, 1, 0, 2, 2, 2, 122, 134, 130, 130, 130, 134,
  122, 7, 7, 7, 9, 1, 0, 124, 130, 130, 254, 128, 130, 124, 7, 10,
  10, 9, 1, 0, 28, 34, 34, 32, 32, 248, 32, 32, 32, 32, 7, 10,
  10, 9, 1, 253, 122, 132, 132, 132, 120, 128, 124, 130, 130, 124, 7, 10,
  10, 9, 1, 0, 128, 128, 128, 188, 194, 130, 130, 130, 130, 130, 5, 10,
  10, 9, 2, 0, 96, 0, 0, 224, 32, 32, 32, 32, 32, 248, 5, 13,
  13, 9, 2, 253, 24, 0, 0, 56, 8, 8, 8, 8, 8, 8, 136, 136,
  112, 7, 10, 10, 9, 1, 0, 128, 128, 128, 132, 136, 144, 176, 200, 132,
  130, 5, 10, 10, 9, 2, 0, 224, 32, 32, 32, 32, 32, 32, 32, 32,
  248, 7, 7, 7, 9, 1, 0, 236, 146, 146, 146, 146, 146, 130, 7, 7,
  7, 9, 1, 0, 188, 194, 130, 130, 130, 130, 130, 7, 7, 7, 9, 1,
  0, 124, 130, 130, 130, 130, 130, 124, 7, 10, 10, 9, 1, 253, 184, 196,
  130, 130, 130, 196, 184, 128, 128, 128, 7, 10, 10, 9, 1, 253, 58, 70,
  130, 130, 130, 70, 58, 2, 2, 2, 7, 7, 7, 9, 1, 0, 156, 98,
  66, 64, 64, 64, 64, 7, 7, 7, 9, 1, 0, 124, 130, 128, 124, 2,
  130, 124, 7, 9, 9, 9, 1, 0, 32, 32, 252, 32, 32, 32, 32, 34,
  28, 7, 7, 7, 9, 1, 0, 130, 130, 130, 130, 130, 134, 122, 7, 7,
  7, 9, 1, 0, 130, 130, 68, 68, 40, 40, 16, 7, 7, 7, 9, 1,
  0, 130, 130, 146, 146, 146, 170, 68, 7, 7, 7, 9, 1, 0, 130, 68,
  40, 16, 40, 68, 130, 7, 10, 10, 9, 1, 253, 66, 66, 36, 36, 36,
  24, 24, 16, 144, 96, 7, 7, 7, 9, 1, 0, 254, 4, 8, 16, 32,
  64, 254, 6, 11, 11, 9, 2, 0, 28, 32, 32, 32, 32, 192, 32, 32,
  32, 32, 28, 1, 12, 12, 9, 4, 255, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 6, 11, 11, 9, 1, 0, 224, 16, 16, 16, 16,
  12, 16, 16, 16, 16, 224, 7, 3, 3, 9, 1, 7, 98, 146, 140, 255
};

/*
  Fontname: -FreeType-Baby-Medium-R-Normal--8-80-72-72-P-42-ISO10646-1
  Copyright: Copyright mrsbarrett 2008
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 9 h= 9 x= 1 y= 5 dx=10 dy= 0 ascent= 8 len=12
  Font Bounding box     w=10 h=10 x=-1 y=-2
  Calculated Min Values           x=-1 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-2
  X Font      ascent = 6 descent=-2
  Max Font    ascent = 8 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_baby[2227] U8G_FONT_SECTION("u8g_font_baby") = {
  0, 10, 10, 255, 254, 5, 1, 108, 2, 200, 32, 255, 254, 8, 254, 6,
  254, 0, 0, 0, 2, 0, 0, 1, 6, 6, 3, 1, 0, 128, 128, 128,
  128, 0, 128, 3, 3, 3, 4, 0, 4, 160, 160, 160, 5, 5, 5, 6,
  0, 0, 80, 248, 80, 248, 80, 3, 7, 7, 4, 0, 255, 64, 96, 128,
  64, 32, 192, 64, 5, 5, 5, 6, 0, 0, 200, 208, 32, 88, 152, 5,
  6, 6, 6, 0, 0, 64, 160, 64, 160, 144, 104, 1, 3, 3, 2, 0,
  4, 128, 128, 128, 2, 7, 7, 3, 0, 255, 64, 128, 128, 128, 128, 128,
  64, 2, 7, 7, 3, 0, 255, 128, 64, 64, 64, 64, 64, 128, 3, 3,
  3, 4, 0, 3, 160, 64, 160, 3, 3, 3, 5, 1, 1, 64, 224, 64,
  2, 3, 3, 3, 0, 254, 192, 64, 128, 3, 1, 1, 4, 0, 2, 224,
  1, 1, 1, 2, 0, 0, 128, 3, 6, 6, 4, 0, 255, 32, 32, 64,
  64, 128, 128, 3, 5, 5, 4, 0, 0, 64, 160, 160, 160, 64, 2, 5,
  5, 3, 0, 0, 64, 192, 64, 64, 64, 4, 5, 5, 5, 0, 0, 96,
  144, 32, 64, 240, 4, 5, 5, 5, 0, 0, 224, 16, 96, 16, 224, 4,
  5, 5, 5, 0, 0, 144, 144, 144, 112, 16, 4, 5, 5, 5, 0, 0,
  240, 128, 224, 16, 224, 4, 5, 5, 5, 0, 0, 96, 128, 224, 144, 96,
  4, 5, 5, 5, 0, 0, 240, 16, 32, 64, 128, 4, 5, 5, 5, 0,
  0, 96, 144, 96, 144, 96, 4, 5, 5, 5, 0, 0, 96, 144, 112, 16,
  96, 1, 3, 3, 3, 1, 0, 128, 0, 128, 2, 5, 5, 3, 0, 254,
  64, 0, 64, 64, 128, 4, 5, 5, 5, 0, 0, 16, 96, 128, 96, 16,
  3, 3, 3, 4, 0, 1, 224, 0, 224, 4, 5, 5, 5, 0, 0, 128,
  96, 16, 96, 128, 4, 6, 6, 5, 0, 0, 96, 144, 32, 64, 0, 64,
  5, 6, 6, 6, 0, 0, 112, 136, 168, 176, 128, 112, 4, 5, 5, 5,
  0, 0, 96, 144, 144, 240, 144, 4, 5, 5, 5, 0, 0, 224, 144, 224,
  144, 224, 4, 5, 5, 5, 0, 0, 96, 144, 128, 144, 96, 4, 5, 5,
  5, 0, 0, 224, 144, 144, 144, 224, 4, 5, 5, 5, 0, 0, 240, 128,
  224, 128, 240, 4, 5, 5, 5, 0, 0, 240, 128, 224, 128, 128, 4, 5,
  5, 5, 0, 0, 96, 128, 176, 144, 96, 4, 5, 5, 5, 0, 0, 144,
  144, 240, 144, 144, 3, 5, 5, 4, 0, 0, 224, 64, 64, 64, 224, 4,
  5, 5, 5, 0, 0, 112, 16, 16, 144, 96, 4, 5, 5, 5, 0, 0,
  144, 144, 144, 224, 144, 3, 5, 5, 4, 0, 0, 128, 128, 128, 128, 224,
  5, 5, 5, 6, 0, 0, 216, 168, 168, 168, 136, 4, 5, 5, 5, 0,
  0, 144, 144, 208, 176, 144, 4, 5, 5, 5, 0, 0, 96, 144, 144, 144,
  96, 4, 5, 5, 5, 0, 0, 224, 144, 144, 224, 128, 4, 5, 5, 5,
  0, 0, 96, 144, 144, 80, 224, 4, 5, 5, 5, 0, 0, 224, 144, 144,
  224, 144, 3, 5, 5, 4, 0, 0, 96, 128, 64, 32, 192, 3, 5, 5,
  4, 0, 0, 224, 64, 64, 64, 64, 4, 5, 5, 5, 0, 0, 144, 144,
  144, 144, 96, 5, 5, 5, 6, 0, 0, 136, 80, 80, 80, 32, 5, 5,
  5, 6, 0, 0, 136, 136, 136, 168, 80, 4, 5, 5, 5, 0, 0, 144,
  144, 144, 96, 144, 4, 6, 6, 5, 0, 255, 144, 144, 144, 112, 16, 96,
  4, 5, 5, 5, 0, 0, 240, 32, 64, 128, 240, 2, 7, 7, 3, 0,
  255, 192, 128, 128, 128, 128, 128, 192, 3, 6, 6, 4, 0, 255, 128, 128,
  64, 64, 32, 32, 2, 7, 7, 3, 0, 255, 192, 64, 64, 64, 64, 64,
  192, 3, 2, 2, 4, 0, 4, 64, 160, 4, 1, 1, 5, 0, 255, 240,
  2, 2, 2, 3, 0, 5, 128, 64, 4, 4, 4, 5, 0, 0, 96, 144,
  144, 112, 4, 5, 5, 5, 0, 0, 128, 224, 144, 144, 96, 3, 4, 4,
  4, 0, 0, 96, 128, 128, 96, 4, 5, 5, 5, 0, 0, 16, 112, 144,
  144, 96, 4, 4, 4, 5, 0, 0, 96, 144, 160, 112, 4, 5, 5, 5,
  0, 0, 96, 144, 128, 192, 128, 4, 6, 6, 5, 0, 254, 96, 144, 144,
  112, 16, 96, 4, 5, 5, 5, 0, 0, 128, 224, 144, 144, 144, 1, 5,
  5, 2, 0, 0, 128, 0, 128, 128, 128, 3, 7, 7, 3, 255, 254, 32,
  0, 32, 32, 32, 32, 192, 3, 5, 5, 4, 0, 0, 128, 160, 192, 160,
  160, 1, 5, 5, 2, 0, 0, 128, 128, 128, 128, 128, 5, 4, 4, 6,
  0, 0, 208, 168, 168, 136, 4, 4, 4, 5, 0, 0, 224, 144, 144, 144,
  4, 4, 4, 5, 0, 0, 96, 144, 144, 96, 4, 6, 6, 5, 0, 254,
  96, 144, 144, 224, 128, 128, 4, 6, 6, 5, 0, 254, 96, 144, 144, 112,
  16, 16, 4, 4, 4, 5, 0, 0, 224, 144, 128, 128, 4, 4, 4, 5,
  0, 0, 112, 64, 32, 224, 3, 5, 5, 4, 0, 0, 64, 224, 64, 64,
  64, 4, 4, 4, 5, 0, 0, 144, 144, 144, 112, 4, 4, 4, 5, 0,
  0, 144, 144, 144, 96, 5, 4, 4, 6, 0, 0, 136, 168, 168, 80, 4,
  4, 4, 5, 0, 0, 144, 144, 96, 144, 4, 6, 6, 5, 0, 254, 144,
  144, 144, 112, 16, 96, 4, 4, 4, 5, 0, 0, 240, 32, 64, 240, 3,
  7, 7, 4, 0, 255, 32, 64, 64, 128, 64, 64, 32, 1, 7, 7, 2,
  0, 255, 128, 128, 128, 128, 128, 128, 128, 3, 7, 7, 4, 0, 255, 128,
  64, 64, 32, 64, 64, 128, 5, 3, 3, 6, 0, 1, 64, 168, 16, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 1, 6, 6, 3, 1, 255, 128, 0, 128, 128, 128, 128, 4, 6, 6,
  5, 0, 255, 16, 112, 160, 160, 112, 64, 4, 6, 6, 5, 0, 0, 96,
  208, 64, 224, 64, 240, 4, 4, 4, 5, 0, 1, 240, 144, 144, 240, 5,
  7, 7, 6, 0, 255, 136, 80, 32, 112, 32, 112, 32, 1, 7, 7, 2,
  0, 255, 128, 128, 128, 0, 128, 128, 128, 4, 7, 7, 5, 0, 255, 112,
  128, 96, 144, 96, 16, 224, 3, 1, 1, 4, 0, 5, 160, 7, 7, 7,
  8, 0, 255, 56, 68, 154, 162, 154, 68, 56, 3, 3, 3, 4, 0, 4,
  96, 160, 224, 4, 3, 3, 5, 0, 1, 80, 160, 80, 5, 3, 3, 6,
  0, 1, 248, 8, 8, 2, 1, 1, 3, 0, 2, 192, 7, 7, 7, 8,
  0, 255, 56, 68, 178, 186, 170, 68, 56, 4, 1, 1, 5, 0, 5, 240,
  3, 3, 3, 4, 0, 4, 64, 160, 64, 3, 5, 5, 4, 0, 0, 64,
  224, 64, 0, 224, 3, 4, 4, 4, 0, 4, 192, 32, 64, 224, 3, 4,
  4, 4, 0, 4, 224, 32, 96, 224, 2, 2, 2, 3, 0, 5, 64, 128,
  5, 6, 6, 6, 0, 254, 144, 144, 144, 248, 128, 128, 5, 6, 6, 6,
  0, 0, 120, 232, 232, 104, 40, 40, 1, 1, 1, 3, 1, 2, 128, 3,
  3, 3, 4, 0, 254, 64, 32, 192, 3, 4, 4, 4, 0, 4, 64, 192,
  64, 224, 4, 4, 4, 5, 0, 4, 96, 144, 144, 96, 4, 3, 3, 5,
  0, 1, 160, 80, 160, 7, 6, 6, 8, 0, 0, 136, 144, 160, 42, 78,
  130, 7, 6, 6, 8, 0, 0, 136, 144, 164, 42, 68, 142, 9, 6, 12,
  10, 0, 0, 226, 0, 100, 0, 232, 0, 10, 128, 19, 128, 32, 128, 4,
  6, 6, 5, 0, 255, 32, 0, 32, 64, 144, 96, 4, 8, 8, 5, 0,
  0, 64, 32, 0, 96, 144, 144, 240, 144, 4, 8, 8, 5, 0, 0, 32,
  64, 0, 96, 144, 144, 240, 144, 4, 8, 8, 5, 0, 0, 96, 144, 0,
  96, 144, 144, 240, 144, 4, 8, 8, 5, 0, 0, 80, 160, 0, 96, 144,
  144, 240, 144, 4, 7, 7, 5, 0, 0, 80, 0, 96, 144, 144, 240, 144,
  4, 7, 7, 5, 0, 0, 96, 0, 96, 144, 144, 240, 144, 7, 5, 5,
  8, 0, 0, 126, 144, 156, 240, 158, 4, 7, 7, 5, 0, 254, 96, 144,
  128, 144, 96, 32, 64, 4, 8, 8, 5, 0, 0, 64, 32, 0, 240, 128,
  224, 128, 240, 4, 8, 8, 5, 0, 0, 32, 64, 0, 240, 128, 224, 128,
  240, 4, 8, 8, 5, 0, 0, 96, 144, 0, 240, 128, 224, 128, 240, 4,
  7, 7, 5, 0, 0, 80, 0, 240, 128, 224, 128, 240, 3, 8, 8, 4,
  0, 0, 128, 64, 0, 224, 64, 64, 64, 224, 3, 8, 8, 4, 0, 0,
  32, 64, 0, 224, 64, 64, 64, 224, 3, 8, 8, 4, 0, 0, 64, 160,
  0, 224, 64, 64, 64, 224, 3, 7, 7, 4, 0, 0, 160, 0, 224, 64,
  64, 64, 224, 5, 5, 5, 6, 0, 0, 112, 72, 232, 72, 112, 4, 8,
  8, 5, 0, 0, 80, 160, 0, 144, 144, 208, 176, 144, 4, 8, 8, 5,
  0, 0, 64, 32, 0, 96, 144, 144, 144, 96, 4, 8, 8, 5, 0, 0,
  32, 64, 0, 96, 144, 144, 144, 96, 4, 8, 8, 5, 0, 0, 96, 144,
  0, 96, 144, 144, 144, 96, 4, 8, 8, 5, 0, 0, 80, 160, 0, 96,
  144, 144, 144, 96, 4, 7, 7, 5, 0, 0, 80, 0, 96, 144, 144, 144,
  96, 3, 3, 3, 4, 0, 1, 160, 64, 160, 6, 5, 5, 7, 0, 0,
  48, 76, 120, 200, 48, 4, 8, 8, 5, 0, 0, 64, 32, 0, 144, 144,
  144, 144, 96, 4, 8, 8, 5, 0, 0, 32, 64, 0, 144, 144, 144, 144,
  96, 4, 8, 8, 5, 0, 0, 96, 144, 0, 144, 144, 144, 144, 96, 4,
  7, 7, 5, 0, 0, 80, 0, 144, 144, 144, 144, 96, 4, 9, 9, 5,
  0, 255, 32, 64, 0, 144, 144, 144, 112, 16, 96, 4, 6, 6, 5, 0,
  0, 128, 224, 144, 144, 224, 128, 4, 5, 5, 5, 0, 0, 96, 144, 160,
  144, 160, 4, 7, 7, 5, 0, 0, 64, 32, 0, 96, 144, 144, 112, 4,
  7, 7, 5, 0, 0, 32, 64, 0, 96, 144, 144, 112, 4, 7, 7, 5,
  0, 0, 96, 144, 0, 96, 144, 144, 112, 4, 7, 7, 5, 0, 0, 80,
  160, 0, 96, 144, 144, 112, 4, 6, 6, 5, 0, 0, 80, 0, 96, 144,
  144, 112, 4, 7, 7, 5, 0, 0, 96, 96, 0, 96, 144, 144, 112, 7,
  4, 4, 8, 0, 0, 108, 146, 148, 126, 3, 6, 6, 4, 0, 254, 96,
  128, 128, 96, 32, 64, 4, 7, 7, 5, 0, 0, 64, 32, 0, 96, 144,
  160, 112, 4, 7, 7, 5, 0, 0, 32, 64, 0, 96, 144, 160, 112, 4,
  7, 7, 5, 0, 0, 96, 144, 0, 96, 144, 160, 112, 4, 6, 6, 5,
  0, 0, 80, 0, 96, 144, 160, 112, 2, 6, 6, 3, 0, 0, 128, 64,
  0, 64, 64, 64, 2, 6, 6, 3, 0, 0, 64, 128, 0, 128, 128, 128,
  3, 6, 6, 4, 0, 0, 64, 160, 0, 64, 64, 64, 3, 5, 5, 4,
  0, 0, 160, 0, 64, 64, 64, 5, 6, 6, 6, 0, 0, 96, 24, 112,
  144, 144, 96, 4, 7, 7, 5, 0, 0, 80, 160, 0, 224, 144, 144, 144,
  4, 7, 7, 5, 0, 0, 64, 32, 0, 96, 144, 144, 96, 4, 7, 7,
  5, 0, 0, 32, 64, 0, 96, 144, 144, 96, 4, 7, 7, 5, 0, 0,
  96, 144, 0, 96, 144, 144, 96, 4, 7, 7, 5, 0, 0, 80, 160, 0,
  96, 144, 144, 96, 4, 6, 6, 5, 0, 0, 80, 0, 96, 144, 144, 96,
  5, 5, 5, 6, 0, 0, 32, 0, 248, 0, 32, 4, 4, 4, 5, 0,
  0, 96, 176, 208, 96, 4, 7, 7, 5, 0, 0, 64, 32, 0, 144, 144,
  144, 112, 4, 7, 7, 5, 0, 0, 32, 64, 0, 144, 144, 144, 112, 4,
  7, 7, 5, 0, 0, 96, 144, 0, 144, 144, 144, 112, 4, 6, 6, 5,
  0, 0, 80, 0, 144, 144, 144, 112, 4, 9, 9, 5, 0, 254, 32, 64,
  0, 144, 144, 144, 112, 16, 96, 4, 8, 8, 5, 0, 254, 128, 128, 224,
  144, 144, 224, 128, 128, 4, 8, 8, 5, 0, 254, 80, 0, 144, 144, 144,
  112, 16, 96
};

/*
  Fontname: -FreeType-Baby-Medium-R-Normal--8-80-72-72-P-42-ISO10646-1
  Copyright: Copyright mrsbarrett 2008
  Capital A Height: 0, '1' Height: 5
  Calculated Max Values w= 4 h= 6 x= 1 y= 3 dx= 5 dy= 0 ascent= 6 len= 6
  Font Bounding box     w=10 h=10 x=-1 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 5 descent= 0
  X Font      ascent = 5 descent= 0
  Max Font    ascent = 6 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_babyn[189] U8G_FONT_SECTION("u8g_font_babyn") = {
  0, 10, 10, 255, 254, 5, 0, 0, 0, 0, 42, 58, 0, 6, 254, 5,
  0, 3, 3, 3, 4, 0, 3, 160, 64, 160, 3, 3, 3, 5, 1, 1,
  64, 224, 64, 2, 3, 3, 3, 0, 254, 192, 64, 128, 3, 1, 1, 4,
  0, 2, 224, 1, 1, 1, 2, 0, 0, 128, 3, 6, 6, 4, 0, 255,
  32, 32, 64, 64, 128, 128, 3, 5, 5, 4, 0, 0, 64, 160, 160, 160,
  64, 2, 5, 5, 3, 0, 0, 64, 192, 64, 64, 64, 4, 5, 5, 5,
  0, 0, 96, 144, 32, 64, 240, 4, 5, 5, 5, 0, 0, 224, 16, 96,
  16, 224, 4, 5, 5, 5, 0, 0, 144, 144, 144, 112, 16, 4, 5, 5,
  5, 0, 0, 240, 128, 224, 16, 224, 4, 5, 5, 5, 0, 0, 96, 128,
  224, 144, 96, 4, 5, 5, 5, 0, 0, 240, 16, 32, 64, 128, 4, 5,
  5, 5, 0, 0, 96, 144, 96, 144, 96, 4, 5, 5, 5, 0, 0, 96,
  144, 112, 16, 96, 1, 3, 3, 3, 1, 0, 128, 0, 128
};

/*
  Fontname: -FreeType-Baby-Medium-R-Normal--8-80-72-72-P-42-ISO10646-1
  Copyright: Copyright mrsbarrett 2008
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 5 h= 7 x= 1 y= 5 dx= 6 dy= 0 ascent= 7 len= 7
  Font Bounding box     w=10 h=10 x=-1 y=-2
  Calculated Min Values           x=-1 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-2
  X Font      ascent = 6 descent=-2
  Max Font    ascent = 7 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_babyr[1040] U8G_FONT_SECTION("u8g_font_babyr") = {
  0, 10, 10, 255, 254, 5, 1, 108, 2, 200, 32, 127, 254, 7, 254, 6,
  254, 0, 0, 0, 2, 0, 0, 1, 6, 6, 3, 1, 0, 128, 128, 128,
  128, 0, 128, 3, 3, 3, 4, 0, 4, 160, 160, 160, 5, 5, 5, 6,
  0, 0, 80, 248, 80, 248, 80, 3, 7, 7, 4, 0, 255, 64, 96, 128,
  64, 32, 192, 64, 5, 5, 5, 6, 0, 0, 200, 208, 32, 88, 152, 5,
  6, 6, 6, 0, 0, 64, 160, 64, 160, 144, 104, 1, 3, 3, 2, 0,
  4, 128, 128, 128, 2, 7, 7, 3, 0, 255, 64, 128, 128, 128, 128, 128,
  64, 2, 7, 7, 3, 0, 255, 128, 64, 64, 64, 64, 64, 128, 3, 3,
  3, 4, 0, 3, 160, 64, 160, 3, 3, 3, 5, 1, 1, 64, 224, 64,
  2, 3, 3, 3, 0, 254, 192, 64, 128, 3, 1, 1, 4, 0, 2, 224,
  1, 1, 1, 2, 0, 0, 128, 3, 6, 6, 4, 0, 255, 32, 32, 64,
  64, 128, 128, 3, 5, 5, 4, 0, 0, 64, 160, 160, 160, 64, 2, 5,
  5, 3, 0, 0, 64, 192, 64, 64, 64, 4, 5, 5, 5, 0, 0, 96,
  144, 32, 64, 240, 4, 5, 5, 5, 0, 0, 224, 16, 96, 16, 224, 4,
  5, 5, 5, 0, 0, 144, 144, 144, 112, 16, 4, 5, 5, 5, 0, 0,
  240, 128, 224, 16, 224, 4, 5, 5, 5, 0, 0, 96, 128, 224, 144, 96,
  4, 5, 5, 5, 0, 0, 240, 16, 32, 64, 128, 4, 5, 5, 5, 0,
  0, 96, 144, 96, 144, 96, 4, 5, 5, 5, 0, 0, 96, 144, 112, 16,
  96, 1, 3, 3, 3, 1, 0, 128, 0, 128, 2, 5, 5, 3, 0, 254,
  64, 0, 64, 64, 128, 4, 5, 5, 5, 0, 0, 16, 96, 128, 96, 16,
  3, 3, 3, 4, 0, 1, 224, 0, 224, 4, 5, 5, 5, 0, 0, 128,
  96, 16, 96, 128, 4, 6, 6, 5, 0, 0, 96, 144, 32, 64, 0, 64,
  5, 6, 6, 6, 0, 0, 112, 136, 168, 176, 128, 112, 4, 5, 5, 5,
  0, 0, 96, 144, 144, 240, 144, 4, 5, 5, 5, 0, 0, 224, 144, 224,
  144, 224, 4, 5, 5, 5, 0, 0, 96, 144, 128, 144, 96, 4, 5, 5,
  5, 0, 0, 224, 144, 144, 144, 224, 4, 5, 5, 5, 0, 0, 240, 128,
  224, 128, 240, 4, 5, 5, 5, 0, 0, 240, 128, 224, 128, 128, 4, 5,
  5, 5, 0, 0, 96, 128, 176, 144, 96, 4, 5, 5, 5, 0, 0, 144,
  144, 240, 144, 144, 3, 5, 5, 4, 0, 0, 224, 64, 64, 64, 224, 4,
  5, 5, 5, 0, 0, 112, 16, 16, 144, 96, 4, 5, 5, 5, 0, 0,
  144, 144, 144, 224, 144, 3, 5, 5, 4, 0, 0, 128, 128, 128, 128, 224,
  5, 5, 5, 6, 0, 0, 216, 168, 168, 168, 136, 4, 5, 5, 5, 0,
  0, 144, 144, 208, 176, 144, 4, 5, 5, 5, 0, 0, 96, 144, 144, 144,
  96, 4, 5, 5, 5, 0, 0, 224, 144, 144, 224, 128, 4, 5, 5, 5,
  0, 0, 96, 144, 144, 80, 224, 4, 5, 5, 5, 0, 0, 224, 144, 144,
  224, 144, 3, 5, 5, 4, 0, 0, 96, 128, 64, 32, 192, 3, 5, 5,
  4, 0, 0, 224, 64, 64, 64, 64, 4, 5, 5, 5, 0, 0, 144, 144,
  144, 144, 96, 5, 5, 5, 6, 0, 0, 136, 80, 80, 80, 32, 5, 5,
  5, 6, 0, 0, 136, 136, 136, 168, 80, 4, 5, 5, 5, 0, 0, 144,
  144, 144, 96, 144, 4, 6, 6, 5, 0, 255, 144, 144, 144, 112, 16, 96,
  4, 5, 5, 5, 0, 0, 240, 32, 64, 128, 240, 2, 7, 7, 3, 0,
  255, 192, 128, 128, 128, 128, 128, 192, 3, 6, 6, 4, 0, 255, 128, 128,
  64, 64, 32, 32, 2, 7, 7, 3, 0, 255, 192, 64, 64, 64, 64, 64,
  192, 3, 2, 2, 4, 0, 4, 64, 160, 4, 1, 1, 5, 0, 255, 240,
  2, 2, 2, 3, 0, 5, 128, 64, 4, 4, 4, 5, 0, 0, 96, 144,
  144, 112, 4, 5, 5, 5, 0, 0, 128, 224, 144, 144, 96, 3, 4, 4,
  4, 0, 0, 96, 128, 128, 96, 4, 5, 5, 5, 0, 0, 16, 112, 144,
  144, 96, 4, 4, 4, 5, 0, 0, 96, 144, 160, 112, 4, 5, 5, 5,
  0, 0, 96, 144, 128, 192, 128, 4, 6, 6, 5, 0, 254, 96, 144, 144,
  112, 16, 96, 4, 5, 5, 5, 0, 0, 128, 224, 144, 144, 144, 1, 5,
  5, 2, 0, 0, 128, 0, 128, 128, 128, 3, 7, 7, 3, 255, 254, 32,
  0, 32, 32, 32, 32, 192, 3, 5, 5, 4, 0, 0, 128, 160, 192, 160,
  160, 1, 5, 5, 2, 0, 0, 128, 128, 128, 128, 128, 5, 4, 4, 6,
  0, 0, 208, 168, 168, 136, 4, 4, 4, 5, 0, 0, 224, 144, 144, 144,
  4, 4, 4, 5, 0, 0, 96, 144, 144, 96, 4, 6, 6, 5, 0, 254,
  96, 144, 144, 224, 128, 128, 4, 6, 6, 5, 0, 254, 96, 144, 144, 112,
  16, 16, 4, 4, 4, 5, 0, 0, 224, 144, 128, 128, 4, 4, 4, 5,
  0, 0, 112, 64, 32, 224, 3, 5, 5, 4, 0, 0, 64, 224, 64, 64,
  64, 4, 4, 4, 5, 0, 0, 144, 144, 144, 112, 4, 4, 4, 5, 0,
  0, 144, 144, 144, 96, 5, 4, 4, 6, 0, 0, 136, 168, 168, 80, 4,
  4, 4, 5, 0, 0, 144, 144, 96, 144, 4, 6, 6, 5, 0, 254, 144,
  144, 144, 112, 16, 96, 4, 4, 4, 5, 0, 0, 240, 32, 64, 240, 3,
  7, 7, 4, 0, 255, 32, 64, 64, 128, 64, 64, 32, 1, 7, 7, 2,
  0, 255, 128, 128, 128, 128, 128, 128, 128, 3, 7, 7, 4, 0, 255, 128,
  64, 64, 32, 64, 64, 128, 5, 3, 3, 6, 0, 1, 64, 168, 16, 255
};

/*
  Fontname: -FreeType-Blipfest 07-Medium-R-Normal--8-80-72-72-P-33-ISO10646-1
  Copyright: Copyright cwillmor 2008
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 5 h= 5 x= 0 y= 3 dx= 6 dy= 0 ascent= 5 len= 5
  Font Bounding box     w= 5 h= 6 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-1
  X Font      ascent = 5 descent=-1
  Max Font    ascent = 5 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_blipfest_07[948] U8G_FONT_SECTION("u8g_font_blipfest_07") = {
  0, 5, 6, 0, 255, 5, 1, 5, 2, 47, 32, 255, 255, 5, 255, 5,
  255, 0, 0, 0, 1, 0, 0, 1, 5, 5, 2, 0, 0, 128, 128, 128,
  0, 128, 3, 2, 2, 4, 0, 3, 160, 160, 255, 255, 255, 4, 5, 5,
  5, 0, 0, 224, 160, 240, 160, 240, 1, 2, 2, 2, 0, 3, 128, 128,
  255, 255, 255, 3, 3, 3, 4, 0, 1, 64, 224, 64, 1, 2, 2, 2,
  0, 0, 128, 128, 3, 1, 1, 4, 0, 2, 224, 1, 1, 1, 2, 0,
  0, 128, 255, 3, 5, 5, 4, 0, 0, 224, 160, 160, 160, 224, 2, 5,
  5, 3, 0, 0, 192, 64, 64, 64, 64, 3, 5, 5, 4, 0, 0, 224,
  32, 224, 128, 224, 3, 5, 5, 4, 0, 0, 224, 32, 224, 32, 224, 3,
  5, 5, 4, 0, 0, 160, 160, 224, 32, 32, 3, 5, 5, 4, 0, 0,
  224, 128, 224, 32, 224, 3, 5, 5, 4, 0, 0, 224, 128, 224, 160, 224,
  3, 5, 5, 4, 0, 0, 224, 32, 32, 32, 32, 3, 5, 5, 4, 0,
  0, 224, 160, 224, 160, 224, 3, 5, 5, 4, 0, 0, 224, 160, 224, 32,
  224, 1, 3, 3, 2, 0, 0, 128, 0, 128, 1, 4, 4, 2, 0, 255,
  128, 0, 128, 128, 255, 3, 3, 3, 4, 0, 1, 224, 0, 224, 255, 3,
  5, 5, 4, 0, 0, 224, 32, 96, 0, 64, 5, 5, 5, 6, 0, 0,
  248, 136, 184, 168, 240, 3, 5, 5, 4, 0, 0, 224, 160, 160, 224, 160,
  3, 5, 5, 4, 0, 0, 224, 160, 224, 160, 224, 3, 5, 5, 4, 0,
  0, 224, 128, 128, 128, 224, 3, 5, 5, 4, 0, 0, 192, 160, 160, 160,
  192, 3, 5, 5, 4, 0, 0, 224, 128, 224, 128, 224, 3, 5, 5, 4,
  0, 0, 224, 128, 224, 128, 128, 3, 5, 5, 4, 0, 0, 224, 128, 160,
  160, 224, 3, 5, 5, 4, 0, 0, 160, 160, 160, 224, 160, 3, 5, 5,
  4, 0, 0, 224, 64, 64, 64, 224, 3, 5, 5, 4, 0, 0, 32, 32,
  32, 160, 224, 3, 5, 5, 4, 0, 0, 160, 160, 160, 192, 160, 3, 5,
  5, 4, 0, 0, 128, 128, 128, 128, 224, 3, 5, 5, 4, 0, 0, 160,
  224, 160, 160, 160, 3, 5, 5, 4, 0, 0, 224, 160, 160, 160, 160, 3,
  5, 5, 4, 0, 0, 224, 160, 160, 160, 224, 3, 5, 5, 4, 0, 0,
  224, 160, 160, 224, 128, 3, 5, 5, 4, 0, 0, 224, 160, 160, 224, 64,
  3, 5, 5, 4, 0, 0, 224, 160, 160, 192, 160, 3, 5, 5, 4, 0,
  0, 224, 128, 224, 32, 224, 3, 5, 5, 4, 0, 0, 224, 64, 64, 64,
  64, 3, 5, 5, 4, 0, 0, 160, 160, 160, 160, 224, 3, 5, 5, 4,
  0, 0, 160, 160, 160, 160, 64, 3, 5, 5, 4, 0, 0, 160, 160, 160,
  224, 224, 3, 5, 5, 4, 0, 0, 160, 160, 64, 160, 160, 3, 5, 5,
  4, 0, 0, 160, 160, 160, 64, 64, 3, 5, 5, 4, 0, 0, 224, 32,
  224, 128, 224, 255, 255, 255, 255, 3, 1, 1, 4, 0, 0, 224, 255, 3,
  3, 3, 4, 0, 0, 96, 160, 224, 3, 5, 5, 4, 0, 0, 128, 128,
  224, 160, 224, 3, 3, 3, 4, 0, 0, 224, 128, 224, 3, 5, 5, 4,
  0, 0, 32, 32, 224, 160, 224, 3, 3, 3, 4, 0, 0, 224, 160, 192,
  3, 5, 5, 4, 0, 0, 96, 64, 224, 64, 64, 3, 4, 4, 4, 0,
  255, 224, 160, 224, 64, 3, 5, 5, 4, 0, 0, 128, 128, 224, 160, 160,
  1, 5, 5, 2, 0, 0, 128, 0, 128, 128, 128, 2, 5, 5, 3, 0,
  0, 64, 0, 64, 64, 192, 3, 5, 5, 4, 0, 0, 128, 128, 160, 192,
  160, 1, 5, 5, 2, 0, 0, 128, 128, 128, 128, 128, 5, 3, 3, 6,
  0, 0, 248, 168, 168, 3, 3, 3, 4, 0, 0, 192, 160, 160, 3, 3,
  3, 4, 0, 0, 224, 160, 224, 3, 4, 4, 4, 0, 255, 224, 160, 224,
  128, 3, 4, 4, 4, 0, 255, 224, 160, 224, 32, 3, 3, 3, 4, 0,
  0, 224, 128, 128, 3, 3, 3, 4, 0, 0, 96, 64, 192, 3, 5, 5,
  4, 0, 0, 64, 224, 64, 64, 96, 3, 3, 3, 4, 0, 0, 160, 160,
  224, 3, 3, 3, 4, 0, 0, 160, 160, 64, 5, 3, 3, 6, 0, 0,
  168, 168, 80, 3, 3, 3, 4, 0, 0, 160, 64, 160, 3, 4, 4, 4,
  0, 255, 160, 160, 224, 32, 3, 3, 3, 4, 0, 0, 224, 64, 224, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255
};

/*
  Fontname: -FreeType-Blipfest 07-Medium-R-Normal--8-80-72-72-P-33-ISO10646-1
  Copyright: Copyright cwillmor 2008
  Capital A Height: 0, '1' Height: 5
  Calculated Max Values w= 3 h= 5 x= 0 y= 2 dx= 4 dy= 0 ascent= 5 len= 5
  Font Bounding box     w= 5 h= 6 x= 0 y=-1
  Calculated Min Values           x= 0 y= 0 dx= 0 dy= 0
  Pure Font   ascent = 5 descent= 0
  X Font      ascent = 5 descent= 0
  Max Font    ascent = 5 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_blipfest_07n[169] U8G_FONT_SECTION("u8g_font_blipfest_07n") = {
  0, 5, 6, 0, 255, 5, 0, 0, 0, 0, 42, 58, 0, 5, 0, 5,
  0, 255, 3, 3, 3, 4, 0, 1, 64, 224, 64, 1, 2, 2, 2, 0,
  0, 128, 128, 3, 1, 1, 4, 0, 2, 224, 1, 1, 1, 2, 0, 0,
  128, 255, 3, 5, 5, 4, 0, 0, 224, 160, 160, 160, 224, 2, 5, 5,
  3, 0, 0, 192, 64, 64, 64, 64, 3, 5, 5, 4, 0, 0, 224, 32,
  224, 128, 224, 3, 5, 5, 4, 0, 0, 224, 32, 224, 32, 224, 3, 5,
  5, 4, 0, 0, 160, 160, 224, 32, 32, 3, 5, 5, 4, 0, 0, 224,
  128, 224, 32, 224, 3, 5, 5, 4, 0, 0, 224, 128, 224, 160, 224, 3,
  5, 5, 4, 0, 0, 224, 32, 32, 32, 32, 3, 5, 5, 4, 0, 0,
  224, 160, 224, 160, 224, 3, 5, 5, 4, 0, 0, 224, 160, 224, 32, 224,
  1, 3, 3, 2, 0, 0, 128, 0, 128
};

/*
  Fontname: -FreeType-Blipfest 07-Medium-R-Normal--8-80-72-72-P-33-ISO10646-1
  Copyright: Copyright cwillmor 2008
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 5 h= 5 x= 0 y= 3 dx= 6 dy= 0 ascent= 5 len= 5
  Font Bounding box     w= 5 h= 6 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-1
  X Font      ascent = 5 descent=-1
  Max Font    ascent = 5 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_blipfest_07r[820] U8G_FONT_SECTION("u8g_font_blipfest_07r") = {
  0, 5, 6, 0, 255, 5, 1, 5, 2, 47, 32, 127, 255, 5, 255, 5,
  255, 0, 0, 0, 1, 0, 0, 1, 5, 5, 2, 0, 0, 128, 128, 128,
  0, 128, 3, 2, 2, 4, 0, 3, 160, 160, 255, 255, 255, 4, 5, 5,
  5, 0, 0, 224, 160, 240, 160, 240, 1, 2, 2, 2, 0, 3, 128, 128,
  255, 255, 255, 3, 3, 3, 4, 0, 1, 64, 224, 64, 1, 2, 2, 2,
  0, 0, 128, 128, 3, 1, 1, 4, 0, 2, 224, 1, 1, 1, 2, 0,
  0, 128, 255, 3, 5, 5, 4, 0, 0, 224, 160, 160, 160, 224, 2, 5,
  5, 3, 0, 0, 192, 64, 64, 64, 64, 3, 5, 5, 4, 0, 0, 224,
  32, 224, 128, 224, 3, 5, 5, 4, 0, 0, 224, 32, 224, 32, 224, 3,
  5, 5, 4, 0, 0, 160, 160, 224, 32, 32, 3, 5, 5, 4, 0, 0,
  224, 128, 224, 32, 224, 3, 5, 5, 4, 0, 0, 224, 128, 224, 160, 224,
  3, 5, 5, 4, 0, 0, 224, 32, 32, 32, 32, 3, 5, 5, 4, 0,
  0, 224, 160, 224, 160, 224, 3, 5, 5, 4, 0, 0, 224, 160, 224, 32,
  224, 1, 3, 3, 2, 0, 0, 128, 0, 128, 1, 4, 4, 2, 0, 255,
  128, 0, 128, 128, 255, 3, 3, 3, 4, 0, 1, 224, 0, 224, 255, 3,
  5, 5, 4, 0, 0, 224, 32, 96, 0, 64, 5, 5, 5, 6, 0, 0,
  248, 136, 184, 168, 240, 3, 5, 5, 4, 0, 0, 224, 160, 160, 224, 160,
  3, 5, 5, 4, 0, 0, 224, 160, 224, 160, 224, 3, 5, 5, 4, 0,
  0, 224, 128, 128, 128, 224, 3, 5, 5, 4, 0, 0, 192, 160, 160, 160,
  192, 3, 5, 5, 4, 0, 0, 224, 128, 224, 128, 224, 3, 5, 5, 4,
  0, 0, 224, 128, 224, 128, 128, 3, 5, 5, 4, 0, 0, 224, 128, 160,
  160, 224, 3, 5, 5, 4, 0, 0, 160, 160, 160, 224, 160, 3, 5, 5,
  4, 0, 0, 224, 64, 64, 64, 224, 3, 5, 5, 4, 0, 0, 32, 32,
  32, 160, 224, 3, 5, 5, 4, 0, 0, 160, 160, 160, 192, 160, 3, 5,
  5, 4, 0, 0, 128, 128, 128, 128, 224, 3, 5, 5, 4, 0, 0, 160,
  224, 160, 160, 160, 3, 5, 5, 4, 0, 0, 224, 160, 160, 160, 160, 3,
  5, 5, 4, 0, 0, 224, 160, 160, 160, 224, 3, 5, 5, 4, 0, 0,
  224, 160, 160, 224, 128, 3, 5, 5, 4, 0, 0, 224, 160, 160, 224, 64,
  3, 5, 5, 4, 0, 0, 224, 160, 160, 192, 160, 3, 5, 5, 4, 0,
  0, 224, 128, 224, 32, 224, 3, 5, 5, 4, 0, 0, 224, 64, 64, 64,
  64, 3, 5, 5, 4, 0, 0, 160, 160, 160, 160, 224, 3, 5, 5, 4,
  0, 0, 160, 160, 160, 160, 64, 3, 5, 5, 4, 0, 0, 160, 160, 160,
  224, 224, 3, 5, 5, 4, 0, 0, 160, 160, 64, 160, 160, 3, 5, 5,
  4, 0, 0, 160, 160, 160, 64, 64, 3, 5, 5, 4, 0, 0, 224, 32,
  224, 128, 224, 255, 255, 255, 255, 3, 1, 1, 4, 0, 0, 224, 255, 3,
  3, 3, 4, 0, 0, 96, 160, 224, 3, 5, 5, 4, 0, 0, 128, 128,
  224, 160, 224, 3, 3, 3, 4, 0, 0, 224, 128, 224, 3, 5, 5, 4,
  0, 0, 32, 32, 224, 160, 224, 3, 3, 3, 4, 0, 0, 224, 160, 192,
  3, 5, 5, 4, 0, 0, 96, 64, 224, 64, 64, 3, 4, 4, 4, 0,
  255, 224, 160, 224, 64, 3, 5, 5, 4, 0, 0, 128, 128, 224, 160, 160,
  1, 5, 5, 2, 0, 0, 128, 0, 128, 128, 128, 2, 5, 5, 3, 0,
  0, 64, 0, 64, 64, 192, 3, 5, 5, 4, 0, 0, 128, 128, 160, 192,
  160, 1, 5, 5, 2, 0, 0, 128, 128, 128, 128, 128, 5, 3, 3, 6,
  0, 0, 248, 168, 168, 3, 3, 3, 4, 0, 0, 192, 160, 160, 3, 3,
  3, 4, 0, 0, 224, 160, 224, 3, 4, 4, 4, 0, 255, 224, 160, 224,
  128, 3, 4, 4, 4, 0, 255, 224, 160, 224, 32, 3, 3, 3, 4, 0,
  0, 224, 128, 128, 3, 3, 3, 4, 0, 0, 96, 64, 192, 3, 5, 5,
  4, 0, 0, 64, 224, 64, 64, 96, 3, 3, 3, 4, 0, 0, 160, 160,
  224, 3, 3, 3, 4, 0, 0, 160, 160, 64, 5, 3, 3, 6, 0, 0,
  168, 168, 80, 3, 3, 3, 4, 0, 0, 160, 64, 160, 3, 4, 4, 4,
  0, 255, 160, 160, 224, 32, 3, 3, 3, 4, 0, 0, 224, 64, 224, 255,
  255, 255, 255, 255
};

/*
  Fontname: -FreeType-Chikita-Medium-R-Normal--8-80-72-72-P-47-ISO10646-1
  Copyright: Copyright southernmedia 2008 "Chikita" is based on "pixelspace 5x5" by "David Chiu" (http://fontstruct.com/fontstructors/skyleth)
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 9 h= 8 x= 1 y= 6 dx=10 dy= 0 ascent= 8 len=10
  Font Bounding box     w= 9 h=10 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-2
  X Font      ascent = 6 descent=-2
  Max Font    ascent = 8 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_chikita[2236] U8G_FONT_SECTION("u8g_font_chikita") = {
  0, 9, 10, 0, 254, 5, 1, 107, 2, 195, 32, 255, 254, 8, 254, 6,
  254, 0, 0, 0, 2, 0, 0, 1, 7, 7, 2, 0, 255, 128, 128, 128,
  128, 128, 0, 128, 3, 2, 2, 4, 0, 4, 160, 160, 5, 5, 5, 6,
  0, 0, 80, 248, 80, 248, 80, 5, 7, 7, 6, 0, 255, 32, 120, 160,
  112, 40, 240, 32, 5, 5, 5, 6, 0, 0, 200, 208, 32, 88, 152, 5,
  5, 5, 6, 0, 0, 32, 80, 104, 144, 104, 1, 2, 2, 2, 0, 4,
  128, 128, 3, 7, 7, 4, 0, 255, 32, 64, 128, 128, 128, 64, 32, 3,
  7, 7, 4, 0, 255, 128, 64, 32, 32, 32, 64, 128, 3, 3, 3, 5,
  1, 1, 160, 64, 160, 5, 5, 5, 6, 0, 0, 32, 32, 248, 32, 32,
  2, 2, 2, 3, 0, 255, 64, 128, 5, 1, 1, 6, 0, 2, 248, 1,
  1, 1, 2, 0, 0, 128, 3, 5, 5, 5, 1, 0, 32, 32, 64, 128,
  128, 4, 5, 5, 5, 0, 0, 96, 144, 144, 144, 96, 2, 5, 5, 3,
  0, 0, 64, 192, 64, 64, 64, 5, 5, 5, 6, 0, 0, 112, 136, 48,
  64, 248, 5, 5, 5, 6, 0, 0, 240, 8, 112, 8, 240, 5, 5, 5,
  6, 0, 0, 48, 80, 144, 248, 16, 5, 5, 5, 6, 0, 0, 248, 128,
  240, 8, 240, 5, 5, 5, 6, 0, 0, 120, 128, 240, 136, 112, 5, 5,
  5, 6, 0, 0, 248, 8, 16, 32, 64, 5, 5, 5, 6, 0, 0, 112,
  136, 112, 136, 112, 5, 5, 5, 6, 0, 0, 112, 136, 120, 8, 240, 1,
  3, 3, 2, 0, 1, 128, 0, 128, 1, 4, 4, 2, 0, 0, 128, 0,
  128, 128, 5, 5, 5, 6, 0, 0, 24, 96, 128, 96, 24, 5, 3, 3,
  6, 0, 1, 248, 0, 248, 5, 5, 5, 6, 0, 0, 192, 48, 8, 48,
  192, 5, 7, 7, 6, 0, 255, 112, 136, 16, 32, 32, 0, 32, 7, 7,
  7, 8, 0, 255, 124, 130, 154, 170, 190, 128, 124, 5, 5, 5, 6, 0,
  0, 112, 136, 136, 248, 136, 5, 5, 5, 6, 0, 0, 240, 136, 240, 136,
  240, 5, 5, 5, 6, 0, 0, 112, 136, 128, 136, 112, 5, 5, 5, 6,
  0, 0, 240, 136, 136, 136, 240, 5, 5, 5, 6, 0, 0, 248, 128, 240,
  128, 248, 5, 5, 5, 6, 0, 0, 248, 128, 240, 128, 128, 5, 5, 5,
  6, 0, 0, 112, 128, 184, 136, 112, 5, 5, 5, 6, 0, 0, 136, 136,
  248, 136, 136, 3, 5, 5, 4, 0, 0, 224, 64, 64, 64, 224, 5, 5,
  5, 6, 0, 0, 8, 8, 8, 136, 112, 5, 5, 5, 6, 0, 0, 136,
  144, 224, 144, 136, 5, 5, 5, 6, 0, 0, 128, 128, 128, 128, 248, 5,
  5, 5, 6, 0, 0, 136, 216, 168, 136, 136, 5, 5, 5, 6, 0, 0,
  136, 200, 168, 152, 136, 5, 5, 5, 6, 0, 0, 112, 136, 136, 136, 112,
  5, 5, 5, 6, 0, 0, 240, 136, 136, 240, 128, 5, 5, 5, 6, 0,
  0, 112, 136, 136, 152, 120, 5, 5, 5, 6, 0, 0, 240, 136, 136, 240,
  136, 5, 5, 5, 6, 0, 0, 120, 128, 112, 8, 240, 5, 5, 5, 6,
  0, 0, 248, 32, 32, 32, 32, 5, 5, 5, 6, 0, 0, 136, 136, 136,
  136, 112, 5, 5, 5, 6, 0, 0, 136, 136, 136, 80, 32, 5, 5, 5,
  6, 0, 0, 136, 168, 168, 168, 80, 5, 5, 5, 6, 0, 0, 136, 80,
  32, 80, 136, 5, 5, 5, 6, 0, 0, 136, 136, 80, 32, 32, 5, 5,
  5, 6, 0, 0, 248, 16, 32, 64, 248, 2, 6, 6, 3, 0, 255, 192,
  128, 128, 128, 128, 192, 3, 5, 5, 4, 0, 0, 128, 128, 64, 32, 32,
  2, 6, 6, 3, 0, 255, 192, 64, 64, 64, 64, 192, 3, 2, 2, 4,
  0, 4, 64, 160, 5, 1, 1, 6, 0, 255, 248, 2, 2, 2, 3, 0,
  4, 128, 64, 4, 4, 4, 5, 0, 0, 112, 144, 144, 240, 4, 5, 5,
  5, 0, 0, 128, 224, 144, 144, 224, 4, 4, 4, 5, 0, 0, 112, 128,
  128, 112, 4, 5, 5, 5, 0, 0, 16, 112, 144, 144, 112, 4, 4, 4,
  5, 0, 0, 96, 144, 224, 112, 4, 5, 5, 5, 0, 0, 48, 64, 240,
  64, 64, 4, 6, 6, 5, 0, 254, 112, 144, 144, 240, 16, 224, 4, 5,
  5, 5, 0, 0, 128, 224, 144, 144, 144, 1, 5, 5, 2, 0, 0, 128,
  0, 128, 128, 128, 2, 7, 7, 3, 0, 254, 64, 0, 64, 64, 64, 64,
  128, 4, 5, 5, 5, 0, 0, 128, 144, 160, 224, 144, 1, 5, 5, 2,
  0, 0, 128, 128, 128, 128, 128, 6, 4, 4, 7, 0, 0, 168, 212, 148,
  148, 4, 4, 4, 5, 0, 0, 160, 208, 144, 144, 4, 4, 4, 5, 0,
  0, 96, 144, 144, 96, 4, 6, 6, 5, 0, 254, 224, 144, 144, 224, 128,
  128, 4, 6, 6, 5, 0, 254, 112, 144, 144, 112, 16, 16, 4, 4, 4,
  5, 0, 0, 176, 192, 128, 128, 4, 4, 4, 5, 0, 0, 112, 192, 48,
  224, 4, 5, 5, 5, 0, 0, 64, 240, 64, 64, 48, 4, 4, 4, 5,
  0, 0, 144, 144, 144, 112, 5, 4, 4, 6, 0, 0, 136, 136, 80, 32,
  5, 4, 4, 6, 0, 0, 136, 136, 168, 80, 4, 4, 4, 5, 0, 0,
  144, 96, 96, 144, 4, 6, 6, 5, 0, 254, 144, 144, 144, 112, 16, 224,
  4, 4, 4, 5, 0, 0, 240, 32, 64, 240, 3, 6, 6, 4, 0, 255,
  96, 64, 128, 128, 64, 96, 1, 6, 6, 2, 0, 255, 128, 128, 128, 128,
  128, 128, 3, 6, 6, 4, 0, 255, 192, 64, 32, 32, 64, 192, 5, 3,
  3, 6, 0, 1, 64, 168, 16, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 1, 7, 7, 2, 0, 255, 128,
  0, 128, 128, 128, 128, 128, 3, 5, 5, 4, 0, 0, 64, 224, 128, 224,
  64, 5, 6, 6, 6, 0, 0, 112, 136, 72, 224, 64, 248, 5, 5, 5,
  6, 0, 0, 136, 112, 80, 112, 136, 5, 6, 6, 6, 0, 0, 136, 80,
  32, 112, 112, 32, 1, 5, 5, 2, 0, 0, 128, 128, 0, 128, 128, 4,
  7, 7, 5, 0, 254, 112, 128, 96, 144, 96, 16, 224, 3, 1, 1, 4,
  0, 6, 160, 7, 7, 7, 8, 0, 255, 124, 130, 186, 162, 186, 130, 124,
  3, 4, 4, 4, 0, 4, 96, 224, 160, 96, 6, 5, 5, 7, 0, 0,
  36, 72, 144, 72, 36, 5, 3, 3, 6, 0, 2, 248, 8, 8, 3, 1,
  1, 5, 1, 2, 224, 7, 7, 7, 8, 0, 255, 124, 130, 186, 178, 170,
  130, 124, 5, 1, 1, 6, 0, 6, 248, 4, 4, 4, 5, 0, 3, 96,
  144, 144, 96, 3, 5, 5, 5, 1, 0, 64, 224, 64, 0, 224, 4, 5,
  5, 5, 0, 2, 96, 144, 32, 64, 240, 4, 5, 5, 5, 0, 2, 224,
  16, 96, 16, 224, 2, 2, 2, 3, 0, 5, 64, 128, 5, 6, 6, 6,
  0, 254, 136, 136, 216, 168, 128, 128, 6, 7, 7, 7, 0, 254, 124, 232,
  232, 104, 40, 40, 40, 3, 3, 3, 5, 1, 1, 224, 224, 224, 3, 3,
  3, 5, 1, 254, 64, 32, 224, 2, 5, 5, 3, 0, 2, 64, 192, 64,
  64, 64, 4, 5, 5, 5, 0, 2, 96, 144, 144, 144, 96, 6, 5, 5,
  7, 0, 0, 144, 72, 36, 72, 144, 7, 8, 8, 8, 0, 254, 66, 196,
  72, 80, 38, 74, 142, 2, 7, 8, 8, 8, 0, 254, 66, 196, 72, 80,
  44, 66, 132, 14, 7, 8, 8, 8, 0, 254, 226, 68, 40, 208, 38, 74,
  142, 2, 5, 7, 7, 6, 0, 255, 32, 0, 32, 32, 72, 136, 112, 5,
  8, 8, 6, 0, 0, 64, 32, 0, 112, 136, 136, 248, 136, 5, 8, 8,
  6, 0, 0, 16, 32, 0, 112, 136, 136, 248, 136, 5, 8, 8, 6, 0,
  0, 32, 80, 0, 112, 136, 136, 248, 136, 5, 8, 8, 6, 0, 0, 40,
  80, 0, 112, 136, 136, 248, 136, 5, 7, 7, 6, 0, 0, 80, 0, 112,
  136, 136, 248, 136, 5, 8, 8, 6, 0, 0, 32, 80, 32, 112, 136, 136,
  248, 136, 9, 5, 10, 10, 0, 0, 63, 128, 72, 0, 143, 0, 248, 0,
  143, 128, 5, 7, 7, 6, 0, 254, 112, 136, 128, 136, 112, 16, 112, 5,
  8, 8, 6, 0, 0, 64, 32, 0, 248, 128, 240, 128, 248, 5, 8, 8,
  6, 0, 0, 16, 32, 0, 248, 128, 240, 128, 248, 5, 8, 8, 6, 0,
  0, 32, 80, 0, 248, 128, 240, 128, 248, 5, 7, 7, 6, 0, 0, 80,
  0, 248, 128, 240, 128, 248, 3, 8, 8, 4, 0, 0, 128, 64, 0, 224,
  64, 64, 64, 224, 3, 8, 8, 4, 0, 0, 32, 64, 0, 224, 64, 64,
  64, 224, 3, 8, 8, 4, 0, 0, 64, 160, 0, 224, 64, 64, 64, 224,
  3, 7, 7, 4, 0, 0, 160, 0, 224, 64, 64, 64, 224, 5, 5, 5,
  6, 0, 0, 112, 72, 232, 72, 112, 5, 8, 8, 6, 0, 0, 40, 80,
  0, 136, 200, 168, 152, 136, 5, 8, 8, 6, 0, 0, 64, 32, 0, 112,
  136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 16, 32, 0, 112, 136, 136,
  136, 112, 5, 8, 8, 6, 0, 0, 32, 80, 0, 112, 136, 136, 136, 112,
  5, 8, 8, 6, 0, 0, 64, 168, 16, 112, 136, 136, 136, 112, 5, 7,
  7, 6, 0, 0, 80, 0, 112, 136, 136, 136, 112, 3, 3, 3, 4, 0,
  1, 160, 64, 160, 5, 5, 5, 6, 0, 0, 120, 152, 168, 200, 240, 5,
  8, 8, 6, 0, 0, 64, 32, 0, 136, 136, 136, 136, 112, 5, 8, 8,
  6, 0, 0, 16, 32, 0, 136, 136, 136, 136, 112, 5, 8, 8, 6, 0,
  0, 32, 80, 0, 136, 136, 136, 136, 112, 5, 7, 7, 6, 0, 0, 80,
  0, 136, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 16, 32, 0, 136,
  136, 80, 32, 32, 5, 5, 5, 6, 0, 0, 128, 240, 136, 240, 128, 4,
  5, 5, 5, 0, 0, 96, 144, 160, 144, 160, 4, 7, 7, 5, 0, 0,
  64, 32, 0, 112, 144, 144, 240, 4, 7, 7, 5, 0, 0, 32, 64, 0,
  112, 144, 144, 240, 4, 7, 7, 5, 0, 0, 32, 80, 0, 112, 144, 144,
  240, 4, 7, 7, 5, 0, 0, 80, 160, 0, 112, 144, 144, 240, 4, 6,
  6, 5, 0, 0, 80, 0, 112, 144, 144, 240, 4, 7, 7, 5, 0, 0,
  32, 80, 32, 112, 144, 144, 240, 7, 5, 5, 8, 0, 0, 236, 18, 126,
  144, 238, 4, 6, 6, 5, 0, 254, 112, 128, 128, 112, 32, 96, 4, 7,
  7, 5, 0, 0, 64, 32, 0, 96, 144, 224, 112, 4, 7, 7, 5, 0,
  0, 32, 64, 0, 96, 144, 224, 112, 4, 7, 7, 5, 0, 0, 32, 80,
  0, 96, 144, 224, 112, 4, 6, 6, 5, 0, 0, 80, 0, 96, 144, 224,
  112, 2, 7, 7, 3, 0, 0, 128, 64, 0, 64, 64, 64, 64, 2, 7,
  7, 3, 0, 0, 64, 128, 0, 128, 128, 128, 128, 3, 7, 7, 4, 0,
  0, 64, 160, 0, 64, 64, 64, 64, 3, 6, 6, 4, 0, 0, 160, 0,
  64, 64, 64, 64, 4, 6, 6, 5, 0, 0, 64, 32, 112, 144, 144, 96,
  4, 7, 7, 5, 0, 0, 80, 160, 0, 160, 208, 144, 144, 4, 7, 7,
  5, 0, 0, 64, 32, 0, 96, 144, 144, 96, 4, 7, 7, 5, 0, 0,
  32, 64, 0, 96, 144, 144, 96, 4, 7, 7, 5, 0, 0, 96, 144, 0,
  96, 144, 144, 96, 4, 7, 7, 5, 0, 0, 80, 160, 0, 96, 144, 144,
  96, 4, 6, 6, 5, 0, 0, 80, 0, 96, 144, 144, 96, 5, 5, 5,
  6, 0, 0, 32, 0, 248, 0, 32, 4, 4, 4, 5, 0, 0, 112, 176,
  208, 224, 4, 7, 7, 5, 0, 0, 64, 32, 0, 144, 144, 144, 112, 4,
  7, 7, 5, 0, 0, 32, 64, 0, 144, 144, 144, 112, 4, 7, 7, 5,
  0, 0, 32, 80, 0, 144, 144, 144, 112, 4, 6, 6, 5, 0, 0, 80,
  0, 144, 144, 144, 112, 4, 8, 8, 5, 0, 254, 32, 64, 0, 144, 144,
  112, 16, 224, 4, 6, 6, 5, 0, 254, 128, 224, 144, 144, 224, 128, 4,
  7, 7, 5, 0, 254, 80, 0, 144, 144, 112, 16, 224
};

/*
  Fontname: -FreeType-Chikita-Medium-R-Normal--8-80-72-72-P-47-ISO10646-1
  Copyright: Copyright southernmedia 2008  "Chikita" is based on "pixelspace 5x5" by "David Chiu" (http://fontstruct.com/fontstructors/skyleth)
  Capital A Height: 0, '1' Height: 5
  Calculated Max Values w= 5 h= 5 x= 1 y= 2 dx= 6 dy= 0 ascent= 5 len= 5
  Font Bounding box     w= 9 h=10 x= 0 y=-2
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 5 descent= 0
  X Font      ascent = 5 descent= 0
  Max Font    ascent = 5 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_chikitan[189] U8G_FONT_SECTION("u8g_font_chikitan") = {
  0, 9, 10, 0, 254, 5, 0, 0, 0, 0, 42, 58, 0, 5, 255, 5,
  0, 3, 3, 3, 5, 1, 1, 160, 64, 160, 5, 5, 5, 6, 0, 0,
  32, 32, 248, 32, 32, 2, 2, 2, 3, 0, 255, 64, 128, 5, 1, 1,
  6, 0, 2, 248, 1, 1, 1, 2, 0, 0, 128, 3, 5, 5, 5, 1,
  0, 32, 32, 64, 128, 128, 4, 5, 5, 5, 0, 0, 96, 144, 144, 144,
  96, 2, 5, 5, 3, 0, 0, 64, 192, 64, 64, 64, 5, 5, 5, 6,
  0, 0, 112, 136, 48, 64, 248, 5, 5, 5, 6, 0, 0, 240, 8, 112,
  8, 240, 5, 5, 5, 6, 0, 0, 48, 80, 144, 248, 16, 5, 5, 5,
  6, 0, 0, 248, 128, 240, 8, 240, 5, 5, 5, 6, 0, 0, 120, 128,
  240, 136, 112, 5, 5, 5, 6, 0, 0, 248, 8, 16, 32, 64, 5, 5,
  5, 6, 0, 0, 112, 136, 112, 136, 112, 5, 5, 5, 6, 0, 0, 112,
  136, 120, 8, 240, 1, 3, 3, 2, 0, 1, 128, 0, 128
};

/*
  Fontname: -FreeType-Chikita-Medium-R-Normal--8-80-72-72-P-47-ISO10646-1
  Copyright: Copyright southernmedia 2008  "Chikita" is based on "pixelspace 5x5" by "David Chiu" (http://fontstruct.com/fontstructors/skyleth)
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 7 h= 7 x= 1 y= 4 dx= 8 dy= 0 ascent= 6 len= 7
  Font Bounding box     w= 9 h=10 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-2
  X Font      ascent = 6 descent=-2
  Max Font    ascent = 6 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_chikitar[1032] U8G_FONT_SECTION("u8g_font_chikitar") = {
  0, 9, 10, 0, 254, 5, 1, 107, 2, 195, 32, 127, 254, 6, 254, 6,
  254, 0, 0, 0, 2, 0, 0, 1, 7, 7, 2, 0, 255, 128, 128, 128,
  128, 128, 0, 128, 3, 2, 2, 4, 0, 4, 160, 160, 5, 5, 5, 6,
  0, 0, 80, 248, 80, 248, 80, 5, 7, 7, 6, 0, 255, 32, 120, 160,
  112, 40, 240, 32, 5, 5, 5, 6, 0, 0, 200, 208, 32, 88, 152, 5,
  5, 5, 6, 0, 0, 32, 80, 104, 144, 104, 1, 2, 2, 2, 0, 4,
  128, 128, 3, 7, 7, 4, 0, 255, 32, 64, 128, 128, 128, 64, 32, 3,
  7, 7, 4, 0, 255, 128, 64, 32, 32, 32, 64, 128, 3, 3, 3, 5,
  1, 1, 160, 64, 160, 5, 5, 5, 6, 0, 0, 32, 32, 248, 32, 32,
  2, 2, 2, 3, 0, 255, 64, 128, 5, 1, 1, 6, 0, 2, 248, 1,
  1, 1, 2, 0, 0, 128, 3, 5, 5, 5, 1, 0, 32, 32, 64, 128,
  128, 4, 5, 5, 5, 0, 0, 96, 144, 144, 144, 96, 2, 5, 5, 3,
  0, 0, 64, 192, 64, 64, 64, 5, 5, 5, 6, 0, 0, 112, 136, 48,
  64, 248, 5, 5, 5, 6, 0, 0, 240, 8, 112, 8, 240, 5, 5, 5,
  6, 0, 0, 48, 80, 144, 248, 16, 5, 5, 5, 6, 0, 0, 248, 128,
  240, 8, 240, 5, 5, 5, 6, 0, 0, 120, 128, 240, 136, 112, 5, 5,
  5, 6, 0, 0, 248, 8, 16, 32, 64, 5, 5, 5, 6, 0, 0, 112,
  136, 112, 136, 112, 5, 5, 5, 6, 0, 0, 112, 136, 120, 8, 240, 1,
  3, 3, 2, 0, 1, 128, 0, 128, 1, 4, 4, 2, 0, 0, 128, 0,
  128, 128, 5, 5, 5, 6, 0, 0, 24, 96, 128, 96, 24, 5, 3, 3,
  6, 0, 1, 248, 0, 248, 5, 5, 5, 6, 0, 0, 192, 48, 8, 48,
  192, 5, 7, 7, 6, 0, 255, 112, 136, 16, 32, 32, 0, 32, 7, 7,
  7, 8, 0, 255, 124, 130, 154, 170, 190, 128, 124, 5, 5, 5, 6, 0,
  0, 112, 136, 136, 248, 136, 5, 5, 5, 6, 0, 0, 240, 136, 240, 136,
  240, 5, 5, 5, 6, 0, 0, 112, 136, 128, 136, 112, 5, 5, 5, 6,
  0, 0, 240, 136, 136, 136, 240, 5, 5, 5, 6, 0, 0, 248, 128, 240,
  128, 248, 5, 5, 5, 6, 0, 0, 248, 128, 240, 128, 128, 5, 5, 5,
  6, 0, 0, 112, 128, 184, 136, 112, 5, 5, 5, 6, 0, 0, 136, 136,
  248, 136, 136, 3, 5, 5, 4, 0, 0, 224, 64, 64, 64, 224, 5, 5,
  5, 6, 0, 0, 8, 8, 8, 136, 112, 5, 5, 5, 6, 0, 0, 136,
  144, 224, 144, 136, 5, 5, 5, 6, 0, 0, 128, 128, 128, 128, 248, 5,
  5, 5, 6, 0, 0, 136, 216, 168, 136, 136, 5, 5, 5, 6, 0, 0,
  136, 200, 168, 152, 136, 5, 5, 5, 6, 0, 0, 112, 136, 136, 136, 112,
  5, 5, 5, 6, 0, 0, 240, 136, 136, 240, 128, 5, 5, 5, 6, 0,
  0, 112, 136, 136, 152, 120, 5, 5, 5, 6, 0, 0, 240, 136, 136, 240,
  136, 5, 5, 5, 6, 0, 0, 120, 128, 112, 8, 240, 5, 5, 5, 6,
  0, 0, 248, 32, 32, 32, 32, 5, 5, 5, 6, 0, 0, 136, 136, 136,
  136, 112, 5, 5, 5, 6, 0, 0, 136, 136, 136, 80, 32, 5, 5, 5,
  6, 0, 0, 136, 168, 168, 168, 80, 5, 5, 5, 6, 0, 0, 136, 80,
  32, 80, 136, 5, 5, 5, 6, 0, 0, 136, 136, 80, 32, 32, 5, 5,
  5, 6, 0, 0, 248, 16, 32, 64, 248, 2, 6, 6, 3, 0, 255, 192,
  128, 128, 128, 128, 192, 3, 5, 5, 4, 0, 0, 128, 128, 64, 32, 32,
  2, 6, 6, 3, 0, 255, 192, 64, 64, 64, 64, 192, 3, 2, 2, 4,
  0, 4, 64, 160, 5, 1, 1, 6, 0, 255, 248, 2, 2, 2, 3, 0,
  4, 128, 64, 4, 4, 4, 5, 0, 0, 112, 144, 144, 240, 4, 5, 5,
  5, 0, 0, 128, 224, 144, 144, 224, 4, 4, 4, 5, 0, 0, 112, 128,
  128, 112, 4, 5, 5, 5, 0, 0, 16, 112, 144, 144, 112, 4, 4, 4,
  5, 0, 0, 96, 144, 224, 112, 4, 5, 5, 5, 0, 0, 48, 64, 240,
  64, 64, 4, 6, 6, 5, 0, 254, 112, 144, 144, 240, 16, 224, 4, 5,
  5, 5, 0, 0, 128, 224, 144, 144, 144, 1, 5, 5, 2, 0, 0, 128,
  0, 128, 128, 128, 2, 7, 7, 3, 0, 254, 64, 0, 64, 64, 64, 64,
  128, 4, 5, 5, 5, 0, 0, 128, 144, 160, 224, 144, 1, 5, 5, 2,
  0, 0, 128, 128, 128, 128, 128, 6, 4, 4, 7, 0, 0, 168, 212, 148,
  148, 4, 4, 4, 5, 0, 0, 160, 208, 144, 144, 4, 4, 4, 5, 0,
  0, 96, 144, 144, 96, 4, 6, 6, 5, 0, 254, 224, 144, 144, 224, 128,
  128, 4, 6, 6, 5, 0, 254, 112, 144, 144, 112, 16, 16, 4, 4, 4,
  5, 0, 0, 176, 192, 128, 128, 4, 4, 4, 5, 0, 0, 112, 192, 48,
  224, 4, 5, 5, 5, 0, 0, 64, 240, 64, 64, 48, 4, 4, 4, 5,
  0, 0, 144, 144, 144, 112, 5, 4, 4, 6, 0, 0, 136, 136, 80, 32,
  5, 4, 4, 6, 0, 0, 136, 136, 168, 80, 4, 4, 4, 5, 0, 0,
  144, 96, 96, 144, 4, 6, 6, 5, 0, 254, 144, 144, 144, 112, 16, 224,
  4, 4, 4, 5, 0, 0, 240, 32, 64, 240, 3, 6, 6, 4, 0, 255,
  96, 64, 128, 128, 64, 96, 1, 6, 6, 2, 0, 255, 128, 128, 128, 128,
  128, 128, 3, 6, 6, 4, 0, 255, 192, 64, 32, 32, 64, 192, 5, 3,
  3, 6, 0, 1, 64, 168, 16, 255
};

/*
  Fontname: -MUTT-ClearlyU-Medium-R-Normal--17-120-100-100-P-123-ISO10646-1
  Copyright: 2001 Computing Research Lab, New Mexico State University.
  Capital A Height: 3, '1' Height: 11
  Calculated Max Values w=16 h=17 x= 7 y= 6 dx=19 dy= 0 ascent=17 len=34
  Font Bounding box     w=40 h=30 x=-9 y=-10
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 3 descent= 1
  X Font      ascent =12 descent= 0
  Max Font    ascent =17 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_cu12_67_75[3981] U8G_FONT_SECTION("u8g_font_cu12_67_75") = {
  0, 40, 30, 247, 246, 3, 2, 98, 5, 14, 32, 255, 1, 17, 254, 12,
  0, 11, 5, 10, 12, 1, 4, 2, 128, 1, 64, 255, 224, 1, 64, 2,
  128, 5, 11, 11, 6, 1, 1, 32, 32, 32, 32, 32, 32, 168, 112, 168,
  112, 32, 11, 5, 10, 12, 1, 4, 32, 96, 65, 128, 255, 0, 65, 128,
  32, 96, 11, 5, 10, 12, 1, 4, 192, 128, 48, 64, 31, 224, 48, 64,
  192, 128, 11, 7, 14, 12, 1, 3, 0, 32, 32, 32, 64, 32, 255, 224,
  64, 32, 32, 32, 0, 32, 7, 11, 11, 8, 1, 1, 16, 56, 84, 16,
  16, 16, 16, 16, 16, 16, 254, 11, 7, 14, 12, 1, 3, 128, 0, 128,
  128, 128, 64, 255, 224, 128, 64, 128, 128, 128, 0, 7, 11, 11, 8, 1,
  1, 254, 16, 16, 16, 16, 16, 16, 16, 84, 56, 16, 7, 11, 11, 8,
  1, 1, 16, 56, 84, 16, 16, 16, 16, 16, 84, 56, 254, 11, 7, 14,
  12, 1, 4, 1, 192, 0, 32, 32, 32, 64, 32, 255, 192, 64, 0, 32,
  0, 11, 7, 14, 12, 1, 4, 112, 0, 128, 0, 128, 128, 128, 64, 127,
  224, 0, 64, 0, 128, 11, 7, 14, 12, 1, 4, 1, 192, 2, 32, 34,
  32, 66, 32, 255, 192, 66, 0, 34, 0, 11, 7, 14, 12, 1, 4, 112,
  0, 136, 0, 136, 128, 136, 64, 127, 224, 8, 64, 8, 128, 12, 5, 10,
  13, 1, 4, 38, 64, 73, 32, 233, 112, 80, 160, 32, 64, 12, 5, 10,
  13, 1, 4, 33, 64, 66, 32, 255, 240, 68, 32, 40, 64, 4, 11, 11,
  5, 1, 1, 16, 16, 32, 64, 176, 208, 32, 160, 160, 192, 240, 6, 11,
  11, 7, 1, 1, 32, 64, 252, 68, 36, 4, 4, 4, 4, 4, 4, 6,
  11, 11, 7, 1, 1, 16, 8, 252, 136, 144, 128, 128, 128, 128, 128, 128,
  6, 11, 11, 7, 1, 1, 4, 4, 4, 4, 4, 4, 36, 68, 252, 64,
  32, 6, 11, 11, 7, 1, 1, 128, 128, 128, 128, 128, 128, 144, 136, 252,
  8, 16, 8, 6, 6, 9, 1, 2, 252, 4, 4, 21, 14, 4, 6, 8,
  8, 7, 1, 1, 4, 4, 4, 36, 68, 252, 64, 32, 11, 8, 16, 11,
  1, 1, 15, 128, 16, 64, 32, 32, 32, 32, 32, 32, 168, 32, 112, 0,
  32, 0, 11, 8, 16, 11, 1, 1, 62, 0, 65, 0, 128, 128, 128, 128,
  128, 128, 130, 160, 1, 192, 0, 128, 9, 11, 22, 10, 1, 1, 255, 128,
  0, 0, 240, 0, 192, 0, 160, 0, 144, 0, 8, 0, 4, 0, 2, 0,
  1, 0, 0, 128, 12, 13, 26, 13, 1, 0, 128, 0, 144, 0, 160, 0,
  255, 240, 160, 0, 144, 0, 128, 16, 0, 144, 0, 80, 255, 240, 0, 80,
  0, 144, 0, 16, 10, 7, 14, 11, 1, 2, 3, 192, 67, 0, 130, 128,
  130, 128, 128, 128, 65, 0, 62, 0, 10, 7, 14, 11, 1, 2, 240, 0,
  48, 128, 80, 64, 80, 64, 64, 64, 32, 128, 31, 0, 11, 3, 6, 12,
  1, 6, 32, 0, 64, 0, 255, 224, 11, 3, 6, 12, 1, 6, 255, 224,
  64, 0, 32, 0, 3, 11, 11, 4, 1, 1, 128, 192, 160, 128, 128, 128,
  128, 128, 128, 128, 128, 3, 11, 11, 4, 1, 1, 32, 96, 160, 32, 32,
  32, 32, 32, 32, 32, 32, 11, 3, 6, 12, 1, 6, 0, 128, 0, 64,
  255, 224, 11, 3, 6, 12, 1, 6, 255, 224, 0, 64, 0, 128, 3, 11,
  11, 4, 1, 1, 128, 128, 128, 128, 128, 128, 128, 128, 160, 192, 128, 3,
  11, 11, 4, 1, 1, 32, 32, 32, 32, 32, 32, 32, 32, 160, 96, 32,
  11, 11, 22, 12, 1, 1, 0, 128, 0, 64, 255, 224, 0, 64, 0, 128,
  0, 0, 32, 0, 64, 0, 255, 224, 64, 0, 32, 0, 11, 11, 22, 12,
  1, 1, 32, 128, 112, 128, 168, 128, 32, 128, 32, 128, 32, 128, 32, 128,
  32, 128, 34, 160, 33, 192, 32, 128, 11, 11, 22, 12, 1, 1, 32, 0,
  64, 0, 255, 224, 64, 0, 32, 0, 0, 0, 0, 128, 0, 64, 255, 224,
  0, 64, 0, 128, 11, 11, 22, 12, 1, 1, 32, 0, 64, 0, 255, 224,
  64, 0, 32, 0, 0, 0, 32, 0, 64, 0, 255, 224, 64, 0, 32, 0,
  11, 11, 22, 12, 1, 1, 32, 128, 113, 192, 170, 160, 32, 128, 32, 128,
  32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 11, 11, 22, 12,
  1, 1, 0, 128, 0, 64, 255, 224, 0, 64, 0, 128, 0, 0, 0, 128,
  0, 64, 255, 224, 0, 64, 0, 128, 11, 11, 22, 12, 1, 1, 32, 128,
  32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 170, 160,
  113, 192, 32, 128, 11, 8, 16, 12, 1, 3, 32, 0, 64, 0, 255, 224,
  0, 0, 0, 0, 255, 224, 0, 64, 0, 128, 11, 8, 16, 12, 1, 3,
  0, 128, 0, 64, 255, 224, 0, 0, 0, 0, 255, 224, 64, 0, 32, 0,
  11, 7, 14, 12, 1, 3, 16, 128, 32, 128, 127, 224, 129, 0, 127, 224,
  34, 0, 18, 0, 13, 7, 14, 14, 1, 3, 17, 64, 33, 32, 127, 240,
  130, 8, 127, 240, 36, 32, 20, 64, 11, 7, 14, 12, 1, 3, 9, 0,
  8, 128, 255, 192, 16, 32, 255, 192, 32, 128, 33, 0, 11, 7, 14, 12,
  1, 3, 16, 0, 32, 0, 127, 224, 128, 0, 127, 224, 32, 0, 16, 0,
  7, 11, 11, 8, 1, 1, 16, 40, 108, 170, 40, 40, 40, 40, 40, 40,
  40, 11, 7, 14, 12, 1, 3, 1, 0, 0, 128, 255, 192, 0, 32, 255,
  192, 0, 128, 1, 0, 7, 11, 11, 8, 1, 1, 40, 40, 40, 40, 40,
  40, 40, 170, 108, 40, 16, 12, 7, 14, 12, 1, 3, 16, 128, 32, 64,
  127, 224, 128, 16, 127, 224, 32, 64, 16, 128, 7, 12, 12, 8, 1, 0,
  16, 40, 108, 170, 40, 40, 40, 40, 170, 108, 40, 16, 10, 10, 20, 11,
  1, 1, 248, 0, 144, 0, 136, 0, 196, 0, 162, 0, 17, 0, 8, 128,
  4, 64, 2, 0, 1, 0, 10, 10, 20, 11, 1, 1, 7, 192, 2, 64,
  4, 64, 8, 192, 17, 64, 34, 0, 68, 0, 136, 0, 16, 0, 32, 0,
  10, 10, 20, 11, 1, 1, 32, 0, 16, 0, 136, 0, 68, 0, 34, 0,
  17, 64, 8, 192, 4, 64, 2, 64, 7, 192, 10, 10, 20, 11, 1, 1,
  1, 0, 2, 0, 4, 64, 8, 128, 17, 0, 162, 0, 196, 0, 136, 0,
  144, 0, 248, 0, 11, 7, 14, 12, 1, 3, 16, 0, 63, 224, 64, 0,
  255, 224, 64, 0, 63, 224, 16, 0, 11, 7, 14, 12, 1, 3, 1, 0,
  255, 128, 0, 64, 255, 224, 0, 64, 255, 128, 1, 0, 12, 5, 10, 13,
  1, 4, 32, 0, 72, 128, 245, 80, 66, 32, 32, 0, 12, 5, 10, 13,
  1, 4, 0, 64, 17, 32, 170, 240, 68, 32, 0, 64, 5, 11, 11, 6,
  1, 1, 32, 112, 168, 32, 32, 248, 32, 248, 32, 32, 32, 5, 11, 11,
  6, 1, 1, 32, 32, 32, 248, 32, 248, 32, 32, 168, 112, 32, 11, 5,
  10, 12, 1, 4, 32, 0, 64, 0, 238, 224, 64, 0, 32, 0, 5, 11,
  11, 6, 1, 1, 32, 112, 168, 0, 32, 32, 32, 0, 32, 32, 32, 11,
  5, 10, 12, 1, 4, 0, 128, 0, 64, 238, 224, 0, 64, 0, 128, 5,
  11, 11, 6, 1, 1, 32, 32, 32, 0, 32, 32, 32, 0, 168, 112, 32,
  12, 7, 14, 13, 1, 3, 128, 0, 144, 0, 160, 0, 255, 240, 160, 0,
  144, 0, 128, 0, 12, 7, 14, 13, 1, 3, 0, 16, 0, 144, 0, 80,
  255, 240, 0, 80, 0, 144, 0, 16, 12, 9, 18, 13, 1, 2, 8, 0,
  24, 0, 47, 240, 64, 16, 128, 16, 64, 16, 47, 240, 24, 0, 8, 0,
  9, 12, 24, 10, 1, 1, 8, 0, 20, 0, 34, 0, 65, 0, 227, 128,
  34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 62, 0, 12, 9,
  18, 13, 1, 2, 1, 0, 1, 128, 255, 64, 128, 32, 128, 16, 128, 32,
  255, 64, 1, 128, 1, 0, 9, 12, 24, 10, 1, 1, 62, 0, 34, 0,
  34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 227, 128, 65, 0, 34, 0,
  20, 0, 8, 0, 9, 17, 34, 10, 1, 0, 8, 0, 20, 0, 34, 0,
  65, 0, 227, 128, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 34, 0,
  62, 0, 0, 0, 62, 0, 34, 0, 34, 0, 62, 0, 9, 14, 28, 10,
  1, 0, 8, 0, 20, 0, 34, 0, 65, 0, 227, 128, 34, 0, 34, 0,
  34, 0, 34, 0, 34, 0, 34, 0, 227, 128, 128, 128, 255, 128, 9, 14,
  28, 10, 1, 0, 8, 0, 20, 0, 62, 0, 65, 0, 227, 128, 34, 0,
  34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 227, 128, 128, 128, 255, 128,
  9, 14, 28, 10, 1, 0, 8, 0, 28, 0, 42, 0, 73, 0, 235, 128,
  42, 0, 42, 0, 42, 0, 42, 0, 42, 0, 42, 0, 235, 128, 136, 128,
  255, 128, 9, 15, 30, 10, 1, 2, 8, 0, 20, 0, 34, 0, 73, 0,
  213, 128, 34, 0, 65, 0, 227, 128, 34, 0, 34, 0, 34, 0, 34, 0,
  34, 0, 34, 0, 62, 0, 9, 17, 34, 10, 1, 0, 8, 0, 20, 0,
  34, 0, 73, 0, 213, 128, 34, 0, 65, 0, 227, 128, 34, 0, 34, 0,
  34, 0, 34, 0, 34, 0, 34, 0, 227, 128, 128, 128, 255, 128, 14, 9,
  18, 16, 2, 2, 224, 64, 160, 96, 191, 208, 128, 24, 128, 20, 128, 24,
  191, 208, 160, 96, 224, 64, 11, 11, 22, 12, 1, 1, 255, 224, 128, 0,
  188, 0, 176, 0, 168, 0, 164, 0, 130, 0, 129, 0, 128, 128, 128, 64,
  128, 32, 11, 11, 22, 12, 1, 1, 128, 32, 64, 32, 32, 32, 16, 32,
  8, 32, 4, 160, 2, 160, 1, 160, 7, 160, 0, 32, 255, 224, 9, 16,
  32, 10, 1, 0, 8, 0, 20, 0, 34, 0, 65, 0, 227, 128, 34, 0,
  34, 0, 34, 0, 34, 0, 34, 0, 34, 0, 227, 128, 65, 0, 34, 0,
  20, 0, 8, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  11, 11, 22, 14, 2, 1, 255, 224, 255, 224, 255, 224, 255, 224, 255, 224,
  255, 224, 255, 224, 255, 224, 255, 224, 255, 224, 255, 224, 11, 11, 22, 14,
  2, 1, 255, 224, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32,
  128, 32, 128, 32, 128, 32, 255, 224, 11, 11, 22, 14, 2, 1, 63, 128,
  64, 64, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32,
  64, 64, 63, 128, 11, 11, 22, 14, 2, 1, 255, 224, 128, 32, 191, 160,
  191, 160, 191, 160, 191, 160, 191, 160, 191, 160, 191, 160, 128, 32, 255, 224,
  11, 11, 22, 14, 2, 1, 255, 224, 128, 32, 255, 224, 128, 32, 255, 224,
  128, 32, 255, 224, 128, 32, 255, 224, 128, 32, 255, 224, 11, 11, 22, 14,
  2, 1, 255, 224, 170, 160, 170, 160, 170, 160, 170, 160, 170, 160, 170, 160,
  170, 160, 170, 160, 170, 160, 255, 224, 11, 11, 22, 14, 2, 1, 255, 224,
  170, 160, 255, 224, 170, 160, 255, 224, 170, 160, 255, 224, 170, 160, 255, 224,
  170, 160, 255, 224, 11, 11, 22, 14, 2, 1, 255, 224, 201, 32, 164, 160,
  146, 96, 201, 32, 164, 160, 146, 96, 201, 32, 164, 160, 146, 96, 255, 224,
  11, 11, 22, 14, 2, 1, 255, 224, 146, 96, 164, 160, 201, 32, 146, 96,
  164, 160, 201, 32, 146, 96, 164, 160, 201, 32, 255, 224, 11, 11, 22, 14,
  2, 1, 255, 224, 213, 96, 170, 160, 213, 96, 170, 160, 213, 96, 170, 160,
  213, 96, 170, 160, 213, 96, 255, 224, 7, 7, 7, 12, 3, 3, 254, 254,
  254, 254, 254, 254, 254, 7, 7, 7, 12, 3, 3, 254, 130, 130, 130, 130,
  130, 254, 13, 6, 12, 16, 2, 3, 255, 248, 255, 248, 255, 248, 255, 248,
  255, 248, 255, 248, 13, 6, 12, 16, 2, 3, 255, 248, 128, 8, 128, 8,
  128, 8, 128, 8, 255, 248, 6, 13, 13, 9, 2, 254, 252, 252, 252, 252,
  252, 252, 252, 252, 252, 252, 252, 252, 252, 6, 13, 13, 9, 2, 254, 252,
  132, 132, 132, 132, 132, 132, 132, 132, 132, 132, 132, 252, 16, 6, 12, 19,
  2, 3, 31, 255, 63, 254, 63, 254, 127, 252, 127, 252, 255, 248, 16, 6,
  12, 19, 2, 3, 31, 255, 32, 2, 32, 2, 64, 4, 64, 4, 255, 248,
  11, 12, 24, 14, 2, 1, 4, 0, 4, 0, 14, 0, 14, 0, 31, 0,
  31, 0, 63, 128, 63, 128, 127, 192, 127, 192, 255, 224, 255, 224, 11, 12,
  24, 14, 2, 1, 4, 0, 4, 0, 10, 0, 10, 0, 17, 0, 17, 0,
  32, 128, 32, 128, 64, 64, 64, 64, 128, 32, 255, 224, 7, 8, 8, 12,
  3, 1, 16, 16, 56, 56, 124, 124, 254, 254, 7, 8, 8, 12, 3, 1,
  16, 16, 40, 40, 68, 68, 130, 254, 12, 11, 22, 15, 2, 1, 192, 0,
  240, 0, 252, 0, 255, 0, 255, 192, 255, 240, 255, 192, 255, 0, 252, 0,
  240, 0, 192, 0, 12, 11, 22, 15, 2, 1, 192, 0, 176, 0, 140, 0,
  131, 0, 128, 192, 128, 48, 128, 192, 131, 0, 140, 0, 176, 0, 192, 0,
  8, 7, 7, 13, 3, 1, 192, 240, 252, 255, 252, 240, 192, 8, 7, 7,
  13, 3, 1, 192, 176, 140, 131, 140, 176, 192, 12, 7, 14, 15, 2, 1,
  192, 0, 252, 0, 255, 192, 255, 240, 255, 192, 252, 0, 192, 0, 12, 7,
  14, 15, 2, 1, 192, 0, 188, 0, 131, 192, 128, 48, 131, 192, 188, 0,
  192, 0, 11, 12, 24, 14, 2, 1, 255, 224, 255, 224, 127, 192, 127, 192,
  63, 128, 63, 128, 31, 0, 31, 0, 14, 0, 14, 0, 4, 0, 4, 0,
  11, 12, 24, 14, 2, 1, 255, 224, 128, 32, 64, 64, 64, 64, 32, 128,
  32, 128, 17, 0, 17, 0, 10, 0, 10, 0, 4, 0, 4, 0, 7, 8,
  8, 12, 3, 1, 254, 254, 124, 124, 56, 56, 16, 16, 7, 8, 8, 12,
  3, 1, 254, 130, 68, 68, 40, 40, 16, 16, 12, 11, 22, 15, 2, 1,
  0, 48, 0, 240, 3, 240, 15, 240, 63, 240, 255, 240, 63, 240, 15, 240,
  3, 240, 0, 240, 0, 48, 12, 11, 22, 15, 2, 1, 0, 48, 0, 208,
  3, 16, 12, 16, 48, 16, 192, 16, 48, 16, 12, 16, 3, 16, 0, 208,
  0, 48, 8, 7, 7, 13, 3, 1, 3, 15, 63, 255, 63, 15, 3, 8,
  7, 7, 13, 3, 1, 3, 13, 49, 193, 49, 13, 3, 12, 7, 14, 15,
  2, 1, 0, 48, 3, 240, 63, 240, 255, 240, 63, 240, 3, 240, 0, 48,
  12, 7, 14, 15, 2, 1, 0, 48, 3, 208, 60, 16, 192, 16, 60, 16,
  3, 208, 0, 48, 11, 11, 22, 14, 2, 1, 4, 0, 14, 0, 31, 0,
  63, 128, 127, 192, 255, 224, 127, 192, 63, 128, 31, 0, 14, 0, 4, 0,
  11, 11, 22, 14, 2, 1, 4, 0, 10, 0, 17, 0, 32, 128, 64, 64,
  128, 32, 64, 64, 32, 128, 17, 0, 10, 0, 4, 0, 11, 11, 22, 14,
  2, 1, 4, 0, 10, 0, 17, 0, 36, 128, 78, 64, 159, 32, 78, 64,
  36, 128, 17, 0, 10, 0, 4, 0, 11, 11, 22, 14, 2, 1, 31, 0,
  96, 192, 64, 64, 142, 32, 159, 32, 159, 32, 159, 32, 142, 32, 64, 64,
  96, 192, 31, 0, 7, 12, 12, 8, 1, 0, 16, 40, 40, 68, 68, 130,
  130, 68, 68, 40, 40, 16, 11, 11, 22, 14, 2, 1, 31, 0, 96, 192,
  64, 64, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 64, 64, 96, 192,
  31, 0, 11, 11, 22, 14, 2, 1, 14, 0, 32, 128, 64, 64, 0, 0,
  128, 32, 128, 32, 128, 32, 0, 0, 64, 64, 32, 128, 14, 0, 11, 11,
  22, 14, 2, 1, 31, 0, 106, 192, 106, 192, 170, 160, 170, 160, 170, 160,
  170, 160, 170, 160, 106, 192, 106, 192, 31, 0, 11, 11, 22, 14, 2, 1,
  31, 0, 96, 192, 64, 64, 142, 32, 145, 32, 145, 32, 145, 32, 142, 32,
  64, 64, 96, 192, 31, 0, 11, 11, 22, 14, 2, 1, 31, 0, 127, 192,
  127, 192, 255, 224, 255, 224, 255, 224, 255, 224, 255, 224, 127, 192, 127, 192,
  31, 0, 11, 11, 22, 14, 2, 1, 31, 0, 120, 192, 120, 64, 248, 32,
  248, 32, 248, 32, 248, 32, 248, 32, 120, 64, 120, 192, 31, 0, 11, 11,
  22, 14, 2, 1, 31, 0, 99, 192, 67, 192, 131, 224, 131, 224, 131, 224,
  131, 224, 131, 224, 67, 192, 99, 192, 31, 0, 11, 11, 22, 14, 2, 1,
  31, 0, 127, 192, 127, 192, 255, 224, 255, 224, 128, 32, 128, 32, 128, 32,
  64, 64, 96, 192, 31, 0, 11, 11, 22, 14, 2, 1, 31, 0, 96, 192,
  64, 64, 128, 32, 128, 32, 128, 32, 255, 224, 255, 224, 127, 192, 127, 192,
  31, 0, 11, 11, 22, 14, 2, 1, 31, 0, 103, 192, 71, 192, 135, 224,
  135, 224, 135, 224, 128, 32, 128, 32, 64, 64, 96, 192, 31, 0, 11, 11,
  22, 14, 2, 1, 31, 0, 99, 192, 67, 192, 131, 224, 131, 224, 131, 224,
  255, 224, 255, 224, 127, 192, 127, 192, 31, 0, 6, 11, 11, 8, 2, 1,
  28, 124, 124, 252, 252, 252, 252, 252, 124, 124, 28, 6, 11, 11, 9, 2,
  1, 224, 248, 248, 252, 252, 252, 252, 252, 248, 248, 224, 7, 12, 12, 10,
  2, 1, 254, 254, 254, 254, 254, 198, 130, 130, 130, 198, 254, 254, 13, 13,
  26, 16, 2, 0, 255, 248, 240, 120, 207, 152, 223, 216, 191, 232, 191, 232,
  191, 232, 191, 232, 191, 232, 223, 216, 207, 152, 240, 120, 255, 248, 13, 7,
  14, 16, 2, 6, 255, 248, 240, 120, 207, 152, 223, 216, 191, 232, 191, 232,
  191, 232, 13, 7, 14, 16, 2, 0, 191, 232, 191, 232, 191, 232, 223, 216,
  207, 152, 240, 120, 255, 248, 6, 6, 6, 8, 2, 6, 28, 96, 64, 128,
  128, 128, 6, 6, 6, 13, 7, 6, 224, 24, 8, 4, 4, 4, 6, 6,
  6, 13, 7, 1, 4, 4, 4, 8, 24, 224, 6, 6, 6, 8, 2, 1,
  128, 128, 128, 64, 96, 28, 11, 6, 12, 14, 2, 6, 31, 0, 96, 192,
  64, 64, 128, 32, 128, 32, 128, 32, 11, 6, 12, 14, 2, 1, 128, 32,
  128, 32, 128, 32, 64, 64, 96, 192, 31, 0, 12, 12, 24, 15, 2, 1,
  0, 16, 0, 48, 0, 112, 0, 240, 1, 240, 3, 240, 7, 240, 15, 240,
  31, 240, 63, 240, 127, 240, 255, 240, 12, 12, 24, 15, 2, 1, 128, 0,
  192, 0, 224, 0, 240, 0, 248, 0, 252, 0, 254, 0, 255, 0, 255, 128,
  255, 192, 255, 224, 255, 240, 12, 12, 24, 15, 2, 1, 255, 240, 255, 224,
  255, 192, 255, 128, 255, 0, 254, 0, 252, 0, 248, 0, 240, 0, 224, 0,
  192, 0, 128, 0, 12, 12, 24, 15, 2, 1, 255, 240, 127, 240, 63, 240,
  31, 240, 15, 240, 7, 240, 3, 240, 1, 240, 0, 240, 0, 112, 0, 48,
  0, 16, 7, 7, 7, 8, 1, 2, 56, 68, 130, 130, 130, 68, 56, 11,
  11, 22, 14, 2, 1, 255, 224, 248, 32, 248, 32, 248, 32, 248, 32, 248,
  32, 248, 32, 248, 32, 248, 32, 248, 32, 255, 224, 11, 11, 22, 14, 2,
  1, 255, 224, 131, 224, 131, 224, 131, 224, 131, 224, 131, 224, 131, 224, 131,
  224, 131, 224, 131, 224, 255, 224, 11, 11, 22, 14, 2, 1, 255, 224, 255,
  224, 255, 160, 255, 32, 254, 32, 252, 32, 248, 32, 240, 32, 224, 32, 192,
  32, 255, 224, 11, 11, 22, 14, 2, 1, 255, 224, 128, 96, 128, 224, 129,
  224, 131, 224, 135, 224, 143, 224, 159, 224, 191, 224, 255, 224, 255, 224, 11,
  11, 22, 14, 2, 1, 255, 224, 132, 32, 132, 32, 132, 32, 132, 32, 132,
  32, 132, 32, 132, 32, 132, 32, 132, 32, 255, 224, 11, 12, 24, 14, 2,
  1, 4, 0, 4, 0, 10, 0, 10, 0, 17, 0, 17, 0, 32, 128, 36,
  128, 78, 64, 68, 64, 128, 32, 255, 224, 11, 12, 24, 14, 2, 1, 4,
  0, 4, 0, 14, 0, 14, 0, 29, 0, 29, 0, 60, 128, 60, 128, 124,
  64, 124, 64, 252, 32, 255, 224, 11, 12, 24, 14, 2, 1, 4, 0, 4,
  0, 14, 0, 14, 0, 23, 0, 23, 0, 39, 128, 39, 128, 71, 192, 71,
  192, 135, 224, 255, 224, 13, 13, 26, 16, 2, 0, 31, 192, 32, 32, 64,
  16, 128, 8, 128, 8, 128, 8, 128, 8, 128, 8, 128, 8, 128, 8, 64,
  16, 32, 32, 31, 192, 11, 11, 22, 14, 2, 1, 255, 224, 132, 32, 132,
  32, 132, 32, 132, 32, 252, 32, 128, 32, 128, 32, 128, 32, 128, 32, 255,
  224, 11, 11, 22, 14, 2, 1, 255, 224, 128, 32, 128, 32, 128, 32, 128,
  32, 252, 32, 132, 32, 132, 32, 132, 32, 132, 32, 255, 224, 11, 11, 22,
  14, 2, 1, 255, 224, 128, 32, 128, 32, 128, 32, 128, 32, 135, 224, 132,
  32, 132, 32, 132, 32, 132, 32, 255, 224, 11, 11, 22, 14, 2, 1, 255,
  224, 132, 32, 132, 32, 132, 32, 132, 32, 135, 224, 128, 32, 128, 32, 128,
  32, 128, 32, 255, 224, 11, 11, 22, 14, 2, 1, 31, 0, 100, 192, 68,
  64, 132, 32, 132, 32, 252, 32, 128, 32, 128, 32, 64, 64, 96, 192, 31,
  0, 11, 11, 22, 14, 2, 1, 31, 0, 96, 192, 64, 64, 128, 32, 128,
  32, 252, 32, 132, 32, 132, 32, 68, 64, 100, 192, 31, 0, 11, 11, 22,
  14, 2, 1, 31, 0, 96, 192, 64, 64, 128, 32, 128, 32, 135, 224, 132,
  32, 132, 32, 68, 64, 100, 192, 31, 0, 11, 11, 22, 14, 2, 1, 31,
  0, 100, 192, 68, 64, 132, 32, 132, 32, 135, 224, 128, 32, 128, 32, 64,
  64, 96, 192, 31, 0, 255, 255, 255, 255, 255, 255, 255, 255
};

/*
  Fontname: -MUTT-ClearlyU-Medium-R-Normal--17-120-100-100-P-123-ISO10646-1
  Copyright: 2001 Computing Research Lab, New Mexico State University.
  Capital A Height: 11, '1' Height: 6
  Calculated Max Values w=16 h=13 x= 3 y= 3 dx=19 dy= 0 ascent=13 len=24
  Font Bounding box     w=40 h=30 x=-9 y=-10
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =11 descent= 0
  X Font      ascent =12 descent= 0
  Max Font    ascent =13 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_cu12_75r[1123] U8G_FONT_SECTION("u8g_font_cu12_75r") = {
  0, 40, 30, 247, 246, 11, 2, 247, 0, 0, 32, 79, 0, 13, 254, 12,
  0, 11, 11, 22, 14, 2, 1, 255, 224, 255, 224, 255, 224, 255, 224, 255,
  224, 255, 224, 255, 224, 255, 224, 255, 224, 255, 224, 255, 224, 11, 11, 22,
  14, 2, 1, 255, 224, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128,
  32, 128, 32, 128, 32, 128, 32, 255, 224, 11, 11, 22, 14, 2, 1, 63,
  128, 64, 64, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128,
  32, 64, 64, 63, 128, 11, 11, 22, 14, 2, 1, 255, 224, 128, 32, 191,
  160, 191, 160, 191, 160, 191, 160, 191, 160, 191, 160, 191, 160, 128, 32, 255,
  224, 11, 11, 22, 14, 2, 1, 255, 224, 128, 32, 255, 224, 128, 32, 255,
  224, 128, 32, 255, 224, 128, 32, 255, 224, 128, 32, 255, 224, 11, 11, 22,
  14, 2, 1, 255, 224, 170, 160, 170, 160, 170, 160, 170, 160, 170, 160, 170,
  160, 170, 160, 170, 160, 170, 160, 255, 224, 11, 11, 22, 14, 2, 1, 255,
  224, 170, 160, 255, 224, 170, 160, 255, 224, 170, 160, 255, 224, 170, 160, 255,
  224, 170, 160, 255, 224, 11, 11, 22, 14, 2, 1, 255, 224, 201, 32, 164,
  160, 146, 96, 201, 32, 164, 160, 146, 96, 201, 32, 164, 160, 146, 96, 255,
  224, 11, 11, 22, 14, 2, 1, 255, 224, 146, 96, 164, 160, 201, 32, 146,
  96, 164, 160, 201, 32, 146, 96, 164, 160, 201, 32, 255, 224, 11, 11, 22,
  14, 2, 1, 255, 224, 213, 96, 170, 160, 213, 96, 170, 160, 213, 96, 170,
  160, 213, 96, 170, 160, 213, 96, 255, 224, 7, 7, 7, 12, 3, 3, 254,
  254, 254, 254, 254, 254, 254, 7, 7, 7, 12, 3, 3, 254, 130, 130, 130,
  130, 130, 254, 13, 6, 12, 16, 2, 3, 255, 248, 255, 248, 255, 248, 255,
  248, 255, 248, 255, 248, 13, 6, 12, 16, 2, 3, 255, 248, 128, 8, 128,
  8, 128, 8, 128, 8, 255, 248, 6, 13, 13, 9, 2, 254, 252, 252, 252,
  252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 6, 13, 13, 9, 2, 254,
  252, 132, 132, 132, 132, 132, 132, 132, 132, 132, 132, 132, 252, 16, 6, 12,
  19, 2, 3, 31, 255, 63, 254, 63, 254, 127, 252, 127, 252, 255, 248, 16,
  6, 12, 19, 2, 3, 31, 255, 32, 2, 32, 2, 64, 4, 64, 4, 255,
  248, 11, 12, 24, 14, 2, 1, 4, 0, 4, 0, 14, 0, 14, 0, 31,
  0, 31, 0, 63, 128, 63, 128, 127, 192, 127, 192, 255, 224, 255, 224, 11,
  12, 24, 14, 2, 1, 4, 0, 4, 0, 10, 0, 10, 0, 17, 0, 17,
  0, 32, 128, 32, 128, 64, 64, 64, 64, 128, 32, 255, 224, 7, 8, 8,
  12, 3, 1, 16, 16, 56, 56, 124, 124, 254, 254, 7, 8, 8, 12, 3,
  1, 16, 16, 40, 40, 68, 68, 130, 254, 12, 11, 22, 15, 2, 1, 192,
  0, 240, 0, 252, 0, 255, 0, 255, 192, 255, 240, 255, 192, 255, 0, 252,
  0, 240, 0, 192, 0, 12, 11, 22, 15, 2, 1, 192, 0, 176, 0, 140,
  0, 131, 0, 128, 192, 128, 48, 128, 192, 131, 0, 140, 0, 176, 0, 192,
  0, 8, 7, 7, 13, 3, 1, 192, 240, 252, 255, 252, 240, 192, 8, 7,
  7, 13, 3, 1, 192, 176, 140, 131, 140, 176, 192, 12, 7, 14, 15, 2,
  1, 192, 0, 252, 0, 255, 192, 255, 240, 255, 192, 252, 0, 192, 0, 12,
  7, 14, 15, 2, 1, 192, 0, 188, 0, 131, 192, 128, 48, 131, 192, 188,
  0, 192, 0, 11, 12, 24, 14, 2, 1, 255, 224, 255, 224, 127, 192, 127,
  192, 63, 128, 63, 128, 31, 0, 31, 0, 14, 0, 14, 0, 4, 0, 4,
  0, 11, 12, 24, 14, 2, 1, 255, 224, 128, 32, 64, 64, 64, 64, 32,
  128, 32, 128, 17, 0, 17, 0, 10, 0, 10, 0, 4, 0, 4, 0, 7,
  8, 8, 12, 3, 1, 254, 254, 124, 124, 56, 56, 16, 16, 7, 8, 8,
  12, 3, 1, 254, 130, 68, 68, 40, 40, 16, 16, 12, 11, 22, 15, 2,
  1, 0, 48, 0, 240, 3, 240, 15, 240, 63, 240, 255, 240, 63, 240, 15,
  240, 3, 240, 0, 240, 0, 48, 12, 11, 22, 15, 2, 1, 0, 48, 0,
  208, 3, 16, 12, 16, 48, 16, 192, 16, 48, 16, 12, 16, 3, 16, 0,
  208, 0, 48, 8, 7, 7, 13, 3, 1, 3, 15, 63, 255, 63, 15, 3,
  8, 7, 7, 13, 3, 1, 3, 13, 49, 193, 49, 13, 3, 12, 7, 14,
  15, 2, 1, 0, 48, 3, 240, 63, 240, 255, 240, 63, 240, 3, 240, 0,
  48, 12, 7, 14, 15, 2, 1, 0, 48, 3, 208, 60, 16, 192, 16, 60,
  16, 3, 208, 0, 48, 11, 11, 22, 14, 2, 1, 4, 0, 14, 0, 31,
  0, 63, 128, 127, 192, 255, 224, 127, 192, 63, 128, 31, 0, 14, 0, 4,
  0, 11, 11, 22, 14, 2, 1, 4, 0, 10, 0, 17, 0, 32, 128, 64,
  64, 128, 32, 64, 64, 32, 128, 17, 0, 10, 0, 4, 0, 11, 11, 22,
  14, 2, 1, 4, 0, 10, 0, 17, 0, 36, 128, 78, 64, 159, 32, 78,
  64, 36, 128, 17, 0, 10, 0, 4, 0, 11, 11, 22, 14, 2, 1, 31,
  0, 96, 192, 64, 64, 142, 32, 159, 32, 159, 32, 159, 32, 142, 32, 64,
  64, 96, 192, 31, 0, 7, 12, 12, 8, 1, 0, 16, 40, 40, 68, 68,
  130, 130, 68, 68, 40, 40, 16, 11, 11, 22, 14, 2, 1, 31, 0, 96,
  192, 64, 64, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 64, 64, 96,
  192, 31, 0, 11, 11, 22, 14, 2, 1, 14, 0, 32, 128, 64, 64, 0,
  0, 128, 32, 128, 32, 128, 32, 0, 0, 64, 64, 32, 128, 14, 0, 11,
  11, 22, 14, 2, 1, 31, 0, 106, 192, 106, 192, 170, 160, 170, 160, 170,
  160, 170, 160, 170, 160, 106, 192, 106, 192, 31, 0, 11, 11, 22, 14, 2,
  1, 31, 0, 96, 192, 64, 64, 142, 32, 145, 32, 145, 32, 145, 32, 142,
  32, 64, 64, 96, 192, 31, 0, 11, 11, 22, 14, 2, 1, 31, 0, 127,
  192, 127, 192, 255, 224, 255, 224, 255, 224, 255, 224, 255, 224, 127, 192, 127,
  192, 31, 0
};

/*
  Fontname: -MUTT-ClearlyU-Medium-R-Normal--17-120-100-100-P-123-ISO10646-1
  Copyright: 2001 Computing Research Lab, New Mexico State University.
  Capital A Height: 11, '1' Height: 11
  Calculated Max Values w=16 h=16 x= 3 y=11 dx=16 dy= 0 ascent=16 len=32
  Font Bounding box     w=40 h=30 x=-9 y=-10
  Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
  Pure Font   ascent =11 descent=-4
  X Font      ascent =12 descent=-4
  Max Font    ascent =16 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_cu12[3993] U8G_FONT_SECTION("u8g_font_cu12") = {
  0, 40, 30, 247, 246, 11, 2, 90, 5, 94, 32, 255, 252, 16, 252, 12,
  252, 0, 0, 0, 5, 0, 0, 2, 12, 12, 5, 1, 0, 192, 192, 192,
  192, 192, 192, 192, 0, 0, 0, 192, 192, 4, 5, 5, 7, 2, 7, 144,
  144, 144, 144, 144, 10, 15, 30, 12, 1, 253, 4, 128, 4, 128, 9, 0,
  9, 0, 9, 0, 255, 192, 18, 0, 18, 0, 18, 0, 255, 192, 36, 0,
  36, 0, 36, 0, 72, 0, 72, 0, 5, 14, 14, 8, 1, 255, 32, 112,
  168, 168, 168, 160, 96, 48, 40, 168, 168, 168, 112, 32, 11, 13, 26, 14,
  1, 255, 96, 64, 152, 128, 151, 128, 145, 0, 146, 0, 98, 0, 4, 0,
  8, 192, 9, 32, 17, 32, 33, 32, 33, 32, 64, 192, 10, 12, 24, 13,
  1, 0, 24, 0, 36, 0, 36, 0, 36, 0, 40, 0, 51, 192, 49, 0,
  81, 0, 138, 0, 138, 0, 196, 64, 123, 128, 1, 5, 5, 4, 2, 7,
  128, 128, 128, 128, 128, 4, 15, 15, 6, 2, 253, 16, 32, 64, 64, 128,
  128, 128, 128, 128, 128, 128, 64, 64, 32, 16, 4, 15, 15, 6, 1, 253,
  128, 64, 32, 32, 16, 16, 16, 16, 16, 16, 16, 32, 32, 64, 128, 7,
  7, 7, 7, 0, 5, 16, 146, 84, 56, 84, 146, 16, 9, 9, 18, 11,
  2, 255, 8, 0, 8, 0, 8, 0, 8, 0, 255, 128, 8, 0, 8, 0,
  8, 0, 8, 0, 2, 5, 5, 5, 1, 253, 192, 192, 64, 64, 128, 4,
  1, 1, 7, 2, 3, 240, 2, 2, 2, 5, 1, 0, 192, 192, 5, 16,
  16, 8, 2, 252, 8, 8, 16, 16, 16, 16, 32, 32, 32, 32, 64, 64,
  64, 64, 128, 128, 5, 11, 11, 7, 1, 0, 112, 80, 136, 136, 136, 136,
  136, 136, 136, 80, 112, 5, 11, 11, 7, 1, 0, 32, 224, 32, 32, 32,
  32, 32, 32, 32, 32, 248, 5, 11, 11, 7, 1, 0, 112, 136, 136, 136,
  8, 16, 16, 32, 72, 72, 248, 5, 11, 11, 7, 1, 0, 112, 136, 136,
  8, 8, 48, 8, 8, 136, 136, 112, 7, 11, 11, 9, 1, 0, 24, 24,
  40, 40, 72, 200, 254, 8, 8, 8, 62, 5, 11, 11, 7, 1, 0, 136,
  240, 128, 128, 240, 200, 8, 8, 136, 144, 96, 5, 11, 11, 7, 1, 0,
  48, 72, 64, 128, 240, 136, 136, 136, 136, 80, 112, 6, 12, 12, 8, 1,
  0, 128, 252, 132, 136, 16, 16, 16, 32, 32, 32, 32, 32, 5, 11, 11,
  7, 1, 0, 112, 136, 136, 136, 80, 112, 136, 136, 136, 136, 112, 5, 11,
  11, 7, 1, 0, 112, 80, 136, 136, 136, 136, 120, 8, 16, 144, 96, 2,
  7, 7, 7, 3, 0, 192, 192, 0, 0, 0, 192, 192, 2, 10, 10, 5,
  1, 253, 192, 192, 0, 0, 0, 192, 192, 64, 64, 128, 5, 9, 9, 6,
  1, 1, 8, 16, 32, 64, 128, 64, 32, 16, 8, 10, 5, 10, 13, 2,
  2, 255, 192, 0, 0, 0, 0, 0, 0, 255, 192, 5, 9, 9, 6, 1,
  1, 128, 64, 32, 16, 8, 16, 32, 64, 128, 5, 12, 12, 8, 1, 0,
  112, 136, 136, 16, 32, 32, 96, 0, 0, 0, 96, 96, 10, 12, 24, 12,
  1, 0, 30, 0, 33, 0, 76, 128, 147, 64, 161, 64, 161, 64, 161, 64,
  161, 64, 147, 64, 77, 128, 32, 192, 31, 0, 11, 11, 22, 11, 0, 0,
  4, 0, 4, 0, 10, 0, 10, 0, 10, 0, 17, 0, 17, 0, 31, 0,
  32, 128, 32, 128, 241, 224, 10, 11, 22, 10, 0, 0, 255, 0, 32, 128,
  32, 64, 32, 64, 32, 128, 63, 0, 32, 128, 32, 64, 32, 64, 32, 128,
  255, 0, 9, 11, 22, 10, 1, 0, 30, 128, 33, 128, 64, 128, 128, 128,
  128, 0, 128, 0, 128, 0, 128, 128, 64, 128, 33, 0, 30, 0, 10, 11,
  22, 10, 0, 0, 254, 0, 33, 128, 32, 128, 32, 64, 32, 64, 32, 64,
  32, 64, 32, 64, 32, 128, 33, 128, 254, 0, 10, 11, 22, 10, 1, 0,
  255, 128, 32, 128, 32, 128, 34, 128, 34, 0, 62, 0, 34, 64, 34, 64,
  32, 128, 32, 128, 255, 128, 9, 11, 22, 9, 1, 0, 255, 128, 32, 128,
  32, 128, 34, 128, 34, 0, 62, 0, 34, 0, 34, 0, 32, 0, 32, 0,
  248, 0, 10, 11, 22, 10, 1, 0, 30, 128, 33, 128, 64, 128, 128, 128,
  128, 0, 128, 0, 131, 192, 128, 128, 64, 128, 32, 128, 31, 128, 11, 11,
  22, 11, 1, 0, 251, 224, 32, 128, 32, 128, 32, 128, 32, 128, 63, 128,
  32, 128, 32, 128, 32, 128, 32, 128, 251, 224, 5, 11, 11, 5, 1, 0,
  248, 32, 32, 32, 32, 32, 32, 32, 32, 32, 248, 6, 11, 11, 6, 1,
  0, 124, 16, 16, 16, 16, 16, 16, 16, 16, 144, 224, 11, 11, 22, 11,
  1, 0, 249, 224, 32, 128, 33, 0, 34, 0, 36, 0, 46, 0, 50, 0,
  33, 0, 33, 0, 32, 128, 249, 224, 8, 11, 11, 8, 0, 0, 248, 32,
  32, 32, 32, 32, 33, 33, 33, 35, 255, 14, 11, 22, 14, 1, 0, 240,
  60, 48, 48, 48, 48, 40, 80, 40, 80, 40, 144, 36, 144, 36, 144, 35,
  16, 35, 16, 251, 124, 11, 11, 22, 11, 1, 0, 227, 224, 48, 128, 48,
  128, 40, 128, 40, 128, 36, 128, 34, 128, 34, 128, 33, 128, 33, 128, 248,
  128, 10, 11, 22, 10, 1, 0, 30, 0, 33, 0, 64, 128, 128, 64, 128,
  64, 128, 64, 128, 64, 128, 64, 64, 128, 33, 0, 30, 0, 9, 11, 22,
  9, 1, 0, 255, 0, 33, 128, 32, 128, 32, 128, 33, 128, 63, 0, 32,
  0, 32, 0, 32, 0, 32, 0, 248, 0, 10, 14, 28, 10, 1, 253, 30,
  0, 33, 0, 64, 128, 128, 64, 128, 64, 128, 64, 128, 64, 128, 64, 92,
  128, 51, 0, 30, 0, 2, 0, 2, 64, 1, 128, 11, 11, 22, 11, 1,
  0, 254, 0, 33, 0, 32, 128, 32, 128, 33, 0, 62, 0, 35, 0, 33,
  0, 33, 0, 33, 0, 248, 224, 6, 11, 11, 7, 1, 0, 124, 132, 132,
  128, 64, 48, 8, 4, 132, 132, 248, 9, 11, 22, 9, 1, 0, 255, 128,
  136, 128, 136, 128, 136, 128, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0,
  8, 0, 62, 0, 11, 11, 22, 11, 1, 0, 251, 224, 32, 128, 32, 128,
  32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 17, 0, 14, 0,
  11, 11, 22, 11, 1, 0, 241, 224, 32, 128, 32, 128, 17, 0, 17, 0,
  17, 0, 10, 0, 10, 0, 10, 0, 4, 0, 4, 0, 16, 11, 22, 16,
  1, 0, 241, 207, 33, 132, 33, 132, 34, 68, 18, 72, 18, 72, 18, 72,
  20, 40, 12, 48, 12, 48, 8, 16, 11, 11, 22, 11, 1, 0, 243, 192,
  17, 0, 18, 0, 10, 0, 12, 0, 4, 0, 10, 0, 26, 0, 17, 0,
  32, 128, 241, 224, 11, 11, 22, 11, 1, 0, 241, 224, 32, 128, 17, 0,
  17, 0, 10, 0, 14, 0, 4, 0, 4, 0, 4, 0, 4, 0, 31, 0,
  7, 11, 11, 7, 1, 0, 254, 196, 132, 136, 8, 16, 34, 34, 66, 70,
  254, 3, 16, 16, 5, 1, 252, 224, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 224, 5, 16, 16, 8, 2, 252, 128, 128, 64,
  64, 64, 64, 32, 32, 32, 32, 16, 16, 16, 16, 8, 8, 3, 16, 16,
  5, 0, 252, 224, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 224, 5, 3, 3, 6, 1, 9, 32, 112, 136, 11, 1, 2, 12,
  1, 254, 255, 224, 3, 4, 4, 6, 3, 8, 128, 192, 64, 32, 6, 7,
  7, 7, 1, 0, 112, 136, 8, 120, 136, 136, 124, 6, 12, 12, 7, 1,
  0, 192, 64, 64, 64, 64, 120, 68, 68, 68, 68, 68, 120, 5, 7, 7,
  6, 1, 0, 112, 136, 128, 128, 128, 136, 112, 6, 12, 12, 7, 1, 0,
  24, 8, 8, 8, 8, 120, 136, 136, 136, 136, 136, 124, 5, 7, 7, 6,
  1, 0, 112, 136, 248, 128, 128, 136, 112, 5, 12, 12, 6, 1, 0, 56,
  72, 64, 64, 64, 240, 64, 64, 64, 64, 64, 224, 7, 11, 11, 8, 1,
  252, 62, 68, 68, 68, 120, 64, 124, 130, 130, 130, 124, 7, 12, 12, 8,
  1, 0, 192, 64, 64, 64, 64, 120, 68, 68, 68, 68, 68, 238, 3, 11,
  11, 4, 1, 0, 192, 192, 0, 0, 192, 64, 64, 64, 64, 64, 224, 4,
  14, 14, 5, 0, 253, 48, 48, 0, 0, 48, 16, 16, 16, 16, 16, 16,
  16, 144, 224, 7, 12, 12, 8, 1, 0, 192, 64, 64, 64, 64, 94, 72,
  80, 112, 88, 72, 238, 3, 12, 12, 4, 1, 0, 192, 64, 64, 64, 64,
  64, 64, 64, 64, 64, 64, 224, 11, 7, 14, 12, 1, 0, 251, 128, 68,
  64, 68, 64, 68, 64, 68, 64, 68, 64, 238, 224, 7, 7, 7, 8, 1,
  0, 248, 68, 68, 68, 68, 68, 238, 5, 7, 7, 6, 1, 0, 112, 136,
  136, 136, 136, 136, 112, 6, 10, 10, 7, 1, 253, 248, 68, 68, 68, 68,
  68, 120, 64, 64, 224, 6, 10, 10, 7, 1, 253, 120, 136, 136, 136, 136,
  136, 120, 8, 8, 28, 5, 7, 7, 6, 1, 0, 208, 104, 64, 64, 64,
  64, 240, 5, 7, 7, 6, 1, 0, 120, 136, 128, 112, 8, 136, 240, 6,
  10, 10, 7, 1, 0, 32, 32, 32, 248, 32, 32, 32, 36, 36, 24, 7,
  7, 7, 8, 1, 0, 204, 68, 68, 68, 68, 68, 62, 8, 7, 7, 9,
  1, 0, 231, 36, 36, 36, 24, 24, 24, 11, 7, 14, 11, 0, 0, 238,
  224, 36, 128, 42, 128, 42, 128, 42, 128, 27, 0, 17, 0, 8, 7, 7,
  9, 1, 0, 231, 36, 24, 24, 24, 36, 231, 8, 10, 10, 8, 1, 253,
  231, 36, 36, 36, 24, 24, 24, 16, 144, 224, 5, 7, 7, 6, 1, 0,
  248, 144, 144, 32, 72, 72, 248, 5, 16, 16, 6, 1, 252, 24, 32, 32,
  32, 32, 32, 32, 192, 32, 32, 32, 32, 32, 32, 32, 24, 1, 16, 16,
  3, 2, 252, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 5, 16, 16, 5, 0, 252, 192, 32, 32, 32, 32, 32, 32,
  24, 32, 32, 32, 32, 32, 32, 32, 192, 5, 3, 3, 8, 1, 9, 72,
  168, 144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 0, 0, 0, 5, 0, 0, 2, 12, 12, 5, 1, 253, 192,
  192, 0, 0, 0, 192, 192, 192, 192, 192, 192, 192, 5, 11, 11, 7, 1,
  254, 16, 16, 112, 168, 160, 160, 160, 200, 112, 64, 64, 8, 12, 12, 9,
  1, 0, 6, 9, 17, 16, 16, 124, 16, 16, 16, 81, 178, 204, 7, 7,
  7, 9, 1, 3, 130, 124, 68, 68, 68, 124, 130, 11, 11, 22, 12, 0,
  0, 241, 224, 32, 128, 17, 0, 10, 0, 127, 192, 14, 0, 4, 0, 127,
  192, 4, 0, 4, 0, 31, 0, 1, 16, 16, 3, 2, 252, 128, 128, 128,
  128, 128, 128, 128, 0, 0, 128, 128, 128, 128, 128, 128, 128, 4, 13, 13,
  6, 1, 0, 96, 144, 128, 128, 96, 144, 144, 144, 96, 16, 16, 144, 96,
  5, 2, 2, 6, 1, 11, 216, 216, 9, 10, 20, 10, 1, 3, 62, 0,
  65, 0, 158, 128, 162, 128, 162, 128, 160, 128, 162, 128, 156, 128, 65, 0,
  62, 0, 4, 6, 6, 5, 1, 7, 96, 16, 112, 144, 112, 240, 7, 7,
  7, 9, 1, 0, 18, 36, 108, 216, 108, 36, 18, 6, 4, 4, 8, 1,
  2, 252, 4, 4, 4, 3, 1, 1, 5, 0, 3, 224, 9, 10, 20, 10,
  1, 3, 62, 0, 65, 0, 188, 128, 146, 128, 146, 128, 156, 128, 146, 128,
  186, 128, 65, 0, 62, 0, 5, 1, 1, 7, 1, 11, 248, 4, 4, 4,
  6, 2, 8, 96, 144, 144, 96, 7, 9, 9, 9, 2, 1, 16, 16, 16,
  254, 16, 16, 16, 0, 254, 4, 7, 7, 5, 1, 6, 96, 144, 16, 16,
  32, 64, 240, 4, 7, 7, 5, 1, 6, 96, 144, 16, 32, 16, 144, 96,
  3, 4, 4, 6, 3, 11, 32, 96, 64, 128, 7, 10, 10, 8, 1, 253,
  136, 136, 136, 136, 136, 218, 164, 128, 128, 128, 7, 15, 15, 8, 1, 252,
  62, 116, 244, 244, 244, 116, 52, 20, 20, 20, 20, 20, 20, 20, 20, 2,
  2, 2, 4, 2, 5, 192, 192, 3, 3, 3, 7, 2, 253, 64, 32, 224,
  3, 7, 7, 4, 1, 6, 64, 192, 64, 64, 64, 64, 224, 4, 6, 6,
  5, 1, 7, 96, 144, 144, 144, 96, 240, 7, 7, 7, 8, 1, 0, 144,
  72, 108, 54, 108, 72, 144, 11, 11, 22, 12, 1, 0, 64, 0, 196, 0,
  68, 0, 68, 0, 68, 64, 232, 192, 9, 64, 10, 64, 11, 224, 16, 64,
  16, 224, 11, 11, 22, 12, 1, 0, 64, 0, 196, 0, 68, 0, 68, 0,
  68, 0, 232, 192, 9, 32, 8, 32, 8, 64, 16, 128, 17, 224, 12, 11,
  22, 13, 1, 0, 96, 0, 146, 0, 18, 0, 34, 0, 18, 32, 148, 96,
  100, 160, 5, 32, 5, 240, 8, 32, 8, 112, 5, 12, 12, 8, 1, 253,
  48, 48, 0, 0, 0, 48, 32, 32, 64, 128, 136, 112, 11, 16, 32, 11,
  0, 0, 8, 0, 12, 0, 4, 0, 2, 0, 0, 0, 4, 0, 4, 0,
  10, 0, 10, 0, 10, 0, 17, 0, 17, 0, 31, 0, 32, 128, 32, 128,
  241, 224, 11, 16, 32, 11, 0, 0, 2, 0, 6, 0, 4, 0, 8, 0,
  0, 0, 4, 0, 4, 0, 10, 0, 10, 0, 10, 0, 17, 0, 17, 0,
  31, 0, 32, 128, 32, 128, 241, 224, 11, 15, 30, 11, 0, 0, 4, 0,
  14, 0, 17, 0, 0, 0, 4, 0, 4, 0, 10, 0, 10, 0, 10, 0,
  17, 0, 17, 0, 31, 0, 32, 128, 32, 128, 241, 224, 11, 15, 30, 11,
  0, 0, 9, 0, 21, 0, 18, 0, 0, 0, 4, 0, 4, 0, 10, 0,
  10, 0, 10, 0, 17, 0, 17, 0, 31, 0, 32, 128, 32, 128, 241, 224,
  11, 14, 28, 11, 0, 0, 27, 0, 27, 0, 0, 0, 4, 0, 4, 0,
  10, 0, 10, 0, 10, 0, 17, 0, 17, 0, 31, 0, 32, 128, 32, 128,
  241, 224, 11, 15, 30, 11, 0, 0, 6, 0, 9, 0, 9, 0, 6, 0,
  4, 0, 4, 0, 10, 0, 10, 0, 10, 0, 17, 0, 17, 0, 31, 0,
  32, 128, 32, 128, 241, 224, 14, 11, 22, 15, 0, 0, 15, 248, 10, 24,
  10, 8, 10, 40, 18, 32, 31, 224, 18, 36, 18, 36, 34, 8, 34, 8,
  247, 248, 9, 14, 28, 10, 1, 253, 30, 128, 33, 128, 64, 128, 128, 128,
  128, 0, 128, 0, 128, 0, 128, 128, 64, 128, 33, 0, 30, 0, 8, 0,
  4, 0, 28, 0, 10, 16, 32, 11, 0, 0, 16, 0, 24, 0, 8, 0,
  4, 0, 0, 0, 255, 128, 32, 128, 32, 128, 34, 128, 34, 0, 62, 0,
  34, 64, 34, 64, 32, 128, 32, 128, 255, 128, 10, 16, 32, 11, 0, 0,
  4, 0, 12, 0, 8, 0, 16, 0, 0, 0, 255, 128, 32, 128, 32, 128,
  34, 128, 34, 0, 62, 0, 34, 64, 34, 64, 32, 128, 32, 128, 255, 128,
  10, 15, 30, 11, 0, 0, 8, 0, 28, 0, 34, 0, 0, 0, 255, 128,
  32, 128, 32, 128, 34, 128, 34, 0, 62, 0, 34, 64, 34, 64, 32, 128,
  32, 128, 255, 128, 10, 14, 28, 11, 0, 0, 54, 0, 54, 0, 0, 0,
  255, 128, 32, 128, 32, 128, 34, 128, 34, 0, 62, 0, 34, 64, 34, 64,
  32, 128, 32, 128, 255, 128, 5, 16, 16, 6, 1, 0, 64, 96, 32, 16,
  0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 32, 248, 5, 16, 16, 6,
  1, 0, 16, 48, 32, 64, 0, 248, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 248, 5, 15, 15, 6, 1, 0, 32, 112, 136, 0, 248, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 248, 5, 14, 14, 6, 1, 0, 216, 216, 0,
  248, 32, 32, 32, 32, 32, 32, 32, 32, 32, 248, 10, 11, 22, 11, 0,
  0, 254, 0, 33, 128, 32, 128, 32, 64, 32, 64, 248, 64, 32, 64, 32,
  64, 32, 128, 33, 128, 254, 0, 11, 15, 30, 12, 0, 0, 9, 0, 21,
  0, 18, 0, 0, 0, 227, 224, 48, 128, 48, 128, 40, 128, 40, 128, 36,
  128, 34, 128, 34, 128, 33, 128, 33, 128, 248, 128, 10, 16, 32, 12, 1,
  0, 16, 0, 24, 0, 8, 0, 4, 0, 0, 0, 30, 0, 33, 0, 64,
  128, 128, 64, 128, 64, 128, 64, 128, 64, 128, 64, 64, 128, 33, 0, 30,
  0, 10, 16, 32, 12, 1, 0, 2, 0, 6, 0, 4, 0, 8, 0, 0,
  0, 30, 0, 33, 0, 64, 128, 128, 64, 128, 64, 128, 64, 128, 64, 128,
  64, 64, 128, 33, 0, 30, 0, 10, 15, 30, 12, 1, 0, 8, 0, 28,
  0, 34, 0, 0, 0, 30, 0, 33, 0, 64, 128, 128, 64, 128, 64, 128,
  64, 128, 64, 128, 64, 64, 128, 33, 0, 30, 0, 10, 15, 30, 12, 1,
  0, 18, 0, 42, 0, 36, 0, 0, 0, 30, 0, 33, 0, 64, 128, 128,
  64, 128, 64, 128, 64, 128, 64, 128, 64, 64, 128, 33, 0, 30, 0, 10,
  14, 28, 12, 1, 0, 54, 0, 54, 0, 0, 0, 30, 0, 33, 0, 64,
  128, 128, 64, 128, 64, 128, 64, 128, 64, 128, 64, 64, 128, 33, 0, 30,
  0, 7, 7, 7, 9, 1, 0, 130, 68, 40, 16, 40, 68, 130, 10, 13,
  26, 12, 1, 255, 0, 128, 31, 0, 33, 0, 66, 128, 130, 64, 132, 64,
  140, 64, 136, 64, 144, 64, 80, 128, 33, 0, 62, 0, 64, 0, 11, 16,
  32, 12, 1, 0, 8, 0, 12, 0, 4, 0, 2, 0, 0, 0, 251, 224,
  32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128,
  17, 0, 14, 0, 11, 16, 32, 12, 1, 0, 2, 0, 6, 0, 4, 0,
  8, 0, 0, 0, 251, 224, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128,
  32, 128, 32, 128, 32, 128, 17, 0, 14, 0, 11, 15, 30, 12, 1, 0,
  4, 0, 14, 0, 17, 0, 0, 0, 251, 224, 32, 128, 32, 128, 32, 128,
  32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 17, 0, 14, 0, 11, 14,
  28, 12, 1, 0, 27, 0, 27, 0, 0, 0, 251, 224, 32, 128, 32, 128,
  32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 128, 17, 0, 14, 0,
  11, 16, 32, 12, 0, 0, 2, 0, 6, 0, 4, 0, 8, 0, 0, 0,
  241, 224, 32, 128, 17, 0, 17, 0, 10, 0, 14, 0, 4, 0, 4, 0,
  4, 0, 4, 0, 31, 0, 9, 11, 22, 10, 0, 0, 248, 0, 32, 0,
  62, 0, 33, 0, 32, 128, 32, 128, 32, 128, 33, 0, 62, 0, 32, 0,
  248, 0, 6, 12, 12, 7, 1, 0, 48, 72, 72, 72, 72, 216, 72, 68,
  68, 68, 68, 216, 6, 12, 12, 7, 1, 0, 64, 96, 32, 16, 0, 112,
  136, 8, 120, 136, 136, 124, 6, 12, 12, 7, 1, 0, 16, 48, 32, 64,
  0, 112, 136, 8, 120, 136, 136, 124, 6, 11, 11, 7, 1, 0, 32, 112,
  136, 0, 112, 136, 8, 120, 136, 136, 124, 6, 11, 11, 7, 1, 0, 72,
  168, 144, 0, 112, 136, 8, 120, 136, 136, 124, 6, 10, 10, 7, 1, 0,
  216, 216, 0, 112, 136, 8, 120, 136, 136, 124, 6, 11, 11, 7, 1, 0,
  48, 72, 72, 48, 112, 136, 8, 120, 136, 136, 124, 10, 7, 14, 11, 1,
  0, 115, 128, 140, 64, 15, 192, 120, 0, 136, 0, 140, 64, 115, 128, 5,
  10, 10, 6, 1, 253, 112, 136, 128, 128, 128, 136, 112, 32, 16, 112, 5,
  12, 12, 6, 1, 0, 64, 96, 32, 16, 0, 112, 136, 248, 128, 128, 136,
  112, 5, 12, 12, 6, 1, 0, 16, 48, 32, 64, 0, 112, 136, 248, 128,
  128, 136, 112, 5, 11, 11, 6, 1, 0, 32, 112, 136, 0, 112, 136, 248,
  128, 128, 136, 112, 5, 10, 10, 6, 1, 0, 216, 216, 0, 112, 136, 248,
  128, 128, 136, 112, 4, 12, 12, 4, 0, 0, 128, 192, 64, 32, 0, 96,
  32, 32, 32, 32, 32, 112, 4, 12, 12, 4, 1, 0, 16, 48, 32, 64,
  0, 192, 64, 64, 64, 64, 64, 224, 5, 11, 11, 5, 0, 0, 32, 112,
  136, 0, 96, 32, 32, 32, 32, 32, 112, 5, 10, 10, 6, 0, 0, 216,
  216, 0, 96, 32, 32, 32, 32, 32, 112, 5, 12, 12, 6, 1, 0, 80,
  112, 224, 16, 16, 120, 136, 136, 136, 136, 136, 112, 7, 11, 11, 8, 1,
  0, 72, 168, 144, 0, 248, 68, 68, 68, 68, 68, 238, 5, 12, 12, 6,
  1, 0, 64, 96, 32, 16, 0, 112, 136, 136, 136, 136, 136, 112, 5, 12,
  12, 6, 1, 0, 16, 48, 32, 64, 0, 112, 136, 136, 136, 136, 136, 112,
  5, 11, 11, 6, 1, 0, 32, 112, 136, 0, 112, 136, 136, 136, 136, 136,
  112, 5, 11, 11, 6, 1, 0, 72, 168, 144, 0, 112, 136, 136, 136, 136,
  136, 112, 5, 10, 10, 6, 1, 0, 216, 216, 0, 112, 136, 136, 136, 136,
  136, 112, 9, 7, 14, 11, 1, 0, 8, 0, 8, 0, 0, 0, 255, 128,
  0, 0, 8, 0, 8, 0, 5, 11, 11, 6, 1, 254, 8, 16, 112, 152,
  168, 168, 168, 200, 112, 64, 128, 7, 12, 12, 8, 1, 0, 64, 96, 32,
  16, 0, 204, 68, 68, 68, 68, 68, 62, 7, 12, 12, 8, 1, 0, 8,
  24, 16, 32, 0, 204, 68, 68, 68, 68, 68, 62, 7, 11, 11, 8, 1,
  0, 16, 56, 68, 0, 204, 68, 68, 68, 68, 68, 62, 7, 10, 10, 8,
  1, 0, 108, 108, 0, 204, 68, 68, 68, 68, 68, 62, 8, 15, 15, 8,
  1, 253, 4, 12, 8, 16, 0, 231, 36, 36, 36, 24, 24, 24, 16, 144,
  224, 6, 15, 15, 7, 1, 253, 192, 64, 64, 64, 64, 120, 68, 68, 68,
  68, 68, 120, 64, 64, 224, 8, 13, 13, 8, 1, 253, 54, 54, 0, 231,
  36, 36, 36, 24, 24, 24, 16, 144, 224
};

/*
  Fontname: cursor
  Copyright: These glyphs are unencumbered
  Capital A Height: 15, '1' Height: 16
  Calculated Max Values w=16 h=16 x= 1 y= 0 dx=17 dy= 0 ascent=15 len=32
  Font Bounding box     w=31 h=31 x=-15 y=-16
  Calculated Min Values           x=-15 y=-16 dx= 0 dy= 0
  Pure Font   ascent =15 descent=-8
  X Font      ascent =16 descent=-16
  Max Font    ascent =15 descent=-16
*/
const u8g_fntpgm_uint8_t u8g_font_cursor[5286] U8G_FONT_SECTION("u8g_font_cursor") = {
  0, 31, 31, 241, 240, 15, 4, 101, 8, 211, 32, 255, 248, 15, 240, 16,
  240, 14, 14, 28, 17, 250, 248, 224, 28, 240, 60, 248, 124, 124, 248, 63,
  240, 31, 224, 15, 192, 15, 192, 31, 224, 63, 240, 124, 248, 248, 124, 240,
  60, 224, 28, 16, 16, 32, 17, 249, 247, 240, 15, 248, 31, 252, 63, 254,
  127, 127, 254, 63, 252, 31, 248, 15, 240, 15, 240, 31, 248, 63, 252, 127,
  254, 254, 127, 252, 63, 248, 31, 240, 15, 14, 14, 28, 17, 243, 242, 0,
  12, 0, 60, 0, 248, 3, 248, 15, 240, 63, 240, 3, 224, 7, 224, 14,
  192, 28, 192, 56, 128, 112, 128, 224, 0, 64, 0, 16, 16, 32, 17, 242,
  241, 0, 7, 0, 31, 0, 127, 1, 254, 7, 254, 31, 252, 63, 252, 63,
  248, 7, 248, 15, 240, 31, 240, 62, 224, 124, 224, 248, 64, 112, 0, 32,
  0, 8, 10, 10, 17, 253, 255, 255, 0, 255, 24, 24, 24, 24, 90, 60,
  24, 10, 12, 24, 17, 252, 254, 255, 192, 255, 192, 255, 192, 255, 192, 255,
  192, 30, 0, 30, 0, 127, 128, 127, 128, 127, 128, 63, 0, 30, 0, 8,
  10, 10, 17, 253, 255, 24, 60, 90, 24, 24, 24, 24, 255, 0, 255, 10,
  12, 24, 17, 252, 254, 12, 0, 30, 0, 127, 128, 127, 128, 127, 128, 30,
  0, 30, 0, 255, 192, 255, 192, 255, 192, 255, 192, 255, 192, 16, 8, 16,
  17, 242, 251, 1, 0, 7, 192, 136, 96, 255, 255, 0, 24, 0, 32, 0,
  64, 255, 192, 16, 9, 18, 17, 242, 251, 7, 0, 15, 192, 159, 224, 255,
  255, 255, 255, 255, 255, 255, 248, 255, 224, 255, 192, 13, 14, 28, 17, 250,
  248, 226, 56, 34, 32, 34, 32, 34, 32, 255, 248, 162, 40, 162, 40, 162,
  40, 162, 40, 255, 248, 34, 32, 34, 32, 34, 32, 226, 56, 15, 16, 32,
  17, 249, 247, 251, 190, 251, 190, 251, 190, 59, 184, 255, 254, 255, 254, 255,
  254, 251, 190, 251, 190, 255, 254, 255, 254, 255, 254, 59, 184, 251, 190, 251,
  190, 251, 190, 14, 14, 28, 17, 0, 255, 192, 0, 192, 0, 196, 16, 196,
  32, 196, 64, 196, 128, 197, 0, 198, 0, 199, 240, 192, 0, 192, 0, 192,
  0, 255, 252, 255, 252, 16, 16, 32, 17, 255, 254, 240, 0, 240, 0, 247,
  12, 247, 28, 247, 56, 247, 112, 247, 224, 247, 192, 247, 252, 247, 252, 247,
  252, 240, 0, 255, 255, 255, 255, 255, 255, 255, 255, 14, 14, 28, 17, 243,
  255, 0, 12, 0, 12, 32, 140, 16, 140, 8, 140, 4, 140, 2, 140, 1,
  140, 63, 140, 0, 12, 0, 12, 0, 12, 255, 252, 255, 252, 16, 16, 32,
  17, 242, 254, 0, 15, 0, 15, 48, 239, 56, 239, 28, 239, 14, 239, 7,
  239, 3, 239, 63, 239, 63, 239, 63, 239, 0, 15, 255, 255, 255, 255, 255,
  255, 255, 255, 13, 14, 28, 17, 250, 255, 2, 0, 2, 0, 2, 0, 2,
  0, 2, 0, 2, 0, 34, 32, 18, 64, 10, 128, 7, 0, 2, 0, 0,
  0, 255, 248, 255, 248, 15, 16, 32, 17, 249, 254, 3, 128, 3, 128, 3,
  128, 3, 128, 3, 128, 3, 128, 51, 152, 59, 184, 31, 240, 15, 224, 7,
  192, 3, 128, 255, 254, 255, 254, 255, 254, 255, 254, 14, 10, 20, 17, 249,
  255, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3,
  0, 255, 252, 255, 252, 16, 12, 24, 17, 248, 254, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 255, 255, 255, 255, 255,
  255, 255, 255, 15, 16, 32, 17, 248, 248, 255, 254, 128, 0, 191, 254, 160,
  2, 175, 250, 168, 10, 171, 234, 170, 42, 170, 170, 171, 170, 168, 42, 175,
  234, 160, 10, 191, 250, 128, 2, 255, 254, 16, 16, 32, 17, 248, 248, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 10,
  14, 28, 17, 252, 242, 12, 0, 12, 0, 30, 0, 30, 0, 63, 0, 63,
  0, 127, 128, 127, 128, 204, 192, 140, 64, 12, 0, 12, 0, 12, 0, 12,
  0, 12, 16, 32, 17, 251, 241, 15, 0, 15, 0, 31, 128, 31, 128, 63,
  192, 63, 192, 127, 224, 127, 224, 255, 240, 255, 240, 255, 240, 239, 112, 15,
  0, 15, 0, 15, 0, 15, 0, 14, 14, 28, 17, 249, 249, 7, 128, 31,
  224, 63, 240, 120, 120, 112, 56, 224, 28, 224, 28, 224, 28, 224, 28, 112,
  56, 120, 120, 63, 240, 31, 224, 7, 128, 16, 16, 32, 17, 248, 248, 7,
  224, 31, 248, 63, 252, 127, 254, 127, 254, 252, 63, 248, 31, 248, 31, 248,
  31, 248, 31, 252, 63, 127, 254, 127, 254, 63, 252, 31, 248, 7, 224, 14,
  16, 32, 17, 250, 243, 63, 240, 103, 152, 200, 204, 147, 36, 158, 36, 136,
  68, 199, 140, 127, 248, 83, 40, 83, 40, 83, 40, 87, 168, 211, 44, 240,
  60, 255, 252, 255, 252, 15, 16, 32, 17, 250, 243, 127, 248, 239, 156, 219,
  238, 183, 182, 191, 246, 159, 102, 207, 206, 255, 252, 215, 172, 215, 172, 215,
  172, 223, 236, 215, 174, 243, 62, 255, 254, 255, 254, 15, 16, 32, 17, 249,
  249, 31, 240, 32, 8, 96, 6, 80, 26, 79, 226, 192, 2, 192, 2, 64,
  2, 64, 2, 89, 26, 106, 170, 235, 170, 218, 154, 64, 2, 64, 2, 63,
  252, 16, 16, 32, 17, 249, 249, 31, 240, 63, 248, 127, 255, 127, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 127, 255, 127, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 127, 255, 63, 252, 16, 15, 30, 17, 249, 248, 2, 128, 2,
  128, 2, 128, 2, 128, 2, 128, 2, 128, 254, 255, 0, 0, 254, 255, 2,
  128, 2, 128, 2, 128, 2, 128, 2, 128, 2, 128, 16, 16, 32, 17, 249,
  247, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7,
  192, 16, 15, 30, 17, 249, 248, 66, 132, 162, 138, 82, 148, 42, 168, 22,
  208, 10, 160, 253, 127, 2, 128, 253, 127, 10, 160, 22, 208, 42, 168, 82,
  148, 162, 138, 66, 132, 16, 15, 30, 17, 249, 248, 102, 204, 182, 219, 222,
  246, 110, 236, 54, 216, 250, 191, 252, 127, 1, 0, 252, 127, 250, 191, 54,
  216, 110, 236, 222, 246, 182, 219, 102, 204, 16, 15, 30, 17, 249, 248, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 254, 255, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 16, 16, 32,
  17, 249, 247, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 255,
  255, 255, 255, 255, 255, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3,
  128, 3, 128, 15, 15, 30, 17, 249, 248, 2, 128, 6, 192, 10, 160, 18,
  144, 34, 136, 66, 132, 254, 254, 0, 0, 254, 254, 66, 132, 34, 136, 18,
  144, 10, 160, 6, 192, 2, 128, 16, 16, 32, 17, 249, 247, 7, 192, 15,
  224, 31, 240, 59, 184, 115, 156, 227, 142, 255, 255, 254, 255, 255, 255, 227,
  142, 115, 156, 59, 184, 31, 240, 15, 224, 7, 192, 3, 128, 10, 10, 20,
  17, 251, 251, 30, 0, 127, 128, 127, 128, 255, 192, 255, 192, 255, 192, 255,
  192, 127, 128, 127, 128, 30, 0, 12, 12, 24, 17, 250, 250, 31, 128, 127,
  224, 127, 224, 255, 240, 255, 240, 255, 240, 255, 240, 255, 240, 255, 240, 127,
  224, 127, 224, 31, 128, 12, 12, 24, 17, 250, 249, 255, 240, 128, 16, 128,
  16, 128, 16, 128, 16, 134, 16, 134, 16, 128, 16, 128, 16, 128, 16, 128,
  16, 255, 240, 14, 14, 28, 17, 249, 248, 255, 252, 255, 252, 255, 252, 224,
  28, 224, 28, 231, 156, 231, 156, 231, 156, 231, 156, 224, 28, 224, 28, 255,
  252, 255, 252, 255, 252, 10, 14, 28, 17, 251, 249, 12, 0, 30, 0, 63,
  0, 109, 128, 204, 192, 12, 0, 12, 0, 12, 0, 12, 0, 204, 192, 109,
  128, 63, 0, 30, 0, 12, 0, 12, 16, 32, 17, 250, 248, 15, 0, 31,
  128, 63, 192, 127, 224, 255, 240, 255, 240, 255, 240, 15, 0, 15, 0, 255,
  240, 255, 240, 255, 240, 127, 224, 63, 192, 31, 128, 15, 0, 15, 15, 30,
  17, 242, 241, 0, 2, 0, 12, 0, 60, 0, 248, 3, 248, 15, 240, 63,
  240, 1, 224, 2, 224, 4, 192, 8, 192, 16, 128, 32, 128, 64, 0, 128,
  0, 15, 16, 32, 17, 242, 240, 0, 6, 0, 30, 0, 126, 1, 252, 7,
  248, 31, 248, 127, 240, 127, 240, 7, 224, 15, 224, 29, 192, 57, 192, 113,
  128, 225, 128, 192, 0, 128, 0, 15, 15, 30, 17, 242, 241, 0, 2, 0,
  12, 0, 60, 0, 248, 3, 248, 0, 112, 0, 176, 1, 32, 2, 32, 4,
  0, 8, 0, 16, 0, 32, 0, 64, 0, 128, 0, 15, 15, 30, 17, 242,
  241, 0, 6, 0, 30, 0, 124, 1, 252, 7, 248, 7, 248, 1, 240, 3,
  240, 7, 96, 14, 64, 28, 0, 56, 0, 112, 0, 224, 0, 192, 0, 12,
  12, 24, 17, 250, 249, 255, 240, 137, 16, 153, 144, 176, 208, 224, 112, 134,
  16, 134, 16, 224, 112, 176, 208, 153, 144, 137, 16, 255, 240, 14, 14, 28,
  17, 249, 248, 255, 252, 255, 252, 207, 204, 223, 236, 252, 252, 251, 124, 247,
  188, 247, 188, 251, 124, 252, 252, 223, 236, 207, 204, 255, 252, 255, 252, 14,
  14, 28, 17, 250, 248, 143, 192, 223, 224, 248, 48, 144, 16, 152, 0, 252,
  0, 0, 0, 0, 0, 0, 252, 0, 100, 32, 36, 48, 124, 31, 236, 15,
  196, 16, 16, 32, 17, 249, 247, 199, 224, 239, 240, 255, 248, 255, 252, 252,
  28, 255, 12, 255, 0, 255, 0, 0, 255, 0, 255, 48, 127, 56, 63, 63,
  255, 31, 255, 15, 247, 7, 227, 14, 14, 28, 17, 249, 249, 3, 0, 7,
  128, 15, 192, 3, 0, 35, 16, 99, 24, 255, 252, 255, 252, 99, 24, 35,
  16, 3, 0, 15, 192, 7, 128, 3, 0, 16, 16, 32, 17, 248, 248, 3,
  192, 3, 224, 7, 224, 15, 240, 23, 232, 59, 220, 255, 255, 255, 255, 255,
  255, 255, 255, 59, 220, 23, 232, 15, 240, 7, 224, 3, 192, 3, 192, 16,
  15, 30, 17, 242, 243, 0, 120, 0, 112, 128, 51, 159, 176, 255, 240, 254,
  48, 252, 48, 96, 56, 0, 240, 31, 224, 8, 0, 8, 0, 8, 0, 8,
  0, 30, 0, 16, 16, 32, 17, 242, 243, 0, 252, 0, 252, 192, 255, 255,
  255, 255, 255, 255, 252, 255, 252, 255, 252, 255, 252, 255, 252, 127, 248, 31,
  240, 28, 0, 28, 0, 63, 0, 63, 0, 16, 16, 32, 17, 254, 240, 63,
  0, 16, 128, 200, 64, 234, 160, 200, 32, 203, 160, 248, 60, 56, 63, 8,
  39, 8, 39, 9, 47, 9, 39, 9, 32, 17, 16, 33, 8, 62, 248, 16,
  16, 32, 17, 254, 240, 63, 0, 223, 128, 239, 192, 255, 224, 239, 224, 239,
  252, 255, 254, 255, 255, 63, 239, 15, 239, 15, 255, 15, 239, 15, 231, 31,
  240, 63, 248, 62, 248, 13, 16, 32, 17, 244, 240, 0, 24, 0, 120, 1,
  224, 3, 192, 7, 128, 15, 192, 31, 224, 95, 192, 255, 224, 191, 224, 15,
  192, 15, 128, 148, 0, 196, 0, 104, 0, 48, 0, 13, 16, 32, 17, 244,
  240, 0, 56, 0, 248, 3, 240, 7, 224, 15, 192, 31, 224, 127, 240, 255,
  240, 255, 240, 255, 240, 255, 224, 255, 192, 255, 128, 254, 0, 252, 0, 120,
  0, 15, 14, 28, 17, 0, 242, 127, 128, 128, 64, 126, 32, 16, 16, 14,
  16, 16, 16, 14, 40, 16, 68, 12, 130, 3, 4, 2, 72, 1, 16, 0,
  160, 0, 64, 16, 16, 32, 17, 0, 241, 127, 128, 255, 192, 255, 224, 255,
  240, 127, 248, 31, 248, 63, 248, 31, 252, 63, 254, 31, 255, 15, 254, 7,
  252, 3, 248, 1, 240, 0, 224, 0, 64, 15, 14, 28, 17, 250, 250, 62,
  248, 99, 140, 193, 6, 128, 2, 128, 2, 128, 2, 128, 2, 192, 6, 96,
  12, 48, 24, 24, 48, 12, 96, 6, 192, 3, 128, 15, 14, 28, 17, 250,
  250, 62, 248, 127, 252, 227, 142, 193, 6, 192, 6, 192, 6, 194, 134, 225,
  14, 112, 28, 56, 56, 28, 112, 15, 224, 7, 192, 3, 128, 16, 16, 32,
  17, 248, 248, 255, 255, 213, 85, 170, 171, 213, 85, 160, 11, 208, 5, 160,
  11, 208, 5, 160, 11, 208, 5, 160, 11, 208, 5, 170, 171, 213, 85, 170,
  171, 255, 255, 16, 16, 32, 17, 248, 248, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 14, 14, 28, 17, 249, 248, 127,
  248, 63, 240, 159, 228, 207, 204, 231, 156, 243, 60, 255, 252, 255, 252, 243,
  60, 231, 156, 207, 204, 159, 228, 63, 240, 127, 248, 16, 16, 32, 17, 248,
  247, 63, 252, 127, 254, 127, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 127, 254, 127, 254, 63,
  252, 8, 14, 14, 17, 0, 242, 128, 192, 224, 240, 248, 252, 254, 255, 248,
  216, 140, 12, 6, 6, 10, 16, 32, 17, 255, 241, 192, 0, 224, 0, 240,
  0, 248, 0, 252, 0, 254, 0, 255, 0, 255, 128, 255, 192, 255, 192, 254,
  0, 239, 0, 207, 0, 7, 128, 7, 128, 3, 0, 14, 13, 26, 17, 0,
  249, 192, 0, 192, 0, 193, 0, 194, 0, 196, 0, 200, 0, 223, 252, 200,
  0, 196, 0, 194, 0, 193, 0, 192, 0, 192, 0, 16, 15, 30, 17, 255,
  248, 240, 0, 240, 0, 240, 192, 241, 192, 243, 128, 247, 0, 255, 255, 255,
  255, 255, 255, 247, 0, 243, 128, 241, 192, 240, 192, 240, 0, 240, 0, 10,
  14, 28, 17, 0, 249, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 255, 192, 255, 192, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 12, 16, 32, 17, 255, 248, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 255, 240, 255, 240, 255, 240, 255, 240, 240, 0, 240, 0, 240,
  0, 240, 0, 240, 0, 240, 0, 16, 16, 32, 17, 248, 248, 128, 3, 127,
  253, 127, 253, 68, 69, 69, 85, 69, 85, 69, 85, 69, 85, 68, 69, 127,
  253, 127, 253, 127, 253, 127, 253, 127, 253, 127, 253, 128, 3, 15, 16, 32,
  17, 248, 248, 127, 252, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255,
  254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255,
  254, 127, 252, 10, 10, 20, 17, 0, 255, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 192, 255, 192, 12, 12, 24,
  17, 255, 254, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 255, 240, 255, 240, 255, 240, 255, 240, 10, 10, 20, 17, 247,
  255, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0,
  192, 255, 192, 255, 192, 12, 12, 24, 17, 246, 254, 0, 240, 0, 240, 0,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 255, 240, 255, 240, 255,
  240, 255, 240, 16, 16, 32, 17, 242, 245, 3, 128, 30, 240, 2, 128, 129,
  0, 67, 135, 36, 75, 29, 112, 5, 64, 4, 64, 2, 128, 4, 64, 9,
  32, 18, 144, 20, 80, 120, 60, 248, 63, 16, 16, 32, 17, 242, 245, 31,
  224, 63, 240, 63, 248, 195, 130, 231, 199, 127, 255, 63, 251, 31, 240, 7,
  224, 7, 192, 15, 224, 31, 240, 63, 248, 126, 252, 252, 127, 252, 127, 16,
  16, 32, 17, 248, 248, 128, 3, 127, 253, 127, 253, 68, 69, 84, 85, 84,
  85, 84, 85, 84, 85, 68, 69, 127, 253, 127, 253, 127, 253, 127, 253, 127,
  253, 127, 253, 128, 3, 15, 16, 32, 17, 248, 248, 127, 252, 255, 254, 255,
  254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255,
  254, 255, 254, 255, 254, 255, 254, 255, 254, 127, 252, 15, 14, 28, 17, 252,
  243, 7, 0, 12, 0, 6, 0, 3, 0, 127, 248, 128, 4, 179, 54, 179,
  54, 179, 54, 128, 6, 128, 6, 96, 28, 24, 96, 7, 128, 16, 16, 32,
  17, 252, 241, 15, 128, 30, 0, 15, 0, 7, 0, 127, 248, 255, 252, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 63, 247, 31, 224, 15,
  192, 7, 128, 11, 16, 32, 17, 246, 255, 112, 0, 136, 0, 140, 0, 74,
  0, 122, 0, 33, 0, 17, 0, 16, 128, 8, 128, 12, 64, 4, 64, 2,
  32, 1, 224, 0, 224, 0, 96, 0, 32, 13, 16, 32, 17, 245, 255, 252,
  0, 254, 0, 255, 0, 127, 0, 63, 128, 63, 128, 31, 192, 15, 192, 15,
  224, 7, 224, 7, 240, 3, 248, 1, 248, 0, 248, 0, 120, 0, 56, 15,
  16, 32, 17, 249, 252, 7, 128, 15, 192, 31, 224, 51, 48, 51, 48, 31,
  224, 15, 192, 7, 128, 135, 132, 135, 134, 67, 8, 56, 112, 7, 128, 31,
  226, 240, 62, 128, 4, 16, 16, 32, 17, 249, 252, 15, 192, 31, 224, 63,
  240, 127, 248, 127, 248, 63, 240, 31, 224, 143, 193, 143, 199, 207, 207, 247,
  156, 120, 120, 7, 128, 127, 227, 255, 255, 240, 62, 10, 10, 20, 17, 252,
  251, 12, 0, 12, 0, 12, 0, 12, 0, 255, 192, 255, 192, 12, 0, 12,
  0, 12, 0, 12, 0, 12, 12, 24, 17, 251, 250, 15, 0, 15, 0, 15,
  0, 15, 0, 255, 240, 255, 240, 255, 240, 255, 240, 15, 0, 15, 0, 15,
  0, 15, 0, 9, 15, 30, 17, 252, 248, 62, 0, 127, 0, 227, 128, 193,
  128, 225, 128, 99, 128, 7, 0, 30, 0, 28, 0, 20, 0, 20, 0, 119,
  0, 54, 0, 28, 0, 8, 0, 11, 16, 32, 17, 251, 248, 31, 0, 63,
  128, 127, 192, 255, 224, 241, 224, 249, 224, 123, 224, 63, 192, 31, 128, 31,
  0, 31, 0, 63, 128, 127, 192, 63, 128, 31, 0, 14, 0, 8, 14, 14,
  17, 249, 242, 1, 3, 7, 15, 31, 63, 127, 255, 31, 27, 49, 48, 96,
  96, 10, 16, 32, 17, 248, 241, 0, 192, 1, 192, 3, 192, 7, 192, 15,
  192, 31, 192, 63, 192, 127, 192, 255, 192, 255, 192, 31, 192, 61, 192, 60,
  192, 120, 0, 120, 0, 48, 0, 14, 13, 26, 17, 243, 249, 0, 12, 0,
  12, 2, 12, 1, 12, 0, 140, 0, 76, 255, 236, 0, 76, 0, 140, 1,
  12, 2, 12, 0, 12, 0, 12, 16, 15, 30, 17, 242, 248, 0, 15, 0,
  15, 3, 15, 3, 143, 1, 207, 0, 239, 255, 255, 255, 255, 255, 255, 0,
  239, 1, 207, 3, 143, 3, 15, 0, 15, 0, 15, 10, 14, 28, 17, 247,
  249, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 255, 192, 255,
  192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 12, 16, 32,
  17, 246, 248, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 255,
  240, 255, 240, 255, 240, 255, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0,
  240, 0, 240, 16, 16, 32, 17, 248, 248, 128, 3, 127, 253, 127, 253, 68,
  69, 85, 69, 85, 69, 85, 69, 85, 69, 68, 69, 127, 253, 127, 253, 127,
  253, 127, 253, 127, 253, 127, 253, 128, 3, 15, 16, 32, 17, 248, 248, 127,
  252, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255,
  254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 255, 254, 127, 252, 14,
  14, 28, 17, 250, 248, 255, 252, 128, 68, 128, 68, 128, 68, 255, 196, 136,
  68, 136, 68, 136, 68, 136, 68, 143, 252, 136, 4, 136, 4, 136, 4, 255,
  252, 16, 16, 32, 17, 249, 247, 255, 255, 255, 255, 255, 255, 224, 119, 255,
  247, 255, 247, 255, 247, 238, 119, 238, 119, 239, 255, 239, 255, 239, 255, 238,
  7, 255, 255, 255, 255, 255, 255, 12, 13, 26, 17, 250, 242, 1, 0, 1,
  0, 5, 128, 5, 128, 13, 128, 13, 192, 29, 192, 29, 192, 61, 224, 61,
  224, 125, 224, 125, 240, 248, 224, 16, 16, 32, 17, 248, 240, 0, 192, 0,
  224, 1, 224, 3, 240, 3, 240, 7, 240, 7, 248, 15, 248, 15, 248, 31,
  252, 31, 252, 63, 252, 63, 255, 127, 255, 255, 248, 127, 224, 7, 15, 15,
  17, 253, 0, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 254, 124,
  56, 16, 9, 16, 32, 17, 252, 255, 62, 0, 62, 0, 62, 0, 62, 0,
  62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 255, 128, 255, 128,
  127, 0, 62, 0, 28, 0, 8, 0, 15, 7, 14, 17, 249, 252, 16, 16,
  48, 24, 127, 252, 240, 30, 127, 252, 48, 24, 16, 16, 15, 9, 18, 17,
  249, 251, 24, 48, 56, 56, 127, 252, 255, 254, 255, 254, 255, 254, 127, 252,
  56, 56, 24, 48, 15, 7, 14, 17, 1, 252, 16, 0, 48, 0, 127, 254,
  240, 0, 127, 254, 48, 0, 16, 0, 16, 9, 18, 17, 0, 251, 12, 0,
  28, 0, 63, 255, 127, 255, 255, 255, 127, 255, 63, 255, 28, 0, 12, 0,
  15, 7, 14, 17, 241, 252, 0, 16, 0, 24, 255, 252, 0, 30, 255, 252,
  0, 24, 0, 16, 16, 9, 18, 17, 241, 251, 0, 48, 0, 56, 255, 252,
  255, 254, 255, 255, 255, 254, 255, 252, 0, 56, 0, 48, 7, 15, 15, 17,
  253, 240, 16, 56, 124, 254, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
  40, 9, 16, 32, 17, 252, 240, 8, 0, 28, 0, 62, 0, 127, 0, 255,
  128, 255, 128, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62,
  0, 62, 0, 62, 0, 62, 0, 7, 15, 15, 17, 253, 248, 16, 56, 124,
  254, 40, 40, 40, 40, 40, 40, 40, 254, 124, 56, 16, 9, 15, 30, 17,
  252, 248, 28, 0, 62, 0, 127, 0, 255, 128, 255, 128, 62, 0, 62, 0,
  62, 0, 62, 0, 62, 0, 255, 128, 255, 128, 127, 0, 62, 0, 28, 0,
  15, 16, 32, 17, 246, 240, 0, 32, 0, 112, 0, 248, 1, 222, 5, 222,
  9, 222, 17, 222, 17, 222, 17, 222, 17, 222, 49, 222, 113, 222, 253, 222,
  24, 136, 0, 120, 0, 48, 16, 16, 32, 17, 245, 240, 0, 56, 0, 124,
  0, 254, 0, 255, 6, 255, 14, 255, 30, 255, 30, 255, 30, 255, 30, 255,
  62, 255, 126, 255, 254, 255, 126, 254, 12, 126, 0, 60, 14, 14, 28, 17,
  249, 249, 255, 0, 128, 0, 128, 0, 128, 0, 143, 192, 136, 64, 136, 68,
  136, 68, 8, 68, 15, 196, 0, 36, 0, 20, 0, 12, 3, 252, 16, 16,
  32, 17, 248, 248, 255, 192, 255, 192, 255, 192, 224, 0, 239, 240, 239, 240,
  239, 247, 238, 119, 238, 119, 239, 247, 15, 247, 15, 255, 0, 31, 3, 255,
  3, 255, 3, 255, 16, 16, 32, 17, 250, 247, 32, 16, 16, 32, 16, 32,
  8, 64, 8, 64, 135, 135, 103, 152, 31, 224, 31, 224, 103, 152, 135, 135,
  8, 64, 8, 64, 16, 32, 16, 32, 32, 16, 16, 16, 32, 17, 250, 247,
  96, 24, 48, 48, 16, 32, 24, 96, 143, 193, 207, 207, 111, 220, 63, 240,
  63, 224, 111, 248, 207, 207, 143, 193, 24, 64, 24, 96, 48, 48, 96, 24,
  11, 16, 32, 17, 247, 242, 0, 96, 1, 0, 52, 96, 121, 0, 104, 96,
  252, 0, 132, 0, 228, 0, 164, 0, 228, 0, 164, 0, 228, 0, 228, 0,
  132, 0, 132, 0, 252, 0, 12, 16, 32, 17, 246, 242, 0, 48, 24, 176,
  62, 176, 62, 176, 126, 176, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0,
  255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 255, 0, 15, 16, 32, 17,
  249, 247, 1, 0, 2, 128, 2, 128, 2, 128, 4, 64, 4, 64, 4, 64,
  57, 56, 192, 6, 56, 56, 9, 32, 18, 144, 36, 72, 40, 40, 48, 24,
  32, 8, 16, 16, 32, 17, 249, 247, 1, 0, 3, 128, 3, 128, 6, 192,
  6, 192, 12, 96, 28, 120, 249, 62, 192, 7, 248, 62, 57, 56, 51, 152,
  102, 204, 108, 108, 120, 60, 112, 28, 15, 13, 26, 17, 249, 249, 3, 128,
  15, 224, 28, 112, 48, 24, 96, 12, 193, 6, 194, 134, 193, 6, 96, 12,
  48, 24, 28, 112, 15, 224, 3, 128, 16, 14, 28, 17, 249, 249, 7, 192,
  15, 224, 31, 240, 60, 120, 112, 28, 225, 14, 195, 135, 198, 199, 195, 135,
  225, 14, 112, 28, 60, 120, 31, 240, 7, 192, 13, 13, 26, 16, 250, 249,
  2, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 0, 255, 248, 2, 0,
  2, 0, 2, 0, 2, 0, 2, 0, 2, 0, 15, 15, 30, 16, 249, 248,
  3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 255, 254, 255, 254,
  255, 254, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 14, 14,
  28, 17, 0, 242, 192, 0, 240, 0, 124, 0, 127, 0, 63, 192, 63, 240,
  31, 0, 31, 0, 12, 128, 12, 64, 4, 32, 4, 16, 0, 8, 0, 4,
  16, 16, 32, 17, 255, 241, 224, 0, 248, 0, 254, 0, 127, 128, 127, 224,
  63, 252, 63, 252, 31, 252, 31, 192, 15, 224, 15, 112, 7, 56, 7, 28,
  7, 14, 0, 7, 0, 3, 14, 14, 28, 17, 0, 242, 255, 252, 255, 252,
  192, 0, 192, 0, 192, 0, 199, 240, 198, 0, 197, 0, 196, 128, 196, 64,
  196, 32, 196, 16, 192, 0, 192, 0, 16, 16, 32, 17, 255, 241, 255, 255,
  255, 255, 255, 255, 255, 255, 240, 0, 247, 252, 247, 252, 247, 252, 247, 192,
  247, 224, 247, 112, 247, 56, 247, 28, 247, 12, 240, 0, 240, 0, 14, 14,
  28, 17, 243, 242, 255, 252, 255, 252, 0, 12, 0, 12, 0, 12, 63, 140,
  1, 140, 2, 140, 4, 140, 8, 140, 16, 140, 32, 140, 0, 12, 0, 12,
  16, 16, 32, 17, 242, 241, 255, 255, 255, 255, 255, 255, 255, 255, 0, 15,
  63, 239, 63, 239, 63, 239, 3, 239, 7, 239, 14, 239, 28, 239, 56, 239,
  48, 239, 0, 15, 0, 15, 13, 14, 28, 17, 250, 242, 255, 248, 255, 248,
  0, 0, 2, 0, 7, 0, 10, 128, 18, 64, 34, 32, 2, 0, 2, 0,
  2, 0, 2, 0, 2, 0, 2, 0, 15, 16, 32, 17, 249, 241, 255, 254,
  255, 254, 255, 254, 255, 254, 3, 128, 7, 192, 15, 224, 31, 240, 59, 184,
  51, 152, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 14, 10,
  20, 17, 249, 246, 255, 252, 255, 252, 3, 0, 3, 0, 3, 0, 3, 0,
  3, 0, 3, 0, 3, 0, 3, 0, 16, 12, 24, 17, 248, 245, 255, 255,
  255, 255, 255, 255, 255, 255, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192,
  3, 192, 3, 192, 3, 192, 7, 16, 16, 17, 253, 240, 16, 0, 56, 124,
  254, 238, 254, 124, 56, 16, 186, 214, 146, 130, 130, 130, 9, 16, 32, 17,
  252, 240, 28, 0, 28, 0, 62, 0, 127, 0, 255, 128, 255, 128, 255, 128,
  127, 0, 62, 0, 93, 0, 255, 128, 255, 128, 255, 128, 235, 128, 235, 128,
  227, 128, 10, 10, 20, 17, 0, 246, 255, 192, 255, 192, 192, 0, 192, 0,
  192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 12, 12, 24, 17,
  255, 245, 255, 240, 255, 240, 255, 240, 255, 240, 240, 0, 240, 0, 240, 0,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 14, 14, 28, 17, 249, 244,
  17, 32, 4, 80, 147, 76, 79, 144, 50, 96, 194, 24, 2, 0, 2, 0,
  2, 0, 2, 0, 2, 0, 2, 128, 2, 128, 1, 0, 16, 16, 32, 17,
  248, 242, 23, 110, 223, 251, 191, 252, 127, 255, 255, 252, 255, 255, 243, 158,
  3, 128, 3, 128, 3, 128, 3, 128, 3, 224, 3, 224, 3, 224, 3, 224,
  1, 192, 10, 10, 20, 17, 247, 246, 255, 192, 255, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 12, 12, 24, 17,
  246, 245, 255, 240, 255, 240, 255, 240, 255, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 16, 16, 32, 17, 241, 249,
  31, 224, 31, 224, 31, 224, 63, 240, 97, 24, 193, 12, 129, 7, 131, 135,
  131, 135, 132, 7, 200, 12, 96, 24, 63, 240, 31, 224, 31, 224, 31, 224,
  16, 16, 32, 17, 241, 249, 63, 240, 63, 240, 63, 240, 127, 248, 255, 252,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 252, 127, 248,
  63, 240, 63, 240, 63, 240, 7, 14, 14, 10, 253, 249, 238, 56, 16, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 56, 238, 9, 16, 32, 10, 252, 248,
  247, 128, 255, 128, 255, 128, 62, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 62, 0, 255, 128, 255, 128, 247, 128,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255
};

/*
  Fontname: cursor
  Copyright: These
  Capital A Height: 0, '1' Height: 0
  Calculated Max Values w=16 h=16 x= 0 y= 0 dx=17 dy= 0 ascent= 7 len=32
  Font Bounding box     w=31 h=31 x=-15 y=-16
  Calculated Min Values           x=-14 y=-16 dx= 0 dy= 0
  Pure Font   ascent = 0 descent= 0
  X Font      ascent = 0 descent= 0
  Max Font    ascent = 7 descent=-16
*/
const u8g_fntpgm_uint8_t u8g_font_cursorr[492] U8G_FONT_SECTION("u8g_font_cursorr") = {
  0, 31, 31, 241, 240, 0, 1, 6, 0, 0, 32, 80, 0, 7, 240, 0,
  0, 255, 255, 14, 14, 28, 17, 243, 242, 0, 12, 0, 60, 0, 248, 3,
  248, 15, 240, 63, 240, 3, 224, 7, 224, 14, 192, 28, 192, 56, 128, 112,
  128, 224, 0, 64, 0, 16, 16, 32, 17, 242, 241, 0, 7, 0, 31, 0,
  127, 1, 254, 7, 254, 31, 252, 63, 252, 63, 248, 7, 248, 15, 240, 31,
  240, 62, 224, 124, 224, 248, 64, 112, 0, 32, 0, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 10, 14, 28,
  17, 252, 242, 12, 0, 12, 0, 30, 0, 30, 0, 63, 0, 63, 0, 127,
  128, 127, 128, 204, 192, 140, 64, 12, 0, 12, 0, 12, 0, 12, 0, 12,
  16, 32, 17, 251, 241, 15, 0, 15, 0, 31, 128, 31, 128, 63, 192, 63,
  192, 127, 224, 127, 224, 255, 240, 255, 240, 255, 240, 239, 112, 15, 0, 15,
  0, 15, 0, 15, 0, 255, 255, 255, 255, 255, 255, 16, 15, 30, 17, 249,
  248, 2, 128, 2, 128, 2, 128, 2, 128, 2, 128, 2, 128, 254, 255, 0,
  0, 254, 255, 2, 128, 2, 128, 2, 128, 2, 128, 2, 128, 2, 128, 16,
  16, 32, 17, 249, 247, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 7, 192, 7, 192, 7, 192, 7,
  192, 7, 192, 7, 192, 255, 255, 16, 15, 30, 17, 249, 248, 1, 0, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 254, 255, 1, 0, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 16, 16, 32, 17, 249,
  247, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 255, 255, 255,
  255, 255, 255, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3,
  128, 255, 255, 255, 255, 255, 255, 255, 255, 15, 15, 30, 17, 242, 241, 0,
  2, 0, 12, 0, 60, 0, 248, 3, 248, 15, 240, 63, 240, 1, 224, 2,
  224, 4, 192, 8, 192, 16, 128, 32, 128, 64, 0, 128, 0, 15, 16, 32,
  17, 242, 240, 0, 6, 0, 30, 0, 126, 1, 252, 7, 248, 31, 248, 127,
  240, 127, 240, 7, 224, 15, 224, 29, 192, 57, 192, 113, 128, 225, 128, 192,
  0, 128, 0, 15, 15, 30, 17, 242, 241, 0, 2, 0, 12, 0, 60, 0,
  248, 3, 248, 0, 112, 0, 176, 1, 32, 2, 32, 4, 0, 8, 0, 16,
  0, 32, 0, 64, 0, 128, 0, 15, 15, 30, 17, 242, 241, 0, 6, 0,
  30, 0, 124, 1, 252, 7, 248, 7, 248, 1, 240, 3, 240, 7, 96, 14,
  64, 28, 0, 56, 0, 112, 0, 224, 0, 192, 0, 255
};

/*
  Fontname: -FreeType-fixed_v01-Medium-R-Normal--8-80-72-72-P-51-ISO10646-1
  Copyright:  www.orgdot.com
  Capital A Height: 7, '1' Height: 7
  Calculated Max Values w= 7 h= 9 x= 2 y= 6 dx= 6 dy= 0 ascent= 7 len= 9
  Font Bounding box     w= 7 h= 9 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 7 descent=-2
  X Font      ascent = 7 descent=-2
  Max Font    ascent = 7 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_fixed_v0[1702] U8G_FONT_SECTION("u8g_font_fixed_v0") = {
  1, 7, 9, 0, 254, 7, 1, 46, 2, 94, 32, 255, 254, 7, 254, 7,
  254, 2, 0, 64, 34, 23, 103, 128, 128, 128, 128, 0, 128, 128, 23, 50,
  98, 160, 160, 3, 85, 101, 80, 248, 80, 248, 80, 2, 87, 103, 112, 168,
  160, 112, 40, 168, 112, 2, 87, 103, 136, 144, 16, 32, 64, 72, 136, 2,
  87, 103, 104, 136, 104, 144, 144, 144, 104, 23, 18, 98, 128, 128, 2, 87,
  103, 56, 64, 128, 128, 128, 64, 56, 2, 87, 103, 224, 16, 8, 8, 8,
  16, 224, 2, 87, 103, 32, 168, 112, 32, 112, 168, 32, 3, 85, 101, 32,
  32, 248, 32, 32, 18, 34, 98, 64, 128, 5, 81, 97, 248, 18, 18, 98,
  128, 128, 2, 87, 103, 8, 16, 16, 32, 64, 64, 128, 2, 87, 103, 112,
  136, 136, 136, 136, 136, 112, 2, 87, 103, 32, 96, 32, 32, 32, 32, 248,
  2, 87, 103, 112, 136, 8, 16, 32, 64, 248, 2, 87, 103, 240, 8, 8,
  48, 8, 8, 240, 2, 87, 103, 16, 144, 144, 248, 16, 16, 16, 2, 87,
  103, 248, 128, 128, 240, 8, 8, 240, 2, 87, 103, 112, 128, 128, 240, 136,
  136, 112, 2, 87, 103, 248, 8, 8, 8, 8, 8, 8, 2, 87, 103, 112,
  136, 136, 112, 136, 136, 112, 2, 87, 103, 112, 136, 136, 248, 8, 8, 112,
  18, 21, 101, 128, 128, 0, 128, 128, 18, 37, 101, 64, 64, 0, 64, 128,
  2, 87, 103, 24, 32, 64, 128, 64, 32, 24, 4, 83, 99, 248, 0, 248,
  2, 87, 103, 192, 32, 16, 8, 16, 32, 192, 2, 87, 103, 248, 8, 8,
  48, 0, 32, 32, 2, 87, 103, 112, 136, 136, 168, 184, 128, 112, 2, 87,
  103, 112, 136, 136, 248, 136, 136, 136, 2, 87, 103, 240, 136, 136, 240, 136,
  136, 240, 2, 87, 103, 112, 136, 128, 128, 128, 136, 112, 2, 87, 103, 240,
  136, 136, 136, 136, 136, 240, 2, 87, 103, 248, 128, 128, 224, 128, 128, 248,
  2, 87, 103, 248, 128, 128, 224, 128, 128, 128, 2, 87, 103, 112, 136, 128,
  184, 136, 136, 112, 2, 87, 103, 136, 136, 136, 248, 136, 136, 136, 2, 87,
  103, 248, 32, 32, 32, 32, 32, 248, 2, 87, 103, 248, 8, 8, 8, 8,
  136, 112, 2, 87, 103, 136, 136, 144, 224, 144, 136, 136, 2, 87, 103, 128,
  128, 128, 128, 128, 128, 248, 2, 87, 103, 136, 136, 216, 168, 136, 136, 136,
  2, 87, 103, 136, 136, 200, 168, 152, 136, 136, 2, 87, 103, 112, 136, 136,
  136, 136, 136, 112, 2, 87, 103, 240, 136, 136, 240, 128, 128, 128, 2, 87,
  103, 112, 136, 136, 136, 136, 168, 112, 2, 87, 103, 240, 136, 136, 240, 160,
  144, 136, 2, 87, 103, 112, 136, 128, 112, 8, 136, 112, 2, 87, 103, 248,
  32, 32, 32, 32, 32, 32, 2, 87, 103, 136, 136, 136, 136, 136, 136, 112,
  2, 87, 103, 136, 136, 136, 136, 136, 80, 32, 2, 87, 103, 136, 136, 136,
  168, 168, 168, 80, 2, 87, 103, 136, 136, 80, 32, 80, 136, 136, 2, 87,
  103, 136, 136, 80, 32, 32, 32, 32, 2, 87, 103, 248, 8, 16, 32, 64,
  128, 248, 18, 55, 103, 224, 128, 128, 128, 128, 128, 224, 2, 87, 103, 128,
  64, 64, 32, 16, 16, 8, 18, 55, 103, 224, 32, 32, 32, 32, 32, 224,
  23, 50, 98, 64, 160, 2, 113, 97, 254, 39, 34, 98, 64, 128, 2, 85,
  101, 112, 8, 120, 136, 120, 2, 87, 103, 128, 128, 240, 136, 136, 136, 240,
  2, 85, 101, 112, 136, 128, 136, 112, 2, 87, 103, 8, 8, 120, 136, 136,
  136, 120, 2, 85, 101, 112, 136, 248, 128, 120, 2, 87, 103, 56, 64, 240,
  64, 64, 64, 64, 0, 87, 103, 112, 136, 136, 136, 120, 8, 112, 2, 87,
  103, 128, 128, 240, 136, 136, 136, 136, 2, 87, 103, 48, 0, 248, 32, 32,
  32, 248, 0, 89, 105, 48, 0, 248, 8, 8, 8, 8, 8, 112, 2, 87,
  103, 128, 128, 136, 144, 224, 144, 136, 2, 87, 103, 224, 32, 32, 32, 32,
  32, 248, 2, 85, 101, 208, 168, 168, 168, 168, 2, 85, 101, 176, 200, 136,
  136, 136, 2, 85, 101, 112, 136, 136, 136, 112, 0, 87, 103, 240, 136, 136,
  136, 240, 128, 128, 0, 87, 103, 120, 136, 136, 136, 120, 8, 8, 2, 85,
  101, 184, 192, 128, 128, 128, 2, 85, 101, 120, 128, 112, 8, 240, 2, 87,
  103, 32, 32, 248, 32, 32, 32, 32, 2, 85, 101, 136, 136, 136, 136, 112,
  2, 85, 101, 136, 136, 136, 80, 32, 2, 85, 101, 136, 168, 168, 168, 80,
  2, 85, 101, 136, 80, 32, 80, 136, 0, 87, 103, 136, 136, 136, 136, 120,
  8, 112, 2, 85, 101, 248, 16, 32, 64, 248, 2, 87, 103, 24, 32, 64,
  192, 64, 32, 24, 34, 23, 103, 128, 128, 128, 128, 128, 128, 128, 2, 87,
  103, 192, 32, 16, 24, 16, 32, 192, 4, 82, 98, 72, 176, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 2,
  87, 103, 48, 0, 248, 32, 32, 32, 248, 2, 87, 103, 32, 112, 168, 160,
  168, 112, 32, 2, 87, 103, 64, 64, 64, 240, 64, 72, 120, 3, 85, 101,
  136, 112, 80, 112, 136, 2, 87, 103, 136, 136, 80, 248, 32, 248, 32, 34,
  23, 103, 128, 128, 128, 0, 128, 128, 128, 2, 87, 103, 120, 128, 120, 136,
  240, 8, 240, 5, 81, 97, 248, 2, 87, 103, 112, 136, 168, 200, 168, 136,
  112, 2, 87, 103, 112, 8, 120, 136, 120, 0, 248, 4, 83, 99, 72, 144,
  72, 4, 82, 98, 248, 8, 255, 2, 87, 103, 112, 136, 248, 200, 200, 136,
  112, 8, 81, 97, 248, 20, 51, 99, 64, 160, 64, 2, 87, 103, 32, 32,
  248, 32, 32, 0, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 4, 83,
  99, 144, 72, 144, 255, 255, 255, 255, 2, 87, 103, 64, 32, 112, 136, 248,
  136, 136, 2, 87, 103, 16, 32, 112, 136, 248, 136, 136, 2, 87, 103, 32,
  80, 112, 136, 248, 136, 136, 2, 87, 103, 72, 176, 112, 136, 248, 136, 136,
  2, 87, 103, 80, 0, 112, 136, 248, 136, 136, 2, 87, 103, 112, 0, 112,
  136, 248, 136, 136, 2, 87, 103, 120, 160, 160, 240, 160, 160, 184, 0, 89,
  105, 112, 136, 128, 128, 128, 136, 112, 32, 96, 2, 87, 103, 64, 32, 248,
  128, 224, 128, 248, 2, 87, 103, 16, 32, 248, 128, 224, 128, 248, 2, 87,
  103, 32, 80, 248, 128, 224, 128, 248, 2, 87, 103, 80, 0, 248, 128, 224,
  128, 248, 2, 87, 103, 64, 32, 248, 32, 32, 32, 248, 2, 87, 103, 16,
  32, 248, 32, 32, 32, 248, 2, 87, 103, 32, 80, 248, 32, 32, 32, 248,
  2, 87, 103, 80, 0, 248, 32, 32, 32, 248, 2, 87, 103, 240, 136, 136,
  232, 136, 136, 240, 2, 87, 103, 72, 176, 136, 200, 168, 152, 136, 2, 87,
  103, 64, 32, 112, 136, 136, 136, 112, 2, 87, 103, 16, 32, 112, 136, 136,
  136, 112, 2, 87, 103, 32, 80, 112, 136, 136, 136, 112, 2, 87, 103, 72,
  176, 112, 136, 136, 136, 112, 2, 87, 103, 80, 0, 112, 136, 136, 136, 112,
  20, 51, 99, 160, 64, 160, 2, 87, 103, 112, 136, 152, 168, 200, 136, 112,
  2, 87, 103, 64, 32, 136, 136, 136, 136, 112, 2, 87, 103, 16, 32, 136,
  136, 136, 136, 112, 2, 87, 103, 32, 80, 136, 136, 136, 136, 112, 2, 87,
  103, 80, 0, 136, 136, 136, 136, 112, 2, 87, 103, 16, 32, 136, 136, 80,
  32, 32, 2, 87, 103, 128, 128, 240, 136, 240, 128, 128, 0, 89, 105, 240,
  136, 136, 176, 136, 136, 176, 128, 128, 2, 87, 103, 64, 32, 112, 8, 120,
  136, 120, 2, 87, 103, 16, 32, 112, 8, 120, 136, 120, 2, 87, 103, 32,
  80, 112, 8, 120, 136, 120, 2, 87, 103, 72, 176, 112, 8, 120, 136, 120,
  2, 87, 103, 80, 0, 112, 8, 120, 136, 120, 2, 87, 103, 48, 0, 112,
  8, 120, 136, 120, 2, 85, 101, 240, 40, 120, 160, 120, 0, 87, 103, 112,
  136, 128, 136, 112, 32, 96, 2, 87, 103, 64, 32, 112, 136, 248, 128, 120,
  2, 87, 103, 16, 32, 112, 136, 248, 128, 120, 2, 87, 103, 32, 80, 112,
  136, 248, 128, 120, 2, 87, 103, 80, 0, 112, 136, 248, 128, 120, 2, 87,
  103, 64, 32, 248, 32, 32, 32, 248, 2, 87, 103, 16, 32, 248, 32, 32,
  32, 248, 2, 87, 103, 32, 80, 248, 32, 32, 32, 248, 2, 87, 103, 80,
  0, 248, 32, 32, 32, 248, 2, 87, 103, 8, 56, 8, 120, 136, 136, 120,
  2, 87, 103, 72, 176, 176, 200, 136, 136, 136, 2, 87, 103, 64, 32, 112,
  136, 136, 136, 112, 2, 87, 103, 16, 32, 112, 136, 136, 136, 112, 2, 87,
  103, 32, 80, 112, 136, 136, 136, 112, 2, 87, 103, 72, 176, 112, 136, 136,
  136, 112, 2, 87, 103, 80, 0, 112, 136, 136, 136, 112, 3, 85, 101, 32,
  0, 248, 0, 32, 2, 85, 101, 112, 152, 168, 200, 112, 2, 87, 103, 64,
  32, 136, 136, 136, 136, 112, 2, 87, 103, 16, 32, 136, 136, 136, 136, 112,
  2, 87, 103, 32, 80, 136, 136, 136, 136, 112, 2, 87, 103, 80, 0, 136,
  136, 136, 136, 112, 0, 89, 105, 16, 32, 136, 136, 136, 136, 120, 8, 112,
  2, 87, 103, 128, 128, 240, 136, 240, 128, 128, 0, 89, 105, 80, 0, 136,
  136, 136, 136, 120, 8, 112
};

/*
  Fontname: -FreeType-fixed_v01-Medium-R-Normal--8-80-72-72-P-51-ISO10646-1
  Copyright:  www.orgdot.com
  Capital A Height: 0, '1' Height: 7
  Calculated Max Values w= 5 h= 7 x= 1 y= 3 dx= 6 dy= 0 ascent= 7 len= 7
  Font Bounding box     w= 7 h= 9 x= 0 y=-2
  Calculated Min Values           x= 0 y= 0 dx= 0 dy= 0
  Pure Font   ascent = 7 descent= 0
  X Font      ascent = 7 descent= 0
  Max Font    ascent = 7 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_fixed_v0n[167] U8G_FONT_SECTION("u8g_font_fixed_v0n") = {
  1, 7, 9, 0, 254, 7, 0, 0, 0, 0, 42, 58, 0, 7, 0, 7,
  0, 2, 87, 103, 32, 168, 112, 32, 112, 168, 32, 3, 85, 101, 32, 32,
  248, 32, 32, 18, 34, 98, 64, 128, 5, 81, 97, 248, 18, 18, 98, 128,
  128, 2, 87, 103, 8, 16, 16, 32, 64, 64, 128, 2, 87, 103, 112, 136,
  136, 136, 136, 136, 112, 2, 87, 103, 32, 96, 32, 32, 32, 32, 248, 2,
  87, 103, 112, 136, 8, 16, 32, 64, 248, 2, 87, 103, 240, 8, 8, 48,
  8, 8, 240, 2, 87, 103, 16, 144, 144, 248, 16, 16, 16, 2, 87, 103,
  248, 128, 128, 240, 8, 8, 240, 2, 87, 103, 112, 128, 128, 240, 136, 136,
  112, 2, 87, 103, 248, 8, 8, 8, 8, 8, 8, 2, 87, 103, 112, 136,
  136, 112, 136, 136, 112, 2, 87, 103, 112, 136, 136, 248, 8, 8, 112, 18,
  21, 101, 128, 128, 0, 128, 128
};

/*
  Fontname: -FreeType-fixed_v01-Medium-R-Normal--8-80-72-72-P-51-ISO10646-1
  Copyright:  www.orgdot.com
  Capital A Height: 7, '1' Height: 7
  Calculated Max Values w= 7 h= 9 x= 2 y= 5 dx= 6 dy= 0 ascent= 7 len= 9
  Font Bounding box     w= 7 h= 9 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 7 descent=-2
  X Font      ascent = 7 descent=-2
  Max Font    ascent = 7 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_fixed_v0r[878] U8G_FONT_SECTION("u8g_font_fixed_v0r") = {
  1, 7, 9, 0, 254, 7, 1, 46, 2, 94, 32, 127, 254, 7, 254, 7,
  254, 2, 0, 64, 34, 23, 103, 128, 128, 128, 128, 0, 128, 128, 23, 50,
  98, 160, 160, 3, 85, 101, 80, 248, 80, 248, 80, 2, 87, 103, 112, 168,
  160, 112, 40, 168, 112, 2, 87, 103, 136, 144, 16, 32, 64, 72, 136, 2,
  87, 103, 104, 136, 104, 144, 144, 144, 104, 23, 18, 98, 128, 128, 2, 87,
  103, 56, 64, 128, 128, 128, 64, 56, 2, 87, 103, 224, 16, 8, 8, 8,
  16, 224, 2, 87, 103, 32, 168, 112, 32, 112, 168, 32, 3, 85, 101, 32,
  32, 248, 32, 32, 18, 34, 98, 64, 128, 5, 81, 97, 248, 18, 18, 98,
  128, 128, 2, 87, 103, 8, 16, 16, 32, 64, 64, 128, 2, 87, 103, 112,
  136, 136, 136, 136, 136, 112, 2, 87, 103, 32, 96, 32, 32, 32, 32, 248,
  2, 87, 103, 112, 136, 8, 16, 32, 64, 248, 2, 87, 103, 240, 8, 8,
  48, 8, 8, 240, 2, 87, 103, 16, 144, 144, 248, 16, 16, 16, 2, 87,
  103, 248, 128, 128, 240, 8, 8, 240, 2, 87, 103, 112, 128, 128, 240, 136,
  136, 112, 2, 87, 103, 248, 8, 8, 8, 8, 8, 8, 2, 87, 103, 112,
  136, 136, 112, 136, 136, 112, 2, 87, 103, 112, 136, 136, 248, 8, 8, 112,
  18, 21, 101, 128, 128, 0, 128, 128, 18, 37, 101, 64, 64, 0, 64, 128,
  2, 87, 103, 24, 32, 64, 128, 64, 32, 24, 4, 83, 99, 248, 0, 248,
  2, 87, 103, 192, 32, 16, 8, 16, 32, 192, 2, 87, 103, 248, 8, 8,
  48, 0, 32, 32, 2, 87, 103, 112, 136, 136, 168, 184, 128, 112, 2, 87,
  103, 112, 136, 136, 248, 136, 136, 136, 2, 87, 103, 240, 136, 136, 240, 136,
  136, 240, 2, 87, 103, 112, 136, 128, 128, 128, 136, 112, 2, 87, 103, 240,
  136, 136, 136, 136, 136, 240, 2, 87, 103, 248, 128, 128, 224, 128, 128, 248,
  2, 87, 103, 248, 128, 128, 224, 128, 128, 128, 2, 87, 103, 112, 136, 128,
  184, 136, 136, 112, 2, 87, 103, 136, 136, 136, 248, 136, 136, 136, 2, 87,
  103, 248, 32, 32, 32, 32, 32, 248, 2, 87, 103, 248, 8, 8, 8, 8,
  136, 112, 2, 87, 103, 136, 136, 144, 224, 144, 136, 136, 2, 87, 103, 128,
  128, 128, 128, 128, 128, 248, 2, 87, 103, 136, 136, 216, 168, 136, 136, 136,
  2, 87, 103, 136, 136, 200, 168, 152, 136, 136, 2, 87, 103, 112, 136, 136,
  136, 136, 136, 112, 2, 87, 103, 240, 136, 136, 240, 128, 128, 128, 2, 87,
  103, 112, 136, 136, 136, 136, 168, 112, 2, 87, 103, 240, 136, 136, 240, 160,
  144, 136, 2, 87, 103, 112, 136, 128, 112, 8, 136, 112, 2, 87, 103, 248,
  32, 32, 32, 32, 32, 32, 2, 87, 103, 136, 136, 136, 136, 136, 136, 112,
  2, 87, 103, 136, 136, 136, 136, 136, 80, 32, 2, 87, 103, 136, 136, 136,
  168, 168, 168, 80, 2, 87, 103, 136, 136, 80, 32, 80, 136, 136, 2, 87,
  103, 136, 136, 80, 32, 32, 32, 32, 2, 87, 103, 248, 8, 16, 32, 64,
  128, 248, 18, 55, 103, 224, 128, 128, 128, 128, 128, 224, 2, 87, 103, 128,
  64, 64, 32, 16, 16, 8, 18, 55, 103, 224, 32, 32, 32, 32, 32, 224,
  23, 50, 98, 64, 160, 2, 113, 97, 254, 39, 34, 98, 64, 128, 2, 85,
  101, 112, 8, 120, 136, 120, 2, 87, 103, 128, 128, 240, 136, 136, 136, 240,
  2, 85, 101, 112, 136, 128, 136, 112, 2, 87, 103, 8, 8, 120, 136, 136,
  136, 120, 2, 85, 101, 112, 136, 248, 128, 120, 2, 87, 103, 56, 64, 240,
  64, 64, 64, 64, 0, 87, 103, 112, 136, 136, 136, 120, 8, 112, 2, 87,
  103, 128, 128, 240, 136, 136, 136, 136, 2, 87, 103, 48, 0, 248, 32, 32,
  32, 248, 0, 89, 105, 48, 0, 248, 8, 8, 8, 8, 8, 112, 2, 87,
  103, 128, 128, 136, 144, 224, 144, 136, 2, 87, 103, 224, 32, 32, 32, 32,
  32, 248, 2, 85, 101, 208, 168, 168, 168, 168, 2, 85, 101, 176, 200, 136,
  136, 136, 2, 85, 101, 112, 136, 136, 136, 112, 0, 87, 103, 240, 136, 136,
  136, 240, 128, 128, 0, 87, 103, 120, 136, 136, 136, 120, 8, 8, 2, 85,
  101, 184, 192, 128, 128, 128, 2, 85, 101, 120, 128, 112, 8, 240, 2, 87,
  103, 32, 32, 248, 32, 32, 32, 32, 2, 85, 101, 136, 136, 136, 136, 112,
  2, 85, 101, 136, 136, 136, 80, 32, 2, 85, 101, 136, 168, 168, 168, 80,
  2, 85, 101, 136, 80, 32, 80, 136, 0, 87, 103, 136, 136, 136, 136, 120,
  8, 112, 2, 85, 101, 248, 16, 32, 64, 248, 2, 87, 103, 24, 32, 64,
  192, 64, 32, 24, 34, 23, 103, 128, 128, 128, 128, 128, 128, 128, 2, 87,
  103, 192, 32, 16, 24, 16, 32, 192, 4, 82, 98, 72, 176, 255
};

/*
  Fontname: -FreeType-FreeDooM-Bold-R-Normal--34-340-72-72-P-170-ISO8859-1
  Copyright: FreeUniveral (c) Stephen Wilson 2009    Original Font Sil-Sophia  Copyright (c) SIL International, 1994-2008.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w= 7 h=10 x= 4 y=10 dx= 8 dy= 0 ascent=12 len=10
  Font Bounding box     w= 7 h=12 x= 0 y= 0
  Calculated Min Values           x= 0 y= 0 dx= 0 dy= 0
  Pure Font   ascent =10 descent= 1
  X Font      ascent =12 descent= 0
  Max Font    ascent =12 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_freedoomr10r[1042] U8G_FONT_SECTION("u8g_font_freedoomr10r") = {
  0, 7, 12, 0, 0, 10, 1, 113, 3, 88, 32, 127, 1, 12, 0, 12,
  0, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0,
  7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0,
  0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0,
  1, 3, 10, 10, 7, 0, 2, 96, 128, 128, 128, 128, 128, 128, 128, 128,
  96, 3, 10, 10, 7, 3, 2, 192, 32, 32, 32, 32, 32, 32, 32, 32,
  192, 5, 5, 5, 8, 1, 7, 168, 112, 32, 112, 168, 7, 7, 7, 8,
  0, 4, 16, 16, 16, 254, 16, 16, 16, 2, 2, 2, 7, 2, 10, 64,
  128, 7, 1, 1, 8, 0, 7, 254, 2, 2, 2, 7, 2, 2, 192, 192,
  7, 10, 10, 8, 0, 2, 2, 4, 4, 8, 16, 16, 32, 64, 64, 128,
  6, 10, 10, 7, 0, 2, 252, 132, 132, 132, 132, 132, 132, 132, 132, 252,
  2, 10, 10, 7, 4, 2, 192, 64, 64, 64, 64, 64, 64, 64, 64, 64,
  6, 10, 10, 7, 0, 2, 252, 4, 4, 4, 4, 252, 128, 128, 128, 252,
  6, 10, 10, 7, 0, 2, 252, 4, 4, 4, 60, 4, 4, 4, 4, 252,
  6, 10, 10, 7, 0, 2, 132, 132, 132, 132, 132, 252, 4, 4, 4, 4,
  6, 10, 10, 7, 0, 2, 252, 128, 128, 128, 252, 4, 4, 4, 4, 252,
  6, 10, 10, 7, 0, 2, 252, 128, 128, 128, 252, 132, 132, 132, 132, 252,
  6, 10, 10, 7, 0, 2, 252, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  6, 10, 10, 7, 0, 2, 252, 132, 132, 132, 252, 132, 132, 132, 132, 252,
  6, 10, 10, 7, 0, 2, 252, 132, 132, 132, 252, 4, 4, 4, 4, 252,
  2, 7, 7, 7, 2, 2, 192, 192, 0, 0, 0, 192, 192, 0, 0, 0,
  7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0,
  0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0,
  1, 7, 10, 10, 8, 0, 2, 254, 130, 130, 130, 130, 254, 130, 130, 130,
  130, 7, 10, 10, 8, 0, 2, 254, 130, 130, 130, 252, 130, 130, 130, 130,
  254, 7, 10, 10, 8, 0, 2, 254, 128, 128, 128, 128, 128, 128, 128, 128,
  254, 7, 10, 10, 8, 0, 2, 252, 130, 130, 130, 130, 130, 130, 130, 130,
  252, 7, 10, 10, 8, 0, 2, 254, 128, 128, 128, 248, 128, 128, 128, 128,
  254, 7, 10, 10, 8, 0, 2, 254, 128, 128, 128, 248, 128, 128, 128, 128,
  128, 7, 10, 10, 8, 0, 2, 254, 128, 128, 128, 158, 130, 130, 130, 130,
  254, 7, 10, 10, 8, 0, 2, 130, 130, 130, 130, 254, 130, 130, 130, 130,
  130, 1, 10, 10, 8, 3, 2, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 7, 10, 10, 8, 0, 2, 30, 2, 2, 2, 2, 2, 130, 130, 130,
  124, 7, 10, 10, 8, 0, 2, 130, 132, 136, 144, 224, 160, 144, 136, 132,
  130, 7, 10, 10, 8, 0, 2, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  254, 7, 10, 10, 8, 0, 2, 130, 198, 170, 146, 130, 130, 130, 130, 130,
  130, 7, 10, 10, 8, 0, 2, 194, 194, 162, 162, 146, 146, 138, 138, 134,
  134, 7, 10, 10, 8, 0, 2, 124, 130, 130, 130, 130, 130, 130, 130, 130,
  124, 7, 10, 10, 8, 0, 2, 254, 130, 130, 130, 254, 128, 128, 128, 128,
  128, 7, 10, 10, 8, 0, 2, 120, 132, 132, 132, 132, 132, 132, 132, 132,
  126, 7, 10, 10, 8, 0, 2, 254, 130, 130, 130, 254, 160, 144, 136, 132,
  130, 7, 10, 10, 8, 0, 2, 254, 128, 128, 128, 128, 254, 2, 2, 2,
  254, 7, 9, 9, 8, 0, 3, 254, 16, 16, 16, 16, 16, 16, 16, 16,
  7, 10, 10, 8, 0, 2, 130, 130, 130, 130, 130, 130, 130, 130, 130, 254,
  7, 10, 10, 8, 0, 2, 130, 130, 130, 68, 68, 108, 40, 40, 16, 16,
  7, 10, 10, 8, 0, 2, 130, 130, 130, 130, 130, 146, 146, 170, 170, 198,
  7, 10, 10, 8, 0, 2, 130, 68, 68, 40, 16, 16, 40, 68, 68, 130,
  7, 10, 10, 8, 0, 2, 130, 130, 130, 130, 254, 16, 16, 16, 16, 16,
  7, 10, 10, 8, 0, 2, 254, 2, 6, 12, 24, 48, 96, 192, 128, 254,
  4, 10, 10, 7, 0, 2, 240, 128, 128, 128, 128, 128, 128, 128, 128, 240,
  6, 10, 10, 7, 0, 2, 128, 64, 64, 32, 32, 16, 16, 8, 8, 4,
  4, 10, 10, 7, 2, 2, 240, 16, 16, 16, 16, 16, 16, 16, 16, 240,
  5, 3, 3, 7, 1, 9, 32, 80, 136, 6, 1, 1, 7, 0, 2, 252,
  2, 2, 2, 7, 2, 10, 128, 64, 0, 0, 0, 7, 0, 1, 0, 0,
  0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1,
  0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7,
  0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0,
  0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1,
  0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7,
  0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0,
  0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1,
  0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7,
  0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0,
  0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1,
  0, 0, 0, 7, 0, 1, 0, 0, 0, 7, 0, 1, 0, 0, 0, 7,
  0, 1
};

/*
  Fontname: -FreeType-FreeDooM-Bold-R-Normal--34-340-72-72-P-170-ISO10646-1
  Copyright: FreeUniveral (c) Stephen Wilson 2009    Original Font Sil-Sophia  Copyright (c) SIL International, 1994-2008.
  Capital A Height: 0, '1' Height: 24
  Calculated Max Values w=17 h=24 x= 7 y=13 dx=19 dy= 0 ascent=26 len=72
  Font Bounding box     w=18 h=26 x= 0 y= 0
  Calculated Min Values           x= 0 y= 0 dx= 0 dy= 0
  Pure Font   ascent =24 descent= 0
  X Font      ascent =24 descent= 0
  Max Font    ascent =26 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_freedoomr25n[943] U8G_FONT_SECTION("u8g_font_freedoomr25n") = {
  0, 18, 26, 0, 0, 24, 3, 112, 3, 144, 32, 127, 0, 26, 0, 24,
  0, 0, 0, 0, 11, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 17, 16, 48, 19, 1, 6, 1, 192, 0, 1, 192, 0, 1, 192, 0,
  1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 255, 255, 128, 255,
  255, 128, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192,
  0, 1, 192, 0, 1, 192, 0, 7, 8, 8, 11, 3, 2, 62, 62, 62,
  62, 62, 240, 240, 240, 9, 2, 4, 11, 1, 13, 255, 128, 255, 128, 5,
  5, 5, 11, 5, 2, 248, 248, 248, 248, 248, 255, 17, 24, 72, 19, 1,
  2, 255, 255, 128, 255, 255, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128,
  192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192,
  3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3,
  128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128,
  255, 255, 128, 255, 255, 128, 255, 255, 128, 6, 24, 24, 19, 7, 2, 252,
  252, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 17, 24, 72, 19, 1, 2, 255, 255, 128,
  255, 255, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0,
  3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 255, 255,
  128, 255, 255, 128, 192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0,
  192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 255, 255, 128, 255,
  255, 128, 255, 255, 128, 17, 24, 72, 19, 1, 2, 255, 255, 128, 255, 255,
  128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128,
  0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 31, 255, 128, 31,
  255, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3,
  128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 255, 255, 128, 255, 255, 128,
  255, 255, 128, 17, 24, 72, 19, 1, 2, 192, 3, 128, 192, 3, 128, 192,
  3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3,
  128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 255, 255, 128, 255, 255, 128,
  0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0,
  3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3,
  128, 17, 24, 72, 19, 1, 2, 255, 255, 128, 255, 255, 128, 192, 0, 0,
  192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 192,
  0, 0, 192, 0, 0, 192, 0, 0, 255, 255, 128, 255, 255, 128, 0, 3,
  128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128,
  0, 3, 128, 0, 3, 128, 255, 255, 128, 255, 255, 128, 255, 255, 128, 17,
  24, 72, 19, 1, 2, 255, 255, 128, 255, 255, 128, 192, 0, 0, 192, 0,
  0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0,
  192, 0, 0, 192, 0, 0, 255, 255, 128, 255, 255, 128, 192, 3, 128, 192,
  3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3,
  128, 192, 3, 128, 255, 255, 128, 255, 255, 128, 255, 255, 128, 16, 24, 48,
  19, 2, 2, 255, 255, 255, 255, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 17, 24, 72, 19, 1, 2, 255, 255, 128, 255, 255, 128, 192,
  3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3,
  128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 255, 255, 128, 255, 255, 128,
  192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192,
  3, 128, 192, 3, 128, 192, 3, 128, 255, 255, 128, 255, 255, 128, 255, 255,
  128, 17, 24, 72, 19, 1, 2, 255, 255, 128, 255, 255, 128, 192, 3, 128,
  192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192, 3, 128, 192,
  3, 128, 192, 3, 128, 192, 3, 128, 255, 255, 128, 255, 255, 128, 0, 3,
  128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128, 0, 3, 128,
  0, 3, 128, 0, 3, 128, 255, 255, 128, 255, 255, 128, 255, 255, 128, 5,
  16, 16, 11, 5, 2, 248, 248, 248, 248, 248, 0, 0, 0, 0, 0, 0,
  248, 248, 248, 248, 248, 7, 16, 16, 11, 3, 2, 62, 62, 62, 62, 62,
  0, 0, 0, 62, 62, 62, 62, 62, 240, 240, 240, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255
};

/*
  Fontname: -FreeType-Lucasfont Alternate-Medium-R-Normal--8-80-72-72-P-50-ISO10646-1
  Copyright: Copyright Patrick Lauke 2012  "Lucasfont Alternate" is based on "Lucasfont" by "Patrick Lauke" (http://fontstruct.com/fontstructors/redux)
  Capital A Height: 7, '1' Height: 7
  Calculated Max Values w= 9 h=10 x= 1 y= 4 dx=10 dy= 0 ascent=10 len=14
  Font Bounding box     w= 9 h=11 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 7 descent=-1
  X Font      ascent = 7 descent=-1
  Max Font    ascent =10 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_lucasfont_alternate[2193] U8G_FONT_SECTION("u8g_font_lucasfont_alternate") = {
  0, 9, 11, 0, 255, 7, 1, 148, 3, 22, 32, 255, 255, 10, 255, 7,
  255, 0, 0, 0, 4, 0, 0, 1, 7, 7, 2, 0, 0, 128, 128, 128,
  128, 0, 0, 128, 3, 3, 3, 4, 0, 4, 160, 160, 160, 5, 7, 7,
  6, 0, 0, 80, 80, 248, 80, 248, 80, 80, 5, 7, 7, 6, 0, 0,
  32, 120, 128, 248, 8, 240, 32, 7, 7, 7, 8, 0, 0, 2, 68, 8,
  16, 32, 68, 128, 6, 7, 7, 7, 0, 0, 96, 144, 144, 96, 148, 136,
  116, 1, 3, 3, 2, 0, 4, 128, 128, 128, 3, 7, 7, 4, 0, 0,
  32, 64, 128, 128, 128, 64, 32, 3, 7, 7, 4, 0, 0, 128, 64, 32,
  32, 32, 64, 128, 7, 5, 5, 8, 0, 1, 68, 40, 254, 40, 68, 5,
  5, 5, 6, 0, 1, 32, 32, 248, 32, 32, 2, 3, 3, 3, 0, 255,
  64, 64, 128, 6, 1, 1, 7, 0, 3, 252, 1, 2, 2, 2, 0, 0,
  128, 128, 7, 7, 7, 8, 0, 0, 2, 4, 8, 16, 32, 64, 128, 5,
  7, 7, 6, 0, 0, 112, 136, 136, 136, 136, 136, 112, 5, 7, 7, 6,
  0, 0, 32, 96, 32, 32, 32, 32, 248, 5, 7, 7, 6, 0, 0, 112,
  136, 8, 16, 32, 64, 248, 5, 7, 7, 6, 0, 0, 240, 8, 8, 120,
  8, 8, 240, 5, 7, 7, 6, 0, 0, 16, 48, 80, 144, 248, 16, 16,
  5, 7, 7, 6, 0, 0, 248, 128, 112, 8, 8, 136, 112, 5, 7, 7,
  6, 0, 0, 112, 136, 128, 240, 136, 136, 112, 5, 7, 7, 6, 0, 0,
  248, 8, 16, 32, 32, 32, 32, 5, 7, 7, 6, 0, 0, 112, 136, 136,
  112, 136, 136, 112, 5, 7, 7, 6, 0, 0, 112, 136, 136, 120, 8, 136,
  112, 1, 4, 4, 2, 0, 1, 128, 0, 0, 128, 2, 6, 6, 3, 0,
  255, 64, 0, 0, 64, 64, 128, 4, 7, 7, 5, 0, 0, 16, 32, 64,
  128, 64, 32, 16, 5, 3, 3, 6, 0, 2, 248, 0, 248, 4, 7, 7,
  5, 0, 0, 128, 64, 32, 16, 32, 64, 128, 5, 7, 7, 6, 0, 0,
  112, 136, 8, 16, 32, 0, 32, 7, 7, 7, 8, 0, 0, 124, 130, 154,
  170, 190, 128, 124, 5, 7, 7, 6, 0, 0, 112, 136, 136, 248, 136, 136,
  136, 5, 7, 7, 6, 0, 0, 240, 136, 136, 240, 136, 136, 240, 5, 7,
  7, 6, 0, 0, 120, 128, 128, 128, 128, 128, 120, 5, 7, 7, 6, 0,
  0, 240, 136, 136, 136, 136, 136, 240, 5, 7, 7, 6, 0, 0, 248, 128,
  128, 240, 128, 128, 248, 5, 7, 7, 6, 0, 0, 248, 128, 128, 240, 128,
  128, 128, 5, 7, 7, 6, 0, 0, 112, 136, 128, 184, 136, 136, 112, 5,
  7, 7, 6, 0, 0, 136, 136, 136, 248, 136, 136, 136, 1, 7, 7, 2,
  0, 0, 128, 128, 128, 128, 128, 128, 128, 5, 7, 7, 6, 0, 0, 8,
  8, 8, 8, 8, 136, 112, 5, 7, 7, 6, 0, 0, 136, 144, 160, 192,
  160, 144, 136, 5, 7, 7, 6, 0, 0, 128, 128, 128, 128, 128, 128, 248,
  7, 7, 7, 8, 0, 0, 130, 198, 170, 146, 130, 130, 130, 6, 7, 7,
  7, 0, 0, 132, 196, 164, 148, 140, 132, 132, 5, 7, 7, 6, 0, 0,
  112, 136, 136, 136, 136, 136, 112, 5, 7, 7, 6, 0, 0, 240, 136, 136,
  240, 128, 128, 128, 5, 7, 7, 6, 0, 0, 112, 136, 136, 136, 168, 144,
  104, 5, 7, 7, 6, 0, 0, 240, 136, 136, 240, 160, 144, 136, 5, 7,
  7, 6, 0, 0, 112, 136, 128, 112, 8, 136, 112, 5, 7, 7, 6, 0,
  0, 248, 32, 32, 32, 32, 32, 32, 5, 7, 7, 6, 0, 0, 136, 136,
  136, 136, 136, 136, 112, 5, 7, 7, 6, 0, 0, 136, 136, 136, 136, 136,
  80, 32, 7, 7, 7, 8, 0, 0, 130, 130, 130, 146, 170, 198, 130, 5,
  7, 7, 6, 0, 0, 136, 136, 80, 32, 80, 136, 136, 5, 7, 7, 6,
  0, 0, 136, 136, 136, 80, 32, 32, 32, 5, 7, 7, 6, 0, 0, 248,
  8, 16, 32, 64, 128, 248, 3, 7, 7, 4, 0, 0, 224, 128, 128, 128,
  128, 128, 224, 7, 7, 7, 8, 0, 0, 128, 64, 32, 16, 8, 4, 2,
  3, 7, 7, 4, 0, 0, 224, 32, 32, 32, 32, 32, 224, 255, 7, 1,
  1, 8, 0, 0, 254, 255, 5, 5, 5, 6, 0, 0, 112, 8, 120, 136,
  120, 5, 6, 6, 6, 0, 0, 128, 128, 240, 136, 136, 240, 4, 5, 5,
  5, 0, 0, 112, 128, 128, 128, 112, 5, 6, 6, 6, 0, 0, 8, 8,
  120, 136, 136, 120, 5, 5, 5, 6, 0, 0, 112, 136, 240, 128, 120, 4,
  6, 6, 5, 0, 0, 48, 64, 240, 64, 64, 64, 5, 6, 6, 6, 0,
  255, 112, 136, 136, 120, 8, 112, 5, 6, 6, 6, 0, 0, 128, 128, 240,
  136, 136, 136, 1, 6, 6, 2, 0, 0, 128, 0, 128, 128, 128, 128, 3,
  7, 7, 4, 0, 255, 32, 0, 32, 32, 32, 32, 192, 4, 6, 6, 5,
  0, 0, 128, 128, 144, 224, 160, 144, 2, 6, 6, 3, 0, 0, 192, 64,
  64, 64, 64, 64, 7, 5, 5, 8, 0, 0, 252, 146, 146, 146, 146, 5,
  5, 5, 6, 0, 0, 240, 136, 136, 136, 136, 5, 5, 5, 6, 0, 0,
  112, 136, 136, 136, 112, 5, 6, 6, 6, 0, 255, 240, 136, 136, 240, 128,
  128, 5, 6, 6, 6, 0, 255, 120, 136, 136, 120, 8, 8, 5, 5, 5,
  6, 0, 0, 240, 136, 128, 128, 128, 5, 5, 5, 6, 0, 0, 120, 128,
  112, 8, 240, 5, 6, 6, 6, 0, 0, 32, 248, 32, 32, 32, 16, 5,
  5, 5, 6, 0, 0, 136, 136, 136, 136, 120, 5, 5, 5, 6, 0, 0,
  136, 136, 136, 80, 32, 7, 5, 5, 8, 0, 0, 146, 146, 146, 146, 126,
  5, 5, 5, 6, 0, 0, 136, 80, 32, 80, 136, 5, 6, 6, 6, 0,
  255, 136, 136, 136, 120, 8, 112, 5, 5, 5, 6, 0, 0, 248, 16, 32,
  64, 248, 4, 7, 7, 5, 0, 0, 48, 64, 64, 128, 64, 64, 48, 1,
  7, 7, 2, 0, 0, 128, 128, 128, 128, 128, 128, 128, 4, 7, 7, 5,
  0, 0, 192, 32, 32, 16, 32, 32, 192, 6, 2, 2, 7, 0, 3, 100,
  152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 1, 7, 7, 2, 0, 0, 128, 0, 0, 128, 128, 128, 128,
  5, 7, 7, 6, 0, 0, 32, 112, 168, 160, 168, 112, 32, 5, 7, 7,
  6, 0, 0, 56, 64, 64, 240, 64, 64, 248, 255, 5, 7, 7, 6, 0,
  0, 136, 136, 80, 32, 248, 32, 32, 1, 7, 7, 2, 0, 0, 128, 128,
  128, 0, 128, 128, 128, 255, 255, 8, 8, 8, 9, 0, 255, 60, 66, 153,
  161, 161, 153, 66, 60, 255, 6, 5, 5, 7, 0, 1, 36, 72, 144, 72,
  36, 5, 3, 3, 6, 0, 1, 248, 8, 8, 5, 1, 1, 6, 0, 3,
  248, 255, 255, 255, 5, 7, 7, 6, 0, 0, 32, 32, 248, 32, 32, 0,
  248, 255, 255, 255, 255, 6, 7, 7, 7, 0, 0, 124, 244, 244, 116, 20,
  20, 20, 1, 1, 1, 2, 0, 3, 128, 255, 255, 255, 6, 5, 5, 7,
  0, 1, 144, 72, 36, 72, 144, 255, 255, 255, 5, 7, 7, 6, 0, 0,
  32, 0, 32, 64, 128, 136, 112, 5, 10, 10, 6, 0, 0, 64, 32, 0,
  112, 136, 136, 248, 136, 136, 136, 5, 10, 10, 6, 0, 0, 16, 32, 0,
  112, 136, 136, 248, 136, 136, 136, 5, 10, 10, 6, 0, 0, 32, 80, 0,
  112, 136, 136, 248, 136, 136, 136, 5, 10, 10, 6, 0, 0, 104, 144, 0,
  112, 136, 136, 248, 136, 136, 136, 5, 9, 9, 6, 0, 0, 80, 0, 112,
  136, 136, 248, 136, 136, 136, 5, 10, 10, 6, 0, 0, 32, 80, 32, 112,
  136, 136, 248, 136, 136, 136, 9, 7, 14, 10, 0, 0, 119, 128, 136, 0,
  136, 0, 255, 0, 136, 0, 136, 0, 143, 128, 255, 5, 10, 10, 6, 0,
  0, 64, 32, 0, 248, 128, 128, 240, 128, 128, 248, 5, 10, 10, 6, 0,
  0, 16, 32, 0, 248, 128, 128, 240, 128, 128, 248, 5, 10, 10, 6, 0,
  0, 32, 80, 0, 248, 128, 128, 240, 128, 128, 248, 5, 9, 9, 6, 0,
  0, 80, 0, 248, 128, 128, 240, 128, 128, 248, 2, 10, 10, 3, 0, 0,
  128, 64, 0, 64, 64, 64, 64, 64, 64, 64, 2, 10, 10, 4, 1, 0,
  64, 128, 0, 128, 128, 128, 128, 128, 128, 128, 3, 10, 10, 4, 0, 0,
  64, 160, 0, 64, 64, 64, 64, 64, 64, 64, 3, 9, 9, 4, 0, 0,
  160, 0, 64, 64, 64, 64, 64, 64, 64, 6, 7, 7, 7, 0, 0, 120,
  68, 68, 244, 68, 68, 120, 6, 10, 10, 7, 0, 0, 100, 152, 0, 132,
  196, 164, 148, 140, 132, 132, 5, 10, 10, 6, 0, 0, 64, 32, 0, 112,
  136, 136, 136, 136, 136, 112, 5, 10, 10, 6, 0, 0, 16, 32, 0, 112,
  136, 136, 136, 136, 136, 112, 5, 10, 10, 6, 0, 0, 32, 80, 0, 112,
  136, 136, 136, 136, 136, 112, 5, 10, 10, 6, 0, 0, 104, 144, 0, 112,
  136, 136, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 136, 112, 136, 136,
  136, 136, 136, 112, 5, 5, 5, 6, 0, 1, 136, 80, 32, 80, 136, 255,
  5, 10, 10, 6, 0, 0, 64, 32, 0, 136, 136, 136, 136, 136, 136, 112,
  5, 10, 10, 6, 0, 0, 16, 32, 0, 136, 136, 136, 136, 136, 136, 112,
  5, 10, 10, 6, 0, 0, 32, 80, 0, 136, 136, 136, 136, 136, 136, 112,
  5, 8, 8, 6, 0, 0, 136, 0, 136, 136, 136, 136, 136, 112, 5, 10,
  10, 6, 0, 0, 16, 32, 0, 136, 136, 136, 80, 32, 32, 32, 255, 4,
  8, 8, 5, 0, 255, 96, 144, 144, 160, 144, 144, 160, 128, 5, 8, 8,
  6, 0, 0, 64, 32, 0, 112, 8, 120, 136, 120, 5, 8, 8, 6, 0,
  0, 16, 32, 0, 112, 8, 120, 136, 120, 5, 8, 8, 6, 0, 0, 32,
  80, 0, 112, 8, 120, 136, 120, 5, 8, 8, 6, 0, 0, 104, 144, 0,
  112, 8, 120, 136, 120, 5, 7, 7, 6, 0, 0, 80, 0, 112, 8, 120,
  136, 120, 5, 9, 9, 6, 0, 0, 32, 80, 32, 0, 112, 8, 120, 136,
  120, 9, 5, 10, 10, 0, 0, 119, 0, 8, 128, 127, 0, 136, 0, 119,
  128, 255, 5, 8, 8, 6, 0, 0, 64, 32, 0, 112, 136, 240, 128, 120,
  5, 8, 8, 6, 0, 0, 16, 32, 0, 112, 136, 240, 128, 120, 5, 8,
  8, 6, 0, 0, 32, 80, 0, 112, 136, 240, 128, 120, 5, 7, 7, 6,
  0, 0, 80, 0, 112, 136, 240, 128, 120, 2, 7, 7, 3, 0, 0, 128,
  64, 0, 64, 64, 64, 64, 2, 7, 7, 3, 0, 0, 64, 128, 0, 128,
  128, 128, 128, 3, 7, 7, 4, 0, 0, 64, 160, 0, 64, 64, 64, 64,
  3, 6, 6, 4, 0, 0, 160, 0, 64, 64, 64, 64, 255, 5, 8, 8,
  6, 0, 0, 104, 144, 0, 240, 136, 136, 136, 136, 5, 8, 8, 6, 0,
  0, 64, 32, 0, 112, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 16,
  32, 0, 112, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 32, 80, 0,
  112, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 104, 144, 0, 112, 136,
  136, 136, 112, 5, 7, 7, 6, 0, 0, 80, 0, 112, 136, 136, 136, 112,
  5, 5, 5, 6, 0, 1, 32, 0, 248, 0, 32, 255, 5, 8, 8, 6,
  0, 0, 64, 32, 0, 136, 136, 136, 136, 120, 5, 8, 8, 6, 0, 0,
  16, 32, 0, 136, 136, 136, 136, 120, 5, 8, 8, 6, 0, 0, 32, 80,
  0, 136, 136, 136, 136, 120, 5, 7, 7, 6, 0, 0, 80, 0, 136, 136,
  136, 136, 120, 5, 9, 9, 6, 0, 255, 16, 32, 0, 136, 136, 136, 120,
  8, 112, 255, 5, 8, 8, 6, 0, 255, 80, 0, 136, 136, 136, 120, 8,
  112
};

/*
  Fontname: -FreeType-Lucasfont Alternate-Medium-R-Normal--8-80-72-72-P-50-ISO10646-1
  Copyright: Copyright Patrick Lauke 2012  "Lucasfont Alternate" is based on "Lucasfont" by "Patrick Lauke" (http://fontstruct.com/fontstructors/redux)
  Capital A Height: 0, '1' Height: 7
  Calculated Max Values w= 7 h= 7 x= 0 y= 3 dx= 8 dy= 0 ascent= 7 len= 7
  Font Bounding box     w= 9 h=11 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 7 descent= 0
  X Font      ascent = 7 descent= 0
  Max Font    ascent = 7 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_lucasfont_alternaten[216] U8G_FONT_SECTION("u8g_font_lucasfont_alternaten") = {
  0, 9, 11, 0, 255, 7, 0, 0, 0, 0, 42, 58, 0, 7, 255, 7,
  0, 7, 5, 5, 8, 0, 1, 68, 40, 254, 40, 68, 5, 5, 5, 6,
  0, 1, 32, 32, 248, 32, 32, 2, 3, 3, 3, 0, 255, 64, 64, 128,
  6, 1, 1, 7, 0, 3, 252, 1, 2, 2, 2, 0, 0, 128, 128, 7,
  7, 7, 8, 0, 0, 2, 4, 8, 16, 32, 64, 128, 5, 7, 7, 6,
  0, 0, 112, 136, 136, 136, 136, 136, 112, 5, 7, 7, 6, 0, 0, 32,
  96, 32, 32, 32, 32, 248, 5, 7, 7, 6, 0, 0, 112, 136, 8, 16,
  32, 64, 248, 5, 7, 7, 6, 0, 0, 240, 8, 8, 120, 8, 8, 240,
  5, 7, 7, 6, 0, 0, 16, 48, 80, 144, 248, 16, 16, 5, 7, 7,
  6, 0, 0, 248, 128, 112, 8, 8, 136, 112, 5, 7, 7, 6, 0, 0,
  112, 136, 128, 240, 136, 136, 112, 5, 7, 7, 6, 0, 0, 248, 8, 16,
  32, 32, 32, 32, 5, 7, 7, 6, 0, 0, 112, 136, 136, 112, 136, 136,
  112, 5, 7, 7, 6, 0, 0, 112, 136, 136, 120, 8, 136, 112, 1, 4,
  4, 2, 0, 1, 128, 0, 0, 128
};

/*
  Fontname: -FreeType-Lucasfont Alternate-Medium-R-Normal--8-80-72-72-P-50-ISO10646-1
  Copyright: Copyright Patrick Lauke 2012  "Lucasfont Alternate" is based on "Lucasfont" by "Patrick Lauke" (http://fontstruct.com/fontstructors/redux)
  Capital A Height: 7, '1' Height: 7
  Calculated Max Values w= 7 h= 7 x= 0 y= 4 dx= 8 dy= 0 ascent= 7 len= 7
  Font Bounding box     w= 9 h=11 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 7 descent=-1
  X Font      ascent = 7 descent=-1
  Max Font    ascent = 7 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_lucasfont_alternater[1138] U8G_FONT_SECTION("u8g_font_lucasfont_alternater") = {
  0, 9, 11, 0, 255, 7, 1, 148, 3, 22, 32, 127, 255, 7, 255, 7,
  255, 0, 0, 0, 4, 0, 0, 1, 7, 7, 2, 0, 0, 128, 128, 128,
  128, 0, 0, 128, 3, 3, 3, 4, 0, 4, 160, 160, 160, 5, 7, 7,
  6, 0, 0, 80, 80, 248, 80, 248, 80, 80, 5, 7, 7, 6, 0, 0,
  32, 120, 128, 248, 8, 240, 32, 7, 7, 7, 8, 0, 0, 2, 68, 8,
  16, 32, 68, 128, 6, 7, 7, 7, 0, 0, 96, 144, 144, 96, 148, 136,
  116, 1, 3, 3, 2, 0, 4, 128, 128, 128, 3, 7, 7, 4, 0, 0,
  32, 64, 128, 128, 128, 64, 32, 3, 7, 7, 4, 0, 0, 128, 64, 32,
  32, 32, 64, 128, 7, 5, 5, 8, 0, 1, 68, 40, 254, 40, 68, 5,
  5, 5, 6, 0, 1, 32, 32, 248, 32, 32, 2, 3, 3, 3, 0, 255,
  64, 64, 128, 6, 1, 1, 7, 0, 3, 252, 1, 2, 2, 2, 0, 0,
  128, 128, 7, 7, 7, 8, 0, 0, 2, 4, 8, 16, 32, 64, 128, 5,
  7, 7, 6, 0, 0, 112, 136, 136, 136, 136, 136, 112, 5, 7, 7, 6,
  0, 0, 32, 96, 32, 32, 32, 32, 248, 5, 7, 7, 6, 0, 0, 112,
  136, 8, 16, 32, 64, 248, 5, 7, 7, 6, 0, 0, 240, 8, 8, 120,
  8, 8, 240, 5, 7, 7, 6, 0, 0, 16, 48, 80, 144, 248, 16, 16,
  5, 7, 7, 6, 0, 0, 248, 128, 112, 8, 8, 136, 112, 5, 7, 7,
  6, 0, 0, 112, 136, 128, 240, 136, 136, 112, 5, 7, 7, 6, 0, 0,
  248, 8, 16, 32, 32, 32, 32, 5, 7, 7, 6, 0, 0, 112, 136, 136,
  112, 136, 136, 112, 5, 7, 7, 6, 0, 0, 112, 136, 136, 120, 8, 136,
  112, 1, 4, 4, 2, 0, 1, 128, 0, 0, 128, 2, 6, 6, 3, 0,
  255, 64, 0, 0, 64, 64, 128, 4, 7, 7, 5, 0, 0, 16, 32, 64,
  128, 64, 32, 16, 5, 3, 3, 6, 0, 2, 248, 0, 248, 4, 7, 7,
  5, 0, 0, 128, 64, 32, 16, 32, 64, 128, 5, 7, 7, 6, 0, 0,
  112, 136, 8, 16, 32, 0, 32, 7, 7, 7, 8, 0, 0, 124, 130, 154,
  170, 190, 128, 124, 5, 7, 7, 6, 0, 0, 112, 136, 136, 248, 136, 136,
  136, 5, 7, 7, 6, 0, 0, 240, 136, 136, 240, 136, 136, 240, 5, 7,
  7, 6, 0, 0, 120, 128, 128, 128, 128, 128, 120, 5, 7, 7, 6, 0,
  0, 240, 136, 136, 136, 136, 136, 240, 5, 7, 7, 6, 0, 0, 248, 128,
  128, 240, 128, 128, 248, 5, 7, 7, 6, 0, 0, 248, 128, 128, 240, 128,
  128, 128, 5, 7, 7, 6, 0, 0, 112, 136, 128, 184, 136, 136, 112, 5,
  7, 7, 6, 0, 0, 136, 136, 136, 248, 136, 136, 136, 1, 7, 7, 2,
  0, 0, 128, 128, 128, 128, 128, 128, 128, 5, 7, 7, 6, 0, 0, 8,
  8, 8, 8, 8, 136, 112, 5, 7, 7, 6, 0, 0, 136, 144, 160, 192,
  160, 144, 136, 5, 7, 7, 6, 0, 0, 128, 128, 128, 128, 128, 128, 248,
  7, 7, 7, 8, 0, 0, 130, 198, 170, 146, 130, 130, 130, 6, 7, 7,
  7, 0, 0, 132, 196, 164, 148, 140, 132, 132, 5, 7, 7, 6, 0, 0,
  112, 136, 136, 136, 136, 136, 112, 5, 7, 7, 6, 0, 0, 240, 136, 136,
  240, 128, 128, 128, 5, 7, 7, 6, 0, 0, 112, 136, 136, 136, 168, 144,
  104, 5, 7, 7, 6, 0, 0, 240, 136, 136, 240, 160, 144, 136, 5, 7,
  7, 6, 0, 0, 112, 136, 128, 112, 8, 136, 112, 5, 7, 7, 6, 0,
  0, 248, 32, 32, 32, 32, 32, 32, 5, 7, 7, 6, 0, 0, 136, 136,
  136, 136, 136, 136, 112, 5, 7, 7, 6, 0, 0, 136, 136, 136, 136, 136,
  80, 32, 7, 7, 7, 8, 0, 0, 130, 130, 130, 146, 170, 198, 130, 5,
  7, 7, 6, 0, 0, 136, 136, 80, 32, 80, 136, 136, 5, 7, 7, 6,
  0, 0, 136, 136, 136, 80, 32, 32, 32, 5, 7, 7, 6, 0, 0, 248,
  8, 16, 32, 64, 128, 248, 3, 7, 7, 4, 0, 0, 224, 128, 128, 128,
  128, 128, 224, 7, 7, 7, 8, 0, 0, 128, 64, 32, 16, 8, 4, 2,
  3, 7, 7, 4, 0, 0, 224, 32, 32, 32, 32, 32, 224, 255, 7, 1,
  1, 8, 0, 0, 254, 255, 5, 5, 5, 6, 0, 0, 112, 8, 120, 136,
  120, 5, 6, 6, 6, 0, 0, 128, 128, 240, 136, 136, 240, 4, 5, 5,
  5, 0, 0, 112, 128, 128, 128, 112, 5, 6, 6, 6, 0, 0, 8, 8,
  120, 136, 136, 120, 5, 5, 5, 6, 0, 0, 112, 136, 240, 128, 120, 4,
  6, 6, 5, 0, 0, 48, 64, 240, 64, 64, 64, 5, 6, 6, 6, 0,
  255, 112, 136, 136, 120, 8, 112, 5, 6, 6, 6, 0, 0, 128, 128, 240,
  136, 136, 136, 1, 6, 6, 2, 0, 0, 128, 0, 128, 128, 128, 128, 3,
  7, 7, 4, 0, 255, 32, 0, 32, 32, 32, 32, 192, 4, 6, 6, 5,
  0, 0, 128, 128, 144, 224, 160, 144, 2, 6, 6, 3, 0, 0, 192, 64,
  64, 64, 64, 64, 7, 5, 5, 8, 0, 0, 252, 146, 146, 146, 146, 5,
  5, 5, 6, 0, 0, 240, 136, 136, 136, 136, 5, 5, 5, 6, 0, 0,
  112, 136, 136, 136, 112, 5, 6, 6, 6, 0, 255, 240, 136, 136, 240, 128,
  128, 5, 6, 6, 6, 0, 255, 120, 136, 136, 120, 8, 8, 5, 5, 5,
  6, 0, 0, 240, 136, 128, 128, 128, 5, 5, 5, 6, 0, 0, 120, 128,
  112, 8, 240, 5, 6, 6, 6, 0, 0, 32, 248, 32, 32, 32, 16, 5,
  5, 5, 6, 0, 0, 136, 136, 136, 136, 120, 5, 5, 5, 6, 0, 0,
  136, 136, 136, 80, 32, 7, 5, 5, 8, 0, 0, 146, 146, 146, 146, 126,
  5, 5, 5, 6, 0, 0, 136, 80, 32, 80, 136, 5, 6, 6, 6, 0,
  255, 136, 136, 136, 120, 8, 112, 5, 5, 5, 6, 0, 0, 248, 16, 32,
  64, 248, 4, 7, 7, 5, 0, 0, 48, 64, 64, 128, 64, 64, 48, 1,
  7, 7, 2, 0, 0, 128, 128, 128, 128, 128, 128, 128, 4, 7, 7, 5,
  0, 0, 192, 32, 32, 16, 32, 32, 192, 6, 2, 2, 7, 0, 3, 100,
  152, 255
};

/*
  Fontname: m2icon5
  Copyright: public domain
  Capital A Height: 5, '1' Height: 0
  Calculated Max Values w= 9 h= 6 x= 0 y= 0 dx=10 dy= 0 ascent= 5 len=10
  Font Bounding box     w= 9 h= 6 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-1
  X Font      ascent = 5 descent=-1
  Max Font    ascent = 5 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_m2icon_5[221] U8G_FONT_SECTION("u8g_font_m2icon_5") = {
  1, 9, 6, 0, 255, 5, 0, 17, 0, 172, 65, 104, 255, 5, 255, 5,
  255, 2, 117, 149, 28, 254, 130, 130, 254, 2, 69, 133, 112, 208, 144, 144,
  240, 2, 84, 100, 216, 112, 112, 216, 2, 117, 133, 6, 12, 216, 112, 32,
  2, 68, 84, 240, 144, 144, 240, 2, 68, 84, 240, 144, 208, 240, 2, 68,
  84, 240, 240, 240, 240, 2, 85, 101, 248, 136, 136, 136, 248, 2, 85, 101,
  248, 136, 168, 136, 248, 2, 85, 101, 248, 248, 248, 248, 248, 2, 68, 84,
  224, 176, 240, 112, 2, 68, 84, 224, 176, 240, 112, 2, 68, 84, 224, 240,
  240, 112, 2, 85, 101, 240, 152, 152, 248, 120, 2, 85, 101, 240, 152, 216,
  248, 120, 2, 85, 101, 240, 248, 248, 248, 120, 2, 68, 84, 96, 144, 144,
  96, 2, 68, 84, 96, 144, 208, 96, 2, 68, 84, 96, 240, 240, 96, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 2, 117, 133, 32,
  64, 254, 64, 32, 2, 85, 101, 32, 112, 168, 32, 32, 255, 255, 255, 2,
  149, 170, 28, 0, 254, 0, 130, 0, 191, 128, 255, 0, 1, 22, 38, 128,
  128, 128, 128, 128, 128, 2, 85, 101, 32, 32, 248, 32, 32
};

/*
  Fontname: m2icon_7
  Copyright: public domain
  Capital A Height: 7, '1' Height: 0
  Calculated Max Values w=12 h= 8 x= 0 y= 1 dx=13 dy= 0 ascent= 7 len=14
  Font Bounding box     w=12 h= 8 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 7 descent=-1
  X Font      ascent = 7 descent=-1
  Max Font    ascent = 7 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_m2icon_7[275] U8G_FONT_SECTION("u8g_font_m2icon_7") = {
  1, 12, 8, 0, 255, 7, 0, 17, 0, 214, 65, 104, 255, 7, 255, 7,
  255, 2, 151, 174, 15, 0, 255, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  255, 128, 2, 87, 103, 56, 104, 232, 136, 136, 136, 248, 3, 84, 100, 216,
  112, 112, 216, 2, 134, 150, 3, 6, 12, 216, 112, 32, 2, 102, 118, 252,
  132, 132, 132, 132, 252, 2, 102, 118, 252, 132, 180, 180, 132, 252, 2, 102,
  118, 252, 252, 252, 252, 252, 252, 2, 119, 151, 254, 130, 130, 130, 130, 130,
  254, 2, 119, 151, 254, 130, 186, 186, 186, 130, 254, 2, 119, 151, 254, 254,
  254, 254, 254, 254, 254, 2, 102, 118, 248, 140, 140, 140, 252, 124, 2, 102,
  118, 248, 140, 172, 140, 252, 124, 2, 102, 134, 248, 252, 252, 252, 252, 124,
  2, 119, 151, 252, 134, 134, 134, 134, 254, 126, 2, 119, 151, 252, 134, 182,
  182, 134, 254, 126, 2, 119, 151, 252, 254, 254, 254, 254, 254, 126, 2, 102,
  118, 120, 204, 132, 132, 204, 120, 2, 102, 118, 120, 204, 180, 180, 204, 120,
  2, 102, 118, 120, 252, 252, 252, 252, 120, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 2, 135, 151, 16, 48, 95, 129, 95, 48, 16,
  2, 119, 135, 16, 40, 68, 238, 40, 40, 56, 255, 255, 255, 2, 199, 222,
  15, 0, 255, 128, 128, 128, 159, 240, 160, 32, 192, 64, 255, 128, 1, 24,
  40, 128, 128, 128, 128, 128, 128, 128, 128, 2, 119, 199, 16, 0, 16, 186,
  16, 0, 16
};

/*
  Fontname: m2icon_9
  Copyright: public domain
  Capital A Height: 8, '1' Height: 0
  Calculated Max Values w=13 h=11 x= 0 y= 1 dx=12 dy= 0 ascent= 9 len=18
  Font Bounding box     w=13 h=11 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 8 descent=-2
  X Font      ascent = 8 descent=-2
  Max Font    ascent = 9 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_m2icon_9[471] U8G_FONT_SECTION("u8g_font_m2icon_9") = {
  0, 13, 11, 0, 254, 8, 0, 17, 1, 111, 65, 105, 254, 9, 254, 8,
  254, 10, 8, 16, 11, 0, 0, 15, 128, 255, 192, 128, 64, 128, 64, 128,
  64, 128, 64, 128, 64, 255, 192, 6, 8, 8, 7, 0, 0, 60, 84, 148,
  244, 132, 132, 132, 252, 6, 5, 5, 7, 0, 1, 204, 120, 48, 120, 204,
  10, 7, 14, 12, 0, 0, 0, 192, 1, 128, 3, 0, 198, 0, 108, 0,
  56, 0, 16, 0, 8, 8, 8, 9, 0, 0, 255, 129, 129, 129, 129, 129,
  129, 255, 8, 8, 8, 9, 0, 0, 255, 129, 189, 189, 189, 189, 129, 255,
  8, 8, 8, 9, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 9, 9,
  18, 10, 0, 0, 255, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 255, 128, 9, 9, 18, 10, 0, 0, 255, 128, 128, 128,
  190, 128, 190, 128, 190, 128, 190, 128, 190, 128, 128, 128, 255, 128, 9, 9,
  18, 11, 0, 0, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 8, 8, 8, 8, 0, 0, 254, 131, 131, 131,
  131, 131, 255, 127, 8, 8, 8, 9, 0, 0, 254, 131, 187, 187, 187, 131,
  255, 127, 8, 8, 8, 9, 0, 0, 254, 255, 255, 255, 255, 255, 255, 127,
  9, 9, 18, 10, 0, 0, 255, 0, 129, 128, 129, 128, 129, 128, 129, 128,
  129, 128, 129, 128, 255, 128, 127, 128, 9, 9, 18, 10, 0, 0, 255, 0,
  129, 128, 189, 128, 189, 128, 189, 128, 189, 128, 129, 128, 255, 128, 127, 128,
  9, 9, 18, 10, 0, 0, 255, 0, 255, 128, 255, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 255, 128, 127, 128, 8, 8, 8, 9, 0, 0, 60, 66,
  129, 129, 129, 129, 66, 60, 8, 8, 8, 9, 0, 0, 60, 66, 153, 189,
  189, 153, 66, 60, 8, 8, 8, 9, 0, 0, 60, 126, 255, 255, 255, 255,
  126, 60, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 10,
  8, 16, 11, 0, 0, 24, 0, 40, 0, 79, 192, 128, 64, 128, 64, 79,
  192, 40, 0, 24, 0, 8, 9, 9, 9, 0, 0, 24, 36, 66, 129, 231,
  36, 36, 36, 60, 255, 255, 255, 13, 8, 16, 11, 0, 0, 15, 128, 255,
  192, 128, 64, 128, 64, 159, 248, 160, 16, 192, 32, 255, 192, 1, 11, 11,
  2, 0, 254, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 9, 9,
  18, 10, 0, 0, 8, 0, 0, 0, 8, 0, 8, 0, 190, 128, 8, 0,
  8, 0, 0, 0, 8, 0, 255
};

/*
  Fontname: micro
  Copyright: Public domain font.  Share and enjoy.
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 3 h= 5 x= 1 y= 5 dx= 4 dy= 0 ascent= 5 len= 5
  Font Bounding box     w= 4 h= 5 x= 0 y= 0
  Calculated Min Values           x= 0 y= 0 dx= 0 dy= 0
  Pure Font   ascent = 5 descent= 0
  X Font      ascent = 5 descent= 0
  Max Font    ascent = 5 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_micro[855] U8G_FONT_SECTION("u8g_font_micro") = {
  1, 4, 5, 0, 0, 5, 0, 255, 1, 245, 32, 255, 0, 5, 0, 5,
  0, 7, 0, 64, 2, 37, 69, 192, 192, 192, 0, 192, 5, 50, 66, 160,
  160, 2, 53, 69, 160, 224, 160, 224, 160, 2, 53, 69, 64, 224, 192, 96,
  224, 3, 52, 68, 160, 96, 192, 160, 2, 53, 69, 64, 64, 224, 192, 64,
  21, 34, 66, 64, 192, 18, 37, 69, 64, 128, 128, 128, 64, 2, 37, 69,
  128, 64, 64, 64, 128, 2, 53, 69, 160, 64, 224, 64, 160, 3, 51, 67,
  64, 224, 64, 2, 34, 66, 64, 192, 4, 49, 65, 224, 2, 34, 66, 192,
  192, 2, 53, 69, 32, 32, 64, 64, 128, 2, 53, 69, 64, 160, 160, 160,
  64, 2, 37, 69, 64, 192, 64, 64, 64, 2, 53, 69, 192, 32, 64, 128,
  224, 2, 53, 69, 192, 32, 96, 32, 224, 2, 53, 69, 160, 160, 160, 224,
  32, 2, 53, 69, 224, 128, 192, 32, 192, 2, 53, 69, 96, 128, 224, 160,
  224, 2, 53, 69, 224, 32, 32, 64, 64, 2, 53, 69, 224, 160, 224, 160,
  224, 2, 53, 69, 224, 160, 224, 32, 192, 2, 37, 69, 192, 192, 0, 192,
  192, 2, 37, 69, 192, 192, 0, 64, 192, 2, 53, 69, 32, 64, 128, 64,
  32, 3, 51, 67, 224, 0, 224, 2, 53, 69, 128, 64, 32, 64, 128, 2,
  53, 69, 224, 32, 96, 0, 64, 2, 53, 69, 96, 160, 192, 128, 96, 2,
  53, 69, 224, 160, 224, 160, 160, 2, 53, 69, 224, 160, 192, 160, 224, 2,
  53, 69, 224, 128, 128, 128, 224, 2, 53, 69, 192, 160, 160, 160, 192, 2,
  53, 69, 224, 128, 224, 128, 224, 2, 53, 69, 224, 128, 224, 128, 128, 2,
  53, 69, 224, 128, 160, 160, 224, 2, 53, 69, 160, 160, 224, 160, 160, 2,
  53, 69, 224, 64, 64, 64, 224, 2, 53, 69, 32, 32, 32, 160, 224, 2,
  53, 69, 160, 160, 192, 160, 160, 2, 53, 69, 128, 128, 128, 128, 224, 2,
  53, 69, 160, 224, 160, 160, 160, 2, 53, 69, 224, 160, 160, 160, 160, 2,
  53, 69, 224, 160, 160, 160, 224, 2, 53, 69, 224, 160, 224, 128, 128, 2,
  53, 69, 224, 160, 160, 192, 96, 2, 53, 69, 224, 160, 192, 160, 160, 2,
  53, 69, 224, 128, 224, 32, 224, 2, 53, 69, 224, 64, 64, 64, 64, 2,
  53, 69, 160, 160, 160, 160, 224, 2, 53, 69, 160, 160, 160, 160, 64, 2,
  53, 69, 160, 160, 160, 224, 160, 2, 53, 69, 160, 224, 64, 224, 160, 2,
  53, 69, 160, 160, 224, 64, 64, 2, 53, 69, 224, 32, 64, 128, 224, 18,
  37, 69, 192, 128, 128, 128, 192, 2, 53, 69, 128, 128, 64, 64, 32, 2,
  37, 69, 192, 64, 64, 64, 192, 5, 50, 66, 64, 160, 2, 49, 65, 224,
  21, 34, 66, 128, 192, 2, 52, 68, 224, 96, 160, 224, 2, 53, 69, 128,
  224, 160, 160, 224, 2, 52, 68, 224, 128, 128, 224, 2, 53, 69, 32, 224,
  160, 160, 224, 2, 52, 68, 224, 160, 192, 224, 2, 53, 69, 96, 128, 192,
  128, 128, 2, 52, 68, 224, 160, 96, 224, 2, 53, 69, 128, 224, 160, 160,
  160, 18, 20, 68, 128, 128, 128, 128, 2, 52, 68, 32, 32, 160, 224, 2,
  53, 69, 128, 160, 192, 192, 160, 2, 37, 69, 192, 64, 64, 64, 64, 2,
  52, 68, 160, 224, 160, 160, 2, 52, 68, 224, 160, 160, 160, 2, 52, 68,
  224, 160, 160, 224, 2, 52, 68, 224, 160, 224, 128, 2, 52, 68, 224, 160,
  224, 32, 2, 52, 68, 224, 160, 128, 128, 2, 52, 68, 224, 192, 96, 224,
  2, 53, 69, 64, 224, 64, 64, 96, 2, 52, 68, 160, 160, 160, 224, 2,
  52, 68, 160, 160, 160, 64, 2, 52, 68, 160, 160, 224, 160, 2, 52, 68,
  160, 64, 64, 160, 2, 52, 68, 160, 160, 96, 192, 2, 52, 68, 224, 96,
  192, 224, 2, 53, 69, 96, 64, 192, 64, 96, 18, 21, 69, 128, 128, 128,
  128, 128, 2, 53, 69, 192, 64, 96, 64, 192, 4, 50, 66, 192, 96, 2,
  53, 69, 96, 64, 64, 64, 192, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255
};

/*
  Fontname: -FreeType-Org_v01-Medium-R-Normal--8-80-72-72-P-43-ISO10646-1
  Copyright:  www.orgdot.com
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w=11 h= 9 x= 1 y= 4 dx=12 dy= 0 ascent= 9 len=10
  Font Bounding box     w=11 h=11 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-1
  X Font      ascent = 5 descent=-1
  Max Font    ascent = 9 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_orgv01[1535] U8G_FONT_SECTION("u8g_font_orgv01") = {
  1, 11, 11, 0, 254, 5, 0, 249, 1, 238, 32, 255, 255, 9, 254, 5,
  255, 2, 0, 64, 2, 21, 37, 128, 128, 128, 0, 128, 6, 49, 65, 160,
  2, 85, 101, 80, 248, 80, 248, 80, 2, 85, 101, 248, 160, 248, 40, 248,
  2, 85, 101, 136, 16, 32, 64, 136, 2, 85, 101, 240, 144, 248, 144, 232,
  6, 17, 33, 128, 2, 37, 53, 64, 128, 128, 128, 64, 2, 37, 53, 128,
  64, 64, 64, 128, 3, 51, 67, 160, 64, 160, 3, 51, 67, 64, 224, 64,
  1, 18, 34, 128, 128, 4, 65, 81, 240, 2, 17, 33, 128, 2, 85, 101,
  8, 16, 32, 64, 128, 2, 85, 101, 248, 136, 136, 136, 248, 2, 21, 37,
  128, 128, 128, 128, 128, 2, 85, 101, 248, 8, 248, 128, 248, 2, 85, 101,
  248, 8, 248, 8, 248, 2, 85, 101, 136, 136, 248, 8, 8, 2, 85, 101,
  248, 128, 248, 8, 248, 2, 85, 101, 248, 128, 248, 136, 248, 2, 85, 101,
  248, 8, 8, 8, 8, 2, 85, 101, 248, 136, 248, 136, 248, 2, 85, 101,
  248, 136, 248, 8, 248, 2, 20, 36, 128, 0, 0, 128, 2, 20, 36, 128,
  0, 128, 128, 2, 53, 69, 32, 64, 128, 64, 32, 3, 67, 83, 240, 0,
  240, 2, 53, 69, 128, 64, 32, 64, 128, 2, 85, 101, 248, 8, 56, 0,
  32, 2, 85, 101, 248, 168, 184, 128, 248, 2, 85, 101, 248, 136, 248, 136,
  136, 2, 85, 101, 240, 136, 240, 136, 240, 2, 85, 101, 248, 128, 128, 128,
  248, 2, 85, 101, 240, 136, 136, 136, 240, 2, 85, 101, 248, 128, 248, 128,
  248, 2, 85, 101, 248, 128, 248, 128, 128, 2, 85, 101, 248, 128, 184, 136,
  248, 2, 85, 101, 136, 136, 248, 136, 136, 2, 85, 101, 248, 32, 32, 32,
  248, 2, 85, 101, 120, 16, 16, 144, 248, 2, 85, 101, 136, 176, 192, 176,
  136, 2, 85, 101, 128, 128, 128, 128, 248, 2, 85, 101, 248, 168, 168, 168,
  168, 2, 85, 101, 248, 136, 136, 136, 136, 2, 85, 101, 248, 136, 136, 136,
  248, 2, 85, 101, 248, 136, 248, 128, 128, 2, 85, 101, 248, 136, 136, 152,
  248, 2, 85, 101, 248, 136, 248, 144, 144, 2, 85, 101, 248, 128, 248, 8,
  248, 2, 85, 101, 248, 32, 32, 32, 32, 2, 85, 101, 136, 136, 136, 136,
  248, 2, 85, 101, 136, 136, 136, 80, 32, 2, 85, 101, 168, 168, 168, 168,
  248, 2, 85, 101, 136, 80, 32, 80, 136, 2, 85, 101, 136, 136, 80, 32,
  32, 2, 85, 101, 248, 8, 248, 128, 248, 2, 37, 53, 192, 128, 128, 128,
  192, 2, 85, 101, 128, 64, 32, 16, 8, 2, 37, 53, 192, 64, 64, 64,
  192, 5, 50, 66, 64, 160, 1, 81, 97, 248, 6, 17, 33, 128, 2, 68,
  84, 240, 16, 240, 240, 2, 69, 85, 128, 240, 144, 144, 240, 2, 68, 84,
  240, 128, 128, 240, 2, 69, 85, 16, 240, 144, 144, 240, 2, 68, 84, 240,
  240, 128, 240, 2, 53, 69, 96, 64, 224, 64, 64, 1, 69, 85, 240, 144,
  144, 240, 16, 2, 69, 85, 128, 240, 144, 144, 144, 2, 20, 36, 128, 128,
  128, 128, 1, 37, 53, 64, 64, 64, 64, 192, 2, 69, 85, 128, 160, 240,
  144, 144, 2, 21, 37, 128, 128, 128, 128, 128, 2, 84, 100, 248, 168, 136,
  136, 2, 68, 84, 240, 144, 144, 144, 2, 68, 84, 240, 144, 144, 240, 1,
  69, 85, 240, 144, 144, 240, 128, 1, 69, 85, 240, 144, 144, 240, 32, 2,
  68, 84, 240, 128, 128, 128, 2, 68, 84, 64, 112, 16, 240, 2, 85, 101,
  32, 248, 32, 32, 32, 2, 68, 84, 144, 144, 144, 240, 2, 68, 84, 144,
  144, 144, 112, 2, 84, 100, 136, 136, 168, 248, 2, 68, 84, 144, 96, 96,
  144, 1, 69, 85, 144, 144, 144, 240, 16, 2, 68, 84, 32, 224, 128, 240,
  2, 53, 69, 32, 64, 192, 64, 32, 2, 21, 37, 128, 128, 128, 128, 128,
  2, 53, 69, 128, 64, 96, 64, 128, 3, 83, 99, 8, 248, 128, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  2, 20, 36, 128, 0, 128, 128, 2, 85, 101, 32, 248, 160, 248, 32, 2,
  85, 101, 64, 224, 64, 72, 120, 2, 85, 101, 136, 112, 80, 112, 136, 2,
  85, 101, 136, 248, 32, 112, 32, 2, 21, 37, 128, 128, 0, 128, 128, 2,
  86, 102, 248, 128, 248, 248, 8, 248, 4, 81, 97, 248, 18, 85, 117, 248,
  168, 200, 168, 248, 2, 181, 202, 251, 224, 138, 0, 251, 224, 136, 32, 139,
  224, 19, 83, 115, 72, 144, 72, 3, 66, 82, 240, 16, 255, 2, 85, 101,
  248, 248, 200, 200, 248, 6, 81, 97, 248, 2, 0, 112, 2, 0, 112, 2,
  0, 112, 2, 0, 112, 2, 0, 112, 2, 0, 112, 2, 0, 112, 2, 0,
  112, 2, 0, 112, 2, 0, 112, 2, 0, 112, 4, 83, 99, 144, 72, 144,
  2, 0, 112, 2, 0, 112, 2, 0, 112, 18, 85, 117, 32, 0, 224, 128,
  248, 2, 88, 104, 64, 32, 0, 248, 136, 248, 136, 136, 2, 88, 104, 16,
  32, 0, 248, 136, 248, 136, 136, 2, 88, 104, 32, 80, 0, 248, 136, 248,
  136, 136, 2, 89, 105, 8, 248, 128, 0, 248, 136, 248, 136, 136, 2, 87,
  103, 80, 0, 248, 136, 248, 136, 136, 2, 87, 103, 32, 0, 248, 136, 248,
  136, 136, 2, 85, 101, 248, 160, 248, 160, 184, 0, 87, 103, 248, 128, 128,
  128, 248, 16, 48, 2, 88, 104, 64, 32, 0, 248, 128, 248, 128, 248, 2,
  88, 104, 16, 32, 0, 248, 128, 248, 128, 248, 2, 88, 104, 32, 80, 0,
  248, 128, 248, 128, 248, 2, 86, 102, 80, 248, 128, 248, 128, 248, 2, 88,
  104, 64, 32, 0, 248, 32, 32, 32, 248, 2, 88, 104, 16, 32, 0, 248,
  32, 32, 32, 248, 2, 88, 104, 32, 80, 0, 248, 32, 32, 32, 248, 2,
  87, 103, 80, 0, 248, 32, 32, 32, 248, 2, 85, 101, 240, 136, 232, 136,
  240, 2, 89, 105, 8, 248, 128, 0, 248, 136, 136, 136, 136, 2, 88, 104,
  64, 32, 0, 248, 136, 136, 136, 248, 2, 88, 104, 16, 32, 0, 248, 136,
  136, 136, 248, 2, 88, 104, 32, 80, 0, 248, 136, 136, 136, 248, 2, 89,
  105, 8, 248, 128, 0, 248, 136, 136, 136, 248, 2, 87, 103, 80, 0, 248,
  136, 136, 136, 248, 3, 51, 67, 160, 64, 160, 2, 85, 101, 248, 152, 168,
  200, 248, 2, 87, 103, 64, 32, 136, 136, 136, 136, 248, 2, 87, 103, 16,
  32, 136, 136, 136, 136, 248, 2, 86, 102, 32, 80, 136, 136, 136, 248, 2,
  86, 102, 80, 0, 136, 136, 136, 248, 2, 88, 104, 16, 32, 0, 136, 136,
  80, 32, 32, 18, 85, 117, 128, 240, 136, 240, 128, 1, 86, 102, 240, 136,
  176, 136, 176, 128, 2, 68, 84, 240, 16, 240, 240, 2, 71, 87, 64, 32,
  0, 240, 16, 240, 240, 2, 71, 87, 32, 64, 0, 240, 16, 240, 240, 2,
  71, 87, 96, 144, 0, 240, 16, 240, 240, 2, 70, 86, 144, 0, 240, 16,
  240, 240, 2, 70, 86, 32, 0, 240, 16, 240, 240, 2, 116, 132, 254, 30,
  240, 254, 0, 70, 86, 240, 128, 128, 240, 32, 96, 2, 71, 87, 64, 32,
  0, 240, 240, 128, 240, 2, 71, 87, 32, 64, 0, 240, 240, 128, 240, 2,
  71, 87, 96, 144, 0, 240, 240, 128, 240, 2, 70, 86, 144, 0, 240, 240,
  128, 240, 2, 39, 39, 128, 64, 0, 64, 64, 64, 64, 2, 39, 39, 64,
  128, 0, 128, 128, 128, 128, 2, 55, 39, 64, 160, 0, 64, 64, 64, 64,
  2, 54, 38, 160, 0, 64, 64, 64, 64, 2, 85, 85, 56, 16, 240, 144,
  240, 2, 71, 87, 80, 160, 0, 240, 144, 144, 144, 2, 71, 87, 64, 32,
  0, 240, 144, 144, 240, 2, 71, 87, 32, 64, 0, 240, 144, 144, 240, 2,
  71, 87, 96, 144, 0, 240, 144, 144, 240, 2, 71, 87, 80, 160, 0, 240,
  144, 144, 240, 2, 70, 86, 144, 0, 240, 144, 144, 240, 2, 85, 101, 32,
  0, 248, 0, 32, 2, 68, 84, 240, 176, 208, 240, 2, 71, 87, 64, 32,
  0, 144, 144, 144, 240, 2, 71, 87, 32, 64, 0, 144, 144, 144, 240, 2,
  71, 87, 96, 144, 0, 144, 144, 144, 240, 2, 70, 86, 144, 0, 144, 144,
  144, 240, 1, 72, 88, 32, 64, 0, 144, 144, 144, 240, 16, 18, 85, 117,
  128, 240, 136, 240, 128, 1, 71, 87, 144, 0, 144, 144, 144, 240, 16
};

/*
  Fontname: -FreeType-Org_v01-Medium-R-Normal--8-80-72-72-P-43-ISO10646-1
  Copyright:  www.orgdot.com
  Capital A Height: 0, '1' Height: 5
  Calculated Max Values w= 5 h= 5 x= 0 y= 2 dx= 6 dy= 0 ascent= 5 len= 5
  Font Bounding box     w=11 h=11 x= 0 y=-2
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 5 descent= 0
  X Font      ascent = 5 descent= 0
  Max Font    ascent = 5 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_orgv01n[137] U8G_FONT_SECTION("u8g_font_orgv01n") = {
  1, 11, 11, 0, 254, 5, 0, 0, 0, 0, 42, 58, 0, 5, 255, 5,
  0, 3, 51, 67, 160, 64, 160, 3, 51, 67, 64, 224, 64, 1, 18, 34,
  128, 128, 4, 65, 81, 240, 2, 17, 33, 128, 2, 85, 101, 8, 16, 32,
  64, 128, 2, 85, 101, 248, 136, 136, 136, 248, 2, 21, 37, 128, 128, 128,
  128, 128, 2, 85, 101, 248, 8, 248, 128, 248, 2, 85, 101, 248, 8, 248,
  8, 248, 2, 85, 101, 136, 136, 248, 8, 8, 2, 85, 101, 248, 128, 248,
  8, 248, 2, 85, 101, 248, 128, 248, 136, 248, 2, 85, 101, 248, 8, 8,
  8, 8, 2, 85, 101, 248, 136, 248, 136, 248, 2, 85, 101, 248, 136, 248,
  8, 248, 2, 20, 36, 128, 0, 0, 128
};

/*
  Fontname: -FreeType-Org_v01-Medium-R-Normal--8-80-72-72-P-43-ISO10646-1
  Copyright:  www.orgdot.com
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 5 h= 5 x= 0 y= 4 dx= 6 dy= 0 ascent= 5 len= 5
  Font Bounding box     w=11 h=11 x= 0 y=-2
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-1
  X Font      ascent = 5 descent=-1
  Max Font    ascent = 5 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_orgv01r[719] U8G_FONT_SECTION("u8g_font_orgv01r") = {
  1, 11, 11, 0, 254, 5, 0, 249, 1, 238, 32, 127, 255, 5, 255, 5,
  255, 2, 0, 64, 2, 21, 37, 128, 128, 128, 0, 128, 6, 49, 65, 160,
  2, 85, 101, 80, 248, 80, 248, 80, 2, 85, 101, 248, 160, 248, 40, 248,
  2, 85, 101, 136, 16, 32, 64, 136, 2, 85, 101, 240, 144, 248, 144, 232,
  6, 17, 33, 128, 2, 37, 53, 64, 128, 128, 128, 64, 2, 37, 53, 128,
  64, 64, 64, 128, 3, 51, 67, 160, 64, 160, 3, 51, 67, 64, 224, 64,
  1, 18, 34, 128, 128, 4, 65, 81, 240, 2, 17, 33, 128, 2, 85, 101,
  8, 16, 32, 64, 128, 2, 85, 101, 248, 136, 136, 136, 248, 2, 21, 37,
  128, 128, 128, 128, 128, 2, 85, 101, 248, 8, 248, 128, 248, 2, 85, 101,
  248, 8, 248, 8, 248, 2, 85, 101, 136, 136, 248, 8, 8, 2, 85, 101,
  248, 128, 248, 8, 248, 2, 85, 101, 248, 128, 248, 136, 248, 2, 85, 101,
  248, 8, 8, 8, 8, 2, 85, 101, 248, 136, 248, 136, 248, 2, 85, 101,
  248, 136, 248, 8, 248, 2, 20, 36, 128, 0, 0, 128, 2, 20, 36, 128,
  0, 128, 128, 2, 53, 69, 32, 64, 128, 64, 32, 3, 67, 83, 240, 0,
  240, 2, 53, 69, 128, 64, 32, 64, 128, 2, 85, 101, 248, 8, 56, 0,
  32, 2, 85, 101, 248, 168, 184, 128, 248, 2, 85, 101, 248, 136, 248, 136,
  136, 2, 85, 101, 240, 136, 240, 136, 240, 2, 85, 101, 248, 128, 128, 128,
  248, 2, 85, 101, 240, 136, 136, 136, 240, 2, 85, 101, 248, 128, 248, 128,
  248, 2, 85, 101, 248, 128, 248, 128, 128, 2, 85, 101, 248, 128, 184, 136,
  248, 2, 85, 101, 136, 136, 248, 136, 136, 2, 85, 101, 248, 32, 32, 32,
  248, 2, 85, 101, 120, 16, 16, 144, 248, 2, 85, 101, 136, 176, 192, 176,
  136, 2, 85, 101, 128, 128, 128, 128, 248, 2, 85, 101, 248, 168, 168, 168,
  168, 2, 85, 101, 248, 136, 136, 136, 136, 2, 85, 101, 248, 136, 136, 136,
  248, 2, 85, 101, 248, 136, 248, 128, 128, 2, 85, 101, 248, 136, 136, 152,
  248, 2, 85, 101, 248, 136, 248, 144, 144, 2, 85, 101, 248, 128, 248, 8,
  248, 2, 85, 101, 248, 32, 32, 32, 32, 2, 85, 101, 136, 136, 136, 136,
  248, 2, 85, 101, 136, 136, 136, 80, 32, 2, 85, 101, 168, 168, 168, 168,
  248, 2, 85, 101, 136, 80, 32, 80, 136, 2, 85, 101, 136, 136, 80, 32,
  32, 2, 85, 101, 248, 8, 248, 128, 248, 2, 37, 53, 192, 128, 128, 128,
  192, 2, 85, 101, 128, 64, 32, 16, 8, 2, 37, 53, 192, 64, 64, 64,
  192, 5, 50, 66, 64, 160, 1, 81, 97, 248, 6, 17, 33, 128, 2, 68,
  84, 240, 16, 240, 240, 2, 69, 85, 128, 240, 144, 144, 240, 2, 68, 84,
  240, 128, 128, 240, 2, 69, 85, 16, 240, 144, 144, 240, 2, 68, 84, 240,
  240, 128, 240, 2, 53, 69, 96, 64, 224, 64, 64, 1, 69, 85, 240, 144,
  144, 240, 16, 2, 69, 85, 128, 240, 144, 144, 144, 2, 20, 36, 128, 128,
  128, 128, 1, 37, 53, 64, 64, 64, 64, 192, 2, 69, 85, 128, 160, 240,
  144, 144, 2, 21, 37, 128, 128, 128, 128, 128, 2, 84, 100, 248, 168, 136,
  136, 2, 68, 84, 240, 144, 144, 144, 2, 68, 84, 240, 144, 144, 240, 1,
  69, 85, 240, 144, 144, 240, 128, 1, 69, 85, 240, 144, 144, 240, 32, 2,
  68, 84, 240, 128, 128, 128, 2, 68, 84, 64, 112, 16, 240, 2, 85, 101,
  32, 248, 32, 32, 32, 2, 68, 84, 144, 144, 144, 240, 2, 68, 84, 144,
  144, 144, 112, 2, 84, 100, 136, 136, 168, 248, 2, 68, 84, 144, 96, 96,
  144, 1, 69, 85, 144, 144, 144, 240, 16, 2, 68, 84, 32, 224, 128, 240,
  2, 53, 69, 32, 64, 192, 64, 32, 2, 21, 37, 128, 128, 128, 128, 128,
  2, 53, 69, 128, 64, 96, 64, 128, 3, 83, 99, 8, 248, 128, 255
};

/*
  Fontname: -FreeType-P01type-Medium-R-Normal--8-80-72-72-P-35-ISO10646-1
  Copyright: Copyright Patrick Lauke 2012
  Capital A Height: 4, '1' Height: 5
  Calculated Max Values w= 5 h= 5 x= 1 y= 2 dx= 6 dy= 0 ascent= 4 len= 5
  Font Bounding box     w= 5 h= 6 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 4 descent=-2
  X Font      ascent = 5 descent=-2
  Max Font    ascent = 4 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_p01type[1163] U8G_FONT_SECTION("u8g_font_p01type") = {
  0, 5, 6, 0, 254, 4, 1, 81, 2, 129, 32, 255, 254, 4, 254, 5,
  254, 0, 0, 0, 4, 0, 0, 1, 5, 5, 3, 1, 255, 128, 128, 128,
  0, 128, 3, 2, 2, 4, 0, 2, 160, 160, 5, 5, 5, 6, 0, 255,
  80, 248, 80, 248, 80, 255, 4, 4, 4, 5, 0, 0, 144, 32, 64, 144,
  4, 5, 5, 5, 0, 255, 64, 128, 80, 160, 80, 1, 2, 2, 2, 0,
  2, 128, 128, 2, 5, 5, 3, 0, 255, 64, 128, 128, 128, 64, 2, 5,
  5, 3, 0, 255, 128, 64, 64, 64, 128, 3, 3, 3, 4, 0, 0, 160,
  64, 160, 3, 3, 3, 4, 0, 0, 64, 224, 64, 2, 2, 2, 3, 0,
  255, 64, 128, 3, 1, 1, 4, 0, 1, 224, 1, 1, 1, 2, 0, 0,
  128, 4, 4, 4, 5, 0, 255, 16, 32, 64, 128, 3, 5, 5, 4, 0,
  255, 96, 160, 160, 160, 192, 1, 5, 5, 2, 0, 255, 128, 128, 128, 128,
  128, 3, 5, 5, 4, 0, 255, 192, 32, 224, 128, 96, 3, 5, 5, 4,
  0, 255, 192, 32, 192, 32, 192, 3, 5, 5, 4, 0, 255, 160, 160, 224,
  32, 32, 3, 5, 5, 4, 0, 255, 96, 128, 224, 32, 192, 3, 5, 5,
  4, 0, 255, 96, 128, 224, 160, 192, 3, 5, 5, 4, 0, 255, 224, 32,
  32, 64, 64, 3, 5, 5, 4, 0, 255, 96, 160, 224, 160, 192, 3, 5,
  5, 4, 0, 255, 96, 160, 224, 32, 192, 1, 3, 3, 2, 0, 0, 128,
  0, 128, 2, 4, 4, 3, 0, 255, 64, 0, 64, 128, 3, 5, 5, 4,
  0, 255, 32, 64, 128, 64, 32, 3, 3, 3, 4, 0, 0, 224, 0, 224,
  3, 5, 5, 4, 0, 255, 128, 64, 32, 64, 128, 4, 5, 5, 5, 0,
  255, 224, 16, 96, 0, 64, 4, 5, 5, 5, 0, 255, 112, 144, 176, 128,
  224, 4, 4, 4, 5, 0, 0, 112, 144, 240, 144, 4, 5, 5, 5, 0,
  255, 112, 144, 224, 144, 224, 4, 4, 4, 5, 0, 0, 112, 128, 128, 240,
  4, 4, 4, 5, 0, 0, 224, 144, 144, 240, 4, 5, 5, 5, 0, 255,
  112, 128, 224, 128, 112, 4, 4, 4, 5, 0, 0, 240, 128, 224, 128, 4,
  4, 4, 5, 0, 0, 112, 128, 144, 224, 4, 4, 4, 5, 0, 0, 144,
  144, 240, 144, 1, 4, 4, 2, 0, 0, 128, 128, 128, 128, 2, 4, 4,
  3, 0, 0, 64, 64, 64, 128, 4, 4, 4, 5, 0, 0, 144, 144, 224,
  144, 4, 4, 4, 5, 0, 0, 128, 128, 128, 112, 4, 4, 4, 5, 0,
  0, 144, 240, 144, 144, 4, 4, 4, 5, 0, 0, 144, 208, 176, 144, 4,
  4, 4, 5, 0, 0, 112, 144, 144, 224, 4, 4, 4, 5, 0, 0, 112,
  144, 224, 128, 4, 4, 4, 5, 0, 0, 112, 144, 160, 208, 4, 4, 4,
  5, 0, 0, 112, 144, 224, 144, 4, 5, 5, 5, 0, 255, 112, 128, 240,
  16, 224, 5, 4, 4, 6, 0, 0, 248, 32, 32, 32, 4, 4, 4, 5,
  0, 0, 144, 144, 144, 224, 4, 4, 4, 5, 0, 0, 144, 144, 144, 96,
  5, 4, 4, 6, 0, 0, 168, 168, 168, 216, 4, 4, 4, 5, 0, 0,
  144, 144, 96, 144, 4, 4, 4, 5, 0, 0, 144, 240, 16, 224, 4, 4,
  4, 5, 0, 0, 240, 32, 64, 240, 2, 5, 5, 3, 0, 255, 192, 128,
  128, 128, 192, 4, 4, 4, 5, 0, 255, 128, 64, 32, 16, 2, 5, 5,
  3, 0, 255, 192, 64, 64, 64, 192, 255, 4, 1, 1, 5, 0, 255, 240,
  255, 3, 3, 3, 4, 0, 0, 96, 160, 224, 3, 4, 4, 4, 0, 0,
  128, 224, 160, 192, 3, 3, 3, 4, 0, 0, 96, 128, 224, 3, 4, 4,
  4, 0, 0, 32, 96, 160, 224, 3, 5, 5, 4, 0, 254, 96, 160, 224,
  128, 96, 3, 4, 4, 4, 0, 0, 96, 64, 224, 64, 3, 5, 5, 4,
  0, 254, 96, 160, 224, 32, 192, 3, 4, 4, 4, 0, 0, 128, 192, 160,
  160, 1, 3, 3, 2, 0, 0, 128, 128, 128, 2, 5, 5, 3, 0, 254,
  64, 64, 64, 64, 128, 3, 4, 4, 4, 0, 0, 128, 160, 192, 160, 1,
  4, 4, 2, 0, 0, 128, 128, 128, 128, 5, 3, 3, 6, 0, 0, 80,
  168, 168, 3, 3, 3, 4, 0, 0, 192, 160, 160, 3, 3, 3, 4, 0,
  0, 96, 160, 192, 3, 5, 5, 4, 0, 254, 96, 160, 192, 128, 128, 3,
  5, 5, 4, 0, 254, 192, 160, 96, 32, 32, 3, 3, 3, 4, 0, 0,
  96, 128, 128, 3, 5, 5, 4, 0, 254, 96, 128, 224, 32, 192, 3, 4,
  4, 4, 0, 0, 64, 224, 64, 32, 3, 3, 3, 4, 0, 0, 160, 160,
  96, 3, 3, 3, 4, 0, 0, 160, 160, 64, 5, 3, 3, 6, 0, 0,
  168, 168, 80, 3, 3, 3, 4, 0, 0, 160, 64, 160, 3, 5, 5, 4,
  0, 254, 160, 160, 96, 32, 192, 3, 3, 3, 4, 0, 0, 224, 64, 224,
  3, 5, 5, 4, 0, 255, 96, 64, 128, 64, 96, 1, 5, 5, 2, 0,
  255, 128, 128, 128, 128, 128, 3, 5, 5, 4, 0, 255, 192, 64, 32, 64,
  192, 4, 2, 2, 5, 0, 1, 80, 160, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 1, 5, 5, 2, 0,
  255, 128, 0, 128, 128, 128, 255, 255, 255, 255, 1, 5, 5, 3, 1, 255,
  128, 128, 0, 128, 128, 255, 255, 255, 255, 5, 5, 5, 6, 0, 255, 40,
  80, 160, 80, 40, 3, 2, 2, 4, 0, 0, 224, 32, 3, 1, 1, 4,
  0, 1, 224, 255, 255, 255, 3, 5, 5, 4, 0, 255, 64, 224, 64, 0,
  224, 255, 255, 255, 255, 255, 1, 1, 1, 2, 0, 1, 128, 255, 255, 255,
  5, 5, 5, 6, 0, 255, 160, 80, 40, 80, 160, 255, 255, 255, 4, 5,
  5, 5, 0, 255, 32, 0, 96, 128, 112, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  3, 3, 3, 4, 0, 0, 160, 64, 160, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 3, 5, 5, 4, 0, 255, 64, 0,
  224, 0, 64, 255, 255, 255, 255, 255, 255, 255, 255
};

/*
  Fontname: -FreeType-P01type-Medium-R-Normal--8-80-72-72-P-35-ISO10646-1
  Copyright: Copyright Patrick Lauke 2012
  Capital A Height: 0, '1' Height: 5
  Calculated Max Values w= 4 h= 5 x= 0 y= 1 dx= 5 dy= 0 ascent= 4 len= 5
  Font Bounding box     w= 5 h= 6 x= 0 y=-2
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 5 descent= 0
  X Font      ascent = 5 descent= 0
  Max Font    ascent = 4 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_p01typen[186] U8G_FONT_SECTION("u8g_font_p01typen") = {
  0, 5, 6, 0, 254, 5, 0, 0, 0, 0, 42, 58, 0, 4, 255, 5,
  0, 3, 3, 3, 4, 0, 0, 160, 64, 160, 3, 3, 3, 4, 0, 0,
  64, 224, 64, 2, 2, 2, 3, 0, 255, 64, 128, 3, 1, 1, 4, 0,
  1, 224, 1, 1, 1, 2, 0, 0, 128, 4, 4, 4, 5, 0, 255, 16,
  32, 64, 128, 3, 5, 5, 4, 0, 255, 96, 160, 160, 160, 192, 1, 5,
  5, 2, 0, 255, 128, 128, 128, 128, 128, 3, 5, 5, 4, 0, 255, 192,
  32, 224, 128, 96, 3, 5, 5, 4, 0, 255, 192, 32, 192, 32, 192, 3,
  5, 5, 4, 0, 255, 160, 160, 224, 32, 32, 3, 5, 5, 4, 0, 255,
  96, 128, 224, 32, 192, 3, 5, 5, 4, 0, 255, 96, 128, 224, 160, 192,
  3, 5, 5, 4, 0, 255, 224, 32, 32, 64, 64, 3, 5, 5, 4, 0,
  255, 96, 160, 224, 160, 192, 3, 5, 5, 4, 0, 255, 96, 160, 224, 32,
  192, 1, 3, 3, 2, 0, 0, 128, 0, 128
};

/*
  Fontname: -FreeType-P01type-Medium-R-Normal--8-80-72-72-P-35-ISO10646-1
  Copyright: Copyright Patrick Lauke 2012
  Capital A Height: 4, '1' Height: 5
  Calculated Max Values w= 5 h= 5 x= 1 y= 2 dx= 6 dy= 0 ascent= 4 len= 5
  Font Bounding box     w= 5 h= 6 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 4 descent=-2
  X Font      ascent = 5 descent=-2
  Max Font    ascent = 4 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_p01typer[938] U8G_FONT_SECTION("u8g_font_p01typer") = {
  0, 5, 6, 0, 254, 4, 1, 81, 2, 129, 32, 127, 254, 4, 254, 5,
  254, 0, 0, 0, 4, 0, 0, 1, 5, 5, 3, 1, 255, 128, 128, 128,
  0, 128, 3, 2, 2, 4, 0, 2, 160, 160, 5, 5, 5, 6, 0, 255,
  80, 248, 80, 248, 80, 255, 4, 4, 4, 5, 0, 0, 144, 32, 64, 144,
  4, 5, 5, 5, 0, 255, 64, 128, 80, 160, 80, 1, 2, 2, 2, 0,
  2, 128, 128, 2, 5, 5, 3, 0, 255, 64, 128, 128, 128, 64, 2, 5,
  5, 3, 0, 255, 128, 64, 64, 64, 128, 3, 3, 3, 4, 0, 0, 160,
  64, 160, 3, 3, 3, 4, 0, 0, 64, 224, 64, 2, 2, 2, 3, 0,
  255, 64, 128, 3, 1, 1, 4, 0, 1, 224, 1, 1, 1, 2, 0, 0,
  128, 4, 4, 4, 5, 0, 255, 16, 32, 64, 128, 3, 5, 5, 4, 0,
  255, 96, 160, 160, 160, 192, 1, 5, 5, 2, 0, 255, 128, 128, 128, 128,
  128, 3, 5, 5, 4, 0, 255, 192, 32, 224, 128, 96, 3, 5, 5, 4,
  0, 255, 192, 32, 192, 32, 192, 3, 5, 5, 4, 0, 255, 160, 160, 224,
  32, 32, 3, 5, 5, 4, 0, 255, 96, 128, 224, 32, 192, 3, 5, 5,
  4, 0, 255, 96, 128, 224, 160, 192, 3, 5, 5, 4, 0, 255, 224, 32,
  32, 64, 64, 3, 5, 5, 4, 0, 255, 96, 160, 224, 160, 192, 3, 5,
  5, 4, 0, 255, 96, 160, 224, 32, 192, 1, 3, 3, 2, 0, 0, 128,
  0, 128, 2, 4, 4, 3, 0, 255, 64, 0, 64, 128, 3, 5, 5, 4,
  0, 255, 32, 64, 128, 64, 32, 3, 3, 3, 4, 0, 0, 224, 0, 224,
  3, 5, 5, 4, 0, 255, 128, 64, 32, 64, 128, 4, 5, 5, 5, 0,
  255, 224, 16, 96, 0, 64, 4, 5, 5, 5, 0, 255, 112, 144, 176, 128,
  224, 4, 4, 4, 5, 0, 0, 112, 144, 240, 144, 4, 5, 5, 5, 0,
  255, 112, 144, 224, 144, 224, 4, 4, 4, 5, 0, 0, 112, 128, 128, 240,
  4, 4, 4, 5, 0, 0, 224, 144, 144, 240, 4, 5, 5, 5, 0, 255,
  112, 128, 224, 128, 112, 4, 4, 4, 5, 0, 0, 240, 128, 224, 128, 4,
  4, 4, 5, 0, 0, 112, 128, 144, 224, 4, 4, 4, 5, 0, 0, 144,
  144, 240, 144, 1, 4, 4, 2, 0, 0, 128, 128, 128, 128, 2, 4, 4,
  3, 0, 0, 64, 64, 64, 128, 4, 4, 4, 5, 0, 0, 144, 144, 224,
  144, 4, 4, 4, 5, 0, 0, 128, 128, 128, 112, 4, 4, 4, 5, 0,
  0, 144, 240, 144, 144, 4, 4, 4, 5, 0, 0, 144, 208, 176, 144, 4,
  4, 4, 5, 0, 0, 112, 144, 144, 224, 4, 4, 4, 5, 0, 0, 112,
  144, 224, 128, 4, 4, 4, 5, 0, 0, 112, 144, 160, 208, 4, 4, 4,
  5, 0, 0, 112, 144, 224, 144, 4, 5, 5, 5, 0, 255, 112, 128, 240,
  16, 224, 5, 4, 4, 6, 0, 0, 248, 32, 32, 32, 4, 4, 4, 5,
  0, 0, 144, 144, 144, 224, 4, 4, 4, 5, 0, 0, 144, 144, 144, 96,
  5, 4, 4, 6, 0, 0, 168, 168, 168, 216, 4, 4, 4, 5, 0, 0,
  144, 144, 96, 144, 4, 4, 4, 5, 0, 0, 144, 240, 16, 224, 4, 4,
  4, 5, 0, 0, 240, 32, 64, 240, 2, 5, 5, 3, 0, 255, 192, 128,
  128, 128, 192, 4, 4, 4, 5, 0, 255, 128, 64, 32, 16, 2, 5, 5,
  3, 0, 255, 192, 64, 64, 64, 192, 255, 4, 1, 1, 5, 0, 255, 240,
  255, 3, 3, 3, 4, 0, 0, 96, 160, 224, 3, 4, 4, 4, 0, 0,
  128, 224, 160, 192, 3, 3, 3, 4, 0, 0, 96, 128, 224, 3, 4, 4,
  4, 0, 0, 32, 96, 160, 224, 3, 5, 5, 4, 0, 254, 96, 160, 224,
  128, 96, 3, 4, 4, 4, 0, 0, 96, 64, 224, 64, 3, 5, 5, 4,
  0, 254, 96, 160, 224, 32, 192, 3, 4, 4, 4, 0, 0, 128, 192, 160,
  160, 1, 3, 3, 2, 0, 0, 128, 128, 128, 2, 5, 5, 3, 0, 254,
  64, 64, 64, 64, 128, 3, 4, 4, 4, 0, 0, 128, 160, 192, 160, 1,
  4, 4, 2, 0, 0, 128, 128, 128, 128, 5, 3, 3, 6, 0, 0, 80,
  168, 168, 3, 3, 3, 4, 0, 0, 192, 160, 160, 3, 3, 3, 4, 0,
  0, 96, 160, 192, 3, 5, 5, 4, 0, 254, 96, 160, 192, 128, 128, 3,
  5, 5, 4, 0, 254, 192, 160, 96, 32, 32, 3, 3, 3, 4, 0, 0,
  96, 128, 128, 3, 5, 5, 4, 0, 254, 96, 128, 224, 32, 192, 3, 4,
  4, 4, 0, 0, 64, 224, 64, 32, 3, 3, 3, 4, 0, 0, 160, 160,
  96, 3, 3, 3, 4, 0, 0, 160, 160, 64, 5, 3, 3, 6, 0, 0,
  168, 168, 80, 3, 3, 3, 4, 0, 0, 160, 64, 160, 3, 5, 5, 4,
  0, 254, 160, 160, 96, 32, 192, 3, 3, 3, 4, 0, 0, 224, 64, 224,
  3, 5, 5, 4, 0, 255, 96, 64, 128, 64, 96, 1, 5, 5, 2, 0,
  255, 128, 128, 128, 128, 128, 3, 5, 5, 4, 0, 255, 192, 64, 32, 64,
  192, 4, 2, 2, 5, 0, 1, 80, 160, 255
};

/*
  Fontname: -FreeType-Pixelle (Micro)-Medium-R-Normal--8-80-72-72-P-32-ISO10646-1
  Copyright: Copyright rdonaghy 2008
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 5 h= 7 x= 0 y= 4 dx= 6 dy= 0 ascent= 6 len= 7
  Font Bounding box     w= 6 h= 8 x=-1 y=-2
  Calculated Min Values           x=-1 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-2
  X Font      ascent = 6 descent=-2
  Max Font    ascent = 6 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_pixelle_micro[1140] U8G_FONT_SECTION("u8g_font_pixelle_micro") = {
  0, 6, 8, 255, 254, 5, 1, 97, 2, 188, 32, 255, 254, 6, 254, 6,
  254, 0, 0, 0, 1, 0, 0, 1, 5, 5, 2, 0, 0, 128, 128, 128,
  0, 128, 3, 2, 2, 4, 0, 3, 160, 160, 5, 5, 5, 6, 0, 0,
  80, 248, 80, 248, 80, 3, 7, 7, 4, 0, 255, 64, 224, 128, 224, 32,
  224, 64, 4, 4, 4, 5, 0, 0, 144, 32, 64, 144, 4, 5, 5, 5,
  0, 0, 96, 64, 208, 160, 208, 1, 2, 2, 2, 0, 3, 128, 128, 2,
  7, 7, 3, 0, 255, 64, 128, 128, 128, 128, 128, 64, 2, 7, 7, 3,
  0, 255, 128, 64, 64, 64, 64, 64, 128, 3, 4, 4, 4, 0, 0, 64,
  224, 64, 160, 3, 3, 3, 4, 0, 0, 64, 224, 64, 1, 2, 2, 2,
  0, 255, 128, 128, 3, 1, 1, 4, 0, 1, 224, 1, 1, 1, 2, 0,
  0, 128, 3, 6, 6, 4, 0, 0, 32, 32, 64, 64, 128, 128, 3, 5,
  5, 4, 0, 0, 64, 160, 224, 160, 64, 3, 5, 5, 4, 0, 0, 192,
  64, 64, 64, 224, 3, 5, 5, 4, 0, 0, 64, 160, 32, 64, 224, 3,
  5, 5, 4, 0, 0, 192, 32, 64, 32, 192, 3, 5, 5, 4, 0, 0,
  160, 160, 224, 32, 32, 3, 5, 5, 4, 0, 0, 224, 128, 224, 32, 192,
  3, 5, 5, 4, 0, 0, 64, 160, 192, 160, 64, 3, 5, 5, 4, 0,
  0, 224, 32, 64, 64, 128, 3, 5, 5, 4, 0, 0, 64, 160, 64, 160,
  64, 3, 5, 5, 4, 0, 0, 64, 160, 96, 160, 64, 1, 3, 3, 2,
  0, 0, 128, 0, 128, 1, 4, 4, 2, 0, 255, 128, 0, 128, 128, 2,
  3, 3, 3, 0, 0, 64, 128, 64, 3, 3, 3, 4, 0, 0, 224, 0,
  224, 2, 3, 3, 3, 0, 0, 128, 64, 128, 3, 5, 5, 4, 0, 0,
  64, 160, 32, 64, 64, 5, 6, 6, 6, 0, 0, 112, 136, 168, 184, 128,
  120, 3, 5, 5, 4, 0, 0, 64, 160, 224, 160, 160, 3, 5, 5, 4,
  0, 0, 192, 160, 192, 160, 192, 3, 5, 5, 4, 0, 0, 64, 160, 128,
  160, 64, 3, 5, 5, 4, 0, 0, 192, 160, 160, 160, 192, 3, 5, 5,
  4, 0, 0, 224, 128, 192, 128, 224, 3, 5, 5, 4, 0, 0, 224, 128,
  192, 128, 128, 3, 5, 5, 4, 0, 0, 64, 160, 128, 160, 96, 3, 5,
  5, 4, 0, 0, 160, 160, 224, 160, 160, 3, 5, 5, 4, 0, 0, 224,
  64, 64, 64, 224, 3, 5, 5, 4, 0, 0, 32, 32, 32, 160, 64, 3,
  5, 5, 4, 0, 0, 160, 160, 192, 160, 160, 3, 5, 5, 4, 0, 0,
  128, 128, 128, 128, 224, 3, 5, 5, 4, 0, 0, 160, 224, 224, 160, 160,
  3, 5, 5, 4, 0, 0, 160, 224, 224, 224, 160, 3, 5, 5, 4, 0,
  0, 64, 160, 160, 160, 64, 3, 5, 5, 4, 0, 0, 192, 160, 192, 128,
  128, 3, 5, 5, 4, 0, 0, 64, 160, 160, 224, 96, 3, 5, 5, 4,
  0, 0, 192, 160, 192, 160, 160, 3, 5, 5, 4, 0, 0, 96, 128, 64,
  32, 224, 3, 5, 5, 4, 0, 0, 224, 64, 64, 64, 64, 3, 5, 5,
  4, 0, 0, 160, 160, 160, 160, 64, 3, 5, 5, 4, 0, 0, 160, 160,
  160, 64, 64, 3, 5, 5, 4, 0, 0, 160, 160, 224, 224, 160, 3, 5,
  5, 4, 0, 0, 160, 160, 64, 160, 160, 3, 5, 5, 4, 0, 0, 160,
  160, 64, 64, 64, 3, 5, 5, 4, 0, 0, 224, 32, 64, 128, 224, 2,
  7, 7, 3, 0, 255, 192, 128, 128, 128, 128, 128, 192, 3, 6, 6, 4,
  0, 0, 128, 128, 64, 64, 32, 32, 2, 7, 7, 3, 0, 255, 192, 64,
  64, 64, 64, 64, 192, 3, 2, 2, 4, 0, 3, 64, 160, 3, 1, 1,
  4, 0, 0, 224, 1, 2, 2, 2, 0, 4, 128, 128, 3, 3, 3, 4,
  0, 0, 96, 160, 96, 3, 5, 5, 4, 0, 0, 128, 128, 192, 160, 192,
  3, 3, 3, 4, 0, 0, 96, 128, 96, 3, 5, 5, 4, 0, 0, 32,
  32, 96, 160, 96, 3, 3, 3, 4, 0, 0, 96, 224, 96, 2, 5, 5,
  3, 0, 0, 64, 128, 192, 128, 128, 3, 5, 5, 4, 0, 254, 96, 160,
  96, 160, 64, 3, 5, 5, 4, 0, 0, 128, 128, 192, 160, 160, 1, 5,
  5, 2, 0, 0, 128, 0, 128, 128, 128, 3, 7, 7, 3, 255, 254, 32,
  0, 32, 32, 32, 160, 64, 3, 6, 6, 4, 0, 0, 128, 128, 128, 160,
  192, 160, 1, 6, 6, 2, 0, 0, 128, 128, 128, 128, 128, 128, 5, 3,
  3, 6, 0, 0, 208, 168, 168, 3, 3, 3, 4, 0, 0, 192, 160, 160,
  3, 3, 3, 4, 0, 0, 64, 160, 64, 3, 5, 5, 4, 0, 254, 192,
  160, 192, 128, 128, 3, 5, 5, 4, 0, 254, 96, 160, 96, 32, 32, 3,
  3, 3, 4, 0, 0, 192, 160, 128, 3, 3, 3, 4, 0, 0, 96, 64,
  192, 3, 5, 5, 4, 0, 0, 64, 64, 224, 64, 64, 3, 3, 3, 4,
  0, 0, 160, 160, 64, 3, 3, 3, 4, 0, 0, 160, 64, 64, 5, 3,
  3, 6, 0, 0, 168, 168, 208, 3, 3, 3, 4, 0, 0, 160, 64, 160,
  3, 5, 5, 4, 0, 254, 160, 160, 96, 160, 64, 3, 3, 3, 4, 0,
  0, 224, 64, 224, 3, 7, 7, 4, 0, 255, 32, 64, 64, 128, 64, 64,
  32, 1, 7, 7, 2, 0, 255, 128, 128, 128, 128, 128, 128, 128, 3, 7,
  7, 4, 0, 255, 128, 64, 64, 32, 64, 64, 128, 4, 2, 2, 5, 0,
  1, 80, 160, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255
};

/*
  Fontname: -FreeType-Pixelle (Micro)-Medium-R-Normal--8-80-72-72-P-32-ISO10646-1
  Copyright: Copyright rdonaghy 2008
  Capital A Height: 0, '1' Height: 5
  Calculated Max Values w= 3 h= 6 x= 0 y= 1 dx= 4 dy= 0 ascent= 6 len= 6
  Font Bounding box     w= 6 h= 8 x=-1 y=-2
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 5 descent= 0
  X Font      ascent = 5 descent= 0
  Max Font    ascent = 6 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_pixelle_micron[189] U8G_FONT_SECTION("u8g_font_pixelle_micron") = {
  0, 6, 8, 255, 254, 5, 0, 0, 0, 0, 42, 58, 0, 6, 255, 5,
  0, 3, 4, 4, 4, 0, 0, 64, 224, 64, 160, 3, 3, 3, 4, 0,
  0, 64, 224, 64, 1, 2, 2, 2, 0, 255, 128, 128, 3, 1, 1, 4,
  0, 1, 224, 1, 1, 1, 2, 0, 0, 128, 3, 6, 6, 4, 0, 0,
  32, 32, 64, 64, 128, 128, 3, 5, 5, 4, 0, 0, 64, 160, 224, 160,
  64, 3, 5, 5, 4, 0, 0, 192, 64, 64, 64, 224, 3, 5, 5, 4,
  0, 0, 64, 160, 32, 64, 224, 3, 5, 5, 4, 0, 0, 192, 32, 64,
  32, 192, 3, 5, 5, 4, 0, 0, 160, 160, 224, 32, 32, 3, 5, 5,
  4, 0, 0, 224, 128, 224, 32, 192, 3, 5, 5, 4, 0, 0, 64, 160,
  192, 160, 64, 3, 5, 5, 4, 0, 0, 224, 32, 64, 64, 128, 3, 5,
  5, 4, 0, 0, 64, 160, 64, 160, 64, 3, 5, 5, 4, 0, 0, 64,
  160, 96, 160, 64, 1, 3, 3, 2, 0, 0, 128, 0, 128
};

/*
  Fontname: -FreeType-Pixelle (Micro)-Medium-R-Normal--8-80-72-72-P-32-ISO10646-1
  Copyright: Copyright rdonaghy 2008
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 5 h= 7 x= 0 y= 4 dx= 6 dy= 0 ascent= 6 len= 7
  Font Bounding box     w= 6 h= 8 x=-1 y=-2
  Calculated Min Values           x=-1 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-2
  X Font      ascent = 6 descent=-2
  Max Font    ascent = 6 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_pixelle_micror[1012] U8G_FONT_SECTION("u8g_font_pixelle_micror") = {
  0, 6, 8, 255, 254, 5, 1, 97, 2, 188, 32, 127, 254, 6, 254, 6,
  254, 0, 0, 0, 1, 0, 0, 1, 5, 5, 2, 0, 0, 128, 128, 128,
  0, 128, 3, 2, 2, 4, 0, 3, 160, 160, 5, 5, 5, 6, 0, 0,
  80, 248, 80, 248, 80, 3, 7, 7, 4, 0, 255, 64, 224, 128, 224, 32,
  224, 64, 4, 4, 4, 5, 0, 0, 144, 32, 64, 144, 4, 5, 5, 5,
  0, 0, 96, 64, 208, 160, 208, 1, 2, 2, 2, 0, 3, 128, 128, 2,
  7, 7, 3, 0, 255, 64, 128, 128, 128, 128, 128, 64, 2, 7, 7, 3,
  0, 255, 128, 64, 64, 64, 64, 64, 128, 3, 4, 4, 4, 0, 0, 64,
  224, 64, 160, 3, 3, 3, 4, 0, 0, 64, 224, 64, 1, 2, 2, 2,
  0, 255, 128, 128, 3, 1, 1, 4, 0, 1, 224, 1, 1, 1, 2, 0,
  0, 128, 3, 6, 6, 4, 0, 0, 32, 32, 64, 64, 128, 128, 3, 5,
  5, 4, 0, 0, 64, 160, 224, 160, 64, 3, 5, 5, 4, 0, 0, 192,
  64, 64, 64, 224, 3, 5, 5, 4, 0, 0, 64, 160, 32, 64, 224, 3,
  5, 5, 4, 0, 0, 192, 32, 64, 32, 192, 3, 5, 5, 4, 0, 0,
  160, 160, 224, 32, 32, 3, 5, 5, 4, 0, 0, 224, 128, 224, 32, 192,
  3, 5, 5, 4, 0, 0, 64, 160, 192, 160, 64, 3, 5, 5, 4, 0,
  0, 224, 32, 64, 64, 128, 3, 5, 5, 4, 0, 0, 64, 160, 64, 160,
  64, 3, 5, 5, 4, 0, 0, 64, 160, 96, 160, 64, 1, 3, 3, 2,
  0, 0, 128, 0, 128, 1, 4, 4, 2, 0, 255, 128, 0, 128, 128, 2,
  3, 3, 3, 0, 0, 64, 128, 64, 3, 3, 3, 4, 0, 0, 224, 0,
  224, 2, 3, 3, 3, 0, 0, 128, 64, 128, 3, 5, 5, 4, 0, 0,
  64, 160, 32, 64, 64, 5, 6, 6, 6, 0, 0, 112, 136, 168, 184, 128,
  120, 3, 5, 5, 4, 0, 0, 64, 160, 224, 160, 160, 3, 5, 5, 4,
  0, 0, 192, 160, 192, 160, 192, 3, 5, 5, 4, 0, 0, 64, 160, 128,
  160, 64, 3, 5, 5, 4, 0, 0, 192, 160, 160, 160, 192, 3, 5, 5,
  4, 0, 0, 224, 128, 192, 128, 224, 3, 5, 5, 4, 0, 0, 224, 128,
  192, 128, 128, 3, 5, 5, 4, 0, 0, 64, 160, 128, 160, 96, 3, 5,
  5, 4, 0, 0, 160, 160, 224, 160, 160, 3, 5, 5, 4, 0, 0, 224,
  64, 64, 64, 224, 3, 5, 5, 4, 0, 0, 32, 32, 32, 160, 64, 3,
  5, 5, 4, 0, 0, 160, 160, 192, 160, 160, 3, 5, 5, 4, 0, 0,
  128, 128, 128, 128, 224, 3, 5, 5, 4, 0, 0, 160, 224, 224, 160, 160,
  3, 5, 5, 4, 0, 0, 160, 224, 224, 224, 160, 3, 5, 5, 4, 0,
  0, 64, 160, 160, 160, 64, 3, 5, 5, 4, 0, 0, 192, 160, 192, 128,
  128, 3, 5, 5, 4, 0, 0, 64, 160, 160, 224, 96, 3, 5, 5, 4,
  0, 0, 192, 160, 192, 160, 160, 3, 5, 5, 4, 0, 0, 96, 128, 64,
  32, 224, 3, 5, 5, 4, 0, 0, 224, 64, 64, 64, 64, 3, 5, 5,
  4, 0, 0, 160, 160, 160, 160, 64, 3, 5, 5, 4, 0, 0, 160, 160,
  160, 64, 64, 3, 5, 5, 4, 0, 0, 160, 160, 224, 224, 160, 3, 5,
  5, 4, 0, 0, 160, 160, 64, 160, 160, 3, 5, 5, 4, 0, 0, 160,
  160, 64, 64, 64, 3, 5, 5, 4, 0, 0, 224, 32, 64, 128, 224, 2,
  7, 7, 3, 0, 255, 192, 128, 128, 128, 128, 128, 192, 3, 6, 6, 4,
  0, 0, 128, 128, 64, 64, 32, 32, 2, 7, 7, 3, 0, 255, 192, 64,
  64, 64, 64, 64, 192, 3, 2, 2, 4, 0, 3, 64, 160, 3, 1, 1,
  4, 0, 0, 224, 1, 2, 2, 2, 0, 4, 128, 128, 3, 3, 3, 4,
  0, 0, 96, 160, 96, 3, 5, 5, 4, 0, 0, 128, 128, 192, 160, 192,
  3, 3, 3, 4, 0, 0, 96, 128, 96, 3, 5, 5, 4, 0, 0, 32,
  32, 96, 160, 96, 3, 3, 3, 4, 0, 0, 96, 224, 96, 2, 5, 5,
  3, 0, 0, 64, 128, 192, 128, 128, 3, 5, 5, 4, 0, 254, 96, 160,
  96, 160, 64, 3, 5, 5, 4, 0, 0, 128, 128, 192, 160, 160, 1, 5,
  5, 2, 0, 0, 128, 0, 128, 128, 128, 3, 7, 7, 3, 255, 254, 32,
  0, 32, 32, 32, 160, 64, 3, 6, 6, 4, 0, 0, 128, 128, 128, 160,
  192, 160, 1, 6, 6, 2, 0, 0, 128, 128, 128, 128, 128, 128, 5, 3,
  3, 6, 0, 0, 208, 168, 168, 3, 3, 3, 4, 0, 0, 192, 160, 160,
  3, 3, 3, 4, 0, 0, 64, 160, 64, 3, 5, 5, 4, 0, 254, 192,
  160, 192, 128, 128, 3, 5, 5, 4, 0, 254, 96, 160, 96, 32, 32, 3,
  3, 3, 4, 0, 0, 192, 160, 128, 3, 3, 3, 4, 0, 0, 96, 64,
  192, 3, 5, 5, 4, 0, 0, 64, 64, 224, 64, 64, 3, 3, 3, 4,
  0, 0, 160, 160, 64, 3, 3, 3, 4, 0, 0, 160, 64, 64, 5, 3,
  3, 6, 0, 0, 168, 168, 208, 3, 3, 3, 4, 0, 0, 160, 64, 160,
  3, 5, 5, 4, 0, 254, 160, 160, 96, 160, 64, 3, 3, 3, 4, 0,
  0, 224, 64, 224, 3, 7, 7, 4, 0, 255, 32, 64, 64, 128, 64, 64,
  32, 1, 7, 7, 2, 0, 255, 128, 128, 128, 128, 128, 128, 128, 3, 7,
  7, 4, 0, 255, 128, 64, 64, 32, 64, 64, 128, 4, 2, 2, 5, 0,
  1, 80, 160, 255
};

/*
  Fontname: -FreeType-Robot de Niro-Medium-R-Normal--16-160-72-72-P-39-ISO10646-1
  Copyright: Copyright BMoser 2008
  Capital A Height: 6, '1' Height: 5
  Calculated Max Values w= 7 h= 8 x= 0 y= 6 dx= 8 dy= 0 ascent=10 len= 8
  Font Bounding box     w=10 h=10 x=-1 y= 0
  Calculated Min Values           x=-1 y= 0 dx= 0 dy= 0
  Pure Font   ascent = 6 descent= 1
  X Font      ascent = 9 descent= 0
  Max Font    ascent =10 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_robot_de_niro[1376] U8G_FONT_SECTION("u8g_font_robot_de_niro") = {
  0, 10, 10, 255, 0, 6, 1, 97, 2, 193, 32, 255, 1, 10, 0, 9,
  0, 0, 0, 0, 2, 0, 0, 2, 5, 5, 3, 0, 3, 192, 128, 128,
  0, 128, 3, 2, 2, 4, 0, 6, 160, 160, 5, 5, 5, 6, 0, 3,
  80, 248, 80, 248, 80, 4, 7, 7, 5, 0, 2, 96, 224, 16, 96, 128,
  112, 96, 5, 5, 5, 6, 0, 3, 192, 208, 32, 88, 24, 4, 5, 5,
  5, 0, 3, 96, 160, 80, 160, 80, 1, 2, 2, 2, 0, 6, 128, 128,
  2, 7, 7, 3, 0, 2, 64, 128, 128, 128, 128, 128, 64, 2, 7, 7,
  3, 0, 2, 128, 64, 64, 64, 64, 64, 128, 3, 3, 3, 4, 0, 6,
  160, 64, 160, 3, 3, 3, 4, 0, 4, 64, 224, 64, 2, 2, 2, 3,
  0, 2, 64, 128, 3, 1, 1, 4, 0, 5, 224, 1, 1, 1, 2, 0,
  3, 128, 3, 5, 5, 4, 0, 3, 32, 32, 64, 128, 128, 3, 5, 5,
  4, 0, 3, 64, 160, 160, 160, 64, 3, 5, 5, 4, 0, 3, 192, 64,
  64, 64, 224, 3, 5, 5, 4, 0, 3, 192, 32, 96, 128, 224, 3, 5,
  5, 4, 0, 3, 192, 32, 224, 32, 224, 3, 5, 5, 4, 0, 3, 160,
  160, 224, 32, 32, 3, 5, 5, 4, 0, 3, 96, 128, 224, 32, 224, 3,
  5, 5, 4, 0, 3, 96, 128, 224, 160, 64, 4, 5, 5, 5, 0, 3,
  224, 32, 112, 32, 32, 3, 5, 5, 4, 0, 3, 96, 160, 224, 160, 192,
  3, 5, 5, 4, 0, 3, 96, 160, 224, 32, 192, 1, 3, 3, 2, 0,
  4, 128, 0, 128, 2, 4, 4, 3, 0, 3, 64, 0, 64, 128, 2, 3,
  3, 3, 0, 4, 64, 128, 64, 3, 3, 3, 4, 0, 4, 224, 0, 224,
  2, 3, 3, 3, 0, 4, 128, 64, 128, 3, 5, 5, 4, 0, 3, 224,
  32, 64, 0, 64, 5, 7, 7, 6, 0, 2, 120, 136, 184, 168, 184, 128,
  120, 4, 6, 6, 4, 255, 2, 48, 80, 112, 80, 80, 128, 4, 5, 5,
  5, 0, 3, 224, 80, 96, 80, 224, 3, 5, 5, 4, 0, 3, 96, 128,
  128, 160, 64, 4, 5, 5, 5, 0, 3, 224, 80, 80, 80, 32, 3, 5,
  5, 4, 0, 3, 96, 128, 192, 128, 224, 4, 6, 6, 5, 0, 2, 176,
  64, 96, 64, 64, 128, 4, 5, 5, 5, 0, 3, 96, 128, 176, 160, 96,
  4, 6, 6, 4, 255, 2, 80, 80, 112, 80, 80, 128, 1, 5, 5, 2,
  0, 3, 128, 128, 128, 128, 128, 3, 5, 5, 4, 0, 3, 64, 32, 32,
  32, 192, 5, 5, 5, 6, 0, 3, 208, 80, 96, 80, 72, 4, 5, 5,
  5, 0, 3, 192, 64, 64, 64, 176, 6, 5, 5, 6, 255, 3, 168, 84,
  84, 84, 68, 4, 5, 5, 5, 0, 3, 224, 80, 80, 80, 80, 3, 5,
  5, 4, 0, 3, 96, 160, 160, 160, 64, 4, 5, 5, 5, 0, 3, 176,
  80, 96, 64, 64, 4, 5, 5, 5, 0, 3, 64, 160, 160, 160, 112, 5,
  5, 5, 5, 255, 3, 176, 80, 96, 80, 72, 3, 5, 5, 4, 0, 3,
  96, 128, 224, 32, 192, 3, 5, 5, 4, 0, 3, 224, 64, 64, 64, 64,
  4, 5, 5, 5, 0, 3, 160, 160, 160, 160, 80, 3, 5, 5, 4, 0,
  3, 160, 160, 160, 160, 64, 6, 5, 5, 7, 0, 3, 172, 168, 168, 168,
  88, 4, 5, 5, 5, 0, 3, 160, 160, 64, 160, 176, 4, 7, 7, 4,
  255, 1, 208, 80, 80, 48, 16, 16, 32, 3, 5, 5, 4, 0, 3, 224,
  32, 64, 128, 224, 2, 7, 7, 3, 0, 2, 192, 128, 128, 128, 128, 128,
  192, 3, 5, 5, 4, 0, 3, 128, 128, 64, 32, 32, 2, 7, 7, 3,
  0, 2, 192, 64, 64, 64, 64, 64, 192, 3, 3, 3, 4, 0, 5, 64,
  160, 160, 4, 1, 1, 5, 0, 3, 240, 2, 2, 2, 3, 0, 6, 128,
  64, 4, 4, 4, 5, 0, 3, 96, 160, 160, 80, 4, 5, 5, 5, 0,
  3, 64, 96, 80, 80, 160, 3, 4, 4, 4, 0, 3, 96, 128, 160, 64,
  4, 6, 6, 5, 0, 3, 16, 32, 96, 160, 160, 208, 4, 4, 4, 5,
  0, 3, 96, 160, 208, 96, 4, 7, 7, 4, 255, 1, 48, 64, 96, 64,
  64, 64, 128, 4, 6, 6, 5, 0, 1, 80, 160, 160, 96, 32, 192, 3,
  7, 7, 4, 0, 3, 64, 128, 128, 192, 160, 160, 160, 1, 5, 5, 2,
  0, 3, 128, 0, 128, 128, 128, 3, 7, 7, 3, 255, 1, 32, 0, 32,
  32, 32, 32, 192, 4, 7, 7, 5, 0, 2, 128, 128, 160, 224, 160, 144,
  16, 4, 6, 6, 5, 0, 3, 32, 80, 96, 64, 64, 176, 6, 4, 4,
  7, 0, 3, 88, 168, 168, 164, 3, 4, 4, 4, 0, 3, 64, 160, 160,
  160, 3, 4, 4, 4, 0, 3, 96, 160, 160, 192, 4, 6, 6, 5, 0,
  1, 176, 80, 80, 96, 64, 128, 4, 6, 6, 5, 0, 1, 80, 160, 160,
  96, 32, 32, 4, 4, 4, 5, 0, 3, 160, 80, 64, 64, 3, 4, 4,
  4, 0, 3, 64, 160, 32, 192, 2, 6, 6, 3, 0, 3, 128, 128, 192,
  128, 128, 64, 4, 4, 4, 5, 0, 3, 160, 160, 160, 80, 3, 4, 4,
  4, 0, 3, 160, 160, 160, 64, 6, 4, 4, 7, 0, 3, 172, 168, 168,
  80, 3, 4, 4, 4, 0, 3, 160, 160, 64, 160, 3, 5, 5, 4, 0,
  2, 160, 160, 64, 32, 192, 4, 5, 5, 5, 0, 2, 224, 32, 64, 144,
  96, 3, 7, 7, 4, 0, 2, 96, 64, 64, 128, 64, 64, 96, 1, 7,
  7, 2, 0, 2, 128, 128, 128, 128, 128, 128, 128, 3, 7, 7, 4, 0,
  2, 192, 64, 64, 32, 64, 64, 192, 4, 2, 2, 5, 0, 5, 80, 160,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 4, 7, 7, 5, 0, 2, 96, 144, 64, 224, 64, 128,
  240, 255, 255, 255, 4, 7, 7, 5, 0, 2, 96, 128, 96, 144, 96, 16,
  96, 255, 7, 8, 8, 8, 0, 2, 124, 130, 154, 170, 162, 154, 130, 124,
  255, 255, 255, 255, 7, 8, 8, 8, 0, 2, 124, 130, 186, 170, 178, 170,
  130, 124, 255, 255, 255, 255, 255, 255, 255, 6, 5, 5, 7, 0, 3, 108,
  232, 104, 40, 40, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 4, 8, 8, 4, 255, 2, 80, 0, 48, 80, 112, 80, 80, 128, 255,
  255, 3, 7, 7, 4, 0, 1, 96, 128, 128, 160, 96, 64, 32, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 3, 7, 7, 4,
  0, 3, 160, 0, 96, 160, 160, 160, 64, 4, 4, 4, 5, 0, 4, 144,
  96, 96, 144, 255, 255, 255, 255, 4, 7, 7, 5, 0, 3, 80, 0, 160,
  160, 160, 160, 80, 255, 255, 4, 7, 7, 4, 255, 1, 32, 80, 96, 80,
  96, 64, 128, 255, 255, 255, 255, 4, 6, 6, 5, 0, 3, 80, 0, 96,
  160, 160, 80, 255, 255, 255, 4, 6, 6, 5, 0, 3, 96, 0, 96, 160,
  208, 96, 4, 6, 6, 5, 0, 3, 96, 0, 96, 160, 208, 96, 4, 7,
  7, 5, 0, 3, 64, 160, 0, 96, 160, 208, 96, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 3, 6, 6, 4, 0, 3, 160, 0, 96, 160,
  160, 192, 5, 5, 5, 6, 0, 3, 32, 0, 248, 0, 32, 255, 255, 255,
  255, 4, 6, 6, 5, 0, 3, 80, 0, 160, 160, 160, 80, 255, 255, 255
};

/*
  Fontname: -FreeType-Robot de Niro-Medium-R-Normal--16-160-72-72-P-39-ISO10646-1
  Copyright: Copyright BMoser 2008
  Capital A Height: 0, '1' Height: 5
  Calculated Max Values w= 4 h= 5 x= 0 y= 6 dx= 5 dy= 0 ascent= 9 len= 5
  Font Bounding box     w=10 h=10 x=-1 y= 0
  Calculated Min Values           x= 0 y= 0 dx= 0 dy= 0
  Pure Font   ascent = 5 descent= 0
  X Font      ascent = 5 descent= 0
  Max Font    ascent = 9 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_robot_de_niron[187] U8G_FONT_SECTION("u8g_font_robot_de_niron") = {
  0, 10, 10, 255, 0, 5, 0, 0, 0, 0, 42, 58, 0, 9, 0, 5,
  0, 3, 3, 3, 4, 0, 6, 160, 64, 160, 3, 3, 3, 4, 0, 4,
  64, 224, 64, 2, 2, 2, 3, 0, 2, 64, 128, 3, 1, 1, 4, 0,
  5, 224, 1, 1, 1, 2, 0, 3, 128, 3, 5, 5, 4, 0, 3, 32,
  32, 64, 128, 128, 3, 5, 5, 4, 0, 3, 64, 160, 160, 160, 64, 3,
  5, 5, 4, 0, 3, 192, 64, 64, 64, 224, 3, 5, 5, 4, 0, 3,
  192, 32, 96, 128, 224, 3, 5, 5, 4, 0, 3, 192, 32, 224, 32, 224,
  3, 5, 5, 4, 0, 3, 160, 160, 224, 32, 32, 3, 5, 5, 4, 0,
  3, 96, 128, 224, 32, 224, 3, 5, 5, 4, 0, 3, 96, 128, 224, 160,
  64, 4, 5, 5, 5, 0, 3, 224, 32, 112, 32, 32, 3, 5, 5, 4,
  0, 3, 96, 160, 224, 160, 192, 3, 5, 5, 4, 0, 3, 96, 160, 224,
  32, 192, 1, 3, 3, 2, 0, 4, 128, 0, 128
};

/*
  Fontname: -FreeType-Robot de Niro-Medium-R-Normal--16-160-72-72-P-39-ISO10646-1
  Copyright: Copyright BMoser 2008
  Capital A Height: 6, '1' Height: 5
  Calculated Max Values w= 6 h= 7 x= 0 y= 6 dx= 7 dy= 0 ascent=10 len= 7
  Font Bounding box     w=10 h=10 x=-1 y= 0
  Calculated Min Values           x=-1 y= 0 dx= 0 dy= 0
  Pure Font   ascent = 6 descent= 1
  X Font      ascent = 9 descent= 0
  Max Font    ascent =10 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_robot_de_niror[1041] U8G_FONT_SECTION("u8g_font_robot_de_niror") = {
  0, 10, 10, 255, 0, 6, 1, 97, 2, 193, 32, 127, 1, 10, 0, 9,
  0, 0, 0, 0, 2, 0, 0, 2, 5, 5, 3, 0, 3, 192, 128, 128,
  0, 128, 3, 2, 2, 4, 0, 6, 160, 160, 5, 5, 5, 6, 0, 3,
  80, 248, 80, 248, 80, 4, 7, 7, 5, 0, 2, 96, 224, 16, 96, 128,
  112, 96, 5, 5, 5, 6, 0, 3, 192, 208, 32, 88, 24, 4, 5, 5,
  5, 0, 3, 96, 160, 80, 160, 80, 1, 2, 2, 2, 0, 6, 128, 128,
  2, 7, 7, 3, 0, 2, 64, 128, 128, 128, 128, 128, 64, 2, 7, 7,
  3, 0, 2, 128, 64, 64, 64, 64, 64, 128, 3, 3, 3, 4, 0, 6,
  160, 64, 160, 3, 3, 3, 4, 0, 4, 64, 224, 64, 2, 2, 2, 3,
  0, 2, 64, 128, 3, 1, 1, 4, 0, 5, 224, 1, 1, 1, 2, 0,
  3, 128, 3, 5, 5, 4, 0, 3, 32, 32, 64, 128, 128, 3, 5, 5,
  4, 0, 3, 64, 160, 160, 160, 64, 3, 5, 5, 4, 0, 3, 192, 64,
  64, 64, 224, 3, 5, 5, 4, 0, 3, 192, 32, 96, 128, 224, 3, 5,
  5, 4, 0, 3, 192, 32, 224, 32, 224, 3, 5, 5, 4, 0, 3, 160,
  160, 224, 32, 32, 3, 5, 5, 4, 0, 3, 96, 128, 224, 32, 224, 3,
  5, 5, 4, 0, 3, 96, 128, 224, 160, 64, 4, 5, 5, 5, 0, 3,
  224, 32, 112, 32, 32, 3, 5, 5, 4, 0, 3, 96, 160, 224, 160, 192,
  3, 5, 5, 4, 0, 3, 96, 160, 224, 32, 192, 1, 3, 3, 2, 0,
  4, 128, 0, 128, 2, 4, 4, 3, 0, 3, 64, 0, 64, 128, 2, 3,
  3, 3, 0, 4, 64, 128, 64, 3, 3, 3, 4, 0, 4, 224, 0, 224,
  2, 3, 3, 3, 0, 4, 128, 64, 128, 3, 5, 5, 4, 0, 3, 224,
  32, 64, 0, 64, 5, 7, 7, 6, 0, 2, 120, 136, 184, 168, 184, 128,
  120, 4, 6, 6, 4, 255, 2, 48, 80, 112, 80, 80, 128, 4, 5, 5,
  5, 0, 3, 224, 80, 96, 80, 224, 3, 5, 5, 4, 0, 3, 96, 128,
  128, 160, 64, 4, 5, 5, 5, 0, 3, 224, 80, 80, 80, 32, 3, 5,
  5, 4, 0, 3, 96, 128, 192, 128, 224, 4, 6, 6, 5, 0, 2, 176,
  64, 96, 64, 64, 128, 4, 5, 5, 5, 0, 3, 96, 128, 176, 160, 96,
  4, 6, 6, 4, 255, 2, 80, 80, 112, 80, 80, 128, 1, 5, 5, 2,
  0, 3, 128, 128, 128, 128, 128, 3, 5, 5, 4, 0, 3, 64, 32, 32,
  32, 192, 5, 5, 5, 6, 0, 3, 208, 80, 96, 80, 72, 4, 5, 5,
  5, 0, 3, 192, 64, 64, 64, 176, 6, 5, 5, 6, 255, 3, 168, 84,
  84, 84, 68, 4, 5, 5, 5, 0, 3, 224, 80, 80, 80, 80, 3, 5,
  5, 4, 0, 3, 96, 160, 160, 160, 64, 4, 5, 5, 5, 0, 3, 176,
  80, 96, 64, 64, 4, 5, 5, 5, 0, 3, 64, 160, 160, 160, 112, 5,
  5, 5, 5, 255, 3, 176, 80, 96, 80, 72, 3, 5, 5, 4, 0, 3,
  96, 128, 224, 32, 192, 3, 5, 5, 4, 0, 3, 224, 64, 64, 64, 64,
  4, 5, 5, 5, 0, 3, 160, 160, 160, 160, 80, 3, 5, 5, 4, 0,
  3, 160, 160, 160, 160, 64, 6, 5, 5, 7, 0, 3, 172, 168, 168, 168,
  88, 4, 5, 5, 5, 0, 3, 160, 160, 64, 160, 176, 4, 7, 7, 4,
  255, 1, 208, 80, 80, 48, 16, 16, 32, 3, 5, 5, 4, 0, 3, 224,
  32, 64, 128, 224, 2, 7, 7, 3, 0, 2, 192, 128, 128, 128, 128, 128,
  192, 3, 5, 5, 4, 0, 3, 128, 128, 64, 32, 32, 2, 7, 7, 3,
  0, 2, 192, 64, 64, 64, 64, 64, 192, 3, 3, 3, 4, 0, 5, 64,
  160, 160, 4, 1, 1, 5, 0, 3, 240, 2, 2, 2, 3, 0, 6, 128,
  64, 4, 4, 4, 5, 0, 3, 96, 160, 160, 80, 4, 5, 5, 5, 0,
  3, 64, 96, 80, 80, 160, 3, 4, 4, 4, 0, 3, 96, 128, 160, 64,
  4, 6, 6, 5, 0, 3, 16, 32, 96, 160, 160, 208, 4, 4, 4, 5,
  0, 3, 96, 160, 208, 96, 4, 7, 7, 4, 255, 1, 48, 64, 96, 64,
  64, 64, 128, 4, 6, 6, 5, 0, 1, 80, 160, 160, 96, 32, 192, 3,
  7, 7, 4, 0, 3, 64, 128, 128, 192, 160, 160, 160, 1, 5, 5, 2,
  0, 3, 128, 0, 128, 128, 128, 3, 7, 7, 3, 255, 1, 32, 0, 32,
  32, 32, 32, 192, 4, 7, 7, 5, 0, 2, 128, 128, 160, 224, 160, 144,
  16, 4, 6, 6, 5, 0, 3, 32, 80, 96, 64, 64, 176, 6, 4, 4,
  7, 0, 3, 88, 168, 168, 164, 3, 4, 4, 4, 0, 3, 64, 160, 160,
  160, 3, 4, 4, 4, 0, 3, 96, 160, 160, 192, 4, 6, 6, 5, 0,
  1, 176, 80, 80, 96, 64, 128, 4, 6, 6, 5, 0, 1, 80, 160, 160,
  96, 32, 32, 4, 4, 4, 5, 0, 3, 160, 80, 64, 64, 3, 4, 4,
  4, 0, 3, 64, 160, 32, 192, 2, 6, 6, 3, 0, 3, 128, 128, 192,
  128, 128, 64, 4, 4, 4, 5, 0, 3, 160, 160, 160, 80, 3, 4, 4,
  4, 0, 3, 160, 160, 160, 64, 6, 4, 4, 7, 0, 3, 172, 168, 168,
  80, 3, 4, 4, 4, 0, 3, 160, 160, 64, 160, 3, 5, 5, 4, 0,
  2, 160, 160, 64, 32, 192, 4, 5, 5, 5, 0, 2, 224, 32, 64, 144,
  96, 3, 7, 7, 4, 0, 2, 96, 64, 64, 128, 64, 64, 96, 1, 7,
  7, 2, 0, 2, 128, 128, 128, 128, 128, 128, 128, 3, 7, 7, 4, 0,
  2, 192, 64, 64, 32, 64, 64, 192, 4, 2, 2, 5, 0, 5, 80, 160,
  255
};

/*
  Fontname: -FreeType-Teachers Pet Sans Serif Bold-Medium-R-Normal--8-80-72-72-P-61-ISO10646-1
  Copyright:  www.orgdot.com
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w=11 h=13 x= 1 y=10 dx=12 dy= 0 ascent=13 len=18
  Font Bounding box     w=11 h=17 x= 0 y=-4
  Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-4
  X Font      ascent = 9 descent=-4
  Max Font    ascent =13 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_tpssb[2656] U8G_FONT_SECTION("u8g_font_tpssb") = {
  0, 11, 17, 0, 252, 9, 1, 205, 3, 159, 32, 255, 252, 13, 252, 9,
  252, 0, 0, 0, 4, 0, 0, 2, 9, 9, 4, 1, 0, 192, 192, 192,
  192, 192, 192, 0, 192, 192, 5, 2, 2, 7, 1, 7, 216, 216, 5, 5,
  5, 7, 1, 0, 80, 248, 80, 248, 80, 7, 9, 9, 9, 1, 0, 124,
  146, 144, 124, 18, 18, 146, 146, 124, 8, 9, 9, 10, 1, 0, 198, 204,
  12, 24, 24, 24, 48, 51, 99, 9, 9, 18, 11, 1, 0, 124, 0, 198,
  0, 198, 0, 124, 0, 198, 0, 198, 0, 198, 0, 199, 128, 62, 0, 2,
  2, 2, 4, 1, 7, 192, 192, 5, 9, 9, 7, 1, 0, 24, 48, 96,
  96, 224, 96, 96, 48, 24, 5, 9, 9, 7, 1, 0, 192, 96, 48, 48,
  56, 48, 48, 96, 192, 5, 7, 7, 7, 1, 1, 32, 168, 112, 32, 112,
  168, 32, 6, 6, 6, 8, 1, 1, 48, 48, 252, 252, 48, 48, 3, 2,
  2, 5, 1, 255, 96, 192, 5, 2, 2, 7, 1, 3, 248, 248, 2, 1,
  1, 4, 1, 0, 192, 6, 9, 9, 8, 1, 0, 12, 24, 24, 48, 48,
  48, 96, 96, 192, 6, 9, 9, 7, 0, 0, 120, 204, 204, 204, 204, 204,
  204, 204, 120, 6, 9, 9, 7, 0, 0, 48, 112, 240, 48, 48, 48, 48,
  48, 252, 6, 9, 9, 7, 0, 0, 120, 204, 204, 12, 24, 48, 96, 192,
  252, 6, 9, 9, 7, 0, 0, 120, 204, 12, 56, 12, 12, 12, 204, 120,
  6, 9, 9, 7, 0, 0, 12, 204, 204, 252, 12, 12, 12, 12, 12, 6,
  9, 9, 7, 0, 0, 252, 192, 192, 248, 12, 12, 12, 204, 120, 6, 9,
  9, 7, 0, 0, 120, 204, 192, 248, 204, 204, 204, 204, 120, 6, 9, 9,
  7, 0, 0, 252, 12, 24, 48, 96, 96, 96, 96, 96, 6, 9, 9, 7,
  0, 0, 120, 204, 204, 120, 204, 204, 204, 204, 120, 6, 9, 9, 7, 0,
  0, 120, 204, 204, 204, 124, 12, 12, 204, 120, 2, 4, 4, 4, 1, 0,
  192, 0, 0, 192, 3, 5, 5, 5, 1, 255, 96, 0, 0, 96, 192, 6,
  9, 9, 8, 1, 0, 12, 24, 48, 96, 192, 96, 48, 24, 12, 6, 5,
  5, 8, 1, 1, 252, 252, 0, 252, 252, 6, 9, 9, 8, 1, 0, 192,
  96, 48, 24, 12, 24, 48, 96, 192, 6, 9, 9, 8, 1, 0, 120, 204,
  12, 24, 48, 48, 0, 48, 48, 10, 8, 16, 12, 1, 0, 63, 0, 64,
  128, 204, 192, 210, 192, 210, 128, 205, 0, 64, 64, 63, 128, 6, 9, 9,
  7, 0, 0, 120, 204, 204, 252, 204, 204, 204, 204, 204, 6, 9, 9, 7,
  0, 0, 248, 204, 204, 248, 204, 204, 204, 204, 248, 6, 9, 9, 7, 0,
  0, 120, 204, 192, 192, 192, 192, 192, 204, 120, 6, 9, 9, 7, 0, 0,
  248, 204, 204, 204, 204, 204, 204, 204, 248, 6, 9, 9, 7, 0, 0, 252,
  192, 192, 248, 192, 192, 192, 192, 252, 6, 9, 9, 7, 0, 0, 252, 192,
  192, 248, 192, 192, 192, 192, 192, 6, 9, 9, 7, 0, 0, 120, 204, 192,
  220, 204, 204, 204, 204, 120, 6, 9, 9, 7, 0, 0, 204, 204, 204, 252,
  204, 204, 204, 204, 204, 2, 9, 9, 3, 0, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 6, 9, 9, 7, 0, 0, 12, 12, 12, 12, 12, 12,
  12, 204, 120, 6, 9, 9, 7, 0, 0, 204, 204, 216, 240, 224, 240, 216,
  204, 204, 6, 9, 9, 7, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  252, 7, 9, 9, 9, 1, 0, 130, 238, 254, 146, 130, 130, 130, 130, 130,
  6, 9, 9, 7, 0, 0, 204, 236, 252, 220, 204, 204, 204, 204, 204, 6,
  9, 9, 7, 0, 0, 120, 204, 204, 204, 204, 204, 204, 204, 120, 6, 9,
  9, 7, 0, 0, 248, 204, 204, 248, 192, 192, 192, 192, 192, 7, 9, 9,
  8, 0, 0, 124, 130, 130, 130, 130, 146, 146, 146, 124, 6, 9, 9, 7,
  0, 0, 248, 204, 204, 248, 204, 204, 204, 204, 204, 6, 9, 9, 7, 0,
  0, 120, 204, 192, 120, 12, 12, 204, 204, 120, 6, 9, 9, 7, 0, 0,
  252, 48, 48, 48, 48, 48, 48, 48, 48, 6, 9, 9, 7, 0, 0, 204,
  204, 204, 204, 204, 204, 204, 204, 120, 7, 9, 9, 8, 0, 0, 198, 198,
  198, 108, 108, 108, 56, 56, 56, 9, 9, 18, 11, 1, 0, 128, 128, 128,
  128, 128, 128, 105, 128, 105, 128, 105, 128, 127, 0, 127, 0, 127, 0, 6,
  9, 9, 7, 0, 0, 204, 204, 120, 48, 48, 120, 204, 204, 204, 6, 9,
  9, 7, 0, 0, 204, 204, 120, 48, 48, 48, 48, 48, 48, 6, 9, 9,
  7, 0, 0, 252, 12, 12, 24, 48, 96, 192, 192, 252, 4, 9, 9, 6,
  1, 0, 240, 192, 192, 192, 192, 192, 192, 192, 240, 6, 7, 7, 8, 1,
  0, 192, 96, 96, 48, 24, 24, 12, 4, 9, 9, 6, 1, 0, 240, 48,
  48, 48, 48, 48, 48, 48, 240, 4, 2, 2, 6, 1, 10, 96, 144, 6,
  2, 2, 8, 1, 0, 252, 252, 2, 2, 2, 4, 1, 10, 64, 128, 6,
  6, 6, 7, 0, 0, 120, 204, 204, 204, 204, 124, 6, 9, 9, 7, 0,
  0, 192, 192, 192, 248, 204, 204, 204, 204, 120, 6, 6, 6, 7, 0, 0,
  120, 204, 192, 192, 204, 120, 6, 9, 9, 7, 0, 0, 12, 12, 12, 124,
  204, 204, 204, 204, 124, 6, 6, 6, 7, 0, 0, 120, 204, 252, 192, 204,
  120, 6, 9, 9, 7, 0, 0, 56, 108, 96, 240, 96, 96, 96, 96, 96,
  6, 10, 10, 7, 0, 252, 120, 204, 204, 204, 204, 124, 12, 12, 204, 120,
  6, 9, 9, 7, 0, 0, 192, 192, 192, 248, 236, 204, 204, 204, 204, 2,
  9, 9, 3, 0, 0, 192, 192, 0, 192, 192, 192, 192, 192, 192, 3, 13,
  13, 4, 0, 252, 96, 96, 0, 96, 96, 96, 96, 96, 96, 96, 96, 96,
  192, 6, 9, 9, 7, 0, 0, 192, 192, 192, 216, 240, 224, 240, 216, 204,
  2, 9, 9, 3, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 7,
  6, 6, 9, 1, 0, 254, 146, 146, 146, 146, 146, 6, 6, 6, 7, 0,
  0, 248, 236, 204, 204, 204, 204, 6, 6, 6, 7, 0, 0, 120, 204, 204,
  204, 204, 120, 6, 10, 10, 7, 0, 252, 120, 204, 204, 204, 204, 248, 192,
  192, 192, 192, 7, 10, 10, 7, 0, 252, 124, 204, 204, 204, 204, 124, 12,
  30, 12, 12, 5, 6, 6, 6, 0, 0, 248, 240, 192, 192, 192, 192, 6,
  6, 6, 7, 0, 0, 120, 224, 120, 12, 204, 120, 5, 9, 9, 6, 0,
  0, 96, 96, 96, 248, 96, 96, 96, 96, 96, 6, 6, 6, 7, 0, 0,
  204, 204, 204, 204, 204, 120, 6, 6, 6, 7, 0, 0, 204, 204, 120, 120,
  48, 48, 9, 6, 12, 10, 0, 0, 128, 128, 128, 128, 107, 0, 107, 0,
  127, 0, 127, 0, 6, 6, 6, 7, 0, 0, 204, 120, 48, 48, 120, 204,
  6, 10, 10, 7, 0, 252, 204, 204, 204, 204, 204, 124, 12, 12, 204, 120,
  6, 6, 6, 7, 0, 0, 124, 204, 24, 48, 96, 252, 6, 9, 9, 8,
  1, 0, 12, 24, 48, 48, 240, 48, 48, 24, 12, 2, 9, 9, 4, 1,
  0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 6, 9, 9, 8, 1, 0,
  192, 96, 48, 48, 28, 48, 48, 96, 192, 5, 2, 2, 6, 0, 10, 232,
  184, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 2, 9, 9, 3, 0, 0, 192, 192, 0, 192, 192, 192, 192,
  192, 192, 5, 7, 7, 7, 1, 0, 32, 112, 168, 160, 168, 112, 32, 6,
  9, 9, 7, 0, 0, 192, 192, 248, 192, 192, 192, 204, 204, 252, 5, 5,
  5, 7, 1, 1, 136, 112, 80, 112, 136, 6, 9, 9, 8, 1, 0, 204,
  204, 120, 48, 48, 120, 48, 120, 48, 2, 9, 9, 4, 1, 0, 192, 192,
  192, 0, 0, 0, 192, 192, 192, 8, 10, 10, 10, 1, 0, 124, 192, 126,
  195, 126, 3, 3, 3, 195, 62, 5, 1, 1, 7, 1, 3, 216, 9, 7,
  14, 11, 1, 0, 62, 0, 65, 0, 221, 128, 209, 128, 221, 128, 65, 0,
  62, 0, 7, 8, 8, 9, 1, 0, 120, 204, 204, 204, 204, 126, 0, 254,
  7, 3, 3, 9, 1, 2, 102, 204, 102, 5, 3, 3, 7, 1, 1, 248,
  248, 24, 255, 9, 7, 14, 11, 1, 0, 62, 0, 65, 0, 221, 128, 209,
  128, 209, 128, 65, 0, 62, 0, 5, 1, 1, 6, 0, 6, 248, 3, 3,
  3, 5, 1, 2, 224, 160, 224, 5, 7, 7, 7, 1, 0, 32, 32, 248,
  32, 32, 0, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 7, 3, 3,
  9, 1, 2, 204, 102, 204, 255, 255, 255, 255, 6, 12, 12, 7, 0, 0,
  96, 48, 0, 120, 204, 204, 252, 204, 204, 204, 204, 204, 6, 12, 12, 7,
  0, 0, 24, 48, 0, 120, 204, 204, 252, 204, 204, 204, 204, 204, 6, 12,
  12, 7, 0, 0, 48, 72, 0, 120, 204, 204, 252, 204, 204, 204, 204, 204,
  6, 12, 12, 7, 0, 0, 232, 184, 0, 120, 204, 204, 252, 204, 204, 204,
  204, 204, 6, 11, 11, 7, 0, 0, 72, 0, 120, 204, 204, 252, 204, 204,
  204, 204, 204, 6, 13, 13, 7, 0, 0, 48, 72, 48, 0, 120, 204, 204,
  252, 204, 204, 204, 204, 204, 11, 9, 18, 12, 0, 0, 127, 224, 206, 0,
  206, 0, 255, 192, 206, 0, 206, 0, 206, 0, 206, 0, 207, 224, 6, 11,
  11, 7, 0, 254, 120, 204, 192, 192, 192, 192, 192, 204, 120, 48, 96, 6,
  12, 12, 7, 0, 0, 96, 48, 0, 252, 192, 192, 248, 192, 192, 192, 192,
  252, 6, 12, 12, 7, 0, 0, 24, 48, 0, 252, 192, 192, 248, 192, 192,
  192, 192, 252, 6, 12, 12, 7, 0, 0, 48, 72, 0, 252, 192, 192, 248,
  192, 192, 192, 192, 252, 6, 11, 11, 7, 0, 0, 204, 0, 252, 192, 192,
  248, 192, 192, 192, 192, 252, 3, 12, 12, 4, 0, 0, 192, 96, 0, 96,
  96, 96, 96, 96, 96, 96, 96, 96, 3, 12, 12, 4, 0, 0, 96, 192,
  0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 4, 12, 12, 5, 0, 0,
  96, 144, 0, 96, 96, 96, 96, 96, 96, 96, 96, 96, 6, 11, 11, 7,
  0, 0, 204, 0, 48, 48, 48, 48, 48, 48, 48, 48, 48, 6, 9, 9,
  7, 0, 0, 248, 204, 204, 236, 204, 204, 204, 204, 248, 6, 12, 12, 7,
  0, 0, 232, 184, 0, 204, 236, 252, 220, 204, 204, 204, 204, 204, 6, 12,
  12, 7, 0, 0, 96, 48, 0, 120, 204, 204, 204, 204, 204, 204, 204, 120,
  6, 12, 12, 7, 0, 0, 24, 48, 0, 120, 204, 204, 204, 204, 204, 204,
  204, 120, 6, 12, 12, 7, 0, 0, 48, 72, 0, 120, 204, 204, 204, 204,
  204, 204, 204, 120, 6, 12, 12, 7, 0, 0, 232, 184, 0, 120, 204, 204,
  204, 204, 204, 204, 204, 120, 6, 11, 11, 7, 0, 0, 204, 0, 120, 204,
  204, 204, 204, 204, 204, 204, 120, 3, 3, 3, 6, 1, 2, 160, 64, 160,
  6, 9, 9, 7, 0, 0, 120, 204, 220, 220, 236, 236, 236, 204, 120, 6,
  12, 12, 7, 0, 0, 96, 48, 0, 204, 204, 204, 204, 204, 204, 204, 204,
  120, 6, 12, 12, 7, 0, 0, 24, 48, 0, 204, 204, 204, 204, 204, 204,
  204, 204, 120, 6, 12, 12, 7, 0, 0, 48, 72, 0, 204, 204, 204, 204,
  204, 204, 204, 204, 120, 6, 11, 11, 7, 0, 0, 204, 0, 204, 204, 204,
  204, 204, 204, 204, 204, 120, 6, 12, 12, 7, 0, 0, 24, 48, 0, 204,
  204, 120, 48, 48, 48, 48, 48, 48, 7, 9, 9, 8, 0, 0, 192, 192,
  252, 198, 252, 192, 192, 192, 192, 7, 11, 11, 8, 0, 254, 252, 198, 220,
  198, 198, 198, 220, 192, 192, 192, 192, 6, 9, 9, 7, 0, 0, 96, 48,
  0, 120, 204, 204, 204, 204, 124, 6, 9, 9, 7, 0, 0, 24, 48, 0,
  120, 204, 204, 204, 204, 124, 6, 9, 9, 7, 0, 0, 48, 72, 0, 120,
  204, 204, 204, 204, 124, 6, 9, 9, 7, 0, 0, 232, 184, 0, 120, 204,
  204, 204, 204, 124, 6, 8, 8, 7, 0, 0, 204, 0, 120, 204, 204, 204,
  204, 124, 6, 10, 10, 7, 0, 0, 48, 72, 48, 0, 120, 204, 204, 204,
  204, 124, 9, 6, 12, 11, 1, 0, 127, 128, 136, 128, 143, 128, 136, 0,
  136, 128, 127, 128, 6, 8, 8, 7, 0, 254, 120, 204, 192, 192, 204, 120,
  48, 96, 6, 9, 9, 7, 0, 0, 96, 48, 0, 120, 204, 252, 192, 204,
  120, 6, 9, 9, 7, 0, 0, 24, 48, 0, 120, 204, 252, 192, 204, 120,
  6, 9, 9, 7, 0, 0, 48, 72, 0, 120, 204, 252, 192, 204, 120, 6,
  8, 8, 7, 0, 0, 204, 0, 120, 204, 252, 192, 204, 120, 3, 12, 12,
  4, 0, 0, 192, 96, 0, 96, 96, 96, 96, 96, 96, 96, 96, 96, 3,
  12, 12, 4, 0, 0, 96, 192, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 4, 12, 12, 5, 0, 0, 96, 144, 0, 96, 96, 96, 96, 96, 96,
  96, 96, 96, 6, 11, 11, 7, 0, 0, 204, 0, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 6, 9, 9, 7, 0, 0, 12, 60, 12, 124, 204, 204,
  204, 204, 124, 6, 9, 9, 7, 0, 0, 232, 184, 0, 248, 236, 204, 204,
  204, 204, 6, 9, 9, 7, 0, 0, 96, 48, 0, 120, 204, 204, 204, 204,
  120, 6, 9, 9, 7, 0, 0, 24, 48, 0, 120, 204, 204, 204, 204, 120,
  6, 9, 9, 7, 0, 0, 48, 72, 0, 120, 204, 204, 204, 204, 120, 6,
  9, 9, 7, 0, 0, 232, 184, 0, 120, 204, 204, 204, 204, 120, 6, 8,
  8, 7, 0, 0, 204, 0, 120, 204, 204, 204, 204, 120, 6, 6, 6, 7,
  0, 1, 48, 0, 252, 252, 0, 48, 6, 6, 6, 7, 0, 0, 120, 220,
  220, 236, 236, 120, 6, 9, 9, 7, 0, 0, 96, 48, 0, 204, 204, 204,
  204, 204, 120, 6, 9, 9, 7, 0, 0, 24, 48, 0, 204, 204, 204, 204,
  204, 120, 6, 9, 9, 7, 0, 0, 48, 72, 0, 204, 204, 204, 204, 204,
  120, 6, 8, 8, 7, 0, 0, 204, 0, 204, 204, 204, 204, 204, 120, 6,
  13, 13, 7, 0, 252, 24, 48, 0, 204, 204, 204, 204, 204, 124, 12, 12,
  204, 120, 6, 6, 6, 7, 0, 0, 192, 248, 204, 248, 192, 192, 6, 12,
  12, 7, 0, 252, 204, 0, 204, 204, 204, 204, 204, 124, 12, 12, 204, 120
};

/*
  Fontname: -FreeType-Teachers Pet Sans Serif Bold-Medium-R-Normal--8-80-72-72-P-61-ISO10646-1
  Copyright:  www.orgdot.com
  Capital A Height: 0, '1' Height: 9
  Calculated Max Values w= 6 h= 9 x= 1 y= 3 dx= 8 dy= 0 ascent= 9 len= 9
  Font Bounding box     w=11 h=17 x= 0 y=-4
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 9 descent= 0
  X Font      ascent = 9 descent= 0
  Max Font    ascent = 9 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_tpssbn[240] U8G_FONT_SECTION("u8g_font_tpssbn") = {
  0, 11, 17, 0, 252, 9, 0, 0, 0, 0, 42, 58, 0, 9, 255, 9,
  0, 5, 7, 7, 7, 1, 1, 32, 168, 112, 32, 112, 168, 32, 6, 6,
  6, 8, 1, 1, 48, 48, 252, 252, 48, 48, 3, 2, 2, 5, 1, 255,
  96, 192, 5, 2, 2, 7, 1, 3, 248, 248, 2, 1, 1, 4, 1, 0,
  192, 6, 9, 9, 8, 1, 0, 12, 24, 24, 48, 48, 48, 96, 96, 192,
  6, 9, 9, 7, 0, 0, 120, 204, 204, 204, 204, 204, 204, 204, 120, 6,
  9, 9, 7, 0, 0, 48, 112, 240, 48, 48, 48, 48, 48, 252, 6, 9,
  9, 7, 0, 0, 120, 204, 204, 12, 24, 48, 96, 192, 252, 6, 9, 9,
  7, 0, 0, 120, 204, 12, 56, 12, 12, 12, 204, 120, 6, 9, 9, 7,
  0, 0, 12, 204, 204, 252, 12, 12, 12, 12, 12, 6, 9, 9, 7, 0,
  0, 252, 192, 192, 248, 12, 12, 12, 204, 120, 6, 9, 9, 7, 0, 0,
  120, 204, 192, 248, 204, 204, 204, 204, 120, 6, 9, 9, 7, 0, 0, 252,
  12, 24, 48, 96, 96, 96, 96, 96, 6, 9, 9, 7, 0, 0, 120, 204,
  204, 120, 204, 204, 204, 204, 120, 6, 9, 9, 7, 0, 0, 120, 204, 204,
  204, 124, 12, 12, 204, 120, 2, 4, 4, 4, 1, 0, 192, 0, 0, 192
};

/*
  Fontname: -FreeType-Teachers Pet Sans Serif Bold-Medium-R-Normal--8-80-72-72-P-61-ISO10646-1
  Copyright:  www.orgdot.com
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w=10 h=13 x= 1 y=10 dx=12 dy= 0 ascent=12 len=18
  Font Bounding box     w=11 h=17 x= 0 y=-4
  Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-4
  X Font      ascent = 9 descent=-4
  Max Font    ascent =12 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_tpssbr[1346] U8G_FONT_SECTION("u8g_font_tpssbr") = {
  0, 11, 17, 0, 252, 9, 1, 205, 3, 159, 32, 127, 252, 12, 252, 9,
  252, 0, 0, 0, 4, 0, 0, 2, 9, 9, 4, 1, 0, 192, 192, 192,
  192, 192, 192, 0, 192, 192, 5, 2, 2, 7, 1, 7, 216, 216, 5, 5,
  5, 7, 1, 0, 80, 248, 80, 248, 80, 7, 9, 9, 9, 1, 0, 124,
  146, 144, 124, 18, 18, 146, 146, 124, 8, 9, 9, 10, 1, 0, 198, 204,
  12, 24, 24, 24, 48, 51, 99, 9, 9, 18, 11, 1, 0, 124, 0, 198,
  0, 198, 0, 124, 0, 198, 0, 198, 0, 198, 0, 199, 128, 62, 0, 2,
  2, 2, 4, 1, 7, 192, 192, 5, 9, 9, 7, 1, 0, 24, 48, 96,
  96, 224, 96, 96, 48, 24, 5, 9, 9, 7, 1, 0, 192, 96, 48, 48,
  56, 48, 48, 96, 192, 5, 7, 7, 7, 1, 1, 32, 168, 112, 32, 112,
  168, 32, 6, 6, 6, 8, 1, 1, 48, 48, 252, 252, 48, 48, 3, 2,
  2, 5, 1, 255, 96, 192, 5, 2, 2, 7, 1, 3, 248, 248, 2, 1,
  1, 4, 1, 0, 192, 6, 9, 9, 8, 1, 0, 12, 24, 24, 48, 48,
  48, 96, 96, 192, 6, 9, 9, 7, 0, 0, 120, 204, 204, 204, 204, 204,
  204, 204, 120, 6, 9, 9, 7, 0, 0, 48, 112, 240, 48, 48, 48, 48,
  48, 252, 6, 9, 9, 7, 0, 0, 120, 204, 204, 12, 24, 48, 96, 192,
  252, 6, 9, 9, 7, 0, 0, 120, 204, 12, 56, 12, 12, 12, 204, 120,
  6, 9, 9, 7, 0, 0, 12, 204, 204, 252, 12, 12, 12, 12, 12, 6,
  9, 9, 7, 0, 0, 252, 192, 192, 248, 12, 12, 12, 204, 120, 6, 9,
  9, 7, 0, 0, 120, 204, 192, 248, 204, 204, 204, 204, 120, 6, 9, 9,
  7, 0, 0, 252, 12, 24, 48, 96, 96, 96, 96, 96, 6, 9, 9, 7,
  0, 0, 120, 204, 204, 120, 204, 204, 204, 204, 120, 6, 9, 9, 7, 0,
  0, 120, 204, 204, 204, 124, 12, 12, 204, 120, 2, 4, 4, 4, 1, 0,
  192, 0, 0, 192, 3, 5, 5, 5, 1, 255, 96, 0, 0, 96, 192, 6,
  9, 9, 8, 1, 0, 12, 24, 48, 96, 192, 96, 48, 24, 12, 6, 5,
  5, 8, 1, 1, 252, 252, 0, 252, 252, 6, 9, 9, 8, 1, 0, 192,
  96, 48, 24, 12, 24, 48, 96, 192, 6, 9, 9, 8, 1, 0, 120, 204,
  12, 24, 48, 48, 0, 48, 48, 10, 8, 16, 12, 1, 0, 63, 0, 64,
  128, 204, 192, 210, 192, 210, 128, 205, 0, 64, 64, 63, 128, 6, 9, 9,
  7, 0, 0, 120, 204, 204, 252, 204, 204, 204, 204, 204, 6, 9, 9, 7,
  0, 0, 248, 204, 204, 248, 204, 204, 204, 204, 248, 6, 9, 9, 7, 0,
  0, 120, 204, 192, 192, 192, 192, 192, 204, 120, 6, 9, 9, 7, 0, 0,
  248, 204, 204, 204, 204, 204, 204, 204, 248, 6, 9, 9, 7, 0, 0, 252,
  192, 192, 248, 192, 192, 192, 192, 252, 6, 9, 9, 7, 0, 0, 252, 192,
  192, 248, 192, 192, 192, 192, 192, 6, 9, 9, 7, 0, 0, 120, 204, 192,
  220, 204, 204, 204, 204, 120, 6, 9, 9, 7, 0, 0, 204, 204, 204, 252,
  204, 204, 204, 204, 204, 2, 9, 9, 3, 0, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 6, 9, 9, 7, 0, 0, 12, 12, 12, 12, 12, 12,
  12, 204, 120, 6, 9, 9, 7, 0, 0, 204, 204, 216, 240, 224, 240, 216,
  204, 204, 6, 9, 9, 7, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  252, 7, 9, 9, 9, 1, 0, 130, 238, 254, 146, 130, 130, 130, 130, 130,
  6, 9, 9, 7, 0, 0, 204, 236, 252, 220, 204, 204, 204, 204, 204, 6,
  9, 9, 7, 0, 0, 120, 204, 204, 204, 204, 204, 204, 204, 120, 6, 9,
  9, 7, 0, 0, 248, 204, 204, 248, 192, 192, 192, 192, 192, 7, 9, 9,
  8, 0, 0, 124, 130, 130, 130, 130, 146, 146, 146, 124, 6, 9, 9, 7,
  0, 0, 248, 204, 204, 248, 204, 204, 204, 204, 204, 6, 9, 9, 7, 0,
  0, 120, 204, 192, 120, 12, 12, 204, 204, 120, 6, 9, 9, 7, 0, 0,
  252, 48, 48, 48, 48, 48, 48, 48, 48, 6, 9, 9, 7, 0, 0, 204,
  204, 204, 204, 204, 204, 204, 204, 120, 7, 9, 9, 8, 0, 0, 198, 198,
  198, 108, 108, 108, 56, 56, 56, 9, 9, 18, 11, 1, 0, 128, 128, 128,
  128, 128, 128, 105, 128, 105, 128, 105, 128, 127, 0, 127, 0, 127, 0, 6,
  9, 9, 7, 0, 0, 204, 204, 120, 48, 48, 120, 204, 204, 204, 6, 9,
  9, 7, 0, 0, 204, 204, 120, 48, 48, 48, 48, 48, 48, 6, 9, 9,
  7, 0, 0, 252, 12, 12, 24, 48, 96, 192, 192, 252, 4, 9, 9, 6,
  1, 0, 240, 192, 192, 192, 192, 192, 192, 192, 240, 6, 7, 7, 8, 1,
  0, 192, 96, 96, 48, 24, 24, 12, 4, 9, 9, 6, 1, 0, 240, 48,
  48, 48, 48, 48, 48, 48, 240, 4, 2, 2, 6, 1, 10, 96, 144, 6,
  2, 2, 8, 1, 0, 252, 252, 2, 2, 2, 4, 1, 10, 64, 128, 6,
  6, 6, 7, 0, 0, 120, 204, 204, 204, 204, 124, 6, 9, 9, 7, 0,
  0, 192, 192, 192, 248, 204, 204, 204, 204, 120, 6, 6, 6, 7, 0, 0,
  120, 204, 192, 192, 204, 120, 6, 9, 9, 7, 0, 0, 12, 12, 12, 124,
  204, 204, 204, 204, 124, 6, 6, 6, 7, 0, 0, 120, 204, 252, 192, 204,
  120, 6, 9, 9, 7, 0, 0, 56, 108, 96, 240, 96, 96, 96, 96, 96,
  6, 10, 10, 7, 0, 252, 120, 204, 204, 204, 204, 124, 12, 12, 204, 120,
  6, 9, 9, 7, 0, 0, 192, 192, 192, 248, 236, 204, 204, 204, 204, 2,
  9, 9, 3, 0, 0, 192, 192, 0, 192, 192, 192, 192, 192, 192, 3, 13,
  13, 4, 0, 252, 96, 96, 0, 96, 96, 96, 96, 96, 96, 96, 96, 96,
  192, 6, 9, 9, 7, 0, 0, 192, 192, 192, 216, 240, 224, 240, 216, 204,
  2, 9, 9, 3, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 7,
  6, 6, 9, 1, 0, 254, 146, 146, 146, 146, 146, 6, 6, 6, 7, 0,
  0, 248, 236, 204, 204, 204, 204, 6, 6, 6, 7, 0, 0, 120, 204, 204,
  204, 204, 120, 6, 10, 10, 7, 0, 252, 120, 204, 204, 204, 204, 248, 192,
  192, 192, 192, 7, 10, 10, 7, 0, 252, 124, 204, 204, 204, 204, 124, 12,
  30, 12, 12, 5, 6, 6, 6, 0, 0, 248, 240, 192, 192, 192, 192, 6,
  6, 6, 7, 0, 0, 120, 224, 120, 12, 204, 120, 5, 9, 9, 6, 0,
  0, 96, 96, 96, 248, 96, 96, 96, 96, 96, 6, 6, 6, 7, 0, 0,
  204, 204, 204, 204, 204, 120, 6, 6, 6, 7, 0, 0, 204, 204, 120, 120,
  48, 48, 9, 6, 12, 10, 0, 0, 128, 128, 128, 128, 107, 0, 107, 0,
  127, 0, 127, 0, 6, 6, 6, 7, 0, 0, 204, 120, 48, 48, 120, 204,
  6, 10, 10, 7, 0, 252, 204, 204, 204, 204, 204, 124, 12, 12, 204, 120,
  6, 6, 6, 7, 0, 0, 124, 204, 24, 48, 96, 252, 6, 9, 9, 8,
  1, 0, 12, 24, 48, 48, 240, 48, 48, 24, 12, 2, 9, 9, 4, 1,
  0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 6, 9, 9, 8, 1, 0,
  192, 96, 48, 48, 28, 48, 48, 96, 192, 5, 2, 2, 6, 0, 10, 232,
  184, 255
};

/*
  Fontname: -FreeType-Teachers Pet Sans Serif-Medium-R-Normal--8-80-72-72-P-18-ISO10646-1
  Copyright:  www.orgdot.com
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 9 h=13 x= 1 y=10 dx=11 dy= 0 ascent=13 len=18
  Font Bounding box     w=11 h=17 x=-1 y=-4
  Calculated Min Values           x=-1 y=-4 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-4
  X Font      ascent = 9 descent=-4
  Max Font    ascent =13 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_tpss[2605] U8G_FONT_SECTION("u8g_font_tpss") = {
  0, 11, 17, 255, 252, 9, 1, 192, 3, 136, 32, 255, 252, 13, 252, 9,
  252, 0, 0, 0, 4, 0, 0, 1, 9, 9, 3, 1, 0, 128, 128, 128,
  128, 128, 128, 0, 128, 128, 3, 2, 2, 5, 1, 7, 160, 160, 5, 5,
  5, 7, 1, 0, 80, 248, 80, 248, 80, 5, 9, 9, 7, 1, 0, 112,
  168, 160, 112, 40, 40, 168, 168, 112, 5, 9, 9, 7, 1, 0, 136, 144,
  16, 32, 32, 32, 64, 72, 136, 7, 9, 9, 9, 1, 0, 112, 136, 136,
  112, 136, 136, 136, 138, 116, 1, 2, 2, 3, 1, 7, 128, 128, 5, 9,
  9, 7, 1, 0, 24, 32, 64, 64, 128, 64, 64, 32, 24, 5, 9, 9,
  7, 1, 0, 192, 32, 16, 16, 8, 16, 16, 32, 192, 5, 7, 7, 7,
  1, 1, 32, 168, 112, 32, 112, 168, 32, 5, 5, 5, 7, 1, 1, 32,
  32, 248, 32, 32, 2, 2, 2, 4, 1, 255, 64, 128, 5, 1, 1, 7,
  1, 3, 248, 1, 1, 1, 3, 1, 0, 128, 5, 9, 9, 7, 1, 0,
  8, 16, 16, 32, 32, 32, 64, 64, 128, 5, 9, 9, 6, 0, 0, 112,
  136, 136, 136, 136, 136, 136, 136, 112, 5, 9, 9, 6, 0, 0, 32, 96,
  160, 32, 32, 32, 32, 32, 248, 5, 9, 9, 6, 0, 0, 112, 136, 136,
  8, 16, 32, 64, 128, 248, 5, 9, 9, 6, 0, 0, 112, 136, 8, 48,
  8, 8, 8, 136, 112, 5, 9, 9, 6, 0, 0, 8, 136, 136, 248, 8,
  8, 8, 8, 8, 5, 9, 9, 6, 0, 0, 248, 128, 128, 248, 8, 8,
  8, 136, 112, 5, 9, 9, 6, 0, 0, 112, 136, 128, 240, 136, 136, 136,
  136, 112, 5, 9, 9, 6, 0, 0, 248, 8, 16, 32, 64, 64, 64, 64,
  64, 5, 9, 9, 6, 0, 0, 112, 136, 136, 112, 136, 136, 136, 136, 112,
  5, 9, 9, 6, 0, 0, 112, 136, 136, 136, 120, 8, 8, 136, 112, 1,
  4, 4, 3, 1, 0, 128, 0, 0, 128, 2, 5, 5, 4, 1, 255, 64,
  0, 0, 64, 128, 5, 9, 9, 7, 1, 0, 8, 16, 32, 64, 128, 64,
  32, 16, 8, 5, 3, 3, 7, 1, 2, 248, 0, 248, 5, 9, 9, 7,
  1, 0, 128, 64, 32, 16, 8, 16, 32, 64, 128, 5, 9, 9, 7, 1,
  0, 112, 136, 8, 16, 32, 32, 0, 32, 32, 9, 8, 16, 11, 1, 0,
  126, 0, 129, 0, 153, 0, 165, 0, 165, 0, 154, 0, 128, 128, 127, 0,
  5, 9, 9, 6, 0, 0, 112, 136, 136, 248, 136, 136, 136, 136, 136, 5,
  9, 9, 6, 0, 0, 240, 136, 136, 240, 136, 136, 136, 136, 240, 5, 9,
  9, 6, 0, 0, 112, 136, 128, 128, 128, 128, 128, 136, 112, 5, 9, 9,
  6, 0, 0, 240, 136, 136, 136, 136, 136, 136, 136, 240, 5, 9, 9, 6,
  0, 0, 248, 128, 128, 240, 128, 128, 128, 128, 248, 5, 9, 9, 6, 0,
  0, 248, 128, 128, 240, 128, 128, 128, 128, 128, 5, 9, 9, 6, 0, 0,
  112, 136, 128, 184, 136, 136, 136, 136, 112, 5, 9, 9, 6, 0, 0, 136,
  136, 136, 248, 136, 136, 136, 136, 136, 1, 9, 9, 2, 0, 0, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 5, 9, 9, 6, 0, 0, 8, 8, 8,
  8, 8, 8, 8, 136, 112, 5, 9, 9, 6, 0, 0, 136, 136, 144, 160,
  192, 160, 144, 136, 136, 5, 9, 9, 6, 0, 0, 128, 128, 128, 128, 128,
  128, 128, 128, 248, 7, 9, 9, 8, 0, 0, 130, 198, 170, 146, 130, 130,
  130, 130, 130, 5, 9, 9, 6, 0, 0, 136, 200, 168, 152, 136, 136, 136,
  136, 136, 5, 9, 9, 6, 0, 0, 112, 136, 136, 136, 136, 136, 136, 136,
  112, 5, 9, 9, 6, 0, 0, 240, 136, 136, 240, 128, 128, 128, 128, 128,
  5, 9, 9, 6, 0, 0, 112, 136, 136, 136, 136, 168, 168, 168, 112, 5,
  9, 9, 6, 0, 0, 240, 136, 136, 240, 136, 136, 136, 136, 136, 5, 9,
  9, 6, 0, 0, 112, 136, 128, 112, 8, 8, 136, 136, 112, 5, 9, 9,
  6, 0, 0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 5, 9, 9, 6,
  0, 0, 136, 136, 136, 136, 136, 136, 136, 136, 112, 5, 9, 9, 6, 0,
  0, 136, 136, 136, 80, 80, 80, 80, 32, 32, 7, 9, 9, 8, 0, 0,
  130, 130, 130, 84, 84, 84, 40, 40, 40, 5, 9, 9, 6, 0, 0, 136,
  136, 80, 32, 32, 80, 136, 136, 136, 5, 9, 9, 6, 0, 0, 136, 136,
  80, 32, 32, 32, 32, 32, 32, 5, 9, 9, 6, 0, 0, 248, 8, 8,
  16, 32, 64, 128, 128, 248, 3, 9, 9, 5, 1, 0, 224, 128, 128, 128,
  128, 128, 128, 128, 224, 5, 7, 7, 7, 1, 0, 128, 64, 64, 32, 16,
  16, 8, 3, 9, 9, 5, 1, 0, 224, 32, 32, 32, 32, 32, 32, 32,
  224, 3, 2, 2, 5, 1, 10, 64, 160, 6, 1, 1, 8, 1, 0, 252,
  2, 2, 2, 4, 1, 10, 64, 128, 5, 6, 6, 6, 0, 0, 112, 136,
  136, 136, 136, 120, 5, 9, 9, 6, 0, 0, 128, 128, 128, 240, 136, 136,
  136, 136, 112, 5, 6, 6, 6, 0, 0, 112, 136, 128, 128, 136, 112, 5,
  9, 9, 6, 0, 0, 8, 8, 8, 120, 136, 136, 136, 136, 120, 5, 6,
  6, 6, 0, 0, 112, 136, 248, 128, 136, 112, 5, 9, 9, 6, 0, 0,
  48, 72, 64, 224, 64, 64, 64, 64, 64, 5, 10, 10, 6, 0, 252, 112,
  136, 136, 136, 136, 120, 8, 8, 136, 112, 5, 9, 9, 6, 0, 0, 128,
  128, 128, 176, 200, 136, 136, 136, 136, 1, 9, 9, 2, 0, 0, 128, 128,
  0, 128, 128, 128, 128, 128, 128, 2, 13, 13, 3, 0, 252, 64, 64, 0,
  64, 64, 64, 64, 64, 64, 64, 64, 64, 128, 5, 9, 9, 6, 0, 0,
  128, 128, 128, 144, 160, 192, 160, 144, 136, 1, 9, 9, 2, 0, 0, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 7, 6, 6, 8, 0, 0, 182, 218,
  146, 146, 146, 146, 5, 6, 6, 6, 0, 0, 176, 200, 136, 136, 136, 136,
  5, 6, 6, 6, 0, 0, 112, 136, 136, 136, 136, 112, 5, 10, 10, 6,
  0, 252, 112, 136, 136, 136, 136, 240, 128, 128, 128, 128, 6, 10, 10, 7,
  0, 252, 120, 136, 136, 136, 136, 120, 8, 28, 8, 8, 4, 6, 6, 5,
  0, 0, 176, 192, 128, 128, 128, 128, 5, 6, 6, 6, 0, 0, 112, 128,
  112, 8, 136, 112, 4, 9, 9, 5, 0, 0, 64, 64, 64, 240, 64, 64,
  64, 64, 64, 5, 6, 6, 6, 0, 0, 136, 136, 136, 136, 136, 112, 5,
  6, 6, 6, 0, 0, 136, 136, 80, 80, 32, 32, 7, 6, 6, 8, 0,
  0, 130, 130, 84, 84, 40, 40, 5, 6, 6, 6, 0, 0, 136, 80, 32,
  32, 80, 136, 5, 10, 10, 6, 0, 252, 136, 136, 136, 136, 136, 120, 8,
  8, 136, 112, 5, 6, 6, 6, 0, 0, 120, 136, 16, 32, 64, 248, 6,
  9, 9, 8, 1, 0, 12, 16, 32, 32, 192, 32, 32, 16, 12, 1, 9,
  9, 3, 1, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 6, 9, 9,
  8, 1, 0, 192, 32, 16, 16, 12, 16, 16, 32, 192, 5, 2, 2, 6,
  0, 10, 232, 184, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 1, 9, 9, 2, 0, 0, 128, 128, 0, 128,
  128, 128, 128, 128, 128, 5, 7, 7, 7, 1, 0, 32, 112, 168, 160, 168,
  112, 32, 5, 9, 9, 7, 1, 0, 128, 128, 240, 128, 128, 128, 136, 136,
  248, 5, 5, 5, 7, 1, 1, 136, 112, 80, 112, 136, 5, 9, 9, 7,
  1, 0, 136, 136, 80, 32, 32, 248, 32, 248, 32, 1, 9, 9, 3, 1,
  0, 128, 128, 128, 0, 0, 0, 128, 128, 128, 6, 10, 10, 8, 1, 0,
  120, 128, 120, 132, 120, 4, 4, 4, 132, 120, 5, 1, 1, 7, 1, 3,
  136, 7, 7, 7, 9, 1, 0, 124, 130, 186, 162, 186, 130, 124, 6, 8,
  8, 8, 1, 0, 112, 136, 136, 136, 136, 116, 0, 252, 5, 3, 3, 7,
  1, 2, 72, 144, 72, 5, 2, 2, 7, 1, 2, 248, 8, 0, 0, 0,
  8, 0, 0, 7, 7, 7, 9, 1, 0, 124, 130, 186, 162, 162, 130, 124,
  5, 1, 1, 6, 0, 6, 248, 3, 3, 3, 5, 1, 2, 64, 160, 64,
  5, 7, 7, 7, 1, 0, 32, 32, 248, 32, 32, 0, 248, 255, 255, 255,
  0, 0, 0, 8, 0, 0, 255, 0, 0, 0, 8, 0, 0, 255, 255, 255,
  5, 3, 3, 7, 1, 2, 144, 72, 144, 255, 255, 255, 255, 5, 12, 12,
  6, 0, 0, 64, 32, 0, 112, 136, 136, 248, 136, 136, 136, 136, 136, 5,
  12, 12, 6, 0, 0, 16, 32, 0, 112, 136, 136, 248, 136, 136, 136, 136,
  136, 5, 12, 12, 6, 0, 0, 32, 80, 0, 112, 136, 136, 248, 136, 136,
  136, 136, 136, 5, 12, 12, 6, 0, 0, 232, 184, 0, 112, 136, 136, 248,
  136, 136, 136, 136, 136, 5, 11, 11, 6, 0, 0, 80, 0, 112, 136, 136,
  248, 136, 136, 136, 136, 136, 5, 13, 13, 6, 0, 0, 32, 80, 32, 0,
  112, 136, 136, 248, 136, 136, 136, 136, 136, 9, 9, 18, 10, 0, 0, 127,
  128, 136, 0, 136, 0, 255, 0, 136, 0, 136, 0, 136, 0, 136, 0, 143,
  128, 5, 9, 9, 6, 0, 254, 112, 136, 128, 128, 128, 136, 112, 32, 96,
  5, 12, 12, 6, 0, 0, 64, 32, 0, 248, 128, 128, 240, 128, 128, 128,
  128, 248, 5, 12, 12, 6, 0, 0, 16, 32, 0, 248, 128, 128, 240, 128,
  128, 128, 128, 248, 5, 12, 12, 6, 0, 0, 32, 80, 0, 248, 128, 128,
  240, 128, 128, 128, 128, 248, 5, 11, 11, 6, 0, 0, 80, 0, 248, 128,
  128, 240, 128, 128, 128, 128, 248, 2, 12, 12, 2, 0, 0, 128, 64, 0,
  64, 64, 64, 64, 64, 64, 64, 64, 64, 2, 12, 12, 2, 0, 0, 64,
  128, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 3, 12, 12, 2, 255,
  0, 64, 160, 0, 64, 64, 64, 64, 64, 64, 64, 64, 64, 3, 11, 11,
  2, 255, 0, 160, 0, 64, 64, 64, 64, 64, 64, 64, 64, 64, 5, 9,
  9, 6, 0, 0, 240, 136, 136, 232, 136, 136, 136, 136, 240, 5, 12, 12,
  6, 0, 0, 232, 184, 0, 136, 136, 136, 200, 168, 152, 136, 136, 136, 5,
  12, 12, 6, 0, 0, 64, 32, 0, 112, 136, 136, 136, 136, 136, 136, 136,
  112, 5, 12, 12, 6, 0, 0, 16, 32, 0, 112, 136, 136, 136, 136, 136,
  136, 136, 112, 5, 12, 12, 6, 0, 0, 32, 80, 0, 112, 136, 136, 136,
  136, 136, 136, 136, 112, 5, 12, 12, 6, 0, 0, 232, 184, 0, 112, 136,
  136, 136, 136, 136, 136, 136, 112, 5, 11, 11, 6, 0, 0, 80, 0, 112,
  136, 136, 136, 136, 136, 136, 136, 112, 3, 3, 3, 6, 1, 2, 160, 64,
  160, 7, 9, 9, 8, 0, 0, 58, 68, 76, 84, 84, 84, 100, 68, 184,
  5, 12, 12, 6, 0, 0, 64, 32, 0, 136, 136, 136, 136, 136, 136, 136,
  136, 112, 5, 12, 12, 6, 0, 0, 16, 32, 0, 136, 136, 136, 136, 136,
  136, 136, 136, 112, 5, 12, 12, 6, 0, 0, 32, 80, 0, 136, 136, 136,
  136, 136, 136, 136, 136, 112, 5, 11, 11, 6, 0, 0, 80, 0, 136, 136,
  136, 136, 136, 136, 136, 136, 112, 5, 12, 12, 6, 0, 0, 16, 32, 0,
  136, 136, 80, 32, 32, 32, 32, 32, 32, 5, 9, 9, 6, 0, 0, 128,
  128, 240, 136, 240, 128, 128, 128, 128, 5, 11, 11, 6, 0, 254, 240, 136,
  176, 136, 136, 136, 176, 128, 128, 128, 128, 5, 9, 9, 6, 0, 0, 64,
  32, 0, 112, 136, 136, 136, 136, 120, 5, 9, 9, 6, 0, 0, 16, 32,
  0, 112, 136, 136, 136, 136, 120, 5, 9, 9, 6, 0, 0, 32, 80, 0,
  112, 136, 136, 136, 136, 120, 5, 9, 9, 6, 0, 0, 232, 184, 0, 112,
  136, 136, 136, 136, 120, 5, 8, 8, 6, 0, 0, 80, 0, 112, 136, 136,
  136, 136, 120, 5, 10, 10, 6, 0, 0, 32, 80, 32, 0, 112, 136, 136,
  136, 136, 120, 9, 6, 12, 10, 0, 0, 119, 0, 136, 128, 143, 128, 136,
  0, 136, 128, 119, 0, 5, 8, 8, 6, 0, 254, 112, 136, 128, 128, 136,
  112, 32, 64, 5, 6, 6, 6, 0, 0, 112, 136, 248, 128, 136, 112, 5,
  6, 6, 6, 0, 0, 112, 136, 248, 128, 136, 112, 5, 6, 6, 6, 0,
  0, 112, 136, 248, 128, 136, 112, 5, 6, 6, 6, 0, 0, 112, 136, 248,
  128, 136, 112, 2, 10, 10, 3, 0, 0, 128, 64, 0, 0, 64, 64, 64,
  64, 64, 64, 2, 10, 10, 3, 0, 0, 64, 128, 0, 0, 128, 128, 128,
  128, 128, 128, 3, 10, 10, 4, 0, 0, 64, 160, 0, 0, 64, 64, 64,
  64, 64, 64, 3, 9, 9, 4, 0, 0, 160, 0, 0, 64, 64, 64, 64,
  64, 64, 5, 9, 9, 6, 0, 0, 8, 56, 8, 120, 136, 136, 136, 136,
  120, 5, 9, 9, 6, 0, 0, 232, 184, 0, 176, 200, 136, 136, 136, 136,
  5, 9, 9, 6, 0, 0, 64, 32, 0, 112, 136, 136, 136, 136, 112, 5,
  9, 9, 6, 0, 0, 16, 32, 0, 112, 136, 136, 136, 136, 112, 5, 9,
  9, 6, 0, 0, 32, 80, 0, 112, 136, 136, 136, 136, 112, 5, 9, 9,
  6, 0, 0, 232, 184, 0, 112, 136, 136, 136, 136, 112, 5, 8, 8, 6,
  0, 0, 80, 0, 112, 136, 136, 136, 136, 112, 5, 5, 5, 6, 0, 1,
  32, 0, 248, 0, 32, 5, 6, 6, 6, 0, 0, 112, 152, 168, 168, 200,
  112, 5, 9, 9, 6, 0, 0, 64, 32, 0, 136, 136, 136, 136, 136, 112,
  5, 9, 9, 6, 0, 0, 16, 32, 0, 136, 136, 136, 136, 136, 112, 5,
  9, 9, 6, 0, 0, 32, 80, 0, 136, 136, 136, 136, 136, 112, 5, 8,
  8, 6, 0, 0, 80, 0, 136, 136, 136, 136, 136, 112, 5, 13, 13, 6,
  0, 252, 16, 32, 0, 136, 136, 136, 136, 136, 120, 8, 8, 136, 112, 5,
  6, 6, 5, 0, 0, 128, 240, 136, 240, 128, 128, 5, 12, 12, 6, 0,
  252, 80, 0, 136, 136, 136, 136, 136, 120, 8, 8, 136, 112
};

/*
  Fontname: -FreeType-Teachers Pet Sans Serif-Medium-R-Normal--8-80-72-72-P-18-ISO10646-1
  Copyright:  www.orgdot.com
  Capital A Height: 0, '1' Height: 9
  Calculated Max Values w= 5 h= 9 x= 1 y= 3 dx= 7 dy= 0 ascent= 9 len= 9
  Font Bounding box     w=11 h=17 x=-1 y=-4
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 9 descent= 0
  X Font      ascent = 9 descent= 0
  Max Font    ascent = 9 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_tpssn[238] U8G_FONT_SECTION("u8g_font_tpssn") = {
  0, 11, 17, 255, 252, 9, 0, 0, 0, 0, 42, 58, 0, 9, 255, 9,
  0, 5, 7, 7, 7, 1, 1, 32, 168, 112, 32, 112, 168, 32, 5, 5,
  5, 7, 1, 1, 32, 32, 248, 32, 32, 2, 2, 2, 4, 1, 255, 64,
  128, 5, 1, 1, 7, 1, 3, 248, 1, 1, 1, 3, 1, 0, 128, 5,
  9, 9, 7, 1, 0, 8, 16, 16, 32, 32, 32, 64, 64, 128, 5, 9,
  9, 6, 0, 0, 112, 136, 136, 136, 136, 136, 136, 136, 112, 5, 9, 9,
  6, 0, 0, 32, 96, 160, 32, 32, 32, 32, 32, 248, 5, 9, 9, 6,
  0, 0, 112, 136, 136, 8, 16, 32, 64, 128, 248, 5, 9, 9, 6, 0,
  0, 112, 136, 8, 48, 8, 8, 8, 136, 112, 5, 9, 9, 6, 0, 0,
  8, 136, 136, 248, 8, 8, 8, 8, 8, 5, 9, 9, 6, 0, 0, 248,
  128, 128, 248, 8, 8, 8, 136, 112, 5, 9, 9, 6, 0, 0, 112, 136,
  128, 240, 136, 136, 136, 136, 112, 5, 9, 9, 6, 0, 0, 248, 8, 16,
  32, 64, 64, 64, 64, 64, 5, 9, 9, 6, 0, 0, 112, 136, 136, 112,
  136, 136, 136, 136, 112, 5, 9, 9, 6, 0, 0, 112, 136, 136, 136, 120,
  8, 8, 136, 112, 1, 4, 4, 3, 1, 0, 128, 0, 0, 128
};

/*
  Fontname: -FreeType-Teachers Pet Sans Serif-Medium-R-Normal--8-80-72-72-P-18-ISO10646-1
  Copyright:  www.orgdot.com
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 9 h=13 x= 1 y=10 dx=11 dy= 0 ascent=12 len=16
  Font Bounding box     w=11 h=17 x=-1 y=-4
  Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-4
  X Font      ascent = 9 descent=-4
  Max Font    ascent =12 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_tpssr[1317] U8G_FONT_SECTION("u8g_font_tpssr") = {
  0, 11, 17, 255, 252, 9, 1, 192, 3, 136, 32, 127, 252, 12, 252, 9,
  252, 0, 0, 0, 4, 0, 0, 1, 9, 9, 3, 1, 0, 128, 128, 128,
  128, 128, 128, 0, 128, 128, 3, 2, 2, 5, 1, 7, 160, 160, 5, 5,
  5, 7, 1, 0, 80, 248, 80, 248, 80, 5, 9, 9, 7, 1, 0, 112,
  168, 160, 112, 40, 40, 168, 168, 112, 5, 9, 9, 7, 1, 0, 136, 144,
  16, 32, 32, 32, 64, 72, 136, 7, 9, 9, 9, 1, 0, 112, 136, 136,
  112, 136, 136, 136, 138, 116, 1, 2, 2, 3, 1, 7, 128, 128, 5, 9,
  9, 7, 1, 0, 24, 32, 64, 64, 128, 64, 64, 32, 24, 5, 9, 9,
  7, 1, 0, 192, 32, 16, 16, 8, 16, 16, 32, 192, 5, 7, 7, 7,
  1, 1, 32, 168, 112, 32, 112, 168, 32, 5, 5, 5, 7, 1, 1, 32,
  32, 248, 32, 32, 2, 2, 2, 4, 1, 255, 64, 128, 5, 1, 1, 7,
  1, 3, 248, 1, 1, 1, 3, 1, 0, 128, 5, 9, 9, 7, 1, 0,
  8, 16, 16, 32, 32, 32, 64, 64, 128, 5, 9, 9, 6, 0, 0, 112,
  136, 136, 136, 136, 136, 136, 136, 112, 5, 9, 9, 6, 0, 0, 32, 96,
  160, 32, 32, 32, 32, 32, 248, 5, 9, 9, 6, 0, 0, 112, 136, 136,
  8, 16, 32, 64, 128, 248, 5, 9, 9, 6, 0, 0, 112, 136, 8, 48,
  8, 8, 8, 136, 112, 5, 9, 9, 6, 0, 0, 8, 136, 136, 248, 8,
  8, 8, 8, 8, 5, 9, 9, 6, 0, 0, 248, 128, 128, 248, 8, 8,
  8, 136, 112, 5, 9, 9, 6, 0, 0, 112, 136, 128, 240, 136, 136, 136,
  136, 112, 5, 9, 9, 6, 0, 0, 248, 8, 16, 32, 64, 64, 64, 64,
  64, 5, 9, 9, 6, 0, 0, 112, 136, 136, 112, 136, 136, 136, 136, 112,
  5, 9, 9, 6, 0, 0, 112, 136, 136, 136, 120, 8, 8, 136, 112, 1,
  4, 4, 3, 1, 0, 128, 0, 0, 128, 2, 5, 5, 4, 1, 255, 64,
  0, 0, 64, 128, 5, 9, 9, 7, 1, 0, 8, 16, 32, 64, 128, 64,
  32, 16, 8, 5, 3, 3, 7, 1, 2, 248, 0, 248, 5, 9, 9, 7,
  1, 0, 128, 64, 32, 16, 8, 16, 32, 64, 128, 5, 9, 9, 7, 1,
  0, 112, 136, 8, 16, 32, 32, 0, 32, 32, 9, 8, 16, 11, 1, 0,
  126, 0, 129, 0, 153, 0, 165, 0, 165, 0, 154, 0, 128, 128, 127, 0,
  5, 9, 9, 6, 0, 0, 112, 136, 136, 248, 136, 136, 136, 136, 136, 5,
  9, 9, 6, 0, 0, 240, 136, 136, 240, 136, 136, 136, 136, 240, 5, 9,
  9, 6, 0, 0, 112, 136, 128, 128, 128, 128, 128, 136, 112, 5, 9, 9,
  6, 0, 0, 240, 136, 136, 136, 136, 136, 136, 136, 240, 5, 9, 9, 6,
  0, 0, 248, 128, 128, 240, 128, 128, 128, 128, 248, 5, 9, 9, 6, 0,
  0, 248, 128, 128, 240, 128, 128, 128, 128, 128, 5, 9, 9, 6, 0, 0,
  112, 136, 128, 184, 136, 136, 136, 136, 112, 5, 9, 9, 6, 0, 0, 136,
  136, 136, 248, 136, 136, 136, 136, 136, 1, 9, 9, 2, 0, 0, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 5, 9, 9, 6, 0, 0, 8, 8, 8,
  8, 8, 8, 8, 136, 112, 5, 9, 9, 6, 0, 0, 136, 136, 144, 160,
  192, 160, 144, 136, 136, 5, 9, 9, 6, 0, 0, 128, 128, 128, 128, 128,
  128, 128, 128, 248, 7, 9, 9, 8, 0, 0, 130, 198, 170, 146, 130, 130,
  130, 130, 130, 5, 9, 9, 6, 0, 0, 136, 200, 168, 152, 136, 136, 136,
  136, 136, 5, 9, 9, 6, 0, 0, 112, 136, 136, 136, 136, 136, 136, 136,
  112, 5, 9, 9, 6, 0, 0, 240, 136, 136, 240, 128, 128, 128, 128, 128,
  5, 9, 9, 6, 0, 0, 112, 136, 136, 136, 136, 168, 168, 168, 112, 5,
  9, 9, 6, 0, 0, 240, 136, 136, 240, 136, 136, 136, 136, 136, 5, 9,
  9, 6, 0, 0, 112, 136, 128, 112, 8, 8, 136, 136, 112, 5, 9, 9,
  6, 0, 0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 5, 9, 9, 6,
  0, 0, 136, 136, 136, 136, 136, 136, 136, 136, 112, 5, 9, 9, 6, 0,
  0, 136, 136, 136, 80, 80, 80, 80, 32, 32, 7, 9, 9, 8, 0, 0,
  130, 130, 130, 84, 84, 84, 40, 40, 40, 5, 9, 9, 6, 0, 0, 136,
  136, 80, 32, 32, 80, 136, 136, 136, 5, 9, 9, 6, 0, 0, 136, 136,
  80, 32, 32, 32, 32, 32, 32, 5, 9, 9, 6, 0, 0, 248, 8, 8,
  16, 32, 64, 128, 128, 248, 3, 9, 9, 5, 1, 0, 224, 128, 128, 128,
  128, 128, 128, 128, 224, 5, 7, 7, 7, 1, 0, 128, 64, 64, 32, 16,
  16, 8, 3, 9, 9, 5, 1, 0, 224, 32, 32, 32, 32, 32, 32, 32,
  224, 3, 2, 2, 5, 1, 10, 64, 160, 6, 1, 1, 8, 1, 0, 252,
  2, 2, 2, 4, 1, 10, 64, 128, 5, 6, 6, 6, 0, 0, 112, 136,
  136, 136, 136, 120, 5, 9, 9, 6, 0, 0, 128, 128, 128, 240, 136, 136,
  136, 136, 112, 5, 6, 6, 6, 0, 0, 112, 136, 128, 128, 136, 112, 5,
  9, 9, 6, 0, 0, 8, 8, 8, 120, 136, 136, 136, 136, 120, 5, 6,
  6, 6, 0, 0, 112, 136, 248, 128, 136, 112, 5, 9, 9, 6, 0, 0,
  48, 72, 64, 224, 64, 64, 64, 64, 64, 5, 10, 10, 6, 0, 252, 112,
  136, 136, 136, 136, 120, 8, 8, 136, 112, 5, 9, 9, 6, 0, 0, 128,
  128, 128, 176, 200, 136, 136, 136, 136, 1, 9, 9, 2, 0, 0, 128, 128,
  0, 128, 128, 128, 128, 128, 128, 2, 13, 13, 3, 0, 252, 64, 64, 0,
  64, 64, 64, 64, 64, 64, 64, 64, 64, 128, 5, 9, 9, 6, 0, 0,
  128, 128, 128, 144, 160, 192, 160, 144, 136, 1, 9, 9, 2, 0, 0, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 7, 6, 6, 8, 0, 0, 182, 218,
  146, 146, 146, 146, 5, 6, 6, 6, 0, 0, 176, 200, 136, 136, 136, 136,
  5, 6, 6, 6, 0, 0, 112, 136, 136, 136, 136, 112, 5, 10, 10, 6,
  0, 252, 112, 136, 136, 136, 136, 240, 128, 128, 128, 128, 6, 10, 10, 7,
  0, 252, 120, 136, 136, 136, 136, 120, 8, 28, 8, 8, 4, 6, 6, 5,
  0, 0, 176, 192, 128, 128, 128, 128, 5, 6, 6, 6, 0, 0, 112, 128,
  112, 8, 136, 112, 4, 9, 9, 5, 0, 0, 64, 64, 64, 240, 64, 64,
  64, 64, 64, 5, 6, 6, 6, 0, 0, 136, 136, 136, 136, 136, 112, 5,
  6, 6, 6, 0, 0, 136, 136, 80, 80, 32, 32, 7, 6, 6, 8, 0,
  0, 130, 130, 84, 84, 40, 40, 5, 6, 6, 6, 0, 0, 136, 80, 32,
  32, 80, 136, 5, 10, 10, 6, 0, 252, 136, 136, 136, 136, 136, 120, 8,
  8, 136, 112, 5, 6, 6, 6, 0, 0, 120, 136, 16, 32, 64, 248, 6,
  9, 9, 8, 1, 0, 12, 16, 32, 32, 192, 32, 32, 16, 12, 1, 9,
  9, 3, 1, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 6, 9, 9,
  8, 1, 0, 192, 32, 16, 16, 12, 16, 16, 32, 192, 5, 2, 2, 6,
  0, 10, 232, 184, 255
};

/*
  Fontname: -FreeType-Trixel Square-Medium-R-Normal--8-80-72-72-P-33-ISO10646-1
  Copyright: Copyright julischka 2008
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 5 h= 7 x= 0 y= 3 dx= 6 dy= 0 ascent= 7 len= 7
  Font Bounding box     w= 5 h= 9 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-2
  X Font      ascent = 5 descent=-2
  Max Font    ascent = 7 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_trixel_square[1236] U8G_FONT_SECTION("u8g_font_trixel_square") = {
  0, 5, 9, 0, 254, 5, 1, 91, 2, 177, 32, 255, 254, 7, 254, 5,
  254, 0, 0, 0, 1, 0, 0, 1, 5, 5, 2, 0, 0, 128, 128, 128,
  0, 128, 3, 2, 2, 4, 0, 3, 160, 160, 5, 5, 5, 6, 0, 255,
  80, 248, 80, 248, 80, 3, 6, 6, 4, 0, 0, 64, 224, 192, 96, 224,
  64, 3, 5, 5, 4, 0, 0, 160, 32, 224, 128, 160, 5, 5, 5, 6,
  0, 0, 224, 160, 240, 160, 248, 1, 2, 2, 2, 0, 3, 128, 128, 2,
  5, 5, 3, 0, 0, 192, 128, 128, 128, 192, 2, 5, 5, 3, 0, 0,
  192, 64, 64, 64, 192, 3, 3, 3, 4, 0, 2, 160, 64, 160, 3, 3,
  3, 4, 0, 0, 64, 224, 64, 1, 2, 2, 2, 0, 255, 128, 128, 3,
  1, 1, 4, 0, 1, 224, 1, 1, 1, 2, 0, 0, 128, 3, 5, 5,
  4, 0, 0, 32, 96, 64, 192, 128, 3, 5, 5, 4, 0, 0, 224, 160,
  160, 160, 224, 2, 5, 5, 3, 0, 0, 64, 192, 64, 64, 64, 3, 5,
  5, 4, 0, 0, 224, 160, 96, 192, 224, 3, 5, 5, 4, 0, 0, 224,
  32, 96, 32, 224, 3, 5, 5, 4, 0, 0, 160, 160, 224, 32, 32, 3,
  5, 5, 4, 0, 0, 224, 128, 224, 32, 224, 3, 5, 5, 4, 0, 0,
  224, 128, 224, 160, 224, 3, 5, 5, 4, 0, 0, 224, 32, 32, 32, 32,
  3, 5, 5, 4, 0, 0, 224, 160, 224, 160, 224, 3, 5, 5, 4, 0,
  0, 224, 160, 224, 32, 224, 1, 3, 3, 2, 0, 0, 128, 0, 128, 1,
  4, 4, 2, 0, 255, 128, 0, 128, 128, 3, 3, 3, 4, 0, 0, 96,
  192, 96, 3, 3, 3, 4, 0, 0, 224, 0, 224, 3, 3, 3, 4, 0,
  0, 192, 96, 192, 3, 5, 5, 4, 0, 0, 224, 32, 96, 0, 64, 5,
  6, 6, 6, 0, 255, 248, 136, 168, 184, 128, 248, 3, 5, 5, 4, 0,
  0, 224, 160, 224, 160, 160, 3, 5, 5, 4, 0, 0, 224, 160, 224, 160,
  224, 3, 5, 5, 4, 0, 0, 224, 160, 128, 160, 224, 3, 5, 5, 4,
  0, 0, 224, 160, 160, 160, 224, 3, 5, 5, 4, 0, 0, 224, 128, 192,
  128, 224, 3, 5, 5, 4, 0, 0, 224, 128, 192, 128, 128, 3, 5, 5,
  4, 0, 0, 224, 128, 160, 160, 224, 3, 5, 5, 4, 0, 0, 160, 160,
  224, 160, 160, 1, 5, 5, 2, 0, 0, 128, 128, 128, 128, 128, 3, 5,
  5, 4, 0, 0, 224, 32, 32, 32, 224, 3, 5, 5, 4, 0, 0, 160,
  160, 192, 160, 160, 3, 5, 5, 4, 0, 0, 128, 128, 128, 128, 224, 5,
  5, 5, 6, 0, 0, 216, 216, 168, 168, 136, 4, 5, 5, 5, 0, 0,
  208, 208, 176, 176, 144, 3, 5, 5, 4, 0, 0, 224, 160, 160, 160, 224,
  3, 5, 5, 4, 0, 0, 224, 160, 224, 128, 128, 4, 5, 5, 5, 0,
  0, 224, 160, 160, 160, 240, 3, 5, 5, 4, 0, 0, 224, 160, 192, 160,
  160, 3, 5, 5, 4, 0, 0, 224, 128, 224, 32, 224, 3, 5, 5, 4,
  0, 0, 224, 64, 64, 64, 64, 3, 5, 5, 4, 0, 0, 160, 160, 160,
  160, 224, 3, 5, 5, 4, 0, 0, 160, 160, 160, 224, 64, 5, 5, 5,
  6, 0, 0, 136, 136, 168, 168, 248, 3, 5, 5, 4, 0, 0, 160, 224,
  64, 224, 160, 3, 5, 5, 4, 0, 0, 160, 160, 224, 64, 64, 3, 5,
  5, 4, 0, 0, 224, 32, 224, 128, 224, 3, 5, 5, 4, 0, 0, 224,
  128, 128, 128, 224, 3, 5, 5, 4, 0, 0, 128, 192, 64, 96, 32, 3,
  5, 5, 4, 0, 0, 224, 32, 32, 32, 224, 3, 2, 2, 4, 0, 3,
  224, 160, 3, 1, 1, 4, 0, 0, 224, 2, 2, 2, 3, 0, 3, 192,
  64, 4, 3, 3, 5, 0, 0, 224, 160, 240, 3, 5, 5, 4, 0, 0,
  128, 128, 224, 160, 224, 3, 3, 3, 4, 0, 0, 224, 128, 224, 3, 5,
  5, 4, 0, 0, 32, 32, 224, 160, 224, 3, 3, 3, 4, 0, 0, 224,
  192, 224, 2, 5, 5, 3, 0, 0, 192, 128, 192, 128, 128, 3, 5, 5,
  4, 0, 254, 224, 160, 224, 32, 224, 3, 5, 5, 4, 0, 0, 128, 128,
  224, 160, 160, 1, 5, 5, 2, 0, 0, 128, 0, 128, 128, 128, 2, 7,
  7, 3, 0, 254, 64, 0, 64, 64, 64, 64, 192, 3, 5, 5, 4, 0,
  0, 128, 128, 160, 224, 160, 2, 5, 5, 3, 0, 0, 128, 128, 128, 128,
  192, 5, 3, 3, 6, 0, 0, 248, 168, 168, 3, 3, 3, 4, 0, 0,
  224, 160, 160, 3, 3, 3, 4, 0, 0, 224, 160, 224, 3, 5, 5, 4,
  0, 254, 224, 160, 224, 128, 128, 3, 5, 5, 4, 0, 254, 224, 160, 224,
  32, 32, 2, 3, 3, 3, 0, 0, 192, 128, 128, 3, 3, 3, 4, 0,
  0, 96, 64, 192, 2, 5, 5, 3, 0, 0, 128, 192, 128, 128, 192, 3,
  3, 3, 4, 0, 0, 160, 160, 224, 3, 3, 3, 4, 0, 0, 160, 224,
  64, 5, 3, 3, 6, 0, 0, 168, 168, 248, 3, 3, 3, 4, 0, 0,
  160, 64, 160, 3, 5, 5, 4, 0, 254, 160, 160, 224, 32, 224, 3, 3,
  3, 4, 0, 0, 224, 64, 224, 3, 5, 5, 4, 0, 0, 96, 64, 192,
  64, 96, 1, 5, 5, 2, 0, 0, 128, 128, 128, 128, 128, 3, 5, 5,
  4, 0, 0, 192, 64, 96, 64, 192, 3, 3, 3, 4, 0, 1, 32, 224,
  128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 4, 5, 5, 5, 0, 0, 112, 64, 96, 64, 240,
  255, 255, 255, 3, 7, 7, 4, 0, 254, 224, 128, 224, 160, 224, 32, 224,
  255, 255, 255, 3, 2, 2, 4, 0, 1, 160, 160, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 3, 2, 2, 4, 0, 1,
  160, 160, 255, 255, 255, 255, 255, 255, 255, 255, 3, 7, 7, 4, 0, 0,
  160, 0, 224, 160, 224, 160, 160, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 3, 7, 7, 4, 0, 0, 160, 0,
  224, 160, 160, 160, 224, 255, 255, 255, 255, 255, 3, 7, 7, 4, 0, 0,
  160, 0, 160, 160, 160, 160, 224, 255, 255, 3, 7, 7, 4, 0, 254, 224,
  160, 224, 160, 224, 128, 128, 255, 255, 255, 255, 4, 5, 5, 5, 0, 0,
  160, 0, 224, 160, 240, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 3, 5, 5, 4, 0, 0, 160, 0, 224, 160,
  224, 255, 255, 255, 255, 255, 3, 5, 5, 4, 0, 0, 160, 0, 160, 160,
  224, 255, 255, 255
};

/*
  Fontname: -FreeType-Trixel Square-Medium-R-Normal--8-80-72-72-P-33-ISO10646-1
  Copyright: Copyright julischka 2008
  Capital A Height: 0, '1' Height: 5
  Calculated Max Values w= 3 h= 5 x= 0 y= 2 dx= 4 dy= 0 ascent= 5 len= 5
  Font Bounding box     w= 5 h= 9 x= 0 y=-2
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 5 descent= 0
  X Font      ascent = 5 descent= 0
  Max Font    ascent = 5 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_trixel_squaren[187] U8G_FONT_SECTION("u8g_font_trixel_squaren") = {
  0, 5, 9, 0, 254, 5, 0, 0, 0, 0, 42, 58, 0, 5, 255, 5,
  0, 3, 3, 3, 4, 0, 2, 160, 64, 160, 3, 3, 3, 4, 0, 0,
  64, 224, 64, 1, 2, 2, 2, 0, 255, 128, 128, 3, 1, 1, 4, 0,
  1, 224, 1, 1, 1, 2, 0, 0, 128, 3, 5, 5, 4, 0, 0, 32,
  96, 64, 192, 128, 3, 5, 5, 4, 0, 0, 224, 160, 160, 160, 224, 2,
  5, 5, 3, 0, 0, 64, 192, 64, 64, 64, 3, 5, 5, 4, 0, 0,
  224, 160, 96, 192, 224, 3, 5, 5, 4, 0, 0, 224, 32, 96, 32, 224,
  3, 5, 5, 4, 0, 0, 160, 160, 224, 32, 32, 3, 5, 5, 4, 0,
  0, 224, 128, 224, 32, 224, 3, 5, 5, 4, 0, 0, 224, 128, 224, 160,
  224, 3, 5, 5, 4, 0, 0, 224, 32, 32, 32, 32, 3, 5, 5, 4,
  0, 0, 224, 160, 224, 160, 224, 3, 5, 5, 4, 0, 0, 224, 160, 224,
  32, 224, 1, 3, 3, 2, 0, 0, 128, 0, 128
};

/*
  Fontname: -FreeType-Trixel Square-Medium-R-Normal--8-80-72-72-P-33-ISO10646-1
  Copyright: Copyright julischka 2008
  Capital A Height: 5, '1' Height: 5
  Calculated Max Values w= 5 h= 7 x= 0 y= 3 dx= 6 dy= 0 ascent= 6 len= 7
  Font Bounding box     w= 5 h= 9 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 5 descent=-2
  X Font      ascent = 5 descent=-2
  Max Font    ascent = 6 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_trixel_squarer[994] U8G_FONT_SECTION("u8g_font_trixel_squarer") = {
  0, 5, 9, 0, 254, 5, 1, 91, 2, 177, 32, 127, 254, 6, 254, 5,
  254, 0, 0, 0, 1, 0, 0, 1, 5, 5, 2, 0, 0, 128, 128, 128,
  0, 128, 3, 2, 2, 4, 0, 3, 160, 160, 5, 5, 5, 6, 0, 255,
  80, 248, 80, 248, 80, 3, 6, 6, 4, 0, 0, 64, 224, 192, 96, 224,
  64, 3, 5, 5, 4, 0, 0, 160, 32, 224, 128, 160, 5, 5, 5, 6,
  0, 0, 224, 160, 240, 160, 248, 1, 2, 2, 2, 0, 3, 128, 128, 2,
  5, 5, 3, 0, 0, 192, 128, 128, 128, 192, 2, 5, 5, 3, 0, 0,
  192, 64, 64, 64, 192, 3, 3, 3, 4, 0, 2, 160, 64, 160, 3, 3,
  3, 4, 0, 0, 64, 224, 64, 1, 2, 2, 2, 0, 255, 128, 128, 3,
  1, 1, 4, 0, 1, 224, 1, 1, 1, 2, 0, 0, 128, 3, 5, 5,
  4, 0, 0, 32, 96, 64, 192, 128, 3, 5, 5, 4, 0, 0, 224, 160,
  160, 160, 224, 2, 5, 5, 3, 0, 0, 64, 192, 64, 64, 64, 3, 5,
  5, 4, 0, 0, 224, 160, 96, 192, 224, 3, 5, 5, 4, 0, 0, 224,
  32, 96, 32, 224, 3, 5, 5, 4, 0, 0, 160, 160, 224, 32, 32, 3,
  5, 5, 4, 0, 0, 224, 128, 224, 32, 224, 3, 5, 5, 4, 0, 0,
  224, 128, 224, 160, 224, 3, 5, 5, 4, 0, 0, 224, 32, 32, 32, 32,
  3, 5, 5, 4, 0, 0, 224, 160, 224, 160, 224, 3, 5, 5, 4, 0,
  0, 224, 160, 224, 32, 224, 1, 3, 3, 2, 0, 0, 128, 0, 128, 1,
  4, 4, 2, 0, 255, 128, 0, 128, 128, 3, 3, 3, 4, 0, 0, 96,
  192, 96, 3, 3, 3, 4, 0, 0, 224, 0, 224, 3, 3, 3, 4, 0,
  0, 192, 96, 192, 3, 5, 5, 4, 0, 0, 224, 32, 96, 0, 64, 5,
  6, 6, 6, 0, 255, 248, 136, 168, 184, 128, 248, 3, 5, 5, 4, 0,
  0, 224, 160, 224, 160, 160, 3, 5, 5, 4, 0, 0, 224, 160, 224, 160,
  224, 3, 5, 5, 4, 0, 0, 224, 160, 128, 160, 224, 3, 5, 5, 4,
  0, 0, 224, 160, 160, 160, 224, 3, 5, 5, 4, 0, 0, 224, 128, 192,
  128, 224, 3, 5, 5, 4, 0, 0, 224, 128, 192, 128, 128, 3, 5, 5,
  4, 0, 0, 224, 128, 160, 160, 224, 3, 5, 5, 4, 0, 0, 160, 160,
  224, 160, 160, 1, 5, 5, 2, 0, 0, 128, 128, 128, 128, 128, 3, 5,
  5, 4, 0, 0, 224, 32, 32, 32, 224, 3, 5, 5, 4, 0, 0, 160,
  160, 192, 160, 160, 3, 5, 5, 4, 0, 0, 128, 128, 128, 128, 224, 5,
  5, 5, 6, 0, 0, 216, 216, 168, 168, 136, 4, 5, 5, 5, 0, 0,
  208, 208, 176, 176, 144, 3, 5, 5, 4, 0, 0, 224, 160, 160, 160, 224,
  3, 5, 5, 4, 0, 0, 224, 160, 224, 128, 128, 4, 5, 5, 5, 0,
  0, 224, 160, 160, 160, 240, 3, 5, 5, 4, 0, 0, 224, 160, 192, 160,
  160, 3, 5, 5, 4, 0, 0, 224, 128, 224, 32, 224, 3, 5, 5, 4,
  0, 0, 224, 64, 64, 64, 64, 3, 5, 5, 4, 0, 0, 160, 160, 160,
  160, 224, 3, 5, 5, 4, 0, 0, 160, 160, 160, 224, 64, 5, 5, 5,
  6, 0, 0, 136, 136, 168, 168, 248, 3, 5, 5, 4, 0, 0, 160, 224,
  64, 224, 160, 3, 5, 5, 4, 0, 0, 160, 160, 224, 64, 64, 3, 5,
  5, 4, 0, 0, 224, 32, 224, 128, 224, 3, 5, 5, 4, 0, 0, 224,
  128, 128, 128, 224, 3, 5, 5, 4, 0, 0, 128, 192, 64, 96, 32, 3,
  5, 5, 4, 0, 0, 224, 32, 32, 32, 224, 3, 2, 2, 4, 0, 3,
  224, 160, 3, 1, 1, 4, 0, 0, 224, 2, 2, 2, 3, 0, 3, 192,
  64, 4, 3, 3, 5, 0, 0, 224, 160, 240, 3, 5, 5, 4, 0, 0,
  128, 128, 224, 160, 224, 3, 3, 3, 4, 0, 0, 224, 128, 224, 3, 5,
  5, 4, 0, 0, 32, 32, 224, 160, 224, 3, 3, 3, 4, 0, 0, 224,
  192, 224, 2, 5, 5, 3, 0, 0, 192, 128, 192, 128, 128, 3, 5, 5,
  4, 0, 254, 224, 160, 224, 32, 224, 3, 5, 5, 4, 0, 0, 128, 128,
  224, 160, 160, 1, 5, 5, 2, 0, 0, 128, 0, 128, 128, 128, 2, 7,
  7, 3, 0, 254, 64, 0, 64, 64, 64, 64, 192, 3, 5, 5, 4, 0,
  0, 128, 128, 160, 224, 160, 2, 5, 5, 3, 0, 0, 128, 128, 128, 128,
  192, 5, 3, 3, 6, 0, 0, 248, 168, 168, 3, 3, 3, 4, 0, 0,
  224, 160, 160, 3, 3, 3, 4, 0, 0, 224, 160, 224, 3, 5, 5, 4,
  0, 254, 224, 160, 224, 128, 128, 3, 5, 5, 4, 0, 254, 224, 160, 224,
  32, 32, 2, 3, 3, 3, 0, 0, 192, 128, 128, 3, 3, 3, 4, 0,
  0, 96, 64, 192, 2, 5, 5, 3, 0, 0, 128, 192, 128, 128, 192, 3,
  3, 3, 4, 0, 0, 160, 160, 224, 3, 3, 3, 4, 0, 0, 160, 224,
  64, 5, 3, 3, 6, 0, 0, 168, 168, 248, 3, 3, 3, 4, 0, 0,
  160, 64, 160, 3, 5, 5, 4, 0, 254, 160, 160, 224, 32, 224, 3, 3,
  3, 4, 0, 0, 224, 64, 224, 3, 5, 5, 4, 0, 0, 96, 64, 192,
  64, 96, 1, 5, 5, 2, 0, 0, 128, 128, 128, 128, 128, 3, 5, 5,
  4, 0, 0, 192, 64, 96, 64, 192, 3, 3, 3, 4, 0, 1, 32, 224,
  128, 255
};

/*
  Fontname: u8glib_4
  Copyright: public domain
  Capital A Height: 4, '1' Height: 4
  Calculated Max Values w= 8 h= 7 x= 1 y= 4 dx= 9 dy= 0 ascent= 6 len= 7
  Font Bounding box     w= 9 h= 6 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 4 descent=-1
  X Font      ascent = 5 descent=-1
  Max Font    ascent = 6 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_u8glib_4[1660] U8G_FONT_SECTION("u8g_font_u8glib_4") = {
  1, 9, 6, 0, 255, 4, 0, 233, 1, 198, 32, 255, 255, 6, 255, 5,
  255, 2, 0, 32, 2, 20, 36, 128, 128, 0, 128, 5, 50, 66, 160, 160,
  1, 85, 101, 80, 248, 80, 248, 80, 1, 86, 102, 32, 120, 224, 56, 240,
  32, 2, 68, 84, 144, 32, 64, 144, 2, 69, 85, 64, 160, 64, 160, 240,
  5, 18, 34, 128, 128, 1, 38, 54, 64, 128, 128, 128, 128, 64, 1, 38,
  54, 128, 64, 64, 64, 64, 128, 3, 34, 50, 192, 192, 2, 51, 67, 64,
  224, 64, 1, 18, 34, 128, 128, 3, 49, 65, 224, 2, 17, 33, 128, 2,
  68, 84, 16, 32, 64, 128, 2, 52, 68, 224, 160, 160, 224, 2, 36, 52,
  64, 192, 64, 64, 2, 52, 68, 224, 32, 64, 224, 2, 52, 68, 224, 64,
  32, 224, 2, 52, 68, 128, 160, 224, 32, 2, 52, 68, 224, 192, 32, 224,
  2, 52, 68, 224, 128, 224, 224, 2, 52, 68, 224, 32, 64, 128, 2, 52,
  68, 224, 224, 160, 224, 2, 52, 68, 224, 224, 32, 224, 2, 19, 35, 128,
  0, 128, 1, 20, 36, 128, 0, 128, 128, 2, 35, 51, 64, 128, 64, 2,
  51, 67, 224, 0, 224, 2, 35, 51, 128, 64, 128, 2, 36, 52, 192, 64,
  0, 64, 2, 68, 84, 240, 176, 128, 240, 2, 68, 84, 96, 144, 240, 144,
  2, 68, 84, 224, 240, 144, 240, 2, 52, 68, 96, 128, 128, 96, 2, 68,
  84, 224, 144, 144, 224, 2, 68, 84, 240, 224, 128, 240, 2, 68, 84, 240,
  128, 224, 128, 2, 68, 84, 240, 128, 176, 240, 2, 68, 84, 144, 240, 144,
  144, 2, 20, 36, 128, 128, 128, 128, 2, 52, 68, 224, 32, 32, 192, 2,
  68, 84, 144, 224, 144, 144, 2, 52, 68, 128, 128, 128, 224, 2, 84, 100,
  136, 216, 168, 136, 2, 68, 84, 144, 208, 176, 144, 2, 68, 84, 96, 144,
  144, 96, 2, 68, 84, 224, 144, 224, 128, 2, 84, 100, 240, 144, 144, 232,
  2, 68, 84, 240, 240, 160, 144, 2, 68, 84, 112, 192, 48, 224, 2, 52,
  68, 224, 64, 64, 64, 2, 68, 84, 144, 144, 144, 240, 2, 68, 84, 144,
  144, 144, 96, 2, 84, 100, 136, 168, 168, 80, 2, 52, 68, 160, 64, 64,
  160, 2, 68, 84, 144, 240, 16, 240, 2, 68, 84, 240, 32, 64, 240, 1,
  38, 54, 192, 128, 128, 128, 128, 192, 2, 68, 84, 128, 64, 32, 16, 1,
  38, 54, 192, 64, 64, 64, 64, 192, 5, 50, 66, 64, 160, 1, 65, 81,
  240, 5, 34, 50, 128, 64, 2, 51, 67, 96, 160, 224, 2, 52, 68, 128,
  192, 160, 192, 2, 35, 51, 192, 128, 192, 2, 52, 68, 32, 96, 160, 96,
  2, 51, 67, 224, 160, 192, 2, 52, 68, 32, 64, 224, 64, 1, 52, 68,
  224, 224, 32, 96, 2, 52, 68, 128, 192, 160, 160, 2, 20, 36, 128, 0,
  128, 128, 1, 37, 53, 64, 0, 64, 64, 128, 2, 52, 68, 128, 160, 192,
  160, 2, 20, 36, 128, 128, 128, 128, 2, 83, 99, 208, 168, 168, 2, 51,
  67, 192, 160, 160, 2, 51, 67, 224, 160, 224, 1, 52, 68, 192, 160, 192,
  128, 1, 52, 68, 96, 160, 96, 32, 2, 35, 51, 192, 128, 128, 2, 51,
  67, 96, 64, 192, 2, 52, 68, 64, 224, 64, 96, 2, 51, 67, 160, 160,
  224, 2, 51, 67, 160, 160, 64, 2, 83, 99, 136, 168, 80, 2, 51, 67,
  160, 64, 160, 1, 52, 68, 160, 224, 32, 224, 2, 51, 67, 192, 64, 96,
  1, 54, 70, 96, 64, 128, 128, 64, 96, 1, 22, 38, 128, 128, 128, 128,
  128, 128, 1, 54, 70, 192, 64, 32, 32, 64, 192, 5, 66, 82, 80, 160,
  2, 69, 85, 240, 144, 144, 144, 240, 2, 0, 32, 2, 53, 69, 160, 0,
  160, 160, 224, 2, 54, 70, 64, 128, 0, 224, 192, 224, 2, 54, 70, 64,
  160, 0, 96, 160, 224, 2, 53, 69, 160, 0, 96, 160, 224, 2, 54, 70,
  64, 32, 0, 96, 160, 224, 2, 54, 70, 64, 160, 64, 96, 160, 224, 1,
  36, 52, 192, 128, 192, 192, 2, 54, 70, 64, 160, 0, 224, 192, 224, 2,
  53, 69, 160, 0, 224, 192, 224, 2, 54, 70, 64, 32, 0, 224, 192, 224,
  2, 52, 68, 160, 0, 64, 64, 2, 53, 149, 64, 160, 0, 64, 64, 2,
  37, 53, 128, 64, 0, 64, 64, 2, 69, 85, 144, 96, 144, 240, 144, 2,
  70, 86, 96, 144, 96, 144, 240, 144, 2, 70, 86, 32, 64, 240, 224, 128,
  240, 2, 83, 99, 120, 176, 248, 2, 132, 148, 31, 46, 120, 143, 2, 54,
  70, 64, 160, 0, 224, 160, 224, 2, 53, 69, 160, 0, 224, 160, 224, 2,
  54, 70, 128, 64, 0, 224, 160, 224, 2, 54, 70, 64, 160, 0, 160, 160,
  224, 2, 54, 70, 64, 32, 0, 160, 160, 224, 1, 54, 70, 160, 0, 160,
  224, 32, 96, 2, 69, 85, 144, 96, 144, 144, 96, 2, 69, 85, 144, 0,
  144, 144, 240, 2, 0, 64, 2, 0, 64, 2, 0, 64, 2, 0, 64, 2,
  0, 64, 2, 54, 70, 64, 128, 0, 96, 160, 224, 2, 37, 53, 64, 128,
  0, 128, 128, 2, 54, 70, 32, 64, 0, 224, 160, 224, 2, 54, 70, 32,
  64, 0, 160, 160, 224, 2, 70, 70, 80, 160, 0, 192, 160, 160, 2, 70,
  86, 80, 160, 144, 208, 176, 144, 2, 21, 37, 128, 128, 0, 128, 128, 1,
  54, 70, 224, 128, 224, 224, 32, 224, 6, 65, 81, 144, 1, 119, 151, 124,
  130, 186, 162, 186, 130, 124, 2, 0, 144, 2, 51, 67, 96, 192, 96, 3,
  50, 66, 224, 32, 2, 0, 144, 1, 119, 151, 124, 130, 186, 178, 170, 130,
  124, 6, 65, 81, 240, 4, 51, 67, 224, 160, 224, 2, 52, 148, 64, 224,
  64, 224, 4, 51, 67, 192, 64, 96, 4, 35, 51, 192, 64, 192, 5, 34,
  50, 64, 128, 1, 52, 148, 160, 160, 224, 128, 1, 101, 117, 124, 244, 116,
  20, 20, 19, 17, 49, 128, 2, 0, 144, 4, 35, 51, 192, 64, 64, 4,
  51, 67, 224, 160, 224, 2, 51, 67, 192, 96, 192, 1, 118, 134, 196, 72,
  80, 40, 78, 132, 1, 118, 134, 196, 72, 80, 44, 68, 134, 1, 118, 150,
  196, 72, 208, 40, 78, 132, 2, 0, 64, 2, 70, 86, 64, 32, 96, 144,
  240, 144, 2, 70, 86, 32, 64, 96, 144, 240, 144, 2, 70, 86, 96, 144,
  96, 144, 240, 144, 2, 70, 86, 80, 160, 96, 144, 240, 144, 2, 69, 85,
  144, 96, 144, 240, 144, 2, 70, 86, 96, 0, 96, 144, 240, 144, 2, 132,
  148, 31, 46, 120, 143, 1, 69, 85, 240, 128, 240, 32, 96, 2, 70, 86,
  64, 32, 240, 224, 128, 240, 2, 70, 86, 32, 64, 240, 224, 128, 240, 2,
  70, 86, 96, 144, 240, 224, 128, 240, 2, 70, 86, 144, 0, 240, 224, 128,
  240, 2, 38, 54, 128, 64, 128, 128, 128, 128, 2, 38, 54, 64, 128, 64,
  64, 64, 64, 2, 54, 70, 64, 160, 64, 64, 64, 64, 2, 53, 69, 160,
  64, 64, 64, 64, 2, 84, 100, 112, 232, 72, 112, 2, 70, 86, 80, 160,
  0, 144, 208, 176, 2, 70, 86, 64, 32, 96, 144, 144, 96, 2, 70, 86,
  32, 64, 96, 144, 144, 96, 2, 70, 86, 96, 144, 96, 144, 144, 96, 2,
  70, 86, 80, 160, 96, 144, 144, 96, 2, 69, 85, 144, 96, 144, 144, 96,
  2, 51, 67, 160, 64, 160, 1, 102, 118, 4, 56, 88, 104, 112, 128, 2,
  70, 86, 64, 32, 144, 144, 144, 240, 2, 70, 86, 32, 64, 144, 144, 144,
  240, 2, 70, 86, 96, 144, 0, 144, 144, 240, 2, 69, 85, 144, 0, 144,
  144, 240, 2, 70, 86, 32, 64, 144, 240, 16, 240, 1, 70, 86, 128, 224,
  144, 144, 224, 128, 1, 53, 69, 192, 192, 160, 192, 128, 2, 54, 70, 64,
  32, 0, 96, 160, 224, 2, 54, 70, 64, 128, 0, 96, 160, 224, 2, 54,
  70, 64, 160, 0, 96, 160, 224, 2, 70, 70, 80, 160, 0, 96, 160, 224,
  2, 53, 69, 160, 0, 96, 160, 224, 2, 54, 70, 64, 160, 64, 96, 160,
  224, 2, 83, 99, 120, 176, 248, 1, 36, 52, 192, 128, 192, 192, 2, 54,
  70, 64, 32, 0, 224, 160, 192, 2, 54, 70, 64, 128, 0, 224, 160, 192,
  2, 54, 70, 64, 160, 0, 224, 160, 192, 2, 53, 69, 160, 0, 224, 160,
  192, 2, 37, 53, 128, 64, 0, 64, 64, 2, 37, 53, 64, 128, 0, 128,
  128, 2, 53, 69, 64, 160, 0, 64, 64, 2, 52, 68, 160, 0, 64, 64,
  2, 70, 86, 96, 96, 16, 112, 144, 96, 2, 70, 70, 80, 160, 0, 192,
  160, 160, 2, 54, 70, 64, 32, 0, 224, 160, 224, 2, 54, 70, 64, 128,
  0, 224, 160, 224, 2, 54, 70, 64, 160, 0, 224, 160, 224, 2, 70, 70,
  80, 160, 0, 224, 160, 224, 2, 53, 69, 160, 0, 224, 160, 224, 2, 53,
  69, 64, 0, 224, 0, 64, 1, 85, 101, 8, 112, 80, 112, 128, 2, 54,
  70, 64, 32, 0, 160, 160, 224, 2, 54, 70, 64, 128, 0, 160, 160, 224,
  2, 54, 70, 64, 160, 0, 160, 160, 224, 2, 53, 69, 160, 0, 160, 160,
  224, 1, 55, 71, 64, 128, 0, 160, 224, 32, 96, 1, 53, 69, 128, 192,
  160, 192, 128, 1, 54, 70, 160, 0, 160, 224, 32, 96
};

/*
  Fontname: u8glib_4
  Copyright: public domain
  Capital A Height: 4, '1' Height: 4
  Calculated Max Values w= 5 h= 6 x= 0 y= 3 dx= 6 dy= 0 ascent= 5 len= 6
  Font Bounding box     w= 9 h= 6 x= 0 y=-1
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent = 4 descent=-1
  X Font      ascent = 5 descent=-1
  Max Font    ascent = 5 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_u8glib_4r[664] U8G_FONT_SECTION("u8g_font_u8glib_4r") = {
  1, 9, 6, 0, 255, 4, 0, 233, 1, 198, 32, 127, 255, 5, 255, 5,
  255, 2, 0, 32, 2, 20, 36, 128, 128, 0, 128, 5, 50, 66, 160, 160,
  1, 85, 101, 80, 248, 80, 248, 80, 1, 86, 102, 32, 120, 224, 56, 240,
  32, 2, 68, 84, 144, 32, 64, 144, 2, 69, 85, 64, 160, 64, 160, 240,
  5, 18, 34, 128, 128, 1, 38, 54, 64, 128, 128, 128, 128, 64, 1, 38,
  54, 128, 64, 64, 64, 64, 128, 3, 34, 50, 192, 192, 2, 51, 67, 64,
  224, 64, 1, 18, 34, 128, 128, 3, 49, 65, 224, 2, 17, 33, 128, 2,
  68, 84, 16, 32, 64, 128, 2, 52, 68, 224, 160, 160, 224, 2, 36, 52,
  64, 192, 64, 64, 2, 52, 68, 224, 32, 64, 224, 2, 52, 68, 224, 64,
  32, 224, 2, 52, 68, 128, 160, 224, 32, 2, 52, 68, 224, 192, 32, 224,
  2, 52, 68, 224, 128, 224, 224, 2, 52, 68, 224, 32, 64, 128, 2, 52,
  68, 224, 224, 160, 224, 2, 52, 68, 224, 224, 32, 224, 2, 19, 35, 128,
  0, 128, 1, 20, 36, 128, 0, 128, 128, 2, 35, 51, 64, 128, 64, 2,
  51, 67, 224, 0, 224, 2, 35, 51, 128, 64, 128, 2, 36, 52, 192, 64,
  0, 64, 2, 68, 84, 240, 176, 128, 240, 2, 68, 84, 96, 144, 240, 144,
  2, 68, 84, 224, 240, 144, 240, 2, 52, 68, 96, 128, 128, 96, 2, 68,
  84, 224, 144, 144, 224, 2, 68, 84, 240, 224, 128, 240, 2, 68, 84, 240,
  128, 224, 128, 2, 68, 84, 240, 128, 176, 240, 2, 68, 84, 144, 240, 144,
  144, 2, 20, 36, 128, 128, 128, 128, 2, 52, 68, 224, 32, 32, 192, 2,
  68, 84, 144, 224, 144, 144, 2, 52, 68, 128, 128, 128, 224, 2, 84, 100,
  136, 216, 168, 136, 2, 68, 84, 144, 208, 176, 144, 2, 68, 84, 96, 144,
  144, 96, 2, 68, 84, 224, 144, 224, 128, 2, 84, 100, 240, 144, 144, 232,
  2, 68, 84, 240, 240, 160, 144, 2, 68, 84, 112, 192, 48, 224, 2, 52,
  68, 224, 64, 64, 64, 2, 68, 84, 144, 144, 144, 240, 2, 68, 84, 144,
  144, 144, 96, 2, 84, 100, 136, 168, 168, 80, 2, 52, 68, 160, 64, 64,
  160, 2, 68, 84, 144, 240, 16, 240, 2, 68, 84, 240, 32, 64, 240, 1,
  38, 54, 192, 128, 128, 128, 128, 192, 2, 68, 84, 128, 64, 32, 16, 1,
  38, 54, 192, 64, 64, 64, 64, 192, 5, 50, 66, 64, 160, 1, 65, 81,
  240, 5, 34, 50, 128, 64, 2, 51, 67, 96, 160, 224, 2, 52, 68, 128,
  192, 160, 192, 2, 35, 51, 192, 128, 192, 2, 52, 68, 32, 96, 160, 96,
  2, 51, 67, 224, 160, 192, 2, 52, 68, 32, 64, 224, 64, 1, 52, 68,
  224, 224, 32, 96, 2, 52, 68, 128, 192, 160, 160, 2, 20, 36, 128, 0,
  128, 128, 1, 37, 53, 64, 0, 64, 64, 128, 2, 52, 68, 128, 160, 192,
  160, 2, 20, 36, 128, 128, 128, 128, 2, 83, 99, 208, 168, 168, 2, 51,
  67, 192, 160, 160, 2, 51, 67, 224, 160, 224, 1, 52, 68, 192, 160, 192,
  128, 1, 52, 68, 96, 160, 96, 32, 2, 35, 51, 192, 128, 128, 2, 51,
  67, 96, 64, 192, 2, 52, 68, 64, 224, 64, 96, 2, 51, 67, 160, 160,
  224, 2, 51, 67, 160, 160, 64, 2, 83, 99, 136, 168, 80, 2, 51, 67,
  160, 64, 160, 1, 52, 68, 160, 224, 32, 224, 2, 51, 67, 192, 64, 96,
  1, 54, 70, 96, 64, 128, 128, 64, 96, 1, 22, 38, 128, 128, 128, 128,
  128, 128, 1, 54, 70, 192, 64, 32, 32, 64, 192, 5, 66, 82, 80, 160,
  2, 69, 85, 240, 144, 144, 144, 240
};
