/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

/**
 * u8g_font_data_unifont.c
 */

#include "u8g.h"

/*
  Fontname: -gnu-unifont-medium-r-normal--16-160-75-75-c-80-iso10646-1
  Copyright:
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w=16 h=16 x= 4 y=14 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-2
  X Font      ascent =11 descent=-2
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_0_10[5136] U8G_FONT_SECTION("u8g_font_unifont_0_10") = {
  0, 16, 16, 0, 254, 10, 5, 43, 7, 25, 10, 255, 254, 14, 254, 11,
  254, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 65, 241, 193, 0, 65, 241, 193, 0, 125, 1, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 69, 241, 196, 64, 68, 65, 168, 64, 16,
  65, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 125, 241, 193,
  0, 125, 241, 193, 0, 65, 1, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 61, 225, 193, 16, 65, 225, 193, 32, 61, 17, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 60, 225, 193, 16, 57, 17, 133,
  16, 120, 225, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 61,
  241, 192, 64, 56, 65, 132, 64, 121, 241, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 114, 57, 202, 32, 74, 57, 202, 32, 115, 185, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 113, 137, 202, 24, 74,
  9, 202, 8, 113, 157, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 113, 153, 202, 4, 74, 9, 202, 16, 113, 157, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 113, 153, 202, 4, 74, 25, 202, 4, 113,
  153, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 113, 133, 202,
  12, 74, 21, 202, 28, 113, 133, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 73, 147, 234, 84, 106, 89, 219, 212, 74, 83, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 52, 83, 194, 154, 49, 23, 137,
  18, 113, 19, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 123,
  185, 193, 36, 121, 57, 193, 36, 121, 57, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 51, 37, 196, 180, 71, 173, 196, 164, 52, 165, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 125, 17, 193, 176, 125,
  81, 193, 16, 125, 17, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 58, 93, 194, 82, 50, 93, 138, 82, 113, 157, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 121, 207, 194, 16, 121, 145, 192, 80, 123,
  143, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 121, 193, 194,
  0, 121, 129, 192, 64, 67, 129, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 57, 193, 194, 0, 89, 129, 200, 64, 59, 129, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 113, 193, 202, 0, 113, 129, 208,
  64, 75, 129, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 73,
  193, 202, 0, 73, 129, 200, 64, 51, 129, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 0, 0, 0, 8, 0, 14, 1, 10, 10, 8, 4,
  0, 128, 128, 128, 128, 128, 128, 128, 0, 128, 128, 5, 4, 4, 8, 2,
  8, 136, 136, 136, 136, 6, 10, 10, 8, 1, 0, 36, 36, 36, 252, 72,
  72, 252, 144, 144, 144, 7, 10, 10, 8, 1, 0, 16, 124, 146, 144, 112,
  28, 18, 146, 124, 16, 7, 10, 10, 8, 1, 0, 98, 148, 148, 104, 16,
  16, 44, 82, 82, 140, 7, 10, 10, 8, 1, 0, 56, 68, 68, 68, 56,
  114, 138, 132, 140, 114, 1, 4, 4, 8, 4, 8, 128, 128, 128, 128, 3,
  12, 12, 8, 3, 255, 32, 64, 64, 128, 128, 128, 128, 128, 128, 64, 64,
  32, 3, 12, 12, 8, 2, 255, 128, 64, 64, 32, 32, 32, 32, 32, 32,
  64, 64, 128, 7, 7, 7, 8, 1, 1, 16, 146, 84, 56, 84, 146, 16,
  7, 7, 7, 8, 1, 1, 16, 16, 16, 254, 16, 16, 16, 2, 4, 4,
  8, 3, 254, 192, 64, 64, 128, 6, 1, 1, 8, 1, 4, 252, 2, 2,
  2, 8, 3, 0, 192, 192, 6, 10, 10, 8, 1, 0, 4, 4, 8, 16,
  16, 32, 32, 64, 128, 128, 6, 10, 10, 8, 1, 0, 48, 72, 132, 132,
  132, 132, 132, 132, 72, 48, 5, 10, 10, 8, 2, 0, 32, 96, 160, 32,
  32, 32, 32, 32, 32, 248, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4,
  24, 32, 64, 128, 128, 252, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4,
  56, 4, 4, 132, 132, 120, 6, 10, 10, 8, 1, 0, 8, 24, 40, 72,
  136, 136, 252, 8, 8, 8, 6, 10, 10, 8, 1, 0, 252, 128, 128, 128,
  248, 4, 4, 4, 132, 120, 6, 10, 10, 8, 1, 0, 56, 64, 128, 128,
  248, 132, 132, 132, 132, 120, 6, 10, 10, 8, 1, 0, 252, 4, 4, 8,
  8, 8, 16, 16, 16, 16, 6, 10, 10, 8, 1, 0, 120, 132, 132, 132,
  120, 132, 132, 132, 132, 120, 6, 10, 10, 8, 1, 0, 120, 132, 132, 132,
  124, 4, 4, 4, 8, 112, 2, 7, 7, 8, 3, 1, 192, 192, 0, 0,
  0, 192, 192, 2, 9, 9, 8, 3, 255, 192, 192, 0, 0, 0, 192, 64,
  64, 128, 5, 9, 9, 8, 2, 0, 8, 16, 32, 64, 128, 64, 32, 16,
  8, 6, 5, 5, 8, 1, 2, 252, 0, 0, 0, 252, 5, 9, 9, 8,
  1, 0, 128, 64, 32, 16, 8, 16, 32, 64, 128, 6, 10, 10, 8, 1,
  0, 120, 132, 132, 4, 8, 16, 16, 0, 16, 16, 6, 10, 10, 8, 1,
  0, 56, 68, 148, 172, 164, 164, 164, 156, 64, 60, 6, 10, 10, 8, 1,
  0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132, 6, 10, 10, 8, 1,
  0, 248, 132, 132, 132, 248, 132, 132, 132, 132, 248, 6, 10, 10, 8, 1,
  0, 120, 132, 132, 128, 128, 128, 128, 132, 132, 120, 6, 10, 10, 8, 1,
  0, 240, 136, 132, 132, 132, 132, 132, 132, 136, 240, 6, 10, 10, 8, 1,
  0, 252, 128, 128, 128, 248, 128, 128, 128, 128, 252, 6, 10, 10, 8, 1,
  0, 252, 128, 128, 128, 248, 128, 128, 128, 128, 128, 6, 10, 10, 8, 1,
  0, 120, 132, 132, 128, 128, 156, 132, 132, 140, 116, 6, 10, 10, 8, 1,
  0, 132, 132, 132, 132, 252, 132, 132, 132, 132, 132, 5, 10, 10, 8, 2,
  0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 248, 7, 10, 10, 8, 1,
  0, 62, 8, 8, 8, 8, 8, 8, 136, 136, 112, 6, 10, 10, 8, 1,
  0, 132, 136, 144, 160, 192, 192, 160, 144, 136, 132, 6, 10, 10, 8, 1,
  0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 252, 6, 10, 10, 8, 1,
  0, 132, 132, 204, 204, 180, 180, 132, 132, 132, 132, 6, 10, 10, 8, 1,
  0, 132, 196, 196, 164, 164, 148, 148, 140, 140, 132, 6, 10, 10, 8, 1,
  0, 120, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 10, 10, 8, 1,
  0, 248, 132, 132, 132, 248, 128, 128, 128, 128, 128, 7, 11, 11, 8, 1,
  255, 120, 132, 132, 132, 132, 132, 132, 180, 204, 120, 6, 6, 10, 10, 8,
  1, 0, 248, 132, 132, 132, 248, 144, 136, 136, 132, 132, 6, 10, 10, 8,
  1, 0, 120, 132, 132, 128, 96, 24, 4, 132, 132, 120, 7, 10, 10, 8,
  1, 0, 254, 16, 16, 16, 16, 16, 16, 16, 16, 16, 6, 10, 10, 8,
  1, 0, 132, 132, 132, 132, 132, 132, 132, 132, 132, 120, 7, 10, 10, 8,
  1, 0, 130, 130, 130, 68, 68, 68, 40, 40, 16, 16, 6, 10, 10, 8,
  1, 0, 132, 132, 132, 132, 180, 180, 204, 204, 132, 132, 6, 10, 10, 8,
  1, 0, 132, 132, 72, 72, 48, 48, 72, 72, 132, 132, 7, 10, 10, 8,
  1, 0, 130, 130, 68, 68, 40, 16, 16, 16, 16, 16, 6, 10, 10, 8,
  1, 0, 252, 4, 4, 8, 16, 32, 64, 128, 128, 252, 3, 12, 12, 8,
  4, 255, 224, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 224, 6, 10,
  10, 8, 1, 0, 128, 128, 64, 32, 32, 16, 16, 8, 4, 4, 3, 12,
  12, 8, 1, 255, 224, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 224,
  6, 3, 3, 8, 1, 9, 48, 72, 132, 7, 1, 1, 8, 1, 255, 254,
  3, 3, 3, 8, 2, 10, 128, 64, 32, 6, 8, 8, 8, 1, 0, 120,
  132, 4, 124, 132, 132, 140, 116, 6, 11, 11, 8, 1, 0, 128, 128, 128,
  184, 196, 132, 132, 132, 132, 196, 184, 6, 8, 8, 8, 1, 0, 120, 132,
  128, 128, 128, 128, 132, 120, 6, 11, 11, 8, 1, 0, 4, 4, 4, 116,
  140, 132, 132, 132, 132, 140, 116, 6, 8, 8, 8, 1, 0, 120, 132, 132,
  252, 128, 128, 132, 120, 5, 11, 11, 8, 1, 0, 24, 32, 32, 32, 248,
  32, 32, 32, 32, 32, 32, 6, 11, 11, 8, 1, 254, 4, 116, 136, 136,
  136, 112, 64, 120, 132, 132, 120, 6, 11, 11, 8, 1, 0, 128, 128, 128,
  184, 196, 132, 132, 132, 132, 132, 132, 5, 11, 11, 8, 2, 0, 32, 32,
  0, 96, 32, 32, 32, 32, 32, 32, 248, 5, 13, 13, 8, 1, 254, 8,
  8, 0, 24, 8, 8, 8, 8, 8, 8, 8, 144, 96, 6, 10, 10, 8,
  1, 0, 128, 128, 136, 144, 160, 192, 160, 144, 136, 132, 5, 10, 10, 8,
  2, 0, 96, 32, 32, 32, 32, 32, 32, 32, 32, 248, 7, 8, 8, 8,
  1, 0, 236, 146, 146, 146, 146, 146, 146, 146, 6, 8, 8, 8, 1, 0,
  184, 196, 132, 132, 132, 132, 132, 132, 6, 8, 8, 8, 1, 0, 120, 132,
  132, 132, 132, 132, 132, 120, 6, 10, 10, 8, 1, 254, 184, 196, 132, 132,
  132, 132, 196, 184, 128, 128, 6, 10, 10, 8, 1, 254, 116, 140, 132, 132,
  132, 132, 140, 116, 4, 4, 6, 8, 8, 8, 1, 0, 184, 196, 132, 128,
  128, 128, 128, 128, 6, 8, 8, 8, 1, 0, 120, 132, 128, 96, 24, 4,
  132, 120, 5, 10, 10, 8, 1, 0, 32, 32, 248, 32, 32, 32, 32, 32,
  32, 24, 6, 8, 8, 8, 1, 0, 132, 132, 132, 132, 132, 132, 140, 116,
  6, 8, 8, 8, 1, 0, 132, 132, 132, 72, 72, 72, 48, 48, 7, 8,
  8, 8, 1, 0, 130, 146, 146, 146, 146, 146, 146, 108, 6, 8, 8, 8,
  1, 0, 132, 132, 72, 48, 48, 72, 132, 132, 6, 10, 10, 8, 1, 254,
  132, 132, 132, 132, 132, 76, 52, 4, 4, 120, 6, 8, 8, 8, 1, 0,
  252, 4, 8, 16, 32, 64, 128, 252, 3, 12, 12, 8, 3, 255, 96, 128,
  128, 64, 64, 128, 128, 64, 64, 128, 128, 96, 1, 14, 14, 8, 4, 254,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 3, 12,
  12, 8, 2, 255, 192, 32, 32, 64, 64, 32, 32, 64, 64, 32, 32, 192,
  7, 3, 3, 8, 1, 8, 98, 146, 140, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 115, 209, 202, 16, 75, 209, 202,
  16, 115, 223, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 113,
  157, 202, 82, 115, 211, 194, 82, 66, 93, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 73, 157, 202, 82, 122, 93, 202, 80, 73, 145, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 115, 147, 202, 82, 115,
  159, 202, 18, 114, 19, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 75, 147, 234, 82, 91, 159, 202, 82, 75, 147, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 116, 185, 166, 164, 37, 165, 164, 164, 116,
  185, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 75, 209, 234,
  16, 91, 209, 202, 16, 75, 223, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 57, 205, 194, 18, 49, 159, 136, 82, 115, 147, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 121, 205, 194, 18, 121, 159, 192,
  82, 123, 147, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 75,
  157, 201, 32, 121, 25, 201, 4, 73, 57, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 75, 185, 201, 8, 121, 9, 201, 8, 73, 49, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 69, 205, 196, 144, 68,
  137, 168, 132, 16, 153, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 114, 29, 202, 18, 114, 19, 194, 18, 67, 221, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 114, 19, 202, 18, 114, 19, 194, 18, 67,
  205, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 14, 33, 137,
  32, 14, 33, 138, 32, 9, 33, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 57, 221, 194, 2, 49, 141, 136, 80, 115, 159, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 57, 221, 194, 2, 49, 141, 136,
  66, 115, 157, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 113,
  207, 202, 16, 74, 13, 202, 2, 113, 221, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 114, 69, 202, 76, 114, 69, 194, 68, 65, 143, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 114, 93, 202, 66, 114,
  77, 194, 80, 65, 159, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 59, 157, 193, 32, 49, 25, 137, 4, 113, 57, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 57, 211, 194, 18, 66, 31, 194, 18, 57,
  211, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 69, 17, 237,
  16, 85, 81, 197, 176, 69, 17, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 59, 141, 194, 82, 51, 159, 138, 18, 114, 19, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 123, 141, 194, 82, 123, 159, 194,
  18, 122, 19, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 57,
  143, 194, 80, 50, 77, 138, 66, 113, 157, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 51, 155, 196, 34, 37, 163, 148, 162, 99, 155, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 57, 221, 194, 8, 50,
  9, 138, 8, 113, 221, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 57, 221, 194, 8, 65, 137, 192, 72, 59, 157, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 14, 249, 144, 32, 12, 33, 130, 32, 28,
  33, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 49, 207, 202,
  16, 73, 145, 200, 80, 51, 143, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 114, 33, 203, 96, 114, 161, 194, 32, 66, 33, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 51, 143, 202, 80, 123, 145, 202,
  16, 74, 15, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 0,
  0, 0, 8, 0, 14, 1, 10, 10, 8, 4, 0, 128, 128, 0, 128, 128,
  128, 128, 128, 128, 128, 7, 10, 10, 8, 1, 0, 16, 16, 124, 146, 144,
  144, 146, 124, 16, 16, 7, 10, 10, 8, 1, 0, 28, 32, 32, 32, 248,
  32, 32, 32, 124, 194, 6, 8, 8, 8, 1, 1, 132, 72, 120, 72, 72,
  120, 72, 132, 7, 10, 10, 8, 1, 0, 130, 68, 40, 16, 254, 16, 254,
  16, 16, 16, 1, 10, 10, 8, 4, 0, 128, 128, 128, 128, 0, 0, 128,
  128, 128, 128, 6, 10, 10, 8, 1, 0, 120, 132, 128, 120, 132, 132, 120,
  4, 132, 120, 4, 2, 2, 8, 2, 12, 144, 144, 8, 10, 10, 8, 0,
  0, 60, 66, 153, 165, 161, 161, 165, 153, 66, 60, 5, 7, 7, 8, 2,
  5, 112, 8, 120, 136, 120, 0, 248, 6, 9, 9, 8, 1, 0, 36, 36,
  72, 72, 144, 72, 72, 36, 36, 6, 4, 4, 8, 1, 0, 252, 4, 4,
  4, 6, 1, 1, 8, 1, 4, 252, 8, 10, 10, 8, 0, 0, 60, 66,
  185, 165, 165, 185, 169, 165, 66, 60, 6, 1, 1, 8, 1, 11, 252, 3,
  4, 4, 8, 2, 10, 64, 160, 160, 64, 7, 9, 9, 8, 1, 1, 16,
  16, 16, 254, 16, 16, 16, 0, 254, 5, 7, 7, 8, 2, 5, 112, 136,
  8, 112, 128, 128, 248, 5, 7, 7, 8, 2, 5, 112, 136, 8, 112, 8,
  136, 112, 3, 3, 3, 8, 3, 10, 32, 64, 128, 5, 8, 8, 8, 2,
  254, 136, 136, 136, 136, 216, 168, 128, 128, 6, 12, 12, 8, 1, 255, 124,
  244, 244, 244, 244, 116, 20, 20, 20, 20, 20, 28, 2, 2, 2, 8, 3,
  4, 192, 192, 3, 2, 2, 8, 2, 254, 32, 192, 3, 7, 7, 8, 2,
  5, 32, 96, 160, 32, 32, 32, 32, 5, 7, 7, 8, 2, 5, 112, 136,
  136, 136, 112, 0, 248, 6, 9, 9, 8, 1, 0, 144, 144, 72, 72, 36,
  72, 72, 144, 144, 6, 10, 10, 8, 1, 0, 68, 196, 72, 80, 80, 36,
  44, 84, 156, 132, 6, 10, 10, 8, 1, 0, 68, 196, 72, 80, 80, 40,
  52, 68, 136, 156, 6, 10, 10, 8, 1, 0, 196, 36, 72, 48, 208, 36,
  44, 84, 156, 132, 6, 10, 10, 8, 1, 0, 16, 16, 0, 16, 16, 96,
  132, 132, 132, 120, 6, 14, 14, 8, 1, 0, 96, 24, 0, 0, 48, 72,
  72, 132, 132, 252, 132, 132, 132, 132, 6, 14, 14, 8, 1, 0, 24, 96,
  0, 0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132, 6, 14, 14, 8,
  1, 0, 48, 72, 0, 0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132,
  6, 14, 14, 8, 1, 0, 100, 152, 0, 0, 48, 72, 72, 132, 132, 252,
  132, 132, 132, 132, 6, 14, 14, 8, 1, 0, 72, 72, 0, 0, 48, 72,
  72, 132, 132, 252, 132, 132, 132, 132, 6, 14, 14, 8, 1, 0, 48, 72,
  48, 0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132, 7, 10, 10, 8,
  1, 0, 62, 80, 144, 144, 254, 144, 144, 144, 144, 158, 6, 12, 12, 8,
  1, 254, 120, 132, 132, 128, 128, 128, 128, 132, 132, 120, 16, 96, 6, 14,
  14, 8, 1, 0, 96, 24, 0, 0, 252, 128, 128, 128, 248, 128, 128, 128,
  128, 252, 6, 14, 14, 8, 1, 0, 24, 96, 0, 0, 252, 128, 128, 128,
  248, 128, 128, 128, 128, 252, 6, 14, 14, 8, 1, 0, 48, 72, 0, 0,
  252, 128, 128, 128, 248, 128, 128, 128, 128, 252, 6, 14, 14, 8, 1, 0,
  72, 72, 0, 0, 252, 128, 128, 128, 248, 128, 128, 128, 128, 252, 5, 14,
  14, 8, 2, 0, 96, 24, 0, 0, 248, 32, 32, 32, 32, 32, 32, 32,
  32, 248, 5, 14, 14, 8, 2, 0, 48, 192, 0, 0, 248, 32, 32, 32,
  32, 32, 32, 32, 32, 248, 5, 14, 14, 8, 2, 0, 96, 144, 0, 0,
  248, 32, 32, 32, 32, 32, 32, 32, 32, 248, 5, 14, 14, 8, 2, 0,
  144, 144, 0, 0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 248, 7, 10,
  10, 8, 0, 0, 120, 68, 66, 66, 242, 66, 66, 66, 68, 120, 6, 14,
  14, 8, 1, 0, 100, 152, 0, 0, 132, 196, 196, 164, 164, 148, 148, 140,
  140, 132, 6, 14, 14, 8, 1, 0, 96, 24, 0, 0, 120, 132, 132, 132,
  132, 132, 132, 132, 132, 120, 6, 14, 14, 8, 1, 0, 24, 96, 0, 0,
  120, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 14, 14, 8, 1, 0,
  48, 72, 0, 0, 120, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 14,
  14, 8, 1, 0, 100, 152, 0, 0, 120, 132, 132, 132, 132, 132, 132, 132,
  132, 120, 6, 14, 14, 8, 1, 0, 72, 72, 0, 0, 120, 132, 132, 132,
  132, 132, 132, 132, 132, 120, 6, 5, 5, 8, 1, 2, 132, 72, 48, 72,
  132, 6, 12, 12, 8, 1, 255, 4, 116, 136, 140, 148, 148, 164, 164, 196,
  68, 184, 128, 6, 14, 14, 8, 1, 0, 96, 24, 0, 0, 132, 132, 132,
  132, 132, 132, 132, 132, 132, 120, 6, 14, 14, 8, 1, 0, 24, 96, 0,
  0, 132, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 14, 14, 8, 1,
  0, 48, 72, 0, 0, 132, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6,
  14, 14, 8, 1, 0, 72, 72, 0, 0, 132, 132, 132, 132, 132, 132, 132,
  132, 132, 120, 7, 14, 14, 8, 1, 0, 24, 96, 0, 0, 130, 130, 68,
  68, 40, 16, 16, 16, 16, 16, 6, 11, 11, 8, 1, 0, 128, 128, 240,
  136, 132, 132, 136, 240, 128, 128, 128, 6, 10, 10, 8, 1, 0, 112, 136,
  136, 136, 248, 132, 132, 132, 196, 184, 6, 12, 12, 8, 1, 0, 96, 24,
  0, 0, 120, 132, 4, 124, 132, 132, 140, 116, 6, 12, 12, 8, 1, 0,
  24, 96, 0, 0, 120, 132, 4, 124, 132, 132, 140, 116, 6, 12, 12, 8,
  1, 0, 48, 72, 0, 0, 120, 132, 4, 124, 132, 132, 140, 116, 6, 12,
  12, 8, 1, 0, 100, 152, 0, 0, 120, 132, 4, 124, 132, 132, 140, 116,
  6, 12, 12, 8, 1, 0, 72, 72, 0, 0, 120, 132, 4, 124, 132, 132,
  140, 116, 6, 13, 13, 8, 1, 0, 48, 72, 48, 0, 0, 120, 132, 4,
  124, 132, 132, 140, 116, 7, 8, 8, 8, 1, 0, 124, 146, 18, 126, 144,
  144, 146, 124, 6, 10, 10, 8, 1, 254, 120, 132, 128, 128, 128, 128, 132,
  120, 16, 96, 6, 12, 12, 8, 1, 0, 96, 24, 0, 0, 120, 132, 132,
  252, 128, 128, 132, 120, 6, 12, 12, 8, 1, 0, 24, 96, 0, 0, 120,
  132, 132, 252, 128, 128, 132, 120, 6, 12, 12, 8, 1, 0, 48, 72, 0,
  0, 120, 132, 132, 252, 128, 128, 132, 120, 6, 12, 12, 8, 1, 0, 72,
  72, 0, 0, 120, 132, 132, 252, 128, 128, 132, 120, 5, 12, 12, 8, 2,
  0, 192, 48, 0, 0, 96, 32, 32, 32, 32, 32, 32, 248, 5, 12, 12,
  8, 2, 0, 48, 192, 0, 0, 96, 32, 32, 32, 32, 32, 32, 248, 5,
  12, 12, 8, 2, 0, 96, 144, 0, 0, 96, 32, 32, 32, 32, 32, 32,
  248, 5, 12, 12, 8, 2, 0, 144, 144, 0, 0, 96, 32, 32, 32, 32,
  32, 32, 248, 6, 12, 12, 8, 1, 0, 100, 24, 40, 68, 4, 124, 132,
  132, 132, 132, 132, 120, 6, 12, 12, 8, 1, 0, 100, 152, 0, 0, 184,
  196, 132, 132, 132, 132, 132, 132, 6, 12, 12, 8, 1, 0, 96, 24, 0,
  0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 8, 1, 0, 24,
  96, 0, 0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 8, 1,
  0, 48, 72, 0, 0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12,
  8, 1, 0, 100, 152, 0, 0, 120, 132, 132, 132, 132, 132, 132, 120, 6,
  12, 12, 8, 1, 0, 72, 72, 0, 0, 120, 132, 132, 132, 132, 132, 132,
  120, 6, 7, 7, 8, 1, 1, 48, 0, 0, 252, 0, 0, 48, 6, 10,
  10, 8, 1, 255, 4, 120, 140, 148, 148, 164, 164, 196, 120, 128, 6, 12,
  12, 8, 1, 0, 96, 24, 0, 0, 132, 132, 132, 132, 132, 132, 140, 116,
  6, 12, 12, 8, 1, 0, 24, 96, 0, 0, 132, 132, 132, 132, 132, 132,
  140, 116, 6, 12, 12, 8, 1, 0, 48, 72, 0, 0, 132, 132, 132, 132,
  132, 132, 140, 116, 6, 12, 12, 8, 1, 0, 72, 72, 0, 0, 132, 132,
  132, 132, 132, 132, 140, 116, 6, 14, 14, 8, 1, 254, 24, 96, 0, 0,
  132, 132, 132, 132, 132, 76, 52, 4, 4, 120, 5, 12, 12, 8, 2, 254,
  128, 128, 240, 136, 136, 136, 144, 160, 192, 128, 128, 128, 6, 14, 14, 8,
  1, 254, 72, 72, 0, 0, 132, 132, 132, 132, 132, 76, 52, 4, 4, 120
};

/*
  Fontname: -gnu-unifont-medium-r-normal--16-160-75-75-c-80-iso10646-1
  Copyright:
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w=16 h=16 x= 5 y=14 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-2
  X Font      ascent =11 descent=-2
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_0_11[3240] U8G_FONT_SECTION("u8g_font_unifont_0_11") = {
  0, 16, 16, 0, 254, 10, 1, 231, 3, 213, 32, 255, 254, 14, 254, 11,
  254, 0, 0, 0, 8, 0, 14, 1, 10, 10, 8, 4, 0, 128, 128, 128,
  128, 128, 128, 128, 0, 128, 128, 5, 4, 4, 8, 2, 8, 136, 136, 136,
  136, 6, 10, 10, 8, 1, 0, 36, 36, 36, 252, 72, 72, 252, 144, 144,
  144, 7, 10, 10, 8, 1, 0, 16, 124, 146, 144, 112, 28, 18, 146, 124,
  16, 7, 10, 10, 8, 1, 0, 98, 148, 148, 104, 16, 16, 44, 82, 82,
  140, 7, 10, 10, 8, 1, 0, 56, 68, 68, 68, 56, 114, 138, 132, 140,
  114, 1, 4, 4, 8, 4, 8, 128, 128, 128, 128, 3, 12, 12, 8, 3,
  255, 32, 64, 64, 128, 128, 128, 128, 128, 128, 64, 64, 32, 3, 12, 12,
  8, 2, 255, 128, 64, 64, 32, 32, 32, 32, 32, 32, 64, 64, 128, 7,
  7, 7, 8, 1, 1, 16, 146, 84, 56, 84, 146, 16, 7, 7, 7, 8,
  1, 1, 16, 16, 16, 254, 16, 16, 16, 2, 4, 4, 8, 3, 254, 192,
  64, 64, 128, 6, 1, 1, 8, 1, 4, 252, 2, 2, 2, 8, 3, 0,
  192, 192, 6, 10, 10, 8, 1, 0, 4, 4, 8, 16, 16, 32, 32, 64,
  128, 128, 6, 10, 10, 8, 1, 0, 48, 72, 132, 132, 132, 132, 132, 132,
  72, 48, 5, 10, 10, 8, 2, 0, 32, 96, 160, 32, 32, 32, 32, 32,
  32, 248, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4, 24, 32, 64, 128,
  128, 252, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4, 56, 4, 4, 132,
  132, 120, 6, 10, 10, 8, 1, 0, 8, 24, 40, 72, 136, 136, 252, 8,
  8, 8, 6, 10, 10, 8, 1, 0, 252, 128, 128, 128, 248, 4, 4, 4,
  132, 120, 6, 10, 10, 8, 1, 0, 56, 64, 128, 128, 248, 132, 132, 132,
  132, 120, 6, 10, 10, 8, 1, 0, 252, 4, 4, 8, 8, 8, 16, 16,
  16, 16, 6, 10, 10, 8, 1, 0, 120, 132, 132, 132, 120, 132, 132, 132,
  132, 120, 6, 10, 10, 8, 1, 0, 120, 132, 132, 132, 124, 4, 4, 4,
  8, 112, 2, 7, 7, 8, 3, 1, 192, 192, 0, 0, 0, 192, 192, 2,
  9, 9, 8, 3, 255, 192, 192, 0, 0, 0, 192, 64, 64, 128, 5, 9,
  9, 8, 2, 0, 8, 16, 32, 64, 128, 64, 32, 16, 8, 6, 5, 5,
  8, 1, 2, 252, 0, 0, 0, 252, 5, 9, 9, 8, 1, 0, 128, 64,
  32, 16, 8, 16, 32, 64, 128, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  4, 8, 16, 16, 0, 16, 16, 6, 10, 10, 8, 1, 0, 56, 68, 148,
  172, 164, 164, 164, 156, 64, 60, 6, 10, 10, 8, 1, 0, 48, 72, 72,
  132, 132, 252, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 248, 132, 132,
  132, 248, 132, 132, 132, 132, 248, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  128, 128, 128, 128, 132, 132, 120, 6, 10, 10, 8, 1, 0, 240, 136, 132,
  132, 132, 132, 132, 132, 136, 240, 6, 10, 10, 8, 1, 0, 252, 128, 128,
  128, 248, 128, 128, 128, 128, 252, 6, 10, 10, 8, 1, 0, 252, 128, 128,
  128, 248, 128, 128, 128, 128, 128, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  128, 128, 156, 132, 132, 140, 116, 6, 10, 10, 8, 1, 0, 132, 132, 132,
  132, 252, 132, 132, 132, 132, 132, 5, 10, 10, 8, 2, 0, 248, 32, 32,
  32, 32, 32, 32, 32, 32, 248, 7, 10, 10, 8, 1, 0, 62, 8, 8,
  8, 8, 8, 8, 136, 136, 112, 6, 10, 10, 8, 1, 0, 132, 136, 144,
  160, 192, 192, 160, 144, 136, 132, 6, 10, 10, 8, 1, 0, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 252, 6, 10, 10, 8, 1, 0, 132, 132, 204,
  204, 180, 180, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 132, 196, 196,
  164, 164, 148, 148, 140, 140, 132, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  132, 132, 132, 132, 132, 132, 120, 6, 10, 10, 8, 1, 0, 248, 132, 132,
  132, 248, 128, 128, 128, 128, 128, 7, 11, 11, 8, 1, 255, 120, 132, 132,
  132, 132, 132, 132, 180, 204, 120, 6, 6, 10, 10, 8, 1, 0, 248, 132,
  132, 132, 248, 144, 136, 136, 132, 132, 6, 10, 10, 8, 1, 0, 120, 132,
  132, 128, 96, 24, 4, 132, 132, 120, 7, 10, 10, 8, 1, 0, 254, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 6, 10, 10, 8, 1, 0, 132, 132,
  132, 132, 132, 132, 132, 132, 132, 120, 7, 10, 10, 8, 1, 0, 130, 130,
  130, 68, 68, 68, 40, 40, 16, 16, 6, 10, 10, 8, 1, 0, 132, 132,
  132, 132, 180, 180, 204, 204, 132, 132, 6, 10, 10, 8, 1, 0, 132, 132,
  72, 72, 48, 48, 72, 72, 132, 132, 7, 10, 10, 8, 1, 0, 130, 130,
  68, 68, 40, 16, 16, 16, 16, 16, 6, 10, 10, 8, 1, 0, 252, 4,
  4, 8, 16, 32, 64, 128, 128, 252, 3, 12, 12, 8, 4, 255, 224, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 224, 6, 10, 10, 8, 1, 0,
  128, 128, 64, 32, 32, 16, 16, 8, 4, 4, 3, 12, 12, 8, 1, 255,
  224, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 224, 6, 3, 3, 8,
  1, 9, 48, 72, 132, 7, 1, 1, 8, 1, 255, 254, 3, 3, 3, 8,
  2, 10, 128, 64, 32, 6, 8, 8, 8, 1, 0, 120, 132, 4, 124, 132,
  132, 140, 116, 6, 11, 11, 8, 1, 0, 128, 128, 128, 184, 196, 132, 132,
  132, 132, 196, 184, 6, 8, 8, 8, 1, 0, 120, 132, 128, 128, 128, 128,
  132, 120, 6, 11, 11, 8, 1, 0, 4, 4, 4, 116, 140, 132, 132, 132,
  132, 140, 116, 6, 8, 8, 8, 1, 0, 120, 132, 132, 252, 128, 128, 132,
  120, 5, 11, 11, 8, 1, 0, 24, 32, 32, 32, 248, 32, 32, 32, 32,
  32, 32, 6, 11, 11, 8, 1, 254, 4, 116, 136, 136, 136, 112, 64, 120,
  132, 132, 120, 6, 11, 11, 8, 1, 0, 128, 128, 128, 184, 196, 132, 132,
  132, 132, 132, 132, 5, 11, 11, 8, 2, 0, 32, 32, 0, 96, 32, 32,
  32, 32, 32, 32, 248, 5, 13, 13, 8, 1, 254, 8, 8, 0, 24, 8,
  8, 8, 8, 8, 8, 8, 144, 96, 6, 10, 10, 8, 1, 0, 128, 128,
  136, 144, 160, 192, 160, 144, 136, 132, 5, 10, 10, 8, 2, 0, 96, 32,
  32, 32, 32, 32, 32, 32, 32, 248, 7, 8, 8, 8, 1, 0, 236, 146,
  146, 146, 146, 146, 146, 146, 6, 8, 8, 8, 1, 0, 184, 196, 132, 132,
  132, 132, 132, 132, 6, 8, 8, 8, 1, 0, 120, 132, 132, 132, 132, 132,
  132, 120, 6, 10, 10, 8, 1, 254, 184, 196, 132, 132, 132, 132, 196, 184,
  128, 128, 6, 10, 10, 8, 1, 254, 116, 140, 132, 132, 132, 132, 140, 116,
  4, 4, 6, 8, 8, 8, 1, 0, 184, 196, 132, 128, 128, 128, 128, 128,
  6, 8, 8, 8, 1, 0, 120, 132, 128, 96, 24, 4, 132, 120, 5, 10,
  10, 8, 1, 0, 32, 32, 248, 32, 32, 32, 32, 32, 32, 24, 6, 8,
  8, 8, 1, 0, 132, 132, 132, 132, 132, 132, 140, 116, 6, 8, 8, 8,
  1, 0, 132, 132, 132, 72, 72, 72, 48, 48, 7, 8, 8, 8, 1, 0,
  130, 146, 146, 146, 146, 146, 146, 108, 6, 8, 8, 8, 1, 0, 132, 132,
  72, 48, 48, 72, 132, 132, 6, 10, 10, 8, 1, 254, 132, 132, 132, 132,
  132, 76, 52, 4, 4, 120, 6, 8, 8, 8, 1, 0, 252, 4, 8, 16,
  32, 64, 128, 252, 3, 12, 12, 8, 3, 255, 96, 128, 128, 64, 64, 128,
  128, 64, 64, 128, 128, 96, 1, 14, 14, 8, 4, 254, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 3, 12, 12, 8, 2, 255,
  192, 32, 32, 64, 64, 32, 32, 64, 64, 32, 32, 192, 7, 3, 3, 8,
  1, 8, 98, 146, 140, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 115, 209, 202, 16, 75, 209, 202, 16, 115, 223, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 6, 10, 10, 8, 1,
  254, 184, 196, 132, 132, 132, 132, 132, 132, 128, 128, 6, 10, 10, 8, 1,
  254, 116, 140, 132, 132, 132, 140, 116, 4, 132, 120, 4, 8, 8, 8, 3,
  0, 192, 64, 64, 64, 64, 64, 64, 112, 7, 12, 12, 8, 1, 254, 16,
  16, 148, 154, 146, 146, 146, 146, 178, 82, 16, 16, 7, 11, 11, 8, 1,
  0, 28, 34, 32, 32, 248, 32, 32, 32, 32, 32, 32, 6, 8, 8, 8,
  1, 0, 120, 132, 132, 132, 132, 132, 132, 120, 7, 12, 12, 8, 1, 254,
  112, 144, 144, 112, 28, 18, 18, 18, 146, 124, 16, 16, 7, 10, 10, 8,
  1, 0, 128, 128, 128, 136, 136, 136, 136, 136, 136, 118, 6, 14, 14, 8,
  1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84,
  2, 7, 7, 8, 3, 1, 192, 192, 0, 0, 0, 192, 192, 6, 2, 2,
  8, 1, 1, 196, 120, 6, 14, 14, 8, 1, 255, 168, 84, 168, 84, 168,
  84, 168, 84, 168, 84, 168, 84, 168, 84, 6, 14, 14, 8, 1, 255, 168,
  84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 6, 14, 14,
  8, 1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168,
  84, 6, 14, 14, 8, 1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168,
  84, 168, 84, 168, 84, 6, 14, 14, 8, 1, 255, 168, 84, 168, 84, 168,
  84, 168, 84, 168, 84, 168, 84, 168, 84, 6, 14, 14, 8, 1, 255, 168,
  84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 5, 4, 4,
  8, 2, 255, 32, 32, 112, 136, 6, 3, 3, 8, 1, 9, 48, 0, 204,
  4, 6, 6, 8, 2, 8, 48, 192, 48, 192, 48, 192, 2, 3, 3, 8,
  3, 10, 192, 0, 192, 4, 3, 3, 8, 2, 10, 176, 128, 176, 3, 3,
  3, 8, 3, 255, 128, 128, 96, 5, 5, 5, 8, 2, 9, 32, 112, 248,
  112, 32, 6, 4, 4, 8, 1, 9, 72, 164, 148, 72, 3, 3, 3, 8,
  0, 9, 192, 32, 32, 2, 3, 3, 8, 5, 255, 64, 128, 64, 4, 4,
  4, 8, 1, 254, 208, 208, 16, 224, 3, 3, 3, 8, 3, 10, 96, 128,
  128, 3, 3, 3, 8, 5, 9, 96, 128, 128, 5, 5, 5, 8, 3, 9,
  48, 64, 152, 160, 32, 8, 4, 4, 8, 0, 9, 66, 165, 66, 36, 3,
  4, 4, 8, 5, 9, 64, 160, 64, 128, 4, 3, 3, 8, 0, 8, 80,
  96, 128, 5, 3, 3, 8, 1, 254, 136, 112, 32, 3, 3, 3, 8, 2,
  255, 32, 32, 224, 2, 3, 3, 8, 3, 255, 64, 128, 64, 3, 3, 3,
  8, 2, 255, 32, 32, 192, 5, 4, 4, 8, 1, 254, 40, 200, 16, 96,
  4, 5, 5, 8, 2, 254, 96, 128, 96, 16, 96, 3, 3, 3, 8, 2,
  9, 192, 32, 32, 3, 4, 4, 8, 1, 9, 64, 160, 64, 32, 5, 4,
  4, 8, 2, 254, 136, 112, 32, 32, 2, 3, 3, 8, 2, 10, 64, 128,
  64, 3, 3, 3, 8, 3, 10, 32, 32, 224, 3, 3, 3, 8, 5, 255,
  128, 128, 96, 5, 4, 4, 8, 0, 9, 72, 168, 168, 144, 4, 4, 4,
  8, 2, 9, 96, 144, 144, 96, 2, 3, 3, 8, 3, 255, 192, 0, 192,
  5, 3, 3, 8, 2, 255, 168, 0, 72, 5, 3, 3, 8, 2, 255, 232,
  0, 8, 5, 3, 3, 8, 2, 255, 232, 64, 72, 2, 2, 2, 8, 3,
  0, 192, 192, 6, 2, 2, 8, 1, 0, 204, 204, 6, 3, 3, 8, 1,
  254, 204, 0, 48, 4, 1, 1, 8, 2, 0, 240, 5, 3, 3, 8, 2,
  254, 248, 32, 32, 2, 2, 2, 8, 2, 10, 192, 192, 2, 2, 2, 8,
  1, 10, 192, 192, 5, 3, 3, 8, 2, 255, 128, 32, 8, 2, 1, 1,
  8, 3, 5, 192, 1, 3, 3, 8, 4, 255, 128, 128, 128, 6, 2, 2,
  8, 1, 10, 124, 248, 4, 1, 1, 8, 2, 10, 240, 1, 9, 9, 8,
  4, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 2, 2, 2, 8, 5,
  10, 192, 192, 2, 2, 2, 8, 1, 10, 192, 192, 3, 8, 8, 8, 3,
  0, 64, 224, 64, 0, 0, 64, 224, 64, 2, 2, 2, 8, 3, 10, 192,
  192, 2, 2, 2, 8, 3, 10, 192, 192, 4, 9, 9, 8, 2, 0, 224,
  128, 128, 128, 128, 128, 128, 128, 240, 5, 4, 4, 8, 2, 254, 248, 32,
  32, 32, 6, 14, 14, 8, 1, 255, 168, 84, 168, 84, 168, 84, 168, 84,
  168, 84, 168, 84, 168, 84, 6, 14, 14, 8, 1, 255, 168, 84, 168, 84,
  168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 6, 14, 14, 8, 1, 255,
  168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 6, 14,
  14, 8, 1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84,
  168, 84, 6, 14, 14, 8, 1, 255, 168, 84, 168, 84, 168, 84, 168, 84,
  168, 84, 168, 84, 168, 84, 6, 14, 14, 8, 1, 255, 168, 84, 168, 84,
  168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 6, 14, 14, 8, 1, 255,
  168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 6, 14,
  14, 8, 1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84,
  168, 84, 6, 9, 9, 8, 1, 0, 132, 132, 68, 36, 88, 144, 136, 132,
  132, 7, 9, 9, 8, 1, 0, 248, 8, 8, 8, 8, 8, 8, 8, 254,
  6, 9, 9, 8, 1, 0, 96, 16, 16, 16, 8, 24, 40, 68, 132, 6,
  9, 9, 8, 1, 0, 252, 8, 8, 8, 8, 8, 8, 8, 8, 6, 9,
  9, 8, 1, 0, 252, 4, 4, 68, 68, 68, 68, 68, 68, 3, 9, 9,
  8, 2, 0, 224, 32, 32, 32, 32, 32, 32, 32, 32, 5, 9, 9, 8,
  2, 0, 192, 48, 40, 32, 32, 32, 32, 32, 32, 6, 9, 9, 8, 1,
  0, 252, 68, 68, 68, 68, 68, 68, 68, 68, 6, 9, 9, 8, 1, 0,
  140, 148, 132, 132, 132, 132, 132, 132, 252, 3, 4, 4, 8, 2, 5, 224,
  32, 32, 32, 6, 11, 11, 8, 1, 254, 252, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 6, 9, 9, 8, 1, 0, 252, 4, 4, 4, 4, 4,
  4, 4, 248, 5, 11, 11, 8, 2, 0, 128, 128, 248, 8, 8, 8, 8,
  16, 16, 32, 192, 7, 9, 9, 8, 0, 0, 254, 34, 34, 34, 34, 34,
  34, 34, 62, 7, 9, 9, 8, 1, 0, 156, 98, 66, 130, 130, 130, 130,
  130, 142, 3, 11, 11, 8, 2, 254, 224, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 4, 9, 9, 8, 2, 0, 112, 16, 16, 16, 16, 16, 16,
  16, 240, 6, 9, 9, 8, 1, 0, 252, 132, 132, 132, 132, 132, 132, 136,
  240, 7, 9, 9, 8, 0, 0, 18, 18, 18, 18, 18, 18, 18, 18, 254,
  6, 11, 11, 8, 1, 254, 252, 132, 132, 132, 228, 4, 4, 4, 4, 4,
  4, 6, 9, 9, 8, 1, 0, 252, 132, 132, 132, 228, 4, 4, 4, 252,
  5, 11, 11, 8, 2, 254, 136, 136, 144, 160, 192, 128, 128, 128, 128, 128,
  128, 6, 9, 9, 8, 1, 0, 132, 132, 72, 48, 16, 8, 4, 4, 252,
  6, 11, 11, 8, 1, 254, 252, 68, 68, 72, 72, 80, 64, 64, 64, 64,
  64, 6, 9, 9, 8, 1, 0, 252, 4, 4, 4, 4, 4, 4, 4, 4,
  7, 9, 9, 8, 1, 0, 146, 146, 146, 146, 146, 146, 146, 146, 254, 6,
  9, 9, 8, 1, 0, 124, 68, 68, 68, 68, 68, 68, 68, 196, 6, 14,
  14, 8, 1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84,
  168, 84, 6, 14, 14, 8, 1, 255, 168, 84, 168, 84, 168, 84, 168, 84,
  168, 84, 168, 84, 168, 84, 6, 14, 14, 8, 1, 255, 168, 84, 168, 84,
  168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 6, 14, 14, 8, 1, 255,
  168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 6, 14,
  14, 8, 1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84,
  168, 84, 7, 9, 9, 8, 1, 0, 238, 34, 34, 34, 34, 34, 34, 34,
  34, 7, 9, 9, 8, 1, 0, 238, 34, 34, 34, 2, 2, 2, 2, 2,
  7, 4, 4, 8, 1, 5, 238, 34, 34, 34, 3, 3, 3, 8, 4, 9,
  32, 64, 128, 6, 3, 3, 8, 1, 9, 36, 72, 144, 6, 14, 14, 8,
  1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84,
  6, 14, 14, 8, 1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84,
  168, 84, 168, 84, 6, 14, 14, 8, 1, 255, 168, 84, 168, 84, 168, 84,
  168, 84, 168, 84, 168, 84, 168, 84, 6, 14, 14, 8, 1, 255, 168, 84,
  168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 6, 14, 14, 8,
  1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84,
  6, 14, 14, 8, 1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84,
  168, 84, 168, 84, 6, 14, 14, 8, 1, 255, 168, 84, 168, 84, 168, 84,
  168, 84, 168, 84, 168, 84, 168, 84, 6, 14, 14, 8, 1, 255, 168, 84,
  168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 6, 14, 14, 8,
  1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84,
  6, 14, 14, 8, 1, 255, 168, 84, 168, 84, 168, 84, 168, 84, 168, 84,
  168, 84, 168, 84, 6, 14, 14, 8, 1, 255, 168, 84, 168, 84, 168, 84,
  168, 84, 168, 84, 168, 84, 168, 84
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w=16 h=16 x= 4 y=14 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-2
  X Font      ascent =11 descent=-2
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_0_8[4249] U8G_FONT_SECTION("u8g_font_unifont_0_8") = {
  0, 16, 16, 0, 254, 10, 1, 231, 3, 213, 32, 255, 254, 14, 254, 11,
  254, 0, 0, 0, 8, 0, 14, 1, 10, 10, 8, 4, 0, 128, 128, 128,
  128, 128, 128, 128, 0, 128, 128, 5, 4, 4, 8, 2, 8, 136, 136, 136,
  136, 6, 10, 10, 8, 1, 0, 36, 36, 36, 252, 72, 72, 252, 144, 144,
  144, 7, 10, 10, 8, 1, 0, 16, 124, 146, 144, 112, 28, 18, 146, 124,
  16, 7, 10, 10, 8, 1, 0, 98, 148, 148, 104, 16, 16, 44, 82, 82,
  140, 7, 10, 10, 8, 1, 0, 56, 68, 68, 40, 48, 82, 138, 132, 140,
  114, 1, 4, 4, 8, 4, 8, 128, 128, 128, 128, 3, 12, 12, 8, 3,
  255, 32, 64, 64, 128, 128, 128, 128, 128, 128, 64, 64, 32, 3, 12, 12,
  8, 2, 255, 128, 64, 64, 32, 32, 32, 32, 32, 32, 64, 64, 128, 7,
  7, 7, 8, 1, 1, 16, 146, 84, 56, 84, 146, 16, 7, 7, 7, 8,
  1, 1, 16, 16, 16, 254, 16, 16, 16, 2, 4, 4, 8, 3, 254, 192,
  64, 64, 128, 4, 1, 1, 8, 2, 4, 240, 2, 2, 2, 8, 3, 0,
  192, 192, 6, 10, 10, 8, 1, 0, 4, 4, 8, 16, 16, 32, 32, 64,
  128, 128, 6, 10, 10, 8, 1, 0, 48, 72, 132, 132, 132, 132, 132, 132,
  72, 48, 5, 10, 10, 8, 2, 0, 32, 96, 160, 32, 32, 32, 32, 32,
  32, 248, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4, 24, 32, 64, 128,
  128, 252, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4, 56, 4, 4, 132,
  132, 120, 6, 10, 10, 8, 1, 0, 8, 24, 40, 72, 136, 136, 252, 8,
  8, 8, 6, 10, 10, 8, 1, 0, 252, 128, 128, 128, 248, 4, 4, 4,
  132, 120, 6, 10, 10, 8, 1, 0, 56, 64, 128, 128, 248, 132, 132, 132,
  132, 120, 6, 10, 10, 8, 1, 0, 252, 4, 4, 8, 8, 8, 16, 16,
  16, 16, 6, 10, 10, 8, 1, 0, 120, 132, 132, 132, 120, 132, 132, 132,
  132, 120, 6, 10, 10, 8, 1, 0, 120, 132, 132, 132, 124, 4, 4, 4,
  8, 112, 2, 7, 7, 8, 3, 1, 192, 192, 0, 0, 0, 192, 192, 2,
  9, 9, 8, 3, 255, 192, 192, 0, 0, 0, 192, 64, 64, 128, 5, 9,
  9, 8, 2, 0, 8, 16, 32, 64, 128, 64, 32, 16, 8, 6, 5, 5,
  8, 1, 2, 252, 0, 0, 0, 252, 5, 9, 9, 8, 1, 0, 128, 64,
  32, 16, 8, 16, 32, 64, 128, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  4, 8, 16, 16, 0, 16, 16, 6, 10, 10, 8, 1, 0, 56, 68, 148,
  172, 164, 164, 164, 156, 64, 60, 6, 10, 10, 8, 1, 0, 48, 72, 72,
  132, 132, 252, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 248, 132, 132,
  132, 248, 132, 132, 132, 132, 248, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  128, 128, 128, 128, 132, 132, 120, 6, 10, 10, 8, 1, 0, 240, 136, 132,
  132, 132, 132, 132, 132, 136, 240, 6, 10, 10, 8, 1, 0, 252, 128, 128,
  128, 248, 128, 128, 128, 128, 252, 6, 10, 10, 8, 1, 0, 252, 128, 128,
  128, 248, 128, 128, 128, 128, 128, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  128, 128, 156, 132, 132, 140, 116, 6, 10, 10, 8, 1, 0, 132, 132, 132,
  132, 252, 132, 132, 132, 132, 132, 5, 10, 10, 8, 2, 0, 248, 32, 32,
  32, 32, 32, 32, 32, 32, 248, 7, 10, 10, 8, 1, 0, 62, 8, 8,
  8, 8, 8, 8, 136, 136, 112, 6, 10, 10, 8, 1, 0, 132, 136, 144,
  160, 192, 192, 160, 144, 136, 132, 6, 10, 10, 8, 1, 0, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 252, 6, 10, 10, 8, 1, 0, 132, 132, 204,
  204, 180, 180, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 132, 196, 196,
  164, 164, 148, 148, 140, 140, 132, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  132, 132, 132, 132, 132, 132, 120, 6, 10, 10, 8, 1, 0, 248, 132, 132,
  132, 248, 128, 128, 128, 128, 128, 7, 11, 11, 8, 1, 255, 120, 132, 132,
  132, 132, 132, 132, 180, 204, 120, 6, 6, 10, 10, 8, 1, 0, 248, 132,
  132, 132, 248, 144, 136, 136, 132, 132, 6, 10, 10, 8, 1, 0, 120, 132,
  132, 128, 96, 24, 4, 132, 132, 120, 7, 10, 10, 8, 1, 0, 254, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 6, 10, 10, 8, 1, 0, 132, 132,
  132, 132, 132, 132, 132, 132, 132, 120, 7, 10, 10, 8, 1, 0, 130, 130,
  130, 68, 68, 68, 40, 40, 16, 16, 6, 10, 10, 8, 1, 0, 132, 132,
  132, 132, 180, 180, 204, 204, 132, 132, 6, 10, 10, 8, 1, 0, 132, 132,
  72, 72, 48, 48, 72, 72, 132, 132, 7, 10, 10, 8, 1, 0, 130, 130,
  68, 68, 40, 16, 16, 16, 16, 16, 6, 10, 10, 8, 1, 0, 252, 4,
  4, 8, 16, 32, 64, 128, 128, 252, 3, 12, 12, 8, 4, 255, 224, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 224, 6, 10, 10, 8, 1, 0,
  128, 128, 64, 32, 32, 16, 16, 8, 4, 4, 3, 12, 12, 8, 1, 255,
  224, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 224, 6, 3, 3, 8,
  1, 9, 48, 72, 132, 7, 1, 1, 8, 1, 255, 254, 3, 3, 3, 8,
  2, 10, 128, 64, 32, 6, 8, 8, 8, 1, 0, 120, 132, 4, 124, 132,
  132, 140, 116, 6, 11, 11, 8, 1, 0, 128, 128, 128, 184, 196, 132, 132,
  132, 132, 196, 184, 6, 8, 8, 8, 1, 0, 120, 132, 128, 128, 128, 128,
  132, 120, 6, 11, 11, 8, 1, 0, 4, 4, 4, 116, 140, 132, 132, 132,
  132, 140, 116, 6, 8, 8, 8, 1, 0, 120, 132, 132, 252, 128, 128, 132,
  120, 5, 11, 11, 8, 1, 0, 24, 32, 32, 32, 248, 32, 32, 32, 32,
  32, 32, 6, 11, 11, 8, 1, 254, 4, 116, 136, 136, 136, 112, 64, 120,
  132, 132, 120, 6, 11, 11, 8, 1, 0, 128, 128, 128, 184, 196, 132, 132,
  132, 132, 132, 132, 5, 11, 11, 8, 2, 0, 32, 32, 0, 96, 32, 32,
  32, 32, 32, 32, 248, 5, 13, 13, 8, 1, 254, 8, 8, 0, 24, 8,
  8, 8, 8, 8, 8, 8, 144, 96, 6, 11, 11, 8, 1, 0, 128, 128,
  128, 136, 144, 160, 192, 160, 144, 136, 132, 5, 11, 11, 8, 2, 0, 96,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 248, 7, 8, 8, 8, 1, 0,
  236, 146, 146, 146, 146, 146, 146, 146, 6, 8, 8, 8, 1, 0, 184, 196,
  132, 132, 132, 132, 132, 132, 6, 8, 8, 8, 1, 0, 120, 132, 132, 132,
  132, 132, 132, 120, 6, 10, 10, 8, 1, 254, 184, 196, 132, 132, 132, 132,
  196, 184, 128, 128, 6, 10, 10, 8, 1, 254, 116, 140, 132, 132, 132, 132,
  140, 116, 4, 4, 6, 8, 8, 8, 1, 0, 184, 196, 132, 128, 128, 128,
  128, 128, 6, 8, 8, 8, 1, 0, 120, 132, 128, 96, 24, 4, 132, 120,
  5, 10, 10, 8, 1, 0, 32, 32, 32, 248, 32, 32, 32, 32, 32, 24,
  6, 8, 8, 8, 1, 0, 132, 132, 132, 132, 132, 132, 140, 116, 6, 8,
  8, 8, 1, 0, 132, 132, 132, 72, 72, 72, 48, 48, 7, 8, 8, 8,
  1, 0, 130, 146, 146, 146, 146, 146, 146, 108, 6, 8, 8, 8, 1, 0,
  132, 132, 72, 48, 48, 72, 132, 132, 6, 10, 10, 8, 1, 254, 132, 132,
  132, 132, 132, 76, 52, 4, 4, 120, 6, 8, 8, 8, 1, 0, 252, 4,
  8, 16, 32, 64, 128, 252, 3, 12, 12, 8, 3, 255, 96, 128, 128, 64,
  64, 128, 128, 64, 64, 128, 128, 96, 1, 14, 14, 8, 4, 254, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 3, 12, 12, 8,
  2, 255, 192, 32, 32, 64, 64, 32, 32, 64, 64, 32, 32, 192, 7, 3,
  3, 8, 1, 8, 98, 146, 140, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 115, 209, 202, 16, 75, 209, 202, 16, 115,
  223, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 113, 157, 202,
  82, 115, 211, 194, 82, 66, 93, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 73, 157, 202, 82, 122, 93, 202, 80, 73, 145, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 115, 147, 202, 82, 115, 159, 202,
  18, 114, 19, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 75,
  147, 234, 82, 91, 159, 202, 82, 75, 147, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 116, 185, 166, 164, 37, 165, 164, 164, 116, 185, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 75, 209, 234, 16, 91,
  209, 202, 16, 75, 223, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 57, 205, 194, 18, 49, 159, 136, 82, 115, 147, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 121, 205, 194, 18, 121, 159, 192, 82, 123,
  147, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 75, 157, 201,
  32, 121, 25, 201, 4, 73, 57, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 37, 221, 164, 132, 60, 133, 164, 132, 36, 153, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 69, 205, 196, 144, 68, 137, 168,
  132, 16, 153, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 114,
  29, 202, 18, 114, 19, 194, 18, 67, 221, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 114, 19, 202, 18, 114, 19, 194, 18, 67, 205, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 14, 33, 137, 32, 14,
  33, 138, 32, 9, 33, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 57, 221, 194, 2, 49, 141, 136, 80, 115, 159, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 57, 221, 194, 2, 49, 141, 136, 66, 115,
  157, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 113, 207, 202,
  16, 74, 13, 202, 2, 113, 221, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 114, 69, 202, 76, 114, 69, 194, 68, 65, 143, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 114, 93, 202, 66, 114, 77, 194,
  80, 65, 159, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 59,
  157, 193, 32, 49, 25, 137, 4, 113, 57, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 57, 211, 194, 18, 66, 31, 194, 18, 57, 211, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 34, 137, 182, 136, 42,
  169, 162, 216, 34, 137, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 59, 141, 194, 82, 51, 159, 138, 18, 114, 19, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 123, 141, 194, 82, 123, 159, 194, 18, 122,
  19, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 57, 143, 194,
  80, 50, 77, 138, 66, 113, 157, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 51, 155, 196, 34, 37, 163, 148, 162, 99, 155, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 57, 221, 194, 8, 50, 9, 138,
  8, 113, 221, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 57,
  221, 194, 8, 65, 137, 192, 72, 59, 157, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 14, 249, 144, 32, 12, 33, 130, 32, 28, 33, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 49, 207, 202, 16, 73,
  145, 200, 80, 51, 143, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 28, 137, 146, 216, 28, 169, 144, 136, 16, 137, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 51, 143, 202, 80, 123, 145, 202, 16, 74,
  15, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 6, 13, 13,
  8, 1, 0, 96, 24, 0, 252, 128, 128, 128, 248, 128, 128, 128, 128, 252,
  6, 14, 14, 8, 1, 0, 72, 72, 0, 0, 252, 128, 128, 128, 248, 128,
  128, 128, 128, 252, 7, 10, 10, 8, 1, 0, 252, 32, 32, 32, 60, 34,
  34, 34, 34, 44, 6, 14, 14, 8, 1, 0, 24, 96, 0, 0, 252, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 6, 10, 10, 8, 1, 0, 56, 68,
  128, 128, 248, 128, 128, 128, 68, 56, 6, 10, 10, 8, 1, 0, 120, 132,
  132, 128, 96, 24, 4, 132, 132, 120, 5, 10, 10, 8, 2, 0, 248, 32,
  32, 32, 32, 32, 32, 32, 32, 248, 5, 14, 14, 8, 2, 0, 144, 144,
  0, 0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 248, 6, 10, 10, 8,
  1, 0, 28, 8, 8, 8, 8, 8, 8, 136, 136, 112, 8, 10, 10, 8,
  0, 0, 120, 72, 72, 72, 78, 73, 73, 73, 73, 142, 7, 10, 10, 8,
  1, 0, 144, 144, 144, 144, 252, 146, 146, 146, 146, 156, 7, 10, 10, 8,
  1, 0, 252, 32, 32, 32, 60, 34, 34, 34, 34, 34, 6, 14, 14, 8,
  1, 0, 24, 96, 0, 0, 128, 140, 144, 160, 192, 192, 160, 144, 136, 132,
  6, 13, 13, 8, 1, 0, 96, 24, 0, 132, 140, 140, 148, 148, 164, 164,
  196, 196, 132, 7, 14, 14, 8, 1, 0, 132, 132, 120, 0, 130, 130, 68,
  68, 40, 40, 16, 16, 32, 96, 7, 12, 12, 8, 1, 254, 130, 130, 130,
  130, 130, 130, 130, 130, 130, 254, 16, 16, 6, 10, 10, 8, 1, 0, 48,
  72, 72, 132, 132, 252, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 248,
  128, 128, 128, 248, 132, 132, 132, 132, 248, 6, 10, 10, 8, 1, 0, 248,
  132, 132, 132, 248, 132, 132, 132, 132, 248, 6, 10, 10, 8, 1, 0, 252,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 8, 12, 12, 8, 0, 254, 14,
  18, 18, 18, 34, 34, 34, 66, 66, 255, 129, 129, 6, 10, 10, 8, 1,
  0, 252, 128, 128, 128, 248, 128, 128, 128, 128, 252, 7, 10, 10, 8, 1,
  0, 146, 146, 84, 84, 56, 56, 84, 84, 146, 146, 6, 10, 10, 8, 1,
  0, 120, 132, 4, 4, 120, 8, 4, 4, 132, 120, 6, 10, 10, 8, 1,
  0, 132, 140, 140, 148, 148, 164, 164, 196, 196, 132, 6, 13, 13, 8, 1,
  0, 72, 48, 0, 132, 140, 140, 148, 148, 164, 164, 196, 196, 132, 6, 10,
  10, 8, 1, 0, 140, 144, 144, 160, 160, 192, 160, 144, 136, 132, 6, 10,
  10, 8, 1, 0, 60, 36, 36, 36, 36, 36, 36, 68, 68, 132, 6, 10,
  10, 8, 1, 0, 132, 132, 204, 204, 180, 180, 132, 132, 132, 132, 6, 10,
  10, 8, 1, 0, 132, 132, 132, 132, 252, 132, 132, 132, 132, 132, 6, 10,
  10, 8, 1, 0, 120, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 10,
  10, 8, 1, 0, 252, 132, 132, 132, 132, 132, 132, 132, 132, 132, 6, 10,
  10, 8, 1, 0, 248, 132, 132, 132, 248, 128, 128, 128, 128, 128, 6, 10,
  10, 8, 1, 0, 120, 132, 132, 128, 128, 128, 128, 132, 132, 120, 7, 10,
  10, 8, 1, 0, 254, 16, 16, 16, 16, 16, 16, 16, 16, 16, 7, 10,
  10, 8, 1, 0, 130, 130, 68, 68, 40, 40, 16, 16, 32, 96, 7, 11,
  11, 8, 1, 0, 16, 124, 146, 146, 146, 146, 146, 124, 16, 16, 16, 6,
  10, 10, 8, 1, 0, 132, 132, 72, 72, 48, 48, 72, 72, 132, 132, 7,
  12, 12, 8, 1, 254, 132, 132, 132, 132, 132, 132, 132, 132, 132, 254, 2,
  2, 6, 10, 10, 8, 1, 0, 132, 132, 132, 132, 132, 252, 4, 4, 4,
  4, 7, 10, 10, 8, 1, 0, 146, 146, 146, 146, 146, 146, 146, 146, 146,
  254, 8, 12, 12, 8, 0, 254, 146, 146, 146, 146, 146, 146, 146, 146, 146,
  255, 1, 1, 7, 10, 10, 8, 1, 0, 224, 32, 32, 32, 60, 34, 34,
  34, 34, 60, 6, 10, 10, 8, 1, 0, 132, 132, 132, 132, 228, 148, 148,
  148, 148, 228, 6, 10, 10, 8, 1, 0, 128, 128, 128, 128, 248, 132, 132,
  132, 132, 248, 6, 10, 10, 8, 1, 0, 112, 136, 4, 4, 124, 4, 4,
  4, 136, 112, 6, 10, 10, 8, 1, 0, 152, 164, 164, 164, 228, 164, 164,
  164, 164, 152, 6, 10, 10, 8, 1, 0, 124, 132, 132, 132, 124, 36, 68,
  68, 132, 132, 6, 8, 8, 8, 1, 0, 120, 132, 4, 124, 132, 132, 140,
  116, 6, 12, 12, 8, 1, 0, 4, 56, 64, 128, 248, 132, 132, 132, 132,
  132, 132, 120, 6, 8, 8, 8, 1, 0, 248, 132, 132, 248, 132, 132, 132,
  248, 6, 8, 8, 8, 1, 0, 252, 128, 128, 128, 128, 128, 128, 128, 7,
  9, 9, 8, 1, 255, 60, 36, 68, 68, 132, 132, 132, 254, 130, 6, 8,
  8, 8, 1, 0, 120, 132, 132, 252, 128, 128, 132, 120, 7, 8, 8, 8,
  1, 0, 146, 146, 84, 56, 56, 84, 146, 146, 6, 8, 8, 8, 1, 0,
  120, 132, 4, 120, 8, 4, 132, 120, 6, 8, 8, 8, 1, 0, 140, 140,
  148, 148, 164, 164, 196, 196, 6, 12, 12, 8, 1, 0, 72, 48, 0, 0,
  140, 140, 148, 148, 164, 164, 196, 196, 6, 8, 8, 8, 1, 0, 140, 144,
  160, 192, 160, 144, 136, 132, 6, 8, 8, 8, 1, 0, 60, 36, 36, 36,
  36, 68, 68, 132, 6, 8, 8, 8, 1, 0, 132, 204, 204, 180, 180, 132,
  132, 132, 6, 8, 8, 8, 1, 0, 132, 132, 132, 252, 132, 132, 132, 132,
  6, 8, 8, 8, 1, 0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 8,
  8, 8, 1, 0, 252, 132, 132, 132, 132, 132, 132, 132, 6, 10, 10, 8,
  1, 254, 184, 196, 132, 132, 132, 132, 196, 184, 128, 128, 6, 8, 8, 8,
  1, 0, 120, 132, 128, 128, 128, 128, 132, 120, 7, 8, 8, 8, 1, 0,
  254, 16, 16, 16, 16, 16, 16, 16, 6, 10, 10, 8, 1, 254, 132, 132,
  72, 72, 48, 48, 32, 32, 64, 192, 7, 13, 13, 8, 1, 254, 16, 16,
  16, 124, 146, 146, 146, 146, 146, 146, 124, 16, 16, 6, 8, 8, 8, 1,
  0, 132, 132, 72, 48, 48, 72, 132, 132, 7, 10, 10, 8, 1, 254, 132,
  132, 132, 132, 132, 132, 132, 254, 2, 2, 6, 8, 8, 8, 1, 0, 132,
  132, 132, 132, 252, 4, 4, 4, 7, 8, 8, 8, 1, 0, 146, 146, 146,
  146, 146, 146, 146, 254, 8, 10, 10, 8, 0, 254, 146, 146, 146, 146, 146,
  146, 146, 255, 1, 1, 7, 8, 8, 8, 1, 0, 224, 32, 32, 60, 34,
  34, 34, 60, 6, 8, 8, 8, 1, 0, 132, 132, 132, 228, 148, 148, 148,
  228, 6, 8, 8, 8, 1, 0, 128, 128, 128, 248, 132, 132, 132, 248, 6,
  8, 8, 8, 1, 0, 112, 136, 4, 124, 4, 4, 136, 112, 6, 8, 8,
  8, 1, 0, 152, 164, 164, 228, 164, 164, 164, 152, 6, 8, 8, 8, 1,
  0, 124, 132, 132, 132, 124, 36, 68, 132, 6, 12, 12, 8, 1, 0, 96,
  24, 0, 0, 120, 132, 132, 252, 128, 128, 132, 120, 6, 12, 12, 8, 1,
  0, 72, 72, 0, 0, 120, 132, 132, 252, 128, 128, 132, 120, 7, 13, 13,
  8, 0, 254, 64, 240, 64, 92, 98, 66, 66, 66, 66, 66, 66, 2, 12,
  6, 12, 12, 8, 1, 0, 24, 96, 0, 0, 252, 128, 128, 128, 128, 128,
  128, 128, 6, 8, 8, 8, 1, 0, 56, 68, 128, 248, 128, 128, 68, 56,
  6, 8, 8, 8, 1, 0, 120, 132, 128, 96, 24, 4, 132, 120, 5, 11,
  11, 8, 2, 0, 32, 32, 0, 96, 32, 32, 32, 32, 32, 32, 248, 5,
  11, 11, 8, 2, 0, 144, 144, 0, 96, 32, 32, 32, 32, 32, 32, 248,
  5, 13, 13, 8, 1, 254, 8, 8, 0, 24, 8, 8, 8, 8, 8, 8,
  8, 144, 96, 8, 8, 8, 8, 0, 0, 120, 72, 72, 78, 73, 73, 73,
  142, 7, 8, 8, 8, 1, 0, 144, 144, 144, 252, 146, 146, 146, 156, 7,
  11, 11, 8, 0, 0, 64, 240, 64, 92, 98, 66, 66, 66, 66, 66, 66,
  6, 12, 12, 8, 1, 0, 24, 96, 0, 0, 140, 144, 160, 192, 160, 144,
  136, 132, 6, 12, 12, 8, 1, 0, 96, 24, 0, 0, 140, 140, 148, 148,
  164, 164, 196, 196, 6, 15, 15, 8, 1, 254, 132, 132, 120, 0, 0, 132,
  132, 72, 72, 48, 48, 32, 32, 64, 192, 5, 10, 10, 8, 2, 254, 136,
  136, 136, 136, 136, 136, 136, 248, 32, 32
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 8, '1' Height: 7
  Calculated Max Values w=16 h=16 x= 9 y=11 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 8 descent= 2
  X Font      ascent =13 descent= 0
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_12_13[3987] U8G_FONT_SECTION("u8g_font_unifont_12_13") = {
  0, 16, 16, 0, 254, 8, 4, 155, 6, 11, 0, 255, 2, 14, 254, 13,
  0, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 74, 81, 234, 80, 90, 81, 201, 158, 0, 1, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 85, 85, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  4, 42, 13, 170, 12, 53, 245, 128, 0, 0, 1, 170, 170, 16, 16, 32,
  16, 0, 254, 85, 85, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 0, 1, 142, 0, 14, 25, 135, 224, 0, 1, 128, 0, 0,
  1, 170, 170, 16, 16, 32, 16, 0, 254, 85, 85, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 0, 25, 128, 36, 0, 69, 129, 68, 1, 73, 158,
  240, 0, 1, 128, 0, 0, 1, 170, 170, 16, 16, 32, 16, 0, 254, 85,
  85, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 1, 149, 130, 124, 2, 1, 191, 0, 0, 1, 170, 170, 16,
  16, 32, 16, 0, 254, 85, 85, 128, 0, 0, 1, 136, 4, 22, 25, 161,
  224, 0, 1, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 0, 1, 170, 170, 12, 14, 28, 16, 1, 255, 1, 80, 225, 80, 33,
  160, 17, 0, 17, 0, 9, 0, 8, 0, 4, 224, 4, 128, 2, 128, 3,
  0, 3, 0, 2, 0, 2, 0, 11, 15, 30, 16, 1, 255, 0, 64, 0,
  128, 225, 0, 33, 64, 16, 128, 17, 32, 8, 192, 8, 0, 4, 224, 4,
  128, 2, 128, 3, 0, 3, 0, 2, 0, 2, 0, 12, 7, 14, 16, 2,
  3, 1, 144, 58, 96, 202, 192, 17, 64, 16, 64, 32, 128, 31, 0, 5,
  10, 10, 8, 1, 1, 8, 8, 80, 16, 32, 32, 64, 64, 136, 160, 7,
  10, 10, 8, 1, 1, 8, 8, 80, 16, 32, 32, 64, 66, 136, 160, 10,
  10, 20, 16, 3, 2, 48, 0, 48, 0, 6, 0, 9, 0, 7, 0, 1,
  0, 14, 0, 240, 128, 0, 64, 0, 64, 2, 4, 4, 8, 3, 3, 64,
  128, 192, 192, 5, 4, 4, 8, 1, 2, 24, 48, 64, 128, 12, 4, 8,
  16, 3, 1, 112, 0, 136, 0, 136, 48, 127, 192, 7, 11, 11, 16, 2,
  0, 24, 32, 32, 24, 32, 76, 82, 98, 36, 88, 128, 6, 4, 4, 8,
  2, 9, 24, 36, 228, 88, 9, 6, 12, 16, 4, 7, 3, 0, 4, 0,
  39, 128, 56, 0, 64, 0, 128, 0, 10, 5, 10, 16, 3, 8, 252, 64,
  16, 64, 32, 128, 71, 0, 64, 0, 11, 4, 8, 16, 2, 9, 24, 32,
  36, 32, 228, 64, 89, 128, 10, 4, 8, 16, 3, 8, 0, 64, 254, 64,
  1, 64, 0, 128, 7, 4, 4, 16, 4, 9, 64, 92, 98, 252, 8, 6,
  6, 16, 3, 8, 40, 40, 40, 104, 128, 127, 3, 5, 5, 16, 6, 8,
  32, 0, 32, 32, 192, 4, 2, 2, 16, 6, 10, 48, 192, 5, 5, 5,
  16, 5, 8, 16, 40, 48, 96, 144, 4, 13, 13, 16, 6, 254, 240, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 192, 2, 5, 5, 8, 3,
  2, 64, 128, 192, 0, 192, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1,
  128, 0, 0, 1, 178, 34, 74, 55, 250, 42, 74, 35, 203, 162, 0, 1,
  128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 14, 14, 28, 16,
  1, 255, 255, 252, 231, 156, 219, 124, 219, 28, 219, 108, 231, 156, 255, 252,
  255, 252, 247, 28, 231, 108, 247, 108, 247, 108, 227, 28, 255, 252, 3, 3,
  3, 16, 7, 0, 64, 0, 160, 7, 9, 9, 8, 1, 2, 124, 130, 128,
  64, 32, 16, 16, 0, 16, 6, 8, 8, 8, 1, 255, 24, 164, 144, 136,
  112, 32, 80, 32, 4, 5, 5, 8, 2, 2, 112, 128, 240, 64, 128, 7,
  10, 10, 8, 1, 3, 2, 124, 128, 16, 16, 16, 16, 16, 16, 16, 3,
  11, 11, 8, 2, 3, 96, 128, 96, 128, 32, 32, 32, 32, 32, 32, 32,
  6, 13, 13, 8, 1, 255, 24, 32, 24, 32, 0, 24, 36, 36, 60, 4,
  8, 144, 96, 3, 12, 12, 8, 3, 254, 64, 64, 64, 64, 64, 64, 64,
  0, 96, 128, 96, 128, 6, 11, 11, 8, 1, 255, 48, 64, 48, 64, 0,
  140, 144, 144, 140, 132, 120, 1, 8, 8, 8, 4, 3, 128, 128, 128, 128,
  128, 128, 128, 128, 6, 7, 7, 8, 1, 0, 8, 68, 132, 120, 0, 0,
  16, 5, 8, 8, 8, 2, 3, 144, 0, 0, 96, 144, 136, 136, 112, 6,
  7, 7, 8, 1, 3, 40, 0, 0, 8, 68, 132, 120, 6, 9, 9, 8,
  1, 3, 32, 0, 80, 0, 0, 8, 68, 132, 120, 6, 8, 8, 8, 1,
  254, 252, 32, 64, 128, 144, 128, 68, 56, 6, 8, 8, 8, 1, 254, 252,
  32, 64, 128, 128, 128, 68, 56, 6, 11, 11, 8, 1, 254, 32, 0, 0,
  252, 32, 64, 128, 128, 128, 68, 56, 6, 5, 5, 8, 1, 3, 16, 8,
  4, 132, 248, 6, 7, 7, 8, 1, 3, 64, 0, 16, 8, 4, 132, 248,
  6, 7, 7, 8, 1, 255, 8, 4, 4, 4, 8, 144, 96, 6, 10, 10,
  8, 1, 255, 32, 0, 0, 8, 4, 4, 4, 8, 144, 96, 7, 7, 7,
  8, 1, 255, 2, 42, 42, 188, 144, 144, 96, 7, 12, 12, 8, 1, 255,
  16, 0, 36, 0, 0, 2, 42, 42, 188, 144, 144, 96, 7, 6, 6, 8,
  1, 0, 12, 50, 156, 144, 144, 96, 7, 9, 9, 8, 1, 0, 8, 0,
  0, 12, 50, 156, 144, 144, 96, 6, 8, 8, 8, 1, 3, 64, 64, 64,
  64, 88, 100, 68, 248, 6, 8, 8, 8, 1, 3, 64, 72, 64, 64, 88,
  100, 68, 248, 6, 9, 9, 8, 1, 254, 48, 72, 64, 56, 64, 128, 128,
  132, 120, 6, 12, 12, 8, 1, 254, 16, 0, 0, 48, 72, 64, 56, 64,
  128, 128, 132, 120, 7, 9, 9, 8, 0, 3, 80, 4, 8, 16, 32, 64,
  60, 130, 126, 7, 12, 12, 8, 0, 255, 4, 8, 16, 32, 64, 60, 130,
  126, 0, 40, 0, 16, 6, 10, 10, 8, 1, 255, 64, 160, 160, 8, 148,
  144, 136, 132, 132, 120, 6, 9, 9, 8, 1, 255, 160, 0, 8, 148, 144,
  136, 132, 132, 120, 6, 10, 10, 8, 1, 255, 64, 0, 160, 8, 148, 144,
  136, 132, 132, 120, 8, 1, 1, 8, 0, 3, 255, 6, 8, 8, 8, 1,
  3, 16, 0, 12, 20, 12, 132, 132, 120, 6, 10, 10, 8, 1, 0, 72,
  0, 0, 56, 36, 20, 76, 132, 136, 112, 6, 8, 8, 8, 1, 3, 4,
  20, 36, 20, 68, 132, 132, 120, 6, 11, 11, 8, 1, 0, 4, 4, 4,
  4, 4, 4, 68, 132, 132, 136, 120, 5, 8, 8, 8, 2, 254, 112, 24,
  120, 128, 128, 128, 128, 128, 6, 9, 9, 8, 1, 0, 32, 0, 0, 8,
  68, 132, 132, 136, 112, 10, 9, 18, 16, 1, 1, 4, 0, 3, 0, 6,
  128, 10, 64, 10, 64, 6, 64, 25, 128, 96, 0, 128, 0, 6, 8, 8,
  8, 1, 255, 24, 36, 36, 60, 4, 8, 144, 96, 6, 7, 7, 8, 1,
  255, 8, 148, 144, 136, 132, 132, 120, 6, 8, 8, 8, 1, 254, 8, 148,
  144, 136, 132, 120, 0, 80, 4, 4, 4, 8, 2, 9, 48, 192, 48, 192,
  5, 5, 5, 8, 2, 8, 24, 24, 200, 80, 224, 4, 4, 4, 8, 2,
  0, 32, 192, 48, 192, 4, 2, 2, 8, 2, 9, 48, 192, 4, 6, 6,
  8, 2, 6, 64, 160, 160, 112, 64, 128, 4, 2, 2, 8, 2, 254, 48,
  192, 5, 4, 4, 8, 1, 7, 8, 40, 176, 192, 4, 4, 4, 8, 2,
  7, 96, 144, 144, 96, 7, 3, 3, 8, 1, 9, 2, 124, 128, 3, 4,
  4, 8, 2, 10, 96, 128, 96, 128, 3, 4, 4, 8, 2, 254, 96, 128,
  96, 128, 2, 3, 3, 16, 9, 254, 128, 64, 64, 5, 5, 5, 16, 5,
  9, 8, 16, 32, 224, 96, 4, 3, 3, 16, 6, 9, 144, 144, 96, 4,
  1, 1, 16, 6, 10, 240, 5, 4, 4, 16, 5, 9, 136, 80, 32, 32,
  5, 4, 4, 16, 5, 9, 32, 32, 80, 136, 2, 2, 2, 16, 7, 0,
  192, 192, 5, 5, 5, 16, 5, 9, 96, 224, 32, 16, 8, 4, 4, 4,
  16, 6, 9, 144, 96, 96, 144, 4, 5, 5, 8, 2, 254, 112, 128, 240,
  64, 128, 3, 3, 3, 8, 2, 5, 64, 224, 64, 4, 9, 9, 8, 2,
  2, 128, 128, 64, 64, 32, 32, 16, 16, 16, 5, 9, 9, 8, 2, 2,
  136, 144, 96, 64, 32, 32, 16, 16, 16, 7, 9, 9, 8, 1, 2, 146,
  164, 120, 64, 32, 32, 16, 16, 16, 6, 9, 9, 8, 1, 2, 8, 16,
  32, 64, 48, 64, 128, 132, 120, 6, 9, 9, 8, 1, 2, 48, 72, 72,
  132, 132, 132, 132, 72, 48, 7, 9, 9, 8, 1, 2, 128, 120, 8, 8,
  4, 4, 4, 2, 2, 7, 9, 9, 8, 1, 2, 130, 130, 68, 68, 40,
  40, 16, 16, 16, 7, 9, 9, 8, 1, 2, 16, 16, 16, 40, 40, 68,
  68, 130, 130, 7, 9, 9, 8, 1, 2, 48, 72, 136, 152, 104, 4, 4,
  2, 2, 5, 10, 10, 8, 1, 2, 8, 8, 144, 144, 32, 32, 72, 72,
  128, 128, 4, 4, 4, 8, 2, 1, 16, 16, 16, 224, 2, 4, 4, 8,
  3, 7, 192, 192, 64, 128, 7, 6, 6, 8, 1, 3, 16, 16, 254, 56,
  108, 68, 6, 4, 4, 8, 1, 3, 8, 68, 132, 120, 6, 7, 7, 8,
  1, 0, 56, 36, 20, 76, 132, 136, 112, 1, 4, 4, 8, 4, 7, 128,
  128, 128, 128, 5, 11, 11, 8, 2, 3, 16, 40, 120, 128, 32, 32, 32,
  32, 32, 32, 32, 6, 11, 11, 8, 1, 3, 12, 16, 76, 176, 0, 16,
  16, 16, 16, 16, 16, 6, 12, 12, 8, 1, 254, 16, 16, 16, 16, 16,
  16, 16, 0, 12, 16, 76, 176, 3, 4, 4, 8, 2, 10, 96, 128, 96,
  128, 5, 11, 11, 8, 2, 3, 24, 32, 24, 32, 128, 128, 128, 128, 128,
  128, 128, 7, 13, 13, 8, 1, 255, 6, 8, 6, 8, 0, 24, 36, 36,
  60, 4, 8, 144, 96, 7, 13, 13, 8, 1, 255, 102, 104, 38, 72, 128,
  24, 36, 36, 60, 4, 8, 144, 96, 7, 11, 11, 8, 1, 255, 6, 8,
  6, 8, 0, 140, 144, 144, 140, 132, 120, 6, 9, 9, 8, 1, 3, 64,
  64, 112, 112, 0, 8, 68, 132, 120, 6, 9, 9, 8, 1, 3, 32, 0,
  32, 0, 0, 8, 68, 132, 120, 6, 8, 8, 8, 1, 255, 8, 68, 132,
  120, 0, 16, 0, 16, 6, 10, 10, 8, 1, 0, 40, 0, 0, 8, 68,
  132, 120, 16, 40, 16, 6, 9, 9, 8, 1, 3, 80, 0, 32, 0, 0,
  8, 68, 132, 120, 6, 8, 8, 8, 1, 255, 8, 68, 132, 120, 0, 40,
  0, 16, 6, 9, 9, 8, 1, 3, 80, 0, 80, 0, 0, 8, 68, 132,
  120, 6, 8, 8, 8, 1, 255, 8, 68, 132, 120, 0, 40, 0, 40, 6,
  13, 13, 8, 1, 254, 48, 64, 48, 64, 0, 252, 32, 64, 128, 128, 128,
  68, 56, 6, 13, 13, 8, 1, 254, 32, 0, 32, 0, 0, 252, 32, 64,
  128, 128, 128, 68, 56, 6, 8, 8, 8, 1, 254, 252, 32, 64, 128, 168,
  128, 68, 56, 6, 8, 8, 8, 1, 254, 252, 32, 64, 144, 128, 144, 68,
  56, 6, 13, 13, 8, 1, 254, 32, 0, 72, 0, 0, 252, 32, 64, 128,
  128, 128, 68, 56, 6, 8, 8, 8, 1, 254, 252, 64, 128, 168, 128, 144,
  68, 56, 6, 8, 8, 8, 1, 254, 252, 64, 128, 168, 128, 168, 68, 56,
  6, 10, 10, 8, 1, 3, 64, 64, 112, 112, 0, 16, 8, 4, 132, 248,
  6, 8, 8, 8, 1, 0, 16, 8, 4, 132, 248, 16, 40, 16, 6, 7,
  7, 8, 1, 1, 16, 8, 4, 132, 248, 0, 16, 6, 12, 12, 8, 1,
  1, 64, 64, 112, 112, 0, 16, 8, 4, 132, 248, 0, 16, 6, 8, 8,
  8, 1, 3, 80, 0, 0, 16, 8, 4, 132, 248, 6, 7, 7, 8, 1,
  1, 16, 8, 4, 132, 248, 0, 80, 6, 9, 9, 8, 1, 3, 32, 0,
  80, 0, 16, 8, 4, 132, 248, 6, 9, 9, 8, 1, 3, 80, 0, 32,
  0, 16, 8, 4, 132, 248, 6, 9, 9, 8, 1, 3, 80, 0, 80, 0,
  16, 8, 4, 132, 248, 6, 13, 13, 8, 1, 255, 16, 16, 28, 28, 0,
  0, 8, 4, 4, 4, 8, 144, 96, 7, 13, 13, 8, 1, 255, 34, 20,
  8, 8, 0, 0, 8, 4, 4, 4, 8, 144, 96, 6, 8, 8, 8, 1,
  254, 8, 4, 4, 4, 8, 152, 116, 8, 6, 7, 7, 8, 1, 255, 8,
  4, 4, 4, 8, 144, 100, 7, 8, 8, 8, 1, 254, 16, 8, 8, 8,
  16, 144, 106, 4, 6, 7, 7, 8, 1, 255, 8, 4, 4, 36, 8, 144,
  100, 6, 10, 10, 8, 1, 255, 36, 0, 0, 8, 4, 4, 4, 8, 144,
  96, 6, 12, 12, 8, 1, 255, 16, 0, 40, 0, 0, 8, 4, 4, 4,
  8, 144, 96, 6, 12, 12, 8, 1, 255, 36, 0, 36, 0, 0, 8, 4,
  4, 4, 8, 144, 96, 7, 10, 10, 8, 1, 0, 8, 0, 0, 2, 42,
  42, 188, 144, 148, 96, 7, 8, 8, 8, 1, 255, 2, 42, 42, 188, 160,
  170, 64, 4, 7, 13, 13, 8, 1, 255, 16, 0, 36, 0, 0, 2, 42,
  42, 188, 160, 170, 64, 4, 7, 6, 6, 8, 1, 0, 12, 50, 156, 160,
  170, 64, 7, 11, 11, 8, 1, 0, 16, 0, 36, 0, 0, 12, 50, 156,
  144, 144, 96, 6, 8, 8, 8, 1, 3, 72, 64, 84, 64, 88, 100, 68,
  248, 6, 14, 14, 8, 1, 254, 32, 0, 72, 0, 0, 48, 72, 64, 56,
  64, 128, 128, 132, 120, 6, 6, 6, 8, 1, 3, 12, 20, 12, 132, 132,
  120, 6, 8, 8, 8, 1, 1, 12, 20, 12, 132, 132, 120, 0, 16, 6,
  11, 11, 8, 1, 1, 8, 0, 0, 12, 20, 12, 132, 132, 120, 0, 16,
  6, 10, 10, 8, 1, 3, 16, 0, 36, 0, 12, 20, 12, 132, 132, 120,
  6, 10, 10, 8, 1, 255, 12, 20, 12, 132, 132, 120, 0, 72, 0, 32,
  6, 10, 10, 8, 1, 3, 20, 0, 20, 0, 12, 20, 12, 132, 132, 120,
  6, 10, 10, 8, 1, 0, 8, 0, 0, 56, 36, 20, 76, 132, 136, 112,
  6, 12, 12, 8, 1, 0, 32, 0, 72, 0, 0, 56, 36, 20, 76, 132,
  136, 112, 7, 8, 8, 8, 0, 3, 4, 8, 16, 32, 64, 60, 130, 126,
  14, 8, 16, 16, 1, 3, 0, 48, 0, 192, 3, 0, 12, 0, 16, 0,
  15, 248, 128, 4, 127, 248, 7, 8, 8, 8, 0, 3, 4, 12, 26, 36,
  64, 60, 130, 126, 6, 10, 10, 8, 1, 3, 16, 0, 4, 20, 36, 20,
  68, 132, 132, 120, 6, 11, 11, 8, 1, 3, 32, 0, 80, 4, 20, 36,
  20, 68, 132, 132, 120, 6, 12, 12, 8, 1, 255, 4, 20, 36, 20, 68,
  132, 132, 120, 0, 40, 0, 16, 7, 10, 10, 8, 0, 3, 8, 16, 36,
  72, 16, 32, 64, 60, 130, 126, 7, 10, 10, 8, 0, 3, 8, 16, 36,
  76, 26, 36, 64, 60, 130, 126, 7, 10, 10, 8, 0, 3, 80, 6, 24,
  98, 12, 48, 64, 60, 130, 126, 7, 12, 12, 8, 0, 1, 8, 16, 36,
  72, 16, 32, 64, 60, 130, 126, 0, 40, 7, 14, 14, 8, 0, 255, 8,
  16, 36, 72, 16, 32, 64, 60, 130, 126, 0, 16, 0, 16, 7, 11, 11,
  8, 0, 3, 64, 0, 166, 24, 98, 12, 48, 64, 60, 130, 126, 7, 14,
  14, 8, 1, 0, 34, 20, 8, 8, 0, 4, 4, 4, 4, 68, 132, 132,
  136, 120, 6, 13, 13, 8, 1, 0, 4, 0, 4, 4, 4, 4, 4, 4,
  68, 132, 132, 136, 120, 7, 14, 14, 8, 1, 0, 8, 0, 18, 0, 4,
  4, 4, 4, 4, 68, 132, 132, 136, 120, 6, 13, 13, 8, 1, 254, 4,
  4, 4, 4, 4, 4, 68, 132, 120, 0, 40, 0, 16, 6, 11, 11, 8,
  1, 254, 16, 0, 0, 8, 68, 132, 132, 136, 112, 0, 16, 6, 6, 6,
  8, 1, 0, 8, 68, 132, 132, 136, 112, 6, 12, 12, 8, 1, 0, 32,
  32, 56, 56, 0, 0, 8, 68, 132, 132, 136, 112, 6, 11, 11, 8, 1,
  254, 16, 0, 0, 8, 68, 132, 132, 136, 120, 20, 8, 6, 11, 11, 8,
  1, 0, 32, 0, 72, 0, 0, 8, 68, 132, 132, 136, 112, 6, 6, 6,
  8, 1, 2, 32, 88, 84, 52, 72, 128, 6, 11, 11, 8, 1, 254, 32,
  0, 0, 252, 64, 128, 168, 128, 144, 68, 56, 4, 10, 10, 8, 2, 3,
  96, 128, 96, 128, 0, 64, 96, 144, 144, 240, 6, 3, 3, 8, 1, 2,
  32, 92, 128, 6, 8, 8, 8, 1, 2, 48, 64, 48, 64, 0, 32, 92,
  128, 6, 6, 6, 8, 1, 2, 80, 0, 0, 32, 92, 128, 6, 8, 8,
  8, 1, 255, 24, 36, 36, 28, 68, 164, 72, 240, 6, 8, 8, 8, 1,
  255, 24, 36, 36, 60, 4, 56, 144, 96, 6, 13, 13, 8, 1, 255, 68,
  40, 16, 16, 0, 24, 36, 36, 60, 4, 8, 144, 96, 6, 14, 14, 8,
  1, 255, 32, 80, 80, 56, 32, 64, 152, 36, 36, 60, 4, 8, 144, 96,
  6, 12, 12, 8, 1, 255, 16, 8, 8, 0, 24, 36, 36, 60, 4, 8,
  144, 96, 6, 12, 12, 8, 1, 255, 16, 40, 68, 0, 24, 36, 36, 60,
  4, 8, 144, 96, 6, 11, 11, 8, 1, 255, 40, 0, 0, 24, 36, 36,
  60, 4, 8, 144, 96, 6, 13, 13, 8, 1, 255, 16, 0, 36, 0, 0,
  24, 36, 36, 60, 4, 8, 144, 96, 6, 7, 7, 8, 1, 255, 8, 148,
  144, 136, 132, 132, 120, 7, 7, 7, 8, 0, 255, 4, 42, 104, 164, 34,
  34, 28, 6, 12, 12, 8, 1, 255, 136, 80, 32, 32, 0, 8, 148, 144,
  136, 132, 132, 120, 6, 11, 11, 8, 1, 255, 16, 0, 0, 24, 36, 36,
  60, 4, 8, 144, 96, 6, 9, 9, 8, 1, 254, 24, 164, 144, 136, 112,
  0, 32, 0, 32, 6, 9, 9, 8, 1, 254, 24, 164, 144, 136, 112, 0,
  80, 0, 32, 7, 6, 6, 8, 1, 255, 16, 40, 32, 64, 128, 254, 7,
  10, 10, 8, 1, 255, 96, 128, 96, 128, 16, 40, 32, 64, 128, 254, 4,
  1, 1, 8, 2, 3, 240, 4, 5, 5, 8, 2, 3, 64, 96, 144, 144,
  240, 11, 5, 10, 16, 3, 9, 16, 64, 18, 224, 127, 224, 128, 0, 254,
  0, 10, 5, 10, 16, 3, 9, 18, 64, 17, 0, 127, 0, 128, 0, 254,
  0, 6, 4, 4, 16, 5, 9, 8, 20, 60, 192, 5, 5, 5, 16, 4,
  9, 136, 72, 48, 16, 48, 8, 5, 5, 16, 3, 9, 252, 32, 72, 33,
  30, 3, 3, 3, 8, 4, 8, 160, 0, 128, 9, 4, 8, 16, 4, 9,
  18, 128, 159, 128, 144, 0, 96, 0, 16, 16, 32, 16, 0, 254, 85, 85,
  128, 0, 1, 193, 134, 48, 11, 233, 140, 24, 16, 5, 144, 4, 16, 5,
  140, 24, 11, 233, 134, 48, 1, 193, 128, 0, 0, 1, 170, 170, 15, 15,
  30, 16, 1, 254, 1, 0, 2, 128, 63, 248, 40, 40, 48, 24, 35, 136,
  100, 76, 164, 74, 100, 76, 35, 136, 48, 24, 40, 40, 63, 248, 2, 128,
  1, 0, 3, 4, 4, 16, 6, 9, 96, 160, 160, 96, 4, 5, 5, 16,
  6, 9, 96, 144, 144, 144, 96, 6, 3, 3, 16, 5, 10, 252, 8, 96,
  3, 5, 5, 16, 6, 9, 96, 224, 128, 128, 64, 9, 4, 8, 16, 4,
  254, 18, 128, 159, 128, 144, 0, 96, 0, 6, 2, 2, 16, 5, 10, 12,
  240, 5, 4, 4, 8, 2, 9, 24, 24, 16, 224, 7, 4, 4, 8, 1,
  9, 32, 64, 128, 254, 7, 4, 4, 16, 3, 9, 32, 64, 128, 254, 6,
  4, 4, 16, 5, 9, 16, 132, 132, 124, 15, 15, 30, 16, 1, 254, 1,
  0, 2, 128, 5, 64, 10, 160, 21, 80, 42, 168, 84, 84, 42, 168, 42,
  168, 42, 168, 43, 168, 40, 40, 47, 232, 96, 12, 255, 254, 5, 5, 5,
  16, 5, 9, 32, 80, 136, 80, 32, 5, 5, 5, 16, 5, 254, 32, 80,
  136, 80, 32, 2, 2, 2, 16, 7, 11, 192, 192, 2, 4, 4, 16, 7,
  254, 192, 128, 128, 64, 6, 9, 9, 8, 1, 3, 16, 40, 68, 0, 16,
  8, 4, 132, 248, 7, 11, 11, 8, 1, 255, 8, 20, 34, 0, 8, 4,
  4, 4, 8, 144, 96, 3, 3, 3, 8, 2, 5, 64, 224, 64, 4, 9,
  9, 8, 2, 2, 128, 128, 64, 64, 32, 32, 16, 16, 16, 5, 9, 9,
  8, 2, 2, 136, 144, 96, 64, 32, 32, 16, 16, 16, 7, 9, 9, 8,
  1, 2, 146, 164, 120, 64, 32, 32, 16, 16, 16, 6, 9, 9, 8, 1,
  2, 48, 72, 192, 228, 88, 64, 32, 32, 32, 7, 9, 9, 8, 1, 1,
  16, 16, 40, 40, 68, 68, 146, 170, 198, 6, 8, 8, 8, 1, 2, 56,
  68, 64, 64, 48, 12, 48, 192, 7, 9, 9, 8, 1, 2, 130, 130, 68,
  68, 40, 40, 16, 16, 16, 7, 9, 9, 8, 1, 2, 16, 16, 16, 40,
  40, 68, 68, 130, 130, 7, 9, 9, 8, 1, 2, 48, 72, 136, 152, 104,
  4, 4, 2, 2, 7, 12, 12, 8, 1, 0, 16, 0, 36, 0, 0, 2,
  42, 42, 188, 144, 148, 96, 7, 9, 9, 8, 1, 0, 8, 0, 0, 12,
  50, 156, 144, 148, 96, 6, 12, 12, 8, 1, 254, 16, 0, 0, 48, 72,
  64, 56, 64, 144, 128, 132, 120, 4, 10, 10, 8, 2, 254, 112, 128, 240,
  64, 128, 0, 80, 80, 80, 80, 6, 8, 8, 8, 1, 254, 56, 12, 124,
  128, 148, 148, 148, 148, 10, 12, 24, 16, 1, 1, 4, 0, 10, 0, 17,
  0, 4, 0, 3, 0, 6, 128, 10, 64, 10, 64, 6, 64, 25, 128, 96,
  0, 128, 0
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 3, '1' Height: 12
  Calculated Max Values w=16 h=16 x=12 y=11 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 3 descent=-2
  X Font      ascent =12 descent=-2
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_18_19[7078] U8G_FONT_SECTION("u8g_font_unifont_18_19") = {
  0, 16, 16, 0, 254, 3, 7, 121, 9, 233, 0, 255, 254, 14, 254, 12,
  254, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 74, 81, 234, 80, 90, 81, 201, 158, 0, 1, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 8, 4, 4, 16, 4, 9, 152, 91, 35,
  28, 2, 2, 2, 16, 7, 11, 192, 192, 2, 5, 5, 16, 12, 3, 192,
  192, 0, 192, 192, 14, 15, 30, 16, 2, 255, 32, 0, 31, 0, 0, 128,
  57, 252, 68, 192, 4, 192, 12, 192, 56, 192, 8, 192, 135, 192, 134, 192,
  78, 192, 60, 192, 0, 192, 0, 64, 15, 12, 24, 16, 1, 255, 57, 254,
  68, 192, 4, 192, 12, 192, 56, 192, 8, 192, 135, 192, 134, 192, 78, 192,
  60, 192, 0, 192, 0, 64, 15, 12, 24, 16, 1, 255, 57, 254, 68, 204,
  4, 204, 12, 204, 56, 204, 8, 204, 135, 204, 134, 204, 78, 204, 60, 204,
  0, 204, 0, 68, 16, 13, 26, 16, 0, 254, 255, 255, 0, 192, 0, 192,
  15, 192, 24, 0, 24, 0, 15, 224, 0, 48, 3, 48, 5, 176, 7, 224,
  0, 64, 0, 32, 16, 16, 32, 16, 0, 254, 3, 192, 6, 32, 1, 0,
  255, 255, 0, 192, 0, 192, 15, 192, 24, 0, 24, 0, 15, 224, 0, 48,
  3, 48, 5, 176, 7, 224, 0, 64, 0, 32, 16, 12, 24, 16, 0, 255,
  255, 255, 1, 128, 0, 192, 0, 192, 1, 192, 15, 128, 65, 128, 64, 192,
  32, 192, 16, 192, 9, 192, 7, 128, 16, 12, 24, 16, 0, 255, 255, 255,
  1, 128, 0, 192, 0, 192, 1, 192, 15, 156, 65, 178, 64, 226, 32, 194,
  16, 198, 9, 196, 7, 128, 16, 13, 26, 16, 0, 254, 255, 255, 1, 128,
  57, 128, 101, 152, 3, 152, 7, 248, 31, 136, 57, 136, 33, 156, 1, 184,
  1, 160, 0, 160, 0, 30, 16, 12, 24, 16, 0, 255, 255, 255, 0, 32,
  0, 32, 56, 32, 116, 248, 99, 204, 99, 12, 48, 12, 16, 120, 12, 192,
  2, 128, 0, 124, 16, 16, 32, 16, 0, 254, 0, 152, 0, 112, 0, 0,
  255, 255, 12, 48, 12, 48, 12, 48, 12, 48, 12, 96, 4, 0, 2, 0,
  1, 128, 0, 96, 0, 16, 0, 24, 0, 24, 16, 16, 32, 16, 0, 254,
  16, 0, 15, 224, 0, 16, 255, 255, 12, 48, 12, 48, 12, 48, 12, 48,
  12, 96, 4, 0, 2, 0, 1, 128, 0, 96, 0, 16, 0, 24, 0, 24,
  16, 13, 26, 16, 0, 254, 255, 255, 12, 48, 12, 48, 12, 48, 12, 48,
  12, 96, 4, 0, 2, 0, 1, 128, 0, 96, 0, 16, 0, 24, 0, 24,
  16, 16, 32, 16, 0, 254, 15, 0, 0, 128, 0, 64, 255, 255, 12, 48,
  12, 48, 12, 48, 12, 48, 12, 96, 4, 0, 2, 0, 1, 128, 0, 96,
  0, 16, 0, 24, 0, 24, 15, 15, 30, 16, 1, 255, 0, 76, 0, 60,
  0, 0, 57, 254, 68, 204, 4, 204, 12, 204, 56, 204, 8, 204, 135, 204,
  134, 204, 78, 204, 60, 204, 0, 204, 0, 68, 15, 15, 30, 16, 1, 255,
  2, 0, 1, 240, 0, 8, 57, 254, 68, 204, 4, 204, 12, 204, 56, 204,
  8, 204, 135, 204, 134, 204, 78, 204, 60, 204, 0, 204, 0, 68, 15, 15,
  30, 16, 1, 255, 1, 192, 0, 32, 0, 16, 57, 254, 68, 204, 4, 204,
  12, 204, 56, 204, 8, 204, 135, 204, 134, 204, 78, 204, 60, 204, 0, 204,
  0, 68, 15, 15, 30, 16, 1, 255, 0, 224, 1, 208, 0, 40, 57, 254,
  68, 204, 4, 204, 12, 204, 56, 204, 8, 204, 135, 204, 134, 204, 78, 204,
  60, 204, 0, 204, 0, 68, 16, 12, 24, 16, 0, 255, 255, 255, 1, 128,
  1, 128, 29, 128, 51, 224, 35, 144, 39, 152, 29, 152, 1, 152, 1, 152,
  1, 128, 0, 128, 16, 12, 24, 16, 0, 255, 255, 255, 8, 24, 8, 24,
  9, 216, 59, 56, 58, 24, 18, 56, 17, 216, 8, 24, 6, 24, 1, 152,
  0, 8, 16, 12, 24, 16, 0, 255, 255, 255, 1, 152, 1, 152, 1, 152,
  1, 152, 7, 152, 3, 152, 1, 152, 0, 152, 0, 24, 0, 24, 0, 8,
  16, 12, 24, 16, 0, 255, 255, 255, 12, 24, 12, 24, 7, 216, 2, 24,
  4, 24, 4, 56, 4, 120, 3, 216, 0, 24, 0, 24, 0, 8, 16, 11,
  22, 16, 0, 0, 255, 255, 0, 96, 0, 96, 15, 224, 24, 0, 24, 4,
  15, 206, 0, 100, 16, 96, 8, 96, 7, 192, 16, 12, 24, 16, 0, 255,
  255, 255, 0, 24, 0, 24, 0, 24, 31, 248, 3, 24, 6, 56, 6, 120,
  3, 216, 0, 24, 0, 24, 0, 8, 16, 13, 26, 16, 0, 254, 255, 255,
  0, 16, 0, 16, 60, 120, 112, 228, 96, 196, 32, 68, 31, 44, 12, 24,
  24, 56, 24, 100, 7, 134, 0, 6, 16, 12, 24, 16, 0, 255, 255, 255,
  0, 24, 0, 24, 0, 24, 3, 248, 17, 152, 8, 216, 8, 216, 7, 152,
  0, 24, 0, 24, 0, 8, 16, 12, 24, 16, 0, 255, 255, 255, 3, 24,
  3, 24, 31, 24, 48, 24, 48, 24, 31, 248, 1, 24, 13, 24, 22, 24,
  29, 24, 0, 136, 16, 12, 24, 16, 0, 255, 255, 255, 0, 24, 0, 24,
  7, 24, 5, 152, 33, 184, 33, 248, 33, 216, 19, 152, 15, 24, 0, 24,
  0, 8, 16, 11, 22, 16, 0, 0, 255, 255, 0, 192, 0, 192, 0, 192,
  7, 192, 12, 0, 24, 0, 24, 0, 24, 0, 12, 16, 7, 224, 16, 12,
  24, 16, 0, 255, 255, 255, 1, 128, 1, 128, 1, 128, 3, 128, 7, 96,
  12, 16, 8, 24, 8, 24, 8, 56, 4, 112, 3, 224, 16, 11, 22, 16,
  0, 0, 255, 255, 0, 24, 0, 24, 3, 248, 6, 0, 6, 0, 3, 240,
  0, 24, 4, 24, 2, 24, 1, 240, 16, 12, 24, 16, 0, 255, 255, 255,
  0, 96, 0, 96, 7, 224, 12, 0, 24, 0, 24, 192, 25, 160, 9, 16,
  5, 16, 3, 48, 1, 224, 16, 12, 24, 16, 0, 255, 255, 255, 25, 152,
  25, 152, 25, 152, 25, 152, 25, 152, 9, 152, 7, 24, 0, 24, 0, 24,
  0, 24, 0, 8, 16, 12, 24, 16, 0, 255, 255, 255, 0, 24, 0, 24,
  0, 24, 7, 248, 14, 24, 12, 24, 12, 24, 6, 24, 2, 24, 1, 24,
  0, 136, 13, 12, 24, 16, 3, 255, 227, 248, 216, 192, 204, 192, 76, 192,
  28, 192, 120, 192, 97, 192, 35, 192, 30, 192, 0, 192, 0, 192, 0, 64,
  16, 12, 24, 16, 0, 255, 255, 255, 0, 24, 0, 24, 0, 24, 1, 248,
  2, 0, 6, 0, 6, 24, 2, 40, 1, 240, 0, 8, 0, 4, 13, 12,
  24, 16, 3, 255, 115, 248, 200, 192, 192, 192, 192, 192, 96, 192, 28, 192,
  48, 192, 96, 192, 97, 192, 99, 192, 30, 192, 0, 64, 16, 12, 24, 16,
  0, 255, 255, 255, 0, 24, 0, 24, 0, 24, 7, 248, 6, 24, 6, 24,
  2, 24, 0, 24, 0, 24, 0, 24, 0, 8, 16, 12, 24, 16, 0, 255,
  255, 255, 0, 24, 0, 24, 0, 24, 7, 248, 6, 24, 6, 24, 2, 24,
  0, 24, 1, 24, 3, 152, 1, 8, 16, 12, 24, 16, 0, 255, 255, 255,
  6, 24, 6, 24, 6, 24, 6, 24, 6, 24, 2, 56, 1, 216, 0, 24,
  0, 24, 0, 24, 0, 8, 16, 12, 24, 16, 0, 255, 255, 255, 49, 128,
  49, 128, 49, 128, 49, 240, 49, 200, 19, 132, 15, 132, 1, 132, 1, 140,
  1, 140, 0, 128, 16, 12, 24, 16, 0, 255, 255, 255, 0, 24, 0, 24,
  7, 216, 14, 120, 13, 24, 12, 152, 12, 120, 7, 248, 0, 24, 0, 24,
  0, 8, 14, 12, 24, 16, 2, 255, 227, 252, 216, 96, 200, 96, 76, 96,
  60, 96, 12, 96, 31, 224, 28, 96, 12, 96, 0, 96, 0, 96, 0, 32,
  16, 12, 24, 16, 0, 255, 255, 255, 6, 24, 6, 24, 6, 24, 6, 24,
  6, 24, 15, 248, 6, 24, 2, 24, 0, 24, 0, 24, 0, 8, 16, 12,
  24, 16, 0, 255, 255, 255, 3, 24, 3, 24, 3, 24, 3, 24, 6, 24,
  4, 56, 4, 120, 3, 216, 0, 24, 0, 24, 0, 8, 16, 12, 24, 16,
  0, 255, 255, 255, 0, 192, 0, 192, 0, 192, 3, 192, 3, 128, 3, 128,
  1, 0, 0, 128, 0, 64, 0, 32, 0, 24, 16, 12, 24, 16, 0, 255,
  255, 255, 0, 192, 0, 192, 0, 192, 3, 192, 3, 128, 3, 128, 1, 0,
  0, 128, 4, 64, 14, 32, 4, 24, 16, 12, 24, 16, 0, 255, 255, 255,
  0, 24, 0, 24, 28, 56, 58, 248, 49, 216, 49, 152, 24, 24, 8, 24,
  4, 24, 3, 24, 0, 8, 16, 11, 22, 16, 0, 0, 255, 255, 0, 48,
  0, 48, 0, 112, 14, 200, 25, 140, 49, 140, 49, 140, 49, 152, 19, 112,
  14, 0, 16, 13, 26, 16, 0, 254, 255, 255, 0, 48, 0, 48, 0, 112,
  14, 200, 25, 140, 49, 140, 49, 140, 49, 152, 19, 112, 14, 0, 0, 192,
  0, 192, 16, 12, 24, 16, 0, 255, 255, 255, 0, 24, 0, 24, 3, 216,
  15, 56, 12, 24, 12, 56, 4, 120, 3, 216, 0, 24, 0, 24, 0, 8,
  16, 12, 24, 16, 0, 255, 255, 255, 6, 24, 6, 24, 31, 24, 1, 152,
  1, 152, 25, 152, 21, 24, 30, 24, 2, 24, 1, 24, 0, 136, 16, 12,
  24, 16, 0, 255, 255, 255, 12, 24, 14, 24, 13, 24, 12, 152, 12, 88,
  12, 56, 6, 56, 1, 216, 0, 24, 0, 24, 0, 8, 16, 12, 24, 16,
  0, 255, 255, 255, 3, 24, 3, 24, 3, 24, 11, 24, 15, 24, 14, 248,
  4, 24, 4, 24, 2, 24, 1, 24, 0, 136, 16, 12, 24, 16, 0, 255,
  255, 255, 0, 24, 0, 24, 7, 248, 12, 0, 12, 0, 6, 240, 1, 152,
  3, 16, 3, 0, 1, 128, 0, 252, 2, 4, 4, 16, 7, 10, 192, 192,
  192, 192, 6, 16, 16, 16, 10, 254, 48, 48, 48, 252, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 48, 16, 2, 2, 2, 16, 7, 255, 192, 192,
  9, 11, 22, 16, 7, 0, 63, 128, 64, 0, 64, 0, 96, 0, 48, 0,
  24, 0, 8, 0, 12, 0, 12, 0, 156, 0, 120, 0, 6, 13, 13, 16,
  10, 254, 252, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 16, 8,
  14, 14, 16, 0, 0, 60, 98, 49, 252, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 16, 9, 16, 32, 16, 7, 254, 120, 0, 132, 0, 132, 0, 31,
  128, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 6,
  0, 6, 0, 6, 0, 6, 0, 2, 0, 6, 3, 3, 16, 4, 255, 152,
  68, 56, 6, 3, 3, 16, 6, 255, 112, 136, 100, 4, 3, 3, 16, 6,
  255, 96, 128, 112, 3, 5, 5, 16, 6, 255, 96, 128, 96, 128, 96, 5,
  3, 3, 16, 5, 10, 136, 72, 48, 5, 3, 3, 16, 4, 10, 128, 112,
  8, 5, 3, 3, 16, 4, 10, 224, 16, 8, 6, 4, 4, 16, 3, 9,
  112, 8, 228, 28, 6, 16, 16, 16, 10, 254, 136, 120, 0, 252, 48, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 16, 8, 16, 16, 16, 8, 254,
  128, 120, 4, 63, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 4,
  8, 16, 16, 16, 8, 254, 240, 8, 4, 63, 12, 12, 12, 12, 12, 12,
  12, 12, 12, 12, 12, 4, 9, 16, 32, 16, 7, 254, 120, 0, 244, 0,
  10, 0, 31, 128, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0,
  6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 2, 0, 5, 3, 3, 16,
  6, 255, 224, 16, 8, 4, 13, 13, 16, 2, 254, 240, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 128, 9, 15, 30, 16, 7, 255, 32, 0,
  30, 0, 129, 0, 125, 128, 3, 0, 31, 0, 3, 0, 3, 0, 3, 0,
  3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 1, 0, 14, 12, 24, 16,
  1, 1, 4, 192, 2, 216, 57, 24, 68, 224, 4, 0, 12, 56, 56, 76,
  8, 204, 135, 156, 134, 120, 78, 0, 60, 0, 1, 3, 3, 16, 8, 10,
  128, 128, 128, 4, 1, 1, 16, 6, 0, 240, 3, 3, 3, 16, 6, 10,
  128, 64, 32, 3, 3, 3, 16, 7, 10, 32, 64, 128, 5, 5, 5, 16,
  5, 8, 136, 72, 48, 0, 248, 6, 2, 2, 16, 3, 254, 132, 120, 8,
  4, 4, 16, 2, 254, 66, 60, 129, 126, 16, 13, 26, 16, 0, 254, 255,
  255, 0, 192, 0, 192, 14, 192, 25, 248, 17, 200, 19, 204, 14, 204, 0,
  204, 0, 204, 4, 192, 14, 64, 4, 0, 16, 13, 26, 16, 0, 254, 255,
  255, 8, 24, 8, 24, 9, 216, 59, 56, 58, 24, 18, 56, 17, 216, 8,
  24, 4, 24, 0, 152, 1, 200, 0, 128, 16, 13, 26, 16, 0, 254, 255,
  255, 1, 152, 1, 152, 1, 152, 1, 152, 7, 152, 3, 152, 1, 152, 0,
  152, 0, 24, 0, 152, 1, 200, 0, 128, 16, 13, 26, 16, 0, 254, 255,
  255, 0, 24, 0, 24, 0, 24, 3, 248, 17, 152, 8, 216, 8, 216, 7,
  152, 0, 24, 0, 152, 1, 200, 0, 128, 16, 13, 26, 16, 0, 254, 255,
  255, 0, 24, 0, 24, 3, 248, 6, 0, 6, 0, 3, 240, 0, 24, 4,
  24, 3, 240, 0, 0, 0, 192, 0, 192, 16, 13, 26, 16, 0, 254, 255,
  255, 0, 96, 0, 96, 7, 224, 12, 0, 24, 224, 25, 144, 25, 16, 13,
  48, 7, 224, 0, 0, 1, 128, 1, 128, 16, 13, 26, 16, 0, 254, 255,
  255, 49, 128, 49, 128, 49, 128, 49, 240, 49, 200, 19, 132, 15, 132, 1,
  132, 1, 140, 9, 140, 28, 128, 8, 0, 16, 13, 26, 16, 0, 254, 255,
  255, 3, 24, 3, 24, 3, 24, 3, 24, 6, 24, 4, 56, 4, 120, 3,
  216, 0, 24, 1, 24, 3, 136, 1, 0, 16, 13, 26, 16, 0, 254, 255,
  255, 3, 0, 3, 0, 51, 24, 75, 40, 7, 240, 15, 24, 51, 8, 67,
  24, 3, 48, 3, 28, 1, 16, 0, 14, 16, 13, 26, 16, 0, 254, 255,
  255, 0, 32, 0, 32, 30, 112, 49, 152, 49, 152, 16, 48, 8, 96, 4,
  192, 0, 60, 0, 192, 0, 192, 0, 60, 8, 5, 5, 16, 4, 255, 72,
  146, 130, 68, 3, 8, 6, 6, 16, 4, 254, 72, 146, 132, 67, 4, 3,
  2, 12, 12, 16, 7, 255, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 64, 5, 12, 12, 16, 6, 255, 144, 216, 216, 216, 216, 216, 216, 216,
  216, 216, 216, 72, 8, 7, 7, 16, 4, 2, 60, 78, 199, 195, 227, 114,
  60, 6, 13, 13, 16, 5, 254, 112, 232, 204, 204, 76, 60, 24, 48, 96,
  32, 16, 8, 4, 9, 13, 26, 16, 4, 254, 252, 0, 226, 0, 1, 0,
  1, 0, 1, 0, 3, 0, 54, 0, 44, 0, 56, 0, 4, 0, 2, 0,
  1, 0, 0, 128, 8, 13, 13, 16, 4, 254, 252, 226, 2, 2, 60, 2,
  1, 51, 46, 60, 4, 2, 1, 12, 12, 24, 16, 2, 255, 128, 16, 64,
  48, 32, 96, 16, 192, 9, 128, 7, 0, 6, 0, 13, 0, 9, 128, 9,
  128, 9, 128, 7, 0, 8, 13, 13, 16, 4, 254, 192, 195, 195, 67, 62,
  12, 12, 104, 88, 120, 4, 2, 1, 8, 13, 13, 16, 4, 254, 60, 192,
  128, 192, 124, 16, 32, 35, 51, 15, 4, 4, 2, 11, 11, 22, 16, 3,
  0, 128, 0, 135, 0, 142, 192, 140, 64, 68, 96, 67, 224, 64, 32, 32,
  32, 32, 64, 24, 192, 7, 0, 10, 10, 20, 16, 3, 1, 255, 192, 32,
  0, 64, 0, 128, 0, 128, 0, 131, 0, 135, 128, 124, 128, 56, 128, 0,
  128, 8, 12, 12, 16, 4, 255, 56, 100, 98, 97, 32, 56, 72, 192, 192,
  192, 32, 31, 5, 4, 4, 16, 6, 3, 112, 136, 136, 112, 2, 2, 2,
  16, 8, 6, 192, 192, 15, 15, 30, 16, 1, 255, 2, 0, 1, 32, 0,
  192, 57, 254, 68, 192, 4, 192, 12, 192, 56, 192, 8, 192, 135, 192, 134,
  192, 78, 192, 60, 192, 0, 192, 0, 64, 15, 15, 30, 16, 1, 255, 0,
  192, 0, 192, 0, 192, 57, 254, 68, 192, 4, 192, 12, 192, 56, 192, 8,
  192, 135, 192, 134, 192, 78, 192, 60, 192, 0, 192, 0, 64, 15, 15, 30,
  16, 1, 255, 0, 12, 0, 12, 0, 12, 57, 254, 68, 204, 4, 204, 12,
  204, 56, 204, 8, 204, 135, 204, 134, 204, 78, 204, 60, 204, 0, 204, 0,
  68, 15, 15, 30, 16, 1, 255, 0, 128, 0, 120, 2, 4, 57, 246, 68,
  12, 4, 124, 12, 204, 56, 204, 8, 204, 135, 204, 134, 204, 78, 204, 60,
  204, 0, 204, 0, 68, 15, 16, 32, 16, 1, 254, 2, 0, 1, 32, 0,
  192, 57, 254, 68, 192, 4, 192, 12, 192, 56, 192, 8, 192, 135, 192, 134,
  192, 78, 192, 60, 192, 0, 64, 33, 0, 30, 0, 15, 16, 32, 16, 1,
  254, 2, 0, 1, 32, 0, 192, 57, 254, 68, 192, 4, 192, 12, 192, 56,
  192, 8, 192, 135, 192, 78, 192, 60, 192, 33, 192, 30, 0, 64, 128, 63,
  0, 16, 12, 24, 16, 0, 255, 255, 255, 24, 0, 24, 0, 24, 0, 63,
  224, 56, 112, 0, 48, 0, 48, 0, 48, 0, 48, 0, 96, 0, 64, 16,
  12, 24, 16, 0, 255, 255, 255, 0, 24, 0, 24, 0, 24, 3, 248, 17,
  152, 8, 216, 8, 216, 7, 152, 0, 24, 8, 152, 2, 8, 16, 12, 24,
  16, 0, 255, 255, 255, 3, 24, 3, 24, 3, 24, 3, 152, 6, 88, 4,
  56, 4, 120, 3, 216, 0, 24, 0, 24, 0, 8, 16, 12, 24, 16, 0,
  255, 255, 255, 1, 152, 1, 152, 1, 152, 1, 152, 7, 152, 3, 152, 1,
  152, 0, 152, 0, 24, 0, 24, 15, 248, 16, 12, 24, 16, 0, 255, 255,
  255, 0, 24, 0, 24, 0, 24, 3, 248, 17, 152, 8, 216, 8, 216, 7,
  152, 0, 24, 0, 24, 31, 248, 8, 13, 13, 16, 4, 254, 124, 226, 193,
  1, 1, 3, 62, 60, 48, 48, 48, 48, 16, 16, 13, 26, 16, 0, 254,
  255, 255, 0, 24, 0, 24, 3, 248, 6, 0, 6, 0, 3, 240, 0, 24,
  4, 24, 2, 24, 1, 240, 0, 0, 15, 254, 16, 12, 24, 16, 0, 255,
  255, 255, 0, 24, 0, 24, 7, 216, 14, 120, 13, 24, 12, 152, 12, 120,
  7, 248, 0, 24, 0, 24, 15, 248, 11, 12, 24, 16, 2, 255, 30, 0,
  55, 0, 97, 128, 193, 128, 193, 128, 89, 128, 57, 128, 1, 128, 1, 128,
  1, 160, 1, 160, 0, 192, 6, 4, 4, 16, 5, 9, 48, 180, 132, 120,
  5, 8, 8, 16, 11, 0, 96, 144, 96, 0, 192, 96, 48, 8, 4, 7,
  7, 16, 11, 1, 96, 144, 96, 0, 96, 144, 96, 14, 14, 28, 16, 1,
  255, 255, 252, 231, 156, 219, 108, 219, 140, 219, 236, 231, 156, 255, 252, 255,
  252, 231, 108, 219, 108, 231, 12, 219, 236, 231, 236, 255, 252, 16, 12, 24,
  16, 0, 255, 255, 255, 0, 12, 64, 12, 67, 140, 71, 204, 71, 236, 99,
  44, 32, 108, 48, 124, 24, 220, 15, 140, 0, 4, 16, 13, 26, 16, 0,
  255, 0, 6, 255, 247, 0, 110, 64, 102, 70, 102, 79, 102, 79, 102, 69,
  102, 65, 102, 97, 102, 51, 230, 30, 102, 0, 34, 16, 15, 30, 16, 0,
  255, 32, 0, 31, 192, 0, 32, 255, 255, 0, 0, 15, 192, 24, 96, 60,
  48, 60, 48, 24, 48, 0, 96, 63, 192, 7, 0, 1, 192, 0, 124, 16,
  15, 30, 16, 0, 255, 32, 0, 31, 240, 0, 8, 255, 255, 30, 0, 63,
  12, 59, 30, 25, 56, 1, 248, 1, 240, 3, 144, 79, 16, 60, 16, 16,
  24, 0, 14, 16, 15, 30, 16, 0, 255, 16, 0, 15, 224, 0, 16, 255,
  255, 3, 0, 3, 0, 67, 0, 67, 16, 67, 56, 99, 108, 33, 204, 48,
  12, 24, 12, 14, 24, 3, 240, 16, 15, 30, 16, 0, 255, 16, 0, 15,
  224, 0, 16, 255, 255, 3, 0, 3, 0, 83, 0, 83, 16, 83, 56, 83,
  108, 73, 204, 40, 12, 36, 12, 18, 24, 15, 240, 15, 14, 28, 16, 1,
  255, 64, 0, 228, 0, 230, 206, 133, 204, 121, 204, 3, 204, 14, 204, 120,
  204, 96, 236, 120, 252, 14, 220, 3, 204, 1, 204, 0, 68, 14, 14, 28,
  16, 1, 255, 64, 0, 128, 0, 128, 0, 64, 0, 127, 192, 31, 240, 0,
  56, 15, 12, 24, 140, 56, 76, 56, 76, 56, 76, 16, 216, 3, 240, 14,
  14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219, 236, 231,
  156, 255, 252, 255, 252, 231, 28, 219, 108, 231, 108, 219, 108, 231, 28, 255,
  252, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219,
  236, 231, 156, 255, 252, 255, 252, 231, 12, 219, 124, 231, 28, 219, 124, 231,
  12, 255, 252, 14, 13, 26, 16, 1, 255, 0, 48, 0, 248, 1, 140, 3,
  12, 135, 140, 135, 140, 131, 12, 128, 12, 192, 12, 64, 108, 96, 156, 51,
  12, 14, 4, 14, 15, 30, 16, 1, 255, 0, 8, 0, 16, 0, 16, 0,
  216, 3, 236, 6, 52, 140, 52, 158, 52, 158, 52, 140, 56, 192, 48, 65,
  176, 98, 112, 60, 48, 24, 16, 14, 14, 28, 16, 1, 255, 255, 252, 231,
  156, 219, 108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 231, 220, 219,
  156, 227, 220, 251, 220, 231, 140, 255, 252, 14, 14, 28, 16, 1, 255, 255,
  252, 231, 156, 219, 108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 231,
  12, 219, 236, 227, 12, 251, 124, 231, 12, 255, 252, 14, 13, 26, 16, 1,
  255, 0, 240, 3, 24, 6, 12, 14, 12, 142, 12, 134, 120, 192, 248, 64,
  120, 96, 12, 48, 12, 24, 12, 12, 24, 7, 240, 14, 15, 30, 16, 1,
  255, 0, 8, 0, 16, 0, 16, 7, 216, 8, 108, 28, 52, 28, 52, 156,
  52, 137, 228, 131, 248, 193, 224, 64, 48, 96, 48, 48, 112, 31, 224, 16,
  12, 24, 16, 0, 255, 255, 255, 0, 96, 0, 96, 1, 248, 7, 100, 60,
  98, 48, 98, 60, 110, 7, 108, 1, 224, 0, 224, 0, 32, 14, 13, 26,
  16, 2, 255, 64, 0, 226, 60, 227, 48, 197, 48, 121, 48, 1, 48, 6,
  48, 120, 48, 126, 48, 1, 176, 0, 112, 0, 48, 0, 16, 14, 12, 24,
  16, 2, 255, 62, 124, 113, 96, 224, 224, 224, 96, 252, 96, 70, 96, 6,
  96, 6, 96, 28, 96, 120, 96, 32, 96, 0, 32, 16, 12, 24, 16, 0,
  255, 255, 255, 24, 24, 48, 24, 56, 24, 31, 152, 1, 152, 6, 24, 12,
  24, 31, 24, 1, 216, 0, 56, 0, 8, 12, 13, 26, 16, 2, 255, 32,
  0, 35, 192, 22, 64, 12, 64, 15, 128, 140, 0, 136, 32, 136, 112, 199,
  176, 64, 48, 96, 48, 48, 96, 31, 128, 16, 12, 24, 16, 0, 255, 255,
  255, 24, 0, 24, 0, 28, 0, 27, 0, 24, 252, 24, 12, 24, 12, 24,
  12, 24, 24, 28, 48, 15, 192, 16, 12, 24, 16, 0, 255, 255, 255, 24,
  0, 24, 0, 28, 0, 27, 224, 24, 56, 24, 104, 28, 200, 15, 16, 0,
  96, 1, 248, 0, 14, 16, 12, 24, 16, 0, 255, 255, 255, 1, 240, 3,
  28, 70, 15, 76, 2, 76, 196, 79, 36, 102, 44, 32, 44, 48, 100, 24,
  196, 15, 131, 16, 12, 24, 16, 0, 255, 255, 231, 0, 102, 0, 102, 1,
  230, 7, 102, 60, 102, 48, 102, 60, 102, 7, 126, 1, 238, 0, 230, 0,
  34, 14, 13, 26, 16, 1, 255, 7, 0, 13, 128, 25, 176, 49, 248, 57,
  204, 185, 140, 145, 184, 129, 140, 193, 204, 199, 248, 111, 176, 121, 128, 48,
  128, 16, 15, 30, 16, 0, 255, 16, 0, 15, 192, 0, 32, 255, 255, 24,
  0, 24, 0, 24, 0, 24, 96, 24, 240, 24, 112, 24, 48, 24, 96, 24,
  192, 15, 128, 7, 0, 16, 15, 30, 16, 0, 255, 16, 0, 15, 0, 0,
  128, 255, 255, 0, 128, 0, 128, 0, 192, 1, 192, 1, 96, 35, 48, 58,
  24, 20, 24, 24, 24, 12, 48, 7, 224, 16, 12, 24, 16, 0, 255, 255,
  255, 3, 0, 3, 0, 67, 0, 67, 16, 67, 56, 99, 108, 33, 204, 48,
  12, 24, 12, 14, 24, 3, 240, 16, 12, 24, 16, 0, 255, 255, 255, 24,
  0, 24, 0, 24, 0, 24, 96, 24, 240, 24, 112, 24, 48, 24, 96, 24,
  192, 15, 128, 7, 0, 13, 13, 26, 16, 3, 255, 28, 96, 62, 120, 97,
  96, 192, 224, 192, 224, 224, 96, 224, 96, 64, 96, 0, 96, 0, 96, 0,
  96, 0, 96, 0, 32, 16, 12, 24, 16, 0, 255, 255, 255, 0, 0, 65,
  248, 67, 12, 67, 132, 67, 134, 99, 134, 33, 6, 48, 6, 24, 12, 12,
  28, 7, 240, 15, 13, 26, 16, 1, 255, 60, 0, 98, 62, 241, 48, 241,
  48, 97, 48, 1, 48, 6, 48, 120, 48, 126, 48, 1, 176, 0, 112, 0,
  48, 0, 16, 16, 12, 24, 16, 0, 255, 255, 255, 12, 0, 12, 0, 12,
  120, 12, 240, 13, 224, 13, 96, 15, 96, 14, 96, 14, 96, 12, 48, 8,
  28, 12, 13, 26, 16, 4, 255, 96, 0, 240, 240, 224, 192, 128, 192, 99,
  192, 30, 192, 56, 192, 224, 192, 248, 192, 14, 192, 3, 192, 1, 192, 0,
  64, 16, 12, 24, 16, 0, 255, 255, 255, 0, 24, 0, 24, 0, 24, 0,
  24, 30, 24, 63, 152, 60, 216, 56, 120, 0, 56, 0, 24, 0, 8, 14,
  14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219, 236, 231,
  156, 255, 252, 255, 252, 195, 156, 219, 108, 195, 140, 219, 236, 219, 156, 255,
  252, 15, 13, 26, 16, 1, 255, 14, 48, 31, 190, 48, 240, 96, 112, 240,
  240, 155, 176, 14, 48, 24, 48, 32, 48, 0, 48, 0, 48, 0, 48, 0,
  16, 16, 12, 24, 16, 0, 255, 255, 255, 16, 0, 56, 120, 12, 100, 6,
  98, 12, 98, 24, 110, 48, 108, 63, 96, 1, 224, 0, 96, 0, 32, 16,
  12, 24, 16, 0, 255, 255, 255, 0, 24, 0, 24, 0, 120, 3, 216, 7,
  24, 28, 24, 31, 24, 1, 216, 0, 120, 0, 56, 0, 8, 16, 12, 24,
  16, 0, 255, 255, 255, 0, 0, 66, 16, 71, 8, 71, 12, 70, 20, 99,
  230, 32, 6, 48, 6, 24, 12, 12, 28, 7, 240, 16, 12, 24, 16, 0,
  255, 255, 255, 12, 24, 28, 24, 14, 24, 3, 24, 3, 24, 3, 24, 15,
  216, 30, 120, 12, 56, 0, 24, 0, 8, 16, 12, 24, 16, 0, 255, 255,
  255, 8, 48, 28, 48, 6, 48, 3, 48, 6, 48, 12, 48, 24, 48, 31,
  176, 0, 240, 0, 48, 0, 16, 16, 12, 24, 16, 0, 255, 255, 255, 0,
  24, 0, 120, 3, 216, 7, 24, 28, 24, 31, 24, 1, 216, 2, 120, 7,
  56, 7, 24, 2, 8, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219,
  108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 199, 220, 219, 156, 199,
  220, 219, 220, 199, 140, 255, 252, 16, 12, 24, 16, 0, 255, 255, 255, 0,
  6, 0, 6, 28, 22, 62, 62, 99, 102, 65, 198, 65, 198, 64, 134, 124,
  6, 60, 6, 24, 2, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219,
  108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 199, 28, 219, 236, 199,
  140, 219, 236, 199, 28, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 231,
  156, 219, 108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 199, 108, 219,
  108, 199, 12, 219, 236, 199, 236, 255, 252, 14, 14, 28, 16, 1, 255, 255,
  252, 231, 156, 219, 108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 199,
  12, 219, 124, 199, 12, 219, 236, 199, 12, 255, 252, 15, 13, 26, 16, 1,
  255, 112, 204, 249, 238, 143, 60, 143, 28, 31, 140, 63, 204, 25, 140, 0,
  12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 4, 16, 12, 24, 16, 0,
  255, 255, 255, 28, 24, 14, 24, 7, 152, 1, 216, 6, 120, 28, 24, 31,
  24, 1, 216, 0, 120, 0, 56, 0, 8, 16, 12, 24, 16, 0, 255, 255,
  255, 16, 12, 56, 12, 28, 12, 6, 12, 2, 204, 1, 236, 3, 28, 102,
  12, 60, 12, 24, 12, 0, 4, 16, 12, 24, 16, 0, 255, 255, 255, 0,
  0, 15, 192, 24, 96, 60, 48, 60, 48, 24, 48, 0, 96, 63, 192, 7,
  0, 1, 192, 0, 124, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219,
  108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 199, 12, 219, 108, 199,
  12, 219, 108, 199, 108, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 231,
  156, 219, 108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 199, 28, 219,
  108, 199, 28, 219, 108, 199, 28, 255, 252, 2, 2, 2, 16, 7, 255, 192,
  192, 14, 12, 24, 16, 0, 255, 240, 0, 8, 0, 15, 192, 28, 96, 60,
  48, 60, 48, 24, 48, 0, 96, 63, 192, 7, 0, 1, 192, 0, 124, 5,
  10, 10, 16, 11, 255, 48, 184, 112, 48, 48, 48, 48, 48, 48, 16, 13,
  14, 28, 16, 0, 255, 15, 128, 63, 224, 96, 16, 96, 8, 32, 0, 248,
  0, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 16,
  0, 12, 14, 28, 16, 4, 255, 63, 0, 65, 128, 128, 192, 190, 64, 65,
  64, 1, 240, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0,
  192, 0, 64, 6, 5, 5, 16, 5, 254, 4, 104, 144, 104, 4, 6, 5,
  5, 16, 6, 254, 96, 128, 112, 8, 4, 5, 5, 5, 16, 5, 254, 24,
  96, 128, 96, 24, 3, 5, 5, 16, 6, 255, 96, 128, 96, 128, 64, 14,
  14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219, 236, 231,
  156, 255, 252, 255, 252, 227, 12, 223, 124, 223, 12, 223, 236, 227, 12, 255,
  252, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219,
  236, 231, 156, 255, 252, 255, 252, 227, 156, 223, 124, 223, 28, 223, 108, 227,
  156, 255, 252, 5, 9, 9, 16, 0, 255, 248, 24, 48, 96, 64, 64, 64,
  88, 56, 5, 12, 12, 16, 0, 255, 128, 112, 8, 248, 24, 48, 96, 64,
  64, 64, 88, 56, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108,
  219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 227, 156, 223, 108, 223, 140,
  223, 236, 227, 156, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156,
  219, 108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 227, 12, 223, 108,
  223, 12, 223, 108, 227, 108, 255, 252, 16, 10, 20, 16, 0, 255, 0, 6,
  248, 23, 24, 14, 48, 6, 96, 6, 64, 6, 64, 6, 64, 6, 88, 6,
  56, 2, 16, 13, 26, 16, 0, 255, 0, 128, 0, 112, 0, 8, 0, 4,
  248, 23, 24, 14, 48, 6, 96, 6, 64, 6, 64, 6, 64, 6, 88, 6,
  56, 2, 5, 3, 3, 16, 6, 0, 192, 48, 8, 8, 12, 12, 16, 4,
  255, 56, 92, 204, 236, 216, 192, 96, 56, 12, 6, 3, 1, 14, 14, 28,
  16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219, 236, 231, 156, 255,
  252, 255, 252, 227, 12, 223, 124, 223, 28, 223, 124, 227, 124, 255, 252, 14,
  14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219, 236, 231,
  156, 255, 252, 255, 252, 199, 156, 219, 108, 219, 108, 219, 108, 199, 156, 255,
  252, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219,
  236, 231, 156, 255, 252, 255, 252, 199, 220, 219, 156, 219, 220, 219, 220, 199,
  140, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219,
  140, 219, 236, 231, 156, 255, 252, 255, 252, 199, 12, 219, 236, 219, 12, 219,
  124, 199, 12, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219,
  108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 199, 28, 219, 236, 219,
  140, 219, 236, 199, 28, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 231,
  156, 219, 108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 199, 108, 219,
  108, 219, 12, 219, 236, 199, 236, 255, 252, 14, 14, 28, 16, 1, 255, 255,
  252, 231, 156, 219, 108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 199,
  12, 219, 124, 219, 12, 219, 236, 199, 12, 255, 252, 14, 14, 28, 16, 1,
  255, 255, 252, 231, 156, 219, 108, 219, 140, 219, 236, 231, 156, 255, 252, 255,
  252, 199, 156, 219, 124, 219, 28, 219, 108, 199, 156, 255, 252, 8, 13, 13,
  16, 8, 255, 128, 112, 8, 4, 23, 14, 6, 6, 6, 6, 6, 6, 2,
  14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219, 236,
  231, 156, 255, 252, 255, 252, 199, 156, 219, 108, 219, 156, 219, 108, 199, 156,
  255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140,
  219, 236, 231, 156, 255, 252, 255, 252, 199, 156, 219, 108, 219, 140, 219, 236,
  199, 156, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108,
  219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 199, 12, 219, 108, 219, 12,
  219, 108, 199, 108, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156,
  219, 108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 199, 28, 219, 108,
  219, 28, 219, 108, 199, 28, 255, 252, 16, 13, 26, 16, 0, 254, 255, 255,
  3, 0, 67, 16, 67, 56, 99, 108, 35, 204, 49, 140, 24, 12, 14, 24,
  3, 240, 0, 0, 0, 192, 0, 192, 16, 13, 26, 16, 0, 254, 255, 255,
  12, 0, 12, 0, 12, 0, 12, 48, 12, 120, 12, 56, 12, 48, 7, 224,
  3, 192, 0, 0, 1, 128, 1, 128, 14, 14, 28, 16, 1, 255, 255, 252,
  231, 156, 219, 108, 219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 199, 12,
  219, 124, 219, 28, 219, 124, 199, 12, 255, 252, 16, 13, 26, 16, 0, 254,
  255, 255, 4, 24, 14, 24, 3, 24, 1, 152, 3, 24, 6, 24, 12, 24,
  15, 216, 0, 120, 1, 24, 3, 136, 1, 0, 15, 15, 30, 16, 1, 254,
  64, 0, 228, 0, 230, 206, 133, 204, 121, 204, 3, 204, 14, 204, 120, 204,
  96, 236, 120, 252, 14, 220, 123, 204, 97, 204, 120, 68, 14, 0, 8, 14,
  14, 16, 4, 255, 128, 124, 3, 121, 197, 205, 158, 128, 124, 3, 121, 197,
  205, 158, 7, 5, 5, 16, 5, 255, 124, 2, 114, 202, 220, 10, 6, 12,
  16, 5, 255, 3, 128, 112, 64, 10, 64, 77, 64, 173, 128, 176, 0, 14,
  14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219, 236, 231,
  156, 255, 252, 255, 252, 195, 108, 223, 108, 199, 12, 223, 236, 195, 236, 255,
  252, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219,
  236, 231, 156, 255, 252, 255, 252, 195, 12, 223, 124, 199, 12, 223, 236, 195,
  12, 255, 252, 10, 11, 22, 16, 3, 0, 30, 0, 63, 0, 97, 128, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 97, 128, 63, 0, 30, 0, 9,
  12, 24, 16, 4, 0, 64, 0, 64, 0, 96, 0, 56, 0, 14, 0, 3,
  0, 1, 128, 97, 128, 225, 128, 225, 128, 195, 0, 126, 0, 10, 11, 22,
  16, 3, 0, 224, 0, 56, 0, 14, 0, 3, 0, 3, 0, 227, 0, 126,
  0, 28, 0, 6, 0, 1, 128, 0, 64, 12, 12, 24, 16, 2, 255, 131,
  192, 132, 96, 136, 48, 140, 48, 142, 48, 142, 48, 134, 48, 64, 48, 64,
  96, 32, 96, 17, 192, 15, 0, 11, 13, 26, 16, 2, 255, 31, 0, 63,
  128, 96, 192, 64, 64, 96, 192, 49, 128, 31, 0, 96, 192, 192, 96, 192,
  96, 224, 224, 127, 192, 31, 0, 11, 13, 26, 16, 2, 255, 7, 0, 30,
  0, 57, 96, 112, 192, 97, 128, 195, 0, 198, 0, 198, 0, 198, 0, 198,
  0, 99, 96, 48, 192, 31, 128, 12, 12, 24, 16, 2, 255, 28, 0, 12,
  0, 12, 0, 140, 0, 140, 96, 140, 160, 141, 176, 199, 48, 64, 48, 96,
  48, 48, 96, 31, 192, 9, 13, 26, 16, 4, 255, 60, 0, 126, 0, 195,
  0, 195, 0, 199, 0, 127, 0, 59, 0, 3, 0, 3, 0, 3, 0, 3,
  0, 3, 0, 1, 128, 13, 13, 26, 16, 1, 255, 224, 0, 96, 0, 96,
  0, 96, 8, 103, 240, 127, 192, 112, 96, 96, 96, 96, 96, 96, 96, 112,
  192, 63, 128, 30, 0, 12, 15, 30, 16, 2, 254, 128, 0, 128, 0, 96,
  0, 60, 0, 15, 0, 3, 192, 0, 224, 0, 48, 60, 48, 66, 48, 225,
  48, 225, 48, 225, 96, 65, 192, 1, 0, 16, 12, 24, 16, 0, 255, 255,
  255, 0, 24, 0, 24, 0, 120, 3, 216, 7, 152, 28, 120, 31, 24, 1,
  216, 0, 120, 0, 56, 0, 8, 16, 13, 26, 16, 0, 254, 255, 255, 0,
  24, 0, 24, 0, 120, 3, 216, 7, 24, 28, 24, 31, 24, 1, 216, 28,
  120, 7, 56, 1, 136, 0, 64, 9, 8, 16, 16, 3, 3, 224, 0, 248,
  0, 124, 0, 14, 0, 3, 0, 1, 0, 0, 128, 0, 128, 12, 13, 26,
  16, 1, 255, 48, 0, 120, 0, 204, 0, 12, 0, 31, 240, 12, 0, 12,
  96, 12, 240, 12, 240, 12, 48, 12, 96, 7, 192, 3, 128, 9, 8, 16,
  16, 3, 2, 0, 128, 0, 128, 1, 0, 3, 0, 14, 0, 124, 0, 248,
  0, 224, 0, 12, 9, 18, 16, 2, 2, 56, 16, 124, 16, 226, 32, 242,
  96, 242, 192, 98, 192, 7, 128, 15, 0, 14, 0, 12, 13, 26, 16, 2,
  255, 0, 16, 0, 16, 0, 16, 56, 16, 124, 16, 126, 16, 62, 16, 6,
  48, 12, 96, 248, 224, 193, 192, 127, 128, 30, 0, 2, 13, 13, 16, 8,
  255, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 64, 11, 13,
  26, 16, 2, 255, 224, 0, 96, 0, 96, 192, 97, 192, 99, 192, 98, 192,
  102, 192, 108, 192, 120, 192, 112, 192, 96, 192, 0, 192, 0, 96, 11, 10,
  20, 16, 3, 1, 31, 0, 63, 128, 96, 192, 192, 96, 192, 96, 192, 96,
  192, 96, 96, 192, 63, 128, 31, 0, 14, 9, 18, 16, 1, 255, 0, 4,
  2, 4, 135, 8, 135, 8, 66, 16, 96, 48, 48, 96, 31, 192, 15, 0,
  6, 8, 8, 16, 5, 254, 96, 128, 128, 64, 32, 16, 8, 4, 14, 14,
  28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219, 236, 231, 156,
  255, 252, 255, 252, 195, 140, 223, 124, 199, 124, 223, 124, 223, 140, 255, 252,
  14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140, 219, 236,
  231, 156, 255, 252, 255, 252, 195, 28, 223, 108, 199, 108, 223, 108, 223, 28,
  255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108, 219, 140,
  219, 236, 231, 156, 255, 252, 255, 252, 195, 12, 223, 124, 199, 28, 223, 124,
  223, 12, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 231, 156, 219, 108,
  219, 140, 219, 236, 231, 156, 255, 252, 255, 252, 195, 12, 223, 124, 199, 28,
  223, 124, 223, 124, 255, 252
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 10, '1' Height: 8
  Calculated Max Values w=16 h=16 x= 4 y= 0 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent= 0
  X Font      ascent =14 descent= 0
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_2_3[4633] U8G_FONT_SECTION("u8g_font_unifont_2_3") = {
  0, 16, 16, 0, 254, 10, 4, 222, 7, 30, 0, 255, 0, 14, 254, 14,
  0, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 74, 81, 234, 80, 90, 81, 201, 158, 0, 1, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 6, 11, 11, 8, 1, 0, 120, 0, 0,
  120, 132, 4, 124, 132, 132, 140, 116, 6, 14, 14, 8, 1, 0, 132, 132,
  120, 0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132, 6, 13, 13, 8,
  1, 0, 132, 132, 120, 0, 0, 120, 132, 4, 124, 132, 132, 140, 116, 7,
  12, 12, 8, 1, 254, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132, 8,
  6, 7, 10, 10, 8, 1, 254, 120, 132, 4, 124, 132, 132, 140, 116, 8,
  6, 6, 14, 14, 8, 1, 0, 24, 96, 0, 0, 120, 132, 132, 128, 128,
  128, 128, 132, 132, 120, 6, 12, 12, 8, 1, 0, 24, 96, 0, 0, 120,
  132, 128, 128, 128, 128, 132, 120, 6, 14, 14, 8, 1, 0, 48, 72, 0,
  0, 120, 132, 132, 128, 128, 128, 128, 132, 132, 120, 6, 12, 12, 8, 1,
  0, 48, 72, 0, 0, 120, 132, 128, 128, 128, 128, 132, 120, 6, 14, 14,
  8, 1, 0, 32, 32, 0, 0, 120, 132, 132, 128, 128, 128, 128, 132, 132,
  120, 6, 12, 12, 8, 1, 0, 32, 32, 0, 0, 120, 132, 128, 128, 128,
  128, 132, 120, 6, 14, 14, 8, 1, 0, 72, 48, 0, 0, 120, 132, 132,
  128, 128, 128, 128, 132, 132, 120, 6, 12, 12, 8, 1, 0, 72, 48, 0,
  0, 120, 132, 128, 128, 128, 128, 132, 120, 6, 14, 14, 8, 1, 0, 144,
  96, 0, 0, 240, 136, 132, 132, 132, 132, 132, 132, 136, 240, 6, 14, 14,
  8, 1, 0, 72, 48, 0, 4, 4, 4, 116, 140, 132, 132, 132, 132, 140,
  116, 7, 10, 10, 8, 0, 0, 120, 68, 66, 66, 242, 66, 66, 66, 68,
  120, 7, 11, 11, 8, 1, 0, 4, 30, 4, 116, 140, 132, 132, 132, 132,
  140, 116, 6, 13, 13, 8, 1, 0, 120, 0, 0, 252, 128, 128, 128, 248,
  128, 128, 128, 128, 252, 6, 11, 11, 8, 1, 0, 120, 0, 0, 120, 132,
  132, 252, 128, 128, 132, 120, 6, 14, 14, 8, 1, 0, 132, 132, 120, 0,
  252, 128, 128, 128, 248, 128, 128, 128, 128, 252, 6, 12, 12, 8, 1, 0,
  132, 132, 120, 0, 120, 132, 132, 252, 128, 128, 132, 120, 6, 14, 14, 8,
  1, 0, 32, 32, 0, 0, 252, 128, 128, 128, 248, 128, 128, 128, 128, 252,
  6, 12, 12, 8, 1, 0, 32, 32, 0, 0, 120, 132, 132, 252, 128, 128,
  132, 120, 6, 12, 12, 8, 1, 254, 252, 128, 128, 128, 248, 128, 128, 128,
  128, 252, 16, 12, 6, 10, 10, 8, 1, 254, 120, 132, 132, 252, 128, 128,
  132, 120, 32, 24, 6, 14, 14, 8, 1, 0, 72, 48, 0, 0, 252, 128,
  128, 128, 248, 128, 128, 128, 128, 252, 6, 12, 12, 8, 1, 0, 72, 48,
  0, 0, 120, 132, 132, 252, 128, 128, 132, 120, 6, 14, 14, 8, 1, 0,
  48, 72, 0, 0, 120, 132, 132, 128, 128, 156, 132, 132, 140, 116, 6, 14,
  14, 8, 1, 254, 48, 72, 0, 4, 116, 136, 136, 136, 112, 64, 120, 132,
  132, 120, 6, 14, 14, 8, 1, 0, 132, 132, 120, 0, 120, 132, 132, 128,
  128, 156, 132, 132, 140, 116, 6, 15, 15, 8, 1, 254, 132, 132, 120, 0,
  4, 116, 136, 136, 136, 112, 64, 120, 132, 132, 120, 6, 14, 14, 8, 1,
  0, 32, 32, 0, 0, 120, 132, 132, 128, 128, 156, 132, 132, 140, 116, 6,
  14, 14, 8, 1, 254, 32, 32, 0, 4, 116, 136, 136, 136, 112, 64, 120,
  132, 132, 120, 6, 12, 12, 8, 1, 254, 120, 132, 132, 128, 128, 156, 132,
  132, 140, 116, 16, 96, 6, 14, 14, 8, 1, 254, 24, 32, 0, 4, 116,
  136, 136, 136, 112, 64, 120, 132, 132, 120, 6, 14, 14, 8, 1, 0, 48,
  72, 0, 0, 132, 132, 132, 132, 252, 132, 132, 132, 132, 132, 6, 14, 14,
  8, 1, 0, 96, 144, 0, 128, 128, 128, 184, 196, 132, 132, 132, 132, 132,
  132, 8, 10, 10, 8, 0, 0, 66, 66, 255, 66, 66, 126, 66, 66, 66,
  66, 7, 11, 11, 8, 0, 0, 64, 240, 64, 92, 98, 66, 66, 66, 66,
  66, 66, 6, 14, 14, 8, 1, 0, 100, 152, 0, 0, 124, 16, 16, 16,
  16, 16, 16, 16, 16, 124, 6, 12, 12, 8, 1, 0, 100, 152, 0, 0,
  48, 16, 16, 16, 16, 16, 16, 124, 5, 13, 13, 8, 2, 0, 240, 0,
  0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 248, 5, 11, 11, 8, 2,
  0, 240, 0, 0, 96, 32, 32, 32, 32, 32, 32, 248, 6, 14, 14, 8,
  1, 0, 132, 132, 120, 0, 124, 16, 16, 16, 16, 16, 16, 16, 16, 124,
  6, 12, 12, 8, 1, 0, 132, 132, 120, 0, 48, 16, 16, 16, 16, 16,
  16, 124, 5, 12, 12, 8, 2, 254, 248, 32, 32, 32, 32, 32, 32, 32,
  32, 248, 32, 24, 5, 13, 13, 8, 2, 254, 32, 32, 0, 96, 32, 32,
  32, 32, 32, 32, 248, 32, 24, 5, 14, 14, 8, 2, 0, 32, 32, 0,
  0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 248, 5, 8, 8, 8, 2,
  0, 96, 32, 32, 32, 32, 32, 32, 248, 6, 10, 10, 8, 1, 0, 132,
  132, 132, 132, 132, 132, 4, 4, 132, 120, 5, 14, 14, 8, 2, 254, 136,
  136, 0, 0, 136, 136, 136, 136, 136, 136, 104, 8, 136, 112, 7, 14, 14,
  8, 1, 0, 24, 36, 0, 0, 62, 8, 8, 8, 8, 8, 8, 136, 136,
  112, 6, 14, 14, 8, 1, 254, 24, 36, 0, 0, 24, 8, 8, 8, 8,
  8, 8, 8, 144, 96, 7, 12, 12, 8, 0, 254, 66, 68, 72, 80, 96,
  96, 80, 72, 68, 66, 32, 192, 7, 13, 13, 8, 0, 254, 64, 64, 64,
  68, 72, 80, 96, 80, 72, 68, 66, 32, 192, 6, 8, 8, 8, 1, 0,
  132, 136, 144, 224, 224, 144, 136, 132, 6, 14, 14, 8, 1, 0, 48, 192,
  0, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 252, 5, 14, 14, 8,
  2, 0, 48, 192, 0, 96, 32, 32, 32, 32, 32, 32, 32, 32, 32, 248,
  6, 12, 12, 8, 1, 254, 128, 128, 128, 128, 128, 128, 128, 128, 128, 252,
  16, 96, 5, 13, 13, 8, 2, 254, 96, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 248, 32, 192, 6, 14, 14, 8, 1, 0, 72, 48, 0, 0, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 252, 5, 14, 14, 8, 2, 0, 144,
  96, 0, 96, 32, 32, 32, 32, 32, 32, 32, 32, 32, 248, 6, 10, 10,
  8, 1, 0, 128, 128, 128, 128, 136, 136, 128, 128, 128, 252, 5, 11, 11,
  8, 1, 0, 96, 32, 32, 32, 32, 40, 40, 32, 32, 32, 248, 7, 10,
  10, 8, 0, 0, 64, 64, 72, 80, 96, 192, 64, 64, 64, 126, 5, 11,
  11, 8, 2, 0, 96, 32, 32, 40, 48, 96, 160, 32, 32, 32, 248, 6,
  14, 14, 8, 1, 0, 24, 96, 0, 0, 132, 196, 196, 164, 164, 148, 148,
  140, 140, 132, 6, 12, 12, 8, 1, 0, 24, 96, 0, 0, 184, 196, 132,
  132, 132, 132, 132, 132, 7, 12, 12, 8, 0, 254, 66, 98, 98, 82, 82,
  74, 74, 70, 70, 66, 32, 192, 7, 10, 10, 8, 0, 254, 92, 98, 66,
  66, 66, 66, 66, 66, 32, 192, 6, 14, 14, 8, 1, 0, 72, 48, 0,
  0, 132, 196, 196, 164, 164, 148, 148, 140, 140, 132, 6, 12, 12, 8, 1,
  0, 72, 48, 0, 0, 184, 196, 132, 132, 132, 132, 132, 132, 6, 13, 13,
  8, 1, 0, 192, 64, 64, 128, 0, 184, 196, 132, 132, 132, 132, 132, 132,
  6, 10, 10, 8, 1, 0, 184, 196, 132, 132, 132, 132, 132, 132, 132, 152,
  6, 10, 10, 8, 1, 254, 184, 196, 132, 132, 132, 132, 132, 132, 4, 24,
  6, 13, 13, 8, 1, 0, 120, 0, 0, 120, 132, 132, 132, 132, 132, 132,
  132, 132, 120, 6, 11, 11, 8, 1, 0, 120, 0, 0, 120, 132, 132, 132,
  132, 132, 132, 120, 6, 14, 14, 8, 1, 0, 132, 132, 120, 0, 120, 132,
  132, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 8, 1, 0, 132, 132,
  120, 0, 120, 132, 132, 132, 132, 132, 132, 120, 7, 14, 14, 8, 1, 0,
  102, 136, 0, 0, 120, 132, 132, 132, 132, 132, 132, 132, 132, 120, 7, 12,
  12, 8, 1, 0, 102, 136, 0, 0, 120, 132, 132, 132, 132, 132, 132, 120,
  7, 10, 10, 8, 1, 0, 110, 144, 144, 144, 156, 144, 144, 144, 144, 110,
  7, 8, 8, 8, 1, 0, 108, 146, 146, 158, 144, 144, 146, 108, 6, 14,
  14, 8, 1, 0, 24, 96, 0, 0, 248, 132, 132, 132, 248, 144, 136, 136,
  132, 132, 6, 12, 12, 8, 1, 0, 24, 96, 0, 0, 184, 196, 132, 128,
  128, 128, 128, 128, 7, 12, 12, 8, 0, 254, 124, 66, 66, 66, 124, 72,
  68, 68, 66, 66, 32, 192, 7, 10, 10, 8, 0, 254, 92, 98, 66, 64,
  64, 64, 64, 64, 32, 192, 6, 14, 14, 8, 1, 0, 72, 48, 0, 0,
  248, 132, 132, 132, 248, 144, 136, 136, 132, 132, 6, 12, 12, 8, 1, 0,
  72, 48, 0, 0, 184, 196, 132, 128, 128, 128, 128, 128, 6, 14, 14, 8,
  1, 0, 24, 96, 0, 0, 120, 132, 132, 128, 96, 24, 4, 132, 132, 120,
  6, 12, 12, 8, 1, 0, 24, 96, 0, 0, 120, 132, 128, 96, 24, 132,
  132, 120, 6, 14, 14, 8, 1, 0, 48, 72, 0, 0, 120, 132, 132, 128,
  96, 24, 4, 132, 132, 120, 6, 12, 12, 8, 1, 0, 48, 72, 0, 0,
  120, 132, 128, 96, 24, 4, 132, 120, 6, 12, 12, 8, 1, 254, 120, 132,
  132, 128, 96, 24, 4, 132, 132, 120, 16, 96, 6, 10, 10, 8, 1, 254,
  120, 132, 128, 96, 24, 4, 132, 120, 16, 96, 6, 14, 14, 8, 1, 0,
  72, 48, 0, 0, 120, 132, 132, 128, 96, 24, 4, 132, 132, 120, 6, 12,
  12, 8, 1, 0, 72, 48, 0, 0, 120, 132, 128, 96, 24, 4, 132, 120,
  7, 12, 12, 8, 1, 254, 254, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  16, 96, 5, 12, 12, 8, 1, 254, 32, 32, 32, 248, 32, 32, 32, 32,
  32, 24, 16, 96, 7, 14, 14, 8, 1, 0, 72, 48, 0, 0, 254, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 5, 14, 14, 8, 1, 0, 72, 48,
  0, 0, 32, 32, 32, 248, 32, 32, 32, 32, 32, 24, 7, 10, 10, 8,
  1, 0, 254, 16, 16, 20, 24, 48, 80, 16, 16, 16, 5, 10, 10, 8,
  1, 0, 32, 32, 32, 248, 32, 40, 48, 96, 160, 24, 6, 14, 14, 8,
  1, 0, 100, 152, 0, 0, 132, 132, 132, 132, 132, 132, 132, 132, 132, 120,
  6, 12, 12, 8, 1, 0, 100, 152, 0, 0, 132, 132, 132, 132, 132, 132,
  140, 116, 6, 13, 13, 8, 1, 0, 120, 0, 0, 132, 132, 132, 132, 132,
  132, 132, 132, 132, 120, 6, 11, 11, 8, 1, 0, 120, 0, 0, 132, 132,
  132, 132, 132, 132, 140, 116, 6, 14, 14, 8, 1, 0, 132, 132, 120, 0,
  132, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 13, 13, 8, 1, 0,
  132, 132, 120, 0, 0, 132, 132, 132, 132, 132, 132, 140, 116, 6, 14, 14,
  8, 1, 0, 48, 72, 48, 0, 132, 132, 132, 132, 132, 132, 132, 132, 132,
  120, 6, 12, 12, 8, 1, 0, 48, 72, 48, 0, 132, 132, 132, 132, 132,
  132, 140, 116, 7, 14, 14, 8, 1, 0, 102, 136, 0, 0, 132, 132, 132,
  132, 132, 132, 132, 132, 132, 120, 7, 12, 12, 8, 1, 0, 102, 136, 0,
  0, 132, 132, 132, 132, 132, 132, 140, 116, 6, 12, 12, 8, 1, 254, 132,
  132, 132, 132, 132, 132, 132, 132, 132, 120, 32, 24, 7, 10, 10, 8, 1,
  254, 132, 132, 132, 132, 132, 132, 140, 116, 8, 6, 6, 14, 14, 8, 1,
  0, 48, 72, 0, 0, 132, 132, 132, 132, 180, 180, 204, 204, 132, 132, 7,
  12, 12, 8, 1, 0, 48, 72, 0, 0, 130, 146, 146, 146, 146, 146, 146,
  108, 7, 14, 14, 8, 1, 0, 48, 72, 0, 0, 130, 130, 68, 68, 40,
  16, 16, 16, 16, 16, 6, 14, 14, 8, 1, 254, 48, 72, 0, 0, 132,
  132, 132, 132, 132, 76, 52, 4, 4, 120, 7, 14, 14, 8, 1, 0, 72,
  72, 0, 0, 130, 130, 68, 68, 40, 16, 16, 16, 16, 16, 6, 14, 14,
  8, 1, 0, 24, 96, 0, 0, 252, 4, 4, 8, 16, 32, 64, 128, 128,
  252, 6, 12, 12, 8, 1, 0, 24, 96, 0, 0, 252, 4, 8, 16, 32,
  64, 128, 252, 6, 14, 14, 8, 1, 0, 32, 32, 0, 0, 252, 4, 4,
  8, 16, 32, 64, 128, 128, 252, 6, 12, 12, 8, 1, 0, 32, 32, 0,
  0, 252, 4, 8, 16, 32, 64, 128, 252, 6, 14, 14, 8, 1, 0, 72,
  48, 0, 0, 252, 4, 4, 8, 16, 32, 64, 128, 128, 252, 6, 12, 12,
  8, 1, 0, 72, 48, 0, 0, 252, 4, 8, 16, 32, 64, 128, 252, 4,
  11, 11, 8, 2, 0, 48, 64, 64, 64, 192, 64, 64, 64, 64, 64, 64,
  7, 11, 11, 8, 0, 0, 64, 240, 64, 92, 98, 66, 66, 66, 66, 98,
  92, 7, 10, 10, 8, 0, 0, 124, 162, 162, 34, 60, 34, 34, 34, 34,
  60, 6, 10, 10, 8, 1, 0, 252, 128, 128, 128, 248, 132, 132, 132, 132,
  248, 6, 10, 10, 8, 1, 0, 252, 128, 128, 184, 196, 132, 132, 132, 196,
  184, 6, 10, 10, 8, 1, 0, 192, 64, 64, 64, 120, 68, 68, 68, 68,
  120, 6, 8, 8, 8, 1, 0, 192, 64, 64, 64, 120, 68, 68, 120, 6,
  10, 10, 8, 1, 0, 120, 132, 132, 4, 4, 4, 4, 132, 132, 248, 7,
  12, 12, 8, 1, 0, 6, 8, 120, 136, 136, 128, 128, 128, 128, 136, 136,
  112, 7, 10, 10, 8, 1, 0, 6, 8, 120, 136, 128, 128, 128, 128, 136,
  112, 7, 10, 10, 8, 0, 0, 120, 68, 66, 66, 242, 66, 66, 66, 68,
  120, 7, 10, 10, 8, 0, 0, 120, 164, 162, 34, 34, 34, 34, 34, 36,
  56, 6, 10, 10, 8, 1, 0, 252, 4, 4, 4, 124, 132, 132, 132, 132,
  124, 6, 10, 10, 8, 1, 0, 252, 4, 4, 116, 140, 132, 132, 132, 140,
  116, 6, 10, 10, 8, 1, 254, 120, 132, 132, 132, 132, 72, 48, 8, 8,
  112, 6, 10, 10, 8, 1, 0, 252, 4, 4, 4, 124, 4, 4, 4, 4,
  252, 6, 10, 10, 8, 1, 0, 48, 72, 132, 4, 4, 252, 132, 132, 72,
  48, 6, 10, 10, 8, 1, 0, 120, 132, 132, 128, 112, 128, 128, 132, 132,
  120, 7, 11, 11, 8, 1, 255, 62, 32, 32, 32, 60, 32, 32, 32, 32,
  32, 192, 5, 12, 12, 8, 1, 255, 24, 32, 32, 32, 248, 32, 32, 32,
  32, 32, 32, 192, 7, 11, 11, 8, 1, 0, 6, 120, 136, 136, 128, 128,
  184, 136, 136, 152, 104, 6, 10, 10, 8, 1, 0, 132, 132, 132, 72, 72,
  48, 48, 72, 72, 48, 6, 11, 11, 8, 1, 0, 128, 128, 128, 128, 228,
  148, 148, 148, 148, 148, 136, 5, 11, 11, 8, 1, 0, 224, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 24, 5, 10, 10, 8, 2, 0, 248, 32, 32,
  32, 248, 32, 32, 32, 32, 248, 6, 10, 10, 8, 1, 0, 140, 148, 160,
  160, 192, 192, 160, 144, 136, 132, 6, 11, 11, 8, 1, 0, 96, 144, 128,
  136, 144, 160, 192, 160, 144, 136, 132, 5, 11, 11, 8, 2, 0, 96, 32,
  32, 32, 248, 32, 32, 32, 32, 32, 248, 6, 10, 10, 8, 1, 0, 72,
  80, 32, 96, 144, 48, 72, 72, 132, 132, 7, 10, 10, 8, 1, 0, 146,
  146, 146, 146, 146, 146, 146, 146, 146, 110, 7, 11, 11, 8, 0, 255, 34,
  34, 50, 50, 42, 42, 38, 38, 34, 34, 192, 6, 10, 10, 8, 1, 254,
  184, 196, 132, 132, 132, 132, 132, 132, 4, 4, 6, 10, 10, 8, 1, 0,
  120, 132, 132, 132, 252, 132, 132, 132, 132, 120, 6, 11, 11, 8, 1, 0,
  4, 116, 136, 136, 136, 136, 136, 136, 136, 136, 112, 6, 9, 9, 8, 1,
  0, 4, 116, 136, 136, 136, 136, 136, 136, 112, 6, 12, 12, 8, 1, 254,
  108, 148, 148, 148, 148, 148, 148, 148, 148, 100, 4, 4, 6, 10, 10, 8,
  1, 254, 108, 148, 148, 148, 148, 148, 148, 100, 4, 4, 7, 10, 10, 8,
  1, 0, 124, 162, 162, 34, 60, 32, 32, 32, 32, 32, 7, 11, 11, 8,
  1, 254, 6, 184, 200, 136, 136, 136, 136, 200, 176, 128, 128, 7, 10, 10,
  8, 1, 0, 224, 64, 120, 68, 68, 120, 80, 72, 68, 66, 6, 10, 10,
  8, 1, 0, 120, 132, 132, 4, 24, 96, 128, 132, 132, 120, 6, 8, 8,
  8, 1, 0, 120, 132, 4, 24, 96, 128, 132, 120, 6, 10, 10, 8, 1,
  0, 252, 128, 64, 32, 16, 16, 32, 64, 128, 252, 5, 12, 12, 8, 1,
  255, 64, 160, 160, 96, 32, 32, 32, 32, 32, 32, 32, 24, 5, 12, 12,
  8, 1, 254, 32, 32, 32, 248, 32, 32, 32, 32, 32, 24, 8, 48, 7,
  10, 10, 8, 1, 0, 126, 144, 144, 16, 16, 16, 16, 16, 16, 16, 5,
  11, 11, 8, 1, 0, 24, 32, 32, 32, 248, 32, 32, 32, 32, 32, 24,
  7, 11, 11, 8, 1, 255, 254, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  12, 7, 12, 12, 8, 1, 0, 2, 2, 140, 136, 136, 136, 136, 136, 136,
  136, 136, 112, 7, 10, 10, 8, 1, 0, 2, 2, 140, 136, 136, 136, 136,
  136, 152, 104, 6, 10, 10, 8, 1, 0, 132, 72, 72, 132, 132, 132, 132,
  132, 72, 48, 6, 10, 10, 8, 1, 0, 152, 132, 132, 132, 132, 132, 132,
  136, 144, 96, 7, 10, 10, 8, 1, 0, 140, 138, 136, 80, 80, 32, 32,
  32, 32, 32, 7, 11, 11, 8, 1, 254, 6, 136, 136, 136, 136, 136, 72,
  56, 8, 8, 112, 6, 10, 10, 8, 1, 0, 252, 4, 8, 16, 120, 32,
  64, 128, 128, 252, 6, 8, 8, 8, 1, 0, 252, 8, 16, 120, 32, 64,
  128, 252, 6, 10, 10, 8, 1, 0, 252, 8, 16, 32, 56, 4, 4, 4,
  140, 120, 6, 10, 10, 8, 1, 0, 252, 64, 32, 16, 112, 128, 128, 128,
  196, 120, 6, 10, 10, 8, 1, 254, 248, 64, 32, 16, 112, 128, 128, 128,
  132, 120, 6, 10, 10, 8, 1, 254, 124, 8, 16, 56, 4, 4, 120, 128,
  132, 120, 6, 10, 10, 8, 1, 0, 120, 132, 132, 8, 16, 252, 64, 128,
  128, 252, 6, 10, 10, 8, 1, 0, 252, 64, 64, 64, 120, 4, 4, 4,
  132, 120, 6, 8, 8, 8, 1, 0, 252, 64, 64, 120, 4, 4, 132, 120,
  5, 10, 10, 8, 1, 0, 32, 32, 248, 32, 32, 48, 8, 8, 136, 112,
  6, 10, 10, 8, 1, 254, 184, 196, 132, 132, 136, 144, 160, 192, 128, 128,
  1, 11, 11, 8, 3, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 3, 11, 11, 8, 2, 0, 160, 160, 160, 160, 160, 160, 160, 160, 160,
  160, 160, 5, 11, 11, 8, 1, 0, 32, 32, 32, 32, 248, 32, 248, 32,
  32, 32, 32, 1, 10, 10, 8, 4, 0, 128, 128, 128, 128, 128, 128, 128,
  0, 128, 128, 7, 14, 14, 8, 1, 0, 10, 4, 0, 0, 206, 162, 162,
  162, 164, 164, 168, 168, 168, 206, 7, 12, 12, 8, 1, 0, 10, 4, 192,
  160, 174, 162, 162, 164, 164, 168, 168, 206, 7, 12, 12, 8, 1, 0, 10,
  36, 32, 32, 110, 162, 162, 164, 164, 168, 168, 110, 7, 10, 10, 8, 1,
  0, 142, 130, 130, 130, 130, 130, 130, 146, 146, 236, 7, 13, 13, 8, 1,
  254, 2, 130, 128, 134, 130, 130, 130, 130, 130, 130, 242, 4, 24, 8, 13,
  13, 8, 0, 254, 97, 33, 32, 35, 33, 33, 33, 33, 33, 33, 249, 2,
  12, 7, 10, 10, 8, 1, 0, 150, 146, 146, 210, 210, 178, 178, 154, 154,
  148, 7, 13, 13, 8, 1, 254, 2, 146, 144, 214, 210, 210, 178, 178, 178,
  146, 146, 36, 24, 7, 13, 13, 8, 1, 254, 2, 2, 0, 166, 210, 146,
  146, 146, 146, 146, 146, 36, 24, 6, 14, 14, 8, 1, 0, 72, 48, 0,
  0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132, 6, 12, 12, 8, 1,
  0, 72, 48, 0, 0, 120, 132, 4, 124, 132, 132, 140, 116, 5, 14, 14,
  8, 2, 0, 144, 96, 0, 0, 248, 32, 32, 32, 32, 32, 32, 32, 32,
  248, 5, 12, 12, 8, 2, 0, 144, 96, 0, 0, 96, 32, 32, 32, 32,
  32, 32, 248, 6, 14, 14, 8, 1, 0, 72, 48, 0, 0, 120, 132, 132,
  132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 8, 1, 0, 72, 48, 0,
  0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 14, 14, 8, 1, 0, 72,
  48, 0, 0, 132, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12,
  8, 1, 0, 72, 48, 0, 0, 132, 132, 132, 132, 132, 132, 140, 116, 6,
  14, 14, 8, 1, 0, 120, 0, 72, 0, 132, 132, 132, 132, 132, 132, 132,
  132, 132, 120, 6, 13, 13, 8, 1, 0, 120, 0, 72, 72, 0, 132, 132,
  132, 132, 132, 132, 140, 116, 6, 14, 14, 8, 1, 0, 24, 96, 0, 72,
  0, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 14, 14, 8, 1, 0,
  24, 96, 0, 72, 72, 0, 132, 132, 132, 132, 132, 132, 140, 116, 6, 14,
  14, 8, 1, 0, 72, 48, 0, 72, 0, 132, 132, 132, 132, 132, 132, 132,
  132, 120, 6, 14, 14, 8, 1, 0, 72, 48, 0, 72, 72, 0, 132, 132,
  132, 132, 132, 132, 140, 116, 6, 14, 14, 8, 1, 0, 96, 24, 0, 72,
  0, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 14, 14, 8, 1, 0,
  96, 24, 0, 72, 72, 0, 132, 132, 132, 132, 132, 132, 140, 116, 6, 8,
  8, 8, 1, 0, 120, 132, 4, 4, 252, 132, 132, 120, 6, 14, 14, 8,
  1, 0, 120, 0, 72, 0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132,
  6, 13, 13, 8, 1, 0, 120, 0, 72, 72, 0, 120, 132, 4, 124, 132,
  132, 140, 116, 6, 14, 14, 8, 1, 0, 120, 0, 48, 0, 48, 72, 72,
  132, 132, 252, 132, 132, 132, 132, 6, 13, 13, 8, 1, 0, 120, 0, 32,
  32, 0, 120, 132, 4, 124, 132, 132, 140, 116, 7, 13, 13, 8, 1, 0,
  120, 0, 0, 62, 80, 144, 144, 254, 144, 144, 144, 144, 158, 7, 11, 11,
  8, 1, 0, 120, 0, 0, 124, 146, 18, 126, 144, 144, 146, 124, 7, 10,
  10, 8, 1, 0, 120, 132, 132, 128, 128, 156, 132, 158, 132, 124, 7, 11,
  11, 8, 1, 254, 4, 116, 136, 136, 136, 112, 64, 120, 158, 132, 120, 6,
  14, 14, 8, 1, 0, 72, 48, 0, 0, 120, 132, 132, 128, 128, 156, 132,
  132, 140, 116, 6, 14, 14, 8, 1, 254, 72, 48, 0, 4, 116, 136, 136,
  136, 112, 64, 120, 132, 132, 120, 6, 14, 14, 8, 1, 0, 72, 48, 0,
  0, 132, 136, 144, 160, 192, 192, 160, 144, 136, 132, 6, 14, 14, 8, 1,
  0, 72, 48, 0, 128, 128, 128, 136, 144, 160, 192, 160, 144, 136, 132, 6,
  12, 12, 8, 1, 254, 120, 132, 132, 132, 132, 132, 132, 132, 132, 120, 32,
  24, 6, 10, 10, 8, 1, 254, 120, 132, 132, 132, 132, 132, 132, 120, 32,
  24, 6, 15, 15, 8, 1, 254, 120, 0, 0, 120, 132, 132, 132, 132, 132,
  132, 132, 132, 120, 32, 24, 6, 13, 13, 8, 1, 254, 120, 0, 0, 120,
  132, 132, 132, 132, 132, 132, 120, 32, 24, 6, 14, 14, 8, 1, 0, 72,
  48, 0, 0, 252, 8, 16, 32, 56, 4, 4, 4, 140, 120, 6, 14, 14,
  8, 1, 254, 72, 48, 0, 0, 124, 8, 16, 32, 56, 4, 4, 4, 132,
  120, 6, 14, 14, 8, 1, 254, 36, 24, 0, 0, 24, 8, 8, 8, 8,
  8, 8, 8, 144, 96, 7, 10, 10, 8, 1, 0, 206, 162, 162, 162, 164,
  164, 168, 168, 168, 206, 7, 10, 10, 8, 1, 0, 192, 160, 174, 162, 162,
  164, 164, 168, 168, 206, 7, 11, 11, 8, 1, 0, 32, 32, 32, 110, 162,
  162, 164, 164, 168, 168, 110, 6, 14, 14, 8, 1, 0, 24, 96, 0, 0,
  120, 132, 132, 128, 128, 156, 132, 132, 140, 116, 6, 14, 14, 8, 1, 254,
  24, 96, 0, 4, 116, 136, 136, 136, 112, 64, 120, 132, 132, 120, 6, 10,
  10, 8, 1, 0, 144, 144, 144, 148, 244, 148, 148, 148, 148, 136, 6, 11,
  11, 8, 1, 255, 184, 196, 132, 132, 136, 144, 160, 192, 128, 128, 128, 6,
  13, 13, 8, 1, 0, 96, 24, 0, 132, 196, 196, 164, 164, 148, 148, 140,
  140, 132, 6, 11, 11, 8, 1, 0, 96, 24, 0, 184, 196, 132, 132, 132,
  132, 132, 132, 6, 14, 14, 8, 1, 0, 24, 96, 48, 72, 48, 48, 72,
  72, 132, 252, 132, 132, 132, 132, 6, 14, 14, 8, 1, 0, 24, 96, 0,
  48, 72, 48, 0, 120, 132, 4, 124, 132, 140, 116, 7, 14, 14, 8, 1,
  0, 12, 48, 0, 0, 62, 80, 144, 144, 254, 144, 144, 144, 144, 158, 7,
  12, 12, 8, 1, 0, 12, 48, 0, 0, 124, 146, 18, 126, 144, 144, 146,
  124, 6, 15, 15, 8, 1, 255, 24, 96, 0, 4, 116, 136, 140, 148, 148,
  164, 164, 196, 68, 184, 128, 6, 13, 13, 8, 1, 255, 24, 96, 0, 4,
  120, 140, 148, 148, 164, 164, 196, 120, 128
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 10, '1' Height: 12
  Calculated Max Values w=16 h=16 x= 4 y=10 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent= 0
  X Font      ascent =12 descent=-2
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_4_5[3791] U8G_FONT_SECTION("u8g_font_unifont_4_5") = {
  0, 16, 16, 0, 254, 10, 4, 177, 6, 164, 0, 255, 0, 14, 254, 12,
  254, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 74, 81, 234, 80, 90, 81, 201, 158, 0, 1, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 7, 12, 12, 8, 0, 0, 204, 34, 0,
  0, 60, 66, 2, 62, 66, 66, 70, 58, 6, 14, 14, 8, 1, 0, 120,
  132, 132, 0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132, 6, 12, 12,
  8, 1, 0, 120, 132, 132, 0, 120, 132, 4, 124, 132, 132, 140, 116, 7,
  14, 14, 8, 0, 0, 204, 34, 0, 0, 126, 64, 64, 64, 124, 64, 64,
  64, 64, 126, 7, 12, 12, 8, 0, 0, 204, 34, 0, 0, 60, 66, 66,
  126, 64, 64, 66, 60, 6, 14, 14, 8, 1, 0, 120, 132, 132, 0, 252,
  128, 128, 128, 248, 128, 128, 128, 128, 252, 6, 12, 12, 8, 1, 0, 120,
  132, 132, 0, 120, 132, 132, 252, 128, 128, 132, 120, 7, 14, 14, 8, 0,
  0, 204, 34, 0, 0, 62, 8, 8, 8, 8, 8, 8, 8, 8, 62, 7,
  12, 12, 8, 0, 0, 204, 34, 0, 0, 24, 8, 8, 8, 8, 8, 8,
  62, 6, 14, 14, 8, 1, 0, 120, 132, 132, 0, 124, 16, 16, 16, 16,
  16, 16, 16, 16, 124, 6, 12, 12, 8, 1, 0, 120, 132, 132, 0, 48,
  16, 16, 16, 16, 16, 16, 124, 7, 14, 14, 8, 0, 0, 204, 34, 0,
  0, 60, 66, 66, 66, 66, 66, 66, 66, 66, 60, 7, 12, 12, 8, 0,
  0, 204, 34, 0, 0, 60, 66, 66, 66, 66, 66, 66, 60, 6, 14, 14,
  8, 1, 0, 120, 132, 132, 0, 120, 132, 132, 132, 132, 132, 132, 132, 132,
  120, 6, 12, 12, 8, 1, 0, 120, 132, 132, 0, 120, 132, 132, 132, 132,
  132, 132, 120, 7, 14, 14, 8, 0, 0, 204, 34, 0, 0, 124, 66, 66,
  66, 124, 72, 68, 68, 66, 66, 7, 12, 12, 8, 0, 0, 204, 34, 0,
  0, 92, 98, 66, 64, 64, 64, 64, 64, 6, 14, 14, 8, 1, 0, 120,
  132, 132, 0, 248, 132, 132, 132, 248, 144, 136, 136, 132, 132, 6, 12, 12,
  8, 1, 0, 120, 132, 132, 0, 184, 196, 132, 128, 128, 128, 128, 128, 7,
  14, 14, 8, 0, 0, 204, 34, 0, 0, 66, 66, 66, 66, 66, 66, 66,
  66, 66, 60, 7, 12, 12, 8, 0, 0, 204, 34, 0, 0, 66, 66, 66,
  66, 66, 66, 70, 58, 6, 14, 14, 8, 1, 0, 120, 132, 132, 0, 132,
  132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 8, 1, 0, 120,
  132, 132, 0, 132, 132, 132, 132, 132, 132, 140, 116, 6, 12, 12, 8, 1,
  254, 120, 132, 132, 128, 96, 24, 4, 132, 132, 120, 16, 32, 6, 10, 10,
  8, 1, 254, 120, 132, 128, 96, 24, 4, 132, 120, 16, 32, 7, 12, 12,
  8, 1, 254, 254, 16, 16, 16, 16, 16, 16, 16, 16, 16, 4, 8, 5,
  12, 12, 8, 1, 254, 32, 32, 32, 248, 32, 32, 32, 32, 32, 24, 64,
  128, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4, 24, 104, 4, 4, 4,
  120, 6, 8, 8, 8, 1, 0, 120, 132, 4, 24, 100, 4, 24, 96, 6,
  13, 13, 8, 1, 0, 72, 48, 0, 132, 132, 132, 132, 252, 132, 132, 132,
  132, 132, 6, 13, 13, 8, 1, 0, 72, 48, 0, 128, 128, 128, 184, 196,
  132, 132, 132, 132, 132, 6, 10, 10, 8, 1, 254, 184, 196, 132, 132, 132,
  132, 132, 132, 4, 4, 7, 13, 13, 8, 1, 254, 4, 4, 4, 116, 140,
  132, 132, 132, 132, 142, 118, 4, 8, 6, 10, 10, 8, 1, 0, 16, 72,
  132, 132, 72, 120, 132, 132, 132, 120, 5, 8, 8, 8, 2, 0, 72, 136,
  144, 96, 144, 136, 136, 112, 6, 12, 12, 8, 1, 254, 252, 4, 4, 8,
  16, 32, 64, 128, 128, 252, 4, 8, 6, 10, 10, 8, 1, 254, 252, 4,
  8, 16, 32, 64, 128, 252, 4, 8, 6, 12, 12, 8, 1, 0, 16, 0,
  48, 72, 72, 132, 132, 252, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0,
  16, 0, 120, 132, 4, 124, 132, 132, 140, 116, 6, 12, 12, 8, 1, 254,
  252, 128, 128, 128, 248, 128, 128, 128, 128, 252, 16, 96, 6, 10, 10, 8,
  1, 254, 120, 132, 132, 252, 128, 128, 132, 120, 16, 96, 6, 14, 14, 8,
  1, 0, 120, 0, 72, 0, 120, 132, 132, 132, 132, 132, 132, 132, 132, 120,
  6, 12, 12, 8, 1, 0, 120, 0, 72, 0, 120, 132, 132, 132, 132, 132,
  132, 120, 6, 14, 14, 8, 1, 0, 120, 0, 100, 152, 0, 120, 132, 132,
  132, 132, 132, 132, 132, 120, 6, 13, 13, 8, 1, 0, 120, 0, 100, 152,
  0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 8, 1, 0, 16,
  0, 120, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 10, 10, 8, 1,
  0, 16, 0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 14, 14, 8, 1,
  0, 120, 0, 16, 0, 120, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6,
  12, 12, 8, 1, 0, 120, 0, 16, 0, 120, 132, 132, 132, 132, 132, 132,
  120, 7, 12, 12, 8, 1, 0, 124, 0, 130, 130, 68, 68, 40, 16, 16,
  16, 16, 16, 6, 12, 12, 8, 1, 254, 120, 0, 132, 132, 132, 132, 132,
  76, 52, 4, 4, 120, 4, 13, 13, 8, 2, 254, 96, 32, 32, 32, 32,
  32, 32, 32, 32, 48, 48, 64, 128, 7, 10, 10, 8, 1, 254, 184, 196,
  132, 132, 132, 132, 134, 134, 4, 8, 6, 12, 12, 8, 1, 254, 32, 32,
  32, 248, 32, 32, 32, 32, 44, 28, 16, 32, 5, 10, 10, 8, 1, 254,
  24, 8, 8, 8, 8, 8, 8, 8, 144, 96, 7, 11, 11, 8, 0, 0,
  16, 16, 16, 84, 186, 146, 146, 146, 146, 186, 84, 7, 10, 10, 8, 0,
  254, 84, 186, 146, 146, 146, 146, 186, 84, 16, 16, 7, 11, 11, 8, 0,
  0, 2, 26, 36, 44, 74, 82, 126, 98, 66, 66, 194, 7, 12, 12, 8,
  0, 255, 2, 60, 70, 74, 72, 80, 80, 96, 98, 66, 124, 128, 7, 11,
  11, 8, 0, 255, 2, 4, 60, 74, 80, 80, 96, 96, 66, 124, 128, 6,
  10, 10, 8, 1, 0, 64, 64, 64, 64, 240, 64, 64, 64, 64, 124, 7,
  12, 12, 8, 1, 0, 2, 4, 254, 24, 24, 16, 16, 48, 48, 80, 80,
  144, 7, 10, 10, 8, 1, 254, 120, 132, 128, 96, 24, 4, 132, 120, 18,
  12, 6, 10, 10, 8, 1, 254, 252, 4, 8, 16, 32, 64, 128, 192, 32,
  28, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4, 8, 16, 16, 16, 16,
  16, 6, 8, 8, 8, 1, 0, 120, 132, 132, 4, 8, 16, 16, 16, 6,
  10, 10, 8, 1, 0, 120, 68, 68, 68, 120, 68, 244, 68, 68, 120, 7,
  10, 10, 8, 0, 0, 68, 68, 68, 68, 68, 254, 68, 68, 68, 56, 6,
  10, 10, 8, 1, 0, 48, 48, 48, 72, 72, 72, 72, 132, 132, 132, 6,
  14, 14, 8, 1, 254, 8, 8, 252, 144, 144, 160, 248, 160, 160, 192, 192,
  252, 128, 128, 7, 10, 10, 8, 0, 255, 2, 60, 70, 74, 126, 80, 96,
  66, 124, 128, 7, 10, 10, 8, 1, 0, 62, 8, 8, 8, 8, 62, 8,
  136, 136, 112, 7, 13, 13, 8, 1, 254, 8, 8, 0, 24, 8, 8, 62,
  8, 8, 8, 8, 144, 96, 7, 12, 12, 8, 1, 254, 112, 136, 136, 136,
  136, 136, 136, 136, 152, 104, 8, 6, 7, 10, 10, 8, 1, 254, 104, 152,
  136, 136, 136, 136, 152, 104, 8, 6, 6, 10, 10, 8, 1, 0, 120, 68,
  68, 68, 248, 80, 72, 72, 68, 68, 6, 8, 8, 8, 1, 0, 88, 100,
  68, 224, 64, 64, 64, 64, 7, 10, 10, 8, 1, 0, 130, 130, 68, 254,
  40, 16, 16, 16, 16, 16, 7, 10, 10, 8, 1, 254, 68, 68, 68, 254,
  68, 36, 28, 4, 4, 56, 6, 8, 8, 8, 1, 0, 184, 196, 132, 132,
  248, 128, 132, 120, 6, 8, 8, 8, 1, 0, 116, 140, 132, 132, 132, 140,
  148, 100, 6, 8, 8, 8, 1, 0, 152, 164, 196, 132, 132, 132, 196, 184,
  6, 11, 11, 8, 1, 0, 112, 128, 128, 184, 196, 132, 132, 132, 132, 196,
  184, 6, 8, 8, 8, 1, 0, 120, 132, 4, 4, 4, 4, 132, 120, 6,
  9, 9, 8, 1, 255, 120, 132, 128, 128, 128, 152, 164, 120, 128, 7, 12,
  12, 8, 1, 255, 8, 8, 8, 104, 152, 136, 136, 136, 136, 152, 104, 6,
  7, 11, 11, 8, 1, 0, 6, 8, 8, 104, 152, 136, 136, 136, 136, 152,
  104, 6, 8, 8, 8, 1, 0, 120, 132, 132, 252, 4, 4, 132, 120, 6,
  8, 8, 8, 1, 0, 120, 132, 4, 4, 252, 132, 132, 120, 7, 8, 8,
  8, 1, 0, 114, 140, 8, 8, 248, 136, 136, 112, 6, 8, 8, 8, 1,
  0, 120, 132, 128, 120, 128, 128, 132, 120, 6, 8, 8, 8, 1, 0, 120,
  132, 4, 120, 4, 4, 132, 120, 7, 8, 8, 8, 1, 0, 114, 140, 8,
  112, 8, 8, 136, 112, 6, 8, 8, 8, 1, 0, 120, 132, 132, 184, 132,
  132, 132, 120, 7, 10, 10, 8, 1, 254, 24, 8, 8, 8, 62, 8, 8,
  8, 144, 96, 7, 11, 11, 8, 1, 254, 6, 104, 152, 136, 136, 136, 152,
  104, 8, 136, 112, 6, 10, 10, 8, 1, 254, 116, 140, 132, 132, 132, 140,
  116, 4, 132, 120, 6, 8, 8, 8, 1, 0, 120, 132, 128, 128, 156, 132,
  132, 124, 6, 10, 10, 8, 1, 254, 132, 132, 132, 72, 72, 48, 48, 72,
  72, 48, 6, 8, 8, 8, 1, 0, 132, 132, 72, 72, 48, 48, 72, 48,
  6, 11, 11, 8, 1, 254, 132, 132, 132, 132, 132, 132, 140, 116, 4, 4,
  4, 6, 11, 11, 8, 1, 0, 112, 128, 128, 184, 196, 132, 132, 132, 132,
  132, 132, 6, 11, 11, 8, 1, 0, 112, 128, 128, 184, 196, 132, 132, 132,
  132, 132, 152, 5, 11, 11, 8, 2, 0, 32, 32, 0, 96, 32, 32, 248,
  32, 32, 32, 248, 3, 8, 8, 8, 3, 0, 128, 128, 128, 128, 128, 128,
  128, 96, 5, 8, 8, 8, 2, 0, 248, 32, 32, 32, 32, 32, 32, 248,
  6, 11, 11, 8, 1, 0, 48, 16, 16, 16, 116, 152, 16, 16, 16, 16,
  124, 6, 11, 11, 8, 1, 0, 48, 16, 16, 112, 144, 124, 16, 16, 16,
  16, 124, 4, 12, 12, 8, 3, 255, 192, 64, 64, 64, 64, 64, 64, 64,
  64, 64, 64, 48, 7, 13, 13, 8, 1, 254, 96, 32, 32, 62, 34, 36,
  40, 44, 34, 34, 250, 18, 12, 7, 8, 8, 8, 1, 0, 146, 146, 146,
  146, 146, 146, 146, 110, 7, 10, 10, 8, 1, 254, 146, 146, 146, 146, 146,
  146, 146, 110, 2, 2, 7, 9, 9, 8, 1, 255, 236, 146, 146, 146, 146,
  146, 146, 130, 12, 7, 9, 9, 8, 1, 255, 44, 50, 34, 34, 34, 34,
  34, 34, 192, 7, 9, 9, 8, 1, 255, 176, 200, 136, 136, 136, 136, 136,
  136, 6, 6, 8, 8, 8, 1, 0, 132, 132, 196, 164, 148, 140, 132, 132,
  6, 8, 8, 8, 1, 0, 120, 132, 132, 252, 132, 132, 132, 120, 7, 8,
  8, 8, 1, 0, 110, 144, 144, 156, 144, 144, 144, 110, 7, 8, 8, 8,
  1, 0, 124, 130, 130, 146, 146, 146, 146, 108, 7, 12, 12, 8, 1, 254,
  16, 16, 124, 146, 146, 146, 146, 146, 146, 124, 16, 16, 6, 8, 8, 8,
  1, 0, 4, 4, 4, 4, 4, 132, 140, 116, 6, 10, 10, 8, 1, 0,
  4, 4, 4, 4, 4, 4, 4, 132, 140, 116, 7, 9, 9, 8, 1, 255,
  8, 8, 8, 8, 8, 136, 152, 104, 6, 6, 10, 10, 8, 1, 254, 184,
  196, 132, 128, 128, 128, 128, 128, 128, 128, 6, 9, 9, 8, 1, 255, 184,
  196, 132, 128, 128, 128, 128, 128, 96, 6, 8, 8, 8, 1, 0, 120, 132,
  132, 128, 128, 128, 128, 128, 6, 8, 8, 8, 1, 0, 120, 132, 132, 4,
  4, 4, 4, 4, 6, 8, 8, 8, 1, 0, 248, 132, 132, 248, 136, 132,
  132, 132, 6, 8, 8, 8, 1, 0, 132, 132, 132, 136, 248, 132, 132, 248,
  6, 10, 10, 8, 1, 254, 120, 132, 128, 96, 24, 4, 132, 248, 128, 96,
  5, 12, 12, 8, 1, 255, 24, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 192, 5, 12, 12, 8, 1, 255, 24, 32, 32, 32, 32, 32, 32, 248,
  32, 32, 32, 192, 5, 9, 9, 8, 1, 255, 192, 32, 32, 32, 32, 32,
  32, 32, 24, 6, 12, 12, 8, 1, 255, 12, 16, 16, 16, 16, 16, 16,
  16, 16, 112, 156, 96, 5, 10, 10, 8, 1, 0, 192, 32, 32, 32, 32,
  32, 32, 248, 32, 32, 6, 11, 11, 8, 1, 255, 32, 32, 32, 248, 32,
  32, 32, 32, 32, 32, 28, 7, 8, 8, 8, 1, 0, 68, 68, 68, 254,
  68, 68, 76, 52, 6, 8, 8, 8, 1, 0, 132, 72, 132, 132, 132, 132,
  72, 48, 6, 8, 8, 8, 1, 0, 152, 132, 132, 132, 132, 136, 144, 96,
  6, 8, 8, 8, 1, 0, 48, 48, 72, 72, 72, 132, 132, 132, 7, 8,
  8, 8, 1, 0, 108, 146, 146, 146, 146, 146, 146, 130, 6, 10, 10, 8,
  1, 254, 120, 128, 128, 176, 200, 132, 132, 132, 132, 132, 7, 8, 8, 8,
  1, 0, 130, 130, 68, 40, 16, 16, 16, 16, 7, 10, 10, 8, 1, 254,
  248, 16, 16, 32, 32, 64, 64, 248, 8, 6, 7, 9, 9, 8, 1, 255,
  252, 4, 8, 16, 32, 76, 146, 252, 32, 6, 10, 10, 8, 1, 254, 124,
  8, 16, 32, 56, 4, 4, 4, 132, 120, 6, 10, 10, 8, 1, 254, 124,
  8, 16, 32, 56, 4, 4, 100, 148, 120, 6, 10, 10, 8, 1, 0, 120,
  132, 132, 4, 8, 16, 16, 16, 16, 16, 6, 10, 10, 8, 1, 0, 120,
  132, 132, 128, 64, 32, 32, 32, 32, 32, 6, 10, 10, 8, 1, 0, 16,
  16, 16, 16, 16, 8, 4, 132, 132, 120, 6, 10, 10, 8, 1, 254, 120,
  132, 128, 128, 128, 128, 128, 128, 132, 120, 6, 8, 8, 8, 1, 0, 120,
  132, 132, 180, 180, 132, 132, 120, 6, 8, 8, 8, 1, 0, 248, 132, 132,
  248, 132, 132, 132, 248, 6, 8, 8, 8, 1, 0, 120, 132, 132, 116, 132,
  132, 132, 120, 7, 8, 8, 8, 1, 0, 118, 136, 128, 128, 152, 136, 136,
  120, 5, 8, 8, 8, 2, 0, 136, 136, 136, 248, 136, 136, 136, 136, 6,
  13, 13, 8, 1, 254, 8, 8, 0, 24, 8, 8, 8, 8, 8, 8, 124,
  144, 96, 6, 11, 11, 8, 1, 254, 132, 68, 36, 20, 12, 20, 36, 68,
  4, 4, 4, 6, 8, 8, 8, 1, 0, 128, 128, 128, 128, 128, 128, 128,
  252, 7, 11, 11, 8, 1, 254, 6, 104, 152, 136, 136, 136, 136, 152, 104,
  8, 8, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4, 8, 16, 16, 124,
  16, 16, 6, 10, 10, 8, 1, 0, 120, 132, 132, 128, 64, 32, 32, 248,
  32, 32, 7, 11, 11, 8, 1, 0, 32, 32, 32, 126, 162, 164, 164, 168,
  168, 176, 126, 7, 13, 13, 8, 1, 254, 32, 32, 32, 126, 162, 164, 168,
  172, 162, 162, 98, 18, 12, 7, 12, 12, 8, 1, 255, 32, 32, 32, 126,
  162, 164, 168, 176, 180, 170, 124, 8, 8, 10, 10, 8, 0, 0, 64, 64,
  70, 248, 72, 68, 66, 65, 65, 62, 7, 13, 13, 8, 1, 254, 6, 72,
  72, 72, 248, 72, 72, 72, 72, 72, 56, 8, 48, 8, 11, 11, 8, 0,
  255, 64, 64, 70, 249, 72, 72, 72, 74, 77, 62, 4, 7, 12, 12, 8,
  1, 254, 96, 144, 128, 220, 162, 162, 162, 162, 162, 162, 4, 24, 7, 11,
  11, 8, 1, 0, 192, 64, 64, 64, 78, 80, 80, 76, 66, 66, 124, 7,
  11, 11, 8, 0, 0, 192, 64, 64, 64, 64, 126, 68, 72, 80, 96, 126,
  7, 11, 11, 8, 1, 0, 130, 146, 146, 146, 108, 0, 130, 146, 146, 146,
  108, 6, 10, 10, 8, 1, 0, 252, 132, 132, 132, 0, 0, 252, 132, 132,
  132, 5, 10, 10, 8, 1, 254, 200, 72, 72, 72, 72, 72, 88, 40, 8,
  8, 7, 10, 10, 8, 1, 254, 200, 72, 72, 72, 72, 72, 88, 40, 8,
  6, 5, 6, 6, 8, 2, 4, 128, 128, 176, 200, 136, 136, 5, 7, 7,
  8, 2, 4, 112, 136, 128, 176, 200, 136, 136, 4, 7, 7, 8, 2, 4,
  16, 0, 16, 16, 16, 144, 96, 5, 5, 5, 8, 2, 5, 176, 200, 128,
  128, 128, 5, 5, 5, 8, 1, 5, 8, 8, 8, 152, 104, 7, 6, 6,
  8, 1, 4, 8, 8, 8, 152, 104, 6, 5, 6, 6, 8, 1, 4, 136,
  144, 240, 136, 136, 240, 5, 4, 4, 8, 1, 6, 136, 168, 168, 80, 5,
  5, 5, 8, 1, 5, 136, 136, 120, 8, 112, 3, 3, 3, 8, 2, 7,
  32, 64, 128, 6, 3, 3, 8, 1, 7, 36, 72, 144, 2, 4, 4, 8,
  3, 6, 64, 128, 128, 192, 2, 4, 4, 8, 3, 6, 192, 64, 64, 128,
  2, 4, 4, 8, 3, 6, 192, 128, 128, 64, 4, 6, 6, 8, 2, 5,
  192, 32, 16, 16, 32, 192, 4, 6, 6, 8, 2, 5, 48, 64, 128, 128,
  64, 48, 6, 7, 7, 8, 1, 4, 120, 132, 4, 4, 56, 32, 32, 6,
  7, 7, 8, 1, 4, 120, 132, 128, 128, 112, 16, 16, 4, 7, 7, 8,
  2, 4, 16, 32, 64, 128, 64, 32, 16, 4, 7, 7, 8, 2, 4, 128,
  64, 32, 16, 32, 64, 128, 7, 4, 4, 8, 1, 6, 16, 40, 68, 130,
  7, 4, 4, 8, 1, 6, 130, 68, 40, 16, 4, 2, 2, 8, 2, 8,
  96, 144, 4, 2, 2, 8, 2, 8, 144, 96, 1, 3, 3, 8, 4, 7,
  128, 128, 128, 4, 1, 1, 8, 2, 9, 240, 4, 2, 2, 8, 2, 8,
  48, 192, 4, 2, 2, 8, 2, 8, 192, 48, 1, 4, 4, 8, 4, 0,
  128, 128, 128, 128, 4, 1, 1, 8, 2, 0, 240, 4, 2, 2, 8, 2,
  255, 192, 48, 4, 2, 2, 8, 2, 255, 48, 192, 3, 6, 6, 8, 2,
  1, 224, 64, 0, 0, 64, 224, 3, 2, 2, 8, 2, 4, 224, 64, 4,
  6, 6, 8, 2, 2, 192, 32, 16, 16, 32, 192, 4, 6, 6, 8, 2,
  2, 48, 64, 128, 128, 64, 48, 5, 5, 5, 8, 1, 2, 32, 32, 32,
  32, 248, 5, 5, 5, 8, 1, 2, 248, 32, 32, 32, 32, 5, 5, 5,
  8, 1, 2, 32, 32, 248, 32, 32, 5, 1, 1, 8, 1, 4, 248, 6,
  3, 3, 8, 1, 9, 132, 132, 120, 2, 2, 2, 8, 3, 10, 192, 192,
  4, 3, 3, 8, 2, 9, 96, 144, 96, 3, 2, 2, 8, 4, 254, 128,
  96, 6, 2, 2, 8, 1, 10, 100, 152, 7, 2, 2, 8, 1, 10, 102,
  136, 7, 4, 4, 8, 0, 3, 32, 96, 162, 28, 6, 5, 5, 8, 1,
  5, 132, 72, 48, 72, 132, 5, 6, 6, 8, 1, 4, 136, 80, 32, 80,
  80, 32, 3, 6, 6, 8, 2, 6, 192, 64, 64, 64, 64, 224, 5, 5,
  5, 8, 1, 5, 120, 128, 112, 8, 240, 5, 5, 5, 8, 1, 5, 136,
  80, 32, 80, 136, 5, 5, 5, 8, 1, 7, 120, 128, 128, 112, 16, 5,
  11, 11, 8, 1, 0, 248, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  5, 11, 11, 8, 1, 0, 8, 8, 248, 8, 8, 8, 8, 8, 8, 8,
  8, 5, 11, 11, 8, 1, 0, 8, 8, 8, 8, 8, 248, 8, 8, 8,
  8, 8, 5, 11, 11, 8, 1, 0, 8, 8, 8, 8, 8, 8, 8, 8,
  248, 8, 8, 5, 11, 11, 8, 1, 0, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 248, 5, 6, 6, 8, 1, 0, 128, 128, 128, 128, 128, 248,
  4, 7, 7, 8, 1, 0, 128, 128, 128, 240, 128, 128, 128, 5, 3, 3,
  8, 1, 0, 136, 80, 32, 6, 3, 3, 8, 1, 9, 252, 0, 252, 6,
  4, 4, 8, 1, 8, 204, 68, 68, 136, 5, 3, 3, 8, 1, 255, 136,
  80, 32, 5, 3, 3, 8, 1, 255, 32, 80, 136, 3, 5, 5, 8, 3,
  255, 32, 64, 128, 64, 32, 3, 5, 5, 8, 3, 255, 128, 64, 32, 64,
  128, 4, 3, 3, 8, 2, 255, 96, 144, 96, 3, 3, 3, 8, 2, 9,
  128, 64, 32, 6, 3, 3, 8, 1, 9, 144, 72, 36, 6, 3, 3, 8,
  1, 9, 36, 72, 144, 6, 2, 2, 8, 1, 254, 100, 152, 2, 7, 7,
  8, 3, 4, 192, 192, 0, 0, 0, 192, 192, 3, 4, 4, 8, 2, 7,
  224, 128, 128, 128, 3, 4, 4, 8, 2, 7, 224, 32, 32, 32, 3, 4,
  4, 8, 2, 0, 128, 128, 128, 224, 3, 4, 4, 8, 2, 0, 32, 32,
  32, 224, 6, 3, 3, 8, 1, 254, 132, 132, 252, 6, 3, 3, 8, 1,
  254, 128, 128, 252, 6, 5, 5, 8, 1, 3, 32, 64, 252, 64, 32
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 3, '1' Height: 9
  Calculated Max Values w=15 h=16 x= 7 y=12 dx=16 dy= 0 ascent=14 len=16
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 3 descent= 0
  X Font      ascent =12 descent= 0
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_67_75[3421] U8G_FONT_SECTION("u8g_font_unifont_67_75") = {
  0, 16, 16, 0, 254, 3, 2, 188, 4, 152, 16, 255, 0, 14, 254, 12,
  0, 7, 5, 5, 8, 1, 2, 32, 64, 254, 64, 32, 5, 14, 14, 8,
  2, 254, 32, 112, 168, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  7, 5, 5, 8, 0, 2, 8, 4, 254, 4, 8, 5, 14, 14, 8, 2,
  0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 168, 112, 32, 8,
  5, 5, 8, 0, 2, 36, 66, 255, 66, 36, 5, 12, 12, 8, 2, 0,
  32, 112, 168, 32, 32, 32, 32, 32, 32, 168, 112, 32, 6, 6, 6, 8,
  1, 3, 240, 192, 160, 144, 8, 4, 6, 6, 6, 8, 1, 3, 60, 12,
  20, 36, 64, 128, 6, 6, 6, 8, 1, 3, 128, 64, 36, 20, 12, 60,
  6, 6, 6, 8, 1, 2, 4, 8, 144, 160, 192, 240, 7, 9, 9, 8,
  1, 0, 8, 8, 40, 72, 254, 72, 40, 8, 8, 7, 9, 9, 8, 0,
  0, 32, 32, 40, 36, 254, 36, 40, 32, 32, 7, 5, 5, 8, 1, 2,
  32, 76, 242, 64, 32, 7, 5, 5, 8, 0, 2, 8, 100, 158, 4, 8,
  8, 5, 5, 8, 0, 3, 36, 72, 255, 72, 36, 5, 14, 14, 8, 2,
  254, 32, 112, 168, 32, 112, 168, 32, 32, 32, 32, 32, 32, 32, 32, 8,
  5, 5, 8, 0, 2, 36, 18, 255, 18, 36, 5, 15, 15, 8, 2, 255,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 168, 112, 32, 168, 112, 32, 7,
  5, 5, 8, 1, 2, 34, 68, 248, 68, 34, 7, 5, 5, 8, 0, 2,
  136, 68, 62, 68, 136, 6, 5, 5, 8, 1, 2, 36, 68, 252, 68, 36,
  5, 12, 12, 8, 2, 0, 32, 112, 168, 32, 32, 32, 32, 32, 32, 32,
  32, 248, 6, 5, 5, 8, 1, 2, 144, 136, 252, 136, 144, 5, 12, 12,
  8, 2, 0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 168, 112, 32, 5,
  12, 12, 8, 2, 0, 32, 112, 168, 32, 32, 32, 32, 32, 168, 112, 32,
  248, 7, 6, 6, 8, 1, 2, 4, 34, 66, 252, 64, 32, 7, 6, 6,
  8, 1, 2, 64, 136, 132, 126, 4, 8, 7, 6, 6, 8, 1, 2, 4,
  42, 74, 252, 72, 40, 7, 6, 6, 8, 1, 2, 64, 168, 164, 126, 36,
  40, 8, 5, 5, 8, 0, 2, 36, 90, 231, 66, 36, 8, 9, 9, 8,
  0, 0, 8, 8, 44, 74, 255, 74, 44, 8, 8, 6, 12, 12, 8, 1,
  0, 128, 128, 128, 144, 176, 208, 144, 16, 16, 84, 56, 16, 5, 9, 9,
  8, 1, 254, 32, 64, 240, 72, 40, 8, 8, 8, 8, 5, 9, 9, 8,
  2, 254, 32, 16, 120, 144, 160, 128, 128, 128, 128, 5, 12, 12, 8, 1,
  2, 8, 8, 8, 8, 8, 8, 8, 40, 72, 240, 64, 32, 5, 12, 12,
  8, 2, 2, 128, 128, 128, 128, 128, 128, 128, 160, 144, 120, 16, 32, 8,
  5, 5, 8, 0, 0, 252, 4, 21, 14, 4, 5, 12, 12, 8, 1, 2,
  8, 8, 8, 8, 8, 8, 8, 40, 72, 248, 64, 32, 8, 5, 5, 8,
  0, 1, 30, 33, 169, 113, 32, 8, 5, 5, 8, 0, 1, 120, 132, 149,
  142, 4, 6, 8, 8, 8, 1, 3, 252, 0, 240, 192, 160, 144, 8, 4,
  6, 11, 11, 8, 1, 0, 160, 192, 252, 192, 160, 0, 20, 12, 252, 12,
  20, 6, 6, 6, 8, 1, 1, 92, 152, 148, 132, 132, 120, 6, 6, 6,
  8, 1, 1, 232, 100, 164, 132, 132, 120, 7, 3, 3, 8, 1, 4, 32,
  64, 254, 7, 3, 3, 8, 1, 2, 254, 64, 32, 3, 14, 14, 8, 4,
  254, 128, 192, 160, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 3,
  14, 14, 8, 2, 254, 32, 96, 160, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 7, 3, 3, 8, 0, 4, 8, 4, 254, 7, 3, 3, 8,
  0, 2, 254, 4, 8, 3, 14, 14, 8, 4, 0, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 160, 192, 128, 3, 14, 14, 8, 2, 0, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 160, 96, 32, 6, 11, 11,
  8, 1, 0, 16, 8, 252, 8, 16, 0, 32, 64, 252, 64, 32, 8, 12,
  12, 8, 0, 0, 36, 116, 172, 36, 36, 36, 36, 36, 36, 53, 46, 36,
  6, 11, 11, 8, 1, 0, 32, 64, 252, 64, 32, 0, 16, 8, 252, 8,
  16, 6, 11, 11, 8, 1, 0, 32, 64, 252, 64, 32, 0, 32, 64, 252,
  64, 32, 8, 12, 12, 8, 0, 0, 36, 126, 165, 36, 36, 36, 36, 36,
  36, 36, 36, 36, 6, 11, 11, 8, 1, 0, 16, 8, 252, 8, 16, 0,
  16, 8, 252, 8, 16, 8, 12, 12, 8, 0, 0, 36, 36, 36, 36, 36,
  36, 36, 36, 36, 165, 126, 36, 6, 7, 7, 8, 1, 1, 32, 64, 252,
  0, 252, 8, 16, 6, 7, 7, 8, 1, 1, 16, 8, 252, 0, 252, 64,
  32, 7, 9, 9, 8, 0, 0, 8, 8, 40, 126, 136, 126, 40, 8, 8,
  8, 9, 9, 8, 0, 0, 8, 8, 44, 126, 137, 126, 44, 8, 8, 7,
  9, 9, 8, 1, 0, 32, 32, 40, 252, 34, 252, 40, 32, 32, 6, 5,
  5, 8, 1, 2, 32, 124, 128, 124, 32, 5, 12, 12, 8, 2, 0, 32,
  80, 216, 80, 80, 80, 80, 80, 80, 80, 80, 80, 6, 5, 5, 8, 1,
  2, 16, 248, 4, 248, 16, 5, 12, 12, 8, 2, 0, 80, 80, 80, 80,
  80, 80, 80, 80, 80, 216, 80, 32, 8, 5, 5, 8, 0, 2, 36, 126,
  129, 126, 36, 5, 12, 12, 8, 2, 0, 32, 80, 216, 80, 80, 80, 80,
  80, 80, 216, 80, 32, 6, 6, 6, 8, 1, 3, 240, 160, 208, 168, 20,
  8, 6, 6, 6, 8, 1, 3, 60, 20, 44, 84, 160, 64, 6, 6, 6,
  8, 1, 3, 8, 20, 168, 208, 160, 240, 6, 6, 6, 8, 1, 3, 64,
  160, 84, 44, 20, 60, 7, 7, 7, 8, 0, 1, 16, 62, 64, 254, 64,
  62, 16, 7, 7, 7, 8, 1, 1, 16, 248, 4, 254, 4, 248, 16, 8,
  5, 5, 8, 0, 2, 32, 66, 245, 72, 32, 8, 5, 5, 8, 0, 2,
  4, 66, 175, 18, 4, 5, 14, 14, 8, 2, 254, 32, 112, 168, 32, 32,
  32, 248, 32, 248, 32, 32, 32, 32, 32, 5, 14, 14, 8, 2, 0, 32,
  32, 32, 32, 32, 248, 32, 248, 32, 32, 32, 168, 112, 32, 7, 5, 5,
  8, 1, 2, 32, 64, 238, 64, 32, 5, 14, 14, 8, 2, 254, 32, 112,
  168, 32, 32, 0, 32, 32, 32, 32, 0, 32, 32, 32, 8, 5, 5, 8,
  0, 2, 4, 2, 239, 2, 4, 5, 14, 14, 8, 2, 0, 32, 32, 32,
  0, 32, 32, 32, 32, 0, 32, 32, 168, 112, 32, 7, 5, 5, 8, 1,
  2, 160, 192, 254, 192, 160, 7, 5, 5, 8, 0, 2, 10, 6, 254, 6,
  10, 8, 7, 7, 8, 0, 1, 16, 48, 95, 129, 95, 48, 16, 7, 12,
  12, 8, 1, 0, 16, 40, 68, 238, 40, 40, 40, 40, 40, 40, 40, 56,
  8, 7, 7, 8, 0, 2, 8, 12, 250, 129, 250, 12, 8, 7, 12, 12,
  8, 1, 0, 56, 40, 40, 40, 40, 40, 40, 40, 238, 68, 40, 16, 7,
  12, 12, 8, 1, 0, 16, 40, 68, 238, 40, 40, 40, 56, 0, 56, 40,
  56, 7, 12, 12, 8, 1, 0, 16, 40, 68, 198, 68, 68, 68, 68, 68,
  198, 130, 254, 7, 12, 12, 8, 1, 0, 16, 40, 124, 198, 68, 68, 68,
  68, 68, 198, 130, 254, 7, 12, 12, 8, 1, 0, 16, 56, 84, 214, 84,
  84, 84, 84, 84, 214, 146, 254, 7, 13, 13, 8, 1, 0, 16, 40, 84,
  238, 68, 198, 68, 68, 68, 68, 68, 68, 124, 7, 13, 13, 8, 1, 0,
  16, 40, 84, 238, 68, 198, 68, 68, 68, 68, 198, 130, 254, 7, 7, 7,
  8, 1, 1, 16, 216, 244, 130, 244, 216, 16, 7, 9, 9, 8, 1, 0,
  254, 128, 184, 176, 168, 132, 130, 128, 128, 7, 9, 9, 8, 1, 0, 2,
  2, 130, 66, 42, 26, 58, 2, 254, 5, 12, 12, 8, 2, 0, 32, 80,
  216, 80, 80, 80, 80, 80, 80, 216, 80, 32, 13, 5, 10, 16, 1, 2,
  14, 32, 17, 16, 255, 248, 17, 16, 14, 32, 8, 12, 12, 8, 0, 0,
  36, 46, 53, 36, 36, 36, 36, 36, 36, 172, 116, 36, 8, 15, 15, 8,
  0, 254, 4, 2, 255, 2, 4, 4, 2, 255, 2, 4, 4, 2, 255, 2,
  4, 8, 5, 5, 8, 0, 2, 36, 68, 255, 68, 36, 8, 5, 5, 8,
  0, 2, 36, 34, 255, 34, 36, 11, 5, 10, 16, 2, 2, 36, 128, 68,
  64, 255, 224, 68, 64, 36, 128, 15, 5, 10, 16, 1, 2, 34, 128, 66,
  128, 255, 254, 66, 128, 34, 128, 15, 5, 10, 16, 0, 2, 2, 136, 2,
  132, 255, 254, 2, 132, 2, 136, 13, 5, 10, 16, 1, 2, 37, 32, 69,
  16, 255, 248, 69, 16, 37, 32, 8, 5, 5, 8, 0, 2, 32, 96, 191,
  96, 32, 8, 5, 5, 8, 0, 2, 4, 6, 253, 6, 4, 12, 5, 10,
  16, 2, 2, 32, 64, 96, 96, 191, 208, 96, 96, 32, 64, 8, 8, 8,
  8, 0, 6, 255, 255, 255, 255, 255, 255, 255, 255, 8, 2, 2, 8, 0,
  254, 255, 255, 8, 4, 4, 8, 0, 254, 255, 255, 255, 255, 8, 6, 6,
  8, 0, 254, 255, 255, 255, 255, 255, 255, 8, 8, 8, 8, 0, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 8, 10, 10, 8, 0, 254, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 8, 12, 12, 8, 0, 254, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 8, 14, 14, 8, 0, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 8, 16, 16,
  8, 0, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 7, 16, 16, 8, 0, 254, 254, 254, 254, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 254, 254, 254, 254, 6, 16, 16, 8, 0, 254, 252,
  252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 5,
  16, 16, 8, 0, 254, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 4, 16, 16, 8, 0, 254, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 3, 16, 16, 8, 0,
  254, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 2, 16, 16, 8, 0, 254, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 1, 16, 16, 8, 0, 254, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 4, 16, 16,
  8, 4, 254, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 7, 16, 16, 8, 0, 254, 136, 34, 136, 34, 136, 34, 136,
  34, 136, 34, 136, 34, 136, 34, 136, 34, 8, 16, 16, 8, 0, 254, 170,
  85, 170, 85, 170, 85, 170, 85, 170, 85, 170, 85, 170, 85, 170, 85, 8,
  16, 16, 8, 0, 254, 238, 187, 238, 187, 238, 187, 238, 187, 238, 187, 238,
  187, 238, 187, 238, 187, 8, 2, 2, 8, 0, 12, 255, 255, 1, 16, 16,
  8, 7, 254, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 4, 8, 8, 8, 0, 254, 240, 240, 240, 240, 240, 240, 240,
  240, 4, 8, 8, 8, 4, 254, 240, 240, 240, 240, 240, 240, 240, 240, 4,
  8, 8, 8, 0, 6, 240, 240, 240, 240, 240, 240, 240, 240, 8, 16, 16,
  8, 0, 254, 240, 240, 240, 240, 240, 240, 240, 240, 255, 255, 255, 255, 255,
  255, 255, 255, 8, 16, 16, 8, 0, 254, 240, 240, 240, 240, 240, 240, 240,
  240, 15, 15, 15, 15, 15, 15, 15, 15, 8, 16, 16, 8, 0, 254, 255,
  255, 255, 255, 255, 255, 255, 255, 240, 240, 240, 240, 240, 240, 240, 240, 8,
  16, 16, 8, 0, 254, 255, 255, 255, 255, 255, 255, 255, 255, 15, 15, 15,
  15, 15, 15, 15, 15, 4, 8, 8, 8, 4, 6, 240, 240, 240, 240, 240,
  240, 240, 240, 8, 16, 16, 8, 0, 254, 15, 15, 15, 15, 15, 15, 15,
  15, 240, 240, 240, 240, 240, 240, 240, 240, 8, 16, 16, 8, 0, 254, 15,
  15, 15, 15, 15, 15, 15, 15, 255, 255, 255, 255, 255, 255, 255, 255, 7,
  7, 7, 8, 1, 1, 254, 254, 254, 254, 254, 254, 254, 7, 7, 7, 8,
  1, 1, 254, 130, 130, 130, 130, 130, 254, 7, 7, 7, 8, 1, 1, 124,
  130, 130, 130, 130, 130, 124, 7, 7, 7, 8, 1, 1, 254, 130, 186, 186,
  186, 130, 254, 7, 7, 7, 8, 1, 1, 254, 130, 254, 130, 254, 130, 254,
  7, 7, 7, 8, 1, 1, 254, 170, 170, 170, 170, 170, 254, 7, 7, 7,
  8, 1, 1, 254, 170, 254, 170, 254, 170, 254, 7, 7, 7, 8, 1, 1,
  254, 166, 146, 202, 166, 146, 254, 7, 7, 7, 8, 1, 1, 254, 202, 146,
  166, 202, 146, 254, 7, 7, 7, 8, 1, 1, 254, 170, 214, 170, 214, 170,
  254, 4, 4, 4, 8, 2, 4, 240, 240, 240, 240, 4, 4, 4, 8, 2,
  4, 240, 144, 144, 240, 7, 4, 4, 8, 1, 4, 254, 254, 254, 254, 7,
  4, 4, 8, 1, 4, 254, 130, 130, 254, 4, 7, 7, 8, 2, 2, 240,
  240, 240, 240, 240, 240, 240, 4, 7, 7, 8, 2, 2, 240, 144, 144, 144,
  144, 144, 240, 8, 3, 3, 8, 0, 4, 63, 126, 252, 8, 3, 3, 8,
  0, 4, 63, 66, 252, 6, 6, 6, 8, 1, 3, 48, 48, 120, 120, 252,
  252, 6, 6, 6, 8, 1, 3, 48, 48, 72, 72, 132, 252, 6, 3, 3,
  8, 1, 3, 48, 120, 252, 6, 3, 3, 8, 1, 3, 48, 72, 252, 6,
  6, 6, 8, 1, 3, 192, 240, 252, 252, 240, 192, 6, 6, 6, 8, 1,
  3, 192, 176, 140, 140, 176, 192, 4, 4, 4, 8, 2, 4, 192, 240, 240,
  192, 4, 4, 4, 8, 2, 4, 192, 176, 176, 192, 6, 5, 5, 8, 1,
  3, 192, 240, 252, 240, 192, 6, 5, 5, 8, 1, 3, 192, 176, 140, 176,
  192, 6, 6, 6, 8, 1, 3, 252, 252, 120, 120, 48, 48, 6, 6, 6,
  8, 1, 3, 252, 132, 72, 72, 48, 48, 6, 3, 3, 8, 1, 3, 252,
  120, 48, 6, 3, 3, 8, 1, 3, 252, 72, 48, 6, 6, 6, 8, 1,
  3, 12, 60, 252, 252, 60, 12, 6, 6, 6, 8, 1, 3, 12, 52, 196,
  196, 52, 12, 4, 4, 4, 8, 2, 4, 48, 240, 240, 48, 4, 4, 4,
  8, 2, 4, 48, 208, 208, 48, 6, 5, 5, 8, 1, 3, 12, 60, 252,
  60, 12, 6, 5, 5, 8, 1, 3, 12, 52, 196, 52, 12, 7, 7, 7,
  8, 1, 2, 16, 56, 124, 254, 124, 56, 16, 7, 7, 7, 8, 1, 2,
  16, 40, 68, 130, 68, 40, 16, 7, 7, 7, 8, 1, 2, 16, 40, 84,
  186, 84, 40, 16, 7, 7, 7, 8, 1, 2, 56, 68, 178, 186, 154, 68,
  56, 6, 10, 10, 8, 1, 1, 48, 48, 72, 72, 132, 132, 72, 72, 48,
  48, 7, 7, 7, 8, 1, 2, 56, 68, 130, 130, 130, 68, 56, 7, 7,
  7, 8, 1, 2, 40, 0, 130, 0, 130, 0, 40, 7, 7, 7, 8, 1,
  2, 56, 108, 170, 170, 170, 108, 56, 7, 7, 7, 8, 1, 2, 56, 68,
  146, 170, 146, 68, 56, 7, 7, 7, 8, 1, 2, 56, 124, 254, 254, 254,
  124, 56, 7, 7, 7, 8, 1, 2, 56, 100, 226, 226, 226, 100, 56, 7,
  7, 7, 8, 1, 2, 56, 76, 142, 142, 142, 76, 56, 7, 7, 7, 8,
  1, 2, 56, 68, 130, 130, 254, 124, 56, 7, 7, 7, 8, 1, 2, 56,
  124, 254, 130, 130, 68, 56, 7, 7, 7, 8, 1, 2, 56, 92, 158, 158,
  130, 68, 56, 7, 7, 7, 8, 1, 2, 56, 76, 142, 142, 254, 124, 56,
  4, 7, 7, 8, 1, 2, 48, 112, 240, 240, 240, 112, 48, 4, 7, 7,
  8, 4, 2, 192, 224, 240, 240, 240, 224, 192, 8, 16, 16, 8, 0, 254,
  255, 255, 255, 255, 255, 255, 231, 195, 195, 231, 255, 255, 255, 255, 255, 255,
  8, 16, 16, 8, 0, 254, 255, 255, 255, 255, 255, 231, 219, 189, 189, 219,
  231, 255, 255, 255, 255, 255, 8, 8, 8, 8, 0, 6, 255, 255, 255, 255,
  255, 231, 219, 189, 8, 8, 8, 8, 0, 254, 189, 219, 231, 255, 255, 255,
  255, 255, 4, 4, 4, 8, 1, 5, 48, 64, 128, 128, 4, 4, 4, 8,
  4, 5, 192, 32, 16, 16, 4, 4, 4, 8, 4, 2, 16, 16, 32, 192,
  4, 4, 4, 8, 1, 2, 128, 128, 64, 48, 7, 4, 4, 8, 1, 5,
  56, 68, 130, 130, 7, 4, 4, 8, 1, 2, 130, 130, 68, 56, 6, 6,
  6, 8, 1, 255, 4, 12, 28, 60, 124, 252, 6, 6, 6, 8, 1, 255,
  128, 192, 224, 240, 248, 252, 6, 6, 6, 8, 1, 6, 252, 248, 240, 224,
  192, 128, 6, 6, 6, 8, 1, 6, 252, 124, 60, 28, 12, 4, 5, 5,
  5, 8, 1, 2, 112, 136, 136, 136, 112, 6, 6, 6, 8, 1, 3, 252,
  228, 228, 228, 228, 252, 6, 6, 6, 8, 1, 3, 252, 156, 156, 156, 156,
  252, 6, 6, 6, 8, 1, 3, 252, 244, 228, 196, 132, 252, 6, 6, 6,
  8, 1, 3, 252, 132, 140, 156, 188, 252, 7, 6, 6, 8, 1, 3, 254,
  146, 146, 146, 146, 254, 7, 7, 7, 8, 1, 2, 16, 40, 40, 68, 84,
  130, 254, 6, 6, 6, 8, 1, 2, 48, 48, 104, 104, 228, 252, 6, 7,
  7, 8, 1, 2, 48, 48, 88, 88, 156, 156, 252, 8, 8, 8, 8, 0,
  2, 60, 66, 129, 129, 129, 129, 66, 60, 6, 6, 6, 8, 1, 0, 252,
  164, 228, 132, 132, 252, 6, 6, 6, 8, 1, 0, 252, 132, 132, 228, 164,
  252, 6, 6, 6, 8, 1, 0, 252, 132, 132, 156, 148, 252, 6, 6, 6,
  8, 1, 0, 252, 148, 156, 132, 132, 252, 8, 8, 8, 8, 0, 0, 60,
  82, 145, 241, 129, 129, 66, 60, 8, 8, 8, 8, 0, 0, 60, 66, 129,
  129, 241, 145, 82, 60, 8, 8, 8, 8, 0, 0, 60, 66, 129, 129, 143,
  137, 74, 60, 8, 8, 8, 8, 0, 0, 60, 74, 137, 143, 129, 129, 66,
  60, 6, 6, 6, 8, 1, 6, 252, 136, 144, 160, 192, 128, 6, 6, 6,
  8, 1, 6, 252, 68, 36, 20, 12, 4, 6, 6, 6, 8, 1, 255, 128,
  192, 160, 144, 136, 252, 6, 6, 6, 8, 1, 255, 252, 132, 132, 132, 132,
  252, 6, 6, 6, 8, 1, 255, 252, 252, 252, 252, 252, 252, 4, 4, 4,
  8, 2, 0, 240, 144, 144, 240, 4, 4, 4, 8, 2, 0, 240, 240, 240,
  240, 6, 6, 6, 8, 1, 255, 4, 12, 20, 36, 68, 252
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 10, '1' Height: 14
  Calculated Max Values w=16 h=16 x= 5 y= 5 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-1
  X Font      ascent =14 descent=-1
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_72_73[7568] U8G_FONT_SECTION("u8g_font_unifont_72_73") = {
  0, 16, 16, 0, 254, 10, 5, 238, 9, 116, 0, 255, 255, 14, 254, 14,
  255, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 74, 81, 234, 80, 90, 81, 201, 158, 0, 1, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 14, 5, 10, 16, 1, 4, 115, 36, 132,
  164, 100, 188, 20, 164, 227, 36, 13, 5, 10, 16, 1, 4, 119, 72, 130,
  72, 98, 48, 18, 72, 226, 72, 13, 5, 10, 16, 1, 4, 247, 72, 130,
  72, 242, 48, 130, 72, 242, 72, 14, 5, 10, 16, 1, 4, 243, 124, 132,
  144, 244, 144, 132, 144, 243, 16, 14, 5, 10, 16, 1, 4, 244, 152, 132,
  164, 246, 164, 133, 172, 244, 156, 13, 5, 10, 16, 1, 4, 99, 72, 148,
  80, 244, 96, 148, 80, 147, 72, 14, 5, 10, 16, 1, 4, 231, 160, 148,
  32, 231, 160, 148, 32, 231, 188, 10, 5, 10, 16, 3, 4, 241, 192, 138,
  0, 241, 128, 136, 64, 243, 128, 11, 5, 10, 16, 2, 4, 139, 224, 136,
  128, 248, 128, 136, 128, 136, 128, 11, 5, 10, 16, 2, 4, 131, 224, 130,
  0, 131, 224, 130, 0, 250, 0, 11, 5, 10, 16, 2, 4, 139, 224, 136,
  128, 136, 128, 80, 128, 32, 128, 11, 5, 10, 16, 2, 4, 251, 224, 130,
  0, 251, 224, 130, 0, 130, 0, 11, 5, 10, 16, 2, 4, 123, 192, 130,
  32, 131, 192, 130, 64, 122, 32, 11, 5, 10, 16, 2, 4, 121, 192, 130,
  32, 114, 32, 10, 32, 241, 192, 11, 5, 10, 16, 2, 4, 123, 224, 128,
  128, 112, 128, 8, 128, 243, 224, 12, 5, 10, 16, 2, 4, 228, 112, 148,
  64, 148, 112, 148, 64, 231, 112, 13, 5, 10, 16, 1, 4, 227, 16, 148,
  48, 148, 16, 148, 16, 227, 56, 13, 5, 10, 16, 1, 4, 227, 48, 148,
  8, 148, 16, 148, 32, 227, 56, 13, 5, 10, 16, 1, 4, 227, 48, 148,
  8, 148, 48, 148, 8, 227, 48, 13, 5, 10, 16, 1, 4, 227, 8, 148,
  24, 148, 40, 148, 56, 227, 8, 14, 5, 10, 16, 1, 4, 147, 36, 212,
  168, 212, 176, 183, 168, 148, 164, 14, 5, 10, 16, 1, 4, 104, 164, 133,
  52, 98, 44, 18, 36, 226, 36, 13, 5, 10, 16, 1, 4, 247, 112, 130,
  72, 242, 112, 130, 72, 242, 112, 13, 5, 10, 16, 1, 4, 102, 72, 137,
  104, 143, 88, 137, 72, 105, 72, 11, 5, 10, 16, 2, 4, 250, 32, 131,
  96, 250, 160, 130, 32, 250, 32, 14, 5, 10, 16, 1, 4, 116, 184, 132,
  164, 100, 184, 20, 164, 227, 56, 14, 5, 10, 16, 1, 4, 243, 156, 132,
  32, 243, 32, 128, 160, 247, 28, 9, 5, 10, 16, 3, 4, 243, 128, 132,
  0, 243, 0, 128, 128, 135, 0, 9, 5, 10, 16, 3, 4, 115, 128, 132,
  0, 179, 0, 144, 128, 119, 0, 9, 5, 10, 16, 3, 4, 227, 128, 148,
  0, 227, 0, 160, 128, 151, 0, 9, 5, 10, 16, 3, 4, 147, 128, 148,
  0, 147, 0, 144, 128, 103, 0, 9, 5, 10, 16, 1, 4, 119, 0, 132,
  128, 103, 0, 20, 0, 228, 0, 14, 5, 10, 16, 1, 4, 231, 160, 148,
  32, 151, 160, 148, 32, 231, 188, 6, 10, 10, 8, 1, 0, 40, 48, 32,
  96, 184, 36, 36, 36, 36, 56, 6, 2, 2, 8, 1, 0, 132, 252, 6,
  9, 9, 8, 1, 1, 144, 208, 176, 144, 0, 32, 32, 32, 60, 7, 7,
  7, 8, 1, 2, 2, 20, 42, 84, 168, 80, 128, 6, 11, 11, 8, 1,
  0, 120, 132, 132, 128, 64, 32, 16, 16, 0, 16, 16, 14, 14, 28, 16,
  1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252,
  255, 252, 195, 12, 251, 236, 195, 220, 223, 188, 195, 188, 255, 252, 14, 14,
  28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236,
  255, 252, 255, 252, 195, 156, 251, 108, 195, 156, 223, 108, 195, 156, 255, 252,
  14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236,
  195, 236, 255, 252, 255, 252, 195, 156, 251, 108, 195, 140, 223, 236, 195, 156,
  255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12,
  223, 236, 195, 236, 255, 252, 255, 252, 195, 12, 251, 108, 195, 12, 223, 108,
  195, 108, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108,
  195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 195, 28, 251, 108, 195, 28,
  223, 108, 195, 28, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108,
  251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 195, 140, 251, 124,
  195, 124, 223, 124, 195, 140, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252,
  195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 195, 28,
  251, 108, 195, 108, 223, 108, 195, 28, 255, 252, 14, 14, 28, 16, 1, 255,
  255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252,
  195, 12, 251, 124, 195, 28, 223, 124, 195, 12, 255, 252, 14, 14, 28, 16,
  1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252,
  255, 252, 195, 12, 251, 124, 195, 28, 223, 124, 195, 124, 255, 252, 14, 14,
  28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236,
  255, 252, 255, 252, 199, 156, 251, 108, 227, 108, 251, 108, 199, 156, 255, 252,
  14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236,
  195, 236, 255, 252, 255, 252, 199, 220, 251, 156, 227, 220, 251, 220, 199, 140,
  255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12,
  223, 236, 195, 236, 255, 252, 255, 252, 199, 12, 251, 236, 227, 12, 251, 124,
  199, 12, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108,
  195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 199, 28, 251, 236, 227, 140,
  251, 236, 199, 28, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108,
  251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 199, 108, 251, 108,
  227, 12, 251, 236, 199, 236, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252,
  195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 199, 12,
  251, 124, 227, 12, 251, 236, 199, 12, 255, 252, 14, 14, 28, 16, 1, 255,
  255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252,
  199, 156, 251, 124, 227, 28, 251, 108, 199, 156, 255, 252, 14, 14, 28, 16,
  1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252,
  255, 252, 199, 12, 251, 236, 227, 220, 251, 188, 199, 188, 255, 252, 14, 14,
  28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236,
  255, 252, 255, 252, 199, 156, 251, 108, 227, 156, 251, 108, 199, 156, 255, 252,
  14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236,
  195, 236, 255, 252, 255, 252, 199, 156, 251, 108, 227, 140, 251, 236, 199, 156,
  255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12,
  223, 236, 195, 236, 255, 252, 255, 252, 199, 12, 251, 108, 227, 12, 251, 108,
  199, 108, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108,
  195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 199, 28, 251, 108, 227, 28,
  251, 108, 199, 28, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108,
  251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 199, 140, 251, 124,
  227, 124, 251, 124, 199, 140, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252,
  195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 199, 28,
  251, 108, 227, 108, 251, 108, 199, 28, 255, 252, 14, 14, 28, 16, 1, 255,
  255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252,
  199, 12, 251, 124, 227, 28, 251, 124, 199, 12, 255, 252, 14, 14, 28, 16,
  1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252,
  255, 252, 199, 12, 251, 124, 227, 28, 251, 124, 199, 124, 255, 252, 5, 10,
  10, 8, 2, 0, 56, 40, 40, 40, 32, 32, 160, 160, 160, 224, 5, 10,
  10, 8, 2, 0, 8, 8, 8, 8, 8, 248, 136, 136, 136, 136, 5, 10,
  10, 8, 2, 0, 136, 136, 136, 136, 136, 248, 32, 32, 32, 32, 5, 10,
  10, 8, 2, 0, 32, 32, 32, 32, 32, 248, 136, 136, 136, 136, 5, 10,
  10, 8, 2, 0, 248, 168, 168, 168, 32, 32, 168, 168, 168, 248, 5, 5,
  5, 8, 2, 5, 136, 216, 168, 216, 136, 6, 8, 8, 8, 1, 1, 28,
  220, 220, 192, 192, 220, 220, 28, 8, 10, 10, 8, 0, 0, 3, 3, 3,
  27, 24, 24, 216, 192, 192, 192, 7, 10, 10, 8, 1, 0, 14, 174, 174,
  160, 160, 160, 160, 160, 160, 160, 7, 9, 9, 8, 1, 0, 218, 218, 218,
  218, 218, 218, 218, 218, 218, 8, 10, 10, 8, 0, 0, 160, 160, 80, 40,
  40, 20, 20, 10, 5, 5, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108,
  251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 219, 28, 219, 108,
  195, 28, 251, 108, 251, 28, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252,
  195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 219, 140,
  219, 124, 195, 124, 251, 124, 251, 140, 255, 252, 14, 14, 28, 16, 1, 255,
  255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252,
  219, 28, 219, 108, 195, 108, 251, 108, 251, 28, 255, 252, 14, 14, 28, 16,
  1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252,
  255, 252, 219, 12, 219, 124, 195, 28, 251, 124, 251, 12, 255, 252, 14, 14,
  28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236,
  255, 252, 255, 252, 219, 12, 219, 124, 195, 28, 251, 124, 251, 124, 255, 252,
  14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236,
  195, 236, 255, 252, 255, 252, 195, 156, 223, 108, 195, 108, 251, 108, 195, 156,
  255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12,
  223, 236, 195, 236, 255, 252, 255, 252, 195, 220, 223, 156, 195, 220, 251, 220,
  195, 140, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108,
  195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 195, 12, 223, 236, 195, 12,
  251, 124, 195, 12, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108,
  251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 195, 28, 223, 236,
  195, 140, 251, 236, 195, 28, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252,
  195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 195, 108,
  223, 108, 195, 12, 251, 236, 195, 236, 255, 252, 14, 14, 28, 16, 1, 255,
  255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252,
  195, 12, 223, 124, 195, 12, 251, 236, 195, 12, 255, 252, 14, 14, 28, 16,
  1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252,
  255, 252, 195, 156, 223, 124, 195, 28, 251, 108, 195, 156, 255, 252, 14, 14,
  28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236,
  255, 252, 255, 252, 195, 12, 223, 236, 195, 220, 251, 188, 195, 188, 255, 252,
  14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236,
  195, 236, 255, 252, 255, 252, 195, 156, 223, 108, 195, 156, 251, 108, 195, 156,
  255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12,
  223, 236, 195, 236, 255, 252, 255, 252, 195, 156, 223, 108, 195, 140, 251, 236,
  195, 156, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108, 251, 108,
  195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 195, 12, 223, 108, 195, 12,
  251, 108, 195, 108, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252, 195, 108,
  251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 195, 28, 223, 108,
  195, 28, 251, 108, 195, 28, 255, 252, 14, 14, 28, 16, 1, 255, 255, 252,
  195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252, 195, 140,
  223, 124, 195, 124, 251, 124, 195, 140, 255, 252, 14, 14, 28, 16, 1, 255,
  255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252, 255, 252,
  195, 28, 223, 108, 195, 108, 251, 108, 195, 28, 255, 252, 14, 14, 28, 16,
  1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236, 255, 252,
  255, 252, 195, 12, 223, 124, 195, 28, 251, 124, 195, 12, 255, 252, 14, 14,
  28, 16, 1, 255, 255, 252, 195, 108, 251, 108, 195, 12, 223, 236, 195, 236,
  255, 252, 255, 252, 195, 12, 223, 124, 195, 28, 251, 124, 195, 124, 255, 252,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 65, 4, 67, 4,
  133, 2, 129, 2, 129, 2, 129, 2, 129, 2, 65, 4, 71, 196, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  67, 132, 68, 68, 132, 66, 128, 66, 128, 130, 129, 2, 130, 2, 68, 4,
  71, 196, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 67, 132, 68, 68, 132, 66, 128, 66, 129, 130, 128, 66,
  132, 66, 68, 68, 67, 132, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 64, 132, 65, 132, 130, 130, 132, 130,
  136, 130, 143, 194, 128, 130, 64, 132, 64, 132, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 71, 196, 68, 4,
  132, 2, 132, 2, 135, 130, 128, 66, 128, 66, 68, 68, 67, 132, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  65, 132, 66, 4, 132, 2, 132, 2, 135, 130, 132, 66, 132, 66, 68, 68,
  67, 132, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 71, 196, 64, 68, 128, 66, 128, 130, 128, 130, 128, 130,
  129, 2, 65, 4, 65, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 67, 132, 68, 68, 132, 66, 132, 66,
  131, 130, 132, 66, 132, 66, 68, 68, 67, 132, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 67, 132, 68, 68,
  132, 66, 132, 66, 131, 194, 128, 66, 128, 66, 64, 132, 67, 4, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  64, 4, 68, 100, 140, 146, 148, 146, 132, 146, 132, 146, 132, 146, 95, 100,
  64, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 64, 4, 68, 68, 140, 194, 149, 66, 132, 66, 132, 66,
  132, 66, 95, 244, 64, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 68, 100, 140, 146, 148, 18,
  132, 34, 132, 66, 132, 130, 95, 244, 64, 4, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 68, 100,
  140, 146, 148, 18, 132, 34, 132, 18, 132, 146, 95, 100, 64, 4, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  64, 4, 68, 20, 140, 50, 148, 82, 132, 146, 132, 250, 132, 18, 95, 20,
  64, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 64, 4, 68, 244, 140, 130, 148, 130, 132, 226, 132, 18,
  132, 146, 95, 100, 64, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 68, 116, 140, 130, 148, 130,
  132, 226, 132, 146, 132, 146, 95, 100, 64, 4, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 68, 244,
  140, 18, 148, 18, 132, 34, 132, 34, 132, 66, 95, 68, 64, 4, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  64, 4, 68, 100, 140, 146, 148, 146, 132, 98, 132, 146, 132, 146, 95, 100,
  64, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 64, 4, 68, 100, 140, 146, 148, 146, 132, 114, 132, 18,
  132, 18, 95, 100, 64, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 76, 100, 146, 146, 130, 146,
  132, 146, 136, 146, 144, 146, 94, 100, 64, 4, 32, 8, 24, 48, 7, 192,
  14, 12, 24, 16, 1, 0, 32, 16, 65, 8, 67, 8, 133, 4, 129, 4,
  129, 4, 129, 4, 129, 4, 129, 4, 65, 8, 71, 200, 32, 16, 14, 12,
  24, 16, 1, 0, 32, 16, 71, 136, 72, 72, 136, 68, 128, 68, 129, 132,
  130, 4, 132, 4, 136, 4, 72, 8, 79, 200, 32, 16, 14, 12, 24, 16,
  1, 0, 32, 16, 71, 136, 72, 72, 136, 68, 128, 68, 131, 132, 128, 68,
  128, 68, 136, 68, 72, 72, 71, 136, 32, 16, 14, 12, 24, 16, 1, 0,
  32, 16, 64, 136, 65, 136, 130, 132, 132, 132, 136, 132, 136, 132, 143, 196,
  128, 132, 64, 136, 64, 136, 32, 16, 14, 12, 24, 16, 1, 0, 32, 16,
  79, 200, 72, 8, 136, 4, 136, 4, 143, 132, 128, 68, 128, 68, 128, 68,
  72, 72, 71, 136, 32, 16, 14, 12, 24, 16, 1, 0, 32, 16, 67, 136,
  68, 8, 136, 4, 136, 4, 143, 132, 136, 68, 136, 68, 136, 68, 72, 72,
  71, 136, 32, 16, 14, 12, 24, 16, 1, 0, 32, 16, 79, 200, 64, 72,
  128, 68, 128, 132, 128, 132, 128, 132, 129, 4, 129, 4, 65, 8, 65, 8,
  32, 16, 14, 12, 24, 16, 1, 0, 32, 16, 71, 136, 72, 72, 136, 68,
  136, 68, 135, 132, 136, 68, 136, 68, 136, 68, 72, 72, 71, 136, 32, 16,
  14, 12, 24, 16, 1, 0, 32, 16, 71, 136, 72, 72, 136, 68, 136, 68,
  135, 196, 128, 68, 128, 68, 128, 68, 64, 136, 71, 8, 32, 16, 16, 12,
  24, 16, 0, 0, 64, 2, 136, 49, 152, 73, 168, 133, 136, 133, 136, 133,
  136, 133, 136, 133, 136, 133, 136, 73, 190, 49, 64, 2, 16, 12, 24, 16,
  0, 0, 64, 2, 136, 17, 152, 49, 168, 81, 136, 17, 136, 17, 136, 17,
  136, 17, 136, 17, 136, 17, 190, 125, 64, 2, 16, 12, 24, 16, 0, 0,
  64, 2, 136, 121, 152, 133, 168, 133, 136, 5, 136, 25, 136, 33, 136, 65,
  136, 129, 136, 129, 190, 253, 64, 2, 16, 12, 24, 16, 0, 0, 64, 2,
  136, 121, 152, 133, 168, 133, 136, 5, 136, 57, 136, 5, 136, 5, 136, 133,
  136, 133, 190, 121, 64, 2, 16, 12, 24, 16, 0, 0, 64, 2, 136, 9,
  152, 25, 168, 41, 136, 73, 136, 137, 136, 137, 136, 253, 136, 9, 136, 9,
  190, 9, 64, 2, 16, 12, 24, 16, 0, 0, 64, 2, 136, 253, 152, 129,
  168, 129, 136, 129, 136, 249, 136, 5, 136, 5, 136, 5, 136, 133, 190, 121,
  64, 2, 16, 12, 24, 16, 0, 0, 64, 2, 136, 57, 152, 65, 168, 129,
  136, 129, 136, 249, 136, 133, 136, 133, 136, 133, 136, 133, 190, 121, 64, 2,
  16, 12, 24, 16, 0, 0, 64, 2, 137, 249, 152, 9, 168, 9, 136, 17,
  136, 17, 136, 17, 136, 33, 136, 33, 136, 33, 190, 33, 64, 2, 16, 12,
  24, 16, 0, 0, 64, 2, 136, 121, 152, 133, 168, 133, 136, 133, 136, 121,
  136, 133, 136, 133, 136, 133, 136, 133, 190, 121, 64, 2, 16, 12, 24, 16,
  0, 0, 64, 2, 136, 121, 152, 133, 168, 133, 136, 133, 136, 125, 136, 5,
  136, 5, 136, 5, 136, 9, 190, 113, 64, 2, 16, 12, 24, 16, 0, 0,
  64, 2, 156, 49, 162, 73, 162, 133, 130, 133, 132, 133, 136, 133, 144, 133,
  160, 133, 160, 73, 190, 49, 64, 2, 7, 10, 10, 16, 5, 0, 32, 96,
  160, 32, 32, 32, 32, 32, 32, 250, 8, 10, 10, 16, 4, 0, 120, 132,
  132, 4, 24, 32, 64, 128, 128, 253, 8, 10, 10, 16, 4, 0, 120, 132,
  132, 4, 56, 4, 4, 132, 132, 121, 8, 10, 10, 16, 4, 0, 8, 24,
  40, 72, 136, 136, 252, 8, 8, 9, 8, 10, 10, 16, 4, 0, 252, 128,
  128, 128, 248, 4, 4, 4, 132, 121, 8, 10, 10, 16, 4, 0, 56, 64,
  128, 128, 248, 132, 132, 132, 132, 121, 8, 10, 10, 16, 4, 0, 252, 4,
  4, 8, 8, 8, 16, 16, 16, 17, 8, 10, 10, 16, 4, 0, 120, 132,
  132, 132, 120, 132, 132, 132, 132, 121, 8, 10, 10, 16, 4, 0, 120, 132,
  132, 132, 124, 4, 4, 4, 8, 113, 14, 10, 20, 16, 1, 0, 32, 192,
  97, 32, 162, 16, 34, 16, 34, 16, 34, 16, 34, 16, 34, 16, 33, 32,
  248, 196, 14, 10, 20, 16, 1, 0, 32, 64, 96, 192, 161, 64, 32, 64,
  32, 64, 32, 64, 32, 64, 32, 64, 32, 64, 249, 244, 14, 10, 20, 16,
  1, 0, 33, 224, 98, 16, 162, 16, 32, 16, 32, 96, 32, 128, 33, 0,
  34, 0, 34, 0, 251, 244, 14, 10, 20, 16, 1, 0, 33, 224, 98, 16,
  162, 16, 32, 16, 32, 224, 32, 16, 32, 16, 34, 16, 34, 16, 249, 228,
  14, 10, 20, 16, 1, 0, 32, 32, 96, 96, 160, 160, 33, 32, 34, 32,
  34, 32, 35, 240, 32, 32, 32, 32, 248, 36, 14, 10, 20, 16, 1, 0,
  35, 240, 98, 0, 162, 0, 34, 0, 35, 224, 32, 16, 32, 16, 32, 16,
  34, 16, 249, 228, 14, 10, 20, 16, 1, 0, 32, 224, 97, 0, 162, 0,
  34, 0, 35, 224, 34, 16, 34, 16, 34, 16, 34, 16, 249, 228, 14, 10,
  20, 16, 1, 0, 35, 240, 96, 16, 160, 16, 32, 32, 32, 32, 32, 32,
  32, 64, 32, 64, 32, 64, 248, 68, 14, 10, 20, 16, 1, 0, 33, 224,
  98, 16, 162, 16, 34, 16, 33, 224, 34, 16, 34, 16, 34, 16, 34, 16,
  249, 228, 14, 10, 20, 16, 1, 0, 33, 224, 98, 16, 162, 16, 34, 16,
  33, 240, 32, 16, 32, 16, 32, 16, 32, 32, 249, 196, 15, 10, 20, 16,
  1, 0, 120, 96, 132, 144, 133, 8, 5, 8, 25, 8, 33, 8, 65, 8,
  129, 8, 128, 144, 252, 98, 14, 12, 24, 16, 1, 0, 32, 16, 64, 8,
  71, 136, 136, 68, 128, 68, 135, 196, 136, 68, 136, 68, 136, 196, 71, 72,
  64, 8, 32, 16, 14, 12, 24, 16, 1, 0, 40, 16, 72, 8, 72, 8,
  139, 132, 140, 68, 136, 68, 136, 68, 136, 68, 136, 68, 76, 72, 75, 136,
  32, 16, 14, 12, 24, 16, 1, 0, 32, 16, 64, 8, 71, 136, 136, 68,
  136, 4, 136, 4, 136, 4, 136, 4, 136, 68, 71, 136, 64, 8, 32, 16,
  14, 12, 24, 16, 1, 255, 32, 80, 64, 72, 64, 72, 135, 68, 136, 196,
  136, 68, 136, 68, 136, 68, 136, 68, 72, 200, 71, 72, 32, 16, 14, 12,
  24, 16, 1, 0, 32, 16, 64, 8, 71, 136, 136, 68, 136, 68, 143, 196,
  136, 4, 136, 4, 136, 68, 71, 136, 64, 8, 32, 16, 14, 12, 24, 16,
  1, 255, 33, 144, 66, 8, 66, 8, 130, 4, 143, 132, 130, 4, 130, 4,
  130, 4, 130, 4, 66, 8, 66, 8, 32, 16, 14, 12, 24, 16, 1, 0,
  32, 16, 64, 72, 71, 72, 136, 132, 136, 132, 136, 132, 135, 4, 132, 4,
  135, 132, 72, 72, 72, 72, 39, 144, 14, 12, 24, 16, 1, 255, 40, 16,
  72, 8, 72, 8, 139, 132, 140, 68, 136, 68, 136, 68, 136, 68, 136, 68,
  72, 72, 72, 72, 32, 16, 13, 12, 24, 16, 1, 0, 34, 32, 66, 16,
  64, 16, 134, 8, 130, 8, 130, 8, 130, 8, 130, 8, 130, 8, 66, 16,
  79, 144, 32, 32, 13, 13, 26, 16, 1, 255, 32, 160, 64, 144, 64, 16,
  129, 136, 128, 136, 128, 136, 128, 136, 128, 136, 128, 136, 64, 144, 64, 144,
  41, 32, 6, 0, 14, 12, 24, 16, 1, 255, 32, 16, 72, 8, 72, 8,
  136, 132, 137, 4, 138, 4, 140, 4, 138, 4, 137, 4, 72, 136, 72, 72,
  32, 16, 13, 12, 24, 16, 1, 0, 32, 32, 70, 16, 66, 16, 130, 8,
  130, 8, 130, 8, 130, 8, 130, 8, 130, 8, 66, 16, 79, 144, 32, 32,
  15, 12, 24, 16, 1, 0, 32, 8, 64, 4, 78, 196, 137, 34, 137, 34,
  137, 34, 137, 34, 137, 34, 137, 34, 73, 36, 64, 4, 32, 8, 14, 12,
  24, 16, 1, 255, 32, 16, 64, 8, 75, 136, 140, 68, 136, 68, 136, 68,
  136, 68, 136, 68, 136, 68, 72, 72, 64, 8, 32, 16, 14, 12, 24, 16,
  1, 0, 32, 16, 64, 8, 71, 136, 136, 68, 136, 68, 136, 68, 136, 68,
  136, 68, 136, 68, 71, 136, 64, 8, 32, 16, 14, 12, 24, 16, 1, 0,
  32, 16, 64, 8, 75, 136, 140, 68, 136, 68, 136, 68, 136, 68, 136, 68,
  140, 68, 75, 136, 72, 8, 40, 16, 14, 12, 24, 16, 1, 255, 32, 16,
  64, 8, 71, 72, 136, 196, 136, 68, 136, 68, 136, 68, 136, 68, 136, 196,
  71, 72, 64, 72, 32, 80, 14, 12, 24, 16, 1, 0, 32, 16, 64, 8,
  75, 136, 140, 68, 136, 68, 136, 4, 136, 4, 136, 4, 136, 4, 72, 8,
  64, 8, 32, 16, 14, 12, 24, 16, 1, 0, 32, 16, 64, 8, 71, 136,
  136, 68, 136, 4, 134, 4, 129, 132, 128, 68, 136, 68, 71, 136, 64, 8,
  32, 16, 14, 12, 24, 16, 1, 255, 32, 16, 66, 8, 66, 8, 143, 132,
  130, 4, 130, 4, 130, 4, 130, 4, 130, 4, 66, 8, 65, 136, 32, 16,
  14, 12, 24, 16, 1, 0, 32, 16, 64, 8, 72, 72, 136, 68, 136, 68,
  136, 68, 136, 68, 136, 68, 136, 196, 71, 72, 64, 8, 32, 16, 14, 12,
  24, 16, 1, 255, 32, 16, 64, 8, 72, 72, 136, 68, 136, 68, 132, 132,
  132, 132, 132, 132, 131, 4, 67, 8, 64, 8, 32, 16, 15, 12, 24, 16,
  1, 0, 32, 8, 64, 4, 72, 36, 137, 34, 137, 34, 137, 34, 137, 34,
  137, 34, 137, 34, 70, 196, 64, 4, 32, 8, 14, 12, 24, 16, 1, 255,
  32, 16, 64, 8, 72, 72, 136, 68, 132, 132, 131, 4, 131, 4, 132, 132,
  136, 68, 72, 72, 64, 8, 32, 16, 14, 12, 24, 16, 1, 0, 32, 16,
  64, 8, 72, 72, 136, 68, 136, 68, 136, 68, 136, 68, 132, 196, 131, 68,
  64, 72, 64, 72, 39, 144, 14, 12, 24, 16, 1, 0, 32, 16, 64, 8,
  79, 200, 128, 68, 128, 132, 129, 4, 130, 4, 132, 4, 136, 4, 79, 200,
  64, 8, 32, 16, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  65, 4, 66, 132, 130, 130, 132, 66, 132, 66, 135, 194, 132, 66, 68, 68,
  68, 68, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 71, 132, 68, 68, 132, 66, 132, 66, 135, 130, 132, 66,
  132, 66, 68, 68, 71, 132, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 67, 132, 68, 68, 132, 66, 132, 2,
  132, 2, 132, 2, 132, 66, 68, 68, 67, 132, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 71, 4, 68, 132,
  132, 66, 132, 66, 132, 66, 132, 66, 132, 66, 68, 132, 71, 4, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  71, 196, 68, 4, 132, 2, 132, 2, 135, 130, 132, 2, 132, 2, 68, 4,
  71, 196, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 71, 196, 68, 4, 132, 2, 132, 2, 135, 130, 132, 2,
  132, 2, 68, 4, 68, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 67, 132, 68, 68, 132, 66, 132, 2,
  133, 194, 132, 66, 132, 66, 68, 196, 67, 68, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 68, 68, 68, 68,
  132, 66, 132, 66, 135, 194, 132, 66, 132, 66, 68, 68, 68, 68, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  71, 196, 65, 4, 129, 2, 129, 2, 129, 2, 129, 2, 129, 2, 65, 4,
  71, 196, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 67, 228, 64, 132, 128, 130, 128, 130, 128, 130, 128, 130,
  132, 130, 68, 132, 67, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 68, 68, 68, 68, 132, 130, 133, 2,
  134, 2, 133, 2, 132, 130, 68, 68, 68, 68, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 68, 4, 68, 4,
  132, 2, 132, 2, 132, 2, 132, 2, 132, 2, 68, 4, 71, 196, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  68, 68, 68, 68, 134, 194, 134, 194, 133, 66, 133, 66, 132, 66, 68, 68,
  68, 68, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 64, 4, 68, 68, 134, 66, 134, 66, 133, 66, 133, 66,
  132, 194, 68, 196, 68, 68, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 67, 132, 68, 68, 132, 66, 132, 66,
  132, 66, 132, 66, 132, 66, 68, 68, 67, 132, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 71, 132, 68, 68,
  132, 66, 132, 66, 135, 130, 132, 2, 132, 2, 68, 4, 68, 4, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  67, 132, 68, 68, 132, 66, 132, 66, 132, 66, 132, 66, 133, 66, 70, 196,
  67, 132, 32, 104, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 71, 132, 68, 68, 132, 66, 132, 66, 135, 130, 133, 2,
  132, 130, 68, 132, 68, 68, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 67, 132, 68, 68, 132, 66, 132, 2,
  131, 130, 128, 66, 132, 66, 68, 68, 67, 132, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 79, 228, 65, 4,
  129, 2, 129, 2, 129, 2, 129, 2, 129, 2, 65, 4, 65, 4, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  68, 68, 68, 68, 132, 66, 132, 66, 132, 66, 132, 66, 132, 66, 68, 68,
  67, 132, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 72, 36, 72, 36, 132, 66, 132, 66, 132, 66, 130, 130,
  130, 130, 65, 4, 65, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 68, 68, 68, 68, 132, 66, 133, 66,
  133, 66, 134, 194, 134, 194, 68, 68, 68, 68, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 68, 68, 68, 68,
  130, 130, 130, 130, 129, 2, 130, 130, 130, 130, 68, 68, 68, 68, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  72, 36, 72, 36, 132, 66, 132, 66, 130, 130, 129, 2, 129, 2, 65, 4,
  65, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 71, 196, 64, 68, 128, 66, 128, 130, 129, 2, 130, 2,
  132, 2, 68, 4, 71, 196, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 67, 132, 132, 66, 128, 66,
  131, 194, 132, 66, 132, 194, 67, 68, 64, 4, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 36, 8, 68, 4, 68, 4,
  133, 130, 134, 66, 132, 66, 132, 66, 132, 66, 70, 68, 69, 132, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  64, 4, 67, 132, 132, 66, 132, 2, 132, 2, 132, 2, 132, 66, 67, 132,
  64, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 72, 64, 68, 64, 68, 131, 66, 132, 194, 132, 66, 132, 66,
  132, 66, 68, 196, 67, 68, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 67, 132, 132, 66, 132, 66,
  135, 194, 132, 2, 132, 66, 67, 132, 64, 4, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 64, 196, 65, 4,
  129, 2, 129, 2, 135, 194, 129, 2, 129, 2, 65, 4, 65, 4, 33, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  64, 68, 67, 68, 132, 130, 132, 130, 131, 2, 130, 2, 131, 130, 68, 68,
  68, 68, 35, 136, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 36, 8, 68, 4, 68, 4, 133, 130, 134, 66, 132, 66, 132, 66,
  132, 66, 68, 68, 68, 68, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 33, 8, 65, 4, 64, 4, 131, 2, 129, 2,
  129, 2, 129, 2, 129, 2, 65, 4, 71, 196, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 72, 64, 68, 64, 4,
  128, 194, 128, 66, 128, 66, 128, 66, 128, 66, 64, 68, 68, 132, 35, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  68, 4, 68, 4, 132, 130, 133, 2, 134, 2, 134, 2, 133, 2, 68, 132,
  68, 68, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 67, 4, 65, 4, 129, 2, 129, 2, 129, 2, 129, 2,
  129, 2, 65, 4, 71, 196, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 78, 196, 137, 34, 137, 34,
  137, 34, 137, 34, 137, 34, 73, 36, 64, 4, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 69, 132,
  134, 66, 132, 66, 132, 66, 132, 66, 132, 66, 68, 68, 64, 4, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  64, 4, 67, 132, 132, 66, 132, 66, 132, 66, 132, 66, 132, 66, 67, 132,
  64, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 64, 4, 69, 132, 134, 66, 132, 66, 132, 66, 132, 66,
  134, 66, 69, 132, 68, 4, 36, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 67, 68, 132, 194, 132, 66,
  132, 66, 132, 66, 132, 66, 68, 196, 67, 68, 32, 72, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 69, 132,
  134, 66, 132, 66, 132, 2, 132, 2, 132, 2, 68, 4, 64, 4, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  64, 4, 67, 132, 132, 66, 132, 2, 131, 130, 128, 66, 132, 66, 67, 132,
  64, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 65, 4, 65, 4, 135, 194, 129, 2, 129, 2, 129, 2,
  129, 2, 65, 4, 64, 196, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 68, 68, 132, 66, 132, 66,
  132, 66, 132, 66, 132, 194, 67, 68, 64, 4, 32, 8, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 68, 68,
  132, 66, 130, 130, 130, 130, 130, 130, 129, 2, 65, 4, 64, 4, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  64, 4, 72, 36, 137, 34, 137, 34, 137, 34, 137, 34, 137, 34, 70, 196,
  64, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  24, 48, 32, 8, 64, 4, 68, 68, 132, 66, 130, 130, 129, 2, 130, 130,
  132, 66, 68, 68, 64, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 68, 68, 132, 66, 132, 66,
  132, 66, 130, 194, 129, 66, 64, 68, 64, 68, 35, 136, 24, 48, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 64, 4, 71, 196,
  128, 66, 128, 130, 129, 2, 130, 2, 132, 2, 71, 196, 64, 4, 32, 8,
  24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8,
  65, 4, 66, 132, 132, 66, 132, 66, 132, 66, 132, 66, 132, 66, 66, 132,
  65, 4, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  31, 240, 63, 248, 127, 252, 123, 188, 243, 62, 234, 190, 251, 190, 251, 190,
  251, 190, 96, 12, 127, 252, 63, 248, 31, 240, 7, 192, 15, 15, 30, 16,
  0, 255, 7, 192, 31, 240, 63, 248, 127, 252, 123, 156, 243, 110, 235, 238,
  251, 222, 251, 190, 251, 126, 96, 12, 127, 252, 63, 248, 31, 240, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248, 127, 252, 123, 156,
  243, 110, 235, 238, 251, 222, 251, 238, 251, 110, 96, 156, 127, 252, 63, 248,
  31, 240, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248,
  127, 252, 123, 236, 243, 206, 235, 174, 251, 110, 251, 6, 251, 238, 96, 236,
  127, 252, 63, 248, 31, 240, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192,
  31, 240, 63, 248, 127, 252, 123, 12, 243, 126, 235, 126, 251, 30, 251, 238,
  251, 110, 96, 156, 127, 252, 63, 248, 31, 240, 7, 192, 13, 13, 26, 16,
  1, 0, 15, 128, 63, 224, 127, 240, 119, 16, 230, 248, 214, 248, 246, 56,
  246, 216, 246, 216, 65, 48, 127, 240, 63, 224, 15, 128, 13, 13, 26, 16,
  1, 0, 15, 128, 63, 224, 127, 240, 118, 16, 231, 216, 215, 216, 247, 184,
  247, 184, 247, 120, 65, 112, 127, 240, 63, 224, 15, 128, 13, 13, 26, 16,
  1, 0, 15, 128, 63, 224, 127, 240, 119, 48, 230, 216, 214, 216, 247, 56,
  246, 216, 246, 216, 65, 48, 127, 240, 63, 224, 15, 128, 15, 15, 30, 16,
  0, 255, 7, 192, 31, 240, 63, 248, 127, 252, 123, 156, 243, 110, 235, 110,
  251, 142, 251, 238, 251, 238, 96, 156, 127, 252, 63, 248, 31, 240, 7, 192,
  15, 15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248, 127, 252, 115, 156,
  237, 110, 253, 110, 251, 110, 247, 110, 239, 110, 97, 156, 127, 252, 63, 248,
  31, 240, 7, 192, 16, 15, 30, 16, 0, 254, 7, 224, 24, 24, 35, 196,
  76, 50, 80, 10, 144, 137, 161, 133, 160, 133, 160, 133, 145, 201, 80, 10,
  76, 50, 35, 196, 24, 24, 7, 224, 16, 15, 30, 16, 0, 254, 7, 224,
  24, 24, 35, 196, 76, 50, 80, 10, 145, 137, 160, 69, 160, 133, 161, 5,
  145, 201, 80, 10, 76, 50, 35, 196, 24, 24, 7, 224, 16, 15, 30, 16,
  0, 254, 7, 224, 24, 24, 35, 196, 76, 50, 80, 10, 145, 137, 160, 69,
  161, 133, 160, 69, 145, 137, 80, 10, 76, 50, 35, 196, 24, 24, 7, 224,
  16, 15, 30, 16, 0, 254, 7, 224, 24, 24, 35, 196, 76, 50, 80, 10,
  146, 137, 162, 133, 163, 197, 160, 133, 144, 137, 80, 10, 76, 50, 35, 196,
  24, 24, 7, 224, 16, 15, 30, 16, 0, 254, 7, 224, 24, 24, 35, 196,
  76, 50, 80, 10, 145, 201, 161, 5, 161, 133, 160, 69, 145, 137, 80, 10,
  76, 50, 35, 196, 24, 24, 7, 224, 16, 15, 30, 16, 0, 254, 7, 224,
  24, 24, 35, 196, 76, 50, 80, 10, 145, 137, 162, 5, 163, 133, 162, 69,
  145, 137, 80, 10, 76, 50, 35, 196, 24, 24, 7, 224, 16, 15, 30, 16,
  0, 254, 7, 224, 24, 24, 35, 196, 76, 50, 80, 10, 145, 201, 160, 69,
  160, 69, 160, 133, 144, 137, 80, 10, 76, 50, 35, 196, 24, 24, 7, 224,
  16, 15, 30, 16, 0, 254, 7, 224, 24, 24, 35, 196, 76, 50, 80, 10,
  145, 137, 162, 69, 161, 133, 162, 69, 145, 137, 80, 10, 76, 50, 35, 196,
  24, 24, 7, 224, 16, 15, 30, 16, 0, 254, 7, 224, 24, 24, 35, 196,
  76, 50, 80, 10, 145, 137, 162, 69, 161, 197, 160, 69, 145, 137, 80, 10,
  76, 50, 35, 196, 24, 24, 7, 224, 16, 15, 30, 16, 0, 254, 7, 224,
  24, 24, 35, 196, 76, 50, 80, 10, 146, 105, 166, 149, 162, 149, 162, 149,
  151, 105, 80, 10, 76, 50, 35, 196, 24, 24, 7, 224, 15, 15, 30, 16,
  0, 255, 7, 192, 31, 240, 63, 248, 126, 252, 125, 124, 251, 190, 251, 190,
  251, 190, 251, 190, 251, 190, 125, 124, 126, 252, 63, 248, 31, 240, 7, 192
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 6, '1' Height: 3
  Calculated Max Values w= 8 h=10 x= 2 y= 4 dx= 8 dy= 0 ascent=11 len=10
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y= 0 dx= 0 dy= 0
  Pure Font   ascent = 6 descent= 0
  X Font      ascent = 8 descent= 0
  Max Font    ascent =11 descent= 0
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_75r[580] U8G_FONT_SECTION("u8g_font_unifont_75r") = {
  0, 16, 16, 0, 254, 6, 1, 137, 0, 0, 32, 79, 0, 11, 0, 8,
  0, 7, 7, 7, 8, 1, 1, 254, 254, 254, 254, 254, 254, 254, 7, 7,
  7, 8, 1, 1, 254, 130, 130, 130, 130, 130, 254, 7, 7, 7, 8, 1,
  1, 124, 130, 130, 130, 130, 130, 124, 7, 7, 7, 8, 1, 1, 254, 130,
  186, 186, 186, 130, 254, 7, 7, 7, 8, 1, 1, 254, 130, 254, 130, 254,
  130, 254, 7, 7, 7, 8, 1, 1, 254, 170, 170, 170, 170, 170, 254, 7,
  7, 7, 8, 1, 1, 254, 170, 254, 170, 254, 170, 254, 7, 7, 7, 8,
  1, 1, 254, 166, 146, 202, 166, 146, 254, 7, 7, 7, 8, 1, 1, 254,
  202, 146, 166, 202, 146, 254, 7, 7, 7, 8, 1, 1, 254, 170, 214, 170,
  214, 170, 254, 4, 4, 4, 8, 2, 4, 240, 240, 240, 240, 4, 4, 4,
  8, 2, 4, 240, 144, 144, 240, 7, 4, 4, 8, 1, 4, 254, 254, 254,
  254, 7, 4, 4, 8, 1, 4, 254, 130, 130, 254, 4, 7, 7, 8, 2,
  2, 240, 240, 240, 240, 240, 240, 240, 4, 7, 7, 8, 2, 2, 240, 144,
  144, 144, 144, 144, 240, 8, 3, 3, 8, 0, 4, 63, 126, 252, 8, 3,
  3, 8, 0, 4, 63, 66, 252, 6, 6, 6, 8, 1, 3, 48, 48, 120,
  120, 252, 252, 6, 6, 6, 8, 1, 3, 48, 48, 72, 72, 132, 252, 6,
  3, 3, 8, 1, 3, 48, 120, 252, 6, 3, 3, 8, 1, 3, 48, 72,
  252, 6, 6, 6, 8, 1, 3, 192, 240, 252, 252, 240, 192, 6, 6, 6,
  8, 1, 3, 192, 176, 140, 140, 176, 192, 4, 4, 4, 8, 2, 4, 192,
  240, 240, 192, 4, 4, 4, 8, 2, 4, 192, 176, 176, 192, 6, 5, 5,
  8, 1, 3, 192, 240, 252, 240, 192, 6, 5, 5, 8, 1, 3, 192, 176,
  140, 176, 192, 6, 6, 6, 8, 1, 3, 252, 252, 120, 120, 48, 48, 6,
  6, 6, 8, 1, 3, 252, 132, 72, 72, 48, 48, 6, 3, 3, 8, 1,
  3, 252, 120, 48, 6, 3, 3, 8, 1, 3, 252, 72, 48, 6, 6, 6,
  8, 1, 3, 12, 60, 252, 252, 60, 12, 6, 6, 6, 8, 1, 3, 12,
  52, 196, 196, 52, 12, 4, 4, 4, 8, 2, 4, 48, 240, 240, 48, 4,
  4, 4, 8, 2, 4, 48, 208, 208, 48, 6, 5, 5, 8, 1, 3, 12,
  60, 252, 60, 12, 6, 5, 5, 8, 1, 3, 12, 52, 196, 52, 12, 7,
  7, 7, 8, 1, 2, 16, 56, 124, 254, 124, 56, 16, 7, 7, 7, 8,
  1, 2, 16, 40, 68, 130, 68, 40, 16, 7, 7, 7, 8, 1, 2, 16,
  40, 84, 186, 84, 40, 16, 7, 7, 7, 8, 1, 2, 56, 68, 178, 186,
  154, 68, 56, 6, 10, 10, 8, 1, 1, 48, 48, 72, 72, 132, 132, 72,
  72, 48, 48, 7, 7, 7, 8, 1, 2, 56, 68, 130, 130, 130, 68, 56,
  7, 7, 7, 8, 1, 2, 40, 0, 130, 0, 130, 0, 40, 7, 7, 7,
  8, 1, 2, 56, 108, 170, 170, 170, 108, 56, 7, 7, 7, 8, 1, 2,
  56, 68, 146, 170, 146, 68, 56, 7, 7, 7, 8, 1, 2, 56, 124, 254,
  254, 254, 124, 56
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 10, '1' Height: 8
  Calculated Max Values w=16 h=16 x= 3 y= 6 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent= 0
  X Font      ascent =10 descent= 0
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_76[2540] U8G_FONT_SECTION("u8g_font_unifont_76") = {
  0, 16, 16, 0, 254, 10, 2, 62, 4, 228, 32, 159, 0, 14, 254, 10,
  0, 7, 12, 12, 8, 1, 0, 16, 146, 68, 0, 56, 124, 124, 56, 0,
  68, 146, 16, 8, 4, 4, 8, 0, 6, 32, 118, 255, 126, 7, 8, 8,
  8, 1, 2, 56, 124, 254, 16, 16, 16, 16, 32, 16, 16, 32, 16, 0,
  254, 139, 200, 3, 192, 47, 241, 4, 36, 138, 80, 40, 18, 10, 80, 73,
  148, 4, 33, 71, 224, 8, 16, 16, 136, 120, 30, 16, 136, 8, 16, 7,
  224, 7, 11, 11, 8, 1, 0, 68, 68, 72, 72, 80, 82, 4, 96, 144,
  144, 96, 7, 6, 6, 8, 1, 3, 16, 16, 254, 56, 108, 68, 7, 7,
  7, 8, 1, 3, 16, 16, 238, 68, 84, 108, 68, 5, 9, 9, 8, 2,
  0, 8, 16, 32, 64, 128, 64, 40, 24, 56, 6, 8, 8, 8, 1, 0,
  252, 132, 136, 144, 160, 148, 140, 156, 8, 8, 8, 8, 0, 0, 60, 66,
  129, 153, 153, 129, 66, 60, 8, 6, 6, 8, 0, 2, 24, 36, 36, 102,
  165, 66, 8, 6, 6, 8, 0, 2, 66, 165, 102, 36, 36, 24, 5, 6,
  6, 8, 1, 2, 8, 16, 96, 144, 144, 96, 7, 9, 9, 8, 1, 0,
  12, 18, 18, 12, 16, 96, 144, 144, 96, 7, 6, 6, 8, 1, 1, 124,
  198, 0, 84, 198, 254, 7, 7, 7, 8, 1, 1, 124, 130, 186, 124, 146,
  130, 254, 7, 7, 7, 8, 1, 0, 254, 130, 130, 130, 130, 130, 254, 7,
  8, 8, 8, 1, 0, 8, 254, 138, 138, 202, 178, 130, 254, 7, 7, 7,
  8, 1, 0, 254, 130, 170, 146, 170, 130, 254, 5, 10, 10, 8, 2, 0,
  136, 136, 80, 80, 32, 32, 80, 80, 136, 136, 7, 12, 12, 8, 1, 2,
  10, 160, 8, 130, 56, 124, 254, 16, 16, 16, 16, 32, 12, 13, 26, 16,
  2, 0, 36, 128, 73, 0, 73, 0, 36, 128, 36, 128, 73, 0, 0, 0,
  127, 32, 255, 208, 191, 80, 128, 80, 128, 224, 127, 0, 11, 13, 26, 16,
  2, 0, 4, 0, 10, 0, 17, 0, 32, 128, 64, 64, 128, 32, 128, 32,
  128, 32, 128, 32, 128, 32, 128, 32, 128, 32, 255, 224, 11, 13, 26, 16,
  2, 0, 4, 0, 14, 0, 31, 0, 63, 128, 127, 192, 255, 224, 255, 224,
  255, 224, 255, 224, 255, 224, 255, 224, 255, 224, 255, 224, 13, 13, 26, 16,
  1, 255, 5, 0, 15, 128, 15, 128, 103, 48, 242, 120, 127, 240, 242, 120,
  98, 48, 4, 0, 4, 0, 4, 0, 8, 0, 16, 0, 13, 12, 24, 16,
  1, 0, 0, 8, 3, 144, 71, 208, 143, 208, 159, 208, 255, 176, 127, 184,
  31, 200, 15, 200, 7, 200, 3, 136, 0, 16, 7, 4, 4, 8, 1, 2,
  252, 62, 62, 28, 7, 4, 4, 8, 1, 2, 126, 248, 248, 112, 7, 4,
  4, 8, 1, 2, 252, 34, 50, 28, 4, 7, 7, 8, 2, 2, 16, 16,
  112, 208, 144, 144, 96, 7, 4, 4, 8, 1, 2, 126, 136, 152, 112, 4,
  7, 7, 8, 2, 0, 96, 144, 144, 208, 112, 16, 16, 8, 12, 12, 8,
  0, 0, 231, 165, 126, 129, 165, 165, 129, 90, 90, 66, 189, 231, 4, 10,
  10, 8, 2, 0, 224, 16, 16, 32, 32, 64, 64, 128, 128, 112, 16, 16,
  32, 16, 0, 254, 7, 224, 24, 24, 36, 36, 92, 58, 92, 58, 190, 125,
  190, 125, 190, 125, 129, 129, 129, 129, 131, 193, 67, 194, 71, 226, 35, 196,
  24, 24, 7, 224, 15, 13, 26, 16, 0, 255, 4, 64, 8, 32, 16, 16,
  16, 16, 19, 144, 12, 96, 62, 248, 68, 68, 133, 66, 131, 130, 2, 128,
  4, 64, 24, 48, 13, 15, 30, 16, 1, 254, 6, 0, 2, 0, 255, 248,
  71, 16, 63, 224, 2, 0, 26, 192, 34, 32, 31, 192, 18, 64, 15, 128,
  10, 128, 7, 0, 10, 128, 2, 0, 5, 8, 8, 8, 2, 0, 112, 136,
  80, 32, 248, 32, 32, 32, 5, 9, 9, 8, 2, 0, 32, 112, 32, 248,
  32, 96, 48, 32, 32, 6, 10, 10, 8, 1, 0, 56, 36, 36, 56, 32,
  168, 112, 32, 112, 168, 5, 9, 9, 8, 2, 0, 32, 112, 32, 248, 32,
  32, 32, 32, 32, 7, 7, 7, 8, 1, 0, 56, 16, 146, 254, 146, 16,
  56, 8, 9, 9, 8, 0, 1, 30, 33, 64, 194, 199, 194, 64, 33, 30,
  11, 11, 22, 16, 2, 0, 21, 0, 27, 0, 0, 0, 85, 64, 164, 160,
  164, 160, 164, 160, 149, 32, 78, 64, 31, 0, 4, 0, 11, 12, 24, 16,
  3, 255, 4, 0, 21, 0, 36, 128, 78, 64, 213, 96, 213, 96, 206, 96,
  228, 224, 223, 96, 142, 32, 21, 0, 4, 0, 8, 8, 8, 8, 0, 0,
  12, 2, 57, 121, 13, 62, 99, 193, 7, 8, 8, 8, 1, 0, 124, 146,
  146, 146, 186, 214, 146, 124, 16, 16, 32, 16, 0, 254, 7, 224, 24, 24,
  32, 4, 64, 2, 64, 2, 156, 49, 190, 49, 255, 3, 231, 131, 231, 199,
  255, 255, 127, 254, 127, 254, 63, 252, 31, 248, 7, 224, 13, 10, 20, 16,
  1, 0, 255, 248, 255, 248, 0, 0, 0, 0, 255, 248, 255, 248, 0, 0,
  0, 0, 255, 248, 255, 248, 13, 10, 20, 16, 1, 0, 248, 248, 248, 248,
  0, 0, 0, 0, 255, 248, 255, 248, 0, 0, 0, 0, 255, 248, 255, 248,
  13, 10, 20, 16, 1, 0, 255, 248, 255, 248, 0, 0, 0, 0, 248, 248,
  248, 248, 0, 0, 0, 0, 255, 248, 255, 248, 13, 10, 20, 16, 1, 0,
  248, 248, 248, 248, 0, 0, 0, 0, 248, 248, 248, 248, 0, 0, 0, 0,
  255, 248, 255, 248, 13, 10, 20, 16, 1, 0, 255, 248, 255, 248, 0, 0,
  0, 0, 255, 248, 255, 248, 0, 0, 0, 0, 248, 248, 248, 248, 13, 10,
  20, 16, 1, 0, 248, 248, 248, 248, 0, 0, 0, 0, 255, 248, 255, 248,
  0, 0, 0, 0, 248, 248, 248, 248, 13, 10, 20, 16, 1, 0, 255, 248,
  255, 248, 0, 0, 0, 0, 248, 248, 248, 248, 0, 0, 0, 0, 248, 248,
  248, 248, 13, 10, 20, 16, 1, 0, 248, 248, 248, 248, 0, 0, 0, 0,
  248, 248, 248, 248, 0, 0, 0, 0, 248, 248, 248, 248, 7, 7, 7, 8,
  1, 0, 146, 124, 124, 238, 124, 124, 146, 8, 10, 10, 8, 0, 1, 60,
  66, 129, 165, 129, 153, 165, 129, 66, 60, 8, 9, 9, 8, 0, 1, 60,
  66, 129, 165, 129, 165, 153, 66, 60, 8, 9, 9, 8, 0, 1, 60, 126,
  255, 219, 255, 219, 231, 126, 60, 7, 7, 7, 8, 1, 2, 146, 84, 56,
  238, 56, 84, 146, 6, 10, 10, 8, 2, 0, 224, 48, 24, 20, 20, 20,
  20, 24, 48, 224, 6, 10, 10, 8, 1, 0, 28, 48, 96, 160, 160, 160,
  160, 96, 48, 28, 5, 11, 11, 8, 2, 0, 136, 136, 112, 136, 136, 136,
  112, 32, 248, 32, 32, 5, 9, 9, 8, 2, 0, 112, 136, 136, 136, 112,
  32, 248, 32, 32, 5, 10, 10, 8, 2, 1, 32, 32, 248, 32, 32, 112,
  136, 136, 136, 112, 7, 8, 8, 8, 1, 1, 14, 6, 10, 112, 136, 136,
  136, 112, 6, 10, 10, 8, 1, 0, 4, 4, 4, 116, 140, 12, 20, 252,
  4, 4, 6, 10, 10, 8, 1, 0, 64, 64, 224, 64, 88, 100, 68, 72,
  72, 72, 7, 9, 9, 8, 1, 0, 214, 84, 124, 84, 214, 16, 56, 40,
  56, 8, 11, 11, 8, 0, 255, 8, 89, 203, 73, 73, 73, 62, 8, 62,
  8, 8, 6, 10, 10, 8, 1, 0, 248, 132, 132, 132, 248, 128, 128, 128,
  128, 252, 7, 10, 10, 8, 1, 0, 68, 170, 40, 40, 16, 16, 16, 16,
  16, 16, 7, 7, 7, 8, 1, 0, 130, 68, 56, 68, 68, 68, 56, 7,
  10, 10, 8, 1, 0, 130, 124, 40, 40, 40, 40, 40, 40, 124, 130, 7,
  8, 8, 8, 1, 0, 124, 146, 144, 96, 12, 18, 146, 124, 8, 9, 9,
  8, 0, 0, 28, 34, 34, 18, 116, 148, 148, 101, 2, 7, 10, 10, 8,
  1, 0, 168, 248, 170, 174, 170, 170, 170, 170, 12, 248, 7, 6, 6, 8,
  1, 1, 56, 68, 68, 238, 0, 254, 7, 10, 10, 8, 1, 0, 168, 248,
  168, 168, 168, 168, 168, 168, 170, 6, 7, 7, 7, 8, 1, 0, 30, 6,
  138, 82, 32, 80, 136, 8, 10, 10, 8, 0, 0, 49, 78, 132, 8, 16,
  60, 98, 162, 162, 28, 6, 6, 6, 8, 1, 2, 84, 168, 0, 0, 84,
  168, 6, 9, 9, 8, 1, 0, 132, 132, 72, 72, 252, 72, 72, 132, 132,
  7, 13, 13, 8, 1, 0, 16, 56, 146, 186, 198, 130, 68, 68, 68, 130,
  130, 130, 254, 7, 11, 11, 8, 1, 0, 16, 56, 198, 130, 68, 68, 68,
  130, 130, 130, 254, 7, 9, 9, 8, 1, 0, 170, 254, 130, 130, 68, 68,
  130, 130, 254, 7, 10, 10, 8, 1, 0, 16, 40, 68, 68, 68, 68, 40,
  238, 130, 254, 6, 11, 11, 8, 1, 0, 4, 60, 68, 132, 132, 116, 36,
  68, 132, 132, 252, 6, 8, 8, 8, 1, 0, 48, 72, 72, 48, 72, 72,
  132, 252, 7, 13, 13, 8, 1, 0, 16, 56, 146, 186, 254, 254, 124, 124,
  124, 254, 254, 254, 254, 7, 11, 11, 8, 1, 0, 16, 56, 254, 238, 124,
  124, 124, 254, 254, 254, 254, 7, 8, 8, 8, 1, 0, 170, 254, 254, 124,
  124, 254, 254, 254, 7, 10, 10, 8, 1, 0, 16, 56, 108, 68, 108, 124,
  56, 254, 254, 254, 6, 11, 11, 8, 1, 0, 4, 60, 108, 252, 252, 124,
  60, 124, 252, 252, 252, 6, 8, 8, 8, 1, 0, 48, 120, 120, 48, 120,
  120, 252, 252, 7, 10, 10, 8, 1, 0, 16, 16, 56, 124, 254, 254, 254,
  124, 16, 56, 7, 9, 9, 8, 1, 0, 108, 146, 130, 130, 130, 68, 40,
  16, 16, 5, 10, 10, 8, 2, 0, 32, 32, 80, 80, 136, 136, 80, 80,
  32, 32, 7, 10, 10, 8, 1, 0, 56, 56, 56, 16, 254, 254, 214, 16,
  16, 56, 7, 10, 10, 8, 1, 0, 16, 16, 40, 68, 130, 130, 130, 124,
  16, 56, 7, 9, 9, 8, 1, 0, 108, 254, 254, 254, 254, 124, 56, 16,
  16, 5, 10, 10, 8, 2, 0, 32, 32, 112, 112, 248, 248, 112, 112, 32,
  32, 7, 10, 10, 8, 1, 0, 56, 40, 56, 16, 238, 186, 214, 16, 16,
  56, 8, 11, 11, 8, 0, 0, 8, 81, 146, 146, 146, 73, 73, 73, 82,
  129, 126, 4, 10, 10, 8, 1, 0, 16, 16, 16, 16, 16, 16, 16, 112,
  240, 224, 6, 10, 10, 8, 1, 0, 16, 24, 20, 20, 16, 16, 16, 112,
  240, 224, 8, 11, 11, 8, 0, 0, 28, 23, 17, 17, 17, 17, 113, 241,
  231, 15, 14, 8, 11, 11, 8, 0, 0, 28, 23, 17, 29, 23, 17, 113,
  241, 231, 15, 14, 6, 12, 12, 8, 1, 0, 128, 128, 128, 128, 128, 184,
  204, 140, 136, 144, 160, 192, 6, 11, 11, 8, 1, 0, 128, 128, 156, 252,
  228, 132, 156, 252, 228, 4, 4, 6, 13, 13, 8, 1, 255, 8, 72, 76,
  124, 248, 200, 72, 76, 124, 248, 200, 72, 64, 7, 10, 10, 8, 1, 0,
  40, 16, 16, 146, 124, 146, 16, 16, 16, 40, 7, 10, 10, 8, 1, 0,
  56, 40, 16, 214, 186, 214, 16, 16, 40, 16, 16, 16, 32, 16, 0, 254,
  3, 192, 5, 32, 10, 152, 18, 72, 10, 208, 4, 48, 48, 4, 72, 10,
  140, 17, 80, 9, 160, 5, 174, 38, 82, 88, 82, 134, 30, 92, 0, 32,
  15, 16, 32, 16, 0, 254, 3, 128, 4, 64, 4, 64, 8, 32, 0, 40,
  57, 24, 27, 56, 41, 0, 33, 8, 67, 132, 64, 4, 128, 34, 128, 66,
  126, 252, 0, 64, 0, 32, 15, 16, 32, 16, 0, 254, 3, 128, 4, 64,
  4, 64, 8, 32, 0, 40, 59, 24, 24, 184, 41, 0, 34, 8, 67, 132,
  64, 4, 128, 34, 128, 66, 126, 252, 0, 64, 0, 32, 15, 16, 32, 16,
  0, 254, 3, 128, 4, 64, 4, 64, 8, 32, 0, 40, 57, 24, 24, 184,
  43, 0, 32, 136, 67, 4, 64, 4, 128, 34, 128, 66, 126, 252, 0, 64,
  0, 32, 15, 16, 32, 16, 0, 254, 3, 128, 4, 64, 4, 64, 8, 32,
  0, 40, 58, 152, 26, 184, 43, 128, 32, 136, 64, 132, 64, 4, 128, 34,
  128, 66, 126, 252, 0, 64, 0, 32, 15, 16, 32, 16, 0, 254, 3, 128,
  4, 64, 4, 64, 8, 32, 0, 40, 59, 152, 26, 56, 43, 0, 32, 136,
  67, 4, 64, 4, 128, 34, 128, 66, 126, 252, 0, 64, 0, 32, 15, 16,
  32, 16, 0, 254, 3, 128, 4, 64, 4, 64, 8, 32, 0, 40, 57, 152,
  26, 56, 43, 128, 34, 72, 65, 132, 64, 4, 128, 34, 128, 66, 126, 252,
  0, 64, 0, 32, 15, 16, 32, 16, 0, 254, 3, 128, 4, 64, 4, 64,
  8, 32, 0, 40, 59, 152, 24, 184, 41, 0, 33, 8, 65, 4, 64, 4,
  128, 34, 128, 66, 126, 252, 0, 64, 0, 32, 15, 16, 32, 16, 0, 254,
  3, 128, 4, 64, 4, 64, 8, 32, 0, 40, 56, 24, 24, 56, 40, 0,
  32, 8, 64, 4, 64, 4, 128, 34, 128, 66, 126, 252, 0, 64, 0, 32,
  16, 16, 32, 16, 0, 254, 3, 192, 5, 224, 14, 248, 30, 120, 14, 240,
  4, 48, 48, 4, 120, 14, 252, 31, 112, 15, 224, 7, 238, 38, 94, 120,
  94, 254, 30, 124, 0, 32, 16, 16, 32, 16, 0, 254, 7, 224, 31, 248,
  62, 124, 125, 190, 123, 222, 255, 143, 247, 223, 231, 255, 243, 239, 247, 239,
  239, 247, 111, 182, 113, 14, 63, 188, 31, 248, 7, 224, 16, 16, 32, 16,
  0, 254, 7, 224, 24, 24, 33, 132, 66, 66, 68, 34, 128, 113, 136, 33,
  152, 1, 140, 17, 136, 17, 144, 9, 80, 74, 78, 242, 32, 68, 24, 24,
  7, 224, 13, 12, 24, 16, 0, 255, 7, 0, 24, 192, 32, 32, 64, 16,
  77, 144, 146, 72, 146, 72, 77, 144, 64, 16, 32, 32, 24, 192, 7, 0,
  12, 11, 22, 16, 2, 0, 24, 0, 24, 0, 16, 0, 30, 0, 16, 0,
  95, 128, 128, 128, 128, 64, 129, 64, 66, 48, 60, 0
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 11, '1' Height: 11
  Calculated Max Values w=16 h=16 x= 4 y= 4 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =11 descent= 0
  X Font      ascent =11 descent=-1
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_77[1657] U8G_FONT_SECTION("u8g_font_unifont_77") = {
  0, 16, 16, 0, 254, 11, 3, 133, 6, 29, 32, 99, 0, 14, 254, 11,
  255, 9, 9, 18, 16, 3, 1, 255, 128, 128, 128, 128, 128, 128, 128, 136,
  128, 128, 128, 128, 128, 128, 128, 255, 128, 9, 9, 18, 16, 3, 1, 255,
  128, 128, 128, 128, 128, 160, 128, 128, 128, 130, 128, 128, 128, 128, 128, 255,
  128, 9, 9, 18, 16, 3, 1, 255, 128, 128, 128, 160, 128, 128, 128, 136,
  128, 128, 128, 130, 128, 128, 128, 255, 128, 9, 9, 18, 16, 3, 1, 255,
  128, 128, 128, 162, 128, 128, 128, 128, 128, 128, 128, 162, 128, 128, 128, 255,
  128, 9, 9, 18, 16, 3, 1, 255, 128, 128, 128, 162, 128, 128, 128, 136,
  128, 128, 128, 162, 128, 128, 128, 255, 128, 9, 9, 18, 16, 3, 1, 255,
  128, 128, 128, 162, 128, 128, 128, 162, 128, 128, 128, 162, 128, 128, 128, 255,
  128, 13, 12, 24, 16, 0, 255, 7, 0, 24, 192, 32, 32, 64, 16, 64,
  16, 128, 200, 128, 200, 64, 16, 64, 16, 32, 32, 24, 192, 7, 0, 13,
  12, 24, 16, 0, 255, 7, 0, 24, 192, 32, 32, 64, 16, 64, 16, 152,
  200, 152, 200, 64, 16, 64, 16, 32, 32, 24, 192, 7, 0, 13, 12, 24,
  16, 0, 255, 7, 0, 31, 192, 63, 224, 127, 240, 127, 240, 255, 56, 255,
  56, 127, 240, 127, 240, 63, 224, 15, 128, 7, 0, 13, 12, 24, 16, 0,
  255, 7, 0, 31, 192, 63, 224, 127, 240, 127, 240, 231, 56, 231, 56, 127,
  240, 127, 240, 63, 224, 15, 128, 7, 0, 13, 2, 4, 16, 1, 4, 255,
  248, 255, 248, 13, 2, 4, 16, 1, 4, 248, 248, 248, 248, 13, 6, 12,
  16, 1, 2, 255, 248, 255, 248, 0, 0, 0, 0, 255, 248, 255, 248, 13,
  6, 12, 16, 1, 2, 248, 248, 248, 248, 0, 0, 0, 0, 255, 248, 255,
  248, 13, 6, 12, 16, 1, 2, 255, 248, 255, 248, 0, 0, 0, 0, 248,
  248, 248, 248, 13, 6, 12, 16, 1, 2, 248, 248, 248, 248, 0, 0, 0,
  0, 248, 248, 248, 248, 6, 11, 11, 8, 1, 0, 224, 156, 132, 132, 228,
  156, 128, 128, 128, 128, 128, 6, 11, 11, 8, 1, 0, 224, 252, 252, 252,
  252, 156, 128, 128, 128, 128, 128, 16, 14, 28, 16, 0, 255, 7, 50, 95,
  124, 62, 126, 124, 31, 248, 39, 116, 67, 34, 129, 1, 0, 2, 128, 4,
  64, 8, 32, 16, 16, 32, 8, 64, 4, 14, 12, 24, 16, 1, 0, 3,
  128, 4, 64, 4, 64, 3, 128, 1, 0, 7, 192, 1, 0, 65, 8, 225,
  28, 65, 8, 33, 16, 31, 224, 13, 13, 26, 16, 1, 0, 128, 8, 64,
  16, 32, 32, 16, 64, 8, 128, 5, 0, 2, 0, 5, 0, 8, 128, 80,
  80, 32, 32, 80, 80, 128, 8, 9, 14, 28, 16, 3, 255, 8, 0, 8,
  0, 127, 128, 137, 128, 136, 0, 126, 0, 9, 0, 9, 0, 62, 0, 72,
  0, 60, 0, 10, 0, 28, 0, 8, 0, 15, 11, 22, 16, 0, 0, 1,
  0, 17, 16, 127, 252, 57, 56, 84, 84, 84, 84, 146, 146, 146, 146, 254,
  254, 124, 124, 56, 56, 11, 8, 16, 16, 2, 0, 63, 128, 95, 192, 143,
  192, 135, 128, 128, 0, 15, 128, 18, 64, 34, 32, 11, 13, 26, 16, 2,
  255, 14, 0, 17, 0, 17, 0, 17, 0, 14, 0, 4, 0, 228, 224, 245,
  224, 117, 192, 53, 128, 14, 0, 4, 0, 4, 0, 13, 13, 26, 16, 1,
  255, 2, 0, 66, 16, 47, 160, 16, 64, 32, 32, 32, 32, 226, 56, 32,
  32, 32, 32, 16, 64, 47, 160, 66, 16, 2, 0, 15, 13, 26, 16, 0,
  0, 1, 0, 2, 128, 57, 56, 127, 252, 253, 126, 5, 64, 3, 128, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 16, 16, 32, 16, 0,
  254, 1, 128, 2, 64, 2, 64, 116, 46, 142, 113, 133, 161, 78, 114, 53,
  172, 53, 172, 78, 114, 133, 161, 142, 113, 116, 46, 2, 64, 2, 64, 1,
  128, 15, 16, 32, 16, 0, 254, 1, 0, 2, 128, 4, 64, 52, 88, 76,
  100, 132, 66, 178, 154, 202, 166, 26, 176, 16, 16, 27, 176, 10, 160, 58,
  184, 38, 200, 25, 48, 1, 0, 15, 15, 30, 16, 0, 255, 1, 0, 2,
  128, 4, 64, 4, 64, 8, 0, 107, 252, 136, 2, 136, 34, 96, 36, 24,
  16, 6, 80, 0, 136, 33, 8, 38, 72, 24, 48, 12, 15, 30, 16, 2,
  255, 192, 0, 48, 0, 12, 0, 3, 0, 0, 192, 0, 48, 0, 0, 255,
  240, 0, 0, 0, 48, 0, 192, 3, 0, 12, 0, 48, 0, 192, 0, 12,
  15, 30, 16, 2, 255, 0, 48, 0, 192, 3, 0, 12, 0, 48, 0, 192,
  0, 0, 0, 255, 240, 0, 0, 192, 0, 48, 0, 12, 0, 3, 0, 0,
  192, 0, 48, 13, 14, 28, 16, 1, 255, 2, 0, 5, 0, 5, 0, 8,
  128, 8, 128, 18, 64, 18, 64, 34, 32, 34, 32, 66, 16, 64, 16, 130,
  8, 128, 8, 255, 248, 6, 11, 11, 8, 1, 255, 4, 8, 16, 32, 64,
  252, 8, 16, 32, 64, 128, 11, 9, 18, 16, 2, 0, 59, 128, 68, 64,
  138, 32, 138, 32, 68, 64, 59, 128, 17, 0, 59, 128, 17, 0, 11, 11,
  22, 16, 2, 0, 7, 0, 3, 0, 5, 0, 56, 224, 68, 96, 142, 160,
  149, 0, 104, 128, 48, 128, 17, 0, 14, 0, 10, 14, 28, 16, 3, 255,
  1, 192, 0, 192, 1, 64, 14, 0, 17, 0, 56, 128, 84, 128, 139, 0,
  134, 0, 68, 0, 56, 0, 16, 0, 56, 0, 16, 0, 8, 12, 12, 16,
  4, 254, 7, 3, 5, 56, 68, 130, 130, 68, 56, 16, 56, 16, 11, 10,
  20, 16, 2, 0, 0, 224, 0, 96, 2, 160, 1, 0, 58, 128, 68, 0,
  130, 0, 130, 0, 68, 0, 56, 0, 15, 13, 26, 16, 0, 254, 224, 14,
  192, 6, 168, 10, 16, 16, 43, 160, 4, 64, 8, 32, 8, 32, 4, 64,
  3, 128, 1, 0, 3, 128, 1, 0, 7, 12, 12, 8, 0, 0, 16, 56,
  84, 16, 56, 16, 56, 68, 130, 130, 68, 56, 14, 7, 14, 16, 0, 255,
  56, 0, 68, 16, 130, 136, 131, 252, 130, 136, 68, 16, 56, 0, 7, 7,
  7, 8, 0, 255, 56, 68, 130, 130, 130, 68, 56, 7, 7, 7, 8, 0,
  255, 56, 124, 254, 254, 254, 124, 56, 5, 5, 5, 8, 2, 0, 112, 136,
  136, 136, 112, 11, 6, 12, 16, 2, 0, 59, 128, 68, 64, 138, 32, 138,
  32, 68, 64, 59, 128, 11, 7, 14, 16, 3, 255, 4, 0, 117, 192, 142,
  32, 142, 32, 142, 32, 117, 192, 4, 0, 13, 5, 10, 16, 1, 0, 112,
  112, 136, 136, 143, 136, 136, 136, 112, 112, 14, 10, 20, 16, 2, 0, 24,
  0, 39, 128, 64, 124, 128, 0, 128, 0, 128, 0, 128, 0, 64, 124, 39,
  128, 24, 0, 11, 13, 26, 16, 2, 0, 31, 0, 10, 0, 63, 128, 64,
  64, 128, 32, 128, 32, 64, 64, 64, 64, 64, 64, 32, 128, 32, 128, 32,
  128, 31, 0, 7, 9, 9, 8, 0, 254, 56, 68, 130, 130, 68, 56, 16,
  16, 16, 6, 9, 9, 8, 0, 254, 112, 136, 4, 4, 8, 48, 32, 248,
  32, 7, 10, 10, 8, 0, 254, 16, 40, 68, 130, 68, 40, 16, 16, 124,
  16, 7, 10, 10, 8, 0, 254, 146, 84, 56, 254, 56, 84, 146, 16, 124,
  16, 13, 11, 22, 16, 1, 0, 2, 0, 2, 0, 2, 0, 2, 0, 114,
  112, 8, 128, 5, 0, 242, 120, 8, 128, 5, 0, 2, 0, 6, 11, 11,
  8, 1, 0, 36, 40, 48, 40, 36, 32, 112, 136, 136, 136, 112, 6, 10,
  10, 8, 1, 254, 56, 112, 224, 224, 224, 112, 56, 16, 124, 16, 8, 7,
  7, 8, 0, 3, 66, 36, 24, 255, 24, 36, 66, 7, 8, 8, 8, 0,
  0, 68, 68, 68, 40, 40, 40, 16, 254, 7, 8, 8, 8, 0, 0, 254,
  16, 40, 40, 40, 68, 68, 68, 6, 8, 8, 8, 1, 0, 252, 132, 132,
  132, 148, 252, 64, 252, 13, 13, 26, 16, 0, 255, 7, 0, 28, 192, 60,
  224, 92, 240, 64, 16, 135, 8, 143, 136, 231, 56, 112, 112, 96, 48, 39,
  32, 31, 192, 7, 0, 13, 13, 26, 16, 0, 255, 7, 0, 24, 192, 48,
  96, 72, 144, 64, 16, 133, 8, 128, 8, 133, 8, 64, 16, 72, 144, 48,
  96, 24, 192, 7, 0, 13, 13, 26, 16, 1, 255, 255, 248, 128, 8, 135,
  8, 136, 136, 136, 136, 135, 8, 130, 8, 130, 8, 130, 8, 131, 136, 130,
  8, 128, 8, 255, 248, 12, 9, 18, 16, 2, 0, 31, 128, 96, 96, 134,
  16, 134, 16, 224, 112, 191, 208, 169, 80, 105, 96, 31, 128, 12, 12, 24,
  16, 2, 0, 31, 128, 96, 96, 134, 16, 134, 16, 224, 112, 191, 208, 169,
  80, 233, 112, 191, 208, 169, 80, 105, 96, 31, 128, 14, 11, 22, 16, 1,
  255, 31, 224, 112, 56, 207, 204, 188, 244, 188, 244, 143, 196, 160, 20, 171,
  84, 203, 76, 112, 56, 31, 224, 14, 14, 28, 16, 1, 255, 31, 224, 112,
  56, 207, 204, 188, 244, 188, 244, 143, 196, 160, 20, 171, 84, 139, 68, 160,
  20, 171, 84, 203, 76, 112, 56, 31, 224
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 15, '1' Height: 13
  Calculated Max Values w=16 h=16 x= 7 y= 5 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =15 descent=-2
  X Font      ascent =15 descent=-2
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_78_79[7084] U8G_FONT_SECTION("u8g_font_unifont_78_79") = {
  0, 16, 16, 0, 254, 15, 8, 41, 11, 207, 1, 255, 254, 14, 254, 15,
  254, 15, 11, 22, 16, 0, 2, 56, 0, 124, 0, 108, 0, 124, 0, 60,
  0, 14, 0, 127, 252, 255, 254, 217, 192, 248, 224, 112, 0, 14, 11, 22,
  16, 0, 1, 112, 12, 248, 56, 216, 112, 254, 224, 127, 192, 7, 128, 127,
  192, 254, 224, 216, 112, 248, 56, 112, 12, 15, 11, 22, 16, 0, 255, 112,
  0, 248, 224, 217, 192, 255, 254, 127, 252, 14, 0, 60, 0, 124, 0, 108,
  0, 124, 0, 56, 0, 15, 11, 22, 16, 0, 1, 112, 12, 136, 50, 174,
  68, 129, 136, 121, 16, 6, 32, 120, 80, 129, 136, 174, 68, 136, 50, 112,
  12, 14, 11, 22, 16, 1, 255, 0, 8, 0, 20, 0, 36, 0, 72, 64,
  144, 161, 32, 162, 64, 84, 128, 73, 0, 34, 0, 28, 0, 15, 15, 30,
  16, 0, 255, 7, 192, 24, 48, 32, 8, 65, 196, 71, 228, 143, 242, 143,
  114, 158, 98, 156, 2, 159, 2, 79, 4, 70, 4, 32, 8, 24, 48, 7,
  192, 15, 15, 30, 16, 0, 255, 7, 192, 25, 48, 35, 136, 67, 132, 65,
  4, 131, 130, 135, 194, 135, 194, 135, 194, 139, 162, 92, 116, 88, 52, 32,
  8, 24, 48, 7, 192, 15, 14, 28, 16, 0, 255, 8, 0, 15, 0, 6,
  0, 7, 192, 195, 128, 227, 192, 127, 254, 127, 254, 227, 192, 195, 128, 7,
  192, 6, 0, 15, 0, 8, 0, 14, 7, 14, 16, 1, 3, 255, 252, 192,
  12, 176, 52, 140, 196, 179, 52, 192, 12, 255, 252, 13, 11, 22, 16, 1,
  255, 6, 192, 25, 32, 41, 32, 107, 240, 170, 8, 169, 200, 169, 136, 110,
  8, 80, 16, 32, 32, 31, 192, 14, 13, 26, 16, 1, 0, 21, 0, 42,
  128, 42, 128, 106, 128, 170, 128, 170, 152, 170, 164, 128, 68, 128, 8, 128,
  16, 64, 32, 32, 32, 31, 192, 15, 15, 30, 16, 0, 255, 24, 48, 36,
  72, 34, 136, 18, 144, 17, 16, 9, 32, 8, 32, 124, 252, 146, 130, 146,
  114, 146, 34, 146, 66, 124, 4, 32, 8, 31, 240, 15, 13, 26, 16, 1,
  0, 0, 16, 0, 56, 0, 112, 7, 238, 25, 234, 35, 154, 71, 10, 142,
  10, 223, 202, 36, 10, 95, 250, 224, 10, 192, 14, 12, 12, 24, 16, 1,
  0, 48, 0, 76, 0, 170, 0, 149, 0, 226, 128, 81, 64, 40, 160, 20,
  80, 10, 80, 5, 144, 2, 48, 1, 240, 15, 7, 14, 16, 0, 3, 63,
  240, 80, 40, 143, 244, 168, 22, 143, 244, 80, 40, 63, 240, 12, 12, 24,
  16, 1, 0, 1, 240, 2, 48, 5, 144, 10, 80, 20, 80, 40, 160, 81,
  64, 226, 128, 149, 0, 170, 0, 76, 0, 48, 0, 15, 7, 14, 16, 0,
  3, 0, 240, 121, 8, 134, 108, 128, 254, 134, 108, 121, 8, 0, 240, 15,
  7, 14, 16, 0, 3, 0, 224, 121, 240, 255, 56, 255, 14, 255, 56, 121,
  240, 0, 224, 13, 10, 20, 16, 1, 255, 0, 8, 0, 16, 0, 32, 128,
  64, 128, 128, 65, 0, 66, 0, 36, 0, 40, 0, 16, 0, 15, 11, 22,
  16, 0, 255, 0, 4, 0, 14, 64, 28, 224, 56, 224, 112, 112, 224, 113,
  192, 59, 128, 63, 0, 30, 0, 12, 0, 11, 11, 22, 16, 2, 1, 64,
  64, 224, 224, 113, 192, 59, 128, 31, 0, 14, 0, 31, 0, 59, 128, 113,
  192, 224, 224, 64, 64, 15, 15, 30, 16, 0, 255, 16, 16, 56, 56, 124,
  124, 254, 254, 127, 252, 63, 248, 31, 240, 15, 224, 31, 240, 63, 248, 127,
  252, 254, 254, 124, 124, 56, 56, 16, 16, 12, 13, 26, 16, 1, 0, 192,
  48, 96, 192, 99, 128, 54, 0, 28, 0, 28, 0, 54, 0, 51, 0, 97,
  128, 96, 192, 192, 96, 192, 48, 64, 0, 12, 14, 28, 16, 1, 255, 192,
  48, 224, 224, 99, 192, 119, 0, 62, 0, 28, 0, 62, 0, 55, 0, 115,
  128, 97, 192, 224, 224, 192, 112, 192, 32, 64, 0, 15, 15, 30, 16, 0,
  255, 7, 192, 4, 64, 5, 64, 5, 64, 5, 64, 253, 126, 129, 2, 191,
  250, 129, 2, 253, 126, 5, 64, 5, 64, 5, 64, 4, 64, 7, 192, 15,
  15, 30, 16, 0, 255, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 255,
  254, 255, 254, 255, 254, 255, 254, 255, 254, 7, 192, 7, 192, 7, 192, 7,
  192, 7, 192, 15, 15, 30, 16, 0, 255, 3, 128, 3, 128, 3, 128, 3,
  128, 3, 128, 3, 128, 252, 126, 252, 126, 252, 126, 3, 128, 3, 128, 3,
  128, 3, 128, 3, 128, 3, 128, 15, 15, 30, 16, 0, 255, 7, 192, 7,
  192, 7, 192, 7, 192, 7, 192, 248, 62, 248, 62, 248, 62, 248, 62, 248,
  62, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 9, 11, 22, 16, 3,
  1, 28, 0, 28, 0, 28, 0, 255, 128, 255, 128, 255, 128, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 13, 15, 30, 16, 1, 255, 15, 0, 9,
  128, 9, 128, 9, 128, 249, 240, 128, 24, 128, 24, 249, 248, 121, 248, 9,
  128, 9, 128, 9, 128, 9, 128, 15, 128, 7, 128, 13, 14, 28, 16, 1,
  255, 31, 192, 16, 64, 247, 120, 135, 8, 191, 232, 191, 232, 191, 232, 135,
  8, 247, 120, 23, 64, 23, 64, 23, 64, 16, 64, 31, 192, 15, 15, 30,
  16, 0, 255, 31, 240, 7, 192, 3, 128, 131, 130, 131, 130, 195, 134, 255,
  254, 255, 254, 255, 254, 195, 134, 131, 130, 131, 130, 3, 128, 7, 192, 31,
  240, 15, 15, 30, 16, 0, 255, 1, 0, 1, 0, 2, 128, 255, 254, 68,
  68, 40, 40, 40, 40, 16, 16, 40, 40, 40, 40, 68, 68, 255, 254, 2,
  128, 1, 0, 1, 0, 15, 15, 30, 16, 0, 255, 3, 128, 7, 192, 7,
  192, 3, 128, 3, 128, 97, 12, 249, 62, 255, 254, 249, 62, 97, 12, 3,
  128, 3, 128, 7, 192, 7, 192, 3, 128, 15, 15, 30, 16, 0, 255, 3,
  128, 7, 192, 7, 192, 7, 192, 3, 128, 113, 28, 249, 62, 255, 254, 249,
  62, 113, 28, 3, 128, 7, 192, 7, 192, 7, 192, 3, 128, 15, 15, 30,
  16, 0, 255, 7, 192, 15, 224, 15, 224, 7, 192, 99, 140, 243, 158, 255,
  254, 255, 254, 255, 254, 243, 158, 99, 140, 7, 192, 15, 224, 15, 224, 7,
  192, 16, 15, 30, 16, 0, 255, 1, 0, 3, 128, 7, 192, 7, 192, 1,
  0, 49, 12, 113, 14, 255, 255, 113, 14, 49, 12, 1, 0, 7, 192, 7,
  192, 3, 128, 1, 0, 15, 15, 30, 16, 0, 255, 1, 0, 3, 128, 3,
  128, 7, 192, 7, 192, 31, 240, 127, 252, 255, 254, 127, 252, 31, 240, 7,
  192, 7, 192, 3, 128, 3, 128, 1, 0, 15, 15, 30, 16, 0, 255, 1,
  0, 2, 128, 2, 128, 4, 64, 4, 64, 24, 48, 96, 12, 128, 2, 96,
  12, 24, 48, 4, 64, 4, 64, 2, 128, 2, 128, 1, 0, 14, 14, 28,
  16, 1, 255, 8, 0, 8, 0, 20, 0, 34, 0, 193, 128, 34, 32, 20,
  32, 8, 80, 9, 140, 0, 80, 0, 32, 2, 32, 5, 0, 2, 0, 15,
  12, 24, 16, 0, 1, 1, 0, 2, 128, 2, 128, 252, 126, 64, 4, 56,
  56, 8, 32, 16, 16, 17, 16, 38, 200, 40, 40, 48, 24, 15, 15, 30,
  16, 0, 255, 7, 192, 31, 240, 62, 248, 126, 252, 124, 124, 192, 6, 240,
  30, 248, 62, 240, 30, 241, 30, 103, 204, 111, 236, 63, 248, 31, 240, 7,
  192, 15, 12, 24, 16, 0, 1, 1, 0, 3, 128, 3, 128, 255, 254, 124,
  124, 56, 56, 8, 32, 28, 112, 31, 240, 62, 248, 56, 56, 48, 24, 15,
  12, 24, 16, 0, 1, 1, 0, 2, 128, 2, 128, 252, 126, 67, 132, 39,
  200, 23, 208, 19, 144, 16, 16, 39, 200, 40, 40, 48, 24, 15, 12, 24,
  16, 0, 1, 1, 0, 2, 128, 28, 112, 225, 14, 79, 228, 35, 136, 23,
  208, 20, 80, 17, 16, 34, 136, 44, 104, 48, 24, 15, 12, 24, 16, 0,
  1, 1, 0, 2, 128, 29, 112, 227, 142, 95, 244, 47, 232, 23, 208, 22,
  208, 21, 80, 34, 136, 44, 104, 48, 24, 15, 13, 26, 16, 0, 0, 1,
  0, 3, 128, 5, 192, 249, 254, 93, 140, 39, 184, 19, 240, 15, 208, 29,
  144, 25, 208, 50, 232, 44, 120, 48, 24, 16, 13, 26, 16, 0, 0, 1,
  0, 2, 128, 2, 192, 255, 254, 68, 71, 56, 62, 8, 60, 22, 208, 17,
  24, 39, 200, 47, 44, 60, 28, 24, 12, 15, 13, 26, 16, 0, 0, 3,
  128, 3, 128, 3, 128, 67, 132, 243, 158, 63, 252, 15, 240, 63, 252, 243,
  158, 67, 132, 3, 128, 3, 128, 3, 128, 15, 13, 26, 16, 0, 0, 3,
  128, 3, 128, 3, 128, 67, 132, 243, 158, 60, 124, 8, 48, 60, 124, 243,
  158, 67, 132, 3, 128, 3, 128, 3, 128, 15, 15, 30, 16, 0, 255, 1,
  0, 1, 0, 33, 8, 17, 16, 13, 96, 15, 224, 7, 192, 255, 254, 7,
  192, 15, 224, 13, 96, 17, 16, 33, 8, 1, 0, 1, 0, 15, 15, 30,
  16, 0, 255, 1, 0, 1, 0, 33, 8, 27, 176, 31, 240, 15, 224, 31,
  224, 255, 254, 31, 240, 15, 224, 31, 240, 27, 176, 33, 8, 1, 0, 1,
  0, 15, 15, 30, 16, 0, 255, 1, 0, 2, 128, 60, 248, 44, 200, 38,
  152, 50, 184, 125, 76, 131, 134, 77, 124, 58, 152, 50, 200, 38, 104, 62,
  120, 2, 128, 1, 0, 13, 13, 26, 16, 1, 0, 2, 0, 2, 0, 2,
  0, 135, 8, 119, 112, 63, 224, 31, 192, 63, 224, 119, 112, 135, 8, 2,
  0, 2, 0, 2, 0, 15, 15, 30, 16, 0, 255, 8, 32, 8, 32, 12,
  96, 6, 192, 230, 206, 59, 184, 31, 240, 7, 192, 31, 240, 59, 184, 230,
  206, 6, 192, 12, 96, 8, 32, 8, 32, 15, 15, 30, 16, 0, 255, 8,
  32, 12, 96, 14, 224, 15, 224, 255, 254, 127, 252, 63, 248, 31, 240, 63,
  248, 127, 252, 255, 254, 15, 224, 14, 224, 12, 96, 8, 32, 15, 15, 30,
  16, 0, 255, 1, 0, 25, 48, 15, 224, 79, 228, 127, 252, 63, 248, 63,
  248, 255, 254, 63, 248, 63, 248, 127, 252, 79, 228, 15, 224, 25, 48, 1,
  0, 15, 15, 30, 16, 0, 255, 9, 32, 73, 36, 37, 72, 21, 80, 203,
  166, 55, 216, 15, 224, 255, 254, 15, 224, 55, 216, 203, 166, 21, 80, 37,
  72, 73, 36, 9, 32, 15, 15, 30, 16, 0, 255, 1, 0, 3, 128, 3,
  128, 3, 128, 225, 14, 113, 28, 13, 96, 3, 128, 13, 96, 113, 28, 225,
  14, 3, 128, 3, 128, 3, 128, 1, 0, 15, 15, 30, 16, 0, 255, 3,
  128, 7, 192, 7, 192, 99, 140, 241, 30, 243, 158, 60, 120, 8, 32, 60,
  120, 243, 158, 241, 30, 99, 140, 7, 192, 7, 192, 3, 128, 15, 15, 30,
  16, 0, 255, 3, 128, 7, 192, 7, 192, 99, 140, 243, 158, 241, 30, 61,
  120, 7, 192, 61, 120, 241, 30, 243, 158, 99, 140, 7, 192, 7, 192, 3,
  128, 15, 15, 30, 16, 0, 255, 3, 128, 4, 64, 4, 64, 116, 92, 252,
  126, 254, 254, 127, 252, 33, 8, 67, 132, 135, 194, 143, 226, 119, 220, 7,
  192, 7, 192, 3, 128, 15, 14, 28, 16, 0, 0, 3, 128, 7, 192, 15,
  224, 119, 220, 255, 254, 252, 126, 240, 30, 112, 28, 24, 48, 62, 248, 127,
  252, 126, 252, 126, 252, 60, 120, 15, 14, 28, 16, 0, 0, 3, 128, 4,
  64, 9, 32, 121, 60, 133, 66, 179, 154, 143, 226, 111, 236, 23, 208, 39,
  200, 73, 36, 82, 148, 66, 132, 60, 120, 15, 15, 30, 16, 0, 255, 3,
  128, 60, 120, 69, 68, 81, 20, 77, 100, 111, 236, 134, 194, 188, 122, 134,
  194, 111, 236, 77, 100, 81, 20, 69, 68, 60, 120, 3, 128, 15, 15, 30,
  16, 0, 255, 7, 192, 30, 240, 62, 248, 92, 116, 103, 204, 252, 126, 232,
  46, 136, 34, 232, 46, 252, 126, 103, 204, 92, 116, 62, 248, 30, 240, 7,
  192, 15, 15, 30, 16, 0, 255, 3, 128, 4, 192, 4, 192, 116, 220, 188,
  230, 159, 158, 79, 60, 63, 248, 114, 100, 230, 114, 206, 122, 118, 92, 6,
  64, 6, 64, 3, 128, 15, 13, 26, 16, 0, 0, 1, 0, 5, 64, 3,
  128, 201, 38, 49, 24, 77, 100, 3, 128, 77, 100, 49, 24, 201, 38, 3,
  128, 5, 64, 1, 0, 15, 13, 26, 16, 0, 0, 1, 0, 5, 64, 11,
  160, 201, 38, 49, 24, 77, 100, 131, 130, 77, 100, 49, 24, 201, 38, 11,
  160, 5, 64, 1, 0, 15, 15, 30, 16, 0, 255, 9, 32, 13, 96, 7,
  192, 19, 144, 201, 38, 49, 24, 237, 110, 3, 128, 237, 110, 49, 24, 201,
  38, 17, 16, 7, 192, 13, 96, 9, 32, 14, 14, 28, 16, 1, 255, 7,
  128, 71, 136, 39, 144, 19, 32, 11, 64, 224, 28, 251, 124, 251, 124, 224,
  28, 11, 64, 19, 32, 39, 144, 71, 136, 7, 128, 15, 15, 30, 16, 0,
  255, 7, 192, 71, 196, 39, 200, 19, 144, 11, 160, 224, 14, 251, 190, 251,
  190, 251, 190, 224, 14, 11, 160, 19, 144, 39, 200, 71, 196, 7, 192, 15,
  15, 30, 16, 0, 255, 3, 128, 7, 192, 7, 192, 119, 220, 251, 190, 249,
  62, 125, 124, 7, 192, 125, 124, 249, 62, 251, 190, 119, 220, 7, 192, 7,
  192, 3, 128, 15, 15, 30, 16, 0, 255, 1, 0, 3, 128, 51, 152, 49,
  24, 9, 32, 5, 64, 99, 140, 255, 254, 99, 140, 5, 64, 9, 32, 49,
  24, 51, 152, 3, 128, 1, 0, 15, 15, 30, 16, 0, 255, 1, 0, 3,
  128, 51, 152, 59, 184, 25, 48, 7, 192, 119, 220, 255, 254, 119, 220, 7,
  192, 25, 48, 59, 184, 51, 152, 3, 128, 1, 0, 11, 11, 22, 16, 2,
  1, 96, 192, 241, 224, 123, 192, 63, 128, 31, 0, 31, 0, 63, 128, 123,
  192, 241, 224, 224, 224, 64, 64, 13, 13, 26, 16, 2, 255, 15, 0, 48,
  192, 64, 32, 64, 48, 128, 16, 128, 24, 128, 24, 128, 24, 64, 56, 64,
  48, 48, 240, 15, 224, 7, 128, 13, 13, 26, 16, 0, 0, 255, 248, 223,
  216, 143, 136, 199, 24, 226, 56, 240, 120, 248, 248, 240, 120, 226, 56, 199,
  24, 143, 136, 223, 216, 255, 248, 12, 12, 24, 16, 3, 1, 255, 192, 128,
  64, 128, 112, 128, 112, 128, 112, 128, 112, 128, 112, 128, 112, 128, 112, 255,
  240, 63, 240, 63, 240, 12, 12, 24, 16, 3, 1, 63, 240, 63, 240, 255,
  240, 128, 112, 128, 112, 128, 112, 128, 112, 128, 112, 128, 112, 128, 112, 128,
  64, 255, 192, 12, 12, 24, 16, 3, 1, 255, 192, 128, 96, 128, 112, 128,
  112, 128, 112, 128, 112, 128, 112, 128, 112, 128, 112, 255, 240, 127, 240, 63,
  240, 12, 12, 24, 16, 3, 1, 63, 240, 127, 240, 255, 240, 128, 112, 128,
  112, 128, 112, 128, 112, 128, 112, 128, 112, 128, 112, 128, 96, 255, 192, 9,
  15, 30, 16, 3, 254, 28, 0, 127, 0, 243, 128, 193, 128, 199, 128, 15,
  0, 28, 0, 24, 0, 24, 0, 24, 0, 0, 0, 24, 0, 60, 0, 60,
  0, 24, 0, 9, 16, 32, 16, 3, 254, 62, 0, 65, 0, 156, 128, 162,
  128, 66, 128, 4, 128, 9, 0, 18, 0, 20, 0, 20, 0, 28, 0, 0,
  0, 28, 0, 34, 0, 34, 0, 28, 0, 7, 15, 15, 16, 4, 255, 56,
  108, 198, 130, 198, 68, 108, 40, 40, 56, 0, 56, 68, 68, 56, 13, 13,
  26, 16, 1, 0, 2, 0, 7, 0, 15, 128, 7, 0, 34, 32, 112, 112,
  248, 248, 112, 112, 34, 32, 7, 0, 15, 128, 7, 0, 2, 0, 4, 14,
  14, 16, 6, 0, 96, 240, 240, 240, 240, 240, 240, 96, 96, 96, 96, 0,
  96, 96, 2, 15, 15, 16, 7, 255, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 4, 15, 15, 16, 6, 255, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 8, 15, 15, 16,
  4, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 7, 10, 10, 16, 4, 4, 28, 112, 192, 248, 252, 254, 254, 254, 124,
  56, 7, 10, 10, 16, 4, 4, 56, 124, 254, 254, 254, 126, 62, 6, 28,
  112, 15, 10, 20, 16, 0, 4, 28, 28, 112, 112, 192, 192, 248, 248, 252,
  252, 254, 254, 254, 254, 254, 254, 124, 124, 56, 56, 15, 10, 20, 16, 0,
  4, 56, 56, 124, 124, 254, 254, 254, 254, 254, 254, 126, 126, 62, 62, 6,
  6, 28, 28, 112, 112, 7, 10, 10, 16, 3, 0, 56, 124, 254, 254, 254,
  126, 62, 6, 28, 112, 15, 10, 20, 16, 0, 0, 56, 56, 124, 124, 254,
  254, 254, 254, 254, 254, 126, 126, 62, 62, 6, 6, 28, 28, 112, 112, 14,
  14, 28, 16, 1, 255, 0, 32, 0, 32, 31, 252, 127, 240, 252, 32, 252,
  32, 126, 32, 31, 224, 0, 32, 96, 96, 240, 64, 240, 192, 99, 128, 62,
  0, 9, 15, 30, 16, 3, 255, 28, 0, 127, 0, 255, 128, 255, 128, 255,
  128, 127, 0, 28, 0, 8, 0, 8, 0, 0, 0, 28, 0, 62, 0, 62,
  0, 62, 0, 28, 0, 9, 13, 26, 16, 3, 0, 119, 0, 255, 128, 255,
  128, 255, 128, 127, 0, 28, 0, 8, 0, 0, 0, 28, 0, 62, 0, 62,
  0, 62, 0, 28, 0, 15, 13, 26, 16, 0, 255, 60, 120, 126, 252, 255,
  254, 255, 254, 255, 254, 127, 252, 127, 252, 63, 248, 31, 240, 15, 224, 7,
  192, 3, 128, 1, 0, 13, 15, 30, 16, 1, 255, 56, 0, 126, 0, 255,
  0, 255, 128, 255, 192, 255, 224, 127, 240, 63, 248, 127, 240, 255, 224, 255,
  192, 255, 128, 255, 0, 126, 0, 56, 0, 15, 14, 28, 16, 0, 255, 3,
  0, 12, 134, 56, 142, 103, 248, 1, 0, 57, 56, 126, 252, 255, 254, 255,
  254, 127, 252, 63, 248, 31, 226, 7, 238, 0, 248, 14, 15, 30, 16, 1,
  254, 97, 152, 99, 200, 55, 236, 23, 228, 23, 252, 19, 252, 115, 252, 157,
  248, 147, 248, 83, 248, 103, 240, 39, 240, 55, 224, 19, 192, 1, 128, 4,
  12, 12, 8, 3, 255, 16, 32, 96, 192, 192, 192, 192, 192, 192, 96, 32,
  16, 4, 12, 12, 8, 2, 255, 128, 64, 96, 48, 48, 48, 48, 48, 48,
  96, 64, 128, 5, 12, 12, 8, 2, 255, 24, 48, 112, 224, 224, 224, 224,
  224, 224, 112, 48, 24, 5, 12, 12, 8, 2, 255, 192, 96, 112, 56, 56,
  56, 56, 56, 56, 112, 96, 192, 5, 12, 12, 8, 2, 255, 24, 48, 48,
  96, 96, 192, 192, 96, 96, 48, 48, 24, 5, 12, 12, 8, 2, 255, 192,
  96, 96, 48, 48, 24, 24, 48, 48, 96, 96, 192, 6, 12, 12, 8, 2,
  255, 28, 56, 56, 112, 112, 224, 224, 112, 112, 56, 56, 28, 6, 12, 12,
  8, 1, 255, 224, 112, 112, 56, 56, 28, 28, 56, 56, 112, 112, 224, 7,
  12, 12, 8, 1, 255, 30, 60, 60, 120, 120, 240, 240, 120, 120, 60, 60,
  30, 7, 12, 12, 8, 0, 255, 240, 120, 120, 60, 60, 30, 30, 60, 60,
  120, 120, 240, 3, 12, 12, 8, 3, 255, 32, 64, 128, 128, 128, 128, 128,
  128, 128, 128, 64, 32, 3, 12, 12, 8, 2, 255, 128, 64, 32, 32, 32,
  32, 32, 32, 32, 32, 64, 128, 6, 12, 12, 8, 1, 255, 60, 112, 96,
  96, 48, 48, 224, 48, 48, 96, 112, 60, 6, 12, 12, 8, 1, 255, 240,
  56, 24, 24, 48, 48, 28, 48, 48, 24, 56, 240, 15, 15, 30, 16, 0,
  255, 7, 192, 31, 240, 63, 248, 126, 252, 124, 252, 250, 254, 254, 254, 254,
  254, 254, 254, 254, 254, 126, 252, 120, 60, 63, 248, 31, 240, 7, 192, 15,
  15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248, 124, 124, 123, 188, 251,
  190, 255, 190, 255, 126, 254, 254, 253, 254, 123, 252, 120, 60, 63, 248, 31,
  240, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248, 124,
  124, 123, 188, 251, 190, 255, 190, 254, 126, 255, 190, 251, 190, 123, 188, 124,
  124, 63, 248, 31, 240, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 31,
  240, 63, 248, 127, 124, 126, 124, 253, 126, 251, 126, 247, 126, 240, 62, 255,
  126, 127, 124, 127, 124, 63, 248, 31, 240, 7, 192, 15, 15, 30, 16, 0,
  255, 7, 192, 31, 240, 63, 248, 120, 60, 123, 252, 251, 254, 251, 254, 248,
  126, 255, 190, 255, 190, 123, 188, 124, 124, 63, 248, 31, 240, 7, 192, 15,
  15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248, 126, 124, 125, 252, 251,
  254, 251, 254, 248, 126, 251, 190, 251, 190, 123, 188, 124, 124, 63, 248, 31,
  240, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248, 120,
  60, 127, 188, 255, 190, 255, 126, 255, 126, 255, 126, 254, 254, 126, 252, 126,
  252, 63, 248, 31, 240, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 31,
  240, 63, 248, 124, 124, 123, 188, 251, 190, 251, 190, 252, 126, 251, 190, 251,
  190, 123, 188, 124, 124, 63, 248, 31, 240, 7, 192, 15, 15, 30, 16, 0,
  255, 7, 192, 31, 240, 63, 248, 124, 124, 123, 188, 251, 190, 251, 190, 252,
  62, 255, 190, 255, 190, 127, 124, 124, 252, 63, 248, 31, 240, 7, 192, 15,
  15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248, 127, 252, 123, 156, 243,
  110, 235, 110, 251, 110, 251, 110, 251, 110, 96, 156, 127, 252, 63, 248, 31,
  240, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 64,
  132, 65, 132, 131, 130, 129, 130, 129, 130, 129, 130, 129, 130, 65, 132, 65,
  132, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24,
  48, 32, 8, 71, 196, 79, 228, 140, 98, 128, 98, 129, 194, 135, 2, 140,
  2, 79, 228, 79, 228, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0,
  255, 7, 192, 24, 48, 32, 8, 71, 196, 79, 228, 140, 98, 128, 98, 129,
  194, 128, 98, 140, 98, 79, 228, 71, 196, 32, 8, 24, 48, 7, 192, 15,
  15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 64, 228, 65, 228, 131,
  98, 134, 98, 140, 98, 159, 242, 159, 242, 64, 100, 64, 100, 32, 8, 24,
  48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 79,
  228, 79, 228, 140, 2, 143, 194, 143, 226, 128, 98, 140, 98, 79, 228, 71,
  196, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24,
  48, 32, 8, 71, 196, 79, 228, 140, 2, 143, 194, 143, 226, 140, 98, 140,
  98, 79, 228, 71, 196, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0,
  255, 7, 192, 24, 48, 32, 8, 79, 228, 79, 228, 128, 98, 128, 98, 128,
  194, 131, 130, 134, 2, 70, 4, 70, 4, 32, 8, 24, 48, 7, 192, 15,
  15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 71, 196, 79, 228, 140,
  98, 140, 98, 135, 194, 140, 98, 140, 98, 79, 228, 71, 196, 32, 8, 24,
  48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24, 48, 32, 8, 71,
  196, 79, 228, 140, 98, 140, 98, 143, 226, 135, 226, 128, 98, 79, 228, 71,
  196, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 24,
  48, 32, 8, 68, 228, 77, 244, 157, 178, 141, 178, 141, 178, 141, 178, 141,
  178, 77, 244, 76, 228, 32, 8, 24, 48, 7, 192, 15, 15, 30, 16, 0,
  255, 7, 192, 31, 240, 63, 248, 127, 124, 126, 124, 252, 126, 254, 126, 254,
  126, 254, 126, 254, 126, 126, 124, 126, 124, 63, 248, 31, 240, 7, 192, 15,
  15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248, 120, 60, 112, 28, 243,
  158, 255, 158, 254, 62, 248, 254, 243, 254, 112, 28, 112, 28, 63, 248, 31,
  240, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248, 120,
  60, 112, 28, 243, 158, 255, 158, 254, 62, 255, 158, 243, 158, 112, 28, 120,
  60, 63, 248, 31, 240, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 31,
  240, 63, 248, 127, 28, 126, 28, 252, 158, 249, 158, 243, 158, 224, 14, 224,
  14, 127, 156, 127, 156, 63, 248, 31, 240, 7, 192, 15, 15, 30, 16, 0,
  255, 7, 192, 31, 240, 63, 248, 112, 28, 112, 28, 243, 254, 240, 62, 240,
  30, 255, 158, 243, 158, 112, 28, 120, 60, 63, 248, 31, 240, 7, 192, 15,
  15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248, 120, 60, 112, 28, 243,
  254, 240, 62, 240, 30, 243, 158, 243, 158, 112, 28, 120, 60, 63, 248, 31,
  240, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248, 112,
  28, 112, 28, 255, 158, 255, 158, 255, 62, 252, 126, 249, 254, 121, 252, 121,
  252, 63, 248, 31, 240, 7, 192, 15, 15, 30, 16, 0, 255, 7, 192, 31,
  240, 63, 248, 120, 60, 112, 28, 243, 158, 243, 158, 248, 62, 243, 158, 243,
  158, 112, 28, 120, 60, 63, 248, 31, 240, 7, 192, 15, 15, 30, 16, 0,
  255, 7, 192, 31, 240, 63, 248, 120, 60, 112, 28, 243, 158, 243, 158, 240,
  30, 248, 30, 255, 158, 112, 28, 120, 60, 63, 248, 31, 240, 7, 192, 15,
  15, 30, 16, 0, 255, 7, 192, 31, 240, 63, 248, 123, 28, 114, 12, 226,
  78, 242, 78, 242, 78, 242, 78, 242, 78, 114, 12, 115, 28, 63, 248, 31,
  240, 7, 192, 15, 13, 26, 16, 0, 0, 31, 128, 15, 192, 7, 224, 3,
  240, 255, 248, 255, 252, 255, 254, 255, 252, 255, 248, 3, 240, 7, 224, 15,
  192, 31, 128, 11, 11, 22, 16, 2, 1, 14, 0, 14, 0, 14, 0, 14,
  0, 255, 224, 255, 224, 255, 224, 14, 0, 14, 0, 14, 0, 14, 0, 13,
  3, 6, 16, 1, 5, 255, 248, 255, 248, 255, 248, 13, 11, 22, 16, 1,
  1, 7, 0, 7, 0, 7, 0, 0, 0, 255, 248, 255, 248, 255, 248, 0,
  0, 7, 0, 7, 0, 7, 0, 11, 11, 22, 16, 2, 1, 32, 0, 112,
  0, 248, 0, 120, 0, 60, 128, 12, 128, 3, 128, 3, 192, 15, 192, 1,
  192, 0, 32, 15, 9, 18, 16, 0, 2, 1, 0, 1, 128, 224, 192, 252,
  240, 255, 254, 252, 240, 224, 192, 1, 128, 1, 0, 11, 11, 22, 16, 2,
  0, 0, 32, 1, 192, 15, 192, 3, 192, 3, 128, 12, 128, 60, 128, 120,
  0, 248, 0, 112, 0, 32, 0, 15, 9, 18, 16, 0, 2, 2, 0, 1,
  0, 1, 192, 0, 240, 255, 254, 0, 240, 1, 192, 1, 0, 2, 0, 15,
  13, 26, 16, 0, 0, 0, 192, 1, 224, 1, 240, 0, 248, 127, 252, 255,
  254, 255, 254, 255, 254, 127, 252, 0, 248, 1, 240, 1, 224, 0, 192, 15,
  11, 22, 16, 0, 1, 0, 16, 0, 16, 0, 24, 0, 24, 255, 252, 255,
  254, 255, 252, 0, 24, 0, 24, 0, 16, 0, 16, 15, 13, 26, 16, 0,
  0, 0, 16, 0, 16, 0, 24, 0, 24, 255, 252, 255, 252, 255, 254, 255,
  252, 255, 252, 0, 24, 0, 24, 0, 16, 0, 16, 15, 9, 18, 16, 0,
  2, 0, 32, 0, 48, 0, 56, 170, 252, 170, 254, 170, 252, 0, 56, 0,
  48, 0, 32, 15, 9, 18, 16, 0, 2, 0, 32, 0, 48, 170, 248, 170,
  252, 170, 254, 170, 252, 170, 248, 0, 48, 0, 32, 15, 9, 18, 16, 0,
  2, 0, 32, 0, 48, 0, 56, 255, 252, 255, 254, 255, 252, 0, 56, 0,
  48, 0, 32, 14, 15, 30, 16, 1, 255, 128, 0, 224, 0, 88, 0, 70,
  0, 33, 128, 32, 96, 16, 24, 15, 252, 31, 248, 63, 224, 63, 128, 126,
  0, 120, 0, 224, 0, 128, 0, 14, 15, 30, 16, 1, 255, 128, 0, 224,
  0, 120, 0, 126, 0, 63, 128, 63, 224, 31, 248, 15, 252, 16, 24, 32,
  96, 33, 128, 70, 0, 88, 0, 224, 0, 128, 0, 14, 15, 30, 16, 1,
  255, 128, 0, 224, 0, 120, 0, 126, 0, 63, 128, 63, 224, 31, 248, 15,
  252, 31, 248, 63, 224, 63, 128, 126, 0, 120, 0, 224, 0, 128, 0, 15,
  8, 16, 16, 0, 3, 128, 0, 128, 16, 192, 24, 127, 252, 127, 254, 63,
  252, 0, 24, 0, 16, 15, 8, 16, 16, 0, 2, 0, 16, 0, 24, 63,
  252, 127, 254, 127, 252, 192, 24, 128, 16, 128, 0, 7, 13, 13, 16, 5,
  0, 16, 16, 24, 248, 252, 252, 254, 252, 252, 248, 24, 16, 16, 15, 9,
  18, 16, 0, 2, 0, 64, 0, 64, 255, 224, 255, 240, 255, 254, 255, 240,
  255, 224, 0, 64, 0, 64, 14, 9, 18, 16, 1, 2, 0, 192, 0, 224,
  255, 176, 128, 24, 128, 12, 128, 24, 255, 176, 0, 224, 0, 192, 14, 9,
  18, 16, 1, 2, 0, 192, 0, 224, 255, 208, 192, 8, 192, 4, 192, 8,
  255, 208, 0, 224, 0, 192, 15, 13, 26, 16, 0, 255, 0, 8, 0, 24,
  0, 36, 0, 68, 63, 130, 64, 2, 128, 6, 255, 30, 254, 124, 5, 240,
  15, 192, 15, 0, 12, 0, 15, 13, 26, 16, 0, 0, 12, 0, 15, 0,
  15, 192, 5, 240, 254, 124, 255, 30, 128, 6, 64, 2, 63, 130, 0, 68,
  0, 36, 0, 24, 0, 8, 15, 12, 24, 16, 0, 0, 0, 128, 0, 192,
  255, 160, 128, 16, 128, 8, 128, 4, 128, 14, 128, 28, 255, 184, 127, 240,
  0, 224, 0, 64, 15, 12, 24, 16, 0, 1, 0, 64, 0, 224, 127, 240,
  255, 184, 128, 28, 128, 14, 128, 4, 128, 8, 128, 16, 255, 160, 0, 192,
  0, 128, 16, 12, 24, 16, 0, 0, 0, 64, 0, 96, 0, 80, 255, 200,
  64, 4, 64, 2, 64, 7, 255, 206, 127, 220, 0, 120, 0, 112, 0, 32,
  7, 6, 6, 8, 1, 3, 198, 56, 68, 68, 68, 56, 16, 12, 24, 16,
  0, 1, 0, 32, 0, 112, 0, 120, 127, 220, 255, 206, 64, 7, 64, 2,
  64, 4, 255, 200, 0, 80, 0, 96, 0, 64, 14, 15, 30, 16, 1, 255,
  15, 128, 63, 224, 126, 240, 254, 120, 254, 56, 0, 28, 0, 12, 0, 4,
  0, 12, 0, 28, 254, 56, 254, 120, 126, 240, 63, 224, 15, 128, 15, 7,
  14, 16, 0, 3, 254, 0, 73, 8, 36, 140, 31, 254, 36, 140, 73, 8,
  254, 0, 11, 11, 22, 16, 2, 1, 16, 0, 24, 0, 28, 0, 252, 0,
  124, 0, 60, 32, 2, 32, 1, 96, 0, 224, 1, 224, 7, 224, 14, 5,
  10, 16, 1, 4, 248, 16, 124, 24, 63, 252, 124, 24, 248, 16, 11, 11,
  22, 16, 2, 0, 7, 224, 1, 224, 0, 224, 1, 96, 2, 32, 60, 32,
  124, 0, 252, 0, 28, 0, 24, 0, 16, 0, 11, 11, 22, 16, 2, 1,
  8, 0, 12, 0, 14, 0, 14, 0, 254, 32, 126, 32, 63, 96, 3, 224,
  1, 224, 3, 224, 15, 224, 15, 9, 18, 16, 0, 2, 0, 32, 252, 16,
  126, 24, 63, 252, 31, 254, 63, 252, 126, 24, 252, 16, 0, 32, 11, 11,
  22, 16, 2, 0, 15, 224, 3, 224, 1, 224, 3, 224, 63, 96, 126, 32,
  254, 32, 14, 0, 14, 0, 12, 0, 8, 0, 15, 11, 22, 16, 0, 1,
  0, 96, 0, 240, 0, 240, 120, 56, 255, 12, 255, 254, 255, 12, 120, 56,
  0, 240, 0, 240, 0, 96, 15, 9, 18, 16, 0, 2, 0, 64, 96, 224,
  120, 240, 252, 120, 255, 254, 252, 120, 120, 240, 96, 224, 0, 64, 15, 7,
  14, 16, 0, 3, 248, 16, 124, 24, 62, 28, 31, 254, 62, 28, 124, 24,
  248, 16, 15, 9, 18, 16, 0, 2, 248, 96, 252, 112, 126, 120, 127, 252,
  63, 254, 127, 252, 126, 120, 252, 112, 248, 96, 15, 9, 18, 16, 0, 2,
  2, 32, 1, 16, 0, 136, 255, 196, 0, 2, 255, 196, 0, 136, 1, 16,
  2, 32, 16, 6, 12, 16, 0, 3, 227, 199, 28, 56, 34, 68, 34, 68,
  34, 68, 28, 56, 6, 6, 6, 8, 1, 0, 128, 136, 144, 160, 192, 252,
  11, 12, 24, 16, 2, 0, 4, 0, 10, 0, 10, 0, 17, 0, 17, 0,
  36, 128, 42, 128, 74, 64, 81, 64, 159, 32, 128, 32, 255, 224, 5, 6,
  6, 8, 1, 0, 32, 32, 32, 32, 32, 248, 10, 8, 16, 16, 3, 1,
  63, 192, 64, 0, 129, 128, 130, 64, 130, 64, 129, 128, 64, 0, 63, 192,
  10, 8, 16, 16, 3, 1, 255, 0, 0, 128, 96, 64, 144, 64, 144, 64,
  96, 64, 0, 128, 255, 0, 5, 10, 10, 8, 2, 0, 112, 136, 136, 16,
  16, 32, 32, 64, 64, 56, 5, 10, 10, 8, 2, 0, 112, 136, 136, 64,
  64, 32, 32, 16, 16, 224, 7, 8, 8, 8, 0, 0, 130, 130, 84, 68,
  40, 40, 16, 16, 14, 8, 16, 16, 1, 1, 129, 252, 130, 0, 68, 0,
  68, 0, 36, 0, 36, 0, 18, 0, 17, 252, 14, 8, 16, 16, 1, 1,
  254, 4, 1, 4, 0, 136, 0, 136, 0, 144, 0, 144, 1, 32, 254, 32,
  3, 10, 10, 8, 2, 0, 64, 64, 64, 64, 224, 64, 64, 64, 64, 64,
  8, 8, 8, 16, 4, 1, 1, 2, 4, 8, 16, 32, 64, 128, 12, 14,
  28, 16, 2, 254, 255, 240, 128, 0, 64, 0, 64, 0, 32, 0, 32, 0,
  32, 0, 32, 0, 32, 0, 32, 0, 64, 0, 64, 0, 128, 0, 128, 0,
  8, 8, 8, 16, 4, 1, 128, 64, 32, 16, 8, 4, 2, 1, 13, 13,
  26, 16, 1, 0, 255, 248, 130, 8, 130, 8, 133, 8, 133, 8, 136, 136,
  136, 136, 144, 72, 144, 72, 160, 40, 160, 40, 192, 24, 255, 248, 13, 13,
  26, 16, 1, 0, 255, 248, 192, 24, 160, 40, 160, 40, 144, 72, 144, 72,
  136, 136, 136, 136, 133, 8, 133, 8, 130, 8, 130, 8, 255, 248, 9, 9,
  18, 16, 4, 0, 8, 0, 20, 0, 34, 0, 65, 0, 136, 128, 65, 0,
  34, 0, 20, 0, 8, 0, 7, 8, 8, 8, 0, 0, 16, 16, 40, 40,
  68, 84, 130, 130, 9, 10, 20, 16, 3, 0, 136, 128, 136, 128, 136, 128,
  136, 128, 136, 128, 136, 128, 136, 128, 136, 128, 73, 0, 62, 0, 6, 6,
  6, 8, 1, 0, 4, 4, 36, 4, 4, 252, 6, 6, 6, 8, 1, 0,
  252, 128, 128, 144, 128, 128, 12, 10, 20, 16, 2, 0, 224, 16, 48, 48,
  40, 80, 36, 144, 35, 16, 35, 16, 36, 144, 40, 80, 48, 48, 224, 16,
  12, 10, 20, 16, 2, 0, 128, 112, 192, 192, 161, 64, 146, 64, 140, 64,
  140, 64, 146, 64, 161, 64, 192, 192, 128, 112, 14, 10, 20, 16, 1, 0,
  224, 28, 48, 48, 40, 80, 36, 144, 35, 16, 35, 16, 36, 144, 40, 80,
  48, 48, 224, 28, 9, 12, 24, 16, 3, 0, 8, 0, 8, 0, 8, 0,
  8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0,
  255, 128, 9, 12, 24, 16, 3, 0, 255, 128, 8, 0, 8, 0, 8, 0,
  8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0,
  13, 7, 14, 16, 1, 2, 5, 0, 5, 0, 253, 248, 5, 0, 253, 248,
  5, 0, 5, 0, 13, 7, 14, 16, 1, 2, 5, 0, 5, 0, 5, 0,
  253, 248, 5, 0, 5, 0, 5, 0, 14, 3, 6, 16, 1, 4, 64, 0,
  191, 252, 64, 0, 14, 3, 6, 16, 1, 4, 128, 0, 255, 252, 128, 0,
  14, 3, 6, 16, 1, 4, 0, 4, 255, 252, 0, 4, 3, 11, 11, 16,
  7, 255, 64, 160, 64, 64, 64, 64, 64, 64, 64, 64, 224, 7, 11, 11,
  8, 0, 0, 16, 40, 40, 68, 68, 254, 68, 68, 40, 40, 16, 13, 13,
  26, 16, 1, 0, 2, 0, 5, 0, 5, 0, 8, 128, 16, 64, 96, 48,
  128, 8, 96, 48, 16, 64, 8, 128, 5, 0, 5, 0, 2, 0, 15, 13,
  26, 16, 0, 0, 0, 128, 1, 64, 1, 64, 2, 32, 4, 16, 24, 12,
  224, 2, 24, 12, 4, 16, 2, 32, 1, 64, 1, 64, 0, 128, 15, 13,
  26, 16, 1, 0, 2, 0, 5, 0, 5, 0, 8, 128, 16, 64, 96, 48,
  128, 14, 96, 48, 16, 64, 8, 128, 5, 0, 5, 0, 2, 0, 15, 13,
  26, 16, 0, 0, 31, 254, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2,
  240, 2, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 31, 254, 15, 13,
  26, 16, 1, 0, 255, 240, 128, 16, 128, 16, 128, 16, 128, 16, 128, 16,
  128, 30, 128, 16, 128, 16, 128, 16, 128, 16, 128, 16, 255, 240, 5, 13,
  13, 8, 2, 0, 248, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160, 160,
  248, 5, 13, 13, 8, 1, 0, 248, 40, 40, 40, 40, 40, 40, 40, 40,
  40, 40, 40, 248, 4, 12, 12, 8, 2, 0, 16, 32, 32, 64, 64, 128,
  128, 64, 64, 32, 32, 16, 4, 12, 12, 8, 2, 0, 128, 64, 64, 32,
  32, 16, 16, 32, 32, 64, 64, 128, 6, 12, 12, 8, 1, 0, 20, 40,
  40, 80, 80, 160, 160, 80, 80, 40, 40, 20, 6, 12, 12, 8, 1, 0,
  160, 80, 80, 40, 40, 20, 20, 40, 40, 80, 80, 160, 4, 12, 12, 8,
  3, 255, 16, 32, 96, 160, 160, 160, 160, 160, 160, 96, 32, 16, 4, 12,
  12, 8, 1, 255, 128, 64, 96, 80, 80, 80, 80, 80, 80, 96, 64, 128,
  3, 12, 12, 8, 4, 255, 32, 64, 128, 128, 128, 128, 128, 128, 128, 128,
  64, 32, 3, 12, 12, 8, 1, 255, 128, 64, 32, 32, 32, 32, 32, 32,
  32, 32, 64, 128, 11, 12, 24, 16, 2, 0, 4, 0, 10, 0, 27, 0,
  42, 128, 106, 192, 170, 160, 42, 128, 42, 128, 42, 128, 42, 128, 42, 128,
  42, 128, 11, 12, 24, 16, 2, 0, 42, 128, 42, 128, 42, 128, 42, 128,
  42, 128, 42, 128, 170, 160, 106, 192, 42, 128, 27, 0, 10, 0, 4, 0,
  12, 10, 20, 16, 2, 0, 7, 128, 8, 64, 16, 32, 32, 16, 168, 16,
  112, 16, 32, 16, 0, 32, 8, 64, 7, 128, 12, 10, 20, 16, 2, 0,
  30, 0, 33, 0, 64, 128, 128, 64, 129, 80, 128, 224, 128, 64, 64, 0,
  33, 0, 30, 0, 15, 7, 14, 16, 0, 1, 3, 128, 5, 72, 9, 36,
  255, 254, 9, 36, 5, 72, 3, 128, 15, 5, 10, 16, 1, 2, 32, 0,
  64, 0, 255, 254, 64, 0, 32, 0, 15, 5, 10, 16, 0, 2, 0, 8,
  0, 4, 255, 254, 0, 4, 0, 8, 14, 5, 10, 16, 1, 2, 32, 16,
  64, 8, 255, 252, 64, 8, 32, 16, 15, 7, 14, 16, 0, 1, 16, 0,
  32, 0, 127, 254, 128, 0, 127, 254, 32, 0, 16, 0, 15, 7, 14, 16,
  0, 1, 0, 16, 0, 8, 255, 252, 0, 2, 255, 252, 0, 8, 0, 16,
  14, 7, 14, 16, 1, 1, 16, 32, 32, 16, 127, 248, 128, 4, 127, 248,
  32, 16, 16, 32, 14, 5, 10, 16, 1, 2, 32, 4, 64, 4, 255, 252,
  64, 4, 32, 4, 14, 5, 10, 16, 1, 2, 128, 16, 128, 8, 255, 252,
  128, 8, 128, 16, 14, 7, 14, 16, 1, 1, 16, 4, 32, 4, 127, 252,
  128, 4, 127, 252, 32, 4, 16, 4, 14, 7, 14, 16, 1, 1, 128, 32,
  128, 16, 255, 248, 128, 4, 255, 248, 128, 16, 128, 32, 15, 5, 10, 16,
  0, 2, 0, 8, 34, 36, 213, 94, 8, 132, 0, 8
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 11, '1' Height: 5
  Calculated Max Values w=15 h=15 x= 3 y= 4 dx=16 dy= 0 ascent=13 len=30
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =11 descent= 2
  X Font      ascent =11 descent= 0
  Max Font    ascent =13 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_86[1858] U8G_FONT_SECTION("u8g_font_unifont_86") = {
  0, 16, 16, 0, 254, 11, 3, 31, 5, 100, 32, 116, 2, 13, 254, 11,
  0, 11, 11, 22, 16, 2, 0, 7, 224, 4, 32, 2, 32, 4, 32, 8,
  160, 17, 96, 34, 0, 68, 0, 136, 0, 80, 0, 32, 0, 11, 11, 22,
  16, 2, 0, 252, 0, 132, 0, 136, 0, 132, 0, 162, 0, 209, 0, 8,
  128, 4, 64, 2, 32, 1, 64, 0, 128, 11, 11, 22, 16, 2, 0, 32,
  0, 80, 0, 136, 0, 68, 0, 34, 0, 17, 96, 8, 160, 4, 32, 2,
  32, 4, 32, 7, 224, 11, 11, 22, 16, 2, 0, 0, 128, 1, 64, 2,
  32, 4, 64, 8, 128, 209, 0, 162, 0, 132, 0, 136, 0, 132, 0, 252,
  0, 14, 7, 14, 16, 1, 1, 16, 32, 48, 48, 95, 232, 128, 4, 95,
  232, 48, 48, 16, 32, 13, 7, 14, 16, 1, 1, 16, 0, 48, 0, 127,
  248, 255, 248, 127, 248, 48, 0, 16, 0, 7, 12, 12, 8, 0, 0, 16,
  56, 124, 254, 56, 56, 56, 56, 56, 56, 56, 56, 7, 12, 12, 8, 0,
  0, 56, 56, 56, 56, 56, 56, 56, 56, 254, 124, 56, 16, 11, 11, 22,
  16, 2, 0, 7, 224, 7, 224, 3, 224, 7, 224, 15, 224, 31, 96, 62,
  0, 124, 0, 248, 0, 112, 0, 32, 0, 11, 11, 22, 16, 2, 0, 252,
  0, 252, 0, 248, 0, 252, 0, 254, 0, 223, 0, 15, 128, 7, 192, 3,
  224, 1, 192, 0, 128, 11, 11, 22, 16, 2, 0, 32, 0, 112, 0, 248,
  0, 124, 0, 62, 0, 31, 96, 15, 224, 7, 224, 3, 224, 7, 224, 7,
  224, 11, 11, 22, 16, 2, 0, 0, 128, 1, 192, 3, 224, 7, 192, 15,
  128, 223, 0, 254, 0, 252, 0, 248, 0, 252, 0, 252, 0, 14, 7, 14,
  16, 1, 1, 16, 32, 48, 48, 127, 248, 255, 252, 127, 248, 48, 48, 16,
  32, 7, 12, 12, 8, 0, 0, 16, 56, 124, 254, 56, 56, 56, 56, 254,
  124, 56, 16, 15, 5, 10, 16, 0, 0, 255, 248, 0, 8, 0, 42, 0,
  28, 0, 8, 15, 5, 10, 16, 0, 4, 0, 8, 0, 28, 0, 42, 0,
  8, 255, 248, 15, 5, 10, 16, 1, 0, 63, 254, 32, 0, 168, 0, 112,
  0, 32, 0, 15, 5, 10, 16, 1, 4, 32, 0, 112, 0, 168, 0, 32,
  0, 63, 254, 10, 10, 20, 16, 3, 255, 255, 192, 255, 192, 255, 192, 255,
  192, 255, 192, 128, 64, 128, 64, 128, 64, 128, 64, 255, 192, 10, 10, 20,
  16, 3, 255, 255, 192, 128, 64, 128, 64, 128, 64, 128, 64, 255, 192, 255,
  192, 255, 192, 255, 192, 255, 192, 10, 10, 20, 16, 3, 255, 255, 192, 255,
  192, 191, 192, 159, 192, 143, 192, 135, 192, 131, 192, 129, 192, 128, 192, 255,
  192, 10, 10, 20, 16, 3, 255, 255, 192, 192, 64, 224, 64, 240, 64, 248,
  64, 252, 64, 254, 64, 255, 64, 255, 192, 255, 192, 10, 10, 20, 16, 3,
  255, 12, 0, 26, 0, 57, 0, 120, 128, 248, 64, 248, 64, 120, 128, 57,
  0, 26, 0, 12, 0, 10, 10, 20, 16, 3, 255, 12, 0, 22, 0, 39,
  0, 71, 128, 135, 192, 135, 192, 71, 128, 39, 0, 22, 0, 12, 0, 10,
  10, 20, 16, 3, 255, 12, 0, 30, 0, 63, 0, 127, 128, 255, 192, 128,
  64, 64, 128, 33, 0, 18, 0, 12, 0, 10, 10, 20, 16, 3, 255, 12,
  0, 18, 0, 33, 0, 64, 128, 128, 64, 255, 192, 127, 128, 63, 0, 30,
  0, 12, 0, 11, 11, 22, 16, 2, 0, 170, 160, 0, 0, 128, 32, 0,
  0, 128, 32, 0, 0, 128, 32, 0, 0, 128, 32, 0, 0, 170, 160, 14,
  14, 28, 16, 1, 255, 255, 252, 255, 252, 255, 252, 255, 252, 255, 252, 255,
  252, 255, 252, 255, 252, 255, 252, 255, 252, 255, 252, 255, 252, 255, 252, 255,
  252, 14, 14, 28, 16, 1, 255, 255, 252, 128, 4, 128, 4, 128, 4, 128,
  4, 128, 4, 128, 4, 128, 4, 128, 4, 128, 4, 128, 4, 128, 4, 128,
  4, 255, 252, 4, 4, 4, 8, 2, 2, 240, 240, 240, 240, 4, 4, 4,
  8, 2, 2, 240, 144, 144, 240, 12, 11, 22, 16, 2, 0, 6, 0, 15,
  0, 31, 128, 63, 192, 127, 224, 255, 240, 127, 224, 127, 224, 63, 192, 63,
  192, 31, 128, 12, 11, 22, 16, 2, 0, 6, 0, 9, 0, 16, 128, 32,
  64, 64, 32, 128, 16, 64, 32, 64, 32, 32, 64, 32, 64, 31, 128, 11,
  11, 22, 16, 2, 255, 4, 0, 27, 0, 96, 192, 128, 32, 128, 32, 128,
  32, 128, 32, 128, 32, 96, 192, 27, 0, 4, 0, 11, 11, 22, 16, 2,
  255, 4, 0, 31, 0, 127, 192, 255, 224, 255, 224, 255, 224, 255, 224, 255,
  224, 127, 192, 31, 0, 4, 0, 14, 10, 20, 16, 1, 0, 15, 192, 31,
  224, 63, 240, 127, 248, 255, 252, 255, 252, 127, 248, 63, 240, 31, 224, 15,
  192, 14, 13, 26, 16, 1, 254, 31, 224, 63, 240, 127, 248, 255, 252, 255,
  252, 255, 252, 255, 252, 255, 252, 255, 252, 255, 252, 127, 248, 63, 240, 31,
  224, 7, 7, 7, 8, 0, 0, 16, 56, 124, 254, 124, 56, 16, 7, 7,
  7, 8, 0, 0, 16, 40, 68, 130, 68, 40, 16, 7, 11, 11, 8, 0,
  0, 16, 56, 56, 124, 124, 254, 124, 124, 56, 56, 16, 7, 11, 11, 8,
  0, 0, 16, 40, 40, 68, 68, 130, 68, 68, 40, 40, 16, 5, 5, 5,
  8, 1, 3, 32, 112, 248, 112, 32, 5, 7, 7, 8, 1, 0, 32, 112,
  112, 248, 112, 112, 32, 5, 7, 7, 8, 1, 0, 32, 80, 80, 136, 80,
  80, 32, 15, 6, 12, 16, 0, 0, 15, 224, 127, 252, 255, 254, 255, 254,
  127, 252, 15, 224, 15, 6, 12, 16, 0, 0, 15, 224, 112, 28, 128, 2,
  128, 2, 112, 28, 15, 224, 6, 13, 13, 8, 1, 0, 48, 120, 120, 120,
  252, 252, 252, 252, 252, 120, 120, 120, 48, 6, 13, 13, 8, 1, 0, 48,
  72, 72, 72, 132, 132, 132, 132, 132, 72, 72, 72, 48, 15, 5, 10, 16,
  1, 2, 33, 192, 66, 32, 255, 254, 66, 32, 33, 192, 14, 15, 30, 16,
  1, 254, 32, 0, 64, 0, 255, 252, 64, 0, 32, 0, 32, 0, 64, 0,
  255, 252, 64, 0, 32, 0, 32, 0, 64, 0, 255, 252, 64, 0, 32, 0,
  15, 5, 10, 16, 1, 2, 33, 192, 66, 160, 255, 254, 66, 160, 33, 192,
  15, 5, 10, 16, 1, 2, 34, 32, 69, 80, 245, 94, 72, 128, 32, 0,
  15, 5, 10, 16, 1, 2, 40, 64, 80, 64, 255, 254, 80, 64, 40, 64,
  15, 5, 10, 16, 1, 2, 40, 160, 80, 160, 255, 254, 80, 160, 40, 160,
  14, 5, 10, 16, 1, 2, 40, 4, 80, 4, 255, 252, 80, 4, 40, 4,
  14, 5, 10, 16, 1, 2, 40, 4, 80, 8, 253, 176, 80, 8, 40, 4,
  14, 5, 10, 16, 1, 2, 32, 0, 64, 0, 213, 84, 64, 0, 32, 0,
  14, 5, 10, 16, 1, 2, 32, 132, 64, 136, 255, 240, 64, 136, 32, 132,
  14, 5, 10, 16, 1, 2, 33, 68, 65, 72, 255, 240, 65, 72, 33, 68,
  14, 5, 10, 16, 1, 2, 40, 4, 80, 8, 255, 240, 80, 8, 40, 4,
  14, 5, 10, 16, 1, 2, 40, 132, 80, 136, 255, 240, 80, 136, 40, 132,
  14, 5, 10, 16, 1, 2, 41, 68, 81, 72, 255, 240, 81, 72, 41, 68,
  15, 5, 10, 16, 1, 2, 40, 144, 80, 96, 255, 254, 80, 96, 40, 144,
  15, 5, 10, 16, 1, 2, 32, 120, 64, 132, 255, 2, 64, 0, 32, 0,
  15, 7, 14, 16, 1, 2, 3, 240, 0, 0, 35, 240, 64, 0, 255, 254,
  64, 0, 32, 0, 15, 7, 14, 16, 1, 2, 0, 56, 4, 68, 35, 128,
  64, 0, 255, 254, 64, 0, 32, 0, 15, 9, 18, 16, 1, 254, 32, 0,
  64, 0, 255, 254, 64, 56, 36, 68, 3, 128, 0, 56, 4, 68, 3, 128,
  14, 9, 18, 16, 1, 0, 224, 0, 24, 0, 6, 16, 1, 8, 31, 252,
  1, 8, 6, 16, 24, 0, 224, 0, 14, 11, 22, 16, 1, 255, 252, 0,
  2, 0, 1, 0, 0, 144, 0, 136, 255, 252, 0, 136, 0, 144, 1, 0,
  2, 0, 252, 0, 15, 11, 22, 16, 0, 255, 4, 0, 8, 0, 31, 254,
  32, 0, 127, 254, 128, 0, 127, 254, 32, 0, 31, 254, 8, 0, 4, 0,
  15, 11, 22, 16, 0, 255, 0, 64, 0, 32, 255, 240, 0, 8, 255, 252,
  0, 2, 255, 252, 0, 8, 255, 240, 0, 32, 0, 64, 15, 7, 14, 16,
  0, 2, 3, 128, 68, 64, 56, 8, 0, 4, 255, 254, 0, 4, 0, 8,
  15, 9, 18, 16, 0, 254, 0, 8, 0, 4, 255, 254, 3, 132, 68, 72,
  56, 0, 3, 128, 68, 64, 56, 0, 15, 7, 14, 16, 1, 2, 3, 128,
  4, 68, 32, 56, 64, 0, 255, 254, 64, 0, 32, 0, 15, 9, 18, 16,
  1, 254, 32, 0, 64, 0, 255, 254, 67, 128, 36, 68, 0, 56, 3, 128,
  4, 68, 0, 56, 15, 7, 14, 16, 1, 0, 32, 0, 64, 0, 255, 254,
  64, 0, 32, 56, 4, 68, 3, 128, 15, 7, 14, 16, 0, 0, 0, 8,
  0, 4, 255, 254, 0, 4, 3, 136, 68, 64, 56, 0, 10, 12, 24, 16,
  3, 0, 4, 0, 8, 0, 16, 0, 32, 0, 64, 0, 255, 192, 0, 128,
  1, 0, 2, 0, 20, 0, 24, 0, 28, 0, 4, 6, 6, 8, 2, 0,
  112, 48, 80, 64, 128, 128, 4, 6, 6, 8, 2, 0, 128, 128, 64, 80,
  48, 112, 13, 13, 26, 16, 1, 0, 2, 0, 2, 0, 5, 0, 5, 0,
  248, 248, 64, 16, 32, 32, 16, 64, 8, 128, 16, 64, 34, 32, 77, 144,
  112, 112, 11, 10, 20, 16, 2, 1, 4, 0, 14, 0, 14, 0, 255, 224,
  127, 192, 63, 128, 63, 128, 123, 192, 241, 224, 192, 96, 11, 10, 20, 16,
  2, 1, 4, 0, 10, 0, 10, 0, 241, 224, 64, 64, 32, 128, 36, 128,
  74, 64, 177, 160, 192, 96, 11, 12, 24, 16, 3, 0, 4, 0, 30, 0,
  127, 0, 255, 128, 255, 192, 255, 224, 255, 224, 255, 192, 255, 128, 127, 0,
  30, 0, 4, 0, 11, 12, 24, 16, 3, 0, 4, 0, 26, 0, 97, 0,
  128, 128, 128, 64, 128, 32, 128, 32, 128, 64, 128, 128, 97, 0, 26, 0,
  4, 0
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 8, '1' Height: 12
  Calculated Max Values w=16 h=16 x= 3 y=10 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 8 descent= 0
  X Font      ascent =12 descent= 0
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont_8_9[4279] U8G_FONT_SECTION("u8g_font_unifont_8_9") = {
  0, 16, 16, 0, 254, 8, 4, 67, 6, 64, 0, 255, 0, 14, 254, 12,
  0, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 74, 81, 234, 80, 90, 81, 201, 158, 0, 1, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 6, 14, 14, 8, 1, 0, 72, 72, 0,
  0, 252, 128, 128, 128, 248, 128, 128, 128, 128, 252, 7, 10, 10, 8, 1,
  0, 252, 32, 32, 32, 60, 34, 34, 34, 34, 44, 6, 14, 14, 8, 1,
  0, 24, 96, 0, 0, 252, 128, 128, 128, 128, 128, 128, 128, 128, 128, 6,
  10, 10, 8, 1, 0, 56, 68, 128, 128, 248, 128, 128, 128, 68, 56, 6,
  10, 10, 8, 1, 0, 120, 132, 132, 128, 96, 24, 4, 132, 132, 120, 5,
  10, 10, 8, 2, 0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 248, 5,
  14, 14, 8, 2, 0, 144, 144, 0, 0, 248, 32, 32, 32, 32, 32, 32,
  32, 32, 248, 6, 10, 10, 8, 1, 0, 28, 8, 8, 8, 8, 8, 8,
  136, 136, 112, 8, 10, 10, 8, 0, 0, 120, 72, 72, 72, 78, 73, 73,
  73, 73, 142, 7, 10, 10, 8, 1, 0, 144, 144, 144, 144, 252, 146, 146,
  146, 146, 156, 7, 10, 10, 8, 1, 0, 252, 32, 32, 32, 60, 34, 34,
  34, 34, 34, 6, 14, 14, 8, 1, 0, 24, 96, 0, 0, 128, 140, 144,
  160, 192, 192, 160, 144, 136, 132, 6, 13, 13, 8, 1, 0, 96, 24, 0,
  132, 140, 140, 148, 148, 164, 164, 196, 196, 132, 7, 14, 14, 8, 1, 0,
  132, 132, 120, 0, 130, 130, 68, 68, 40, 40, 16, 16, 32, 96, 7, 12,
  12, 8, 1, 254, 130, 130, 130, 130, 130, 130, 130, 130, 130, 254, 16, 16,
  6, 10, 10, 8, 1, 0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132,
  6, 10, 10, 8, 1, 0, 248, 128, 128, 128, 248, 132, 132, 132, 132, 248,
  6, 10, 10, 8, 1, 0, 248, 132, 132, 132, 248, 132, 132, 132, 132, 248,
  6, 10, 10, 8, 1, 0, 252, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  8, 12, 12, 8, 0, 254, 14, 18, 18, 18, 34, 34, 34, 66, 66, 255,
  129, 129, 6, 10, 10, 8, 1, 0, 252, 128, 128, 128, 248, 128, 128, 128,
  128, 252, 7, 10, 10, 8, 1, 0, 146, 146, 84, 84, 56, 56, 84, 84,
  146, 146, 6, 10, 10, 8, 1, 0, 120, 132, 4, 4, 120, 8, 4, 4,
  132, 120, 6, 10, 10, 8, 1, 0, 132, 140, 140, 148, 148, 164, 164, 196,
  196, 132, 6, 13, 13, 8, 1, 0, 72, 48, 0, 132, 140, 140, 148, 148,
  164, 164, 196, 196, 132, 6, 10, 10, 8, 1, 0, 140, 144, 144, 160, 160,
  192, 160, 144, 136, 132, 6, 10, 10, 8, 1, 0, 60, 36, 36, 36, 36,
  36, 36, 68, 68, 132, 6, 10, 10, 8, 1, 0, 132, 132, 204, 204, 180,
  180, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 132, 132, 132, 132, 252,
  132, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 120, 132, 132, 132, 132,
  132, 132, 132, 132, 120, 6, 10, 10, 8, 1, 0, 252, 132, 132, 132, 132,
  132, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 248, 132, 132, 132, 248,
  128, 128, 128, 128, 128, 6, 10, 10, 8, 1, 0, 120, 132, 132, 128, 128,
  128, 128, 132, 132, 120, 7, 10, 10, 8, 1, 0, 254, 16, 16, 16, 16,
  16, 16, 16, 16, 16, 7, 10, 10, 8, 1, 0, 130, 130, 68, 68, 40,
  40, 16, 16, 32, 96, 7, 11, 11, 8, 1, 0, 16, 124, 146, 146, 146,
  146, 146, 124, 16, 16, 16, 6, 10, 10, 8, 1, 0, 132, 132, 72, 72,
  48, 48, 72, 72, 132, 132, 7, 12, 12, 8, 1, 254, 132, 132, 132, 132,
  132, 132, 132, 132, 132, 254, 2, 2, 6, 10, 10, 8, 1, 0, 132, 132,
  132, 132, 132, 252, 4, 4, 4, 4, 7, 10, 10, 8, 1, 0, 146, 146,
  146, 146, 146, 146, 146, 146, 146, 254, 8, 12, 12, 8, 0, 254, 146, 146,
  146, 146, 146, 146, 146, 146, 146, 255, 1, 1, 7, 10, 10, 8, 1, 0,
  224, 32, 32, 32, 60, 34, 34, 34, 34, 60, 6, 10, 10, 8, 1, 0,
  132, 132, 132, 132, 228, 148, 148, 148, 148, 228, 6, 10, 10, 8, 1, 0,
  128, 128, 128, 128, 248, 132, 132, 132, 132, 248, 6, 10, 10, 8, 1, 0,
  112, 136, 4, 4, 124, 4, 4, 4, 136, 112, 6, 10, 10, 8, 1, 0,
  152, 164, 164, 164, 228, 164, 164, 164, 164, 152, 6, 10, 10, 8, 1, 0,
  124, 132, 132, 132, 124, 36, 68, 68, 132, 132, 6, 8, 8, 8, 1, 0,
  120, 132, 4, 124, 132, 132, 140, 116, 6, 12, 12, 8, 1, 0, 4, 56,
  64, 128, 248, 132, 132, 132, 132, 132, 132, 120, 6, 8, 8, 8, 1, 0,
  248, 132, 132, 248, 132, 132, 132, 248, 6, 8, 8, 8, 1, 0, 252, 128,
  128, 128, 128, 128, 128, 128, 7, 9, 9, 8, 1, 255, 60, 36, 68, 68,
  132, 132, 132, 254, 130, 6, 8, 8, 8, 1, 0, 120, 132, 132, 252, 128,
  128, 132, 120, 7, 8, 8, 8, 1, 0, 146, 146, 84, 56, 56, 84, 146,
  146, 6, 8, 8, 8, 1, 0, 120, 132, 4, 120, 8, 4, 132, 120, 6,
  8, 8, 8, 1, 0, 140, 140, 148, 148, 164, 164, 196, 196, 6, 12, 12,
  8, 1, 0, 72, 48, 0, 0, 140, 140, 148, 148, 164, 164, 196, 196, 6,
  8, 8, 8, 1, 0, 140, 144, 160, 192, 160, 144, 136, 132, 6, 8, 8,
  8, 1, 0, 60, 36, 36, 36, 36, 68, 68, 132, 6, 8, 8, 8, 1,
  0, 132, 204, 204, 180, 180, 132, 132, 132, 6, 8, 8, 8, 1, 0, 132,
  132, 132, 252, 132, 132, 132, 132, 6, 8, 8, 8, 1, 0, 120, 132, 132,
  132, 132, 132, 132, 120, 6, 8, 8, 8, 1, 0, 252, 132, 132, 132, 132,
  132, 132, 132, 6, 10, 10, 8, 1, 254, 184, 196, 132, 132, 132, 132, 196,
  184, 128, 128, 6, 8, 8, 8, 1, 0, 120, 132, 128, 128, 128, 128, 132,
  120, 7, 8, 8, 8, 1, 0, 254, 16, 16, 16, 16, 16, 16, 16, 6,
  10, 10, 8, 1, 254, 132, 132, 72, 72, 48, 48, 32, 32, 64, 192, 7,
  13, 13, 8, 1, 254, 16, 16, 16, 124, 146, 146, 146, 146, 146, 146, 124,
  16, 16, 6, 8, 8, 8, 1, 0, 132, 132, 72, 48, 48, 72, 132, 132,
  7, 10, 10, 8, 1, 254, 132, 132, 132, 132, 132, 132, 132, 254, 2, 2,
  6, 8, 8, 8, 1, 0, 132, 132, 132, 132, 252, 4, 4, 4, 7, 8,
  8, 8, 1, 0, 146, 146, 146, 146, 146, 146, 146, 254, 8, 10, 10, 8,
  0, 254, 146, 146, 146, 146, 146, 146, 146, 255, 1, 1, 7, 8, 8, 8,
  1, 0, 224, 32, 32, 60, 34, 34, 34, 60, 6, 8, 8, 8, 1, 0,
  132, 132, 132, 228, 148, 148, 148, 228, 6, 8, 8, 8, 1, 0, 128, 128,
  128, 248, 132, 132, 132, 248, 6, 8, 8, 8, 1, 0, 112, 136, 4, 124,
  4, 4, 136, 112, 6, 8, 8, 8, 1, 0, 152, 164, 164, 228, 164, 164,
  164, 152, 6, 8, 8, 8, 1, 0, 124, 132, 132, 132, 124, 36, 68, 132,
  6, 12, 12, 8, 1, 0, 96, 24, 0, 0, 120, 132, 132, 252, 128, 128,
  132, 120, 6, 12, 12, 8, 1, 0, 72, 72, 0, 0, 120, 132, 132, 252,
  128, 128, 132, 120, 7, 13, 13, 8, 0, 254, 64, 240, 64, 92, 98, 66,
  66, 66, 66, 66, 66, 2, 12, 6, 12, 12, 8, 1, 0, 24, 96, 0,
  0, 252, 128, 128, 128, 128, 128, 128, 128, 6, 8, 8, 8, 1, 0, 56,
  68, 128, 248, 128, 128, 68, 56, 6, 8, 8, 8, 1, 0, 120, 132, 128,
  96, 24, 4, 132, 120, 5, 11, 11, 8, 2, 0, 32, 32, 0, 96, 32,
  32, 32, 32, 32, 32, 248, 5, 11, 11, 8, 2, 0, 144, 144, 0, 96,
  32, 32, 32, 32, 32, 32, 248, 5, 13, 13, 8, 1, 254, 8, 8, 0,
  24, 8, 8, 8, 8, 8, 8, 8, 144, 96, 8, 8, 8, 8, 0, 0,
  120, 72, 72, 78, 73, 73, 73, 142, 7, 8, 8, 8, 1, 0, 144, 144,
  144, 252, 146, 146, 146, 156, 7, 11, 11, 8, 0, 0, 64, 240, 64, 92,
  98, 66, 66, 66, 66, 66, 66, 6, 12, 12, 8, 1, 0, 24, 96, 0,
  0, 140, 144, 160, 192, 160, 144, 136, 132, 6, 12, 12, 8, 1, 0, 96,
  24, 0, 0, 140, 140, 148, 148, 164, 164, 196, 196, 6, 15, 15, 8, 1,
  254, 132, 132, 120, 0, 0, 132, 132, 72, 72, 48, 48, 32, 32, 64, 192,
  5, 10, 10, 8, 2, 254, 136, 136, 136, 136, 136, 136, 136, 248, 32, 32,
  7, 10, 10, 8, 1, 0, 146, 146, 146, 146, 146, 146, 146, 146, 180, 72,
  7, 8, 8, 8, 1, 0, 68, 130, 130, 146, 146, 146, 146, 108, 7, 10,
  10, 8, 1, 0, 32, 248, 32, 32, 60, 34, 34, 34, 34, 60, 6, 10,
  10, 8, 1, 0, 64, 64, 240, 64, 64, 120, 68, 68, 68, 120, 7, 10,
  10, 8, 1, 0, 140, 146, 160, 160, 252, 160, 160, 160, 146, 140, 7, 8,
  8, 8, 1, 0, 140, 146, 160, 252, 160, 160, 146, 140, 7, 10, 10, 8,
  1, 0, 16, 16, 40, 40, 68, 108, 84, 146, 146, 146, 7, 8, 8, 8,
  1, 0, 16, 40, 40, 68, 108, 146, 146, 146, 7, 10, 10, 8, 1, 0,
  144, 144, 168, 168, 164, 236, 212, 146, 146, 146, 7, 8, 8, 8, 1, 0,
  144, 168, 168, 164, 236, 146, 146, 146, 7, 10, 10, 8, 1, 0, 124, 68,
  68, 40, 16, 56, 84, 146, 146, 146, 7, 8, 8, 8, 1, 0, 124, 68,
  40, 16, 124, 146, 146, 146, 7, 10, 10, 8, 1, 0, 190, 162, 162, 148,
  232, 156, 170, 170, 170, 170, 7, 8, 8, 8, 1, 0, 190, 162, 148, 232,
  156, 170, 170, 170, 6, 14, 14, 8, 1, 254, 72, 48, 120, 132, 4, 4,
  120, 8, 4, 4, 4, 120, 128, 128, 6, 13, 13, 8, 1, 254, 72, 48,
  0, 120, 132, 4, 120, 8, 4, 4, 120, 128, 128, 7, 10, 10, 8, 1,
  0, 146, 146, 146, 146, 146, 124, 16, 16, 16, 16, 7, 8, 8, 8, 1,
  254, 146, 146, 146, 146, 146, 124, 16, 16, 6, 10, 10, 8, 1, 0, 120,
  132, 132, 132, 252, 132, 132, 132, 132, 120, 6, 8, 8, 8, 1, 0, 120,
  132, 132, 252, 132, 132, 132, 120, 7, 10, 10, 8, 1, 0, 134, 136, 136,
  136, 80, 80, 80, 32, 32, 32, 6, 8, 8, 8, 1, 0, 140, 144, 144,
  80, 80, 80, 32, 32, 7, 14, 14, 8, 1, 0, 204, 34, 0, 0, 134,
  136, 136, 136, 80, 80, 80, 32, 32, 32, 7, 12, 12, 8, 1, 0, 204,
  34, 0, 0, 140, 144, 144, 80, 80, 80, 32, 32, 7, 12, 12, 8, 1,
  254, 64, 160, 178, 178, 178, 170, 172, 168, 168, 72, 16, 16, 7, 10, 10,
  8, 1, 254, 82, 178, 178, 170, 172, 168, 168, 72, 16, 16, 7, 12, 12,
  8, 1, 255, 16, 124, 146, 130, 130, 130, 130, 130, 130, 146, 124, 16, 7,
  10, 10, 8, 1, 255, 16, 124, 146, 130, 130, 130, 130, 146, 124, 16, 7,
  14, 14, 8, 1, 0, 120, 134, 48, 8, 16, 0, 108, 130, 130, 146, 146,
  146, 146, 108, 7, 11, 11, 8, 1, 0, 120, 134, 48, 8, 16, 0, 108,
  130, 146, 146, 108, 7, 13, 13, 8, 1, 0, 254, 16, 0, 146, 146, 146,
  146, 146, 146, 146, 146, 180, 72, 7, 10, 10, 8, 1, 0, 254, 16, 0,
  146, 146, 146, 146, 146, 180, 72, 6, 12, 12, 8, 1, 254, 120, 132, 132,
  128, 128, 128, 128, 128, 120, 8, 8, 8, 6, 10, 10, 8, 1, 254, 120,
  132, 132, 128, 128, 128, 120, 8, 8, 8, 7, 7, 7, 8, 1, 1, 36,
  24, 136, 84, 34, 48, 72, 4, 3, 3, 8, 1, 10, 16, 240, 128, 5,
  4, 4, 8, 0, 9, 16, 40, 72, 128, 4, 3, 3, 8, 1, 10, 112,
  128, 96, 4, 3, 3, 8, 2, 10, 224, 16, 96, 8, 3, 3, 8, 0,
  10, 48, 76, 131, 14, 14, 28, 16, 0, 254, 1, 0, 2, 128, 16, 16,
  40, 40, 0, 0, 0, 0, 64, 8, 160, 20, 0, 0, 0, 0, 0, 0,
  16, 16, 41, 40, 2, 128, 14, 14, 28, 16, 1, 254, 1, 0, 33, 8,
  19, 16, 24, 96, 0, 0, 0, 0, 0, 16, 224, 28, 32, 0, 0, 0,
  0, 0, 25, 176, 17, 16, 33, 8, 7, 15, 15, 8, 1, 254, 72, 48,
  0, 132, 140, 140, 148, 148, 164, 164, 196, 196, 134, 4, 8, 7, 14, 14,
  8, 1, 254, 72, 48, 0, 0, 140, 140, 148, 148, 164, 164, 196, 198, 4,
  8, 6, 10, 10, 8, 1, 0, 64, 224, 64, 64, 64, 120, 68, 68, 76,
  120, 6, 7, 7, 8, 1, 0, 64, 224, 64, 120, 68, 68, 120, 6, 10,
  10, 8, 1, 0, 248, 132, 148, 136, 244, 128, 128, 128, 128, 128, 6, 10,
  10, 8, 1, 254, 184, 196, 132, 132, 132, 148, 200, 180, 128, 128, 6, 12,
  12, 8, 1, 0, 4, 4, 252, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  6, 10, 10, 8, 1, 0, 4, 4, 252, 128, 128, 128, 128, 128, 128, 128,
  7, 10, 10, 8, 1, 0, 62, 32, 32, 32, 32, 248, 32, 32, 32, 32,
  7, 8, 8, 8, 1, 0, 62, 32, 32, 32, 248, 32, 32, 32, 6, 11,
  11, 8, 1, 255, 252, 128, 128, 128, 128, 248, 132, 132, 132, 132, 24, 6,
  9, 9, 8, 1, 255, 252, 128, 128, 128, 248, 132, 132, 132, 24, 7, 12,
  12, 8, 1, 254, 146, 146, 84, 84, 56, 56, 84, 84, 146, 146, 2, 2,
  7, 10, 10, 8, 1, 254, 146, 146, 84, 56, 56, 84, 146, 146, 2, 2,
  6, 12, 12, 8, 1, 254, 120, 132, 4, 4, 120, 8, 4, 4, 132, 120,
  16, 96, 6, 10, 10, 8, 1, 254, 120, 132, 4, 120, 8, 4, 132, 120,
  16, 96, 6, 12, 12, 8, 1, 254, 128, 140, 144, 160, 192, 192, 160, 144,
  136, 132, 4, 4, 6, 10, 10, 8, 1, 254, 140, 144, 160, 192, 160, 144,
  136, 132, 4, 4, 7, 10, 10, 8, 1, 0, 128, 134, 168, 168, 240, 168,
  168, 168, 132, 130, 7, 8, 8, 8, 1, 0, 134, 168, 168, 240, 168, 168,
  132, 130, 7, 10, 10, 8, 1, 0, 64, 230, 72, 80, 96, 96, 80, 72,
  68, 66, 7, 8, 8, 8, 1, 0, 70, 232, 80, 96, 80, 72, 68, 66,
  8, 10, 10, 8, 0, 0, 224, 35, 36, 40, 48, 48, 40, 36, 34, 33,
  8, 8, 8, 8, 0, 0, 227, 36, 40, 48, 40, 36, 34, 33, 7, 12,
  12, 8, 1, 254, 132, 132, 132, 132, 252, 132, 132, 132, 132, 134, 2, 2,
  7, 10, 10, 8, 1, 254, 132, 132, 132, 252, 132, 132, 132, 134, 2, 2,
  7, 10, 10, 8, 1, 0, 142, 136, 136, 136, 248, 136, 136, 136, 136, 136,
  7, 8, 8, 8, 1, 0, 142, 136, 136, 248, 136, 136, 136, 136, 7, 12,
  12, 8, 1, 254, 240, 144, 144, 144, 144, 156, 146, 146, 146, 146, 2, 12,
  7, 10, 10, 8, 1, 254, 240, 144, 144, 144, 156, 146, 146, 146, 2, 12,
  6, 12, 12, 8, 1, 255, 64, 152, 164, 164, 164, 164, 164, 164, 164, 88,
  48, 12, 6, 9, 9, 8, 1, 255, 64, 152, 164, 164, 164, 164, 88, 48,
  12, 6, 12, 12, 8, 1, 254, 120, 132, 132, 128, 128, 128, 128, 132, 132,
  120, 32, 24, 6, 10, 10, 8, 1, 254, 120, 132, 132, 128, 128, 132, 132,
  120, 32, 24, 7, 12, 12, 8, 1, 254, 254, 16, 16, 16, 16, 16, 16,
  16, 16, 24, 8, 8, 7, 10, 10, 8, 1, 254, 254, 16, 16, 16, 16,
  16, 16, 24, 8, 8, 7, 10, 10, 8, 1, 0, 130, 130, 68, 68, 40,
  16, 16, 16, 16, 16, 5, 10, 10, 8, 2, 254, 136, 136, 136, 80, 80,
  32, 32, 32, 32, 32, 7, 10, 10, 8, 1, 0, 130, 130, 68, 68, 40,
  16, 16, 124, 16, 16, 5, 8, 8, 8, 2, 0, 136, 136, 136, 80, 32,
  32, 248, 32, 7, 12, 12, 8, 1, 254, 132, 132, 72, 72, 48, 48, 72,
  72, 132, 134, 2, 2, 7, 10, 10, 8, 1, 254, 132, 132, 72, 48, 48,
  72, 132, 134, 2, 2, 8, 12, 12, 8, 0, 254, 250, 34, 34, 34, 34,
  34, 34, 34, 34, 63, 1, 1, 8, 10, 10, 8, 0, 254, 250, 34, 34,
  34, 34, 34, 34, 63, 1, 1, 7, 12, 12, 8, 1, 254, 132, 132, 132,
  132, 132, 140, 116, 4, 4, 6, 2, 2, 7, 10, 10, 8, 1, 254, 132,
  132, 132, 132, 140, 116, 4, 6, 2, 2, 6, 10, 10, 8, 1, 0, 132,
  132, 132, 132, 164, 172, 116, 36, 36, 4, 6, 8, 8, 8, 1, 0, 132,
  132, 132, 164, 172, 116, 36, 4, 6, 10, 10, 8, 1, 0, 128, 128, 128,
  184, 196, 132, 132, 132, 132, 132, 6, 8, 8, 8, 1, 0, 128, 128, 184,
  196, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 152, 164, 164, 164, 124,
  32, 32, 36, 36, 24, 6, 8, 8, 8, 1, 0, 152, 164, 164, 124, 32,
  32, 36, 24, 6, 12, 12, 8, 1, 254, 152, 164, 164, 164, 124, 32, 32,
  36, 36, 24, 16, 16, 6, 12, 12, 8, 1, 254, 152, 164, 164, 164, 124,
  32, 32, 36, 36, 24, 16, 16, 5, 10, 10, 8, 2, 0, 248, 32, 32,
  32, 32, 32, 32, 32, 32, 248, 7, 14, 14, 8, 1, 0, 130, 130, 124,
  0, 146, 146, 84, 84, 56, 56, 84, 84, 146, 146, 7, 13, 13, 8, 1,
  0, 68, 68, 56, 0, 0, 146, 146, 84, 56, 56, 84, 146, 146, 6, 12,
  12, 8, 1, 254, 128, 140, 144, 160, 192, 248, 132, 132, 132, 132, 4, 24,
  6, 10, 10, 8, 1, 254, 140, 144, 160, 192, 248, 132, 132, 132, 4, 24,
  7, 12, 12, 8, 1, 254, 60, 36, 36, 36, 36, 36, 36, 68, 68, 134,
  4, 8, 7, 10, 10, 8, 1, 254, 60, 36, 36, 36, 36, 68, 68, 134,
  4, 8, 6, 12, 12, 8, 1, 254, 132, 132, 132, 132, 252, 132, 132, 132,
  132, 132, 4, 24, 6, 10, 10, 8, 1, 254, 132, 132, 132, 252, 132, 132,
  132, 132, 4, 24, 7, 12, 12, 8, 1, 254, 132, 132, 132, 132, 252, 132,
  132, 132, 132, 134, 4, 8, 7, 10, 10, 8, 1, 254, 132, 132, 132, 252,
  132, 132, 132, 134, 4, 8, 6, 12, 12, 8, 1, 254, 132, 132, 132, 132,
  132, 140, 116, 4, 4, 12, 8, 8, 6, 10, 10, 8, 1, 254, 132, 132,
  132, 132, 140, 116, 4, 12, 8, 8, 7, 12, 12, 8, 1, 254, 132, 132,
  204, 204, 180, 180, 132, 132, 132, 134, 4, 8, 7, 10, 10, 8, 1, 254,
  132, 204, 204, 180, 180, 132, 132, 134, 4, 8, 3, 10, 10, 8, 3, 0,
  224, 64, 64, 64, 64, 64, 64, 64, 64, 224, 6, 14, 14, 8, 1, 0,
  132, 132, 120, 0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132, 6, 13,
  13, 8, 1, 0, 132, 132, 120, 0, 0, 120, 132, 4, 124, 132, 132, 140,
  116, 6, 14, 14, 8, 1, 0, 72, 72, 0, 0, 48, 72, 72, 132, 132,
  252, 132, 132, 132, 132, 6, 12, 12, 8, 1, 0, 72, 72, 0, 0, 120,
  132, 4, 124, 132, 132, 140, 116, 7, 10, 10, 8, 1, 0, 62, 80, 144,
  144, 254, 144, 144, 144, 144, 158, 7, 8, 8, 8, 1, 0, 124, 146, 18,
  126, 144, 144, 146, 124, 6, 14, 14, 8, 1, 0, 132, 132, 120, 0, 252,
  128, 128, 128, 248, 128, 128, 128, 128, 252, 6, 12, 12, 8, 1, 0, 132,
  132, 120, 0, 120, 132, 132, 252, 128, 128, 132, 120, 6, 10, 10, 8, 1,
  0, 48, 72, 132, 4, 4, 252, 132, 132, 72, 48, 6, 8, 8, 8, 1,
  0, 120, 132, 4, 4, 252, 132, 132, 120, 6, 14, 14, 8, 1, 0, 72,
  72, 0, 0, 48, 72, 132, 4, 4, 252, 132, 132, 72, 48, 6, 12, 12,
  8, 1, 0, 72, 72, 0, 0, 120, 132, 4, 4, 252, 132, 132, 120, 7,
  14, 14, 8, 1, 0, 72, 72, 0, 0, 146, 146, 84, 84, 56, 56, 84,
  84, 146, 146, 7, 12, 12, 8, 1, 0, 72, 72, 0, 0, 146, 146, 84,
  56, 56, 84, 146, 146, 6, 14, 14, 8, 1, 0, 72, 72, 0, 0, 120,
  132, 4, 4, 120, 8, 4, 4, 132, 120, 6, 12, 12, 8, 1, 0, 72,
  72, 0, 0, 120, 132, 4, 120, 8, 4, 132, 120, 6, 10, 10, 8, 1,
  0, 252, 8, 16, 32, 56, 4, 4, 4, 140, 120, 6, 10, 10, 8, 1,
  254, 124, 8, 16, 32, 56, 4, 4, 4, 132, 120, 6, 13, 13, 8, 1,
  0, 120, 0, 0, 132, 140, 140, 148, 148, 164, 164, 196, 196, 132, 6, 11,
  11, 8, 1, 0, 120, 0, 0, 140, 140, 148, 148, 164, 164, 196, 196, 6,
  14, 14, 8, 1, 0, 72, 72, 0, 0, 132, 140, 140, 148, 148, 164, 164,
  196, 196, 132, 6, 12, 12, 8, 1, 0, 72, 72, 0, 0, 140, 140, 148,
  148, 164, 164, 196, 196, 6, 14, 14, 8, 1, 0, 72, 72, 0, 0, 120,
  132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 8, 1, 0, 72,
  72, 0, 0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 10, 10, 8, 1,
  0, 120, 132, 132, 132, 252, 132, 132, 132, 132, 120, 6, 8, 8, 8, 1,
  0, 120, 132, 132, 252, 132, 132, 132, 120, 6, 14, 14, 8, 1, 0, 72,
  72, 0, 0, 120, 132, 132, 132, 252, 132, 132, 132, 132, 120, 6, 12, 12,
  8, 1, 0, 72, 72, 0, 0, 120, 132, 132, 252, 132, 132, 132, 120, 6,
  12, 12, 8, 1, 0, 72, 0, 120, 132, 4, 4, 124, 4, 4, 4, 132,
  120, 6, 10, 10, 8, 1, 0, 72, 0, 120, 132, 4, 60, 4, 4, 132,
  120, 7, 13, 13, 8, 1, 0, 124, 0, 0, 130, 130, 68, 68, 40, 40,
  16, 16, 32, 96, 6, 13, 13, 8, 1, 254, 120, 0, 0, 132, 132, 72,
  72, 48, 48, 32, 32, 64, 192, 7, 14, 14, 8, 1, 0, 72, 72, 0,
  0, 130, 130, 68, 68, 40, 40, 16, 16, 32, 96, 6, 14, 14, 8, 1,
  254, 72, 72, 0, 0, 132, 132, 72, 72, 48, 48, 32, 32, 64, 192, 7,
  14, 14, 8, 1, 0, 102, 136, 0, 0, 130, 130, 68, 68, 40, 40, 16,
  16, 32, 96, 7, 14, 14, 8, 1, 254, 102, 136, 0, 0, 132, 132, 72,
  72, 48, 48, 32, 32, 64, 192, 6, 14, 14, 8, 1, 0, 72, 72, 0,
  0, 132, 132, 132, 132, 132, 140, 116, 4, 4, 4, 6, 12, 12, 8, 1,
  0, 72, 72, 0, 0, 132, 132, 132, 132, 140, 116, 4, 4, 6, 12, 12,
  8, 1, 254, 252, 128, 128, 128, 128, 128, 128, 128, 128, 224, 96, 32, 6,
  10, 10, 8, 1, 254, 252, 128, 128, 128, 128, 128, 128, 224, 96, 32, 6,
  14, 14, 8, 1, 0, 72, 72, 0, 0, 132, 132, 132, 132, 228, 148, 148,
  148, 148, 228, 6, 12, 12, 8, 1, 0, 72, 72, 0, 0, 132, 132, 132,
  228, 148, 148, 148, 228, 6, 12, 12, 8, 1, 254, 252, 128, 128, 128, 248,
  128, 128, 128, 128, 192, 64, 192, 5, 10, 10, 8, 1, 254, 248, 128, 128,
  240, 128, 128, 128, 192, 64, 192, 6, 12, 12, 8, 1, 254, 132, 132, 72,
  72, 48, 48, 72, 72, 132, 132, 4, 8, 6, 10, 10, 8, 1, 254, 132,
  132, 72, 48, 48, 72, 132, 132, 4, 8, 6, 10, 10, 8, 1, 0, 132,
  132, 72, 72, 48, 252, 72, 72, 132, 132, 6, 8, 8, 8, 1, 0, 132,
  132, 72, 48, 252, 72, 132, 132
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w=16 h=16 x= 4 y=14 dx=16 dy= 0 ascent=14 len=32
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-2
  X Font      ascent =11 descent=-2
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifont[5551] U8G_FONT_SECTION("u8g_font_unifont") = {
  0, 16, 16, 0, 254, 10, 6, 167, 8, 149, 0, 255, 254, 14, 254, 11,
  254, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 74, 81, 234, 80, 90, 81, 201, 158, 0, 1, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 57, 147, 194, 82, 50, 95, 138, 82, 113,
  147, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 59, 165, 193,
  36, 49, 25, 137, 36, 113, 37, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 123, 165, 193, 36, 121, 25, 193, 36, 121, 37, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 121, 191, 194, 72, 122, 73, 194,
  72, 121, 137, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 122,
  77, 194, 82, 123, 83, 194, 214, 122, 79, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 49, 165, 202, 40, 122, 49, 202, 40, 73, 165, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 115, 209, 202, 16, 115,
  209, 202, 16, 115, 223, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 30, 57, 145, 64, 30, 49, 145, 8, 30, 113, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 34, 249, 162, 32, 62, 33, 162, 32, 34,
  33, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 32, 249, 160,
  128, 32, 249, 160, 128, 62, 129, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 34, 249, 162, 32, 34, 33, 148, 32, 8, 33, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 62, 249, 160, 128, 62, 249, 160,
  128, 32, 129, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 30,
  241, 160, 136, 32, 241, 160, 144, 30, 137, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 30, 113, 160, 136, 28, 137, 130, 136, 60, 113, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 30, 249, 160, 32, 28,
  33, 130, 32, 60, 249, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 57, 29, 165, 16, 37, 29, 165, 16, 57, 221, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 113, 137, 202, 24, 74, 9, 202, 8, 113,
  157, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 113, 153, 202,
  4, 74, 9, 202, 16, 113, 157, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 113, 153, 202, 4, 74, 25, 202, 4, 113, 153, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 113, 133, 202, 12, 74, 21, 202,
  28, 113, 133, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 73,
  147, 234, 84, 106, 89, 219, 212, 74, 83, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 52, 83, 194, 154, 49, 23, 137, 18, 113, 19, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 123, 185, 193, 36, 121,
  57, 193, 36, 121, 57, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 51, 37, 196, 180, 71, 173, 196, 164, 52, 165, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 62, 137, 160, 216, 62, 169, 160, 136, 62,
  137, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 58, 93, 194,
  82, 50, 93, 138, 82, 113, 157, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 121, 207, 194, 16, 121, 145, 192, 80, 123, 143, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 30, 113, 144, 128, 30, 97, 144,
  16, 16, 225, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 14,
  113, 144, 128, 22, 97, 146, 16, 14, 225, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 28, 113, 146, 128, 28, 97, 148, 16, 18, 225, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 18, 113, 146, 128, 18,
  97, 146, 16, 12, 225, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 0, 0, 0, 8, 0, 14, 1, 10, 10, 8, 4, 0, 128, 128, 128,
  128, 128, 128, 128, 0, 128, 128, 5, 4, 4, 8, 2, 8, 136, 136, 136,
  136, 6, 10, 10, 8, 1, 0, 36, 36, 36, 252, 72, 72, 252, 144, 144,
  144, 7, 10, 10, 8, 1, 0, 16, 124, 146, 144, 112, 28, 18, 146, 124,
  16, 7, 10, 10, 8, 1, 0, 98, 148, 148, 104, 16, 16, 44, 82, 82,
  140, 7, 10, 10, 8, 1, 0, 56, 68, 68, 40, 48, 82, 138, 132, 140,
  114, 1, 4, 4, 8, 4, 8, 128, 128, 128, 128, 3, 12, 12, 8, 3,
  255, 32, 64, 64, 128, 128, 128, 128, 128, 128, 64, 64, 32, 3, 12, 12,
  8, 2, 255, 128, 64, 64, 32, 32, 32, 32, 32, 32, 64, 64, 128, 7,
  7, 7, 8, 1, 1, 16, 146, 84, 56, 84, 146, 16, 7, 7, 7, 8,
  1, 1, 16, 16, 16, 254, 16, 16, 16, 2, 4, 4, 8, 3, 254, 192,
  64, 64, 128, 4, 1, 1, 8, 2, 4, 240, 2, 2, 2, 8, 3, 0,
  192, 192, 6, 10, 10, 8, 1, 0, 4, 4, 8, 16, 16, 32, 32, 64,
  128, 128, 6, 10, 10, 8, 1, 0, 48, 72, 132, 132, 132, 132, 132, 132,
  72, 48, 5, 10, 10, 8, 2, 0, 32, 96, 160, 32, 32, 32, 32, 32,
  32, 248, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4, 24, 32, 64, 128,
  128, 252, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4, 56, 4, 4, 132,
  132, 120, 6, 10, 10, 8, 1, 0, 8, 24, 40, 72, 136, 136, 252, 8,
  8, 8, 6, 10, 10, 8, 1, 0, 252, 128, 128, 128, 248, 4, 4, 4,
  132, 120, 6, 10, 10, 8, 1, 0, 56, 64, 128, 128, 248, 132, 132, 132,
  132, 120, 6, 10, 10, 8, 1, 0, 252, 4, 4, 8, 8, 8, 16, 16,
  16, 16, 6, 10, 10, 8, 1, 0, 120, 132, 132, 132, 120, 132, 132, 132,
  132, 120, 6, 10, 10, 8, 1, 0, 120, 132, 132, 132, 124, 4, 4, 4,
  8, 112, 2, 7, 7, 8, 3, 1, 192, 192, 0, 0, 0, 192, 192, 2,
  9, 9, 8, 3, 255, 192, 192, 0, 0, 0, 192, 64, 64, 128, 5, 9,
  9, 8, 2, 0, 8, 16, 32, 64, 128, 64, 32, 16, 8, 6, 5, 5,
  8, 1, 2, 252, 0, 0, 0, 252, 5, 9, 9, 8, 1, 0, 128, 64,
  32, 16, 8, 16, 32, 64, 128, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  4, 8, 16, 16, 0, 16, 16, 6, 10, 10, 8, 1, 0, 56, 68, 148,
  172, 164, 164, 164, 156, 64, 60, 6, 10, 10, 8, 1, 0, 48, 72, 72,
  132, 132, 252, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 248, 132, 132,
  132, 248, 132, 132, 132, 132, 248, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  128, 128, 128, 128, 132, 132, 120, 6, 10, 10, 8, 1, 0, 240, 136, 132,
  132, 132, 132, 132, 132, 136, 240, 6, 10, 10, 8, 1, 0, 252, 128, 128,
  128, 248, 128, 128, 128, 128, 252, 6, 10, 10, 8, 1, 0, 252, 128, 128,
  128, 248, 128, 128, 128, 128, 128, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  128, 128, 156, 132, 132, 140, 116, 6, 10, 10, 8, 1, 0, 132, 132, 132,
  132, 252, 132, 132, 132, 132, 132, 5, 10, 10, 8, 2, 0, 248, 32, 32,
  32, 32, 32, 32, 32, 32, 248, 7, 10, 10, 8, 1, 0, 62, 8, 8,
  8, 8, 8, 8, 136, 136, 112, 6, 10, 10, 8, 1, 0, 132, 136, 144,
  160, 192, 192, 160, 144, 136, 132, 6, 10, 10, 8, 1, 0, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 252, 6, 10, 10, 8, 1, 0, 132, 132, 204,
  204, 180, 180, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 132, 196, 196,
  164, 164, 148, 148, 140, 140, 132, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  132, 132, 132, 132, 132, 132, 120, 6, 10, 10, 8, 1, 0, 248, 132, 132,
  132, 248, 128, 128, 128, 128, 128, 7, 11, 11, 8, 1, 255, 120, 132, 132,
  132, 132, 132, 132, 180, 204, 120, 6, 6, 10, 10, 8, 1, 0, 248, 132,
  132, 132, 248, 144, 136, 136, 132, 132, 6, 10, 10, 8, 1, 0, 120, 132,
  132, 128, 96, 24, 4, 132, 132, 120, 7, 10, 10, 8, 1, 0, 254, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 6, 10, 10, 8, 1, 0, 132, 132,
  132, 132, 132, 132, 132, 132, 132, 120, 7, 10, 10, 8, 1, 0, 130, 130,
  130, 68, 68, 68, 40, 40, 16, 16, 6, 10, 10, 8, 1, 0, 132, 132,
  132, 132, 180, 180, 204, 204, 132, 132, 6, 10, 10, 8, 1, 0, 132, 132,
  72, 72, 48, 48, 72, 72, 132, 132, 7, 10, 10, 8, 1, 0, 130, 130,
  68, 68, 40, 16, 16, 16, 16, 16, 6, 10, 10, 8, 1, 0, 252, 4,
  4, 8, 16, 32, 64, 128, 128, 252, 3, 12, 12, 8, 4, 255, 224, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 224, 6, 10, 10, 8, 1, 0,
  128, 128, 64, 32, 32, 16, 16, 8, 4, 4, 3, 12, 12, 8, 1, 255,
  224, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 224, 6, 3, 3, 8,
  1, 9, 48, 72, 132, 7, 1, 1, 8, 1, 255, 254, 3, 3, 3, 8,
  2, 10, 128, 64, 32, 6, 8, 8, 8, 1, 0, 120, 132, 4, 124, 132,
  132, 140, 116, 6, 11, 11, 8, 1, 0, 128, 128, 128, 184, 196, 132, 132,
  132, 132, 196, 184, 6, 8, 8, 8, 1, 0, 120, 132, 128, 128, 128, 128,
  132, 120, 6, 11, 11, 8, 1, 0, 4, 4, 4, 116, 140, 132, 132, 132,
  132, 140, 116, 6, 8, 8, 8, 1, 0, 120, 132, 132, 252, 128, 128, 132,
  120, 5, 11, 11, 8, 1, 0, 24, 32, 32, 32, 248, 32, 32, 32, 32,
  32, 32, 6, 11, 11, 8, 1, 254, 4, 116, 136, 136, 136, 112, 64, 120,
  132, 132, 120, 6, 11, 11, 8, 1, 0, 128, 128, 128, 184, 196, 132, 132,
  132, 132, 132, 132, 5, 11, 11, 8, 2, 0, 32, 32, 0, 96, 32, 32,
  32, 32, 32, 32, 248, 5, 13, 13, 8, 1, 254, 8, 8, 0, 24, 8,
  8, 8, 8, 8, 8, 8, 144, 96, 6, 11, 11, 8, 1, 0, 128, 128,
  128, 136, 144, 160, 192, 160, 144, 136, 132, 5, 11, 11, 8, 2, 0, 96,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 248, 7, 8, 8, 8, 1, 0,
  236, 146, 146, 146, 146, 146, 146, 146, 6, 8, 8, 8, 1, 0, 184, 196,
  132, 132, 132, 132, 132, 132, 6, 8, 8, 8, 1, 0, 120, 132, 132, 132,
  132, 132, 132, 120, 6, 10, 10, 8, 1, 254, 184, 196, 132, 132, 132, 132,
  196, 184, 128, 128, 6, 10, 10, 8, 1, 254, 116, 140, 132, 132, 132, 132,
  140, 116, 4, 4, 6, 8, 8, 8, 1, 0, 184, 196, 132, 128, 128, 128,
  128, 128, 6, 8, 8, 8, 1, 0, 120, 132, 128, 96, 24, 4, 132, 120,
  5, 10, 10, 8, 1, 0, 32, 32, 32, 248, 32, 32, 32, 32, 32, 24,
  6, 8, 8, 8, 1, 0, 132, 132, 132, 132, 132, 132, 140, 116, 6, 8,
  8, 8, 1, 0, 132, 132, 132, 72, 72, 72, 48, 48, 7, 8, 8, 8,
  1, 0, 130, 146, 146, 146, 146, 146, 146, 108, 6, 8, 8, 8, 1, 0,
  132, 132, 72, 48, 48, 72, 132, 132, 6, 10, 10, 8, 1, 254, 132, 132,
  132, 132, 132, 76, 52, 4, 4, 120, 6, 8, 8, 8, 1, 0, 252, 4,
  8, 16, 32, 64, 128, 252, 3, 12, 12, 8, 3, 255, 96, 128, 128, 64,
  64, 128, 128, 64, 64, 128, 128, 96, 1, 14, 14, 8, 4, 254, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 3, 12, 12, 8,
  2, 255, 192, 32, 32, 64, 64, 32, 32, 64, 64, 32, 32, 192, 7, 3,
  3, 8, 1, 8, 98, 146, 140, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 115, 209, 202, 16, 75, 209, 202, 16, 115,
  223, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 113, 157, 202,
  82, 115, 211, 194, 82, 66, 93, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 73, 157, 202, 82, 122, 93, 202, 80, 73, 145, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 115, 147, 202, 82, 115, 159, 202,
  18, 114, 19, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 75,
  147, 234, 82, 91, 159, 202, 82, 75, 147, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 116, 185, 166, 164, 37, 165, 164, 164, 116, 185, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 75, 209, 234, 16, 91,
  209, 202, 16, 75, 223, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 57, 205, 194, 18, 49, 159, 136, 82, 115, 147, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 121, 205, 194, 18, 121, 159, 192, 82, 123,
  147, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 75, 157, 201,
  32, 121, 25, 201, 4, 73, 57, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 37, 221, 164, 132, 60, 133, 164, 132, 36, 153, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 69, 205, 196, 144, 68, 137, 168,
  132, 16, 153, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 114,
  29, 202, 18, 114, 19, 194, 18, 67, 221, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 114, 19, 202, 18, 114, 19, 194, 18, 67, 205, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 14, 33, 137, 32, 14,
  33, 138, 32, 9, 33, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 57, 221, 194, 2, 49, 141, 136, 80, 115, 159, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 57, 221, 194, 2, 49, 141, 136, 66, 115,
  157, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 113, 207, 202,
  16, 74, 13, 202, 2, 113, 221, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 114, 69, 202, 76, 114, 69, 194, 68, 65, 143, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 114, 93, 202, 66, 114, 77, 194,
  80, 65, 159, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 59,
  157, 193, 32, 49, 25, 137, 4, 113, 57, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 57, 211, 194, 18, 66, 31, 194, 18, 57, 211, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 34, 137, 182, 136, 42,
  169, 162, 216, 34, 137, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 59, 141, 194, 82, 51, 159, 138, 18, 114, 19, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 123, 141, 194, 82, 123, 159, 194, 18, 122,
  19, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32,
  16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 57, 143, 194,
  80, 50, 77, 138, 66, 113, 157, 128, 0, 0, 1, 128, 0, 0, 1, 128,
  0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0,
  1, 128, 0, 51, 155, 196, 34, 37, 163, 148, 162, 99, 155, 128, 0, 0,
  1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170,
  170, 0, 1, 128, 0, 0, 1, 128, 0, 57, 221, 194, 8, 50, 9, 138,
  8, 113, 221, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 57,
  221, 194, 8, 65, 137, 192, 72, 59, 157, 128, 0, 0, 1, 128, 0, 0,
  1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128,
  0, 0, 1, 128, 0, 14, 249, 144, 32, 12, 33, 130, 32, 28, 33, 128,
  0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0,
  254, 170, 170, 0, 1, 128, 0, 0, 1, 128, 0, 49, 207, 202, 16, 73,
  145, 200, 80, 51, 143, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85,
  85, 16, 16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 0, 1, 128,
  0, 28, 137, 146, 216, 28, 169, 144, 136, 16, 137, 128, 0, 0, 1, 128,
  0, 0, 1, 128, 0, 85, 85, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 51, 143, 202, 80, 123, 145, 202, 16, 74,
  15, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85, 0, 0, 0,
  8, 0, 14, 1, 10, 10, 8, 4, 0, 128, 128, 0, 128, 128, 128, 128,
  128, 128, 128, 7, 10, 10, 8, 1, 0, 16, 16, 124, 146, 144, 144, 146,
  124, 16, 16, 7, 10, 10, 8, 1, 0, 28, 32, 32, 32, 248, 32, 32,
  32, 124, 194, 6, 8, 8, 8, 1, 1, 132, 72, 120, 72, 72, 120, 72,
  132, 7, 10, 10, 8, 1, 0, 130, 68, 40, 16, 254, 16, 254, 16, 16,
  16, 1, 10, 10, 8, 4, 0, 128, 128, 128, 128, 0, 0, 128, 128, 128,
  128, 6, 10, 10, 8, 1, 0, 120, 132, 128, 120, 132, 132, 120, 4, 132,
  120, 4, 2, 2, 8, 2, 12, 144, 144, 8, 10, 10, 8, 0, 0, 60,
  66, 153, 165, 161, 161, 165, 153, 66, 60, 5, 7, 7, 8, 2, 5, 112,
  8, 120, 136, 120, 0, 248, 6, 9, 9, 8, 1, 0, 36, 36, 72, 72,
  144, 72, 72, 36, 36, 6, 4, 4, 8, 1, 0, 252, 4, 4, 4, 16,
  16, 32, 16, 0, 254, 170, 170, 0, 1, 128, 0, 58, 99, 194, 84, 51,
  201, 138, 72, 114, 73, 128, 0, 0, 1, 128, 0, 3, 193, 128, 0, 0,
  1, 128, 0, 85, 85, 8, 10, 10, 8, 0, 0, 60, 66, 185, 165, 165,
  185, 169, 165, 66, 60, 6, 1, 1, 8, 1, 11, 252, 3, 4, 4, 8,
  2, 10, 64, 160, 160, 64, 7, 9, 9, 8, 1, 1, 16, 16, 16, 254,
  16, 16, 16, 0, 254, 5, 7, 7, 8, 2, 5, 112, 136, 8, 112, 128,
  128, 248, 5, 7, 7, 8, 2, 5, 112, 136, 8, 112, 8, 136, 112, 3,
  3, 3, 8, 3, 10, 32, 64, 128, 8, 10, 10, 8, 0, 254, 66, 66,
  66, 66, 66, 66, 102, 89, 64, 128, 6, 12, 12, 8, 1, 255, 124, 244,
  244, 244, 244, 116, 20, 20, 20, 20, 20, 28, 2, 2, 2, 8, 3, 4,
  192, 192, 3, 2, 2, 8, 2, 254, 32, 192, 3, 7, 7, 8, 2, 5,
  32, 96, 160, 32, 32, 32, 32, 5, 7, 7, 8, 2, 5, 112, 136, 136,
  136, 112, 0, 248, 6, 9, 9, 8, 1, 0, 144, 144, 72, 72, 36, 72,
  72, 144, 144, 6, 10, 10, 8, 1, 0, 68, 196, 72, 80, 80, 36, 44,
  84, 156, 132, 6, 10, 10, 8, 1, 0, 68, 196, 72, 80, 80, 40, 52,
  68, 136, 156, 6, 10, 10, 8, 1, 0, 196, 36, 72, 48, 208, 36, 44,
  84, 156, 132, 6, 10, 10, 8, 1, 0, 16, 16, 0, 16, 16, 96, 132,
  132, 132, 120, 6, 14, 14, 8, 1, 0, 96, 24, 0, 0, 48, 72, 72,
  132, 132, 252, 132, 132, 132, 132, 6, 14, 14, 8, 1, 0, 24, 96, 0,
  0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132, 6, 14, 14, 8, 1,
  0, 48, 72, 0, 0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132, 6,
  14, 14, 8, 1, 0, 100, 152, 0, 0, 48, 72, 72, 132, 132, 252, 132,
  132, 132, 132, 6, 14, 14, 8, 1, 0, 72, 72, 0, 0, 48, 72, 72,
  132, 132, 252, 132, 132, 132, 132, 6, 14, 14, 8, 1, 0, 48, 72, 48,
  0, 48, 72, 72, 132, 132, 252, 132, 132, 132, 132, 7, 10, 10, 8, 1,
  0, 62, 80, 144, 144, 254, 144, 144, 144, 144, 158, 6, 12, 12, 8, 1,
  254, 120, 132, 132, 128, 128, 128, 128, 132, 132, 120, 16, 96, 6, 14, 14,
  8, 1, 0, 96, 24, 0, 0, 252, 128, 128, 128, 248, 128, 128, 128, 128,
  252, 6, 14, 14, 8, 1, 0, 24, 96, 0, 0, 252, 128, 128, 128, 248,
  128, 128, 128, 128, 252, 6, 14, 14, 8, 1, 0, 48, 72, 0, 0, 252,
  128, 128, 128, 248, 128, 128, 128, 128, 252, 6, 14, 14, 8, 1, 0, 72,
  72, 0, 0, 252, 128, 128, 128, 248, 128, 128, 128, 128, 252, 5, 14, 14,
  8, 2, 0, 96, 24, 0, 0, 248, 32, 32, 32, 32, 32, 32, 32, 32,
  248, 5, 14, 14, 8, 2, 0, 48, 192, 0, 0, 248, 32, 32, 32, 32,
  32, 32, 32, 32, 248, 5, 14, 14, 8, 2, 0, 96, 144, 0, 0, 248,
  32, 32, 32, 32, 32, 32, 32, 32, 248, 5, 14, 14, 8, 2, 0, 144,
  144, 0, 0, 248, 32, 32, 32, 32, 32, 32, 32, 32, 248, 7, 10, 10,
  8, 0, 0, 120, 68, 66, 66, 242, 66, 66, 66, 68, 120, 6, 14, 14,
  8, 1, 0, 100, 152, 0, 0, 132, 196, 196, 164, 164, 148, 148, 140, 140,
  132, 6, 14, 14, 8, 1, 0, 96, 24, 0, 0, 120, 132, 132, 132, 132,
  132, 132, 132, 132, 120, 6, 14, 14, 8, 1, 0, 24, 96, 0, 0, 120,
  132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 14, 14, 8, 1, 0, 48,
  72, 0, 0, 120, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 14, 14,
  8, 1, 0, 100, 152, 0, 0, 120, 132, 132, 132, 132, 132, 132, 132, 132,
  120, 6, 14, 14, 8, 1, 0, 72, 72, 0, 0, 120, 132, 132, 132, 132,
  132, 132, 132, 132, 120, 6, 5, 5, 8, 1, 2, 132, 72, 48, 72, 132,
  6, 12, 12, 8, 1, 255, 4, 116, 136, 140, 148, 148, 164, 164, 196, 68,
  184, 128, 6, 14, 14, 8, 1, 0, 96, 24, 0, 0, 132, 132, 132, 132,
  132, 132, 132, 132, 132, 120, 6, 14, 14, 8, 1, 0, 24, 96, 0, 0,
  132, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 14, 14, 8, 1, 0,
  48, 72, 0, 0, 132, 132, 132, 132, 132, 132, 132, 132, 132, 120, 6, 14,
  14, 8, 1, 0, 72, 72, 0, 0, 132, 132, 132, 132, 132, 132, 132, 132,
  132, 120, 7, 14, 14, 8, 1, 0, 24, 96, 0, 0, 130, 130, 68, 68,
  40, 16, 16, 16, 16, 16, 6, 11, 11, 8, 1, 0, 128, 128, 240, 136,
  132, 132, 136, 240, 128, 128, 128, 6, 10, 10, 8, 1, 0, 112, 136, 136,
  144, 176, 136, 132, 132, 164, 152, 6, 12, 12, 8, 1, 0, 96, 24, 0,
  0, 120, 132, 4, 124, 132, 132, 140, 116, 6, 12, 12, 8, 1, 0, 24,
  96, 0, 0, 120, 132, 4, 124, 132, 132, 140, 116, 6, 12, 12, 8, 1,
  0, 48, 72, 0, 0, 120, 132, 4, 124, 132, 132, 140, 116, 6, 12, 12,
  8, 1, 0, 100, 152, 0, 0, 120, 132, 4, 124, 132, 132, 140, 116, 6,
  12, 12, 8, 1, 0, 72, 72, 0, 0, 120, 132, 4, 124, 132, 132, 140,
  116, 6, 13, 13, 8, 1, 0, 48, 72, 48, 0, 0, 120, 132, 4, 124,
  132, 132, 140, 116, 7, 8, 8, 8, 1, 0, 124, 146, 18, 126, 144, 144,
  146, 124, 6, 10, 10, 8, 1, 254, 120, 132, 128, 128, 128, 128, 132, 120,
  16, 96, 6, 12, 12, 8, 1, 0, 96, 24, 0, 0, 120, 132, 132, 252,
  128, 128, 132, 120, 6, 12, 12, 8, 1, 0, 24, 96, 0, 0, 120, 132,
  132, 252, 128, 128, 132, 120, 6, 12, 12, 8, 1, 0, 48, 72, 0, 0,
  120, 132, 132, 252, 128, 128, 132, 120, 6, 12, 12, 8, 1, 0, 72, 72,
  0, 0, 120, 132, 132, 252, 128, 128, 132, 120, 5, 12, 12, 8, 2, 0,
  192, 48, 0, 0, 96, 32, 32, 32, 32, 32, 32, 248, 5, 12, 12, 8,
  2, 0, 48, 192, 0, 0, 96, 32, 32, 32, 32, 32, 32, 248, 5, 12,
  12, 8, 2, 0, 96, 144, 0, 0, 96, 32, 32, 32, 32, 32, 32, 248,
  5, 12, 12, 8, 2, 0, 144, 144, 0, 0, 96, 32, 32, 32, 32, 32,
  32, 248, 6, 12, 12, 8, 1, 0, 100, 24, 40, 68, 4, 124, 132, 132,
  132, 132, 132, 120, 6, 12, 12, 8, 1, 0, 100, 152, 0, 0, 184, 196,
  132, 132, 132, 132, 132, 132, 6, 12, 12, 8, 1, 0, 96, 24, 0, 0,
  120, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 8, 1, 0, 24, 96,
  0, 0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 8, 1, 0,
  48, 72, 0, 0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 8,
  1, 0, 100, 152, 0, 0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 12,
  12, 8, 1, 0, 72, 72, 0, 0, 120, 132, 132, 132, 132, 132, 132, 120,
  6, 7, 7, 8, 1, 1, 48, 0, 0, 252, 0, 0, 48, 6, 10, 10,
  8, 1, 255, 4, 120, 140, 148, 148, 164, 164, 196, 120, 128, 6, 12, 12,
  8, 1, 0, 96, 24, 0, 0, 132, 132, 132, 132, 132, 132, 140, 116, 6,
  12, 12, 8, 1, 0, 24, 96, 0, 0, 132, 132, 132, 132, 132, 132, 140,
  116, 6, 12, 12, 8, 1, 0, 48, 72, 0, 0, 132, 132, 132, 132, 132,
  132, 140, 116, 6, 12, 12, 8, 1, 0, 72, 72, 0, 0, 132, 132, 132,
  132, 132, 132, 140, 116, 6, 14, 14, 8, 1, 254, 24, 96, 0, 0, 132,
  132, 132, 132, 132, 76, 52, 4, 4, 120, 5, 12, 12, 8, 2, 254, 128,
  128, 240, 136, 136, 136, 144, 160, 192, 128, 128, 128, 6, 14, 14, 8, 1,
  254, 72, 72, 0, 0, 132, 132, 132, 132, 132, 76, 52, 4, 4, 120
};

/*
  Fontname: -gnu-Unifont-Medium-R-Normal-Sans-16-160-75-75-c-80-iso10646-1
  Copyright: Copyright (C) 2014 Roman Czyborra, Paul Hardy, Qianqian Fang, Andrew Miller, et al. Licensed under the GNU General Public License; either version 2, or (at your option) a later version, with the GNU Font Embedding Exception.
  Capital A Height: 10, '1' Height: 10
  Calculated Max Values w=16 h=16 x= 4 y=14 dx=16 dy= 0 ascent=14 len=14
  Font Bounding box     w=16 h=16 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =10 descent=-2
  X Font      ascent =11 descent=-2
  Max Font    ascent =14 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_unifontr[1485] U8G_FONT_SECTION("u8g_font_unifontr") = {
  0, 16, 16, 0, 254, 10, 1, 231, 3, 213, 32, 127, 254, 14, 254, 11,
  254, 0, 0, 0, 8, 0, 14, 1, 10, 10, 8, 4, 0, 128, 128, 128,
  128, 128, 128, 128, 0, 128, 128, 5, 4, 4, 8, 2, 8, 136, 136, 136,
  136, 6, 10, 10, 8, 1, 0, 36, 36, 36, 252, 72, 72, 252, 144, 144,
  144, 7, 10, 10, 8, 1, 0, 16, 124, 146, 144, 112, 28, 18, 146, 124,
  16, 7, 10, 10, 8, 1, 0, 98, 148, 148, 104, 16, 16, 44, 82, 82,
  140, 7, 10, 10, 8, 1, 0, 56, 68, 68, 40, 48, 82, 138, 132, 140,
  114, 1, 4, 4, 8, 4, 8, 128, 128, 128, 128, 3, 12, 12, 8, 3,
  255, 32, 64, 64, 128, 128, 128, 128, 128, 128, 64, 64, 32, 3, 12, 12,
  8, 2, 255, 128, 64, 64, 32, 32, 32, 32, 32, 32, 64, 64, 128, 7,
  7, 7, 8, 1, 1, 16, 146, 84, 56, 84, 146, 16, 7, 7, 7, 8,
  1, 1, 16, 16, 16, 254, 16, 16, 16, 2, 4, 4, 8, 3, 254, 192,
  64, 64, 128, 4, 1, 1, 8, 2, 4, 240, 2, 2, 2, 8, 3, 0,
  192, 192, 6, 10, 10, 8, 1, 0, 4, 4, 8, 16, 16, 32, 32, 64,
  128, 128, 6, 10, 10, 8, 1, 0, 48, 72, 132, 132, 132, 132, 132, 132,
  72, 48, 5, 10, 10, 8, 2, 0, 32, 96, 160, 32, 32, 32, 32, 32,
  32, 248, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4, 24, 32, 64, 128,
  128, 252, 6, 10, 10, 8, 1, 0, 120, 132, 132, 4, 56, 4, 4, 132,
  132, 120, 6, 10, 10, 8, 1, 0, 8, 24, 40, 72, 136, 136, 252, 8,
  8, 8, 6, 10, 10, 8, 1, 0, 252, 128, 128, 128, 248, 4, 4, 4,
  132, 120, 6, 10, 10, 8, 1, 0, 56, 64, 128, 128, 248, 132, 132, 132,
  132, 120, 6, 10, 10, 8, 1, 0, 252, 4, 4, 8, 8, 8, 16, 16,
  16, 16, 6, 10, 10, 8, 1, 0, 120, 132, 132, 132, 120, 132, 132, 132,
  132, 120, 6, 10, 10, 8, 1, 0, 120, 132, 132, 132, 124, 4, 4, 4,
  8, 112, 2, 7, 7, 8, 3, 1, 192, 192, 0, 0, 0, 192, 192, 2,
  9, 9, 8, 3, 255, 192, 192, 0, 0, 0, 192, 64, 64, 128, 5, 9,
  9, 8, 2, 0, 8, 16, 32, 64, 128, 64, 32, 16, 8, 6, 5, 5,
  8, 1, 2, 252, 0, 0, 0, 252, 5, 9, 9, 8, 1, 0, 128, 64,
  32, 16, 8, 16, 32, 64, 128, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  4, 8, 16, 16, 0, 16, 16, 6, 10, 10, 8, 1, 0, 56, 68, 148,
  172, 164, 164, 164, 156, 64, 60, 6, 10, 10, 8, 1, 0, 48, 72, 72,
  132, 132, 252, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 248, 132, 132,
  132, 248, 132, 132, 132, 132, 248, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  128, 128, 128, 128, 132, 132, 120, 6, 10, 10, 8, 1, 0, 240, 136, 132,
  132, 132, 132, 132, 132, 136, 240, 6, 10, 10, 8, 1, 0, 252, 128, 128,
  128, 248, 128, 128, 128, 128, 252, 6, 10, 10, 8, 1, 0, 252, 128, 128,
  128, 248, 128, 128, 128, 128, 128, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  128, 128, 156, 132, 132, 140, 116, 6, 10, 10, 8, 1, 0, 132, 132, 132,
  132, 252, 132, 132, 132, 132, 132, 5, 10, 10, 8, 2, 0, 248, 32, 32,
  32, 32, 32, 32, 32, 32, 248, 7, 10, 10, 8, 1, 0, 62, 8, 8,
  8, 8, 8, 8, 136, 136, 112, 6, 10, 10, 8, 1, 0, 132, 136, 144,
  160, 192, 192, 160, 144, 136, 132, 6, 10, 10, 8, 1, 0, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 252, 6, 10, 10, 8, 1, 0, 132, 132, 204,
  204, 180, 180, 132, 132, 132, 132, 6, 10, 10, 8, 1, 0, 132, 196, 196,
  164, 164, 148, 148, 140, 140, 132, 6, 10, 10, 8, 1, 0, 120, 132, 132,
  132, 132, 132, 132, 132, 132, 120, 6, 10, 10, 8, 1, 0, 248, 132, 132,
  132, 248, 128, 128, 128, 128, 128, 7, 11, 11, 8, 1, 255, 120, 132, 132,
  132, 132, 132, 132, 180, 204, 120, 6, 6, 10, 10, 8, 1, 0, 248, 132,
  132, 132, 248, 144, 136, 136, 132, 132, 6, 10, 10, 8, 1, 0, 120, 132,
  132, 128, 96, 24, 4, 132, 132, 120, 7, 10, 10, 8, 1, 0, 254, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 6, 10, 10, 8, 1, 0, 132, 132,
  132, 132, 132, 132, 132, 132, 132, 120, 7, 10, 10, 8, 1, 0, 130, 130,
  130, 68, 68, 68, 40, 40, 16, 16, 6, 10, 10, 8, 1, 0, 132, 132,
  132, 132, 180, 180, 204, 204, 132, 132, 6, 10, 10, 8, 1, 0, 132, 132,
  72, 72, 48, 48, 72, 72, 132, 132, 7, 10, 10, 8, 1, 0, 130, 130,
  68, 68, 40, 16, 16, 16, 16, 16, 6, 10, 10, 8, 1, 0, 252, 4,
  4, 8, 16, 32, 64, 128, 128, 252, 3, 12, 12, 8, 4, 255, 224, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 224, 6, 10, 10, 8, 1, 0,
  128, 128, 64, 32, 32, 16, 16, 8, 4, 4, 3, 12, 12, 8, 1, 255,
  224, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 224, 6, 3, 3, 8,
  1, 9, 48, 72, 132, 7, 1, 1, 8, 1, 255, 254, 3, 3, 3, 8,
  2, 10, 128, 64, 32, 6, 8, 8, 8, 1, 0, 120, 132, 4, 124, 132,
  132, 140, 116, 6, 11, 11, 8, 1, 0, 128, 128, 128, 184, 196, 132, 132,
  132, 132, 196, 184, 6, 8, 8, 8, 1, 0, 120, 132, 128, 128, 128, 128,
  132, 120, 6, 11, 11, 8, 1, 0, 4, 4, 4, 116, 140, 132, 132, 132,
  132, 140, 116, 6, 8, 8, 8, 1, 0, 120, 132, 132, 252, 128, 128, 132,
  120, 5, 11, 11, 8, 1, 0, 24, 32, 32, 32, 248, 32, 32, 32, 32,
  32, 32, 6, 11, 11, 8, 1, 254, 4, 116, 136, 136, 136, 112, 64, 120,
  132, 132, 120, 6, 11, 11, 8, 1, 0, 128, 128, 128, 184, 196, 132, 132,
  132, 132, 132, 132, 5, 11, 11, 8, 2, 0, 32, 32, 0, 96, 32, 32,
  32, 32, 32, 32, 248, 5, 13, 13, 8, 1, 254, 8, 8, 0, 24, 8,
  8, 8, 8, 8, 8, 8, 144, 96, 6, 11, 11, 8, 1, 0, 128, 128,
  128, 136, 144, 160, 192, 160, 144, 136, 132, 5, 11, 11, 8, 2, 0, 96,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 248, 7, 8, 8, 8, 1, 0,
  236, 146, 146, 146, 146, 146, 146, 146, 6, 8, 8, 8, 1, 0, 184, 196,
  132, 132, 132, 132, 132, 132, 6, 8, 8, 8, 1, 0, 120, 132, 132, 132,
  132, 132, 132, 120, 6, 10, 10, 8, 1, 254, 184, 196, 132, 132, 132, 132,
  196, 184, 128, 128, 6, 10, 10, 8, 1, 254, 116, 140, 132, 132, 132, 132,
  140, 116, 4, 4, 6, 8, 8, 8, 1, 0, 184, 196, 132, 128, 128, 128,
  128, 128, 6, 8, 8, 8, 1, 0, 120, 132, 128, 96, 24, 4, 132, 120,
  5, 10, 10, 8, 1, 0, 32, 32, 32, 248, 32, 32, 32, 32, 32, 24,
  6, 8, 8, 8, 1, 0, 132, 132, 132, 132, 132, 132, 140, 116, 6, 8,
  8, 8, 1, 0, 132, 132, 132, 72, 72, 72, 48, 48, 7, 8, 8, 8,
  1, 0, 130, 146, 146, 146, 146, 146, 146, 108, 6, 8, 8, 8, 1, 0,
  132, 132, 72, 48, 48, 72, 132, 132, 6, 10, 10, 8, 1, 254, 132, 132,
  132, 132, 132, 76, 52, 4, 4, 120, 6, 8, 8, 8, 1, 0, 252, 4,
  8, 16, 32, 64, 128, 252, 3, 12, 12, 8, 3, 255, 96, 128, 128, 64,
  64, 128, 128, 64, 64, 128, 128, 96, 1, 14, 14, 8, 4, 254, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 3, 12, 12, 8,
  2, 255, 192, 32, 32, 64, 64, 32, 32, 64, 64, 32, 32, 192, 7, 3,
  3, 8, 1, 8, 98, 146, 140, 16, 16, 32, 16, 0, 254, 170, 170, 0,
  1, 128, 0, 0, 1, 128, 0, 115, 209, 202, 16, 75, 209, 202, 16, 115,
  223, 128, 0, 0, 1, 128, 0, 0, 1, 128, 0, 85, 85
};
