/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

/**
 * u8g_font_data_helvetica.c
 */

#include "u8g.h"

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--11-80-100-100-P-60-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 8, '1' Height: 8
  Calculated Max Values w=10 h=11 x= 1 y= 7 dx=11 dy= 0 ascent=11 len=18
  Font Bounding box     w=12 h=19 x=-1 y=-5
  Calculated Min Values           x=-1 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 8 descent=-2
  X Font      ascent = 8 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_helvB08[2677] U8G_FONT_SECTION("u8g_font_helvB08") = {
  0, 12, 19, 255, 251, 8, 1, 182, 3, 122, 32, 255, 254, 11, 254, 8,
  254, 0, 0, 0, 3, 0, 1, 2, 8, 8, 4, 1, 0, 192, 192, 192,
  192, 128, 128, 0, 192, 3, 3, 3, 5, 1, 5, 160, 160, 160, 7, 7,
  7, 6, 255, 0, 40, 40, 126, 40, 252, 80, 80, 5, 10, 10, 6, 0,
  255, 32, 112, 168, 224, 112, 56, 40, 168, 112, 32, 7, 8, 8, 8, 0,
  0, 98, 180, 104, 16, 16, 44, 86, 140, 7, 8, 8, 8, 0, 0, 112,
  216, 216, 112, 222, 204, 220, 118, 1, 3, 3, 3, 1, 5, 128, 128, 128,
  3, 10, 10, 4, 0, 254, 32, 96, 64, 192, 192, 192, 192, 64, 96, 32,
  3, 10, 10, 4, 0, 254, 128, 192, 64, 96, 96, 96, 96, 64, 192, 128,
  3, 3, 3, 4, 0, 5, 160, 64, 160, 6, 5, 5, 6, 0, 1, 48,
  48, 252, 48, 48, 2, 4, 4, 3, 0, 254, 192, 192, 64, 128, 4, 1,
  1, 5, 0, 3, 240, 2, 2, 2, 3, 0, 0, 192, 192, 4, 8, 8,
  4, 0, 0, 16, 16, 32, 32, 64, 64, 128, 128, 5, 8, 8, 6, 0,
  0, 112, 216, 216, 216, 216, 216, 216, 112, 3, 8, 8, 6, 1, 0, 96,
  224, 96, 96, 96, 96, 96, 96, 5, 8, 8, 6, 0, 0, 112, 216, 24,
  24, 48, 96, 192, 248, 5, 8, 8, 6, 0, 0, 112, 216, 24, 48, 24,
  24, 216, 112, 6, 8, 8, 6, 0, 0, 8, 24, 56, 88, 152, 252, 24,
  24, 5, 8, 8, 6, 0, 0, 248, 192, 192, 240, 24, 152, 216, 112, 5,
  8, 8, 6, 0, 0, 112, 216, 192, 240, 216, 216, 216, 112, 5, 8, 8,
  6, 0, 0, 248, 24, 24, 48, 48, 96, 96, 96, 5, 8, 8, 6, 0,
  0, 112, 216, 216, 112, 216, 216, 216, 112, 5, 8, 8, 6, 0, 0, 112,
  216, 216, 216, 120, 24, 216, 112, 2, 6, 6, 3, 0, 0, 192, 192, 0,
  0, 192, 192, 2, 8, 8, 3, 0, 254, 192, 192, 0, 0, 192, 192, 64,
  128, 4, 5, 5, 5, 0, 1, 48, 96, 192, 96, 48, 5, 3, 3, 6,
  0, 2, 248, 0, 248, 4, 5, 5, 5, 0, 1, 192, 96, 48, 96, 192,
  5, 8, 8, 6, 0, 0, 112, 216, 24, 48, 96, 96, 0, 96, 10, 9,
  18, 11, 0, 255, 31, 0, 96, 128, 77, 64, 146, 64, 162, 64, 164, 128,
  155, 0, 64, 0, 62, 0, 7, 8, 8, 8, 0, 0, 56, 56, 108, 108,
  108, 254, 198, 198, 6, 8, 8, 7, 0, 0, 248, 204, 204, 248, 204, 204,
  204, 248, 7, 8, 8, 8, 0, 0, 60, 102, 194, 192, 192, 194, 102, 60,
  6, 8, 8, 7, 0, 0, 240, 216, 204, 204, 204, 204, 216, 240, 5, 8,
  8, 6, 0, 0, 248, 192, 192, 248, 192, 192, 192, 248, 5, 8, 8, 6,
  0, 0, 248, 192, 192, 240, 192, 192, 192, 192, 7, 8, 8, 8, 0, 0,
  60, 102, 194, 192, 206, 198, 102, 58, 6, 8, 8, 7, 0, 0, 204, 204,
  204, 252, 204, 204, 204, 204, 2, 8, 8, 3, 0, 0, 192, 192, 192, 192,
  192, 192, 192, 192, 5, 8, 8, 6, 0, 0, 24, 24, 24, 24, 24, 24,
  216, 112, 7, 8, 8, 7, 0, 0, 204, 216, 240, 224, 240, 216, 204, 198,
  5, 8, 8, 6, 0, 0, 192, 192, 192, 192, 192, 192, 192, 248, 9, 8,
  16, 10, 0, 0, 193, 128, 227, 128, 227, 128, 247, 128, 213, 128, 221, 128,
  201, 128, 201, 128, 7, 8, 8, 8, 0, 0, 198, 230, 230, 214, 214, 206,
  206, 198, 7, 8, 8, 8, 0, 0, 56, 108, 198, 198, 198, 198, 108, 56,
  6, 8, 8, 7, 0, 0, 248, 204, 204, 204, 248, 192, 192, 192, 7, 9,
  9, 8, 0, 255, 56, 108, 198, 198, 198, 214, 108, 60, 2, 6, 8, 8,
  7, 0, 0, 248, 204, 204, 204, 248, 204, 204, 204, 6, 8, 8, 7, 0,
  0, 120, 204, 224, 120, 28, 140, 204, 120, 6, 8, 8, 7, 0, 0, 252,
  48, 48, 48, 48, 48, 48, 48, 6, 8, 8, 7, 0, 0, 204, 204, 204,
  204, 204, 204, 204, 120, 7, 8, 8, 8, 0, 0, 198, 198, 108, 108, 108,
  56, 56, 16, 10, 8, 16, 11, 0, 0, 204, 192, 204, 192, 204, 192, 109,
  128, 109, 128, 127, 128, 51, 0, 51, 0, 7, 8, 8, 8, 0, 0, 198,
  198, 108, 56, 56, 108, 198, 198, 8, 8, 8, 9, 0, 0, 195, 195, 102,
  102, 60, 24, 24, 24, 6, 8, 8, 7, 0, 0, 252, 12, 24, 48, 112,
  96, 192, 252, 3, 10, 10, 4, 0, 254, 224, 192, 192, 192, 192, 192, 192,
  192, 192, 224, 4, 8, 8, 4, 0, 0, 128, 128, 64, 64, 32, 32, 16,
  16, 3, 10, 10, 4, 0, 254, 224, 96, 96, 96, 96, 96, 96, 96, 96,
  224, 4, 4, 4, 5, 0, 4, 96, 240, 144, 144, 6, 1, 1, 6, 0,
  254, 252, 2, 2, 2, 3, 0, 7, 128, 64, 6, 6, 6, 6, 0, 0,
  112, 152, 120, 216, 216, 108, 5, 8, 8, 6, 0, 0, 192, 192, 240, 216,
  216, 216, 216, 240, 4, 6, 6, 5, 0, 0, 112, 208, 192, 192, 208, 112,
  5, 8, 8, 6, 0, 0, 24, 24, 120, 216, 216, 216, 216, 120, 5, 6,
  6, 6, 0, 0, 112, 216, 248, 192, 216, 112, 5, 8, 8, 4, 255, 0,
  56, 96, 240, 96, 96, 96, 96, 96, 5, 8, 8, 6, 0, 254, 104, 216,
  216, 216, 216, 120, 24, 112, 5, 8, 8, 6, 0, 0, 192, 192, 240, 216,
  216, 216, 216, 216, 2, 8, 8, 3, 0, 0, 192, 0, 192, 192, 192, 192,
  192, 192, 3, 10, 10, 3, 255, 254, 96, 0, 96, 96, 96, 96, 96, 96,
  96, 192, 6, 8, 8, 6, 0, 0, 192, 192, 216, 240, 224, 240, 216, 204,
  2, 8, 8, 3, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 8, 6,
  6, 9, 0, 0, 182, 219, 219, 219, 219, 219, 5, 6, 6, 6, 0, 0,
  176, 216, 216, 216, 216, 216, 5, 6, 6, 6, 0, 0, 112, 216, 216, 216,
  216, 112, 5, 8, 8, 6, 0, 254, 176, 216, 216, 216, 216, 240, 192, 192,
  5, 8, 8, 6, 0, 254, 104, 216, 216, 216, 216, 120, 24, 24, 4, 6,
  6, 4, 0, 0, 176, 224, 192, 192, 192, 192, 5, 6, 6, 6, 0, 0,
  112, 216, 112, 24, 216, 112, 4, 8, 8, 4, 255, 0, 96, 96, 240, 96,
  96, 96, 96, 48, 5, 6, 6, 6, 0, 0, 216, 216, 216, 216, 216, 104,
  5, 6, 6, 6, 0, 0, 216, 216, 216, 80, 112, 32, 7, 6, 6, 8,
  0, 0, 214, 214, 214, 108, 108, 108, 6, 6, 6, 7, 0, 0, 204, 120,
  48, 120, 204, 204, 5, 8, 8, 6, 0, 254, 216, 216, 216, 216, 120, 48,
  48, 96, 5, 6, 6, 6, 0, 0, 248, 24, 48, 96, 192, 248, 4, 10,
  10, 5, 0, 254, 48, 96, 96, 96, 192, 96, 96, 96, 96, 48, 1, 10,
  10, 3, 1, 254, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 4, 10,
  10, 5, 0, 254, 192, 96, 96, 96, 48, 96, 96, 96, 96, 192, 5, 2,
  2, 6, 0, 3, 104, 176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 3, 0, 1, 2, 8, 8,
  4, 1, 254, 192, 0, 64, 64, 192, 192, 192, 192, 5, 8, 8, 6, 0,
  255, 16, 112, 216, 160, 160, 216, 112, 64, 5, 8, 8, 6, 0, 0, 56,
  104, 96, 240, 96, 96, 104, 216, 6, 6, 6, 6, 0, 1, 132, 120, 72,
  72, 120, 132, 6, 8, 8, 7, 0, 0, 132, 132, 204, 72, 252, 48, 252,
  48, 1, 10, 10, 3, 1, 254, 128, 128, 128, 128, 0, 0, 128, 128, 128,
  128, 5, 10, 10, 6, 0, 254, 112, 200, 224, 112, 152, 200, 112, 56, 152,
  112, 3, 1, 1, 3, 0, 7, 160, 8, 8, 8, 10, 1, 0, 60, 66,
  153, 165, 161, 157, 66, 60, 3, 5, 5, 5, 1, 3, 224, 32, 160, 0,
  224, 6, 3, 3, 7, 0, 1, 108, 216, 108, 5, 3, 3, 7, 1, 2,
  248, 8, 8, 4, 1, 1, 5, 0, 3, 240, 8, 8, 8, 10, 1, 0,
  60, 66, 189, 165, 185, 165, 66, 60, 3, 1, 1, 3, 0, 7, 224, 3,
  3, 3, 4, 0, 5, 96, 160, 192, 6, 7, 7, 6, 0, 0, 48, 48,
  252, 48, 48, 0, 252, 3, 4, 4, 3, 0, 4, 96, 160, 64, 224, 3,
  4, 4, 3, 0, 4, 224, 64, 32, 192, 2, 2, 2, 3, 0, 7, 64,
  128, 5, 8, 8, 6, 0, 254, 216, 216, 216, 216, 216, 232, 192, 192, 6,
  10, 10, 6, 0, 254, 124, 232, 232, 232, 104, 40, 40, 40, 40, 40, 2,
  1, 1, 3, 0, 3, 192, 2, 2, 2, 3, 0, 254, 64, 192, 2, 4,
  4, 3, 0, 4, 64, 192, 64, 64, 3, 5, 5, 5, 1, 3, 224, 160,
  224, 0, 224, 6, 3, 3, 7, 0, 1, 216, 108, 216, 8, 8, 8, 9,
  0, 0, 68, 196, 72, 72, 18, 38, 47, 66, 7, 8, 8, 9, 0, 0,
  68, 196, 72, 72, 22, 42, 36, 78, 8, 8, 8, 9, 0, 0, 228, 68,
  40, 200, 18, 38, 47, 66, 5, 8, 8, 6, 0, 254, 48, 0, 48, 48,
  96, 192, 216, 112, 7, 11, 11, 8, 0, 0, 32, 16, 0, 56, 56, 108,
  108, 108, 254, 198, 198, 7, 11, 11, 8, 0, 0, 8, 16, 0, 56, 56,
  108, 108, 108, 254, 198, 198, 7, 11, 11, 8, 0, 0, 16, 40, 0, 56,
  56, 108, 108, 108, 254, 198, 198, 7, 11, 11, 8, 0, 0, 20, 40, 0,
  56, 56, 108, 108, 108, 254, 198, 198, 7, 10, 10, 8, 0, 0, 40, 0,
  56, 56, 108, 108, 108, 254, 198, 198, 7, 11, 11, 8, 0, 0, 16, 40,
  16, 56, 56, 108, 108, 108, 254, 198, 198, 9, 8, 16, 10, 0, 0, 63,
  128, 60, 0, 108, 0, 111, 128, 108, 0, 252, 0, 204, 0, 207, 128, 7,
  10, 10, 8, 0, 254, 60, 102, 194, 192, 192, 194, 102, 60, 16, 48, 5,
  11, 11, 6, 0, 0, 64, 32, 0, 248, 192, 192, 248, 192, 192, 192, 248,
  5, 11, 11, 6, 0, 0, 16, 32, 0, 248, 192, 192, 248, 192, 192, 192,
  248, 5, 11, 11, 6, 0, 0, 32, 80, 0, 248, 192, 192, 248, 192, 192,
  192, 248, 5, 10, 10, 6, 0, 0, 80, 0, 248, 192, 192, 248, 192, 192,
  192, 248, 2, 11, 11, 3, 0, 0, 128, 64, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 2, 11, 11, 3, 0, 0, 64, 128, 0, 192, 192, 192, 192,
  192, 192, 192, 192, 3, 11, 11, 3, 255, 0, 64, 160, 0, 96, 96, 96,
  96, 96, 96, 96, 96, 4, 10, 10, 3, 255, 0, 144, 0, 96, 96, 96,
  96, 96, 96, 96, 96, 7, 8, 8, 7, 255, 0, 120, 108, 102, 246, 102,
  102, 108, 120, 7, 11, 11, 8, 0, 0, 20, 40, 0, 198, 230, 230, 214,
  214, 206, 206, 198, 7, 11, 11, 8, 0, 0, 16, 8, 0, 56, 108, 198,
  198, 198, 198, 108, 56, 7, 11, 11, 8, 0, 0, 8, 16, 0, 56, 108,
  198, 198, 198, 198, 108, 56, 7, 11, 11, 8, 0, 0, 16, 40, 0, 56,
  108, 198, 198, 198, 198, 108, 56, 7, 11, 11, 8, 0, 0, 20, 40, 0,
  56, 108, 198, 198, 198, 198, 108, 56, 7, 10, 10, 8, 0, 0, 40, 0,
  56, 108, 198, 198, 198, 198, 108, 56, 6, 5, 5, 6, 0, 1, 204, 120,
  48, 120, 204, 7, 8, 8, 8, 0, 0, 58, 108, 206, 214, 214, 230, 108,
  184, 6, 11, 11, 7, 0, 0, 32, 16, 0, 204, 204, 204, 204, 204, 204,
  204, 120, 6, 11, 11, 7, 0, 0, 8, 16, 0, 204, 204, 204, 204, 204,
  204, 204, 120, 6, 11, 11, 7, 0, 0, 32, 80, 0, 204, 204, 204, 204,
  204, 204, 204, 120, 6, 10, 10, 7, 0, 0, 72, 0, 204, 204, 204, 204,
  204, 204, 204, 120, 8, 11, 11, 9, 0, 0, 4, 8, 0, 195, 195, 102,
  102, 60, 24, 24, 24, 6, 8, 8, 7, 0, 0, 192, 248, 204, 204, 204,
  248, 192, 192, 5, 8, 8, 6, 0, 0, 112, 200, 200, 208, 200, 200, 200,
  208, 6, 9, 9, 6, 0, 0, 32, 16, 0, 112, 152, 120, 216, 216, 108,
  6, 9, 9, 6, 0, 0, 16, 32, 0, 112, 152, 120, 216, 216, 108, 6,
  9, 9, 6, 0, 0, 32, 80, 0, 112, 152, 120, 216, 216, 108, 6, 9,
  9, 6, 0, 0, 40, 80, 0, 112, 152, 120, 216, 216, 108, 6, 8, 8,
  6, 0, 0, 80, 0, 112, 152, 120, 216, 216, 108, 6, 9, 9, 6, 0,
  0, 32, 80, 32, 112, 152, 120, 216, 216, 108, 8, 6, 6, 9, 0, 0,
  126, 155, 127, 216, 219, 110, 4, 8, 8, 5, 0, 254, 112, 208, 192, 192,
  208, 112, 32, 96, 5, 9, 9, 6, 0, 0, 64, 32, 0, 112, 216, 248,
  192, 216, 112, 5, 9, 9, 6, 0, 0, 16, 32, 0, 112, 216, 248, 192,
  216, 112, 5, 9, 9, 6, 0, 0, 32, 80, 0, 112, 216, 248, 192, 216,
  112, 5, 8, 8, 6, 0, 0, 80, 0, 112, 216, 248, 192, 216, 112, 2,
  9, 9, 3, 0, 0, 128, 64, 0, 192, 192, 192, 192, 192, 192, 2, 9,
  9, 3, 0, 0, 64, 128, 0, 192, 192, 192, 192, 192, 192, 3, 9, 9,
  3, 0, 0, 64, 160, 0, 192, 192, 192, 192, 192, 192, 3, 8, 8, 3,
  0, 0, 160, 0, 192, 192, 192, 192, 192, 192, 5, 9, 9, 6, 0, 0,
  80, 96, 160, 112, 216, 216, 216, 216, 112, 5, 9, 9, 6, 0, 0, 80,
  160, 0, 176, 216, 216, 216, 216, 216, 5, 9, 9, 6, 0, 0, 64, 32,
  0, 112, 216, 216, 216, 216, 112, 5, 9, 9, 6, 0, 0, 16, 32, 0,
  112, 216, 216, 216, 216, 112, 5, 9, 9, 6, 0, 0, 32, 80, 0, 112,
  216, 216, 216, 216, 112, 5, 9, 9, 6, 0, 0, 80, 160, 0, 112, 216,
  216, 216, 216, 112, 5, 8, 8, 6, 0, 0, 80, 0, 112, 216, 216, 216,
  216, 112, 6, 5, 5, 6, 0, 1, 48, 0, 252, 0, 48, 7, 6, 6,
  6, 255, 0, 58, 108, 124, 108, 108, 184, 5, 9, 9, 6, 0, 0, 64,
  32, 0, 216, 216, 216, 216, 216, 104, 5, 9, 9, 6, 0, 0, 16, 32,
  0, 216, 216, 216, 216, 216, 104, 5, 9, 9, 6, 0, 0, 32, 80, 0,
  216, 216, 216, 216, 216, 104, 5, 8, 8, 6, 0, 0, 80, 0, 216, 216,
  216, 216, 216, 104, 5, 11, 11, 6, 0, 254, 16, 32, 0, 216, 216, 216,
  216, 120, 48, 48, 96, 5, 10, 10, 6, 0, 254, 192, 192, 240, 216, 200,
  200, 216, 240, 192, 192, 5, 10, 10, 6, 0, 254, 80, 0, 216, 216, 216,
  216, 120, 48, 48, 96
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--11-80-100-100-P-60-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 0, '1' Height: 8
  Calculated Max Values w= 6 h= 8 x= 1 y= 5 dx= 6 dy= 0 ascent= 8 len= 8
  Font Bounding box     w=12 h=19 x=-1 y=-5
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 8 descent= 0
  X Font      ascent = 8 descent= 0
  Max Font    ascent = 8 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_helvB08n[228] U8G_FONT_SECTION("u8g_font_helvB08n") = {
  0, 12, 19, 255, 251, 8, 0, 0, 0, 0, 42, 58, 0, 8, 254, 8,
  0, 3, 3, 3, 4, 0, 5, 160, 64, 160, 6, 5, 5, 6, 0, 1,
  48, 48, 252, 48, 48, 2, 4, 4, 3, 0, 254, 192, 192, 64, 128, 4,
  1, 1, 5, 0, 3, 240, 2, 2, 2, 3, 0, 0, 192, 192, 4, 8,
  8, 4, 0, 0, 16, 16, 32, 32, 64, 64, 128, 128, 5, 8, 8, 6,
  0, 0, 112, 216, 216, 216, 216, 216, 216, 112, 3, 8, 8, 6, 1, 0,
  96, 224, 96, 96, 96, 96, 96, 96, 5, 8, 8, 6, 0, 0, 112, 216,
  24, 24, 48, 96, 192, 248, 5, 8, 8, 6, 0, 0, 112, 216, 24, 48,
  24, 24, 216, 112, 6, 8, 8, 6, 0, 0, 8, 24, 56, 88, 152, 252,
  24, 24, 5, 8, 8, 6, 0, 0, 248, 192, 192, 240, 24, 152, 216, 112,
  5, 8, 8, 6, 0, 0, 112, 216, 192, 240, 216, 216, 216, 112, 5, 8,
  8, 6, 0, 0, 248, 24, 24, 48, 48, 96, 96, 96, 5, 8, 8, 6,
  0, 0, 112, 216, 216, 112, 216, 216, 216, 112, 5, 8, 8, 6, 0, 0,
  112, 216, 216, 216, 120, 24, 216, 112, 2, 6, 6, 3, 0, 0, 192, 192,
  0, 0, 192, 192
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--11-80-100-100-P-60-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 8, '1' Height: 8
  Calculated Max Values w=10 h=10 x= 1 y= 7 dx=11 dy= 0 ascent= 9 len=18
  Font Bounding box     w=12 h=19 x=-1 y=-5
  Calculated Min Values           x=-1 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 8 descent=-2
  X Font      ascent = 8 descent=-2
  Max Font    ascent = 9 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_helvB08r[1287] U8G_FONT_SECTION("u8g_font_helvB08r") = {
  0, 12, 19, 255, 251, 8, 1, 182, 3, 122, 32, 127, 254, 9, 254, 8,
  254, 0, 0, 0, 3, 0, 1, 2, 8, 8, 4, 1, 0, 192, 192, 192,
  192, 128, 128, 0, 192, 3, 3, 3, 5, 1, 5, 160, 160, 160, 7, 7,
  7, 6, 255, 0, 40, 40, 126, 40, 252, 80, 80, 5, 10, 10, 6, 0,
  255, 32, 112, 168, 224, 112, 56, 40, 168, 112, 32, 7, 8, 8, 8, 0,
  0, 98, 180, 104, 16, 16, 44, 86, 140, 7, 8, 8, 8, 0, 0, 112,
  216, 216, 112, 222, 204, 220, 118, 1, 3, 3, 3, 1, 5, 128, 128, 128,
  3, 10, 10, 4, 0, 254, 32, 96, 64, 192, 192, 192, 192, 64, 96, 32,
  3, 10, 10, 4, 0, 254, 128, 192, 64, 96, 96, 96, 96, 64, 192, 128,
  3, 3, 3, 4, 0, 5, 160, 64, 160, 6, 5, 5, 6, 0, 1, 48,
  48, 252, 48, 48, 2, 4, 4, 3, 0, 254, 192, 192, 64, 128, 4, 1,
  1, 5, 0, 3, 240, 2, 2, 2, 3, 0, 0, 192, 192, 4, 8, 8,
  4, 0, 0, 16, 16, 32, 32, 64, 64, 128, 128, 5, 8, 8, 6, 0,
  0, 112, 216, 216, 216, 216, 216, 216, 112, 3, 8, 8, 6, 1, 0, 96,
  224, 96, 96, 96, 96, 96, 96, 5, 8, 8, 6, 0, 0, 112, 216, 24,
  24, 48, 96, 192, 248, 5, 8, 8, 6, 0, 0, 112, 216, 24, 48, 24,
  24, 216, 112, 6, 8, 8, 6, 0, 0, 8, 24, 56, 88, 152, 252, 24,
  24, 5, 8, 8, 6, 0, 0, 248, 192, 192, 240, 24, 152, 216, 112, 5,
  8, 8, 6, 0, 0, 112, 216, 192, 240, 216, 216, 216, 112, 5, 8, 8,
  6, 0, 0, 248, 24, 24, 48, 48, 96, 96, 96, 5, 8, 8, 6, 0,
  0, 112, 216, 216, 112, 216, 216, 216, 112, 5, 8, 8, 6, 0, 0, 112,
  216, 216, 216, 120, 24, 216, 112, 2, 6, 6, 3, 0, 0, 192, 192, 0,
  0, 192, 192, 2, 8, 8, 3, 0, 254, 192, 192, 0, 0, 192, 192, 64,
  128, 4, 5, 5, 5, 0, 1, 48, 96, 192, 96, 48, 5, 3, 3, 6,
  0, 2, 248, 0, 248, 4, 5, 5, 5, 0, 1, 192, 96, 48, 96, 192,
  5, 8, 8, 6, 0, 0, 112, 216, 24, 48, 96, 96, 0, 96, 10, 9,
  18, 11, 0, 255, 31, 0, 96, 128, 77, 64, 146, 64, 162, 64, 164, 128,
  155, 0, 64, 0, 62, 0, 7, 8, 8, 8, 0, 0, 56, 56, 108, 108,
  108, 254, 198, 198, 6, 8, 8, 7, 0, 0, 248, 204, 204, 248, 204, 204,
  204, 248, 7, 8, 8, 8, 0, 0, 60, 102, 194, 192, 192, 194, 102, 60,
  6, 8, 8, 7, 0, 0, 240, 216, 204, 204, 204, 204, 216, 240, 5, 8,
  8, 6, 0, 0, 248, 192, 192, 248, 192, 192, 192, 248, 5, 8, 8, 6,
  0, 0, 248, 192, 192, 240, 192, 192, 192, 192, 7, 8, 8, 8, 0, 0,
  60, 102, 194, 192, 206, 198, 102, 58, 6, 8, 8, 7, 0, 0, 204, 204,
  204, 252, 204, 204, 204, 204, 2, 8, 8, 3, 0, 0, 192, 192, 192, 192,
  192, 192, 192, 192, 5, 8, 8, 6, 0, 0, 24, 24, 24, 24, 24, 24,
  216, 112, 7, 8, 8, 7, 0, 0, 204, 216, 240, 224, 240, 216, 204, 198,
  5, 8, 8, 6, 0, 0, 192, 192, 192, 192, 192, 192, 192, 248, 9, 8,
  16, 10, 0, 0, 193, 128, 227, 128, 227, 128, 247, 128, 213, 128, 221, 128,
  201, 128, 201, 128, 7, 8, 8, 8, 0, 0, 198, 230, 230, 214, 214, 206,
  206, 198, 7, 8, 8, 8, 0, 0, 56, 108, 198, 198, 198, 198, 108, 56,
  6, 8, 8, 7, 0, 0, 248, 204, 204, 204, 248, 192, 192, 192, 7, 9,
  9, 8, 0, 255, 56, 108, 198, 198, 198, 214, 108, 60, 2, 6, 8, 8,
  7, 0, 0, 248, 204, 204, 204, 248, 204, 204, 204, 6, 8, 8, 7, 0,
  0, 120, 204, 224, 120, 28, 140, 204, 120, 6, 8, 8, 7, 0, 0, 252,
  48, 48, 48, 48, 48, 48, 48, 6, 8, 8, 7, 0, 0, 204, 204, 204,
  204, 204, 204, 204, 120, 7, 8, 8, 8, 0, 0, 198, 198, 108, 108, 108,
  56, 56, 16, 10, 8, 16, 11, 0, 0, 204, 192, 204, 192, 204, 192, 109,
  128, 109, 128, 127, 128, 51, 0, 51, 0, 7, 8, 8, 8, 0, 0, 198,
  198, 108, 56, 56, 108, 198, 198, 8, 8, 8, 9, 0, 0, 195, 195, 102,
  102, 60, 24, 24, 24, 6, 8, 8, 7, 0, 0, 252, 12, 24, 48, 112,
  96, 192, 252, 3, 10, 10, 4, 0, 254, 224, 192, 192, 192, 192, 192, 192,
  192, 192, 224, 4, 8, 8, 4, 0, 0, 128, 128, 64, 64, 32, 32, 16,
  16, 3, 10, 10, 4, 0, 254, 224, 96, 96, 96, 96, 96, 96, 96, 96,
  224, 4, 4, 4, 5, 0, 4, 96, 240, 144, 144, 6, 1, 1, 6, 0,
  254, 252, 2, 2, 2, 3, 0, 7, 128, 64, 6, 6, 6, 6, 0, 0,
  112, 152, 120, 216, 216, 108, 5, 8, 8, 6, 0, 0, 192, 192, 240, 216,
  216, 216, 216, 240, 4, 6, 6, 5, 0, 0, 112, 208, 192, 192, 208, 112,
  5, 8, 8, 6, 0, 0, 24, 24, 120, 216, 216, 216, 216, 120, 5, 6,
  6, 6, 0, 0, 112, 216, 248, 192, 216, 112, 5, 8, 8, 4, 255, 0,
  56, 96, 240, 96, 96, 96, 96, 96, 5, 8, 8, 6, 0, 254, 104, 216,
  216, 216, 216, 120, 24, 112, 5, 8, 8, 6, 0, 0, 192, 192, 240, 216,
  216, 216, 216, 216, 2, 8, 8, 3, 0, 0, 192, 0, 192, 192, 192, 192,
  192, 192, 3, 10, 10, 3, 255, 254, 96, 0, 96, 96, 96, 96, 96, 96,
  96, 192, 6, 8, 8, 6, 0, 0, 192, 192, 216, 240, 224, 240, 216, 204,
  2, 8, 8, 3, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 8, 6,
  6, 9, 0, 0, 182, 219, 219, 219, 219, 219, 5, 6, 6, 6, 0, 0,
  176, 216, 216, 216, 216, 216, 5, 6, 6, 6, 0, 0, 112, 216, 216, 216,
  216, 112, 5, 8, 8, 6, 0, 254, 176, 216, 216, 216, 216, 240, 192, 192,
  5, 8, 8, 6, 0, 254, 104, 216, 216, 216, 216, 120, 24, 24, 4, 6,
  6, 4, 0, 0, 176, 224, 192, 192, 192, 192, 5, 6, 6, 6, 0, 0,
  112, 216, 112, 24, 216, 112, 4, 8, 8, 4, 255, 0, 96, 96, 240, 96,
  96, 96, 96, 48, 5, 6, 6, 6, 0, 0, 216, 216, 216, 216, 216, 104,
  5, 6, 6, 6, 0, 0, 216, 216, 216, 80, 112, 32, 7, 6, 6, 8,
  0, 0, 214, 214, 214, 108, 108, 108, 6, 6, 6, 7, 0, 0, 204, 120,
  48, 120, 204, 204, 5, 8, 8, 6, 0, 254, 216, 216, 216, 216, 120, 48,
  48, 96, 5, 6, 6, 6, 0, 0, 248, 24, 48, 96, 192, 248, 4, 10,
  10, 5, 0, 254, 48, 96, 96, 96, 192, 96, 96, 96, 96, 48, 1, 10,
  10, 3, 1, 254, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 4, 10,
  10, 5, 0, 254, 192, 96, 96, 96, 48, 96, 96, 96, 96, 192, 5, 2,
  2, 6, 0, 3, 104, 176, 255
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--14-100-100-100-P-82-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 11, '1' Height: 11
  Calculated Max Values w=14 h=14 x= 2 y= 9 dx=15 dy= 0 ascent=14 len=28
  Font Bounding box     w=17 h=23 x=-1 y=-6
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =11 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =14 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_helvB10[3692] U8G_FONT_SECTION("u8g_font_helvB10") = {
  0, 17, 23, 255, 250, 11, 2, 27, 4, 205, 32, 255, 253, 14, 253, 11,
  253, 0, 0, 0, 4, 0, 1, 2, 11, 11, 4, 1, 0, 192, 192, 192,
  192, 192, 192, 128, 128, 0, 192, 192, 5, 3, 3, 7, 1, 8, 216, 216,
  144, 9, 10, 20, 9, 0, 0, 27, 0, 27, 0, 27, 0, 127, 128, 54,
  0, 54, 0, 255, 0, 108, 0, 108, 0, 108, 0, 7, 14, 14, 8, 0,
  254, 16, 124, 214, 214, 208, 240, 120, 28, 22, 214, 214, 124, 16, 16, 12,
  11, 22, 13, 0, 0, 120, 64, 204, 192, 205, 128, 121, 0, 3, 0, 6,
  0, 4, 0, 13, 224, 11, 48, 27, 48, 17, 224, 9, 10, 20, 11, 1,
  0, 56, 0, 108, 0, 108, 0, 56, 0, 115, 0, 251, 0, 206, 0, 198,
  0, 207, 0, 125, 128, 2, 3, 3, 4, 1, 8, 192, 192, 128, 4, 14,
  14, 5, 1, 253, 48, 96, 96, 192, 192, 192, 192, 192, 192, 192, 192, 96,
  96, 48, 4, 14, 14, 5, 0, 253, 192, 96, 96, 48, 48, 48, 48, 48,
  48, 48, 48, 96, 96, 192, 5, 4, 4, 6, 0, 7, 32, 248, 112, 216,
  8, 7, 7, 9, 0, 1, 24, 24, 24, 255, 24, 24, 24, 3, 3, 3,
  4, 0, 255, 96, 96, 192, 3, 1, 1, 4, 0, 4, 224, 2, 2, 2,
  4, 1, 0, 192, 192, 4, 11, 11, 4, 0, 0, 16, 16, 48, 32, 32,
  96, 64, 64, 192, 128, 128, 7, 11, 11, 8, 0, 0, 56, 108, 198, 198,
  198, 198, 198, 198, 198, 108, 56, 4, 11, 11, 8, 1, 0, 48, 240, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 7, 11, 11, 8, 0, 0, 124, 198,
  198, 6, 14, 12, 24, 48, 96, 192, 254, 7, 11, 11, 8, 0, 0, 124,
  198, 198, 6, 6, 60, 6, 6, 198, 198, 124, 8, 11, 11, 8, 0, 0,
  6, 14, 30, 54, 102, 198, 198, 255, 6, 6, 6, 7, 11, 11, 8, 0,
  0, 126, 96, 96, 192, 252, 14, 6, 6, 198, 204, 120, 7, 11, 11, 8,
  0, 0, 60, 102, 102, 192, 220, 230, 198, 198, 198, 198, 124, 7, 11, 11,
  8, 0, 0, 254, 6, 12, 12, 24, 24, 48, 48, 96, 96, 96, 7, 11,
  11, 8, 0, 0, 124, 198, 198, 198, 198, 124, 198, 198, 198, 198, 124, 7,
  11, 11, 8, 0, 0, 124, 198, 198, 198, 198, 198, 126, 6, 198, 204, 120,
  2, 8, 8, 5, 2, 0, 192, 192, 0, 0, 0, 0, 192, 192, 3, 9,
  9, 5, 1, 255, 96, 96, 0, 0, 0, 0, 96, 96, 192, 6, 5, 5,
  8, 1, 2, 28, 112, 192, 112, 28, 7, 3, 3, 9, 1, 3, 254, 0,
  254, 6, 5, 5, 8, 1, 2, 224, 56, 12, 56, 224, 7, 11, 11, 9,
  1, 0, 124, 198, 198, 6, 12, 24, 48, 48, 0, 48, 48, 13, 12, 24,
  14, 0, 255, 15, 128, 56, 224, 112, 112, 102, 176, 205, 152, 217, 152, 219,
  24, 219, 48, 206, 224, 96, 0, 49, 128, 31, 0, 10, 11, 22, 10, 0,
  0, 12, 0, 12, 0, 30, 0, 18, 0, 51, 0, 51, 0, 97, 128, 127,
  128, 97, 128, 192, 192, 192, 192, 8, 11, 11, 10, 1, 0, 254, 199, 195,
  195, 198, 252, 198, 195, 195, 199, 254, 9, 11, 22, 11, 1, 0, 31, 0,
  123, 128, 96, 128, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 96, 128,
  123, 128, 31, 0, 9, 11, 22, 11, 1, 0, 252, 0, 199, 0, 195, 0,
  193, 128, 193, 128, 193, 128, 193, 128, 193, 128, 195, 0, 199, 0, 252, 0,
  7, 11, 11, 9, 1, 0, 254, 192, 192, 192, 192, 254, 192, 192, 192, 192,
  254, 7, 11, 11, 9, 1, 0, 254, 192, 192, 192, 192, 252, 192, 192, 192,
  192, 192, 9, 11, 22, 11, 1, 0, 31, 0, 123, 128, 96, 128, 192, 0,
  192, 0, 199, 128, 193, 128, 193, 128, 97, 128, 123, 128, 30, 128, 8, 11,
  11, 10, 1, 0, 195, 195, 195, 195, 195, 255, 195, 195, 195, 195, 195, 2,
  11, 11, 4, 1, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  7, 11, 11, 8, 0, 0, 6, 6, 6, 6, 6, 6, 6, 198, 198, 238,
  124, 9, 11, 22, 10, 1, 0, 195, 0, 198, 0, 204, 0, 216, 0, 240,
  0, 240, 0, 216, 0, 204, 0, 198, 0, 195, 0, 193, 128, 7, 11, 11,
  8, 1, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 254, 11, 11,
  22, 13, 1, 0, 192, 96, 192, 96, 224, 224, 224, 224, 241, 224, 209, 96,
  209, 96, 219, 96, 202, 96, 206, 96, 196, 96, 9, 11, 22, 11, 1, 0,
  193, 128, 225, 128, 225, 128, 209, 128, 217, 128, 201, 128, 205, 128, 197, 128,
  195, 128, 195, 128, 193, 128, 10, 11, 22, 12, 1, 0, 30, 0, 115, 128,
  97, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 97, 128, 115, 128,
  30, 0, 8, 11, 11, 10, 1, 0, 254, 199, 195, 195, 199, 254, 192, 192,
  192, 192, 192, 10, 11, 22, 12, 1, 0, 30, 0, 115, 128, 97, 128, 192,
  192, 192, 192, 192, 192, 192, 192, 198, 192, 99, 128, 115, 128, 30, 192, 9,
  11, 22, 11, 1, 0, 254, 0, 199, 0, 195, 0, 195, 0, 198, 0, 254,
  0, 199, 0, 195, 0, 195, 0, 195, 0, 193, 128, 8, 11, 11, 10, 1,
  0, 126, 231, 195, 224, 120, 30, 7, 3, 195, 238, 124, 8, 11, 11, 8,
  0, 0, 255, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 9, 11, 22,
  11, 1, 0, 193, 128, 193, 128, 193, 128, 193, 128, 193, 128, 193, 128, 193,
  128, 193, 128, 193, 128, 99, 0, 62, 0, 10, 11, 22, 10, 0, 0, 192,
  192, 192, 192, 97, 128, 97, 128, 115, 128, 51, 0, 51, 0, 30, 0, 30,
  0, 12, 0, 12, 0, 14, 11, 22, 14, 0, 0, 195, 12, 195, 12, 195,
  12, 103, 152, 100, 152, 100, 152, 108, 216, 44, 208, 56, 112, 24, 96, 24,
  96, 9, 11, 22, 9, 0, 0, 193, 128, 193, 128, 99, 0, 54, 0, 28,
  0, 28, 0, 54, 0, 99, 0, 99, 0, 193, 128, 193, 128, 10, 11, 22,
  10, 0, 0, 192, 192, 97, 128, 97, 128, 51, 0, 51, 0, 30, 0, 30,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 8, 11, 11, 9, 0, 0, 255,
  3, 6, 12, 28, 24, 48, 112, 96, 192, 255, 4, 14, 14, 5, 1, 253,
  240, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 240, 4, 11,
  11, 4, 0, 0, 128, 128, 192, 64, 64, 96, 32, 32, 48, 16, 16, 4,
  14, 14, 5, 0, 253, 240, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 240, 6, 5, 5, 8, 1, 6, 48, 120, 72, 204, 204, 8, 1,
  1, 8, 0, 253, 255, 3, 2, 2, 5, 1, 9, 192, 96, 7, 8, 8,
  8, 1, 0, 120, 204, 12, 124, 204, 204, 220, 118, 7, 11, 11, 9, 1,
  0, 192, 192, 192, 216, 236, 198, 198, 198, 198, 236, 216, 6, 8, 8, 8,
  1, 0, 56, 108, 204, 192, 192, 204, 108, 56, 7, 11, 11, 9, 1, 0,
  6, 6, 6, 54, 110, 198, 198, 198, 198, 110, 54, 6, 8, 8, 8, 1,
  0, 120, 204, 204, 252, 192, 192, 236, 120, 5, 11, 11, 4, 0, 0, 56,
  96, 96, 240, 96, 96, 96, 96, 96, 96, 96, 7, 11, 11, 9, 1, 253,
  58, 110, 198, 198, 198, 198, 110, 54, 6, 206, 124, 7, 11, 11, 9, 1,
  0, 192, 192, 192, 220, 238, 198, 198, 198, 198, 198, 198, 2, 11, 11, 4,
  1, 0, 192, 192, 0, 192, 192, 192, 192, 192, 192, 192, 192, 3, 14, 14,
  4, 0, 253, 96, 96, 0, 96, 96, 96, 96, 96, 96, 96, 96, 96, 224,
  192, 6, 11, 11, 8, 1, 0, 192, 192, 192, 204, 216, 240, 240, 216, 216,
  204, 204, 2, 11, 11, 4, 1, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 10, 8, 16, 12, 1, 0, 219, 128, 238, 192, 204, 192, 204,
  192, 204, 192, 204, 192, 204, 192, 204, 192, 7, 8, 8, 9, 1, 0, 220,
  238, 198, 198, 198, 198, 198, 198, 7, 8, 8, 9, 1, 0, 56, 108, 198,
  198, 198, 198, 108, 56, 7, 11, 11, 9, 1, 253, 216, 236, 198, 198, 198,
  198, 236, 216, 192, 192, 192, 7, 11, 11, 9, 1, 253, 54, 110, 198, 198,
  198, 198, 110, 54, 6, 6, 6, 5, 8, 8, 6, 1, 0, 216, 248, 192,
  192, 192, 192, 192, 192, 6, 8, 8, 8, 1, 0, 120, 204, 224, 120, 28,
  12, 236, 120, 5, 10, 10, 5, 0, 0, 96, 96, 248, 96, 96, 96, 96,
  96, 104, 48, 7, 8, 8, 9, 1, 0, 198, 198, 198, 198, 198, 198, 238,
  118, 8, 8, 8, 8, 0, 0, 195, 195, 102, 102, 36, 60, 24, 24, 10,
  8, 16, 10, 0, 0, 204, 192, 204, 192, 204, 192, 109, 128, 109, 128, 51,
  0, 51, 0, 51, 0, 7, 8, 8, 7, 0, 0, 198, 198, 108, 56, 56,
  108, 198, 198, 8, 11, 11, 8, 0, 253, 195, 195, 102, 102, 36, 60, 24,
  24, 24, 48, 112, 6, 8, 8, 6, 0, 0, 252, 12, 24, 48, 48, 96,
  192, 252, 5, 14, 14, 6, 0, 253, 24, 48, 48, 48, 48, 96, 192, 96,
  48, 48, 48, 48, 48, 24, 1, 14, 14, 4, 2, 253, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 5, 14, 14, 6, 1, 253,
  192, 96, 96, 96, 96, 48, 24, 48, 96, 96, 96, 96, 96, 192, 7, 3,
  3, 9, 1, 3, 114, 222, 140, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 4, 0, 1, 2, 11,
  11, 4, 1, 253, 192, 192, 0, 64, 64, 192, 192, 192, 192, 192, 192, 7,
  10, 10, 8, 0, 255, 4, 60, 110, 200, 208, 208, 230, 102, 124, 64, 8,
  11, 11, 8, 0, 0, 60, 102, 102, 96, 252, 48, 48, 48, 96, 251, 222,
  7, 7, 7, 8, 0, 2, 130, 124, 108, 108, 108, 124, 130, 8, 11, 11,
  9, 0, 0, 195, 195, 195, 102, 102, 60, 126, 24, 126, 24, 24, 1, 14,
  14, 4, 2, 253, 128, 128, 128, 128, 128, 128, 0, 0, 128, 128, 128, 128,
  128, 128, 6, 14, 14, 8, 1, 253, 120, 204, 204, 224, 120, 220, 204, 204,
  236, 120, 28, 204, 204, 120, 5, 2, 2, 5, 0, 9, 216, 216, 10, 11,
  22, 12, 1, 0, 30, 0, 97, 128, 76, 128, 210, 192, 144, 64, 144, 64,
  144, 64, 146, 64, 76, 128, 97, 128, 30, 0, 5, 7, 7, 6, 0, 4,
  112, 144, 112, 208, 248, 0, 248, 7, 5, 5, 9, 1, 2, 54, 108, 216,
  108, 54, 7, 4, 4, 9, 1, 2, 254, 254, 2, 2, 3, 1, 1, 4,
  0, 4, 224, 10, 11, 22, 12, 1, 0, 30, 0, 97, 128, 92, 128, 146,
  64, 146, 64, 156, 64, 146, 64, 146, 64, 82, 128, 97, 128, 30, 0, 5,
  1, 1, 5, 0, 9, 248, 4, 4, 4, 6, 1, 7, 96, 144, 144, 96,
  8, 9, 9, 9, 0, 0, 24, 24, 24, 255, 24, 24, 24, 0, 255, 4,
  6, 6, 5, 0, 5, 96, 176, 48, 96, 192, 240, 4, 6, 6, 5, 0,
  5, 96, 176, 96, 48, 176, 96, 3, 2, 2, 5, 1, 9, 96, 192, 7,
  11, 11, 9, 1, 253, 198, 198, 198, 198, 198, 198, 238, 246, 192, 192, 192,
  8, 14, 14, 8, 0, 253, 63, 122, 250, 250, 250, 122, 58, 10, 10, 10,
  10, 10, 10, 10, 2, 2, 2, 4, 1, 3, 192, 192, 5, 3, 3, 5,
  0, 253, 24, 216, 112, 3, 6, 6, 4, 0, 5, 96, 224, 96, 96, 96,
  96, 5, 7, 7, 6, 0, 4, 112, 216, 216, 216, 112, 0, 248, 7, 5,
  5, 9, 1, 2, 216, 108, 54, 108, 216, 12, 11, 22, 12, 0, 0, 97,
  128, 225, 128, 99, 0, 99, 0, 102, 0, 102, 32, 6, 96, 12, 224, 13,
  96, 25, 240, 24, 96, 11, 11, 22, 12, 0, 0, 97, 128, 225, 128, 99,
  0, 99, 0, 102, 0, 102, 192, 7, 96, 12, 96, 12, 192, 25, 128, 25,
  224, 12, 11, 22, 12, 0, 0, 97, 128, 177, 128, 99, 0, 51, 0, 182,
  0, 102, 32, 6, 96, 12, 224, 13, 96, 25, 240, 24, 96, 7, 11, 11,
  9, 1, 253, 24, 24, 0, 24, 24, 48, 96, 192, 198, 198, 124, 10, 14,
  28, 10, 0, 0, 24, 0, 12, 0, 0, 0, 12, 0, 12, 0, 30, 0,
  18, 0, 51, 0, 51, 0, 97, 128, 127, 128, 97, 128, 192, 192, 192, 192,
  10, 14, 28, 10, 0, 0, 6, 0, 12, 0, 0, 0, 12, 0, 12, 0,
  30, 0, 18, 0, 51, 0, 51, 0, 97, 128, 127, 128, 97, 128, 192, 192,
  192, 192, 10, 14, 28, 10, 0, 0, 14, 0, 27, 0, 0, 0, 12, 0,
  12, 0, 30, 0, 18, 0, 51, 0, 51, 0, 97, 128, 127, 128, 97, 128,
  192, 192, 192, 192, 10, 14, 28, 10, 0, 0, 13, 0, 22, 0, 0, 0,
  12, 0, 12, 0, 30, 0, 18, 0, 51, 0, 51, 0, 97, 128, 127, 128,
  97, 128, 192, 192, 192, 192, 10, 14, 28, 10, 0, 0, 51, 0, 51, 0,
  0, 0, 12, 0, 12, 0, 30, 0, 18, 0, 51, 0, 51, 0, 97, 128,
  127, 128, 97, 128, 192, 192, 192, 192, 10, 14, 28, 10, 0, 0, 12, 0,
  18, 0, 12, 0, 12, 0, 12, 0, 30, 0, 18, 0, 51, 0, 51, 0,
  97, 128, 127, 128, 97, 128, 192, 192, 192, 192, 14, 11, 22, 15, 0, 0,
  15, 252, 15, 0, 27, 0, 19, 0, 51, 0, 51, 248, 99, 0, 127, 0,
  99, 0, 195, 0, 195, 252, 9, 14, 28, 11, 1, 253, 31, 0, 123, 128,
  96, 128, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 96, 128, 123, 128,
  31, 0, 6, 0, 54, 0, 28, 0, 7, 14, 14, 9, 1, 0, 48, 24,
  0, 254, 192, 192, 192, 192, 254, 192, 192, 192, 192, 254, 7, 14, 14, 9,
  1, 0, 12, 24, 0, 254, 192, 192, 192, 192, 254, 192, 192, 192, 192, 254,
  7, 14, 14, 9, 1, 0, 28, 54, 0, 254, 192, 192, 192, 192, 254, 192,
  192, 192, 192, 254, 7, 14, 14, 9, 1, 0, 108, 108, 0, 254, 192, 192,
  192, 192, 254, 192, 192, 192, 192, 254, 3, 14, 14, 4, 0, 0, 192, 96,
  0, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 3, 14, 14, 4,
  1, 0, 96, 192, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  5, 14, 14, 4, 0, 0, 112, 216, 0, 96, 96, 96, 96, 96, 96, 96,
  96, 96, 96, 96, 5, 14, 14, 4, 0, 0, 216, 216, 0, 96, 96, 96,
  96, 96, 96, 96, 96, 96, 96, 96, 10, 11, 22, 11, 0, 0, 126, 0,
  99, 128, 97, 128, 96, 192, 96, 192, 248, 192, 96, 192, 96, 192, 97, 128,
  99, 128, 126, 0, 9, 14, 28, 11, 1, 0, 26, 0, 44, 0, 0, 0,
  193, 128, 225, 128, 225, 128, 209, 128, 217, 128, 201, 128, 205, 128, 197, 128,
  195, 128, 195, 128, 193, 128, 10, 14, 28, 12, 1, 0, 24, 0, 12, 0,
  0, 0, 30, 0, 115, 128, 97, 128, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 97, 128, 115, 128, 30, 0, 10, 14, 28, 12, 1, 0, 6, 0,
  12, 0, 0, 0, 30, 0, 115, 128, 97, 128, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 97, 128, 115, 128, 30, 0, 10, 14, 28, 12, 1, 0,
  14, 0, 27, 0, 0, 0, 30, 0, 115, 128, 97, 128, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 97, 128, 115, 128, 30, 0, 10, 14, 28, 12,
  1, 0, 13, 0, 22, 0, 0, 0, 30, 0, 115, 128, 97, 128, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 97, 128, 115, 128, 30, 0, 10, 14,
  28, 12, 1, 0, 51, 0, 51, 0, 0, 0, 30, 0, 115, 128, 97, 128,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 97, 128, 115, 128, 30, 0,
  8, 7, 7, 9, 0, 1, 195, 102, 60, 24, 60, 102, 195, 12, 11, 22,
  12, 0, 0, 15, 48, 57, 224, 48, 192, 97, 224, 99, 96, 102, 96, 108,
  96, 120, 96, 48, 192, 121, 192, 207, 0, 9, 14, 28, 11, 1, 0, 24,
  0, 12, 0, 0, 0, 193, 128, 193, 128, 193, 128, 193, 128, 193, 128, 193,
  128, 193, 128, 193, 128, 193, 128, 99, 0, 62, 0, 9, 14, 28, 11, 1,
  0, 6, 0, 12, 0, 0, 0, 193, 128, 193, 128, 193, 128, 193, 128, 193,
  128, 193, 128, 193, 128, 193, 128, 193, 128, 99, 0, 62, 0, 9, 14, 28,
  11, 1, 0, 28, 0, 54, 0, 0, 0, 193, 128, 193, 128, 193, 128, 193,
  128, 193, 128, 193, 128, 193, 128, 193, 128, 193, 128, 99, 0, 62, 0, 9,
  14, 28, 11, 1, 0, 99, 0, 99, 0, 0, 0, 193, 128, 193, 128, 193,
  128, 193, 128, 193, 128, 193, 128, 193, 128, 193, 128, 193, 128, 99, 0, 62,
  0, 10, 14, 28, 10, 0, 0, 6, 0, 12, 0, 0, 0, 192, 192, 97,
  128, 97, 128, 51, 0, 51, 0, 30, 0, 30, 0, 12, 0, 12, 0, 12,
  0, 12, 0, 8, 11, 11, 10, 1, 0, 192, 192, 254, 199, 195, 195, 199,
  254, 192, 192, 192, 6, 11, 11, 8, 1, 0, 120, 204, 204, 204, 216, 216,
  204, 204, 204, 204, 216, 7, 11, 11, 8, 1, 0, 48, 24, 0, 120, 204,
  12, 124, 204, 204, 220, 118, 7, 11, 11, 8, 1, 0, 24, 48, 0, 120,
  204, 12, 124, 204, 204, 220, 118, 7, 11, 11, 8, 1, 0, 56, 108, 0,
  120, 204, 12, 124, 204, 204, 220, 118, 7, 11, 11, 8, 1, 0, 52, 88,
  0, 120, 204, 12, 124, 204, 204, 220, 118, 7, 11, 11, 8, 1, 0, 108,
  108, 0, 120, 204, 12, 124, 204, 204, 220, 118, 7, 11, 11, 8, 1, 0,
  48, 72, 48, 120, 204, 12, 124, 204, 204, 220, 118, 11, 8, 16, 13, 1,
  0, 123, 192, 206, 96, 12, 96, 127, 224, 204, 0, 204, 0, 222, 96, 119,
  192, 7, 11, 11, 9, 1, 253, 60, 102, 198, 192, 192, 198, 102, 60, 24,
  88, 112, 6, 11, 11, 8, 1, 0, 96, 48, 0, 120, 204, 204, 252, 192,
  192, 236, 120, 6, 11, 11, 8, 1, 0, 24, 48, 0, 120, 204, 204, 252,
  192, 192, 236, 120, 6, 11, 11, 8, 1, 0, 56, 108, 0, 120, 204, 204,
  252, 192, 192, 236, 120, 6, 11, 11, 8, 1, 0, 108, 108, 0, 120, 204,
  204, 252, 192, 192, 236, 120, 3, 11, 11, 4, 0, 0, 192, 96, 0, 96,
  96, 96, 96, 96, 96, 96, 96, 3, 11, 11, 4, 1, 0, 96, 192, 0,
  192, 192, 192, 192, 192, 192, 192, 192, 5, 11, 11, 4, 0, 0, 112, 216,
  0, 96, 96, 96, 96, 96, 96, 96, 96, 5, 11, 11, 4, 0, 0, 216,
  216, 0, 96, 96, 96, 96, 96, 96, 96, 96, 7, 11, 11, 9, 1, 0,
  108, 56, 72, 60, 108, 198, 198, 198, 198, 108, 56, 7, 11, 11, 9, 1,
  0, 52, 88, 0, 220, 238, 198, 198, 198, 198, 198, 198, 7, 11, 11, 9,
  1, 0, 48, 24, 0, 56, 108, 198, 198, 198, 198, 108, 56, 7, 11, 11,
  9, 1, 0, 24, 48, 0, 56, 108, 198, 198, 198, 198, 108, 56, 7, 11,
  11, 9, 1, 0, 56, 108, 0, 56, 108, 198, 198, 198, 198, 108, 56, 7,
  11, 11, 9, 1, 0, 52, 88, 0, 56, 108, 198, 198, 198, 198, 108, 56,
  7, 11, 11, 9, 1, 0, 108, 108, 0, 56, 108, 198, 198, 198, 198, 108,
  56, 8, 7, 7, 9, 0, 1, 24, 24, 0, 255, 0, 24, 24, 7, 8,
  8, 9, 1, 0, 58, 108, 206, 214, 214, 230, 108, 184, 7, 11, 11, 9,
  1, 0, 48, 24, 0, 198, 198, 198, 198, 198, 198, 238, 118, 7, 11, 11,
  9, 1, 0, 12, 24, 0, 198, 198, 198, 198, 198, 198, 238, 118, 7, 11,
  11, 9, 1, 0, 56, 108, 0, 198, 198, 198, 198, 198, 198, 238, 118, 7,
  11, 11, 9, 1, 0, 108, 108, 0, 198, 198, 198, 198, 198, 198, 238, 118,
  8, 14, 14, 8, 0, 253, 12, 24, 0, 195, 195, 102, 102, 36, 60, 24,
  24, 24, 48, 112, 7, 14, 14, 9, 1, 253, 192, 192, 192, 216, 236, 198,
  198, 198, 198, 236, 216, 192, 192, 192, 8, 14, 14, 8, 0, 253, 54, 54,
  0, 195, 195, 102, 102, 36, 60, 24, 24, 24, 48, 112
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--14-100-100-100-P-82-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 0, '1' Height: 11
  Calculated Max Values w= 8 h=11 x= 2 y= 7 dx= 9 dy= 0 ascent=11 len=11
  Font Bounding box     w=17 h=23 x=-1 y=-6
  Calculated Min Values           x= 0 y=-1 dx= 0 dy= 0
  Pure Font   ascent =11 descent= 0
  X Font      ascent =11 descent= 0
  Max Font    ascent =11 descent=-1
*/
const u8g_fntpgm_uint8_t u8g_font_helvB10n[265] U8G_FONT_SECTION("u8g_font_helvB10n") = {
  0, 17, 23, 255, 250, 11, 0, 0, 0, 0, 42, 58, 0, 11, 255, 11,
  0, 5, 4, 4, 6, 0, 7, 32, 248, 112, 216, 8, 7, 7, 9, 0,
  1, 24, 24, 24, 255, 24, 24, 24, 3, 3, 3, 4, 0, 255, 96, 96,
  192, 3, 1, 1, 4, 0, 4, 224, 2, 2, 2, 4, 1, 0, 192, 192,
  4, 11, 11, 4, 0, 0, 16, 16, 48, 32, 32, 96, 64, 64, 192, 128,
  128, 7, 11, 11, 8, 0, 0, 56, 108, 198, 198, 198, 198, 198, 198, 198,
  108, 56, 4, 11, 11, 8, 1, 0, 48, 240, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 7, 11, 11, 8, 0, 0, 124, 198, 198, 6, 14, 12, 24,
  48, 96, 192, 254, 7, 11, 11, 8, 0, 0, 124, 198, 198, 6, 6, 60,
  6, 6, 198, 198, 124, 8, 11, 11, 8, 0, 0, 6, 14, 30, 54, 102,
  198, 198, 255, 6, 6, 6, 7, 11, 11, 8, 0, 0, 126, 96, 96, 192,
  252, 14, 6, 6, 198, 204, 120, 7, 11, 11, 8, 0, 0, 60, 102, 102,
  192, 220, 230, 198, 198, 198, 198, 124, 7, 11, 11, 8, 0, 0, 254, 6,
  12, 12, 24, 24, 48, 48, 96, 96, 96, 7, 11, 11, 8, 0, 0, 124,
  198, 198, 198, 198, 124, 198, 198, 198, 198, 124, 7, 11, 11, 8, 0, 0,
  124, 198, 198, 198, 198, 198, 126, 6, 198, 204, 120, 2, 8, 8, 5, 2,
  0, 192, 192, 0, 0, 0, 0, 192, 192
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--14-100-100-100-P-82-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 11, '1' Height: 11
  Calculated Max Values w=14 h=14 x= 2 y= 9 dx=14 dy= 0 ascent=12 len=24
  Font Bounding box     w=17 h=23 x=-1 y=-6
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =11 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =12 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_helvB10r[1720] U8G_FONT_SECTION("u8g_font_helvB10r") = {
  0, 17, 23, 255, 250, 11, 2, 27, 4, 205, 32, 127, 253, 12, 253, 11,
  253, 0, 0, 0, 4, 0, 1, 2, 11, 11, 4, 1, 0, 192, 192, 192,
  192, 192, 192, 128, 128, 0, 192, 192, 5, 3, 3, 7, 1, 8, 216, 216,
  144, 9, 10, 20, 9, 0, 0, 27, 0, 27, 0, 27, 0, 127, 128, 54,
  0, 54, 0, 255, 0, 108, 0, 108, 0, 108, 0, 7, 14, 14, 8, 0,
  254, 16, 124, 214, 214, 208, 240, 120, 28, 22, 214, 214, 124, 16, 16, 12,
  11, 22, 13, 0, 0, 120, 64, 204, 192, 205, 128, 121, 0, 3, 0, 6,
  0, 4, 0, 13, 224, 11, 48, 27, 48, 17, 224, 9, 10, 20, 11, 1,
  0, 56, 0, 108, 0, 108, 0, 56, 0, 115, 0, 251, 0, 206, 0, 198,
  0, 207, 0, 125, 128, 2, 3, 3, 4, 1, 8, 192, 192, 128, 4, 14,
  14, 5, 1, 253, 48, 96, 96, 192, 192, 192, 192, 192, 192, 192, 192, 96,
  96, 48, 4, 14, 14, 5, 0, 253, 192, 96, 96, 48, 48, 48, 48, 48,
  48, 48, 48, 96, 96, 192, 5, 4, 4, 6, 0, 7, 32, 248, 112, 216,
  8, 7, 7, 9, 0, 1, 24, 24, 24, 255, 24, 24, 24, 3, 3, 3,
  4, 0, 255, 96, 96, 192, 3, 1, 1, 4, 0, 4, 224, 2, 2, 2,
  4, 1, 0, 192, 192, 4, 11, 11, 4, 0, 0, 16, 16, 48, 32, 32,
  96, 64, 64, 192, 128, 128, 7, 11, 11, 8, 0, 0, 56, 108, 198, 198,
  198, 198, 198, 198, 198, 108, 56, 4, 11, 11, 8, 1, 0, 48, 240, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 7, 11, 11, 8, 0, 0, 124, 198,
  198, 6, 14, 12, 24, 48, 96, 192, 254, 7, 11, 11, 8, 0, 0, 124,
  198, 198, 6, 6, 60, 6, 6, 198, 198, 124, 8, 11, 11, 8, 0, 0,
  6, 14, 30, 54, 102, 198, 198, 255, 6, 6, 6, 7, 11, 11, 8, 0,
  0, 126, 96, 96, 192, 252, 14, 6, 6, 198, 204, 120, 7, 11, 11, 8,
  0, 0, 60, 102, 102, 192, 220, 230, 198, 198, 198, 198, 124, 7, 11, 11,
  8, 0, 0, 254, 6, 12, 12, 24, 24, 48, 48, 96, 96, 96, 7, 11,
  11, 8, 0, 0, 124, 198, 198, 198, 198, 124, 198, 198, 198, 198, 124, 7,
  11, 11, 8, 0, 0, 124, 198, 198, 198, 198, 198, 126, 6, 198, 204, 120,
  2, 8, 8, 5, 2, 0, 192, 192, 0, 0, 0, 0, 192, 192, 3, 9,
  9, 5, 1, 255, 96, 96, 0, 0, 0, 0, 96, 96, 192, 6, 5, 5,
  8, 1, 2, 28, 112, 192, 112, 28, 7, 3, 3, 9, 1, 3, 254, 0,
  254, 6, 5, 5, 8, 1, 2, 224, 56, 12, 56, 224, 7, 11, 11, 9,
  1, 0, 124, 198, 198, 6, 12, 24, 48, 48, 0, 48, 48, 13, 12, 24,
  14, 0, 255, 15, 128, 56, 224, 112, 112, 102, 176, 205, 152, 217, 152, 219,
  24, 219, 48, 206, 224, 96, 0, 49, 128, 31, 0, 10, 11, 22, 10, 0,
  0, 12, 0, 12, 0, 30, 0, 18, 0, 51, 0, 51, 0, 97, 128, 127,
  128, 97, 128, 192, 192, 192, 192, 8, 11, 11, 10, 1, 0, 254, 199, 195,
  195, 198, 252, 198, 195, 195, 199, 254, 9, 11, 22, 11, 1, 0, 31, 0,
  123, 128, 96, 128, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 96, 128,
  123, 128, 31, 0, 9, 11, 22, 11, 1, 0, 252, 0, 199, 0, 195, 0,
  193, 128, 193, 128, 193, 128, 193, 128, 193, 128, 195, 0, 199, 0, 252, 0,
  7, 11, 11, 9, 1, 0, 254, 192, 192, 192, 192, 254, 192, 192, 192, 192,
  254, 7, 11, 11, 9, 1, 0, 254, 192, 192, 192, 192, 252, 192, 192, 192,
  192, 192, 9, 11, 22, 11, 1, 0, 31, 0, 123, 128, 96, 128, 192, 0,
  192, 0, 199, 128, 193, 128, 193, 128, 97, 128, 123, 128, 30, 128, 8, 11,
  11, 10, 1, 0, 195, 195, 195, 195, 195, 255, 195, 195, 195, 195, 195, 2,
  11, 11, 4, 1, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  7, 11, 11, 8, 0, 0, 6, 6, 6, 6, 6, 6, 6, 198, 198, 238,
  124, 9, 11, 22, 10, 1, 0, 195, 0, 198, 0, 204, 0, 216, 0, 240,
  0, 240, 0, 216, 0, 204, 0, 198, 0, 195, 0, 193, 128, 7, 11, 11,
  8, 1, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 254, 11, 11,
  22, 13, 1, 0, 192, 96, 192, 96, 224, 224, 224, 224, 241, 224, 209, 96,
  209, 96, 219, 96, 202, 96, 206, 96, 196, 96, 9, 11, 22, 11, 1, 0,
  193, 128, 225, 128, 225, 128, 209, 128, 217, 128, 201, 128, 205, 128, 197, 128,
  195, 128, 195, 128, 193, 128, 10, 11, 22, 12, 1, 0, 30, 0, 115, 128,
  97, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 97, 128, 115, 128,
  30, 0, 8, 11, 11, 10, 1, 0, 254, 199, 195, 195, 199, 254, 192, 192,
  192, 192, 192, 10, 11, 22, 12, 1, 0, 30, 0, 115, 128, 97, 128, 192,
  192, 192, 192, 192, 192, 192, 192, 198, 192, 99, 128, 115, 128, 30, 192, 9,
  11, 22, 11, 1, 0, 254, 0, 199, 0, 195, 0, 195, 0, 198, 0, 254,
  0, 199, 0, 195, 0, 195, 0, 195, 0, 193, 128, 8, 11, 11, 10, 1,
  0, 126, 231, 195, 224, 120, 30, 7, 3, 195, 238, 124, 8, 11, 11, 8,
  0, 0, 255, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 9, 11, 22,
  11, 1, 0, 193, 128, 193, 128, 193, 128, 193, 128, 193, 128, 193, 128, 193,
  128, 193, 128, 193, 128, 99, 0, 62, 0, 10, 11, 22, 10, 0, 0, 192,
  192, 192, 192, 97, 128, 97, 128, 115, 128, 51, 0, 51, 0, 30, 0, 30,
  0, 12, 0, 12, 0, 14, 11, 22, 14, 0, 0, 195, 12, 195, 12, 195,
  12, 103, 152, 100, 152, 100, 152, 108, 216, 44, 208, 56, 112, 24, 96, 24,
  96, 9, 11, 22, 9, 0, 0, 193, 128, 193, 128, 99, 0, 54, 0, 28,
  0, 28, 0, 54, 0, 99, 0, 99, 0, 193, 128, 193, 128, 10, 11, 22,
  10, 0, 0, 192, 192, 97, 128, 97, 128, 51, 0, 51, 0, 30, 0, 30,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 8, 11, 11, 9, 0, 0, 255,
  3, 6, 12, 28, 24, 48, 112, 96, 192, 255, 4, 14, 14, 5, 1, 253,
  240, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 240, 4, 11,
  11, 4, 0, 0, 128, 128, 192, 64, 64, 96, 32, 32, 48, 16, 16, 4,
  14, 14, 5, 0, 253, 240, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 240, 6, 5, 5, 8, 1, 6, 48, 120, 72, 204, 204, 8, 1,
  1, 8, 0, 253, 255, 3, 2, 2, 5, 1, 9, 192, 96, 7, 8, 8,
  8, 1, 0, 120, 204, 12, 124, 204, 204, 220, 118, 7, 11, 11, 9, 1,
  0, 192, 192, 192, 216, 236, 198, 198, 198, 198, 236, 216, 6, 8, 8, 8,
  1, 0, 56, 108, 204, 192, 192, 204, 108, 56, 7, 11, 11, 9, 1, 0,
  6, 6, 6, 54, 110, 198, 198, 198, 198, 110, 54, 6, 8, 8, 8, 1,
  0, 120, 204, 204, 252, 192, 192, 236, 120, 5, 11, 11, 4, 0, 0, 56,
  96, 96, 240, 96, 96, 96, 96, 96, 96, 96, 7, 11, 11, 9, 1, 253,
  58, 110, 198, 198, 198, 198, 110, 54, 6, 206, 124, 7, 11, 11, 9, 1,
  0, 192, 192, 192, 220, 238, 198, 198, 198, 198, 198, 198, 2, 11, 11, 4,
  1, 0, 192, 192, 0, 192, 192, 192, 192, 192, 192, 192, 192, 3, 14, 14,
  4, 0, 253, 96, 96, 0, 96, 96, 96, 96, 96, 96, 96, 96, 96, 224,
  192, 6, 11, 11, 8, 1, 0, 192, 192, 192, 204, 216, 240, 240, 216, 216,
  204, 204, 2, 11, 11, 4, 1, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 10, 8, 16, 12, 1, 0, 219, 128, 238, 192, 204, 192, 204,
  192, 204, 192, 204, 192, 204, 192, 204, 192, 7, 8, 8, 9, 1, 0, 220,
  238, 198, 198, 198, 198, 198, 198, 7, 8, 8, 9, 1, 0, 56, 108, 198,
  198, 198, 198, 108, 56, 7, 11, 11, 9, 1, 253, 216, 236, 198, 198, 198,
  198, 236, 216, 192, 192, 192, 7, 11, 11, 9, 1, 253, 54, 110, 198, 198,
  198, 198, 110, 54, 6, 6, 6, 5, 8, 8, 6, 1, 0, 216, 248, 192,
  192, 192, 192, 192, 192, 6, 8, 8, 8, 1, 0, 120, 204, 224, 120, 28,
  12, 236, 120, 5, 10, 10, 5, 0, 0, 96, 96, 248, 96, 96, 96, 96,
  96, 104, 48, 7, 8, 8, 9, 1, 0, 198, 198, 198, 198, 198, 198, 238,
  118, 8, 8, 8, 8, 0, 0, 195, 195, 102, 102, 36, 60, 24, 24, 10,
  8, 16, 10, 0, 0, 204, 192, 204, 192, 204, 192, 109, 128, 109, 128, 51,
  0, 51, 0, 51, 0, 7, 8, 8, 7, 0, 0, 198, 198, 108, 56, 56,
  108, 198, 198, 8, 11, 11, 8, 0, 253, 195, 195, 102, 102, 36, 60, 24,
  24, 24, 48, 112, 6, 8, 8, 6, 0, 0, 252, 12, 24, 48, 48, 96,
  192, 252, 5, 14, 14, 6, 0, 253, 24, 48, 48, 48, 48, 96, 192, 96,
  48, 48, 48, 48, 48, 24, 1, 14, 14, 4, 2, 253, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 5, 14, 14, 6, 1, 253,
  192, 96, 96, 96, 96, 48, 24, 48, 96, 96, 96, 96, 96, 192, 7, 3,
  3, 9, 1, 3, 114, 222, 140, 255
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--17-120-100-100-P-92-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 12, '1' Height: 12
  Calculated Max Values w=14 h=17 x= 2 y=10 dx=16 dy= 0 ascent=16 len=32
  Font Bounding box     w=20 h=27 x=-2 y=-7
  Calculated Min Values           x=-1 y=-4 dx= 0 dy= 0
  Pure Font   ascent =12 descent=-4
  X Font      ascent =12 descent=-4
  Max Font    ascent =16 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_helvB12[4077] U8G_FONT_SECTION("u8g_font_helvB12") = {
  0, 20, 27, 254, 249, 12, 2, 74, 5, 106, 32, 255, 252, 16, 252, 12,
  252, 0, 0, 0, 5, 0, 1, 2, 12, 12, 6, 2, 0, 192, 192, 192,
  192, 192, 192, 128, 128, 128, 0, 192, 192, 5, 4, 4, 8, 1, 8, 216,
  216, 216, 72, 9, 12, 24, 9, 0, 0, 27, 0, 27, 0, 27, 0, 127,
  128, 127, 128, 54, 0, 54, 0, 255, 0, 255, 0, 108, 0, 108, 0, 108,
  0, 7, 14, 14, 9, 1, 255, 16, 124, 254, 214, 208, 240, 120, 60, 30,
  22, 214, 254, 124, 16, 13, 12, 24, 14, 0, 0, 48, 64, 120, 128, 204,
  128, 205, 0, 121, 0, 50, 0, 2, 96, 4, 240, 5, 152, 9, 152, 8,
  240, 16, 96, 10, 12, 24, 12, 1, 0, 60, 0, 126, 0, 102, 0, 102,
  0, 60, 0, 56, 192, 125, 192, 207, 128, 199, 0, 199, 0, 127, 128, 57,
  192, 2, 4, 4, 4, 1, 8, 192, 192, 192, 64, 4, 15, 15, 6, 1,
  253, 48, 112, 96, 192, 192, 192, 192, 192, 192, 192, 192, 192, 96, 112, 48,
  4, 15, 15, 6, 0, 253, 192, 224, 96, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 96, 224, 192, 5, 5, 5, 6, 0, 7, 32, 168, 112, 112, 136,
  8, 8, 8, 10, 1, 0, 24, 24, 24, 255, 255, 24, 24, 24, 2, 5,
  5, 4, 1, 253, 192, 192, 64, 64, 128, 4, 2, 2, 5, 0, 3, 240,
  240, 2, 2, 2, 4, 1, 0, 192, 192, 4, 12, 12, 5, 0, 0, 16,
  16, 48, 32, 32, 96, 64, 64, 192, 128, 128, 128, 8, 12, 12, 9, 0,
  0, 60, 126, 231, 195, 195, 195, 195, 195, 195, 231, 126, 60, 5, 12, 12,
  9, 1, 0, 8, 24, 248, 248, 24, 24, 24, 24, 24, 24, 24, 24, 8,
  12, 12, 9, 0, 0, 60, 126, 231, 195, 195, 7, 14, 28, 56, 112, 255,
  255, 8, 12, 12, 9, 0, 0, 60, 126, 231, 195, 7, 30, 30, 7, 195,
  231, 126, 60, 8, 12, 12, 9, 0, 0, 14, 30, 54, 54, 102, 102, 198,
  255, 255, 6, 6, 6, 8, 12, 12, 9, 0, 0, 63, 63, 48, 48, 124,
  126, 71, 3, 3, 231, 126, 60, 8, 12, 12, 9, 0, 0, 60, 126, 231,
  192, 220, 254, 231, 195, 195, 231, 126, 60, 8, 12, 12, 9, 0, 0, 255,
  255, 6, 6, 12, 12, 24, 24, 24, 48, 48, 48, 8, 12, 12, 9, 0,
  0, 60, 126, 231, 195, 102, 60, 126, 231, 195, 231, 126, 60, 8, 12, 12,
  9, 0, 0, 60, 126, 231, 195, 195, 231, 127, 59, 3, 231, 126, 60, 2,
  8, 8, 5, 2, 0, 192, 192, 0, 0, 0, 0, 192, 192, 2, 11, 11,
  5, 2, 253, 192, 192, 0, 0, 0, 0, 192, 192, 64, 64, 128, 8, 8,
  8, 10, 1, 0, 3, 15, 60, 224, 224, 60, 15, 3, 8, 6, 6, 10,
  1, 1, 255, 255, 0, 0, 255, 255, 8, 8, 8, 10, 1, 0, 192, 240,
  60, 7, 7, 60, 240, 192, 7, 12, 12, 10, 1, 0, 124, 254, 198, 198,
  6, 14, 12, 24, 24, 0, 24, 24, 13, 14, 28, 16, 1, 254, 15, 192,
  56, 96, 96, 16, 71, 216, 204, 72, 136, 200, 152, 200, 152, 136, 153, 152,
  201, 144, 70, 96, 96, 0, 56, 192, 15, 128, 11, 12, 24, 12, 0, 0,
  14, 0, 14, 0, 31, 0, 27, 0, 59, 128, 49, 128, 113, 192, 96, 192,
  127, 192, 255, 224, 192, 96, 192, 96, 9, 12, 24, 11, 1, 0, 254, 0,
  255, 0, 195, 128, 193, 128, 195, 128, 255, 0, 255, 0, 195, 128, 193, 128,
  195, 128, 255, 0, 254, 0, 10, 12, 24, 12, 1, 0, 31, 0, 63, 128,
  113, 192, 96, 192, 224, 0, 192, 0, 192, 0, 224, 0, 96, 192, 113, 192,
  63, 128, 31, 0, 10, 12, 24, 12, 1, 0, 252, 0, 255, 0, 195, 128,
  193, 128, 193, 192, 192, 192, 192, 192, 193, 192, 193, 128, 195, 128, 255, 0,
  252, 0, 8, 12, 12, 10, 1, 0, 255, 255, 192, 192, 192, 254, 254, 192,
  192, 192, 255, 255, 8, 12, 12, 10, 1, 0, 255, 255, 192, 192, 192, 254,
  254, 192, 192, 192, 192, 192, 10, 12, 24, 12, 1, 0, 31, 0, 63, 128,
  113, 192, 96, 192, 224, 0, 192, 0, 195, 192, 227, 192, 96, 192, 113, 192,
  63, 192, 30, 192, 10, 12, 24, 12, 1, 0, 192, 192, 192, 192, 192, 192,
  192, 192, 255, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 2, 12, 12, 4, 1, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 7, 12, 12, 9, 1, 0, 6, 6, 6, 6, 6, 6,
  6, 6, 198, 198, 254, 124, 11, 12, 24, 12, 1, 0, 193, 192, 195, 128,
  199, 0, 206, 0, 220, 0, 248, 0, 252, 0, 206, 0, 199, 0, 195, 128,
  193, 192, 192, 224, 8, 12, 12, 10, 1, 0, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 255, 255, 11, 12, 24, 13, 1, 0, 224, 224, 224, 224,
  224, 224, 241, 224, 241, 224, 209, 96, 219, 96, 219, 96, 202, 96, 206, 96,
  206, 96, 196, 96, 10, 12, 24, 12, 1, 0, 224, 192, 240, 192, 240, 192,
  216, 192, 216, 192, 204, 192, 204, 192, 198, 192, 198, 192, 195, 192, 195, 192,
  193, 192, 11, 12, 24, 13, 1, 0, 31, 0, 63, 128, 113, 192, 96, 192,
  224, 224, 192, 96, 192, 96, 224, 224, 96, 192, 113, 192, 63, 128, 31, 0,
  9, 12, 24, 11, 1, 0, 254, 0, 255, 0, 195, 128, 193, 128, 193, 128,
  195, 128, 255, 0, 254, 0, 192, 0, 192, 0, 192, 0, 192, 0, 11, 13,
  26, 13, 1, 255, 31, 0, 63, 128, 113, 192, 96, 192, 224, 224, 192, 96,
  192, 96, 226, 96, 103, 192, 115, 192, 63, 128, 31, 192, 0, 128, 10, 12,
  24, 12, 1, 0, 255, 0, 255, 128, 193, 128, 193, 128, 195, 128, 255, 0,
  255, 0, 195, 128, 193, 128, 193, 128, 193, 192, 193, 192, 9, 12, 24, 11,
  1, 0, 62, 0, 127, 0, 227, 128, 193, 128, 240, 0, 126, 0, 31, 0,
  3, 128, 193, 128, 227, 128, 127, 0, 62, 0, 10, 12, 24, 10, 0, 0,
  255, 192, 255, 192, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0,
  12, 0, 12, 0, 12, 0, 12, 0, 10, 12, 24, 12, 1, 0, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  225, 192, 127, 128, 63, 0, 10, 12, 24, 11, 0, 0, 192, 192, 192, 192,
  97, 128, 97, 128, 97, 128, 51, 0, 51, 0, 51, 0, 30, 0, 30, 0,
  12, 0, 12, 0, 14, 12, 24, 15, 0, 0, 195, 12, 195, 12, 195, 12,
  99, 24, 103, 152, 103, 152, 52, 176, 60, 240, 60, 240, 24, 96, 24, 96,
  24, 96, 9, 12, 24, 11, 1, 0, 193, 128, 227, 128, 99, 0, 54, 0,
  62, 0, 28, 0, 28, 0, 62, 0, 54, 0, 99, 0, 227, 128, 193, 128,
  10, 12, 24, 11, 0, 0, 192, 192, 225, 192, 97, 128, 51, 0, 51, 0,
  30, 0, 30, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 8, 12,
  12, 10, 1, 0, 255, 255, 7, 6, 12, 28, 56, 48, 96, 224, 255, 255,
  4, 15, 15, 6, 1, 253, 240, 240, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 240, 240, 4, 12, 12, 5, 0, 0, 128, 128, 192, 64, 64,
  96, 32, 32, 48, 16, 16, 16, 4, 15, 15, 6, 0, 253, 240, 240, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 240, 240, 8, 7, 7, 10,
  1, 5, 24, 24, 60, 102, 102, 195, 195, 9, 1, 2, 9, 0, 253, 255,
  128, 3, 3, 3, 6, 2, 10, 128, 192, 32, 8, 9, 9, 9, 1, 0,
  124, 254, 198, 14, 126, 230, 198, 254, 119, 8, 12, 12, 10, 1, 0, 192,
  192, 192, 220, 254, 231, 195, 195, 195, 231, 254, 220, 8, 9, 9, 9, 1,
  0, 60, 126, 231, 192, 192, 192, 231, 126, 60, 8, 12, 12, 10, 1, 0,
  3, 3, 3, 63, 127, 231, 195, 195, 195, 231, 127, 59, 8, 9, 9, 10,
  1, 0, 60, 126, 195, 255, 255, 192, 231, 126, 60, 4, 12, 12, 6, 1,
  0, 48, 112, 96, 240, 240, 96, 96, 96, 96, 96, 96, 96, 8, 13, 13,
  10, 1, 252, 59, 127, 231, 195, 195, 195, 231, 127, 59, 3, 231, 126, 60,
  8, 12, 12, 10, 1, 0, 192, 192, 192, 222, 255, 227, 195, 195, 195, 195,
  195, 195, 2, 12, 12, 4, 1, 0, 192, 192, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 3, 16, 16, 5, 1, 252, 96, 96, 0, 96, 96, 96,
  96, 96, 96, 96, 96, 96, 96, 96, 224, 192, 8, 12, 12, 9, 1, 0,
  192, 192, 192, 199, 206, 220, 248, 252, 236, 206, 198, 199, 2, 12, 12, 4,
  1, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 12, 9,
  18, 14, 1, 0, 222, 224, 255, 240, 231, 48, 198, 48, 198, 48, 198, 48,
  198, 48, 198, 48, 198, 48, 8, 9, 9, 10, 1, 0, 222, 255, 227, 195,
  195, 195, 195, 195, 195, 8, 9, 9, 10, 1, 0, 60, 126, 231, 195, 195,
  195, 231, 126, 60, 8, 13, 13, 10, 1, 252, 220, 254, 231, 195, 195, 195,
  231, 254, 220, 192, 192, 192, 192, 8, 13, 13, 10, 1, 252, 59, 127, 231,
  195, 195, 195, 231, 127, 59, 3, 3, 3, 3, 5, 9, 9, 6, 1, 0,
  216, 248, 224, 192, 192, 192, 192, 192, 192, 7, 9, 9, 9, 1, 0, 124,
  254, 198, 240, 124, 14, 198, 254, 124, 4, 11, 11, 6, 1, 0, 96, 96,
  240, 240, 96, 96, 96, 96, 96, 112, 48, 8, 9, 9, 10, 1, 0, 195,
  195, 195, 195, 195, 195, 199, 255, 123, 8, 9, 9, 9, 0, 0, 195, 195,
  102, 102, 102, 60, 60, 24, 24, 12, 9, 18, 13, 0, 0, 198, 48, 198,
  48, 102, 96, 102, 96, 111, 96, 63, 192, 57, 192, 25, 128, 25, 128, 7,
  9, 9, 9, 1, 0, 198, 198, 108, 124, 56, 124, 108, 198, 198, 8, 13,
  13, 9, 0, 252, 195, 195, 99, 102, 54, 54, 60, 28, 24, 24, 24, 112,
  96, 7, 9, 9, 8, 0, 0, 254, 254, 14, 28, 24, 56, 112, 254, 254,
  4, 15, 15, 6, 1, 253, 48, 112, 96, 96, 96, 96, 96, 192, 96, 96,
  96, 96, 96, 112, 48, 1, 16, 16, 4, 1, 252, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 4, 15, 15, 6, 1,
  253, 192, 224, 96, 96, 96, 96, 96, 48, 96, 96, 96, 96, 96, 224, 192,
  8, 3, 3, 10, 1, 3, 113, 153, 142, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 5, 0, 1,
  2, 12, 12, 6, 1, 253, 192, 192, 0, 64, 64, 64, 192, 192, 192, 192,
  192, 192, 8, 11, 11, 9, 0, 255, 4, 60, 126, 239, 200, 216, 208, 247,
  126, 60, 32, 8, 12, 12, 9, 0, 0, 28, 62, 99, 99, 96, 48, 124,
  48, 48, 32, 127, 255, 7, 7, 7, 9, 1, 2, 186, 124, 198, 198, 198,
  124, 186, 8, 12, 12, 9, 0, 0, 195, 195, 102, 102, 60, 24, 126, 24,
  126, 24, 24, 24, 1, 16, 16, 5, 2, 252, 128, 128, 128, 128, 128, 128,
  128, 0, 0, 128, 128, 128, 128, 128, 128, 128, 8, 15, 15, 9, 0, 253,
  60, 126, 102, 96, 120, 126, 199, 195, 243, 126, 30, 6, 102, 126, 60, 5,
  2, 2, 6, 0, 10, 216, 216, 12, 12, 24, 12, 0, 0, 15, 0, 57,
  192, 96, 96, 79, 32, 217, 176, 144, 16, 144, 16, 217, 176, 79, 32, 96,
  32, 57, 192, 15, 0, 5, 7, 7, 6, 1, 5, 96, 144, 112, 144, 120,
  0, 248, 8, 6, 6, 9, 0, 2, 51, 102, 204, 204, 102, 51, 8, 5,
  5, 10, 0, 2, 255, 255, 3, 3, 3, 4, 2, 2, 5, 0, 3, 240,
  240, 12, 12, 24, 12, 0, 0, 15, 0, 57, 192, 96, 96, 95, 32, 217,
  176, 153, 144, 158, 16, 219, 48, 91, 32, 96, 96, 57, 192, 15, 0, 5,
  1, 1, 6, 0, 10, 248, 4, 5, 5, 7, 1, 7, 96, 144, 144, 144,
  96, 8, 11, 11, 10, 1, 0, 24, 24, 24, 255, 255, 24, 24, 24, 0,
  255, 255, 5, 7, 7, 6, 0, 5, 112, 216, 216, 48, 96, 248, 248, 5,
  7, 7, 6, 0, 5, 112, 216, 24, 48, 24, 216, 112, 3, 3, 3, 6,
  1, 10, 32, 96, 128, 8, 12, 12, 10, 1, 253, 195, 195, 195, 195, 195,
  195, 199, 255, 251, 192, 192, 192, 8, 15, 15, 9, 0, 253, 127, 242, 242,
  242, 242, 242, 114, 18, 18, 18, 18, 18, 18, 18, 18, 2, 2, 2, 5,
  1, 4, 192, 192, 5, 4, 4, 6, 0, 252, 32, 48, 152, 112, 4, 7,
  7, 6, 1, 5, 48, 240, 240, 48, 48, 48, 48, 5, 7, 7, 6, 0,
  5, 112, 216, 136, 216, 112, 0, 248, 8, 6, 6, 9, 1, 2, 204, 102,
  51, 51, 102, 204, 13, 12, 24, 14, 1, 0, 48, 192, 240, 128, 241, 128,
  49, 0, 51, 48, 50, 112, 54, 240, 4, 176, 13, 176, 9, 248, 24, 48,
  16, 48, 12, 12, 24, 14, 0, 0, 48, 128, 241, 128, 241, 0, 51, 0,
  50, 0, 54, 224, 53, 176, 13, 176, 8, 96, 24, 192, 17, 240, 49, 240,
  13, 12, 24, 14, 0, 0, 112, 64, 216, 192, 24, 128, 49, 128, 25, 48,
  219, 112, 114, 240, 6, 176, 5, 176, 13, 248, 8, 48, 24, 48, 7, 12,
  12, 10, 1, 253, 48, 48, 0, 48, 48, 96, 224, 192, 198, 198, 254, 124,
  11, 16, 32, 12, 0, 0, 16, 0, 24, 0, 4, 0, 0, 0, 14, 0,
  14, 0, 31, 0, 27, 0, 59, 128, 49, 128, 113, 192, 96, 192, 127, 192,
  255, 224, 192, 96, 192, 96, 11, 16, 32, 12, 0, 0, 2, 0, 6, 0,
  8, 0, 0, 0, 14, 0, 14, 0, 31, 0, 27, 0, 59, 128, 49, 128,
  113, 192, 96, 192, 127, 192, 255, 224, 192, 96, 192, 96, 11, 16, 32, 12,
  0, 0, 4, 0, 14, 0, 17, 0, 0, 0, 14, 0, 14, 0, 31, 0,
  27, 0, 59, 128, 49, 128, 113, 192, 96, 192, 127, 192, 255, 224, 192, 96,
  192, 96, 11, 15, 30, 12, 0, 0, 14, 128, 23, 0, 0, 0, 14, 0,
  14, 0, 31, 0, 27, 0, 59, 128, 49, 128, 113, 192, 96, 192, 127, 192,
  255, 224, 192, 96, 192, 96, 11, 15, 30, 12, 0, 0, 49, 128, 49, 128,
  0, 0, 14, 0, 14, 0, 31, 0, 27, 0, 59, 128, 49, 128, 113, 192,
  96, 192, 127, 192, 255, 224, 192, 96, 192, 96, 11, 16, 32, 12, 0, 0,
  12, 0, 18, 0, 18, 0, 12, 0, 14, 0, 14, 0, 31, 0, 27, 0,
  59, 128, 49, 128, 113, 192, 96, 192, 127, 192, 255, 224, 192, 96, 192, 96,
  14, 12, 24, 15, 0, 0, 31, 252, 31, 252, 27, 0, 51, 0, 51, 0,
  51, 248, 99, 248, 127, 0, 127, 0, 195, 0, 195, 252, 195, 252, 10, 16,
  32, 12, 1, 252, 31, 0, 63, 128, 113, 192, 96, 192, 224, 0, 192, 0,
  192, 0, 224, 0, 96, 192, 113, 192, 63, 128, 31, 0, 4, 0, 6, 0,
  19, 0, 14, 0, 8, 16, 16, 10, 1, 0, 32, 48, 8, 0, 255, 255,
  192, 192, 192, 254, 254, 192, 192, 192, 255, 255, 8, 16, 16, 10, 1, 0,
  4, 12, 16, 0, 255, 255, 192, 192, 192, 254, 254, 192, 192, 192, 255, 255,
  8, 16, 16, 10, 1, 0, 8, 28, 34, 0, 255, 255, 192, 192, 192, 254,
  254, 192, 192, 192, 255, 255, 8, 15, 15, 10, 1, 0, 102, 102, 0, 255,
  255, 192, 192, 192, 254, 254, 192, 192, 192, 255, 255, 3, 16, 16, 4, 0,
  0, 128, 192, 32, 0, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
  96, 3, 16, 16, 4, 1, 0, 32, 96, 128, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 5, 16, 16, 4, 0, 0, 32, 112, 136,
  0, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 6, 15, 15,
  4, 255, 0, 204, 204, 0, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 12, 12, 24, 12, 0, 0, 63, 0, 63, 192, 48, 224, 48, 96,
  48, 112, 252, 48, 252, 48, 48, 112, 48, 96, 48, 224, 63, 192, 63, 0,
  10, 15, 30, 12, 1, 0, 29, 0, 46, 0, 0, 0, 224, 192, 240, 192,
  240, 192, 216, 192, 216, 192, 204, 192, 204, 192, 198, 192, 198, 192, 195, 192,
  195, 192, 193, 192, 11, 16, 32, 13, 1, 0, 8, 0, 12, 0, 2, 0,
  0, 0, 31, 0, 63, 128, 113, 192, 96, 192, 224, 224, 192, 96, 192, 96,
  224, 224, 96, 192, 113, 192, 63, 128, 31, 0, 11, 16, 32, 13, 1, 0,
  1, 0, 3, 0, 4, 0, 0, 0, 31, 0, 63, 128, 113, 192, 96, 192,
  224, 224, 192, 96, 192, 96, 224, 224, 96, 192, 113, 192, 63, 128, 31, 0,
  11, 16, 32, 13, 1, 0, 4, 0, 14, 0, 17, 0, 0, 0, 31, 0,
  63, 128, 113, 192, 96, 192, 224, 224, 192, 96, 192, 96, 224, 224, 96, 192,
  113, 192, 63, 128, 31, 0, 11, 15, 30, 13, 1, 0, 14, 128, 23, 0,
  0, 0, 31, 0, 63, 128, 113, 192, 96, 192, 224, 224, 192, 96, 192, 96,
  224, 224, 96, 192, 113, 192, 63, 128, 31, 0, 11, 15, 30, 13, 1, 0,
  25, 128, 25, 128, 0, 0, 31, 0, 63, 128, 113, 192, 96, 192, 224, 224,
  192, 96, 192, 96, 224, 224, 96, 192, 113, 192, 63, 128, 31, 0, 9, 9,
  18, 10, 0, 0, 65, 0, 227, 128, 119, 0, 62, 0, 28, 0, 62, 0,
  119, 0, 227, 128, 65, 0, 11, 12, 24, 13, 1, 0, 31, 32, 63, 192,
  112, 192, 97, 192, 227, 96, 198, 96, 204, 96, 216, 224, 112, 192, 97, 192,
  127, 128, 159, 0, 10, 16, 32, 12, 1, 0, 16, 0, 24, 0, 4, 0,
  0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 16, 32, 12, 1, 0,
  2, 0, 6, 0, 8, 0, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0,
  10, 16, 32, 12, 1, 0, 4, 0, 14, 0, 17, 0, 0, 0, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  225, 192, 127, 128, 63, 0, 10, 15, 30, 12, 1, 0, 51, 0, 51, 0,
  0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 16, 32, 11, 0, 0,
  2, 0, 6, 0, 8, 0, 0, 0, 192, 192, 225, 192, 97, 128, 51, 0,
  51, 0, 30, 0, 30, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0,
  9, 12, 24, 11, 1, 0, 192, 0, 254, 0, 255, 0, 195, 128, 193, 128,
  193, 128, 195, 128, 255, 0, 254, 0, 192, 0, 192, 0, 192, 0, 8, 12,
  12, 10, 1, 0, 124, 254, 198, 198, 220, 222, 195, 195, 195, 195, 222, 220,
  8, 13, 13, 9, 1, 0, 32, 48, 8, 0, 124, 254, 198, 14, 126, 230,
  198, 254, 119, 8, 13, 13, 9, 1, 0, 4, 12, 16, 0, 124, 254, 198,
  14, 126, 230, 198, 254, 119, 8, 13, 13, 9, 1, 0, 16, 56, 68, 0,
  124, 254, 198, 14, 126, 230, 198, 254, 119, 8, 12, 12, 9, 1, 0, 58,
  92, 0, 124, 254, 198, 14, 126, 230, 198, 254, 119, 8, 12, 12, 9, 1,
  0, 108, 108, 0, 124, 254, 198, 14, 126, 230, 198, 254, 119, 8, 13, 13,
  9, 1, 0, 24, 36, 36, 24, 124, 254, 198, 14, 126, 230, 198, 254, 119,
  13, 9, 18, 15, 1, 0, 125, 224, 255, 240, 198, 24, 15, 248, 127, 248,
  230, 0, 207, 56, 255, 240, 121, 224, 8, 13, 13, 9, 1, 252, 60, 126,
  231, 192, 192, 192, 231, 126, 60, 16, 24, 76, 56, 8, 13, 13, 10, 1,
  0, 32, 48, 8, 0, 60, 126, 195, 255, 255, 192, 231, 126, 60, 8, 13,
  13, 10, 1, 0, 4, 12, 16, 0, 60, 126, 195, 255, 255, 192, 231, 126,
  60, 8, 13, 13, 10, 1, 0, 8, 28, 34, 0, 60, 126, 195, 255, 255,
  192, 231, 126, 60, 8, 12, 12, 10, 1, 0, 54, 54, 0, 60, 126, 195,
  255, 255, 192, 231, 126, 60, 3, 13, 13, 4, 0, 0, 128, 192, 32, 0,
  96, 96, 96, 96, 96, 96, 96, 96, 96, 3, 13, 13, 4, 1, 0, 32,
  96, 128, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 5, 13, 13, 4,
  0, 0, 32, 112, 136, 0, 96, 96, 96, 96, 96, 96, 96, 96, 96, 5,
  12, 12, 4, 0, 0, 216, 216, 0, 96, 96, 96, 96, 96, 96, 96, 96,
  96, 8, 12, 12, 10, 1, 0, 96, 124, 248, 28, 126, 231, 195, 195, 195,
  231, 126, 60, 8, 12, 12, 10, 1, 0, 58, 92, 0, 222, 255, 227, 195,
  195, 195, 195, 195, 195, 8, 13, 13, 10, 1, 0, 32, 48, 8, 0, 60,
  126, 231, 195, 195, 195, 231, 126, 60, 8, 13, 13, 10, 1, 0, 8, 24,
  32, 0, 60, 126, 231, 195, 195, 195, 231, 126, 60, 8, 13, 13, 10, 1,
  0, 16, 56, 68, 0, 60, 126, 231, 195, 195, 195, 231, 126, 60, 8, 12,
  12, 10, 1, 0, 58, 92, 0, 60, 126, 231, 195, 195, 195, 231, 126, 60,
  8, 12, 12, 10, 1, 0, 108, 108, 0, 60, 126, 231, 195, 195, 195, 231,
  126, 60, 8, 8, 8, 10, 1, 0, 24, 24, 0, 255, 255, 0, 24, 24,
  8, 9, 9, 10, 1, 0, 61, 127, 231, 207, 219, 243, 231, 254, 188, 8,
  13, 13, 10, 1, 0, 32, 48, 8, 0, 195, 195, 195, 195, 195, 195, 199,
  255, 123, 8, 13, 13, 10, 1, 0, 8, 24, 32, 0, 195, 195, 195, 195,
  195, 195, 199, 255, 123, 8, 13, 13, 10, 1, 0, 16, 56, 68, 0, 195,
  195, 195, 195, 195, 195, 199, 255, 123, 8, 12, 12, 10, 1, 0, 108, 108,
  0, 195, 195, 195, 195, 195, 195, 199, 255, 123, 8, 17, 17, 9, 0, 252,
  4, 12, 16, 0, 195, 195, 99, 102, 54, 54, 60, 28, 24, 24, 24, 112,
  96, 8, 16, 16, 10, 1, 252, 192, 192, 192, 220, 254, 231, 195, 195, 195,
  231, 254, 220, 192, 192, 192, 192, 8, 16, 16, 9, 0, 252, 54, 54, 0,
  195, 195, 99, 102, 54, 54, 60, 28, 24, 24, 24, 112, 96
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--17-120-100-100-P-92-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 0, '1' Height: 12
  Calculated Max Values w= 8 h=12 x= 2 y= 7 dx=10 dy= 0 ascent=12 len=12
  Font Bounding box     w=20 h=27 x=-2 y=-7
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =12 descent= 0
  X Font      ascent =12 descent= 0
  Max Font    ascent =12 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_helvB12n[281] U8G_FONT_SECTION("u8g_font_helvB12n") = {
  0, 20, 27, 254, 249, 12, 0, 0, 0, 0, 42, 58, 0, 12, 253, 12,
  0, 5, 5, 5, 6, 0, 7, 32, 168, 112, 112, 136, 8, 8, 8, 10,
  1, 0, 24, 24, 24, 255, 255, 24, 24, 24, 2, 5, 5, 4, 1, 253,
  192, 192, 64, 64, 128, 4, 2, 2, 5, 0, 3, 240, 240, 2, 2, 2,
  4, 1, 0, 192, 192, 4, 12, 12, 5, 0, 0, 16, 16, 48, 32, 32,
  96, 64, 64, 192, 128, 128, 128, 8, 12, 12, 9, 0, 0, 60, 126, 231,
  195, 195, 195, 195, 195, 195, 231, 126, 60, 5, 12, 12, 9, 1, 0, 8,
  24, 248, 248, 24, 24, 24, 24, 24, 24, 24, 24, 8, 12, 12, 9, 0,
  0, 60, 126, 231, 195, 195, 7, 14, 28, 56, 112, 255, 255, 8, 12, 12,
  9, 0, 0, 60, 126, 231, 195, 7, 30, 30, 7, 195, 231, 126, 60, 8,
  12, 12, 9, 0, 0, 14, 30, 54, 54, 102, 102, 198, 255, 255, 6, 6,
  6, 8, 12, 12, 9, 0, 0, 63, 63, 48, 48, 124, 126, 71, 3, 3,
  231, 126, 60, 8, 12, 12, 9, 0, 0, 60, 126, 231, 192, 220, 254, 231,
  195, 195, 231, 126, 60, 8, 12, 12, 9, 0, 0, 255, 255, 6, 6, 12,
  12, 24, 24, 24, 48, 48, 48, 8, 12, 12, 9, 0, 0, 60, 126, 231,
  195, 102, 60, 126, 231, 195, 231, 126, 60, 8, 12, 12, 9, 0, 0, 60,
  126, 231, 195, 195, 231, 127, 59, 3, 231, 126, 60, 2, 8, 8, 5, 2,
  0, 192, 192, 0, 0, 0, 0, 192, 192
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--17-120-100-100-P-92-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 12, '1' Height: 12
  Calculated Max Values w=14 h=16 x= 2 y=10 dx=16 dy= 0 ascent=13 len=28
  Font Bounding box     w=20 h=27 x=-2 y=-7
  Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
  Pure Font   ascent =12 descent=-4
  X Font      ascent =12 descent=-4
  Max Font    ascent =13 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_helvB12r[1914] U8G_FONT_SECTION("u8g_font_helvB12r") = {
  0, 20, 27, 254, 249, 12, 2, 74, 5, 106, 32, 127, 252, 13, 252, 12,
  252, 0, 0, 0, 5, 0, 1, 2, 12, 12, 6, 2, 0, 192, 192, 192,
  192, 192, 192, 128, 128, 128, 0, 192, 192, 5, 4, 4, 8, 1, 8, 216,
  216, 216, 72, 9, 12, 24, 9, 0, 0, 27, 0, 27, 0, 27, 0, 127,
  128, 127, 128, 54, 0, 54, 0, 255, 0, 255, 0, 108, 0, 108, 0, 108,
  0, 7, 14, 14, 9, 1, 255, 16, 124, 254, 214, 208, 240, 120, 60, 30,
  22, 214, 254, 124, 16, 13, 12, 24, 14, 0, 0, 48, 64, 120, 128, 204,
  128, 205, 0, 121, 0, 50, 0, 2, 96, 4, 240, 5, 152, 9, 152, 8,
  240, 16, 96, 10, 12, 24, 12, 1, 0, 60, 0, 126, 0, 102, 0, 102,
  0, 60, 0, 56, 192, 125, 192, 207, 128, 199, 0, 199, 0, 127, 128, 57,
  192, 2, 4, 4, 4, 1, 8, 192, 192, 192, 64, 4, 15, 15, 6, 1,
  253, 48, 112, 96, 192, 192, 192, 192, 192, 192, 192, 192, 192, 96, 112, 48,
  4, 15, 15, 6, 0, 253, 192, 224, 96, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 96, 224, 192, 5, 5, 5, 6, 0, 7, 32, 168, 112, 112, 136,
  8, 8, 8, 10, 1, 0, 24, 24, 24, 255, 255, 24, 24, 24, 2, 5,
  5, 4, 1, 253, 192, 192, 64, 64, 128, 4, 2, 2, 5, 0, 3, 240,
  240, 2, 2, 2, 4, 1, 0, 192, 192, 4, 12, 12, 5, 0, 0, 16,
  16, 48, 32, 32, 96, 64, 64, 192, 128, 128, 128, 8, 12, 12, 9, 0,
  0, 60, 126, 231, 195, 195, 195, 195, 195, 195, 231, 126, 60, 5, 12, 12,
  9, 1, 0, 8, 24, 248, 248, 24, 24, 24, 24, 24, 24, 24, 24, 8,
  12, 12, 9, 0, 0, 60, 126, 231, 195, 195, 7, 14, 28, 56, 112, 255,
  255, 8, 12, 12, 9, 0, 0, 60, 126, 231, 195, 7, 30, 30, 7, 195,
  231, 126, 60, 8, 12, 12, 9, 0, 0, 14, 30, 54, 54, 102, 102, 198,
  255, 255, 6, 6, 6, 8, 12, 12, 9, 0, 0, 63, 63, 48, 48, 124,
  126, 71, 3, 3, 231, 126, 60, 8, 12, 12, 9, 0, 0, 60, 126, 231,
  192, 220, 254, 231, 195, 195, 231, 126, 60, 8, 12, 12, 9, 0, 0, 255,
  255, 6, 6, 12, 12, 24, 24, 24, 48, 48, 48, 8, 12, 12, 9, 0,
  0, 60, 126, 231, 195, 102, 60, 126, 231, 195, 231, 126, 60, 8, 12, 12,
  9, 0, 0, 60, 126, 231, 195, 195, 231, 127, 59, 3, 231, 126, 60, 2,
  8, 8, 5, 2, 0, 192, 192, 0, 0, 0, 0, 192, 192, 2, 11, 11,
  5, 2, 253, 192, 192, 0, 0, 0, 0, 192, 192, 64, 64, 128, 8, 8,
  8, 10, 1, 0, 3, 15, 60, 224, 224, 60, 15, 3, 8, 6, 6, 10,
  1, 1, 255, 255, 0, 0, 255, 255, 8, 8, 8, 10, 1, 0, 192, 240,
  60, 7, 7, 60, 240, 192, 7, 12, 12, 10, 1, 0, 124, 254, 198, 198,
  6, 14, 12, 24, 24, 0, 24, 24, 13, 14, 28, 16, 1, 254, 15, 192,
  56, 96, 96, 16, 71, 216, 204, 72, 136, 200, 152, 200, 152, 136, 153, 152,
  201, 144, 70, 96, 96, 0, 56, 192, 15, 128, 11, 12, 24, 12, 0, 0,
  14, 0, 14, 0, 31, 0, 27, 0, 59, 128, 49, 128, 113, 192, 96, 192,
  127, 192, 255, 224, 192, 96, 192, 96, 9, 12, 24, 11, 1, 0, 254, 0,
  255, 0, 195, 128, 193, 128, 195, 128, 255, 0, 255, 0, 195, 128, 193, 128,
  195, 128, 255, 0, 254, 0, 10, 12, 24, 12, 1, 0, 31, 0, 63, 128,
  113, 192, 96, 192, 224, 0, 192, 0, 192, 0, 224, 0, 96, 192, 113, 192,
  63, 128, 31, 0, 10, 12, 24, 12, 1, 0, 252, 0, 255, 0, 195, 128,
  193, 128, 193, 192, 192, 192, 192, 192, 193, 192, 193, 128, 195, 128, 255, 0,
  252, 0, 8, 12, 12, 10, 1, 0, 255, 255, 192, 192, 192, 254, 254, 192,
  192, 192, 255, 255, 8, 12, 12, 10, 1, 0, 255, 255, 192, 192, 192, 254,
  254, 192, 192, 192, 192, 192, 10, 12, 24, 12, 1, 0, 31, 0, 63, 128,
  113, 192, 96, 192, 224, 0, 192, 0, 195, 192, 227, 192, 96, 192, 113, 192,
  63, 192, 30, 192, 10, 12, 24, 12, 1, 0, 192, 192, 192, 192, 192, 192,
  192, 192, 255, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 2, 12, 12, 4, 1, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 7, 12, 12, 9, 1, 0, 6, 6, 6, 6, 6, 6,
  6, 6, 198, 198, 254, 124, 11, 12, 24, 12, 1, 0, 193, 192, 195, 128,
  199, 0, 206, 0, 220, 0, 248, 0, 252, 0, 206, 0, 199, 0, 195, 128,
  193, 192, 192, 224, 8, 12, 12, 10, 1, 0, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 255, 255, 11, 12, 24, 13, 1, 0, 224, 224, 224, 224,
  224, 224, 241, 224, 241, 224, 209, 96, 219, 96, 219, 96, 202, 96, 206, 96,
  206, 96, 196, 96, 10, 12, 24, 12, 1, 0, 224, 192, 240, 192, 240, 192,
  216, 192, 216, 192, 204, 192, 204, 192, 198, 192, 198, 192, 195, 192, 195, 192,
  193, 192, 11, 12, 24, 13, 1, 0, 31, 0, 63, 128, 113, 192, 96, 192,
  224, 224, 192, 96, 192, 96, 224, 224, 96, 192, 113, 192, 63, 128, 31, 0,
  9, 12, 24, 11, 1, 0, 254, 0, 255, 0, 195, 128, 193, 128, 193, 128,
  195, 128, 255, 0, 254, 0, 192, 0, 192, 0, 192, 0, 192, 0, 11, 13,
  26, 13, 1, 255, 31, 0, 63, 128, 113, 192, 96, 192, 224, 224, 192, 96,
  192, 96, 226, 96, 103, 192, 115, 192, 63, 128, 31, 192, 0, 128, 10, 12,
  24, 12, 1, 0, 255, 0, 255, 128, 193, 128, 193, 128, 195, 128, 255, 0,
  255, 0, 195, 128, 193, 128, 193, 128, 193, 192, 193, 192, 9, 12, 24, 11,
  1, 0, 62, 0, 127, 0, 227, 128, 193, 128, 240, 0, 126, 0, 31, 0,
  3, 128, 193, 128, 227, 128, 127, 0, 62, 0, 10, 12, 24, 10, 0, 0,
  255, 192, 255, 192, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0,
  12, 0, 12, 0, 12, 0, 12, 0, 10, 12, 24, 12, 1, 0, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  225, 192, 127, 128, 63, 0, 10, 12, 24, 11, 0, 0, 192, 192, 192, 192,
  97, 128, 97, 128, 97, 128, 51, 0, 51, 0, 51, 0, 30, 0, 30, 0,
  12, 0, 12, 0, 14, 12, 24, 15, 0, 0, 195, 12, 195, 12, 195, 12,
  99, 24, 103, 152, 103, 152, 52, 176, 60, 240, 60, 240, 24, 96, 24, 96,
  24, 96, 9, 12, 24, 11, 1, 0, 193, 128, 227, 128, 99, 0, 54, 0,
  62, 0, 28, 0, 28, 0, 62, 0, 54, 0, 99, 0, 227, 128, 193, 128,
  10, 12, 24, 11, 0, 0, 192, 192, 225, 192, 97, 128, 51, 0, 51, 0,
  30, 0, 30, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 8, 12,
  12, 10, 1, 0, 255, 255, 7, 6, 12, 28, 56, 48, 96, 224, 255, 255,
  4, 15, 15, 6, 1, 253, 240, 240, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 240, 240, 4, 12, 12, 5, 0, 0, 128, 128, 192, 64, 64,
  96, 32, 32, 48, 16, 16, 16, 4, 15, 15, 6, 0, 253, 240, 240, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 240, 240, 8, 7, 7, 10,
  1, 5, 24, 24, 60, 102, 102, 195, 195, 9, 1, 2, 9, 0, 253, 255,
  128, 3, 3, 3, 6, 2, 10, 128, 192, 32, 8, 9, 9, 9, 1, 0,
  124, 254, 198, 14, 126, 230, 198, 254, 119, 8, 12, 12, 10, 1, 0, 192,
  192, 192, 220, 254, 231, 195, 195, 195, 231, 254, 220, 8, 9, 9, 9, 1,
  0, 60, 126, 231, 192, 192, 192, 231, 126, 60, 8, 12, 12, 10, 1, 0,
  3, 3, 3, 63, 127, 231, 195, 195, 195, 231, 127, 59, 8, 9, 9, 10,
  1, 0, 60, 126, 195, 255, 255, 192, 231, 126, 60, 4, 12, 12, 6, 1,
  0, 48, 112, 96, 240, 240, 96, 96, 96, 96, 96, 96, 96, 8, 13, 13,
  10, 1, 252, 59, 127, 231, 195, 195, 195, 231, 127, 59, 3, 231, 126, 60,
  8, 12, 12, 10, 1, 0, 192, 192, 192, 222, 255, 227, 195, 195, 195, 195,
  195, 195, 2, 12, 12, 4, 1, 0, 192, 192, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 3, 16, 16, 5, 1, 252, 96, 96, 0, 96, 96, 96,
  96, 96, 96, 96, 96, 96, 96, 96, 224, 192, 8, 12, 12, 9, 1, 0,
  192, 192, 192, 199, 206, 220, 248, 252, 236, 206, 198, 199, 2, 12, 12, 4,
  1, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 12, 9,
  18, 14, 1, 0, 222, 224, 255, 240, 231, 48, 198, 48, 198, 48, 198, 48,
  198, 48, 198, 48, 198, 48, 8, 9, 9, 10, 1, 0, 222, 255, 227, 195,
  195, 195, 195, 195, 195, 8, 9, 9, 10, 1, 0, 60, 126, 231, 195, 195,
  195, 231, 126, 60, 8, 13, 13, 10, 1, 252, 220, 254, 231, 195, 195, 195,
  231, 254, 220, 192, 192, 192, 192, 8, 13, 13, 10, 1, 252, 59, 127, 231,
  195, 195, 195, 231, 127, 59, 3, 3, 3, 3, 5, 9, 9, 6, 1, 0,
  216, 248, 224, 192, 192, 192, 192, 192, 192, 7, 9, 9, 9, 1, 0, 124,
  254, 198, 240, 124, 14, 198, 254, 124, 4, 11, 11, 6, 1, 0, 96, 96,
  240, 240, 96, 96, 96, 96, 96, 112, 48, 8, 9, 9, 10, 1, 0, 195,
  195, 195, 195, 195, 195, 199, 255, 123, 8, 9, 9, 9, 0, 0, 195, 195,
  102, 102, 102, 60, 60, 24, 24, 12, 9, 18, 13, 0, 0, 198, 48, 198,
  48, 102, 96, 102, 96, 111, 96, 63, 192, 57, 192, 25, 128, 25, 128, 7,
  9, 9, 9, 1, 0, 198, 198, 108, 124, 56, 124, 108, 198, 198, 8, 13,
  13, 9, 0, 252, 195, 195, 99, 102, 54, 54, 60, 28, 24, 24, 24, 112,
  96, 7, 9, 9, 8, 0, 0, 254, 254, 14, 28, 24, 56, 112, 254, 254,
  4, 15, 15, 6, 1, 253, 48, 112, 96, 96, 96, 96, 96, 192, 96, 96,
  96, 96, 96, 112, 48, 1, 16, 16, 4, 1, 252, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 4, 15, 15, 6, 1,
  253, 192, 224, 96, 96, 96, 96, 96, 48, 96, 96, 96, 96, 96, 224, 192,
  8, 3, 3, 10, 1, 3, 113, 153, 142, 255
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--20-140-100-100-P-105-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 14, '1' Height: 13
  Calculated Max Values w=16 h=19 x= 2 y=12 dx=18 dy= 0 ascent=18 len=38
  Font Bounding box     w=22 h=29 x=-2 y=-7
  Calculated Min Values           x=-1 y=-5 dx= 0 dy= 0
  Pure Font   ascent =14 descent=-4
  X Font      ascent =14 descent=-4
  Max Font    ascent =18 descent=-5
*/
const u8g_fntpgm_uint8_t u8g_font_helvB14[5489] U8G_FONT_SECTION("u8g_font_helvB14") = {
  0, 22, 29, 254, 249, 14, 3, 23, 6, 234, 32, 255, 252, 18, 251, 14,
  252, 0, 0, 0, 5, 0, 1, 3, 14, 14, 5, 1, 0, 224, 224, 224,
  224, 224, 224, 224, 224, 192, 192, 0, 224, 224, 224, 5, 5, 5, 7, 1,
  9, 216, 216, 216, 216, 144, 11, 13, 26, 11, 0, 0, 13, 128, 13, 128,
  13, 128, 127, 224, 127, 224, 27, 0, 27, 0, 27, 0, 255, 192, 255, 192,
  54, 0, 54, 0, 54, 0, 10, 16, 32, 10, 0, 254, 4, 0, 63, 0,
  127, 128, 229, 128, 228, 0, 228, 0, 124, 0, 63, 0, 15, 128, 9, 192,
  233, 192, 233, 192, 127, 128, 63, 0, 8, 0, 8, 0, 13, 13, 26, 16,
  1, 0, 120, 96, 252, 96, 204, 192, 204, 128, 253, 128, 123, 0, 2, 0,
  6, 240, 13, 248, 9, 152, 25, 152, 49, 248, 48, 240, 13, 14, 28, 14,
  1, 0, 30, 0, 63, 0, 115, 128, 97, 128, 115, 0, 62, 0, 28, 96,
  126, 96, 231, 224, 195, 192, 193, 192, 227, 224, 127, 112, 62, 56, 2, 5,
  5, 4, 1, 9, 192, 192, 192, 192, 128, 6, 18, 18, 7, 1, 252, 28,
  56, 48, 112, 96, 224, 224, 224, 224, 224, 224, 224, 224, 96, 112, 48, 56,
  28, 6, 18, 18, 7, 0, 252, 224, 112, 48, 56, 24, 28, 28, 28, 28,
  28, 28, 28, 28, 24, 56, 48, 112, 224, 7, 6, 6, 9, 1, 8, 16,
  214, 124, 56, 108, 68, 8, 8, 8, 11, 1, 1, 24, 24, 24, 255, 255,
  24, 24, 24, 3, 6, 6, 5, 1, 253, 224, 224, 224, 96, 192, 128, 5,
  3, 3, 6, 0, 4, 248, 248, 248, 3, 3, 3, 5, 1, 0, 224, 224,
  224, 5, 14, 14, 5, 0, 0, 24, 24, 24, 56, 48, 48, 48, 112, 96,
  96, 224, 192, 192, 192, 9, 13, 26, 10, 0, 0, 28, 0, 127, 0, 119,
  0, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 119,
  0, 127, 0, 28, 0, 6, 13, 13, 10, 1, 0, 28, 60, 252, 252, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 9, 13, 26, 10, 0, 0, 62, 0,
  127, 0, 227, 128, 227, 128, 3, 128, 7, 0, 31, 0, 62, 0, 120, 0,
  112, 0, 224, 0, 255, 128, 255, 128, 9, 13, 26, 10, 0, 0, 62, 0,
  127, 0, 231, 0, 227, 0, 7, 0, 30, 0, 31, 0, 7, 128, 3, 128,
  227, 128, 231, 128, 127, 0, 62, 0, 9, 13, 26, 10, 0, 0, 7, 0,
  15, 0, 31, 0, 63, 0, 55, 0, 119, 0, 103, 0, 231, 0, 255, 128,
  255, 128, 7, 0, 7, 0, 7, 0, 9, 13, 26, 10, 0, 0, 255, 0,
  255, 0, 224, 0, 224, 0, 254, 0, 255, 0, 231, 128, 3, 128, 3, 128,
  227, 128, 231, 128, 255, 0, 126, 0, 9, 13, 26, 10, 0, 0, 63, 0,
  127, 128, 113, 128, 224, 0, 238, 0, 255, 0, 243, 128, 225, 128, 225, 128,
  225, 128, 243, 128, 127, 0, 62, 0, 9, 13, 26, 10, 0, 0, 255, 128,
  255, 128, 3, 128, 7, 0, 14, 0, 14, 0, 28, 0, 28, 0, 56, 0,
  56, 0, 112, 0, 112, 0, 112, 0, 9, 13, 26, 10, 0, 0, 62, 0,
  127, 0, 227, 128, 227, 128, 227, 128, 127, 0, 62, 0, 119, 0, 227, 128,
  227, 128, 227, 128, 127, 0, 62, 0, 9, 13, 26, 10, 0, 0, 62, 0,
  127, 0, 231, 128, 195, 128, 195, 128, 195, 128, 231, 128, 127, 128, 59, 128,
  3, 128, 199, 0, 255, 0, 126, 0, 3, 10, 10, 6, 1, 0, 224, 224,
  224, 0, 0, 0, 0, 224, 224, 224, 3, 13, 13, 6, 1, 253, 224, 224,
  224, 0, 0, 0, 0, 224, 224, 224, 96, 192, 128, 9, 9, 18, 11, 1,
  0, 3, 128, 15, 128, 62, 0, 120, 0, 224, 0, 120, 0, 62, 0, 15,
  128, 3, 128, 9, 5, 10, 11, 1, 3, 255, 128, 255, 128, 0, 0, 255,
  128, 255, 128, 9, 9, 18, 11, 1, 0, 224, 0, 248, 0, 62, 0, 15,
  0, 3, 128, 15, 0, 62, 0, 248, 0, 224, 0, 8, 14, 14, 10, 1,
  0, 126, 255, 231, 231, 14, 30, 28, 56, 56, 56, 0, 56, 56, 56, 16,
  17, 34, 18, 1, 253, 7, 240, 31, 252, 60, 30, 112, 6, 99, 183, 231,
  243, 198, 99, 204, 99, 204, 195, 204, 198, 204, 198, 239, 252, 231, 184, 112,
  0, 60, 0, 31, 240, 7, 240, 12, 14, 28, 14, 1, 0, 15, 0, 15,
  0, 31, 128, 25, 128, 25, 128, 57, 192, 57, 192, 48, 192, 112, 224, 127,
  224, 127, 224, 224, 112, 224, 112, 224, 112, 11, 14, 28, 14, 2, 0, 254,
  0, 255, 128, 227, 192, 225, 192, 225, 192, 227, 128, 255, 128, 255, 192, 225,
  224, 224, 224, 224, 224, 225, 224, 255, 192, 255, 0, 12, 14, 28, 14, 1,
  0, 15, 128, 63, 224, 120, 224, 112, 112, 240, 112, 224, 0, 224, 0, 224,
  0, 224, 0, 240, 112, 112, 112, 120, 224, 63, 224, 15, 128, 12, 14, 28,
  14, 1, 0, 255, 0, 255, 192, 225, 224, 224, 224, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 224, 112, 224, 224, 225, 224, 255, 192, 255, 0, 10,
  14, 28, 13, 2, 0, 255, 192, 255, 192, 224, 0, 224, 0, 224, 0, 224,
  0, 255, 128, 255, 128, 224, 0, 224, 0, 224, 0, 224, 0, 255, 192, 255,
  192, 10, 14, 28, 12, 1, 0, 255, 192, 255, 192, 224, 0, 224, 0, 224,
  0, 224, 0, 255, 128, 255, 128, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 12, 14, 28, 15, 1, 0, 15, 128, 63, 224, 120, 224, 112,
  112, 240, 112, 224, 0, 224, 0, 227, 240, 227, 240, 240, 112, 112, 112, 120,
  240, 63, 240, 31, 176, 12, 14, 28, 14, 1, 0, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 224, 112, 255, 240, 255, 240, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 224, 112, 3, 14, 14, 5, 1, 0, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 9, 14, 28, 10, 0,
  0, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3,
  128, 3, 128, 227, 128, 227, 128, 247, 128, 127, 0, 62, 0, 13, 14, 28,
  14, 1, 0, 224, 240, 225, 224, 227, 192, 231, 128, 239, 0, 254, 0, 252,
  0, 254, 0, 239, 0, 231, 128, 227, 192, 225, 224, 224, 240, 224, 120, 9,
  14, 28, 11, 1, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 128, 255,
  128, 14, 14, 28, 16, 1, 0, 224, 28, 224, 28, 240, 60, 240, 60, 248,
  124, 248, 124, 248, 124, 236, 220, 236, 220, 236, 220, 231, 156, 231, 156, 227,
  28, 227, 28, 12, 14, 28, 14, 1, 0, 224, 112, 240, 112, 240, 112, 248,
  112, 252, 112, 236, 112, 238, 112, 230, 112, 231, 112, 227, 112, 225, 240, 225,
  240, 224, 240, 224, 112, 13, 14, 28, 15, 1, 0, 15, 128, 63, 224, 120,
  240, 112, 112, 240, 120, 224, 56, 224, 56, 224, 56, 224, 56, 240, 120, 112,
  112, 120, 240, 63, 224, 15, 128, 11, 14, 28, 13, 1, 0, 255, 0, 255,
  192, 225, 224, 224, 224, 224, 224, 224, 224, 225, 224, 255, 192, 255, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 13, 15, 30, 15, 1, 255, 15,
  128, 63, 224, 120, 240, 112, 112, 240, 120, 224, 56, 224, 56, 224, 56, 224,
  56, 243, 120, 115, 240, 121, 240, 63, 224, 15, 240, 0, 48, 12, 14, 28,
  14, 1, 0, 255, 0, 255, 192, 225, 224, 224, 224, 224, 224, 225, 224, 255,
  192, 255, 128, 225, 192, 224, 224, 224, 224, 224, 224, 224, 224, 224, 240, 11,
  14, 28, 13, 1, 0, 63, 128, 127, 192, 241, 224, 224, 224, 240, 0, 126,
  0, 63, 128, 15, 192, 1, 224, 224, 224, 224, 224, 241, 224, 127, 192, 63,
  128, 11, 14, 28, 11, 0, 0, 255, 224, 255, 224, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 12, 14, 28, 14, 1, 0, 224, 112, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 112,
  224, 127, 224, 31, 128, 13, 14, 28, 13, 0, 0, 224, 56, 224, 56, 112,
  112, 112, 112, 48, 96, 56, 224, 56, 224, 29, 192, 29, 192, 13, 128, 15,
  128, 15, 128, 7, 0, 7, 0, 15, 14, 28, 17, 1, 0, 227, 142, 227,
  142, 227, 142, 227, 142, 115, 156, 115, 156, 115, 156, 118, 220, 54, 216, 54,
  216, 62, 248, 28, 112, 28, 112, 28, 112, 12, 14, 28, 12, 0, 0, 224,
  112, 224, 112, 112, 224, 121, 224, 25, 128, 31, 128, 15, 0, 31, 128, 25,
  128, 57, 192, 112, 224, 112, 224, 224, 112, 224, 112, 13, 14, 28, 13, 0,
  0, 224, 56, 224, 56, 112, 112, 56, 224, 56, 224, 29, 192, 29, 192, 15,
  128, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 10, 14, 28,
  12, 1, 0, 255, 192, 255, 192, 1, 192, 3, 128, 7, 0, 7, 0, 14,
  0, 28, 0, 56, 0, 56, 0, 112, 0, 224, 0, 255, 192, 255, 192, 5,
  18, 18, 6, 1, 252, 248, 248, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 248, 248, 5, 14, 14, 5, 0, 0, 192, 192, 192,
  224, 96, 96, 96, 112, 48, 48, 56, 24, 24, 24, 5, 18, 18, 6, 0,
  252, 248, 248, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 248, 248, 10, 7, 14, 10, 0, 6, 12, 0, 30, 0, 30, 0, 51,
  0, 115, 128, 97, 128, 225, 192, 10, 2, 4, 10, 0, 252, 255, 192, 255,
  192, 5, 3, 3, 5, 0, 11, 224, 112, 56, 10, 10, 20, 11, 1, 0,
  62, 0, 127, 0, 99, 128, 7, 128, 63, 128, 123, 128, 227, 128, 231, 128,
  251, 128, 123, 192, 10, 14, 28, 12, 1, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 239, 0, 255, 128, 243, 128, 225, 192, 225, 192, 225, 192, 225, 192,
  243, 128, 255, 128, 239, 0, 9, 10, 20, 11, 1, 0, 30, 0, 127, 128,
  115, 128, 224, 0, 224, 0, 224, 0, 224, 0, 115, 128, 127, 128, 30, 0,
  10, 14, 28, 12, 1, 0, 1, 192, 1, 192, 1, 192, 1, 192, 61, 192,
  127, 192, 115, 192, 225, 192, 225, 192, 225, 192, 225, 192, 115, 192, 127, 192,
  61, 192, 9, 10, 20, 11, 1, 0, 30, 0, 127, 0, 115, 128, 225, 128,
  255, 128, 255, 128, 224, 0, 115, 128, 127, 128, 30, 0, 7, 14, 14, 7,
  0, 0, 30, 62, 56, 56, 254, 254, 56, 56, 56, 56, 56, 56, 56, 56,
  10, 14, 28, 12, 1, 252, 61, 192, 127, 192, 115, 192, 225, 192, 225, 192,
  225, 192, 225, 192, 115, 192, 127, 192, 61, 192, 1, 192, 115, 128, 127, 128,
  30, 0, 9, 14, 28, 11, 1, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  239, 0, 255, 128, 243, 128, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128,
  227, 128, 227, 128, 3, 14, 14, 5, 1, 0, 224, 224, 224, 0, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 5, 18, 18, 5, 255, 252, 56, 56,
  56, 0, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 248, 240,
  9, 14, 28, 10, 1, 0, 224, 0, 224, 0, 224, 0, 224, 0, 231, 0,
  238, 0, 252, 0, 248, 0, 248, 0, 252, 0, 238, 0, 231, 0, 231, 128,
  227, 128, 3, 14, 14, 5, 1, 0, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 15, 10, 20, 17, 1, 0, 239, 60, 255, 254,
  243, 206, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142,
  9, 10, 20, 11, 1, 0, 239, 0, 255, 128, 243, 128, 227, 128, 227, 128,
  227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 10, 10, 20, 12, 1, 0,
  30, 0, 127, 128, 115, 128, 225, 192, 225, 192, 225, 192, 225, 192, 115, 128,
  127, 128, 30, 0, 10, 14, 28, 12, 1, 252, 239, 0, 255, 128, 243, 128,
  225, 192, 225, 192, 225, 192, 225, 192, 243, 128, 255, 128, 239, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 10, 14, 28, 12, 1, 252, 61, 192, 127, 192,
  115, 192, 225, 192, 225, 192, 225, 192, 225, 192, 115, 192, 127, 192, 61, 192,
  1, 192, 1, 192, 1, 192, 1, 192, 6, 10, 10, 7, 1, 0, 236, 252,
  252, 224, 224, 224, 224, 224, 224, 224, 9, 10, 20, 11, 1, 0, 63, 0,
  127, 128, 227, 128, 224, 0, 255, 0, 63, 128, 3, 128, 227, 128, 255, 0,
  126, 0, 6, 13, 13, 6, 0, 0, 112, 112, 112, 252, 252, 112, 112, 112,
  112, 112, 112, 124, 60, 9, 10, 20, 11, 1, 0, 227, 128, 227, 128, 227,
  128, 227, 128, 227, 128, 227, 128, 227, 128, 231, 128, 255, 128, 123, 128, 9,
  10, 20, 9, 0, 0, 227, 128, 227, 128, 227, 128, 119, 0, 119, 0, 119,
  0, 62, 0, 62, 0, 28, 0, 28, 0, 15, 10, 20, 15, 0, 0, 227,
  142, 227, 142, 227, 142, 115, 156, 119, 220, 118, 220, 62, 248, 60, 120, 28,
  112, 28, 112, 9, 10, 20, 11, 1, 0, 227, 128, 227, 128, 119, 0, 62,
  0, 28, 0, 62, 0, 119, 0, 119, 0, 227, 128, 227, 128, 9, 14, 28,
  11, 1, 252, 227, 128, 227, 128, 227, 128, 119, 0, 119, 0, 119, 0, 62,
  0, 62, 0, 28, 0, 28, 0, 28, 0, 24, 0, 120, 0, 112, 0, 8,
  10, 10, 10, 1, 0, 255, 255, 7, 14, 28, 56, 112, 224, 255, 255, 7,
  18, 18, 8, 1, 252, 14, 28, 56, 56, 56, 56, 56, 112, 224, 112, 56,
  56, 56, 56, 56, 56, 28, 14, 2, 18, 18, 5, 1, 252, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 7,
  18, 18, 8, 0, 252, 224, 112, 56, 56, 56, 56, 56, 28, 14, 28, 56,
  56, 56, 56, 56, 56, 112, 224, 9, 3, 6, 11, 1, 4, 121, 128, 255,
  128, 207, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 0, 0, 0, 5, 0, 1, 3, 14, 14, 6, 2, 252,
  224, 224, 224, 0, 96, 96, 224, 224, 224, 224, 224, 224, 224, 224, 8, 14,
  14, 10, 1, 254, 2, 2, 62, 127, 231, 200, 200, 208, 208, 227, 127, 126,
  64, 64, 10, 13, 26, 11, 0, 0, 31, 0, 63, 192, 113, 192, 112, 0,
  112, 0, 56, 0, 127, 0, 28, 0, 28, 0, 56, 0, 112, 192, 255, 192,
  239, 128, 9, 8, 16, 11, 1, 2, 193, 128, 255, 128, 119, 0, 99, 0,
  99, 0, 119, 0, 255, 128, 193, 128, 9, 13, 26, 10, 0, 0, 227, 128,
  227, 128, 227, 128, 119, 0, 119, 0, 62, 0, 255, 128, 28, 0, 255, 128,
  28, 0, 28, 0, 28, 0, 28, 0, 2, 18, 18, 5, 1, 252, 192, 192,
  192, 192, 192, 192, 192, 192, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  9, 18, 36, 10, 0, 252, 62, 0, 127, 0, 227, 128, 227, 128, 240, 0,
  124, 0, 254, 0, 199, 0, 195, 128, 225, 128, 113, 128, 63, 128, 15, 0,
  7, 128, 227, 128, 227, 128, 127, 0, 62, 0, 5, 2, 2, 7, 1, 12,
  216, 216, 14, 14, 28, 15, 1, 0, 15, 192, 56, 112, 96, 24, 199, 140,
  207, 204, 152, 196, 152, 4, 152, 4, 152, 68, 207, 204, 199, 140, 96, 24,
  56, 112, 15, 192, 6, 9, 9, 8, 1, 5, 120, 140, 124, 204, 204, 116,
  0, 252, 252, 10, 8, 16, 11, 0, 1, 29, 192, 59, 128, 119, 0, 238,
  0, 238, 0, 119, 0, 59, 128, 29, 192, 9, 5, 10, 11, 1, 3, 255,
  128, 255, 128, 1, 128, 1, 128, 1, 128, 5, 3, 3, 6, 0, 4, 248,
  248, 248, 13, 14, 28, 15, 1, 0, 15, 128, 48, 96, 96, 16, 95, 144,
  153, 200, 152, 200, 153, 200, 159, 8, 153, 136, 153, 136, 88, 208, 96, 48,
  56, 224, 15, 128, 5, 2, 2, 7, 1, 12, 248, 248, 6, 6, 6, 7,
  0, 7, 120, 252, 204, 204, 252, 120, 9, 9, 18, 11, 1, 0, 28, 0,
  28, 0, 255, 128, 255, 128, 28, 0, 28, 0, 0, 0, 255, 128, 255, 128,
  6, 8, 8, 6, 0, 5, 120, 252, 204, 28, 120, 224, 252, 252, 6, 8,
  8, 6, 0, 5, 120, 252, 204, 56, 60, 204, 252, 120, 5, 3, 3, 5,
  0, 11, 56, 112, 224, 9, 14, 28, 11, 1, 252, 227, 128, 227, 128, 227,
  128, 227, 128, 227, 128, 227, 128, 227, 128, 231, 128, 255, 128, 251, 128, 224,
  0, 224, 0, 224, 0, 224, 0, 9, 18, 36, 10, 0, 252, 63, 128, 123,
  0, 251, 0, 251, 0, 251, 0, 251, 0, 251, 0, 123, 0, 59, 0, 27,
  0, 27, 0, 27, 0, 27, 0, 27, 0, 27, 0, 27, 0, 27, 0, 27,
  0, 2, 2, 2, 5, 1, 6, 192, 192, 5, 5, 5, 7, 1, 251, 96,
  112, 24, 248, 240, 4, 8, 8, 6, 0, 5, 48, 240, 240, 48, 48, 48,
  48, 48, 6, 9, 9, 8, 1, 5, 120, 204, 204, 204, 204, 120, 0, 252,
  252, 10, 8, 16, 11, 0, 1, 238, 0, 119, 0, 59, 128, 29, 192, 29,
  192, 59, 128, 119, 0, 238, 0, 14, 13, 26, 15, 0, 0, 48, 96, 240,
  96, 240, 192, 48, 192, 49, 128, 49, 152, 51, 56, 54, 56, 6, 120, 12,
  216, 12, 252, 24, 24, 24, 24, 15, 13, 26, 15, 0, 0, 48, 96, 240,
  96, 240, 192, 48, 192, 49, 128, 49, 188, 51, 126, 54, 102, 6, 14, 12,
  60, 12, 112, 24, 126, 24, 126, 14, 13, 26, 15, 0, 0, 120, 48, 252,
  48, 204, 96, 56, 96, 60, 192, 204, 216, 253, 184, 123, 56, 3, 120, 6,
  216, 6, 252, 12, 24, 12, 24, 8, 14, 14, 10, 1, 252, 28, 28, 28,
  0, 28, 28, 28, 56, 120, 112, 231, 231, 255, 126, 12, 18, 36, 14, 1,
  0, 56, 0, 28, 0, 6, 0, 0, 0, 15, 0, 15, 0, 31, 128, 25,
  128, 25, 128, 57, 192, 57, 192, 48, 192, 112, 224, 127, 224, 127, 224, 224,
  112, 224, 112, 224, 112, 12, 18, 36, 14, 1, 0, 1, 192, 3, 128, 6,
  0, 0, 0, 15, 0, 15, 0, 31, 128, 25, 128, 25, 128, 57, 192, 57,
  192, 48, 192, 112, 224, 127, 224, 127, 224, 224, 112, 224, 112, 224, 112, 12,
  18, 36, 14, 1, 0, 7, 0, 15, 128, 29, 192, 0, 0, 15, 0, 15,
  0, 31, 128, 25, 128, 25, 128, 57, 192, 57, 192, 48, 192, 112, 224, 127,
  224, 127, 224, 224, 112, 224, 112, 224, 112, 12, 18, 36, 14, 1, 0, 14,
  32, 31, 192, 35, 128, 0, 0, 15, 0, 15, 0, 31, 128, 25, 128, 25,
  128, 57, 192, 57, 192, 48, 192, 112, 224, 127, 224, 127, 224, 224, 112, 224,
  112, 224, 112, 12, 18, 36, 14, 1, 0, 25, 128, 25, 128, 25, 128, 0,
  0, 15, 0, 15, 0, 31, 128, 25, 128, 25, 128, 57, 192, 57, 192, 48,
  192, 112, 224, 127, 224, 127, 224, 224, 112, 224, 112, 224, 112, 12, 18, 36,
  14, 1, 0, 15, 0, 25, 128, 25, 128, 15, 0, 15, 0, 15, 0, 31,
  128, 25, 128, 25, 128, 57, 192, 57, 192, 48, 192, 112, 224, 127, 224, 127,
  224, 224, 112, 224, 112, 224, 112, 16, 14, 28, 18, 1, 0, 15, 255, 15,
  255, 31, 128, 27, 128, 59, 128, 59, 128, 51, 254, 115, 254, 115, 128, 127,
  128, 255, 128, 227, 128, 227, 255, 227, 255, 12, 19, 38, 14, 1, 251, 15,
  128, 63, 224, 120, 224, 112, 112, 240, 112, 224, 0, 224, 0, 224, 0, 224,
  0, 240, 112, 112, 112, 120, 224, 63, 224, 15, 128, 12, 0, 14, 0, 3,
  0, 31, 0, 30, 0, 10, 18, 36, 13, 2, 0, 56, 0, 28, 0, 6,
  0, 0, 0, 255, 192, 255, 192, 224, 0, 224, 0, 224, 0, 224, 0, 255,
  128, 255, 128, 224, 0, 224, 0, 224, 0, 224, 0, 255, 192, 255, 192, 10,
  18, 36, 13, 2, 0, 3, 128, 7, 0, 12, 0, 0, 0, 255, 192, 255,
  192, 224, 0, 224, 0, 224, 0, 224, 0, 255, 128, 255, 128, 224, 0, 224,
  0, 224, 0, 224, 0, 255, 192, 255, 192, 10, 18, 36, 13, 2, 0, 14,
  0, 31, 0, 59, 128, 0, 0, 255, 192, 255, 192, 224, 0, 224, 0, 224,
  0, 224, 0, 255, 128, 255, 128, 224, 0, 224, 0, 224, 0, 224, 0, 255,
  192, 255, 192, 10, 18, 36, 13, 2, 0, 51, 0, 51, 0, 51, 0, 0,
  0, 255, 192, 255, 192, 224, 0, 224, 0, 224, 0, 224, 0, 255, 128, 255,
  128, 224, 0, 224, 0, 224, 0, 224, 0, 255, 192, 255, 192, 5, 18, 18,
  5, 255, 0, 224, 112, 24, 0, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 5, 18, 18, 5, 1, 0, 56, 112, 192, 0, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 7, 18, 18,
  5, 255, 0, 56, 124, 238, 0, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 6, 18, 18, 5, 0, 0, 204, 204, 204, 0, 112,
  112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 14, 14, 28,
  14, 255, 0, 63, 192, 63, 240, 56, 120, 56, 56, 56, 28, 56, 28, 255,
  28, 255, 28, 56, 28, 56, 28, 56, 56, 56, 120, 63, 240, 63, 192, 12,
  18, 36, 14, 1, 0, 14, 32, 31, 192, 35, 128, 0, 0, 224, 112, 240,
  112, 240, 112, 248, 112, 252, 112, 236, 112, 238, 112, 230, 112, 231, 112, 227,
  112, 225, 240, 225, 240, 224, 240, 224, 112, 13, 18, 36, 15, 1, 0, 28,
  0, 14, 0, 3, 0, 0, 0, 15, 128, 63, 224, 120, 240, 112, 112, 240,
  120, 224, 56, 224, 56, 224, 56, 224, 56, 240, 120, 112, 112, 120, 240, 63,
  224, 15, 128, 13, 18, 36, 15, 1, 0, 1, 192, 3, 128, 6, 0, 0,
  0, 15, 128, 63, 224, 120, 240, 112, 112, 240, 120, 224, 56, 224, 56, 224,
  56, 224, 56, 240, 120, 112, 112, 120, 240, 63, 224, 15, 128, 13, 18, 36,
  15, 1, 0, 7, 0, 15, 128, 29, 192, 0, 0, 15, 128, 63, 224, 120,
  240, 112, 112, 240, 120, 224, 56, 224, 56, 224, 56, 224, 56, 240, 120, 112,
  112, 120, 240, 63, 224, 15, 128, 13, 18, 36, 15, 1, 0, 7, 16, 15,
  224, 17, 192, 0, 0, 15, 128, 63, 224, 120, 240, 112, 112, 240, 120, 224,
  56, 224, 56, 224, 56, 224, 56, 240, 120, 112, 112, 120, 240, 63, 224, 15,
  128, 13, 18, 36, 15, 1, 0, 12, 192, 12, 192, 12, 192, 0, 0, 15,
  128, 63, 224, 120, 240, 112, 112, 240, 120, 224, 56, 224, 56, 224, 56, 224,
  56, 240, 120, 112, 112, 120, 240, 63, 224, 15, 128, 10, 8, 16, 11, 0,
  1, 225, 192, 115, 128, 63, 0, 30, 0, 30, 0, 63, 0, 115, 128, 225,
  192, 15, 14, 28, 15, 0, 0, 7, 198, 31, 252, 60, 56, 56, 120, 120,
  220, 113, 156, 113, 28, 115, 28, 118, 28, 124, 60, 56, 56, 60, 120, 127,
  240, 199, 192, 12, 18, 36, 14, 1, 0, 28, 0, 14, 0, 3, 0, 0,
  0, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 224, 112, 112, 224, 127, 224, 31, 128, 12, 18, 36,
  14, 1, 0, 1, 192, 3, 128, 6, 0, 0, 0, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224,
  112, 112, 224, 127, 224, 31, 128, 12, 18, 36, 14, 1, 0, 7, 0, 15,
  128, 29, 192, 0, 0, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 112, 224, 127, 224, 31,
  128, 12, 18, 36, 14, 1, 0, 25, 128, 25, 128, 25, 128, 0, 0, 224,
  112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 112, 224, 127, 224, 31, 128, 13, 18, 36, 13, 0,
  0, 1, 192, 3, 128, 6, 0, 0, 0, 224, 56, 224, 56, 112, 112, 56,
  224, 56, 224, 29, 192, 29, 192, 15, 128, 7, 0, 7, 0, 7, 0, 7,
  0, 7, 0, 7, 0, 11, 14, 28, 13, 1, 0, 224, 0, 224, 0, 224,
  0, 255, 0, 255, 192, 225, 224, 224, 224, 224, 224, 225, 224, 255, 192, 255,
  0, 224, 0, 224, 0, 224, 0, 8, 14, 14, 10, 1, 0, 60, 126, 231,
  231, 231, 231, 238, 238, 231, 231, 231, 231, 239, 238, 10, 14, 28, 11, 1,
  0, 112, 0, 56, 0, 12, 0, 0, 0, 62, 0, 127, 0, 115, 128, 7,
  128, 63, 128, 123, 128, 227, 128, 231, 128, 251, 128, 123, 192, 10, 14, 28,
  11, 1, 0, 3, 128, 7, 0, 12, 0, 0, 0, 62, 0, 127, 0, 115,
  128, 7, 128, 63, 128, 123, 128, 227, 128, 231, 128, 251, 128, 123, 192, 10,
  14, 28, 11, 1, 0, 28, 0, 62, 0, 119, 0, 0, 0, 62, 0, 127,
  0, 115, 128, 7, 128, 63, 128, 123, 128, 227, 128, 231, 128, 251, 128, 123,
  192, 10, 14, 28, 11, 1, 0, 59, 0, 127, 0, 110, 0, 0, 0, 62,
  0, 127, 0, 115, 128, 7, 128, 63, 128, 123, 128, 227, 128, 231, 128, 251,
  128, 123, 192, 10, 14, 28, 11, 1, 0, 51, 0, 51, 0, 51, 0, 0,
  0, 62, 0, 127, 0, 115, 128, 7, 128, 63, 128, 123, 128, 227, 128, 231,
  128, 251, 128, 123, 192, 10, 14, 28, 11, 1, 0, 60, 0, 102, 0, 102,
  0, 60, 0, 62, 0, 127, 0, 115, 128, 7, 128, 63, 128, 123, 128, 227,
  128, 231, 128, 251, 128, 123, 192, 14, 10, 20, 16, 1, 0, 61, 240, 127,
  248, 103, 28, 15, 28, 63, 252, 119, 0, 231, 0, 239, 156, 255, 252, 121,
  240, 9, 15, 30, 10, 1, 251, 30, 0, 127, 128, 115, 128, 224, 0, 224,
  0, 224, 0, 224, 0, 115, 128, 127, 128, 30, 0, 24, 0, 28, 0, 6,
  0, 62, 0, 60, 0, 9, 14, 28, 11, 1, 0, 112, 0, 56, 0, 12,
  0, 0, 0, 30, 0, 127, 0, 115, 128, 225, 128, 255, 128, 255, 128, 224,
  0, 115, 128, 127, 128, 30, 0, 9, 14, 28, 11, 1, 0, 3, 128, 7,
  0, 12, 0, 0, 0, 30, 0, 127, 0, 115, 128, 225, 128, 255, 128, 255,
  128, 224, 0, 115, 128, 127, 128, 30, 0, 9, 14, 28, 11, 1, 0, 28,
  0, 62, 0, 119, 0, 0, 0, 30, 0, 127, 0, 115, 128, 225, 128, 255,
  128, 255, 128, 224, 0, 115, 128, 127, 128, 30, 0, 9, 14, 28, 11, 1,
  0, 51, 0, 51, 0, 51, 0, 0, 0, 30, 0, 127, 0, 115, 128, 225,
  128, 255, 128, 255, 128, 224, 0, 115, 128, 127, 128, 30, 0, 5, 14, 14,
  5, 255, 0, 224, 112, 24, 0, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 5, 14, 14, 5, 1, 0, 56, 112, 192, 0, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 7, 14, 14, 5, 255, 0, 56, 124, 238, 0, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 5, 14, 14, 5, 0, 0, 216,
  216, 216, 0, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 10, 14, 28,
  12, 1, 0, 96, 0, 55, 0, 60, 0, 102, 0, 31, 0, 127, 128, 115,
  128, 225, 192, 225, 192, 225, 192, 225, 192, 115, 128, 127, 128, 30, 0, 9,
  14, 28, 11, 1, 0, 59, 0, 127, 0, 110, 0, 0, 0, 239, 0, 255,
  128, 243, 128, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 227,
  128, 10, 14, 28, 12, 1, 0, 112, 0, 56, 0, 12, 0, 0, 0, 30,
  0, 127, 128, 115, 128, 225, 192, 225, 192, 225, 192, 225, 192, 115, 128, 127,
  128, 30, 0, 10, 14, 28, 12, 1, 0, 3, 128, 7, 0, 12, 0, 0,
  0, 30, 0, 127, 128, 115, 128, 225, 192, 225, 192, 225, 192, 225, 192, 115,
  128, 127, 128, 30, 0, 10, 14, 28, 12, 1, 0, 28, 0, 62, 0, 119,
  0, 0, 0, 30, 0, 127, 128, 115, 128, 225, 192, 225, 192, 225, 192, 225,
  192, 115, 128, 127, 128, 30, 0, 10, 14, 28, 12, 1, 0, 59, 0, 127,
  0, 110, 0, 0, 0, 30, 0, 127, 128, 115, 128, 225, 192, 225, 192, 225,
  192, 225, 192, 115, 128, 127, 128, 30, 0, 10, 14, 28, 12, 1, 0, 51,
  0, 51, 0, 51, 0, 0, 0, 30, 0, 127, 128, 115, 128, 225, 192, 225,
  192, 225, 192, 225, 192, 115, 128, 127, 128, 30, 0, 9, 8, 16, 11, 1,
  1, 28, 0, 28, 0, 0, 0, 255, 128, 255, 128, 0, 0, 28, 0, 28,
  0, 12, 10, 20, 12, 0, 0, 15, 48, 63, 224, 57, 192, 115, 224, 119,
  224, 126, 224, 124, 224, 57, 192, 127, 192, 207, 0, 9, 14, 28, 11, 1,
  0, 112, 0, 56, 0, 12, 0, 0, 0, 227, 128, 227, 128, 227, 128, 227,
  128, 227, 128, 227, 128, 227, 128, 231, 128, 255, 128, 123, 128, 9, 14, 28,
  11, 1, 0, 3, 128, 7, 0, 12, 0, 0, 0, 227, 128, 227, 128, 227,
  128, 227, 128, 227, 128, 227, 128, 227, 128, 231, 128, 255, 128, 123, 128, 9,
  14, 28, 11, 1, 0, 28, 0, 62, 0, 119, 0, 0, 0, 227, 128, 227,
  128, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 231, 128, 255, 128, 123,
  128, 9, 14, 28, 11, 1, 0, 51, 0, 51, 0, 51, 0, 0, 0, 227,
  128, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 231, 128, 255,
  128, 123, 128, 9, 18, 36, 11, 1, 252, 7, 0, 14, 0, 24, 0, 0,
  0, 227, 128, 227, 128, 227, 128, 119, 0, 119, 0, 119, 0, 62, 0, 62,
  0, 28, 0, 28, 0, 28, 0, 24, 0, 120, 0, 112, 0, 10, 18, 36,
  12, 1, 252, 224, 0, 224, 0, 224, 0, 224, 0, 239, 0, 255, 128, 243,
  128, 225, 192, 225, 192, 225, 192, 225, 192, 243, 128, 255, 128, 239, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 9, 18, 36, 11, 1, 252, 51, 0, 51,
  0, 51, 0, 0, 0, 227, 128, 227, 128, 227, 128, 119, 0, 119, 0, 119,
  0, 62, 0, 62, 0, 28, 0, 28, 0, 28, 0, 24, 0, 120, 0, 112,
  0
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--20-140-100-100-P-105-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 0, '1' Height: 13
  Calculated Max Values w= 9 h=14 x= 1 y= 8 dx=11 dy= 0 ascent=14 len=26
  Font Bounding box     w=22 h=29 x=-2 y=-7
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =13 descent= 0
  X Font      ascent =13 descent= 0
  Max Font    ascent =14 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_helvB14n[416] U8G_FONT_SECTION("u8g_font_helvB14n") = {
  0, 22, 29, 254, 249, 13, 0, 0, 0, 0, 42, 58, 0, 14, 253, 13,
  0, 7, 6, 6, 9, 1, 8, 16, 214, 124, 56, 108, 68, 8, 8, 8,
  11, 1, 1, 24, 24, 24, 255, 255, 24, 24, 24, 3, 6, 6, 5, 1,
  253, 224, 224, 224, 96, 192, 128, 5, 3, 3, 6, 0, 4, 248, 248, 248,
  3, 3, 3, 5, 1, 0, 224, 224, 224, 5, 14, 14, 5, 0, 0, 24,
  24, 24, 56, 48, 48, 48, 112, 96, 96, 224, 192, 192, 192, 9, 13, 26,
  10, 0, 0, 28, 0, 127, 0, 119, 0, 227, 128, 227, 128, 227, 128, 227,
  128, 227, 128, 227, 128, 227, 128, 119, 0, 127, 0, 28, 0, 6, 13, 13,
  10, 1, 0, 28, 60, 252, 252, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  9, 13, 26, 10, 0, 0, 62, 0, 127, 0, 227, 128, 227, 128, 3, 128,
  7, 0, 31, 0, 62, 0, 120, 0, 112, 0, 224, 0, 255, 128, 255, 128,
  9, 13, 26, 10, 0, 0, 62, 0, 127, 0, 231, 0, 227, 0, 7, 0,
  30, 0, 31, 0, 7, 128, 3, 128, 227, 128, 231, 128, 127, 0, 62, 0,
  9, 13, 26, 10, 0, 0, 7, 0, 15, 0, 31, 0, 63, 0, 55, 0,
  119, 0, 103, 0, 231, 0, 255, 128, 255, 128, 7, 0, 7, 0, 7, 0,
  9, 13, 26, 10, 0, 0, 255, 0, 255, 0, 224, 0, 224, 0, 254, 0,
  255, 0, 231, 128, 3, 128, 3, 128, 227, 128, 231, 128, 255, 0, 126, 0,
  9, 13, 26, 10, 0, 0, 63, 0, 127, 128, 113, 128, 224, 0, 238, 0,
  255, 0, 243, 128, 225, 128, 225, 128, 225, 128, 243, 128, 127, 0, 62, 0,
  9, 13, 26, 10, 0, 0, 255, 128, 255, 128, 3, 128, 7, 0, 14, 0,
  14, 0, 28, 0, 28, 0, 56, 0, 56, 0, 112, 0, 112, 0, 112, 0,
  9, 13, 26, 10, 0, 0, 62, 0, 127, 0, 227, 128, 227, 128, 227, 128,
  127, 0, 62, 0, 119, 0, 227, 128, 227, 128, 227, 128, 127, 0, 62, 0,
  9, 13, 26, 10, 0, 0, 62, 0, 127, 0, 231, 128, 195, 128, 195, 128,
  195, 128, 231, 128, 127, 128, 59, 128, 3, 128, 199, 0, 255, 0, 126, 0,
  3, 10, 10, 6, 1, 0, 224, 224, 224, 0, 0, 0, 0, 224, 224, 224
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--20-140-100-100-P-105-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 14, '1' Height: 13
  Calculated Max Values w=16 h=18 x= 2 y=11 dx=18 dy= 0 ascent=14 len=34
  Font Bounding box     w=22 h=29 x=-2 y=-7
  Calculated Min Values           x=-1 y=-4 dx= 0 dy= 0
  Pure Font   ascent =14 descent=-4
  X Font      ascent =14 descent=-4
  Max Font    ascent =14 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_helvB14r[2548] U8G_FONT_SECTION("u8g_font_helvB14r") = {
  0, 22, 29, 254, 249, 14, 3, 23, 6, 234, 32, 127, 252, 14, 252, 14,
  252, 0, 0, 0, 5, 0, 1, 3, 14, 14, 5, 1, 0, 224, 224, 224,
  224, 224, 224, 224, 224, 192, 192, 0, 224, 224, 224, 5, 5, 5, 7, 1,
  9, 216, 216, 216, 216, 144, 11, 13, 26, 11, 0, 0, 13, 128, 13, 128,
  13, 128, 127, 224, 127, 224, 27, 0, 27, 0, 27, 0, 255, 192, 255, 192,
  54, 0, 54, 0, 54, 0, 10, 16, 32, 10, 0, 254, 4, 0, 63, 0,
  127, 128, 229, 128, 228, 0, 228, 0, 124, 0, 63, 0, 15, 128, 9, 192,
  233, 192, 233, 192, 127, 128, 63, 0, 8, 0, 8, 0, 13, 13, 26, 16,
  1, 0, 120, 96, 252, 96, 204, 192, 204, 128, 253, 128, 123, 0, 2, 0,
  6, 240, 13, 248, 9, 152, 25, 152, 49, 248, 48, 240, 13, 14, 28, 14,
  1, 0, 30, 0, 63, 0, 115, 128, 97, 128, 115, 0, 62, 0, 28, 96,
  126, 96, 231, 224, 195, 192, 193, 192, 227, 224, 127, 112, 62, 56, 2, 5,
  5, 4, 1, 9, 192, 192, 192, 192, 128, 6, 18, 18, 7, 1, 252, 28,
  56, 48, 112, 96, 224, 224, 224, 224, 224, 224, 224, 224, 96, 112, 48, 56,
  28, 6, 18, 18, 7, 0, 252, 224, 112, 48, 56, 24, 28, 28, 28, 28,
  28, 28, 28, 28, 24, 56, 48, 112, 224, 7, 6, 6, 9, 1, 8, 16,
  214, 124, 56, 108, 68, 8, 8, 8, 11, 1, 1, 24, 24, 24, 255, 255,
  24, 24, 24, 3, 6, 6, 5, 1, 253, 224, 224, 224, 96, 192, 128, 5,
  3, 3, 6, 0, 4, 248, 248, 248, 3, 3, 3, 5, 1, 0, 224, 224,
  224, 5, 14, 14, 5, 0, 0, 24, 24, 24, 56, 48, 48, 48, 112, 96,
  96, 224, 192, 192, 192, 9, 13, 26, 10, 0, 0, 28, 0, 127, 0, 119,
  0, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 119,
  0, 127, 0, 28, 0, 6, 13, 13, 10, 1, 0, 28, 60, 252, 252, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 9, 13, 26, 10, 0, 0, 62, 0,
  127, 0, 227, 128, 227, 128, 3, 128, 7, 0, 31, 0, 62, 0, 120, 0,
  112, 0, 224, 0, 255, 128, 255, 128, 9, 13, 26, 10, 0, 0, 62, 0,
  127, 0, 231, 0, 227, 0, 7, 0, 30, 0, 31, 0, 7, 128, 3, 128,
  227, 128, 231, 128, 127, 0, 62, 0, 9, 13, 26, 10, 0, 0, 7, 0,
  15, 0, 31, 0, 63, 0, 55, 0, 119, 0, 103, 0, 231, 0, 255, 128,
  255, 128, 7, 0, 7, 0, 7, 0, 9, 13, 26, 10, 0, 0, 255, 0,
  255, 0, 224, 0, 224, 0, 254, 0, 255, 0, 231, 128, 3, 128, 3, 128,
  227, 128, 231, 128, 255, 0, 126, 0, 9, 13, 26, 10, 0, 0, 63, 0,
  127, 128, 113, 128, 224, 0, 238, 0, 255, 0, 243, 128, 225, 128, 225, 128,
  225, 128, 243, 128, 127, 0, 62, 0, 9, 13, 26, 10, 0, 0, 255, 128,
  255, 128, 3, 128, 7, 0, 14, 0, 14, 0, 28, 0, 28, 0, 56, 0,
  56, 0, 112, 0, 112, 0, 112, 0, 9, 13, 26, 10, 0, 0, 62, 0,
  127, 0, 227, 128, 227, 128, 227, 128, 127, 0, 62, 0, 119, 0, 227, 128,
  227, 128, 227, 128, 127, 0, 62, 0, 9, 13, 26, 10, 0, 0, 62, 0,
  127, 0, 231, 128, 195, 128, 195, 128, 195, 128, 231, 128, 127, 128, 59, 128,
  3, 128, 199, 0, 255, 0, 126, 0, 3, 10, 10, 6, 1, 0, 224, 224,
  224, 0, 0, 0, 0, 224, 224, 224, 3, 13, 13, 6, 1, 253, 224, 224,
  224, 0, 0, 0, 0, 224, 224, 224, 96, 192, 128, 9, 9, 18, 11, 1,
  0, 3, 128, 15, 128, 62, 0, 120, 0, 224, 0, 120, 0, 62, 0, 15,
  128, 3, 128, 9, 5, 10, 11, 1, 3, 255, 128, 255, 128, 0, 0, 255,
  128, 255, 128, 9, 9, 18, 11, 1, 0, 224, 0, 248, 0, 62, 0, 15,
  0, 3, 128, 15, 0, 62, 0, 248, 0, 224, 0, 8, 14, 14, 10, 1,
  0, 126, 255, 231, 231, 14, 30, 28, 56, 56, 56, 0, 56, 56, 56, 16,
  17, 34, 18, 1, 253, 7, 240, 31, 252, 60, 30, 112, 6, 99, 183, 231,
  243, 198, 99, 204, 99, 204, 195, 204, 198, 204, 198, 239, 252, 231, 184, 112,
  0, 60, 0, 31, 240, 7, 240, 12, 14, 28, 14, 1, 0, 15, 0, 15,
  0, 31, 128, 25, 128, 25, 128, 57, 192, 57, 192, 48, 192, 112, 224, 127,
  224, 127, 224, 224, 112, 224, 112, 224, 112, 11, 14, 28, 14, 2, 0, 254,
  0, 255, 128, 227, 192, 225, 192, 225, 192, 227, 128, 255, 128, 255, 192, 225,
  224, 224, 224, 224, 224, 225, 224, 255, 192, 255, 0, 12, 14, 28, 14, 1,
  0, 15, 128, 63, 224, 120, 224, 112, 112, 240, 112, 224, 0, 224, 0, 224,
  0, 224, 0, 240, 112, 112, 112, 120, 224, 63, 224, 15, 128, 12, 14, 28,
  14, 1, 0, 255, 0, 255, 192, 225, 224, 224, 224, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 224, 112, 224, 224, 225, 224, 255, 192, 255, 0, 10,
  14, 28, 13, 2, 0, 255, 192, 255, 192, 224, 0, 224, 0, 224, 0, 224,
  0, 255, 128, 255, 128, 224, 0, 224, 0, 224, 0, 224, 0, 255, 192, 255,
  192, 10, 14, 28, 12, 1, 0, 255, 192, 255, 192, 224, 0, 224, 0, 224,
  0, 224, 0, 255, 128, 255, 128, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 12, 14, 28, 15, 1, 0, 15, 128, 63, 224, 120, 224, 112,
  112, 240, 112, 224, 0, 224, 0, 227, 240, 227, 240, 240, 112, 112, 112, 120,
  240, 63, 240, 31, 176, 12, 14, 28, 14, 1, 0, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 224, 112, 255, 240, 255, 240, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 224, 112, 3, 14, 14, 5, 1, 0, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 9, 14, 28, 10, 0,
  0, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3,
  128, 3, 128, 227, 128, 227, 128, 247, 128, 127, 0, 62, 0, 13, 14, 28,
  14, 1, 0, 224, 240, 225, 224, 227, 192, 231, 128, 239, 0, 254, 0, 252,
  0, 254, 0, 239, 0, 231, 128, 227, 192, 225, 224, 224, 240, 224, 120, 9,
  14, 28, 11, 1, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 128, 255,
  128, 14, 14, 28, 16, 1, 0, 224, 28, 224, 28, 240, 60, 240, 60, 248,
  124, 248, 124, 248, 124, 236, 220, 236, 220, 236, 220, 231, 156, 231, 156, 227,
  28, 227, 28, 12, 14, 28, 14, 1, 0, 224, 112, 240, 112, 240, 112, 248,
  112, 252, 112, 236, 112, 238, 112, 230, 112, 231, 112, 227, 112, 225, 240, 225,
  240, 224, 240, 224, 112, 13, 14, 28, 15, 1, 0, 15, 128, 63, 224, 120,
  240, 112, 112, 240, 120, 224, 56, 224, 56, 224, 56, 224, 56, 240, 120, 112,
  112, 120, 240, 63, 224, 15, 128, 11, 14, 28, 13, 1, 0, 255, 0, 255,
  192, 225, 224, 224, 224, 224, 224, 224, 224, 225, 224, 255, 192, 255, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 13, 15, 30, 15, 1, 255, 15,
  128, 63, 224, 120, 240, 112, 112, 240, 120, 224, 56, 224, 56, 224, 56, 224,
  56, 243, 120, 115, 240, 121, 240, 63, 224, 15, 240, 0, 48, 12, 14, 28,
  14, 1, 0, 255, 0, 255, 192, 225, 224, 224, 224, 224, 224, 225, 224, 255,
  192, 255, 128, 225, 192, 224, 224, 224, 224, 224, 224, 224, 224, 224, 240, 11,
  14, 28, 13, 1, 0, 63, 128, 127, 192, 241, 224, 224, 224, 240, 0, 126,
  0, 63, 128, 15, 192, 1, 224, 224, 224, 224, 224, 241, 224, 127, 192, 63,
  128, 11, 14, 28, 11, 0, 0, 255, 224, 255, 224, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 12, 14, 28, 14, 1, 0, 224, 112, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 112,
  224, 127, 224, 31, 128, 13, 14, 28, 13, 0, 0, 224, 56, 224, 56, 112,
  112, 112, 112, 48, 96, 56, 224, 56, 224, 29, 192, 29, 192, 13, 128, 15,
  128, 15, 128, 7, 0, 7, 0, 15, 14, 28, 17, 1, 0, 227, 142, 227,
  142, 227, 142, 227, 142, 115, 156, 115, 156, 115, 156, 118, 220, 54, 216, 54,
  216, 62, 248, 28, 112, 28, 112, 28, 112, 12, 14, 28, 12, 0, 0, 224,
  112, 224, 112, 112, 224, 121, 224, 25, 128, 31, 128, 15, 0, 31, 128, 25,
  128, 57, 192, 112, 224, 112, 224, 224, 112, 224, 112, 13, 14, 28, 13, 0,
  0, 224, 56, 224, 56, 112, 112, 56, 224, 56, 224, 29, 192, 29, 192, 15,
  128, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 10, 14, 28,
  12, 1, 0, 255, 192, 255, 192, 1, 192, 3, 128, 7, 0, 7, 0, 14,
  0, 28, 0, 56, 0, 56, 0, 112, 0, 224, 0, 255, 192, 255, 192, 5,
  18, 18, 6, 1, 252, 248, 248, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 248, 248, 5, 14, 14, 5, 0, 0, 192, 192, 192,
  224, 96, 96, 96, 112, 48, 48, 56, 24, 24, 24, 5, 18, 18, 6, 0,
  252, 248, 248, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 248, 248, 10, 7, 14, 10, 0, 6, 12, 0, 30, 0, 30, 0, 51,
  0, 115, 128, 97, 128, 225, 192, 10, 2, 4, 10, 0, 252, 255, 192, 255,
  192, 5, 3, 3, 5, 0, 11, 224, 112, 56, 10, 10, 20, 11, 1, 0,
  62, 0, 127, 0, 99, 128, 7, 128, 63, 128, 123, 128, 227, 128, 231, 128,
  251, 128, 123, 192, 10, 14, 28, 12, 1, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 239, 0, 255, 128, 243, 128, 225, 192, 225, 192, 225, 192, 225, 192,
  243, 128, 255, 128, 239, 0, 9, 10, 20, 11, 1, 0, 30, 0, 127, 128,
  115, 128, 224, 0, 224, 0, 224, 0, 224, 0, 115, 128, 127, 128, 30, 0,
  10, 14, 28, 12, 1, 0, 1, 192, 1, 192, 1, 192, 1, 192, 61, 192,
  127, 192, 115, 192, 225, 192, 225, 192, 225, 192, 225, 192, 115, 192, 127, 192,
  61, 192, 9, 10, 20, 11, 1, 0, 30, 0, 127, 0, 115, 128, 225, 128,
  255, 128, 255, 128, 224, 0, 115, 128, 127, 128, 30, 0, 7, 14, 14, 7,
  0, 0, 30, 62, 56, 56, 254, 254, 56, 56, 56, 56, 56, 56, 56, 56,
  10, 14, 28, 12, 1, 252, 61, 192, 127, 192, 115, 192, 225, 192, 225, 192,
  225, 192, 225, 192, 115, 192, 127, 192, 61, 192, 1, 192, 115, 128, 127, 128,
  30, 0, 9, 14, 28, 11, 1, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  239, 0, 255, 128, 243, 128, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128,
  227, 128, 227, 128, 3, 14, 14, 5, 1, 0, 224, 224, 224, 0, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 5, 18, 18, 5, 255, 252, 56, 56,
  56, 0, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 248, 240,
  9, 14, 28, 10, 1, 0, 224, 0, 224, 0, 224, 0, 224, 0, 231, 0,
  238, 0, 252, 0, 248, 0, 248, 0, 252, 0, 238, 0, 231, 0, 231, 128,
  227, 128, 3, 14, 14, 5, 1, 0, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 15, 10, 20, 17, 1, 0, 239, 60, 255, 254,
  243, 206, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142,
  9, 10, 20, 11, 1, 0, 239, 0, 255, 128, 243, 128, 227, 128, 227, 128,
  227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 10, 10, 20, 12, 1, 0,
  30, 0, 127, 128, 115, 128, 225, 192, 225, 192, 225, 192, 225, 192, 115, 128,
  127, 128, 30, 0, 10, 14, 28, 12, 1, 252, 239, 0, 255, 128, 243, 128,
  225, 192, 225, 192, 225, 192, 225, 192, 243, 128, 255, 128, 239, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 10, 14, 28, 12, 1, 252, 61, 192, 127, 192,
  115, 192, 225, 192, 225, 192, 225, 192, 225, 192, 115, 192, 127, 192, 61, 192,
  1, 192, 1, 192, 1, 192, 1, 192, 6, 10, 10, 7, 1, 0, 236, 252,
  252, 224, 224, 224, 224, 224, 224, 224, 9, 10, 20, 11, 1, 0, 63, 0,
  127, 128, 227, 128, 224, 0, 255, 0, 63, 128, 3, 128, 227, 128, 255, 0,
  126, 0, 6, 13, 13, 6, 0, 0, 112, 112, 112, 252, 252, 112, 112, 112,
  112, 112, 112, 124, 60, 9, 10, 20, 11, 1, 0, 227, 128, 227, 128, 227,
  128, 227, 128, 227, 128, 227, 128, 227, 128, 231, 128, 255, 128, 123, 128, 9,
  10, 20, 9, 0, 0, 227, 128, 227, 128, 227, 128, 119, 0, 119, 0, 119,
  0, 62, 0, 62, 0, 28, 0, 28, 0, 15, 10, 20, 15, 0, 0, 227,
  142, 227, 142, 227, 142, 115, 156, 119, 220, 118, 220, 62, 248, 60, 120, 28,
  112, 28, 112, 9, 10, 20, 11, 1, 0, 227, 128, 227, 128, 119, 0, 62,
  0, 28, 0, 62, 0, 119, 0, 119, 0, 227, 128, 227, 128, 9, 14, 28,
  11, 1, 252, 227, 128, 227, 128, 227, 128, 119, 0, 119, 0, 119, 0, 62,
  0, 62, 0, 28, 0, 28, 0, 28, 0, 24, 0, 120, 0, 112, 0, 8,
  10, 10, 10, 1, 0, 255, 255, 7, 14, 28, 56, 112, 224, 255, 255, 7,
  18, 18, 8, 1, 252, 14, 28, 56, 56, 56, 56, 56, 112, 224, 112, 56,
  56, 56, 56, 56, 56, 28, 14, 2, 18, 18, 5, 1, 252, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 7,
  18, 18, 8, 0, 252, 224, 112, 56, 56, 56, 56, 56, 28, 14, 28, 56,
  56, 56, 56, 56, 56, 112, 224, 9, 3, 6, 11, 1, 4, 121, 128, 255,
  128, 207, 0, 255
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--25-180-100-100-P-138-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 19, '1' Height: 18
  Calculated Max Values w=22 h=24 x= 3 y=17 dx=24 dy= 0 ascent=24 len=72
  Font Bounding box     w=28 h=37 x=-2 y=-8
  Calculated Min Values           x=-1 y=-5 dx= 0 dy= 0
  Pure Font   ascent =19 descent=-5
  X Font      ascent =19 descent=-5
  Max Font    ascent =24 descent=-5
*/
const u8g_fntpgm_uint8_t u8g_font_helvB18[7527] U8G_FONT_SECTION("u8g_font_helvB18") = {
  0, 28, 37, 254, 248, 19, 4, 35, 9, 107, 32, 255, 251, 24, 251, 19,
  251, 0, 0, 0, 6, 0, 1, 3, 19, 19, 7, 2, 0, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 192, 192, 192, 0, 0, 224, 224, 224,
  5, 6, 6, 9, 2, 13, 216, 216, 216, 216, 216, 144, 12, 18, 36, 14,
  1, 0, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 127, 240, 127, 240,
  25, 128, 25, 128, 25, 128, 25, 128, 255, 224, 255, 224, 51, 0, 51, 0,
  51, 0, 51, 0, 51, 0, 12, 21, 42, 13, 0, 254, 6, 0, 63, 128,
  127, 224, 246, 224, 230, 112, 230, 112, 246, 0, 126, 0, 62, 0, 15, 0,
  7, 192, 7, 224, 6, 240, 230, 112, 230, 112, 230, 112, 246, 240, 127, 224,
  31, 192, 6, 0, 6, 0, 21, 18, 54, 22, 0, 0, 0, 7, 0, 62,
  7, 0, 127, 14, 0, 227, 142, 0, 193, 156, 0, 193, 156, 0, 227, 184,
  0, 127, 56, 0, 62, 112, 0, 0, 112, 0, 0, 227, 224, 0, 231, 240,
  1, 206, 56, 1, 204, 24, 3, 140, 24, 3, 142, 56, 7, 7, 240, 7,
  3, 224, 16, 18, 36, 18, 1, 0, 15, 128, 31, 192, 61, 224, 56, 224,
  56, 224, 56, 224, 29, 192, 15, 128, 31, 0, 63, 156, 123, 220, 113, 252,
  224, 248, 224, 112, 224, 248, 241, 252, 127, 206, 31, 135, 2, 6, 6, 6,
  2, 13, 192, 192, 192, 192, 192, 128, 6, 24, 24, 8, 1, 251, 12, 28,
  56, 56, 112, 112, 96, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 96,
  112, 112, 56, 56, 28, 12, 6, 24, 24, 8, 1, 251, 192, 224, 112, 112,
  56, 56, 24, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 24, 56, 56,
  112, 112, 224, 192, 8, 7, 7, 10, 1, 12, 24, 24, 219, 255, 60, 102,
  102, 12, 12, 24, 15, 1, 1, 6, 0, 6, 0, 6, 0, 6, 0, 6,
  0, 255, 240, 255, 240, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 3,
  6, 6, 7, 2, 253, 224, 224, 224, 96, 96, 192, 7, 3, 3, 8, 0,
  6, 254, 254, 254, 3, 3, 3, 7, 2, 0, 224, 224, 224, 7, 19, 19,
  8, 1, 0, 6, 6, 6, 12, 12, 12, 24, 24, 24, 24, 48, 48, 48,
  96, 96, 96, 192, 192, 192, 12, 18, 36, 13, 0, 0, 31, 128, 63, 192,
  121, 224, 112, 224, 112, 224, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112,
  224, 112, 224, 112, 224, 112, 112, 224, 112, 224, 121, 224, 63, 192, 31, 128,
  7, 18, 18, 13, 2, 0, 14, 14, 30, 254, 254, 14, 14, 14, 14, 14,
  14, 14, 14, 14, 14, 14, 14, 14, 12, 18, 36, 13, 0, 0, 31, 0,
  127, 192, 113, 224, 224, 224, 224, 112, 224, 112, 0, 112, 0, 224, 1, 224,
  3, 192, 7, 128, 31, 0, 60, 0, 120, 0, 240, 0, 224, 0, 255, 240,
  255, 240, 12, 18, 36, 13, 0, 0, 31, 0, 127, 192, 113, 192, 224, 224,
  224, 224, 224, 224, 0, 224, 1, 192, 15, 128, 15, 224, 0, 224, 0, 112,
  0, 112, 224, 112, 224, 240, 113, 224, 127, 224, 31, 128, 12, 18, 36, 13,
  0, 0, 1, 192, 3, 192, 3, 192, 7, 192, 7, 192, 13, 192, 29, 192,
  25, 192, 49, 192, 113, 192, 97, 192, 225, 192, 255, 240, 255, 240, 1, 192,
  1, 192, 1, 192, 1, 192, 12, 18, 36, 13, 0, 0, 127, 224, 127, 224,
  112, 0, 112, 0, 112, 0, 112, 0, 127, 128, 127, 192, 113, 224, 0, 224,
  0, 112, 0, 112, 0, 112, 224, 112, 224, 240, 241, 224, 127, 192, 31, 128,
  12, 18, 36, 13, 0, 0, 15, 128, 63, 224, 120, 224, 112, 112, 224, 112,
  224, 0, 224, 0, 239, 0, 255, 192, 249, 224, 240, 224, 224, 112, 224, 112,
  224, 112, 112, 224, 121, 224, 63, 192, 31, 128, 12, 18, 36, 13, 0, 0,
  255, 240, 255, 240, 0, 240, 0, 224, 1, 192, 1, 192, 3, 128, 3, 128,
  7, 0, 7, 0, 14, 0, 14, 0, 30, 0, 28, 0, 28, 0, 60, 0,
  56, 0, 56, 0, 12, 18, 36, 13, 0, 0, 15, 0, 63, 192, 57, 192,
  112, 224, 112, 224, 112, 224, 112, 224, 57, 192, 31, 128, 63, 192, 112, 224,
  224, 112, 224, 112, 224, 112, 224, 112, 112, 224, 127, 224, 31, 128, 12, 18,
  36, 13, 0, 0, 31, 128, 127, 192, 121, 224, 240, 224, 224, 112, 224, 112,
  224, 112, 224, 112, 240, 240, 121, 240, 127, 240, 31, 112, 0, 112, 0, 112,
  224, 224, 243, 224, 127, 192, 31, 0, 3, 14, 14, 7, 2, 0, 224, 224,
  224, 0, 0, 0, 0, 0, 0, 0, 0, 224, 224, 224, 3, 17, 17, 7,
  2, 253, 224, 224, 224, 0, 0, 0, 0, 0, 0, 0, 0, 224, 224, 224,
  96, 96, 192, 13, 12, 24, 15, 0, 1, 0, 56, 0, 248, 3, 224, 15,
  128, 62, 0, 240, 0, 240, 0, 62, 0, 15, 128, 3, 224, 0, 248, 0,
  56, 10, 5, 10, 14, 2, 5, 255, 192, 255, 192, 0, 0, 255, 192, 255,
  192, 13, 12, 24, 14, 1, 1, 224, 0, 248, 0, 62, 0, 15, 128, 3,
  224, 0, 120, 0, 120, 3, 224, 15, 128, 62, 0, 248, 0, 224, 0, 11,
  19, 38, 15, 2, 0, 31, 128, 127, 192, 121, 224, 240, 224, 224, 224, 225,
  224, 1, 192, 3, 192, 7, 128, 7, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 0, 0, 0, 0, 14, 0, 14, 0, 14, 0, 22, 22, 66, 24, 1,
  252, 1, 255, 0, 7, 255, 192, 15, 129, 240, 30, 0, 120, 60, 0, 56,
  120, 125, 156, 112, 255, 156, 241, 199, 28, 227, 135, 28, 227, 14, 28, 231,
  14, 56, 231, 12, 56, 231, 28, 112, 231, 28, 112, 227, 157, 224, 243, 255,
  192, 113, 247, 0, 120, 0, 0, 60, 0, 0, 31, 7, 0, 15, 255, 0,
  3, 252, 0, 16, 19, 38, 18, 1, 0, 3, 192, 3, 192, 7, 224, 7,
  224, 14, 96, 14, 112, 14, 112, 28, 56, 28, 56, 28, 56, 56, 28, 56,
  28, 63, 252, 127, 254, 112, 14, 112, 14, 224, 7, 224, 7, 224, 7, 15,
  19, 38, 18, 2, 0, 255, 224, 255, 248, 224, 120, 224, 28, 224, 28, 224,
  28, 224, 28, 224, 56, 255, 240, 255, 248, 224, 28, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 30, 224, 124, 255, 248, 255, 224, 16, 19, 38, 18, 1,
  0, 7, 240, 31, 252, 62, 62, 120, 15, 112, 7, 240, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 240, 7, 112, 7, 120,
  15, 62, 62, 31, 252, 7, 240, 16, 19, 38, 19, 2, 0, 255, 224, 255,
  248, 224, 124, 224, 30, 224, 14, 224, 15, 224, 7, 224, 7, 224, 7, 224,
  7, 224, 7, 224, 7, 224, 7, 224, 15, 224, 14, 224, 30, 224, 124, 255,
  248, 255, 224, 13, 19, 38, 16, 2, 0, 255, 240, 255, 240, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 224, 255, 224, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 248, 255, 248, 12,
  19, 38, 15, 2, 0, 255, 240, 255, 240, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 255, 224, 255, 224, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 17, 19, 57, 19, 1,
  0, 7, 240, 0, 31, 252, 0, 62, 62, 0, 120, 15, 0, 112, 7, 0,
  240, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 127, 128, 224,
  127, 128, 224, 3, 128, 224, 3, 128, 240, 3, 128, 112, 7, 128, 120, 15,
  128, 62, 63, 128, 31, 251, 128, 7, 243, 128, 15, 19, 38, 19, 2, 0,
  224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14,
  255, 254, 255, 254, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14,
  224, 14, 224, 14, 224, 14, 3, 19, 19, 7, 2, 0, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 11,
  19, 38, 14, 1, 0, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 113, 224, 127, 192, 63, 128, 14, 19, 38, 18, 2,
  0, 224, 60, 224, 120, 224, 240, 225, 224, 227, 192, 231, 128, 239, 0, 254,
  0, 254, 0, 255, 0, 247, 128, 227, 128, 225, 192, 225, 224, 224, 224, 224,
  112, 224, 120, 224, 56, 224, 60, 12, 19, 38, 15, 2, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255,
  240, 255, 240, 19, 19, 57, 23, 2, 0, 224, 0, 224, 240, 1, 224, 240,
  1, 224, 248, 3, 224, 248, 3, 224, 252, 7, 224, 236, 6, 224, 238, 14,
  224, 230, 12, 224, 231, 28, 224, 231, 28, 224, 227, 24, 224, 227, 184, 224,
  227, 184, 224, 225, 240, 224, 225, 240, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 15, 19, 38, 19, 2, 0, 224, 14, 240, 14, 240, 14, 248, 14,
  248, 14, 252, 14, 238, 14, 238, 14, 231, 14, 227, 142, 227, 142, 225, 206,
  224, 206, 224, 238, 224, 126, 224, 62, 224, 62, 224, 30, 224, 14, 17, 19,
  57, 19, 1, 0, 7, 240, 0, 31, 252, 0, 62, 62, 0, 120, 15, 0,
  112, 7, 0, 240, 7, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224,
  3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 240, 7, 128, 112, 7,
  0, 120, 15, 0, 62, 62, 0, 31, 252, 0, 7, 240, 0, 14, 19, 38,
  17, 2, 0, 255, 224, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224,
  28, 224, 56, 255, 248, 255, 240, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 17, 20, 60, 19, 1, 255, 7,
  240, 0, 31, 252, 0, 62, 62, 0, 120, 15, 0, 112, 7, 0, 240, 7,
  128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128,
  224, 3, 128, 224, 3, 128, 240, 39, 128, 112, 119, 0, 120, 63, 0, 62,
  30, 0, 31, 254, 0, 7, 247, 0, 0, 2, 0, 14, 19, 38, 17, 2,
  0, 255, 224, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224,
  56, 255, 248, 255, 240, 224, 120, 224, 56, 224, 28, 224, 28, 224, 28, 224,
  28, 224, 28, 224, 28, 224, 28, 14, 19, 38, 17, 2, 0, 15, 192, 63,
  240, 120, 248, 240, 56, 224, 56, 224, 0, 240, 0, 124, 0, 63, 192, 7,
  240, 0, 248, 0, 60, 0, 28, 224, 28, 224, 28, 224, 60, 248, 248, 127,
  240, 31, 192, 15, 19, 38, 15, 0, 0, 255, 254, 255, 254, 3, 128, 3,
  128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3,
  128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 15,
  19, 38, 19, 2, 0, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224,
  14, 240, 30, 112, 28, 124, 124, 63, 248, 15, 224, 16, 19, 38, 18, 1,
  0, 224, 7, 224, 7, 240, 15, 112, 14, 120, 30, 56, 28, 56, 28, 60,
  60, 28, 56, 28, 56, 30, 120, 14, 112, 14, 112, 14, 112, 7, 224, 7,
  224, 3, 192, 3, 192, 3, 192, 21, 19, 57, 23, 1, 0, 224, 112, 56,
  224, 112, 56, 224, 112, 56, 224, 112, 56, 112, 248, 112, 112, 248, 112, 112,
  216, 112, 113, 220, 112, 49, 220, 96, 57, 220, 224, 57, 140, 224, 59, 142,
  224, 27, 142, 192, 27, 142, 192, 31, 7, 192, 31, 7, 192, 14, 3, 128,
  14, 3, 128, 14, 3, 128, 16, 19, 38, 18, 1, 0, 224, 7, 240, 15,
  120, 30, 56, 28, 28, 56, 14, 112, 15, 240, 7, 224, 3, 192, 3, 192,
  7, 224, 15, 240, 14, 112, 28, 56, 60, 60, 56, 28, 112, 14, 240, 15,
  224, 7, 15, 19, 38, 17, 1, 0, 224, 14, 240, 14, 112, 28, 120, 28,
  56, 56, 60, 56, 28, 112, 28, 112, 14, 224, 14, 224, 7, 192, 7, 192,
  3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 14, 19,
  38, 16, 1, 0, 255, 252, 255, 252, 0, 60, 0, 120, 0, 240, 1, 224,
  1, 224, 3, 192, 7, 128, 7, 128, 15, 0, 30, 0, 30, 0, 60, 0,
  56, 0, 120, 0, 240, 0, 255, 252, 255, 252, 5, 24, 24, 8, 1, 251,
  248, 248, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 248, 248, 7, 19, 19, 8, 0, 0, 192, 192,
  192, 96, 96, 96, 48, 48, 48, 48, 24, 24, 24, 12, 12, 12, 6, 6,
  6, 5, 24, 24, 8, 2, 251, 248, 248, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 248, 248, 11,
  9, 18, 14, 1, 10, 14, 0, 14, 0, 31, 0, 27, 0, 59, 128, 113,
  192, 113, 192, 224, 224, 224, 224, 14, 2, 4, 14, 0, 251, 255, 252, 255,
  252, 6, 4, 4, 8, 1, 15, 224, 112, 56, 28, 12, 14, 28, 14, 1,
  0, 31, 128, 63, 192, 113, 224, 112, 224, 0, 224, 7, 224, 63, 224, 124,
  224, 240, 224, 224, 224, 225, 224, 243, 224, 127, 240, 62, 112, 12, 19, 38,
  15, 2, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 239, 128, 255,
  192, 249, 224, 240, 224, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224,
  112, 240, 224, 249, 224, 255, 192, 239, 128, 11, 14, 28, 13, 1, 0, 31,
  128, 63, 192, 121, 224, 112, 224, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 112, 224, 121, 224, 63, 192, 31, 128, 12, 19, 38, 15, 1,
  0, 0, 112, 0, 112, 0, 112, 0, 112, 0, 112, 31, 112, 63, 240, 121,
  240, 112, 240, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 112,
  240, 121, 240, 63, 240, 31, 112, 12, 14, 28, 14, 1, 0, 15, 0, 63,
  192, 121, 224, 112, 224, 224, 112, 224, 112, 255, 240, 255, 240, 224, 0, 224,
  0, 112, 112, 120, 240, 63, 224, 15, 128, 7, 19, 19, 9, 1, 0, 30,
  62, 56, 56, 56, 254, 254, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 12, 19, 38, 15, 1, 251, 31, 112, 63, 240, 121, 240, 112, 240,
  224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 112, 240, 121, 240,
  63, 240, 31, 112, 0, 112, 224, 112, 240, 224, 127, 224, 31, 128, 11, 19,
  38, 15, 2, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 239, 0,
  255, 192, 241, 192, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 3, 19, 19, 7, 2, 0,
  224, 224, 224, 0, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 5, 24, 24, 7, 0, 251, 56, 56, 56, 0, 0, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 248,
  240, 11, 19, 38, 14, 2, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 225, 192, 227, 192, 231, 128, 239, 0, 254, 0, 252, 0, 254, 0, 239,
  0, 231, 0, 231, 128, 227, 192, 225, 192, 225, 224, 224, 224, 3, 19, 19,
  7, 2, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 17, 14, 42, 21, 2, 0, 239, 62, 0, 255,
  255, 0, 243, 231, 128, 225, 195, 128, 225, 195, 128, 225, 195, 128, 225, 195,
  128, 225, 195, 128, 225, 195, 128, 225, 195, 128, 225, 195, 128, 225, 195, 128,
  225, 195, 128, 225, 195, 128, 11, 14, 28, 15, 2, 0, 239, 128, 255, 192,
  241, 192, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 12, 14, 28, 14, 1, 0, 15, 0,
  63, 192, 121, 224, 112, 224, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112,
  224, 112, 112, 224, 121, 224, 63, 192, 15, 0, 12, 19, 38, 15, 2, 251,
  239, 128, 255, 192, 249, 224, 240, 224, 224, 112, 224, 112, 224, 112, 224, 112,
  224, 112, 224, 112, 240, 224, 249, 224, 255, 192, 239, 128, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 12, 19, 38, 15, 1, 251, 31, 112, 63, 240,
  121, 240, 112, 240, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112,
  112, 240, 121, 240, 63, 240, 31, 112, 0, 112, 0, 112, 0, 112, 0, 112,
  0, 112, 7, 14, 14, 10, 2, 0, 238, 254, 254, 240, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 11, 14, 28, 13, 1, 0, 63, 0, 127, 128,
  243, 192, 225, 192, 224, 0, 252, 0, 127, 128, 15, 192, 1, 224, 224, 224,
  224, 224, 241, 224, 127, 192, 63, 128, 7, 18, 18, 9, 1, 0, 56, 56,
  56, 56, 254, 254, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 62, 30,
  11, 14, 28, 15, 2, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 225, 224, 115, 224, 126, 224,
  28, 224, 12, 14, 28, 14, 1, 0, 224, 112, 224, 112, 224, 112, 112, 224,
  112, 224, 112, 224, 57, 192, 57, 192, 57, 192, 31, 128, 31, 128, 15, 0,
  15, 0, 15, 0, 19, 14, 42, 19, 0, 0, 224, 224, 224, 224, 224, 224,
  96, 224, 192, 113, 241, 192, 113, 241, 192, 49, 177, 128, 51, 185, 128, 59,
  187, 128, 27, 27, 0, 31, 31, 0, 31, 31, 0, 14, 14, 0, 14, 14,
  0, 14, 14, 0, 11, 14, 28, 13, 1, 0, 224, 224, 241, 224, 113, 192,
  59, 128, 63, 128, 31, 0, 14, 0, 31, 0, 31, 0, 59, 128, 123, 192,
  113, 192, 241, 224, 224, 224, 13, 19, 38, 15, 1, 251, 224, 56, 224, 56,
  112, 56, 120, 112, 56, 112, 60, 240, 28, 224, 28, 224, 15, 192, 15, 192,
  7, 192, 7, 128, 3, 128, 3, 128, 7, 0, 7, 0, 14, 0, 62, 0,
  60, 0, 11, 14, 28, 13, 1, 0, 255, 224, 255, 224, 1, 192, 3, 128,
  7, 128, 15, 0, 14, 0, 30, 0, 60, 0, 56, 0, 112, 0, 240, 0,
  255, 224, 255, 224, 7, 24, 24, 10, 1, 251, 14, 28, 56, 56, 56, 56,
  56, 56, 56, 56, 112, 224, 224, 112, 56, 56, 56, 56, 56, 56, 56, 56,
  28, 14, 2, 24, 24, 7, 3, 251, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  7, 24, 24, 10, 2, 251, 224, 112, 56, 56, 56, 56, 56, 56, 56, 56,
  28, 14, 14, 28, 56, 56, 56, 56, 56, 56, 56, 56, 112, 224, 11, 4,
  8, 14, 1, 5, 120, 224, 254, 224, 239, 224, 227, 192, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
  6, 0, 1, 3, 19, 19, 7, 2, 251, 224, 224, 224, 0, 0, 96, 96,
  96, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 11, 18, 36, 14,
  1, 254, 1, 128, 1, 128, 31, 128, 63, 192, 123, 224, 115, 96, 227, 0,
  230, 0, 230, 0, 230, 0, 230, 0, 236, 0, 236, 224, 125, 224, 127, 192,
  63, 128, 24, 0, 24, 0, 13, 18, 36, 14, 1, 0, 31, 128, 63, 192,
  112, 224, 112, 224, 112, 0, 120, 0, 56, 0, 28, 0, 255, 192, 255, 192,
  28, 0, 28, 0, 28, 0, 56, 0, 56, 0, 127, 56, 255, 248, 241, 240,
  12, 12, 24, 14, 1, 3, 192, 48, 239, 112, 127, 224, 57, 192, 112, 224,
  112, 224, 112, 224, 112, 224, 57, 192, 127, 224, 239, 112, 192, 48, 13, 18,
  36, 14, 0, 0, 224, 56, 224, 56, 112, 112, 112, 112, 56, 224, 56, 224,
  29, 192, 29, 192, 127, 240, 127, 240, 7, 0, 127, 240, 127, 240, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 2, 24, 24, 7, 3, 251, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 0, 0, 0, 0, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 12, 24, 48, 14, 1, 251, 31, 128, 63, 192,
  121, 224, 112, 224, 120, 224, 60, 0, 30, 0, 127, 0, 247, 128, 227, 192,
  225, 224, 224, 224, 112, 112, 120, 112, 60, 112, 30, 224, 15, 192, 7, 128,
  3, 192, 113, 224, 112, 224, 121, 224, 63, 192, 31, 128, 7, 2, 2, 9,
  1, 16, 238, 238, 19, 19, 57, 19, 0, 0, 1, 240, 0, 15, 254, 0,
  30, 15, 0, 56, 3, 128, 112, 1, 192, 97, 240, 192, 227, 184, 224, 198,
  12, 96, 198, 0, 96, 198, 0, 96, 198, 0, 96, 198, 12, 96, 227, 184,
  224, 97, 240, 192, 112, 1, 192, 56, 3, 128, 30, 15, 0, 15, 254, 0,
  1, 240, 0, 8, 12, 12, 10, 1, 7, 124, 254, 198, 30, 126, 230, 198,
  255, 123, 0, 255, 255, 10, 8, 16, 13, 1, 3, 29, 192, 59, 128, 119,
  0, 238, 0, 238, 0, 119, 0, 59, 128, 29, 192, 12, 7, 14, 15, 1,
  4, 255, 240, 255, 240, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48, 7,
  3, 3, 8, 0, 6, 254, 254, 254, 19, 19, 57, 19, 0, 0, 3, 248,
  0, 15, 254, 0, 28, 15, 0, 56, 3, 128, 115, 249, 192, 99, 28, 192,
  227, 12, 224, 195, 12, 96, 195, 24, 96, 195, 240, 96, 195, 48, 96, 195,
  24, 96, 227, 24, 96, 99, 12, 224, 112, 0, 192, 56, 1, 192, 30, 3,
  128, 15, 254, 0, 3, 248, 0, 7, 2, 2, 9, 1, 17, 254, 254, 8,
  7, 7, 9, 0, 11, 60, 102, 195, 195, 195, 102, 60, 11, 13, 26, 15,
  2, 0, 14, 0, 14, 0, 14, 0, 14, 0, 255, 224, 255, 224, 14, 0,
  14, 0, 14, 0, 14, 0, 0, 0, 255, 224, 255, 224, 6, 10, 10, 7,
  0, 8, 120, 252, 204, 12, 28, 120, 224, 192, 252, 252, 6, 10, 10, 7,
  0, 8, 120, 252, 204, 12, 56, 56, 12, 204, 252, 120, 6, 4, 4, 8,
  1, 15, 28, 56, 112, 224, 11, 19, 38, 15, 2, 251, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  225, 224, 243, 224, 254, 224, 236, 224, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 11, 24, 48, 13, 1, 251, 15, 224, 63, 224, 124, 192, 124, 192,
  252, 192, 252, 192, 252, 192, 252, 192, 252, 192, 124, 192, 124, 192, 60, 192,
  28, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192,
  12, 192, 12, 192, 12, 192, 12, 192, 3, 3, 3, 7, 2, 6, 224, 224,
  224, 6, 6, 6, 8, 1, 251, 112, 120, 28, 28, 252, 120, 4, 10, 10,
  7, 1, 8, 48, 48, 240, 240, 48, 48, 48, 48, 48, 48, 8, 12, 12,
  10, 1, 7, 60, 126, 231, 195, 195, 195, 231, 126, 60, 0, 255, 255, 10,
  8, 16, 13, 1, 3, 238, 0, 119, 0, 59, 128, 29, 192, 29, 192, 59,
  128, 119, 0, 238, 0, 17, 18, 54, 19, 1, 0, 48, 24, 0, 48, 24,
  0, 240, 48, 0, 240, 48, 0, 48, 96, 0, 48, 96, 0, 48, 192, 0,
  48, 192, 0, 49, 134, 0, 49, 142, 0, 3, 30, 0, 3, 30, 0, 6,
  54, 0, 6, 102, 0, 12, 127, 128, 12, 127, 128, 24, 6, 0, 24, 6,
  0, 16, 18, 36, 19, 1, 0, 48, 24, 48, 24, 240, 48, 240, 48, 48,
  96, 48, 96, 48, 192, 48, 192, 49, 158, 49, 191, 3, 51, 3, 3, 6,
  7, 6, 30, 12, 56, 12, 48, 24, 63, 24, 63, 17, 18, 54, 19, 1,
  0, 120, 24, 0, 252, 24, 0, 204, 48, 0, 12, 48, 0, 56, 96, 0,
  56, 96, 0, 12, 192, 0, 204, 192, 0, 253, 134, 0, 121, 142, 0, 3,
  30, 0, 3, 30, 0, 6, 54, 0, 6, 102, 0, 12, 127, 128, 12, 127,
  128, 24, 6, 0, 24, 6, 0, 11, 19, 38, 15, 2, 251, 14, 0, 14,
  0, 14, 0, 0, 0, 0, 0, 14, 0, 14, 0, 14, 0, 14, 0, 28,
  0, 60, 0, 120, 0, 112, 0, 240, 224, 224, 224, 225, 224, 243, 192, 127,
  192, 63, 0, 16, 24, 48, 18, 1, 0, 14, 0, 7, 0, 3, 128, 1,
  192, 0, 0, 3, 192, 3, 192, 7, 224, 7, 224, 14, 96, 14, 112, 14,
  112, 28, 56, 28, 56, 28, 56, 56, 28, 56, 28, 63, 252, 127, 254, 112,
  14, 112, 14, 224, 7, 224, 7, 224, 7, 16, 24, 48, 18, 1, 0, 0,
  112, 0, 224, 1, 192, 3, 128, 0, 0, 3, 192, 3, 192, 7, 224, 7,
  224, 14, 96, 14, 112, 14, 112, 28, 56, 28, 56, 28, 56, 56, 28, 56,
  28, 63, 252, 127, 254, 112, 14, 112, 14, 224, 7, 224, 7, 224, 7, 16,
  24, 48, 18, 1, 0, 1, 192, 3, 224, 7, 112, 14, 56, 0, 0, 3,
  192, 3, 192, 7, 224, 7, 224, 14, 96, 14, 112, 14, 112, 28, 56, 28,
  56, 28, 56, 56, 28, 56, 28, 63, 252, 127, 254, 112, 14, 112, 14, 224,
  7, 224, 7, 224, 7, 16, 23, 46, 18, 1, 0, 7, 152, 15, 248, 12,
  240, 0, 0, 3, 192, 3, 192, 7, 224, 7, 224, 14, 96, 14, 112, 14,
  112, 28, 56, 28, 56, 28, 56, 56, 28, 56, 28, 63, 252, 127, 254, 112,
  14, 112, 14, 224, 7, 224, 7, 224, 7, 16, 23, 46, 18, 1, 0, 14,
  112, 14, 112, 0, 0, 0, 0, 3, 192, 3, 192, 7, 224, 7, 224, 14,
  96, 14, 112, 14, 112, 28, 56, 28, 56, 28, 56, 56, 28, 56, 28, 63,
  252, 127, 254, 112, 14, 112, 14, 224, 7, 224, 7, 224, 7, 16, 24, 48,
  18, 1, 0, 3, 192, 6, 96, 4, 32, 6, 96, 3, 192, 3, 192, 3,
  192, 7, 224, 7, 224, 14, 96, 14, 112, 14, 112, 28, 56, 28, 56, 28,
  56, 56, 28, 56, 28, 63, 252, 127, 254, 112, 14, 112, 14, 224, 7, 224,
  7, 224, 7, 22, 19, 57, 24, 1, 0, 3, 255, 248, 3, 255, 248, 7,
  112, 0, 7, 112, 0, 14, 112, 0, 14, 112, 0, 14, 112, 0, 28, 112,
  0, 28, 127, 240, 28, 127, 240, 56, 112, 0, 56, 112, 0, 63, 240, 0,
  127, 240, 0, 112, 112, 0, 112, 112, 0, 224, 112, 0, 224, 127, 252, 224,
  127, 252, 16, 24, 48, 18, 1, 251, 7, 240, 31, 252, 62, 62, 120, 15,
  112, 7, 240, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 240, 7, 112, 7, 120, 15, 62, 62, 31, 252, 7, 240, 3, 192,
  0, 224, 0, 224, 7, 224, 3, 192, 13, 24, 48, 16, 2, 0, 56, 0,
  28, 0, 14, 0, 7, 0, 0, 0, 255, 240, 255, 240, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 255, 224, 255, 224, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 248, 255, 248, 13, 24,
  48, 16, 2, 0, 1, 192, 3, 128, 7, 0, 14, 0, 0, 0, 255, 240,
  255, 240, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 224,
  255, 224, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  255, 248, 255, 248, 13, 24, 48, 16, 2, 0, 7, 0, 15, 128, 29, 192,
  56, 224, 0, 0, 255, 240, 255, 240, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 255, 224, 255, 224, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 255, 248, 255, 248, 13, 23, 46, 16, 2, 0,
  56, 224, 56, 224, 0, 0, 0, 0, 255, 240, 255, 240, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 255, 224, 255, 224, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 248, 255, 248, 6, 24,
  24, 7, 0, 0, 224, 112, 56, 28, 0, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 6, 24, 24, 7,
  1, 0, 28, 56, 112, 224, 0, 112, 112, 112, 112, 112, 112, 112, 112, 112,
  112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 9, 24, 48, 7, 255, 0,
  28, 0, 62, 0, 119, 0, 227, 128, 0, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  7, 23, 23, 7, 0, 0, 238, 238, 0, 0, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 19, 19, 57,
  19, 255, 0, 31, 252, 0, 31, 255, 0, 28, 15, 128, 28, 3, 192, 28,
  1, 192, 28, 1, 224, 28, 0, 224, 28, 0, 224, 255, 192, 224, 255, 192,
  224, 28, 0, 224, 28, 0, 224, 28, 0, 224, 28, 1, 224, 28, 1, 192,
  28, 3, 192, 28, 15, 128, 31, 255, 0, 31, 252, 0, 15, 23, 46, 19,
  2, 0, 15, 48, 31, 240, 25, 224, 0, 0, 224, 14, 240, 14, 240, 14,
  248, 14, 248, 14, 252, 14, 238, 14, 238, 14, 231, 14, 227, 142, 227, 142,
  225, 206, 224, 206, 224, 238, 224, 126, 224, 62, 224, 62, 224, 30, 224, 14,
  17, 24, 72, 19, 1, 0, 14, 0, 0, 7, 0, 0, 3, 128, 0, 1,
  192, 0, 0, 0, 0, 7, 240, 0, 31, 252, 0, 62, 62, 0, 120, 15,
  0, 112, 7, 0, 240, 7, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128,
  224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 240, 7, 128, 112,
  7, 0, 120, 15, 0, 62, 62, 0, 31, 252, 0, 7, 240, 0, 17, 24,
  72, 19, 1, 0, 0, 56, 0, 0, 112, 0, 0, 224, 0, 1, 192, 0,
  0, 0, 0, 7, 240, 0, 31, 252, 0, 62, 62, 0, 120, 15, 0, 112,
  7, 0, 240, 7, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3,
  128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 240, 7, 128, 112, 7, 0,
  120, 15, 0, 62, 62, 0, 31, 252, 0, 7, 240, 0, 17, 24, 72, 19,
  1, 0, 1, 192, 0, 3, 224, 0, 7, 112, 0, 14, 56, 0, 0, 0,
  0, 7, 240, 0, 31, 252, 0, 62, 62, 0, 120, 15, 0, 112, 7, 0,
  240, 7, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224,
  3, 128, 224, 3, 128, 224, 3, 128, 240, 7, 128, 112, 7, 0, 120, 15,
  0, 62, 62, 0, 31, 252, 0, 7, 240, 0, 17, 23, 69, 19, 1, 0,
  7, 152, 0, 15, 248, 0, 12, 240, 0, 0, 0, 0, 7, 240, 0, 31,
  252, 0, 62, 62, 0, 120, 15, 0, 112, 7, 0, 240, 7, 128, 224, 3,
  128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128,
  224, 3, 128, 240, 7, 128, 112, 7, 0, 120, 15, 0, 62, 62, 0, 31,
  252, 0, 7, 240, 0, 17, 23, 69, 19, 1, 0, 14, 56, 0, 14, 56,
  0, 0, 0, 0, 0, 0, 0, 7, 240, 0, 31, 252, 0, 62, 62, 0,
  120, 15, 0, 112, 7, 0, 240, 7, 128, 224, 3, 128, 224, 3, 128, 224,
  3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 240, 7,
  128, 112, 7, 0, 120, 15, 0, 62, 62, 0, 31, 252, 0, 7, 240, 0,
  12, 12, 24, 15, 1, 1, 64, 32, 224, 112, 112, 224, 57, 192, 31, 128,
  15, 0, 15, 0, 31, 128, 57, 192, 112, 224, 224, 112, 64, 32, 19, 19,
  57, 19, 0, 0, 3, 248, 96, 15, 254, 224, 31, 31, 192, 60, 3, 128,
  56, 7, 128, 120, 15, 192, 112, 29, 192, 112, 57, 192, 112, 113, 192, 112,
  225, 192, 113, 193, 192, 115, 129, 192, 119, 1, 192, 126, 3, 192, 60, 3,
  128, 60, 7, 128, 127, 31, 0, 239, 254, 0, 195, 248, 0, 15, 24, 48,
  19, 2, 0, 14, 0, 7, 0, 3, 128, 1, 192, 0, 0, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 224, 14, 240, 30, 112, 28, 124, 124, 63,
  248, 15, 224, 15, 24, 48, 19, 2, 0, 0, 112, 0, 224, 1, 192, 3,
  128, 0, 0, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 240,
  30, 112, 28, 124, 124, 63, 248, 15, 224, 15, 24, 48, 19, 2, 0, 3,
  128, 7, 192, 14, 224, 28, 112, 0, 0, 224, 14, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 14, 240, 30, 112, 28, 124, 124, 63, 248, 15, 224, 15,
  23, 46, 19, 2, 0, 28, 112, 28, 112, 0, 0, 0, 0, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 224, 14, 240, 30, 112, 28, 124, 124, 63,
  248, 15, 224, 15, 24, 48, 17, 1, 0, 0, 112, 0, 224, 1, 192, 3,
  128, 0, 0, 224, 14, 240, 30, 112, 28, 120, 60, 56, 56, 60, 120, 28,
  112, 30, 240, 14, 224, 15, 224, 7, 192, 7, 192, 3, 128, 3, 128, 3,
  128, 3, 128, 3, 128, 3, 128, 3, 128, 14, 19, 38, 17, 2, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 255, 224, 255, 248, 224, 56, 224, 28, 224,
  28, 224, 28, 224, 28, 224, 56, 255, 248, 255, 240, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 11, 19, 38, 14, 2, 0, 30, 0, 127, 128, 243,
  128, 225, 192, 225, 192, 225, 192, 225, 192, 227, 128, 239, 0, 239, 128, 227,
  192, 225, 192, 224, 224, 224, 224, 224, 224, 224, 224, 225, 192, 239, 192, 239,
  128, 12, 19, 38, 14, 1, 0, 28, 0, 14, 0, 7, 0, 3, 128, 0,
  0, 31, 128, 63, 192, 113, 224, 112, 224, 0, 224, 7, 224, 63, 224, 124,
  224, 240, 224, 224, 224, 225, 224, 243, 224, 127, 240, 62, 112, 12, 19, 38,
  14, 1, 0, 1, 192, 3, 128, 7, 0, 14, 0, 0, 0, 31, 128, 63,
  192, 113, 224, 112, 224, 0, 224, 7, 224, 63, 224, 124, 224, 240, 224, 224,
  224, 225, 224, 243, 224, 127, 240, 62, 112, 12, 19, 38, 14, 1, 0, 7,
  0, 15, 128, 29, 192, 56, 224, 0, 0, 31, 128, 63, 192, 113, 224, 112,
  224, 0, 224, 7, 224, 63, 224, 124, 224, 240, 224, 224, 224, 225, 224, 243,
  224, 127, 240, 62, 112, 12, 19, 38, 14, 1, 0, 60, 192, 127, 192, 103,
  128, 0, 0, 0, 0, 31, 128, 63, 192, 113, 224, 112, 224, 0, 224, 7,
  224, 63, 224, 124, 224, 240, 224, 224, 224, 225, 224, 243, 224, 127, 240, 62,
  112, 12, 18, 36, 14, 1, 0, 57, 192, 57, 192, 0, 0, 0, 0, 31,
  128, 63, 192, 113, 224, 112, 224, 0, 224, 7, 224, 63, 224, 124, 224, 240,
  224, 224, 224, 225, 224, 243, 224, 127, 240, 62, 112, 12, 19, 38, 14, 1,
  0, 7, 0, 13, 128, 8, 128, 13, 128, 7, 0, 31, 128, 63, 192, 113,
  224, 112, 224, 0, 224, 7, 224, 63, 224, 124, 224, 240, 224, 224, 224, 225,
  224, 243, 224, 127, 240, 62, 112, 20, 14, 42, 22, 1, 0, 31, 143, 0,
  63, 255, 192, 113, 249, 224, 112, 240, 224, 0, 224, 112, 7, 224, 112, 63,
  255, 240, 124, 255, 240, 240, 224, 0, 224, 224, 0, 225, 240, 112, 243, 248,
  240, 127, 63, 224, 62, 15, 128, 11, 19, 38, 13, 1, 251, 31, 128, 63,
  192, 121, 224, 112, 224, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 112, 224, 121, 224, 63, 192, 31, 128, 30, 0, 7, 0, 7, 0, 63,
  0, 30, 0, 12, 19, 38, 14, 1, 0, 28, 0, 14, 0, 7, 0, 3,
  128, 0, 0, 15, 0, 63, 192, 121, 224, 112, 224, 224, 112, 224, 112, 255,
  240, 255, 240, 224, 0, 224, 0, 112, 112, 120, 240, 63, 224, 15, 128, 12,
  19, 38, 14, 1, 0, 3, 128, 7, 0, 14, 0, 28, 0, 0, 0, 15,
  0, 63, 192, 121, 224, 112, 224, 224, 112, 224, 112, 255, 240, 255, 240, 224,
  0, 224, 0, 112, 112, 120, 240, 63, 224, 15, 128, 12, 19, 38, 14, 1,
  0, 7, 0, 15, 128, 29, 192, 56, 224, 0, 0, 15, 0, 63, 192, 121,
  224, 112, 224, 224, 112, 224, 112, 255, 240, 255, 240, 224, 0, 224, 0, 112,
  112, 120, 240, 63, 224, 15, 128, 12, 18, 36, 14, 1, 0, 57, 192, 57,
  192, 0, 0, 0, 0, 15, 0, 63, 192, 121, 224, 112, 224, 224, 112, 224,
  112, 255, 240, 255, 240, 224, 0, 224, 0, 112, 112, 120, 240, 63, 224, 15,
  128, 6, 19, 19, 7, 0, 0, 224, 112, 56, 28, 0, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 6, 19, 19, 7, 1, 0,
  28, 56, 112, 224, 0, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
  112, 112, 112, 9, 19, 38, 7, 255, 0, 28, 0, 62, 0, 119, 0, 227,
  128, 0, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 7,
  18, 18, 7, 0, 0, 238, 238, 0, 0, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 12, 19, 38, 14, 1, 0, 112, 0, 29,
  192, 7, 0, 31, 0, 97, 128, 15, 192, 63, 192, 121, 224, 112, 224, 224,
  112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 112, 224, 121, 224, 63,
  192, 15, 0, 11, 19, 38, 15, 2, 0, 60, 192, 127, 192, 103, 128, 0,
  0, 0, 0, 239, 128, 255, 192, 241, 192, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 12,
  19, 38, 14, 1, 0, 28, 0, 14, 0, 7, 0, 3, 128, 0, 0, 15,
  0, 63, 192, 121, 224, 112, 224, 224, 112, 224, 112, 224, 112, 224, 112, 224,
  112, 224, 112, 112, 224, 121, 224, 63, 192, 15, 0, 12, 19, 38, 14, 1,
  0, 3, 128, 7, 0, 14, 0, 28, 0, 0, 0, 15, 0, 63, 192, 121,
  224, 112, 224, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 112,
  224, 121, 224, 63, 192, 15, 0, 12, 19, 38, 14, 1, 0, 14, 0, 31,
  0, 59, 128, 113, 192, 0, 0, 15, 0, 63, 192, 121, 224, 112, 224, 224,
  112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 112, 224, 121, 224, 63,
  192, 15, 0, 12, 19, 38, 14, 1, 0, 60, 192, 127, 192, 103, 128, 0,
  0, 0, 0, 15, 0, 63, 192, 121, 224, 112, 224, 224, 112, 224, 112, 224,
  112, 224, 112, 224, 112, 224, 112, 112, 224, 121, 224, 63, 192, 15, 0, 12,
  18, 36, 14, 1, 0, 57, 192, 57, 192, 0, 0, 0, 0, 15, 0, 63,
  192, 121, 224, 112, 224, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224,
  112, 112, 224, 121, 224, 63, 192, 15, 0, 11, 12, 24, 15, 2, 1, 14,
  0, 14, 0, 14, 0, 0, 0, 0, 0, 255, 224, 255, 224, 0, 0, 0,
  0, 14, 0, 14, 0, 14, 0, 14, 14, 28, 14, 0, 0, 7, 140, 31,
  252, 60, 248, 56, 112, 112, 248, 113, 248, 115, 184, 119, 56, 126, 56, 124,
  56, 56, 112, 124, 240, 255, 224, 199, 128, 11, 19, 38, 15, 2, 0, 56,
  0, 28, 0, 14, 0, 7, 0, 0, 0, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 225, 224, 115,
  224, 126, 224, 28, 224, 11, 19, 38, 15, 2, 0, 3, 128, 7, 0, 14,
  0, 28, 0, 0, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 225, 224, 115, 224, 126, 224, 28,
  224, 11, 19, 38, 15, 2, 0, 14, 0, 31, 0, 59, 128, 113, 192, 0,
  0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 225, 224, 115, 224, 126, 224, 28, 224, 11, 18, 36,
  15, 2, 0, 57, 192, 57, 192, 0, 0, 0, 0, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 225,
  224, 115, 224, 126, 224, 28, 224, 13, 24, 48, 15, 1, 251, 0, 224, 1,
  192, 3, 128, 7, 0, 0, 0, 224, 56, 224, 56, 112, 56, 120, 112, 56,
  112, 60, 240, 28, 224, 28, 224, 15, 192, 15, 192, 7, 192, 7, 128, 3,
  128, 3, 128, 7, 0, 7, 0, 14, 0, 62, 0, 60, 0, 12, 24, 48,
  15, 2, 251, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 239, 128, 255,
  192, 249, 224, 240, 224, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224,
  112, 240, 224, 249, 224, 255, 192, 239, 128, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 13, 23, 46, 15, 1, 251, 28, 224, 28, 224, 0, 0, 0,
  0, 224, 56, 224, 56, 112, 56, 120, 112, 56, 112, 60, 240, 28, 224, 28,
  224, 15, 192, 15, 192, 7, 192, 7, 128, 3, 128, 3, 128, 7, 0, 7,
  0, 14, 0, 62, 0, 60, 0
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--25-180-100-100-P-138-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 0, '1' Height: 18
  Calculated Max Values w=12 h=19 x= 2 y=12 dx=15 dy= 0 ascent=19 len=36
  Font Bounding box     w=28 h=37 x=-2 y=-8
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =18 descent= 0
  X Font      ascent =18 descent= 0
  Max Font    ascent =19 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_helvB18n[537] U8G_FONT_SECTION("u8g_font_helvB18n") = {
  0, 28, 37, 254, 248, 18, 0, 0, 0, 0, 42, 58, 0, 19, 253, 18,
  0, 8, 7, 7, 10, 1, 12, 24, 24, 219, 255, 60, 102, 102, 12, 12,
  24, 15, 1, 1, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 255, 240,
  255, 240, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 3, 6, 6, 7,
  2, 253, 224, 224, 224, 96, 96, 192, 7, 3, 3, 8, 0, 6, 254, 254,
  254, 3, 3, 3, 7, 2, 0, 224, 224, 224, 7, 19, 19, 8, 1, 0,
  6, 6, 6, 12, 12, 12, 24, 24, 24, 24, 48, 48, 48, 96, 96, 96,
  192, 192, 192, 12, 18, 36, 13, 0, 0, 31, 128, 63, 192, 121, 224, 112,
  224, 112, 224, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224,
  112, 224, 112, 112, 224, 112, 224, 121, 224, 63, 192, 31, 128, 7, 18, 18,
  13, 2, 0, 14, 14, 30, 254, 254, 14, 14, 14, 14, 14, 14, 14, 14,
  14, 14, 14, 14, 14, 12, 18, 36, 13, 0, 0, 31, 0, 127, 192, 113,
  224, 224, 224, 224, 112, 224, 112, 0, 112, 0, 224, 1, 224, 3, 192, 7,
  128, 31, 0, 60, 0, 120, 0, 240, 0, 224, 0, 255, 240, 255, 240, 12,
  18, 36, 13, 0, 0, 31, 0, 127, 192, 113, 192, 224, 224, 224, 224, 224,
  224, 0, 224, 1, 192, 15, 128, 15, 224, 0, 224, 0, 112, 0, 112, 224,
  112, 224, 240, 113, 224, 127, 224, 31, 128, 12, 18, 36, 13, 0, 0, 1,
  192, 3, 192, 3, 192, 7, 192, 7, 192, 13, 192, 29, 192, 25, 192, 49,
  192, 113, 192, 97, 192, 225, 192, 255, 240, 255, 240, 1, 192, 1, 192, 1,
  192, 1, 192, 12, 18, 36, 13, 0, 0, 127, 224, 127, 224, 112, 0, 112,
  0, 112, 0, 112, 0, 127, 128, 127, 192, 113, 224, 0, 224, 0, 112, 0,
  112, 0, 112, 224, 112, 224, 240, 241, 224, 127, 192, 31, 128, 12, 18, 36,
  13, 0, 0, 15, 128, 63, 224, 120, 224, 112, 112, 224, 112, 224, 0, 224,
  0, 239, 0, 255, 192, 249, 224, 240, 224, 224, 112, 224, 112, 224, 112, 112,
  224, 121, 224, 63, 192, 31, 128, 12, 18, 36, 13, 0, 0, 255, 240, 255,
  240, 0, 240, 0, 224, 1, 192, 1, 192, 3, 128, 3, 128, 7, 0, 7,
  0, 14, 0, 14, 0, 30, 0, 28, 0, 28, 0, 60, 0, 56, 0, 56,
  0, 12, 18, 36, 13, 0, 0, 15, 0, 63, 192, 57, 192, 112, 224, 112,
  224, 112, 224, 112, 224, 57, 192, 31, 128, 63, 192, 112, 224, 224, 112, 224,
  112, 224, 112, 224, 112, 112, 224, 127, 224, 31, 128, 12, 18, 36, 13, 0,
  0, 31, 128, 127, 192, 121, 224, 240, 224, 224, 112, 224, 112, 224, 112, 224,
  112, 240, 240, 121, 240, 127, 240, 31, 112, 0, 112, 0, 112, 224, 224, 243,
  224, 127, 192, 31, 0, 3, 14, 14, 7, 2, 0, 224, 224, 224, 0, 0,
  0, 0, 0, 0, 0, 0, 224, 224, 224
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--25-180-100-100-P-138-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 19, '1' Height: 18
  Calculated Max Values w=22 h=24 x= 3 y=15 dx=24 dy= 0 ascent=19 len=66
  Font Bounding box     w=28 h=37 x=-2 y=-8
  Calculated Min Values           x= 0 y=-5 dx= 0 dy= 0
  Pure Font   ascent =19 descent=-5
  X Font      ascent =19 descent=-5
  Max Font    ascent =19 descent=-5
*/
const u8g_fntpgm_uint8_t u8g_font_helvB18r[3453] U8G_FONT_SECTION("u8g_font_helvB18r") = {
  0, 28, 37, 254, 248, 19, 4, 35, 9, 107, 32, 127, 251, 19, 251, 19,
  251, 0, 0, 0, 6, 0, 1, 3, 19, 19, 7, 2, 0, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 192, 192, 192, 0, 0, 224, 224, 224,
  5, 6, 6, 9, 2, 13, 216, 216, 216, 216, 216, 144, 12, 18, 36, 14,
  1, 0, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 127, 240, 127, 240,
  25, 128, 25, 128, 25, 128, 25, 128, 255, 224, 255, 224, 51, 0, 51, 0,
  51, 0, 51, 0, 51, 0, 12, 21, 42, 13, 0, 254, 6, 0, 63, 128,
  127, 224, 246, 224, 230, 112, 230, 112, 246, 0, 126, 0, 62, 0, 15, 0,
  7, 192, 7, 224, 6, 240, 230, 112, 230, 112, 230, 112, 246, 240, 127, 224,
  31, 192, 6, 0, 6, 0, 21, 18, 54, 22, 0, 0, 0, 7, 0, 62,
  7, 0, 127, 14, 0, 227, 142, 0, 193, 156, 0, 193, 156, 0, 227, 184,
  0, 127, 56, 0, 62, 112, 0, 0, 112, 0, 0, 227, 224, 0, 231, 240,
  1, 206, 56, 1, 204, 24, 3, 140, 24, 3, 142, 56, 7, 7, 240, 7,
  3, 224, 16, 18, 36, 18, 1, 0, 15, 128, 31, 192, 61, 224, 56, 224,
  56, 224, 56, 224, 29, 192, 15, 128, 31, 0, 63, 156, 123, 220, 113, 252,
  224, 248, 224, 112, 224, 248, 241, 252, 127, 206, 31, 135, 2, 6, 6, 6,
  2, 13, 192, 192, 192, 192, 192, 128, 6, 24, 24, 8, 1, 251, 12, 28,
  56, 56, 112, 112, 96, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 96,
  112, 112, 56, 56, 28, 12, 6, 24, 24, 8, 1, 251, 192, 224, 112, 112,
  56, 56, 24, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 24, 56, 56,
  112, 112, 224, 192, 8, 7, 7, 10, 1, 12, 24, 24, 219, 255, 60, 102,
  102, 12, 12, 24, 15, 1, 1, 6, 0, 6, 0, 6, 0, 6, 0, 6,
  0, 255, 240, 255, 240, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 3,
  6, 6, 7, 2, 253, 224, 224, 224, 96, 96, 192, 7, 3, 3, 8, 0,
  6, 254, 254, 254, 3, 3, 3, 7, 2, 0, 224, 224, 224, 7, 19, 19,
  8, 1, 0, 6, 6, 6, 12, 12, 12, 24, 24, 24, 24, 48, 48, 48,
  96, 96, 96, 192, 192, 192, 12, 18, 36, 13, 0, 0, 31, 128, 63, 192,
  121, 224, 112, 224, 112, 224, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112,
  224, 112, 224, 112, 224, 112, 112, 224, 112, 224, 121, 224, 63, 192, 31, 128,
  7, 18, 18, 13, 2, 0, 14, 14, 30, 254, 254, 14, 14, 14, 14, 14,
  14, 14, 14, 14, 14, 14, 14, 14, 12, 18, 36, 13, 0, 0, 31, 0,
  127, 192, 113, 224, 224, 224, 224, 112, 224, 112, 0, 112, 0, 224, 1, 224,
  3, 192, 7, 128, 31, 0, 60, 0, 120, 0, 240, 0, 224, 0, 255, 240,
  255, 240, 12, 18, 36, 13, 0, 0, 31, 0, 127, 192, 113, 192, 224, 224,
  224, 224, 224, 224, 0, 224, 1, 192, 15, 128, 15, 224, 0, 224, 0, 112,
  0, 112, 224, 112, 224, 240, 113, 224, 127, 224, 31, 128, 12, 18, 36, 13,
  0, 0, 1, 192, 3, 192, 3, 192, 7, 192, 7, 192, 13, 192, 29, 192,
  25, 192, 49, 192, 113, 192, 97, 192, 225, 192, 255, 240, 255, 240, 1, 192,
  1, 192, 1, 192, 1, 192, 12, 18, 36, 13, 0, 0, 127, 224, 127, 224,
  112, 0, 112, 0, 112, 0, 112, 0, 127, 128, 127, 192, 113, 224, 0, 224,
  0, 112, 0, 112, 0, 112, 224, 112, 224, 240, 241, 224, 127, 192, 31, 128,
  12, 18, 36, 13, 0, 0, 15, 128, 63, 224, 120, 224, 112, 112, 224, 112,
  224, 0, 224, 0, 239, 0, 255, 192, 249, 224, 240, 224, 224, 112, 224, 112,
  224, 112, 112, 224, 121, 224, 63, 192, 31, 128, 12, 18, 36, 13, 0, 0,
  255, 240, 255, 240, 0, 240, 0, 224, 1, 192, 1, 192, 3, 128, 3, 128,
  7, 0, 7, 0, 14, 0, 14, 0, 30, 0, 28, 0, 28, 0, 60, 0,
  56, 0, 56, 0, 12, 18, 36, 13, 0, 0, 15, 0, 63, 192, 57, 192,
  112, 224, 112, 224, 112, 224, 112, 224, 57, 192, 31, 128, 63, 192, 112, 224,
  224, 112, 224, 112, 224, 112, 224, 112, 112, 224, 127, 224, 31, 128, 12, 18,
  36, 13, 0, 0, 31, 128, 127, 192, 121, 224, 240, 224, 224, 112, 224, 112,
  224, 112, 224, 112, 240, 240, 121, 240, 127, 240, 31, 112, 0, 112, 0, 112,
  224, 224, 243, 224, 127, 192, 31, 0, 3, 14, 14, 7, 2, 0, 224, 224,
  224, 0, 0, 0, 0, 0, 0, 0, 0, 224, 224, 224, 3, 17, 17, 7,
  2, 253, 224, 224, 224, 0, 0, 0, 0, 0, 0, 0, 0, 224, 224, 224,
  96, 96, 192, 13, 12, 24, 15, 0, 1, 0, 56, 0, 248, 3, 224, 15,
  128, 62, 0, 240, 0, 240, 0, 62, 0, 15, 128, 3, 224, 0, 248, 0,
  56, 10, 5, 10, 14, 2, 5, 255, 192, 255, 192, 0, 0, 255, 192, 255,
  192, 13, 12, 24, 14, 1, 1, 224, 0, 248, 0, 62, 0, 15, 128, 3,
  224, 0, 120, 0, 120, 3, 224, 15, 128, 62, 0, 248, 0, 224, 0, 11,
  19, 38, 15, 2, 0, 31, 128, 127, 192, 121, 224, 240, 224, 224, 224, 225,
  224, 1, 192, 3, 192, 7, 128, 7, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 0, 0, 0, 0, 14, 0, 14, 0, 14, 0, 22, 22, 66, 24, 1,
  252, 1, 255, 0, 7, 255, 192, 15, 129, 240, 30, 0, 120, 60, 0, 56,
  120, 125, 156, 112, 255, 156, 241, 199, 28, 227, 135, 28, 227, 14, 28, 231,
  14, 56, 231, 12, 56, 231, 28, 112, 231, 28, 112, 227, 157, 224, 243, 255,
  192, 113, 247, 0, 120, 0, 0, 60, 0, 0, 31, 7, 0, 15, 255, 0,
  3, 252, 0, 16, 19, 38, 18, 1, 0, 3, 192, 3, 192, 7, 224, 7,
  224, 14, 96, 14, 112, 14, 112, 28, 56, 28, 56, 28, 56, 56, 28, 56,
  28, 63, 252, 127, 254, 112, 14, 112, 14, 224, 7, 224, 7, 224, 7, 15,
  19, 38, 18, 2, 0, 255, 224, 255, 248, 224, 120, 224, 28, 224, 28, 224,
  28, 224, 28, 224, 56, 255, 240, 255, 248, 224, 28, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 30, 224, 124, 255, 248, 255, 224, 16, 19, 38, 18, 1,
  0, 7, 240, 31, 252, 62, 62, 120, 15, 112, 7, 240, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 240, 7, 112, 7, 120,
  15, 62, 62, 31, 252, 7, 240, 16, 19, 38, 19, 2, 0, 255, 224, 255,
  248, 224, 124, 224, 30, 224, 14, 224, 15, 224, 7, 224, 7, 224, 7, 224,
  7, 224, 7, 224, 7, 224, 7, 224, 15, 224, 14, 224, 30, 224, 124, 255,
  248, 255, 224, 13, 19, 38, 16, 2, 0, 255, 240, 255, 240, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 224, 255, 224, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 248, 255, 248, 12,
  19, 38, 15, 2, 0, 255, 240, 255, 240, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 255, 224, 255, 224, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 17, 19, 57, 19, 1,
  0, 7, 240, 0, 31, 252, 0, 62, 62, 0, 120, 15, 0, 112, 7, 0,
  240, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 127, 128, 224,
  127, 128, 224, 3, 128, 224, 3, 128, 240, 3, 128, 112, 7, 128, 120, 15,
  128, 62, 63, 128, 31, 251, 128, 7, 243, 128, 15, 19, 38, 19, 2, 0,
  224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14,
  255, 254, 255, 254, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14,
  224, 14, 224, 14, 224, 14, 3, 19, 19, 7, 2, 0, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 11,
  19, 38, 14, 1, 0, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 113, 224, 127, 192, 63, 128, 14, 19, 38, 18, 2,
  0, 224, 60, 224, 120, 224, 240, 225, 224, 227, 192, 231, 128, 239, 0, 254,
  0, 254, 0, 255, 0, 247, 128, 227, 128, 225, 192, 225, 224, 224, 224, 224,
  112, 224, 120, 224, 56, 224, 60, 12, 19, 38, 15, 2, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255,
  240, 255, 240, 19, 19, 57, 23, 2, 0, 224, 0, 224, 240, 1, 224, 240,
  1, 224, 248, 3, 224, 248, 3, 224, 252, 7, 224, 236, 6, 224, 238, 14,
  224, 230, 12, 224, 231, 28, 224, 231, 28, 224, 227, 24, 224, 227, 184, 224,
  227, 184, 224, 225, 240, 224, 225, 240, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 15, 19, 38, 19, 2, 0, 224, 14, 240, 14, 240, 14, 248, 14,
  248, 14, 252, 14, 238, 14, 238, 14, 231, 14, 227, 142, 227, 142, 225, 206,
  224, 206, 224, 238, 224, 126, 224, 62, 224, 62, 224, 30, 224, 14, 17, 19,
  57, 19, 1, 0, 7, 240, 0, 31, 252, 0, 62, 62, 0, 120, 15, 0,
  112, 7, 0, 240, 7, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224,
  3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 240, 7, 128, 112, 7,
  0, 120, 15, 0, 62, 62, 0, 31, 252, 0, 7, 240, 0, 14, 19, 38,
  17, 2, 0, 255, 224, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224,
  28, 224, 56, 255, 248, 255, 240, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 17, 20, 60, 19, 1, 255, 7,
  240, 0, 31, 252, 0, 62, 62, 0, 120, 15, 0, 112, 7, 0, 240, 7,
  128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128,
  224, 3, 128, 224, 3, 128, 240, 39, 128, 112, 119, 0, 120, 63, 0, 62,
  30, 0, 31, 254, 0, 7, 247, 0, 0, 2, 0, 14, 19, 38, 17, 2,
  0, 255, 224, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224,
  56, 255, 248, 255, 240, 224, 120, 224, 56, 224, 28, 224, 28, 224, 28, 224,
  28, 224, 28, 224, 28, 224, 28, 14, 19, 38, 17, 2, 0, 15, 192, 63,
  240, 120, 248, 240, 56, 224, 56, 224, 0, 240, 0, 124, 0, 63, 192, 7,
  240, 0, 248, 0, 60, 0, 28, 224, 28, 224, 28, 224, 60, 248, 248, 127,
  240, 31, 192, 15, 19, 38, 15, 0, 0, 255, 254, 255, 254, 3, 128, 3,
  128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3,
  128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 15,
  19, 38, 19, 2, 0, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224,
  14, 240, 30, 112, 28, 124, 124, 63, 248, 15, 224, 16, 19, 38, 18, 1,
  0, 224, 7, 224, 7, 240, 15, 112, 14, 120, 30, 56, 28, 56, 28, 60,
  60, 28, 56, 28, 56, 30, 120, 14, 112, 14, 112, 14, 112, 7, 224, 7,
  224, 3, 192, 3, 192, 3, 192, 21, 19, 57, 23, 1, 0, 224, 112, 56,
  224, 112, 56, 224, 112, 56, 224, 112, 56, 112, 248, 112, 112, 248, 112, 112,
  216, 112, 113, 220, 112, 49, 220, 96, 57, 220, 224, 57, 140, 224, 59, 142,
  224, 27, 142, 192, 27, 142, 192, 31, 7, 192, 31, 7, 192, 14, 3, 128,
  14, 3, 128, 14, 3, 128, 16, 19, 38, 18, 1, 0, 224, 7, 240, 15,
  120, 30, 56, 28, 28, 56, 14, 112, 15, 240, 7, 224, 3, 192, 3, 192,
  7, 224, 15, 240, 14, 112, 28, 56, 60, 60, 56, 28, 112, 14, 240, 15,
  224, 7, 15, 19, 38, 17, 1, 0, 224, 14, 240, 14, 112, 28, 120, 28,
  56, 56, 60, 56, 28, 112, 28, 112, 14, 224, 14, 224, 7, 192, 7, 192,
  3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 14, 19,
  38, 16, 1, 0, 255, 252, 255, 252, 0, 60, 0, 120, 0, 240, 1, 224,
  1, 224, 3, 192, 7, 128, 7, 128, 15, 0, 30, 0, 30, 0, 60, 0,
  56, 0, 120, 0, 240, 0, 255, 252, 255, 252, 5, 24, 24, 8, 1, 251,
  248, 248, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 248, 248, 7, 19, 19, 8, 0, 0, 192, 192,
  192, 96, 96, 96, 48, 48, 48, 48, 24, 24, 24, 12, 12, 12, 6, 6,
  6, 5, 24, 24, 8, 2, 251, 248, 248, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 248, 248, 11,
  9, 18, 14, 1, 10, 14, 0, 14, 0, 31, 0, 27, 0, 59, 128, 113,
  192, 113, 192, 224, 224, 224, 224, 14, 2, 4, 14, 0, 251, 255, 252, 255,
  252, 6, 4, 4, 8, 1, 15, 224, 112, 56, 28, 12, 14, 28, 14, 1,
  0, 31, 128, 63, 192, 113, 224, 112, 224, 0, 224, 7, 224, 63, 224, 124,
  224, 240, 224, 224, 224, 225, 224, 243, 224, 127, 240, 62, 112, 12, 19, 38,
  15, 2, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 239, 128, 255,
  192, 249, 224, 240, 224, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224,
  112, 240, 224, 249, 224, 255, 192, 239, 128, 11, 14, 28, 13, 1, 0, 31,
  128, 63, 192, 121, 224, 112, 224, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 112, 224, 121, 224, 63, 192, 31, 128, 12, 19, 38, 15, 1,
  0, 0, 112, 0, 112, 0, 112, 0, 112, 0, 112, 31, 112, 63, 240, 121,
  240, 112, 240, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 112,
  240, 121, 240, 63, 240, 31, 112, 12, 14, 28, 14, 1, 0, 15, 0, 63,
  192, 121, 224, 112, 224, 224, 112, 224, 112, 255, 240, 255, 240, 224, 0, 224,
  0, 112, 112, 120, 240, 63, 224, 15, 128, 7, 19, 19, 9, 1, 0, 30,
  62, 56, 56, 56, 254, 254, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 12, 19, 38, 15, 1, 251, 31, 112, 63, 240, 121, 240, 112, 240,
  224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 112, 240, 121, 240,
  63, 240, 31, 112, 0, 112, 224, 112, 240, 224, 127, 224, 31, 128, 11, 19,
  38, 15, 2, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 239, 0,
  255, 192, 241, 192, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 3, 19, 19, 7, 2, 0,
  224, 224, 224, 0, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 5, 24, 24, 7, 0, 251, 56, 56, 56, 0, 0, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 248,
  240, 11, 19, 38, 14, 2, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 225, 192, 227, 192, 231, 128, 239, 0, 254, 0, 252, 0, 254, 0, 239,
  0, 231, 0, 231, 128, 227, 192, 225, 192, 225, 224, 224, 224, 3, 19, 19,
  7, 2, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 17, 14, 42, 21, 2, 0, 239, 62, 0, 255,
  255, 0, 243, 231, 128, 225, 195, 128, 225, 195, 128, 225, 195, 128, 225, 195,
  128, 225, 195, 128, 225, 195, 128, 225, 195, 128, 225, 195, 128, 225, 195, 128,
  225, 195, 128, 225, 195, 128, 11, 14, 28, 15, 2, 0, 239, 128, 255, 192,
  241, 192, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 12, 14, 28, 14, 1, 0, 15, 0,
  63, 192, 121, 224, 112, 224, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112,
  224, 112, 112, 224, 121, 224, 63, 192, 15, 0, 12, 19, 38, 15, 2, 251,
  239, 128, 255, 192, 249, 224, 240, 224, 224, 112, 224, 112, 224, 112, 224, 112,
  224, 112, 224, 112, 240, 224, 249, 224, 255, 192, 239, 128, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 12, 19, 38, 15, 1, 251, 31, 112, 63, 240,
  121, 240, 112, 240, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 112,
  112, 240, 121, 240, 63, 240, 31, 112, 0, 112, 0, 112, 0, 112, 0, 112,
  0, 112, 7, 14, 14, 10, 2, 0, 238, 254, 254, 240, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 11, 14, 28, 13, 1, 0, 63, 0, 127, 128,
  243, 192, 225, 192, 224, 0, 252, 0, 127, 128, 15, 192, 1, 224, 224, 224,
  224, 224, 241, 224, 127, 192, 63, 128, 7, 18, 18, 9, 1, 0, 56, 56,
  56, 56, 254, 254, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 62, 30,
  11, 14, 28, 15, 2, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 225, 224, 115, 224, 126, 224,
  28, 224, 12, 14, 28, 14, 1, 0, 224, 112, 224, 112, 224, 112, 112, 224,
  112, 224, 112, 224, 57, 192, 57, 192, 57, 192, 31, 128, 31, 128, 15, 0,
  15, 0, 15, 0, 19, 14, 42, 19, 0, 0, 224, 224, 224, 224, 224, 224,
  96, 224, 192, 113, 241, 192, 113, 241, 192, 49, 177, 128, 51, 185, 128, 59,
  187, 128, 27, 27, 0, 31, 31, 0, 31, 31, 0, 14, 14, 0, 14, 14,
  0, 14, 14, 0, 11, 14, 28, 13, 1, 0, 224, 224, 241, 224, 113, 192,
  59, 128, 63, 128, 31, 0, 14, 0, 31, 0, 31, 0, 59, 128, 123, 192,
  113, 192, 241, 224, 224, 224, 13, 19, 38, 15, 1, 251, 224, 56, 224, 56,
  112, 56, 120, 112, 56, 112, 60, 240, 28, 224, 28, 224, 15, 192, 15, 192,
  7, 192, 7, 128, 3, 128, 3, 128, 7, 0, 7, 0, 14, 0, 62, 0,
  60, 0, 11, 14, 28, 13, 1, 0, 255, 224, 255, 224, 1, 192, 3, 128,
  7, 128, 15, 0, 14, 0, 30, 0, 60, 0, 56, 0, 112, 0, 240, 0,
  255, 224, 255, 224, 7, 24, 24, 10, 1, 251, 14, 28, 56, 56, 56, 56,
  56, 56, 56, 56, 112, 224, 224, 112, 56, 56, 56, 56, 56, 56, 56, 56,
  28, 14, 2, 24, 24, 7, 3, 251, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  7, 24, 24, 10, 2, 251, 224, 112, 56, 56, 56, 56, 56, 56, 56, 56,
  28, 14, 14, 28, 56, 56, 56, 56, 56, 56, 56, 56, 112, 224, 11, 4,
  8, 14, 1, 5, 120, 224, 254, 224, 239, 224, 227, 192, 255
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--34-240-100-100-P-182-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 25, '1' Height: 23
  Calculated Max Values w=31 h=32 x= 4 y=21 dx=33 dy= 0 ascent=31 len=120
  Font Bounding box     w=40 h=49 x=-6 y=-12
  Calculated Min Values           x=-1 y=-7 dx= 0 dy= 0
  Pure Font   ascent =25 descent=-7
  X Font      ascent =25 descent=-7
  Max Font    ascent =31 descent=-7
*/
const u8g_fntpgm_uint8_t u8g_font_helvB24[11554] U8G_FONT_SECTION("u8g_font_helvB24") = {
  0, 40, 49, 250, 244, 25, 5, 252, 14, 144, 32, 255, 249, 31, 249, 25,
  249, 0, 0, 0, 9, 0, 1, 5, 25, 25, 11, 3, 0, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 112, 112, 112, 112, 112, 112, 112, 0,
  0, 248, 248, 248, 248, 248, 11, 9, 18, 16, 2, 16, 241, 224, 241, 224,
  241, 224, 241, 224, 241, 224, 241, 224, 241, 224, 96, 192, 96, 192, 18, 25,
  75, 19, 0, 255, 3, 199, 0, 3, 199, 0, 3, 143, 0, 3, 143, 0,
  7, 143, 0, 7, 142, 0, 7, 142, 0, 127, 255, 192, 127, 255, 192, 127,
  255, 192, 127, 255, 192, 15, 28, 0, 14, 28, 0, 14, 28, 0, 14, 60,
  0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 255, 255, 128, 28, 120, 0,
  60, 120, 0, 60, 112, 0, 60, 112, 0, 56, 240, 0, 56, 240, 0, 16,
  28, 56, 18, 1, 253, 1, 128, 1, 128, 15, 240, 63, 252, 127, 254, 253,
  190, 249, 159, 241, 159, 241, 143, 249, 128, 255, 128, 127, 192, 63, 240, 15,
  252, 1, 254, 1, 255, 1, 159, 1, 143, 241, 143, 241, 159, 249, 159, 127,
  254, 127, 254, 63, 248, 7, 224, 1, 128, 1, 128, 1, 128, 26, 23, 92,
  29, 1, 0, 14, 0, 48, 0, 63, 128, 112, 0, 127, 192, 96, 0, 113,
  192, 224, 0, 224, 224, 192, 0, 224, 225, 192, 0, 224, 227, 128, 0, 224,
  227, 128, 0, 113, 199, 0, 0, 127, 198, 0, 0, 63, 142, 0, 0, 14,
  12, 28, 0, 0, 28, 127, 0, 0, 24, 255, 128, 0, 56, 227, 128, 0,
  49, 193, 192, 0, 113, 193, 192, 0, 97, 193, 192, 0, 225, 193, 192, 1,
  192, 227, 128, 1, 192, 255, 128, 3, 128, 127, 0, 3, 0, 28, 0, 20,
  25, 75, 24, 2, 0, 3, 224, 0, 15, 248, 0, 31, 252, 0, 31, 252,
  0, 30, 60, 0, 62, 60, 0, 62, 60, 0, 31, 60, 0, 31, 248, 0,
  15, 248, 0, 15, 240, 0, 15, 224, 0, 63, 241, 224, 127, 241, 224, 124,
  249, 192, 248, 255, 192, 240, 127, 192, 240, 63, 128, 240, 31, 0, 248, 15,
  128, 252, 63, 192, 127, 255, 224, 127, 251, 224, 31, 241, 240, 7, 192, 0,
  4, 9, 9, 8, 2, 16, 240, 240, 240, 240, 240, 240, 240, 96, 96, 8,
  31, 31, 11, 1, 250, 7, 15, 30, 30, 60, 60, 56, 120, 120, 120, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 248, 120, 120, 120, 120, 60, 60, 28,
  30, 14, 15, 7, 8, 31, 31, 11, 1, 250, 224, 240, 120, 120, 60, 60,
  28, 30, 30, 30, 15, 15, 15, 15, 15, 15, 15, 15, 15, 31, 30, 30,
  30, 28, 60, 60, 56, 120, 112, 240, 224, 10, 11, 22, 13, 1, 13, 12,
  0, 12, 0, 76, 128, 237, 192, 255, 192, 127, 128, 30, 0, 63, 0, 127,
  128, 115, 128, 33, 0, 16, 16, 32, 19, 1, 0, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 255, 255, 255, 255, 255, 255, 255, 255, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 5, 11, 11, 9, 2,
  250, 248, 248, 248, 248, 248, 24, 24, 56, 112, 224, 128, 9, 5, 10, 11,
  1, 7, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 5, 5, 5, 9,
  2, 0, 248, 248, 248, 248, 248, 8, 25, 25, 9, 0, 0, 3, 3, 3,
  3, 6, 6, 6, 14, 12, 12, 12, 28, 24, 24, 24, 48, 48, 48, 112,
  96, 96, 96, 192, 192, 192, 15, 24, 48, 18, 1, 0, 15, 224, 31, 240,
  63, 248, 127, 252, 124, 124, 248, 62, 248, 62, 248, 62, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 248, 62, 248, 62,
  248, 62, 124, 124, 127, 252, 63, 248, 31, 240, 15, 224, 10, 23, 46, 18,
  2, 0, 1, 192, 3, 192, 7, 192, 31, 192, 255, 192, 255, 192, 255, 192,
  3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192,
  3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192,
  16, 24, 48, 18, 1, 0, 15, 224, 63, 248, 127, 252, 127, 254, 252, 126,
  248, 63, 248, 31, 240, 31, 240, 31, 0, 63, 0, 62, 0, 126, 0, 252,
  1, 248, 7, 240, 15, 224, 31, 128, 63, 0, 126, 0, 252, 0, 255, 255,
  255, 255, 255, 255, 255, 255, 16, 24, 48, 18, 1, 0, 15, 224, 63, 248,
  127, 252, 127, 252, 248, 62, 240, 62, 240, 30, 240, 30, 0, 62, 0, 124,
  3, 248, 3, 240, 3, 252, 0, 126, 0, 63, 0, 31, 240, 31, 240, 31,
  240, 63, 248, 62, 127, 254, 127, 252, 63, 248, 15, 224, 16, 24, 48, 18,
  1, 0, 0, 248, 0, 248, 1, 248, 3, 248, 3, 248, 7, 248, 15, 120,
  14, 120, 30, 120, 28, 120, 60, 120, 120, 120, 112, 120, 240, 120, 224, 120,
  255, 255, 255, 255, 255, 255, 255, 255, 0, 120, 0, 120, 0, 120, 0, 120,
  0, 120, 15, 24, 48, 18, 1, 0, 63, 252, 63, 252, 63, 252, 63, 252,
  56, 0, 120, 0, 120, 0, 120, 0, 123, 224, 127, 248, 127, 252, 127, 252,
  120, 126, 0, 62, 0, 62, 0, 30, 0, 30, 240, 62, 240, 62, 248, 124,
  127, 252, 127, 248, 63, 240, 15, 192, 15, 24, 48, 18, 1, 0, 7, 224,
  31, 248, 63, 252, 63, 254, 124, 62, 120, 30, 240, 0, 240, 0, 243, 224,
  247, 248, 255, 252, 255, 252, 252, 126, 248, 62, 240, 30, 240, 30, 240, 30,
  240, 30, 248, 62, 124, 124, 127, 252, 63, 248, 31, 240, 7, 192, 16, 24,
  48, 18, 1, 0, 255, 255, 255, 255, 255, 255, 255, 255, 0, 30, 0, 62,
  0, 60, 0, 120, 0, 248, 0, 240, 1, 240, 1, 224, 3, 224, 3, 192,
  7, 192, 7, 192, 7, 128, 15, 128, 15, 128, 15, 128, 31, 0, 31, 0,
  31, 0, 31, 0, 17, 24, 72, 18, 0, 0, 7, 240, 0, 31, 252, 0,
  63, 254, 0, 62, 62, 0, 124, 31, 0, 120, 15, 0, 120, 15, 0, 120,
  15, 0, 124, 31, 0, 62, 62, 0, 31, 252, 0, 31, 252, 0, 63, 254,
  0, 124, 31, 0, 248, 15, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128,
  248, 15, 128, 126, 63, 0, 127, 254, 0, 63, 254, 0, 31, 252, 0, 7,
  240, 0, 15, 24, 48, 18, 1, 0, 7, 192, 31, 240, 63, 248, 127, 252,
  124, 124, 248, 62, 240, 30, 240, 30, 240, 30, 240, 30, 248, 62, 252, 126,
  127, 254, 127, 254, 63, 222, 7, 158, 0, 30, 0, 30, 240, 60, 248, 124,
  127, 248, 127, 248, 31, 240, 7, 192, 5, 17, 17, 11, 3, 0, 248, 248,
  248, 248, 248, 0, 0, 0, 0, 0, 0, 0, 248, 248, 248, 248, 248, 5,
  23, 23, 11, 3, 250, 248, 248, 248, 248, 248, 0, 0, 0, 0, 0, 0,
  0, 248, 248, 248, 248, 248, 24, 24, 56, 112, 224, 128, 16, 16, 32, 19,
  1, 0, 0, 3, 0, 31, 0, 127, 3, 255, 15, 254, 127, 248, 255, 192,
  254, 0, 254, 0, 255, 192, 127, 240, 15, 254, 3, 255, 0, 127, 0, 31,
  0, 3, 15, 12, 24, 19, 2, 2, 255, 254, 255, 254, 255, 254, 255, 254,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 254, 255, 254, 255, 254, 255, 254,
  16, 16, 32, 19, 1, 0, 192, 0, 240, 0, 254, 0, 255, 192, 127, 240,
  31, 254, 3, 255, 0, 127, 0, 127, 3, 255, 31, 254, 127, 240, 255, 192,
  254, 0, 240, 0, 192, 0, 16, 25, 50, 20, 2, 0, 15, 224, 63, 248,
  127, 252, 127, 254, 252, 126, 248, 63, 248, 31, 240, 31, 240, 31, 0, 63,
  0, 126, 0, 254, 1, 252, 1, 248, 3, 224, 3, 192, 7, 192, 7, 192,
  0, 0, 0, 0, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 29, 30,
  120, 33, 1, 251, 0, 15, 224, 0, 0, 127, 252, 0, 1, 255, 254, 0,
  3, 240, 63, 128, 7, 192, 7, 192, 15, 0, 3, 192, 30, 0, 1, 224,
  28, 0, 0, 240, 60, 7, 220, 112, 56, 31, 252, 112, 112, 60, 252, 56,
  112, 120, 120, 56, 240, 240, 56, 56, 224, 224, 56, 56, 225, 224, 56, 56,
  225, 192, 112, 120, 225, 192, 112, 112, 225, 192, 112, 112, 225, 224, 240, 224,
  241, 225, 241, 224, 112, 255, 255, 192, 120, 127, 63, 128, 56, 62, 30, 0,
  60, 0, 0, 0, 30, 0, 0, 0, 15, 128, 0, 0, 15, 240, 60, 0,
  3, 255, 252, 0, 1, 255, 252, 0, 0, 127, 224, 0, 22, 25, 75, 23,
  0, 0, 0, 252, 0, 0, 252, 0, 1, 254, 0, 1, 254, 0, 1, 254,
  0, 3, 255, 0, 3, 255, 0, 3, 255, 0, 7, 207, 128, 7, 207, 128,
  7, 207, 128, 15, 135, 128, 15, 135, 192, 15, 135, 192, 31, 3, 192, 31,
  3, 224, 31, 255, 224, 31, 255, 224, 63, 255, 240, 63, 255, 240, 62, 1,
  240, 124, 0, 248, 124, 0, 248, 252, 0, 252, 248, 0, 124, 19, 25, 75,
  24, 3, 0, 255, 252, 0, 255, 255, 0, 255, 255, 128, 255, 255, 128, 248,
  15, 192, 248, 7, 192, 248, 7, 192, 248, 7, 192, 248, 7, 192, 248, 15,
  128, 255, 255, 0, 255, 255, 0, 255, 255, 128, 255, 255, 192, 248, 7, 192,
  248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248,
  7, 224, 255, 255, 192, 255, 255, 192, 255, 255, 128, 255, 254, 0, 21, 25,
  75, 24, 1, 0, 1, 254, 0, 7, 255, 128, 15, 255, 192, 31, 255, 224,
  63, 135, 240, 62, 1, 240, 124, 1, 248, 124, 0, 248, 124, 0, 248, 248,
  0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0,
  0, 248, 0, 0, 124, 0, 248, 124, 0, 248, 126, 1, 248, 62, 1, 240,
  63, 135, 240, 31, 255, 224, 15, 255, 192, 7, 255, 128, 1, 254, 0, 21,
  25, 75, 24, 2, 0, 255, 248, 0, 255, 255, 0, 255, 255, 128, 255, 255,
  192, 248, 15, 224, 248, 3, 224, 248, 3, 240, 248, 1, 240, 248, 1, 248,
  248, 0, 248, 248, 0, 248, 248, 0, 248, 248, 0, 248, 248, 0, 248, 248,
  0, 248, 248, 0, 248, 248, 1, 248, 248, 1, 240, 248, 3, 240, 248, 3,
  224, 248, 15, 224, 255, 255, 192, 255, 255, 128, 255, 255, 0, 255, 248, 0,
  18, 25, 75, 22, 2, 0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 255,
  255, 128, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0,
  0, 248, 0, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0,
  248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248,
  0, 0, 248, 0, 0, 255, 255, 192, 255, 255, 192, 255, 255, 192, 255, 255,
  192, 16, 25, 50, 20, 2, 0, 255, 255, 255, 255, 255, 255, 255, 255, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 255, 254, 255, 254, 255,
  254, 255, 254, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 22, 25, 75, 25, 1, 0, 0,
  255, 0, 3, 255, 192, 15, 255, 224, 31, 255, 240, 31, 195, 248, 63, 0,
  248, 126, 0, 124, 124, 0, 124, 252, 0, 0, 248, 0, 0, 248, 0, 0,
  248, 0, 0, 248, 15, 252, 248, 15, 252, 248, 15, 252, 248, 15, 252, 252,
  0, 124, 124, 0, 124, 126, 0, 124, 126, 0, 252, 63, 131, 252, 63, 255,
  252, 31, 255, 220, 7, 255, 156, 3, 254, 28, 19, 25, 75, 23, 2, 0,
  248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248,
  3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 255, 255,
  224, 255, 255, 224, 255, 255, 224, 255, 255, 224, 248, 3, 224, 248, 3, 224,
  248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248,
  3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 5, 25, 25, 9, 2,
  0, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 15, 25, 50, 18, 1, 0,
  0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62,
  0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 248, 62,
  248, 62, 248, 62, 248, 62, 248, 62, 252, 126, 255, 252, 127, 252, 63, 248,
  15, 224, 20, 25, 75, 24, 2, 0, 248, 7, 224, 248, 7, 224, 248, 15,
  192, 248, 31, 128, 248, 63, 0, 248, 126, 0, 248, 252, 0, 248, 248, 0,
  249, 248, 0, 251, 240, 0, 255, 224, 0, 255, 224, 0, 255, 240, 0, 255,
  240, 0, 255, 248, 0, 252, 252, 0, 248, 126, 0, 248, 126, 0, 248, 63,
  0, 248, 31, 128, 248, 15, 128, 248, 15, 192, 248, 7, 224, 248, 3, 240,
  248, 3, 240, 16, 25, 50, 20, 2, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 255, 255, 255, 255, 255, 255, 255, 255, 23, 25, 75, 27, 2,
  0, 254, 0, 254, 254, 0, 254, 255, 1, 254, 255, 1, 254, 255, 1, 254,
  255, 1, 254, 255, 131, 254, 255, 131, 254, 251, 131, 190, 251, 131, 190, 251,
  199, 190, 251, 199, 190, 251, 199, 190, 249, 199, 62, 249, 239, 62, 249, 239,
  62, 249, 239, 62, 249, 239, 62, 248, 238, 62, 248, 254, 62, 248, 254, 62,
  248, 254, 62, 248, 124, 62, 248, 124, 62, 248, 124, 62, 19, 25, 75, 24,
  2, 0, 248, 3, 224, 252, 3, 224, 252, 3, 224, 254, 3, 224, 254, 3,
  224, 255, 3, 224, 255, 3, 224, 255, 131, 224, 255, 195, 224, 251, 195, 224,
  251, 227, 224, 249, 227, 224, 249, 243, 224, 248, 243, 224, 248, 251, 224, 248,
  123, 224, 248, 63, 224, 248, 63, 224, 248, 31, 224, 248, 31, 224, 248, 15,
  224, 248, 15, 224, 248, 7, 224, 248, 7, 224, 248, 3, 224, 23, 25, 75,
  25, 1, 0, 1, 255, 0, 7, 255, 192, 15, 255, 224, 31, 255, 240, 63,
  199, 248, 63, 1, 248, 126, 0, 252, 124, 0, 124, 124, 0, 124, 248, 0,
  62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62,
  248, 0, 62, 124, 0, 124, 124, 0, 124, 126, 0, 252, 63, 1, 248, 63,
  199, 248, 31, 255, 240, 15, 255, 224, 7, 255, 192, 1, 255, 0, 18, 25,
  75, 22, 2, 0, 255, 248, 0, 255, 254, 0, 255, 255, 0, 255, 255, 128,
  248, 31, 128, 248, 15, 192, 248, 7, 192, 248, 7, 192, 248, 7, 192, 248,
  7, 192, 248, 15, 192, 248, 31, 128, 255, 255, 128, 255, 255, 0, 255, 252,
  0, 255, 240, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0,
  248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 23,
  26, 78, 26, 1, 255, 1, 255, 0, 7, 255, 192, 15, 255, 224, 31, 255,
  240, 63, 199, 248, 63, 1, 248, 126, 0, 252, 124, 0, 124, 252, 0, 126,
  248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248,
  0, 62, 248, 2, 62, 252, 7, 62, 124, 15, 188, 126, 15, 252, 63, 7,
  248, 63, 195, 240, 31, 255, 248, 15, 255, 252, 7, 255, 254, 1, 255, 60,
  0, 0, 24, 19, 25, 75, 24, 2, 0, 255, 254, 0, 255, 255, 128, 255,
  255, 192, 255, 255, 192, 248, 7, 224, 248, 3, 224, 248, 3, 224, 248, 3,
  224, 248, 3, 224, 248, 7, 192, 248, 15, 192, 255, 255, 128, 255, 255, 0,
  255, 255, 0, 255, 255, 128, 248, 15, 192, 248, 7, 192, 248, 7, 192, 248,
  7, 192, 248, 7, 192, 248, 7, 192, 248, 7, 192, 248, 7, 192, 248, 7,
  224, 248, 3, 224, 19, 25, 75, 22, 1, 0, 3, 248, 0, 15, 254, 0,
  31, 255, 0, 63, 255, 128, 62, 31, 128, 124, 7, 192, 120, 7, 192, 120,
  3, 192, 124, 0, 0, 127, 0, 0, 63, 240, 0, 63, 254, 0, 31, 255,
  128, 3, 255, 192, 0, 63, 192, 0, 7, 224, 0, 3, 224, 248, 3, 224,
  248, 3, 224, 124, 3, 224, 126, 15, 192, 63, 255, 192, 31, 255, 128, 15,
  255, 0, 3, 248, 0, 19, 25, 75, 20, 0, 0, 255, 255, 224, 255, 255,
  224, 255, 255, 224, 255, 255, 224, 1, 240, 0, 1, 240, 0, 1, 240, 0,
  1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1,
  240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240,
  0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0,
  1, 240, 0, 1, 240, 0, 19, 25, 75, 24, 2, 0, 248, 3, 224, 248,
  3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3,
  224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224,
  248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248,
  3, 224, 248, 3, 224, 252, 7, 224, 127, 31, 192, 127, 255, 192, 63, 255,
  128, 31, 255, 0, 7, 252, 0, 20, 25, 75, 22, 1, 0, 248, 1, 240,
  248, 1, 240, 124, 3, 224, 124, 3, 224, 124, 3, 224, 60, 3, 192, 62,
  7, 192, 62, 7, 192, 30, 7, 128, 31, 15, 128, 31, 15, 128, 15, 15,
  0, 15, 15, 0, 15, 15, 0, 7, 158, 0, 7, 158, 0, 7, 158, 0,
  7, 254, 0, 3, 252, 0, 3, 252, 0, 3, 252, 0, 1, 248, 0, 1,
  248, 0, 1, 248, 0, 0, 240, 0, 29, 25, 100, 31, 1, 0, 248, 31,
  129, 248, 248, 31, 129, 248, 120, 31, 129, 240, 120, 31, 129, 240, 120, 31,
  129, 240, 124, 63, 195, 224, 124, 63, 195, 224, 124, 63, 195, 224, 60, 63,
  195, 224, 60, 57, 195, 192, 62, 121, 227, 192, 62, 121, 231, 192, 30, 121,
  231, 192, 30, 121, 231, 128, 30, 112, 231, 128, 30, 112, 231, 128, 15, 240,
  255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 224, 127, 0, 7, 224,
  126, 0, 7, 224, 126, 0, 7, 224, 126, 0, 3, 192, 60, 0, 3, 192,
  60, 0, 20, 25, 75, 22, 1, 0, 252, 3, 224, 126, 7, 224, 126, 7,
  192, 63, 15, 192, 31, 15, 128, 31, 159, 0, 15, 159, 0, 15, 190, 0,
  7, 254, 0, 7, 252, 0, 3, 252, 0, 3, 248, 0, 1, 248, 0, 3,
  248, 0, 3, 252, 0, 7, 252, 0, 7, 254, 0, 15, 191, 0, 31, 159,
  0, 31, 31, 128, 63, 15, 128, 62, 15, 192, 126, 7, 192, 252, 7, 224,
  252, 3, 240, 20, 25, 75, 22, 1, 0, 252, 3, 240, 252, 3, 224, 126,
  7, 224, 62, 7, 192, 63, 15, 192, 63, 15, 128, 31, 15, 128, 31, 159,
  0, 15, 159, 0, 15, 254, 0, 7, 254, 0, 7, 252, 0, 3, 252, 0,
  3, 248, 0, 3, 248, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1,
  240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240,
  0, 1, 240, 0, 17, 25, 75, 20, 1, 0, 255, 255, 128, 255, 255, 128,
  255, 255, 128, 255, 255, 128, 0, 15, 128, 0, 31, 128, 0, 63, 0, 0,
  126, 0, 0, 124, 0, 0, 252, 0, 1, 248, 0, 3, 240, 0, 3, 240,
  0, 7, 224, 0, 15, 192, 0, 15, 128, 0, 31, 128, 0, 63, 0, 0,
  126, 0, 0, 126, 0, 0, 252, 0, 0, 255, 255, 128, 255, 255, 128, 255,
  255, 128, 255, 255, 128, 8, 31, 31, 11, 2, 250, 255, 255, 255, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 255, 255, 255, 9, 25, 50, 9, 0, 0,
  192, 0, 192, 0, 224, 0, 96, 0, 96, 0, 112, 0, 112, 0, 48, 0,
  56, 0, 56, 0, 24, 0, 28, 0, 28, 0, 12, 0, 12, 0, 14, 0,
  14, 0, 6, 0, 7, 0, 7, 0, 3, 0, 3, 128, 3, 128, 1, 128,
  1, 128, 8, 31, 31, 11, 0, 250, 255, 255, 255, 15, 15, 15, 15, 15,
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
  15, 15, 15, 15, 255, 255, 255, 14, 14, 28, 19, 2, 9, 7, 128, 15,
  192, 15, 192, 15, 192, 31, 224, 31, 224, 60, 240, 60, 240, 56, 112, 120,
  120, 120, 120, 112, 60, 240, 60, 240, 60, 18, 2, 6, 18, 0, 250, 255,
  255, 192, 255, 255, 192, 5, 5, 5, 11, 2, 20, 224, 240, 112, 120, 56,
  15, 18, 36, 18, 1, 0, 15, 240, 63, 252, 127, 252, 124, 62, 248, 30,
  248, 30, 0, 254, 15, 254, 63, 254, 127, 30, 248, 30, 248, 30, 240, 62,
  248, 126, 255, 254, 255, 254, 127, 222, 63, 30, 16, 25, 50, 20, 2, 0,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 243, 240,
  247, 252, 255, 252, 255, 254, 252, 62, 248, 31, 240, 31, 240, 15, 240, 15,
  240, 15, 240, 15, 240, 31, 240, 31, 248, 62, 255, 254, 255, 252, 247, 248,
  241, 240, 15, 18, 36, 18, 1, 0, 7, 224, 31, 248, 63, 252, 63, 252,
  124, 62, 120, 62, 240, 30, 240, 0, 240, 0, 240, 0, 240, 0, 240, 30,
  248, 30, 124, 62, 127, 252, 63, 248, 31, 248, 7, 224, 16, 25, 50, 20,
  1, 0, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  15, 207, 31, 239, 63, 255, 127, 255, 124, 63, 248, 31, 240, 15, 240, 15,
  240, 15, 240, 15, 240, 15, 240, 15, 248, 31, 124, 63, 127, 255, 63, 239,
  31, 239, 15, 143, 16, 18, 36, 18, 1, 0, 7, 224, 31, 248, 63, 252,
  127, 254, 124, 62, 248, 31, 240, 31, 255, 255, 255, 255, 255, 255, 240, 0,
  240, 0, 248, 30, 124, 62, 127, 252, 63, 252, 31, 240, 7, 192, 10, 25,
  50, 11, 0, 0, 7, 192, 15, 192, 31, 192, 31, 0, 30, 0, 30, 0,
  30, 0, 255, 192, 255, 192, 255, 192, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 16, 25, 50, 20, 1, 249, 15, 207, 31, 239,
  63, 255, 127, 255, 124, 63, 248, 31, 248, 31, 240, 15, 240, 15, 240, 15,
  240, 15, 248, 31, 248, 31, 124, 63, 127, 255, 63, 255, 31, 239, 15, 207,
  0, 15, 248, 31, 248, 31, 126, 126, 127, 254, 63, 252, 15, 240, 15, 25,
  50, 20, 2, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0,
  240, 0, 241, 224, 247, 248, 255, 252, 255, 252, 252, 62, 248, 30, 248, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 4, 25, 25, 9, 2, 0, 240, 240, 240, 240,
  0, 0, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 6, 32, 32, 9, 0, 249, 60, 60, 60, 60, 0,
  0, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
  60, 60, 60, 60, 60, 60, 60, 252, 252, 248, 248, 15, 25, 50, 19, 2,
  0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  62, 240, 124, 240, 248, 241, 240, 243, 224, 247, 192, 255, 128, 255, 192, 255,
  192, 255, 224, 255, 224, 249, 240, 241, 240, 240, 248, 240, 120, 240, 124, 240,
  62, 240, 62, 4, 25, 25, 9, 2, 0, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 24, 18, 54, 30, 2, 0, 241, 224, 248, 247, 251, 254, 255, 255,
  254, 255, 255, 255, 252, 127, 31, 248, 62, 15, 240, 60, 15, 240, 60, 15,
  240, 60, 15, 240, 60, 15, 240, 60, 15, 240, 60, 15, 240, 60, 15, 240,
  60, 15, 240, 60, 15, 240, 60, 15, 240, 60, 15, 240, 60, 15, 15, 18,
  36, 20, 2, 0, 241, 240, 247, 252, 255, 252, 255, 254, 252, 62, 248, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 17, 18, 54, 20, 1, 0, 7, 240,
  0, 31, 252, 0, 63, 254, 0, 127, 255, 0, 124, 31, 0, 248, 15, 128,
  248, 15, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 248,
  15, 128, 248, 15, 128, 124, 31, 0, 127, 255, 0, 63, 254, 0, 31, 252,
  0, 7, 240, 0, 16, 25, 50, 20, 2, 249, 241, 240, 247, 248, 255, 252,
  255, 254, 252, 62, 248, 31, 248, 31, 240, 15, 240, 15, 240, 15, 240, 15,
  248, 31, 248, 31, 252, 62, 255, 254, 255, 252, 247, 248, 241, 240, 240, 0,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 16, 25, 50, 20,
  1, 249, 7, 207, 31, 239, 63, 255, 127, 255, 124, 63, 248, 31, 240, 15,
  240, 15, 240, 15, 240, 15, 240, 15, 240, 15, 248, 31, 124, 63, 127, 255,
  63, 255, 63, 239, 15, 207, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 10, 18, 36, 13, 2, 0, 240, 192, 243, 192, 247, 192,
  255, 192, 255, 192, 252, 0, 248, 0, 248, 0, 240, 0, 240, 0, 240, 0,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 16, 18,
  36, 19, 1, 0, 7, 240, 31, 252, 63, 254, 124, 62, 120, 31, 120, 31,
  124, 0, 127, 192, 63, 248, 15, 254, 3, 255, 0, 63, 248, 15, 248, 15,
  124, 31, 127, 254, 63, 252, 15, 240, 9, 22, 44, 11, 1, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 255, 128, 255, 128, 255, 128, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 63, 128, 63, 128, 31, 128, 15, 128, 15, 18, 36, 20, 2, 0,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 248, 62, 248, 126, 255, 254, 127, 254,
  127, 222, 31, 30, 17, 18, 54, 19, 0, 0, 248, 15, 128, 248, 15, 128,
  124, 31, 0, 124, 31, 0, 60, 30, 0, 60, 30, 0, 62, 62, 0, 30,
  60, 0, 30, 60, 0, 30, 60, 0, 15, 120, 0, 15, 120, 0, 15, 120,
  0, 7, 240, 0, 7, 240, 0, 7, 240, 0, 3, 224, 0, 3, 224, 0,
  25, 18, 72, 26, 0, 0, 248, 62, 15, 128, 248, 62, 15, 128, 120, 62,
  15, 0, 124, 62, 31, 0, 124, 127, 31, 0, 60, 127, 30, 0, 60, 127,
  30, 0, 60, 119, 30, 0, 60, 247, 158, 0, 30, 227, 188, 0, 30, 227,
  188, 0, 30, 227, 188, 0, 31, 227, 252, 0, 15, 193, 248, 0, 15, 193,
  248, 0, 15, 193, 248, 0, 7, 128, 240, 0, 7, 128, 240, 0, 16, 18,
  36, 19, 1, 0, 248, 31, 252, 63, 124, 62, 62, 124, 62, 120, 31, 248,
  15, 240, 7, 224, 3, 192, 7, 224, 15, 224, 15, 240, 31, 248, 62, 120,
  62, 124, 124, 62, 252, 63, 248, 31, 16, 25, 50, 19, 1, 249, 248, 31,
  248, 31, 248, 30, 120, 62, 124, 62, 124, 60, 60, 60, 62, 124, 62, 120,
  30, 120, 30, 120, 31, 240, 15, 240, 15, 240, 15, 224, 7, 224, 7, 224,
  7, 192, 7, 192, 7, 192, 15, 128, 63, 128, 63, 0, 63, 0, 60, 0,
  14, 18, 36, 17, 1, 0, 255, 252, 255, 252, 255, 252, 255, 252, 0, 248,
  1, 240, 3, 240, 7, 224, 15, 192, 31, 128, 31, 0, 62, 0, 124, 0,
  248, 0, 255, 252, 255, 252, 255, 252, 255, 252, 9, 32, 64, 13, 2, 249,
  15, 128, 31, 128, 63, 128, 62, 0, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 124, 0, 120, 0,
  224, 0, 120, 0, 124, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 63, 128, 31, 128, 15, 128,
  3, 31, 31, 9, 3, 250, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 9, 32, 64, 13, 2, 249, 248, 0, 252, 0, 254,
  0, 62, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 31, 0, 15, 0, 3, 128, 15, 0, 31,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 254, 0, 252, 0, 248, 0, 14, 6, 12, 19, 2,
  5, 56, 0, 126, 12, 255, 156, 231, 252, 193, 248, 0, 112, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
  0, 9, 0, 1, 5, 24, 24, 11, 2, 250, 248, 248, 248, 248, 248, 0,
  0, 112, 112, 112, 112, 112, 112, 248, 248, 248, 248, 248, 248, 248, 248, 248,
  248, 248, 15, 24, 48, 18, 1, 253, 0, 32, 0, 32, 0, 96, 7, 240,
  31, 248, 63, 252, 127, 252, 124, 190, 248, 158, 249, 158, 241, 128, 241, 128,
  243, 0, 243, 0, 243, 30, 250, 30, 126, 62, 127, 252, 63, 248, 31, 240,
  15, 192, 12, 0, 8, 0, 8, 0, 17, 24, 72, 18, 0, 0, 3, 240,
  0, 31, 252, 0, 63, 254, 0, 63, 255, 0, 126, 31, 0, 124, 15, 128,
  124, 15, 128, 124, 7, 128, 124, 0, 0, 126, 0, 0, 62, 0, 0, 255,
  240, 0, 255, 240, 0, 31, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0,
  0, 31, 0, 0, 30, 0, 0, 61, 227, 0, 127, 255, 128, 255, 255, 128,
  255, 255, 0, 96, 126, 0, 15, 15, 30, 18, 1, 4, 224, 14, 247, 222,
  255, 254, 127, 252, 60, 120, 120, 60, 112, 28, 112, 28, 112, 28, 120, 60,
  60, 120, 127, 252, 255, 254, 247, 222, 224, 14, 18, 24, 72, 18, 0, 0,
  248, 7, 192, 248, 7, 192, 124, 15, 128, 60, 15, 0, 30, 30, 0, 30,
  30, 0, 15, 60, 0, 15, 60, 0, 7, 248, 0, 7, 248, 0, 3, 240,
  0, 1, 224, 0, 63, 255, 0, 63, 255, 0, 1, 224, 0, 1, 224, 0,
  63, 255, 0, 63, 255, 0, 1, 224, 0, 1, 224, 0, 1, 224, 0, 1,
  224, 0, 1, 224, 0, 1, 224, 0, 3, 31, 31, 9, 3, 250, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 0, 0, 0, 0, 0,
  0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 16, 32, 64,
  18, 1, 249, 15, 240, 31, 248, 63, 248, 126, 124, 124, 60, 124, 60, 126,
  0, 127, 0, 63, 192, 31, 224, 63, 248, 127, 252, 113, 254, 240, 255, 240,
  63, 248, 31, 252, 15, 127, 15, 127, 159, 63, 254, 31, 248, 7, 252, 1,
  254, 0, 126, 0, 62, 120, 30, 120, 30, 124, 62, 63, 252, 63, 252, 31,
  248, 7, 224, 10, 4, 8, 11, 0, 21, 243, 192, 243, 192, 243, 192, 243,
  192, 26, 25, 100, 24, 0, 0, 0, 127, 128, 0, 3, 255, 224, 0, 7,
  128, 248, 0, 31, 0, 60, 0, 28, 0, 14, 0, 56, 0, 7, 0, 112,
  63, 3, 0, 112, 127, 131, 128, 224, 243, 193, 128, 225, 192, 225, 192, 193,
  192, 224, 192, 195, 128, 0, 192, 195, 128, 0, 192, 195, 128, 0, 192, 195,
  128, 0, 192, 193, 192, 224, 192, 225, 192, 225, 192, 224, 243, 195, 128, 96,
  127, 131, 128, 112, 63, 7, 0, 56, 0, 14, 0, 30, 0, 60, 0, 15,
  128, 248, 0, 7, 255, 224, 0, 1, 255, 128, 0, 9, 16, 32, 12, 1,
  9, 62, 0, 127, 0, 227, 128, 195, 128, 31, 128, 127, 128, 243, 128, 227,
  128, 227, 128, 255, 128, 123, 128, 0, 0, 0, 0, 255, 128, 255, 128, 255,
  128, 12, 13, 26, 18, 3, 2, 8, 16, 24, 48, 56, 112, 120, 240, 241,
  224, 225, 192, 225, 192, 241, 224, 249, 240, 120, 240, 56, 112, 24, 48, 8,
  16, 16, 10, 20, 19, 1, 4, 255, 255, 255, 255, 255, 255, 255, 255, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 9, 5, 10, 11, 1,
  7, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 26, 25, 100, 24, 0,
  0, 0, 255, 128, 0, 3, 255, 224, 0, 7, 128, 248, 0, 30, 0, 60,
  0, 28, 0, 14, 0, 56, 255, 135, 0, 112, 255, 195, 0, 112, 225, 227,
  128, 224, 224, 225, 128, 224, 224, 225, 128, 192, 224, 225, 192, 192, 225, 193,
  192, 192, 255, 129, 192, 192, 255, 1, 192, 192, 227, 129, 192, 192, 227, 193,
  192, 224, 225, 193, 128, 224, 224, 227, 128, 112, 224, 243, 128, 112, 224, 119,
  0, 56, 0, 14, 0, 30, 0, 28, 0, 15, 128, 120, 0, 7, 255, 224,
  0, 1, 255, 128, 0, 10, 3, 6, 11, 0, 21, 255, 192, 255, 192, 255,
  192, 9, 10, 20, 13, 2, 14, 62, 0, 127, 0, 99, 0, 193, 128, 193,
  128, 193, 128, 193, 128, 99, 0, 127, 0, 62, 0, 16, 22, 44, 19, 1,
  0, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 255, 255, 255,
  255, 255, 255, 255, 255, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 10, 15, 30,
  11, 0, 9, 63, 0, 127, 128, 243, 192, 225, 192, 225, 192, 1, 192, 3,
  192, 7, 128, 15, 0, 62, 0, 120, 0, 112, 0, 255, 192, 255, 192, 255,
  192, 10, 15, 30, 11, 0, 9, 30, 0, 127, 128, 243, 192, 225, 192, 225,
  192, 3, 192, 15, 128, 15, 128, 3, 192, 1, 192, 225, 192, 225, 192, 243,
  192, 127, 128, 62, 0, 6, 5, 5, 11, 4, 20, 60, 120, 112, 224, 224,
  15, 25, 50, 20, 2, 249, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 248, 62,
  248, 126, 255, 254, 255, 254, 255, 222, 247, 158, 240, 0, 240, 0, 240, 0,
  240, 0, 240, 0, 240, 0, 240, 0, 17, 31, 93, 18, 0, 250, 15, 255,
  128, 31, 255, 128, 63, 140, 0, 127, 140, 0, 127, 140, 0, 255, 140, 0,
  255, 140, 0, 255, 140, 0, 255, 140, 0, 255, 140, 0, 127, 140, 0, 127,
  140, 0, 63, 140, 0, 63, 140, 0, 15, 140, 0, 1, 140, 0, 1, 140,
  0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0,
  1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1,
  140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 4, 5, 5, 9, 2,
  11, 96, 240, 240, 240, 96, 7, 8, 8, 11, 2, 249, 48, 48, 48, 124,
  30, 14, 252, 248, 6, 15, 15, 11, 2, 9, 28, 60, 252, 252, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 10, 16, 32, 12, 1, 9, 63,
  0, 127, 128, 115, 128, 225, 192, 225, 192, 225, 192, 225, 192, 225, 192, 115,
  128, 127, 128, 63, 0, 0, 0, 0, 0, 255, 192, 255, 192, 255, 192, 12,
  12, 24, 18, 3, 3, 129, 0, 193, 128, 225, 192, 241, 224, 120, 240, 56,
  112, 56, 112, 120, 240, 241, 224, 225, 192, 193, 128, 129, 0, 26, 24, 96,
  28, 0, 0, 0, 0, 56, 0, 6, 0, 112, 0, 30, 0, 112, 0, 254,
  0, 224, 0, 254, 1, 192, 0, 14, 1, 192, 0, 14, 3, 128, 0, 14,
  3, 128, 0, 14, 7, 0, 0, 14, 7, 0, 0, 14, 14, 7, 0, 14,
  28, 15, 0, 14, 28, 31, 0, 14, 56, 31, 0, 0, 56, 55, 0, 0,
  112, 103, 0, 0, 112, 231, 0, 0, 224, 199, 0, 1, 193, 135, 0, 1,
  193, 255, 192, 3, 129, 255, 192, 3, 128, 7, 0, 7, 0, 7, 0, 7,
  0, 7, 0, 25, 24, 96, 28, 1, 0, 0, 0, 224, 0, 12, 1, 192,
  0, 28, 1, 192, 0, 252, 3, 128, 0, 252, 3, 128, 0, 28, 7, 0,
  0, 28, 14, 0, 0, 28, 14, 0, 0, 28, 28, 0, 0, 28, 28, 0,
  0, 28, 56, 126, 0, 28, 48, 255, 0, 28, 113, 231, 128, 28, 225, 195,
  128, 0, 225, 195, 128, 1, 192, 7, 128, 1, 192, 15, 0, 3, 128, 30,
  0, 7, 0, 60, 0, 7, 0, 120, 0, 14, 0, 240, 0, 14, 1, 255,
  128, 28, 1, 255, 128, 28, 1, 255, 128, 25, 24, 96, 27, 1, 0, 63,
  0, 28, 0, 127, 128, 56, 0, 243, 192, 56, 0, 225, 192, 112, 0, 225,
  192, 224, 0, 3, 192, 224, 0, 15, 129, 192, 0, 15, 129, 192, 0, 15,
  195, 128, 0, 1, 199, 0, 0, 225, 199, 14, 0, 225, 206, 30, 0, 243,
  206, 30, 0, 127, 156, 62, 0, 63, 28, 126, 0, 0, 56, 238, 0, 0,
  112, 206, 0, 0, 113, 142, 0, 0, 227, 142, 0, 0, 227, 255, 128, 1,
  195, 255, 128, 1, 192, 14, 0, 3, 128, 14, 0, 3, 128, 14, 0, 16,
  24, 48, 20, 1, 250, 3, 224, 3, 224, 3, 224, 3, 224, 0, 0, 0,
  0, 3, 192, 3, 192, 3, 192, 7, 192, 31, 128, 63, 128, 127, 0, 126,
  0, 252, 0, 248, 15, 248, 15, 248, 15, 252, 31, 126, 127, 127, 254, 63,
  254, 63, 252, 15, 240, 22, 31, 93, 23, 0, 0, 3, 192, 0, 1, 224,
  0, 0, 240, 0, 0, 120, 0, 0, 60, 0, 0, 0, 0, 0, 252, 0,
  0, 252, 0, 1, 254, 0, 1, 254, 0, 1, 254, 0, 3, 255, 0, 3,
  255, 0, 3, 255, 0, 7, 207, 128, 7, 207, 128, 7, 207, 128, 15, 135,
  128, 15, 135, 192, 15, 135, 192, 31, 3, 192, 31, 3, 224, 31, 255, 224,
  31, 255, 224, 63, 255, 240, 63, 255, 240, 62, 1, 240, 124, 0, 248, 124,
  0, 248, 252, 0, 252, 248, 0, 124, 22, 31, 93, 23, 0, 0, 0, 15,
  0, 0, 30, 0, 0, 60, 0, 0, 120, 0, 0, 240, 0, 0, 0, 0,
  0, 252, 0, 0, 252, 0, 1, 254, 0, 1, 254, 0, 1, 254, 0, 3,
  255, 0, 3, 255, 0, 3, 255, 0, 7, 207, 128, 7, 207, 128, 7, 207,
  128, 15, 135, 128, 15, 135, 192, 15, 135, 192, 31, 3, 192, 31, 3, 224,
  31, 255, 224, 31, 255, 224, 63, 255, 240, 63, 255, 240, 62, 1, 240, 124,
  0, 248, 124, 0, 248, 252, 0, 252, 248, 0, 124, 22, 31, 93, 23, 0,
  0, 0, 48, 0, 0, 120, 0, 0, 252, 0, 1, 206, 0, 3, 135, 0,
  0, 0, 0, 0, 252, 0, 0, 252, 0, 1, 254, 0, 1, 254, 0, 1,
  254, 0, 3, 255, 0, 3, 255, 0, 3, 255, 0, 7, 207, 128, 7, 207,
  128, 7, 207, 128, 15, 135, 128, 15, 135, 192, 15, 135, 192, 31, 3, 192,
  31, 3, 224, 31, 255, 224, 31, 255, 224, 63, 255, 240, 63, 255, 240, 62,
  1, 240, 124, 0, 248, 124, 0, 248, 252, 0, 252, 248, 0, 124, 22, 30,
  90, 23, 0, 0, 0, 241, 128, 1, 255, 128, 3, 255, 0, 3, 30, 0,
  0, 0, 0, 0, 252, 0, 0, 252, 0, 1, 254, 0, 1, 254, 0, 1,
  254, 0, 3, 255, 0, 3, 255, 0, 3, 255, 0, 7, 207, 128, 7, 207,
  128, 7, 207, 128, 15, 135, 128, 15, 135, 192, 15, 135, 192, 31, 3, 192,
  31, 3, 224, 31, 255, 224, 31, 255, 224, 63, 255, 240, 63, 255, 240, 62,
  1, 240, 124, 0, 248, 124, 0, 248, 252, 0, 252, 248, 0, 124, 22, 31,
  93, 23, 0, 0, 3, 207, 0, 3, 207, 0, 3, 207, 0, 3, 207, 0,
  0, 0, 0, 0, 0, 0, 0, 252, 0, 0, 252, 0, 1, 254, 0, 1,
  254, 0, 1, 254, 0, 3, 255, 0, 3, 255, 0, 3, 255, 0, 7, 207,
  128, 7, 207, 128, 7, 207, 128, 15, 135, 128, 15, 135, 192, 15, 135, 192,
  31, 3, 192, 31, 3, 224, 31, 255, 224, 31, 255, 224, 63, 255, 240, 63,
  255, 240, 62, 1, 240, 124, 0, 248, 124, 0, 248, 252, 0, 252, 248, 0,
  124, 22, 31, 93, 23, 0, 0, 0, 120, 0, 0, 204, 0, 0, 132, 0,
  0, 132, 0, 0, 204, 0, 0, 120, 0, 0, 0, 0, 0, 252, 0, 1,
  254, 0, 1, 254, 0, 1, 254, 0, 3, 255, 0, 3, 255, 0, 3, 255,
  0, 7, 207, 128, 7, 207, 128, 7, 207, 128, 15, 135, 128, 15, 135, 192,
  15, 135, 192, 31, 3, 192, 31, 3, 224, 31, 255, 224, 31, 255, 224, 63,
  255, 240, 63, 255, 240, 62, 1, 240, 124, 0, 248, 124, 0, 248, 252, 0,
  252, 248, 0, 124, 31, 25, 100, 32, 0, 0, 0, 255, 255, 252, 0, 255,
  255, 252, 0, 255, 255, 252, 1, 255, 255, 252, 1, 243, 192, 0, 1, 227,
  192, 0, 3, 227, 192, 0, 3, 227, 192, 0, 3, 195, 192, 0, 7, 195,
  192, 0, 7, 195, 192, 0, 7, 195, 255, 248, 15, 131, 255, 248, 15, 131,
  255, 248, 15, 131, 255, 248, 31, 3, 192, 0, 31, 255, 192, 0, 31, 255,
  192, 0, 63, 255, 192, 0, 63, 255, 192, 0, 62, 3, 192, 0, 124, 3,
  255, 254, 124, 3, 255, 254, 248, 3, 255, 254, 248, 3, 255, 254, 21, 32,
  96, 23, 1, 249, 1, 254, 0, 7, 255, 128, 15, 255, 192, 31, 255, 224,
  63, 135, 240, 62, 1, 240, 124, 1, 240, 124, 0, 248, 124, 0, 248, 248,
  0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0,
  0, 248, 0, 0, 124, 0, 248, 124, 0, 248, 126, 1, 248, 62, 1, 240,
  63, 135, 240, 31, 255, 224, 15, 255, 192, 7, 255, 128, 1, 252, 0, 0,
  96, 0, 0, 96, 0, 0, 248, 0, 0, 28, 0, 0, 28, 0, 1, 248,
  0, 1, 240, 0, 18, 31, 93, 22, 2, 0, 30, 0, 0, 15, 0, 0,
  7, 128, 0, 3, 192, 0, 1, 224, 0, 0, 0, 0, 255, 255, 128, 255,
  255, 128, 255, 255, 128, 255, 255, 128, 248, 0, 0, 248, 0, 0, 248, 0,
  0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 255, 255, 0, 255, 255, 0,
  255, 255, 0, 255, 255, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248,
  0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 255, 255, 192, 255, 255,
  192, 255, 255, 192, 255, 255, 192, 18, 31, 93, 22, 2, 0, 0, 120, 0,
  0, 240, 0, 1, 224, 0, 3, 192, 0, 7, 128, 0, 0, 0, 0, 255,
  255, 128, 255, 255, 128, 255, 255, 128, 255, 255, 128, 248, 0, 0, 248, 0,
  0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 255, 255, 0,
  255, 255, 0, 255, 255, 0, 255, 255, 0, 248, 0, 0, 248, 0, 0, 248,
  0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 255, 255,
  192, 255, 255, 192, 255, 255, 192, 255, 255, 192, 18, 31, 93, 22, 2, 0,
  0, 192, 0, 1, 224, 0, 3, 240, 0, 7, 56, 0, 14, 28, 0, 0,
  0, 0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 255, 255, 128, 248, 0,
  0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0,
  255, 255, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 248, 0, 0, 248,
  0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0,
  0, 255, 255, 192, 255, 255, 192, 255, 255, 192, 255, 255, 192, 18, 31, 93,
  22, 2, 0, 30, 60, 0, 30, 60, 0, 30, 60, 0, 30, 60, 0, 0,
  0, 0, 0, 0, 0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 255, 255,
  128, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0,
  248, 0, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 248,
  0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0,
  0, 248, 0, 0, 255, 255, 192, 255, 255, 192, 255, 255, 192, 255, 255, 192,
  8, 31, 31, 9, 0, 0, 240, 120, 60, 30, 15, 0, 62, 62, 62, 62,
  62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
  62, 62, 62, 62, 62, 8, 31, 31, 9, 2, 0, 15, 30, 60, 120, 240,
  0, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 10, 31, 62, 9, 0, 0,
  12, 0, 30, 0, 63, 0, 115, 128, 225, 192, 0, 0, 62, 0, 62, 0,
  62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0,
  62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0,
  62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 10, 31,
  62, 9, 0, 0, 243, 192, 243, 192, 243, 192, 243, 192, 0, 0, 0, 0,
  62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0,
  62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0,
  62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0,
  62, 0, 23, 25, 75, 23, 255, 0, 31, 255, 128, 31, 255, 224, 31, 255,
  240, 31, 255, 248, 31, 7, 248, 31, 0, 252, 31, 0, 252, 31, 0, 124,
  31, 0, 126, 31, 0, 62, 31, 0, 62, 255, 240, 62, 255, 240, 62, 255,
  240, 62, 31, 0, 62, 31, 0, 62, 31, 0, 124, 31, 0, 124, 31, 0,
  124, 31, 0, 248, 31, 3, 248, 31, 255, 240, 31, 255, 240, 31, 255, 192,
  31, 255, 128, 19, 30, 90, 24, 2, 0, 3, 198, 0, 7, 254, 0, 15,
  252, 0, 12, 120, 0, 0, 0, 0, 248, 3, 224, 252, 3, 224, 252, 3,
  224, 254, 3, 224, 254, 3, 224, 255, 3, 224, 255, 3, 224, 255, 131, 224,
  255, 195, 224, 251, 195, 224, 251, 227, 224, 249, 227, 224, 249, 243, 224, 248,
  243, 224, 248, 251, 224, 248, 123, 224, 248, 63, 224, 248, 63, 224, 248, 31,
  224, 248, 31, 224, 248, 15, 224, 248, 15, 224, 248, 7, 224, 248, 7, 224,
  248, 3, 224, 23, 31, 93, 25, 1, 0, 1, 224, 0, 0, 240, 0, 0,
  120, 0, 0, 60, 0, 0, 30, 0, 0, 0, 0, 1, 255, 0, 7, 255,
  192, 15, 255, 224, 31, 255, 240, 63, 199, 248, 63, 1, 248, 126, 0, 252,
  124, 0, 124, 124, 0, 124, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248,
  0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 124, 0, 124, 124, 0,
  124, 126, 0, 252, 63, 1, 248, 63, 199, 248, 31, 255, 240, 15, 255, 224,
  7, 255, 192, 1, 255, 0, 23, 31, 93, 25, 1, 0, 0, 7, 128, 0,
  15, 0, 0, 30, 0, 0, 60, 0, 0, 120, 0, 0, 0, 0, 1, 255,
  0, 7, 255, 192, 15, 255, 224, 31, 255, 240, 63, 199, 248, 63, 1, 248,
  126, 0, 252, 124, 0, 124, 124, 0, 124, 248, 0, 62, 248, 0, 62, 248,
  0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 124, 0,
  124, 124, 0, 124, 126, 0, 252, 63, 1, 248, 63, 199, 248, 31, 255, 240,
  15, 255, 224, 7, 255, 192, 1, 255, 0, 23, 31, 93, 25, 1, 0, 0,
  24, 0, 0, 60, 0, 0, 126, 0, 0, 231, 0, 1, 195, 128, 0, 0,
  0, 1, 255, 0, 7, 255, 192, 15, 255, 224, 31, 255, 240, 63, 199, 248,
  63, 1, 248, 126, 0, 252, 124, 0, 124, 124, 0, 124, 248, 0, 62, 248,
  0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0,
  62, 124, 0, 124, 124, 0, 124, 126, 0, 252, 63, 1, 248, 63, 199, 248,
  31, 255, 240, 15, 255, 224, 7, 255, 192, 1, 255, 0, 23, 30, 90, 25,
  1, 0, 0, 120, 192, 0, 255, 192, 1, 255, 128, 1, 143, 0, 0, 0,
  0, 1, 255, 0, 7, 255, 192, 15, 255, 224, 31, 255, 240, 63, 199, 248,
  63, 1, 248, 126, 0, 252, 124, 0, 124, 124, 0, 124, 248, 0, 62, 248,
  0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0,
  62, 124, 0, 124, 124, 0, 124, 126, 0, 252, 63, 1, 248, 63, 199, 248,
  31, 255, 240, 15, 255, 224, 7, 255, 192, 1, 255, 0, 23, 31, 93, 25,
  1, 0, 1, 231, 128, 1, 231, 128, 1, 231, 128, 1, 231, 128, 0, 0,
  0, 0, 0, 0, 1, 255, 0, 7, 255, 192, 15, 255, 224, 31, 255, 240,
  63, 199, 248, 63, 1, 248, 126, 0, 252, 124, 0, 124, 124, 0, 124, 248,
  0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0,
  62, 248, 0, 62, 124, 0, 124, 124, 0, 124, 126, 0, 252, 63, 1, 248,
  63, 199, 248, 31, 255, 240, 15, 255, 224, 7, 255, 192, 1, 255, 0, 15,
  16, 32, 19, 2, 0, 32, 8, 112, 28, 248, 62, 252, 126, 126, 252, 63,
  248, 31, 240, 15, 224, 15, 224, 31, 240, 63, 248, 126, 252, 252, 126, 248,
  62, 112, 28, 32, 8, 24, 25, 75, 25, 1, 0, 1, 255, 7, 7, 255,
  206, 15, 255, 252, 31, 255, 248, 63, 199, 248, 63, 0, 248, 126, 1, 252,
  124, 3, 252, 124, 7, 188, 248, 7, 62, 248, 14, 62, 248, 28, 62, 248,
  56, 62, 248, 112, 62, 248, 224, 62, 248, 224, 62, 125, 192, 124, 127, 128,
  124, 127, 0, 252, 63, 1, 248, 63, 199, 248, 63, 255, 240, 63, 255, 224,
  119, 255, 192, 225, 255, 0, 19, 31, 93, 24, 2, 0, 7, 128, 0, 3,
  192, 0, 1, 224, 0, 0, 240, 0, 0, 120, 0, 0, 0, 0, 248, 3,
  224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224,
  248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248,
  3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3,
  224, 248, 3, 224, 248, 3, 224, 252, 7, 224, 127, 31, 192, 127, 255, 192,
  63, 255, 128, 31, 255, 0, 7, 252, 0, 19, 31, 93, 24, 2, 0, 0,
  30, 0, 0, 60, 0, 0, 120, 0, 0, 240, 0, 1, 224, 0, 0, 0,
  0, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224,
  248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248,
  3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3,
  224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 252, 7, 224, 127, 31, 192,
  127, 255, 192, 63, 255, 128, 31, 255, 0, 7, 252, 0, 19, 31, 93, 24,
  2, 0, 0, 96, 0, 0, 240, 0, 1, 248, 0, 3, 156, 0, 7, 14,
  0, 0, 0, 0, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224,
  248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248,
  3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3,
  224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 252, 7, 224,
  127, 31, 192, 127, 255, 192, 63, 255, 128, 31, 255, 0, 7, 252, 0, 19,
  31, 93, 24, 2, 0, 15, 30, 0, 15, 30, 0, 15, 30, 0, 15, 30,
  0, 0, 0, 0, 0, 0, 0, 248, 3, 224, 248, 3, 224, 248, 3, 224,
  248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248,
  3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3,
  224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224,
  252, 7, 224, 127, 31, 192, 127, 255, 192, 63, 255, 128, 31, 255, 0, 7,
  252, 0, 20, 31, 93, 22, 1, 0, 0, 30, 0, 0, 60, 0, 0, 120,
  0, 0, 240, 0, 1, 224, 0, 0, 0, 0, 252, 3, 240, 252, 3, 240,
  126, 7, 224, 62, 7, 192, 63, 15, 192, 63, 15, 128, 31, 15, 128, 31,
  159, 0, 15, 159, 0, 15, 254, 0, 7, 254, 0, 7, 252, 0, 3, 252,
  0, 3, 248, 0, 3, 248, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0,
  1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1,
  240, 0, 1, 240, 0, 18, 25, 75, 22, 2, 0, 248, 0, 0, 248, 0,
  0, 248, 0, 0, 255, 248, 0, 255, 254, 0, 255, 255, 0, 255, 255, 128,
  248, 31, 128, 248, 15, 192, 248, 7, 192, 248, 7, 192, 248, 7, 192, 248,
  7, 192, 248, 15, 192, 248, 31, 128, 255, 255, 128, 255, 255, 0, 255, 254,
  0, 255, 252, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0,
  248, 0, 0, 248, 0, 0, 17, 25, 75, 20, 2, 0, 15, 192, 0, 63,
  240, 0, 127, 252, 0, 255, 252, 0, 248, 126, 0, 248, 62, 0, 240, 62,
  0, 240, 62, 0, 240, 124, 0, 240, 252, 0, 241, 248, 0, 241, 252, 0,
  241, 254, 0, 240, 127, 0, 240, 31, 0, 240, 31, 128, 240, 15, 128, 240,
  15, 128, 240, 15, 128, 240, 31, 128, 240, 63, 0, 241, 255, 0, 241, 254,
  0, 241, 252, 0, 241, 240, 0, 15, 25, 50, 18, 1, 0, 15, 0, 7,
  128, 3, 128, 1, 192, 0, 224, 0, 0, 0, 0, 15, 240, 63, 252, 127,
  252, 124, 62, 248, 30, 248, 30, 1, 254, 15, 254, 63, 254, 127, 30, 248,
  30, 240, 30, 240, 62, 248, 126, 255, 254, 255, 254, 127, 222, 63, 30, 15,
  25, 50, 18, 1, 0, 0, 120, 0, 240, 0, 224, 1, 192, 3, 128, 0,
  0, 0, 0, 15, 240, 63, 252, 127, 252, 124, 62, 248, 30, 248, 30, 1,
  254, 15, 254, 63, 254, 127, 30, 248, 30, 240, 30, 240, 62, 248, 126, 255,
  254, 255, 254, 127, 222, 63, 30, 15, 25, 50, 18, 1, 0, 1, 128, 3,
  192, 7, 224, 14, 112, 28, 56, 0, 0, 0, 0, 15, 240, 63, 252, 127,
  252, 124, 62, 248, 30, 248, 30, 1, 254, 15, 254, 63, 254, 127, 30, 248,
  30, 240, 30, 240, 62, 248, 126, 255, 254, 255, 254, 127, 222, 63, 30, 15,
  24, 48, 18, 1, 0, 7, 140, 15, 252, 31, 248, 24, 240, 0, 0, 0,
  0, 15, 240, 63, 252, 127, 252, 124, 62, 248, 30, 248, 30, 1, 254, 15,
  254, 63, 254, 127, 30, 248, 30, 240, 30, 240, 62, 248, 126, 255, 254, 255,
  254, 127, 222, 63, 30, 15, 24, 48, 18, 1, 0, 30, 120, 30, 120, 30,
  120, 30, 120, 0, 0, 0, 0, 15, 240, 63, 252, 127, 252, 124, 62, 248,
  30, 248, 30, 1, 254, 15, 254, 63, 254, 127, 30, 248, 30, 240, 30, 240,
  62, 248, 126, 255, 254, 255, 254, 127, 222, 63, 30, 15, 25, 50, 18, 1,
  0, 3, 192, 6, 96, 4, 32, 4, 32, 6, 96, 3, 192, 0, 0, 15,
  240, 63, 252, 127, 252, 124, 62, 248, 30, 248, 30, 1, 254, 15, 254, 63,
  254, 127, 30, 248, 30, 248, 30, 240, 62, 248, 126, 255, 254, 255, 254, 127,
  222, 63, 30, 26, 19, 76, 29, 1, 0, 7, 224, 248, 0, 31, 251, 254,
  0, 63, 255, 255, 0, 63, 255, 255, 0, 124, 63, 15, 128, 120, 30, 7,
  128, 120, 30, 7, 192, 0, 62, 7, 192, 7, 255, 255, 192, 63, 255, 255,
  192, 127, 255, 255, 192, 124, 30, 0, 0, 248, 30, 0, 0, 248, 30, 7,
  192, 252, 63, 15, 192, 255, 255, 255, 128, 127, 247, 255, 0, 63, 227, 254,
  0, 15, 129, 248, 0, 15, 25, 50, 18, 1, 249, 7, 224, 31, 248, 63,
  252, 63, 252, 124, 62, 120, 30, 248, 30, 240, 0, 240, 0, 240, 0, 240,
  0, 248, 30, 248, 30, 124, 62, 127, 252, 63, 248, 31, 248, 7, 224, 3,
  0, 3, 0, 7, 192, 0, 224, 0, 224, 15, 192, 15, 128, 16, 25, 50,
  18, 1, 0, 15, 0, 7, 128, 3, 128, 1, 192, 0, 224, 0, 0, 0,
  0, 7, 224, 31, 248, 63, 252, 127, 254, 124, 62, 248, 30, 240, 31, 255,
  255, 255, 255, 255, 255, 240, 0, 240, 0, 248, 30, 124, 62, 127, 254, 63,
  252, 31, 240, 7, 192, 16, 25, 50, 18, 1, 0, 0, 120, 0, 240, 0,
  224, 1, 192, 3, 128, 0, 0, 0, 0, 7, 224, 31, 248, 63, 252, 127,
  254, 124, 62, 248, 30, 240, 31, 255, 255, 255, 255, 255, 255, 240, 0, 240,
  0, 248, 30, 124, 62, 127, 254, 63, 252, 31, 240, 7, 192, 16, 25, 50,
  18, 1, 0, 1, 128, 3, 192, 7, 224, 14, 112, 28, 56, 0, 0, 0,
  0, 7, 224, 31, 248, 63, 252, 127, 254, 124, 62, 248, 30, 240, 31, 255,
  255, 255, 255, 255, 255, 240, 0, 240, 0, 248, 30, 124, 62, 127, 254, 63,
  252, 31, 240, 7, 192, 16, 24, 48, 18, 1, 0, 30, 120, 30, 120, 30,
  120, 30, 120, 0, 0, 0, 0, 7, 224, 31, 248, 63, 252, 127, 254, 124,
  62, 248, 30, 240, 31, 255, 255, 255, 255, 255, 255, 240, 0, 240, 0, 248,
  30, 124, 62, 127, 254, 63, 252, 31, 240, 7, 192, 7, 25, 25, 9, 1,
  0, 240, 120, 56, 28, 14, 0, 0, 30, 30, 30, 30, 30, 30, 30, 30,
  30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 6, 25, 25, 9, 2, 0,
  60, 56, 112, 112, 224, 0, 0, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 10, 25, 50, 9, 255, 0, 12,
  0, 30, 0, 63, 0, 115, 128, 225, 192, 0, 0, 0, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 10, 24, 48, 9, 255, 0, 243, 192, 243, 192, 243, 192, 243, 192, 0,
  0, 0, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 17, 26, 78, 20, 1, 0, 48, 0, 0,
  120, 32, 0, 124, 240, 0, 63, 224, 0, 31, 192, 0, 63, 224, 0, 115,
  240, 0, 33, 248, 0, 7, 252, 0, 31, 254, 0, 63, 254, 0, 127, 255,
  0, 124, 31, 0, 248, 15, 128, 248, 15, 128, 240, 7, 128, 240, 7, 128,
  240, 7, 128, 248, 15, 128, 248, 15, 128, 252, 31, 128, 126, 63, 0, 127,
  255, 0, 63, 254, 0, 31, 252, 0, 7, 240, 0, 15, 24, 48, 20, 2,
  0, 15, 24, 31, 248, 63, 240, 49, 224, 0, 0, 0, 0, 243, 240, 247,
  248, 255, 252, 255, 254, 252, 62, 248, 62, 240, 30, 240, 30, 240, 30, 240,
  30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240,
  30, 17, 25, 75, 20, 1, 0, 7, 128, 0, 3, 192, 0, 1, 192, 0,
  1, 224, 0, 0, 240, 0, 0, 0, 0, 0, 0, 0, 7, 240, 0, 31,
  252, 0, 63, 254, 0, 127, 255, 0, 124, 31, 0, 248, 15, 128, 248, 15,
  128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 248, 15, 128,
  248, 15, 128, 124, 31, 0, 127, 255, 0, 63, 254, 0, 31, 252, 0, 7,
  240, 0, 17, 25, 75, 20, 1, 0, 0, 120, 0, 0, 240, 0, 0, 224,
  0, 1, 192, 0, 3, 192, 0, 0, 0, 0, 0, 0, 0, 7, 240, 0,
  31, 252, 0, 63, 254, 0, 127, 255, 0, 124, 31, 0, 248, 15, 128, 248,
  15, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 248, 15,
  128, 248, 15, 128, 124, 31, 0, 127, 255, 0, 63, 254, 0, 31, 252, 0,
  7, 240, 0, 17, 25, 75, 20, 1, 0, 0, 192, 0, 1, 224, 0, 3,
  240, 0, 7, 56, 0, 14, 28, 0, 0, 0, 0, 0, 0, 0, 7, 240,
  0, 31, 252, 0, 63, 254, 0, 127, 255, 0, 124, 31, 0, 248, 15, 128,
  248, 15, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 248,
  15, 128, 248, 15, 128, 124, 31, 0, 127, 255, 0, 63, 254, 0, 31, 252,
  0, 7, 240, 0, 17, 24, 72, 20, 1, 0, 7, 140, 0, 15, 252, 0,
  31, 248, 0, 24, 240, 0, 0, 0, 0, 0, 0, 0, 7, 240, 0, 31,
  252, 0, 63, 254, 0, 127, 255, 0, 124, 31, 0, 248, 15, 128, 248, 15,
  128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 248, 15, 128,
  248, 15, 128, 124, 31, 0, 127, 255, 0, 63, 254, 0, 31, 252, 0, 7,
  240, 0, 17, 24, 72, 20, 1, 0, 30, 60, 0, 30, 60, 0, 30, 60,
  0, 30, 60, 0, 0, 0, 0, 0, 0, 0, 7, 240, 0, 31, 252, 0,
  63, 254, 0, 127, 255, 0, 124, 31, 0, 248, 15, 128, 248, 15, 128, 240,
  7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 248, 15, 128, 248, 15,
  128, 124, 31, 0, 127, 255, 0, 63, 254, 0, 31, 252, 0, 7, 240, 0,
  16, 16, 32, 19, 1, 0, 3, 192, 3, 192, 3, 192, 3, 192, 0, 0,
  0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 3, 192,
  3, 192, 3, 192, 3, 192, 21, 18, 54, 20, 255, 0, 1, 252, 56, 7,
  255, 112, 15, 255, 224, 31, 255, 192, 31, 143, 192, 62, 7, 224, 62, 15,
  224, 60, 29, 224, 60, 57, 224, 60, 113, 224, 62, 227, 224, 63, 131, 224,
  63, 7, 224, 31, 143, 192, 31, 255, 192, 63, 255, 128, 119, 255, 0, 225,
  252, 0, 15, 25, 50, 20, 2, 0, 30, 0, 15, 0, 7, 0, 3, 128,
  1, 192, 0, 0, 0, 0, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 248, 62,
  248, 126, 255, 254, 127, 254, 127, 222, 31, 30, 15, 25, 50, 20, 2, 0,
  0, 240, 1, 224, 1, 192, 3, 128, 7, 0, 0, 0, 0, 0, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 248, 62, 248, 126, 255, 254, 127, 254, 127, 222,
  31, 30, 15, 25, 50, 20, 2, 0, 3, 0, 7, 128, 15, 192, 28, 224,
  56, 112, 0, 0, 0, 0, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 248, 62,
  248, 126, 255, 254, 127, 254, 127, 222, 31, 30, 15, 25, 50, 20, 2, 0,
  60, 120, 60, 120, 60, 120, 60, 120, 0, 0, 0, 0, 0, 0, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 248, 62, 248, 126, 255, 254, 127, 254, 127, 222,
  31, 30, 16, 32, 64, 19, 1, 249, 0, 120, 0, 240, 1, 224, 1, 192,
  3, 128, 0, 0, 0, 0, 248, 31, 248, 31, 248, 31, 120, 30, 124, 62,
  124, 60, 60, 60, 60, 60, 62, 120, 62, 120, 30, 120, 31, 240, 31, 240,
  15, 240, 15, 224, 7, 224, 7, 224, 7, 192, 7, 192, 7, 192, 15, 128,
  63, 128, 63, 0, 63, 0, 60, 0, 16, 32, 64, 20, 2, 249, 240, 0,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 243, 240, 247, 252,
  255, 254, 255, 254, 252, 63, 248, 31, 248, 31, 240, 15, 240, 15, 240, 15,
  240, 15, 248, 31, 248, 31, 252, 62, 255, 254, 255, 252, 247, 248, 241, 240,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 16, 31,
  62, 19, 1, 249, 30, 120, 30, 120, 30, 120, 30, 120, 0, 0, 0, 0,
  248, 31, 248, 31, 248, 31, 120, 62, 124, 62, 124, 60, 124, 60, 62, 124,
  62, 120, 62, 120, 30, 120, 31, 240, 31, 240, 15, 240, 15, 224, 7, 224,
  7, 224, 7, 192, 7, 192, 7, 192, 15, 128, 63, 128, 63, 0, 63, 0,
  60, 0
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--34-240-100-100-P-182-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 0, '1' Height: 23
  Calculated Max Values w=17 h=25 x= 3 y=13 dx=19 dy= 0 ascent=25 len=72
  Font Bounding box     w=40 h=49 x=-6 y=-12
  Calculated Min Values           x= 0 y=-6 dx= 0 dy= 0
  Pure Font   ascent =23 descent= 0
  X Font      ascent =23 descent= 0
  Max Font    ascent =25 descent=-6
*/
const u8g_fntpgm_uint8_t u8g_font_helvB24n[743] U8G_FONT_SECTION("u8g_font_helvB24n") = {
  0, 40, 49, 250, 244, 23, 0, 0, 0, 0, 42, 58, 0, 25, 250, 23,
  0, 10, 11, 22, 13, 1, 13, 12, 0, 12, 0, 76, 128, 237, 192, 255,
  192, 127, 128, 30, 0, 63, 0, 127, 128, 115, 128, 33, 0, 16, 16, 32,
  19, 1, 0, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 255,
  255, 255, 255, 255, 255, 255, 255, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 5, 11, 11, 9, 2, 250, 248, 248, 248, 248, 248, 24, 24,
  56, 112, 224, 128, 9, 5, 10, 11, 1, 7, 255, 128, 255, 128, 255, 128,
  255, 128, 255, 128, 5, 5, 5, 9, 2, 0, 248, 248, 248, 248, 248, 8,
  25, 25, 9, 0, 0, 3, 3, 3, 3, 6, 6, 6, 14, 12, 12, 12,
  28, 24, 24, 24, 48, 48, 48, 112, 96, 96, 96, 192, 192, 192, 15, 24,
  48, 18, 1, 0, 15, 224, 31, 240, 63, 248, 127, 252, 124, 124, 248, 62,
  248, 62, 248, 62, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 248, 62, 248, 62, 248, 62, 124, 124, 127, 252, 63, 248,
  31, 240, 15, 224, 10, 23, 46, 18, 2, 0, 1, 192, 3, 192, 7, 192,
  31, 192, 255, 192, 255, 192, 255, 192, 3, 192, 3, 192, 3, 192, 3, 192,
  3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192,
  3, 192, 3, 192, 3, 192, 3, 192, 16, 24, 48, 18, 1, 0, 15, 224,
  63, 248, 127, 252, 127, 254, 252, 126, 248, 63, 248, 31, 240, 31, 240, 31,
  0, 63, 0, 62, 0, 126, 0, 252, 1, 248, 7, 240, 15, 224, 31, 128,
  63, 0, 126, 0, 252, 0, 255, 255, 255, 255, 255, 255, 255, 255, 16, 24,
  48, 18, 1, 0, 15, 224, 63, 248, 127, 252, 127, 252, 248, 62, 240, 62,
  240, 30, 240, 30, 0, 62, 0, 124, 3, 248, 3, 240, 3, 252, 0, 126,
  0, 63, 0, 31, 240, 31, 240, 31, 240, 63, 248, 62, 127, 254, 127, 252,
  63, 248, 15, 224, 16, 24, 48, 18, 1, 0, 0, 248, 0, 248, 1, 248,
  3, 248, 3, 248, 7, 248, 15, 120, 14, 120, 30, 120, 28, 120, 60, 120,
  120, 120, 112, 120, 240, 120, 224, 120, 255, 255, 255, 255, 255, 255, 255, 255,
  0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 15, 24, 48, 18, 1, 0,
  63, 252, 63, 252, 63, 252, 63, 252, 56, 0, 120, 0, 120, 0, 120, 0,
  123, 224, 127, 248, 127, 252, 127, 252, 120, 126, 0, 62, 0, 62, 0, 30,
  0, 30, 240, 62, 240, 62, 248, 124, 127, 252, 127, 248, 63, 240, 15, 192,
  15, 24, 48, 18, 1, 0, 7, 224, 31, 248, 63, 252, 63, 254, 124, 62,
  120, 30, 240, 0, 240, 0, 243, 224, 247, 248, 255, 252, 255, 252, 252, 126,
  248, 62, 240, 30, 240, 30, 240, 30, 240, 30, 248, 62, 124, 124, 127, 252,
  63, 248, 31, 240, 7, 192, 16, 24, 48, 18, 1, 0, 255, 255, 255, 255,
  255, 255, 255, 255, 0, 30, 0, 62, 0, 60, 0, 120, 0, 248, 0, 240,
  1, 240, 1, 224, 3, 224, 3, 192, 7, 192, 7, 192, 7, 128, 15, 128,
  15, 128, 15, 128, 31, 0, 31, 0, 31, 0, 31, 0, 17, 24, 72, 18,
  0, 0, 7, 240, 0, 31, 252, 0, 63, 254, 0, 62, 62, 0, 124, 31,
  0, 120, 15, 0, 120, 15, 0, 120, 15, 0, 124, 31, 0, 62, 62, 0,
  31, 252, 0, 31, 252, 0, 63, 254, 0, 124, 31, 0, 248, 15, 128, 240,
  7, 128, 240, 7, 128, 240, 7, 128, 248, 15, 128, 126, 63, 0, 127, 254,
  0, 63, 254, 0, 31, 252, 0, 7, 240, 0, 15, 24, 48, 18, 1, 0,
  7, 192, 31, 240, 63, 248, 127, 252, 124, 124, 248, 62, 240, 30, 240, 30,
  240, 30, 240, 30, 248, 62, 252, 126, 127, 254, 127, 254, 63, 222, 7, 158,
  0, 30, 0, 30, 240, 60, 248, 124, 127, 248, 127, 248, 31, 240, 7, 192,
  5, 17, 17, 11, 3, 0, 248, 248, 248, 248, 248, 0, 0, 0, 0, 0,
  0, 0, 248, 248, 248, 248, 248
};

/*
  Fontname: -Adobe-Helvetica-Bold-R-Normal--34-240-100-100-P-182-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 25, '1' Height: 23
  Calculated Max Values w=29 h=32 x= 3 y=20 dx=33 dy= 0 ascent=25 len=120
  Font Bounding box     w=40 h=49 x=-6 y=-12
  Calculated Min Values           x= 0 y=-7 dx= 0 dy= 0
  Pure Font   ascent =25 descent=-7
  X Font      ascent =25 descent=-7
  Max Font    ascent =25 descent=-7
*/
const u8g_fntpgm_uint8_t u8g_font_helvB24r[5214] U8G_FONT_SECTION("u8g_font_helvB24r") = {
  0, 40, 49, 250, 244, 25, 5, 252, 14, 144, 32, 127, 249, 25, 249, 25,
  249, 0, 0, 0, 9, 0, 1, 5, 25, 25, 11, 3, 0, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 112, 112, 112, 112, 112, 112, 112, 0,
  0, 248, 248, 248, 248, 248, 11, 9, 18, 16, 2, 16, 241, 224, 241, 224,
  241, 224, 241, 224, 241, 224, 241, 224, 241, 224, 96, 192, 96, 192, 18, 25,
  75, 19, 0, 255, 3, 199, 0, 3, 199, 0, 3, 143, 0, 3, 143, 0,
  7, 143, 0, 7, 142, 0, 7, 142, 0, 127, 255, 192, 127, 255, 192, 127,
  255, 192, 127, 255, 192, 15, 28, 0, 14, 28, 0, 14, 28, 0, 14, 60,
  0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 255, 255, 128, 28, 120, 0,
  60, 120, 0, 60, 112, 0, 60, 112, 0, 56, 240, 0, 56, 240, 0, 16,
  28, 56, 18, 1, 253, 1, 128, 1, 128, 15, 240, 63, 252, 127, 254, 253,
  190, 249, 159, 241, 159, 241, 143, 249, 128, 255, 128, 127, 192, 63, 240, 15,
  252, 1, 254, 1, 255, 1, 159, 1, 143, 241, 143, 241, 159, 249, 159, 127,
  254, 127, 254, 63, 248, 7, 224, 1, 128, 1, 128, 1, 128, 26, 23, 92,
  29, 1, 0, 14, 0, 48, 0, 63, 128, 112, 0, 127, 192, 96, 0, 113,
  192, 224, 0, 224, 224, 192, 0, 224, 225, 192, 0, 224, 227, 128, 0, 224,
  227, 128, 0, 113, 199, 0, 0, 127, 198, 0, 0, 63, 142, 0, 0, 14,
  12, 28, 0, 0, 28, 127, 0, 0, 24, 255, 128, 0, 56, 227, 128, 0,
  49, 193, 192, 0, 113, 193, 192, 0, 97, 193, 192, 0, 225, 193, 192, 1,
  192, 227, 128, 1, 192, 255, 128, 3, 128, 127, 0, 3, 0, 28, 0, 20,
  25, 75, 24, 2, 0, 3, 224, 0, 15, 248, 0, 31, 252, 0, 31, 252,
  0, 30, 60, 0, 62, 60, 0, 62, 60, 0, 31, 60, 0, 31, 248, 0,
  15, 248, 0, 15, 240, 0, 15, 224, 0, 63, 241, 224, 127, 241, 224, 124,
  249, 192, 248, 255, 192, 240, 127, 192, 240, 63, 128, 240, 31, 0, 248, 15,
  128, 252, 63, 192, 127, 255, 224, 127, 251, 224, 31, 241, 240, 7, 192, 0,
  4, 9, 9, 8, 2, 16, 240, 240, 240, 240, 240, 240, 240, 96, 96, 8,
  31, 31, 11, 1, 250, 7, 15, 30, 30, 60, 60, 56, 120, 120, 120, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 248, 120, 120, 120, 120, 60, 60, 28,
  30, 14, 15, 7, 8, 31, 31, 11, 1, 250, 224, 240, 120, 120, 60, 60,
  28, 30, 30, 30, 15, 15, 15, 15, 15, 15, 15, 15, 15, 31, 30, 30,
  30, 28, 60, 60, 56, 120, 112, 240, 224, 10, 11, 22, 13, 1, 13, 12,
  0, 12, 0, 76, 128, 237, 192, 255, 192, 127, 128, 30, 0, 63, 0, 127,
  128, 115, 128, 33, 0, 16, 16, 32, 19, 1, 0, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 255, 255, 255, 255, 255, 255, 255, 255, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 5, 11, 11, 9, 2,
  250, 248, 248, 248, 248, 248, 24, 24, 56, 112, 224, 128, 9, 5, 10, 11,
  1, 7, 255, 128, 255, 128, 255, 128, 255, 128, 255, 128, 5, 5, 5, 9,
  2, 0, 248, 248, 248, 248, 248, 8, 25, 25, 9, 0, 0, 3, 3, 3,
  3, 6, 6, 6, 14, 12, 12, 12, 28, 24, 24, 24, 48, 48, 48, 112,
  96, 96, 96, 192, 192, 192, 15, 24, 48, 18, 1, 0, 15, 224, 31, 240,
  63, 248, 127, 252, 124, 124, 248, 62, 248, 62, 248, 62, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 248, 62, 248, 62,
  248, 62, 124, 124, 127, 252, 63, 248, 31, 240, 15, 224, 10, 23, 46, 18,
  2, 0, 1, 192, 3, 192, 7, 192, 31, 192, 255, 192, 255, 192, 255, 192,
  3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192,
  3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192,
  16, 24, 48, 18, 1, 0, 15, 224, 63, 248, 127, 252, 127, 254, 252, 126,
  248, 63, 248, 31, 240, 31, 240, 31, 0, 63, 0, 62, 0, 126, 0, 252,
  1, 248, 7, 240, 15, 224, 31, 128, 63, 0, 126, 0, 252, 0, 255, 255,
  255, 255, 255, 255, 255, 255, 16, 24, 48, 18, 1, 0, 15, 224, 63, 248,
  127, 252, 127, 252, 248, 62, 240, 62, 240, 30, 240, 30, 0, 62, 0, 124,
  3, 248, 3, 240, 3, 252, 0, 126, 0, 63, 0, 31, 240, 31, 240, 31,
  240, 63, 248, 62, 127, 254, 127, 252, 63, 248, 15, 224, 16, 24, 48, 18,
  1, 0, 0, 248, 0, 248, 1, 248, 3, 248, 3, 248, 7, 248, 15, 120,
  14, 120, 30, 120, 28, 120, 60, 120, 120, 120, 112, 120, 240, 120, 224, 120,
  255, 255, 255, 255, 255, 255, 255, 255, 0, 120, 0, 120, 0, 120, 0, 120,
  0, 120, 15, 24, 48, 18, 1, 0, 63, 252, 63, 252, 63, 252, 63, 252,
  56, 0, 120, 0, 120, 0, 120, 0, 123, 224, 127, 248, 127, 252, 127, 252,
  120, 126, 0, 62, 0, 62, 0, 30, 0, 30, 240, 62, 240, 62, 248, 124,
  127, 252, 127, 248, 63, 240, 15, 192, 15, 24, 48, 18, 1, 0, 7, 224,
  31, 248, 63, 252, 63, 254, 124, 62, 120, 30, 240, 0, 240, 0, 243, 224,
  247, 248, 255, 252, 255, 252, 252, 126, 248, 62, 240, 30, 240, 30, 240, 30,
  240, 30, 248, 62, 124, 124, 127, 252, 63, 248, 31, 240, 7, 192, 16, 24,
  48, 18, 1, 0, 255, 255, 255, 255, 255, 255, 255, 255, 0, 30, 0, 62,
  0, 60, 0, 120, 0, 248, 0, 240, 1, 240, 1, 224, 3, 224, 3, 192,
  7, 192, 7, 192, 7, 128, 15, 128, 15, 128, 15, 128, 31, 0, 31, 0,
  31, 0, 31, 0, 17, 24, 72, 18, 0, 0, 7, 240, 0, 31, 252, 0,
  63, 254, 0, 62, 62, 0, 124, 31, 0, 120, 15, 0, 120, 15, 0, 120,
  15, 0, 124, 31, 0, 62, 62, 0, 31, 252, 0, 31, 252, 0, 63, 254,
  0, 124, 31, 0, 248, 15, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128,
  248, 15, 128, 126, 63, 0, 127, 254, 0, 63, 254, 0, 31, 252, 0, 7,
  240, 0, 15, 24, 48, 18, 1, 0, 7, 192, 31, 240, 63, 248, 127, 252,
  124, 124, 248, 62, 240, 30, 240, 30, 240, 30, 240, 30, 248, 62, 252, 126,
  127, 254, 127, 254, 63, 222, 7, 158, 0, 30, 0, 30, 240, 60, 248, 124,
  127, 248, 127, 248, 31, 240, 7, 192, 5, 17, 17, 11, 3, 0, 248, 248,
  248, 248, 248, 0, 0, 0, 0, 0, 0, 0, 248, 248, 248, 248, 248, 5,
  23, 23, 11, 3, 250, 248, 248, 248, 248, 248, 0, 0, 0, 0, 0, 0,
  0, 248, 248, 248, 248, 248, 24, 24, 56, 112, 224, 128, 16, 16, 32, 19,
  1, 0, 0, 3, 0, 31, 0, 127, 3, 255, 15, 254, 127, 248, 255, 192,
  254, 0, 254, 0, 255, 192, 127, 240, 15, 254, 3, 255, 0, 127, 0, 31,
  0, 3, 15, 12, 24, 19, 2, 2, 255, 254, 255, 254, 255, 254, 255, 254,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 254, 255, 254, 255, 254, 255, 254,
  16, 16, 32, 19, 1, 0, 192, 0, 240, 0, 254, 0, 255, 192, 127, 240,
  31, 254, 3, 255, 0, 127, 0, 127, 3, 255, 31, 254, 127, 240, 255, 192,
  254, 0, 240, 0, 192, 0, 16, 25, 50, 20, 2, 0, 15, 224, 63, 248,
  127, 252, 127, 254, 252, 126, 248, 63, 248, 31, 240, 31, 240, 31, 0, 63,
  0, 126, 0, 254, 1, 252, 1, 248, 3, 224, 3, 192, 7, 192, 7, 192,
  0, 0, 0, 0, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 29, 30,
  120, 33, 1, 251, 0, 15, 224, 0, 0, 127, 252, 0, 1, 255, 254, 0,
  3, 240, 63, 128, 7, 192, 7, 192, 15, 0, 3, 192, 30, 0, 1, 224,
  28, 0, 0, 240, 60, 7, 220, 112, 56, 31, 252, 112, 112, 60, 252, 56,
  112, 120, 120, 56, 240, 240, 56, 56, 224, 224, 56, 56, 225, 224, 56, 56,
  225, 192, 112, 120, 225, 192, 112, 112, 225, 192, 112, 112, 225, 224, 240, 224,
  241, 225, 241, 224, 112, 255, 255, 192, 120, 127, 63, 128, 56, 62, 30, 0,
  60, 0, 0, 0, 30, 0, 0, 0, 15, 128, 0, 0, 15, 240, 60, 0,
  3, 255, 252, 0, 1, 255, 252, 0, 0, 127, 224, 0, 22, 25, 75, 23,
  0, 0, 0, 252, 0, 0, 252, 0, 1, 254, 0, 1, 254, 0, 1, 254,
  0, 3, 255, 0, 3, 255, 0, 3, 255, 0, 7, 207, 128, 7, 207, 128,
  7, 207, 128, 15, 135, 128, 15, 135, 192, 15, 135, 192, 31, 3, 192, 31,
  3, 224, 31, 255, 224, 31, 255, 224, 63, 255, 240, 63, 255, 240, 62, 1,
  240, 124, 0, 248, 124, 0, 248, 252, 0, 252, 248, 0, 124, 19, 25, 75,
  24, 3, 0, 255, 252, 0, 255, 255, 0, 255, 255, 128, 255, 255, 128, 248,
  15, 192, 248, 7, 192, 248, 7, 192, 248, 7, 192, 248, 7, 192, 248, 15,
  128, 255, 255, 0, 255, 255, 0, 255, 255, 128, 255, 255, 192, 248, 7, 192,
  248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248,
  7, 224, 255, 255, 192, 255, 255, 192, 255, 255, 128, 255, 254, 0, 21, 25,
  75, 24, 1, 0, 1, 254, 0, 7, 255, 128, 15, 255, 192, 31, 255, 224,
  63, 135, 240, 62, 1, 240, 124, 1, 248, 124, 0, 248, 124, 0, 248, 248,
  0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0,
  0, 248, 0, 0, 124, 0, 248, 124, 0, 248, 126, 1, 248, 62, 1, 240,
  63, 135, 240, 31, 255, 224, 15, 255, 192, 7, 255, 128, 1, 254, 0, 21,
  25, 75, 24, 2, 0, 255, 248, 0, 255, 255, 0, 255, 255, 128, 255, 255,
  192, 248, 15, 224, 248, 3, 224, 248, 3, 240, 248, 1, 240, 248, 1, 248,
  248, 0, 248, 248, 0, 248, 248, 0, 248, 248, 0, 248, 248, 0, 248, 248,
  0, 248, 248, 0, 248, 248, 1, 248, 248, 1, 240, 248, 3, 240, 248, 3,
  224, 248, 15, 224, 255, 255, 192, 255, 255, 128, 255, 255, 0, 255, 248, 0,
  18, 25, 75, 22, 2, 0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 255,
  255, 128, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0,
  0, 248, 0, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0,
  248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248,
  0, 0, 248, 0, 0, 255, 255, 192, 255, 255, 192, 255, 255, 192, 255, 255,
  192, 16, 25, 50, 20, 2, 0, 255, 255, 255, 255, 255, 255, 255, 255, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 255, 254, 255, 254, 255,
  254, 255, 254, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 22, 25, 75, 25, 1, 0, 0,
  255, 0, 3, 255, 192, 15, 255, 224, 31, 255, 240, 31, 195, 248, 63, 0,
  248, 126, 0, 124, 124, 0, 124, 252, 0, 0, 248, 0, 0, 248, 0, 0,
  248, 0, 0, 248, 15, 252, 248, 15, 252, 248, 15, 252, 248, 15, 252, 252,
  0, 124, 124, 0, 124, 126, 0, 124, 126, 0, 252, 63, 131, 252, 63, 255,
  252, 31, 255, 220, 7, 255, 156, 3, 254, 28, 19, 25, 75, 23, 2, 0,
  248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248,
  3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 255, 255,
  224, 255, 255, 224, 255, 255, 224, 255, 255, 224, 248, 3, 224, 248, 3, 224,
  248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248,
  3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 5, 25, 25, 9, 2,
  0, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248,
  248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 15, 25, 50, 18, 1, 0,
  0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62,
  0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 248, 62,
  248, 62, 248, 62, 248, 62, 248, 62, 252, 126, 255, 252, 127, 252, 63, 248,
  15, 224, 20, 25, 75, 24, 2, 0, 248, 7, 224, 248, 7, 224, 248, 15,
  192, 248, 31, 128, 248, 63, 0, 248, 126, 0, 248, 252, 0, 248, 248, 0,
  249, 248, 0, 251, 240, 0, 255, 224, 0, 255, 224, 0, 255, 240, 0, 255,
  240, 0, 255, 248, 0, 252, 252, 0, 248, 126, 0, 248, 126, 0, 248, 63,
  0, 248, 31, 128, 248, 15, 128, 248, 15, 192, 248, 7, 224, 248, 3, 240,
  248, 3, 240, 16, 25, 50, 20, 2, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 255, 255, 255, 255, 255, 255, 255, 255, 23, 25, 75, 27, 2,
  0, 254, 0, 254, 254, 0, 254, 255, 1, 254, 255, 1, 254, 255, 1, 254,
  255, 1, 254, 255, 131, 254, 255, 131, 254, 251, 131, 190, 251, 131, 190, 251,
  199, 190, 251, 199, 190, 251, 199, 190, 249, 199, 62, 249, 239, 62, 249, 239,
  62, 249, 239, 62, 249, 239, 62, 248, 238, 62, 248, 254, 62, 248, 254, 62,
  248, 254, 62, 248, 124, 62, 248, 124, 62, 248, 124, 62, 19, 25, 75, 24,
  2, 0, 248, 3, 224, 252, 3, 224, 252, 3, 224, 254, 3, 224, 254, 3,
  224, 255, 3, 224, 255, 3, 224, 255, 131, 224, 255, 195, 224, 251, 195, 224,
  251, 227, 224, 249, 227, 224, 249, 243, 224, 248, 243, 224, 248, 251, 224, 248,
  123, 224, 248, 63, 224, 248, 63, 224, 248, 31, 224, 248, 31, 224, 248, 15,
  224, 248, 15, 224, 248, 7, 224, 248, 7, 224, 248, 3, 224, 23, 25, 75,
  25, 1, 0, 1, 255, 0, 7, 255, 192, 15, 255, 224, 31, 255, 240, 63,
  199, 248, 63, 1, 248, 126, 0, 252, 124, 0, 124, 124, 0, 124, 248, 0,
  62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62,
  248, 0, 62, 124, 0, 124, 124, 0, 124, 126, 0, 252, 63, 1, 248, 63,
  199, 248, 31, 255, 240, 15, 255, 224, 7, 255, 192, 1, 255, 0, 18, 25,
  75, 22, 2, 0, 255, 248, 0, 255, 254, 0, 255, 255, 0, 255, 255, 128,
  248, 31, 128, 248, 15, 192, 248, 7, 192, 248, 7, 192, 248, 7, 192, 248,
  7, 192, 248, 15, 192, 248, 31, 128, 255, 255, 128, 255, 255, 0, 255, 252,
  0, 255, 240, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0,
  248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 23,
  26, 78, 26, 1, 255, 1, 255, 0, 7, 255, 192, 15, 255, 224, 31, 255,
  240, 63, 199, 248, 63, 1, 248, 126, 0, 252, 124, 0, 124, 252, 0, 126,
  248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248,
  0, 62, 248, 2, 62, 252, 7, 62, 124, 15, 188, 126, 15, 252, 63, 7,
  248, 63, 195, 240, 31, 255, 248, 15, 255, 252, 7, 255, 254, 1, 255, 60,
  0, 0, 24, 19, 25, 75, 24, 2, 0, 255, 254, 0, 255, 255, 128, 255,
  255, 192, 255, 255, 192, 248, 7, 224, 248, 3, 224, 248, 3, 224, 248, 3,
  224, 248, 3, 224, 248, 7, 192, 248, 15, 192, 255, 255, 128, 255, 255, 0,
  255, 255, 0, 255, 255, 128, 248, 15, 192, 248, 7, 192, 248, 7, 192, 248,
  7, 192, 248, 7, 192, 248, 7, 192, 248, 7, 192, 248, 7, 192, 248, 7,
  224, 248, 3, 224, 19, 25, 75, 22, 1, 0, 3, 248, 0, 15, 254, 0,
  31, 255, 0, 63, 255, 128, 62, 31, 128, 124, 7, 192, 120, 7, 192, 120,
  3, 192, 124, 0, 0, 127, 0, 0, 63, 240, 0, 63, 254, 0, 31, 255,
  128, 3, 255, 192, 0, 63, 192, 0, 7, 224, 0, 3, 224, 248, 3, 224,
  248, 3, 224, 124, 3, 224, 126, 15, 192, 63, 255, 192, 31, 255, 128, 15,
  255, 0, 3, 248, 0, 19, 25, 75, 20, 0, 0, 255, 255, 224, 255, 255,
  224, 255, 255, 224, 255, 255, 224, 1, 240, 0, 1, 240, 0, 1, 240, 0,
  1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1,
  240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240,
  0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0,
  1, 240, 0, 1, 240, 0, 19, 25, 75, 24, 2, 0, 248, 3, 224, 248,
  3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3,
  224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224,
  248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248, 3, 224, 248,
  3, 224, 248, 3, 224, 252, 7, 224, 127, 31, 192, 127, 255, 192, 63, 255,
  128, 31, 255, 0, 7, 252, 0, 20, 25, 75, 22, 1, 0, 248, 1, 240,
  248, 1, 240, 124, 3, 224, 124, 3, 224, 124, 3, 224, 60, 3, 192, 62,
  7, 192, 62, 7, 192, 30, 7, 128, 31, 15, 128, 31, 15, 128, 15, 15,
  0, 15, 15, 0, 15, 15, 0, 7, 158, 0, 7, 158, 0, 7, 158, 0,
  7, 254, 0, 3, 252, 0, 3, 252, 0, 3, 252, 0, 1, 248, 0, 1,
  248, 0, 1, 248, 0, 0, 240, 0, 29, 25, 100, 31, 1, 0, 248, 31,
  129, 248, 248, 31, 129, 248, 120, 31, 129, 240, 120, 31, 129, 240, 120, 31,
  129, 240, 124, 63, 195, 224, 124, 63, 195, 224, 124, 63, 195, 224, 60, 63,
  195, 224, 60, 57, 195, 192, 62, 121, 227, 192, 62, 121, 231, 192, 30, 121,
  231, 192, 30, 121, 231, 128, 30, 112, 231, 128, 30, 112, 231, 128, 15, 240,
  255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 224, 127, 0, 7, 224,
  126, 0, 7, 224, 126, 0, 7, 224, 126, 0, 3, 192, 60, 0, 3, 192,
  60, 0, 20, 25, 75, 22, 1, 0, 252, 3, 224, 126, 7, 224, 126, 7,
  192, 63, 15, 192, 31, 15, 128, 31, 159, 0, 15, 159, 0, 15, 190, 0,
  7, 254, 0, 7, 252, 0, 3, 252, 0, 3, 248, 0, 1, 248, 0, 3,
  248, 0, 3, 252, 0, 7, 252, 0, 7, 254, 0, 15, 191, 0, 31, 159,
  0, 31, 31, 128, 63, 15, 128, 62, 15, 192, 126, 7, 192, 252, 7, 224,
  252, 3, 240, 20, 25, 75, 22, 1, 0, 252, 3, 240, 252, 3, 224, 126,
  7, 224, 62, 7, 192, 63, 15, 192, 63, 15, 128, 31, 15, 128, 31, 159,
  0, 15, 159, 0, 15, 254, 0, 7, 254, 0, 7, 252, 0, 3, 252, 0,
  3, 248, 0, 3, 248, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1,
  240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240,
  0, 1, 240, 0, 17, 25, 75, 20, 1, 0, 255, 255, 128, 255, 255, 128,
  255, 255, 128, 255, 255, 128, 0, 15, 128, 0, 31, 128, 0, 63, 0, 0,
  126, 0, 0, 124, 0, 0, 252, 0, 1, 248, 0, 3, 240, 0, 3, 240,
  0, 7, 224, 0, 15, 192, 0, 15, 128, 0, 31, 128, 0, 63, 0, 0,
  126, 0, 0, 126, 0, 0, 252, 0, 0, 255, 255, 128, 255, 255, 128, 255,
  255, 128, 255, 255, 128, 8, 31, 31, 11, 2, 250, 255, 255, 255, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 255, 255, 255, 9, 25, 50, 9, 0, 0,
  192, 0, 192, 0, 224, 0, 96, 0, 96, 0, 112, 0, 112, 0, 48, 0,
  56, 0, 56, 0, 24, 0, 28, 0, 28, 0, 12, 0, 12, 0, 14, 0,
  14, 0, 6, 0, 7, 0, 7, 0, 3, 0, 3, 128, 3, 128, 1, 128,
  1, 128, 8, 31, 31, 11, 0, 250, 255, 255, 255, 15, 15, 15, 15, 15,
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
  15, 15, 15, 15, 255, 255, 255, 14, 14, 28, 19, 2, 9, 7, 128, 15,
  192, 15, 192, 15, 192, 31, 224, 31, 224, 60, 240, 60, 240, 56, 112, 120,
  120, 120, 120, 112, 60, 240, 60, 240, 60, 18, 2, 6, 18, 0, 250, 255,
  255, 192, 255, 255, 192, 5, 5, 5, 11, 2, 20, 224, 240, 112, 120, 56,
  15, 18, 36, 18, 1, 0, 15, 240, 63, 252, 127, 252, 124, 62, 248, 30,
  248, 30, 0, 254, 15, 254, 63, 254, 127, 30, 248, 30, 248, 30, 240, 62,
  248, 126, 255, 254, 255, 254, 127, 222, 63, 30, 16, 25, 50, 20, 2, 0,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 243, 240,
  247, 252, 255, 252, 255, 254, 252, 62, 248, 31, 240, 31, 240, 15, 240, 15,
  240, 15, 240, 15, 240, 31, 240, 31, 248, 62, 255, 254, 255, 252, 247, 248,
  241, 240, 15, 18, 36, 18, 1, 0, 7, 224, 31, 248, 63, 252, 63, 252,
  124, 62, 120, 62, 240, 30, 240, 0, 240, 0, 240, 0, 240, 0, 240, 30,
  248, 30, 124, 62, 127, 252, 63, 248, 31, 248, 7, 224, 16, 25, 50, 20,
  1, 0, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  15, 207, 31, 239, 63, 255, 127, 255, 124, 63, 248, 31, 240, 15, 240, 15,
  240, 15, 240, 15, 240, 15, 240, 15, 248, 31, 124, 63, 127, 255, 63, 239,
  31, 239, 15, 143, 16, 18, 36, 18, 1, 0, 7, 224, 31, 248, 63, 252,
  127, 254, 124, 62, 248, 31, 240, 31, 255, 255, 255, 255, 255, 255, 240, 0,
  240, 0, 248, 30, 124, 62, 127, 252, 63, 252, 31, 240, 7, 192, 10, 25,
  50, 11, 0, 0, 7, 192, 15, 192, 31, 192, 31, 0, 30, 0, 30, 0,
  30, 0, 255, 192, 255, 192, 255, 192, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 16, 25, 50, 20, 1, 249, 15, 207, 31, 239,
  63, 255, 127, 255, 124, 63, 248, 31, 248, 31, 240, 15, 240, 15, 240, 15,
  240, 15, 248, 31, 248, 31, 124, 63, 127, 255, 63, 255, 31, 239, 15, 207,
  0, 15, 248, 31, 248, 31, 126, 126, 127, 254, 63, 252, 15, 240, 15, 25,
  50, 20, 2, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0,
  240, 0, 241, 224, 247, 248, 255, 252, 255, 252, 252, 62, 248, 30, 248, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 4, 25, 25, 9, 2, 0, 240, 240, 240, 240,
  0, 0, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 6, 32, 32, 9, 0, 249, 60, 60, 60, 60, 0,
  0, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
  60, 60, 60, 60, 60, 60, 60, 252, 252, 248, 248, 15, 25, 50, 19, 2,
  0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  62, 240, 124, 240, 248, 241, 240, 243, 224, 247, 192, 255, 128, 255, 192, 255,
  192, 255, 224, 255, 224, 249, 240, 241, 240, 240, 248, 240, 120, 240, 124, 240,
  62, 240, 62, 4, 25, 25, 9, 2, 0, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 24, 18, 54, 30, 2, 0, 241, 224, 248, 247, 251, 254, 255, 255,
  254, 255, 255, 255, 252, 127, 31, 248, 62, 15, 240, 60, 15, 240, 60, 15,
  240, 60, 15, 240, 60, 15, 240, 60, 15, 240, 60, 15, 240, 60, 15, 240,
  60, 15, 240, 60, 15, 240, 60, 15, 240, 60, 15, 240, 60, 15, 15, 18,
  36, 20, 2, 0, 241, 240, 247, 252, 255, 252, 255, 254, 252, 62, 248, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 17, 18, 54, 20, 1, 0, 7, 240,
  0, 31, 252, 0, 63, 254, 0, 127, 255, 0, 124, 31, 0, 248, 15, 128,
  248, 15, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 248,
  15, 128, 248, 15, 128, 124, 31, 0, 127, 255, 0, 63, 254, 0, 31, 252,
  0, 7, 240, 0, 16, 25, 50, 20, 2, 249, 241, 240, 247, 248, 255, 252,
  255, 254, 252, 62, 248, 31, 248, 31, 240, 15, 240, 15, 240, 15, 240, 15,
  248, 31, 248, 31, 252, 62, 255, 254, 255, 252, 247, 248, 241, 240, 240, 0,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 16, 25, 50, 20,
  1, 249, 7, 207, 31, 239, 63, 255, 127, 255, 124, 63, 248, 31, 240, 15,
  240, 15, 240, 15, 240, 15, 240, 15, 240, 15, 248, 31, 124, 63, 127, 255,
  63, 255, 63, 239, 15, 207, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 10, 18, 36, 13, 2, 0, 240, 192, 243, 192, 247, 192,
  255, 192, 255, 192, 252, 0, 248, 0, 248, 0, 240, 0, 240, 0, 240, 0,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 16, 18,
  36, 19, 1, 0, 7, 240, 31, 252, 63, 254, 124, 62, 120, 31, 120, 31,
  124, 0, 127, 192, 63, 248, 15, 254, 3, 255, 0, 63, 248, 15, 248, 15,
  124, 31, 127, 254, 63, 252, 15, 240, 9, 22, 44, 11, 1, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 255, 128, 255, 128, 255, 128, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 63, 128, 63, 128, 31, 128, 15, 128, 15, 18, 36, 20, 2, 0,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 248, 62, 248, 126, 255, 254, 127, 254,
  127, 222, 31, 30, 17, 18, 54, 19, 0, 0, 248, 15, 128, 248, 15, 128,
  124, 31, 0, 124, 31, 0, 60, 30, 0, 60, 30, 0, 62, 62, 0, 30,
  60, 0, 30, 60, 0, 30, 60, 0, 15, 120, 0, 15, 120, 0, 15, 120,
  0, 7, 240, 0, 7, 240, 0, 7, 240, 0, 3, 224, 0, 3, 224, 0,
  25, 18, 72, 26, 0, 0, 248, 62, 15, 128, 248, 62, 15, 128, 120, 62,
  15, 0, 124, 62, 31, 0, 124, 127, 31, 0, 60, 127, 30, 0, 60, 127,
  30, 0, 60, 119, 30, 0, 60, 247, 158, 0, 30, 227, 188, 0, 30, 227,
  188, 0, 30, 227, 188, 0, 31, 227, 252, 0, 15, 193, 248, 0, 15, 193,
  248, 0, 15, 193, 248, 0, 7, 128, 240, 0, 7, 128, 240, 0, 16, 18,
  36, 19, 1, 0, 248, 31, 252, 63, 124, 62, 62, 124, 62, 120, 31, 248,
  15, 240, 7, 224, 3, 192, 7, 224, 15, 224, 15, 240, 31, 248, 62, 120,
  62, 124, 124, 62, 252, 63, 248, 31, 16, 25, 50, 19, 1, 249, 248, 31,
  248, 31, 248, 30, 120, 62, 124, 62, 124, 60, 60, 60, 62, 124, 62, 120,
  30, 120, 30, 120, 31, 240, 15, 240, 15, 240, 15, 224, 7, 224, 7, 224,
  7, 192, 7, 192, 7, 192, 15, 128, 63, 128, 63, 0, 63, 0, 60, 0,
  14, 18, 36, 17, 1, 0, 255, 252, 255, 252, 255, 252, 255, 252, 0, 248,
  1, 240, 3, 240, 7, 224, 15, 192, 31, 128, 31, 0, 62, 0, 124, 0,
  248, 0, 255, 252, 255, 252, 255, 252, 255, 252, 9, 32, 64, 13, 2, 249,
  15, 128, 31, 128, 63, 128, 62, 0, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 124, 0, 120, 0,
  224, 0, 120, 0, 124, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 63, 128, 31, 128, 15, 128,
  3, 31, 31, 9, 3, 250, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 9, 32, 64, 13, 2, 249, 248, 0, 252, 0, 254,
  0, 62, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 31, 0, 15, 0, 3, 128, 15, 0, 31,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 254, 0, 252, 0, 248, 0, 14, 6, 12, 19, 2,
  5, 56, 0, 126, 12, 255, 156, 231, 252, 193, 248, 0, 112, 255
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--11-80-100-100-P-56-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 8, '1' Height: 8
  Calculated Max Values w=10 h=11 x= 1 y= 7 dx=11 dy= 0 ascent=11 len=18
  Font Bounding box     w=13 h=18 x=-2 y=-4
  Calculated Min Values           x=-1 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 8 descent=-2
  X Font      ascent = 8 descent=-2
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_helvR08[2687] U8G_FONT_SECTION("u8g_font_helvR08") = {
  0, 13, 18, 254, 252, 8, 1, 178, 3, 111, 32, 255, 254, 11, 254, 8,
  254, 0, 0, 0, 3, 0, 1, 1, 8, 8, 3, 1, 0, 128, 128, 128,
  128, 128, 128, 0, 128, 3, 2, 2, 4, 1, 6, 160, 160, 6, 7, 7,
  6, 0, 0, 40, 40, 124, 40, 248, 80, 80, 5, 10, 10, 6, 0, 255,
  32, 112, 168, 160, 112, 40, 40, 168, 112, 32, 8, 8, 8, 9, 0, 0,
  100, 148, 104, 8, 16, 22, 41, 38, 6, 8, 8, 8, 1, 0, 96, 144,
  144, 96, 148, 136, 152, 100, 1, 2, 2, 2, 0, 6, 128, 128, 3, 10,
  10, 4, 0, 254, 32, 64, 64, 128, 128, 128, 128, 64, 64, 32, 3, 10,
  10, 4, 1, 254, 128, 64, 64, 32, 32, 32, 32, 64, 64, 128, 3, 3,
  3, 4, 0, 5, 160, 64, 160, 5, 5, 5, 6, 0, 1, 32, 32, 248,
  32, 32, 2, 3, 3, 3, 0, 254, 64, 64, 128, 3, 1, 1, 4, 0,
  3, 224, 1, 1, 1, 3, 1, 0, 128, 3, 8, 8, 3, 0, 0, 32,
  32, 64, 64, 64, 64, 128, 128, 5, 8, 8, 6, 0, 0, 112, 136, 136,
  136, 136, 136, 136, 112, 2, 8, 8, 6, 1, 0, 64, 192, 64, 64, 64,
  64, 64, 64, 5, 8, 8, 6, 0, 0, 112, 136, 8, 8, 48, 64, 128,
  248, 5, 8, 8, 6, 0, 0, 112, 136, 8, 48, 8, 8, 136, 112, 5,
  8, 8, 6, 0, 0, 16, 48, 80, 80, 144, 248, 16, 16, 5, 8, 8,
  6, 0, 0, 120, 64, 64, 112, 8, 8, 136, 112, 5, 8, 8, 6, 0,
  0, 112, 136, 128, 240, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 248,
  8, 16, 32, 32, 64, 64, 64, 5, 8, 8, 6, 0, 0, 112, 136, 136,
  112, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 112, 136, 136, 136, 120,
  8, 136, 112, 1, 6, 6, 3, 1, 0, 128, 0, 0, 0, 0, 128, 2,
  8, 8, 3, 0, 254, 64, 0, 0, 0, 0, 64, 64, 128, 3, 5, 5,
  6, 1, 1, 32, 64, 128, 64, 32, 4, 3, 3, 5, 0, 2, 240, 0,
  240, 3, 5, 5, 6, 1, 1, 128, 64, 32, 64, 128, 4, 8, 8, 6,
  1, 0, 96, 144, 16, 32, 64, 64, 0, 64, 10, 9, 18, 11, 0, 255,
  31, 0, 32, 128, 77, 64, 146, 64, 162, 64, 164, 128, 155, 0, 64, 0,
  62, 0, 7, 8, 8, 7, 0, 0, 16, 16, 40, 40, 68, 124, 130, 130,
  5, 8, 8, 7, 1, 0, 240, 136, 136, 240, 136, 136, 136, 240, 6, 8,
  8, 8, 1, 0, 120, 132, 128, 128, 128, 128, 132, 120, 6, 8, 8, 8,
  1, 0, 240, 136, 132, 132, 132, 132, 136, 240, 5, 8, 8, 7, 1, 0,
  248, 128, 128, 248, 128, 128, 128, 248, 5, 8, 8, 6, 1, 0, 248, 128,
  128, 240, 128, 128, 128, 128, 6, 8, 8, 8, 1, 0, 120, 132, 128, 128,
  140, 132, 132, 124, 6, 8, 8, 8, 1, 0, 132, 132, 132, 252, 132, 132,
  132, 132, 1, 8, 8, 3, 1, 0, 128, 128, 128, 128, 128, 128, 128, 128,
  4, 8, 8, 5, 0, 0, 16, 16, 16, 16, 16, 16, 144, 96, 5, 8,
  8, 7, 1, 0, 136, 144, 160, 224, 144, 144, 136, 136, 4, 8, 8, 6,
  1, 0, 128, 128, 128, 128, 128, 128, 128, 240, 7, 8, 8, 9, 1, 0,
  130, 198, 198, 170, 170, 146, 146, 146, 6, 8, 8, 8, 1, 0, 196, 196,
  164, 164, 148, 148, 140, 140, 6, 8, 8, 8, 1, 0, 120, 132, 132, 132,
  132, 132, 132, 120, 5, 8, 8, 7, 1, 0, 240, 136, 136, 240, 128, 128,
  128, 128, 7, 9, 9, 8, 1, 255, 120, 132, 132, 132, 132, 148, 140, 124,
  2, 5, 8, 8, 7, 1, 0, 240, 136, 136, 240, 136, 136, 136, 136, 5,
  8, 8, 7, 1, 0, 112, 136, 128, 112, 8, 136, 136, 112, 5, 8, 8,
  5, 0, 0, 248, 32, 32, 32, 32, 32, 32, 32, 6, 8, 8, 8, 1,
  0, 132, 132, 132, 132, 132, 132, 132, 120, 7, 8, 8, 7, 0, 0, 130,
  130, 68, 68, 68, 40, 40, 16, 9, 8, 16, 9, 0, 0, 136, 128, 136,
  128, 73, 0, 73, 0, 85, 0, 34, 0, 34, 0, 34, 0, 5, 8, 8,
  7, 1, 0, 136, 136, 80, 32, 80, 80, 136, 136, 7, 8, 8, 7, 0,
  0, 130, 68, 68, 40, 40, 16, 16, 16, 5, 8, 8, 7, 1, 0, 248,
  8, 16, 32, 32, 64, 128, 248, 2, 10, 10, 3, 1, 254, 192, 128, 128,
  128, 128, 128, 128, 128, 128, 192, 3, 8, 8, 3, 0, 0, 128, 128, 64,
  64, 64, 64, 32, 32, 2, 10, 10, 3, 0, 254, 192, 64, 64, 64, 64,
  64, 64, 64, 64, 192, 5, 5, 5, 6, 0, 3, 32, 32, 80, 80, 136,
  6, 1, 1, 6, 0, 254, 252, 2, 2, 2, 3, 0, 7, 128, 64, 5,
  6, 6, 5, 0, 0, 224, 16, 112, 144, 144, 104, 5, 8, 8, 6, 0,
  0, 128, 128, 176, 200, 136, 136, 200, 176, 4, 6, 6, 5, 0, 0, 96,
  144, 128, 128, 144, 96, 5, 8, 8, 6, 0, 0, 8, 8, 104, 152, 136,
  136, 152, 104, 4, 6, 6, 5, 0, 0, 96, 144, 240, 128, 144, 96, 4,
  8, 8, 4, 0, 0, 48, 64, 224, 64, 64, 64, 64, 64, 5, 8, 8,
  6, 0, 254, 104, 152, 136, 136, 152, 104, 8, 112, 5, 8, 8, 6, 0,
  0, 128, 128, 176, 200, 136, 136, 136, 136, 1, 8, 8, 2, 0, 0, 128,
  0, 128, 128, 128, 128, 128, 128, 2, 10, 10, 2, 255, 254, 64, 0, 64,
  64, 64, 64, 64, 64, 64, 128, 4, 8, 8, 5, 0, 0, 128, 128, 144,
  160, 192, 160, 144, 144, 1, 8, 8, 2, 0, 0, 128, 128, 128, 128, 128,
  128, 128, 128, 7, 6, 6, 8, 0, 0, 236, 146, 146, 146, 146, 146, 5,
  6, 6, 6, 0, 0, 176, 200, 136, 136, 136, 136, 5, 6, 6, 6, 0,
  0, 112, 136, 136, 136, 136, 112, 5, 8, 8, 6, 0, 254, 176, 200, 136,
  136, 200, 176, 128, 128, 5, 8, 8, 6, 0, 254, 104, 152, 136, 136, 152,
  104, 8, 8, 3, 6, 6, 4, 0, 0, 160, 192, 128, 128, 128, 128, 4,
  6, 6, 5, 0, 0, 96, 144, 96, 16, 144, 96, 3, 8, 8, 4, 0,
  0, 64, 64, 224, 64, 64, 64, 64, 96, 4, 6, 6, 5, 0, 0, 144,
  144, 144, 144, 144, 112, 5, 6, 6, 6, 0, 0, 136, 136, 80, 80, 32,
  32, 7, 6, 6, 8, 0, 0, 146, 146, 84, 84, 40, 40, 5, 6, 6,
  6, 0, 0, 136, 80, 32, 80, 136, 136, 5, 8, 8, 5, 255, 254, 72,
  72, 80, 80, 48, 32, 32, 192, 4, 6, 6, 5, 0, 0, 240, 16, 32,
  64, 128, 240, 3, 10, 10, 3, 0, 254, 32, 64, 64, 64, 128, 64, 64,
  64, 64, 32, 1, 10, 10, 3, 1, 254, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 3, 10, 10, 3, 0, 254, 128, 64, 64, 64, 32, 64, 64,
  64, 64, 128, 6, 2, 2, 7, 0, 3, 100, 152, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 3,
  0, 1, 1, 8, 8, 3, 1, 254, 128, 0, 128, 128, 128, 128, 128, 128,
  5, 8, 8, 6, 1, 255, 16, 112, 168, 160, 160, 168, 112, 64, 5, 8,
  8, 6, 0, 0, 48, 72, 64, 224, 64, 64, 72, 176, 4, 6, 6, 5,
  0, 1, 144, 96, 144, 144, 96, 144, 5, 8, 8, 6, 0, 0, 136, 136,
  136, 80, 248, 32, 248, 32, 1, 10, 10, 3, 1, 254, 128, 128, 128, 128,
  0, 0, 128, 128, 128, 128, 5, 10, 10, 6, 0, 254, 112, 136, 192, 112,
  152, 200, 112, 24, 136, 112, 3, 1, 1, 3, 0, 7, 160, 7, 7, 7,
  9, 1, 0, 56, 68, 154, 162, 154, 68, 56, 3, 5, 5, 4, 0, 3,
  224, 32, 160, 0, 224, 5, 5, 5, 6, 0, 0, 40, 80, 160, 80, 40,
  5, 3, 3, 7, 1, 2, 248, 8, 8, 3, 1, 1, 4, 0, 3, 224,
  7, 7, 7, 9, 1, 0, 56, 68, 186, 178, 170, 68, 56, 3, 1, 1,
  3, 0, 7, 224, 4, 4, 4, 4, 0, 4, 96, 144, 144, 96, 5, 7,
  7, 6, 0, 0, 32, 32, 248, 32, 32, 0, 248, 3, 4, 4, 3, 0,
  4, 96, 160, 64, 224, 3, 4, 4, 3, 0, 4, 224, 64, 32, 192, 2,
  2, 2, 3, 0, 7, 64, 128, 4, 8, 8, 5, 0, 254, 144, 144, 144,
  144, 144, 240, 128, 128, 6, 10, 10, 6, 0, 254, 124, 232, 232, 232, 104,
  40, 40, 40, 40, 40, 2, 1, 1, 3, 0, 3, 192, 2, 2, 2, 3,
  0, 254, 64, 192, 2, 4, 4, 3, 0, 4, 64, 192, 64, 64, 3, 5,
  5, 4, 0, 3, 224, 160, 224, 0, 224, 5, 5, 5, 6, 0, 0, 160,
  80, 40, 80, 160, 9, 8, 16, 9, 0, 0, 68, 0, 196, 0, 72, 0,
  72, 0, 17, 0, 19, 0, 39, 128, 33, 0, 8, 8, 8, 9, 0, 0,
  68, 196, 72, 72, 19, 21, 34, 39, 9, 8, 16, 9, 0, 0, 224, 0,
  68, 0, 36, 0, 200, 0, 9, 0, 19, 0, 23, 128, 33, 0, 4, 8,
  8, 6, 1, 254, 32, 0, 32, 32, 64, 128, 144, 96, 7, 11, 11, 7,
  0, 0, 32, 16, 0, 16, 16, 40, 40, 68, 124, 130, 130, 7, 11, 11,
  7, 0, 0, 8, 16, 0, 16, 16, 40, 40, 68, 124, 130, 130, 7, 11,
  11, 7, 0, 0, 16, 40, 0, 16, 16, 40, 40, 68, 124, 130, 130, 7,
  11, 11, 7, 0, 0, 20, 40, 0, 16, 16, 40, 40, 68, 124, 130, 130,
  7, 10, 10, 7, 0, 0, 40, 0, 16, 16, 40, 40, 68, 124, 130, 130,
  7, 11, 11, 7, 0, 0, 16, 40, 16, 16, 16, 40, 40, 68, 124, 130,
  130, 9, 8, 16, 10, 0, 0, 31, 128, 24, 0, 40, 0, 47, 128, 72,
  0, 120, 0, 136, 0, 143, 128, 6, 10, 10, 8, 1, 254, 120, 132, 128,
  128, 128, 128, 132, 120, 16, 48, 5, 11, 11, 7, 1, 0, 64, 32, 0,
  248, 128, 128, 248, 128, 128, 128, 248, 5, 11, 11, 7, 1, 0, 16, 32,
  0, 248, 128, 128, 248, 128, 128, 128, 248, 5, 11, 11, 7, 1, 0, 32,
  80, 0, 248, 128, 128, 248, 128, 128, 128, 248, 5, 10, 10, 7, 1, 0,
  80, 0, 248, 128, 128, 248, 128, 128, 128, 248, 2, 11, 11, 3, 0, 0,
  128, 64, 0, 64, 64, 64, 64, 64, 64, 64, 64, 2, 11, 11, 3, 1,
  0, 64, 128, 0, 128, 128, 128, 128, 128, 128, 128, 128, 3, 11, 11, 3,
  0, 0, 64, 160, 0, 64, 64, 64, 64, 64, 64, 64, 64, 3, 10, 10,
  3, 0, 0, 160, 0, 64, 64, 64, 64, 64, 64, 64, 64, 7, 8, 8,
  8, 0, 0, 120, 68, 66, 242, 66, 66, 68, 120, 6, 11, 11, 8, 1,
  0, 40, 80, 0, 196, 196, 164, 164, 148, 148, 140, 140, 6, 11, 11, 8,
  1, 0, 32, 16, 0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 11, 11,
  8, 1, 0, 8, 16, 0, 120, 132, 132, 132, 132, 132, 132, 120, 6, 11,
  11, 8, 1, 0, 32, 80, 0, 120, 132, 132, 132, 132, 132, 132, 120, 6,
  11, 11, 8, 1, 0, 40, 80, 0, 120, 132, 132, 132, 132, 132, 132, 120,
  6, 10, 10, 8, 1, 0, 72, 0, 120, 132, 132, 132, 132, 132, 132, 120,
  5, 5, 5, 6, 0, 1, 136, 80, 32, 80, 136, 6, 10, 10, 8, 1,
  255, 4, 120, 140, 148, 148, 164, 164, 196, 120, 128, 6, 11, 11, 8, 1,
  0, 32, 16, 0, 132, 132, 132, 132, 132, 132, 132, 120, 6, 11, 11, 8,
  1, 0, 8, 16, 0, 132, 132, 132, 132, 132, 132, 132, 120, 6, 11, 11,
  8, 1, 0, 32, 80, 0, 132, 132, 132, 132, 132, 132, 132, 120, 6, 10,
  10, 8, 1, 0, 72, 0, 132, 132, 132, 132, 132, 132, 132, 120, 7, 11,
  11, 7, 0, 0, 8, 16, 0, 130, 68, 68, 40, 40, 16, 16, 16, 5,
  8, 8, 7, 1, 0, 128, 128, 240, 136, 136, 240, 128, 128, 4, 8, 8,
  5, 0, 0, 96, 144, 144, 160, 144, 144, 144, 160, 5, 9, 9, 5, 0,
  0, 64, 32, 0, 224, 16, 112, 144, 144, 104, 5, 9, 9, 5, 0, 0,
  32, 64, 0, 224, 16, 112, 144, 144, 104, 5, 9, 9, 5, 0, 0, 32,
  80, 0, 224, 16, 112, 144, 144, 104, 5, 9, 9, 5, 0, 0, 80, 160,
  0, 224, 16, 112, 144, 144, 104, 5, 8, 8, 5, 0, 0, 80, 0, 224,
  16, 112, 144, 144, 104, 5, 9, 9, 5, 0, 0, 32, 80, 32, 224, 16,
  112, 144, 144, 104, 7, 6, 6, 8, 0, 0, 236, 18, 126, 144, 146, 108,
  4, 8, 8, 5, 0, 254, 96, 144, 128, 128, 144, 96, 32, 96, 4, 9,
  9, 5, 0, 0, 64, 32, 0, 96, 144, 240, 128, 144, 96, 4, 9, 9,
  5, 0, 0, 32, 64, 0, 96, 144, 240, 128, 144, 96, 4, 9, 9, 5,
  0, 0, 64, 160, 0, 96, 144, 240, 128, 144, 96, 4, 8, 8, 5, 0,
  0, 160, 0, 96, 144, 240, 128, 144, 96, 2, 9, 9, 2, 255, 0, 128,
  64, 0, 64, 64, 64, 64, 64, 64, 2, 9, 9, 2, 0, 0, 64, 128,
  0, 128, 128, 128, 128, 128, 128, 3, 9, 9, 2, 255, 0, 64, 160, 0,
  64, 64, 64, 64, 64, 64, 3, 8, 8, 2, 255, 0, 160, 0, 64, 64,
  64, 64, 64, 64, 5, 9, 9, 6, 0, 0, 64, 120, 144, 120, 136, 136,
  136, 136, 112, 4, 9, 9, 5, 0, 0, 80, 160, 0, 224, 144, 144, 144,
  144, 144, 5, 9, 9, 6, 0, 0, 64, 32, 0, 112, 136, 136, 136, 136,
  112, 5, 9, 9, 6, 0, 0, 16, 32, 0, 112, 136, 136, 136, 136, 112,
  5, 9, 9, 6, 0, 0, 32, 80, 0, 112, 136, 136, 136, 136, 112, 5,
  9, 9, 6, 0, 0, 40, 80, 0, 112, 136, 136, 136, 136, 112, 5, 8,
  8, 6, 0, 0, 80, 0, 112, 136, 136, 136, 136, 112, 5, 5, 5, 6,
  0, 1, 32, 0, 248, 0, 32, 7, 6, 6, 6, 255, 0, 58, 76, 84,
  100, 68, 184, 4, 9, 9, 5, 0, 0, 64, 32, 0, 144, 144, 144, 144,
  144, 112, 4, 9, 9, 5, 0, 0, 16, 32, 0, 144, 144, 144, 144, 144,
  112, 4, 9, 9, 5, 0, 0, 64, 160, 0, 144, 144, 144, 144, 144, 112,
  4, 8, 8, 5, 0, 0, 160, 0, 144, 144, 144, 144, 144, 112, 5, 11,
  11, 5, 255, 254, 8, 16, 0, 72, 72, 80, 80, 48, 32, 32, 192, 5,
  10, 10, 6, 0, 254, 128, 128, 176, 200, 136, 136, 200, 176, 128, 128, 5,
  10, 10, 5, 255, 254, 80, 0, 72, 72, 80, 80, 48, 32, 32, 192
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--11-80-100-100-P-56-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 0, '1' Height: 8
  Calculated Max Values w= 5 h= 8 x= 1 y= 5 dx= 6 dy= 0 ascent= 8 len= 8
  Font Bounding box     w=13 h=18 x=-2 y=-4
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 8 descent= 0
  X Font      ascent = 8 descent= 0
  Max Font    ascent = 8 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_helvR08n[226] U8G_FONT_SECTION("u8g_font_helvR08n") = {
  0, 13, 18, 254, 252, 8, 0, 0, 0, 0, 42, 58, 0, 8, 254, 8,
  0, 3, 3, 3, 4, 0, 5, 160, 64, 160, 5, 5, 5, 6, 0, 1,
  32, 32, 248, 32, 32, 2, 3, 3, 3, 0, 254, 64, 64, 128, 3, 1,
  1, 4, 0, 3, 224, 1, 1, 1, 3, 1, 0, 128, 3, 8, 8, 3,
  0, 0, 32, 32, 64, 64, 64, 64, 128, 128, 5, 8, 8, 6, 0, 0,
  112, 136, 136, 136, 136, 136, 136, 112, 2, 8, 8, 6, 1, 0, 64, 192,
  64, 64, 64, 64, 64, 64, 5, 8, 8, 6, 0, 0, 112, 136, 8, 8,
  48, 64, 128, 248, 5, 8, 8, 6, 0, 0, 112, 136, 8, 48, 8, 8,
  136, 112, 5, 8, 8, 6, 0, 0, 16, 48, 80, 80, 144, 248, 16, 16,
  5, 8, 8, 6, 0, 0, 120, 64, 64, 112, 8, 8, 136, 112, 5, 8,
  8, 6, 0, 0, 112, 136, 128, 240, 136, 136, 136, 112, 5, 8, 8, 6,
  0, 0, 248, 8, 16, 32, 32, 64, 64, 64, 5, 8, 8, 6, 0, 0,
  112, 136, 136, 112, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 112, 136,
  136, 136, 120, 8, 136, 112, 1, 6, 6, 3, 1, 0, 128, 0, 0, 0,
  0, 128
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--11-80-100-100-P-56-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 8, '1' Height: 8
  Calculated Max Values w=10 h=10 x= 1 y= 7 dx=11 dy= 0 ascent= 9 len=18
  Font Bounding box     w=13 h=18 x=-2 y=-4
  Calculated Min Values           x=-1 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 8 descent=-2
  X Font      ascent = 8 descent=-2
  Max Font    ascent = 9 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_helvR08r[1276] U8G_FONT_SECTION("u8g_font_helvR08r") = {
  0, 13, 18, 254, 252, 8, 1, 178, 3, 111, 32, 127, 254, 9, 254, 8,
  254, 0, 0, 0, 3, 0, 1, 1, 8, 8, 3, 1, 0, 128, 128, 128,
  128, 128, 128, 0, 128, 3, 2, 2, 4, 1, 6, 160, 160, 6, 7, 7,
  6, 0, 0, 40, 40, 124, 40, 248, 80, 80, 5, 10, 10, 6, 0, 255,
  32, 112, 168, 160, 112, 40, 40, 168, 112, 32, 8, 8, 8, 9, 0, 0,
  100, 148, 104, 8, 16, 22, 41, 38, 6, 8, 8, 8, 1, 0, 96, 144,
  144, 96, 148, 136, 152, 100, 1, 2, 2, 2, 0, 6, 128, 128, 3, 10,
  10, 4, 0, 254, 32, 64, 64, 128, 128, 128, 128, 64, 64, 32, 3, 10,
  10, 4, 1, 254, 128, 64, 64, 32, 32, 32, 32, 64, 64, 128, 3, 3,
  3, 4, 0, 5, 160, 64, 160, 5, 5, 5, 6, 0, 1, 32, 32, 248,
  32, 32, 2, 3, 3, 3, 0, 254, 64, 64, 128, 3, 1, 1, 4, 0,
  3, 224, 1, 1, 1, 3, 1, 0, 128, 3, 8, 8, 3, 0, 0, 32,
  32, 64, 64, 64, 64, 128, 128, 5, 8, 8, 6, 0, 0, 112, 136, 136,
  136, 136, 136, 136, 112, 2, 8, 8, 6, 1, 0, 64, 192, 64, 64, 64,
  64, 64, 64, 5, 8, 8, 6, 0, 0, 112, 136, 8, 8, 48, 64, 128,
  248, 5, 8, 8, 6, 0, 0, 112, 136, 8, 48, 8, 8, 136, 112, 5,
  8, 8, 6, 0, 0, 16, 48, 80, 80, 144, 248, 16, 16, 5, 8, 8,
  6, 0, 0, 120, 64, 64, 112, 8, 8, 136, 112, 5, 8, 8, 6, 0,
  0, 112, 136, 128, 240, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 248,
  8, 16, 32, 32, 64, 64, 64, 5, 8, 8, 6, 0, 0, 112, 136, 136,
  112, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 112, 136, 136, 136, 120,
  8, 136, 112, 1, 6, 6, 3, 1, 0, 128, 0, 0, 0, 0, 128, 2,
  8, 8, 3, 0, 254, 64, 0, 0, 0, 0, 64, 64, 128, 3, 5, 5,
  6, 1, 1, 32, 64, 128, 64, 32, 4, 3, 3, 5, 0, 2, 240, 0,
  240, 3, 5, 5, 6, 1, 1, 128, 64, 32, 64, 128, 4, 8, 8, 6,
  1, 0, 96, 144, 16, 32, 64, 64, 0, 64, 10, 9, 18, 11, 0, 255,
  31, 0, 32, 128, 77, 64, 146, 64, 162, 64, 164, 128, 155, 0, 64, 0,
  62, 0, 7, 8, 8, 7, 0, 0, 16, 16, 40, 40, 68, 124, 130, 130,
  5, 8, 8, 7, 1, 0, 240, 136, 136, 240, 136, 136, 136, 240, 6, 8,
  8, 8, 1, 0, 120, 132, 128, 128, 128, 128, 132, 120, 6, 8, 8, 8,
  1, 0, 240, 136, 132, 132, 132, 132, 136, 240, 5, 8, 8, 7, 1, 0,
  248, 128, 128, 248, 128, 128, 128, 248, 5, 8, 8, 6, 1, 0, 248, 128,
  128, 240, 128, 128, 128, 128, 6, 8, 8, 8, 1, 0, 120, 132, 128, 128,
  140, 132, 132, 124, 6, 8, 8, 8, 1, 0, 132, 132, 132, 252, 132, 132,
  132, 132, 1, 8, 8, 3, 1, 0, 128, 128, 128, 128, 128, 128, 128, 128,
  4, 8, 8, 5, 0, 0, 16, 16, 16, 16, 16, 16, 144, 96, 5, 8,
  8, 7, 1, 0, 136, 144, 160, 224, 144, 144, 136, 136, 4, 8, 8, 6,
  1, 0, 128, 128, 128, 128, 128, 128, 128, 240, 7, 8, 8, 9, 1, 0,
  130, 198, 198, 170, 170, 146, 146, 146, 6, 8, 8, 8, 1, 0, 196, 196,
  164, 164, 148, 148, 140, 140, 6, 8, 8, 8, 1, 0, 120, 132, 132, 132,
  132, 132, 132, 120, 5, 8, 8, 7, 1, 0, 240, 136, 136, 240, 128, 128,
  128, 128, 7, 9, 9, 8, 1, 255, 120, 132, 132, 132, 132, 148, 140, 124,
  2, 5, 8, 8, 7, 1, 0, 240, 136, 136, 240, 136, 136, 136, 136, 5,
  8, 8, 7, 1, 0, 112, 136, 128, 112, 8, 136, 136, 112, 5, 8, 8,
  5, 0, 0, 248, 32, 32, 32, 32, 32, 32, 32, 6, 8, 8, 8, 1,
  0, 132, 132, 132, 132, 132, 132, 132, 120, 7, 8, 8, 7, 0, 0, 130,
  130, 68, 68, 68, 40, 40, 16, 9, 8, 16, 9, 0, 0, 136, 128, 136,
  128, 73, 0, 73, 0, 85, 0, 34, 0, 34, 0, 34, 0, 5, 8, 8,
  7, 1, 0, 136, 136, 80, 32, 80, 80, 136, 136, 7, 8, 8, 7, 0,
  0, 130, 68, 68, 40, 40, 16, 16, 16, 5, 8, 8, 7, 1, 0, 248,
  8, 16, 32, 32, 64, 128, 248, 2, 10, 10, 3, 1, 254, 192, 128, 128,
  128, 128, 128, 128, 128, 128, 192, 3, 8, 8, 3, 0, 0, 128, 128, 64,
  64, 64, 64, 32, 32, 2, 10, 10, 3, 0, 254, 192, 64, 64, 64, 64,
  64, 64, 64, 64, 192, 5, 5, 5, 6, 0, 3, 32, 32, 80, 80, 136,
  6, 1, 1, 6, 0, 254, 252, 2, 2, 2, 3, 0, 7, 128, 64, 5,
  6, 6, 5, 0, 0, 224, 16, 112, 144, 144, 104, 5, 8, 8, 6, 0,
  0, 128, 128, 176, 200, 136, 136, 200, 176, 4, 6, 6, 5, 0, 0, 96,
  144, 128, 128, 144, 96, 5, 8, 8, 6, 0, 0, 8, 8, 104, 152, 136,
  136, 152, 104, 4, 6, 6, 5, 0, 0, 96, 144, 240, 128, 144, 96, 4,
  8, 8, 4, 0, 0, 48, 64, 224, 64, 64, 64, 64, 64, 5, 8, 8,
  6, 0, 254, 104, 152, 136, 136, 152, 104, 8, 112, 5, 8, 8, 6, 0,
  0, 128, 128, 176, 200, 136, 136, 136, 136, 1, 8, 8, 2, 0, 0, 128,
  0, 128, 128, 128, 128, 128, 128, 2, 10, 10, 2, 255, 254, 64, 0, 64,
  64, 64, 64, 64, 64, 64, 128, 4, 8, 8, 5, 0, 0, 128, 128, 144,
  160, 192, 160, 144, 144, 1, 8, 8, 2, 0, 0, 128, 128, 128, 128, 128,
  128, 128, 128, 7, 6, 6, 8, 0, 0, 236, 146, 146, 146, 146, 146, 5,
  6, 6, 6, 0, 0, 176, 200, 136, 136, 136, 136, 5, 6, 6, 6, 0,
  0, 112, 136, 136, 136, 136, 112, 5, 8, 8, 6, 0, 254, 176, 200, 136,
  136, 200, 176, 128, 128, 5, 8, 8, 6, 0, 254, 104, 152, 136, 136, 152,
  104, 8, 8, 3, 6, 6, 4, 0, 0, 160, 192, 128, 128, 128, 128, 4,
  6, 6, 5, 0, 0, 96, 144, 96, 16, 144, 96, 3, 8, 8, 4, 0,
  0, 64, 64, 224, 64, 64, 64, 64, 96, 4, 6, 6, 5, 0, 0, 144,
  144, 144, 144, 144, 112, 5, 6, 6, 6, 0, 0, 136, 136, 80, 80, 32,
  32, 7, 6, 6, 8, 0, 0, 146, 146, 84, 84, 40, 40, 5, 6, 6,
  6, 0, 0, 136, 80, 32, 80, 136, 136, 5, 8, 8, 5, 255, 254, 72,
  72, 80, 80, 48, 32, 32, 192, 4, 6, 6, 5, 0, 0, 240, 16, 32,
  64, 128, 240, 3, 10, 10, 3, 0, 254, 32, 64, 64, 64, 128, 64, 64,
  64, 64, 32, 1, 10, 10, 3, 1, 254, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 3, 10, 10, 3, 0, 254, 128, 64, 64, 64, 32, 64, 64,
  64, 64, 128, 6, 2, 2, 7, 0, 3, 100, 152, 255
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--14-100-100-100-P-76-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 11, '1' Height: 11
  Calculated Max Values w=13 h=14 x= 2 y= 9 dx=14 dy= 0 ascent=14 len=28
  Font Bounding box     w=17 h=22 x=-2 y=-5
  Calculated Min Values           x=-1 y=-3 dx= 0 dy= 0
  Pure Font   ascent =11 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =14 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_helvR10[3527] U8G_FONT_SECTION("u8g_font_helvR10") = {
  0, 17, 22, 254, 251, 11, 2, 10, 4, 133, 32, 255, 253, 14, 253, 11,
  253, 0, 0, 0, 4, 0, 1, 1, 11, 11, 4, 2, 0, 128, 128, 128,
  128, 128, 128, 128, 128, 0, 128, 128, 3, 3, 3, 5, 1, 8, 160, 160,
  160, 7, 10, 10, 8, 0, 0, 20, 20, 20, 126, 40, 40, 252, 80, 80,
  80, 7, 14, 14, 8, 0, 254, 16, 124, 146, 146, 144, 80, 56, 20, 18,
  146, 146, 124, 16, 16, 11, 11, 22, 12, 0, 0, 112, 128, 137, 0, 137,
  0, 114, 0, 2, 0, 4, 0, 8, 0, 9, 192, 18, 32, 18, 32, 33,
  192, 8, 10, 10, 10, 1, 0, 48, 72, 72, 48, 32, 82, 138, 132, 138,
  113, 1, 3, 3, 3, 1, 8, 128, 128, 128, 3, 14, 14, 5, 1, 253,
  32, 64, 64, 128, 128, 128, 128, 128, 128, 128, 128, 64, 64, 32, 3, 14,
  14, 5, 1, 253, 128, 64, 64, 32, 32, 32, 32, 32, 32, 32, 32, 64,
  64, 128, 5, 5, 5, 7, 1, 6, 32, 168, 112, 168, 32, 7, 7, 7,
  9, 1, 1, 16, 16, 16, 254, 16, 16, 16, 2, 4, 4, 3, 0, 254,
  64, 64, 64, 128, 3, 1, 1, 4, 0, 4, 224, 1, 2, 2, 3, 1,
  0, 128, 128, 4, 11, 11, 4, 0, 0, 16, 16, 32, 32, 32, 64, 64,
  64, 128, 128, 128, 6, 11, 11, 8, 1, 0, 120, 132, 132, 132, 132, 132,
  132, 132, 132, 132, 120, 3, 11, 11, 8, 2, 0, 32, 224, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 6, 11, 11, 8, 1, 0, 120, 132, 132, 4,
  8, 16, 32, 64, 128, 128, 252, 6, 11, 11, 8, 1, 0, 120, 132, 132,
  4, 4, 56, 4, 4, 132, 132, 120, 7, 11, 11, 8, 1, 0, 4, 12,
  20, 36, 68, 132, 132, 254, 4, 4, 4, 6, 11, 11, 8, 1, 0, 252,
  128, 128, 128, 248, 4, 4, 4, 132, 132, 120, 6, 11, 11, 8, 1, 0,
  120, 132, 128, 128, 184, 196, 132, 132, 132, 132, 120, 6, 11, 11, 8, 1,
  0, 252, 4, 8, 8, 16, 16, 32, 32, 64, 64, 64, 6, 11, 11, 8,
  1, 0, 120, 132, 132, 132, 132, 120, 132, 132, 132, 132, 120, 6, 11, 11,
  8, 1, 0, 120, 132, 132, 132, 132, 124, 4, 4, 132, 132, 120, 1, 8,
  8, 3, 1, 0, 128, 128, 0, 0, 0, 0, 128, 128, 2, 10, 10, 4,
  0, 254, 64, 64, 0, 0, 0, 0, 64, 64, 64, 128, 6, 5, 5, 8,
  1, 2, 12, 48, 192, 48, 12, 6, 3, 3, 9, 1, 3, 252, 0, 252,
  6, 5, 5, 8, 1, 2, 192, 48, 12, 48, 192, 6, 11, 11, 8, 1,
  0, 48, 204, 132, 132, 4, 8, 16, 32, 0, 32, 32, 11, 12, 24, 13,
  1, 255, 15, 0, 48, 192, 64, 32, 70, 160, 137, 32, 145, 32, 145, 32,
  147, 64, 141, 128, 64, 0, 96, 128, 31, 0, 9, 11, 22, 9, 0, 0,
  8, 0, 28, 0, 20, 0, 20, 0, 34, 0, 34, 0, 65, 0, 127, 0,
  65, 0, 128, 128, 128, 128, 7, 11, 11, 9, 1, 0, 252, 134, 130, 130,
  132, 248, 132, 130, 130, 134, 252, 8, 11, 11, 10, 1, 0, 28, 99, 65,
  128, 128, 128, 128, 128, 65, 99, 28, 8, 11, 11, 10, 1, 0, 248, 134,
  130, 129, 129, 129, 129, 129, 130, 134, 248, 7, 11, 11, 9, 1, 0, 254,
  128, 128, 128, 128, 252, 128, 128, 128, 128, 254, 7, 11, 11, 8, 1, 0,
  254, 128, 128, 128, 128, 252, 128, 128, 128, 128, 128, 9, 11, 22, 11, 1,
  0, 30, 0, 97, 128, 64, 128, 128, 0, 128, 0, 135, 128, 128, 128, 128,
  128, 64, 128, 99, 128, 28, 128, 8, 11, 11, 10, 1, 0, 129, 129, 129,
  129, 129, 255, 129, 129, 129, 129, 129, 1, 11, 11, 4, 2, 0, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 6, 11, 11, 7, 0, 0, 4,
  4, 4, 4, 4, 4, 4, 4, 132, 132, 120, 8, 11, 11, 9, 1, 0,
  130, 132, 136, 144, 160, 224, 144, 136, 132, 130, 129, 6, 11, 11, 8, 2,
  0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 252, 11, 11, 22, 12,
  0, 0, 128, 32, 192, 96, 192, 96, 160, 160, 160, 160, 145, 32, 145, 32,
  138, 32, 138, 32, 132, 32, 132, 32, 8, 11, 11, 10, 1, 0, 193, 161,
  161, 145, 145, 137, 137, 133, 133, 131, 131, 9, 11, 22, 11, 1, 0, 28,
  0, 99, 0, 65, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 65,
  0, 99, 0, 28, 0, 7, 11, 11, 9, 1, 0, 252, 134, 130, 130, 134,
  252, 128, 128, 128, 128, 128, 9, 11, 22, 11, 1, 0, 28, 0, 99, 0,
  65, 0, 128, 128, 128, 128, 128, 128, 136, 128, 132, 128, 67, 0, 99, 0,
  28, 128, 8, 11, 11, 10, 1, 0, 254, 131, 129, 129, 130, 252, 130, 129,
  129, 129, 129, 7, 11, 11, 9, 1, 0, 56, 198, 130, 128, 96, 24, 6,
  2, 130, 198, 56, 9, 11, 22, 9, 0, 0, 255, 128, 8, 0, 8, 0,
  8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0,
  8, 11, 11, 10, 1, 0, 129, 129, 129, 129, 129, 129, 129, 129, 129, 66,
  60, 9, 11, 22, 9, 0, 0, 128, 128, 128, 128, 65, 0, 65, 0, 99,
  0, 34, 0, 34, 0, 20, 0, 20, 0, 8, 0, 8, 0, 13, 11, 22,
  13, 0, 0, 130, 8, 130, 8, 133, 8, 69, 16, 69, 16, 69, 16, 40,
  160, 40, 160, 40, 160, 16, 64, 16, 64, 9, 11, 22, 9, 0, 0, 128,
  128, 65, 0, 34, 0, 20, 0, 8, 0, 8, 0, 20, 0, 34, 0, 65,
  0, 65, 0, 128, 128, 9, 11, 22, 9, 0, 0, 128, 128, 193, 128, 65,
  0, 34, 0, 34, 0, 20, 0, 28, 0, 8, 0, 8, 0, 8, 0, 8,
  0, 7, 11, 11, 9, 1, 0, 254, 2, 4, 8, 24, 16, 32, 96, 64,
  128, 254, 3, 14, 14, 4, 1, 253, 224, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 224, 4, 11, 11, 4, 0, 0, 128, 128, 64, 64,
  64, 32, 32, 32, 16, 16, 16, 3, 14, 14, 4, 0, 253, 224, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 224, 5, 5, 5, 7, 1,
  6, 32, 80, 80, 136, 136, 8, 1, 1, 8, 0, 253, 255, 2, 2, 2,
  5, 1, 9, 128, 64, 7, 8, 8, 8, 1, 0, 120, 204, 4, 124, 196,
  132, 204, 118, 6, 11, 11, 7, 1, 0, 128, 128, 128, 184, 204, 132, 132,
  132, 132, 204, 184, 6, 8, 8, 7, 1, 0, 120, 204, 128, 128, 128, 132,
  204, 120, 6, 11, 11, 8, 1, 0, 4, 4, 4, 116, 204, 132, 132, 132,
  132, 204, 116, 6, 8, 8, 8, 1, 0, 120, 204, 132, 252, 128, 128, 204,
  120, 4, 11, 11, 4, 0, 0, 48, 64, 64, 224, 64, 64, 64, 64, 64,
  64, 64, 6, 11, 11, 8, 1, 253, 116, 204, 132, 132, 132, 132, 204, 116,
  4, 204, 120, 6, 11, 11, 8, 1, 0, 128, 128, 128, 184, 204, 132, 132,
  132, 132, 132, 132, 1, 11, 11, 3, 1, 0, 128, 128, 0, 128, 128, 128,
  128, 128, 128, 128, 128, 3, 14, 14, 3, 255, 253, 32, 32, 0, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 192, 6, 11, 11, 7, 1, 0, 128,
  128, 128, 136, 144, 160, 192, 160, 144, 136, 132, 1, 11, 11, 3, 1, 0,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 9, 8, 16, 11, 1,
  0, 179, 0, 204, 128, 136, 128, 136, 128, 136, 128, 136, 128, 136, 128, 136,
  128, 6, 8, 8, 8, 1, 0, 184, 204, 132, 132, 132, 132, 132, 132, 6,
  8, 8, 8, 1, 0, 120, 204, 132, 132, 132, 132, 204, 120, 6, 11, 11,
  8, 1, 253, 184, 204, 132, 132, 132, 132, 204, 184, 128, 128, 128, 6, 11,
  11, 8, 1, 253, 116, 204, 132, 132, 132, 132, 204, 116, 4, 4, 4, 4,
  8, 8, 5, 1, 0, 176, 192, 128, 128, 128, 128, 128, 128, 5, 8, 8,
  7, 1, 0, 112, 136, 192, 112, 24, 8, 136, 112, 4, 10, 10, 4, 0,
  0, 64, 64, 224, 64, 64, 64, 64, 64, 64, 48, 6, 8, 8, 7, 1,
  0, 132, 132, 132, 132, 132, 132, 204, 116, 7, 8, 8, 7, 0, 0, 130,
  130, 68, 68, 68, 40, 40, 16, 9, 8, 16, 10, 0, 0, 136, 128, 136,
  128, 136, 128, 73, 0, 73, 0, 85, 0, 34, 0, 34, 0, 7, 8, 8,
  7, 0, 0, 198, 68, 40, 16, 16, 40, 68, 198, 7, 11, 11, 7, 0,
  253, 130, 194, 68, 68, 36, 40, 24, 16, 16, 48, 96, 6, 8, 8, 7,
  0, 0, 252, 4, 8, 16, 32, 64, 128, 252, 5, 14, 14, 5, 0, 253,
  24, 32, 32, 32, 32, 64, 128, 64, 32, 32, 32, 32, 32, 24, 1, 14,
  14, 3, 1, 253, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 5, 14, 14, 5, 0, 253, 192, 32, 32, 32, 32, 16, 8, 16,
  32, 32, 32, 32, 32, 192, 6, 3, 3, 8, 1, 3, 100, 180, 152, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  0, 0, 0, 4, 0, 1, 1, 11, 11, 4, 1, 253, 128, 128, 0, 128,
  128, 128, 128, 128, 128, 128, 128, 6, 10, 10, 8, 1, 255, 4, 120, 204,
  144, 144, 160, 164, 204, 120, 128, 7, 11, 11, 8, 0, 0, 56, 68, 64,
  64, 248, 32, 32, 32, 64, 98, 220, 6, 6, 6, 8, 1, 2, 132, 120,
  72, 72, 120, 132, 7, 11, 11, 7, 0, 0, 130, 130, 130, 68, 68, 40,
  254, 16, 254, 16, 16, 1, 14, 14, 3, 1, 253, 128, 128, 128, 128, 128,
  128, 0, 0, 128, 128, 128, 128, 128, 128, 5, 14, 14, 8, 2, 253, 112,
  216, 136, 192, 112, 152, 136, 136, 200, 112, 24, 136, 216, 112, 5, 1, 1,
  5, 0, 9, 216, 10, 11, 22, 12, 1, 0, 30, 0, 97, 128, 92, 128,
  162, 192, 162, 64, 160, 64, 162, 64, 156, 64, 64, 128, 97, 128, 30, 0,
  4, 7, 7, 6, 1, 4, 224, 16, 112, 144, 208, 0, 240, 6, 5, 5,
  8, 1, 2, 36, 72, 144, 72, 36, 7, 4, 4, 9, 1, 2, 254, 2,
  2, 2, 3, 1, 1, 4, 0, 4, 224, 10, 11, 22, 12, 1, 0, 30,
  0, 97, 128, 92, 128, 146, 64, 146, 64, 156, 64, 146, 64, 146, 64, 64,
  128, 97, 128, 30, 0, 4, 1, 1, 4, 0, 9, 240, 4, 4, 4, 6,
  1, 7, 96, 144, 144, 96, 7, 9, 9, 9, 1, 0, 16, 16, 16, 254,
  16, 16, 16, 0, 254, 4, 6, 6, 5, 0, 5, 96, 144, 16, 32, 64,
  240, 4, 6, 6, 5, 0, 5, 96, 144, 32, 16, 144, 96, 2, 2, 2,
  5, 2, 9, 64, 128, 6, 11, 11, 8, 1, 253, 132, 132, 132, 132, 132,
  132, 204, 180, 128, 128, 128, 7, 14, 14, 8, 0, 253, 62, 116, 244, 244,
  244, 116, 52, 20, 20, 20, 20, 20, 20, 20, 2, 1, 1, 4, 1, 4,
  192, 4, 3, 3, 5, 0, 253, 32, 144, 96, 2, 6, 6, 5, 1, 5,
  64, 192, 64, 64, 64, 64, 4, 7, 7, 6, 1, 4, 96, 144, 144, 144,
  96, 0, 240, 6, 5, 5, 8, 1, 2, 144, 72, 36, 72, 144, 10, 11,
  22, 12, 1, 0, 66, 0, 194, 0, 68, 0, 68, 0, 72, 0, 72, 128,
  9, 128, 18, 128, 20, 128, 39, 192, 32, 128, 9, 11, 22, 12, 1, 0,
  66, 0, 194, 0, 68, 0, 68, 0, 72, 0, 75, 0, 20, 128, 16, 128,
  17, 0, 34, 0, 39, 128, 11, 11, 22, 12, 0, 0, 97, 0, 145, 0,
  34, 0, 18, 0, 148, 0, 100, 64, 4, 192, 9, 64, 10, 64, 19, 224,
  16, 64, 6, 11, 11, 8, 1, 253, 16, 16, 0, 16, 32, 64, 128, 132,
  132, 204, 48, 9, 14, 28, 9, 0, 0, 16, 0, 8, 0, 0, 0, 8,
  0, 28, 0, 20, 0, 20, 0, 34, 0, 34, 0, 65, 0, 127, 0, 65,
  0, 128, 128, 128, 128, 9, 14, 28, 9, 0, 0, 4, 0, 8, 0, 0,
  0, 8, 0, 28, 0, 20, 0, 20, 0, 34, 0, 34, 0, 65, 0, 127,
  0, 65, 0, 128, 128, 128, 128, 9, 14, 28, 9, 0, 0, 12, 0, 18,
  0, 0, 0, 8, 0, 28, 0, 20, 0, 20, 0, 34, 0, 34, 0, 65,
  0, 127, 0, 65, 0, 128, 128, 128, 128, 9, 14, 28, 9, 0, 0, 26,
  0, 44, 0, 0, 0, 8, 0, 28, 0, 20, 0, 20, 0, 34, 0, 34,
  0, 65, 0, 127, 0, 65, 0, 128, 128, 128, 128, 9, 13, 26, 9, 0,
  0, 54, 0, 0, 0, 8, 0, 28, 0, 20, 0, 20, 0, 34, 0, 34,
  0, 65, 0, 127, 0, 65, 0, 128, 128, 128, 128, 9, 14, 28, 9, 0,
  0, 12, 0, 18, 0, 18, 0, 12, 0, 12, 0, 20, 0, 20, 0, 34,
  0, 34, 0, 65, 0, 127, 0, 65, 0, 128, 128, 128, 128, 12, 11, 22,
  14, 1, 0, 31, 240, 18, 0, 18, 0, 34, 0, 34, 0, 35, 240, 126,
  0, 66, 0, 66, 0, 130, 0, 131, 240, 8, 14, 14, 10, 1, 253, 28,
  99, 65, 128, 128, 128, 128, 128, 65, 99, 28, 8, 36, 24, 7, 14, 14,
  9, 1, 0, 32, 16, 0, 254, 128, 128, 128, 128, 252, 128, 128, 128, 128,
  254, 7, 14, 14, 9, 1, 0, 8, 16, 0, 254, 128, 128, 128, 128, 252,
  128, 128, 128, 128, 254, 7, 14, 14, 9, 1, 0, 24, 36, 0, 254, 128,
  128, 128, 128, 252, 128, 128, 128, 128, 254, 7, 13, 13, 9, 1, 0, 108,
  0, 254, 128, 128, 128, 128, 252, 128, 128, 128, 128, 254, 2, 14, 14, 4,
  1, 0, 128, 64, 0, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
  2, 14, 14, 4, 2, 0, 64, 128, 0, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 4, 14, 14, 4, 1, 0, 96, 144, 0, 64, 64, 64,
  64, 64, 64, 64, 64, 64, 64, 64, 5, 13, 13, 4, 0, 0, 216, 0,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 9, 11, 22, 10, 0,
  0, 124, 0, 67, 0, 65, 0, 64, 128, 64, 128, 240, 128, 64, 128, 64,
  128, 65, 0, 67, 0, 124, 0, 8, 14, 14, 10, 1, 0, 26, 44, 0,
  193, 161, 161, 145, 145, 137, 137, 133, 133, 131, 131, 9, 14, 28, 11, 1,
  0, 16, 0, 8, 0, 0, 0, 28, 0, 99, 0, 65, 0, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 65, 0, 99, 0, 28, 0, 9, 14, 28,
  11, 1, 0, 4, 0, 8, 0, 0, 0, 28, 0, 99, 0, 65, 0, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 65, 0, 99, 0, 28, 0, 9,
  14, 28, 11, 1, 0, 12, 0, 18, 0, 0, 0, 28, 0, 99, 0, 65,
  0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 65, 0, 99, 0, 28,
  0, 9, 14, 28, 11, 1, 0, 26, 0, 44, 0, 0, 0, 28, 0, 99,
  0, 65, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 65, 0, 99,
  0, 28, 0, 9, 13, 26, 11, 1, 0, 51, 0, 0, 0, 28, 0, 99,
  0, 65, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 65, 0, 99,
  0, 28, 0, 7, 7, 7, 9, 1, 1, 130, 68, 40, 16, 40, 68, 130,
  11, 11, 22, 11, 0, 0, 14, 32, 49, 192, 32, 128, 65, 64, 66, 64,
  68, 64, 72, 64, 80, 64, 32, 128, 113, 128, 142, 0, 8, 14, 14, 10,
  1, 0, 16, 8, 0, 129, 129, 129, 129, 129, 129, 129, 129, 129, 66, 60,
  8, 14, 14, 10, 1, 0, 4, 8, 0, 129, 129, 129, 129, 129, 129, 129,
  129, 129, 66, 60, 8, 14, 14, 10, 1, 0, 24, 36, 0, 129, 129, 129,
  129, 129, 129, 129, 129, 129, 66, 60, 8, 13, 13, 10, 1, 0, 102, 0,
  129, 129, 129, 129, 129, 129, 129, 129, 129, 66, 60, 9, 14, 28, 9, 0,
  0, 4, 0, 8, 0, 0, 0, 128, 128, 193, 128, 65, 0, 34, 0, 34,
  0, 20, 0, 28, 0, 8, 0, 8, 0, 8, 0, 8, 0, 7, 11, 11,
  9, 1, 0, 128, 128, 252, 134, 130, 130, 134, 252, 128, 128, 128, 5, 11,
  11, 7, 1, 0, 112, 136, 136, 136, 176, 144, 136, 136, 136, 136, 176, 7,
  11, 11, 8, 1, 0, 32, 16, 0, 120, 204, 4, 124, 196, 132, 204, 118,
  7, 11, 11, 8, 1, 0, 16, 32, 0, 120, 204, 4, 124, 196, 132, 204,
  118, 7, 11, 11, 8, 1, 0, 48, 72, 0, 120, 204, 4, 124, 196, 132,
  204, 118, 7, 11, 11, 8, 1, 0, 52, 88, 0, 120, 204, 4, 124, 196,
  132, 204, 118, 7, 11, 11, 8, 1, 0, 72, 72, 0, 120, 204, 4, 124,
  196, 132, 204, 118, 7, 12, 12, 8, 1, 0, 48, 72, 48, 0, 120, 204,
  4, 124, 196, 132, 204, 118, 11, 8, 16, 13, 1, 0, 123, 192, 198, 96,
  4, 32, 127, 224, 196, 0, 132, 0, 206, 96, 123, 192, 6, 11, 11, 8,
  1, 253, 120, 204, 128, 128, 128, 132, 204, 120, 16, 72, 48, 6, 11, 11,
  8, 1, 0, 32, 16, 0, 120, 204, 132, 252, 128, 128, 204, 120, 6, 11,
  11, 8, 1, 0, 16, 32, 0, 120, 204, 132, 252, 128, 128, 204, 120, 6,
  11, 11, 8, 1, 0, 48, 72, 0, 120, 204, 132, 252, 128, 128, 204, 120,
  6, 11, 11, 8, 1, 0, 72, 72, 0, 120, 204, 132, 252, 128, 128, 204,
  120, 2, 11, 11, 3, 1, 0, 128, 64, 0, 128, 128, 128, 128, 128, 128,
  128, 128, 2, 11, 11, 3, 1, 0, 64, 128, 0, 128, 128, 128, 128, 128,
  128, 128, 128, 4, 11, 11, 3, 0, 0, 96, 144, 0, 64, 64, 64, 64,
  64, 64, 64, 64, 3, 11, 11, 3, 0, 0, 160, 160, 0, 64, 64, 64,
  64, 64, 64, 64, 64, 6, 11, 11, 8, 1, 0, 216, 112, 144, 120, 204,
  132, 132, 132, 132, 204, 120, 6, 11, 11, 8, 1, 0, 104, 176, 0, 184,
  204, 132, 132, 132, 132, 132, 132, 6, 11, 11, 8, 1, 0, 32, 16, 0,
  120, 204, 132, 132, 132, 132, 204, 120, 6, 11, 11, 8, 1, 0, 16, 32,
  0, 120, 204, 132, 132, 132, 132, 204, 120, 6, 11, 11, 8, 1, 0, 48,
  72, 0, 120, 204, 132, 132, 132, 132, 204, 120, 6, 11, 11, 8, 1, 0,
  104, 176, 0, 120, 204, 132, 132, 132, 132, 204, 120, 6, 11, 11, 8, 1,
  0, 72, 72, 0, 120, 204, 132, 132, 132, 132, 204, 120, 7, 7, 7, 9,
  1, 1, 16, 16, 0, 254, 0, 16, 16, 8, 8, 8, 8, 0, 0, 61,
  98, 70, 74, 82, 98, 70, 188, 6, 11, 11, 8, 1, 0, 32, 16, 0,
  132, 132, 132, 132, 132, 132, 204, 116, 6, 11, 11, 8, 1, 0, 16, 32,
  0, 132, 132, 132, 132, 132, 132, 204, 116, 6, 11, 11, 8, 1, 0, 48,
  72, 0, 132, 132, 132, 132, 132, 132, 204, 116, 6, 11, 11, 8, 1, 0,
  72, 72, 0, 132, 132, 132, 132, 132, 132, 204, 116, 7, 14, 14, 7, 0,
  253, 8, 16, 0, 130, 194, 68, 68, 36, 40, 24, 16, 16, 48, 96, 6,
  14, 14, 8, 1, 253, 128, 128, 128, 184, 204, 132, 132, 132, 132, 204, 184,
  128, 128, 128, 7, 14, 14, 7, 0, 253, 36, 36, 0, 130, 194, 68, 68,
  36, 40, 24, 16, 16, 48, 96
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--14-100-100-100-P-76-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 0, '1' Height: 11
  Calculated Max Values w= 7 h=11 x= 2 y= 6 dx= 9 dy= 0 ascent=11 len=11
  Font Bounding box     w=17 h=22 x=-2 y=-5
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =11 descent= 0
  X Font      ascent =11 descent= 0
  Max Font    ascent =11 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_helvR10n[267] U8G_FONT_SECTION("u8g_font_helvR10n") = {
  0, 17, 22, 254, 251, 11, 0, 0, 0, 0, 42, 58, 0, 11, 254, 11,
  0, 5, 5, 5, 7, 1, 6, 32, 168, 112, 168, 32, 7, 7, 7, 9,
  1, 1, 16, 16, 16, 254, 16, 16, 16, 2, 4, 4, 3, 0, 254, 64,
  64, 64, 128, 3, 1, 1, 4, 0, 4, 224, 1, 2, 2, 3, 1, 0,
  128, 128, 4, 11, 11, 4, 0, 0, 16, 16, 32, 32, 32, 64, 64, 64,
  128, 128, 128, 6, 11, 11, 8, 1, 0, 120, 132, 132, 132, 132, 132, 132,
  132, 132, 132, 120, 3, 11, 11, 8, 2, 0, 32, 224, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 6, 11, 11, 8, 1, 0, 120, 132, 132, 4, 8,
  16, 32, 64, 128, 128, 252, 6, 11, 11, 8, 1, 0, 120, 132, 132, 4,
  4, 56, 4, 4, 132, 132, 120, 7, 11, 11, 8, 1, 0, 4, 12, 20,
  36, 68, 132, 132, 254, 4, 4, 4, 6, 11, 11, 8, 1, 0, 252, 128,
  128, 128, 248, 4, 4, 4, 132, 132, 120, 6, 11, 11, 8, 1, 0, 120,
  132, 128, 128, 184, 196, 132, 132, 132, 132, 120, 6, 11, 11, 8, 1, 0,
  252, 4, 8, 8, 16, 16, 32, 32, 64, 64, 64, 6, 11, 11, 8, 1,
  0, 120, 132, 132, 132, 132, 120, 132, 132, 132, 132, 120, 6, 11, 11, 8,
  1, 0, 120, 132, 132, 132, 132, 124, 4, 4, 132, 132, 120, 1, 8, 8,
  3, 1, 0, 128, 128, 0, 0, 0, 0, 128, 128
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--14-100-100-100-P-76-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 11, '1' Height: 11
  Calculated Max Values w=13 h=14 x= 2 y= 9 dx=13 dy= 0 ascent=12 len=24
  Font Bounding box     w=17 h=22 x=-2 y=-5
  Calculated Min Values           x=-1 y=-3 dx= 0 dy= 0
  Pure Font   ascent =11 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =12 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_helvR10r[1648] U8G_FONT_SECTION("u8g_font_helvR10r") = {
  0, 17, 22, 254, 251, 11, 2, 10, 4, 133, 32, 127, 253, 12, 253, 11,
  253, 0, 0, 0, 4, 0, 1, 1, 11, 11, 4, 2, 0, 128, 128, 128,
  128, 128, 128, 128, 128, 0, 128, 128, 3, 3, 3, 5, 1, 8, 160, 160,
  160, 7, 10, 10, 8, 0, 0, 20, 20, 20, 126, 40, 40, 252, 80, 80,
  80, 7, 14, 14, 8, 0, 254, 16, 124, 146, 146, 144, 80, 56, 20, 18,
  146, 146, 124, 16, 16, 11, 11, 22, 12, 0, 0, 112, 128, 137, 0, 137,
  0, 114, 0, 2, 0, 4, 0, 8, 0, 9, 192, 18, 32, 18, 32, 33,
  192, 8, 10, 10, 10, 1, 0, 48, 72, 72, 48, 32, 82, 138, 132, 138,
  113, 1, 3, 3, 3, 1, 8, 128, 128, 128, 3, 14, 14, 5, 1, 253,
  32, 64, 64, 128, 128, 128, 128, 128, 128, 128, 128, 64, 64, 32, 3, 14,
  14, 5, 1, 253, 128, 64, 64, 32, 32, 32, 32, 32, 32, 32, 32, 64,
  64, 128, 5, 5, 5, 7, 1, 6, 32, 168, 112, 168, 32, 7, 7, 7,
  9, 1, 1, 16, 16, 16, 254, 16, 16, 16, 2, 4, 4, 3, 0, 254,
  64, 64, 64, 128, 3, 1, 1, 4, 0, 4, 224, 1, 2, 2, 3, 1,
  0, 128, 128, 4, 11, 11, 4, 0, 0, 16, 16, 32, 32, 32, 64, 64,
  64, 128, 128, 128, 6, 11, 11, 8, 1, 0, 120, 132, 132, 132, 132, 132,
  132, 132, 132, 132, 120, 3, 11, 11, 8, 2, 0, 32, 224, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 6, 11, 11, 8, 1, 0, 120, 132, 132, 4,
  8, 16, 32, 64, 128, 128, 252, 6, 11, 11, 8, 1, 0, 120, 132, 132,
  4, 4, 56, 4, 4, 132, 132, 120, 7, 11, 11, 8, 1, 0, 4, 12,
  20, 36, 68, 132, 132, 254, 4, 4, 4, 6, 11, 11, 8, 1, 0, 252,
  128, 128, 128, 248, 4, 4, 4, 132, 132, 120, 6, 11, 11, 8, 1, 0,
  120, 132, 128, 128, 184, 196, 132, 132, 132, 132, 120, 6, 11, 11, 8, 1,
  0, 252, 4, 8, 8, 16, 16, 32, 32, 64, 64, 64, 6, 11, 11, 8,
  1, 0, 120, 132, 132, 132, 132, 120, 132, 132, 132, 132, 120, 6, 11, 11,
  8, 1, 0, 120, 132, 132, 132, 132, 124, 4, 4, 132, 132, 120, 1, 8,
  8, 3, 1, 0, 128, 128, 0, 0, 0, 0, 128, 128, 2, 10, 10, 4,
  0, 254, 64, 64, 0, 0, 0, 0, 64, 64, 64, 128, 6, 5, 5, 8,
  1, 2, 12, 48, 192, 48, 12, 6, 3, 3, 9, 1, 3, 252, 0, 252,
  6, 5, 5, 8, 1, 2, 192, 48, 12, 48, 192, 6, 11, 11, 8, 1,
  0, 48, 204, 132, 132, 4, 8, 16, 32, 0, 32, 32, 11, 12, 24, 13,
  1, 255, 15, 0, 48, 192, 64, 32, 70, 160, 137, 32, 145, 32, 145, 32,
  147, 64, 141, 128, 64, 0, 96, 128, 31, 0, 9, 11, 22, 9, 0, 0,
  8, 0, 28, 0, 20, 0, 20, 0, 34, 0, 34, 0, 65, 0, 127, 0,
  65, 0, 128, 128, 128, 128, 7, 11, 11, 9, 1, 0, 252, 134, 130, 130,
  132, 248, 132, 130, 130, 134, 252, 8, 11, 11, 10, 1, 0, 28, 99, 65,
  128, 128, 128, 128, 128, 65, 99, 28, 8, 11, 11, 10, 1, 0, 248, 134,
  130, 129, 129, 129, 129, 129, 130, 134, 248, 7, 11, 11, 9, 1, 0, 254,
  128, 128, 128, 128, 252, 128, 128, 128, 128, 254, 7, 11, 11, 8, 1, 0,
  254, 128, 128, 128, 128, 252, 128, 128, 128, 128, 128, 9, 11, 22, 11, 1,
  0, 30, 0, 97, 128, 64, 128, 128, 0, 128, 0, 135, 128, 128, 128, 128,
  128, 64, 128, 99, 128, 28, 128, 8, 11, 11, 10, 1, 0, 129, 129, 129,
  129, 129, 255, 129, 129, 129, 129, 129, 1, 11, 11, 4, 2, 0, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 6, 11, 11, 7, 0, 0, 4,
  4, 4, 4, 4, 4, 4, 4, 132, 132, 120, 8, 11, 11, 9, 1, 0,
  130, 132, 136, 144, 160, 224, 144, 136, 132, 130, 129, 6, 11, 11, 8, 2,
  0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 252, 11, 11, 22, 12,
  0, 0, 128, 32, 192, 96, 192, 96, 160, 160, 160, 160, 145, 32, 145, 32,
  138, 32, 138, 32, 132, 32, 132, 32, 8, 11, 11, 10, 1, 0, 193, 161,
  161, 145, 145, 137, 137, 133, 133, 131, 131, 9, 11, 22, 11, 1, 0, 28,
  0, 99, 0, 65, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 65,
  0, 99, 0, 28, 0, 7, 11, 11, 9, 1, 0, 252, 134, 130, 130, 134,
  252, 128, 128, 128, 128, 128, 9, 11, 22, 11, 1, 0, 28, 0, 99, 0,
  65, 0, 128, 128, 128, 128, 128, 128, 136, 128, 132, 128, 67, 0, 99, 0,
  28, 128, 8, 11, 11, 10, 1, 0, 254, 131, 129, 129, 130, 252, 130, 129,
  129, 129, 129, 7, 11, 11, 9, 1, 0, 56, 198, 130, 128, 96, 24, 6,
  2, 130, 198, 56, 9, 11, 22, 9, 0, 0, 255, 128, 8, 0, 8, 0,
  8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0,
  8, 11, 11, 10, 1, 0, 129, 129, 129, 129, 129, 129, 129, 129, 129, 66,
  60, 9, 11, 22, 9, 0, 0, 128, 128, 128, 128, 65, 0, 65, 0, 99,
  0, 34, 0, 34, 0, 20, 0, 20, 0, 8, 0, 8, 0, 13, 11, 22,
  13, 0, 0, 130, 8, 130, 8, 133, 8, 69, 16, 69, 16, 69, 16, 40,
  160, 40, 160, 40, 160, 16, 64, 16, 64, 9, 11, 22, 9, 0, 0, 128,
  128, 65, 0, 34, 0, 20, 0, 8, 0, 8, 0, 20, 0, 34, 0, 65,
  0, 65, 0, 128, 128, 9, 11, 22, 9, 0, 0, 128, 128, 193, 128, 65,
  0, 34, 0, 34, 0, 20, 0, 28, 0, 8, 0, 8, 0, 8, 0, 8,
  0, 7, 11, 11, 9, 1, 0, 254, 2, 4, 8, 24, 16, 32, 96, 64,
  128, 254, 3, 14, 14, 4, 1, 253, 224, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 224, 4, 11, 11, 4, 0, 0, 128, 128, 64, 64,
  64, 32, 32, 32, 16, 16, 16, 3, 14, 14, 4, 0, 253, 224, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 224, 5, 5, 5, 7, 1,
  6, 32, 80, 80, 136, 136, 8, 1, 1, 8, 0, 253, 255, 2, 2, 2,
  5, 1, 9, 128, 64, 7, 8, 8, 8, 1, 0, 120, 204, 4, 124, 196,
  132, 204, 118, 6, 11, 11, 7, 1, 0, 128, 128, 128, 184, 204, 132, 132,
  132, 132, 204, 184, 6, 8, 8, 7, 1, 0, 120, 204, 128, 128, 128, 132,
  204, 120, 6, 11, 11, 8, 1, 0, 4, 4, 4, 116, 204, 132, 132, 132,
  132, 204, 116, 6, 8, 8, 8, 1, 0, 120, 204, 132, 252, 128, 128, 204,
  120, 4, 11, 11, 4, 0, 0, 48, 64, 64, 224, 64, 64, 64, 64, 64,
  64, 64, 6, 11, 11, 8, 1, 253, 116, 204, 132, 132, 132, 132, 204, 116,
  4, 204, 120, 6, 11, 11, 8, 1, 0, 128, 128, 128, 184, 204, 132, 132,
  132, 132, 132, 132, 1, 11, 11, 3, 1, 0, 128, 128, 0, 128, 128, 128,
  128, 128, 128, 128, 128, 3, 14, 14, 3, 255, 253, 32, 32, 0, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 192, 6, 11, 11, 7, 1, 0, 128,
  128, 128, 136, 144, 160, 192, 160, 144, 136, 132, 1, 11, 11, 3, 1, 0,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 9, 8, 16, 11, 1,
  0, 179, 0, 204, 128, 136, 128, 136, 128, 136, 128, 136, 128, 136, 128, 136,
  128, 6, 8, 8, 8, 1, 0, 184, 204, 132, 132, 132, 132, 132, 132, 6,
  8, 8, 8, 1, 0, 120, 204, 132, 132, 132, 132, 204, 120, 6, 11, 11,
  8, 1, 253, 184, 204, 132, 132, 132, 132, 204, 184, 128, 128, 128, 6, 11,
  11, 8, 1, 253, 116, 204, 132, 132, 132, 132, 204, 116, 4, 4, 4, 4,
  8, 8, 5, 1, 0, 176, 192, 128, 128, 128, 128, 128, 128, 5, 8, 8,
  7, 1, 0, 112, 136, 192, 112, 24, 8, 136, 112, 4, 10, 10, 4, 0,
  0, 64, 64, 224, 64, 64, 64, 64, 64, 64, 48, 6, 8, 8, 7, 1,
  0, 132, 132, 132, 132, 132, 132, 204, 116, 7, 8, 8, 7, 0, 0, 130,
  130, 68, 68, 68, 40, 40, 16, 9, 8, 16, 10, 0, 0, 136, 128, 136,
  128, 136, 128, 73, 0, 73, 0, 85, 0, 34, 0, 34, 0, 7, 8, 8,
  7, 0, 0, 198, 68, 40, 16, 16, 40, 68, 198, 7, 11, 11, 7, 0,
  253, 130, 194, 68, 68, 36, 40, 24, 16, 16, 48, 96, 6, 8, 8, 7,
  0, 0, 252, 4, 8, 16, 32, 64, 128, 252, 5, 14, 14, 5, 0, 253,
  24, 32, 32, 32, 32, 64, 128, 64, 32, 32, 32, 32, 32, 24, 1, 14,
  14, 3, 1, 253, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 5, 14, 14, 5, 0, 253, 192, 32, 32, 32, 32, 16, 8, 16,
  32, 32, 32, 32, 32, 192, 6, 3, 3, 8, 1, 3, 100, 180, 152, 255
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--17-120-100-100-P-88-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 12, '1' Height: 12
  Calculated Max Values w=14 h=16 x= 3 y=10 dx=17 dy= 0 ascent=16 len=32
  Font Bounding box     w=20 h=26 x=-2 y=-6
  Calculated Min Values           x=-1 y=-4 dx= 0 dy= 0
  Pure Font   ascent =12 descent=-4
  X Font      ascent =12 descent=-4
  Max Font    ascent =16 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_helvR12[4077] U8G_FONT_SECTION("u8g_font_helvR12") = {
  0, 20, 26, 254, 250, 12, 2, 91, 5, 99, 32, 255, 252, 16, 252, 12,
  252, 0, 0, 0, 5, 0, 1, 1, 12, 12, 5, 2, 0, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 0, 128, 128, 4, 4, 4, 6, 1, 8, 144,
  144, 144, 144, 8, 11, 11, 9, 0, 0, 18, 18, 18, 127, 36, 36, 36,
  254, 72, 72, 72, 7, 15, 15, 9, 1, 254, 16, 124, 146, 146, 144, 80,
  48, 24, 20, 18, 146, 146, 124, 16, 16, 12, 12, 24, 14, 0, 0, 112,
  64, 136, 128, 136, 128, 137, 0, 114, 0, 2, 0, 4, 0, 4, 224, 9,
  16, 17, 16, 17, 16, 32, 224, 10, 12, 24, 11, 0, 0, 24, 0, 36,
  0, 66, 0, 66, 0, 36, 0, 24, 0, 41, 0, 69, 0, 130, 0, 131,
  0, 68, 128, 56, 64, 2, 4, 4, 3, 0, 8, 192, 192, 64, 64, 3,
  16, 16, 6, 1, 252, 32, 64, 64, 64, 128, 128, 128, 128, 128, 128, 128,
  128, 64, 64, 64, 32, 3, 16, 16, 6, 1, 252, 128, 64, 64, 64, 32,
  32, 32, 32, 32, 32, 32, 32, 64, 64, 64, 128, 5, 5, 5, 6, 0,
  7, 32, 168, 112, 80, 136, 9, 9, 18, 10, 0, 0, 8, 0, 8, 0,
  8, 0, 8, 0, 255, 128, 8, 0, 8, 0, 8, 0, 8, 0, 2, 4,
  4, 4, 1, 254, 64, 64, 64, 128, 4, 1, 1, 5, 0, 4, 240, 1,
  2, 2, 4, 2, 0, 128, 128, 4, 12, 12, 5, 0, 0, 16, 16, 32,
  32, 32, 32, 64, 64, 64, 128, 128, 128, 7, 12, 12, 9, 1, 0, 56,
  68, 68, 130, 130, 130, 130, 130, 130, 68, 68, 56, 3, 12, 12, 9, 3,
  0, 32, 32, 96, 160, 32, 32, 32, 32, 32, 32, 32, 32, 7, 12, 12,
  9, 1, 0, 56, 68, 130, 130, 2, 4, 8, 48, 64, 128, 128, 254, 7,
  12, 12, 9, 1, 0, 56, 68, 130, 130, 4, 56, 4, 2, 130, 130, 68,
  56, 8, 12, 12, 9, 0, 0, 12, 20, 20, 36, 36, 68, 68, 132, 255,
  4, 4, 4, 7, 12, 12, 9, 1, 0, 62, 32, 32, 64, 120, 68, 2,
  2, 2, 130, 68, 56, 7, 12, 12, 9, 1, 0, 60, 66, 130, 128, 184,
  196, 130, 130, 130, 130, 68, 56, 8, 12, 12, 9, 0, 0, 255, 1, 2,
  4, 4, 8, 8, 16, 16, 16, 32, 32, 7, 12, 12, 9, 1, 0, 56,
  68, 130, 130, 68, 56, 68, 130, 130, 130, 68, 56, 7, 12, 12, 9, 1,
  0, 56, 68, 130, 130, 130, 130, 70, 58, 2, 130, 132, 120, 1, 9, 9,
  4, 2, 0, 128, 128, 0, 0, 0, 0, 0, 128, 128, 2, 11, 11, 4,
  1, 254, 64, 64, 0, 0, 0, 0, 0, 64, 64, 64, 128, 9, 9, 18,
  10, 0, 0, 1, 128, 6, 0, 24, 0, 96, 0, 128, 0, 96, 0, 24,
  0, 6, 0, 1, 128, 8, 4, 4, 10, 0, 2, 255, 0, 0, 255, 9,
  9, 18, 10, 1, 0, 192, 0, 48, 0, 12, 0, 3, 0, 0, 128, 3,
  0, 12, 0, 48, 0, 192, 0, 7, 12, 12, 9, 1, 0, 56, 68, 130,
  130, 2, 4, 8, 16, 16, 0, 16, 16, 13, 14, 28, 17, 1, 254, 7,
  128, 24, 96, 32, 16, 67, 208, 76, 72, 136, 72, 144, 136, 144, 136, 144,
  144, 153, 144, 78, 96, 64, 0, 48, 96, 15, 128, 10, 12, 24, 11, 0,
  0, 12, 0, 12, 0, 18, 0, 18, 0, 18, 0, 33, 0, 33, 0, 127,
  128, 64, 128, 64, 128, 128, 64, 128, 64, 9, 12, 24, 11, 1, 0, 252,
  0, 130, 0, 129, 0, 129, 0, 130, 0, 254, 0, 129, 0, 128, 128, 128,
  128, 128, 128, 129, 0, 254, 0, 10, 12, 24, 12, 1, 0, 15, 0, 48,
  128, 64, 64, 64, 0, 128, 0, 128, 0, 128, 0, 128, 0, 64, 0, 64,
  64, 48, 128, 15, 0, 10, 12, 24, 12, 1, 0, 252, 0, 131, 0, 128,
  128, 128, 128, 128, 64, 128, 64, 128, 64, 128, 64, 128, 128, 128, 128, 131,
  0, 252, 0, 8, 12, 12, 11, 1, 0, 255, 128, 128, 128, 128, 255, 128,
  128, 128, 128, 128, 255, 7, 12, 12, 10, 1, 0, 254, 128, 128, 128, 128,
  254, 128, 128, 128, 128, 128, 128, 10, 12, 24, 13, 1, 0, 14, 0, 49,
  128, 64, 64, 64, 0, 128, 0, 128, 0, 135, 192, 128, 64, 64, 64, 64,
  192, 49, 64, 14, 64, 9, 12, 24, 12, 1, 0, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 255, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 1, 12, 12, 4, 1, 0, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 6, 12, 12, 8, 0, 0, 4, 4, 4, 4, 4,
  4, 4, 4, 132, 132, 132, 120, 8, 12, 12, 11, 1, 0, 129, 130, 132,
  136, 144, 176, 200, 136, 132, 130, 130, 129, 7, 12, 12, 9, 1, 0, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 254, 11, 12, 24, 13, 1,
  0, 128, 32, 192, 96, 192, 96, 160, 160, 160, 160, 160, 160, 145, 32, 145,
  32, 145, 32, 138, 32, 138, 32, 132, 32, 9, 12, 24, 12, 1, 0, 128,
  128, 192, 128, 160, 128, 160, 128, 144, 128, 136, 128, 136, 128, 132, 128, 130,
  128, 130, 128, 129, 128, 128, 128, 11, 12, 24, 13, 1, 0, 14, 0, 49,
  128, 64, 64, 64, 64, 128, 32, 128, 32, 128, 32, 128, 32, 64, 64, 64,
  64, 49, 128, 14, 0, 8, 12, 12, 11, 2, 0, 252, 130, 129, 129, 130,
  252, 128, 128, 128, 128, 128, 128, 11, 13, 26, 13, 1, 255, 14, 0, 49,
  128, 64, 64, 64, 64, 128, 32, 128, 32, 128, 32, 128, 32, 64, 64, 66,
  64, 49, 128, 14, 128, 0, 64, 9, 12, 24, 12, 2, 0, 252, 0, 130,
  0, 129, 0, 129, 0, 130, 0, 252, 0, 130, 0, 129, 0, 129, 0, 129,
  0, 129, 0, 128, 128, 9, 12, 24, 11, 1, 0, 62, 0, 65, 0, 128,
  128, 128, 128, 64, 0, 48, 0, 14, 0, 1, 0, 128, 128, 128, 128, 65,
  0, 62, 0, 9, 12, 24, 10, 0, 0, 255, 128, 8, 0, 8, 0, 8,
  0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8,
  0, 9, 12, 24, 12, 1, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 65, 0, 62, 0, 10,
  12, 24, 11, 0, 0, 128, 64, 128, 64, 64, 128, 64, 128, 64, 128, 33,
  0, 33, 0, 18, 0, 18, 0, 18, 0, 12, 0, 12, 0, 13, 12, 24,
  15, 1, 0, 130, 8, 130, 8, 130, 8, 69, 16, 69, 16, 69, 16, 40,
  160, 40, 160, 40, 160, 16, 64, 16, 64, 16, 64, 8, 12, 12, 11, 1,
  0, 129, 66, 66, 36, 36, 24, 24, 36, 36, 66, 66, 129, 9, 12, 24,
  11, 1, 0, 128, 128, 65, 0, 65, 0, 34, 0, 34, 0, 20, 0, 28,
  0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 9, 12, 24, 10, 0,
  0, 127, 128, 1, 0, 3, 0, 2, 0, 4, 0, 12, 0, 8, 0, 16,
  0, 48, 0, 32, 0, 64, 0, 255, 128, 3, 15, 15, 5, 1, 253, 224,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 224, 4, 12,
  12, 5, 0, 0, 128, 128, 64, 64, 64, 64, 32, 32, 32, 16, 16, 16,
  3, 15, 15, 5, 0, 253, 224, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 224, 7, 7, 7, 8, 0, 5, 16, 40, 40, 68, 68,
  130, 130, 9, 1, 2, 9, 0, 253, 255, 128, 3, 3, 3, 6, 0, 10,
  128, 192, 32, 8, 9, 9, 9, 1, 0, 124, 130, 2, 6, 122, 130, 130,
  134, 123, 7, 12, 12, 9, 1, 0, 128, 128, 128, 184, 196, 130, 130, 130,
  130, 130, 196, 184, 7, 9, 9, 8, 1, 0, 56, 68, 130, 128, 128, 128,
  130, 68, 56, 7, 12, 12, 9, 1, 0, 2, 2, 2, 58, 70, 130, 130,
  130, 130, 130, 70, 58, 7, 9, 9, 9, 1, 0, 56, 68, 130, 130, 254,
  128, 130, 68, 56, 4, 12, 12, 5, 1, 0, 48, 64, 64, 240, 64, 64,
  64, 64, 64, 64, 64, 64, 7, 13, 13, 9, 1, 252, 58, 70, 130, 130,
  130, 130, 130, 70, 58, 2, 130, 132, 120, 7, 12, 12, 9, 1, 0, 128,
  128, 128, 188, 194, 130, 130, 130, 130, 130, 130, 130, 1, 12, 12, 3, 1,
  0, 128, 128, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 3, 16, 16,
  4, 255, 252, 32, 32, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 192, 7, 12, 12, 8, 0, 0, 128, 128, 128, 132, 136, 144, 160,
  224, 144, 136, 132, 130, 1, 12, 12, 3, 1, 0, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 11, 9, 18, 14, 2, 0, 185, 192, 198,
  32, 132, 32, 132, 32, 132, 32, 132, 32, 132, 32, 132, 32, 132, 32, 7,
  9, 9, 9, 1, 0, 188, 194, 130, 130, 130, 130, 130, 130, 130, 7, 9,
  9, 9, 1, 0, 56, 68, 130, 130, 130, 130, 130, 68, 56, 7, 13, 13,
  9, 1, 252, 184, 196, 130, 130, 130, 130, 130, 196, 184, 128, 128, 128, 128,
  7, 13, 13, 9, 1, 252, 58, 70, 130, 130, 130, 130, 130, 70, 58, 2,
  2, 2, 2, 4, 9, 9, 5, 1, 0, 176, 192, 128, 128, 128, 128, 128,
  128, 128, 6, 9, 9, 8, 1, 0, 120, 132, 132, 192, 48, 12, 132, 132,
  120, 4, 11, 11, 5, 1, 0, 64, 64, 240, 64, 64, 64, 64, 64, 64,
  64, 48, 7, 9, 9, 9, 1, 0, 130, 130, 130, 130, 130, 130, 130, 134,
  122, 7, 9, 9, 8, 0, 0, 130, 130, 68, 68, 68, 40, 40, 56, 16,
  11, 9, 18, 12, 0, 0, 132, 32, 132, 32, 68, 64, 78, 64, 74, 64,
  42, 128, 42, 128, 17, 0, 17, 0, 7, 9, 9, 8, 0, 0, 130, 68,
  68, 40, 16, 40, 68, 68, 130, 7, 12, 12, 8, 0, 253, 130, 130, 68,
  68, 40, 40, 56, 16, 16, 32, 32, 192, 6, 9, 9, 8, 1, 0, 252,
  4, 8, 16, 32, 32, 64, 128, 252, 3, 16, 16, 6, 1, 252, 32, 64,
  64, 64, 64, 64, 64, 128, 64, 64, 64, 64, 64, 64, 64, 32, 1, 16,
  16, 4, 1, 252, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 3, 16, 16, 6, 1, 252, 128, 64, 64, 64, 64, 64,
  64, 32, 64, 64, 64, 64, 64, 64, 64, 128, 8, 2, 2, 10, 1, 4,
  113, 142, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 0, 0, 0, 5, 0, 1, 1, 12, 12, 6, 2, 253, 128,
  128, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 7, 13, 13, 9, 1,
  254, 4, 4, 56, 76, 138, 144, 144, 144, 162, 100, 56, 64, 64, 8, 12,
  12, 9, 0, 0, 14, 17, 33, 32, 32, 16, 126, 8, 16, 32, 121, 134,
  8, 7, 7, 9, 0, 3, 189, 102, 66, 66, 66, 102, 189, 9, 12, 24,
  9, 0, 0, 128, 128, 65, 0, 65, 0, 34, 0, 34, 0, 20, 0, 127,
  0, 8, 0, 127, 0, 8, 0, 8, 0, 8, 0, 1, 16, 16, 4, 1,
  252, 128, 128, 128, 128, 128, 128, 0, 0, 0, 0, 128, 128, 128, 128, 128,
  128, 7, 15, 15, 9, 1, 253, 56, 68, 70, 96, 152, 140, 134, 194, 98,
  50, 28, 4, 196, 68, 56, 3, 2, 2, 5, 1, 10, 160, 160, 12, 12,
  24, 12, 0, 0, 15, 0, 48, 192, 71, 32, 72, 160, 144, 16, 144, 16,
  144, 16, 144, 16, 72, 160, 71, 32, 48, 192, 15, 0, 5, 7, 7, 6,
  1, 5, 96, 144, 112, 144, 120, 0, 248, 6, 6, 6, 9, 1, 2, 36,
  72, 144, 144, 72, 36, 8, 5, 5, 10, 0, 1, 255, 1, 1, 1, 1,
  4, 1, 1, 5, 0, 4, 240, 12, 12, 24, 12, 0, 0, 15, 0, 48,
  192, 64, 32, 79, 32, 136, 144, 136, 144, 143, 16, 138, 16, 73, 32, 72,
  160, 48, 192, 15, 0, 5, 1, 1, 6, 0, 10, 248, 5, 5, 5, 7,
  1, 7, 112, 136, 136, 136, 112, 9, 11, 22, 10, 0, 0, 8, 0, 8,
  0, 8, 0, 8, 0, 255, 128, 8, 0, 8, 0, 8, 0, 8, 0, 0,
  0, 255, 128, 5, 7, 7, 6, 0, 5, 112, 136, 136, 16, 96, 128, 248,
  5, 7, 7, 6, 0, 5, 112, 136, 8, 48, 8, 136, 112, 3, 3, 3,
  6, 1, 10, 32, 96, 128, 7, 13, 13, 9, 1, 252, 130, 130, 130, 130,
  130, 130, 130, 134, 250, 128, 128, 128, 128, 7, 15, 15, 9, 1, 253, 62,
  116, 244, 244, 244, 244, 116, 52, 20, 20, 20, 20, 20, 20, 20, 1, 2,
  2, 5, 2, 4, 128, 128, 4, 4, 4, 6, 0, 252, 32, 32, 144, 96,
  3, 7, 7, 6, 0, 5, 32, 224, 32, 32, 32, 32, 32, 4, 7, 7,
  6, 1, 5, 96, 144, 144, 144, 96, 0, 240, 6, 6, 6, 9, 1, 2,
  144, 72, 36, 36, 72, 144, 12, 12, 24, 14, 0, 0, 32, 64, 224, 128,
  32, 128, 33, 0, 34, 0, 34, 32, 36, 96, 4, 160, 9, 32, 17, 240,
  16, 32, 32, 32, 12, 13, 26, 14, 0, 0, 0, 64, 32, 128, 224, 128,
  33, 0, 34, 0, 34, 0, 36, 224, 37, 16, 9, 16, 8, 32, 16, 192,
  33, 0, 33, 240, 13, 12, 24, 14, 0, 0, 112, 64, 136, 64, 8, 128,
  48, 128, 9, 0, 137, 16, 114, 48, 2, 80, 4, 144, 4, 248, 8, 16,
  8, 16, 7, 12, 12, 10, 1, 253, 16, 16, 0, 16, 16, 32, 64, 128,
  130, 130, 68, 56, 10, 16, 32, 11, 0, 0, 16, 0, 24, 0, 4, 0,
  0, 0, 12, 0, 12, 0, 18, 0, 18, 0, 18, 0, 33, 0, 33, 0,
  127, 128, 64, 128, 64, 128, 128, 64, 128, 64, 10, 16, 32, 11, 0, 0,
  2, 0, 6, 0, 8, 0, 0, 0, 12, 0, 12, 0, 18, 0, 18, 0,
  18, 0, 33, 0, 33, 0, 127, 128, 64, 128, 64, 128, 128, 64, 128, 64,
  10, 16, 32, 11, 0, 0, 4, 0, 14, 0, 17, 0, 0, 0, 12, 0,
  12, 0, 18, 0, 18, 0, 18, 0, 33, 0, 33, 0, 127, 128, 64, 128,
  64, 128, 128, 64, 128, 64, 10, 15, 30, 11, 0, 0, 26, 0, 44, 0,
  0, 0, 12, 0, 12, 0, 18, 0, 18, 0, 18, 0, 33, 0, 33, 0,
  127, 128, 64, 128, 64, 128, 128, 64, 128, 64, 10, 15, 30, 11, 0, 0,
  18, 0, 18, 0, 0, 0, 12, 0, 12, 0, 18, 0, 18, 0, 18, 0,
  33, 0, 33, 0, 127, 128, 64, 128, 64, 128, 128, 64, 128, 64, 10, 15,
  30, 11, 0, 0, 12, 0, 18, 0, 18, 0, 12, 0, 12, 0, 18, 0,
  18, 0, 18, 0, 33, 0, 33, 0, 127, 128, 64, 128, 64, 128, 128, 64,
  128, 64, 14, 12, 24, 16, 0, 0, 7, 252, 9, 0, 9, 0, 17, 0,
  17, 0, 33, 252, 33, 0, 127, 0, 65, 0, 65, 0, 129, 0, 129, 252,
  10, 16, 32, 12, 1, 252, 15, 0, 48, 128, 64, 64, 64, 0, 128, 0,
  128, 0, 128, 0, 128, 0, 64, 0, 64, 64, 48, 128, 15, 0, 4, 0,
  4, 0, 18, 0, 12, 0, 8, 16, 16, 11, 1, 0, 32, 48, 8, 0,
  255, 128, 128, 128, 128, 255, 128, 128, 128, 128, 128, 255, 8, 16, 16, 11,
  1, 0, 4, 12, 16, 0, 255, 128, 128, 128, 128, 255, 128, 128, 128, 128,
  128, 255, 8, 16, 16, 11, 1, 0, 16, 56, 68, 0, 255, 128, 128, 128,
  128, 255, 128, 128, 128, 128, 128, 255, 8, 15, 15, 11, 1, 0, 36, 36,
  0, 255, 128, 128, 128, 128, 255, 128, 128, 128, 128, 128, 255, 3, 16, 16,
  4, 0, 0, 128, 192, 32, 0, 64, 64, 64, 64, 64, 64, 64, 64, 64,
  64, 64, 64, 3, 16, 16, 4, 0, 0, 32, 96, 128, 0, 64, 64, 64,
  64, 64, 64, 64, 64, 64, 64, 64, 64, 5, 16, 16, 4, 255, 0, 32,
  112, 136, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 3,
  15, 15, 4, 0, 0, 160, 160, 0, 64, 64, 64, 64, 64, 64, 64, 64,
  64, 64, 64, 64, 12, 12, 24, 12, 0, 0, 63, 0, 32, 192, 32, 32,
  32, 32, 32, 16, 248, 16, 32, 16, 32, 16, 32, 32, 32, 32, 32, 192,
  63, 0, 9, 15, 30, 12, 1, 0, 26, 0, 44, 0, 0, 0, 128, 128,
  192, 128, 160, 128, 160, 128, 144, 128, 136, 128, 136, 128, 132, 128, 130, 128,
  130, 128, 129, 128, 128, 128, 11, 16, 32, 13, 1, 0, 8, 0, 12, 0,
  2, 0, 0, 0, 14, 0, 49, 128, 64, 64, 64, 64, 128, 32, 128, 32,
  128, 32, 128, 32, 64, 64, 64, 64, 49, 128, 14, 0, 11, 16, 32, 13,
  1, 0, 1, 0, 3, 0, 4, 0, 0, 0, 14, 0, 49, 128, 64, 64,
  64, 64, 128, 32, 128, 32, 128, 32, 128, 32, 64, 64, 64, 64, 49, 128,
  14, 0, 11, 16, 32, 13, 1, 0, 4, 0, 14, 0, 17, 0, 0, 0,
  14, 0, 49, 128, 64, 64, 64, 64, 128, 32, 128, 32, 128, 32, 128, 32,
  64, 64, 64, 64, 49, 128, 14, 0, 11, 15, 30, 13, 1, 0, 13, 0,
  22, 0, 0, 0, 14, 0, 49, 128, 64, 64, 64, 64, 128, 32, 128, 32,
  128, 32, 128, 32, 64, 64, 64, 64, 49, 128, 14, 0, 11, 15, 30, 13,
  1, 0, 17, 0, 17, 0, 0, 0, 14, 0, 49, 128, 64, 64, 64, 64,
  128, 32, 128, 32, 128, 32, 128, 32, 64, 64, 64, 64, 49, 128, 14, 0,
  8, 8, 8, 10, 1, 0, 129, 66, 36, 24, 24, 36, 66, 129, 11, 14,
  28, 13, 1, 255, 0, 64, 14, 128, 49, 128, 65, 64, 66, 64, 130, 32,
  132, 32, 132, 32, 136, 32, 72, 64, 80, 64, 49, 128, 46, 0, 64, 0,
  9, 16, 32, 12, 1, 0, 32, 0, 48, 0, 8, 0, 0, 0, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 65, 0, 62, 0, 9, 16, 32, 12, 1, 0, 2, 0, 6, 0,
  8, 0, 0, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 65, 0, 62, 0, 9, 16, 32, 12,
  1, 0, 8, 0, 28, 0, 34, 0, 0, 0, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 65, 0,
  62, 0, 9, 15, 30, 12, 1, 0, 34, 0, 34, 0, 0, 0, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 65, 0, 62, 0, 9, 16, 32, 11, 1, 0, 2, 0, 6, 0,
  8, 0, 0, 0, 128, 128, 65, 0, 65, 0, 34, 0, 34, 0, 20, 0,
  28, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 12, 12, 11,
  2, 0, 128, 128, 252, 130, 129, 129, 130, 252, 128, 128, 128, 128, 7, 12,
  12, 10, 2, 0, 120, 132, 130, 130, 132, 188, 134, 130, 130, 130, 132, 184,
  8, 13, 13, 9, 1, 0, 32, 48, 8, 0, 124, 130, 2, 6, 122, 130,
  130, 134, 123, 8, 13, 13, 9, 1, 0, 4, 12, 16, 0, 124, 130, 2,
  6, 122, 130, 130, 134, 123, 8, 13, 13, 9, 1, 0, 16, 56, 68, 0,
  124, 130, 2, 6, 122, 130, 130, 134, 123, 8, 12, 12, 9, 1, 0, 52,
  88, 0, 124, 130, 2, 6, 122, 130, 130, 134, 123, 8, 12, 12, 9, 1,
  0, 40, 40, 0, 124, 130, 2, 6, 122, 130, 130, 134, 123, 8, 13, 13,
  9, 1, 0, 16, 40, 16, 0, 124, 130, 2, 6, 122, 130, 130, 134, 123,
  13, 9, 18, 15, 1, 0, 124, 224, 131, 16, 2, 8, 6, 8, 123, 248,
  130, 0, 130, 8, 135, 16, 120, 224, 7, 13, 13, 8, 1, 252, 56, 68,
  130, 128, 128, 128, 130, 68, 56, 16, 16, 72, 48, 7, 13, 13, 9, 1,
  0, 64, 96, 16, 0, 56, 68, 130, 130, 254, 128, 130, 68, 56, 7, 13,
  13, 9, 1, 0, 8, 24, 32, 0, 56, 68, 130, 130, 254, 128, 130, 68,
  56, 7, 13, 13, 9, 1, 0, 16, 56, 68, 0, 56, 68, 130, 130, 254,
  128, 130, 68, 56, 7, 12, 12, 9, 1, 0, 40, 40, 0, 56, 68, 130,
  130, 254, 128, 130, 68, 56, 3, 13, 13, 4, 1, 0, 128, 192, 32, 0,
  64, 64, 64, 64, 64, 64, 64, 64, 64, 3, 13, 13, 4, 1, 0, 32,
  96, 128, 0, 64, 64, 64, 64, 64, 64, 64, 64, 64, 5, 13, 13, 4,
  0, 0, 32, 112, 136, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 3,
  12, 12, 4, 1, 0, 160, 160, 0, 64, 64, 64, 64, 64, 64, 64, 64,
  64, 7, 12, 12, 9, 1, 0, 72, 48, 88, 60, 68, 130, 130, 130, 130,
  130, 68, 56, 7, 12, 12, 9, 1, 0, 52, 88, 0, 188, 194, 130, 130,
  130, 130, 130, 130, 130, 7, 13, 13, 9, 1, 0, 32, 48, 8, 0, 56,
  68, 130, 130, 130, 130, 130, 68, 56, 7, 13, 13, 9, 1, 0, 8, 24,
  32, 0, 56, 68, 130, 130, 130, 130, 130, 68, 56, 7, 13, 13, 9, 1,
  0, 16, 56, 68, 0, 56, 68, 130, 130, 130, 130, 130, 68, 56, 7, 12,
  12, 9, 1, 0, 52, 88, 0, 56, 68, 130, 130, 130, 130, 130, 68, 56,
  7, 12, 12, 9, 1, 0, 40, 40, 0, 56, 68, 130, 130, 130, 130, 130,
  68, 56, 7, 9, 9, 10, 1, 0, 16, 16, 0, 0, 254, 0, 0, 16,
  16, 7, 10, 10, 10, 1, 0, 2, 60, 68, 138, 146, 146, 162, 162, 68,
  184, 7, 13, 13, 9, 1, 0, 32, 48, 8, 0, 130, 130, 130, 130, 130,
  130, 130, 134, 122, 7, 13, 13, 9, 1, 0, 4, 12, 16, 0, 130, 130,
  130, 130, 130, 130, 130, 134, 122, 7, 13, 13, 9, 1, 0, 16, 56, 68,
  0, 130, 130, 130, 130, 130, 130, 130, 134, 122, 7, 12, 12, 9, 1, 0,
  40, 40, 0, 130, 130, 130, 130, 130, 130, 130, 134, 122, 7, 16, 16, 8,
  0, 253, 8, 24, 32, 0, 130, 130, 68, 68, 40, 40, 56, 16, 16, 32,
  32, 192, 7, 16, 16, 9, 1, 252, 128, 128, 128, 184, 196, 130, 130, 130,
  130, 130, 196, 184, 128, 128, 128, 128, 7, 15, 15, 8, 0, 253, 40, 40,
  0, 130, 130, 68, 68, 40, 40, 56, 16, 16, 32, 32, 192
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--17-120-100-100-P-88-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 0, '1' Height: 12
  Calculated Max Values w= 9 h=12 x= 3 y= 7 dx=10 dy= 0 ascent=12 len=18
  Font Bounding box     w=20 h=26 x=-2 y=-6
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent =12 descent= 0
  X Font      ascent =12 descent= 0
  Max Font    ascent =12 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_helvR12n[290] U8G_FONT_SECTION("u8g_font_helvR12n") = {
  0, 20, 26, 254, 250, 12, 0, 0, 0, 0, 42, 58, 0, 12, 254, 12,
  0, 5, 5, 5, 6, 0, 7, 32, 168, 112, 80, 136, 9, 9, 18, 10,
  0, 0, 8, 0, 8, 0, 8, 0, 8, 0, 255, 128, 8, 0, 8, 0,
  8, 0, 8, 0, 2, 4, 4, 4, 1, 254, 64, 64, 64, 128, 4, 1,
  1, 5, 0, 4, 240, 1, 2, 2, 4, 2, 0, 128, 128, 4, 12, 12,
  5, 0, 0, 16, 16, 32, 32, 32, 32, 64, 64, 64, 128, 128, 128, 7,
  12, 12, 9, 1, 0, 56, 68, 68, 130, 130, 130, 130, 130, 130, 68, 68,
  56, 3, 12, 12, 9, 3, 0, 32, 32, 96, 160, 32, 32, 32, 32, 32,
  32, 32, 32, 7, 12, 12, 9, 1, 0, 56, 68, 130, 130, 2, 4, 8,
  48, 64, 128, 128, 254, 7, 12, 12, 9, 1, 0, 56, 68, 130, 130, 4,
  56, 4, 2, 130, 130, 68, 56, 8, 12, 12, 9, 0, 0, 12, 20, 20,
  36, 36, 68, 68, 132, 255, 4, 4, 4, 7, 12, 12, 9, 1, 0, 62,
  32, 32, 64, 120, 68, 2, 2, 2, 130, 68, 56, 7, 12, 12, 9, 1,
  0, 60, 66, 130, 128, 184, 196, 130, 130, 130, 130, 68, 56, 8, 12, 12,
  9, 0, 0, 255, 1, 2, 4, 4, 8, 8, 16, 16, 16, 32, 32, 7,
  12, 12, 9, 1, 0, 56, 68, 130, 130, 68, 56, 68, 130, 130, 130, 68,
  56, 7, 12, 12, 9, 1, 0, 56, 68, 130, 130, 130, 130, 70, 58, 2,
  130, 132, 120, 1, 9, 9, 4, 2, 0, 128, 128, 0, 0, 0, 0, 0,
  128, 128
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--17-120-100-100-P-88-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 12, '1' Height: 12
  Calculated Max Values w=13 h=16 x= 3 y=10 dx=17 dy= 0 ascent=13 len=28
  Font Bounding box     w=20 h=26 x=-2 y=-6
  Calculated Min Values           x=-1 y=-4 dx= 0 dy= 0
  Pure Font   ascent =12 descent=-4
  X Font      ascent =12 descent=-4
  Max Font    ascent =13 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_helvR12r[1907] U8G_FONT_SECTION("u8g_font_helvR12r") = {
  0, 20, 26, 254, 250, 12, 2, 91, 5, 99, 32, 127, 252, 13, 252, 12,
  252, 0, 0, 0, 5, 0, 1, 1, 12, 12, 5, 2, 0, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 0, 128, 128, 4, 4, 4, 6, 1, 8, 144,
  144, 144, 144, 8, 11, 11, 9, 0, 0, 18, 18, 18, 127, 36, 36, 36,
  254, 72, 72, 72, 7, 15, 15, 9, 1, 254, 16, 124, 146, 146, 144, 80,
  48, 24, 20, 18, 146, 146, 124, 16, 16, 12, 12, 24, 14, 0, 0, 112,
  64, 136, 128, 136, 128, 137, 0, 114, 0, 2, 0, 4, 0, 4, 224, 9,
  16, 17, 16, 17, 16, 32, 224, 10, 12, 24, 11, 0, 0, 24, 0, 36,
  0, 66, 0, 66, 0, 36, 0, 24, 0, 41, 0, 69, 0, 130, 0, 131,
  0, 68, 128, 56, 64, 2, 4, 4, 3, 0, 8, 192, 192, 64, 64, 3,
  16, 16, 6, 1, 252, 32, 64, 64, 64, 128, 128, 128, 128, 128, 128, 128,
  128, 64, 64, 64, 32, 3, 16, 16, 6, 1, 252, 128, 64, 64, 64, 32,
  32, 32, 32, 32, 32, 32, 32, 64, 64, 64, 128, 5, 5, 5, 6, 0,
  7, 32, 168, 112, 80, 136, 9, 9, 18, 10, 0, 0, 8, 0, 8, 0,
  8, 0, 8, 0, 255, 128, 8, 0, 8, 0, 8, 0, 8, 0, 2, 4,
  4, 4, 1, 254, 64, 64, 64, 128, 4, 1, 1, 5, 0, 4, 240, 1,
  2, 2, 4, 2, 0, 128, 128, 4, 12, 12, 5, 0, 0, 16, 16, 32,
  32, 32, 32, 64, 64, 64, 128, 128, 128, 7, 12, 12, 9, 1, 0, 56,
  68, 68, 130, 130, 130, 130, 130, 130, 68, 68, 56, 3, 12, 12, 9, 3,
  0, 32, 32, 96, 160, 32, 32, 32, 32, 32, 32, 32, 32, 7, 12, 12,
  9, 1, 0, 56, 68, 130, 130, 2, 4, 8, 48, 64, 128, 128, 254, 7,
  12, 12, 9, 1, 0, 56, 68, 130, 130, 4, 56, 4, 2, 130, 130, 68,
  56, 8, 12, 12, 9, 0, 0, 12, 20, 20, 36, 36, 68, 68, 132, 255,
  4, 4, 4, 7, 12, 12, 9, 1, 0, 62, 32, 32, 64, 120, 68, 2,
  2, 2, 130, 68, 56, 7, 12, 12, 9, 1, 0, 60, 66, 130, 128, 184,
  196, 130, 130, 130, 130, 68, 56, 8, 12, 12, 9, 0, 0, 255, 1, 2,
  4, 4, 8, 8, 16, 16, 16, 32, 32, 7, 12, 12, 9, 1, 0, 56,
  68, 130, 130, 68, 56, 68, 130, 130, 130, 68, 56, 7, 12, 12, 9, 1,
  0, 56, 68, 130, 130, 130, 130, 70, 58, 2, 130, 132, 120, 1, 9, 9,
  4, 2, 0, 128, 128, 0, 0, 0, 0, 0, 128, 128, 2, 11, 11, 4,
  1, 254, 64, 64, 0, 0, 0, 0, 0, 64, 64, 64, 128, 9, 9, 18,
  10, 0, 0, 1, 128, 6, 0, 24, 0, 96, 0, 128, 0, 96, 0, 24,
  0, 6, 0, 1, 128, 8, 4, 4, 10, 0, 2, 255, 0, 0, 255, 9,
  9, 18, 10, 1, 0, 192, 0, 48, 0, 12, 0, 3, 0, 0, 128, 3,
  0, 12, 0, 48, 0, 192, 0, 7, 12, 12, 9, 1, 0, 56, 68, 130,
  130, 2, 4, 8, 16, 16, 0, 16, 16, 13, 14, 28, 17, 1, 254, 7,
  128, 24, 96, 32, 16, 67, 208, 76, 72, 136, 72, 144, 136, 144, 136, 144,
  144, 153, 144, 78, 96, 64, 0, 48, 96, 15, 128, 10, 12, 24, 11, 0,
  0, 12, 0, 12, 0, 18, 0, 18, 0, 18, 0, 33, 0, 33, 0, 127,
  128, 64, 128, 64, 128, 128, 64, 128, 64, 9, 12, 24, 11, 1, 0, 252,
  0, 130, 0, 129, 0, 129, 0, 130, 0, 254, 0, 129, 0, 128, 128, 128,
  128, 128, 128, 129, 0, 254, 0, 10, 12, 24, 12, 1, 0, 15, 0, 48,
  128, 64, 64, 64, 0, 128, 0, 128, 0, 128, 0, 128, 0, 64, 0, 64,
  64, 48, 128, 15, 0, 10, 12, 24, 12, 1, 0, 252, 0, 131, 0, 128,
  128, 128, 128, 128, 64, 128, 64, 128, 64, 128, 64, 128, 128, 128, 128, 131,
  0, 252, 0, 8, 12, 12, 11, 1, 0, 255, 128, 128, 128, 128, 255, 128,
  128, 128, 128, 128, 255, 7, 12, 12, 10, 1, 0, 254, 128, 128, 128, 128,
  254, 128, 128, 128, 128, 128, 128, 10, 12, 24, 13, 1, 0, 14, 0, 49,
  128, 64, 64, 64, 0, 128, 0, 128, 0, 135, 192, 128, 64, 64, 64, 64,
  192, 49, 64, 14, 64, 9, 12, 24, 12, 1, 0, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 255, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 1, 12, 12, 4, 1, 0, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 6, 12, 12, 8, 0, 0, 4, 4, 4, 4, 4,
  4, 4, 4, 132, 132, 132, 120, 8, 12, 12, 11, 1, 0, 129, 130, 132,
  136, 144, 176, 200, 136, 132, 130, 130, 129, 7, 12, 12, 9, 1, 0, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 254, 11, 12, 24, 13, 1,
  0, 128, 32, 192, 96, 192, 96, 160, 160, 160, 160, 160, 160, 145, 32, 145,
  32, 145, 32, 138, 32, 138, 32, 132, 32, 9, 12, 24, 12, 1, 0, 128,
  128, 192, 128, 160, 128, 160, 128, 144, 128, 136, 128, 136, 128, 132, 128, 130,
  128, 130, 128, 129, 128, 128, 128, 11, 12, 24, 13, 1, 0, 14, 0, 49,
  128, 64, 64, 64, 64, 128, 32, 128, 32, 128, 32, 128, 32, 64, 64, 64,
  64, 49, 128, 14, 0, 8, 12, 12, 11, 2, 0, 252, 130, 129, 129, 130,
  252, 128, 128, 128, 128, 128, 128, 11, 13, 26, 13, 1, 255, 14, 0, 49,
  128, 64, 64, 64, 64, 128, 32, 128, 32, 128, 32, 128, 32, 64, 64, 66,
  64, 49, 128, 14, 128, 0, 64, 9, 12, 24, 12, 2, 0, 252, 0, 130,
  0, 129, 0, 129, 0, 130, 0, 252, 0, 130, 0, 129, 0, 129, 0, 129,
  0, 129, 0, 128, 128, 9, 12, 24, 11, 1, 0, 62, 0, 65, 0, 128,
  128, 128, 128, 64, 0, 48, 0, 14, 0, 1, 0, 128, 128, 128, 128, 65,
  0, 62, 0, 9, 12, 24, 10, 0, 0, 255, 128, 8, 0, 8, 0, 8,
  0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8,
  0, 9, 12, 24, 12, 1, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 65, 0, 62, 0, 10,
  12, 24, 11, 0, 0, 128, 64, 128, 64, 64, 128, 64, 128, 64, 128, 33,
  0, 33, 0, 18, 0, 18, 0, 18, 0, 12, 0, 12, 0, 13, 12, 24,
  15, 1, 0, 130, 8, 130, 8, 130, 8, 69, 16, 69, 16, 69, 16, 40,
  160, 40, 160, 40, 160, 16, 64, 16, 64, 16, 64, 8, 12, 12, 11, 1,
  0, 129, 66, 66, 36, 36, 24, 24, 36, 36, 66, 66, 129, 9, 12, 24,
  11, 1, 0, 128, 128, 65, 0, 65, 0, 34, 0, 34, 0, 20, 0, 28,
  0, 8, 0, 8, 0, 8, 0, 8, 0, 8, 0, 9, 12, 24, 10, 0,
  0, 127, 128, 1, 0, 3, 0, 2, 0, 4, 0, 12, 0, 8, 0, 16,
  0, 48, 0, 32, 0, 64, 0, 255, 128, 3, 15, 15, 5, 1, 253, 224,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 224, 4, 12,
  12, 5, 0, 0, 128, 128, 64, 64, 64, 64, 32, 32, 32, 16, 16, 16,
  3, 15, 15, 5, 0, 253, 224, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 224, 7, 7, 7, 8, 0, 5, 16, 40, 40, 68, 68,
  130, 130, 9, 1, 2, 9, 0, 253, 255, 128, 3, 3, 3, 6, 0, 10,
  128, 192, 32, 8, 9, 9, 9, 1, 0, 124, 130, 2, 6, 122, 130, 130,
  134, 123, 7, 12, 12, 9, 1, 0, 128, 128, 128, 184, 196, 130, 130, 130,
  130, 130, 196, 184, 7, 9, 9, 8, 1, 0, 56, 68, 130, 128, 128, 128,
  130, 68, 56, 7, 12, 12, 9, 1, 0, 2, 2, 2, 58, 70, 130, 130,
  130, 130, 130, 70, 58, 7, 9, 9, 9, 1, 0, 56, 68, 130, 130, 254,
  128, 130, 68, 56, 4, 12, 12, 5, 1, 0, 48, 64, 64, 240, 64, 64,
  64, 64, 64, 64, 64, 64, 7, 13, 13, 9, 1, 252, 58, 70, 130, 130,
  130, 130, 130, 70, 58, 2, 130, 132, 120, 7, 12, 12, 9, 1, 0, 128,
  128, 128, 188, 194, 130, 130, 130, 130, 130, 130, 130, 1, 12, 12, 3, 1,
  0, 128, 128, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 3, 16, 16,
  4, 255, 252, 32, 32, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 192, 7, 12, 12, 8, 0, 0, 128, 128, 128, 132, 136, 144, 160,
  224, 144, 136, 132, 130, 1, 12, 12, 3, 1, 0, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 11, 9, 18, 14, 2, 0, 185, 192, 198,
  32, 132, 32, 132, 32, 132, 32, 132, 32, 132, 32, 132, 32, 132, 32, 7,
  9, 9, 9, 1, 0, 188, 194, 130, 130, 130, 130, 130, 130, 130, 7, 9,
  9, 9, 1, 0, 56, 68, 130, 130, 130, 130, 130, 68, 56, 7, 13, 13,
  9, 1, 252, 184, 196, 130, 130, 130, 130, 130, 196, 184, 128, 128, 128, 128,
  7, 13, 13, 9, 1, 252, 58, 70, 130, 130, 130, 130, 130, 70, 58, 2,
  2, 2, 2, 4, 9, 9, 5, 1, 0, 176, 192, 128, 128, 128, 128, 128,
  128, 128, 6, 9, 9, 8, 1, 0, 120, 132, 132, 192, 48, 12, 132, 132,
  120, 4, 11, 11, 5, 1, 0, 64, 64, 240, 64, 64, 64, 64, 64, 64,
  64, 48, 7, 9, 9, 9, 1, 0, 130, 130, 130, 130, 130, 130, 130, 134,
  122, 7, 9, 9, 8, 0, 0, 130, 130, 68, 68, 68, 40, 40, 56, 16,
  11, 9, 18, 12, 0, 0, 132, 32, 132, 32, 68, 64, 78, 64, 74, 64,
  42, 128, 42, 128, 17, 0, 17, 0, 7, 9, 9, 8, 0, 0, 130, 68,
  68, 40, 16, 40, 68, 68, 130, 7, 12, 12, 8, 0, 253, 130, 130, 68,
  68, 40, 40, 56, 16, 16, 32, 32, 192, 6, 9, 9, 8, 1, 0, 252,
  4, 8, 16, 32, 32, 64, 128, 252, 3, 16, 16, 6, 1, 252, 32, 64,
  64, 64, 64, 64, 64, 128, 64, 64, 64, 64, 64, 64, 64, 32, 1, 16,
  16, 4, 1, 252, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 3, 16, 16, 6, 1, 252, 128, 64, 64, 64, 64, 64,
  64, 32, 64, 64, 64, 64, 64, 64, 64, 128, 8, 2, 2, 10, 1, 4,
  113, 142, 255
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--20-140-100-100-P-100-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 14, '1' Height: 13
  Calculated Max Values w=16 h=18 x= 2 y=12 dx=18 dy= 0 ascent=18 len=36
  Font Bounding box     w=22 h=29 x=-2 y=-7
  Calculated Min Values           x=-1 y=-4 dx= 0 dy= 0
  Pure Font   ascent =14 descent=-4
  X Font      ascent =14 descent=-4
  Max Font    ascent =18 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_helvR14[4920] U8G_FONT_SECTION("u8g_font_helvR14") = {
  0, 22, 29, 254, 249, 14, 2, 149, 6, 82, 32, 255, 252, 18, 252, 14,
  252, 0, 0, 0, 5, 0, 1, 2, 14, 14, 6, 2, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 128, 128, 0, 0, 192, 192, 5, 5, 5, 5, 0,
  9, 216, 216, 216, 216, 216, 10, 13, 26, 10, 0, 0, 9, 0, 9, 0,
  9, 0, 127, 192, 127, 192, 18, 0, 18, 0, 18, 0, 255, 128, 255, 128,
  36, 0, 36, 0, 36, 0, 9, 16, 32, 10, 1, 254, 8, 0, 62, 0,
  127, 0, 203, 0, 200, 0, 232, 0, 120, 0, 62, 0, 15, 0, 9, 128,
  201, 128, 235, 128, 127, 0, 62, 0, 8, 0, 8, 0, 14, 13, 26, 16,
  1, 0, 120, 96, 204, 192, 204, 192, 205, 128, 205, 128, 123, 0, 3, 0,
  6, 120, 6, 204, 12, 204, 12, 204, 24, 204, 24, 120, 12, 13, 26, 13,
  1, 0, 60, 0, 126, 0, 102, 0, 102, 0, 60, 0, 124, 0, 238, 192,
  198, 192, 195, 192, 195, 128, 231, 192, 126, 224, 60, 112, 1, 5, 5, 3,
  1, 9, 128, 128, 128, 128, 128, 4, 18, 18, 6, 0, 252, 16, 48, 96,
  96, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 96, 96, 48, 16, 4,
  18, 18, 6, 1, 252, 128, 192, 96, 96, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 96, 96, 192, 128, 5, 7, 7, 7, 1, 7, 32, 168, 248,
  32, 248, 168, 32, 8, 10, 10, 10, 1, 0, 24, 24, 24, 24, 255, 255,
  24, 24, 24, 24, 2, 5, 5, 5, 1, 253, 192, 192, 64, 64, 128, 5,
  1, 1, 6, 0, 5, 248, 2, 2, 2, 5, 1, 0, 192, 192, 5, 14,
  14, 5, 0, 0, 24, 24, 24, 24, 48, 48, 48, 96, 96, 96, 192, 192,
  192, 192, 8, 13, 13, 10, 1, 0, 60, 126, 102, 195, 195, 195, 195, 195,
  195, 195, 102, 126, 60, 5, 13, 13, 10, 2, 0, 24, 248, 248, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 8, 13, 13, 10, 1, 0, 60, 254,
  195, 3, 7, 14, 28, 56, 112, 224, 192, 255, 255, 8, 13, 13, 10, 1,
  0, 62, 127, 195, 195, 6, 28, 30, 7, 3, 195, 199, 126, 60, 9, 13,
  26, 10, 0, 0, 3, 0, 7, 0, 15, 0, 27, 0, 51, 0, 51, 0,
  99, 0, 195, 0, 255, 128, 255, 128, 3, 0, 3, 0, 3, 0, 8, 13,
  13, 10, 1, 0, 254, 254, 192, 192, 252, 254, 199, 3, 3, 195, 199, 254,
  124, 8, 13, 13, 10, 1, 0, 60, 127, 99, 192, 192, 220, 254, 195, 195,
  195, 227, 126, 60, 8, 13, 13, 10, 1, 0, 255, 255, 3, 6, 12, 12,
  24, 24, 48, 48, 96, 96, 96, 8, 13, 13, 10, 1, 0, 60, 126, 231,
  195, 195, 102, 126, 231, 195, 195, 231, 126, 60, 8, 13, 13, 10, 1, 0,
  60, 126, 199, 195, 195, 195, 127, 59, 3, 3, 198, 254, 124, 2, 10, 10,
  5, 1, 0, 192, 192, 0, 0, 0, 0, 0, 0, 192, 192, 2, 13, 13,
  5, 1, 253, 192, 192, 0, 0, 0, 0, 0, 0, 192, 192, 64, 64, 128,
  8, 9, 9, 10, 1, 0, 3, 15, 60, 112, 192, 112, 60, 15, 3, 7,
  5, 5, 11, 2, 2, 254, 254, 0, 254, 254, 8, 9, 9, 10, 1, 0,
  192, 240, 60, 14, 3, 14, 60, 240, 192, 7, 14, 14, 10, 1, 0, 124,
  254, 198, 198, 14, 28, 56, 48, 48, 48, 0, 0, 48, 48, 16, 17, 34,
  18, 1, 253, 3, 240, 15, 252, 28, 14, 48, 6, 99, 211, 103, 115, 198,
  51, 204, 99, 204, 102, 204, 102, 204, 204, 207, 248, 103, 112, 112, 0, 56,
  0, 31, 240, 7, 224, 12, 14, 28, 13, 0, 0, 6, 0, 6, 0, 15,
  0, 15, 0, 25, 128, 25, 128, 48, 192, 48, 192, 63, 192, 127, 224, 96,
  96, 96, 96, 192, 48, 192, 48, 11, 14, 28, 13, 1, 0, 255, 0, 255,
  128, 193, 192, 192, 192, 192, 192, 193, 128, 255, 128, 255, 192, 192, 224, 192,
  96, 192, 96, 192, 224, 255, 192, 255, 128, 12, 14, 28, 14, 1, 0, 15,
  128, 63, 224, 112, 112, 96, 48, 224, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 224, 0, 96, 48, 112, 112, 63, 224, 15, 128, 12, 14, 28, 14, 1,
  0, 255, 128, 255, 192, 192, 224, 192, 96, 192, 48, 192, 48, 192, 48, 192,
  48, 192, 48, 192, 48, 192, 96, 192, 224, 255, 192, 255, 128, 10, 14, 28,
  13, 2, 0, 255, 192, 255, 192, 192, 0, 192, 0, 192, 0, 192, 0, 255,
  128, 255, 128, 192, 0, 192, 0, 192, 0, 192, 0, 255, 192, 255, 192, 9,
  14, 28, 12, 2, 0, 255, 128, 255, 128, 192, 0, 192, 0, 192, 0, 192,
  0, 255, 0, 255, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 13, 14, 28, 15, 1, 0, 15, 192, 63, 240, 112, 56, 96, 24, 224,
  24, 192, 0, 192, 0, 192, 248, 192, 248, 224, 24, 96, 24, 112, 56, 63,
  248, 15, 216, 11, 14, 28, 14, 1, 0, 192, 96, 192, 96, 192, 96, 192,
  96, 192, 96, 192, 96, 255, 224, 255, 224, 192, 96, 192, 96, 192, 96, 192,
  96, 192, 96, 192, 96, 2, 14, 14, 6, 2, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 8, 14, 14, 10, 0, 0, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 195, 195, 231, 126, 60, 12, 14, 28,
  13, 2, 0, 192, 224, 193, 192, 195, 128, 199, 0, 206, 0, 220, 0, 248,
  0, 252, 0, 206, 0, 199, 0, 195, 128, 193, 192, 192, 224, 192, 112, 9,
  14, 28, 11, 1, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 128, 255,
  128, 14, 14, 28, 16, 1, 0, 192, 12, 192, 12, 224, 28, 224, 28, 240,
  60, 240, 60, 216, 108, 216, 108, 204, 204, 204, 204, 196, 140, 199, 140, 195,
  12, 195, 12, 11, 14, 28, 14, 1, 0, 192, 96, 224, 96, 240, 96, 240,
  96, 216, 96, 204, 96, 204, 96, 198, 96, 198, 96, 195, 96, 193, 224, 193,
  224, 192, 224, 192, 96, 13, 14, 28, 15, 1, 0, 15, 128, 63, 224, 112,
  112, 96, 48, 224, 56, 192, 24, 192, 24, 192, 24, 192, 24, 224, 56, 96,
  48, 112, 112, 63, 224, 15, 128, 10, 14, 28, 13, 2, 0, 255, 0, 255,
  128, 193, 192, 192, 192, 192, 192, 193, 192, 255, 128, 255, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 13, 15, 30, 15, 1, 255, 15,
  128, 63, 224, 112, 112, 96, 48, 224, 56, 192, 24, 192, 24, 192, 24, 192,
  24, 225, 184, 97, 176, 112, 240, 63, 224, 15, 176, 0, 48, 11, 14, 28,
  14, 1, 0, 255, 128, 255, 192, 192, 224, 192, 96, 192, 96, 192, 224, 255,
  192, 255, 128, 192, 192, 192, 192, 192, 96, 192, 96, 192, 96, 192, 96, 10,
  14, 28, 13, 1, 0, 30, 0, 127, 128, 225, 192, 192, 192, 224, 0, 124,
  0, 31, 0, 3, 128, 1, 192, 0, 192, 192, 192, 225, 192, 127, 128, 63,
  0, 10, 14, 28, 12, 1, 0, 255, 192, 255, 192, 12, 0, 12, 0, 12,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12,
  0, 12, 0, 11, 14, 28, 14, 1, 0, 192, 96, 192, 96, 192, 96, 192,
  96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 96,
  192, 127, 192, 31, 0, 12, 14, 28, 13, 0, 0, 192, 48, 192, 48, 96,
  96, 96, 96, 96, 96, 48, 192, 48, 192, 48, 192, 25, 128, 25, 128, 25,
  128, 15, 0, 15, 0, 6, 0, 16, 14, 28, 18, 1, 0, 193, 131, 193,
  131, 193, 131, 195, 195, 99, 198, 98, 70, 102, 102, 102, 102, 54, 108, 54,
  108, 52, 44, 28, 56, 24, 24, 24, 24, 11, 14, 28, 13, 1, 0, 192,
  96, 192, 96, 96, 192, 113, 192, 49, 128, 27, 0, 14, 0, 14, 0, 27,
  0, 49, 128, 113, 192, 96, 192, 192, 96, 192, 96, 12, 14, 28, 13, 0,
  0, 192, 48, 192, 48, 96, 96, 96, 96, 48, 192, 57, 192, 25, 128, 15,
  0, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 10, 14, 28,
  12, 1, 0, 255, 192, 255, 192, 0, 192, 1, 128, 3, 0, 6, 0, 12,
  0, 28, 0, 24, 0, 48, 0, 96, 0, 192, 0, 255, 192, 255, 192, 4,
  18, 18, 5, 0, 252, 240, 240, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 240, 240, 5, 14, 14, 5, 0, 0, 192, 192, 192,
  96, 96, 96, 48, 48, 48, 48, 24, 24, 24, 24, 4, 18, 18, 5, 0,
  252, 240, 240, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 240, 240, 7, 6, 6, 9, 1, 7, 16, 56, 108, 108, 198, 198, 11,
  2, 4, 11, 0, 252, 255, 224, 255, 224, 4, 3, 3, 4, 0, 11, 192,
  96, 48, 9, 10, 20, 11, 1, 0, 126, 0, 231, 0, 195, 0, 7, 0,
  127, 0, 227, 0, 195, 0, 195, 0, 231, 128, 121, 128, 9, 14, 28, 11,
  1, 0, 192, 0, 192, 0, 192, 0, 192, 0, 222, 0, 255, 0, 227, 0,
  193, 128, 193, 128, 193, 128, 193, 128, 227, 0, 255, 0, 222, 0, 8, 10,
  10, 10, 1, 0, 62, 127, 99, 192, 192, 192, 192, 99, 127, 62, 9, 14,
  28, 11, 1, 0, 1, 128, 1, 128, 1, 128, 1, 128, 61, 128, 127, 128,
  99, 128, 193, 128, 193, 128, 193, 128, 193, 128, 99, 128, 127, 128, 61, 128,
  8, 10, 10, 10, 1, 0, 60, 126, 195, 195, 255, 192, 192, 227, 127, 60,
  6, 14, 14, 6, 0, 0, 28, 60, 48, 48, 252, 252, 48, 48, 48, 48,
  48, 48, 48, 48, 9, 14, 28, 11, 1, 252, 61, 128, 127, 128, 97, 128,
  193, 128, 193, 128, 193, 128, 193, 128, 99, 128, 127, 128, 61, 128, 1, 128,
  99, 0, 127, 0, 28, 0, 8, 14, 14, 10, 1, 0, 192, 192, 192, 192,
  222, 255, 227, 195, 195, 195, 195, 195, 195, 195, 2, 14, 14, 4, 1, 0,
  192, 192, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 4, 18,
  18, 4, 255, 252, 48, 48, 0, 0, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 240, 224, 8, 14, 14, 9, 1, 0, 192, 192, 192, 192,
  198, 204, 216, 240, 248, 216, 204, 206, 198, 199, 2, 14, 14, 4, 1, 0,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 14, 10,
  20, 16, 1, 0, 222, 120, 255, 252, 227, 140, 195, 12, 195, 12, 195, 12,
  195, 12, 195, 12, 195, 12, 195, 12, 8, 10, 10, 10, 1, 0, 222, 255,
  227, 195, 195, 195, 195, 195, 195, 195, 9, 10, 20, 11, 1, 0, 62, 0,
  127, 0, 99, 0, 193, 128, 193, 128, 193, 128, 193, 128, 99, 0, 127, 0,
  62, 0, 9, 14, 28, 11, 1, 252, 222, 0, 255, 0, 227, 0, 193, 128,
  193, 128, 193, 128, 193, 128, 227, 0, 255, 0, 222, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 9, 14, 28, 11, 1, 252, 61, 128, 127, 128, 99, 128,
  193, 128, 193, 128, 193, 128, 193, 128, 99, 128, 127, 128, 61, 128, 1, 128,
  1, 128, 1, 128, 1, 128, 5, 10, 10, 6, 1, 0, 216, 216, 224, 192,
  192, 192, 192, 192, 192, 192, 7, 10, 10, 9, 1, 0, 60, 126, 198, 192,
  252, 62, 6, 198, 252, 120, 6, 13, 13, 6, 0, 0, 48, 48, 48, 252,
  252, 48, 48, 48, 48, 48, 48, 60, 28, 8, 10, 10, 10, 1, 0, 195,
  195, 195, 195, 195, 195, 195, 199, 255, 123, 8, 10, 10, 10, 1, 0, 195,
  195, 195, 102, 102, 102, 36, 60, 24, 24, 12, 10, 20, 14, 1, 0, 198,
  48, 198, 48, 198, 48, 102, 96, 102, 96, 105, 96, 41, 64, 57, 192, 25,
  128, 25, 128, 8, 10, 10, 10, 1, 0, 195, 231, 102, 60, 24, 24, 60,
  102, 231, 195, 8, 14, 14, 10, 1, 252, 195, 195, 195, 102, 102, 102, 36,
  60, 24, 24, 24, 24, 112, 112, 7, 10, 10, 9, 1, 0, 254, 254, 6,
  12, 24, 48, 96, 192, 254, 254, 6, 18, 18, 6, 255, 252, 12, 24, 48,
  48, 48, 48, 48, 96, 192, 96, 48, 48, 48, 48, 48, 48, 24, 12, 2,
  18, 18, 5, 1, 252, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 6, 18, 18, 6, 0, 252, 192, 96, 48,
  48, 48, 48, 48, 24, 12, 24, 48, 48, 48, 48, 48, 48, 96, 192, 8,
  3, 3, 10, 1, 4, 115, 255, 206, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 5, 0, 1, 2,
  14, 14, 6, 2, 252, 192, 192, 0, 0, 64, 64, 192, 192, 192, 192, 192,
  192, 192, 192, 8, 14, 14, 10, 1, 254, 4, 4, 62, 127, 107, 200, 200,
  200, 200, 107, 127, 62, 16, 16, 9, 13, 26, 10, 0, 0, 30, 0, 63,
  0, 97, 128, 97, 128, 96, 0, 48, 0, 126, 0, 24, 0, 24, 0, 48,
  0, 96, 128, 255, 128, 223, 0, 8, 7, 7, 10, 1, 3, 195, 255, 102,
  102, 102, 255, 195, 8, 13, 13, 10, 1, 0, 195, 195, 102, 102, 102, 60,
  255, 24, 255, 24, 24, 24, 24, 2, 18, 18, 5, 1, 252, 192, 192, 192,
  192, 192, 192, 192, 0, 0, 0, 0, 192, 192, 192, 192, 192, 192, 192, 8,
  18, 18, 10, 1, 252, 60, 126, 195, 195, 240, 124, 110, 199, 195, 227, 115,
  62, 14, 7, 195, 195, 126, 60, 5, 2, 2, 6, 0, 12, 216, 216, 13,
  14, 28, 15, 1, 0, 15, 128, 48, 96, 64, 16, 71, 16, 136, 136, 144,
  136, 144, 8, 144, 8, 144, 8, 136, 136, 71, 16, 64, 16, 48, 96, 15,
  128, 5, 8, 8, 7, 1, 6, 112, 152, 56, 72, 216, 104, 0, 248, 7,
  6, 6, 9, 1, 2, 54, 108, 216, 216, 108, 54, 9, 5, 10, 11, 1,
  3, 255, 128, 255, 128, 1, 128, 1, 128, 1, 128, 5, 1, 1, 6, 0,
  5, 248, 13, 14, 28, 14, 0, 0, 15, 128, 48, 96, 64, 16, 79, 144,
  136, 72, 136, 72, 136, 72, 143, 136, 137, 8, 136, 136, 72, 80, 64, 16,
  48, 96, 15, 128, 5, 1, 1, 5, 0, 12, 248, 5, 5, 5, 7, 1,
  8, 112, 216, 136, 216, 112, 8, 11, 11, 10, 1, 0, 24, 24, 24, 255,
  255, 24, 24, 24, 0, 255, 255, 5, 8, 8, 6, 0, 5, 112, 248, 152,
  24, 48, 96, 248, 248, 5, 8, 8, 6, 0, 5, 112, 248, 152, 48, 48,
  152, 248, 112, 4, 3, 3, 4, 0, 11, 48, 96, 192, 8, 14, 14, 10,
  1, 252, 195, 195, 195, 195, 195, 195, 195, 231, 255, 219, 192, 192, 192, 192,
  8, 18, 18, 10, 1, 252, 63, 114, 242, 242, 242, 242, 242, 114, 50, 18,
  18, 18, 18, 18, 18, 18, 18, 18, 2, 2, 2, 4, 1, 4, 192, 192,
  5, 5, 5, 5, 0, 252, 96, 112, 24, 216, 240, 4, 8, 8, 6, 0,
  5, 48, 240, 240, 48, 48, 48, 48, 48, 5, 8, 8, 7, 1, 6, 112,
  216, 136, 136, 216, 112, 0, 248, 7, 6, 6, 9, 1, 2, 216, 108, 54,
  54, 108, 216, 14, 13, 26, 15, 0, 0, 48, 48, 240, 48, 240, 96, 48,
  192, 48, 192, 49, 136, 49, 24, 51, 56, 6, 120, 6, 216, 12, 252, 24,
  24, 24, 24, 14, 13, 26, 15, 0, 0, 48, 48, 240, 48, 240, 96, 48,
  192, 48, 192, 49, 184, 49, 124, 51, 76, 6, 12, 6, 24, 12, 48, 24,
  124, 24, 124, 14, 13, 26, 15, 0, 0, 112, 48, 248, 48, 152, 96, 48,
  192, 48, 192, 153, 136, 249, 24, 115, 56, 6, 120, 6, 216, 12, 252, 24,
  24, 24, 24, 7, 14, 14, 10, 1, 252, 24, 24, 0, 0, 24, 24, 24,
  56, 112, 224, 198, 198, 254, 124, 12, 18, 36, 13, 0, 0, 24, 0, 12,
  0, 6, 0, 0, 0, 6, 0, 6, 0, 15, 0, 15, 0, 25, 128, 25,
  128, 48, 192, 48, 192, 63, 192, 127, 224, 96, 96, 96, 96, 192, 48, 192,
  48, 12, 18, 36, 13, 0, 0, 1, 128, 3, 0, 6, 0, 0, 0, 6,
  0, 6, 0, 15, 0, 15, 0, 25, 128, 25, 128, 48, 192, 48, 192, 63,
  192, 127, 224, 96, 96, 96, 96, 192, 48, 192, 48, 12, 18, 36, 13, 0,
  0, 6, 0, 15, 0, 25, 128, 0, 0, 6, 0, 6, 0, 15, 0, 15,
  0, 25, 128, 25, 128, 48, 192, 48, 192, 63, 192, 127, 224, 96, 96, 96,
  96, 192, 48, 192, 48, 12, 18, 36, 13, 0, 0, 12, 128, 22, 128, 19,
  0, 0, 0, 6, 0, 6, 0, 15, 0, 15, 0, 25, 128, 25, 128, 48,
  192, 48, 192, 63, 192, 127, 224, 96, 96, 96, 96, 192, 48, 192, 48, 12,
  17, 34, 13, 0, 0, 25, 128, 25, 128, 0, 0, 6, 0, 6, 0, 15,
  0, 15, 0, 25, 128, 25, 128, 48, 192, 48, 192, 63, 192, 127, 224, 96,
  96, 96, 96, 192, 48, 192, 48, 12, 17, 34, 13, 0, 0, 6, 0, 9,
  0, 9, 0, 6, 0, 6, 0, 15, 0, 15, 0, 25, 128, 25, 128, 48,
  192, 48, 192, 63, 192, 127, 224, 96, 96, 96, 96, 192, 48, 192, 48, 16,
  14, 28, 18, 1, 0, 7, 255, 7, 255, 13, 128, 13, 128, 25, 128, 25,
  128, 49, 254, 49, 254, 63, 128, 127, 128, 97, 128, 97, 128, 193, 255, 193,
  255, 12, 18, 36, 14, 1, 252, 15, 128, 63, 224, 112, 112, 96, 48, 224,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 224, 0, 96, 48, 112, 112, 63,
  224, 15, 128, 6, 0, 3, 0, 27, 0, 30, 0, 10, 18, 36, 13, 2,
  0, 48, 0, 24, 0, 12, 0, 0, 0, 255, 192, 255, 192, 192, 0, 192,
  0, 192, 0, 192, 0, 255, 128, 255, 128, 192, 0, 192, 0, 192, 0, 192,
  0, 255, 192, 255, 192, 10, 18, 36, 13, 2, 0, 3, 0, 6, 0, 12,
  0, 0, 0, 255, 192, 255, 192, 192, 0, 192, 0, 192, 0, 192, 0, 255,
  128, 255, 128, 192, 0, 192, 0, 192, 0, 192, 0, 255, 192, 255, 192, 10,
  18, 36, 13, 2, 0, 12, 0, 30, 0, 51, 0, 0, 0, 255, 192, 255,
  192, 192, 0, 192, 0, 192, 0, 192, 0, 255, 128, 255, 128, 192, 0, 192,
  0, 192, 0, 192, 0, 255, 192, 255, 192, 10, 17, 34, 13, 2, 0, 51,
  0, 51, 0, 0, 0, 255, 192, 255, 192, 192, 0, 192, 0, 192, 0, 192,
  0, 255, 128, 255, 128, 192, 0, 192, 0, 192, 0, 192, 0, 255, 192, 255,
  192, 4, 18, 18, 6, 0, 0, 192, 96, 48, 0, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 4, 18, 18, 6, 2, 0, 48,
  96, 192, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 6, 18, 18, 6, 0, 0, 48, 120, 132, 0, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 6, 17, 17, 6, 0, 0, 204,
  204, 0, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  14, 14, 28, 14, 255, 0, 63, 224, 63, 240, 48, 56, 48, 24, 48, 12,
  48, 12, 254, 12, 254, 12, 48, 12, 48, 12, 48, 24, 48, 56, 63, 240,
  63, 224, 11, 18, 36, 14, 1, 0, 12, 128, 22, 128, 19, 0, 0, 0,
  192, 96, 224, 96, 240, 96, 240, 96, 216, 96, 204, 96, 204, 96, 198, 96,
  198, 96, 195, 96, 193, 224, 193, 224, 192, 224, 192, 96, 13, 18, 36, 15,
  1, 0, 24, 0, 12, 0, 6, 0, 0, 0, 15, 128, 63, 224, 112, 112,
  96, 48, 224, 56, 192, 24, 192, 24, 192, 24, 192, 24, 224, 56, 96, 48,
  112, 112, 63, 224, 15, 128, 13, 18, 36, 15, 1, 0, 1, 128, 3, 0,
  6, 0, 0, 0, 15, 128, 63, 224, 112, 112, 96, 48, 224, 56, 192, 24,
  192, 24, 192, 24, 192, 24, 224, 56, 96, 48, 112, 112, 63, 224, 15, 128,
  13, 18, 36, 15, 1, 0, 3, 0, 7, 128, 12, 192, 0, 0, 15, 128,
  63, 224, 112, 112, 96, 48, 224, 56, 192, 24, 192, 24, 192, 24, 192, 24,
  224, 56, 96, 48, 112, 112, 63, 224, 15, 128, 13, 18, 36, 15, 1, 0,
  6, 64, 11, 64, 9, 128, 0, 0, 15, 128, 63, 224, 112, 112, 96, 48,
  224, 56, 192, 24, 192, 24, 192, 24, 192, 24, 224, 56, 96, 48, 112, 112,
  63, 224, 15, 128, 13, 17, 34, 15, 1, 0, 12, 192, 12, 192, 0, 0,
  15, 128, 63, 224, 112, 112, 96, 48, 224, 56, 192, 24, 192, 24, 192, 24,
  192, 24, 224, 56, 96, 48, 112, 112, 63, 224, 15, 128, 10, 9, 18, 10,
  0, 0, 192, 192, 97, 128, 51, 0, 30, 0, 12, 0, 30, 0, 51, 0,
  97, 128, 192, 192, 14, 14, 28, 15, 0, 0, 7, 204, 31, 248, 56, 48,
  48, 120, 112, 220, 97, 140, 99, 12, 98, 12, 102, 12, 108, 28, 56, 24,
  56, 56, 111, 240, 199, 192, 11, 18, 36, 14, 1, 0, 24, 0, 12, 0,
  6, 0, 0, 0, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96,
  192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 96, 192, 127, 192, 31, 0,
  11, 18, 36, 14, 1, 0, 3, 0, 6, 0, 12, 0, 0, 0, 192, 96,
  192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96,
  192, 96, 192, 96, 96, 192, 127, 192, 31, 0, 11, 18, 36, 14, 1, 0,
  6, 0, 15, 0, 25, 128, 0, 0, 192, 96, 192, 96, 192, 96, 192, 96,
  192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 96, 192,
  127, 192, 31, 0, 11, 17, 34, 14, 1, 0, 49, 128, 49, 128, 0, 0,
  192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96,
  192, 96, 192, 96, 192, 96, 96, 192, 127, 192, 31, 0, 12, 18, 36, 13,
  0, 0, 1, 128, 3, 0, 6, 0, 0, 0, 192, 48, 192, 48, 96, 96,
  96, 96, 48, 192, 57, 192, 25, 128, 15, 0, 6, 0, 6, 0, 6, 0,
  6, 0, 6, 0, 6, 0, 10, 14, 28, 12, 1, 0, 192, 0, 192, 0,
  192, 0, 255, 0, 255, 128, 193, 192, 192, 192, 192, 192, 193, 192, 255, 128,
  255, 0, 192, 0, 192, 0, 192, 0, 7, 14, 14, 9, 1, 0, 56, 124,
  198, 198, 198, 198, 220, 220, 198, 198, 198, 198, 222, 220, 9, 14, 28, 11,
  1, 0, 48, 0, 24, 0, 12, 0, 0, 0, 126, 0, 231, 0, 195, 0,
  7, 0, 127, 0, 227, 0, 195, 0, 195, 0, 231, 128, 121, 128, 9, 14,
  28, 11, 1, 0, 12, 0, 24, 0, 48, 0, 0, 0, 126, 0, 231, 0,
  195, 0, 7, 0, 127, 0, 227, 0, 195, 0, 195, 0, 231, 128, 121, 128,
  9, 14, 28, 11, 1, 0, 24, 0, 60, 0, 102, 0, 0, 0, 126, 0,
  231, 0, 195, 0, 7, 0, 127, 0, 227, 0, 195, 0, 195, 0, 231, 128,
  121, 128, 9, 14, 28, 11, 1, 0, 50, 0, 90, 0, 76, 0, 0, 0,
  126, 0, 231, 0, 195, 0, 7, 0, 127, 0, 227, 0, 195, 0, 195, 0,
  231, 128, 121, 128, 9, 14, 28, 11, 1, 0, 102, 0, 102, 0, 0, 0,
  0, 0, 126, 0, 231, 0, 195, 0, 7, 0, 127, 0, 227, 0, 195, 0,
  195, 0, 231, 128, 121, 128, 9, 14, 28, 11, 1, 0, 24, 0, 36, 0,
  36, 0, 24, 0, 126, 0, 231, 0, 195, 0, 7, 0, 127, 0, 227, 0,
  195, 0, 195, 0, 231, 128, 121, 128, 14, 10, 20, 17, 2, 0, 126, 240,
  231, 248, 195, 12, 7, 12, 127, 252, 227, 0, 195, 0, 195, 140, 231, 252,
  122, 240, 8, 14, 14, 10, 1, 252, 62, 127, 99, 192, 192, 192, 192, 99,
  127, 62, 24, 12, 108, 120, 8, 14, 14, 10, 1, 0, 48, 24, 12, 0,
  60, 126, 195, 195, 255, 192, 192, 227, 127, 60, 8, 14, 14, 10, 1, 0,
  12, 24, 48, 0, 60, 126, 195, 195, 255, 192, 192, 227, 127, 60, 8, 14,
  14, 10, 1, 0, 24, 60, 102, 0, 60, 126, 195, 195, 255, 192, 192, 227,
  127, 60, 8, 14, 14, 10, 1, 0, 102, 102, 0, 0, 60, 126, 195, 195,
  255, 192, 192, 227, 127, 60, 4, 14, 14, 4, 0, 0, 192, 96, 48, 0,
  96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 4, 14, 14, 4, 0, 0,
  48, 96, 192, 0, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 6, 14,
  14, 4, 255, 0, 48, 120, 204, 0, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 5, 14, 14, 4, 0, 0, 216, 216, 0, 0, 96, 96, 96, 96,
  96, 96, 96, 96, 96, 96, 9, 14, 28, 11, 1, 0, 96, 0, 54, 0,
  56, 0, 76, 0, 62, 0, 127, 0, 99, 0, 193, 128, 193, 128, 193, 128,
  193, 128, 99, 0, 127, 0, 62, 0, 8, 14, 14, 10, 1, 0, 50, 90,
  76, 0, 222, 255, 227, 195, 195, 195, 195, 195, 195, 195, 9, 14, 28, 11,
  1, 0, 48, 0, 24, 0, 12, 0, 0, 0, 62, 0, 127, 0, 99, 0,
  193, 128, 193, 128, 193, 128, 193, 128, 99, 0, 127, 0, 62, 0, 9, 14,
  28, 11, 1, 0, 6, 0, 12, 0, 24, 0, 0, 0, 62, 0, 127, 0,
  99, 0, 193, 128, 193, 128, 193, 128, 193, 128, 99, 0, 127, 0, 62, 0,
  9, 14, 28, 11, 1, 0, 24, 0, 60, 0, 102, 0, 0, 0, 62, 0,
  127, 0, 99, 0, 193, 128, 193, 128, 193, 128, 193, 128, 99, 0, 127, 0,
  62, 0, 9, 14, 28, 11, 1, 0, 50, 0, 90, 0, 76, 0, 0, 0,
  62, 0, 127, 0, 99, 0, 193, 128, 193, 128, 193, 128, 193, 128, 99, 0,
  127, 0, 62, 0, 9, 14, 28, 11, 1, 0, 51, 0, 51, 0, 0, 0,
  0, 0, 62, 0, 127, 0, 99, 0, 193, 128, 193, 128, 193, 128, 193, 128,
  99, 0, 127, 0, 62, 0, 8, 8, 8, 10, 1, 1, 24, 24, 0, 255,
  255, 0, 24, 24, 11, 10, 20, 11, 0, 0, 14, 96, 63, 192, 49, 128,
  99, 192, 102, 192, 108, 192, 120, 192, 49, 128, 127, 128, 206, 0, 8, 14,
  14, 10, 1, 0, 48, 24, 12, 0, 195, 195, 195, 195, 195, 195, 195, 199,
  255, 123, 8, 14, 14, 10, 1, 0, 6, 12, 24, 0, 195, 195, 195, 195,
  195, 195, 195, 199, 255, 123, 8, 14, 14, 10, 1, 0, 24, 60, 102, 0,
  195, 195, 195, 195, 195, 195, 195, 199, 255, 123, 8, 14, 14, 10, 1, 0,
  102, 102, 0, 0, 195, 195, 195, 195, 195, 195, 195, 199, 255, 123, 8, 18,
  18, 10, 1, 252, 6, 12, 24, 0, 195, 195, 195, 102, 102, 102, 36, 60,
  24, 24, 24, 24, 112, 112, 9, 18, 36, 11, 1, 252, 192, 0, 192, 0,
  192, 0, 192, 0, 222, 0, 255, 0, 227, 0, 193, 128, 193, 128, 193, 128,
  193, 128, 227, 0, 255, 0, 222, 0, 192, 0, 192, 0, 192, 0, 192, 0,
  8, 18, 18, 10, 1, 252, 102, 102, 0, 0, 195, 195, 195, 102, 102, 102,
  36, 60, 24, 24, 24, 24, 112, 112
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--20-140-100-100-P-100-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 0, '1' Height: 13
  Calculated Max Values w= 9 h=14 x= 2 y= 7 dx=10 dy= 0 ascent=14 len=26
  Font Bounding box     w=22 h=29 x=-2 y=-7
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =13 descent= 0
  X Font      ascent =13 descent= 0
  Max Font    ascent =14 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_helvR14n[311] U8G_FONT_SECTION("u8g_font_helvR14n") = {
  0, 22, 29, 254, 249, 13, 0, 0, 0, 0, 42, 58, 0, 14, 253, 13,
  0, 5, 7, 7, 7, 1, 7, 32, 168, 248, 32, 248, 168, 32, 8, 10,
  10, 10, 1, 0, 24, 24, 24, 24, 255, 255, 24, 24, 24, 24, 2, 5,
  5, 5, 1, 253, 192, 192, 64, 64, 128, 5, 1, 1, 6, 0, 5, 248,
  2, 2, 2, 5, 1, 0, 192, 192, 5, 14, 14, 5, 0, 0, 24, 24,
  24, 24, 48, 48, 48, 96, 96, 96, 192, 192, 192, 192, 8, 13, 13, 10,
  1, 0, 60, 126, 102, 195, 195, 195, 195, 195, 195, 195, 102, 126, 60, 5,
  13, 13, 10, 2, 0, 24, 248, 248, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 8, 13, 13, 10, 1, 0, 60, 254, 195, 3, 7, 14, 28, 56,
  112, 224, 192, 255, 255, 8, 13, 13, 10, 1, 0, 62, 127, 195, 195, 6,
  28, 30, 7, 3, 195, 199, 126, 60, 9, 13, 26, 10, 0, 0, 3, 0,
  7, 0, 15, 0, 27, 0, 51, 0, 51, 0, 99, 0, 195, 0, 255, 128,
  255, 128, 3, 0, 3, 0, 3, 0, 8, 13, 13, 10, 1, 0, 254, 254,
  192, 192, 252, 254, 199, 3, 3, 195, 199, 254, 124, 8, 13, 13, 10, 1,
  0, 60, 127, 99, 192, 192, 220, 254, 195, 195, 195, 227, 126, 60, 8, 13,
  13, 10, 1, 0, 255, 255, 3, 6, 12, 12, 24, 24, 48, 48, 96, 96,
  96, 8, 13, 13, 10, 1, 0, 60, 126, 231, 195, 195, 102, 126, 231, 195,
  195, 231, 126, 60, 8, 13, 13, 10, 1, 0, 60, 126, 199, 195, 195, 195,
  127, 59, 3, 3, 198, 254, 124, 2, 10, 10, 5, 1, 0, 192, 192, 0,
  0, 0, 0, 0, 0, 192, 192
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--20-140-100-100-P-100-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 14, '1' Height: 13
  Calculated Max Values w=16 h=18 x= 2 y=11 dx=18 dy= 0 ascent=14 len=34
  Font Bounding box     w=22 h=29 x=-2 y=-7
  Calculated Min Values           x=-1 y=-4 dx= 0 dy= 0
  Pure Font   ascent =14 descent=-4
  X Font      ascent =14 descent=-4
  Max Font    ascent =14 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_helvR14r[2281] U8G_FONT_SECTION("u8g_font_helvR14r") = {
  0, 22, 29, 254, 249, 14, 2, 149, 6, 82, 32, 127, 252, 14, 252, 14,
  252, 0, 0, 0, 5, 0, 1, 2, 14, 14, 6, 2, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 128, 128, 0, 0, 192, 192, 5, 5, 5, 5, 0,
  9, 216, 216, 216, 216, 216, 10, 13, 26, 10, 0, 0, 9, 0, 9, 0,
  9, 0, 127, 192, 127, 192, 18, 0, 18, 0, 18, 0, 255, 128, 255, 128,
  36, 0, 36, 0, 36, 0, 9, 16, 32, 10, 1, 254, 8, 0, 62, 0,
  127, 0, 203, 0, 200, 0, 232, 0, 120, 0, 62, 0, 15, 0, 9, 128,
  201, 128, 235, 128, 127, 0, 62, 0, 8, 0, 8, 0, 14, 13, 26, 16,
  1, 0, 120, 96, 204, 192, 204, 192, 205, 128, 205, 128, 123, 0, 3, 0,
  6, 120, 6, 204, 12, 204, 12, 204, 24, 204, 24, 120, 12, 13, 26, 13,
  1, 0, 60, 0, 126, 0, 102, 0, 102, 0, 60, 0, 124, 0, 238, 192,
  198, 192, 195, 192, 195, 128, 231, 192, 126, 224, 60, 112, 1, 5, 5, 3,
  1, 9, 128, 128, 128, 128, 128, 4, 18, 18, 6, 0, 252, 16, 48, 96,
  96, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 96, 96, 48, 16, 4,
  18, 18, 6, 1, 252, 128, 192, 96, 96, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 96, 96, 192, 128, 5, 7, 7, 7, 1, 7, 32, 168, 248,
  32, 248, 168, 32, 8, 10, 10, 10, 1, 0, 24, 24, 24, 24, 255, 255,
  24, 24, 24, 24, 2, 5, 5, 5, 1, 253, 192, 192, 64, 64, 128, 5,
  1, 1, 6, 0, 5, 248, 2, 2, 2, 5, 1, 0, 192, 192, 5, 14,
  14, 5, 0, 0, 24, 24, 24, 24, 48, 48, 48, 96, 96, 96, 192, 192,
  192, 192, 8, 13, 13, 10, 1, 0, 60, 126, 102, 195, 195, 195, 195, 195,
  195, 195, 102, 126, 60, 5, 13, 13, 10, 2, 0, 24, 248, 248, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 8, 13, 13, 10, 1, 0, 60, 254,
  195, 3, 7, 14, 28, 56, 112, 224, 192, 255, 255, 8, 13, 13, 10, 1,
  0, 62, 127, 195, 195, 6, 28, 30, 7, 3, 195, 199, 126, 60, 9, 13,
  26, 10, 0, 0, 3, 0, 7, 0, 15, 0, 27, 0, 51, 0, 51, 0,
  99, 0, 195, 0, 255, 128, 255, 128, 3, 0, 3, 0, 3, 0, 8, 13,
  13, 10, 1, 0, 254, 254, 192, 192, 252, 254, 199, 3, 3, 195, 199, 254,
  124, 8, 13, 13, 10, 1, 0, 60, 127, 99, 192, 192, 220, 254, 195, 195,
  195, 227, 126, 60, 8, 13, 13, 10, 1, 0, 255, 255, 3, 6, 12, 12,
  24, 24, 48, 48, 96, 96, 96, 8, 13, 13, 10, 1, 0, 60, 126, 231,
  195, 195, 102, 126, 231, 195, 195, 231, 126, 60, 8, 13, 13, 10, 1, 0,
  60, 126, 199, 195, 195, 195, 127, 59, 3, 3, 198, 254, 124, 2, 10, 10,
  5, 1, 0, 192, 192, 0, 0, 0, 0, 0, 0, 192, 192, 2, 13, 13,
  5, 1, 253, 192, 192, 0, 0, 0, 0, 0, 0, 192, 192, 64, 64, 128,
  8, 9, 9, 10, 1, 0, 3, 15, 60, 112, 192, 112, 60, 15, 3, 7,
  5, 5, 11, 2, 2, 254, 254, 0, 254, 254, 8, 9, 9, 10, 1, 0,
  192, 240, 60, 14, 3, 14, 60, 240, 192, 7, 14, 14, 10, 1, 0, 124,
  254, 198, 198, 14, 28, 56, 48, 48, 48, 0, 0, 48, 48, 16, 17, 34,
  18, 1, 253, 3, 240, 15, 252, 28, 14, 48, 6, 99, 211, 103, 115, 198,
  51, 204, 99, 204, 102, 204, 102, 204, 204, 207, 248, 103, 112, 112, 0, 56,
  0, 31, 240, 7, 224, 12, 14, 28, 13, 0, 0, 6, 0, 6, 0, 15,
  0, 15, 0, 25, 128, 25, 128, 48, 192, 48, 192, 63, 192, 127, 224, 96,
  96, 96, 96, 192, 48, 192, 48, 11, 14, 28, 13, 1, 0, 255, 0, 255,
  128, 193, 192, 192, 192, 192, 192, 193, 128, 255, 128, 255, 192, 192, 224, 192,
  96, 192, 96, 192, 224, 255, 192, 255, 128, 12, 14, 28, 14, 1, 0, 15,
  128, 63, 224, 112, 112, 96, 48, 224, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 224, 0, 96, 48, 112, 112, 63, 224, 15, 128, 12, 14, 28, 14, 1,
  0, 255, 128, 255, 192, 192, 224, 192, 96, 192, 48, 192, 48, 192, 48, 192,
  48, 192, 48, 192, 48, 192, 96, 192, 224, 255, 192, 255, 128, 10, 14, 28,
  13, 2, 0, 255, 192, 255, 192, 192, 0, 192, 0, 192, 0, 192, 0, 255,
  128, 255, 128, 192, 0, 192, 0, 192, 0, 192, 0, 255, 192, 255, 192, 9,
  14, 28, 12, 2, 0, 255, 128, 255, 128, 192, 0, 192, 0, 192, 0, 192,
  0, 255, 0, 255, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 13, 14, 28, 15, 1, 0, 15, 192, 63, 240, 112, 56, 96, 24, 224,
  24, 192, 0, 192, 0, 192, 248, 192, 248, 224, 24, 96, 24, 112, 56, 63,
  248, 15, 216, 11, 14, 28, 14, 1, 0, 192, 96, 192, 96, 192, 96, 192,
  96, 192, 96, 192, 96, 255, 224, 255, 224, 192, 96, 192, 96, 192, 96, 192,
  96, 192, 96, 192, 96, 2, 14, 14, 6, 2, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 8, 14, 14, 10, 0, 0, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 195, 195, 231, 126, 60, 12, 14, 28,
  13, 2, 0, 192, 224, 193, 192, 195, 128, 199, 0, 206, 0, 220, 0, 248,
  0, 252, 0, 206, 0, 199, 0, 195, 128, 193, 192, 192, 224, 192, 112, 9,
  14, 28, 11, 1, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 128, 255,
  128, 14, 14, 28, 16, 1, 0, 192, 12, 192, 12, 224, 28, 224, 28, 240,
  60, 240, 60, 216, 108, 216, 108, 204, 204, 204, 204, 196, 140, 199, 140, 195,
  12, 195, 12, 11, 14, 28, 14, 1, 0, 192, 96, 224, 96, 240, 96, 240,
  96, 216, 96, 204, 96, 204, 96, 198, 96, 198, 96, 195, 96, 193, 224, 193,
  224, 192, 224, 192, 96, 13, 14, 28, 15, 1, 0, 15, 128, 63, 224, 112,
  112, 96, 48, 224, 56, 192, 24, 192, 24, 192, 24, 192, 24, 224, 56, 96,
  48, 112, 112, 63, 224, 15, 128, 10, 14, 28, 13, 2, 0, 255, 0, 255,
  128, 193, 192, 192, 192, 192, 192, 193, 192, 255, 128, 255, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 13, 15, 30, 15, 1, 255, 15,
  128, 63, 224, 112, 112, 96, 48, 224, 56, 192, 24, 192, 24, 192, 24, 192,
  24, 225, 184, 97, 176, 112, 240, 63, 224, 15, 176, 0, 48, 11, 14, 28,
  14, 1, 0, 255, 128, 255, 192, 192, 224, 192, 96, 192, 96, 192, 224, 255,
  192, 255, 128, 192, 192, 192, 192, 192, 96, 192, 96, 192, 96, 192, 96, 10,
  14, 28, 13, 1, 0, 30, 0, 127, 128, 225, 192, 192, 192, 224, 0, 124,
  0, 31, 0, 3, 128, 1, 192, 0, 192, 192, 192, 225, 192, 127, 128, 63,
  0, 10, 14, 28, 12, 1, 0, 255, 192, 255, 192, 12, 0, 12, 0, 12,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12,
  0, 12, 0, 11, 14, 28, 14, 1, 0, 192, 96, 192, 96, 192, 96, 192,
  96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 96,
  192, 127, 192, 31, 0, 12, 14, 28, 13, 0, 0, 192, 48, 192, 48, 96,
  96, 96, 96, 96, 96, 48, 192, 48, 192, 48, 192, 25, 128, 25, 128, 25,
  128, 15, 0, 15, 0, 6, 0, 16, 14, 28, 18, 1, 0, 193, 131, 193,
  131, 193, 131, 195, 195, 99, 198, 98, 70, 102, 102, 102, 102, 54, 108, 54,
  108, 52, 44, 28, 56, 24, 24, 24, 24, 11, 14, 28, 13, 1, 0, 192,
  96, 192, 96, 96, 192, 113, 192, 49, 128, 27, 0, 14, 0, 14, 0, 27,
  0, 49, 128, 113, 192, 96, 192, 192, 96, 192, 96, 12, 14, 28, 13, 0,
  0, 192, 48, 192, 48, 96, 96, 96, 96, 48, 192, 57, 192, 25, 128, 15,
  0, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 10, 14, 28,
  12, 1, 0, 255, 192, 255, 192, 0, 192, 1, 128, 3, 0, 6, 0, 12,
  0, 28, 0, 24, 0, 48, 0, 96, 0, 192, 0, 255, 192, 255, 192, 4,
  18, 18, 5, 0, 252, 240, 240, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 240, 240, 5, 14, 14, 5, 0, 0, 192, 192, 192,
  96, 96, 96, 48, 48, 48, 48, 24, 24, 24, 24, 4, 18, 18, 5, 0,
  252, 240, 240, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 240, 240, 7, 6, 6, 9, 1, 7, 16, 56, 108, 108, 198, 198, 11,
  2, 4, 11, 0, 252, 255, 224, 255, 224, 4, 3, 3, 4, 0, 11, 192,
  96, 48, 9, 10, 20, 11, 1, 0, 126, 0, 231, 0, 195, 0, 7, 0,
  127, 0, 227, 0, 195, 0, 195, 0, 231, 128, 121, 128, 9, 14, 28, 11,
  1, 0, 192, 0, 192, 0, 192, 0, 192, 0, 222, 0, 255, 0, 227, 0,
  193, 128, 193, 128, 193, 128, 193, 128, 227, 0, 255, 0, 222, 0, 8, 10,
  10, 10, 1, 0, 62, 127, 99, 192, 192, 192, 192, 99, 127, 62, 9, 14,
  28, 11, 1, 0, 1, 128, 1, 128, 1, 128, 1, 128, 61, 128, 127, 128,
  99, 128, 193, 128, 193, 128, 193, 128, 193, 128, 99, 128, 127, 128, 61, 128,
  8, 10, 10, 10, 1, 0, 60, 126, 195, 195, 255, 192, 192, 227, 127, 60,
  6, 14, 14, 6, 0, 0, 28, 60, 48, 48, 252, 252, 48, 48, 48, 48,
  48, 48, 48, 48, 9, 14, 28, 11, 1, 252, 61, 128, 127, 128, 97, 128,
  193, 128, 193, 128, 193, 128, 193, 128, 99, 128, 127, 128, 61, 128, 1, 128,
  99, 0, 127, 0, 28, 0, 8, 14, 14, 10, 1, 0, 192, 192, 192, 192,
  222, 255, 227, 195, 195, 195, 195, 195, 195, 195, 2, 14, 14, 4, 1, 0,
  192, 192, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 4, 18,
  18, 4, 255, 252, 48, 48, 0, 0, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 240, 224, 8, 14, 14, 9, 1, 0, 192, 192, 192, 192,
  198, 204, 216, 240, 248, 216, 204, 206, 198, 199, 2, 14, 14, 4, 1, 0,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 14, 10,
  20, 16, 1, 0, 222, 120, 255, 252, 227, 140, 195, 12, 195, 12, 195, 12,
  195, 12, 195, 12, 195, 12, 195, 12, 8, 10, 10, 10, 1, 0, 222, 255,
  227, 195, 195, 195, 195, 195, 195, 195, 9, 10, 20, 11, 1, 0, 62, 0,
  127, 0, 99, 0, 193, 128, 193, 128, 193, 128, 193, 128, 99, 0, 127, 0,
  62, 0, 9, 14, 28, 11, 1, 252, 222, 0, 255, 0, 227, 0, 193, 128,
  193, 128, 193, 128, 193, 128, 227, 0, 255, 0, 222, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 9, 14, 28, 11, 1, 252, 61, 128, 127, 128, 99, 128,
  193, 128, 193, 128, 193, 128, 193, 128, 99, 128, 127, 128, 61, 128, 1, 128,
  1, 128, 1, 128, 1, 128, 5, 10, 10, 6, 1, 0, 216, 216, 224, 192,
  192, 192, 192, 192, 192, 192, 7, 10, 10, 9, 1, 0, 60, 126, 198, 192,
  252, 62, 6, 198, 252, 120, 6, 13, 13, 6, 0, 0, 48, 48, 48, 252,
  252, 48, 48, 48, 48, 48, 48, 60, 28, 8, 10, 10, 10, 1, 0, 195,
  195, 195, 195, 195, 195, 195, 199, 255, 123, 8, 10, 10, 10, 1, 0, 195,
  195, 195, 102, 102, 102, 36, 60, 24, 24, 12, 10, 20, 14, 1, 0, 198,
  48, 198, 48, 198, 48, 102, 96, 102, 96, 105, 96, 41, 64, 57, 192, 25,
  128, 25, 128, 8, 10, 10, 10, 1, 0, 195, 231, 102, 60, 24, 24, 60,
  102, 231, 195, 8, 14, 14, 10, 1, 252, 195, 195, 195, 102, 102, 102, 36,
  60, 24, 24, 24, 24, 112, 112, 7, 10, 10, 9, 1, 0, 254, 254, 6,
  12, 24, 48, 96, 192, 254, 254, 6, 18, 18, 6, 255, 252, 12, 24, 48,
  48, 48, 48, 48, 96, 192, 96, 48, 48, 48, 48, 48, 48, 24, 12, 2,
  18, 18, 5, 1, 252, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 6, 18, 18, 6, 0, 252, 192, 96, 48,
  48, 48, 48, 48, 24, 12, 24, 48, 48, 48, 48, 48, 48, 96, 192, 8,
  3, 3, 10, 1, 4, 115, 255, 206, 255
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--25-180-100-100-P-130-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 19, '1' Height: 18
  Calculated Max Values w=22 h=24 x= 3 y=16 dx=25 dy= 0 ascent=24 len=69
  Font Bounding box     w=28 h=37 x=-3 y=-8
  Calculated Min Values           x=-1 y=-5 dx= 0 dy= 0
  Pure Font   ascent =19 descent=-5
  X Font      ascent =19 descent=-5
  Max Font    ascent =24 descent=-5
*/
const u8g_fntpgm_uint8_t u8g_font_helvR18[7307] U8G_FONT_SECTION("u8g_font_helvR18") = {
  0, 28, 37, 253, 248, 19, 4, 37, 9, 49, 32, 255, 251, 24, 251, 19,
  251, 0, 0, 0, 6, 0, 1, 2, 19, 19, 6, 2, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 128, 128, 0, 0, 192, 192, 192,
  6, 6, 6, 8, 1, 13, 204, 204, 204, 204, 204, 68, 11, 17, 34, 14,
  2, 0, 12, 192, 12, 192, 12, 192, 25, 128, 255, 224, 255, 224, 25, 128,
  25, 128, 51, 0, 51, 0, 255, 224, 255, 224, 51, 0, 51, 0, 102, 0,
  102, 0, 102, 0, 11, 22, 44, 13, 1, 254, 6, 0, 6, 0, 31, 128,
  63, 192, 118, 224, 102, 96, 102, 96, 102, 0, 118, 0, 62, 0, 62, 0,
  15, 128, 7, 192, 6, 224, 6, 96, 198, 96, 198, 96, 230, 224, 127, 192,
  63, 128, 6, 0, 6, 0, 19, 18, 54, 22, 1, 0, 0, 6, 0, 60,
  12, 0, 126, 12, 0, 195, 24, 0, 195, 24, 0, 195, 48, 0, 195, 48,
  0, 126, 96, 0, 60, 96, 0, 0, 192, 0, 0, 199, 128, 1, 143, 192,
  1, 152, 96, 3, 24, 96, 3, 24, 96, 6, 24, 96, 6, 15, 192, 4,
  7, 128, 14, 18, 36, 17, 2, 0, 15, 0, 31, 128, 57, 192, 48, 192,
  48, 192, 48, 192, 25, 128, 15, 0, 30, 0, 63, 24, 115, 152, 97, 216,
  192, 240, 192, 96, 192, 240, 225, 216, 127, 156, 30, 0, 2, 6, 6, 6,
  2, 13, 192, 192, 192, 192, 192, 64, 5, 24, 24, 8, 2, 251, 24, 24,
  48, 48, 96, 96, 96, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 96,
  96, 96, 48, 48, 24, 24, 5, 24, 24, 8, 1, 251, 192, 192, 96, 96,
  48, 48, 48, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 48, 48, 48,
  96, 96, 192, 192, 7, 7, 7, 10, 1, 12, 16, 16, 214, 124, 56, 108,
  68, 12, 12, 24, 14, 1, 1, 6, 0, 6, 0, 6, 0, 6, 0, 6,
  0, 255, 240, 255, 240, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 2,
  6, 6, 6, 2, 253, 192, 192, 192, 64, 64, 128, 6, 2, 2, 8, 1,
  6, 252, 252, 2, 3, 3, 6, 2, 0, 192, 192, 192, 7, 19, 19, 7,
  0, 0, 6, 4, 12, 12, 8, 24, 24, 16, 16, 48, 48, 32, 96, 96,
  64, 192, 192, 128, 128, 11, 18, 36, 13, 1, 0, 31, 0, 63, 128, 113,
  192, 96, 192, 96, 192, 224, 224, 192, 96, 192, 96, 192, 96, 192, 96, 192,
  96, 192, 96, 224, 224, 96, 192, 96, 192, 113, 192, 63, 128, 31, 0, 6,
  18, 18, 13, 2, 0, 12, 12, 28, 252, 252, 12, 12, 12, 12, 12, 12,
  12, 12, 12, 12, 12, 12, 12, 11, 18, 36, 13, 1, 0, 30, 0, 127,
  128, 97, 192, 192, 192, 192, 96, 192, 96, 0, 224, 0, 192, 1, 192, 3,
  128, 15, 0, 28, 0, 56, 0, 112, 0, 224, 0, 192, 0, 255, 224, 255,
  224, 11, 18, 36, 13, 1, 0, 31, 0, 127, 128, 97, 128, 192, 192, 192,
  192, 192, 192, 0, 192, 1, 128, 15, 0, 15, 192, 0, 192, 0, 96, 0,
  96, 192, 96, 192, 192, 97, 192, 127, 128, 31, 0, 11, 18, 36, 13, 1,
  0, 1, 128, 3, 128, 3, 128, 7, 128, 15, 128, 13, 128, 25, 128, 57,
  128, 49, 128, 97, 128, 225, 128, 193, 128, 255, 224, 255, 224, 1, 128, 1,
  128, 1, 128, 1, 128, 11, 18, 36, 13, 1, 0, 127, 192, 127, 192, 96,
  0, 96, 0, 96, 0, 96, 0, 126, 0, 127, 128, 113, 192, 0, 192, 0,
  224, 0, 96, 0, 96, 192, 224, 192, 192, 225, 192, 127, 128, 30, 0, 11,
  18, 36, 13, 1, 0, 15, 0, 63, 192, 112, 192, 96, 96, 224, 96, 192,
  0, 192, 0, 207, 0, 223, 128, 241, 192, 224, 192, 192, 96, 192, 96, 192,
  96, 224, 224, 113, 192, 127, 192, 31, 0, 11, 18, 36, 13, 1, 0, 255,
  224, 255, 224, 0, 224, 0, 192, 1, 128, 1, 128, 3, 0, 3, 0, 6,
  0, 6, 0, 12, 0, 12, 0, 28, 0, 24, 0, 24, 0, 56, 0, 48,
  0, 48, 0, 11, 18, 36, 13, 1, 0, 14, 0, 63, 128, 49, 128, 96,
  192, 96, 192, 96, 192, 49, 128, 31, 0, 63, 128, 113, 192, 96, 192, 192,
  96, 192, 96, 192, 96, 192, 96, 96, 192, 127, 192, 31, 0, 11, 18, 36,
  13, 1, 0, 31, 0, 127, 192, 113, 192, 224, 192, 192, 96, 192, 96, 192,
  96, 192, 96, 224, 224, 113, 224, 127, 96, 30, 96, 0, 96, 0, 224, 192,
  192, 225, 192, 127, 128, 30, 0, 2, 14, 14, 6, 2, 0, 192, 192, 192,
  0, 0, 0, 0, 0, 0, 0, 0, 192, 192, 192, 2, 17, 17, 6, 2,
  253, 192, 192, 192, 0, 0, 0, 0, 0, 0, 0, 0, 192, 192, 192, 64,
  64, 128, 12, 12, 24, 15, 1, 1, 0, 48, 0, 240, 3, 192, 15, 0,
  60, 0, 224, 0, 224, 0, 60, 0, 15, 0, 3, 192, 0, 240, 0, 48,
  10, 5, 10, 15, 2, 5, 255, 192, 255, 192, 0, 0, 255, 192, 255, 192,
  12, 12, 24, 15, 1, 1, 192, 0, 240, 0, 60, 0, 15, 0, 3, 192,
  0, 112, 0, 112, 3, 192, 15, 0, 60, 0, 240, 0, 192, 0, 10, 19,
  38, 12, 1, 0, 31, 0, 127, 128, 113, 192, 224, 192, 192, 192, 193, 192,
  1, 128, 3, 128, 7, 0, 6, 0, 12, 0, 12, 0, 12, 0, 12, 0,
  0, 0, 0, 0, 12, 0, 12, 0, 12, 0, 22, 23, 69, 25, 2, 252,
  0, 255, 0, 3, 255, 192, 15, 1, 224, 28, 0, 112, 56, 0, 24, 48,
  0, 24, 96, 115, 12, 96, 251, 12, 193, 199, 12, 195, 134, 12, 195, 6,
  12, 198, 6, 12, 198, 12, 28, 198, 12, 24, 198, 12, 56, 231, 28, 112,
  99, 247, 224, 113, 227, 128, 56, 0, 0, 28, 0, 0, 15, 3, 0, 7,
  255, 0, 0, 252, 0, 15, 19, 38, 17, 1, 0, 3, 128, 3, 128, 6,
  192, 6, 192, 12, 64, 12, 96, 12, 96, 24, 48, 24, 48, 24, 48, 48,
  24, 63, 248, 63, 248, 96, 12, 96, 12, 96, 12, 192, 6, 192, 6, 192,
  6, 14, 19, 38, 17, 2, 0, 255, 192, 255, 240, 192, 112, 192, 24, 192,
  24, 192, 24, 192, 24, 192, 48, 255, 224, 255, 240, 192, 24, 192, 12, 192,
  12, 192, 12, 192, 12, 192, 28, 192, 120, 255, 240, 255, 192, 15, 19, 38,
  18, 1, 0, 7, 224, 31, 248, 60, 60, 112, 14, 96, 6, 224, 6, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 224, 6, 96,
  6, 112, 14, 60, 60, 31, 248, 7, 224, 15, 19, 38, 18, 2, 0, 255,
  192, 255, 240, 192, 120, 192, 28, 192, 12, 192, 14, 192, 6, 192, 6, 192,
  6, 192, 6, 192, 6, 192, 6, 192, 6, 192, 14, 192, 12, 192, 28, 192,
  120, 255, 240, 255, 192, 12, 19, 38, 16, 2, 0, 255, 240, 255, 240, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 224, 255, 224, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 240, 255,
  240, 11, 19, 38, 14, 2, 0, 255, 224, 255, 224, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 255, 192, 255, 192, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 16, 19, 38,
  19, 1, 0, 7, 224, 31, 248, 60, 60, 112, 14, 96, 6, 224, 6, 192,
  0, 192, 0, 192, 0, 192, 127, 192, 127, 192, 3, 192, 3, 224, 3, 96,
  7, 112, 15, 60, 63, 31, 251, 7, 227, 14, 19, 38, 18, 2, 0, 192,
  12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 255,
  252, 255, 252, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192,
  12, 192, 12, 192, 12, 2, 19, 19, 8, 3, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 10, 19,
  38, 13, 1, 0, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 97, 128, 127, 128, 63, 0, 13, 19, 38, 18, 3, 0,
  192, 56, 192, 112, 192, 224, 193, 192, 195, 128, 199, 0, 206, 0, 220, 0,
  252, 0, 254, 0, 231, 0, 195, 128, 193, 128, 193, 192, 192, 224, 192, 96,
  192, 112, 192, 56, 192, 24, 11, 19, 38, 14, 2, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 224,
  255, 224, 17, 19, 57, 21, 2, 0, 192, 1, 128, 224, 3, 128, 224, 3,
  128, 240, 7, 128, 240, 7, 128, 216, 13, 128, 216, 13, 128, 216, 13, 128,
  204, 25, 128, 204, 25, 128, 204, 25, 128, 198, 49, 128, 198, 49, 128, 198,
  49, 128, 195, 97, 128, 195, 97, 128, 195, 97, 128, 193, 193, 128, 193, 193,
  128, 14, 19, 38, 18, 2, 0, 224, 12, 240, 12, 240, 12, 216, 12, 220,
  12, 204, 12, 206, 12, 198, 12, 199, 12, 195, 12, 195, 140, 193, 140, 193,
  204, 192, 204, 192, 236, 192, 108, 192, 60, 192, 60, 192, 28, 16, 19, 38,
  18, 1, 0, 7, 224, 31, 248, 60, 60, 112, 14, 96, 6, 224, 7, 192,
  3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 224, 7, 96,
  6, 112, 14, 60, 60, 31, 248, 7, 224, 13, 19, 38, 16, 2, 0, 255,
  224, 255, 240, 192, 48, 192, 24, 192, 24, 192, 24, 192, 24, 192, 48, 255,
  240, 255, 224, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 16, 19, 38, 18, 1, 0, 7, 224, 31, 248, 60,
  60, 112, 14, 96, 6, 224, 7, 192, 3, 192, 3, 192, 3, 192, 3, 192,
  3, 192, 3, 192, 3, 224, 7, 96, 230, 112, 126, 60, 28, 31, 254, 7,
  231, 13, 19, 38, 17, 2, 0, 255, 224, 255, 240, 192, 48, 192, 24, 192,
  24, 192, 24, 192, 24, 192, 48, 255, 240, 255, 224, 192, 112, 192, 48, 192,
  24, 192, 24, 192, 24, 192, 24, 192, 24, 192, 24, 192, 24, 13, 19, 38,
  16, 2, 0, 15, 128, 63, 224, 96, 96, 192, 48, 192, 48, 192, 0, 224,
  0, 124, 0, 63, 128, 7, 224, 0, 240, 0, 56, 0, 24, 0, 24, 192,
  24, 192, 56, 240, 112, 127, 224, 31, 128, 14, 19, 38, 16, 1, 0, 255,
  252, 255, 252, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3,
  0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3,
  0, 3, 0, 3, 0, 14, 19, 38, 18, 2, 0, 192, 12, 192, 12, 192,
  12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192,
  12, 192, 12, 192, 12, 192, 12, 192, 12, 96, 24, 112, 56, 63, 240, 15,
  192, 15, 19, 38, 17, 1, 0, 192, 6, 192, 6, 224, 14, 96, 12, 112,
  28, 48, 24, 48, 24, 56, 56, 24, 48, 24, 48, 28, 112, 12, 96, 12,
  96, 14, 224, 6, 192, 6, 192, 3, 128, 3, 128, 3, 128, 20, 19, 57,
  22, 1, 0, 192, 96, 48, 192, 96, 48, 192, 96, 48, 192, 240, 48, 96,
  240, 96, 97, 152, 96, 97, 152, 96, 97, 152, 96, 97, 152, 96, 49, 152,
  192, 51, 12, 192, 51, 12, 192, 51, 12, 192, 27, 13, 128, 27, 13, 128,
  30, 7, 128, 14, 7, 0, 12, 3, 0, 12, 3, 0, 15, 19, 38, 17,
  1, 0, 192, 6, 224, 14, 112, 28, 48, 24, 24, 48, 28, 112, 14, 224,
  7, 192, 3, 128, 3, 128, 7, 192, 14, 224, 12, 96, 28, 112, 56, 56,
  48, 24, 96, 12, 224, 14, 192, 6, 14, 19, 38, 16, 1, 0, 192, 12,
  224, 28, 96, 24, 112, 56, 48, 48, 56, 112, 24, 96, 28, 224, 12, 192,
  15, 192, 7, 128, 7, 128, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0,
  3, 0, 3, 0, 13, 19, 38, 15, 1, 0, 255, 248, 255, 248, 0, 56,
  0, 112, 0, 224, 1, 192, 1, 192, 3, 128, 7, 0, 7, 0, 14, 0,
  28, 0, 28, 0, 56, 0, 112, 0, 112, 0, 224, 0, 255, 248, 255, 248,
  4, 24, 24, 7, 2, 251, 240, 240, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 240, 240, 8, 19,
  19, 7, 0, 0, 192, 64, 64, 96, 32, 32, 48, 16, 16, 16, 24, 8,
  8, 12, 4, 4, 6, 2, 3, 4, 24, 24, 7, 1, 251, 240, 240, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 240, 240, 10, 9, 18, 12, 1, 10, 12, 0, 12, 0, 30,
  0, 18, 0, 51, 0, 97, 128, 97, 128, 192, 192, 192, 192, 14, 2, 4,
  14, 0, 251, 255, 252, 255, 252, 5, 4, 4, 7, 1, 15, 192, 96, 48,
  24, 11, 14, 28, 13, 1, 0, 31, 0, 63, 128, 97, 192, 96, 192, 0,
  192, 7, 192, 63, 192, 120, 192, 224, 192, 192, 192, 193, 192, 227, 192, 126,
  224, 60, 96, 11, 19, 38, 14, 2, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 207, 0, 223, 128, 241, 192, 224, 192, 192, 224, 192, 96, 192,
  96, 192, 96, 192, 96, 192, 224, 224, 192, 241, 192, 223, 128, 207, 0, 10,
  14, 28, 12, 1, 0, 31, 0, 63, 128, 113, 192, 96, 192, 224, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 224, 0, 96, 192, 113, 192, 63, 128, 31,
  0, 11, 19, 38, 14, 1, 0, 0, 96, 0, 96, 0, 96, 0, 96, 0,
  96, 30, 96, 63, 96, 113, 224, 96, 224, 224, 96, 192, 96, 192, 96, 192,
  96, 192, 96, 224, 96, 96, 224, 113, 224, 63, 96, 30, 96, 11, 14, 28,
  13, 1, 0, 14, 0, 63, 128, 113, 192, 96, 192, 192, 96, 192, 96, 255,
  224, 255, 224, 192, 0, 192, 0, 96, 96, 112, 224, 63, 192, 15, 0, 6,
  19, 19, 8, 1, 0, 28, 60, 48, 48, 48, 252, 252, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 11, 19, 38, 14, 1, 251, 30, 96,
  63, 96, 113, 224, 96, 224, 224, 96, 192, 96, 192, 96, 192, 96, 192, 96,
  224, 96, 96, 224, 113, 224, 63, 96, 30, 96, 0, 96, 192, 96, 224, 192,
  127, 192, 31, 0, 10, 19, 38, 13, 2, 0, 192, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 206, 0, 223, 128, 241, 128, 224, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  2, 19, 19, 6, 2, 0, 192, 192, 192, 0, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 4, 24, 24, 6, 0, 251, 48,
  48, 48, 0, 0, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 240, 224, 10, 19, 38, 12, 2, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 193, 128, 195, 128, 199, 0, 206, 0, 220,
  0, 248, 0, 252, 0, 206, 0, 198, 0, 199, 0, 195, 128, 193, 128, 193,
  192, 192, 192, 2, 19, 19, 6, 2, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 16, 14, 28, 20,
  2, 0, 206, 60, 255, 126, 227, 199, 193, 131, 193, 131, 193, 131, 193, 131,
  193, 131, 193, 131, 193, 131, 193, 131, 193, 131, 193, 131, 193, 131, 10, 14,
  28, 14, 2, 0, 206, 0, 223, 128, 241, 128, 224, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  11, 14, 28, 13, 1, 0, 31, 0, 63, 128, 113, 192, 96, 192, 224, 224,
  192, 96, 192, 96, 192, 96, 192, 96, 224, 224, 96, 192, 113, 192, 63, 128,
  31, 0, 11, 19, 38, 14, 2, 251, 207, 0, 223, 128, 241, 192, 224, 192,
  192, 224, 192, 96, 192, 96, 192, 96, 192, 96, 192, 224, 224, 192, 241, 192,
  223, 128, 207, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 11, 19,
  38, 14, 1, 251, 30, 96, 63, 96, 113, 224, 96, 224, 224, 96, 192, 96,
  192, 96, 192, 96, 192, 96, 224, 96, 96, 224, 113, 224, 63, 96, 30, 96,
  0, 96, 0, 96, 0, 96, 0, 96, 0, 96, 6, 14, 14, 9, 2, 0,
  204, 220, 248, 240, 224, 192, 192, 192, 192, 192, 192, 192, 192, 192, 10, 14,
  28, 12, 1, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 0, 248, 0,
  127, 0, 15, 128, 1, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0,
  6, 18, 18, 8, 1, 0, 48, 48, 48, 48, 252, 252, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 60, 28, 10, 14, 28, 14, 2, 0, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 193, 192, 99, 192, 126, 192, 28, 192, 11, 14, 28, 13, 1, 0,
  192, 96, 192, 96, 192, 96, 96, 192, 96, 192, 113, 192, 49, 128, 49, 128,
  27, 0, 27, 0, 27, 0, 14, 0, 14, 0, 14, 0, 18, 14, 42, 18,
  0, 0, 192, 192, 192, 192, 192, 192, 97, 225, 128, 97, 225, 128, 97, 225,
  128, 49, 35, 0, 51, 51, 0, 51, 51, 0, 27, 54, 0, 26, 22, 0,
  30, 30, 0, 14, 28, 0, 12, 12, 0, 12, 12, 0, 10, 14, 28, 12,
  1, 0, 192, 192, 225, 192, 97, 128, 51, 0, 30, 0, 30, 0, 12, 0,
  30, 0, 30, 0, 51, 0, 115, 128, 97, 128, 192, 192, 192, 192, 12, 19,
  38, 13, 0, 251, 192, 48, 192, 48, 96, 48, 112, 96, 48, 96, 56, 224,
  24, 192, 24, 192, 13, 128, 13, 128, 7, 128, 7, 0, 3, 0, 3, 0,
  6, 0, 6, 0, 12, 0, 60, 0, 56, 0, 10, 14, 28, 12, 1, 0,
  255, 192, 255, 192, 1, 128, 3, 0, 7, 0, 14, 0, 12, 0, 28, 0,
  56, 0, 48, 0, 96, 0, 224, 0, 255, 192, 255, 192, 6, 24, 24, 8,
  1, 251, 12, 24, 48, 48, 48, 48, 48, 48, 48, 48, 96, 192, 192, 96,
  48, 48, 48, 48, 48, 48, 48, 48, 24, 12, 1, 24, 24, 6, 2, 251,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 6, 24, 24, 8, 1, 251, 192, 96,
  48, 48, 48, 48, 48, 48, 48, 48, 24, 12, 12, 24, 48, 48, 48, 48,
  48, 48, 48, 48, 96, 192, 10, 4, 8, 14, 2, 5, 112, 192, 252, 192,
  207, 192, 195, 128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 0, 0, 0, 6, 0, 1, 2, 19, 19, 6, 2,
  251, 192, 192, 192, 0, 0, 64, 64, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 10, 18, 36, 13, 1, 254, 1, 128, 1, 128, 31, 0,
  63, 128, 115, 192, 102, 192, 198, 0, 204, 0, 204, 0, 204, 0, 216, 0,
  216, 0, 216, 192, 113, 192, 127, 128, 63, 0, 96, 0, 96, 0, 12, 18,
  36, 14, 1, 0, 31, 128, 63, 224, 112, 112, 96, 48, 96, 0, 112, 0,
  48, 0, 24, 0, 255, 128, 255, 128, 24, 0, 24, 0, 24, 0, 48, 0,
  48, 0, 103, 48, 255, 240, 240, 224, 11, 12, 24, 13, 1, 3, 192, 96,
  238, 224, 127, 192, 49, 128, 96, 192, 96, 192, 96, 192, 96, 192, 49, 128,
  127, 192, 238, 224, 192, 96, 14, 18, 36, 14, 0, 0, 224, 28, 96, 24,
  112, 56, 48, 48, 56, 112, 24, 96, 28, 224, 12, 192, 63, 240, 63, 240,
  3, 0, 63, 240, 63, 240, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0,
  2, 24, 24, 6, 2, 251, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  0, 0, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 11, 24,
  48, 13, 1, 251, 31, 0, 63, 128, 113, 192, 96, 192, 112, 192, 56, 0,
  28, 0, 126, 0, 231, 0, 195, 128, 193, 192, 192, 192, 96, 96, 112, 96,
  56, 96, 28, 192, 15, 128, 7, 0, 3, 128, 97, 192, 96, 192, 113, 192,
  63, 128, 31, 0, 6, 2, 2, 8, 1, 16, 204, 204, 19, 19, 57, 19,
  1, 0, 3, 248, 0, 14, 14, 0, 48, 1, 128, 96, 0, 192, 65, 240,
  64, 195, 24, 96, 134, 12, 32, 132, 0, 32, 132, 0, 32, 132, 0, 32,
  132, 0, 32, 134, 12, 32, 195, 24, 96, 65, 240, 64, 96, 0, 192, 48,
  1, 128, 24, 3, 0, 14, 14, 0, 3, 248, 0, 7, 12, 12, 9, 1,
  7, 120, 204, 204, 28, 108, 204, 204, 220, 118, 0, 254, 254, 9, 8, 16,
  14, 2, 3, 25, 128, 51, 0, 102, 0, 204, 0, 204, 0, 102, 0, 51,
  0, 25, 128, 13, 8, 16, 15, 1, 2, 255, 248, 255, 248, 0, 24, 0,
  24, 0, 24, 0, 24, 0, 24, 0, 24, 6, 2, 2, 8, 1, 6, 252,
  252, 18, 19, 57, 19, 1, 0, 7, 248, 0, 28, 14, 0, 48, 3, 0,
  96, 1, 128, 67, 240, 128, 194, 24, 192, 130, 8, 64, 130, 8, 64, 130,
  8, 64, 130, 16, 64, 131, 240, 64, 130, 32, 64, 130, 16, 64, 194, 16,
  192, 66, 8, 128, 96, 1, 128, 48, 3, 0, 28, 14, 0, 7, 248, 0,
  6, 2, 2, 8, 1, 16, 252, 252, 8, 7, 7, 9, 0, 11, 60, 102,
  195, 195, 195, 102, 60, 12, 13, 26, 14, 1, 0, 6, 0, 6, 0, 6,
  0, 6, 0, 255, 240, 255, 240, 6, 0, 6, 0, 6, 0, 6, 0, 0,
  0, 255, 240, 255, 240, 7, 10, 10, 7, 0, 8, 60, 126, 198, 6, 12,
  24, 48, 96, 254, 254, 7, 10, 10, 7, 0, 8, 124, 254, 198, 6, 60,
  60, 6, 198, 254, 124, 5, 4, 4, 7, 1, 15, 24, 48, 96, 192, 10,
  19, 38, 14, 2, 251, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 193, 192, 227, 192, 254, 192, 220,
  192, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 10, 24, 48, 12, 1,
  251, 31, 192, 127, 192, 125, 128, 253, 128, 253, 128, 253, 128, 253, 128, 253,
  128, 253, 128, 125, 128, 125, 128, 61, 128, 13, 128, 13, 128, 13, 128, 13,
  128, 13, 128, 13, 128, 13, 128, 13, 128, 13, 128, 13, 128, 13, 128, 13,
  128, 2, 3, 3, 6, 2, 6, 192, 192, 192, 5, 6, 6, 7, 1, 251,
  96, 112, 24, 24, 248, 112, 4, 10, 10, 7, 0, 8, 48, 48, 240, 240,
  48, 48, 48, 48, 48, 48, 7, 12, 12, 9, 1, 7, 56, 108, 198, 198,
  198, 198, 198, 108, 56, 0, 254, 254, 9, 8, 16, 14, 3, 3, 204, 0,
  102, 0, 51, 0, 25, 128, 25, 128, 51, 0, 102, 0, 204, 0, 18, 18,
  54, 19, 1, 0, 48, 24, 0, 48, 24, 0, 240, 48, 0, 240, 48, 0,
  48, 96, 0, 48, 96, 0, 48, 192, 0, 48, 192, 0, 49, 131, 0, 49,
  135, 0, 3, 15, 0, 3, 15, 0, 6, 27, 0, 6, 51, 0, 12, 127,
  192, 12, 127, 192, 24, 3, 0, 24, 3, 0, 18, 18, 54, 19, 1, 0,
  48, 24, 0, 48, 24, 0, 240, 48, 0, 240, 48, 0, 48, 96, 0, 48,
  96, 0, 48, 192, 0, 48, 192, 0, 49, 135, 128, 49, 143, 192, 3, 24,
  192, 3, 0, 192, 6, 1, 128, 6, 3, 0, 12, 6, 0, 12, 12, 0,
  24, 31, 192, 24, 31, 192, 19, 18, 54, 19, 0, 0, 124, 12, 0, 254,
  12, 0, 198, 24, 0, 6, 24, 0, 60, 48, 0, 60, 48, 0, 6, 96,
  0, 198, 96, 0, 254, 193, 128, 124, 195, 128, 1, 135, 128, 1, 135, 128,
  3, 13, 128, 3, 25, 128, 6, 63, 224, 6, 63, 224, 12, 1, 128, 12,
  1, 128, 10, 19, 38, 12, 1, 251, 12, 0, 12, 0, 12, 0, 0, 0,
  0, 0, 12, 0, 12, 0, 12, 0, 12, 0, 24, 0, 56, 0, 112, 0,
  96, 0, 224, 192, 192, 192, 193, 192, 227, 128, 127, 128, 62, 0, 15, 24,
  48, 17, 1, 0, 12, 0, 6, 0, 3, 0, 1, 128, 0, 0, 3, 128,
  3, 128, 6, 192, 6, 192, 12, 64, 12, 96, 12, 96, 24, 48, 24, 48,
  24, 48, 48, 24, 63, 248, 63, 248, 96, 12, 96, 12, 96, 12, 192, 6,
  192, 6, 192, 6, 15, 24, 48, 17, 1, 0, 0, 96, 0, 192, 1, 128,
  3, 0, 0, 0, 3, 128, 3, 128, 6, 192, 6, 192, 12, 64, 12, 96,
  12, 96, 24, 48, 24, 48, 24, 48, 48, 24, 63, 248, 63, 248, 96, 12,
  96, 12, 96, 12, 192, 6, 192, 6, 192, 6, 15, 24, 48, 17, 1, 0,
  1, 128, 3, 192, 6, 96, 12, 48, 0, 0, 3, 128, 3, 128, 6, 192,
  6, 192, 12, 64, 12, 96, 12, 96, 24, 48, 24, 48, 24, 48, 48, 24,
  63, 248, 63, 248, 96, 12, 96, 12, 96, 12, 192, 6, 192, 6, 192, 6,
  15, 23, 46, 17, 1, 0, 7, 16, 13, 176, 8, 224, 0, 0, 3, 128,
  3, 128, 6, 192, 6, 192, 12, 64, 12, 96, 12, 96, 24, 48, 24, 48,
  24, 48, 48, 24, 63, 248, 63, 248, 96, 12, 96, 12, 96, 12, 192, 6,
  192, 6, 192, 6, 15, 23, 46, 17, 1, 0, 12, 96, 12, 96, 0, 0,
  0, 0, 3, 128, 3, 128, 6, 192, 6, 192, 12, 64, 12, 96, 12, 96,
  24, 48, 24, 48, 24, 48, 48, 24, 63, 248, 63, 248, 96, 12, 96, 12,
  96, 12, 192, 6, 192, 6, 192, 6, 15, 24, 48, 17, 1, 0, 3, 128,
  4, 64, 4, 64, 3, 128, 0, 0, 3, 128, 3, 128, 6, 192, 6, 192,
  12, 64, 12, 96, 12, 96, 24, 48, 24, 48, 24, 48, 48, 24, 63, 248,
  63, 248, 96, 12, 96, 12, 96, 12, 192, 6, 192, 6, 192, 6, 21, 19,
  57, 23, 1, 0, 3, 255, 248, 3, 255, 248, 6, 96, 0, 6, 96, 0,
  12, 96, 0, 12, 96, 0, 12, 96, 0, 24, 96, 0, 24, 127, 248, 24,
  127, 248, 48, 96, 0, 63, 224, 0, 63, 224, 0, 96, 96, 0, 96, 96,
  0, 96, 96, 0, 192, 96, 0, 192, 127, 248, 192, 127, 248, 15, 24, 48,
  18, 1, 251, 7, 224, 31, 248, 60, 60, 112, 14, 96, 6, 224, 6, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 224, 6, 96,
  6, 112, 14, 60, 60, 31, 248, 7, 224, 1, 128, 0, 192, 0, 192, 7,
  192, 3, 128, 12, 24, 48, 16, 2, 0, 48, 0, 24, 0, 12, 0, 6,
  0, 0, 0, 255, 240, 255, 240, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 255, 224, 255, 224, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 255, 240, 255, 240, 12, 24, 48, 16, 2, 0, 1,
  128, 3, 0, 6, 0, 12, 0, 0, 0, 255, 240, 255, 240, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 224, 255, 224, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 240, 255, 240, 12,
  24, 48, 16, 2, 0, 6, 0, 15, 0, 25, 128, 48, 192, 0, 0, 255,
  240, 255, 240, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255,
  224, 255, 224, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 255, 240, 255, 240, 12, 23, 46, 16, 2, 0, 24, 192, 24, 192, 0,
  0, 0, 0, 255, 240, 255, 240, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 255, 224, 255, 224, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 255, 240, 255, 240, 5, 24, 24, 8, 1, 0, 192,
  96, 48, 24, 0, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 48, 5, 24, 24, 8, 2, 0, 24, 48, 96,
  192, 0, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96,
  96, 96, 96, 96, 96, 8, 24, 24, 8, 0, 0, 24, 60, 102, 195, 0,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 6, 23, 23, 8, 1, 0, 204, 204, 0, 0, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  18, 19, 57, 18, 255, 0, 31, 248, 0, 31, 254, 0, 24, 15, 0, 24,
  3, 128, 24, 1, 128, 24, 1, 192, 24, 0, 192, 24, 0, 192, 255, 128,
  192, 255, 128, 192, 24, 0, 192, 24, 0, 192, 24, 0, 192, 24, 1, 192,
  24, 1, 128, 24, 3, 128, 24, 15, 0, 31, 254, 0, 31, 248, 0, 14,
  23, 46, 18, 2, 0, 14, 32, 27, 96, 17, 192, 0, 0, 224, 12, 240,
  12, 240, 12, 216, 12, 220, 12, 204, 12, 206, 12, 198, 12, 199, 12, 195,
  12, 195, 140, 193, 140, 193, 204, 192, 204, 192, 236, 192, 108, 192, 60, 192,
  60, 192, 28, 16, 24, 48, 18, 1, 0, 12, 0, 6, 0, 3, 0, 1,
  128, 0, 0, 7, 224, 31, 248, 60, 60, 112, 14, 96, 6, 224, 7, 192,
  3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 224, 7, 96,
  6, 112, 14, 60, 60, 31, 248, 7, 224, 16, 24, 48, 18, 1, 0, 0,
  48, 0, 96, 0, 192, 1, 128, 0, 0, 7, 224, 31, 248, 60, 60, 112,
  14, 96, 6, 224, 7, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192,
  3, 192, 3, 224, 7, 96, 6, 112, 14, 60, 60, 31, 248, 7, 224, 16,
  24, 48, 18, 1, 0, 0, 192, 1, 224, 3, 48, 6, 24, 0, 0, 7,
  224, 31, 248, 60, 60, 112, 14, 96, 6, 224, 7, 192, 3, 192, 3, 192,
  3, 192, 3, 192, 3, 192, 3, 192, 3, 224, 7, 96, 6, 112, 14, 60,
  60, 31, 248, 7, 224, 16, 23, 46, 18, 1, 0, 3, 136, 6, 216, 4,
  112, 0, 0, 7, 224, 31, 248, 60, 60, 112, 14, 96, 6, 224, 7, 192,
  3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 224, 7, 96,
  6, 112, 14, 60, 60, 31, 248, 7, 224, 16, 23, 46, 18, 1, 0, 6,
  48, 6, 48, 0, 0, 0, 0, 7, 224, 31, 248, 60, 60, 112, 14, 96,
  6, 224, 7, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192,
  3, 224, 7, 96, 6, 112, 14, 60, 60, 31, 248, 7, 224, 13, 12, 24,
  14, 0, 1, 192, 24, 96, 48, 48, 96, 24, 192, 13, 128, 7, 0, 7,
  0, 13, 128, 24, 192, 48, 96, 96, 48, 192, 24, 18, 19, 57, 18, 0,
  0, 3, 240, 192, 15, 253, 192, 30, 31, 128, 56, 7, 0, 48, 15, 0,
  112, 29, 128, 96, 57, 128, 96, 113, 128, 96, 225, 128, 97, 193, 128, 99,
  129, 128, 103, 1, 128, 110, 1, 128, 124, 3, 128, 56, 3, 0, 56, 7,
  0, 126, 30, 0, 239, 252, 0, 195, 240, 0, 14, 24, 48, 18, 2, 0,
  24, 0, 12, 0, 6, 0, 3, 0, 0, 0, 192, 12, 192, 12, 192, 12,
  192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12,
  192, 12, 192, 12, 192, 12, 192, 12, 96, 24, 112, 56, 63, 240, 15, 192,
  14, 24, 48, 18, 2, 0, 0, 96, 0, 192, 1, 128, 3, 0, 0, 0,
  192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12,
  192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 96, 24,
  112, 56, 63, 240, 15, 192, 14, 24, 48, 18, 2, 0, 3, 0, 7, 128,
  12, 192, 24, 96, 0, 0, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12,
  192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12,
  192, 12, 192, 12, 96, 24, 112, 56, 63, 240, 15, 192, 14, 23, 46, 18,
  2, 0, 24, 192, 24, 192, 0, 0, 0, 0, 192, 12, 192, 12, 192, 12,
  192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12,
  192, 12, 192, 12, 192, 12, 192, 12, 96, 24, 112, 56, 63, 240, 15, 192,
  14, 24, 48, 16, 1, 0, 0, 96, 0, 192, 1, 128, 3, 0, 0, 0,
  192, 12, 224, 28, 96, 24, 112, 56, 48, 48, 56, 112, 24, 96, 28, 224,
  12, 192, 15, 192, 7, 128, 7, 128, 3, 0, 3, 0, 3, 0, 3, 0,
  3, 0, 3, 0, 3, 0, 13, 19, 38, 16, 2, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 255, 224, 255, 240, 192, 48, 192, 24, 192, 24, 192, 24,
  192, 24, 192, 48, 255, 240, 255, 224, 192, 0, 192, 0, 192, 0, 192, 0,
  192, 0, 10, 19, 38, 15, 3, 0, 28, 0, 127, 0, 227, 0, 193, 128,
  193, 128, 193, 128, 195, 0, 199, 0, 206, 0, 207, 0, 195, 128, 193, 128,
  192, 192, 192, 192, 192, 192, 193, 128, 195, 128, 207, 0, 206, 0, 11, 19,
  38, 13, 1, 0, 24, 0, 12, 0, 6, 0, 3, 0, 0, 0, 31, 0,
  63, 128, 97, 192, 96, 192, 0, 192, 7, 192, 63, 192, 120, 192, 224, 192,
  192, 192, 193, 192, 227, 192, 126, 224, 60, 96, 11, 19, 38, 13, 1, 0,
  1, 128, 3, 0, 6, 0, 12, 0, 0, 0, 31, 0, 63, 128, 97, 192,
  96, 192, 0, 192, 7, 192, 63, 192, 120, 192, 224, 192, 192, 192, 193, 192,
  227, 192, 126, 224, 60, 96, 11, 19, 38, 13, 1, 0, 12, 0, 30, 0,
  51, 0, 97, 128, 0, 0, 31, 0, 63, 128, 97, 192, 96, 192, 0, 192,
  7, 192, 63, 192, 120, 192, 224, 192, 192, 192, 193, 192, 227, 192, 126, 224,
  60, 96, 11, 18, 36, 13, 1, 0, 28, 64, 54, 192, 35, 128, 0, 0,
  31, 0, 63, 128, 97, 192, 96, 192, 0, 192, 7, 192, 63, 192, 120, 192,
  224, 192, 192, 192, 193, 192, 227, 192, 126, 224, 60, 96, 11, 18, 36, 13,
  1, 0, 51, 0, 51, 0, 0, 0, 0, 0, 31, 0, 63, 128, 97, 192,
  96, 192, 0, 192, 7, 192, 63, 192, 120, 192, 224, 192, 192, 192, 193, 192,
  227, 192, 126, 224, 60, 96, 11, 19, 38, 13, 1, 0, 6, 0, 9, 0,
  9, 0, 6, 0, 0, 0, 31, 0, 63, 128, 97, 192, 96, 192, 0, 192,
  7, 192, 63, 192, 120, 192, 224, 192, 192, 192, 193, 192, 227, 192, 126, 224,
  60, 96, 19, 14, 42, 21, 1, 0, 31, 14, 0, 63, 191, 128, 97, 241,
  192, 96, 224, 192, 0, 192, 96, 7, 192, 96, 63, 255, 224, 120, 255, 224,
  224, 192, 0, 192, 192, 0, 193, 224, 96, 227, 240, 224, 126, 63, 192, 60,
  15, 0, 10, 19, 38, 12, 1, 251, 31, 0, 63, 128, 113, 192, 96, 192,
  224, 0, 192, 0, 192, 0, 192, 0, 192, 0, 224, 0, 96, 192, 113, 192,
  63, 128, 31, 0, 12, 0, 6, 0, 6, 0, 62, 0, 28, 0, 11, 19,
  38, 13, 1, 0, 24, 0, 12, 0, 6, 0, 3, 0, 0, 0, 14, 0,
  63, 128, 113, 192, 96, 192, 192, 96, 192, 96, 255, 224, 255, 224, 192, 0,
  192, 0, 96, 96, 112, 224, 63, 192, 15, 0, 11, 19, 38, 13, 1, 0,
  3, 0, 6, 0, 12, 0, 24, 0, 0, 0, 14, 0, 63, 128, 113, 192,
  96, 192, 192, 96, 192, 96, 255, 224, 255, 224, 192, 0, 192, 0, 96, 96,
  112, 224, 63, 192, 15, 0, 11, 19, 38, 13, 1, 0, 12, 0, 30, 0,
  51, 0, 97, 128, 0, 0, 14, 0, 63, 128, 113, 192, 96, 192, 192, 96,
  192, 96, 255, 224, 255, 224, 192, 0, 192, 0, 96, 96, 112, 224, 63, 192,
  15, 0, 11, 18, 36, 13, 1, 0, 51, 0, 51, 0, 0, 0, 0, 0,
  14, 0, 63, 128, 113, 192, 96, 192, 192, 96, 192, 96, 255, 224, 255, 224,
  192, 0, 192, 0, 96, 96, 112, 224, 63, 192, 15, 0, 5, 19, 19, 6,
  0, 0, 192, 96, 48, 24, 0, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 5, 19, 19, 6, 1, 0, 24, 48, 96, 192, 0,
  96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 8, 19,
  19, 6, 255, 0, 24, 60, 102, 195, 0, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 6, 18, 18, 6, 0, 0, 204, 204, 0,
  0, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 11,
  19, 38, 13, 1, 0, 96, 0, 57, 128, 14, 0, 30, 0, 99, 0, 31,
  128, 63, 128, 113, 192, 96, 192, 224, 224, 192, 96, 192, 96, 192, 96, 192,
  96, 224, 224, 96, 192, 113, 192, 63, 128, 31, 0, 10, 18, 36, 14, 2,
  0, 56, 128, 109, 128, 71, 0, 0, 0, 206, 0, 223, 128, 241, 128, 224,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 11, 19, 38, 13, 1, 0, 24, 0, 12, 0, 6,
  0, 3, 0, 0, 0, 31, 0, 63, 128, 113, 192, 96, 192, 224, 224, 192,
  96, 192, 96, 192, 96, 192, 96, 224, 224, 96, 192, 113, 192, 63, 128, 31,
  0, 11, 19, 38, 13, 1, 0, 3, 0, 6, 0, 12, 0, 24, 0, 0,
  0, 31, 0, 63, 128, 113, 192, 96, 192, 224, 224, 192, 96, 192, 96, 192,
  96, 192, 96, 224, 224, 96, 192, 113, 192, 63, 128, 31, 0, 11, 19, 38,
  13, 1, 0, 12, 0, 30, 0, 51, 0, 97, 128, 0, 0, 31, 0, 63,
  128, 113, 192, 96, 192, 224, 224, 192, 96, 192, 96, 192, 96, 192, 96, 224,
  224, 96, 192, 113, 192, 63, 128, 31, 0, 11, 18, 36, 13, 1, 0, 28,
  64, 54, 192, 35, 128, 0, 0, 31, 0, 63, 128, 113, 192, 96, 192, 224,
  224, 192, 96, 192, 96, 192, 96, 192, 96, 224, 224, 96, 192, 113, 192, 63,
  128, 31, 0, 11, 18, 36, 13, 1, 0, 51, 0, 51, 0, 0, 0, 0,
  0, 31, 0, 63, 128, 113, 192, 96, 192, 224, 224, 192, 96, 192, 96, 192,
  96, 192, 96, 224, 224, 96, 192, 113, 192, 63, 128, 31, 0, 12, 12, 24,
  14, 1, 1, 6, 0, 6, 0, 6, 0, 0, 0, 0, 0, 255, 240, 255,
  240, 0, 0, 0, 0, 6, 0, 6, 0, 6, 0, 13, 14, 28, 13, 0,
  0, 15, 152, 31, 248, 56, 112, 48, 224, 113, 240, 99, 176, 99, 48, 102,
  48, 108, 48, 124, 112, 56, 96, 112, 224, 255, 192, 207, 128, 10, 19, 38,
  14, 2, 0, 48, 0, 24, 0, 12, 0, 6, 0, 0, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 193, 192, 99, 192, 126, 192, 28, 192, 10, 19, 38, 14, 2, 0, 3,
  0, 6, 0, 12, 0, 24, 0, 0, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 193, 192, 99,
  192, 126, 192, 28, 192, 10, 19, 38, 14, 2, 0, 12, 0, 30, 0, 51,
  0, 97, 128, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 193, 192, 99, 192, 126, 192, 28,
  192, 10, 18, 36, 14, 2, 0, 51, 0, 51, 0, 0, 0, 0, 0, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 193, 192, 99, 192, 126, 192, 28, 192, 12, 24, 48, 13, 0,
  251, 0, 192, 1, 128, 3, 0, 6, 0, 0, 0, 192, 48, 192, 48, 96,
  48, 112, 96, 48, 96, 56, 224, 24, 192, 24, 192, 13, 128, 13, 128, 7,
  128, 7, 0, 3, 0, 3, 0, 6, 0, 6, 0, 12, 0, 60, 0, 56,
  0, 11, 24, 48, 14, 2, 251, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 207, 0, 223, 128, 241, 192, 224, 192, 192, 224, 192, 96, 192, 96, 192,
  96, 192, 96, 192, 224, 224, 192, 241, 192, 223, 128, 207, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 12, 23, 46, 13, 0, 251, 25, 128, 25,
  128, 0, 0, 0, 0, 192, 48, 192, 48, 96, 48, 112, 96, 48, 96, 56,
  224, 24, 192, 24, 192, 13, 128, 13, 128, 7, 128, 7, 0, 3, 0, 3,
  0, 6, 0, 6, 0, 12, 0, 60, 0, 56, 0
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--25-180-100-100-P-130-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 0, '1' Height: 18
  Calculated Max Values w=12 h=19 x= 2 y=12 dx=14 dy= 0 ascent=19 len=36
  Font Bounding box     w=28 h=37 x=-3 y=-8
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =18 descent= 0
  X Font      ascent =18 descent= 0
  Max Font    ascent =19 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_helvR18n[536] U8G_FONT_SECTION("u8g_font_helvR18n") = {
  0, 28, 37, 253, 248, 18, 0, 0, 0, 0, 42, 58, 0, 19, 253, 18,
  0, 7, 7, 7, 10, 1, 12, 16, 16, 214, 124, 56, 108, 68, 12, 12,
  24, 14, 1, 1, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 255, 240,
  255, 240, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 2, 6, 6, 6,
  2, 253, 192, 192, 192, 64, 64, 128, 6, 2, 2, 8, 1, 6, 252, 252,
  2, 3, 3, 6, 2, 0, 192, 192, 192, 7, 19, 19, 7, 0, 0, 6,
  4, 12, 12, 8, 24, 24, 16, 16, 48, 48, 32, 96, 96, 64, 192, 192,
  128, 128, 11, 18, 36, 13, 1, 0, 31, 0, 63, 128, 113, 192, 96, 192,
  96, 192, 224, 224, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96, 192, 96,
  224, 224, 96, 192, 96, 192, 113, 192, 63, 128, 31, 0, 6, 18, 18, 13,
  2, 0, 12, 12, 28, 252, 252, 12, 12, 12, 12, 12, 12, 12, 12, 12,
  12, 12, 12, 12, 11, 18, 36, 13, 1, 0, 30, 0, 127, 128, 97, 192,
  192, 192, 192, 96, 192, 96, 0, 224, 0, 192, 1, 192, 3, 128, 15, 0,
  28, 0, 56, 0, 112, 0, 224, 0, 192, 0, 255, 224, 255, 224, 11, 18,
  36, 13, 1, 0, 31, 0, 127, 128, 97, 128, 192, 192, 192, 192, 192, 192,
  0, 192, 1, 128, 15, 0, 15, 192, 0, 192, 0, 96, 0, 96, 192, 96,
  192, 192, 97, 192, 127, 128, 31, 0, 11, 18, 36, 13, 1, 0, 1, 128,
  3, 128, 3, 128, 7, 128, 15, 128, 13, 128, 25, 128, 57, 128, 49, 128,
  97, 128, 225, 128, 193, 128, 255, 224, 255, 224, 1, 128, 1, 128, 1, 128,
  1, 128, 11, 18, 36, 13, 1, 0, 127, 192, 127, 192, 96, 0, 96, 0,
  96, 0, 96, 0, 126, 0, 127, 128, 113, 192, 0, 192, 0, 224, 0, 96,
  0, 96, 192, 224, 192, 192, 225, 192, 127, 128, 30, 0, 11, 18, 36, 13,
  1, 0, 15, 0, 63, 192, 112, 192, 96, 96, 224, 96, 192, 0, 192, 0,
  207, 0, 223, 128, 241, 192, 224, 192, 192, 96, 192, 96, 192, 96, 224, 224,
  113, 192, 127, 192, 31, 0, 11, 18, 36, 13, 1, 0, 255, 224, 255, 224,
  0, 224, 0, 192, 1, 128, 1, 128, 3, 0, 3, 0, 6, 0, 6, 0,
  12, 0, 12, 0, 28, 0, 24, 0, 24, 0, 56, 0, 48, 0, 48, 0,
  11, 18, 36, 13, 1, 0, 14, 0, 63, 128, 49, 128, 96, 192, 96, 192,
  96, 192, 49, 128, 31, 0, 63, 128, 113, 192, 96, 192, 192, 96, 192, 96,
  192, 96, 192, 96, 96, 192, 127, 192, 31, 0, 11, 18, 36, 13, 1, 0,
  31, 0, 127, 192, 113, 192, 224, 192, 192, 96, 192, 96, 192, 96, 192, 96,
  224, 224, 113, 224, 127, 96, 30, 96, 0, 96, 0, 224, 192, 192, 225, 192,
  127, 128, 30, 0, 2, 14, 14, 6, 2, 0, 192, 192, 192, 0, 0, 0,
  0, 0, 0, 0, 0, 192, 192, 192
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--25-180-100-100-P-130-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 19, '1' Height: 18
  Calculated Max Values w=22 h=24 x= 3 y=15 dx=25 dy= 0 ascent=20 len=69
  Font Bounding box     w=28 h=37 x=-3 y=-8
  Calculated Min Values           x= 0 y=-5 dx= 0 dy= 0
  Pure Font   ascent =19 descent=-5
  X Font      ascent =19 descent=-5
  Max Font    ascent =20 descent=-5
*/
const u8g_fntpgm_uint8_t u8g_font_helvR18r[3381] U8G_FONT_SECTION("u8g_font_helvR18r") = {
  0, 28, 37, 253, 248, 19, 4, 37, 9, 49, 32, 127, 251, 20, 251, 19,
  251, 0, 0, 0, 6, 0, 1, 2, 19, 19, 6, 2, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 128, 128, 0, 0, 192, 192, 192,
  6, 6, 6, 8, 1, 13, 204, 204, 204, 204, 204, 68, 11, 17, 34, 14,
  2, 0, 12, 192, 12, 192, 12, 192, 25, 128, 255, 224, 255, 224, 25, 128,
  25, 128, 51, 0, 51, 0, 255, 224, 255, 224, 51, 0, 51, 0, 102, 0,
  102, 0, 102, 0, 11, 22, 44, 13, 1, 254, 6, 0, 6, 0, 31, 128,
  63, 192, 118, 224, 102, 96, 102, 96, 102, 0, 118, 0, 62, 0, 62, 0,
  15, 128, 7, 192, 6, 224, 6, 96, 198, 96, 198, 96, 230, 224, 127, 192,
  63, 128, 6, 0, 6, 0, 19, 18, 54, 22, 1, 0, 0, 6, 0, 60,
  12, 0, 126, 12, 0, 195, 24, 0, 195, 24, 0, 195, 48, 0, 195, 48,
  0, 126, 96, 0, 60, 96, 0, 0, 192, 0, 0, 199, 128, 1, 143, 192,
  1, 152, 96, 3, 24, 96, 3, 24, 96, 6, 24, 96, 6, 15, 192, 4,
  7, 128, 14, 18, 36, 17, 2, 0, 15, 0, 31, 128, 57, 192, 48, 192,
  48, 192, 48, 192, 25, 128, 15, 0, 30, 0, 63, 24, 115, 152, 97, 216,
  192, 240, 192, 96, 192, 240, 225, 216, 127, 156, 30, 0, 2, 6, 6, 6,
  2, 13, 192, 192, 192, 192, 192, 64, 5, 24, 24, 8, 2, 251, 24, 24,
  48, 48, 96, 96, 96, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 96,
  96, 96, 48, 48, 24, 24, 5, 24, 24, 8, 1, 251, 192, 192, 96, 96,
  48, 48, 48, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 48, 48, 48,
  96, 96, 192, 192, 7, 7, 7, 10, 1, 12, 16, 16, 214, 124, 56, 108,
  68, 12, 12, 24, 14, 1, 1, 6, 0, 6, 0, 6, 0, 6, 0, 6,
  0, 255, 240, 255, 240, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 2,
  6, 6, 6, 2, 253, 192, 192, 192, 64, 64, 128, 6, 2, 2, 8, 1,
  6, 252, 252, 2, 3, 3, 6, 2, 0, 192, 192, 192, 7, 19, 19, 7,
  0, 0, 6, 4, 12, 12, 8, 24, 24, 16, 16, 48, 48, 32, 96, 96,
  64, 192, 192, 128, 128, 11, 18, 36, 13, 1, 0, 31, 0, 63, 128, 113,
  192, 96, 192, 96, 192, 224, 224, 192, 96, 192, 96, 192, 96, 192, 96, 192,
  96, 192, 96, 224, 224, 96, 192, 96, 192, 113, 192, 63, 128, 31, 0, 6,
  18, 18, 13, 2, 0, 12, 12, 28, 252, 252, 12, 12, 12, 12, 12, 12,
  12, 12, 12, 12, 12, 12, 12, 11, 18, 36, 13, 1, 0, 30, 0, 127,
  128, 97, 192, 192, 192, 192, 96, 192, 96, 0, 224, 0, 192, 1, 192, 3,
  128, 15, 0, 28, 0, 56, 0, 112, 0, 224, 0, 192, 0, 255, 224, 255,
  224, 11, 18, 36, 13, 1, 0, 31, 0, 127, 128, 97, 128, 192, 192, 192,
  192, 192, 192, 0, 192, 1, 128, 15, 0, 15, 192, 0, 192, 0, 96, 0,
  96, 192, 96, 192, 192, 97, 192, 127, 128, 31, 0, 11, 18, 36, 13, 1,
  0, 1, 128, 3, 128, 3, 128, 7, 128, 15, 128, 13, 128, 25, 128, 57,
  128, 49, 128, 97, 128, 225, 128, 193, 128, 255, 224, 255, 224, 1, 128, 1,
  128, 1, 128, 1, 128, 11, 18, 36, 13, 1, 0, 127, 192, 127, 192, 96,
  0, 96, 0, 96, 0, 96, 0, 126, 0, 127, 128, 113, 192, 0, 192, 0,
  224, 0, 96, 0, 96, 192, 224, 192, 192, 225, 192, 127, 128, 30, 0, 11,
  18, 36, 13, 1, 0, 15, 0, 63, 192, 112, 192, 96, 96, 224, 96, 192,
  0, 192, 0, 207, 0, 223, 128, 241, 192, 224, 192, 192, 96, 192, 96, 192,
  96, 224, 224, 113, 192, 127, 192, 31, 0, 11, 18, 36, 13, 1, 0, 255,
  224, 255, 224, 0, 224, 0, 192, 1, 128, 1, 128, 3, 0, 3, 0, 6,
  0, 6, 0, 12, 0, 12, 0, 28, 0, 24, 0, 24, 0, 56, 0, 48,
  0, 48, 0, 11, 18, 36, 13, 1, 0, 14, 0, 63, 128, 49, 128, 96,
  192, 96, 192, 96, 192, 49, 128, 31, 0, 63, 128, 113, 192, 96, 192, 192,
  96, 192, 96, 192, 96, 192, 96, 96, 192, 127, 192, 31, 0, 11, 18, 36,
  13, 1, 0, 31, 0, 127, 192, 113, 192, 224, 192, 192, 96, 192, 96, 192,
  96, 192, 96, 224, 224, 113, 224, 127, 96, 30, 96, 0, 96, 0, 224, 192,
  192, 225, 192, 127, 128, 30, 0, 2, 14, 14, 6, 2, 0, 192, 192, 192,
  0, 0, 0, 0, 0, 0, 0, 0, 192, 192, 192, 2, 17, 17, 6, 2,
  253, 192, 192, 192, 0, 0, 0, 0, 0, 0, 0, 0, 192, 192, 192, 64,
  64, 128, 12, 12, 24, 15, 1, 1, 0, 48, 0, 240, 3, 192, 15, 0,
  60, 0, 224, 0, 224, 0, 60, 0, 15, 0, 3, 192, 0, 240, 0, 48,
  10, 5, 10, 15, 2, 5, 255, 192, 255, 192, 0, 0, 255, 192, 255, 192,
  12, 12, 24, 15, 1, 1, 192, 0, 240, 0, 60, 0, 15, 0, 3, 192,
  0, 112, 0, 112, 3, 192, 15, 0, 60, 0, 240, 0, 192, 0, 10, 19,
  38, 12, 1, 0, 31, 0, 127, 128, 113, 192, 224, 192, 192, 192, 193, 192,
  1, 128, 3, 128, 7, 0, 6, 0, 12, 0, 12, 0, 12, 0, 12, 0,
  0, 0, 0, 0, 12, 0, 12, 0, 12, 0, 22, 23, 69, 25, 2, 252,
  0, 255, 0, 3, 255, 192, 15, 1, 224, 28, 0, 112, 56, 0, 24, 48,
  0, 24, 96, 115, 12, 96, 251, 12, 193, 199, 12, 195, 134, 12, 195, 6,
  12, 198, 6, 12, 198, 12, 28, 198, 12, 24, 198, 12, 56, 231, 28, 112,
  99, 247, 224, 113, 227, 128, 56, 0, 0, 28, 0, 0, 15, 3, 0, 7,
  255, 0, 0, 252, 0, 15, 19, 38, 17, 1, 0, 3, 128, 3, 128, 6,
  192, 6, 192, 12, 64, 12, 96, 12, 96, 24, 48, 24, 48, 24, 48, 48,
  24, 63, 248, 63, 248, 96, 12, 96, 12, 96, 12, 192, 6, 192, 6, 192,
  6, 14, 19, 38, 17, 2, 0, 255, 192, 255, 240, 192, 112, 192, 24, 192,
  24, 192, 24, 192, 24, 192, 48, 255, 224, 255, 240, 192, 24, 192, 12, 192,
  12, 192, 12, 192, 12, 192, 28, 192, 120, 255, 240, 255, 192, 15, 19, 38,
  18, 1, 0, 7, 224, 31, 248, 60, 60, 112, 14, 96, 6, 224, 6, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 224, 6, 96,
  6, 112, 14, 60, 60, 31, 248, 7, 224, 15, 19, 38, 18, 2, 0, 255,
  192, 255, 240, 192, 120, 192, 28, 192, 12, 192, 14, 192, 6, 192, 6, 192,
  6, 192, 6, 192, 6, 192, 6, 192, 6, 192, 14, 192, 12, 192, 28, 192,
  120, 255, 240, 255, 192, 12, 19, 38, 16, 2, 0, 255, 240, 255, 240, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 224, 255, 224, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 240, 255,
  240, 11, 19, 38, 14, 2, 0, 255, 224, 255, 224, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 255, 192, 255, 192, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 16, 19, 38,
  19, 1, 0, 7, 224, 31, 248, 60, 60, 112, 14, 96, 6, 224, 6, 192,
  0, 192, 0, 192, 0, 192, 127, 192, 127, 192, 3, 192, 3, 224, 3, 96,
  7, 112, 15, 60, 63, 31, 251, 7, 227, 14, 19, 38, 18, 2, 0, 192,
  12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 255,
  252, 255, 252, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192,
  12, 192, 12, 192, 12, 2, 19, 19, 8, 3, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 10, 19,
  38, 13, 1, 0, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 97, 128, 127, 128, 63, 0, 13, 19, 38, 18, 3, 0,
  192, 56, 192, 112, 192, 224, 193, 192, 195, 128, 199, 0, 206, 0, 220, 0,
  252, 0, 254, 0, 231, 0, 195, 128, 193, 128, 193, 192, 192, 224, 192, 96,
  192, 112, 192, 56, 192, 24, 11, 19, 38, 14, 2, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 224,
  255, 224, 17, 19, 57, 21, 2, 0, 192, 1, 128, 224, 3, 128, 224, 3,
  128, 240, 7, 128, 240, 7, 128, 216, 13, 128, 216, 13, 128, 216, 13, 128,
  204, 25, 128, 204, 25, 128, 204, 25, 128, 198, 49, 128, 198, 49, 128, 198,
  49, 128, 195, 97, 128, 195, 97, 128, 195, 97, 128, 193, 193, 128, 193, 193,
  128, 14, 19, 38, 18, 2, 0, 224, 12, 240, 12, 240, 12, 216, 12, 220,
  12, 204, 12, 206, 12, 198, 12, 199, 12, 195, 12, 195, 140, 193, 140, 193,
  204, 192, 204, 192, 236, 192, 108, 192, 60, 192, 60, 192, 28, 16, 19, 38,
  18, 1, 0, 7, 224, 31, 248, 60, 60, 112, 14, 96, 6, 224, 7, 192,
  3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 224, 7, 96,
  6, 112, 14, 60, 60, 31, 248, 7, 224, 13, 19, 38, 16, 2, 0, 255,
  224, 255, 240, 192, 48, 192, 24, 192, 24, 192, 24, 192, 24, 192, 48, 255,
  240, 255, 224, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 16, 19, 38, 18, 1, 0, 7, 224, 31, 248, 60,
  60, 112, 14, 96, 6, 224, 7, 192, 3, 192, 3, 192, 3, 192, 3, 192,
  3, 192, 3, 192, 3, 224, 7, 96, 230, 112, 126, 60, 28, 31, 254, 7,
  231, 13, 19, 38, 17, 2, 0, 255, 224, 255, 240, 192, 48, 192, 24, 192,
  24, 192, 24, 192, 24, 192, 48, 255, 240, 255, 224, 192, 112, 192, 48, 192,
  24, 192, 24, 192, 24, 192, 24, 192, 24, 192, 24, 192, 24, 13, 19, 38,
  16, 2, 0, 15, 128, 63, 224, 96, 96, 192, 48, 192, 48, 192, 0, 224,
  0, 124, 0, 63, 128, 7, 224, 0, 240, 0, 56, 0, 24, 0, 24, 192,
  24, 192, 56, 240, 112, 127, 224, 31, 128, 14, 19, 38, 16, 1, 0, 255,
  252, 255, 252, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3,
  0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3,
  0, 3, 0, 3, 0, 14, 19, 38, 18, 2, 0, 192, 12, 192, 12, 192,
  12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192,
  12, 192, 12, 192, 12, 192, 12, 192, 12, 96, 24, 112, 56, 63, 240, 15,
  192, 15, 19, 38, 17, 1, 0, 192, 6, 192, 6, 224, 14, 96, 12, 112,
  28, 48, 24, 48, 24, 56, 56, 24, 48, 24, 48, 28, 112, 12, 96, 12,
  96, 14, 224, 6, 192, 6, 192, 3, 128, 3, 128, 3, 128, 20, 19, 57,
  22, 1, 0, 192, 96, 48, 192, 96, 48, 192, 96, 48, 192, 240, 48, 96,
  240, 96, 97, 152, 96, 97, 152, 96, 97, 152, 96, 97, 152, 96, 49, 152,
  192, 51, 12, 192, 51, 12, 192, 51, 12, 192, 27, 13, 128, 27, 13, 128,
  30, 7, 128, 14, 7, 0, 12, 3, 0, 12, 3, 0, 15, 19, 38, 17,
  1, 0, 192, 6, 224, 14, 112, 28, 48, 24, 24, 48, 28, 112, 14, 224,
  7, 192, 3, 128, 3, 128, 7, 192, 14, 224, 12, 96, 28, 112, 56, 56,
  48, 24, 96, 12, 224, 14, 192, 6, 14, 19, 38, 16, 1, 0, 192, 12,
  224, 28, 96, 24, 112, 56, 48, 48, 56, 112, 24, 96, 28, 224, 12, 192,
  15, 192, 7, 128, 7, 128, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0,
  3, 0, 3, 0, 13, 19, 38, 15, 1, 0, 255, 248, 255, 248, 0, 56,
  0, 112, 0, 224, 1, 192, 1, 192, 3, 128, 7, 0, 7, 0, 14, 0,
  28, 0, 28, 0, 56, 0, 112, 0, 112, 0, 224, 0, 255, 248, 255, 248,
  4, 24, 24, 7, 2, 251, 240, 240, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 240, 240, 8, 19,
  19, 7, 0, 0, 192, 64, 64, 96, 32, 32, 48, 16, 16, 16, 24, 8,
  8, 12, 4, 4, 6, 2, 3, 4, 24, 24, 7, 1, 251, 240, 240, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 240, 240, 10, 9, 18, 12, 1, 10, 12, 0, 12, 0, 30,
  0, 18, 0, 51, 0, 97, 128, 97, 128, 192, 192, 192, 192, 14, 2, 4,
  14, 0, 251, 255, 252, 255, 252, 5, 4, 4, 7, 1, 15, 192, 96, 48,
  24, 11, 14, 28, 13, 1, 0, 31, 0, 63, 128, 97, 192, 96, 192, 0,
  192, 7, 192, 63, 192, 120, 192, 224, 192, 192, 192, 193, 192, 227, 192, 126,
  224, 60, 96, 11, 19, 38, 14, 2, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 207, 0, 223, 128, 241, 192, 224, 192, 192, 224, 192, 96, 192,
  96, 192, 96, 192, 96, 192, 224, 224, 192, 241, 192, 223, 128, 207, 0, 10,
  14, 28, 12, 1, 0, 31, 0, 63, 128, 113, 192, 96, 192, 224, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 224, 0, 96, 192, 113, 192, 63, 128, 31,
  0, 11, 19, 38, 14, 1, 0, 0, 96, 0, 96, 0, 96, 0, 96, 0,
  96, 30, 96, 63, 96, 113, 224, 96, 224, 224, 96, 192, 96, 192, 96, 192,
  96, 192, 96, 224, 96, 96, 224, 113, 224, 63, 96, 30, 96, 11, 14, 28,
  13, 1, 0, 14, 0, 63, 128, 113, 192, 96, 192, 192, 96, 192, 96, 255,
  224, 255, 224, 192, 0, 192, 0, 96, 96, 112, 224, 63, 192, 15, 0, 6,
  19, 19, 8, 1, 0, 28, 60, 48, 48, 48, 252, 252, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 11, 19, 38, 14, 1, 251, 30, 96,
  63, 96, 113, 224, 96, 224, 224, 96, 192, 96, 192, 96, 192, 96, 192, 96,
  224, 96, 96, 224, 113, 224, 63, 96, 30, 96, 0, 96, 192, 96, 224, 192,
  127, 192, 31, 0, 10, 19, 38, 13, 2, 0, 192, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 206, 0, 223, 128, 241, 128, 224, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  2, 19, 19, 6, 2, 0, 192, 192, 192, 0, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 4, 24, 24, 6, 0, 251, 48,
  48, 48, 0, 0, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 240, 224, 10, 19, 38, 12, 2, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 193, 128, 195, 128, 199, 0, 206, 0, 220,
  0, 248, 0, 252, 0, 206, 0, 198, 0, 199, 0, 195, 128, 193, 128, 193,
  192, 192, 192, 2, 19, 19, 6, 2, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 16, 14, 28, 20,
  2, 0, 206, 60, 255, 126, 227, 199, 193, 131, 193, 131, 193, 131, 193, 131,
  193, 131, 193, 131, 193, 131, 193, 131, 193, 131, 193, 131, 193, 131, 10, 14,
  28, 14, 2, 0, 206, 0, 223, 128, 241, 128, 224, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  11, 14, 28, 13, 1, 0, 31, 0, 63, 128, 113, 192, 96, 192, 224, 224,
  192, 96, 192, 96, 192, 96, 192, 96, 224, 224, 96, 192, 113, 192, 63, 128,
  31, 0, 11, 19, 38, 14, 2, 251, 207, 0, 223, 128, 241, 192, 224, 192,
  192, 224, 192, 96, 192, 96, 192, 96, 192, 96, 192, 224, 224, 192, 241, 192,
  223, 128, 207, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 11, 19,
  38, 14, 1, 251, 30, 96, 63, 96, 113, 224, 96, 224, 224, 96, 192, 96,
  192, 96, 192, 96, 192, 96, 224, 96, 96, 224, 113, 224, 63, 96, 30, 96,
  0, 96, 0, 96, 0, 96, 0, 96, 0, 96, 6, 14, 14, 9, 2, 0,
  204, 220, 248, 240, 224, 192, 192, 192, 192, 192, 192, 192, 192, 192, 10, 14,
  28, 12, 1, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 0, 248, 0,
  127, 0, 15, 128, 1, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0,
  6, 18, 18, 8, 1, 0, 48, 48, 48, 48, 252, 252, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 60, 28, 10, 14, 28, 14, 2, 0, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 193, 192, 99, 192, 126, 192, 28, 192, 11, 14, 28, 13, 1, 0,
  192, 96, 192, 96, 192, 96, 96, 192, 96, 192, 113, 192, 49, 128, 49, 128,
  27, 0, 27, 0, 27, 0, 14, 0, 14, 0, 14, 0, 18, 14, 42, 18,
  0, 0, 192, 192, 192, 192, 192, 192, 97, 225, 128, 97, 225, 128, 97, 225,
  128, 49, 35, 0, 51, 51, 0, 51, 51, 0, 27, 54, 0, 26, 22, 0,
  30, 30, 0, 14, 28, 0, 12, 12, 0, 12, 12, 0, 10, 14, 28, 12,
  1, 0, 192, 192, 225, 192, 97, 128, 51, 0, 30, 0, 30, 0, 12, 0,
  30, 0, 30, 0, 51, 0, 115, 128, 97, 128, 192, 192, 192, 192, 12, 19,
  38, 13, 0, 251, 192, 48, 192, 48, 96, 48, 112, 96, 48, 96, 56, 224,
  24, 192, 24, 192, 13, 128, 13, 128, 7, 128, 7, 0, 3, 0, 3, 0,
  6, 0, 6, 0, 12, 0, 60, 0, 56, 0, 10, 14, 28, 12, 1, 0,
  255, 192, 255, 192, 1, 128, 3, 0, 7, 0, 14, 0, 12, 0, 28, 0,
  56, 0, 48, 0, 96, 0, 224, 0, 255, 192, 255, 192, 6, 24, 24, 8,
  1, 251, 12, 24, 48, 48, 48, 48, 48, 48, 48, 48, 96, 192, 192, 96,
  48, 48, 48, 48, 48, 48, 48, 48, 24, 12, 1, 24, 24, 6, 2, 251,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 6, 24, 24, 8, 1, 251, 192, 96,
  48, 48, 48, 48, 48, 48, 48, 48, 24, 12, 12, 24, 48, 48, 48, 48,
  48, 48, 48, 48, 96, 192, 10, 4, 8, 14, 2, 5, 112, 192, 252, 192,
  207, 192, 195, 128, 255
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--34-240-100-100-P-176-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 25, '1' Height: 24
  Calculated Max Values w=29 h=32 x= 4 y=22 dx=34 dy= 0 ascent=31 len=120
  Font Bounding box     w=39 h=48 x=-5 y=-11
  Calculated Min Values           x=-1 y=-7 dx= 0 dy= 0
  Pure Font   ascent =25 descent=-7
  X Font      ascent =25 descent=-7
  Max Font    ascent =31 descent=-7
*/
const u8g_fntpgm_uint8_t u8g_font_helvR24[10931] U8G_FONT_SECTION("u8g_font_helvR24") = {
  0, 39, 48, 251, 245, 25, 5, 215, 14, 105, 32, 255, 249, 31, 249, 25,
  249, 0, 0, 0, 9, 0, 1, 3, 25, 25, 9, 4, 0, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 64, 64,
  0, 0, 224, 224, 224, 224, 8, 8, 8, 12, 2, 15, 231, 231, 231, 231,
  231, 231, 66, 66, 17, 23, 69, 19, 1, 0, 3, 135, 0, 3, 135, 0,
  3, 6, 0, 3, 6, 0, 7, 14, 0, 7, 14, 0, 127, 255, 128, 127,
  255, 128, 127, 255, 128, 14, 28, 0, 14, 28, 0, 12, 24, 0, 28, 56,
  0, 28, 56, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 56, 112, 0,
  56, 112, 0, 48, 96, 0, 48, 96, 0, 112, 224, 0, 112, 224, 0, 16,
  31, 62, 18, 1, 252, 1, 128, 1, 128, 1, 128, 15, 240, 31, 248, 61,
  188, 113, 142, 113, 142, 225, 142, 225, 128, 225, 128, 113, 128, 125, 128, 63,
  192, 31, 240, 7, 252, 1, 254, 1, 158, 1, 143, 1, 135, 225, 135, 225,
  135, 113, 142, 113, 142, 61, 188, 63, 248, 15, 240, 1, 128, 1, 128, 1,
  128, 1, 128, 26, 24, 96, 29, 1, 0, 0, 0, 48, 0, 31, 0, 112,
  0, 127, 128, 96, 0, 115, 192, 224, 0, 224, 192, 192, 0, 192, 225, 192,
  0, 192, 225, 128, 0, 192, 227, 128, 0, 224, 195, 0, 0, 115, 199, 0,
  0, 127, 134, 0, 0, 31, 14, 0, 0, 0, 12, 0, 0, 0, 28, 62,
  0, 0, 24, 127, 128, 0, 56, 243, 128, 0, 48, 193, 192, 0, 113, 192,
  192, 0, 97, 192, 192, 0, 225, 192, 192, 0, 192, 193, 192, 1, 192, 227,
  128, 1, 128, 127, 128, 3, 128, 62, 0, 18, 23, 69, 22, 2, 0, 7,
  192, 0, 15, 224, 0, 30, 112, 0, 60, 56, 0, 56, 56, 0, 56, 56,
  0, 60, 112, 0, 30, 240, 0, 15, 224, 0, 7, 192, 0, 15, 128, 0,
  63, 192, 0, 121, 199, 0, 112, 231, 0, 224, 246, 0, 224, 126, 0, 224,
  60, 0, 224, 28, 0, 240, 62, 0, 120, 127, 0, 127, 247, 128, 63, 227,
  192, 15, 0, 0, 3, 8, 8, 6, 2, 15, 224, 224, 224, 224, 224, 224,
  224, 64, 7, 31, 31, 11, 2, 249, 6, 12, 12, 24, 24, 56, 48, 112,
  112, 112, 96, 224, 224, 224, 224, 224, 224, 224, 224, 224, 96, 112, 112, 112,
  48, 56, 24, 24, 12, 12, 6, 7, 31, 31, 11, 1, 249, 192, 96, 96,
  48, 48, 56, 24, 28, 28, 28, 12, 14, 14, 14, 14, 14, 14, 14, 14,
  12, 12, 28, 28, 24, 24, 56, 48, 112, 96, 96, 192, 10, 11, 22, 13,
  1, 15, 12, 0, 12, 0, 76, 128, 237, 192, 127, 128, 63, 0, 30, 0,
  63, 0, 115, 128, 225, 192, 64, 128, 17, 16, 48, 19, 1, 1, 1, 192,
  0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0,
  1, 192, 0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 1, 192, 0, 1,
  192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 3, 9,
  9, 9, 3, 251, 224, 224, 224, 224, 32, 96, 96, 192, 128, 8, 2, 2,
  11, 1, 8, 255, 255, 3, 4, 4, 9, 3, 0, 224, 224, 224, 224, 9,
  24, 48, 9, 0, 0, 1, 128, 1, 128, 1, 128, 3, 0, 3, 0, 3,
  0, 6, 0, 6, 0, 6, 0, 12, 0, 12, 0, 12, 0, 8, 0, 24,
  0, 24, 0, 24, 0, 48, 0, 48, 0, 48, 0, 96, 0, 96, 0, 96,
  0, 192, 0, 192, 0, 15, 24, 48, 18, 1, 0, 7, 192, 31, 240, 63,
  248, 60, 120, 120, 60, 112, 28, 112, 28, 224, 14, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 112, 28, 112,
  28, 112, 60, 60, 120, 63, 248, 31, 240, 7, 192, 8, 24, 24, 18, 3,
  0, 3, 7, 7, 15, 63, 255, 255, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 15, 24, 48, 18, 1, 0, 7,
  192, 31, 240, 63, 248, 120, 60, 112, 28, 240, 14, 224, 14, 224, 14, 0,
  14, 0, 28, 0, 60, 0, 120, 0, 240, 3, 224, 7, 192, 31, 0, 60,
  0, 120, 0, 112, 0, 224, 0, 224, 0, 255, 254, 255, 254, 255, 254, 15,
  24, 48, 18, 1, 0, 7, 192, 31, 240, 63, 248, 56, 56, 112, 28, 112,
  28, 112, 28, 112, 28, 0, 28, 0, 56, 3, 248, 3, 240, 3, 248, 0,
  60, 0, 30, 0, 14, 224, 14, 224, 14, 224, 14, 112, 28, 120, 60, 63,
  248, 31, 240, 7, 192, 16, 24, 48, 18, 0, 0, 0, 24, 0, 56, 0,
  120, 0, 120, 0, 248, 1, 248, 3, 184, 3, 184, 7, 56, 14, 56, 14,
  56, 28, 56, 56, 56, 56, 56, 112, 56, 224, 56, 255, 255, 255, 255, 255,
  255, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 15, 24, 48, 18, 1,
  0, 63, 252, 63, 252, 63, 252, 56, 0, 56, 0, 56, 0, 112, 0, 112,
  0, 119, 192, 127, 240, 127, 248, 120, 124, 112, 28, 0, 30, 0, 14, 0,
  14, 0, 14, 224, 14, 224, 30, 240, 28, 120, 124, 127, 248, 63, 240, 15,
  128, 15, 24, 48, 18, 1, 0, 3, 192, 15, 240, 31, 248, 60, 56, 56,
  28, 112, 28, 112, 0, 112, 0, 96, 0, 227, 192, 239, 240, 255, 248, 248,
  60, 240, 28, 240, 14, 224, 14, 224, 14, 96, 14, 112, 14, 112, 28, 56,
  60, 63, 248, 31, 240, 7, 192, 15, 24, 48, 18, 1, 0, 255, 254, 255,
  254, 255, 254, 0, 14, 0, 28, 0, 24, 0, 56, 0, 112, 0, 112, 0,
  224, 0, 224, 1, 192, 1, 192, 3, 128, 3, 128, 7, 0, 7, 0, 7,
  0, 14, 0, 14, 0, 14, 0, 28, 0, 28, 0, 28, 0, 15, 24, 48,
  18, 1, 0, 7, 192, 31, 240, 63, 248, 56, 60, 112, 28, 112, 28, 112,
  28, 112, 28, 120, 60, 60, 120, 31, 240, 15, 224, 63, 248, 120, 60, 112,
  28, 224, 14, 224, 14, 224, 14, 224, 14, 240, 28, 120, 60, 63, 248, 31,
  240, 7, 192, 15, 24, 48, 18, 1, 0, 7, 192, 31, 240, 63, 248, 120,
  124, 112, 60, 240, 28, 224, 30, 224, 14, 224, 14, 224, 14, 224, 30, 224,
  30, 112, 62, 127, 254, 63, 238, 15, 206, 0, 14, 0, 28, 224, 28, 240,
  60, 120, 120, 63, 240, 63, 224, 15, 128, 3, 18, 18, 9, 4, 0, 224,
  224, 224, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 224, 224,
  224, 3, 22, 22, 9, 4, 251, 224, 224, 224, 224, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 224, 224, 224, 224, 32, 96, 96, 192, 128, 16, 16, 32,
  19, 2, 0, 0, 3, 0, 15, 0, 63, 1, 252, 7, 224, 31, 128, 254,
  0, 240, 0, 240, 0, 254, 0, 31, 128, 7, 224, 1, 252, 0, 127, 0,
  15, 0, 3, 15, 9, 18, 19, 2, 4, 255, 254, 255, 254, 255, 254, 0,
  0, 0, 0, 0, 0, 255, 254, 255, 254, 255, 254, 16, 16, 32, 19, 1,
  0, 192, 0, 240, 0, 254, 0, 63, 128, 7, 224, 1, 248, 0, 127, 0,
  15, 0, 15, 0, 127, 1, 248, 7, 224, 63, 128, 254, 0, 240, 0, 192,
  0, 14, 25, 50, 18, 2, 0, 7, 192, 31, 240, 63, 248, 120, 56, 112,
  28, 240, 28, 224, 28, 224, 28, 0, 28, 0, 56, 0, 56, 0, 112, 0,
  224, 1, 224, 1, 192, 3, 128, 3, 128, 3, 128, 3, 128, 0, 0, 0,
  0, 3, 128, 3, 128, 3, 128, 3, 128, 29, 30, 120, 34, 1, 251, 0,
  7, 192, 0, 0, 63, 248, 0, 0, 255, 254, 0, 3, 240, 63, 128, 7,
  192, 7, 192, 15, 0, 3, 224, 30, 0, 1, 224, 28, 0, 0, 240, 56,
  15, 140, 112, 56, 31, 220, 56, 112, 60, 252, 56, 112, 112, 124, 56, 96,
  224, 56, 24, 224, 224, 56, 24, 225, 224, 56, 24, 225, 192, 112, 56, 225,
  192, 112, 56, 225, 192, 112, 112, 225, 192, 224, 112, 225, 224, 224, 224, 112,
  243, 243, 192, 112, 255, 127, 128, 120, 62, 127, 0, 60, 0, 0, 0, 30,
  0, 0, 0, 31, 0, 0, 0, 15, 128, 0, 0, 3, 224, 120, 0, 1,
  255, 248, 0, 0, 127, 224, 0, 20, 25, 75, 22, 1, 0, 0, 240, 0,
  0, 240, 0, 0, 248, 0, 1, 248, 0, 1, 248, 0, 3, 156, 0, 3,
  156, 0, 3, 156, 0, 7, 158, 0, 7, 14, 0, 7, 14, 0, 15, 15,
  0, 15, 15, 0, 14, 7, 0, 30, 7, 128, 31, 255, 128, 31, 255, 128,
  63, 255, 192, 60, 3, 192, 56, 1, 192, 120, 1, 224, 120, 1, 224, 112,
  0, 224, 240, 0, 240, 240, 0, 240, 17, 25, 75, 22, 3, 0, 255, 240,
  0, 255, 252, 0, 255, 254, 0, 224, 62, 0, 224, 15, 0, 224, 15, 0,
  224, 7, 0, 224, 7, 0, 224, 15, 0, 224, 14, 0, 224, 62, 0, 255,
  252, 0, 255, 252, 0, 255, 254, 0, 224, 31, 0, 224, 7, 128, 224, 3,
  128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 7, 128, 224, 15, 0,
  255, 254, 0, 255, 254, 0, 255, 248, 0, 20, 25, 75, 24, 2, 0, 1,
  252, 0, 7, 255, 0, 15, 255, 128, 31, 7, 192, 60, 1, 224, 56, 0,
  224, 112, 0, 240, 112, 0, 112, 224, 0, 0, 224, 0, 0, 224, 0, 0,
  224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224,
  0, 112, 240, 0, 112, 112, 0, 240, 120, 0, 224, 60, 1, 224, 63, 7,
  192, 31, 255, 128, 7, 254, 0, 1, 248, 0, 18, 25, 75, 24, 3, 0,
  255, 240, 0, 255, 252, 0, 255, 254, 0, 224, 31, 0, 224, 15, 0, 224,
  7, 128, 224, 3, 128, 224, 3, 128, 224, 1, 192, 224, 1, 192, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  224, 3, 192, 224, 3, 128, 224, 3, 128, 224, 7, 128, 224, 15, 0, 224,
  30, 0, 255, 254, 0, 255, 252, 0, 255, 240, 0, 17, 25, 75, 22, 3,
  0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 224, 0, 0, 224, 0, 0,
  224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224,
  0, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0,
  224, 0, 0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 16, 25, 50, 20,
  3, 0, 255, 255, 255, 255, 255, 255, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 255, 252, 255, 252, 255, 252, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 22, 25, 75, 25, 1, 0, 0, 254, 0, 3, 255, 128,
  15, 255, 192, 31, 131, 240, 62, 0, 240, 60, 0, 120, 120, 0, 56, 112,
  0, 56, 240, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 15,
  252, 224, 15, 252, 224, 15, 252, 224, 0, 28, 240, 0, 28, 112, 0, 28,
  120, 0, 60, 56, 0, 60, 60, 0, 252, 31, 1, 252, 15, 255, 220, 7,
  255, 28, 1, 252, 28, 18, 25, 75, 24, 3, 0, 224, 1, 192, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 255, 255, 192, 255,
  255, 192, 255, 255, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  224, 1, 192, 224, 1, 192, 3, 25, 25, 9, 3, 0, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 13, 25, 50, 16, 1, 0, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 224, 56, 224, 56, 224,
  56, 224, 56, 240, 120, 120, 240, 127, 240, 63, 224, 31, 128, 20, 25, 75,
  22, 3, 0, 224, 3, 192, 224, 7, 128, 224, 15, 0, 224, 30, 0, 224,
  60, 0, 224, 120, 0, 224, 240, 0, 225, 224, 0, 227, 192, 0, 231, 192,
  0, 239, 128, 0, 255, 192, 0, 255, 192, 0, 249, 224, 0, 240, 240, 0,
  224, 112, 0, 224, 120, 0, 224, 60, 0, 224, 28, 0, 224, 30, 0, 224,
  15, 0, 224, 7, 128, 224, 3, 192, 224, 3, 224, 224, 1, 240, 14, 25,
  50, 18, 3, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  255, 252, 255, 252, 255, 252, 21, 25, 75, 27, 3, 0, 240, 0, 120, 240,
  0, 120, 248, 0, 248, 248, 0, 248, 252, 1, 248, 252, 1, 248, 252, 1,
  248, 236, 1, 184, 238, 3, 184, 238, 3, 184, 230, 3, 56, 231, 7, 56,
  231, 7, 56, 227, 6, 56, 227, 142, 56, 227, 142, 56, 227, 142, 56, 225,
  140, 56, 225, 220, 56, 225, 220, 56, 224, 216, 56, 224, 248, 56, 224, 248,
  56, 224, 112, 56, 224, 112, 56, 19, 25, 75, 24, 2, 0, 240, 0, 224,
  240, 0, 224, 248, 0, 224, 252, 0, 224, 252, 0, 224, 254, 0, 224, 239,
  0, 224, 231, 0, 224, 231, 128, 224, 227, 192, 224, 227, 192, 224, 225, 224,
  224, 224, 224, 224, 224, 240, 224, 224, 120, 224, 224, 56, 224, 224, 60, 224,
  224, 28, 224, 224, 30, 224, 224, 15, 224, 224, 7, 224, 224, 7, 224, 224,
  3, 224, 224, 1, 224, 224, 1, 224, 23, 25, 75, 25, 1, 0, 0, 254,
  0, 3, 255, 128, 15, 239, 224, 31, 1, 240, 62, 0, 248, 60, 0, 120,
  120, 0, 60, 112, 0, 28, 240, 0, 30, 224, 0, 14, 224, 0, 14, 224,
  0, 14, 224, 0, 14, 224, 0, 14, 224, 0, 14, 224, 0, 14, 240, 0,
  30, 240, 0, 30, 120, 0, 60, 60, 0, 120, 62, 0, 248, 31, 1, 240,
  15, 239, 224, 3, 255, 128, 0, 254, 0, 17, 25, 75, 22, 3, 0, 255,
  248, 0, 255, 254, 0, 255, 255, 0, 224, 15, 0, 224, 7, 128, 224, 3,
  128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 7, 128,
  224, 15, 0, 255, 255, 0, 255, 254, 0, 255, 248, 0, 224, 0, 0, 224,
  0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 23, 26, 78, 26, 1, 255,
  0, 254, 0, 3, 255, 128, 15, 239, 224, 31, 1, 240, 62, 0, 248, 60,
  0, 120, 120, 0, 60, 112, 0, 28, 240, 0, 30, 224, 0, 14, 224, 0,
  14, 224, 0, 14, 224, 0, 14, 224, 0, 14, 224, 0, 14, 224, 0, 14,
  240, 0, 30, 240, 2, 30, 120, 7, 60, 60, 7, 184, 62, 3, 248, 31,
  1, 240, 15, 239, 248, 3, 255, 188, 0, 254, 30, 0, 0, 12, 19, 25,
  75, 24, 3, 0, 255, 252, 0, 255, 255, 0, 255, 255, 128, 224, 7, 128,
  224, 3, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224,
  3, 192, 224, 3, 128, 224, 15, 128, 255, 255, 0, 255, 254, 0, 255, 255,
  0, 224, 15, 128, 224, 7, 128, 224, 3, 128, 224, 3, 192, 224, 3, 192,
  224, 3, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 224, 19,
  25, 75, 22, 1, 0, 3, 248, 0, 15, 254, 0, 31, 255, 0, 60, 15,
  128, 56, 3, 192, 112, 1, 192, 112, 1, 192, 112, 0, 0, 120, 0, 0,
  124, 0, 0, 63, 192, 0, 31, 248, 0, 7, 255, 0, 0, 127, 128, 0,
  15, 192, 0, 1, 224, 0, 0, 224, 224, 0, 224, 240, 0, 224, 112, 1,
  224, 120, 1, 192, 62, 7, 192, 63, 255, 128, 15, 254, 0, 3, 248, 0,
  19, 25, 75, 20, 0, 0, 255, 255, 224, 255, 255, 224, 255, 255, 224, 0,
  224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224,
  0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0,
  224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224,
  0, 18, 25, 75, 24, 3, 0, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224,
  1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  240, 3, 192, 120, 7, 128, 124, 15, 128, 63, 255, 0, 31, 254, 0, 3,
  240, 0, 19, 25, 75, 22, 1, 0, 240, 1, 224, 240, 1, 224, 240, 1,
  224, 112, 1, 192, 120, 3, 192, 120, 3, 192, 56, 3, 128, 56, 3, 128,
  60, 7, 128, 28, 7, 0, 28, 7, 0, 30, 15, 0, 14, 14, 0, 14,
  14, 0, 15, 14, 0, 7, 28, 0, 7, 28, 0, 7, 156, 0, 3, 184,
  0, 3, 184, 0, 3, 184, 0, 1, 240, 0, 1, 240, 0, 0, 224, 0,
  0, 224, 0, 29, 25, 100, 31, 1, 0, 240, 7, 0, 120, 240, 7, 0,
  120, 240, 15, 128, 120, 112, 15, 128, 112, 112, 15, 128, 112, 120, 29, 192,
  240, 120, 29, 192, 240, 56, 29, 192, 224, 56, 29, 192, 224, 56, 56, 224,
  224, 60, 56, 225, 224, 28, 56, 225, 192, 28, 48, 225, 192, 28, 112, 113,
  192, 28, 112, 113, 192, 14, 112, 115, 128, 14, 224, 59, 128, 14, 224, 59,
  128, 14, 224, 59, 128, 7, 224, 63, 128, 7, 192, 31, 0, 7, 192, 31,
  0, 7, 192, 31, 0, 3, 128, 14, 0, 3, 128, 14, 0, 20, 25, 75,
  22, 1, 0, 248, 0, 240, 120, 1, 224, 60, 3, 192, 28, 3, 192, 30,
  7, 128, 15, 7, 0, 15, 15, 0, 7, 158, 0, 3, 156, 0, 3, 252,
  0, 1, 248, 0, 0, 240, 0, 0, 240, 0, 1, 248, 0, 1, 248, 0,
  3, 156, 0, 7, 158, 0, 7, 14, 0, 15, 15, 0, 30, 7, 128, 30,
  7, 128, 60, 3, 192, 120, 1, 224, 120, 1, 224, 240, 0, 240, 21, 25,
  75, 22, 0, 0, 240, 0, 120, 120, 0, 240, 120, 0, 224, 60, 1, 224,
  28, 1, 192, 30, 3, 192, 14, 7, 128, 15, 7, 128, 7, 143, 0, 3,
  142, 0, 3, 222, 0, 1, 220, 0, 1, 252, 0, 0, 248, 0, 0, 248,
  0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0,
  0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 18,
  25, 75, 20, 1, 0, 127, 255, 192, 127, 255, 192, 127, 255, 192, 0, 7,
  128, 0, 15, 128, 0, 15, 0, 0, 30, 0, 0, 60, 0, 0, 60, 0,
  0, 120, 0, 0, 240, 0, 1, 224, 0, 1, 224, 0, 3, 192, 0, 7,
  128, 0, 7, 128, 0, 15, 0, 0, 30, 0, 0, 60, 0, 0, 60, 0,
  0, 120, 0, 0, 240, 0, 0, 255, 255, 192, 255, 255, 192, 255, 255, 192,
  6, 32, 32, 9, 2, 249, 252, 252, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 252, 252, 9, 24, 48, 9, 0, 0, 192, 0, 192, 0,
  96, 0, 96, 0, 96, 0, 48, 0, 48, 0, 48, 0, 16, 0, 24, 0,
  24, 0, 24, 0, 12, 0, 12, 0, 12, 0, 6, 0, 6, 0, 6, 0,
  2, 0, 3, 0, 3, 0, 3, 0, 1, 128, 1, 128, 6, 32, 32, 9,
  1, 249, 252, 252, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  252, 252, 12, 13, 26, 16, 1, 11, 6, 0, 15, 0, 15, 0, 31, 128,
  25, 128, 25, 128, 57, 192, 48, 192, 112, 224, 96, 96, 96, 96, 224, 112,
  192, 48, 18, 2, 6, 18, 0, 250, 255, 255, 192, 255, 255, 192, 6, 5,
  5, 11, 1, 20, 224, 240, 112, 56, 28, 16, 18, 36, 18, 1, 0, 15,
  224, 63, 248, 60, 120, 112, 60, 112, 28, 0, 28, 0, 60, 1, 252, 31,
  252, 126, 28, 120, 28, 240, 28, 224, 28, 224, 60, 224, 124, 121, 254, 127,
  223, 63, 143, 15, 25, 50, 18, 2, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 227, 224, 239, 240, 255, 248, 248, 60, 240,
  28, 240, 30, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 240,
  30, 240, 28, 252, 60, 255, 248, 239, 240, 231, 224, 14, 18, 36, 16, 1,
  0, 7, 192, 31, 240, 63, 248, 56, 60, 112, 28, 112, 28, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 28, 224, 28, 112, 28, 120, 56, 63,
  248, 31, 240, 7, 192, 15, 25, 50, 18, 1, 0, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 7, 206, 31, 238, 63, 254, 124,
  62, 112, 30, 240, 30, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224,
  14, 240, 30, 240, 30, 120, 62, 127, 254, 63, 238, 15, 206, 15, 18, 36,
  18, 2, 0, 7, 192, 31, 240, 63, 248, 120, 60, 112, 28, 240, 14, 224,
  14, 224, 14, 255, 254, 255, 254, 224, 0, 224, 0, 240, 14, 112, 30, 120,
  60, 63, 248, 31, 240, 7, 192, 8, 25, 25, 9, 1, 0, 15, 31, 60,
  56, 56, 56, 56, 255, 255, 255, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 15, 25, 50, 18, 1, 249, 7, 206, 31, 238,
  63, 254, 124, 62, 112, 30, 240, 30, 224, 14, 224, 14, 224, 14, 224, 14,
  224, 14, 224, 14, 240, 30, 112, 62, 120, 62, 63, 254, 31, 238, 7, 142,
  0, 14, 224, 14, 224, 28, 240, 28, 124, 120, 63, 248, 31, 224, 14, 25,
  50, 18, 2, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 227, 224, 239, 240, 255, 248, 248, 60, 240, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 3, 25, 25, 7, 2, 0, 224, 224, 224, 224,
  0, 0, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 6, 32, 32, 7, 255, 249, 28, 28, 28, 28, 0,
  0, 0, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 60, 252, 248, 15, 25, 50, 16, 1,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  120, 224, 240, 225, 224, 227, 192, 231, 128, 239, 0, 255, 0, 255, 0, 251,
  128, 243, 192, 225, 192, 225, 224, 224, 224, 224, 240, 224, 120, 224, 56, 224,
  60, 224, 30, 3, 25, 25, 7, 2, 0, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 23, 18, 54, 27, 2, 0, 227, 192, 240, 239, 243, 252, 255, 247,
  252, 248, 126, 30, 240, 60, 14, 224, 56, 14, 224, 56, 14, 224, 56, 14,
  224, 56, 14, 224, 56, 14, 224, 56, 14, 224, 56, 14, 224, 56, 14, 224,
  56, 14, 224, 56, 14, 224, 56, 14, 224, 56, 14, 224, 56, 14, 14, 18,
  36, 18, 2, 0, 227, 224, 239, 248, 255, 248, 248, 60, 240, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 15, 18, 36, 18, 1, 0, 7, 192,
  31, 240, 63, 248, 120, 60, 112, 28, 240, 30, 224, 14, 224, 14, 224, 14,
  224, 14, 224, 14, 224, 14, 240, 30, 112, 28, 120, 60, 63, 248, 31, 240,
  7, 192, 15, 25, 50, 18, 2, 249, 3, 192, 239, 240, 255, 248, 248, 60,
  240, 28, 240, 30, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14,
  240, 30, 240, 28, 248, 60, 255, 248, 239, 240, 231, 224, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 15, 25, 50, 18, 1, 249,
  7, 192, 31, 238, 63, 254, 124, 62, 112, 30, 240, 30, 224, 14, 224, 14,
  224, 14, 224, 14, 224, 14, 224, 14, 240, 30, 112, 30, 120, 62, 63, 254,
  31, 238, 15, 206, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 8, 18, 18, 11, 2, 0, 231, 239, 255, 252, 240, 240, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 13, 18, 36, 16, 2, 0,
  15, 128, 63, 224, 127, 224, 112, 240, 224, 112, 224, 0, 112, 0, 126, 0,
  63, 192, 7, 240, 0, 240, 0, 120, 224, 56, 224, 56, 240, 112, 127, 240,
  127, 224, 31, 128, 8, 22, 22, 9, 1, 0, 56, 56, 56, 56, 255, 255,
  255, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 60, 63, 31,
  14, 18, 36, 18, 2, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 60, 240, 124, 127, 252, 127, 220, 31, 28, 15, 18, 36, 16, 0, 0,
  224, 14, 224, 14, 112, 28, 112, 28, 112, 28, 56, 56, 56, 56, 56, 56,
  28, 112, 28, 112, 28, 112, 14, 224, 14, 224, 14, 224, 7, 192, 7, 192,
  3, 128, 3, 128, 23, 18, 54, 23, 0, 0, 224, 56, 14, 224, 56, 14,
  112, 124, 28, 112, 124, 28, 112, 108, 28, 56, 238, 28, 56, 238, 56, 56,
  238, 56, 56, 198, 56, 24, 198, 48, 29, 199, 112, 29, 199, 112, 29, 199,
  112, 13, 131, 96, 15, 131, 224, 15, 131, 224, 7, 1, 192, 7, 1, 192,
  15, 18, 36, 16, 0, 0, 240, 30, 120, 28, 56, 56, 60, 112, 28, 112,
  14, 224, 15, 224, 7, 192, 3, 128, 7, 192, 7, 192, 15, 224, 30, 224,
  28, 112, 56, 120, 56, 56, 112, 28, 240, 30, 14, 25, 50, 16, 1, 249,
  224, 28, 224, 28, 240, 56, 112, 56, 112, 56, 112, 112, 56, 112, 56, 112,
  56, 224, 60, 224, 28, 224, 29, 192, 29, 192, 15, 192, 15, 128, 15, 128,
  7, 0, 7, 0, 7, 0, 14, 0, 14, 0, 28, 0, 124, 0, 120, 0,
  112, 0, 14, 18, 36, 16, 1, 0, 127, 248, 127, 248, 127, 248, 0, 120,
  0, 240, 0, 224, 1, 192, 3, 192, 7, 128, 7, 0, 14, 0, 28, 0,
  60, 0, 120, 0, 112, 0, 255, 252, 255, 252, 255, 252, 8, 32, 32, 11,
  1, 249, 15, 31, 28, 24, 24, 24, 24, 24, 24, 24, 24, 24, 56, 56,
  112, 224, 224, 112, 56, 56, 24, 24, 24, 24, 24, 24, 24, 24, 24, 28,
  31, 15, 2, 31, 31, 9, 3, 249, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 8, 32, 32, 11, 1, 249, 240, 248, 56,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 28, 28, 14, 7, 7, 14, 28,
  28, 24, 24, 24, 24, 24, 24, 24, 24, 24, 56, 248, 240, 14, 6, 12,
  19, 2, 9, 24, 0, 124, 12, 127, 12, 199, 220, 193, 248, 0, 240, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  0, 0, 0, 9, 0, 1, 3, 25, 25, 11, 4, 249, 224, 224, 224, 224,
  0, 0, 64, 64, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 14, 25, 50, 19, 2, 252, 0, 32, 0, 96, 0,
  64, 7, 224, 31, 240, 60, 248, 120, 188, 112, 156, 112, 156, 225, 128, 225,
  0, 225, 0, 227, 0, 227, 0, 226, 12, 226, 28, 118, 28, 124, 60, 60,
  120, 31, 240, 15, 224, 8, 0, 24, 0, 16, 0, 16, 0, 15, 24, 48,
  19, 1, 0, 3, 192, 15, 248, 31, 252, 60, 60, 120, 30, 112, 14, 112,
  14, 112, 0, 112, 0, 56, 0, 56, 0, 255, 192, 255, 192, 12, 0, 14,
  0, 14, 0, 12, 0, 28, 0, 24, 0, 56, 0, 115, 134, 255, 254, 255,
  254, 96, 124, 12, 13, 26, 18, 3, 5, 230, 48, 255, 240, 127, 240, 112,
  224, 96, 96, 224, 112, 224, 112, 224, 112, 96, 96, 112, 224, 127, 240, 255,
  240, 230, 48, 16, 24, 48, 18, 1, 0, 224, 7, 224, 7, 112, 14, 112,
  14, 56, 28, 56, 28, 28, 56, 28, 56, 14, 112, 14, 112, 7, 224, 127,
  254, 127, 254, 127, 254, 1, 192, 1, 192, 127, 254, 127, 254, 127, 254, 1,
  192, 1, 192, 1, 192, 1, 192, 1, 192, 2, 32, 32, 9, 3, 249, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 0, 0, 0, 0,
  0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 15,
  32, 64, 18, 1, 249, 3, 192, 15, 240, 31, 248, 28, 120, 56, 60, 56,
  28, 56, 28, 60, 0, 30, 0, 31, 128, 63, 224, 113, 240, 224, 248, 224,
  124, 224, 28, 224, 30, 112, 14, 124, 14, 62, 14, 31, 28, 15, 156, 3,
  248, 1, 240, 0, 240, 0, 120, 112, 56, 112, 56, 120, 56, 56, 112, 63,
  240, 31, 224, 7, 128, 8, 3, 3, 11, 1, 22, 231, 231, 231, 24, 25,
  75, 25, 0, 0, 0, 254, 0, 3, 255, 128, 7, 1, 224, 12, 0, 112,
  24, 0, 24, 48, 126, 12, 96, 255, 134, 97, 193, 198, 195, 128, 195, 195,
  0, 3, 199, 0, 3, 134, 0, 1, 134, 0, 1, 134, 0, 1, 134, 0,
  1, 199, 0, 3, 195, 128, 195, 97, 225, 198, 96, 255, 134, 48, 62, 12,
  24, 0, 24, 28, 0, 56, 7, 1, 224, 3, 255, 128, 0, 254, 0, 10,
  15, 30, 12, 1, 10, 63, 0, 119, 128, 97, 128, 1, 128, 7, 128, 127,
  128, 225, 128, 193, 128, 195, 128, 231, 128, 125, 192, 0, 0, 0, 0, 255,
  192, 255, 192, 12, 9, 18, 18, 3, 5, 28, 112, 56, 224, 113, 192, 227,
  128, 195, 0, 227, 128, 113, 192, 56, 224, 28, 112, 16, 9, 18, 19, 1,
  3, 255, 255, 255, 255, 255, 255, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 8, 2, 2, 11, 1, 8, 255, 255, 24, 25, 75, 25, 0,
  0, 0, 126, 0, 3, 255, 128, 7, 1, 224, 12, 0, 112, 24, 0, 24,
  48, 0, 12, 97, 255, 6, 97, 255, 134, 193, 129, 195, 193, 128, 195, 193,
  128, 195, 129, 129, 129, 129, 255, 1, 129, 252, 1, 129, 142, 1, 193, 134,
  3, 193, 131, 3, 97, 129, 134, 97, 129, 198, 48, 0, 12, 24, 0, 24,
  28, 0, 56, 7, 1, 224, 3, 255, 128, 0, 126, 0, 9, 2, 4, 11,
  1, 22, 255, 128, 255, 128, 9, 9, 18, 13, 2, 15, 62, 0, 127, 0,
  227, 128, 193, 128, 193, 128, 193, 128, 227, 128, 127, 0, 62, 0, 17, 21,
  63, 19, 1, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0,
  1, 192, 0, 1, 192, 0, 1, 192, 0, 255, 255, 128, 255, 255, 128, 255,
  255, 128, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192,
  0, 1, 192, 0, 0, 0, 0, 0, 0, 0, 255, 255, 128, 255, 255, 128,
  255, 255, 128, 9, 15, 30, 11, 1, 9, 30, 0, 127, 0, 99, 0, 193,
  128, 193, 128, 1, 128, 3, 0, 7, 0, 30, 0, 56, 0, 112, 0, 224,
  0, 192, 0, 255, 128, 255, 128, 9, 15, 30, 11, 1, 9, 62, 0, 127,
  0, 227, 128, 193, 128, 193, 128, 3, 128, 15, 0, 15, 0, 3, 128, 1,
  128, 193, 128, 193, 128, 227, 128, 127, 0, 62, 0, 7, 5, 5, 11, 3,
  22, 30, 60, 56, 112, 224, 14, 24, 48, 19, 2, 250, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 60, 240, 124, 255, 252, 255, 220, 255, 28,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 16, 30, 60, 17,
  1, 251, 7, 255, 31, 255, 63, 140, 63, 140, 127, 140, 127, 140, 255, 140,
  255, 140, 255, 140, 255, 140, 127, 140, 127, 140, 63, 140, 63, 140, 31, 140,
  3, 140, 1, 140, 1, 140, 1, 140, 1, 140, 1, 140, 1, 140, 1, 140,
  1, 140, 1, 140, 1, 140, 1, 140, 1, 140, 1, 140, 1, 140, 4, 4,
  4, 9, 3, 11, 96, 240, 240, 96, 7, 7, 7, 11, 2, 249, 24, 24,
  60, 14, 6, 206, 124, 5, 15, 15, 11, 2, 9, 24, 56, 248, 248, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 10, 15, 30, 12, 1, 10,
  30, 0, 127, 128, 97, 128, 225, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  225, 192, 97, 128, 127, 128, 30, 0, 0, 0, 255, 192, 255, 192, 12, 9,
  18, 18, 3, 5, 227, 128, 113, 192, 56, 224, 28, 112, 12, 48, 28, 112,
  56, 224, 113, 192, 227, 128, 25, 25, 100, 28, 1, 0, 0, 0, 48, 0,
  24, 0, 112, 0, 56, 0, 96, 0, 248, 0, 224, 0, 248, 1, 192, 0,
  24, 1, 128, 0, 24, 3, 128, 0, 24, 3, 0, 0, 24, 7, 0, 0,
  24, 14, 0, 0, 24, 12, 0, 0, 24, 28, 6, 0, 24, 24, 14, 0,
  24, 56, 30, 0, 24, 112, 62, 0, 24, 96, 118, 0, 0, 224, 102, 0,
  1, 192, 198, 0, 1, 129, 198, 0, 3, 131, 134, 0, 3, 3, 255, 128,
  7, 3, 255, 128, 6, 0, 6, 0, 14, 0, 6, 0, 12, 0, 6, 0,
  25, 25, 100, 28, 1, 0, 0, 0, 96, 0, 24, 0, 224, 0, 56, 0,
  192, 0, 248, 1, 128, 0, 248, 3, 128, 0, 24, 3, 0, 0, 24, 6,
  0, 0, 24, 14, 0, 0, 24, 12, 0, 0, 24, 28, 0, 0, 24, 24,
  0, 0, 24, 56, 60, 0, 24, 48, 255, 0, 24, 112, 195, 128, 24, 97,
  129, 128, 24, 193, 129, 128, 1, 192, 3, 128, 1, 128, 7, 0, 3, 128,
  14, 0, 3, 0, 60, 0, 6, 0, 112, 0, 14, 0, 224, 0, 12, 1,
  192, 0, 28, 1, 255, 128, 24, 1, 255, 128, 25, 24, 96, 28, 1, 0,
  62, 0, 14, 0, 127, 0, 12, 0, 99, 128, 24, 0, 193, 128, 56, 0,
  193, 128, 48, 0, 3, 128, 96, 0, 15, 0, 224, 0, 15, 128, 192, 0,
  1, 193, 128, 0, 0, 195, 128, 0, 192, 195, 6, 0, 192, 199, 14, 0,
  97, 206, 30, 0, 127, 140, 62, 0, 30, 24, 118, 0, 0, 56, 102, 0,
  0, 48, 198, 0, 0, 97, 198, 0, 0, 227, 134, 0, 1, 195, 255, 128,
  1, 131, 255, 128, 3, 0, 6, 0, 7, 0, 6, 0, 6, 0, 6, 0,
  14, 25, 50, 19, 3, 249, 3, 128, 3, 128, 3, 128, 3, 128, 0, 0,
  0, 0, 3, 128, 3, 128, 3, 128, 7, 128, 7, 0, 15, 0, 30, 0,
  60, 0, 120, 0, 112, 0, 240, 0, 224, 28, 224, 28, 224, 28, 240, 60,
  120, 120, 127, 240, 63, 224, 7, 128, 20, 31, 93, 22, 1, 0, 3, 192,
  0, 1, 224, 0, 0, 224, 0, 0, 112, 0, 0, 56, 0, 0, 0, 0,
  0, 240, 0, 0, 240, 0, 0, 240, 0, 1, 248, 0, 1, 248, 0, 3,
  252, 0, 3, 156, 0, 3, 156, 0, 7, 158, 0, 7, 14, 0, 7, 14,
  0, 15, 15, 0, 14, 15, 0, 14, 7, 0, 30, 7, 128, 31, 255, 128,
  31, 255, 128, 63, 255, 192, 60, 3, 192, 56, 1, 192, 120, 1, 224, 120,
  1, 224, 112, 0, 224, 240, 0, 240, 240, 0, 240, 20, 31, 93, 22, 1,
  0, 0, 60, 0, 0, 120, 0, 0, 112, 0, 0, 224, 0, 1, 192, 0,
  0, 0, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 1, 248, 0, 1,
  248, 0, 3, 252, 0, 3, 156, 0, 3, 156, 0, 7, 158, 0, 7, 14,
  0, 7, 14, 0, 15, 15, 0, 15, 15, 0, 14, 7, 0, 30, 7, 128,
  31, 255, 128, 31, 255, 128, 63, 255, 192, 60, 3, 192, 120, 1, 192, 120,
  1, 224, 120, 1, 224, 112, 0, 224, 240, 0, 240, 240, 0, 240, 20, 31,
  93, 22, 1, 0, 0, 64, 0, 0, 224, 0, 1, 240, 0, 3, 184, 0,
  7, 28, 0, 0, 0, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 1,
  248, 0, 1, 248, 0, 3, 252, 0, 3, 156, 0, 3, 156, 0, 7, 158,
  0, 7, 14, 0, 7, 14, 0, 15, 15, 0, 15, 15, 0, 14, 7, 0,
  30, 7, 128, 31, 255, 128, 31, 255, 128, 63, 255, 192, 60, 3, 192, 56,
  1, 192, 120, 1, 224, 120, 1, 224, 112, 0, 224, 240, 0, 240, 240, 0,
  240, 20, 30, 90, 22, 1, 0, 1, 198, 0, 3, 254, 0, 7, 252, 0,
  6, 56, 0, 0, 0, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 1,
  248, 0, 1, 248, 0, 3, 252, 0, 3, 156, 0, 3, 156, 0, 7, 158,
  0, 7, 14, 0, 7, 14, 0, 15, 15, 0, 15, 15, 0, 14, 7, 0,
  30, 7, 128, 31, 255, 128, 31, 255, 128, 63, 255, 192, 60, 3, 192, 56,
  1, 192, 120, 1, 224, 120, 1, 224, 112, 0, 224, 240, 0, 240, 240, 0,
  240, 20, 30, 90, 22, 1, 0, 3, 156, 0, 3, 156, 0, 3, 156, 0,
  0, 0, 0, 0, 0, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 1,
  248, 0, 1, 248, 0, 3, 252, 0, 3, 156, 0, 3, 156, 0, 7, 158,
  0, 7, 14, 0, 7, 14, 0, 15, 15, 0, 15, 15, 0, 14, 7, 0,
  30, 7, 128, 31, 255, 128, 31, 255, 128, 63, 255, 192, 60, 3, 192, 56,
  1, 192, 120, 1, 224, 120, 1, 224, 112, 0, 224, 240, 0, 240, 240, 0,
  240, 20, 31, 93, 22, 1, 0, 0, 240, 0, 1, 152, 0, 1, 8, 0,
  1, 8, 0, 1, 152, 0, 0, 240, 0, 0, 0, 0, 0, 240, 0, 0,
  240, 0, 1, 248, 0, 1, 248, 0, 3, 252, 0, 3, 156, 0, 3, 156,
  0, 7, 158, 0, 7, 14, 0, 7, 14, 0, 15, 15, 0, 14, 15, 0,
  14, 7, 0, 30, 7, 128, 31, 255, 128, 31, 255, 128, 63, 255, 192, 60,
  3, 192, 56, 1, 192, 120, 1, 224, 120, 1, 224, 112, 0, 224, 240, 0,
  240, 240, 0, 240, 29, 25, 100, 32, 1, 0, 0, 127, 255, 248, 0, 127,
  255, 248, 0, 255, 255, 248, 0, 227, 128, 0, 1, 195, 128, 0, 1, 195,
  128, 0, 3, 195, 128, 0, 3, 131, 128, 0, 3, 131, 128, 0, 7, 131,
  128, 0, 7, 3, 128, 0, 7, 3, 255, 240, 15, 3, 255, 240, 14, 3,
  255, 240, 30, 3, 128, 0, 31, 255, 128, 0, 31, 255, 128, 0, 63, 255,
  128, 0, 56, 3, 128, 0, 120, 3, 128, 0, 120, 3, 128, 0, 112, 3,
  128, 0, 240, 3, 255, 248, 224, 3, 255, 248, 224, 3, 255, 248, 20, 32,
  96, 23, 2, 249, 1, 248, 0, 7, 254, 0, 15, 255, 128, 31, 7, 128,
  60, 3, 192, 120, 1, 224, 112, 0, 224, 112, 0, 224, 240, 0, 0, 240,
  0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0,
  0, 240, 0, 112, 240, 0, 112, 112, 0, 240, 112, 0, 224, 120, 1, 224,
  60, 3, 192, 31, 7, 192, 15, 255, 128, 7, 254, 0, 1, 248, 0, 0,
  96, 0, 0, 96, 0, 0, 240, 0, 0, 56, 0, 0, 24, 0, 3, 56,
  0, 1, 240, 0, 17, 31, 93, 22, 3, 0, 15, 0, 0, 7, 128, 0,
  3, 128, 0, 1, 192, 0, 0, 224, 0, 0, 0, 0, 255, 255, 0, 255,
  255, 0, 255, 255, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 255, 255, 0,
  255, 255, 0, 255, 255, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224,
  0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 255, 255,
  128, 255, 255, 128, 255, 255, 128, 17, 31, 93, 22, 3, 0, 0, 120, 0,
  0, 240, 0, 0, 224, 0, 1, 192, 0, 3, 128, 0, 0, 0, 0, 255,
  255, 0, 255, 255, 0, 255, 255, 0, 224, 0, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0,
  255, 255, 0, 255, 255, 0, 255, 255, 0, 224, 0, 0, 224, 0, 0, 224,
  0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0,
  0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 17, 31, 93, 22, 3, 0,
  0, 128, 0, 1, 192, 0, 3, 224, 0, 7, 112, 0, 14, 56, 0, 0,
  0, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0,
  224, 0, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 224, 0, 0, 224,
  0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 17, 30, 90,
  22, 3, 0, 28, 56, 0, 28, 56, 0, 28, 56, 0, 0, 0, 0, 0,
  0, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0,
  224, 0, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 224, 0, 0, 224,
  0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 7, 31, 31,
  9, 0, 0, 240, 120, 56, 28, 14, 0, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 7, 31, 31, 9, 2, 0, 30, 60, 56, 112, 224, 0, 112, 112,
  112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
  112, 112, 112, 112, 112, 112, 112, 9, 31, 62, 9, 0, 0, 8, 0, 28,
  0, 62, 0, 119, 0, 227, 128, 0, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 9, 30, 60, 9, 0,
  0, 227, 128, 227, 128, 227, 128, 0, 0, 0, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 21, 25, 75,
  23, 0, 0, 31, 254, 0, 31, 255, 128, 31, 255, 192, 28, 3, 224, 28,
  0, 224, 28, 0, 240, 28, 0, 112, 28, 0, 112, 28, 0, 56, 28, 0,
  56, 28, 0, 56, 255, 192, 56, 255, 192, 56, 28, 0, 56, 28, 0, 56,
  28, 0, 56, 28, 0, 120, 28, 0, 112, 28, 0, 112, 28, 0, 240, 28,
  0, 224, 28, 3, 192, 31, 255, 192, 31, 255, 128, 31, 254, 0, 19, 30,
  90, 24, 2, 0, 1, 198, 0, 3, 254, 0, 7, 252, 0, 6, 56, 0,
  0, 0, 0, 240, 0, 224, 248, 0, 224, 248, 0, 224, 252, 0, 224, 252,
  0, 224, 254, 0, 224, 239, 0, 224, 231, 0, 224, 231, 128, 224, 227, 192,
  224, 227, 192, 224, 225, 224, 224, 224, 224, 224, 224, 240, 224, 224, 120, 224,
  224, 56, 224, 224, 60, 224, 224, 28, 224, 224, 30, 224, 224, 15, 224, 224,
  7, 224, 224, 7, 224, 224, 3, 224, 224, 1, 224, 224, 1, 224, 23, 31,
  93, 25, 1, 0, 0, 240, 0, 0, 120, 0, 0, 56, 0, 0, 28, 0,
  0, 14, 0, 0, 0, 0, 0, 254, 0, 3, 255, 128, 15, 255, 224, 31,
  1, 240, 62, 0, 248, 60, 0, 120, 120, 0, 60, 112, 0, 28, 112, 0,
  28, 240, 0, 30, 224, 0, 14, 224, 0, 14, 224, 0, 14, 224, 0, 14,
  224, 0, 14, 240, 0, 30, 240, 0, 30, 112, 0, 28, 120, 0, 60, 60,
  0, 120, 62, 0, 248, 31, 1, 240, 15, 255, 224, 3, 255, 128, 0, 254,
  0, 23, 31, 93, 25, 1, 0, 0, 15, 0, 0, 30, 0, 0, 28, 0,
  0, 56, 0, 0, 112, 0, 0, 0, 0, 0, 254, 0, 3, 255, 128, 15,
  255, 224, 31, 1, 240, 62, 0, 248, 60, 0, 120, 120, 0, 60, 112, 0,
  28, 112, 0, 28, 240, 0, 30, 224, 0, 14, 224, 0, 14, 224, 0, 14,
  224, 0, 14, 224, 0, 14, 240, 0, 30, 240, 0, 30, 112, 0, 28, 120,
  0, 60, 60, 0, 120, 62, 0, 248, 31, 1, 240, 15, 255, 224, 3, 255,
  128, 0, 254, 0, 23, 31, 93, 25, 1, 0, 0, 16, 0, 0, 56, 0,
  0, 124, 0, 0, 238, 0, 1, 199, 0, 0, 0, 0, 0, 254, 0, 3,
  255, 128, 15, 255, 224, 31, 1, 240, 62, 0, 248, 60, 0, 120, 120, 0,
  60, 112, 0, 28, 112, 0, 28, 240, 0, 30, 224, 0, 14, 224, 0, 14,
  224, 0, 14, 224, 0, 14, 224, 0, 14, 240, 0, 30, 240, 0, 30, 112,
  0, 28, 120, 0, 60, 60, 0, 120, 62, 0, 248, 31, 1, 240, 15, 255,
  224, 3, 255, 128, 0, 254, 0, 23, 30, 90, 25, 1, 0, 0, 113, 128,
  0, 255, 128, 1, 255, 0, 1, 142, 0, 0, 0, 0, 0, 254, 0, 3,
  255, 128, 15, 255, 224, 31, 1, 240, 62, 0, 248, 60, 0, 120, 120, 0,
  60, 112, 0, 28, 112, 0, 28, 240, 0, 30, 224, 0, 14, 224, 0, 14,
  224, 0, 14, 224, 0, 14, 224, 0, 14, 240, 0, 30, 240, 0, 30, 112,
  0, 28, 120, 0, 60, 60, 0, 120, 62, 0, 248, 31, 1, 240, 15, 255,
  224, 3, 255, 128, 0, 254, 0, 23, 29, 87, 25, 1, 0, 1, 195, 128,
  1, 195, 128, 1, 195, 128, 0, 0, 0, 0, 254, 0, 3, 255, 128, 15,
  255, 224, 31, 1, 240, 62, 0, 248, 60, 0, 120, 120, 0, 60, 112, 0,
  28, 112, 0, 28, 240, 0, 30, 224, 0, 14, 224, 0, 14, 224, 0, 14,
  224, 0, 14, 224, 0, 14, 240, 0, 30, 240, 0, 30, 112, 0, 28, 120,
  0, 60, 60, 0, 120, 62, 0, 248, 31, 1, 240, 15, 255, 224, 3, 255,
  128, 0, 254, 0, 15, 15, 30, 19, 2, 1, 64, 4, 224, 14, 240, 30,
  120, 60, 60, 120, 31, 240, 15, 224, 7, 192, 7, 192, 15, 224, 30, 240,
  60, 120, 120, 60, 240, 30, 96, 12, 23, 25, 75, 25, 1, 0, 0, 254,
  6, 3, 255, 140, 15, 255, 248, 31, 1, 240, 62, 0, 248, 60, 0, 248,
  120, 1, 188, 112, 3, 28, 112, 6, 28, 240, 6, 30, 224, 12, 14, 224,
  24, 14, 224, 48, 14, 224, 96, 14, 224, 192, 14, 225, 128, 30, 243, 0,
  30, 118, 0, 28, 124, 0, 60, 60, 0, 120, 62, 0, 248, 63, 1, 240,
  111, 255, 224, 195, 255, 128, 0, 254, 0, 18, 31, 93, 24, 3, 0, 7,
  128, 0, 3, 192, 0, 1, 192, 0, 0, 224, 0, 0, 112, 0, 0, 0,
  0, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224,
  1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 240, 3, 192, 120, 7, 128,
  124, 15, 128, 63, 255, 0, 31, 254, 0, 3, 240, 0, 18, 31, 93, 24,
  3, 0, 0, 120, 0, 0, 240, 0, 0, 224, 0, 1, 192, 0, 3, 128,
  0, 0, 0, 0, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224,
  1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 240, 3, 192,
  120, 7, 128, 124, 15, 128, 63, 255, 0, 31, 254, 0, 3, 240, 0, 18,
  31, 93, 24, 3, 0, 0, 64, 0, 0, 224, 0, 1, 240, 0, 3, 184,
  0, 7, 28, 0, 0, 0, 0, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224,
  1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  240, 3, 192, 120, 7, 128, 124, 15, 128, 63, 255, 0, 31, 254, 0, 3,
  240, 0, 18, 30, 90, 24, 3, 0, 14, 28, 0, 14, 28, 0, 14, 28,
  0, 0, 0, 0, 0, 0, 0, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224,
  1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  240, 3, 192, 120, 7, 128, 124, 15, 128, 63, 255, 0, 31, 254, 0, 3,
  240, 0, 19, 31, 93, 22, 1, 0, 0, 60, 0, 0, 120, 0, 0, 112,
  0, 0, 224, 0, 1, 192, 0, 0, 0, 0, 224, 0, 224, 240, 1, 224,
  112, 1, 192, 120, 3, 192, 56, 3, 128, 60, 7, 128, 28, 15, 0, 30,
  15, 0, 15, 30, 0, 7, 28, 0, 7, 188, 0, 3, 184, 0, 3, 248,
  0, 1, 240, 0, 1, 240, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0,
  224, 0, 0, 224, 0, 17, 25, 75, 22, 3, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 255, 248, 0, 255, 254, 0,
  255, 255, 0, 224, 15, 0, 224, 7, 0, 224, 7, 128, 224, 3, 128, 224,
  3, 128, 224, 7, 128, 224, 7, 0, 224, 15, 0, 255, 254, 0, 255, 252,
  0, 255, 248, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0,
  224, 0, 0, 224, 0, 0, 14, 25, 50, 20, 4, 0, 15, 128, 63, 224,
  127, 240, 120, 240, 240, 120, 224, 56, 224, 56, 224, 56, 224, 120, 224, 240,
  227, 224, 227, 224, 227, 240, 224, 120, 224, 60, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 56, 224, 120, 231, 240, 231, 224, 231, 128, 16, 25,
  50, 18, 1, 0, 15, 0, 7, 128, 3, 128, 1, 192, 0, 224, 0, 0,
  0, 0, 15, 224, 63, 248, 60, 124, 112, 28, 112, 28, 0, 28, 0, 28,
  0, 252, 31, 252, 127, 156, 120, 28, 240, 28, 224, 28, 224, 60, 224, 124,
  121, 252, 127, 223, 63, 143, 16, 25, 50, 18, 1, 0, 0, 240, 1, 224,
  1, 192, 3, 128, 7, 0, 0, 0, 0, 0, 15, 224, 63, 248, 60, 124,
  112, 28, 112, 28, 0, 28, 0, 28, 0, 252, 31, 252, 127, 156, 120, 28,
  240, 28, 224, 28, 224, 60, 224, 124, 120, 252, 127, 223, 63, 143, 16, 25,
  50, 18, 1, 0, 1, 0, 3, 128, 7, 192, 14, 224, 28, 112, 0, 0,
  0, 0, 15, 224, 63, 248, 60, 124, 112, 28, 112, 28, 0, 28, 0, 28,
  0, 252, 31, 252, 127, 156, 120, 28, 240, 28, 224, 28, 224, 60, 224, 124,
  120, 252, 127, 223, 63, 143, 16, 24, 48, 18, 1, 0, 7, 24, 15, 248,
  31, 240, 24, 224, 0, 0, 0, 0, 15, 224, 63, 248, 60, 124, 112, 28,
  112, 28, 0, 28, 0, 28, 0, 252, 31, 252, 127, 156, 120, 28, 240, 28,
  224, 28, 224, 60, 224, 124, 120, 252, 127, 223, 63, 143, 16, 23, 46, 18,
  1, 0, 14, 112, 14, 112, 14, 112, 0, 0, 0, 0, 15, 224, 63, 248,
  60, 252, 112, 28, 112, 28, 0, 28, 0, 28, 0, 252, 31, 252, 127, 156,
  120, 28, 240, 28, 224, 28, 224, 60, 224, 124, 121, 252, 127, 223, 63, 143,
  16, 25, 50, 18, 1, 0, 3, 128, 6, 192, 4, 64, 4, 64, 6, 192,
  3, 128, 0, 0, 15, 224, 63, 248, 60, 124, 112, 28, 112, 28, 0, 28,
  0, 28, 0, 252, 31, 252, 127, 156, 120, 28, 240, 28, 224, 28, 224, 60,
  224, 124, 120, 252, 127, 223, 63, 143, 26, 18, 72, 29, 1, 0, 7, 192,
  248, 0, 31, 241, 254, 0, 60, 127, 143, 0, 112, 62, 3, 128, 112, 30,
  3, 128, 0, 28, 1, 192, 0, 28, 1, 192, 0, 252, 1, 192, 15, 255,
  255, 192, 63, 255, 255, 192, 126, 31, 255, 192, 240, 28, 0, 0, 224, 28,
  1, 192, 224, 30, 1, 192, 224, 126, 3, 128, 248, 247, 143, 0, 127, 231,
  255, 0, 63, 129, 252, 0, 14, 25, 50, 17, 1, 249, 7, 192, 31, 240,
  63, 248, 56, 56, 112, 28, 112, 28, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 28, 224, 28, 112, 56, 120, 120, 63, 240, 31, 224, 7, 128,
  3, 0, 3, 0, 7, 128, 1, 192, 0, 192, 25, 192, 15, 128, 15, 25,
  50, 18, 1, 0, 30, 0, 15, 0, 7, 0, 3, 128, 1, 192, 0, 0,
  0, 0, 7, 192, 31, 240, 62, 120, 120, 28, 112, 28, 240, 14, 224, 14,
  224, 14, 255, 254, 255, 254, 224, 0, 224, 0, 224, 14, 112, 14, 120, 28,
  60, 124, 31, 240, 15, 224, 15, 25, 50, 18, 1, 0, 1, 224, 3, 192,
  3, 128, 7, 0, 14, 0, 0, 0, 0, 0, 7, 192, 31, 240, 60, 120,
  120, 28, 112, 28, 240, 14, 224, 14, 224, 14, 255, 254, 255, 254, 224, 0,
  224, 0, 224, 14, 112, 14, 120, 28, 60, 124, 31, 240, 15, 224, 15, 25,
  50, 18, 1, 0, 1, 0, 3, 128, 7, 192, 14, 224, 28, 112, 0, 0,
  0, 0, 7, 192, 31, 240, 60, 120, 120, 28, 112, 28, 240, 14, 224, 14,
  224, 14, 255, 254, 255, 254, 224, 0, 224, 0, 224, 14, 112, 14, 120, 28,
  60, 124, 31, 240, 7, 192, 15, 23, 46, 18, 1, 0, 28, 112, 28, 112,
  28, 112, 0, 0, 0, 0, 7, 192, 31, 240, 60, 120, 120, 28, 112, 28,
  240, 14, 224, 14, 224, 14, 255, 254, 255, 254, 224, 0, 224, 0, 224, 14,
  112, 14, 120, 28, 60, 124, 31, 240, 7, 192, 7, 25, 25, 9, 0, 0,
  240, 120, 56, 28, 14, 0, 0, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 7, 25, 25, 9, 2, 0, 30,
  60, 56, 112, 224, 0, 0, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112,
  112, 112, 112, 112, 112, 112, 112, 112, 9, 25, 50, 9, 0, 0, 8, 0,
  28, 0, 62, 0, 119, 0, 227, 128, 0, 0, 0, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  8, 23, 23, 9, 1, 0, 231, 231, 231, 0, 0, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 15, 25, 50,
  19, 1, 0, 120, 64, 60, 224, 31, 192, 15, 128, 31, 128, 59, 192, 17,
  224, 7, 240, 31, 248, 63, 248, 120, 60, 112, 28, 112, 28, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 224, 14, 112, 28, 112, 28, 120, 60, 63,
  248, 31, 240, 7, 192, 14, 24, 48, 18, 2, 0, 14, 48, 31, 240, 63,
  224, 49, 192, 0, 0, 0, 0, 3, 192, 239, 240, 255, 248, 248, 60, 240,
  28, 240, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224,
  28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 15, 25, 50, 19, 1,
  0, 30, 0, 15, 0, 7, 0, 3, 128, 1, 192, 0, 0, 0, 0, 7,
  192, 31, 240, 63, 248, 120, 60, 112, 28, 112, 28, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 112, 28, 112, 28, 120, 60, 63, 248, 31,
  240, 7, 192, 15, 25, 50, 19, 1, 0, 1, 224, 3, 192, 3, 128, 7,
  0, 14, 0, 0, 0, 0, 0, 7, 192, 31, 240, 63, 248, 120, 60, 112,
  28, 112, 28, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 112,
  28, 112, 28, 120, 60, 63, 248, 31, 240, 7, 192, 15, 25, 50, 19, 1,
  0, 1, 0, 3, 128, 7, 192, 14, 224, 28, 112, 0, 0, 0, 0, 7,
  192, 31, 240, 63, 248, 120, 60, 112, 28, 112, 28, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 112, 28, 112, 28, 120, 60, 63, 248, 31,
  240, 7, 192, 15, 24, 48, 19, 1, 0, 14, 48, 31, 240, 63, 224, 49,
  192, 0, 0, 0, 0, 7, 192, 31, 240, 63, 248, 120, 60, 112, 28, 112,
  28, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 112, 28, 112,
  28, 120, 60, 63, 248, 31, 240, 7, 192, 15, 23, 46, 19, 1, 0, 28,
  112, 28, 112, 28, 112, 0, 0, 0, 0, 7, 192, 31, 240, 63, 248, 120,
  60, 112, 28, 112, 28, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224,
  14, 112, 28, 112, 28, 120, 60, 63, 248, 31, 240, 7, 192, 15, 15, 30,
  19, 2, 1, 3, 128, 3, 128, 3, 128, 0, 0, 0, 0, 0, 0, 255,
  254, 255, 254, 255, 254, 0, 0, 0, 0, 0, 0, 3, 128, 3, 128, 3,
  128, 16, 18, 36, 19, 2, 0, 7, 195, 31, 246, 63, 252, 120, 120, 112,
  28, 112, 60, 224, 110, 224, 206, 225, 142, 227, 14, 230, 14, 236, 14, 120,
  28, 112, 28, 56, 60, 127, 248, 223, 240, 135, 192, 14, 25, 50, 19, 2,
  0, 30, 0, 15, 0, 7, 0, 3, 128, 1, 192, 0, 0, 0, 0, 224,
  28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224,
  28, 224, 28, 224, 28, 224, 28, 224, 60, 224, 60, 240, 252, 127, 252, 63,
  220, 15, 0, 14, 25, 50, 19, 2, 0, 1, 224, 3, 192, 3, 128, 7,
  0, 14, 0, 0, 0, 0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224,
  28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224,
  60, 224, 60, 240, 252, 127, 252, 63, 220, 15, 0, 14, 25, 50, 19, 2,
  0, 1, 0, 3, 128, 7, 192, 14, 224, 28, 112, 0, 0, 0, 0, 224,
  28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224,
  28, 224, 28, 224, 28, 224, 28, 224, 60, 224, 60, 240, 252, 127, 252, 63,
  220, 15, 0, 14, 23, 46, 19, 2, 0, 28, 224, 28, 224, 28, 224, 0,
  0, 0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224,
  28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 60, 224, 60, 240,
  252, 127, 252, 63, 220, 15, 0, 14, 32, 64, 17, 1, 249, 0, 240, 1,
  224, 1, 192, 3, 128, 7, 0, 0, 0, 0, 0, 224, 28, 224, 28, 224,
  60, 112, 56, 112, 56, 112, 56, 120, 112, 56, 112, 56, 240, 60, 224, 28,
  224, 29, 192, 29, 192, 15, 192, 15, 128, 15, 128, 7, 0, 7, 0, 7,
  0, 14, 0, 14, 0, 30, 0, 124, 0, 124, 0, 112, 0, 15, 31, 62,
  19, 2, 250, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 231, 224, 239, 240, 255, 248, 248, 60, 240, 28, 240, 30, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 224, 14, 240, 28, 240, 28, 248, 60, 255,
  248, 239, 240, 227, 192, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 14, 30, 60, 17, 1, 249, 28, 112, 28, 112, 28, 112, 0, 0, 0,
  0, 224, 28, 224, 28, 224, 60, 112, 56, 112, 56, 112, 120, 120, 112, 56,
  112, 56, 240, 60, 224, 28, 224, 29, 192, 29, 192, 15, 192, 15, 128, 15,
  128, 7, 0, 7, 0, 7, 0, 14, 0, 14, 0, 30, 0, 124, 0, 124,
  0, 112, 0
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--34-240-100-100-P-176-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 0, '1' Height: 24
  Calculated Max Values w=17 h=24 x= 4 y=15 dx=19 dy= 0 ascent=26 len=48
  Font Bounding box     w=39 h=48 x=-5 y=-11
  Calculated Min Values           x= 0 y=-5 dx= 0 dy= 0
  Pure Font   ascent =24 descent= 0
  X Font      ascent =24 descent= 0
  Max Font    ascent =26 descent=-5
*/
const u8g_fntpgm_uint8_t u8g_font_helvR24n[726] U8G_FONT_SECTION("u8g_font_helvR24n") = {
  0, 39, 48, 251, 245, 24, 0, 0, 0, 0, 42, 58, 0, 26, 251, 24,
  0, 10, 11, 22, 13, 1, 15, 12, 0, 12, 0, 76, 128, 237, 192, 127,
  128, 63, 0, 30, 0, 63, 0, 115, 128, 225, 192, 64, 128, 17, 16, 48,
  19, 1, 1, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1,
  192, 0, 1, 192, 0, 1, 192, 0, 255, 255, 128, 255, 255, 128, 255, 255,
  128, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0,
  1, 192, 0, 3, 9, 9, 9, 3, 251, 224, 224, 224, 224, 32, 96, 96,
  192, 128, 8, 2, 2, 11, 1, 8, 255, 255, 3, 4, 4, 9, 3, 0,
  224, 224, 224, 224, 9, 24, 48, 9, 0, 0, 1, 128, 1, 128, 1, 128,
  3, 0, 3, 0, 3, 0, 6, 0, 6, 0, 6, 0, 12, 0, 12, 0,
  12, 0, 8, 0, 24, 0, 24, 0, 24, 0, 48, 0, 48, 0, 48, 0,
  96, 0, 96, 0, 96, 0, 192, 0, 192, 0, 15, 24, 48, 18, 1, 0,
  7, 192, 31, 240, 63, 248, 60, 120, 120, 60, 112, 28, 112, 28, 224, 14,
  224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14,
  224, 14, 112, 28, 112, 28, 112, 60, 60, 120, 63, 248, 31, 240, 7, 192,
  8, 24, 24, 18, 3, 0, 3, 7, 7, 15, 63, 255, 255, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 15, 24,
  48, 18, 1, 0, 7, 192, 31, 240, 63, 248, 120, 60, 112, 28, 240, 14,
  224, 14, 224, 14, 0, 14, 0, 28, 0, 60, 0, 120, 0, 240, 3, 224,
  7, 192, 31, 0, 60, 0, 120, 0, 112, 0, 224, 0, 224, 0, 255, 254,
  255, 254, 255, 254, 15, 24, 48, 18, 1, 0, 7, 192, 31, 240, 63, 248,
  56, 56, 112, 28, 112, 28, 112, 28, 112, 28, 0, 28, 0, 56, 3, 248,
  3, 240, 3, 248, 0, 60, 0, 30, 0, 14, 224, 14, 224, 14, 224, 14,
  112, 28, 120, 60, 63, 248, 31, 240, 7, 192, 16, 24, 48, 18, 0, 0,
  0, 24, 0, 56, 0, 120, 0, 120, 0, 248, 1, 248, 3, 184, 3, 184,
  7, 56, 14, 56, 14, 56, 28, 56, 56, 56, 56, 56, 112, 56, 224, 56,
  255, 255, 255, 255, 255, 255, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56,
  15, 24, 48, 18, 1, 0, 63, 252, 63, 252, 63, 252, 56, 0, 56, 0,
  56, 0, 112, 0, 112, 0, 119, 192, 127, 240, 127, 248, 120, 124, 112, 28,
  0, 30, 0, 14, 0, 14, 0, 14, 224, 14, 224, 30, 240, 28, 120, 124,
  127, 248, 63, 240, 15, 128, 15, 24, 48, 18, 1, 0, 3, 192, 15, 240,
  31, 248, 60, 56, 56, 28, 112, 28, 112, 0, 112, 0, 96, 0, 227, 192,
  239, 240, 255, 248, 248, 60, 240, 28, 240, 14, 224, 14, 224, 14, 96, 14,
  112, 14, 112, 28, 56, 60, 63, 248, 31, 240, 7, 192, 15, 24, 48, 18,
  1, 0, 255, 254, 255, 254, 255, 254, 0, 14, 0, 28, 0, 24, 0, 56,
  0, 112, 0, 112, 0, 224, 0, 224, 1, 192, 1, 192, 3, 128, 3, 128,
  7, 0, 7, 0, 7, 0, 14, 0, 14, 0, 14, 0, 28, 0, 28, 0,
  28, 0, 15, 24, 48, 18, 1, 0, 7, 192, 31, 240, 63, 248, 56, 60,
  112, 28, 112, 28, 112, 28, 112, 28, 120, 60, 60, 120, 31, 240, 15, 224,
  63, 248, 120, 60, 112, 28, 224, 14, 224, 14, 224, 14, 224, 14, 240, 28,
  120, 60, 63, 248, 31, 240, 7, 192, 15, 24, 48, 18, 1, 0, 7, 192,
  31, 240, 63, 248, 120, 124, 112, 60, 240, 28, 224, 30, 224, 14, 224, 14,
  224, 14, 224, 30, 224, 30, 112, 62, 127, 254, 63, 238, 15, 206, 0, 14,
  0, 28, 224, 28, 240, 60, 120, 120, 63, 240, 63, 224, 15, 128, 3, 18,
  18, 9, 4, 0, 224, 224, 224, 224, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 224, 224, 224, 224
};

/*
  Fontname: -Adobe-Helvetica-Medium-R-Normal--34-240-100-100-P-176-ISO10646-1
  Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
  Capital A Height: 25, '1' Height: 24
  Calculated Max Values w=29 h=32 x= 4 y=20 dx=34 dy= 0 ascent=27 len=120
  Font Bounding box     w=39 h=48 x=-5 y=-11
  Calculated Min Values           x=-1 y=-7 dx= 0 dy= 0
  Pure Font   ascent =25 descent=-7
  X Font      ascent =25 descent=-7
  Max Font    ascent =27 descent=-7
*/
const u8g_fntpgm_uint8_t u8g_font_helvR24r[4992] U8G_FONT_SECTION("u8g_font_helvR24r") = {
  0, 39, 48, 251, 245, 25, 5, 215, 14, 105, 32, 127, 249, 27, 249, 25,
  249, 0, 0, 0, 9, 0, 1, 3, 25, 25, 9, 4, 0, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 64, 64,
  0, 0, 224, 224, 224, 224, 8, 8, 8, 12, 2, 15, 231, 231, 231, 231,
  231, 231, 66, 66, 17, 23, 69, 19, 1, 0, 3, 135, 0, 3, 135, 0,
  3, 6, 0, 3, 6, 0, 7, 14, 0, 7, 14, 0, 127, 255, 128, 127,
  255, 128, 127, 255, 128, 14, 28, 0, 14, 28, 0, 12, 24, 0, 28, 56,
  0, 28, 56, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 56, 112, 0,
  56, 112, 0, 48, 96, 0, 48, 96, 0, 112, 224, 0, 112, 224, 0, 16,
  31, 62, 18, 1, 252, 1, 128, 1, 128, 1, 128, 15, 240, 31, 248, 61,
  188, 113, 142, 113, 142, 225, 142, 225, 128, 225, 128, 113, 128, 125, 128, 63,
  192, 31, 240, 7, 252, 1, 254, 1, 158, 1, 143, 1, 135, 225, 135, 225,
  135, 113, 142, 113, 142, 61, 188, 63, 248, 15, 240, 1, 128, 1, 128, 1,
  128, 1, 128, 26, 24, 96, 29, 1, 0, 0, 0, 48, 0, 31, 0, 112,
  0, 127, 128, 96, 0, 115, 192, 224, 0, 224, 192, 192, 0, 192, 225, 192,
  0, 192, 225, 128, 0, 192, 227, 128, 0, 224, 195, 0, 0, 115, 199, 0,
  0, 127, 134, 0, 0, 31, 14, 0, 0, 0, 12, 0, 0, 0, 28, 62,
  0, 0, 24, 127, 128, 0, 56, 243, 128, 0, 48, 193, 192, 0, 113, 192,
  192, 0, 97, 192, 192, 0, 225, 192, 192, 0, 192, 193, 192, 1, 192, 227,
  128, 1, 128, 127, 128, 3, 128, 62, 0, 18, 23, 69, 22, 2, 0, 7,
  192, 0, 15, 224, 0, 30, 112, 0, 60, 56, 0, 56, 56, 0, 56, 56,
  0, 60, 112, 0, 30, 240, 0, 15, 224, 0, 7, 192, 0, 15, 128, 0,
  63, 192, 0, 121, 199, 0, 112, 231, 0, 224, 246, 0, 224, 126, 0, 224,
  60, 0, 224, 28, 0, 240, 62, 0, 120, 127, 0, 127, 247, 128, 63, 227,
  192, 15, 0, 0, 3, 8, 8, 6, 2, 15, 224, 224, 224, 224, 224, 224,
  224, 64, 7, 31, 31, 11, 2, 249, 6, 12, 12, 24, 24, 56, 48, 112,
  112, 112, 96, 224, 224, 224, 224, 224, 224, 224, 224, 224, 96, 112, 112, 112,
  48, 56, 24, 24, 12, 12, 6, 7, 31, 31, 11, 1, 249, 192, 96, 96,
  48, 48, 56, 24, 28, 28, 28, 12, 14, 14, 14, 14, 14, 14, 14, 14,
  12, 12, 28, 28, 24, 24, 56, 48, 112, 96, 96, 192, 10, 11, 22, 13,
  1, 15, 12, 0, 12, 0, 76, 128, 237, 192, 127, 128, 63, 0, 30, 0,
  63, 0, 115, 128, 225, 192, 64, 128, 17, 16, 48, 19, 1, 1, 1, 192,
  0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0,
  1, 192, 0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 1, 192, 0, 1,
  192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 3, 9,
  9, 9, 3, 251, 224, 224, 224, 224, 32, 96, 96, 192, 128, 8, 2, 2,
  11, 1, 8, 255, 255, 3, 4, 4, 9, 3, 0, 224, 224, 224, 224, 9,
  24, 48, 9, 0, 0, 1, 128, 1, 128, 1, 128, 3, 0, 3, 0, 3,
  0, 6, 0, 6, 0, 6, 0, 12, 0, 12, 0, 12, 0, 8, 0, 24,
  0, 24, 0, 24, 0, 48, 0, 48, 0, 48, 0, 96, 0, 96, 0, 96,
  0, 192, 0, 192, 0, 15, 24, 48, 18, 1, 0, 7, 192, 31, 240, 63,
  248, 60, 120, 120, 60, 112, 28, 112, 28, 224, 14, 224, 14, 224, 14, 224,
  14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 112, 28, 112,
  28, 112, 60, 60, 120, 63, 248, 31, 240, 7, 192, 8, 24, 24, 18, 3,
  0, 3, 7, 7, 15, 63, 255, 255, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 15, 24, 48, 18, 1, 0, 7,
  192, 31, 240, 63, 248, 120, 60, 112, 28, 240, 14, 224, 14, 224, 14, 0,
  14, 0, 28, 0, 60, 0, 120, 0, 240, 3, 224, 7, 192, 31, 0, 60,
  0, 120, 0, 112, 0, 224, 0, 224, 0, 255, 254, 255, 254, 255, 254, 15,
  24, 48, 18, 1, 0, 7, 192, 31, 240, 63, 248, 56, 56, 112, 28, 112,
  28, 112, 28, 112, 28, 0, 28, 0, 56, 3, 248, 3, 240, 3, 248, 0,
  60, 0, 30, 0, 14, 224, 14, 224, 14, 224, 14, 112, 28, 120, 60, 63,
  248, 31, 240, 7, 192, 16, 24, 48, 18, 0, 0, 0, 24, 0, 56, 0,
  120, 0, 120, 0, 248, 1, 248, 3, 184, 3, 184, 7, 56, 14, 56, 14,
  56, 28, 56, 56, 56, 56, 56, 112, 56, 224, 56, 255, 255, 255, 255, 255,
  255, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 15, 24, 48, 18, 1,
  0, 63, 252, 63, 252, 63, 252, 56, 0, 56, 0, 56, 0, 112, 0, 112,
  0, 119, 192, 127, 240, 127, 248, 120, 124, 112, 28, 0, 30, 0, 14, 0,
  14, 0, 14, 224, 14, 224, 30, 240, 28, 120, 124, 127, 248, 63, 240, 15,
  128, 15, 24, 48, 18, 1, 0, 3, 192, 15, 240, 31, 248, 60, 56, 56,
  28, 112, 28, 112, 0, 112, 0, 96, 0, 227, 192, 239, 240, 255, 248, 248,
  60, 240, 28, 240, 14, 224, 14, 224, 14, 96, 14, 112, 14, 112, 28, 56,
  60, 63, 248, 31, 240, 7, 192, 15, 24, 48, 18, 1, 0, 255, 254, 255,
  254, 255, 254, 0, 14, 0, 28, 0, 24, 0, 56, 0, 112, 0, 112, 0,
  224, 0, 224, 1, 192, 1, 192, 3, 128, 3, 128, 7, 0, 7, 0, 7,
  0, 14, 0, 14, 0, 14, 0, 28, 0, 28, 0, 28, 0, 15, 24, 48,
  18, 1, 0, 7, 192, 31, 240, 63, 248, 56, 60, 112, 28, 112, 28, 112,
  28, 112, 28, 120, 60, 60, 120, 31, 240, 15, 224, 63, 248, 120, 60, 112,
  28, 224, 14, 224, 14, 224, 14, 224, 14, 240, 28, 120, 60, 63, 248, 31,
  240, 7, 192, 15, 24, 48, 18, 1, 0, 7, 192, 31, 240, 63, 248, 120,
  124, 112, 60, 240, 28, 224, 30, 224, 14, 224, 14, 224, 14, 224, 30, 224,
  30, 112, 62, 127, 254, 63, 238, 15, 206, 0, 14, 0, 28, 224, 28, 240,
  60, 120, 120, 63, 240, 63, 224, 15, 128, 3, 18, 18, 9, 4, 0, 224,
  224, 224, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 224, 224,
  224, 3, 22, 22, 9, 4, 251, 224, 224, 224, 224, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 224, 224, 224, 224, 32, 96, 96, 192, 128, 16, 16, 32,
  19, 2, 0, 0, 3, 0, 15, 0, 63, 1, 252, 7, 224, 31, 128, 254,
  0, 240, 0, 240, 0, 254, 0, 31, 128, 7, 224, 1, 252, 0, 127, 0,
  15, 0, 3, 15, 9, 18, 19, 2, 4, 255, 254, 255, 254, 255, 254, 0,
  0, 0, 0, 0, 0, 255, 254, 255, 254, 255, 254, 16, 16, 32, 19, 1,
  0, 192, 0, 240, 0, 254, 0, 63, 128, 7, 224, 1, 248, 0, 127, 0,
  15, 0, 15, 0, 127, 1, 248, 7, 224, 63, 128, 254, 0, 240, 0, 192,
  0, 14, 25, 50, 18, 2, 0, 7, 192, 31, 240, 63, 248, 120, 56, 112,
  28, 240, 28, 224, 28, 224, 28, 0, 28, 0, 56, 0, 56, 0, 112, 0,
  224, 1, 224, 1, 192, 3, 128, 3, 128, 3, 128, 3, 128, 0, 0, 0,
  0, 3, 128, 3, 128, 3, 128, 3, 128, 29, 30, 120, 34, 1, 251, 0,
  7, 192, 0, 0, 63, 248, 0, 0, 255, 254, 0, 3, 240, 63, 128, 7,
  192, 7, 192, 15, 0, 3, 224, 30, 0, 1, 224, 28, 0, 0, 240, 56,
  15, 140, 112, 56, 31, 220, 56, 112, 60, 252, 56, 112, 112, 124, 56, 96,
  224, 56, 24, 224, 224, 56, 24, 225, 224, 56, 24, 225, 192, 112, 56, 225,
  192, 112, 56, 225, 192, 112, 112, 225, 192, 224, 112, 225, 224, 224, 224, 112,
  243, 243, 192, 112, 255, 127, 128, 120, 62, 127, 0, 60, 0, 0, 0, 30,
  0, 0, 0, 31, 0, 0, 0, 15, 128, 0, 0, 3, 224, 120, 0, 1,
  255, 248, 0, 0, 127, 224, 0, 20, 25, 75, 22, 1, 0, 0, 240, 0,
  0, 240, 0, 0, 248, 0, 1, 248, 0, 1, 248, 0, 3, 156, 0, 3,
  156, 0, 3, 156, 0, 7, 158, 0, 7, 14, 0, 7, 14, 0, 15, 15,
  0, 15, 15, 0, 14, 7, 0, 30, 7, 128, 31, 255, 128, 31, 255, 128,
  63, 255, 192, 60, 3, 192, 56, 1, 192, 120, 1, 224, 120, 1, 224, 112,
  0, 224, 240, 0, 240, 240, 0, 240, 17, 25, 75, 22, 3, 0, 255, 240,
  0, 255, 252, 0, 255, 254, 0, 224, 62, 0, 224, 15, 0, 224, 15, 0,
  224, 7, 0, 224, 7, 0, 224, 15, 0, 224, 14, 0, 224, 62, 0, 255,
  252, 0, 255, 252, 0, 255, 254, 0, 224, 31, 0, 224, 7, 128, 224, 3,
  128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 7, 128, 224, 15, 0,
  255, 254, 0, 255, 254, 0, 255, 248, 0, 20, 25, 75, 24, 2, 0, 1,
  252, 0, 7, 255, 0, 15, 255, 128, 31, 7, 192, 60, 1, 224, 56, 0,
  224, 112, 0, 240, 112, 0, 112, 224, 0, 0, 224, 0, 0, 224, 0, 0,
  224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224,
  0, 112, 240, 0, 112, 112, 0, 240, 120, 0, 224, 60, 1, 224, 63, 7,
  192, 31, 255, 128, 7, 254, 0, 1, 248, 0, 18, 25, 75, 24, 3, 0,
  255, 240, 0, 255, 252, 0, 255, 254, 0, 224, 31, 0, 224, 15, 0, 224,
  7, 128, 224, 3, 128, 224, 3, 128, 224, 1, 192, 224, 1, 192, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  224, 3, 192, 224, 3, 128, 224, 3, 128, 224, 7, 128, 224, 15, 0, 224,
  30, 0, 255, 254, 0, 255, 252, 0, 255, 240, 0, 17, 25, 75, 22, 3,
  0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 224, 0, 0, 224, 0, 0,
  224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224,
  0, 0, 255, 255, 0, 255, 255, 0, 255, 255, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0,
  224, 0, 0, 255, 255, 128, 255, 255, 128, 255, 255, 128, 16, 25, 50, 20,
  3, 0, 255, 255, 255, 255, 255, 255, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 255, 252, 255, 252, 255, 252, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 22, 25, 75, 25, 1, 0, 0, 254, 0, 3, 255, 128,
  15, 255, 192, 31, 131, 240, 62, 0, 240, 60, 0, 120, 120, 0, 56, 112,
  0, 56, 240, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 15,
  252, 224, 15, 252, 224, 15, 252, 224, 0, 28, 240, 0, 28, 112, 0, 28,
  120, 0, 60, 56, 0, 60, 60, 0, 252, 31, 1, 252, 15, 255, 220, 7,
  255, 28, 1, 252, 28, 18, 25, 75, 24, 3, 0, 224, 1, 192, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 255, 255, 192, 255,
  255, 192, 255, 255, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  224, 1, 192, 224, 1, 192, 3, 25, 25, 9, 3, 0, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 13, 25, 50, 16, 1, 0, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 224, 56, 224, 56, 224,
  56, 224, 56, 240, 120, 120, 240, 127, 240, 63, 224, 31, 128, 20, 25, 75,
  22, 3, 0, 224, 3, 192, 224, 7, 128, 224, 15, 0, 224, 30, 0, 224,
  60, 0, 224, 120, 0, 224, 240, 0, 225, 224, 0, 227, 192, 0, 231, 192,
  0, 239, 128, 0, 255, 192, 0, 255, 192, 0, 249, 224, 0, 240, 240, 0,
  224, 112, 0, 224, 120, 0, 224, 60, 0, 224, 28, 0, 224, 30, 0, 224,
  15, 0, 224, 7, 128, 224, 3, 192, 224, 3, 224, 224, 1, 240, 14, 25,
  50, 18, 3, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  255, 252, 255, 252, 255, 252, 21, 25, 75, 27, 3, 0, 240, 0, 120, 240,
  0, 120, 248, 0, 248, 248, 0, 248, 252, 1, 248, 252, 1, 248, 252, 1,
  248, 236, 1, 184, 238, 3, 184, 238, 3, 184, 230, 3, 56, 231, 7, 56,
  231, 7, 56, 227, 6, 56, 227, 142, 56, 227, 142, 56, 227, 142, 56, 225,
  140, 56, 225, 220, 56, 225, 220, 56, 224, 216, 56, 224, 248, 56, 224, 248,
  56, 224, 112, 56, 224, 112, 56, 19, 25, 75, 24, 2, 0, 240, 0, 224,
  240, 0, 224, 248, 0, 224, 252, 0, 224, 252, 0, 224, 254, 0, 224, 239,
  0, 224, 231, 0, 224, 231, 128, 224, 227, 192, 224, 227, 192, 224, 225, 224,
  224, 224, 224, 224, 224, 240, 224, 224, 120, 224, 224, 56, 224, 224, 60, 224,
  224, 28, 224, 224, 30, 224, 224, 15, 224, 224, 7, 224, 224, 7, 224, 224,
  3, 224, 224, 1, 224, 224, 1, 224, 23, 25, 75, 25, 1, 0, 0, 254,
  0, 3, 255, 128, 15, 239, 224, 31, 1, 240, 62, 0, 248, 60, 0, 120,
  120, 0, 60, 112, 0, 28, 240, 0, 30, 224, 0, 14, 224, 0, 14, 224,
  0, 14, 224, 0, 14, 224, 0, 14, 224, 0, 14, 224, 0, 14, 240, 0,
  30, 240, 0, 30, 120, 0, 60, 60, 0, 120, 62, 0, 248, 31, 1, 240,
  15, 239, 224, 3, 255, 128, 0, 254, 0, 17, 25, 75, 22, 3, 0, 255,
  248, 0, 255, 254, 0, 255, 255, 0, 224, 15, 0, 224, 7, 128, 224, 3,
  128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 7, 128,
  224, 15, 0, 255, 255, 0, 255, 254, 0, 255, 248, 0, 224, 0, 0, 224,
  0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 23, 26, 78, 26, 1, 255,
  0, 254, 0, 3, 255, 128, 15, 239, 224, 31, 1, 240, 62, 0, 248, 60,
  0, 120, 120, 0, 60, 112, 0, 28, 240, 0, 30, 224, 0, 14, 224, 0,
  14, 224, 0, 14, 224, 0, 14, 224, 0, 14, 224, 0, 14, 224, 0, 14,
  240, 0, 30, 240, 2, 30, 120, 7, 60, 60, 7, 184, 62, 3, 248, 31,
  1, 240, 15, 239, 248, 3, 255, 188, 0, 254, 30, 0, 0, 12, 19, 25,
  75, 24, 3, 0, 255, 252, 0, 255, 255, 0, 255, 255, 128, 224, 7, 128,
  224, 3, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224,
  3, 192, 224, 3, 128, 224, 15, 128, 255, 255, 0, 255, 254, 0, 255, 255,
  0, 224, 15, 128, 224, 7, 128, 224, 3, 128, 224, 3, 192, 224, 3, 192,
  224, 3, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 224, 19,
  25, 75, 22, 1, 0, 3, 248, 0, 15, 254, 0, 31, 255, 0, 60, 15,
  128, 56, 3, 192, 112, 1, 192, 112, 1, 192, 112, 0, 0, 120, 0, 0,
  124, 0, 0, 63, 192, 0, 31, 248, 0, 7, 255, 0, 0, 127, 128, 0,
  15, 192, 0, 1, 224, 0, 0, 224, 224, 0, 224, 240, 0, 224, 112, 1,
  224, 120, 1, 192, 62, 7, 192, 63, 255, 128, 15, 254, 0, 3, 248, 0,
  19, 25, 75, 20, 0, 0, 255, 255, 224, 255, 255, 224, 255, 255, 224, 0,
  224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224,
  0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0,
  224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224,
  0, 18, 25, 75, 24, 3, 0, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224,
  1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 224, 1, 192,
  240, 3, 192, 120, 7, 128, 124, 15, 128, 63, 255, 0, 31, 254, 0, 3,
  240, 0, 19, 25, 75, 22, 1, 0, 240, 1, 224, 240, 1, 224, 240, 1,
  224, 112, 1, 192, 120, 3, 192, 120, 3, 192, 56, 3, 128, 56, 3, 128,
  60, 7, 128, 28, 7, 0, 28, 7, 0, 30, 15, 0, 14, 14, 0, 14,
  14, 0, 15, 14, 0, 7, 28, 0, 7, 28, 0, 7, 156, 0, 3, 184,
  0, 3, 184, 0, 3, 184, 0, 1, 240, 0, 1, 240, 0, 0, 224, 0,
  0, 224, 0, 29, 25, 100, 31, 1, 0, 240, 7, 0, 120, 240, 7, 0,
  120, 240, 15, 128, 120, 112, 15, 128, 112, 112, 15, 128, 112, 120, 29, 192,
  240, 120, 29, 192, 240, 56, 29, 192, 224, 56, 29, 192, 224, 56, 56, 224,
  224, 60, 56, 225, 224, 28, 56, 225, 192, 28, 48, 225, 192, 28, 112, 113,
  192, 28, 112, 113, 192, 14, 112, 115, 128, 14, 224, 59, 128, 14, 224, 59,
  128, 14, 224, 59, 128, 7, 224, 63, 128, 7, 192, 31, 0, 7, 192, 31,
  0, 7, 192, 31, 0, 3, 128, 14, 0, 3, 128, 14, 0, 20, 25, 75,
  22, 1, 0, 248, 0, 240, 120, 1, 224, 60, 3, 192, 28, 3, 192, 30,
  7, 128, 15, 7, 0, 15, 15, 0, 7, 158, 0, 3, 156, 0, 3, 252,
  0, 1, 248, 0, 0, 240, 0, 0, 240, 0, 1, 248, 0, 1, 248, 0,
  3, 156, 0, 7, 158, 0, 7, 14, 0, 15, 15, 0, 30, 7, 128, 30,
  7, 128, 60, 3, 192, 120, 1, 224, 120, 1, 224, 240, 0, 240, 21, 25,
  75, 22, 0, 0, 240, 0, 120, 120, 0, 240, 120, 0, 224, 60, 1, 224,
  28, 1, 192, 30, 3, 192, 14, 7, 128, 15, 7, 128, 7, 143, 0, 3,
  142, 0, 3, 222, 0, 1, 220, 0, 1, 252, 0, 0, 248, 0, 0, 248,
  0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0,
  0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 18,
  25, 75, 20, 1, 0, 127, 255, 192, 127, 255, 192, 127, 255, 192, 0, 7,
  128, 0, 15, 128, 0, 15, 0, 0, 30, 0, 0, 60, 0, 0, 60, 0,
  0, 120, 0, 0, 240, 0, 1, 224, 0, 1, 224, 0, 3, 192, 0, 7,
  128, 0, 7, 128, 0, 15, 0, 0, 30, 0, 0, 60, 0, 0, 60, 0,
  0, 120, 0, 0, 240, 0, 0, 255, 255, 192, 255, 255, 192, 255, 255, 192,
  6, 32, 32, 9, 2, 249, 252, 252, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 252, 252, 9, 24, 48, 9, 0, 0, 192, 0, 192, 0,
  96, 0, 96, 0, 96, 0, 48, 0, 48, 0, 48, 0, 16, 0, 24, 0,
  24, 0, 24, 0, 12, 0, 12, 0, 12, 0, 6, 0, 6, 0, 6, 0,
  2, 0, 3, 0, 3, 0, 3, 0, 1, 128, 1, 128, 6, 32, 32, 9,
  1, 249, 252, 252, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  252, 252, 12, 13, 26, 16, 1, 11, 6, 0, 15, 0, 15, 0, 31, 128,
  25, 128, 25, 128, 57, 192, 48, 192, 112, 224, 96, 96, 96, 96, 224, 112,
  192, 48, 18, 2, 6, 18, 0, 250, 255, 255, 192, 255, 255, 192, 6, 5,
  5, 11, 1, 20, 224, 240, 112, 56, 28, 16, 18, 36, 18, 1, 0, 15,
  224, 63, 248, 60, 120, 112, 60, 112, 28, 0, 28, 0, 60, 1, 252, 31,
  252, 126, 28, 120, 28, 240, 28, 224, 28, 224, 60, 224, 124, 121, 254, 127,
  223, 63, 143, 15, 25, 50, 18, 2, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 227, 224, 239, 240, 255, 248, 248, 60, 240,
  28, 240, 30, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 240,
  30, 240, 28, 252, 60, 255, 248, 239, 240, 231, 224, 14, 18, 36, 16, 1,
  0, 7, 192, 31, 240, 63, 248, 56, 60, 112, 28, 112, 28, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 28, 224, 28, 112, 28, 120, 56, 63,
  248, 31, 240, 7, 192, 15, 25, 50, 18, 1, 0, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 7, 206, 31, 238, 63, 254, 124,
  62, 112, 30, 240, 30, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224,
  14, 240, 30, 240, 30, 120, 62, 127, 254, 63, 238, 15, 206, 15, 18, 36,
  18, 2, 0, 7, 192, 31, 240, 63, 248, 120, 60, 112, 28, 240, 14, 224,
  14, 224, 14, 255, 254, 255, 254, 224, 0, 224, 0, 240, 14, 112, 30, 120,
  60, 63, 248, 31, 240, 7, 192, 8, 25, 25, 9, 1, 0, 15, 31, 60,
  56, 56, 56, 56, 255, 255, 255, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 15, 25, 50, 18, 1, 249, 7, 206, 31, 238,
  63, 254, 124, 62, 112, 30, 240, 30, 224, 14, 224, 14, 224, 14, 224, 14,
  224, 14, 224, 14, 240, 30, 112, 62, 120, 62, 63, 254, 31, 238, 7, 142,
  0, 14, 224, 14, 224, 28, 240, 28, 124, 120, 63, 248, 31, 224, 14, 25,
  50, 18, 2, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 227, 224, 239, 240, 255, 248, 248, 60, 240, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 3, 25, 25, 7, 2, 0, 224, 224, 224, 224,
  0, 0, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 6, 32, 32, 7, 255, 249, 28, 28, 28, 28, 0,
  0, 0, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 60, 252, 248, 15, 25, 50, 16, 1,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  120, 224, 240, 225, 224, 227, 192, 231, 128, 239, 0, 255, 0, 255, 0, 251,
  128, 243, 192, 225, 192, 225, 224, 224, 224, 224, 240, 224, 120, 224, 56, 224,
  60, 224, 30, 3, 25, 25, 7, 2, 0, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 23, 18, 54, 27, 2, 0, 227, 192, 240, 239, 243, 252, 255, 247,
  252, 248, 126, 30, 240, 60, 14, 224, 56, 14, 224, 56, 14, 224, 56, 14,
  224, 56, 14, 224, 56, 14, 224, 56, 14, 224, 56, 14, 224, 56, 14, 224,
  56, 14, 224, 56, 14, 224, 56, 14, 224, 56, 14, 224, 56, 14, 14, 18,
  36, 18, 2, 0, 227, 224, 239, 248, 255, 248, 248, 60, 240, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 15, 18, 36, 18, 1, 0, 7, 192,
  31, 240, 63, 248, 120, 60, 112, 28, 240, 30, 224, 14, 224, 14, 224, 14,
  224, 14, 224, 14, 224, 14, 240, 30, 112, 28, 120, 60, 63, 248, 31, 240,
  7, 192, 15, 25, 50, 18, 2, 249, 3, 192, 239, 240, 255, 248, 248, 60,
  240, 28, 240, 30, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14,
  240, 30, 240, 28, 248, 60, 255, 248, 239, 240, 231, 224, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 15, 25, 50, 18, 1, 249,
  7, 192, 31, 238, 63, 254, 124, 62, 112, 30, 240, 30, 224, 14, 224, 14,
  224, 14, 224, 14, 224, 14, 224, 14, 240, 30, 112, 30, 120, 62, 63, 254,
  31, 238, 15, 206, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 8, 18, 18, 11, 2, 0, 231, 239, 255, 252, 240, 240, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 13, 18, 36, 16, 2, 0,
  15, 128, 63, 224, 127, 224, 112, 240, 224, 112, 224, 0, 112, 0, 126, 0,
  63, 192, 7, 240, 0, 240, 0, 120, 224, 56, 224, 56, 240, 112, 127, 240,
  127, 224, 31, 128, 8, 22, 22, 9, 1, 0, 56, 56, 56, 56, 255, 255,
  255, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 60, 63, 31,
  14, 18, 36, 18, 2, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 60, 240, 124, 127, 252, 127, 220, 31, 28, 15, 18, 36, 16, 0, 0,
  224, 14, 224, 14, 112, 28, 112, 28, 112, 28, 56, 56, 56, 56, 56, 56,
  28, 112, 28, 112, 28, 112, 14, 224, 14, 224, 14, 224, 7, 192, 7, 192,
  3, 128, 3, 128, 23, 18, 54, 23, 0, 0, 224, 56, 14, 224, 56, 14,
  112, 124, 28, 112, 124, 28, 112, 108, 28, 56, 238, 28, 56, 238, 56, 56,
  238, 56, 56, 198, 56, 24, 198, 48, 29, 199, 112, 29, 199, 112, 29, 199,
  112, 13, 131, 96, 15, 131, 224, 15, 131, 224, 7, 1, 192, 7, 1, 192,
  15, 18, 36, 16, 0, 0, 240, 30, 120, 28, 56, 56, 60, 112, 28, 112,
  14, 224, 15, 224, 7, 192, 3, 128, 7, 192, 7, 192, 15, 224, 30, 224,
  28, 112, 56, 120, 56, 56, 112, 28, 240, 30, 14, 25, 50, 16, 1, 249,
  224, 28, 224, 28, 240, 56, 112, 56, 112, 56, 112, 112, 56, 112, 56, 112,
  56, 224, 60, 224, 28, 224, 29, 192, 29, 192, 15, 192, 15, 128, 15, 128,
  7, 0, 7, 0, 7, 0, 14, 0, 14, 0, 28, 0, 124, 0, 120, 0,
  112, 0, 14, 18, 36, 16, 1, 0, 127, 248, 127, 248, 127, 248, 0, 120,
  0, 240, 0, 224, 1, 192, 3, 192, 7, 128, 7, 0, 14, 0, 28, 0,
  60, 0, 120, 0, 112, 0, 255, 252, 255, 252, 255, 252, 8, 32, 32, 11,
  1, 249, 15, 31, 28, 24, 24, 24, 24, 24, 24, 24, 24, 24, 56, 56,
  112, 224, 224, 112, 56, 56, 24, 24, 24, 24, 24, 24, 24, 24, 24, 28,
  31, 15, 2, 31, 31, 9, 3, 249, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 8, 32, 32, 11, 1, 249, 240, 248, 56,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 28, 28, 14, 7, 7, 14, 28,
  28, 24, 24, 24, 24, 24, 24, 24, 24, 24, 56, 248, 240, 14, 6, 12,
  19, 2, 9, 24, 0, 124, 12, 127, 12, 199, 220, 193, 248, 0, 240, 255
};
