/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

/**
 * u8g_font_data_profont.c
 */

#include "u8g.h"

/*
  Fontname: ProFont10
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 6, '1' Height: 6
  Calculated Max Values w= 5 h= 9 x= 2 y= 5 dx= 5 dy= 0 ascent= 8 len= 9
  Font Bounding box     w= 5 h= 9 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 6 descent=-2
  X Font      ascent = 7 descent=-2
  Max Font    ascent = 8 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_profont10[2560] U8G_FONT_SECTION("u8g_font_profont10") = {
  0, 5, 9, 0, 254, 6, 1, 126, 2, 248, 32, 255, 254, 8, 254, 7,
  254, 0, 0, 0, 5, 0, 0, 1, 6, 6, 5, 2, 0, 128, 128, 128,
  128, 0, 128, 3, 2, 2, 5, 1, 5, 160, 160, 5, 5, 5, 5, 0,
  1, 80, 248, 80, 248, 80, 5, 8, 8, 5, 0, 255, 32, 120, 160, 112,
  40, 168, 112, 32, 5, 6, 6, 5, 0, 0, 120, 168, 176, 104, 168, 144,
  4, 6, 6, 5, 0, 0, 64, 160, 64, 80, 160, 80, 1, 2, 2, 5,
  2, 4, 128, 128, 3, 8, 8, 5, 1, 255, 32, 64, 128, 128, 128, 128,
  64, 32, 3, 8, 8, 5, 0, 255, 128, 64, 32, 32, 32, 32, 64, 128,
  4, 5, 5, 5, 0, 1, 64, 144, 96, 144, 32, 3, 3, 3, 5, 0,
  1, 64, 224, 64, 2, 3, 3, 5, 0, 254, 64, 64, 128, 2, 1, 1,
  5, 1, 2, 192, 1, 1, 1, 5, 2, 0, 128, 4, 8, 8, 5, 0,
  254, 16, 16, 32, 32, 64, 64, 128, 128, 4, 6, 6, 5, 0, 0, 96,
  144, 176, 208, 144, 96, 3, 6, 6, 5, 1, 0, 64, 192, 64, 64, 64,
  224, 4, 6, 6, 5, 0, 0, 96, 144, 16, 32, 64, 240, 4, 6, 6,
  5, 0, 0, 96, 144, 32, 16, 144, 96, 4, 6, 6, 5, 0, 0, 32,
  96, 160, 240, 32, 112, 4, 6, 6, 5, 0, 0, 240, 128, 224, 16, 144,
  96, 4, 6, 6, 5, 0, 0, 96, 128, 224, 144, 144, 96, 4, 6, 6,
  5, 0, 0, 240, 16, 32, 64, 64, 64, 4, 6, 6, 5, 0, 0, 96,
  144, 96, 144, 144, 96, 4, 6, 6, 5, 0, 0, 96, 144, 144, 112, 16,
  96, 1, 4, 4, 5, 2, 0, 128, 0, 0, 128, 2, 6, 6, 5, 0,
  254, 64, 0, 0, 64, 64, 128, 3, 5, 5, 5, 1, 0, 32, 64, 128,
  64, 32, 4, 3, 3, 5, 0, 1, 240, 0, 240, 3, 5, 5, 5, 1,
  0, 128, 64, 32, 64, 128, 4, 6, 6, 5, 0, 0, 96, 144, 32, 64,
  0, 64, 4, 6, 6, 5, 0, 0, 96, 144, 176, 176, 128, 112, 4, 6,
  6, 5, 0, 0, 96, 144, 144, 240, 144, 144, 4, 6, 6, 5, 0, 0,
  224, 144, 224, 144, 144, 224, 4, 6, 6, 5, 0, 0, 96, 144, 128, 128,
  144, 96, 4, 6, 6, 5, 0, 0, 224, 144, 144, 144, 144, 224, 4, 6,
  6, 5, 0, 0, 240, 128, 224, 128, 128, 240, 4, 6, 6, 5, 0, 0,
  240, 128, 224, 128, 128, 128, 4, 6, 6, 5, 0, 0, 96, 144, 128, 176,
  144, 96, 4, 6, 6, 5, 0, 0, 144, 144, 240, 144, 144, 144, 3, 6,
  6, 5, 1, 0, 224, 64, 64, 64, 64, 224, 4, 6, 6, 5, 0, 0,
  16, 16, 16, 16, 144, 96, 4, 6, 6, 5, 0, 0, 144, 160, 192, 192,
  160, 144, 4, 6, 6, 5, 0, 0, 128, 128, 128, 128, 128, 240, 4, 6,
  6, 5, 0, 0, 144, 240, 240, 144, 144, 144, 4, 6, 6, 5, 0, 0,
  144, 208, 176, 144, 144, 144, 4, 6, 6, 5, 0, 0, 96, 144, 144, 144,
  144, 96, 4, 6, 6, 5, 0, 0, 224, 144, 144, 224, 128, 128, 4, 7,
  7, 5, 0, 255, 96, 144, 144, 144, 176, 96, 16, 4, 6, 6, 5, 0,
  0, 224, 144, 144, 224, 144, 144, 4, 6, 6, 5, 0, 0, 96, 144, 96,
  16, 144, 96, 3, 6, 6, 5, 1, 0, 224, 64, 64, 64, 64, 64, 4,
  6, 6, 5, 0, 0, 144, 144, 144, 144, 144, 96, 4, 6, 6, 5, 0,
  0, 144, 144, 144, 144, 160, 64, 4, 6, 6, 5, 0, 0, 144, 144, 144,
  240, 240, 144, 4, 6, 6, 5, 0, 0, 144, 144, 96, 96, 144, 144, 4,
  6, 6, 5, 0, 0, 144, 144, 160, 64, 64, 64, 4, 6, 6, 5, 0,
  0, 240, 16, 32, 64, 128, 240, 2, 8, 8, 5, 2, 255, 192, 128, 128,
  128, 128, 128, 128, 192, 4, 8, 8, 5, 1, 254, 128, 128, 64, 64, 32,
  32, 16, 16, 2, 8, 8, 5, 1, 255, 192, 64, 64, 64, 64, 64, 64,
  192, 3, 2, 2, 5, 1, 4, 64, 160, 5, 1, 1, 5, 0, 254, 248,
  2, 2, 2, 5, 1, 5, 128, 64, 4, 4, 4, 5, 0, 0, 112, 144,
  176, 80, 4, 6, 6, 5, 0, 0, 128, 128, 224, 144, 144, 224, 4, 4,
  4, 5, 0, 0, 96, 144, 128, 112, 4, 6, 6, 5, 0, 0, 16, 16,
  112, 144, 144, 112, 4, 4, 4, 5, 0, 0, 96, 240, 128, 112, 3, 6,
  6, 5, 1, 0, 32, 64, 224, 64, 64, 64, 4, 6, 6, 5, 0, 254,
  112, 144, 144, 112, 16, 96, 4, 6, 6, 5, 0, 0, 128, 128, 224, 144,
  144, 144, 3, 6, 6, 5, 1, 0, 64, 0, 192, 64, 64, 224, 2, 8,
  8, 5, 1, 254, 64, 0, 192, 64, 64, 64, 64, 128, 4, 6, 6, 5,
  0, 0, 128, 128, 160, 192, 160, 144, 3, 6, 6, 5, 1, 0, 192, 64,
  64, 64, 64, 224, 5, 4, 4, 5, 0, 0, 240, 168, 168, 168, 4, 4,
  4, 5, 0, 0, 160, 208, 144, 144, 4, 4, 4, 5, 0, 0, 96, 144,
  144, 96, 4, 6, 6, 5, 0, 254, 224, 144, 144, 224, 128, 128, 4, 6,
  6, 5, 0, 254, 112, 144, 144, 112, 16, 16, 4, 4, 4, 5, 0, 0,
  160, 208, 128, 128, 4, 4, 4, 5, 0, 0, 112, 224, 16, 224, 3, 6,
  6, 5, 1, 0, 64, 64, 224, 64, 64, 32, 4, 4, 4, 5, 0, 0,
  144, 144, 176, 80, 4, 4, 4, 5, 0, 0, 144, 144, 160, 64, 5, 4,
  4, 5, 0, 0, 168, 168, 168, 80, 4, 4, 4, 5, 0, 0, 144, 96,
  96, 144, 4, 6, 6, 5, 0, 254, 144, 144, 144, 112, 16, 96, 4, 4,
  4, 5, 0, 0, 240, 32, 64, 240, 3, 9, 9, 5, 1, 254, 32, 64,
  64, 64, 128, 64, 64, 64, 32, 1, 8, 8, 5, 2, 255, 128, 128, 128,
  128, 128, 128, 128, 128, 3, 9, 9, 5, 1, 254, 128, 64, 64, 64, 32,
  64, 64, 64, 128, 4, 2, 2, 5, 0, 2, 80, 160, 0, 0, 0, 5,
  0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 5, 0, 0, 2, 3,
  3, 5, 0, 255, 64, 64, 128, 3, 9, 9, 5, 1, 254, 32, 64, 64,
  224, 64, 64, 64, 64, 128, 4, 3, 3, 5, 0, 255, 80, 80, 160, 5,
  1, 1, 5, 0, 0, 168, 3, 5, 5, 5, 1, 1, 64, 224, 64, 64,
  64, 3, 5, 5, 5, 1, 1, 64, 224, 64, 224, 64, 3, 2, 2, 5,
  1, 5, 64, 160, 5, 6, 6, 5, 0, 0, 120, 208, 224, 112, 248, 112,
  4, 8, 8, 5, 0, 0, 80, 32, 112, 128, 96, 16, 144, 96, 2, 3,
  3, 5, 0, 0, 64, 128, 64, 4, 6, 6, 5, 0, 0, 112, 160, 176,
  160, 160, 112, 0, 0, 0, 5, 0, 0, 0, 0, 0, 5, 0, 0, 0,
  0, 0, 5, 0, 0, 0, 0, 0, 5, 0, 0, 2, 3, 3, 5, 2,
  3, 64, 128, 128, 2, 3, 3, 5, 1, 3, 64, 64, 128, 4, 3, 3,
  5, 0, 3, 80, 160, 160, 4, 3, 3, 5, 0, 3, 80, 80, 160, 4,
  4, 4, 5, 0, 1, 96, 240, 240, 96, 2, 1, 1, 5, 1, 2, 192,
  5, 1, 1, 5, 0, 2, 248, 4, 2, 2, 5, 0, 5, 80, 160, 5,
  3, 3, 5, 0, 3, 248, 88, 88, 4, 7, 7, 5, 0, 0, 80, 32,
  0, 112, 224, 16, 224, 2, 3, 3, 5, 0, 0, 128, 64, 128, 4, 4,
  4, 5, 0, 0, 112, 176, 160, 80, 0, 0, 0, 5, 0, 0, 0, 0,
  0, 5, 0, 0, 4, 8, 8, 5, 0, 0, 80, 0, 144, 144, 160, 64,
  64, 64, 0, 0, 0, 5, 0, 0, 1, 6, 6, 5, 2, 0, 128, 0,
  128, 128, 128, 128, 4, 6, 6, 5, 0, 255, 32, 96, 176, 192, 112, 64,
  4, 6, 6, 5, 0, 0, 96, 128, 192, 128, 144, 224, 4, 4, 4, 5,
  0, 0, 144, 96, 96, 144, 3, 6, 6, 5, 1, 0, 160, 64, 224, 64,
  224, 64, 1, 8, 8, 5, 2, 255, 128, 128, 128, 0, 0, 128, 128, 128,
  4, 8, 8, 5, 0, 255, 96, 144, 64, 160, 80, 32, 144, 96, 2, 1,
  1, 5, 1, 5, 192, 4, 6, 6, 5, 0, 0, 192, 32, 208, 208, 32,
  192, 3, 5, 5, 5, 1, 2, 96, 160, 96, 0, 224, 5, 3, 3, 5,
  0, 0, 72, 144, 72, 4, 2, 2, 5, 0, 1, 240, 16, 3, 1, 1,
  5, 0, 2, 224, 4, 5, 5, 5, 0, 1, 192, 32, 208, 208, 176, 2,
  1, 1, 5, 1, 5, 192, 3, 3, 3, 5, 1, 3, 64, 160, 64, 3,
  4, 4, 5, 0, 0, 64, 224, 64, 224, 2, 3, 3, 5, 1, 4, 128,
  64, 192, 2, 3, 3, 5, 1, 4, 192, 64, 192, 2, 1, 1, 5, 2,
  5, 192, 4, 5, 5, 5, 0, 255, 160, 160, 160, 208, 128, 4, 6, 6,
  5, 0, 0, 112, 176, 176, 112, 48, 48, 1, 1, 1, 5, 2, 2, 128,
  2, 2, 2, 5, 1, 254, 192, 192, 2, 3, 3, 5, 1, 4, 192, 64,
  64, 3, 5, 5, 5, 1, 2, 64, 160, 64, 0, 224, 5, 3, 3, 5,
  0, 0, 144, 72, 144, 5, 7, 7, 5, 0, 0, 192, 72, 80, 32, 72,
  152, 8, 5, 7, 7, 5, 0, 0, 192, 72, 80, 32, 80, 136, 24, 5,
  7, 7, 5, 0, 0, 192, 72, 208, 32, 72, 152, 8, 4, 6, 6, 5,
  0, 0, 32, 0, 32, 64, 144, 96, 4, 8, 8, 5, 0, 0, 64, 32,
  96, 144, 144, 240, 144, 144, 4, 8, 8, 5, 0, 0, 32, 64, 96, 144,
  144, 240, 144, 144, 4, 8, 8, 5, 0, 0, 32, 80, 0, 96, 144, 240,
  144, 144, 4, 8, 8, 5, 0, 0, 80, 160, 0, 96, 144, 240, 144, 144,
  4, 8, 8, 5, 0, 0, 80, 0, 96, 144, 144, 240, 144, 144, 4, 8,
  8, 5, 0, 0, 32, 80, 32, 96, 144, 240, 144, 144, 4, 6, 6, 5,
  0, 0, 112, 160, 240, 160, 160, 176, 4, 8, 8, 5, 0, 254, 96, 144,
  128, 128, 144, 96, 32, 64, 4, 8, 8, 5, 0, 0, 64, 32, 240, 128,
  224, 128, 128, 240, 4, 8, 8, 5, 0, 0, 32, 64, 240, 128, 224, 128,
  128, 240, 4, 8, 8, 5, 0, 0, 32, 80, 240, 128, 224, 128, 128, 240,
  4, 8, 8, 5, 0, 0, 80, 0, 240, 128, 224, 128, 128, 240, 3, 8,
  8, 5, 1, 0, 128, 64, 224, 64, 64, 64, 64, 224, 3, 8, 8, 5,
  1, 0, 32, 64, 224, 64, 64, 64, 64, 224, 3, 8, 8, 5, 1, 0,
  64, 160, 0, 224, 64, 64, 64, 224, 3, 8, 8, 5, 1, 0, 160, 0,
  224, 64, 64, 64, 64, 224, 4, 6, 6, 5, 0, 0, 96, 80, 208, 80,
  80, 96, 4, 8, 8, 5, 0, 0, 80, 160, 144, 208, 176, 144, 144, 144,
  4, 8, 8, 5, 0, 0, 64, 32, 96, 144, 144, 144, 144, 96, 4, 8,
  8, 5, 0, 0, 32, 64, 96, 144, 144, 144, 144, 96, 4, 8, 8, 5,
  0, 0, 32, 80, 0, 96, 144, 144, 144, 96, 4, 8, 8, 5, 0, 0,
  80, 160, 0, 96, 144, 144, 144, 96, 4, 8, 8, 5, 0, 0, 80, 0,
  96, 144, 144, 144, 144, 96, 3, 3, 3, 5, 0, 1, 160, 64, 160, 4,
  6, 6, 5, 0, 0, 96, 144, 176, 208, 144, 96, 4, 8, 8, 5, 0,
  0, 64, 32, 144, 144, 144, 144, 144, 96, 4, 8, 8, 5, 0, 0, 32,
  64, 144, 144, 144, 144, 144, 96, 4, 8, 8, 5, 0, 0, 32, 80, 0,
  144, 144, 144, 144, 96, 4, 8, 8, 5, 0, 0, 80, 0, 144, 144, 144,
  144, 144, 96, 4, 8, 8, 5, 0, 0, 32, 64, 0, 144, 144, 160, 64,
  64, 4, 6, 6, 5, 0, 0, 128, 224, 144, 224, 128, 128, 4, 7, 7,
  5, 0, 255, 96, 144, 160, 160, 144, 160, 128, 4, 7, 7, 5, 0, 0,
  64, 32, 0, 112, 144, 176, 80, 4, 7, 7, 5, 0, 0, 32, 64, 0,
  112, 144, 176, 80, 4, 7, 7, 5, 0, 0, 32, 80, 0, 112, 144, 176,
  80, 4, 7, 7, 5, 0, 0, 80, 160, 0, 112, 144, 176, 80, 4, 6,
  6, 5, 0, 0, 80, 0, 112, 144, 176, 80, 4, 7, 7, 5, 0, 0,
  32, 80, 32, 112, 144, 176, 80, 4, 4, 4, 5, 0, 0, 112, 176, 160,
  112, 4, 6, 6, 5, 0, 254, 96, 144, 128, 112, 32, 64, 4, 7, 7,
  5, 0, 0, 64, 32, 0, 96, 240, 128, 112, 4, 7, 7, 5, 0, 0,
  32, 64, 0, 96, 240, 128, 112, 4, 7, 7, 5, 0, 0, 32, 80, 0,
  96, 240, 128, 112, 4, 6, 6, 5, 0, 0, 80, 0, 96, 240, 128, 112,
  3, 7, 7, 5, 1, 0, 128, 64, 0, 192, 64, 64, 224, 3, 7, 7,
  5, 1, 0, 64, 128, 0, 192, 64, 64, 224, 3, 7, 7, 5, 1, 0,
  64, 160, 0, 192, 64, 64, 224, 3, 6, 6, 5, 1, 0, 160, 0, 192,
  64, 64, 224, 4, 7, 7, 5, 0, 0, 192, 192, 32, 112, 144, 144, 96,
  4, 7, 7, 5, 0, 0, 80, 160, 0, 160, 208, 144, 144, 4, 7, 7,
  5, 0, 0, 64, 32, 0, 96, 144, 144, 96, 4, 7, 7, 5, 0, 0,
  32, 64, 0, 96, 144, 144, 96, 4, 7, 7, 5, 0, 0, 32, 80, 0,
  96, 144, 144, 96, 4, 7, 7, 5, 0, 0, 80, 160, 0, 96, 144, 144,
  96, 4, 6, 6, 5, 0, 0, 80, 0, 96, 144, 144, 96, 3, 5, 5,
  5, 0, 0, 64, 0, 224, 0, 64, 4, 4, 4, 5, 0, 0, 96, 176,
  208, 96, 4, 7, 7, 5, 0, 0, 64, 32, 0, 144, 144, 176, 80, 4,
  7, 7, 5, 0, 0, 32, 64, 0, 144, 144, 176, 80, 4, 7, 7, 5,
  0, 0, 32, 80, 0, 144, 144, 176, 80, 4, 6, 6, 5, 0, 0, 80,
  0, 144, 144, 176, 80, 4, 9, 9, 5, 0, 254, 16, 32, 0, 144, 144,
  144, 112, 16, 96, 4, 8, 8, 5, 0, 254, 128, 128, 224, 144, 144, 224,
  128, 128, 4, 8, 8, 5, 0, 254, 80, 0, 144, 144, 144, 112, 16, 96
};

/*
  Fontname: ProFont10
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 6, '1' Height: 6
  Calculated Max Values w= 5 h= 9 x= 2 y= 5 dx= 5 dy= 0 ascent= 7 len= 9
  Font Bounding box     w= 5 h= 9 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 6 descent=-2
  X Font      ascent = 7 descent=-2
  Max Font    ascent = 7 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_profont10r[1106] U8G_FONT_SECTION("u8g_font_profont10r") = {
  0, 5, 9, 0, 254, 6, 1, 126, 2, 248, 32, 127, 254, 7, 254, 7,
  254, 0, 0, 0, 5, 0, 0, 1, 6, 6, 5, 2, 0, 128, 128, 128,
  128, 0, 128, 3, 2, 2, 5, 1, 5, 160, 160, 5, 5, 5, 5, 0,
  1, 80, 248, 80, 248, 80, 5, 8, 8, 5, 0, 255, 32, 120, 160, 112,
  40, 168, 112, 32, 5, 6, 6, 5, 0, 0, 120, 168, 176, 104, 168, 144,
  4, 6, 6, 5, 0, 0, 64, 160, 64, 80, 160, 80, 1, 2, 2, 5,
  2, 4, 128, 128, 3, 8, 8, 5, 1, 255, 32, 64, 128, 128, 128, 128,
  64, 32, 3, 8, 8, 5, 0, 255, 128, 64, 32, 32, 32, 32, 64, 128,
  4, 5, 5, 5, 0, 1, 64, 144, 96, 144, 32, 3, 3, 3, 5, 0,
  1, 64, 224, 64, 2, 3, 3, 5, 0, 254, 64, 64, 128, 2, 1, 1,
  5, 1, 2, 192, 1, 1, 1, 5, 2, 0, 128, 4, 8, 8, 5, 0,
  254, 16, 16, 32, 32, 64, 64, 128, 128, 4, 6, 6, 5, 0, 0, 96,
  144, 176, 208, 144, 96, 3, 6, 6, 5, 1, 0, 64, 192, 64, 64, 64,
  224, 4, 6, 6, 5, 0, 0, 96, 144, 16, 32, 64, 240, 4, 6, 6,
  5, 0, 0, 96, 144, 32, 16, 144, 96, 4, 6, 6, 5, 0, 0, 32,
  96, 160, 240, 32, 112, 4, 6, 6, 5, 0, 0, 240, 128, 224, 16, 144,
  96, 4, 6, 6, 5, 0, 0, 96, 128, 224, 144, 144, 96, 4, 6, 6,
  5, 0, 0, 240, 16, 32, 64, 64, 64, 4, 6, 6, 5, 0, 0, 96,
  144, 96, 144, 144, 96, 4, 6, 6, 5, 0, 0, 96, 144, 144, 112, 16,
  96, 1, 4, 4, 5, 2, 0, 128, 0, 0, 128, 2, 6, 6, 5, 0,
  254, 64, 0, 0, 64, 64, 128, 3, 5, 5, 5, 1, 0, 32, 64, 128,
  64, 32, 4, 3, 3, 5, 0, 1, 240, 0, 240, 3, 5, 5, 5, 1,
  0, 128, 64, 32, 64, 128, 4, 6, 6, 5, 0, 0, 96, 144, 32, 64,
  0, 64, 4, 6, 6, 5, 0, 0, 96, 144, 176, 176, 128, 112, 4, 6,
  6, 5, 0, 0, 96, 144, 144, 240, 144, 144, 4, 6, 6, 5, 0, 0,
  224, 144, 224, 144, 144, 224, 4, 6, 6, 5, 0, 0, 96, 144, 128, 128,
  144, 96, 4, 6, 6, 5, 0, 0, 224, 144, 144, 144, 144, 224, 4, 6,
  6, 5, 0, 0, 240, 128, 224, 128, 128, 240, 4, 6, 6, 5, 0, 0,
  240, 128, 224, 128, 128, 128, 4, 6, 6, 5, 0, 0, 96, 144, 128, 176,
  144, 96, 4, 6, 6, 5, 0, 0, 144, 144, 240, 144, 144, 144, 3, 6,
  6, 5, 1, 0, 224, 64, 64, 64, 64, 224, 4, 6, 6, 5, 0, 0,
  16, 16, 16, 16, 144, 96, 4, 6, 6, 5, 0, 0, 144, 160, 192, 192,
  160, 144, 4, 6, 6, 5, 0, 0, 128, 128, 128, 128, 128, 240, 4, 6,
  6, 5, 0, 0, 144, 240, 240, 144, 144, 144, 4, 6, 6, 5, 0, 0,
  144, 208, 176, 144, 144, 144, 4, 6, 6, 5, 0, 0, 96, 144, 144, 144,
  144, 96, 4, 6, 6, 5, 0, 0, 224, 144, 144, 224, 128, 128, 4, 7,
  7, 5, 0, 255, 96, 144, 144, 144, 176, 96, 16, 4, 6, 6, 5, 0,
  0, 224, 144, 144, 224, 144, 144, 4, 6, 6, 5, 0, 0, 96, 144, 96,
  16, 144, 96, 3, 6, 6, 5, 1, 0, 224, 64, 64, 64, 64, 64, 4,
  6, 6, 5, 0, 0, 144, 144, 144, 144, 144, 96, 4, 6, 6, 5, 0,
  0, 144, 144, 144, 144, 160, 64, 4, 6, 6, 5, 0, 0, 144, 144, 144,
  240, 240, 144, 4, 6, 6, 5, 0, 0, 144, 144, 96, 96, 144, 144, 4,
  6, 6, 5, 0, 0, 144, 144, 160, 64, 64, 64, 4, 6, 6, 5, 0,
  0, 240, 16, 32, 64, 128, 240, 2, 8, 8, 5, 2, 255, 192, 128, 128,
  128, 128, 128, 128, 192, 4, 8, 8, 5, 1, 254, 128, 128, 64, 64, 32,
  32, 16, 16, 2, 8, 8, 5, 1, 255, 192, 64, 64, 64, 64, 64, 64,
  192, 3, 2, 2, 5, 1, 4, 64, 160, 5, 1, 1, 5, 0, 254, 248,
  2, 2, 2, 5, 1, 5, 128, 64, 4, 4, 4, 5, 0, 0, 112, 144,
  176, 80, 4, 6, 6, 5, 0, 0, 128, 128, 224, 144, 144, 224, 4, 4,
  4, 5, 0, 0, 96, 144, 128, 112, 4, 6, 6, 5, 0, 0, 16, 16,
  112, 144, 144, 112, 4, 4, 4, 5, 0, 0, 96, 240, 128, 112, 3, 6,
  6, 5, 1, 0, 32, 64, 224, 64, 64, 64, 4, 6, 6, 5, 0, 254,
  112, 144, 144, 112, 16, 96, 4, 6, 6, 5, 0, 0, 128, 128, 224, 144,
  144, 144, 3, 6, 6, 5, 1, 0, 64, 0, 192, 64, 64, 224, 2, 8,
  8, 5, 1, 254, 64, 0, 192, 64, 64, 64, 64, 128, 4, 6, 6, 5,
  0, 0, 128, 128, 160, 192, 160, 144, 3, 6, 6, 5, 1, 0, 192, 64,
  64, 64, 64, 224, 5, 4, 4, 5, 0, 0, 240, 168, 168, 168, 4, 4,
  4, 5, 0, 0, 160, 208, 144, 144, 4, 4, 4, 5, 0, 0, 96, 144,
  144, 96, 4, 6, 6, 5, 0, 254, 224, 144, 144, 224, 128, 128, 4, 6,
  6, 5, 0, 254, 112, 144, 144, 112, 16, 16, 4, 4, 4, 5, 0, 0,
  160, 208, 128, 128, 4, 4, 4, 5, 0, 0, 112, 224, 16, 224, 3, 6,
  6, 5, 1, 0, 64, 64, 224, 64, 64, 32, 4, 4, 4, 5, 0, 0,
  144, 144, 176, 80, 4, 4, 4, 5, 0, 0, 144, 144, 160, 64, 5, 4,
  4, 5, 0, 0, 168, 168, 168, 80, 4, 4, 4, 5, 0, 0, 144, 96,
  96, 144, 4, 6, 6, 5, 0, 254, 144, 144, 144, 112, 16, 96, 4, 4,
  4, 5, 0, 0, 240, 32, 64, 240, 3, 9, 9, 5, 1, 254, 32, 64,
  64, 64, 128, 64, 64, 64, 32, 1, 8, 8, 5, 2, 255, 128, 128, 128,
  128, 128, 128, 128, 128, 3, 9, 9, 5, 1, 254, 128, 64, 64, 64, 32,
  64, 64, 64, 128, 4, 2, 2, 5, 0, 2, 80, 160, 0, 0, 0, 5,
  0, 0
};

/*
  Fontname: ProFont11
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 7, '1' Height: 7
  Calculated Max Values w= 6 h=11 x= 3 y= 6 dx= 6 dy= 0 ascent= 9 len=11
  Font Bounding box     w= 6 h=10 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 7 descent=-2
  X Font      ascent = 8 descent=-2
  Max Font    ascent = 9 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_profont11[2768] U8G_FONT_SECTION("u8g_font_profont11") = {
  0, 6, 10, 0, 254, 7, 1, 158, 3, 55, 32, 255, 254, 9, 254, 8,
  254, 0, 0, 0, 6, 0, 0, 1, 7, 7, 6, 2, 0, 128, 128, 128,
  128, 128, 0, 128, 3, 3, 3, 6, 1, 5, 160, 160, 160, 5, 5, 5,
  6, 0, 2, 80, 248, 80, 248, 80, 5, 9, 9, 6, 0, 255, 32, 112,
  168, 160, 112, 40, 168, 112, 32, 5, 7, 7, 6, 0, 0, 120, 168, 176,
  80, 104, 168, 144, 5, 7, 7, 6, 0, 0, 96, 144, 160, 64, 168, 144,
  104, 1, 3, 3, 6, 2, 5, 128, 128, 128, 3, 9, 9, 6, 1, 255,
  32, 64, 128, 128, 128, 128, 128, 64, 32, 3, 9, 9, 6, 1, 255, 128,
  64, 32, 32, 32, 32, 32, 64, 128, 5, 5, 5, 6, 0, 2, 32, 168,
  112, 168, 32, 5, 5, 5, 6, 0, 1, 32, 32, 248, 32, 32, 2, 4,
  4, 6, 1, 254, 192, 192, 64, 128, 3, 1, 1, 6, 1, 3, 224, 2,
  2, 2, 6, 2, 0, 192, 192, 5, 10, 10, 6, 0, 254, 8, 8, 16,
  16, 32, 32, 64, 64, 128, 128, 5, 7, 7, 6, 0, 0, 112, 136, 152,
  168, 200, 136, 112, 5, 7, 7, 6, 0, 0, 32, 224, 32, 32, 32, 32,
  248, 5, 7, 7, 6, 0, 0, 112, 136, 8, 16, 32, 64, 248, 5, 7,
  7, 6, 0, 0, 112, 136, 8, 48, 8, 136, 112, 5, 7, 7, 6, 0,
  0, 16, 48, 80, 144, 248, 16, 56, 5, 7, 7, 6, 0, 0, 248, 128,
  240, 8, 8, 136, 112, 5, 7, 7, 6, 0, 0, 112, 128, 240, 136, 136,
  136, 112, 5, 7, 7, 6, 0, 0, 248, 8, 8, 16, 32, 32, 32, 5,
  7, 7, 6, 0, 0, 112, 136, 136, 112, 136, 136, 112, 5, 7, 7, 6,
  0, 0, 112, 136, 136, 136, 120, 8, 112, 2, 5, 5, 6, 2, 0, 192,
  192, 0, 192, 192, 2, 7, 7, 6, 1, 254, 192, 192, 0, 192, 192, 64,
  128, 4, 7, 7, 6, 1, 0, 16, 32, 64, 128, 64, 32, 16, 5, 3,
  3, 6, 0, 2, 248, 0, 248, 4, 7, 7, 6, 1, 0, 128, 64, 32,
  16, 32, 64, 128, 5, 7, 7, 6, 0, 0, 112, 136, 8, 16, 32, 0,
  32, 5, 7, 7, 6, 0, 0, 112, 136, 184, 168, 184, 128, 120, 5, 7,
  7, 6, 0, 0, 32, 80, 80, 136, 248, 136, 136, 5, 7, 7, 6, 0,
  0, 240, 136, 136, 240, 136, 136, 240, 5, 7, 7, 6, 0, 0, 112, 136,
  128, 128, 128, 136, 112, 5, 7, 7, 6, 0, 0, 240, 136, 136, 136, 136,
  136, 240, 5, 7, 7, 6, 0, 0, 248, 128, 128, 240, 128, 128, 248, 5,
  7, 7, 6, 0, 0, 248, 128, 128, 240, 128, 128, 128, 5, 7, 7, 6,
  0, 0, 112, 136, 128, 152, 136, 136, 112, 5, 7, 7, 6, 0, 0, 136,
  136, 136, 248, 136, 136, 136, 5, 7, 7, 6, 0, 0, 248, 32, 32, 32,
  32, 32, 248, 5, 7, 7, 6, 0, 0, 8, 8, 8, 8, 136, 136, 112,
  5, 7, 7, 6, 0, 0, 136, 144, 160, 192, 160, 144, 136, 5, 7, 7,
  6, 0, 0, 128, 128, 128, 128, 128, 128, 248, 5, 7, 7, 6, 0, 0,
  136, 216, 168, 168, 136, 136, 136, 5, 7, 7, 6, 0, 0, 136, 200, 168,
  152, 136, 136, 136, 5, 7, 7, 6, 0, 0, 112, 136, 136, 136, 136, 136,
  112, 5, 7, 7, 6, 0, 0, 240, 136, 136, 240, 128, 128, 128, 5, 8,
  8, 6, 0, 255, 112, 136, 136, 136, 136, 168, 112, 8, 5, 7, 7, 6,
  0, 0, 240, 136, 136, 240, 136, 136, 136, 5, 7, 7, 6, 0, 0, 112,
  136, 128, 112, 8, 136, 112, 5, 7, 7, 6, 0, 0, 248, 32, 32, 32,
  32, 32, 32, 5, 7, 7, 6, 0, 0, 136, 136, 136, 136, 136, 136, 112,
  5, 7, 7, 6, 0, 0, 136, 136, 136, 80, 80, 32, 32, 5, 7, 7,
  6, 0, 0, 136, 136, 136, 168, 168, 216, 136, 5, 7, 7, 6, 0, 0,
  136, 136, 80, 32, 80, 136, 136, 5, 7, 7, 6, 0, 0, 136, 136, 136,
  80, 32, 32, 32, 5, 7, 7, 6, 0, 0, 248, 8, 16, 32, 64, 128,
  248, 2, 9, 9, 6, 2, 255, 192, 128, 128, 128, 128, 128, 128, 128, 192,
  5, 10, 10, 6, 1, 254, 128, 128, 64, 64, 32, 32, 16, 16, 8, 8,
  2, 9, 9, 6, 1, 255, 192, 64, 64, 64, 64, 64, 64, 64, 192, 5,
  3, 3, 6, 0, 4, 32, 80, 136, 6, 1, 1, 6, 0, 254, 252, 2,
  2, 2, 6, 1, 6, 128, 64, 5, 5, 5, 6, 0, 0, 120, 136, 136,
  152, 104, 5, 7, 7, 6, 0, 0, 128, 128, 240, 136, 136, 136, 240, 5,
  5, 5, 6, 0, 0, 112, 136, 128, 128, 120, 5, 7, 7, 6, 0, 0,
  8, 8, 120, 136, 136, 136, 120, 5, 5, 5, 6, 0, 0, 112, 136, 248,
  128, 120, 4, 7, 7, 6, 1, 0, 48, 64, 224, 64, 64, 64, 64, 5,
  7, 7, 6, 0, 254, 120, 136, 136, 136, 120, 8, 112, 5, 7, 7, 6,
  0, 0, 128, 128, 240, 136, 136, 136, 136, 3, 7, 7, 6, 1, 0, 64,
  0, 192, 64, 64, 64, 224, 3, 9, 9, 6, 0, 254, 32, 0, 96, 32,
  32, 32, 32, 32, 192, 5, 7, 7, 6, 0, 0, 128, 128, 144, 160, 224,
  144, 136, 3, 7, 7, 6, 1, 0, 192, 64, 64, 64, 64, 64, 224, 5,
  5, 5, 6, 0, 0, 240, 168, 168, 168, 168, 5, 5, 5, 6, 0, 0,
  176, 200, 136, 136, 136, 5, 5, 5, 6, 0, 0, 112, 136, 136, 136, 112,
  5, 7, 7, 6, 0, 254, 240, 136, 136, 136, 240, 128, 128, 5, 7, 7,
  6, 0, 254, 120, 136, 136, 136, 120, 8, 8, 5, 5, 5, 6, 0, 0,
  176, 200, 128, 128, 128, 5, 5, 5, 6, 0, 0, 120, 128, 112, 8, 240,
  4, 7, 7, 6, 1, 0, 64, 64, 224, 64, 64, 64, 48, 5, 5, 5,
  6, 0, 0, 136, 136, 136, 152, 104, 5, 5, 5, 6, 0, 0, 136, 136,
  80, 80, 32, 5, 5, 5, 6, 0, 0, 168, 168, 168, 168, 80, 5, 5,
  5, 6, 0, 0, 136, 80, 32, 80, 136, 5, 7, 7, 6, 0, 254, 136,
  136, 136, 136, 120, 8, 112, 5, 5, 5, 6, 0, 0, 248, 16, 32, 64,
  248, 3, 11, 11, 6, 1, 254, 32, 64, 64, 64, 64, 128, 64, 64, 64,
  64, 32, 1, 9, 9, 6, 2, 255, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 3, 11, 11, 6, 1, 254, 128, 64, 64, 64, 64, 32, 64, 64, 64,
  64, 128, 5, 2, 2, 6, 0, 3, 104, 176, 0, 0, 0, 6, 0, 0,
  0, 0, 0, 6, 0, 0, 0, 0, 0, 6, 0, 0, 2, 3, 3, 6,
  0, 255, 64, 64, 128, 5, 11, 11, 6, 0, 254, 24, 32, 32, 32, 112,
  32, 32, 32, 32, 32, 192, 4, 3, 3, 6, 0, 255, 80, 80, 160, 5,
  1, 1, 6, 0, 0, 168, 3, 5, 5, 6, 1, 2, 64, 224, 64, 64,
  64, 3, 5, 5, 6, 1, 2, 64, 224, 64, 224, 64, 3, 2, 2, 6,
  1, 6, 64, 160, 6, 8, 8, 6, 0, 0, 124, 168, 176, 96, 104, 212,
  84, 40, 5, 9, 9, 6, 0, 0, 80, 32, 112, 136, 128, 112, 8, 136,
  112, 2, 4, 4, 6, 0, 0, 64, 128, 128, 64, 5, 7, 7, 6, 0,
  0, 120, 160, 160, 176, 160, 160, 120, 0, 0, 0, 6, 0, 0, 0, 0,
  0, 6, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 6, 0, 0,
  2, 3, 3, 6, 2, 4, 64, 128, 128, 2, 3, 3, 6, 2, 4, 64,
  64, 128, 4, 3, 3, 6, 1, 4, 80, 160, 160, 4, 3, 3, 6, 1,
  4, 80, 80, 160, 5, 5, 5, 6, 0, 1, 112, 248, 248, 248, 112, 3,
  1, 1, 6, 1, 3, 224, 6, 1, 1, 6, 0, 3, 252, 5, 2, 2,
  6, 0, 6, 104, 176, 6, 3, 3, 6, 0, 4, 244, 92, 92, 5, 8,
  8, 6, 0, 0, 80, 32, 0, 120, 128, 112, 8, 240, 2, 4, 4, 6,
  0, 0, 128, 64, 64, 128, 5, 5, 5, 6, 0, 0, 80, 168, 184, 160,
  88, 0, 0, 0, 6, 0, 0, 0, 0, 0, 6, 0, 0, 5, 9, 9,
  6, 0, 0, 80, 0, 136, 136, 136, 80, 32, 32, 32, 0, 0, 0, 6,
  0, 0, 1, 7, 7, 6, 3, 0, 128, 0, 128, 128, 128, 128, 128, 5,
  7, 7, 6, 0, 255, 32, 112, 168, 160, 160, 120, 32, 5, 8, 8, 6,
  0, 0, 96, 144, 128, 224, 128, 128, 136, 240, 5, 5, 5, 6, 0, 0,
  136, 112, 80, 112, 136, 5, 7, 7, 6, 0, 0, 136, 80, 248, 32, 248,
  32, 32, 1, 9, 9, 6, 2, 255, 128, 128, 128, 128, 0, 128, 128, 128,
  128, 5, 10, 10, 6, 0, 255, 112, 136, 72, 160, 144, 72, 40, 144, 136,
  112, 3, 1, 1, 6, 1, 6, 160, 5, 7, 7, 6, 0, 0, 224, 16,
  104, 136, 104, 16, 224, 4, 6, 6, 6, 1, 3, 112, 144, 144, 112, 0,
  240, 5, 4, 4, 6, 0, 0, 72, 144, 144, 72, 5, 3, 3, 6, 0,
  1, 248, 8, 8, 5, 1, 1, 6, 0, 3, 248, 5, 6, 6, 6, 0,
  1, 224, 16, 200, 168, 200, 176, 3, 1, 1, 6, 1, 6, 224, 4, 4,
  4, 6, 1, 4, 96, 144, 144, 96, 5, 6, 6, 6, 0, 0, 32, 32,
  248, 32, 32, 248, 3, 4, 4, 6, 1, 5, 192, 32, 64, 224, 3, 5,
  5, 6, 1, 4, 192, 32, 96, 32, 192, 3, 2, 2, 6, 2, 6, 96,
  192, 5, 7, 7, 6, 0, 254, 144, 144, 144, 144, 232, 128, 128, 5, 8,
  8, 6, 0, 0, 120, 168, 168, 168, 120, 40, 40, 40, 2, 2, 2, 6,
  2, 2, 192, 192, 3, 3, 3, 6, 1, 254, 224, 96, 192, 3, 4, 4,
  6, 1, 5, 192, 64, 64, 224, 4, 6, 6, 6, 1, 3, 96, 144, 144,
  96, 0, 240, 5, 4, 4, 6, 0, 0, 144, 72, 72, 144, 6, 9, 9,
  6, 0, 0, 192, 64, 68, 232, 16, 40, 88, 184, 8, 6, 9, 9, 6,
  0, 0, 192, 64, 68, 232, 16, 56, 68, 136, 28, 6, 9, 9, 6, 0,
  0, 192, 32, 100, 40, 208, 40, 88, 184, 8, 5, 7, 7, 6, 0, 0,
  32, 0, 32, 64, 128, 136, 112, 5, 9, 9, 6, 0, 0, 64, 32, 32,
  80, 80, 136, 248, 136, 136, 5, 9, 9, 6, 0, 0, 16, 32, 32, 80,
  80, 136, 248, 136, 136, 5, 9, 9, 6, 0, 0, 32, 80, 0, 32, 80,
  136, 248, 136, 136, 5, 9, 9, 6, 0, 0, 104, 176, 32, 80, 80, 136,
  248, 136, 136, 5, 9, 9, 6, 0, 0, 80, 0, 32, 80, 80, 136, 248,
  136, 136, 5, 9, 9, 6, 0, 0, 32, 80, 32, 80, 136, 136, 248, 136,
  136, 5, 7, 7, 6, 0, 0, 120, 160, 160, 240, 160, 160, 184, 5, 9,
  9, 6, 0, 254, 112, 136, 128, 128, 128, 136, 112, 32, 64, 5, 9, 9,
  6, 0, 0, 64, 32, 248, 128, 128, 240, 128, 128, 248, 5, 9, 9, 6,
  0, 0, 16, 32, 248, 128, 128, 240, 128, 128, 248, 5, 9, 9, 6, 0,
  0, 32, 80, 248, 128, 128, 240, 128, 128, 248, 5, 9, 9, 6, 0, 0,
  80, 0, 248, 128, 128, 240, 128, 128, 248, 5, 9, 9, 6, 0, 0, 64,
  32, 248, 32, 32, 32, 32, 32, 248, 5, 9, 9, 6, 0, 0, 16, 32,
  248, 32, 32, 32, 32, 32, 248, 5, 9, 9, 6, 0, 0, 32, 80, 0,
  248, 32, 32, 32, 32, 248, 5, 9, 9, 6, 0, 0, 80, 0, 248, 32,
  32, 32, 32, 32, 248, 5, 7, 7, 6, 0, 0, 112, 72, 72, 232, 72,
  72, 112, 5, 9, 9, 6, 0, 0, 104, 176, 136, 200, 168, 152, 136, 136,
  136, 5, 9, 9, 6, 0, 0, 64, 32, 112, 136, 136, 136, 136, 136, 112,
  5, 9, 9, 6, 0, 0, 16, 32, 112, 136, 136, 136, 136, 136, 112, 5,
  9, 9, 6, 0, 0, 32, 80, 0, 112, 136, 136, 136, 136, 112, 5, 9,
  9, 6, 0, 0, 104, 176, 112, 136, 136, 136, 136, 136, 112, 5, 9, 9,
  6, 0, 0, 80, 0, 112, 136, 136, 136, 136, 136, 112, 5, 5, 5, 6,
  0, 1, 136, 80, 32, 80, 136, 5, 7, 7, 6, 0, 0, 112, 136, 152,
  168, 200, 136, 112, 5, 9, 9, 6, 0, 0, 64, 32, 136, 136, 136, 136,
  136, 136, 112, 5, 9, 9, 6, 0, 0, 16, 32, 136, 136, 136, 136, 136,
  136, 112, 5, 9, 9, 6, 0, 0, 32, 80, 0, 136, 136, 136, 136, 136,
  112, 5, 9, 9, 6, 0, 0, 80, 0, 136, 136, 136, 136, 136, 136, 112,
  5, 9, 9, 6, 0, 0, 16, 32, 136, 136, 136, 80, 32, 32, 32, 5,
  7, 7, 6, 0, 0, 128, 240, 136, 136, 240, 128, 128, 5, 9, 9, 6,
  0, 255, 48, 72, 136, 144, 144, 136, 136, 176, 128, 5, 8, 8, 6, 0,
  0, 32, 16, 0, 120, 136, 136, 152, 104, 5, 8, 8, 6, 0, 0, 16,
  32, 0, 120, 136, 136, 152, 104, 5, 8, 8, 6, 0, 0, 32, 80, 0,
  120, 136, 136, 152, 104, 5, 8, 8, 6, 0, 0, 104, 176, 0, 120, 136,
  136, 152, 104, 5, 7, 7, 6, 0, 0, 80, 0, 120, 136, 136, 152, 104,
  5, 8, 8, 6, 0, 0, 32, 80, 32, 120, 136, 136, 152, 104, 5, 5,
  5, 6, 0, 0, 112, 168, 184, 160, 120, 5, 7, 7, 6, 0, 254, 112,
  136, 128, 128, 120, 32, 64, 5, 8, 8, 6, 0, 0, 64, 32, 0, 112,
  136, 248, 128, 120, 5, 8, 8, 6, 0, 0, 16, 32, 0, 112, 136, 248,
  128, 120, 5, 8, 8, 6, 0, 0, 32, 80, 0, 112, 136, 248, 128, 120,
  5, 7, 7, 6, 0, 0, 80, 0, 112, 136, 248, 128, 120, 3, 8, 8,
  6, 1, 0, 128, 64, 0, 192, 64, 64, 64, 224, 3, 8, 8, 6, 1,
  0, 32, 64, 0, 192, 64, 64, 64, 224, 3, 8, 8, 6, 1, 0, 64,
  160, 0, 192, 64, 64, 64, 224, 3, 7, 7, 6, 1, 0, 160, 0, 192,
  64, 64, 64, 224, 5, 8, 8, 6, 0, 0, 96, 96, 16, 120, 136, 136,
  136, 112, 5, 8, 8, 6, 0, 0, 104, 176, 0, 176, 200, 136, 136, 136,
  5, 8, 8, 6, 0, 0, 64, 32, 0, 112, 136, 136, 136, 112, 5, 8,
  8, 6, 0, 0, 16, 32, 0, 112, 136, 136, 136, 112, 5, 8, 8, 6,
  0, 0, 32, 80, 0, 112, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0,
  104, 176, 0, 112, 136, 136, 136, 112, 5, 7, 7, 6, 0, 0, 80, 0,
  112, 136, 136, 136, 112, 5, 5, 5, 6, 0, 1, 32, 0, 248, 0, 32,
  5, 5, 5, 6, 0, 0, 112, 152, 168, 200, 112, 5, 8, 8, 6, 0,
  0, 64, 32, 0, 136, 136, 136, 152, 104, 5, 8, 8, 6, 0, 0, 16,
  32, 0, 136, 136, 136, 152, 104, 5, 8, 8, 6, 0, 0, 32, 80, 0,
  136, 136, 136, 152, 104, 5, 7, 7, 6, 0, 0, 80, 0, 136, 136, 136,
  152, 104, 5, 10, 10, 6, 0, 254, 16, 32, 0, 136, 136, 136, 136, 120,
  8, 112, 5, 9, 9, 6, 0, 254, 128, 128, 240, 136, 136, 136, 240, 128,
  128, 5, 9, 9, 6, 0, 254, 80, 0, 136, 136, 136, 136, 120, 8, 112
};

/*
  Fontname: ProFont11
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 7, '1' Height: 7
  Calculated Max Values w= 6 h=11 x= 2 y= 6 dx= 6 dy= 0 ascent= 9 len=11
  Font Bounding box     w= 6 h=10 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 7 descent=-2
  X Font      ascent = 8 descent=-2
  Max Font    ascent = 9 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_profont11r[1200] U8G_FONT_SECTION("u8g_font_profont11r") = {
  0, 6, 10, 0, 254, 7, 1, 158, 3, 55, 32, 127, 254, 9, 254, 8,
  254, 0, 0, 0, 6, 0, 0, 1, 7, 7, 6, 2, 0, 128, 128, 128,
  128, 128, 0, 128, 3, 3, 3, 6, 1, 5, 160, 160, 160, 5, 5, 5,
  6, 0, 2, 80, 248, 80, 248, 80, 5, 9, 9, 6, 0, 255, 32, 112,
  168, 160, 112, 40, 168, 112, 32, 5, 7, 7, 6, 0, 0, 120, 168, 176,
  80, 104, 168, 144, 5, 7, 7, 6, 0, 0, 96, 144, 160, 64, 168, 144,
  104, 1, 3, 3, 6, 2, 5, 128, 128, 128, 3, 9, 9, 6, 1, 255,
  32, 64, 128, 128, 128, 128, 128, 64, 32, 3, 9, 9, 6, 1, 255, 128,
  64, 32, 32, 32, 32, 32, 64, 128, 5, 5, 5, 6, 0, 2, 32, 168,
  112, 168, 32, 5, 5, 5, 6, 0, 1, 32, 32, 248, 32, 32, 2, 4,
  4, 6, 1, 254, 192, 192, 64, 128, 3, 1, 1, 6, 1, 3, 224, 2,
  2, 2, 6, 2, 0, 192, 192, 5, 10, 10, 6, 0, 254, 8, 8, 16,
  16, 32, 32, 64, 64, 128, 128, 5, 7, 7, 6, 0, 0, 112, 136, 152,
  168, 200, 136, 112, 5, 7, 7, 6, 0, 0, 32, 224, 32, 32, 32, 32,
  248, 5, 7, 7, 6, 0, 0, 112, 136, 8, 16, 32, 64, 248, 5, 7,
  7, 6, 0, 0, 112, 136, 8, 48, 8, 136, 112, 5, 7, 7, 6, 0,
  0, 16, 48, 80, 144, 248, 16, 56, 5, 7, 7, 6, 0, 0, 248, 128,
  240, 8, 8, 136, 112, 5, 7, 7, 6, 0, 0, 112, 128, 240, 136, 136,
  136, 112, 5, 7, 7, 6, 0, 0, 248, 8, 8, 16, 32, 32, 32, 5,
  7, 7, 6, 0, 0, 112, 136, 136, 112, 136, 136, 112, 5, 7, 7, 6,
  0, 0, 112, 136, 136, 136, 120, 8, 112, 2, 5, 5, 6, 2, 0, 192,
  192, 0, 192, 192, 2, 7, 7, 6, 1, 254, 192, 192, 0, 192, 192, 64,
  128, 4, 7, 7, 6, 1, 0, 16, 32, 64, 128, 64, 32, 16, 5, 3,
  3, 6, 0, 2, 248, 0, 248, 4, 7, 7, 6, 1, 0, 128, 64, 32,
  16, 32, 64, 128, 5, 7, 7, 6, 0, 0, 112, 136, 8, 16, 32, 0,
  32, 5, 7, 7, 6, 0, 0, 112, 136, 184, 168, 184, 128, 120, 5, 7,
  7, 6, 0, 0, 32, 80, 80, 136, 248, 136, 136, 5, 7, 7, 6, 0,
  0, 240, 136, 136, 240, 136, 136, 240, 5, 7, 7, 6, 0, 0, 112, 136,
  128, 128, 128, 136, 112, 5, 7, 7, 6, 0, 0, 240, 136, 136, 136, 136,
  136, 240, 5, 7, 7, 6, 0, 0, 248, 128, 128, 240, 128, 128, 248, 5,
  7, 7, 6, 0, 0, 248, 128, 128, 240, 128, 128, 128, 5, 7, 7, 6,
  0, 0, 112, 136, 128, 152, 136, 136, 112, 5, 7, 7, 6, 0, 0, 136,
  136, 136, 248, 136, 136, 136, 5, 7, 7, 6, 0, 0, 248, 32, 32, 32,
  32, 32, 248, 5, 7, 7, 6, 0, 0, 8, 8, 8, 8, 136, 136, 112,
  5, 7, 7, 6, 0, 0, 136, 144, 160, 192, 160, 144, 136, 5, 7, 7,
  6, 0, 0, 128, 128, 128, 128, 128, 128, 248, 5, 7, 7, 6, 0, 0,
  136, 216, 168, 168, 136, 136, 136, 5, 7, 7, 6, 0, 0, 136, 200, 168,
  152, 136, 136, 136, 5, 7, 7, 6, 0, 0, 112, 136, 136, 136, 136, 136,
  112, 5, 7, 7, 6, 0, 0, 240, 136, 136, 240, 128, 128, 128, 5, 8,
  8, 6, 0, 255, 112, 136, 136, 136, 136, 168, 112, 8, 5, 7, 7, 6,
  0, 0, 240, 136, 136, 240, 136, 136, 136, 5, 7, 7, 6, 0, 0, 112,
  136, 128, 112, 8, 136, 112, 5, 7, 7, 6, 0, 0, 248, 32, 32, 32,
  32, 32, 32, 5, 7, 7, 6, 0, 0, 136, 136, 136, 136, 136, 136, 112,
  5, 7, 7, 6, 0, 0, 136, 136, 136, 80, 80, 32, 32, 5, 7, 7,
  6, 0, 0, 136, 136, 136, 168, 168, 216, 136, 5, 7, 7, 6, 0, 0,
  136, 136, 80, 32, 80, 136, 136, 5, 7, 7, 6, 0, 0, 136, 136, 136,
  80, 32, 32, 32, 5, 7, 7, 6, 0, 0, 248, 8, 16, 32, 64, 128,
  248, 2, 9, 9, 6, 2, 255, 192, 128, 128, 128, 128, 128, 128, 128, 192,
  5, 10, 10, 6, 1, 254, 128, 128, 64, 64, 32, 32, 16, 16, 8, 8,
  2, 9, 9, 6, 1, 255, 192, 64, 64, 64, 64, 64, 64, 64, 192, 5,
  3, 3, 6, 0, 4, 32, 80, 136, 6, 1, 1, 6, 0, 254, 252, 2,
  2, 2, 6, 1, 6, 128, 64, 5, 5, 5, 6, 0, 0, 120, 136, 136,
  152, 104, 5, 7, 7, 6, 0, 0, 128, 128, 240, 136, 136, 136, 240, 5,
  5, 5, 6, 0, 0, 112, 136, 128, 128, 120, 5, 7, 7, 6, 0, 0,
  8, 8, 120, 136, 136, 136, 120, 5, 5, 5, 6, 0, 0, 112, 136, 248,
  128, 120, 4, 7, 7, 6, 1, 0, 48, 64, 224, 64, 64, 64, 64, 5,
  7, 7, 6, 0, 254, 120, 136, 136, 136, 120, 8, 112, 5, 7, 7, 6,
  0, 0, 128, 128, 240, 136, 136, 136, 136, 3, 7, 7, 6, 1, 0, 64,
  0, 192, 64, 64, 64, 224, 3, 9, 9, 6, 0, 254, 32, 0, 96, 32,
  32, 32, 32, 32, 192, 5, 7, 7, 6, 0, 0, 128, 128, 144, 160, 224,
  144, 136, 3, 7, 7, 6, 1, 0, 192, 64, 64, 64, 64, 64, 224, 5,
  5, 5, 6, 0, 0, 240, 168, 168, 168, 168, 5, 5, 5, 6, 0, 0,
  176, 200, 136, 136, 136, 5, 5, 5, 6, 0, 0, 112, 136, 136, 136, 112,
  5, 7, 7, 6, 0, 254, 240, 136, 136, 136, 240, 128, 128, 5, 7, 7,
  6, 0, 254, 120, 136, 136, 136, 120, 8, 8, 5, 5, 5, 6, 0, 0,
  176, 200, 128, 128, 128, 5, 5, 5, 6, 0, 0, 120, 128, 112, 8, 240,
  4, 7, 7, 6, 1, 0, 64, 64, 224, 64, 64, 64, 48, 5, 5, 5,
  6, 0, 0, 136, 136, 136, 152, 104, 5, 5, 5, 6, 0, 0, 136, 136,
  80, 80, 32, 5, 5, 5, 6, 0, 0, 168, 168, 168, 168, 80, 5, 5,
  5, 6, 0, 0, 136, 80, 32, 80, 136, 5, 7, 7, 6, 0, 254, 136,
  136, 136, 136, 120, 8, 112, 5, 5, 5, 6, 0, 0, 248, 16, 32, 64,
  248, 3, 11, 11, 6, 1, 254, 32, 64, 64, 64, 64, 128, 64, 64, 64,
  64, 32, 1, 9, 9, 6, 2, 255, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 3, 11, 11, 6, 1, 254, 128, 64, 64, 64, 64, 32, 64, 64, 64,
  64, 128, 5, 2, 2, 6, 0, 3, 104, 176, 0, 0, 0, 6, 0, 0
};

/*
  Fontname: ProFont12
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 8, '1' Height: 8
  Calculated Max Values w= 6 h=12 x= 3 y= 7 dx= 6 dy= 0 ascent=10 len=12
  Font Bounding box     w= 6 h=11 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 8 descent=-2
  X Font      ascent = 9 descent=-2
  Max Font    ascent =10 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_profont12[2907] U8G_FONT_SECTION("u8g_font_profont12") = {
  0, 6, 11, 0, 254, 8, 1, 178, 3, 103, 32, 255, 254, 10, 254, 9,
  254, 0, 0, 0, 6, 0, 0, 1, 8, 8, 6, 2, 0, 128, 128, 128,
  128, 128, 128, 0, 128, 3, 3, 3, 6, 1, 6, 160, 160, 160, 5, 5,
  5, 6, 0, 3, 80, 248, 80, 248, 80, 5, 10, 10, 6, 0, 255, 32,
  112, 168, 160, 112, 40, 40, 168, 112, 32, 5, 8, 8, 6, 0, 0, 120,
  168, 168, 80, 48, 104, 168, 144, 5, 8, 8, 6, 0, 0, 96, 144, 160,
  64, 160, 168, 144, 104, 1, 3, 3, 6, 2, 6, 128, 128, 128, 3, 10,
  10, 6, 1, 255, 32, 64, 128, 128, 128, 128, 128, 128, 64, 32, 3, 10,
  10, 6, 1, 255, 128, 64, 32, 32, 32, 32, 32, 32, 64, 128, 5, 5,
  5, 6, 0, 3, 32, 168, 112, 168, 32, 5, 5, 5, 6, 0, 1, 32,
  32, 248, 32, 32, 2, 4, 4, 6, 1, 254, 192, 192, 64, 128, 3, 1,
  1, 6, 1, 3, 224, 2, 2, 2, 6, 2, 0, 192, 192, 5, 10, 10,
  6, 0, 254, 8, 8, 16, 16, 32, 32, 64, 64, 128, 128, 5, 8, 8,
  6, 0, 0, 112, 136, 152, 168, 200, 136, 136, 112, 5, 8, 8, 6, 0,
  0, 32, 224, 32, 32, 32, 32, 32, 248, 5, 8, 8, 6, 0, 0, 112,
  136, 8, 16, 32, 64, 128, 248, 5, 8, 8, 6, 0, 0, 112, 136, 8,
  48, 8, 8, 136, 112, 5, 8, 8, 6, 0, 0, 16, 48, 80, 144, 248,
  16, 16, 56, 5, 8, 8, 6, 0, 0, 248, 128, 128, 240, 8, 8, 136,
  112, 5, 8, 8, 6, 0, 0, 112, 128, 128, 240, 136, 136, 136, 112, 5,
  8, 8, 6, 0, 0, 248, 8, 8, 16, 32, 32, 32, 32, 5, 8, 8,
  6, 0, 0, 112, 136, 136, 112, 136, 136, 136, 112, 5, 8, 8, 6, 0,
  0, 112, 136, 136, 136, 120, 8, 8, 112, 2, 6, 6, 6, 2, 0, 192,
  192, 0, 0, 192, 192, 2, 8, 8, 6, 1, 254, 192, 192, 0, 0, 192,
  192, 64, 128, 4, 7, 7, 6, 1, 1, 16, 32, 64, 128, 64, 32, 16,
  5, 3, 3, 6, 0, 3, 248, 0, 248, 4, 7, 7, 6, 1, 1, 128,
  64, 32, 16, 32, 64, 128, 5, 8, 8, 6, 0, 0, 112, 136, 8, 8,
  16, 32, 0, 32, 5, 8, 8, 6, 0, 0, 112, 136, 184, 168, 184, 128,
  128, 120, 5, 8, 8, 6, 0, 0, 32, 80, 80, 136, 136, 248, 136, 136,
  5, 8, 8, 6, 0, 0, 240, 136, 136, 240, 136, 136, 136, 240, 5, 8,
  8, 6, 0, 0, 112, 136, 128, 128, 128, 128, 136, 112, 5, 8, 8, 6,
  0, 0, 240, 136, 136, 136, 136, 136, 136, 240, 5, 8, 8, 6, 0, 0,
  248, 128, 128, 240, 128, 128, 128, 248, 5, 8, 8, 6, 0, 0, 248, 128,
  128, 240, 128, 128, 128, 128, 5, 8, 8, 6, 0, 0, 112, 136, 128, 128,
  152, 136, 136, 112, 5, 8, 8, 6, 0, 0, 136, 136, 136, 248, 136, 136,
  136, 136, 5, 8, 8, 6, 0, 0, 248, 32, 32, 32, 32, 32, 32, 248,
  5, 8, 8, 6, 0, 0, 8, 8, 8, 8, 8, 136, 136, 112, 5, 8,
  8, 6, 0, 0, 136, 144, 160, 192, 192, 160, 144, 136, 5, 8, 8, 6,
  0, 0, 128, 128, 128, 128, 128, 128, 128, 248, 5, 8, 8, 6, 0, 0,
  136, 216, 168, 168, 136, 136, 136, 136, 5, 8, 8, 6, 0, 0, 136, 200,
  168, 152, 136, 136, 136, 136, 5, 8, 8, 6, 0, 0, 112, 136, 136, 136,
  136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 240, 136, 136, 240, 128, 128,
  128, 128, 5, 9, 9, 6, 0, 255, 112, 136, 136, 136, 136, 136, 168, 112,
  8, 5, 8, 8, 6, 0, 0, 240, 136, 136, 240, 136, 136, 136, 136, 5,
  8, 8, 6, 0, 0, 112, 136, 128, 112, 8, 8, 136, 112, 5, 8, 8,
  6, 0, 0, 248, 32, 32, 32, 32, 32, 32, 32, 5, 8, 8, 6, 0,
  0, 136, 136, 136, 136, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 136,
  136, 136, 136, 80, 80, 32, 32, 5, 8, 8, 6, 0, 0, 136, 136, 136,
  136, 168, 168, 216, 136, 5, 8, 8, 6, 0, 0, 136, 136, 136, 80, 32,
  80, 136, 136, 5, 8, 8, 6, 0, 0, 136, 136, 136, 136, 80, 32, 32,
  32, 5, 8, 8, 6, 0, 0, 248, 8, 16, 32, 64, 128, 128, 248, 2,
  10, 10, 6, 2, 255, 192, 128, 128, 128, 128, 128, 128, 128, 128, 192, 5,
  10, 10, 6, 1, 254, 128, 128, 64, 64, 32, 32, 16, 16, 8, 8, 2,
  10, 10, 6, 1, 255, 192, 64, 64, 64, 64, 64, 64, 64, 64, 192, 5,
  3, 3, 6, 0, 5, 32, 80, 136, 6, 1, 1, 6, 0, 254, 252, 2,
  2, 2, 6, 1, 7, 128, 64, 5, 5, 5, 6, 0, 0, 120, 136, 136,
  152, 104, 5, 8, 8, 6, 0, 0, 128, 128, 128, 240, 136, 136, 136, 240,
  5, 5, 5, 6, 0, 0, 112, 136, 128, 128, 120, 5, 8, 8, 6, 0,
  0, 8, 8, 8, 120, 136, 136, 136, 120, 5, 5, 5, 6, 0, 0, 112,
  136, 248, 128, 120, 4, 8, 8, 6, 1, 0, 48, 64, 224, 64, 64, 64,
  64, 64, 5, 7, 7, 6, 0, 254, 120, 136, 136, 136, 120, 8, 112, 5,
  8, 8, 6, 0, 0, 128, 128, 128, 240, 136, 136, 136, 136, 3, 8, 8,
  6, 1, 0, 64, 0, 0, 192, 64, 64, 64, 224, 3, 10, 10, 6, 0,
  254, 32, 0, 0, 96, 32, 32, 32, 32, 32, 192, 5, 8, 8, 6, 0,
  0, 128, 128, 128, 144, 160, 224, 144, 136, 3, 8, 8, 6, 1, 0, 192,
  64, 64, 64, 64, 64, 64, 224, 5, 5, 5, 6, 0, 0, 240, 168, 168,
  168, 168, 5, 5, 5, 6, 0, 0, 176, 200, 136, 136, 136, 5, 5, 5,
  6, 0, 0, 112, 136, 136, 136, 112, 5, 7, 7, 6, 0, 254, 240, 136,
  136, 136, 240, 128, 128, 5, 7, 7, 6, 0, 254, 120, 136, 136, 136, 120,
  8, 8, 5, 5, 5, 6, 0, 0, 176, 200, 128, 128, 128, 5, 5, 5,
  6, 0, 0, 120, 128, 112, 8, 240, 4, 8, 8, 6, 1, 0, 64, 64,
  64, 224, 64, 64, 64, 48, 5, 5, 5, 6, 0, 0, 136, 136, 136, 152,
  104, 5, 5, 5, 6, 0, 0, 136, 136, 80, 80, 32, 5, 5, 5, 6,
  0, 0, 168, 168, 168, 168, 80, 5, 5, 5, 6, 0, 0, 136, 80, 32,
  80, 136, 5, 7, 7, 6, 0, 254, 136, 136, 136, 136, 120, 8, 112, 5,
  5, 5, 6, 0, 0, 248, 16, 32, 64, 248, 3, 11, 11, 6, 1, 254,
  32, 64, 64, 64, 64, 128, 64, 64, 64, 64, 32, 1, 10, 10, 6, 2,
  255, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 3, 11, 11, 6, 1,
  254, 128, 64, 64, 64, 64, 32, 64, 64, 64, 64, 128, 5, 2, 2, 6,
  0, 4, 104, 176, 0, 0, 0, 6, 0, 0, 0, 0, 0, 6, 0, 0,
  0, 0, 0, 6, 0, 0, 2, 3, 3, 6, 0, 255, 64, 64, 128, 5,
  12, 12, 6, 0, 254, 24, 32, 32, 32, 32, 112, 32, 32, 32, 32, 32,
  192, 4, 3, 3, 6, 0, 255, 80, 80, 160, 5, 1, 1, 6, 0, 0,
  168, 3, 6, 6, 6, 1, 2, 64, 224, 64, 64, 64, 64, 3, 6, 6,
  6, 1, 2, 64, 224, 64, 64, 224, 64, 3, 2, 2, 6, 1, 7, 64,
  160, 6, 9, 9, 6, 0, 0, 124, 164, 168, 80, 32, 104, 212, 84, 40,
  5, 10, 10, 6, 0, 0, 80, 32, 112, 136, 128, 112, 8, 8, 136, 112,
  2, 4, 4, 6, 0, 0, 64, 128, 128, 64, 5, 8, 8, 6, 0, 0,
  120, 160, 160, 176, 160, 160, 160, 120, 0, 0, 0, 6, 0, 0, 0, 0,
  0, 6, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 6, 0, 0,
  2, 3, 3, 6, 2, 5, 64, 128, 128, 2, 3, 3, 6, 2, 5, 64,
  64, 128, 4, 3, 3, 6, 1, 5, 80, 160, 160, 4, 3, 3, 6, 1,
  5, 80, 80, 160, 5, 5, 5, 6, 0, 2, 112, 248, 248, 248, 112, 3,
  1, 1, 6, 1, 3, 224, 6, 1, 1, 6, 0, 3, 252, 5, 2, 2,
  6, 0, 7, 104, 176, 6, 3, 3, 6, 0, 5, 244, 92, 92, 5, 9,
  9, 6, 0, 0, 80, 32, 0, 0, 120, 128, 112, 8, 240, 2, 4, 4,
  6, 0, 0, 128, 64, 64, 128, 5, 5, 5, 6, 0, 0, 80, 168, 184,
  160, 88, 0, 0, 0, 6, 0, 0, 0, 0, 0, 6, 0, 0, 5, 10,
  10, 6, 0, 0, 80, 0, 0, 136, 136, 136, 80, 32, 32, 32, 0, 0,
  0, 6, 0, 0, 1, 8, 8, 6, 3, 0, 128, 0, 128, 128, 128, 128,
  128, 128, 5, 7, 7, 6, 0, 255, 32, 112, 168, 160, 160, 120, 32, 5,
  9, 9, 6, 0, 0, 96, 144, 128, 224, 128, 128, 128, 136, 240, 5, 5,
  5, 6, 0, 1, 136, 112, 80, 112, 136, 5, 8, 8, 6, 0, 0, 136,
  80, 248, 32, 248, 32, 32, 32, 1, 10, 10, 6, 2, 255, 128, 128, 128,
  128, 0, 0, 128, 128, 128, 128, 5, 11, 11, 6, 0, 255, 112, 136, 72,
  160, 144, 136, 72, 40, 144, 136, 112, 3, 1, 1, 6, 1, 7, 160, 5,
  8, 8, 6, 0, 0, 224, 16, 104, 136, 136, 104, 16, 224, 4, 7, 7,
  6, 1, 3, 112, 144, 144, 112, 0, 0, 240, 5, 4, 4, 6, 0, 0,
  72, 144, 144, 72, 5, 3, 3, 6, 0, 2, 248, 8, 8, 5, 1, 1,
  6, 0, 3, 248, 5, 7, 7, 6, 0, 1, 224, 16, 200, 168, 168, 200,
  176, 3, 1, 1, 6, 1, 7, 224, 4, 4, 4, 6, 1, 5, 96, 144,
  144, 96, 5, 6, 6, 6, 0, 1, 32, 32, 248, 32, 32, 248, 3, 4,
  4, 6, 1, 6, 192, 32, 64, 224, 3, 5, 5, 6, 1, 5, 192, 32,
  96, 32, 192, 4, 2, 2, 6, 2, 7, 112, 224, 5, 7, 7, 6, 0,
  254, 144, 144, 144, 144, 232, 128, 128, 5, 9, 9, 6, 0, 0, 120, 168,
  168, 168, 120, 40, 40, 40, 40, 2, 2, 2, 6, 2, 3, 192, 192, 4,
  3, 3, 6, 1, 254, 240, 112, 224, 3, 4, 4, 6, 1, 6, 192, 64,
  64, 224, 4, 7, 7, 6, 1, 3, 96, 144, 144, 96, 0, 0, 240, 5,
  4, 4, 6, 0, 0, 144, 72, 72, 144, 6, 10, 10, 6, 0, 0, 192,
  64, 68, 232, 16, 32, 72, 152, 56, 8, 6, 10, 10, 6, 0, 0, 192,
  64, 68, 232, 16, 32, 88, 132, 8, 28, 6, 10, 10, 6, 0, 0, 192,
  32, 100, 40, 208, 32, 72, 152, 56, 8, 5, 8, 8, 6, 0, 0, 32,
  0, 32, 64, 128, 128, 136, 112, 5, 10, 10, 6, 0, 0, 64, 32, 32,
  80, 80, 136, 136, 248, 136, 136, 5, 10, 10, 6, 0, 0, 16, 32, 32,
  80, 80, 136, 136, 248, 136, 136, 5, 10, 10, 6, 0, 0, 32, 80, 0,
  32, 80, 80, 136, 248, 136, 136, 5, 10, 10, 6, 0, 0, 104, 176, 32,
  80, 80, 136, 136, 248, 136, 136, 5, 10, 10, 6, 0, 0, 80, 0, 32,
  80, 80, 136, 136, 248, 136, 136, 5, 10, 10, 6, 0, 0, 32, 80, 32,
  80, 80, 136, 136, 248, 136, 136, 5, 8, 8, 6, 0, 0, 120, 160, 160,
  240, 160, 160, 160, 184, 5, 10, 10, 6, 0, 254, 112, 136, 128, 128, 128,
  128, 136, 112, 32, 64, 5, 10, 10, 6, 0, 0, 64, 32, 248, 128, 128,
  240, 128, 128, 128, 248, 5, 10, 10, 6, 0, 0, 16, 32, 248, 128, 128,
  240, 128, 128, 128, 248, 5, 10, 10, 6, 0, 0, 32, 80, 248, 128, 128,
  240, 128, 128, 128, 248, 5, 10, 10, 6, 0, 0, 80, 0, 248, 128, 128,
  240, 128, 128, 128, 248, 5, 10, 10, 6, 0, 0, 64, 32, 248, 32, 32,
  32, 32, 32, 32, 248, 5, 10, 10, 6, 0, 0, 16, 32, 248, 32, 32,
  32, 32, 32, 32, 248, 5, 10, 10, 6, 0, 0, 32, 80, 0, 248, 32,
  32, 32, 32, 32, 248, 5, 10, 10, 6, 0, 0, 80, 0, 248, 32, 32,
  32, 32, 32, 32, 248, 6, 8, 8, 6, 0, 0, 120, 68, 68, 228, 68,
  68, 68, 120, 5, 10, 10, 6, 0, 0, 104, 176, 136, 200, 168, 152, 136,
  136, 136, 136, 5, 10, 10, 6, 0, 0, 64, 32, 112, 136, 136, 136, 136,
  136, 136, 112, 5, 10, 10, 6, 0, 0, 16, 32, 112, 136, 136, 136, 136,
  136, 136, 112, 5, 10, 10, 6, 0, 0, 32, 80, 0, 112, 136, 136, 136,
  136, 136, 112, 5, 10, 10, 6, 0, 0, 104, 176, 112, 136, 136, 136, 136,
  136, 136, 112, 5, 10, 10, 6, 0, 0, 80, 0, 112, 136, 136, 136, 136,
  136, 136, 112, 5, 5, 5, 6, 0, 2, 136, 80, 32, 80, 136, 5, 8,
  8, 6, 0, 0, 112, 136, 152, 168, 200, 136, 136, 112, 5, 10, 10, 6,
  0, 0, 64, 32, 136, 136, 136, 136, 136, 136, 136, 112, 5, 10, 10, 6,
  0, 0, 16, 32, 136, 136, 136, 136, 136, 136, 136, 112, 5, 10, 10, 6,
  0, 0, 32, 80, 0, 136, 136, 136, 136, 136, 136, 112, 5, 10, 10, 6,
  0, 0, 80, 0, 136, 136, 136, 136, 136, 136, 136, 112, 5, 10, 10, 6,
  0, 0, 16, 32, 136, 136, 136, 136, 80, 32, 32, 32, 5, 8, 8, 6,
  0, 0, 128, 240, 136, 136, 136, 240, 128, 128, 5, 10, 10, 6, 0, 255,
  48, 72, 136, 144, 144, 136, 136, 136, 176, 128, 5, 9, 9, 6, 0, 0,
  32, 16, 0, 0, 120, 136, 136, 152, 104, 5, 9, 9, 6, 0, 0, 16,
  32, 0, 0, 120, 136, 136, 152, 104, 5, 9, 9, 6, 0, 0, 32, 80,
  0, 0, 120, 136, 136, 152, 104, 5, 9, 9, 6, 0, 0, 104, 176, 0,
  0, 120, 136, 136, 152, 104, 5, 8, 8, 6, 0, 0, 80, 0, 0, 120,
  136, 136, 152, 104, 5, 9, 9, 6, 0, 0, 32, 80, 32, 0, 120, 136,
  136, 152, 104, 5, 5, 5, 6, 0, 0, 112, 168, 184, 160, 120, 5, 7,
  7, 6, 0, 254, 112, 136, 128, 128, 120, 32, 64, 5, 9, 9, 6, 0,
  0, 64, 32, 0, 0, 112, 136, 248, 128, 120, 5, 9, 9, 6, 0, 0,
  16, 32, 0, 0, 112, 136, 248, 128, 120, 5, 9, 9, 6, 0, 0, 32,
  80, 0, 0, 112, 136, 248, 128, 120, 5, 8, 8, 6, 0, 0, 80, 0,
  0, 112, 136, 248, 128, 120, 3, 9, 9, 6, 1, 0, 128, 64, 0, 0,
  192, 64, 64, 64, 224, 3, 9, 9, 6, 1, 0, 32, 64, 0, 0, 192,
  64, 64, 64, 224, 3, 9, 9, 6, 1, 0, 64, 160, 0, 0, 192, 64,
  64, 64, 224, 3, 8, 8, 6, 1, 0, 160, 0, 0, 192, 64, 64, 64,
  224, 5, 9, 9, 6, 0, 0, 96, 96, 16, 8, 120, 136, 136, 136, 112,
  5, 9, 9, 6, 0, 0, 104, 176, 0, 0, 176, 200, 136, 136, 136, 5,
  9, 9, 6, 0, 0, 64, 32, 0, 0, 112, 136, 136, 136, 112, 5, 9,
  9, 6, 0, 0, 16, 32, 0, 0, 112, 136, 136, 136, 112, 5, 9, 9,
  6, 0, 0, 32, 80, 0, 0, 112, 136, 136, 136, 112, 5, 9, 9, 6,
  0, 0, 104, 176, 0, 0, 112, 136, 136, 136, 112, 5, 8, 8, 6, 0,
  0, 80, 0, 0, 112, 136, 136, 136, 112, 5, 5, 5, 6, 0, 1, 32,
  0, 248, 0, 32, 5, 5, 5, 6, 0, 0, 112, 152, 168, 200, 112, 5,
  9, 9, 6, 0, 0, 64, 32, 0, 0, 136, 136, 136, 152, 104, 5, 9,
  9, 6, 0, 0, 16, 32, 0, 0, 136, 136, 136, 152, 104, 5, 9, 9,
  6, 0, 0, 32, 80, 0, 0, 136, 136, 136, 152, 104, 5, 8, 8, 6,
  0, 0, 80, 0, 0, 136, 136, 136, 152, 104, 5, 11, 11, 6, 0, 254,
  16, 32, 0, 0, 136, 136, 136, 136, 120, 8, 112, 5, 10, 10, 6, 0,
  254, 128, 128, 128, 240, 136, 136, 136, 240, 128, 128, 5, 10, 10, 6, 0,
  254, 80, 0, 0, 136, 136, 136, 136, 120, 8, 112
};

/*
  Fontname: ProFont12
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 8, '1' Height: 8
  Calculated Max Values w= 6 h=11 x= 2 y= 7 dx= 6 dy= 0 ascent= 9 len=11
  Font Bounding box     w= 6 h=11 x= 0 y=-2
  Calculated Min Values           x= 0 y=-2 dx= 0 dy= 0
  Pure Font   ascent = 8 descent=-2
  X Font      ascent = 9 descent=-2
  Max Font    ascent = 9 descent=-2
*/
const u8g_fntpgm_uint8_t u8g_font_profont12r[1258] U8G_FONT_SECTION("u8g_font_profont12r") = {
  0, 6, 11, 0, 254, 8, 1, 178, 3, 103, 32, 127, 254, 9, 254, 9,
  254, 0, 0, 0, 6, 0, 0, 1, 8, 8, 6, 2, 0, 128, 128, 128,
  128, 128, 128, 0, 128, 3, 3, 3, 6, 1, 6, 160, 160, 160, 5, 5,
  5, 6, 0, 3, 80, 248, 80, 248, 80, 5, 10, 10, 6, 0, 255, 32,
  112, 168, 160, 112, 40, 40, 168, 112, 32, 5, 8, 8, 6, 0, 0, 120,
  168, 168, 80, 48, 104, 168, 144, 5, 8, 8, 6, 0, 0, 96, 144, 160,
  64, 160, 168, 144, 104, 1, 3, 3, 6, 2, 6, 128, 128, 128, 3, 10,
  10, 6, 1, 255, 32, 64, 128, 128, 128, 128, 128, 128, 64, 32, 3, 10,
  10, 6, 1, 255, 128, 64, 32, 32, 32, 32, 32, 32, 64, 128, 5, 5,
  5, 6, 0, 3, 32, 168, 112, 168, 32, 5, 5, 5, 6, 0, 1, 32,
  32, 248, 32, 32, 2, 4, 4, 6, 1, 254, 192, 192, 64, 128, 3, 1,
  1, 6, 1, 3, 224, 2, 2, 2, 6, 2, 0, 192, 192, 5, 10, 10,
  6, 0, 254, 8, 8, 16, 16, 32, 32, 64, 64, 128, 128, 5, 8, 8,
  6, 0, 0, 112, 136, 152, 168, 200, 136, 136, 112, 5, 8, 8, 6, 0,
  0, 32, 224, 32, 32, 32, 32, 32, 248, 5, 8, 8, 6, 0, 0, 112,
  136, 8, 16, 32, 64, 128, 248, 5, 8, 8, 6, 0, 0, 112, 136, 8,
  48, 8, 8, 136, 112, 5, 8, 8, 6, 0, 0, 16, 48, 80, 144, 248,
  16, 16, 56, 5, 8, 8, 6, 0, 0, 248, 128, 128, 240, 8, 8, 136,
  112, 5, 8, 8, 6, 0, 0, 112, 128, 128, 240, 136, 136, 136, 112, 5,
  8, 8, 6, 0, 0, 248, 8, 8, 16, 32, 32, 32, 32, 5, 8, 8,
  6, 0, 0, 112, 136, 136, 112, 136, 136, 136, 112, 5, 8, 8, 6, 0,
  0, 112, 136, 136, 136, 120, 8, 8, 112, 2, 6, 6, 6, 2, 0, 192,
  192, 0, 0, 192, 192, 2, 8, 8, 6, 1, 254, 192, 192, 0, 0, 192,
  192, 64, 128, 4, 7, 7, 6, 1, 1, 16, 32, 64, 128, 64, 32, 16,
  5, 3, 3, 6, 0, 3, 248, 0, 248, 4, 7, 7, 6, 1, 1, 128,
  64, 32, 16, 32, 64, 128, 5, 8, 8, 6, 0, 0, 112, 136, 8, 8,
  16, 32, 0, 32, 5, 8, 8, 6, 0, 0, 112, 136, 184, 168, 184, 128,
  128, 120, 5, 8, 8, 6, 0, 0, 32, 80, 80, 136, 136, 248, 136, 136,
  5, 8, 8, 6, 0, 0, 240, 136, 136, 240, 136, 136, 136, 240, 5, 8,
  8, 6, 0, 0, 112, 136, 128, 128, 128, 128, 136, 112, 5, 8, 8, 6,
  0, 0, 240, 136, 136, 136, 136, 136, 136, 240, 5, 8, 8, 6, 0, 0,
  248, 128, 128, 240, 128, 128, 128, 248, 5, 8, 8, 6, 0, 0, 248, 128,
  128, 240, 128, 128, 128, 128, 5, 8, 8, 6, 0, 0, 112, 136, 128, 128,
  152, 136, 136, 112, 5, 8, 8, 6, 0, 0, 136, 136, 136, 248, 136, 136,
  136, 136, 5, 8, 8, 6, 0, 0, 248, 32, 32, 32, 32, 32, 32, 248,
  5, 8, 8, 6, 0, 0, 8, 8, 8, 8, 8, 136, 136, 112, 5, 8,
  8, 6, 0, 0, 136, 144, 160, 192, 192, 160, 144, 136, 5, 8, 8, 6,
  0, 0, 128, 128, 128, 128, 128, 128, 128, 248, 5, 8, 8, 6, 0, 0,
  136, 216, 168, 168, 136, 136, 136, 136, 5, 8, 8, 6, 0, 0, 136, 200,
  168, 152, 136, 136, 136, 136, 5, 8, 8, 6, 0, 0, 112, 136, 136, 136,
  136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 240, 136, 136, 240, 128, 128,
  128, 128, 5, 9, 9, 6, 0, 255, 112, 136, 136, 136, 136, 136, 168, 112,
  8, 5, 8, 8, 6, 0, 0, 240, 136, 136, 240, 136, 136, 136, 136, 5,
  8, 8, 6, 0, 0, 112, 136, 128, 112, 8, 8, 136, 112, 5, 8, 8,
  6, 0, 0, 248, 32, 32, 32, 32, 32, 32, 32, 5, 8, 8, 6, 0,
  0, 136, 136, 136, 136, 136, 136, 136, 112, 5, 8, 8, 6, 0, 0, 136,
  136, 136, 136, 80, 80, 32, 32, 5, 8, 8, 6, 0, 0, 136, 136, 136,
  136, 168, 168, 216, 136, 5, 8, 8, 6, 0, 0, 136, 136, 136, 80, 32,
  80, 136, 136, 5, 8, 8, 6, 0, 0, 136, 136, 136, 136, 80, 32, 32,
  32, 5, 8, 8, 6, 0, 0, 248, 8, 16, 32, 64, 128, 128, 248, 2,
  10, 10, 6, 2, 255, 192, 128, 128, 128, 128, 128, 128, 128, 128, 192, 5,
  10, 10, 6, 1, 254, 128, 128, 64, 64, 32, 32, 16, 16, 8, 8, 2,
  10, 10, 6, 1, 255, 192, 64, 64, 64, 64, 64, 64, 64, 64, 192, 5,
  3, 3, 6, 0, 5, 32, 80, 136, 6, 1, 1, 6, 0, 254, 252, 2,
  2, 2, 6, 1, 7, 128, 64, 5, 5, 5, 6, 0, 0, 120, 136, 136,
  152, 104, 5, 8, 8, 6, 0, 0, 128, 128, 128, 240, 136, 136, 136, 240,
  5, 5, 5, 6, 0, 0, 112, 136, 128, 128, 120, 5, 8, 8, 6, 0,
  0, 8, 8, 8, 120, 136, 136, 136, 120, 5, 5, 5, 6, 0, 0, 112,
  136, 248, 128, 120, 4, 8, 8, 6, 1, 0, 48, 64, 224, 64, 64, 64,
  64, 64, 5, 7, 7, 6, 0, 254, 120, 136, 136, 136, 120, 8, 112, 5,
  8, 8, 6, 0, 0, 128, 128, 128, 240, 136, 136, 136, 136, 3, 8, 8,
  6, 1, 0, 64, 0, 0, 192, 64, 64, 64, 224, 3, 10, 10, 6, 0,
  254, 32, 0, 0, 96, 32, 32, 32, 32, 32, 192, 5, 8, 8, 6, 0,
  0, 128, 128, 128, 144, 160, 224, 144, 136, 3, 8, 8, 6, 1, 0, 192,
  64, 64, 64, 64, 64, 64, 224, 5, 5, 5, 6, 0, 0, 240, 168, 168,
  168, 168, 5, 5, 5, 6, 0, 0, 176, 200, 136, 136, 136, 5, 5, 5,
  6, 0, 0, 112, 136, 136, 136, 112, 5, 7, 7, 6, 0, 254, 240, 136,
  136, 136, 240, 128, 128, 5, 7, 7, 6, 0, 254, 120, 136, 136, 136, 120,
  8, 8, 5, 5, 5, 6, 0, 0, 176, 200, 128, 128, 128, 5, 5, 5,
  6, 0, 0, 120, 128, 112, 8, 240, 4, 8, 8, 6, 1, 0, 64, 64,
  64, 224, 64, 64, 64, 48, 5, 5, 5, 6, 0, 0, 136, 136, 136, 152,
  104, 5, 5, 5, 6, 0, 0, 136, 136, 80, 80, 32, 5, 5, 5, 6,
  0, 0, 168, 168, 168, 168, 80, 5, 5, 5, 6, 0, 0, 136, 80, 32,
  80, 136, 5, 7, 7, 6, 0, 254, 136, 136, 136, 136, 120, 8, 112, 5,
  5, 5, 6, 0, 0, 248, 16, 32, 64, 248, 3, 11, 11, 6, 1, 254,
  32, 64, 64, 64, 64, 128, 64, 64, 64, 64, 32, 1, 10, 10, 6, 2,
  255, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 3, 11, 11, 6, 1,
  254, 128, 64, 64, 64, 64, 32, 64, 64, 64, 64, 128, 5, 2, 2, 6,
  0, 4, 104, 176, 0, 0, 0, 6, 0, 0
};

/*
  Fontname: ProFont15
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 7 h=15 x= 4 y= 8 dx= 7 dy= 0 ascent=12 len=15
  Font Bounding box     w= 7 h=14 x= 0 y=-3
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =12 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_profont15[3186] U8G_FONT_SECTION("u8g_font_profont15") = {
  0, 7, 14, 0, 253, 9, 1, 217, 3, 175, 32, 255, 253, 12, 253, 11,
  253, 0, 0, 0, 7, 0, 0, 1, 9, 9, 7, 3, 0, 128, 128, 128,
  128, 128, 128, 128, 0, 128, 4, 4, 4, 7, 1, 7, 144, 144, 144, 144,
  6, 6, 6, 7, 0, 3, 72, 252, 72, 72, 252, 72, 5, 13, 13, 7,
  0, 254, 32, 32, 112, 168, 160, 160, 112, 40, 40, 168, 112, 32, 32, 7,
  9, 9, 7, 0, 0, 126, 162, 164, 168, 84, 42, 74, 138, 132, 6, 9,
  9, 7, 0, 0, 112, 136, 144, 160, 64, 160, 148, 136, 116, 1, 4, 4,
  7, 3, 7, 128, 128, 128, 128, 4, 13, 13, 7, 1, 254, 16, 32, 64,
  128, 128, 128, 128, 128, 128, 128, 64, 32, 16, 4, 13, 13, 7, 1, 254,
  128, 64, 32, 16, 16, 16, 16, 16, 16, 16, 32, 64, 128, 5, 6, 6,
  7, 0, 3, 32, 168, 112, 112, 168, 32, 5, 5, 5, 7, 0, 1, 32,
  32, 248, 32, 32, 3, 5, 5, 7, 1, 253, 96, 96, 32, 64, 128, 4,
  1, 1, 7, 1, 3, 240, 2, 2, 2, 7, 2, 0, 192, 192, 6, 12,
  12, 7, 0, 254, 4, 4, 8, 8, 16, 16, 32, 32, 64, 64, 128, 128,
  6, 9, 9, 7, 0, 0, 120, 132, 140, 148, 164, 196, 132, 132, 120, 7,
  9, 9, 7, 0, 0, 16, 112, 16, 16, 16, 16, 16, 16, 254, 6, 9,
  9, 7, 0, 0, 120, 132, 4, 4, 8, 16, 32, 64, 252, 6, 9, 9,
  7, 0, 0, 120, 132, 4, 4, 56, 4, 4, 132, 120, 6, 9, 9, 7,
  0, 0, 8, 24, 40, 72, 136, 252, 8, 8, 28, 6, 9, 9, 7, 0,
  0, 252, 128, 128, 248, 4, 4, 4, 132, 120, 6, 9, 9, 7, 0, 0,
  120, 128, 128, 248, 132, 132, 132, 132, 120, 6, 9, 9, 7, 0, 0, 252,
  4, 4, 8, 16, 32, 32, 32, 32, 6, 9, 9, 7, 0, 0, 120, 132,
  132, 132, 120, 132, 132, 132, 120, 6, 9, 9, 7, 0, 0, 120, 132, 132,
  132, 132, 124, 4, 4, 120, 2, 7, 7, 7, 2, 0, 192, 192, 0, 0,
  0, 192, 192, 3, 10, 10, 7, 1, 253, 96, 96, 0, 0, 0, 96, 96,
  32, 64, 128, 5, 9, 9, 7, 1, 0, 8, 16, 32, 64, 128, 64, 32,
  16, 8, 6, 4, 4, 7, 0, 3, 252, 0, 0, 252, 5, 9, 9, 7,
  1, 0, 128, 64, 32, 16, 8, 16, 32, 64, 128, 6, 9, 9, 7, 0,
  0, 120, 132, 4, 4, 8, 16, 32, 0, 32, 6, 9, 9, 7, 0, 0,
  120, 132, 156, 164, 164, 152, 128, 128, 124, 6, 9, 9, 7, 0, 0, 48,
  48, 72, 72, 132, 252, 132, 132, 132, 6, 9, 9, 7, 0, 0, 248, 132,
  132, 132, 248, 132, 132, 132, 248, 6, 9, 9, 7, 0, 0, 120, 132, 128,
  128, 128, 128, 128, 132, 120, 6, 9, 9, 7, 0, 0, 248, 132, 132, 132,
  132, 132, 132, 132, 248, 6, 9, 9, 7, 0, 0, 252, 128, 128, 128, 248,
  128, 128, 128, 252, 6, 9, 9, 7, 0, 0, 252, 128, 128, 128, 248, 128,
  128, 128, 128, 6, 9, 9, 7, 0, 0, 120, 132, 128, 128, 140, 132, 132,
  132, 120, 6, 9, 9, 7, 0, 0, 132, 132, 132, 132, 252, 132, 132, 132,
  132, 7, 9, 9, 7, 0, 0, 254, 16, 16, 16, 16, 16, 16, 16, 254,
  6, 9, 9, 7, 0, 0, 4, 4, 4, 4, 4, 132, 132, 132, 120, 6,
  9, 9, 7, 0, 0, 132, 136, 144, 160, 192, 160, 144, 136, 132, 6, 9,
  9, 7, 0, 0, 128, 128, 128, 128, 128, 128, 128, 128, 252, 7, 9, 9,
  7, 0, 0, 130, 198, 170, 146, 146, 130, 130, 130, 130, 6, 9, 9, 7,
  0, 0, 132, 196, 164, 148, 140, 132, 132, 132, 132, 6, 9, 9, 7, 0,
  0, 120, 132, 132, 132, 132, 132, 132, 132, 120, 6, 9, 9, 7, 0, 0,
  248, 132, 132, 132, 248, 128, 128, 128, 128, 6, 10, 10, 7, 0, 255, 120,
  132, 132, 132, 132, 132, 164, 148, 120, 4, 6, 9, 9, 7, 0, 0, 248,
  132, 132, 132, 248, 132, 132, 132, 132, 6, 9, 9, 7, 0, 0, 120, 132,
  128, 128, 120, 4, 4, 132, 120, 7, 9, 9, 7, 0, 0, 254, 16, 16,
  16, 16, 16, 16, 16, 16, 6, 9, 9, 7, 0, 0, 132, 132, 132, 132,
  132, 132, 132, 132, 120, 7, 9, 9, 7, 0, 0, 130, 130, 130, 68, 68,
  40, 40, 16, 16, 7, 9, 9, 7, 0, 0, 130, 130, 130, 130, 146, 146,
  170, 198, 130, 6, 9, 9, 7, 0, 0, 132, 132, 132, 72, 48, 48, 72,
  132, 132, 7, 9, 9, 7, 0, 0, 130, 130, 130, 68, 40, 16, 16, 16,
  16, 6, 9, 9, 7, 0, 0, 252, 4, 8, 16, 32, 64, 128, 128, 252,
  3, 12, 12, 7, 2, 255, 224, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 224, 6, 12, 12, 7, 1, 254, 128, 128, 64, 64, 32, 32, 16, 16,
  8, 8, 4, 4, 3, 12, 12, 7, 1, 255, 224, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 224, 5, 3, 3, 7, 1, 6, 32, 80, 136, 7,
  1, 1, 7, 0, 254, 254, 3, 3, 3, 7, 1, 8, 128, 64, 32, 6,
  6, 6, 7, 0, 0, 124, 132, 132, 140, 148, 100, 6, 9, 9, 7, 0,
  0, 128, 128, 128, 248, 132, 132, 132, 132, 248, 6, 6, 6, 7, 0, 0,
  120, 132, 128, 128, 128, 124, 6, 9, 9, 7, 0, 0, 4, 4, 4, 124,
  132, 132, 132, 132, 124, 6, 6, 6, 7, 0, 0, 120, 132, 252, 128, 128,
  124, 4, 9, 9, 7, 1, 0, 48, 64, 64, 224, 64, 64, 64, 64, 64,
  6, 9, 9, 7, 0, 253, 124, 132, 132, 132, 132, 124, 4, 4, 120, 6,
  9, 9, 7, 0, 0, 128, 128, 128, 248, 132, 132, 132, 132, 132, 3, 9,
  9, 7, 2, 0, 64, 0, 0, 192, 64, 64, 64, 64, 224, 3, 12, 12,
  7, 1, 253, 32, 0, 0, 96, 32, 32, 32, 32, 32, 32, 32, 192, 6,
  9, 9, 7, 0, 0, 128, 128, 128, 136, 144, 160, 208, 136, 132, 3, 9,
  9, 7, 2, 0, 192, 64, 64, 64, 64, 64, 64, 64, 224, 7, 6, 6,
  7, 0, 0, 252, 146, 146, 146, 146, 146, 6, 6, 6, 7, 0, 0, 152,
  164, 196, 132, 132, 132, 6, 6, 6, 7, 0, 0, 120, 132, 132, 132, 132,
  120, 6, 9, 9, 7, 0, 253, 248, 132, 132, 132, 132, 248, 128, 128, 128,
  6, 9, 9, 7, 0, 253, 124, 132, 132, 132, 132, 124, 4, 4, 4, 6,
  6, 6, 7, 0, 0, 152, 164, 192, 128, 128, 128, 6, 6, 6, 7, 0,
  0, 124, 128, 120, 4, 4, 248, 4, 9, 9, 7, 1, 0, 64, 64, 64,
  224, 64, 64, 64, 64, 48, 6, 6, 6, 7, 0, 0, 132, 132, 132, 140,
  148, 100, 6, 6, 6, 7, 0, 0, 132, 132, 72, 72, 48, 48, 7, 6,
  6, 7, 0, 0, 146, 146, 146, 146, 146, 108, 6, 6, 6, 7, 0, 0,
  132, 72, 48, 48, 72, 132, 6, 9, 9, 7, 0, 253, 132, 132, 132, 132,
  132, 124, 4, 4, 120, 6, 6, 6, 7, 0, 0, 252, 8, 16, 32, 64,
  252, 4, 15, 15, 7, 1, 253, 48, 64, 64, 64, 64, 64, 64, 128, 64,
  64, 64, 64, 64, 64, 48, 1, 13, 13, 7, 3, 254, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 4, 15, 15, 7, 1, 253, 192,
  32, 32, 32, 32, 32, 32, 16, 32, 32, 32, 32, 32, 32, 192, 6, 2,
  2, 7, 0, 4, 100, 152, 0, 0, 0, 7, 0, 0, 0, 0, 0, 7,
  0, 0, 0, 0, 0, 7, 0, 0, 2, 4, 4, 7, 0, 255, 64, 64,
  64, 128, 7, 14, 14, 7, 0, 254, 6, 8, 16, 16, 16, 56, 16, 16,
  16, 16, 16, 16, 32, 192, 5, 4, 4, 7, 0, 255, 72, 72, 72, 144,
  7, 1, 1, 7, 0, 0, 146, 3, 6, 6, 7, 2, 3, 64, 224, 64,
  64, 64, 64, 3, 6, 6, 7, 2, 3, 64, 224, 64, 64, 224, 64, 5,
  3, 3, 7, 1, 8, 32, 80, 136, 7, 10, 10, 7, 0, 0, 126, 164,
  168, 176, 96, 84, 170, 42, 42, 20, 6, 12, 12, 7, 0, 0, 68, 40,
  16, 120, 132, 128, 128, 120, 4, 4, 132, 120, 2, 5, 5, 7, 0, 0,
  64, 128, 128, 128, 64, 6, 9, 9, 7, 0, 0, 124, 144, 144, 144, 152,
  144, 144, 144, 124, 0, 0, 0, 7, 0, 0, 0, 0, 0, 7, 0, 0,
  0, 0, 0, 7, 0, 0, 0, 0, 0, 7, 0, 0, 2, 4, 4, 7,
  3, 5, 64, 128, 128, 128, 2, 4, 4, 7, 3, 5, 64, 64, 64, 128,
  5, 4, 4, 7, 1, 5, 72, 144, 144, 144, 5, 4, 4, 7, 1, 5,
  72, 72, 72, 144, 6, 6, 6, 7, 0, 2, 48, 120, 252, 252, 120, 48,
  4, 1, 1, 7, 1, 3, 240, 7, 1, 1, 7, 0, 3, 254, 6, 2,
  2, 7, 0, 8, 100, 152, 7, 4, 4, 7, 0, 5, 242, 94, 82, 82,
  6, 11, 11, 7, 0, 0, 68, 40, 16, 0, 0, 124, 128, 120, 4, 4,
  248, 2, 5, 5, 7, 0, 0, 128, 64, 64, 64, 128, 6, 6, 6, 7,
  0, 0, 104, 148, 156, 144, 144, 108, 0, 0, 0, 7, 0, 0, 0, 0,
  0, 7, 0, 0, 7, 12, 12, 7, 0, 0, 68, 0, 0, 130, 130, 130,
  68, 40, 16, 16, 16, 16, 0, 0, 0, 7, 0, 0, 1, 9, 9, 7,
  4, 0, 128, 0, 128, 128, 128, 128, 128, 128, 128, 5, 10, 10, 7, 0,
  254, 32, 32, 112, 168, 160, 160, 160, 120, 32, 32, 6, 11, 11, 7, 0,
  0, 96, 144, 128, 128, 240, 128, 128, 128, 132, 136, 240, 7, 7, 7, 7,
  0, 0, 130, 68, 56, 40, 56, 68, 130, 7, 10, 10, 7, 0, 0, 130,
  68, 40, 254, 16, 16, 254, 16, 16, 16, 1, 13, 13, 7, 3, 254, 128,
  128, 128, 128, 128, 0, 0, 0, 128, 128, 128, 128, 128, 6, 13, 13, 7,
  0, 255, 120, 132, 132, 68, 160, 144, 72, 36, 20, 136, 132, 132, 120, 4,
  1, 1, 7, 1, 8, 144, 6, 9, 9, 7, 0, 0, 240, 8, 116, 132,
  132, 132, 116, 8, 240, 5, 8, 8, 7, 1, 4, 120, 136, 136, 136, 120,
  0, 0, 248, 6, 5, 5, 7, 0, 0, 68, 136, 136, 136, 68, 6, 4,
  4, 7, 0, 1, 252, 4, 4, 4, 5, 1, 1, 7, 0, 3, 248, 6,
  8, 8, 7, 0, 1, 240, 8, 100, 148, 148, 228, 148, 136, 4, 1, 1,
  7, 1, 8, 240, 5, 5, 5, 7, 1, 6, 112, 136, 136, 136, 112, 5,
  6, 6, 7, 0, 1, 32, 32, 248, 32, 32, 248, 4, 5, 5, 7, 1,
  7, 96, 144, 32, 64, 240, 4, 5, 5, 7, 1, 7, 96, 144, 32, 144,
  96, 3, 3, 3, 7, 3, 8, 96, 224, 192, 6, 9, 9, 7, 0, 253,
  136, 136, 136, 136, 136, 244, 128, 128, 128, 6, 10, 10, 7, 0, 0, 60,
  84, 148, 148, 84, 60, 20, 20, 20, 20, 2, 2, 2, 7, 3, 3, 192,
  192, 2, 3, 3, 7, 2, 254, 192, 64, 128, 3, 5, 5, 7, 2, 7,
  192, 64, 64, 64, 224, 5, 8, 8, 7, 1, 4, 112, 136, 136, 136, 112,
  0, 0, 248, 6, 5, 5, 7, 0, 0, 136, 68, 68, 68, 136, 7, 12,
  12, 7, 0, 0, 96, 32, 32, 34, 116, 8, 16, 36, 76, 148, 30, 4,
  7, 12, 12, 7, 0, 0, 96, 32, 32, 34, 116, 8, 16, 44, 82, 132,
  8, 30, 7, 12, 12, 7, 0, 0, 96, 144, 32, 146, 100, 8, 16, 36,
  76, 148, 30, 4, 6, 9, 9, 7, 0, 0, 16, 0, 16, 32, 64, 128,
  128, 132, 120, 6, 12, 12, 7, 0, 0, 64, 32, 16, 48, 48, 72, 72,
  132, 252, 132, 132, 132, 6, 12, 12, 7, 0, 0, 8, 16, 32, 48, 48,
  72, 72, 132, 252, 132, 132, 132, 6, 12, 12, 7, 0, 0, 16, 40, 68,
  48, 48, 72, 72, 132, 252, 132, 132, 132, 6, 12, 12, 7, 0, 0, 100,
  152, 0, 48, 48, 72, 72, 132, 252, 132, 132, 132, 6, 12, 12, 7, 0,
  0, 72, 0, 0, 48, 48, 72, 72, 132, 252, 132, 132, 132, 6, 12, 12,
  7, 0, 0, 48, 72, 72, 48, 48, 72, 72, 132, 252, 132, 132, 132, 6,
  9, 9, 7, 0, 0, 124, 144, 144, 144, 248, 144, 144, 144, 156, 6, 11,
  11, 7, 0, 254, 120, 132, 128, 128, 128, 128, 128, 132, 120, 16, 32, 6,
  12, 12, 7, 0, 0, 64, 32, 16, 252, 128, 128, 128, 248, 128, 128, 128,
  252, 6, 12, 12, 7, 0, 0, 8, 16, 32, 252, 128, 128, 128, 248, 128,
  128, 128, 252, 6, 12, 12, 7, 0, 0, 16, 40, 68, 252, 128, 128, 128,
  248, 128, 128, 128, 252, 6, 12, 12, 7, 0, 0, 72, 0, 0, 252, 128,
  128, 128, 248, 128, 128, 128, 252, 7, 12, 12, 7, 0, 0, 64, 32, 16,
  254, 16, 16, 16, 16, 16, 16, 16, 254, 7, 12, 12, 7, 0, 0, 4,
  8, 16, 254, 16, 16, 16, 16, 16, 16, 16, 254, 7, 12, 12, 7, 0,
  0, 16, 40, 68, 254, 16, 16, 16, 16, 16, 16, 16, 254, 7, 12, 12,
  7, 0, 0, 72, 0, 0, 254, 16, 16, 16, 16, 16, 16, 16, 254, 6,
  9, 9, 7, 0, 0, 120, 68, 68, 68, 228, 68, 68, 68, 120, 6, 12,
  12, 7, 0, 0, 100, 152, 0, 132, 196, 164, 148, 140, 132, 132, 132, 132,
  6, 12, 12, 7, 0, 0, 64, 32, 16, 120, 132, 132, 132, 132, 132, 132,
  132, 120, 6, 12, 12, 7, 0, 0, 8, 16, 32, 120, 132, 132, 132, 132,
  132, 132, 132, 120, 6, 12, 12, 7, 0, 0, 16, 40, 68, 120, 132, 132,
  132, 132, 132, 132, 132, 120, 6, 12, 12, 7, 0, 0, 100, 152, 0, 120,
  132, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 7, 0, 0, 72, 0,
  0, 120, 132, 132, 132, 132, 132, 132, 132, 120, 5, 5, 5, 7, 0, 2,
  136, 80, 32, 80, 136, 6, 9, 9, 7, 0, 0, 120, 132, 140, 148, 164,
  196, 132, 132, 120, 6, 12, 12, 7, 0, 0, 64, 32, 16, 132, 132, 132,
  132, 132, 132, 132, 132, 120, 6, 12, 12, 7, 0, 0, 8, 16, 32, 132,
  132, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 7, 0, 0, 16, 40,
  68, 0, 132, 132, 132, 132, 132, 132, 132, 120, 6, 12, 12, 7, 0, 0,
  72, 0, 0, 132, 132, 132, 132, 132, 132, 132, 132, 120, 7, 12, 12, 7,
  0, 0, 4, 8, 16, 130, 130, 130, 68, 40, 16, 16, 16, 16, 6, 9,
  9, 7, 0, 0, 128, 248, 132, 132, 132, 248, 128, 128, 128, 6, 11, 11,
  7, 0, 255, 56, 68, 132, 136, 144, 144, 136, 132, 132, 152, 128, 6, 11,
  11, 7, 0, 0, 64, 32, 16, 0, 0, 124, 132, 132, 140, 148, 100, 6,
  11, 11, 7, 0, 0, 4, 8, 16, 0, 0, 124, 132, 132, 140, 148, 100,
  6, 11, 11, 7, 0, 0, 16, 40, 68, 0, 0, 124, 132, 132, 140, 148,
  100, 6, 10, 10, 7, 0, 0, 100, 152, 0, 0, 124, 132, 132, 140, 148,
  100, 6, 9, 9, 7, 0, 0, 72, 0, 0, 124, 132, 132, 140, 148, 100,
  6, 10, 10, 7, 0, 0, 48, 72, 72, 48, 124, 132, 132, 140, 148, 100,
  6, 6, 6, 7, 0, 0, 120, 164, 188, 160, 160, 124, 6, 8, 8, 7,
  0, 254, 120, 132, 128, 128, 128, 124, 16, 32, 6, 11, 11, 7, 0, 0,
  64, 32, 16, 0, 0, 120, 132, 252, 128, 128, 124, 6, 11, 11, 7, 0,
  0, 4, 8, 16, 0, 0, 120, 132, 252, 128, 128, 124, 6, 11, 11, 7,
  0, 0, 16, 40, 68, 0, 0, 120, 132, 252, 128, 128, 124, 6, 9, 9,
  7, 0, 0, 72, 0, 0, 120, 132, 252, 128, 128, 124, 4, 11, 11, 7,
  1, 0, 128, 64, 32, 0, 0, 96, 32, 32, 32, 32, 112, 4, 11, 11,
  7, 2, 0, 16, 32, 64, 0, 0, 192, 64, 64, 64, 64, 224, 5, 11,
  11, 7, 1, 0, 32, 80, 136, 0, 0, 96, 32, 32, 32, 32, 112, 4,
  9, 9, 7, 1, 0, 144, 0, 0, 96, 32, 32, 32, 32, 112, 6, 11,
  11, 7, 0, 0, 80, 32, 80, 8, 4, 124, 132, 132, 132, 132, 120, 6,
  10, 10, 7, 0, 0, 100, 152, 0, 0, 152, 164, 196, 132, 132, 132, 6,
  11, 11, 7, 0, 0, 64, 32, 16, 0, 0, 120, 132, 132, 132, 132, 120,
  6, 11, 11, 7, 0, 0, 4, 8, 16, 0, 0, 120, 132, 132, 132, 132,
  120, 6, 11, 11, 7, 0, 0, 16, 40, 68, 0, 0, 120, 132, 132, 132,
  132, 120, 6, 10, 10, 7, 0, 0, 100, 152, 0, 0, 120, 132, 132, 132,
  132, 120, 6, 9, 9, 7, 0, 0, 72, 0, 0, 120, 132, 132, 132, 132,
  120, 5, 5, 5, 7, 0, 1, 32, 0, 248, 0, 32, 6, 6, 6, 7,
  0, 0, 120, 140, 148, 164, 196, 120, 6, 11, 11, 7, 0, 0, 64, 32,
  16, 0, 0, 132, 132, 132, 140, 148, 100, 6, 11, 11, 7, 0, 0, 4,
  8, 16, 0, 0, 132, 132, 132, 140, 148, 100, 6, 11, 11, 7, 0, 0,
  16, 40, 68, 0, 0, 132, 132, 132, 140, 148, 100, 6, 9, 9, 7, 0,
  0, 72, 0, 0, 132, 132, 132, 140, 148, 100, 6, 14, 14, 7, 0, 253,
  4, 8, 16, 0, 0, 132, 132, 132, 132, 132, 124, 4, 4, 120, 6, 12,
  12, 7, 0, 253, 128, 128, 128, 248, 132, 132, 132, 132, 248, 128, 128, 128,
  6, 12, 12, 7, 0, 253, 72, 0, 0, 132, 132, 132, 132, 132, 124, 4,
  4, 120
};

/*
  Fontname: ProFont15
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 9, '1' Height: 9
  Calculated Max Values w= 7 h=15 x= 3 y= 8 dx= 7 dy= 0 ascent=12 len=15
  Font Bounding box     w= 7 h=14 x= 0 y=-3
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent = 9 descent=-3
  X Font      ascent =11 descent=-3
  Max Font    ascent =12 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_profont15r[1372] U8G_FONT_SECTION("u8g_font_profont15r") = {
  0, 7, 14, 0, 253, 9, 1, 217, 3, 175, 32, 127, 253, 12, 253, 11,
  253, 0, 0, 0, 7, 0, 0, 1, 9, 9, 7, 3, 0, 128, 128, 128,
  128, 128, 128, 128, 0, 128, 4, 4, 4, 7, 1, 7, 144, 144, 144, 144,
  6, 6, 6, 7, 0, 3, 72, 252, 72, 72, 252, 72, 5, 13, 13, 7,
  0, 254, 32, 32, 112, 168, 160, 160, 112, 40, 40, 168, 112, 32, 32, 7,
  9, 9, 7, 0, 0, 126, 162, 164, 168, 84, 42, 74, 138, 132, 6, 9,
  9, 7, 0, 0, 112, 136, 144, 160, 64, 160, 148, 136, 116, 1, 4, 4,
  7, 3, 7, 128, 128, 128, 128, 4, 13, 13, 7, 1, 254, 16, 32, 64,
  128, 128, 128, 128, 128, 128, 128, 64, 32, 16, 4, 13, 13, 7, 1, 254,
  128, 64, 32, 16, 16, 16, 16, 16, 16, 16, 32, 64, 128, 5, 6, 6,
  7, 0, 3, 32, 168, 112, 112, 168, 32, 5, 5, 5, 7, 0, 1, 32,
  32, 248, 32, 32, 3, 5, 5, 7, 1, 253, 96, 96, 32, 64, 128, 4,
  1, 1, 7, 1, 3, 240, 2, 2, 2, 7, 2, 0, 192, 192, 6, 12,
  12, 7, 0, 254, 4, 4, 8, 8, 16, 16, 32, 32, 64, 64, 128, 128,
  6, 9, 9, 7, 0, 0, 120, 132, 140, 148, 164, 196, 132, 132, 120, 7,
  9, 9, 7, 0, 0, 16, 112, 16, 16, 16, 16, 16, 16, 254, 6, 9,
  9, 7, 0, 0, 120, 132, 4, 4, 8, 16, 32, 64, 252, 6, 9, 9,
  7, 0, 0, 120, 132, 4, 4, 56, 4, 4, 132, 120, 6, 9, 9, 7,
  0, 0, 8, 24, 40, 72, 136, 252, 8, 8, 28, 6, 9, 9, 7, 0,
  0, 252, 128, 128, 248, 4, 4, 4, 132, 120, 6, 9, 9, 7, 0, 0,
  120, 128, 128, 248, 132, 132, 132, 132, 120, 6, 9, 9, 7, 0, 0, 252,
  4, 4, 8, 16, 32, 32, 32, 32, 6, 9, 9, 7, 0, 0, 120, 132,
  132, 132, 120, 132, 132, 132, 120, 6, 9, 9, 7, 0, 0, 120, 132, 132,
  132, 132, 124, 4, 4, 120, 2, 7, 7, 7, 2, 0, 192, 192, 0, 0,
  0, 192, 192, 3, 10, 10, 7, 1, 253, 96, 96, 0, 0, 0, 96, 96,
  32, 64, 128, 5, 9, 9, 7, 1, 0, 8, 16, 32, 64, 128, 64, 32,
  16, 8, 6, 4, 4, 7, 0, 3, 252, 0, 0, 252, 5, 9, 9, 7,
  1, 0, 128, 64, 32, 16, 8, 16, 32, 64, 128, 6, 9, 9, 7, 0,
  0, 120, 132, 4, 4, 8, 16, 32, 0, 32, 6, 9, 9, 7, 0, 0,
  120, 132, 156, 164, 164, 152, 128, 128, 124, 6, 9, 9, 7, 0, 0, 48,
  48, 72, 72, 132, 252, 132, 132, 132, 6, 9, 9, 7, 0, 0, 248, 132,
  132, 132, 248, 132, 132, 132, 248, 6, 9, 9, 7, 0, 0, 120, 132, 128,
  128, 128, 128, 128, 132, 120, 6, 9, 9, 7, 0, 0, 248, 132, 132, 132,
  132, 132, 132, 132, 248, 6, 9, 9, 7, 0, 0, 252, 128, 128, 128, 248,
  128, 128, 128, 252, 6, 9, 9, 7, 0, 0, 252, 128, 128, 128, 248, 128,
  128, 128, 128, 6, 9, 9, 7, 0, 0, 120, 132, 128, 128, 140, 132, 132,
  132, 120, 6, 9, 9, 7, 0, 0, 132, 132, 132, 132, 252, 132, 132, 132,
  132, 7, 9, 9, 7, 0, 0, 254, 16, 16, 16, 16, 16, 16, 16, 254,
  6, 9, 9, 7, 0, 0, 4, 4, 4, 4, 4, 132, 132, 132, 120, 6,
  9, 9, 7, 0, 0, 132, 136, 144, 160, 192, 160, 144, 136, 132, 6, 9,
  9, 7, 0, 0, 128, 128, 128, 128, 128, 128, 128, 128, 252, 7, 9, 9,
  7, 0, 0, 130, 198, 170, 146, 146, 130, 130, 130, 130, 6, 9, 9, 7,
  0, 0, 132, 196, 164, 148, 140, 132, 132, 132, 132, 6, 9, 9, 7, 0,
  0, 120, 132, 132, 132, 132, 132, 132, 132, 120, 6, 9, 9, 7, 0, 0,
  248, 132, 132, 132, 248, 128, 128, 128, 128, 6, 10, 10, 7, 0, 255, 120,
  132, 132, 132, 132, 132, 164, 148, 120, 4, 6, 9, 9, 7, 0, 0, 248,
  132, 132, 132, 248, 132, 132, 132, 132, 6, 9, 9, 7, 0, 0, 120, 132,
  128, 128, 120, 4, 4, 132, 120, 7, 9, 9, 7, 0, 0, 254, 16, 16,
  16, 16, 16, 16, 16, 16, 6, 9, 9, 7, 0, 0, 132, 132, 132, 132,
  132, 132, 132, 132, 120, 7, 9, 9, 7, 0, 0, 130, 130, 130, 68, 68,
  40, 40, 16, 16, 7, 9, 9, 7, 0, 0, 130, 130, 130, 130, 146, 146,
  170, 198, 130, 6, 9, 9, 7, 0, 0, 132, 132, 132, 72, 48, 48, 72,
  132, 132, 7, 9, 9, 7, 0, 0, 130, 130, 130, 68, 40, 16, 16, 16,
  16, 6, 9, 9, 7, 0, 0, 252, 4, 8, 16, 32, 64, 128, 128, 252,
  3, 12, 12, 7, 2, 255, 224, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 224, 6, 12, 12, 7, 1, 254, 128, 128, 64, 64, 32, 32, 16, 16,
  8, 8, 4, 4, 3, 12, 12, 7, 1, 255, 224, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 224, 5, 3, 3, 7, 1, 6, 32, 80, 136, 7,
  1, 1, 7, 0, 254, 254, 3, 3, 3, 7, 1, 8, 128, 64, 32, 6,
  6, 6, 7, 0, 0, 124, 132, 132, 140, 148, 100, 6, 9, 9, 7, 0,
  0, 128, 128, 128, 248, 132, 132, 132, 132, 248, 6, 6, 6, 7, 0, 0,
  120, 132, 128, 128, 128, 124, 6, 9, 9, 7, 0, 0, 4, 4, 4, 124,
  132, 132, 132, 132, 124, 6, 6, 6, 7, 0, 0, 120, 132, 252, 128, 128,
  124, 4, 9, 9, 7, 1, 0, 48, 64, 64, 224, 64, 64, 64, 64, 64,
  6, 9, 9, 7, 0, 253, 124, 132, 132, 132, 132, 124, 4, 4, 120, 6,
  9, 9, 7, 0, 0, 128, 128, 128, 248, 132, 132, 132, 132, 132, 3, 9,
  9, 7, 2, 0, 64, 0, 0, 192, 64, 64, 64, 64, 224, 3, 12, 12,
  7, 1, 253, 32, 0, 0, 96, 32, 32, 32, 32, 32, 32, 32, 192, 6,
  9, 9, 7, 0, 0, 128, 128, 128, 136, 144, 160, 208, 136, 132, 3, 9,
  9, 7, 2, 0, 192, 64, 64, 64, 64, 64, 64, 64, 224, 7, 6, 6,
  7, 0, 0, 252, 146, 146, 146, 146, 146, 6, 6, 6, 7, 0, 0, 152,
  164, 196, 132, 132, 132, 6, 6, 6, 7, 0, 0, 120, 132, 132, 132, 132,
  120, 6, 9, 9, 7, 0, 253, 248, 132, 132, 132, 132, 248, 128, 128, 128,
  6, 9, 9, 7, 0, 253, 124, 132, 132, 132, 132, 124, 4, 4, 4, 6,
  6, 6, 7, 0, 0, 152, 164, 192, 128, 128, 128, 6, 6, 6, 7, 0,
  0, 124, 128, 120, 4, 4, 248, 4, 9, 9, 7, 1, 0, 64, 64, 64,
  224, 64, 64, 64, 64, 48, 6, 6, 6, 7, 0, 0, 132, 132, 132, 140,
  148, 100, 6, 6, 6, 7, 0, 0, 132, 132, 72, 72, 48, 48, 7, 6,
  6, 7, 0, 0, 146, 146, 146, 146, 146, 108, 6, 6, 6, 7, 0, 0,
  132, 72, 48, 48, 72, 132, 6, 9, 9, 7, 0, 253, 132, 132, 132, 132,
  132, 124, 4, 4, 120, 6, 6, 6, 7, 0, 0, 252, 8, 16, 32, 64,
  252, 4, 15, 15, 7, 1, 253, 48, 64, 64, 64, 64, 64, 64, 128, 64,
  64, 64, 64, 64, 64, 48, 1, 13, 13, 7, 3, 254, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 4, 15, 15, 7, 1, 253, 192,
  32, 32, 32, 32, 32, 32, 16, 32, 32, 32, 32, 32, 32, 192, 6, 2,
  2, 7, 0, 4, 100, 152, 0, 0, 0, 7, 0, 0
};

/*
  Fontname: ProFont17
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 11, '1' Height: 11
  Calculated Max Values w= 9 h=17 x= 5 y=10 dx=14 dy= 0 ascent=14 len=32
  Font Bounding box     w=14 h=16 x= 0 y=-3
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =11 descent=-3
  X Font      ascent =13 descent=-3
  Max Font    ascent =14 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_profont17[3681] U8G_FONT_SECTION("u8g_font_profont17") = {
  0, 14, 16, 0, 253, 11, 2, 35, 4, 78, 32, 255, 253, 14, 253, 13,
  253, 0, 0, 0, 14, 0, 0, 2, 11, 11, 14, 3, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 0, 192, 192, 5, 5, 5, 14, 1, 8, 216, 216,
  216, 216, 216, 7, 7, 7, 14, 1, 3, 108, 254, 254, 108, 254, 254, 108,
  8, 15, 15, 14, 0, 254, 24, 24, 60, 126, 219, 216, 124, 62, 31, 219,
  219, 126, 60, 24, 24, 8, 11, 11, 14, 0, 0, 63, 127, 219, 222, 124,
  60, 62, 123, 219, 206, 196, 8, 11, 11, 14, 0, 0, 48, 120, 204, 204,
  216, 112, 243, 222, 204, 254, 123, 2, 5, 5, 14, 3, 8, 192, 192, 192,
  192, 192, 6, 15, 15, 14, 1, 254, 12, 24, 48, 96, 192, 192, 192, 192,
  192, 192, 192, 96, 48, 24, 12, 6, 15, 15, 14, 1, 254, 192, 96, 48,
  24, 12, 12, 12, 12, 12, 12, 12, 24, 48, 96, 192, 8, 8, 8, 14,
  0, 3, 24, 219, 255, 60, 60, 255, 219, 24, 8, 8, 8, 14, 0, 1,
  24, 24, 24, 255, 255, 24, 24, 24, 4, 6, 6, 14, 1, 253, 112, 112,
  112, 48, 96, 192, 5, 2, 2, 14, 1, 4, 248, 248, 3, 3, 3, 14,
  2, 0, 224, 224, 224, 9, 16, 32, 14, 0, 253, 1, 128, 1, 128, 3,
  0, 3, 0, 6, 0, 6, 0, 12, 0, 12, 0, 24, 0, 24, 0, 48,
  0, 48, 0, 96, 0, 96, 0, 192, 0, 192, 0, 8, 11, 11, 14, 0,
  0, 60, 126, 195, 199, 207, 219, 243, 227, 195, 126, 60, 8, 11, 11, 14,
  0, 0, 24, 120, 120, 24, 24, 24, 24, 24, 24, 255, 255, 8, 11, 11,
  14, 0, 0, 60, 126, 195, 195, 6, 12, 24, 48, 96, 255, 255, 8, 11,
  11, 14, 0, 0, 60, 126, 195, 195, 30, 28, 6, 195, 195, 126, 60, 8,
  11, 11, 14, 0, 0, 6, 14, 30, 54, 102, 198, 255, 255, 6, 15, 15,
  8, 11, 11, 14, 0, 0, 255, 255, 192, 252, 254, 3, 3, 3, 195, 126,
  60, 8, 11, 11, 14, 0, 0, 62, 126, 192, 252, 254, 195, 195, 195, 195,
  126, 60, 8, 11, 11, 14, 0, 0, 255, 255, 3, 3, 6, 12, 24, 24,
  24, 24, 24, 8, 11, 11, 14, 0, 0, 60, 126, 195, 195, 126, 60, 126,
  195, 195, 126, 60, 8, 11, 11, 14, 0, 0, 60, 126, 195, 195, 195, 195,
  127, 63, 3, 126, 124, 3, 8, 8, 14, 2, 0, 224, 224, 224, 0, 0,
  224, 224, 224, 4, 11, 11, 14, 1, 253, 112, 112, 112, 0, 0, 112, 112,
  112, 48, 96, 192, 7, 11, 11, 14, 1, 0, 6, 12, 24, 48, 96, 192,
  96, 48, 24, 12, 6, 8, 5, 5, 14, 0, 3, 255, 255, 0, 255, 255,
  7, 11, 11, 14, 1, 0, 192, 96, 48, 24, 12, 6, 12, 24, 48, 96,
  192, 8, 11, 11, 14, 0, 0, 60, 126, 195, 195, 6, 12, 24, 16, 0,
  24, 24, 8, 11, 11, 14, 0, 0, 60, 126, 195, 207, 223, 219, 223, 206,
  192, 127, 63, 8, 11, 11, 14, 0, 0, 24, 60, 60, 102, 102, 195, 255,
  255, 195, 195, 195, 8, 11, 11, 14, 0, 0, 252, 254, 195, 195, 254, 252,
  198, 195, 195, 254, 252, 8, 11, 11, 14, 0, 0, 60, 126, 195, 195, 192,
  192, 192, 195, 195, 126, 60, 8, 11, 11, 14, 0, 0, 252, 254, 195, 195,
  195, 195, 195, 195, 195, 254, 252, 8, 11, 11, 14, 0, 0, 255, 255, 192,
  192, 252, 252, 192, 192, 192, 255, 255, 8, 11, 11, 14, 0, 0, 255, 255,
  192, 192, 252, 252, 192, 192, 192, 192, 192, 8, 11, 11, 14, 0, 0, 60,
  126, 195, 195, 192, 207, 207, 195, 195, 126, 60, 8, 11, 11, 14, 0, 0,
  195, 195, 195, 195, 255, 255, 195, 195, 195, 195, 195, 8, 11, 11, 14, 0,
  0, 255, 255, 24, 24, 24, 24, 24, 24, 24, 255, 255, 8, 11, 11, 14,
  0, 0, 3, 3, 3, 3, 3, 3, 195, 195, 195, 126, 60, 8, 11, 11,
  14, 0, 0, 195, 198, 204, 216, 240, 224, 240, 216, 204, 198, 195, 8, 11,
  11, 14, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 255, 8,
  11, 11, 14, 0, 0, 195, 231, 255, 255, 219, 219, 219, 195, 195, 195, 195,
  8, 11, 11, 14, 0, 0, 195, 227, 243, 219, 207, 199, 195, 195, 195, 195,
  195, 8, 11, 11, 14, 0, 0, 60, 126, 195, 195, 195, 195, 195, 195, 195,
  126, 60, 8, 11, 11, 14, 0, 0, 252, 254, 195, 195, 254, 252, 192, 192,
  192, 192, 192, 8, 13, 13, 14, 0, 254, 60, 126, 195, 195, 195, 195, 195,
  219, 207, 126, 62, 6, 3, 8, 11, 11, 14, 0, 0, 252, 254, 195, 195,
  254, 252, 198, 195, 195, 195, 195, 8, 11, 11, 14, 0, 0, 60, 126, 195,
  192, 124, 62, 7, 195, 195, 126, 60, 8, 11, 11, 14, 0, 0, 255, 255,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 8, 11, 11, 14, 0, 0, 195,
  195, 195, 195, 195, 195, 195, 195, 195, 126, 60, 8, 11, 11, 14, 0, 0,
  195, 195, 195, 195, 195, 102, 102, 60, 60, 24, 24, 8, 11, 11, 14, 0,
  0, 195, 195, 195, 195, 219, 219, 219, 255, 255, 231, 195, 8, 11, 11, 14,
  0, 0, 195, 195, 195, 102, 60, 24, 60, 102, 195, 195, 195, 8, 11, 11,
  14, 0, 0, 195, 195, 195, 195, 231, 126, 60, 24, 24, 24, 24, 8, 11,
  11, 14, 0, 0, 255, 255, 3, 6, 12, 24, 48, 96, 192, 255, 255, 4,
  15, 15, 14, 3, 254, 240, 240, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 240, 240, 9, 16, 32, 14, 0, 253, 192, 0, 192, 0, 96, 0,
  96, 0, 48, 0, 48, 0, 24, 0, 24, 0, 12, 0, 12, 0, 6, 0,
  6, 0, 3, 0, 3, 0, 1, 128, 1, 128, 4, 15, 15, 14, 1, 254,
  240, 240, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 240, 240, 7,
  5, 5, 14, 1, 6, 16, 56, 108, 198, 130, 9, 2, 4, 14, 0, 253,
  255, 128, 255, 128, 3, 4, 4, 14, 1, 9, 128, 192, 96, 32, 8, 8,
  8, 14, 0, 0, 63, 127, 195, 195, 199, 207, 123, 51, 8, 11, 11, 14,
  0, 0, 192, 192, 192, 252, 254, 195, 195, 195, 195, 254, 252, 8, 8, 8,
  14, 0, 0, 60, 126, 195, 195, 192, 192, 127, 63, 8, 11, 11, 14, 0,
  0, 3, 3, 3, 63, 127, 195, 195, 195, 195, 127, 63, 8, 8, 8, 14,
  0, 0, 60, 126, 195, 255, 255, 192, 127, 63, 6, 11, 11, 14, 2, 0,
  28, 60, 96, 240, 240, 96, 96, 96, 96, 96, 96, 8, 11, 11, 14, 0,
  253, 63, 127, 195, 195, 195, 195, 127, 63, 3, 62, 60, 8, 11, 11, 14,
  0, 0, 192, 192, 192, 252, 254, 195, 195, 195, 195, 195, 195, 6, 11, 11,
  14, 1, 0, 48, 48, 0, 240, 240, 48, 48, 48, 48, 252, 252, 5, 14,
  14, 14, 0, 253, 24, 24, 0, 120, 120, 24, 24, 24, 24, 24, 24, 24,
  240, 224, 8, 11, 11, 14, 0, 0, 192, 192, 192, 198, 204, 216, 240, 248,
  204, 198, 195, 6, 11, 11, 14, 1, 0, 240, 240, 48, 48, 48, 48, 48,
  48, 48, 252, 252, 8, 8, 8, 14, 0, 0, 252, 254, 219, 219, 219, 219,
  219, 219, 8, 8, 8, 14, 0, 0, 204, 222, 243, 227, 195, 195, 195, 195,
  8, 8, 8, 14, 0, 0, 60, 126, 195, 195, 195, 195, 126, 60, 8, 11,
  11, 14, 0, 253, 252, 254, 195, 195, 195, 195, 254, 252, 192, 192, 192, 8,
  11, 11, 14, 0, 253, 63, 127, 195, 195, 195, 195, 127, 63, 3, 3, 3,
  8, 8, 8, 14, 0, 0, 204, 222, 243, 227, 192, 192, 192, 192, 8, 8,
  8, 14, 0, 0, 63, 255, 192, 252, 63, 3, 255, 252, 6, 11, 11, 14,
  2, 0, 96, 96, 96, 240, 240, 96, 96, 96, 96, 60, 28, 8, 8, 8,
  14, 0, 0, 195, 195, 195, 195, 199, 207, 123, 51, 8, 8, 8, 14, 0,
  0, 195, 195, 195, 102, 102, 60, 60, 24, 8, 8, 8, 14, 0, 0, 219,
  219, 219, 219, 219, 219, 255, 102, 8, 8, 8, 14, 0, 0, 195, 102, 60,
  24, 24, 60, 102, 195, 8, 11, 11, 14, 0, 253, 195, 195, 195, 195, 195,
  195, 127, 63, 3, 62, 60, 7, 8, 8, 14, 0, 0, 254, 254, 12, 24,
  48, 96, 254, 254, 5, 17, 17, 14, 1, 253, 24, 56, 48, 48, 48, 48,
  48, 96, 192, 96, 48, 48, 48, 48, 48, 56, 24, 2, 15, 15, 14, 3,
  254, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  5, 17, 17, 14, 2, 253, 192, 224, 96, 96, 96, 96, 96, 48, 24, 48,
  96, 96, 96, 96, 96, 224, 192, 8, 3, 3, 14, 0, 5, 113, 219, 142,
  0, 0, 0, 14, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 14,
  0, 0, 4, 5, 5, 14, 0, 254, 48, 48, 48, 96, 192, 8, 17, 17,
  14, 0, 253, 7, 15, 24, 24, 24, 24, 60, 60, 24, 24, 24, 24, 24,
  24, 24, 240, 224, 7, 5, 5, 14, 0, 254, 54, 54, 54, 108, 216, 8,
  2, 2, 14, 0, 0, 219, 219, 4, 9, 9, 14, 2, 2, 96, 96, 240,
  240, 96, 96, 96, 96, 96, 4, 9, 9, 14, 2, 2, 96, 96, 240, 240,
  96, 240, 240, 96, 96, 6, 3, 3, 14, 1, 10, 48, 120, 204, 9, 13,
  26, 14, 0, 0, 63, 128, 127, 128, 217, 128, 219, 0, 222, 0, 124, 0,
  56, 0, 63, 0, 127, 128, 214, 128, 150, 128, 31, 128, 15, 0, 8, 14,
  14, 14, 0, 0, 102, 60, 24, 60, 126, 195, 192, 124, 62, 7, 195, 195,
  126, 60, 4, 7, 7, 14, 0, 0, 48, 96, 192, 192, 192, 96, 48, 8,
  11, 11, 14, 0, 0, 63, 127, 216, 216, 220, 220, 216, 216, 216, 127, 63,
  0, 0, 0, 14, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 14,
  0, 0, 0, 0, 0, 14, 0, 0, 4, 5, 5, 14, 3, 6, 48, 96,
  192, 192, 192, 4, 5, 5, 14, 3, 6, 48, 48, 48, 96, 192, 7, 5,
  5, 14, 1, 6, 54, 108, 216, 216, 216, 7, 5, 5, 14, 1, 6, 54,
  54, 54, 108, 216, 7, 7, 7, 14, 0, 2, 56, 124, 254, 254, 254, 124,
  56, 5, 2, 2, 14, 2, 5, 248, 248, 9, 2, 4, 14, 0, 5, 255,
  128, 255, 128, 8, 3, 3, 14, 0, 9, 113, 219, 142, 9, 5, 10, 14,
  0, 6, 252, 128, 39, 128, 39, 128, 36, 128, 36, 128, 8, 13, 13, 14,
  0, 0, 102, 60, 24, 0, 0, 63, 255, 192, 252, 63, 3, 255, 252, 4,
  7, 7, 14, 0, 0, 192, 96, 48, 48, 48, 96, 192, 8, 8, 8, 14,
  0, 0, 36, 126, 219, 223, 223, 216, 127, 39, 0, 0, 0, 14, 0, 0,
  0, 0, 0, 14, 0, 0, 8, 14, 14, 14, 0, 0, 102, 102, 0, 195,
  195, 195, 195, 231, 126, 60, 24, 24, 24, 24, 0, 0, 0, 14, 0, 0,
  2, 11, 11, 14, 5, 0, 192, 192, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 8, 12, 12, 14, 0, 254, 24, 24, 60, 126, 219, 219, 216, 216, 127,
  63, 24, 24, 8, 12, 12, 14, 0, 0, 120, 252, 204, 192, 240, 240, 192,
  192, 192, 199, 254, 252, 8, 8, 8, 14, 0, 0, 129, 66, 60, 36, 36,
  60, 66, 129, 8, 11, 11, 14, 0, 0, 195, 102, 60, 255, 255, 24, 255,
  255, 24, 24, 24, 2, 15, 15, 14, 3, 254, 192, 192, 192, 192, 192, 192,
  0, 0, 0, 192, 192, 192, 192, 192, 192, 8, 16, 16, 14, 0, 254, 60,
  126, 99, 99, 51, 216, 204, 198, 99, 51, 27, 204, 198, 198, 126, 60, 4,
  2, 2, 14, 2, 9, 144, 240, 8, 11, 11, 14, 0, 0, 120, 252, 134,
  123, 251, 195, 251, 123, 134, 252, 120, 6, 9, 9, 14, 2, 5, 60, 124,
  204, 204, 124, 60, 0, 252, 252, 8, 7, 7, 14, 0, 0, 51, 102, 204,
  204, 204, 102, 51, 8, 4, 4, 14, 0, 2, 255, 255, 3, 3, 8, 2,
  2, 14, 0, 4, 255, 255, 8, 10, 10, 14, 0, 1, 248, 252, 6, 243,
  251, 219, 243, 251, 222, 204, 5, 2, 2, 14, 2, 9, 248, 248, 6, 6,
  6, 14, 2, 6, 48, 120, 204, 204, 120, 48, 8, 9, 9, 14, 0, 0,
  24, 24, 24, 255, 255, 24, 24, 255, 255, 4, 6, 6, 14, 2, 8, 96,
  144, 16, 32, 64, 240, 4, 6, 6, 14, 2, 8, 96, 144, 32, 16, 144,
  96, 4, 4, 4, 14, 3, 9, 48, 112, 224, 192, 8, 11, 11, 14, 0,
  253, 204, 204, 204, 204, 204, 204, 255, 243, 192, 192, 192, 8, 13, 13, 14,
  0, 0, 63, 127, 219, 219, 219, 219, 127, 63, 27, 27, 27, 27, 27, 3,
  3, 3, 14, 3, 4, 224, 224, 224, 4, 5, 5, 14, 1, 253, 112, 112,
  48, 96, 192, 3, 6, 6, 14, 3, 8, 192, 64, 64, 64, 64, 224, 6,
  9, 9, 14, 2, 5, 48, 120, 204, 204, 120, 48, 0, 252, 252, 8, 7,
  7, 14, 0, 0, 204, 102, 51, 51, 51, 102, 204, 9, 14, 28, 14, 0,
  0, 96, 0, 32, 0, 32, 0, 32, 128, 33, 0, 114, 0, 4, 0, 8,
  0, 17, 0, 35, 0, 69, 0, 137, 0, 15, 128, 1, 0, 9, 14, 28,
  14, 0, 0, 96, 0, 32, 0, 32, 0, 32, 128, 33, 0, 114, 0, 4,
  0, 8, 0, 19, 0, 36, 128, 64, 128, 129, 0, 2, 0, 7, 128, 9,
  14, 28, 14, 0, 0, 48, 0, 72, 0, 16, 0, 8, 128, 73, 0, 50,
  0, 4, 0, 8, 0, 17, 0, 35, 0, 69, 0, 137, 0, 15, 128, 1,
  0, 8, 11, 11, 14, 0, 0, 24, 24, 0, 8, 24, 48, 96, 195, 195,
  126, 60, 8, 14, 14, 14, 0, 0, 96, 48, 24, 24, 60, 60, 102, 102,
  195, 255, 255, 195, 195, 195, 8, 14, 14, 14, 0, 0, 6, 12, 24, 24,
  60, 60, 102, 102, 195, 255, 255, 195, 195, 195, 8, 14, 14, 14, 0, 0,
  24, 60, 102, 24, 60, 60, 102, 102, 195, 255, 255, 195, 195, 195, 8, 14,
  14, 14, 0, 0, 115, 219, 142, 24, 60, 60, 102, 102, 195, 255, 255, 195,
  195, 195, 8, 14, 14, 14, 0, 0, 102, 102, 0, 24, 60, 60, 102, 102,
  195, 255, 255, 195, 195, 195, 8, 14, 14, 14, 0, 0, 24, 60, 36, 60,
  24, 60, 102, 102, 195, 255, 255, 195, 195, 195, 8, 11, 11, 14, 0, 0,
  63, 127, 216, 216, 252, 252, 216, 216, 216, 223, 223, 8, 14, 14, 14, 0,
  253, 60, 126, 195, 195, 192, 192, 192, 195, 195, 126, 60, 24, 48, 96, 8,
  14, 14, 14, 0, 0, 96, 48, 24, 255, 255, 192, 192, 252, 252, 192, 192,
  192, 255, 255, 8, 14, 14, 14, 0, 0, 6, 12, 24, 255, 255, 192, 192,
  252, 252, 192, 192, 192, 255, 255, 8, 14, 14, 14, 0, 0, 24, 60, 102,
  255, 255, 192, 192, 252, 252, 192, 192, 192, 255, 255, 8, 14, 14, 14, 0,
  0, 102, 102, 0, 255, 255, 192, 192, 252, 252, 192, 192, 192, 255, 255, 8,
  14, 14, 14, 0, 0, 96, 48, 24, 255, 255, 24, 24, 24, 24, 24, 24,
  24, 255, 255, 8, 14, 14, 14, 0, 0, 6, 12, 24, 255, 255, 24, 24,
  24, 24, 24, 24, 24, 255, 255, 8, 14, 14, 14, 0, 0, 24, 60, 102,
  255, 255, 24, 24, 24, 24, 24, 24, 24, 255, 255, 8, 14, 14, 14, 0,
  0, 102, 102, 0, 255, 255, 24, 24, 24, 24, 24, 24, 24, 255, 255, 8,
  11, 11, 14, 0, 0, 124, 126, 99, 99, 243, 243, 99, 99, 99, 126, 124,
  8, 14, 14, 14, 0, 0, 113, 219, 142, 195, 227, 243, 219, 207, 199, 195,
  195, 195, 195, 195, 8, 14, 14, 14, 0, 0, 96, 48, 24, 60, 126, 195,
  195, 195, 195, 195, 195, 195, 126, 60, 8, 14, 14, 14, 0, 0, 6, 12,
  24, 60, 126, 195, 195, 195, 195, 195, 195, 195, 126, 60, 8, 14, 14, 14,
  0, 0, 24, 60, 102, 0, 60, 126, 195, 195, 195, 195, 195, 195, 126, 60,
  8, 14, 14, 14, 0, 0, 113, 219, 142, 60, 126, 195, 195, 195, 195, 195,
  195, 195, 126, 60, 8, 14, 14, 14, 0, 0, 102, 102, 0, 60, 126, 195,
  195, 195, 195, 195, 195, 195, 126, 60, 8, 7, 7, 14, 0, 2, 195, 102,
  60, 24, 60, 102, 195, 8, 11, 11, 14, 0, 0, 60, 126, 195, 199, 207,
  219, 243, 227, 195, 126, 60, 8, 14, 14, 14, 0, 0, 96, 48, 24, 195,
  195, 195, 195, 195, 195, 195, 195, 195, 126, 60, 8, 14, 14, 14, 0, 0,
  6, 12, 24, 195, 195, 195, 195, 195, 195, 195, 195, 195, 126, 60, 8, 14,
  14, 14, 0, 0, 24, 60, 102, 0, 195, 195, 195, 195, 195, 195, 195, 195,
  126, 60, 8, 14, 14, 14, 0, 0, 102, 102, 0, 195, 195, 195, 195, 195,
  195, 195, 195, 195, 126, 60, 8, 14, 14, 14, 0, 0, 6, 12, 24, 195,
  195, 195, 195, 231, 126, 60, 24, 24, 24, 24, 8, 11, 11, 14, 0, 0,
  192, 192, 252, 254, 195, 195, 254, 252, 192, 192, 192, 8, 15, 15, 14, 0,
  254, 28, 62, 99, 195, 195, 198, 204, 204, 198, 195, 195, 222, 220, 192, 192,
  8, 13, 13, 14, 0, 0, 16, 24, 12, 4, 0, 63, 127, 195, 195, 199,
  207, 123, 51, 8, 13, 13, 14, 0, 0, 4, 12, 24, 16, 0, 63, 127,
  195, 195, 199, 207, 123, 51, 8, 12, 12, 14, 0, 0, 24, 60, 102, 0,
  63, 127, 195, 195, 199, 207, 123, 51, 8, 12, 12, 14, 0, 0, 113, 219,
  142, 0, 63, 127, 195, 195, 199, 207, 123, 51, 8, 11, 11, 14, 0, 0,
  102, 102, 0, 63, 127, 195, 195, 199, 207, 123, 51, 8, 12, 12, 14, 0,
  0, 24, 36, 36, 24, 63, 127, 195, 195, 199, 207, 123, 51, 8, 8, 8,
  14, 0, 0, 60, 126, 219, 223, 223, 216, 127, 63, 8, 11, 11, 14, 0,
  253, 60, 126, 195, 195, 192, 192, 127, 63, 24, 48, 96, 8, 13, 13, 14,
  0, 0, 32, 48, 24, 8, 0, 60, 126, 195, 255, 255, 192, 127, 63, 8,
  13, 13, 14, 0, 0, 4, 12, 24, 16, 0, 60, 126, 195, 255, 255, 192,
  127, 63, 8, 12, 12, 14, 0, 0, 24, 60, 102, 0, 60, 126, 195, 255,
  255, 192, 127, 63, 8, 11, 11, 14, 0, 0, 102, 102, 0, 60, 126, 195,
  255, 255, 192, 127, 63, 6, 13, 13, 14, 1, 0, 128, 192, 96, 32, 0,
  240, 240, 48, 48, 48, 48, 252, 252, 6, 13, 13, 14, 1, 0, 8, 24,
  48, 32, 0, 240, 240, 48, 48, 48, 48, 252, 252, 6, 12, 12, 14, 1,
  0, 48, 120, 204, 0, 240, 240, 48, 48, 48, 48, 252, 252, 6, 11, 11,
  14, 1, 0, 204, 204, 0, 240, 240, 48, 48, 48, 48, 252, 252, 8, 13,
  13, 14, 0, 0, 72, 48, 48, 72, 4, 62, 127, 195, 195, 195, 195, 126,
  60, 8, 12, 12, 14, 0, 0, 113, 219, 142, 0, 204, 222, 243, 227, 195,
  195, 195, 195, 8, 13, 13, 14, 0, 0, 32, 48, 24, 8, 0, 60, 126,
  195, 195, 195, 195, 126, 60, 8, 13, 13, 14, 0, 0, 4, 12, 24, 16,
  0, 60, 126, 195, 195, 195, 195, 126, 60, 8, 12, 12, 14, 0, 0, 24,
  60, 102, 0, 60, 126, 195, 195, 195, 195, 126, 60, 8, 12, 12, 14, 0,
  0, 113, 219, 142, 0, 60, 126, 195, 195, 195, 195, 126, 60, 8, 11, 11,
  14, 0, 0, 102, 102, 0, 60, 126, 195, 195, 195, 195, 126, 60, 8, 8,
  8, 14, 0, 2, 24, 24, 0, 255, 255, 0, 24, 24, 8, 8, 8, 14,
  0, 0, 60, 126, 199, 207, 243, 227, 126, 60, 8, 13, 13, 14, 0, 0,
  32, 48, 24, 8, 0, 195, 195, 195, 195, 199, 207, 123, 51, 8, 13, 13,
  14, 0, 0, 4, 12, 24, 16, 0, 195, 195, 195, 195, 199, 207, 123, 51,
  8, 12, 12, 14, 0, 0, 24, 60, 102, 0, 195, 195, 195, 195, 199, 207,
  123, 51, 8, 11, 11, 14, 0, 0, 102, 102, 0, 195, 195, 195, 195, 199,
  207, 123, 51, 8, 16, 16, 14, 0, 253, 4, 12, 24, 16, 0, 195, 195,
  195, 195, 195, 195, 127, 63, 3, 62, 60, 8, 14, 14, 14, 0, 253, 192,
  192, 192, 252, 254, 195, 195, 195, 195, 254, 252, 192, 192, 192, 8, 14, 14,
  14, 0, 253, 102, 102, 0, 195, 195, 195, 195, 195, 195, 127, 63, 3, 62,
  60
};

/*
  Fontname: ProFont17
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 11, '1' Height: 11
  Calculated Max Values w= 9 h=17 x= 3 y= 9 dx=14 dy= 0 ascent=14 len=32
  Font Bounding box     w=14 h=16 x= 0 y=-3
  Calculated Min Values           x= 0 y=-3 dx= 0 dy= 0
  Pure Font   ascent =11 descent=-3
  X Font      ascent =13 descent=-3
  Max Font    ascent =14 descent=-3
*/
const u8g_fntpgm_uint8_t u8g_font_profont17r[1590] U8G_FONT_SECTION("u8g_font_profont17r") = {
  0, 14, 16, 0, 253, 11, 2, 35, 4, 78, 32, 127, 253, 14, 253, 13,
  253, 0, 0, 0, 14, 0, 0, 2, 11, 11, 14, 3, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 0, 192, 192, 5, 5, 5, 14, 1, 8, 216, 216,
  216, 216, 216, 7, 7, 7, 14, 1, 3, 108, 254, 254, 108, 254, 254, 108,
  8, 15, 15, 14, 0, 254, 24, 24, 60, 126, 219, 216, 124, 62, 31, 219,
  219, 126, 60, 24, 24, 8, 11, 11, 14, 0, 0, 63, 127, 219, 222, 124,
  60, 62, 123, 219, 206, 196, 8, 11, 11, 14, 0, 0, 48, 120, 204, 204,
  216, 112, 243, 222, 204, 254, 123, 2, 5, 5, 14, 3, 8, 192, 192, 192,
  192, 192, 6, 15, 15, 14, 1, 254, 12, 24, 48, 96, 192, 192, 192, 192,
  192, 192, 192, 96, 48, 24, 12, 6, 15, 15, 14, 1, 254, 192, 96, 48,
  24, 12, 12, 12, 12, 12, 12, 12, 24, 48, 96, 192, 8, 8, 8, 14,
  0, 3, 24, 219, 255, 60, 60, 255, 219, 24, 8, 8, 8, 14, 0, 1,
  24, 24, 24, 255, 255, 24, 24, 24, 4, 6, 6, 14, 1, 253, 112, 112,
  112, 48, 96, 192, 5, 2, 2, 14, 1, 4, 248, 248, 3, 3, 3, 14,
  2, 0, 224, 224, 224, 9, 16, 32, 14, 0, 253, 1, 128, 1, 128, 3,
  0, 3, 0, 6, 0, 6, 0, 12, 0, 12, 0, 24, 0, 24, 0, 48,
  0, 48, 0, 96, 0, 96, 0, 192, 0, 192, 0, 8, 11, 11, 14, 0,
  0, 60, 126, 195, 199, 207, 219, 243, 227, 195, 126, 60, 8, 11, 11, 14,
  0, 0, 24, 120, 120, 24, 24, 24, 24, 24, 24, 255, 255, 8, 11, 11,
  14, 0, 0, 60, 126, 195, 195, 6, 12, 24, 48, 96, 255, 255, 8, 11,
  11, 14, 0, 0, 60, 126, 195, 195, 30, 28, 6, 195, 195, 126, 60, 8,
  11, 11, 14, 0, 0, 6, 14, 30, 54, 102, 198, 255, 255, 6, 15, 15,
  8, 11, 11, 14, 0, 0, 255, 255, 192, 252, 254, 3, 3, 3, 195, 126,
  60, 8, 11, 11, 14, 0, 0, 62, 126, 192, 252, 254, 195, 195, 195, 195,
  126, 60, 8, 11, 11, 14, 0, 0, 255, 255, 3, 3, 6, 12, 24, 24,
  24, 24, 24, 8, 11, 11, 14, 0, 0, 60, 126, 195, 195, 126, 60, 126,
  195, 195, 126, 60, 8, 11, 11, 14, 0, 0, 60, 126, 195, 195, 195, 195,
  127, 63, 3, 126, 124, 3, 8, 8, 14, 2, 0, 224, 224, 224, 0, 0,
  224, 224, 224, 4, 11, 11, 14, 1, 253, 112, 112, 112, 0, 0, 112, 112,
  112, 48, 96, 192, 7, 11, 11, 14, 1, 0, 6, 12, 24, 48, 96, 192,
  96, 48, 24, 12, 6, 8, 5, 5, 14, 0, 3, 255, 255, 0, 255, 255,
  7, 11, 11, 14, 1, 0, 192, 96, 48, 24, 12, 6, 12, 24, 48, 96,
  192, 8, 11, 11, 14, 0, 0, 60, 126, 195, 195, 6, 12, 24, 16, 0,
  24, 24, 8, 11, 11, 14, 0, 0, 60, 126, 195, 207, 223, 219, 223, 206,
  192, 127, 63, 8, 11, 11, 14, 0, 0, 24, 60, 60, 102, 102, 195, 255,
  255, 195, 195, 195, 8, 11, 11, 14, 0, 0, 252, 254, 195, 195, 254, 252,
  198, 195, 195, 254, 252, 8, 11, 11, 14, 0, 0, 60, 126, 195, 195, 192,
  192, 192, 195, 195, 126, 60, 8, 11, 11, 14, 0, 0, 252, 254, 195, 195,
  195, 195, 195, 195, 195, 254, 252, 8, 11, 11, 14, 0, 0, 255, 255, 192,
  192, 252, 252, 192, 192, 192, 255, 255, 8, 11, 11, 14, 0, 0, 255, 255,
  192, 192, 252, 252, 192, 192, 192, 192, 192, 8, 11, 11, 14, 0, 0, 60,
  126, 195, 195, 192, 207, 207, 195, 195, 126, 60, 8, 11, 11, 14, 0, 0,
  195, 195, 195, 195, 255, 255, 195, 195, 195, 195, 195, 8, 11, 11, 14, 0,
  0, 255, 255, 24, 24, 24, 24, 24, 24, 24, 255, 255, 8, 11, 11, 14,
  0, 0, 3, 3, 3, 3, 3, 3, 195, 195, 195, 126, 60, 8, 11, 11,
  14, 0, 0, 195, 198, 204, 216, 240, 224, 240, 216, 204, 198, 195, 8, 11,
  11, 14, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 255, 255, 8,
  11, 11, 14, 0, 0, 195, 231, 255, 255, 219, 219, 219, 195, 195, 195, 195,
  8, 11, 11, 14, 0, 0, 195, 227, 243, 219, 207, 199, 195, 195, 195, 195,
  195, 8, 11, 11, 14, 0, 0, 60, 126, 195, 195, 195, 195, 195, 195, 195,
  126, 60, 8, 11, 11, 14, 0, 0, 252, 254, 195, 195, 254, 252, 192, 192,
  192, 192, 192, 8, 13, 13, 14, 0, 254, 60, 126, 195, 195, 195, 195, 195,
  219, 207, 126, 62, 6, 3, 8, 11, 11, 14, 0, 0, 252, 254, 195, 195,
  254, 252, 198, 195, 195, 195, 195, 8, 11, 11, 14, 0, 0, 60, 126, 195,
  192, 124, 62, 7, 195, 195, 126, 60, 8, 11, 11, 14, 0, 0, 255, 255,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 8, 11, 11, 14, 0, 0, 195,
  195, 195, 195, 195, 195, 195, 195, 195, 126, 60, 8, 11, 11, 14, 0, 0,
  195, 195, 195, 195, 195, 102, 102, 60, 60, 24, 24, 8, 11, 11, 14, 0,
  0, 195, 195, 195, 195, 219, 219, 219, 255, 255, 231, 195, 8, 11, 11, 14,
  0, 0, 195, 195, 195, 102, 60, 24, 60, 102, 195, 195, 195, 8, 11, 11,
  14, 0, 0, 195, 195, 195, 195, 231, 126, 60, 24, 24, 24, 24, 8, 11,
  11, 14, 0, 0, 255, 255, 3, 6, 12, 24, 48, 96, 192, 255, 255, 4,
  15, 15, 14, 3, 254, 240, 240, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 240, 240, 9, 16, 32, 14, 0, 253, 192, 0, 192, 0, 96, 0,
  96, 0, 48, 0, 48, 0, 24, 0, 24, 0, 12, 0, 12, 0, 6, 0,
  6, 0, 3, 0, 3, 0, 1, 128, 1, 128, 4, 15, 15, 14, 1, 254,
  240, 240, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 240, 240, 7,
  5, 5, 14, 1, 6, 16, 56, 108, 198, 130, 9, 2, 4, 14, 0, 253,
  255, 128, 255, 128, 3, 4, 4, 14, 1, 9, 128, 192, 96, 32, 8, 8,
  8, 14, 0, 0, 63, 127, 195, 195, 199, 207, 123, 51, 8, 11, 11, 14,
  0, 0, 192, 192, 192, 252, 254, 195, 195, 195, 195, 254, 252, 8, 8, 8,
  14, 0, 0, 60, 126, 195, 195, 192, 192, 127, 63, 8, 11, 11, 14, 0,
  0, 3, 3, 3, 63, 127, 195, 195, 195, 195, 127, 63, 8, 8, 8, 14,
  0, 0, 60, 126, 195, 255, 255, 192, 127, 63, 6, 11, 11, 14, 2, 0,
  28, 60, 96, 240, 240, 96, 96, 96, 96, 96, 96, 8, 11, 11, 14, 0,
  253, 63, 127, 195, 195, 195, 195, 127, 63, 3, 62, 60, 8, 11, 11, 14,
  0, 0, 192, 192, 192, 252, 254, 195, 195, 195, 195, 195, 195, 6, 11, 11,
  14, 1, 0, 48, 48, 0, 240, 240, 48, 48, 48, 48, 252, 252, 5, 14,
  14, 14, 0, 253, 24, 24, 0, 120, 120, 24, 24, 24, 24, 24, 24, 24,
  240, 224, 8, 11, 11, 14, 0, 0, 192, 192, 192, 198, 204, 216, 240, 248,
  204, 198, 195, 6, 11, 11, 14, 1, 0, 240, 240, 48, 48, 48, 48, 48,
  48, 48, 252, 252, 8, 8, 8, 14, 0, 0, 252, 254, 219, 219, 219, 219,
  219, 219, 8, 8, 8, 14, 0, 0, 204, 222, 243, 227, 195, 195, 195, 195,
  8, 8, 8, 14, 0, 0, 60, 126, 195, 195, 195, 195, 126, 60, 8, 11,
  11, 14, 0, 253, 252, 254, 195, 195, 195, 195, 254, 252, 192, 192, 192, 8,
  11, 11, 14, 0, 253, 63, 127, 195, 195, 195, 195, 127, 63, 3, 3, 3,
  8, 8, 8, 14, 0, 0, 204, 222, 243, 227, 192, 192, 192, 192, 8, 8,
  8, 14, 0, 0, 63, 255, 192, 252, 63, 3, 255, 252, 6, 11, 11, 14,
  2, 0, 96, 96, 96, 240, 240, 96, 96, 96, 96, 60, 28, 8, 8, 8,
  14, 0, 0, 195, 195, 195, 195, 199, 207, 123, 51, 8, 8, 8, 14, 0,
  0, 195, 195, 195, 102, 102, 60, 60, 24, 8, 8, 8, 14, 0, 0, 219,
  219, 219, 219, 219, 219, 255, 102, 8, 8, 8, 14, 0, 0, 195, 102, 60,
  24, 24, 60, 102, 195, 8, 11, 11, 14, 0, 253, 195, 195, 195, 195, 195,
  195, 127, 63, 3, 62, 60, 7, 8, 8, 14, 0, 0, 254, 254, 12, 24,
  48, 96, 254, 254, 5, 17, 17, 14, 1, 253, 24, 56, 48, 48, 48, 48,
  48, 96, 192, 96, 48, 48, 48, 48, 48, 56, 24, 2, 15, 15, 14, 3,
  254, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  5, 17, 17, 14, 2, 253, 192, 224, 96, 96, 96, 96, 96, 48, 24, 48,
  96, 96, 96, 96, 96, 224, 192, 8, 3, 3, 14, 0, 5, 113, 219, 142,
  0, 0, 0, 14, 0, 0
};

/*
  Fontname: ProFont22
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 14, '1' Height: 14
  Calculated Max Values w=12 h=22 x= 6 y=12 dx=12 dy= 0 ascent=18 len=44
  Font Bounding box     w=12 h=21 x= 0 y=-4
  Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
  Pure Font   ascent =14 descent=-4
  X Font      ascent =16 descent=-4
  Max Font    ascent =18 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_profont22[6454] U8G_FONT_SECTION("u8g_font_profont22") = {
  0, 12, 21, 0, 252, 14, 3, 117, 7, 113, 32, 255, 252, 18, 252, 16,
  252, 0, 0, 0, 12, 0, 0, 2, 14, 14, 12, 4, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 0, 0, 192, 192, 6, 6, 6, 12, 2,
  10, 204, 204, 204, 204, 204, 204, 10, 10, 20, 12, 0, 4, 51, 0, 51,
  0, 255, 192, 255, 192, 51, 0, 51, 0, 255, 192, 255, 192, 51, 0, 51,
  0, 10, 18, 36, 12, 0, 254, 12, 0, 12, 0, 63, 0, 127, 128, 237,
  192, 204, 192, 204, 0, 236, 0, 127, 0, 63, 128, 13, 192, 12, 192, 204,
  192, 237, 192, 127, 128, 63, 0, 12, 0, 12, 0, 10, 14, 28, 12, 0,
  0, 63, 192, 127, 192, 204, 192, 205, 192, 207, 128, 207, 0, 127, 0, 63,
  128, 60, 192, 124, 192, 236, 192, 204, 192, 199, 128, 195, 0, 10, 14, 28,
  12, 0, 0, 62, 0, 127, 0, 227, 0, 199, 0, 206, 0, 252, 0, 120,
  0, 120, 0, 252, 192, 207, 192, 199, 128, 231, 128, 127, 192, 60, 192, 2,
  6, 6, 12, 4, 10, 192, 192, 192, 192, 192, 192, 6, 18, 18, 12, 2,
  254, 12, 28, 56, 112, 224, 192, 192, 192, 192, 192, 192, 192, 192, 224, 112,
  56, 28, 12, 6, 18, 18, 12, 2, 254, 192, 224, 112, 56, 28, 12, 12,
  12, 12, 12, 12, 12, 12, 28, 56, 112, 224, 192, 10, 10, 20, 12, 0,
  4, 12, 0, 12, 0, 204, 192, 255, 192, 63, 0, 63, 0, 255, 192, 204,
  192, 12, 0, 12, 0, 10, 10, 20, 12, 0, 2, 12, 0, 12, 0, 12,
  0, 12, 0, 255, 192, 255, 192, 12, 0, 12, 0, 12, 0, 12, 0, 5,
  9, 9, 12, 2, 252, 48, 120, 120, 56, 24, 56, 112, 224, 64, 6, 2,
  2, 12, 2, 6, 252, 252, 4, 4, 4, 12, 3, 1, 96, 240, 240, 96,
  11, 20, 40, 12, 0, 252, 0, 96, 0, 96, 0, 192, 0, 192, 1, 128,
  1, 128, 3, 0, 3, 0, 6, 0, 6, 0, 12, 0, 12, 0, 24, 0,
  24, 0, 48, 0, 48, 0, 96, 0, 96, 0, 192, 0, 192, 0, 10, 14,
  28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 193, 192, 195, 192, 199, 192,
  206, 192, 220, 192, 248, 192, 240, 192, 224, 192, 225, 192, 127, 128, 63, 0,
  10, 14, 28, 12, 0, 0, 12, 0, 12, 0, 124, 0, 124, 0, 12, 0,
  12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 255, 192,
  255, 192, 10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192,
  0, 192, 1, 192, 3, 128, 7, 0, 14, 0, 28, 0, 56, 0, 112, 0,
  255, 192, 255, 192, 10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192,
  192, 192, 0, 192, 1, 128, 15, 0, 15, 128, 1, 192, 0, 192, 192, 192,
  225, 192, 127, 128, 63, 0, 10, 14, 28, 12, 0, 0, 3, 0, 7, 0,
  15, 0, 31, 0, 59, 0, 115, 0, 227, 0, 195, 0, 255, 192, 255, 192,
  3, 0, 3, 0, 15, 192, 15, 192, 10, 14, 28, 12, 0, 0, 255, 192,
  255, 192, 192, 0, 192, 0, 255, 0, 255, 128, 1, 192, 0, 192, 0, 192,
  0, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 14, 28, 12, 0, 0,
  63, 0, 127, 0, 224, 0, 192, 0, 255, 0, 255, 128, 193, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 14, 28, 12,
  0, 0, 255, 192, 255, 192, 0, 192, 0, 192, 0, 192, 1, 192, 3, 128,
  7, 0, 14, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 10, 14,
  28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 192, 97, 128,
  63, 0, 127, 128, 225, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0,
  10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 224, 192, 127, 192, 63, 192, 0, 192, 1, 192, 63, 128,
  63, 0, 4, 10, 10, 12, 3, 1, 96, 240, 240, 96, 0, 0, 96, 240,
  240, 96, 5, 15, 15, 12, 2, 252, 48, 120, 120, 48, 0, 0, 48, 120,
  120, 56, 24, 56, 112, 224, 64, 8, 14, 14, 12, 2, 0, 3, 7, 14,
  28, 56, 112, 224, 224, 112, 56, 28, 14, 7, 3, 10, 6, 12, 12, 0,
  4, 255, 192, 255, 192, 0, 0, 0, 0, 255, 192, 255, 192, 8, 14, 14,
  12, 2, 0, 192, 224, 112, 56, 28, 14, 7, 7, 14, 28, 56, 112, 224,
  192, 10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 0,
  192, 1, 192, 3, 128, 7, 0, 14, 0, 12, 0, 0, 0, 0, 0, 12,
  0, 12, 0, 10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192,
  192, 199, 192, 207, 192, 204, 192, 204, 192, 207, 192, 199, 128, 192, 0, 224,
  0, 127, 192, 63, 192, 10, 14, 28, 12, 0, 0, 12, 0, 30, 0, 30,
  0, 51, 0, 51, 0, 97, 128, 97, 128, 192, 192, 255, 192, 255, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 10, 14, 28, 12, 0, 0, 255, 0, 255,
  128, 193, 192, 192, 192, 192, 192, 193, 128, 255, 0, 255, 128, 193, 192, 192,
  192, 192, 192, 193, 192, 255, 128, 255, 0, 10, 14, 28, 12, 0, 0, 63,
  0, 127, 128, 225, 192, 192, 192, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 192, 225, 192, 127, 128, 63, 0, 10, 14, 28, 12, 0,
  0, 255, 0, 255, 128, 193, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 193, 192, 255, 128, 255, 0, 10, 14, 28,
  12, 0, 0, 255, 192, 255, 192, 192, 0, 192, 0, 192, 0, 192, 0, 255,
  0, 255, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 192, 255, 192, 10,
  14, 28, 12, 0, 0, 255, 192, 255, 192, 192, 0, 192, 0, 192, 0, 192,
  0, 255, 0, 255, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192,
  0, 192, 0, 195, 192, 195, 192, 192, 192, 192, 192, 192, 192, 225, 192, 127,
  128, 63, 0, 10, 14, 28, 12, 0, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 255, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 10, 14, 28, 12, 0, 0, 255, 192, 255, 192, 12,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12,
  0, 12, 0, 255, 192, 255, 192, 10, 14, 28, 12, 0, 0, 0, 192, 0,
  192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 192, 192, 192,
  192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 14, 28, 12, 0, 0, 193,
  192, 195, 128, 199, 0, 206, 0, 220, 0, 248, 0, 240, 0, 248, 0, 220,
  0, 206, 0, 199, 0, 195, 128, 193, 192, 192, 192, 10, 14, 28, 12, 0,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 192, 255, 192, 10, 14, 28,
  12, 0, 0, 192, 192, 225, 192, 243, 192, 255, 192, 222, 192, 204, 192, 204,
  192, 204, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 10,
  14, 28, 12, 0, 0, 192, 192, 224, 192, 240, 192, 248, 192, 220, 192, 206,
  192, 199, 192, 195, 192, 193, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 225, 192, 127,
  128, 63, 0, 10, 14, 28, 12, 0, 0, 255, 0, 255, 128, 193, 192, 192,
  192, 192, 192, 193, 192, 255, 128, 255, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 10, 16, 32, 12, 0, 254, 63, 0, 127, 128, 225,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 204,
  192, 239, 192, 127, 128, 63, 128, 1, 192, 0, 192, 10, 14, 28, 12, 0,
  0, 255, 0, 255, 128, 193, 192, 192, 192, 192, 192, 193, 128, 255, 0, 255,
  128, 193, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 10, 14, 28,
  12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 0, 224, 0, 127,
  0, 63, 128, 1, 192, 0, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10,
  14, 28, 12, 0, 0, 255, 192, 255, 192, 12, 0, 12, 0, 12, 0, 12,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12,
  0, 10, 14, 28, 12, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 225, 192, 127,
  128, 63, 0, 10, 14, 28, 12, 0, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 97, 128, 97, 128, 51, 0, 51, 0, 30, 0, 30,
  0, 12, 0, 12, 0, 10, 14, 28, 12, 0, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 204, 192, 204, 192, 204, 192, 222, 192, 255,
  192, 243, 192, 225, 192, 192, 192, 10, 14, 28, 12, 0, 0, 192, 192, 192,
  192, 192, 192, 225, 192, 115, 128, 63, 0, 30, 0, 30, 0, 63, 0, 115,
  128, 225, 192, 192, 192, 192, 192, 192, 192, 10, 14, 28, 12, 0, 0, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 225, 192, 115, 128, 63, 0, 30,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 10, 14, 28, 12, 0,
  0, 255, 192, 255, 192, 0, 192, 1, 192, 3, 128, 7, 0, 14, 0, 28,
  0, 56, 0, 112, 0, 224, 0, 192, 0, 255, 192, 255, 192, 4, 18, 18,
  12, 4, 254, 240, 240, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 240, 240, 11, 20, 40, 12, 1, 252, 192, 0, 192, 0, 96,
  0, 96, 0, 48, 0, 48, 0, 24, 0, 24, 0, 12, 0, 12, 0, 6,
  0, 6, 0, 3, 0, 3, 0, 1, 128, 1, 128, 0, 192, 0, 192, 0,
  96, 0, 96, 4, 18, 18, 12, 2, 254, 240, 240, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 240, 240, 10, 6, 12, 12, 0,
  8, 12, 0, 30, 0, 63, 0, 115, 128, 225, 192, 64, 128, 12, 2, 4,
  12, 0, 252, 255, 240, 255, 240, 4, 4, 4, 12, 2, 12, 192, 224, 112,
  48, 10, 10, 20, 12, 0, 0, 63, 192, 127, 192, 224, 192, 192, 192, 192,
  192, 193, 192, 195, 192, 231, 192, 126, 192, 60, 192, 10, 14, 28, 12, 0,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 0, 255, 128, 193, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 193, 192, 255, 128, 255, 0, 10, 10, 20,
  12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 0, 192, 0, 192,
  0, 224, 0, 127, 192, 63, 192, 10, 14, 28, 12, 0, 0, 0, 192, 0,
  192, 0, 192, 0, 192, 63, 192, 127, 192, 224, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 224, 192, 127, 192, 63, 192, 10, 10, 20, 12, 0, 0, 63,
  0, 127, 128, 225, 192, 192, 192, 255, 192, 255, 192, 192, 0, 224, 0, 127,
  192, 63, 192, 8, 14, 14, 12, 2, 0, 15, 31, 56, 48, 252, 252, 48,
  48, 48, 48, 48, 48, 48, 48, 10, 14, 28, 12, 0, 252, 63, 192, 127,
  192, 224, 192, 192, 192, 192, 192, 192, 192, 192, 192, 224, 192, 127, 192, 63,
  192, 0, 192, 1, 192, 63, 128, 63, 0, 10, 14, 28, 12, 0, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 255, 0, 255, 128, 193, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 6, 14, 14, 12, 2,
  0, 48, 48, 0, 0, 240, 240, 48, 48, 48, 48, 48, 48, 252, 252, 6,
  18, 18, 12, 0, 252, 12, 12, 0, 0, 60, 60, 12, 12, 12, 12, 12,
  12, 12, 12, 12, 28, 248, 240, 10, 14, 28, 12, 0, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 195, 128, 199, 0, 206, 0, 220, 0, 252, 0, 254,
  0, 231, 0, 195, 128, 193, 192, 192, 192, 6, 14, 14, 12, 2, 0, 240,
  240, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 252, 252, 10, 10, 20,
  12, 0, 0, 255, 0, 255, 128, 205, 192, 204, 192, 204, 192, 204, 192, 204,
  192, 204, 192, 204, 192, 204, 192, 10, 10, 20, 12, 0, 0, 207, 0, 223,
  128, 249, 192, 240, 192, 224, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 10, 10, 20, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 14, 28, 12, 0,
  252, 255, 0, 255, 128, 193, 192, 192, 192, 192, 192, 192, 192, 192, 192, 193,
  192, 255, 128, 255, 0, 192, 0, 192, 0, 192, 0, 192, 0, 10, 14, 28,
  12, 0, 252, 63, 192, 127, 192, 224, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 224, 192, 127, 192, 63, 192, 0, 192, 0, 192, 0, 192, 0, 192, 10,
  10, 20, 12, 0, 0, 207, 0, 223, 128, 249, 192, 240, 192, 224, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 10, 10, 20, 12, 0, 0, 63,
  192, 127, 192, 192, 0, 192, 0, 127, 0, 63, 128, 0, 192, 0, 192, 255,
  128, 255, 0, 8, 14, 14, 12, 2, 0, 48, 48, 48, 48, 252, 252, 48,
  48, 48, 48, 48, 56, 31, 15, 10, 10, 20, 12, 0, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 193, 192, 195, 192, 231, 192, 126, 192, 60,
  192, 10, 10, 20, 12, 0, 0, 192, 192, 192, 192, 192, 192, 97, 128, 97,
  128, 51, 128, 51, 0, 30, 0, 30, 0, 12, 0, 10, 10, 20, 12, 0,
  0, 204, 192, 204, 192, 204, 192, 204, 192, 204, 192, 204, 192, 204, 192, 204,
  192, 127, 128, 51, 0, 10, 10, 20, 12, 0, 0, 192, 192, 225, 192, 115,
  128, 63, 0, 30, 0, 30, 0, 63, 0, 115, 128, 225, 192, 192, 192, 10,
  14, 28, 12, 0, 252, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 224, 192, 127, 192, 63, 192, 0, 192, 1, 192, 63, 128, 63,
  0, 10, 10, 20, 12, 0, 0, 255, 192, 255, 192, 3, 128, 7, 0, 14,
  0, 28, 0, 56, 0, 112, 0, 255, 192, 255, 192, 6, 22, 22, 12, 2,
  252, 12, 28, 56, 48, 48, 48, 48, 48, 48, 112, 224, 224, 112, 48, 48,
  48, 48, 48, 48, 56, 28, 12, 2, 18, 18, 12, 4, 254, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 6,
  22, 22, 12, 2, 252, 192, 224, 112, 48, 48, 48, 48, 48, 48, 56, 28,
  28, 56, 48, 48, 48, 48, 48, 48, 112, 224, 192, 10, 4, 8, 12, 0,
  6, 48, 192, 124, 192, 207, 128, 195, 0, 0, 0, 0, 12, 0, 0, 0,
  0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 4, 7, 7, 12, 0,
  253, 48, 48, 48, 48, 112, 224, 64, 10, 22, 44, 12, 0, 252, 3, 192,
  7, 192, 14, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 63, 0,
  63, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0,
  12, 0, 12, 0, 28, 0, 248, 0, 240, 0, 8, 7, 7, 12, 0, 253,
  51, 51, 51, 51, 119, 238, 68, 10, 2, 4, 12, 0, 0, 204, 192, 204,
  192, 6, 10, 10, 12, 2, 4, 48, 48, 252, 252, 48, 48, 48, 48, 48,
  48, 6, 10, 10, 12, 2, 4, 48, 48, 252, 252, 48, 48, 252, 252, 48,
  48, 6, 4, 4, 12, 2, 12, 48, 120, 252, 204, 12, 16, 32, 12, 0,
  0, 63, 240, 127, 240, 204, 224, 205, 192, 207, 128, 207, 0, 126, 0, 60,
  0, 60, 192, 127, 224, 243, 48, 243, 48, 179, 48, 51, 48, 31, 224, 12,
  192, 10, 18, 36, 12, 0, 0, 51, 0, 63, 0, 30, 0, 12, 0, 63,
  0, 127, 128, 225, 192, 192, 192, 192, 0, 224, 0, 127, 0, 63, 128, 1,
  192, 0, 192, 192, 192, 225, 192, 127, 128, 63, 0, 4, 10, 10, 12, 0,
  255, 48, 112, 96, 224, 192, 192, 224, 96, 112, 48, 10, 14, 28, 12, 0,
  0, 63, 192, 127, 192, 236, 0, 204, 0, 204, 0, 204, 0, 207, 0, 207,
  0, 204, 0, 204, 0, 204, 0, 236, 0, 127, 192, 63, 192, 0, 0, 0,
  12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0,
  0, 0, 12, 0, 0, 4, 7, 7, 12, 4, 8, 32, 112, 224, 192, 192,
  192, 192, 4, 7, 7, 12, 4, 7, 48, 48, 48, 48, 112, 224, 64, 8,
  7, 7, 12, 2, 8, 34, 119, 238, 204, 204, 204, 204, 8, 7, 7, 12,
  2, 7, 51, 51, 51, 51, 119, 238, 68, 10, 10, 20, 12, 0, 2, 30,
  0, 127, 128, 127, 128, 255, 192, 255, 192, 255, 192, 255, 192, 127, 128, 127,
  128, 30, 0, 6, 2, 2, 12, 2, 6, 252, 252, 12, 2, 4, 12, 0,
  6, 255, 240, 255, 240, 10, 4, 8, 12, 0, 12, 48, 192, 124, 192, 207,
  128, 195, 0, 12, 6, 12, 12, 0, 8, 255, 48, 255, 240, 51, 240, 51,
  240, 51, 48, 51, 48, 10, 16, 32, 12, 0, 0, 51, 0, 63, 0, 30,
  0, 12, 0, 0, 0, 0, 0, 63, 192, 127, 192, 192, 0, 192, 0, 127,
  0, 63, 128, 0, 192, 0, 192, 255, 128, 255, 0, 4, 10, 10, 12, 0,
  255, 192, 224, 96, 112, 48, 48, 112, 96, 224, 192, 10, 10, 20, 12, 0,
  0, 51, 0, 127, 128, 204, 192, 204, 192, 207, 192, 207, 192, 204, 0, 204,
  0, 127, 192, 51, 192, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0,
  0, 10, 18, 36, 12, 0, 0, 51, 0, 51, 0, 0, 0, 0, 0, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 225, 192, 115, 128, 63, 0, 30,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 0, 0, 0, 12, 0,
  0, 2, 14, 14, 12, 6, 0, 192, 192, 0, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 10, 14, 28, 12, 0, 254, 12, 0, 12, 0, 63,
  0, 127, 128, 237, 192, 204, 192, 204, 0, 204, 0, 204, 0, 236, 0, 127,
  192, 63, 192, 12, 0, 12, 0, 10, 16, 32, 12, 0, 0, 60, 0, 126,
  0, 231, 0, 195, 0, 192, 0, 192, 0, 252, 0, 252, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 192, 193, 192, 255, 128, 255, 0, 10, 10, 20,
  12, 0, 0, 64, 128, 225, 192, 127, 128, 63, 0, 51, 0, 51, 0, 63,
  0, 127, 128, 225, 192, 64, 128, 10, 14, 28, 12, 0, 0, 192, 192, 225,
  192, 115, 128, 63, 0, 255, 192, 255, 192, 12, 0, 12, 0, 255, 192, 255,
  192, 12, 0, 12, 0, 12, 0, 12, 0, 2, 18, 18, 12, 4, 254, 192,
  192, 192, 192, 192, 192, 192, 192, 0, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 10, 20, 40, 12, 0, 254, 31, 0, 127, 128, 97, 192, 224, 192, 112,
  192, 56, 192, 220, 0, 206, 0, 199, 0, 227, 128, 113, 192, 56, 192, 28,
  192, 14, 192, 199, 0, 195, 128, 193, 192, 225, 128, 127, 128, 62, 0, 6,
  2, 2, 12, 2, 12, 204, 204, 10, 14, 28, 12, 0, 0, 120, 0, 254,
  0, 135, 0, 1, 128, 61, 128, 124, 192, 192, 192, 192, 192, 124, 192, 61,
  128, 1, 128, 135, 0, 254, 0, 120, 0, 8, 12, 12, 12, 2, 6, 63,
  127, 227, 195, 195, 227, 127, 63, 0, 0, 255, 255, 10, 10, 20, 12, 0,
  255, 48, 192, 113, 192, 97, 128, 227, 128, 195, 0, 195, 0, 227, 128, 97,
  128, 113, 192, 48, 192, 10, 6, 12, 12, 0, 2, 255, 192, 255, 192, 0,
  192, 0, 192, 0, 192, 0, 192, 10, 2, 4, 12, 0, 6, 255, 192, 255,
  192, 10, 12, 24, 12, 0, 2, 120, 0, 254, 0, 135, 0, 1, 128, 241,
  128, 248, 192, 204, 192, 204, 192, 248, 192, 249, 192, 223, 128, 207, 0, 6,
  2, 2, 12, 2, 12, 252, 252, 8, 8, 8, 12, 2, 8, 60, 126, 231,
  195, 195, 231, 126, 60, 10, 12, 24, 12, 0, 0, 12, 0, 12, 0, 12,
  0, 12, 0, 255, 192, 255, 192, 12, 0, 12, 0, 12, 0, 12, 0, 255,
  192, 255, 192, 5, 7, 7, 12, 3, 11, 112, 136, 8, 16, 32, 64, 248,
  5, 7, 7, 12, 3, 11, 112, 136, 8, 48, 8, 136, 112, 4, 4, 4,
  12, 4, 12, 48, 112, 224, 192, 10, 14, 28, 12, 0, 252, 195, 0, 195,
  0, 195, 0, 195, 0, 195, 0, 195, 0, 195, 0, 199, 128, 255, 192, 252,
  192, 192, 0, 192, 0, 192, 0, 192, 0, 10, 16, 32, 12, 0, 0, 31,
  192, 127, 192, 124, 192, 236, 192, 204, 192, 204, 192, 236, 192, 124, 192, 127,
  192, 31, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 12, 192, 4,
  4, 4, 12, 4, 4, 96, 240, 240, 96, 4, 6, 6, 12, 2, 252, 240,
  240, 48, 112, 224, 64, 5, 7, 7, 12, 3, 11, 32, 224, 32, 32, 32,
  32, 248, 8, 12, 12, 12, 2, 6, 60, 126, 231, 195, 195, 231, 126, 60,
  0, 0, 255, 255, 10, 10, 20, 12, 0, 255, 195, 0, 227, 128, 97, 128,
  113, 192, 48, 192, 48, 192, 113, 192, 97, 128, 227, 128, 195, 0, 12, 18,
  36, 12, 0, 0, 16, 0, 112, 0, 16, 0, 16, 0, 16, 16, 16, 32,
  124, 64, 0, 128, 1, 0, 2, 0, 4, 0, 8, 64, 16, 192, 33, 64,
  66, 64, 131, 224, 0, 64, 0, 224, 12, 18, 36, 12, 0, 0, 16, 0,
  112, 0, 16, 0, 16, 0, 16, 16, 16, 32, 124, 64, 0, 128, 1, 0,
  2, 0, 4, 0, 9, 192, 18, 32, 32, 32, 64, 64, 128, 128, 1, 0,
  3, 224, 12, 18, 36, 12, 0, 0, 56, 0, 68, 0, 4, 0, 24, 0,
  4, 16, 68, 32, 56, 64, 0, 128, 1, 0, 2, 0, 4, 0, 8, 64,
  16, 192, 33, 64, 66, 64, 131, 224, 0, 64, 0, 224, 10, 14, 28, 12,
  0, 0, 12, 0, 12, 0, 0, 0, 0, 0, 12, 0, 28, 0, 56, 0,
  112, 0, 224, 0, 192, 0, 192, 192, 225, 192, 127, 128, 63, 0, 10, 18,
  36, 12, 0, 0, 48, 0, 56, 0, 28, 0, 12, 0, 12, 0, 30, 0,
  30, 0, 51, 0, 51, 0, 97, 128, 97, 128, 192, 192, 255, 192, 255, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 10, 18, 36, 12, 0, 0, 3, 0,
  7, 0, 14, 0, 12, 0, 12, 0, 30, 0, 30, 0, 51, 0, 51, 0,
  97, 128, 97, 128, 192, 192, 255, 192, 255, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 10, 18, 36, 12, 0, 0, 12, 0, 30, 0, 63, 0, 51, 0,
  12, 0, 30, 0, 30, 0, 51, 0, 51, 0, 97, 128, 97, 128, 192, 192,
  255, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 10, 18, 36, 12,
  0, 0, 48, 192, 124, 192, 207, 128, 195, 0, 12, 0, 30, 0, 30, 0,
  51, 0, 51, 0, 97, 128, 97, 128, 192, 192, 255, 192, 255, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 10, 18, 36, 12, 0, 0, 51, 0, 51, 0,
  0, 0, 0, 0, 12, 0, 30, 0, 30, 0, 51, 0, 51, 0, 97, 128,
  97, 128, 192, 192, 255, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  10, 18, 36, 12, 0, 0, 12, 0, 30, 0, 51, 0, 51, 0, 30, 0,
  30, 0, 30, 0, 51, 0, 51, 0, 97, 128, 97, 128, 192, 192, 255, 192,
  255, 192, 192, 192, 192, 192, 192, 192, 192, 192, 10, 14, 28, 12, 0, 0,
  63, 192, 127, 192, 236, 0, 204, 0, 204, 0, 204, 0, 255, 0, 255, 0,
  204, 0, 204, 0, 204, 0, 204, 0, 207, 192, 207, 192, 10, 18, 36, 12,
  0, 252, 63, 0, 127, 128, 225, 192, 192, 192, 192, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 192, 0, 192, 192, 225, 192, 127, 128, 63, 0, 12, 0,
  28, 0, 56, 0, 16, 0, 10, 18, 36, 12, 0, 0, 48, 0, 56, 0,
  28, 0, 12, 0, 255, 192, 255, 192, 192, 0, 192, 0, 192, 0, 192, 0,
  255, 0, 255, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 192, 255, 192,
  10, 18, 36, 12, 0, 0, 3, 0, 7, 0, 14, 0, 12, 0, 255, 192,
  255, 192, 192, 0, 192, 0, 192, 0, 192, 0, 255, 0, 255, 0, 192, 0,
  192, 0, 192, 0, 192, 0, 255, 192, 255, 192, 10, 18, 36, 12, 0, 0,
  12, 0, 30, 0, 63, 0, 51, 0, 255, 192, 255, 192, 192, 0, 192, 0,
  192, 0, 192, 0, 255, 0, 255, 0, 192, 0, 192, 0, 192, 0, 192, 0,
  255, 192, 255, 192, 10, 18, 36, 12, 0, 0, 51, 0, 51, 0, 0, 0,
  0, 0, 255, 192, 255, 192, 192, 0, 192, 0, 192, 0, 192, 0, 255, 0,
  255, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 192, 255, 192, 10, 18,
  36, 12, 0, 0, 48, 0, 56, 0, 28, 0, 12, 0, 255, 192, 255, 192,
  12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0,
  12, 0, 12, 0, 255, 192, 255, 192, 10, 18, 36, 12, 0, 0, 3, 0,
  7, 0, 14, 0, 12, 0, 255, 192, 255, 192, 12, 0, 12, 0, 12, 0,
  12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 255, 192,
  255, 192, 10, 18, 36, 12, 0, 0, 12, 0, 30, 0, 63, 0, 51, 0,
  255, 192, 255, 192, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0,
  12, 0, 12, 0, 12, 0, 12, 0, 255, 192, 255, 192, 10, 18, 36, 12,
  0, 0, 51, 0, 51, 0, 0, 0, 0, 0, 255, 192, 255, 192, 12, 0,
  12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0,
  12, 0, 255, 192, 255, 192, 10, 14, 28, 12, 0, 0, 63, 0, 63, 128,
  49, 192, 48, 192, 48, 192, 48, 192, 252, 192, 252, 192, 48, 192, 48, 192,
  48, 192, 49, 192, 63, 128, 63, 0, 10, 18, 36, 12, 0, 0, 48, 192,
  124, 192, 207, 128, 199, 0, 192, 192, 224, 192, 240, 192, 248, 192, 220, 192,
  206, 192, 199, 192, 195, 192, 193, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 10, 18, 36, 12, 0, 0, 48, 0, 56, 0, 28, 0, 12, 0,
  63, 0, 127, 128, 225, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 18, 36, 12,
  0, 0, 3, 0, 7, 0, 14, 0, 12, 0, 63, 0, 127, 128, 225, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  225, 192, 127, 128, 63, 0, 10, 18, 36, 12, 0, 0, 12, 0, 30, 0,
  63, 0, 51, 0, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0,
  10, 18, 36, 12, 0, 0, 48, 192, 124, 192, 207, 128, 199, 0, 63, 0,
  127, 128, 225, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 18, 36, 12, 0, 0,
  51, 0, 51, 0, 0, 0, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 225, 192,
  127, 128, 63, 0, 10, 10, 20, 12, 0, 2, 64, 128, 225, 192, 115, 128,
  63, 0, 30, 0, 30, 0, 63, 0, 115, 128, 225, 192, 64, 128, 10, 14,
  28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 193, 192, 195, 192, 199, 192,
  206, 192, 220, 192, 248, 192, 240, 192, 224, 192, 225, 192, 127, 128, 63, 0,
  10, 18, 36, 12, 0, 0, 48, 0, 56, 0, 28, 0, 12, 0, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 18, 36, 12, 0, 0,
  3, 0, 7, 0, 14, 0, 12, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 225, 192,
  127, 128, 63, 0, 10, 18, 36, 12, 0, 0, 12, 0, 30, 0, 63, 0,
  51, 0, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 18,
  36, 12, 0, 0, 51, 0, 51, 0, 0, 0, 0, 0, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 225, 192, 127, 128, 63, 0, 10, 18, 36, 12, 0, 0, 3, 0,
  7, 0, 14, 0, 12, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  225, 192, 115, 128, 63, 0, 30, 0, 12, 0, 12, 0, 12, 0, 12, 0,
  12, 0, 10, 14, 28, 12, 0, 0, 192, 0, 192, 0, 255, 0, 255, 128,
  193, 192, 192, 192, 192, 192, 193, 192, 255, 128, 255, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 10, 18, 36, 12, 0, 254, 15, 0, 31, 128, 57, 192,
  112, 192, 224, 192, 193, 192, 195, 128, 195, 0, 195, 0, 195, 128, 193, 192,
  192, 192, 192, 192, 193, 192, 207, 128, 207, 0, 192, 0, 192, 0, 10, 16,
  32, 12, 0, 0, 12, 0, 14, 0, 7, 0, 3, 0, 0, 0, 0, 0,
  63, 192, 127, 192, 224, 192, 192, 192, 192, 192, 193, 192, 195, 192, 231, 192,
  126, 192, 60, 192, 10, 16, 32, 12, 0, 0, 3, 0, 7, 0, 14, 0,
  12, 0, 0, 0, 0, 0, 63, 192, 127, 192, 224, 192, 192, 192, 192, 192,
  193, 192, 195, 192, 231, 192, 126, 192, 60, 192, 10, 16, 32, 12, 0, 0,
  12, 0, 30, 0, 63, 0, 51, 0, 0, 0, 0, 0, 63, 192, 127, 192,
  224, 192, 192, 192, 192, 192, 193, 192, 195, 192, 231, 192, 126, 192, 60, 192,
  10, 16, 32, 12, 0, 0, 48, 192, 124, 192, 207, 128, 199, 0, 0, 0,
  0, 0, 63, 192, 127, 192, 224, 192, 192, 192, 192, 192, 193, 192, 195, 192,
  231, 192, 126, 192, 60, 192, 10, 14, 28, 12, 0, 0, 51, 0, 51, 0,
  0, 0, 0, 0, 63, 192, 127, 192, 224, 192, 192, 192, 192, 192, 193, 192,
  195, 192, 231, 192, 126, 192, 60, 192, 10, 16, 32, 12, 0, 0, 12, 0,
  30, 0, 51, 0, 51, 0, 30, 0, 12, 0, 63, 192, 127, 192, 224, 192,
  192, 192, 192, 192, 193, 192, 195, 192, 231, 192, 126, 192, 60, 192, 10, 10,
  20, 12, 0, 0, 63, 0, 127, 128, 237, 192, 204, 192, 207, 192, 207, 192,
  204, 0, 236, 0, 127, 192, 63, 192, 10, 14, 28, 12, 0, 252, 63, 0,
  127, 128, 225, 192, 192, 192, 192, 0, 192, 0, 192, 0, 224, 0, 127, 192,
  63, 192, 12, 0, 28, 0, 56, 0, 16, 0, 10, 16, 32, 12, 0, 0,
  48, 0, 56, 0, 28, 0, 12, 0, 0, 0, 0, 0, 63, 0, 127, 128,
  225, 192, 192, 192, 255, 192, 255, 192, 192, 0, 224, 0, 127, 192, 63, 192,
  10, 16, 32, 12, 0, 0, 3, 0, 7, 0, 14, 0, 12, 0, 0, 0,
  0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 255, 192, 255, 192, 192, 0,
  224, 0, 127, 192, 63, 192, 10, 16, 32, 12, 0, 0, 12, 0, 30, 0,
  63, 0, 51, 0, 0, 0, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192,
  255, 192, 255, 192, 192, 0, 224, 0, 127, 192, 63, 192, 10, 14, 28, 12,
  0, 0, 51, 0, 51, 0, 0, 0, 0, 0, 63, 0, 127, 128, 225, 192,
  192, 192, 255, 192, 255, 192, 192, 0, 224, 0, 127, 192, 63, 192, 6, 16,
  16, 12, 2, 0, 192, 224, 112, 48, 0, 0, 240, 240, 48, 48, 48, 48,
  48, 48, 252, 252, 6, 16, 16, 12, 2, 0, 12, 28, 56, 48, 0, 0,
  240, 240, 48, 48, 48, 48, 48, 48, 252, 252, 6, 16, 16, 12, 2, 0,
  48, 120, 252, 204, 0, 0, 240, 240, 48, 48, 48, 48, 48, 48, 252, 252,
  6, 14, 14, 12, 2, 0, 204, 204, 0, 0, 240, 240, 48, 48, 48, 48,
  48, 48, 252, 252, 10, 17, 34, 12, 0, 0, 36, 0, 126, 0, 60, 0,
  60, 0, 126, 0, 39, 0, 3, 128, 63, 192, 127, 192, 225, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 16, 32, 12,
  0, 0, 48, 192, 124, 192, 207, 128, 199, 0, 0, 0, 0, 0, 207, 0,
  223, 128, 249, 192, 240, 192, 224, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 10, 16, 32, 12, 0, 0, 48, 0, 56, 0, 28, 0, 12, 0,
  0, 0, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 225, 192, 127, 128, 63, 0, 10, 16, 32, 12, 0, 0, 3, 0,
  7, 0, 14, 0, 12, 0, 0, 0, 0, 0, 63, 0, 127, 128, 225, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 16,
  32, 12, 0, 0, 12, 0, 30, 0, 63, 0, 51, 0, 0, 0, 0, 0,
  63, 0, 127, 128, 225, 192, 192, 192, 192, 192, 192, 192, 192, 192, 225, 192,
  127, 128, 63, 0, 10, 16, 32, 12, 0, 0, 48, 192, 124, 192, 207, 128,
  199, 0, 0, 0, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 14, 28, 12, 0, 0,
  51, 0, 51, 0, 0, 0, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 10, 20, 12,
  0, 2, 12, 0, 12, 0, 0, 0, 0, 0, 255, 192, 255, 192, 0, 0,
  0, 0, 12, 0, 12, 0, 10, 10, 20, 12, 0, 0, 63, 0, 127, 128,
  227, 192, 199, 192, 206, 192, 220, 192, 248, 192, 241, 192, 127, 128, 63, 0,
  10, 16, 32, 12, 0, 0, 48, 0, 56, 0, 28, 0, 12, 0, 0, 0,
  0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 193, 192, 195, 192,
  231, 192, 126, 192, 60, 192, 10, 16, 32, 12, 0, 0, 3, 0, 7, 0,
  14, 0, 12, 0, 0, 0, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 193, 192, 195, 192, 231, 192, 126, 192, 60, 192, 10, 16, 32, 12,
  0, 0, 12, 0, 30, 0, 63, 0, 51, 0, 0, 0, 0, 0, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 193, 192, 195, 192, 231, 192, 126, 192,
  60, 192, 10, 14, 28, 12, 0, 0, 51, 0, 51, 0, 0, 0, 0, 0,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 193, 192, 195, 192, 231, 192,
  126, 192, 60, 192, 10, 20, 40, 12, 0, 252, 3, 0, 7, 0, 14, 0,
  12, 0, 0, 0, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 224, 192, 127, 192, 63, 192, 0, 192, 1, 192, 63, 128,
  63, 0, 10, 18, 36, 12, 0, 252, 192, 0, 192, 0, 192, 0, 192, 0,
  255, 0, 255, 128, 193, 192, 192, 192, 192, 192, 192, 192, 192, 192, 193, 192,
  255, 128, 255, 0, 192, 0, 192, 0, 192, 0, 192, 0, 10, 18, 36, 12,
  0, 252, 51, 0, 51, 0, 0, 0, 0, 0, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 224, 192, 127, 192, 63, 192, 0, 192,
  1, 192, 63, 128, 63, 0
};

/*
  Fontname: ProFont22
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 14, '1' Height: 14
  Calculated Max Values w=12 h=22 x= 4 y=12 dx=12 dy= 0 ascent=18 len=40
  Font Bounding box     w=12 h=21 x= 0 y=-4
  Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
  Pure Font   ascent =14 descent=-4
  X Font      ascent =16 descent=-4
  Max Font    ascent =18 descent=-4
*/
const u8g_fntpgm_uint8_t u8g_font_profont22r[2719] U8G_FONT_SECTION("u8g_font_profont22r") = {
  0, 12, 21, 0, 252, 14, 3, 117, 7, 113, 32, 127, 252, 18, 252, 16,
  252, 0, 0, 0, 12, 0, 0, 2, 14, 14, 12, 4, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 0, 0, 192, 192, 6, 6, 6, 12, 2,
  10, 204, 204, 204, 204, 204, 204, 10, 10, 20, 12, 0, 4, 51, 0, 51,
  0, 255, 192, 255, 192, 51, 0, 51, 0, 255, 192, 255, 192, 51, 0, 51,
  0, 10, 18, 36, 12, 0, 254, 12, 0, 12, 0, 63, 0, 127, 128, 237,
  192, 204, 192, 204, 0, 236, 0, 127, 0, 63, 128, 13, 192, 12, 192, 204,
  192, 237, 192, 127, 128, 63, 0, 12, 0, 12, 0, 10, 14, 28, 12, 0,
  0, 63, 192, 127, 192, 204, 192, 205, 192, 207, 128, 207, 0, 127, 0, 63,
  128, 60, 192, 124, 192, 236, 192, 204, 192, 199, 128, 195, 0, 10, 14, 28,
  12, 0, 0, 62, 0, 127, 0, 227, 0, 199, 0, 206, 0, 252, 0, 120,
  0, 120, 0, 252, 192, 207, 192, 199, 128, 231, 128, 127, 192, 60, 192, 2,
  6, 6, 12, 4, 10, 192, 192, 192, 192, 192, 192, 6, 18, 18, 12, 2,
  254, 12, 28, 56, 112, 224, 192, 192, 192, 192, 192, 192, 192, 192, 224, 112,
  56, 28, 12, 6, 18, 18, 12, 2, 254, 192, 224, 112, 56, 28, 12, 12,
  12, 12, 12, 12, 12, 12, 28, 56, 112, 224, 192, 10, 10, 20, 12, 0,
  4, 12, 0, 12, 0, 204, 192, 255, 192, 63, 0, 63, 0, 255, 192, 204,
  192, 12, 0, 12, 0, 10, 10, 20, 12, 0, 2, 12, 0, 12, 0, 12,
  0, 12, 0, 255, 192, 255, 192, 12, 0, 12, 0, 12, 0, 12, 0, 5,
  9, 9, 12, 2, 252, 48, 120, 120, 56, 24, 56, 112, 224, 64, 6, 2,
  2, 12, 2, 6, 252, 252, 4, 4, 4, 12, 3, 1, 96, 240, 240, 96,
  11, 20, 40, 12, 0, 252, 0, 96, 0, 96, 0, 192, 0, 192, 1, 128,
  1, 128, 3, 0, 3, 0, 6, 0, 6, 0, 12, 0, 12, 0, 24, 0,
  24, 0, 48, 0, 48, 0, 96, 0, 96, 0, 192, 0, 192, 0, 10, 14,
  28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 193, 192, 195, 192, 199, 192,
  206, 192, 220, 192, 248, 192, 240, 192, 224, 192, 225, 192, 127, 128, 63, 0,
  10, 14, 28, 12, 0, 0, 12, 0, 12, 0, 124, 0, 124, 0, 12, 0,
  12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 255, 192,
  255, 192, 10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192,
  0, 192, 1, 192, 3, 128, 7, 0, 14, 0, 28, 0, 56, 0, 112, 0,
  255, 192, 255, 192, 10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192,
  192, 192, 0, 192, 1, 128, 15, 0, 15, 128, 1, 192, 0, 192, 192, 192,
  225, 192, 127, 128, 63, 0, 10, 14, 28, 12, 0, 0, 3, 0, 7, 0,
  15, 0, 31, 0, 59, 0, 115, 0, 227, 0, 195, 0, 255, 192, 255, 192,
  3, 0, 3, 0, 15, 192, 15, 192, 10, 14, 28, 12, 0, 0, 255, 192,
  255, 192, 192, 0, 192, 0, 255, 0, 255, 128, 1, 192, 0, 192, 0, 192,
  0, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 14, 28, 12, 0, 0,
  63, 0, 127, 0, 224, 0, 192, 0, 255, 0, 255, 128, 193, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 14, 28, 12,
  0, 0, 255, 192, 255, 192, 0, 192, 0, 192, 0, 192, 1, 192, 3, 128,
  7, 0, 14, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 10, 14,
  28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 192, 97, 128,
  63, 0, 127, 128, 225, 192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0,
  10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 224, 192, 127, 192, 63, 192, 0, 192, 1, 192, 63, 128,
  63, 0, 4, 10, 10, 12, 3, 1, 96, 240, 240, 96, 0, 0, 96, 240,
  240, 96, 5, 15, 15, 12, 2, 252, 48, 120, 120, 48, 0, 0, 48, 120,
  120, 56, 24, 56, 112, 224, 64, 8, 14, 14, 12, 2, 0, 3, 7, 14,
  28, 56, 112, 224, 224, 112, 56, 28, 14, 7, 3, 10, 6, 12, 12, 0,
  4, 255, 192, 255, 192, 0, 0, 0, 0, 255, 192, 255, 192, 8, 14, 14,
  12, 2, 0, 192, 224, 112, 56, 28, 14, 7, 7, 14, 28, 56, 112, 224,
  192, 10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 0,
  192, 1, 192, 3, 128, 7, 0, 14, 0, 12, 0, 0, 0, 0, 0, 12,
  0, 12, 0, 10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192,
  192, 199, 192, 207, 192, 204, 192, 204, 192, 207, 192, 199, 128, 192, 0, 224,
  0, 127, 192, 63, 192, 10, 14, 28, 12, 0, 0, 12, 0, 30, 0, 30,
  0, 51, 0, 51, 0, 97, 128, 97, 128, 192, 192, 255, 192, 255, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 10, 14, 28, 12, 0, 0, 255, 0, 255,
  128, 193, 192, 192, 192, 192, 192, 193, 128, 255, 0, 255, 128, 193, 192, 192,
  192, 192, 192, 193, 192, 255, 128, 255, 0, 10, 14, 28, 12, 0, 0, 63,
  0, 127, 128, 225, 192, 192, 192, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 192, 225, 192, 127, 128, 63, 0, 10, 14, 28, 12, 0,
  0, 255, 0, 255, 128, 193, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 193, 192, 255, 128, 255, 0, 10, 14, 28,
  12, 0, 0, 255, 192, 255, 192, 192, 0, 192, 0, 192, 0, 192, 0, 255,
  0, 255, 0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 192, 255, 192, 10,
  14, 28, 12, 0, 0, 255, 192, 255, 192, 192, 0, 192, 0, 192, 0, 192,
  0, 255, 0, 255, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192,
  0, 192, 0, 195, 192, 195, 192, 192, 192, 192, 192, 192, 192, 225, 192, 127,
  128, 63, 0, 10, 14, 28, 12, 0, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 255, 192, 255, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 10, 14, 28, 12, 0, 0, 255, 192, 255, 192, 12,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12,
  0, 12, 0, 255, 192, 255, 192, 10, 14, 28, 12, 0, 0, 0, 192, 0,
  192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 192, 192, 192,
  192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 14, 28, 12, 0, 0, 193,
  192, 195, 128, 199, 0, 206, 0, 220, 0, 248, 0, 240, 0, 248, 0, 220,
  0, 206, 0, 199, 0, 195, 128, 193, 192, 192, 192, 10, 14, 28, 12, 0,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 192, 255, 192, 10, 14, 28,
  12, 0, 0, 192, 192, 225, 192, 243, 192, 255, 192, 222, 192, 204, 192, 204,
  192, 204, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 10,
  14, 28, 12, 0, 0, 192, 192, 224, 192, 240, 192, 248, 192, 220, 192, 206,
  192, 199, 192, 195, 192, 193, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 10, 14, 28, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 225, 192, 127,
  128, 63, 0, 10, 14, 28, 12, 0, 0, 255, 0, 255, 128, 193, 192, 192,
  192, 192, 192, 193, 192, 255, 128, 255, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 10, 16, 32, 12, 0, 254, 63, 0, 127, 128, 225,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 204,
  192, 239, 192, 127, 128, 63, 128, 1, 192, 0, 192, 10, 14, 28, 12, 0,
  0, 255, 0, 255, 128, 193, 192, 192, 192, 192, 192, 193, 128, 255, 0, 255,
  128, 193, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 10, 14, 28,
  12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 0, 224, 0, 127,
  0, 63, 128, 1, 192, 0, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10,
  14, 28, 12, 0, 0, 255, 192, 255, 192, 12, 0, 12, 0, 12, 0, 12,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 12,
  0, 10, 14, 28, 12, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 225, 192, 127,
  128, 63, 0, 10, 14, 28, 12, 0, 0, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 97, 128, 97, 128, 51, 0, 51, 0, 30, 0, 30,
  0, 12, 0, 12, 0, 10, 14, 28, 12, 0, 0, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 204, 192, 204, 192, 204, 192, 222, 192, 255,
  192, 243, 192, 225, 192, 192, 192, 10, 14, 28, 12, 0, 0, 192, 192, 192,
  192, 192, 192, 225, 192, 115, 128, 63, 0, 30, 0, 30, 0, 63, 0, 115,
  128, 225, 192, 192, 192, 192, 192, 192, 192, 10, 14, 28, 12, 0, 0, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 225, 192, 115, 128, 63, 0, 30,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 12, 0, 10, 14, 28, 12, 0,
  0, 255, 192, 255, 192, 0, 192, 1, 192, 3, 128, 7, 0, 14, 0, 28,
  0, 56, 0, 112, 0, 224, 0, 192, 0, 255, 192, 255, 192, 4, 18, 18,
  12, 4, 254, 240, 240, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 240, 240, 11, 20, 40, 12, 1, 252, 192, 0, 192, 0, 96,
  0, 96, 0, 48, 0, 48, 0, 24, 0, 24, 0, 12, 0, 12, 0, 6,
  0, 6, 0, 3, 0, 3, 0, 1, 128, 1, 128, 0, 192, 0, 192, 0,
  96, 0, 96, 4, 18, 18, 12, 2, 254, 240, 240, 48, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 240, 240, 10, 6, 12, 12, 0,
  8, 12, 0, 30, 0, 63, 0, 115, 128, 225, 192, 64, 128, 12, 2, 4,
  12, 0, 252, 255, 240, 255, 240, 4, 4, 4, 12, 2, 12, 192, 224, 112,
  48, 10, 10, 20, 12, 0, 0, 63, 192, 127, 192, 224, 192, 192, 192, 192,
  192, 193, 192, 195, 192, 231, 192, 126, 192, 60, 192, 10, 14, 28, 12, 0,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 255, 0, 255, 128, 193, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 193, 192, 255, 128, 255, 0, 10, 10, 20,
  12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192, 0, 192, 0, 192,
  0, 224, 0, 127, 192, 63, 192, 10, 14, 28, 12, 0, 0, 0, 192, 0,
  192, 0, 192, 0, 192, 63, 192, 127, 192, 224, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 224, 192, 127, 192, 63, 192, 10, 10, 20, 12, 0, 0, 63,
  0, 127, 128, 225, 192, 192, 192, 255, 192, 255, 192, 192, 0, 224, 0, 127,
  192, 63, 192, 8, 14, 14, 12, 2, 0, 15, 31, 56, 48, 252, 252, 48,
  48, 48, 48, 48, 48, 48, 48, 10, 14, 28, 12, 0, 252, 63, 192, 127,
  192, 224, 192, 192, 192, 192, 192, 192, 192, 192, 192, 224, 192, 127, 192, 63,
  192, 0, 192, 1, 192, 63, 128, 63, 0, 10, 14, 28, 12, 0, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 255, 0, 255, 128, 193, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 6, 14, 14, 12, 2,
  0, 48, 48, 0, 0, 240, 240, 48, 48, 48, 48, 48, 48, 252, 252, 6,
  18, 18, 12, 0, 252, 12, 12, 0, 0, 60, 60, 12, 12, 12, 12, 12,
  12, 12, 12, 12, 28, 248, 240, 10, 14, 28, 12, 0, 0, 192, 0, 192,
  0, 192, 0, 192, 0, 195, 128, 199, 0, 206, 0, 220, 0, 252, 0, 254,
  0, 231, 0, 195, 128, 193, 192, 192, 192, 6, 14, 14, 12, 2, 0, 240,
  240, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 252, 252, 10, 10, 20,
  12, 0, 0, 255, 0, 255, 128, 205, 192, 204, 192, 204, 192, 204, 192, 204,
  192, 204, 192, 204, 192, 204, 192, 10, 10, 20, 12, 0, 0, 207, 0, 223,
  128, 249, 192, 240, 192, 224, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 10, 10, 20, 12, 0, 0, 63, 0, 127, 128, 225, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 225, 192, 127, 128, 63, 0, 10, 14, 28, 12, 0,
  252, 255, 0, 255, 128, 193, 192, 192, 192, 192, 192, 192, 192, 192, 192, 193,
  192, 255, 128, 255, 0, 192, 0, 192, 0, 192, 0, 192, 0, 10, 14, 28,
  12, 0, 252, 63, 192, 127, 192, 224, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 224, 192, 127, 192, 63, 192, 0, 192, 0, 192, 0, 192, 0, 192, 10,
  10, 20, 12, 0, 0, 207, 0, 223, 128, 249, 192, 240, 192, 224, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 10, 10, 20, 12, 0, 0, 63,
  192, 127, 192, 192, 0, 192, 0, 127, 0, 63, 128, 0, 192, 0, 192, 255,
  128, 255, 0, 8, 14, 14, 12, 2, 0, 48, 48, 48, 48, 252, 252, 48,
  48, 48, 48, 48, 56, 31, 15, 10, 10, 20, 12, 0, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 193, 192, 195, 192, 231, 192, 126, 192, 60,
  192, 10, 10, 20, 12, 0, 0, 192, 192, 192, 192, 192, 192, 97, 128, 97,
  128, 51, 128, 51, 0, 30, 0, 30, 0, 12, 0, 10, 10, 20, 12, 0,
  0, 204, 192, 204, 192, 204, 192, 204, 192, 204, 192, 204, 192, 204, 192, 204,
  192, 127, 128, 51, 0, 10, 10, 20, 12, 0, 0, 192, 192, 225, 192, 115,
  128, 63, 0, 30, 0, 30, 0, 63, 0, 115, 128, 225, 192, 192, 192, 10,
  14, 28, 12, 0, 252, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 224, 192, 127, 192, 63, 192, 0, 192, 1, 192, 63, 128, 63,
  0, 10, 10, 20, 12, 0, 0, 255, 192, 255, 192, 3, 128, 7, 0, 14,
  0, 28, 0, 56, 0, 112, 0, 255, 192, 255, 192, 6, 22, 22, 12, 2,
  252, 12, 28, 56, 48, 48, 48, 48, 48, 48, 112, 224, 224, 112, 48, 48,
  48, 48, 48, 48, 56, 28, 12, 2, 18, 18, 12, 4, 254, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 6,
  22, 22, 12, 2, 252, 192, 224, 112, 48, 48, 48, 48, 48, 48, 56, 28,
  28, 56, 48, 48, 48, 48, 48, 48, 112, 224, 192, 10, 4, 8, 12, 0,
  6, 48, 192, 124, 192, 207, 128, 195, 0, 0, 0, 0, 12, 0, 0
};

/*
  Fontname: ProFont29
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 19, '1' Height: 19
  Calculated Max Values w=16 h=29 x= 8 y=16 dx=16 dy= 0 ascent=24 len=58
  Font Bounding box     w=16 h=28 x= 0 y=-5
  Calculated Min Values           x= 0 y=-5 dx= 0 dy= 0
  Pure Font   ascent =19 descent=-5
  X Font      ascent =22 descent=-5
  Max Font    ascent =24 descent=-5
*/
const u8g_fntpgm_uint8_t u8g_font_profont29[8666] U8G_FONT_SECTION("u8g_font_profont29") = {
  0, 16, 28, 0, 251, 19, 4, 198, 9, 234, 32, 255, 251, 24, 251, 22,
  251, 0, 0, 0, 16, 0, 0, 3, 19, 19, 16, 5, 0, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 0, 0, 224, 224, 224,
  9, 9, 18, 16, 2, 13, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128,
  227, 128, 227, 128, 227, 128, 227, 128, 15, 15, 30, 16, 0, 5, 28, 112,
  28, 112, 28, 112, 255, 254, 255, 254, 255, 254, 28, 112, 28, 112, 28, 112,
  255, 254, 255, 254, 255, 254, 28, 112, 28, 112, 28, 112, 13, 25, 50, 16,
  0, 253, 7, 0, 7, 0, 7, 0, 15, 128, 63, 224, 127, 240, 119, 112,
  231, 56, 231, 56, 231, 0, 119, 0, 127, 128, 63, 224, 15, 240, 7, 112,
  7, 56, 231, 56, 231, 56, 119, 112, 127, 240, 63, 224, 15, 128, 7, 0,
  7, 0, 7, 0, 14, 19, 38, 16, 0, 0, 31, 252, 63, 252, 127, 252,
  102, 28, 231, 60, 231, 120, 231, 240, 103, 224, 127, 224, 63, 192, 31, 240,
  31, 48, 63, 56, 127, 56, 247, 56, 227, 48, 227, 240, 225, 224, 224, 192,
  14, 19, 38, 16, 0, 0, 15, 0, 63, 192, 127, 224, 112, 224, 225, 224,
  227, 192, 231, 128, 127, 0, 126, 0, 60, 0, 126, 8, 127, 28, 231, 188,
  227, 248, 225, 240, 113, 240, 127, 248, 63, 188, 14, 24, 3, 9, 9, 16,
  5, 13, 224, 224, 224, 224, 224, 224, 224, 224, 224, 9, 25, 50, 16, 3,
  253, 3, 0, 7, 128, 15, 0, 30, 0, 60, 0, 120, 0, 240, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 240, 0, 120, 0, 60, 0, 30, 0, 15, 0, 7,
  128, 3, 0, 9, 25, 50, 16, 2, 253, 96, 0, 240, 0, 120, 0, 60,
  0, 30, 0, 15, 0, 7, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3,
  128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 7, 128, 15,
  0, 30, 0, 60, 0, 120, 0, 240, 0, 96, 0, 13, 13, 26, 16, 0,
  5, 7, 0, 7, 0, 103, 48, 247, 248, 127, 240, 31, 192, 31, 192, 127,
  240, 255, 248, 103, 48, 7, 0, 7, 0, 7, 0, 13, 13, 26, 16, 0,
  3, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 255, 248, 255, 248, 255,
  248, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 6, 11, 11, 16, 3,
  251, 56, 124, 124, 124, 60, 28, 28, 60, 120, 240, 96, 8, 3, 3, 16,
  3, 8, 255, 255, 255, 5, 5, 5, 16, 4, 1, 112, 248, 248, 248, 112,
  15, 26, 52, 16, 0, 251, 0, 14, 0, 14, 0, 28, 0, 28, 0, 56,
  0, 56, 0, 112, 0, 112, 0, 224, 0, 224, 1, 192, 1, 192, 3, 128,
  3, 128, 7, 0, 7, 0, 14, 0, 14, 0, 28, 0, 28, 0, 56, 0,
  56, 0, 112, 0, 112, 0, 224, 0, 224, 0, 14, 19, 38, 16, 0, 0,
  15, 192, 63, 240, 127, 248, 112, 56, 224, 60, 224, 124, 224, 252, 225, 252,
  227, 220, 231, 156, 239, 28, 254, 28, 252, 28, 248, 28, 240, 28, 112, 56,
  127, 248, 63, 240, 15, 192, 13, 19, 38, 16, 0, 0, 7, 0, 7, 0,
  15, 0, 127, 0, 127, 0, 127, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 255, 248, 255, 248,
  255, 248, 14, 19, 38, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56,
  224, 28, 224, 28, 0, 28, 0, 56, 0, 120, 0, 240, 1, 224, 3, 192,
  7, 128, 15, 0, 30, 0, 60, 0, 127, 252, 255, 252, 255, 252, 14, 19,
  38, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  0, 28, 0, 120, 3, 240, 3, 224, 3, 240, 0, 120, 0, 28, 224, 28,
  224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 19, 38, 16, 0, 0,
  0, 224, 1, 224, 3, 224, 7, 224, 15, 224, 30, 224, 60, 224, 120, 224,
  240, 224, 224, 224, 255, 252, 255, 252, 255, 252, 0, 224, 0, 224, 0, 224,
  7, 252, 7, 252, 7, 252, 14, 19, 38, 16, 0, 0, 255, 252, 255, 252,
  255, 252, 224, 0, 224, 0, 255, 192, 255, 240, 255, 248, 0, 56, 0, 28,
  0, 28, 0, 28, 0, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240,
  15, 192, 14, 19, 38, 16, 0, 0, 15, 224, 63, 224, 127, 224, 112, 0,
  224, 0, 255, 192, 255, 240, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 19,
  38, 16, 0, 0, 255, 252, 255, 252, 255, 252, 0, 28, 0, 28, 0, 28,
  0, 60, 0, 120, 0, 240, 1, 224, 3, 192, 7, 128, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 14, 19, 38, 16, 0, 0,
  15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28, 224, 28, 120, 120,
  63, 240, 31, 224, 63, 240, 120, 120, 224, 28, 224, 28, 224, 28, 112, 56,
  127, 248, 63, 240, 15, 192, 14, 19, 38, 16, 0, 0, 15, 192, 63, 240,
  127, 248, 112, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  112, 28, 127, 252, 63, 252, 15, 252, 0, 28, 0, 56, 31, 248, 31, 240,
  31, 192, 5, 13, 13, 16, 4, 1, 112, 248, 248, 248, 112, 0, 0, 0,
  112, 248, 248, 248, 112, 6, 19, 19, 16, 3, 251, 56, 124, 124, 124, 56,
  0, 0, 0, 56, 124, 124, 124, 60, 28, 28, 60, 120, 240, 96, 12, 19,
  38, 16, 2, 0, 0, 96, 0, 240, 1, 224, 3, 192, 7, 128, 15, 0,
  30, 0, 60, 0, 120, 0, 240, 0, 120, 0, 60, 0, 30, 0, 15, 0,
  7, 128, 3, 192, 1, 224, 0, 240, 0, 96, 14, 9, 18, 16, 0, 5,
  255, 252, 255, 252, 255, 252, 0, 0, 0, 0, 0, 0, 255, 252, 255, 252,
  255, 252, 12, 19, 38, 16, 2, 0, 96, 0, 240, 0, 120, 0, 60, 0,
  30, 0, 15, 0, 7, 128, 3, 192, 1, 224, 0, 240, 1, 224, 3, 192,
  7, 128, 15, 0, 30, 0, 60, 0, 120, 0, 240, 0, 96, 0, 14, 19,
  38, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  0, 28, 0, 60, 0, 120, 0, 240, 1, 224, 3, 192, 7, 128, 7, 0,
  0, 0, 0, 0, 7, 0, 7, 0, 7, 0, 14, 19, 38, 16, 0, 0,
  15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 225, 252, 227, 252, 231, 252,
  231, 28, 231, 28, 231, 28, 231, 252, 227, 248, 225, 240, 224, 0, 112, 0,
  127, 252, 63, 252, 15, 252, 14, 19, 38, 16, 0, 0, 7, 128, 7, 128,
  15, 192, 15, 192, 28, 224, 28, 224, 56, 112, 56, 112, 112, 56, 112, 56,
  224, 28, 255, 252, 255, 252, 255, 252, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 14, 19, 38, 16, 0, 0, 255, 192, 255, 240, 255, 248, 224, 56,
  224, 28, 224, 28, 224, 28, 224, 120, 255, 240, 255, 224, 255, 240, 224, 120,
  224, 28, 224, 28, 224, 28, 224, 56, 255, 248, 255, 240, 255, 192, 14, 19,
  38, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 28,
  224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 19, 38, 16, 0, 0,
  255, 192, 255, 240, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 56,
  255, 248, 255, 240, 255, 192, 14, 19, 38, 16, 0, 0, 255, 252, 255, 252,
  255, 252, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 224, 255, 224,
  255, 224, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 252, 255, 252,
  255, 252, 14, 19, 38, 16, 0, 0, 255, 252, 255, 252, 255, 252, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 255, 224, 255, 224, 255, 224, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 14, 19,
  38, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  224, 0, 224, 0, 224, 252, 224, 252, 224, 252, 224, 28, 224, 28, 224, 28,
  224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 19, 38, 16, 0, 0,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  255, 252, 255, 252, 255, 252, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 13, 19, 38, 16, 0, 0, 255, 248, 255, 248,
  255, 248, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 255, 248, 255, 248,
  255, 248, 14, 19, 38, 16, 0, 0, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 13, 19,
  38, 16, 0, 0, 224, 56, 224, 120, 224, 240, 225, 224, 227, 192, 231, 128,
  239, 0, 254, 0, 252, 0, 248, 0, 252, 0, 254, 0, 239, 0, 231, 128,
  227, 192, 225, 224, 224, 240, 224, 120, 224, 56, 14, 19, 38, 16, 0, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  255, 252, 255, 252, 255, 252, 15, 19, 38, 16, 0, 0, 224, 14, 240, 30,
  248, 62, 252, 126, 254, 254, 239, 238, 231, 206, 227, 142, 227, 142, 227, 142,
  227, 142, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14,
  224, 14, 14, 19, 38, 16, 0, 0, 224, 28, 240, 28, 248, 28, 252, 28,
  254, 28, 239, 28, 231, 156, 227, 220, 225, 252, 224, 252, 224, 124, 224, 60,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 14, 19,
  38, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 19, 38, 16, 0, 0,
  255, 192, 255, 240, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 56,
  255, 248, 255, 240, 255, 192, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 14, 22, 44, 16, 0, 253, 15, 192, 63, 240,
  127, 248, 112, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 230, 28, 239, 28, 119, 248, 127, 248, 63, 240,
  15, 240, 0, 120, 0, 60, 0, 24, 14, 19, 38, 16, 0, 0, 255, 192,
  255, 240, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 120, 255, 240,
  255, 224, 255, 240, 224, 120, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 14, 19, 38, 16, 0, 0, 15, 192, 63, 240, 127, 248,
  112, 56, 224, 28, 224, 28, 224, 0, 112, 0, 127, 192, 63, 240, 15, 248,
  0, 56, 0, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192,
  13, 19, 38, 16, 0, 0, 255, 248, 255, 248, 255, 248, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 14, 19, 38, 16,
  0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  112, 56, 127, 248, 63, 240, 15, 192, 14, 19, 38, 16, 0, 0, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 56, 112, 56,
  56, 112, 56, 112, 28, 224, 28, 224, 15, 192, 15, 192, 7, 128, 7, 128,
  3, 0, 3, 0, 15, 19, 38, 16, 0, 0, 224, 14, 224, 14, 224, 14,
  224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 227, 142, 227, 142, 227, 142,
  227, 142, 231, 206, 239, 254, 254, 254, 252, 126, 248, 62, 240, 30, 224, 14,
  14, 19, 38, 16, 0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 240, 60,
  120, 120, 60, 240, 31, 224, 15, 192, 7, 128, 15, 192, 31, 224, 60, 240,
  120, 120, 240, 60, 224, 28, 224, 28, 224, 28, 224, 28, 13, 19, 38, 16,
  0, 0, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56,
  240, 120, 120, 240, 61, 224, 31, 192, 15, 128, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 14, 19, 38, 16, 0, 0, 255, 252,
  255, 252, 255, 252, 0, 28, 0, 60, 0, 120, 0, 240, 1, 224, 3, 192,
  7, 128, 15, 0, 30, 0, 60, 0, 120, 0, 240, 0, 224, 0, 255, 252,
  255, 252, 255, 252, 6, 25, 25, 16, 5, 253, 252, 252, 252, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  252, 252, 252, 15, 26, 52, 16, 1, 251, 224, 0, 224, 0, 112, 0, 112,
  0, 56, 0, 56, 0, 28, 0, 28, 0, 14, 0, 14, 0, 7, 0, 7,
  0, 3, 128, 3, 128, 1, 192, 1, 192, 0, 224, 0, 224, 0, 112, 0,
  112, 0, 56, 0, 56, 0, 28, 0, 28, 0, 14, 0, 14, 6, 25, 25,
  16, 2, 253, 252, 252, 252, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 252, 252, 252, 14, 8, 16, 16,
  0, 11, 3, 0, 7, 128, 15, 192, 31, 224, 60, 240, 120, 120, 240, 60,
  96, 24, 16, 3, 6, 16, 0, 251, 255, 255, 255, 255, 255, 255, 7, 6,
  6, 16, 2, 15, 96, 240, 120, 60, 30, 12, 14, 14, 28, 16, 0, 0,
  15, 252, 63, 252, 127, 252, 112, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 60, 224, 124, 113, 252, 127, 220, 63, 156, 14, 28, 14, 19, 38, 16,
  0, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 192, 255, 240,
  255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 56, 255, 248, 255, 240, 255, 192, 14, 14, 28, 16, 0, 0, 15, 192,
  63, 240, 127, 248, 112, 56, 224, 28, 224, 28, 224, 0, 224, 0, 224, 0,
  224, 0, 112, 0, 127, 252, 63, 252, 15, 252, 14, 19, 38, 16, 0, 0,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 15, 252, 63, 252, 127, 252,
  112, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 28,
  127, 252, 63, 252, 15, 252, 14, 14, 28, 16, 0, 0, 15, 192, 63, 240,
  127, 248, 112, 56, 224, 28, 224, 28, 255, 252, 255, 252, 255, 252, 224, 0,
  112, 0, 127, 252, 63, 252, 15, 252, 11, 19, 38, 16, 2, 0, 1, 224,
  7, 224, 15, 224, 14, 0, 28, 0, 255, 128, 255, 128, 255, 128, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 14, 19, 38, 16, 0, 251, 15, 252, 63, 252, 127, 252,
  112, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 28,
  127, 252, 63, 252, 15, 252, 0, 28, 0, 56, 31, 248, 31, 240, 31, 192,
  14, 19, 38, 16, 0, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  255, 192, 255, 240, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 9, 19, 38, 16,
  2, 0, 28, 0, 28, 0, 28, 0, 0, 0, 0, 0, 252, 0, 252, 0,
  252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 255, 128, 255, 128, 255, 128, 8, 24, 24, 16, 0, 251, 7, 7,
  7, 0, 0, 63, 63, 63, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 14, 254, 252, 240, 14, 19, 38, 16, 0, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 120, 224, 240, 225, 224, 227, 192, 231, 128,
  239, 0, 255, 0, 255, 128, 251, 192, 241, 224, 224, 240, 224, 120, 224, 60,
  224, 28, 9, 19, 38, 16, 2, 0, 252, 0, 252, 0, 252, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 255, 128, 255, 128, 255, 128, 15, 14,
  28, 16, 0, 0, 255, 224, 255, 248, 255, 252, 227, 156, 227, 142, 227, 142,
  227, 142, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142,
  14, 14, 28, 16, 0, 0, 225, 192, 231, 240, 239, 248, 254, 56, 248, 28,
  240, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 14, 14, 28, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 56, 127, 248,
  63, 240, 15, 192, 14, 19, 38, 16, 0, 251, 255, 192, 255, 240, 255, 248,
  224, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 56,
  255, 248, 255, 240, 255, 192, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  14, 19, 38, 16, 0, 251, 15, 252, 63, 252, 127, 252, 112, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 28, 127, 252, 63, 252,
  15, 252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 14, 14, 28, 16,
  0, 0, 225, 192, 231, 240, 239, 248, 254, 56, 248, 28, 240, 28, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 14, 14,
  28, 16, 0, 0, 15, 252, 63, 252, 127, 252, 240, 0, 224, 0, 255, 192,
  127, 240, 31, 248, 0, 60, 0, 28, 0, 60, 255, 248, 255, 240, 255, 192,
  11, 19, 38, 16, 2, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  255, 128, 255, 128, 255, 128, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 14, 0, 15, 224, 7, 224, 1, 224, 14, 14, 28, 16,
  0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 60, 224, 124, 113, 252, 127, 220, 63, 156, 14, 28, 14, 14,
  28, 16, 0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 56,
  112, 56, 56, 112, 56, 112, 28, 224, 28, 224, 15, 192, 15, 192, 7, 128,
  15, 14, 28, 16, 0, 0, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142,
  227, 142, 227, 142, 227, 142, 227, 142, 227, 142, 247, 222, 127, 252, 126, 252,
  28, 112, 14, 14, 28, 16, 0, 0, 224, 28, 224, 28, 240, 60, 120, 120,
  60, 240, 31, 224, 15, 192, 15, 192, 31, 224, 60, 240, 120, 120, 240, 60,
  224, 28, 224, 28, 14, 19, 38, 16, 0, 251, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 28,
  127, 252, 63, 252, 15, 252, 0, 28, 0, 56, 31, 248, 31, 240, 31, 192,
  13, 14, 28, 16, 0, 0, 255, 248, 255, 248, 255, 248, 0, 240, 1, 224,
  3, 192, 7, 128, 15, 0, 30, 0, 60, 0, 120, 0, 255, 248, 255, 248,
  255, 248, 9, 29, 58, 16, 3, 251, 3, 128, 15, 128, 15, 128, 30, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  60, 0, 248, 0, 224, 0, 248, 0, 60, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 30, 0, 15, 128, 15, 128,
  3, 128, 3, 25, 25, 16, 5, 253, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 9, 29, 58, 16, 2, 251, 224, 0, 248, 0, 248, 0, 60, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 30,
  0, 15, 128, 3, 128, 15, 128, 30, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 60, 0, 248, 0, 248, 0, 224,
  0, 13, 5, 10, 16, 0, 8, 60, 56, 127, 56, 255, 248, 231, 240, 225,
  224, 0, 0, 0, 16, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0,
  16, 0, 0, 5, 8, 8, 16, 0, 253, 56, 56, 56, 56, 56, 120, 240,
  96, 13, 29, 58, 16, 0, 251, 0, 120, 1, 248, 3, 248, 3, 128, 7,
  0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 31, 192, 31, 192, 31,
  192, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7,
  0, 7, 0, 7, 0, 7, 0, 7, 0, 14, 0, 254, 0, 252, 0, 240,
  0, 11, 8, 16, 16, 0, 253, 56, 224, 56, 224, 56, 224, 56, 224, 56,
  224, 121, 224, 243, 192, 97, 128, 13, 3, 6, 16, 0, 0, 231, 56, 231,
  56, 231, 56, 9, 14, 28, 16, 2, 5, 28, 0, 28, 0, 28, 0, 255,
  128, 255, 128, 255, 128, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 9, 14, 28, 16, 2, 5, 28, 0, 28, 0, 28,
  0, 255, 128, 255, 128, 255, 128, 28, 0, 28, 0, 255, 128, 255, 128, 255,
  128, 28, 0, 28, 0, 28, 0, 10, 6, 12, 16, 2, 16, 12, 0, 30,
  0, 63, 0, 127, 128, 243, 192, 97, 128, 15, 22, 44, 16, 0, 0, 31,
  254, 63, 254, 127, 254, 119, 30, 227, 60, 227, 120, 227, 240, 247, 224, 127,
  192, 127, 128, 63, 0, 15, 56, 63, 252, 127, 252, 253, 238, 248, 198, 216,
  198, 152, 198, 29, 238, 15, 252, 15, 252, 7, 56, 14, 24, 48, 16, 0,
  0, 24, 192, 61, 224, 31, 192, 15, 128, 7, 0, 15, 192, 63, 240, 127,
  248, 112, 56, 224, 28, 224, 28, 224, 0, 112, 0, 127, 192, 63, 240, 15,
  248, 0, 56, 0, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15,
  192, 5, 13, 13, 16, 0, 255, 48, 56, 112, 112, 224, 224, 224, 224, 224,
  112, 112, 56, 48, 14, 19, 38, 16, 0, 0, 15, 252, 63, 252, 127, 252,
  119, 0, 231, 0, 231, 0, 231, 0, 231, 0, 231, 224, 231, 224, 231, 224,
  231, 0, 231, 0, 231, 0, 231, 0, 119, 0, 127, 252, 63, 252, 15, 252,
  0, 0, 0, 16, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 16,
  0, 0, 0, 0, 0, 16, 0, 0, 5, 8, 8, 16, 5, 11, 48, 120,
  240, 224, 224, 224, 224, 224, 5, 8, 8, 16, 6, 11, 56, 56, 56, 56,
  56, 120, 240, 96, 11, 8, 16, 16, 2, 11, 48, 192, 121, 224, 243, 192,
  227, 128, 227, 128, 227, 128, 227, 128, 227, 128, 11, 8, 16, 16, 3, 11,
  56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 121, 224, 243, 192, 97, 128,
  13, 13, 26, 16, 0, 3, 15, 128, 63, 224, 127, 240, 127, 240, 255, 248,
  255, 248, 255, 248, 255, 248, 255, 248, 127, 240, 127, 240, 63, 224, 15, 128,
  8, 3, 3, 16, 3, 8, 255, 255, 255, 16, 3, 6, 16, 0, 8, 255,
  255, 255, 255, 255, 255, 13, 5, 10, 16, 0, 16, 60, 56, 127, 56, 255,
  248, 231, 240, 225, 224, 15, 8, 16, 16, 0, 11, 255, 206, 255, 254, 255,
  254, 57, 254, 57, 254, 57, 206, 57, 206, 57, 206, 14, 22, 44, 16, 0,
  0, 24, 96, 60, 240, 31, 224, 15, 192, 7, 128, 3, 0, 0, 0, 0,
  0, 15, 252, 63, 252, 127, 252, 240, 0, 224, 0, 255, 192, 127, 240, 31,
  248, 0, 60, 0, 28, 0, 60, 255, 248, 255, 240, 255, 192, 5, 13, 13,
  16, 0, 255, 96, 224, 112, 112, 56, 56, 56, 56, 56, 120, 112, 224, 96,
  14, 14, 28, 16, 0, 0, 60, 240, 127, 248, 127, 248, 231, 28, 231, 28,
  231, 28, 231, 252, 231, 252, 231, 252, 231, 0, 231, 0, 127, 252, 127, 252,
  60, 252, 0, 0, 0, 16, 0, 0, 0, 0, 0, 16, 0, 0, 13, 24,
  48, 16, 0, 0, 56, 224, 56, 224, 56, 224, 0, 0, 0, 0, 224, 56,
  224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 240, 120, 120, 240,
  61, 224, 31, 192, 15, 128, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 0, 0, 0, 16, 0, 0, 3, 19, 19, 16, 8, 0,
  224, 224, 224, 0, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 13, 20, 40, 16, 0, 253, 7, 0, 7, 0, 7, 0, 15,
  128, 63, 224, 127, 240, 119, 112, 231, 56, 231, 56, 231, 0, 231, 0, 231,
  0, 231, 0, 119, 0, 127, 248, 63, 248, 15, 248, 7, 0, 7, 0, 7,
  0, 13, 22, 44, 16, 0, 0, 14, 0, 63, 128, 127, 128, 113, 192, 224,
  224, 224, 224, 224, 0, 224, 0, 255, 0, 255, 0, 255, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 56, 224, 56, 224, 112, 255, 240, 255,
  224, 255, 128, 13, 13, 26, 16, 0, 0, 64, 16, 224, 56, 112, 112, 63,
  224, 31, 192, 29, 192, 24, 192, 29, 192, 31, 192, 63, 224, 112, 112, 224,
  56, 64, 16, 15, 19, 38, 16, 0, 0, 96, 12, 240, 30, 120, 60, 60,
  120, 30, 240, 127, 252, 127, 252, 127, 252, 3, 128, 3, 128, 3, 128, 127,
  252, 127, 252, 127, 252, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3,
  25, 25, 16, 5, 253, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  0, 0, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 14, 27,
  54, 16, 0, 253, 15, 192, 63, 240, 63, 248, 112, 56, 112, 28, 120, 28,
  60, 28, 30, 28, 239, 0, 231, 128, 227, 192, 225, 224, 240, 240, 120, 120,
  60, 60, 30, 28, 15, 28, 7, 156, 3, 220, 225, 224, 224, 240, 224, 120,
  224, 56, 112, 56, 127, 240, 63, 240, 15, 128, 8, 3, 3, 16, 3, 16,
  231, 231, 231, 14, 19, 38, 16, 0, 0, 28, 0, 255, 128, 255, 224, 193,
  240, 0, 112, 31, 56, 127, 56, 127, 24, 224, 28, 224, 28, 224, 28, 127,
  24, 127, 56, 31, 56, 0, 112, 193, 240, 255, 224, 255, 128, 28, 0, 12,
  16, 32, 16, 2, 8, 15, 240, 63, 240, 127, 240, 112, 112, 224, 112, 224,
  112, 224, 112, 112, 112, 127, 240, 63, 240, 15, 240, 0, 0, 0, 0, 255,
  240, 255, 240, 255, 240, 13, 13, 26, 16, 0, 255, 48, 48, 56, 56, 112,
  112, 112, 112, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 112, 112, 112,
  112, 56, 56, 48, 48, 14, 8, 16, 16, 0, 3, 255, 252, 255, 252, 255,
  252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 13, 3, 6, 16, 0,
  8, 255, 248, 255, 248, 255, 248, 14, 17, 34, 16, 0, 2, 28, 0, 255,
  128, 255, 224, 193, 240, 0, 112, 248, 56, 254, 56, 254, 24, 231, 28, 231,
  28, 231, 28, 254, 24, 254, 56, 254, 56, 239, 240, 231, 240, 227, 192, 8,
  3, 3, 16, 3, 16, 255, 255, 255, 12, 12, 24, 16, 2, 10, 15, 0,
  63, 192, 127, 224, 112, 224, 224, 112, 224, 112, 224, 112, 224, 112, 112, 224,
  127, 224, 63, 192, 15, 0, 13, 16, 32, 16, 0, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 255, 248, 255, 248, 255, 248, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 255, 248, 255, 248, 255, 248, 6, 9, 9, 16,
  4, 15, 120, 132, 4, 4, 8, 16, 32, 64, 252, 6, 9, 9, 16, 4,
  15, 120, 132, 4, 8, 48, 8, 4, 132, 120, 7, 6, 6, 16, 5, 16,
  12, 30, 60, 120, 240, 96, 14, 18, 36, 16, 0, 251, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 225, 240,
  255, 252, 255, 188, 254, 12, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  14, 22, 44, 16, 0, 0, 7, 252, 31, 252, 63, 252, 127, 28, 119, 28,
  231, 28, 231, 28, 231, 28, 231, 28, 119, 28, 127, 28, 63, 252, 31, 252,
  7, 252, 7, 28, 7, 28, 7, 28, 7, 28, 7, 28, 7, 28, 7, 28,
  7, 28, 5, 5, 5, 16, 5, 6, 112, 248, 248, 248, 112, 6, 8, 8,
  16, 3, 251, 252, 252, 252, 60, 124, 248, 240, 96, 7, 9, 9, 16, 4,
  15, 16, 112, 16, 16, 16, 16, 16, 16, 254, 11, 16, 32, 16, 3, 8,
  14, 0, 63, 128, 127, 192, 113, 192, 224, 224, 224, 224, 224, 224, 113, 192,
  127, 192, 63, 128, 14, 0, 0, 0, 0, 0, 255, 224, 255, 224, 255, 224,
  13, 13, 26, 16, 0, 255, 96, 96, 224, 224, 112, 112, 112, 112, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 112, 112, 112, 112, 224, 224, 96, 96,
  15, 24, 48, 16, 0, 0, 8, 0, 56, 0, 8, 0, 8, 0, 8, 0,
  8, 0, 8, 2, 8, 4, 127, 8, 0, 16, 0, 32, 0, 64, 0, 128,
  1, 0, 2, 0, 4, 8, 8, 24, 16, 40, 32, 72, 64, 136, 128, 254,
  0, 8, 0, 8, 0, 62, 15, 24, 48, 16, 0, 0, 8, 0, 56, 0,
  8, 0, 8, 0, 8, 0, 8, 0, 8, 2, 8, 4, 127, 8, 0, 16,
  0, 32, 0, 64, 0, 128, 1, 0, 2, 0, 4, 120, 8, 132, 16, 4,
  32, 4, 64, 8, 128, 16, 0, 32, 0, 64, 0, 252, 15, 24, 48, 16,
  0, 0, 30, 0, 33, 0, 1, 0, 2, 0, 12, 0, 2, 0, 1, 2,
  33, 4, 30, 8, 0, 16, 0, 32, 0, 64, 0, 128, 1, 0, 2, 0,
  4, 8, 8, 24, 16, 40, 32, 72, 64, 136, 128, 254, 0, 8, 0, 8,
  0, 62, 14, 19, 38, 16, 0, 0, 3, 128, 3, 128, 3, 128, 0, 0,
  0, 0, 3, 128, 7, 128, 15, 0, 30, 0, 60, 0, 120, 0, 240, 0,
  224, 0, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 24,
  48, 16, 0, 0, 24, 0, 60, 0, 30, 0, 15, 0, 7, 128, 7, 128,
  7, 128, 15, 192, 15, 192, 28, 224, 28, 224, 56, 112, 56, 112, 112, 56,
  112, 56, 224, 28, 255, 252, 255, 252, 255, 252, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 14, 24, 48, 16, 0, 0, 0, 96, 0, 240, 1, 224,
  3, 192, 7, 128, 7, 128, 7, 128, 15, 192, 15, 192, 28, 224, 28, 224,
  56, 112, 56, 112, 112, 56, 112, 56, 224, 28, 255, 252, 255, 252, 255, 252,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 14, 24, 48, 16, 0, 0,
  3, 0, 7, 128, 15, 192, 31, 224, 28, 224, 11, 64, 7, 128, 15, 192,
  15, 192, 28, 224, 28, 224, 56, 112, 56, 112, 112, 56, 112, 56, 224, 28,
  255, 252, 255, 252, 255, 252, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  14, 24, 48, 16, 0, 0, 60, 56, 127, 56, 255, 248, 231, 240, 225, 224,
  7, 128, 7, 128, 15, 192, 15, 192, 28, 224, 28, 224, 56, 112, 56, 112,
  112, 56, 112, 56, 224, 28, 255, 252, 255, 252, 255, 252, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 14, 24, 48, 16, 0, 0, 56, 112, 56, 112,
  56, 112, 0, 0, 0, 0, 7, 128, 7, 128, 15, 192, 15, 192, 28, 224,
  28, 224, 56, 112, 56, 112, 112, 56, 112, 56, 224, 28, 255, 252, 255, 252,
  255, 252, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 14, 24, 48, 16,
  0, 0, 7, 128, 15, 192, 28, 224, 24, 96, 28, 224, 15, 192, 7, 128,
  15, 192, 15, 192, 28, 224, 28, 224, 56, 112, 56, 112, 112, 56, 112, 56,
  224, 28, 255, 252, 255, 252, 255, 252, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 14, 19, 38, 16, 0, 0, 15, 252, 63, 252, 127, 252, 119, 0,
  231, 0, 231, 0, 231, 0, 231, 0, 255, 224, 255, 224, 255, 224, 231, 0,
  231, 0, 231, 0, 231, 0, 231, 0, 231, 252, 231, 252, 231, 252, 14, 24,
  48, 16, 0, 251, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 28,
  224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 7, 0, 15, 0, 30, 0,
  60, 0, 24, 0, 14, 24, 48, 16, 0, 0, 24, 0, 60, 0, 30, 0,
  15, 0, 7, 128, 255, 252, 255, 252, 255, 252, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 255, 224, 255, 224, 255, 224, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 255, 252, 255, 252, 255, 252, 14, 24, 48, 16, 0, 0,
  0, 96, 0, 240, 1, 224, 3, 192, 7, 128, 255, 252, 255, 252, 255, 252,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 224, 255, 224, 255, 224,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 252, 255, 252, 255, 252,
  14, 24, 48, 16, 0, 0, 3, 0, 7, 128, 15, 192, 31, 224, 28, 224,
  255, 252, 255, 252, 255, 252, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  255, 224, 255, 224, 255, 224, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  255, 252, 255, 252, 255, 252, 14, 24, 48, 16, 0, 0, 56, 112, 56, 112,
  56, 112, 0, 0, 0, 0, 255, 252, 255, 252, 255, 252, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 255, 224, 255, 224, 255, 224, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 255, 252, 255, 252, 255, 252, 13, 24, 48, 16,
  0, 0, 24, 0, 60, 0, 30, 0, 15, 0, 7, 0, 255, 248, 255, 248,
  255, 248, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 255, 248, 255, 248,
  255, 248, 13, 24, 48, 16, 0, 0, 0, 192, 1, 224, 3, 192, 7, 128,
  7, 0, 255, 248, 255, 248, 255, 248, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 255, 248, 255, 248, 255, 248, 13, 24, 48, 16, 0, 0, 2, 0,
  7, 0, 15, 128, 31, 192, 56, 224, 255, 248, 255, 248, 255, 248, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 255, 248, 255, 248, 255, 248, 13, 24,
  48, 16, 0, 0, 56, 224, 56, 224, 56, 224, 0, 0, 0, 0, 255, 248,
  255, 248, 255, 248, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 255, 248,
  255, 248, 255, 248, 14, 19, 38, 16, 0, 0, 31, 192, 31, 240, 31, 248,
  28, 56, 28, 28, 28, 28, 28, 28, 28, 28, 255, 156, 255, 156, 255, 156,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 56, 31, 248, 31, 240, 31, 192,
  14, 24, 48, 16, 0, 0, 60, 56, 127, 56, 255, 248, 231, 240, 225, 224,
  224, 28, 240, 28, 248, 28, 252, 28, 254, 28, 239, 28, 231, 156, 227, 220,
  225, 252, 224, 252, 224, 124, 224, 60, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 14, 24, 48, 16, 0, 0, 12, 0, 30, 0,
  15, 0, 7, 128, 3, 128, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 24, 48, 16,
  0, 0, 0, 192, 1, 224, 3, 192, 7, 128, 7, 0, 15, 192, 63, 240,
  127, 248, 112, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240,
  15, 192, 14, 24, 48, 16, 0, 0, 3, 0, 7, 128, 15, 192, 31, 224,
  60, 240, 24, 96, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  112, 56, 127, 248, 63, 240, 15, 192, 14, 24, 48, 16, 0, 0, 60, 56,
  127, 56, 255, 248, 231, 240, 225, 224, 15, 192, 63, 240, 127, 248, 112, 56,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 24,
  48, 16, 0, 0, 56, 112, 56, 112, 56, 112, 0, 0, 0, 0, 15, 192,
  63, 240, 127, 248, 112, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 56, 127, 248,
  63, 240, 15, 192, 14, 13, 26, 16, 0, 3, 96, 24, 240, 60, 120, 120,
  60, 240, 31, 224, 15, 192, 7, 128, 15, 192, 31, 224, 60, 240, 120, 120,
  240, 60, 96, 24, 14, 19, 38, 16, 0, 0, 15, 192, 63, 240, 127, 248,
  112, 56, 224, 60, 224, 124, 224, 252, 225, 252, 227, 220, 231, 156, 239, 28,
  254, 28, 252, 28, 248, 28, 240, 28, 112, 56, 127, 248, 63, 240, 15, 192,
  14, 24, 48, 16, 0, 0, 24, 0, 60, 0, 30, 0, 15, 0, 7, 128,
  227, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 56,
  127, 248, 63, 240, 15, 192, 14, 24, 48, 16, 0, 0, 0, 96, 0, 240,
  1, 224, 3, 192, 7, 128, 227, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 24, 48, 16,
  0, 0, 3, 0, 7, 128, 15, 192, 31, 224, 60, 240, 24, 96, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240,
  15, 192, 14, 24, 48, 16, 0, 0, 56, 112, 56, 112, 56, 112, 0, 0,
  0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  112, 56, 127, 248, 63, 240, 15, 192, 13, 24, 48, 16, 0, 0, 0, 96,
  0, 240, 1, 224, 3, 192, 7, 128, 227, 56, 224, 56, 224, 56, 224, 56,
  224, 56, 224, 56, 224, 56, 240, 120, 120, 240, 61, 224, 31, 192, 15, 128,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 14, 19,
  38, 16, 0, 0, 224, 0, 224, 0, 224, 0, 255, 192, 255, 240, 255, 248,
  224, 56, 224, 28, 224, 28, 224, 28, 224, 56, 255, 248, 255, 240, 255, 192,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 13, 25, 50, 16, 0, 253,
  3, 192, 7, 224, 15, 240, 30, 120, 60, 56, 120, 56, 240, 56, 224, 56,
  224, 112, 224, 224, 224, 224, 224, 224, 224, 224, 224, 112, 224, 56, 224, 56,
  224, 56, 224, 56, 224, 120, 227, 240, 227, 224, 227, 192, 224, 0, 224, 0,
  224, 0, 14, 22, 44, 16, 0, 0, 6, 0, 15, 0, 7, 128, 3, 192,
  1, 224, 0, 192, 0, 0, 0, 0, 15, 252, 63, 252, 127, 252, 112, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 60, 224, 124, 113, 252, 127, 220,
  63, 156, 14, 28, 14, 22, 44, 16, 0, 0, 0, 96, 0, 240, 1, 224,
  3, 192, 7, 128, 3, 0, 0, 0, 0, 0, 15, 252, 63, 252, 127, 252,
  112, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 60, 224, 124, 113, 252,
  127, 220, 63, 156, 14, 28, 14, 22, 44, 16, 0, 0, 3, 0, 7, 128,
  15, 192, 31, 224, 60, 240, 24, 96, 0, 0, 0, 0, 15, 252, 63, 252,
  127, 252, 112, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 60, 224, 124,
  113, 252, 127, 220, 63, 156, 14, 28, 14, 21, 42, 16, 0, 0, 60, 56,
  127, 56, 255, 248, 231, 240, 225, 224, 0, 0, 0, 0, 15, 252, 63, 252,
  127, 252, 112, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 60, 224, 124,
  113, 252, 127, 220, 63, 156, 14, 28, 14, 19, 38, 16, 0, 0, 56, 112,
  56, 112, 56, 112, 0, 0, 0, 0, 15, 252, 63, 252, 127, 252, 112, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 60, 224, 124, 113, 252, 127, 220,
  63, 156, 14, 28, 14, 21, 42, 16, 0, 0, 7, 192, 15, 224, 12, 96,
  12, 96, 12, 96, 15, 224, 7, 192, 15, 252, 63, 252, 127, 252, 112, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 60, 224, 124, 113, 252, 127, 220,
  63, 156, 14, 28, 14, 14, 28, 16, 0, 0, 15, 192, 63, 240, 127, 248,
  119, 120, 231, 60, 231, 28, 231, 252, 231, 252, 231, 252, 231, 0, 119, 0,
  127, 252, 63, 252, 15, 252, 14, 19, 38, 16, 0, 251, 15, 192, 63, 240,
  127, 248, 112, 56, 224, 28, 224, 28, 224, 0, 224, 0, 224, 0, 224, 0,
  112, 0, 127, 252, 63, 252, 15, 252, 7, 0, 15, 0, 30, 0, 60, 0,
  24, 0, 14, 22, 44, 16, 0, 0, 24, 0, 60, 0, 30, 0, 15, 0,
  7, 128, 3, 0, 0, 0, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56,
  224, 28, 224, 28, 255, 252, 255, 252, 255, 252, 224, 0, 112, 0, 127, 252,
  63, 252, 15, 252, 14, 22, 44, 16, 0, 0, 0, 96, 0, 240, 1, 224,
  3, 192, 7, 128, 3, 0, 0, 0, 0, 0, 15, 192, 63, 240, 127, 248,
  112, 56, 224, 28, 224, 28, 255, 252, 255, 252, 255, 252, 224, 0, 112, 0,
  127, 252, 63, 252, 15, 252, 14, 22, 44, 16, 0, 0, 3, 0, 7, 128,
  15, 192, 31, 224, 60, 240, 24, 96, 0, 0, 0, 0, 15, 192, 63, 240,
  127, 248, 112, 56, 224, 28, 224, 28, 255, 252, 255, 252, 255, 252, 224, 0,
  112, 0, 127, 252, 63, 252, 15, 252, 14, 19, 38, 16, 0, 0, 56, 112,
  56, 112, 56, 112, 0, 0, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56,
  224, 28, 224, 28, 255, 252, 255, 252, 255, 252, 224, 0, 112, 0, 127, 252,
  63, 252, 15, 252, 9, 22, 44, 16, 2, 0, 96, 0, 240, 0, 120, 0,
  60, 0, 30, 0, 12, 0, 0, 0, 0, 0, 252, 0, 252, 0, 252, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  255, 128, 255, 128, 255, 128, 9, 22, 44, 16, 2, 0, 3, 0, 7, 128,
  15, 0, 30, 0, 60, 0, 24, 0, 0, 0, 0, 0, 252, 0, 252, 0,
  252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 255, 128, 255, 128, 255, 128, 10, 22, 44, 16, 2, 0, 12, 0,
  30, 0, 63, 0, 127, 128, 243, 192, 97, 128, 0, 0, 0, 0, 252, 0,
  252, 0, 252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 255, 128, 255, 128, 255, 128, 9, 19, 38, 16, 2, 0,
  227, 128, 227, 128, 227, 128, 0, 0, 0, 0, 252, 0, 252, 0, 252, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  255, 128, 255, 128, 255, 128, 14, 23, 46, 16, 0, 0, 49, 128, 123, 192,
  63, 128, 31, 0, 31, 0, 63, 128, 123, 192, 49, 224, 0, 240, 15, 248,
  63, 252, 127, 252, 112, 60, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 21, 42, 16, 0, 0,
  60, 56, 127, 56, 255, 248, 231, 240, 225, 224, 0, 0, 0, 0, 225, 192,
  231, 240, 239, 248, 254, 56, 248, 28, 240, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 14, 22, 44, 16, 0, 0,
  24, 0, 60, 0, 30, 0, 15, 0, 7, 128, 3, 0, 0, 0, 0, 0,
  15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 22, 44, 16,
  0, 0, 0, 96, 0, 240, 1, 224, 3, 192, 7, 128, 3, 0, 0, 0,
  0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 22,
  44, 16, 0, 0, 3, 0, 7, 128, 15, 192, 31, 224, 60, 240, 24, 96,
  0, 0, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192,
  14, 21, 42, 16, 0, 0, 60, 56, 127, 56, 255, 248, 231, 240, 225, 224,
  0, 0, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192,
  14, 19, 38, 16, 0, 0, 56, 112, 56, 112, 56, 112, 0, 0, 0, 0,
  15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 13, 14, 28, 16,
  0, 2, 7, 0, 7, 0, 7, 0, 0, 0, 0, 0, 255, 248, 255, 248,
  255, 248, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 7, 0, 14, 14,
  28, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 120, 224, 252, 225, 220,
  227, 156, 231, 28, 238, 28, 252, 28, 120, 56, 127, 248, 63, 240, 15, 192,
  14, 22, 44, 16, 0, 0, 24, 0, 60, 0, 30, 0, 15, 0, 7, 128,
  3, 0, 0, 0, 0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 60, 224, 124, 113, 252, 127, 220, 63, 156,
  14, 28, 14, 22, 44, 16, 0, 0, 0, 96, 0, 240, 1, 224, 3, 192,
  7, 128, 3, 0, 0, 0, 0, 0, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 60, 224, 124, 113, 252, 127, 220,
  63, 156, 14, 28, 14, 22, 44, 16, 0, 0, 3, 0, 7, 128, 15, 192,
  31, 224, 60, 240, 24, 96, 0, 0, 0, 0, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 60, 224, 124, 113, 252,
  127, 220, 63, 156, 14, 28, 14, 19, 38, 16, 0, 0, 56, 112, 56, 112,
  56, 112, 0, 0, 0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 60, 224, 124, 113, 252, 127, 220, 63, 156,
  14, 28, 14, 27, 54, 16, 0, 251, 0, 96, 0, 240, 1, 224, 3, 192,
  7, 128, 3, 0, 0, 0, 0, 0, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 28, 127, 252,
  63, 252, 15, 252, 0, 28, 0, 56, 31, 248, 31, 240, 31, 192, 14, 24,
  48, 16, 0, 251, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 192,
  255, 240, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 56, 255, 248, 255, 240, 255, 192, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 14, 24, 48, 16, 0, 251, 56, 112, 56, 112, 56, 112,
  0, 0, 0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 112, 28, 127, 252, 63, 252, 31, 252,
  0, 28, 0, 56, 31, 248, 31, 240, 31, 224
};

/*
  Fontname: ProFont29
  Copyright: ProFont Distribution 2.2 - Generated by Fontographer 4.1.5
  Capital A Height: 19, '1' Height: 19
  Calculated Max Values w=16 h=29 x= 5 y=15 dx=16 dy= 0 ascent=24 len=58
  Font Bounding box     w=16 h=28 x= 0 y=-5
  Calculated Min Values           x= 0 y=-5 dx= 0 dy= 0
  Pure Font   ascent =19 descent=-5
  X Font      ascent =22 descent=-5
  Max Font    ascent =24 descent=-5
*/
const u8g_fntpgm_uint8_t u8g_font_profont29r[3719] U8G_FONT_SECTION("u8g_font_profont29r") = {
  0, 16, 28, 0, 251, 19, 4, 198, 9, 234, 32, 127, 251, 24, 251, 22,
  251, 0, 0, 0, 16, 0, 0, 3, 19, 19, 16, 5, 0, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 0, 0, 224, 224, 224,
  9, 9, 18, 16, 2, 13, 227, 128, 227, 128, 227, 128, 227, 128, 227, 128,
  227, 128, 227, 128, 227, 128, 227, 128, 15, 15, 30, 16, 0, 5, 28, 112,
  28, 112, 28, 112, 255, 254, 255, 254, 255, 254, 28, 112, 28, 112, 28, 112,
  255, 254, 255, 254, 255, 254, 28, 112, 28, 112, 28, 112, 13, 25, 50, 16,
  0, 253, 7, 0, 7, 0, 7, 0, 15, 128, 63, 224, 127, 240, 119, 112,
  231, 56, 231, 56, 231, 0, 119, 0, 127, 128, 63, 224, 15, 240, 7, 112,
  7, 56, 231, 56, 231, 56, 119, 112, 127, 240, 63, 224, 15, 128, 7, 0,
  7, 0, 7, 0, 14, 19, 38, 16, 0, 0, 31, 252, 63, 252, 127, 252,
  102, 28, 231, 60, 231, 120, 231, 240, 103, 224, 127, 224, 63, 192, 31, 240,
  31, 48, 63, 56, 127, 56, 247, 56, 227, 48, 227, 240, 225, 224, 224, 192,
  14, 19, 38, 16, 0, 0, 15, 0, 63, 192, 127, 224, 112, 224, 225, 224,
  227, 192, 231, 128, 127, 0, 126, 0, 60, 0, 126, 8, 127, 28, 231, 188,
  227, 248, 225, 240, 113, 240, 127, 248, 63, 188, 14, 24, 3, 9, 9, 16,
  5, 13, 224, 224, 224, 224, 224, 224, 224, 224, 224, 9, 25, 50, 16, 3,
  253, 3, 0, 7, 128, 15, 0, 30, 0, 60, 0, 120, 0, 240, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 240, 0, 120, 0, 60, 0, 30, 0, 15, 0, 7,
  128, 3, 0, 9, 25, 50, 16, 2, 253, 96, 0, 240, 0, 120, 0, 60,
  0, 30, 0, 15, 0, 7, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3,
  128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 7, 128, 15,
  0, 30, 0, 60, 0, 120, 0, 240, 0, 96, 0, 13, 13, 26, 16, 0,
  5, 7, 0, 7, 0, 103, 48, 247, 248, 127, 240, 31, 192, 31, 192, 127,
  240, 255, 248, 103, 48, 7, 0, 7, 0, 7, 0, 13, 13, 26, 16, 0,
  3, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 255, 248, 255, 248, 255,
  248, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 6, 11, 11, 16, 3,
  251, 56, 124, 124, 124, 60, 28, 28, 60, 120, 240, 96, 8, 3, 3, 16,
  3, 8, 255, 255, 255, 5, 5, 5, 16, 4, 1, 112, 248, 248, 248, 112,
  15, 26, 52, 16, 0, 251, 0, 14, 0, 14, 0, 28, 0, 28, 0, 56,
  0, 56, 0, 112, 0, 112, 0, 224, 0, 224, 1, 192, 1, 192, 3, 128,
  3, 128, 7, 0, 7, 0, 14, 0, 14, 0, 28, 0, 28, 0, 56, 0,
  56, 0, 112, 0, 112, 0, 224, 0, 224, 0, 14, 19, 38, 16, 0, 0,
  15, 192, 63, 240, 127, 248, 112, 56, 224, 60, 224, 124, 224, 252, 225, 252,
  227, 220, 231, 156, 239, 28, 254, 28, 252, 28, 248, 28, 240, 28, 112, 56,
  127, 248, 63, 240, 15, 192, 13, 19, 38, 16, 0, 0, 7, 0, 7, 0,
  15, 0, 127, 0, 127, 0, 127, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 255, 248, 255, 248,
  255, 248, 14, 19, 38, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56,
  224, 28, 224, 28, 0, 28, 0, 56, 0, 120, 0, 240, 1, 224, 3, 192,
  7, 128, 15, 0, 30, 0, 60, 0, 127, 252, 255, 252, 255, 252, 14, 19,
  38, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  0, 28, 0, 120, 3, 240, 3, 224, 3, 240, 0, 120, 0, 28, 224, 28,
  224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 19, 38, 16, 0, 0,
  0, 224, 1, 224, 3, 224, 7, 224, 15, 224, 30, 224, 60, 224, 120, 224,
  240, 224, 224, 224, 255, 252, 255, 252, 255, 252, 0, 224, 0, 224, 0, 224,
  7, 252, 7, 252, 7, 252, 14, 19, 38, 16, 0, 0, 255, 252, 255, 252,
  255, 252, 224, 0, 224, 0, 255, 192, 255, 240, 255, 248, 0, 56, 0, 28,
  0, 28, 0, 28, 0, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240,
  15, 192, 14, 19, 38, 16, 0, 0, 15, 224, 63, 224, 127, 224, 112, 0,
  224, 0, 255, 192, 255, 240, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 19,
  38, 16, 0, 0, 255, 252, 255, 252, 255, 252, 0, 28, 0, 28, 0, 28,
  0, 60, 0, 120, 0, 240, 1, 224, 3, 192, 7, 128, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 14, 19, 38, 16, 0, 0,
  15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28, 224, 28, 120, 120,
  63, 240, 31, 224, 63, 240, 120, 120, 224, 28, 224, 28, 224, 28, 112, 56,
  127, 248, 63, 240, 15, 192, 14, 19, 38, 16, 0, 0, 15, 192, 63, 240,
  127, 248, 112, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  112, 28, 127, 252, 63, 252, 15, 252, 0, 28, 0, 56, 31, 248, 31, 240,
  31, 192, 5, 13, 13, 16, 4, 1, 112, 248, 248, 248, 112, 0, 0, 0,
  112, 248, 248, 248, 112, 6, 19, 19, 16, 3, 251, 56, 124, 124, 124, 56,
  0, 0, 0, 56, 124, 124, 124, 60, 28, 28, 60, 120, 240, 96, 12, 19,
  38, 16, 2, 0, 0, 96, 0, 240, 1, 224, 3, 192, 7, 128, 15, 0,
  30, 0, 60, 0, 120, 0, 240, 0, 120, 0, 60, 0, 30, 0, 15, 0,
  7, 128, 3, 192, 1, 224, 0, 240, 0, 96, 14, 9, 18, 16, 0, 5,
  255, 252, 255, 252, 255, 252, 0, 0, 0, 0, 0, 0, 255, 252, 255, 252,
  255, 252, 12, 19, 38, 16, 2, 0, 96, 0, 240, 0, 120, 0, 60, 0,
  30, 0, 15, 0, 7, 128, 3, 192, 1, 224, 0, 240, 1, 224, 3, 192,
  7, 128, 15, 0, 30, 0, 60, 0, 120, 0, 240, 0, 96, 0, 14, 19,
  38, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  0, 28, 0, 60, 0, 120, 0, 240, 1, 224, 3, 192, 7, 128, 7, 0,
  0, 0, 0, 0, 7, 0, 7, 0, 7, 0, 14, 19, 38, 16, 0, 0,
  15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 225, 252, 227, 252, 231, 252,
  231, 28, 231, 28, 231, 28, 231, 252, 227, 248, 225, 240, 224, 0, 112, 0,
  127, 252, 63, 252, 15, 252, 14, 19, 38, 16, 0, 0, 7, 128, 7, 128,
  15, 192, 15, 192, 28, 224, 28, 224, 56, 112, 56, 112, 112, 56, 112, 56,
  224, 28, 255, 252, 255, 252, 255, 252, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 14, 19, 38, 16, 0, 0, 255, 192, 255, 240, 255, 248, 224, 56,
  224, 28, 224, 28, 224, 28, 224, 120, 255, 240, 255, 224, 255, 240, 224, 120,
  224, 28, 224, 28, 224, 28, 224, 56, 255, 248, 255, 240, 255, 192, 14, 19,
  38, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 28,
  224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 19, 38, 16, 0, 0,
  255, 192, 255, 240, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 56,
  255, 248, 255, 240, 255, 192, 14, 19, 38, 16, 0, 0, 255, 252, 255, 252,
  255, 252, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 224, 255, 224,
  255, 224, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 252, 255, 252,
  255, 252, 14, 19, 38, 16, 0, 0, 255, 252, 255, 252, 255, 252, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 255, 224, 255, 224, 255, 224, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 14, 19,
  38, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  224, 0, 224, 0, 224, 252, 224, 252, 224, 252, 224, 28, 224, 28, 224, 28,
  224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 19, 38, 16, 0, 0,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  255, 252, 255, 252, 255, 252, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 13, 19, 38, 16, 0, 0, 255, 248, 255, 248,
  255, 248, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 255, 248, 255, 248,
  255, 248, 14, 19, 38, 16, 0, 0, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 13, 19,
  38, 16, 0, 0, 224, 56, 224, 120, 224, 240, 225, 224, 227, 192, 231, 128,
  239, 0, 254, 0, 252, 0, 248, 0, 252, 0, 254, 0, 239, 0, 231, 128,
  227, 192, 225, 224, 224, 240, 224, 120, 224, 56, 14, 19, 38, 16, 0, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  255, 252, 255, 252, 255, 252, 15, 19, 38, 16, 0, 0, 224, 14, 240, 30,
  248, 62, 252, 126, 254, 254, 239, 238, 231, 206, 227, 142, 227, 142, 227, 142,
  227, 142, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 224, 14,
  224, 14, 14, 19, 38, 16, 0, 0, 224, 28, 240, 28, 248, 28, 252, 28,
  254, 28, 239, 28, 231, 156, 227, 220, 225, 252, 224, 252, 224, 124, 224, 60,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 14, 19,
  38, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 112, 56, 127, 248, 63, 240, 15, 192, 14, 19, 38, 16, 0, 0,
  255, 192, 255, 240, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 56,
  255, 248, 255, 240, 255, 192, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 14, 22, 44, 16, 0, 253, 15, 192, 63, 240,
  127, 248, 112, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 230, 28, 239, 28, 119, 248, 127, 248, 63, 240,
  15, 240, 0, 120, 0, 60, 0, 24, 14, 19, 38, 16, 0, 0, 255, 192,
  255, 240, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 120, 255, 240,
  255, 224, 255, 240, 224, 120, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 14, 19, 38, 16, 0, 0, 15, 192, 63, 240, 127, 248,
  112, 56, 224, 28, 224, 28, 224, 0, 112, 0, 127, 192, 63, 240, 15, 248,
  0, 56, 0, 28, 224, 28, 224, 28, 112, 56, 127, 248, 63, 240, 15, 192,
  13, 19, 38, 16, 0, 0, 255, 248, 255, 248, 255, 248, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 14, 19, 38, 16,
  0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  112, 56, 127, 248, 63, 240, 15, 192, 14, 19, 38, 16, 0, 0, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 56, 112, 56,
  56, 112, 56, 112, 28, 224, 28, 224, 15, 192, 15, 192, 7, 128, 7, 128,
  3, 0, 3, 0, 15, 19, 38, 16, 0, 0, 224, 14, 224, 14, 224, 14,
  224, 14, 224, 14, 224, 14, 224, 14, 224, 14, 227, 142, 227, 142, 227, 142,
  227, 142, 231, 206, 239, 254, 254, 254, 252, 126, 248, 62, 240, 30, 224, 14,
  14, 19, 38, 16, 0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 240, 60,
  120, 120, 60, 240, 31, 224, 15, 192, 7, 128, 15, 192, 31, 224, 60, 240,
  120, 120, 240, 60, 224, 28, 224, 28, 224, 28, 224, 28, 13, 19, 38, 16,
  0, 0, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56,
  240, 120, 120, 240, 61, 224, 31, 192, 15, 128, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 14, 19, 38, 16, 0, 0, 255, 252,
  255, 252, 255, 252, 0, 28, 0, 60, 0, 120, 0, 240, 1, 224, 3, 192,
  7, 128, 15, 0, 30, 0, 60, 0, 120, 0, 240, 0, 224, 0, 255, 252,
  255, 252, 255, 252, 6, 25, 25, 16, 5, 253, 252, 252, 252, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  252, 252, 252, 15, 26, 52, 16, 1, 251, 224, 0, 224, 0, 112, 0, 112,
  0, 56, 0, 56, 0, 28, 0, 28, 0, 14, 0, 14, 0, 7, 0, 7,
  0, 3, 128, 3, 128, 1, 192, 1, 192, 0, 224, 0, 224, 0, 112, 0,
  112, 0, 56, 0, 56, 0, 28, 0, 28, 0, 14, 0, 14, 6, 25, 25,
  16, 2, 253, 252, 252, 252, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 252, 252, 252, 14, 8, 16, 16,
  0, 11, 3, 0, 7, 128, 15, 192, 31, 224, 60, 240, 120, 120, 240, 60,
  96, 24, 16, 3, 6, 16, 0, 251, 255, 255, 255, 255, 255, 255, 7, 6,
  6, 16, 2, 15, 96, 240, 120, 60, 30, 12, 14, 14, 28, 16, 0, 0,
  15, 252, 63, 252, 127, 252, 112, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 60, 224, 124, 113, 252, 127, 220, 63, 156, 14, 28, 14, 19, 38, 16,
  0, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 255, 192, 255, 240,
  255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 56, 255, 248, 255, 240, 255, 192, 14, 14, 28, 16, 0, 0, 15, 192,
  63, 240, 127, 248, 112, 56, 224, 28, 224, 28, 224, 0, 224, 0, 224, 0,
  224, 0, 112, 0, 127, 252, 63, 252, 15, 252, 14, 19, 38, 16, 0, 0,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 15, 252, 63, 252, 127, 252,
  112, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 28,
  127, 252, 63, 252, 15, 252, 14, 14, 28, 16, 0, 0, 15, 192, 63, 240,
  127, 248, 112, 56, 224, 28, 224, 28, 255, 252, 255, 252, 255, 252, 224, 0,
  112, 0, 127, 252, 63, 252, 15, 252, 11, 19, 38, 16, 2, 0, 1, 224,
  7, 224, 15, 224, 14, 0, 28, 0, 255, 128, 255, 128, 255, 128, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 14, 19, 38, 16, 0, 251, 15, 252, 63, 252, 127, 252,
  112, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 28,
  127, 252, 63, 252, 15, 252, 0, 28, 0, 56, 31, 248, 31, 240, 31, 192,
  14, 19, 38, 16, 0, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  255, 192, 255, 240, 255, 248, 224, 56, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 9, 19, 38, 16,
  2, 0, 28, 0, 28, 0, 28, 0, 0, 0, 0, 0, 252, 0, 252, 0,
  252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 255, 128, 255, 128, 255, 128, 8, 24, 24, 16, 0, 251, 7, 7,
  7, 0, 0, 63, 63, 63, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 14, 254, 252, 240, 14, 19, 38, 16, 0, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 120, 224, 240, 225, 224, 227, 192, 231, 128,
  239, 0, 255, 0, 255, 128, 251, 192, 241, 224, 224, 240, 224, 120, 224, 60,
  224, 28, 9, 19, 38, 16, 2, 0, 252, 0, 252, 0, 252, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 255, 128, 255, 128, 255, 128, 15, 14,
  28, 16, 0, 0, 255, 224, 255, 248, 255, 252, 227, 156, 227, 142, 227, 142,
  227, 142, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142,
  14, 14, 28, 16, 0, 0, 225, 192, 231, 240, 239, 248, 254, 56, 248, 28,
  240, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 14, 14, 28, 16, 0, 0, 15, 192, 63, 240, 127, 248, 112, 56,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 56, 127, 248,
  63, 240, 15, 192, 14, 19, 38, 16, 0, 251, 255, 192, 255, 240, 255, 248,
  224, 56, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 56,
  255, 248, 255, 240, 255, 192, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0,
  14, 19, 38, 16, 0, 251, 15, 252, 63, 252, 127, 252, 112, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 28, 127, 252, 63, 252,
  15, 252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 14, 14, 28, 16,
  0, 0, 225, 192, 231, 240, 239, 248, 254, 56, 248, 28, 240, 28, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 14, 14,
  28, 16, 0, 0, 15, 252, 63, 252, 127, 252, 240, 0, 224, 0, 255, 192,
  127, 240, 31, 248, 0, 60, 0, 28, 0, 60, 255, 248, 255, 240, 255, 192,
  11, 19, 38, 16, 2, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  255, 128, 255, 128, 255, 128, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 14, 0, 15, 224, 7, 224, 1, 224, 14, 14, 28, 16,
  0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 60, 224, 124, 113, 252, 127, 220, 63, 156, 14, 28, 14, 14,
  28, 16, 0, 0, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 56,
  112, 56, 56, 112, 56, 112, 28, 224, 28, 224, 15, 192, 15, 192, 7, 128,
  15, 14, 28, 16, 0, 0, 227, 142, 227, 142, 227, 142, 227, 142, 227, 142,
  227, 142, 227, 142, 227, 142, 227, 142, 227, 142, 247, 222, 127, 252, 126, 252,
  28, 112, 14, 14, 28, 16, 0, 0, 224, 28, 224, 28, 240, 60, 120, 120,
  60, 240, 31, 224, 15, 192, 15, 192, 31, 224, 60, 240, 120, 120, 240, 60,
  224, 28, 224, 28, 14, 19, 38, 16, 0, 251, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 28,
  127, 252, 63, 252, 15, 252, 0, 28, 0, 56, 31, 248, 31, 240, 31, 192,
  13, 14, 28, 16, 0, 0, 255, 248, 255, 248, 255, 248, 0, 240, 1, 224,
  3, 192, 7, 128, 15, 0, 30, 0, 60, 0, 120, 0, 255, 248, 255, 248,
  255, 248, 9, 29, 58, 16, 3, 251, 3, 128, 15, 128, 15, 128, 30, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  60, 0, 248, 0, 224, 0, 248, 0, 60, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 30, 0, 15, 128, 15, 128,
  3, 128, 3, 25, 25, 16, 5, 253, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 9, 29, 58, 16, 2, 251, 224, 0, 248, 0, 248, 0, 60, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 30,
  0, 15, 128, 3, 128, 15, 128, 30, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 60, 0, 248, 0, 248, 0, 224,
  0, 13, 5, 10, 16, 0, 8, 60, 56, 127, 56, 255, 248, 231, 240, 225,
  224, 0, 0, 0, 16, 0, 0
};
