/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

/**
 * u8g_font_data_os.c
 */

#include "u8g.h"

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--25-250-72-72-P-136-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 18, '1' Height: 18
  Calculated Max Values w=26 h=24 x= 5 y=14 dx=27 dy= 0 ascent=24 len=72
  Font Bounding box     w=70 h=31 x=-22 y=-7
  Calculated Min Values           x=-1 y=-6 dx= 0 dy= 0
  Pure Font   ascent =18 descent=-6
  X Font      ascent =18 descent=-6
  Max Font    ascent =24 descent=-6
*/
const u8g_fntpgm_uint8_t u8g_font_osb18[7637] U8G_FONT_SECTION("u8g_font_osb18") = {
  0, 70, 31, 234, 249, 18, 4, 190, 10, 54, 32, 255, 250, 24, 250, 18,
  250, 0, 0, 0, 7, 0, 0, 4, 18, 18, 6, 1, 0, 96, 240, 240,
  240, 240, 240, 96, 96, 96, 96, 96, 64, 0, 0, 96, 240, 240, 96, 6,
  6, 6, 10, 2, 12, 204, 204, 204, 204, 204, 204, 15, 18, 36, 19, 2,
  0, 6, 24, 6, 24, 4, 16, 4, 16, 12, 48, 255, 254, 255, 254, 12,
  48, 8, 32, 8, 32, 24, 96, 24, 96, 255, 254, 255, 254, 16, 64, 16,
  64, 48, 192, 48, 192, 11, 22, 44, 14, 2, 254, 9, 0, 9, 0, 31,
  128, 105, 64, 73, 32, 201, 32, 201, 96, 249, 224, 249, 64, 127, 0, 63,
  128, 31, 192, 15, 192, 73, 224, 233, 224, 201, 96, 137, 96, 137, 96, 73,
  192, 63, 128, 9, 0, 9, 0, 17, 18, 54, 21, 2, 0, 56, 4, 0,
  68, 12, 0, 198, 8, 0, 198, 24, 0, 198, 48, 0, 198, 32, 0, 198,
  96, 0, 76, 64, 0, 56, 192, 0, 1, 142, 0, 1, 27, 0, 3, 49,
  128, 2, 49, 128, 4, 49, 128, 12, 49, 128, 8, 49, 128, 24, 17, 0,
  16, 14, 0, 17, 18, 54, 19, 1, 0, 3, 192, 0, 4, 32, 0, 12,
  32, 0, 12, 32, 0, 12, 32, 0, 14, 64, 0, 15, 128, 0, 7, 0,
  0, 15, 143, 128, 27, 195, 0, 49, 194, 0, 96, 226, 0, 224, 244, 0,
  224, 120, 0, 240, 56, 0, 240, 60, 0, 126, 223, 128, 63, 15, 0, 2,
  6, 6, 6, 2, 12, 192, 192, 192, 192, 192, 192, 7, 23, 23, 9, 1,
  251, 2, 4, 8, 16, 48, 96, 96, 96, 224, 224, 224, 224, 224, 224, 224,
  96, 96, 96, 48, 16, 8, 4, 2, 7, 23, 23, 9, 0, 251, 128, 64,
  32, 16, 24, 12, 12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 12, 12,
  24, 16, 32, 64, 128, 9, 10, 20, 13, 2, 8, 24, 0, 24, 0, 201,
  128, 235, 128, 28, 0, 44, 0, 235, 128, 217, 128, 24, 0, 24, 0, 21,
  21, 63, 23, 1, 253, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48,
  0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0,
  0, 48, 0, 255, 255, 248, 255, 255, 248, 0, 48, 0, 0, 48, 0, 0,
  48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48,
  0, 0, 48, 0, 4, 9, 9, 7, 2, 251, 224, 240, 240, 240, 16, 32,
  32, 64, 128, 6, 3, 3, 8, 1, 5, 252, 252, 252, 4, 4, 4, 8,
  2, 0, 96, 240, 240, 96, 9, 23, 46, 11, 1, 251, 1, 128, 1, 128,
  1, 0, 3, 0, 3, 0, 2, 0, 6, 0, 6, 0, 4, 0, 12, 0,
  12, 0, 8, 0, 24, 0, 24, 0, 24, 0, 16, 0, 48, 0, 48, 0,
  32, 0, 96, 0, 96, 0, 64, 0, 192, 0, 12, 18, 36, 15, 1, 0,
  15, 0, 25, 128, 48, 192, 112, 224, 112, 224, 240, 224, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 112, 224, 112, 224, 48, 192,
  25, 128, 15, 0, 8, 18, 18, 15, 3, 0, 24, 56, 248, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 255, 11, 18, 36, 15,
  2, 0, 31, 0, 113, 192, 96, 224, 224, 224, 240, 224, 248, 224, 121, 192,
  1, 192, 3, 0, 6, 0, 8, 0, 48, 32, 64, 32, 64, 32, 255, 224,
  191, 224, 143, 192, 135, 128, 12, 18, 36, 15, 1, 0, 31, 0, 49, 192,
  96, 224, 112, 224, 120, 224, 120, 224, 0, 192, 1, 128, 62, 0, 1, 192,
  0, 224, 0, 240, 112, 240, 248, 240, 240, 240, 192, 224, 65, 192, 63, 0,
  11, 18, 36, 15, 2, 0, 3, 0, 7, 0, 7, 0, 15, 0, 15, 0,
  23, 0, 55, 0, 39, 0, 103, 0, 71, 0, 199, 0, 135, 0, 255, 224,
  7, 0, 7, 0, 7, 0, 7, 0, 63, 224, 11, 18, 36, 15, 2, 0,
  65, 128, 127, 128, 126, 0, 120, 0, 64, 0, 64, 0, 95, 0, 99, 128,
  65, 192, 65, 224, 1, 224, 33, 224, 241, 224, 241, 224, 225, 192, 193, 192,
  67, 128, 62, 0, 11, 18, 36, 15, 2, 0, 7, 128, 24, 64, 48, 224,
  113, 224, 113, 224, 240, 0, 240, 0, 247, 128, 249, 192, 240, 224, 240, 224,
  240, 224, 240, 224, 112, 224, 112, 224, 48, 192, 57, 192, 15, 0, 11, 18,
  36, 15, 2, 0, 156, 64, 190, 96, 255, 32, 255, 224, 128, 32, 128, 64,
  128, 64, 0, 128, 1, 128, 3, 0, 7, 0, 6, 0, 14, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 12, 0, 12, 18, 36, 15, 1, 0, 31, 128,
  32, 64, 64, 32, 192, 32, 192, 32, 240, 32, 252, 64, 127, 128, 127, 192,
  63, 224, 103, 240, 193, 240, 192, 112, 192, 48, 192, 48, 96, 32, 112, 64,
  31, 128, 12, 18, 36, 15, 2, 0, 31, 0, 113, 128, 96, 192, 224, 224,
  224, 224, 224, 240, 224, 240, 96, 240, 113, 240, 30, 240, 0, 240, 0, 240,
  56, 224, 120, 224, 120, 224, 97, 192, 33, 128, 30, 0, 4, 12, 12, 8,
  2, 0, 96, 240, 240, 96, 0, 0, 0, 0, 96, 240, 240, 96, 4, 17,
  17, 7, 2, 251, 96, 240, 240, 96, 0, 0, 0, 0, 224, 240, 240, 240,
  16, 32, 32, 64, 128, 19, 21, 63, 24, 2, 252, 0, 0, 96, 0, 1,
  224, 0, 7, 128, 0, 14, 0, 0, 56, 0, 0, 224, 0, 3, 128, 0,
  15, 0, 0, 60, 0, 0, 112, 0, 0, 224, 0, 0, 120, 0, 0, 28,
  0, 0, 7, 0, 0, 1, 192, 0, 0, 112, 0, 0, 60, 0, 0, 15,
  0, 0, 3, 128, 0, 0, 224, 0, 0, 32, 21, 7, 21, 23, 1, 3,
  255, 255, 248, 255, 255, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255,
  255, 248, 255, 255, 248, 19, 21, 63, 24, 2, 252, 192, 0, 0, 240, 0,
  0, 60, 0, 0, 14, 0, 0, 3, 128, 0, 0, 224, 0, 0, 56, 0,
  0, 30, 0, 0, 7, 128, 0, 1, 192, 0, 0, 224, 0, 3, 192, 0,
  7, 0, 0, 28, 0, 0, 112, 0, 1, 192, 0, 7, 128, 0, 30, 0,
  0, 56, 0, 0, 224, 0, 0, 128, 0, 0, 8, 18, 18, 12, 2, 0,
  60, 78, 135, 135, 135, 78, 12, 24, 16, 32, 36, 36, 24, 0, 24, 60,
  60, 24, 18, 18, 54, 20, 1, 0, 3, 240, 0, 12, 12, 0, 24, 3,
  0, 48, 237, 0, 97, 173, 128, 99, 28, 128, 199, 28, 192, 207, 24, 192,
  206, 24, 192, 206, 56, 192, 206, 56, 192, 206, 56, 128, 78, 49, 128, 110,
  91, 0, 35, 156, 0, 48, 0, 0, 12, 4, 0, 3, 248, 0, 17, 18,
  54, 19, 1, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 1, 224, 0,
  1, 224, 0, 1, 224, 0, 2, 240, 0, 2, 240, 0, 4, 112, 0, 4,
  120, 0, 4, 120, 0, 8, 56, 0, 15, 252, 0, 8, 60, 0, 16, 28,
  0, 16, 30, 0, 48, 30, 0, 252, 127, 128, 15, 18, 36, 18, 2, 0,
  255, 224, 56, 56, 56, 56, 56, 28, 56, 28, 56, 28, 56, 56, 56, 48,
  63, 192, 56, 56, 56, 28, 56, 30, 56, 30, 56, 30, 56, 30, 56, 28,
  56, 56, 255, 240, 13, 18, 36, 17, 2, 0, 7, 136, 24, 120, 48, 56,
  112, 24, 112, 24, 240, 8, 240, 8, 240, 8, 240, 0, 240, 0, 240, 0,
  240, 8, 240, 8, 112, 8, 112, 8, 56, 16, 24, 32, 7, 192, 16, 18,
  36, 19, 2, 0, 255, 224, 56, 56, 56, 28, 56, 14, 56, 14, 56, 14,
  56, 15, 56, 15, 56, 15, 56, 15, 56, 15, 56, 15, 56, 14, 56, 14,
  56, 12, 56, 28, 56, 56, 255, 224, 14, 18, 36, 18, 2, 0, 255, 252,
  56, 28, 56, 12, 56, 12, 56, 4, 56, 68, 56, 64, 56, 192, 56, 192,
  63, 192, 56, 192, 56, 68, 56, 68, 56, 4, 56, 4, 56, 12, 56, 28,
  255, 252, 14, 18, 36, 17, 2, 0, 255, 252, 56, 60, 56, 28, 56, 12,
  56, 4, 56, 68, 56, 68, 56, 192, 56, 192, 63, 192, 56, 192, 56, 64,
  56, 64, 56, 0, 56, 0, 56, 0, 56, 0, 255, 0, 15, 18, 36, 18,
  2, 0, 7, 136, 24, 104, 48, 56, 112, 24, 112, 8, 112, 8, 240, 8,
  240, 0, 240, 0, 241, 254, 240, 56, 240, 56, 240, 56, 112, 56, 112, 56,
  48, 40, 24, 72, 15, 136, 17, 18, 54, 20, 2, 0, 255, 127, 128, 56,
  14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14,
  0, 56, 14, 0, 63, 254, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0,
  56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 255,
  127, 128, 8, 18, 18, 11, 2, 0, 255, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 255, 11, 18, 36, 13, 1, 0,
  31, 224, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128,
  3, 128, 3, 128, 3, 128, 115, 128, 243, 128, 243, 128, 227, 128, 195, 128,
  67, 0, 60, 0, 17, 18, 54, 19, 2, 0, 254, 127, 0, 56, 24, 0,
  56, 16, 0, 56, 32, 0, 56, 64, 0, 56, 192, 0, 57, 128, 0, 59,
  192, 0, 59, 192, 0, 61, 224, 0, 57, 240, 0, 56, 240, 0, 56, 248,
  0, 56, 120, 0, 56, 124, 0, 56, 60, 0, 56, 62, 0, 254, 127, 128,
  14, 18, 36, 17, 2, 0, 255, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 4, 56, 4, 56, 4,
  56, 12, 56, 12, 56, 28, 56, 60, 255, 252, 20, 18, 54, 22, 1, 0,
  254, 3, 240, 30, 3, 192, 30, 3, 192, 31, 5, 192, 31, 5, 192, 23,
  5, 192, 23, 133, 192, 23, 137, 192, 19, 201, 192, 19, 201, 192, 17, 209,
  192, 17, 241, 192, 17, 241, 192, 16, 241, 192, 16, 225, 192, 16, 225, 192,
  56, 97, 192, 254, 111, 240, 17, 18, 54, 18, 1, 0, 252, 63, 128, 60,
  14, 0, 62, 4, 0, 31, 4, 0, 31, 4, 0, 31, 132, 0, 23, 196,
  0, 19, 196, 0, 17, 228, 0, 17, 244, 0, 16, 244, 0, 16, 124, 0,
  16, 124, 0, 16, 60, 0, 16, 28, 0, 16, 28, 0, 56, 12, 0, 254,
  4, 0, 15, 18, 36, 18, 2, 0, 7, 192, 8, 32, 56, 48, 48, 24,
  112, 28, 112, 28, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  112, 28, 112, 28, 48, 24, 48, 56, 8, 32, 7, 192, 15, 18, 36, 18,
  2, 0, 255, 240, 56, 56, 56, 28, 56, 30, 56, 30, 56, 30, 56, 30,
  56, 28, 56, 56, 63, 224, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 255, 128, 15, 24, 48, 18, 2, 250, 7, 192, 8, 32,
  56, 56, 48, 24, 112, 28, 112, 28, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 112, 28, 112, 28, 51, 152, 52, 176, 28, 226, 7, 194,
  0, 194, 0, 194, 0, 230, 0, 254, 0, 124, 0, 56, 16, 18, 36, 19,
  2, 0, 255, 224, 56, 120, 56, 56, 56, 60, 56, 60, 56, 60, 56, 56,
  56, 112, 63, 192, 56, 96, 56, 48, 56, 56, 56, 56, 56, 57, 56, 57,
  56, 57, 56, 57, 255, 158, 12, 18, 36, 15, 2, 0, 30, 32, 97, 160,
  192, 224, 192, 96, 224, 32, 240, 32, 252, 0, 126, 0, 63, 128, 15, 192,
  135, 224, 129, 240, 128, 240, 192, 48, 192, 48, 224, 32, 176, 96, 143, 128,
  15, 18, 36, 18, 2, 0, 255, 254, 231, 30, 199, 14, 135, 14, 135, 6,
  135, 6, 7, 2, 7, 2, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 31, 224, 18, 18, 54, 20, 2, 0,
  255, 31, 192, 56, 7, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56,
  2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2,
  0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 24, 2, 0, 28, 4, 0,
  14, 8, 0, 3, 240, 0, 17, 18, 54, 19, 2, 0, 255, 63, 128, 60,
  6, 0, 60, 4, 0, 30, 4, 0, 30, 8, 0, 30, 8, 0, 15, 8,
  0, 15, 16, 0, 7, 144, 0, 7, 144, 0, 7, 160, 0, 3, 224, 0,
  3, 224, 0, 3, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 0,
  128, 0, 26, 18, 72, 27, 1, 0, 255, 191, 223, 192, 30, 15, 6, 0,
  30, 15, 6, 0, 15, 15, 4, 0, 15, 15, 132, 0, 15, 15, 132, 0,
  7, 143, 140, 0, 7, 139, 200, 0, 7, 147, 200, 0, 3, 211, 200, 0,
  3, 209, 240, 0, 3, 225, 240, 0, 1, 225, 240, 0, 1, 224, 240, 0,
  1, 224, 224, 0, 0, 192, 224, 0, 0, 192, 96, 0, 0, 192, 64, 0,
  16, 18, 36, 19, 2, 0, 255, 63, 62, 24, 30, 16, 31, 16, 15, 32,
  15, 224, 7, 192, 7, 192, 3, 192, 3, 224, 3, 224, 2, 240, 4, 240,
  8, 120, 8, 120, 16, 60, 48, 60, 252, 255, 16, 18, 36, 19, 2, 0,
  254, 127, 60, 12, 60, 8, 30, 16, 30, 16, 30, 16, 15, 32, 15, 32,
  7, 64, 7, 192, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128,
  3, 128, 15, 240, 13, 18, 36, 16, 2, 0, 127, 248, 112, 120, 96, 240,
  97, 240, 65, 224, 67, 224, 3, 192, 7, 192, 7, 128, 15, 0, 15, 0,
  30, 0, 30, 8, 60, 8, 124, 24, 120, 24, 248, 56, 255, 248, 6, 22,
  22, 10, 2, 252, 252, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 252, 9, 23, 46, 11, 1, 251,
  192, 0, 64, 0, 96, 0, 96, 0, 32, 0, 48, 0, 48, 0, 16, 0,
  24, 0, 24, 0, 24, 0, 8, 0, 12, 0, 12, 0, 4, 0, 6, 0,
  6, 0, 2, 0, 3, 0, 3, 0, 1, 0, 1, 128, 1, 128, 6, 22,
  22, 10, 2, 252, 252, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 252, 11, 9, 18, 15, 2, 9,
  4, 0, 12, 0, 30, 0, 27, 0, 51, 0, 49, 128, 96, 192, 192, 192,
  192, 96, 13, 2, 4, 13, 0, 252, 255, 248, 255, 248, 4, 4, 4, 11,
  2, 13, 192, 224, 96, 48, 11, 12, 24, 13, 1, 0, 30, 0, 99, 0,
  99, 128, 115, 128, 35, 128, 31, 128, 115, 128, 227, 128, 227, 160, 227, 160,
  247, 160, 121, 192, 12, 18, 36, 13, 0, 0, 248, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 59, 128, 60, 224, 60, 224, 56, 112, 56, 112,
  56, 112, 56, 112, 56, 112, 56, 112, 60, 224, 36, 192, 35, 128, 9, 12,
  24, 12, 1, 0, 30, 0, 49, 0, 113, 128, 227, 128, 227, 128, 224, 0,
  224, 0, 224, 0, 224, 128, 112, 128, 49, 0, 30, 0, 12, 18, 36, 13,
  1, 0, 7, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 29, 192,
  115, 192, 99, 192, 225, 192, 225, 192, 225, 192, 225, 192, 225, 192, 225, 192,
  99, 192, 115, 192, 29, 240, 9, 12, 24, 12, 1, 0, 30, 0, 51, 0,
  99, 128, 227, 128, 227, 128, 255, 128, 224, 0, 224, 0, 224, 128, 112, 128,
  49, 0, 30, 0, 9, 18, 36, 9, 1, 0, 15, 0, 29, 128, 59, 128,
  59, 128, 57, 0, 56, 0, 252, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 252, 0, 12, 18,
  36, 14, 1, 250, 30, 112, 51, 176, 113, 240, 113, 192, 113, 192, 113, 192,
  51, 128, 30, 0, 96, 0, 127, 128, 127, 192, 63, 224, 96, 224, 128, 96,
  128, 96, 128, 64, 64, 192, 63, 0, 12, 18, 36, 13, 0, 0, 248, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 57, 192, 62, 224, 60, 224,
  56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224,
  253, 240, 5, 18, 18, 7, 1, 0, 112, 112, 112, 32, 0, 0, 240, 112,
  112, 112, 112, 112, 112, 112, 112, 112, 112, 248, 7, 24, 24, 8, 255, 250,
  14, 14, 14, 4, 0, 0, 62, 14, 14, 14, 14, 14, 14, 14, 14, 14,
  14, 14, 14, 110, 238, 238, 204, 120, 13, 18, 36, 13, 0, 0, 248, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 57, 240, 56, 192, 56, 128,
  57, 0, 57, 0, 59, 128, 63, 128, 57, 192, 57, 192, 56, 224, 56, 224,
  255, 248, 7, 18, 18, 8, 0, 0, 248, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 254, 18, 12, 36, 19, 1, 0,
  243, 142, 0, 125, 247, 0, 121, 231, 0, 113, 199, 0, 113, 199, 0, 113,
  199, 0, 113, 199, 0, 113, 199, 0, 113, 199, 0, 113, 199, 0, 113, 199,
  0, 251, 239, 192, 11, 12, 24, 13, 1, 0, 243, 128, 125, 192, 121, 192,
  113, 192, 113, 192, 113, 192, 113, 192, 113, 192, 113, 192, 113, 192, 113, 192,
  251, 224, 10, 12, 24, 12, 1, 0, 30, 0, 51, 0, 97, 128, 225, 192,
  225, 192, 225, 192, 225, 192, 225, 192, 225, 192, 97, 128, 51, 0, 30, 0,
  12, 18, 36, 13, 0, 250, 251, 128, 60, 192, 60, 224, 56, 112, 56, 112,
  56, 112, 56, 112, 56, 112, 56, 112, 60, 224, 60, 224, 59, 192, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 254, 0, 11, 18, 36, 13, 1, 250,
  28, 64, 50, 64, 99, 192, 225, 192, 225, 192, 225, 192, 225, 192, 225, 192,
  225, 192, 99, 192, 115, 192, 61, 192, 1, 192, 1, 192, 1, 192, 1, 192,
  1, 192, 7, 224, 9, 12, 24, 11, 1, 0, 243, 0, 117, 128, 123, 128,
  123, 128, 112, 0, 112, 0, 112, 0, 112, 0, 112, 0, 112, 0, 112, 0,
  248, 0, 9, 12, 24, 11, 1, 0, 57, 0, 199, 0, 195, 0, 225, 0,
  240, 0, 124, 0, 63, 0, 143, 128, 131, 128, 193, 128, 225, 0, 158, 0,
  8, 17, 17, 10, 1, 0, 16, 16, 16, 48, 112, 254, 112, 112, 112, 112,
  112, 113, 113, 113, 113, 114, 60, 12, 12, 24, 13, 0, 0, 249, 224, 56,
  224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 57,
  224, 58, 224, 28, 240, 12, 12, 24, 13, 1, 0, 253, 240, 112, 64, 56,
  64, 56, 128, 28, 128, 28, 128, 29, 0, 15, 0, 14, 0, 14, 0, 6,
  0, 4, 0, 19, 12, 36, 19, 0, 0, 253, 251, 224, 56, 112, 128, 28,
  112, 128, 28, 113, 0, 28, 121, 0, 14, 185, 0, 14, 154, 0, 14, 158,
  0, 7, 28, 0, 7, 12, 0, 2, 12, 0, 2, 8, 0, 12, 12, 24,
  13, 0, 0, 253, 240, 56, 64, 28, 128, 31, 0, 15, 0, 15, 0, 7,
  0, 7, 128, 11, 192, 17, 192, 17, 224, 253, 240, 12, 18, 36, 12, 0,
  250, 252, 240, 112, 64, 56, 64, 56, 128, 28, 128, 28, 128, 29, 0, 15,
  0, 15, 0, 7, 0, 6, 0, 6, 0, 2, 0, 4, 0, 116, 0, 116,
  0, 104, 0, 56, 0, 10, 12, 24, 12, 1, 0, 127, 192, 99, 128, 71,
  128, 71, 0, 15, 0, 14, 0, 28, 0, 60, 64, 56, 64, 120, 64, 112,
  192, 255, 192, 8, 23, 23, 10, 1, 251, 3, 28, 56, 56, 56, 56, 56,
  56, 56, 56, 48, 192, 48, 56, 56, 56, 56, 56, 56, 56, 56, 28, 3,
  2, 23, 23, 8, 3, 251, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 8, 23, 23,
  11, 2, 251, 192, 112, 56, 56, 56, 56, 56, 56, 56, 56, 28, 7, 28,
  56, 56, 56, 56, 56, 56, 56, 56, 112, 192, 14, 5, 10, 16, 1, 4,
  120, 8, 255, 4, 143, 196, 131, 252, 64, 120, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 7, 0,
  0, 4, 18, 18, 6, 1, 250, 96, 240, 240, 96, 0, 0, 64, 96, 96,
  96, 96, 96, 240, 240, 240, 240, 240, 96, 9, 18, 36, 15, 3, 253, 4,
  0, 4, 0, 4, 0, 30, 0, 53, 0, 117, 128, 231, 128, 231, 128, 228,
  0, 228, 0, 228, 0, 228, 0, 100, 128, 116, 128, 31, 0, 4, 0, 4,
  0, 4, 0, 16, 18, 36, 19, 2, 0, 0, 248, 1, 132, 3, 6, 7,
  14, 7, 14, 7, 0, 7, 0, 63, 0, 7, 240, 7, 128, 3, 128, 3,
  128, 3, 128, 3, 1, 123, 2, 143, 204, 135, 252, 120, 240, 12, 12, 24,
  14, 1, 3, 132, 16, 223, 176, 112, 224, 96, 96, 192, 48, 192, 48, 192,
  48, 192, 48, 64, 96, 96, 96, 127, 224, 207, 48, 14, 18, 36, 14, 0,
  0, 254, 124, 56, 16, 60, 16, 60, 32, 30, 32, 30, 64, 14, 64, 15,
  128, 7, 128, 127, 240, 7, 0, 127, 240, 7, 0, 7, 0, 7, 0, 7,
  0, 7, 0, 31, 224, 2, 22, 22, 8, 3, 252, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 0, 0, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 11, 23, 46, 15, 1, 251, 15, 0, 48, 128, 96, 192, 97, 192, 97,
  192, 112, 128, 124, 0, 63, 0, 223, 128, 143, 192, 129, 224, 192, 96, 248,
  32, 126, 32, 63, 64, 15, 128, 3, 192, 49, 192, 112, 192, 112, 192, 96,
  128, 33, 128, 30, 0, 8, 3, 3, 12, 2, 14, 231, 231, 231, 18, 18,
  54, 20, 1, 0, 3, 240, 0, 12, 12, 0, 16, 2, 0, 33, 201, 0,
  67, 56, 128, 70, 24, 128, 142, 8, 64, 142, 8, 64, 142, 0, 64, 142,
  0, 64, 142, 8, 64, 142, 8, 64, 70, 8, 128, 67, 16, 128, 33, 225,
  0, 16, 2, 0, 12, 12, 0, 3, 240, 0, 7, 9, 9, 10, 1, 9,
  120, 204, 204, 60, 76, 204, 206, 126, 254, 7, 10, 10, 12, 3, 1, 32,
  100, 68, 204, 204, 204, 204, 196, 100, 34, 13, 7, 14, 15, 1, 4, 255,
  248, 255, 248, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 6, 3, 3,
  8, 1, 5, 252, 252, 252, 18, 18, 54, 20, 1, 0, 3, 240, 0, 12,
  12, 0, 16, 2, 0, 47, 225, 0, 71, 48, 128, 71, 56, 128, 135, 56,
  64, 135, 48, 64, 135, 192, 64, 135, 48, 64, 135, 56, 64, 135, 56, 64,
  71, 58, 128, 71, 58, 128, 47, 157, 0, 16, 2, 0, 12, 12, 0, 3,
  240, 0, 7, 2, 2, 11, 2, 14, 254, 254, 8, 7, 7, 14, 3, 11,
  60, 102, 131, 129, 129, 194, 126, 21, 18, 54, 23, 1, 254, 0, 48, 0,
  0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 255,
  255, 248, 255, 255, 248, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48,
  0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 0, 0, 255, 255, 248,
  255, 255, 248, 7, 11, 11, 11, 2, 7, 124, 206, 206, 238, 28, 48, 98,
  66, 254, 190, 8, 8, 11, 11, 12, 2, 7, 60, 198, 231, 231, 6, 56,
  6, 103, 231, 199, 60, 4, 4, 4, 11, 5, 13, 48, 112, 96, 192, 13,
  18, 36, 15, 1, 250, 97, 128, 225, 192, 225, 192, 225, 192, 225, 192, 225,
  192, 225, 192, 64, 136, 64, 136, 65, 248, 127, 120, 94, 48, 64, 0, 96,
  0, 96, 0, 112, 0, 112, 0, 112, 0, 13, 21, 42, 15, 1, 253, 31,
  248, 126, 96, 126, 96, 254, 96, 254, 96, 254, 96, 254, 96, 126, 96, 62,
  96, 14, 96, 6, 96, 6, 96, 6, 96, 6, 96, 6, 96, 6, 96, 6,
  96, 6, 96, 6, 96, 6, 96, 6, 96, 4, 4, 4, 8, 2, 6, 96,
  240, 240, 96, 5, 5, 5, 11, 3, 250, 32, 96, 24, 24, 240, 6, 11,
  11, 11, 3, 7, 48, 240, 112, 112, 112, 112, 112, 112, 112, 112, 252, 7,
  9, 9, 9, 1, 9, 56, 68, 198, 198, 198, 198, 68, 56, 254, 7, 10,
  10, 13, 3, 1, 152, 140, 68, 102, 102, 102, 102, 70, 76, 136, 18, 18,
  54, 22, 3, 0, 48, 8, 0, 240, 8, 0, 112, 16, 0, 112, 48, 0,
  112, 32, 0, 112, 96, 0, 112, 64, 0, 112, 195, 0, 112, 135, 0, 113,
  143, 0, 253, 15, 0, 3, 23, 0, 2, 39, 0, 4, 39, 0, 12, 63,
  192, 8, 7, 0, 24, 7, 0, 16, 31, 192, 18, 18, 54, 23, 3, 0,
  48, 4, 0, 240, 8, 0, 112, 24, 0, 112, 16, 0, 112, 48, 0, 112,
  32, 0, 112, 96, 0, 112, 79, 0, 112, 147, 192, 113, 177, 192, 253, 57,
  192, 3, 3, 128, 2, 6, 0, 6, 8, 0, 4, 16, 64, 8, 63, 192,
  24, 47, 192, 16, 39, 128, 20, 18, 54, 23, 2, 0, 124, 2, 0, 199,
  6, 0, 231, 4, 0, 6, 12, 0, 56, 8, 0, 6, 16, 0, 7, 16,
  0, 231, 33, 192, 231, 97, 192, 198, 67, 192, 60, 133, 192, 0, 133, 192,
  1, 9, 192, 1, 9, 192, 2, 31, 240, 6, 1, 192, 4, 1, 192, 8,
  7, 240, 8, 18, 18, 12, 2, 250, 48, 120, 120, 48, 56, 68, 68, 4,
  8, 24, 48, 114, 97, 225, 225, 225, 114, 60, 17, 23, 69, 19, 1, 1,
  7, 0, 0, 7, 0, 0, 1, 128, 0, 0, 128, 0, 0, 0, 0, 0,
  192, 0, 0, 192, 0, 1, 192, 0, 1, 224, 0, 1, 224, 0, 3, 224,
  0, 2, 240, 0, 2, 240, 0, 4, 240, 0, 4, 120, 0, 4, 120, 0,
  8, 56, 0, 15, 252, 0, 8, 60, 0, 16, 28, 0, 16, 30, 0, 48,
  30, 0, 252, 255, 128, 17, 23, 69, 19, 1, 1, 0, 56, 0, 0, 48,
  0, 0, 96, 0, 0, 192, 0, 0, 0, 0, 0, 192, 0, 0, 192, 0,
  0, 192, 0, 1, 224, 0, 1, 224, 0, 1, 224, 0, 2, 240, 0, 2,
  240, 0, 4, 112, 0, 4, 120, 0, 4, 120, 0, 8, 56, 0, 15, 252,
  0, 8, 60, 0, 16, 28, 0, 16, 30, 0, 48, 30, 0, 252, 127, 128,
  17, 23, 69, 19, 1, 0, 0, 192, 0, 1, 192, 0, 3, 96, 0, 6,
  24, 0, 0, 0, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 1, 224,
  0, 1, 224, 0, 1, 224, 0, 2, 240, 0, 2, 240, 0, 4, 112, 0,
  4, 120, 0, 4, 120, 0, 8, 56, 0, 15, 252, 0, 8, 60, 0, 16,
  28, 0, 16, 30, 0, 48, 30, 0, 252, 127, 128, 17, 23, 69, 19, 1,
  0, 1, 8, 0, 7, 240, 0, 4, 240, 0, 0, 0, 0, 0, 0, 0,
  0, 192, 0, 0, 192, 0, 1, 192, 0, 1, 224, 0, 1, 224, 0, 3,
  224, 0, 2, 240, 0, 2, 240, 0, 4, 240, 0, 4, 120, 0, 4, 120,
  0, 8, 56, 0, 15, 252, 0, 8, 60, 0, 16, 28, 0, 16, 30, 0,
  48, 30, 0, 252, 255, 128, 16, 23, 46, 18, 1, 0, 14, 112, 14, 112,
  14, 112, 0, 0, 0, 0, 1, 128, 1, 128, 1, 128, 3, 192, 3, 192,
  3, 192, 5, 224, 5, 224, 4, 224, 8, 240, 8, 240, 8, 112, 31, 248,
  16, 120, 16, 60, 48, 60, 48, 60, 252, 255, 18, 23, 69, 19, 1, 0,
  1, 224, 0, 2, 16, 0, 2, 16, 0, 1, 224, 0, 0, 0, 0, 0,
  192, 0, 0, 192, 0, 0, 224, 0, 1, 224, 0, 1, 224, 0, 1, 240,
  0, 2, 240, 0, 2, 240, 0, 4, 120, 0, 4, 120, 0, 4, 120, 0,
  8, 60, 0, 15, 252, 0, 8, 28, 0, 16, 30, 0, 16, 30, 0, 48,
  30, 0, 252, 127, 192, 23, 18, 54, 25, 1, 0, 0, 127, 254, 0, 60,
  14, 0, 60, 6, 0, 124, 6, 0, 92, 2, 0, 220, 34, 0, 156, 32,
  1, 156, 96, 1, 28, 96, 3, 31, 224, 2, 28, 96, 6, 28, 34, 7,
  252, 34, 8, 28, 2, 8, 28, 2, 24, 28, 6, 56, 28, 14, 254, 127,
  254, 13, 24, 48, 17, 2, 250, 7, 136, 24, 120, 48, 56, 112, 24, 112,
  24, 240, 8, 240, 8, 240, 8, 240, 0, 240, 0, 240, 0, 240, 8, 240,
  8, 112, 8, 112, 8, 56, 16, 24, 32, 7, 192, 2, 0, 3, 128, 0,
  192, 0, 192, 8, 192, 7, 128, 14, 23, 46, 18, 2, 1, 28, 0, 12,
  0, 6, 0, 1, 0, 0, 0, 255, 252, 56, 28, 56, 12, 56, 12, 56,
  4, 56, 68, 56, 64, 56, 192, 56, 192, 63, 192, 56, 192, 56, 68, 56,
  68, 56, 4, 56, 4, 56, 12, 56, 28, 255, 252, 14, 23, 46, 18, 2,
  1, 0, 224, 0, 192, 1, 128, 2, 0, 0, 0, 255, 252, 56, 28, 56,
  12, 56, 12, 56, 4, 56, 68, 56, 64, 56, 192, 56, 192, 63, 192, 56,
  192, 56, 68, 56, 68, 56, 4, 56, 4, 56, 12, 56, 28, 255, 252, 14,
  23, 46, 18, 2, 0, 3, 0, 7, 128, 12, 192, 16, 32, 0, 0, 255,
  252, 56, 28, 56, 12, 56, 12, 56, 4, 56, 68, 56, 64, 56, 192, 56,
  192, 63, 192, 56, 192, 56, 68, 56, 68, 56, 4, 56, 4, 56, 12, 56,
  28, 255, 252, 14, 23, 46, 18, 2, 0, 28, 224, 28, 224, 28, 224, 0,
  0, 0, 0, 255, 252, 56, 28, 56, 12, 56, 12, 56, 4, 56, 68, 56,
  64, 56, 192, 56, 192, 63, 192, 56, 192, 56, 68, 56, 68, 56, 4, 56,
  12, 56, 12, 56, 28, 255, 252, 8, 23, 23, 11, 2, 1, 192, 96, 48,
  16, 0, 255, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 255, 8, 23, 23, 11, 2, 1, 7, 14, 8, 16, 0, 255,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  255, 8, 23, 23, 11, 2, 0, 16, 56, 108, 130, 0, 255, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 255, 8, 23,
  23, 11, 2, 0, 231, 231, 231, 0, 0, 255, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 255, 16, 18, 36, 19, 2,
  0, 255, 224, 56, 56, 56, 28, 56, 14, 56, 14, 56, 14, 56, 15, 56,
  15, 255, 15, 56, 15, 56, 15, 56, 15, 56, 14, 56, 14, 56, 12, 56,
  28, 56, 56, 255, 224, 17, 23, 69, 18, 1, 0, 3, 136, 0, 3, 240,
  0, 4, 96, 0, 0, 0, 0, 0, 0, 0, 252, 63, 128, 60, 14, 0,
  62, 4, 0, 31, 4, 0, 31, 4, 0, 23, 132, 0, 23, 196, 0, 19,
  196, 0, 17, 228, 0, 17, 244, 0, 16, 244, 0, 16, 124, 0, 16, 124,
  0, 16, 60, 0, 16, 28, 0, 16, 28, 0, 56, 12, 0, 254, 4, 0,
  15, 24, 48, 18, 2, 0, 12, 0, 12, 0, 14, 0, 3, 0, 1, 0,
  0, 0, 7, 192, 8, 32, 56, 48, 48, 24, 112, 28, 112, 28, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 112, 28, 112, 28, 48, 24,
  48, 56, 8, 32, 7, 192, 15, 24, 48, 18, 2, 0, 0, 96, 0, 96,
  0, 224, 1, 128, 1, 0, 0, 0, 7, 192, 8, 32, 56, 48, 48, 24,
  112, 28, 112, 28, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  112, 28, 112, 28, 48, 24, 48, 56, 8, 32, 7, 192, 15, 24, 48, 18,
  2, 0, 1, 0, 3, 128, 7, 128, 14, 192, 24, 48, 0, 0, 7, 192,
  8, 32, 56, 48, 48, 24, 112, 28, 112, 28, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 240, 30, 112, 28, 112, 28, 48, 24, 48, 56, 8, 32,
  7, 192, 15, 23, 46, 18, 2, 0, 7, 32, 15, 224, 16, 192, 0, 0,
  0, 0, 7, 192, 8, 32, 56, 48, 48, 24, 112, 28, 112, 28, 240, 30,
  240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 112, 28, 112, 28, 48, 24,
  48, 56, 8, 32, 7, 192, 15, 23, 46, 18, 2, 0, 28, 224, 28, 224,
  28, 224, 0, 0, 0, 0, 7, 192, 8, 32, 56, 48, 48, 24, 112, 28,
  112, 28, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 112, 28,
  112, 28, 48, 24, 48, 56, 8, 32, 7, 192, 16, 15, 30, 24, 4, 0,
  192, 3, 96, 6, 48, 12, 24, 24, 12, 48, 6, 96, 3, 192, 1, 128,
  3, 192, 6, 96, 12, 48, 56, 24, 112, 12, 224, 6, 192, 3, 15, 18,
  36, 18, 2, 0, 7, 194, 8, 116, 48, 60, 48, 56, 112, 60, 112, 124,
  240, 94, 240, 222, 241, 158, 243, 30, 246, 30, 244, 30, 124, 28, 120, 28,
  56, 24, 120, 24, 92, 32, 135, 192, 18, 24, 72, 20, 2, 0, 6, 0,
  0, 7, 0, 0, 3, 0, 0, 1, 128, 0, 0, 0, 0, 0, 0, 0,
  255, 31, 192, 56, 7, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56,
  2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2,
  0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 24, 2, 0, 28, 4, 0,
  14, 8, 0, 3, 240, 0, 18, 24, 72, 20, 2, 0, 0, 24, 0, 0,
  56, 0, 0, 112, 0, 0, 192, 0, 0, 128, 0, 0, 0, 0, 255, 31,
  192, 56, 7, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0,
  56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56,
  2, 0, 56, 2, 0, 56, 2, 0, 24, 2, 0, 28, 4, 0, 14, 8,
  0, 3, 240, 0, 18, 24, 72, 20, 2, 0, 0, 128, 0, 1, 192, 0,
  1, 224, 0, 6, 48, 0, 8, 8, 0, 0, 0, 0, 255, 31, 192, 56,
  7, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2,
  0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0,
  56, 2, 0, 56, 2, 0, 24, 2, 0, 28, 4, 0, 14, 8, 0, 3,
  240, 0, 18, 23, 69, 20, 2, 0, 7, 56, 0, 7, 56, 0, 7, 56,
  0, 0, 0, 0, 0, 0, 0, 255, 31, 192, 56, 7, 0, 56, 2, 0,
  56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56,
  2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2,
  0, 24, 2, 0, 28, 4, 0, 14, 8, 0, 3, 240, 0, 16, 23, 46,
  19, 2, 1, 0, 112, 0, 96, 0, 192, 1, 0, 0, 0, 254, 127, 60,
  12, 60, 8, 30, 16, 30, 16, 30, 16, 15, 32, 15, 32, 7, 64, 7,
  192, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 15,
  240, 15, 18, 36, 18, 2, 0, 255, 128, 56, 0, 56, 0, 63, 224, 56,
  56, 56, 28, 56, 30, 56, 30, 56, 30, 56, 30, 56, 28, 56, 56, 63,
  224, 56, 0, 56, 0, 56, 0, 56, 0, 255, 128, 12, 18, 36, 13, 0,
  0, 7, 128, 12, 192, 24, 224, 56, 224, 56, 224, 56, 224, 56, 192, 59,
  0, 56, 192, 56, 96, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 63,
  112, 63, 96, 251, 192, 11, 18, 36, 13, 1, 0, 32, 0, 48, 0, 48,
  0, 24, 0, 4, 0, 0, 0, 30, 0, 99, 0, 99, 128, 115, 128, 7,
  128, 27, 128, 115, 128, 227, 128, 227, 160, 227, 160, 247, 160, 121, 192, 11,
  18, 36, 13, 1, 0, 3, 0, 3, 0, 6, 0, 4, 0, 8, 0, 0,
  0, 30, 0, 99, 0, 99, 128, 115, 128, 35, 128, 31, 128, 115, 128, 227,
  128, 227, 160, 227, 160, 247, 160, 121, 192, 11, 18, 36, 13, 1, 0, 12,
  0, 12, 0, 30, 0, 50, 0, 65, 0, 0, 0, 30, 0, 99, 0, 99,
  128, 115, 128, 35, 128, 31, 128, 115, 128, 227, 128, 227, 160, 227, 160, 247,
  160, 121, 192, 11, 17, 34, 13, 1, 0, 57, 0, 127, 0, 70, 0, 0,
  0, 0, 0, 30, 0, 99, 0, 99, 128, 115, 128, 35, 128, 31, 128, 115,
  128, 227, 128, 227, 160, 227, 160, 247, 160, 121, 192, 11, 17, 34, 13, 1,
  0, 119, 0, 119, 0, 119, 0, 0, 0, 0, 0, 30, 0, 99, 0, 99,
  128, 115, 128, 35, 128, 31, 128, 115, 128, 227, 128, 227, 160, 227, 160, 247,
  160, 121, 192, 11, 18, 36, 13, 1, 0, 28, 0, 38, 0, 34, 0, 34,
  0, 28, 0, 0, 0, 30, 0, 99, 0, 99, 128, 115, 128, 35, 128, 31,
  128, 115, 128, 227, 128, 227, 160, 227, 160, 231, 160, 121, 192, 15, 12, 24,
  18, 1, 0, 62, 248, 99, 140, 99, 142, 115, 142, 7, 142, 27, 254, 115,
  128, 227, 128, 227, 130, 227, 130, 247, 196, 120, 120, 9, 18, 36, 12, 1,
  250, 30, 0, 49, 0, 113, 128, 227, 128, 227, 128, 224, 0, 224, 0, 224,
  0, 224, 128, 112, 128, 49, 0, 30, 0, 8, 0, 8, 0, 6, 0, 6,
  0, 6, 0, 28, 0, 9, 18, 36, 12, 1, 0, 32, 0, 112, 0, 48,
  0, 24, 0, 4, 0, 0, 0, 30, 0, 51, 0, 99, 128, 227, 128, 227,
  128, 255, 128, 224, 0, 224, 0, 224, 128, 112, 128, 49, 0, 30, 0, 9,
  18, 36, 12, 1, 0, 3, 0, 7, 0, 6, 0, 12, 0, 8, 0, 0,
  0, 30, 0, 51, 0, 99, 128, 227, 128, 227, 128, 255, 128, 224, 0, 224,
  0, 224, 128, 112, 128, 49, 0, 30, 0, 9, 18, 36, 12, 1, 0, 12,
  0, 28, 0, 28, 0, 50, 0, 65, 0, 0, 0, 30, 0, 51, 0, 99,
  128, 227, 128, 227, 128, 255, 128, 224, 0, 224, 0, 224, 128, 112, 128, 49,
  0, 30, 0, 9, 17, 34, 12, 1, 0, 115, 128, 115, 128, 115, 128, 0,
  0, 0, 0, 30, 0, 51, 0, 99, 128, 227, 128, 227, 128, 255, 128, 224,
  0, 224, 0, 224, 0, 112, 128, 49, 0, 30, 0, 7, 18, 18, 8, 1,
  0, 192, 224, 112, 16, 8, 0, 120, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 126, 6, 18, 18, 8, 1, 0, 12, 28, 24, 48, 0, 0, 240,
  112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 248, 7, 18, 18, 7, 0,
  0, 56, 56, 108, 198, 0, 0, 120, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 126, 7, 17, 17, 8, 1, 0, 238, 238, 238, 0, 0, 120, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 126, 10, 18, 36, 12, 1, 0,
  57, 128, 30, 0, 14, 0, 31, 0, 39, 0, 3, 128, 31, 128, 51, 192,
  97, 192, 225, 192, 225, 192, 225, 192, 225, 192, 225, 192, 225, 192, 97, 128,
  51, 128, 30, 0, 11, 17, 34, 13, 1, 0, 24, 128, 63, 128, 39, 0,
  0, 0, 0, 0, 243, 128, 125, 192, 121, 192, 113, 192, 113, 192, 113, 192,
  113, 192, 113, 192, 113, 192, 113, 192, 113, 192, 251, 224, 10, 18, 36, 12,
  1, 0, 48, 0, 48, 0, 24, 0, 12, 0, 4, 0, 0, 0, 30, 0,
  51, 0, 97, 128, 225, 192, 225, 192, 225, 192, 225, 192, 225, 192, 225, 192,
  97, 128, 51, 0, 30, 0, 10, 18, 36, 12, 1, 0, 3, 0, 3, 0,
  7, 0, 4, 0, 8, 0, 0, 0, 30, 0, 51, 0, 97, 128, 225, 192,
  225, 192, 225, 192, 225, 192, 225, 192, 225, 192, 97, 128, 51, 0, 30, 0,
  10, 18, 36, 12, 1, 0, 12, 0, 14, 0, 30, 0, 51, 0, 96, 128,
  0, 0, 30, 0, 51, 0, 97, 128, 225, 192, 225, 192, 225, 192, 225, 192,
  225, 192, 225, 192, 97, 128, 51, 0, 30, 0, 10, 17, 34, 12, 1, 0,
  56, 128, 63, 0, 70, 0, 0, 0, 0, 0, 30, 0, 51, 0, 97, 128,
  225, 192, 225, 192, 225, 192, 225, 192, 225, 192, 225, 192, 97, 128, 51, 0,
  30, 0, 10, 17, 34, 12, 1, 0, 115, 128, 115, 128, 115, 128, 0, 0,
  0, 0, 30, 0, 51, 0, 97, 128, 225, 192, 225, 192, 225, 192, 225, 192,
  225, 192, 225, 192, 97, 128, 51, 0, 30, 0, 21, 17, 51, 23, 1, 254,
  0, 48, 0, 0, 120, 0, 0, 120, 0, 0, 48, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 248, 255, 255, 248, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0, 120, 0, 0, 120, 0,
  0, 48, 0, 10, 12, 24, 12, 1, 0, 30, 64, 51, 128, 97, 128, 225,
  192, 227, 192, 229, 192, 233, 192, 241, 192, 241, 192, 97, 128, 115, 0, 158,
  0, 12, 18, 36, 13, 0, 0, 24, 0, 24, 0, 12, 0, 6, 0, 2,
  0, 0, 0, 249, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56,
  224, 56, 224, 56, 224, 57, 224, 58, 224, 28, 240, 12, 18, 36, 13, 0,
  0, 1, 128, 1, 128, 3, 0, 2, 0, 0, 0, 0, 0, 249, 224, 56,
  224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 57,
  224, 58, 224, 28, 240, 12, 18, 36, 13, 0, 0, 6, 0, 6, 0, 15,
  0, 25, 128, 0, 0, 0, 0, 249, 224, 56, 224, 56, 224, 56, 224, 56,
  224, 56, 224, 56, 224, 56, 224, 56, 224, 57, 224, 58, 224, 28, 240, 12,
  17, 34, 13, 0, 0, 57, 192, 57, 192, 57, 192, 0, 0, 0, 0, 249,
  224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56,
  224, 57, 224, 58, 224, 28, 240, 12, 24, 48, 12, 0, 250, 1, 128, 1,
  128, 3, 0, 6, 0, 4, 0, 0, 0, 252, 240, 112, 64, 56, 64, 56,
  128, 28, 128, 28, 128, 29, 0, 15, 0, 15, 0, 7, 0, 6, 0, 6,
  0, 2, 0, 4, 0, 116, 0, 116, 0, 104, 0, 56, 0, 12, 23, 46,
  13, 0, 250, 24, 0, 120, 0, 184, 0, 56, 0, 56, 0, 57, 224, 58,
  240, 60, 112, 60, 112, 56, 112, 56, 96, 56, 224, 56, 192, 56, 128, 57,
  0, 58, 0, 60, 0, 56, 0, 56, 0, 56, 0, 56, 0, 96, 0, 128,
  0, 13, 23, 46, 13, 0, 250, 28, 224, 28, 224, 28, 224, 0, 0, 0,
  0, 254, 120, 56, 32, 60, 64, 28, 64, 30, 64, 14, 64, 14, 128, 7,
  128, 7, 128, 7, 0, 3, 0, 3, 0, 2, 0, 2, 0, 58, 0, 60,
  0, 52, 0, 56, 0
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--25-250-72-72-P-136-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 0, '1' Height: 18
  Calculated Max Values w=21 h=23 x= 3 y= 8 dx=23 dy= 0 ascent=18 len=63
  Font Bounding box     w=70 h=31 x=-22 y=-7
  Calculated Min Values           x= 0 y=-5 dx= 0 dy= 0
  Pure Font   ascent =18 descent= 0
  X Font      ascent =18 descent= 0
  Max Font    ascent =18 descent=-5
*/
const u8g_fntpgm_uint8_t u8g_font_osb18n[618] U8G_FONT_SECTION("u8g_font_osb18n") = {
  0, 70, 31, 234, 249, 18, 0, 0, 0, 0, 42, 58, 0, 18, 251, 18,
  0, 9, 10, 20, 13, 2, 8, 24, 0, 24, 0, 201, 128, 235, 128, 28,
  0, 44, 0, 235, 128, 217, 128, 24, 0, 24, 0, 21, 21, 63, 23, 1,
  253, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0,
  0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 255,
  255, 248, 255, 255, 248, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48,
  0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0,
  4, 9, 9, 7, 2, 251, 224, 240, 240, 240, 16, 32, 32, 64, 128, 6,
  3, 3, 8, 1, 5, 252, 252, 252, 4, 4, 4, 8, 2, 0, 96, 240,
  240, 96, 9, 23, 46, 11, 1, 251, 1, 128, 1, 128, 1, 0, 3, 0,
  3, 0, 2, 0, 6, 0, 6, 0, 4, 0, 12, 0, 12, 0, 8, 0,
  24, 0, 24, 0, 24, 0, 16, 0, 48, 0, 48, 0, 32, 0, 96, 0,
  96, 0, 64, 0, 192, 0, 12, 18, 36, 15, 1, 0, 15, 0, 25, 128,
  48, 192, 112, 224, 112, 224, 240, 224, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 112, 224, 112, 224, 48, 192, 25, 128, 15, 0,
  8, 18, 18, 15, 3, 0, 24, 56, 248, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 255, 11, 18, 36, 15, 2, 0, 31, 0,
  113, 192, 96, 224, 224, 224, 240, 224, 248, 224, 121, 192, 1, 192, 3, 0,
  6, 0, 8, 0, 48, 32, 64, 32, 64, 32, 255, 224, 191, 224, 143, 192,
  135, 128, 12, 18, 36, 15, 1, 0, 31, 0, 49, 192, 96, 224, 112, 224,
  120, 224, 120, 224, 0, 192, 1, 128, 62, 0, 1, 192, 0, 224, 0, 240,
  112, 240, 248, 240, 240, 240, 192, 224, 65, 192, 63, 0, 11, 18, 36, 15,
  2, 0, 3, 0, 7, 0, 7, 0, 15, 0, 15, 0, 23, 0, 55, 0,
  39, 0, 103, 0, 71, 0, 199, 0, 135, 0, 255, 224, 7, 0, 7, 0,
  7, 0, 7, 0, 63, 224, 11, 18, 36, 15, 2, 0, 65, 128, 127, 128,
  126, 0, 120, 0, 64, 0, 64, 0, 95, 0, 99, 128, 65, 192, 65, 224,
  1, 224, 33, 224, 241, 224, 241, 224, 225, 192, 193, 192, 67, 128, 62, 0,
  11, 18, 36, 15, 2, 0, 7, 128, 24, 64, 48, 224, 113, 224, 113, 224,
  240, 0, 240, 0, 247, 128, 249, 192, 240, 224, 240, 224, 240, 224, 240, 224,
  112, 224, 112, 224, 48, 192, 57, 192, 15, 0, 11, 18, 36, 15, 2, 0,
  156, 64, 190, 96, 255, 32, 255, 224, 128, 32, 128, 64, 128, 64, 0, 128,
  1, 128, 3, 0, 7, 0, 6, 0, 14, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 12, 0, 12, 18, 36, 15, 1, 0, 31, 128, 32, 64, 64, 32,
  192, 32, 192, 32, 240, 32, 252, 64, 127, 128, 127, 192, 63, 224, 103, 240,
  193, 240, 192, 112, 192, 48, 192, 48, 96, 32, 112, 64, 31, 128, 12, 18,
  36, 15, 2, 0, 31, 0, 113, 128, 96, 192, 224, 224, 224, 224, 224, 240,
  224, 240, 96, 240, 113, 240, 30, 240, 0, 240, 0, 240, 56, 224, 120, 224,
  120, 224, 97, 192, 33, 128, 30, 0, 4, 12, 12, 8, 2, 0, 96, 240,
  240, 96, 0, 0, 0, 0, 96, 240, 240, 96
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--25-250-72-72-P-136-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 18, '1' Height: 18
  Calculated Max Values w=26 h=24 x= 3 y=13 dx=27 dy= 0 ascent=20 len=72
  Font Bounding box     w=70 h=31 x=-22 y=-7
  Calculated Min Values           x=-1 y=-6 dx= 0 dy= 0
  Pure Font   ascent =18 descent=-6
  X Font      ascent =18 descent=-6
  Max Font    ascent =20 descent=-6
*/
const u8g_fntpgm_uint8_t u8g_font_osb18r[3611] U8G_FONT_SECTION("u8g_font_osb18r") = {
  0, 70, 31, 234, 249, 18, 4, 190, 10, 54, 32, 127, 250, 20, 250, 18,
  250, 0, 0, 0, 7, 0, 0, 4, 18, 18, 6, 1, 0, 96, 240, 240,
  240, 240, 240, 96, 96, 96, 96, 96, 64, 0, 0, 96, 240, 240, 96, 6,
  6, 6, 10, 2, 12, 204, 204, 204, 204, 204, 204, 15, 18, 36, 19, 2,
  0, 6, 24, 6, 24, 4, 16, 4, 16, 12, 48, 255, 254, 255, 254, 12,
  48, 8, 32, 8, 32, 24, 96, 24, 96, 255, 254, 255, 254, 16, 64, 16,
  64, 48, 192, 48, 192, 11, 22, 44, 14, 2, 254, 9, 0, 9, 0, 31,
  128, 105, 64, 73, 32, 201, 32, 201, 96, 249, 224, 249, 64, 127, 0, 63,
  128, 31, 192, 15, 192, 73, 224, 233, 224, 201, 96, 137, 96, 137, 96, 73,
  192, 63, 128, 9, 0, 9, 0, 17, 18, 54, 21, 2, 0, 56, 4, 0,
  68, 12, 0, 198, 8, 0, 198, 24, 0, 198, 48, 0, 198, 32, 0, 198,
  96, 0, 76, 64, 0, 56, 192, 0, 1, 142, 0, 1, 27, 0, 3, 49,
  128, 2, 49, 128, 4, 49, 128, 12, 49, 128, 8, 49, 128, 24, 17, 0,
  16, 14, 0, 17, 18, 54, 19, 1, 0, 3, 192, 0, 4, 32, 0, 12,
  32, 0, 12, 32, 0, 12, 32, 0, 14, 64, 0, 15, 128, 0, 7, 0,
  0, 15, 143, 128, 27, 195, 0, 49, 194, 0, 96, 226, 0, 224, 244, 0,
  224, 120, 0, 240, 56, 0, 240, 60, 0, 126, 223, 128, 63, 15, 0, 2,
  6, 6, 6, 2, 12, 192, 192, 192, 192, 192, 192, 7, 23, 23, 9, 1,
  251, 2, 4, 8, 16, 48, 96, 96, 96, 224, 224, 224, 224, 224, 224, 224,
  96, 96, 96, 48, 16, 8, 4, 2, 7, 23, 23, 9, 0, 251, 128, 64,
  32, 16, 24, 12, 12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 12, 12,
  24, 16, 32, 64, 128, 9, 10, 20, 13, 2, 8, 24, 0, 24, 0, 201,
  128, 235, 128, 28, 0, 44, 0, 235, 128, 217, 128, 24, 0, 24, 0, 21,
  21, 63, 23, 1, 253, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48,
  0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0,
  0, 48, 0, 255, 255, 248, 255, 255, 248, 0, 48, 0, 0, 48, 0, 0,
  48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48,
  0, 0, 48, 0, 4, 9, 9, 7, 2, 251, 224, 240, 240, 240, 16, 32,
  32, 64, 128, 6, 3, 3, 8, 1, 5, 252, 252, 252, 4, 4, 4, 8,
  2, 0, 96, 240, 240, 96, 9, 23, 46, 11, 1, 251, 1, 128, 1, 128,
  1, 0, 3, 0, 3, 0, 2, 0, 6, 0, 6, 0, 4, 0, 12, 0,
  12, 0, 8, 0, 24, 0, 24, 0, 24, 0, 16, 0, 48, 0, 48, 0,
  32, 0, 96, 0, 96, 0, 64, 0, 192, 0, 12, 18, 36, 15, 1, 0,
  15, 0, 25, 128, 48, 192, 112, 224, 112, 224, 240, 224, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 112, 224, 112, 224, 48, 192,
  25, 128, 15, 0, 8, 18, 18, 15, 3, 0, 24, 56, 248, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 255, 11, 18, 36, 15,
  2, 0, 31, 0, 113, 192, 96, 224, 224, 224, 240, 224, 248, 224, 121, 192,
  1, 192, 3, 0, 6, 0, 8, 0, 48, 32, 64, 32, 64, 32, 255, 224,
  191, 224, 143, 192, 135, 128, 12, 18, 36, 15, 1, 0, 31, 0, 49, 192,
  96, 224, 112, 224, 120, 224, 120, 224, 0, 192, 1, 128, 62, 0, 1, 192,
  0, 224, 0, 240, 112, 240, 248, 240, 240, 240, 192, 224, 65, 192, 63, 0,
  11, 18, 36, 15, 2, 0, 3, 0, 7, 0, 7, 0, 15, 0, 15, 0,
  23, 0, 55, 0, 39, 0, 103, 0, 71, 0, 199, 0, 135, 0, 255, 224,
  7, 0, 7, 0, 7, 0, 7, 0, 63, 224, 11, 18, 36, 15, 2, 0,
  65, 128, 127, 128, 126, 0, 120, 0, 64, 0, 64, 0, 95, 0, 99, 128,
  65, 192, 65, 224, 1, 224, 33, 224, 241, 224, 241, 224, 225, 192, 193, 192,
  67, 128, 62, 0, 11, 18, 36, 15, 2, 0, 7, 128, 24, 64, 48, 224,
  113, 224, 113, 224, 240, 0, 240, 0, 247, 128, 249, 192, 240, 224, 240, 224,
  240, 224, 240, 224, 112, 224, 112, 224, 48, 192, 57, 192, 15, 0, 11, 18,
  36, 15, 2, 0, 156, 64, 190, 96, 255, 32, 255, 224, 128, 32, 128, 64,
  128, 64, 0, 128, 1, 128, 3, 0, 7, 0, 6, 0, 14, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 12, 0, 12, 18, 36, 15, 1, 0, 31, 128,
  32, 64, 64, 32, 192, 32, 192, 32, 240, 32, 252, 64, 127, 128, 127, 192,
  63, 224, 103, 240, 193, 240, 192, 112, 192, 48, 192, 48, 96, 32, 112, 64,
  31, 128, 12, 18, 36, 15, 2, 0, 31, 0, 113, 128, 96, 192, 224, 224,
  224, 224, 224, 240, 224, 240, 96, 240, 113, 240, 30, 240, 0, 240, 0, 240,
  56, 224, 120, 224, 120, 224, 97, 192, 33, 128, 30, 0, 4, 12, 12, 8,
  2, 0, 96, 240, 240, 96, 0, 0, 0, 0, 96, 240, 240, 96, 4, 17,
  17, 7, 2, 251, 96, 240, 240, 96, 0, 0, 0, 0, 224, 240, 240, 240,
  16, 32, 32, 64, 128, 19, 21, 63, 24, 2, 252, 0, 0, 96, 0, 1,
  224, 0, 7, 128, 0, 14, 0, 0, 56, 0, 0, 224, 0, 3, 128, 0,
  15, 0, 0, 60, 0, 0, 112, 0, 0, 224, 0, 0, 120, 0, 0, 28,
  0, 0, 7, 0, 0, 1, 192, 0, 0, 112, 0, 0, 60, 0, 0, 15,
  0, 0, 3, 128, 0, 0, 224, 0, 0, 32, 21, 7, 21, 23, 1, 3,
  255, 255, 248, 255, 255, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255,
  255, 248, 255, 255, 248, 19, 21, 63, 24, 2, 252, 192, 0, 0, 240, 0,
  0, 60, 0, 0, 14, 0, 0, 3, 128, 0, 0, 224, 0, 0, 56, 0,
  0, 30, 0, 0, 7, 128, 0, 1, 192, 0, 0, 224, 0, 3, 192, 0,
  7, 0, 0, 28, 0, 0, 112, 0, 1, 192, 0, 7, 128, 0, 30, 0,
  0, 56, 0, 0, 224, 0, 0, 128, 0, 0, 8, 18, 18, 12, 2, 0,
  60, 78, 135, 135, 135, 78, 12, 24, 16, 32, 36, 36, 24, 0, 24, 60,
  60, 24, 18, 18, 54, 20, 1, 0, 3, 240, 0, 12, 12, 0, 24, 3,
  0, 48, 237, 0, 97, 173, 128, 99, 28, 128, 199, 28, 192, 207, 24, 192,
  206, 24, 192, 206, 56, 192, 206, 56, 192, 206, 56, 128, 78, 49, 128, 110,
  91, 0, 35, 156, 0, 48, 0, 0, 12, 4, 0, 3, 248, 0, 17, 18,
  54, 19, 1, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 1, 224, 0,
  1, 224, 0, 1, 224, 0, 2, 240, 0, 2, 240, 0, 4, 112, 0, 4,
  120, 0, 4, 120, 0, 8, 56, 0, 15, 252, 0, 8, 60, 0, 16, 28,
  0, 16, 30, 0, 48, 30, 0, 252, 127, 128, 15, 18, 36, 18, 2, 0,
  255, 224, 56, 56, 56, 56, 56, 28, 56, 28, 56, 28, 56, 56, 56, 48,
  63, 192, 56, 56, 56, 28, 56, 30, 56, 30, 56, 30, 56, 30, 56, 28,
  56, 56, 255, 240, 13, 18, 36, 17, 2, 0, 7, 136, 24, 120, 48, 56,
  112, 24, 112, 24, 240, 8, 240, 8, 240, 8, 240, 0, 240, 0, 240, 0,
  240, 8, 240, 8, 112, 8, 112, 8, 56, 16, 24, 32, 7, 192, 16, 18,
  36, 19, 2, 0, 255, 224, 56, 56, 56, 28, 56, 14, 56, 14, 56, 14,
  56, 15, 56, 15, 56, 15, 56, 15, 56, 15, 56, 15, 56, 14, 56, 14,
  56, 12, 56, 28, 56, 56, 255, 224, 14, 18, 36, 18, 2, 0, 255, 252,
  56, 28, 56, 12, 56, 12, 56, 4, 56, 68, 56, 64, 56, 192, 56, 192,
  63, 192, 56, 192, 56, 68, 56, 68, 56, 4, 56, 4, 56, 12, 56, 28,
  255, 252, 14, 18, 36, 17, 2, 0, 255, 252, 56, 60, 56, 28, 56, 12,
  56, 4, 56, 68, 56, 68, 56, 192, 56, 192, 63, 192, 56, 192, 56, 64,
  56, 64, 56, 0, 56, 0, 56, 0, 56, 0, 255, 0, 15, 18, 36, 18,
  2, 0, 7, 136, 24, 104, 48, 56, 112, 24, 112, 8, 112, 8, 240, 8,
  240, 0, 240, 0, 241, 254, 240, 56, 240, 56, 240, 56, 112, 56, 112, 56,
  48, 40, 24, 72, 15, 136, 17, 18, 54, 20, 2, 0, 255, 127, 128, 56,
  14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14,
  0, 56, 14, 0, 63, 254, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0,
  56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 255,
  127, 128, 8, 18, 18, 11, 2, 0, 255, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 255, 11, 18, 36, 13, 1, 0,
  31, 224, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128,
  3, 128, 3, 128, 3, 128, 115, 128, 243, 128, 243, 128, 227, 128, 195, 128,
  67, 0, 60, 0, 17, 18, 54, 19, 2, 0, 254, 127, 0, 56, 24, 0,
  56, 16, 0, 56, 32, 0, 56, 64, 0, 56, 192, 0, 57, 128, 0, 59,
  192, 0, 59, 192, 0, 61, 224, 0, 57, 240, 0, 56, 240, 0, 56, 248,
  0, 56, 120, 0, 56, 124, 0, 56, 60, 0, 56, 62, 0, 254, 127, 128,
  14, 18, 36, 17, 2, 0, 255, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 4, 56, 4, 56, 4,
  56, 12, 56, 12, 56, 28, 56, 60, 255, 252, 20, 18, 54, 22, 1, 0,
  254, 3, 240, 30, 3, 192, 30, 3, 192, 31, 5, 192, 31, 5, 192, 23,
  5, 192, 23, 133, 192, 23, 137, 192, 19, 201, 192, 19, 201, 192, 17, 209,
  192, 17, 241, 192, 17, 241, 192, 16, 241, 192, 16, 225, 192, 16, 225, 192,
  56, 97, 192, 254, 111, 240, 17, 18, 54, 18, 1, 0, 252, 63, 128, 60,
  14, 0, 62, 4, 0, 31, 4, 0, 31, 4, 0, 31, 132, 0, 23, 196,
  0, 19, 196, 0, 17, 228, 0, 17, 244, 0, 16, 244, 0, 16, 124, 0,
  16, 124, 0, 16, 60, 0, 16, 28, 0, 16, 28, 0, 56, 12, 0, 254,
  4, 0, 15, 18, 36, 18, 2, 0, 7, 192, 8, 32, 56, 48, 48, 24,
  112, 28, 112, 28, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30, 240, 30,
  112, 28, 112, 28, 48, 24, 48, 56, 8, 32, 7, 192, 15, 18, 36, 18,
  2, 0, 255, 240, 56, 56, 56, 28, 56, 30, 56, 30, 56, 30, 56, 30,
  56, 28, 56, 56, 63, 224, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 255, 128, 15, 24, 48, 18, 2, 250, 7, 192, 8, 32,
  56, 56, 48, 24, 112, 28, 112, 28, 240, 30, 240, 30, 240, 30, 240, 30,
  240, 30, 240, 30, 112, 28, 112, 28, 51, 152, 52, 176, 28, 226, 7, 194,
  0, 194, 0, 194, 0, 230, 0, 254, 0, 124, 0, 56, 16, 18, 36, 19,
  2, 0, 255, 224, 56, 120, 56, 56, 56, 60, 56, 60, 56, 60, 56, 56,
  56, 112, 63, 192, 56, 96, 56, 48, 56, 56, 56, 56, 56, 57, 56, 57,
  56, 57, 56, 57, 255, 158, 12, 18, 36, 15, 2, 0, 30, 32, 97, 160,
  192, 224, 192, 96, 224, 32, 240, 32, 252, 0, 126, 0, 63, 128, 15, 192,
  135, 224, 129, 240, 128, 240, 192, 48, 192, 48, 224, 32, 176, 96, 143, 128,
  15, 18, 36, 18, 2, 0, 255, 254, 231, 30, 199, 14, 135, 14, 135, 6,
  135, 6, 7, 2, 7, 2, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 31, 224, 18, 18, 54, 20, 2, 0,
  255, 31, 192, 56, 7, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56,
  2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 56, 2,
  0, 56, 2, 0, 56, 2, 0, 56, 2, 0, 24, 2, 0, 28, 4, 0,
  14, 8, 0, 3, 240, 0, 17, 18, 54, 19, 2, 0, 255, 63, 128, 60,
  6, 0, 60, 4, 0, 30, 4, 0, 30, 8, 0, 30, 8, 0, 15, 8,
  0, 15, 16, 0, 7, 144, 0, 7, 144, 0, 7, 160, 0, 3, 224, 0,
  3, 224, 0, 3, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 0,
  128, 0, 26, 18, 72, 27, 1, 0, 255, 191, 223, 192, 30, 15, 6, 0,
  30, 15, 6, 0, 15, 15, 4, 0, 15, 15, 132, 0, 15, 15, 132, 0,
  7, 143, 140, 0, 7, 139, 200, 0, 7, 147, 200, 0, 3, 211, 200, 0,
  3, 209, 240, 0, 3, 225, 240, 0, 1, 225, 240, 0, 1, 224, 240, 0,
  1, 224, 224, 0, 0, 192, 224, 0, 0, 192, 96, 0, 0, 192, 64, 0,
  16, 18, 36, 19, 2, 0, 255, 63, 62, 24, 30, 16, 31, 16, 15, 32,
  15, 224, 7, 192, 7, 192, 3, 192, 3, 224, 3, 224, 2, 240, 4, 240,
  8, 120, 8, 120, 16, 60, 48, 60, 252, 255, 16, 18, 36, 19, 2, 0,
  254, 127, 60, 12, 60, 8, 30, 16, 30, 16, 30, 16, 15, 32, 15, 32,
  7, 64, 7, 192, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128,
  3, 128, 15, 240, 13, 18, 36, 16, 2, 0, 127, 248, 112, 120, 96, 240,
  97, 240, 65, 224, 67, 224, 3, 192, 7, 192, 7, 128, 15, 0, 15, 0,
  30, 0, 30, 8, 60, 8, 124, 24, 120, 24, 248, 56, 255, 248, 6, 22,
  22, 10, 2, 252, 252, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 252, 9, 23, 46, 11, 1, 251,
  192, 0, 64, 0, 96, 0, 96, 0, 32, 0, 48, 0, 48, 0, 16, 0,
  24, 0, 24, 0, 24, 0, 8, 0, 12, 0, 12, 0, 4, 0, 6, 0,
  6, 0, 2, 0, 3, 0, 3, 0, 1, 0, 1, 128, 1, 128, 6, 22,
  22, 10, 2, 252, 252, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 252, 11, 9, 18, 15, 2, 9,
  4, 0, 12, 0, 30, 0, 27, 0, 51, 0, 49, 128, 96, 192, 192, 192,
  192, 96, 13, 2, 4, 13, 0, 252, 255, 248, 255, 248, 4, 4, 4, 11,
  2, 13, 192, 224, 96, 48, 11, 12, 24, 13, 1, 0, 30, 0, 99, 0,
  99, 128, 115, 128, 35, 128, 31, 128, 115, 128, 227, 128, 227, 160, 227, 160,
  247, 160, 121, 192, 12, 18, 36, 13, 0, 0, 248, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 59, 128, 60, 224, 60, 224, 56, 112, 56, 112,
  56, 112, 56, 112, 56, 112, 56, 112, 60, 224, 36, 192, 35, 128, 9, 12,
  24, 12, 1, 0, 30, 0, 49, 0, 113, 128, 227, 128, 227, 128, 224, 0,
  224, 0, 224, 0, 224, 128, 112, 128, 49, 0, 30, 0, 12, 18, 36, 13,
  1, 0, 7, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 29, 192,
  115, 192, 99, 192, 225, 192, 225, 192, 225, 192, 225, 192, 225, 192, 225, 192,
  99, 192, 115, 192, 29, 240, 9, 12, 24, 12, 1, 0, 30, 0, 51, 0,
  99, 128, 227, 128, 227, 128, 255, 128, 224, 0, 224, 0, 224, 128, 112, 128,
  49, 0, 30, 0, 9, 18, 36, 9, 1, 0, 15, 0, 29, 128, 59, 128,
  59, 128, 57, 0, 56, 0, 252, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 252, 0, 12, 18,
  36, 14, 1, 250, 30, 112, 51, 176, 113, 240, 113, 192, 113, 192, 113, 192,
  51, 128, 30, 0, 96, 0, 127, 128, 127, 192, 63, 224, 96, 224, 128, 96,
  128, 96, 128, 64, 64, 192, 63, 0, 12, 18, 36, 13, 0, 0, 248, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 57, 192, 62, 224, 60, 224,
  56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224,
  253, 240, 5, 18, 18, 7, 1, 0, 112, 112, 112, 32, 0, 0, 240, 112,
  112, 112, 112, 112, 112, 112, 112, 112, 112, 248, 7, 24, 24, 8, 255, 250,
  14, 14, 14, 4, 0, 0, 62, 14, 14, 14, 14, 14, 14, 14, 14, 14,
  14, 14, 14, 110, 238, 238, 204, 120, 13, 18, 36, 13, 0, 0, 248, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 57, 240, 56, 192, 56, 128,
  57, 0, 57, 0, 59, 128, 63, 128, 57, 192, 57, 192, 56, 224, 56, 224,
  255, 248, 7, 18, 18, 8, 0, 0, 248, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 254, 18, 12, 36, 19, 1, 0,
  243, 142, 0, 125, 247, 0, 121, 231, 0, 113, 199, 0, 113, 199, 0, 113,
  199, 0, 113, 199, 0, 113, 199, 0, 113, 199, 0, 113, 199, 0, 113, 199,
  0, 251, 239, 192, 11, 12, 24, 13, 1, 0, 243, 128, 125, 192, 121, 192,
  113, 192, 113, 192, 113, 192, 113, 192, 113, 192, 113, 192, 113, 192, 113, 192,
  251, 224, 10, 12, 24, 12, 1, 0, 30, 0, 51, 0, 97, 128, 225, 192,
  225, 192, 225, 192, 225, 192, 225, 192, 225, 192, 97, 128, 51, 0, 30, 0,
  12, 18, 36, 13, 0, 250, 251, 128, 60, 192, 60, 224, 56, 112, 56, 112,
  56, 112, 56, 112, 56, 112, 56, 112, 60, 224, 60, 224, 59, 192, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 254, 0, 11, 18, 36, 13, 1, 250,
  28, 64, 50, 64, 99, 192, 225, 192, 225, 192, 225, 192, 225, 192, 225, 192,
  225, 192, 99, 192, 115, 192, 61, 192, 1, 192, 1, 192, 1, 192, 1, 192,
  1, 192, 7, 224, 9, 12, 24, 11, 1, 0, 243, 0, 117, 128, 123, 128,
  123, 128, 112, 0, 112, 0, 112, 0, 112, 0, 112, 0, 112, 0, 112, 0,
  248, 0, 9, 12, 24, 11, 1, 0, 57, 0, 199, 0, 195, 0, 225, 0,
  240, 0, 124, 0, 63, 0, 143, 128, 131, 128, 193, 128, 225, 0, 158, 0,
  8, 17, 17, 10, 1, 0, 16, 16, 16, 48, 112, 254, 112, 112, 112, 112,
  112, 113, 113, 113, 113, 114, 60, 12, 12, 24, 13, 0, 0, 249, 224, 56,
  224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 57,
  224, 58, 224, 28, 240, 12, 12, 24, 13, 1, 0, 253, 240, 112, 64, 56,
  64, 56, 128, 28, 128, 28, 128, 29, 0, 15, 0, 14, 0, 14, 0, 6,
  0, 4, 0, 19, 12, 36, 19, 0, 0, 253, 251, 224, 56, 112, 128, 28,
  112, 128, 28, 113, 0, 28, 121, 0, 14, 185, 0, 14, 154, 0, 14, 158,
  0, 7, 28, 0, 7, 12, 0, 2, 12, 0, 2, 8, 0, 12, 12, 24,
  13, 0, 0, 253, 240, 56, 64, 28, 128, 31, 0, 15, 0, 15, 0, 7,
  0, 7, 128, 11, 192, 17, 192, 17, 224, 253, 240, 12, 18, 36, 12, 0,
  250, 252, 240, 112, 64, 56, 64, 56, 128, 28, 128, 28, 128, 29, 0, 15,
  0, 15, 0, 7, 0, 6, 0, 6, 0, 2, 0, 4, 0, 116, 0, 116,
  0, 104, 0, 56, 0, 10, 12, 24, 12, 1, 0, 127, 192, 99, 128, 71,
  128, 71, 0, 15, 0, 14, 0, 28, 0, 60, 64, 56, 64, 120, 64, 112,
  192, 255, 192, 8, 23, 23, 10, 1, 251, 3, 28, 56, 56, 56, 56, 56,
  56, 56, 56, 48, 192, 48, 56, 56, 56, 56, 56, 56, 56, 56, 28, 3,
  2, 23, 23, 8, 3, 251, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 8, 23, 23,
  11, 2, 251, 192, 112, 56, 56, 56, 56, 56, 56, 56, 56, 28, 7, 28,
  56, 56, 56, 56, 56, 56, 56, 56, 112, 192, 14, 5, 10, 16, 1, 4,
  120, 8, 255, 4, 143, 196, 131, 252, 64, 120, 255
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--28-280-72-72-P-153-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 21, '1' Height: 21
  Calculated Max Values w=28 h=29 x= 5 y=17 dx=31 dy= 0 ascent=28 len=87
  Font Bounding box     w=77 h=36 x=-24 y=-8
  Calculated Min Values           x=-1 y=-8 dx= 0 dy= 0
  Pure Font   ascent =21 descent=-7
  X Font      ascent =21 descent=-7
  Max Font    ascent =28 descent=-8
*/
const u8g_fntpgm_uint8_t u8g_font_osb21[9612] U8G_FONT_SECTION("u8g_font_osb21") = {
  0, 77, 36, 232, 248, 21, 5, 141, 12, 241, 32, 255, 249, 28, 248, 21,
  249, 0, 0, 0, 8, 0, 0, 5, 21, 21, 9, 2, 1, 240, 248, 248,
  248, 248, 112, 112, 112, 112, 32, 32, 32, 32, 32, 32, 0, 0, 112, 248,
  248, 112, 7, 6, 6, 11, 2, 16, 238, 238, 238, 238, 198, 68, 16, 21,
  42, 20, 2, 0, 6, 12, 6, 12, 6, 12, 6, 8, 6, 24, 6, 24,
  255, 255, 255, 255, 12, 24, 12, 24, 12, 48, 12, 48, 12, 48, 8, 48,
  255, 255, 255, 255, 24, 32, 24, 96, 24, 96, 16, 96, 48, 96, 13, 25,
  50, 16, 2, 254, 9, 0, 11, 0, 61, 192, 105, 48, 73, 8, 201, 8,
  201, 56, 233, 120, 249, 112, 253, 0, 127, 0, 127, 0, 63, 192, 15, 224,
  15, 240, 73, 248, 233, 248, 233, 56, 201, 24, 137, 24, 137, 16, 73, 32,
  57, 192, 15, 0, 9, 0, 19, 22, 66, 25, 3, 0, 0, 1, 0, 60,
  3, 0, 102, 2, 0, 231, 4, 0, 231, 4, 0, 231, 8, 0, 231, 8,
  0, 231, 16, 0, 231, 48, 0, 102, 32, 0, 102, 96, 0, 24, 64, 0,
  0, 195, 0, 0, 140, 192, 1, 140, 192, 1, 28, 224, 2, 28, 224, 2,
  28, 224, 4, 28, 224, 4, 28, 224, 8, 12, 192, 24, 7, 128, 20, 21,
  63, 22, 1, 1, 3, 224, 0, 6, 16, 0, 14, 16, 0, 14, 16, 0,
  14, 16, 0, 14, 48, 0, 15, 32, 0, 15, 64, 0, 7, 128, 0, 3,
  192, 0, 7, 195, 240, 9, 224, 192, 48, 224, 128, 112, 240, 128, 112, 121,
  0, 240, 59, 0, 240, 62, 0, 240, 30, 0, 248, 31, 16, 126, 111, 160,
  63, 199, 192, 3, 6, 6, 7, 2, 16, 224, 224, 224, 224, 192, 64, 8,
  27, 27, 10, 2, 250, 1, 2, 4, 8, 24, 48, 48, 112, 112, 240, 240,
  240, 240, 240, 240, 240, 240, 112, 112, 112, 48, 48, 24, 8, 4, 2, 1,
  8, 26, 26, 10, 1, 250, 128, 192, 96, 48, 24, 24, 12, 12, 14, 14,
  14, 14, 15, 15, 15, 14, 14, 14, 14, 12, 12, 24, 24, 48, 96, 192,
  11, 12, 24, 14, 2, 9, 14, 0, 14, 0, 78, 192, 228, 224, 245, 192,
  14, 0, 14, 0, 245, 192, 228, 192, 78, 192, 14, 0, 14, 0, 24, 25,
  75, 26, 1, 252, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0,
  0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0,
  24, 0, 0, 24, 0, 0, 24, 0, 255, 255, 255, 255, 255, 255, 0, 24,
  0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0,
  0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 5,
  10, 10, 7, 1, 251, 112, 248, 248, 248, 120, 8, 16, 16, 32, 192, 7,
  3, 3, 11, 2, 6, 254, 254, 254, 4, 4, 4, 8, 2, 0, 96, 240,
  240, 96, 9, 27, 54, 13, 2, 250, 1, 128, 1, 128, 1, 128, 3, 0,
  3, 0, 3, 0, 2, 0, 6, 0, 6, 0, 6, 0, 12, 0, 12, 0,
  12, 0, 24, 0, 24, 0, 24, 0, 16, 0, 48, 0, 48, 0, 48, 0,
  96, 0, 96, 0, 96, 0, 192, 0, 192, 0, 192, 0, 128, 0, 14, 21,
  42, 16, 1, 1, 15, 192, 24, 96, 56, 112, 56, 112, 120, 120, 120, 120,
  248, 120, 248, 124, 248, 124, 248, 124, 248, 124, 248, 124, 248, 124, 248, 124,
  248, 120, 120, 120, 120, 120, 56, 112, 56, 112, 24, 96, 15, 192, 9, 21,
  42, 16, 3, 0, 6, 0, 14, 0, 30, 0, 254, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 255, 128, 12, 21,
  42, 16, 2, 1, 63, 192, 97, 224, 96, 224, 224, 240, 224, 240, 240, 240,
  248, 240, 121, 224, 49, 224, 3, 192, 7, 128, 14, 0, 28, 0, 48, 16,
  96, 16, 64, 16, 192, 16, 255, 240, 255, 224, 143, 224, 135, 192, 13, 21,
  42, 16, 2, 1, 63, 192, 96, 224, 96, 224, 224, 240, 240, 240, 248, 240,
  120, 240, 112, 240, 0, 224, 1, 192, 31, 0, 0, 224, 0, 240, 0, 112,
  112, 120, 248, 120, 248, 120, 240, 120, 224, 112, 96, 240, 59, 192, 13, 21,
  42, 16, 1, 0, 1, 192, 1, 192, 3, 192, 3, 192, 7, 192, 7, 192,
  15, 192, 27, 192, 27, 192, 51, 192, 35, 192, 99, 192, 67, 192, 195, 192,
  255, 248, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 31, 248, 13, 21,
  42, 16, 2, 0, 96, 224, 127, 192, 127, 128, 127, 0, 120, 0, 64, 0,
  64, 0, 64, 0, 79, 0, 113, 224, 64, 240, 64, 240, 0, 248, 0, 248,
  112, 248, 248, 248, 248, 248, 240, 240, 224, 240, 97, 224, 59, 192, 13, 21,
  42, 16, 2, 1, 15, 224, 24, 32, 56, 48, 48, 240, 112, 240, 112, 240,
  240, 96, 240, 0, 240, 0, 247, 128, 248, 224, 240, 112, 240, 112, 240, 112,
  240, 120, 112, 120, 112, 112, 112, 112, 48, 112, 56, 96, 13, 192, 11, 21,
  42, 16, 3, 0, 156, 64, 190, 96, 255, 32, 255, 32, 199, 224, 129, 160,
  128, 64, 128, 64, 0, 128, 0, 128, 1, 0, 3, 0, 7, 0, 6, 0,
  14, 0, 14, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 14, 21,
  42, 16, 2, 1, 31, 192, 48, 32, 96, 48, 96, 16, 224, 16, 240, 16,
  248, 32, 254, 32, 127, 192, 63, 192, 31, 240, 31, 248, 99, 248, 64, 248,
  192, 60, 192, 24, 192, 24, 192, 24, 96, 16, 112, 48, 31, 192, 13, 21,
  42, 16, 2, 1, 31, 128, 48, 192, 112, 96, 112, 112, 240, 112, 240, 112,
  240, 120, 240, 120, 240, 120, 112, 120, 112, 120, 56, 248, 15, 120, 0, 120,
  0, 120, 56, 112, 120, 112, 120, 96, 112, 224, 96, 192, 63, 128, 4, 14,
  14, 8, 2, 0, 96, 240, 240, 240, 96, 0, 0, 0, 0, 0, 96, 240,
  240, 96, 5, 19, 19, 8, 2, 251, 96, 240, 240, 240, 96, 0, 0, 0,
  0, 112, 248, 248, 248, 248, 8, 16, 16, 32, 192, 21, 24, 72, 26, 2,
  252, 0, 0, 24, 0, 0, 56, 0, 0, 240, 0, 3, 192, 0, 15, 0,
  0, 28, 0, 0, 120, 0, 1, 224, 0, 7, 128, 0, 14, 0, 0, 60,
  0, 0, 240, 0, 0, 224, 0, 0, 120, 0, 0, 30, 0, 0, 7, 128,
  0, 1, 192, 0, 0, 240, 0, 0, 60, 0, 0, 15, 0, 0, 3, 128,
  0, 1, 224, 0, 0, 120, 0, 0, 24, 24, 8, 24, 26, 1, 4, 255,
  255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 255, 255, 255, 255, 255, 255, 21, 24, 72, 26, 3, 252, 128, 0, 0,
  224, 0, 0, 120, 0, 0, 30, 0, 0, 7, 128, 0, 1, 192, 0, 0,
  240, 0, 0, 60, 0, 0, 15, 0, 0, 3, 128, 0, 1, 224, 0, 0,
  120, 0, 0, 56, 0, 0, 240, 0, 3, 192, 0, 15, 0, 0, 28, 0,
  0, 120, 0, 1, 224, 0, 7, 128, 0, 14, 0, 0, 60, 0, 0, 240,
  0, 0, 192, 0, 0, 9, 21, 42, 13, 2, 1, 126, 0, 71, 0, 135,
  128, 135, 128, 135, 128, 135, 128, 71, 0, 14, 0, 12, 0, 28, 0, 16,
  0, 48, 0, 34, 0, 34, 0, 34, 0, 28, 0, 0, 0, 12, 0, 30,
  0, 30, 0, 12, 0, 20, 22, 66, 22, 1, 0, 0, 32, 0, 3, 222,
  0, 12, 3, 0, 24, 0, 128, 48, 0, 192, 48, 112, 96, 97, 207, 96,
  99, 142, 48, 199, 142, 48, 199, 14, 48, 199, 14, 48, 207, 14, 48, 207,
  28, 48, 207, 28, 32, 207, 28, 96, 79, 60, 64, 103, 44, 128, 99, 199,
  0, 48, 0, 0, 24, 0, 0, 12, 2, 0, 3, 252, 0, 19, 21, 63,
  22, 2, 0, 0, 64, 0, 0, 96, 0, 0, 224, 0, 0, 224, 0, 0,
  240, 0, 1, 240, 0, 1, 240, 0, 1, 248, 0, 2, 120, 0, 2, 120,
  0, 2, 124, 0, 4, 60, 0, 4, 60, 0, 4, 62, 0, 15, 254, 0,
  8, 30, 0, 8, 31, 0, 16, 15, 0, 16, 15, 0, 48, 15, 128, 254,
  127, 224, 17, 21, 63, 19, 1, 0, 255, 240, 0, 30, 28, 0, 30, 14,
  0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 30, 14, 0,
  30, 14, 0, 30, 24, 0, 31, 224, 0, 30, 28, 0, 30, 15, 0, 30,
  7, 0, 30, 7, 128, 30, 7, 128, 30, 7, 128, 30, 7, 128, 30, 7,
  0, 30, 14, 0, 255, 248, 0, 15, 21, 42, 18, 2, 1, 15, 230, 28,
  30, 56, 30, 56, 14, 120, 14, 120, 6, 248, 6, 248, 6, 248, 2, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 2, 248, 2, 120, 2, 120, 4, 56,
  4, 60, 12, 28, 8, 15, 240, 19, 21, 63, 21, 1, 0, 255, 248, 0,
  30, 14, 0, 30, 7, 0, 30, 3, 128, 30, 3, 192, 30, 3, 192, 30,
  3, 192, 30, 3, 224, 30, 3, 224, 30, 3, 224, 30, 3, 224, 30, 3,
  224, 30, 3, 224, 30, 3, 224, 30, 3, 192, 30, 3, 192, 30, 3, 192,
  30, 3, 128, 30, 7, 0, 30, 14, 0, 255, 248, 0, 16, 21, 42, 19,
  1, 0, 255, 255, 30, 15, 30, 7, 30, 3, 30, 3, 30, 1, 30, 17,
  30, 16, 30, 48, 30, 48, 31, 240, 30, 48, 30, 48, 30, 17, 30, 17,
  30, 1, 30, 1, 30, 3, 30, 7, 30, 15, 255, 255, 17, 21, 63, 19,
  1, 0, 255, 255, 128, 30, 15, 128, 30, 7, 128, 30, 3, 128, 30, 1,
  128, 30, 1, 128, 30, 17, 128, 30, 17, 128, 30, 48, 0, 30, 48, 0,
  31, 240, 0, 30, 48, 0, 30, 48, 0, 30, 16, 0, 30, 16, 0, 30,
  0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 255, 192,
  0, 17, 22, 66, 20, 2, 0, 0, 128, 0, 7, 114, 0, 28, 30, 0,
  24, 14, 0, 56, 6, 0, 120, 6, 0, 120, 6, 0, 120, 2, 0, 248,
  2, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 255, 128, 248, 30,
  0, 248, 30, 0, 248, 30, 0, 120, 30, 0, 120, 30, 0, 56, 30, 0,
  56, 22, 0, 28, 34, 0, 14, 194, 0, 20, 21, 63, 22, 1, 0, 255,
  223, 240, 30, 3, 192, 30, 3, 192, 30, 3, 192, 30, 3, 192, 30, 3,
  192, 30, 3, 192, 30, 3, 192, 30, 3, 192, 30, 3, 192, 31, 255, 192,
  30, 3, 192, 30, 3, 192, 30, 3, 192, 30, 3, 192, 30, 3, 192, 30,
  3, 192, 30, 3, 192, 30, 3, 192, 30, 3, 192, 255, 223, 240, 9, 21,
  42, 11, 1, 0, 255, 128, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 255, 128, 13, 21,
  42, 15, 1, 0, 15, 248, 1, 224, 1, 224, 1, 224, 1, 224, 1, 224,
  1, 224, 1, 224, 1, 224, 1, 224, 1, 224, 1, 224, 1, 224, 113, 224,
  249, 224, 249, 224, 249, 192, 225, 192, 193, 192, 65, 128, 55, 0, 19, 21,
  63, 21, 1, 0, 255, 159, 192, 30, 7, 0, 30, 6, 0, 30, 12, 0,
  30, 8, 0, 30, 16, 0, 30, 32, 0, 30, 96, 0, 30, 240, 0, 31,
  240, 0, 31, 248, 0, 30, 248, 0, 30, 124, 0, 30, 124, 0, 30, 62,
  0, 30, 30, 0, 30, 31, 0, 30, 15, 0, 30, 15, 128, 30, 15, 128,
  255, 159, 224, 17, 21, 63, 19, 1, 0, 255, 128, 0, 30, 0, 0, 30,
  0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0,
  0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 1, 0,
  30, 1, 128, 30, 1, 128, 30, 1, 128, 30, 3, 128, 30, 3, 128, 30,
  7, 128, 30, 15, 128, 255, 255, 128, 23, 21, 63, 25, 1, 0, 254, 0,
  254, 30, 0, 240, 31, 1, 240, 31, 1, 240, 31, 1, 240, 31, 129, 240,
  23, 130, 240, 23, 194, 240, 23, 194, 240, 19, 196, 240, 19, 228, 240, 17,
  228, 240, 17, 228, 240, 17, 248, 240, 16, 248, 240, 16, 248, 240, 16, 248,
  240, 16, 112, 240, 16, 112, 240, 56, 48, 240, 254, 35, 254, 21, 21, 63,
  22, 1, 0, 254, 15, 248, 31, 1, 192, 31, 0, 128, 15, 128, 128, 15,
  192, 128, 15, 192, 128, 11, 224, 128, 11, 240, 128, 9, 248, 128, 8, 248,
  128, 8, 252, 128, 8, 126, 128, 8, 62, 128, 8, 31, 128, 8, 31, 128,
  8, 15, 128, 8, 7, 128, 8, 7, 128, 8, 3, 128, 28, 1, 128, 255,
  129, 128, 17, 22, 66, 20, 2, 0, 0, 128, 0, 7, 112, 0, 12, 24,
  0, 24, 12, 0, 56, 14, 0, 120, 14, 0, 120, 15, 0, 120, 15, 0,
  248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248,
  15, 128, 248, 15, 128, 120, 15, 0, 120, 15, 0, 120, 15, 0, 56, 14,
  0, 24, 12, 0, 12, 24, 0, 7, 112, 0, 17, 21, 63, 19, 1, 0,
  255, 248, 0, 30, 14, 0, 30, 7, 0, 30, 7, 128, 30, 7, 128, 30,
  7, 128, 30, 7, 128, 30, 7, 128, 30, 15, 0, 30, 14, 0, 31, 248,
  0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0,
  30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 255, 192, 0, 17,
  29, 87, 20, 2, 249, 0, 128, 0, 7, 112, 0, 12, 24, 0, 24, 12,
  0, 56, 14, 0, 120, 14, 0, 120, 15, 0, 120, 15, 0, 248, 15, 128,
  248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248,
  15, 128, 120, 15, 0, 120, 15, 0, 121, 142, 0, 58, 78, 0, 30, 124,
  0, 30, 120, 128, 6, 112, 128, 1, 224, 128, 0, 96, 128, 0, 113, 128,
  0, 127, 128, 0, 127, 0, 0, 63, 0, 0, 30, 0, 19, 21, 63, 21,
  1, 0, 255, 240, 0, 30, 28, 0, 30, 14, 0, 30, 15, 0, 30, 15,
  0, 30, 15, 0, 30, 15, 0, 30, 14, 0, 30, 28, 0, 31, 224, 0,
  30, 48, 0, 30, 28, 0, 30, 28, 0, 30, 28, 0, 30, 30, 0, 30,
  30, 0, 30, 30, 32, 30, 30, 32, 30, 30, 32, 30, 14, 64, 255, 207,
  192, 13, 22, 44, 17, 3, 0, 4, 0, 59, 144, 64, 240, 192, 112, 192,
  112, 224, 48, 240, 48, 248, 16, 254, 16, 127, 0, 63, 128, 31, 224, 15,
  240, 131, 240, 129, 248, 128, 120, 192, 56, 192, 24, 224, 24, 224, 16, 240,
  48, 159, 192, 17, 21, 63, 20, 2, 0, 255, 255, 128, 227, 207, 128, 195,
  199, 128, 195, 195, 128, 131, 195, 128, 131, 193, 128, 131, 193, 128, 3, 193,
  128, 3, 192, 128, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0,
  3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 31, 248, 0, 19, 21, 63, 22, 2, 0, 255, 15,
  224, 60, 3, 128, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0,
  60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60,
  1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1,
  0, 28, 1, 0, 28, 2, 0, 14, 4, 0, 7, 248, 0, 20, 21, 63,
  22, 1, 0, 255, 207, 240, 30, 1, 128, 31, 1, 0, 31, 1, 0, 15,
  1, 0, 15, 130, 0, 15, 130, 0, 7, 130, 0, 7, 196, 0, 7, 196,
  0, 3, 196, 0, 3, 232, 0, 3, 232, 0, 1, 232, 0, 1, 248, 0,
  0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 96, 0, 0, 96, 0, 0,
  96, 0, 28, 21, 84, 31, 2, 0, 255, 191, 231, 240, 62, 15, 129, 192,
  30, 7, 129, 128, 30, 7, 129, 128, 31, 7, 193, 0, 15, 7, 193, 0,
  15, 7, 193, 0, 15, 143, 226, 0, 7, 137, 226, 0, 7, 137, 226, 0,
  7, 201, 246, 0, 3, 208, 244, 0, 3, 208, 244, 0, 3, 240, 252, 0,
  1, 240, 124, 0, 1, 224, 120, 0, 1, 224, 120, 0, 0, 224, 56, 0,
  0, 192, 48, 0, 0, 192, 48, 0, 0, 64, 16, 0, 19, 21, 63, 20,
  1, 0, 255, 159, 192, 63, 6, 0, 31, 6, 0, 15, 4, 0, 15, 136,
  0, 7, 152, 0, 7, 208, 0, 3, 240, 0, 3, 224, 0, 1, 240, 0,
  1, 240, 0, 0, 248, 0, 1, 248, 0, 3, 124, 0, 2, 124, 0, 6,
  62, 0, 4, 62, 0, 8, 30, 0, 24, 31, 0, 24, 31, 128, 254, 63,
  224, 18, 21, 63, 21, 2, 0, 255, 31, 192, 62, 7, 0, 30, 6, 0,
  30, 4, 0, 31, 4, 0, 15, 4, 0, 15, 136, 0, 7, 136, 0, 7,
  144, 0, 7, 208, 0, 3, 240, 0, 3, 224, 0, 1, 224, 0, 1, 224,
  0, 1, 224, 0, 1, 224, 0, 1, 224, 0, 1, 224, 0, 1, 224, 0,
  1, 224, 0, 7, 248, 0, 15, 21, 42, 19, 2, 0, 127, 254, 120, 62,
  112, 124, 96, 124, 96, 248, 64, 248, 65, 240, 1, 240, 3, 224, 3, 224,
  7, 192, 7, 128, 15, 128, 31, 2, 31, 2, 62, 2, 62, 6, 124, 6,
  124, 14, 248, 30, 255, 254, 7, 26, 26, 11, 2, 251, 254, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 254, 10, 27, 54, 13, 1, 250, 192, 0, 96, 0,
  96, 0, 96, 0, 32, 0, 48, 0, 48, 0, 48, 0, 24, 0, 24, 0,
  24, 0, 12, 0, 12, 0, 12, 0, 4, 0, 6, 0, 6, 0, 6, 0,
  3, 0, 3, 0, 3, 0, 1, 128, 1, 128, 1, 128, 0, 128, 0, 192,
  0, 192, 7, 26, 26, 11, 2, 251, 254, 30, 30, 30, 30, 30, 30, 30,
  30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
  30, 254, 12, 10, 20, 16, 2, 12, 6, 0, 7, 0, 15, 0, 29, 128,
  25, 128, 48, 192, 48, 224, 96, 96, 224, 48, 192, 48, 15, 2, 4, 15,
  0, 251, 255, 254, 255, 254, 5, 5, 5, 12, 2, 16, 192, 224, 112, 48,
  24, 12, 14, 28, 14, 1, 0, 30, 0, 99, 128, 99, 192, 243, 192, 115,
  192, 35, 192, 15, 192, 51, 192, 115, 192, 243, 192, 243, 208, 243, 208, 243,
  208, 125, 224, 13, 21, 42, 14, 0, 0, 252, 0, 60, 0, 60, 0, 60,
  0, 60, 0, 60, 0, 60, 0, 61, 192, 62, 96, 60, 112, 60, 112, 60,
  120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 112, 52, 112, 38,
  96, 35, 192, 10, 14, 28, 13, 1, 0, 15, 0, 56, 128, 112, 192, 113,
  192, 243, 192, 243, 128, 240, 0, 240, 0, 240, 0, 240, 0, 112, 64, 112,
  64, 56, 128, 15, 0, 13, 21, 42, 15, 1, 0, 3, 224, 1, 224, 1,
  224, 1, 224, 1, 224, 1, 224, 1, 224, 29, 224, 51, 224, 113, 224, 113,
  224, 241, 224, 241, 224, 241, 224, 241, 224, 241, 224, 241, 224, 113, 224, 113,
  224, 51, 224, 29, 248, 11, 14, 28, 13, 1, 0, 15, 0, 51, 128, 113,
  192, 113, 192, 241, 192, 241, 224, 255, 224, 240, 0, 240, 0, 240, 32, 112,
  64, 112, 64, 56, 128, 15, 0, 11, 21, 42, 10, 1, 0, 7, 128, 12,
  192, 28, 192, 61, 224, 61, 192, 60, 0, 60, 0, 254, 0, 60, 0, 60,
  0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60,
  0, 60, 0, 60, 0, 254, 0, 14, 21, 42, 16, 1, 249, 15, 24, 57,
  236, 121, 252, 121, 248, 121, 224, 121, 224, 57, 192, 57, 192, 15, 0, 112,
  0, 192, 0, 255, 0, 255, 224, 127, 240, 63, 248, 64, 56, 128, 24, 128,
  16, 128, 48, 96, 96, 31, 128, 14, 21, 42, 16, 1, 0, 252, 0, 60,
  0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 61, 224, 62, 112, 60,
  112, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60,
  120, 60, 120, 60, 120, 254, 252, 6, 21, 21, 8, 1, 0, 48, 120, 120,
  48, 0, 0, 0, 248, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120,
  120, 252, 8, 28, 28, 8, 255, 249, 6, 15, 15, 6, 0, 0, 0, 31,
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 79, 255,
  239, 238, 206, 56, 14, 21, 42, 16, 1, 0, 252, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 248, 60, 96, 60, 64, 60, 128,
  60, 128, 61, 128, 63, 128, 63, 192, 61, 224, 60, 224, 60, 240, 60, 112,
  60, 120, 254, 252, 8, 21, 21, 9, 1, 0, 252, 60, 60, 60, 60, 60,
  60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 255, 20,
  14, 42, 23, 2, 0, 249, 199, 128, 126, 233, 192, 120, 241, 192, 120, 241,
  224, 120, 241, 224, 120, 241, 224, 120, 241, 224, 120, 241, 224, 120, 241, 224,
  120, 241, 224, 120, 241, 224, 120, 241, 224, 120, 241, 224, 253, 251, 240, 13,
  14, 28, 16, 2, 0, 251, 192, 124, 224, 120, 224, 120, 240, 120, 240, 120,
  240, 120, 240, 120, 240, 120, 240, 120, 240, 120, 240, 120, 240, 120, 240, 253,
  248, 12, 14, 28, 14, 1, 0, 15, 0, 49, 128, 112, 192, 112, 224, 240,
  224, 240, 224, 240, 240, 240, 240, 240, 224, 240, 224, 112, 224, 112, 192, 49,
  128, 15, 0, 13, 21, 42, 15, 1, 249, 253, 192, 62, 96, 60, 112, 60,
  112, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 112, 60,
  112, 62, 96, 61, 192, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60,
  0, 254, 0, 13, 21, 42, 14, 1, 249, 30, 32, 51, 32, 113, 96, 113,
  224, 241, 224, 241, 224, 241, 224, 241, 224, 241, 224, 241, 224, 113, 224, 113,
  224, 51, 224, 29, 224, 1, 224, 1, 224, 1, 224, 1, 224, 1, 224, 1,
  224, 3, 248, 10, 14, 28, 12, 2, 0, 251, 128, 125, 128, 123, 192, 123,
  128, 121, 128, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120,
  0, 120, 0, 252, 0, 10, 14, 28, 13, 2, 0, 60, 128, 67, 128, 193,
  128, 193, 128, 224, 128, 248, 0, 126, 0, 63, 128, 143, 128, 131, 192, 192,
  192, 224, 192, 240, 128, 143, 0, 9, 20, 40, 10, 0, 0, 8, 0, 8,
  0, 8, 0, 24, 0, 24, 0, 56, 0, 255, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 56, 0, 56, 0, 56, 128, 56, 128, 56, 128, 56, 128, 57,
  128, 57, 0, 14, 0, 14, 14, 28, 15, 0, 0, 253, 248, 60, 120, 60,
  120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60,
  120, 60, 248, 29, 120, 14, 124, 13, 14, 28, 15, 1, 0, 252, 248, 120,
  32, 56, 32, 60, 32, 28, 64, 28, 64, 30, 64, 14, 128, 14, 128, 15,
  0, 7, 0, 7, 0, 6, 0, 2, 0, 20, 14, 42, 22, 1, 0, 253,
  253, 240, 120, 120, 64, 56, 120, 64, 60, 56, 64, 28, 120, 128, 28, 124,
  128, 30, 92, 128, 14, 157, 0, 14, 159, 0, 15, 143, 0, 7, 14, 0,
  7, 14, 0, 6, 6, 0, 2, 4, 0, 13, 14, 28, 15, 1, 0, 254,
  248, 60, 96, 60, 64, 30, 128, 30, 128, 15, 0, 7, 0, 7, 128, 7,
  192, 11, 192, 9, 224, 16, 224, 48, 240, 253, 248, 13, 21, 42, 15, 1,
  249, 252, 248, 120, 32, 56, 32, 60, 64, 28, 64, 28, 64, 30, 64, 14,
  128, 15, 128, 7, 128, 7, 128, 7, 0, 3, 0, 3, 0, 2, 0, 2,
  0, 50, 0, 122, 0, 116, 0, 116, 0, 56, 0, 11, 14, 28, 13, 1,
  0, 127, 224, 97, 224, 67, 192, 67, 128, 71, 128, 15, 0, 15, 0, 30,
  0, 30, 32, 60, 32, 56, 32, 120, 96, 240, 224, 255, 224, 9, 27, 54,
  12, 1, 250, 0, 128, 7, 0, 14, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 28, 0, 28, 0, 56, 0, 224, 0, 56,
  0, 28, 0, 28, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 14, 0, 7, 0, 0, 128, 2, 27, 27, 8, 3, 250, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 9, 27, 54, 13, 2, 250,
  192, 0, 56, 0, 28, 0, 28, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 14, 0, 1, 128, 14, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 28, 0,
  28, 0, 56, 0, 192, 0, 16, 6, 12, 18, 1, 5, 124, 2, 127, 1,
  143, 193, 131, 241, 128, 254, 64, 62, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 8, 0, 0, 5,
  21, 21, 9, 2, 249, 112, 248, 248, 112, 0, 0, 32, 32, 32, 32, 32,
  112, 112, 112, 112, 248, 248, 248, 248, 248, 112, 10, 21, 42, 16, 3, 253,
  2, 0, 2, 0, 2, 0, 15, 0, 26, 128, 50, 192, 114, 192, 243, 192,
  243, 192, 242, 0, 242, 0, 242, 0, 242, 0, 242, 64, 114, 64, 50, 64,
  30, 128, 15, 0, 2, 0, 2, 0, 2, 0, 17, 21, 63, 20, 2, 1,
  0, 254, 0, 1, 131, 0, 3, 131, 0, 3, 135, 128, 7, 135, 128, 7,
  135, 0, 7, 128, 0, 7, 128, 0, 7, 128, 0, 31, 128, 0, 39, 248,
  0, 7, 128, 0, 7, 192, 0, 3, 192, 0, 3, 128, 0, 3, 128, 0,
  3, 128, 128, 123, 1, 128, 143, 135, 0, 135, 254, 0, 121, 252, 0, 13,
  13, 26, 17, 2, 3, 207, 152, 255, 248, 112, 112, 96, 48, 192, 24, 192,
  24, 192, 24, 192, 24, 192, 24, 96, 48, 112, 112, 255, 248, 207, 152, 15,
  21, 42, 16, 1, 0, 254, 126, 124, 24, 124, 24, 60, 16, 60, 16, 30,
  32, 30, 32, 30, 64, 15, 64, 15, 128, 7, 128, 127, 248, 7, 128, 127,
  248, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 63, 240, 2,
  26, 26, 8, 3, 251, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 0,
  0, 0, 0, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 13,
  27, 54, 18, 1, 250, 15, 128, 16, 64, 32, 96, 96, 224, 97, 224, 97,
  224, 112, 128, 124, 0, 63, 0, 95, 192, 79, 240, 195, 240, 192, 248, 224,
  56, 248, 24, 126, 16, 127, 144, 31, 224, 7, 224, 1, 224, 48, 224, 120,
  96, 120, 96, 112, 96, 96, 192, 48, 128, 31, 0, 9, 4, 8, 13, 2,
  16, 99, 0, 247, 128, 247, 128, 99, 0, 20, 21, 63, 22, 1, 1, 3,
  252, 0, 12, 3, 0, 16, 0, 128, 32, 0, 64, 32, 244, 64, 65, 140,
  32, 67, 132, 32, 131, 132, 16, 135, 132, 16, 135, 132, 16, 135, 128, 16,
  135, 128, 16, 135, 128, 16, 135, 130, 16, 67, 132, 32, 67, 132, 32, 33,
  136, 64, 32, 240, 64, 16, 0, 128, 12, 3, 0, 3, 252, 0, 8, 11,
  11, 10, 1, 10, 56, 76, 108, 108, 60, 204, 205, 205, 118, 0, 255, 7,
  11, 11, 13, 3, 2, 34, 68, 196, 204, 204, 204, 204, 204, 68, 98, 34,
  14, 8, 16, 16, 1, 4, 255, 252, 255, 252, 0, 12, 0, 12, 0, 12,
  0, 12, 0, 12, 0, 12, 7, 3, 3, 11, 2, 6, 254, 254, 254, 20,
  21, 63, 22, 1, 1, 3, 252, 0, 12, 3, 0, 16, 0, 128, 32, 0,
  64, 47, 248, 64, 67, 206, 32, 67, 206, 32, 131, 207, 16, 131, 206, 16,
  131, 206, 16, 131, 240, 16, 131, 204, 16, 131, 206, 16, 131, 206, 16, 67,
  206, 160, 67, 206, 160, 35, 206, 192, 47, 231, 64, 16, 0, 128, 12, 3,
  0, 3, 252, 0, 7, 2, 2, 13, 3, 17, 254, 254, 9, 10, 20, 17,
  4, 12, 8, 0, 62, 0, 119, 0, 193, 128, 193, 128, 193, 128, 193, 128,
  99, 0, 127, 0, 28, 0, 24, 22, 66, 26, 1, 254, 0, 24, 0, 0,
  24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24,
  0, 0, 24, 0, 255, 255, 255, 255, 255, 255, 0, 24, 0, 0, 24, 0,
  0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0,
  24, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 9, 12,
  24, 13, 2, 9, 62, 0, 71, 0, 199, 128, 231, 0, 111, 0, 12, 0,
  24, 0, 33, 0, 65, 128, 255, 0, 159, 0, 142, 0, 10, 13, 26, 13,
  2, 8, 62, 0, 67, 0, 195, 128, 227, 128, 99, 128, 3, 0, 60, 0,
  7, 0, 3, 128, 243, 192, 227, 128, 199, 128, 62, 0, 5, 5, 5, 12,
  5, 16, 24, 56, 112, 96, 192, 14, 22, 44, 17, 2, 248, 96, 192, 224,
  224, 241, 224, 241, 224, 225, 224, 225, 224, 224, 224, 224, 224, 96, 192, 64,
  196, 64, 196, 65, 252, 127, 124, 78, 56, 64, 0, 64, 0, 96, 0, 224,
  0, 240, 0, 240, 0, 112, 0, 96, 0, 13, 25, 50, 17, 2, 252, 31,
  248, 126, 96, 254, 96, 254, 96, 254, 96, 254, 96, 254, 96, 254, 96, 254,
  96, 126, 96, 62, 96, 6, 96, 6, 96, 6, 96, 6, 96, 6, 96, 6,
  96, 6, 96, 6, 96, 6, 96, 6, 96, 6, 96, 6, 96, 6, 96, 6,
  96, 4, 4, 4, 8, 2, 7, 96, 240, 240, 96, 5, 6, 6, 13, 4,
  249, 32, 64, 48, 24, 24, 240, 7, 12, 12, 13, 3, 9, 28, 252, 60,
  60, 60, 60, 60, 60, 60, 60, 60, 254, 8, 11, 11, 11, 2, 10, 60,
  102, 230, 231, 231, 231, 230, 102, 60, 0, 255, 7, 11, 11, 13, 3, 2,
  136, 68, 102, 102, 102, 102, 102, 102, 68, 140, 136, 22, 21, 63, 26, 3,
  0, 12, 1, 128, 28, 1, 0, 252, 3, 0, 60, 2, 0, 60, 6, 0,
  60, 12, 0, 60, 12, 0, 60, 24, 0, 60, 16, 0, 60, 48, 112, 60,
  32, 240, 60, 97, 240, 254, 65, 240, 0, 194, 240, 0, 130, 240, 1, 132,
  240, 3, 8, 240, 3, 15, 252, 6, 0, 240, 4, 0, 240, 12, 3, 248,
  21, 22, 66, 26, 3, 0, 0, 1, 128, 28, 1, 0, 252, 3, 0, 60,
  2, 0, 60, 6, 0, 60, 4, 0, 60, 12, 0, 60, 24, 0, 60, 24,
  0, 60, 51, 224, 60, 36, 112, 60, 108, 120, 60, 78, 120, 254, 206, 120,
  0, 134, 112, 1, 128, 192, 1, 1, 0, 3, 2, 8, 2, 4, 8, 6,
  15, 248, 4, 11, 240, 12, 8, 224, 22, 21, 63, 25, 2, 0, 62, 0,
  128, 67, 1, 128, 195, 129, 0, 227, 131, 0, 99, 130, 0, 3, 6, 0,
  60, 4, 0, 7, 8, 0, 3, 152, 0, 243, 208, 112, 227, 176, 112, 199,
  160, 240, 62, 97, 240, 0, 65, 240, 0, 194, 240, 0, 130, 240, 1, 132,
  240, 1, 7, 252, 3, 0, 240, 2, 0, 240, 6, 3, 252, 9, 22, 44,
  13, 2, 249, 24, 0, 60, 0, 60, 0, 60, 0, 24, 0, 0, 0, 28,
  0, 34, 0, 34, 0, 34, 0, 6, 0, 12, 0, 28, 0, 56, 0, 112,
  0, 113, 0, 240, 128, 240, 128, 240, 128, 240, 128, 113, 0, 62, 0, 19,
  27, 81, 22, 2, 1, 3, 0, 0, 3, 128, 0, 1, 128, 0, 0, 192,
  0, 0, 64, 0, 0, 0, 0, 0, 64, 0, 0, 96, 0, 0, 224, 0,
  0, 224, 0, 0, 240, 0, 1, 240, 0, 1, 240, 0, 1, 248, 0, 2,
  120, 0, 2, 120, 0, 2, 124, 0, 4, 60, 0, 4, 60, 0, 4, 62,
  0, 15, 254, 0, 8, 30, 0, 8, 31, 0, 16, 15, 0, 16, 15, 0,
  48, 15, 128, 254, 127, 224, 19, 27, 81, 21, 2, 1, 0, 24, 0, 0,
  56, 0, 0, 48, 0, 0, 96, 0, 0, 64, 0, 0, 0, 0, 0, 64,
  0, 0, 96, 0, 0, 224, 0, 0, 224, 0, 0, 240, 0, 1, 240, 0,
  1, 240, 0, 1, 248, 0, 2, 120, 0, 2, 120, 0, 2, 124, 0, 4,
  60, 0, 4, 60, 0, 8, 60, 0, 15, 254, 0, 8, 30, 0, 16, 30,
  0, 16, 15, 0, 16, 15, 0, 48, 15, 128, 254, 127, 224, 19, 27, 81,
  22, 2, 0, 0, 64, 0, 0, 224, 0, 1, 240, 0, 3, 24, 0, 4,
  4, 0, 0, 0, 0, 0, 64, 0, 0, 96, 0, 0, 224, 0, 0, 224,
  0, 0, 240, 0, 1, 240, 0, 1, 240, 0, 1, 248, 0, 2, 120, 0,
  2, 120, 0, 2, 124, 0, 4, 60, 0, 4, 60, 0, 4, 62, 0, 15,
  254, 0, 8, 30, 0, 8, 31, 0, 16, 15, 0, 16, 15, 0, 48, 15,
  128, 254, 127, 224, 19, 27, 81, 21, 2, 0, 0, 4, 0, 1, 200, 0,
  3, 248, 0, 4, 112, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0,
  96, 0, 0, 224, 0, 0, 224, 0, 0, 240, 0, 1, 240, 0, 1, 240,
  0, 1, 248, 0, 2, 120, 0, 2, 120, 0, 2, 124, 0, 4, 60, 0,
  4, 60, 0, 4, 60, 0, 15, 254, 0, 8, 30, 0, 24, 30, 0, 16,
  15, 0, 16, 15, 0, 48, 15, 128, 254, 127, 224, 19, 27, 81, 22, 2,
  0, 3, 12, 0, 7, 158, 0, 7, 158, 0, 3, 12, 0, 0, 0, 0,
  0, 0, 0, 0, 96, 0, 0, 96, 0, 0, 224, 0, 0, 240, 0, 0,
  240, 0, 1, 240, 0, 1, 248, 0, 1, 120, 0, 2, 120, 0, 2, 124,
  0, 2, 60, 0, 4, 60, 0, 4, 62, 0, 4, 30, 0, 15, 254, 0,
  8, 31, 0, 8, 15, 0, 16, 15, 0, 16, 15, 0, 48, 15, 128, 254,
  127, 224, 19, 27, 81, 21, 1, 0, 0, 240, 0, 1, 8, 0, 1, 8,
  0, 1, 8, 0, 0, 240, 0, 0, 0, 0, 0, 96, 0, 0, 96, 0,
  0, 240, 0, 0, 240, 0, 0, 240, 0, 1, 248, 0, 1, 248, 0, 1,
  120, 0, 1, 120, 0, 2, 124, 0, 2, 60, 0, 2, 60, 0, 4, 62,
  0, 4, 30, 0, 7, 254, 0, 8, 31, 0, 8, 15, 0, 8, 15, 0,
  24, 15, 0, 24, 15, 128, 254, 63, 224, 26, 21, 84, 28, 0, 0, 0,
  63, 255, 192, 0, 15, 131, 192, 0, 15, 129, 192, 0, 31, 128, 192, 0,
  23, 128, 192, 0, 55, 128, 64, 0, 39, 132, 64, 0, 103, 132, 0, 0,
  71, 140, 0, 0, 199, 156, 0, 0, 135, 252, 0, 1, 135, 156, 0, 1,
  7, 140, 0, 3, 7, 132, 64, 3, 255, 132, 64, 6, 7, 128, 64, 4,
  7, 128, 64, 12, 7, 128, 192, 12, 7, 129, 192, 28, 7, 131, 192, 255,
  63, 255, 192, 15, 28, 56, 18, 2, 250, 15, 230, 28, 30, 56, 30, 56,
  14, 120, 14, 120, 6, 248, 6, 248, 6, 248, 2, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 2, 120, 2, 120, 2, 120, 4, 56, 4, 60, 12, 28,
  8, 6, 48, 1, 192, 1, 0, 1, 192, 0, 96, 0, 96, 4, 96, 3,
  192, 16, 27, 54, 19, 1, 1, 6, 0, 7, 0, 3, 0, 1, 128, 0,
  0, 0, 0, 255, 255, 30, 15, 30, 7, 30, 3, 30, 3, 30, 1, 30,
  17, 30, 16, 30, 48, 30, 48, 31, 240, 30, 48, 30, 48, 30, 17, 30,
  17, 30, 1, 30, 1, 30, 3, 30, 7, 30, 15, 255, 255, 16, 27, 54,
  19, 1, 1, 0, 56, 0, 120, 0, 96, 0, 192, 0, 0, 0, 0, 255,
  255, 30, 15, 30, 7, 30, 3, 30, 3, 30, 1, 30, 17, 30, 16, 30,
  48, 30, 48, 31, 240, 30, 48, 30, 48, 30, 17, 30, 17, 30, 1, 30,
  1, 30, 3, 30, 7, 30, 15, 255, 255, 16, 27, 54, 19, 1, 0, 0,
  128, 1, 192, 3, 96, 6, 56, 8, 0, 0, 0, 255, 255, 30, 15, 30,
  7, 30, 3, 30, 3, 30, 1, 30, 17, 30, 16, 30, 48, 30, 48, 31,
  240, 30, 48, 30, 48, 30, 17, 30, 17, 30, 1, 30, 1, 30, 3, 30,
  7, 30, 15, 255, 255, 16, 27, 54, 19, 1, 0, 6, 24, 15, 60, 15,
  60, 6, 24, 0, 0, 0, 0, 255, 255, 30, 15, 30, 7, 30, 3, 30,
  3, 30, 1, 30, 17, 30, 16, 30, 48, 30, 48, 31, 240, 30, 48, 30,
  48, 30, 17, 30, 17, 30, 1, 30, 1, 30, 3, 30, 7, 30, 15, 255,
  255, 9, 27, 54, 11, 1, 1, 96, 0, 112, 0, 56, 0, 8, 0, 0,
  0, 0, 0, 255, 128, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 255, 128, 10, 27, 54,
  12, 1, 1, 3, 128, 3, 128, 6, 0, 12, 0, 8, 0, 0, 0, 255,
  192, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 255, 192, 9, 27, 54, 11, 1, 0, 12,
  0, 28, 0, 62, 0, 99, 0, 0, 128, 0, 0, 255, 128, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 255, 128, 10, 27, 54, 13, 2, 0, 97, 128, 243, 192, 243,
  192, 97, 128, 0, 0, 0, 0, 255, 192, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 255,
  192, 19, 21, 63, 22, 2, 0, 255, 248, 0, 30, 14, 0, 30, 7, 0,
  30, 3, 128, 30, 3, 192, 30, 3, 192, 30, 3, 192, 30, 3, 224, 30,
  3, 224, 30, 3, 224, 255, 131, 224, 30, 3, 224, 30, 3, 224, 30, 3,
  224, 30, 3, 192, 30, 3, 192, 30, 3, 128, 30, 3, 128, 30, 7, 0,
  30, 14, 0, 255, 248, 0, 21, 26, 78, 22, 1, 1, 0, 226, 0, 1,
  254, 0, 2, 28, 0, 0, 0, 0, 0, 0, 0, 254, 15, 248, 31, 1,
  192, 31, 0, 128, 15, 128, 128, 15, 192, 128, 15, 192, 128, 11, 224, 128,
  11, 240, 128, 9, 248, 128, 8, 248, 128, 8, 252, 128, 8, 126, 128, 8,
  62, 128, 8, 31, 128, 8, 31, 128, 8, 15, 128, 8, 7, 128, 8, 7,
  128, 8, 3, 128, 28, 1, 128, 255, 129, 128, 17, 27, 81, 20, 2, 1,
  14, 0, 0, 7, 0, 0, 3, 0, 0, 1, 128, 0, 0, 0, 0, 0,
  128, 0, 7, 112, 0, 12, 24, 0, 24, 12, 0, 56, 14, 0, 120, 14,
  0, 120, 15, 0, 120, 15, 0, 248, 15, 128, 248, 15, 128, 248, 15, 128,
  248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 120, 15, 0, 120,
  15, 0, 120, 15, 0, 56, 14, 0, 24, 12, 0, 12, 24, 0, 7, 112,
  0, 17, 27, 81, 20, 2, 1, 0, 56, 0, 0, 112, 0, 0, 96, 0,
  0, 192, 0, 0, 0, 0, 0, 128, 0, 7, 112, 0, 12, 24, 0, 24,
  12, 0, 56, 14, 0, 120, 14, 0, 120, 15, 0, 120, 15, 0, 248, 15,
  128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128,
  248, 15, 128, 120, 15, 0, 120, 15, 0, 120, 15, 0, 56, 14, 0, 24,
  12, 0, 12, 24, 0, 7, 112, 0, 17, 27, 81, 20, 2, 0, 0, 128,
  0, 1, 192, 0, 3, 96, 0, 6, 48, 0, 8, 8, 0, 0, 128, 0,
  7, 112, 0, 12, 24, 0, 24, 12, 0, 56, 14, 0, 120, 14, 0, 120,
  15, 0, 120, 15, 0, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15,
  128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 120, 15, 0, 120, 15, 0,
  120, 15, 0, 56, 14, 0, 24, 12, 0, 12, 24, 0, 7, 112, 0, 17,
  27, 81, 20, 2, 0, 0, 8, 0, 7, 136, 0, 7, 240, 0, 8, 224,
  0, 0, 0, 0, 0, 128, 0, 7, 112, 0, 12, 24, 0, 24, 12, 0,
  56, 14, 0, 120, 14, 0, 120, 15, 0, 120, 15, 0, 248, 15, 128, 248,
  15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15,
  128, 120, 15, 0, 120, 15, 0, 120, 15, 0, 56, 14, 0, 24, 12, 0,
  12, 24, 0, 7, 112, 0, 17, 27, 81, 20, 2, 0, 12, 48, 0, 30,
  120, 0, 30, 120, 0, 12, 48, 0, 0, 0, 0, 0, 128, 0, 7, 112,
  0, 12, 24, 0, 24, 12, 0, 56, 14, 0, 120, 14, 0, 120, 15, 0,
  120, 15, 0, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248,
  15, 128, 248, 15, 128, 248, 15, 128, 120, 15, 0, 120, 15, 0, 120, 15,
  0, 56, 14, 0, 24, 12, 0, 12, 24, 0, 7, 112, 0, 18, 19, 57,
  26, 4, 254, 64, 0, 64, 224, 0, 192, 112, 1, 128, 56, 3, 0, 28,
  6, 0, 14, 12, 0, 7, 24, 0, 3, 176, 0, 1, 224, 0, 0, 224,
  0, 1, 240, 0, 3, 56, 0, 6, 28, 0, 12, 12, 0, 24, 6, 0,
  48, 3, 0, 112, 1, 128, 224, 0, 192, 64, 0, 0, 17, 22, 66, 20,
  2, 0, 0, 128, 0, 7, 113, 128, 12, 27, 0, 24, 14, 0, 56, 14,
  0, 56, 14, 0, 120, 31, 0, 120, 31, 0, 248, 47, 128, 248, 111, 128,
  248, 79, 128, 248, 143, 128, 249, 15, 128, 251, 15, 128, 250, 15, 128, 124,
  15, 0, 124, 15, 0, 120, 14, 0, 56, 14, 0, 56, 12, 0, 108, 24,
  0, 199, 112, 0, 19, 27, 81, 22, 2, 1, 7, 0, 0, 3, 128, 0,
  1, 128, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 255, 15, 224, 60,
  3, 128, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1,
  0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0,
  60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 28,
  1, 0, 28, 2, 0, 14, 4, 0, 7, 248, 0, 19, 27, 81, 22, 2,
  1, 0, 28, 0, 0, 56, 0, 0, 48, 0, 0, 96, 0, 0, 0, 0,
  0, 0, 0, 255, 15, 224, 60, 3, 128, 60, 1, 0, 60, 1, 0, 60,
  1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1,
  0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0,
  60, 1, 0, 60, 1, 0, 28, 1, 0, 28, 2, 0, 14, 4, 0, 7,
  248, 0, 19, 27, 81, 22, 2, 0, 0, 192, 0, 0, 224, 0, 1, 240,
  0, 6, 24, 0, 0, 4, 0, 0, 0, 0, 255, 15, 224, 60, 3, 128,
  60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60,
  1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1,
  0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 28, 3, 0,
  28, 2, 0, 14, 4, 0, 7, 248, 0, 19, 27, 81, 22, 2, 0, 3,
  12, 0, 7, 158, 0, 7, 158, 0, 3, 12, 0, 0, 0, 0, 0, 0,
  0, 255, 143, 224, 60, 3, 128, 60, 1, 0, 60, 1, 0, 60, 1, 0,
  60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60,
  1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1,
  0, 60, 1, 0, 28, 1, 0, 28, 2, 0, 14, 4, 0, 7, 248, 0,
  19, 27, 81, 21, 2, 1, 0, 28, 0, 0, 60, 0, 0, 48, 0, 0,
  96, 0, 0, 0, 0, 0, 0, 0, 255, 31, 224, 62, 7, 0, 30, 6,
  0, 30, 6, 0, 31, 4, 0, 15, 4, 0, 15, 136, 0, 7, 136, 0,
  7, 144, 0, 7, 208, 0, 3, 240, 0, 3, 224, 0, 1, 224, 0, 1,
  224, 0, 1, 224, 0, 1, 224, 0, 1, 224, 0, 1, 224, 0, 1, 224,
  0, 1, 224, 0, 7, 248, 0, 17, 21, 63, 19, 1, 0, 255, 192, 0,
  30, 0, 0, 30, 0, 0, 30, 0, 0, 31, 248, 0, 30, 14, 0, 30,
  15, 0, 30, 7, 128, 30, 7, 128, 30, 7, 128, 30, 7, 128, 30, 7,
  128, 30, 15, 0, 30, 14, 0, 31, 248, 0, 30, 0, 0, 30, 0, 0,
  30, 0, 0, 30, 0, 0, 30, 0, 0, 255, 192, 0, 14, 21, 42, 16,
  1, 0, 7, 192, 12, 96, 28, 112, 28, 112, 60, 112, 60, 112, 60, 112,
  60, 96, 61, 128, 60, 96, 60, 48, 60, 56, 60, 56, 60, 56, 60, 60,
  60, 60, 60, 56, 63, 184, 63, 184, 63, 48, 253, 224, 12, 21, 42, 14,
  1, 0, 96, 0, 112, 0, 56, 0, 24, 0, 12, 0, 4, 0, 0, 0,
  30, 0, 99, 128, 99, 192, 243, 192, 115, 192, 7, 192, 27, 192, 115, 192,
  115, 192, 243, 192, 243, 208, 243, 208, 243, 208, 125, 224, 12, 21, 42, 14,
  1, 0, 1, 128, 3, 128, 3, 0, 6, 0, 12, 0, 8, 0, 0, 0,
  30, 0, 99, 128, 99, 192, 243, 192, 115, 192, 35, 192, 15, 192, 51, 192,
  115, 192, 243, 192, 243, 208, 243, 208, 243, 208, 125, 224, 12, 21, 42, 14,
  1, 0, 12, 0, 12, 0, 30, 0, 19, 0, 33, 128, 64, 128, 0, 0,
  30, 0, 99, 128, 99, 192, 243, 192, 115, 192, 35, 192, 15, 192, 51, 192,
  115, 192, 243, 192, 243, 208, 243, 208, 243, 208, 125, 224, 12, 20, 40, 14,
  1, 0, 56, 128, 127, 128, 71, 0, 0, 0, 0, 0, 0, 0, 30, 0,
  99, 128, 99, 192, 243, 192, 115, 192, 3, 192, 31, 192, 51, 192, 115, 192,
  243, 192, 243, 208, 243, 208, 245, 208, 121, 224, 12, 20, 40, 14, 1, 0,
  97, 128, 243, 192, 243, 192, 97, 128, 0, 0, 0, 0, 30, 0, 99, 128,
  99, 192, 243, 192, 115, 192, 35, 192, 15, 192, 51, 192, 115, 192, 243, 192,
  243, 208, 243, 208, 243, 208, 125, 224, 12, 21, 42, 14, 1, 1, 30, 0,
  33, 0, 33, 0, 33, 0, 50, 0, 12, 0, 0, 0, 31, 0, 99, 128,
  97, 192, 241, 192, 113, 192, 33, 192, 15, 192, 49, 192, 97, 192, 225, 192,
  225, 208, 225, 208, 227, 208, 124, 224, 17, 14, 42, 19, 1, 0, 62, 60,
  0, 99, 230, 0, 99, 199, 0, 243, 199, 128, 115, 199, 128, 7, 199, 128,
  27, 255, 128, 115, 192, 0, 115, 192, 0, 243, 192, 128, 243, 192, 128, 243,
  225, 0, 242, 225, 0, 124, 62, 0, 10, 21, 42, 13, 1, 249, 15, 0,
  56, 128, 112, 192, 113, 192, 243, 192, 243, 128, 240, 0, 240, 0, 240, 0,
  240, 0, 112, 64, 112, 64, 56, 128, 31, 0, 4, 0, 8, 0, 6, 0,
  3, 0, 3, 0, 3, 0, 30, 0, 11, 21, 42, 13, 1, 0, 48, 0,
  48, 0, 56, 0, 24, 0, 12, 0, 0, 0, 0, 0, 15, 0, 51, 128,
  113, 192, 113, 192, 241, 192, 241, 224, 255, 224, 240, 0, 240, 0, 240, 32,
  112, 64, 112, 64, 56, 128, 15, 0, 11, 21, 42, 13, 1, 0, 1, 128,
  3, 128, 3, 128, 6, 0, 4, 0, 8, 0, 0, 0, 15, 0, 51, 128,
  113, 192, 113, 192, 241, 192, 241, 224, 255, 224, 240, 0, 240, 0, 240, 32,
  112, 64, 112, 64, 56, 128, 15, 0, 11, 21, 42, 13, 1, 0, 12, 0,
  14, 0, 30, 0, 27, 0, 49, 128, 64, 0, 0, 0, 15, 0, 51, 128,
  113, 192, 113, 192, 241, 192, 241, 224, 255, 224, 240, 0, 240, 0, 240, 32,
  112, 64, 112, 64, 56, 128, 15, 0, 11, 20, 40, 13, 1, 0, 49, 128,
  123, 192, 123, 192, 49, 128, 0, 0, 0, 0, 15, 0, 51, 128, 113, 192,
  113, 192, 241, 192, 241, 224, 255, 224, 240, 0, 240, 0, 240, 32, 112, 64,
  112, 64, 56, 128, 15, 0, 7, 21, 21, 9, 1, 0, 192, 224, 112, 48,
  24, 8, 0, 124, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
  126, 6, 21, 21, 9, 2, 0, 12, 12, 28, 56, 32, 0, 0, 248, 120,
  120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 252, 8, 21, 21, 8,
  1, 0, 56, 56, 124, 110, 131, 0, 0, 252, 60, 60, 60, 60, 60, 60,
  60, 60, 60, 60, 60, 60, 254, 8, 20, 20, 9, 1, 0, 102, 255, 255,
  102, 0, 0, 124, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
  126, 12, 21, 42, 14, 1, 0, 60, 64, 31, 128, 15, 0, 15, 0, 55,
  128, 3, 128, 3, 192, 31, 192, 49, 224, 113, 224, 112, 224, 240, 224, 240,
  240, 240, 240, 240, 240, 240, 224, 240, 224, 112, 224, 113, 192, 49, 192, 15,
  0, 13, 19, 38, 16, 2, 1, 30, 64, 63, 192, 35, 128, 0, 0, 0,
  0, 251, 192, 124, 224, 120, 224, 120, 240, 120, 240, 120, 240, 120, 240, 120,
  240, 120, 240, 120, 240, 120, 240, 120, 240, 120, 240, 253, 248, 12, 21, 42,
  14, 1, 0, 48, 0, 56, 0, 56, 0, 12, 0, 6, 0, 2, 0, 0,
  0, 15, 0, 49, 128, 112, 192, 112, 224, 240, 224, 240, 224, 240, 240, 240,
  240, 240, 224, 240, 224, 112, 224, 112, 192, 49, 128, 15, 0, 12, 21, 42,
  14, 1, 0, 1, 128, 1, 192, 3, 128, 3, 0, 6, 0, 4, 0, 0,
  0, 15, 0, 49, 128, 112, 192, 112, 224, 240, 224, 240, 224, 240, 240, 240,
  240, 240, 224, 240, 224, 112, 224, 112, 192, 49, 128, 15, 0, 12, 21, 42,
  14, 1, 0, 6, 0, 14, 0, 15, 0, 27, 0, 48, 128, 32, 64, 0,
  0, 15, 0, 49, 128, 112, 192, 112, 224, 240, 224, 240, 224, 240, 240, 240,
  240, 240, 224, 240, 224, 112, 224, 112, 192, 49, 128, 15, 0, 12, 20, 40,
  14, 1, 0, 28, 64, 63, 192, 71, 128, 0, 0, 0, 0, 0, 0, 15,
  0, 49, 128, 112, 192, 112, 224, 240, 224, 240, 224, 240, 240, 240, 240, 240,
  224, 240, 224, 112, 224, 112, 192, 49, 128, 15, 0, 12, 20, 40, 14, 1,
  0, 49, 128, 123, 192, 123, 192, 49, 128, 0, 0, 0, 0, 15, 0, 49,
  128, 112, 192, 112, 224, 240, 224, 240, 224, 240, 240, 240, 240, 240, 224, 240,
  224, 112, 224, 112, 192, 49, 128, 15, 0, 24, 19, 57, 26, 1, 254, 0,
  24, 0, 0, 60, 0, 0, 60, 0, 0, 24, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 60, 0, 0,
  60, 0, 0, 60, 0, 0, 24, 0, 12, 14, 28, 14, 1, 0, 15, 16,
  49, 160, 113, 192, 112, 224, 241, 224, 243, 224, 242, 240, 244, 240, 248, 224,
  240, 224, 112, 224, 112, 192, 121, 128, 143, 0, 14, 21, 42, 15, 0, 0,
  24, 0, 28, 0, 12, 0, 6, 0, 3, 0, 0, 0, 0, 0, 253, 248,
  60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120,
  60, 120, 60, 248, 60, 248, 29, 120, 14, 124, 14, 21, 42, 15, 0, 0,
  0, 192, 0, 192, 1, 192, 1, 128, 3, 0, 0, 0, 0, 0, 253, 248,
  60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120,
  60, 120, 60, 120, 60, 248, 29, 120, 14, 124, 14, 21, 42, 15, 0, 0,
  3, 0, 7, 0, 7, 128, 12, 128, 24, 64, 0, 0, 0, 0, 253, 248,
  60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120,
  60, 120, 60, 120, 60, 248, 29, 120, 14, 124, 14, 20, 40, 15, 0, 0,
  24, 192, 61, 224, 61, 224, 24, 192, 0, 0, 0, 0, 253, 248, 60, 120,
  60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120,
  60, 120, 60, 248, 29, 120, 14, 124, 13, 28, 56, 15, 1, 249, 0, 192,
  0, 192, 1, 192, 3, 128, 2, 0, 0, 0, 0, 0, 252, 248, 120, 32,
  56, 32, 60, 64, 28, 64, 28, 64, 30, 64, 14, 128, 15, 128, 7, 128,
  7, 0, 7, 0, 3, 0, 3, 0, 2, 0, 2, 0, 50, 0, 124, 0,
  116, 0, 116, 0, 56, 0, 13, 26, 52, 15, 1, 250, 28, 0, 124, 0,
  188, 0, 60, 0, 60, 0, 60, 0, 60, 240, 63, 120, 60, 120, 60, 120,
  60, 120, 60, 120, 60, 112, 60, 112, 60, 96, 60, 192, 60, 128, 61, 0,
  62, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 48, 0, 192, 0,
  13, 27, 54, 15, 1, 249, 24, 96, 60, 240, 60, 240, 24, 96, 0, 0,
  0, 0, 254, 120, 120, 48, 56, 32, 60, 32, 28, 32, 30, 64, 30, 64,
  14, 64, 15, 128, 7, 128, 7, 128, 7, 0, 3, 0, 3, 0, 1, 0,
  2, 0, 50, 0, 122, 0, 116, 0, 116, 0, 56, 0
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--28-280-72-72-P-153-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 0, '1' Height: 21
  Calculated Max Values w=24 h=27 x= 3 y= 9 dx=26 dy= 0 ascent=22 len=75
  Font Bounding box     w=77 h=36 x=-24 y=-8
  Calculated Min Values           x= 0 y=-6 dx= 0 dy= 0
  Pure Font   ascent =21 descent= 0
  X Font      ascent =21 descent= 0
  Max Font    ascent =22 descent=-6
*/
const u8g_fntpgm_uint8_t u8g_font_osb21n[723] U8G_FONT_SECTION("u8g_font_osb21n") = {
  0, 77, 36, 232, 248, 21, 0, 0, 0, 0, 42, 58, 0, 22, 250, 21,
  0, 11, 12, 24, 14, 2, 9, 14, 0, 14, 0, 78, 192, 228, 224, 245,
  192, 14, 0, 14, 0, 245, 192, 228, 192, 78, 192, 14, 0, 14, 0, 24,
  25, 75, 26, 1, 252, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24,
  0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0,
  0, 24, 0, 0, 24, 0, 0, 24, 0, 255, 255, 255, 255, 255, 255, 0,
  24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24,
  0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0,
  5, 10, 10, 7, 1, 251, 112, 248, 248, 248, 120, 8, 16, 16, 32, 192,
  7, 3, 3, 11, 2, 6, 254, 254, 254, 4, 4, 4, 8, 2, 0, 96,
  240, 240, 96, 9, 27, 54, 13, 2, 250, 1, 128, 1, 128, 1, 128, 3,
  0, 3, 0, 3, 0, 2, 0, 6, 0, 6, 0, 6, 0, 12, 0, 12,
  0, 12, 0, 24, 0, 24, 0, 24, 0, 16, 0, 48, 0, 48, 0, 48,
  0, 96, 0, 96, 0, 96, 0, 192, 0, 192, 0, 192, 0, 128, 0, 14,
  21, 42, 16, 1, 1, 15, 192, 24, 96, 56, 112, 56, 112, 120, 120, 120,
  120, 248, 120, 248, 124, 248, 124, 248, 124, 248, 124, 248, 124, 248, 124, 248,
  124, 248, 120, 120, 120, 120, 120, 56, 112, 56, 112, 24, 96, 15, 192, 9,
  21, 42, 16, 3, 0, 6, 0, 14, 0, 30, 0, 254, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 255, 128, 12,
  21, 42, 16, 2, 1, 63, 192, 97, 224, 96, 224, 224, 240, 224, 240, 240,
  240, 248, 240, 121, 224, 49, 224, 3, 192, 7, 128, 14, 0, 28, 0, 48,
  16, 96, 16, 64, 16, 192, 16, 255, 240, 255, 224, 143, 224, 135, 192, 13,
  21, 42, 16, 2, 1, 63, 192, 96, 224, 96, 224, 224, 240, 240, 240, 248,
  240, 120, 240, 112, 240, 0, 224, 1, 192, 31, 0, 0, 224, 0, 240, 0,
  112, 112, 120, 248, 120, 248, 120, 240, 120, 224, 112, 96, 240, 59, 192, 13,
  21, 42, 16, 1, 0, 1, 192, 1, 192, 3, 192, 3, 192, 7, 192, 7,
  192, 15, 192, 27, 192, 27, 192, 51, 192, 35, 192, 99, 192, 67, 192, 195,
  192, 255, 248, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 31, 248, 13,
  21, 42, 16, 2, 0, 96, 224, 127, 192, 127, 128, 127, 0, 120, 0, 64,
  0, 64, 0, 64, 0, 79, 0, 113, 224, 64, 240, 64, 240, 0, 248, 0,
  248, 112, 248, 248, 248, 248, 248, 240, 240, 224, 240, 97, 224, 59, 192, 13,
  21, 42, 16, 2, 1, 15, 224, 24, 32, 56, 48, 48, 240, 112, 240, 112,
  240, 240, 96, 240, 0, 240, 0, 247, 128, 248, 224, 240, 112, 240, 112, 240,
  112, 240, 120, 112, 120, 112, 112, 112, 112, 48, 112, 56, 96, 13, 192, 11,
  21, 42, 16, 3, 0, 156, 64, 190, 96, 255, 32, 255, 32, 199, 224, 129,
  160, 128, 64, 128, 64, 0, 128, 0, 128, 1, 0, 3, 0, 7, 0, 6,
  0, 14, 0, 14, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 14,
  21, 42, 16, 2, 1, 31, 192, 48, 32, 96, 48, 96, 16, 224, 16, 240,
  16, 248, 32, 254, 32, 127, 192, 63, 192, 31, 240, 31, 248, 99, 248, 64,
  248, 192, 60, 192, 24, 192, 24, 192, 24, 96, 16, 112, 48, 31, 192, 13,
  21, 42, 16, 2, 1, 31, 128, 48, 192, 112, 96, 112, 112, 240, 112, 240,
  112, 240, 120, 240, 120, 240, 120, 112, 120, 112, 120, 56, 248, 15, 120, 0,
  120, 0, 120, 56, 112, 120, 112, 120, 96, 112, 224, 96, 192, 63, 128, 4,
  14, 14, 8, 2, 0, 96, 240, 240, 240, 96, 0, 0, 0, 0, 0, 96,
  240, 240, 96
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--28-280-72-72-P-153-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 21, '1' Height: 21
  Calculated Max Values w=28 h=29 x= 3 y=16 dx=31 dy= 0 ascent=23 len=87
  Font Bounding box     w=77 h=36 x=-24 y=-8
  Calculated Min Values           x=-1 y=-7 dx= 0 dy= 0
  Pure Font   ascent =21 descent=-7
  X Font      ascent =21 descent=-7
  Max Font    ascent =23 descent=-7
*/
const u8g_fntpgm_uint8_t u8g_font_osb21r[4521] U8G_FONT_SECTION("u8g_font_osb21r") = {
  0, 77, 36, 232, 248, 21, 5, 141, 12, 241, 32, 127, 249, 23, 249, 21,
  249, 0, 0, 0, 8, 0, 0, 5, 21, 21, 9, 2, 1, 240, 248, 248,
  248, 248, 112, 112, 112, 112, 32, 32, 32, 32, 32, 32, 0, 0, 112, 248,
  248, 112, 7, 6, 6, 11, 2, 16, 238, 238, 238, 238, 198, 68, 16, 21,
  42, 20, 2, 0, 6, 12, 6, 12, 6, 12, 6, 8, 6, 24, 6, 24,
  255, 255, 255, 255, 12, 24, 12, 24, 12, 48, 12, 48, 12, 48, 8, 48,
  255, 255, 255, 255, 24, 32, 24, 96, 24, 96, 16, 96, 48, 96, 13, 25,
  50, 16, 2, 254, 9, 0, 11, 0, 61, 192, 105, 48, 73, 8, 201, 8,
  201, 56, 233, 120, 249, 112, 253, 0, 127, 0, 127, 0, 63, 192, 15, 224,
  15, 240, 73, 248, 233, 248, 233, 56, 201, 24, 137, 24, 137, 16, 73, 32,
  57, 192, 15, 0, 9, 0, 19, 22, 66, 25, 3, 0, 0, 1, 0, 60,
  3, 0, 102, 2, 0, 231, 4, 0, 231, 4, 0, 231, 8, 0, 231, 8,
  0, 231, 16, 0, 231, 48, 0, 102, 32, 0, 102, 96, 0, 24, 64, 0,
  0, 195, 0, 0, 140, 192, 1, 140, 192, 1, 28, 224, 2, 28, 224, 2,
  28, 224, 4, 28, 224, 4, 28, 224, 8, 12, 192, 24, 7, 128, 20, 21,
  63, 22, 1, 1, 3, 224, 0, 6, 16, 0, 14, 16, 0, 14, 16, 0,
  14, 16, 0, 14, 48, 0, 15, 32, 0, 15, 64, 0, 7, 128, 0, 3,
  192, 0, 7, 195, 240, 9, 224, 192, 48, 224, 128, 112, 240, 128, 112, 121,
  0, 240, 59, 0, 240, 62, 0, 240, 30, 0, 248, 31, 16, 126, 111, 160,
  63, 199, 192, 3, 6, 6, 7, 2, 16, 224, 224, 224, 224, 192, 64, 8,
  27, 27, 10, 2, 250, 1, 2, 4, 8, 24, 48, 48, 112, 112, 240, 240,
  240, 240, 240, 240, 240, 240, 112, 112, 112, 48, 48, 24, 8, 4, 2, 1,
  8, 26, 26, 10, 1, 250, 128, 192, 96, 48, 24, 24, 12, 12, 14, 14,
  14, 14, 15, 15, 15, 14, 14, 14, 14, 12, 12, 24, 24, 48, 96, 192,
  11, 12, 24, 14, 2, 9, 14, 0, 14, 0, 78, 192, 228, 224, 245, 192,
  14, 0, 14, 0, 245, 192, 228, 192, 78, 192, 14, 0, 14, 0, 24, 25,
  75, 26, 1, 252, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0,
  0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0,
  24, 0, 0, 24, 0, 0, 24, 0, 255, 255, 255, 255, 255, 255, 0, 24,
  0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0,
  0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 5,
  10, 10, 7, 1, 251, 112, 248, 248, 248, 120, 8, 16, 16, 32, 192, 7,
  3, 3, 11, 2, 6, 254, 254, 254, 4, 4, 4, 8, 2, 0, 96, 240,
  240, 96, 9, 27, 54, 13, 2, 250, 1, 128, 1, 128, 1, 128, 3, 0,
  3, 0, 3, 0, 2, 0, 6, 0, 6, 0, 6, 0, 12, 0, 12, 0,
  12, 0, 24, 0, 24, 0, 24, 0, 16, 0, 48, 0, 48, 0, 48, 0,
  96, 0, 96, 0, 96, 0, 192, 0, 192, 0, 192, 0, 128, 0, 14, 21,
  42, 16, 1, 1, 15, 192, 24, 96, 56, 112, 56, 112, 120, 120, 120, 120,
  248, 120, 248, 124, 248, 124, 248, 124, 248, 124, 248, 124, 248, 124, 248, 124,
  248, 120, 120, 120, 120, 120, 56, 112, 56, 112, 24, 96, 15, 192, 9, 21,
  42, 16, 3, 0, 6, 0, 14, 0, 30, 0, 254, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 255, 128, 12, 21,
  42, 16, 2, 1, 63, 192, 97, 224, 96, 224, 224, 240, 224, 240, 240, 240,
  248, 240, 121, 224, 49, 224, 3, 192, 7, 128, 14, 0, 28, 0, 48, 16,
  96, 16, 64, 16, 192, 16, 255, 240, 255, 224, 143, 224, 135, 192, 13, 21,
  42, 16, 2, 1, 63, 192, 96, 224, 96, 224, 224, 240, 240, 240, 248, 240,
  120, 240, 112, 240, 0, 224, 1, 192, 31, 0, 0, 224, 0, 240, 0, 112,
  112, 120, 248, 120, 248, 120, 240, 120, 224, 112, 96, 240, 59, 192, 13, 21,
  42, 16, 1, 0, 1, 192, 1, 192, 3, 192, 3, 192, 7, 192, 7, 192,
  15, 192, 27, 192, 27, 192, 51, 192, 35, 192, 99, 192, 67, 192, 195, 192,
  255, 248, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 31, 248, 13, 21,
  42, 16, 2, 0, 96, 224, 127, 192, 127, 128, 127, 0, 120, 0, 64, 0,
  64, 0, 64, 0, 79, 0, 113, 224, 64, 240, 64, 240, 0, 248, 0, 248,
  112, 248, 248, 248, 248, 248, 240, 240, 224, 240, 97, 224, 59, 192, 13, 21,
  42, 16, 2, 1, 15, 224, 24, 32, 56, 48, 48, 240, 112, 240, 112, 240,
  240, 96, 240, 0, 240, 0, 247, 128, 248, 224, 240, 112, 240, 112, 240, 112,
  240, 120, 112, 120, 112, 112, 112, 112, 48, 112, 56, 96, 13, 192, 11, 21,
  42, 16, 3, 0, 156, 64, 190, 96, 255, 32, 255, 32, 199, 224, 129, 160,
  128, 64, 128, 64, 0, 128, 0, 128, 1, 0, 3, 0, 7, 0, 6, 0,
  14, 0, 14, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 14, 21,
  42, 16, 2, 1, 31, 192, 48, 32, 96, 48, 96, 16, 224, 16, 240, 16,
  248, 32, 254, 32, 127, 192, 63, 192, 31, 240, 31, 248, 99, 248, 64, 248,
  192, 60, 192, 24, 192, 24, 192, 24, 96, 16, 112, 48, 31, 192, 13, 21,
  42, 16, 2, 1, 31, 128, 48, 192, 112, 96, 112, 112, 240, 112, 240, 112,
  240, 120, 240, 120, 240, 120, 112, 120, 112, 120, 56, 248, 15, 120, 0, 120,
  0, 120, 56, 112, 120, 112, 120, 96, 112, 224, 96, 192, 63, 128, 4, 14,
  14, 8, 2, 0, 96, 240, 240, 240, 96, 0, 0, 0, 0, 0, 96, 240,
  240, 96, 5, 19, 19, 8, 2, 251, 96, 240, 240, 240, 96, 0, 0, 0,
  0, 112, 248, 248, 248, 248, 8, 16, 16, 32, 192, 21, 24, 72, 26, 2,
  252, 0, 0, 24, 0, 0, 56, 0, 0, 240, 0, 3, 192, 0, 15, 0,
  0, 28, 0, 0, 120, 0, 1, 224, 0, 7, 128, 0, 14, 0, 0, 60,
  0, 0, 240, 0, 0, 224, 0, 0, 120, 0, 0, 30, 0, 0, 7, 128,
  0, 1, 192, 0, 0, 240, 0, 0, 60, 0, 0, 15, 0, 0, 3, 128,
  0, 1, 224, 0, 0, 120, 0, 0, 24, 24, 8, 24, 26, 1, 4, 255,
  255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 255, 255, 255, 255, 255, 255, 21, 24, 72, 26, 3, 252, 128, 0, 0,
  224, 0, 0, 120, 0, 0, 30, 0, 0, 7, 128, 0, 1, 192, 0, 0,
  240, 0, 0, 60, 0, 0, 15, 0, 0, 3, 128, 0, 1, 224, 0, 0,
  120, 0, 0, 56, 0, 0, 240, 0, 3, 192, 0, 15, 0, 0, 28, 0,
  0, 120, 0, 1, 224, 0, 7, 128, 0, 14, 0, 0, 60, 0, 0, 240,
  0, 0, 192, 0, 0, 9, 21, 42, 13, 2, 1, 126, 0, 71, 0, 135,
  128, 135, 128, 135, 128, 135, 128, 71, 0, 14, 0, 12, 0, 28, 0, 16,
  0, 48, 0, 34, 0, 34, 0, 34, 0, 28, 0, 0, 0, 12, 0, 30,
  0, 30, 0, 12, 0, 20, 22, 66, 22, 1, 0, 0, 32, 0, 3, 222,
  0, 12, 3, 0, 24, 0, 128, 48, 0, 192, 48, 112, 96, 97, 207, 96,
  99, 142, 48, 199, 142, 48, 199, 14, 48, 199, 14, 48, 207, 14, 48, 207,
  28, 48, 207, 28, 32, 207, 28, 96, 79, 60, 64, 103, 44, 128, 99, 199,
  0, 48, 0, 0, 24, 0, 0, 12, 2, 0, 3, 252, 0, 19, 21, 63,
  22, 2, 0, 0, 64, 0, 0, 96, 0, 0, 224, 0, 0, 224, 0, 0,
  240, 0, 1, 240, 0, 1, 240, 0, 1, 248, 0, 2, 120, 0, 2, 120,
  0, 2, 124, 0, 4, 60, 0, 4, 60, 0, 4, 62, 0, 15, 254, 0,
  8, 30, 0, 8, 31, 0, 16, 15, 0, 16, 15, 0, 48, 15, 128, 254,
  127, 224, 17, 21, 63, 19, 1, 0, 255, 240, 0, 30, 28, 0, 30, 14,
  0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 30, 14, 0,
  30, 14, 0, 30, 24, 0, 31, 224, 0, 30, 28, 0, 30, 15, 0, 30,
  7, 0, 30, 7, 128, 30, 7, 128, 30, 7, 128, 30, 7, 128, 30, 7,
  0, 30, 14, 0, 255, 248, 0, 15, 21, 42, 18, 2, 1, 15, 230, 28,
  30, 56, 30, 56, 14, 120, 14, 120, 6, 248, 6, 248, 6, 248, 2, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 2, 248, 2, 120, 2, 120, 4, 56,
  4, 60, 12, 28, 8, 15, 240, 19, 21, 63, 21, 1, 0, 255, 248, 0,
  30, 14, 0, 30, 7, 0, 30, 3, 128, 30, 3, 192, 30, 3, 192, 30,
  3, 192, 30, 3, 224, 30, 3, 224, 30, 3, 224, 30, 3, 224, 30, 3,
  224, 30, 3, 224, 30, 3, 224, 30, 3, 192, 30, 3, 192, 30, 3, 192,
  30, 3, 128, 30, 7, 0, 30, 14, 0, 255, 248, 0, 16, 21, 42, 19,
  1, 0, 255, 255, 30, 15, 30, 7, 30, 3, 30, 3, 30, 1, 30, 17,
  30, 16, 30, 48, 30, 48, 31, 240, 30, 48, 30, 48, 30, 17, 30, 17,
  30, 1, 30, 1, 30, 3, 30, 7, 30, 15, 255, 255, 17, 21, 63, 19,
  1, 0, 255, 255, 128, 30, 15, 128, 30, 7, 128, 30, 3, 128, 30, 1,
  128, 30, 1, 128, 30, 17, 128, 30, 17, 128, 30, 48, 0, 30, 48, 0,
  31, 240, 0, 30, 48, 0, 30, 48, 0, 30, 16, 0, 30, 16, 0, 30,
  0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 255, 192,
  0, 17, 22, 66, 20, 2, 0, 0, 128, 0, 7, 114, 0, 28, 30, 0,
  24, 14, 0, 56, 6, 0, 120, 6, 0, 120, 6, 0, 120, 2, 0, 248,
  2, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 255, 128, 248, 30,
  0, 248, 30, 0, 248, 30, 0, 120, 30, 0, 120, 30, 0, 56, 30, 0,
  56, 22, 0, 28, 34, 0, 14, 194, 0, 20, 21, 63, 22, 1, 0, 255,
  223, 240, 30, 3, 192, 30, 3, 192, 30, 3, 192, 30, 3, 192, 30, 3,
  192, 30, 3, 192, 30, 3, 192, 30, 3, 192, 30, 3, 192, 31, 255, 192,
  30, 3, 192, 30, 3, 192, 30, 3, 192, 30, 3, 192, 30, 3, 192, 30,
  3, 192, 30, 3, 192, 30, 3, 192, 30, 3, 192, 255, 223, 240, 9, 21,
  42, 11, 1, 0, 255, 128, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 255, 128, 13, 21,
  42, 15, 1, 0, 15, 248, 1, 224, 1, 224, 1, 224, 1, 224, 1, 224,
  1, 224, 1, 224, 1, 224, 1, 224, 1, 224, 1, 224, 1, 224, 113, 224,
  249, 224, 249, 224, 249, 192, 225, 192, 193, 192, 65, 128, 55, 0, 19, 21,
  63, 21, 1, 0, 255, 159, 192, 30, 7, 0, 30, 6, 0, 30, 12, 0,
  30, 8, 0, 30, 16, 0, 30, 32, 0, 30, 96, 0, 30, 240, 0, 31,
  240, 0, 31, 248, 0, 30, 248, 0, 30, 124, 0, 30, 124, 0, 30, 62,
  0, 30, 30, 0, 30, 31, 0, 30, 15, 0, 30, 15, 128, 30, 15, 128,
  255, 159, 224, 17, 21, 63, 19, 1, 0, 255, 128, 0, 30, 0, 0, 30,
  0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0,
  0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 1, 0,
  30, 1, 128, 30, 1, 128, 30, 1, 128, 30, 3, 128, 30, 3, 128, 30,
  7, 128, 30, 15, 128, 255, 255, 128, 23, 21, 63, 25, 1, 0, 254, 0,
  254, 30, 0, 240, 31, 1, 240, 31, 1, 240, 31, 1, 240, 31, 129, 240,
  23, 130, 240, 23, 194, 240, 23, 194, 240, 19, 196, 240, 19, 228, 240, 17,
  228, 240, 17, 228, 240, 17, 248, 240, 16, 248, 240, 16, 248, 240, 16, 248,
  240, 16, 112, 240, 16, 112, 240, 56, 48, 240, 254, 35, 254, 21, 21, 63,
  22, 1, 0, 254, 15, 248, 31, 1, 192, 31, 0, 128, 15, 128, 128, 15,
  192, 128, 15, 192, 128, 11, 224, 128, 11, 240, 128, 9, 248, 128, 8, 248,
  128, 8, 252, 128, 8, 126, 128, 8, 62, 128, 8, 31, 128, 8, 31, 128,
  8, 15, 128, 8, 7, 128, 8, 7, 128, 8, 3, 128, 28, 1, 128, 255,
  129, 128, 17, 22, 66, 20, 2, 0, 0, 128, 0, 7, 112, 0, 12, 24,
  0, 24, 12, 0, 56, 14, 0, 120, 14, 0, 120, 15, 0, 120, 15, 0,
  248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248,
  15, 128, 248, 15, 128, 120, 15, 0, 120, 15, 0, 120, 15, 0, 56, 14,
  0, 24, 12, 0, 12, 24, 0, 7, 112, 0, 17, 21, 63, 19, 1, 0,
  255, 248, 0, 30, 14, 0, 30, 7, 0, 30, 7, 128, 30, 7, 128, 30,
  7, 128, 30, 7, 128, 30, 7, 128, 30, 15, 0, 30, 14, 0, 31, 248,
  0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0,
  30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 255, 192, 0, 17,
  29, 87, 20, 2, 249, 0, 128, 0, 7, 112, 0, 12, 24, 0, 24, 12,
  0, 56, 14, 0, 120, 14, 0, 120, 15, 0, 120, 15, 0, 248, 15, 128,
  248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248, 15, 128, 248,
  15, 128, 120, 15, 0, 120, 15, 0, 121, 142, 0, 58, 78, 0, 30, 124,
  0, 30, 120, 128, 6, 112, 128, 1, 224, 128, 0, 96, 128, 0, 113, 128,
  0, 127, 128, 0, 127, 0, 0, 63, 0, 0, 30, 0, 19, 21, 63, 21,
  1, 0, 255, 240, 0, 30, 28, 0, 30, 14, 0, 30, 15, 0, 30, 15,
  0, 30, 15, 0, 30, 15, 0, 30, 14, 0, 30, 28, 0, 31, 224, 0,
  30, 48, 0, 30, 28, 0, 30, 28, 0, 30, 28, 0, 30, 30, 0, 30,
  30, 0, 30, 30, 32, 30, 30, 32, 30, 30, 32, 30, 14, 64, 255, 207,
  192, 13, 22, 44, 17, 3, 0, 4, 0, 59, 144, 64, 240, 192, 112, 192,
  112, 224, 48, 240, 48, 248, 16, 254, 16, 127, 0, 63, 128, 31, 224, 15,
  240, 131, 240, 129, 248, 128, 120, 192, 56, 192, 24, 224, 24, 224, 16, 240,
  48, 159, 192, 17, 21, 63, 20, 2, 0, 255, 255, 128, 227, 207, 128, 195,
  199, 128, 195, 195, 128, 131, 195, 128, 131, 193, 128, 131, 193, 128, 3, 193,
  128, 3, 192, 128, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0,
  3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 31, 248, 0, 19, 21, 63, 22, 2, 0, 255, 15,
  224, 60, 3, 128, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0,
  60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60,
  1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1, 0, 60, 1,
  0, 28, 1, 0, 28, 2, 0, 14, 4, 0, 7, 248, 0, 20, 21, 63,
  22, 1, 0, 255, 207, 240, 30, 1, 128, 31, 1, 0, 31, 1, 0, 15,
  1, 0, 15, 130, 0, 15, 130, 0, 7, 130, 0, 7, 196, 0, 7, 196,
  0, 3, 196, 0, 3, 232, 0, 3, 232, 0, 1, 232, 0, 1, 248, 0,
  0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 96, 0, 0, 96, 0, 0,
  96, 0, 28, 21, 84, 31, 2, 0, 255, 191, 231, 240, 62, 15, 129, 192,
  30, 7, 129, 128, 30, 7, 129, 128, 31, 7, 193, 0, 15, 7, 193, 0,
  15, 7, 193, 0, 15, 143, 226, 0, 7, 137, 226, 0, 7, 137, 226, 0,
  7, 201, 246, 0, 3, 208, 244, 0, 3, 208, 244, 0, 3, 240, 252, 0,
  1, 240, 124, 0, 1, 224, 120, 0, 1, 224, 120, 0, 0, 224, 56, 0,
  0, 192, 48, 0, 0, 192, 48, 0, 0, 64, 16, 0, 19, 21, 63, 20,
  1, 0, 255, 159, 192, 63, 6, 0, 31, 6, 0, 15, 4, 0, 15, 136,
  0, 7, 152, 0, 7, 208, 0, 3, 240, 0, 3, 224, 0, 1, 240, 0,
  1, 240, 0, 0, 248, 0, 1, 248, 0, 3, 124, 0, 2, 124, 0, 6,
  62, 0, 4, 62, 0, 8, 30, 0, 24, 31, 0, 24, 31, 128, 254, 63,
  224, 18, 21, 63, 21, 2, 0, 255, 31, 192, 62, 7, 0, 30, 6, 0,
  30, 4, 0, 31, 4, 0, 15, 4, 0, 15, 136, 0, 7, 136, 0, 7,
  144, 0, 7, 208, 0, 3, 240, 0, 3, 224, 0, 1, 224, 0, 1, 224,
  0, 1, 224, 0, 1, 224, 0, 1, 224, 0, 1, 224, 0, 1, 224, 0,
  1, 224, 0, 7, 248, 0, 15, 21, 42, 19, 2, 0, 127, 254, 120, 62,
  112, 124, 96, 124, 96, 248, 64, 248, 65, 240, 1, 240, 3, 224, 3, 224,
  7, 192, 7, 128, 15, 128, 31, 2, 31, 2, 62, 2, 62, 6, 124, 6,
  124, 14, 248, 30, 255, 254, 7, 26, 26, 11, 2, 251, 254, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 254, 10, 27, 54, 13, 1, 250, 192, 0, 96, 0,
  96, 0, 96, 0, 32, 0, 48, 0, 48, 0, 48, 0, 24, 0, 24, 0,
  24, 0, 12, 0, 12, 0, 12, 0, 4, 0, 6, 0, 6, 0, 6, 0,
  3, 0, 3, 0, 3, 0, 1, 128, 1, 128, 1, 128, 0, 128, 0, 192,
  0, 192, 7, 26, 26, 11, 2, 251, 254, 30, 30, 30, 30, 30, 30, 30,
  30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30,
  30, 254, 12, 10, 20, 16, 2, 12, 6, 0, 7, 0, 15, 0, 29, 128,
  25, 128, 48, 192, 48, 224, 96, 96, 224, 48, 192, 48, 15, 2, 4, 15,
  0, 251, 255, 254, 255, 254, 5, 5, 5, 12, 2, 16, 192, 224, 112, 48,
  24, 12, 14, 28, 14, 1, 0, 30, 0, 99, 128, 99, 192, 243, 192, 115,
  192, 35, 192, 15, 192, 51, 192, 115, 192, 243, 192, 243, 208, 243, 208, 243,
  208, 125, 224, 13, 21, 42, 14, 0, 0, 252, 0, 60, 0, 60, 0, 60,
  0, 60, 0, 60, 0, 60, 0, 61, 192, 62, 96, 60, 112, 60, 112, 60,
  120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 112, 52, 112, 38,
  96, 35, 192, 10, 14, 28, 13, 1, 0, 15, 0, 56, 128, 112, 192, 113,
  192, 243, 192, 243, 128, 240, 0, 240, 0, 240, 0, 240, 0, 112, 64, 112,
  64, 56, 128, 15, 0, 13, 21, 42, 15, 1, 0, 3, 224, 1, 224, 1,
  224, 1, 224, 1, 224, 1, 224, 1, 224, 29, 224, 51, 224, 113, 224, 113,
  224, 241, 224, 241, 224, 241, 224, 241, 224, 241, 224, 241, 224, 113, 224, 113,
  224, 51, 224, 29, 248, 11, 14, 28, 13, 1, 0, 15, 0, 51, 128, 113,
  192, 113, 192, 241, 192, 241, 224, 255, 224, 240, 0, 240, 0, 240, 32, 112,
  64, 112, 64, 56, 128, 15, 0, 11, 21, 42, 10, 1, 0, 7, 128, 12,
  192, 28, 192, 61, 224, 61, 192, 60, 0, 60, 0, 254, 0, 60, 0, 60,
  0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60,
  0, 60, 0, 60, 0, 254, 0, 14, 21, 42, 16, 1, 249, 15, 24, 57,
  236, 121, 252, 121, 248, 121, 224, 121, 224, 57, 192, 57, 192, 15, 0, 112,
  0, 192, 0, 255, 0, 255, 224, 127, 240, 63, 248, 64, 56, 128, 24, 128,
  16, 128, 48, 96, 96, 31, 128, 14, 21, 42, 16, 1, 0, 252, 0, 60,
  0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 61, 224, 62, 112, 60,
  112, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60,
  120, 60, 120, 60, 120, 254, 252, 6, 21, 21, 8, 1, 0, 48, 120, 120,
  48, 0, 0, 0, 248, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120,
  120, 252, 8, 28, 28, 8, 255, 249, 6, 15, 15, 6, 0, 0, 0, 31,
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 79, 255,
  239, 238, 206, 56, 14, 21, 42, 16, 1, 0, 252, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 248, 60, 96, 60, 64, 60, 128,
  60, 128, 61, 128, 63, 128, 63, 192, 61, 224, 60, 224, 60, 240, 60, 112,
  60, 120, 254, 252, 8, 21, 21, 9, 1, 0, 252, 60, 60, 60, 60, 60,
  60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 255, 20,
  14, 42, 23, 2, 0, 249, 199, 128, 126, 233, 192, 120, 241, 192, 120, 241,
  224, 120, 241, 224, 120, 241, 224, 120, 241, 224, 120, 241, 224, 120, 241, 224,
  120, 241, 224, 120, 241, 224, 120, 241, 224, 120, 241, 224, 253, 251, 240, 13,
  14, 28, 16, 2, 0, 251, 192, 124, 224, 120, 224, 120, 240, 120, 240, 120,
  240, 120, 240, 120, 240, 120, 240, 120, 240, 120, 240, 120, 240, 120, 240, 253,
  248, 12, 14, 28, 14, 1, 0, 15, 0, 49, 128, 112, 192, 112, 224, 240,
  224, 240, 224, 240, 240, 240, 240, 240, 224, 240, 224, 112, 224, 112, 192, 49,
  128, 15, 0, 13, 21, 42, 15, 1, 249, 253, 192, 62, 96, 60, 112, 60,
  112, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 112, 60,
  112, 62, 96, 61, 192, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60,
  0, 254, 0, 13, 21, 42, 14, 1, 249, 30, 32, 51, 32, 113, 96, 113,
  224, 241, 224, 241, 224, 241, 224, 241, 224, 241, 224, 241, 224, 113, 224, 113,
  224, 51, 224, 29, 224, 1, 224, 1, 224, 1, 224, 1, 224, 1, 224, 1,
  224, 3, 248, 10, 14, 28, 12, 2, 0, 251, 128, 125, 128, 123, 192, 123,
  128, 121, 128, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120,
  0, 120, 0, 252, 0, 10, 14, 28, 13, 2, 0, 60, 128, 67, 128, 193,
  128, 193, 128, 224, 128, 248, 0, 126, 0, 63, 128, 143, 128, 131, 192, 192,
  192, 224, 192, 240, 128, 143, 0, 9, 20, 40, 10, 0, 0, 8, 0, 8,
  0, 8, 0, 24, 0, 24, 0, 56, 0, 255, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 56, 0, 56, 0, 56, 128, 56, 128, 56, 128, 56, 128, 57,
  128, 57, 0, 14, 0, 14, 14, 28, 15, 0, 0, 253, 248, 60, 120, 60,
  120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60,
  120, 60, 248, 29, 120, 14, 124, 13, 14, 28, 15, 1, 0, 252, 248, 120,
  32, 56, 32, 60, 32, 28, 64, 28, 64, 30, 64, 14, 128, 14, 128, 15,
  0, 7, 0, 7, 0, 6, 0, 2, 0, 20, 14, 42, 22, 1, 0, 253,
  253, 240, 120, 120, 64, 56, 120, 64, 60, 56, 64, 28, 120, 128, 28, 124,
  128, 30, 92, 128, 14, 157, 0, 14, 159, 0, 15, 143, 0, 7, 14, 0,
  7, 14, 0, 6, 6, 0, 2, 4, 0, 13, 14, 28, 15, 1, 0, 254,
  248, 60, 96, 60, 64, 30, 128, 30, 128, 15, 0, 7, 0, 7, 128, 7,
  192, 11, 192, 9, 224, 16, 224, 48, 240, 253, 248, 13, 21, 42, 15, 1,
  249, 252, 248, 120, 32, 56, 32, 60, 64, 28, 64, 28, 64, 30, 64, 14,
  128, 15, 128, 7, 128, 7, 128, 7, 0, 3, 0, 3, 0, 2, 0, 2,
  0, 50, 0, 122, 0, 116, 0, 116, 0, 56, 0, 11, 14, 28, 13, 1,
  0, 127, 224, 97, 224, 67, 192, 67, 128, 71, 128, 15, 0, 15, 0, 30,
  0, 30, 32, 60, 32, 56, 32, 120, 96, 240, 224, 255, 224, 9, 27, 54,
  12, 1, 250, 0, 128, 7, 0, 14, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 28, 0, 28, 0, 56, 0, 224, 0, 56,
  0, 28, 0, 28, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 14, 0, 7, 0, 0, 128, 2, 27, 27, 8, 3, 250, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 9, 27, 54, 13, 2, 250,
  192, 0, 56, 0, 28, 0, 28, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 14, 0, 1, 128, 14, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 28, 0,
  28, 0, 56, 0, 192, 0, 16, 6, 12, 18, 1, 5, 124, 2, 127, 1,
  143, 193, 131, 241, 128, 254, 64, 62, 255
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--34-340-72-72-P-184-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 26, '1' Height: 25
  Calculated Max Values w=34 h=33 x= 6 y=20 dx=36 dy= 0 ascent=34 len=125
  Font Bounding box     w=95 h=44 x=-29 y=-10
  Calculated Min Values           x=-2 y=-10 dx= 0 dy= 0
  Pure Font   ascent =26 descent=-8
  X Font      ascent =26 descent=-8
  Max Font    ascent =34 descent=-10
*/
const u8g_fntpgm_uint8_t u8g_font_osb26[12640] U8G_FONT_SECTION("u8g_font_osb26") = {
  0, 95, 44, 227, 246, 26, 7, 105, 16, 163, 32, 255, 248, 34, 246, 26,
  248, 0, 0, 0, 10, 0, 0, 6, 25, 25, 10, 2, 1, 120, 252, 252,
  252, 252, 252, 120, 120, 120, 120, 48, 48, 48, 48, 48, 48, 48, 0, 0,
  0, 120, 252, 252, 252, 120, 8, 8, 8, 12, 2, 18, 231, 231, 231, 231,
  231, 231, 66, 66, 20, 25, 75, 24, 2, 0, 3, 131, 0, 3, 131, 0,
  3, 3, 0, 3, 3, 0, 3, 3, 0, 3, 7, 0, 3, 7, 0, 255,
  255, 240, 255, 255, 240, 6, 6, 0, 6, 6, 0, 6, 6, 0, 6, 14,
  0, 6, 14, 0, 14, 12, 0, 12, 12, 0, 12, 12, 0, 255, 255, 224,
  255, 255, 224, 12, 28, 0, 12, 24, 0, 28, 24, 0, 24, 24, 0, 24,
  24, 0, 24, 24, 0, 16, 31, 62, 20, 2, 253, 2, 32, 2, 32, 2,
  32, 15, 248, 26, 38, 50, 34, 114, 35, 114, 35, 114, 47, 122, 47, 126,
  46, 126, 46, 63, 160, 63, 224, 31, 240, 15, 248, 7, 252, 3, 254, 2,
  126, 114, 63, 250, 47, 250, 47, 242, 39, 226, 39, 194, 38, 98, 38, 50,
  44, 30, 56, 3, 224, 2, 32, 2, 32, 23, 26, 78, 29, 3, 0, 8,
  0, 48, 54, 0, 32, 99, 0, 96, 99, 0, 192, 227, 128, 192, 227, 129,
  128, 227, 129, 0, 227, 131, 0, 227, 130, 0, 227, 134, 0, 99, 12, 0,
  54, 8, 0, 28, 24, 0, 0, 16, 112, 0, 48, 216, 0, 97, 140, 0,
  97, 140, 0, 195, 142, 0, 131, 142, 1, 131, 142, 1, 3, 142, 3, 3,
  142, 6, 3, 142, 4, 1, 140, 12, 1, 140, 8, 0, 248, 24, 25, 75,
  26, 1, 1, 1, 252, 0, 3, 4, 0, 3, 2, 0, 7, 2, 0, 7,
  2, 0, 7, 6, 0, 7, 132, 0, 7, 200, 0, 3, 240, 0, 3, 224,
  0, 1, 240, 0, 3, 240, 127, 6, 248, 28, 12, 124, 8, 24, 60, 24,
  56, 62, 16, 112, 31, 16, 240, 15, 32, 240, 15, 224, 248, 7, 192, 248,
  3, 192, 252, 3, 225, 126, 7, 242, 127, 253, 254, 31, 240, 124, 3, 8,
  8, 7, 2, 18, 224, 224, 224, 224, 224, 224, 64, 64, 10, 31, 62, 12,
  2, 250, 0, 192, 1, 0, 2, 0, 6, 0, 12, 0, 24, 0, 56, 0,
  56, 0, 120, 0, 112, 0, 112, 0, 240, 0, 240, 0, 240, 0, 240, 0,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 112, 0, 112, 0, 112, 0,
  56, 0, 56, 0, 24, 0, 28, 0, 12, 0, 6, 0, 3, 0, 1, 128,
  9, 32, 64, 12, 1, 250, 192, 0, 96, 0, 48, 0, 24, 0, 28, 0,
  12, 0, 14, 0, 6, 0, 7, 0, 7, 0, 7, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128,
  7, 0, 7, 0, 7, 0, 14, 0, 14, 0, 12, 0, 24, 0, 48, 0,
  96, 0, 192, 0, 128, 0, 12, 14, 28, 17, 3, 11, 14, 0, 14, 0,
  14, 0, 196, 112, 228, 240, 245, 224, 14, 0, 14, 0, 245, 224, 228, 240,
  196, 112, 14, 0, 14, 0, 14, 0, 29, 30, 120, 31, 1, 251, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 255, 255, 255, 248, 255, 255, 255, 248, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 7, 11, 11, 10, 2, 249, 120, 252, 254, 254,
  126, 6, 4, 12, 8, 48, 224, 9, 4, 8, 13, 2, 7, 255, 128, 255,
  128, 255, 128, 255, 128, 5, 5, 5, 9, 2, 0, 112, 248, 248, 248, 112,
  12, 33, 66, 15, 2, 249, 0, 112, 0, 96, 0, 96, 0, 224, 0, 192,
  0, 192, 1, 192, 1, 192, 1, 128, 1, 128, 3, 128, 3, 0, 3, 0,
  7, 0, 6, 0, 6, 0, 6, 0, 14, 0, 12, 0, 12, 0, 28, 0,
  24, 0, 24, 0, 56, 0, 56, 0, 48, 0, 48, 0, 112, 0, 96, 0,
  96, 0, 224, 0, 192, 0, 192, 0, 16, 25, 50, 20, 2, 1, 7, 224,
  14, 112, 28, 56, 60, 60, 60, 60, 124, 62, 124, 62, 124, 62, 252, 63,
  252, 63, 252, 63, 252, 63, 252, 63, 252, 63, 252, 63, 252, 63, 252, 63,
  124, 62, 124, 62, 124, 62, 60, 60, 60, 60, 28, 56, 14, 112, 7, 224,
  12, 25, 50, 20, 4, 0, 7, 0, 7, 0, 31, 0, 255, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 255, 240, 15, 25, 50, 20, 2, 1, 31, 240,
  48, 120, 96, 60, 96, 62, 224, 62, 240, 62, 248, 62, 252, 62, 124, 124,
  56, 124, 0, 248, 1, 240, 1, 224, 3, 128, 7, 0, 12, 2, 24, 2,
  48, 2, 32, 2, 76, 6, 127, 254, 127, 252, 71, 252, 67, 252, 65, 248,
  15, 26, 52, 20, 2, 0, 1, 0, 14, 240, 56, 120, 48, 60, 112, 62,
  120, 62, 124, 62, 124, 62, 60, 62, 24, 60, 0, 120, 0, 112, 31, 192,
  0, 240, 0, 120, 0, 60, 0, 60, 56, 62, 124, 62, 252, 62, 252, 62,
  248, 62, 224, 60, 96, 124, 96, 120, 31, 224, 16, 25, 50, 20, 2, 0,
  0, 120, 0, 120, 0, 248, 1, 248, 1, 248, 3, 248, 3, 248, 6, 248,
  6, 248, 12, 248, 12, 248, 24, 248, 56, 248, 48, 248, 96, 248, 96, 248,
  192, 248, 255, 255, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  15, 255, 15, 26, 52, 20, 3, 0, 0, 8, 48, 56, 63, 240, 63, 224,
  63, 128, 62, 0, 32, 0, 32, 0, 32, 0, 32, 0, 39, 192, 56, 112,
  48, 120, 32, 60, 32, 60, 0, 62, 0, 62, 56, 62, 120, 62, 252, 62,
  248, 62, 248, 60, 224, 60, 96, 120, 112, 112, 31, 224, 16, 25, 50, 20,
  2, 1, 7, 240, 12, 8, 28, 12, 56, 60, 56, 124, 120, 124, 120, 120,
  120, 48, 248, 0, 248, 0, 251, 224, 252, 56, 252, 60, 248, 30, 248, 31,
  248, 31, 248, 31, 248, 31, 120, 31, 120, 31, 120, 31, 56, 30, 28, 30,
  12, 60, 7, 240, 15, 25, 50, 20, 3, 0, 79, 28, 95, 156, 127, 198,
  127, 230, 127, 254, 224, 246, 192, 4, 192, 12, 128, 12, 128, 24, 0, 16,
  0, 48, 0, 96, 0, 224, 1, 192, 1, 192, 3, 192, 7, 128, 7, 128,
  15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 7, 0, 17, 25, 75, 20,
  2, 1, 7, 240, 0, 24, 12, 0, 48, 12, 0, 48, 6, 0, 112, 6,
  0, 112, 6, 0, 120, 6, 0, 124, 4, 0, 127, 12, 0, 127, 152, 0,
  63, 224, 0, 31, 248, 0, 15, 252, 0, 15, 254, 0, 49, 255, 0, 96,
  127, 0, 64, 31, 0, 192, 15, 128, 192, 7, 0, 192, 7, 0, 192, 3,
  0, 96, 6, 0, 96, 6, 0, 56, 12, 0, 14, 240, 0, 15, 25, 50,
  20, 2, 1, 31, 192, 60, 112, 120, 48, 120, 56, 248, 60, 248, 60, 248,
  60, 248, 62, 248, 62, 248, 62, 248, 62, 120, 62, 124, 126, 60, 126, 15,
  190, 0, 62, 0, 62, 12, 60, 30, 60, 62, 60, 62, 56, 60, 56, 48,
  112, 16, 96, 15, 192, 5, 17, 17, 9, 2, 0, 112, 248, 248, 248, 112,
  0, 0, 0, 0, 0, 0, 0, 112, 248, 248, 248, 112, 6, 23, 23, 9,
  2, 249, 112, 248, 248, 248, 112, 0, 0, 0, 0, 0, 0, 0, 112, 248,
  252, 252, 252, 12, 12, 8, 16, 48, 192, 26, 29, 116, 32, 3, 251, 0,
  0, 1, 192, 0, 0, 3, 192, 0, 0, 15, 0, 0, 0, 62, 0, 0,
  0, 248, 0, 0, 1, 224, 0, 0, 7, 128, 0, 0, 31, 0, 0, 0,
  124, 0, 0, 0, 240, 0, 0, 3, 192, 0, 0, 15, 128, 0, 0, 62,
  0, 0, 0, 120, 0, 0, 0, 224, 0, 0, 0, 120, 0, 0, 0, 62,
  0, 0, 0, 15, 128, 0, 0, 3, 192, 0, 0, 0, 240, 0, 0, 0,
  124, 0, 0, 0, 31, 0, 0, 0, 7, 128, 0, 0, 1, 224, 0, 0,
  0, 248, 0, 0, 0, 62, 0, 0, 0, 15, 0, 0, 0, 3, 192, 0,
  0, 1, 192, 29, 9, 36, 33, 2, 5, 255, 255, 255, 248, 255, 255, 255,
  248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 255, 255, 255, 248, 255, 255, 255, 248, 26, 29, 116,
  32, 3, 251, 224, 0, 0, 0, 240, 0, 0, 0, 60, 0, 0, 0, 31,
  0, 0, 0, 7, 192, 0, 0, 1, 224, 0, 0, 0, 120, 0, 0, 0,
  62, 0, 0, 0, 15, 128, 0, 0, 3, 192, 0, 0, 0, 240, 0, 0,
  0, 124, 0, 0, 0, 31, 0, 0, 0, 7, 128, 0, 0, 1, 192, 0,
  0, 7, 128, 0, 0, 31, 0, 0, 0, 124, 0, 0, 0, 240, 0, 0,
  3, 192, 0, 0, 15, 128, 0, 0, 62, 0, 0, 0, 120, 0, 0, 1,
  224, 0, 0, 7, 192, 0, 0, 31, 0, 0, 0, 60, 0, 0, 0, 240,
  0, 0, 0, 224, 0, 0, 0, 11, 25, 50, 16, 2, 1, 63, 128, 67,
  192, 129, 224, 129, 224, 129, 224, 131, 224, 195, 192, 67, 192, 3, 128, 7,
  0, 6, 0, 12, 0, 8, 0, 24, 0, 17, 0, 17, 0, 17, 0, 14,
  0, 0, 0, 0, 0, 14, 0, 31, 0, 31, 0, 31, 0, 14, 0, 25,
  25, 100, 27, 1, 1, 0, 255, 192, 0, 3, 0, 48, 0, 6, 0, 24,
  0, 12, 0, 12, 0, 24, 0, 6, 0, 48, 30, 243, 0, 48, 114, 243,
  0, 96, 225, 227, 0, 97, 225, 225, 128, 227, 193, 225, 128, 195, 193, 225,
  128, 195, 193, 193, 128, 199, 131, 193, 128, 199, 131, 193, 128, 199, 131, 195,
  0, 199, 131, 195, 0, 231, 135, 130, 0, 103, 135, 134, 0, 99, 139, 204,
  0, 49, 240, 240, 0, 48, 0, 0, 0, 24, 0, 0, 0, 12, 0, 0,
  0, 7, 0, 96, 0, 1, 255, 192, 0, 23, 26, 78, 25, 1, 0, 0,
  16, 0, 0, 24, 0, 0, 56, 0, 0, 56, 0, 0, 60, 0, 0, 124,
  0, 0, 124, 0, 0, 126, 0, 0, 254, 0, 0, 254, 0, 0, 158, 0,
  1, 159, 0, 1, 159, 0, 1, 31, 0, 3, 15, 128, 3, 15, 128, 3,
  15, 128, 6, 7, 192, 7, 255, 192, 6, 7, 192, 4, 7, 224, 12, 3,
  224, 12, 3, 224, 28, 3, 240, 28, 3, 240, 255, 159, 254, 20, 25, 75,
  24, 2, 0, 255, 254, 0, 31, 7, 128, 31, 7, 192, 31, 3, 192, 31,
  3, 224, 31, 3, 224, 31, 3, 224, 31, 3, 224, 31, 3, 192, 31, 7,
  128, 31, 7, 0, 31, 248, 0, 31, 7, 0, 31, 3, 192, 31, 1, 224,
  31, 1, 224, 31, 1, 240, 31, 1, 240, 31, 1, 240, 31, 1, 240, 31,
  1, 240, 31, 1, 224, 31, 3, 192, 31, 7, 128, 255, 254, 0, 19, 25,
  75, 22, 2, 1, 3, 248, 64, 14, 6, 192, 30, 3, 192, 60, 3, 192,
  60, 1, 192, 124, 1, 192, 124, 0, 192, 124, 0, 192, 252, 0, 192, 252,
  0, 64, 252, 0, 64, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0,
  0, 252, 0, 0, 252, 0, 96, 124, 0, 64, 124, 0, 64, 124, 0, 64,
  60, 0, 192, 30, 0, 128, 30, 1, 0, 15, 3, 0, 3, 252, 0, 23,
  25, 75, 27, 2, 0, 255, 255, 0, 31, 3, 192, 31, 0, 224, 31, 0,
  240, 31, 0, 120, 31, 0, 120, 31, 0, 124, 31, 0, 124, 31, 0, 126,
  31, 0, 126, 31, 0, 126, 31, 0, 126, 31, 0, 126, 31, 0, 126, 31,
  0, 126, 31, 0, 126, 31, 0, 124, 31, 0, 124, 31, 0, 124, 31, 0,
  120, 31, 0, 120, 31, 0, 240, 31, 0, 224, 31, 3, 192, 255, 255, 0,
  20, 25, 75, 23, 2, 0, 255, 255, 224, 31, 1, 224, 31, 0, 224, 31,
  0, 224, 31, 0, 96, 31, 0, 96, 31, 0, 32, 31, 4, 32, 31, 4,
  0, 31, 12, 0, 31, 12, 0, 31, 28, 0, 31, 252, 0, 31, 28, 0,
  31, 12, 0, 31, 12, 48, 31, 4, 48, 31, 4, 48, 31, 0, 48, 31,
  0, 112, 31, 0, 112, 31, 0, 240, 31, 1, 240, 31, 3, 240, 255, 255,
  240, 20, 25, 75, 23, 2, 0, 255, 255, 240, 31, 3, 240, 31, 0, 240,
  31, 0, 240, 31, 0, 112, 31, 0, 112, 31, 0, 48, 31, 4, 48, 31,
  4, 48, 31, 12, 48, 31, 12, 0, 31, 28, 0, 31, 252, 0, 31, 28,
  0, 31, 12, 0, 31, 12, 0, 31, 4, 0, 31, 4, 0, 31, 0, 0,
  31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 255,
  240, 0, 21, 26, 78, 24, 2, 0, 0, 32, 0, 3, 220, 32, 7, 3,
  96, 14, 1, 224, 28, 1, 224, 60, 0, 224, 60, 0, 224, 124, 0, 96,
  124, 0, 96, 252, 0, 32, 252, 0, 32, 252, 0, 0, 252, 0, 0, 252,
  63, 248, 252, 3, 224, 252, 3, 224, 252, 3, 224, 252, 3, 224, 124, 3,
  224, 124, 3, 224, 124, 3, 224, 60, 3, 224, 60, 3, 96, 30, 6, 96,
  14, 12, 96, 3, 184, 32, 25, 25, 100, 28, 2, 0, 255, 231, 255, 128,
  31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0,
  31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0,
  31, 0, 248, 0, 31, 0, 248, 0, 31, 255, 248, 0, 31, 0, 248, 0,
  31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0,
  31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0,
  31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0, 255, 231, 255, 128,
  11, 25, 50, 14, 2, 0, 255, 224, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 255, 224, 16, 25, 50, 18, 1, 0, 7, 255,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 120, 248,
  248, 248, 248, 248, 248, 248, 240, 248, 224, 240, 64, 240, 97, 224, 63, 192,
  24, 25, 75, 27, 2, 0, 255, 227, 252, 31, 0, 224, 31, 0, 192, 31,
  0, 128, 31, 1, 128, 31, 3, 0, 31, 6, 0, 31, 12, 0, 31, 28,
  0, 31, 28, 0, 31, 62, 0, 31, 126, 0, 31, 255, 0, 31, 191, 0,
  31, 31, 128, 31, 31, 128, 31, 15, 192, 31, 15, 192, 31, 7, 224, 31,
  7, 224, 31, 3, 240, 31, 1, 240, 31, 1, 248, 31, 1, 252, 255, 231,
  255, 20, 25, 75, 23, 2, 0, 255, 224, 0, 31, 0, 0, 31, 0, 0,
  31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31,
  0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0,
  0, 31, 0, 48, 31, 0, 48, 31, 0, 48, 31, 0, 48, 31, 0, 112,
  31, 0, 112, 31, 0, 240, 31, 0, 240, 31, 1, 240, 31, 3, 240, 255,
  255, 240, 27, 25, 100, 30, 2, 0, 255, 0, 63, 224, 15, 0, 63, 0,
  15, 128, 63, 0, 15, 128, 63, 0, 15, 128, 127, 0, 15, 192, 95, 0,
  15, 192, 95, 0, 11, 224, 95, 0, 11, 224, 223, 0, 11, 224, 159, 0,
  9, 240, 159, 0, 9, 240, 159, 0, 9, 241, 31, 0, 8, 249, 31, 0,
  8, 249, 31, 0, 8, 249, 31, 0, 8, 126, 31, 0, 8, 126, 31, 0,
  8, 62, 31, 0, 8, 62, 31, 0, 8, 60, 31, 0, 8, 28, 31, 0,
  24, 28, 31, 0, 60, 28, 31, 0, 255, 8, 255, 224, 24, 25, 75, 27,
  2, 0, 255, 3, 255, 31, 128, 124, 31, 128, 56, 15, 192, 16, 7, 224,
  16, 7, 240, 16, 7, 240, 16, 5, 248, 16, 5, 252, 16, 4, 252, 16,
  4, 126, 16, 4, 127, 16, 4, 63, 16, 4, 31, 144, 4, 31, 208, 4,
  15, 208, 4, 7, 240, 4, 7, 240, 4, 3, 240, 4, 1, 240, 4, 1,
  240, 4, 0, 240, 14, 0, 112, 31, 0, 48, 255, 192, 48, 20, 25, 75,
  24, 2, 1, 3, 252, 0, 6, 6, 0, 14, 7, 0, 28, 3, 128, 60,
  3, 192, 60, 3, 192, 124, 3, 224, 124, 3, 224, 124, 3, 224, 252, 3,
  240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240,
  252, 3, 240, 124, 3, 224, 124, 3, 224, 124, 3, 224, 60, 3, 192, 60,
  3, 192, 28, 3, 128, 14, 7, 0, 6, 6, 0, 3, 252, 0, 20, 25,
  75, 24, 2, 0, 255, 254, 0, 31, 3, 128, 31, 3, 192, 31, 1, 224,
  31, 1, 240, 31, 1, 240, 31, 1, 240, 31, 1, 240, 31, 1, 240, 31,
  1, 224, 31, 3, 192, 31, 7, 128, 31, 254, 0, 31, 0, 0, 31, 0,
  0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0,
  31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 255, 240, 0, 20,
  33, 99, 24, 2, 249, 3, 252, 0, 6, 6, 0, 14, 7, 0, 28, 3,
  128, 60, 3, 192, 60, 3, 192, 124, 3, 224, 124, 3, 224, 124, 3, 224,
  252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252,
  3, 240, 252, 3, 240, 124, 3, 240, 124, 3, 224, 124, 3, 224, 60, 243,
  192, 61, 155, 192, 29, 11, 128, 15, 15, 128, 7, 15, 16, 3, 156, 16,
  0, 108, 16, 0, 12, 16, 0, 12, 48, 0, 14, 48, 0, 15, 240, 0,
  15, 224, 0, 7, 224, 0, 3, 128, 22, 25, 75, 25, 2, 0, 255, 252,
  0, 31, 7, 128, 31, 7, 192, 31, 3, 192, 31, 3, 224, 31, 3, 224,
  31, 3, 224, 31, 3, 224, 31, 3, 192, 31, 7, 192, 31, 15, 0, 31,
  248, 0, 31, 14, 0, 31, 15, 0, 31, 7, 128, 31, 7, 192, 31, 7,
  192, 31, 7, 192, 31, 7, 192, 31, 7, 196, 31, 7, 196, 31, 7, 196,
  31, 7, 196, 31, 3, 200, 255, 241, 248, 16, 25, 50, 21, 3, 1, 31,
  198, 32, 118, 96, 62, 224, 30, 224, 14, 240, 6, 248, 6, 252, 6, 255,
  2, 127, 128, 127, 192, 63, 240, 15, 248, 7, 252, 129, 254, 128, 254, 192,
  127, 192, 31, 192, 15, 224, 7, 224, 7, 240, 6, 248, 6, 220, 12, 135,
  120, 21, 25, 75, 25, 3, 0, 255, 255, 248, 248, 248, 248, 240, 248, 120,
  224, 248, 120, 192, 248, 56, 192, 248, 56, 128, 248, 24, 128, 248, 24, 128,
  248, 24, 128, 248, 24, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248,
  0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0,
  0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 15,
  255, 0, 23, 25, 75, 26, 2, 0, 255, 225, 254, 31, 0, 120, 31, 0,
  48, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16,
  31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31,
  0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0,
  16, 31, 0, 16, 15, 0, 32, 15, 0, 32, 7, 128, 64, 3, 192, 192,
  1, 255, 0, 24, 25, 75, 27, 2, 0, 255, 241, 255, 31, 128, 56, 15,
  128, 48, 15, 192, 48, 15, 192, 48, 7, 192, 32, 7, 224, 32, 7, 224,
  96, 3, 224, 64, 3, 240, 64, 1, 240, 192, 1, 240, 128, 1, 248, 128,
  0, 249, 128, 0, 249, 128, 0, 253, 0, 0, 125, 0, 0, 127, 0, 0,
  126, 0, 0, 62, 0, 0, 62, 0, 0, 60, 0, 0, 28, 0, 0, 28,
  0, 0, 24, 0, 34, 25, 125, 36, 1, 0, 255, 231, 255, 127, 192, 31,
  129, 248, 14, 0, 15, 128, 248, 14, 0, 15, 128, 252, 12, 0, 15, 192,
  124, 12, 0, 7, 192, 124, 12, 0, 7, 192, 124, 8, 0, 7, 224, 254,
  24, 0, 3, 224, 190, 24, 0, 3, 224, 190, 24, 0, 3, 241, 159, 16,
  0, 1, 241, 159, 48, 0, 1, 241, 31, 48, 0, 1, 249, 15, 32, 0,
  1, 251, 15, 160, 0, 0, 250, 15, 224, 0, 0, 254, 15, 224, 0, 0,
  254, 7, 192, 0, 0, 126, 7, 192, 0, 0, 124, 7, 192, 0, 0, 124,
  3, 192, 0, 0, 60, 3, 128, 0, 0, 56, 3, 128, 0, 0, 56, 1,
  128, 0, 0, 24, 1, 128, 0, 23, 25, 75, 26, 2, 0, 255, 231, 252,
  31, 193, 224, 15, 192, 192, 15, 193, 128, 7, 225, 128, 7, 227, 0, 3,
  242, 0, 3, 246, 0, 1, 244, 0, 1, 248, 0, 0, 248, 0, 0, 252,
  0, 0, 124, 0, 0, 62, 0, 0, 126, 0, 0, 127, 0, 0, 159, 0,
  1, 159, 128, 1, 15, 128, 3, 15, 192, 6, 7, 224, 4, 7, 224, 12,
  3, 240, 28, 7, 240, 255, 143, 254, 23, 25, 75, 26, 2, 0, 255, 225,
  254, 31, 128, 112, 31, 128, 96, 15, 128, 96, 15, 192, 64, 7, 192, 192,
  7, 224, 192, 7, 224, 128, 3, 225, 128, 3, 241, 0, 1, 241, 0, 1,
  251, 0, 0, 250, 0, 0, 254, 0, 0, 252, 0, 0, 124, 0, 0, 124,
  0, 0, 124, 0, 0, 124, 0, 0, 124, 0, 0, 124, 0, 0, 124, 0,
  0, 124, 0, 0, 124, 0, 3, 255, 128, 18, 25, 75, 22, 2, 0, 127,
  255, 192, 124, 15, 192, 120, 31, 128, 112, 31, 128, 96, 63, 0, 96, 63,
  0, 64, 126, 0, 64, 126, 0, 64, 252, 0, 0, 252, 0, 1, 248, 0,
  1, 240, 0, 3, 240, 0, 7, 224, 0, 7, 224, 0, 15, 192, 64, 15,
  192, 64, 31, 128, 64, 31, 128, 64, 63, 0, 192, 63, 1, 192, 126, 1,
  192, 126, 3, 192, 252, 15, 192, 255, 255, 192, 8, 31, 31, 14, 3, 250,
  255, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 255, 11,
  33, 66, 15, 2, 249, 192, 0, 192, 0, 224, 0, 96, 0, 96, 0, 96,
  0, 112, 0, 48, 0, 48, 0, 56, 0, 24, 0, 24, 0, 28, 0, 12,
  0, 12, 0, 12, 0, 14, 0, 6, 0, 6, 0, 7, 0, 3, 0, 3,
  0, 3, 0, 3, 128, 1, 128, 1, 128, 1, 192, 0, 192, 0, 192, 0,
  224, 0, 96, 0, 96, 0, 96, 8, 31, 31, 13, 2, 250, 255, 15, 15,
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 255, 16, 12, 24, 20,
  2, 14, 1, 128, 3, 128, 3, 192, 7, 224, 14, 96, 14, 112, 28, 56,
  24, 56, 56, 28, 112, 12, 96, 14, 224, 7, 18, 2, 6, 18, 0, 250,
  255, 255, 192, 255, 255, 192, 6, 7, 7, 15, 3, 18, 224, 224, 240, 120,
  24, 12, 4, 15, 17, 34, 18, 2, 0, 15, 128, 49, 224, 96, 240, 112,
  240, 120, 240, 120, 240, 32, 240, 7, 240, 28, 240, 56, 240, 120, 240, 240,
  240, 240, 242, 240, 242, 240, 242, 121, 252, 62, 120, 15, 25, 50, 18, 1,
  0, 252, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60,
  0, 60, 240, 61, 56, 62, 60, 62, 28, 62, 30, 62, 30, 60, 30, 60,
  30, 60, 30, 60, 30, 60, 30, 62, 30, 62, 30, 62, 28, 50, 60, 35,
  56, 33, 224, 13, 17, 34, 16, 2, 0, 7, 128, 28, 96, 56, 32, 120,
  112, 120, 240, 248, 240, 240, 224, 240, 64, 240, 0, 240, 0, 240, 0, 240,
  8, 120, 16, 120, 16, 56, 16, 28, 32, 7, 192, 17, 25, 75, 20, 2,
  0, 1, 252, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0,
  0, 60, 0, 0, 60, 0, 0, 60, 0, 15, 60, 0, 28, 188, 0, 56,
  124, 0, 120, 124, 0, 120, 60, 0, 240, 60, 0, 240, 60, 0, 240, 60,
  0, 240, 60, 0, 240, 60, 0, 240, 60, 0, 240, 60, 0, 120, 60, 0,
  120, 124, 0, 56, 124, 0, 28, 188, 0, 15, 63, 128, 13, 17, 34, 17,
  2, 0, 7, 128, 24, 224, 56, 240, 120, 240, 120, 240, 240, 120, 240, 120,
  240, 120, 255, 248, 240, 0, 240, 0, 240, 8, 120, 8, 120, 24, 56, 16,
  28, 32, 7, 192, 12, 25, 50, 12, 1, 0, 3, 192, 14, 112, 30, 112,
  28, 240, 60, 240, 60, 240, 60, 0, 60, 0, 255, 128, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 255, 128, 17, 25, 75, 19,
  1, 248, 7, 199, 0, 28, 249, 128, 60, 115, 128, 120, 123, 128, 120, 123,
  0, 120, 120, 0, 120, 120, 0, 120, 120, 0, 60, 112, 0, 28, 224, 0,
  7, 192, 0, 56, 0, 0, 96, 0, 0, 127, 192, 0, 127, 248, 0, 127,
  252, 0, 63, 254, 0, 63, 254, 0, 64, 14, 0, 128, 6, 0, 128, 6,
  0, 128, 4, 0, 64, 12, 0, 32, 56, 0, 31, 224, 0, 17, 25, 75,
  19, 1, 0, 252, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60,
  0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 120, 0, 61, 188,
  0, 61, 28, 0, 62, 30, 0, 62, 30, 0, 62, 30, 0, 60, 30, 0,
  60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60,
  30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 255, 127, 128, 8, 25,
  25, 11, 2, 0, 56, 124, 124, 124, 56, 0, 0, 0, 252, 60, 60, 60,
  60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 255, 10, 33, 66,
  10, 254, 248, 3, 128, 7, 192, 7, 192, 7, 192, 3, 128, 0, 0, 0,
  0, 0, 0, 31, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 99, 192, 243, 192, 243, 192, 243, 128, 231,
  128, 103, 0, 62, 0, 17, 25, 75, 19, 1, 0, 252, 0, 0, 60, 0,
  0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0,
  60, 0, 0, 60, 127, 0, 60, 24, 0, 60, 16, 0, 60, 48, 0, 60,
  32, 0, 60, 64, 0, 60, 192, 0, 60, 224, 0, 61, 224, 0, 62, 240,
  0, 62, 240, 0, 60, 120, 0, 60, 124, 0, 60, 60, 0, 60, 62, 0,
  60, 62, 0, 255, 127, 128, 9, 25, 50, 11, 1, 0, 252, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 255, 128, 25, 17,
  68, 28, 1, 0, 252, 120, 120, 0, 61, 188, 158, 0, 61, 31, 30, 0,
  62, 31, 30, 0, 62, 30, 31, 0, 62, 30, 31, 0, 60, 30, 31, 0,
  60, 30, 31, 0, 60, 30, 31, 0, 60, 30, 31, 0, 60, 30, 31, 0,
  60, 30, 31, 0, 60, 30, 31, 0, 60, 30, 31, 0, 60, 30, 31, 0,
  60, 30, 31, 0, 255, 127, 191, 128, 17, 17, 51, 19, 1, 0, 252, 120,
  0, 61, 188, 0, 61, 28, 0, 62, 30, 0, 62, 30, 0, 62, 30, 0,
  60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60,
  30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 255, 127,
  128, 14, 17, 34, 18, 2, 0, 7, 128, 28, 224, 56, 112, 120, 120, 120,
  120, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 120,
  120, 120, 120, 56, 112, 24, 224, 7, 128, 15, 25, 50, 18, 1, 248, 252,
  240, 61, 56, 62, 60, 62, 28, 62, 30, 62, 30, 60, 30, 60, 30, 60,
  30, 60, 30, 60, 30, 62, 30, 62, 30, 62, 28, 62, 60, 61, 56, 60,
  240, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 255,
  128, 16, 25, 50, 19, 2, 248, 15, 132, 28, 196, 56, 100, 120, 124, 120,
  60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 120,
  124, 120, 124, 56, 124, 28, 188, 15, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 1, 255, 12, 17, 34, 14, 1, 0, 252,
  224, 61, 112, 62, 240, 62, 240, 62, 240, 62, 96, 60, 0, 60, 0, 60,
  0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 255,
  0, 11, 17, 34, 14, 2, 0, 60, 64, 99, 64, 193, 192, 192, 192, 224,
  192, 240, 64, 252, 0, 127, 0, 63, 128, 31, 192, 135, 224, 129, 224, 192,
  224, 224, 96, 224, 96, 144, 192, 143, 128, 11, 24, 48, 13, 1, 0, 12,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 28, 0, 60, 0, 255, 192, 60,
  0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60,
  32, 60, 32, 60, 32, 60, 32, 60, 96, 60, 64, 31, 192, 15, 128, 17,
  17, 51, 19, 1, 0, 252, 126, 0, 60, 30, 0, 60, 30, 0, 60, 30,
  0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0,
  60, 30, 0, 60, 30, 0, 60, 62, 0, 60, 62, 0, 60, 62, 0, 60,
  94, 0, 30, 158, 0, 15, 31, 128, 17, 17, 51, 18, 0, 0, 255, 159,
  128, 30, 6, 0, 30, 4, 0, 30, 4, 0, 15, 12, 0, 15, 8, 0,
  15, 8, 0, 7, 152, 0, 7, 144, 0, 3, 208, 0, 3, 240, 0, 3,
  224, 0, 1, 224, 0, 1, 192, 0, 1, 192, 0, 0, 192, 0, 0, 128,
  0, 25, 17, 68, 26, 0, 0, 255, 63, 207, 128, 30, 15, 6, 0, 30,
  15, 6, 0, 30, 15, 4, 0, 15, 7, 132, 0, 15, 15, 132, 0, 7,
  143, 136, 0, 7, 139, 200, 0, 7, 147, 200, 0, 3, 211, 208, 0, 3,
  209, 240, 0, 3, 225, 240, 0, 1, 225, 224, 0, 1, 224, 224, 0, 1,
  192, 224, 0, 0, 192, 192, 0, 0, 192, 64, 0, 16, 17, 34, 18, 1,
  0, 255, 126, 62, 24, 30, 16, 31, 16, 15, 32, 15, 192, 7, 192, 3,
  192, 3, 192, 1, 224, 3, 240, 2, 240, 4, 248, 8, 120, 8, 124, 24,
  126, 254, 127, 17, 25, 75, 18, 0, 248, 255, 159, 128, 62, 6, 0, 30,
  4, 0, 31, 4, 0, 15, 8, 0, 15, 8, 0, 15, 136, 0, 7, 136,
  0, 7, 144, 0, 3, 208, 0, 3, 208, 0, 3, 224, 0, 1, 224, 0,
  1, 224, 0, 0, 224, 0, 0, 192, 0, 0, 64, 0, 0, 64, 0, 0,
  128, 0, 28, 128, 0, 60, 128, 0, 60, 128, 0, 57, 0, 0, 59, 0,
  0, 30, 0, 0, 13, 17, 34, 16, 1, 0, 127, 248, 112, 248, 96, 240,
  97, 224, 67, 224, 67, 192, 7, 192, 7, 128, 15, 128, 15, 0, 31, 8,
  30, 8, 60, 24, 124, 24, 120, 56, 248, 120, 255, 248, 11, 33, 66, 15,
  2, 249, 0, 32, 3, 192, 7, 0, 15, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  56, 0, 224, 0, 56, 0, 28, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 14, 0, 7, 0,
  3, 192, 0, 32, 2, 32, 32, 10, 4, 249, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 11, 33, 66, 15, 3, 249,
  128, 0, 240, 0, 60, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 15, 0, 7, 0,
  1, 224, 7, 0, 15, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 60, 0, 240, 0,
  128, 0, 19, 7, 21, 23, 2, 6, 62, 0, 64, 127, 128, 32, 255, 240,
  32, 135, 252, 32, 129, 255, 224, 128, 63, 192, 64, 15, 128, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
  0, 10, 0, 0, 6, 26, 26, 10, 2, 248, 120, 252, 252, 252, 120, 0,
  0, 0, 32, 48, 48, 48, 48, 48, 48, 120, 120, 120, 120, 252, 252, 252,
  252, 252, 252, 120, 13, 25, 50, 19, 3, 252, 1, 0, 1, 0, 1, 0,
  1, 0, 15, 192, 29, 32, 57, 48, 121, 112, 121, 112, 249, 112, 241, 96,
  241, 0, 241, 0, 241, 0, 241, 0, 241, 8, 121, 16, 121, 16, 57, 16,
  29, 32, 15, 192, 1, 0, 1, 0, 1, 0, 1, 0, 21, 26, 78, 24,
  2, 0, 0, 2, 0, 0, 61, 192, 0, 112, 96, 0, 240, 112, 1, 224,
  112, 1, 224, 240, 3, 224, 240, 3, 224, 224, 3, 224, 0, 3, 224, 0,
  3, 224, 0, 31, 224, 0, 35, 225, 0, 1, 254, 0, 1, 240, 0, 1,
  240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 224, 0, 0, 224,
  8, 60, 192, 16, 199, 192, 48, 131, 255, 224, 131, 255, 192, 124, 63, 128,
  18, 17, 51, 20, 1, 3, 64, 0, 128, 227, 241, 192, 127, 255, 128, 60,
  15, 0, 56, 7, 0, 48, 3, 0, 112, 3, 128, 96, 1, 128, 96, 1,
  128, 96, 1, 128, 96, 1, 128, 112, 3, 128, 48, 3, 0, 56, 7, 0,
  62, 31, 0, 127, 255, 128, 99, 241, 128, 18, 25, 75, 20, 1, 0, 255,
  143, 192, 63, 3, 128, 63, 3, 0, 31, 3, 0, 31, 130, 0, 15, 130,
  0, 15, 196, 0, 15, 196, 0, 7, 196, 0, 7, 232, 0, 3, 232, 0,
  3, 248, 0, 3, 240, 0, 63, 255, 128, 1, 240, 0, 1, 240, 0, 63,
  255, 128, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240, 0, 1, 240,
  0, 1, 240, 0, 1, 240, 0, 31, 254, 0, 2, 32, 32, 10, 4, 250,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 0, 0, 0,
  0, 0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  15, 32, 64, 22, 2, 249, 7, 224, 28, 24, 56, 24, 48, 28, 112, 124,
  112, 124, 112, 124, 120, 56, 124, 0, 63, 0, 31, 224, 127, 240, 71, 252,
  193, 252, 192, 126, 224, 30, 248, 14, 254, 6, 127, 134, 63, 228, 31, 248,
  7, 248, 1, 248, 0, 124, 60, 60, 60, 28, 124, 28, 124, 28, 112, 24,
  48, 56, 24, 112, 15, 192, 11, 4, 8, 15, 2, 19, 113, 192, 241, 224,
  241, 224, 113, 192, 24, 25, 75, 28, 2, 1, 1, 255, 128, 6, 0, 64,
  12, 0, 48, 24, 0, 24, 48, 60, 136, 32, 227, 132, 65, 193, 134, 65,
  193, 130, 195, 192, 130, 131, 192, 131, 131, 192, 129, 131, 192, 1, 131, 192,
  1, 131, 192, 1, 131, 192, 65, 131, 192, 131, 195, 192, 130, 65, 192, 130,
  65, 193, 134, 32, 227, 4, 48, 60, 8, 16, 0, 24, 12, 0, 48, 6,
  0, 64, 1, 255, 128, 10, 13, 26, 13, 1, 12, 60, 0, 70, 0, 199,
  0, 231, 0, 71, 0, 63, 0, 103, 0, 231, 0, 231, 64, 231, 64, 123,
  128, 0, 0, 255, 128, 9, 15, 30, 17, 4, 1, 8, 0, 24, 128, 48,
  128, 97, 0, 99, 0, 227, 0, 227, 0, 227, 0, 227, 0, 227, 0, 227,
  0, 97, 0, 49, 128, 48, 128, 8, 0, 16, 9, 18, 20, 2, 5, 255,
  255, 255, 255, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0,
  3, 9, 4, 8, 13, 2, 7, 255, 128, 255, 128, 255, 128, 255, 128, 24,
  25, 75, 28, 2, 1, 1, 255, 128, 6, 0, 64, 12, 0, 48, 24, 0,
  24, 55, 254, 8, 33, 227, 132, 65, 227, 198, 65, 227, 194, 193, 227, 194,
  129, 227, 195, 129, 231, 129, 129, 252, 1, 129, 231, 1, 129, 227, 129, 129,
  227, 193, 129, 227, 195, 193, 227, 210, 65, 227, 210, 65, 227, 214, 33, 227,
  212, 55, 249, 232, 16, 0, 24, 12, 0, 48, 6, 0, 64, 1, 255, 128,
  9, 2, 4, 15, 3, 20, 255, 128, 255, 128, 11, 10, 20, 19, 4, 16,
  63, 128, 123, 192, 224, 192, 192, 96, 192, 96, 192, 96, 192, 224, 97, 192,
  63, 128, 31, 0, 29, 26, 104, 33, 2, 254, 0, 6, 0, 0, 0, 6,
  0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6,
  0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6,
  0, 0, 255, 255, 255, 248, 255, 255, 255, 248, 0, 6, 0, 0, 0, 6,
  0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6,
  0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6, 0, 0, 0, 6,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 240, 255, 255,
  255, 240, 10, 16, 32, 15, 3, 9, 31, 0, 103, 128, 195, 192, 195, 192,
  227, 192, 243, 128, 7, 128, 14, 0, 28, 0, 48, 64, 64, 64, 64, 64,
  255, 192, 255, 192, 159, 128, 135, 0, 11, 16, 32, 15, 2, 9, 31, 0,
  35, 128, 99, 192, 115, 192, 115, 192, 51, 128, 3, 0, 28, 0, 3, 128,
  3, 192, 97, 224, 241, 224, 241, 224, 227, 224, 99, 192, 63, 0, 6, 7,
  7, 15, 6, 18, 28, 28, 60, 120, 96, 192, 128, 17, 27, 81, 20, 2,
  246, 96, 48, 0, 112, 120, 0, 240, 120, 0, 240, 120, 0, 240, 120, 0,
  240, 120, 0, 240, 120, 0, 240, 120, 0, 240, 120, 0, 96, 56, 0, 96,
  48, 128, 96, 48, 128, 96, 113, 128, 32, 127, 128, 48, 255, 128, 95, 207,
  0, 71, 143, 0, 64, 0, 0, 96, 0, 0, 96, 0, 0, 112, 0, 0,
  112, 0, 0, 120, 0, 0, 120, 0, 0, 120, 0, 0, 120, 0, 0, 48,
  0, 0, 17, 30, 90, 20, 2, 251, 15, 255, 128, 63, 140, 0, 127, 140,
  0, 127, 140, 0, 255, 140, 0, 255, 140, 0, 255, 140, 0, 255, 140, 0,
  255, 140, 0, 127, 140, 0, 127, 140, 0, 63, 140, 0, 31, 140, 0, 1,
  140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140,
  0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0,
  1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1,
  140, 0, 5, 5, 5, 9, 2, 9, 112, 248, 248, 248, 112, 7, 7, 7,
  15, 4, 249, 32, 32, 24, 14, 14, 14, 252, 8, 15, 15, 16, 4, 10,
  12, 28, 252, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 255, 9,
  13, 26, 13, 2, 12, 28, 0, 103, 0, 99, 0, 227, 128, 227, 128, 227,
  128, 227, 128, 227, 128, 99, 0, 103, 0, 28, 0, 0, 0, 255, 128, 9,
  14, 28, 17, 4, 2, 132, 0, 198, 0, 99, 0, 99, 0, 115, 128, 115,
  128, 115, 128, 115, 128, 115, 128, 99, 128, 99, 0, 195, 0, 134, 0, 12,
  0, 25, 26, 104, 31, 4, 0, 0, 0, 48, 0, 12, 0, 48, 0, 28,
  0, 96, 0, 252, 0, 96, 0, 60, 0, 192, 0, 60, 0, 128, 0, 60,
  1, 128, 0, 60, 3, 0, 0, 60, 3, 0, 0, 60, 6, 0, 0, 60,
  6, 0, 0, 60, 12, 14, 0, 60, 12, 30, 0, 60, 24, 30, 0, 60,
  16, 62, 0, 255, 48, 62, 0, 0, 96, 94, 0, 0, 96, 158, 0, 0,
  192, 158, 0, 0, 193, 30, 0, 1, 131, 30, 0, 1, 131, 255, 128, 3,
  0, 30, 0, 2, 0, 30, 0, 6, 0, 30, 0, 12, 0, 255, 128, 25,
  26, 104, 31, 4, 0, 0, 0, 48, 0, 28, 0, 32, 0, 252, 0, 96,
  0, 60, 0, 64, 0, 60, 0, 192, 0, 60, 1, 128, 0, 60, 1, 128,
  0, 60, 3, 0, 0, 60, 3, 0, 0, 60, 6, 0, 0, 60, 4, 62,
  0, 60, 12, 207, 0, 60, 9, 135, 128, 60, 25, 135, 128, 60, 49, 199,
  128, 255, 49, 231, 0, 0, 96, 207, 0, 0, 96, 28, 0, 0, 192, 56,
  0, 0, 128, 96, 0, 1, 128, 64, 128, 3, 0, 128, 128, 3, 1, 255,
  128, 6, 1, 255, 128, 6, 1, 63, 0, 12, 1, 14, 0, 26, 26, 104,
  30, 2, 0, 0, 0, 24, 0, 31, 0, 24, 0, 35, 128, 48, 0, 99,
  192, 48, 0, 115, 192, 96, 0, 115, 192, 64, 0, 51, 128, 192, 0, 3,
  0, 128, 0, 28, 1, 128, 0, 3, 131, 0, 0, 3, 195, 0, 0, 113,
  230, 7, 0, 241, 228, 15, 0, 227, 236, 15, 0, 99, 200, 31, 0, 63,
  24, 31, 0, 0, 16, 47, 0, 0, 48, 79, 0, 0, 96, 79, 0, 0,
  96, 143, 0, 0, 192, 143, 0, 0, 129, 255, 192, 1, 128, 15, 0, 1,
  0, 15, 0, 3, 0, 15, 0, 2, 0, 127, 192, 11, 26, 52, 16, 2,
  248, 28, 0, 62, 0, 62, 0, 62, 0, 28, 0, 0, 0, 0, 0, 30,
  0, 49, 0, 33, 0, 33, 0, 1, 0, 2, 0, 6, 0, 14, 0, 28,
  0, 60, 0, 120, 192, 120, 64, 248, 32, 240, 32, 240, 32, 240, 32, 120,
  64, 120, 64, 31, 128, 23, 33, 99, 25, 1, 0, 1, 128, 0, 1, 192,
  0, 0, 224, 0, 0, 96, 0, 0, 48, 0, 0, 16, 0, 0, 0, 0,
  0, 16, 0, 0, 24, 0, 0, 56, 0, 0, 56, 0, 0, 60, 0, 0,
  124, 0, 0, 124, 0, 0, 126, 0, 0, 254, 0, 0, 254, 0, 0, 158,
  0, 1, 159, 0, 1, 159, 0, 1, 31, 0, 3, 15, 128, 3, 15, 128,
  3, 15, 128, 6, 7, 192, 7, 255, 192, 6, 7, 192, 4, 7, 224, 12,
  3, 224, 12, 3, 224, 28, 3, 240, 28, 3, 240, 255, 159, 254, 23, 33,
  99, 25, 1, 0, 0, 3, 0, 0, 7, 128, 0, 7, 0, 0, 14, 0,
  0, 28, 0, 0, 16, 0, 0, 0, 0, 0, 16, 0, 0, 24, 0, 0,
  56, 0, 0, 56, 0, 0, 60, 0, 0, 124, 0, 0, 124, 0, 0, 126,
  0, 0, 254, 0, 0, 254, 0, 0, 159, 0, 1, 159, 0, 1, 159, 0,
  1, 31, 128, 3, 15, 128, 3, 15, 128, 3, 15, 128, 6, 7, 192, 7,
  255, 192, 6, 7, 192, 12, 7, 224, 12, 3, 224, 12, 3, 224, 28, 3,
  240, 60, 3, 248, 255, 159, 254, 23, 33, 99, 25, 1, 0, 0, 16, 0,
  0, 56, 0, 0, 56, 0, 0, 124, 0, 0, 199, 0, 1, 129, 128, 0,
  0, 0, 0, 16, 0, 0, 24, 0, 0, 56, 0, 0, 56, 0, 0, 60,
  0, 0, 124, 0, 0, 124, 0, 0, 126, 0, 0, 254, 0, 0, 254, 0,
  0, 158, 0, 1, 159, 0, 1, 159, 0, 1, 31, 0, 3, 15, 128, 3,
  15, 128, 3, 15, 128, 6, 7, 192, 7, 255, 192, 6, 7, 192, 4, 7,
  224, 12, 3, 224, 12, 3, 224, 28, 3, 240, 28, 3, 240, 255, 159, 254,
  23, 32, 96, 25, 1, 0, 0, 112, 128, 0, 249, 0, 1, 191, 0, 1,
  14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 56,
  0, 0, 56, 0, 0, 60, 0, 0, 124, 0, 0, 124, 0, 0, 126, 0,
  0, 254, 0, 0, 254, 0, 0, 159, 0, 1, 159, 0, 1, 159, 0, 1,
  31, 128, 3, 15, 128, 3, 15, 128, 3, 15, 128, 6, 7, 192, 7, 255,
  192, 6, 7, 192, 12, 7, 224, 12, 3, 224, 12, 3, 224, 28, 3, 240,
  60, 3, 248, 255, 159, 254, 23, 32, 96, 25, 1, 0, 1, 195, 128, 3,
  199, 128, 3, 199, 128, 1, 195, 128, 0, 0, 0, 0, 0, 0, 0, 24,
  0, 0, 56, 0, 0, 56, 0, 0, 56, 0, 0, 60, 0, 0, 124, 0,
  0, 124, 0, 0, 126, 0, 0, 254, 0, 0, 254, 0, 0, 159, 0, 1,
  159, 0, 1, 159, 0, 1, 15, 128, 3, 15, 128, 2, 15, 128, 2, 15,
  192, 6, 7, 192, 7, 255, 192, 4, 7, 192, 4, 3, 224, 8, 3, 224,
  8, 3, 224, 24, 1, 240, 24, 3, 240, 255, 159, 254, 23, 33, 99, 25,
  1, 0, 0, 60, 0, 0, 126, 0, 0, 195, 0, 0, 195, 0, 0, 199,
  0, 0, 126, 0, 0, 60, 0, 0, 0, 0, 0, 24, 0, 0, 56, 0,
  0, 56, 0, 0, 60, 0, 0, 124, 0, 0, 124, 0, 0, 126, 0, 0,
  254, 0, 0, 254, 0, 0, 159, 0, 1, 159, 0, 1, 159, 0, 1, 15,
  0, 3, 15, 128, 3, 15, 128, 2, 15, 128, 2, 7, 192, 7, 255, 192,
  4, 7, 192, 4, 3, 224, 12, 3, 224, 8, 3, 224, 24, 1, 240, 28,
  1, 240, 255, 159, 254, 32, 25, 100, 34, 1, 0, 0, 15, 255, 255, 0,
  3, 240, 31, 0, 7, 240, 15, 0, 7, 240, 7, 0, 5, 240, 7, 0,
  13, 240, 3, 0, 9, 240, 3, 0, 25, 240, 35, 0, 25, 240, 32, 0,
  49, 240, 96, 0, 49, 240, 96, 0, 97, 240, 224, 0, 97, 255, 224, 0,
  193, 240, 224, 0, 193, 240, 96, 1, 129, 240, 96, 1, 129, 240, 33, 3,
  255, 240, 33, 3, 1, 240, 3, 6, 1, 240, 3, 6, 1, 240, 7, 12,
  1, 240, 7, 12, 1, 240, 15, 62, 1, 240, 63, 255, 143, 255, 255, 19,
  33, 99, 22, 2, 249, 3, 248, 192, 14, 6, 192, 30, 3, 192, 60, 3,
  192, 60, 1, 192, 124, 1, 192, 124, 0, 192, 124, 0, 192, 252, 0, 192,
  252, 0, 64, 252, 0, 64, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252,
  0, 0, 252, 0, 0, 252, 0, 96, 124, 0, 64, 124, 0, 64, 124, 0,
  64, 60, 0, 192, 62, 0, 128, 30, 1, 0, 15, 2, 0, 3, 156, 0,
  0, 224, 0, 0, 128, 0, 0, 240, 0, 0, 56, 0, 0, 56, 0, 0,
  56, 0, 2, 48, 0, 1, 224, 0, 20, 33, 99, 23, 2, 0, 3, 0,
  0, 7, 128, 0, 3, 128, 0, 1, 192, 0, 0, 224, 0, 0, 32, 0,
  0, 0, 0, 0, 0, 0, 255, 255, 224, 31, 1, 224, 31, 0, 224, 31,
  0, 224, 31, 0, 96, 31, 0, 96, 31, 0, 32, 31, 4, 32, 31, 4,
  0, 31, 12, 0, 31, 12, 0, 31, 28, 0, 31, 252, 0, 31, 28, 0,
  31, 12, 0, 31, 12, 48, 31, 4, 48, 31, 4, 48, 31, 0, 48, 31,
  0, 112, 31, 0, 112, 31, 0, 240, 31, 1, 240, 31, 3, 240, 255, 255,
  240, 20, 33, 99, 23, 2, 0, 0, 6, 0, 0, 14, 0, 0, 30, 0,
  0, 28, 0, 0, 48, 0, 0, 96, 0, 0, 0, 0, 0, 0, 0, 255,
  255, 224, 31, 1, 224, 31, 0, 224, 31, 0, 224, 31, 0, 96, 31, 0,
  96, 31, 0, 32, 31, 4, 32, 31, 4, 0, 31, 12, 0, 31, 12, 0,
  31, 28, 0, 31, 252, 0, 31, 28, 0, 31, 12, 0, 31, 12, 48, 31,
  4, 48, 31, 4, 48, 31, 0, 48, 31, 0, 112, 31, 0, 112, 31, 0,
  240, 31, 0, 240, 31, 3, 240, 255, 255, 240, 20, 33, 99, 23, 2, 0,
  0, 32, 0, 0, 96, 0, 0, 240, 0, 1, 248, 0, 3, 140, 0, 6,
  3, 0, 0, 0, 0, 0, 0, 0, 255, 255, 224, 31, 1, 224, 31, 0,
  224, 31, 0, 224, 31, 0, 96, 31, 0, 96, 31, 0, 32, 31, 4, 32,
  31, 4, 0, 31, 12, 0, 31, 12, 0, 31, 28, 0, 31, 252, 0, 31,
  28, 0, 31, 12, 0, 31, 12, 48, 31, 4, 48, 31, 4, 48, 31, 0,
  48, 31, 0, 112, 31, 0, 112, 31, 0, 240, 31, 1, 240, 31, 3, 240,
  255, 255, 240, 20, 32, 96, 23, 2, 0, 7, 14, 0, 7, 143, 0, 7,
  143, 0, 7, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255,
  224, 31, 1, 224, 31, 0, 224, 31, 0, 224, 31, 0, 96, 31, 0, 96,
  31, 0, 32, 31, 4, 32, 31, 4, 0, 31, 12, 0, 31, 12, 0, 31,
  28, 0, 31, 252, 0, 31, 28, 0, 31, 12, 0, 31, 12, 48, 31, 4,
  48, 31, 4, 48, 31, 0, 48, 31, 0, 112, 31, 0, 112, 31, 0, 240,
  31, 0, 240, 31, 3, 240, 255, 255, 240, 11, 33, 66, 14, 2, 0, 96,
  0, 112, 0, 120, 0, 56, 0, 28, 0, 4, 0, 0, 0, 0, 0, 255,
  224, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 255,
  224, 11, 33, 66, 14, 2, 0, 0, 192, 1, 192, 3, 192, 3, 128, 7,
  0, 4, 0, 0, 0, 0, 0, 255, 224, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 255, 224, 11, 33, 66, 14, 2, 0, 4,
  0, 14, 0, 14, 0, 31, 0, 113, 128, 192, 96, 0, 0, 0, 0, 255,
  224, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 255,
  224, 11, 32, 64, 15, 2, 0, 112, 224, 241, 224, 241, 224, 112, 224, 0,
  0, 0, 0, 0, 0, 255, 224, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 255, 224, 23, 25, 75, 27, 2, 0, 255, 255, 0,
  31, 3, 192, 31, 0, 224, 31, 0, 240, 31, 0, 120, 31, 0, 120, 31,
  0, 124, 31, 0, 124, 31, 0, 126, 31, 0, 126, 31, 0, 126, 255, 224,
  126, 31, 0, 126, 31, 0, 126, 31, 0, 126, 31, 0, 126, 31, 0, 124,
  31, 0, 124, 31, 0, 124, 31, 0, 120, 31, 0, 120, 31, 0, 240, 31,
  0, 224, 31, 3, 192, 255, 255, 0, 24, 32, 96, 27, 2, 0, 0, 112,
  64, 0, 252, 192, 0, 159, 128, 0, 135, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 255, 3, 255, 31, 128, 124, 31, 128, 56, 15, 192, 16, 7,
  224, 16, 7, 240, 16, 7, 240, 16, 5, 248, 16, 5, 252, 16, 4, 252,
  16, 4, 126, 16, 4, 127, 16, 4, 63, 16, 4, 31, 144, 4, 31, 208,
  4, 15, 208, 4, 7, 240, 4, 7, 240, 4, 3, 240, 4, 1, 240, 4,
  1, 240, 4, 0, 240, 14, 0, 112, 31, 0, 48, 255, 192, 48, 20, 33,
  99, 24, 2, 1, 7, 0, 0, 7, 128, 0, 3, 128, 0, 1, 192, 0,
  0, 192, 0, 0, 96, 0, 0, 0, 0, 0, 0, 0, 3, 252, 0, 6,
  6, 0, 14, 7, 0, 28, 3, 128, 60, 3, 192, 60, 3, 192, 124, 3,
  224, 124, 3, 224, 124, 3, 224, 252, 3, 240, 252, 3, 240, 252, 3, 240,
  252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 124, 3, 224, 124,
  3, 224, 124, 3, 224, 60, 3, 192, 60, 3, 192, 28, 3, 128, 14, 7,
  0, 6, 6, 0, 3, 252, 0, 20, 33, 99, 24, 2, 1, 0, 14, 0,
  0, 30, 0, 0, 28, 0, 0, 56, 0, 0, 48, 0, 0, 96, 0, 0,
  0, 0, 0, 0, 0, 3, 252, 0, 6, 6, 0, 14, 7, 0, 28, 3,
  128, 60, 3, 192, 60, 3, 192, 124, 3, 224, 124, 3, 224, 124, 3, 224,
  252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252,
  3, 240, 252, 3, 240, 124, 3, 224, 124, 3, 224, 124, 3, 224, 60, 3,
  192, 60, 3, 192, 28, 3, 128, 14, 7, 0, 6, 6, 0, 3, 252, 0,
  20, 33, 99, 24, 2, 0, 0, 96, 0, 0, 96, 0, 0, 240, 0, 1,
  248, 0, 3, 156, 0, 6, 6, 0, 0, 0, 0, 0, 0, 0, 3, 252,
  0, 6, 6, 0, 14, 7, 0, 28, 3, 128, 60, 3, 192, 60, 3, 192,
  124, 3, 224, 124, 3, 224, 124, 3, 224, 252, 3, 240, 252, 3, 240, 252,
  3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 124, 3,
  224, 124, 3, 224, 124, 3, 224, 60, 3, 192, 60, 3, 192, 28, 3, 128,
  14, 7, 0, 6, 6, 0, 3, 252, 0, 20, 32, 96, 24, 2, 0, 1,
  194, 0, 3, 230, 0, 6, 124, 0, 4, 56, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 3, 252, 0, 6, 6, 0, 14, 7, 0, 28, 3, 128,
  60, 3, 192, 60, 3, 192, 124, 3, 224, 124, 3, 224, 124, 3, 224, 252,
  3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3,
  240, 252, 3, 240, 124, 3, 224, 124, 3, 224, 124, 3, 224, 60, 3, 192,
  60, 3, 192, 28, 3, 128, 14, 7, 0, 6, 6, 0, 3, 252, 0, 20,
  32, 96, 24, 2, 0, 7, 14, 0, 7, 143, 0, 7, 143, 0, 7, 14,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 252, 0, 6, 6, 0,
  14, 7, 0, 28, 3, 128, 60, 3, 192, 60, 3, 192, 124, 3, 224, 124,
  3, 224, 124, 3, 224, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3,
  240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 124, 3, 224, 124, 3, 224,
  124, 3, 224, 60, 3, 192, 60, 3, 192, 28, 3, 128, 14, 7, 0, 6,
  6, 0, 3, 252, 0, 22, 23, 69, 32, 5, 254, 64, 0, 8, 224, 0,
  28, 240, 0, 60, 120, 0, 120, 56, 0, 240, 28, 0, 224, 14, 1, 192,
  7, 3, 128, 3, 135, 0, 1, 206, 0, 0, 252, 0, 0, 120, 0, 0,
  120, 0, 0, 252, 0, 1, 206, 0, 3, 135, 0, 7, 3, 128, 14, 1,
  192, 28, 0, 224, 56, 0, 112, 112, 0, 56, 224, 0, 28, 64, 0, 8,
  20, 25, 75, 24, 2, 1, 3, 252, 48, 6, 6, 96, 14, 3, 192, 28,
  3, 128, 60, 3, 192, 60, 3, 192, 124, 3, 224, 124, 7, 224, 124, 15,
  224, 252, 11, 240, 252, 19, 240, 252, 35, 240, 252, 99, 240, 252, 67, 240,
  252, 131, 240, 253, 3, 240, 127, 3, 224, 126, 3, 224, 124, 3, 224, 60,
  3, 192, 60, 3, 192, 28, 3, 128, 60, 7, 0, 102, 6, 0, 195, 252,
  0, 23, 33, 99, 26, 2, 1, 1, 192, 0, 1, 224, 0, 0, 224, 0,
  0, 112, 0, 0, 56, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 255,
  225, 254, 31, 0, 120, 31, 0, 48, 31, 0, 16, 31, 0, 16, 31, 0,
  16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16,
  31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31,
  0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 15, 0, 32, 15, 0,
  32, 7, 128, 64, 3, 192, 192, 1, 255, 0, 23, 33, 99, 26, 2, 1,
  0, 3, 128, 0, 3, 128, 0, 7, 128, 0, 14, 0, 0, 12, 0, 0,
  24, 0, 0, 0, 0, 0, 0, 0, 255, 225, 254, 31, 0, 120, 31, 0,
  48, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16,
  31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31,
  0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0,
  16, 31, 0, 16, 15, 0, 32, 15, 0, 32, 7, 128, 64, 3, 192, 192,
  1, 255, 0, 23, 33, 99, 26, 2, 0, 0, 8, 0, 0, 24, 0, 0,
  60, 0, 0, 126, 0, 0, 227, 0, 1, 128, 192, 0, 0, 0, 0, 0,
  0, 255, 225, 254, 31, 0, 120, 31, 0, 48, 31, 0, 16, 31, 0, 16,
  31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31,
  0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0,
  16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 15, 0, 48,
  15, 128, 32, 7, 128, 64, 3, 192, 192, 1, 255, 0, 23, 32, 96, 26,
  2, 0, 1, 195, 128, 1, 227, 192, 1, 227, 192, 1, 195, 128, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 255, 225, 254, 31, 0, 120, 31, 0, 48,
  31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31,
  0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0,
  16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16,
  31, 0, 16, 15, 0, 32, 15, 0, 32, 7, 128, 64, 3, 192, 192, 1,
  255, 0, 23, 33, 99, 26, 2, 0, 0, 1, 128, 0, 3, 128, 0, 7,
  128, 0, 7, 0, 0, 12, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0,
  255, 225, 254, 31, 128, 112, 31, 128, 96, 15, 128, 96, 15, 192, 64, 7,
  192, 192, 7, 224, 192, 7, 224, 128, 3, 225, 128, 3, 241, 0, 1, 241,
  0, 1, 251, 0, 0, 250, 0, 0, 254, 0, 0, 252, 0, 0, 124, 0,
  0, 124, 0, 0, 124, 0, 0, 124, 0, 0, 124, 0, 0, 124, 0, 0,
  124, 0, 0, 124, 0, 0, 124, 0, 3, 255, 128, 20, 25, 75, 24, 2,
  0, 255, 240, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0,
  31, 254, 0, 31, 7, 128, 31, 3, 192, 31, 1, 224, 31, 1, 240, 31,
  1, 240, 31, 1, 240, 31, 1, 240, 31, 1, 240, 31, 1, 224, 31, 3,
  192, 31, 7, 128, 31, 254, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0,
  31, 0, 0, 31, 0, 0, 31, 0, 0, 255, 240, 0, 16, 25, 50, 19,
  1, 0, 3, 224, 6, 120, 14, 60, 30, 60, 28, 60, 60, 60, 60, 60,
  60, 56, 60, 112, 61, 192, 60, 48, 60, 28, 60, 30, 60, 30, 60, 15,
  60, 15, 60, 15, 60, 15, 60, 15, 60, 15, 61, 207, 63, 222, 63, 158,
  61, 156, 252, 248, 15, 25, 50, 18, 2, 0, 48, 0, 56, 0, 60, 0,
  28, 0, 14, 0, 2, 0, 0, 0, 0, 0, 15, 128, 49, 224, 96, 240,
  112, 240, 120, 240, 120, 240, 48, 240, 3, 240, 28, 240, 56, 240, 120, 240,
  240, 240, 240, 242, 240, 242, 240, 242, 121, 252, 62, 120, 15, 25, 50, 18,
  2, 0, 0, 224, 0, 224, 1, 224, 1, 192, 3, 0, 6, 0, 4, 0,
  0, 0, 15, 128, 49, 224, 96, 240, 112, 240, 120, 240, 120, 240, 32, 240,
  7, 240, 28, 240, 56, 240, 120, 240, 240, 240, 240, 242, 240, 242, 240, 242,
  121, 252, 62, 120, 15, 25, 50, 18, 2, 0, 7, 0, 7, 0, 15, 0,
  13, 128, 24, 192, 112, 96, 0, 0, 0, 0, 15, 128, 49, 224, 96, 240,
  112, 240, 120, 240, 120, 240, 32, 240, 7, 240, 28, 240, 56, 240, 120, 240,
  240, 240, 240, 242, 240, 242, 240, 242, 121, 252, 62, 120, 15, 24, 48, 18,
  2, 0, 28, 32, 63, 32, 103, 224, 65, 192, 0, 0, 0, 0, 0, 0,
  15, 128, 49, 224, 96, 240, 112, 240, 120, 240, 120, 240, 48, 240, 7, 240,
  28, 240, 56, 240, 120, 240, 240, 240, 240, 242, 240, 242, 240, 242, 121, 252,
  62, 120, 15, 24, 48, 18, 2, 0, 112, 224, 120, 240, 120, 240, 112, 224,
  0, 0, 0, 0, 0, 0, 15, 128, 49, 224, 96, 240, 112, 240, 120, 240,
  120, 240, 32, 240, 7, 240, 28, 240, 56, 240, 120, 240, 240, 240, 240, 242,
  240, 242, 240, 242, 121, 252, 62, 120, 15, 25, 50, 18, 2, 1, 15, 128,
  25, 192, 16, 192, 16, 192, 24, 192, 15, 128, 7, 0, 0, 0, 15, 128,
  49, 224, 96, 240, 112, 240, 120, 240, 120, 240, 32, 240, 7, 240, 24, 240,
  56, 240, 112, 240, 240, 240, 240, 242, 240, 242, 240, 242, 121, 252, 62, 120,
  21, 17, 51, 25, 2, 0, 31, 143, 128, 49, 248, 224, 96, 248, 240, 112,
  248, 112, 120, 248, 120, 120, 240, 120, 48, 240, 120, 3, 240, 120, 28, 255,
  248, 56, 240, 0, 120, 240, 0, 240, 240, 8, 240, 248, 8, 240, 248, 8,
  240, 248, 16, 121, 188, 48, 62, 15, 192, 13, 24, 48, 16, 2, 249, 7,
  128, 28, 96, 56, 32, 120, 112, 120, 240, 248, 240, 240, 224, 240, 64, 240,
  0, 240, 0, 240, 0, 240, 8, 120, 16, 120, 16, 56, 16, 28, 32, 15,
  192, 2, 0, 4, 0, 3, 128, 1, 192, 1, 192, 17, 192, 15, 128, 13,
  25, 50, 17, 2, 0, 48, 0, 56, 0, 60, 0, 28, 0, 6, 0, 3,
  0, 0, 0, 0, 0, 7, 128, 24, 224, 56, 240, 120, 240, 120, 240, 240,
  120, 240, 120, 240, 120, 255, 248, 240, 0, 240, 0, 240, 8, 120, 8, 120,
  24, 56, 16, 28, 32, 7, 192, 13, 25, 50, 17, 2, 0, 0, 96, 0,
  224, 1, 224, 1, 192, 3, 128, 6, 0, 0, 0, 0, 0, 7, 128, 24,
  224, 56, 240, 120, 240, 120, 240, 240, 120, 240, 120, 240, 120, 255, 248, 240,
  0, 240, 0, 240, 8, 120, 8, 120, 24, 56, 16, 28, 32, 7, 192, 13,
  25, 50, 17, 2, 0, 7, 0, 7, 0, 15, 128, 13, 128, 24, 192, 48,
  112, 0, 0, 0, 0, 7, 128, 24, 224, 56, 240, 120, 240, 120, 240, 240,
  120, 240, 120, 240, 120, 255, 248, 240, 0, 240, 0, 240, 8, 120, 8, 120,
  24, 56, 16, 28, 32, 7, 192, 13, 24, 48, 17, 2, 0, 56, 224, 120,
  240, 120, 240, 56, 224, 0, 0, 0, 0, 0, 0, 7, 128, 24, 224, 56,
  240, 120, 240, 120, 240, 240, 120, 240, 120, 240, 120, 255, 248, 240, 0, 240,
  0, 240, 8, 120, 8, 120, 24, 56, 16, 28, 32, 7, 192, 8, 25, 25,
  10, 1, 0, 192, 224, 240, 112, 24, 12, 0, 0, 252, 60, 60, 60, 60,
  60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 255, 8, 25, 25, 10,
  1, 0, 3, 7, 7, 14, 28, 16, 0, 0, 252, 60, 60, 60, 60, 60,
  60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 255, 10, 25, 50, 10, 0,
  0, 28, 0, 30, 0, 30, 0, 55, 0, 97, 128, 192, 192, 0, 0, 0,
  0, 126, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 127, 128, 10, 24, 48, 11, 1, 0, 115, 128, 243, 192, 243, 192, 115,
  128, 0, 0, 0, 0, 0, 0, 126, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 127, 128, 14, 25, 50, 18, 2, 0, 30,
  48, 15, 96, 15, 128, 7, 128, 15, 192, 49, 224, 1, 224, 0, 240, 15,
  248, 28, 248, 56, 120, 120, 120, 120, 124, 240, 124, 240, 60, 240, 60, 240,
  60, 240, 60, 240, 60, 240, 124, 120, 120, 120, 120, 56, 112, 28, 224, 7,
  192, 17, 23, 69, 19, 1, 1, 7, 136, 0, 15, 248, 0, 16, 240, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 252, 120, 0, 61, 188, 0, 61,
  28, 0, 62, 30, 0, 62, 30, 0, 62, 30, 0, 60, 30, 0, 60, 30,
  0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0,
  60, 30, 0, 60, 30, 0, 60, 30, 0, 255, 127, 128, 14, 25, 50, 18,
  2, 0, 24, 0, 60, 0, 28, 0, 14, 0, 7, 0, 3, 0, 0, 0,
  0, 0, 7, 128, 28, 224, 56, 112, 120, 120, 120, 120, 240, 60, 240, 60,
  240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 120, 120, 120, 120, 56, 112,
  24, 224, 7, 128, 14, 25, 50, 18, 2, 0, 0, 96, 0, 240, 0, 224,
  1, 192, 3, 128, 3, 0, 0, 0, 0, 0, 7, 128, 28, 224, 56, 112,
  120, 120, 120, 120, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60,
  240, 60, 120, 120, 120, 120, 56, 112, 24, 224, 7, 128, 14, 25, 50, 18,
  2, 0, 3, 0, 7, 128, 7, 128, 15, 192, 28, 224, 48, 48, 32, 16,
  0, 0, 7, 128, 28, 224, 56, 112, 120, 120, 120, 120, 240, 60, 240, 60,
  240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 120, 120, 120, 120, 56, 112,
  24, 224, 7, 128, 14, 24, 48, 18, 2, 0, 14, 16, 31, 144, 39, 224,
  33, 224, 0, 0, 0, 0, 0, 0, 7, 128, 28, 224, 56, 112, 120, 120,
  120, 120, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60,
  120, 120, 120, 120, 56, 112, 24, 224, 7, 128, 14, 24, 48, 18, 2, 0,
  56, 112, 60, 240, 60, 240, 56, 112, 0, 0, 0, 0, 0, 0, 7, 128,
  28, 224, 56, 112, 120, 120, 120, 120, 240, 60, 240, 60, 240, 60, 240, 60,
  240, 60, 240, 60, 240, 60, 120, 120, 120, 120, 56, 112, 24, 224, 7, 128,
  29, 23, 92, 31, 1, 254, 0, 7, 0, 0, 0, 15, 128, 0, 0, 15,
  128, 0, 0, 15, 128, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255,
  255, 248, 255, 255, 255, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7,
  0, 0, 0, 15, 128, 0, 0, 15, 128, 0, 0, 15, 128, 0, 0, 7,
  0, 0, 14, 17, 34, 18, 2, 0, 7, 132, 24, 232, 56, 120, 120, 120,
  120, 120, 240, 124, 240, 188, 241, 188, 243, 60, 246, 60, 244, 60, 248, 60,
  120, 120, 120, 120, 120, 112, 92, 96, 135, 128, 17, 25, 75, 19, 1, 0,
  12, 0, 0, 30, 0, 0, 14, 0, 0, 7, 0, 0, 3, 0, 0, 0,
  128, 0, 0, 0, 0, 0, 0, 0, 252, 126, 0, 60, 30, 0, 60, 30,
  0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0,
  60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 62, 0, 60, 62, 0, 60,
  62, 0, 60, 94, 0, 30, 158, 0, 15, 31, 128, 17, 25, 75, 19, 1,
  0, 0, 48, 0, 0, 112, 0, 0, 112, 0, 0, 224, 0, 1, 192, 0,
  1, 0, 0, 0, 0, 0, 0, 0, 0, 252, 126, 0, 60, 30, 0, 60,
  30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30,
  0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 62, 0, 60, 62, 0,
  60, 62, 0, 60, 94, 0, 30, 158, 0, 15, 31, 128, 17, 25, 75, 19,
  1, 0, 1, 128, 0, 3, 192, 0, 3, 192, 0, 7, 224, 0, 12, 48,
  0, 24, 24, 0, 0, 0, 0, 0, 0, 0, 252, 126, 0, 60, 30, 0,
  60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60,
  30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 62, 0, 60, 62,
  0, 60, 62, 0, 60, 94, 0, 30, 158, 0, 15, 31, 128, 17, 24, 72,
  19, 1, 0, 28, 112, 0, 30, 120, 0, 30, 120, 0, 28, 112, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 252, 126, 0, 60, 30, 0, 60, 30,
  0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0,
  60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 62, 0, 60, 62, 0, 60,
  62, 0, 60, 94, 0, 30, 158, 0, 15, 31, 128, 17, 33, 99, 18, 0,
  248, 0, 28, 0, 0, 28, 0, 0, 60, 0, 0, 112, 0, 0, 96, 0,
  0, 192, 0, 0, 0, 0, 0, 0, 0, 255, 159, 128, 62, 6, 0, 30,
  4, 0, 31, 4, 0, 15, 4, 0, 15, 8, 0, 15, 136, 0, 7, 136,
  0, 7, 152, 0, 3, 208, 0, 3, 208, 0, 3, 240, 0, 1, 224, 0,
  1, 224, 0, 0, 224, 0, 0, 192, 0, 0, 64, 0, 0, 64, 0, 0,
  64, 0, 28, 128, 0, 60, 128, 0, 60, 128, 0, 57, 0, 0, 59, 0,
  0, 30, 0, 0, 15, 32, 64, 18, 1, 247, 12, 0, 28, 0, 124, 0,
  188, 0, 60, 0, 60, 0, 60, 0, 60, 120, 60, 252, 61, 30, 63, 30,
  62, 30, 62, 30, 62, 30, 60, 30, 60, 28, 60, 28, 60, 56, 60, 56,
  60, 48, 60, 96, 60, 192, 61, 0, 62, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 48, 0, 192, 0, 17, 32, 96, 18, 0, 248,
  14, 28, 0, 15, 60, 0, 15, 60, 0, 14, 28, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 255, 159, 128, 62, 6, 0, 30, 4, 0, 30, 4,
  0, 15, 8, 0, 15, 8, 0, 15, 8, 0, 7, 136, 0, 7, 144, 0,
  3, 208, 0, 3, 208, 0, 3, 224, 0, 1, 224, 0, 1, 224, 0, 0,
  224, 0, 0, 192, 0, 0, 192, 0, 0, 64, 0, 0, 128, 0, 28, 128,
  0, 60, 128, 0, 61, 0, 0, 57, 0, 0, 59, 0, 0, 30, 0, 0
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--34-340-72-72-P-184-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 0, '1' Height: 25
  Calculated Max Values w=29 h=33 x= 4 y=11 dx=31 dy= 0 ascent=26 len=120
  Font Bounding box     w=95 h=44 x=-29 y=-10
  Calculated Min Values           x= 0 y=-7 dx= 0 dy= 0
  Pure Font   ascent =25 descent= 0
  X Font      ascent =25 descent= 0
  Max Font    ascent =26 descent=-7
*/
const u8g_fntpgm_uint8_t u8g_font_osb26n[903] U8G_FONT_SECTION("u8g_font_osb26n") = {
  0, 95, 44, 227, 246, 25, 0, 0, 0, 0, 42, 58, 0, 26, 249, 25,
  0, 12, 14, 28, 17, 3, 11, 14, 0, 14, 0, 14, 0, 196, 112, 228,
  240, 245, 224, 14, 0, 14, 0, 245, 224, 228, 240, 196, 112, 14, 0, 14,
  0, 14, 0, 29, 30, 120, 31, 1, 251, 0, 3, 0, 0, 0, 3, 0,
  0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0,
  0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0,
  0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0,
  0, 255, 255, 255, 248, 255, 255, 255, 248, 0, 3, 0, 0, 0, 3, 0,
  0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0,
  0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0,
  0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0,
  0, 7, 11, 11, 10, 2, 249, 120, 252, 254, 254, 126, 6, 4, 12, 8,
  48, 224, 9, 4, 8, 13, 2, 7, 255, 128, 255, 128, 255, 128, 255, 128,
  5, 5, 5, 9, 2, 0, 112, 248, 248, 248, 112, 12, 33, 66, 15, 2,
  249, 0, 112, 0, 96, 0, 96, 0, 224, 0, 192, 0, 192, 1, 192, 1,
  192, 1, 128, 1, 128, 3, 128, 3, 0, 3, 0, 7, 0, 6, 0, 6,
  0, 6, 0, 14, 0, 12, 0, 12, 0, 28, 0, 24, 0, 24, 0, 56,
  0, 56, 0, 48, 0, 48, 0, 112, 0, 96, 0, 96, 0, 224, 0, 192,
  0, 192, 0, 16, 25, 50, 20, 2, 1, 7, 224, 14, 112, 28, 56, 60,
  60, 60, 60, 124, 62, 124, 62, 124, 62, 252, 63, 252, 63, 252, 63, 252,
  63, 252, 63, 252, 63, 252, 63, 252, 63, 252, 63, 124, 62, 124, 62, 124,
  62, 60, 60, 60, 60, 28, 56, 14, 112, 7, 224, 12, 25, 50, 20, 4,
  0, 7, 0, 7, 0, 31, 0, 255, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 255, 240, 15, 25, 50, 20, 2, 1, 31, 240, 48, 120, 96, 60, 96,
  62, 224, 62, 240, 62, 248, 62, 252, 62, 124, 124, 56, 124, 0, 248, 1,
  240, 1, 224, 3, 128, 7, 0, 12, 2, 24, 2, 48, 2, 32, 2, 76,
  6, 127, 254, 127, 252, 71, 252, 67, 252, 65, 248, 15, 26, 52, 20, 2,
  0, 1, 0, 14, 240, 56, 120, 48, 60, 112, 62, 120, 62, 124, 62, 124,
  62, 60, 62, 24, 60, 0, 120, 0, 112, 31, 192, 0, 240, 0, 120, 0,
  60, 0, 60, 56, 62, 124, 62, 252, 62, 252, 62, 248, 62, 224, 60, 96,
  124, 96, 120, 31, 224, 16, 25, 50, 20, 2, 0, 0, 120, 0, 120, 0,
  248, 1, 248, 1, 248, 3, 248, 3, 248, 6, 248, 6, 248, 12, 248, 12,
  248, 24, 248, 56, 248, 48, 248, 96, 248, 96, 248, 192, 248, 255, 255, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 15, 255, 15, 26, 52,
  20, 3, 0, 0, 8, 48, 56, 63, 240, 63, 224, 63, 128, 62, 0, 32,
  0, 32, 0, 32, 0, 32, 0, 39, 192, 56, 112, 48, 120, 32, 60, 32,
  60, 0, 62, 0, 62, 56, 62, 120, 62, 252, 62, 248, 62, 248, 60, 224,
  60, 96, 120, 112, 112, 31, 224, 16, 25, 50, 20, 2, 1, 7, 240, 12,
  8, 28, 12, 56, 60, 56, 124, 120, 124, 120, 120, 120, 48, 248, 0, 248,
  0, 251, 224, 252, 56, 252, 60, 248, 30, 248, 31, 248, 31, 248, 31, 248,
  31, 120, 31, 120, 31, 120, 31, 56, 30, 28, 30, 12, 60, 7, 240, 15,
  25, 50, 20, 3, 0, 79, 28, 95, 156, 127, 198, 127, 230, 127, 254, 224,
  246, 192, 4, 192, 12, 128, 12, 128, 24, 0, 16, 0, 48, 0, 96, 0,
  224, 1, 192, 1, 192, 3, 192, 7, 128, 7, 128, 15, 128, 15, 128, 15,
  128, 15, 128, 15, 128, 7, 0, 17, 25, 75, 20, 2, 1, 7, 240, 0,
  24, 12, 0, 48, 12, 0, 48, 6, 0, 112, 6, 0, 112, 6, 0, 120,
  6, 0, 124, 4, 0, 127, 12, 0, 127, 152, 0, 63, 224, 0, 31, 248,
  0, 15, 252, 0, 15, 254, 0, 49, 255, 0, 96, 127, 0, 64, 31, 0,
  192, 15, 128, 192, 7, 0, 192, 7, 0, 192, 3, 0, 96, 6, 0, 96,
  6, 0, 56, 12, 0, 14, 240, 0, 15, 25, 50, 20, 2, 1, 31, 192,
  60, 112, 120, 48, 120, 56, 248, 60, 248, 60, 248, 60, 248, 62, 248, 62,
  248, 62, 248, 62, 120, 62, 124, 126, 60, 126, 15, 190, 0, 62, 0, 62,
  12, 60, 30, 60, 62, 60, 62, 56, 60, 56, 48, 112, 16, 96, 15, 192,
  5, 17, 17, 9, 2, 0, 112, 248, 248, 248, 112, 0, 0, 0, 0, 0,
  0, 0, 112, 248, 248, 248, 112
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--34-340-72-72-P-184-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 26, '1' Height: 25
  Calculated Max Values w=34 h=33 x= 4 y=18 dx=36 dy= 0 ascent=28 len=125
  Font Bounding box     w=95 h=44 x=-29 y=-10
  Calculated Min Values           x=-2 y=-8 dx= 0 dy= 0
  Pure Font   ascent =26 descent=-8
  X Font      ascent =26 descent=-8
  Max Font    ascent =28 descent=-8
*/
const u8g_fntpgm_uint8_t u8g_font_osb26r[5950] U8G_FONT_SECTION("u8g_font_osb26r") = {
  0, 95, 44, 227, 246, 26, 7, 105, 16, 163, 32, 127, 248, 28, 248, 26,
  248, 0, 0, 0, 10, 0, 0, 6, 25, 25, 10, 2, 1, 120, 252, 252,
  252, 252, 252, 120, 120, 120, 120, 48, 48, 48, 48, 48, 48, 48, 0, 0,
  0, 120, 252, 252, 252, 120, 8, 8, 8, 12, 2, 18, 231, 231, 231, 231,
  231, 231, 66, 66, 20, 25, 75, 24, 2, 0, 3, 131, 0, 3, 131, 0,
  3, 3, 0, 3, 3, 0, 3, 3, 0, 3, 7, 0, 3, 7, 0, 255,
  255, 240, 255, 255, 240, 6, 6, 0, 6, 6, 0, 6, 6, 0, 6, 14,
  0, 6, 14, 0, 14, 12, 0, 12, 12, 0, 12, 12, 0, 255, 255, 224,
  255, 255, 224, 12, 28, 0, 12, 24, 0, 28, 24, 0, 24, 24, 0, 24,
  24, 0, 24, 24, 0, 16, 31, 62, 20, 2, 253, 2, 32, 2, 32, 2,
  32, 15, 248, 26, 38, 50, 34, 114, 35, 114, 35, 114, 47, 122, 47, 126,
  46, 126, 46, 63, 160, 63, 224, 31, 240, 15, 248, 7, 252, 3, 254, 2,
  126, 114, 63, 250, 47, 250, 47, 242, 39, 226, 39, 194, 38, 98, 38, 50,
  44, 30, 56, 3, 224, 2, 32, 2, 32, 23, 26, 78, 29, 3, 0, 8,
  0, 48, 54, 0, 32, 99, 0, 96, 99, 0, 192, 227, 128, 192, 227, 129,
  128, 227, 129, 0, 227, 131, 0, 227, 130, 0, 227, 134, 0, 99, 12, 0,
  54, 8, 0, 28, 24, 0, 0, 16, 112, 0, 48, 216, 0, 97, 140, 0,
  97, 140, 0, 195, 142, 0, 131, 142, 1, 131, 142, 1, 3, 142, 3, 3,
  142, 6, 3, 142, 4, 1, 140, 12, 1, 140, 8, 0, 248, 24, 25, 75,
  26, 1, 1, 1, 252, 0, 3, 4, 0, 3, 2, 0, 7, 2, 0, 7,
  2, 0, 7, 6, 0, 7, 132, 0, 7, 200, 0, 3, 240, 0, 3, 224,
  0, 1, 240, 0, 3, 240, 127, 6, 248, 28, 12, 124, 8, 24, 60, 24,
  56, 62, 16, 112, 31, 16, 240, 15, 32, 240, 15, 224, 248, 7, 192, 248,
  3, 192, 252, 3, 225, 126, 7, 242, 127, 253, 254, 31, 240, 124, 3, 8,
  8, 7, 2, 18, 224, 224, 224, 224, 224, 224, 64, 64, 10, 31, 62, 12,
  2, 250, 0, 192, 1, 0, 2, 0, 6, 0, 12, 0, 24, 0, 56, 0,
  56, 0, 120, 0, 112, 0, 112, 0, 240, 0, 240, 0, 240, 0, 240, 0,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 112, 0, 112, 0, 112, 0,
  56, 0, 56, 0, 24, 0, 28, 0, 12, 0, 6, 0, 3, 0, 1, 128,
  9, 32, 64, 12, 1, 250, 192, 0, 96, 0, 48, 0, 24, 0, 28, 0,
  12, 0, 14, 0, 6, 0, 7, 0, 7, 0, 7, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128,
  7, 0, 7, 0, 7, 0, 14, 0, 14, 0, 12, 0, 24, 0, 48, 0,
  96, 0, 192, 0, 128, 0, 12, 14, 28, 17, 3, 11, 14, 0, 14, 0,
  14, 0, 196, 112, 228, 240, 245, 224, 14, 0, 14, 0, 245, 224, 228, 240,
  196, 112, 14, 0, 14, 0, 14, 0, 29, 30, 120, 31, 1, 251, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 255, 255, 255, 248, 255, 255, 255, 248, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 7, 11, 11, 10, 2, 249, 120, 252, 254, 254,
  126, 6, 4, 12, 8, 48, 224, 9, 4, 8, 13, 2, 7, 255, 128, 255,
  128, 255, 128, 255, 128, 5, 5, 5, 9, 2, 0, 112, 248, 248, 248, 112,
  12, 33, 66, 15, 2, 249, 0, 112, 0, 96, 0, 96, 0, 224, 0, 192,
  0, 192, 1, 192, 1, 192, 1, 128, 1, 128, 3, 128, 3, 0, 3, 0,
  7, 0, 6, 0, 6, 0, 6, 0, 14, 0, 12, 0, 12, 0, 28, 0,
  24, 0, 24, 0, 56, 0, 56, 0, 48, 0, 48, 0, 112, 0, 96, 0,
  96, 0, 224, 0, 192, 0, 192, 0, 16, 25, 50, 20, 2, 1, 7, 224,
  14, 112, 28, 56, 60, 60, 60, 60, 124, 62, 124, 62, 124, 62, 252, 63,
  252, 63, 252, 63, 252, 63, 252, 63, 252, 63, 252, 63, 252, 63, 252, 63,
  124, 62, 124, 62, 124, 62, 60, 60, 60, 60, 28, 56, 14, 112, 7, 224,
  12, 25, 50, 20, 4, 0, 7, 0, 7, 0, 31, 0, 255, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 255, 240, 15, 25, 50, 20, 2, 1, 31, 240,
  48, 120, 96, 60, 96, 62, 224, 62, 240, 62, 248, 62, 252, 62, 124, 124,
  56, 124, 0, 248, 1, 240, 1, 224, 3, 128, 7, 0, 12, 2, 24, 2,
  48, 2, 32, 2, 76, 6, 127, 254, 127, 252, 71, 252, 67, 252, 65, 248,
  15, 26, 52, 20, 2, 0, 1, 0, 14, 240, 56, 120, 48, 60, 112, 62,
  120, 62, 124, 62, 124, 62, 60, 62, 24, 60, 0, 120, 0, 112, 31, 192,
  0, 240, 0, 120, 0, 60, 0, 60, 56, 62, 124, 62, 252, 62, 252, 62,
  248, 62, 224, 60, 96, 124, 96, 120, 31, 224, 16, 25, 50, 20, 2, 0,
  0, 120, 0, 120, 0, 248, 1, 248, 1, 248, 3, 248, 3, 248, 6, 248,
  6, 248, 12, 248, 12, 248, 24, 248, 56, 248, 48, 248, 96, 248, 96, 248,
  192, 248, 255, 255, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  15, 255, 15, 26, 52, 20, 3, 0, 0, 8, 48, 56, 63, 240, 63, 224,
  63, 128, 62, 0, 32, 0, 32, 0, 32, 0, 32, 0, 39, 192, 56, 112,
  48, 120, 32, 60, 32, 60, 0, 62, 0, 62, 56, 62, 120, 62, 252, 62,
  248, 62, 248, 60, 224, 60, 96, 120, 112, 112, 31, 224, 16, 25, 50, 20,
  2, 1, 7, 240, 12, 8, 28, 12, 56, 60, 56, 124, 120, 124, 120, 120,
  120, 48, 248, 0, 248, 0, 251, 224, 252, 56, 252, 60, 248, 30, 248, 31,
  248, 31, 248, 31, 248, 31, 120, 31, 120, 31, 120, 31, 56, 30, 28, 30,
  12, 60, 7, 240, 15, 25, 50, 20, 3, 0, 79, 28, 95, 156, 127, 198,
  127, 230, 127, 254, 224, 246, 192, 4, 192, 12, 128, 12, 128, 24, 0, 16,
  0, 48, 0, 96, 0, 224, 1, 192, 1, 192, 3, 192, 7, 128, 7, 128,
  15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 7, 0, 17, 25, 75, 20,
  2, 1, 7, 240, 0, 24, 12, 0, 48, 12, 0, 48, 6, 0, 112, 6,
  0, 112, 6, 0, 120, 6, 0, 124, 4, 0, 127, 12, 0, 127, 152, 0,
  63, 224, 0, 31, 248, 0, 15, 252, 0, 15, 254, 0, 49, 255, 0, 96,
  127, 0, 64, 31, 0, 192, 15, 128, 192, 7, 0, 192, 7, 0, 192, 3,
  0, 96, 6, 0, 96, 6, 0, 56, 12, 0, 14, 240, 0, 15, 25, 50,
  20, 2, 1, 31, 192, 60, 112, 120, 48, 120, 56, 248, 60, 248, 60, 248,
  60, 248, 62, 248, 62, 248, 62, 248, 62, 120, 62, 124, 126, 60, 126, 15,
  190, 0, 62, 0, 62, 12, 60, 30, 60, 62, 60, 62, 56, 60, 56, 48,
  112, 16, 96, 15, 192, 5, 17, 17, 9, 2, 0, 112, 248, 248, 248, 112,
  0, 0, 0, 0, 0, 0, 0, 112, 248, 248, 248, 112, 6, 23, 23, 9,
  2, 249, 112, 248, 248, 248, 112, 0, 0, 0, 0, 0, 0, 0, 112, 248,
  252, 252, 252, 12, 12, 8, 16, 48, 192, 26, 29, 116, 32, 3, 251, 0,
  0, 1, 192, 0, 0, 3, 192, 0, 0, 15, 0, 0, 0, 62, 0, 0,
  0, 248, 0, 0, 1, 224, 0, 0, 7, 128, 0, 0, 31, 0, 0, 0,
  124, 0, 0, 0, 240, 0, 0, 3, 192, 0, 0, 15, 128, 0, 0, 62,
  0, 0, 0, 120, 0, 0, 0, 224, 0, 0, 0, 120, 0, 0, 0, 62,
  0, 0, 0, 15, 128, 0, 0, 3, 192, 0, 0, 0, 240, 0, 0, 0,
  124, 0, 0, 0, 31, 0, 0, 0, 7, 128, 0, 0, 1, 224, 0, 0,
  0, 248, 0, 0, 0, 62, 0, 0, 0, 15, 0, 0, 0, 3, 192, 0,
  0, 1, 192, 29, 9, 36, 33, 2, 5, 255, 255, 255, 248, 255, 255, 255,
  248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 255, 255, 255, 248, 255, 255, 255, 248, 26, 29, 116,
  32, 3, 251, 224, 0, 0, 0, 240, 0, 0, 0, 60, 0, 0, 0, 31,
  0, 0, 0, 7, 192, 0, 0, 1, 224, 0, 0, 0, 120, 0, 0, 0,
  62, 0, 0, 0, 15, 128, 0, 0, 3, 192, 0, 0, 0, 240, 0, 0,
  0, 124, 0, 0, 0, 31, 0, 0, 0, 7, 128, 0, 0, 1, 192, 0,
  0, 7, 128, 0, 0, 31, 0, 0, 0, 124, 0, 0, 0, 240, 0, 0,
  3, 192, 0, 0, 15, 128, 0, 0, 62, 0, 0, 0, 120, 0, 0, 1,
  224, 0, 0, 7, 192, 0, 0, 31, 0, 0, 0, 60, 0, 0, 0, 240,
  0, 0, 0, 224, 0, 0, 0, 11, 25, 50, 16, 2, 1, 63, 128, 67,
  192, 129, 224, 129, 224, 129, 224, 131, 224, 195, 192, 67, 192, 3, 128, 7,
  0, 6, 0, 12, 0, 8, 0, 24, 0, 17, 0, 17, 0, 17, 0, 14,
  0, 0, 0, 0, 0, 14, 0, 31, 0, 31, 0, 31, 0, 14, 0, 25,
  25, 100, 27, 1, 1, 0, 255, 192, 0, 3, 0, 48, 0, 6, 0, 24,
  0, 12, 0, 12, 0, 24, 0, 6, 0, 48, 30, 243, 0, 48, 114, 243,
  0, 96, 225, 227, 0, 97, 225, 225, 128, 227, 193, 225, 128, 195, 193, 225,
  128, 195, 193, 193, 128, 199, 131, 193, 128, 199, 131, 193, 128, 199, 131, 195,
  0, 199, 131, 195, 0, 231, 135, 130, 0, 103, 135, 134, 0, 99, 139, 204,
  0, 49, 240, 240, 0, 48, 0, 0, 0, 24, 0, 0, 0, 12, 0, 0,
  0, 7, 0, 96, 0, 1, 255, 192, 0, 23, 26, 78, 25, 1, 0, 0,
  16, 0, 0, 24, 0, 0, 56, 0, 0, 56, 0, 0, 60, 0, 0, 124,
  0, 0, 124, 0, 0, 126, 0, 0, 254, 0, 0, 254, 0, 0, 158, 0,
  1, 159, 0, 1, 159, 0, 1, 31, 0, 3, 15, 128, 3, 15, 128, 3,
  15, 128, 6, 7, 192, 7, 255, 192, 6, 7, 192, 4, 7, 224, 12, 3,
  224, 12, 3, 224, 28, 3, 240, 28, 3, 240, 255, 159, 254, 20, 25, 75,
  24, 2, 0, 255, 254, 0, 31, 7, 128, 31, 7, 192, 31, 3, 192, 31,
  3, 224, 31, 3, 224, 31, 3, 224, 31, 3, 224, 31, 3, 192, 31, 7,
  128, 31, 7, 0, 31, 248, 0, 31, 7, 0, 31, 3, 192, 31, 1, 224,
  31, 1, 224, 31, 1, 240, 31, 1, 240, 31, 1, 240, 31, 1, 240, 31,
  1, 240, 31, 1, 224, 31, 3, 192, 31, 7, 128, 255, 254, 0, 19, 25,
  75, 22, 2, 1, 3, 248, 64, 14, 6, 192, 30, 3, 192, 60, 3, 192,
  60, 1, 192, 124, 1, 192, 124, 0, 192, 124, 0, 192, 252, 0, 192, 252,
  0, 64, 252, 0, 64, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0,
  0, 252, 0, 0, 252, 0, 96, 124, 0, 64, 124, 0, 64, 124, 0, 64,
  60, 0, 192, 30, 0, 128, 30, 1, 0, 15, 3, 0, 3, 252, 0, 23,
  25, 75, 27, 2, 0, 255, 255, 0, 31, 3, 192, 31, 0, 224, 31, 0,
  240, 31, 0, 120, 31, 0, 120, 31, 0, 124, 31, 0, 124, 31, 0, 126,
  31, 0, 126, 31, 0, 126, 31, 0, 126, 31, 0, 126, 31, 0, 126, 31,
  0, 126, 31, 0, 126, 31, 0, 124, 31, 0, 124, 31, 0, 124, 31, 0,
  120, 31, 0, 120, 31, 0, 240, 31, 0, 224, 31, 3, 192, 255, 255, 0,
  20, 25, 75, 23, 2, 0, 255, 255, 224, 31, 1, 224, 31, 0, 224, 31,
  0, 224, 31, 0, 96, 31, 0, 96, 31, 0, 32, 31, 4, 32, 31, 4,
  0, 31, 12, 0, 31, 12, 0, 31, 28, 0, 31, 252, 0, 31, 28, 0,
  31, 12, 0, 31, 12, 48, 31, 4, 48, 31, 4, 48, 31, 0, 48, 31,
  0, 112, 31, 0, 112, 31, 0, 240, 31, 1, 240, 31, 3, 240, 255, 255,
  240, 20, 25, 75, 23, 2, 0, 255, 255, 240, 31, 3, 240, 31, 0, 240,
  31, 0, 240, 31, 0, 112, 31, 0, 112, 31, 0, 48, 31, 4, 48, 31,
  4, 48, 31, 12, 48, 31, 12, 0, 31, 28, 0, 31, 252, 0, 31, 28,
  0, 31, 12, 0, 31, 12, 0, 31, 4, 0, 31, 4, 0, 31, 0, 0,
  31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 255,
  240, 0, 21, 26, 78, 24, 2, 0, 0, 32, 0, 3, 220, 32, 7, 3,
  96, 14, 1, 224, 28, 1, 224, 60, 0, 224, 60, 0, 224, 124, 0, 96,
  124, 0, 96, 252, 0, 32, 252, 0, 32, 252, 0, 0, 252, 0, 0, 252,
  63, 248, 252, 3, 224, 252, 3, 224, 252, 3, 224, 252, 3, 224, 124, 3,
  224, 124, 3, 224, 124, 3, 224, 60, 3, 224, 60, 3, 96, 30, 6, 96,
  14, 12, 96, 3, 184, 32, 25, 25, 100, 28, 2, 0, 255, 231, 255, 128,
  31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0,
  31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0,
  31, 0, 248, 0, 31, 0, 248, 0, 31, 255, 248, 0, 31, 0, 248, 0,
  31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0,
  31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0,
  31, 0, 248, 0, 31, 0, 248, 0, 31, 0, 248, 0, 255, 231, 255, 128,
  11, 25, 50, 14, 2, 0, 255, 224, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 255, 224, 16, 25, 50, 18, 1, 0, 7, 255,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 120, 248,
  248, 248, 248, 248, 248, 248, 240, 248, 224, 240, 64, 240, 97, 224, 63, 192,
  24, 25, 75, 27, 2, 0, 255, 227, 252, 31, 0, 224, 31, 0, 192, 31,
  0, 128, 31, 1, 128, 31, 3, 0, 31, 6, 0, 31, 12, 0, 31, 28,
  0, 31, 28, 0, 31, 62, 0, 31, 126, 0, 31, 255, 0, 31, 191, 0,
  31, 31, 128, 31, 31, 128, 31, 15, 192, 31, 15, 192, 31, 7, 224, 31,
  7, 224, 31, 3, 240, 31, 1, 240, 31, 1, 248, 31, 1, 252, 255, 231,
  255, 20, 25, 75, 23, 2, 0, 255, 224, 0, 31, 0, 0, 31, 0, 0,
  31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31,
  0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0,
  0, 31, 0, 48, 31, 0, 48, 31, 0, 48, 31, 0, 48, 31, 0, 112,
  31, 0, 112, 31, 0, 240, 31, 0, 240, 31, 1, 240, 31, 3, 240, 255,
  255, 240, 27, 25, 100, 30, 2, 0, 255, 0, 63, 224, 15, 0, 63, 0,
  15, 128, 63, 0, 15, 128, 63, 0, 15, 128, 127, 0, 15, 192, 95, 0,
  15, 192, 95, 0, 11, 224, 95, 0, 11, 224, 223, 0, 11, 224, 159, 0,
  9, 240, 159, 0, 9, 240, 159, 0, 9, 241, 31, 0, 8, 249, 31, 0,
  8, 249, 31, 0, 8, 249, 31, 0, 8, 126, 31, 0, 8, 126, 31, 0,
  8, 62, 31, 0, 8, 62, 31, 0, 8, 60, 31, 0, 8, 28, 31, 0,
  24, 28, 31, 0, 60, 28, 31, 0, 255, 8, 255, 224, 24, 25, 75, 27,
  2, 0, 255, 3, 255, 31, 128, 124, 31, 128, 56, 15, 192, 16, 7, 224,
  16, 7, 240, 16, 7, 240, 16, 5, 248, 16, 5, 252, 16, 4, 252, 16,
  4, 126, 16, 4, 127, 16, 4, 63, 16, 4, 31, 144, 4, 31, 208, 4,
  15, 208, 4, 7, 240, 4, 7, 240, 4, 3, 240, 4, 1, 240, 4, 1,
  240, 4, 0, 240, 14, 0, 112, 31, 0, 48, 255, 192, 48, 20, 25, 75,
  24, 2, 1, 3, 252, 0, 6, 6, 0, 14, 7, 0, 28, 3, 128, 60,
  3, 192, 60, 3, 192, 124, 3, 224, 124, 3, 224, 124, 3, 224, 252, 3,
  240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240,
  252, 3, 240, 124, 3, 224, 124, 3, 224, 124, 3, 224, 60, 3, 192, 60,
  3, 192, 28, 3, 128, 14, 7, 0, 6, 6, 0, 3, 252, 0, 20, 25,
  75, 24, 2, 0, 255, 254, 0, 31, 3, 128, 31, 3, 192, 31, 1, 224,
  31, 1, 240, 31, 1, 240, 31, 1, 240, 31, 1, 240, 31, 1, 240, 31,
  1, 224, 31, 3, 192, 31, 7, 128, 31, 254, 0, 31, 0, 0, 31, 0,
  0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0,
  31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 255, 240, 0, 20,
  33, 99, 24, 2, 249, 3, 252, 0, 6, 6, 0, 14, 7, 0, 28, 3,
  128, 60, 3, 192, 60, 3, 192, 124, 3, 224, 124, 3, 224, 124, 3, 224,
  252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252,
  3, 240, 252, 3, 240, 124, 3, 240, 124, 3, 224, 124, 3, 224, 60, 243,
  192, 61, 155, 192, 29, 11, 128, 15, 15, 128, 7, 15, 16, 3, 156, 16,
  0, 108, 16, 0, 12, 16, 0, 12, 48, 0, 14, 48, 0, 15, 240, 0,
  15, 224, 0, 7, 224, 0, 3, 128, 22, 25, 75, 25, 2, 0, 255, 252,
  0, 31, 7, 128, 31, 7, 192, 31, 3, 192, 31, 3, 224, 31, 3, 224,
  31, 3, 224, 31, 3, 224, 31, 3, 192, 31, 7, 192, 31, 15, 0, 31,
  248, 0, 31, 14, 0, 31, 15, 0, 31, 7, 128, 31, 7, 192, 31, 7,
  192, 31, 7, 192, 31, 7, 192, 31, 7, 196, 31, 7, 196, 31, 7, 196,
  31, 7, 196, 31, 3, 200, 255, 241, 248, 16, 25, 50, 21, 3, 1, 31,
  198, 32, 118, 96, 62, 224, 30, 224, 14, 240, 6, 248, 6, 252, 6, 255,
  2, 127, 128, 127, 192, 63, 240, 15, 248, 7, 252, 129, 254, 128, 254, 192,
  127, 192, 31, 192, 15, 224, 7, 224, 7, 240, 6, 248, 6, 220, 12, 135,
  120, 21, 25, 75, 25, 3, 0, 255, 255, 248, 248, 248, 248, 240, 248, 120,
  224, 248, 120, 192, 248, 56, 192, 248, 56, 128, 248, 24, 128, 248, 24, 128,
  248, 24, 128, 248, 24, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248,
  0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0,
  0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 15,
  255, 0, 23, 25, 75, 26, 2, 0, 255, 225, 254, 31, 0, 120, 31, 0,
  48, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16,
  31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31,
  0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0, 16, 31, 0,
  16, 31, 0, 16, 15, 0, 32, 15, 0, 32, 7, 128, 64, 3, 192, 192,
  1, 255, 0, 24, 25, 75, 27, 2, 0, 255, 241, 255, 31, 128, 56, 15,
  128, 48, 15, 192, 48, 15, 192, 48, 7, 192, 32, 7, 224, 32, 7, 224,
  96, 3, 224, 64, 3, 240, 64, 1, 240, 192, 1, 240, 128, 1, 248, 128,
  0, 249, 128, 0, 249, 128, 0, 253, 0, 0, 125, 0, 0, 127, 0, 0,
  126, 0, 0, 62, 0, 0, 62, 0, 0, 60, 0, 0, 28, 0, 0, 28,
  0, 0, 24, 0, 34, 25, 125, 36, 1, 0, 255, 231, 255, 127, 192, 31,
  129, 248, 14, 0, 15, 128, 248, 14, 0, 15, 128, 252, 12, 0, 15, 192,
  124, 12, 0, 7, 192, 124, 12, 0, 7, 192, 124, 8, 0, 7, 224, 254,
  24, 0, 3, 224, 190, 24, 0, 3, 224, 190, 24, 0, 3, 241, 159, 16,
  0, 1, 241, 159, 48, 0, 1, 241, 31, 48, 0, 1, 249, 15, 32, 0,
  1, 251, 15, 160, 0, 0, 250, 15, 224, 0, 0, 254, 15, 224, 0, 0,
  254, 7, 192, 0, 0, 126, 7, 192, 0, 0, 124, 7, 192, 0, 0, 124,
  3, 192, 0, 0, 60, 3, 128, 0, 0, 56, 3, 128, 0, 0, 56, 1,
  128, 0, 0, 24, 1, 128, 0, 23, 25, 75, 26, 2, 0, 255, 231, 252,
  31, 193, 224, 15, 192, 192, 15, 193, 128, 7, 225, 128, 7, 227, 0, 3,
  242, 0, 3, 246, 0, 1, 244, 0, 1, 248, 0, 0, 248, 0, 0, 252,
  0, 0, 124, 0, 0, 62, 0, 0, 126, 0, 0, 127, 0, 0, 159, 0,
  1, 159, 128, 1, 15, 128, 3, 15, 192, 6, 7, 224, 4, 7, 224, 12,
  3, 240, 28, 7, 240, 255, 143, 254, 23, 25, 75, 26, 2, 0, 255, 225,
  254, 31, 128, 112, 31, 128, 96, 15, 128, 96, 15, 192, 64, 7, 192, 192,
  7, 224, 192, 7, 224, 128, 3, 225, 128, 3, 241, 0, 1, 241, 0, 1,
  251, 0, 0, 250, 0, 0, 254, 0, 0, 252, 0, 0, 124, 0, 0, 124,
  0, 0, 124, 0, 0, 124, 0, 0, 124, 0, 0, 124, 0, 0, 124, 0,
  0, 124, 0, 0, 124, 0, 3, 255, 128, 18, 25, 75, 22, 2, 0, 127,
  255, 192, 124, 15, 192, 120, 31, 128, 112, 31, 128, 96, 63, 0, 96, 63,
  0, 64, 126, 0, 64, 126, 0, 64, 252, 0, 0, 252, 0, 1, 248, 0,
  1, 240, 0, 3, 240, 0, 7, 224, 0, 7, 224, 0, 15, 192, 64, 15,
  192, 64, 31, 128, 64, 31, 128, 64, 63, 0, 192, 63, 1, 192, 126, 1,
  192, 126, 3, 192, 252, 15, 192, 255, 255, 192, 8, 31, 31, 14, 3, 250,
  255, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
  240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 255, 11,
  33, 66, 15, 2, 249, 192, 0, 192, 0, 224, 0, 96, 0, 96, 0, 96,
  0, 112, 0, 48, 0, 48, 0, 56, 0, 24, 0, 24, 0, 28, 0, 12,
  0, 12, 0, 12, 0, 14, 0, 6, 0, 6, 0, 7, 0, 3, 0, 3,
  0, 3, 0, 3, 128, 1, 128, 1, 128, 1, 192, 0, 192, 0, 192, 0,
  224, 0, 96, 0, 96, 0, 96, 8, 31, 31, 13, 2, 250, 255, 15, 15,
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 255, 16, 12, 24, 20,
  2, 14, 1, 128, 3, 128, 3, 192, 7, 224, 14, 96, 14, 112, 28, 56,
  24, 56, 56, 28, 112, 12, 96, 14, 224, 7, 18, 2, 6, 18, 0, 250,
  255, 255, 192, 255, 255, 192, 6, 7, 7, 15, 3, 18, 224, 224, 240, 120,
  24, 12, 4, 15, 17, 34, 18, 2, 0, 15, 128, 49, 224, 96, 240, 112,
  240, 120, 240, 120, 240, 32, 240, 7, 240, 28, 240, 56, 240, 120, 240, 240,
  240, 240, 242, 240, 242, 240, 242, 121, 252, 62, 120, 15, 25, 50, 18, 1,
  0, 252, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60,
  0, 60, 240, 61, 56, 62, 60, 62, 28, 62, 30, 62, 30, 60, 30, 60,
  30, 60, 30, 60, 30, 60, 30, 62, 30, 62, 30, 62, 28, 50, 60, 35,
  56, 33, 224, 13, 17, 34, 16, 2, 0, 7, 128, 28, 96, 56, 32, 120,
  112, 120, 240, 248, 240, 240, 224, 240, 64, 240, 0, 240, 0, 240, 0, 240,
  8, 120, 16, 120, 16, 56, 16, 28, 32, 7, 192, 17, 25, 75, 20, 2,
  0, 1, 252, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0,
  0, 60, 0, 0, 60, 0, 0, 60, 0, 15, 60, 0, 28, 188, 0, 56,
  124, 0, 120, 124, 0, 120, 60, 0, 240, 60, 0, 240, 60, 0, 240, 60,
  0, 240, 60, 0, 240, 60, 0, 240, 60, 0, 240, 60, 0, 120, 60, 0,
  120, 124, 0, 56, 124, 0, 28, 188, 0, 15, 63, 128, 13, 17, 34, 17,
  2, 0, 7, 128, 24, 224, 56, 240, 120, 240, 120, 240, 240, 120, 240, 120,
  240, 120, 255, 248, 240, 0, 240, 0, 240, 8, 120, 8, 120, 24, 56, 16,
  28, 32, 7, 192, 12, 25, 50, 12, 1, 0, 3, 192, 14, 112, 30, 112,
  28, 240, 60, 240, 60, 240, 60, 0, 60, 0, 255, 128, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 255, 128, 17, 25, 75, 19,
  1, 248, 7, 199, 0, 28, 249, 128, 60, 115, 128, 120, 123, 128, 120, 123,
  0, 120, 120, 0, 120, 120, 0, 120, 120, 0, 60, 112, 0, 28, 224, 0,
  7, 192, 0, 56, 0, 0, 96, 0, 0, 127, 192, 0, 127, 248, 0, 127,
  252, 0, 63, 254, 0, 63, 254, 0, 64, 14, 0, 128, 6, 0, 128, 6,
  0, 128, 4, 0, 64, 12, 0, 32, 56, 0, 31, 224, 0, 17, 25, 75,
  19, 1, 0, 252, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60,
  0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 120, 0, 61, 188,
  0, 61, 28, 0, 62, 30, 0, 62, 30, 0, 62, 30, 0, 60, 30, 0,
  60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60,
  30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 255, 127, 128, 8, 25,
  25, 11, 2, 0, 56, 124, 124, 124, 56, 0, 0, 0, 252, 60, 60, 60,
  60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 255, 10, 33, 66,
  10, 254, 248, 3, 128, 7, 192, 7, 192, 7, 192, 3, 128, 0, 0, 0,
  0, 0, 0, 31, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 99, 192, 243, 192, 243, 192, 243, 128, 231,
  128, 103, 0, 62, 0, 17, 25, 75, 19, 1, 0, 252, 0, 0, 60, 0,
  0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0,
  60, 0, 0, 60, 127, 0, 60, 24, 0, 60, 16, 0, 60, 48, 0, 60,
  32, 0, 60, 64, 0, 60, 192, 0, 60, 224, 0, 61, 224, 0, 62, 240,
  0, 62, 240, 0, 60, 120, 0, 60, 124, 0, 60, 60, 0, 60, 62, 0,
  60, 62, 0, 255, 127, 128, 9, 25, 50, 11, 1, 0, 252, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 255, 128, 25, 17,
  68, 28, 1, 0, 252, 120, 120, 0, 61, 188, 158, 0, 61, 31, 30, 0,
  62, 31, 30, 0, 62, 30, 31, 0, 62, 30, 31, 0, 60, 30, 31, 0,
  60, 30, 31, 0, 60, 30, 31, 0, 60, 30, 31, 0, 60, 30, 31, 0,
  60, 30, 31, 0, 60, 30, 31, 0, 60, 30, 31, 0, 60, 30, 31, 0,
  60, 30, 31, 0, 255, 127, 191, 128, 17, 17, 51, 19, 1, 0, 252, 120,
  0, 61, 188, 0, 61, 28, 0, 62, 30, 0, 62, 30, 0, 62, 30, 0,
  60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60,
  30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 255, 127,
  128, 14, 17, 34, 18, 2, 0, 7, 128, 28, 224, 56, 112, 120, 120, 120,
  120, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 120,
  120, 120, 120, 56, 112, 24, 224, 7, 128, 15, 25, 50, 18, 1, 248, 252,
  240, 61, 56, 62, 60, 62, 28, 62, 30, 62, 30, 60, 30, 60, 30, 60,
  30, 60, 30, 60, 30, 62, 30, 62, 30, 62, 28, 62, 60, 61, 56, 60,
  240, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 255,
  128, 16, 25, 50, 19, 2, 248, 15, 132, 28, 196, 56, 100, 120, 124, 120,
  60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 240, 60, 120,
  124, 120, 124, 56, 124, 28, 188, 15, 60, 0, 60, 0, 60, 0, 60, 0,
  60, 0, 60, 0, 60, 0, 60, 1, 255, 12, 17, 34, 14, 1, 0, 252,
  224, 61, 112, 62, 240, 62, 240, 62, 240, 62, 96, 60, 0, 60, 0, 60,
  0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 255,
  0, 11, 17, 34, 14, 2, 0, 60, 64, 99, 64, 193, 192, 192, 192, 224,
  192, 240, 64, 252, 0, 127, 0, 63, 128, 31, 192, 135, 224, 129, 224, 192,
  224, 224, 96, 224, 96, 144, 192, 143, 128, 11, 24, 48, 13, 1, 0, 12,
  0, 12, 0, 12, 0, 12, 0, 12, 0, 28, 0, 60, 0, 255, 192, 60,
  0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60, 0, 60,
  32, 60, 32, 60, 32, 60, 32, 60, 96, 60, 64, 31, 192, 15, 128, 17,
  17, 51, 19, 1, 0, 252, 126, 0, 60, 30, 0, 60, 30, 0, 60, 30,
  0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0,
  60, 30, 0, 60, 30, 0, 60, 62, 0, 60, 62, 0, 60, 62, 0, 60,
  94, 0, 30, 158, 0, 15, 31, 128, 17, 17, 51, 18, 0, 0, 255, 159,
  128, 30, 6, 0, 30, 4, 0, 30, 4, 0, 15, 12, 0, 15, 8, 0,
  15, 8, 0, 7, 152, 0, 7, 144, 0, 3, 208, 0, 3, 240, 0, 3,
  224, 0, 1, 224, 0, 1, 192, 0, 1, 192, 0, 0, 192, 0, 0, 128,
  0, 25, 17, 68, 26, 0, 0, 255, 63, 207, 128, 30, 15, 6, 0, 30,
  15, 6, 0, 30, 15, 4, 0, 15, 7, 132, 0, 15, 15, 132, 0, 7,
  143, 136, 0, 7, 139, 200, 0, 7, 147, 200, 0, 3, 211, 208, 0, 3,
  209, 240, 0, 3, 225, 240, 0, 1, 225, 224, 0, 1, 224, 224, 0, 1,
  192, 224, 0, 0, 192, 192, 0, 0, 192, 64, 0, 16, 17, 34, 18, 1,
  0, 255, 126, 62, 24, 30, 16, 31, 16, 15, 32, 15, 192, 7, 192, 3,
  192, 3, 192, 1, 224, 3, 240, 2, 240, 4, 248, 8, 120, 8, 124, 24,
  126, 254, 127, 17, 25, 75, 18, 0, 248, 255, 159, 128, 62, 6, 0, 30,
  4, 0, 31, 4, 0, 15, 8, 0, 15, 8, 0, 15, 136, 0, 7, 136,
  0, 7, 144, 0, 3, 208, 0, 3, 208, 0, 3, 224, 0, 1, 224, 0,
  1, 224, 0, 0, 224, 0, 0, 192, 0, 0, 64, 0, 0, 64, 0, 0,
  128, 0, 28, 128, 0, 60, 128, 0, 60, 128, 0, 57, 0, 0, 59, 0,
  0, 30, 0, 0, 13, 17, 34, 16, 1, 0, 127, 248, 112, 248, 96, 240,
  97, 224, 67, 224, 67, 192, 7, 192, 7, 128, 15, 128, 15, 0, 31, 8,
  30, 8, 60, 24, 124, 24, 120, 56, 248, 120, 255, 248, 11, 33, 66, 15,
  2, 249, 0, 32, 3, 192, 7, 0, 15, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  56, 0, 224, 0, 56, 0, 28, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 14, 0, 7, 0,
  3, 192, 0, 32, 2, 32, 32, 10, 4, 249, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 11, 33, 66, 15, 3, 249,
  128, 0, 240, 0, 60, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 15, 0, 7, 0,
  1, 224, 7, 0, 15, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 60, 0, 240, 0,
  128, 0, 19, 7, 21, 23, 2, 6, 62, 0, 64, 127, 128, 32, 255, 240,
  32, 135, 252, 32, 129, 255, 224, 128, 63, 192, 64, 15, 128, 255
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--38-380-72-72-P-206-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 29, '1' Height: 28
  Calculated Max Values w=38 h=37 x= 7 y=23 dx=41 dy= 0 ascent=38 len=165
  Font Bounding box     w=107 h=49 x=-33 y=-11
  Calculated Min Values           x=-2 y=-11 dx= 0 dy= 0
  Pure Font   ascent =29 descent=-9
  X Font      ascent =29 descent=-9
  Max Font    ascent =38 descent=-11
*/
const u8g_fntpgm_uint8_t u8g_font_osb29[15818] U8G_FONT_SECTION("u8g_font_osb29") = {
  0, 107, 49, 223, 245, 29, 9, 166, 21, 115, 32, 255, 247, 38, 245, 29,
  247, 0, 0, 0, 11, 0, 0, 6, 28, 28, 10, 2, 1, 120, 252, 252,
  252, 252, 252, 252, 120, 120, 120, 120, 120, 48, 48, 48, 48, 48, 48, 48,
  48, 0, 0, 120, 252, 252, 252, 252, 120, 10, 9, 18, 16, 3, 20, 243,
  192, 243, 192, 243, 192, 243, 192, 243, 192, 243, 192, 97, 128, 97, 128, 97,
  128, 22, 28, 84, 28, 3, 0, 1, 192, 224, 1, 192, 224, 1, 192, 224,
  1, 192, 224, 1, 128, 192, 1, 128, 192, 1, 128, 192, 3, 129, 252, 255,
  255, 252, 255, 255, 252, 3, 129, 128, 3, 1, 128, 3, 1, 128, 7, 3,
  128, 7, 3, 128, 7, 3, 128, 7, 3, 128, 6, 3, 0, 255, 255, 252,
  255, 255, 252, 255, 255, 252, 14, 7, 0, 14, 7, 0, 14, 6, 0, 12,
  6, 0, 12, 6, 0, 28, 14, 0, 28, 14, 0, 18, 34, 102, 22, 2,
  253, 1, 16, 0, 1, 16, 0, 1, 16, 0, 7, 252, 0, 29, 19, 0,
  57, 17, 128, 49, 16, 192, 113, 16, 192, 113, 17, 192, 113, 19, 192, 121,
  23, 192, 127, 23, 128, 127, 19, 0, 63, 144, 0, 63, 240, 0, 31, 240,
  0, 15, 252, 0, 7, 254, 0, 1, 255, 0, 1, 255, 128, 1, 63, 128,
  121, 31, 192, 249, 23, 192, 249, 19, 192, 249, 17, 192, 225, 17, 192, 193,
  17, 192, 97, 17, 128, 97, 19, 0, 57, 22, 0, 15, 60, 0, 1, 208,
  0, 1, 16, 0, 1, 16, 0, 26, 29, 116, 32, 3, 0, 4, 0, 12,
  0, 27, 0, 8, 0, 49, 128, 24, 0, 113, 192, 16, 0, 113, 192, 48,
  0, 241, 224, 96, 0, 241, 224, 96, 0, 241, 224, 192, 0, 241, 224, 128,
  0, 241, 225, 128, 0, 241, 225, 0, 0, 113, 195, 0, 0, 113, 194, 0,
  0, 59, 134, 0, 0, 30, 12, 0, 0, 0, 12, 28, 0, 0, 24, 119,
  0, 0, 16, 227, 128, 0, 48, 227, 128, 0, 33, 227, 192, 0, 97, 227,
  192, 0, 65, 227, 192, 0, 193, 227, 192, 1, 129, 227, 192, 1, 129, 227,
  192, 3, 1, 227, 128, 2, 0, 227, 128, 6, 0, 99, 0, 4, 0, 62,
  0, 27, 28, 112, 31, 2, 1, 0, 254, 0, 0, 1, 195, 0, 0, 3,
  129, 0, 0, 7, 129, 128, 0, 7, 129, 128, 0, 7, 129, 128, 0, 7,
  131, 128, 0, 7, 195, 0, 0, 7, 198, 0, 0, 3, 236, 0, 0, 3,
  248, 0, 0, 1, 240, 0, 0, 0, 248, 0, 0, 1, 252, 31, 224, 7,
  124, 3, 128, 14, 62, 3, 0, 28, 63, 3, 0, 56, 31, 134, 0, 120,
  15, 134, 0, 120, 7, 196, 0, 248, 7, 232, 0, 248, 3, 248, 0, 248,
  1, 240, 0, 252, 1, 248, 0, 254, 0, 248, 32, 127, 1, 252, 64, 63,
  254, 127, 192, 31, 248, 31, 128, 4, 9, 9, 10, 3, 20, 240, 240, 240,
  240, 240, 240, 96, 96, 96, 11, 35, 70, 13, 2, 249, 0, 96, 0, 192,
  1, 128, 3, 0, 6, 0, 12, 0, 28, 0, 24, 0, 56, 0, 56, 0,
  120, 0, 120, 0, 120, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 120, 0, 120, 0, 120, 0, 120, 0,
  56, 0, 56, 0, 28, 0, 12, 0, 14, 0, 7, 0, 3, 0, 1, 128,
  0, 96, 11, 36, 72, 14, 1, 249, 192, 0, 96, 0, 48, 0, 24, 0,
  12, 0, 14, 0, 7, 0, 7, 0, 3, 128, 3, 128, 3, 192, 3, 192,
  3, 192, 3, 192, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 192, 3, 192, 3, 192, 3, 128, 3, 128, 7, 0,
  7, 0, 6, 0, 12, 0, 28, 0, 56, 0, 112, 0, 192, 0, 128, 0,
  14, 16, 32, 19, 3, 12, 3, 0, 7, 128, 7, 128, 199, 24, 227, 60,
  242, 124, 122, 248, 7, 128, 7, 128, 250, 248, 242, 124, 227, 60, 199, 24,
  7, 128, 7, 128, 3, 0, 33, 33, 165, 37, 2, 251, 0, 1, 192, 0,
  0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0,
  0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0,
  1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1,
  192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192,
  0, 0, 0, 1, 192, 0, 0, 255, 255, 255, 255, 128, 255, 255, 255, 255,
  128, 255, 255, 255, 255, 128, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0,
  0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0,
  1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1,
  192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192,
  0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0,
  0, 7, 13, 13, 10, 2, 249, 120, 252, 252, 254, 254, 126, 6, 4, 4,
  8, 24, 96, 192, 10, 4, 8, 14, 2, 8, 255, 192, 255, 192, 255, 192,
  255, 192, 6, 6, 6, 10, 2, 0, 120, 252, 252, 252, 252, 120, 13, 37,
  74, 17, 2, 248, 0, 24, 0, 56, 0, 56, 0, 48, 0, 112, 0, 112,
  0, 96, 0, 96, 0, 224, 0, 224, 0, 192, 1, 192, 1, 192, 1, 128,
  3, 128, 3, 128, 3, 128, 3, 0, 7, 0, 7, 0, 6, 0, 14, 0,
  14, 0, 12, 0, 12, 0, 28, 0, 28, 0, 24, 0, 56, 0, 56, 0,
  48, 0, 112, 0, 112, 0, 112, 0, 96, 0, 224, 0, 224, 0, 18, 28,
  84, 22, 2, 1, 3, 240, 0, 14, 28, 0, 14, 28, 0, 28, 14, 0,
  60, 15, 0, 60, 15, 0, 124, 15, 128, 124, 15, 128, 124, 15, 128, 252,
  15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15,
  192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 124, 15, 128,
  124, 15, 128, 124, 15, 128, 60, 15, 0, 60, 15, 0, 28, 14, 0, 12,
  28, 0, 14, 28, 0, 3, 240, 0, 13, 28, 56, 22, 5, 0, 3, 128,
  7, 128, 15, 128, 255, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 255, 248, 17, 28, 84, 22, 2, 1, 15, 248, 0, 24,
  62, 0, 48, 63, 0, 112, 31, 0, 240, 31, 128, 240, 31, 128, 252, 31,
  128, 252, 31, 128, 254, 31, 128, 126, 63, 0, 60, 63, 0, 0, 126, 0,
  0, 252, 0, 0, 248, 0, 1, 224, 0, 3, 128, 0, 6, 0, 0, 12,
  0, 128, 24, 0, 128, 16, 0, 128, 32, 0, 128, 47, 1, 128, 127, 255,
  128, 127, 255, 128, 71, 255, 0, 67, 255, 0, 65, 254, 0, 64, 252, 0,
  17, 28, 84, 22, 2, 1, 15, 248, 0, 24, 62, 0, 48, 63, 0, 48,
  31, 0, 112, 31, 128, 120, 31, 128, 124, 31, 128, 124, 31, 128, 124, 31,
  128, 60, 31, 0, 0, 31, 0, 0, 62, 0, 0, 120, 0, 15, 192, 0,
  0, 120, 0, 0, 62, 0, 0, 63, 0, 0, 31, 0, 16, 31, 128, 124,
  31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 248, 31, 128, 240, 63,
  0, 112, 62, 0, 56, 124, 0, 31, 248, 0, 18, 28, 84, 22, 2, 0,
  0, 124, 0, 0, 124, 0, 0, 252, 0, 0, 252, 0, 1, 252, 0, 1,
  252, 0, 3, 252, 0, 3, 252, 0, 6, 252, 0, 6, 252, 0, 12, 252,
  0, 12, 252, 0, 24, 252, 0, 24, 252, 0, 48, 252, 0, 48, 252, 0,
  96, 252, 0, 96, 252, 0, 192, 252, 0, 255, 255, 192, 0, 252, 0, 0,
  252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252,
  0, 15, 255, 192, 17, 29, 87, 22, 3, 0, 0, 6, 0, 112, 28, 0,
  127, 252, 0, 127, 248, 0, 127, 224, 0, 127, 192, 0, 126, 0, 0, 96,
  0, 0, 96, 0, 0, 96, 0, 0, 96, 0, 0, 103, 224, 0, 120, 120,
  0, 112, 62, 0, 96, 62, 0, 96, 31, 0, 0, 31, 0, 0, 31, 128,
  0, 31, 128, 56, 31, 128, 124, 31, 128, 252, 31, 128, 252, 31, 128, 248,
  31, 0, 240, 31, 0, 224, 30, 0, 96, 62, 0, 48, 124, 0, 31, 240,
  0, 18, 29, 87, 22, 3, 0, 0, 32, 0, 3, 220, 0, 7, 6, 0,
  14, 6, 0, 30, 15, 0, 60, 31, 0, 60, 63, 0, 124, 63, 0, 124,
  62, 0, 124, 28, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 253, 248,
  0, 255, 30, 0, 254, 31, 0, 252, 15, 128, 252, 15, 128, 252, 15, 192,
  252, 15, 192, 252, 15, 192, 124, 15, 192, 124, 15, 192, 124, 15, 192, 60,
  15, 128, 28, 15, 128, 30, 15, 0, 14, 30, 0, 3, 252, 0, 17, 28,
  84, 22, 3, 0, 103, 135, 0, 111, 199, 0, 127, 227, 128, 127, 241, 128,
  127, 249, 128, 127, 255, 128, 96, 125, 128, 64, 1, 0, 64, 3, 0, 64,
  3, 0, 192, 6, 0, 0, 4, 0, 0, 12, 0, 0, 24, 0, 0, 56,
  0, 0, 112, 0, 0, 112, 0, 0, 240, 0, 1, 240, 0, 3, 224, 0,
  3, 224, 0, 3, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 7,
  224, 0, 7, 224, 0, 3, 192, 0, 19, 29, 87, 22, 2, 0, 0, 64,
  0, 7, 184, 0, 28, 6, 0, 56, 3, 0, 112, 1, 0, 112, 1, 128,
  240, 1, 128, 240, 1, 128, 248, 1, 128, 252, 3, 0, 255, 2, 0, 127,
  196, 0, 127, 248, 0, 63, 252, 0, 31, 255, 0, 15, 255, 128, 27, 255,
  128, 48, 255, 192, 96, 63, 192, 96, 15, 192, 224, 3, 224, 224, 1, 192,
  224, 1, 192, 224, 1, 192, 224, 1, 192, 112, 1, 128, 56, 1, 0, 28,
  6, 0, 15, 252, 0, 18, 28, 84, 22, 3, 1, 15, 240, 0, 30, 28,
  0, 60, 30, 0, 124, 14, 0, 124, 15, 0, 252, 15, 128, 252, 15, 128,
  252, 15, 128, 252, 15, 128, 252, 15, 192, 252, 15, 192, 124, 15, 192, 124,
  15, 192, 62, 31, 192, 30, 63, 192, 7, 239, 192, 0, 15, 192, 0, 15,
  192, 0, 15, 192, 30, 15, 128, 31, 15, 128, 63, 15, 128, 63, 15, 0,
  62, 15, 0, 56, 30, 0, 24, 28, 0, 24, 56, 0, 15, 240, 0, 6,
  19, 19, 10, 2, 0, 120, 252, 252, 252, 252, 120, 0, 0, 0, 0, 0,
  0, 0, 120, 252, 252, 252, 252, 120, 7, 26, 26, 10, 2, 249, 120, 252,
  252, 252, 252, 120, 0, 0, 0, 0, 0, 0, 0, 120, 252, 252, 254, 254,
  126, 6, 4, 4, 8, 16, 96, 192, 29, 33, 132, 36, 3, 250, 0, 0,
  0, 24, 0, 0, 0, 120, 0, 0, 1, 240, 0, 0, 7, 192, 0, 0,
  31, 128, 0, 0, 62, 0, 0, 0, 248, 0, 0, 3, 224, 0, 0, 15,
  192, 0, 0, 31, 0, 0, 0, 124, 0, 0, 1, 240, 0, 0, 7, 192,
  0, 0, 15, 128, 0, 0, 62, 0, 0, 0, 248, 0, 0, 0, 240, 0,
  0, 0, 124, 0, 0, 0, 62, 0, 0, 0, 15, 128, 0, 0, 3, 224,
  0, 0, 0, 248, 0, 0, 0, 124, 0, 0, 0, 31, 0, 0, 0, 7,
  192, 0, 0, 1, 240, 0, 0, 0, 252, 0, 0, 0, 62, 0, 0, 0,
  15, 128, 0, 0, 3, 224, 0, 0, 1, 248, 0, 0, 0, 120, 0, 0,
  0, 16, 32, 11, 44, 36, 2, 5, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 29, 33, 132, 36, 4, 250, 192, 0, 0, 0, 240, 0,
  0, 0, 124, 0, 0, 0, 31, 0, 0, 0, 15, 192, 0, 0, 3, 224,
  0, 0, 0, 248, 0, 0, 0, 62, 0, 0, 0, 31, 128, 0, 0, 7,
  192, 0, 0, 1, 240, 0, 0, 0, 124, 0, 0, 0, 31, 0, 0, 0,
  15, 128, 0, 0, 3, 224, 0, 0, 0, 248, 0, 0, 0, 120, 0, 0,
  1, 240, 0, 0, 3, 224, 0, 0, 15, 128, 0, 0, 62, 0, 0, 0,
  248, 0, 0, 1, 240, 0, 0, 7, 192, 0, 0, 31, 0, 0, 0, 124,
  0, 0, 1, 248, 0, 0, 3, 224, 0, 0, 15, 128, 0, 0, 62, 0,
  0, 0, 252, 0, 0, 0, 240, 0, 0, 0, 64, 0, 0, 0, 12, 28,
  56, 18, 3, 1, 63, 128, 119, 224, 65, 224, 129, 240, 129, 240, 129, 240,
  129, 240, 129, 224, 193, 224, 67, 192, 3, 128, 7, 0, 6, 0, 12, 0,
  8, 0, 24, 0, 16, 64, 16, 64, 16, 64, 24, 128, 15, 0, 0, 0,
  7, 128, 15, 192, 15, 192, 15, 192, 15, 192, 7, 128, 28, 29, 116, 32,
  2, 0, 0, 2, 0, 0, 0, 125, 240, 0, 1, 192, 28, 0, 3, 0,
  6, 0, 6, 0, 3, 0, 12, 0, 1, 128, 24, 15, 61, 192, 56, 28,
  188, 192, 48, 56, 248, 224, 112, 112, 120, 224, 112, 240, 120, 96, 225, 224,
  120, 112, 225, 224, 248, 112, 225, 224, 240, 112, 227, 224, 240, 112, 227, 192,
  240, 112, 227, 192, 240, 112, 227, 193, 224, 96, 227, 193, 224, 224, 99, 193,
  224, 192, 99, 195, 224, 192, 115, 194, 225, 128, 49, 228, 227, 0, 56, 120,
  124, 0, 28, 0, 0, 0, 12, 0, 0, 0, 7, 0, 0, 0, 3, 128,
  24, 0, 0, 255, 224, 0, 26, 29, 116, 29, 2, 0, 0, 4, 0, 0,
  0, 6, 0, 0, 0, 14, 0, 0, 0, 14, 0, 0, 0, 15, 0, 0,
  0, 31, 0, 0, 0, 31, 0, 0, 0, 31, 128, 0, 0, 63, 128, 0,
  0, 47, 128, 0, 0, 47, 192, 0, 0, 111, 192, 0, 0, 79, 192, 0,
  0, 71, 192, 0, 0, 199, 224, 0, 0, 135, 224, 0, 0, 131, 224, 0,
  1, 131, 240, 0, 1, 3, 240, 0, 3, 1, 240, 0, 3, 255, 248, 0,
  2, 1, 248, 0, 6, 0, 248, 0, 6, 0, 252, 0, 4, 0, 252, 0,
  12, 0, 252, 0, 12, 0, 124, 0, 30, 0, 254, 0, 255, 199, 255, 192,
  22, 28, 84, 27, 3, 0, 255, 255, 0, 31, 131, 192, 31, 131, 224, 31,
  129, 240, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129,
  248, 31, 129, 240, 31, 129, 240, 31, 131, 192, 31, 131, 128, 31, 252, 0,
  31, 131, 128, 31, 129, 224, 31, 128, 240, 31, 128, 248, 31, 128, 252, 31,
  128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 248, 31, 128,
  248, 31, 129, 240, 31, 131, 224, 255, 255, 128, 21, 28, 84, 26, 3, 1,
  1, 254, 48, 7, 3, 48, 14, 1, 240, 30, 0, 240, 60, 0, 240, 60,
  0, 112, 124, 0, 112, 124, 0, 48, 124, 0, 48, 252, 0, 48, 252, 0,
  48, 252, 0, 16, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0,
  252, 0, 0, 252, 0, 24, 252, 0, 24, 124, 0, 16, 124, 0, 16, 124,
  0, 16, 60, 0, 48, 60, 0, 32, 30, 0, 96, 14, 0, 192, 7, 1,
  128, 1, 254, 0, 25, 28, 112, 30, 3, 0, 255, 255, 128, 0, 31, 128,
  224, 0, 31, 128, 112, 0, 31, 128, 56, 0, 31, 128, 60, 0, 31, 128,
  30, 0, 31, 128, 30, 0, 31, 128, 31, 0, 31, 128, 31, 0, 31, 128,
  31, 0, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 0, 31, 128, 31, 0, 31, 128, 31, 0, 31, 128,
  30, 0, 31, 128, 30, 0, 31, 128, 60, 0, 31, 128, 56, 0, 31, 128,
  112, 0, 31, 128, 224, 0, 255, 255, 128, 0, 22, 28, 84, 26, 2, 0,
  255, 255, 252, 15, 192, 124, 15, 192, 60, 15, 192, 28, 15, 192, 28, 15,
  192, 12, 15, 192, 12, 15, 192, 12, 15, 193, 4, 15, 193, 0, 15, 195,
  0, 15, 195, 0, 15, 199, 0, 15, 255, 0, 15, 199, 0, 15, 195, 0,
  15, 195, 0, 15, 193, 4, 15, 193, 4, 15, 193, 4, 15, 192, 12, 15,
  192, 12, 15, 192, 12, 15, 192, 28, 15, 192, 28, 15, 192, 60, 15, 192,
  252, 255, 255, 252, 22, 28, 84, 25, 2, 0, 255, 255, 252, 31, 128, 252,
  31, 128, 124, 31, 128, 60, 31, 128, 28, 31, 128, 28, 31, 128, 28, 31,
  128, 12, 31, 129, 12, 31, 129, 12, 31, 131, 12, 31, 131, 0, 31, 135,
  0, 31, 255, 0, 31, 143, 0, 31, 135, 0, 31, 131, 0, 31, 129, 0,
  31, 129, 0, 31, 129, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31,
  128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 255, 252, 0, 24, 29,
  87, 28, 3, 0, 0, 16, 0, 1, 239, 24, 3, 3, 152, 14, 0, 248,
  30, 0, 248, 28, 0, 120, 60, 0, 56, 60, 0, 56, 124, 0, 24, 124,
  0, 24, 124, 0, 24, 252, 0, 8, 252, 0, 0, 252, 0, 0, 252, 0,
  0, 252, 31, 255, 252, 1, 248, 252, 1, 248, 252, 1, 248, 252, 1, 248,
  124, 1, 248, 124, 1, 248, 124, 1, 248, 60, 1, 248, 60, 1, 248, 30,
  3, 152, 14, 3, 24, 7, 6, 24, 1, 220, 24, 27, 28, 112, 31, 2,
  0, 255, 251, 255, 224, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63,
  0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63,
  0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63,
  0, 31, 128, 63, 0, 31, 255, 255, 0, 31, 128, 63, 0, 31, 128, 63,
  0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63,
  0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63,
  0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63, 0, 255, 251, 255,
  224, 13, 28, 56, 17, 2, 0, 255, 248, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 255, 248, 18,
  28, 84, 20, 1, 0, 7, 255, 192, 0, 126, 0, 0, 126, 0, 0, 126,
  0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0,
  0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0,
  126, 0, 0, 126, 0, 0, 126, 0, 16, 126, 0, 124, 126, 0, 252, 126,
  0, 252, 126, 0, 252, 126, 0, 248, 126, 0, 240, 124, 0, 224, 124, 0,
  96, 120, 0, 32, 240, 0, 31, 224, 0, 26, 28, 112, 29, 2, 0, 255,
  241, 255, 0, 31, 128, 120, 0, 31, 128, 112, 0, 31, 128, 96, 0, 31,
  128, 64, 0, 31, 128, 192, 0, 31, 129, 128, 0, 31, 131, 0, 0, 31,
  134, 0, 0, 31, 134, 0, 0, 31, 142, 0, 0, 31, 159, 0, 0, 31,
  191, 0, 0, 31, 255, 128, 0, 31, 223, 128, 0, 31, 159, 192, 0, 31,
  143, 192, 0, 31, 143, 224, 0, 31, 135, 224, 0, 31, 135, 240, 0, 31,
  131, 240, 0, 31, 131, 248, 0, 31, 129, 248, 0, 31, 129, 252, 0, 31,
  128, 252, 0, 31, 128, 254, 0, 31, 128, 254, 0, 255, 243, 255, 192, 22,
  28, 84, 25, 2, 0, 255, 248, 0, 31, 128, 0, 31, 128, 0, 31, 128,
  0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0,
  31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31,
  128, 0, 31, 128, 0, 31, 128, 12, 31, 128, 12, 31, 128, 12, 31, 128,
  12, 31, 128, 28, 31, 128, 28, 31, 128, 60, 31, 128, 60, 31, 128, 124,
  31, 128, 252, 31, 129, 252, 255, 255, 252, 31, 28, 112, 34, 2, 0, 255,
  128, 15, 254, 15, 128, 15, 224, 15, 192, 15, 224, 15, 192, 15, 224, 15,
  192, 15, 224, 15, 224, 23, 224, 15, 224, 23, 224, 15, 240, 23, 224, 13,
  240, 23, 224, 13, 240, 39, 224, 13, 248, 39, 224, 12, 248, 39, 224, 12,
  248, 39, 224, 12, 252, 71, 224, 12, 124, 71, 224, 12, 124, 71, 224, 12,
  126, 71, 224, 12, 62, 135, 224, 12, 63, 135, 224, 12, 63, 135, 224, 12,
  31, 135, 224, 12, 31, 7, 224, 12, 31, 7, 224, 12, 15, 7, 224, 12,
  15, 7, 224, 28, 14, 7, 224, 62, 6, 7, 224, 255, 134, 63, 254, 27,
  28, 112, 30, 2, 0, 255, 128, 255, 224, 31, 192, 63, 0, 31, 192, 30,
  0, 15, 224, 12, 0, 7, 240, 12, 0, 7, 240, 12, 0, 7, 248, 12,
  0, 7, 248, 12, 0, 6, 252, 12, 0, 6, 254, 12, 0, 6, 126, 12,
  0, 6, 63, 12, 0, 6, 63, 140, 0, 6, 31, 140, 0, 6, 31, 204,
  0, 6, 15, 236, 0, 6, 7, 236, 0, 6, 7, 252, 0, 6, 3, 252,
  0, 6, 1, 252, 0, 6, 1, 252, 0, 6, 0, 252, 0, 6, 0, 252,
  0, 6, 0, 124, 0, 6, 0, 60, 0, 15, 0, 60, 0, 31, 128, 28,
  0, 255, 224, 12, 0, 22, 28, 84, 27, 3, 1, 1, 254, 0, 3, 3,
  0, 6, 1, 128, 14, 1, 192, 28, 0, 224, 60, 0, 240, 60, 0, 240,
  124, 0, 248, 124, 0, 248, 124, 0, 248, 252, 0, 252, 252, 0, 252, 252,
  0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0,
  252, 124, 0, 248, 124, 0, 248, 124, 0, 248, 60, 0, 240, 60, 0, 240,
  28, 0, 224, 14, 1, 192, 6, 1, 128, 3, 3, 0, 1, 254, 0, 23,
  28, 84, 27, 2, 0, 255, 255, 128, 31, 129, 240, 31, 128, 248, 31, 128,
  252, 31, 128, 124, 31, 128, 126, 31, 128, 126, 31, 128, 126, 31, 128, 126,
  31, 128, 126, 31, 128, 124, 31, 128, 252, 31, 128, 248, 31, 129, 224, 31,
  255, 128, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128,
  0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0,
  31, 128, 0, 31, 128, 0, 255, 248, 0, 22, 37, 111, 27, 3, 248, 1,
  254, 0, 3, 3, 0, 6, 1, 128, 14, 1, 192, 28, 0, 224, 60, 0,
  240, 60, 0, 240, 124, 0, 248, 124, 0, 248, 124, 0, 248, 252, 0, 252,
  252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252,
  0, 252, 252, 0, 252, 124, 0, 248, 124, 0, 248, 124, 0, 248, 60, 56,
  240, 60, 76, 240, 30, 133, 224, 14, 135, 224, 7, 135, 192, 3, 135, 132,
  1, 238, 4, 0, 22, 4, 0, 6, 4, 0, 7, 12, 0, 7, 12, 0,
  7, 252, 0, 7, 248, 0, 7, 248, 0, 3, 240, 0, 1, 224, 25, 28,
  112, 28, 2, 0, 255, 255, 0, 0, 31, 135, 192, 0, 31, 131, 224, 0,
  31, 129, 240, 0, 31, 129, 248, 0, 31, 129, 248, 0, 31, 129, 248, 0,
  31, 129, 248, 0, 31, 129, 248, 0, 31, 129, 240, 0, 31, 131, 224, 0,
  31, 135, 192, 0, 31, 254, 0, 0, 31, 135, 128, 0, 31, 131, 192, 0,
  31, 129, 240, 0, 31, 129, 240, 0, 31, 129, 248, 0, 31, 129, 248, 0,
  31, 129, 248, 0, 31, 129, 248, 0, 31, 129, 248, 128, 31, 129, 248, 128,
  31, 129, 248, 128, 31, 129, 248, 128, 31, 129, 249, 0, 31, 128, 249, 0,
  255, 248, 126, 0, 18, 29, 87, 23, 3, 0, 1, 0, 0, 31, 225, 128,
  48, 57, 128, 96, 31, 128, 96, 15, 128, 224, 7, 128, 240, 3, 128, 240,
  3, 128, 248, 1, 128, 254, 1, 128, 255, 1, 128, 127, 192, 0, 127, 224,
  0, 63, 248, 0, 31, 252, 0, 7, 255, 0, 3, 255, 0, 128, 255, 128,
  128, 127, 128, 192, 31, 192, 192, 15, 192, 192, 7, 192, 224, 3, 192, 224,
  1, 192, 240, 1, 128, 248, 1, 128, 248, 3, 0, 206, 2, 0, 135, 188,
  0, 24, 28, 84, 27, 2, 0, 255, 255, 255, 252, 126, 63, 248, 126, 31,
  240, 126, 15, 224, 126, 15, 224, 126, 7, 192, 126, 7, 192, 126, 3, 192,
  126, 3, 192, 126, 3, 128, 126, 3, 128, 126, 2, 0, 126, 0, 0, 126,
  0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0,
  0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0,
  126, 0, 0, 126, 0, 0, 126, 0, 7, 255, 224, 26, 28, 112, 30, 3,
  0, 255, 240, 127, 192, 31, 128, 31, 0, 31, 128, 14, 0, 31, 128, 6,
  0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6,
  0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6,
  0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6,
  0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6,
  0, 31, 128, 6, 0, 31, 128, 6, 0, 15, 128, 12, 0, 15, 192, 12,
  0, 7, 192, 24, 0, 7, 224, 56, 0, 1, 252, 240, 0, 0, 255, 192,
  0, 27, 28, 112, 30, 2, 0, 255, 248, 127, 224, 31, 192, 15, 0, 15,
  192, 6, 0, 15, 192, 6, 0, 7, 224, 4, 0, 7, 224, 12, 0, 7,
  224, 8, 0, 3, 240, 8, 0, 3, 240, 8, 0, 3, 240, 24, 0, 1,
  248, 16, 0, 1, 248, 16, 0, 1, 252, 48, 0, 0, 252, 32, 0, 0,
  252, 32, 0, 0, 254, 96, 0, 0, 126, 64, 0, 0, 126, 64, 0, 0,
  127, 192, 0, 0, 63, 128, 0, 0, 63, 128, 0, 0, 63, 128, 0, 0,
  31, 0, 0, 0, 31, 0, 0, 0, 31, 0, 0, 0, 14, 0, 0, 0,
  14, 0, 0, 0, 14, 0, 0, 38, 28, 140, 41, 2, 0, 255, 243, 255,
  207, 252, 31, 192, 126, 1, 224, 15, 192, 126, 0, 192, 15, 192, 62, 0,
  192, 7, 192, 63, 0, 128, 7, 224, 63, 0, 128, 7, 224, 63, 1, 128,
  7, 224, 63, 129, 0, 3, 240, 63, 129, 0, 3, 240, 127, 131, 0, 3,
  240, 111, 195, 0, 1, 248, 79, 194, 0, 1, 248, 207, 194, 0, 1, 248,
  199, 230, 0, 0, 252, 135, 230, 0, 0, 252, 135, 228, 0, 0, 253, 131,
  244, 0, 0, 127, 131, 252, 0, 0, 127, 3, 248, 0, 0, 127, 3, 248,
  0, 0, 127, 1, 248, 0, 0, 63, 1, 248, 0, 0, 62, 1, 240, 0,
  0, 62, 0, 240, 0, 0, 30, 0, 240, 0, 0, 28, 0, 240, 0, 0,
  28, 0, 96, 0, 0, 12, 0, 96, 0, 26, 28, 112, 29, 2, 0, 255,
  241, 255, 128, 31, 224, 124, 0, 15, 224, 56, 0, 15, 224, 48, 0, 7,
  240, 96, 0, 7, 240, 96, 0, 3, 248, 192, 0, 3, 248, 128, 0, 1,
  253, 128, 0, 0, 255, 0, 0, 0, 254, 0, 0, 0, 126, 0, 0, 0,
  127, 0, 0, 0, 63, 0, 0, 0, 63, 128, 0, 0, 31, 128, 0, 0,
  63, 192, 0, 0, 111, 192, 0, 0, 79, 224, 0, 0, 199, 224, 0, 1,
  135, 240, 0, 1, 131, 240, 0, 3, 3, 248, 0, 2, 1, 248, 0, 6,
  1, 252, 0, 14, 0, 252, 0, 30, 1, 254, 0, 255, 199, 255, 192, 25,
  28, 112, 28, 2, 0, 255, 240, 255, 128, 31, 192, 60, 0, 31, 192, 24,
  0, 15, 192, 24, 0, 15, 224, 24, 0, 7, 224, 16, 0, 7, 224, 48,
  0, 3, 240, 32, 0, 3, 240, 32, 0, 1, 248, 96, 0, 1, 248, 64,
  0, 1, 252, 64, 0, 0, 252, 192, 0, 0, 254, 128, 0, 0, 127, 128,
  0, 0, 127, 128, 0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0,
  0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0,
  0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0,
  0, 1, 255, 224, 0, 20, 28, 84, 25, 3, 0, 127, 255, 240, 126, 7,
  240, 124, 7, 224, 120, 15, 224, 112, 15, 192, 96, 31, 192, 96, 31, 128,
  96, 63, 128, 64, 63, 0, 64, 127, 0, 0, 254, 0, 0, 254, 0, 1,
  252, 0, 1, 248, 0, 3, 248, 0, 3, 240, 0, 7, 240, 0, 7, 224,
  16, 15, 224, 16, 15, 192, 16, 31, 192, 48, 31, 128, 48, 63, 128, 112,
  63, 0, 112, 127, 0, 240, 126, 1, 240, 254, 7, 240, 255, 255, 240, 9,
  35, 70, 15, 3, 249, 255, 128, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 255, 128, 13, 37, 74, 17, 2,
  248, 192, 0, 224, 0, 224, 0, 96, 0, 112, 0, 112, 0, 48, 0, 56,
  0, 56, 0, 24, 0, 24, 0, 28, 0, 28, 0, 12, 0, 14, 0, 14,
  0, 6, 0, 6, 0, 7, 0, 7, 0, 3, 0, 3, 128, 3, 128, 1,
  128, 1, 192, 1, 192, 0, 192, 0, 192, 0, 224, 0, 224, 0, 96, 0,
  112, 0, 112, 0, 48, 0, 48, 0, 56, 0, 56, 9, 35, 70, 15, 3,
  249, 255, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15,
  128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15,
  128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15,
  128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15,
  128, 15, 128, 15, 128, 255, 128, 18, 14, 42, 22, 2, 15, 0, 192, 0,
  0, 192, 0, 1, 224, 0, 3, 240, 0, 3, 240, 0, 7, 56, 0, 7,
  56, 0, 14, 28, 0, 28, 14, 0, 28, 14, 0, 56, 7, 0, 56, 7,
  0, 112, 3, 128, 224, 1, 192, 20, 3, 9, 20, 0, 249, 255, 255, 240,
  255, 255, 240, 255, 255, 240, 7, 7, 7, 17, 3, 21, 224, 240, 240, 120,
  60, 12, 6, 17, 19, 57, 20, 2, 0, 15, 192, 0, 24, 240, 0, 48,
  120, 0, 112, 120, 0, 124, 124, 0, 124, 124, 0, 124, 124, 0, 0, 252,
  0, 7, 124, 0, 28, 124, 0, 56, 124, 0, 120, 124, 0, 248, 124, 0,
  248, 124, 128, 248, 124, 128, 248, 124, 128, 252, 253, 128, 127, 191, 0, 62,
  30, 0, 18, 28, 84, 20, 0, 0, 255, 0, 0, 31, 0, 0, 31, 0,
  0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0,
  31, 0, 0, 31, 60, 0, 31, 78, 0, 31, 143, 0, 31, 135, 128, 31,
  7, 128, 31, 7, 128, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7,
  192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 128, 31, 7, 128,
  31, 135, 0, 25, 143, 0, 16, 206, 0, 16, 120, 0, 14, 19, 38, 18,
  2, 0, 7, 224, 14, 48, 60, 24, 60, 28, 120, 60, 120, 124, 248, 124,
  248, 120, 248, 48, 248, 0, 248, 0, 248, 0, 248, 0, 120, 4, 120, 4,
  56, 4, 28, 8, 14, 16, 7, 224, 18, 28, 84, 21, 2, 0, 0, 254,
  0, 0, 62, 0, 0, 62, 0, 0, 62, 0, 0, 62, 0, 0, 62, 0,
  0, 62, 0, 0, 62, 0, 0, 62, 0, 15, 62, 0, 28, 190, 0, 60,
  126, 0, 120, 126, 0, 120, 62, 0, 120, 62, 0, 248, 62, 0, 248, 62,
  0, 248, 62, 0, 248, 62, 0, 248, 62, 0, 248, 62, 0, 248, 62, 0,
  120, 62, 0, 120, 62, 0, 120, 126, 0, 60, 126, 0, 28, 190, 0, 15,
  63, 192, 14, 19, 38, 18, 2, 0, 7, 192, 28, 224, 56, 112, 56, 120,
  120, 120, 120, 124, 248, 124, 248, 124, 248, 124, 255, 252, 248, 0, 248, 0,
  248, 0, 120, 4, 120, 4, 56, 8, 60, 8, 30, 16, 7, 224, 14, 28,
  56, 13, 1, 0, 1, 240, 7, 24, 15, 28, 30, 60, 30, 124, 62, 124,
  62, 56, 62, 0, 62, 0, 255, 192, 62, 0, 62, 0, 62, 0, 62, 0,
  62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0,
  62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 255, 192, 19, 28, 84, 22,
  2, 247, 7, 225, 192, 30, 118, 96, 60, 60, 224, 60, 60, 224, 124, 62,
  192, 124, 62, 0, 124, 62, 0, 124, 62, 0, 60, 60, 0, 60, 60, 0,
  30, 120, 0, 7, 224, 0, 56, 0, 0, 96, 0, 0, 96, 0, 0, 127,
  224, 0, 127, 254, 0, 127, 255, 0, 63, 255, 128, 31, 255, 128, 96, 7,
  128, 192, 3, 128, 128, 3, 128, 128, 3, 0, 128, 3, 0, 64, 6, 0,
  48, 28, 0, 15, 240, 0, 20, 28, 84, 22, 1, 0, 255, 0, 0, 31,
  0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0,
  0, 31, 0, 0, 31, 0, 0, 31, 30, 0, 31, 111, 0, 31, 135, 128,
  31, 135, 192, 31, 135, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31,
  7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7,
  192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 255, 223, 240,
  8, 28, 28, 12, 2, 0, 60, 126, 126, 126, 126, 60, 0, 0, 0, 252,
  124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124,
  124, 255, 12, 37, 74, 13, 254, 247, 1, 224, 3, 240, 3, 240, 3, 240,
  3, 240, 1, 224, 0, 0, 0, 0, 0, 0, 15, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 123, 224, 251, 224, 251, 224, 243, 192, 227, 192, 103, 128,
  30, 0, 20, 28, 84, 21, 1, 0, 255, 0, 0, 31, 0, 0, 31, 0,
  0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0,
  31, 0, 0, 31, 31, 192, 31, 7, 0, 31, 6, 0, 31, 4, 0, 31,
  8, 0, 31, 16, 0, 31, 16, 0, 31, 48, 0, 31, 120, 0, 31, 248,
  0, 31, 188, 0, 31, 60, 0, 31, 30, 0, 31, 31, 0, 31, 15, 0,
  31, 15, 128, 31, 15, 128, 31, 15, 192, 255, 223, 240, 11, 28, 56, 12,
  1, 0, 255, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 255, 224, 27, 19, 76, 30, 2, 0,
  254, 60, 30, 0, 62, 222, 111, 0, 63, 31, 143, 0, 63, 31, 143, 128,
  63, 31, 143, 128, 62, 31, 15, 128, 62, 31, 15, 128, 62, 31, 15, 128,
  62, 31, 15, 128, 62, 31, 15, 128, 62, 31, 15, 128, 62, 31, 15, 128,
  62, 31, 15, 128, 62, 31, 15, 128, 62, 31, 15, 128, 62, 31, 15, 128,
  62, 31, 15, 128, 62, 31, 15, 128, 255, 63, 223, 224, 19, 19, 57, 22,
  2, 0, 254, 60, 0, 62, 222, 0, 63, 15, 0, 63, 15, 128, 63, 15,
  128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128,
  62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62,
  15, 128, 62, 15, 128, 62, 15, 128, 255, 191, 224, 16, 19, 38, 20, 2,
  0, 7, 192, 12, 112, 28, 56, 56, 60, 120, 30, 120, 30, 248, 30, 248,
  31, 248, 31, 248, 31, 248, 31, 248, 31, 248, 30, 120, 30, 120, 30, 56,
  60, 28, 56, 12, 112, 7, 192, 18, 28, 84, 21, 1, 247, 255, 60, 0,
  31, 78, 0, 31, 143, 0, 31, 135, 128, 31, 7, 128, 31, 7, 128, 31,
  7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7,
  192, 31, 7, 192, 31, 7, 128, 31, 7, 128, 31, 135, 128, 31, 143, 0,
  31, 78, 0, 31, 60, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31,
  0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 255, 192,
  0, 17, 28, 84, 20, 2, 247, 7, 130, 0, 28, 194, 0, 60, 102, 0,
  120, 126, 0, 120, 62, 0, 120, 62, 0, 248, 62, 0, 248, 62, 0, 248,
  62, 0, 248, 62, 0, 248, 62, 0, 248, 62, 0, 248, 62, 0, 120, 62,
  0, 120, 62, 0, 120, 126, 0, 60, 126, 0, 28, 190, 0, 15, 62, 0,
  0, 62, 0, 0, 62, 0, 0, 62, 0, 0, 62, 0, 0, 62, 0, 0,
  62, 0, 0, 62, 0, 0, 62, 0, 0, 255, 128, 14, 19, 38, 17, 2,
  0, 254, 48, 62, 120, 62, 188, 63, 60, 63, 124, 62, 124, 62, 56, 62,
  0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62,
  0, 62, 0, 62, 0, 255, 128, 13, 19, 38, 16, 2, 0, 31, 16, 97,
  208, 96, 112, 224, 48, 224, 48, 240, 16, 248, 0, 126, 0, 127, 128, 63,
  224, 15, 240, 135, 240, 193, 248, 192, 120, 224, 56, 224, 24, 240, 16, 156,
  48, 135, 192, 12, 27, 54, 14, 1, 0, 6, 0, 6, 0, 6, 0, 6,
  0, 6, 0, 14, 0, 30, 0, 62, 0, 255, 224, 62, 0, 62, 0, 62,
  0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 16, 62,
  16, 62, 16, 62, 16, 62, 16, 62, 32, 62, 32, 31, 192, 7, 128, 19,
  19, 57, 21, 1, 0, 254, 63, 128, 62, 15, 128, 62, 15, 128, 62, 15,
  128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128,
  62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62,
  31, 128, 62, 31, 128, 30, 47, 128, 30, 79, 128, 7, 143, 224, 18, 19,
  57, 20, 1, 0, 255, 143, 192, 62, 3, 0, 30, 2, 0, 30, 2, 0,
  31, 2, 0, 15, 4, 0, 15, 4, 0, 15, 132, 0, 7, 136, 0, 7,
  200, 0, 7, 216, 0, 3, 208, 0, 3, 240, 0, 3, 240, 0, 1, 224,
  0, 1, 224, 0, 0, 224, 0, 0, 192, 0, 0, 192, 0, 28, 19, 76,
  30, 1, 0, 255, 63, 231, 240, 62, 15, 129, 192, 30, 7, 129, 128, 30,
  7, 129, 128, 31, 7, 193, 0, 15, 7, 193, 0, 15, 7, 195, 0, 15,
  143, 226, 0, 7, 137, 226, 0, 7, 137, 230, 0, 7, 217, 244, 0, 3,
  208, 244, 0, 3, 240, 248, 0, 3, 240, 248, 0, 1, 224, 248, 0, 1,
  224, 112, 0, 1, 192, 112, 0, 0, 192, 112, 0, 0, 192, 32, 0, 18,
  19, 57, 20, 1, 0, 255, 63, 128, 126, 14, 0, 62, 12, 0, 31, 8,
  0, 31, 16, 0, 15, 176, 0, 15, 160, 0, 7, 192, 0, 3, 192, 0,
  3, 224, 0, 1, 240, 0, 3, 240, 0, 2, 248, 0, 4, 248, 0, 12,
  124, 0, 8, 126, 0, 24, 62, 0, 56, 63, 0, 254, 127, 192, 19, 28,
  84, 20, 0, 247, 255, 207, 224, 63, 3, 128, 31, 3, 0, 31, 2, 0,
  15, 2, 0, 15, 130, 0, 15, 130, 0, 7, 196, 0, 7, 196, 0, 3,
  196, 0, 3, 232, 0, 3, 232, 0, 1, 248, 0, 1, 248, 0, 0, 240,
  0, 0, 240, 0, 0, 112, 0, 0, 96, 0, 0, 96, 0, 0, 32, 0,
  0, 64, 0, 12, 64, 0, 30, 64, 0, 62, 64, 0, 62, 128, 0, 60,
  128, 0, 29, 0, 0, 14, 0, 0, 14, 19, 38, 17, 1, 0, 127, 252,
  120, 124, 112, 248, 96, 248, 65, 240, 65, 224, 67, 224, 3, 192, 7, 192,
  7, 128, 15, 128, 31, 4, 31, 4, 62, 4, 62, 12, 124, 12, 120, 28,
  248, 60, 255, 252, 12, 35, 70, 16, 2, 249, 1, 240, 7, 128, 15, 0,
  15, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 30, 0, 30, 0, 56, 0, 224, 0, 56, 0,
  30, 0, 30, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 15, 0, 15, 0, 7, 128, 1, 240,
  3, 36, 36, 11, 4, 248, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 12, 37, 74, 16, 2, 248,
  128, 0, 240, 0, 28, 0, 15, 0, 15, 0, 15, 128, 15, 128, 15, 128,
  15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128,
  7, 128, 3, 192, 0, 112, 3, 192, 7, 128, 15, 128, 15, 128, 15, 128,
  15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128,
  15, 0, 15, 0, 28, 0, 248, 0, 128, 0, 21, 8, 24, 25, 2, 6,
  62, 0, 48, 127, 192, 16, 255, 240, 8, 135, 252, 8, 129, 255, 24, 128,
  127, 248, 192, 31, 240, 96, 3, 224, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 11, 0, 0, 6,
  29, 29, 10, 2, 247, 120, 252, 252, 252, 252, 120, 0, 0, 32, 48, 48,
  48, 48, 48, 48, 48, 112, 120, 120, 120, 120, 252, 252, 252, 252, 252, 252,
  120, 120, 14, 28, 56, 22, 4, 251, 1, 128, 1, 128, 1, 128, 1, 128,
  3, 192, 15, 176, 29, 152, 61, 152, 121, 184, 121, 184, 249, 184, 249, 184,
  249, 128, 249, 128, 249, 128, 249, 128, 249, 128, 249, 132, 121, 132, 121, 132,
  61, 136, 29, 152, 15, 176, 3, 192, 1, 128, 1, 128, 1, 128, 1, 128,
  23, 29, 87, 27, 2, 0, 0, 1, 0, 0, 30, 224, 0, 120, 16, 0,
  248, 24, 0, 240, 28, 1, 240, 60, 1, 240, 124, 3, 240, 124, 3, 240,
  120, 3, 240, 0, 3, 240, 0, 3, 240, 0, 3, 240, 0, 31, 240, 64,
  1, 255, 128, 1, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0,
  120, 0, 0, 120, 0, 0, 112, 0, 0, 112, 6, 60, 112, 4, 127, 224,
  28, 131, 255, 248, 129, 255, 240, 195, 63, 224, 124, 31, 192, 18, 20, 60,
  21, 2, 3, 0, 0, 128, 195, 225, 128, 239, 249, 192, 255, 255, 128, 120,
  15, 0, 112, 7, 0, 96, 3, 0, 224, 1, 128, 192, 1, 128, 192, 1,
  128, 192, 1, 128, 192, 1, 128, 224, 1, 128, 96, 3, 0, 112, 7, 0,
  120, 15, 0, 255, 255, 128, 239, 249, 192, 195, 225, 128, 0, 0, 128, 21,
  28, 84, 23, 1, 0, 255, 195, 248, 63, 0, 224, 63, 0, 192, 31, 128,
  192, 31, 128, 128, 31, 192, 128, 15, 193, 0, 15, 193, 0, 7, 227, 0,
  7, 226, 0, 7, 246, 0, 3, 244, 0, 3, 252, 0, 1, 248, 0, 63,
  255, 192, 1, 248, 0, 1, 248, 0, 1, 248, 0, 63, 255, 192, 1, 248,
  0, 1, 248, 0, 1, 248, 0, 1, 248, 0, 1, 248, 0, 1, 248, 0,
  1, 248, 0, 1, 248, 0, 15, 255, 128, 3, 35, 35, 11, 4, 249, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 0, 0, 0,
  0, 0, 0, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 17, 36, 108, 24, 2, 248, 1, 240, 0, 6, 12, 0, 12, 6,
  0, 24, 7, 0, 56, 31, 0, 56, 63, 0, 56, 63, 0, 56, 62, 0,
  60, 28, 0, 63, 0, 0, 63, 192, 0, 31, 224, 0, 63, 248, 0, 103,
  254, 0, 67, 255, 0, 192, 255, 0, 192, 63, 128, 224, 15, 128, 248, 3,
  128, 254, 1, 128, 127, 129, 128, 127, 225, 0, 63, 249, 0, 15, 254, 0,
  3, 254, 0, 0, 254, 0, 0, 63, 0, 14, 15, 0, 31, 7, 0, 63,
  7, 0, 63, 7, 0, 62, 7, 0, 56, 6, 0, 24, 12, 0, 12, 24,
  0, 7, 240, 0, 12, 5, 10, 16, 2, 22, 112, 224, 249, 240, 249, 240,
  249, 240, 112, 224, 28, 28, 112, 32, 2, 1, 0, 127, 224, 0, 1, 128,
  24, 0, 6, 0, 12, 0, 12, 0, 3, 0, 24, 0, 1, 0, 16, 30,
  33, 128, 48, 113, 160, 192, 96, 224, 224, 64, 97, 224, 96, 96, 97, 224,
  96, 96, 193, 224, 32, 32, 195, 224, 32, 48, 195, 224, 32, 48, 195, 224,
  0, 48, 195, 224, 0, 48, 195, 224, 0, 48, 195, 224, 16, 48, 193, 224,
  16, 32, 65, 224, 48, 96, 97, 224, 32, 96, 96, 240, 96, 64, 48, 112,
  192, 192, 16, 31, 1, 128, 24, 0, 1, 0, 12, 0, 3, 0, 6, 0,
  12, 0, 1, 128, 24, 0, 0, 127, 224, 0, 11, 14, 28, 15, 2, 14,
  30, 0, 35, 0, 99, 128, 115, 128, 115, 128, 15, 128, 51, 128, 99, 128,
  227, 128, 227, 160, 227, 160, 125, 192, 0, 0, 255, 224, 10, 16, 32, 18,
  4, 1, 24, 64, 48, 192, 112, 128, 97, 128, 225, 128, 227, 128, 227, 128,
  227, 128, 227, 128, 227, 128, 227, 128, 97, 128, 97, 128, 48, 192, 24, 64,
  8, 0, 19, 11, 33, 22, 2, 5, 255, 255, 224, 255, 255, 224, 255, 255,
  224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224,
  0, 0, 224, 0, 0, 224, 0, 0, 224, 10, 4, 8, 14, 2, 8, 255,
  192, 255, 192, 255, 192, 255, 192, 28, 28, 112, 32, 2, 1, 0, 127, 224,
  0, 1, 128, 24, 0, 6, 0, 12, 0, 12, 0, 3, 0, 24, 0, 1,
  0, 19, 255, 193, 128, 48, 249, 224, 192, 96, 248, 240, 64, 96, 248, 248,
  96, 96, 248, 248, 96, 192, 248, 248, 32, 192, 248, 240, 48, 192, 249, 224,
  48, 192, 254, 0, 48, 192, 249, 192, 48, 192, 249, 224, 48, 192, 249, 240,
  48, 192, 249, 240, 32, 64, 249, 242, 96, 96, 249, 242, 96, 96, 249, 242,
  64, 48, 249, 246, 192, 19, 254, 253, 128, 24, 0, 121, 0, 12, 0, 3,
  0, 6, 0, 12, 0, 1, 128, 24, 0, 0, 127, 224, 0, 10, 3, 6,
  16, 3, 23, 255, 192, 255, 192, 255, 192, 12, 11, 22, 22, 5, 18, 31,
  128, 127, 224, 112, 96, 224, 48, 192, 48, 192, 48, 192, 48, 224, 112, 112,
  224, 63, 192, 31, 128, 32, 29, 116, 36, 2, 254, 0, 1, 192, 0, 0,
  1, 192, 0, 0, 1, 192, 0, 0, 1, 192, 0, 0, 1, 192, 0, 0,
  1, 192, 0, 0, 1, 192, 0, 0, 1, 192, 0, 0, 1, 192, 0, 0,
  1, 192, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,
  1, 192, 0, 0, 1, 192, 0, 0, 1, 192, 0, 0, 1, 192, 0, 0,
  1, 192, 0, 0, 1, 192, 0, 0, 1, 192, 0, 0, 1, 192, 0, 0,
  1, 192, 0, 0, 1, 192, 0, 0, 1, 192, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 11,
  17, 34, 17, 3, 11, 31, 0, 99, 192, 225, 224, 225, 224, 241, 224, 241,
  224, 115, 192, 7, 128, 14, 0, 28, 0, 48, 32, 96, 32, 64, 96, 255,
  224, 255, 224, 143, 192, 135, 128, 12, 18, 36, 16, 2, 10, 31, 0, 51,
  192, 97, 224, 113, 224, 121, 224, 121, 224, 1, 192, 3, 128, 30, 0, 3,
  192, 1, 224, 1, 240, 121, 240, 249, 240, 241, 240, 225, 224, 99, 192, 31,
  0, 7, 7, 7, 17, 7, 21, 14, 30, 30, 60, 120, 96, 192, 19, 30,
  90, 22, 2, 245, 112, 28, 0, 112, 28, 0, 248, 62, 0, 248, 62, 0,
  248, 62, 0, 248, 62, 0, 248, 62, 0, 240, 62, 0, 240, 62, 0, 240,
  62, 0, 112, 28, 0, 112, 28, 0, 96, 28, 32, 96, 24, 32, 32, 56,
  96, 32, 127, 224, 61, 255, 192, 47, 231, 192, 39, 195, 192, 32, 0, 0,
  32, 0, 0, 112, 0, 0, 112, 0, 0, 120, 0, 0, 120, 0, 0, 124,
  0, 0, 124, 0, 0, 124, 0, 0, 124, 0, 0, 56, 0, 0, 18, 33,
  99, 23, 3, 251, 15, 255, 192, 63, 206, 0, 127, 206, 0, 127, 206, 0,
  255, 206, 0, 255, 206, 0, 255, 206, 0, 255, 206, 0, 255, 206, 0, 255,
  206, 0, 255, 206, 0, 255, 206, 0, 127, 206, 0, 63, 206, 0, 7, 206,
  0, 1, 206, 0, 1, 206, 0, 1, 206, 0, 1, 206, 0, 1, 206, 0,
  1, 206, 0, 1, 206, 0, 1, 206, 0, 1, 206, 0, 1, 206, 0, 1,
  206, 0, 1, 206, 0, 1, 206, 0, 1, 206, 0, 1, 206, 0, 1, 206,
  0, 1, 206, 0, 1, 206, 0, 6, 6, 6, 10, 2, 10, 120, 252, 252,
  252, 252, 120, 7, 8, 8, 17, 5, 248, 32, 32, 56, 12, 14, 14, 14,
  252, 8, 17, 17, 16, 4, 11, 12, 28, 252, 60, 60, 60, 60, 60, 60,
  60, 60, 60, 60, 60, 60, 60, 255, 10, 14, 28, 14, 2, 14, 30, 0,
  51, 0, 115, 128, 243, 192, 243, 192, 243, 192, 243, 192, 243, 192, 243, 192,
  115, 128, 51, 0, 30, 0, 0, 0, 255, 192, 10, 16, 32, 18, 4, 1,
  6, 0, 131, 0, 195, 0, 97, 128, 97, 128, 113, 192, 113, 192, 113, 192,
  113, 192, 113, 192, 97, 192, 97, 128, 65, 128, 195, 0, 134, 0, 4, 0,
  28, 29, 116, 34, 4, 0, 0, 0, 12, 0, 12, 0, 12, 0, 28, 0,
  24, 0, 252, 0, 24, 0, 60, 0, 48, 0, 60, 0, 32, 0, 60, 0,
  96, 0, 60, 0, 192, 0, 60, 0, 192, 0, 60, 1, 128, 0, 60, 1,
  128, 0, 60, 3, 0, 0, 60, 2, 3, 128, 60, 6, 3, 128, 60, 12,
  7, 128, 60, 12, 15, 128, 60, 24, 15, 128, 255, 24, 31, 128, 0, 48,
  23, 128, 0, 32, 39, 128, 0, 96, 103, 128, 0, 192, 71, 128, 0, 192,
  199, 128, 1, 128, 255, 240, 1, 128, 7, 128, 3, 0, 7, 128, 2, 0,
  7, 128, 6, 0, 7, 128, 12, 0, 63, 240, 27, 29, 116, 34, 4, 0,
  0, 0, 12, 0, 12, 0, 24, 0, 28, 0, 24, 0, 252, 0, 48, 0,
  60, 0, 48, 0, 60, 0, 96, 0, 60, 0, 96, 0, 60, 0, 192, 0,
  60, 1, 128, 0, 60, 1, 128, 0, 60, 3, 0, 0, 60, 3, 31, 0,
  60, 6, 115, 192, 60, 6, 225, 224, 60, 12, 225, 224, 60, 8, 241, 224,
  255, 24, 241, 224, 0, 48, 115, 192, 0, 48, 3, 128, 0, 96, 7, 0,
  0, 96, 14, 0, 0, 192, 24, 0, 0, 128, 48, 32, 1, 128, 64, 32,
  3, 0, 64, 96, 3, 0, 191, 224, 6, 0, 255, 224, 6, 0, 159, 192,
  12, 0, 135, 128, 30, 29, 116, 34, 2, 0, 0, 0, 3, 0, 31, 0,
  3, 0, 51, 192, 6, 0, 97, 224, 4, 0, 113, 224, 12, 0, 121, 224,
  8, 0, 121, 224, 24, 0, 1, 192, 48, 0, 3, 128, 48, 0, 30, 0,
  96, 0, 3, 192, 64, 0, 1, 224, 192, 0, 49, 240, 128, 224, 249, 241,
  128, 224, 249, 243, 1, 224, 225, 226, 3, 224, 99, 230, 3, 224, 63, 132,
  5, 224, 0, 12, 5, 224, 0, 8, 9, 224, 0, 16, 25, 224, 0, 48,
  17, 224, 0, 32, 49, 224, 0, 96, 63, 252, 0, 64, 1, 224, 0, 192,
  1, 224, 0, 128, 1, 224, 1, 0, 1, 224, 3, 0, 15, 252, 12, 29,
  58, 18, 3, 247, 30, 0, 63, 0, 63, 0, 63, 0, 63, 0, 30, 0,
  0, 0, 14, 0, 17, 0, 32, 128, 32, 128, 32, 128, 1, 128, 3, 0,
  3, 0, 6, 0, 14, 0, 28, 0, 60, 96, 120, 32, 120, 48, 248, 16,
  248, 16, 248, 16, 248, 16, 248, 48, 124, 96, 63, 192, 31, 128, 26, 37,
  148, 29, 2, 0, 0, 224, 0, 0, 0, 240, 0, 0, 0, 240, 0, 0,
  0, 120, 0, 0, 0, 56, 0, 0, 0, 12, 0, 0, 0, 6, 0, 0,
  0, 0, 0, 0, 0, 4, 0, 0, 0, 6, 0, 0, 0, 14, 0, 0,
  0, 14, 0, 0, 0, 15, 0, 0, 0, 31, 0, 0, 0, 31, 0, 0,
  0, 31, 128, 0, 0, 63, 128, 0, 0, 47, 128, 0, 0, 47, 192, 0,
  0, 111, 192, 0, 0, 79, 192, 0, 0, 71, 192, 0, 0, 199, 224, 0,
  0, 135, 224, 0, 0, 131, 224, 0, 1, 131, 240, 0, 1, 3, 240, 0,
  3, 1, 240, 0, 3, 255, 248, 0, 2, 1, 248, 0, 6, 0, 248, 0,
  6, 0, 252, 0, 4, 0, 252, 0, 12, 0, 252, 0, 12, 0, 124, 0,
  30, 0, 254, 0, 255, 199, 255, 192, 26, 37, 148, 29, 2, 0, 0, 0,
  224, 0, 0, 0, 224, 0, 0, 1, 224, 0, 0, 3, 192, 0, 0, 3,
  128, 0, 0, 6, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 4,
  0, 0, 0, 6, 0, 0, 0, 14, 0, 0, 0, 14, 0, 0, 0, 31,
  0, 0, 0, 31, 0, 0, 0, 31, 0, 0, 0, 63, 128, 0, 0, 63,
  128, 0, 0, 47, 128, 0, 0, 111, 192, 0, 0, 111, 192, 0, 0, 79,
  192, 0, 0, 199, 192, 0, 0, 199, 224, 0, 0, 135, 224, 0, 1, 131,
  224, 0, 1, 131, 240, 0, 1, 3, 240, 0, 3, 1, 240, 0, 3, 255,
  248, 0, 2, 1, 248, 0, 6, 0, 248, 0, 6, 0, 252, 0, 4, 0,
  252, 0, 12, 0, 252, 0, 12, 0, 126, 0, 62, 0, 255, 0, 255, 199,
  255, 192, 26, 37, 148, 29, 2, 0, 0, 4, 0, 0, 0, 14, 0, 0,
  0, 14, 0, 0, 0, 31, 0, 0, 0, 59, 128, 0, 0, 224, 192, 0,
  1, 128, 48, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 6, 0, 0,
  0, 14, 0, 0, 0, 14, 0, 0, 0, 15, 0, 0, 0, 31, 0, 0,
  0, 31, 0, 0, 0, 31, 128, 0, 0, 63, 128, 0, 0, 47, 128, 0,
  0, 47, 192, 0, 0, 111, 192, 0, 0, 79, 192, 0, 0, 71, 192, 0,
  0, 199, 224, 0, 0, 135, 224, 0, 0, 131, 224, 0, 1, 131, 240, 0,
  1, 3, 240, 0, 3, 1, 240, 0, 3, 255, 248, 0, 2, 1, 248, 0,
  6, 0, 248, 0, 6, 0, 252, 0, 4, 0, 252, 0, 12, 0, 252, 0,
  12, 0, 124, 0, 30, 0, 254, 0, 255, 199, 255, 192, 26, 36, 144, 29,
  2, 0, 0, 56, 32, 0, 0, 126, 32, 0, 0, 255, 224, 0, 0, 143,
  192, 0, 0, 131, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 6, 0, 0, 0, 14, 0, 0, 0, 14, 0, 0, 0, 15,
  0, 0, 0, 31, 0, 0, 0, 31, 0, 0, 0, 63, 128, 0, 0, 63,
  128, 0, 0, 47, 128, 0, 0, 111, 192, 0, 0, 111, 192, 0, 0, 79,
  192, 0, 0, 199, 192, 0, 0, 199, 224, 0, 0, 135, 224, 0, 1, 131,
  224, 0, 1, 131, 240, 0, 1, 3, 240, 0, 3, 1, 240, 0, 3, 255,
  248, 0, 2, 1, 248, 0, 6, 0, 248, 0, 6, 0, 252, 0, 4, 0,
  252, 0, 12, 0, 252, 0, 12, 0, 126, 0, 62, 0, 255, 0, 255, 199,
  255, 192, 26, 36, 144, 29, 2, 0, 0, 224, 224, 0, 1, 241, 240, 0,
  1, 241, 240, 0, 1, 241, 240, 0, 0, 224, 224, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 4, 0, 0, 0, 14, 0, 0, 0, 14, 0, 0,
  0, 14, 0, 0, 0, 31, 0, 0, 0, 31, 0, 0, 0, 31, 0, 0,
  0, 63, 128, 0, 0, 63, 128, 0, 0, 63, 128, 0, 0, 111, 192, 0,
  0, 111, 192, 0, 0, 79, 192, 0, 0, 199, 192, 0, 0, 199, 224, 0,
  0, 135, 224, 0, 1, 131, 224, 0, 1, 131, 240, 0, 1, 3, 240, 0,
  3, 1, 240, 0, 3, 255, 248, 0, 2, 1, 248, 0, 6, 0, 248, 0,
  6, 0, 252, 0, 4, 0, 252, 0, 12, 0, 124, 0, 12, 0, 124, 0,
  30, 0, 126, 0, 255, 199, 255, 192, 26, 37, 148, 29, 2, 0, 0, 31,
  0, 0, 0, 63, 128, 0, 0, 97, 192, 0, 0, 96, 192, 0, 0, 96,
  192, 0, 0, 113, 192, 0, 0, 63, 128, 0, 0, 30, 0, 0, 0, 0,
  0, 0, 0, 6, 0, 0, 0, 14, 0, 0, 0, 14, 0, 0, 0, 15,
  0, 0, 0, 31, 0, 0, 0, 31, 0, 0, 0, 31, 128, 0, 0, 63,
  128, 0, 0, 63, 128, 0, 0, 47, 128, 0, 0, 111, 192, 0, 0, 79,
  192, 0, 0, 71, 192, 0, 0, 135, 224, 0, 0, 135, 224, 0, 0, 131,
  224, 0, 1, 3, 240, 0, 1, 3, 240, 0, 3, 1, 240, 0, 3, 255,
  248, 0, 2, 1, 248, 0, 6, 0, 248, 0, 4, 0, 252, 0, 4, 0,
  252, 0, 12, 0, 252, 0, 12, 0, 124, 0, 28, 0, 254, 0, 255, 199,
  255, 192, 36, 28, 140, 38, 1, 0, 0, 7, 255, 255, 224, 0, 1, 254,
  3, 224, 0, 1, 254, 1, 224, 0, 1, 254, 0, 224, 0, 1, 254, 0,
  224, 0, 3, 126, 0, 96, 0, 3, 126, 0, 96, 0, 6, 126, 0, 32,
  0, 6, 126, 4, 32, 0, 12, 126, 4, 0, 0, 12, 126, 12, 0, 0,
  24, 126, 12, 0, 0, 24, 126, 28, 0, 0, 48, 127, 252, 0, 0, 48,
  126, 60, 0, 0, 96, 126, 28, 0, 0, 96, 126, 12, 0, 0, 192, 126,
  4, 48, 0, 192, 126, 4, 48, 1, 255, 254, 4, 48, 1, 128, 126, 0,
  48, 3, 0, 126, 0, 112, 3, 0, 126, 0, 112, 6, 0, 126, 0, 240,
  6, 0, 126, 0, 240, 14, 0, 126, 1, 240, 63, 0, 126, 7, 240, 255,
  199, 255, 255, 240, 21, 37, 111, 26, 3, 248, 1, 254, 48, 7, 3, 48,
  14, 1, 240, 30, 0, 240, 60, 0, 240, 60, 0, 112, 124, 0, 112, 124,
  0, 48, 124, 0, 48, 252, 0, 48, 252, 0, 48, 252, 0, 16, 252, 0,
  0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 24,
  252, 0, 24, 124, 0, 16, 124, 0, 16, 124, 0, 16, 60, 0, 48, 60,
  0, 32, 30, 0, 96, 14, 0, 192, 7, 1, 128, 1, 254, 0, 0, 32,
  0, 0, 96, 0, 0, 120, 0, 0, 28, 0, 0, 14, 0, 0, 14, 0,
  0, 14, 0, 2, 28, 0, 1, 248, 0, 22, 37, 111, 26, 2, 0, 1,
  128, 0, 1, 192, 0, 1, 224, 0, 0, 224, 0, 0, 112, 0, 0, 24,
  0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 255, 255, 252, 15, 192, 124,
  15, 192, 60, 15, 192, 28, 15, 192, 28, 15, 192, 12, 15, 192, 12, 15,
  192, 12, 15, 193, 4, 15, 193, 0, 15, 195, 0, 15, 195, 0, 15, 199,
  0, 15, 255, 0, 15, 199, 0, 15, 195, 0, 15, 195, 0, 15, 193, 4,
  15, 193, 4, 15, 193, 4, 15, 192, 12, 15, 192, 12, 15, 192, 12, 15,
  192, 28, 15, 192, 28, 15, 192, 60, 15, 192, 252, 255, 255, 252, 22, 37,
  111, 26, 2, 0, 0, 1, 192, 0, 3, 192, 0, 3, 192, 0, 7, 128,
  0, 14, 0, 0, 12, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 255,
  255, 252, 15, 192, 124, 15, 192, 60, 15, 192, 28, 15, 192, 28, 15, 192,
  12, 15, 192, 12, 15, 192, 4, 15, 193, 4, 15, 193, 0, 15, 195, 0,
  15, 195, 0, 15, 199, 0, 15, 255, 0, 15, 199, 0, 15, 195, 0, 15,
  195, 0, 15, 193, 4, 15, 193, 4, 15, 193, 4, 15, 192, 4, 15, 192,
  12, 15, 192, 12, 15, 192, 28, 15, 192, 28, 15, 192, 60, 15, 192, 252,
  255, 255, 252, 22, 37, 111, 26, 2, 0, 0, 8, 0, 0, 24, 0, 0,
  60, 0, 0, 126, 0, 0, 231, 0, 1, 193, 128, 3, 0, 64, 0, 0,
  0, 0, 0, 0, 255, 255, 252, 15, 192, 124, 15, 192, 60, 15, 192, 28,
  15, 192, 28, 15, 192, 12, 15, 192, 12, 15, 192, 12, 15, 193, 4, 15,
  193, 0, 15, 195, 0, 15, 195, 0, 15, 199, 0, 15, 255, 0, 15, 199,
  0, 15, 195, 0, 15, 195, 0, 15, 193, 4, 15, 193, 4, 15, 193, 4,
  15, 192, 12, 15, 192, 12, 15, 192, 12, 15, 192, 28, 15, 192, 28, 15,
  192, 60, 15, 192, 252, 255, 255, 252, 22, 36, 108, 26, 2, 0, 1, 193,
  192, 3, 227, 224, 3, 227, 224, 3, 227, 224, 1, 193, 192, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 255, 255, 252, 15, 192, 124, 15, 192, 60, 15,
  192, 28, 15, 192, 28, 15, 192, 12, 15, 192, 12, 15, 192, 4, 15, 193,
  4, 15, 193, 0, 15, 195, 0, 15, 195, 0, 15, 199, 0, 15, 255, 0,
  15, 199, 0, 15, 195, 0, 15, 195, 0, 15, 193, 4, 15, 193, 4, 15,
  193, 4, 15, 192, 4, 15, 192, 12, 15, 192, 12, 15, 192, 28, 15, 192,
  28, 15, 192, 60, 15, 192, 252, 255, 255, 252, 13, 37, 74, 17, 2, 0,
  96, 0, 112, 0, 120, 0, 56, 0, 28, 0, 14, 0, 2, 0, 0, 0,
  0, 0, 255, 248, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 255, 248, 13, 37, 74, 17, 2, 0,
  0, 112, 0, 240, 1, 240, 1, 224, 3, 128, 7, 0, 4, 0, 0, 0,
  0, 0, 255, 248, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 255, 248, 13, 37, 74, 17, 2, 0,
  6, 0, 6, 0, 15, 0, 31, 128, 57, 192, 112, 112, 192, 24, 0, 0,
  0, 0, 255, 248, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 255, 248, 13, 36, 72, 16, 2, 0,
  112, 112, 248, 248, 248, 248, 248, 248, 112, 112, 0, 0, 0, 0, 0, 0,
  255, 248, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 255, 248, 25, 28, 112, 29, 2, 0, 255, 255,
  128, 0, 31, 128, 224, 0, 31, 128, 112, 0, 31, 128, 56, 0, 31, 128,
  60, 0, 31, 128, 30, 0, 31, 128, 30, 0, 31, 128, 31, 0, 31, 128,
  31, 0, 31, 128, 31, 0, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 255, 248, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 0, 31, 128, 31, 0, 31, 128,
  31, 0, 31, 128, 30, 0, 31, 128, 30, 0, 31, 128, 60, 0, 31, 128,
  56, 0, 31, 128, 112, 0, 31, 128, 224, 0, 255, 255, 128, 0, 27, 36,
  144, 30, 2, 0, 0, 24, 0, 0, 0, 62, 32, 0, 0, 127, 224, 0,
  0, 71, 192, 0, 0, 1, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 255, 128, 255, 224, 31, 192, 63, 0, 31, 192, 30, 0,
  15, 224, 12, 0, 7, 240, 12, 0, 7, 240, 12, 0, 7, 248, 12, 0,
  7, 248, 12, 0, 6, 252, 12, 0, 6, 254, 12, 0, 6, 126, 12, 0,
  6, 63, 12, 0, 6, 63, 140, 0, 6, 31, 140, 0, 6, 31, 204, 0,
  6, 15, 236, 0, 6, 7, 236, 0, 6, 7, 252, 0, 6, 3, 252, 0,
  6, 1, 252, 0, 6, 1, 252, 0, 6, 0, 252, 0, 6, 0, 252, 0,
  6, 0, 124, 0, 6, 0, 60, 0, 15, 0, 60, 0, 31, 128, 28, 0,
  255, 224, 12, 0, 22, 37, 111, 27, 3, 1, 7, 128, 0, 7, 128, 0,
  3, 192, 0, 1, 192, 0, 0, 224, 0, 0, 112, 0, 0, 16, 0, 0,
  0, 0, 0, 0, 0, 1, 254, 0, 3, 3, 0, 6, 1, 128, 14, 1,
  192, 28, 0, 224, 60, 0, 240, 60, 0, 240, 124, 0, 248, 124, 0, 248,
  124, 0, 248, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252,
  0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 124, 0, 248, 124, 0,
  248, 124, 0, 248, 60, 0, 240, 60, 0, 240, 28, 0, 224, 14, 1, 192,
  6, 1, 128, 3, 3, 0, 1, 254, 0, 22, 37, 111, 27, 3, 1, 0,
  7, 128, 0, 7, 128, 0, 15, 0, 0, 14, 0, 0, 28, 0, 0, 56,
  0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 1, 254, 0, 3, 3, 0,
  6, 1, 128, 14, 1, 192, 28, 0, 224, 60, 0, 240, 60, 0, 240, 124,
  0, 248, 124, 0, 248, 124, 0, 248, 252, 0, 252, 252, 0, 252, 252, 0,
  252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252,
  124, 0, 248, 124, 0, 248, 124, 0, 248, 60, 0, 240, 60, 0, 240, 28,
  0, 224, 14, 1, 192, 6, 1, 128, 3, 3, 0, 1, 254, 0, 22, 37,
  111, 27, 3, 0, 0, 48, 0, 0, 48, 0, 0, 120, 0, 0, 252, 0,
  1, 206, 0, 3, 135, 0, 6, 1, 128, 0, 0, 0, 0, 0, 0, 1,
  254, 0, 3, 3, 0, 6, 1, 128, 14, 1, 192, 28, 0, 224, 60, 0,
  240, 60, 0, 240, 124, 0, 248, 124, 0, 248, 124, 0, 248, 252, 0, 252,
  252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252,
  0, 252, 252, 0, 252, 124, 0, 248, 124, 0, 248, 124, 0, 248, 60, 0,
  240, 60, 0, 240, 28, 0, 224, 14, 1, 192, 6, 1, 128, 3, 3, 0,
  1, 254, 0, 22, 36, 108, 27, 3, 0, 1, 192, 128, 3, 241, 128, 3,
  255, 0, 4, 63, 0, 4, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 254, 0, 3, 3, 0, 6, 1, 128, 14, 1, 192, 28, 0, 224,
  60, 0, 240, 60, 0, 240, 124, 0, 248, 124, 0, 248, 124, 0, 248, 252,
  0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0,
  252, 252, 0, 252, 252, 0, 252, 124, 0, 248, 124, 0, 248, 124, 0, 248,
  60, 0, 240, 60, 0, 240, 28, 0, 224, 14, 1, 192, 6, 1, 128, 3,
  3, 0, 1, 254, 0, 22, 36, 108, 27, 3, 0, 3, 131, 128, 7, 199,
  192, 7, 199, 192, 7, 199, 192, 3, 131, 128, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 1, 254, 0, 3, 3, 0, 6, 1, 128, 14, 1, 192, 28,
  0, 224, 60, 0, 240, 60, 0, 240, 124, 0, 248, 124, 0, 248, 124, 0,
  248, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252,
  252, 0, 252, 252, 0, 252, 252, 0, 252, 124, 0, 248, 124, 0, 248, 124,
  0, 248, 60, 0, 240, 60, 0, 240, 28, 0, 224, 14, 1, 192, 6, 1,
  128, 3, 3, 0, 1, 254, 0, 24, 25, 75, 36, 6, 254, 64, 0, 2,
  224, 0, 7, 240, 0, 14, 120, 0, 28, 60, 0, 60, 30, 0, 120, 15,
  0, 240, 7, 129, 224, 3, 195, 192, 1, 231, 128, 0, 239, 0, 0, 126,
  0, 0, 60, 0, 0, 124, 0, 0, 254, 0, 1, 231, 0, 3, 195, 128,
  7, 129, 192, 15, 0, 224, 30, 0, 112, 60, 0, 56, 120, 0, 28, 112,
  0, 14, 224, 0, 7, 192, 0, 2, 22, 28, 84, 27, 3, 1, 1, 254,
  12, 3, 3, 152, 6, 3, 208, 14, 1, 240, 28, 1, 224, 60, 1, 240,
  60, 1, 240, 124, 1, 248, 124, 3, 248, 124, 6, 248, 252, 14, 252, 252,
  12, 252, 252, 24, 252, 252, 56, 252, 252, 112, 252, 252, 96, 252, 252, 192,
  252, 253, 192, 252, 125, 128, 248, 127, 0, 248, 126, 0, 248, 62, 0, 240,
  62, 0, 240, 30, 0, 224, 62, 1, 192, 46, 1, 128, 103, 3, 0, 193,
  254, 0, 26, 37, 148, 30, 3, 1, 0, 224, 0, 0, 0, 240, 0, 0,
  0, 120, 0, 0, 0, 56, 0, 0, 0, 28, 0, 0, 0, 12, 0, 0,
  0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 240, 127, 192,
  31, 128, 31, 0, 31, 128, 14, 0, 31, 128, 6, 0, 31, 128, 6, 0,
  31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0,
  31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0,
  31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0,
  31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0,
  31, 128, 6, 0, 15, 128, 12, 0, 15, 192, 12, 0, 7, 192, 24, 0,
  7, 224, 56, 0, 1, 252, 240, 0, 0, 255, 192, 0, 26, 37, 148, 30,
  3, 1, 0, 0, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 3,
  192, 0, 0, 7, 0, 0, 0, 6, 0, 0, 0, 12, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 255, 240, 127, 192, 31, 128, 31, 0, 31, 128,
  14, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128,
  6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128,
  6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128,
  6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128,
  6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 15, 128,
  12, 0, 15, 192, 12, 0, 7, 192, 24, 0, 7, 224, 56, 0, 1, 252,
  240, 0, 0, 255, 192, 0, 26, 37, 148, 30, 3, 0, 0, 4, 0, 0,
  0, 14, 0, 0, 0, 31, 0, 0, 0, 31, 128, 0, 0, 59, 192, 0,
  0, 224, 224, 0, 1, 128, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  255, 240, 127, 192, 31, 128, 31, 0, 31, 128, 14, 0, 31, 128, 6, 0,
  31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0,
  31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0,
  31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0,
  31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0,
  31, 128, 6, 0, 31, 128, 6, 0, 15, 128, 4, 0, 15, 128, 12, 0,
  7, 192, 24, 0, 7, 224, 24, 0, 1, 240, 112, 0, 0, 255, 192, 0,
  26, 36, 144, 30, 3, 0, 0, 224, 224, 0, 1, 241, 240, 0, 1, 241,
  240, 0, 1, 241, 240, 0, 0, 224, 224, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 255, 240, 127, 192, 31, 128, 31, 0, 31, 128,
  14, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128,
  6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128,
  6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128,
  6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128,
  6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 15, 128,
  12, 0, 15, 192, 12, 0, 7, 192, 24, 0, 7, 224, 56, 0, 1, 252,
  240, 0, 0, 255, 192, 0, 25, 37, 148, 28, 2, 0, 0, 0, 224, 0,
  0, 0, 224, 0, 0, 1, 224, 0, 0, 3, 192, 0, 0, 3, 128, 0,
  0, 6, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  255, 240, 255, 128, 31, 192, 60, 0, 31, 192, 24, 0, 15, 192, 24, 0,
  15, 224, 24, 0, 7, 224, 16, 0, 7, 224, 48, 0, 3, 240, 32, 0,
  3, 240, 32, 0, 1, 248, 96, 0, 1, 248, 64, 0, 1, 252, 64, 0,
  0, 252, 192, 0, 0, 254, 128, 0, 0, 127, 128, 0, 0, 127, 128, 0,
  0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0, 0,
  0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0, 0,
  0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0, 0, 1, 255, 224, 0,
  23, 28, 84, 27, 2, 0, 255, 248, 0, 31, 128, 0, 31, 128, 0, 31,
  128, 0, 31, 128, 0, 31, 255, 128, 31, 129, 224, 31, 128, 248, 31, 128,
  252, 31, 128, 124, 31, 128, 126, 31, 128, 126, 31, 128, 126, 31, 128, 126,
  31, 128, 126, 31, 128, 124, 31, 128, 252, 31, 128, 248, 31, 129, 224, 31,
  255, 128, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128,
  0, 31, 128, 0, 31, 128, 0, 255, 248, 0, 19, 28, 84, 22, 1, 0,
  0, 248, 0, 3, 156, 0, 7, 142, 0, 15, 15, 0, 15, 15, 0, 15,
  15, 0, 31, 15, 0, 31, 15, 0, 31, 14, 0, 31, 28, 0, 31, 112,
  0, 31, 12, 0, 31, 7, 0, 31, 7, 128, 31, 3, 192, 31, 3, 192,
  31, 3, 192, 31, 3, 224, 31, 3, 224, 31, 3, 224, 31, 3, 224, 31,
  3, 224, 31, 115, 224, 31, 243, 192, 31, 243, 192, 31, 227, 128, 31, 103,
  0, 255, 62, 0, 17, 28, 84, 20, 2, 0, 56, 0, 0, 60, 0, 0,
  60, 0, 0, 30, 0, 0, 14, 0, 0, 3, 0, 0, 1, 0, 0, 0,
  0, 0, 0, 0, 0, 15, 192, 0, 24, 240, 0, 48, 120, 0, 112, 120,
  0, 124, 124, 0, 124, 124, 0, 56, 124, 0, 1, 252, 0, 14, 124, 0,
  28, 124, 0, 56, 124, 0, 120, 124, 0, 248, 124, 0, 248, 124, 128, 248,
  124, 128, 248, 124, 128, 252, 253, 128, 127, 191, 0, 62, 30, 0, 17, 28,
  84, 20, 2, 0, 0, 48, 0, 0, 112, 0, 0, 240, 0, 0, 224, 0,
  1, 192, 0, 1, 128, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 15,
  192, 0, 24, 240, 0, 48, 120, 0, 112, 120, 0, 124, 124, 0, 124, 124,
  0, 124, 124, 0, 0, 252, 0, 7, 124, 0, 28, 124, 0, 56, 124, 0,
  120, 124, 0, 248, 124, 0, 248, 124, 128, 248, 124, 128, 248, 124, 128, 252,
  253, 128, 127, 191, 0, 62, 30, 0, 17, 28, 84, 20, 2, 0, 3, 0,
  0, 3, 128, 0, 7, 128, 0, 7, 192, 0, 12, 224, 0, 24, 112, 0,
  48, 24, 0, 0, 0, 0, 0, 0, 0, 15, 192, 0, 24, 240, 0, 48,
  120, 0, 112, 120, 0, 124, 124, 0, 124, 124, 0, 124, 124, 0, 0, 252,
  0, 7, 124, 0, 28, 124, 0, 56, 124, 0, 120, 124, 0, 248, 124, 0,
  248, 124, 128, 248, 124, 128, 248, 124, 128, 252, 253, 128, 127, 191, 0, 62,
  30, 0, 17, 27, 81, 20, 2, 0, 14, 8, 0, 31, 152, 0, 63, 240,
  0, 35, 240, 0, 32, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  15, 192, 0, 24, 240, 0, 48, 120, 0, 112, 120, 0, 124, 124, 0, 124,
  124, 0, 124, 124, 0, 0, 252, 0, 7, 124, 0, 28, 124, 0, 56, 124,
  0, 120, 124, 0, 248, 124, 0, 248, 124, 128, 248, 124, 128, 248, 124, 128,
  252, 253, 128, 127, 191, 0, 62, 30, 0, 17, 27, 81, 20, 2, 0, 56,
  112, 0, 124, 248, 0, 124, 248, 0, 124, 248, 0, 56, 112, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 15, 192, 0, 24, 240, 0, 48, 120, 0,
  112, 120, 0, 124, 124, 0, 124, 124, 0, 124, 124, 0, 0, 252, 0, 7,
  124, 0, 28, 124, 0, 56, 124, 0, 120, 124, 0, 248, 124, 0, 248, 124,
  128, 248, 124, 128, 248, 124, 128, 252, 253, 128, 127, 191, 0, 62, 30, 0,
  17, 28, 84, 20, 2, 1, 15, 192, 0, 12, 192, 0, 24, 96, 0, 24,
  96, 0, 24, 96, 0, 28, 224, 0, 15, 192, 0, 7, 128, 0, 0, 0,
  0, 15, 192, 0, 16, 240, 0, 48, 120, 0, 112, 120, 0, 120, 124, 0,
  124, 124, 0, 124, 124, 0, 0, 252, 0, 7, 124, 0, 28, 124, 0, 56,
  124, 0, 120, 124, 0, 248, 124, 0, 248, 124, 128, 248, 124, 128, 248, 124,
  128, 252, 253, 128, 127, 255, 0, 62, 62, 0, 23, 19, 57, 27, 2, 0,
  15, 195, 224, 24, 238, 112, 48, 124, 56, 112, 124, 60, 120, 124, 60, 124,
  124, 62, 124, 124, 62, 24, 124, 62, 3, 252, 62, 14, 127, 254, 60, 124,
  0, 120, 124, 0, 248, 124, 2, 248, 124, 2, 248, 124, 2, 248, 124, 4,
  252, 222, 4, 127, 143, 8, 63, 3, 240, 14, 27, 54, 18, 2, 248, 7,
  224, 14, 48, 60, 24, 60, 28, 120, 60, 120, 124, 248, 124, 248, 120, 248,
  48, 248, 0, 248, 0, 248, 0, 248, 0, 120, 4, 120, 4, 56, 4, 60,
  8, 30, 16, 7, 224, 2, 0, 2, 0, 3, 128, 0, 192, 0, 224, 0,
  224, 0, 224, 7, 128, 14, 28, 56, 18, 2, 0, 56, 0, 56, 0, 60,
  0, 30, 0, 14, 0, 7, 0, 1, 0, 0, 0, 0, 0, 7, 192, 28,
  224, 56, 112, 56, 120, 120, 120, 120, 124, 248, 124, 248, 124, 248, 124, 255,
  252, 248, 0, 248, 0, 248, 4, 120, 4, 120, 4, 56, 8, 60, 24, 30,
  48, 7, 192, 14, 28, 56, 18, 2, 0, 0, 112, 0, 112, 0, 240, 1,
  224, 1, 192, 3, 128, 2, 0, 0, 0, 0, 0, 7, 192, 28, 224, 56,
  112, 56, 120, 120, 120, 120, 124, 248, 124, 248, 124, 255, 252, 248, 0, 248,
  0, 248, 0, 248, 4, 120, 4, 120, 12, 56, 8, 60, 24, 30, 48, 7,
  192, 14, 28, 56, 18, 2, 0, 3, 0, 7, 128, 7, 128, 15, 192, 12,
  192, 24, 96, 48, 56, 0, 0, 0, 0, 7, 192, 28, 224, 56, 112, 56,
  120, 120, 120, 120, 124, 248, 124, 248, 124, 248, 124, 255, 252, 248, 0, 248,
  0, 248, 0, 120, 4, 120, 4, 56, 8, 60, 8, 30, 16, 7, 224, 14,
  27, 54, 18, 2, 0, 56, 112, 124, 248, 124, 248, 124, 248, 56, 112, 0,
  0, 0, 0, 0, 0, 7, 192, 28, 224, 56, 112, 56, 120, 120, 120, 120,
  124, 248, 124, 248, 124, 248, 124, 255, 252, 248, 0, 248, 0, 248, 0, 120,
  4, 120, 12, 56, 8, 60, 24, 30, 48, 7, 192, 10, 28, 56, 12, 1,
  0, 224, 0, 240, 0, 248, 0, 120, 0, 28, 0, 14, 0, 2, 0, 0,
  0, 0, 0, 127, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 127, 192, 9, 28, 56, 12, 2, 0, 1,
  128, 3, 128, 7, 128, 15, 0, 14, 0, 28, 0, 16, 0, 0, 0, 0,
  0, 254, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62,
  0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62,
  0, 62, 0, 62, 0, 255, 128, 11, 28, 56, 11, 1, 0, 14, 0, 30,
  0, 31, 0, 63, 0, 115, 128, 224, 192, 128, 96, 0, 0, 0, 0, 127,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 127, 192, 11, 27, 54, 12, 1, 0, 113, 192, 251, 224, 251,
  224, 251, 224, 113, 192, 0, 0, 0, 0, 0, 0, 127, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31,
  0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 127,
  192, 16, 28, 56, 20, 2, 0, 31, 8, 15, 184, 7, 224, 7, 224, 7,
  224, 13, 240, 16, 248, 0, 248, 0, 124, 7, 252, 30, 126, 60, 62, 56,
  62, 120, 30, 120, 31, 248, 31, 248, 31, 248, 31, 248, 31, 248, 31, 248,
  31, 248, 30, 120, 30, 120, 30, 56, 60, 60, 60, 12, 112, 7, 224, 19,
  27, 81, 22, 2, 0, 0, 2, 0, 7, 194, 0, 15, 254, 0, 15, 252,
  0, 8, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 60, 0,
  62, 222, 0, 63, 15, 0, 63, 15, 128, 63, 15, 128, 62, 15, 128, 62,
  15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15,
  128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128,
  62, 15, 128, 255, 191, 224, 16, 28, 56, 20, 2, 0, 24, 0, 28, 0,
  30, 0, 15, 0, 7, 0, 3, 128, 0, 192, 0, 0, 0, 0, 7, 192,
  12, 112, 28, 56, 56, 60, 120, 30, 120, 30, 248, 30, 248, 31, 248, 31,
  248, 31, 248, 31, 248, 31, 248, 30, 120, 30, 120, 30, 56, 60, 28, 56,
  12, 112, 7, 192, 16, 28, 56, 20, 2, 0, 0, 56, 0, 56, 0, 120,
  0, 240, 0, 224, 1, 192, 3, 0, 0, 0, 0, 0, 7, 192, 12, 112,
  28, 56, 56, 60, 120, 30, 120, 30, 248, 30, 248, 31, 248, 31, 248, 31,
  248, 31, 248, 31, 248, 30, 120, 30, 120, 30, 56, 60, 28, 56, 12, 112,
  7, 192, 16, 28, 56, 20, 2, 0, 3, 128, 3, 192, 3, 192, 7, 224,
  14, 112, 28, 56, 48, 12, 0, 0, 0, 0, 7, 192, 12, 112, 28, 56,
  56, 60, 120, 30, 120, 30, 248, 30, 248, 31, 248, 31, 248, 31, 248, 31,
  248, 31, 248, 30, 120, 30, 120, 30, 56, 60, 28, 56, 12, 112, 7, 192,
  16, 27, 54, 20, 2, 0, 14, 4, 31, 140, 31, 248, 35, 248, 32, 112,
  0, 0, 0, 0, 0, 0, 7, 192, 12, 112, 28, 56, 56, 60, 120, 30,
  120, 30, 248, 30, 248, 31, 248, 31, 248, 31, 248, 31, 248, 31, 248, 30,
  120, 30, 120, 30, 56, 60, 28, 56, 12, 112, 7, 192, 16, 27, 54, 20,
  2, 0, 28, 56, 62, 124, 62, 124, 62, 124, 28, 56, 0, 0, 0, 0,
  0, 0, 7, 192, 12, 112, 28, 56, 56, 60, 120, 30, 120, 30, 248, 30,
  248, 31, 248, 31, 248, 31, 248, 31, 248, 31, 248, 30, 120, 30, 120, 30,
  56, 60, 28, 56, 12, 112, 7, 192, 33, 26, 130, 37, 2, 253, 0, 3,
  192, 0, 0, 0, 7, 224, 0, 0, 0, 7, 224, 0, 0, 0, 7, 224,
  0, 0, 0, 7, 224, 0, 0, 0, 3, 192, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 255, 255, 255, 255, 128, 255, 255, 255, 255, 128, 255,
  255, 255, 255, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 3, 192, 0, 0, 0, 7, 224, 0, 0, 0, 7, 224, 0,
  0, 0, 7, 224, 0, 0, 0, 7, 224, 0, 0, 0, 3, 192, 0, 0,
  16, 19, 38, 20, 2, 0, 7, 225, 12, 114, 28, 60, 56, 60, 120, 62,
  120, 62, 248, 126, 248, 95, 248, 223, 249, 159, 251, 31, 254, 31, 252, 30,
  124, 30, 120, 30, 60, 28, 124, 56, 78, 48, 135, 192, 19, 28, 84, 21,
  1, 0, 12, 0, 0, 30, 0, 0, 15, 0, 0, 7, 0, 0, 3, 128,
  0, 1, 192, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 254, 63, 128,
  62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62,
  15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15,
  128, 62, 15, 128, 62, 15, 128, 62, 31, 128, 62, 31, 128, 30, 47, 128,
  31, 79, 128, 7, 143, 224, 19, 28, 84, 21, 1, 0, 0, 28, 0, 0,
  60, 0, 0, 60, 0, 0, 120, 0, 0, 224, 0, 0, 192, 0, 1, 128,
  0, 0, 0, 0, 0, 0, 0, 254, 63, 128, 62, 15, 128, 62, 15, 128,
  62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62,
  15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15,
  128, 62, 31, 128, 62, 31, 128, 30, 47, 128, 30, 79, 128, 7, 143, 224,
  19, 28, 84, 21, 1, 0, 1, 192, 0, 1, 224, 0, 3, 224, 0, 3,
  240, 0, 7, 56, 0, 12, 28, 0, 24, 4, 0, 0, 0, 0, 0, 0,
  0, 254, 63, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128,
  62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62,
  15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 31, 128, 62, 31,
  128, 30, 47, 128, 30, 79, 128, 7, 143, 224, 19, 27, 81, 21, 1, 0,
  28, 28, 0, 62, 62, 0, 62, 62, 0, 62, 62, 0, 28, 28, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 254, 63, 128, 62, 15, 128, 62, 15,
  128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128,
  62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62,
  15, 128, 62, 31, 128, 62, 31, 128, 30, 47, 128, 30, 79, 128, 7, 143,
  224, 18, 37, 111, 19, 0, 247, 0, 14, 0, 0, 30, 0, 0, 30, 0,
  0, 60, 0, 0, 48, 0, 0, 96, 0, 0, 192, 0, 0, 0, 0, 0,
  0, 0, 255, 207, 192, 63, 3, 0, 31, 3, 0, 31, 2, 0, 15, 2,
  0, 15, 130, 0, 15, 132, 0, 7, 196, 0, 7, 196, 0, 3, 196, 0,
  3, 232, 0, 3, 232, 0, 1, 248, 0, 1, 240, 0, 0, 240, 0, 0,
  240, 0, 0, 96, 0, 0, 96, 0, 0, 96, 0, 0, 32, 0, 0, 64,
  0, 12, 64, 0, 30, 64, 0, 62, 128, 0, 62, 128, 0, 60, 128, 0,
  29, 0, 0, 14, 0, 0, 18, 36, 108, 20, 0, 247, 3, 0, 0, 15,
  0, 0, 63, 0, 0, 223, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0,
  0, 31, 0, 0, 31, 31, 0, 31, 63, 128, 31, 71, 128, 31, 135, 192,
  31, 135, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 128, 31,
  7, 128, 31, 15, 0, 31, 15, 0, 31, 14, 0, 31, 12, 0, 31, 24,
  0, 31, 48, 0, 31, 96, 0, 31, 128, 0, 31, 0, 0, 31, 0, 0,
  31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 30,
  0, 0, 56, 0, 0, 224, 0, 0, 19, 36, 108, 20, 0, 247, 7, 14,
  0, 15, 159, 0, 15, 159, 0, 15, 159, 0, 7, 14, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 255, 207, 224, 63, 3, 0, 31, 3, 0, 31,
  2, 0, 15, 2, 0, 15, 130, 0, 15, 132, 0, 7, 196, 0, 7, 196,
  0, 3, 196, 0, 3, 232, 0, 3, 232, 0, 1, 248, 0, 1, 240, 0,
  0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 96, 0, 0, 96, 0, 0,
  32, 0, 0, 64, 0, 12, 64, 0, 30, 64, 0, 62, 64, 0, 62, 128,
  0, 60, 128, 0, 29, 0, 0, 14, 0, 0
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--38-380-72-72-P-206-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 0, '1' Height: 28
  Calculated Max Values w=33 h=37 x= 5 y=12 dx=37 dy= 0 ascent=29 len=165
  Font Bounding box     w=107 h=49 x=-33 y=-11
  Calculated Min Values           x= 0 y=-8 dx= 0 dy= 0
  Pure Font   ascent =28 descent= 0
  X Font      ascent =28 descent= 0
  Max Font    ascent =29 descent=-8
*/
const u8g_fntpgm_uint8_t u8g_font_osb29n[1257] U8G_FONT_SECTION("u8g_font_osb29n") = {
  0, 107, 49, 223, 245, 28, 0, 0, 0, 0, 42, 58, 0, 29, 248, 28,
  0, 14, 16, 32, 19, 3, 12, 3, 0, 7, 128, 7, 128, 199, 24, 227,
  60, 242, 124, 122, 248, 7, 128, 7, 128, 250, 248, 242, 124, 227, 60, 199,
  24, 7, 128, 7, 128, 3, 0, 33, 33, 165, 37, 2, 251, 0, 1, 192,
  0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0,
  0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0,
  0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0,
  1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1,
  192, 0, 0, 0, 1, 192, 0, 0, 255, 255, 255, 255, 128, 255, 255, 255,
  255, 128, 255, 255, 255, 255, 128, 0, 1, 192, 0, 0, 0, 1, 192, 0,
  0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0,
  0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0,
  1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1,
  192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192,
  0, 0, 7, 13, 13, 10, 2, 249, 120, 252, 252, 254, 254, 126, 6, 4,
  4, 8, 24, 96, 192, 10, 4, 8, 14, 2, 8, 255, 192, 255, 192, 255,
  192, 255, 192, 6, 6, 6, 10, 2, 0, 120, 252, 252, 252, 252, 120, 13,
  37, 74, 17, 2, 248, 0, 24, 0, 56, 0, 56, 0, 48, 0, 112, 0,
  112, 0, 96, 0, 96, 0, 224, 0, 224, 0, 192, 1, 192, 1, 192, 1,
  128, 3, 128, 3, 128, 3, 128, 3, 0, 7, 0, 7, 0, 6, 0, 14,
  0, 14, 0, 12, 0, 12, 0, 28, 0, 28, 0, 24, 0, 56, 0, 56,
  0, 48, 0, 112, 0, 112, 0, 112, 0, 96, 0, 224, 0, 224, 0, 18,
  28, 84, 22, 2, 1, 3, 240, 0, 14, 28, 0, 14, 28, 0, 28, 14,
  0, 60, 15, 0, 60, 15, 0, 124, 15, 128, 124, 15, 128, 124, 15, 128,
  252, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 252,
  15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 124, 15,
  128, 124, 15, 128, 124, 15, 128, 60, 15, 0, 60, 15, 0, 28, 14, 0,
  12, 28, 0, 14, 28, 0, 3, 240, 0, 13, 28, 56, 22, 5, 0, 3,
  128, 7, 128, 15, 128, 255, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 255, 248, 17, 28, 84, 22, 2, 1, 15, 248, 0,
  24, 62, 0, 48, 63, 0, 112, 31, 0, 240, 31, 128, 240, 31, 128, 252,
  31, 128, 252, 31, 128, 254, 31, 128, 126, 63, 0, 60, 63, 0, 0, 126,
  0, 0, 252, 0, 0, 248, 0, 1, 224, 0, 3, 128, 0, 6, 0, 0,
  12, 0, 128, 24, 0, 128, 16, 0, 128, 32, 0, 128, 47, 1, 128, 127,
  255, 128, 127, 255, 128, 71, 255, 0, 67, 255, 0, 65, 254, 0, 64, 252,
  0, 17, 28, 84, 22, 2, 1, 15, 248, 0, 24, 62, 0, 48, 63, 0,
  48, 31, 0, 112, 31, 128, 120, 31, 128, 124, 31, 128, 124, 31, 128, 124,
  31, 128, 60, 31, 0, 0, 31, 0, 0, 62, 0, 0, 120, 0, 15, 192,
  0, 0, 120, 0, 0, 62, 0, 0, 63, 0, 0, 31, 0, 16, 31, 128,
  124, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 248, 31, 128, 240,
  63, 0, 112, 62, 0, 56, 124, 0, 31, 248, 0, 18, 28, 84, 22, 2,
  0, 0, 124, 0, 0, 124, 0, 0, 252, 0, 0, 252, 0, 1, 252, 0,
  1, 252, 0, 3, 252, 0, 3, 252, 0, 6, 252, 0, 6, 252, 0, 12,
  252, 0, 12, 252, 0, 24, 252, 0, 24, 252, 0, 48, 252, 0, 48, 252,
  0, 96, 252, 0, 96, 252, 0, 192, 252, 0, 255, 255, 192, 0, 252, 0,
  0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0,
  252, 0, 15, 255, 192, 17, 29, 87, 22, 3, 0, 0, 6, 0, 112, 28,
  0, 127, 252, 0, 127, 248, 0, 127, 224, 0, 127, 192, 0, 126, 0, 0,
  96, 0, 0, 96, 0, 0, 96, 0, 0, 96, 0, 0, 103, 224, 0, 120,
  120, 0, 112, 62, 0, 96, 62, 0, 96, 31, 0, 0, 31, 0, 0, 31,
  128, 0, 31, 128, 56, 31, 128, 124, 31, 128, 252, 31, 128, 252, 31, 128,
  248, 31, 0, 240, 31, 0, 224, 30, 0, 96, 62, 0, 48, 124, 0, 31,
  240, 0, 18, 29, 87, 22, 3, 0, 0, 32, 0, 3, 220, 0, 7, 6,
  0, 14, 6, 0, 30, 15, 0, 60, 31, 0, 60, 63, 0, 124, 63, 0,
  124, 62, 0, 124, 28, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 253,
  248, 0, 255, 30, 0, 254, 31, 0, 252, 15, 128, 252, 15, 128, 252, 15,
  192, 252, 15, 192, 252, 15, 192, 124, 15, 192, 124, 15, 192, 124, 15, 192,
  60, 15, 128, 28, 15, 128, 30, 15, 0, 14, 30, 0, 3, 252, 0, 17,
  28, 84, 22, 3, 0, 103, 135, 0, 111, 199, 0, 127, 227, 128, 127, 241,
  128, 127, 249, 128, 127, 255, 128, 96, 125, 128, 64, 1, 0, 64, 3, 0,
  64, 3, 0, 192, 6, 0, 0, 4, 0, 0, 12, 0, 0, 24, 0, 0,
  56, 0, 0, 112, 0, 0, 112, 0, 0, 240, 0, 1, 240, 0, 3, 224,
  0, 3, 224, 0, 3, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0,
  7, 224, 0, 7, 224, 0, 3, 192, 0, 19, 29, 87, 22, 2, 0, 0,
  64, 0, 7, 184, 0, 28, 6, 0, 56, 3, 0, 112, 1, 0, 112, 1,
  128, 240, 1, 128, 240, 1, 128, 248, 1, 128, 252, 3, 0, 255, 2, 0,
  127, 196, 0, 127, 248, 0, 63, 252, 0, 31, 255, 0, 15, 255, 128, 27,
  255, 128, 48, 255, 192, 96, 63, 192, 96, 15, 192, 224, 3, 224, 224, 1,
  192, 224, 1, 192, 224, 1, 192, 224, 1, 192, 112, 1, 128, 56, 1, 0,
  28, 6, 0, 15, 252, 0, 18, 28, 84, 22, 3, 1, 15, 240, 0, 30,
  28, 0, 60, 30, 0, 124, 14, 0, 124, 15, 0, 252, 15, 128, 252, 15,
  128, 252, 15, 128, 252, 15, 128, 252, 15, 192, 252, 15, 192, 124, 15, 192,
  124, 15, 192, 62, 31, 192, 30, 63, 192, 7, 239, 192, 0, 15, 192, 0,
  15, 192, 0, 15, 192, 30, 15, 128, 31, 15, 128, 63, 15, 128, 63, 15,
  0, 62, 15, 0, 56, 30, 0, 24, 28, 0, 24, 56, 0, 15, 240, 0,
  6, 19, 19, 10, 2, 0, 120, 252, 252, 252, 252, 120, 0, 0, 0, 0,
  0, 0, 0, 120, 252, 252, 252, 252, 120
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--38-380-72-72-P-206-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 29, '1' Height: 28
  Calculated Max Values w=38 h=37 x= 5 y=21 dx=41 dy= 0 ascent=31 len=165
  Font Bounding box     w=107 h=49 x=-33 y=-11
  Calculated Min Values           x=-2 y=-9 dx= 0 dy= 0
  Pure Font   ascent =29 descent=-9
  X Font      ascent =29 descent=-9
  Max Font    ascent =31 descent=-9
*/
const u8g_fntpgm_uint8_t u8g_font_osb29r[7481] U8G_FONT_SECTION("u8g_font_osb29r") = {
  0, 107, 49, 223, 245, 29, 9, 166, 21, 115, 32, 127, 247, 31, 247, 29,
  247, 0, 0, 0, 11, 0, 0, 6, 28, 28, 10, 2, 1, 120, 252, 252,
  252, 252, 252, 252, 120, 120, 120, 120, 120, 48, 48, 48, 48, 48, 48, 48,
  48, 0, 0, 120, 252, 252, 252, 252, 120, 10, 9, 18, 16, 3, 20, 243,
  192, 243, 192, 243, 192, 243, 192, 243, 192, 243, 192, 97, 128, 97, 128, 97,
  128, 22, 28, 84, 28, 3, 0, 1, 192, 224, 1, 192, 224, 1, 192, 224,
  1, 192, 224, 1, 128, 192, 1, 128, 192, 1, 128, 192, 3, 129, 252, 255,
  255, 252, 255, 255, 252, 3, 129, 128, 3, 1, 128, 3, 1, 128, 7, 3,
  128, 7, 3, 128, 7, 3, 128, 7, 3, 128, 6, 3, 0, 255, 255, 252,
  255, 255, 252, 255, 255, 252, 14, 7, 0, 14, 7, 0, 14, 6, 0, 12,
  6, 0, 12, 6, 0, 28, 14, 0, 28, 14, 0, 18, 34, 102, 22, 2,
  253, 1, 16, 0, 1, 16, 0, 1, 16, 0, 7, 252, 0, 29, 19, 0,
  57, 17, 128, 49, 16, 192, 113, 16, 192, 113, 17, 192, 113, 19, 192, 121,
  23, 192, 127, 23, 128, 127, 19, 0, 63, 144, 0, 63, 240, 0, 31, 240,
  0, 15, 252, 0, 7, 254, 0, 1, 255, 0, 1, 255, 128, 1, 63, 128,
  121, 31, 192, 249, 23, 192, 249, 19, 192, 249, 17, 192, 225, 17, 192, 193,
  17, 192, 97, 17, 128, 97, 19, 0, 57, 22, 0, 15, 60, 0, 1, 208,
  0, 1, 16, 0, 1, 16, 0, 26, 29, 116, 32, 3, 0, 4, 0, 12,
  0, 27, 0, 8, 0, 49, 128, 24, 0, 113, 192, 16, 0, 113, 192, 48,
  0, 241, 224, 96, 0, 241, 224, 96, 0, 241, 224, 192, 0, 241, 224, 128,
  0, 241, 225, 128, 0, 241, 225, 0, 0, 113, 195, 0, 0, 113, 194, 0,
  0, 59, 134, 0, 0, 30, 12, 0, 0, 0, 12, 28, 0, 0, 24, 119,
  0, 0, 16, 227, 128, 0, 48, 227, 128, 0, 33, 227, 192, 0, 97, 227,
  192, 0, 65, 227, 192, 0, 193, 227, 192, 1, 129, 227, 192, 1, 129, 227,
  192, 3, 1, 227, 128, 2, 0, 227, 128, 6, 0, 99, 0, 4, 0, 62,
  0, 27, 28, 112, 31, 2, 1, 0, 254, 0, 0, 1, 195, 0, 0, 3,
  129, 0, 0, 7, 129, 128, 0, 7, 129, 128, 0, 7, 129, 128, 0, 7,
  131, 128, 0, 7, 195, 0, 0, 7, 198, 0, 0, 3, 236, 0, 0, 3,
  248, 0, 0, 1, 240, 0, 0, 0, 248, 0, 0, 1, 252, 31, 224, 7,
  124, 3, 128, 14, 62, 3, 0, 28, 63, 3, 0, 56, 31, 134, 0, 120,
  15, 134, 0, 120, 7, 196, 0, 248, 7, 232, 0, 248, 3, 248, 0, 248,
  1, 240, 0, 252, 1, 248, 0, 254, 0, 248, 32, 127, 1, 252, 64, 63,
  254, 127, 192, 31, 248, 31, 128, 4, 9, 9, 10, 3, 20, 240, 240, 240,
  240, 240, 240, 96, 96, 96, 11, 35, 70, 13, 2, 249, 0, 96, 0, 192,
  1, 128, 3, 0, 6, 0, 12, 0, 28, 0, 24, 0, 56, 0, 56, 0,
  120, 0, 120, 0, 120, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 120, 0, 120, 0, 120, 0, 120, 0,
  56, 0, 56, 0, 28, 0, 12, 0, 14, 0, 7, 0, 3, 0, 1, 128,
  0, 96, 11, 36, 72, 14, 1, 249, 192, 0, 96, 0, 48, 0, 24, 0,
  12, 0, 14, 0, 7, 0, 7, 0, 3, 128, 3, 128, 3, 192, 3, 192,
  3, 192, 3, 192, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 192, 3, 192, 3, 192, 3, 128, 3, 128, 7, 0,
  7, 0, 6, 0, 12, 0, 28, 0, 56, 0, 112, 0, 192, 0, 128, 0,
  14, 16, 32, 19, 3, 12, 3, 0, 7, 128, 7, 128, 199, 24, 227, 60,
  242, 124, 122, 248, 7, 128, 7, 128, 250, 248, 242, 124, 227, 60, 199, 24,
  7, 128, 7, 128, 3, 0, 33, 33, 165, 37, 2, 251, 0, 1, 192, 0,
  0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0,
  0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0,
  1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1,
  192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192,
  0, 0, 0, 1, 192, 0, 0, 255, 255, 255, 255, 128, 255, 255, 255, 255,
  128, 255, 255, 255, 255, 128, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0,
  0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0,
  1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1,
  192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192,
  0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 192, 0,
  0, 7, 13, 13, 10, 2, 249, 120, 252, 252, 254, 254, 126, 6, 4, 4,
  8, 24, 96, 192, 10, 4, 8, 14, 2, 8, 255, 192, 255, 192, 255, 192,
  255, 192, 6, 6, 6, 10, 2, 0, 120, 252, 252, 252, 252, 120, 13, 37,
  74, 17, 2, 248, 0, 24, 0, 56, 0, 56, 0, 48, 0, 112, 0, 112,
  0, 96, 0, 96, 0, 224, 0, 224, 0, 192, 1, 192, 1, 192, 1, 128,
  3, 128, 3, 128, 3, 128, 3, 0, 7, 0, 7, 0, 6, 0, 14, 0,
  14, 0, 12, 0, 12, 0, 28, 0, 28, 0, 24, 0, 56, 0, 56, 0,
  48, 0, 112, 0, 112, 0, 112, 0, 96, 0, 224, 0, 224, 0, 18, 28,
  84, 22, 2, 1, 3, 240, 0, 14, 28, 0, 14, 28, 0, 28, 14, 0,
  60, 15, 0, 60, 15, 0, 124, 15, 128, 124, 15, 128, 124, 15, 128, 252,
  15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15,
  192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 124, 15, 128,
  124, 15, 128, 124, 15, 128, 60, 15, 0, 60, 15, 0, 28, 14, 0, 12,
  28, 0, 14, 28, 0, 3, 240, 0, 13, 28, 56, 22, 5, 0, 3, 128,
  7, 128, 15, 128, 255, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 255, 248, 17, 28, 84, 22, 2, 1, 15, 248, 0, 24,
  62, 0, 48, 63, 0, 112, 31, 0, 240, 31, 128, 240, 31, 128, 252, 31,
  128, 252, 31, 128, 254, 31, 128, 126, 63, 0, 60, 63, 0, 0, 126, 0,
  0, 252, 0, 0, 248, 0, 1, 224, 0, 3, 128, 0, 6, 0, 0, 12,
  0, 128, 24, 0, 128, 16, 0, 128, 32, 0, 128, 47, 1, 128, 127, 255,
  128, 127, 255, 128, 71, 255, 0, 67, 255, 0, 65, 254, 0, 64, 252, 0,
  17, 28, 84, 22, 2, 1, 15, 248, 0, 24, 62, 0, 48, 63, 0, 48,
  31, 0, 112, 31, 128, 120, 31, 128, 124, 31, 128, 124, 31, 128, 124, 31,
  128, 60, 31, 0, 0, 31, 0, 0, 62, 0, 0, 120, 0, 15, 192, 0,
  0, 120, 0, 0, 62, 0, 0, 63, 0, 0, 31, 0, 16, 31, 128, 124,
  31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 248, 31, 128, 240, 63,
  0, 112, 62, 0, 56, 124, 0, 31, 248, 0, 18, 28, 84, 22, 2, 0,
  0, 124, 0, 0, 124, 0, 0, 252, 0, 0, 252, 0, 1, 252, 0, 1,
  252, 0, 3, 252, 0, 3, 252, 0, 6, 252, 0, 6, 252, 0, 12, 252,
  0, 12, 252, 0, 24, 252, 0, 24, 252, 0, 48, 252, 0, 48, 252, 0,
  96, 252, 0, 96, 252, 0, 192, 252, 0, 255, 255, 192, 0, 252, 0, 0,
  252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252,
  0, 15, 255, 192, 17, 29, 87, 22, 3, 0, 0, 6, 0, 112, 28, 0,
  127, 252, 0, 127, 248, 0, 127, 224, 0, 127, 192, 0, 126, 0, 0, 96,
  0, 0, 96, 0, 0, 96, 0, 0, 96, 0, 0, 103, 224, 0, 120, 120,
  0, 112, 62, 0, 96, 62, 0, 96, 31, 0, 0, 31, 0, 0, 31, 128,
  0, 31, 128, 56, 31, 128, 124, 31, 128, 252, 31, 128, 252, 31, 128, 248,
  31, 0, 240, 31, 0, 224, 30, 0, 96, 62, 0, 48, 124, 0, 31, 240,
  0, 18, 29, 87, 22, 3, 0, 0, 32, 0, 3, 220, 0, 7, 6, 0,
  14, 6, 0, 30, 15, 0, 60, 31, 0, 60, 63, 0, 124, 63, 0, 124,
  62, 0, 124, 28, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 253, 248,
  0, 255, 30, 0, 254, 31, 0, 252, 15, 128, 252, 15, 128, 252, 15, 192,
  252, 15, 192, 252, 15, 192, 124, 15, 192, 124, 15, 192, 124, 15, 192, 60,
  15, 128, 28, 15, 128, 30, 15, 0, 14, 30, 0, 3, 252, 0, 17, 28,
  84, 22, 3, 0, 103, 135, 0, 111, 199, 0, 127, 227, 128, 127, 241, 128,
  127, 249, 128, 127, 255, 128, 96, 125, 128, 64, 1, 0, 64, 3, 0, 64,
  3, 0, 192, 6, 0, 0, 4, 0, 0, 12, 0, 0, 24, 0, 0, 56,
  0, 0, 112, 0, 0, 112, 0, 0, 240, 0, 1, 240, 0, 3, 224, 0,
  3, 224, 0, 3, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 7,
  224, 0, 7, 224, 0, 3, 192, 0, 19, 29, 87, 22, 2, 0, 0, 64,
  0, 7, 184, 0, 28, 6, 0, 56, 3, 0, 112, 1, 0, 112, 1, 128,
  240, 1, 128, 240, 1, 128, 248, 1, 128, 252, 3, 0, 255, 2, 0, 127,
  196, 0, 127, 248, 0, 63, 252, 0, 31, 255, 0, 15, 255, 128, 27, 255,
  128, 48, 255, 192, 96, 63, 192, 96, 15, 192, 224, 3, 224, 224, 1, 192,
  224, 1, 192, 224, 1, 192, 224, 1, 192, 112, 1, 128, 56, 1, 0, 28,
  6, 0, 15, 252, 0, 18, 28, 84, 22, 3, 1, 15, 240, 0, 30, 28,
  0, 60, 30, 0, 124, 14, 0, 124, 15, 0, 252, 15, 128, 252, 15, 128,
  252, 15, 128, 252, 15, 128, 252, 15, 192, 252, 15, 192, 124, 15, 192, 124,
  15, 192, 62, 31, 192, 30, 63, 192, 7, 239, 192, 0, 15, 192, 0, 15,
  192, 0, 15, 192, 30, 15, 128, 31, 15, 128, 63, 15, 128, 63, 15, 0,
  62, 15, 0, 56, 30, 0, 24, 28, 0, 24, 56, 0, 15, 240, 0, 6,
  19, 19, 10, 2, 0, 120, 252, 252, 252, 252, 120, 0, 0, 0, 0, 0,
  0, 0, 120, 252, 252, 252, 252, 120, 7, 26, 26, 10, 2, 249, 120, 252,
  252, 252, 252, 120, 0, 0, 0, 0, 0, 0, 0, 120, 252, 252, 254, 254,
  126, 6, 4, 4, 8, 16, 96, 192, 29, 33, 132, 36, 3, 250, 0, 0,
  0, 24, 0, 0, 0, 120, 0, 0, 1, 240, 0, 0, 7, 192, 0, 0,
  31, 128, 0, 0, 62, 0, 0, 0, 248, 0, 0, 3, 224, 0, 0, 15,
  192, 0, 0, 31, 0, 0, 0, 124, 0, 0, 1, 240, 0, 0, 7, 192,
  0, 0, 15, 128, 0, 0, 62, 0, 0, 0, 248, 0, 0, 0, 240, 0,
  0, 0, 124, 0, 0, 0, 62, 0, 0, 0, 15, 128, 0, 0, 3, 224,
  0, 0, 0, 248, 0, 0, 0, 124, 0, 0, 0, 31, 0, 0, 0, 7,
  192, 0, 0, 1, 240, 0, 0, 0, 252, 0, 0, 0, 62, 0, 0, 0,
  15, 128, 0, 0, 3, 224, 0, 0, 1, 248, 0, 0, 0, 120, 0, 0,
  0, 16, 32, 11, 44, 36, 2, 5, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 29, 33, 132, 36, 4, 250, 192, 0, 0, 0, 240, 0,
  0, 0, 124, 0, 0, 0, 31, 0, 0, 0, 15, 192, 0, 0, 3, 224,
  0, 0, 0, 248, 0, 0, 0, 62, 0, 0, 0, 31, 128, 0, 0, 7,
  192, 0, 0, 1, 240, 0, 0, 0, 124, 0, 0, 0, 31, 0, 0, 0,
  15, 128, 0, 0, 3, 224, 0, 0, 0, 248, 0, 0, 0, 120, 0, 0,
  1, 240, 0, 0, 3, 224, 0, 0, 15, 128, 0, 0, 62, 0, 0, 0,
  248, 0, 0, 1, 240, 0, 0, 7, 192, 0, 0, 31, 0, 0, 0, 124,
  0, 0, 1, 248, 0, 0, 3, 224, 0, 0, 15, 128, 0, 0, 62, 0,
  0, 0, 252, 0, 0, 0, 240, 0, 0, 0, 64, 0, 0, 0, 12, 28,
  56, 18, 3, 1, 63, 128, 119, 224, 65, 224, 129, 240, 129, 240, 129, 240,
  129, 240, 129, 224, 193, 224, 67, 192, 3, 128, 7, 0, 6, 0, 12, 0,
  8, 0, 24, 0, 16, 64, 16, 64, 16, 64, 24, 128, 15, 0, 0, 0,
  7, 128, 15, 192, 15, 192, 15, 192, 15, 192, 7, 128, 28, 29, 116, 32,
  2, 0, 0, 2, 0, 0, 0, 125, 240, 0, 1, 192, 28, 0, 3, 0,
  6, 0, 6, 0, 3, 0, 12, 0, 1, 128, 24, 15, 61, 192, 56, 28,
  188, 192, 48, 56, 248, 224, 112, 112, 120, 224, 112, 240, 120, 96, 225, 224,
  120, 112, 225, 224, 248, 112, 225, 224, 240, 112, 227, 224, 240, 112, 227, 192,
  240, 112, 227, 192, 240, 112, 227, 193, 224, 96, 227, 193, 224, 224, 99, 193,
  224, 192, 99, 195, 224, 192, 115, 194, 225, 128, 49, 228, 227, 0, 56, 120,
  124, 0, 28, 0, 0, 0, 12, 0, 0, 0, 7, 0, 0, 0, 3, 128,
  24, 0, 0, 255, 224, 0, 26, 29, 116, 29, 2, 0, 0, 4, 0, 0,
  0, 6, 0, 0, 0, 14, 0, 0, 0, 14, 0, 0, 0, 15, 0, 0,
  0, 31, 0, 0, 0, 31, 0, 0, 0, 31, 128, 0, 0, 63, 128, 0,
  0, 47, 128, 0, 0, 47, 192, 0, 0, 111, 192, 0, 0, 79, 192, 0,
  0, 71, 192, 0, 0, 199, 224, 0, 0, 135, 224, 0, 0, 131, 224, 0,
  1, 131, 240, 0, 1, 3, 240, 0, 3, 1, 240, 0, 3, 255, 248, 0,
  2, 1, 248, 0, 6, 0, 248, 0, 6, 0, 252, 0, 4, 0, 252, 0,
  12, 0, 252, 0, 12, 0, 124, 0, 30, 0, 254, 0, 255, 199, 255, 192,
  22, 28, 84, 27, 3, 0, 255, 255, 0, 31, 131, 192, 31, 131, 224, 31,
  129, 240, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129,
  248, 31, 129, 240, 31, 129, 240, 31, 131, 192, 31, 131, 128, 31, 252, 0,
  31, 131, 128, 31, 129, 224, 31, 128, 240, 31, 128, 248, 31, 128, 252, 31,
  128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 248, 31, 128,
  248, 31, 129, 240, 31, 131, 224, 255, 255, 128, 21, 28, 84, 26, 3, 1,
  1, 254, 48, 7, 3, 48, 14, 1, 240, 30, 0, 240, 60, 0, 240, 60,
  0, 112, 124, 0, 112, 124, 0, 48, 124, 0, 48, 252, 0, 48, 252, 0,
  48, 252, 0, 16, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0,
  252, 0, 0, 252, 0, 24, 252, 0, 24, 124, 0, 16, 124, 0, 16, 124,
  0, 16, 60, 0, 48, 60, 0, 32, 30, 0, 96, 14, 0, 192, 7, 1,
  128, 1, 254, 0, 25, 28, 112, 30, 3, 0, 255, 255, 128, 0, 31, 128,
  224, 0, 31, 128, 112, 0, 31, 128, 56, 0, 31, 128, 60, 0, 31, 128,
  30, 0, 31, 128, 30, 0, 31, 128, 31, 0, 31, 128, 31, 0, 31, 128,
  31, 0, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 0, 31, 128, 31, 0, 31, 128, 31, 0, 31, 128,
  30, 0, 31, 128, 30, 0, 31, 128, 60, 0, 31, 128, 56, 0, 31, 128,
  112, 0, 31, 128, 224, 0, 255, 255, 128, 0, 22, 28, 84, 26, 2, 0,
  255, 255, 252, 15, 192, 124, 15, 192, 60, 15, 192, 28, 15, 192, 28, 15,
  192, 12, 15, 192, 12, 15, 192, 12, 15, 193, 4, 15, 193, 0, 15, 195,
  0, 15, 195, 0, 15, 199, 0, 15, 255, 0, 15, 199, 0, 15, 195, 0,
  15, 195, 0, 15, 193, 4, 15, 193, 4, 15, 193, 4, 15, 192, 12, 15,
  192, 12, 15, 192, 12, 15, 192, 28, 15, 192, 28, 15, 192, 60, 15, 192,
  252, 255, 255, 252, 22, 28, 84, 25, 2, 0, 255, 255, 252, 31, 128, 252,
  31, 128, 124, 31, 128, 60, 31, 128, 28, 31, 128, 28, 31, 128, 28, 31,
  128, 12, 31, 129, 12, 31, 129, 12, 31, 131, 12, 31, 131, 0, 31, 135,
  0, 31, 255, 0, 31, 143, 0, 31, 135, 0, 31, 131, 0, 31, 129, 0,
  31, 129, 0, 31, 129, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31,
  128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 255, 252, 0, 24, 29,
  87, 28, 3, 0, 0, 16, 0, 1, 239, 24, 3, 3, 152, 14, 0, 248,
  30, 0, 248, 28, 0, 120, 60, 0, 56, 60, 0, 56, 124, 0, 24, 124,
  0, 24, 124, 0, 24, 252, 0, 8, 252, 0, 0, 252, 0, 0, 252, 0,
  0, 252, 31, 255, 252, 1, 248, 252, 1, 248, 252, 1, 248, 252, 1, 248,
  124, 1, 248, 124, 1, 248, 124, 1, 248, 60, 1, 248, 60, 1, 248, 30,
  3, 152, 14, 3, 24, 7, 6, 24, 1, 220, 24, 27, 28, 112, 31, 2,
  0, 255, 251, 255, 224, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63,
  0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63,
  0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63,
  0, 31, 128, 63, 0, 31, 255, 255, 0, 31, 128, 63, 0, 31, 128, 63,
  0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63,
  0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63,
  0, 31, 128, 63, 0, 31, 128, 63, 0, 31, 128, 63, 0, 255, 251, 255,
  224, 13, 28, 56, 17, 2, 0, 255, 248, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 255, 248, 18,
  28, 84, 20, 1, 0, 7, 255, 192, 0, 126, 0, 0, 126, 0, 0, 126,
  0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0,
  0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0,
  126, 0, 0, 126, 0, 0, 126, 0, 16, 126, 0, 124, 126, 0, 252, 126,
  0, 252, 126, 0, 252, 126, 0, 248, 126, 0, 240, 124, 0, 224, 124, 0,
  96, 120, 0, 32, 240, 0, 31, 224, 0, 26, 28, 112, 29, 2, 0, 255,
  241, 255, 0, 31, 128, 120, 0, 31, 128, 112, 0, 31, 128, 96, 0, 31,
  128, 64, 0, 31, 128, 192, 0, 31, 129, 128, 0, 31, 131, 0, 0, 31,
  134, 0, 0, 31, 134, 0, 0, 31, 142, 0, 0, 31, 159, 0, 0, 31,
  191, 0, 0, 31, 255, 128, 0, 31, 223, 128, 0, 31, 159, 192, 0, 31,
  143, 192, 0, 31, 143, 224, 0, 31, 135, 224, 0, 31, 135, 240, 0, 31,
  131, 240, 0, 31, 131, 248, 0, 31, 129, 248, 0, 31, 129, 252, 0, 31,
  128, 252, 0, 31, 128, 254, 0, 31, 128, 254, 0, 255, 243, 255, 192, 22,
  28, 84, 25, 2, 0, 255, 248, 0, 31, 128, 0, 31, 128, 0, 31, 128,
  0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0,
  31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31,
  128, 0, 31, 128, 0, 31, 128, 12, 31, 128, 12, 31, 128, 12, 31, 128,
  12, 31, 128, 28, 31, 128, 28, 31, 128, 60, 31, 128, 60, 31, 128, 124,
  31, 128, 252, 31, 129, 252, 255, 255, 252, 31, 28, 112, 34, 2, 0, 255,
  128, 15, 254, 15, 128, 15, 224, 15, 192, 15, 224, 15, 192, 15, 224, 15,
  192, 15, 224, 15, 224, 23, 224, 15, 224, 23, 224, 15, 240, 23, 224, 13,
  240, 23, 224, 13, 240, 39, 224, 13, 248, 39, 224, 12, 248, 39, 224, 12,
  248, 39, 224, 12, 252, 71, 224, 12, 124, 71, 224, 12, 124, 71, 224, 12,
  126, 71, 224, 12, 62, 135, 224, 12, 63, 135, 224, 12, 63, 135, 224, 12,
  31, 135, 224, 12, 31, 7, 224, 12, 31, 7, 224, 12, 15, 7, 224, 12,
  15, 7, 224, 28, 14, 7, 224, 62, 6, 7, 224, 255, 134, 63, 254, 27,
  28, 112, 30, 2, 0, 255, 128, 255, 224, 31, 192, 63, 0, 31, 192, 30,
  0, 15, 224, 12, 0, 7, 240, 12, 0, 7, 240, 12, 0, 7, 248, 12,
  0, 7, 248, 12, 0, 6, 252, 12, 0, 6, 254, 12, 0, 6, 126, 12,
  0, 6, 63, 12, 0, 6, 63, 140, 0, 6, 31, 140, 0, 6, 31, 204,
  0, 6, 15, 236, 0, 6, 7, 236, 0, 6, 7, 252, 0, 6, 3, 252,
  0, 6, 1, 252, 0, 6, 1, 252, 0, 6, 0, 252, 0, 6, 0, 252,
  0, 6, 0, 124, 0, 6, 0, 60, 0, 15, 0, 60, 0, 31, 128, 28,
  0, 255, 224, 12, 0, 22, 28, 84, 27, 3, 1, 1, 254, 0, 3, 3,
  0, 6, 1, 128, 14, 1, 192, 28, 0, 224, 60, 0, 240, 60, 0, 240,
  124, 0, 248, 124, 0, 248, 124, 0, 248, 252, 0, 252, 252, 0, 252, 252,
  0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0,
  252, 124, 0, 248, 124, 0, 248, 124, 0, 248, 60, 0, 240, 60, 0, 240,
  28, 0, 224, 14, 1, 192, 6, 1, 128, 3, 3, 0, 1, 254, 0, 23,
  28, 84, 27, 2, 0, 255, 255, 128, 31, 129, 240, 31, 128, 248, 31, 128,
  252, 31, 128, 124, 31, 128, 126, 31, 128, 126, 31, 128, 126, 31, 128, 126,
  31, 128, 126, 31, 128, 124, 31, 128, 252, 31, 128, 248, 31, 129, 224, 31,
  255, 128, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128,
  0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0,
  31, 128, 0, 31, 128, 0, 255, 248, 0, 22, 37, 111, 27, 3, 248, 1,
  254, 0, 3, 3, 0, 6, 1, 128, 14, 1, 192, 28, 0, 224, 60, 0,
  240, 60, 0, 240, 124, 0, 248, 124, 0, 248, 124, 0, 248, 252, 0, 252,
  252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252, 0, 252, 252,
  0, 252, 252, 0, 252, 124, 0, 248, 124, 0, 248, 124, 0, 248, 60, 56,
  240, 60, 76, 240, 30, 133, 224, 14, 135, 224, 7, 135, 192, 3, 135, 132,
  1, 238, 4, 0, 22, 4, 0, 6, 4, 0, 7, 12, 0, 7, 12, 0,
  7, 252, 0, 7, 248, 0, 7, 248, 0, 3, 240, 0, 1, 224, 25, 28,
  112, 28, 2, 0, 255, 255, 0, 0, 31, 135, 192, 0, 31, 131, 224, 0,
  31, 129, 240, 0, 31, 129, 248, 0, 31, 129, 248, 0, 31, 129, 248, 0,
  31, 129, 248, 0, 31, 129, 248, 0, 31, 129, 240, 0, 31, 131, 224, 0,
  31, 135, 192, 0, 31, 254, 0, 0, 31, 135, 128, 0, 31, 131, 192, 0,
  31, 129, 240, 0, 31, 129, 240, 0, 31, 129, 248, 0, 31, 129, 248, 0,
  31, 129, 248, 0, 31, 129, 248, 0, 31, 129, 248, 128, 31, 129, 248, 128,
  31, 129, 248, 128, 31, 129, 248, 128, 31, 129, 249, 0, 31, 128, 249, 0,
  255, 248, 126, 0, 18, 29, 87, 23, 3, 0, 1, 0, 0, 31, 225, 128,
  48, 57, 128, 96, 31, 128, 96, 15, 128, 224, 7, 128, 240, 3, 128, 240,
  3, 128, 248, 1, 128, 254, 1, 128, 255, 1, 128, 127, 192, 0, 127, 224,
  0, 63, 248, 0, 31, 252, 0, 7, 255, 0, 3, 255, 0, 128, 255, 128,
  128, 127, 128, 192, 31, 192, 192, 15, 192, 192, 7, 192, 224, 3, 192, 224,
  1, 192, 240, 1, 128, 248, 1, 128, 248, 3, 0, 206, 2, 0, 135, 188,
  0, 24, 28, 84, 27, 2, 0, 255, 255, 255, 252, 126, 63, 248, 126, 31,
  240, 126, 15, 224, 126, 15, 224, 126, 7, 192, 126, 7, 192, 126, 3, 192,
  126, 3, 192, 126, 3, 128, 126, 3, 128, 126, 2, 0, 126, 0, 0, 126,
  0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0,
  0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0, 126, 0, 0,
  126, 0, 0, 126, 0, 0, 126, 0, 7, 255, 224, 26, 28, 112, 30, 3,
  0, 255, 240, 127, 192, 31, 128, 31, 0, 31, 128, 14, 0, 31, 128, 6,
  0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6,
  0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6,
  0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6,
  0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6, 0, 31, 128, 6,
  0, 31, 128, 6, 0, 31, 128, 6, 0, 15, 128, 12, 0, 15, 192, 12,
  0, 7, 192, 24, 0, 7, 224, 56, 0, 1, 252, 240, 0, 0, 255, 192,
  0, 27, 28, 112, 30, 2, 0, 255, 248, 127, 224, 31, 192, 15, 0, 15,
  192, 6, 0, 15, 192, 6, 0, 7, 224, 4, 0, 7, 224, 12, 0, 7,
  224, 8, 0, 3, 240, 8, 0, 3, 240, 8, 0, 3, 240, 24, 0, 1,
  248, 16, 0, 1, 248, 16, 0, 1, 252, 48, 0, 0, 252, 32, 0, 0,
  252, 32, 0, 0, 254, 96, 0, 0, 126, 64, 0, 0, 126, 64, 0, 0,
  127, 192, 0, 0, 63, 128, 0, 0, 63, 128, 0, 0, 63, 128, 0, 0,
  31, 0, 0, 0, 31, 0, 0, 0, 31, 0, 0, 0, 14, 0, 0, 0,
  14, 0, 0, 0, 14, 0, 0, 38, 28, 140, 41, 2, 0, 255, 243, 255,
  207, 252, 31, 192, 126, 1, 224, 15, 192, 126, 0, 192, 15, 192, 62, 0,
  192, 7, 192, 63, 0, 128, 7, 224, 63, 0, 128, 7, 224, 63, 1, 128,
  7, 224, 63, 129, 0, 3, 240, 63, 129, 0, 3, 240, 127, 131, 0, 3,
  240, 111, 195, 0, 1, 248, 79, 194, 0, 1, 248, 207, 194, 0, 1, 248,
  199, 230, 0, 0, 252, 135, 230, 0, 0, 252, 135, 228, 0, 0, 253, 131,
  244, 0, 0, 127, 131, 252, 0, 0, 127, 3, 248, 0, 0, 127, 3, 248,
  0, 0, 127, 1, 248, 0, 0, 63, 1, 248, 0, 0, 62, 1, 240, 0,
  0, 62, 0, 240, 0, 0, 30, 0, 240, 0, 0, 28, 0, 240, 0, 0,
  28, 0, 96, 0, 0, 12, 0, 96, 0, 26, 28, 112, 29, 2, 0, 255,
  241, 255, 128, 31, 224, 124, 0, 15, 224, 56, 0, 15, 224, 48, 0, 7,
  240, 96, 0, 7, 240, 96, 0, 3, 248, 192, 0, 3, 248, 128, 0, 1,
  253, 128, 0, 0, 255, 0, 0, 0, 254, 0, 0, 0, 126, 0, 0, 0,
  127, 0, 0, 0, 63, 0, 0, 0, 63, 128, 0, 0, 31, 128, 0, 0,
  63, 192, 0, 0, 111, 192, 0, 0, 79, 224, 0, 0, 199, 224, 0, 1,
  135, 240, 0, 1, 131, 240, 0, 3, 3, 248, 0, 2, 1, 248, 0, 6,
  1, 252, 0, 14, 0, 252, 0, 30, 1, 254, 0, 255, 199, 255, 192, 25,
  28, 112, 28, 2, 0, 255, 240, 255, 128, 31, 192, 60, 0, 31, 192, 24,
  0, 15, 192, 24, 0, 15, 224, 24, 0, 7, 224, 16, 0, 7, 224, 48,
  0, 3, 240, 32, 0, 3, 240, 32, 0, 1, 248, 96, 0, 1, 248, 64,
  0, 1, 252, 64, 0, 0, 252, 192, 0, 0, 254, 128, 0, 0, 127, 128,
  0, 0, 127, 128, 0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0,
  0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0,
  0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0,
  0, 1, 255, 224, 0, 20, 28, 84, 25, 3, 0, 127, 255, 240, 126, 7,
  240, 124, 7, 224, 120, 15, 224, 112, 15, 192, 96, 31, 192, 96, 31, 128,
  96, 63, 128, 64, 63, 0, 64, 127, 0, 0, 254, 0, 0, 254, 0, 1,
  252, 0, 1, 248, 0, 3, 248, 0, 3, 240, 0, 7, 240, 0, 7, 224,
  16, 15, 224, 16, 15, 192, 16, 31, 192, 48, 31, 128, 48, 63, 128, 112,
  63, 0, 112, 127, 0, 240, 126, 1, 240, 254, 7, 240, 255, 255, 240, 9,
  35, 70, 15, 3, 249, 255, 128, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248,
  0, 248, 0, 248, 0, 248, 0, 248, 0, 255, 128, 13, 37, 74, 17, 2,
  248, 192, 0, 224, 0, 224, 0, 96, 0, 112, 0, 112, 0, 48, 0, 56,
  0, 56, 0, 24, 0, 24, 0, 28, 0, 28, 0, 12, 0, 14, 0, 14,
  0, 6, 0, 6, 0, 7, 0, 7, 0, 3, 0, 3, 128, 3, 128, 1,
  128, 1, 192, 1, 192, 0, 192, 0, 192, 0, 224, 0, 224, 0, 96, 0,
  112, 0, 112, 0, 48, 0, 48, 0, 56, 0, 56, 9, 35, 70, 15, 3,
  249, 255, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15,
  128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15,
  128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15,
  128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15,
  128, 15, 128, 15, 128, 255, 128, 18, 14, 42, 22, 2, 15, 0, 192, 0,
  0, 192, 0, 1, 224, 0, 3, 240, 0, 3, 240, 0, 7, 56, 0, 7,
  56, 0, 14, 28, 0, 28, 14, 0, 28, 14, 0, 56, 7, 0, 56, 7,
  0, 112, 3, 128, 224, 1, 192, 20, 3, 9, 20, 0, 249, 255, 255, 240,
  255, 255, 240, 255, 255, 240, 7, 7, 7, 17, 3, 21, 224, 240, 240, 120,
  60, 12, 6, 17, 19, 57, 20, 2, 0, 15, 192, 0, 24, 240, 0, 48,
  120, 0, 112, 120, 0, 124, 124, 0, 124, 124, 0, 124, 124, 0, 0, 252,
  0, 7, 124, 0, 28, 124, 0, 56, 124, 0, 120, 124, 0, 248, 124, 0,
  248, 124, 128, 248, 124, 128, 248, 124, 128, 252, 253, 128, 127, 191, 0, 62,
  30, 0, 18, 28, 84, 20, 0, 0, 255, 0, 0, 31, 0, 0, 31, 0,
  0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0,
  31, 0, 0, 31, 60, 0, 31, 78, 0, 31, 143, 0, 31, 135, 128, 31,
  7, 128, 31, 7, 128, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7,
  192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 128, 31, 7, 128,
  31, 135, 0, 25, 143, 0, 16, 206, 0, 16, 120, 0, 14, 19, 38, 18,
  2, 0, 7, 224, 14, 48, 60, 24, 60, 28, 120, 60, 120, 124, 248, 124,
  248, 120, 248, 48, 248, 0, 248, 0, 248, 0, 248, 0, 120, 4, 120, 4,
  56, 4, 28, 8, 14, 16, 7, 224, 18, 28, 84, 21, 2, 0, 0, 254,
  0, 0, 62, 0, 0, 62, 0, 0, 62, 0, 0, 62, 0, 0, 62, 0,
  0, 62, 0, 0, 62, 0, 0, 62, 0, 15, 62, 0, 28, 190, 0, 60,
  126, 0, 120, 126, 0, 120, 62, 0, 120, 62, 0, 248, 62, 0, 248, 62,
  0, 248, 62, 0, 248, 62, 0, 248, 62, 0, 248, 62, 0, 248, 62, 0,
  120, 62, 0, 120, 62, 0, 120, 126, 0, 60, 126, 0, 28, 190, 0, 15,
  63, 192, 14, 19, 38, 18, 2, 0, 7, 192, 28, 224, 56, 112, 56, 120,
  120, 120, 120, 124, 248, 124, 248, 124, 248, 124, 255, 252, 248, 0, 248, 0,
  248, 0, 120, 4, 120, 4, 56, 8, 60, 8, 30, 16, 7, 224, 14, 28,
  56, 13, 1, 0, 1, 240, 7, 24, 15, 28, 30, 60, 30, 124, 62, 124,
  62, 56, 62, 0, 62, 0, 255, 192, 62, 0, 62, 0, 62, 0, 62, 0,
  62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0,
  62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 255, 192, 19, 28, 84, 22,
  2, 247, 7, 225, 192, 30, 118, 96, 60, 60, 224, 60, 60, 224, 124, 62,
  192, 124, 62, 0, 124, 62, 0, 124, 62, 0, 60, 60, 0, 60, 60, 0,
  30, 120, 0, 7, 224, 0, 56, 0, 0, 96, 0, 0, 96, 0, 0, 127,
  224, 0, 127, 254, 0, 127, 255, 0, 63, 255, 128, 31, 255, 128, 96, 7,
  128, 192, 3, 128, 128, 3, 128, 128, 3, 0, 128, 3, 0, 64, 6, 0,
  48, 28, 0, 15, 240, 0, 20, 28, 84, 22, 1, 0, 255, 0, 0, 31,
  0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0,
  0, 31, 0, 0, 31, 0, 0, 31, 30, 0, 31, 111, 0, 31, 135, 128,
  31, 135, 192, 31, 135, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31,
  7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7,
  192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 255, 223, 240,
  8, 28, 28, 12, 2, 0, 60, 126, 126, 126, 126, 60, 0, 0, 0, 252,
  124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124,
  124, 255, 12, 37, 74, 13, 254, 247, 1, 224, 3, 240, 3, 240, 3, 240,
  3, 240, 1, 224, 0, 0, 0, 0, 0, 0, 15, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 123, 224, 251, 224, 251, 224, 243, 192, 227, 192, 103, 128,
  30, 0, 20, 28, 84, 21, 1, 0, 255, 0, 0, 31, 0, 0, 31, 0,
  0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0,
  31, 0, 0, 31, 31, 192, 31, 7, 0, 31, 6, 0, 31, 4, 0, 31,
  8, 0, 31, 16, 0, 31, 16, 0, 31, 48, 0, 31, 120, 0, 31, 248,
  0, 31, 188, 0, 31, 60, 0, 31, 30, 0, 31, 31, 0, 31, 15, 0,
  31, 15, 128, 31, 15, 128, 31, 15, 192, 255, 223, 240, 11, 28, 56, 12,
  1, 0, 255, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 255, 224, 27, 19, 76, 30, 2, 0,
  254, 60, 30, 0, 62, 222, 111, 0, 63, 31, 143, 0, 63, 31, 143, 128,
  63, 31, 143, 128, 62, 31, 15, 128, 62, 31, 15, 128, 62, 31, 15, 128,
  62, 31, 15, 128, 62, 31, 15, 128, 62, 31, 15, 128, 62, 31, 15, 128,
  62, 31, 15, 128, 62, 31, 15, 128, 62, 31, 15, 128, 62, 31, 15, 128,
  62, 31, 15, 128, 62, 31, 15, 128, 255, 63, 223, 224, 19, 19, 57, 22,
  2, 0, 254, 60, 0, 62, 222, 0, 63, 15, 0, 63, 15, 128, 63, 15,
  128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128,
  62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62,
  15, 128, 62, 15, 128, 62, 15, 128, 255, 191, 224, 16, 19, 38, 20, 2,
  0, 7, 192, 12, 112, 28, 56, 56, 60, 120, 30, 120, 30, 248, 30, 248,
  31, 248, 31, 248, 31, 248, 31, 248, 31, 248, 30, 120, 30, 120, 30, 56,
  60, 28, 56, 12, 112, 7, 192, 18, 28, 84, 21, 1, 247, 255, 60, 0,
  31, 78, 0, 31, 143, 0, 31, 135, 128, 31, 7, 128, 31, 7, 128, 31,
  7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7, 192, 31, 7,
  192, 31, 7, 192, 31, 7, 128, 31, 7, 128, 31, 135, 128, 31, 143, 0,
  31, 78, 0, 31, 60, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31,
  0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 31, 0, 0, 255, 192,
  0, 17, 28, 84, 20, 2, 247, 7, 130, 0, 28, 194, 0, 60, 102, 0,
  120, 126, 0, 120, 62, 0, 120, 62, 0, 248, 62, 0, 248, 62, 0, 248,
  62, 0, 248, 62, 0, 248, 62, 0, 248, 62, 0, 248, 62, 0, 120, 62,
  0, 120, 62, 0, 120, 126, 0, 60, 126, 0, 28, 190, 0, 15, 62, 0,
  0, 62, 0, 0, 62, 0, 0, 62, 0, 0, 62, 0, 0, 62, 0, 0,
  62, 0, 0, 62, 0, 0, 62, 0, 0, 255, 128, 14, 19, 38, 17, 2,
  0, 254, 48, 62, 120, 62, 188, 63, 60, 63, 124, 62, 124, 62, 56, 62,
  0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62,
  0, 62, 0, 62, 0, 255, 128, 13, 19, 38, 16, 2, 0, 31, 16, 97,
  208, 96, 112, 224, 48, 224, 48, 240, 16, 248, 0, 126, 0, 127, 128, 63,
  224, 15, 240, 135, 240, 193, 248, 192, 120, 224, 56, 224, 24, 240, 16, 156,
  48, 135, 192, 12, 27, 54, 14, 1, 0, 6, 0, 6, 0, 6, 0, 6,
  0, 6, 0, 14, 0, 30, 0, 62, 0, 255, 224, 62, 0, 62, 0, 62,
  0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 0, 62, 16, 62,
  16, 62, 16, 62, 16, 62, 16, 62, 32, 62, 32, 31, 192, 7, 128, 19,
  19, 57, 21, 1, 0, 254, 63, 128, 62, 15, 128, 62, 15, 128, 62, 15,
  128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128,
  62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62, 15, 128, 62,
  31, 128, 62, 31, 128, 30, 47, 128, 30, 79, 128, 7, 143, 224, 18, 19,
  57, 20, 1, 0, 255, 143, 192, 62, 3, 0, 30, 2, 0, 30, 2, 0,
  31, 2, 0, 15, 4, 0, 15, 4, 0, 15, 132, 0, 7, 136, 0, 7,
  200, 0, 7, 216, 0, 3, 208, 0, 3, 240, 0, 3, 240, 0, 1, 224,
  0, 1, 224, 0, 0, 224, 0, 0, 192, 0, 0, 192, 0, 28, 19, 76,
  30, 1, 0, 255, 63, 231, 240, 62, 15, 129, 192, 30, 7, 129, 128, 30,
  7, 129, 128, 31, 7, 193, 0, 15, 7, 193, 0, 15, 7, 195, 0, 15,
  143, 226, 0, 7, 137, 226, 0, 7, 137, 230, 0, 7, 217, 244, 0, 3,
  208, 244, 0, 3, 240, 248, 0, 3, 240, 248, 0, 1, 224, 248, 0, 1,
  224, 112, 0, 1, 192, 112, 0, 0, 192, 112, 0, 0, 192, 32, 0, 18,
  19, 57, 20, 1, 0, 255, 63, 128, 126, 14, 0, 62, 12, 0, 31, 8,
  0, 31, 16, 0, 15, 176, 0, 15, 160, 0, 7, 192, 0, 3, 192, 0,
  3, 224, 0, 1, 240, 0, 3, 240, 0, 2, 248, 0, 4, 248, 0, 12,
  124, 0, 8, 126, 0, 24, 62, 0, 56, 63, 0, 254, 127, 192, 19, 28,
  84, 20, 0, 247, 255, 207, 224, 63, 3, 128, 31, 3, 0, 31, 2, 0,
  15, 2, 0, 15, 130, 0, 15, 130, 0, 7, 196, 0, 7, 196, 0, 3,
  196, 0, 3, 232, 0, 3, 232, 0, 1, 248, 0, 1, 248, 0, 0, 240,
  0, 0, 240, 0, 0, 112, 0, 0, 96, 0, 0, 96, 0, 0, 32, 0,
  0, 64, 0, 12, 64, 0, 30, 64, 0, 62, 64, 0, 62, 128, 0, 60,
  128, 0, 29, 0, 0, 14, 0, 0, 14, 19, 38, 17, 1, 0, 127, 252,
  120, 124, 112, 248, 96, 248, 65, 240, 65, 224, 67, 224, 3, 192, 7, 192,
  7, 128, 15, 128, 31, 4, 31, 4, 62, 4, 62, 12, 124, 12, 120, 28,
  248, 60, 255, 252, 12, 35, 70, 16, 2, 249, 1, 240, 7, 128, 15, 0,
  15, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 30, 0, 30, 0, 56, 0, 224, 0, 56, 0,
  30, 0, 30, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 15, 0, 15, 0, 7, 128, 1, 240,
  3, 36, 36, 11, 4, 248, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 12, 37, 74, 16, 2, 248,
  128, 0, 240, 0, 28, 0, 15, 0, 15, 0, 15, 128, 15, 128, 15, 128,
  15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128,
  7, 128, 3, 192, 0, 112, 3, 192, 7, 128, 15, 128, 15, 128, 15, 128,
  15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128,
  15, 0, 15, 0, 28, 0, 248, 0, 128, 0, 21, 8, 24, 25, 2, 6,
  62, 0, 48, 127, 192, 16, 255, 240, 8, 135, 252, 8, 129, 255, 24, 128,
  127, 248, 192, 31, 240, 96, 3, 224, 255
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--48-480-72-72-P-258-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 35, '1' Height: 34
  Calculated Max Values w=49 h=46 x= 9 y=28 dx=52 dy= 0 ascent=45 len=246
  Font Bounding box     w=133 h=60 x=-41 y=-14
  Calculated Min Values           x=-2 y=-12 dx= 0 dy= 0
  Pure Font   ascent =35 descent=-10
  X Font      ascent =35 descent=-10
  Max Font    ascent =45 descent=-12
*/
const u8g_fntpgm_uint8_t u8g_font_osb35[22097] U8G_FONT_SECTION("u8g_font_osb35") = {
  0, 133, 60, 215, 242, 35, 12, 220, 29, 224, 32, 255, 246, 45, 244, 35,
  246, 0, 0, 0, 13, 0, 0, 8, 34, 34, 14, 3, 1, 126, 126, 255,
  255, 255, 255, 255, 255, 126, 126, 126, 126, 60, 60, 60, 60, 60, 24, 24,
  24, 24, 24, 24, 24, 24, 0, 0, 0, 126, 255, 255, 255, 255, 126, 12,
  12, 24, 18, 3, 23, 32, 64, 241, 224, 249, 240, 249, 240, 249, 240, 249,
  240, 249, 240, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 28, 34, 136,
  34, 3, 0, 0, 112, 14, 0, 0, 112, 14, 0, 0, 112, 14, 0, 0,
  112, 14, 0, 0, 240, 30, 0, 0, 224, 28, 0, 0, 224, 28, 0, 0,
  224, 28, 0, 0, 224, 28, 0, 255, 255, 255, 240, 255, 255, 255, 240, 255,
  255, 255, 240, 1, 192, 56, 0, 1, 192, 56, 0, 1, 192, 56, 0, 1,
  192, 56, 0, 3, 192, 56, 0, 3, 128, 120, 0, 3, 128, 112, 0, 3,
  128, 112, 0, 3, 128, 112, 0, 3, 128, 112, 0, 255, 255, 255, 224, 255,
  255, 255, 224, 255, 255, 255, 224, 7, 0, 224, 0, 7, 0, 224, 0, 7,
  0, 224, 0, 7, 0, 224, 0, 15, 1, 224, 0, 14, 1, 224, 0, 14,
  1, 192, 0, 14, 1, 192, 0, 14, 1, 192, 0, 23, 42, 126, 28, 2,
  252, 0, 195, 0, 0, 195, 0, 0, 195, 0, 0, 195, 0, 3, 255, 192,
  7, 195, 112, 28, 195, 24, 60, 195, 12, 56, 195, 14, 120, 195, 14, 120,
  195, 30, 120, 195, 62, 124, 195, 126, 126, 195, 126, 127, 195, 124, 127, 195,
  56, 63, 243, 0, 63, 251, 0, 31, 255, 0, 31, 255, 128, 7, 255, 192,
  3, 255, 240, 0, 255, 248, 0, 255, 248, 0, 223, 252, 0, 199, 252, 124,
  195, 254, 124, 195, 254, 252, 195, 126, 252, 195, 62, 248, 195, 30, 240, 195,
  30, 224, 195, 28, 96, 195, 28, 112, 195, 56, 56, 195, 56, 28, 195, 96,
  7, 255, 192, 0, 195, 0, 0, 195, 0, 0, 195, 0, 0, 195, 0, 33,
  35, 175, 41, 4, 0, 0, 0, 0, 48, 0, 15, 192, 0, 96, 0, 60,
  240, 0, 224, 0, 56, 112, 0, 192, 0, 120, 120, 1, 128, 0, 120, 120,
  1, 128, 0, 248, 124, 3, 0, 0, 248, 124, 7, 0, 0, 248, 124, 6,
  0, 0, 248, 124, 14, 0, 0, 248, 124, 12, 0, 0, 248, 124, 24, 0,
  0, 120, 120, 24, 0, 0, 120, 120, 48, 0, 0, 56, 240, 112, 0, 0,
  28, 224, 96, 0, 0, 15, 192, 192, 0, 0, 0, 0, 192, 0, 0, 0,
  1, 128, 240, 0, 0, 3, 131, 156, 0, 0, 3, 7, 158, 0, 0, 7,
  15, 15, 0, 0, 6, 15, 15, 0, 0, 12, 31, 15, 128, 0, 12, 31,
  15, 128, 0, 24, 31, 15, 128, 0, 56, 31, 15, 128, 0, 48, 31, 15,
  128, 0, 96, 31, 15, 128, 0, 96, 31, 15, 128, 0, 192, 15, 15, 0,
  1, 192, 15, 15, 0, 1, 128, 7, 14, 0, 3, 128, 7, 158, 0, 3,
  0, 1, 248, 0, 33, 34, 170, 37, 2, 1, 0, 31, 224, 0, 0, 0,
  112, 112, 0, 0, 0, 224, 48, 0, 0, 0, 224, 24, 0, 0, 1, 224,
  24, 0, 0, 1, 224, 24, 0, 0, 1, 224, 24, 0, 0, 1, 240, 56,
  0, 0, 1, 240, 48, 0, 0, 1, 248, 96, 0, 0, 1, 248, 192, 0,
  0, 0, 255, 128, 0, 0, 0, 255, 0, 0, 0, 0, 126, 0, 0, 0,
  0, 63, 0, 0, 0, 0, 255, 129, 255, 128, 1, 223, 128, 62, 0, 3,
  143, 192, 28, 0, 7, 15, 224, 24, 0, 14, 7, 224, 56, 0, 30, 3,
  240, 48, 0, 60, 1, 248, 48, 0, 124, 1, 248, 96, 0, 124, 0, 252,
  96, 0, 252, 0, 126, 192, 0, 252, 0, 127, 128, 0, 252, 0, 63, 128,
  0, 254, 0, 31, 128, 0, 255, 0, 31, 128, 0, 255, 0, 15, 193, 128,
  127, 192, 63, 225, 0, 63, 248, 247, 243, 0, 31, 255, 195, 254, 0, 15,
  254, 0, 252, 0, 5, 12, 12, 11, 3, 23, 32, 240, 248, 248, 248, 248,
  248, 112, 112, 112, 112, 112, 14, 43, 86, 18, 3, 248, 0, 28, 0, 56,
  0, 112, 0, 224, 1, 192, 3, 128, 7, 0, 15, 0, 14, 0, 30, 0,
  30, 0, 60, 0, 60, 0, 124, 0, 124, 0, 124, 0, 252, 0, 252, 0,
  252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0,
  124, 0, 124, 0, 124, 0, 124, 0, 60, 0, 60, 0, 30, 0, 30, 0,
  14, 0, 15, 0, 7, 0, 3, 128, 1, 192, 0, 224, 0, 112, 0, 56,
  0, 12, 13, 43, 86, 17, 1, 248, 192, 0, 224, 0, 48, 0, 24, 0,
  28, 0, 14, 0, 7, 0, 7, 128, 3, 128, 3, 192, 1, 224, 1, 224,
  1, 224, 1, 240, 1, 240, 1, 240, 1, 248, 1, 248, 1, 248, 1, 248,
  1, 248, 1, 248, 1, 248, 1, 248, 1, 248, 1, 248, 1, 248, 1, 240,
  1, 240, 1, 240, 1, 224, 1, 224, 3, 192, 3, 192, 3, 128, 7, 128,
  7, 0, 14, 0, 28, 0, 56, 0, 112, 0, 224, 0, 128, 0, 17, 19,
  57, 24, 4, 13, 1, 128, 0, 3, 192, 0, 3, 192, 0, 227, 195, 0,
  241, 135, 128, 248, 143, 128, 252, 159, 128, 126, 191, 0, 3, 192, 0, 3,
  192, 0, 126, 191, 0, 252, 159, 128, 248, 143, 128, 241, 135, 128, 225, 195,
  0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 1, 128, 0, 41, 41, 246,
  45, 2, 249, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0,
  0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0,
  0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28,
  0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0,
  0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0,
  0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28,
  0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0,
  0, 28, 0, 0, 0, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255, 255,
  128, 255, 255, 255, 255, 255, 128, 0, 0, 28, 0, 0, 0, 0, 0, 28,
  0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0,
  0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0,
  0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28,
  0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0,
  0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0,
  0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28,
  0, 0, 0, 0, 0, 28, 0, 0, 0, 9, 15, 30, 13, 2, 248, 126,
  0, 255, 0, 255, 128, 255, 128, 255, 128, 127, 128, 1, 128, 1, 128, 1,
  128, 3, 0, 2, 0, 6, 0, 28, 0, 56, 0, 96, 0, 12, 5, 10,
  18, 3, 10, 255, 240, 255, 240, 255, 240, 255, 240, 255, 240, 8, 6, 6,
  14, 3, 1, 126, 255, 255, 255, 255, 126, 16, 44, 88, 22, 3, 247, 0,
  7, 0, 15, 0, 14, 0, 14, 0, 14, 0, 30, 0, 28, 0, 28, 0,
  60, 0, 56, 0, 56, 0, 120, 0, 112, 0, 112, 0, 240, 0, 224, 0,
  224, 0, 224, 1, 224, 1, 192, 1, 192, 3, 192, 3, 128, 3, 128, 7,
  128, 7, 0, 7, 0, 15, 0, 14, 0, 14, 0, 14, 0, 30, 0, 28,
  0, 28, 0, 60, 0, 56, 0, 56, 0, 120, 0, 112, 0, 112, 0, 240,
  0, 224, 0, 224, 0, 224, 0, 23, 35, 105, 28, 2, 0, 0, 16, 0,
  0, 254, 0, 3, 199, 128, 7, 131, 192, 15, 1, 224, 15, 1, 224, 31,
  1, 240, 63, 1, 248, 63, 1, 248, 127, 1, 248, 127, 1, 252, 127, 1,
  252, 127, 1, 252, 255, 1, 254, 255, 1, 254, 255, 1, 254, 255, 1, 254,
  255, 1, 254, 255, 1, 254, 255, 1, 254, 255, 1, 254, 255, 1, 254, 255,
  1, 254, 127, 1, 252, 127, 1, 252, 127, 1, 252, 127, 1, 252, 63, 1,
  248, 63, 1, 248, 31, 1, 240, 15, 1, 224, 15, 1, 224, 7, 131, 192,
  3, 199, 128, 0, 254, 0, 16, 34, 68, 28, 6, 0, 0, 240, 0, 240,
  1, 240, 7, 240, 255, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240,
  7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240,
  7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240,
  7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 255, 255, 255, 255,
  21, 34, 102, 28, 3, 1, 7, 255, 0, 14, 15, 192, 28, 7, 224, 56,
  7, 240, 120, 3, 240, 120, 3, 248, 248, 3, 248, 252, 3, 248, 255, 3,
  248, 255, 3, 248, 255, 7, 248, 127, 7, 240, 63, 15, 240, 12, 15, 224,
  0, 31, 192, 0, 63, 128, 0, 127, 0, 0, 252, 0, 1, 240, 0, 3,
  192, 0, 7, 128, 0, 14, 0, 24, 12, 0, 24, 24, 0, 24, 48, 0,
  24, 96, 0, 24, 111, 192, 56, 127, 255, 248, 255, 255, 240, 239, 255, 240,
  195, 255, 240, 193, 255, 224, 192, 255, 192, 192, 63, 128, 22, 34, 102, 28,
  3, 1, 7, 255, 0, 14, 15, 192, 28, 7, 224, 56, 7, 240, 120, 3,
  240, 124, 3, 248, 126, 3, 248, 127, 3, 248, 127, 3, 248, 127, 3, 248,
  63, 3, 240, 30, 3, 240, 0, 7, 224, 0, 7, 192, 0, 15, 0, 7,
  248, 0, 0, 31, 128, 0, 15, 192, 0, 7, 224, 0, 7, 240, 0, 3,
  248, 0, 3, 248, 62, 3, 252, 127, 3, 252, 255, 3, 252, 255, 3, 252,
  255, 3, 252, 254, 3, 252, 252, 3, 248, 248, 7, 248, 120, 7, 240, 56,
  15, 224, 30, 31, 192, 15, 255, 0, 23, 34, 102, 28, 2, 0, 0, 7,
  192, 0, 15, 192, 0, 15, 192, 0, 31, 192, 0, 63, 192, 0, 63, 192,
  0, 127, 192, 0, 127, 192, 0, 255, 192, 0, 223, 192, 1, 223, 192, 1,
  159, 192, 3, 159, 192, 7, 31, 192, 6, 31, 192, 14, 31, 192, 12, 31,
  192, 28, 31, 192, 24, 31, 192, 56, 31, 192, 112, 31, 192, 96, 31, 192,
  224, 31, 192, 255, 255, 254, 0, 31, 192, 0, 31, 192, 0, 31, 192, 0,
  31, 192, 0, 31, 192, 0, 31, 192, 0, 31, 192, 0, 31, 192, 7, 255,
  252, 7, 255, 252, 21, 34, 102, 28, 4, 0, 32, 0, 192, 60, 7, 128,
  63, 255, 128, 63, 255, 0, 63, 254, 0, 63, 248, 0, 63, 224, 0, 63,
  0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0,
  0, 49, 252, 0, 54, 63, 0, 60, 15, 192, 56, 15, 224, 48, 15, 224,
  32, 7, 240, 0, 7, 240, 0, 7, 248, 0, 7, 248, 8, 7, 248, 62,
  7, 248, 126, 7, 248, 254, 7, 248, 254, 7, 248, 254, 7, 240, 248, 7,
  240, 240, 7, 224, 112, 15, 192, 48, 15, 192, 28, 31, 0, 15, 252, 0,
  22, 34, 102, 28, 3, 1, 0, 255, 128, 3, 192, 192, 7, 192, 96, 15,
  128, 240, 31, 131, 240, 31, 7, 240, 63, 15, 240, 63, 15, 240, 127, 15,
  224, 127, 7, 192, 127, 3, 0, 127, 0, 0, 255, 0, 0, 255, 0, 0,
  255, 63, 0, 255, 255, 192, 255, 195, 224, 255, 131, 240, 255, 3, 248, 255,
  1, 248, 255, 1, 252, 255, 1, 252, 255, 1, 252, 127, 1, 252, 127, 1,
  252, 127, 1, 252, 127, 1, 252, 63, 1, 248, 63, 1, 248, 31, 1, 248,
  15, 129, 240, 7, 131, 224, 3, 195, 192, 1, 255, 0, 20, 34, 102, 28,
  5, 1, 71, 224, 224, 207, 240, 224, 223, 248, 112, 255, 252, 48, 255, 254,
  48, 255, 255, 240, 255, 255, 240, 224, 31, 176, 192, 0, 32, 192, 0, 96,
  128, 0, 96, 128, 0, 192, 128, 1, 192, 0, 1, 128, 0, 3, 128, 0,
  7, 0, 0, 15, 0, 0, 14, 0, 0, 30, 0, 0, 60, 0, 0, 124,
  0, 0, 252, 0, 1, 252, 0, 1, 248, 0, 3, 248, 0, 3, 248, 0,
  7, 248, 0, 7, 248, 0, 7, 248, 0, 7, 248, 0, 7, 248, 0, 7,
  248, 0, 3, 248, 0, 3, 240, 0, 23, 34, 102, 28, 3, 1, 1, 255,
  128, 7, 0, 192, 12, 0, 96, 28, 0, 48, 56, 0, 24, 56, 0, 24,
  120, 0, 24, 120, 0, 24, 124, 0, 24, 126, 0, 24, 127, 0, 48, 127,
  192, 32, 127, 240, 96, 63, 255, 128, 63, 255, 0, 31, 255, 192, 15, 255,
  240, 7, 255, 248, 15, 255, 248, 24, 63, 252, 48, 15, 252, 112, 3, 254,
  96, 0, 254, 224, 0, 126, 224, 0, 62, 224, 0, 30, 224, 0, 30, 224,
  0, 12, 240, 0, 28, 112, 0, 24, 56, 0, 24, 28, 0, 48, 15, 0,
  192, 3, 255, 0, 22, 34, 102, 28, 3, 1, 3, 254, 0, 15, 15, 0,
  31, 7, 128, 62, 7, 192, 126, 3, 224, 126, 3, 240, 126, 3, 240, 254,
  3, 248, 254, 3, 248, 254, 3, 248, 254, 3, 248, 254, 3, 252, 254, 3,
  252, 254, 3, 252, 126, 3, 252, 127, 7, 252, 63, 7, 252, 31, 15, 252,
  15, 255, 252, 3, 243, 252, 0, 3, 252, 0, 3, 252, 0, 3, 248, 7,
  3, 248, 31, 131, 248, 31, 195, 248, 63, 195, 240, 63, 195, 240, 63, 131,
  224, 62, 7, 224, 60, 7, 192, 28, 15, 128, 14, 31, 0, 7, 252, 0,
  8, 22, 22, 14, 3, 1, 126, 255, 255, 255, 255, 126, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 126, 255, 255, 255, 255, 126, 9, 32, 64, 13,
  2, 247, 63, 0, 127, 128, 127, 128, 127, 128, 127, 128, 63, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 60, 0, 127, 0, 255, 0, 255, 128, 255, 128, 255, 128, 57, 128,
  1, 128, 1, 128, 3, 0, 3, 0, 6, 0, 12, 0, 56, 0, 240, 0,
  64, 0, 37, 40, 200, 45, 4, 249, 0, 0, 0, 0, 48, 0, 0, 0,
  0, 240, 0, 0, 0, 1, 248, 0, 0, 0, 7, 224, 0, 0, 0, 31,
  128, 0, 0, 0, 126, 0, 0, 0, 1, 252, 0, 0, 0, 7, 240, 0,
  0, 0, 15, 192, 0, 0, 0, 63, 0, 0, 0, 0, 252, 0, 0, 0,
  3, 240, 0, 0, 0, 15, 224, 0, 0, 0, 63, 128, 0, 0, 0, 126,
  0, 0, 0, 1, 248, 0, 0, 0, 7, 224, 0, 0, 0, 31, 128, 0,
  0, 0, 127, 0, 0, 0, 0, 252, 0, 0, 0, 0, 248, 0, 0, 0,
  0, 126, 0, 0, 0, 0, 31, 128, 0, 0, 0, 15, 224, 0, 0, 0,
  3, 248, 0, 0, 0, 0, 252, 0, 0, 0, 0, 63, 0, 0, 0, 0,
  15, 192, 0, 0, 0, 3, 240, 0, 0, 0, 1, 252, 0, 0, 0, 0,
  127, 0, 0, 0, 0, 31, 192, 0, 0, 0, 7, 224, 0, 0, 0, 1,
  248, 0, 0, 0, 0, 126, 0, 0, 0, 0, 63, 128, 0, 0, 0, 15,
  224, 0, 0, 0, 3, 248, 0, 0, 0, 0, 248, 0, 0, 0, 0, 48,
  41, 13, 78, 45, 2, 6, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255,
  255, 128, 255, 255, 255, 255, 255, 128, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255, 255, 128, 255, 255,
  255, 255, 255, 128, 37, 40, 200, 45, 4, 249, 96, 0, 0, 0, 0, 120,
  0, 0, 0, 0, 252, 0, 0, 0, 0, 63, 0, 0, 0, 0, 15, 192,
  0, 0, 0, 3, 240, 0, 0, 0, 1, 252, 0, 0, 0, 0, 127, 0,
  0, 0, 0, 31, 128, 0, 0, 0, 7, 224, 0, 0, 0, 1, 248, 0,
  0, 0, 0, 126, 0, 0, 0, 0, 63, 128, 0, 0, 0, 15, 224, 0,
  0, 0, 3, 240, 0, 0, 0, 0, 252, 0, 0, 0, 0, 63, 0, 0,
  0, 0, 15, 192, 0, 0, 0, 7, 240, 0, 0, 0, 1, 248, 0, 0,
  0, 0, 248, 0, 0, 0, 3, 240, 0, 0, 0, 15, 192, 0, 0, 0,
  63, 128, 0, 0, 0, 254, 0, 0, 0, 1, 248, 0, 0, 0, 7, 224,
  0, 0, 0, 31, 128, 0, 0, 0, 126, 0, 0, 0, 1, 252, 0, 0,
  0, 7, 240, 0, 0, 0, 31, 192, 0, 0, 0, 63, 0, 0, 0, 0,
  252, 0, 0, 0, 3, 240, 0, 0, 0, 15, 224, 0, 0, 0, 63, 128,
  0, 0, 0, 254, 0, 0, 0, 0, 248, 0, 0, 0, 0, 96, 0, 0,
  0, 0, 15, 34, 68, 22, 3, 1, 31, 240, 59, 248, 96, 252, 96, 252,
  192, 126, 192, 126, 192, 126, 192, 126, 192, 126, 64, 252, 96, 252, 48, 248,
  1, 240, 1, 224, 3, 192, 3, 128, 7, 0, 7, 0, 14, 0, 12, 16,
  12, 16, 12, 16, 12, 16, 6, 32, 3, 192, 0, 0, 0, 0, 0, 128,
  3, 224, 7, 240, 7, 240, 7, 240, 7, 240, 3, 224, 35, 34, 170, 39,
  2, 1, 0, 15, 255, 0, 0, 0, 56, 1, 224, 0, 0, 224, 0, 112,
  0, 1, 128, 0, 28, 0, 7, 0, 0, 14, 0, 14, 0, 0, 7, 0,
  12, 0, 248, 3, 0, 28, 3, 205, 243, 128, 56, 7, 135, 241, 128, 56,
  15, 7, 225, 192, 112, 31, 7, 225, 192, 112, 62, 7, 224, 224, 112, 62,
  7, 224, 224, 224, 124, 7, 192, 224, 224, 124, 7, 192, 224, 224, 124, 7,
  192, 224, 224, 252, 15, 192, 224, 224, 248, 15, 128, 224, 224, 248, 15, 128,
  224, 224, 248, 15, 129, 192, 224, 248, 31, 129, 192, 224, 248, 31, 129, 128,
  112, 248, 31, 3, 128, 112, 248, 63, 3, 0, 112, 120, 111, 6, 0, 56,
  60, 199, 140, 0, 56, 31, 3, 240, 0, 28, 0, 0, 0, 0, 14, 0,
  0, 0, 0, 7, 0, 0, 0, 0, 3, 128, 0, 0, 0, 1, 192, 0,
  96, 0, 0, 120, 1, 192, 0, 0, 31, 255, 0, 0, 33, 35, 175, 36,
  2, 0, 0, 0, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 224, 0,
  0, 0, 1, 224, 0, 0, 0, 3, 224, 0, 0, 0, 3, 240, 0, 0,
  0, 3, 240, 0, 0, 0, 7, 240, 0, 0, 0, 7, 248, 0, 0, 0,
  7, 248, 0, 0, 0, 15, 248, 0, 0, 0, 15, 252, 0, 0, 0, 15,
  252, 0, 0, 0, 25, 252, 0, 0, 0, 25, 254, 0, 0, 0, 25, 254,
  0, 0, 0, 48, 254, 0, 0, 0, 48, 255, 0, 0, 0, 32, 255, 0,
  0, 0, 96, 127, 0, 0, 0, 96, 127, 128, 0, 0, 64, 127, 128, 0,
  0, 192, 63, 128, 0, 0, 192, 63, 192, 0, 0, 255, 255, 192, 0, 1,
  255, 255, 192, 0, 1, 128, 31, 224, 0, 1, 0, 31, 224, 0, 3, 0,
  15, 224, 0, 3, 0, 15, 240, 0, 2, 0, 15, 240, 0, 6, 0, 7,
  240, 0, 15, 0, 7, 248, 0, 31, 0, 15, 252, 0, 255, 240, 255, 255,
  128, 28, 34, 136, 33, 3, 0, 255, 255, 240, 0, 15, 224, 126, 0, 15,
  224, 31, 0, 15, 224, 31, 128, 15, 224, 15, 192, 15, 224, 15, 192, 15,
  224, 15, 224, 15, 224, 15, 224, 15, 224, 15, 224, 15, 224, 15, 224, 15,
  224, 15, 224, 15, 224, 15, 192, 15, 224, 15, 192, 15, 224, 31, 128, 15,
  224, 30, 0, 15, 224, 60, 0, 15, 255, 224, 0, 15, 224, 124, 0, 15,
  224, 63, 0, 15, 224, 31, 128, 15, 224, 15, 192, 15, 224, 15, 224, 15,
  224, 15, 240, 15, 224, 15, 240, 15, 224, 15, 240, 15, 224, 15, 240, 15,
  224, 15, 240, 15, 224, 15, 240, 15, 224, 15, 224, 15, 224, 15, 224, 15,
  224, 31, 192, 15, 224, 31, 128, 15, 224, 126, 0, 255, 255, 248, 0, 26,
  34, 136, 31, 3, 1, 0, 127, 193, 128, 1, 224, 241, 128, 3, 192, 63,
  128, 15, 128, 31, 128, 15, 128, 15, 128, 31, 0, 15, 128, 63, 0, 7,
  128, 63, 0, 7, 128, 127, 0, 3, 128, 127, 0, 3, 128, 127, 0, 3,
  128, 127, 0, 1, 128, 255, 0, 1, 128, 255, 0, 1, 128, 255, 0, 1,
  128, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0,
  0, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 192, 127, 0, 0,
  192, 127, 0, 0, 192, 127, 0, 0, 128, 63, 0, 1, 128, 63, 0, 1,
  128, 63, 0, 1, 128, 31, 128, 3, 0, 15, 128, 3, 0, 7, 128, 6,
  0, 3, 192, 12, 0, 1, 224, 56, 0, 0, 127, 224, 0, 32, 34, 136,
  37, 3, 0, 255, 255, 248, 0, 15, 224, 31, 0, 15, 224, 7, 128, 15,
  224, 3, 224, 15, 224, 1, 240, 15, 224, 1, 240, 15, 224, 0, 248, 15,
  224, 0, 252, 15, 224, 0, 252, 15, 224, 0, 254, 15, 224, 0, 254, 15,
  224, 0, 254, 15, 224, 0, 255, 15, 224, 0, 255, 15, 224, 0, 255, 15,
  224, 0, 255, 15, 224, 0, 255, 15, 224, 0, 255, 15, 224, 0, 255, 15,
  224, 0, 255, 15, 224, 0, 255, 15, 224, 0, 254, 15, 224, 0, 254, 15,
  224, 0, 254, 15, 224, 0, 254, 15, 224, 0, 252, 15, 224, 0, 252, 15,
  224, 0, 248, 15, 224, 1, 240, 15, 224, 1, 224, 15, 224, 3, 192, 15,
  224, 7, 128, 15, 224, 30, 0, 255, 255, 248, 0, 27, 34, 136, 33, 3,
  0, 255, 255, 255, 224, 15, 224, 31, 224, 15, 224, 7, 224, 15, 224, 3,
  224, 15, 224, 1, 224, 15, 224, 1, 224, 15, 224, 0, 224, 15, 224, 0,
  224, 15, 224, 0, 96, 15, 224, 48, 96, 15, 224, 48, 96, 15, 224, 48,
  0, 15, 224, 112, 0, 15, 224, 112, 0, 15, 224, 240, 0, 15, 225, 240,
  0, 15, 255, 240, 0, 15, 225, 240, 0, 15, 224, 240, 0, 15, 224, 112,
  0, 15, 224, 112, 32, 15, 224, 48, 96, 15, 224, 48, 96, 15, 224, 48,
  96, 15, 224, 0, 96, 15, 224, 0, 96, 15, 224, 0, 224, 15, 224, 0,
  224, 15, 224, 1, 224, 15, 224, 3, 224, 15, 224, 3, 224, 15, 224, 15,
  224, 255, 255, 255, 224, 255, 255, 255, 224, 28, 34, 136, 32, 3, 0, 255,
  255, 255, 240, 7, 240, 15, 240, 7, 240, 3, 240, 7, 240, 1, 240, 7,
  240, 1, 240, 7, 240, 0, 240, 7, 240, 0, 240, 7, 240, 0, 112, 7,
  240, 0, 112, 7, 240, 24, 48, 7, 240, 24, 48, 7, 240, 24, 48, 7,
  240, 56, 48, 7, 240, 56, 0, 7, 240, 120, 0, 7, 240, 248, 0, 7,
  255, 248, 0, 7, 240, 248, 0, 7, 240, 120, 0, 7, 240, 56, 0, 7,
  240, 56, 0, 7, 240, 24, 0, 7, 240, 24, 0, 7, 240, 24, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 255, 255, 128, 0, 30, 34, 136, 35, 3, 1, 0, 127, 224,
  192, 0, 224, 120, 192, 3, 192, 31, 192, 7, 128, 15, 192, 15, 128, 7,
  192, 31, 0, 7, 192, 31, 0, 3, 192, 63, 0, 3, 192, 63, 0, 1,
  192, 127, 0, 1, 192, 127, 0, 1, 192, 127, 0, 0, 192, 255, 0, 0,
  192, 255, 0, 0, 192, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0,
  0, 255, 3, 255, 252, 255, 3, 255, 252, 255, 0, 31, 192, 255, 0, 31,
  192, 255, 0, 31, 192, 127, 0, 31, 192, 127, 0, 31, 192, 127, 0, 31,
  192, 127, 0, 31, 192, 63, 0, 31, 192, 63, 0, 31, 192, 31, 0, 31,
  192, 15, 128, 57, 192, 15, 128, 49, 192, 7, 192, 96, 192, 1, 224, 192,
  192, 0, 127, 128, 192, 34, 34, 170, 39, 3, 0, 255, 255, 63, 255, 192,
  7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7,
  240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240,
  1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1,
  252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252,
  0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 255, 255, 252, 0,
  7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7,
  240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240,
  1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1,
  252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252,
  0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0,
  255, 255, 63, 255, 192, 16, 34, 68, 21, 3, 0, 255, 255, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 255, 255, 23,
  34, 102, 26, 2, 0, 1, 255, 254, 0, 15, 224, 0, 15, 224, 0, 15,
  224, 0, 15, 224, 0, 15, 224, 0, 15, 224, 0, 15, 224, 0, 15, 224,
  0, 15, 224, 0, 15, 224, 0, 15, 224, 0, 15, 224, 0, 15, 224, 0,
  15, 224, 0, 15, 224, 0, 15, 224, 0, 15, 224, 0, 15, 224, 0, 15,
  224, 0, 15, 224, 30, 15, 224, 126, 15, 224, 127, 15, 224, 255, 15, 224,
  255, 15, 224, 254, 15, 224, 254, 15, 224, 248, 15, 192, 112, 15, 192, 96,
  15, 128, 48, 31, 0, 24, 30, 0, 15, 248, 0, 33, 34, 170, 37, 3,
  0, 255, 255, 31, 254, 0, 7, 240, 7, 240, 0, 7, 240, 3, 192, 0,
  7, 240, 3, 128, 0, 7, 240, 3, 0, 0, 7, 240, 7, 0, 0, 7,
  240, 14, 0, 0, 7, 240, 12, 0, 0, 7, 240, 24, 0, 0, 7, 240,
  48, 0, 0, 7, 240, 96, 0, 0, 7, 240, 224, 0, 0, 7, 240, 224,
  0, 0, 7, 241, 240, 0, 0, 7, 243, 240, 0, 0, 7, 247, 248, 0,
  0, 7, 255, 252, 0, 0, 7, 255, 252, 0, 0, 7, 249, 254, 0, 0,
  7, 241, 254, 0, 0, 7, 240, 255, 0, 0, 7, 240, 255, 0, 0, 7,
  240, 127, 128, 0, 7, 240, 127, 128, 0, 7, 240, 63, 192, 0, 7, 240,
  63, 192, 0, 7, 240, 31, 224, 0, 7, 240, 31, 224, 0, 7, 240, 15,
  240, 0, 7, 240, 15, 240, 0, 7, 240, 7, 248, 0, 7, 240, 7, 248,
  0, 7, 240, 7, 252, 0, 255, 255, 63, 255, 128, 28, 34, 136, 32, 3,
  0, 255, 255, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0,
  0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0,
  0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0,
  0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0,
  0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0,
  48, 7, 240, 0, 48, 7, 240, 0, 48, 7, 240, 0, 112, 7, 240, 0,
  112, 7, 240, 0, 112, 7, 240, 0, 240, 7, 240, 0, 240, 7, 240, 0,
  240, 7, 240, 1, 240, 7, 240, 3, 240, 7, 240, 3, 240, 7, 240, 7,
  240, 255, 255, 255, 240, 255, 255, 255, 240, 39, 34, 170, 43, 2, 0, 255,
  240, 0, 63, 254, 7, 240, 0, 63, 192, 7, 248, 0, 63, 192, 7, 248,
  0, 63, 192, 7, 248, 0, 127, 192, 7, 252, 0, 127, 192, 7, 252, 0,
  95, 192, 7, 252, 0, 95, 192, 7, 254, 0, 223, 192, 6, 254, 0, 223,
  192, 6, 255, 0, 159, 192, 6, 127, 0, 159, 192, 6, 127, 1, 159, 192,
  6, 127, 129, 159, 192, 6, 63, 129, 31, 192, 6, 63, 129, 31, 192, 6,
  63, 195, 31, 192, 6, 31, 194, 31, 192, 6, 31, 226, 31, 192, 6, 15,
  226, 31, 192, 6, 15, 230, 31, 192, 6, 15, 244, 31, 192, 6, 7, 244,
  31, 192, 6, 7, 244, 31, 192, 6, 7, 252, 31, 192, 6, 3, 248, 31,
  192, 6, 3, 248, 31, 192, 6, 1, 248, 31, 192, 6, 1, 248, 31, 192,
  6, 1, 240, 31, 192, 6, 0, 240, 31, 192, 15, 0, 240, 31, 192, 63,
  192, 240, 31, 192, 255, 240, 97, 255, 254, 34, 35, 175, 37, 2, 255, 255,
  224, 15, 255, 192, 31, 240, 3, 255, 0, 15, 240, 0, 252, 0, 15, 248,
  0, 120, 0, 7, 252, 0, 48, 0, 3, 254, 0, 48, 0, 3, 254, 0,
  48, 0, 3, 255, 0, 48, 0, 3, 255, 128, 48, 0, 3, 255, 128, 48,
  0, 3, 127, 192, 48, 0, 3, 63, 224, 48, 0, 3, 31, 224, 48, 0,
  3, 31, 240, 48, 0, 3, 15, 248, 48, 0, 3, 7, 248, 48, 0, 3,
  7, 252, 48, 0, 3, 3, 254, 48, 0, 3, 1, 255, 48, 0, 3, 1,
  255, 48, 0, 3, 0, 255, 176, 0, 3, 0, 127, 240, 0, 3, 0, 127,
  240, 0, 3, 0, 63, 240, 0, 3, 0, 31, 240, 0, 3, 0, 15, 240,
  0, 3, 0, 15, 240, 0, 3, 0, 7, 240, 0, 3, 0, 3, 240, 0,
  3, 0, 3, 240, 0, 7, 128, 1, 240, 0, 15, 192, 0, 240, 0, 63,
  240, 0, 240, 0, 255, 252, 0, 112, 0, 0, 0, 0, 48, 0, 28, 34,
  136, 33, 3, 1, 0, 63, 192, 0, 0, 224, 112, 0, 3, 192, 56, 0,
  7, 128, 30, 0, 15, 128, 30, 0, 15, 0, 15, 0, 31, 0, 15, 128,
  63, 0, 15, 192, 63, 0, 15, 192, 127, 0, 15, 192, 127, 0, 15, 224,
  127, 0, 15, 224, 127, 0, 15, 224, 255, 0, 15, 240, 255, 0, 15, 240,
  255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240,
  255, 0, 15, 240, 255, 0, 15, 240, 127, 0, 15, 224, 127, 0, 15, 224,
  127, 0, 15, 224, 127, 0, 15, 192, 63, 0, 15, 192, 63, 0, 15, 192,
  31, 0, 15, 128, 15, 0, 15, 0, 15, 128, 31, 0, 7, 128, 30, 0,
  3, 192, 60, 0, 0, 224, 112, 0, 0, 63, 192, 0, 29, 34, 136, 34,
  3, 0, 255, 255, 248, 0, 7, 240, 63, 0, 7, 240, 15, 192, 7, 240,
  15, 224, 7, 240, 15, 240, 7, 240, 7, 240, 7, 240, 7, 248, 7, 240,
  7, 248, 7, 240, 7, 248, 7, 240, 7, 248, 7, 240, 7, 248, 7, 240,
  7, 248, 7, 240, 7, 240, 7, 240, 15, 240, 7, 240, 15, 224, 7, 240,
  15, 192, 7, 240, 31, 0, 7, 255, 252, 0, 7, 240, 0, 0, 7, 240,
  0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240,
  0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240,
  0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240,
  0, 0, 7, 240, 0, 0, 255, 255, 128, 0, 28, 45, 180, 33, 3, 246,
  0, 63, 192, 0, 0, 224, 112, 0, 3, 192, 56, 0, 7, 128, 30, 0,
  15, 128, 30, 0, 15, 0, 15, 0, 31, 0, 15, 128, 63, 0, 15, 128,
  63, 0, 15, 192, 127, 0, 15, 192, 127, 0, 15, 224, 127, 0, 15, 224,
  127, 0, 15, 224, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240,
  255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240,
  255, 0, 15, 240, 255, 0, 15, 240, 127, 0, 15, 224, 127, 0, 15, 224,
  127, 0, 15, 224, 63, 0, 15, 192, 63, 15, 15, 192, 31, 17, 143, 128,
  15, 160, 223, 0, 15, 160, 223, 0, 7, 160, 254, 0, 3, 224, 252, 16,
  0, 240, 248, 16, 0, 127, 224, 16, 0, 0, 224, 16, 0, 0, 224, 16,
  0, 0, 224, 48, 0, 0, 240, 48, 0, 0, 248, 112, 0, 0, 255, 240,
  0, 0, 255, 224, 0, 0, 127, 224, 0, 0, 127, 192, 0, 0, 63, 128,
  0, 0, 31, 0, 32, 36, 144, 36, 3, 254, 255, 255, 240, 0, 7, 240,
  126, 0, 7, 240, 63, 0, 7, 240, 63, 128, 7, 240, 31, 192, 7, 240,
  31, 192, 7, 240, 31, 224, 7, 240, 31, 224, 7, 240, 31, 224, 7, 240,
  31, 224, 7, 240, 31, 224, 7, 240, 31, 192, 7, 240, 63, 192, 7, 240,
  63, 0, 7, 240, 126, 0, 7, 255, 240, 0, 7, 240, 240, 0, 7, 240,
  62, 0, 7, 240, 63, 0, 7, 240, 31, 128, 7, 240, 31, 128, 7, 240,
  31, 192, 7, 240, 31, 192, 7, 240, 31, 192, 7, 240, 31, 192, 7, 240,
  31, 195, 7, 240, 31, 195, 7, 240, 31, 195, 7, 240, 31, 195, 7, 240,
  31, 195, 7, 240, 31, 198, 7, 240, 31, 198, 7, 240, 15, 238, 255, 255,
  135, 252, 0, 0, 3, 248, 0, 0, 0, 96, 23, 34, 102, 29, 4, 1,
  7, 252, 24, 24, 15, 24, 56, 3, 248, 112, 1, 248, 112, 0, 248, 240,
  0, 120, 248, 0, 120, 248, 0, 56, 252, 0, 24, 254, 0, 24, 255, 128,
  24, 255, 224, 8, 127, 240, 0, 127, 252, 0, 63, 254, 0, 31, 255, 128,
  15, 255, 192, 3, 255, 240, 1, 255, 248, 128, 127, 248, 192, 31, 252, 192,
  15, 252, 192, 3, 254, 224, 1, 254, 224, 0, 126, 224, 0, 62, 240, 0,
  30, 248, 0, 30, 248, 0, 28, 252, 0, 28, 254, 0, 24, 239, 0, 48,
  195, 128, 96, 193, 255, 128, 29, 34, 136, 34, 3, 0, 255, 255, 255, 248,
  255, 63, 231, 248, 252, 31, 193, 248, 248, 31, 192, 248, 248, 31, 192, 248,
  240, 31, 192, 120, 224, 31, 192, 56, 224, 31, 192, 56, 224, 31, 192, 56,
  192, 31, 192, 24, 192, 31, 192, 24, 192, 31, 192, 24, 192, 31, 192, 24,
  128, 31, 192, 8, 0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0,
  0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0,
  0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0,
  0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0,
  0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0,
  3, 255, 254, 0, 33, 34, 170, 38, 3, 0, 255, 255, 7, 255, 128, 15,
  224, 1, 254, 0, 15, 224, 0, 120, 0, 15, 224, 0, 48, 0, 15, 224,
  0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0,
  48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48,
  0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0,
  15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15,
  224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224,
  0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0,
  48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 7, 224, 0, 48,
  0, 7, 224, 0, 96, 0, 7, 240, 0, 96, 0, 3, 240, 0, 192, 0,
  1, 248, 1, 192, 0, 0, 252, 3, 128, 0, 0, 127, 159, 0, 0, 0,
  31, 252, 0, 0, 34, 34, 170, 37, 2, 0, 255, 255, 135, 255, 192, 15,
  248, 0, 126, 0, 7, 248, 0, 56, 0, 7, 248, 0, 56, 0, 3, 248,
  0, 48, 0, 3, 252, 0, 48, 0, 3, 252, 0, 48, 0, 1, 254, 0,
  96, 0, 1, 254, 0, 96, 0, 0, 254, 0, 96, 0, 0, 255, 0, 192,
  0, 0, 255, 0, 192, 0, 0, 127, 0, 192, 0, 0, 127, 129, 128, 0,
  0, 127, 129, 128, 0, 0, 63, 129, 128, 0, 0, 63, 195, 0, 0, 0,
  63, 195, 0, 0, 0, 31, 195, 0, 0, 0, 31, 230, 0, 0, 0, 15,
  230, 0, 0, 0, 15, 246, 0, 0, 0, 15, 252, 0, 0, 0, 7, 252,
  0, 0, 0, 7, 252, 0, 0, 0, 7, 248, 0, 0, 0, 3, 248, 0,
  0, 0, 3, 248, 0, 0, 0, 3, 240, 0, 0, 0, 1, 240, 0, 0,
  0, 1, 240, 0, 0, 0, 0, 224, 0, 0, 0, 0, 224, 0, 0, 0,
  0, 224, 0, 0, 49, 34, 238, 52, 2, 0, 255, 255, 63, 255, 207, 255,
  128, 31, 252, 7, 254, 0, 252, 0, 7, 248, 3, 252, 0, 112, 0, 7,
  248, 1, 252, 0, 112, 0, 3, 248, 1, 254, 0, 96, 0, 3, 252, 1,
  254, 0, 96, 0, 3, 252, 0, 254, 0, 96, 0, 1, 252, 0, 254, 0,
  192, 0, 1, 254, 1, 255, 0, 192, 0, 1, 254, 1, 255, 0, 192, 0,
  0, 254, 1, 255, 1, 128, 0, 0, 255, 3, 127, 129, 128, 0, 0, 255,
  3, 63, 129, 128, 0, 0, 127, 3, 63, 129, 128, 0, 0, 127, 135, 63,
  195, 0, 0, 0, 127, 134, 31, 195, 0, 0, 0, 63, 134, 31, 195, 0,
  0, 0, 63, 198, 31, 231, 0, 0, 0, 31, 204, 15, 230, 0, 0, 0,
  31, 204, 15, 230, 0, 0, 0, 31, 236, 15, 246, 0, 0, 0, 15, 248,
  7, 252, 0, 0, 0, 15, 248, 7, 252, 0, 0, 0, 15, 248, 7, 252,
  0, 0, 0, 7, 248, 3, 252, 0, 0, 0, 7, 240, 3, 248, 0, 0,
  0, 7, 240, 3, 248, 0, 0, 0, 3, 240, 1, 248, 0, 0, 0, 3,
  224, 1, 240, 0, 0, 0, 3, 224, 1, 240, 0, 0, 0, 1, 224, 0,
  240, 0, 0, 0, 1, 192, 0, 240, 0, 0, 0, 1, 192, 0, 224, 0,
  0, 0, 0, 192, 0, 96, 0, 0, 33, 34, 170, 36, 2, 0, 127, 255,
  31, 254, 0, 31, 252, 3, 240, 0, 7, 248, 3, 192, 0, 3, 248, 3,
  128, 0, 3, 252, 3, 128, 0, 1, 252, 3, 0, 0, 1, 254, 7, 0,
  0, 0, 255, 6, 0, 0, 0, 255, 12, 0, 0, 0, 127, 140, 0, 0,
  0, 127, 152, 0, 0, 0, 63, 240, 0, 0, 0, 63, 240, 0, 0, 0,
  31, 224, 0, 0, 0, 31, 224, 0, 0, 0, 15, 240, 0, 0, 0, 15,
  248, 0, 0, 0, 7, 248, 0, 0, 0, 7, 252, 0, 0, 0, 7, 252,
  0, 0, 0, 15, 254, 0, 0, 0, 29, 254, 0, 0, 0, 24, 255, 0,
  0, 0, 56, 255, 0, 0, 0, 48, 127, 128, 0, 0, 96, 127, 128, 0,
  0, 224, 63, 192, 0, 0, 192, 63, 224, 0, 1, 128, 31, 224, 0, 3,
  128, 31, 240, 0, 3, 128, 15, 240, 0, 7, 128, 15, 248, 0, 31, 128,
  31, 252, 0, 255, 240, 127, 255, 128, 32, 34, 136, 35, 2, 0, 255, 254,
  15, 255, 31, 248, 1, 248, 15, 248, 0, 240, 7, 248, 0, 224, 7, 248,
  0, 192, 3, 252, 0, 192, 3, 252, 0, 192, 1, 252, 1, 128, 1, 254,
  1, 128, 0, 254, 3, 0, 0, 255, 3, 0, 0, 255, 3, 0, 0, 127,
  134, 0, 0, 127, 134, 0, 0, 63, 196, 0, 0, 63, 204, 0, 0, 31,
  204, 0, 0, 31, 248, 0, 0, 15, 248, 0, 0, 15, 248, 0, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 255, 255, 0, 25, 34, 136, 31, 3, 0, 127, 255, 255, 128,
  127, 128, 127, 128, 126, 0, 255, 0, 124, 0, 255, 0, 120, 1, 254, 0,
  120, 3, 254, 0, 112, 3, 252, 0, 112, 7, 252, 0, 96, 7, 248, 0,
  96, 15, 248, 0, 96, 15, 240, 0, 64, 31, 224, 0, 0, 31, 224, 0,
  0, 63, 192, 0, 0, 63, 192, 0, 0, 127, 128, 0, 0, 127, 128, 0,
  0, 255, 0, 0, 0, 255, 0, 0, 1, 254, 0, 0, 3, 254, 0, 128,
  3, 252, 0, 128, 7, 248, 0, 128, 7, 248, 0, 128, 15, 240, 1, 128,
  15, 240, 1, 128, 31, 224, 3, 128, 31, 224, 3, 128, 63, 192, 7, 128,
  63, 192, 15, 128, 127, 128, 31, 128, 127, 128, 63, 128, 255, 255, 255, 128,
  255, 255, 255, 128, 11, 42, 84, 18, 4, 248, 255, 224, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 255, 224, 16, 44,
  88, 22, 3, 247, 224, 0, 224, 0, 224, 0, 240, 0, 112, 0, 112, 0,
  120, 0, 56, 0, 56, 0, 60, 0, 28, 0, 28, 0, 30, 0, 14, 0,
  14, 0, 14, 0, 15, 0, 7, 0, 7, 0, 7, 128, 3, 128, 3, 128,
  3, 192, 1, 192, 1, 192, 1, 224, 0, 224, 0, 224, 0, 224, 0, 240,
  0, 112, 0, 112, 0, 120, 0, 56, 0, 56, 0, 60, 0, 28, 0, 28,
  0, 30, 0, 14, 0, 14, 0, 14, 0, 15, 0, 7, 11, 42, 84, 18,
  3, 248, 255, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 255, 224, 22, 17, 51, 28, 3, 18, 0, 48, 0, 0,
  112, 0, 0, 120, 0, 0, 252, 0, 0, 252, 0, 1, 254, 0, 3, 207,
  0, 3, 143, 0, 7, 135, 128, 15, 3, 128, 15, 3, 192, 30, 1, 224,
  60, 0, 224, 60, 0, 240, 120, 0, 120, 112, 0, 56, 240, 0, 60, 25,
  3, 12, 25, 0, 248, 255, 255, 255, 128, 255, 255, 255, 128, 255, 255, 255,
  128, 8, 9, 9, 21, 4, 25, 96, 240, 248, 124, 60, 30, 15, 3, 1,
  21, 22, 66, 24, 2, 1, 15, 248, 0, 24, 62, 0, 56, 63, 0, 120,
  31, 0, 124, 31, 128, 126, 31, 128, 126, 31, 128, 62, 31, 128, 8, 63,
  128, 1, 255, 128, 7, 159, 128, 30, 31, 128, 62, 31, 128, 124, 31, 128,
  124, 31, 128, 252, 31, 128, 252, 31, 136, 252, 31, 136, 252, 31, 152, 254,
  63, 144, 127, 127, 240, 63, 143, 224, 22, 34, 102, 25, 1, 0, 255, 128,
  0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0,
  31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31,
  128, 0, 31, 159, 128, 31, 179, 224, 31, 225, 224, 31, 193, 240, 31, 193,
  248, 31, 192, 248, 31, 192, 248, 31, 128, 252, 31, 128, 252, 31, 128, 252,
  31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31,
  128, 248, 31, 192, 248, 31, 193, 248, 29, 193, 240, 24, 225, 224, 24, 99,
  192, 16, 63, 128, 18, 22, 66, 22, 2, 1, 3, 252, 0, 15, 6, 0,
  31, 3, 0, 62, 3, 128, 62, 7, 128, 126, 15, 128, 124, 31, 128, 252,
  31, 128, 252, 31, 0, 252, 14, 0, 252, 0, 0, 252, 0, 0, 252, 0,
  0, 252, 0, 0, 252, 0, 0, 124, 0, 64, 124, 0, 192, 62, 0, 128,
  62, 0, 128, 30, 1, 0, 15, 130, 0, 3, 252, 0, 23, 34, 102, 26,
  2, 0, 0, 63, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 7,
  224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224,
  0, 7, 224, 0, 7, 224, 7, 231, 224, 31, 23, 224, 30, 31, 224, 62,
  15, 224, 126, 15, 224, 124, 15, 224, 124, 7, 224, 252, 7, 224, 252, 7,
  224, 252, 7, 224, 252, 7, 224, 252, 7, 224, 252, 7, 224, 252, 7, 224,
  252, 7, 224, 124, 7, 224, 124, 15, 224, 126, 15, 224, 62, 15, 224, 30,
  31, 224, 15, 23, 224, 7, 231, 254, 18, 22, 66, 23, 2, 1, 3, 252,
  0, 14, 30, 0, 30, 31, 0, 62, 15, 128, 60, 15, 128, 124, 15, 128,
  124, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 255, 255, 192, 252,
  0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 64, 124, 0, 64, 124, 0,
  192, 62, 0, 192, 62, 0, 128, 31, 1, 0, 15, 131, 0, 3, 252, 0,
  18, 34, 102, 16, 1, 1, 0, 255, 0, 1, 199, 128, 7, 199, 128, 7,
  199, 192, 15, 143, 192, 15, 143, 192, 31, 143, 192, 31, 143, 128, 31, 135,
  128, 31, 128, 0, 31, 128, 0, 31, 128, 0, 255, 240, 0, 31, 128, 0,
  31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31,
  128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128,
  0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0,
  31, 128, 0, 31, 128, 0, 31, 128, 0, 255, 240, 0, 24, 33, 99, 27,
  2, 246, 7, 254, 62, 31, 15, 71, 63, 7, 143, 62, 7, 207, 126, 7,
  238, 126, 7, 228, 126, 7, 224, 126, 7, 224, 126, 7, 224, 62, 7, 192,
  31, 15, 128, 15, 15, 0, 3, 252, 0, 12, 0, 0, 48, 0, 0, 48,
  0, 0, 112, 0, 0, 112, 0, 0, 127, 255, 128, 127, 255, 224, 63, 255,
  240, 31, 255, 240, 7, 255, 248, 60, 1, 248, 96, 0, 120, 192, 0, 56,
  192, 0, 56, 192, 0, 48, 192, 0, 112, 96, 0, 96, 48, 1, 192, 30,
  7, 128, 3, 252, 0, 24, 34, 102, 27, 1, 0, 255, 128, 0, 31, 128,
  0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0,
  31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 129, 0, 31,
  143, 224, 31, 145, 240, 31, 160, 248, 31, 160, 252, 31, 192, 252, 31, 192,
  252, 31, 192, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252,
  31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31,
  128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 255, 227,
  255, 11, 35, 70, 15, 2, 0, 4, 0, 31, 0, 63, 128, 63, 128, 63,
  128, 63, 128, 31, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 255, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63,
  0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63,
  0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 255, 224, 15, 46, 92,
  16, 254, 245, 0, 16, 0, 124, 0, 254, 0, 254, 0, 254, 0, 254, 0,
  124, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 252, 0,
  252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0,
  252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0,
  252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 56, 252, 124,
  252, 252, 252, 252, 252, 248, 248, 248, 248, 113, 240, 49, 224, 31, 128, 25,
  34, 136, 27, 1, 0, 255, 128, 0, 0, 31, 128, 0, 0, 31, 128, 0,
  0, 31, 128, 0, 0, 31, 128, 0, 0, 31, 128, 0, 0, 31, 128, 0,
  0, 31, 128, 0, 0, 31, 128, 0, 0, 31, 128, 0, 0, 31, 128, 0,
  0, 31, 128, 0, 0, 31, 131, 254, 0, 31, 128, 240, 0, 31, 128, 96,
  0, 31, 128, 192, 0, 31, 128, 128, 0, 31, 129, 128, 0, 31, 131, 0,
  0, 31, 134, 0, 0, 31, 143, 0, 0, 31, 159, 0, 0, 31, 159, 128,
  0, 31, 191, 128, 0, 31, 239, 192, 0, 31, 199, 224, 0, 31, 135, 224,
  0, 31, 131, 240, 0, 31, 129, 248, 0, 31, 129, 248, 0, 31, 128, 252,
  0, 31, 128, 252, 0, 31, 128, 254, 0, 255, 243, 255, 128, 12, 34, 68,
  14, 1, 0, 255, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 255, 240, 34, 22, 110, 37, 2, 1, 255, 31, 193,
  248, 0, 63, 35, 230, 124, 0, 63, 67, 228, 62, 0, 63, 131, 248, 63,
  0, 63, 131, 248, 63, 0, 63, 131, 248, 63, 0, 63, 3, 240, 63, 0,
  63, 3, 240, 63, 0, 63, 3, 240, 63, 0, 63, 3, 240, 63, 0, 63,
  3, 240, 63, 0, 63, 3, 240, 63, 0, 63, 3, 240, 63, 0, 63, 3,
  240, 63, 0, 63, 3, 240, 63, 0, 63, 3, 240, 63, 0, 63, 3, 240,
  63, 0, 63, 3, 240, 63, 0, 63, 3, 240, 63, 0, 63, 3, 240, 63,
  0, 63, 3, 240, 63, 0, 255, 207, 252, 255, 192, 23, 22, 66, 27, 2,
  1, 255, 31, 192, 63, 35, 224, 63, 65, 240, 63, 65, 248, 63, 129, 248,
  63, 129, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63,
  1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1,
  248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248,
  255, 199, 254, 20, 22, 66, 24, 2, 1, 3, 252, 0, 15, 15, 0, 30,
  7, 128, 62, 7, 192, 62, 7, 192, 124, 3, 224, 124, 3, 224, 252, 3,
  240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240,
  252, 3, 240, 252, 3, 240, 124, 3, 224, 124, 3, 224, 62, 7, 192, 62,
  7, 192, 30, 7, 128, 15, 15, 0, 3, 252, 0, 22, 33, 99, 25, 1,
  246, 255, 159, 128, 31, 163, 192, 31, 225, 224, 31, 193, 240, 31, 192, 248,
  31, 192, 248, 31, 192, 248, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31,
  128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 192,
  252, 31, 192, 248, 31, 192, 248, 31, 193, 240, 31, 225, 240, 31, 179, 224,
  31, 159, 128, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31,
  128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128,
  0, 255, 240, 0, 22, 33, 99, 25, 2, 246, 7, 240, 32, 15, 24, 96,
  30, 28, 96, 62, 14, 224, 126, 15, 224, 124, 15, 224, 124, 7, 224, 252,
  7, 224, 252, 7, 224, 252, 7, 224, 252, 7, 224, 252, 7, 224, 252, 7,
  224, 252, 7, 224, 252, 7, 224, 124, 7, 224, 124, 15, 224, 126, 15, 224,
  62, 15, 224, 30, 31, 224, 31, 23, 224, 7, 231, 224, 0, 7, 224, 0,
  7, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 7,
  224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 63, 252, 17, 22, 66,
  20, 2, 1, 255, 31, 0, 63, 63, 128, 63, 79, 128, 63, 79, 128, 63,
  159, 128, 63, 159, 128, 63, 159, 0, 63, 14, 0, 63, 0, 0, 63, 0,
  0, 63, 0, 0, 63, 0, 0, 63, 0, 0, 63, 0, 0, 63, 0, 0,
  63, 0, 0, 63, 0, 0, 63, 0, 0, 63, 0, 0, 63, 0, 0, 63,
  0, 0, 255, 192, 0, 16, 22, 44, 21, 3, 1, 31, 196, 48, 116, 96,
  60, 224, 28, 224, 28, 240, 12, 248, 4, 254, 4, 127, 128, 127, 224, 63,
  240, 31, 252, 7, 254, 129, 254, 192, 127, 192, 31, 224, 15, 224, 7, 240,
  7, 248, 6, 204, 14, 135, 248, 15, 32, 64, 17, 1, 0, 1, 128, 1,
  128, 1, 128, 1, 128, 1, 128, 3, 128, 3, 128, 7, 128, 15, 128, 63,
  128, 255, 248, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 130, 31, 130, 31, 130, 31,
  130, 31, 134, 31, 134, 31, 132, 15, 196, 15, 248, 7, 240, 24, 22, 66,
  26, 1, 0, 255, 143, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31,
  129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129,
  248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248,
  31, 129, 248, 31, 131, 248, 31, 131, 248, 31, 133, 248, 15, 133, 248, 15,
  201, 248, 7, 241, 255, 23, 23, 69, 25, 1, 255, 255, 241, 254, 63, 192,
  120, 31, 128, 48, 15, 192, 48, 15, 192, 32, 7, 192, 96, 7, 224, 96,
  7, 224, 64, 3, 224, 192, 3, 240, 128, 3, 240, 128, 1, 241, 128, 1,
  249, 0, 0, 249, 0, 0, 255, 0, 0, 254, 0, 0, 126, 0, 0, 126,
  0, 0, 124, 0, 0, 60, 0, 0, 60, 0, 0, 24, 0, 0, 24, 0,
  35, 23, 115, 37, 1, 255, 255, 231, 255, 31, 224, 63, 129, 252, 7, 128,
  31, 128, 252, 3, 0, 15, 128, 252, 2, 0, 15, 192, 124, 2, 0, 15,
  192, 124, 6, 0, 7, 192, 126, 4, 0, 7, 224, 254, 4, 0, 3, 224,
  191, 12, 0, 3, 224, 191, 8, 0, 3, 241, 159, 24, 0, 1, 241, 31,
  144, 0, 1, 241, 31, 144, 0, 1, 251, 31, 176, 0, 0, 250, 15, 224,
  0, 0, 250, 15, 224, 0, 0, 254, 15, 224, 0, 0, 124, 7, 192, 0,
  0, 124, 7, 192, 0, 0, 60, 7, 192, 0, 0, 56, 3, 128, 0, 0,
  56, 3, 128, 0, 0, 24, 3, 0, 0, 23, 22, 66, 25, 1, 0, 255,
  231, 252, 63, 192, 240, 31, 192, 224, 15, 192, 192, 15, 225, 128, 7, 227,
  0, 3, 242, 0, 3, 254, 0, 1, 252, 0, 1, 252, 0, 0, 252, 0,
  0, 126, 0, 0, 127, 0, 0, 127, 0, 0, 223, 128, 1, 159, 192, 3,
  15, 192, 2, 15, 224, 6, 7, 224, 14, 7, 240, 30, 7, 248, 255, 207,
  254, 23, 33, 99, 25, 1, 245, 255, 241, 254, 63, 192, 120, 31, 128, 48,
  15, 192, 32, 15, 192, 32, 15, 192, 96, 7, 224, 64, 7, 224, 64, 3,
  240, 192, 3, 240, 128, 1, 248, 128, 1, 249, 128, 0, 249, 0, 0, 253,
  0, 0, 253, 0, 0, 126, 0, 0, 126, 0, 0, 62, 0, 0, 60, 0,
  0, 28, 0, 0, 28, 0, 0, 12, 0, 0, 8, 0, 0, 8, 0, 0,
  8, 0, 15, 16, 0, 31, 16, 0, 63, 144, 0, 63, 32, 0, 62, 32,
  0, 62, 64, 0, 31, 192, 0, 15, 0, 0, 18, 22, 66, 22, 2, 0,
  127, 255, 192, 124, 15, 192, 120, 31, 128, 112, 63, 0, 96, 63, 0, 96,
  126, 0, 64, 126, 0, 64, 252, 0, 1, 248, 0, 1, 248, 0, 3, 240,
  0, 3, 240, 0, 7, 224, 64, 15, 192, 64, 15, 192, 64, 31, 128, 192,
  31, 0, 192, 63, 1, 192, 126, 1, 192, 126, 3, 192, 252, 15, 192, 255,
  255, 192, 14, 43, 86, 20, 3, 247, 0, 60, 0, 240, 3, 192, 7, 128,
  7, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128,
  15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 0, 15, 0,
  28, 0, 240, 0, 60, 0, 30, 0, 15, 0, 15, 128, 15, 128, 15, 128,
  15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128,
  15, 128, 15, 128, 7, 128, 7, 128, 3, 192, 0, 240, 0, 60, 3, 44,
  44, 13, 5, 247, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  15, 43, 86, 20, 3, 247, 240, 0, 60, 0, 15, 0, 7, 128, 7, 128,
  7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192,
  7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 3, 192, 3, 192, 0, 240,
  0, 62, 0, 240, 1, 224, 3, 192, 7, 192, 7, 192, 7, 192, 7, 192,
  7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192,
  7, 192, 7, 128, 7, 128, 15, 0, 60, 0, 240, 0, 27, 9, 36, 31,
  2, 8, 31, 128, 1, 128, 63, 240, 0, 192, 127, 254, 0, 96, 255, 255,
  128, 96, 193, 255, 240, 96, 192, 63, 255, 224, 192, 15, 255, 192, 96, 1,
  255, 128, 48, 0, 63, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 13, 0, 0, 8, 35, 35,
  14, 3, 245, 60, 126, 255, 255, 255, 126, 60, 0, 0, 0, 24, 24, 24,
  24, 24, 24, 24, 24, 60, 60, 60, 60, 126, 126, 126, 126, 254, 255, 255,
  255, 255, 255, 255, 126, 60, 18, 34, 102, 28, 5, 250, 0, 96, 0, 0,
  96, 0, 0, 96, 0, 0, 96, 0, 0, 96, 0, 1, 240, 0, 7, 236,
  0, 15, 103, 0, 30, 99, 0, 62, 99, 128, 126, 103, 128, 126, 111, 128,
  124, 111, 128, 252, 111, 128, 252, 103, 0, 252, 96, 0, 252, 96, 0, 252,
  96, 0, 252, 96, 0, 252, 96, 0, 252, 96, 0, 124, 96, 192, 124, 96,
  192, 62, 96, 128, 62, 97, 128, 30, 97, 0, 15, 99, 0, 7, 252, 0,
  0, 248, 0, 0, 96, 0, 0, 96, 0, 0, 96, 0, 0, 96, 0, 0,
  96, 0, 29, 34, 136, 34, 3, 1, 0, 1, 255, 0, 0, 7, 129, 192,
  0, 31, 0, 224, 0, 31, 0, 224, 0, 63, 0, 240, 0, 126, 1, 240,
  0, 126, 3, 240, 0, 254, 3, 240, 0, 254, 3, 224, 0, 254, 1, 192,
  0, 254, 0, 0, 0, 254, 0, 0, 0, 254, 0, 0, 0, 254, 0, 0,
  15, 254, 0, 0, 24, 126, 6, 0, 0, 127, 252, 0, 0, 127, 0, 0,
  0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0, 0, 0, 63, 0, 0,
  0, 31, 0, 0, 0, 31, 0, 0, 0, 30, 0, 0, 0, 30, 0, 24,
  30, 28, 0, 56, 127, 220, 0, 112, 195, 248, 0, 224, 128, 255, 255, 224,
  128, 127, 255, 192, 128, 255, 255, 128, 193, 207, 255, 0, 127, 3, 252, 0,
  24, 22, 66, 28, 2, 5, 96, 126, 6, 243, 255, 207, 127, 255, 254, 63,
  129, 252, 30, 0, 120, 60, 0, 60, 56, 0, 28, 56, 0, 28, 112, 0,
  14, 112, 0, 14, 112, 0, 14, 112, 0, 14, 112, 0, 14, 112, 0, 14,
  56, 0, 28, 56, 0, 28, 60, 0, 60, 30, 0, 120, 63, 129, 252, 127,
  255, 254, 243, 255, 207, 96, 126, 6, 26, 34, 136, 28, 1, 0, 255, 248,
  63, 192, 63, 224, 15, 0, 31, 224, 14, 0, 31, 224, 12, 0, 31, 224,
  12, 0, 15, 240, 8, 0, 15, 240, 8, 0, 7, 240, 24, 0, 7, 248,
  16, 0, 3, 248, 48, 0, 3, 252, 32, 0, 3, 252, 96, 0, 1, 254,
  64, 0, 1, 254, 192, 0, 0, 254, 128, 0, 0, 255, 128, 0, 0, 255,
  0, 0, 63, 255, 254, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127,
  0, 0, 0, 127, 0, 0, 63, 255, 254, 0, 0, 127, 0, 0, 0, 127,
  0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127,
  0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127, 0, 0, 0, 127,
  0, 0, 7, 255, 248, 0, 3, 42, 42, 13, 5, 248, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 0, 0, 0,
  0, 0, 0, 0, 0, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 22, 43, 129, 30, 2, 248, 1, 255, 0, 7,
  1, 192, 14, 0, 224, 28, 0, 224, 28, 1, 240, 60, 3, 240, 60, 7,
  240, 60, 7, 240, 62, 7, 224, 62, 3, 192, 63, 0, 0, 31, 192, 0,
  31, 248, 0, 15, 254, 0, 31, 255, 128, 55, 255, 192, 97, 255, 240, 96,
  127, 248, 224, 31, 248, 224, 7, 252, 240, 1, 252, 252, 0, 124, 255, 0,
  60, 255, 192, 28, 127, 240, 24, 63, 252, 24, 31, 255, 16, 15, 255, 160,
  3, 255, 192, 0, 255, 224, 0, 63, 224, 0, 15, 240, 6, 3, 240, 31,
  129, 240, 63, 128, 240, 63, 128, 240, 63, 128, 240, 63, 0, 240, 62, 0,
  224, 28, 1, 192, 28, 3, 192, 15, 7, 0, 3, 252, 0, 15, 6, 12,
  21, 3, 26, 120, 60, 252, 126, 252, 126, 252, 126, 252, 126, 120, 60, 35,
  34, 170, 39, 2, 1, 0, 15, 254, 0, 0, 0, 112, 3, 192, 0, 0,
  192, 0, 96, 0, 3, 128, 0, 56, 0, 6, 0, 0, 28, 0, 12, 0,
  0, 6, 0, 24, 3, 225, 134, 0, 24, 15, 25, 131, 0, 48, 30, 15,
  129, 128, 48, 62, 7, 129, 128, 96, 60, 3, 128, 192, 96, 124, 3, 128,
  192, 96, 124, 1, 128, 192, 192, 252, 1, 128, 96, 192, 252, 1, 128, 96,
  192, 252, 0, 0, 96, 192, 252, 0, 0, 96, 192, 252, 0, 0, 96, 192,
  252, 0, 0, 96, 192, 252, 0, 128, 96, 192, 252, 0, 128, 96, 64, 124,
  0, 128, 192, 96, 124, 1, 128, 192, 96, 60, 1, 0, 192, 48, 62, 3,
  1, 128, 48, 30, 2, 1, 128, 24, 15, 12, 3, 0, 24, 3, 248, 6,
  0, 12, 0, 0, 6, 0, 6, 0, 0, 12, 0, 3, 128, 0, 56, 0,
  0, 192, 0, 96, 0, 0, 112, 1, 192, 0, 0, 15, 254, 0, 0, 14,
  17, 34, 18, 2, 17, 31, 0, 51, 192, 97, 224, 113, 224, 121, 224, 57,
  224, 7, 224, 57, 224, 113, 224, 241, 224, 241, 228, 241, 228, 241, 228, 126,
  248, 0, 0, 127, 252, 127, 252, 13, 20, 40, 23, 5, 1, 4, 0, 28,
  24, 24, 48, 56, 112, 112, 96, 112, 224, 241, 224, 241, 224, 241, 224, 241,
  224, 241, 224, 241, 224, 241, 224, 112, 224, 112, 224, 112, 96, 56, 48, 24,
  16, 12, 0, 4, 0, 23, 13, 39, 27, 2, 6, 255, 255, 254, 255, 255,
  254, 255, 255, 254, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14,
  0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0,
  0, 14, 12, 5, 10, 18, 3, 10, 255, 240, 255, 240, 255, 240, 255, 240,
  255, 240, 35, 34, 170, 39, 2, 1, 0, 15, 254, 0, 0, 0, 112, 3,
  192, 0, 0, 192, 0, 96, 0, 3, 128, 0, 56, 0, 6, 0, 0, 28,
  0, 12, 0, 0, 6, 0, 24, 255, 252, 6, 0, 24, 62, 31, 3, 0,
  48, 62, 15, 129, 128, 48, 62, 15, 193, 128, 96, 62, 15, 192, 192, 96,
  62, 15, 192, 192, 96, 62, 15, 192, 192, 192, 62, 15, 128, 96, 192, 62,
  31, 0, 96, 192, 63, 248, 0, 96, 192, 62, 60, 0, 96, 192, 62, 30,
  0, 96, 192, 62, 15, 0, 96, 192, 62, 15, 128, 96, 192, 62, 15, 128,
  96, 64, 62, 15, 128, 192, 96, 62, 15, 136, 192, 96, 62, 15, 136, 192,
  48, 62, 15, 137, 128, 48, 62, 15, 145, 128, 24, 255, 231, 243, 0, 24,
  0, 3, 230, 0, 12, 0, 0, 6, 0, 6, 0, 0, 12, 0, 3, 128,
  0, 56, 0, 0, 192, 0, 96, 0, 0, 112, 1, 192, 0, 0, 15, 254,
  0, 0, 12, 3, 6, 20, 4, 28, 255, 240, 255, 240, 255, 240, 16, 15,
  30, 28, 6, 20, 15, 240, 31, 248, 62, 124, 120, 30, 240, 14, 224, 7,
  224, 7, 224, 7, 224, 7, 224, 14, 112, 14, 124, 60, 63, 252, 31, 240,
  3, 192, 41, 36, 216, 45, 2, 253, 0, 0, 28, 0, 0, 0, 0, 0,
  28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0,
  0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0,
  0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0,
  28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0,
  0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 255, 255, 255, 255,
  255, 128, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255, 255, 128, 0, 0,
  28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0,
  0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0,
  0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0,
  28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0,
  0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255,
  255, 255, 255, 0, 255, 255, 255, 255, 255, 0, 255, 255, 255, 255, 255, 0,
  14, 21, 42, 21, 4, 14, 31, 240, 48, 248, 96, 124, 224, 124, 240, 124,
  248, 124, 248, 120, 120, 248, 1, 240, 1, 224, 3, 128, 6, 0, 12, 4,
  16, 4, 32, 4, 32, 12, 127, 252, 127, 252, 79, 248, 71, 248, 1, 224,
  16, 21, 42, 22, 3, 14, 31, 224, 48, 248, 112, 124, 112, 124, 124, 124,
  124, 124, 60, 124, 0, 120, 0, 224, 15, 128, 0, 240, 0, 124, 0, 62,
  16, 63, 124, 63, 252, 63, 252, 63, 240, 63, 112, 126, 112, 252, 31, 240,
  8, 9, 9, 21, 9, 25, 6, 15, 31, 62, 60, 120, 240, 192, 128, 24,
  35, 105, 29, 3, 244, 120, 3, 192, 124, 3, 192, 252, 7, 224, 252, 7,
  224, 252, 7, 224, 252, 7, 224, 252, 7, 224, 252, 7, 224, 252, 7, 224,
  248, 7, 224, 248, 7, 224, 120, 7, 192, 112, 3, 192, 112, 3, 193, 112,
  3, 129, 48, 3, 131, 48, 7, 135, 48, 7, 255, 56, 15, 254, 62, 62,
  254, 47, 252, 126, 35, 248, 60, 32, 0, 0, 48, 0, 0, 112, 0, 0,
  112, 0, 0, 120, 0, 0, 124, 0, 0, 124, 0, 0, 124, 0, 0, 126,
  0, 0, 126, 0, 0, 126, 0, 0, 62, 0, 0, 28, 0, 0, 23, 41,
  123, 28, 3, 249, 3, 255, 254, 15, 240, 224, 63, 240, 224, 127, 240, 224,
  127, 240, 224, 255, 240, 224, 255, 240, 224, 255, 240, 224, 255, 240, 224, 255,
  240, 224, 255, 240, 224, 255, 240, 224, 255, 240, 224, 255, 240, 224, 127, 240,
  224, 63, 240, 224, 31, 240, 224, 7, 240, 224, 0, 112, 224, 0, 112, 224,
  0, 112, 224, 0, 112, 224, 0, 112, 224, 0, 112, 224, 0, 112, 224, 0,
  112, 224, 0, 112, 224, 0, 112, 224, 0, 112, 224, 0, 112, 224, 0, 112,
  224, 0, 112, 224, 0, 112, 224, 0, 112, 224, 0, 112, 224, 0, 112, 224,
  0, 112, 224, 0, 112, 224, 0, 112, 224, 0, 112, 224, 0, 112, 224, 8,
  7, 7, 14, 3, 12, 60, 126, 255, 255, 255, 126, 60, 10, 10, 20, 21,
  5, 246, 8, 0, 8, 0, 24, 0, 15, 0, 7, 128, 3, 192, 3, 192,
  3, 192, 199, 128, 63, 0, 11, 20, 40, 21, 5, 14, 7, 0, 15, 0,
  255, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0, 31, 0,
  31, 0, 255, 224, 13, 17, 34, 19, 3, 17, 15, 128, 24, 192, 56, 224,
  112, 112, 112, 112, 240, 120, 240, 120, 240, 120, 240, 120, 240, 120, 240, 120,
  112, 112, 112, 224, 56, 224, 15, 128, 0, 0, 255, 248, 13, 20, 40, 23,
  5, 1, 1, 0, 193, 128, 96, 192, 112, 224, 48, 112, 56, 112, 56, 120,
  60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 60, 120, 56, 112, 56, 112,
  48, 112, 96, 224, 64, 192, 1, 128, 1, 0, 36, 36, 180, 44, 5, 255,
  0, 0, 0, 48, 0, 7, 0, 0, 48, 0, 7, 0, 0, 96, 0, 31,
  0, 0, 224, 0, 255, 0, 0, 192, 0, 31, 0, 1, 192, 0, 31, 0,
  1, 128, 0, 31, 0, 3, 0, 0, 31, 0, 7, 0, 0, 31, 0, 6,
  0, 0, 31, 0, 14, 0, 0, 31, 0, 12, 0, 0, 31, 0, 24, 0,
  0, 31, 0, 24, 0, 0, 31, 0, 48, 0, 0, 31, 0, 112, 15, 0,
  31, 0, 96, 31, 0, 31, 0, 224, 31, 0, 31, 0, 192, 63, 0, 31,
  1, 128, 127, 0, 255, 227, 128, 127, 0, 0, 3, 0, 223, 0, 0, 7,
  1, 159, 0, 0, 6, 1, 159, 0, 0, 12, 3, 31, 0, 0, 12, 2,
  31, 0, 0, 24, 6, 31, 0, 0, 56, 12, 31, 0, 0, 48, 15, 255,
  240, 0, 112, 0, 31, 0, 0, 96, 0, 31, 0, 0, 192, 0, 31, 0,
  1, 192, 0, 31, 0, 1, 128, 0, 31, 0, 3, 128, 1, 255, 224, 3,
  0, 0, 0, 0, 35, 36, 180, 43, 5, 255, 0, 0, 0, 56, 0, 7,
  0, 0, 48, 0, 7, 0, 0, 112, 0, 31, 0, 0, 224, 0, 255, 0,
  0, 192, 0, 31, 0, 1, 192, 0, 31, 0, 1, 128, 0, 31, 0, 3,
  128, 0, 31, 0, 3, 0, 0, 31, 0, 7, 0, 0, 31, 0, 14, 0,
  0, 31, 0, 12, 0, 0, 31, 0, 28, 0, 0, 31, 0, 24, 0, 0,
  31, 0, 56, 126, 0, 31, 0, 113, 143, 128, 31, 0, 99, 7, 192, 31,
  0, 231, 3, 224, 31, 0, 199, 3, 224, 31, 1, 199, 131, 224, 255, 227,
  135, 195, 224, 0, 3, 3, 199, 192, 0, 7, 1, 135, 128, 0, 6, 0,
  15, 0, 0, 14, 0, 30, 0, 0, 12, 0, 56, 0, 0, 24, 0, 96,
  0, 0, 56, 0, 128, 32, 0, 48, 1, 0, 32, 0, 112, 2, 0, 32,
  0, 96, 2, 255, 224, 0, 192, 7, 255, 224, 1, 192, 6, 255, 192, 1,
  128, 4, 127, 192, 3, 128, 4, 63, 128, 3, 0, 0, 0, 0, 38, 36,
  180, 44, 3, 255, 0, 0, 0, 12, 0, 31, 224, 0, 12, 0, 48, 248,
  0, 24, 0, 112, 124, 0, 56, 0, 112, 124, 0, 48, 0, 124, 124, 0,
  112, 0, 124, 124, 0, 96, 0, 60, 124, 0, 192, 0, 0, 120, 1, 192,
  0, 0, 224, 1, 128, 0, 15, 128, 3, 128, 0, 0, 240, 3, 0, 0,
  0, 124, 7, 0, 0, 0, 62, 6, 0, 0, 16, 63, 12, 0, 0, 124,
  63, 28, 3, 192, 252, 63, 24, 7, 192, 252, 63, 56, 7, 192, 240, 63,
  48, 15, 192, 112, 126, 112, 31, 192, 112, 252, 224, 31, 192, 31, 240, 192,
  55, 192, 0, 1, 192, 103, 192, 0, 1, 128, 103, 192, 0, 3, 128, 199,
  192, 0, 3, 0, 135, 192, 0, 6, 1, 135, 192, 0, 14, 3, 7, 192,
  0, 12, 3, 255, 252, 0, 28, 0, 7, 192, 0, 24, 0, 7, 192, 0,
  56, 0, 7, 192, 0, 112, 0, 7, 192, 0, 96, 0, 7, 192, 0, 224,
  0, 127, 248, 0, 192, 0, 0, 0, 16, 35, 70, 23, 3, 245, 7, 0,
  15, 128, 31, 192, 31, 192, 31, 192, 15, 128, 7, 0, 0, 0, 0, 0,
  7, 128, 12, 224, 16, 48, 16, 48, 16, 48, 16, 48, 0, 96, 0, 224,
  0, 192, 3, 192, 7, 128, 15, 128, 31, 0, 31, 4, 62, 4, 126, 6,
  124, 2, 252, 3, 252, 3, 252, 3, 252, 3, 252, 6, 126, 6, 63, 12,
  31, 248, 7, 224, 33, 45, 225, 36, 2, 0, 0, 56, 0, 0, 0, 0,
  60, 0, 0, 0, 0, 62, 0, 0, 0, 0, 62, 0, 0, 0, 0, 31,
  0, 0, 0, 0, 7, 0, 0, 0, 0, 3, 128, 0, 0, 0, 1, 192,
  0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 0,
  0, 0, 1, 192, 0, 0, 0, 1, 224, 0, 0, 0, 1, 224, 0, 0,
  0, 3, 224, 0, 0, 0, 3, 240, 0, 0, 0, 3, 240, 0, 0, 0,
  7, 240, 0, 0, 0, 7, 248, 0, 0, 0, 7, 248, 0, 0, 0, 15,
  248, 0, 0, 0, 15, 252, 0, 0, 0, 15, 252, 0, 0, 0, 25, 252,
  0, 0, 0, 25, 254, 0, 0, 0, 25, 254, 0, 0, 0, 48, 254, 0,
  0, 0, 48, 255, 0, 0, 0, 32, 255, 0, 0, 0, 96, 127, 0, 0,
  0, 96, 127, 128, 0, 0, 64, 127, 128, 0, 0, 192, 63, 128, 0, 0,
  192, 63, 192, 0, 0, 255, 255, 192, 0, 1, 255, 255, 192, 0, 1, 128,
  31, 224, 0, 1, 0, 31, 224, 0, 3, 0, 15, 224, 0, 3, 0, 15,
  240, 0, 2, 0, 15, 240, 0, 6, 0, 7, 240, 0, 15, 0, 7, 248,
  0, 31, 0, 15, 252, 0, 255, 240, 255, 255, 128, 33, 45, 225, 36, 2,
  0, 0, 0, 14, 0, 0, 0, 0, 15, 0, 0, 0, 0, 31, 0, 0,
  0, 0, 62, 0, 0, 0, 0, 60, 0, 0, 0, 0, 120, 0, 0, 0,
  0, 240, 0, 0, 0, 0, 192, 0, 0, 0, 0, 128, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 224,
  0, 0, 0, 1, 224, 0, 0, 0, 3, 224, 0, 0, 0, 3, 240, 0,
  0, 0, 3, 240, 0, 0, 0, 7, 240, 0, 0, 0, 7, 248, 0, 0,
  0, 7, 248, 0, 0, 0, 15, 248, 0, 0, 0, 15, 252, 0, 0, 0,
  15, 252, 0, 0, 0, 25, 252, 0, 0, 0, 25, 254, 0, 0, 0, 25,
  254, 0, 0, 0, 48, 254, 0, 0, 0, 48, 255, 0, 0, 0, 32, 255,
  0, 0, 0, 96, 127, 0, 0, 0, 96, 127, 128, 0, 0, 64, 127, 128,
  0, 0, 192, 63, 128, 0, 0, 192, 63, 192, 0, 0, 255, 255, 192, 0,
  1, 255, 255, 192, 0, 1, 128, 31, 224, 0, 1, 0, 31, 224, 0, 3,
  0, 15, 224, 0, 3, 0, 15, 240, 0, 6, 0, 15, 240, 0, 6, 0,
  7, 240, 0, 15, 0, 7, 248, 0, 255, 240, 255, 255, 128, 255, 240, 255,
  255, 128, 33, 44, 220, 36, 2, 0, 0, 1, 192, 0, 0, 0, 1, 224,
  0, 0, 0, 3, 224, 0, 0, 0, 7, 240, 0, 0, 0, 15, 120, 0,
  0, 0, 30, 30, 0, 0, 0, 120, 7, 0, 0, 0, 64, 1, 128, 0,
  0, 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 1, 192, 0, 0, 0,
  1, 224, 0, 0, 0, 1, 224, 0, 0, 0, 3, 224, 0, 0, 0, 3,
  240, 0, 0, 0, 3, 240, 0, 0, 0, 7, 240, 0, 0, 0, 7, 248,
  0, 0, 0, 7, 248, 0, 0, 0, 15, 248, 0, 0, 0, 15, 252, 0,
  0, 0, 15, 252, 0, 0, 0, 25, 252, 0, 0, 0, 25, 254, 0, 0,
  0, 25, 254, 0, 0, 0, 48, 254, 0, 0, 0, 48, 255, 0, 0, 0,
  32, 255, 0, 0, 0, 96, 127, 0, 0, 0, 96, 127, 128, 0, 0, 64,
  127, 128, 0, 0, 192, 63, 128, 0, 0, 192, 63, 192, 0, 0, 255, 255,
  192, 0, 1, 255, 255, 192, 0, 1, 128, 31, 224, 0, 1, 0, 31, 224,
  0, 3, 0, 15, 224, 0, 3, 0, 15, 240, 0, 2, 0, 15, 240, 0,
  6, 0, 7, 240, 0, 15, 0, 7, 248, 0, 31, 0, 15, 252, 0, 255,
  240, 255, 255, 128, 33, 43, 215, 36, 2, 0, 0, 15, 1, 0, 0, 0,
  31, 227, 0, 0, 0, 63, 254, 0, 0, 0, 33, 254, 0, 0, 0, 32,
  124, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 224, 0,
  0, 0, 1, 224, 0, 0, 0, 3, 224, 0, 0, 0, 3, 240, 0, 0,
  0, 3, 240, 0, 0, 0, 7, 240, 0, 0, 0, 7, 248, 0, 0, 0,
  7, 248, 0, 0, 0, 15, 248, 0, 0, 0, 15, 252, 0, 0, 0, 15,
  252, 0, 0, 0, 25, 252, 0, 0, 0, 25, 254, 0, 0, 0, 25, 254,
  0, 0, 0, 48, 254, 0, 0, 0, 48, 255, 0, 0, 0, 32, 255, 0,
  0, 0, 96, 127, 0, 0, 0, 96, 127, 128, 0, 0, 64, 127, 128, 0,
  0, 192, 63, 128, 0, 0, 192, 63, 192, 0, 0, 255, 255, 192, 0, 1,
  255, 255, 192, 0, 1, 128, 31, 224, 0, 1, 0, 31, 224, 0, 3, 0,
  15, 224, 0, 3, 0, 15, 240, 0, 6, 0, 15, 240, 0, 6, 0, 7,
  240, 0, 15, 0, 7, 248, 0, 255, 240, 255, 255, 128, 255, 240, 255, 255,
  128, 33, 43, 215, 36, 2, 0, 0, 60, 15, 0, 0, 0, 126, 31, 128,
  0, 0, 126, 31, 128, 0, 0, 126, 31, 128, 0, 0, 126, 31, 128, 0,
  0, 60, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 1, 224, 0, 0, 0, 1,
  224, 0, 0, 0, 1, 224, 0, 0, 0, 3, 240, 0, 0, 0, 3, 240,
  0, 0, 0, 3, 240, 0, 0, 0, 7, 248, 0, 0, 0, 7, 248, 0,
  0, 0, 7, 248, 0, 0, 0, 15, 252, 0, 0, 0, 15, 252, 0, 0,
  0, 25, 252, 0, 0, 0, 25, 254, 0, 0, 0, 24, 254, 0, 0, 0,
  48, 254, 0, 0, 0, 48, 255, 0, 0, 0, 48, 127, 0, 0, 0, 96,
  127, 0, 0, 0, 96, 127, 128, 0, 0, 96, 63, 128, 0, 0, 192, 63,
  128, 0, 0, 192, 63, 192, 0, 0, 255, 255, 192, 0, 1, 255, 255, 192,
  0, 1, 128, 31, 224, 0, 1, 128, 15, 224, 0, 3, 0, 15, 224, 0,
  3, 0, 15, 240, 0, 3, 0, 7, 240, 0, 7, 0, 7, 240, 0, 15,
  0, 7, 248, 0, 31, 128, 15, 252, 0, 255, 240, 255, 255, 128, 33, 45,
  225, 36, 2, 0, 0, 1, 224, 0, 0, 0, 7, 248, 0, 0, 0, 14,
  28, 0, 0, 0, 12, 12, 0, 0, 0, 12, 12, 0, 0, 0, 12, 12,
  0, 0, 0, 14, 28, 0, 0, 0, 7, 248, 0, 0, 0, 3, 240, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 1, 192, 0, 0,
  0, 1, 224, 0, 0, 0, 1, 224, 0, 0, 0, 3, 224, 0, 0, 0,
  3, 240, 0, 0, 0, 3, 240, 0, 0, 0, 7, 240, 0, 0, 0, 7,
  248, 0, 0, 0, 7, 248, 0, 0, 0, 15, 248, 0, 0, 0, 13, 252,
  0, 0, 0, 13, 252, 0, 0, 0, 29, 252, 0, 0, 0, 25, 254, 0,
  0, 0, 24, 254, 0, 0, 0, 56, 254, 0, 0, 0, 48, 255, 0, 0,
  0, 48, 127, 0, 0, 0, 112, 127, 0, 0, 0, 96, 127, 128, 0, 0,
  96, 63, 128, 0, 0, 224, 63, 128, 0, 0, 192, 63, 192, 0, 0, 255,
  255, 192, 0, 1, 255, 255, 192, 0, 1, 128, 31, 224, 0, 1, 128, 31,
  224, 0, 3, 0, 15, 224, 0, 3, 0, 15, 240, 0, 3, 0, 15, 240,
  0, 7, 0, 7, 240, 0, 15, 0, 7, 248, 0, 31, 128, 15, 252, 0,
  255, 240, 255, 255, 128, 45, 34, 204, 48, 1, 0, 0, 0, 127, 255, 255,
  240, 0, 0, 31, 248, 7, 240, 0, 0, 15, 248, 1, 240, 0, 0, 15,
  248, 0, 240, 0, 0, 31, 248, 0, 240, 0, 0, 27, 248, 0, 112, 0,
  0, 59, 248, 0, 112, 0, 0, 51, 248, 0, 48, 0, 0, 115, 248, 0,
  48, 0, 0, 99, 248, 12, 48, 0, 0, 227, 248, 12, 16, 0, 0, 195,
  248, 12, 0, 0, 1, 195, 248, 28, 0, 0, 1, 131, 248, 28, 0, 0,
  3, 131, 248, 60, 0, 0, 3, 3, 248, 124, 0, 0, 7, 3, 255, 252,
  0, 0, 6, 3, 248, 124, 0, 0, 14, 3, 248, 60, 0, 0, 12, 3,
  248, 28, 0, 0, 28, 3, 248, 28, 0, 0, 24, 3, 248, 12, 24, 0,
  56, 3, 248, 12, 24, 0, 63, 255, 248, 12, 24, 0, 96, 3, 248, 0,
  56, 0, 224, 3, 248, 0, 56, 0, 192, 3, 248, 0, 56, 1, 192, 3,
  248, 0, 120, 1, 128, 3, 248, 0, 120, 3, 128, 3, 248, 0, 248, 7,
  128, 3, 248, 1, 248, 15, 128, 3, 248, 3, 248, 255, 248, 127, 255, 255,
  248, 255, 248, 127, 255, 255, 248, 26, 45, 180, 31, 3, 246, 0, 127, 193,
  128, 1, 224, 241, 128, 3, 192, 63, 128, 7, 128, 31, 128, 15, 128, 15,
  128, 31, 0, 15, 128, 63, 0, 7, 128, 63, 0, 7, 128, 63, 0, 3,
  128, 127, 0, 3, 128, 127, 0, 1, 128, 127, 0, 1, 128, 255, 0, 1,
  128, 255, 0, 1, 128, 255, 0, 1, 128, 255, 0, 0, 0, 255, 0, 0,
  0, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0,
  0, 255, 0, 0, 192, 127, 0, 0, 192, 127, 0, 0, 192, 127, 0, 0,
  128, 63, 0, 0, 128, 63, 0, 1, 128, 63, 0, 1, 128, 31, 128, 3,
  0, 15, 128, 3, 0, 7, 128, 6, 0, 3, 192, 12, 0, 1, 224, 56,
  0, 0, 127, 224, 0, 0, 12, 0, 0, 0, 8, 0, 0, 0, 30, 0,
  0, 0, 31, 128, 0, 0, 3, 192, 0, 0, 1, 224, 0, 0, 1, 224,
  0, 0, 1, 224, 0, 0, 129, 192, 0, 0, 199, 192, 0, 0, 63, 0,
  0, 27, 45, 180, 33, 3, 0, 0, 224, 0, 0, 1, 240, 0, 0, 1,
  240, 0, 0, 0, 248, 0, 0, 0, 124, 0, 0, 0, 60, 0, 0, 0,
  14, 0, 0, 0, 6, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 255, 255, 255, 224, 15, 224, 31, 224, 15, 224, 7, 224, 15,
  224, 3, 224, 15, 224, 1, 224, 15, 224, 1, 224, 15, 224, 0, 224, 15,
  224, 0, 224, 15, 224, 0, 96, 15, 224, 48, 96, 15, 224, 48, 96, 15,
  224, 48, 0, 15, 224, 112, 0, 15, 224, 112, 0, 15, 224, 240, 0, 15,
  225, 240, 0, 15, 255, 240, 0, 15, 225, 240, 0, 15, 224, 240, 0, 15,
  224, 112, 0, 15, 224, 112, 32, 15, 224, 48, 96, 15, 224, 48, 96, 15,
  224, 48, 96, 15, 224, 0, 96, 15, 224, 0, 96, 15, 224, 0, 224, 15,
  224, 0, 224, 15, 224, 1, 224, 15, 224, 3, 224, 15, 224, 3, 224, 15,
  224, 15, 224, 255, 255, 255, 224, 255, 255, 255, 224, 27, 45, 180, 33, 3,
  0, 0, 0, 56, 0, 0, 0, 120, 0, 0, 0, 248, 0, 0, 0, 248,
  0, 0, 1, 240, 0, 0, 3, 192, 0, 0, 3, 128, 0, 0, 6, 0,
  0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
  224, 15, 224, 31, 224, 15, 224, 7, 224, 15, 224, 3, 224, 15, 224, 1,
  224, 15, 224, 1, 224, 15, 224, 0, 224, 15, 224, 0, 224, 15, 224, 0,
  96, 15, 224, 48, 96, 15, 224, 48, 96, 15, 224, 48, 0, 15, 224, 112,
  0, 15, 224, 112, 0, 15, 224, 240, 0, 15, 225, 240, 0, 15, 255, 240,
  0, 15, 225, 240, 0, 15, 224, 240, 0, 15, 224, 112, 0, 15, 224, 112,
  32, 15, 224, 48, 96, 15, 224, 48, 96, 15, 224, 48, 96, 15, 224, 0,
  96, 15, 224, 0, 224, 15, 224, 0, 224, 15, 224, 0, 224, 15, 224, 1,
  224, 15, 224, 3, 224, 15, 224, 3, 224, 15, 224, 15, 224, 255, 255, 255,
  224, 255, 255, 255, 224, 27, 44, 176, 33, 3, 0, 0, 6, 0, 0, 0,
  15, 0, 0, 0, 15, 128, 0, 0, 31, 192, 0, 0, 57, 224, 0, 0,
  240, 112, 0, 3, 192, 28, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 255, 255, 255, 224, 15, 224, 31, 224, 15, 224, 7, 224, 15,
  224, 3, 224, 15, 224, 1, 224, 15, 224, 1, 224, 15, 224, 0, 224, 15,
  224, 0, 224, 15, 224, 0, 96, 15, 224, 48, 96, 15, 224, 48, 96, 15,
  224, 48, 0, 15, 224, 112, 0, 15, 224, 112, 0, 15, 224, 240, 0, 15,
  225, 240, 0, 15, 255, 240, 0, 15, 225, 240, 0, 15, 224, 240, 0, 15,
  224, 112, 0, 15, 224, 112, 32, 15, 224, 48, 96, 15, 224, 48, 96, 15,
  224, 48, 96, 15, 224, 0, 96, 15, 224, 0, 96, 15, 224, 0, 224, 15,
  224, 0, 224, 15, 224, 1, 224, 15, 224, 3, 224, 15, 224, 3, 224, 15,
  224, 15, 224, 255, 255, 255, 224, 255, 255, 255, 224, 27, 43, 172, 33, 3,
  0, 1, 224, 120, 0, 3, 240, 252, 0, 3, 240, 252, 0, 3, 240, 252,
  0, 3, 240, 252, 0, 1, 224, 120, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 255, 255, 255, 224, 15, 224, 31, 224, 15, 224, 7,
  224, 15, 224, 3, 224, 15, 224, 1, 224, 15, 224, 1, 224, 15, 224, 0,
  224, 15, 224, 0, 224, 15, 224, 0, 224, 15, 224, 48, 96, 15, 224, 48,
  96, 15, 224, 48, 0, 15, 224, 112, 0, 15, 224, 112, 0, 15, 224, 240,
  0, 15, 225, 240, 0, 15, 255, 240, 0, 15, 225, 240, 0, 15, 224, 240,
  0, 15, 224, 112, 0, 15, 224, 112, 96, 15, 224, 48, 96, 15, 224, 48,
  96, 15, 224, 48, 96, 15, 224, 0, 96, 15, 224, 0, 224, 15, 224, 0,
  224, 15, 224, 0, 224, 15, 224, 1, 224, 15, 224, 3, 224, 15, 224, 3,
  224, 15, 224, 15, 224, 255, 255, 255, 224, 255, 255, 255, 224, 16, 45, 90,
  21, 3, 0, 56, 0, 124, 0, 124, 0, 62, 0, 31, 0, 15, 0, 3,
  128, 1, 192, 0, 0, 0, 0, 0, 0, 255, 255, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 255, 255, 16, 45, 90,
  21, 3, 0, 0, 14, 0, 30, 0, 62, 0, 60, 0, 120, 0, 240, 0,
  224, 1, 192, 0, 0, 0, 0, 0, 0, 255, 255, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 255, 255, 16, 44, 88,
  21, 3, 0, 1, 192, 3, 192, 3, 224, 7, 240, 31, 120, 60, 28, 240,
  7, 0, 1, 0, 0, 0, 0, 255, 255, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 255, 255, 255, 255, 16, 43, 86, 21, 3,
  0, 120, 30, 252, 63, 252, 63, 252, 63, 252, 63, 120, 30, 0, 0, 0,
  0, 0, 0, 255, 255, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 255, 255, 32, 34, 136, 37, 3, 0, 255, 255, 248,
  0, 7, 240, 31, 0, 7, 240, 7, 128, 7, 240, 3, 224, 7, 240, 1,
  240, 7, 240, 1, 240, 7, 240, 0, 248, 7, 240, 0, 252, 7, 240, 0,
  252, 7, 240, 0, 254, 7, 240, 0, 254, 7, 240, 0, 254, 7, 240, 0,
  255, 7, 240, 0, 255, 7, 240, 0, 255, 7, 240, 0, 255, 255, 255, 0,
  255, 7, 240, 0, 255, 7, 240, 0, 255, 7, 240, 0, 255, 7, 240, 0,
  255, 7, 240, 0, 254, 7, 240, 0, 254, 7, 240, 0, 254, 7, 240, 0,
  254, 7, 240, 0, 252, 7, 240, 0, 252, 7, 240, 0, 248, 7, 240, 1,
  240, 7, 240, 1, 224, 7, 240, 3, 192, 7, 240, 7, 128, 7, 240, 31,
  0, 255, 255, 248, 0, 34, 44, 220, 37, 2, 255, 0, 7, 128, 128, 0,
  0, 15, 241, 128, 0, 0, 31, 255, 0, 0, 0, 16, 255, 0, 0, 0,
  16, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 224, 15, 255, 192, 31, 240, 3,
  255, 0, 15, 240, 0, 252, 0, 15, 248, 0, 120, 0, 7, 252, 0, 48,
  0, 3, 254, 0, 48, 0, 3, 254, 0, 48, 0, 3, 255, 0, 48, 0,
  3, 255, 128, 48, 0, 3, 255, 128, 48, 0, 3, 127, 192, 48, 0, 3,
  63, 224, 48, 0, 3, 31, 224, 48, 0, 3, 31, 240, 48, 0, 3, 15,
  248, 48, 0, 3, 7, 248, 48, 0, 3, 7, 252, 48, 0, 3, 3, 254,
  48, 0, 3, 1, 255, 48, 0, 3, 1, 255, 48, 0, 3, 0, 255, 176,
  0, 3, 0, 127, 240, 0, 3, 0, 127, 240, 0, 3, 0, 63, 240, 0,
  3, 0, 31, 240, 0, 3, 0, 15, 240, 0, 3, 0, 15, 240, 0, 3,
  0, 7, 240, 0, 3, 0, 3, 240, 0, 3, 0, 3, 240, 0, 7, 128,
  1, 240, 0, 15, 192, 0, 240, 0, 63, 240, 0, 240, 0, 255, 252, 0,
  112, 0, 0, 0, 0, 48, 0, 28, 45, 180, 33, 3, 0, 0, 192, 0,
  0, 1, 224, 0, 0, 1, 240, 0, 0, 0, 248, 0, 0, 0, 120, 0,
  0, 0, 60, 0, 0, 0, 28, 0, 0, 0, 6, 0, 0, 0, 2, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 192, 0, 0, 224, 112,
  0, 3, 192, 56, 0, 7, 128, 30, 0, 15, 128, 30, 0, 15, 0, 15,
  0, 31, 0, 15, 128, 63, 0, 15, 192, 63, 0, 15, 192, 127, 0, 15,
  192, 127, 0, 15, 224, 127, 0, 15, 224, 127, 0, 15, 224, 255, 0, 15,
  240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15,
  240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 127, 0, 15,
  224, 127, 0, 15, 224, 127, 0, 15, 224, 127, 0, 15, 192, 63, 0, 15,
  192, 63, 0, 15, 192, 31, 0, 15, 128, 15, 0, 15, 0, 15, 128, 31,
  0, 7, 128, 30, 0, 3, 192, 60, 0, 0, 224, 112, 0, 0, 63, 192,
  0, 28, 45, 180, 33, 3, 0, 0, 0, 48, 0, 0, 0, 120, 0, 0,
  0, 248, 0, 0, 1, 240, 0, 0, 1, 224, 0, 0, 3, 192, 0, 0,
  3, 128, 0, 0, 6, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 63, 192, 0, 0, 224, 112, 0, 3, 192, 56, 0, 7,
  128, 30, 0, 15, 128, 30, 0, 15, 0, 15, 0, 31, 0, 15, 128, 63,
  0, 15, 192, 63, 0, 15, 192, 127, 0, 15, 192, 127, 0, 15, 224, 127,
  0, 15, 224, 127, 0, 15, 224, 255, 0, 15, 240, 255, 0, 15, 240, 255,
  0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 255,
  0, 15, 240, 255, 0, 15, 240, 127, 0, 15, 224, 127, 0, 15, 224, 127,
  0, 15, 224, 127, 0, 15, 192, 63, 0, 15, 192, 63, 0, 15, 192, 31,
  0, 15, 128, 15, 0, 15, 0, 15, 128, 31, 0, 7, 128, 30, 0, 3,
  192, 60, 0, 0, 224, 112, 0, 0, 63, 192, 0, 28, 45, 180, 33, 3,
  0, 0, 6, 0, 0, 0, 14, 0, 0, 0, 15, 0, 0, 0, 31, 128,
  0, 0, 63, 192, 0, 0, 121, 224, 0, 0, 240, 240, 0, 3, 192, 60,
  0, 3, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 192,
  0, 0, 224, 112, 0, 3, 192, 56, 0, 7, 128, 30, 0, 15, 128, 30,
  0, 15, 0, 15, 0, 31, 0, 15, 128, 63, 0, 15, 192, 63, 0, 15,
  192, 127, 0, 15, 192, 127, 0, 15, 224, 127, 0, 15, 224, 127, 0, 15,
  224, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15,
  240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15,
  240, 127, 0, 15, 224, 127, 0, 15, 224, 127, 0, 15, 224, 127, 0, 15,
  192, 63, 0, 15, 192, 63, 0, 15, 192, 31, 0, 15, 128, 15, 0, 15,
  0, 15, 128, 31, 0, 7, 128, 30, 0, 3, 192, 60, 0, 0, 224, 112,
  0, 0, 63, 192, 0, 28, 44, 176, 33, 3, 0, 0, 0, 8, 0, 0,
  126, 24, 0, 0, 255, 248, 0, 1, 255, 240, 0, 1, 7, 224, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 63, 192, 0, 0, 224, 112, 0, 3, 192, 56, 0, 7,
  128, 30, 0, 15, 128, 30, 0, 15, 0, 15, 0, 31, 0, 15, 128, 63,
  0, 15, 192, 63, 0, 15, 192, 127, 0, 15, 192, 127, 0, 15, 224, 127,
  0, 15, 224, 127, 0, 15, 224, 255, 0, 15, 240, 255, 0, 15, 240, 255,
  0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 255,
  0, 15, 240, 255, 0, 15, 240, 127, 0, 15, 224, 127, 0, 15, 224, 127,
  0, 15, 224, 127, 0, 15, 192, 63, 0, 15, 192, 63, 0, 15, 192, 31,
  0, 15, 128, 15, 0, 15, 0, 15, 128, 31, 0, 7, 128, 30, 0, 3,
  192, 60, 0, 0, 224, 112, 0, 0, 63, 192, 0, 28, 44, 176, 33, 3,
  0, 1, 224, 120, 0, 3, 240, 252, 0, 3, 240, 252, 0, 3, 240, 252,
  0, 3, 240, 252, 0, 1, 224, 120, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 192, 0, 0, 224, 112,
  0, 3, 192, 56, 0, 7, 128, 30, 0, 15, 128, 30, 0, 15, 0, 15,
  0, 31, 0, 15, 128, 63, 0, 15, 192, 63, 0, 15, 192, 127, 0, 15,
  192, 127, 0, 15, 224, 127, 0, 15, 224, 127, 0, 15, 224, 255, 0, 15,
  240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15,
  240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 127, 0, 15,
  224, 127, 0, 15, 224, 127, 0, 15, 224, 127, 0, 15, 192, 63, 0, 15,
  192, 63, 0, 15, 192, 31, 0, 15, 128, 15, 0, 15, 0, 15, 128, 31,
  0, 7, 128, 30, 0, 3, 192, 60, 0, 0, 224, 112, 0, 0, 63, 192,
  0, 31, 30, 120, 45, 7, 253, 32, 0, 0, 0, 112, 0, 0, 12, 248,
  0, 0, 30, 124, 0, 0, 60, 62, 0, 0, 120, 31, 0, 1, 240, 15,
  128, 3, 224, 7, 192, 7, 192, 3, 224, 15, 128, 1, 240, 31, 0, 0,
  248, 62, 0, 0, 124, 124, 0, 0, 62, 248, 0, 0, 31, 240, 0, 0,
  15, 224, 0, 0, 7, 192, 0, 0, 15, 224, 0, 0, 31, 240, 0, 0,
  62, 248, 0, 0, 124, 60, 0, 0, 248, 30, 0, 1, 240, 15, 0, 3,
  224, 7, 128, 7, 192, 3, 192, 15, 128, 1, 224, 31, 0, 0, 240, 62,
  0, 0, 120, 124, 0, 0, 60, 248, 0, 0, 30, 112, 0, 0, 12, 28,
  34, 136, 33, 3, 1, 0, 63, 224, 48, 0, 224, 112, 96, 1, 192, 60,
  192, 7, 128, 31, 192, 15, 128, 31, 128, 15, 0, 15, 0, 31, 0, 15,
  128, 63, 0, 15, 192, 63, 0, 31, 192, 63, 0, 31, 224, 127, 0, 63,
  224, 127, 0, 111, 224, 127, 0, 239, 224, 255, 0, 207, 240, 255, 1, 143,
  240, 255, 3, 15, 240, 255, 7, 15, 240, 255, 14, 15, 240, 255, 12, 15,
  240, 255, 24, 15, 240, 255, 48, 15, 240, 255, 112, 15, 224, 127, 96, 15,
  224, 127, 192, 15, 224, 127, 128, 15, 192, 63, 128, 15, 192, 63, 0, 15,
  192, 31, 0, 15, 128, 15, 0, 15, 0, 31, 128, 30, 0, 63, 128, 30,
  0, 51, 192, 56, 0, 96, 224, 112, 0, 192, 127, 192, 0, 33, 45, 225,
  38, 3, 0, 0, 24, 0, 0, 0, 0, 60, 0, 0, 0, 0, 62, 0,
  0, 0, 0, 31, 0, 0, 0, 0, 15, 128, 0, 0, 0, 7, 128, 0,
  0, 0, 1, 192, 0, 0, 0, 0, 224, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 7, 255, 128, 15,
  224, 1, 254, 0, 15, 224, 0, 120, 0, 15, 224, 0, 48, 0, 15, 224,
  0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0,
  48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48,
  0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0,
  15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15,
  224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224,
  0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0,
  48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 7, 224, 0, 48,
  0, 7, 224, 0, 96, 0, 7, 240, 0, 96, 0, 3, 240, 0, 192, 0,
  1, 248, 1, 192, 0, 0, 252, 3, 128, 0, 0, 127, 159, 0, 0, 0,
  31, 252, 0, 0, 33, 45, 225, 38, 3, 0, 0, 0, 7, 0, 0, 0,
  0, 15, 0, 0, 0, 0, 15, 0, 0, 0, 0, 31, 0, 0, 0, 0,
  60, 0, 0, 0, 0, 56, 0, 0, 0, 0, 112, 0, 0, 0, 0, 224,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 255, 255, 7, 255, 128, 15, 224, 1, 254, 0, 15, 224, 0, 120, 0,
  15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15,
  224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224,
  0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0,
  48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48,
  0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0,
  15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15,
  224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224,
  0, 48, 0, 7, 224, 0, 48, 0, 7, 224, 0, 96, 0, 7, 240, 0,
  96, 0, 3, 240, 0, 192, 0, 1, 248, 1, 192, 0, 0, 252, 3, 128,
  0, 0, 127, 159, 0, 0, 0, 31, 252, 0, 0, 33, 45, 225, 38, 3,
  0, 0, 0, 64, 0, 0, 0, 0, 224, 0, 0, 0, 1, 240, 0, 0,
  0, 3, 240, 0, 0, 0, 7, 248, 0, 0, 0, 15, 28, 0, 0, 0,
  30, 15, 0, 0, 0, 112, 3, 128, 0, 0, 0, 0, 128, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 7, 255, 128, 15, 224, 1,
  254, 0, 15, 224, 0, 120, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48,
  0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0,
  15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15,
  224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224,
  0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0,
  48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48,
  0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0,
  15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 7, 224, 0, 48, 0, 7,
  224, 0, 96, 0, 7, 240, 0, 96, 0, 3, 240, 0, 192, 0, 1, 248,
  1, 192, 0, 0, 252, 3, 128, 0, 0, 127, 159, 0, 0, 0, 31, 252,
  0, 0, 33, 44, 220, 38, 3, 0, 0, 60, 15, 0, 0, 0, 126, 31,
  128, 0, 0, 126, 31, 128, 0, 0, 126, 31, 128, 0, 0, 126, 31, 128,
  0, 0, 60, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 254, 7, 255, 128, 15,
  224, 1, 254, 0, 15, 224, 0, 120, 0, 15, 224, 0, 48, 0, 15, 224,
  0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0,
  48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48,
  0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0,
  15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15,
  224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224,
  0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0,
  48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 7, 224, 0, 48,
  0, 7, 224, 0, 96, 0, 7, 240, 0, 96, 0, 3, 240, 0, 192, 0,
  1, 248, 1, 192, 0, 0, 252, 3, 128, 0, 0, 127, 159, 0, 0, 0,
  31, 252, 0, 0, 32, 45, 180, 35, 2, 0, 0, 0, 7, 0, 0, 0,
  15, 0, 0, 0, 31, 0, 0, 0, 31, 0, 0, 0, 60, 0, 0, 0,
  120, 0, 0, 0, 112, 0, 0, 0, 192, 0, 0, 0, 128, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 255, 254, 15, 255, 31, 248, 1, 248, 15, 248,
  0, 240, 7, 248, 0, 224, 7, 248, 0, 192, 3, 252, 0, 192, 3, 252,
  0, 192, 1, 252, 1, 128, 1, 254, 1, 128, 0, 254, 3, 0, 0, 255,
  3, 0, 0, 255, 3, 0, 0, 127, 134, 0, 0, 127, 134, 0, 0, 63,
  196, 0, 0, 63, 204, 0, 0, 31, 204, 0, 0, 31, 248, 0, 0, 15,
  248, 0, 0, 15, 248, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 255, 255, 0, 29, 34,
  136, 34, 3, 0, 255, 255, 128, 0, 7, 240, 0, 0, 7, 240, 0, 0,
  7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 255, 248, 0,
  7, 240, 63, 0, 7, 240, 15, 192, 7, 240, 15, 224, 7, 240, 15, 240,
  7, 240, 7, 240, 7, 240, 7, 248, 7, 240, 7, 248, 7, 240, 7, 248,
  7, 240, 7, 248, 7, 240, 7, 248, 7, 240, 7, 248, 7, 240, 7, 240,
  7, 240, 15, 240, 7, 240, 15, 224, 7, 240, 15, 192, 7, 240, 31, 0,
  7, 255, 252, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0,
  7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0,
  7, 240, 0, 0, 7, 240, 0, 0, 255, 255, 128, 0, 23, 34, 102, 27,
  2, 0, 0, 127, 0, 1, 227, 128, 3, 195, 224, 7, 193, 224, 7, 193,
  240, 15, 129, 240, 15, 129, 240, 15, 129, 240, 31, 129, 240, 31, 129, 224,
  31, 129, 224, 31, 129, 192, 31, 131, 128, 31, 188, 0, 31, 131, 0, 31,
  129, 192, 31, 128, 240, 31, 128, 248, 31, 128, 248, 31, 128, 124, 31, 128,
  124, 31, 128, 126, 31, 128, 126, 31, 128, 126, 31, 128, 126, 31, 128, 126,
  31, 128, 126, 31, 184, 126, 31, 252, 124, 31, 252, 124, 31, 248, 252, 31,
  248, 248, 31, 184, 240, 255, 159, 224, 21, 34, 102, 24, 2, 0, 24, 0,
  0, 60, 0, 0, 62, 0, 0, 30, 0, 0, 15, 0, 0, 7, 128, 0,
  3, 128, 0, 1, 192, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 15, 248, 0, 24, 62, 0, 56, 63, 0, 120, 31, 0, 124, 31,
  128, 126, 31, 128, 126, 31, 128, 60, 31, 128, 0, 127, 128, 3, 223, 128,
  15, 31, 128, 30, 31, 128, 62, 31, 128, 124, 31, 128, 252, 31, 128, 252,
  31, 128, 252, 31, 136, 252, 31, 136, 252, 31, 152, 254, 63, 144, 127, 127,
  240, 63, 143, 224, 21, 34, 102, 24, 2, 0, 0, 12, 0, 0, 30, 0,
  0, 62, 0, 0, 62, 0, 0, 124, 0, 0, 120, 0, 0, 224, 0, 0,
  192, 0, 1, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 248,
  0, 24, 62, 0, 56, 63, 0, 120, 31, 0, 124, 31, 128, 126, 31, 128,
  126, 31, 128, 62, 31, 128, 8, 63, 128, 1, 255, 128, 7, 159, 128, 30,
  31, 128, 62, 31, 128, 124, 31, 128, 124, 31, 128, 252, 31, 128, 252, 31,
  136, 252, 31, 136, 252, 31, 152, 254, 63, 144, 127, 127, 240, 63, 143, 224,
  21, 34, 102, 24, 2, 0, 1, 192, 0, 1, 224, 0, 3, 224, 0, 3,
  224, 0, 7, 240, 0, 7, 56, 0, 14, 28, 0, 28, 14, 0, 48, 7,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 248, 0, 24, 62, 0,
  56, 63, 0, 120, 31, 0, 124, 31, 128, 126, 31, 128, 126, 31, 128, 62,
  31, 128, 8, 63, 128, 1, 255, 128, 7, 159, 128, 30, 31, 128, 62, 31,
  128, 124, 31, 128, 124, 31, 128, 252, 31, 128, 252, 31, 136, 252, 31, 136,
  252, 31, 152, 254, 63, 144, 127, 127, 240, 63, 143, 224, 21, 32, 96, 24,
  2, 0, 15, 3, 0, 31, 195, 0, 63, 254, 0, 49, 252, 0, 32, 120,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  15, 248, 0, 24, 62, 0, 56, 63, 0, 120, 31, 0, 124, 31, 128, 126,
  31, 128, 126, 31, 128, 62, 31, 128, 8, 63, 128, 1, 255, 128, 7, 159,
  128, 30, 31, 128, 62, 31, 128, 124, 31, 128, 124, 31, 128, 252, 31, 128,
  252, 31, 136, 252, 31, 136, 252, 31, 152, 254, 63, 144, 127, 127, 240, 63,
  143, 224, 21, 32, 96, 24, 2, 0, 60, 30, 0, 126, 63, 0, 126, 63,
  0, 126, 63, 0, 126, 63, 0, 60, 30, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 15, 248, 0, 24, 62, 0, 56, 63, 0, 120,
  31, 0, 124, 31, 128, 126, 31, 128, 126, 31, 128, 62, 31, 128, 8, 63,
  128, 1, 255, 128, 7, 159, 128, 30, 31, 128, 62, 31, 128, 124, 31, 128,
  124, 31, 128, 252, 31, 128, 252, 31, 136, 252, 31, 136, 252, 31, 152, 254,
  63, 144, 127, 127, 240, 63, 143, 224, 21, 34, 102, 24, 2, 1, 3, 240,
  0, 7, 248, 0, 14, 28, 0, 12, 12, 0, 12, 12, 0, 12, 12, 0,
  14, 28, 0, 7, 248, 0, 1, 224, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 15, 248, 0, 24, 62, 0, 56, 63, 0, 120, 31, 0, 124, 31,
  128, 126, 31, 128, 126, 31, 128, 62, 31, 128, 8, 63, 128, 1, 255, 128,
  7, 31, 128, 30, 31, 128, 62, 31, 128, 124, 31, 128, 124, 31, 128, 252,
  31, 128, 252, 31, 136, 252, 31, 136, 252, 31, 152, 254, 63, 144, 127, 111,
  240, 63, 199, 224, 29, 22, 88, 34, 2, 1, 15, 240, 255, 128, 24, 63,
  195, 192, 56, 63, 195, 224, 120, 31, 131, 240, 124, 31, 129, 240, 126, 31,
  129, 240, 126, 31, 129, 248, 62, 31, 129, 248, 0, 63, 129, 248, 1, 255,
  129, 248, 7, 31, 255, 248, 30, 31, 128, 0, 62, 31, 128, 0, 124, 31,
  128, 0, 124, 31, 128, 8, 252, 31, 128, 8, 252, 31, 128, 24, 252, 31,
  192, 16, 252, 31, 192, 16, 254, 51, 192, 32, 127, 97, 240, 64, 63, 192,
  255, 128, 18, 32, 96, 22, 2, 247, 3, 252, 0, 15, 6, 0, 31, 7,
  0, 62, 7, 128, 62, 7, 128, 126, 15, 128, 124, 31, 128, 252, 31, 128,
  252, 31, 0, 252, 14, 0, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252,
  0, 0, 252, 0, 0, 124, 0, 64, 124, 0, 192, 62, 0, 128, 62, 1,
  128, 30, 1, 0, 15, 130, 0, 3, 252, 0, 0, 128, 0, 0, 128, 0,
  1, 128, 0, 0, 240, 0, 0, 56, 0, 0, 60, 0, 0, 60, 0, 0,
  60, 0, 4, 120, 0, 3, 240, 0, 18, 34, 102, 23, 2, 0, 28, 0,
  0, 30, 0, 0, 30, 0, 0, 31, 0, 0, 15, 128, 0, 7, 128, 0,
  3, 192, 0, 0, 192, 0, 0, 96, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 3, 252, 0, 14, 30, 0, 30, 31, 0, 62, 15, 128, 60, 15,
  128, 124, 15, 128, 124, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192,
  255, 255, 192, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 64, 124,
  0, 64, 124, 0, 192, 62, 0, 192, 62, 1, 128, 31, 1, 0, 15, 135,
  0, 3, 252, 0, 18, 34, 102, 23, 2, 0, 0, 14, 0, 0, 31, 0,
  0, 31, 0, 0, 62, 0, 0, 60, 0, 0, 120, 0, 0, 240, 0, 0,
  224, 0, 1, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 252,
  0, 14, 30, 0, 30, 31, 0, 62, 15, 128, 60, 15, 128, 124, 15, 128,
  124, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 255, 255, 192, 252,
  0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 64, 124, 0, 64, 124, 0,
  192, 62, 0, 192, 62, 0, 128, 31, 1, 0, 15, 131, 0, 3, 252, 0,
  18, 34, 102, 23, 2, 0, 1, 224, 0, 1, 224, 0, 1, 240, 0, 3,
  240, 0, 3, 248, 0, 7, 56, 0, 14, 28, 0, 28, 14, 0, 56, 3,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 252, 0, 14, 30, 0,
  30, 31, 0, 62, 15, 128, 60, 15, 128, 124, 15, 128, 124, 15, 192, 252,
  15, 192, 252, 15, 192, 252, 15, 192, 255, 255, 192, 252, 0, 0, 252, 0,
  0, 252, 0, 0, 252, 0, 64, 124, 0, 64, 124, 0, 192, 62, 0, 192,
  62, 0, 128, 31, 1, 0, 15, 131, 0, 3, 252, 0, 18, 32, 96, 23,
  2, 0, 30, 15, 0, 63, 31, 128, 63, 31, 128, 63, 31, 128, 63, 31,
  128, 30, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  3, 252, 0, 14, 30, 0, 30, 31, 0, 62, 15, 128, 60, 15, 128, 124,
  15, 128, 124, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 255, 255,
  192, 252, 0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 64, 124, 0, 64,
  124, 0, 192, 62, 0, 192, 62, 0, 128, 31, 1, 0, 15, 131, 0, 3,
  252, 0, 12, 34, 68, 15, 1, 0, 96, 0, 240, 0, 248, 0, 248, 0,
  124, 0, 28, 0, 14, 0, 7, 0, 3, 0, 0, 0, 0, 0, 0, 0,
  127, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128,
  31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 127, 240, 12, 34, 68, 15,
  2, 0, 0, 224, 1, 240, 1, 240, 3, 224, 7, 192, 7, 128, 15, 0,
  28, 0, 24, 0, 0, 0, 0, 0, 0, 0, 255, 0, 63, 0, 63, 0,
  63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0,
  63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0,
  63, 0, 63, 0, 255, 224, 14, 34, 68, 14, 0, 0, 7, 128, 15, 128,
  15, 128, 15, 192, 31, 224, 60, 224, 56, 112, 112, 60, 192, 12, 0, 0,
  0, 0, 0, 0, 63, 192, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192,
  15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192,
  15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 63, 248,
  14, 32, 64, 14, 1, 0, 120, 120, 252, 252, 252, 252, 252, 252, 252, 252,
  120, 120, 0, 0, 0, 0, 0, 0, 0, 0, 63, 192, 15, 192, 15, 192,
  15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192,
  15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192,
  15, 192, 15, 192, 63, 248, 20, 34, 102, 24, 2, 0, 15, 193, 128, 15,
  227, 0, 7, 254, 0, 3, 248, 0, 1, 248, 0, 1, 252, 0, 3, 254,
  0, 14, 126, 0, 24, 63, 0, 0, 63, 128, 0, 31, 128, 0, 15, 192,
  7, 255, 192, 15, 15, 224, 30, 7, 224, 62, 7, 224, 62, 7, 224, 124,
  7, 240, 124, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3,
  240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 124, 3, 224,
  124, 7, 224, 62, 7, 192, 62, 7, 192, 30, 7, 128, 15, 15, 0, 3,
  252, 0, 23, 32, 96, 27, 2, 0, 3, 224, 96, 7, 248, 64, 15, 255,
  192, 12, 127, 128, 8, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 255, 31, 192, 63, 35, 224, 63, 65, 240, 63,
  65, 248, 63, 129, 248, 63, 129, 248, 63, 1, 248, 63, 1, 248, 63, 1,
  248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248,
  63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63,
  1, 248, 63, 1, 248, 255, 199, 254, 20, 34, 102, 24, 2, 0, 14, 0,
  0, 31, 0, 0, 31, 0, 0, 15, 128, 0, 7, 192, 0, 3, 192, 0,
  1, 224, 0, 0, 96, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 3, 252, 0, 15, 15, 0, 30, 7, 128, 62, 7, 192, 62, 7,
  192, 124, 3, 224, 124, 3, 224, 252, 3, 240, 252, 3, 240, 252, 3, 240,
  252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 124,
  3, 224, 124, 3, 224, 62, 7, 192, 62, 7, 192, 30, 7, 128, 15, 15,
  0, 3, 252, 0, 20, 34, 102, 24, 2, 0, 0, 7, 0, 0, 15, 128,
  0, 15, 128, 0, 31, 0, 0, 62, 0, 0, 60, 0, 0, 120, 0, 0,
  224, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 252,
  0, 15, 15, 0, 30, 7, 128, 62, 7, 192, 62, 7, 192, 124, 3, 224,
  124, 3, 224, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252,
  3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 124, 3, 224, 124, 3,
  224, 62, 7, 192, 62, 7, 192, 30, 7, 128, 15, 15, 0, 3, 252, 0,
  20, 34, 102, 24, 2, 0, 0, 240, 0, 0, 240, 0, 1, 248, 0, 1,
  248, 0, 3, 252, 0, 3, 156, 0, 7, 14, 0, 14, 7, 0, 24, 1,
  128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 252, 0, 15, 15, 0,
  30, 7, 128, 62, 7, 192, 62, 7, 192, 124, 3, 224, 124, 3, 224, 252,
  3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3,
  240, 252, 3, 240, 252, 3, 240, 124, 3, 224, 124, 3, 224, 62, 7, 192,
  62, 7, 192, 30, 7, 128, 15, 15, 0, 3, 252, 0, 20, 32, 96, 24,
  2, 0, 7, 192, 128, 15, 240, 128, 31, 255, 128, 16, 255, 0, 16, 62,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  3, 252, 0, 15, 15, 0, 30, 7, 128, 62, 7, 192, 62, 7, 192, 124,
  3, 224, 124, 3, 224, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3,
  240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 124, 3, 224,
  124, 3, 224, 62, 7, 192, 62, 7, 192, 30, 7, 128, 15, 15, 0, 3,
  252, 0, 20, 32, 96, 24, 2, 0, 30, 15, 0, 63, 31, 128, 63, 31,
  128, 63, 31, 128, 63, 31, 128, 30, 15, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 3, 252, 0, 15, 15, 0, 30, 7, 128, 62,
  7, 192, 62, 7, 192, 124, 3, 224, 124, 3, 224, 252, 3, 240, 252, 3,
  240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240,
  252, 3, 240, 124, 3, 224, 124, 3, 224, 62, 7, 192, 62, 7, 192, 30,
  7, 128, 15, 15, 0, 3, 252, 0, 41, 32, 192, 45, 2, 253, 0, 0,
  28, 0, 0, 0, 0, 0, 62, 0, 0, 0, 0, 0, 127, 0, 0, 0,
  0, 0, 127, 0, 0, 0, 0, 0, 127, 0, 0, 0, 0, 0, 62, 0,
  0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255, 255, 128, 255, 255,
  255, 255, 255, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 62, 0, 0, 0,
  0, 0, 127, 0, 0, 0, 0, 0, 127, 0, 0, 0, 0, 0, 127, 0,
  0, 0, 0, 0, 62, 0, 0, 0, 0, 0, 28, 0, 0, 0, 20, 22,
  66, 24, 2, 1, 3, 252, 48, 15, 15, 96, 30, 15, 192, 62, 7, 192,
  62, 7, 192, 124, 7, 224, 124, 7, 224, 252, 15, 240, 252, 27, 240, 252,
  51, 240, 252, 115, 240, 252, 227, 240, 252, 195, 240, 253, 131, 240, 255, 3,
  240, 126, 3, 224, 126, 3, 224, 62, 7, 192, 62, 7, 192, 63, 7, 128,
  111, 15, 0, 195, 252, 0, 24, 34, 102, 26, 1, 0, 7, 0, 0, 7,
  128, 0, 7, 192, 0, 7, 192, 0, 3, 224, 0, 1, 224, 0, 0, 112,
  0, 0, 48, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  255, 143, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31,
  129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129,
  248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248,
  31, 131, 248, 31, 131, 248, 31, 133, 248, 15, 133, 248, 15, 201, 248, 7,
  241, 255, 24, 34, 102, 26, 1, 0, 0, 3, 128, 0, 3, 128, 0, 7,
  128, 0, 15, 128, 0, 15, 0, 0, 30, 0, 0, 28, 0, 0, 56, 0,
  0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 143, 248, 31,
  129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129,
  248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248,
  31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 131, 248, 31,
  131, 248, 31, 133, 248, 15, 133, 248, 15, 201, 248, 7, 241, 255, 24, 34,
  102, 26, 1, 0, 0, 56, 0, 0, 120, 0, 0, 124, 0, 0, 252, 0,
  0, 254, 0, 1, 206, 0, 3, 135, 0, 7, 3, 128, 14, 0, 192, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 143, 248, 31, 129, 248, 31, 129,
  248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248,
  31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31,
  129, 248, 31, 129, 248, 31, 129, 248, 31, 131, 248, 31, 131, 248, 31, 133,
  248, 15, 133, 248, 15, 201, 248, 7, 241, 255, 24, 32, 96, 26, 1, 0,
  7, 131, 192, 15, 199, 224, 15, 199, 224, 15, 199, 224, 15, 199, 224, 7,
  131, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 135,
  248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248,
  31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31,
  129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 131,
  248, 31, 131, 248, 31, 133, 248, 15, 133, 248, 15, 201, 248, 7, 241, 255,
  23, 45, 135, 25, 1, 245, 0, 1, 192, 0, 1, 224, 0, 3, 224, 0,
  7, 192, 0, 7, 128, 0, 15, 0, 0, 14, 0, 0, 28, 0, 0, 24,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 241, 254, 63, 192, 120,
  31, 128, 48, 15, 192, 32, 15, 192, 32, 15, 192, 96, 7, 224, 64, 7,
  224, 64, 3, 240, 192, 3, 240, 128, 1, 248, 128, 1, 249, 128, 0, 249,
  0, 0, 253, 0, 0, 253, 0, 0, 126, 0, 0, 126, 0, 0, 62, 0,
  0, 60, 0, 0, 28, 0, 0, 28, 0, 0, 12, 0, 0, 8, 0, 0,
  8, 0, 0, 8, 0, 15, 16, 0, 31, 16, 0, 63, 144, 0, 63, 32,
  0, 62, 32, 0, 62, 64, 0, 31, 192, 0, 15, 0, 0, 22, 44, 132,
  25, 1, 244, 3, 128, 0, 15, 128, 0, 63, 128, 0, 255, 128, 0, 223,
  128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128,
  0, 31, 135, 240, 31, 159, 248, 31, 177, 248, 31, 160, 252, 31, 192, 252,
  31, 192, 252, 31, 192, 252, 31, 128, 252, 31, 128, 252, 31, 128, 248, 31,
  129, 248, 31, 129, 240, 31, 129, 240, 31, 129, 224, 31, 131, 192, 31, 131,
  128, 31, 135, 128, 31, 134, 0, 31, 140, 0, 31, 152, 0, 31, 224, 0,
  31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31,
  128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 30, 0, 0, 120, 0,
  0, 224, 0, 0, 128, 0, 0, 23, 44, 132, 25, 1, 245, 3, 193, 224,
  7, 227, 240, 7, 227, 240, 7, 227, 240, 7, 227, 240, 3, 193, 224, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 241,
  254, 63, 192, 120, 31, 128, 48, 15, 192, 32, 15, 192, 32, 15, 192, 96,
  7, 224, 64, 7, 224, 64, 3, 240, 192, 3, 240, 128, 1, 240, 128, 1,
  249, 128, 0, 249, 0, 0, 253, 0, 0, 253, 0, 0, 126, 0, 0, 126,
  0, 0, 62, 0, 0, 60, 0, 0, 28, 0, 0, 28, 0, 0, 12, 0,
  0, 8, 0, 0, 8, 0, 0, 8, 0, 15, 16, 0, 31, 16, 0, 63,
  144, 0, 63, 32, 0, 62, 32, 0, 62, 64, 0, 31, 192, 0, 15, 0,
  0
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--48-480-72-72-P-258-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 0, '1' Height: 34
  Calculated Max Values w=41 h=44 x= 6 y=13 dx=45 dy= 0 ascent=35 len=246
  Font Bounding box     w=133 h=60 x=-41 y=-14
  Calculated Min Values           x= 0 y=-9 dx= 0 dy= 0
  Pure Font   ascent =34 descent= 0
  X Font      ascent =34 descent= 0
  Max Font    ascent =35 descent=-9
*/
const u8g_fntpgm_uint8_t u8g_font_osb35n[1567] U8G_FONT_SECTION("u8g_font_osb35n") = {
  0, 133, 60, 215, 242, 34, 0, 0, 0, 0, 42, 58, 0, 35, 247, 34,
  0, 17, 19, 57, 24, 4, 13, 1, 128, 0, 3, 192, 0, 3, 192, 0,
  227, 195, 0, 241, 135, 128, 248, 143, 128, 252, 159, 128, 126, 191, 0, 3,
  192, 0, 3, 192, 0, 126, 191, 0, 252, 159, 128, 248, 143, 128, 241, 135,
  128, 225, 195, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 1, 128, 0,
  41, 41, 246, 45, 2, 249, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0,
  0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0,
  28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0,
  0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0,
  0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0,
  28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0,
  0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0,
  0, 0, 0, 0, 28, 0, 0, 0, 255, 255, 255, 255, 255, 128, 255, 255,
  255, 255, 255, 128, 255, 255, 255, 255, 255, 128, 0, 0, 28, 0, 0, 0,
  0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0,
  0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0,
  28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0,
  0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0,
  0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0,
  28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0,
  0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 9, 15, 30, 13,
  2, 248, 126, 0, 255, 0, 255, 128, 255, 128, 255, 128, 127, 128, 1, 128,
  1, 128, 1, 128, 3, 0, 2, 0, 6, 0, 28, 0, 56, 0, 96, 0,
  12, 5, 10, 18, 3, 10, 255, 240, 255, 240, 255, 240, 255, 240, 255, 240,
  8, 6, 6, 14, 3, 1, 126, 255, 255, 255, 255, 126, 16, 44, 88, 22,
  3, 247, 0, 7, 0, 15, 0, 14, 0, 14, 0, 14, 0, 30, 0, 28,
  0, 28, 0, 60, 0, 56, 0, 56, 0, 120, 0, 112, 0, 112, 0, 240,
  0, 224, 0, 224, 0, 224, 1, 224, 1, 192, 1, 192, 3, 192, 3, 128,
  3, 128, 7, 128, 7, 0, 7, 0, 15, 0, 14, 0, 14, 0, 14, 0,
  30, 0, 28, 0, 28, 0, 60, 0, 56, 0, 56, 0, 120, 0, 112, 0,
  112, 0, 240, 0, 224, 0, 224, 0, 224, 0, 23, 35, 105, 28, 2, 0,
  0, 16, 0, 0, 254, 0, 3, 199, 128, 7, 131, 192, 15, 1, 224, 15,
  1, 224, 31, 1, 240, 63, 1, 248, 63, 1, 248, 127, 1, 248, 127, 1,
  252, 127, 1, 252, 127, 1, 252, 255, 1, 254, 255, 1, 254, 255, 1, 254,
  255, 1, 254, 255, 1, 254, 255, 1, 254, 255, 1, 254, 255, 1, 254, 255,
  1, 254, 255, 1, 254, 127, 1, 252, 127, 1, 252, 127, 1, 252, 127, 1,
  252, 63, 1, 248, 63, 1, 248, 31, 1, 240, 15, 1, 224, 15, 1, 224,
  7, 131, 192, 3, 199, 128, 0, 254, 0, 16, 34, 68, 28, 6, 0, 0,
  240, 0, 240, 1, 240, 7, 240, 255, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 255,
  255, 255, 255, 21, 34, 102, 28, 3, 1, 7, 255, 0, 14, 15, 192, 28,
  7, 224, 56, 7, 240, 120, 3, 240, 120, 3, 248, 248, 3, 248, 252, 3,
  248, 255, 3, 248, 255, 3, 248, 255, 7, 248, 127, 7, 240, 63, 15, 240,
  12, 15, 224, 0, 31, 192, 0, 63, 128, 0, 127, 0, 0, 252, 0, 1,
  240, 0, 3, 192, 0, 7, 128, 0, 14, 0, 24, 12, 0, 24, 24, 0,
  24, 48, 0, 24, 96, 0, 24, 111, 192, 56, 127, 255, 248, 255, 255, 240,
  239, 255, 240, 195, 255, 240, 193, 255, 224, 192, 255, 192, 192, 63, 128, 22,
  34, 102, 28, 3, 1, 7, 255, 0, 14, 15, 192, 28, 7, 224, 56, 7,
  240, 120, 3, 240, 124, 3, 248, 126, 3, 248, 127, 3, 248, 127, 3, 248,
  127, 3, 248, 63, 3, 240, 30, 3, 240, 0, 7, 224, 0, 7, 192, 0,
  15, 0, 7, 248, 0, 0, 31, 128, 0, 15, 192, 0, 7, 224, 0, 7,
  240, 0, 3, 248, 0, 3, 248, 62, 3, 252, 127, 3, 252, 255, 3, 252,
  255, 3, 252, 255, 3, 252, 254, 3, 252, 252, 3, 248, 248, 7, 248, 120,
  7, 240, 56, 15, 224, 30, 31, 192, 15, 255, 0, 23, 34, 102, 28, 2,
  0, 0, 7, 192, 0, 15, 192, 0, 15, 192, 0, 31, 192, 0, 63, 192,
  0, 63, 192, 0, 127, 192, 0, 127, 192, 0, 255, 192, 0, 223, 192, 1,
  223, 192, 1, 159, 192, 3, 159, 192, 7, 31, 192, 6, 31, 192, 14, 31,
  192, 12, 31, 192, 28, 31, 192, 24, 31, 192, 56, 31, 192, 112, 31, 192,
  96, 31, 192, 224, 31, 192, 255, 255, 254, 0, 31, 192, 0, 31, 192, 0,
  31, 192, 0, 31, 192, 0, 31, 192, 0, 31, 192, 0, 31, 192, 0, 31,
  192, 7, 255, 252, 7, 255, 252, 21, 34, 102, 28, 4, 0, 32, 0, 192,
  60, 7, 128, 63, 255, 128, 63, 255, 0, 63, 254, 0, 63, 248, 0, 63,
  224, 0, 63, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0,
  0, 48, 0, 0, 49, 252, 0, 54, 63, 0, 60, 15, 192, 56, 15, 224,
  48, 15, 224, 32, 7, 240, 0, 7, 240, 0, 7, 248, 0, 7, 248, 8,
  7, 248, 62, 7, 248, 126, 7, 248, 254, 7, 248, 254, 7, 248, 254, 7,
  240, 248, 7, 240, 240, 7, 224, 112, 15, 192, 48, 15, 192, 28, 31, 0,
  15, 252, 0, 22, 34, 102, 28, 3, 1, 0, 255, 128, 3, 192, 192, 7,
  192, 96, 15, 128, 240, 31, 131, 240, 31, 7, 240, 63, 15, 240, 63, 15,
  240, 127, 15, 224, 127, 7, 192, 127, 3, 0, 127, 0, 0, 255, 0, 0,
  255, 0, 0, 255, 63, 0, 255, 255, 192, 255, 195, 224, 255, 131, 240, 255,
  3, 248, 255, 1, 248, 255, 1, 252, 255, 1, 252, 255, 1, 252, 127, 1,
  252, 127, 1, 252, 127, 1, 252, 127, 1, 252, 63, 1, 248, 63, 1, 248,
  31, 1, 248, 15, 129, 240, 7, 131, 224, 3, 195, 192, 1, 255, 0, 20,
  34, 102, 28, 5, 1, 71, 224, 224, 207, 240, 224, 223, 248, 112, 255, 252,
  48, 255, 254, 48, 255, 255, 240, 255, 255, 240, 224, 31, 176, 192, 0, 32,
  192, 0, 96, 128, 0, 96, 128, 0, 192, 128, 1, 192, 0, 1, 128, 0,
  3, 128, 0, 7, 0, 0, 15, 0, 0, 14, 0, 0, 30, 0, 0, 60,
  0, 0, 124, 0, 0, 252, 0, 1, 252, 0, 1, 248, 0, 3, 248, 0,
  3, 248, 0, 7, 248, 0, 7, 248, 0, 7, 248, 0, 7, 248, 0, 7,
  248, 0, 7, 248, 0, 3, 248, 0, 3, 240, 0, 23, 34, 102, 28, 3,
  1, 1, 255, 128, 7, 0, 192, 12, 0, 96, 28, 0, 48, 56, 0, 24,
  56, 0, 24, 120, 0, 24, 120, 0, 24, 124, 0, 24, 126, 0, 24, 127,
  0, 48, 127, 192, 32, 127, 240, 96, 63, 255, 128, 63, 255, 0, 31, 255,
  192, 15, 255, 240, 7, 255, 248, 15, 255, 248, 24, 63, 252, 48, 15, 252,
  112, 3, 254, 96, 0, 254, 224, 0, 126, 224, 0, 62, 224, 0, 30, 224,
  0, 30, 224, 0, 12, 240, 0, 28, 112, 0, 24, 56, 0, 24, 28, 0,
  48, 15, 0, 192, 3, 255, 0, 22, 34, 102, 28, 3, 1, 3, 254, 0,
  15, 15, 0, 31, 7, 128, 62, 7, 192, 126, 3, 224, 126, 3, 240, 126,
  3, 240, 254, 3, 248, 254, 3, 248, 254, 3, 248, 254, 3, 248, 254, 3,
  252, 254, 3, 252, 254, 3, 252, 126, 3, 252, 127, 7, 252, 63, 7, 252,
  31, 15, 252, 15, 255, 252, 3, 243, 252, 0, 3, 252, 0, 3, 252, 0,
  3, 248, 7, 3, 248, 31, 131, 248, 31, 195, 248, 63, 195, 240, 63, 195,
  240, 63, 131, 224, 62, 7, 224, 60, 7, 192, 28, 15, 128, 14, 31, 0,
  7, 252, 0, 8, 22, 22, 14, 3, 1, 126, 255, 255, 255, 255, 126, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 255, 255, 255, 255, 126
};

/*
  Fontname: -FreeType-Old Standard TT-Bold-R-Normal--48-480-72-72-P-258-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 35, '1' Height: 34
  Calculated Max Values w=49 h=46 x= 6 y=25 dx=52 dy= 0 ascent=38 len=246
  Font Bounding box     w=133 h=60 x=-41 y=-14
  Calculated Min Values           x=-2 y=-11 dx= 0 dy= 0
  Pure Font   ascent =35 descent=-10
  X Font      ascent =35 descent=-10
  Max Font    ascent =38 descent=-11
*/
const u8g_fntpgm_uint8_t u8g_font_osb35r[10247] U8G_FONT_SECTION("u8g_font_osb35r") = {
  0, 133, 60, 215, 242, 35, 12, 220, 29, 224, 32, 127, 246, 38, 245, 35,
  246, 0, 0, 0, 13, 0, 0, 8, 34, 34, 14, 3, 1, 126, 126, 255,
  255, 255, 255, 255, 255, 126, 126, 126, 126, 60, 60, 60, 60, 60, 24, 24,
  24, 24, 24, 24, 24, 24, 0, 0, 0, 126, 255, 255, 255, 255, 126, 12,
  12, 24, 18, 3, 23, 32, 64, 241, 224, 249, 240, 249, 240, 249, 240, 249,
  240, 249, 240, 112, 224, 112, 224, 112, 224, 112, 224, 112, 224, 28, 34, 136,
  34, 3, 0, 0, 112, 14, 0, 0, 112, 14, 0, 0, 112, 14, 0, 0,
  112, 14, 0, 0, 240, 30, 0, 0, 224, 28, 0, 0, 224, 28, 0, 0,
  224, 28, 0, 0, 224, 28, 0, 255, 255, 255, 240, 255, 255, 255, 240, 255,
  255, 255, 240, 1, 192, 56, 0, 1, 192, 56, 0, 1, 192, 56, 0, 1,
  192, 56, 0, 3, 192, 56, 0, 3, 128, 120, 0, 3, 128, 112, 0, 3,
  128, 112, 0, 3, 128, 112, 0, 3, 128, 112, 0, 255, 255, 255, 224, 255,
  255, 255, 224, 255, 255, 255, 224, 7, 0, 224, 0, 7, 0, 224, 0, 7,
  0, 224, 0, 7, 0, 224, 0, 15, 1, 224, 0, 14, 1, 224, 0, 14,
  1, 192, 0, 14, 1, 192, 0, 14, 1, 192, 0, 23, 42, 126, 28, 2,
  252, 0, 195, 0, 0, 195, 0, 0, 195, 0, 0, 195, 0, 3, 255, 192,
  7, 195, 112, 28, 195, 24, 60, 195, 12, 56, 195, 14, 120, 195, 14, 120,
  195, 30, 120, 195, 62, 124, 195, 126, 126, 195, 126, 127, 195, 124, 127, 195,
  56, 63, 243, 0, 63, 251, 0, 31, 255, 0, 31, 255, 128, 7, 255, 192,
  3, 255, 240, 0, 255, 248, 0, 255, 248, 0, 223, 252, 0, 199, 252, 124,
  195, 254, 124, 195, 254, 252, 195, 126, 252, 195, 62, 248, 195, 30, 240, 195,
  30, 224, 195, 28, 96, 195, 28, 112, 195, 56, 56, 195, 56, 28, 195, 96,
  7, 255, 192, 0, 195, 0, 0, 195, 0, 0, 195, 0, 0, 195, 0, 33,
  35, 175, 41, 4, 0, 0, 0, 0, 48, 0, 15, 192, 0, 96, 0, 60,
  240, 0, 224, 0, 56, 112, 0, 192, 0, 120, 120, 1, 128, 0, 120, 120,
  1, 128, 0, 248, 124, 3, 0, 0, 248, 124, 7, 0, 0, 248, 124, 6,
  0, 0, 248, 124, 14, 0, 0, 248, 124, 12, 0, 0, 248, 124, 24, 0,
  0, 120, 120, 24, 0, 0, 120, 120, 48, 0, 0, 56, 240, 112, 0, 0,
  28, 224, 96, 0, 0, 15, 192, 192, 0, 0, 0, 0, 192, 0, 0, 0,
  1, 128, 240, 0, 0, 3, 131, 156, 0, 0, 3, 7, 158, 0, 0, 7,
  15, 15, 0, 0, 6, 15, 15, 0, 0, 12, 31, 15, 128, 0, 12, 31,
  15, 128, 0, 24, 31, 15, 128, 0, 56, 31, 15, 128, 0, 48, 31, 15,
  128, 0, 96, 31, 15, 128, 0, 96, 31, 15, 128, 0, 192, 15, 15, 0,
  1, 192, 15, 15, 0, 1, 128, 7, 14, 0, 3, 128, 7, 158, 0, 3,
  0, 1, 248, 0, 33, 34, 170, 37, 2, 1, 0, 31, 224, 0, 0, 0,
  112, 112, 0, 0, 0, 224, 48, 0, 0, 0, 224, 24, 0, 0, 1, 224,
  24, 0, 0, 1, 224, 24, 0, 0, 1, 224, 24, 0, 0, 1, 240, 56,
  0, 0, 1, 240, 48, 0, 0, 1, 248, 96, 0, 0, 1, 248, 192, 0,
  0, 0, 255, 128, 0, 0, 0, 255, 0, 0, 0, 0, 126, 0, 0, 0,
  0, 63, 0, 0, 0, 0, 255, 129, 255, 128, 1, 223, 128, 62, 0, 3,
  143, 192, 28, 0, 7, 15, 224, 24, 0, 14, 7, 224, 56, 0, 30, 3,
  240, 48, 0, 60, 1, 248, 48, 0, 124, 1, 248, 96, 0, 124, 0, 252,
  96, 0, 252, 0, 126, 192, 0, 252, 0, 127, 128, 0, 252, 0, 63, 128,
  0, 254, 0, 31, 128, 0, 255, 0, 31, 128, 0, 255, 0, 15, 193, 128,
  127, 192, 63, 225, 0, 63, 248, 247, 243, 0, 31, 255, 195, 254, 0, 15,
  254, 0, 252, 0, 5, 12, 12, 11, 3, 23, 32, 240, 248, 248, 248, 248,
  248, 112, 112, 112, 112, 112, 14, 43, 86, 18, 3, 248, 0, 28, 0, 56,
  0, 112, 0, 224, 1, 192, 3, 128, 7, 0, 15, 0, 14, 0, 30, 0,
  30, 0, 60, 0, 60, 0, 124, 0, 124, 0, 124, 0, 252, 0, 252, 0,
  252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0,
  124, 0, 124, 0, 124, 0, 124, 0, 60, 0, 60, 0, 30, 0, 30, 0,
  14, 0, 15, 0, 7, 0, 3, 128, 1, 192, 0, 224, 0, 112, 0, 56,
  0, 12, 13, 43, 86, 17, 1, 248, 192, 0, 224, 0, 48, 0, 24, 0,
  28, 0, 14, 0, 7, 0, 7, 128, 3, 128, 3, 192, 1, 224, 1, 224,
  1, 224, 1, 240, 1, 240, 1, 240, 1, 248, 1, 248, 1, 248, 1, 248,
  1, 248, 1, 248, 1, 248, 1, 248, 1, 248, 1, 248, 1, 248, 1, 240,
  1, 240, 1, 240, 1, 224, 1, 224, 3, 192, 3, 192, 3, 128, 7, 128,
  7, 0, 14, 0, 28, 0, 56, 0, 112, 0, 224, 0, 128, 0, 17, 19,
  57, 24, 4, 13, 1, 128, 0, 3, 192, 0, 3, 192, 0, 227, 195, 0,
  241, 135, 128, 248, 143, 128, 252, 159, 128, 126, 191, 0, 3, 192, 0, 3,
  192, 0, 126, 191, 0, 252, 159, 128, 248, 143, 128, 241, 135, 128, 225, 195,
  0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 1, 128, 0, 41, 41, 246,
  45, 2, 249, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0,
  0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0,
  0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28,
  0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0,
  0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0,
  0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28,
  0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0,
  0, 28, 0, 0, 0, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255, 255,
  128, 255, 255, 255, 255, 255, 128, 0, 0, 28, 0, 0, 0, 0, 0, 28,
  0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0,
  0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0,
  0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28,
  0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0,
  0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0,
  0, 0, 0, 28, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 28,
  0, 0, 0, 0, 0, 28, 0, 0, 0, 9, 15, 30, 13, 2, 248, 126,
  0, 255, 0, 255, 128, 255, 128, 255, 128, 127, 128, 1, 128, 1, 128, 1,
  128, 3, 0, 2, 0, 6, 0, 28, 0, 56, 0, 96, 0, 12, 5, 10,
  18, 3, 10, 255, 240, 255, 240, 255, 240, 255, 240, 255, 240, 8, 6, 6,
  14, 3, 1, 126, 255, 255, 255, 255, 126, 16, 44, 88, 22, 3, 247, 0,
  7, 0, 15, 0, 14, 0, 14, 0, 14, 0, 30, 0, 28, 0, 28, 0,
  60, 0, 56, 0, 56, 0, 120, 0, 112, 0, 112, 0, 240, 0, 224, 0,
  224, 0, 224, 1, 224, 1, 192, 1, 192, 3, 192, 3, 128, 3, 128, 7,
  128, 7, 0, 7, 0, 15, 0, 14, 0, 14, 0, 14, 0, 30, 0, 28,
  0, 28, 0, 60, 0, 56, 0, 56, 0, 120, 0, 112, 0, 112, 0, 240,
  0, 224, 0, 224, 0, 224, 0, 23, 35, 105, 28, 2, 0, 0, 16, 0,
  0, 254, 0, 3, 199, 128, 7, 131, 192, 15, 1, 224, 15, 1, 224, 31,
  1, 240, 63, 1, 248, 63, 1, 248, 127, 1, 248, 127, 1, 252, 127, 1,
  252, 127, 1, 252, 255, 1, 254, 255, 1, 254, 255, 1, 254, 255, 1, 254,
  255, 1, 254, 255, 1, 254, 255, 1, 254, 255, 1, 254, 255, 1, 254, 255,
  1, 254, 127, 1, 252, 127, 1, 252, 127, 1, 252, 127, 1, 252, 63, 1,
  248, 63, 1, 248, 31, 1, 240, 15, 1, 224, 15, 1, 224, 7, 131, 192,
  3, 199, 128, 0, 254, 0, 16, 34, 68, 28, 6, 0, 0, 240, 0, 240,
  1, 240, 7, 240, 255, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240,
  7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240,
  7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240,
  7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 255, 255, 255, 255,
  21, 34, 102, 28, 3, 1, 7, 255, 0, 14, 15, 192, 28, 7, 224, 56,
  7, 240, 120, 3, 240, 120, 3, 248, 248, 3, 248, 252, 3, 248, 255, 3,
  248, 255, 3, 248, 255, 7, 248, 127, 7, 240, 63, 15, 240, 12, 15, 224,
  0, 31, 192, 0, 63, 128, 0, 127, 0, 0, 252, 0, 1, 240, 0, 3,
  192, 0, 7, 128, 0, 14, 0, 24, 12, 0, 24, 24, 0, 24, 48, 0,
  24, 96, 0, 24, 111, 192, 56, 127, 255, 248, 255, 255, 240, 239, 255, 240,
  195, 255, 240, 193, 255, 224, 192, 255, 192, 192, 63, 128, 22, 34, 102, 28,
  3, 1, 7, 255, 0, 14, 15, 192, 28, 7, 224, 56, 7, 240, 120, 3,
  240, 124, 3, 248, 126, 3, 248, 127, 3, 248, 127, 3, 248, 127, 3, 248,
  63, 3, 240, 30, 3, 240, 0, 7, 224, 0, 7, 192, 0, 15, 0, 7,
  248, 0, 0, 31, 128, 0, 15, 192, 0, 7, 224, 0, 7, 240, 0, 3,
  248, 0, 3, 248, 62, 3, 252, 127, 3, 252, 255, 3, 252, 255, 3, 252,
  255, 3, 252, 254, 3, 252, 252, 3, 248, 248, 7, 248, 120, 7, 240, 56,
  15, 224, 30, 31, 192, 15, 255, 0, 23, 34, 102, 28, 2, 0, 0, 7,
  192, 0, 15, 192, 0, 15, 192, 0, 31, 192, 0, 63, 192, 0, 63, 192,
  0, 127, 192, 0, 127, 192, 0, 255, 192, 0, 223, 192, 1, 223, 192, 1,
  159, 192, 3, 159, 192, 7, 31, 192, 6, 31, 192, 14, 31, 192, 12, 31,
  192, 28, 31, 192, 24, 31, 192, 56, 31, 192, 112, 31, 192, 96, 31, 192,
  224, 31, 192, 255, 255, 254, 0, 31, 192, 0, 31, 192, 0, 31, 192, 0,
  31, 192, 0, 31, 192, 0, 31, 192, 0, 31, 192, 0, 31, 192, 7, 255,
  252, 7, 255, 252, 21, 34, 102, 28, 4, 0, 32, 0, 192, 60, 7, 128,
  63, 255, 128, 63, 255, 0, 63, 254, 0, 63, 248, 0, 63, 224, 0, 63,
  0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0,
  0, 49, 252, 0, 54, 63, 0, 60, 15, 192, 56, 15, 224, 48, 15, 224,
  32, 7, 240, 0, 7, 240, 0, 7, 248, 0, 7, 248, 8, 7, 248, 62,
  7, 248, 126, 7, 248, 254, 7, 248, 254, 7, 248, 254, 7, 240, 248, 7,
  240, 240, 7, 224, 112, 15, 192, 48, 15, 192, 28, 31, 0, 15, 252, 0,
  22, 34, 102, 28, 3, 1, 0, 255, 128, 3, 192, 192, 7, 192, 96, 15,
  128, 240, 31, 131, 240, 31, 7, 240, 63, 15, 240, 63, 15, 240, 127, 15,
  224, 127, 7, 192, 127, 3, 0, 127, 0, 0, 255, 0, 0, 255, 0, 0,
  255, 63, 0, 255, 255, 192, 255, 195, 224, 255, 131, 240, 255, 3, 248, 255,
  1, 248, 255, 1, 252, 255, 1, 252, 255, 1, 252, 127, 1, 252, 127, 1,
  252, 127, 1, 252, 127, 1, 252, 63, 1, 248, 63, 1, 248, 31, 1, 248,
  15, 129, 240, 7, 131, 224, 3, 195, 192, 1, 255, 0, 20, 34, 102, 28,
  5, 1, 71, 224, 224, 207, 240, 224, 223, 248, 112, 255, 252, 48, 255, 254,
  48, 255, 255, 240, 255, 255, 240, 224, 31, 176, 192, 0, 32, 192, 0, 96,
  128, 0, 96, 128, 0, 192, 128, 1, 192, 0, 1, 128, 0, 3, 128, 0,
  7, 0, 0, 15, 0, 0, 14, 0, 0, 30, 0, 0, 60, 0, 0, 124,
  0, 0, 252, 0, 1, 252, 0, 1, 248, 0, 3, 248, 0, 3, 248, 0,
  7, 248, 0, 7, 248, 0, 7, 248, 0, 7, 248, 0, 7, 248, 0, 7,
  248, 0, 3, 248, 0, 3, 240, 0, 23, 34, 102, 28, 3, 1, 1, 255,
  128, 7, 0, 192, 12, 0, 96, 28, 0, 48, 56, 0, 24, 56, 0, 24,
  120, 0, 24, 120, 0, 24, 124, 0, 24, 126, 0, 24, 127, 0, 48, 127,
  192, 32, 127, 240, 96, 63, 255, 128, 63, 255, 0, 31, 255, 192, 15, 255,
  240, 7, 255, 248, 15, 255, 248, 24, 63, 252, 48, 15, 252, 112, 3, 254,
  96, 0, 254, 224, 0, 126, 224, 0, 62, 224, 0, 30, 224, 0, 30, 224,
  0, 12, 240, 0, 28, 112, 0, 24, 56, 0, 24, 28, 0, 48, 15, 0,
  192, 3, 255, 0, 22, 34, 102, 28, 3, 1, 3, 254, 0, 15, 15, 0,
  31, 7, 128, 62, 7, 192, 126, 3, 224, 126, 3, 240, 126, 3, 240, 254,
  3, 248, 254, 3, 248, 254, 3, 248, 254, 3, 248, 254, 3, 252, 254, 3,
  252, 254, 3, 252, 126, 3, 252, 127, 7, 252, 63, 7, 252, 31, 15, 252,
  15, 255, 252, 3, 243, 252, 0, 3, 252, 0, 3, 252, 0, 3, 248, 7,
  3, 248, 31, 131, 248, 31, 195, 248, 63, 195, 240, 63, 195, 240, 63, 131,
  224, 62, 7, 224, 60, 7, 192, 28, 15, 128, 14, 31, 0, 7, 252, 0,
  8, 22, 22, 14, 3, 1, 126, 255, 255, 255, 255, 126, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 126, 255, 255, 255, 255, 126, 9, 32, 64, 13,
  2, 247, 63, 0, 127, 128, 127, 128, 127, 128, 127, 128, 63, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 60, 0, 127, 0, 255, 0, 255, 128, 255, 128, 255, 128, 57, 128,
  1, 128, 1, 128, 3, 0, 3, 0, 6, 0, 12, 0, 56, 0, 240, 0,
  64, 0, 37, 40, 200, 45, 4, 249, 0, 0, 0, 0, 48, 0, 0, 0,
  0, 240, 0, 0, 0, 1, 248, 0, 0, 0, 7, 224, 0, 0, 0, 31,
  128, 0, 0, 0, 126, 0, 0, 0, 1, 252, 0, 0, 0, 7, 240, 0,
  0, 0, 15, 192, 0, 0, 0, 63, 0, 0, 0, 0, 252, 0, 0, 0,
  3, 240, 0, 0, 0, 15, 224, 0, 0, 0, 63, 128, 0, 0, 0, 126,
  0, 0, 0, 1, 248, 0, 0, 0, 7, 224, 0, 0, 0, 31, 128, 0,
  0, 0, 127, 0, 0, 0, 0, 252, 0, 0, 0, 0, 248, 0, 0, 0,
  0, 126, 0, 0, 0, 0, 31, 128, 0, 0, 0, 15, 224, 0, 0, 0,
  3, 248, 0, 0, 0, 0, 252, 0, 0, 0, 0, 63, 0, 0, 0, 0,
  15, 192, 0, 0, 0, 3, 240, 0, 0, 0, 1, 252, 0, 0, 0, 0,
  127, 0, 0, 0, 0, 31, 192, 0, 0, 0, 7, 224, 0, 0, 0, 1,
  248, 0, 0, 0, 0, 126, 0, 0, 0, 0, 63, 128, 0, 0, 0, 15,
  224, 0, 0, 0, 3, 248, 0, 0, 0, 0, 248, 0, 0, 0, 0, 48,
  41, 13, 78, 45, 2, 6, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255,
  255, 128, 255, 255, 255, 255, 255, 128, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255, 255, 128, 255, 255,
  255, 255, 255, 128, 37, 40, 200, 45, 4, 249, 96, 0, 0, 0, 0, 120,
  0, 0, 0, 0, 252, 0, 0, 0, 0, 63, 0, 0, 0, 0, 15, 192,
  0, 0, 0, 3, 240, 0, 0, 0, 1, 252, 0, 0, 0, 0, 127, 0,
  0, 0, 0, 31, 128, 0, 0, 0, 7, 224, 0, 0, 0, 1, 248, 0,
  0, 0, 0, 126, 0, 0, 0, 0, 63, 128, 0, 0, 0, 15, 224, 0,
  0, 0, 3, 240, 0, 0, 0, 0, 252, 0, 0, 0, 0, 63, 0, 0,
  0, 0, 15, 192, 0, 0, 0, 7, 240, 0, 0, 0, 1, 248, 0, 0,
  0, 0, 248, 0, 0, 0, 3, 240, 0, 0, 0, 15, 192, 0, 0, 0,
  63, 128, 0, 0, 0, 254, 0, 0, 0, 1, 248, 0, 0, 0, 7, 224,
  0, 0, 0, 31, 128, 0, 0, 0, 126, 0, 0, 0, 1, 252, 0, 0,
  0, 7, 240, 0, 0, 0, 31, 192, 0, 0, 0, 63, 0, 0, 0, 0,
  252, 0, 0, 0, 3, 240, 0, 0, 0, 15, 224, 0, 0, 0, 63, 128,
  0, 0, 0, 254, 0, 0, 0, 0, 248, 0, 0, 0, 0, 96, 0, 0,
  0, 0, 15, 34, 68, 22, 3, 1, 31, 240, 59, 248, 96, 252, 96, 252,
  192, 126, 192, 126, 192, 126, 192, 126, 192, 126, 64, 252, 96, 252, 48, 248,
  1, 240, 1, 224, 3, 192, 3, 128, 7, 0, 7, 0, 14, 0, 12, 16,
  12, 16, 12, 16, 12, 16, 6, 32, 3, 192, 0, 0, 0, 0, 0, 128,
  3, 224, 7, 240, 7, 240, 7, 240, 7, 240, 3, 224, 35, 34, 170, 39,
  2, 1, 0, 15, 255, 0, 0, 0, 56, 1, 224, 0, 0, 224, 0, 112,
  0, 1, 128, 0, 28, 0, 7, 0, 0, 14, 0, 14, 0, 0, 7, 0,
  12, 0, 248, 3, 0, 28, 3, 205, 243, 128, 56, 7, 135, 241, 128, 56,
  15, 7, 225, 192, 112, 31, 7, 225, 192, 112, 62, 7, 224, 224, 112, 62,
  7, 224, 224, 224, 124, 7, 192, 224, 224, 124, 7, 192, 224, 224, 124, 7,
  192, 224, 224, 252, 15, 192, 224, 224, 248, 15, 128, 224, 224, 248, 15, 128,
  224, 224, 248, 15, 129, 192, 224, 248, 31, 129, 192, 224, 248, 31, 129, 128,
  112, 248, 31, 3, 128, 112, 248, 63, 3, 0, 112, 120, 111, 6, 0, 56,
  60, 199, 140, 0, 56, 31, 3, 240, 0, 28, 0, 0, 0, 0, 14, 0,
  0, 0, 0, 7, 0, 0, 0, 0, 3, 128, 0, 0, 0, 1, 192, 0,
  96, 0, 0, 120, 1, 192, 0, 0, 31, 255, 0, 0, 33, 35, 175, 36,
  2, 0, 0, 0, 192, 0, 0, 0, 1, 192, 0, 0, 0, 1, 224, 0,
  0, 0, 1, 224, 0, 0, 0, 3, 224, 0, 0, 0, 3, 240, 0, 0,
  0, 3, 240, 0, 0, 0, 7, 240, 0, 0, 0, 7, 248, 0, 0, 0,
  7, 248, 0, 0, 0, 15, 248, 0, 0, 0, 15, 252, 0, 0, 0, 15,
  252, 0, 0, 0, 25, 252, 0, 0, 0, 25, 254, 0, 0, 0, 25, 254,
  0, 0, 0, 48, 254, 0, 0, 0, 48, 255, 0, 0, 0, 32, 255, 0,
  0, 0, 96, 127, 0, 0, 0, 96, 127, 128, 0, 0, 64, 127, 128, 0,
  0, 192, 63, 128, 0, 0, 192, 63, 192, 0, 0, 255, 255, 192, 0, 1,
  255, 255, 192, 0, 1, 128, 31, 224, 0, 1, 0, 31, 224, 0, 3, 0,
  15, 224, 0, 3, 0, 15, 240, 0, 2, 0, 15, 240, 0, 6, 0, 7,
  240, 0, 15, 0, 7, 248, 0, 31, 0, 15, 252, 0, 255, 240, 255, 255,
  128, 28, 34, 136, 33, 3, 0, 255, 255, 240, 0, 15, 224, 126, 0, 15,
  224, 31, 0, 15, 224, 31, 128, 15, 224, 15, 192, 15, 224, 15, 192, 15,
  224, 15, 224, 15, 224, 15, 224, 15, 224, 15, 224, 15, 224, 15, 224, 15,
  224, 15, 224, 15, 224, 15, 192, 15, 224, 15, 192, 15, 224, 31, 128, 15,
  224, 30, 0, 15, 224, 60, 0, 15, 255, 224, 0, 15, 224, 124, 0, 15,
  224, 63, 0, 15, 224, 31, 128, 15, 224, 15, 192, 15, 224, 15, 224, 15,
  224, 15, 240, 15, 224, 15, 240, 15, 224, 15, 240, 15, 224, 15, 240, 15,
  224, 15, 240, 15, 224, 15, 240, 15, 224, 15, 224, 15, 224, 15, 224, 15,
  224, 31, 192, 15, 224, 31, 128, 15, 224, 126, 0, 255, 255, 248, 0, 26,
  34, 136, 31, 3, 1, 0, 127, 193, 128, 1, 224, 241, 128, 3, 192, 63,
  128, 15, 128, 31, 128, 15, 128, 15, 128, 31, 0, 15, 128, 63, 0, 7,
  128, 63, 0, 7, 128, 127, 0, 3, 128, 127, 0, 3, 128, 127, 0, 3,
  128, 127, 0, 1, 128, 255, 0, 1, 128, 255, 0, 1, 128, 255, 0, 1,
  128, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0,
  0, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 192, 127, 0, 0,
  192, 127, 0, 0, 192, 127, 0, 0, 128, 63, 0, 1, 128, 63, 0, 1,
  128, 63, 0, 1, 128, 31, 128, 3, 0, 15, 128, 3, 0, 7, 128, 6,
  0, 3, 192, 12, 0, 1, 224, 56, 0, 0, 127, 224, 0, 32, 34, 136,
  37, 3, 0, 255, 255, 248, 0, 15, 224, 31, 0, 15, 224, 7, 128, 15,
  224, 3, 224, 15, 224, 1, 240, 15, 224, 1, 240, 15, 224, 0, 248, 15,
  224, 0, 252, 15, 224, 0, 252, 15, 224, 0, 254, 15, 224, 0, 254, 15,
  224, 0, 254, 15, 224, 0, 255, 15, 224, 0, 255, 15, 224, 0, 255, 15,
  224, 0, 255, 15, 224, 0, 255, 15, 224, 0, 255, 15, 224, 0, 255, 15,
  224, 0, 255, 15, 224, 0, 255, 15, 224, 0, 254, 15, 224, 0, 254, 15,
  224, 0, 254, 15, 224, 0, 254, 15, 224, 0, 252, 15, 224, 0, 252, 15,
  224, 0, 248, 15, 224, 1, 240, 15, 224, 1, 224, 15, 224, 3, 192, 15,
  224, 7, 128, 15, 224, 30, 0, 255, 255, 248, 0, 27, 34, 136, 33, 3,
  0, 255, 255, 255, 224, 15, 224, 31, 224, 15, 224, 7, 224, 15, 224, 3,
  224, 15, 224, 1, 224, 15, 224, 1, 224, 15, 224, 0, 224, 15, 224, 0,
  224, 15, 224, 0, 96, 15, 224, 48, 96, 15, 224, 48, 96, 15, 224, 48,
  0, 15, 224, 112, 0, 15, 224, 112, 0, 15, 224, 240, 0, 15, 225, 240,
  0, 15, 255, 240, 0, 15, 225, 240, 0, 15, 224, 240, 0, 15, 224, 112,
  0, 15, 224, 112, 32, 15, 224, 48, 96, 15, 224, 48, 96, 15, 224, 48,
  96, 15, 224, 0, 96, 15, 224, 0, 96, 15, 224, 0, 224, 15, 224, 0,
  224, 15, 224, 1, 224, 15, 224, 3, 224, 15, 224, 3, 224, 15, 224, 15,
  224, 255, 255, 255, 224, 255, 255, 255, 224, 28, 34, 136, 32, 3, 0, 255,
  255, 255, 240, 7, 240, 15, 240, 7, 240, 3, 240, 7, 240, 1, 240, 7,
  240, 1, 240, 7, 240, 0, 240, 7, 240, 0, 240, 7, 240, 0, 112, 7,
  240, 0, 112, 7, 240, 24, 48, 7, 240, 24, 48, 7, 240, 24, 48, 7,
  240, 56, 48, 7, 240, 56, 0, 7, 240, 120, 0, 7, 240, 248, 0, 7,
  255, 248, 0, 7, 240, 248, 0, 7, 240, 120, 0, 7, 240, 56, 0, 7,
  240, 56, 0, 7, 240, 24, 0, 7, 240, 24, 0, 7, 240, 24, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 255, 255, 128, 0, 30, 34, 136, 35, 3, 1, 0, 127, 224,
  192, 0, 224, 120, 192, 3, 192, 31, 192, 7, 128, 15, 192, 15, 128, 7,
  192, 31, 0, 7, 192, 31, 0, 3, 192, 63, 0, 3, 192, 63, 0, 1,
  192, 127, 0, 1, 192, 127, 0, 1, 192, 127, 0, 0, 192, 255, 0, 0,
  192, 255, 0, 0, 192, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0,
  0, 255, 3, 255, 252, 255, 3, 255, 252, 255, 0, 31, 192, 255, 0, 31,
  192, 255, 0, 31, 192, 127, 0, 31, 192, 127, 0, 31, 192, 127, 0, 31,
  192, 127, 0, 31, 192, 63, 0, 31, 192, 63, 0, 31, 192, 31, 0, 31,
  192, 15, 128, 57, 192, 15, 128, 49, 192, 7, 192, 96, 192, 1, 224, 192,
  192, 0, 127, 128, 192, 34, 34, 170, 39, 3, 0, 255, 255, 63, 255, 192,
  7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7,
  240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240,
  1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1,
  252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252,
  0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 255, 255, 252, 0,
  7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7,
  240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240,
  1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1,
  252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252,
  0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0, 7, 240, 1, 252, 0,
  255, 255, 63, 255, 192, 16, 34, 68, 21, 3, 0, 255, 255, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7,
  240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 7, 240, 255, 255, 23,
  34, 102, 26, 2, 0, 1, 255, 254, 0, 15, 224, 0, 15, 224, 0, 15,
  224, 0, 15, 224, 0, 15, 224, 0, 15, 224, 0, 15, 224, 0, 15, 224,
  0, 15, 224, 0, 15, 224, 0, 15, 224, 0, 15, 224, 0, 15, 224, 0,
  15, 224, 0, 15, 224, 0, 15, 224, 0, 15, 224, 0, 15, 224, 0, 15,
  224, 0, 15, 224, 30, 15, 224, 126, 15, 224, 127, 15, 224, 255, 15, 224,
  255, 15, 224, 254, 15, 224, 254, 15, 224, 248, 15, 192, 112, 15, 192, 96,
  15, 128, 48, 31, 0, 24, 30, 0, 15, 248, 0, 33, 34, 170, 37, 3,
  0, 255, 255, 31, 254, 0, 7, 240, 7, 240, 0, 7, 240, 3, 192, 0,
  7, 240, 3, 128, 0, 7, 240, 3, 0, 0, 7, 240, 7, 0, 0, 7,
  240, 14, 0, 0, 7, 240, 12, 0, 0, 7, 240, 24, 0, 0, 7, 240,
  48, 0, 0, 7, 240, 96, 0, 0, 7, 240, 224, 0, 0, 7, 240, 224,
  0, 0, 7, 241, 240, 0, 0, 7, 243, 240, 0, 0, 7, 247, 248, 0,
  0, 7, 255, 252, 0, 0, 7, 255, 252, 0, 0, 7, 249, 254, 0, 0,
  7, 241, 254, 0, 0, 7, 240, 255, 0, 0, 7, 240, 255, 0, 0, 7,
  240, 127, 128, 0, 7, 240, 127, 128, 0, 7, 240, 63, 192, 0, 7, 240,
  63, 192, 0, 7, 240, 31, 224, 0, 7, 240, 31, 224, 0, 7, 240, 15,
  240, 0, 7, 240, 15, 240, 0, 7, 240, 7, 248, 0, 7, 240, 7, 248,
  0, 7, 240, 7, 252, 0, 255, 255, 63, 255, 128, 28, 34, 136, 32, 3,
  0, 255, 255, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0,
  0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0,
  0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0,
  0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0,
  0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0,
  48, 7, 240, 0, 48, 7, 240, 0, 48, 7, 240, 0, 112, 7, 240, 0,
  112, 7, 240, 0, 112, 7, 240, 0, 240, 7, 240, 0, 240, 7, 240, 0,
  240, 7, 240, 1, 240, 7, 240, 3, 240, 7, 240, 3, 240, 7, 240, 7,
  240, 255, 255, 255, 240, 255, 255, 255, 240, 39, 34, 170, 43, 2, 0, 255,
  240, 0, 63, 254, 7, 240, 0, 63, 192, 7, 248, 0, 63, 192, 7, 248,
  0, 63, 192, 7, 248, 0, 127, 192, 7, 252, 0, 127, 192, 7, 252, 0,
  95, 192, 7, 252, 0, 95, 192, 7, 254, 0, 223, 192, 6, 254, 0, 223,
  192, 6, 255, 0, 159, 192, 6, 127, 0, 159, 192, 6, 127, 1, 159, 192,
  6, 127, 129, 159, 192, 6, 63, 129, 31, 192, 6, 63, 129, 31, 192, 6,
  63, 195, 31, 192, 6, 31, 194, 31, 192, 6, 31, 226, 31, 192, 6, 15,
  226, 31, 192, 6, 15, 230, 31, 192, 6, 15, 244, 31, 192, 6, 7, 244,
  31, 192, 6, 7, 244, 31, 192, 6, 7, 252, 31, 192, 6, 3, 248, 31,
  192, 6, 3, 248, 31, 192, 6, 1, 248, 31, 192, 6, 1, 248, 31, 192,
  6, 1, 240, 31, 192, 6, 0, 240, 31, 192, 15, 0, 240, 31, 192, 63,
  192, 240, 31, 192, 255, 240, 97, 255, 254, 34, 35, 175, 37, 2, 255, 255,
  224, 15, 255, 192, 31, 240, 3, 255, 0, 15, 240, 0, 252, 0, 15, 248,
  0, 120, 0, 7, 252, 0, 48, 0, 3, 254, 0, 48, 0, 3, 254, 0,
  48, 0, 3, 255, 0, 48, 0, 3, 255, 128, 48, 0, 3, 255, 128, 48,
  0, 3, 127, 192, 48, 0, 3, 63, 224, 48, 0, 3, 31, 224, 48, 0,
  3, 31, 240, 48, 0, 3, 15, 248, 48, 0, 3, 7, 248, 48, 0, 3,
  7, 252, 48, 0, 3, 3, 254, 48, 0, 3, 1, 255, 48, 0, 3, 1,
  255, 48, 0, 3, 0, 255, 176, 0, 3, 0, 127, 240, 0, 3, 0, 127,
  240, 0, 3, 0, 63, 240, 0, 3, 0, 31, 240, 0, 3, 0, 15, 240,
  0, 3, 0, 15, 240, 0, 3, 0, 7, 240, 0, 3, 0, 3, 240, 0,
  3, 0, 3, 240, 0, 7, 128, 1, 240, 0, 15, 192, 0, 240, 0, 63,
  240, 0, 240, 0, 255, 252, 0, 112, 0, 0, 0, 0, 48, 0, 28, 34,
  136, 33, 3, 1, 0, 63, 192, 0, 0, 224, 112, 0, 3, 192, 56, 0,
  7, 128, 30, 0, 15, 128, 30, 0, 15, 0, 15, 0, 31, 0, 15, 128,
  63, 0, 15, 192, 63, 0, 15, 192, 127, 0, 15, 192, 127, 0, 15, 224,
  127, 0, 15, 224, 127, 0, 15, 224, 255, 0, 15, 240, 255, 0, 15, 240,
  255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240,
  255, 0, 15, 240, 255, 0, 15, 240, 127, 0, 15, 224, 127, 0, 15, 224,
  127, 0, 15, 224, 127, 0, 15, 192, 63, 0, 15, 192, 63, 0, 15, 192,
  31, 0, 15, 128, 15, 0, 15, 0, 15, 128, 31, 0, 7, 128, 30, 0,
  3, 192, 60, 0, 0, 224, 112, 0, 0, 63, 192, 0, 29, 34, 136, 34,
  3, 0, 255, 255, 248, 0, 7, 240, 63, 0, 7, 240, 15, 192, 7, 240,
  15, 224, 7, 240, 15, 240, 7, 240, 7, 240, 7, 240, 7, 248, 7, 240,
  7, 248, 7, 240, 7, 248, 7, 240, 7, 248, 7, 240, 7, 248, 7, 240,
  7, 248, 7, 240, 7, 240, 7, 240, 15, 240, 7, 240, 15, 224, 7, 240,
  15, 192, 7, 240, 31, 0, 7, 255, 252, 0, 7, 240, 0, 0, 7, 240,
  0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240,
  0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240,
  0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240,
  0, 0, 7, 240, 0, 0, 255, 255, 128, 0, 28, 45, 180, 33, 3, 246,
  0, 63, 192, 0, 0, 224, 112, 0, 3, 192, 56, 0, 7, 128, 30, 0,
  15, 128, 30, 0, 15, 0, 15, 0, 31, 0, 15, 128, 63, 0, 15, 128,
  63, 0, 15, 192, 127, 0, 15, 192, 127, 0, 15, 224, 127, 0, 15, 224,
  127, 0, 15, 224, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240,
  255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240, 255, 0, 15, 240,
  255, 0, 15, 240, 255, 0, 15, 240, 127, 0, 15, 224, 127, 0, 15, 224,
  127, 0, 15, 224, 63, 0, 15, 192, 63, 15, 15, 192, 31, 17, 143, 128,
  15, 160, 223, 0, 15, 160, 223, 0, 7, 160, 254, 0, 3, 224, 252, 16,
  0, 240, 248, 16, 0, 127, 224, 16, 0, 0, 224, 16, 0, 0, 224, 16,
  0, 0, 224, 48, 0, 0, 240, 48, 0, 0, 248, 112, 0, 0, 255, 240,
  0, 0, 255, 224, 0, 0, 127, 224, 0, 0, 127, 192, 0, 0, 63, 128,
  0, 0, 31, 0, 32, 36, 144, 36, 3, 254, 255, 255, 240, 0, 7, 240,
  126, 0, 7, 240, 63, 0, 7, 240, 63, 128, 7, 240, 31, 192, 7, 240,
  31, 192, 7, 240, 31, 224, 7, 240, 31, 224, 7, 240, 31, 224, 7, 240,
  31, 224, 7, 240, 31, 224, 7, 240, 31, 192, 7, 240, 63, 192, 7, 240,
  63, 0, 7, 240, 126, 0, 7, 255, 240, 0, 7, 240, 240, 0, 7, 240,
  62, 0, 7, 240, 63, 0, 7, 240, 31, 128, 7, 240, 31, 128, 7, 240,
  31, 192, 7, 240, 31, 192, 7, 240, 31, 192, 7, 240, 31, 192, 7, 240,
  31, 195, 7, 240, 31, 195, 7, 240, 31, 195, 7, 240, 31, 195, 7, 240,
  31, 195, 7, 240, 31, 198, 7, 240, 31, 198, 7, 240, 15, 238, 255, 255,
  135, 252, 0, 0, 3, 248, 0, 0, 0, 96, 23, 34, 102, 29, 4, 1,
  7, 252, 24, 24, 15, 24, 56, 3, 248, 112, 1, 248, 112, 0, 248, 240,
  0, 120, 248, 0, 120, 248, 0, 56, 252, 0, 24, 254, 0, 24, 255, 128,
  24, 255, 224, 8, 127, 240, 0, 127, 252, 0, 63, 254, 0, 31, 255, 128,
  15, 255, 192, 3, 255, 240, 1, 255, 248, 128, 127, 248, 192, 31, 252, 192,
  15, 252, 192, 3, 254, 224, 1, 254, 224, 0, 126, 224, 0, 62, 240, 0,
  30, 248, 0, 30, 248, 0, 28, 252, 0, 28, 254, 0, 24, 239, 0, 48,
  195, 128, 96, 193, 255, 128, 29, 34, 136, 34, 3, 0, 255, 255, 255, 248,
  255, 63, 231, 248, 252, 31, 193, 248, 248, 31, 192, 248, 248, 31, 192, 248,
  240, 31, 192, 120, 224, 31, 192, 56, 224, 31, 192, 56, 224, 31, 192, 56,
  192, 31, 192, 24, 192, 31, 192, 24, 192, 31, 192, 24, 192, 31, 192, 24,
  128, 31, 192, 8, 0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0,
  0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0,
  0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0,
  0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0,
  0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0, 0, 31, 192, 0,
  3, 255, 254, 0, 33, 34, 170, 38, 3, 0, 255, 255, 7, 255, 128, 15,
  224, 1, 254, 0, 15, 224, 0, 120, 0, 15, 224, 0, 48, 0, 15, 224,
  0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0,
  48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48,
  0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0,
  15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15,
  224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224,
  0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 15, 224, 0,
  48, 0, 15, 224, 0, 48, 0, 15, 224, 0, 48, 0, 7, 224, 0, 48,
  0, 7, 224, 0, 96, 0, 7, 240, 0, 96, 0, 3, 240, 0, 192, 0,
  1, 248, 1, 192, 0, 0, 252, 3, 128, 0, 0, 127, 159, 0, 0, 0,
  31, 252, 0, 0, 34, 34, 170, 37, 2, 0, 255, 255, 135, 255, 192, 15,
  248, 0, 126, 0, 7, 248, 0, 56, 0, 7, 248, 0, 56, 0, 3, 248,
  0, 48, 0, 3, 252, 0, 48, 0, 3, 252, 0, 48, 0, 1, 254, 0,
  96, 0, 1, 254, 0, 96, 0, 0, 254, 0, 96, 0, 0, 255, 0, 192,
  0, 0, 255, 0, 192, 0, 0, 127, 0, 192, 0, 0, 127, 129, 128, 0,
  0, 127, 129, 128, 0, 0, 63, 129, 128, 0, 0, 63, 195, 0, 0, 0,
  63, 195, 0, 0, 0, 31, 195, 0, 0, 0, 31, 230, 0, 0, 0, 15,
  230, 0, 0, 0, 15, 246, 0, 0, 0, 15, 252, 0, 0, 0, 7, 252,
  0, 0, 0, 7, 252, 0, 0, 0, 7, 248, 0, 0, 0, 3, 248, 0,
  0, 0, 3, 248, 0, 0, 0, 3, 240, 0, 0, 0, 1, 240, 0, 0,
  0, 1, 240, 0, 0, 0, 0, 224, 0, 0, 0, 0, 224, 0, 0, 0,
  0, 224, 0, 0, 49, 34, 238, 52, 2, 0, 255, 255, 63, 255, 207, 255,
  128, 31, 252, 7, 254, 0, 252, 0, 7, 248, 3, 252, 0, 112, 0, 7,
  248, 1, 252, 0, 112, 0, 3, 248, 1, 254, 0, 96, 0, 3, 252, 1,
  254, 0, 96, 0, 3, 252, 0, 254, 0, 96, 0, 1, 252, 0, 254, 0,
  192, 0, 1, 254, 1, 255, 0, 192, 0, 1, 254, 1, 255, 0, 192, 0,
  0, 254, 1, 255, 1, 128, 0, 0, 255, 3, 127, 129, 128, 0, 0, 255,
  3, 63, 129, 128, 0, 0, 127, 3, 63, 129, 128, 0, 0, 127, 135, 63,
  195, 0, 0, 0, 127, 134, 31, 195, 0, 0, 0, 63, 134, 31, 195, 0,
  0, 0, 63, 198, 31, 231, 0, 0, 0, 31, 204, 15, 230, 0, 0, 0,
  31, 204, 15, 230, 0, 0, 0, 31, 236, 15, 246, 0, 0, 0, 15, 248,
  7, 252, 0, 0, 0, 15, 248, 7, 252, 0, 0, 0, 15, 248, 7, 252,
  0, 0, 0, 7, 248, 3, 252, 0, 0, 0, 7, 240, 3, 248, 0, 0,
  0, 7, 240, 3, 248, 0, 0, 0, 3, 240, 1, 248, 0, 0, 0, 3,
  224, 1, 240, 0, 0, 0, 3, 224, 1, 240, 0, 0, 0, 1, 224, 0,
  240, 0, 0, 0, 1, 192, 0, 240, 0, 0, 0, 1, 192, 0, 224, 0,
  0, 0, 0, 192, 0, 96, 0, 0, 33, 34, 170, 36, 2, 0, 127, 255,
  31, 254, 0, 31, 252, 3, 240, 0, 7, 248, 3, 192, 0, 3, 248, 3,
  128, 0, 3, 252, 3, 128, 0, 1, 252, 3, 0, 0, 1, 254, 7, 0,
  0, 0, 255, 6, 0, 0, 0, 255, 12, 0, 0, 0, 127, 140, 0, 0,
  0, 127, 152, 0, 0, 0, 63, 240, 0, 0, 0, 63, 240, 0, 0, 0,
  31, 224, 0, 0, 0, 31, 224, 0, 0, 0, 15, 240, 0, 0, 0, 15,
  248, 0, 0, 0, 7, 248, 0, 0, 0, 7, 252, 0, 0, 0, 7, 252,
  0, 0, 0, 15, 254, 0, 0, 0, 29, 254, 0, 0, 0, 24, 255, 0,
  0, 0, 56, 255, 0, 0, 0, 48, 127, 128, 0, 0, 96, 127, 128, 0,
  0, 224, 63, 192, 0, 0, 192, 63, 224, 0, 1, 128, 31, 224, 0, 3,
  128, 31, 240, 0, 3, 128, 15, 240, 0, 7, 128, 15, 248, 0, 31, 128,
  31, 252, 0, 255, 240, 127, 255, 128, 32, 34, 136, 35, 2, 0, 255, 254,
  15, 255, 31, 248, 1, 248, 15, 248, 0, 240, 7, 248, 0, 224, 7, 248,
  0, 192, 3, 252, 0, 192, 3, 252, 0, 192, 1, 252, 1, 128, 1, 254,
  1, 128, 0, 254, 3, 0, 0, 255, 3, 0, 0, 255, 3, 0, 0, 127,
  134, 0, 0, 127, 134, 0, 0, 63, 196, 0, 0, 63, 204, 0, 0, 31,
  204, 0, 0, 31, 248, 0, 0, 15, 248, 0, 0, 15, 248, 0, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7, 240, 0, 0, 7,
  240, 0, 0, 255, 255, 0, 25, 34, 136, 31, 3, 0, 127, 255, 255, 128,
  127, 128, 127, 128, 126, 0, 255, 0, 124, 0, 255, 0, 120, 1, 254, 0,
  120, 3, 254, 0, 112, 3, 252, 0, 112, 7, 252, 0, 96, 7, 248, 0,
  96, 15, 248, 0, 96, 15, 240, 0, 64, 31, 224, 0, 0, 31, 224, 0,
  0, 63, 192, 0, 0, 63, 192, 0, 0, 127, 128, 0, 0, 127, 128, 0,
  0, 255, 0, 0, 0, 255, 0, 0, 1, 254, 0, 0, 3, 254, 0, 128,
  3, 252, 0, 128, 7, 248, 0, 128, 7, 248, 0, 128, 15, 240, 1, 128,
  15, 240, 1, 128, 31, 224, 3, 128, 31, 224, 3, 128, 63, 192, 7, 128,
  63, 192, 15, 128, 127, 128, 31, 128, 127, 128, 63, 128, 255, 255, 255, 128,
  255, 255, 255, 128, 11, 42, 84, 18, 4, 248, 255, 224, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0,
  248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 248, 0, 255, 224, 16, 44,
  88, 22, 3, 247, 224, 0, 224, 0, 224, 0, 240, 0, 112, 0, 112, 0,
  120, 0, 56, 0, 56, 0, 60, 0, 28, 0, 28, 0, 30, 0, 14, 0,
  14, 0, 14, 0, 15, 0, 7, 0, 7, 0, 7, 128, 3, 128, 3, 128,
  3, 192, 1, 192, 1, 192, 1, 224, 0, 224, 0, 224, 0, 224, 0, 240,
  0, 112, 0, 112, 0, 120, 0, 56, 0, 56, 0, 60, 0, 28, 0, 28,
  0, 30, 0, 14, 0, 14, 0, 14, 0, 15, 0, 7, 11, 42, 84, 18,
  3, 248, 255, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224, 3, 224,
  3, 224, 3, 224, 255, 224, 22, 17, 51, 28, 3, 18, 0, 48, 0, 0,
  112, 0, 0, 120, 0, 0, 252, 0, 0, 252, 0, 1, 254, 0, 3, 207,
  0, 3, 143, 0, 7, 135, 128, 15, 3, 128, 15, 3, 192, 30, 1, 224,
  60, 0, 224, 60, 0, 240, 120, 0, 120, 112, 0, 56, 240, 0, 60, 25,
  3, 12, 25, 0, 248, 255, 255, 255, 128, 255, 255, 255, 128, 255, 255, 255,
  128, 8, 9, 9, 21, 4, 25, 96, 240, 248, 124, 60, 30, 15, 3, 1,
  21, 22, 66, 24, 2, 1, 15, 248, 0, 24, 62, 0, 56, 63, 0, 120,
  31, 0, 124, 31, 128, 126, 31, 128, 126, 31, 128, 62, 31, 128, 8, 63,
  128, 1, 255, 128, 7, 159, 128, 30, 31, 128, 62, 31, 128, 124, 31, 128,
  124, 31, 128, 252, 31, 128, 252, 31, 136, 252, 31, 136, 252, 31, 152, 254,
  63, 144, 127, 127, 240, 63, 143, 224, 22, 34, 102, 25, 1, 0, 255, 128,
  0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0,
  31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31,
  128, 0, 31, 159, 128, 31, 179, 224, 31, 225, 224, 31, 193, 240, 31, 193,
  248, 31, 192, 248, 31, 192, 248, 31, 128, 252, 31, 128, 252, 31, 128, 252,
  31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31,
  128, 248, 31, 192, 248, 31, 193, 248, 29, 193, 240, 24, 225, 224, 24, 99,
  192, 16, 63, 128, 18, 22, 66, 22, 2, 1, 3, 252, 0, 15, 6, 0,
  31, 3, 0, 62, 3, 128, 62, 7, 128, 126, 15, 128, 124, 31, 128, 252,
  31, 128, 252, 31, 0, 252, 14, 0, 252, 0, 0, 252, 0, 0, 252, 0,
  0, 252, 0, 0, 252, 0, 0, 124, 0, 64, 124, 0, 192, 62, 0, 128,
  62, 0, 128, 30, 1, 0, 15, 130, 0, 3, 252, 0, 23, 34, 102, 26,
  2, 0, 0, 63, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 7,
  224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224,
  0, 7, 224, 0, 7, 224, 7, 231, 224, 31, 23, 224, 30, 31, 224, 62,
  15, 224, 126, 15, 224, 124, 15, 224, 124, 7, 224, 252, 7, 224, 252, 7,
  224, 252, 7, 224, 252, 7, 224, 252, 7, 224, 252, 7, 224, 252, 7, 224,
  252, 7, 224, 124, 7, 224, 124, 15, 224, 126, 15, 224, 62, 15, 224, 30,
  31, 224, 15, 23, 224, 7, 231, 254, 18, 22, 66, 23, 2, 1, 3, 252,
  0, 14, 30, 0, 30, 31, 0, 62, 15, 128, 60, 15, 128, 124, 15, 128,
  124, 15, 192, 252, 15, 192, 252, 15, 192, 252, 15, 192, 255, 255, 192, 252,
  0, 0, 252, 0, 0, 252, 0, 0, 252, 0, 64, 124, 0, 64, 124, 0,
  192, 62, 0, 192, 62, 0, 128, 31, 1, 0, 15, 131, 0, 3, 252, 0,
  18, 34, 102, 16, 1, 1, 0, 255, 0, 1, 199, 128, 7, 199, 128, 7,
  199, 192, 15, 143, 192, 15, 143, 192, 31, 143, 192, 31, 143, 128, 31, 135,
  128, 31, 128, 0, 31, 128, 0, 31, 128, 0, 255, 240, 0, 31, 128, 0,
  31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31,
  128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128,
  0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0,
  31, 128, 0, 31, 128, 0, 31, 128, 0, 255, 240, 0, 24, 33, 99, 27,
  2, 246, 7, 254, 62, 31, 15, 71, 63, 7, 143, 62, 7, 207, 126, 7,
  238, 126, 7, 228, 126, 7, 224, 126, 7, 224, 126, 7, 224, 62, 7, 192,
  31, 15, 128, 15, 15, 0, 3, 252, 0, 12, 0, 0, 48, 0, 0, 48,
  0, 0, 112, 0, 0, 112, 0, 0, 127, 255, 128, 127, 255, 224, 63, 255,
  240, 31, 255, 240, 7, 255, 248, 60, 1, 248, 96, 0, 120, 192, 0, 56,
  192, 0, 56, 192, 0, 48, 192, 0, 112, 96, 0, 96, 48, 1, 192, 30,
  7, 128, 3, 252, 0, 24, 34, 102, 27, 1, 0, 255, 128, 0, 31, 128,
  0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0,
  31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 129, 0, 31,
  143, 224, 31, 145, 240, 31, 160, 248, 31, 160, 252, 31, 192, 252, 31, 192,
  252, 31, 192, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252,
  31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31,
  128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 255, 227,
  255, 11, 35, 70, 15, 2, 0, 4, 0, 31, 0, 63, 128, 63, 128, 63,
  128, 63, 128, 31, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 255, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63,
  0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 63,
  0, 63, 0, 63, 0, 63, 0, 63, 0, 63, 0, 255, 224, 15, 46, 92,
  16, 254, 245, 0, 16, 0, 124, 0, 254, 0, 254, 0, 254, 0, 254, 0,
  124, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 252, 0,
  252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0,
  252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0,
  252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 0, 252, 56, 252, 124,
  252, 252, 252, 252, 252, 248, 248, 248, 248, 113, 240, 49, 224, 31, 128, 25,
  34, 136, 27, 1, 0, 255, 128, 0, 0, 31, 128, 0, 0, 31, 128, 0,
  0, 31, 128, 0, 0, 31, 128, 0, 0, 31, 128, 0, 0, 31, 128, 0,
  0, 31, 128, 0, 0, 31, 128, 0, 0, 31, 128, 0, 0, 31, 128, 0,
  0, 31, 128, 0, 0, 31, 131, 254, 0, 31, 128, 240, 0, 31, 128, 96,
  0, 31, 128, 192, 0, 31, 128, 128, 0, 31, 129, 128, 0, 31, 131, 0,
  0, 31, 134, 0, 0, 31, 143, 0, 0, 31, 159, 0, 0, 31, 159, 128,
  0, 31, 191, 128, 0, 31, 239, 192, 0, 31, 199, 224, 0, 31, 135, 224,
  0, 31, 131, 240, 0, 31, 129, 248, 0, 31, 129, 248, 0, 31, 128, 252,
  0, 31, 128, 252, 0, 31, 128, 254, 0, 255, 243, 255, 128, 12, 34, 68,
  14, 1, 0, 255, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 255, 240, 34, 22, 110, 37, 2, 1, 255, 31, 193,
  248, 0, 63, 35, 230, 124, 0, 63, 67, 228, 62, 0, 63, 131, 248, 63,
  0, 63, 131, 248, 63, 0, 63, 131, 248, 63, 0, 63, 3, 240, 63, 0,
  63, 3, 240, 63, 0, 63, 3, 240, 63, 0, 63, 3, 240, 63, 0, 63,
  3, 240, 63, 0, 63, 3, 240, 63, 0, 63, 3, 240, 63, 0, 63, 3,
  240, 63, 0, 63, 3, 240, 63, 0, 63, 3, 240, 63, 0, 63, 3, 240,
  63, 0, 63, 3, 240, 63, 0, 63, 3, 240, 63, 0, 63, 3, 240, 63,
  0, 63, 3, 240, 63, 0, 255, 207, 252, 255, 192, 23, 22, 66, 27, 2,
  1, 255, 31, 192, 63, 35, 224, 63, 65, 240, 63, 65, 248, 63, 129, 248,
  63, 129, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63,
  1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1,
  248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248, 63, 1, 248,
  255, 199, 254, 20, 22, 66, 24, 2, 1, 3, 252, 0, 15, 15, 0, 30,
  7, 128, 62, 7, 192, 62, 7, 192, 124, 3, 224, 124, 3, 224, 252, 3,
  240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240, 252, 3, 240,
  252, 3, 240, 252, 3, 240, 124, 3, 224, 124, 3, 224, 62, 7, 192, 62,
  7, 192, 30, 7, 128, 15, 15, 0, 3, 252, 0, 22, 33, 99, 25, 1,
  246, 255, 159, 128, 31, 163, 192, 31, 225, 224, 31, 193, 240, 31, 192, 248,
  31, 192, 248, 31, 192, 248, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31,
  128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 128, 252, 31, 192,
  252, 31, 192, 248, 31, 192, 248, 31, 193, 240, 31, 225, 240, 31, 179, 224,
  31, 159, 128, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31,
  128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128, 0, 31, 128,
  0, 255, 240, 0, 22, 33, 99, 25, 2, 246, 7, 240, 32, 15, 24, 96,
  30, 28, 96, 62, 14, 224, 126, 15, 224, 124, 15, 224, 124, 7, 224, 252,
  7, 224, 252, 7, 224, 252, 7, 224, 252, 7, 224, 252, 7, 224, 252, 7,
  224, 252, 7, 224, 252, 7, 224, 124, 7, 224, 124, 15, 224, 126, 15, 224,
  62, 15, 224, 30, 31, 224, 31, 23, 224, 7, 231, 224, 0, 7, 224, 0,
  7, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 7,
  224, 0, 7, 224, 0, 7, 224, 0, 7, 224, 0, 63, 252, 17, 22, 66,
  20, 2, 1, 255, 31, 0, 63, 63, 128, 63, 79, 128, 63, 79, 128, 63,
  159, 128, 63, 159, 128, 63, 159, 0, 63, 14, 0, 63, 0, 0, 63, 0,
  0, 63, 0, 0, 63, 0, 0, 63, 0, 0, 63, 0, 0, 63, 0, 0,
  63, 0, 0, 63, 0, 0, 63, 0, 0, 63, 0, 0, 63, 0, 0, 63,
  0, 0, 255, 192, 0, 16, 22, 44, 21, 3, 1, 31, 196, 48, 116, 96,
  60, 224, 28, 224, 28, 240, 12, 248, 4, 254, 4, 127, 128, 127, 224, 63,
  240, 31, 252, 7, 254, 129, 254, 192, 127, 192, 31, 224, 15, 224, 7, 240,
  7, 248, 6, 204, 14, 135, 248, 15, 32, 64, 17, 1, 0, 1, 128, 1,
  128, 1, 128, 1, 128, 1, 128, 3, 128, 3, 128, 7, 128, 15, 128, 63,
  128, 255, 248, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 128, 31,
  128, 31, 128, 31, 128, 31, 128, 31, 128, 31, 130, 31, 130, 31, 130, 31,
  130, 31, 134, 31, 134, 31, 132, 15, 196, 15, 248, 7, 240, 24, 22, 66,
  26, 1, 0, 255, 143, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31,
  129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129,
  248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248, 31, 129, 248,
  31, 129, 248, 31, 131, 248, 31, 131, 248, 31, 133, 248, 15, 133, 248, 15,
  201, 248, 7, 241, 255, 23, 23, 69, 25, 1, 255, 255, 241, 254, 63, 192,
  120, 31, 128, 48, 15, 192, 48, 15, 192, 32, 7, 192, 96, 7, 224, 96,
  7, 224, 64, 3, 224, 192, 3, 240, 128, 3, 240, 128, 1, 241, 128, 1,
  249, 0, 0, 249, 0, 0, 255, 0, 0, 254, 0, 0, 126, 0, 0, 126,
  0, 0, 124, 0, 0, 60, 0, 0, 60, 0, 0, 24, 0, 0, 24, 0,
  35, 23, 115, 37, 1, 255, 255, 231, 255, 31, 224, 63, 129, 252, 7, 128,
  31, 128, 252, 3, 0, 15, 128, 252, 2, 0, 15, 192, 124, 2, 0, 15,
  192, 124, 6, 0, 7, 192, 126, 4, 0, 7, 224, 254, 4, 0, 3, 224,
  191, 12, 0, 3, 224, 191, 8, 0, 3, 241, 159, 24, 0, 1, 241, 31,
  144, 0, 1, 241, 31, 144, 0, 1, 251, 31, 176, 0, 0, 250, 15, 224,
  0, 0, 250, 15, 224, 0, 0, 254, 15, 224, 0, 0, 124, 7, 192, 0,
  0, 124, 7, 192, 0, 0, 60, 7, 192, 0, 0, 56, 3, 128, 0, 0,
  56, 3, 128, 0, 0, 24, 3, 0, 0, 23, 22, 66, 25, 1, 0, 255,
  231, 252, 63, 192, 240, 31, 192, 224, 15, 192, 192, 15, 225, 128, 7, 227,
  0, 3, 242, 0, 3, 254, 0, 1, 252, 0, 1, 252, 0, 0, 252, 0,
  0, 126, 0, 0, 127, 0, 0, 127, 0, 0, 223, 128, 1, 159, 192, 3,
  15, 192, 2, 15, 224, 6, 7, 224, 14, 7, 240, 30, 7, 248, 255, 207,
  254, 23, 33, 99, 25, 1, 245, 255, 241, 254, 63, 192, 120, 31, 128, 48,
  15, 192, 32, 15, 192, 32, 15, 192, 96, 7, 224, 64, 7, 224, 64, 3,
  240, 192, 3, 240, 128, 1, 248, 128, 1, 249, 128, 0, 249, 0, 0, 253,
  0, 0, 253, 0, 0, 126, 0, 0, 126, 0, 0, 62, 0, 0, 60, 0,
  0, 28, 0, 0, 28, 0, 0, 12, 0, 0, 8, 0, 0, 8, 0, 0,
  8, 0, 15, 16, 0, 31, 16, 0, 63, 144, 0, 63, 32, 0, 62, 32,
  0, 62, 64, 0, 31, 192, 0, 15, 0, 0, 18, 22, 66, 22, 2, 0,
  127, 255, 192, 124, 15, 192, 120, 31, 128, 112, 63, 0, 96, 63, 0, 96,
  126, 0, 64, 126, 0, 64, 252, 0, 1, 248, 0, 1, 248, 0, 3, 240,
  0, 3, 240, 0, 7, 224, 64, 15, 192, 64, 15, 192, 64, 31, 128, 192,
  31, 0, 192, 63, 1, 192, 126, 1, 192, 126, 3, 192, 252, 15, 192, 255,
  255, 192, 14, 43, 86, 20, 3, 247, 0, 60, 0, 240, 3, 192, 7, 128,
  7, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128,
  15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 0, 15, 0,
  28, 0, 240, 0, 60, 0, 30, 0, 15, 0, 15, 128, 15, 128, 15, 128,
  15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128,
  15, 128, 15, 128, 7, 128, 7, 128, 3, 192, 0, 240, 0, 60, 3, 44,
  44, 13, 5, 247, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  15, 43, 86, 20, 3, 247, 240, 0, 60, 0, 15, 0, 7, 128, 7, 128,
  7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192,
  7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 3, 192, 3, 192, 0, 240,
  0, 62, 0, 240, 1, 224, 3, 192, 7, 192, 7, 192, 7, 192, 7, 192,
  7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192, 7, 192,
  7, 192, 7, 128, 7, 128, 15, 0, 60, 0, 240, 0, 27, 9, 36, 31,
  2, 8, 31, 128, 1, 128, 63, 240, 0, 192, 127, 254, 0, 96, 255, 255,
  128, 96, 193, 255, 240, 96, 192, 63, 255, 224, 192, 15, 255, 192, 96, 1,
  255, 128, 48, 0, 63, 0, 255
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--26-260-72-72-P-138-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 18, '1' Height: 18
  Calculated Max Values w=26 h=24 x= 5 y=15 dx=28 dy= 0 ascent=25 len=72
  Font Bounding box     w=68 h=33 x=-21 y=-8
  Calculated Min Values           x=-1 y=-7 dx= 0 dy= 0
  Pure Font   ascent =18 descent=-6
  X Font      ascent =19 descent=-6
  Max Font    ascent =25 descent=-7
*/
const u8g_fntpgm_uint8_t u8g_font_osr18[7816] U8G_FONT_SECTION("u8g_font_osr18") = {
  0, 68, 33, 235, 248, 18, 4, 197, 10, 125, 32, 255, 250, 25, 249, 19,
  250, 0, 0, 0, 7, 0, 0, 3, 18, 18, 7, 2, 0, 224, 224, 224,
  224, 224, 224, 64, 64, 64, 64, 64, 64, 64, 64, 0, 224, 224, 224, 6,
  5, 5, 10, 2, 13, 204, 204, 204, 204, 72, 14, 18, 36, 18, 2, 0,
  4, 32, 4, 32, 4, 32, 4, 32, 4, 32, 255, 252, 8, 64, 8, 64,
  8, 64, 8, 64, 8, 64, 24, 64, 255, 252, 16, 128, 16, 128, 16, 128,
  16, 128, 16, 128, 11, 22, 44, 15, 2, 254, 9, 0, 9, 0, 31, 128,
  41, 64, 73, 32, 73, 32, 73, 96, 73, 96, 105, 0, 61, 0, 31, 128,
  15, 192, 9, 192, 9, 96, 233, 32, 233, 32, 201, 32, 201, 64, 105, 64,
  31, 128, 9, 0, 9, 0, 18, 18, 54, 22, 2, 0, 56, 2, 0, 68,
  4, 0, 198, 8, 0, 198, 8, 0, 198, 16, 0, 198, 32, 0, 198, 32,
  0, 68, 64, 0, 56, 64, 0, 0, 134, 0, 1, 25, 128, 1, 48, 128,
  2, 48, 192, 4, 48, 192, 4, 48, 192, 8, 48, 192, 8, 24, 128, 16,
  15, 0, 18, 18, 54, 20, 1, 0, 7, 128, 0, 8, 64, 0, 24, 64,
  0, 24, 64, 0, 24, 192, 0, 28, 128, 0, 15, 0, 0, 6, 31, 192,
  15, 6, 0, 23, 6, 0, 35, 132, 0, 97, 196, 0, 192, 232, 0, 192,
  240, 0, 192, 112, 0, 224, 120, 128, 96, 220, 128, 63, 15, 0, 2, 5,
  5, 7, 2, 13, 192, 192, 192, 192, 64, 6, 23, 23, 10, 3, 252, 8,
  16, 48, 32, 64, 64, 192, 128, 128, 128, 128, 128, 128, 128, 128, 192, 64,
  64, 96, 32, 16, 24, 12, 6, 23, 23, 9, 1, 252, 64, 32, 48, 16,
  24, 8, 8, 12, 4, 4, 4, 4, 4, 4, 12, 8, 8, 8, 16, 16,
  32, 64, 192, 10, 10, 20, 14, 2, 8, 12, 0, 12, 0, 204, 192, 201,
  192, 43, 0, 28, 0, 123, 128, 201, 192, 12, 0, 12, 0, 22, 22, 66,
  24, 1, 252, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0,
  16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16,
  0, 255, 255, 252, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0,
  0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0,
  16, 0, 0, 16, 0, 3, 8, 8, 7, 2, 252, 192, 224, 224, 32, 32,
  64, 64, 128, 7, 1, 1, 11, 2, 6, 254, 3, 3, 3, 7, 2, 0,
  224, 224, 224, 8, 24, 24, 12, 2, 250, 1, 1, 2, 2, 2, 4, 4,
  4, 12, 8, 8, 24, 16, 16, 16, 32, 32, 32, 64, 64, 64, 128, 128,
  128, 12, 18, 36, 15, 1, 0, 15, 0, 16, 192, 32, 64, 96, 96, 96,
  32, 192, 48, 192, 48, 192, 48, 192, 48, 192, 48, 192, 48, 192, 48, 192,
  48, 96, 32, 96, 96, 32, 64, 16, 192, 15, 0, 9, 18, 36, 15, 3,
  0, 8, 0, 8, 0, 24, 0, 248, 0, 24, 0, 24, 0, 24, 0, 24,
  0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24,
  0, 24, 0, 255, 128, 10, 18, 36, 15, 2, 0, 30, 0, 99, 128, 129,
  192, 128, 192, 128, 192, 224, 192, 240, 192, 32, 192, 1, 128, 3, 0, 6,
  0, 8, 0, 16, 0, 32, 0, 64, 64, 192, 64, 255, 192, 255, 192, 11,
  18, 36, 15, 2, 0, 63, 0, 97, 128, 192, 192, 224, 192, 240, 192, 0,
  192, 0, 192, 1, 128, 62, 0, 1, 128, 0, 192, 0, 96, 96, 96, 240,
  96, 240, 96, 192, 192, 65, 128, 63, 0, 12, 18, 36, 15, 2, 0, 1,
  0, 3, 0, 3, 0, 7, 0, 15, 0, 11, 0, 19, 0, 51, 0, 35,
  0, 67, 0, 195, 0, 131, 0, 255, 224, 3, 0, 3, 0, 3, 0, 3,
  0, 31, 240, 11, 18, 36, 15, 2, 0, 96, 192, 127, 128, 126, 0, 64,
  0, 64, 0, 64, 0, 95, 0, 97, 128, 64, 192, 64, 224, 0, 96, 0,
  96, 96, 96, 240, 96, 224, 192, 192, 192, 65, 128, 62, 0, 11, 18, 36,
  15, 2, 0, 15, 0, 24, 128, 48, 64, 96, 192, 96, 192, 64, 0, 192,
  0, 207, 0, 209, 192, 224, 192, 224, 224, 224, 96, 224, 96, 224, 96, 96,
  224, 96, 192, 49, 128, 15, 0, 10, 18, 36, 15, 3, 0, 255, 192, 255,
  192, 128, 64, 128, 64, 128, 128, 0, 128, 1, 0, 1, 0, 2, 0, 6,
  0, 6, 0, 12, 0, 12, 0, 30, 0, 30, 0, 30, 0, 30, 0, 14,
  0, 12, 18, 36, 15, 2, 0, 31, 128, 48, 224, 96, 96, 192, 48, 192,
  48, 224, 48, 240, 32, 124, 64, 63, 128, 55, 224, 96, 240, 192, 112, 192,
  48, 192, 48, 192, 48, 96, 96, 112, 192, 31, 128, 11, 18, 36, 15, 2,
  0, 30, 0, 49, 128, 96, 192, 224, 192, 192, 64, 192, 96, 192, 96, 192,
  224, 96, 224, 113, 96, 30, 96, 0, 96, 0, 64, 96, 192, 96, 192, 64,
  128, 65, 0, 62, 0, 3, 12, 12, 7, 2, 0, 224, 224, 224, 0, 0,
  0, 0, 0, 0, 224, 224, 224, 4, 16, 16, 8, 2, 252, 240, 240, 240,
  0, 0, 0, 0, 0, 96, 240, 240, 16, 16, 32, 32, 64, 20, 21, 63,
  24, 2, 253, 0, 0, 48, 0, 0, 192, 0, 3, 0, 0, 12, 0, 0,
  48, 0, 0, 224, 0, 3, 128, 0, 14, 0, 0, 24, 0, 0, 96, 0,
  0, 192, 0, 0, 48, 0, 0, 12, 0, 0, 7, 0, 0, 1, 192, 0,
  0, 112, 0, 0, 24, 0, 0, 6, 0, 0, 1, 128, 0, 0, 96, 0,
  0, 16, 22, 6, 18, 24, 1, 4, 255, 255, 252, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 255, 255, 252, 20, 21, 63, 24, 2, 253,
  192, 0, 0, 48, 0, 0, 12, 0, 0, 3, 0, 0, 0, 192, 0, 0,
  112, 0, 0, 28, 0, 0, 7, 0, 0, 1, 128, 0, 0, 96, 0, 0,
  48, 0, 0, 192, 0, 3, 0, 0, 14, 0, 0, 56, 0, 0, 224, 0,
  1, 128, 0, 6, 0, 0, 24, 0, 0, 96, 0, 0, 128, 0, 0, 9,
  18, 36, 12, 2, 0, 62, 0, 67, 0, 129, 128, 129, 128, 225, 128, 97,
  128, 3, 0, 6, 0, 12, 0, 16, 0, 48, 0, 34, 0, 34, 0, 28,
  0, 0, 0, 28, 0, 28, 0, 28, 0, 18, 18, 54, 20, 1, 0, 3,
  248, 0, 12, 6, 0, 16, 109, 0, 33, 156, 128, 67, 12, 128, 70, 8,
  64, 142, 8, 64, 142, 24, 64, 140, 24, 64, 140, 16, 64, 140, 48, 128,
  140, 48, 128, 140, 241, 0, 71, 30, 0, 96, 0, 0, 32, 0, 0, 24,
  12, 0, 7, 240, 0, 18, 18, 54, 20, 2, 0, 0, 128, 0, 0, 192,
  0, 1, 192, 0, 1, 192, 0, 1, 224, 0, 3, 224, 0, 2, 96, 0,
  2, 112, 0, 6, 112, 0, 4, 48, 0, 4, 56, 0, 12, 56, 0, 15,
  248, 0, 24, 28, 0, 16, 12, 0, 16, 12, 0, 48, 14, 0, 254, 63,
  192, 15, 18, 36, 17, 1, 0, 255, 240, 24, 28, 24, 12, 24, 6, 24,
  6, 24, 6, 24, 12, 24, 24, 31, 224, 24, 24, 24, 12, 24, 6, 24,
  6, 24, 6, 24, 6, 24, 12, 24, 28, 255, 240, 14, 18, 36, 18, 2,
  0, 7, 132, 24, 108, 32, 60, 96, 28, 96, 12, 192, 12, 192, 4, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 4, 96, 4, 96, 4, 32, 8, 48,
  24, 24, 48, 7, 192, 17, 18, 54, 20, 1, 0, 255, 240, 0, 24, 12,
  0, 24, 6, 0, 24, 3, 0, 24, 3, 0, 24, 1, 128, 24, 1, 128,
  24, 1, 128, 24, 1, 128, 24, 1, 128, 24, 1, 128, 24, 1, 128, 24,
  1, 128, 24, 3, 0, 24, 3, 0, 24, 6, 0, 24, 12, 0, 255, 240,
  0, 15, 18, 36, 18, 1, 0, 255, 254, 24, 6, 24, 2, 24, 2, 24,
  2, 24, 34, 24, 32, 24, 96, 31, 224, 24, 96, 24, 32, 24, 32, 24,
  34, 24, 2, 24, 2, 24, 6, 24, 14, 255, 254, 15, 18, 36, 17, 1,
  0, 255, 254, 24, 6, 24, 2, 24, 2, 24, 2, 24, 34, 24, 32, 24,
  96, 31, 224, 24, 96, 24, 32, 24, 32, 24, 32, 24, 0, 24, 0, 24,
  0, 24, 0, 127, 0, 17, 18, 54, 19, 2, 0, 7, 196, 0, 24, 100,
  0, 48, 28, 0, 96, 28, 0, 96, 12, 0, 96, 4, 0, 192, 4, 0,
  192, 0, 0, 192, 127, 128, 192, 28, 0, 192, 28, 0, 192, 28, 0, 192,
  28, 0, 96, 28, 0, 96, 28, 0, 48, 52, 0, 24, 100, 0, 7, 132,
  0, 18, 18, 54, 20, 1, 0, 255, 63, 192, 24, 6, 0, 24, 6, 0,
  24, 6, 0, 24, 6, 0, 24, 6, 0, 24, 6, 0, 24, 6, 0, 31,
  254, 0, 24, 6, 0, 24, 6, 0, 24, 6, 0, 24, 6, 0, 24, 6,
  0, 24, 6, 0, 24, 6, 0, 24, 6, 0, 255, 63, 192, 8, 18, 18,
  10, 1, 0, 255, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 255, 12, 18, 36, 14, 1, 0, 7, 240, 1, 128, 1,
  128, 1, 128, 1, 128, 1, 128, 1, 128, 1, 128, 1, 128, 1, 128, 1,
  128, 1, 128, 97, 128, 241, 128, 225, 128, 193, 128, 67, 0, 62, 0, 17,
  18, 54, 19, 1, 0, 255, 63, 128, 24, 14, 0, 24, 8, 0, 24, 16,
  0, 24, 32, 0, 24, 64, 0, 24, 128, 0, 25, 192, 0, 26, 192, 0,
  28, 224, 0, 24, 96, 0, 24, 112, 0, 24, 56, 0, 24, 56, 0, 24,
  28, 0, 24, 28, 0, 24, 14, 0, 255, 127, 128, 15, 18, 36, 17, 1,
  0, 255, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24,
  0, 24, 0, 24, 0, 24, 0, 24, 2, 24, 2, 24, 2, 24, 6, 24,
  6, 24, 14, 255, 254, 20, 18, 54, 22, 1, 0, 252, 3, 240, 28, 3,
  128, 30, 5, 128, 22, 5, 128, 22, 5, 128, 23, 5, 128, 19, 9, 128,
  19, 9, 128, 19, 137, 128, 19, 145, 128, 17, 145, 128, 17, 209, 128, 17,
  209, 128, 16, 225, 128, 16, 225, 128, 16, 225, 128, 16, 65, 128, 254, 79,
  240, 18, 18, 54, 19, 1, 0, 252, 15, 192, 28, 2, 0, 30, 2, 0,
  22, 2, 0, 23, 2, 0, 19, 130, 0, 17, 130, 0, 17, 194, 0, 16,
  226, 0, 16, 226, 0, 16, 114, 0, 16, 50, 0, 16, 58, 0, 16, 30,
  0, 16, 14, 0, 16, 14, 0, 16, 6, 0, 254, 2, 0, 15, 18, 36,
  18, 2, 0, 7, 192, 24, 48, 48, 24, 32, 8, 96, 12, 96, 12, 192,
  6, 192, 6, 192, 6, 192, 6, 192, 6, 192, 6, 96, 12, 96, 12, 32,
  8, 48, 24, 24, 48, 7, 192, 15, 18, 36, 17, 1, 0, 255, 240, 24,
  28, 24, 12, 24, 6, 24, 6, 24, 6, 24, 12, 24, 24, 31, 240, 24,
  0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 255,
  0, 15, 22, 44, 18, 2, 252, 7, 192, 24, 48, 48, 24, 32, 8, 96,
  12, 96, 12, 192, 6, 192, 6, 192, 6, 192, 6, 192, 6, 192, 6, 96,
  12, 99, 140, 36, 76, 52, 120, 28, 114, 7, 226, 0, 98, 0, 118, 0,
  60, 0, 24, 17, 18, 54, 19, 1, 0, 255, 240, 0, 24, 24, 0, 24,
  12, 0, 24, 12, 0, 24, 12, 0, 24, 12, 0, 24, 24, 0, 31, 224,
  0, 24, 48, 0, 24, 56, 0, 24, 24, 0, 24, 24, 0, 24, 24, 0,
  24, 28, 128, 24, 28, 128, 24, 28, 128, 24, 31, 0, 255, 15, 0, 13,
  18, 36, 16, 2, 0, 30, 32, 97, 160, 192, 96, 192, 96, 192, 32, 192,
  32, 224, 0, 124, 0, 63, 128, 15, 224, 129, 240, 128, 112, 128, 24, 192,
  24, 192, 24, 224, 16, 152, 32, 135, 192, 15, 18, 36, 18, 2, 0, 255,
  254, 195, 14, 131, 6, 131, 2, 3, 2, 3, 2, 3, 2, 3, 0, 3,
  0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3,
  0, 31, 240, 19, 18, 54, 21, 1, 0, 255, 15, 224, 24, 1, 0, 24,
  1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1,
  0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0,
  24, 1, 0, 12, 1, 0, 12, 2, 0, 6, 4, 0, 1, 248, 0, 18,
  18, 54, 20, 1, 0, 255, 31, 192, 28, 3, 0, 28, 2, 0, 12, 2,
  0, 14, 6, 0, 6, 4, 0, 7, 4, 0, 7, 8, 0, 3, 8, 0,
  3, 136, 0, 3, 144, 0, 1, 144, 0, 1, 208, 0, 0, 224, 0, 0,
  224, 0, 0, 224, 0, 0, 64, 0, 0, 64, 0, 26, 18, 72, 28, 1,
  0, 255, 63, 159, 192, 28, 14, 3, 0, 12, 6, 2, 0, 12, 14, 2,
  0, 14, 15, 6, 0, 14, 15, 4, 0, 6, 19, 4, 0, 7, 19, 140,
  0, 7, 19, 136, 0, 3, 49, 136, 0, 3, 161, 216, 0, 3, 161, 208,
  0, 1, 160, 208, 0, 1, 192, 240, 0, 1, 192, 224, 0, 0, 192, 96,
  0, 0, 128, 96, 0, 0, 128, 64, 0, 18, 18, 54, 20, 1, 0, 127,
  191, 128, 14, 12, 0, 14, 12, 0, 7, 8, 0, 7, 16, 0, 3, 176,
  0, 1, 160, 0, 1, 192, 0, 0, 192, 0, 0, 224, 0, 1, 96, 0,
  3, 112, 0, 2, 56, 0, 4, 56, 0, 12, 28, 0, 8, 12, 0, 24,
  14, 0, 254, 63, 192, 17, 18, 54, 19, 1, 0, 255, 31, 128, 28, 6,
  0, 28, 4, 0, 14, 4, 0, 6, 8, 0, 7, 8, 0, 3, 144, 0,
  3, 160, 0, 1, 224, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0,
  192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 7, 252,
  0, 14, 18, 36, 17, 2, 0, 127, 252, 112, 56, 96, 48, 64, 112, 64,
  224, 128, 192, 1, 192, 3, 128, 3, 0, 7, 0, 14, 0, 12, 4, 28,
  4, 56, 4, 48, 12, 112, 28, 224, 56, 255, 248, 5, 23, 23, 10, 3,
  251, 248, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 248, 8, 24, 24, 12, 2, 250, 128, 128,
  128, 64, 64, 64, 32, 32, 32, 16, 16, 16, 16, 8, 8, 8, 4, 4,
  4, 2, 2, 2, 1, 1, 5, 23, 23, 10, 2, 251, 248, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 248, 11, 9, 18, 15, 2, 9, 4, 0, 14, 0, 10, 0, 17,
  0, 49, 128, 32, 128, 64, 64, 64, 96, 128, 32, 14, 1, 2, 14, 0,
  252, 255, 252, 4, 4, 4, 11, 2, 13, 192, 224, 96, 16, 11, 12, 24,
  13, 1, 0, 30, 0, 99, 0, 65, 128, 97, 128, 33, 128, 15, 128, 113,
  128, 193, 128, 195, 160, 195, 160, 197, 160, 121, 192, 11, 18, 36, 13, 0,
  0, 240, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 51, 128, 52,
  192, 56, 96, 56, 96, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96, 56,
  96, 40, 192, 39, 128, 9, 12, 24, 11, 1, 0, 30, 0, 33, 0, 96,
  128, 193, 128, 193, 128, 192, 0, 192, 0, 192, 0, 192, 128, 96, 128, 33,
  0, 30, 0, 12, 18, 36, 14, 1, 0, 7, 192, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 192, 28, 192, 98, 192, 97, 192, 193, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 97, 192, 97, 192, 30, 240, 9, 12, 24,
  12, 1, 0, 30, 0, 35, 0, 97, 128, 193, 128, 193, 128, 255, 128, 192,
  0, 192, 0, 192, 128, 96, 128, 33, 0, 30, 0, 9, 18, 36, 9, 1,
  0, 15, 0, 24, 128, 49, 128, 49, 0, 48, 0, 48, 0, 254, 0, 48,
  0, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48,
  0, 48, 0, 254, 0, 12, 18, 36, 15, 2, 250, 30, 112, 97, 176, 225,
  240, 192, 192, 192, 192, 192, 192, 225, 128, 97, 128, 30, 0, 224, 0, 255,
  0, 127, 192, 64, 96, 128, 32, 128, 32, 128, 32, 192, 64, 63, 128, 13,
  18, 36, 15, 1, 0, 240, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48,
  0, 51, 192, 52, 192, 56, 96, 56, 96, 48, 96, 48, 96, 48, 96, 48,
  96, 48, 96, 48, 96, 48, 96, 253, 248, 6, 18, 18, 8, 1, 0, 112,
  112, 32, 0, 0, 0, 240, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  252, 7, 24, 24, 8, 255, 250, 6, 6, 0, 0, 0, 0, 62, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 198, 198, 140, 120, 12,
  18, 36, 14, 1, 0, 240, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48,
  0, 49, 240, 48, 128, 49, 0, 50, 0, 50, 0, 54, 0, 59, 0, 51,
  0, 49, 128, 49, 192, 48, 224, 253, 240, 6, 18, 18, 8, 1, 0, 240,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  252, 19, 12, 36, 21, 1, 0, 243, 199, 0, 52, 249, 128, 56, 113, 192,
  56, 97, 192, 48, 97, 192, 48, 97, 192, 48, 97, 192, 48, 97, 192, 48,
  97, 192, 48, 97, 192, 48, 97, 192, 253, 251, 224, 13, 12, 24, 15, 1,
  0, 243, 192, 52, 192, 56, 96, 56, 96, 48, 96, 48, 96, 48, 96, 48,
  96, 48, 96, 48, 96, 48, 96, 253, 248, 10, 12, 24, 13, 1, 0, 30,
  0, 33, 128, 97, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 97, 128, 33, 128, 30, 0, 11, 18, 36, 14, 1, 250, 243, 128, 52,
  192, 56, 96, 56, 96, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96, 56,
  96, 56, 192, 55, 128, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 252,
  0, 12, 18, 36, 13, 1, 250, 28, 64, 98, 64, 97, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 97, 192, 97, 192, 30, 192, 0,
  192, 0, 192, 0, 192, 0, 192, 0, 192, 3, 240, 9, 12, 24, 11, 1,
  0, 243, 128, 52, 128, 57, 128, 56, 128, 56, 0, 48, 0, 48, 0, 48,
  0, 48, 0, 48, 0, 48, 0, 252, 0, 9, 12, 24, 11, 1, 0, 125,
  0, 131, 0, 129, 0, 193, 0, 240, 0, 124, 0, 31, 0, 131, 128, 128,
  128, 192, 128, 224, 128, 159, 0, 8, 17, 17, 10, 1, 0, 16, 16, 16,
  48, 48, 254, 48, 48, 48, 48, 48, 48, 48, 49, 49, 51, 30, 13, 12,
  24, 14, 0, 0, 241, 224, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96,
  48, 96, 48, 96, 48, 224, 48, 224, 57, 96, 30, 120, 13, 12, 24, 14,
  1, 0, 252, 248, 48, 96, 48, 64, 24, 64, 24, 128, 12, 128, 12, 128,
  13, 0, 7, 0, 7, 0, 2, 0, 2, 0, 19, 12, 36, 21, 1, 0,
  253, 251, 224, 48, 96, 128, 48, 96, 128, 24, 113, 0, 24, 177, 0, 12,
  177, 0, 12, 154, 0, 13, 26, 0, 7, 28, 0, 7, 12, 0, 2, 12,
  0, 2, 8, 0, 12, 12, 24, 14, 1, 0, 249, 224, 48, 128, 57, 0,
  25, 0, 14, 0, 14, 0, 6, 0, 11, 0, 19, 0, 17, 128, 33, 192,
  243, 240, 13, 18, 36, 14, 0, 250, 252, 248, 56, 32, 24, 32, 24, 64,
  12, 64, 12, 64, 12, 128, 6, 128, 6, 128, 7, 0, 3, 0, 3, 0,
  2, 0, 2, 0, 34, 0, 98, 0, 100, 0, 56, 0, 9, 12, 24, 12,
  1, 0, 255, 128, 195, 128, 131, 0, 134, 0, 142, 0, 12, 0, 24, 0,
  56, 0, 48, 128, 96, 128, 96, 128, 255, 128, 6, 23, 23, 12, 3, 251,
  12, 16, 48, 48, 48, 48, 56, 24, 24, 24, 16, 224, 48, 16, 24, 24,
  56, 48, 48, 48, 48, 16, 12, 1, 24, 24, 7, 3, 250, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 6, 23, 23, 11, 3, 251, 192, 32, 48, 48, 48,
  112, 96, 96, 96, 96, 32, 28, 48, 96, 96, 96, 96, 112, 48, 48, 48,
  32, 192, 15, 5, 10, 17, 1, 4, 32, 4, 254, 2, 143, 194, 129, 254,
  64, 124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 0, 0, 0, 7, 0, 0, 3, 18, 18, 7, 2, 250, 224,
  224, 224, 0, 64, 64, 64, 64, 64, 64, 64, 64, 224, 224, 224, 224, 224,
  224, 9, 18, 36, 15, 3, 253, 4, 0, 4, 0, 4, 0, 31, 0, 53,
  0, 100, 128, 229, 128, 197, 128, 196, 0, 196, 0, 196, 0, 228, 128, 100,
  128, 53, 0, 31, 0, 4, 0, 4, 0, 4, 0, 14, 18, 36, 19, 2,
  0, 0, 248, 1, 132, 3, 4, 2, 12, 6, 0, 6, 0, 6, 0, 62,
  0, 7, 224, 6, 0, 6, 0, 6, 0, 6, 0, 6, 0, 116, 4, 140,
  4, 139, 248, 112, 240, 11, 11, 22, 15, 2, 2, 159, 32, 113, 192, 64,
  64, 128, 96, 128, 32, 128, 32, 128, 32, 128, 32, 64, 64, 96, 192, 159,
  32, 15, 18, 36, 15, 0, 0, 252, 126, 56, 24, 24, 16, 28, 16, 12,
  32, 14, 64, 6, 64, 7, 128, 3, 128, 63, 240, 3, 0, 3, 0, 63,
  240, 3, 0, 3, 0, 3, 0, 3, 0, 31, 224, 1, 23, 23, 7, 3,
  251, 128, 128, 128, 128, 128, 128, 128, 128, 128, 0, 0, 0, 0, 0, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 10, 23, 46, 17, 3, 251, 30, 0,
  33, 0, 35, 0, 35, 0, 32, 0, 48, 0, 28, 0, 46, 0, 71, 0,
  131, 128, 129, 192, 192, 192, 224, 64, 112, 64, 56, 128, 29, 0, 6, 0,
  3, 0, 3, 0, 49, 0, 49, 0, 34, 0, 28, 0, 7, 2, 2, 11,
  2, 15, 198, 198, 19, 18, 54, 21, 1, 0, 3, 248, 0, 12, 6, 0,
  16, 225, 0, 33, 28, 128, 67, 12, 64, 70, 4, 64, 134, 4, 32, 134,
  0, 32, 134, 0, 32, 134, 0, 32, 134, 0, 32, 134, 8, 32, 67, 8,
  64, 67, 8, 64, 32, 240, 128, 16, 1, 0, 12, 6, 0, 3, 248, 0,
  7, 8, 8, 11, 2, 10, 240, 200, 24, 104, 136, 154, 100, 252, 6, 10,
  10, 12, 3, 1, 32, 68, 136, 136, 136, 136, 136, 136, 68, 32, 13, 6,
  12, 15, 1, 3, 255, 248, 0, 8, 0, 8, 0, 8, 0, 8, 0, 8,
  7, 1, 1, 11, 2, 6, 254, 19, 18, 54, 21, 1, 0, 3, 248, 0,
  12, 6, 0, 31, 225, 0, 35, 24, 128, 67, 24, 64, 67, 24, 64, 131,
  24, 32, 131, 24, 32, 131, 224, 32, 131, 16, 32, 131, 24, 32, 131, 24,
  32, 67, 26, 64, 67, 26, 64, 47, 142, 128, 16, 1, 0, 12, 6, 0,
  3, 248, 0, 7, 1, 1, 11, 2, 15, 254, 7, 7, 7, 15, 4, 11,
  56, 68, 130, 130, 130, 68, 56, 22, 18, 54, 24, 1, 255, 0, 16, 0,
  0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0,
  16, 0, 255, 255, 252, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16,
  0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0,
  255, 255, 252, 7, 10, 10, 11, 2, 8, 124, 134, 134, 230, 6, 8, 16,
  96, 66, 254, 7, 11, 11, 12, 3, 7, 120, 132, 198, 198, 4, 120, 14,
  70, 198, 134, 120, 4, 4, 4, 11, 5, 13, 48, 48, 96, 128, 14, 19,
  38, 17, 2, 249, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 64, 192, 64, 128, 64, 132, 163, 252, 158, 56, 128, 0, 128, 0,
  192, 0, 192, 0, 192, 0, 224, 0, 64, 0, 11, 22, 44, 14, 2, 252,
  63, 224, 120, 128, 248, 128, 248, 128, 248, 128, 248, 128, 248, 128, 120, 128,
  8, 128, 8, 128, 8, 128, 8, 128, 8, 128, 8, 128, 8, 128, 8, 128,
  8, 128, 8, 128, 8, 128, 8, 128, 8, 128, 8, 128, 3, 3, 3, 7,
  2, 7, 224, 224, 224, 5, 5, 5, 11, 3, 251, 64, 48, 24, 24, 240,
  6, 11, 11, 12, 3, 7, 16, 16, 240, 48, 48, 48, 48, 48, 48, 48,
  252, 6, 9, 9, 10, 2, 9, 112, 136, 132, 132, 132, 132, 72, 48, 252,
  7, 10, 10, 13, 3, 1, 8, 68, 68, 34, 34, 34, 34, 68, 68, 136,
  18, 18, 54, 23, 3, 0, 16, 4, 0, 240, 12, 0, 48, 8, 0, 48,
  16, 0, 48, 16, 0, 48, 32, 0, 48, 96, 0, 48, 67, 0, 48, 135,
  0, 48, 139, 0, 253, 11, 0, 3, 19, 0, 2, 19, 0, 6, 35, 0,
  4, 63, 192, 8, 3, 0, 24, 3, 0, 16, 15, 192, 17, 18, 54, 22,
  3, 0, 16, 4, 0, 240, 8, 0, 48, 8, 0, 48, 16, 0, 48, 16,
  0, 48, 32, 0, 48, 64, 0, 48, 78, 0, 48, 179, 128, 48, 161, 128,
  253, 49, 128, 3, 17, 128, 2, 3, 0, 4, 6, 0, 4, 8, 0, 8,
  16, 128, 24, 49, 128, 16, 63, 128, 18, 18, 54, 23, 3, 0, 120, 4,
  0, 134, 12, 0, 198, 8, 0, 4, 16, 0, 120, 16, 0, 12, 32, 0,
  6, 96, 0, 198, 67, 0, 198, 135, 0, 142, 139, 0, 121, 11, 0, 2,
  19, 0, 2, 19, 0, 4, 35, 0, 12, 63, 192, 8, 3, 0, 16, 3,
  0, 16, 15, 192, 9, 18, 36, 12, 1, 250, 28, 0, 28, 0, 28, 0,
  0, 0, 28, 0, 34, 0, 34, 0, 6, 0, 4, 0, 24, 0, 48, 0,
  96, 0, 227, 0, 195, 128, 192, 128, 224, 128, 97, 0, 62, 0, 18, 24,
  72, 20, 2, 0, 6, 0, 0, 6, 0, 0, 3, 0, 0, 0, 128, 0,
  0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 192, 0, 1, 192, 0, 1,
  192, 0, 1, 224, 0, 3, 224, 0, 2, 96, 0, 2, 112, 0, 6, 112,
  0, 4, 48, 0, 4, 56, 0, 12, 24, 0, 15, 248, 0, 24, 28, 0,
  16, 12, 0, 16, 14, 0, 48, 14, 0, 254, 63, 192, 18, 24, 72, 20,
  2, 0, 0, 16, 0, 0, 48, 0, 0, 96, 0, 0, 64, 0, 0, 128,
  0, 0, 0, 0, 0, 128, 0, 0, 192, 0, 1, 192, 0, 1, 192, 0,
  1, 224, 0, 3, 224, 0, 2, 96, 0, 2, 112, 0, 6, 112, 0, 4,
  48, 0, 4, 56, 0, 12, 56, 0, 15, 248, 0, 24, 28, 0, 16, 12,
  0, 16, 14, 0, 48, 14, 0, 254, 63, 192, 18, 24, 72, 20, 2, 0,
  0, 128, 0, 0, 192, 0, 1, 96, 0, 2, 48, 0, 4, 8, 0, 0,
  0, 0, 0, 128, 0, 0, 192, 0, 1, 192, 0, 1, 192, 0, 1, 224,
  0, 3, 224, 0, 2, 96, 0, 2, 112, 0, 6, 112, 0, 4, 48, 0,
  4, 56, 0, 12, 56, 0, 15, 248, 0, 24, 28, 0, 16, 12, 0, 16,
  12, 0, 48, 14, 0, 254, 63, 192, 18, 23, 69, 20, 2, 0, 3, 144,
  0, 5, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0,
  0, 128, 0, 1, 192, 0, 1, 192, 0, 1, 224, 0, 3, 224, 0, 2,
  96, 0, 2, 112, 0, 6, 112, 0, 4, 48, 0, 12, 56, 0, 12, 56,
  0, 15, 248, 0, 24, 28, 0, 16, 28, 0, 16, 12, 0, 48, 14, 0,
  254, 63, 192, 18, 23, 69, 20, 1, 0, 6, 24, 0, 6, 24, 0, 2,
  16, 0, 0, 0, 0, 0, 0, 0, 0, 192, 0, 0, 192, 0, 0, 192,
  0, 1, 224, 0, 1, 224, 0, 1, 96, 0, 2, 112, 0, 2, 112, 0,
  2, 48, 0, 4, 56, 0, 4, 24, 0, 12, 24, 0, 15, 252, 0, 8,
  12, 0, 24, 12, 0, 24, 14, 0, 56, 6, 0, 254, 63, 192, 17, 24,
  72, 20, 2, 0, 1, 192, 0, 2, 32, 0, 2, 32, 0, 2, 32, 0,
  1, 192, 0, 0, 0, 0, 0, 128, 0, 0, 128, 0, 1, 192, 0, 1,
  192, 0, 1, 192, 0, 2, 224, 0, 2, 96, 0, 2, 96, 0, 4, 112,
  0, 4, 112, 0, 12, 48, 0, 8, 56, 0, 15, 248, 0, 24, 28, 0,
  16, 28, 0, 16, 12, 0, 48, 14, 0, 254, 127, 128, 24, 18, 54, 26,
  0, 0, 0, 127, 255, 0, 28, 7, 0, 28, 3, 0, 44, 1, 0, 44,
  1, 0, 76, 17, 0, 76, 16, 0, 140, 48, 0, 143, 240, 1, 12, 48,
  3, 12, 16, 2, 12, 17, 7, 252, 17, 4, 12, 1, 8, 12, 1, 8,
  12, 3, 24, 12, 7, 254, 63, 255, 14, 24, 48, 18, 2, 250, 7, 132,
  24, 108, 32, 60, 96, 28, 96, 12, 192, 12, 192, 4, 192, 0, 192, 0,
  192, 0, 192, 0, 192, 4, 96, 4, 96, 4, 96, 8, 48, 24, 24, 48,
  7, 192, 2, 0, 3, 128, 0, 192, 0, 192, 8, 192, 7, 128, 15, 24,
  48, 18, 1, 0, 4, 0, 6, 0, 3, 0, 1, 128, 0, 0, 0, 0,
  255, 254, 24, 6, 24, 2, 24, 2, 24, 2, 24, 34, 24, 32, 24, 96,
  31, 224, 24, 96, 24, 32, 24, 32, 24, 34, 24, 2, 24, 2, 24, 6,
  24, 14, 255, 254, 15, 24, 48, 18, 1, 0, 0, 48, 0, 48, 0, 96,
  0, 192, 0, 0, 0, 0, 255, 254, 24, 14, 24, 6, 24, 2, 24, 2,
  24, 34, 24, 32, 24, 96, 31, 224, 24, 96, 24, 32, 24, 32, 24, 34,
  24, 2, 24, 2, 24, 6, 24, 14, 255, 254, 15, 24, 48, 18, 1, 0,
  0, 128, 1, 192, 3, 64, 6, 48, 8, 8, 0, 0, 255, 254, 24, 6,
  24, 2, 24, 2, 24, 2, 24, 34, 24, 32, 24, 96, 31, 224, 24, 96,
  24, 32, 24, 32, 24, 34, 24, 2, 24, 2, 24, 6, 24, 14, 255, 254,
  15, 23, 46, 18, 1, 0, 6, 48, 6, 48, 4, 16, 0, 0, 0, 0,
  255, 254, 24, 14, 24, 6, 24, 2, 24, 2, 24, 34, 24, 32, 24, 96,
  31, 224, 24, 96, 24, 32, 24, 32, 24, 34, 24, 2, 24, 2, 24, 6,
  24, 14, 255, 254, 8, 24, 24, 10, 1, 0, 64, 96, 48, 16, 8, 0,
  255, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 255, 8, 24, 24, 10, 1, 0, 3, 3, 6, 8, 0, 0, 255, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 255,
  8, 24, 24, 10, 1, 0, 8, 24, 52, 66, 129, 0, 255, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 255, 8, 23,
  23, 10, 1, 0, 195, 195, 66, 0, 0, 255, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 255, 17, 18, 54, 19, 1,
  0, 255, 240, 0, 24, 12, 0, 24, 6, 0, 24, 3, 0, 24, 3, 0,
  24, 1, 128, 24, 1, 128, 24, 1, 128, 127, 1, 128, 24, 1, 128, 24,
  1, 128, 24, 1, 128, 24, 1, 128, 24, 3, 0, 24, 3, 0, 24, 6,
  0, 24, 12, 0, 255, 240, 0, 18, 24, 72, 19, 1, 0, 3, 200, 0,
  2, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252,
  15, 192, 28, 2, 0, 30, 2, 0, 22, 2, 0, 23, 2, 0, 19, 130,
  0, 17, 130, 0, 17, 194, 0, 16, 226, 0, 16, 226, 0, 16, 114, 0,
  16, 50, 0, 16, 58, 0, 16, 30, 0, 16, 14, 0, 16, 14, 0, 16,
  6, 0, 252, 2, 0, 15, 24, 48, 18, 2, 1, 28, 0, 12, 0, 6,
  0, 2, 0, 1, 0, 0, 0, 7, 192, 24, 48, 48, 24, 32, 8, 96,
  12, 96, 12, 192, 6, 192, 6, 192, 6, 192, 6, 192, 6, 192, 6, 96,
  12, 96, 12, 32, 8, 48, 24, 24, 48, 7, 192, 15, 24, 48, 18, 2,
  1, 0, 112, 0, 96, 0, 192, 0, 128, 1, 0, 0, 0, 7, 192, 24,
  48, 48, 24, 32, 8, 96, 12, 96, 12, 192, 6, 192, 6, 192, 6, 192,
  6, 192, 6, 192, 6, 96, 12, 96, 12, 32, 8, 48, 24, 24, 48, 7,
  192, 15, 24, 48, 18, 2, 0, 1, 0, 3, 128, 6, 192, 12, 96, 16,
  16, 0, 0, 7, 192, 24, 48, 48, 24, 32, 8, 96, 12, 96, 12, 192,
  6, 192, 6, 192, 6, 192, 6, 192, 6, 192, 6, 96, 12, 96, 12, 32,
  8, 48, 24, 24, 48, 7, 192, 15, 24, 48, 18, 2, 0, 15, 16, 19,
  224, 0, 0, 0, 0, 0, 0, 0, 0, 7, 192, 24, 48, 48, 24, 32,
  8, 96, 12, 96, 12, 192, 6, 192, 6, 192, 6, 192, 6, 192, 6, 192,
  6, 96, 12, 96, 12, 32, 8, 48, 24, 24, 48, 7, 192, 15, 24, 48,
  18, 2, 0, 8, 0, 12, 96, 12, 96, 0, 0, 0, 0, 0, 0, 7,
  192, 24, 48, 48, 24, 32, 8, 96, 12, 96, 12, 192, 6, 192, 6, 192,
  6, 192, 6, 192, 6, 192, 6, 96, 12, 96, 12, 32, 8, 48, 24, 24,
  48, 7, 192, 16, 16, 32, 24, 4, 255, 0, 1, 64, 3, 32, 6, 16,
  12, 8, 24, 4, 48, 2, 96, 1, 192, 1, 128, 3, 64, 6, 32, 12,
  16, 24, 8, 48, 4, 96, 2, 192, 1, 15, 18, 36, 18, 2, 0, 7,
  194, 24, 52, 48, 28, 32, 12, 96, 28, 96, 44, 192, 70, 192, 198, 193,
  134, 195, 6, 198, 6, 196, 6, 232, 12, 112, 12, 96, 8, 112, 24, 88,
  48, 135, 192, 19, 24, 72, 21, 1, 1, 3, 0, 0, 3, 128, 0, 0,
  128, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 255, 15, 224, 24, 1,
  0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0,
  24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24,
  1, 0, 24, 1, 0, 12, 1, 0, 12, 2, 0, 6, 4, 0, 1, 248,
  0, 19, 24, 72, 21, 1, 1, 0, 28, 0, 0, 24, 0, 0, 48, 0,
  0, 32, 0, 0, 64, 0, 0, 0, 0, 255, 15, 224, 24, 1, 0, 24,
  1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1,
  0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0,
  24, 1, 0, 12, 1, 0, 12, 2, 0, 6, 4, 0, 1, 248, 0, 19,
  24, 72, 21, 1, 0, 0, 96, 0, 0, 224, 0, 1, 176, 0, 3, 8,
  0, 0, 4, 0, 0, 0, 0, 255, 15, 224, 24, 1, 0, 24, 1, 0,
  24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24,
  1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1,
  0, 12, 1, 0, 12, 2, 0, 6, 4, 0, 1, 248, 0, 19, 23, 69,
  21, 1, 1, 3, 24, 0, 3, 24, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 255, 15, 224, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1,
  0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0,
  24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 12, 1, 0, 12,
  2, 0, 6, 4, 0, 1, 248, 0, 17, 24, 72, 19, 1, 0, 0, 24,
  0, 0, 56, 0, 0, 48, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0,
  255, 31, 128, 28, 6, 0, 28, 4, 0, 14, 4, 0, 6, 8, 0, 7,
  8, 0, 3, 144, 0, 3, 160, 0, 1, 224, 0, 0, 192, 0, 0, 192,
  0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0,
  0, 192, 0, 7, 252, 0, 15, 18, 36, 17, 1, 0, 255, 0, 24, 0,
  24, 0, 31, 224, 24, 24, 24, 12, 24, 6, 24, 6, 24, 6, 24, 14,
  24, 12, 24, 24, 31, 240, 24, 0, 24, 0, 24, 0, 24, 0, 255, 0,
  12, 18, 36, 14, 1, 0, 7, 128, 24, 224, 24, 96, 48, 96, 48, 192,
  48, 128, 55, 0, 49, 128, 48, 64, 48, 96, 48, 112, 48, 48, 48, 48,
  48, 48, 54, 48, 54, 112, 52, 96, 243, 192, 11, 18, 36, 13, 1, 0,
  96, 0, 96, 0, 48, 0, 24, 0, 8, 0, 0, 0, 30, 0, 99, 0,
  65, 128, 97, 128, 33, 128, 15, 128, 113, 128, 193, 128, 195, 160, 195, 160,
  197, 160, 121, 192, 11, 18, 36, 13, 1, 0, 1, 128, 3, 128, 3, 0,
  4, 0, 8, 0, 0, 0, 62, 0, 65, 0, 65, 128, 97, 128, 33, 128,
  15, 128, 113, 128, 193, 128, 193, 160, 195, 160, 197, 160, 120, 192, 11, 18,
  36, 13, 1, 0, 8, 0, 12, 0, 28, 0, 50, 0, 65, 0, 0, 0,
  30, 0, 99, 0, 65, 128, 97, 128, 33, 128, 15, 128, 113, 128, 193, 128,
  195, 160, 195, 160, 197, 160, 121, 192, 11, 17, 34, 13, 1, 0, 56, 128,
  79, 0, 0, 0, 0, 0, 0, 0, 30, 0, 99, 0, 65, 128, 97, 128,
  33, 128, 15, 128, 113, 128, 193, 128, 195, 160, 195, 160, 197, 160, 121, 192,
  11, 17, 34, 13, 1, 0, 99, 0, 99, 0, 1, 0, 0, 0, 0, 0,
  60, 0, 67, 0, 67, 0, 99, 0, 3, 0, 15, 0, 115, 0, 195, 0,
  195, 32, 199, 32, 203, 32, 121, 192, 11, 18, 36, 13, 1, 0, 28, 0,
  34, 0, 34, 0, 34, 0, 28, 0, 0, 0, 60, 0, 67, 0, 67, 0,
  99, 0, 35, 0, 15, 0, 115, 0, 195, 0, 195, 32, 199, 32, 199, 32,
  121, 192, 16, 12, 24, 18, 1, 0, 30, 120, 99, 198, 65, 134, 97, 131,
  1, 131, 31, 255, 97, 128, 193, 128, 195, 129, 195, 130, 196, 194, 120, 124,
  9, 18, 36, 11, 1, 250, 30, 0, 33, 0, 96, 128, 193, 128, 193, 128,
  192, 0, 192, 0, 192, 0, 192, 0, 96, 128, 33, 0, 30, 0, 8, 0,
  12, 0, 2, 0, 3, 0, 3, 0, 30, 0, 9, 18, 36, 12, 1, 0,
  96, 0, 112, 0, 48, 0, 8, 0, 0, 0, 0, 0, 30, 0, 35, 0,
  97, 128, 193, 128, 193, 128, 255, 128, 192, 0, 192, 0, 192, 128, 96, 128,
  33, 0, 30, 0, 9, 18, 36, 12, 1, 0, 1, 0, 3, 0, 2, 0,
  4, 0, 8, 0, 0, 0, 30, 0, 35, 0, 97, 128, 193, 128, 193, 128,
  255, 128, 192, 0, 192, 0, 192, 128, 96, 128, 33, 0, 30, 0, 9, 18,
  36, 12, 1, 0, 8, 0, 12, 0, 28, 0, 18, 0, 33, 0, 0, 0,
  30, 0, 35, 0, 97, 128, 193, 128, 193, 128, 255, 128, 192, 0, 192, 0,
  192, 128, 96, 128, 33, 0, 30, 0, 9, 17, 34, 12, 1, 0, 51, 0,
  51, 0, 1, 0, 0, 0, 0, 0, 30, 0, 35, 0, 97, 128, 193, 128,
  193, 128, 255, 128, 192, 0, 192, 0, 192, 128, 96, 128, 33, 0, 30, 0,
  7, 18, 18, 8, 0, 0, 192, 224, 96, 16, 8, 0, 120, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 126, 6, 18, 18, 7, 1, 0, 4, 12,
  24, 16, 32, 0, 240, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 252,
  8, 17, 17, 8, 0, 0, 24, 56, 36, 195, 0, 120, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 126, 7, 17, 17, 9, 1, 0, 4, 198, 198,
  0, 0, 120, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 124, 10, 18,
  36, 13, 1, 0, 56, 128, 27, 0, 12, 0, 22, 0, 35, 0, 3, 0,
  31, 128, 33, 128, 97, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 97, 128, 33, 128, 30, 0, 13, 17, 34, 15, 1, 0, 14, 64,
  19, 192, 0, 0, 0, 0, 0, 0, 243, 192, 52, 192, 56, 96, 56, 96,
  48, 96, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96, 253, 248,
  10, 18, 36, 13, 1, 0, 96, 0, 48, 0, 16, 0, 8, 0, 4, 0,
  0, 0, 30, 0, 33, 128, 97, 128, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 97, 128, 33, 128, 30, 0, 10, 18, 36, 13, 1, 0,
  1, 128, 3, 128, 3, 0, 4, 0, 0, 0, 0, 0, 30, 0, 33, 128,
  97, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 97, 128,
  33, 128, 30, 0, 10, 18, 36, 13, 1, 0, 4, 0, 12, 0, 14, 0,
  18, 0, 33, 0, 0, 0, 30, 0, 33, 128, 97, 128, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 97, 128, 33, 128, 30, 0, 10, 17,
  34, 13, 1, 0, 60, 128, 47, 0, 0, 0, 0, 0, 0, 0, 30, 0,
  33, 128, 97, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  97, 128, 33, 128, 30, 0, 10, 17, 34, 13, 1, 0, 49, 128, 49, 128,
  1, 0, 0, 0, 0, 0, 30, 0, 33, 128, 97, 128, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 97, 128, 33, 128, 30, 0, 22, 16,
  48, 24, 1, 255, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 252, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 0, 0, 112,
  0, 0, 112, 0, 10, 12, 24, 13, 1, 0, 30, 64, 33, 128, 96, 128,
  193, 192, 194, 192, 196, 192, 200, 192, 208, 192, 208, 192, 97, 128, 97, 128,
  158, 0, 13, 18, 36, 14, 0, 0, 16, 0, 24, 0, 12, 0, 4, 0,
  2, 0, 0, 0, 241, 224, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96,
  48, 96, 48, 96, 48, 224, 48, 224, 57, 96, 30, 120, 13, 18, 36, 14,
  0, 0, 0, 192, 0, 192, 1, 128, 2, 0, 0, 0, 0, 0, 241, 224,
  48, 96, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96, 48, 224,
  48, 224, 57, 96, 30, 120, 13, 18, 36, 14, 0, 0, 2, 0, 6, 0,
  5, 0, 8, 128, 16, 0, 0, 0, 241, 224, 48, 96, 48, 96, 48, 96,
  48, 96, 48, 96, 48, 96, 48, 96, 48, 224, 48, 224, 57, 96, 30, 120,
  13, 17, 34, 14, 0, 0, 24, 192, 24, 192, 0, 0, 0, 0, 0, 0,
  240, 224, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96,
  48, 224, 48, 224, 57, 96, 30, 120, 13, 24, 48, 14, 0, 250, 0, 96,
  0, 224, 0, 192, 1, 0, 0, 0, 0, 0, 252, 248, 56, 32, 24, 32,
  24, 64, 12, 64, 12, 64, 12, 128, 6, 128, 6, 128, 7, 0, 3, 0,
  3, 0, 3, 0, 2, 0, 34, 0, 98, 0, 100, 0, 56, 0, 11, 24,
  48, 14, 1, 250, 48, 0, 240, 0, 48, 0, 48, 0, 48, 0, 48, 0,
  49, 192, 54, 224, 52, 96, 56, 96, 56, 96, 48, 96, 48, 192, 48, 192,
  49, 128, 49, 0, 50, 0, 60, 0, 48, 0, 48, 0, 48, 0, 48, 0,
  48, 0, 96, 0, 13, 23, 46, 14, 0, 250, 8, 64, 12, 96, 12, 96,
  0, 0, 0, 0, 252, 120, 24, 32, 24, 32, 24, 64, 12, 64, 12, 64,
  14, 128, 6, 128, 6, 128, 7, 0, 3, 0, 3, 0, 2, 0, 2, 0,
  34, 0, 114, 0, 100, 0, 56, 0
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--26-260-72-72-P-138-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 0, '1' Height: 18
  Calculated Max Values w=22 h=24 x= 3 y= 8 dx=24 dy= 0 ascent=18 len=66
  Font Bounding box     w=68 h=33 x=-21 y=-8
  Calculated Min Values           x= 0 y=-6 dx= 0 dy= 0
  Pure Font   ascent =18 descent= 0
  X Font      ascent =18 descent= 0
  Max Font    ascent =18 descent=-6
*/
const u8g_fntpgm_uint8_t u8g_font_osr18n[613] U8G_FONT_SECTION("u8g_font_osr18n") = {
  0, 68, 33, 235, 248, 18, 0, 0, 0, 0, 42, 58, 0, 18, 250, 18,
  0, 10, 10, 20, 14, 2, 8, 12, 0, 12, 0, 204, 192, 201, 192, 43,
  0, 28, 0, 123, 128, 201, 192, 12, 0, 12, 0, 22, 22, 66, 24, 1,
  252, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0,
  0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 255,
  255, 252, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16,
  0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0,
  0, 16, 0, 3, 8, 8, 7, 2, 252, 192, 224, 224, 32, 32, 64, 64,
  128, 7, 1, 1, 11, 2, 6, 254, 3, 3, 3, 7, 2, 0, 224, 224,
  224, 8, 24, 24, 12, 2, 250, 1, 1, 2, 2, 2, 4, 4, 4, 12,
  8, 8, 24, 16, 16, 16, 32, 32, 32, 64, 64, 64, 128, 128, 128, 12,
  18, 36, 15, 1, 0, 15, 0, 16, 192, 32, 64, 96, 96, 96, 32, 192,
  48, 192, 48, 192, 48, 192, 48, 192, 48, 192, 48, 192, 48, 192, 48, 96,
  32, 96, 96, 32, 64, 16, 192, 15, 0, 9, 18, 36, 15, 3, 0, 8,
  0, 8, 0, 24, 0, 248, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24,
  0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24,
  0, 255, 128, 10, 18, 36, 15, 2, 0, 30, 0, 99, 128, 129, 192, 128,
  192, 128, 192, 224, 192, 240, 192, 32, 192, 1, 128, 3, 0, 6, 0, 8,
  0, 16, 0, 32, 0, 64, 64, 192, 64, 255, 192, 255, 192, 11, 18, 36,
  15, 2, 0, 63, 0, 97, 128, 192, 192, 224, 192, 240, 192, 0, 192, 0,
  192, 1, 128, 62, 0, 1, 128, 0, 192, 0, 96, 96, 96, 240, 96, 240,
  96, 192, 192, 65, 128, 63, 0, 12, 18, 36, 15, 2, 0, 1, 0, 3,
  0, 3, 0, 7, 0, 15, 0, 11, 0, 19, 0, 51, 0, 35, 0, 67,
  0, 195, 0, 131, 0, 255, 224, 3, 0, 3, 0, 3, 0, 3, 0, 31,
  240, 11, 18, 36, 15, 2, 0, 96, 192, 127, 128, 126, 0, 64, 0, 64,
  0, 64, 0, 95, 0, 97, 128, 64, 192, 64, 224, 0, 96, 0, 96, 96,
  96, 240, 96, 224, 192, 192, 192, 65, 128, 62, 0, 11, 18, 36, 15, 2,
  0, 15, 0, 24, 128, 48, 64, 96, 192, 96, 192, 64, 0, 192, 0, 207,
  0, 209, 192, 224, 192, 224, 224, 224, 96, 224, 96, 224, 96, 96, 224, 96,
  192, 49, 128, 15, 0, 10, 18, 36, 15, 3, 0, 255, 192, 255, 192, 128,
  64, 128, 64, 128, 128, 0, 128, 1, 0, 1, 0, 2, 0, 6, 0, 6,
  0, 12, 0, 12, 0, 30, 0, 30, 0, 30, 0, 30, 0, 14, 0, 12,
  18, 36, 15, 2, 0, 31, 128, 48, 224, 96, 96, 192, 48, 192, 48, 224,
  48, 240, 32, 124, 64, 63, 128, 55, 224, 96, 240, 192, 112, 192, 48, 192,
  48, 192, 48, 96, 96, 112, 192, 31, 128, 11, 18, 36, 15, 2, 0, 30,
  0, 49, 128, 96, 192, 224, 192, 192, 64, 192, 96, 192, 96, 192, 224, 96,
  224, 113, 96, 30, 96, 0, 96, 0, 64, 96, 192, 96, 192, 64, 128, 65,
  0, 62, 0, 3, 12, 12, 7, 2, 0, 224, 224, 224, 0, 0, 0, 0,
  0, 0, 224, 224, 224
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--26-260-72-72-P-138-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 18, '1' Height: 18
  Calculated Max Values w=26 h=24 x= 3 y=13 dx=28 dy= 0 ascent=20 len=72
  Font Bounding box     w=68 h=33 x=-21 y=-8
  Calculated Min Values           x=-1 y=-6 dx= 0 dy= 0
  Pure Font   ascent =18 descent=-6
  X Font      ascent =19 descent=-6
  Max Font    ascent =20 descent=-6
*/
const u8g_fntpgm_uint8_t u8g_font_osr18r[3683] U8G_FONT_SECTION("u8g_font_osr18r") = {
  0, 68, 33, 235, 248, 18, 4, 197, 10, 125, 32, 127, 250, 20, 250, 19,
  250, 0, 0, 0, 7, 0, 0, 3, 18, 18, 7, 2, 0, 224, 224, 224,
  224, 224, 224, 64, 64, 64, 64, 64, 64, 64, 64, 0, 224, 224, 224, 6,
  5, 5, 10, 2, 13, 204, 204, 204, 204, 72, 14, 18, 36, 18, 2, 0,
  4, 32, 4, 32, 4, 32, 4, 32, 4, 32, 255, 252, 8, 64, 8, 64,
  8, 64, 8, 64, 8, 64, 24, 64, 255, 252, 16, 128, 16, 128, 16, 128,
  16, 128, 16, 128, 11, 22, 44, 15, 2, 254, 9, 0, 9, 0, 31, 128,
  41, 64, 73, 32, 73, 32, 73, 96, 73, 96, 105, 0, 61, 0, 31, 128,
  15, 192, 9, 192, 9, 96, 233, 32, 233, 32, 201, 32, 201, 64, 105, 64,
  31, 128, 9, 0, 9, 0, 18, 18, 54, 22, 2, 0, 56, 2, 0, 68,
  4, 0, 198, 8, 0, 198, 8, 0, 198, 16, 0, 198, 32, 0, 198, 32,
  0, 68, 64, 0, 56, 64, 0, 0, 134, 0, 1, 25, 128, 1, 48, 128,
  2, 48, 192, 4, 48, 192, 4, 48, 192, 8, 48, 192, 8, 24, 128, 16,
  15, 0, 18, 18, 54, 20, 1, 0, 7, 128, 0, 8, 64, 0, 24, 64,
  0, 24, 64, 0, 24, 192, 0, 28, 128, 0, 15, 0, 0, 6, 31, 192,
  15, 6, 0, 23, 6, 0, 35, 132, 0, 97, 196, 0, 192, 232, 0, 192,
  240, 0, 192, 112, 0, 224, 120, 128, 96, 220, 128, 63, 15, 0, 2, 5,
  5, 7, 2, 13, 192, 192, 192, 192, 64, 6, 23, 23, 10, 3, 252, 8,
  16, 48, 32, 64, 64, 192, 128, 128, 128, 128, 128, 128, 128, 128, 192, 64,
  64, 96, 32, 16, 24, 12, 6, 23, 23, 9, 1, 252, 64, 32, 48, 16,
  24, 8, 8, 12, 4, 4, 4, 4, 4, 4, 12, 8, 8, 8, 16, 16,
  32, 64, 192, 10, 10, 20, 14, 2, 8, 12, 0, 12, 0, 204, 192, 201,
  192, 43, 0, 28, 0, 123, 128, 201, 192, 12, 0, 12, 0, 22, 22, 66,
  24, 1, 252, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0,
  16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16,
  0, 255, 255, 252, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0,
  0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0, 16, 0, 0,
  16, 0, 0, 16, 0, 3, 8, 8, 7, 2, 252, 192, 224, 224, 32, 32,
  64, 64, 128, 7, 1, 1, 11, 2, 6, 254, 3, 3, 3, 7, 2, 0,
  224, 224, 224, 8, 24, 24, 12, 2, 250, 1, 1, 2, 2, 2, 4, 4,
  4, 12, 8, 8, 24, 16, 16, 16, 32, 32, 32, 64, 64, 64, 128, 128,
  128, 12, 18, 36, 15, 1, 0, 15, 0, 16, 192, 32, 64, 96, 96, 96,
  32, 192, 48, 192, 48, 192, 48, 192, 48, 192, 48, 192, 48, 192, 48, 192,
  48, 96, 32, 96, 96, 32, 64, 16, 192, 15, 0, 9, 18, 36, 15, 3,
  0, 8, 0, 8, 0, 24, 0, 248, 0, 24, 0, 24, 0, 24, 0, 24,
  0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24,
  0, 24, 0, 255, 128, 10, 18, 36, 15, 2, 0, 30, 0, 99, 128, 129,
  192, 128, 192, 128, 192, 224, 192, 240, 192, 32, 192, 1, 128, 3, 0, 6,
  0, 8, 0, 16, 0, 32, 0, 64, 64, 192, 64, 255, 192, 255, 192, 11,
  18, 36, 15, 2, 0, 63, 0, 97, 128, 192, 192, 224, 192, 240, 192, 0,
  192, 0, 192, 1, 128, 62, 0, 1, 128, 0, 192, 0, 96, 96, 96, 240,
  96, 240, 96, 192, 192, 65, 128, 63, 0, 12, 18, 36, 15, 2, 0, 1,
  0, 3, 0, 3, 0, 7, 0, 15, 0, 11, 0, 19, 0, 51, 0, 35,
  0, 67, 0, 195, 0, 131, 0, 255, 224, 3, 0, 3, 0, 3, 0, 3,
  0, 31, 240, 11, 18, 36, 15, 2, 0, 96, 192, 127, 128, 126, 0, 64,
  0, 64, 0, 64, 0, 95, 0, 97, 128, 64, 192, 64, 224, 0, 96, 0,
  96, 96, 96, 240, 96, 224, 192, 192, 192, 65, 128, 62, 0, 11, 18, 36,
  15, 2, 0, 15, 0, 24, 128, 48, 64, 96, 192, 96, 192, 64, 0, 192,
  0, 207, 0, 209, 192, 224, 192, 224, 224, 224, 96, 224, 96, 224, 96, 96,
  224, 96, 192, 49, 128, 15, 0, 10, 18, 36, 15, 3, 0, 255, 192, 255,
  192, 128, 64, 128, 64, 128, 128, 0, 128, 1, 0, 1, 0, 2, 0, 6,
  0, 6, 0, 12, 0, 12, 0, 30, 0, 30, 0, 30, 0, 30, 0, 14,
  0, 12, 18, 36, 15, 2, 0, 31, 128, 48, 224, 96, 96, 192, 48, 192,
  48, 224, 48, 240, 32, 124, 64, 63, 128, 55, 224, 96, 240, 192, 112, 192,
  48, 192, 48, 192, 48, 96, 96, 112, 192, 31, 128, 11, 18, 36, 15, 2,
  0, 30, 0, 49, 128, 96, 192, 224, 192, 192, 64, 192, 96, 192, 96, 192,
  224, 96, 224, 113, 96, 30, 96, 0, 96, 0, 64, 96, 192, 96, 192, 64,
  128, 65, 0, 62, 0, 3, 12, 12, 7, 2, 0, 224, 224, 224, 0, 0,
  0, 0, 0, 0, 224, 224, 224, 4, 16, 16, 8, 2, 252, 240, 240, 240,
  0, 0, 0, 0, 0, 96, 240, 240, 16, 16, 32, 32, 64, 20, 21, 63,
  24, 2, 253, 0, 0, 48, 0, 0, 192, 0, 3, 0, 0, 12, 0, 0,
  48, 0, 0, 224, 0, 3, 128, 0, 14, 0, 0, 24, 0, 0, 96, 0,
  0, 192, 0, 0, 48, 0, 0, 12, 0, 0, 7, 0, 0, 1, 192, 0,
  0, 112, 0, 0, 24, 0, 0, 6, 0, 0, 1, 128, 0, 0, 96, 0,
  0, 16, 22, 6, 18, 24, 1, 4, 255, 255, 252, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 255, 255, 252, 20, 21, 63, 24, 2, 253,
  192, 0, 0, 48, 0, 0, 12, 0, 0, 3, 0, 0, 0, 192, 0, 0,
  112, 0, 0, 28, 0, 0, 7, 0, 0, 1, 128, 0, 0, 96, 0, 0,
  48, 0, 0, 192, 0, 3, 0, 0, 14, 0, 0, 56, 0, 0, 224, 0,
  1, 128, 0, 6, 0, 0, 24, 0, 0, 96, 0, 0, 128, 0, 0, 9,
  18, 36, 12, 2, 0, 62, 0, 67, 0, 129, 128, 129, 128, 225, 128, 97,
  128, 3, 0, 6, 0, 12, 0, 16, 0, 48, 0, 34, 0, 34, 0, 28,
  0, 0, 0, 28, 0, 28, 0, 28, 0, 18, 18, 54, 20, 1, 0, 3,
  248, 0, 12, 6, 0, 16, 109, 0, 33, 156, 128, 67, 12, 128, 70, 8,
  64, 142, 8, 64, 142, 24, 64, 140, 24, 64, 140, 16, 64, 140, 48, 128,
  140, 48, 128, 140, 241, 0, 71, 30, 0, 96, 0, 0, 32, 0, 0, 24,
  12, 0, 7, 240, 0, 18, 18, 54, 20, 2, 0, 0, 128, 0, 0, 192,
  0, 1, 192, 0, 1, 192, 0, 1, 224, 0, 3, 224, 0, 2, 96, 0,
  2, 112, 0, 6, 112, 0, 4, 48, 0, 4, 56, 0, 12, 56, 0, 15,
  248, 0, 24, 28, 0, 16, 12, 0, 16, 12, 0, 48, 14, 0, 254, 63,
  192, 15, 18, 36, 17, 1, 0, 255, 240, 24, 28, 24, 12, 24, 6, 24,
  6, 24, 6, 24, 12, 24, 24, 31, 224, 24, 24, 24, 12, 24, 6, 24,
  6, 24, 6, 24, 6, 24, 12, 24, 28, 255, 240, 14, 18, 36, 18, 2,
  0, 7, 132, 24, 108, 32, 60, 96, 28, 96, 12, 192, 12, 192, 4, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 4, 96, 4, 96, 4, 32, 8, 48,
  24, 24, 48, 7, 192, 17, 18, 54, 20, 1, 0, 255, 240, 0, 24, 12,
  0, 24, 6, 0, 24, 3, 0, 24, 3, 0, 24, 1, 128, 24, 1, 128,
  24, 1, 128, 24, 1, 128, 24, 1, 128, 24, 1, 128, 24, 1, 128, 24,
  1, 128, 24, 3, 0, 24, 3, 0, 24, 6, 0, 24, 12, 0, 255, 240,
  0, 15, 18, 36, 18, 1, 0, 255, 254, 24, 6, 24, 2, 24, 2, 24,
  2, 24, 34, 24, 32, 24, 96, 31, 224, 24, 96, 24, 32, 24, 32, 24,
  34, 24, 2, 24, 2, 24, 6, 24, 14, 255, 254, 15, 18, 36, 17, 1,
  0, 255, 254, 24, 6, 24, 2, 24, 2, 24, 2, 24, 34, 24, 32, 24,
  96, 31, 224, 24, 96, 24, 32, 24, 32, 24, 32, 24, 0, 24, 0, 24,
  0, 24, 0, 127, 0, 17, 18, 54, 19, 2, 0, 7, 196, 0, 24, 100,
  0, 48, 28, 0, 96, 28, 0, 96, 12, 0, 96, 4, 0, 192, 4, 0,
  192, 0, 0, 192, 127, 128, 192, 28, 0, 192, 28, 0, 192, 28, 0, 192,
  28, 0, 96, 28, 0, 96, 28, 0, 48, 52, 0, 24, 100, 0, 7, 132,
  0, 18, 18, 54, 20, 1, 0, 255, 63, 192, 24, 6, 0, 24, 6, 0,
  24, 6, 0, 24, 6, 0, 24, 6, 0, 24, 6, 0, 24, 6, 0, 31,
  254, 0, 24, 6, 0, 24, 6, 0, 24, 6, 0, 24, 6, 0, 24, 6,
  0, 24, 6, 0, 24, 6, 0, 24, 6, 0, 255, 63, 192, 8, 18, 18,
  10, 1, 0, 255, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 255, 12, 18, 36, 14, 1, 0, 7, 240, 1, 128, 1,
  128, 1, 128, 1, 128, 1, 128, 1, 128, 1, 128, 1, 128, 1, 128, 1,
  128, 1, 128, 97, 128, 241, 128, 225, 128, 193, 128, 67, 0, 62, 0, 17,
  18, 54, 19, 1, 0, 255, 63, 128, 24, 14, 0, 24, 8, 0, 24, 16,
  0, 24, 32, 0, 24, 64, 0, 24, 128, 0, 25, 192, 0, 26, 192, 0,
  28, 224, 0, 24, 96, 0, 24, 112, 0, 24, 56, 0, 24, 56, 0, 24,
  28, 0, 24, 28, 0, 24, 14, 0, 255, 127, 128, 15, 18, 36, 17, 1,
  0, 255, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24,
  0, 24, 0, 24, 0, 24, 0, 24, 2, 24, 2, 24, 2, 24, 6, 24,
  6, 24, 14, 255, 254, 20, 18, 54, 22, 1, 0, 252, 3, 240, 28, 3,
  128, 30, 5, 128, 22, 5, 128, 22, 5, 128, 23, 5, 128, 19, 9, 128,
  19, 9, 128, 19, 137, 128, 19, 145, 128, 17, 145, 128, 17, 209, 128, 17,
  209, 128, 16, 225, 128, 16, 225, 128, 16, 225, 128, 16, 65, 128, 254, 79,
  240, 18, 18, 54, 19, 1, 0, 252, 15, 192, 28, 2, 0, 30, 2, 0,
  22, 2, 0, 23, 2, 0, 19, 130, 0, 17, 130, 0, 17, 194, 0, 16,
  226, 0, 16, 226, 0, 16, 114, 0, 16, 50, 0, 16, 58, 0, 16, 30,
  0, 16, 14, 0, 16, 14, 0, 16, 6, 0, 254, 2, 0, 15, 18, 36,
  18, 2, 0, 7, 192, 24, 48, 48, 24, 32, 8, 96, 12, 96, 12, 192,
  6, 192, 6, 192, 6, 192, 6, 192, 6, 192, 6, 96, 12, 96, 12, 32,
  8, 48, 24, 24, 48, 7, 192, 15, 18, 36, 17, 1, 0, 255, 240, 24,
  28, 24, 12, 24, 6, 24, 6, 24, 6, 24, 12, 24, 24, 31, 240, 24,
  0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 24, 0, 255,
  0, 15, 22, 44, 18, 2, 252, 7, 192, 24, 48, 48, 24, 32, 8, 96,
  12, 96, 12, 192, 6, 192, 6, 192, 6, 192, 6, 192, 6, 192, 6, 96,
  12, 99, 140, 36, 76, 52, 120, 28, 114, 7, 226, 0, 98, 0, 118, 0,
  60, 0, 24, 17, 18, 54, 19, 1, 0, 255, 240, 0, 24, 24, 0, 24,
  12, 0, 24, 12, 0, 24, 12, 0, 24, 12, 0, 24, 24, 0, 31, 224,
  0, 24, 48, 0, 24, 56, 0, 24, 24, 0, 24, 24, 0, 24, 24, 0,
  24, 28, 128, 24, 28, 128, 24, 28, 128, 24, 31, 0, 255, 15, 0, 13,
  18, 36, 16, 2, 0, 30, 32, 97, 160, 192, 96, 192, 96, 192, 32, 192,
  32, 224, 0, 124, 0, 63, 128, 15, 224, 129, 240, 128, 112, 128, 24, 192,
  24, 192, 24, 224, 16, 152, 32, 135, 192, 15, 18, 36, 18, 2, 0, 255,
  254, 195, 14, 131, 6, 131, 2, 3, 2, 3, 2, 3, 2, 3, 0, 3,
  0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3, 0, 3,
  0, 31, 240, 19, 18, 54, 21, 1, 0, 255, 15, 224, 24, 1, 0, 24,
  1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1,
  0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0, 24, 1, 0,
  24, 1, 0, 12, 1, 0, 12, 2, 0, 6, 4, 0, 1, 248, 0, 18,
  18, 54, 20, 1, 0, 255, 31, 192, 28, 3, 0, 28, 2, 0, 12, 2,
  0, 14, 6, 0, 6, 4, 0, 7, 4, 0, 7, 8, 0, 3, 8, 0,
  3, 136, 0, 3, 144, 0, 1, 144, 0, 1, 208, 0, 0, 224, 0, 0,
  224, 0, 0, 224, 0, 0, 64, 0, 0, 64, 0, 26, 18, 72, 28, 1,
  0, 255, 63, 159, 192, 28, 14, 3, 0, 12, 6, 2, 0, 12, 14, 2,
  0, 14, 15, 6, 0, 14, 15, 4, 0, 6, 19, 4, 0, 7, 19, 140,
  0, 7, 19, 136, 0, 3, 49, 136, 0, 3, 161, 216, 0, 3, 161, 208,
  0, 1, 160, 208, 0, 1, 192, 240, 0, 1, 192, 224, 0, 0, 192, 96,
  0, 0, 128, 96, 0, 0, 128, 64, 0, 18, 18, 54, 20, 1, 0, 127,
  191, 128, 14, 12, 0, 14, 12, 0, 7, 8, 0, 7, 16, 0, 3, 176,
  0, 1, 160, 0, 1, 192, 0, 0, 192, 0, 0, 224, 0, 1, 96, 0,
  3, 112, 0, 2, 56, 0, 4, 56, 0, 12, 28, 0, 8, 12, 0, 24,
  14, 0, 254, 63, 192, 17, 18, 54, 19, 1, 0, 255, 31, 128, 28, 6,
  0, 28, 4, 0, 14, 4, 0, 6, 8, 0, 7, 8, 0, 3, 144, 0,
  3, 160, 0, 1, 224, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0,
  192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 7, 252,
  0, 14, 18, 36, 17, 2, 0, 127, 252, 112, 56, 96, 48, 64, 112, 64,
  224, 128, 192, 1, 192, 3, 128, 3, 0, 7, 0, 14, 0, 12, 4, 28,
  4, 56, 4, 48, 12, 112, 28, 224, 56, 255, 248, 5, 23, 23, 10, 3,
  251, 248, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 248, 8, 24, 24, 12, 2, 250, 128, 128,
  128, 64, 64, 64, 32, 32, 32, 16, 16, 16, 16, 8, 8, 8, 4, 4,
  4, 2, 2, 2, 1, 1, 5, 23, 23, 10, 2, 251, 248, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 248, 11, 9, 18, 15, 2, 9, 4, 0, 14, 0, 10, 0, 17,
  0, 49, 128, 32, 128, 64, 64, 64, 96, 128, 32, 14, 1, 2, 14, 0,
  252, 255, 252, 4, 4, 4, 11, 2, 13, 192, 224, 96, 16, 11, 12, 24,
  13, 1, 0, 30, 0, 99, 0, 65, 128, 97, 128, 33, 128, 15, 128, 113,
  128, 193, 128, 195, 160, 195, 160, 197, 160, 121, 192, 11, 18, 36, 13, 0,
  0, 240, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 51, 128, 52,
  192, 56, 96, 56, 96, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96, 56,
  96, 40, 192, 39, 128, 9, 12, 24, 11, 1, 0, 30, 0, 33, 0, 96,
  128, 193, 128, 193, 128, 192, 0, 192, 0, 192, 0, 192, 128, 96, 128, 33,
  0, 30, 0, 12, 18, 36, 14, 1, 0, 7, 192, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 192, 28, 192, 98, 192, 97, 192, 193, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 97, 192, 97, 192, 30, 240, 9, 12, 24,
  12, 1, 0, 30, 0, 35, 0, 97, 128, 193, 128, 193, 128, 255, 128, 192,
  0, 192, 0, 192, 128, 96, 128, 33, 0, 30, 0, 9, 18, 36, 9, 1,
  0, 15, 0, 24, 128, 49, 128, 49, 0, 48, 0, 48, 0, 254, 0, 48,
  0, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48,
  0, 48, 0, 254, 0, 12, 18, 36, 15, 2, 250, 30, 112, 97, 176, 225,
  240, 192, 192, 192, 192, 192, 192, 225, 128, 97, 128, 30, 0, 224, 0, 255,
  0, 127, 192, 64, 96, 128, 32, 128, 32, 128, 32, 192, 64, 63, 128, 13,
  18, 36, 15, 1, 0, 240, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48,
  0, 51, 192, 52, 192, 56, 96, 56, 96, 48, 96, 48, 96, 48, 96, 48,
  96, 48, 96, 48, 96, 48, 96, 253, 248, 6, 18, 18, 8, 1, 0, 112,
  112, 32, 0, 0, 0, 240, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  252, 7, 24, 24, 8, 255, 250, 6, 6, 0, 0, 0, 0, 62, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 198, 198, 140, 120, 12,
  18, 36, 14, 1, 0, 240, 0, 48, 0, 48, 0, 48, 0, 48, 0, 48,
  0, 49, 240, 48, 128, 49, 0, 50, 0, 50, 0, 54, 0, 59, 0, 51,
  0, 49, 128, 49, 192, 48, 224, 253, 240, 6, 18, 18, 8, 1, 0, 240,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  252, 19, 12, 36, 21, 1, 0, 243, 199, 0, 52, 249, 128, 56, 113, 192,
  56, 97, 192, 48, 97, 192, 48, 97, 192, 48, 97, 192, 48, 97, 192, 48,
  97, 192, 48, 97, 192, 48, 97, 192, 253, 251, 224, 13, 12, 24, 15, 1,
  0, 243, 192, 52, 192, 56, 96, 56, 96, 48, 96, 48, 96, 48, 96, 48,
  96, 48, 96, 48, 96, 48, 96, 253, 248, 10, 12, 24, 13, 1, 0, 30,
  0, 33, 128, 97, 128, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 97, 128, 33, 128, 30, 0, 11, 18, 36, 14, 1, 250, 243, 128, 52,
  192, 56, 96, 56, 96, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96, 56,
  96, 56, 192, 55, 128, 48, 0, 48, 0, 48, 0, 48, 0, 48, 0, 252,
  0, 12, 18, 36, 13, 1, 250, 28, 64, 98, 64, 97, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 97, 192, 97, 192, 30, 192, 0,
  192, 0, 192, 0, 192, 0, 192, 0, 192, 3, 240, 9, 12, 24, 11, 1,
  0, 243, 128, 52, 128, 57, 128, 56, 128, 56, 0, 48, 0, 48, 0, 48,
  0, 48, 0, 48, 0, 48, 0, 252, 0, 9, 12, 24, 11, 1, 0, 125,
  0, 131, 0, 129, 0, 193, 0, 240, 0, 124, 0, 31, 0, 131, 128, 128,
  128, 192, 128, 224, 128, 159, 0, 8, 17, 17, 10, 1, 0, 16, 16, 16,
  48, 48, 254, 48, 48, 48, 48, 48, 48, 48, 49, 49, 51, 30, 13, 12,
  24, 14, 0, 0, 241, 224, 48, 96, 48, 96, 48, 96, 48, 96, 48, 96,
  48, 96, 48, 96, 48, 224, 48, 224, 57, 96, 30, 120, 13, 12, 24, 14,
  1, 0, 252, 248, 48, 96, 48, 64, 24, 64, 24, 128, 12, 128, 12, 128,
  13, 0, 7, 0, 7, 0, 2, 0, 2, 0, 19, 12, 36, 21, 1, 0,
  253, 251, 224, 48, 96, 128, 48, 96, 128, 24, 113, 0, 24, 177, 0, 12,
  177, 0, 12, 154, 0, 13, 26, 0, 7, 28, 0, 7, 12, 0, 2, 12,
  0, 2, 8, 0, 12, 12, 24, 14, 1, 0, 249, 224, 48, 128, 57, 0,
  25, 0, 14, 0, 14, 0, 6, 0, 11, 0, 19, 0, 17, 128, 33, 192,
  243, 240, 13, 18, 36, 14, 0, 250, 252, 248, 56, 32, 24, 32, 24, 64,
  12, 64, 12, 64, 12, 128, 6, 128, 6, 128, 7, 0, 3, 0, 3, 0,
  2, 0, 2, 0, 34, 0, 98, 0, 100, 0, 56, 0, 9, 12, 24, 12,
  1, 0, 255, 128, 195, 128, 131, 0, 134, 0, 142, 0, 12, 0, 24, 0,
  56, 0, 48, 128, 96, 128, 96, 128, 255, 128, 6, 23, 23, 12, 3, 251,
  12, 16, 48, 48, 48, 48, 56, 24, 24, 24, 16, 224, 48, 16, 24, 24,
  56, 48, 48, 48, 48, 16, 12, 1, 24, 24, 7, 3, 250, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 6, 23, 23, 11, 3, 251, 192, 32, 48, 48, 48,
  112, 96, 96, 96, 96, 32, 28, 48, 96, 96, 96, 96, 112, 48, 48, 48,
  32, 192, 15, 5, 10, 17, 1, 4, 32, 4, 254, 2, 143, 194, 129, 254,
  64, 124, 255
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--29-290-72-72-P-153-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 21, '1' Height: 21
  Calculated Max Values w=29 h=28 x= 6 y=17 dx=32 dy= 0 ascent=28 len=88
  Font Bounding box     w=76 h=38 x=-24 y=-9
  Calculated Min Values           x=-1 y=-8 dx= 0 dy= 0
  Pure Font   ascent =21 descent=-7
  X Font      ascent =22 descent=-7
  Max Font    ascent =28 descent=-8
*/
const u8g_fntpgm_uint8_t u8g_font_osr21[9530] U8G_FONT_SECTION("u8g_font_osr21") = {
  0, 76, 38, 232, 247, 21, 5, 131, 12, 189, 32, 255, 249, 28, 248, 22,
  249, 0, 0, 0, 8, 0, 0, 4, 21, 21, 8, 2, 0, 96, 240, 240,
  240, 240, 240, 96, 96, 96, 96, 96, 96, 96, 96, 96, 64, 0, 96, 240,
  240, 96, 7, 5, 5, 11, 2, 17, 238, 204, 204, 204, 68, 15, 21, 42,
  19, 2, 0, 2, 16, 6, 16, 6, 16, 4, 16, 4, 48, 4, 48, 255,
  254, 4, 32, 12, 32, 12, 32, 8, 32, 8, 96, 8, 96, 8, 64, 255,
  254, 24, 64, 24, 64, 16, 192, 16, 192, 16, 128, 16, 128, 13, 25, 50,
  17, 2, 254, 5, 0, 5, 0, 15, 128, 53, 96, 37, 16, 69, 24, 69,
  24, 69, 56, 69, 56, 117, 48, 61, 0, 63, 0, 15, 192, 7, 224, 5,
  240, 5, 48, 101, 24, 229, 24, 229, 24, 197, 24, 69, 48, 69, 32, 61,
  192, 7, 0, 5, 0, 19, 21, 63, 25, 3, 0, 60, 1, 0, 70, 2,
  0, 66, 2, 0, 195, 4, 0, 195, 8, 0, 195, 8, 0, 195, 16, 0,
  195, 16, 0, 66, 32, 0, 102, 32, 0, 56, 64, 0, 0, 67, 0, 0,
  140, 192, 1, 8, 64, 1, 24, 96, 2, 24, 96, 2, 24, 96, 4, 24,
  96, 4, 24, 96, 8, 8, 64, 8, 7, 128, 20, 21, 63, 23, 2, 0,
  3, 128, 0, 12, 64, 0, 8, 32, 0, 24, 32, 0, 24, 32, 0, 24,
  96, 0, 28, 64, 0, 12, 128, 0, 15, 0, 0, 7, 15, 240, 15, 1,
  128, 27, 129, 0, 51, 193, 0, 97, 194, 0, 96, 226, 0, 224, 244, 0,
  224, 124, 0, 224, 56, 0, 224, 60, 0, 96, 60, 32, 59, 198, 192, 3,
  5, 5, 7, 2, 17, 224, 192, 192, 192, 64, 6, 28, 28, 10, 3, 250,
  4, 12, 24, 16, 32, 32, 64, 64, 64, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 192, 64, 64, 32, 32, 16, 24, 8, 4, 6, 28, 28, 11,
  2, 250, 128, 192, 64, 32, 48, 16, 24, 8, 8, 8, 4, 4, 4, 4,
  4, 4, 4, 4, 12, 8, 8, 24, 16, 48, 32, 96, 192, 128, 10, 12,
  24, 14, 2, 9, 12, 0, 14, 0, 204, 64, 228, 192, 117, 192, 14, 0,
  30, 0, 229, 192, 196, 192, 12, 0, 14, 0, 12, 0, 24, 25, 75, 26,
  1, 252, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8,
  0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0,
  0, 8, 0, 0, 8, 0, 255, 255, 255, 0, 8, 0, 0, 8, 0, 0,
  8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8,
  0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 4, 8, 8,
  8, 2, 251, 224, 240, 240, 16, 16, 16, 32, 64, 7, 2, 2, 11, 2,
  7, 254, 254, 4, 4, 4, 8, 2, 0, 96, 240, 240, 96, 9, 28, 56,
  13, 2, 250, 0, 128, 0, 128, 1, 128, 1, 0, 1, 0, 1, 0, 2,
  0, 2, 0, 2, 0, 6, 0, 4, 0, 4, 0, 12, 0, 8, 0, 8,
  0, 24, 0, 16, 0, 16, 0, 16, 0, 32, 0, 32, 0, 32, 0, 64,
  0, 64, 0, 64, 0, 192, 0, 128, 0, 128, 0, 14, 21, 42, 17, 1,
  0, 7, 128, 24, 64, 48, 32, 32, 48, 96, 16, 96, 24, 96, 24, 224,
  24, 224, 24, 224, 24, 224, 28, 224, 28, 224, 24, 224, 24, 224, 24, 96,
  24, 96, 24, 96, 48, 48, 32, 16, 96, 15, 192, 10, 21, 42, 17, 3,
  0, 2, 0, 6, 0, 6, 0, 14, 0, 254, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 14, 0, 14, 0, 255, 192, 12, 21, 42, 17, 2,
  0, 31, 0, 32, 192, 64, 96, 128, 112, 128, 112, 192, 112, 240, 112, 112,
  112, 32, 96, 0, 224, 0, 192, 1, 0, 6, 0, 12, 0, 24, 0, 48,
  16, 96, 16, 64, 16, 224, 112, 255, 240, 255, 240, 12, 21, 42, 17, 2,
  0, 31, 0, 97, 192, 192, 224, 224, 96, 240, 96, 112, 112, 0, 96, 0,
  96, 0, 224, 48, 192, 63, 0, 0, 192, 0, 96, 0, 112, 0, 112, 96,
  112, 240, 112, 240, 112, 192, 96, 192, 192, 127, 128, 14, 21, 42, 17, 2,
  0, 0, 64, 0, 192, 1, 192, 1, 192, 3, 192, 7, 192, 5, 192, 13,
  192, 9, 192, 17, 192, 49, 192, 33, 192, 65, 192, 193, 192, 255, 252, 1,
  192, 1, 192, 1, 192, 1, 192, 1, 192, 15, 252, 12, 21, 42, 17, 2,
  0, 96, 64, 127, 128, 127, 0, 64, 0, 64, 0, 64, 0, 64, 0, 95,
  0, 96, 192, 64, 96, 64, 96, 0, 112, 0, 112, 0, 112, 96, 112, 240,
  112, 240, 112, 224, 96, 192, 224, 64, 192, 63, 128, 12, 21, 42, 17, 2,
  0, 7, 128, 24, 64, 16, 96, 48, 224, 96, 224, 96, 192, 96, 0, 224,
  0, 231, 128, 232, 192, 240, 96, 240, 96, 224, 112, 224, 112, 224, 112, 224,
  112, 96, 112, 96, 96, 112, 96, 48, 192, 31, 128, 11, 21, 42, 17, 3,
  0, 255, 224, 255, 224, 192, 32, 128, 32, 128, 64, 128, 64, 0, 64, 0,
  128, 1, 0, 1, 0, 2, 0, 6, 0, 6, 0, 12, 0, 12, 0, 12,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 14, 21, 42, 17, 2,
  0, 15, 128, 48, 96, 96, 48, 224, 24, 224, 24, 224, 24, 224, 24, 240,
  16, 124, 32, 63, 192, 15, 224, 51, 240, 96, 248, 224, 56, 224, 28, 224,
  28, 224, 24, 224, 24, 96, 24, 112, 48, 31, 192, 12, 21, 42, 17, 2,
  0, 15, 0, 48, 128, 96, 64, 96, 96, 224, 96, 224, 96, 224, 112, 224,
  112, 224, 112, 96, 112, 96, 240, 49, 176, 14, 48, 0, 48, 0, 32, 48,
  96, 112, 96, 112, 64, 96, 192, 96, 128, 63, 0, 4, 14, 14, 8, 2,
  0, 96, 240, 240, 96, 0, 0, 0, 0, 0, 0, 96, 240, 240, 96, 4,
  18, 18, 8, 2, 251, 96, 240, 240, 96, 0, 0, 0, 0, 0, 0, 224,
  240, 240, 16, 16, 48, 32, 64, 22, 24, 72, 27, 2, 251, 0, 0, 12,
  0, 0, 56, 0, 0, 96, 0, 1, 128, 0, 7, 0, 0, 28, 0, 0,
  112, 0, 0, 192, 0, 3, 0, 0, 14, 0, 0, 56, 0, 0, 224, 0,
  0, 224, 0, 0, 48, 0, 0, 12, 0, 0, 7, 0, 0, 1, 192, 0,
  0, 112, 0, 0, 24, 0, 0, 6, 0, 0, 3, 128, 0, 0, 224, 0,
  0, 56, 0, 0, 12, 24, 7, 21, 26, 1, 5, 255, 255, 255, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
  22, 24, 72, 27, 3, 251, 192, 0, 0, 112, 0, 0, 24, 0, 0, 6,
  0, 0, 3, 128, 0, 0, 224, 0, 0, 56, 0, 0, 12, 0, 0, 3,
  0, 0, 0, 192, 0, 0, 112, 0, 0, 28, 0, 0, 28, 0, 0, 48,
  0, 0, 192, 0, 3, 128, 0, 14, 0, 0, 56, 0, 0, 96, 0, 1,
  128, 0, 7, 0, 0, 28, 0, 0, 112, 0, 0, 192, 0, 0, 11, 21,
  42, 14, 2, 0, 30, 0, 97, 128, 128, 192, 128, 192, 240, 224, 240, 192,
  97, 192, 1, 128, 3, 128, 6, 0, 12, 0, 8, 0, 17, 0, 17, 0,
  17, 0, 14, 0, 0, 0, 12, 0, 30, 0, 30, 0, 12, 0, 21, 21,
  63, 25, 2, 1, 3, 255, 0, 12, 0, 128, 24, 0, 64, 48, 0, 32,
  32, 59, 144, 64, 199, 16, 65, 135, 8, 131, 7, 8, 135, 6, 8, 134,
  6, 8, 142, 14, 8, 142, 14, 8, 142, 12, 16, 142, 28, 16, 142, 28,
  32, 70, 44, 64, 67, 199, 128, 32, 0, 0, 16, 0, 0, 8, 1, 128,
  7, 222, 0, 20, 21, 63, 22, 1, 0, 0, 32, 0, 0, 96, 0, 0,
  96, 0, 0, 112, 0, 0, 240, 0, 0, 240, 0, 0, 184, 0, 1, 56,
  0, 1, 56, 0, 3, 28, 0, 3, 28, 0, 2, 28, 0, 6, 14, 0,
  6, 14, 0, 7, 254, 0, 12, 7, 0, 12, 7, 0, 8, 7, 0, 24,
  3, 128, 24, 3, 128, 255, 31, 240, 16, 21, 42, 20, 2, 0, 255, 240,
  28, 12, 28, 6, 28, 7, 28, 7, 28, 7, 28, 7, 28, 6, 28, 12,
  31, 240, 28, 28, 28, 6, 28, 6, 28, 7, 28, 7, 28, 7, 28, 7,
  28, 7, 28, 6, 28, 12, 255, 240, 15, 21, 42, 19, 2, 1, 15, 226,
  16, 54, 48, 30, 32, 14, 96, 6, 96, 6, 224, 6, 224, 2, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 2, 96, 2, 96, 2, 96, 4,
  32, 4, 48, 12, 24, 8, 7, 240, 19, 21, 63, 22, 2, 0, 255, 248,
  0, 28, 6, 0, 28, 3, 0, 28, 1, 128, 28, 1, 128, 28, 1, 192,
  28, 0, 192, 28, 0, 192, 28, 0, 192, 28, 0, 224, 28, 0, 224, 28,
  0, 224, 28, 0, 192, 28, 0, 192, 28, 0, 192, 28, 1, 192, 28, 1,
  128, 28, 1, 0, 28, 3, 0, 28, 6, 0, 255, 248, 0, 17, 21, 63,
  20, 2, 0, 255, 255, 128, 28, 3, 128, 28, 3, 128, 28, 1, 128, 28,
  1, 128, 28, 0, 128, 28, 32, 128, 28, 32, 0, 28, 32, 0, 28, 96,
  0, 31, 224, 0, 28, 96, 0, 28, 32, 0, 28, 32, 128, 28, 32, 128,
  28, 0, 128, 28, 1, 128, 28, 1, 128, 28, 3, 128, 28, 7, 128, 255,
  255, 128, 17, 21, 63, 20, 2, 0, 255, 255, 128, 28, 3, 128, 28, 3,
  128, 28, 1, 128, 28, 1, 128, 28, 0, 128, 28, 32, 128, 28, 32, 0,
  28, 32, 0, 28, 96, 0, 31, 224, 0, 28, 96, 0, 28, 32, 0, 28,
  32, 0, 28, 32, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 0, 255, 128, 0, 18, 21, 63, 21, 2, 1, 15, 226, 0,
  24, 26, 0, 48, 14, 0, 32, 14, 0, 96, 6, 0, 96, 6, 0, 224,
  2, 0, 224, 2, 0, 224, 0, 0, 224, 0, 0, 224, 127, 192, 224, 14,
  0, 224, 14, 0, 224, 14, 0, 224, 14, 0, 96, 14, 0, 96, 14, 0,
  32, 14, 0, 48, 26, 0, 16, 50, 0, 15, 226, 0, 20, 21, 63, 23,
  2, 0, 255, 15, 240, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3,
  128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 31, 255, 128,
  28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28,
  3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 255, 15,
  240, 8, 21, 21, 12, 2, 0, 255, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 255, 13, 21, 42, 15,
  1, 0, 7, 248, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  112, 224, 240, 192, 240, 192, 192, 192, 65, 128, 127, 0, 19, 21, 63, 22,
  2, 0, 255, 31, 224, 28, 7, 0, 28, 6, 0, 28, 12, 0, 28, 8,
  0, 28, 16, 0, 28, 32, 0, 28, 64, 0, 28, 192, 0, 29, 224, 0,
  30, 224, 0, 28, 112, 0, 28, 112, 0, 28, 56, 0, 28, 28, 0, 28,
  28, 0, 28, 14, 0, 28, 14, 0, 28, 7, 0, 28, 7, 0, 255, 63,
  224, 16, 21, 42, 20, 2, 0, 255, 128, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 1, 28, 1, 28, 1, 28, 1, 28, 3, 28, 3, 28, 15, 255,
  255, 21, 21, 63, 25, 2, 0, 252, 1, 248, 30, 1, 224, 30, 1, 224,
  30, 2, 224, 22, 2, 224, 23, 2, 224, 23, 2, 224, 19, 4, 224, 19,
  132, 224, 19, 132, 224, 17, 132, 224, 17, 200, 224, 17, 200, 224, 16, 200,
  224, 16, 208, 224, 16, 240, 224, 16, 240, 224, 16, 112, 224, 16, 96, 224,
  16, 96, 224, 254, 39, 248, 20, 21, 63, 23, 2, 0, 252, 7, 240, 28,
  0, 128, 30, 0, 128, 31, 0, 128, 23, 0, 128, 19, 128, 128, 19, 192,
  128, 17, 192, 128, 16, 224, 128, 16, 240, 128, 16, 112, 128, 16, 56, 128,
  16, 56, 128, 16, 28, 128, 16, 30, 128, 16, 14, 128, 16, 7, 128, 16,
  7, 128, 16, 3, 128, 16, 1, 128, 254, 1, 128, 17, 22, 66, 20, 2,
  0, 0, 128, 0, 7, 112, 0, 24, 8, 0, 16, 12, 0, 48, 6, 0,
  96, 6, 0, 96, 3, 0, 96, 3, 0, 224, 3, 0, 224, 3, 0, 224,
  3, 0, 224, 3, 128, 224, 3, 128, 224, 3, 0, 224, 3, 0, 96, 3,
  0, 96, 3, 0, 96, 6, 0, 48, 6, 0, 16, 12, 0, 24, 8, 0,
  7, 240, 0, 17, 21, 63, 20, 2, 0, 255, 248, 0, 28, 14, 0, 28,
  7, 0, 28, 3, 0, 28, 3, 0, 28, 3, 128, 28, 3, 0, 28, 3,
  0, 28, 6, 0, 28, 12, 0, 31, 240, 0, 28, 0, 0, 28, 0, 0,
  28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28,
  0, 0, 28, 0, 0, 255, 128, 0, 17, 27, 81, 20, 2, 251, 0, 128,
  0, 7, 112, 0, 24, 8, 0, 16, 12, 0, 48, 6, 0, 96, 6, 0,
  96, 3, 0, 96, 3, 0, 224, 3, 0, 224, 3, 0, 224, 3, 0, 224,
  3, 128, 224, 3, 128, 224, 3, 0, 224, 3, 0, 96, 3, 0, 96, 3,
  0, 97, 198, 0, 51, 38, 0, 26, 60, 0, 14, 60, 0, 7, 48, 128,
  0, 241, 0, 0, 49, 0, 0, 57, 0, 0, 31, 0, 0, 14, 0, 18,
  21, 63, 21, 2, 0, 255, 248, 0, 28, 14, 0, 28, 6, 0, 28, 7,
  0, 28, 7, 0, 28, 7, 0, 28, 7, 0, 28, 6, 0, 28, 12, 0,
  31, 240, 0, 28, 24, 0, 28, 24, 0, 28, 12, 0, 28, 12, 0, 28,
  12, 0, 28, 14, 0, 28, 14, 64, 28, 14, 64, 28, 14, 64, 28, 7,
  128, 255, 131, 128, 14, 21, 42, 18, 3, 1, 63, 144, 96, 208, 192, 112,
  192, 48, 192, 16, 192, 16, 224, 16, 240, 16, 124, 0, 63, 128, 31, 224,
  7, 240, 128, 248, 128, 56, 128, 28, 128, 12, 192, 12, 224, 12, 224, 8,
  144, 16, 142, 224, 17, 21, 63, 21, 2, 0, 255, 255, 128, 225, 195, 128,
  193, 193, 128, 193, 193, 128, 193, 192, 128, 129, 192, 128, 129, 192, 128, 129,
  192, 128, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192,
  0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0,
  1, 192, 0, 1, 192, 0, 15, 248, 0, 20, 21, 63, 23, 2, 0, 255,
  7, 240, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0,
  128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128,
  28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28,
  0, 128, 12, 0, 128, 12, 1, 0, 6, 2, 0, 3, 252, 0, 20, 22,
  66, 23, 2, 255, 255, 143, 240, 28, 1, 192, 28, 1, 128, 14, 1, 128,
  14, 1, 0, 14, 1, 0, 7, 3, 0, 7, 2, 0, 7, 2, 0, 3,
  134, 0, 3, 132, 0, 3, 132, 0, 1, 196, 0, 1, 200, 0, 1, 200,
  0, 0, 232, 0, 0, 240, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0,
  0, 32, 0, 0, 32, 0, 29, 22, 88, 32, 2, 255, 255, 63, 231, 248,
  28, 7, 0, 192, 28, 7, 0, 128, 28, 7, 0, 128, 12, 7, 128, 128,
  14, 15, 129, 128, 14, 11, 129, 0, 6, 9, 129, 0, 7, 9, 195, 0,
  7, 25, 194, 0, 7, 17, 194, 0, 3, 16, 230, 0, 3, 144, 228, 0,
  3, 176, 228, 0, 1, 160, 108, 0, 1, 224, 120, 0, 1, 224, 120, 0,
  1, 192, 120, 0, 0, 192, 48, 0, 0, 192, 48, 0, 0, 192, 48, 0,
  0, 128, 16, 0, 19, 21, 63, 22, 2, 0, 255, 159, 224, 14, 7, 0,
  14, 6, 0, 7, 4, 0, 7, 12, 0, 3, 136, 0, 3, 208, 0, 1,
  208, 0, 1, 224, 0, 0, 224, 0, 0, 112, 0, 0, 240, 0, 1, 184,
  0, 1, 56, 0, 2, 28, 0, 6, 28, 0, 4, 14, 0, 8, 14, 0,
  24, 7, 0, 24, 7, 0, 255, 31, 224, 19, 21, 63, 21, 1, 0, 255,
  143, 224, 30, 3, 128, 14, 3, 0, 14, 2, 0, 7, 2, 0, 7, 4,
  0, 3, 132, 0, 1, 200, 0, 1, 200, 0, 0, 240, 0, 0, 240, 0,
  0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0,
  112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 7, 254, 0, 15, 21,
  42, 19, 2, 0, 63, 254, 56, 14, 112, 28, 96, 56, 64, 56, 64, 112,
  64, 240, 0, 224, 1, 192, 1, 192, 3, 128, 7, 128, 7, 0, 14, 2,
  14, 2, 28, 2, 60, 2, 56, 6, 112, 6, 240, 14, 255, 254, 6, 27,
  27, 11, 3, 250, 252, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 252, 9,
  28, 56, 13, 2, 250, 128, 0, 128, 0, 192, 0, 64, 0, 64, 0, 64,
  0, 32, 0, 32, 0, 32, 0, 16, 0, 16, 0, 16, 0, 24, 0, 8,
  0, 8, 0, 12, 0, 4, 0, 4, 0, 4, 0, 2, 0, 2, 0, 2,
  0, 1, 0, 1, 0, 1, 0, 1, 128, 0, 128, 0, 128, 6, 27, 27,
  11, 2, 250, 252, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 252, 13, 11,
  22, 17, 2, 10, 2, 0, 2, 0, 5, 0, 13, 128, 8, 128, 24, 192,
  16, 64, 32, 32, 96, 48, 64, 16, 192, 24, 15, 1, 2, 15, 0, 251,
  255, 254, 5, 5, 5, 13, 2, 16, 192, 224, 96, 48, 8, 13, 14, 28,
  15, 1, 0, 31, 0, 33, 128, 97, 192, 113, 192, 113, 192, 1, 192, 15,
  192, 49, 192, 97, 192, 225, 192, 225, 200, 225, 200, 226, 216, 60, 240, 13,
  21, 42, 15, 1, 0, 248, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 59, 192, 60, 96, 56, 48, 56, 48, 56, 48, 56, 48, 56,
  56, 56, 56, 56, 48, 56, 48, 56, 48, 56, 48, 36, 96, 35, 192, 10,
  14, 28, 12, 1, 0, 31, 0, 48, 128, 96, 64, 96, 192, 225, 192, 224,
  128, 224, 0, 224, 0, 224, 0, 224, 0, 96, 64, 96, 128, 48, 128, 31,
  0, 13, 21, 42, 15, 1, 0, 3, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 30, 224, 49, 224, 97, 224, 96, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 96, 224, 96, 224, 49, 224, 30,
  248, 10, 14, 28, 13, 1, 0, 30, 0, 49, 128, 97, 128, 96, 192, 224,
  192, 224, 192, 255, 192, 224, 0, 224, 0, 224, 64, 96, 64, 96, 64, 48,
  128, 31, 0, 10, 21, 42, 10, 1, 0, 15, 0, 24, 128, 57, 192, 57,
  128, 56, 0, 56, 0, 56, 0, 254, 0, 56, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56,
  0, 254, 0, 14, 21, 42, 16, 2, 249, 31, 56, 113, 200, 96, 220, 224,
  248, 224, 224, 224, 224, 224, 224, 96, 192, 49, 128, 31, 0, 96, 0, 128,
  0, 224, 0, 127, 224, 56, 112, 64, 16, 128, 16, 128, 16, 128, 48, 64,
  96, 63, 128, 14, 21, 42, 16, 1, 0, 248, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 56, 0, 56, 0, 57, 192, 62, 96, 60, 112, 56, 112, 56,
  112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56,
  112, 252, 252, 6, 21, 21, 7, 1, 0, 112, 112, 112, 0, 0, 0, 0,
  240, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 252, 8, 28,
  28, 9, 255, 249, 6, 7, 6, 0, 0, 0, 0, 31, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 70, 230, 198, 204, 120,
  13, 21, 42, 15, 1, 0, 248, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 57, 248, 56, 192, 56, 128, 57, 0, 57, 0, 58, 0,
  63, 0, 63, 0, 59, 128, 57, 192, 56, 192, 56, 224, 56, 224, 253, 248,
  7, 21, 21, 8, 1, 0, 248, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 254, 21, 14, 42, 23, 1,
  0, 249, 195, 192, 62, 100, 224, 60, 120, 96, 56, 120, 96, 56, 112, 96,
  56, 112, 96, 56, 112, 96, 56, 112, 96, 56, 112, 96, 56, 112, 96, 56,
  112, 96, 56, 112, 96, 56, 112, 96, 252, 253, 248, 14, 14, 28, 16, 1,
  0, 249, 192, 62, 96, 60, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56,
  112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 252, 252, 12, 14, 28,
  14, 1, 0, 15, 0, 48, 128, 96, 192, 96, 96, 224, 96, 224, 96, 224,
  112, 224, 112, 224, 96, 224, 96, 96, 96, 96, 192, 48, 128, 15, 0, 13,
  21, 42, 15, 1, 249, 251, 192, 60, 96, 56, 48, 56, 48, 56, 48, 56,
  48, 56, 56, 56, 56, 56, 48, 56, 48, 56, 48, 56, 48, 60, 96, 59,
  192, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 252, 0, 13,
  21, 42, 15, 1, 249, 30, 32, 49, 32, 96, 224, 96, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 96, 224, 96, 224, 49, 224, 30,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 3, 248, 10,
  14, 28, 12, 1, 0, 249, 128, 58, 64, 60, 192, 60, 192, 56, 0, 56,
  0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 252,
  0, 10, 14, 28, 13, 2, 0, 60, 128, 195, 128, 129, 128, 128, 128, 192,
  128, 240, 0, 62, 0, 15, 128, 131, 192, 128, 192, 192, 64, 192, 64, 160,
  128, 159, 0, 8, 20, 20, 10, 1, 0, 16, 16, 16, 16, 48, 48, 254,
  48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 59, 30, 14, 14, 28,
  16, 1, 0, 248, 240, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56,
  112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 240, 25, 112, 14, 124, 15,
  14, 28, 15, 0, 0, 254, 126, 56, 16, 24, 16, 28, 16, 12, 32, 12,
  32, 6, 32, 6, 64, 7, 64, 3, 64, 3, 128, 1, 128, 1, 128, 1,
  0, 22, 14, 42, 22, 0, 0, 254, 252, 252, 56, 56, 32, 24, 56, 32,
  28, 56, 32, 12, 56, 64, 12, 60, 64, 6, 76, 64, 6, 76, 128, 7,
  70, 128, 3, 134, 128, 3, 135, 0, 1, 131, 0, 1, 131, 0, 1, 2,
  0, 14, 14, 28, 16, 1, 0, 124, 248, 56, 96, 24, 64, 12, 128, 14,
  128, 7, 0, 7, 0, 3, 128, 5, 128, 5, 192, 8, 192, 16, 224, 16,
  96, 249, 252, 15, 21, 42, 15, 0, 249, 254, 126, 24, 16, 24, 16, 28,
  16, 12, 32, 12, 32, 14, 32, 6, 64, 6, 64, 6, 64, 3, 128, 3,
  128, 3, 128, 1, 128, 1, 0, 1, 0, 1, 0, 98, 0, 114, 0, 100,
  0, 56, 0, 10, 14, 28, 13, 1, 0, 255, 192, 193, 192, 129, 128, 131,
  0, 135, 0, 6, 0, 14, 0, 28, 0, 24, 0, 56, 64, 48, 64, 112,
  64, 224, 192, 255, 192, 6, 27, 27, 12, 3, 250, 12, 24, 48, 48, 48,
  48, 48, 56, 24, 24, 24, 16, 48, 192, 48, 16, 24, 24, 24, 56, 48,
  48, 48, 48, 48, 16, 12, 1, 28, 28, 8, 4, 250, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 6, 27, 27, 12, 3, 250, 128, 96,
  32, 48, 48, 48, 112, 96, 96, 96, 96, 96, 32, 28, 48, 96, 96, 96,
  96, 96, 112, 48, 48, 48, 32, 96, 192, 16, 6, 12, 18, 1, 5, 56,
  2, 126, 1, 143, 193, 131, 241, 128, 255, 64, 62, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 8,
  0, 0, 4, 21, 21, 8, 2, 249, 96, 240, 240, 96, 0, 64, 64, 96,
  96, 96, 96, 96, 96, 96, 96, 240, 240, 240, 240, 240, 96, 10, 21, 42,
  17, 3, 253, 4, 0, 4, 0, 4, 0, 4, 0, 31, 0, 52, 128, 100,
  64, 100, 192, 229, 192, 228, 128, 228, 0, 228, 0, 228, 0, 228, 0, 100,
  64, 100, 64, 52, 128, 31, 0, 4, 0, 4, 0, 4, 0, 16, 21, 42,
  21, 2, 0, 0, 60, 0, 194, 0, 131, 1, 135, 1, 135, 3, 130, 3,
  128, 3, 128, 3, 128, 63, 128, 3, 240, 3, 128, 3, 128, 3, 128, 3,
  0, 3, 0, 123, 1, 142, 1, 135, 3, 135, 254, 120, 252, 13, 13, 26,
  17, 2, 4, 143, 136, 112, 112, 96, 48, 64, 16, 128, 8, 128, 8, 128,
  8, 128, 8, 128, 8, 64, 16, 96, 48, 112, 112, 143, 136, 16, 21, 42,
  17, 1, 0, 252, 63, 56, 8, 56, 8, 24, 16, 28, 16, 28, 32, 14,
  32, 14, 64, 6, 64, 7, 128, 3, 128, 63, 248, 3, 128, 3, 128, 63,
  248, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 31, 240, 1, 27, 27,
  8, 4, 251, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 0, 0,
  0, 0, 0, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 11, 27,
  54, 19, 3, 250, 30, 0, 49, 0, 97, 128, 99, 128, 97, 0, 112, 0,
  56, 0, 60, 0, 62, 0, 79, 0, 131, 128, 129, 192, 128, 224, 192, 96,
  224, 32, 112, 32, 56, 64, 28, 128, 15, 0, 7, 0, 3, 0, 1, 128,
  33, 128, 113, 128, 97, 128, 35, 0, 28, 0, 8, 3, 3, 12, 2, 16,
  195, 231, 195, 21, 22, 66, 23, 1, 0, 0, 32, 0, 3, 222, 0, 12,
  1, 128, 24, 0, 192, 48, 114, 96, 33, 142, 32, 67, 6, 16, 67, 2,
  16, 135, 2, 8, 135, 0, 8, 135, 0, 8, 135, 0, 8, 135, 0, 8,
  135, 0, 8, 135, 2, 8, 67, 2, 16, 67, 4, 16, 33, 132, 32, 48,
  120, 96, 24, 0, 192, 12, 1, 128, 3, 222, 0, 8, 9, 9, 12, 2,
  12, 120, 196, 12, 52, 68, 197, 205, 118, 254, 7, 12, 12, 14, 3, 1,
  16, 34, 98, 68, 196, 196, 196, 196, 196, 66, 34, 16, 14, 6, 12, 16,
  1, 5, 255, 252, 0, 4, 0, 4, 0, 4, 0, 4, 0, 4, 7, 2,
  2, 11, 2, 7, 254, 254, 21, 22, 66, 23, 1, 0, 0, 32, 0, 3,
  222, 0, 12, 1, 128, 24, 0, 192, 63, 248, 96, 35, 140, 32, 67, 142,
  16, 67, 142, 16, 131, 142, 8, 131, 140, 8, 131, 240, 8, 131, 140, 8,
  131, 140, 8, 131, 142, 8, 131, 142, 72, 67, 142, 80, 67, 134, 80, 47,
  195, 160, 48, 0, 96, 24, 0, 192, 12, 1, 128, 3, 222, 0, 8, 1,
  1, 14, 3, 17, 255, 8, 8, 8, 16, 4, 13, 60, 66, 129, 129, 129,
  129, 66, 60, 24, 21, 63, 26, 1, 255, 0, 8, 0, 0, 8, 0, 0,
  8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8,
  0, 255, 255, 255, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0,
  0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0,
  0, 0, 0, 0, 0, 255, 255, 255, 8, 13, 13, 13, 3, 8, 60, 198,
  135, 199, 231, 6, 12, 24, 48, 65, 193, 255, 255, 9, 13, 26, 13, 3,
  8, 60, 0, 70, 0, 67, 0, 99, 0, 3, 0, 6, 0, 120, 0, 7,
  0, 3, 0, 227, 128, 227, 0, 135, 0, 124, 0, 5, 5, 5, 13, 6,
  16, 24, 56, 48, 96, 128, 15, 22, 44, 18, 2, 248, 192, 64, 192, 96,
  224, 224, 192, 224, 192, 224, 192, 96, 192, 96, 192, 96, 64, 96, 64, 64,
  64, 66, 192, 194, 177, 190, 143, 28, 128, 0, 128, 0, 192, 0, 192, 0,
  192, 0, 224, 0, 224, 0, 96, 0, 12, 26, 52, 16, 2, 251, 31, 240,
  124, 64, 252, 64, 252, 64, 252, 64, 252, 64, 252, 64, 124, 64, 60, 64,
  4, 64, 4, 64, 4, 64, 4, 64, 4, 64, 4, 64, 4, 64, 4, 64,
  4, 64, 4, 64, 4, 64, 4, 64, 4, 64, 4, 64, 4, 64, 4, 64,
  4, 64, 4, 4, 4, 8, 2, 8, 96, 240, 240, 96, 6, 7, 7, 13,
  3, 250, 32, 32, 48, 8, 12, 140, 120, 6, 12, 12, 13, 4, 9, 16,
  48, 240, 48, 48, 48, 48, 48, 48, 48, 48, 252, 7, 10, 10, 11, 2,
  11, 56, 68, 198, 198, 198, 198, 198, 68, 56, 254, 8, 12, 12, 14, 3,
  1, 8, 132, 70, 66, 35, 35, 35, 35, 34, 70, 68, 8, 19, 21, 63,
  25, 4, 0, 16, 3, 0, 48, 2, 0, 240, 4, 0, 48, 4, 0, 48,
  8, 0, 48, 8, 0, 48, 16, 0, 48, 48, 0, 48, 32, 0, 48, 65,
  128, 48, 67, 128, 48, 131, 128, 252, 133, 128, 1, 9, 128, 3, 9, 128,
  2, 17, 128, 4, 31, 224, 4, 1, 128, 8, 1, 128, 8, 1, 128, 16,
  7, 224, 19, 21, 63, 25, 4, 0, 16, 2, 0, 48, 2, 0, 240, 4,
  0, 48, 4, 0, 48, 8, 0, 48, 16, 0, 48, 16, 0, 48, 32, 0,
  48, 39, 128, 48, 72, 192, 48, 80, 224, 48, 144, 224, 252, 156, 224, 1,
  12, 192, 2, 0, 192, 2, 1, 0, 4, 6, 0, 4, 12, 32, 8, 8,
  32, 8, 31, 224, 16, 31, 224, 20, 21, 63, 25, 3, 0, 60, 1, 0,
  70, 1, 0, 67, 2, 0, 99, 2, 0, 3, 4, 0, 6, 12, 0, 120,
  8, 0, 7, 16, 0, 3, 16, 0, 227, 160, 192, 227, 33, 192, 135, 65,
  192, 124, 130, 192, 0, 132, 192, 1, 4, 192, 1, 8, 192, 2, 15, 240,
  2, 0, 192, 4, 0, 192, 8, 0, 192, 8, 3, 240, 11, 21, 42, 14,
  1, 249, 12, 0, 30, 0, 30, 0, 12, 0, 0, 0, 14, 0, 17, 0,
  17, 0, 17, 0, 2, 0, 6, 0, 28, 0, 56, 0, 112, 0, 224, 192,
  225, 224, 225, 224, 224, 32, 96, 32, 112, 64, 31, 128, 20, 28, 84, 22,
  1, 0, 3, 0, 0, 3, 128, 0, 1, 128, 0, 0, 192, 0, 0, 64,
  0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 96, 0, 0, 96, 0,
  0, 112, 0, 0, 240, 0, 0, 240, 0, 0, 184, 0, 1, 56, 0, 1,
  56, 0, 3, 28, 0, 3, 28, 0, 2, 28, 0, 6, 14, 0, 6, 14,
  0, 7, 254, 0, 12, 7, 0, 12, 7, 0, 8, 7, 0, 24, 3, 128,
  24, 3, 128, 255, 31, 240, 20, 28, 84, 22, 1, 0, 0, 4, 0, 0,
  12, 0, 0, 24, 0, 0, 48, 0, 0, 32, 0, 0, 0, 0, 0, 0,
  0, 0, 32, 0, 0, 96, 0, 0, 96, 0, 0, 112, 0, 0, 240, 0,
  0, 240, 0, 1, 184, 0, 1, 56, 0, 1, 56, 0, 3, 28, 0, 3,
  28, 0, 2, 28, 0, 6, 14, 0, 6, 14, 0, 7, 254, 0, 12, 7,
  0, 12, 7, 0, 8, 7, 0, 24, 3, 128, 24, 3, 128, 255, 31, 240,
  20, 28, 84, 22, 1, 0, 0, 32, 0, 0, 96, 0, 0, 240, 0, 1,
  152, 0, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 96,
  0, 0, 96, 0, 0, 112, 0, 0, 240, 0, 0, 240, 0, 0, 184, 0,
  1, 56, 0, 1, 56, 0, 3, 28, 0, 3, 28, 0, 2, 28, 0, 6,
  14, 0, 6, 14, 0, 7, 254, 0, 12, 7, 0, 12, 7, 0, 8, 7,
  0, 24, 3, 128, 24, 3, 128, 255, 31, 240, 20, 27, 81, 22, 1, 0,
  1, 228, 0, 3, 252, 0, 2, 56, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 32, 0, 0, 96, 0, 0, 96, 0, 0, 112, 0, 0, 240,
  0, 0, 240, 0, 0, 184, 0, 1, 184, 0, 1, 56, 0, 3, 28, 0,
  3, 28, 0, 2, 28, 0, 6, 14, 0, 6, 14, 0, 7, 254, 0, 12,
  7, 0, 12, 7, 0, 8, 7, 0, 24, 3, 128, 24, 3, 128, 255, 31,
  240, 19, 27, 81, 22, 2, 0, 6, 24, 0, 7, 28, 0, 6, 24, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 192, 0, 0,
  224, 0, 0, 224, 0, 1, 224, 0, 1, 224, 0, 1, 112, 0, 3, 112,
  0, 2, 48, 0, 2, 56, 0, 6, 56, 0, 4, 24, 0, 4, 28, 0,
  12, 28, 0, 15, 252, 0, 8, 14, 0, 24, 14, 0, 24, 6, 0, 24,
  7, 0, 56, 7, 0, 254, 31, 224, 20, 28, 84, 23, 2, 0, 0, 96,
  0, 1, 152, 0, 1, 8, 0, 1, 8, 0, 1, 152, 0, 0, 96, 0,
  0, 0, 0, 0, 96, 0, 0, 96, 0, 0, 96, 0, 0, 240, 0, 0,
  240, 0, 0, 240, 0, 1, 184, 0, 1, 56, 0, 1, 56, 0, 3, 28,
  0, 2, 28, 0, 2, 28, 0, 6, 14, 0, 4, 14, 0, 15, 254, 0,
  8, 7, 0, 8, 7, 0, 24, 7, 0, 24, 3, 128, 56, 3, 128, 255,
  31, 240, 27, 21, 84, 30, 1, 0, 0, 63, 255, 224, 0, 15, 0, 224,
  0, 15, 0, 96, 0, 31, 0, 96, 0, 23, 0, 32, 0, 55, 0, 32,
  0, 39, 8, 32, 0, 103, 8, 0, 0, 71, 8, 0, 0, 199, 24, 0,
  0, 135, 248, 0, 1, 7, 24, 0, 3, 7, 8, 0, 2, 7, 8, 32,
  7, 255, 8, 32, 4, 7, 0, 32, 12, 7, 0, 32, 8, 7, 0, 96,
  24, 7, 0, 96, 56, 7, 1, 224, 255, 63, 255, 224, 15, 28, 56, 19,
  2, 250, 15, 226, 16, 54, 48, 30, 32, 14, 96, 6, 96, 6, 224, 6,
  224, 2, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 2, 96, 2,
  96, 2, 96, 4, 32, 4, 48, 12, 24, 8, 6, 112, 1, 128, 1, 0,
  1, 192, 0, 96, 0, 112, 8, 96, 7, 192, 17, 28, 84, 20, 2, 0,
  4, 0, 0, 6, 0, 0, 3, 0, 0, 1, 0, 0, 0, 128, 0, 0,
  0, 0, 0, 0, 0, 255, 255, 128, 28, 3, 128, 28, 3, 128, 28, 1,
  128, 28, 1, 128, 28, 0, 128, 28, 32, 128, 28, 32, 0, 28, 32, 0,
  28, 96, 0, 31, 224, 0, 28, 96, 0, 28, 32, 0, 28, 32, 128, 28,
  32, 128, 28, 0, 128, 28, 1, 128, 28, 1, 128, 28, 3, 128, 28, 7,
  128, 255, 255, 128, 17, 28, 84, 20, 2, 0, 0, 24, 0, 0, 56, 0,
  0, 48, 0, 0, 96, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 255,
  255, 128, 28, 3, 128, 28, 3, 128, 28, 1, 128, 28, 1, 128, 28, 0,
  128, 28, 32, 128, 28, 32, 0, 28, 32, 0, 28, 96, 0, 31, 224, 0,
  28, 96, 0, 28, 32, 0, 28, 32, 128, 28, 32, 128, 28, 0, 128, 28,
  1, 128, 28, 1, 128, 28, 3, 128, 28, 7, 128, 255, 255, 128, 17, 28,
  84, 20, 2, 0, 0, 128, 0, 0, 192, 0, 1, 192, 0, 2, 32, 0,
  4, 24, 0, 0, 0, 0, 0, 0, 0, 255, 255, 128, 28, 3, 128, 28,
  3, 128, 28, 1, 128, 28, 1, 128, 28, 0, 128, 28, 32, 128, 28, 32,
  0, 28, 32, 0, 28, 96, 0, 31, 224, 0, 28, 96, 0, 28, 32, 0,
  28, 32, 128, 28, 32, 128, 28, 0, 128, 28, 1, 128, 28, 1, 128, 28,
  3, 128, 28, 7, 128, 255, 255, 128, 17, 27, 81, 20, 2, 0, 6, 48,
  0, 7, 56, 0, 6, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  255, 255, 128, 28, 7, 128, 28, 3, 128, 28, 1, 128, 28, 1, 128, 28,
  1, 128, 28, 32, 128, 28, 32, 0, 28, 32, 0, 28, 96, 0, 31, 224,
  0, 28, 96, 0, 28, 32, 0, 28, 32, 128, 28, 32, 128, 28, 1, 0,
  28, 1, 128, 28, 1, 128, 28, 3, 128, 28, 7, 128, 255, 255, 128, 8,
  28, 28, 12, 2, 0, 192, 224, 96, 48, 24, 0, 0, 255, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  255, 9, 28, 56, 12, 2, 0, 1, 0, 3, 0, 6, 0, 4, 0, 8,
  0, 0, 0, 0, 0, 255, 128, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 255, 128, 8,
  28, 28, 12, 2, 0, 8, 24, 28, 38, 193, 0, 0, 255, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  255, 9, 27, 54, 11, 2, 0, 195, 0, 227, 128, 195, 0, 0, 0, 0,
  0, 0, 0, 255, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 255, 0, 19, 21, 63,
  22, 2, 0, 255, 248, 0, 28, 6, 0, 28, 3, 0, 28, 1, 128, 28,
  1, 192, 28, 0, 192, 28, 0, 192, 28, 0, 224, 28, 0, 224, 255, 128,
  224, 28, 0, 224, 28, 0, 224, 28, 0, 224, 28, 0, 224, 28, 0, 192,
  28, 0, 192, 28, 1, 128, 28, 1, 128, 28, 3, 0, 28, 6, 0, 255,
  248, 0, 20, 27, 81, 23, 2, 0, 1, 226, 0, 3, 254, 0, 2, 28,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252, 7, 240, 28, 0, 128,
  30, 0, 128, 31, 0, 128, 23, 0, 128, 19, 128, 128, 19, 192, 128, 17,
  192, 128, 16, 224, 128, 16, 240, 128, 16, 112, 128, 16, 56, 128, 16, 56,
  128, 16, 28, 128, 16, 30, 128, 16, 14, 128, 16, 7, 128, 16, 7, 128,
  16, 3, 128, 16, 1, 128, 254, 1, 128, 17, 28, 84, 20, 2, 0, 12,
  0, 0, 14, 0, 0, 6, 0, 0, 3, 0, 0, 1, 128, 0, 0, 0,
  0, 0, 128, 0, 7, 112, 0, 24, 8, 0, 16, 12, 0, 48, 6, 0,
  96, 6, 0, 96, 3, 0, 96, 3, 0, 224, 3, 0, 224, 3, 0, 224,
  3, 0, 224, 3, 128, 224, 3, 128, 224, 3, 0, 224, 3, 0, 96, 3,
  0, 96, 3, 0, 96, 6, 0, 48, 6, 0, 16, 12, 0, 24, 8, 0,
  7, 240, 0, 17, 28, 84, 20, 2, 0, 0, 24, 0, 0, 56, 0, 0,
  112, 0, 0, 64, 0, 0, 128, 0, 0, 0, 0, 0, 128, 0, 7, 112,
  0, 24, 8, 0, 16, 12, 0, 48, 6, 0, 96, 6, 0, 96, 3, 0,
  96, 3, 0, 224, 3, 0, 224, 3, 0, 224, 3, 0, 224, 3, 128, 224,
  3, 128, 224, 3, 0, 224, 3, 0, 96, 3, 0, 96, 3, 0, 96, 6,
  0, 48, 6, 0, 16, 12, 0, 24, 8, 0, 7, 240, 0, 17, 28, 84,
  20, 2, 0, 0, 128, 0, 1, 128, 0, 3, 192, 0, 6, 32, 0, 12,
  16, 0, 0, 8, 0, 0, 128, 0, 7, 112, 0, 24, 8, 0, 16, 12,
  0, 48, 6, 0, 96, 6, 0, 96, 3, 0, 96, 3, 0, 224, 3, 0,
  224, 3, 0, 224, 3, 0, 224, 3, 128, 224, 3, 128, 224, 3, 0, 224,
  3, 0, 96, 3, 0, 96, 3, 0, 96, 6, 0, 48, 6, 0, 16, 12,
  0, 24, 8, 0, 7, 240, 0, 17, 27, 81, 20, 2, 0, 7, 136, 0,
  15, 248, 0, 8, 112, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 7,
  112, 0, 24, 8, 0, 16, 12, 0, 48, 6, 0, 96, 6, 0, 96, 3,
  0, 96, 3, 0, 224, 3, 0, 224, 3, 0, 224, 3, 0, 224, 3, 128,
  224, 3, 128, 224, 3, 0, 224, 3, 0, 96, 3, 0, 96, 3, 0, 96,
  6, 0, 48, 6, 0, 16, 12, 0, 24, 8, 0, 7, 240, 0, 17, 27,
  81, 20, 2, 0, 12, 48, 0, 14, 56, 0, 12, 48, 0, 0, 0, 0,
  0, 0, 0, 0, 128, 0, 7, 112, 0, 24, 8, 0, 16, 12, 0, 48,
  6, 0, 96, 6, 0, 96, 3, 0, 96, 3, 0, 224, 3, 0, 224, 3,
  0, 224, 3, 0, 224, 3, 128, 224, 3, 128, 224, 3, 0, 224, 3, 0,
  96, 3, 0, 96, 3, 0, 96, 6, 0, 48, 6, 0, 16, 12, 0, 24,
  8, 0, 7, 240, 0, 18, 18, 54, 27, 5, 255, 128, 0, 192, 192, 1,
  128, 96, 3, 0, 48, 6, 0, 24, 12, 0, 12, 24, 0, 6, 48, 0,
  3, 96, 0, 1, 192, 0, 1, 192, 0, 3, 96, 0, 6, 48, 0, 12,
  24, 0, 24, 12, 0, 48, 6, 0, 96, 3, 0, 64, 1, 128, 128, 0,
  192, 17, 21, 63, 20, 2, 1, 7, 241, 0, 8, 15, 0, 16, 14, 0,
  48, 6, 0, 96, 14, 0, 96, 27, 0, 96, 19, 0, 224, 35, 0, 224,
  99, 0, 224, 195, 128, 225, 131, 128, 225, 3, 0, 226, 3, 0, 230, 3,
  0, 236, 3, 0, 104, 3, 0, 112, 6, 0, 112, 6, 0, 112, 12, 0,
  88, 8, 0, 143, 240, 0, 20, 28, 84, 23, 2, 0, 3, 0, 0, 3,
  128, 0, 1, 128, 0, 0, 192, 0, 0, 32, 0, 0, 0, 0, 0, 0,
  0, 255, 7, 240, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128,
  28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28,
  0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0,
  128, 28, 0, 128, 12, 0, 128, 12, 1, 0, 6, 2, 0, 3, 252, 0,
  20, 28, 84, 23, 2, 0, 0, 4, 0, 0, 12, 0, 0, 24, 0, 0,
  16, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 255, 7, 240, 28, 0,
  128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128,
  28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28,
  0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 12, 0,
  128, 12, 1, 0, 6, 2, 0, 3, 252, 0, 20, 28, 84, 23, 2, 0,
  0, 32, 0, 0, 96, 0, 0, 112, 0, 0, 136, 0, 3, 4, 0, 0,
  0, 0, 0, 0, 0, 255, 7, 240, 28, 0, 128, 28, 0, 128, 28, 0,
  128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128,
  28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28,
  0, 128, 28, 0, 128, 28, 0, 128, 12, 1, 128, 12, 1, 0, 6, 2,
  0, 3, 252, 0, 20, 27, 81, 23, 2, 0, 1, 134, 0, 3, 142, 0,
  1, 134, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 131, 240, 28,
  0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0,
  128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128,
  28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 12,
  0, 128, 12, 1, 0, 6, 2, 0, 3, 252, 0, 19, 28, 84, 21, 1,
  0, 0, 4, 0, 0, 12, 0, 0, 24, 0, 0, 16, 0, 0, 32, 0,
  0, 0, 0, 0, 0, 0, 255, 143, 224, 30, 3, 128, 14, 3, 0, 14,
  2, 0, 7, 2, 0, 7, 4, 0, 3, 132, 0, 1, 200, 0, 1, 200,
  0, 0, 240, 0, 0, 240, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0,
  0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0,
  112, 0, 7, 254, 0, 17, 21, 63, 20, 2, 0, 255, 128, 0, 28, 0,
  0, 28, 0, 0, 31, 240, 0, 28, 12, 0, 28, 6, 0, 28, 3, 0,
  28, 3, 0, 28, 3, 128, 28, 3, 128, 28, 3, 0, 28, 3, 0, 28,
  6, 0, 28, 12, 0, 31, 240, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 0, 28, 0, 0, 255, 128, 0, 13, 21, 42, 15, 1, 0,
  7, 192, 12, 96, 24, 112, 56, 112, 56, 112, 56, 96, 56, 192, 59, 0,
  56, 192, 56, 96, 56, 48, 56, 48, 56, 56, 56, 56, 56, 56, 56, 56,
  58, 56, 63, 56, 62, 48, 60, 48, 251, 192, 13, 21, 42, 15, 1, 0,
  96, 0, 96, 0, 48, 0, 24, 0, 8, 0, 4, 0, 0, 0, 31, 0,
  97, 128, 65, 192, 97, 192, 113, 192, 1, 192, 15, 192, 49, 192, 97, 192,
  193, 192, 193, 200, 195, 200, 196, 216, 56, 240, 13, 21, 42, 15, 1, 0,
  0, 192, 1, 192, 1, 128, 3, 0, 6, 0, 4, 0, 0, 0, 31, 0,
  33, 128, 96, 192, 112, 192, 112, 192, 0, 192, 7, 192, 56, 192, 96, 192,
  224, 192, 224, 200, 225, 200, 226, 216, 60, 112, 13, 21, 42, 15, 1, 0,
  4, 0, 12, 0, 14, 0, 26, 0, 17, 0, 32, 128, 0, 0, 31, 0,
  33, 128, 97, 192, 113, 192, 113, 192, 1, 192, 15, 192, 49, 192, 97, 192,
  225, 192, 225, 200, 225, 200, 226, 216, 60, 240, 13, 20, 40, 15, 1, 0,
  24, 0, 63, 128, 71, 128, 0, 0, 0, 0, 0, 0, 31, 0, 33, 128,
  97, 192, 113, 192, 113, 192, 1, 192, 15, 192, 49, 192, 97, 192, 225, 192,
  225, 200, 225, 200, 226, 216, 60, 240, 13, 20, 40, 15, 1, 0, 97, 128,
  97, 192, 97, 128, 0, 0, 0, 0, 0, 0, 30, 0, 97, 128, 64, 128,
  96, 128, 96, 192, 0, 192, 15, 192, 48, 192, 96, 192, 192, 192, 193, 200,
  194, 200, 194, 216, 60, 112, 13, 21, 42, 15, 1, 0, 14, 0, 49, 0,
  33, 0, 33, 0, 19, 0, 14, 0, 0, 0, 30, 0, 33, 128, 97, 128,
  97, 128, 113, 192, 1, 192, 15, 192, 113, 192, 97, 192, 225, 192, 225, 200,
  227, 200, 229, 216, 120, 240, 18, 14, 42, 20, 1, 0, 31, 30, 0, 97,
  227, 0, 65, 227, 0, 97, 193, 128, 113, 193, 128, 1, 193, 128, 15, 255,
  192, 113, 192, 0, 65, 192, 0, 193, 192, 128, 193, 192, 128, 194, 224, 128,
  194, 97, 0, 60, 62, 0, 10, 20, 40, 12, 1, 250, 31, 0, 48, 128,
  96, 192, 96, 192, 225, 192, 224, 128, 224, 0, 224, 0, 224, 0, 224, 64,
  96, 64, 96, 128, 48, 128, 31, 0, 8, 0, 12, 0, 3, 0, 3, 0,
  3, 0, 30, 0, 10, 21, 42, 13, 1, 0, 96, 0, 112, 0, 56, 0,
  24, 0, 4, 0, 0, 0, 0, 0, 30, 0, 49, 128, 97, 128, 96, 192,
  224, 192, 224, 192, 255, 192, 224, 0, 224, 0, 224, 64, 96, 64, 96, 64,
  48, 128, 31, 0, 10, 21, 42, 13, 1, 0, 0, 192, 1, 192, 1, 128,
  3, 0, 6, 0, 0, 0, 0, 0, 30, 0, 49, 128, 97, 128, 96, 192,
  224, 192, 224, 192, 255, 192, 224, 0, 224, 0, 224, 64, 96, 64, 96, 64,
  48, 128, 31, 0, 10, 21, 42, 13, 1, 0, 4, 0, 4, 0, 14, 0,
  11, 0, 17, 0, 32, 128, 0, 0, 30, 0, 49, 128, 97, 128, 96, 192,
  224, 192, 224, 192, 255, 192, 224, 0, 224, 0, 224, 64, 96, 64, 96, 64,
  48, 128, 31, 0, 10, 20, 40, 13, 1, 0, 49, 128, 113, 192, 49, 128,
  0, 0, 0, 0, 0, 0, 30, 0, 49, 128, 97, 128, 96, 192, 224, 192,
  224, 192, 255, 192, 224, 0, 224, 0, 224, 64, 96, 64, 96, 64, 48, 128,
  31, 0, 7, 21, 21, 8, 0, 0, 192, 192, 96, 48, 24, 0, 0, 124,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 126, 7, 21, 21,
  8, 1, 0, 6, 14, 12, 24, 16, 0, 0, 248, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 252, 7, 20, 20, 9, 1, 0, 48, 48,
  104, 132, 2, 0, 248, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 252, 8, 19, 19, 9, 1, 0, 198, 231, 198, 0, 0, 124, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 126, 12, 21, 42, 14, 1,
  0, 56, 64, 29, 128, 14, 0, 15, 0, 19, 0, 33, 128, 1, 192, 15,
  192, 48, 224, 96, 224, 96, 96, 224, 96, 224, 112, 224, 112, 224, 96, 224,
  96, 224, 96, 96, 96, 96, 192, 48, 128, 15, 0, 14, 20, 40, 16, 1,
  0, 14, 32, 15, 32, 19, 192, 16, 192, 0, 0, 0, 0, 249, 192, 62,
  96, 60, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56,
  112, 56, 112, 56, 112, 56, 112, 252, 252, 12, 21, 42, 14, 1, 0, 32,
  0, 48, 0, 24, 0, 8, 0, 4, 0, 0, 0, 0, 0, 15, 0, 48,
  128, 96, 192, 96, 96, 224, 96, 224, 96, 224, 112, 224, 112, 224, 96, 224,
  96, 96, 96, 96, 192, 48, 128, 15, 0, 12, 21, 42, 14, 1, 0, 0,
  192, 1, 192, 1, 128, 3, 0, 2, 0, 4, 0, 0, 0, 15, 0, 48,
  128, 96, 192, 96, 96, 224, 96, 224, 96, 224, 112, 224, 112, 224, 96, 224,
  96, 96, 96, 96, 192, 48, 128, 15, 0, 12, 21, 42, 14, 1, 0, 4,
  0, 6, 0, 14, 0, 11, 0, 16, 128, 32, 0, 0, 0, 15, 0, 48,
  128, 96, 192, 96, 96, 224, 96, 224, 96, 224, 112, 224, 112, 224, 96, 224,
  96, 96, 96, 96, 192, 48, 128, 15, 0, 12, 20, 40, 14, 1, 0, 28,
  64, 63, 192, 39, 128, 0, 0, 0, 0, 0, 0, 15, 0, 48, 128, 96,
  192, 96, 96, 224, 96, 224, 96, 224, 112, 224, 112, 224, 96, 224, 96, 96,
  96, 96, 192, 48, 128, 15, 0, 12, 20, 40, 14, 1, 0, 48, 192, 57,
  192, 48, 192, 0, 0, 0, 0, 0, 0, 15, 0, 48, 128, 96, 192, 96,
  96, 224, 96, 224, 96, 224, 112, 224, 112, 224, 96, 224, 96, 96, 96, 96,
  192, 48, 128, 15, 0, 24, 19, 57, 26, 1, 254, 0, 24, 0, 0, 60,
  0, 0, 60, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 60, 0, 0, 60,
  0, 0, 24, 0, 12, 14, 28, 14, 1, 0, 15, 32, 48, 160, 96, 192,
  96, 224, 225, 96, 227, 96, 226, 112, 228, 112, 232, 96, 240, 96, 96, 96,
  96, 192, 112, 128, 143, 0, 14, 21, 42, 16, 1, 0, 24, 0, 24, 0,
  12, 0, 6, 0, 2, 0, 0, 0, 0, 0, 248, 240, 56, 112, 56, 112,
  56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112,
  56, 240, 25, 112, 14, 124, 14, 21, 42, 16, 1, 0, 0, 96, 0, 224,
  0, 192, 1, 128, 1, 0, 0, 0, 0, 0, 248, 240, 56, 112, 56, 112,
  56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112,
  56, 240, 25, 112, 14, 124, 14, 21, 42, 16, 1, 0, 2, 0, 3, 0,
  7, 0, 4, 128, 8, 64, 0, 0, 0, 0, 248, 240, 56, 112, 56, 112,
  56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112,
  56, 240, 25, 112, 14, 124, 14, 20, 40, 16, 1, 0, 24, 96, 28, 224,
  24, 96, 0, 0, 0, 0, 0, 0, 248, 240, 56, 112, 56, 112, 56, 112,
  56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 240,
  25, 112, 14, 124, 14, 28, 56, 15, 0, 249, 0, 48, 0, 112, 0, 96,
  0, 192, 1, 128, 0, 0, 0, 0, 254, 124, 24, 16, 24, 16, 28, 16,
  12, 32, 12, 32, 14, 32, 6, 64, 6, 64, 6, 64, 3, 128, 3, 128,
  3, 128, 1, 128, 1, 0, 1, 0, 1, 0, 98, 0, 114, 0, 100, 0,
  56, 0, 12, 28, 56, 14, 1, 249, 56, 0, 248, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 57, 224, 62, 112, 60, 112, 56, 112, 56, 112,
  56, 112, 56, 96, 56, 96, 56, 192, 56, 128, 57, 128, 58, 0, 60, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 48, 0, 192, 0,
  14, 26, 52, 15, 0, 249, 12, 48, 14, 112, 12, 48, 0, 0, 0, 0,
  254, 60, 24, 16, 24, 16, 28, 32, 12, 32, 12, 32, 14, 32, 6, 64,
  6, 64, 7, 64, 3, 128, 3, 128, 3, 128, 1, 0, 1, 0, 1, 0,
  1, 0, 114, 0, 114, 0, 116, 0, 56, 0
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--29-290-72-72-P-153-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 0, '1' Height: 21
  Calculated Max Values w=24 h=28 x= 3 y= 9 dx=26 dy= 0 ascent=22 len=75
  Font Bounding box     w=76 h=38 x=-24 y=-9
  Calculated Min Values           x= 0 y=-6 dx= 0 dy= 0
  Pure Font   ascent =21 descent= 0
  X Font      ascent =21 descent= 0
  Max Font    ascent =22 descent=-6
*/
const u8g_fntpgm_uint8_t u8g_font_osr21n[722] U8G_FONT_SECTION("u8g_font_osr21n") = {
  0, 76, 38, 232, 247, 21, 0, 0, 0, 0, 42, 58, 0, 22, 250, 21,
  0, 10, 12, 24, 14, 2, 9, 12, 0, 14, 0, 204, 64, 228, 192, 117,
  192, 14, 0, 30, 0, 229, 192, 196, 192, 12, 0, 14, 0, 12, 0, 24,
  25, 75, 26, 1, 252, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8,
  0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0,
  0, 8, 0, 0, 8, 0, 0, 8, 0, 255, 255, 255, 0, 8, 0, 0,
  8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8,
  0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0,
  4, 8, 8, 8, 2, 251, 224, 240, 240, 16, 16, 16, 32, 64, 7, 2,
  2, 11, 2, 7, 254, 254, 4, 4, 4, 8, 2, 0, 96, 240, 240, 96,
  9, 28, 56, 13, 2, 250, 0, 128, 0, 128, 1, 128, 1, 0, 1, 0,
  1, 0, 2, 0, 2, 0, 2, 0, 6, 0, 4, 0, 4, 0, 12, 0,
  8, 0, 8, 0, 24, 0, 16, 0, 16, 0, 16, 0, 32, 0, 32, 0,
  32, 0, 64, 0, 64, 0, 64, 0, 192, 0, 128, 0, 128, 0, 14, 21,
  42, 17, 1, 0, 7, 128, 24, 64, 48, 32, 32, 48, 96, 16, 96, 24,
  96, 24, 224, 24, 224, 24, 224, 24, 224, 28, 224, 28, 224, 24, 224, 24,
  224, 24, 96, 24, 96, 24, 96, 48, 48, 32, 16, 96, 15, 192, 10, 21,
  42, 17, 3, 0, 2, 0, 6, 0, 6, 0, 14, 0, 254, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 255, 192, 12, 21,
  42, 17, 2, 0, 31, 0, 32, 192, 64, 96, 128, 112, 128, 112, 192, 112,
  240, 112, 112, 112, 32, 96, 0, 224, 0, 192, 1, 0, 6, 0, 12, 0,
  24, 0, 48, 16, 96, 16, 64, 16, 224, 112, 255, 240, 255, 240, 12, 21,
  42, 17, 2, 0, 31, 0, 97, 192, 192, 224, 224, 96, 240, 96, 112, 112,
  0, 96, 0, 96, 0, 224, 48, 192, 63, 0, 0, 192, 0, 96, 0, 112,
  0, 112, 96, 112, 240, 112, 240, 112, 192, 96, 192, 192, 127, 128, 14, 21,
  42, 17, 2, 0, 0, 64, 0, 192, 1, 192, 1, 192, 3, 192, 7, 192,
  5, 192, 13, 192, 9, 192, 17, 192, 49, 192, 33, 192, 65, 192, 193, 192,
  255, 252, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 15, 252, 12, 21,
  42, 17, 2, 0, 96, 64, 127, 128, 127, 0, 64, 0, 64, 0, 64, 0,
  64, 0, 95, 0, 96, 192, 64, 96, 64, 96, 0, 112, 0, 112, 0, 112,
  96, 112, 240, 112, 240, 112, 224, 96, 192, 224, 64, 192, 63, 128, 12, 21,
  42, 17, 2, 0, 7, 128, 24, 64, 16, 96, 48, 224, 96, 224, 96, 192,
  96, 0, 224, 0, 231, 128, 232, 192, 240, 96, 240, 96, 224, 112, 224, 112,
  224, 112, 224, 112, 96, 112, 96, 96, 112, 96, 48, 192, 31, 128, 11, 21,
  42, 17, 3, 0, 255, 224, 255, 224, 192, 32, 128, 32, 128, 64, 128, 64,
  0, 64, 0, 128, 1, 0, 1, 0, 2, 0, 6, 0, 6, 0, 12, 0,
  12, 0, 12, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 14, 21,
  42, 17, 2, 0, 15, 128, 48, 96, 96, 48, 224, 24, 224, 24, 224, 24,
  224, 24, 240, 16, 124, 32, 63, 192, 15, 224, 51, 240, 96, 248, 224, 56,
  224, 28, 224, 28, 224, 24, 224, 24, 96, 24, 112, 48, 31, 192, 12, 21,
  42, 17, 2, 0, 15, 0, 48, 128, 96, 64, 96, 96, 224, 96, 224, 96,
  224, 112, 224, 112, 224, 112, 96, 112, 96, 240, 49, 176, 14, 48, 0, 48,
  0, 32, 48, 96, 112, 96, 112, 64, 96, 192, 96, 128, 63, 0, 4, 14,
  14, 8, 2, 0, 96, 240, 240, 96, 0, 0, 0, 0, 0, 0, 96, 240,
  240, 96
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--29-290-72-72-P-153-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 21, '1' Height: 21
  Calculated Max Values w=29 h=28 x= 4 y=17 dx=32 dy= 0 ascent=23 len=88
  Font Bounding box     w=76 h=38 x=-24 y=-9
  Calculated Min Values           x=-1 y=-7 dx= 0 dy= 0
  Pure Font   ascent =21 descent=-7
  X Font      ascent =22 descent=-7
  Max Font    ascent =23 descent=-7
*/
const u8g_fntpgm_uint8_t u8g_font_osr21r[4396] U8G_FONT_SECTION("u8g_font_osr21r") = {
  0, 76, 38, 232, 247, 21, 5, 131, 12, 189, 32, 127, 249, 23, 249, 22,
  249, 0, 0, 0, 8, 0, 0, 4, 21, 21, 8, 2, 0, 96, 240, 240,
  240, 240, 240, 96, 96, 96, 96, 96, 96, 96, 96, 96, 64, 0, 96, 240,
  240, 96, 7, 5, 5, 11, 2, 17, 238, 204, 204, 204, 68, 15, 21, 42,
  19, 2, 0, 2, 16, 6, 16, 6, 16, 4, 16, 4, 48, 4, 48, 255,
  254, 4, 32, 12, 32, 12, 32, 8, 32, 8, 96, 8, 96, 8, 64, 255,
  254, 24, 64, 24, 64, 16, 192, 16, 192, 16, 128, 16, 128, 13, 25, 50,
  17, 2, 254, 5, 0, 5, 0, 15, 128, 53, 96, 37, 16, 69, 24, 69,
  24, 69, 56, 69, 56, 117, 48, 61, 0, 63, 0, 15, 192, 7, 224, 5,
  240, 5, 48, 101, 24, 229, 24, 229, 24, 197, 24, 69, 48, 69, 32, 61,
  192, 7, 0, 5, 0, 19, 21, 63, 25, 3, 0, 60, 1, 0, 70, 2,
  0, 66, 2, 0, 195, 4, 0, 195, 8, 0, 195, 8, 0, 195, 16, 0,
  195, 16, 0, 66, 32, 0, 102, 32, 0, 56, 64, 0, 0, 67, 0, 0,
  140, 192, 1, 8, 64, 1, 24, 96, 2, 24, 96, 2, 24, 96, 4, 24,
  96, 4, 24, 96, 8, 8, 64, 8, 7, 128, 20, 21, 63, 23, 2, 0,
  3, 128, 0, 12, 64, 0, 8, 32, 0, 24, 32, 0, 24, 32, 0, 24,
  96, 0, 28, 64, 0, 12, 128, 0, 15, 0, 0, 7, 15, 240, 15, 1,
  128, 27, 129, 0, 51, 193, 0, 97, 194, 0, 96, 226, 0, 224, 244, 0,
  224, 124, 0, 224, 56, 0, 224, 60, 0, 96, 60, 32, 59, 198, 192, 3,
  5, 5, 7, 2, 17, 224, 192, 192, 192, 64, 6, 28, 28, 10, 3, 250,
  4, 12, 24, 16, 32, 32, 64, 64, 64, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 192, 64, 64, 32, 32, 16, 24, 8, 4, 6, 28, 28, 11,
  2, 250, 128, 192, 64, 32, 48, 16, 24, 8, 8, 8, 4, 4, 4, 4,
  4, 4, 4, 4, 12, 8, 8, 24, 16, 48, 32, 96, 192, 128, 10, 12,
  24, 14, 2, 9, 12, 0, 14, 0, 204, 64, 228, 192, 117, 192, 14, 0,
  30, 0, 229, 192, 196, 192, 12, 0, 14, 0, 12, 0, 24, 25, 75, 26,
  1, 252, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8,
  0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0,
  0, 8, 0, 0, 8, 0, 255, 255, 255, 0, 8, 0, 0, 8, 0, 0,
  8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8,
  0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 0, 8, 0, 4, 8, 8,
  8, 2, 251, 224, 240, 240, 16, 16, 16, 32, 64, 7, 2, 2, 11, 2,
  7, 254, 254, 4, 4, 4, 8, 2, 0, 96, 240, 240, 96, 9, 28, 56,
  13, 2, 250, 0, 128, 0, 128, 1, 128, 1, 0, 1, 0, 1, 0, 2,
  0, 2, 0, 2, 0, 6, 0, 4, 0, 4, 0, 12, 0, 8, 0, 8,
  0, 24, 0, 16, 0, 16, 0, 16, 0, 32, 0, 32, 0, 32, 0, 64,
  0, 64, 0, 64, 0, 192, 0, 128, 0, 128, 0, 14, 21, 42, 17, 1,
  0, 7, 128, 24, 64, 48, 32, 32, 48, 96, 16, 96, 24, 96, 24, 224,
  24, 224, 24, 224, 24, 224, 28, 224, 28, 224, 24, 224, 24, 224, 24, 96,
  24, 96, 24, 96, 48, 48, 32, 16, 96, 15, 192, 10, 21, 42, 17, 3,
  0, 2, 0, 6, 0, 6, 0, 14, 0, 254, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 14, 0, 14, 0, 255, 192, 12, 21, 42, 17, 2,
  0, 31, 0, 32, 192, 64, 96, 128, 112, 128, 112, 192, 112, 240, 112, 112,
  112, 32, 96, 0, 224, 0, 192, 1, 0, 6, 0, 12, 0, 24, 0, 48,
  16, 96, 16, 64, 16, 224, 112, 255, 240, 255, 240, 12, 21, 42, 17, 2,
  0, 31, 0, 97, 192, 192, 224, 224, 96, 240, 96, 112, 112, 0, 96, 0,
  96, 0, 224, 48, 192, 63, 0, 0, 192, 0, 96, 0, 112, 0, 112, 96,
  112, 240, 112, 240, 112, 192, 96, 192, 192, 127, 128, 14, 21, 42, 17, 2,
  0, 0, 64, 0, 192, 1, 192, 1, 192, 3, 192, 7, 192, 5, 192, 13,
  192, 9, 192, 17, 192, 49, 192, 33, 192, 65, 192, 193, 192, 255, 252, 1,
  192, 1, 192, 1, 192, 1, 192, 1, 192, 15, 252, 12, 21, 42, 17, 2,
  0, 96, 64, 127, 128, 127, 0, 64, 0, 64, 0, 64, 0, 64, 0, 95,
  0, 96, 192, 64, 96, 64, 96, 0, 112, 0, 112, 0, 112, 96, 112, 240,
  112, 240, 112, 224, 96, 192, 224, 64, 192, 63, 128, 12, 21, 42, 17, 2,
  0, 7, 128, 24, 64, 16, 96, 48, 224, 96, 224, 96, 192, 96, 0, 224,
  0, 231, 128, 232, 192, 240, 96, 240, 96, 224, 112, 224, 112, 224, 112, 224,
  112, 96, 112, 96, 96, 112, 96, 48, 192, 31, 128, 11, 21, 42, 17, 3,
  0, 255, 224, 255, 224, 192, 32, 128, 32, 128, 64, 128, 64, 0, 64, 0,
  128, 1, 0, 1, 0, 2, 0, 6, 0, 6, 0, 12, 0, 12, 0, 12,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 14, 21, 42, 17, 2,
  0, 15, 128, 48, 96, 96, 48, 224, 24, 224, 24, 224, 24, 224, 24, 240,
  16, 124, 32, 63, 192, 15, 224, 51, 240, 96, 248, 224, 56, 224, 28, 224,
  28, 224, 24, 224, 24, 96, 24, 112, 48, 31, 192, 12, 21, 42, 17, 2,
  0, 15, 0, 48, 128, 96, 64, 96, 96, 224, 96, 224, 96, 224, 112, 224,
  112, 224, 112, 96, 112, 96, 240, 49, 176, 14, 48, 0, 48, 0, 32, 48,
  96, 112, 96, 112, 64, 96, 192, 96, 128, 63, 0, 4, 14, 14, 8, 2,
  0, 96, 240, 240, 96, 0, 0, 0, 0, 0, 0, 96, 240, 240, 96, 4,
  18, 18, 8, 2, 251, 96, 240, 240, 96, 0, 0, 0, 0, 0, 0, 224,
  240, 240, 16, 16, 48, 32, 64, 22, 24, 72, 27, 2, 251, 0, 0, 12,
  0, 0, 56, 0, 0, 96, 0, 1, 128, 0, 7, 0, 0, 28, 0, 0,
  112, 0, 0, 192, 0, 3, 0, 0, 14, 0, 0, 56, 0, 0, 224, 0,
  0, 224, 0, 0, 48, 0, 0, 12, 0, 0, 7, 0, 0, 1, 192, 0,
  0, 112, 0, 0, 24, 0, 0, 6, 0, 0, 3, 128, 0, 0, 224, 0,
  0, 56, 0, 0, 12, 24, 7, 21, 26, 1, 5, 255, 255, 255, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
  22, 24, 72, 27, 3, 251, 192, 0, 0, 112, 0, 0, 24, 0, 0, 6,
  0, 0, 3, 128, 0, 0, 224, 0, 0, 56, 0, 0, 12, 0, 0, 3,
  0, 0, 0, 192, 0, 0, 112, 0, 0, 28, 0, 0, 28, 0, 0, 48,
  0, 0, 192, 0, 3, 128, 0, 14, 0, 0, 56, 0, 0, 96, 0, 1,
  128, 0, 7, 0, 0, 28, 0, 0, 112, 0, 0, 192, 0, 0, 11, 21,
  42, 14, 2, 0, 30, 0, 97, 128, 128, 192, 128, 192, 240, 224, 240, 192,
  97, 192, 1, 128, 3, 128, 6, 0, 12, 0, 8, 0, 17, 0, 17, 0,
  17, 0, 14, 0, 0, 0, 12, 0, 30, 0, 30, 0, 12, 0, 21, 21,
  63, 25, 2, 1, 3, 255, 0, 12, 0, 128, 24, 0, 64, 48, 0, 32,
  32, 59, 144, 64, 199, 16, 65, 135, 8, 131, 7, 8, 135, 6, 8, 134,
  6, 8, 142, 14, 8, 142, 14, 8, 142, 12, 16, 142, 28, 16, 142, 28,
  32, 70, 44, 64, 67, 199, 128, 32, 0, 0, 16, 0, 0, 8, 1, 128,
  7, 222, 0, 20, 21, 63, 22, 1, 0, 0, 32, 0, 0, 96, 0, 0,
  96, 0, 0, 112, 0, 0, 240, 0, 0, 240, 0, 0, 184, 0, 1, 56,
  0, 1, 56, 0, 3, 28, 0, 3, 28, 0, 2, 28, 0, 6, 14, 0,
  6, 14, 0, 7, 254, 0, 12, 7, 0, 12, 7, 0, 8, 7, 0, 24,
  3, 128, 24, 3, 128, 255, 31, 240, 16, 21, 42, 20, 2, 0, 255, 240,
  28, 12, 28, 6, 28, 7, 28, 7, 28, 7, 28, 7, 28, 6, 28, 12,
  31, 240, 28, 28, 28, 6, 28, 6, 28, 7, 28, 7, 28, 7, 28, 7,
  28, 7, 28, 6, 28, 12, 255, 240, 15, 21, 42, 19, 2, 1, 15, 226,
  16, 54, 48, 30, 32, 14, 96, 6, 96, 6, 224, 6, 224, 2, 224, 0,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 2, 96, 2, 96, 2, 96, 4,
  32, 4, 48, 12, 24, 8, 7, 240, 19, 21, 63, 22, 2, 0, 255, 248,
  0, 28, 6, 0, 28, 3, 0, 28, 1, 128, 28, 1, 128, 28, 1, 192,
  28, 0, 192, 28, 0, 192, 28, 0, 192, 28, 0, 224, 28, 0, 224, 28,
  0, 224, 28, 0, 192, 28, 0, 192, 28, 0, 192, 28, 1, 192, 28, 1,
  128, 28, 1, 0, 28, 3, 0, 28, 6, 0, 255, 248, 0, 17, 21, 63,
  20, 2, 0, 255, 255, 128, 28, 3, 128, 28, 3, 128, 28, 1, 128, 28,
  1, 128, 28, 0, 128, 28, 32, 128, 28, 32, 0, 28, 32, 0, 28, 96,
  0, 31, 224, 0, 28, 96, 0, 28, 32, 0, 28, 32, 128, 28, 32, 128,
  28, 0, 128, 28, 1, 128, 28, 1, 128, 28, 3, 128, 28, 7, 128, 255,
  255, 128, 17, 21, 63, 20, 2, 0, 255, 255, 128, 28, 3, 128, 28, 3,
  128, 28, 1, 128, 28, 1, 128, 28, 0, 128, 28, 32, 128, 28, 32, 0,
  28, 32, 0, 28, 96, 0, 31, 224, 0, 28, 96, 0, 28, 32, 0, 28,
  32, 0, 28, 32, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 0, 255, 128, 0, 18, 21, 63, 21, 2, 1, 15, 226, 0,
  24, 26, 0, 48, 14, 0, 32, 14, 0, 96, 6, 0, 96, 6, 0, 224,
  2, 0, 224, 2, 0, 224, 0, 0, 224, 0, 0, 224, 127, 192, 224, 14,
  0, 224, 14, 0, 224, 14, 0, 224, 14, 0, 96, 14, 0, 96, 14, 0,
  32, 14, 0, 48, 26, 0, 16, 50, 0, 15, 226, 0, 20, 21, 63, 23,
  2, 0, 255, 15, 240, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3,
  128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 31, 255, 128,
  28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28,
  3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 255, 15,
  240, 8, 21, 21, 12, 2, 0, 255, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 255, 13, 21, 42, 15,
  1, 0, 7, 248, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  112, 224, 240, 192, 240, 192, 192, 192, 65, 128, 127, 0, 19, 21, 63, 22,
  2, 0, 255, 31, 224, 28, 7, 0, 28, 6, 0, 28, 12, 0, 28, 8,
  0, 28, 16, 0, 28, 32, 0, 28, 64, 0, 28, 192, 0, 29, 224, 0,
  30, 224, 0, 28, 112, 0, 28, 112, 0, 28, 56, 0, 28, 28, 0, 28,
  28, 0, 28, 14, 0, 28, 14, 0, 28, 7, 0, 28, 7, 0, 255, 63,
  224, 16, 21, 42, 20, 2, 0, 255, 128, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 1, 28, 1, 28, 1, 28, 1, 28, 3, 28, 3, 28, 15, 255,
  255, 21, 21, 63, 25, 2, 0, 252, 1, 248, 30, 1, 224, 30, 1, 224,
  30, 2, 224, 22, 2, 224, 23, 2, 224, 23, 2, 224, 19, 4, 224, 19,
  132, 224, 19, 132, 224, 17, 132, 224, 17, 200, 224, 17, 200, 224, 16, 200,
  224, 16, 208, 224, 16, 240, 224, 16, 240, 224, 16, 112, 224, 16, 96, 224,
  16, 96, 224, 254, 39, 248, 20, 21, 63, 23, 2, 0, 252, 7, 240, 28,
  0, 128, 30, 0, 128, 31, 0, 128, 23, 0, 128, 19, 128, 128, 19, 192,
  128, 17, 192, 128, 16, 224, 128, 16, 240, 128, 16, 112, 128, 16, 56, 128,
  16, 56, 128, 16, 28, 128, 16, 30, 128, 16, 14, 128, 16, 7, 128, 16,
  7, 128, 16, 3, 128, 16, 1, 128, 254, 1, 128, 17, 22, 66, 20, 2,
  0, 0, 128, 0, 7, 112, 0, 24, 8, 0, 16, 12, 0, 48, 6, 0,
  96, 6, 0, 96, 3, 0, 96, 3, 0, 224, 3, 0, 224, 3, 0, 224,
  3, 0, 224, 3, 128, 224, 3, 128, 224, 3, 0, 224, 3, 0, 96, 3,
  0, 96, 3, 0, 96, 6, 0, 48, 6, 0, 16, 12, 0, 24, 8, 0,
  7, 240, 0, 17, 21, 63, 20, 2, 0, 255, 248, 0, 28, 14, 0, 28,
  7, 0, 28, 3, 0, 28, 3, 0, 28, 3, 128, 28, 3, 0, 28, 3,
  0, 28, 6, 0, 28, 12, 0, 31, 240, 0, 28, 0, 0, 28, 0, 0,
  28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28,
  0, 0, 28, 0, 0, 255, 128, 0, 17, 27, 81, 20, 2, 251, 0, 128,
  0, 7, 112, 0, 24, 8, 0, 16, 12, 0, 48, 6, 0, 96, 6, 0,
  96, 3, 0, 96, 3, 0, 224, 3, 0, 224, 3, 0, 224, 3, 0, 224,
  3, 128, 224, 3, 128, 224, 3, 0, 224, 3, 0, 96, 3, 0, 96, 3,
  0, 97, 198, 0, 51, 38, 0, 26, 60, 0, 14, 60, 0, 7, 48, 128,
  0, 241, 0, 0, 49, 0, 0, 57, 0, 0, 31, 0, 0, 14, 0, 18,
  21, 63, 21, 2, 0, 255, 248, 0, 28, 14, 0, 28, 6, 0, 28, 7,
  0, 28, 7, 0, 28, 7, 0, 28, 7, 0, 28, 6, 0, 28, 12, 0,
  31, 240, 0, 28, 24, 0, 28, 24, 0, 28, 12, 0, 28, 12, 0, 28,
  12, 0, 28, 14, 0, 28, 14, 64, 28, 14, 64, 28, 14, 64, 28, 7,
  128, 255, 131, 128, 14, 21, 42, 18, 3, 1, 63, 144, 96, 208, 192, 112,
  192, 48, 192, 16, 192, 16, 224, 16, 240, 16, 124, 0, 63, 128, 31, 224,
  7, 240, 128, 248, 128, 56, 128, 28, 128, 12, 192, 12, 224, 12, 224, 8,
  144, 16, 142, 224, 17, 21, 63, 21, 2, 0, 255, 255, 128, 225, 195, 128,
  193, 193, 128, 193, 193, 128, 193, 192, 128, 129, 192, 128, 129, 192, 128, 129,
  192, 128, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192,
  0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0,
  1, 192, 0, 1, 192, 0, 15, 248, 0, 20, 21, 63, 23, 2, 0, 255,
  7, 240, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0,
  128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128,
  28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28, 0, 128, 28,
  0, 128, 12, 0, 128, 12, 1, 0, 6, 2, 0, 3, 252, 0, 20, 22,
  66, 23, 2, 255, 255, 143, 240, 28, 1, 192, 28, 1, 128, 14, 1, 128,
  14, 1, 0, 14, 1, 0, 7, 3, 0, 7, 2, 0, 7, 2, 0, 3,
  134, 0, 3, 132, 0, 3, 132, 0, 1, 196, 0, 1, 200, 0, 1, 200,
  0, 0, 232, 0, 0, 240, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0,
  0, 32, 0, 0, 32, 0, 29, 22, 88, 32, 2, 255, 255, 63, 231, 248,
  28, 7, 0, 192, 28, 7, 0, 128, 28, 7, 0, 128, 12, 7, 128, 128,
  14, 15, 129, 128, 14, 11, 129, 0, 6, 9, 129, 0, 7, 9, 195, 0,
  7, 25, 194, 0, 7, 17, 194, 0, 3, 16, 230, 0, 3, 144, 228, 0,
  3, 176, 228, 0, 1, 160, 108, 0, 1, 224, 120, 0, 1, 224, 120, 0,
  1, 192, 120, 0, 0, 192, 48, 0, 0, 192, 48, 0, 0, 192, 48, 0,
  0, 128, 16, 0, 19, 21, 63, 22, 2, 0, 255, 159, 224, 14, 7, 0,
  14, 6, 0, 7, 4, 0, 7, 12, 0, 3, 136, 0, 3, 208, 0, 1,
  208, 0, 1, 224, 0, 0, 224, 0, 0, 112, 0, 0, 240, 0, 1, 184,
  0, 1, 56, 0, 2, 28, 0, 6, 28, 0, 4, 14, 0, 8, 14, 0,
  24, 7, 0, 24, 7, 0, 255, 31, 224, 19, 21, 63, 21, 1, 0, 255,
  143, 224, 30, 3, 128, 14, 3, 0, 14, 2, 0, 7, 2, 0, 7, 4,
  0, 3, 132, 0, 1, 200, 0, 1, 200, 0, 0, 240, 0, 0, 240, 0,
  0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0,
  112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 7, 254, 0, 15, 21,
  42, 19, 2, 0, 63, 254, 56, 14, 112, 28, 96, 56, 64, 56, 64, 112,
  64, 240, 0, 224, 1, 192, 1, 192, 3, 128, 7, 128, 7, 0, 14, 2,
  14, 2, 28, 2, 60, 2, 56, 6, 112, 6, 240, 14, 255, 254, 6, 27,
  27, 11, 3, 250, 252, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 252, 9,
  28, 56, 13, 2, 250, 128, 0, 128, 0, 192, 0, 64, 0, 64, 0, 64,
  0, 32, 0, 32, 0, 32, 0, 16, 0, 16, 0, 16, 0, 24, 0, 8,
  0, 8, 0, 12, 0, 4, 0, 4, 0, 4, 0, 2, 0, 2, 0, 2,
  0, 1, 0, 1, 0, 1, 0, 1, 128, 0, 128, 0, 128, 6, 27, 27,
  11, 2, 250, 252, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 252, 13, 11,
  22, 17, 2, 10, 2, 0, 2, 0, 5, 0, 13, 128, 8, 128, 24, 192,
  16, 64, 32, 32, 96, 48, 64, 16, 192, 24, 15, 1, 2, 15, 0, 251,
  255, 254, 5, 5, 5, 13, 2, 16, 192, 224, 96, 48, 8, 13, 14, 28,
  15, 1, 0, 31, 0, 33, 128, 97, 192, 113, 192, 113, 192, 1, 192, 15,
  192, 49, 192, 97, 192, 225, 192, 225, 200, 225, 200, 226, 216, 60, 240, 13,
  21, 42, 15, 1, 0, 248, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 59, 192, 60, 96, 56, 48, 56, 48, 56, 48, 56, 48, 56,
  56, 56, 56, 56, 48, 56, 48, 56, 48, 56, 48, 36, 96, 35, 192, 10,
  14, 28, 12, 1, 0, 31, 0, 48, 128, 96, 64, 96, 192, 225, 192, 224,
  128, 224, 0, 224, 0, 224, 0, 224, 0, 96, 64, 96, 128, 48, 128, 31,
  0, 13, 21, 42, 15, 1, 0, 3, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 224, 0, 224, 30, 224, 49, 224, 97, 224, 96, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 96, 224, 96, 224, 49, 224, 30,
  248, 10, 14, 28, 13, 1, 0, 30, 0, 49, 128, 97, 128, 96, 192, 224,
  192, 224, 192, 255, 192, 224, 0, 224, 0, 224, 64, 96, 64, 96, 64, 48,
  128, 31, 0, 10, 21, 42, 10, 1, 0, 15, 0, 24, 128, 57, 192, 57,
  128, 56, 0, 56, 0, 56, 0, 254, 0, 56, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56,
  0, 254, 0, 14, 21, 42, 16, 2, 249, 31, 56, 113, 200, 96, 220, 224,
  248, 224, 224, 224, 224, 224, 224, 96, 192, 49, 128, 31, 0, 96, 0, 128,
  0, 224, 0, 127, 224, 56, 112, 64, 16, 128, 16, 128, 16, 128, 48, 64,
  96, 63, 128, 14, 21, 42, 16, 1, 0, 248, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 56, 0, 56, 0, 57, 192, 62, 96, 60, 112, 56, 112, 56,
  112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56,
  112, 252, 252, 6, 21, 21, 7, 1, 0, 112, 112, 112, 0, 0, 0, 0,
  240, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 112, 252, 8, 28,
  28, 9, 255, 249, 6, 7, 6, 0, 0, 0, 0, 31, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 70, 230, 198, 204, 120,
  13, 21, 42, 15, 1, 0, 248, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 57, 248, 56, 192, 56, 128, 57, 0, 57, 0, 58, 0,
  63, 0, 63, 0, 59, 128, 57, 192, 56, 192, 56, 224, 56, 224, 253, 248,
  7, 21, 21, 8, 1, 0, 248, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 254, 21, 14, 42, 23, 1,
  0, 249, 195, 192, 62, 100, 224, 60, 120, 96, 56, 120, 96, 56, 112, 96,
  56, 112, 96, 56, 112, 96, 56, 112, 96, 56, 112, 96, 56, 112, 96, 56,
  112, 96, 56, 112, 96, 56, 112, 96, 252, 253, 248, 14, 14, 28, 16, 1,
  0, 249, 192, 62, 96, 60, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56,
  112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 252, 252, 12, 14, 28,
  14, 1, 0, 15, 0, 48, 128, 96, 192, 96, 96, 224, 96, 224, 96, 224,
  112, 224, 112, 224, 96, 224, 96, 96, 96, 96, 192, 48, 128, 15, 0, 13,
  21, 42, 15, 1, 249, 251, 192, 60, 96, 56, 48, 56, 48, 56, 48, 56,
  48, 56, 56, 56, 56, 56, 48, 56, 48, 56, 48, 56, 48, 60, 96, 59,
  192, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 252, 0, 13,
  21, 42, 15, 1, 249, 30, 32, 49, 32, 96, 224, 96, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 96, 224, 96, 224, 49, 224, 30,
  224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 3, 248, 10,
  14, 28, 12, 1, 0, 249, 128, 58, 64, 60, 192, 60, 192, 56, 0, 56,
  0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 252,
  0, 10, 14, 28, 13, 2, 0, 60, 128, 195, 128, 129, 128, 128, 128, 192,
  128, 240, 0, 62, 0, 15, 128, 131, 192, 128, 192, 192, 64, 192, 64, 160,
  128, 159, 0, 8, 20, 20, 10, 1, 0, 16, 16, 16, 16, 48, 48, 254,
  48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 59, 30, 14, 14, 28,
  16, 1, 0, 248, 240, 56, 112, 56, 112, 56, 112, 56, 112, 56, 112, 56,
  112, 56, 112, 56, 112, 56, 112, 56, 112, 56, 240, 25, 112, 14, 124, 15,
  14, 28, 15, 0, 0, 254, 126, 56, 16, 24, 16, 28, 16, 12, 32, 12,
  32, 6, 32, 6, 64, 7, 64, 3, 64, 3, 128, 1, 128, 1, 128, 1,
  0, 22, 14, 42, 22, 0, 0, 254, 252, 252, 56, 56, 32, 24, 56, 32,
  28, 56, 32, 12, 56, 64, 12, 60, 64, 6, 76, 64, 6, 76, 128, 7,
  70, 128, 3, 134, 128, 3, 135, 0, 1, 131, 0, 1, 131, 0, 1, 2,
  0, 14, 14, 28, 16, 1, 0, 124, 248, 56, 96, 24, 64, 12, 128, 14,
  128, 7, 0, 7, 0, 3, 128, 5, 128, 5, 192, 8, 192, 16, 224, 16,
  96, 249, 252, 15, 21, 42, 15, 0, 249, 254, 126, 24, 16, 24, 16, 28,
  16, 12, 32, 12, 32, 14, 32, 6, 64, 6, 64, 6, 64, 3, 128, 3,
  128, 3, 128, 1, 128, 1, 0, 1, 0, 1, 0, 98, 0, 114, 0, 100,
  0, 56, 0, 10, 14, 28, 13, 1, 0, 255, 192, 193, 192, 129, 128, 131,
  0, 135, 0, 6, 0, 14, 0, 28, 0, 24, 0, 56, 64, 48, 64, 112,
  64, 224, 192, 255, 192, 6, 27, 27, 12, 3, 250, 12, 24, 48, 48, 48,
  48, 48, 56, 24, 24, 24, 16, 48, 192, 48, 16, 24, 24, 24, 56, 48,
  48, 48, 48, 48, 16, 12, 1, 28, 28, 8, 4, 250, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 6, 27, 27, 12, 3, 250, 128, 96,
  32, 48, 48, 48, 112, 96, 96, 96, 96, 96, 32, 28, 48, 96, 96, 96,
  96, 96, 112, 48, 48, 48, 32, 96, 192, 16, 6, 12, 18, 1, 5, 56,
  2, 126, 1, 143, 193, 131, 241, 128, 255, 64, 62, 255
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--36-360-72-72-P-189-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 26, '1' Height: 25
  Calculated Max Values w=36 h=35 x= 7 y=21 dx=38 dy= 0 ascent=35 len=140
  Font Bounding box     w=94 h=46 x=-29 y=-11
  Calculated Min Values           x=-1 y=-10 dx= 0 dy= 0
  Pure Font   ascent =26 descent=-8
  X Font      ascent =27 descent=-8
  Max Font    ascent =35 descent=-10
*/
const u8g_fntpgm_uint8_t u8g_font_osr26[13186] U8G_FONT_SECTION("u8g_font_osr26") = {
  0, 94, 46, 227, 245, 26, 7, 96, 17, 82, 32, 255, 248, 35, 246, 27,
  248, 0, 0, 0, 10, 0, 0, 4, 25, 25, 10, 3, 0, 96, 240, 240,
  240, 240, 240, 240, 240, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 32,
  64, 96, 240, 240, 240, 96, 8, 7, 7, 14, 3, 20, 195, 195, 195, 195,
  195, 195, 66, 19, 25, 75, 25, 3, 0, 1, 130, 0, 1, 130, 0, 1,
  2, 0, 1, 6, 0, 3, 6, 0, 3, 6, 0, 3, 6, 0, 255, 255,
  224, 2, 4, 0, 2, 4, 0, 2, 12, 0, 6, 12, 0, 6, 12, 0,
  6, 12, 0, 6, 8, 0, 4, 8, 0, 4, 8, 0, 255, 255, 224, 12,
  24, 0, 12, 24, 0, 12, 16, 0, 8, 16, 0, 8, 48, 0, 8, 48,
  0, 24, 48, 0, 16, 31, 62, 21, 2, 253, 2, 64, 2, 64, 2, 64,
  7, 224, 26, 92, 50, 70, 34, 66, 98, 67, 98, 71, 98, 79, 98, 79,
  114, 78, 58, 64, 63, 64, 31, 192, 7, 240, 3, 252, 2, 126, 2, 78,
  34, 71, 242, 67, 242, 67, 226, 67, 226, 67, 194, 66, 66, 70, 34, 76,
  30, 112, 3, 192, 2, 64, 2, 64, 24, 25, 75, 30, 3, 0, 30, 0,
  48, 33, 0, 32, 97, 128, 96, 192, 192, 64, 192, 192, 192, 192, 192, 128,
  192, 193, 0, 192, 195, 0, 192, 194, 0, 64, 134, 0, 97, 132, 0, 34,
  8, 0, 28, 24, 112, 0, 16, 132, 0, 49, 134, 0, 33, 2, 0, 67,
  3, 0, 195, 3, 0, 131, 3, 1, 131, 3, 1, 3, 3, 3, 3, 3,
  6, 1, 6, 4, 1, 134, 12, 0, 252, 24, 25, 75, 28, 2, 0, 1,
  240, 0, 3, 8, 0, 6, 12, 0, 12, 4, 0, 12, 4, 0, 12, 12,
  0, 14, 8, 0, 14, 24, 0, 7, 48, 0, 7, 192, 0, 3, 193, 255,
  7, 192, 56, 13, 224, 48, 24, 240, 48, 48, 112, 32, 112, 120, 96, 112,
  60, 64, 224, 28, 128, 224, 15, 128, 224, 15, 0, 224, 7, 0, 240, 3,
  129, 112, 15, 194, 120, 25, 228, 31, 224, 252, 2, 7, 7, 8, 3, 20,
  192, 192, 192, 192, 192, 192, 64, 8, 33, 33, 14, 4, 250, 3, 6, 12,
  12, 24, 16, 48, 48, 96, 96, 96, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 64, 96, 96, 96, 48, 48, 24, 24, 12, 6, 6, 3, 8, 33,
  33, 13, 2, 250, 192, 96, 96, 48, 24, 24, 12, 12, 6, 6, 6, 2,
  3, 3, 3, 3, 3, 3, 3, 3, 2, 6, 6, 6, 4, 12, 12, 24,
  24, 48, 96, 192, 128, 13, 15, 30, 18, 3, 10, 7, 0, 7, 0, 7,
  0, 195, 24, 226, 56, 242, 120, 58, 224, 7, 0, 7, 128, 122, 240, 242,
  120, 226, 56, 7, 0, 7, 0, 7, 0, 30, 31, 124, 34, 2, 250, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 255, 255, 255, 252, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 5, 11, 11, 10, 2,
  250, 112, 248, 248, 120, 8, 8, 8, 16, 16, 32, 64, 9, 2, 4, 13,
  2, 8, 255, 128, 255, 128, 4, 5, 5, 10, 3, 0, 96, 240, 240, 240,
  96, 12, 34, 68, 16, 2, 249, 0, 16, 0, 48, 0, 48, 0, 32, 0,
  96, 0, 96, 0, 64, 0, 192, 0, 192, 0, 128, 0, 128, 1, 128, 1,
  0, 1, 0, 3, 0, 2, 0, 2, 0, 6, 0, 4, 0, 4, 0, 12,
  0, 8, 0, 8, 0, 24, 0, 24, 0, 16, 0, 48, 0, 48, 0, 32,
  0, 96, 0, 96, 0, 64, 0, 192, 0, 192, 0, 17, 25, 75, 21, 2,
  0, 3, 224, 0, 14, 56, 0, 28, 28, 0, 24, 12, 0, 56, 14, 0,
  112, 7, 0, 112, 7, 0, 112, 7, 0, 240, 7, 128, 240, 7, 128, 240,
  7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7,
  128, 240, 7, 128, 112, 7, 0, 112, 7, 0, 112, 7, 0, 56, 14, 0,
  56, 14, 0, 24, 12, 0, 12, 24, 0, 7, 112, 0, 12, 25, 50, 21,
  4, 0, 1, 0, 3, 0, 3, 0, 15, 0, 255, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 255, 240, 15, 25, 50, 21, 3, 0, 15, 192, 48, 112, 96, 56,
  64, 60, 192, 30, 192, 30, 224, 30, 248, 30, 248, 30, 120, 28, 0, 60,
  0, 56, 0, 112, 0, 224, 1, 192, 3, 0, 14, 0, 28, 4, 56, 4,
  48, 4, 96, 4, 96, 12, 255, 252, 255, 252, 255, 252, 15, 25, 50, 21,
  3, 0, 15, 192, 48, 112, 32, 56, 96, 28, 112, 28, 120, 28, 120, 28,
  48, 28, 0, 28, 0, 56, 0, 112, 31, 192, 24, 112, 0, 56, 0, 60,
  0, 30, 0, 30, 112, 30, 248, 30, 248, 30, 248, 30, 192, 60, 192, 56,
  96, 112, 63, 224, 17, 25, 75, 21, 2, 0, 0, 16, 0, 0, 48, 0,
  0, 112, 0, 0, 112, 0, 0, 240, 0, 1, 240, 0, 1, 112, 0, 3,
  112, 0, 6, 112, 0, 6, 112, 0, 12, 112, 0, 8, 112, 0, 24, 112,
  0, 48, 112, 0, 32, 112, 0, 96, 112, 0, 192, 112, 0, 255, 255, 128,
  0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0,
  112, 0, 7, 255, 128, 15, 26, 52, 21, 3, 0, 32, 0, 48, 56, 63,
  240, 63, 192, 47, 0, 32, 0, 32, 0, 32, 0, 32, 0, 39, 192, 56,
  112, 48, 56, 32, 60, 32, 28, 0, 30, 0, 30, 0, 30, 0, 30, 120,
  30, 248, 30, 248, 28, 240, 60, 224, 60, 96, 56, 112, 112, 63, 192, 15,
  25, 50, 21, 3, 0, 3, 224, 6, 24, 12, 12, 24, 28, 56, 60, 48,
  60, 112, 16, 112, 0, 112, 0, 243, 224, 246, 56, 252, 28, 248, 28, 248,
  14, 240, 14, 240, 14, 240, 14, 240, 14, 112, 14, 112, 14, 112, 12, 56,
  28, 56, 24, 24, 56, 14, 224, 14, 25, 50, 21, 3, 0, 255, 252, 255,
  252, 255, 252, 192, 12, 128, 8, 128, 8, 128, 8, 128, 16, 0, 16, 0,
  32, 0, 96, 0, 64, 0, 128, 1, 128, 1, 128, 3, 0, 3, 0, 7,
  0, 7, 0, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 7, 128, 17,
  25, 75, 21, 2, 0, 7, 240, 0, 28, 28, 0, 48, 14, 0, 112, 6,
  0, 224, 3, 0, 224, 3, 0, 224, 3, 0, 240, 3, 0, 240, 6, 0,
  124, 6, 0, 127, 140, 0, 31, 240, 0, 7, 252, 0, 25, 254, 0, 48,
  63, 0, 96, 15, 128, 224, 7, 128, 224, 3, 128, 224, 3, 128, 224, 3,
  128, 224, 3, 0, 96, 7, 0, 112, 6, 0, 56, 12, 0, 15, 248, 0,
  15, 25, 50, 21, 3, 0, 7, 192, 24, 96, 48, 48, 112, 56, 112, 28,
  224, 28, 224, 28, 224, 30, 224, 30, 224, 30, 224, 30, 112, 62, 112, 62,
  56, 94, 15, 158, 0, 30, 0, 28, 0, 28, 56, 28, 120, 28, 120, 56,
  112, 56, 96, 112, 48, 224, 31, 192, 4, 17, 17, 10, 3, 0, 96, 240,
  240, 240, 96, 0, 0, 0, 0, 0, 0, 0, 96, 240, 240, 240, 96, 5,
  23, 23, 11, 3, 250, 112, 248, 248, 248, 112, 0, 0, 0, 0, 0, 0,
  0, 112, 248, 248, 120, 24, 24, 24, 16, 48, 32, 64, 28, 29, 116, 34,
  3, 251, 0, 0, 0, 112, 0, 0, 1, 192, 0, 0, 7, 0, 0, 0,
  28, 0, 0, 0, 112, 0, 0, 1, 224, 0, 0, 3, 128, 0, 0, 14,
  0, 0, 0, 56, 0, 0, 0, 224, 0, 0, 3, 128, 0, 0, 15, 0,
  0, 0, 28, 0, 0, 0, 112, 0, 0, 0, 192, 0, 0, 0, 112, 0,
  0, 0, 28, 0, 0, 0, 7, 0, 0, 0, 1, 192, 0, 0, 0, 240,
  0, 0, 0, 56, 0, 0, 0, 14, 0, 0, 0, 3, 128, 0, 0, 0,
  224, 0, 0, 0, 56, 0, 0, 0, 14, 0, 0, 0, 7, 0, 0, 0,
  1, 192, 0, 0, 0, 112, 30, 8, 32, 34, 2, 6, 255, 255, 255, 252,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 252, 28, 29, 116, 34,
  3, 251, 224, 0, 0, 0, 56, 0, 0, 0, 14, 0, 0, 0, 3, 128,
  0, 0, 0, 224, 0, 0, 0, 112, 0, 0, 0, 28, 0, 0, 0, 7,
  0, 0, 0, 1, 192, 0, 0, 0, 112, 0, 0, 0, 28, 0, 0, 0,
  15, 0, 0, 0, 3, 128, 0, 0, 0, 224, 0, 0, 0, 48, 0, 0,
  0, 224, 0, 0, 3, 128, 0, 0, 14, 0, 0, 0, 56, 0, 0, 0,
  240, 0, 0, 1, 192, 0, 0, 7, 0, 0, 0, 28, 0, 0, 0, 112,
  0, 0, 1, 192, 0, 0, 7, 0, 0, 0, 30, 0, 0, 0, 56, 0,
  0, 0, 224, 0, 0, 0, 13, 25, 50, 17, 2, 0, 15, 128, 48, 224,
  64, 112, 192, 56, 192, 56, 248, 56, 248, 56, 112, 56, 0, 112, 0, 224,
  1, 192, 3, 128, 3, 0, 4, 0, 12, 0, 8, 64, 8, 64, 8, 128,
  7, 0, 0, 0, 3, 0, 7, 128, 7, 128, 7, 128, 3, 0, 26, 27,
  108, 30, 2, 0, 0, 4, 0, 0, 0, 251, 224, 0, 3, 0, 56, 0,
  6, 0, 12, 0, 12, 0, 6, 0, 24, 0, 3, 0, 48, 15, 1, 0,
  48, 49, 241, 128, 96, 96, 241, 128, 96, 192, 224, 128, 193, 192, 224, 192,
  193, 128, 224, 192, 193, 128, 192, 192, 195, 128, 192, 192, 195, 1, 192, 192,
  195, 1, 192, 192, 195, 1, 129, 128, 195, 3, 129, 128, 67, 7, 129, 0,
  99, 7, 130, 0, 97, 137, 132, 0, 32, 240, 248, 0, 48, 0, 0, 0,
  24, 0, 0, 0, 12, 0, 16, 0, 7, 0, 48, 0, 1, 255, 192, 0,
  25, 26, 104, 28, 2, 0, 0, 8, 0, 0, 0, 12, 0, 0, 0, 28,
  0, 0, 0, 28, 0, 0, 0, 30, 0, 0, 0, 62, 0, 0, 0, 46,
  0, 0, 0, 47, 0, 0, 0, 103, 0, 0, 0, 103, 0, 0, 0, 71,
  128, 0, 0, 195, 128, 0, 0, 195, 128, 0, 0, 131, 192, 0, 1, 129,
  192, 0, 1, 129, 192, 0, 3, 1, 224, 0, 3, 255, 224, 0, 2, 0,
  224, 0, 6, 0, 240, 0, 6, 0, 112, 0, 6, 0, 112, 0, 12, 0,
  120, 0, 12, 0, 120, 0, 30, 0, 120, 0, 255, 195, 255, 128, 20, 26,
  78, 25, 3, 0, 255, 252, 0, 28, 3, 0, 28, 1, 192, 28, 1, 192,
  28, 0, 224, 28, 0, 224, 28, 0, 224, 28, 0, 224, 28, 0, 224, 28,
  1, 192, 28, 1, 128, 28, 3, 0, 31, 252, 0, 28, 7, 0, 28, 1,
  192, 28, 1, 224, 28, 0, 224, 28, 0, 240, 28, 0, 240, 28, 0, 240,
  28, 0, 240, 28, 0, 240, 28, 1, 224, 28, 1, 192, 28, 3, 128, 255,
  254, 0, 19, 26, 78, 24, 3, 1, 3, 252, 32, 14, 6, 96, 28, 3,
  224, 24, 1, 224, 56, 0, 224, 120, 0, 224, 112, 0, 96, 112, 0, 96,
  240, 0, 96, 240, 0, 32, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240,
  0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 112, 0, 32, 112, 0,
  32, 120, 0, 96, 56, 0, 64, 56, 0, 64, 28, 0, 128, 12, 0, 128,
  6, 3, 0, 3, 222, 0, 24, 26, 78, 29, 3, 0, 255, 255, 0, 28,
  1, 192, 28, 0, 112, 28, 0, 56, 28, 0, 56, 28, 0, 28, 28, 0,
  30, 28, 0, 30, 28, 0, 14, 28, 0, 15, 28, 0, 15, 28, 0, 15,
  28, 0, 15, 28, 0, 15, 28, 0, 15, 28, 0, 15, 28, 0, 15, 28,
  0, 14, 28, 0, 30, 28, 0, 30, 28, 0, 28, 28, 0, 56, 28, 0,
  56, 28, 0, 112, 28, 1, 192, 255, 255, 0, 21, 26, 78, 25, 2, 0,
  255, 255, 248, 14, 0, 120, 14, 0, 56, 14, 0, 24, 14, 0, 24, 14,
  0, 8, 14, 0, 8, 14, 4, 8, 14, 4, 0, 14, 4, 0, 14, 12,
  0, 14, 12, 0, 15, 252, 0, 14, 12, 0, 14, 4, 0, 14, 4, 0,
  14, 4, 8, 14, 4, 8, 14, 0, 8, 14, 0, 8, 14, 0, 24, 14,
  0, 24, 14, 0, 56, 14, 0, 56, 14, 0, 248, 255, 255, 248, 20, 26,
  78, 24, 2, 0, 255, 255, 240, 14, 0, 240, 14, 0, 112, 14, 0, 48,
  14, 0, 48, 14, 0, 16, 14, 0, 16, 14, 4, 16, 14, 4, 0, 14,
  4, 0, 14, 12, 0, 14, 12, 0, 15, 252, 0, 14, 12, 0, 14, 12,
  0, 14, 4, 0, 14, 4, 0, 14, 4, 0, 14, 0, 0, 14, 0, 0,
  14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 255,
  224, 0, 22, 27, 81, 26, 3, 0, 0, 32, 0, 3, 220, 32, 6, 7,
  32, 12, 3, 224, 24, 1, 224, 56, 0, 224, 56, 0, 96, 112, 0, 96,
  112, 0, 96, 112, 0, 32, 240, 0, 32, 240, 0, 0, 240, 0, 0, 240,
  0, 0, 240, 15, 252, 240, 0, 224, 240, 0, 224, 240, 0, 224, 240, 0,
  224, 112, 0, 224, 112, 0, 224, 56, 0, 224, 56, 1, 224, 24, 1, 32,
  12, 3, 32, 6, 6, 32, 3, 252, 32, 24, 26, 78, 28, 2, 0, 255,
  195, 255, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0,
  56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56,
  14, 0, 56, 15, 255, 248, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14,
  0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0,
  56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 255, 195, 255, 10, 26, 52,
  14, 2, 0, 255, 192, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 255, 192, 16, 26, 52, 19, 2, 0, 3, 255, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 112, 56, 248, 56, 248, 56, 240, 56, 192, 48, 192, 112, 96, 96, 63,
  192, 24, 26, 78, 28, 2, 0, 255, 199, 254, 14, 1, 240, 14, 0, 224,
  14, 0, 192, 14, 1, 128, 14, 3, 0, 14, 6, 0, 14, 12, 0, 14,
  24, 0, 14, 24, 0, 14, 56, 0, 14, 124, 0, 14, 188, 0, 15, 62,
  0, 15, 30, 0, 14, 31, 0, 14, 15, 0, 14, 15, 128, 14, 7, 128,
  14, 7, 192, 14, 3, 192, 14, 1, 224, 14, 1, 240, 14, 0, 240, 14,
  0, 248, 255, 199, 255, 20, 26, 78, 24, 2, 0, 255, 224, 0, 14, 0,
  0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0,
  14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14,
  0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 16, 14, 0,
  16, 14, 0, 32, 14, 0, 48, 14, 0, 48, 14, 0, 48, 14, 0, 112,
  14, 0, 240, 14, 3, 240, 255, 255, 240, 26, 26, 104, 30, 2, 0, 255,
  0, 31, 192, 15, 0, 30, 0, 15, 128, 30, 0, 15, 128, 46, 0, 11,
  128, 46, 0, 11, 128, 46, 0, 11, 192, 110, 0, 9, 192, 78, 0, 9,
  192, 78, 0, 9, 224, 78, 0, 8, 224, 142, 0, 8, 224, 142, 0, 8,
  224, 142, 0, 8, 241, 142, 0, 8, 113, 14, 0, 8, 113, 14, 0, 8,
  121, 14, 0, 8, 59, 14, 0, 8, 58, 14, 0, 8, 58, 14, 0, 8,
  30, 14, 0, 8, 28, 14, 0, 8, 28, 14, 0, 8, 12, 14, 0, 28,
  12, 14, 0, 255, 136, 255, 192, 25, 26, 104, 28, 2, 0, 254, 0, 255,
  128, 15, 0, 28, 0, 15, 128, 8, 0, 15, 128, 8, 0, 11, 192, 8,
  0, 11, 192, 8, 0, 9, 224, 8, 0, 8, 240, 8, 0, 8, 240, 8,
  0, 8, 120, 8, 0, 8, 60, 8, 0, 8, 60, 8, 0, 8, 30, 8,
  0, 8, 30, 8, 0, 8, 15, 8, 0, 8, 7, 136, 0, 8, 7, 136,
  0, 8, 3, 200, 0, 8, 1, 232, 0, 8, 1, 232, 0, 8, 0, 248,
  0, 8, 0, 120, 0, 8, 0, 120, 0, 8, 0, 56, 0, 28, 0, 24,
  0, 255, 128, 24, 0, 21, 27, 81, 26, 3, 0, 0, 32, 0, 3, 220,
  0, 6, 3, 0, 12, 1, 128, 28, 1, 192, 56, 0, 224, 56, 0, 224,
  120, 0, 240, 112, 0, 112, 112, 0, 112, 240, 0, 120, 240, 0, 120, 240,
  0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0,
  120, 112, 0, 112, 112, 0, 112, 120, 0, 240, 56, 0, 224, 56, 0, 224,
  28, 1, 192, 12, 1, 128, 6, 3, 0, 3, 254, 0, 21, 26, 78, 25,
  2, 0, 255, 255, 0, 14, 1, 192, 14, 0, 224, 14, 0, 240, 14, 0,
  120, 14, 0, 120, 14, 0, 120, 14, 0, 120, 14, 0, 120, 14, 0, 112,
  14, 0, 240, 14, 0, 224, 14, 1, 192, 15, 254, 0, 14, 0, 0, 14,
  0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0,
  0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 255, 224, 0,
  21, 33, 99, 26, 3, 250, 0, 32, 0, 3, 220, 0, 6, 3, 0, 12,
  1, 128, 28, 1, 192, 56, 0, 224, 56, 0, 224, 120, 0, 240, 112, 0,
  112, 112, 0, 112, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120,
  240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 112, 0, 112, 112,
  0, 112, 120, 0, 240, 56, 112, 224, 57, 152, 224, 29, 13, 192, 13, 13,
  128, 7, 15, 8, 3, 158, 8, 0, 110, 8, 0, 14, 8, 0, 14, 24,
  0, 7, 176, 0, 7, 240, 0, 3, 192, 22, 26, 78, 25, 2, 0, 255,
  255, 0, 14, 3, 192, 14, 1, 224, 14, 0, 240, 14, 0, 240, 14, 0,
  240, 14, 0, 240, 14, 0, 240, 14, 1, 224, 14, 1, 192, 14, 7, 128,
  15, 252, 0, 14, 6, 0, 14, 7, 0, 14, 3, 128, 14, 3, 128, 14,
  3, 128, 14, 3, 192, 14, 3, 192, 14, 3, 192, 14, 3, 196, 14, 1,
  196, 14, 1, 196, 14, 1, 236, 14, 1, 248, 255, 224, 240, 17, 26, 78,
  22, 3, 1, 31, 227, 0, 48, 51, 0, 96, 31, 0, 192, 15, 0, 192,
  7, 0, 192, 3, 0, 192, 3, 0, 224, 3, 0, 240, 1, 0, 120, 0,
  0, 127, 0, 0, 63, 192, 0, 31, 248, 0, 7, 252, 0, 1, 254, 0,
  128, 63, 0, 128, 15, 128, 128, 3, 128, 192, 3, 128, 192, 1, 128, 192,
  1, 128, 224, 1, 128, 240, 1, 0, 248, 3, 0, 140, 6, 0, 135, 252,
  0, 21, 26, 78, 26, 3, 0, 255, 255, 248, 240, 112, 120, 224, 112, 56,
  192, 112, 24, 192, 112, 24, 192, 112, 24, 128, 112, 8, 128, 112, 8, 128,
  112, 8, 128, 112, 8, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112,
  0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0,
  0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0,
  112, 0, 7, 255, 128, 25, 26, 104, 29, 2, 0, 255, 192, 255, 128, 14,
  0, 14, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14,
  0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14,
  0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14,
  0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14,
  0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 6,
  0, 8, 0, 7, 0, 8, 0, 3, 0, 16, 0, 1, 192, 32, 0, 0,
  127, 192, 0, 25, 26, 104, 28, 2, 0, 255, 241, 255, 128, 15, 0, 60,
  0, 15, 0, 24, 0, 7, 128, 24, 0, 7, 128, 16, 0, 3, 128, 48,
  0, 3, 192, 48, 0, 3, 192, 48, 0, 1, 192, 32, 0, 1, 224, 96,
  0, 1, 224, 96, 0, 0, 224, 64, 0, 0, 240, 192, 0, 0, 240, 192,
  0, 0, 112, 128, 0, 0, 113, 128, 0, 0, 121, 128, 0, 0, 57, 0,
  0, 0, 59, 0, 0, 0, 63, 0, 0, 0, 30, 0, 0, 0, 30, 0,
  0, 0, 14, 0, 0, 0, 14, 0, 0, 0, 12, 0, 0, 0, 4, 0,
  0, 36, 26, 130, 38, 1, 0, 255, 231, 255, 63, 240, 15, 0, 248, 7,
  128, 15, 0, 120, 3, 0, 7, 0, 120, 3, 0, 7, 128, 120, 6, 0,
  7, 128, 248, 6, 0, 3, 128, 252, 6, 0, 3, 128, 252, 4, 0, 3,
  192, 156, 12, 0, 1, 193, 156, 12, 0, 1, 193, 158, 12, 0, 1, 225,
  14, 24, 0, 1, 227, 14, 24, 0, 0, 227, 14, 24, 0, 0, 227, 15,
  16, 0, 0, 242, 7, 48, 0, 0, 118, 7, 48, 0, 0, 118, 7, 32,
  0, 0, 116, 3, 224, 0, 0, 124, 3, 224, 0, 0, 60, 3, 192, 0,
  0, 60, 1, 192, 0, 0, 56, 1, 192, 0, 0, 24, 1, 192, 0, 0,
  24, 1, 128, 0, 0, 16, 0, 128, 0, 24, 26, 78, 27, 2, 0, 255,
  227, 255, 15, 128, 112, 7, 128, 96, 7, 192, 96, 3, 192, 192, 1, 224,
  128, 1, 225, 128, 0, 227, 0, 0, 242, 0, 0, 118, 0, 0, 124, 0,
  0, 56, 0, 0, 60, 0, 0, 60, 0, 0, 62, 0, 0, 79, 0, 0,
  207, 0, 0, 135, 128, 1, 135, 128, 1, 3, 192, 3, 3, 192, 6, 1,
  224, 6, 0, 224, 14, 0, 240, 30, 0, 240, 255, 199, 255, 24, 26, 78,
  27, 2, 0, 255, 225, 255, 31, 0, 56, 15, 0, 48, 7, 128, 48, 7,
  128, 32, 3, 192, 96, 3, 192, 64, 1, 224, 128, 0, 224, 128, 0, 241,
  0, 0, 113, 0, 0, 122, 0, 0, 58, 0, 0, 60, 0, 0, 28, 0,
  0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0,
  28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 1, 255,
  224, 19, 26, 78, 23, 2, 0, 63, 255, 224, 60, 3, 192, 56, 3, 192,
  112, 7, 128, 96, 15, 0, 96, 15, 0, 64, 30, 0, 64, 30, 0, 64,
  60, 0, 0, 120, 0, 0, 120, 0, 0, 240, 0, 0, 224, 0, 1, 224,
  0, 3, 192, 0, 3, 192, 0, 7, 128, 32, 7, 0, 32, 15, 0, 32,
  30, 0, 96, 30, 0, 96, 60, 0, 224, 56, 0, 224, 120, 1, 224, 240,
  3, 192, 255, 255, 192, 7, 33, 33, 14, 4, 249, 254, 240, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 240, 254, 12, 34, 68, 16,
  2, 249, 128, 0, 192, 0, 64, 0, 64, 0, 96, 0, 32, 0, 32, 0,
  48, 0, 16, 0, 16, 0, 24, 0, 8, 0, 8, 0, 12, 0, 4, 0,
  4, 0, 6, 0, 6, 0, 2, 0, 3, 0, 3, 0, 1, 0, 1, 128,
  1, 128, 0, 128, 0, 128, 0, 192, 0, 64, 0, 64, 0, 96, 0, 32,
  0, 32, 0, 48, 0, 16, 7, 33, 33, 15, 3, 249, 254, 14, 14, 14,
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 254, 15, 13, 26,
  21, 3, 12, 1, 0, 3, 128, 3, 128, 6, 192, 4, 64, 12, 96, 24,
  48, 16, 16, 48, 24, 96, 8, 96, 12, 192, 6, 128, 2, 19, 1, 3,
  19, 0, 250, 255, 255, 224, 6, 6, 6, 16, 3, 19, 192, 224, 112, 48,
  24, 12, 16, 17, 34, 19, 2, 0, 15, 128, 48, 224, 96, 112, 96, 112,
  120, 112, 120, 112, 0, 112, 1, 240, 30, 112, 112, 112, 96, 112, 224, 112,
  224, 113, 224, 241, 225, 113, 113, 126, 62, 60, 16, 26, 52, 18, 0, 0,
  252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 112, 29, 140, 29, 14, 30, 6, 30, 7, 28, 7, 28, 7,
  28, 7, 28, 7, 28, 7, 28, 7, 28, 7, 28, 7, 30, 6, 26, 14,
  17, 12, 16, 240, 12, 17, 34, 16, 2, 0, 15, 128, 24, 96, 48, 48,
  112, 48, 96, 112, 224, 112, 224, 112, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 96, 16, 112, 16, 48, 32, 24, 64, 15, 128, 16, 26, 52, 19,
  2, 0, 1, 248, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 56, 14, 56, 57, 184, 48, 184, 112, 120, 96, 120, 224, 56,
  224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 96, 56, 112, 120,
  48, 120, 48, 248, 15, 63, 13, 17, 34, 17, 2, 0, 15, 128, 24, 224,
  48, 96, 112, 112, 96, 48, 224, 56, 224, 56, 255, 248, 224, 0, 224, 0,
  224, 0, 224, 8, 112, 16, 112, 16, 48, 32, 24, 96, 7, 128, 12, 26,
  52, 12, 1, 0, 7, 192, 12, 32, 28, 48, 56, 112, 56, 112, 56, 0,
  56, 0, 56, 0, 56, 0, 255, 128, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 255, 128, 17, 25, 75, 20, 2, 248, 7, 199,
  0, 28, 117, 128, 56, 59, 128, 112, 31, 128, 112, 28, 0, 112, 28, 0,
  112, 28, 0, 112, 28, 0, 56, 56, 0, 28, 112, 0, 7, 192, 0, 56,
  0, 0, 64, 0, 0, 64, 0, 0, 64, 0, 0, 127, 224, 0, 63, 248,
  0, 14, 28, 0, 112, 2, 0, 192, 2, 0, 192, 2, 0, 192, 2, 0,
  224, 4, 0, 112, 8, 0, 15, 240, 0, 18, 26, 78, 21, 1, 0, 252,
  0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 124, 0, 28, 142, 0,
  29, 7, 0, 30, 7, 0, 30, 7, 0, 28, 7, 0, 28, 7, 0, 28,
  7, 0, 28, 7, 0, 28, 7, 0, 28, 7, 0, 28, 7, 0, 28, 7,
  0, 28, 7, 0, 28, 7, 0, 28, 7, 0, 255, 31, 192, 7, 25, 25,
  10, 2, 0, 48, 120, 120, 48, 0, 0, 0, 0, 248, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 254, 9, 34, 68, 11,
  255, 248, 1, 128, 3, 128, 3, 128, 1, 128, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 31, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128,
  3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128,
  3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 67, 128, 227, 128, 227, 0,
  195, 0, 70, 0, 60, 0, 17, 26, 78, 19, 1, 0, 252, 0, 0, 28,
  0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 0, 28, 0, 0, 28, 127, 0, 28, 24, 0, 28, 16, 0,
  28, 48, 0, 28, 32, 0, 28, 64, 0, 28, 128, 0, 29, 192, 0, 29,
  192, 0, 30, 224, 0, 28, 112, 0, 28, 112, 0, 28, 56, 0, 28, 60,
  0, 28, 28, 0, 28, 30, 0, 255, 127, 128, 9, 26, 52, 11, 1, 0,
  252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 255, 128, 25, 17, 68, 29, 2, 0, 248, 240, 120, 0, 57, 56,
  156, 0, 58, 29, 14, 0, 60, 30, 14, 0, 60, 30, 14, 0, 56, 28,
  14, 0, 56, 28, 14, 0, 56, 28, 14, 0, 56, 28, 14, 0, 56, 28,
  14, 0, 56, 28, 14, 0, 56, 28, 14, 0, 56, 28, 14, 0, 56, 28,
  14, 0, 56, 28, 14, 0, 56, 28, 14, 0, 254, 127, 63, 128, 17, 17,
  51, 21, 2, 0, 248, 248, 0, 57, 28, 0, 58, 14, 0, 60, 14, 0,
  60, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56,
  14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14,
  0, 56, 14, 0, 254, 63, 128, 14, 17, 34, 18, 2, 0, 7, 128, 24,
  96, 48, 48, 112, 56, 112, 24, 224, 28, 224, 28, 224, 28, 224, 28, 224,
  28, 224, 28, 224, 28, 112, 24, 112, 56, 48, 48, 24, 96, 7, 128, 16,
  25, 50, 19, 1, 248, 252, 240, 29, 140, 31, 14, 30, 6, 30, 7, 28,
  7, 28, 7, 28, 7, 28, 7, 28, 7, 28, 7, 28, 7, 28, 7, 30,
  6, 30, 14, 29, 12, 28, 240, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 255, 128, 16, 25, 50, 18, 2, 248, 15, 8, 56,
  136, 48, 216, 112, 88, 96, 120, 224, 56, 224, 56, 224, 56, 224, 56, 224,
  56, 224, 56, 224, 56, 96, 56, 112, 120, 48, 120, 48, 184, 15, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 1, 255, 12,
  17, 34, 15, 2, 0, 248, 224, 57, 16, 58, 48, 58, 112, 60, 112, 60,
  0, 60, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 56, 0, 254, 0, 12, 17, 34, 16, 2, 0, 62, 64, 97,
  64, 192, 192, 192, 64, 192, 64, 224, 64, 120, 0, 127, 0, 31, 192, 7,
  224, 128, 240, 192, 112, 192, 48, 224, 48, 224, 48, 152, 96, 135, 192, 11,
  24, 48, 13, 1, 0, 8, 0, 8, 0, 8, 0, 8, 0, 24, 0, 24,
  0, 56, 0, 255, 192, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 32, 56, 32, 56, 32, 56,
  96, 31, 192, 15, 128, 17, 17, 51, 20, 1, 0, 248, 62, 0, 56, 14,
  0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0,
  56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56,
  30, 0, 56, 30, 0, 56, 46, 0, 28, 78, 0, 15, 143, 128, 18, 17,
  51, 19, 0, 0, 255, 31, 192, 28, 7, 0, 28, 6, 0, 12, 4, 0,
  14, 4, 0, 14, 4, 0, 7, 8, 0, 7, 8, 0, 3, 8, 0, 3,
  144, 0, 1, 144, 0, 1, 208, 0, 1, 224, 0, 0, 224, 0, 0, 224,
  0, 0, 64, 0, 0, 64, 0, 27, 17, 68, 28, 0, 0, 255, 63, 207,
  224, 28, 15, 3, 0, 28, 7, 3, 0, 12, 7, 2, 0, 14, 7, 2,
  0, 14, 15, 130, 0, 7, 11, 132, 0, 7, 9, 132, 0, 3, 137, 196,
  0, 3, 145, 200, 0, 1, 144, 200, 0, 1, 208, 232, 0, 1, 224, 240,
  0, 0, 224, 112, 0, 0, 224, 112, 0, 0, 64, 96, 0, 0, 64, 32,
  0, 16, 17, 34, 19, 2, 0, 254, 126, 60, 56, 28, 48, 28, 32, 14,
  64, 14, 64, 7, 128, 3, 128, 3, 128, 3, 192, 3, 192, 4, 224, 8,
  96, 8, 112, 16, 56, 48, 56, 252, 255, 18, 25, 75, 20, 1, 248, 255,
  31, 192, 28, 6, 0, 28, 6, 0, 12, 4, 0, 14, 4, 0, 14, 4,
  0, 6, 8, 0, 7, 8, 0, 7, 8, 0, 3, 16, 0, 3, 144, 0,
  3, 144, 0, 1, 240, 0, 1, 224, 0, 1, 224, 0, 0, 224, 0, 0,
  192, 0, 0, 64, 0, 0, 192, 0, 0, 128, 0, 112, 128, 0, 113, 128,
  0, 113, 0, 0, 115, 0, 0, 60, 0, 0, 12, 17, 34, 15, 1, 0,
  255, 240, 224, 112, 192, 224, 128, 224, 129, 192, 131, 128, 131, 128, 7, 0,
  7, 0, 14, 0, 28, 16, 28, 16, 56, 16, 56, 16, 112, 48, 224, 112,
  255, 240, 8, 33, 33, 15, 3, 249, 3, 4, 8, 24, 24, 24, 24, 28,
  28, 28, 12, 12, 12, 12, 8, 24, 224, 24, 8, 12, 12, 12, 12, 28,
  28, 28, 24, 24, 24, 24, 8, 4, 3, 2, 34, 34, 10, 4, 249, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 8, 33, 33, 14, 3, 249, 192, 32, 16, 24, 24, 24, 24, 24, 56,
  56, 48, 48, 48, 48, 16, 24, 7, 24, 16, 48, 48, 48, 48, 56, 56,
  24, 24, 24, 24, 24, 16, 32, 192, 20, 6, 18, 24, 2, 6, 62, 0,
  32, 127, 192, 16, 135, 248, 16, 128, 255, 48, 128, 63, 224, 96, 7, 192,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 0, 0, 0, 10, 0, 0, 4, 25, 25, 10, 3, 248, 96, 240, 240,
  240, 96, 64, 64, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 240, 240,
  240, 240, 240, 240, 240, 96, 12, 25, 50, 21, 4, 252, 1, 0, 1, 0,
  1, 0, 1, 0, 7, 192, 25, 32, 57, 48, 113, 48, 113, 112, 225, 112,
  225, 32, 225, 0, 225, 0, 225, 0, 225, 0, 225, 0, 113, 16, 113, 16,
  57, 16, 29, 32, 7, 192, 1, 0, 1, 0, 1, 0, 1, 0, 20, 25,
  75, 25, 2, 0, 0, 15, 128, 0, 24, 96, 0, 48, 32, 0, 96, 112,
  0, 192, 240, 0, 192, 240, 1, 192, 224, 1, 192, 0, 1, 192, 0, 1,
  192, 0, 1, 192, 0, 63, 192, 0, 1, 254, 0, 1, 192, 0, 1, 192,
  0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 1, 192, 0, 57, 128, 16,
  199, 128, 16, 131, 128, 48, 131, 224, 96, 134, 255, 192, 120, 63, 128, 18,
  16, 48, 22, 2, 5, 195, 241, 192, 124, 15, 128, 48, 7, 0, 32, 3,
  0, 96, 1, 0, 64, 1, 128, 64, 0, 128, 64, 0, 128, 64, 0, 128,
  64, 0, 128, 64, 1, 128, 96, 1, 0, 32, 3, 0, 48, 7, 0, 124,
  15, 128, 227, 241, 192, 20, 25, 75, 22, 1, 0, 255, 7, 240, 60, 1,
  192, 28, 1, 128, 30, 1, 0, 14, 3, 0, 15, 2, 0, 7, 6, 0,
  7, 132, 0, 3, 140, 0, 3, 136, 0, 1, 216, 0, 1, 208, 0, 1,
  224, 0, 31, 255, 0, 0, 224, 0, 0, 224, 0, 31, 255, 0, 0, 224,
  0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0, 0, 224, 0,
  0, 224, 0, 15, 254, 0, 2, 33, 33, 10, 4, 250, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 0, 0, 0, 0, 0, 0, 0,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 13, 32, 64,
  23, 4, 249, 7, 128, 24, 64, 16, 96, 48, 224, 48, 224, 48, 64, 56,
  0, 28, 0, 30, 0, 15, 0, 23, 128, 99, 192, 129, 224, 128, 240, 128,
  120, 128, 24, 192, 24, 224, 8, 120, 8, 60, 16, 30, 32, 15, 64, 7,
  128, 3, 192, 1, 192, 0, 224, 16, 96, 56, 96, 56, 96, 48, 64, 16,
  192, 15, 0, 10, 4, 8, 16, 3, 20, 96, 192, 225, 192, 225, 192, 96,
  192, 26, 26, 104, 30, 2, 1, 0, 255, 192, 0, 3, 0, 48, 0, 4,
  0, 8, 0, 8, 0, 4, 0, 16, 30, 2, 0, 32, 113, 225, 0, 32,
  224, 225, 0, 65, 192, 96, 128, 65, 192, 96, 128, 129, 128, 32, 64, 131,
  128, 32, 64, 131, 128, 0, 64, 131, 128, 0, 64, 131, 128, 0, 64, 131,
  128, 0, 64, 131, 128, 0, 64, 131, 128, 32, 64, 65, 192, 64, 128, 65,
  192, 64, 128, 32, 224, 65, 0, 32, 112, 129, 0, 16, 31, 2, 0, 8,
  0, 4, 0, 4, 0, 8, 0, 3, 0, 48, 0, 0, 255, 192, 0, 9,
  13, 26, 13, 2, 12, 120, 0, 132, 0, 198, 0, 198, 0, 14, 0, 54,
  0, 70, 0, 198, 0, 198, 128, 206, 128, 115, 0, 0, 0, 255, 0, 10,
  14, 28, 18, 4, 2, 16, 64, 48, 128, 97, 128, 97, 0, 195, 0, 195,
  0, 195, 0, 195, 0, 195, 0, 67, 0, 97, 0, 32, 128, 16, 192, 8,
  0, 18, 7, 21, 22, 2, 6, 255, 255, 192, 0, 0, 192, 0, 0, 192,
  0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 9, 2, 4, 13,
  2, 8, 255, 128, 255, 128, 26, 26, 104, 30, 2, 1, 0, 255, 192, 0,
  3, 0, 48, 0, 4, 0, 8, 0, 8, 0, 4, 0, 19, 255, 2, 0,
  32, 225, 193, 0, 32, 224, 225, 0, 64, 224, 224, 128, 64, 224, 224, 128,
  128, 224, 224, 64, 128, 224, 224, 64, 128, 225, 192, 64, 128, 254, 0, 64,
  128, 225, 128, 64, 128, 224, 192, 64, 128, 224, 224, 64, 128, 224, 224, 64,
  64, 224, 228, 128, 64, 224, 228, 128, 32, 224, 233, 0, 35, 248, 121, 0,
  16, 0, 2, 0, 8, 0, 4, 0, 4, 0, 8, 0, 3, 0, 48, 0,
  0, 255, 192, 0, 9, 1, 2, 15, 3, 21, 255, 128, 10, 9, 18, 22,
  6, 16, 30, 0, 97, 128, 192, 128, 128, 64, 128, 64, 128, 64, 64, 128,
  97, 128, 30, 0, 30, 25, 100, 34, 2, 255, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 255, 255, 255, 252, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3,
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 252, 10, 15,
  30, 16, 3, 10, 63, 0, 67, 128, 129, 192, 129, 192, 225, 192, 225, 192,
  1, 128, 3, 0, 6, 0, 8, 0, 48, 0, 64, 64, 64, 64, 255, 192,
  255, 192, 10, 16, 32, 16, 4, 9, 62, 0, 67, 0, 193, 128, 225, 128,
  225, 128, 1, 128, 3, 0, 124, 0, 3, 128, 1, 192, 1, 192, 225, 192,
  225, 192, 129, 192, 131, 128, 126, 0, 6, 6, 6, 16, 7, 19, 12, 28,
  56, 48, 96, 192, 19, 27, 81, 22, 2, 246, 96, 24, 0, 224, 60, 0,
  224, 60, 0, 224, 60, 0, 224, 60, 0, 224, 60, 0, 224, 60, 0, 224,
  60, 0, 224, 60, 0, 192, 24, 0, 64, 24, 0, 64, 24, 0, 64, 56,
  0, 96, 48, 32, 112, 124, 96, 95, 231, 224, 71, 195, 192, 128, 0, 0,
  192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 224, 0, 0, 224,
  0, 0, 224, 0, 0, 240, 0, 0, 96, 0, 0, 15, 31, 62, 19, 2,
  251, 31, 254, 62, 16, 126, 16, 254, 16, 254, 16, 254, 16, 254, 16, 254,
  16, 254, 16, 126, 16, 62, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2,
  16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2,
  16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 16, 2, 16, 4,
  5, 5, 10, 3, 9, 96, 240, 240, 240, 96, 7, 7, 7, 16, 4, 248,
  16, 32, 28, 6, 6, 134, 124, 8, 15, 15, 16, 4, 10, 8, 24, 248,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 255, 9, 13, 26, 15,
  3, 12, 28, 0, 99, 0, 67, 0, 193, 128, 193, 128, 193, 128, 193, 128,
  193, 128, 67, 0, 99, 0, 28, 0, 0, 0, 255, 128, 9, 14, 28, 17,
  4, 2, 132, 0, 66, 0, 99, 0, 33, 0, 49, 128, 49, 128, 49, 128,
  49, 128, 49, 128, 33, 128, 99, 0, 67, 0, 134, 0, 4, 0, 24, 25,
  75, 31, 4, 0, 8, 0, 16, 24, 0, 48, 248, 0, 32, 24, 0, 64,
  24, 0, 64, 24, 0, 128, 24, 1, 128, 24, 1, 0, 24, 2, 0, 24,
  6, 0, 24, 4, 12, 24, 8, 28, 24, 8, 28, 24, 16, 44, 255, 48,
  76, 0, 32, 76, 0, 64, 140, 0, 192, 140, 0, 129, 12, 1, 2, 12,
  1, 3, 255, 2, 0, 12, 6, 0, 12, 4, 0, 12, 8, 0, 127, 24,
  25, 75, 31, 4, 0, 8, 0, 32, 24, 0, 96, 248, 0, 64, 24, 0,
  192, 24, 0, 128, 24, 1, 0, 24, 1, 0, 24, 2, 0, 24, 6, 0,
  24, 4, 0, 24, 12, 248, 24, 9, 14, 24, 18, 15, 24, 18, 7, 255,
  35, 135, 0, 97, 135, 0, 64, 14, 0, 128, 12, 0, 128, 24, 1, 0,
  32, 3, 0, 193, 2, 1, 1, 6, 1, 1, 4, 3, 255, 8, 3, 254,
  24, 25, 75, 31, 4, 0, 62, 0, 32, 67, 0, 32, 193, 128, 64, 225,
  128, 192, 1, 128, 128, 3, 1, 128, 124, 1, 0, 3, 130, 0, 1, 194,
  0, 1, 196, 0, 225, 204, 24, 225, 200, 24, 129, 208, 56, 131, 144, 88,
  126, 32, 88, 0, 96, 152, 0, 64, 152, 0, 193, 24, 0, 129, 24, 1,
  2, 24, 3, 3, 255, 2, 0, 24, 6, 0, 24, 4, 0, 24, 8, 0,
  127, 13, 25, 50, 17, 1, 248, 6, 0, 15, 0, 15, 0, 15, 0, 6,
  0, 7, 0, 8, 192, 16, 64, 16, 64, 16, 192, 0, 128, 1, 0, 7,
  0, 14, 0, 28, 0, 56, 0, 112, 0, 240, 112, 224, 120, 224, 120, 224,
  24, 224, 24, 112, 16, 56, 96, 15, 192, 25, 34, 136, 28, 2, 0, 0,
  192, 0, 0, 0, 224, 0, 0, 0, 224, 0, 0, 0, 48, 0, 0, 0,
  24, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  8, 0, 0, 0, 12, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0,
  30, 0, 0, 0, 62, 0, 0, 0, 46, 0, 0, 0, 47, 0, 0, 0,
  103, 0, 0, 0, 103, 0, 0, 0, 71, 128, 0, 0, 195, 128, 0, 0,
  195, 128, 0, 0, 131, 192, 0, 1, 129, 192, 0, 1, 129, 192, 0, 3,
  1, 224, 0, 3, 255, 224, 0, 2, 0, 224, 0, 6, 0, 240, 0, 6,
  0, 112, 0, 6, 0, 112, 0, 12, 0, 120, 0, 12, 0, 120, 0, 30,
  0, 120, 0, 255, 195, 255, 128, 25, 34, 136, 28, 2, 0, 0, 0, 192,
  0, 0, 1, 192, 0, 0, 3, 128, 0, 0, 7, 0, 0, 0, 6, 0,
  0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0,
  0, 0, 12, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 30, 0,
  0, 0, 62, 0, 0, 0, 46, 0, 0, 0, 47, 0, 0, 0, 103, 0,
  0, 0, 103, 0, 0, 0, 71, 128, 0, 0, 195, 128, 0, 0, 195, 128,
  0, 1, 131, 192, 0, 1, 129, 192, 0, 1, 129, 192, 0, 3, 1, 224,
  0, 3, 255, 224, 0, 2, 0, 224, 0, 6, 0, 240, 0, 6, 0, 112,
  0, 4, 0, 112, 0, 12, 0, 120, 0, 12, 0, 56, 0, 30, 0, 124,
  0, 255, 195, 255, 128, 25, 34, 136, 28, 2, 0, 0, 8, 0, 0, 0,
  28, 0, 0, 0, 30, 0, 0, 0, 51, 0, 0, 0, 65, 128, 0, 1,
  128, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0,
  12, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0, 30, 0, 0, 0,
  62, 0, 0, 0, 46, 0, 0, 0, 47, 0, 0, 0, 103, 0, 0, 0,
  103, 0, 0, 0, 71, 128, 0, 0, 195, 128, 0, 0, 195, 128, 0, 0,
  131, 192, 0, 1, 129, 192, 0, 1, 129, 192, 0, 3, 1, 224, 0, 3,
  255, 224, 0, 2, 0, 224, 0, 6, 0, 240, 0, 6, 0, 112, 0, 6,
  0, 112, 0, 12, 0, 120, 0, 12, 0, 120, 0, 30, 0, 120, 0, 255,
  195, 255, 128, 25, 33, 132, 28, 2, 0, 0, 112, 64, 0, 0, 252, 64,
  0, 0, 159, 192, 0, 1, 7, 128, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 12, 0, 0, 0, 28, 0,
  0, 0, 28, 0, 0, 0, 30, 0, 0, 0, 62, 0, 0, 0, 46, 0,
  0, 0, 47, 0, 0, 0, 103, 0, 0, 0, 103, 0, 0, 0, 71, 128,
  0, 0, 195, 128, 0, 0, 195, 128, 0, 1, 131, 192, 0, 1, 129, 192,
  0, 1, 129, 192, 0, 3, 1, 224, 0, 3, 255, 224, 0, 2, 0, 224,
  0, 6, 0, 240, 0, 6, 0, 112, 0, 4, 0, 112, 0, 12, 0, 120,
  0, 12, 0, 56, 0, 30, 0, 124, 0, 255, 195, 255, 128, 25, 33, 132,
  28, 2, 0, 0, 193, 128, 0, 1, 193, 192, 0, 1, 193, 192, 0, 0,
  193, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  8, 0, 0, 0, 24, 0, 0, 0, 28, 0, 0, 0, 28, 0, 0, 0,
  60, 0, 0, 0, 62, 0, 0, 0, 62, 0, 0, 0, 110, 0, 0, 0,
  79, 0, 0, 0, 71, 0, 0, 0, 199, 0, 0, 0, 199, 128, 0, 0,
  131, 128, 0, 1, 131, 128, 0, 1, 129, 192, 0, 1, 1, 192, 0, 3,
  1, 192, 0, 3, 255, 224, 0, 2, 0, 224, 0, 6, 0, 224, 0, 6,
  0, 112, 0, 4, 0, 112, 0, 12, 0, 112, 0, 12, 0, 120, 0, 30,
  0, 120, 0, 255, 195, 255, 128, 25, 35, 140, 28, 2, 0, 0, 28, 0,
  0, 0, 34, 0, 0, 0, 65, 0, 0, 0, 65, 0, 0, 0, 65, 0,
  0, 0, 65, 0, 0, 0, 34, 0, 0, 0, 28, 0, 0, 0, 0, 0,
  0, 0, 8, 0, 0, 0, 12, 0, 0, 0, 28, 0, 0, 0, 28, 0,
  0, 0, 30, 0, 0, 0, 62, 0, 0, 0, 46, 0, 0, 0, 47, 0,
  0, 0, 111, 0, 0, 0, 71, 0, 0, 0, 71, 128, 0, 0, 199, 128,
  0, 0, 131, 128, 0, 1, 131, 192, 0, 1, 131, 192, 0, 1, 1, 192,
  0, 3, 1, 224, 0, 3, 255, 224, 0, 2, 0, 224, 0, 6, 0, 240,
  0, 6, 0, 240, 0, 4, 0, 112, 0, 12, 0, 120, 0, 12, 0, 120,
  0, 28, 0, 120, 0, 255, 195, 255, 128, 33, 26, 130, 36, 1, 0, 0,
  7, 255, 255, 128, 0, 1, 224, 7, 128, 0, 1, 224, 3, 128, 0, 3,
  224, 1, 128, 0, 2, 224, 1, 128, 0, 6, 224, 0, 128, 0, 4, 224,
  0, 128, 0, 12, 224, 32, 128, 0, 8, 224, 32, 0, 0, 24, 224, 32,
  0, 0, 16, 224, 96, 0, 0, 48, 224, 96, 0, 0, 48, 255, 224, 0,
  0, 96, 224, 96, 0, 0, 96, 224, 96, 0, 0, 192, 224, 32, 0, 0,
  192, 224, 32, 128, 1, 255, 224, 32, 128, 1, 0, 224, 0, 128, 3, 0,
  224, 0, 128, 2, 0, 224, 1, 128, 6, 0, 224, 1, 128, 6, 0, 224,
  1, 128, 14, 0, 224, 3, 128, 30, 0, 224, 15, 128, 255, 199, 255, 255,
  128, 19, 34, 102, 24, 3, 249, 3, 252, 64, 14, 6, 96, 28, 3, 224,
  24, 1, 224, 56, 0, 224, 120, 0, 224, 112, 0, 96, 112, 0, 96, 240,
  0, 96, 240, 0, 32, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0,
  0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 112, 0, 32, 112, 0, 32,
  120, 0, 96, 56, 0, 64, 56, 0, 64, 24, 0, 128, 12, 0, 128, 6,
  3, 0, 3, 204, 0, 0, 112, 0, 0, 64, 0, 0, 240, 0, 0, 28,
  0, 0, 28, 0, 0, 28, 0, 2, 28, 0, 1, 240, 0, 21, 34, 102,
  25, 2, 0, 3, 0, 0, 3, 128, 0, 1, 192, 0, 0, 192, 0, 0,
  96, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 255, 255, 248, 14, 0,
  120, 14, 0, 56, 14, 0, 24, 14, 0, 24, 14, 0, 8, 14, 0, 8,
  14, 4, 8, 14, 4, 0, 14, 4, 0, 14, 12, 0, 14, 12, 0, 15,
  252, 0, 14, 12, 0, 14, 4, 0, 14, 4, 0, 14, 4, 8, 14, 4,
  8, 14, 0, 8, 14, 0, 8, 14, 0, 24, 14, 0, 24, 14, 0, 56,
  14, 0, 56, 14, 0, 248, 255, 255, 248, 21, 34, 102, 25, 2, 0, 0,
  3, 0, 0, 7, 128, 0, 7, 0, 0, 12, 0, 0, 24, 0, 0, 48,
  0, 0, 0, 0, 0, 0, 0, 255, 255, 248, 14, 0, 120, 14, 0, 56,
  14, 0, 24, 14, 0, 24, 14, 0, 8, 14, 0, 8, 14, 4, 8, 14,
  4, 0, 14, 4, 0, 14, 12, 0, 14, 12, 0, 15, 252, 0, 14, 12,
  0, 14, 4, 0, 14, 4, 0, 14, 4, 8, 14, 4, 8, 14, 0, 8,
  14, 0, 8, 14, 0, 24, 14, 0, 24, 14, 0, 56, 14, 0, 56, 14,
  0, 248, 255, 255, 248, 21, 34, 102, 25, 2, 0, 0, 48, 0, 0, 48,
  0, 0, 120, 0, 0, 204, 0, 1, 134, 0, 2, 1, 128, 0, 0, 0,
  0, 0, 0, 255, 255, 248, 14, 0, 120, 14, 0, 56, 14, 0, 24, 14,
  0, 24, 14, 0, 8, 14, 0, 8, 14, 4, 8, 14, 4, 0, 14, 4,
  0, 14, 12, 0, 14, 12, 0, 15, 252, 0, 14, 12, 0, 14, 4, 0,
  14, 4, 0, 14, 4, 8, 14, 4, 8, 14, 0, 8, 14, 0, 8, 14,
  0, 24, 14, 0, 24, 14, 0, 56, 14, 0, 56, 14, 0, 248, 255, 255,
  248, 21, 33, 99, 25, 2, 0, 1, 131, 0, 3, 135, 0, 3, 135, 0,
  1, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 248, 14,
  0, 120, 14, 0, 56, 14, 0, 24, 14, 0, 24, 14, 0, 8, 14, 0,
  8, 14, 4, 8, 14, 4, 0, 14, 4, 0, 14, 12, 0, 14, 12, 0,
  15, 252, 0, 14, 12, 0, 14, 4, 0, 14, 4, 0, 14, 4, 8, 14,
  4, 8, 14, 0, 8, 14, 0, 8, 14, 0, 24, 14, 0, 24, 14, 0,
  56, 14, 0, 56, 14, 0, 248, 255, 255, 248, 10, 34, 68, 14, 2, 0,
  192, 0, 224, 0, 112, 0, 56, 0, 8, 0, 4, 0, 0, 0, 0, 0,
  255, 192, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 255, 192, 10, 34, 68, 14, 2, 0, 0, 192, 1, 192, 1, 128,
  3, 0, 6, 0, 4, 0, 0, 0, 0, 0, 255, 192, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 255, 192, 10, 34,
  68, 14, 2, 0, 4, 0, 14, 0, 30, 0, 59, 0, 97, 128, 128, 64,
  0, 0, 0, 0, 255, 192, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 255, 192, 11, 33, 66, 14, 2, 0, 96, 192,
  224, 224, 224, 224, 96, 192, 0, 0, 0, 0, 0, 0, 127, 224, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 127, 224,
  24, 26, 78, 27, 2, 0, 255, 255, 0, 14, 0, 192, 14, 0, 112, 14,
  0, 56, 14, 0, 60, 14, 0, 28, 14, 0, 30, 14, 0, 30, 14, 0,
  14, 14, 0, 15, 14, 0, 15, 14, 0, 15, 255, 224, 15, 14, 0, 15,
  14, 0, 15, 14, 0, 15, 14, 0, 15, 14, 0, 14, 14, 0, 30, 14,
  0, 30, 14, 0, 28, 14, 0, 56, 14, 0, 56, 14, 0, 112, 14, 0,
  192, 255, 255, 0, 25, 33, 132, 28, 2, 0, 0, 120, 32, 0, 0, 254,
  96, 0, 0, 143, 192, 0, 0, 131, 128, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 254, 0, 255, 128, 15, 0, 28, 0, 15, 128,
  8, 0, 15, 128, 8, 0, 11, 192, 8, 0, 11, 192, 8, 0, 9, 224,
  8, 0, 8, 240, 8, 0, 8, 240, 8, 0, 8, 120, 8, 0, 8, 60,
  8, 0, 8, 60, 8, 0, 8, 30, 8, 0, 8, 30, 8, 0, 8, 15,
  8, 0, 8, 7, 136, 0, 8, 7, 136, 0, 8, 3, 200, 0, 8, 1,
  232, 0, 8, 1, 232, 0, 8, 0, 248, 0, 8, 0, 120, 0, 8, 0,
  120, 0, 8, 0, 56, 0, 28, 0, 24, 0, 255, 128, 24, 0, 21, 34,
  102, 26, 3, 0, 3, 0, 0, 7, 0, 0, 3, 128, 0, 1, 192, 0,
  0, 64, 0, 0, 32, 0, 0, 0, 0, 0, 32, 0, 3, 220, 0, 6,
  3, 0, 12, 1, 128, 28, 1, 192, 56, 0, 224, 56, 0, 224, 120, 0,
  240, 112, 0, 112, 112, 0, 112, 240, 0, 120, 240, 0, 120, 240, 0, 120,
  240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 112,
  0, 112, 112, 0, 112, 120, 0, 240, 56, 0, 224, 56, 0, 224, 28, 1,
  192, 12, 1, 128, 6, 3, 0, 3, 254, 0, 21, 34, 102, 26, 3, 0,
  0, 6, 0, 0, 7, 0, 0, 14, 0, 0, 28, 0, 0, 16, 0, 0,
  32, 0, 0, 0, 0, 0, 32, 0, 3, 220, 0, 6, 3, 0, 12, 1,
  128, 28, 1, 192, 56, 0, 224, 56, 0, 224, 120, 0, 240, 112, 0, 112,
  112, 0, 112, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240,
  0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 112, 0, 112, 112, 0,
  112, 120, 0, 240, 56, 0, 224, 56, 0, 224, 28, 1, 192, 12, 1, 128,
  6, 3, 0, 3, 254, 0, 21, 34, 102, 26, 3, 0, 0, 32, 0, 0,
  112, 0, 0, 112, 0, 0, 216, 0, 1, 4, 0, 6, 3, 0, 0, 0,
  0, 0, 32, 0, 3, 220, 0, 6, 3, 0, 12, 1, 128, 28, 1, 192,
  56, 0, 224, 56, 0, 224, 120, 0, 240, 112, 0, 112, 112, 0, 112, 240,
  0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0,
  120, 240, 0, 120, 240, 0, 120, 112, 0, 112, 112, 0, 112, 120, 0, 240,
  56, 0, 224, 56, 0, 224, 28, 1, 192, 12, 1, 128, 6, 3, 0, 3,
  254, 0, 21, 33, 99, 26, 3, 0, 3, 225, 0, 3, 255, 0, 4, 62,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 3, 220, 0,
  6, 3, 0, 12, 1, 128, 28, 1, 192, 56, 0, 224, 56, 0, 224, 120,
  0, 240, 112, 0, 112, 112, 0, 112, 240, 0, 120, 240, 0, 120, 240, 0,
  120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120,
  112, 0, 112, 112, 0, 112, 120, 0, 240, 56, 0, 224, 56, 0, 224, 28,
  1, 192, 12, 1, 128, 6, 3, 0, 3, 254, 0, 21, 33, 99, 26, 3,
  0, 3, 6, 0, 7, 7, 0, 7, 7, 0, 3, 6, 0, 0, 0, 0,
  0, 0, 0, 0, 32, 0, 3, 220, 0, 6, 3, 0, 12, 1, 128, 28,
  1, 192, 56, 0, 224, 56, 0, 224, 120, 0, 240, 112, 0, 112, 112, 0,
  112, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120,
  240, 0, 120, 240, 0, 120, 240, 0, 120, 112, 0, 112, 112, 0, 112, 120,
  0, 240, 56, 0, 224, 56, 0, 224, 28, 1, 192, 12, 1, 128, 6, 3,
  0, 3, 254, 0, 22, 23, 69, 34, 6, 254, 128, 0, 4, 192, 0, 12,
  96, 0, 24, 48, 0, 48, 24, 0, 96, 12, 0, 192, 6, 1, 128, 3,
  3, 0, 1, 134, 0, 0, 204, 0, 0, 120, 0, 0, 48, 0, 0, 120,
  0, 0, 204, 0, 1, 134, 0, 3, 3, 0, 6, 1, 128, 12, 0, 192,
  24, 0, 96, 48, 0, 48, 96, 0, 24, 192, 0, 12, 128, 0, 0, 21,
  27, 81, 26, 3, 0, 0, 32, 0, 3, 222, 24, 6, 3, 48, 12, 1,
  224, 28, 1, 192, 56, 0, 224, 56, 1, 224, 120, 3, 240, 112, 2, 112,
  112, 6, 112, 240, 12, 120, 240, 24, 120, 240, 16, 120, 240, 48, 120, 240,
  96, 120, 240, 192, 120, 240, 192, 120, 241, 128, 120, 115, 0, 112, 114, 0,
  112, 126, 0, 240, 60, 0, 224, 56, 0, 224, 28, 1, 192, 60, 1, 128,
  102, 3, 0, 195, 222, 0, 25, 34, 136, 29, 2, 0, 0, 192, 0, 0,
  0, 224, 0, 0, 0, 224, 0, 0, 0, 48, 0, 0, 0, 16, 0, 0,
  0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 192, 255, 128,
  14, 0, 14, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0,
  14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0,
  14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0,
  14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0,
  14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0,
  6, 0, 8, 0, 7, 0, 8, 0, 3, 0, 16, 0, 1, 192, 32, 0,
  0, 127, 192, 0, 25, 34, 136, 29, 2, 0, 0, 0, 192, 0, 0, 1,
  192, 0, 0, 3, 128, 0, 0, 7, 0, 0, 0, 4, 0, 0, 0, 8,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 192, 255, 128, 14, 0,
  14, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0,
  4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0,
  4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0,
  4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0,
  4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 6, 0,
  8, 0, 7, 0, 8, 0, 3, 0, 16, 0, 1, 192, 32, 0, 0, 127,
  192, 0, 25, 34, 136, 29, 2, 0, 0, 8, 0, 0, 0, 28, 0, 0,
  0, 30, 0, 0, 0, 55, 0, 0, 0, 65, 128, 0, 1, 128, 96, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 192, 255, 128, 14, 0, 14, 0,
  14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0,
  14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0,
  14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0,
  14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0,
  14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 6, 0, 8, 0,
  7, 0, 8, 0, 3, 128, 16, 0, 1, 192, 96, 0, 0, 127, 192, 0,
  25, 33, 132, 29, 2, 0, 0, 192, 192, 0, 0, 225, 192, 0, 0, 225,
  192, 0, 0, 192, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 255, 192, 255, 128, 14, 0, 14, 0, 14, 0, 4, 0, 14, 0,
  4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0,
  4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0,
  4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0,
  4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0,
  4, 0, 14, 0, 4, 0, 6, 0, 8, 0, 7, 0, 8, 0, 3, 0,
  16, 0, 1, 192, 32, 0, 0, 127, 192, 0, 24, 34, 102, 27, 2, 0,
  0, 0, 192, 0, 1, 192, 0, 3, 128, 0, 7, 0, 0, 4, 0, 0,
  8, 0, 0, 0, 0, 0, 0, 0, 255, 225, 255, 31, 0, 56, 15, 0,
  48, 7, 128, 48, 7, 128, 32, 3, 192, 96, 3, 192, 64, 1, 224, 128,
  0, 224, 128, 0, 241, 0, 0, 113, 0, 0, 122, 0, 0, 58, 0, 0,
  60, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28,
  0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 1, 255, 224, 21, 26, 78, 25, 2, 0, 255, 224, 0, 14,
  0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 15, 255, 0, 14, 1,
  192, 14, 0, 224, 14, 0, 240, 14, 0, 120, 14, 0, 120, 14, 0, 120,
  14, 0, 120, 14, 0, 120, 14, 0, 240, 14, 0, 224, 14, 1, 192, 15,
  255, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0,
  0, 14, 0, 0, 14, 0, 0, 255, 224, 0, 16, 26, 52, 19, 1, 0,
  1, 240, 3, 28, 6, 14, 14, 14, 28, 14, 28, 14, 28, 12, 28, 28,
  28, 48, 29, 192, 28, 48, 28, 24, 28, 12, 28, 14, 28, 6, 28, 7,
  28, 7, 28, 7, 28, 7, 28, 7, 28, 135, 29, 199, 29, 199, 29, 142,
  29, 140, 252, 120, 16, 25, 50, 19, 2, 1, 112, 0, 112, 0, 56, 0,
  28, 0, 12, 0, 2, 0, 0, 0, 0, 0, 15, 128, 48, 224, 32, 112,
  96, 112, 120, 112, 120, 112, 0, 112, 1, 240, 30, 112, 112, 112, 96, 112,
  224, 112, 224, 113, 224, 241, 225, 113, 113, 126, 62, 60, 16, 25, 50, 19,
  2, 1, 0, 112, 0, 240, 0, 224, 1, 128, 3, 0, 2, 0, 0, 0,
  0, 0, 15, 128, 48, 224, 96, 112, 96, 112, 120, 112, 120, 112, 0, 112,
  1, 240, 30, 112, 112, 112, 96, 112, 224, 112, 224, 113, 224, 241, 225, 113,
  113, 126, 62, 60, 16, 25, 50, 19, 2, 0, 6, 0, 7, 0, 7, 0,
  13, 128, 24, 192, 48, 96, 0, 0, 0, 0, 15, 128, 48, 224, 96, 112,
  96, 112, 120, 112, 120, 112, 0, 112, 1, 240, 30, 112, 112, 112, 96, 112,
  224, 112, 224, 113, 224, 241, 225, 113, 113, 126, 62, 60, 16, 24, 48, 19,
  2, 0, 30, 48, 63, 224, 35, 192, 0, 0, 0, 0, 0, 0, 0, 0,
  15, 128, 48, 224, 96, 112, 96, 112, 120, 112, 120, 112, 0, 112, 1, 240,
  30, 112, 112, 112, 96, 112, 224, 112, 224, 113, 224, 241, 225, 113, 113, 126,
  62, 60, 16, 24, 48, 19, 2, 0, 48, 96, 112, 224, 112, 224, 48, 96,
  0, 0, 0, 0, 0, 0, 15, 0, 48, 192, 96, 96, 96, 96, 112, 96,
  112, 96, 0, 96, 1, 224, 30, 96, 112, 96, 96, 96, 224, 96, 224, 97,
  224, 225, 225, 99, 113, 126, 62, 60, 16, 25, 50, 19, 2, 0, 7, 0,
  24, 192, 16, 64, 16, 64, 24, 192, 7, 0, 0, 0, 0, 0, 15, 128,
  48, 224, 96, 112, 96, 112, 120, 112, 120, 112, 0, 112, 1, 240, 30, 112,
  112, 112, 96, 112, 224, 112, 224, 113, 224, 241, 225, 113, 113, 126, 62, 60,
  22, 17, 51, 26, 2, 0, 15, 135, 192, 48, 236, 112, 96, 120, 48, 112,
  120, 56, 120, 112, 24, 56, 112, 28, 0, 112, 28, 7, 255, 252, 56, 112,
  0, 112, 112, 0, 224, 112, 0, 224, 112, 4, 224, 248, 8, 224, 184, 8,
  225, 56, 16, 113, 28, 48, 62, 7, 192, 12, 24, 48, 16, 2, 249, 15,
  128, 24, 96, 48, 48, 112, 48, 96, 112, 224, 112, 224, 112, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 96, 16, 112, 16, 48, 32, 24, 96, 15,
  128, 2, 0, 6, 0, 1, 128, 0, 192, 0, 192, 16, 192, 15, 128, 13,
  25, 50, 17, 2, 1, 48, 0, 56, 0, 28, 0, 12, 0, 6, 0, 3,
  0, 0, 0, 0, 0, 15, 128, 24, 224, 48, 96, 112, 112, 96, 48, 224,
  56, 224, 56, 255, 248, 224, 0, 224, 0, 224, 0, 224, 8, 112, 16, 112,
  16, 48, 16, 24, 96, 7, 128, 13, 25, 50, 17, 2, 1, 0, 112, 0,
  112, 0, 224, 0, 192, 1, 128, 3, 0, 0, 0, 0, 0, 15, 128, 24,
  224, 48, 96, 112, 112, 96, 48, 224, 56, 224, 56, 255, 248, 224, 0, 224,
  0, 224, 0, 224, 8, 112, 16, 112, 16, 48, 16, 24, 96, 7, 128, 13,
  25, 50, 17, 2, 0, 3, 0, 3, 0, 7, 128, 5, 128, 8, 64, 16,
  32, 0, 0, 0, 0, 15, 128, 24, 224, 48, 96, 112, 112, 96, 48, 224,
  56, 224, 56, 255, 248, 224, 0, 224, 0, 224, 0, 224, 8, 112, 16, 112,
  16, 48, 32, 24, 96, 7, 128, 13, 24, 48, 17, 2, 0, 24, 96, 56,
  112, 56, 112, 24, 96, 0, 0, 0, 0, 0, 0, 15, 128, 24, 224, 48,
  96, 112, 48, 96, 48, 224, 56, 224, 56, 255, 248, 224, 0, 224, 0, 224,
  0, 224, 8, 112, 16, 112, 16, 48, 32, 24, 96, 7, 128, 9, 25, 50,
  11, 0, 0, 192, 0, 224, 0, 112, 0, 56, 0, 8, 0, 4, 0, 0,
  0, 0, 0, 62, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 63, 128, 8, 25, 25, 10, 2, 0, 3, 7, 7, 12, 24,
  48, 0, 0, 248, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56,
  56, 56, 56, 254, 9, 25, 50, 11, 1, 0, 24, 0, 28, 0, 60, 0,
  54, 0, 99, 0, 128, 128, 0, 0, 0, 0, 124, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 127, 0, 9, 24, 48, 11,
  1, 0, 97, 128, 227, 128, 227, 128, 97, 128, 0, 0, 0, 0, 0, 0,
  126, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  127, 128, 14, 26, 52, 18, 2, 0, 28, 16, 14, 48, 15, 192, 7, 128,
  7, 128, 13, 192, 48, 224, 0, 224, 0, 112, 7, 240, 24, 120, 48, 56,
  112, 60, 112, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 112, 24, 112, 56, 48, 48, 24, 96, 7, 128, 17, 24, 72, 21,
  2, 0, 7, 4, 0, 15, 204, 0, 9, 248, 0, 8, 112, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 248, 248, 0, 57, 28, 0, 58, 14, 0,
  60, 14, 0, 60, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56,
  14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14,
  0, 56, 14, 0, 56, 14, 0, 254, 63, 128, 14, 25, 50, 18, 2, 1,
  56, 0, 56, 0, 28, 0, 12, 0, 6, 0, 3, 0, 0, 0, 0, 0,
  7, 128, 24, 96, 48, 48, 112, 56, 112, 24, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 112, 24, 112, 56, 48, 48, 24, 96,
  7, 128, 14, 25, 50, 18, 2, 1, 0, 48, 0, 112, 0, 224, 0, 192,
  1, 128, 1, 0, 0, 0, 0, 0, 7, 128, 24, 96, 48, 48, 112, 56,
  112, 24, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  112, 24, 112, 56, 48, 48, 24, 96, 7, 128, 14, 25, 50, 18, 2, 0,
  3, 0, 3, 0, 7, 128, 4, 128, 8, 64, 16, 32, 0, 0, 0, 0,
  7, 128, 24, 96, 48, 48, 112, 56, 112, 24, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 224, 28, 224, 28, 112, 24, 112, 56, 48, 48, 24, 96,
  7, 128, 14, 24, 48, 18, 2, 0, 30, 16, 31, 240, 33, 224, 0, 0,
  0, 0, 0, 0, 0, 0, 7, 128, 24, 96, 48, 48, 112, 56, 112, 24,
  224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28, 112, 24,
  112, 56, 48, 48, 24, 96, 7, 128, 14, 24, 48, 18, 2, 0, 24, 48,
  56, 112, 56, 112, 24, 48, 0, 0, 0, 0, 0, 0, 7, 128, 24, 96,
  48, 48, 112, 56, 112, 24, 224, 28, 224, 28, 224, 28, 224, 28, 224, 28,
  224, 28, 224, 28, 112, 24, 112, 56, 48, 48, 24, 96, 7, 128, 30, 23,
  92, 34, 2, 254, 0, 3, 0, 0, 0, 7, 128, 0, 0, 7, 128, 0,
  0, 7, 128, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  255, 255, 255, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
  0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 3, 0, 0,
  14, 17, 34, 18, 2, 0, 7, 132, 24, 104, 48, 56, 112, 56, 112, 56,
  224, 92, 224, 156, 225, 156, 227, 28, 226, 28, 228, 28, 232, 28, 120, 24,
  112, 56, 48, 48, 88, 96, 135, 192, 17, 25, 75, 20, 1, 1, 28, 0,
  0, 28, 0, 0, 14, 0, 0, 3, 0, 0, 1, 0, 0, 0, 128, 0,
  0, 0, 0, 0, 0, 0, 248, 62, 0, 56, 14, 0, 56, 14, 0, 56,
  14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14,
  0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 30, 0, 56, 30, 0,
  56, 46, 0, 28, 78, 0, 15, 143, 128, 17, 25, 75, 20, 1, 1, 0,
  28, 0, 0, 60, 0, 0, 48, 0, 0, 96, 0, 0, 192, 0, 0, 128,
  0, 0, 0, 0, 0, 0, 0, 248, 62, 0, 56, 14, 0, 56, 14, 0,
  56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56,
  14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 30, 0, 56, 30,
  0, 56, 46, 0, 28, 78, 0, 15, 143, 128, 17, 25, 75, 20, 1, 0,
  0, 128, 0, 1, 192, 0, 1, 192, 0, 3, 96, 0, 4, 48, 0, 8,
  8, 0, 0, 0, 0, 0, 0, 0, 248, 62, 0, 56, 14, 0, 56, 14,
  0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0,
  56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 30, 0, 56,
  30, 0, 56, 46, 0, 28, 78, 0, 15, 143, 128, 17, 24, 72, 20, 1,
  0, 12, 48, 0, 28, 56, 0, 28, 56, 0, 12, 48, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 248, 62, 0, 56, 14, 0, 56, 14, 0, 56,
  14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14,
  0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 30, 0, 56, 30, 0,
  56, 46, 0, 28, 78, 0, 15, 143, 128, 18, 33, 99, 19, 1, 249, 0,
  12, 0, 0, 28, 0, 0, 24, 0, 0, 48, 0, 0, 96, 0, 0, 64,
  0, 0, 0, 0, 0, 0, 0, 255, 31, 192, 28, 6, 0, 28, 4, 0,
  12, 4, 0, 14, 4, 0, 14, 4, 0, 6, 8, 0, 7, 8, 0, 7,
  8, 0, 3, 16, 0, 3, 144, 0, 3, 144, 0, 1, 224, 0, 1, 224,
  0, 1, 224, 0, 0, 192, 0, 0, 192, 0, 0, 64, 0, 0, 128, 0,
  0, 128, 0, 112, 128, 0, 113, 128, 0, 113, 0, 0, 114, 0, 0, 60,
  0, 0, 16, 34, 68, 19, 1, 247, 12, 0, 60, 0, 92, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 60, 28, 126, 28, 143, 29, 7,
  30, 7, 30, 7, 30, 7, 28, 6, 28, 14, 28, 14, 28, 12, 28, 24,
  28, 16, 28, 32, 28, 64, 29, 128, 31, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 224, 0, 17, 32, 96, 19,
  1, 248, 6, 12, 0, 7, 28, 0, 7, 28, 0, 6, 12, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 255, 31, 128, 28, 6, 0, 28, 4, 0,
  14, 4, 0, 14, 4, 0, 14, 8, 0, 7, 8, 0, 7, 8, 0, 7,
  16, 0, 3, 144, 0, 3, 144, 0, 3, 160, 0, 1, 224, 0, 1, 224,
  0, 1, 224, 0, 0, 192, 0, 0, 192, 0, 0, 64, 0, 0, 128, 0,
  0, 128, 0, 112, 128, 0, 121, 0, 0, 121, 0, 0, 114, 0, 0, 60,
  0, 0
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--36-360-72-72-P-189-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 0, '1' Height: 25
  Calculated Max Values w=30 h=34 x= 4 y=10 dx=34 dy= 0 ascent=27 len=124
  Font Bounding box     w=94 h=46 x=-29 y=-11
  Calculated Min Values           x= 0 y=-7 dx= 0 dy= 0
  Pure Font   ascent =25 descent= 0
  X Font      ascent =25 descent= 0
  Max Font    ascent =27 descent=-7
*/
const u8g_fntpgm_uint8_t u8g_font_osr26n[955] U8G_FONT_SECTION("u8g_font_osr26n") = {
  0, 94, 46, 227, 245, 25, 0, 0, 0, 0, 42, 58, 0, 27, 249, 25,
  0, 13, 15, 30, 18, 3, 10, 7, 0, 7, 0, 7, 0, 195, 24, 226,
  56, 242, 120, 58, 224, 7, 0, 7, 128, 122, 240, 242, 120, 226, 56, 7,
  0, 7, 0, 7, 0, 30, 31, 124, 34, 2, 250, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 255, 255, 255, 252, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 5, 11, 11, 10, 2, 250, 112, 248, 248,
  120, 8, 8, 8, 16, 16, 32, 64, 9, 2, 4, 13, 2, 8, 255, 128,
  255, 128, 4, 5, 5, 10, 3, 0, 96, 240, 240, 240, 96, 12, 34, 68,
  16, 2, 249, 0, 16, 0, 48, 0, 48, 0, 32, 0, 96, 0, 96, 0,
  64, 0, 192, 0, 192, 0, 128, 0, 128, 1, 128, 1, 0, 1, 0, 3,
  0, 2, 0, 2, 0, 6, 0, 4, 0, 4, 0, 12, 0, 8, 0, 8,
  0, 24, 0, 24, 0, 16, 0, 48, 0, 48, 0, 32, 0, 96, 0, 96,
  0, 64, 0, 192, 0, 192, 0, 17, 25, 75, 21, 2, 0, 3, 224, 0,
  14, 56, 0, 28, 28, 0, 24, 12, 0, 56, 14, 0, 112, 7, 0, 112,
  7, 0, 112, 7, 0, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7,
  128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128,
  112, 7, 0, 112, 7, 0, 112, 7, 0, 56, 14, 0, 56, 14, 0, 24,
  12, 0, 12, 24, 0, 7, 112, 0, 12, 25, 50, 21, 4, 0, 1, 0,
  3, 0, 3, 0, 15, 0, 255, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 255, 240,
  15, 25, 50, 21, 3, 0, 15, 192, 48, 112, 96, 56, 64, 60, 192, 30,
  192, 30, 224, 30, 248, 30, 248, 30, 120, 28, 0, 60, 0, 56, 0, 112,
  0, 224, 1, 192, 3, 0, 14, 0, 28, 4, 56, 4, 48, 4, 96, 4,
  96, 12, 255, 252, 255, 252, 255, 252, 15, 25, 50, 21, 3, 0, 15, 192,
  48, 112, 32, 56, 96, 28, 112, 28, 120, 28, 120, 28, 48, 28, 0, 28,
  0, 56, 0, 112, 31, 192, 24, 112, 0, 56, 0, 60, 0, 30, 0, 30,
  112, 30, 248, 30, 248, 30, 248, 30, 192, 60, 192, 56, 96, 112, 63, 224,
  17, 25, 75, 21, 2, 0, 0, 16, 0, 0, 48, 0, 0, 112, 0, 0,
  112, 0, 0, 240, 0, 1, 240, 0, 1, 112, 0, 3, 112, 0, 6, 112,
  0, 6, 112, 0, 12, 112, 0, 8, 112, 0, 24, 112, 0, 48, 112, 0,
  32, 112, 0, 96, 112, 0, 192, 112, 0, 255, 255, 128, 0, 112, 0, 0,
  112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 7, 255,
  128, 15, 26, 52, 21, 3, 0, 32, 0, 48, 56, 63, 240, 63, 192, 47,
  0, 32, 0, 32, 0, 32, 0, 32, 0, 39, 192, 56, 112, 48, 56, 32,
  60, 32, 28, 0, 30, 0, 30, 0, 30, 0, 30, 120, 30, 248, 30, 248,
  28, 240, 60, 224, 60, 96, 56, 112, 112, 63, 192, 15, 25, 50, 21, 3,
  0, 3, 224, 6, 24, 12, 12, 24, 28, 56, 60, 48, 60, 112, 16, 112,
  0, 112, 0, 243, 224, 246, 56, 252, 28, 248, 28, 248, 14, 240, 14, 240,
  14, 240, 14, 240, 14, 112, 14, 112, 14, 112, 12, 56, 28, 56, 24, 24,
  56, 14, 224, 14, 25, 50, 21, 3, 0, 255, 252, 255, 252, 255, 252, 192,
  12, 128, 8, 128, 8, 128, 8, 128, 16, 0, 16, 0, 32, 0, 96, 0,
  64, 0, 128, 1, 128, 1, 128, 3, 0, 3, 0, 7, 0, 7, 0, 15,
  128, 15, 128, 15, 128, 15, 128, 15, 128, 7, 128, 17, 25, 75, 21, 2,
  0, 7, 240, 0, 28, 28, 0, 48, 14, 0, 112, 6, 0, 224, 3, 0,
  224, 3, 0, 224, 3, 0, 240, 3, 0, 240, 6, 0, 124, 6, 0, 127,
  140, 0, 31, 240, 0, 7, 252, 0, 25, 254, 0, 48, 63, 0, 96, 15,
  128, 224, 7, 128, 224, 3, 128, 224, 3, 128, 224, 3, 128, 224, 3, 0,
  96, 7, 0, 112, 6, 0, 56, 12, 0, 15, 248, 0, 15, 25, 50, 21,
  3, 0, 7, 192, 24, 96, 48, 48, 112, 56, 112, 28, 224, 28, 224, 28,
  224, 30, 224, 30, 224, 30, 224, 30, 112, 62, 112, 62, 56, 94, 15, 158,
  0, 30, 0, 28, 0, 28, 56, 28, 120, 28, 120, 56, 112, 56, 96, 112,
  48, 224, 31, 192, 4, 17, 17, 10, 3, 0, 96, 240, 240, 240, 96, 0,
  0, 0, 0, 0, 0, 0, 96, 240, 240, 240, 96
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--36-360-72-72-P-189-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 26, '1' Height: 25
  Calculated Max Values w=36 h=34 x= 4 y=20 dx=38 dy= 0 ascent=28 len=130
  Font Bounding box     w=94 h=46 x=-29 y=-11
  Calculated Min Values           x=-1 y=-8 dx= 0 dy= 0
  Pure Font   ascent =26 descent=-8
  X Font      ascent =27 descent=-8
  Max Font    ascent =28 descent=-8
*/
const u8g_fntpgm_uint8_t u8g_font_osr26r[6049] U8G_FONT_SECTION("u8g_font_osr26r") = {
  0, 94, 46, 227, 245, 26, 7, 96, 17, 82, 32, 127, 248, 28, 248, 27,
  248, 0, 0, 0, 10, 0, 0, 4, 25, 25, 10, 3, 0, 96, 240, 240,
  240, 240, 240, 240, 240, 96, 96, 96, 96, 96, 96, 96, 96, 96, 96, 32,
  64, 96, 240, 240, 240, 96, 8, 7, 7, 14, 3, 20, 195, 195, 195, 195,
  195, 195, 66, 19, 25, 75, 25, 3, 0, 1, 130, 0, 1, 130, 0, 1,
  2, 0, 1, 6, 0, 3, 6, 0, 3, 6, 0, 3, 6, 0, 255, 255,
  224, 2, 4, 0, 2, 4, 0, 2, 12, 0, 6, 12, 0, 6, 12, 0,
  6, 12, 0, 6, 8, 0, 4, 8, 0, 4, 8, 0, 255, 255, 224, 12,
  24, 0, 12, 24, 0, 12, 16, 0, 8, 16, 0, 8, 48, 0, 8, 48,
  0, 24, 48, 0, 16, 31, 62, 21, 2, 253, 2, 64, 2, 64, 2, 64,
  7, 224, 26, 92, 50, 70, 34, 66, 98, 67, 98, 71, 98, 79, 98, 79,
  114, 78, 58, 64, 63, 64, 31, 192, 7, 240, 3, 252, 2, 126, 2, 78,
  34, 71, 242, 67, 242, 67, 226, 67, 226, 67, 194, 66, 66, 70, 34, 76,
  30, 112, 3, 192, 2, 64, 2, 64, 24, 25, 75, 30, 3, 0, 30, 0,
  48, 33, 0, 32, 97, 128, 96, 192, 192, 64, 192, 192, 192, 192, 192, 128,
  192, 193, 0, 192, 195, 0, 192, 194, 0, 64, 134, 0, 97, 132, 0, 34,
  8, 0, 28, 24, 112, 0, 16, 132, 0, 49, 134, 0, 33, 2, 0, 67,
  3, 0, 195, 3, 0, 131, 3, 1, 131, 3, 1, 3, 3, 3, 3, 3,
  6, 1, 6, 4, 1, 134, 12, 0, 252, 24, 25, 75, 28, 2, 0, 1,
  240, 0, 3, 8, 0, 6, 12, 0, 12, 4, 0, 12, 4, 0, 12, 12,
  0, 14, 8, 0, 14, 24, 0, 7, 48, 0, 7, 192, 0, 3, 193, 255,
  7, 192, 56, 13, 224, 48, 24, 240, 48, 48, 112, 32, 112, 120, 96, 112,
  60, 64, 224, 28, 128, 224, 15, 128, 224, 15, 0, 224, 7, 0, 240, 3,
  129, 112, 15, 194, 120, 25, 228, 31, 224, 252, 2, 7, 7, 8, 3, 20,
  192, 192, 192, 192, 192, 192, 64, 8, 33, 33, 14, 4, 250, 3, 6, 12,
  12, 24, 16, 48, 48, 96, 96, 96, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 64, 96, 96, 96, 48, 48, 24, 24, 12, 6, 6, 3, 8, 33,
  33, 13, 2, 250, 192, 96, 96, 48, 24, 24, 12, 12, 6, 6, 6, 2,
  3, 3, 3, 3, 3, 3, 3, 3, 2, 6, 6, 6, 4, 12, 12, 24,
  24, 48, 96, 192, 128, 13, 15, 30, 18, 3, 10, 7, 0, 7, 0, 7,
  0, 195, 24, 226, 56, 242, 120, 58, 224, 7, 0, 7, 128, 122, 240, 242,
  120, 226, 56, 7, 0, 7, 0, 7, 0, 30, 31, 124, 34, 2, 250, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 255, 255, 255, 252, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0,
  3, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 5, 11, 11, 10, 2,
  250, 112, 248, 248, 120, 8, 8, 8, 16, 16, 32, 64, 9, 2, 4, 13,
  2, 8, 255, 128, 255, 128, 4, 5, 5, 10, 3, 0, 96, 240, 240, 240,
  96, 12, 34, 68, 16, 2, 249, 0, 16, 0, 48, 0, 48, 0, 32, 0,
  96, 0, 96, 0, 64, 0, 192, 0, 192, 0, 128, 0, 128, 1, 128, 1,
  0, 1, 0, 3, 0, 2, 0, 2, 0, 6, 0, 4, 0, 4, 0, 12,
  0, 8, 0, 8, 0, 24, 0, 24, 0, 16, 0, 48, 0, 48, 0, 32,
  0, 96, 0, 96, 0, 64, 0, 192, 0, 192, 0, 17, 25, 75, 21, 2,
  0, 3, 224, 0, 14, 56, 0, 28, 28, 0, 24, 12, 0, 56, 14, 0,
  112, 7, 0, 112, 7, 0, 112, 7, 0, 240, 7, 128, 240, 7, 128, 240,
  7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7,
  128, 240, 7, 128, 112, 7, 0, 112, 7, 0, 112, 7, 0, 56, 14, 0,
  56, 14, 0, 24, 12, 0, 12, 24, 0, 7, 112, 0, 12, 25, 50, 21,
  4, 0, 1, 0, 3, 0, 3, 0, 15, 0, 255, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  7, 0, 255, 240, 15, 25, 50, 21, 3, 0, 15, 192, 48, 112, 96, 56,
  64, 60, 192, 30, 192, 30, 224, 30, 248, 30, 248, 30, 120, 28, 0, 60,
  0, 56, 0, 112, 0, 224, 1, 192, 3, 0, 14, 0, 28, 4, 56, 4,
  48, 4, 96, 4, 96, 12, 255, 252, 255, 252, 255, 252, 15, 25, 50, 21,
  3, 0, 15, 192, 48, 112, 32, 56, 96, 28, 112, 28, 120, 28, 120, 28,
  48, 28, 0, 28, 0, 56, 0, 112, 31, 192, 24, 112, 0, 56, 0, 60,
  0, 30, 0, 30, 112, 30, 248, 30, 248, 30, 248, 30, 192, 60, 192, 56,
  96, 112, 63, 224, 17, 25, 75, 21, 2, 0, 0, 16, 0, 0, 48, 0,
  0, 112, 0, 0, 112, 0, 0, 240, 0, 1, 240, 0, 1, 112, 0, 3,
  112, 0, 6, 112, 0, 6, 112, 0, 12, 112, 0, 8, 112, 0, 24, 112,
  0, 48, 112, 0, 32, 112, 0, 96, 112, 0, 192, 112, 0, 255, 255, 128,
  0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0,
  112, 0, 7, 255, 128, 15, 26, 52, 21, 3, 0, 32, 0, 48, 56, 63,
  240, 63, 192, 47, 0, 32, 0, 32, 0, 32, 0, 32, 0, 39, 192, 56,
  112, 48, 56, 32, 60, 32, 28, 0, 30, 0, 30, 0, 30, 0, 30, 120,
  30, 248, 30, 248, 28, 240, 60, 224, 60, 96, 56, 112, 112, 63, 192, 15,
  25, 50, 21, 3, 0, 3, 224, 6, 24, 12, 12, 24, 28, 56, 60, 48,
  60, 112, 16, 112, 0, 112, 0, 243, 224, 246, 56, 252, 28, 248, 28, 248,
  14, 240, 14, 240, 14, 240, 14, 240, 14, 112, 14, 112, 14, 112, 12, 56,
  28, 56, 24, 24, 56, 14, 224, 14, 25, 50, 21, 3, 0, 255, 252, 255,
  252, 255, 252, 192, 12, 128, 8, 128, 8, 128, 8, 128, 16, 0, 16, 0,
  32, 0, 96, 0, 64, 0, 128, 1, 128, 1, 128, 3, 0, 3, 0, 7,
  0, 7, 0, 15, 128, 15, 128, 15, 128, 15, 128, 15, 128, 7, 128, 17,
  25, 75, 21, 2, 0, 7, 240, 0, 28, 28, 0, 48, 14, 0, 112, 6,
  0, 224, 3, 0, 224, 3, 0, 224, 3, 0, 240, 3, 0, 240, 6, 0,
  124, 6, 0, 127, 140, 0, 31, 240, 0, 7, 252, 0, 25, 254, 0, 48,
  63, 0, 96, 15, 128, 224, 7, 128, 224, 3, 128, 224, 3, 128, 224, 3,
  128, 224, 3, 0, 96, 7, 0, 112, 6, 0, 56, 12, 0, 15, 248, 0,
  15, 25, 50, 21, 3, 0, 7, 192, 24, 96, 48, 48, 112, 56, 112, 28,
  224, 28, 224, 28, 224, 30, 224, 30, 224, 30, 224, 30, 112, 62, 112, 62,
  56, 94, 15, 158, 0, 30, 0, 28, 0, 28, 56, 28, 120, 28, 120, 56,
  112, 56, 96, 112, 48, 224, 31, 192, 4, 17, 17, 10, 3, 0, 96, 240,
  240, 240, 96, 0, 0, 0, 0, 0, 0, 0, 96, 240, 240, 240, 96, 5,
  23, 23, 11, 3, 250, 112, 248, 248, 248, 112, 0, 0, 0, 0, 0, 0,
  0, 112, 248, 248, 120, 24, 24, 24, 16, 48, 32, 64, 28, 29, 116, 34,
  3, 251, 0, 0, 0, 112, 0, 0, 1, 192, 0, 0, 7, 0, 0, 0,
  28, 0, 0, 0, 112, 0, 0, 1, 224, 0, 0, 3, 128, 0, 0, 14,
  0, 0, 0, 56, 0, 0, 0, 224, 0, 0, 3, 128, 0, 0, 15, 0,
  0, 0, 28, 0, 0, 0, 112, 0, 0, 0, 192, 0, 0, 0, 112, 0,
  0, 0, 28, 0, 0, 0, 7, 0, 0, 0, 1, 192, 0, 0, 0, 240,
  0, 0, 0, 56, 0, 0, 0, 14, 0, 0, 0, 3, 128, 0, 0, 0,
  224, 0, 0, 0, 56, 0, 0, 0, 14, 0, 0, 0, 7, 0, 0, 0,
  1, 192, 0, 0, 0, 112, 30, 8, 32, 34, 2, 6, 255, 255, 255, 252,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 252, 28, 29, 116, 34,
  3, 251, 224, 0, 0, 0, 56, 0, 0, 0, 14, 0, 0, 0, 3, 128,
  0, 0, 0, 224, 0, 0, 0, 112, 0, 0, 0, 28, 0, 0, 0, 7,
  0, 0, 0, 1, 192, 0, 0, 0, 112, 0, 0, 0, 28, 0, 0, 0,
  15, 0, 0, 0, 3, 128, 0, 0, 0, 224, 0, 0, 0, 48, 0, 0,
  0, 224, 0, 0, 3, 128, 0, 0, 14, 0, 0, 0, 56, 0, 0, 0,
  240, 0, 0, 1, 192, 0, 0, 7, 0, 0, 0, 28, 0, 0, 0, 112,
  0, 0, 1, 192, 0, 0, 7, 0, 0, 0, 30, 0, 0, 0, 56, 0,
  0, 0, 224, 0, 0, 0, 13, 25, 50, 17, 2, 0, 15, 128, 48, 224,
  64, 112, 192, 56, 192, 56, 248, 56, 248, 56, 112, 56, 0, 112, 0, 224,
  1, 192, 3, 128, 3, 0, 4, 0, 12, 0, 8, 64, 8, 64, 8, 128,
  7, 0, 0, 0, 3, 0, 7, 128, 7, 128, 7, 128, 3, 0, 26, 27,
  108, 30, 2, 0, 0, 4, 0, 0, 0, 251, 224, 0, 3, 0, 56, 0,
  6, 0, 12, 0, 12, 0, 6, 0, 24, 0, 3, 0, 48, 15, 1, 0,
  48, 49, 241, 128, 96, 96, 241, 128, 96, 192, 224, 128, 193, 192, 224, 192,
  193, 128, 224, 192, 193, 128, 192, 192, 195, 128, 192, 192, 195, 1, 192, 192,
  195, 1, 192, 192, 195, 1, 129, 128, 195, 3, 129, 128, 67, 7, 129, 0,
  99, 7, 130, 0, 97, 137, 132, 0, 32, 240, 248, 0, 48, 0, 0, 0,
  24, 0, 0, 0, 12, 0, 16, 0, 7, 0, 48, 0, 1, 255, 192, 0,
  25, 26, 104, 28, 2, 0, 0, 8, 0, 0, 0, 12, 0, 0, 0, 28,
  0, 0, 0, 28, 0, 0, 0, 30, 0, 0, 0, 62, 0, 0, 0, 46,
  0, 0, 0, 47, 0, 0, 0, 103, 0, 0, 0, 103, 0, 0, 0, 71,
  128, 0, 0, 195, 128, 0, 0, 195, 128, 0, 0, 131, 192, 0, 1, 129,
  192, 0, 1, 129, 192, 0, 3, 1, 224, 0, 3, 255, 224, 0, 2, 0,
  224, 0, 6, 0, 240, 0, 6, 0, 112, 0, 6, 0, 112, 0, 12, 0,
  120, 0, 12, 0, 120, 0, 30, 0, 120, 0, 255, 195, 255, 128, 20, 26,
  78, 25, 3, 0, 255, 252, 0, 28, 3, 0, 28, 1, 192, 28, 1, 192,
  28, 0, 224, 28, 0, 224, 28, 0, 224, 28, 0, 224, 28, 0, 224, 28,
  1, 192, 28, 1, 128, 28, 3, 0, 31, 252, 0, 28, 7, 0, 28, 1,
  192, 28, 1, 224, 28, 0, 224, 28, 0, 240, 28, 0, 240, 28, 0, 240,
  28, 0, 240, 28, 0, 240, 28, 1, 224, 28, 1, 192, 28, 3, 128, 255,
  254, 0, 19, 26, 78, 24, 3, 1, 3, 252, 32, 14, 6, 96, 28, 3,
  224, 24, 1, 224, 56, 0, 224, 120, 0, 224, 112, 0, 96, 112, 0, 96,
  240, 0, 96, 240, 0, 32, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240,
  0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 112, 0, 32, 112, 0,
  32, 120, 0, 96, 56, 0, 64, 56, 0, 64, 28, 0, 128, 12, 0, 128,
  6, 3, 0, 3, 222, 0, 24, 26, 78, 29, 3, 0, 255, 255, 0, 28,
  1, 192, 28, 0, 112, 28, 0, 56, 28, 0, 56, 28, 0, 28, 28, 0,
  30, 28, 0, 30, 28, 0, 14, 28, 0, 15, 28, 0, 15, 28, 0, 15,
  28, 0, 15, 28, 0, 15, 28, 0, 15, 28, 0, 15, 28, 0, 15, 28,
  0, 14, 28, 0, 30, 28, 0, 30, 28, 0, 28, 28, 0, 56, 28, 0,
  56, 28, 0, 112, 28, 1, 192, 255, 255, 0, 21, 26, 78, 25, 2, 0,
  255, 255, 248, 14, 0, 120, 14, 0, 56, 14, 0, 24, 14, 0, 24, 14,
  0, 8, 14, 0, 8, 14, 4, 8, 14, 4, 0, 14, 4, 0, 14, 12,
  0, 14, 12, 0, 15, 252, 0, 14, 12, 0, 14, 4, 0, 14, 4, 0,
  14, 4, 8, 14, 4, 8, 14, 0, 8, 14, 0, 8, 14, 0, 24, 14,
  0, 24, 14, 0, 56, 14, 0, 56, 14, 0, 248, 255, 255, 248, 20, 26,
  78, 24, 2, 0, 255, 255, 240, 14, 0, 240, 14, 0, 112, 14, 0, 48,
  14, 0, 48, 14, 0, 16, 14, 0, 16, 14, 4, 16, 14, 4, 0, 14,
  4, 0, 14, 12, 0, 14, 12, 0, 15, 252, 0, 14, 12, 0, 14, 12,
  0, 14, 4, 0, 14, 4, 0, 14, 4, 0, 14, 0, 0, 14, 0, 0,
  14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 255,
  224, 0, 22, 27, 81, 26, 3, 0, 0, 32, 0, 3, 220, 32, 6, 7,
  32, 12, 3, 224, 24, 1, 224, 56, 0, 224, 56, 0, 96, 112, 0, 96,
  112, 0, 96, 112, 0, 32, 240, 0, 32, 240, 0, 0, 240, 0, 0, 240,
  0, 0, 240, 15, 252, 240, 0, 224, 240, 0, 224, 240, 0, 224, 240, 0,
  224, 112, 0, 224, 112, 0, 224, 56, 0, 224, 56, 1, 224, 24, 1, 32,
  12, 3, 32, 6, 6, 32, 3, 252, 32, 24, 26, 78, 28, 2, 0, 255,
  195, 255, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0,
  56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56,
  14, 0, 56, 15, 255, 248, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14,
  0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0,
  56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 255, 195, 255, 10, 26, 52,
  14, 2, 0, 255, 192, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14,
  0, 14, 0, 14, 0, 255, 192, 16, 26, 52, 19, 2, 0, 3, 255, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 112, 56, 248, 56, 248, 56, 240, 56, 192, 48, 192, 112, 96, 96, 63,
  192, 24, 26, 78, 28, 2, 0, 255, 199, 254, 14, 1, 240, 14, 0, 224,
  14, 0, 192, 14, 1, 128, 14, 3, 0, 14, 6, 0, 14, 12, 0, 14,
  24, 0, 14, 24, 0, 14, 56, 0, 14, 124, 0, 14, 188, 0, 15, 62,
  0, 15, 30, 0, 14, 31, 0, 14, 15, 0, 14, 15, 128, 14, 7, 128,
  14, 7, 192, 14, 3, 192, 14, 1, 224, 14, 1, 240, 14, 0, 240, 14,
  0, 248, 255, 199, 255, 20, 26, 78, 24, 2, 0, 255, 224, 0, 14, 0,
  0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0,
  14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14,
  0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 16, 14, 0,
  16, 14, 0, 32, 14, 0, 48, 14, 0, 48, 14, 0, 48, 14, 0, 112,
  14, 0, 240, 14, 3, 240, 255, 255, 240, 26, 26, 104, 30, 2, 0, 255,
  0, 31, 192, 15, 0, 30, 0, 15, 128, 30, 0, 15, 128, 46, 0, 11,
  128, 46, 0, 11, 128, 46, 0, 11, 192, 110, 0, 9, 192, 78, 0, 9,
  192, 78, 0, 9, 224, 78, 0, 8, 224, 142, 0, 8, 224, 142, 0, 8,
  224, 142, 0, 8, 241, 142, 0, 8, 113, 14, 0, 8, 113, 14, 0, 8,
  121, 14, 0, 8, 59, 14, 0, 8, 58, 14, 0, 8, 58, 14, 0, 8,
  30, 14, 0, 8, 28, 14, 0, 8, 28, 14, 0, 8, 12, 14, 0, 28,
  12, 14, 0, 255, 136, 255, 192, 25, 26, 104, 28, 2, 0, 254, 0, 255,
  128, 15, 0, 28, 0, 15, 128, 8, 0, 15, 128, 8, 0, 11, 192, 8,
  0, 11, 192, 8, 0, 9, 224, 8, 0, 8, 240, 8, 0, 8, 240, 8,
  0, 8, 120, 8, 0, 8, 60, 8, 0, 8, 60, 8, 0, 8, 30, 8,
  0, 8, 30, 8, 0, 8, 15, 8, 0, 8, 7, 136, 0, 8, 7, 136,
  0, 8, 3, 200, 0, 8, 1, 232, 0, 8, 1, 232, 0, 8, 0, 248,
  0, 8, 0, 120, 0, 8, 0, 120, 0, 8, 0, 56, 0, 28, 0, 24,
  0, 255, 128, 24, 0, 21, 27, 81, 26, 3, 0, 0, 32, 0, 3, 220,
  0, 6, 3, 0, 12, 1, 128, 28, 1, 192, 56, 0, 224, 56, 0, 224,
  120, 0, 240, 112, 0, 112, 112, 0, 112, 240, 0, 120, 240, 0, 120, 240,
  0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0,
  120, 112, 0, 112, 112, 0, 112, 120, 0, 240, 56, 0, 224, 56, 0, 224,
  28, 1, 192, 12, 1, 128, 6, 3, 0, 3, 254, 0, 21, 26, 78, 25,
  2, 0, 255, 255, 0, 14, 1, 192, 14, 0, 224, 14, 0, 240, 14, 0,
  120, 14, 0, 120, 14, 0, 120, 14, 0, 120, 14, 0, 120, 14, 0, 112,
  14, 0, 240, 14, 0, 224, 14, 1, 192, 15, 254, 0, 14, 0, 0, 14,
  0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0,
  0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 255, 224, 0,
  21, 33, 99, 26, 3, 250, 0, 32, 0, 3, 220, 0, 6, 3, 0, 12,
  1, 128, 28, 1, 192, 56, 0, 224, 56, 0, 224, 120, 0, 240, 112, 0,
  112, 112, 0, 112, 240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120,
  240, 0, 120, 240, 0, 120, 240, 0, 120, 240, 0, 120, 112, 0, 112, 112,
  0, 112, 120, 0, 240, 56, 112, 224, 57, 152, 224, 29, 13, 192, 13, 13,
  128, 7, 15, 8, 3, 158, 8, 0, 110, 8, 0, 14, 8, 0, 14, 24,
  0, 7, 176, 0, 7, 240, 0, 3, 192, 22, 26, 78, 25, 2, 0, 255,
  255, 0, 14, 3, 192, 14, 1, 224, 14, 0, 240, 14, 0, 240, 14, 0,
  240, 14, 0, 240, 14, 0, 240, 14, 1, 224, 14, 1, 192, 14, 7, 128,
  15, 252, 0, 14, 6, 0, 14, 7, 0, 14, 3, 128, 14, 3, 128, 14,
  3, 128, 14, 3, 192, 14, 3, 192, 14, 3, 192, 14, 3, 196, 14, 1,
  196, 14, 1, 196, 14, 1, 236, 14, 1, 248, 255, 224, 240, 17, 26, 78,
  22, 3, 1, 31, 227, 0, 48, 51, 0, 96, 31, 0, 192, 15, 0, 192,
  7, 0, 192, 3, 0, 192, 3, 0, 224, 3, 0, 240, 1, 0, 120, 0,
  0, 127, 0, 0, 63, 192, 0, 31, 248, 0, 7, 252, 0, 1, 254, 0,
  128, 63, 0, 128, 15, 128, 128, 3, 128, 192, 3, 128, 192, 1, 128, 192,
  1, 128, 224, 1, 128, 240, 1, 0, 248, 3, 0, 140, 6, 0, 135, 252,
  0, 21, 26, 78, 26, 3, 0, 255, 255, 248, 240, 112, 120, 224, 112, 56,
  192, 112, 24, 192, 112, 24, 192, 112, 24, 128, 112, 8, 128, 112, 8, 128,
  112, 8, 128, 112, 8, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112,
  0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0,
  0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0, 112, 0, 0,
  112, 0, 7, 255, 128, 25, 26, 104, 29, 2, 0, 255, 192, 255, 128, 14,
  0, 14, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14,
  0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14,
  0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14,
  0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14,
  0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 14, 0, 4, 0, 6,
  0, 8, 0, 7, 0, 8, 0, 3, 0, 16, 0, 1, 192, 32, 0, 0,
  127, 192, 0, 25, 26, 104, 28, 2, 0, 255, 241, 255, 128, 15, 0, 60,
  0, 15, 0, 24, 0, 7, 128, 24, 0, 7, 128, 16, 0, 3, 128, 48,
  0, 3, 192, 48, 0, 3, 192, 48, 0, 1, 192, 32, 0, 1, 224, 96,
  0, 1, 224, 96, 0, 0, 224, 64, 0, 0, 240, 192, 0, 0, 240, 192,
  0, 0, 112, 128, 0, 0, 113, 128, 0, 0, 121, 128, 0, 0, 57, 0,
  0, 0, 59, 0, 0, 0, 63, 0, 0, 0, 30, 0, 0, 0, 30, 0,
  0, 0, 14, 0, 0, 0, 14, 0, 0, 0, 12, 0, 0, 0, 4, 0,
  0, 36, 26, 130, 38, 1, 0, 255, 231, 255, 63, 240, 15, 0, 248, 7,
  128, 15, 0, 120, 3, 0, 7, 0, 120, 3, 0, 7, 128, 120, 6, 0,
  7, 128, 248, 6, 0, 3, 128, 252, 6, 0, 3, 128, 252, 4, 0, 3,
  192, 156, 12, 0, 1, 193, 156, 12, 0, 1, 193, 158, 12, 0, 1, 225,
  14, 24, 0, 1, 227, 14, 24, 0, 0, 227, 14, 24, 0, 0, 227, 15,
  16, 0, 0, 242, 7, 48, 0, 0, 118, 7, 48, 0, 0, 118, 7, 32,
  0, 0, 116, 3, 224, 0, 0, 124, 3, 224, 0, 0, 60, 3, 192, 0,
  0, 60, 1, 192, 0, 0, 56, 1, 192, 0, 0, 24, 1, 192, 0, 0,
  24, 1, 128, 0, 0, 16, 0, 128, 0, 24, 26, 78, 27, 2, 0, 255,
  227, 255, 15, 128, 112, 7, 128, 96, 7, 192, 96, 3, 192, 192, 1, 224,
  128, 1, 225, 128, 0, 227, 0, 0, 242, 0, 0, 118, 0, 0, 124, 0,
  0, 56, 0, 0, 60, 0, 0, 60, 0, 0, 62, 0, 0, 79, 0, 0,
  207, 0, 0, 135, 128, 1, 135, 128, 1, 3, 192, 3, 3, 192, 6, 1,
  224, 6, 0, 224, 14, 0, 240, 30, 0, 240, 255, 199, 255, 24, 26, 78,
  27, 2, 0, 255, 225, 255, 31, 0, 56, 15, 0, 48, 7, 128, 48, 7,
  128, 32, 3, 192, 96, 3, 192, 64, 1, 224, 128, 0, 224, 128, 0, 241,
  0, 0, 113, 0, 0, 122, 0, 0, 58, 0, 0, 60, 0, 0, 28, 0,
  0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0,
  28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 1, 255,
  224, 19, 26, 78, 23, 2, 0, 63, 255, 224, 60, 3, 192, 56, 3, 192,
  112, 7, 128, 96, 15, 0, 96, 15, 0, 64, 30, 0, 64, 30, 0, 64,
  60, 0, 0, 120, 0, 0, 120, 0, 0, 240, 0, 0, 224, 0, 1, 224,
  0, 3, 192, 0, 3, 192, 0, 7, 128, 32, 7, 0, 32, 15, 0, 32,
  30, 0, 96, 30, 0, 96, 60, 0, 224, 56, 0, 224, 120, 1, 224, 240,
  3, 192, 255, 255, 192, 7, 33, 33, 14, 4, 249, 254, 240, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 240, 254, 12, 34, 68, 16,
  2, 249, 128, 0, 192, 0, 64, 0, 64, 0, 96, 0, 32, 0, 32, 0,
  48, 0, 16, 0, 16, 0, 24, 0, 8, 0, 8, 0, 12, 0, 4, 0,
  4, 0, 6, 0, 6, 0, 2, 0, 3, 0, 3, 0, 1, 0, 1, 128,
  1, 128, 0, 128, 0, 128, 0, 192, 0, 64, 0, 64, 0, 96, 0, 32,
  0, 32, 0, 48, 0, 16, 7, 33, 33, 15, 3, 249, 254, 14, 14, 14,
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
  14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 254, 15, 13, 26,
  21, 3, 12, 1, 0, 3, 128, 3, 128, 6, 192, 4, 64, 12, 96, 24,
  48, 16, 16, 48, 24, 96, 8, 96, 12, 192, 6, 128, 2, 19, 1, 3,
  19, 0, 250, 255, 255, 224, 6, 6, 6, 16, 3, 19, 192, 224, 112, 48,
  24, 12, 16, 17, 34, 19, 2, 0, 15, 128, 48, 224, 96, 112, 96, 112,
  120, 112, 120, 112, 0, 112, 1, 240, 30, 112, 112, 112, 96, 112, 224, 112,
  224, 113, 224, 241, 225, 113, 113, 126, 62, 60, 16, 26, 52, 18, 0, 0,
  252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 112, 29, 140, 29, 14, 30, 6, 30, 7, 28, 7, 28, 7,
  28, 7, 28, 7, 28, 7, 28, 7, 28, 7, 28, 7, 30, 6, 26, 14,
  17, 12, 16, 240, 12, 17, 34, 16, 2, 0, 15, 128, 24, 96, 48, 48,
  112, 48, 96, 112, 224, 112, 224, 112, 224, 0, 224, 0, 224, 0, 224, 0,
  224, 0, 96, 16, 112, 16, 48, 32, 24, 64, 15, 128, 16, 26, 52, 19,
  2, 0, 1, 248, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 56, 14, 56, 57, 184, 48, 184, 112, 120, 96, 120, 224, 56,
  224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 224, 56, 96, 56, 112, 120,
  48, 120, 48, 248, 15, 63, 13, 17, 34, 17, 2, 0, 15, 128, 24, 224,
  48, 96, 112, 112, 96, 48, 224, 56, 224, 56, 255, 248, 224, 0, 224, 0,
  224, 0, 224, 8, 112, 16, 112, 16, 48, 32, 24, 96, 7, 128, 12, 26,
  52, 12, 1, 0, 7, 192, 12, 32, 28, 48, 56, 112, 56, 112, 56, 0,
  56, 0, 56, 0, 56, 0, 255, 128, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 56, 0, 56, 0, 255, 128, 17, 25, 75, 20, 2, 248, 7, 199,
  0, 28, 117, 128, 56, 59, 128, 112, 31, 128, 112, 28, 0, 112, 28, 0,
  112, 28, 0, 112, 28, 0, 56, 56, 0, 28, 112, 0, 7, 192, 0, 56,
  0, 0, 64, 0, 0, 64, 0, 0, 64, 0, 0, 127, 224, 0, 63, 248,
  0, 14, 28, 0, 112, 2, 0, 192, 2, 0, 192, 2, 0, 192, 2, 0,
  224, 4, 0, 112, 8, 0, 15, 240, 0, 18, 26, 78, 21, 1, 0, 252,
  0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 124, 0, 28, 142, 0,
  29, 7, 0, 30, 7, 0, 30, 7, 0, 28, 7, 0, 28, 7, 0, 28,
  7, 0, 28, 7, 0, 28, 7, 0, 28, 7, 0, 28, 7, 0, 28, 7,
  0, 28, 7, 0, 28, 7, 0, 28, 7, 0, 255, 31, 192, 7, 25, 25,
  10, 2, 0, 48, 120, 120, 48, 0, 0, 0, 0, 248, 56, 56, 56, 56,
  56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 254, 9, 34, 68, 11,
  255, 248, 1, 128, 3, 128, 3, 128, 1, 128, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 31, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128,
  3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 3, 128,
  3, 128, 3, 128, 3, 128, 3, 128, 3, 128, 67, 128, 227, 128, 227, 0,
  195, 0, 70, 0, 60, 0, 17, 26, 78, 19, 1, 0, 252, 0, 0, 28,
  0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 0, 28, 0, 0, 28, 127, 0, 28, 24, 0, 28, 16, 0,
  28, 48, 0, 28, 32, 0, 28, 64, 0, 28, 128, 0, 29, 192, 0, 29,
  192, 0, 30, 224, 0, 28, 112, 0, 28, 112, 0, 28, 56, 0, 28, 60,
  0, 28, 28, 0, 28, 30, 0, 255, 127, 128, 9, 26, 52, 11, 1, 0,
  252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 255, 128, 25, 17, 68, 29, 2, 0, 248, 240, 120, 0, 57, 56,
  156, 0, 58, 29, 14, 0, 60, 30, 14, 0, 60, 30, 14, 0, 56, 28,
  14, 0, 56, 28, 14, 0, 56, 28, 14, 0, 56, 28, 14, 0, 56, 28,
  14, 0, 56, 28, 14, 0, 56, 28, 14, 0, 56, 28, 14, 0, 56, 28,
  14, 0, 56, 28, 14, 0, 56, 28, 14, 0, 254, 127, 63, 128, 17, 17,
  51, 21, 2, 0, 248, 248, 0, 57, 28, 0, 58, 14, 0, 60, 14, 0,
  60, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56,
  14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14,
  0, 56, 14, 0, 254, 63, 128, 14, 17, 34, 18, 2, 0, 7, 128, 24,
  96, 48, 48, 112, 56, 112, 24, 224, 28, 224, 28, 224, 28, 224, 28, 224,
  28, 224, 28, 224, 28, 112, 24, 112, 56, 48, 48, 24, 96, 7, 128, 16,
  25, 50, 19, 1, 248, 252, 240, 29, 140, 31, 14, 30, 6, 30, 7, 28,
  7, 28, 7, 28, 7, 28, 7, 28, 7, 28, 7, 28, 7, 28, 7, 30,
  6, 30, 14, 29, 12, 28, 240, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 255, 128, 16, 25, 50, 18, 2, 248, 15, 8, 56,
  136, 48, 216, 112, 88, 96, 120, 224, 56, 224, 56, 224, 56, 224, 56, 224,
  56, 224, 56, 224, 56, 96, 56, 112, 120, 48, 120, 48, 184, 15, 56, 0,
  56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 1, 255, 12,
  17, 34, 15, 2, 0, 248, 224, 57, 16, 58, 48, 58, 112, 60, 112, 60,
  0, 60, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 56, 0, 254, 0, 12, 17, 34, 16, 2, 0, 62, 64, 97,
  64, 192, 192, 192, 64, 192, 64, 224, 64, 120, 0, 127, 0, 31, 192, 7,
  224, 128, 240, 192, 112, 192, 48, 224, 48, 224, 48, 152, 96, 135, 192, 11,
  24, 48, 13, 1, 0, 8, 0, 8, 0, 8, 0, 8, 0, 24, 0, 24,
  0, 56, 0, 255, 192, 56, 0, 56, 0, 56, 0, 56, 0, 56, 0, 56,
  0, 56, 0, 56, 0, 56, 0, 56, 0, 56, 32, 56, 32, 56, 32, 56,
  96, 31, 192, 15, 128, 17, 17, 51, 20, 1, 0, 248, 62, 0, 56, 14,
  0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0,
  56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56, 14, 0, 56,
  30, 0, 56, 30, 0, 56, 46, 0, 28, 78, 0, 15, 143, 128, 18, 17,
  51, 19, 0, 0, 255, 31, 192, 28, 7, 0, 28, 6, 0, 12, 4, 0,
  14, 4, 0, 14, 4, 0, 7, 8, 0, 7, 8, 0, 3, 8, 0, 3,
  144, 0, 1, 144, 0, 1, 208, 0, 1, 224, 0, 0, 224, 0, 0, 224,
  0, 0, 64, 0, 0, 64, 0, 27, 17, 68, 28, 0, 0, 255, 63, 207,
  224, 28, 15, 3, 0, 28, 7, 3, 0, 12, 7, 2, 0, 14, 7, 2,
  0, 14, 15, 130, 0, 7, 11, 132, 0, 7, 9, 132, 0, 3, 137, 196,
  0, 3, 145, 200, 0, 1, 144, 200, 0, 1, 208, 232, 0, 1, 224, 240,
  0, 0, 224, 112, 0, 0, 224, 112, 0, 0, 64, 96, 0, 0, 64, 32,
  0, 16, 17, 34, 19, 2, 0, 254, 126, 60, 56, 28, 48, 28, 32, 14,
  64, 14, 64, 7, 128, 3, 128, 3, 128, 3, 192, 3, 192, 4, 224, 8,
  96, 8, 112, 16, 56, 48, 56, 252, 255, 18, 25, 75, 20, 1, 248, 255,
  31, 192, 28, 6, 0, 28, 6, 0, 12, 4, 0, 14, 4, 0, 14, 4,
  0, 6, 8, 0, 7, 8, 0, 7, 8, 0, 3, 16, 0, 3, 144, 0,
  3, 144, 0, 1, 240, 0, 1, 224, 0, 1, 224, 0, 0, 224, 0, 0,
  192, 0, 0, 64, 0, 0, 192, 0, 0, 128, 0, 112, 128, 0, 113, 128,
  0, 113, 0, 0, 115, 0, 0, 60, 0, 0, 12, 17, 34, 15, 1, 0,
  255, 240, 224, 112, 192, 224, 128, 224, 129, 192, 131, 128, 131, 128, 7, 0,
  7, 0, 14, 0, 28, 16, 28, 16, 56, 16, 56, 16, 112, 48, 224, 112,
  255, 240, 8, 33, 33, 15, 3, 249, 3, 4, 8, 24, 24, 24, 24, 28,
  28, 28, 12, 12, 12, 12, 8, 24, 224, 24, 8, 12, 12, 12, 12, 28,
  28, 28, 24, 24, 24, 24, 8, 4, 3, 2, 34, 34, 10, 4, 249, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 8, 33, 33, 14, 3, 249, 192, 32, 16, 24, 24, 24, 24, 24, 56,
  56, 48, 48, 48, 48, 16, 24, 7, 24, 16, 48, 48, 48, 48, 56, 56,
  24, 24, 24, 24, 24, 16, 32, 192, 20, 6, 18, 24, 2, 6, 62, 0,
  32, 127, 192, 16, 135, 248, 16, 128, 255, 48, 128, 63, 224, 96, 7, 192,
  255
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--41-410-72-72-P-216-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 29, '1' Height: 28
  Calculated Max Values w=41 h=39 x= 8 y=23 dx=44 dy= 0 ascent=39 len=174
  Font Bounding box     w=107 h=51 x=-33 y=-12
  Calculated Min Values           x=-1 y=-11 dx= 0 dy= 0
  Pure Font   ascent =29 descent=-9
  X Font      ascent =30 descent=-9
  Max Font    ascent =39 descent=-11
*/
const u8g_fntpgm_uint8_t u8g_font_osr29[16232] U8G_FONT_SECTION("u8g_font_osr29") = {
  0, 107, 51, 223, 244, 29, 9, 148, 21, 166, 32, 255, 247, 39, 245, 30,
  247, 0, 0, 0, 11, 0, 0, 5, 28, 28, 11, 3, 0, 112, 248, 248,
  248, 248, 248, 248, 248, 112, 112, 112, 112, 112, 112, 112, 112, 32, 32, 32,
  32, 32, 32, 0, 112, 248, 248, 248, 112, 9, 8, 16, 17, 4, 22, 227,
  128, 227, 128, 227, 128, 227, 128, 193, 128, 65, 128, 65, 0, 65, 0, 22,
  28, 84, 28, 3, 0, 0, 192, 192, 0, 192, 192, 0, 192, 192, 0, 192,
  128, 0, 129, 128, 1, 129, 128, 1, 129, 128, 1, 129, 128, 255, 255, 252,
  255, 255, 252, 1, 129, 0, 3, 3, 0, 3, 3, 0, 3, 3, 0, 3,
  3, 0, 3, 3, 0, 2, 2, 0, 6, 6, 0, 255, 255, 252, 255, 255,
  252, 6, 6, 0, 6, 6, 0, 6, 4, 0, 4, 12, 0, 12, 12, 0,
  12, 12, 0, 12, 12, 0, 12, 12, 0, 18, 34, 102, 24, 3, 253, 1,
  16, 0, 1, 16, 0, 1, 16, 0, 3, 248, 0, 13, 22, 0, 25, 17,
  0, 49, 16, 128, 97, 16, 192, 97, 16, 192, 97, 17, 192, 97, 19, 192,
  97, 19, 192, 113, 19, 128, 61, 16, 0, 63, 144, 0, 31, 240, 0, 15,
  252, 0, 3, 254, 0, 1, 127, 0, 1, 31, 128, 1, 19, 128, 33, 17,
  192, 113, 16, 192, 249, 16, 192, 241, 16, 192, 241, 16, 192, 225, 16, 128,
  97, 17, 128, 97, 17, 0, 49, 19, 0, 15, 188, 0, 1, 240, 0, 1,
  16, 0, 1, 16, 0, 28, 28, 112, 36, 4, 0, 31, 0, 6, 0, 49,
  128, 4, 0, 96, 192, 12, 0, 96, 192, 8, 0, 224, 224, 24, 0, 224,
  224, 48, 0, 224, 224, 32, 0, 224, 224, 96, 0, 224, 224, 64, 0, 224,
  224, 128, 0, 96, 193, 128, 0, 96, 193, 0, 0, 49, 131, 0, 0, 31,
  6, 0, 0, 0, 4, 15, 0, 0, 12, 48, 128, 0, 8, 48, 192, 0,
  16, 96, 96, 0, 48, 96, 96, 0, 32, 224, 112, 0, 96, 224, 112, 0,
  64, 224, 112, 0, 128, 224, 112, 1, 128, 224, 112, 1, 0, 96, 96, 2,
  0, 96, 96, 6, 0, 48, 192, 4, 0, 31, 128, 28, 28, 112, 32, 2,
  0, 0, 248, 0, 0, 3, 140, 0, 0, 7, 4, 0, 0, 6, 2, 0,
  0, 14, 2, 0, 0, 14, 2, 0, 0, 14, 6, 0, 0, 14, 4, 0,
  0, 15, 12, 0, 0, 7, 24, 0, 0, 7, 176, 0, 0, 3, 224, 0,
  0, 1, 224, 63, 240, 3, 224, 7, 128, 6, 240, 7, 0, 12, 120, 6,
  0, 24, 124, 6, 0, 48, 60, 4, 0, 112, 30, 12, 0, 112, 31, 24,
  0, 240, 15, 144, 0, 240, 7, 176, 0, 240, 7, 224, 0, 240, 3, 224,
  0, 240, 3, 240, 32, 120, 6, 248, 32, 60, 12, 124, 192, 31, 240, 63,
  128, 3, 8, 8, 10, 4, 22, 224, 224, 224, 224, 192, 64, 64, 64, 9,
  37, 74, 15, 4, 249, 1, 128, 3, 0, 6, 0, 14, 0, 12, 0, 24,
  0, 24, 0, 48, 0, 48, 0, 96, 0, 96, 0, 96, 0, 96, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 96, 0, 96, 0, 96, 0, 96, 0, 48, 0, 48, 0, 56,
  0, 24, 0, 12, 0, 12, 0, 6, 0, 3, 0, 3, 128, 1, 128, 9,
  37, 74, 15, 2, 249, 192, 0, 96, 0, 48, 0, 56, 0, 24, 0, 12,
  0, 12, 0, 6, 0, 6, 0, 3, 0, 3, 0, 3, 0, 3, 0, 1,
  128, 1, 128, 1, 128, 1, 128, 1, 128, 1, 128, 1, 128, 1, 128, 1,
  128, 1, 128, 3, 128, 3, 0, 3, 0, 3, 0, 6, 0, 6, 0, 14,
  0, 12, 0, 24, 0, 24, 0, 48, 0, 96, 0, 224, 0, 192, 0, 15,
  17, 34, 21, 3, 11, 3, 128, 3, 192, 3, 128, 3, 128, 225, 142, 241,
  30, 249, 62, 29, 112, 3, 192, 3, 192, 29, 120, 249, 62, 241, 30, 227,
  142, 3, 128, 3, 192, 3, 128, 35, 34, 170, 39, 2, 250, 0, 0, 192,
  0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0,
  0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0,
  0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0,
  0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0,
  192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 255, 255, 255,
  255, 224, 255, 255, 255, 255, 224, 0, 0, 192, 0, 0, 0, 0, 192, 0,
  0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0,
  0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0,
  0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0,
  192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192,
  0, 0, 0, 0, 192, 0, 0, 5, 12, 12, 11, 3, 249, 112, 240, 248,
  248, 24, 8, 8, 16, 16, 32, 32, 64, 10, 2, 4, 14, 2, 9, 255,
  192, 255, 192, 5, 5, 5, 11, 3, 0, 112, 248, 248, 248, 112, 14, 38,
  76, 18, 2, 248, 0, 12, 0, 12, 0, 12, 0, 8, 0, 24, 0, 24,
  0, 16, 0, 48, 0, 48, 0, 32, 0, 96, 0, 96, 0, 64, 0, 192,
  0, 192, 0, 128, 1, 128, 1, 128, 1, 0, 3, 0, 3, 0, 2, 0,
  6, 0, 6, 0, 4, 0, 12, 0, 12, 0, 8, 0, 24, 0, 24, 0,
  16, 0, 48, 0, 48, 0, 32, 0, 96, 0, 96, 0, 64, 0, 192, 0,
  20, 28, 84, 24, 2, 0, 1, 248, 0, 7, 12, 0, 12, 7, 0, 28,
  3, 128, 24, 1, 128, 56, 1, 192, 56, 1, 192, 112, 0, 224, 112, 0,
  224, 112, 0, 224, 240, 0, 240, 240, 0, 240, 240, 0, 240, 240, 0, 240,
  240, 0, 240, 240, 0, 240, 240, 0, 240, 240, 0, 240, 240, 0, 240, 112,
  0, 224, 112, 0, 224, 112, 0, 224, 56, 1, 192, 56, 1, 192, 24, 1,
  128, 12, 3, 0, 6, 6, 0, 3, 252, 0, 14, 28, 56, 24, 5, 0,
  1, 128, 1, 128, 3, 128, 7, 128, 255, 128, 7, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 255, 252, 17, 28, 84, 24, 3, 0, 7, 224,
  0, 24, 60, 0, 32, 30, 0, 64, 15, 0, 192, 15, 0, 192, 7, 128,
  192, 7, 128, 240, 7, 128, 252, 7, 128, 252, 7, 128, 124, 7, 128, 24,
  15, 0, 0, 14, 0, 0, 28, 0, 0, 56, 0, 0, 112, 0, 0, 224,
  0, 1, 192, 0, 3, 0, 0, 6, 0, 0, 12, 0, 128, 24, 0, 128,
  48, 0, 128, 48, 1, 128, 112, 1, 128, 127, 255, 128, 127, 255, 128, 127,
  255, 128, 17, 28, 84, 24, 3, 0, 15, 224, 0, 48, 56, 0, 96, 28,
  0, 96, 14, 0, 240, 15, 0, 248, 15, 0, 248, 15, 0, 120, 15, 0,
  0, 15, 0, 0, 15, 0, 0, 14, 0, 0, 28, 0, 28, 56, 0, 31,
  224, 0, 0, 60, 0, 0, 30, 0, 0, 15, 0, 0, 7, 0, 0, 7,
  128, 0, 7, 128, 120, 7, 128, 248, 7, 128, 248, 7, 128, 248, 7, 0,
  192, 15, 0, 192, 14, 0, 96, 28, 0, 31, 240, 0, 19, 28, 84, 24,
  2, 0, 0, 12, 0, 0, 12, 0, 0, 28, 0, 0, 60, 0, 0, 60,
  0, 0, 124, 0, 0, 252, 0, 0, 252, 0, 1, 188, 0, 3, 60, 0,
  3, 60, 0, 6, 60, 0, 12, 60, 0, 12, 60, 0, 24, 60, 0, 48,
  60, 0, 32, 60, 0, 96, 60, 0, 192, 60, 0, 255, 255, 224, 0, 60,
  0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0,
  0, 60, 0, 7, 255, 224, 17, 29, 87, 24, 4, 0, 0, 2, 0, 120,
  12, 0, 127, 248, 0, 127, 240, 0, 111, 192, 0, 96, 0, 0, 96, 0,
  0, 96, 0, 0, 96, 0, 0, 96, 0, 0, 103, 224, 0, 104, 60, 0,
  112, 30, 0, 96, 14, 0, 96, 15, 0, 96, 7, 0, 0, 7, 128, 0,
  7, 128, 0, 7, 128, 16, 7, 128, 120, 7, 128, 252, 7, 128, 252, 7,
  128, 248, 15, 0, 224, 15, 0, 224, 14, 0, 96, 28, 0, 48, 56, 0,
  31, 240, 0, 17, 28, 84, 24, 3, 0, 1, 248, 0, 3, 12, 0, 12,
  6, 0, 28, 7, 0, 24, 15, 0, 56, 31, 0, 48, 31, 0, 112, 14,
  0, 112, 0, 0, 112, 0, 0, 240, 0, 0, 241, 240, 0, 246, 28, 0,
  252, 14, 0, 248, 7, 0, 248, 7, 0, 240, 7, 128, 240, 7, 128, 240,
  7, 128, 240, 7, 128, 112, 7, 128, 112, 7, 128, 112, 7, 0, 48, 7,
  0, 56, 7, 0, 24, 14, 0, 12, 28, 0, 7, 248, 0, 16, 28, 56,
  24, 4, 0, 255, 255, 255, 255, 255, 255, 192, 3, 128, 2, 128, 2, 128,
  6, 128, 4, 0, 12, 0, 8, 0, 24, 0, 48, 0, 32, 0, 96, 0,
  192, 0, 192, 1, 128, 3, 128, 3, 128, 7, 128, 7, 128, 7, 128, 15,
  192, 15, 192, 15, 192, 15, 192, 15, 192, 7, 192, 20, 28, 84, 24, 2,
  0, 3, 248, 0, 14, 14, 0, 56, 7, 0, 112, 3, 128, 112, 1, 192,
  240, 1, 192, 240, 1, 192, 240, 1, 192, 240, 1, 192, 248, 1, 128, 126,
  3, 128, 127, 131, 0, 63, 252, 0, 15, 252, 0, 7, 255, 0, 24, 127,
  192, 48, 15, 224, 112, 3, 224, 224, 1, 240, 224, 0, 240, 224, 0, 240,
  224, 0, 224, 224, 0, 224, 224, 0, 224, 112, 1, 192, 48, 1, 128, 28,
  7, 0, 15, 252, 0, 17, 28, 84, 24, 3, 0, 7, 224, 0, 12, 56,
  0, 56, 12, 0, 56, 14, 0, 112, 14, 0, 112, 7, 0, 240, 7, 0,
  240, 7, 0, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 112,
  15, 128, 112, 15, 128, 56, 27, 128, 28, 51, 128, 7, 199, 128, 0, 7,
  128, 0, 7, 0, 0, 7, 0, 56, 7, 0, 124, 7, 0, 124, 14, 0,
  120, 14, 0, 112, 12, 0, 112, 24, 0, 48, 48, 0, 31, 224, 0, 5,
  19, 19, 11, 3, 0, 112, 248, 248, 248, 112, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 112, 248, 248, 248, 112, 6, 26, 26, 12, 3, 249, 112, 248,
  248, 248, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 248, 252, 124,
  12, 12, 12, 8, 24, 48, 32, 64, 32, 34, 136, 39, 3, 250, 0, 0,
  0, 2, 0, 0, 0, 7, 0, 0, 0, 28, 0, 0, 0, 112, 0, 0,
  1, 224, 0, 0, 7, 128, 0, 0, 30, 0, 0, 0, 120, 0, 0, 1,
  224, 0, 0, 3, 128, 0, 0, 14, 0, 0, 0, 56, 0, 0, 0, 240,
  0, 0, 3, 192, 0, 0, 15, 0, 0, 0, 60, 0, 0, 0, 240, 0,
  0, 0, 224, 0, 0, 0, 120, 0, 0, 0, 30, 0, 0, 0, 7, 128,
  0, 0, 1, 192, 0, 0, 0, 112, 0, 0, 0, 28, 0, 0, 0, 7,
  0, 0, 0, 3, 192, 0, 0, 0, 240, 0, 0, 0, 60, 0, 0, 0,
  15, 0, 0, 0, 3, 128, 0, 0, 0, 224, 0, 0, 0, 56, 0, 0,
  0, 14, 0, 0, 0, 6, 35, 10, 50, 39, 2, 6, 255, 255, 255, 255,
  224, 255, 255, 255, 255, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 255, 255, 255, 255, 224, 255, 255, 255, 255, 224, 32, 34,
  136, 39, 3, 250, 64, 0, 0, 0, 224, 0, 0, 0, 56, 0, 0, 0,
  14, 0, 0, 0, 7, 128, 0, 0, 1, 224, 0, 0, 0, 120, 0, 0,
  0, 30, 0, 0, 0, 7, 128, 0, 0, 1, 192, 0, 0, 0, 112, 0,
  0, 0, 28, 0, 0, 0, 15, 0, 0, 0, 3, 192, 0, 0, 0, 240,
  0, 0, 0, 60, 0, 0, 0, 15, 0, 0, 0, 7, 0, 0, 0, 30,
  0, 0, 0, 120, 0, 0, 1, 224, 0, 0, 3, 128, 0, 0, 14, 0,
  0, 0, 56, 0, 0, 0, 224, 0, 0, 3, 192, 0, 0, 15, 0, 0,
  0, 60, 0, 0, 0, 240, 0, 0, 1, 192, 0, 0, 7, 0, 0, 0,
  28, 0, 0, 0, 112, 0, 0, 0, 96, 0, 0, 0, 15, 28, 56, 20,
  3, 0, 15, 192, 48, 112, 64, 60, 192, 28, 192, 30, 248, 30, 248, 30,
  112, 30, 0, 28, 0, 60, 0, 120, 0, 240, 1, 192, 3, 128, 6, 0,
  12, 0, 8, 32, 8, 32, 8, 32, 12, 64, 7, 128, 0, 0, 0, 0,
  3, 128, 7, 192, 7, 192, 7, 192, 3, 128, 29, 29, 116, 33, 2, 1,
  0, 63, 248, 0, 1, 192, 14, 0, 3, 0, 3, 0, 6, 0, 1, 128,
  12, 0, 0, 192, 24, 7, 206, 96, 48, 12, 124, 32, 48, 56, 60, 48,
  96, 112, 60, 16, 96, 224, 56, 24, 96, 224, 56, 24, 193, 192, 56, 24,
  193, 192, 56, 24, 193, 192, 48, 24, 195, 192, 112, 24, 195, 128, 112, 24,
  195, 128, 112, 48, 195, 128, 224, 48, 195, 128, 224, 48, 67, 129, 224, 96,
  97, 130, 224, 192, 97, 196, 225, 128, 48, 120, 62, 0, 48, 0, 0, 0,
  24, 0, 0, 0, 12, 0, 0, 0, 6, 0, 4, 0, 3, 128, 28, 0,
  0, 127, 240, 0, 29, 29, 116, 32, 2, 0, 0, 2, 0, 0, 0, 6,
  0, 0, 0, 7, 0, 0, 0, 7, 0, 0, 0, 15, 128, 0, 0, 15,
  128, 0, 0, 15, 128, 0, 0, 31, 192, 0, 0, 19, 192, 0, 0, 51,
  192, 0, 0, 49, 224, 0, 0, 33, 224, 0, 0, 97, 224, 0, 0, 96,
  240, 0, 0, 64, 240, 0, 0, 192, 240, 0, 0, 192, 120, 0, 0, 128,
  120, 0, 1, 128, 120, 0, 1, 255, 252, 0, 1, 0, 60, 0, 3, 0,
  28, 0, 3, 0, 30, 0, 6, 0, 30, 0, 6, 0, 15, 0, 6, 0,
  15, 0, 14, 0, 15, 0, 30, 0, 15, 128, 255, 224, 255, 248, 23, 29,
  87, 28, 3, 0, 255, 255, 128, 15, 0, 224, 15, 0, 120, 15, 0, 60,
  15, 0, 28, 15, 0, 28, 15, 0, 30, 15, 0, 30, 15, 0, 28, 15,
  0, 28, 15, 0, 56, 15, 0, 48, 15, 0, 224, 15, 255, 0, 15, 0,
  224, 15, 0, 112, 15, 0, 56, 15, 0, 60, 15, 0, 30, 15, 0, 30,
  15, 0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 60, 15,
  0, 60, 15, 0, 120, 15, 0, 224, 255, 255, 128, 22, 29, 87, 28, 3,
  1, 1, 254, 8, 7, 3, 152, 12, 0, 248, 28, 0, 248, 24, 0, 120,
  56, 0, 56, 120, 0, 56, 112, 0, 24, 112, 0, 24, 240, 0, 8, 240,
  0, 8, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0,
  0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 112, 0, 12, 112, 0, 12,
  120, 0, 12, 56, 0, 24, 56, 0, 24, 28, 0, 24, 12, 0, 48, 6,
  0, 96, 3, 0, 192, 0, 255, 128, 27, 29, 116, 32, 3, 0, 255, 255,
  192, 0, 15, 0, 112, 0, 15, 0, 28, 0, 15, 0, 14, 0, 15, 0,
  7, 0, 15, 0, 7, 128, 15, 0, 3, 128, 15, 0, 3, 192, 15, 0,
  3, 192, 15, 0, 1, 192, 15, 0, 1, 224, 15, 0, 1, 224, 15, 0,
  1, 224, 15, 0, 1, 224, 15, 0, 1, 224, 15, 0, 1, 224, 15, 0,
  1, 224, 15, 0, 1, 224, 15, 0, 1, 224, 15, 0, 3, 192, 15, 0,
  3, 192, 15, 0, 3, 192, 15, 0, 3, 128, 15, 0, 7, 0, 15, 0,
  7, 0, 15, 0, 14, 0, 15, 0, 28, 0, 15, 0, 112, 0, 255, 255,
  192, 0, 23, 29, 87, 29, 3, 0, 255, 255, 254, 15, 0, 62, 15, 0,
  14, 15, 0, 14, 15, 0, 6, 15, 0, 6, 15, 0, 2, 15, 0, 2,
  15, 1, 2, 15, 1, 0, 15, 1, 0, 15, 1, 0, 15, 3, 0, 15,
  7, 0, 15, 255, 0, 15, 7, 0, 15, 3, 0, 15, 1, 0, 15, 1,
  2, 15, 1, 2, 15, 1, 2, 15, 0, 2, 15, 0, 6, 15, 0, 6,
  15, 0, 6, 15, 0, 14, 15, 0, 30, 15, 0, 126, 255, 255, 254, 23,
  29, 87, 28, 3, 0, 255, 255, 254, 15, 0, 62, 15, 0, 14, 15, 0,
  14, 15, 0, 6, 15, 0, 6, 15, 0, 2, 15, 0, 2, 15, 1, 2,
  15, 1, 0, 15, 1, 0, 15, 1, 0, 15, 3, 0, 15, 7, 0, 15,
  255, 0, 15, 7, 0, 15, 3, 0, 15, 1, 0, 15, 1, 0, 15, 1,
  0, 15, 1, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0,
  15, 0, 0, 15, 0, 0, 15, 0, 0, 255, 240, 0, 25, 30, 120, 29,
  3, 0, 0, 16, 0, 0, 1, 254, 8, 0, 6, 3, 152, 0, 12, 0,
  248, 0, 28, 0, 248, 0, 24, 0, 120, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 112, 0, 24, 0, 112, 0, 24, 0, 112, 0, 8, 0, 240, 0,
  8, 0, 240, 0, 0, 0, 240, 0, 0, 0, 240, 0, 0, 0, 240, 7,
  255, 128, 240, 0, 120, 0, 240, 0, 120, 0, 240, 0, 120, 0, 240, 0,
  120, 0, 112, 0, 120, 0, 112, 0, 120, 0, 112, 0, 120, 0, 56, 0,
  120, 0, 56, 0, 120, 0, 24, 0, 248, 0, 28, 0, 200, 0, 12, 1,
  136, 0, 6, 3, 8, 0, 1, 254, 8, 0, 28, 29, 116, 33, 3, 0,
  255, 240, 255, 240, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 255, 255, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  255, 240, 255, 240, 12, 29, 58, 17, 3, 0, 255, 240, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 255, 240, 19, 29, 87, 22, 2, 0, 1, 255, 224, 0, 30, 0,
  0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0,
  30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30,
  0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0,
  0, 30, 0, 0, 30, 0, 120, 30, 0, 248, 30, 0, 248, 30, 0, 248,
  30, 0, 192, 28, 0, 192, 28, 0, 64, 24, 0, 96, 48, 0, 31, 224,
  0, 27, 29, 116, 32, 3, 0, 255, 241, 255, 192, 15, 0, 126, 0, 15,
  0, 60, 0, 15, 0, 56, 0, 15, 0, 112, 0, 15, 0, 96, 0, 15,
  0, 192, 0, 15, 1, 128, 0, 15, 3, 0, 0, 15, 6, 0, 0, 15,
  14, 0, 0, 15, 30, 0, 0, 15, 63, 0, 0, 15, 111, 0, 0, 15,
  207, 128, 0, 15, 135, 128, 0, 15, 7, 192, 0, 15, 3, 192, 0, 15,
  3, 224, 0, 15, 3, 224, 0, 15, 1, 240, 0, 15, 1, 240, 0, 15,
  0, 248, 0, 15, 0, 248, 0, 15, 0, 124, 0, 15, 0, 124, 0, 15,
  0, 62, 0, 15, 0, 63, 0, 255, 241, 255, 224, 23, 29, 87, 28, 3,
  0, 255, 248, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0,
  15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15,
  0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0,
  0, 15, 0, 0, 15, 0, 0, 15, 0, 2, 15, 0, 2, 15, 0, 6,
  15, 0, 6, 15, 0, 6, 15, 0, 14, 15, 0, 14, 15, 0, 30, 15,
  0, 62, 15, 0, 254, 255, 255, 254, 30, 29, 116, 35, 3, 0, 255, 128,
  3, 252, 15, 128, 7, 192, 15, 192, 7, 192, 15, 192, 7, 192, 15, 192,
  15, 192, 13, 192, 11, 192, 13, 224, 11, 192, 13, 224, 11, 192, 12, 224,
  27, 192, 12, 240, 19, 192, 12, 240, 19, 192, 12, 112, 51, 192, 12, 112,
  35, 192, 12, 120, 35, 192, 12, 120, 35, 192, 12, 56, 99, 192, 12, 60,
  67, 192, 12, 60, 67, 192, 12, 28, 195, 192, 12, 28, 131, 192, 12, 30,
  131, 192, 12, 14, 131, 192, 12, 15, 131, 192, 12, 15, 3, 192, 12, 15,
  3, 192, 12, 7, 3, 192, 12, 6, 3, 192, 30, 6, 3, 192, 255, 194,
  63, 252, 28, 29, 116, 32, 3, 0, 255, 0, 63, 240, 15, 128, 7, 128,
  15, 128, 3, 0, 15, 192, 3, 0, 15, 224, 3, 0, 13, 224, 3, 0,
  13, 240, 3, 0, 12, 248, 3, 0, 12, 120, 3, 0, 12, 124, 3, 0,
  12, 60, 3, 0, 12, 30, 3, 0, 12, 31, 3, 0, 12, 15, 3, 0,
  12, 7, 131, 0, 12, 7, 131, 0, 12, 3, 195, 0, 12, 3, 227, 0,
  12, 1, 227, 0, 12, 0, 243, 0, 12, 0, 251, 0, 12, 0, 123, 0,
  12, 0, 63, 0, 12, 0, 63, 0, 12, 0, 31, 0, 12, 0, 31, 0,
  12, 0, 15, 0, 30, 0, 7, 0, 255, 192, 7, 0, 24, 29, 87, 29,
  3, 1, 0, 255, 0, 3, 0, 192, 6, 0, 96, 12, 0, 48, 28, 0,
  56, 56, 0, 28, 56, 0, 28, 120, 0, 30, 112, 0, 14, 112, 0, 14,
  240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240,
  0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 112, 0, 14, 112, 0,
  14, 120, 0, 30, 56, 0, 28, 56, 0, 28, 28, 0, 56, 12, 0, 48,
  6, 0, 96, 3, 0, 192, 0, 255, 0, 23, 29, 87, 28, 3, 0, 255,
  255, 128, 15, 0, 224, 15, 0, 120, 15, 0, 60, 15, 0, 60, 15, 0,
  30, 15, 0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 60,
  15, 0, 60, 15, 0, 120, 15, 0, 224, 15, 255, 128, 15, 0, 0, 15,
  0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0,
  0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0,
  15, 0, 0, 255, 248, 0, 24, 36, 108, 29, 3, 250, 0, 255, 0, 3,
  0, 192, 6, 0, 96, 12, 0, 48, 28, 0, 56, 56, 0, 28, 56, 0,
  28, 120, 0, 30, 112, 0, 14, 112, 0, 14, 240, 0, 15, 240, 0, 15,
  240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240,
  0, 15, 240, 0, 15, 112, 0, 14, 120, 0, 30, 120, 0, 30, 56, 60,
  28, 56, 99, 28, 28, 195, 56, 14, 193, 184, 6, 193, 240, 3, 193, 225,
  0, 247, 193, 0, 9, 193, 0, 1, 193, 0, 1, 195, 0, 1, 226, 0,
  1, 254, 0, 0, 252, 0, 0, 56, 25, 29, 116, 29, 3, 0, 255, 255,
  128, 0, 15, 1, 240, 0, 15, 0, 120, 0, 15, 0, 120, 0, 15, 0,
  60, 0, 15, 0, 60, 0, 15, 0, 60, 0, 15, 0, 60, 0, 15, 0,
  60, 0, 15, 0, 120, 0, 15, 0, 240, 0, 15, 1, 224, 0, 15, 255,
  0, 0, 15, 3, 128, 0, 15, 1, 192, 0, 15, 0, 224, 0, 15, 0,
  224, 0, 15, 0, 240, 0, 15, 0, 240, 0, 15, 0, 240, 0, 15, 0,
  240, 0, 15, 0, 240, 0, 15, 0, 248, 128, 15, 0, 120, 128, 15, 0,
  120, 128, 15, 0, 121, 128, 15, 0, 127, 0, 15, 0, 63, 0, 255, 248,
  30, 0, 19, 29, 87, 25, 4, 1, 15, 240, 192, 48, 28, 192, 96, 15,
  192, 96, 7, 192, 192, 3, 192, 192, 1, 192, 192, 1, 192, 192, 0, 192,
  224, 0, 192, 240, 0, 192, 120, 0, 64, 127, 0, 0, 63, 192, 0, 31,
  248, 0, 15, 254, 0, 1, 255, 128, 128, 127, 128, 128, 15, 192, 128, 3,
  224, 128, 1, 224, 192, 0, 224, 192, 0, 96, 224, 0, 96, 224, 0, 96,
  240, 0, 96, 248, 0, 192, 156, 0, 128, 134, 1, 0, 131, 254, 0, 24,
  29, 87, 29, 3, 0, 255, 255, 255, 248, 60, 31, 240, 60, 15, 224, 60,
  7, 192, 60, 3, 192, 60, 3, 192, 60, 3, 128, 60, 1, 128, 60, 1,
  128, 60, 1, 128, 60, 1, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0,
  60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60,
  0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0,
  0, 60, 0, 0, 60, 0, 0, 60, 0, 7, 255, 224, 29, 29, 116, 34,
  3, 0, 255, 240, 31, 248, 15, 0, 3, 192, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 7, 0,
  1, 0, 7, 0, 3, 0, 3, 128, 2, 0, 1, 192, 6, 0, 0, 224,
  24, 0, 0, 63, 240, 0, 29, 29, 116, 32, 2, 0, 255, 248, 63, 248,
  15, 128, 3, 192, 7, 128, 3, 128, 7, 128, 3, 0, 3, 192, 3, 0,
  3, 192, 3, 0, 3, 192, 2, 0, 1, 224, 6, 0, 1, 224, 6, 0,
  1, 240, 4, 0, 0, 240, 12, 0, 0, 240, 12, 0, 0, 248, 8, 0,
  0, 120, 24, 0, 0, 120, 24, 0, 0, 60, 16, 0, 0, 60, 48, 0,
  0, 60, 48, 0, 0, 30, 32, 0, 0, 30, 96, 0, 0, 31, 96, 0,
  0, 15, 64, 0, 0, 15, 192, 0, 0, 15, 192, 0, 0, 7, 128, 0,
  0, 7, 128, 0, 0, 7, 128, 0, 0, 3, 0, 0, 0, 3, 0, 0,
  41, 29, 174, 44, 2, 0, 255, 241, 255, 227, 255, 128, 15, 128, 63, 0,
  124, 0, 7, 128, 30, 0, 56, 0, 7, 128, 30, 0, 48, 0, 7, 128,
  31, 0, 48, 0, 3, 192, 31, 0, 48, 0, 3, 192, 31, 0, 96, 0,
  3, 192, 55, 0, 96, 0, 1, 224, 55, 128, 96, 0, 1, 224, 55, 128,
  64, 0, 1, 224, 39, 128, 192, 0, 1, 224, 99, 192, 192, 0, 0, 240,
  99, 192, 128, 0, 0, 240, 67, 193, 128, 0, 0, 240, 193, 193, 128, 0,
  0, 120, 193, 225, 0, 0, 0, 120, 193, 227, 0, 0, 0, 120, 129, 227,
  0, 0, 0, 125, 128, 242, 0, 0, 0, 61, 128, 246, 0, 0, 0, 61,
  0, 246, 0, 0, 0, 61, 0, 116, 0, 0, 0, 31, 0, 124, 0, 0,
  0, 31, 0, 124, 0, 0, 0, 30, 0, 60, 0, 0, 0, 14, 0, 56,
  0, 0, 0, 14, 0, 56, 0, 0, 0, 12, 0, 56, 0, 0, 0, 12,
  0, 16, 0, 0, 28, 29, 116, 31, 2, 0, 255, 248, 255, 224, 7, 192,
  30, 0, 7, 192, 28, 0, 3, 224, 24, 0, 1, 224, 24, 0, 1, 240,
  48, 0, 0, 240, 32, 0, 0, 248, 96, 0, 0, 120, 192, 0, 0, 124,
  128, 0, 0, 61, 128, 0, 0, 63, 0, 0, 0, 30, 0, 0, 0, 15,
  0, 0, 0, 15, 0, 0, 0, 15, 128, 0, 0, 31, 128, 0, 0, 51,
  192, 0, 0, 51, 224, 0, 0, 97, 224, 0, 0, 193, 240, 0, 0, 192,
  240, 0, 1, 128, 248, 0, 3, 0, 120, 0, 3, 0, 124, 0, 6, 0,
  60, 0, 14, 0, 62, 0, 31, 0, 63, 0, 255, 225, 255, 240, 27, 29,
  116, 30, 2, 0, 255, 248, 127, 224, 15, 128, 31, 0, 15, 128, 14, 0,
  7, 128, 12, 0, 3, 192, 12, 0, 3, 192, 8, 0, 1, 224, 24, 0,
  1, 240, 16, 0, 0, 240, 48, 0, 0, 248, 32, 0, 0, 120, 96, 0,
  0, 60, 64, 0, 0, 60, 192, 0, 0, 30, 128, 0, 0, 31, 0, 0,
  0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0,
  0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0,
  0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0,
  0, 15, 0, 0, 1, 255, 248, 0, 22, 29, 87, 27, 3, 0, 63, 255,
  252, 62, 0, 120, 60, 0, 248, 56, 0, 240, 48, 1, 224, 48, 3, 224,
  96, 3, 192, 96, 7, 128, 64, 15, 128, 64, 15, 0, 0, 31, 0, 0,
  62, 0, 0, 60, 0, 0, 124, 0, 0, 120, 0, 0, 240, 0, 1, 240,
  0, 1, 224, 0, 3, 224, 4, 7, 192, 4, 7, 128, 12, 15, 128, 12,
  31, 0, 12, 31, 0, 28, 62, 0, 28, 60, 0, 60, 124, 0, 120, 248,
  0, 248, 255, 255, 248, 8, 37, 37, 16, 5, 248, 255, 240, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 240, 255,
  14, 38, 76, 18, 2, 248, 192, 0, 64, 0, 96, 0, 96, 0, 32, 0,
  48, 0, 48, 0, 16, 0, 24, 0, 24, 0, 8, 0, 12, 0, 12, 0,
  4, 0, 4, 0, 6, 0, 2, 0, 2, 0, 3, 0, 3, 0, 1, 0,
  1, 128, 1, 128, 0, 128, 0, 192, 0, 192, 0, 64, 0, 96, 0, 96,
  0, 32, 0, 48, 0, 48, 0, 16, 0, 24, 0, 24, 0, 8, 0, 12,
  0, 12, 8, 37, 37, 16, 3, 248, 255, 15, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 15, 255, 18, 14, 42,
  24, 3, 15, 0, 192, 0, 1, 192, 0, 1, 224, 0, 3, 48, 0, 3,
  48, 0, 6, 24, 0, 12, 12, 0, 12, 12, 0, 24, 6, 0, 48, 6,
  0, 48, 3, 0, 96, 1, 128, 224, 1, 128, 192, 0, 192, 21, 2, 6,
  21, 0, 250, 255, 255, 248, 255, 255, 248, 7, 7, 7, 18, 3, 21, 192,
  224, 112, 56, 24, 12, 2, 18, 19, 57, 21, 2, 0, 15, 192, 0, 56,
  112, 0, 32, 56, 0, 96, 28, 0, 120, 28, 0, 120, 28, 0, 56, 28,
  0, 0, 28, 0, 0, 252, 0, 15, 28, 0, 56, 28, 0, 112, 28, 0,
  224, 28, 0, 224, 28, 64, 224, 60, 64, 224, 60, 64, 224, 92, 192, 112,
  159, 128, 31, 15, 0, 18, 29, 87, 21, 1, 0, 252, 0, 0, 28, 0,
  0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0,
  28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 120, 0, 28, 142, 0, 29,
  7, 0, 30, 3, 128, 30, 3, 128, 28, 3, 128, 28, 3, 192, 28, 3,
  192, 28, 3, 192, 28, 3, 192, 28, 3, 192, 28, 3, 192, 28, 3, 192,
  28, 3, 128, 28, 3, 128, 30, 3, 128, 27, 7, 0, 17, 142, 0, 16,
  248, 0, 15, 19, 38, 18, 2, 0, 7, 224, 28, 16, 56, 8, 48, 12,
  112, 28, 112, 60, 240, 60, 240, 24, 240, 0, 240, 0, 240, 0, 240, 0,
  240, 6, 112, 4, 112, 4, 48, 12, 56, 8, 12, 48, 7, 224, 18, 29,
  87, 21, 2, 0, 0, 254, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0,
  0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0,
  14, 0, 15, 142, 0, 28, 78, 0, 56, 46, 0, 112, 30, 0, 112, 30,
  0, 112, 14, 0, 240, 14, 0, 240, 14, 0, 240, 14, 0, 240, 14, 0,
  240, 14, 0, 240, 14, 0, 240, 14, 0, 112, 14, 0, 112, 14, 0, 112,
  30, 0, 56, 62, 0, 24, 110, 0, 7, 207, 192, 15, 19, 38, 19, 2,
  0, 7, 192, 12, 112, 56, 56, 48, 28, 112, 28, 112, 28, 240, 30, 240,
  30, 255, 254, 240, 0, 240, 0, 240, 0, 240, 6, 112, 4, 112, 4, 56,
  4, 56, 8, 28, 16, 7, 224, 14, 29, 58, 14, 1, 0, 1, 240, 7,
  24, 14, 24, 12, 60, 28, 60, 28, 56, 28, 0, 28, 0, 28, 0, 28,
  0, 255, 192, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 255, 192, 20, 28, 84, 22, 2, 247, 7, 225, 192,
  28, 58, 96, 56, 30, 240, 112, 30, 240, 112, 14, 224, 240, 15, 0, 240,
  15, 0, 240, 15, 0, 112, 14, 0, 112, 30, 0, 56, 28, 0, 28, 56,
  0, 7, 224, 0, 56, 0, 0, 64, 0, 0, 192, 0, 0, 240, 0, 0,
  255, 254, 0, 63, 255, 0, 15, 7, 128, 112, 1, 192, 64, 0, 192, 192,
  0, 192, 192, 0, 192, 192, 1, 128, 96, 1, 128, 56, 6, 0, 7, 248,
  0, 20, 29, 87, 22, 1, 0, 252, 0, 0, 28, 0, 0, 28, 0, 0,
  28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28,
  0, 0, 28, 0, 0, 28, 60, 0, 28, 199, 0, 29, 3, 0, 29, 3,
  128, 30, 3, 128, 30, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128,
  28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28,
  3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 255, 159, 240, 8, 28,
  28, 11, 1, 0, 24, 60, 60, 24, 0, 0, 0, 0, 0, 252, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 255,
  11, 37, 74, 14, 255, 247, 0, 192, 1, 224, 1, 224, 0, 192, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 15, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 224, 224, 240, 224, 224, 192, 193, 128, 99, 128, 62, 0,
  19, 29, 87, 21, 1, 0, 252, 0, 0, 28, 0, 0, 28, 0, 0, 28,
  0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 0, 28, 63, 192, 28, 14, 0, 28, 12, 0, 28, 8, 0,
  28, 16, 0, 28, 48, 0, 28, 96, 0, 28, 192, 0, 28, 224, 0, 29,
  224, 0, 30, 240, 0, 30, 120, 0, 28, 60, 0, 28, 60, 0, 28, 30,
  0, 28, 15, 0, 28, 15, 0, 28, 15, 128, 255, 63, 224, 9, 29, 58,
  11, 1, 0, 252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 255, 128, 31, 19, 76,
  33, 1, 0, 252, 124, 15, 128, 28, 199, 24, 192, 29, 7, 32, 224, 31,
  3, 224, 112, 30, 3, 192, 112, 28, 3, 128, 112, 28, 3, 128, 112, 28,
  3, 128, 112, 28, 3, 128, 112, 28, 3, 128, 112, 28, 3, 128, 112, 28,
  3, 128, 112, 28, 3, 128, 112, 28, 3, 128, 112, 28, 3, 128, 112, 28,
  3, 128, 112, 28, 3, 128, 112, 28, 3, 128, 112, 255, 159, 243, 254, 20,
  19, 57, 22, 1, 0, 252, 60, 0, 28, 199, 0, 29, 3, 0, 31, 3,
  128, 30, 3, 128, 30, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128,
  28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28,
  3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 255, 159, 240, 17, 19,
  57, 21, 2, 0, 3, 224, 0, 12, 56, 0, 24, 28, 0, 56, 14, 0,
  112, 14, 0, 112, 7, 0, 240, 7, 0, 240, 7, 0, 240, 7, 128, 240,
  7, 128, 240, 7, 128, 240, 7, 0, 240, 7, 0, 112, 7, 0, 112, 14,
  0, 56, 14, 0, 24, 28, 0, 12, 56, 0, 3, 224, 0, 18, 28, 84,
  21, 1, 247, 252, 120, 0, 29, 142, 0, 31, 7, 0, 30, 3, 128, 30,
  3, 128, 28, 3, 128, 28, 3, 192, 28, 3, 192, 28, 3, 192, 28, 3,
  192, 28, 3, 192, 28, 3, 192, 28, 3, 192, 28, 3, 128, 28, 3, 128,
  30, 3, 128, 31, 7, 0, 29, 134, 0, 28, 120, 0, 28, 0, 0, 28,
  0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 0, 255, 128, 0, 18, 28, 84, 21, 2, 247, 7, 130, 0,
  28, 98, 0, 56, 54, 0, 112, 22, 0, 112, 30, 0, 112, 14, 0, 240,
  14, 0, 240, 14, 0, 240, 14, 0, 240, 14, 0, 240, 14, 0, 240, 14,
  0, 240, 14, 0, 112, 14, 0, 112, 14, 0, 112, 30, 0, 56, 62, 0,
  24, 110, 0, 7, 206, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0,
  14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 127,
  192, 15, 19, 38, 16, 1, 0, 252, 56, 28, 196, 28, 142, 29, 30, 31,
  28, 30, 12, 30, 0, 30, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 255, 128, 14, 19, 38,
  18, 2, 0, 31, 16, 96, 208, 64, 112, 192, 48, 192, 16, 224, 16, 240,
  0, 126, 0, 63, 128, 31, 224, 3, 248, 128, 252, 192, 28, 192, 12, 224,
  12, 224, 12, 240, 8, 140, 24, 131, 224, 12, 27, 54, 14, 1, 0, 4,
  0, 4, 0, 4, 0, 4, 0, 4, 0, 12, 0, 12, 0, 28, 0, 255,
  224, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 16, 28, 16, 28, 16, 28, 48, 30,
  32, 15, 224, 7, 192, 20, 19, 57, 22, 1, 0, 252, 31, 128, 28, 3,
  128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128,
  28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28,
  3, 128, 28, 7, 128, 28, 7, 128, 28, 15, 128, 12, 11, 128, 14, 51,
  128, 3, 195, 240, 20, 19, 57, 21, 1, 0, 255, 15, 240, 60, 3, 128,
  28, 3, 0, 28, 3, 0, 14, 2, 0, 14, 2, 0, 15, 6, 0, 7,
  4, 0, 7, 4, 0, 3, 140, 0, 3, 136, 0, 3, 200, 0, 1, 216,
  0, 1, 208, 0, 0, 240, 0, 0, 240, 0, 0, 96, 0, 0, 96, 0,
  0, 96, 0, 30, 19, 76, 31, 1, 0, 255, 31, 243, 252, 60, 7, 128,
  224, 28, 3, 128, 192, 28, 3, 128, 192, 14, 3, 192, 128, 14, 3, 192,
  128, 15, 7, 193, 128, 7, 5, 225, 0, 7, 4, 225, 0, 3, 140, 227,
  0, 3, 136, 114, 0, 1, 200, 114, 0, 1, 216, 118, 0, 1, 240, 60,
  0, 0, 240, 60, 0, 0, 240, 60, 0, 0, 96, 24, 0, 0, 96, 24,
  0, 0, 32, 24, 0, 18, 19, 57, 21, 1, 0, 255, 31, 192, 30, 14,
  0, 30, 12, 0, 14, 8, 0, 15, 24, 0, 7, 16, 0, 3, 160, 0,
  3, 224, 0, 1, 192, 0, 1, 224, 0, 1, 224, 0, 1, 112, 0, 3,
  120, 0, 2, 56, 0, 4, 28, 0, 12, 28, 0, 24, 14, 0, 24, 15,
  0, 254, 63, 192, 20, 28, 84, 22, 1, 247, 255, 143, 240, 30, 1, 128,
  30, 1, 128, 14, 1, 0, 14, 1, 0, 15, 3, 0, 7, 2, 0, 7,
  2, 0, 3, 134, 0, 3, 132, 0, 3, 132, 0, 1, 204, 0, 1, 200,
  0, 1, 200, 0, 0, 248, 0, 0, 240, 0, 0, 240, 0, 0, 112, 0,
  0, 96, 0, 0, 96, 0, 0, 96, 0, 0, 64, 0, 48, 64, 0, 120,
  192, 0, 120, 128, 0, 113, 128, 0, 51, 0, 0, 30, 0, 0, 14, 19,
  38, 18, 2, 0, 255, 252, 224, 60, 192, 56, 192, 120, 128, 240, 128, 224,
  129, 224, 1, 192, 3, 128, 7, 128, 7, 0, 15, 0, 30, 4, 28, 4,
  60, 4, 56, 12, 112, 12, 240, 28, 255, 252, 10, 37, 74, 17, 4, 248,
  1, 192, 6, 0, 12, 0, 8, 0, 24, 0, 24, 0, 24, 0, 28, 0,
  28, 0, 12, 0, 14, 0, 14, 0, 14, 0, 6, 0, 6, 0, 6, 0,
  4, 0, 8, 0, 240, 0, 24, 0, 12, 0, 4, 0, 6, 0, 6, 0,
  14, 0, 14, 0, 14, 0, 12, 0, 28, 0, 28, 0, 24, 0, 24, 0,
  24, 0, 8, 0, 12, 0, 6, 0, 1, 192, 2, 38, 38, 12, 5, 248,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 10, 37, 74, 17, 3, 248, 224, 0, 24, 0,
  12, 0, 4, 0, 6, 0, 6, 0, 6, 0, 14, 0, 14, 0, 12, 0,
  28, 0, 28, 0, 28, 0, 24, 0, 24, 0, 24, 0, 8, 0, 4, 0,
  3, 192, 6, 0, 8, 0, 24, 0, 24, 0, 24, 0, 28, 0, 28, 0,
  28, 0, 12, 0, 14, 0, 14, 0, 6, 0, 6, 0, 6, 0, 4, 0,
  12, 0, 24, 0, 224, 0, 23, 8, 24, 27, 2, 7, 30, 0, 8, 127,
  192, 4, 255, 240, 2, 199, 254, 2, 128, 255, 134, 128, 63, 254, 192, 15,
  252, 96, 1, 248, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 0, 0, 0, 11, 0, 0, 5, 28, 28, 11, 3,
  247, 112, 248, 248, 248, 112, 0, 32, 32, 32, 32, 32, 32, 112, 112, 112,
  112, 112, 112, 112, 112, 248, 248, 248, 248, 248, 248, 248, 112, 14, 28, 56,
  24, 5, 252, 0, 128, 0, 128, 0, 128, 0, 128, 0, 128, 7, 224, 12,
  152, 24, 136, 56, 140, 112, 156, 112, 188, 240, 188, 240, 152, 240, 128, 240,
  128, 240, 128, 240, 128, 240, 132, 112, 132, 112, 132, 56, 132, 24, 136, 14,
  144, 3, 224, 0, 128, 0, 128, 0, 128, 0, 128, 23, 28, 84, 30, 3,
  0, 0, 3, 240, 0, 6, 24, 0, 28, 12, 0, 24, 14, 0, 48, 62,
  0, 112, 62, 0, 112, 62, 0, 112, 24, 0, 112, 0, 0, 240, 0, 0,
  240, 0, 0, 240, 0, 31, 240, 0, 32, 255, 128, 0, 240, 0, 0, 240,
  0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 224, 0,
  0, 224, 0, 62, 224, 2, 67, 192, 2, 128, 224, 4, 129, 127, 60, 194,
  63, 248, 60, 15, 240, 20, 20, 60, 24, 2, 4, 64, 0, 32, 225, 248,
  112, 119, 254, 224, 62, 7, 192, 24, 1, 128, 48, 0, 192, 48, 0, 192,
  96, 0, 96, 96, 0, 96, 96, 0, 96, 96, 0, 96, 96, 0, 96, 96,
  0, 96, 48, 0, 192, 48, 0, 192, 24, 1, 128, 62, 7, 192, 119, 254,
  224, 225, 248, 112, 64, 0, 32, 22, 28, 84, 24, 1, 0, 255, 131, 252,
  62, 0, 112, 30, 0, 96, 14, 0, 64, 15, 0, 64, 15, 0, 128, 7,
  128, 128, 7, 129, 0, 3, 193, 0, 3, 194, 0, 1, 226, 0, 1, 228,
  0, 0, 252, 0, 0, 248, 0, 0, 120, 0, 31, 255, 192, 0, 120, 0,
  0, 120, 0, 31, 255, 192, 0, 120, 0, 0, 120, 0, 0, 120, 0, 0,
  120, 0, 0, 120, 0, 0, 120, 0, 0, 120, 0, 0, 120, 0, 7, 255,
  128, 2, 37, 37, 12, 5, 249, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 0, 0, 0, 0, 0, 0, 0, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 15, 36, 72, 26,
  4, 248, 7, 192, 12, 32, 24, 48, 48, 120, 48, 120, 48, 112, 56, 0,
  56, 0, 28, 0, 30, 0, 15, 0, 31, 192, 35, 224, 97, 240, 64, 248,
  192, 60, 192, 30, 192, 14, 224, 6, 240, 6, 120, 6, 60, 4, 31, 12,
  15, 152, 7, 224, 3, 224, 0, 224, 0, 112, 0, 112, 0, 56, 56, 56,
  60, 56, 56, 48, 48, 48, 24, 96, 7, 128, 12, 4, 8, 18, 3, 22,
  96, 96, 240, 240, 240, 240, 96, 96, 30, 29, 116, 34, 2, 1, 0, 127,
  248, 0, 1, 192, 14, 0, 3, 0, 3, 0, 4, 0, 0, 128, 8, 0,
  0, 64, 16, 7, 196, 32, 32, 24, 108, 16, 32, 48, 60, 16, 64, 112,
  28, 8, 64, 224, 12, 8, 192, 224, 12, 8, 129, 224, 4, 4, 129, 224,
  0, 4, 129, 224, 0, 4, 129, 224, 0, 4, 129, 224, 0, 4, 129, 224,
  0, 4, 129, 224, 4, 4, 192, 224, 4, 8, 64, 224, 8, 8, 64, 112,
  8, 8, 32, 112, 24, 16, 48, 24, 48, 48, 16, 15, 192, 32, 8, 0,
  0, 64, 4, 0, 0, 128, 3, 0, 3, 0, 1, 192, 14, 0, 0, 127,
  248, 0, 11, 14, 28, 16, 3, 14, 60, 0, 102, 0, 67, 0, 99, 0,
  99, 0, 7, 0, 27, 0, 99, 0, 195, 0, 195, 32, 231, 32, 121, 192,
  0, 0, 127, 192, 10, 16, 32, 19, 4, 1, 24, 64, 48, 192, 32, 128,
  97, 128, 97, 0, 195, 0, 195, 0, 195, 0, 195, 0, 195, 0, 195, 0,
  97, 128, 97, 128, 48, 128, 16, 64, 8, 0, 20, 8, 24, 24, 2, 7,
  255, 255, 240, 255, 255, 240, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0,
  0, 48, 0, 0, 48, 0, 0, 48, 10, 2, 4, 14, 2, 9, 255, 192,
  255, 192, 30, 29, 116, 34, 2, 1, 0, 127, 248, 0, 1, 192, 14, 0,
  3, 0, 3, 0, 4, 0, 0, 128, 8, 0, 0, 64, 19, 255, 192, 32,
  32, 112, 240, 48, 32, 112, 120, 16, 64, 112, 120, 8, 64, 112, 120, 8,
  192, 112, 120, 8, 128, 112, 112, 4, 128, 112, 224, 4, 128, 127, 128, 4,
  128, 112, 224, 4, 128, 112, 112, 4, 128, 112, 112, 4, 128, 112, 120, 4,
  128, 112, 120, 8, 64, 112, 120, 136, 64, 112, 120, 136, 32, 112, 56, 144,
  32, 112, 57, 16, 19, 252, 30, 32, 8, 0, 0, 64, 4, 0, 0, 128,
  3, 0, 3, 0, 1, 192, 14, 0, 0, 127, 248, 0, 11, 2, 4, 19,
  4, 23, 255, 224, 255, 224, 11, 10, 20, 23, 6, 18, 31, 0, 96, 128,
  64, 64, 128, 32, 128, 32, 128, 32, 128, 32, 64, 64, 96, 128, 31, 0,
  35, 28, 140, 39, 2, 254, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0,
  0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0,
  0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0,
  192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 255, 255, 255,
  255, 224, 255, 255, 255, 255, 224, 0, 0, 192, 0, 0, 0, 0, 192, 0,
  0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0,
  0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0,
  0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 192, 255, 255, 255,
  255, 192, 11, 17, 34, 18, 4, 11, 31, 0, 99, 192, 129, 192, 128, 224,
  192, 224, 224, 224, 112, 224, 1, 192, 1, 128, 3, 0, 12, 0, 24, 0,
  32, 32, 64, 32, 64, 96, 255, 224, 255, 224, 11, 17, 34, 18, 5, 11,
  31, 0, 97, 192, 192, 192, 224, 224, 240, 224, 0, 224, 0, 192, 97, 128,
  126, 0, 1, 128, 0, 192, 0, 224, 224, 224, 240, 224, 224, 192, 129, 192,
  127, 0, 7, 7, 7, 18, 8, 21, 6, 14, 28, 56, 48, 96, 128, 21,
  30, 90, 25, 3, 245, 96, 6, 0, 224, 15, 0, 240, 15, 0, 240, 15,
  0, 240, 15, 0, 224, 15, 0, 224, 15, 0, 224, 15, 0, 224, 15, 0,
  224, 15, 0, 224, 6, 0, 64, 6, 0, 64, 6, 0, 64, 6, 0, 96,
  12, 8, 96, 14, 24, 88, 57, 248, 79, 241, 248, 67, 224, 112, 192, 0,
  0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 224, 0, 0,
  224, 0, 0, 240, 0, 0, 240, 0, 0, 112, 0, 0, 112, 0, 0, 17,
  35, 105, 23, 3, 250, 15, 255, 128, 63, 140, 0, 127, 140, 0, 127, 140,
  0, 255, 140, 0, 255, 140, 0, 255, 140, 0, 255, 140, 0, 255, 140, 0,
  127, 140, 0, 127, 140, 0, 63, 140, 0, 7, 140, 0, 1, 140, 0, 1,
  140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140,
  0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0,
  1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1,
  140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 1, 140, 0, 5, 5,
  5, 11, 3, 10, 112, 248, 248, 248, 112, 8, 8, 8, 18, 5, 248, 48,
  32, 60, 6, 7, 7, 15, 252, 9, 17, 34, 19, 5, 11, 4, 0, 12,
  0, 28, 0, 252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 255, 128, 10,
  14, 28, 16, 3, 14, 30, 0, 51, 0, 97, 128, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 193, 192, 97, 128, 35, 0, 30, 0, 0, 0, 255,
  192, 10, 16, 32, 20, 5, 1, 134, 0, 195, 0, 65, 0, 97, 128, 32,
  192, 48, 192, 48, 192, 48, 192, 48, 192, 48, 192, 48, 192, 97, 128, 97,
  128, 67, 0, 130, 0, 4, 0, 27, 28, 112, 35, 5, 0, 4, 0, 12,
  0, 12, 0, 8, 0, 28, 0, 24, 0, 252, 0, 16, 0, 28, 0, 32,
  0, 28, 0, 96, 0, 28, 0, 64, 0, 28, 0, 192, 0, 28, 0, 128,
  0, 28, 1, 128, 0, 28, 3, 0, 0, 28, 2, 0, 0, 28, 6, 7,
  0, 28, 4, 15, 0, 28, 12, 15, 0, 28, 24, 23, 0, 255, 144, 23,
  0, 0, 48, 39, 0, 0, 32, 71, 0, 0, 96, 71, 0, 0, 192, 135,
  0, 0, 129, 7, 0, 1, 129, 255, 224, 1, 0, 7, 0, 3, 0, 7,
  0, 6, 0, 7, 0, 6, 0, 7, 0, 12, 0, 63, 224, 27, 28, 112,
  35, 5, 0, 4, 0, 4, 0, 12, 0, 12, 0, 28, 0, 8, 0, 252,
  0, 16, 0, 28, 0, 48, 0, 28, 0, 32, 0, 28, 0, 96, 0, 28,
  0, 64, 0, 28, 0, 128, 0, 28, 1, 128, 0, 28, 1, 0, 0, 28,
  3, 31, 0, 28, 6, 99, 192, 28, 4, 129, 192, 28, 12, 128, 224, 28,
  8, 192, 224, 255, 152, 224, 224, 0, 48, 240, 224, 0, 32, 1, 192, 0,
  96, 1, 128, 0, 64, 3, 0, 0, 192, 12, 0, 1, 128, 24, 0, 1,
  0, 32, 32, 3, 0, 64, 32, 2, 0, 64, 96, 6, 0, 255, 224, 12,
  0, 255, 224, 28, 28, 112, 36, 5, 0, 31, 0, 6, 0, 97, 192, 4,
  0, 192, 224, 8, 0, 224, 224, 24, 0, 240, 224, 16, 0, 0, 192, 48,
  0, 1, 128, 96, 0, 126, 0, 64, 0, 97, 128, 192, 0, 0, 192, 128,
  0, 0, 225, 128, 0, 96, 227, 3, 128, 240, 226, 3, 128, 224, 230, 7,
  128, 129, 196, 7, 128, 67, 136, 11, 128, 62, 24, 19, 128, 0, 16, 19,
  128, 0, 48, 35, 128, 0, 96, 99, 128, 0, 64, 67, 128, 0, 192, 131,
  128, 0, 128, 255, 240, 1, 128, 3, 128, 3, 0, 3, 128, 2, 0, 3,
  128, 6, 0, 3, 128, 4, 0, 31, 240, 15, 28, 56, 19, 1, 247, 3,
  128, 7, 192, 7, 192, 7, 192, 3, 128, 0, 0, 3, 128, 4, 64, 8,
  32, 8, 32, 8, 96, 0, 96, 0, 192, 1, 128, 7, 0, 14, 0, 28,
  0, 56, 0, 120, 0, 240, 60, 240, 62, 240, 62, 240, 6, 240, 6, 112,
  6, 120, 12, 28, 24, 7, 224, 29, 38, 152, 32, 2, 0, 0, 224, 0,
  0, 0, 240, 0, 0, 0, 112, 0, 0, 0, 56, 0, 0, 0, 12, 0,
  0, 0, 6, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 2, 0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0, 7, 0,
  0, 0, 15, 128, 0, 0, 15, 128, 0, 0, 15, 128, 0, 0, 31, 192,
  0, 0, 19, 192, 0, 0, 51, 192, 0, 0, 49, 224, 0, 0, 33, 224,
  0, 0, 97, 224, 0, 0, 96, 240, 0, 0, 64, 240, 0, 0, 192, 240,
  0, 0, 192, 120, 0, 0, 128, 120, 0, 1, 128, 120, 0, 1, 255, 252,
  0, 1, 0, 60, 0, 3, 0, 28, 0, 3, 0, 30, 0, 6, 0, 30,
  0, 6, 0, 15, 0, 6, 0, 15, 0, 14, 0, 15, 0, 30, 0, 15,
  128, 255, 224, 255, 248, 29, 38, 152, 32, 2, 0, 0, 0, 48, 0, 0,
  0, 112, 0, 0, 0, 240, 0, 0, 0, 224, 0, 0, 1, 128, 0, 0,
  3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  2, 0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0, 7, 0, 0, 0,
  15, 128, 0, 0, 15, 128, 0, 0, 15, 128, 0, 0, 31, 192, 0, 0,
  19, 192, 0, 0, 51, 192, 0, 0, 49, 224, 0, 0, 33, 224, 0, 0,
  97, 224, 0, 0, 96, 240, 0, 0, 64, 240, 0, 0, 192, 240, 0, 0,
  192, 120, 0, 0, 128, 120, 0, 1, 128, 120, 0, 1, 255, 252, 0, 3,
  0, 60, 0, 3, 0, 30, 0, 3, 0, 30, 0, 6, 0, 30, 0, 6,
  0, 15, 0, 6, 0, 15, 0, 14, 0, 15, 0, 31, 0, 31, 192, 255,
  224, 255, 248, 29, 38, 152, 32, 2, 0, 0, 6, 0, 0, 0, 7, 0,
  0, 0, 15, 128, 0, 0, 29, 128, 0, 0, 56, 192, 0, 0, 96, 48,
  0, 0, 128, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0,
  0, 0, 6, 0, 0, 0, 7, 0, 0, 0, 7, 0, 0, 0, 15, 128,
  0, 0, 15, 128, 0, 0, 15, 128, 0, 0, 31, 192, 0, 0, 19, 192,
  0, 0, 51, 192, 0, 0, 49, 224, 0, 0, 33, 224, 0, 0, 97, 224,
  0, 0, 96, 240, 0, 0, 64, 240, 0, 0, 192, 240, 0, 0, 192, 120,
  0, 0, 128, 120, 0, 1, 128, 120, 0, 1, 255, 252, 0, 1, 0, 60,
  0, 3, 0, 28, 0, 3, 0, 30, 0, 6, 0, 30, 0, 6, 0, 15,
  0, 6, 0, 15, 0, 14, 0, 15, 0, 30, 0, 15, 128, 255, 224, 255,
  248, 29, 37, 148, 32, 2, 0, 0, 60, 8, 0, 0, 127, 24, 0, 0,
  207, 240, 0, 0, 129, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 6, 0, 0, 0,
  7, 0, 0, 0, 7, 0, 0, 0, 15, 128, 0, 0, 15, 128, 0, 0,
  15, 128, 0, 0, 31, 192, 0, 0, 19, 192, 0, 0, 51, 192, 0, 0,
  49, 224, 0, 0, 33, 224, 0, 0, 97, 224, 0, 0, 96, 240, 0, 0,
  64, 240, 0, 0, 192, 240, 0, 0, 192, 120, 0, 0, 128, 120, 0, 1,
  128, 120, 0, 1, 255, 252, 0, 3, 0, 60, 0, 3, 0, 30, 0, 3,
  0, 30, 0, 6, 0, 30, 0, 6, 0, 15, 0, 6, 0, 15, 0, 14,
  0, 15, 0, 31, 0, 31, 192, 255, 224, 255, 248, 29, 37, 148, 32, 2,
  0, 0, 96, 48, 0, 0, 240, 120, 0, 0, 240, 120, 0, 0, 96, 48,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 2, 0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0, 7, 0,
  0, 0, 15, 128, 0, 0, 15, 128, 0, 0, 31, 128, 0, 0, 31, 192,
  0, 0, 19, 192, 0, 0, 51, 192, 0, 0, 49, 224, 0, 0, 33, 224,
  0, 0, 97, 224, 0, 0, 96, 240, 0, 0, 64, 240, 0, 0, 192, 112,
  0, 0, 192, 120, 0, 0, 128, 120, 0, 1, 128, 56, 0, 1, 255, 252,
  0, 1, 0, 28, 0, 3, 0, 28, 0, 3, 0, 30, 0, 6, 0, 30,
  0, 6, 0, 15, 0, 6, 0, 15, 0, 14, 0, 15, 0, 31, 0, 15,
  128, 255, 224, 255, 248, 29, 39, 156, 32, 2, 0, 0, 15, 0, 0, 0,
  16, 128, 0, 0, 32, 64, 0, 0, 32, 64, 0, 0, 32, 64, 0, 0,
  32, 64, 0, 0, 16, 128, 0, 0, 15, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 2, 0, 0, 0, 6, 0, 0, 0, 7, 0, 0, 0,
  7, 0, 0, 0, 15, 128, 0, 0, 15, 128, 0, 0, 31, 128, 0, 0,
  31, 192, 0, 0, 19, 192, 0, 0, 51, 192, 0, 0, 51, 224, 0, 0,
  33, 224, 0, 0, 97, 224, 0, 0, 97, 240, 0, 0, 64, 240, 0, 0,
  192, 240, 0, 0, 192, 248, 0, 0, 128, 120, 0, 1, 128, 120, 0, 1,
  255, 252, 0, 1, 0, 60, 0, 3, 0, 60, 0, 2, 0, 62, 0, 6,
  0, 30, 0, 6, 0, 31, 0, 6, 0, 31, 0, 14, 0, 15, 0, 30,
  0, 15, 128, 255, 224, 255, 248, 37, 29, 145, 41, 1, 0, 0, 3, 255,
  255, 248, 0, 0, 124, 0, 248, 0, 0, 124, 0, 56, 0, 0, 124, 0,
  56, 0, 0, 252, 0, 24, 0, 1, 188, 0, 24, 0, 1, 188, 0, 8,
  0, 3, 60, 0, 8, 0, 3, 60, 4, 8, 0, 6, 60, 4, 0, 0,
  6, 60, 4, 0, 0, 12, 60, 4, 0, 0, 12, 60, 12, 0, 0, 24,
  60, 28, 0, 0, 24, 63, 252, 0, 0, 48, 60, 28, 0, 0, 48, 60,
  12, 0, 0, 96, 60, 4, 0, 0, 96, 60, 4, 8, 0, 255, 252, 4,
  8, 0, 128, 60, 4, 8, 1, 128, 60, 0, 8, 1, 0, 60, 0, 24,
  3, 0, 60, 0, 24, 2, 0, 60, 0, 24, 6, 0, 60, 0, 56, 14,
  0, 60, 0, 120, 31, 0, 60, 1, 248, 255, 225, 255, 255, 248, 22, 38,
  114, 28, 3, 248, 1, 255, 12, 7, 1, 140, 14, 0, 252, 28, 0, 124,
  24, 0, 60, 56, 0, 60, 56, 0, 28, 112, 0, 28, 112, 0, 12, 112,
  0, 12, 240, 0, 8, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0,
  0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 112, 0, 4,
  112, 0, 4, 120, 0, 12, 56, 0, 8, 56, 0, 8, 28, 0, 16, 12,
  0, 16, 14, 0, 32, 3, 0, 192, 1, 247, 128, 0, 56, 0, 0, 32,
  0, 0, 56, 0, 0, 14, 0, 0, 7, 0, 0, 7, 0, 0, 7, 0,
  1, 14, 0, 0, 252, 0, 23, 38, 114, 29, 3, 0, 1, 128, 0, 1,
  192, 0, 1, 224, 0, 0, 224, 0, 0, 48, 0, 0, 24, 0, 0, 12,
  0, 0, 0, 0, 0, 0, 0, 255, 255, 254, 15, 0, 62, 15, 0, 14,
  15, 0, 14, 15, 0, 6, 15, 0, 6, 15, 0, 2, 15, 0, 2, 15,
  1, 2, 15, 1, 0, 15, 1, 0, 15, 1, 0, 15, 3, 0, 15, 7,
  0, 15, 255, 0, 15, 7, 0, 15, 3, 0, 15, 1, 0, 15, 1, 2,
  15, 1, 2, 15, 1, 2, 15, 0, 2, 15, 0, 6, 15, 0, 6, 15,
  0, 6, 15, 0, 14, 15, 0, 30, 15, 0, 126, 255, 255, 254, 23, 38,
  114, 29, 3, 0, 0, 0, 192, 0, 1, 224, 0, 3, 192, 0, 3, 128,
  0, 6, 0, 0, 12, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 255,
  255, 254, 15, 0, 62, 15, 0, 14, 15, 0, 14, 15, 0, 6, 15, 0,
  6, 15, 0, 2, 15, 0, 2, 15, 1, 2, 15, 1, 0, 15, 1, 0,
  15, 1, 0, 15, 3, 0, 15, 7, 0, 15, 255, 0, 15, 7, 0, 15,
  3, 0, 15, 1, 0, 15, 1, 2, 15, 1, 2, 15, 1, 2, 15, 0,
  2, 15, 0, 6, 15, 0, 6, 15, 0, 6, 15, 0, 14, 15, 0, 30,
  15, 0, 126, 255, 255, 254, 23, 38, 114, 29, 3, 0, 0, 8, 0, 0,
  28, 0, 0, 62, 0, 0, 55, 0, 0, 99, 128, 1, 128, 192, 2, 0,
  32, 0, 0, 0, 0, 0, 0, 255, 255, 254, 15, 0, 62, 15, 0, 14,
  15, 0, 14, 15, 0, 6, 15, 0, 6, 15, 0, 2, 15, 0, 2, 15,
  1, 2, 15, 1, 0, 15, 1, 0, 15, 1, 0, 15, 3, 0, 15, 7,
  0, 15, 255, 0, 15, 7, 0, 15, 3, 0, 15, 1, 0, 15, 1, 2,
  15, 1, 2, 15, 1, 2, 15, 0, 2, 15, 0, 6, 15, 0, 6, 15,
  0, 6, 15, 0, 14, 15, 0, 30, 15, 0, 126, 255, 255, 254, 23, 37,
  111, 29, 3, 0, 1, 128, 192, 3, 193, 224, 3, 193, 224, 1, 128, 192,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 254, 15,
  0, 62, 15, 0, 14, 15, 0, 14, 15, 0, 6, 15, 0, 6, 15, 0,
  2, 15, 0, 2, 15, 1, 2, 15, 1, 0, 15, 1, 0, 15, 3, 0,
  15, 3, 0, 15, 7, 0, 15, 255, 0, 15, 7, 0, 15, 3, 0, 15,
  3, 0, 15, 1, 2, 15, 1, 2, 15, 1, 2, 15, 0, 2, 15, 0,
  6, 15, 0, 6, 15, 0, 6, 15, 0, 14, 15, 0, 30, 15, 0, 126,
  255, 255, 254, 12, 38, 76, 17, 3, 0, 192, 0, 224, 0, 112, 0, 56,
  0, 24, 0, 12, 0, 2, 0, 0, 0, 0, 0, 255, 240, 15, 0, 15,
  0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 255, 240, 12, 38, 76, 17, 3, 0, 0, 48, 0, 112, 0,
  224, 1, 192, 3, 128, 2, 0, 4, 0, 0, 0, 0, 0, 255, 240, 15,
  0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 0, 255, 240, 12, 38, 76, 17, 3, 0, 6, 0, 14,
  0, 15, 0, 27, 128, 48, 192, 96, 96, 128, 16, 0, 0, 0, 0, 255,
  240, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 0, 15, 0, 255, 240, 12, 37, 74, 15, 2, 0, 96,
  96, 240, 240, 240, 240, 96, 96, 0, 0, 0, 0, 0, 0, 0, 0, 255,
  240, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15,
  0, 15, 0, 15, 0, 15, 0, 255, 240, 27, 29, 116, 32, 3, 0, 255,
  255, 192, 0, 15, 0, 112, 0, 15, 0, 28, 0, 15, 0, 14, 0, 15,
  0, 7, 0, 15, 0, 7, 128, 15, 0, 3, 128, 15, 0, 3, 192, 15,
  0, 3, 192, 15, 0, 1, 192, 15, 0, 1, 224, 15, 0, 1, 224, 15,
  0, 1, 224, 255, 240, 1, 224, 15, 0, 1, 224, 15, 0, 1, 224, 15,
  0, 1, 224, 15, 0, 1, 224, 15, 0, 1, 224, 15, 0, 3, 192, 15,
  0, 3, 192, 15, 0, 3, 192, 15, 0, 3, 128, 15, 0, 7, 0, 15,
  0, 7, 0, 15, 0, 14, 0, 15, 0, 28, 0, 15, 0, 112, 0, 255,
  255, 192, 0, 28, 37, 148, 32, 3, 0, 0, 60, 8, 0, 0, 127, 152,
  0, 0, 71, 240, 0, 0, 65, 240, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 63, 240, 15, 128, 7,
  128, 15, 128, 3, 0, 15, 192, 3, 0, 15, 224, 3, 0, 13, 224, 3,
  0, 13, 240, 3, 0, 12, 248, 3, 0, 12, 120, 3, 0, 12, 124, 3,
  0, 12, 60, 3, 0, 12, 30, 3, 0, 12, 31, 3, 0, 12, 15, 3,
  0, 12, 7, 131, 0, 12, 7, 131, 0, 12, 3, 195, 0, 12, 3, 227,
  0, 12, 1, 227, 0, 12, 0, 243, 0, 12, 0, 251, 0, 12, 0, 123,
  0, 12, 0, 63, 0, 12, 0, 63, 0, 12, 0, 31, 0, 12, 0, 31,
  0, 12, 0, 15, 0, 30, 0, 7, 0, 255, 192, 7, 0, 24, 38, 114,
  29, 3, 1, 3, 128, 0, 3, 192, 0, 1, 192, 0, 0, 224, 0, 0,
  112, 0, 0, 48, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 255,
  0, 3, 0, 192, 6, 0, 96, 12, 0, 48, 28, 0, 56, 56, 0, 28,
  56, 0, 28, 120, 0, 30, 112, 0, 14, 112, 0, 14, 240, 0, 15, 240,
  0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0,
  15, 240, 0, 15, 240, 0, 15, 112, 0, 14, 112, 0, 14, 120, 0, 30,
  56, 0, 28, 56, 0, 28, 28, 0, 56, 12, 0, 48, 6, 0, 96, 3,
  0, 192, 0, 255, 0, 24, 38, 114, 29, 3, 1, 0, 1, 192, 0, 3,
  192, 0, 3, 128, 0, 7, 0, 0, 14, 0, 0, 12, 0, 0, 16, 0,
  0, 0, 0, 0, 0, 0, 0, 255, 0, 3, 0, 192, 6, 0, 96, 12,
  0, 48, 28, 0, 56, 56, 0, 28, 56, 0, 28, 120, 0, 30, 112, 0,
  14, 112, 0, 14, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15,
  240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 112,
  0, 14, 112, 0, 14, 120, 0, 30, 56, 0, 28, 56, 0, 28, 28, 0,
  56, 12, 0, 48, 6, 0, 96, 3, 0, 192, 0, 255, 0, 24, 38, 114,
  29, 3, 0, 0, 24, 0, 0, 24, 0, 0, 60, 0, 0, 126, 0, 0,
  195, 0, 1, 129, 128, 6, 0, 96, 0, 0, 0, 0, 0, 0, 0, 255,
  0, 3, 0, 192, 6, 0, 96, 12, 0, 48, 28, 0, 56, 56, 0, 28,
  56, 0, 28, 120, 0, 30, 112, 0, 14, 112, 0, 14, 240, 0, 15, 240,
  0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0,
  15, 240, 0, 15, 240, 0, 15, 112, 0, 14, 112, 0, 14, 120, 0, 30,
  56, 0, 28, 56, 0, 28, 28, 0, 56, 12, 0, 48, 6, 0, 96, 3,
  0, 192, 0, 255, 0, 24, 37, 111, 29, 3, 0, 1, 240, 32, 3, 252,
  64, 2, 63, 192, 2, 7, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 255, 0, 3, 0, 192, 6, 0, 96, 12, 0, 48, 28,
  0, 56, 56, 0, 28, 56, 0, 28, 120, 0, 30, 112, 0, 14, 112, 0,
  14, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15,
  240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 112, 0, 14, 112,
  0, 14, 120, 0, 30, 56, 0, 28, 56, 0, 28, 28, 0, 56, 12, 0,
  48, 6, 0, 96, 3, 0, 192, 0, 255, 0, 24, 37, 111, 29, 3, 0,
  1, 129, 128, 3, 195, 192, 3, 195, 192, 1, 129, 128, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 3, 0, 192, 6, 0,
  96, 12, 0, 48, 28, 0, 56, 56, 0, 28, 56, 0, 28, 120, 0, 30,
  112, 0, 14, 112, 0, 14, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240,
  0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0,
  15, 112, 0, 14, 112, 0, 14, 120, 0, 30, 56, 0, 28, 56, 0, 28,
  28, 0, 56, 12, 0, 48, 6, 0, 96, 3, 0, 192, 0, 255, 0, 25,
  25, 100, 39, 7, 254, 192, 0, 1, 128, 224, 0, 3, 0, 112, 0, 6,
  0, 56, 0, 12, 0, 28, 0, 24, 0, 14, 0, 48, 0, 7, 0, 96,
  0, 3, 128, 192, 0, 1, 193, 128, 0, 0, 227, 0, 0, 0, 118, 0,
  0, 0, 60, 0, 0, 0, 28, 0, 0, 0, 62, 0, 0, 0, 103, 0,
  0, 0, 195, 128, 0, 1, 129, 192, 0, 3, 0, 224, 0, 6, 0, 112,
  0, 12, 0, 56, 0, 24, 0, 28, 0, 48, 0, 14, 0, 96, 0, 7,
  0, 192, 0, 3, 128, 128, 0, 1, 0, 24, 29, 87, 29, 3, 1, 0,
  255, 131, 3, 0, 230, 6, 0, 124, 12, 0, 60, 28, 0, 56, 56, 0,
  60, 56, 0, 124, 120, 0, 254, 112, 0, 206, 112, 1, 142, 240, 3, 15,
  240, 6, 15, 240, 14, 15, 240, 12, 15, 240, 24, 15, 240, 48, 15, 240,
  96, 15, 240, 224, 15, 240, 192, 15, 113, 128, 14, 115, 0, 14, 126, 0,
  30, 62, 0, 28, 60, 0, 28, 28, 0, 56, 60, 0, 48, 62, 0, 96,
  103, 0, 192, 193, 255, 0, 29, 38, 152, 34, 3, 1, 0, 112, 0, 0,
  0, 112, 0, 0, 0, 56, 0, 0, 0, 28, 0, 0, 0, 14, 0, 0,
  0, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  255, 240, 31, 248, 15, 0, 3, 192, 15, 0, 1, 128, 15, 0, 1, 128,
  15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128,
  15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128,
  15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128,
  15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128,
  15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 7, 0, 1, 0,
  7, 0, 3, 0, 3, 128, 2, 0, 1, 192, 6, 0, 0, 224, 24, 0,
  0, 63, 240, 0, 29, 38, 152, 34, 3, 1, 0, 0, 56, 0, 0, 0,
  120, 0, 0, 0, 240, 0, 0, 0, 224, 0, 0, 1, 128, 0, 0, 3,
  0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 240,
  31, 248, 15, 0, 3, 192, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 7, 0, 1, 0, 7, 0,
  3, 0, 3, 128, 2, 0, 1, 192, 6, 0, 0, 224, 24, 0, 0, 63,
  240, 0, 29, 38, 152, 34, 3, 0, 0, 3, 0, 0, 0, 7, 0, 0,
  0, 7, 128, 0, 0, 13, 192, 0, 0, 24, 96, 0, 0, 96, 48, 0,
  0, 192, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 240, 31, 248,
  15, 0, 3, 192, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128,
  15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128,
  15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128,
  15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128,
  15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128,
  15, 0, 1, 128, 15, 0, 1, 128, 7, 0, 3, 0, 7, 0, 3, 0,
  3, 128, 6, 0, 1, 192, 14, 0, 0, 224, 24, 0, 0, 63, 240, 0,
  29, 37, 148, 34, 3, 0, 0, 48, 48, 0, 0, 120, 120, 0, 0, 120,
  120, 0, 0, 48, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 255, 240, 31, 248, 15, 0, 3, 192, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 7, 0, 1, 0, 7, 0, 3, 0, 3, 128, 2, 0, 1, 192,
  6, 0, 0, 224, 24, 0, 0, 63, 240, 0, 27, 38, 152, 30, 2, 0,
  0, 0, 48, 0, 0, 0, 112, 0, 0, 0, 224, 0, 0, 0, 192, 0,
  0, 1, 128, 0, 0, 3, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 255, 248, 127, 224, 15, 128, 31, 0, 15, 128, 14, 0,
  7, 128, 12, 0, 3, 192, 12, 0, 3, 192, 8, 0, 1, 224, 24, 0,
  1, 240, 16, 0, 0, 240, 48, 0, 0, 248, 32, 0, 0, 120, 96, 0,
  0, 60, 64, 0, 0, 60, 192, 0, 0, 30, 128, 0, 0, 31, 0, 0,
  0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0,
  0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0,
  0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0,
  0, 15, 0, 0, 1, 255, 248, 0, 23, 29, 87, 28, 3, 0, 255, 248,
  0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 255, 128,
  15, 0, 224, 15, 0, 120, 15, 0, 60, 15, 0, 60, 15, 0, 30, 15,
  0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 60, 15, 0,
  60, 15, 0, 120, 15, 0, 224, 15, 255, 128, 15, 0, 0, 15, 0, 0,
  15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15,
  0, 0, 255, 248, 0, 19, 29, 87, 22, 1, 0, 0, 252, 0, 3, 14,
  0, 6, 7, 0, 14, 7, 128, 12, 7, 128, 28, 7, 128, 28, 7, 128,
  28, 7, 0, 28, 14, 0, 28, 28, 0, 28, 224, 0, 28, 24, 0, 28,
  6, 0, 28, 7, 0, 28, 3, 128, 28, 3, 128, 28, 1, 192, 28, 1,
  192, 28, 1, 192, 28, 1, 224, 28, 1, 224, 28, 1, 224, 28, 1, 224,
  28, 225, 192, 29, 225, 192, 29, 225, 192, 28, 131, 128, 28, 199, 0, 252,
  60, 0, 18, 28, 84, 21, 2, 1, 112, 0, 0, 120, 0, 0, 60, 0,
  0, 28, 0, 0, 6, 0, 0, 3, 0, 0, 1, 0, 0, 0, 0, 0,
  0, 0, 0, 15, 192, 0, 56, 112, 0, 32, 56, 0, 96, 28, 0, 120,
  28, 0, 120, 28, 0, 56, 28, 0, 0, 28, 0, 0, 252, 0, 15, 28,
  0, 56, 28, 0, 112, 28, 0, 224, 28, 0, 224, 28, 64, 224, 60, 64,
  224, 60, 64, 224, 92, 192, 112, 159, 128, 31, 15, 0, 18, 28, 84, 21,
  2, 1, 0, 28, 0, 0, 60, 0, 0, 120, 0, 0, 112, 0, 0, 192,
  0, 1, 128, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 15, 192, 0,
  56, 112, 0, 32, 56, 0, 96, 28, 0, 120, 28, 0, 120, 28, 0, 56,
  28, 0, 0, 28, 0, 0, 252, 0, 15, 28, 0, 56, 28, 0, 112, 28,
  0, 224, 28, 0, 224, 28, 64, 224, 60, 64, 224, 60, 64, 224, 92, 192,
  112, 159, 128, 31, 15, 0, 18, 28, 84, 21, 2, 0, 3, 128, 0, 3,
  128, 0, 7, 128, 0, 6, 192, 0, 12, 96, 0, 24, 48, 0, 32, 24,
  0, 0, 0, 0, 0, 0, 0, 15, 192, 0, 56, 112, 0, 32, 56, 0,
  96, 28, 0, 120, 28, 0, 120, 28, 0, 56, 28, 0, 0, 28, 0, 0,
  252, 0, 15, 28, 0, 56, 28, 0, 112, 28, 0, 224, 28, 0, 224, 28,
  64, 224, 60, 64, 224, 60, 64, 224, 92, 192, 112, 159, 128, 31, 15, 0,
  18, 27, 81, 21, 2, 0, 30, 8, 0, 63, 136, 0, 39, 248, 0, 64,
  240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 192,
  0, 56, 112, 0, 32, 56, 0, 96, 28, 0, 120, 28, 0, 120, 28, 0,
  56, 28, 0, 0, 28, 0, 0, 252, 0, 15, 28, 0, 56, 28, 0, 112,
  28, 0, 224, 28, 0, 224, 28, 64, 224, 60, 64, 224, 60, 64, 224, 92,
  192, 112, 159, 128, 31, 15, 0, 18, 27, 81, 21, 2, 0, 56, 48, 0,
  120, 120, 0, 120, 120, 0, 56, 48, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 15, 192, 0, 24, 112, 0, 32, 56, 0, 96, 28,
  0, 112, 28, 0, 120, 28, 0, 56, 28, 0, 0, 28, 0, 0, 252, 0,
  15, 28, 0, 56, 28, 0, 112, 28, 0, 224, 28, 0, 224, 28, 64, 224,
  60, 64, 224, 60, 64, 224, 92, 192, 112, 159, 128, 31, 15, 0, 18, 28,
  84, 21, 2, 0, 7, 128, 0, 8, 64, 0, 16, 32, 0, 16, 32, 0,
  16, 32, 0, 8, 64, 0, 7, 128, 0, 0, 0, 0, 0, 0, 0, 15,
  192, 0, 56, 112, 0, 32, 56, 0, 96, 28, 0, 112, 28, 0, 120, 28,
  0, 56, 28, 0, 0, 28, 0, 0, 252, 0, 15, 28, 0, 56, 28, 0,
  112, 28, 0, 224, 28, 0, 224, 28, 64, 224, 60, 64, 224, 92, 64, 224,
  156, 192, 112, 159, 128, 31, 15, 0, 25, 19, 76, 29, 2, 0, 15, 193,
  240, 0, 56, 115, 28, 0, 32, 30, 14, 0, 96, 30, 7, 0, 120, 28,
  7, 0, 120, 28, 7, 0, 56, 28, 7, 128, 0, 28, 7, 128, 3, 255,
  255, 128, 28, 28, 0, 0, 112, 28, 0, 0, 112, 28, 0, 0, 224, 28,
  1, 128, 224, 28, 1, 0, 224, 62, 1, 0, 224, 46, 1, 0, 224, 70,
  2, 0, 112, 131, 4, 0, 31, 0, 248, 0, 15, 27, 54, 18, 2, 248,
  7, 224, 28, 16, 56, 8, 48, 12, 112, 28, 112, 60, 240, 60, 240, 24,
  240, 0, 240, 0, 240, 0, 240, 0, 240, 6, 112, 4, 112, 4, 48, 12,
  56, 8, 28, 48, 7, 224, 1, 0, 2, 0, 1, 192, 0, 96, 0, 112,
  0, 112, 8, 240, 7, 192, 15, 28, 56, 19, 2, 1, 56, 0, 60, 0,
  28, 0, 14, 0, 7, 0, 3, 0, 0, 128, 0, 0, 0, 0, 7, 192,
  12, 112, 56, 56, 48, 28, 112, 28, 112, 28, 240, 30, 240, 30, 255, 254,
  240, 0, 240, 0, 240, 0, 240, 2, 112, 4, 112, 4, 56, 4, 56, 8,
  28, 16, 7, 224, 15, 28, 56, 19, 2, 1, 0, 28, 0, 60, 0, 56,
  0, 112, 0, 224, 0, 192, 1, 0, 0, 0, 0, 0, 7, 192, 12, 112,
  56, 56, 48, 28, 112, 28, 112, 28, 240, 30, 240, 30, 255, 254, 240, 0,
  240, 0, 240, 0, 240, 2, 112, 4, 112, 4, 56, 4, 56, 8, 28, 16,
  7, 224, 15, 28, 56, 19, 2, 0, 1, 128, 3, 128, 3, 192, 7, 192,
  6, 96, 8, 48, 16, 8, 0, 0, 0, 0, 7, 192, 12, 112, 56, 56,
  48, 28, 112, 28, 112, 28, 240, 30, 240, 30, 255, 254, 240, 0, 240, 0,
  240, 0, 240, 6, 112, 4, 112, 4, 56, 4, 56, 8, 28, 16, 7, 224,
  15, 27, 54, 19, 2, 0, 24, 24, 60, 60, 60, 60, 24, 24, 0, 0,
  0, 0, 0, 0, 0, 0, 7, 192, 12, 112, 56, 56, 48, 28, 112, 28,
  112, 28, 240, 14, 240, 14, 255, 254, 240, 0, 240, 0, 240, 0, 240, 2,
  112, 4, 112, 4, 56, 4, 56, 8, 28, 16, 7, 224, 10, 28, 56, 11,
  0, 0, 192, 0, 224, 0, 224, 0, 112, 0, 24, 0, 12, 0, 4, 0,
  0, 0, 0, 0, 126, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 127, 192, 10, 28, 56, 11, 1, 0,
  0, 192, 1, 192, 3, 128, 7, 0, 6, 0, 12, 0, 16, 0, 0, 0,
  0, 0, 252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 28, 0, 255, 128, 11, 28, 56, 11, 0, 0, 12, 0,
  12, 0, 30, 0, 31, 0, 51, 0, 96, 128, 128, 96, 0, 0, 0, 0,
  126, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 127, 192, 11, 26, 52, 13, 1, 0, 96, 192, 241, 224,
  241, 224, 96, 192, 0, 0, 0, 0, 0, 0, 62, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 63, 192,
  17, 29, 87, 21, 2, 0, 30, 4, 0, 15, 12, 0, 7, 176, 0, 3,
  224, 0, 1, 224, 0, 6, 224, 0, 12, 240, 0, 16, 120, 0, 0, 56,
  0, 0, 28, 0, 3, 254, 0, 12, 62, 0, 24, 30, 0, 56, 15, 0,
  112, 15, 0, 112, 7, 0, 240, 7, 0, 240, 7, 128, 240, 7, 128, 240,
  7, 128, 240, 7, 0, 240, 7, 0, 240, 7, 0, 112, 7, 0, 112, 14,
  0, 56, 14, 0, 24, 28, 0, 12, 56, 0, 3, 224, 0, 20, 26, 78,
  22, 1, 0, 3, 225, 0, 7, 254, 0, 4, 126, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 252, 60, 0, 28, 199, 0, 29, 3,
  0, 31, 3, 128, 30, 3, 128, 30, 3, 128, 28, 3, 128, 28, 3, 128,
  28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28,
  3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 255, 159,
  240, 17, 28, 84, 21, 2, 1, 56, 0, 0, 60, 0, 0, 30, 0, 0,
  14, 0, 0, 3, 0, 0, 1, 128, 0, 0, 128, 0, 0, 0, 0, 0,
  0, 0, 3, 224, 0, 12, 56, 0, 24, 28, 0, 56, 14, 0, 112, 14,
  0, 112, 7, 0, 240, 7, 0, 240, 7, 0, 240, 7, 128, 240, 7, 128,
  240, 7, 128, 240, 7, 0, 240, 7, 0, 112, 7, 0, 112, 14, 0, 56,
  14, 0, 24, 28, 0, 12, 56, 0, 3, 224, 0, 17, 28, 84, 21, 2,
  1, 0, 28, 0, 0, 28, 0, 0, 56, 0, 0, 112, 0, 0, 96, 0,
  0, 192, 0, 1, 128, 0, 0, 0, 0, 0, 0, 0, 3, 224, 0, 12,
  56, 0, 24, 28, 0, 56, 14, 0, 112, 14, 0, 112, 7, 0, 240, 7,
  0, 240, 7, 0, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 0,
  240, 7, 0, 112, 7, 0, 112, 14, 0, 56, 14, 0, 24, 28, 0, 12,
  56, 0, 3, 224, 0, 17, 28, 84, 21, 2, 0, 1, 128, 0, 1, 192,
  0, 3, 192, 0, 3, 96, 0, 6, 32, 0, 12, 16, 0, 16, 12, 0,
  0, 0, 0, 0, 0, 0, 3, 224, 0, 12, 56, 0, 24, 28, 0, 56,
  14, 0, 112, 14, 0, 112, 7, 0, 240, 7, 0, 240, 7, 0, 240, 7,
  128, 240, 7, 128, 240, 7, 128, 240, 7, 0, 240, 7, 0, 112, 7, 0,
  112, 14, 0, 56, 14, 0, 24, 28, 0, 12, 56, 0, 3, 224, 0, 17,
  27, 81, 21, 2, 0, 15, 4, 0, 31, 204, 0, 19, 248, 0, 16, 240,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 224, 0,
  12, 56, 0, 24, 28, 0, 56, 14, 0, 112, 14, 0, 112, 7, 0, 240,
  7, 0, 240, 7, 0, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7,
  0, 240, 7, 0, 112, 7, 0, 112, 14, 0, 56, 14, 0, 24, 28, 0,
  12, 56, 0, 3, 224, 0, 17, 27, 81, 21, 2, 0, 24, 24, 0, 60,
  60, 0, 60, 60, 0, 24, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 3, 224, 0, 12, 56, 0, 24, 28, 0, 56, 14, 0,
  112, 14, 0, 112, 7, 0, 240, 7, 0, 240, 7, 0, 240, 7, 128, 240,
  7, 128, 240, 7, 128, 240, 7, 0, 240, 7, 0, 112, 7, 0, 112, 14,
  0, 56, 14, 0, 24, 28, 0, 12, 56, 0, 3, 224, 0, 35, 26, 130,
  39, 2, 254, 0, 0, 224, 0, 0, 0, 1, 240, 0, 0, 0, 1, 240,
  0, 0, 0, 1, 240, 0, 0, 0, 0, 224, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255,
  255, 255, 255, 224, 255, 255, 255, 255, 224, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 0,
  0, 0, 1, 240, 0, 0, 0, 1, 240, 0, 0, 0, 1, 240, 0, 0,
  0, 0, 224, 0, 0, 17, 19, 57, 21, 2, 0, 3, 225, 0, 12, 59,
  0, 24, 30, 0, 56, 14, 0, 112, 14, 0, 112, 31, 0, 240, 55, 0,
  240, 103, 0, 240, 199, 128, 240, 135, 128, 241, 7, 128, 242, 7, 0, 244,
  7, 0, 124, 7, 0, 120, 14, 0, 56, 14, 0, 120, 28, 0, 76, 56,
  0, 131, 224, 0, 20, 28, 84, 22, 1, 1, 14, 0, 0, 15, 0, 0,
  7, 0, 0, 3, 128, 0, 1, 192, 0, 0, 64, 0, 0, 32, 0, 0,
  0, 0, 0, 0, 0, 252, 31, 128, 28, 3, 128, 28, 3, 128, 28, 3,
  128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128,
  28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 7, 128, 28,
  7, 128, 28, 15, 128, 12, 11, 128, 14, 51, 128, 3, 195, 240, 20, 28,
  84, 22, 1, 1, 0, 7, 0, 0, 15, 0, 0, 30, 0, 0, 24, 0,
  0, 48, 0, 0, 96, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 252,
  31, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3,
  128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128,
  28, 3, 128, 28, 3, 128, 28, 7, 128, 28, 7, 128, 28, 15, 128, 12,
  11, 128, 14, 51, 128, 3, 195, 240, 20, 28, 84, 22, 1, 0, 0, 96,
  0, 0, 224, 0, 0, 240, 0, 1, 176, 0, 3, 24, 0, 2, 4, 0,
  4, 2, 0, 0, 0, 0, 0, 0, 0, 252, 31, 128, 28, 3, 128, 28,
  3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3,
  128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128,
  28, 7, 128, 28, 7, 128, 28, 15, 128, 12, 11, 128, 14, 51, 128, 3,
  195, 240, 20, 27, 81, 22, 1, 0, 6, 6, 0, 15, 15, 0, 15, 15,
  0, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  252, 15, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28,
  3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3,
  128, 28, 3, 128, 28, 3, 128, 28, 7, 128, 28, 7, 128, 28, 15, 128,
  12, 11, 128, 14, 51, 128, 3, 195, 240, 20, 37, 111, 22, 1, 248, 0,
  3, 0, 0, 7, 0, 0, 15, 0, 0, 28, 0, 0, 24, 0, 0, 48,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 143, 240, 30, 1, 128,
  30, 1, 128, 14, 1, 0, 14, 1, 0, 15, 3, 0, 7, 2, 0, 7,
  2, 0, 3, 134, 0, 3, 132, 0, 3, 132, 0, 1, 204, 0, 1, 200,
  0, 1, 200, 0, 0, 248, 0, 0, 240, 0, 0, 240, 0, 0, 112, 0,
  0, 96, 0, 0, 96, 0, 0, 96, 0, 0, 64, 0, 48, 64, 0, 120,
  192, 0, 120, 128, 0, 113, 128, 0, 51, 0, 0, 30, 0, 0, 18, 38,
  114, 21, 1, 246, 12, 0, 0, 60, 0, 0, 252, 0, 0, 28, 0, 0,
  28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28,
  30, 0, 28, 127, 0, 28, 199, 128, 29, 3, 128, 31, 3, 192, 30, 3,
  192, 30, 3, 128, 28, 3, 128, 28, 3, 128, 28, 7, 0, 28, 7, 0,
  28, 6, 0, 28, 12, 0, 28, 28, 0, 28, 24, 0, 28, 48, 0, 28,
  192, 0, 29, 128, 0, 30, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0,
  56, 0, 0, 192, 0, 0, 19, 36, 108, 21, 1, 247, 3, 6, 0, 7,
  143, 0, 7, 143, 0, 3, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 255, 143, 224, 30, 3, 128, 30, 1, 0, 14, 3, 0,
  14, 2, 0, 7, 2, 0, 7, 2, 0, 7, 6, 0, 3, 132, 0, 3,
  132, 0, 3, 140, 0, 1, 200, 0, 1, 200, 0, 1, 200, 0, 0, 240,
  0, 0, 240, 0, 0, 240, 0, 0, 96, 0, 0, 96, 0, 0, 96, 0,
  0, 64, 0, 0, 64, 0, 48, 64, 0, 120, 64, 0, 120, 128, 0, 121,
  128, 0, 59, 0, 0, 30, 0, 0
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--41-410-72-72-P-216-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 0, '1' Height: 28
  Calculated Max Values w=35 h=38 x= 5 y=11 dx=39 dy= 0 ascent=30 len=170
  Font Bounding box     w=107 h=51 x=-33 y=-12
  Calculated Min Values           x= 0 y=-8 dx= 0 dy= 0
  Pure Font   ascent =28 descent= 0
  X Font      ascent =28 descent= 0
  Max Font    ascent =30 descent=-8
*/
const u8g_fntpgm_uint8_t u8g_font_osr29n[1226] U8G_FONT_SECTION("u8g_font_osr29n") = {
  0, 107, 51, 223, 244, 28, 0, 0, 0, 0, 42, 58, 0, 30, 248, 28,
  0, 15, 17, 34, 21, 3, 11, 3, 128, 3, 192, 3, 128, 3, 128, 225,
  142, 241, 30, 249, 62, 29, 112, 3, 192, 3, 192, 29, 120, 249, 62, 241,
  30, 227, 142, 3, 128, 3, 192, 3, 128, 35, 34, 170, 39, 2, 250, 0,
  0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0,
  192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192,
  0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0,
  0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0,
  0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 255,
  255, 255, 255, 224, 255, 255, 255, 255, 224, 0, 0, 192, 0, 0, 0, 0,
  192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192,
  0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0,
  0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0,
  0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0,
  0, 192, 0, 0, 0, 0, 192, 0, 0, 5, 12, 12, 11, 3, 249, 112,
  240, 248, 248, 24, 8, 8, 16, 16, 32, 32, 64, 10, 2, 4, 14, 2,
  9, 255, 192, 255, 192, 5, 5, 5, 11, 3, 0, 112, 248, 248, 248, 112,
  14, 38, 76, 18, 2, 248, 0, 12, 0, 12, 0, 12, 0, 8, 0, 24,
  0, 24, 0, 16, 0, 48, 0, 48, 0, 32, 0, 96, 0, 96, 0, 64,
  0, 192, 0, 192, 0, 128, 1, 128, 1, 128, 1, 0, 3, 0, 3, 0,
  2, 0, 6, 0, 6, 0, 4, 0, 12, 0, 12, 0, 8, 0, 24, 0,
  24, 0, 16, 0, 48, 0, 48, 0, 32, 0, 96, 0, 96, 0, 64, 0,
  192, 0, 20, 28, 84, 24, 2, 0, 1, 248, 0, 7, 12, 0, 12, 7,
  0, 28, 3, 128, 24, 1, 128, 56, 1, 192, 56, 1, 192, 112, 0, 224,
  112, 0, 224, 112, 0, 224, 240, 0, 240, 240, 0, 240, 240, 0, 240, 240,
  0, 240, 240, 0, 240, 240, 0, 240, 240, 0, 240, 240, 0, 240, 240, 0,
  240, 112, 0, 224, 112, 0, 224, 112, 0, 224, 56, 1, 192, 56, 1, 192,
  24, 1, 128, 12, 3, 0, 6, 6, 0, 3, 252, 0, 14, 28, 56, 24,
  5, 0, 1, 128, 1, 128, 3, 128, 7, 128, 255, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 7, 128, 255, 252, 17, 28, 84, 24, 3, 0,
  7, 224, 0, 24, 60, 0, 32, 30, 0, 64, 15, 0, 192, 15, 0, 192,
  7, 128, 192, 7, 128, 240, 7, 128, 252, 7, 128, 252, 7, 128, 124, 7,
  128, 24, 15, 0, 0, 14, 0, 0, 28, 0, 0, 56, 0, 0, 112, 0,
  0, 224, 0, 1, 192, 0, 3, 0, 0, 6, 0, 0, 12, 0, 128, 24,
  0, 128, 48, 0, 128, 48, 1, 128, 112, 1, 128, 127, 255, 128, 127, 255,
  128, 127, 255, 128, 17, 28, 84, 24, 3, 0, 15, 224, 0, 48, 56, 0,
  96, 28, 0, 96, 14, 0, 240, 15, 0, 248, 15, 0, 248, 15, 0, 120,
  15, 0, 0, 15, 0, 0, 15, 0, 0, 14, 0, 0, 28, 0, 28, 56,
  0, 31, 224, 0, 0, 60, 0, 0, 30, 0, 0, 15, 0, 0, 7, 0,
  0, 7, 128, 0, 7, 128, 120, 7, 128, 248, 7, 128, 248, 7, 128, 248,
  7, 0, 192, 15, 0, 192, 14, 0, 96, 28, 0, 31, 240, 0, 19, 28,
  84, 24, 2, 0, 0, 12, 0, 0, 12, 0, 0, 28, 0, 0, 60, 0,
  0, 60, 0, 0, 124, 0, 0, 252, 0, 0, 252, 0, 1, 188, 0, 3,
  60, 0, 3, 60, 0, 6, 60, 0, 12, 60, 0, 12, 60, 0, 24, 60,
  0, 48, 60, 0, 32, 60, 0, 96, 60, 0, 192, 60, 0, 255, 255, 224,
  0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0,
  60, 0, 0, 60, 0, 7, 255, 224, 17, 29, 87, 24, 4, 0, 0, 2,
  0, 120, 12, 0, 127, 248, 0, 127, 240, 0, 111, 192, 0, 96, 0, 0,
  96, 0, 0, 96, 0, 0, 96, 0, 0, 96, 0, 0, 103, 224, 0, 104,
  60, 0, 112, 30, 0, 96, 14, 0, 96, 15, 0, 96, 7, 0, 0, 7,
  128, 0, 7, 128, 0, 7, 128, 16, 7, 128, 120, 7, 128, 252, 7, 128,
  252, 7, 128, 248, 15, 0, 224, 15, 0, 224, 14, 0, 96, 28, 0, 48,
  56, 0, 31, 240, 0, 17, 28, 84, 24, 3, 0, 1, 248, 0, 3, 12,
  0, 12, 6, 0, 28, 7, 0, 24, 15, 0, 56, 31, 0, 48, 31, 0,
  112, 14, 0, 112, 0, 0, 112, 0, 0, 240, 0, 0, 241, 240, 0, 246,
  28, 0, 252, 14, 0, 248, 7, 0, 248, 7, 0, 240, 7, 128, 240, 7,
  128, 240, 7, 128, 240, 7, 128, 112, 7, 128, 112, 7, 128, 112, 7, 0,
  48, 7, 0, 56, 7, 0, 24, 14, 0, 12, 28, 0, 7, 248, 0, 16,
  28, 56, 24, 4, 0, 255, 255, 255, 255, 255, 255, 192, 3, 128, 2, 128,
  2, 128, 6, 128, 4, 0, 12, 0, 8, 0, 24, 0, 48, 0, 32, 0,
  96, 0, 192, 0, 192, 1, 128, 3, 128, 3, 128, 7, 128, 7, 128, 7,
  128, 15, 192, 15, 192, 15, 192, 15, 192, 15, 192, 7, 192, 20, 28, 84,
  24, 2, 0, 3, 248, 0, 14, 14, 0, 56, 7, 0, 112, 3, 128, 112,
  1, 192, 240, 1, 192, 240, 1, 192, 240, 1, 192, 240, 1, 192, 248, 1,
  128, 126, 3, 128, 127, 131, 0, 63, 252, 0, 15, 252, 0, 7, 255, 0,
  24, 127, 192, 48, 15, 224, 112, 3, 224, 224, 1, 240, 224, 0, 240, 224,
  0, 240, 224, 0, 224, 224, 0, 224, 224, 0, 224, 112, 1, 192, 48, 1,
  128, 28, 7, 0, 15, 252, 0, 17, 28, 84, 24, 3, 0, 7, 224, 0,
  12, 56, 0, 56, 12, 0, 56, 14, 0, 112, 14, 0, 112, 7, 0, 240,
  7, 0, 240, 7, 0, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7,
  128, 112, 15, 128, 112, 15, 128, 56, 27, 128, 28, 51, 128, 7, 199, 128,
  0, 7, 128, 0, 7, 0, 0, 7, 0, 56, 7, 0, 124, 7, 0, 124,
  14, 0, 120, 14, 0, 112, 12, 0, 112, 24, 0, 48, 48, 0, 31, 224,
  0, 5, 19, 19, 11, 3, 0, 112, 248, 248, 248, 112, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 112, 248, 248, 248, 112
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--41-410-72-72-P-216-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 29, '1' Height: 28
  Calculated Max Values w=41 h=38 x= 5 y=22 dx=44 dy= 0 ascent=31 len=174
  Font Bounding box     w=107 h=51 x=-33 y=-12
  Calculated Min Values           x=-1 y=-9 dx= 0 dy= 0
  Pure Font   ascent =29 descent=-9
  X Font      ascent =30 descent=-9
  Max Font    ascent =31 descent=-9
*/
const u8g_fntpgm_uint8_t u8g_font_osr29r[7573] U8G_FONT_SECTION("u8g_font_osr29r") = {
  0, 107, 51, 223, 244, 29, 9, 148, 21, 166, 32, 127, 247, 31, 247, 30,
  247, 0, 0, 0, 11, 0, 0, 5, 28, 28, 11, 3, 0, 112, 248, 248,
  248, 248, 248, 248, 248, 112, 112, 112, 112, 112, 112, 112, 112, 32, 32, 32,
  32, 32, 32, 0, 112, 248, 248, 248, 112, 9, 8, 16, 17, 4, 22, 227,
  128, 227, 128, 227, 128, 227, 128, 193, 128, 65, 128, 65, 0, 65, 0, 22,
  28, 84, 28, 3, 0, 0, 192, 192, 0, 192, 192, 0, 192, 192, 0, 192,
  128, 0, 129, 128, 1, 129, 128, 1, 129, 128, 1, 129, 128, 255, 255, 252,
  255, 255, 252, 1, 129, 0, 3, 3, 0, 3, 3, 0, 3, 3, 0, 3,
  3, 0, 3, 3, 0, 2, 2, 0, 6, 6, 0, 255, 255, 252, 255, 255,
  252, 6, 6, 0, 6, 6, 0, 6, 4, 0, 4, 12, 0, 12, 12, 0,
  12, 12, 0, 12, 12, 0, 12, 12, 0, 18, 34, 102, 24, 3, 253, 1,
  16, 0, 1, 16, 0, 1, 16, 0, 3, 248, 0, 13, 22, 0, 25, 17,
  0, 49, 16, 128, 97, 16, 192, 97, 16, 192, 97, 17, 192, 97, 19, 192,
  97, 19, 192, 113, 19, 128, 61, 16, 0, 63, 144, 0, 31, 240, 0, 15,
  252, 0, 3, 254, 0, 1, 127, 0, 1, 31, 128, 1, 19, 128, 33, 17,
  192, 113, 16, 192, 249, 16, 192, 241, 16, 192, 241, 16, 192, 225, 16, 128,
  97, 17, 128, 97, 17, 0, 49, 19, 0, 15, 188, 0, 1, 240, 0, 1,
  16, 0, 1, 16, 0, 28, 28, 112, 36, 4, 0, 31, 0, 6, 0, 49,
  128, 4, 0, 96, 192, 12, 0, 96, 192, 8, 0, 224, 224, 24, 0, 224,
  224, 48, 0, 224, 224, 32, 0, 224, 224, 96, 0, 224, 224, 64, 0, 224,
  224, 128, 0, 96, 193, 128, 0, 96, 193, 0, 0, 49, 131, 0, 0, 31,
  6, 0, 0, 0, 4, 15, 0, 0, 12, 48, 128, 0, 8, 48, 192, 0,
  16, 96, 96, 0, 48, 96, 96, 0, 32, 224, 112, 0, 96, 224, 112, 0,
  64, 224, 112, 0, 128, 224, 112, 1, 128, 224, 112, 1, 0, 96, 96, 2,
  0, 96, 96, 6, 0, 48, 192, 4, 0, 31, 128, 28, 28, 112, 32, 2,
  0, 0, 248, 0, 0, 3, 140, 0, 0, 7, 4, 0, 0, 6, 2, 0,
  0, 14, 2, 0, 0, 14, 2, 0, 0, 14, 6, 0, 0, 14, 4, 0,
  0, 15, 12, 0, 0, 7, 24, 0, 0, 7, 176, 0, 0, 3, 224, 0,
  0, 1, 224, 63, 240, 3, 224, 7, 128, 6, 240, 7, 0, 12, 120, 6,
  0, 24, 124, 6, 0, 48, 60, 4, 0, 112, 30, 12, 0, 112, 31, 24,
  0, 240, 15, 144, 0, 240, 7, 176, 0, 240, 7, 224, 0, 240, 3, 224,
  0, 240, 3, 240, 32, 120, 6, 248, 32, 60, 12, 124, 192, 31, 240, 63,
  128, 3, 8, 8, 10, 4, 22, 224, 224, 224, 224, 192, 64, 64, 64, 9,
  37, 74, 15, 4, 249, 1, 128, 3, 0, 6, 0, 14, 0, 12, 0, 24,
  0, 24, 0, 48, 0, 48, 0, 96, 0, 96, 0, 96, 0, 96, 0, 192,
  0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192,
  0, 192, 0, 96, 0, 96, 0, 96, 0, 96, 0, 48, 0, 48, 0, 56,
  0, 24, 0, 12, 0, 12, 0, 6, 0, 3, 0, 3, 128, 1, 128, 9,
  37, 74, 15, 2, 249, 192, 0, 96, 0, 48, 0, 56, 0, 24, 0, 12,
  0, 12, 0, 6, 0, 6, 0, 3, 0, 3, 0, 3, 0, 3, 0, 1,
  128, 1, 128, 1, 128, 1, 128, 1, 128, 1, 128, 1, 128, 1, 128, 1,
  128, 1, 128, 3, 128, 3, 0, 3, 0, 3, 0, 6, 0, 6, 0, 14,
  0, 12, 0, 24, 0, 24, 0, 48, 0, 96, 0, 224, 0, 192, 0, 15,
  17, 34, 21, 3, 11, 3, 128, 3, 192, 3, 128, 3, 128, 225, 142, 241,
  30, 249, 62, 29, 112, 3, 192, 3, 192, 29, 120, 249, 62, 241, 30, 227,
  142, 3, 128, 3, 192, 3, 128, 35, 34, 170, 39, 2, 250, 0, 0, 192,
  0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0,
  0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0,
  0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0,
  0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0,
  192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 255, 255, 255,
  255, 224, 255, 255, 255, 255, 224, 0, 0, 192, 0, 0, 0, 0, 192, 0,
  0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0,
  0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0,
  0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0,
  192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192,
  0, 0, 0, 0, 192, 0, 0, 5, 12, 12, 11, 3, 249, 112, 240, 248,
  248, 24, 8, 8, 16, 16, 32, 32, 64, 10, 2, 4, 14, 2, 9, 255,
  192, 255, 192, 5, 5, 5, 11, 3, 0, 112, 248, 248, 248, 112, 14, 38,
  76, 18, 2, 248, 0, 12, 0, 12, 0, 12, 0, 8, 0, 24, 0, 24,
  0, 16, 0, 48, 0, 48, 0, 32, 0, 96, 0, 96, 0, 64, 0, 192,
  0, 192, 0, 128, 1, 128, 1, 128, 1, 0, 3, 0, 3, 0, 2, 0,
  6, 0, 6, 0, 4, 0, 12, 0, 12, 0, 8, 0, 24, 0, 24, 0,
  16, 0, 48, 0, 48, 0, 32, 0, 96, 0, 96, 0, 64, 0, 192, 0,
  20, 28, 84, 24, 2, 0, 1, 248, 0, 7, 12, 0, 12, 7, 0, 28,
  3, 128, 24, 1, 128, 56, 1, 192, 56, 1, 192, 112, 0, 224, 112, 0,
  224, 112, 0, 224, 240, 0, 240, 240, 0, 240, 240, 0, 240, 240, 0, 240,
  240, 0, 240, 240, 0, 240, 240, 0, 240, 240, 0, 240, 240, 0, 240, 112,
  0, 224, 112, 0, 224, 112, 0, 224, 56, 1, 192, 56, 1, 192, 24, 1,
  128, 12, 3, 0, 6, 6, 0, 3, 252, 0, 14, 28, 56, 24, 5, 0,
  1, 128, 1, 128, 3, 128, 7, 128, 255, 128, 7, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128,
  7, 128, 7, 128, 7, 128, 255, 252, 17, 28, 84, 24, 3, 0, 7, 224,
  0, 24, 60, 0, 32, 30, 0, 64, 15, 0, 192, 15, 0, 192, 7, 128,
  192, 7, 128, 240, 7, 128, 252, 7, 128, 252, 7, 128, 124, 7, 128, 24,
  15, 0, 0, 14, 0, 0, 28, 0, 0, 56, 0, 0, 112, 0, 0, 224,
  0, 1, 192, 0, 3, 0, 0, 6, 0, 0, 12, 0, 128, 24, 0, 128,
  48, 0, 128, 48, 1, 128, 112, 1, 128, 127, 255, 128, 127, 255, 128, 127,
  255, 128, 17, 28, 84, 24, 3, 0, 15, 224, 0, 48, 56, 0, 96, 28,
  0, 96, 14, 0, 240, 15, 0, 248, 15, 0, 248, 15, 0, 120, 15, 0,
  0, 15, 0, 0, 15, 0, 0, 14, 0, 0, 28, 0, 28, 56, 0, 31,
  224, 0, 0, 60, 0, 0, 30, 0, 0, 15, 0, 0, 7, 0, 0, 7,
  128, 0, 7, 128, 120, 7, 128, 248, 7, 128, 248, 7, 128, 248, 7, 0,
  192, 15, 0, 192, 14, 0, 96, 28, 0, 31, 240, 0, 19, 28, 84, 24,
  2, 0, 0, 12, 0, 0, 12, 0, 0, 28, 0, 0, 60, 0, 0, 60,
  0, 0, 124, 0, 0, 252, 0, 0, 252, 0, 1, 188, 0, 3, 60, 0,
  3, 60, 0, 6, 60, 0, 12, 60, 0, 12, 60, 0, 24, 60, 0, 48,
  60, 0, 32, 60, 0, 96, 60, 0, 192, 60, 0, 255, 255, 224, 0, 60,
  0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0,
  0, 60, 0, 7, 255, 224, 17, 29, 87, 24, 4, 0, 0, 2, 0, 120,
  12, 0, 127, 248, 0, 127, 240, 0, 111, 192, 0, 96, 0, 0, 96, 0,
  0, 96, 0, 0, 96, 0, 0, 96, 0, 0, 103, 224, 0, 104, 60, 0,
  112, 30, 0, 96, 14, 0, 96, 15, 0, 96, 7, 0, 0, 7, 128, 0,
  7, 128, 0, 7, 128, 16, 7, 128, 120, 7, 128, 252, 7, 128, 252, 7,
  128, 248, 15, 0, 224, 15, 0, 224, 14, 0, 96, 28, 0, 48, 56, 0,
  31, 240, 0, 17, 28, 84, 24, 3, 0, 1, 248, 0, 3, 12, 0, 12,
  6, 0, 28, 7, 0, 24, 15, 0, 56, 31, 0, 48, 31, 0, 112, 14,
  0, 112, 0, 0, 112, 0, 0, 240, 0, 0, 241, 240, 0, 246, 28, 0,
  252, 14, 0, 248, 7, 0, 248, 7, 0, 240, 7, 128, 240, 7, 128, 240,
  7, 128, 240, 7, 128, 112, 7, 128, 112, 7, 128, 112, 7, 0, 48, 7,
  0, 56, 7, 0, 24, 14, 0, 12, 28, 0, 7, 248, 0, 16, 28, 56,
  24, 4, 0, 255, 255, 255, 255, 255, 255, 192, 3, 128, 2, 128, 2, 128,
  6, 128, 4, 0, 12, 0, 8, 0, 24, 0, 48, 0, 32, 0, 96, 0,
  192, 0, 192, 1, 128, 3, 128, 3, 128, 7, 128, 7, 128, 7, 128, 15,
  192, 15, 192, 15, 192, 15, 192, 15, 192, 7, 192, 20, 28, 84, 24, 2,
  0, 3, 248, 0, 14, 14, 0, 56, 7, 0, 112, 3, 128, 112, 1, 192,
  240, 1, 192, 240, 1, 192, 240, 1, 192, 240, 1, 192, 248, 1, 128, 126,
  3, 128, 127, 131, 0, 63, 252, 0, 15, 252, 0, 7, 255, 0, 24, 127,
  192, 48, 15, 224, 112, 3, 224, 224, 1, 240, 224, 0, 240, 224, 0, 240,
  224, 0, 224, 224, 0, 224, 224, 0, 224, 112, 1, 192, 48, 1, 128, 28,
  7, 0, 15, 252, 0, 17, 28, 84, 24, 3, 0, 7, 224, 0, 12, 56,
  0, 56, 12, 0, 56, 14, 0, 112, 14, 0, 112, 7, 0, 240, 7, 0,
  240, 7, 0, 240, 7, 128, 240, 7, 128, 240, 7, 128, 240, 7, 128, 112,
  15, 128, 112, 15, 128, 56, 27, 128, 28, 51, 128, 7, 199, 128, 0, 7,
  128, 0, 7, 0, 0, 7, 0, 56, 7, 0, 124, 7, 0, 124, 14, 0,
  120, 14, 0, 112, 12, 0, 112, 24, 0, 48, 48, 0, 31, 224, 0, 5,
  19, 19, 11, 3, 0, 112, 248, 248, 248, 112, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 112, 248, 248, 248, 112, 6, 26, 26, 12, 3, 249, 112, 248,
  248, 248, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 248, 252, 124,
  12, 12, 12, 8, 24, 48, 32, 64, 32, 34, 136, 39, 3, 250, 0, 0,
  0, 2, 0, 0, 0, 7, 0, 0, 0, 28, 0, 0, 0, 112, 0, 0,
  1, 224, 0, 0, 7, 128, 0, 0, 30, 0, 0, 0, 120, 0, 0, 1,
  224, 0, 0, 3, 128, 0, 0, 14, 0, 0, 0, 56, 0, 0, 0, 240,
  0, 0, 3, 192, 0, 0, 15, 0, 0, 0, 60, 0, 0, 0, 240, 0,
  0, 0, 224, 0, 0, 0, 120, 0, 0, 0, 30, 0, 0, 0, 7, 128,
  0, 0, 1, 192, 0, 0, 0, 112, 0, 0, 0, 28, 0, 0, 0, 7,
  0, 0, 0, 3, 192, 0, 0, 0, 240, 0, 0, 0, 60, 0, 0, 0,
  15, 0, 0, 0, 3, 128, 0, 0, 0, 224, 0, 0, 0, 56, 0, 0,
  0, 14, 0, 0, 0, 6, 35, 10, 50, 39, 2, 6, 255, 255, 255, 255,
  224, 255, 255, 255, 255, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 255, 255, 255, 255, 224, 255, 255, 255, 255, 224, 32, 34,
  136, 39, 3, 250, 64, 0, 0, 0, 224, 0, 0, 0, 56, 0, 0, 0,
  14, 0, 0, 0, 7, 128, 0, 0, 1, 224, 0, 0, 0, 120, 0, 0,
  0, 30, 0, 0, 0, 7, 128, 0, 0, 1, 192, 0, 0, 0, 112, 0,
  0, 0, 28, 0, 0, 0, 15, 0, 0, 0, 3, 192, 0, 0, 0, 240,
  0, 0, 0, 60, 0, 0, 0, 15, 0, 0, 0, 7, 0, 0, 0, 30,
  0, 0, 0, 120, 0, 0, 1, 224, 0, 0, 3, 128, 0, 0, 14, 0,
  0, 0, 56, 0, 0, 0, 224, 0, 0, 3, 192, 0, 0, 15, 0, 0,
  0, 60, 0, 0, 0, 240, 0, 0, 1, 192, 0, 0, 7, 0, 0, 0,
  28, 0, 0, 0, 112, 0, 0, 0, 96, 0, 0, 0, 15, 28, 56, 20,
  3, 0, 15, 192, 48, 112, 64, 60, 192, 28, 192, 30, 248, 30, 248, 30,
  112, 30, 0, 28, 0, 60, 0, 120, 0, 240, 1, 192, 3, 128, 6, 0,
  12, 0, 8, 32, 8, 32, 8, 32, 12, 64, 7, 128, 0, 0, 0, 0,
  3, 128, 7, 192, 7, 192, 7, 192, 3, 128, 29, 29, 116, 33, 2, 1,
  0, 63, 248, 0, 1, 192, 14, 0, 3, 0, 3, 0, 6, 0, 1, 128,
  12, 0, 0, 192, 24, 7, 206, 96, 48, 12, 124, 32, 48, 56, 60, 48,
  96, 112, 60, 16, 96, 224, 56, 24, 96, 224, 56, 24, 193, 192, 56, 24,
  193, 192, 56, 24, 193, 192, 48, 24, 195, 192, 112, 24, 195, 128, 112, 24,
  195, 128, 112, 48, 195, 128, 224, 48, 195, 128, 224, 48, 67, 129, 224, 96,
  97, 130, 224, 192, 97, 196, 225, 128, 48, 120, 62, 0, 48, 0, 0, 0,
  24, 0, 0, 0, 12, 0, 0, 0, 6, 0, 4, 0, 3, 128, 28, 0,
  0, 127, 240, 0, 29, 29, 116, 32, 2, 0, 0, 2, 0, 0, 0, 6,
  0, 0, 0, 7, 0, 0, 0, 7, 0, 0, 0, 15, 128, 0, 0, 15,
  128, 0, 0, 15, 128, 0, 0, 31, 192, 0, 0, 19, 192, 0, 0, 51,
  192, 0, 0, 49, 224, 0, 0, 33, 224, 0, 0, 97, 224, 0, 0, 96,
  240, 0, 0, 64, 240, 0, 0, 192, 240, 0, 0, 192, 120, 0, 0, 128,
  120, 0, 1, 128, 120, 0, 1, 255, 252, 0, 1, 0, 60, 0, 3, 0,
  28, 0, 3, 0, 30, 0, 6, 0, 30, 0, 6, 0, 15, 0, 6, 0,
  15, 0, 14, 0, 15, 0, 30, 0, 15, 128, 255, 224, 255, 248, 23, 29,
  87, 28, 3, 0, 255, 255, 128, 15, 0, 224, 15, 0, 120, 15, 0, 60,
  15, 0, 28, 15, 0, 28, 15, 0, 30, 15, 0, 30, 15, 0, 28, 15,
  0, 28, 15, 0, 56, 15, 0, 48, 15, 0, 224, 15, 255, 0, 15, 0,
  224, 15, 0, 112, 15, 0, 56, 15, 0, 60, 15, 0, 30, 15, 0, 30,
  15, 0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 60, 15,
  0, 60, 15, 0, 120, 15, 0, 224, 255, 255, 128, 22, 29, 87, 28, 3,
  1, 1, 254, 8, 7, 3, 152, 12, 0, 248, 28, 0, 248, 24, 0, 120,
  56, 0, 56, 120, 0, 56, 112, 0, 24, 112, 0, 24, 240, 0, 8, 240,
  0, 8, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0,
  0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 112, 0, 12, 112, 0, 12,
  120, 0, 12, 56, 0, 24, 56, 0, 24, 28, 0, 24, 12, 0, 48, 6,
  0, 96, 3, 0, 192, 0, 255, 128, 27, 29, 116, 32, 3, 0, 255, 255,
  192, 0, 15, 0, 112, 0, 15, 0, 28, 0, 15, 0, 14, 0, 15, 0,
  7, 0, 15, 0, 7, 128, 15, 0, 3, 128, 15, 0, 3, 192, 15, 0,
  3, 192, 15, 0, 1, 192, 15, 0, 1, 224, 15, 0, 1, 224, 15, 0,
  1, 224, 15, 0, 1, 224, 15, 0, 1, 224, 15, 0, 1, 224, 15, 0,
  1, 224, 15, 0, 1, 224, 15, 0, 1, 224, 15, 0, 3, 192, 15, 0,
  3, 192, 15, 0, 3, 192, 15, 0, 3, 128, 15, 0, 7, 0, 15, 0,
  7, 0, 15, 0, 14, 0, 15, 0, 28, 0, 15, 0, 112, 0, 255, 255,
  192, 0, 23, 29, 87, 29, 3, 0, 255, 255, 254, 15, 0, 62, 15, 0,
  14, 15, 0, 14, 15, 0, 6, 15, 0, 6, 15, 0, 2, 15, 0, 2,
  15, 1, 2, 15, 1, 0, 15, 1, 0, 15, 1, 0, 15, 3, 0, 15,
  7, 0, 15, 255, 0, 15, 7, 0, 15, 3, 0, 15, 1, 0, 15, 1,
  2, 15, 1, 2, 15, 1, 2, 15, 0, 2, 15, 0, 6, 15, 0, 6,
  15, 0, 6, 15, 0, 14, 15, 0, 30, 15, 0, 126, 255, 255, 254, 23,
  29, 87, 28, 3, 0, 255, 255, 254, 15, 0, 62, 15, 0, 14, 15, 0,
  14, 15, 0, 6, 15, 0, 6, 15, 0, 2, 15, 0, 2, 15, 1, 2,
  15, 1, 0, 15, 1, 0, 15, 1, 0, 15, 3, 0, 15, 7, 0, 15,
  255, 0, 15, 7, 0, 15, 3, 0, 15, 1, 0, 15, 1, 0, 15, 1,
  0, 15, 1, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0,
  15, 0, 0, 15, 0, 0, 15, 0, 0, 255, 240, 0, 25, 30, 120, 29,
  3, 0, 0, 16, 0, 0, 1, 254, 8, 0, 6, 3, 152, 0, 12, 0,
  248, 0, 28, 0, 248, 0, 24, 0, 120, 0, 56, 0, 56, 0, 56, 0,
  56, 0, 112, 0, 24, 0, 112, 0, 24, 0, 112, 0, 8, 0, 240, 0,
  8, 0, 240, 0, 0, 0, 240, 0, 0, 0, 240, 0, 0, 0, 240, 7,
  255, 128, 240, 0, 120, 0, 240, 0, 120, 0, 240, 0, 120, 0, 240, 0,
  120, 0, 112, 0, 120, 0, 112, 0, 120, 0, 112, 0, 120, 0, 56, 0,
  120, 0, 56, 0, 120, 0, 24, 0, 248, 0, 28, 0, 200, 0, 12, 1,
  136, 0, 6, 3, 8, 0, 1, 254, 8, 0, 28, 29, 116, 33, 3, 0,
  255, 240, 255, 240, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 255, 255, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  255, 240, 255, 240, 12, 29, 58, 17, 3, 0, 255, 240, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0,
  15, 0, 255, 240, 19, 29, 87, 22, 2, 0, 1, 255, 224, 0, 30, 0,
  0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0,
  30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30,
  0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0,
  0, 30, 0, 0, 30, 0, 120, 30, 0, 248, 30, 0, 248, 30, 0, 248,
  30, 0, 192, 28, 0, 192, 28, 0, 64, 24, 0, 96, 48, 0, 31, 224,
  0, 27, 29, 116, 32, 3, 0, 255, 241, 255, 192, 15, 0, 126, 0, 15,
  0, 60, 0, 15, 0, 56, 0, 15, 0, 112, 0, 15, 0, 96, 0, 15,
  0, 192, 0, 15, 1, 128, 0, 15, 3, 0, 0, 15, 6, 0, 0, 15,
  14, 0, 0, 15, 30, 0, 0, 15, 63, 0, 0, 15, 111, 0, 0, 15,
  207, 128, 0, 15, 135, 128, 0, 15, 7, 192, 0, 15, 3, 192, 0, 15,
  3, 224, 0, 15, 3, 224, 0, 15, 1, 240, 0, 15, 1, 240, 0, 15,
  0, 248, 0, 15, 0, 248, 0, 15, 0, 124, 0, 15, 0, 124, 0, 15,
  0, 62, 0, 15, 0, 63, 0, 255, 241, 255, 224, 23, 29, 87, 28, 3,
  0, 255, 248, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0,
  15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15,
  0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0,
  0, 15, 0, 0, 15, 0, 0, 15, 0, 2, 15, 0, 2, 15, 0, 6,
  15, 0, 6, 15, 0, 6, 15, 0, 14, 15, 0, 14, 15, 0, 30, 15,
  0, 62, 15, 0, 254, 255, 255, 254, 30, 29, 116, 35, 3, 0, 255, 128,
  3, 252, 15, 128, 7, 192, 15, 192, 7, 192, 15, 192, 7, 192, 15, 192,
  15, 192, 13, 192, 11, 192, 13, 224, 11, 192, 13, 224, 11, 192, 12, 224,
  27, 192, 12, 240, 19, 192, 12, 240, 19, 192, 12, 112, 51, 192, 12, 112,
  35, 192, 12, 120, 35, 192, 12, 120, 35, 192, 12, 56, 99, 192, 12, 60,
  67, 192, 12, 60, 67, 192, 12, 28, 195, 192, 12, 28, 131, 192, 12, 30,
  131, 192, 12, 14, 131, 192, 12, 15, 131, 192, 12, 15, 3, 192, 12, 15,
  3, 192, 12, 7, 3, 192, 12, 6, 3, 192, 30, 6, 3, 192, 255, 194,
  63, 252, 28, 29, 116, 32, 3, 0, 255, 0, 63, 240, 15, 128, 7, 128,
  15, 128, 3, 0, 15, 192, 3, 0, 15, 224, 3, 0, 13, 224, 3, 0,
  13, 240, 3, 0, 12, 248, 3, 0, 12, 120, 3, 0, 12, 124, 3, 0,
  12, 60, 3, 0, 12, 30, 3, 0, 12, 31, 3, 0, 12, 15, 3, 0,
  12, 7, 131, 0, 12, 7, 131, 0, 12, 3, 195, 0, 12, 3, 227, 0,
  12, 1, 227, 0, 12, 0, 243, 0, 12, 0, 251, 0, 12, 0, 123, 0,
  12, 0, 63, 0, 12, 0, 63, 0, 12, 0, 31, 0, 12, 0, 31, 0,
  12, 0, 15, 0, 30, 0, 7, 0, 255, 192, 7, 0, 24, 29, 87, 29,
  3, 1, 0, 255, 0, 3, 0, 192, 6, 0, 96, 12, 0, 48, 28, 0,
  56, 56, 0, 28, 56, 0, 28, 120, 0, 30, 112, 0, 14, 112, 0, 14,
  240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240,
  0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 112, 0, 14, 112, 0,
  14, 120, 0, 30, 56, 0, 28, 56, 0, 28, 28, 0, 56, 12, 0, 48,
  6, 0, 96, 3, 0, 192, 0, 255, 0, 23, 29, 87, 28, 3, 0, 255,
  255, 128, 15, 0, 224, 15, 0, 120, 15, 0, 60, 15, 0, 60, 15, 0,
  30, 15, 0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 30, 15, 0, 60,
  15, 0, 60, 15, 0, 120, 15, 0, 224, 15, 255, 128, 15, 0, 0, 15,
  0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0,
  0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0,
  15, 0, 0, 255, 248, 0, 24, 36, 108, 29, 3, 250, 0, 255, 0, 3,
  0, 192, 6, 0, 96, 12, 0, 48, 28, 0, 56, 56, 0, 28, 56, 0,
  28, 120, 0, 30, 112, 0, 14, 112, 0, 14, 240, 0, 15, 240, 0, 15,
  240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240, 0, 15, 240,
  0, 15, 240, 0, 15, 112, 0, 14, 120, 0, 30, 120, 0, 30, 56, 60,
  28, 56, 99, 28, 28, 195, 56, 14, 193, 184, 6, 193, 240, 3, 193, 225,
  0, 247, 193, 0, 9, 193, 0, 1, 193, 0, 1, 195, 0, 1, 226, 0,
  1, 254, 0, 0, 252, 0, 0, 56, 25, 29, 116, 29, 3, 0, 255, 255,
  128, 0, 15, 1, 240, 0, 15, 0, 120, 0, 15, 0, 120, 0, 15, 0,
  60, 0, 15, 0, 60, 0, 15, 0, 60, 0, 15, 0, 60, 0, 15, 0,
  60, 0, 15, 0, 120, 0, 15, 0, 240, 0, 15, 1, 224, 0, 15, 255,
  0, 0, 15, 3, 128, 0, 15, 1, 192, 0, 15, 0, 224, 0, 15, 0,
  224, 0, 15, 0, 240, 0, 15, 0, 240, 0, 15, 0, 240, 0, 15, 0,
  240, 0, 15, 0, 240, 0, 15, 0, 248, 128, 15, 0, 120, 128, 15, 0,
  120, 128, 15, 0, 121, 128, 15, 0, 127, 0, 15, 0, 63, 0, 255, 248,
  30, 0, 19, 29, 87, 25, 4, 1, 15, 240, 192, 48, 28, 192, 96, 15,
  192, 96, 7, 192, 192, 3, 192, 192, 1, 192, 192, 1, 192, 192, 0, 192,
  224, 0, 192, 240, 0, 192, 120, 0, 64, 127, 0, 0, 63, 192, 0, 31,
  248, 0, 15, 254, 0, 1, 255, 128, 128, 127, 128, 128, 15, 192, 128, 3,
  224, 128, 1, 224, 192, 0, 224, 192, 0, 96, 224, 0, 96, 224, 0, 96,
  240, 0, 96, 248, 0, 192, 156, 0, 128, 134, 1, 0, 131, 254, 0, 24,
  29, 87, 29, 3, 0, 255, 255, 255, 248, 60, 31, 240, 60, 15, 224, 60,
  7, 192, 60, 3, 192, 60, 3, 192, 60, 3, 128, 60, 1, 128, 60, 1,
  128, 60, 1, 128, 60, 1, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0,
  60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60,
  0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0, 0, 60, 0,
  0, 60, 0, 0, 60, 0, 0, 60, 0, 7, 255, 224, 29, 29, 116, 34,
  3, 0, 255, 240, 31, 248, 15, 0, 3, 192, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0,
  1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 15, 0, 1, 128, 7, 0,
  1, 0, 7, 0, 3, 0, 3, 128, 2, 0, 1, 192, 6, 0, 0, 224,
  24, 0, 0, 63, 240, 0, 29, 29, 116, 32, 2, 0, 255, 248, 63, 248,
  15, 128, 3, 192, 7, 128, 3, 128, 7, 128, 3, 0, 3, 192, 3, 0,
  3, 192, 3, 0, 3, 192, 2, 0, 1, 224, 6, 0, 1, 224, 6, 0,
  1, 240, 4, 0, 0, 240, 12, 0, 0, 240, 12, 0, 0, 248, 8, 0,
  0, 120, 24, 0, 0, 120, 24, 0, 0, 60, 16, 0, 0, 60, 48, 0,
  0, 60, 48, 0, 0, 30, 32, 0, 0, 30, 96, 0, 0, 31, 96, 0,
  0, 15, 64, 0, 0, 15, 192, 0, 0, 15, 192, 0, 0, 7, 128, 0,
  0, 7, 128, 0, 0, 7, 128, 0, 0, 3, 0, 0, 0, 3, 0, 0,
  41, 29, 174, 44, 2, 0, 255, 241, 255, 227, 255, 128, 15, 128, 63, 0,
  124, 0, 7, 128, 30, 0, 56, 0, 7, 128, 30, 0, 48, 0, 7, 128,
  31, 0, 48, 0, 3, 192, 31, 0, 48, 0, 3, 192, 31, 0, 96, 0,
  3, 192, 55, 0, 96, 0, 1, 224, 55, 128, 96, 0, 1, 224, 55, 128,
  64, 0, 1, 224, 39, 128, 192, 0, 1, 224, 99, 192, 192, 0, 0, 240,
  99, 192, 128, 0, 0, 240, 67, 193, 128, 0, 0, 240, 193, 193, 128, 0,
  0, 120, 193, 225, 0, 0, 0, 120, 193, 227, 0, 0, 0, 120, 129, 227,
  0, 0, 0, 125, 128, 242, 0, 0, 0, 61, 128, 246, 0, 0, 0, 61,
  0, 246, 0, 0, 0, 61, 0, 116, 0, 0, 0, 31, 0, 124, 0, 0,
  0, 31, 0, 124, 0, 0, 0, 30, 0, 60, 0, 0, 0, 14, 0, 56,
  0, 0, 0, 14, 0, 56, 0, 0, 0, 12, 0, 56, 0, 0, 0, 12,
  0, 16, 0, 0, 28, 29, 116, 31, 2, 0, 255, 248, 255, 224, 7, 192,
  30, 0, 7, 192, 28, 0, 3, 224, 24, 0, 1, 224, 24, 0, 1, 240,
  48, 0, 0, 240, 32, 0, 0, 248, 96, 0, 0, 120, 192, 0, 0, 124,
  128, 0, 0, 61, 128, 0, 0, 63, 0, 0, 0, 30, 0, 0, 0, 15,
  0, 0, 0, 15, 0, 0, 0, 15, 128, 0, 0, 31, 128, 0, 0, 51,
  192, 0, 0, 51, 224, 0, 0, 97, 224, 0, 0, 193, 240, 0, 0, 192,
  240, 0, 1, 128, 248, 0, 3, 0, 120, 0, 3, 0, 124, 0, 6, 0,
  60, 0, 14, 0, 62, 0, 31, 0, 63, 0, 255, 225, 255, 240, 27, 29,
  116, 30, 2, 0, 255, 248, 127, 224, 15, 128, 31, 0, 15, 128, 14, 0,
  7, 128, 12, 0, 3, 192, 12, 0, 3, 192, 8, 0, 1, 224, 24, 0,
  1, 240, 16, 0, 0, 240, 48, 0, 0, 248, 32, 0, 0, 120, 96, 0,
  0, 60, 64, 0, 0, 60, 192, 0, 0, 30, 128, 0, 0, 31, 0, 0,
  0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0,
  0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0,
  0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0,
  0, 15, 0, 0, 1, 255, 248, 0, 22, 29, 87, 27, 3, 0, 63, 255,
  252, 62, 0, 120, 60, 0, 248, 56, 0, 240, 48, 1, 224, 48, 3, 224,
  96, 3, 192, 96, 7, 128, 64, 15, 128, 64, 15, 0, 0, 31, 0, 0,
  62, 0, 0, 60, 0, 0, 124, 0, 0, 120, 0, 0, 240, 0, 1, 240,
  0, 1, 224, 0, 3, 224, 4, 7, 192, 4, 7, 128, 12, 15, 128, 12,
  31, 0, 12, 31, 0, 28, 62, 0, 28, 60, 0, 60, 124, 0, 120, 248,
  0, 248, 255, 255, 248, 8, 37, 37, 16, 5, 248, 255, 240, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 240, 255,
  14, 38, 76, 18, 2, 248, 192, 0, 64, 0, 96, 0, 96, 0, 32, 0,
  48, 0, 48, 0, 16, 0, 24, 0, 24, 0, 8, 0, 12, 0, 12, 0,
  4, 0, 4, 0, 6, 0, 2, 0, 2, 0, 3, 0, 3, 0, 1, 0,
  1, 128, 1, 128, 0, 128, 0, 192, 0, 192, 0, 64, 0, 96, 0, 96,
  0, 32, 0, 48, 0, 48, 0, 16, 0, 24, 0, 24, 0, 8, 0, 12,
  0, 12, 8, 37, 37, 16, 3, 248, 255, 15, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 15, 255, 18, 14, 42,
  24, 3, 15, 0, 192, 0, 1, 192, 0, 1, 224, 0, 3, 48, 0, 3,
  48, 0, 6, 24, 0, 12, 12, 0, 12, 12, 0, 24, 6, 0, 48, 6,
  0, 48, 3, 0, 96, 1, 128, 224, 1, 128, 192, 0, 192, 21, 2, 6,
  21, 0, 250, 255, 255, 248, 255, 255, 248, 7, 7, 7, 18, 3, 21, 192,
  224, 112, 56, 24, 12, 2, 18, 19, 57, 21, 2, 0, 15, 192, 0, 56,
  112, 0, 32, 56, 0, 96, 28, 0, 120, 28, 0, 120, 28, 0, 56, 28,
  0, 0, 28, 0, 0, 252, 0, 15, 28, 0, 56, 28, 0, 112, 28, 0,
  224, 28, 0, 224, 28, 64, 224, 60, 64, 224, 60, 64, 224, 92, 192, 112,
  159, 128, 31, 15, 0, 18, 29, 87, 21, 1, 0, 252, 0, 0, 28, 0,
  0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0,
  28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 120, 0, 28, 142, 0, 29,
  7, 0, 30, 3, 128, 30, 3, 128, 28, 3, 128, 28, 3, 192, 28, 3,
  192, 28, 3, 192, 28, 3, 192, 28, 3, 192, 28, 3, 192, 28, 3, 192,
  28, 3, 128, 28, 3, 128, 30, 3, 128, 27, 7, 0, 17, 142, 0, 16,
  248, 0, 15, 19, 38, 18, 2, 0, 7, 224, 28, 16, 56, 8, 48, 12,
  112, 28, 112, 60, 240, 60, 240, 24, 240, 0, 240, 0, 240, 0, 240, 0,
  240, 6, 112, 4, 112, 4, 48, 12, 56, 8, 12, 48, 7, 224, 18, 29,
  87, 21, 2, 0, 0, 254, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0,
  0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0,
  14, 0, 15, 142, 0, 28, 78, 0, 56, 46, 0, 112, 30, 0, 112, 30,
  0, 112, 14, 0, 240, 14, 0, 240, 14, 0, 240, 14, 0, 240, 14, 0,
  240, 14, 0, 240, 14, 0, 240, 14, 0, 112, 14, 0, 112, 14, 0, 112,
  30, 0, 56, 62, 0, 24, 110, 0, 7, 207, 192, 15, 19, 38, 19, 2,
  0, 7, 192, 12, 112, 56, 56, 48, 28, 112, 28, 112, 28, 240, 30, 240,
  30, 255, 254, 240, 0, 240, 0, 240, 0, 240, 6, 112, 4, 112, 4, 56,
  4, 56, 8, 28, 16, 7, 224, 14, 29, 58, 14, 1, 0, 1, 240, 7,
  24, 14, 24, 12, 60, 28, 60, 28, 56, 28, 0, 28, 0, 28, 0, 28,
  0, 255, 192, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 255, 192, 20, 28, 84, 22, 2, 247, 7, 225, 192,
  28, 58, 96, 56, 30, 240, 112, 30, 240, 112, 14, 224, 240, 15, 0, 240,
  15, 0, 240, 15, 0, 112, 14, 0, 112, 30, 0, 56, 28, 0, 28, 56,
  0, 7, 224, 0, 56, 0, 0, 64, 0, 0, 192, 0, 0, 240, 0, 0,
  255, 254, 0, 63, 255, 0, 15, 7, 128, 112, 1, 192, 64, 0, 192, 192,
  0, 192, 192, 0, 192, 192, 1, 128, 96, 1, 128, 56, 6, 0, 7, 248,
  0, 20, 29, 87, 22, 1, 0, 252, 0, 0, 28, 0, 0, 28, 0, 0,
  28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28,
  0, 0, 28, 0, 0, 28, 60, 0, 28, 199, 0, 29, 3, 0, 29, 3,
  128, 30, 3, 128, 30, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128,
  28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28,
  3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 255, 159, 240, 8, 28,
  28, 11, 1, 0, 24, 60, 60, 24, 0, 0, 0, 0, 0, 252, 28, 28,
  28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 255,
  11, 37, 74, 14, 255, 247, 0, 192, 1, 224, 1, 224, 0, 192, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 15, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224, 0, 224,
  0, 224, 0, 224, 224, 224, 240, 224, 224, 192, 193, 128, 99, 128, 62, 0,
  19, 29, 87, 21, 1, 0, 252, 0, 0, 28, 0, 0, 28, 0, 0, 28,
  0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 0, 28, 63, 192, 28, 14, 0, 28, 12, 0, 28, 8, 0,
  28, 16, 0, 28, 48, 0, 28, 96, 0, 28, 192, 0, 28, 224, 0, 29,
  224, 0, 30, 240, 0, 30, 120, 0, 28, 60, 0, 28, 60, 0, 28, 30,
  0, 28, 15, 0, 28, 15, 0, 28, 15, 128, 255, 63, 224, 9, 29, 58,
  11, 1, 0, 252, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 255, 128, 31, 19, 76,
  33, 1, 0, 252, 124, 15, 128, 28, 199, 24, 192, 29, 7, 32, 224, 31,
  3, 224, 112, 30, 3, 192, 112, 28, 3, 128, 112, 28, 3, 128, 112, 28,
  3, 128, 112, 28, 3, 128, 112, 28, 3, 128, 112, 28, 3, 128, 112, 28,
  3, 128, 112, 28, 3, 128, 112, 28, 3, 128, 112, 28, 3, 128, 112, 28,
  3, 128, 112, 28, 3, 128, 112, 28, 3, 128, 112, 255, 159, 243, 254, 20,
  19, 57, 22, 1, 0, 252, 60, 0, 28, 199, 0, 29, 3, 0, 31, 3,
  128, 30, 3, 128, 30, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128,
  28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28,
  3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 255, 159, 240, 17, 19,
  57, 21, 2, 0, 3, 224, 0, 12, 56, 0, 24, 28, 0, 56, 14, 0,
  112, 14, 0, 112, 7, 0, 240, 7, 0, 240, 7, 0, 240, 7, 128, 240,
  7, 128, 240, 7, 128, 240, 7, 0, 240, 7, 0, 112, 7, 0, 112, 14,
  0, 56, 14, 0, 24, 28, 0, 12, 56, 0, 3, 224, 0, 18, 28, 84,
  21, 1, 247, 252, 120, 0, 29, 142, 0, 31, 7, 0, 30, 3, 128, 30,
  3, 128, 28, 3, 128, 28, 3, 192, 28, 3, 192, 28, 3, 192, 28, 3,
  192, 28, 3, 192, 28, 3, 192, 28, 3, 192, 28, 3, 128, 28, 3, 128,
  30, 3, 128, 31, 7, 0, 29, 134, 0, 28, 120, 0, 28, 0, 0, 28,
  0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0, 0, 28, 0,
  0, 28, 0, 0, 255, 128, 0, 18, 28, 84, 21, 2, 247, 7, 130, 0,
  28, 98, 0, 56, 54, 0, 112, 22, 0, 112, 30, 0, 112, 14, 0, 240,
  14, 0, 240, 14, 0, 240, 14, 0, 240, 14, 0, 240, 14, 0, 240, 14,
  0, 240, 14, 0, 112, 14, 0, 112, 14, 0, 112, 30, 0, 56, 62, 0,
  24, 110, 0, 7, 206, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0,
  14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 14, 0, 0, 127,
  192, 15, 19, 38, 16, 1, 0, 252, 56, 28, 196, 28, 142, 29, 30, 31,
  28, 30, 12, 30, 0, 30, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 255, 128, 14, 19, 38,
  18, 2, 0, 31, 16, 96, 208, 64, 112, 192, 48, 192, 16, 224, 16, 240,
  0, 126, 0, 63, 128, 31, 224, 3, 248, 128, 252, 192, 28, 192, 12, 224,
  12, 224, 12, 240, 8, 140, 24, 131, 224, 12, 27, 54, 14, 1, 0, 4,
  0, 4, 0, 4, 0, 4, 0, 4, 0, 12, 0, 12, 0, 28, 0, 255,
  224, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28, 0, 28,
  0, 28, 0, 28, 0, 28, 0, 28, 16, 28, 16, 28, 16, 28, 48, 30,
  32, 15, 224, 7, 192, 20, 19, 57, 22, 1, 0, 252, 31, 128, 28, 3,
  128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128,
  28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28, 3, 128, 28,
  3, 128, 28, 7, 128, 28, 7, 128, 28, 15, 128, 12, 11, 128, 14, 51,
  128, 3, 195, 240, 20, 19, 57, 21, 1, 0, 255, 15, 240, 60, 3, 128,
  28, 3, 0, 28, 3, 0, 14, 2, 0, 14, 2, 0, 15, 6, 0, 7,
  4, 0, 7, 4, 0, 3, 140, 0, 3, 136, 0, 3, 200, 0, 1, 216,
  0, 1, 208, 0, 0, 240, 0, 0, 240, 0, 0, 96, 0, 0, 96, 0,
  0, 96, 0, 30, 19, 76, 31, 1, 0, 255, 31, 243, 252, 60, 7, 128,
  224, 28, 3, 128, 192, 28, 3, 128, 192, 14, 3, 192, 128, 14, 3, 192,
  128, 15, 7, 193, 128, 7, 5, 225, 0, 7, 4, 225, 0, 3, 140, 227,
  0, 3, 136, 114, 0, 1, 200, 114, 0, 1, 216, 118, 0, 1, 240, 60,
  0, 0, 240, 60, 0, 0, 240, 60, 0, 0, 96, 24, 0, 0, 96, 24,
  0, 0, 32, 24, 0, 18, 19, 57, 21, 1, 0, 255, 31, 192, 30, 14,
  0, 30, 12, 0, 14, 8, 0, 15, 24, 0, 7, 16, 0, 3, 160, 0,
  3, 224, 0, 1, 192, 0, 1, 224, 0, 1, 224, 0, 1, 112, 0, 3,
  120, 0, 2, 56, 0, 4, 28, 0, 12, 28, 0, 24, 14, 0, 24, 15,
  0, 254, 63, 192, 20, 28, 84, 22, 1, 247, 255, 143, 240, 30, 1, 128,
  30, 1, 128, 14, 1, 0, 14, 1, 0, 15, 3, 0, 7, 2, 0, 7,
  2, 0, 3, 134, 0, 3, 132, 0, 3, 132, 0, 1, 204, 0, 1, 200,
  0, 1, 200, 0, 0, 248, 0, 0, 240, 0, 0, 240, 0, 0, 112, 0,
  0, 96, 0, 0, 96, 0, 0, 96, 0, 0, 64, 0, 48, 64, 0, 120,
  192, 0, 120, 128, 0, 113, 128, 0, 51, 0, 0, 30, 0, 0, 14, 19,
  38, 18, 2, 0, 255, 252, 224, 60, 192, 56, 192, 120, 128, 240, 128, 224,
  129, 224, 1, 192, 3, 128, 7, 128, 7, 0, 15, 0, 30, 4, 28, 4,
  60, 4, 56, 12, 112, 12, 240, 28, 255, 252, 10, 37, 74, 17, 4, 248,
  1, 192, 6, 0, 12, 0, 8, 0, 24, 0, 24, 0, 24, 0, 28, 0,
  28, 0, 12, 0, 14, 0, 14, 0, 14, 0, 6, 0, 6, 0, 6, 0,
  4, 0, 8, 0, 240, 0, 24, 0, 12, 0, 4, 0, 6, 0, 6, 0,
  14, 0, 14, 0, 14, 0, 12, 0, 28, 0, 28, 0, 24, 0, 24, 0,
  24, 0, 8, 0, 12, 0, 6, 0, 1, 192, 2, 38, 38, 12, 5, 248,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 10, 37, 74, 17, 3, 248, 224, 0, 24, 0,
  12, 0, 4, 0, 6, 0, 6, 0, 6, 0, 14, 0, 14, 0, 12, 0,
  28, 0, 28, 0, 28, 0, 24, 0, 24, 0, 24, 0, 8, 0, 4, 0,
  3, 192, 6, 0, 8, 0, 24, 0, 24, 0, 24, 0, 28, 0, 28, 0,
  28, 0, 12, 0, 14, 0, 14, 0, 6, 0, 6, 0, 6, 0, 4, 0,
  12, 0, 24, 0, 224, 0, 23, 8, 24, 27, 2, 7, 30, 0, 8, 127,
  192, 4, 255, 240, 2, 199, 254, 2, 128, 255, 134, 128, 63, 254, 192, 15,
  252, 96, 1, 248, 255
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--49-490-72-72-P-256-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 35, '1' Height: 34
  Calculated Max Values w=49 h=47 x=10 y=28 dx=52 dy= 0 ascent=47 len=252
  Font Bounding box     w=128 h=62 x=-40 y=-15
  Calculated Min Values           x=-2 y=-13 dx= 0 dy= 0
  Pure Font   ascent =35 descent=-10
  X Font      ascent =36 descent=-10
  Max Font    ascent =47 descent=-13
*/
const u8g_fntpgm_uint8_t u8g_font_osr35[22370] U8G_FONT_SECTION("u8g_font_osr35") = {
  0, 128, 62, 216, 241, 35, 12, 236, 30, 116, 32, 255, 246, 47, 243, 36,
  246, 0, 0, 0, 14, 0, 0, 6, 34, 34, 14, 4, 0, 120, 252, 252,
  252, 252, 252, 252, 252, 252, 120, 120, 120, 120, 120, 120, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 48, 0, 0, 0, 120, 252, 252, 252, 120, 11,
  10, 20, 19, 4, 26, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 64, 64, 64, 64, 64, 64, 64, 64, 26, 34, 136, 34, 4, 0, 0,
  48, 24, 0, 0, 48, 24, 0, 0, 112, 24, 0, 0, 96, 24, 0, 0,
  96, 56, 0, 0, 96, 56, 0, 0, 96, 48, 0, 0, 96, 48, 0, 0,
  96, 48, 0, 0, 224, 48, 0, 255, 255, 255, 192, 255, 255, 255, 192, 0,
  192, 96, 0, 0, 192, 96, 0, 0, 192, 96, 0, 1, 192, 96, 0, 1,
  128, 96, 0, 1, 128, 224, 0, 1, 128, 192, 0, 1, 128, 192, 0, 1,
  128, 192, 0, 3, 128, 192, 0, 255, 255, 255, 192, 255, 255, 255, 192, 3,
  1, 128, 0, 3, 1, 128, 0, 3, 1, 128, 0, 7, 1, 128, 0, 7,
  1, 128, 0, 6, 1, 128, 0, 6, 3, 128, 0, 6, 3, 0, 0, 6,
  3, 0, 0, 6, 3, 0, 0, 22, 41, 123, 29, 3, 252, 0, 204, 0,
  0, 204, 0, 0, 204, 0, 1, 254, 0, 7, 207, 192, 12, 204, 96, 24,
  204, 48, 48, 204, 24, 32, 204, 24, 96, 204, 28, 96, 204, 60, 96, 204,
  124, 96, 204, 124, 112, 204, 120, 120, 204, 120, 62, 204, 0, 63, 204, 0,
  31, 252, 0, 15, 252, 0, 7, 255, 128, 1, 255, 192, 0, 255, 224, 0,
  207, 240, 0, 205, 248, 0, 204, 120, 48, 204, 60, 120, 204, 28, 248, 204,
  28, 248, 204, 12, 240, 204, 12, 240, 204, 8, 224, 204, 24, 96, 204, 24,
  96, 204, 48, 48, 204, 96, 28, 205, 192, 7, 255, 128, 0, 204, 0, 0,
  204, 0, 0, 204, 0, 0, 204, 0, 33, 34, 170, 43, 5, 0, 15, 128,
  0, 48, 0, 24, 192, 0, 96, 0, 48, 96, 0, 64, 0, 112, 112, 0,
  192, 0, 96, 48, 1, 128, 0, 224, 56, 1, 128, 0, 224, 56, 3, 0,
  0, 224, 56, 2, 0, 0, 224, 56, 6, 0, 0, 224, 56, 12, 0, 0,
  224, 56, 12, 0, 0, 224, 56, 24, 0, 0, 96, 48, 48, 0, 0, 96,
  112, 48, 0, 0, 48, 96, 96, 0, 0, 24, 192, 64, 0, 0, 15, 128,
  192, 0, 0, 0, 1, 128, 248, 0, 0, 1, 129, 140, 0, 0, 3, 3,
  6, 0, 0, 2, 6, 7, 0, 0, 6, 6, 3, 0, 0, 12, 14, 3,
  128, 0, 8, 14, 3, 128, 0, 24, 14, 3, 128, 0, 48, 14, 3, 128,
  0, 48, 14, 3, 128, 0, 96, 14, 3, 128, 0, 64, 14, 3, 128, 0,
  192, 6, 3, 0, 1, 128, 6, 3, 0, 1, 128, 7, 7, 0, 3, 0,
  3, 14, 0, 6, 0, 1, 252, 0, 33, 34, 170, 39, 3, 0, 0, 63,
  0, 0, 0, 0, 227, 128, 0, 0, 1, 128, 192, 0, 0, 3, 128, 64,
  0, 0, 3, 0, 96, 0, 0, 7, 0, 96, 0, 0, 7, 0, 96, 0,
  0, 7, 0, 224, 0, 0, 7, 0, 192, 0, 0, 7, 129, 192, 0, 0,
  7, 131, 128, 0, 0, 3, 199, 0, 0, 0, 3, 238, 0, 0, 0, 1,
  248, 0, 0, 0, 0, 248, 7, 255, 128, 1, 248, 0, 252, 0, 3, 252,
  0, 112, 0, 7, 62, 0, 112, 0, 14, 63, 0, 96, 0, 28, 31, 0,
  96, 0, 60, 15, 128, 192, 0, 56, 7, 192, 192, 0, 120, 7, 193, 128,
  0, 120, 3, 225, 128, 0, 240, 1, 243, 0, 0, 240, 1, 254, 0, 0,
  240, 0, 254, 0, 0, 240, 0, 124, 0, 0, 248, 0, 62, 0, 0, 248,
  0, 62, 1, 0, 120, 0, 127, 1, 0, 60, 0, 207, 130, 0, 30, 3,
  135, 252, 0, 15, 254, 1, 248, 0, 3, 10, 10, 11, 4, 26, 224, 224,
  224, 224, 224, 224, 64, 64, 64, 64, 11, 46, 92, 18, 5, 246, 0, 64,
  0, 224, 1, 192, 3, 128, 3, 0, 6, 0, 14, 0, 12, 0, 28, 0,
  24, 0, 56, 0, 48, 0, 48, 0, 112, 0, 96, 0, 96, 0, 96, 0,
  224, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 192, 0, 224, 0, 96, 0, 96, 0, 96, 0, 112, 0,
  48, 0, 48, 0, 56, 0, 24, 0, 28, 0, 12, 0, 14, 0, 6, 0,
  3, 0, 3, 128, 1, 192, 0, 224, 0, 64, 11, 45, 90, 18, 2, 246,
  64, 0, 96, 0, 112, 0, 56, 0, 28, 0, 12, 0, 14, 0, 6, 0,
  3, 0, 3, 0, 3, 128, 1, 128, 1, 192, 0, 192, 0, 192, 0, 192,
  0, 224, 0, 96, 0, 96, 0, 96, 0, 96, 0, 96, 0, 96, 0, 96,
  0, 96, 0, 96, 0, 96, 0, 96, 0, 96, 0, 224, 0, 192, 0, 192,
  0, 192, 1, 128, 1, 128, 3, 128, 3, 0, 7, 0, 6, 0, 14, 0,
  12, 0, 24, 0, 56, 0, 112, 0, 224, 0, 18, 20, 60, 25, 4, 14,
  0, 224, 0, 1, 224, 0, 1, 224, 0, 1, 224, 0, 224, 195, 128, 240,
  135, 192, 248, 143, 192, 60, 159, 128, 3, 248, 0, 1, 224, 0, 3, 240,
  0, 30, 190, 0, 124, 143, 128, 248, 135, 192, 240, 195, 192, 97, 193, 128,
  1, 224, 0, 1, 224, 0, 1, 224, 0, 0, 224, 0, 41, 41, 246, 45,
  2, 248, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0,
  12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0,
  0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0,
  0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0,
  12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0,
  0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0,
  0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0,
  12, 0, 0, 0, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255, 255, 128,
  0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0,
  0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0,
  12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0,
  0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0,
  0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0,
  12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0,
  0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0,
  0, 0, 0, 0, 12, 0, 0, 0, 7, 15, 15, 14, 4, 247, 120, 252,
  252, 254, 126, 6, 6, 6, 4, 12, 8, 24, 48, 96, 64, 12, 3, 6,
  18, 3, 11, 255, 240, 255, 240, 255, 240, 6, 5, 5, 14, 4, 1, 120,
  252, 252, 252, 120, 16, 46, 92, 22, 3, 246, 0, 3, 0, 3, 0, 3,
  0, 6, 0, 6, 0, 6, 0, 12, 0, 12, 0, 12, 0, 24, 0, 24,
  0, 24, 0, 48, 0, 48, 0, 48, 0, 48, 0, 96, 0, 96, 0, 96,
  0, 192, 0, 192, 0, 192, 1, 128, 1, 128, 1, 128, 3, 0, 3, 0,
  3, 0, 6, 0, 6, 0, 6, 0, 12, 0, 12, 0, 12, 0, 24, 0,
  24, 0, 24, 0, 48, 0, 48, 0, 48, 0, 96, 0, 96, 0, 96, 0,
  96, 0, 192, 0, 192, 0, 23, 34, 102, 28, 2, 0, 0, 124, 0, 1,
  199, 0, 7, 1, 128, 6, 0, 192, 14, 0, 224, 28, 0, 112, 60, 0,
  120, 60, 0, 120, 56, 0, 56, 120, 0, 60, 120, 0, 60, 120, 0, 60,
  248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248,
  0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 120, 0,
  60, 120, 0, 60, 120, 0, 60, 120, 0, 60, 60, 0, 120, 60, 0, 120,
  28, 0, 112, 28, 0, 112, 14, 0, 224, 7, 1, 192, 3, 131, 128, 0,
  254, 0, 17, 34, 102, 28, 6, 0, 0, 64, 0, 0, 64, 0, 0, 192,
  0, 0, 192, 0, 1, 192, 0, 7, 192, 0, 255, 192, 0, 3, 192, 0,
  3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192,
  0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0,
  3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 0, 255, 255, 128, 255, 255, 128, 21, 34,
  102, 28, 4, 0, 3, 252, 0, 14, 31, 0, 16, 7, 192, 32, 3, 224,
  96, 1, 240, 64, 1, 240, 192, 0, 240, 192, 0, 248, 224, 0, 248, 252,
  0, 248, 254, 0, 248, 126, 0, 248, 126, 0, 240, 62, 1, 240, 0, 1,
  224, 0, 3, 192, 0, 3, 128, 0, 7, 0, 0, 14, 0, 0, 28, 0,
  0, 112, 0, 0, 224, 0, 1, 192, 0, 3, 0, 0, 6, 0, 16, 12,
  0, 16, 24, 0, 16, 16, 0, 16, 48, 0, 48, 48, 0, 112, 127, 255,
  240, 127, 255, 240, 127, 255, 240, 127, 255, 240, 21, 34, 102, 28, 4, 0,
  3, 248, 0, 14, 31, 0, 24, 7, 128, 48, 3, 192, 112, 3, 192, 120,
  1, 224, 124, 1, 224, 126, 1, 224, 126, 1, 224, 60, 1, 224, 0, 1,
  224, 0, 3, 192, 0, 3, 192, 0, 7, 128, 0, 14, 0, 15, 248, 0,
  31, 143, 0, 14, 3, 128, 0, 3, 224, 0, 1, 224, 0, 1, 240, 0,
  0, 248, 0, 0, 248, 0, 0, 248, 60, 0, 248, 126, 0, 248, 254, 0,
  248, 254, 0, 248, 252, 1, 240, 224, 1, 240, 224, 3, 224, 96, 3, 192,
  48, 15, 0, 15, 254, 0, 23, 34, 102, 28, 3, 0, 0, 1, 128, 0,
  1, 128, 0, 3, 128, 0, 7, 128, 0, 7, 128, 0, 15, 128, 0, 31,
  128, 0, 31, 128, 0, 55, 128, 0, 119, 128, 0, 231, 128, 0, 199, 128,
  1, 199, 128, 3, 135, 128, 3, 7, 128, 6, 7, 128, 14, 7, 128, 12,
  7, 128, 24, 7, 128, 56, 7, 128, 48, 7, 128, 96, 7, 128, 224, 7,
  128, 255, 255, 254, 0, 7, 128, 0, 7, 128, 0, 7, 128, 0, 7, 128,
  0, 7, 128, 0, 7, 128, 0, 7, 128, 0, 7, 128, 3, 255, 254, 3,
  255, 254, 21, 35, 105, 28, 4, 0, 48, 0, 64, 60, 3, 192, 63, 255,
  128, 63, 255, 0, 63, 252, 0, 55, 240, 0, 48, 0, 0, 48, 0, 0,
  48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 51,
  254, 0, 60, 7, 128, 56, 3, 192, 48, 1, 224, 48, 1, 240, 48, 1,
  240, 0, 0, 240, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248,
  60, 0, 248, 126, 0, 248, 254, 0, 248, 254, 0, 240, 252, 1, 240, 248,
  1, 224, 240, 1, 224, 112, 3, 192, 112, 7, 128, 60, 31, 0, 15, 252,
  0, 21, 34, 102, 28, 4, 0, 0, 126, 0, 1, 193, 128, 3, 128, 192,
  7, 0, 64, 14, 0, 224, 28, 1, 224, 28, 3, 224, 56, 3, 224, 56,
  3, 192, 120, 0, 0, 120, 0, 0, 120, 0, 0, 120, 0, 0, 240, 126,
  0, 241, 255, 128, 243, 131, 192, 247, 1, 224, 254, 1, 240, 252, 0, 240,
  252, 0, 240, 248, 0, 248, 248, 0, 120, 248, 0, 120, 248, 0, 120, 120,
  0, 120, 120, 0, 120, 120, 0, 248, 120, 0, 240, 56, 0, 240, 60, 0,
  224, 28, 1, 224, 14, 3, 192, 7, 7, 128, 1, 254, 0, 19, 34, 102,
  28, 5, 0, 255, 255, 224, 255, 255, 224, 255, 255, 224, 255, 255, 224, 224,
  0, 224, 192, 0, 64, 128, 0, 64, 128, 0, 192, 128, 0, 128, 128, 1,
  128, 0, 1, 128, 0, 3, 0, 0, 2, 0, 0, 6, 0, 0, 12, 0,
  0, 24, 0, 0, 24, 0, 0, 48, 0, 0, 112, 0, 0, 112, 0, 0,
  224, 0, 0, 224, 0, 1, 224, 0, 1, 224, 0, 3, 224, 0, 3, 224,
  0, 3, 224, 0, 7, 240, 0, 7, 240, 0, 7, 240, 0, 7, 240, 0,
  7, 240, 0, 3, 240, 0, 3, 224, 0, 23, 34, 102, 28, 3, 0, 1,
  254, 0, 7, 135, 128, 30, 1, 192, 56, 0, 224, 120, 0, 112, 112, 0,
  112, 240, 0, 56, 240, 0, 56, 240, 0, 56, 240, 0, 56, 248, 0, 56,
  252, 0, 112, 126, 0, 112, 127, 192, 224, 63, 241, 192, 31, 255, 0, 7,
  255, 128, 7, 255, 224, 12, 63, 248, 56, 7, 252, 112, 1, 252, 112, 0,
  126, 224, 0, 62, 224, 0, 62, 224, 0, 62, 224, 0, 30, 224, 0, 30,
  224, 0, 28, 96, 0, 60, 112, 0, 56, 48, 0, 120, 24, 0, 240, 14,
  1, 192, 3, 255, 0, 21, 34, 102, 28, 4, 0, 1, 248, 0, 7, 142,
  0, 14, 3, 0, 28, 1, 128, 56, 1, 192, 120, 1, 224, 120, 0, 224,
  120, 0, 240, 240, 0, 240, 240, 0, 240, 240, 0, 240, 240, 0, 248, 240,
  0, 248, 248, 0, 248, 120, 1, 248, 120, 1, 248, 120, 3, 248, 60, 7,
  120, 30, 14, 120, 15, 252, 120, 3, 240, 120, 0, 0, 240, 0, 0, 240,
  0, 0, 240, 0, 0, 240, 60, 0, 224, 124, 0, 224, 124, 1, 192, 124,
  1, 192, 120, 3, 128, 112, 3, 0, 56, 6, 0, 28, 28, 0, 15, 248,
  0, 6, 22, 22, 14, 4, 1, 120, 252, 252, 252, 120, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 120, 252, 252, 252, 120, 7, 31, 31,
  14, 4, 248, 120, 252, 252, 252, 120, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 120, 252, 252, 254, 126, 14, 6, 6, 4, 12, 8, 24, 48,
  96, 64, 38, 40, 200, 46, 4, 249, 0, 0, 0, 0, 28, 0, 0, 0,
  0, 120, 0, 0, 0, 1, 240, 0, 0, 0, 7, 192, 0, 0, 0, 15,
  0, 0, 0, 0, 60, 0, 0, 0, 0, 240, 0, 0, 0, 3, 192, 0,
  0, 0, 15, 0, 0, 0, 0, 62, 0, 0, 0, 0, 248, 0, 0, 0,
  1, 224, 0, 0, 0, 7, 128, 0, 0, 0, 30, 0, 0, 0, 0, 120,
  0, 0, 0, 1, 224, 0, 0, 0, 7, 192, 0, 0, 0, 31, 0, 0,
  0, 0, 60, 0, 0, 0, 0, 240, 0, 0, 0, 0, 240, 0, 0, 0,
  0, 124, 0, 0, 0, 0, 31, 0, 0, 0, 0, 7, 128, 0, 0, 0,
  1, 224, 0, 0, 0, 0, 120, 0, 0, 0, 0, 30, 0, 0, 0, 0,
  7, 128, 0, 0, 0, 3, 224, 0, 0, 0, 0, 248, 0, 0, 0, 0,
  60, 0, 0, 0, 0, 15, 0, 0, 0, 0, 3, 192, 0, 0, 0, 0,
  240, 0, 0, 0, 0, 60, 0, 0, 0, 0, 31, 0, 0, 0, 0, 7,
  192, 0, 0, 0, 1, 224, 0, 0, 0, 0, 120, 0, 0, 0, 0, 28,
  41, 11, 66, 45, 2, 7, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255,
  255, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
  255, 128, 255, 255, 255, 255, 255, 128, 38, 40, 200, 46, 4, 249, 224, 0,
  0, 0, 0, 120, 0, 0, 0, 0, 62, 0, 0, 0, 0, 15, 128, 0,
  0, 0, 3, 192, 0, 0, 0, 0, 240, 0, 0, 0, 0, 60, 0, 0,
  0, 0, 15, 0, 0, 0, 0, 3, 192, 0, 0, 0, 1, 240, 0, 0,
  0, 0, 124, 0, 0, 0, 0, 30, 0, 0, 0, 0, 7, 128, 0, 0,
  0, 1, 224, 0, 0, 0, 0, 120, 0, 0, 0, 0, 30, 0, 0, 0,
  0, 15, 128, 0, 0, 0, 3, 224, 0, 0, 0, 0, 240, 0, 0, 0,
  0, 60, 0, 0, 0, 0, 60, 0, 0, 0, 0, 248, 0, 0, 0, 3,
  224, 0, 0, 0, 7, 128, 0, 0, 0, 30, 0, 0, 0, 0, 120, 0,
  0, 0, 1, 224, 0, 0, 0, 7, 128, 0, 0, 0, 31, 0, 0, 0,
  0, 124, 0, 0, 0, 0, 240, 0, 0, 0, 3, 192, 0, 0, 0, 15,
  0, 0, 0, 0, 60, 0, 0, 0, 0, 240, 0, 0, 0, 3, 224, 0,
  0, 0, 15, 128, 0, 0, 0, 30, 0, 0, 0, 0, 120, 0, 0, 0,
  0, 224, 0, 0, 0, 0, 18, 34, 102, 23, 3, 0, 7, 240, 0, 28,
  60, 0, 48, 15, 0, 96, 7, 128, 192, 7, 128, 192, 3, 192, 192, 3,
  192, 248, 3, 192, 252, 3, 192, 124, 7, 192, 56, 7, 128, 0, 15, 128,
  0, 31, 0, 0, 62, 0, 0, 124, 0, 0, 240, 0, 0, 224, 0, 1,
  192, 0, 3, 0, 0, 6, 0, 0, 14, 8, 0, 12, 8, 0, 12, 8,
  0, 12, 8, 0, 6, 16, 0, 3, 224, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 1, 224, 0, 3, 240, 0, 3, 240, 0, 3, 240, 0, 1,
  224, 0, 35, 36, 180, 40, 2, 0, 0, 3, 254, 0, 0, 0, 30, 7,
  192, 0, 0, 112, 0, 112, 0, 1, 192, 0, 24, 0, 3, 128, 0, 12,
  0, 7, 0, 0, 6, 0, 14, 0, 0, 3, 0, 28, 0, 120, 1, 0,
  24, 1, 196, 225, 128, 56, 7, 7, 224, 128, 48, 14, 3, 224, 192, 112,
  12, 3, 192, 192, 96, 28, 3, 192, 64, 96, 56, 3, 192, 96, 224, 56,
  3, 192, 96, 192, 120, 3, 128, 96, 192, 112, 7, 128, 96, 192, 112, 7,
  128, 96, 192, 240, 7, 128, 96, 192, 224, 7, 0, 96, 192, 224, 15, 0,
  224, 192, 224, 15, 0, 192, 192, 224, 14, 0, 192, 96, 224, 30, 1, 128,
  96, 224, 62, 1, 128, 96, 224, 62, 3, 0, 96, 96, 78, 6, 0, 48,
  49, 143, 12, 0, 48, 31, 7, 240, 0, 24, 0, 0, 0, 0, 12, 0,
  0, 0, 0, 6, 0, 0, 0, 0, 3, 0, 0, 0, 0, 1, 192, 0,
  112, 0, 0, 112, 1, 192, 0, 0, 31, 255, 0, 0, 34, 35, 175, 37,
  2, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 224, 0,
  0, 0, 1, 224, 0, 0, 0, 1, 224, 0, 0, 0, 3, 240, 0, 0,
  0, 3, 240, 0, 0, 0, 3, 240, 0, 0, 0, 6, 248, 0, 0, 0,
  6, 248, 0, 0, 0, 6, 248, 0, 0, 0, 12, 124, 0, 0, 0, 12,
  124, 0, 0, 0, 12, 124, 0, 0, 0, 24, 62, 0, 0, 0, 24, 62,
  0, 0, 0, 24, 30, 0, 0, 0, 48, 31, 0, 0, 0, 48, 31, 0,
  0, 0, 48, 15, 0, 0, 0, 96, 15, 128, 0, 0, 96, 15, 128, 0,
  0, 96, 7, 128, 0, 0, 255, 255, 192, 0, 0, 255, 255, 192, 0, 0,
  192, 3, 192, 0, 1, 128, 3, 224, 0, 1, 128, 3, 224, 0, 3, 128,
  1, 224, 0, 3, 0, 1, 240, 0, 3, 0, 1, 240, 0, 7, 0, 0,
  240, 0, 7, 0, 0, 248, 0, 31, 128, 1, 252, 0, 255, 248, 31, 255,
  192, 28, 35, 140, 34, 3, 0, 255, 255, 240, 0, 7, 192, 62, 0, 7,
  128, 15, 0, 7, 128, 7, 128, 7, 128, 3, 192, 7, 128, 1, 224, 7,
  128, 1, 224, 7, 128, 1, 224, 7, 128, 1, 224, 7, 128, 1, 224, 7,
  128, 1, 224, 7, 128, 1, 224, 7, 128, 3, 192, 7, 128, 3, 128, 7,
  128, 7, 0, 7, 128, 30, 0, 7, 255, 240, 0, 7, 128, 62, 0, 7,
  128, 15, 0, 7, 128, 7, 128, 7, 128, 3, 192, 7, 128, 3, 224, 7,
  128, 1, 224, 7, 128, 1, 240, 7, 128, 1, 240, 7, 128, 1, 240, 7,
  128, 1, 240, 7, 128, 1, 240, 7, 128, 1, 240, 7, 128, 3, 224, 7,
  128, 3, 224, 7, 128, 7, 192, 7, 128, 15, 128, 7, 192, 62, 0, 255,
  255, 240, 0, 26, 36, 144, 32, 3, 0, 0, 63, 0, 128, 0, 225, 224,
  128, 3, 128, 113, 128, 7, 0, 63, 128, 14, 0, 31, 128, 30, 0, 15,
  128, 28, 0, 7, 128, 60, 0, 3, 128, 60, 0, 3, 128, 124, 0, 3,
  128, 120, 0, 1, 128, 120, 0, 1, 128, 120, 0, 0, 128, 248, 0, 0,
  128, 248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0,
  0, 248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0,
  0, 248, 0, 0, 0, 120, 0, 0, 192, 120, 0, 0, 192, 120, 0, 0,
  192, 60, 0, 0, 192, 60, 0, 0, 128, 60, 0, 1, 128, 28, 0, 1,
  128, 14, 0, 3, 0, 14, 0, 3, 0, 7, 0, 6, 0, 3, 128, 12,
  0, 0, 224, 56, 0, 0, 127, 224, 0, 33, 35, 175, 38, 3, 0, 255,
  255, 252, 0, 0, 7, 192, 15, 0, 0, 7, 128, 3, 192, 0, 7, 128,
  0, 224, 0, 7, 128, 0, 112, 0, 7, 128, 0, 120, 0, 7, 128, 0,
  60, 0, 7, 128, 0, 62, 0, 7, 128, 0, 30, 0, 7, 128, 0, 31,
  0, 7, 128, 0, 31, 0, 7, 128, 0, 15, 0, 7, 128, 0, 15, 0,
  7, 128, 0, 15, 128, 7, 128, 0, 15, 128, 7, 128, 0, 15, 128, 7,
  128, 0, 15, 128, 7, 128, 0, 15, 128, 7, 128, 0, 15, 128, 7, 128,
  0, 15, 128, 7, 128, 0, 15, 128, 7, 128, 0, 15, 128, 7, 128, 0,
  15, 0, 7, 128, 0, 31, 0, 7, 128, 0, 31, 0, 7, 128, 0, 30,
  0, 7, 128, 0, 30, 0, 7, 128, 0, 60, 0, 7, 128, 0, 60, 0,
  7, 128, 0, 120, 0, 7, 128, 0, 112, 0, 7, 128, 0, 224, 0, 7,
  128, 3, 192, 0, 7, 192, 15, 0, 0, 255, 255, 252, 0, 0, 28, 35,
  140, 34, 3, 0, 255, 255, 255, 240, 7, 192, 7, 240, 7, 128, 1, 240,
  7, 128, 0, 240, 7, 128, 0, 112, 7, 128, 0, 112, 7, 128, 0, 48,
  7, 128, 0, 48, 7, 128, 0, 48, 7, 128, 0, 16, 7, 128, 32, 16,
  7, 128, 32, 16, 7, 128, 32, 0, 7, 128, 96, 0, 7, 128, 96, 0,
  7, 128, 96, 0, 7, 128, 224, 0, 7, 255, 224, 0, 7, 129, 224, 0,
  7, 128, 96, 0, 7, 128, 96, 0, 7, 128, 96, 0, 7, 128, 32, 16,
  7, 128, 32, 16, 7, 128, 32, 16, 7, 128, 0, 16, 7, 128, 0, 48,
  7, 128, 0, 48, 7, 128, 0, 48, 7, 128, 0, 112, 7, 128, 0, 112,
  7, 128, 0, 240, 7, 128, 1, 240, 255, 255, 255, 240, 255, 255, 255, 240,
  27, 35, 140, 34, 4, 0, 255, 255, 255, 224, 15, 128, 15, 224, 7, 128,
  3, 224, 7, 128, 1, 224, 7, 128, 0, 224, 7, 128, 0, 224, 7, 128,
  0, 96, 7, 128, 0, 96, 7, 128, 0, 96, 7, 128, 0, 32, 7, 128,
  32, 32, 7, 128, 32, 32, 7, 128, 32, 0, 7, 128, 96, 0, 7, 128,
  96, 0, 7, 128, 96, 0, 7, 128, 224, 0, 7, 255, 224, 0, 7, 129,
  224, 0, 7, 128, 96, 0, 7, 128, 96, 0, 7, 128, 96, 0, 7, 128,
  32, 0, 7, 128, 32, 0, 7, 128, 32, 0, 7, 128, 0, 0, 7, 128,
  0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128,
  0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 15, 128, 0, 0, 255, 254,
  0, 0, 30, 36, 144, 34, 3, 0, 0, 63, 128, 192, 0, 224, 224, 192,
  3, 128, 56, 192, 7, 0, 29, 192, 14, 0, 15, 192, 14, 0, 7, 192,
  28, 0, 7, 192, 60, 0, 3, 192, 60, 0, 3, 192, 124, 0, 1, 192,
  120, 0, 1, 192, 120, 0, 0, 192, 120, 0, 0, 192, 248, 0, 0, 192,
  248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0, 0,
  248, 0, 255, 252, 248, 0, 255, 252, 248, 0, 7, 192, 248, 0, 7, 192,
  248, 0, 7, 192, 248, 0, 7, 192, 120, 0, 7, 192, 120, 0, 7, 192,
  124, 0, 7, 192, 60, 0, 7, 192, 60, 0, 7, 192, 28, 0, 15, 192,
  30, 0, 15, 192, 14, 0, 28, 192, 7, 0, 24, 192, 3, 0, 48, 192,
  1, 192, 224, 192, 0, 127, 128, 192, 33, 35, 175, 38, 3, 0, 255, 252,
  31, 255, 128, 7, 192, 0, 248, 0, 7, 128, 0, 240, 0, 7, 128, 0,
  240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240,
  0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0,
  7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7,
  128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 255,
  255, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0,
  240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240,
  0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0,
  7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7,
  128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128,
  0, 240, 0, 7, 192, 0, 248, 0, 255, 252, 31, 255, 128, 14, 35, 70,
  19, 3, 0, 255, 252, 7, 192, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 192, 255, 252, 23, 35, 105, 27, 2, 0, 0,
  127, 254, 0, 7, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192,
  0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0,
  3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 60, 3, 192, 126, 3, 192, 254, 3, 192,
  254, 3, 192, 252, 3, 192, 224, 3, 128, 224, 7, 128, 96, 7, 0, 112,
  14, 0, 56, 28, 0, 15, 248, 0, 32, 35, 140, 37, 3, 0, 255, 252,
  63, 254, 7, 192, 15, 240, 7, 128, 7, 192, 7, 128, 3, 128, 7, 128,
  7, 0, 7, 128, 6, 0, 7, 128, 12, 0, 7, 128, 28, 0, 7, 128,
  56, 0, 7, 128, 112, 0, 7, 128, 224, 0, 7, 129, 192, 0, 7, 129,
  128, 0, 7, 131, 128, 0, 7, 135, 128, 0, 7, 143, 192, 0, 7, 155,
  224, 0, 7, 179, 224, 0, 7, 225, 240, 0, 7, 193, 240, 0, 7, 128,
  248, 0, 7, 128, 248, 0, 7, 128, 124, 0, 7, 128, 124, 0, 7, 128,
  62, 0, 7, 128, 62, 0, 7, 128, 31, 0, 7, 128, 31, 0, 7, 128,
  15, 128, 7, 128, 15, 192, 7, 128, 7, 192, 7, 128, 7, 224, 7, 128,
  3, 224, 7, 192, 7, 248, 255, 252, 127, 255, 27, 35, 140, 33, 3, 0,
  255, 254, 0, 0, 7, 192, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 32, 7, 128, 0, 96,
  7, 128, 0, 96, 7, 128, 0, 96, 7, 128, 0, 96, 7, 128, 0, 224,
  7, 128, 0, 224, 7, 128, 0, 224, 7, 128, 1, 224, 7, 128, 3, 224,
  7, 128, 7, 224, 255, 255, 255, 224, 255, 255, 255, 224, 36, 35, 175, 41,
  3, 0, 255, 224, 0, 63, 240, 7, 224, 0, 62, 0, 7, 224, 0, 126,
  0, 7, 240, 0, 94, 0, 7, 240, 0, 94, 0, 6, 240, 0, 222, 0,
  6, 248, 0, 222, 0, 6, 248, 0, 158, 0, 6, 120, 0, 158, 0, 6,
  120, 1, 158, 0, 6, 124, 1, 158, 0, 6, 60, 1, 30, 0, 6, 60,
  1, 30, 0, 6, 62, 3, 30, 0, 6, 62, 3, 30, 0, 6, 30, 2,
  30, 0, 6, 30, 2, 30, 0, 6, 31, 6, 30, 0, 6, 15, 4, 30,
  0, 6, 15, 4, 30, 0, 6, 15, 140, 30, 0, 6, 7, 140, 30, 0,
  6, 7, 136, 30, 0, 6, 7, 200, 30, 0, 6, 7, 216, 30, 0, 6,
  3, 216, 30, 0, 6, 3, 208, 30, 0, 6, 3, 240, 30, 0, 6, 1,
  240, 30, 0, 6, 1, 240, 30, 0, 6, 1, 224, 30, 0, 6, 0, 224,
  30, 0, 15, 0, 224, 30, 0, 31, 128, 192, 62, 0, 255, 240, 195, 255,
  240, 33, 36, 180, 38, 3, 255, 255, 192, 7, 255, 128, 7, 192, 0, 252,
  0, 7, 224, 0, 120, 0, 7, 240, 0, 48, 0, 7, 240, 0, 48, 0,
  7, 248, 0, 48, 0, 6, 248, 0, 48, 0, 6, 124, 0, 48, 0, 6,
  126, 0, 48, 0, 6, 62, 0, 48, 0, 6, 31, 0, 48, 0, 6, 31,
  0, 48, 0, 6, 15, 128, 48, 0, 6, 15, 192, 48, 0, 6, 7, 192,
  48, 0, 6, 3, 224, 48, 0, 6, 3, 224, 48, 0, 6, 1, 240, 48,
  0, 6, 1, 248, 48, 0, 6, 0, 248, 48, 0, 6, 0, 124, 48, 0,
  6, 0, 124, 48, 0, 6, 0, 62, 48, 0, 6, 0, 63, 48, 0, 6,
  0, 31, 48, 0, 6, 0, 15, 176, 0, 6, 0, 15, 176, 0, 6, 0,
  7, 240, 0, 6, 0, 7, 240, 0, 6, 0, 3, 240, 0, 6, 0, 1,
  240, 0, 6, 0, 1, 240, 0, 15, 0, 0, 240, 0, 31, 128, 0, 112,
  0, 255, 240, 0, 112, 0, 0, 0, 0, 48, 0, 28, 36, 144, 33, 3,
  0, 0, 31, 128, 0, 0, 240, 240, 0, 1, 192, 56, 0, 3, 128, 28,
  0, 7, 0, 14, 0, 14, 0, 7, 0, 30, 0, 7, 128, 28, 0, 3,
  128, 60, 0, 3, 192, 60, 0, 3, 192, 124, 0, 3, 224, 120, 0, 1,
  224, 120, 0, 1, 224, 248, 0, 1, 224, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 120, 0, 1,
  224, 120, 0, 1, 224, 124, 0, 3, 224, 124, 0, 3, 224, 60, 0, 3,
  192, 60, 0, 3, 192, 30, 0, 7, 128, 14, 0, 7, 0, 14, 0, 15,
  0, 7, 0, 14, 0, 3, 128, 28, 0, 0, 224, 112, 0, 0, 127, 224,
  0, 28, 35, 140, 33, 3, 0, 255, 255, 240, 0, 7, 192, 30, 0, 7,
  128, 7, 128, 7, 128, 7, 192, 7, 128, 3, 224, 7, 128, 3, 224, 7,
  128, 1, 240, 7, 128, 1, 240, 7, 128, 1, 240, 7, 128, 1, 240, 7,
  128, 1, 240, 7, 128, 1, 240, 7, 128, 3, 224, 7, 128, 3, 224, 7,
  128, 7, 192, 7, 128, 7, 128, 7, 128, 30, 0, 7, 255, 248, 0, 7,
  128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7,
  128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7,
  128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7,
  128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 192, 0, 0, 255,
  254, 0, 0, 28, 44, 176, 33, 3, 248, 0, 31, 128, 0, 0, 240, 240,
  0, 1, 192, 56, 0, 3, 128, 28, 0, 7, 0, 14, 0, 14, 0, 7,
  0, 30, 0, 7, 128, 28, 0, 3, 128, 60, 0, 3, 192, 60, 0, 3,
  192, 124, 0, 3, 224, 120, 0, 1, 224, 120, 0, 1, 224, 248, 0, 1,
  224, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 120, 0, 1, 224, 120, 0, 1, 224, 124, 0, 3,
  224, 124, 0, 3, 224, 60, 15, 3, 192, 60, 25, 195, 192, 30, 48, 199,
  128, 14, 96, 231, 128, 15, 96, 111, 0, 7, 96, 126, 0, 3, 224, 124,
  16, 0, 240, 120, 16, 0, 127, 240, 16, 0, 0, 112, 16, 0, 0, 112,
  16, 0, 0, 120, 48, 0, 0, 120, 32, 0, 0, 124, 96, 0, 0, 63,
  192, 0, 0, 63, 192, 0, 0, 15, 0, 30, 35, 140, 35, 3, 0, 255,
  255, 248, 0, 7, 192, 62, 0, 7, 128, 15, 128, 7, 128, 7, 192, 7,
  128, 7, 192, 7, 128, 3, 224, 7, 128, 3, 224, 7, 128, 3, 224, 7,
  128, 3, 224, 7, 128, 3, 224, 7, 128, 3, 192, 7, 128, 7, 192, 7,
  128, 7, 128, 7, 128, 15, 0, 7, 128, 60, 0, 7, 255, 224, 0, 7,
  128, 240, 0, 7, 128, 56, 0, 7, 128, 28, 0, 7, 128, 30, 0, 7,
  128, 30, 0, 7, 128, 31, 0, 7, 128, 15, 0, 7, 128, 15, 0, 7,
  128, 15, 0, 7, 128, 15, 0, 7, 128, 15, 128, 7, 128, 15, 132, 7,
  128, 15, 132, 7, 128, 15, 132, 7, 128, 15, 132, 7, 128, 15, 140, 7,
  128, 7, 248, 7, 192, 7, 248, 255, 254, 3, 240, 23, 36, 108, 30, 4,
  0, 3, 240, 0, 14, 28, 24, 56, 7, 24, 48, 3, 248, 112, 1, 248,
  96, 0, 248, 224, 0, 120, 224, 0, 56, 224, 0, 56, 224, 0, 56, 224,
  0, 24, 240, 0, 24, 248, 0, 8, 126, 0, 8, 127, 192, 0, 63, 240,
  0, 31, 252, 0, 15, 255, 128, 3, 255, 224, 0, 255, 240, 128, 63, 248,
  128, 7, 252, 128, 1, 252, 192, 0, 126, 192, 0, 62, 192, 0, 30, 224,
  0, 14, 224, 0, 14, 240, 0, 14, 240, 0, 14, 248, 0, 12, 252, 0,
  28, 222, 0, 24, 199, 0, 48, 195, 128, 96, 128, 255, 192, 28, 35, 140,
  35, 4, 0, 255, 255, 255, 240, 254, 15, 131, 240, 248, 15, 1, 240, 240,
  15, 0, 240, 224, 15, 0, 112, 192, 15, 0, 112, 192, 15, 0, 48, 192,
  15, 0, 48, 192, 15, 0, 48, 128, 15, 0, 16, 128, 15, 0, 16, 128,
  15, 0, 16, 128, 15, 0, 16, 0, 15, 0, 0, 0, 15, 0, 0, 0,
  15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0,
  15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0,
  15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0,
  15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0,
  15, 0, 0, 0, 15, 0, 0, 0, 15, 128, 0, 3, 255, 254, 0, 34,
  35, 175, 39, 3, 0, 255, 252, 3, 255, 192, 7, 192, 0, 126, 0, 7,
  128, 0, 60, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128,
  0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0,
  24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24,
  0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0,
  7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7,
  128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128,
  0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0,
  24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 3, 192, 0, 24,
  0, 3, 192, 0, 48, 0, 3, 192, 0, 48, 0, 1, 224, 0, 96, 0,
  0, 224, 0, 96, 0, 0, 112, 0, 192, 0, 0, 60, 3, 128, 0, 0,
  15, 254, 0, 0, 34, 36, 180, 37, 2, 255, 255, 255, 7, 255, 192, 15,
  240, 0, 126, 0, 3, 224, 0, 56, 0, 3, 224, 0, 56, 0, 3, 240,
  0, 48, 0, 1, 240, 0, 48, 0, 1, 240, 0, 48, 0, 0, 248, 0,
  96, 0, 0, 248, 0, 96, 0, 0, 248, 0, 96, 0, 0, 124, 0, 192,
  0, 0, 124, 0, 192, 0, 0, 124, 0, 192, 0, 0, 62, 0, 192, 0,
  0, 62, 1, 128, 0, 0, 62, 1, 128, 0, 0, 31, 1, 128, 0, 0,
  31, 3, 0, 0, 0, 31, 3, 0, 0, 0, 15, 131, 0, 0, 0, 15,
  134, 0, 0, 0, 15, 134, 0, 0, 0, 7, 198, 0, 0, 0, 7, 204,
  0, 0, 0, 3, 204, 0, 0, 0, 3, 236, 0, 0, 0, 3, 232, 0,
  0, 0, 1, 248, 0, 0, 0, 1, 248, 0, 0, 0, 1, 248, 0, 0,
  0, 0, 240, 0, 0, 0, 0, 240, 0, 0, 0, 0, 240, 0, 0, 0,
  0, 96, 0, 0, 0, 0, 96, 0, 0, 0, 0, 96, 0, 0, 49, 36,
  252, 52, 2, 255, 255, 254, 127, 255, 15, 255, 128, 15, 240, 15, 248, 1,
  248, 0, 3, 224, 3, 240, 0, 240, 0, 3, 224, 3, 224, 0, 96, 0,
  3, 224, 3, 240, 0, 96, 0, 1, 240, 3, 240, 0, 96, 0, 1, 240,
  3, 240, 0, 192, 0, 1, 240, 3, 240, 0, 192, 0, 0, 240, 7, 248,
  0, 192, 0, 0, 248, 6, 248, 0, 128, 0, 0, 248, 6, 248, 1, 128,
  0, 0, 248, 6, 124, 1, 128, 0, 0, 120, 14, 124, 1, 128, 0, 0,
  124, 12, 124, 3, 0, 0, 0, 124, 12, 62, 3, 0, 0, 0, 60, 28,
  62, 3, 0, 0, 0, 60, 24, 62, 6, 0, 0, 0, 60, 24, 30, 6,
  0, 0, 0, 62, 24, 31, 6, 0, 0, 0, 30, 56, 31, 12, 0, 0,
  0, 30, 48, 31, 12, 0, 0, 0, 30, 48, 15, 140, 0, 0, 0, 15,
  48, 15, 152, 0, 0, 0, 15, 112, 15, 152, 0, 0, 0, 15, 96, 7,
  216, 0, 0, 0, 15, 96, 7, 208, 0, 0, 0, 7, 224, 7, 240, 0,
  0, 0, 7, 192, 3, 240, 0, 0, 0, 7, 192, 3, 240, 0, 0, 0,
  3, 192, 3, 224, 0, 0, 0, 3, 192, 3, 224, 0, 0, 0, 3, 128,
  1, 224, 0, 0, 0, 1, 128, 1, 192, 0, 0, 0, 1, 128, 1, 192,
  0, 0, 0, 1, 128, 0, 192, 0, 0, 0, 1, 0, 0, 128, 0, 0,
  33, 35, 175, 36, 2, 0, 127, 255, 31, 255, 0, 3, 240, 3, 240, 0,
  1, 240, 1, 224, 0, 1, 240, 1, 192, 0, 0, 248, 1, 128, 0, 0,
  120, 3, 0, 0, 0, 124, 3, 0, 0, 0, 60, 6, 0, 0, 0, 62,
  14, 0, 0, 0, 31, 12, 0, 0, 0, 31, 24, 0, 0, 0, 15, 152,
  0, 0, 0, 15, 176, 0, 0, 0, 7, 224, 0, 0, 0, 7, 224, 0,
  0, 0, 3, 224, 0, 0, 0, 3, 224, 0, 0, 0, 1, 240, 0, 0,
  0, 3, 240, 0, 0, 0, 3, 248, 0, 0, 0, 6, 248, 0, 0, 0,
  14, 124, 0, 0, 0, 12, 124, 0, 0, 0, 24, 62, 0, 0, 0, 56,
  62, 0, 0, 0, 48, 31, 0, 0, 0, 96, 31, 0, 0, 0, 224, 15,
  128, 0, 0, 192, 15, 128, 0, 1, 128, 7, 192, 0, 3, 128, 7, 192,
  0, 3, 128, 3, 224, 0, 7, 128, 3, 240, 0, 31, 192, 3, 248, 0,
  255, 248, 63, 255, 128, 32, 35, 140, 35, 2, 0, 255, 254, 15, 255, 15,
  224, 1, 248, 7, 224, 0, 240, 3, 224, 0, 96, 3, 240, 0, 64, 1,
  240, 0, 192, 1, 248, 0, 128, 0, 248, 0, 128, 0, 252, 1, 0, 0,
  124, 3, 0, 0, 62, 2, 0, 0, 62, 6, 0, 0, 31, 4, 0, 0,
  31, 12, 0, 0, 15, 136, 0, 0, 7, 216, 0, 0, 7, 208, 0, 0,
  3, 240, 0, 0, 3, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0,
  1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0,
  1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0,
  1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0,
  1, 240, 0, 0, 127, 255, 192, 26, 35, 140, 32, 3, 0, 63, 255, 255,
  192, 63, 128, 15, 128, 62, 0, 31, 128, 60, 0, 31, 0, 56, 0, 62,
  0, 56, 0, 62, 0, 48, 0, 124, 0, 48, 0, 252, 0, 96, 0, 248,
  0, 96, 1, 240, 0, 64, 3, 240, 0, 64, 3, 224, 0, 0, 7, 192,
  0, 0, 7, 192, 0, 0, 15, 128, 0, 0, 31, 128, 0, 0, 31, 0,
  0, 0, 62, 0, 0, 0, 126, 0, 0, 0, 124, 0, 0, 0, 252, 0,
  0, 0, 248, 0, 64, 1, 240, 0, 64, 3, 240, 0, 64, 3, 224, 0,
  192, 7, 192, 0, 192, 7, 192, 0, 192, 15, 128, 1, 192, 31, 128, 1,
  192, 31, 0, 3, 192, 62, 0, 3, 192, 126, 0, 7, 192, 124, 0, 15,
  128, 248, 0, 63, 128, 255, 255, 255, 128, 10, 45, 90, 19, 6, 247, 255,
  192, 254, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 240, 0, 254, 0, 255, 192, 16, 46, 92, 22, 3, 246, 192,
  0, 192, 0, 192, 0, 96, 0, 96, 0, 96, 0, 48, 0, 48, 0, 48,
  0, 24, 0, 24, 0, 24, 0, 12, 0, 12, 0, 12, 0, 6, 0, 6,
  0, 6, 0, 2, 0, 3, 0, 3, 0, 3, 0, 1, 128, 1, 128, 1,
  128, 0, 192, 0, 192, 0, 192, 0, 96, 0, 96, 0, 96, 0, 48, 0,
  48, 0, 48, 0, 24, 0, 24, 0, 24, 0, 12, 0, 12, 0, 12, 0,
  6, 0, 6, 0, 6, 0, 3, 0, 3, 0, 3, 10, 45, 90, 19, 3,
  247, 255, 192, 31, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 31, 192, 255, 192, 22, 18, 54, 28, 3,
  17, 0, 16, 0, 0, 48, 0, 0, 56, 0, 0, 120, 0, 0, 108, 0,
  0, 206, 0, 1, 198, 0, 1, 131, 0, 3, 3, 0, 7, 1, 128, 6,
  1, 192, 14, 0, 192, 28, 0, 96, 24, 0, 112, 56, 0, 48, 48, 0,
  56, 96, 0, 24, 224, 0, 12, 25, 2, 8, 25, 0, 248, 255, 255, 255,
  128, 255, 255, 255, 128, 8, 9, 9, 22, 4, 25, 224, 240, 240, 120, 60,
  12, 6, 3, 1, 21, 22, 66, 24, 2, 1, 7, 248, 0, 24, 30, 0,
  16, 15, 0, 48, 7, 0, 56, 7, 128, 60, 7, 128, 62, 7, 128, 28,
  7, 128, 0, 7, 128, 0, 31, 128, 3, 247, 128, 31, 7, 128, 60, 7,
  128, 120, 7, 128, 248, 7, 128, 240, 7, 128, 240, 15, 136, 240, 15, 136,
  240, 23, 136, 248, 23, 152, 120, 39, 240, 63, 195, 240, 22, 35, 105, 25,
  1, 0, 255, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0,
  0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0,
  15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 31, 128, 15, 32, 224, 15,
  64, 240, 15, 192, 112, 15, 128, 120, 15, 128, 120, 15, 0, 120, 15, 0,
  60, 15, 0, 60, 15, 0, 60, 15, 0, 60, 15, 0, 60, 15, 0, 60,
  15, 0, 60, 15, 0, 60, 15, 0, 120, 15, 0, 120, 15, 128, 120, 13,
  128, 112, 12, 192, 224, 12, 96, 224, 8, 63, 128, 17, 22, 66, 21, 2,
  1, 7, 252, 0, 14, 6, 0, 28, 3, 0, 56, 3, 0, 56, 3, 128,
  120, 15, 128, 120, 15, 128, 240, 15, 128, 240, 7, 0, 240, 0, 0, 240,
  0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 128, 120, 0,
  128, 120, 0, 128, 56, 1, 0, 56, 1, 0, 28, 2, 0, 14, 6, 0,
  7, 248, 0, 22, 35, 105, 25, 2, 0, 0, 63, 192, 0, 3, 192, 0,
  3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192,
  15, 227, 192, 28, 19, 192, 60, 11, 192, 56, 15, 192, 120, 7, 192, 120,
  7, 192, 120, 3, 192, 240, 3, 192, 240, 3, 192, 240, 3, 192, 240, 3,
  192, 240, 3, 192, 240, 3, 192, 240, 3, 192, 240, 3, 192, 120, 3, 192,
  120, 3, 192, 120, 7, 192, 56, 7, 192, 60, 15, 192, 28, 27, 192, 7,
  243, 252, 18, 22, 66, 22, 2, 1, 7, 248, 0, 14, 28, 0, 28, 14,
  0, 56, 15, 0, 56, 7, 128, 120, 7, 128, 120, 7, 128, 240, 7, 192,
  240, 7, 192, 240, 7, 192, 255, 255, 192, 240, 0, 0, 240, 0, 0, 240,
  0, 0, 240, 0, 128, 120, 0, 128, 120, 0, 128, 120, 1, 128, 56, 1,
  0, 28, 3, 0, 14, 6, 0, 7, 252, 0, 16, 35, 70, 16, 1, 0,
  0, 248, 3, 198, 7, 3, 15, 7, 14, 15, 14, 15, 30, 15, 30, 6,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 255, 240, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 255, 240, 23, 33, 99, 27, 3, 246, 7, 252, 124, 30,
  14, 206, 60, 7, 142, 124, 7, 158, 120, 3, 222, 120, 3, 192, 120, 3,
  192, 120, 3, 192, 120, 3, 192, 120, 3, 192, 60, 7, 128, 28, 7, 128,
  14, 14, 0, 3, 248, 0, 28, 0, 0, 96, 0, 0, 192, 0, 0, 192,
  0, 0, 224, 0, 0, 255, 255, 128, 127, 255, 224, 15, 255, 240, 28, 0,
  112, 48, 0, 56, 96, 0, 24, 192, 0, 24, 192, 0, 24, 192, 0, 24,
  192, 0, 48, 96, 0, 48, 120, 0, 96, 30, 7, 192, 3, 254, 0, 24,
  35, 105, 27, 1, 0, 255, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0,
  0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0,
  15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 15, 192, 15,
  48, 240, 15, 96, 112, 15, 64, 120, 15, 128, 120, 15, 128, 120, 15, 0,
  120, 15, 0, 120, 15, 0, 120, 15, 0, 120, 15, 0, 120, 15, 0, 120,
  15, 0, 120, 15, 0, 120, 15, 0, 120, 15, 0, 120, 15, 0, 120, 15,
  0, 120, 15, 0, 120, 15, 0, 120, 15, 0, 120, 255, 195, 255, 10, 34,
  68, 14, 2, 0, 28, 0, 62, 0, 62, 0, 62, 0, 28, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 255, 192, 13, 45, 90, 16, 254, 245, 0, 112,
  0, 248, 0, 248, 0, 248, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 15, 248, 0, 120, 0, 120, 0, 120, 0, 120,
  0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120,
  0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120,
  0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 240, 120, 240, 120, 240, 112,
  224, 240, 96, 224, 115, 192, 31, 0, 22, 35, 105, 24, 1, 0, 254, 0,
  0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0,
  30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30,
  0, 0, 30, 0, 0, 30, 15, 252, 30, 3, 224, 30, 1, 128, 30, 3,
  0, 30, 6, 0, 30, 6, 0, 30, 12, 0, 30, 24, 0, 30, 48, 0,
  30, 120, 0, 30, 248, 0, 30, 188, 0, 31, 190, 0, 31, 30, 0, 30,
  15, 0, 30, 15, 128, 30, 7, 128, 30, 3, 192, 30, 3, 224, 30, 1,
  224, 30, 3, 240, 255, 207, 252, 11, 35, 70, 13, 1, 0, 254, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 255, 224, 36, 22, 110, 40, 2, 1, 254, 63, 129, 252, 0, 30, 97,
  195, 14, 0, 30, 193, 230, 15, 0, 30, 128, 228, 7, 128, 31, 0, 248,
  7, 128, 31, 0, 248, 7, 128, 30, 0, 240, 7, 128, 30, 0, 240, 7,
  128, 30, 0, 240, 7, 128, 30, 0, 240, 7, 128, 30, 0, 240, 7, 128,
  30, 0, 240, 7, 128, 30, 0, 240, 7, 128, 30, 0, 240, 7, 128, 30,
  0, 240, 7, 128, 30, 0, 240, 7, 128, 30, 0, 240, 7, 128, 30, 0,
  240, 7, 128, 30, 0, 240, 7, 128, 30, 0, 240, 7, 128, 30, 0, 240,
  7, 128, 255, 199, 254, 63, 240, 23, 22, 66, 27, 2, 1, 254, 31, 128,
  30, 97, 224, 30, 192, 224, 30, 128, 240, 31, 0, 240, 31, 0, 240, 30,
  0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0,
  240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240,
  30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 255, 199, 254, 19,
  22, 66, 24, 2, 1, 3, 252, 0, 14, 14, 0, 28, 7, 0, 60, 3,
  128, 56, 3, 192, 120, 3, 192, 120, 1, 224, 248, 1, 224, 240, 1, 224,
  240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240,
  1, 224, 120, 1, 224, 120, 3, 192, 56, 3, 192, 60, 3, 128, 28, 7,
  0, 14, 14, 0, 3, 252, 0, 22, 33, 99, 25, 1, 246, 254, 63, 128,
  30, 97, 192, 30, 192, 224, 31, 128, 112, 31, 0, 120, 31, 0, 120, 30,
  0, 120, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0,
  60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 120, 30, 0, 120,
  31, 0, 120, 31, 0, 112, 31, 128, 224, 30, 192, 192, 30, 127, 128, 30,
  0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0,
  0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 255, 224, 0,
  22, 33, 99, 25, 2, 246, 7, 240, 64, 28, 24, 192, 28, 12, 192, 56,
  12, 192, 120, 7, 192, 120, 7, 192, 120, 3, 192, 240, 3, 192, 240, 3,
  192, 240, 3, 192, 240, 3, 192, 240, 3, 192, 240, 3, 192, 240, 3, 192,
  240, 3, 192, 120, 3, 192, 120, 3, 192, 120, 7, 192, 56, 7, 192, 60,
  15, 192, 28, 27, 192, 7, 243, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192,
  0, 3, 192, 0, 3, 192, 0, 31, 252, 17, 22, 66, 20, 2, 1, 254,
  31, 0, 30, 35, 128, 30, 67, 128, 30, 207, 128, 30, 143, 128, 31, 143,
  0, 31, 2, 0, 31, 0, 0, 31, 0, 0, 30, 0, 0, 30, 0, 0,
  30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30,
  0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 255, 192,
  0, 17, 22, 66, 22, 3, 1, 31, 226, 0, 112, 50, 0, 96, 30, 0,
  192, 14, 0, 192, 6, 0, 224, 2, 0, 240, 2, 0, 252, 0, 0, 127,
  0, 0, 63, 192, 0, 31, 248, 0, 7, 254, 0, 128, 255, 0, 192, 31,
  0, 192, 7, 128, 224, 3, 128, 224, 1, 128, 240, 1, 128, 240, 1, 128,
  248, 3, 0, 198, 7, 0, 131, 252, 0, 14, 32, 64, 17, 1, 0, 2,
  0, 2, 0, 2, 0, 2, 0, 2, 0, 6, 0, 6, 0, 6, 0, 14,
  0, 30, 0, 255, 248, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 4, 30, 4, 30, 4, 30, 12, 15, 8, 15, 248, 7, 240, 23,
  22, 66, 27, 2, 0, 254, 7, 240, 30, 0, 240, 30, 0, 240, 30, 0,
  240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240,
  30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30,
  0, 240, 30, 1, 240, 30, 1, 240, 30, 1, 240, 30, 2, 240, 14, 6,
  240, 15, 12, 240, 3, 240, 254, 24, 23, 69, 26, 1, 255, 255, 225, 255,
  31, 0, 124, 15, 0, 48, 15, 0, 48, 15, 0, 32, 7, 128, 96, 7,
  128, 96, 3, 192, 64, 3, 192, 192, 1, 192, 192, 1, 224, 128, 1, 225,
  128, 0, 241, 128, 0, 241, 0, 0, 113, 0, 0, 123, 0, 0, 58, 0,
  0, 62, 0, 0, 62, 0, 0, 28, 0, 0, 28, 0, 0, 12, 0, 0,
  8, 0, 36, 23, 115, 38, 1, 255, 255, 231, 255, 31, 240, 31, 1, 248,
  7, 128, 31, 0, 240, 3, 0, 15, 0, 120, 3, 0, 15, 0, 120, 2,
  0, 7, 128, 120, 6, 0, 7, 128, 252, 6, 0, 3, 128, 252, 4, 0,
  3, 192, 188, 12, 0, 3, 192, 158, 12, 0, 1, 225, 158, 8, 0, 1,
  225, 14, 24, 0, 0, 225, 15, 24, 0, 0, 243, 15, 16, 0, 0, 242,
  7, 48, 0, 0, 114, 7, 176, 0, 0, 126, 7, 160, 0, 0, 62, 3,
  224, 0, 0, 60, 3, 192, 0, 0, 28, 1, 192, 0, 0, 28, 1, 192,
  0, 0, 24, 1, 128, 0, 0, 8, 0, 128, 0, 22, 22, 66, 26, 2,
  0, 255, 207, 248, 31, 3, 192, 31, 3, 128, 15, 3, 0, 7, 131, 0,
  7, 198, 0, 3, 196, 0, 1, 236, 0, 1, 248, 0, 0, 240, 0, 0,
  112, 0, 0, 120, 0, 0, 124, 0, 0, 220, 0, 1, 158, 0, 1, 15,
  0, 3, 15, 0, 6, 7, 128, 4, 7, 192, 12, 3, 192, 28, 3, 224,
  255, 15, 252, 24, 33, 99, 26, 1, 245, 255, 225, 255, 31, 0, 120, 15,
  0, 48, 15, 0, 48, 7, 0, 32, 7, 128, 96, 7, 128, 96, 3, 192,
  64, 3, 192, 192, 3, 192, 192, 1, 224, 128, 1, 225, 128, 0, 225, 128,
  0, 241, 128, 0, 241, 0, 0, 115, 0, 0, 123, 0, 0, 122, 0, 0,
  62, 0, 0, 62, 0, 0, 60, 0, 0, 28, 0, 0, 28, 0, 0, 24,
  0, 0, 24, 0, 0, 24, 0, 24, 48, 0, 60, 48, 0, 60, 48, 0,
  60, 96, 0, 56, 96, 0, 31, 192, 0, 15, 0, 0, 17, 22, 66, 22,
  2, 0, 255, 255, 128, 248, 7, 128, 224, 15, 0, 224, 31, 0, 192, 30,
  0, 192, 60, 0, 128, 124, 0, 128, 120, 0, 0, 240, 0, 1, 240, 0,
  1, 224, 0, 3, 192, 0, 7, 192, 0, 7, 128, 128, 15, 0, 128, 31,
  0, 128, 30, 0, 128, 60, 1, 128, 124, 1, 128, 120, 3, 128, 240, 15,
  128, 255, 255, 128, 11, 45, 90, 21, 6, 247, 0, 224, 1, 128, 7, 0,
  14, 0, 12, 0, 28, 0, 28, 0, 28, 0, 28, 0, 30, 0, 30, 0,
  14, 0, 14, 0, 15, 0, 15, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  6, 0, 4, 0, 24, 0, 224, 0, 56, 0, 12, 0, 6, 0, 6, 0,
  7, 0, 7, 0, 7, 0, 15, 0, 15, 0, 15, 0, 14, 0, 30, 0,
  30, 0, 28, 0, 28, 0, 28, 0, 28, 0, 12, 0, 12, 0, 6, 0,
  3, 128, 0, 224, 2, 46, 46, 14, 6, 246, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 11, 45, 90, 20, 4, 247, 192, 0,
  112, 0, 28, 0, 12, 0, 6, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  15, 0, 15, 0, 14, 0, 30, 0, 30, 0, 30, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 12, 0, 4, 0, 3, 0, 0, 224, 3, 0, 6, 0,
  12, 0, 28, 0, 28, 0, 28, 0, 28, 0, 30, 0, 30, 0, 30, 0,
  14, 0, 15, 0, 15, 0, 7, 0, 7, 0, 7, 0, 7, 0, 6, 0,
  6, 0, 12, 0, 56, 0, 224, 0, 28, 9, 36, 32, 2, 8, 31, 128,
  0, 192, 127, 240, 0, 96, 127, 252, 0, 48, 227, 255, 0, 48, 192, 127,
  224, 48, 192, 31, 248, 112, 192, 3, 255, 224, 96, 0, 255, 192, 48, 0,
  31, 128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 0, 0, 0, 14, 0, 0, 6, 33, 33, 14, 4, 246, 120,
  252, 252, 252, 120, 0, 0, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
  48, 120, 120, 120, 120, 120, 120, 248, 252, 252, 252, 252, 252, 252, 252, 120,
  17, 34, 102, 28, 5, 250, 0, 192, 0, 0, 192, 0, 0, 192, 0, 0,
  192, 0, 0, 192, 0, 0, 192, 0, 7, 252, 0, 14, 198, 0, 28, 195,
  0, 56, 195, 128, 120, 195, 128, 120, 207, 128, 120, 207, 128, 248, 207, 128,
  240, 199, 0, 240, 192, 0, 240, 192, 0, 240, 192, 0, 240, 192, 0, 240,
  192, 0, 248, 192, 128, 120, 192, 128, 120, 192, 128, 120, 193, 128, 56, 193,
  0, 28, 195, 0, 14, 198, 0, 7, 252, 0, 0, 192, 0, 0, 192, 0,
  0, 192, 0, 0, 192, 0, 0, 192, 0, 0, 192, 0, 28, 34, 136, 35,
  3, 0, 0, 0, 126, 0, 0, 1, 227, 128, 0, 3, 128, 192, 0, 7,
  0, 192, 0, 14, 0, 224, 0, 14, 1, 224, 0, 28, 3, 224, 0, 28,
  3, 224, 0, 60, 3, 192, 0, 60, 0, 128, 0, 60, 0, 0, 0, 60,
  0, 0, 0, 60, 0, 0, 0, 60, 0, 0, 0, 60, 0, 0, 31, 252,
  0, 0, 0, 127, 248, 0, 0, 124, 0, 0, 0, 124, 0, 0, 0, 60,
  0, 0, 0, 60, 0, 0, 0, 60, 0, 0, 0, 60, 0, 0, 0, 60,
  0, 0, 0, 56, 0, 0, 0, 56, 0, 16, 62, 56, 0, 32, 99, 240,
  0, 32, 193, 240, 0, 96, 128, 120, 0, 64, 128, 254, 0, 192, 128, 159,
  255, 128, 193, 7, 255, 0, 126, 1, 254, 0, 24, 24, 72, 28, 2, 5,
  64, 0, 2, 224, 126, 7, 115, 255, 206, 63, 129, 252, 30, 0, 120, 28,
  0, 56, 56, 0, 24, 48, 0, 12, 48, 0, 12, 96, 0, 6, 96, 0,
  6, 96, 0, 6, 96, 0, 6, 96, 0, 6, 96, 0, 6, 112, 0, 12,
  48, 0, 12, 56, 0, 28, 28, 0, 56, 30, 0, 120, 63, 129, 252, 115,
  255, 206, 224, 126, 7, 64, 0, 2, 27, 33, 132, 29, 1, 0, 255, 224,
  127, 224, 31, 0, 15, 0, 15, 0, 6, 0, 15, 128, 6, 0, 7, 128,
  12, 0, 7, 192, 12, 0, 3, 192, 24, 0, 3, 224, 24, 0, 1, 224,
  48, 0, 1, 240, 32, 0, 0, 240, 96, 0, 0, 248, 64, 0, 0, 248,
  192, 0, 0, 124, 128, 0, 0, 125, 128, 0, 0, 63, 0, 0, 0, 63,
  0, 0, 15, 255, 252, 0, 0, 30, 0, 0, 0, 30, 0, 0, 0, 30,
  0, 0, 15, 255, 252, 0, 0, 30, 0, 0, 0, 30, 0, 0, 0, 30,
  0, 0, 0, 30, 0, 0, 0, 30, 0, 0, 0, 30, 0, 0, 0, 30,
  0, 0, 0, 30, 0, 0, 0, 30, 0, 0, 0, 31, 0, 0, 3, 255,
  240, 0, 2, 44, 44, 14, 6, 248, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 0, 0, 0, 0, 0, 0,
  0, 0, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 18, 43, 129, 31, 5, 247, 1, 240, 0, 6, 24, 0,
  12, 12, 0, 24, 30, 0, 56, 62, 0, 56, 62, 0, 56, 62, 0, 56,
  8, 0, 60, 0, 0, 30, 0, 0, 31, 0, 0, 15, 128, 0, 7, 192,
  0, 15, 224, 0, 25, 240, 0, 48, 252, 0, 96, 126, 0, 64, 63, 0,
  192, 15, 128, 192, 7, 128, 192, 3, 192, 224, 1, 192, 240, 0, 192, 120,
  0, 192, 124, 0, 192, 62, 0, 128, 31, 1, 128, 15, 131, 0, 7, 198,
  0, 3, 248, 0, 1, 240, 0, 0, 248, 0, 0, 124, 0, 0, 60, 0,
  0, 30, 0, 0, 14, 0, 30, 14, 0, 62, 14, 0, 62, 14, 0, 60,
  12, 0, 24, 28, 0, 12, 56, 0, 7, 224, 0, 14, 5, 10, 22, 4,
  27, 112, 56, 248, 124, 248, 124, 248, 124, 112, 56, 35, 36, 180, 40, 3,
  0, 0, 7, 252, 0, 0, 0, 60, 7, 128, 0, 0, 224, 0, 192, 0,
  1, 128, 0, 48, 0, 3, 0, 0, 24, 0, 4, 0, 0, 12, 0, 8,
  0, 0, 6, 0, 24, 1, 240, 131, 0, 48, 7, 28, 129, 0, 32, 30,
  7, 128, 128, 96, 28, 3, 128, 128, 64, 56, 1, 128, 64, 64, 120, 1,
  128, 64, 192, 120, 0, 128, 64, 128, 120, 0, 128, 96, 128, 248, 0, 0,
  32, 128, 240, 0, 0, 32, 128, 240, 0, 0, 32, 128, 240, 0, 0, 32,
  128, 240, 0, 0, 32, 128, 240, 0, 0, 32, 128, 240, 0, 0, 32, 128,
  248, 0, 128, 96, 64, 120, 0, 128, 64, 64, 120, 0, 128, 64, 96, 56,
  1, 128, 192, 32, 60, 1, 0, 128, 48, 30, 3, 1, 128, 16, 15, 14,
  3, 0, 24, 3, 248, 2, 0, 12, 0, 0, 6, 0, 6, 0, 0, 12,
  0, 3, 128, 0, 56, 0, 0, 192, 0, 96, 0, 0, 120, 3, 192, 0,
  0, 31, 254, 0, 0, 13, 17, 34, 19, 3, 17, 62, 0, 99, 0, 193,
  128, 225, 128, 225, 128, 3, 128, 13, 128, 49, 128, 113, 128, 225, 128, 225,
  136, 225, 136, 247, 152, 120, 240, 0, 0, 0, 0, 255, 240, 13, 19, 38,
  23, 5, 1, 4, 0, 12, 24, 24, 48, 48, 32, 112, 96, 96, 96, 96,
  192, 224, 192, 224, 192, 224, 192, 224, 192, 224, 192, 224, 192, 96, 192, 112,
  96, 48, 96, 56, 48, 24, 16, 12, 0, 23, 10, 30, 29, 3, 8, 255,
  255, 254, 255, 255, 254, 0, 0, 6, 0, 0, 6, 0, 0, 6, 0, 0,
  6, 0, 0, 6, 0, 0, 6, 0, 0, 6, 0, 0, 6, 12, 3, 6,
  18, 3, 11, 255, 240, 255, 240, 255, 240, 35, 36, 180, 40, 3, 0, 0,
  7, 252, 0, 0, 0, 60, 7, 128, 0, 0, 224, 0, 192, 0, 1, 128,
  0, 48, 0, 3, 0, 0, 24, 0, 4, 0, 0, 12, 0, 8, 0, 0,
  6, 0, 25, 255, 248, 3, 0, 48, 60, 30, 1, 0, 32, 60, 15, 0,
  128, 96, 60, 7, 128, 128, 64, 60, 7, 128, 64, 64, 60, 7, 128, 64,
  192, 60, 7, 128, 64, 128, 60, 7, 128, 96, 128, 60, 15, 0, 32, 128,
  60, 30, 0, 32, 128, 63, 240, 0, 32, 128, 60, 28, 0, 32, 128, 60,
  14, 0, 32, 128, 60, 7, 0, 32, 128, 60, 7, 0, 32, 128, 60, 7,
  128, 96, 64, 60, 7, 128, 64, 64, 60, 7, 132, 64, 64, 60, 7, 132,
  192, 32, 60, 7, 136, 128, 48, 60, 3, 201, 128, 17, 255, 129, 241, 0,
  24, 0, 0, 2, 0, 12, 0, 0, 6, 0, 6, 0, 0, 12, 0, 3,
  0, 0, 24, 0, 0, 192, 0, 96, 0, 0, 112, 1, 192, 0, 0, 31,
  254, 0, 0, 13, 2, 4, 21, 4, 28, 255, 248, 255, 248, 14, 13, 26,
  29, 8, 21, 15, 192, 56, 96, 112, 48, 96, 24, 192, 8, 192, 12, 192,
  12, 192, 12, 192, 12, 96, 24, 96, 24, 56, 112, 15, 192, 41, 34, 204,
  45, 2, 254, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0,
  0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0,
  0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12,
  0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0,
  0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0,
  0, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255, 255, 128, 0, 0, 12,
  0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0,
  0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0,
  0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12,
  0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0,
  0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255, 255, 128, 14,
  21, 42, 22, 4, 13, 15, 192, 49, 240, 96, 120, 192, 124, 192, 60, 224,
  60, 248, 60, 120, 60, 48, 120, 0, 112, 0, 224, 1, 192, 3, 128, 6,
  0, 12, 0, 48, 4, 32, 4, 96, 12, 127, 248, 255, 248, 255, 248, 14,
  21, 42, 22, 5, 13, 15, 192, 56, 224, 96, 112, 96, 56, 112, 56, 120,
  56, 48, 56, 0, 112, 0, 224, 63, 128, 56, 224, 0, 120, 0, 56, 0,
  60, 112, 60, 248, 60, 240, 60, 192, 56, 192, 120, 96, 240, 31, 192, 8,
  9, 9, 22, 10, 25, 7, 15, 15, 30, 60, 48, 96, 192, 128, 25, 36,
  144, 29, 3, 243, 112, 1, 192, 0, 240, 3, 192, 0, 240, 3, 224, 0,
  240, 3, 224, 0, 240, 3, 224, 0, 240, 3, 224, 0, 240, 3, 224, 0,
  240, 3, 224, 0, 240, 3, 224, 0, 240, 3, 224, 0, 224, 3, 224, 0,
  224, 1, 192, 0, 224, 1, 192, 0, 96, 1, 192, 0, 96, 1, 192, 0,
  96, 1, 192, 0, 96, 1, 128, 0, 96, 3, 129, 128, 112, 7, 193, 128,
  88, 15, 127, 128, 79, 254, 63, 128, 67, 252, 31, 0, 64, 0, 0, 0,
  192, 0, 0, 0, 192, 0, 0, 0, 192, 0, 0, 0, 192, 0, 0, 0,
  192, 0, 0, 0, 224, 0, 0, 0, 224, 0, 0, 0, 240, 0, 0, 0,
  240, 0, 0, 0, 240, 0, 0, 0, 248, 0, 0, 0, 120, 0, 0, 0,
  120, 0, 0, 0, 20, 42, 126, 26, 3, 249, 7, 255, 240, 31, 193, 128,
  63, 193, 128, 127, 193, 128, 127, 193, 128, 255, 193, 128, 255, 193, 128, 255,
  193, 128, 255, 193, 128, 255, 193, 128, 255, 193, 128, 127, 193, 128, 127, 193,
  128, 63, 193, 128, 15, 193, 128, 0, 193, 128, 0, 193, 128, 0, 193, 128,
  0, 193, 128, 0, 193, 128, 0, 193, 128, 0, 193, 128, 0, 193, 128, 0,
  193, 128, 0, 193, 128, 0, 193, 128, 0, 193, 128, 0, 193, 128, 0, 193,
  128, 0, 193, 128, 0, 193, 128, 0, 193, 128, 0, 193, 128, 0, 193, 128,
  0, 193, 128, 0, 193, 128, 0, 193, 128, 0, 193, 128, 0, 193, 128, 0,
  193, 128, 0, 193, 128, 0, 193, 128, 6, 6, 6, 14, 4, 12, 120, 252,
  252, 252, 252, 120, 10, 10, 20, 21, 5, 246, 8, 0, 8, 0, 24, 0,
  15, 0, 3, 128, 1, 192, 1, 192, 1, 192, 195, 128, 63, 0, 11, 20,
  40, 21, 5, 14, 2, 0, 6, 0, 14, 0, 254, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 14, 0,
  14, 0, 14, 0, 14, 0, 14, 0, 14, 0, 255, 224, 12, 17, 34, 18,
  3, 17, 15, 0, 57, 192, 112, 192, 96, 224, 224, 96, 224, 112, 224, 112,
  224, 112, 224, 112, 224, 112, 96, 96, 112, 224, 49, 192, 31, 0, 0, 0,
  0, 0, 255, 240, 13, 19, 38, 23, 5, 1, 1, 0, 193, 128, 96, 192,
  32, 96, 48, 112, 48, 48, 24, 48, 24, 56, 24, 56, 24, 56, 24, 56,
  24, 56, 24, 56, 24, 48, 48, 112, 48, 96, 96, 224, 64, 192, 1, 128,
  33, 35, 175, 42, 5, 255, 2, 0, 0, 96, 0, 6, 0, 0, 64, 0,
  14, 0, 0, 192, 0, 254, 0, 1, 128, 0, 14, 0, 1, 0, 0, 14,
  0, 3, 0, 0, 14, 0, 2, 0, 0, 14, 0, 6, 0, 0, 14, 0,
  12, 0, 0, 14, 0, 8, 0, 0, 14, 0, 24, 0, 0, 14, 0, 16,
  0, 0, 14, 0, 48, 0, 0, 14, 0, 96, 0, 0, 14, 0, 96, 56,
  0, 14, 0, 192, 120, 0, 14, 0, 128, 120, 0, 14, 1, 128, 248, 0,
  14, 3, 0, 184, 0, 255, 227, 1, 56, 0, 0, 6, 1, 56, 0, 0,
  4, 2, 56, 0, 0, 12, 2, 56, 0, 0, 8, 4, 56, 0, 0, 24,
  12, 56, 0, 0, 48, 8, 56, 0, 0, 32, 24, 56, 0, 0, 96, 31,
  255, 128, 0, 64, 0, 56, 0, 0, 192, 0, 56, 0, 1, 128, 0, 56,
  0, 1, 128, 0, 56, 0, 3, 0, 0, 56, 0, 2, 0, 1, 255, 128,
  6, 0, 0, 0, 0, 33, 35, 175, 42, 5, 255, 2, 0, 0, 96, 0,
  6, 0, 0, 64, 0, 6, 0, 0, 192, 0, 14, 0, 1, 128, 0, 254,
  0, 1, 128, 0, 14, 0, 3, 0, 0, 14, 0, 2, 0, 0, 14, 0,
  6, 0, 0, 14, 0, 4, 0, 0, 14, 0, 12, 0, 0, 14, 0, 24,
  0, 0, 14, 0, 16, 0, 0, 14, 0, 48, 0, 0, 14, 0, 33, 248,
  0, 14, 0, 102, 62, 0, 14, 0, 204, 15, 0, 14, 0, 152, 15, 128,
  14, 1, 152, 7, 128, 14, 1, 24, 7, 128, 255, 227, 31, 7, 128, 0,
  6, 31, 7, 128, 0, 4, 15, 7, 0, 0, 12, 0, 14, 0, 0, 8,
  0, 28, 0, 0, 24, 0, 56, 0, 0, 48, 0, 112, 0, 0, 48, 0,
  192, 0, 0, 96, 1, 128, 0, 0, 64, 2, 0, 128, 0, 192, 4, 0,
  128, 1, 128, 12, 1, 128, 1, 128, 15, 255, 0, 3, 0, 15, 255, 0,
  2, 0, 31, 255, 0, 6, 0, 0, 0, 0, 33, 35, 175, 42, 5, 255,
  15, 192, 0, 48, 0, 56, 224, 0, 96, 0, 96, 112, 0, 96, 0, 96,
  56, 0, 192, 0, 112, 56, 0, 128, 0, 120, 56, 1, 128, 0, 48, 56,
  3, 0, 0, 0, 112, 3, 0, 0, 0, 224, 6, 0, 0, 63, 128, 4,
  0, 0, 56, 224, 12, 0, 0, 0, 120, 24, 0, 0, 0, 56, 24, 0,
  0, 0, 60, 48, 0, 0, 112, 60, 32, 28, 0, 248, 60, 96, 28, 0,
  240, 60, 192, 60, 0, 192, 120, 192, 92, 0, 96, 241, 128, 92, 0, 63,
  193, 0, 156, 0, 0, 3, 1, 156, 0, 0, 6, 1, 28, 0, 0, 6,
  2, 28, 0, 0, 12, 6, 28, 0, 0, 8, 4, 28, 0, 0, 24, 8,
  28, 0, 0, 48, 24, 28, 0, 0, 48, 31, 255, 128, 0, 96, 0, 28,
  0, 0, 64, 0, 28, 0, 0, 192, 0, 28, 0, 1, 128, 0, 28, 0,
  1, 128, 0, 28, 0, 3, 0, 1, 255, 128, 2, 0, 0, 0, 0, 18,
  33, 99, 24, 2, 246, 1, 224, 0, 3, 240, 0, 3, 240, 0, 3, 240,
  0, 1, 224, 0, 0, 0, 0, 0, 0, 0, 1, 224, 0, 2, 48, 0,
  4, 24, 0, 4, 24, 0, 4, 24, 0, 4, 24, 0, 0, 48, 0, 0,
  112, 0, 0, 224, 0, 1, 192, 0, 7, 128, 0, 15, 0, 0, 30, 0,
  0, 60, 0, 0, 124, 0, 0, 120, 15, 0, 248, 31, 128, 240, 31, 192,
  240, 15, 192, 240, 0, 192, 240, 0, 192, 120, 0, 192, 120, 1, 128, 60,
  3, 0, 15, 14, 0, 3, 248, 0, 34, 46, 230, 37, 2, 0, 0, 56,
  0, 0, 0, 0, 60, 0, 0, 0, 0, 60, 0, 0, 0, 0, 30, 0,
  0, 0, 0, 15, 0, 0, 0, 0, 3, 128, 0, 0, 0, 1, 128, 0,
  0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0,
  0, 224, 0, 0, 0, 1, 224, 0, 0, 0, 1, 224, 0, 0, 0, 3,
  240, 0, 0, 0, 3, 240, 0, 0, 0, 3, 240, 0, 0, 0, 6, 248,
  0, 0, 0, 6, 248, 0, 0, 0, 6, 248, 0, 0, 0, 12, 124, 0,
  0, 0, 12, 124, 0, 0, 0, 12, 124, 0, 0, 0, 24, 62, 0, 0,
  0, 24, 62, 0, 0, 0, 24, 30, 0, 0, 0, 48, 31, 0, 0, 0,
  48, 31, 0, 0, 0, 48, 15, 0, 0, 0, 96, 15, 128, 0, 0, 96,
  15, 128, 0, 0, 96, 7, 128, 0, 0, 255, 255, 192, 0, 0, 255, 255,
  192, 0, 0, 192, 3, 192, 0, 1, 128, 3, 224, 0, 1, 128, 3, 224,
  0, 3, 128, 1, 224, 0, 3, 0, 1, 240, 0, 3, 0, 1, 240, 0,
  7, 0, 0, 240, 0, 7, 0, 0, 248, 0, 31, 128, 1, 252, 0, 255,
  248, 31, 255, 192, 34, 46, 230, 37, 2, 0, 0, 0, 7, 0, 0, 0,
  0, 15, 0, 0, 0, 0, 15, 0, 0, 0, 0, 30, 0, 0, 0, 0,
  60, 0, 0, 0, 0, 48, 0, 0, 0, 0, 96, 0, 0, 0, 0, 192,
  0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 224, 0, 0,
  0, 1, 224, 0, 0, 0, 1, 224, 0, 0, 0, 3, 240, 0, 0, 0,
  3, 240, 0, 0, 0, 3, 240, 0, 0, 0, 6, 248, 0, 0, 0, 6,
  248, 0, 0, 0, 6, 248, 0, 0, 0, 12, 124, 0, 0, 0, 12, 124,
  0, 0, 0, 12, 124, 0, 0, 0, 24, 62, 0, 0, 0, 24, 62, 0,
  0, 0, 24, 30, 0, 0, 0, 48, 31, 0, 0, 0, 48, 31, 0, 0,
  0, 48, 15, 0, 0, 0, 96, 15, 128, 0, 0, 96, 15, 128, 0, 0,
  224, 7, 128, 0, 0, 255, 255, 192, 0, 0, 255, 255, 192, 0, 1, 192,
  3, 192, 0, 1, 128, 3, 224, 0, 1, 128, 3, 224, 0, 3, 128, 1,
  224, 0, 3, 0, 1, 240, 0, 3, 0, 1, 240, 0, 7, 0, 0, 240,
  0, 15, 128, 0, 248, 0, 255, 248, 31, 255, 192, 255, 248, 31, 255, 192,
  34, 45, 225, 37, 2, 0, 0, 0, 192, 0, 0, 0, 1, 224, 0, 0,
  0, 3, 240, 0, 0, 0, 7, 56, 0, 0, 0, 14, 28, 0, 0, 0,
  28, 14, 0, 0, 0, 48, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 0, 192,
  0, 0, 0, 0, 224, 0, 0, 0, 1, 224, 0, 0, 0, 1, 224, 0,
  0, 0, 3, 240, 0, 0, 0, 3, 240, 0, 0, 0, 3, 240, 0, 0,
  0, 6, 248, 0, 0, 0, 6, 248, 0, 0, 0, 6, 248, 0, 0, 0,
  12, 124, 0, 0, 0, 12, 124, 0, 0, 0, 12, 124, 0, 0, 0, 24,
  62, 0, 0, 0, 24, 62, 0, 0, 0, 24, 30, 0, 0, 0, 48, 31,
  0, 0, 0, 48, 31, 0, 0, 0, 48, 15, 0, 0, 0, 96, 15, 128,
  0, 0, 96, 15, 128, 0, 0, 96, 7, 128, 0, 0, 255, 255, 192, 0,
  0, 255, 255, 192, 0, 0, 192, 3, 192, 0, 1, 128, 3, 224, 0, 1,
  128, 3, 224, 0, 3, 128, 1, 224, 0, 3, 0, 1, 240, 0, 3, 0,
  1, 240, 0, 7, 0, 0, 240, 0, 7, 0, 0, 248, 0, 31, 128, 1,
  252, 0, 255, 248, 31, 255, 192, 34, 45, 225, 37, 2, 0, 0, 15, 0,
  128, 0, 0, 31, 225, 128, 0, 0, 63, 255, 0, 0, 0, 33, 255, 0,
  0, 0, 32, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 1, 224, 0, 0, 0, 1,
  224, 0, 0, 0, 1, 224, 0, 0, 0, 3, 240, 0, 0, 0, 3, 240,
  0, 0, 0, 3, 240, 0, 0, 0, 6, 248, 0, 0, 0, 6, 248, 0,
  0, 0, 6, 248, 0, 0, 0, 12, 124, 0, 0, 0, 12, 124, 0, 0,
  0, 12, 124, 0, 0, 0, 24, 62, 0, 0, 0, 24, 62, 0, 0, 0,
  24, 30, 0, 0, 0, 48, 31, 0, 0, 0, 48, 31, 0, 0, 0, 112,
  15, 0, 0, 0, 96, 15, 128, 0, 0, 96, 15, 128, 0, 0, 224, 7,
  128, 0, 0, 255, 255, 192, 0, 0, 255, 255, 192, 0, 1, 192, 3, 192,
  0, 1, 128, 3, 224, 0, 1, 128, 3, 224, 0, 3, 128, 1, 224, 0,
  3, 0, 1, 240, 0, 3, 0, 1, 240, 0, 7, 0, 0, 240, 0, 15,
  128, 0, 248, 0, 255, 248, 31, 255, 192, 255, 248, 31, 255, 192, 34, 44,
  220, 37, 2, 0, 0, 28, 7, 0, 0, 0, 62, 15, 128, 0, 0, 62,
  15, 128, 0, 0, 62, 15, 128, 0, 0, 28, 7, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 64, 0, 0, 0, 0, 192, 0, 0, 0, 0, 224, 0, 0,
  0, 0, 224, 0, 0, 0, 1, 224, 0, 0, 0, 1, 240, 0, 0, 0,
  3, 240, 0, 0, 0, 3, 240, 0, 0, 0, 3, 248, 0, 0, 0, 7,
  248, 0, 0, 0, 6, 120, 0, 0, 0, 6, 124, 0, 0, 0, 14, 60,
  0, 0, 0, 12, 60, 0, 0, 0, 12, 62, 0, 0, 0, 28, 30, 0,
  0, 0, 24, 30, 0, 0, 0, 24, 31, 0, 0, 0, 48, 15, 0, 0,
  0, 48, 15, 0, 0, 0, 112, 15, 128, 0, 0, 96, 7, 128, 0, 0,
  96, 7, 128, 0, 0, 255, 255, 192, 0, 0, 255, 255, 192, 0, 0, 192,
  3, 192, 0, 1, 192, 3, 224, 0, 1, 192, 1, 224, 0, 1, 128, 1,
  224, 0, 3, 128, 1, 240, 0, 3, 128, 0, 240, 0, 7, 128, 0, 240,
  0, 7, 128, 0, 248, 0, 31, 192, 1, 252, 0, 255, 248, 31, 255, 192,
  34, 47, 235, 37, 2, 0, 0, 1, 224, 0, 0, 0, 6, 24, 0, 0,
  0, 4, 8, 0, 0, 0, 8, 4, 0, 0, 0, 8, 4, 0, 0, 0,
  8, 4, 0, 0, 0, 8, 4, 0, 0, 0, 4, 8, 0, 0, 0, 6,
  24, 0, 0, 0, 3, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 224, 0,
  0, 0, 1, 224, 0, 0, 0, 1, 224, 0, 0, 0, 3, 240, 0, 0,
  0, 3, 240, 0, 0, 0, 3, 240, 0, 0, 0, 6, 248, 0, 0, 0,
  6, 248, 0, 0, 0, 6, 248, 0, 0, 0, 12, 124, 0, 0, 0, 12,
  124, 0, 0, 0, 12, 124, 0, 0, 0, 24, 62, 0, 0, 0, 24, 62,
  0, 0, 0, 24, 30, 0, 0, 0, 48, 31, 0, 0, 0, 48, 31, 0,
  0, 0, 48, 15, 0, 0, 0, 96, 15, 128, 0, 0, 96, 7, 128, 0,
  0, 96, 7, 128, 0, 0, 255, 255, 192, 0, 0, 255, 255, 192, 0, 1,
  192, 3, 192, 0, 1, 128, 3, 224, 0, 1, 128, 3, 224, 0, 3, 128,
  1, 224, 0, 3, 0, 1, 240, 0, 3, 0, 1, 240, 0, 7, 0, 0,
  240, 0, 7, 0, 0, 248, 0, 31, 128, 1, 252, 0, 255, 248, 31, 255,
  192, 44, 35, 210, 48, 1, 0, 0, 0, 127, 255, 255, 240, 0, 0, 15,
  224, 3, 240, 0, 0, 15, 192, 0, 240, 0, 0, 15, 192, 0, 112, 0,
  0, 15, 192, 0, 112, 0, 0, 27, 192, 0, 48, 0, 0, 27, 192, 0,
  48, 0, 0, 51, 192, 0, 48, 0, 0, 51, 192, 0, 16, 0, 0, 99,
  192, 0, 16, 0, 0, 99, 192, 16, 16, 0, 0, 195, 192, 16, 16, 0,
  1, 195, 192, 16, 0, 0, 1, 131, 192, 48, 0, 0, 3, 131, 192, 48,
  0, 0, 3, 3, 192, 48, 0, 0, 7, 3, 192, 112, 0, 0, 6, 3,
  255, 240, 0, 0, 14, 3, 192, 240, 0, 0, 12, 3, 192, 48, 0, 0,
  24, 3, 192, 48, 0, 0, 24, 3, 192, 16, 0, 0, 48, 3, 192, 16,
  16, 0, 63, 255, 192, 16, 16, 0, 96, 3, 192, 16, 16, 0, 96, 3,
  192, 0, 16, 0, 192, 3, 192, 0, 16, 0, 192, 3, 192, 0, 48, 1,
  128, 3, 192, 0, 48, 1, 128, 3, 192, 0, 112, 3, 128, 3, 192, 0,
  112, 7, 128, 3, 192, 0, 240, 15, 128, 3, 192, 1, 240, 255, 248, 127,
  255, 255, 240, 255, 248, 127, 255, 255, 240, 26, 47, 188, 32, 3, 245, 0,
  63, 0, 128, 0, 225, 225, 128, 3, 128, 113, 128, 7, 0, 63, 128, 14,
  0, 31, 128, 30, 0, 15, 128, 28, 0, 7, 128, 60, 0, 7, 128, 60,
  0, 3, 128, 124, 0, 3, 128, 120, 0, 1, 128, 120, 0, 1, 128, 120,
  0, 0, 128, 248, 0, 0, 128, 248, 0, 0, 0, 248, 0, 0, 0, 248,
  0, 0, 0, 248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0, 0, 248,
  0, 0, 0, 248, 0, 0, 0, 248, 0, 0, 0, 120, 0, 0, 192, 120,
  0, 0, 192, 120, 0, 0, 192, 124, 0, 0, 192, 60, 0, 0, 128, 60,
  0, 1, 128, 28, 0, 1, 128, 30, 0, 3, 0, 14, 0, 3, 0, 7,
  0, 6, 0, 3, 128, 12, 0, 1, 192, 56, 0, 0, 127, 224, 0, 0,
  8, 0, 0, 0, 8, 0, 0, 0, 28, 0, 0, 0, 15, 128, 0, 0,
  3, 192, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0,
  129, 224, 0, 0, 199, 192, 0, 0, 63, 0, 0, 28, 46, 184, 34, 3,
  0, 0, 224, 0, 0, 0, 240, 0, 0, 0, 240, 0, 0, 0, 120, 0,
  0, 0, 60, 0, 0, 0, 14, 0, 0, 0, 6, 0, 0, 0, 3, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
  240, 255, 255, 255, 240, 7, 128, 1, 240, 7, 128, 0, 240, 7, 128, 0,
  112, 7, 128, 0, 112, 7, 128, 0, 48, 7, 128, 0, 48, 7, 128, 0,
  48, 7, 128, 0, 16, 7, 128, 32, 16, 7, 128, 32, 16, 7, 128, 32,
  0, 7, 128, 96, 0, 7, 128, 96, 0, 7, 128, 96, 0, 7, 128, 224,
  0, 7, 255, 224, 0, 7, 129, 224, 0, 7, 128, 96, 0, 7, 128, 96,
  0, 7, 128, 96, 0, 7, 128, 32, 16, 7, 128, 32, 16, 7, 128, 32,
  16, 7, 128, 0, 16, 7, 128, 0, 48, 7, 128, 0, 48, 7, 128, 0,
  48, 7, 128, 0, 112, 7, 128, 0, 112, 7, 128, 0, 240, 7, 128, 1,
  240, 255, 255, 255, 240, 255, 255, 255, 240, 28, 46, 184, 34, 3, 0, 0,
  0, 28, 0, 0, 0, 60, 0, 0, 0, 60, 0, 0, 0, 120, 0, 0,
  0, 240, 0, 0, 0, 192, 0, 0, 1, 128, 0, 0, 3, 0, 0, 0,
  2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 240, 255,
  255, 255, 240, 7, 128, 1, 240, 7, 128, 0, 240, 7, 128, 0, 112, 7,
  128, 0, 112, 7, 128, 0, 48, 7, 128, 0, 48, 7, 128, 0, 48, 7,
  128, 0, 16, 7, 128, 32, 16, 7, 128, 32, 16, 7, 128, 32, 0, 7,
  128, 96, 0, 7, 128, 96, 0, 7, 128, 96, 0, 7, 128, 224, 0, 7,
  255, 224, 0, 7, 129, 224, 0, 7, 128, 96, 0, 7, 128, 96, 0, 7,
  128, 96, 0, 7, 128, 32, 16, 7, 128, 32, 16, 7, 128, 32, 16, 7,
  128, 0, 16, 7, 128, 0, 48, 7, 128, 0, 48, 7, 128, 0, 48, 7,
  128, 0, 112, 7, 128, 0, 112, 7, 128, 0, 240, 7, 128, 1, 240, 255,
  255, 255, 240, 255, 255, 255, 240, 28, 45, 180, 34, 3, 0, 0, 3, 0,
  0, 0, 7, 128, 0, 0, 15, 192, 0, 0, 12, 224, 0, 0, 24, 112,
  0, 0, 112, 24, 0, 0, 192, 12, 0, 0, 0, 2, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 255, 255, 255, 240, 255, 255, 255, 240, 7, 128, 1,
  240, 7, 128, 0, 240, 7, 128, 0, 112, 7, 128, 0, 112, 7, 128, 0,
  48, 7, 128, 0, 48, 7, 128, 0, 48, 7, 128, 0, 16, 7, 128, 32,
  16, 7, 128, 32, 16, 7, 128, 32, 0, 7, 128, 96, 0, 7, 128, 96,
  0, 7, 128, 96, 0, 7, 128, 224, 0, 7, 255, 224, 0, 7, 129, 224,
  0, 7, 128, 96, 0, 7, 128, 96, 0, 7, 128, 96, 0, 7, 128, 32,
  16, 7, 128, 32, 16, 7, 128, 32, 16, 7, 128, 0, 16, 7, 128, 0,
  48, 7, 128, 0, 48, 7, 128, 0, 48, 7, 128, 0, 112, 7, 128, 0,
  112, 7, 128, 0, 240, 7, 128, 1, 240, 255, 255, 255, 240, 255, 255, 255,
  240, 28, 44, 176, 34, 3, 0, 0, 112, 28, 0, 0, 248, 62, 0, 0,
  248, 62, 0, 0, 248, 62, 0, 0, 112, 28, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 240, 7,
  192, 7, 240, 7, 128, 1, 240, 7, 128, 0, 240, 7, 128, 0, 112, 7,
  128, 0, 112, 7, 128, 0, 48, 7, 128, 0, 48, 7, 128, 0, 48, 7,
  128, 0, 16, 7, 128, 32, 16, 7, 128, 32, 16, 7, 128, 32, 0, 7,
  128, 32, 0, 7, 128, 96, 0, 7, 128, 96, 0, 7, 128, 224, 0, 7,
  255, 224, 0, 7, 129, 224, 0, 7, 128, 96, 0, 7, 128, 96, 0, 7,
  128, 32, 0, 7, 128, 32, 16, 7, 128, 32, 16, 7, 128, 32, 16, 7,
  128, 0, 16, 7, 128, 0, 48, 7, 128, 0, 48, 7, 128, 0, 48, 7,
  128, 0, 112, 7, 128, 0, 112, 7, 128, 0, 240, 7, 128, 1, 240, 255,
  255, 255, 240, 255, 255, 255, 240, 14, 46, 92, 19, 3, 0, 224, 0, 240,
  0, 240, 0, 120, 0, 60, 0, 12, 0, 6, 0, 3, 0, 1, 0, 0,
  0, 0, 0, 255, 252, 255, 252, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 15, 128, 255, 252, 14, 46, 92, 19, 3, 0, 0,
  28, 0, 60, 0, 60, 0, 120, 0, 240, 0, 192, 1, 128, 3, 0, 0,
  0, 0, 0, 0, 0, 255, 252, 255, 252, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 192, 255, 252, 14, 45, 90, 19, 3,
  0, 3, 0, 7, 128, 7, 192, 14, 192, 24, 96, 112, 56, 192, 12, 0,
  0, 0, 0, 0, 0, 255, 252, 7, 192, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 255, 252, 255, 252, 15, 44, 88, 20, 3,
  0, 112, 28, 248, 62, 248, 62, 248, 62, 112, 28, 0, 0, 0, 0, 0,
  0, 0, 0, 127, 254, 7, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 7, 192, 127, 254, 32, 35, 140, 38, 4, 0, 255,
  255, 248, 0, 15, 128, 15, 0, 7, 128, 3, 128, 7, 128, 1, 192, 7,
  128, 0, 224, 7, 128, 0, 240, 7, 128, 0, 120, 7, 128, 0, 124, 7,
  128, 0, 60, 7, 128, 0, 62, 7, 128, 0, 62, 7, 128, 0, 30, 7,
  128, 0, 30, 7, 128, 0, 31, 7, 128, 0, 31, 7, 128, 0, 31, 255,
  254, 0, 31, 7, 128, 0, 31, 7, 128, 0, 31, 7, 128, 0, 31, 7,
  128, 0, 31, 7, 128, 0, 31, 7, 128, 0, 30, 7, 128, 0, 62, 7,
  128, 0, 62, 7, 128, 0, 60, 7, 128, 0, 60, 7, 128, 0, 120, 7,
  128, 0, 120, 7, 128, 0, 240, 7, 128, 0, 224, 7, 128, 1, 192, 7,
  128, 3, 128, 15, 128, 30, 0, 255, 255, 248, 0, 33, 46, 230, 38, 3,
  255, 0, 7, 1, 128, 0, 0, 31, 225, 128, 0, 0, 31, 255, 0, 0,
  0, 16, 255, 0, 0, 0, 48, 62, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 255, 192, 7, 255, 128, 255, 192, 7, 255, 128, 7, 224, 0,
  120, 0, 7, 240, 0, 48, 0, 7, 240, 0, 48, 0, 7, 248, 0, 48,
  0, 6, 248, 0, 48, 0, 6, 252, 0, 48, 0, 6, 126, 0, 48, 0,
  6, 62, 0, 48, 0, 6, 63, 0, 48, 0, 6, 31, 0, 48, 0, 6,
  15, 128, 48, 0, 6, 15, 192, 48, 0, 6, 7, 192, 48, 0, 6, 7,
  224, 48, 0, 6, 3, 224, 48, 0, 6, 1, 240, 48, 0, 6, 1, 248,
  48, 0, 6, 0, 248, 48, 0, 6, 0, 252, 48, 0, 6, 0, 124, 48,
  0, 6, 0, 62, 48, 0, 6, 0, 63, 48, 0, 6, 0, 31, 48, 0,
  6, 0, 15, 176, 0, 6, 0, 15, 176, 0, 6, 0, 7, 240, 0, 6,
  0, 7, 240, 0, 6, 0, 3, 240, 0, 6, 0, 1, 240, 0, 6, 0,
  1, 240, 0, 15, 0, 0, 240, 0, 31, 128, 0, 240, 0, 255, 240, 0,
  112, 0, 0, 0, 0, 48, 0, 28, 46, 184, 33, 3, 1, 1, 192, 0,
  0, 1, 224, 0, 0, 1, 240, 0, 0, 0, 112, 0, 0, 0, 56, 0,
  0, 0, 28, 0, 0, 0, 12, 0, 0, 0, 6, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 31, 128, 0, 0, 255, 240, 0, 1, 192, 56,
  0, 3, 128, 28, 0, 7, 0, 14, 0, 14, 0, 7, 0, 30, 0, 7,
  128, 30, 0, 7, 128, 60, 0, 3, 192, 60, 0, 3, 192, 124, 0, 3,
  224, 124, 0, 3, 224, 120, 0, 1, 224, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1,
  240, 120, 0, 1, 224, 120, 0, 1, 224, 120, 0, 3, 224, 124, 0, 3,
  192, 60, 0, 3, 192, 60, 0, 3, 192, 30, 0, 7, 128, 14, 0, 7,
  0, 14, 0, 7, 0, 7, 0, 14, 0, 3, 128, 28, 0, 0, 192, 48,
  0, 0, 127, 224, 0, 28, 46, 184, 33, 3, 1, 0, 0, 56, 0, 0,
  0, 120, 0, 0, 0, 248, 0, 0, 0, 224, 0, 0, 1, 192, 0, 0,
  3, 128, 0, 0, 3, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 31, 128, 0, 0, 255, 240, 0, 1, 192, 56, 0, 3,
  128, 28, 0, 7, 0, 14, 0, 14, 0, 7, 0, 30, 0, 7, 128, 30,
  0, 7, 128, 60, 0, 3, 192, 60, 0, 3, 192, 124, 0, 3, 224, 124,
  0, 3, 224, 120, 0, 1, 224, 248, 0, 1, 240, 248, 0, 1, 240, 248,
  0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248,
  0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 120,
  0, 1, 224, 120, 0, 1, 224, 120, 0, 3, 224, 124, 0, 3, 192, 60,
  0, 3, 192, 60, 0, 3, 192, 30, 0, 7, 128, 14, 0, 7, 0, 14,
  0, 7, 0, 7, 0, 14, 0, 3, 128, 28, 0, 0, 192, 48, 0, 0,
  127, 224, 0, 28, 46, 184, 33, 3, 0, 0, 6, 0, 0, 0, 15, 0,
  0, 0, 15, 0, 0, 0, 31, 128, 0, 0, 57, 192, 0, 0, 112, 224,
  0, 0, 192, 48, 0, 3, 128, 28, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 31, 128, 0, 0, 255, 240, 0, 1, 192, 56, 0, 3, 128, 28,
  0, 7, 0, 14, 0, 14, 0, 7, 0, 30, 0, 7, 128, 30, 0, 7,
  128, 60, 0, 3, 192, 60, 0, 3, 192, 124, 0, 3, 224, 124, 0, 3,
  224, 120, 0, 1, 224, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 120, 0, 1,
  224, 120, 0, 1, 224, 120, 0, 3, 224, 124, 0, 3, 192, 60, 0, 3,
  192, 60, 0, 3, 192, 30, 0, 7, 128, 14, 0, 7, 0, 14, 0, 7,
  0, 7, 0, 14, 0, 3, 128, 28, 0, 0, 192, 48, 0, 0, 127, 224,
  0, 28, 45, 180, 33, 3, 0, 0, 120, 12, 0, 0, 255, 8, 0, 1,
  255, 248, 0, 1, 143, 248, 0, 1, 1, 224, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 128, 0, 0,
  255, 240, 0, 1, 192, 56, 0, 3, 128, 28, 0, 7, 0, 14, 0, 14,
  0, 7, 0, 30, 0, 7, 128, 30, 0, 7, 128, 60, 0, 3, 192, 60,
  0, 3, 192, 124, 0, 3, 224, 124, 0, 3, 224, 120, 0, 1, 224, 248,
  0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248,
  0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248,
  0, 1, 240, 248, 0, 1, 240, 120, 0, 1, 224, 120, 0, 1, 224, 120,
  0, 3, 224, 124, 0, 3, 192, 60, 0, 3, 192, 60, 0, 3, 192, 30,
  0, 7, 128, 14, 0, 7, 0, 14, 0, 7, 0, 7, 0, 14, 0, 3,
  128, 28, 0, 0, 192, 48, 0, 0, 127, 224, 0, 28, 45, 180, 33, 3,
  0, 0, 224, 56, 0, 1, 240, 124, 0, 1, 240, 124, 0, 1, 240, 124,
  0, 0, 224, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 31, 128, 0, 0, 240, 240, 0, 1, 192, 56,
  0, 3, 128, 28, 0, 7, 0, 14, 0, 14, 0, 7, 0, 30, 0, 7,
  128, 28, 0, 3, 128, 60, 0, 3, 192, 60, 0, 3, 192, 124, 0, 3,
  224, 120, 0, 1, 224, 120, 0, 1, 224, 248, 0, 1, 224, 248, 0, 1,
  240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1,
  240, 120, 0, 1, 224, 120, 0, 1, 224, 124, 0, 3, 224, 124, 0, 3,
  224, 60, 0, 3, 192, 60, 0, 3, 192, 30, 0, 7, 128, 14, 0, 7,
  0, 14, 0, 15, 0, 7, 0, 14, 0, 3, 128, 28, 0, 0, 224, 112,
  0, 0, 127, 224, 0, 30, 30, 120, 46, 8, 254, 192, 0, 0, 12, 224,
  0, 0, 28, 112, 0, 0, 56, 56, 0, 0, 112, 28, 0, 0, 224, 14,
  0, 1, 192, 7, 0, 3, 128, 3, 128, 7, 0, 1, 192, 14, 0, 0,
  224, 28, 0, 0, 112, 56, 0, 0, 56, 112, 0, 0, 28, 224, 0, 0,
  15, 192, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 15, 192, 0, 0,
  28, 224, 0, 0, 56, 112, 0, 0, 112, 56, 0, 0, 224, 28, 0, 1,
  192, 14, 0, 3, 128, 7, 0, 7, 0, 3, 128, 14, 0, 1, 192, 28,
  0, 0, 224, 56, 0, 0, 112, 112, 0, 0, 56, 224, 0, 0, 28, 192,
  0, 0, 12, 28, 36, 144, 33, 3, 0, 0, 31, 128, 32, 0, 240, 240,
  96, 1, 192, 56, 224, 3, 128, 30, 192, 7, 0, 15, 128, 14, 0, 7,
  128, 30, 0, 7, 128, 28, 0, 7, 128, 60, 0, 15, 192, 60, 0, 31,
  192, 124, 0, 59, 224, 120, 0, 49, 224, 120, 0, 97, 224, 248, 0, 225,
  240, 248, 1, 193, 240, 248, 1, 129, 240, 248, 3, 1, 240, 248, 7, 1,
  240, 248, 6, 1, 240, 248, 12, 1, 240, 248, 28, 1, 240, 248, 56, 1,
  240, 248, 48, 1, 240, 120, 96, 1, 224, 120, 224, 1, 224, 121, 192, 3,
  224, 125, 128, 3, 192, 63, 0, 3, 192, 63, 0, 3, 192, 30, 0, 7,
  128, 30, 0, 7, 0, 30, 0, 15, 0, 63, 0, 14, 0, 51, 128, 28,
  0, 97, 192, 112, 0, 192, 127, 224, 0, 34, 46, 230, 39, 3, 1, 0,
  28, 0, 0, 0, 0, 28, 0, 0, 0, 0, 30, 0, 0, 0, 0, 15,
  0, 0, 0, 0, 7, 0, 0, 0, 0, 1, 128, 0, 0, 0, 0, 192,
  0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 255, 252, 3, 255, 192, 255, 252, 3, 255, 192, 7, 192, 0, 126, 0,
  7, 128, 0, 60, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7,
  128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128,
  0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0,
  24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24,
  0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0,
  7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7,
  128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128,
  0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 3, 192, 0,
  24, 0, 3, 192, 0, 48, 0, 1, 192, 0, 48, 0, 1, 224, 0, 96,
  0, 0, 224, 0, 96, 0, 0, 112, 0, 192, 0, 0, 60, 3, 128, 0,
  0, 15, 254, 0, 0, 34, 46, 230, 39, 3, 1, 0, 0, 7, 0, 0,
  0, 0, 15, 0, 0, 0, 0, 30, 0, 0, 0, 0, 28, 0, 0, 0,
  0, 56, 0, 0, 0, 0, 112, 0, 0, 0, 0, 96, 0, 0, 0, 0,
  128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 252, 3,
  255, 192, 255, 252, 3, 255, 192, 7, 192, 0, 126, 0, 7, 128, 0, 60,
  0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0,
  7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7,
  128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128,
  0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0,
  24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24,
  0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0,
  7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7,
  128, 0, 24, 0, 7, 128, 0, 24, 0, 3, 192, 0, 24, 0, 3, 192,
  0, 48, 0, 1, 192, 0, 48, 0, 1, 224, 0, 96, 0, 0, 224, 0,
  96, 0, 0, 112, 0, 192, 0, 0, 60, 3, 128, 0, 0, 15, 254, 0,
  0, 34, 46, 230, 39, 3, 0, 0, 0, 192, 0, 0, 0, 0, 224, 0,
  0, 0, 1, 224, 0, 0, 0, 3, 240, 0, 0, 0, 3, 56, 0, 0,
  0, 6, 28, 0, 0, 0, 28, 6, 0, 0, 0, 48, 3, 128, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 252,
  3, 255, 192, 7, 192, 0, 126, 0, 7, 128, 0, 60, 0, 7, 128, 0,
  24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24,
  0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0,
  7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7,
  128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128,
  0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0,
  24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24,
  0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0,
  7, 128, 0, 24, 0, 3, 192, 0, 24, 0, 3, 192, 0, 48, 0, 3,
  192, 0, 48, 0, 1, 224, 0, 96, 0, 0, 240, 0, 224, 0, 0, 120,
  1, 192, 0, 0, 62, 7, 128, 0, 0, 15, 254, 0, 0, 34, 45, 225,
  39, 3, 0, 0, 28, 7, 0, 0, 0, 62, 15, 128, 0, 0, 62, 15,
  128, 0, 0, 62, 15, 128, 0, 0, 28, 7, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 255, 252, 3, 255, 192, 7, 192, 0, 126, 0, 7,
  128, 0, 60, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128,
  0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0,
  24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24,
  0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0,
  7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7,
  128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128,
  0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0,
  24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 3, 192, 0, 24,
  0, 3, 192, 0, 48, 0, 3, 192, 0, 48, 0, 1, 224, 0, 96, 0,
  0, 224, 0, 96, 0, 0, 112, 0, 192, 0, 0, 60, 3, 128, 0, 0,
  15, 254, 0, 0, 32, 46, 184, 35, 2, 0, 0, 0, 3, 0, 0, 0,
  7, 128, 0, 0, 15, 0, 0, 0, 30, 0, 0, 0, 60, 0, 0, 0,
  56, 0, 0, 0, 96, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 255, 254, 15, 255, 255, 254, 15, 255, 7, 224,
  0, 240, 7, 224, 0, 96, 3, 224, 0, 96, 3, 240, 0, 64, 1, 240,
  0, 192, 0, 248, 0, 128, 0, 252, 1, 128, 0, 124, 1, 0, 0, 62,
  3, 0, 0, 62, 2, 0, 0, 31, 6, 0, 0, 31, 12, 0, 0, 15,
  136, 0, 0, 7, 152, 0, 0, 7, 208, 0, 0, 3, 240, 0, 0, 3,
  224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1,
  224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1,
  224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1,
  224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1, 240, 0, 0, 127,
  255, 192, 28, 35, 140, 33, 3, 0, 255, 254, 0, 0, 7, 192, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 255, 240, 0, 7, 192, 30, 0, 7, 128, 7, 128, 7, 128, 7, 192,
  7, 128, 3, 224, 7, 128, 3, 224, 7, 128, 1, 240, 7, 128, 1, 240,
  7, 128, 1, 240, 7, 128, 1, 240, 7, 128, 1, 240, 7, 128, 1, 240,
  7, 128, 3, 224, 7, 128, 3, 224, 7, 128, 7, 192, 7, 128, 7, 128,
  7, 128, 30, 0, 7, 255, 248, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 192, 0, 0,
  255, 254, 0, 0, 22, 35, 105, 26, 1, 0, 0, 63, 128, 0, 243, 224,
  1, 192, 240, 3, 128, 240, 7, 128, 248, 7, 0, 120, 15, 0, 120, 15,
  0, 120, 15, 0, 248, 15, 0, 240, 15, 0, 224, 15, 1, 192, 15, 3,
  0, 15, 60, 0, 15, 6, 0, 15, 1, 128, 15, 0, 192, 15, 0, 224,
  15, 0, 112, 15, 0, 120, 15, 0, 120, 15, 0, 60, 15, 0, 60, 15,
  0, 60, 15, 0, 60, 15, 0, 60, 15, 0, 60, 15, 0, 60, 15, 56,
  60, 15, 120, 60, 15, 120, 60, 15, 112, 120, 15, 96, 112, 15, 48, 224,
  255, 31, 192, 21, 33, 99, 24, 2, 1, 56, 0, 0, 60, 0, 0, 30,
  0, 0, 14, 0, 0, 7, 0, 0, 3, 128, 0, 1, 128, 0, 0, 192,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 248, 0, 24, 30, 0,
  16, 15, 0, 48, 7, 0, 56, 7, 128, 60, 7, 128, 62, 7, 128, 28,
  7, 128, 0, 7, 128, 0, 31, 128, 3, 247, 128, 31, 7, 128, 60, 7,
  128, 120, 7, 128, 248, 7, 128, 240, 7, 128, 240, 15, 136, 240, 15, 136,
  240, 23, 136, 248, 23, 152, 120, 39, 240, 63, 195, 240, 21, 33, 99, 24,
  2, 1, 0, 7, 0, 0, 15, 128, 0, 15, 0, 0, 30, 0, 0, 60,
  0, 0, 48, 0, 0, 96, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 7, 248, 0, 24, 30, 0, 16, 15, 0, 48, 7, 0, 56,
  7, 128, 60, 7, 128, 62, 7, 128, 28, 7, 128, 0, 7, 128, 0, 31,
  128, 3, 247, 128, 31, 7, 128, 60, 7, 128, 120, 7, 128, 248, 7, 128,
  240, 7, 128, 240, 15, 136, 240, 15, 136, 240, 23, 136, 248, 23, 152, 120,
  39, 240, 63, 195, 240, 21, 33, 99, 24, 2, 0, 0, 192, 0, 0, 224,
  0, 1, 224, 0, 1, 240, 0, 3, 48, 0, 6, 24, 0, 12, 12, 0,
  24, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 248, 0, 24,
  30, 0, 16, 15, 0, 48, 7, 0, 56, 7, 128, 60, 7, 128, 62, 7,
  128, 28, 7, 128, 0, 7, 128, 0, 31, 128, 3, 247, 128, 31, 7, 128,
  60, 7, 128, 120, 7, 128, 248, 7, 128, 240, 7, 128, 240, 15, 136, 240,
  15, 136, 240, 23, 136, 248, 23, 152, 120, 39, 240, 63, 195, 240, 21, 32,
  96, 24, 2, 0, 15, 129, 0, 31, 227, 0, 31, 255, 0, 16, 254, 0,
  32, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 7, 248, 0, 24, 30, 0, 16, 15, 0, 48, 7, 0, 56, 7,
  128, 60, 7, 128, 62, 7, 128, 28, 7, 128, 0, 7, 128, 0, 31, 128,
  3, 247, 128, 31, 7, 128, 60, 7, 128, 120, 7, 128, 248, 7, 128, 240,
  7, 128, 240, 15, 136, 240, 15, 136, 240, 23, 136, 248, 23, 152, 120, 39,
  240, 63, 195, 240, 21, 32, 96, 24, 2, 0, 28, 14, 0, 62, 31, 0,
  62, 31, 0, 62, 31, 0, 28, 14, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 7, 248, 0, 24, 30, 0, 16, 15,
  0, 48, 7, 0, 56, 7, 128, 60, 7, 128, 62, 7, 128, 28, 7, 128,
  0, 7, 128, 0, 31, 128, 3, 247, 128, 31, 7, 128, 60, 7, 128, 120,
  7, 128, 248, 7, 128, 240, 7, 128, 240, 15, 136, 240, 15, 136, 240, 23,
  136, 248, 23, 152, 120, 39, 240, 63, 195, 240, 21, 34, 102, 24, 2, 0,
  1, 224, 0, 2, 24, 0, 4, 8, 0, 8, 4, 0, 8, 4, 0, 8,
  4, 0, 4, 12, 0, 6, 24, 0, 1, 240, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 7, 248, 0, 24, 30, 0, 16, 15, 0, 48, 7, 0,
  56, 7, 128, 60, 7, 128, 60, 7, 128, 28, 7, 128, 0, 7, 128, 0,
  31, 128, 3, 247, 128, 31, 7, 128, 60, 7, 128, 120, 7, 128, 248, 7,
  128, 240, 7, 128, 240, 15, 136, 240, 15, 136, 240, 31, 136, 248, 23, 152,
  120, 39, 240, 63, 195, 240, 30, 22, 88, 34, 2, 1, 7, 248, 63, 128,
  24, 30, 97, 224, 16, 15, 224, 224, 48, 7, 192, 112, 56, 7, 192, 120,
  60, 7, 128, 120, 62, 7, 128, 120, 30, 7, 128, 60, 0, 7, 128, 60,
  0, 15, 128, 60, 1, 247, 255, 252, 15, 7, 128, 0, 60, 7, 128, 0,
  120, 7, 128, 0, 248, 7, 128, 0, 240, 7, 128, 8, 240, 15, 128, 8,
  240, 11, 192, 8, 240, 27, 192, 16, 248, 17, 224, 48, 120, 32, 240, 96,
  63, 192, 127, 192, 17, 32, 96, 21, 2, 247, 7, 252, 0, 14, 6, 0,
  28, 3, 0, 56, 3, 0, 56, 3, 128, 120, 15, 128, 120, 15, 128, 240,
  15, 128, 240, 7, 0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0,
  0, 240, 0, 0, 240, 0, 128, 120, 0, 128, 120, 0, 128, 120, 1, 0,
  56, 1, 0, 28, 2, 0, 14, 6, 0, 7, 248, 0, 0, 128, 0, 0,
  128, 0, 1, 128, 0, 0, 240, 0, 0, 56, 0, 0, 28, 0, 0, 28,
  0, 0, 28, 0, 12, 56, 0, 3, 240, 0, 18, 33, 99, 22, 2, 1,
  60, 0, 0, 60, 0, 0, 30, 0, 0, 15, 0, 0, 7, 0, 0, 3,
  128, 0, 0, 192, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 7, 248, 0, 14, 28, 0, 28, 14, 0, 56, 15, 0, 56, 7, 128,
  120, 7, 128, 120, 7, 128, 240, 7, 192, 240, 7, 192, 240, 7, 192, 255,
  255, 192, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 128, 120, 0,
  128, 120, 0, 128, 120, 1, 128, 56, 1, 0, 28, 3, 0, 14, 6, 0,
  7, 252, 0, 18, 33, 99, 22, 2, 1, 0, 7, 0, 0, 15, 0, 0,
  15, 0, 0, 30, 0, 0, 60, 0, 0, 48, 0, 0, 96, 0, 0, 192,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 248, 0, 14, 28, 0,
  28, 14, 0, 56, 15, 0, 56, 7, 128, 120, 7, 128, 120, 7, 128, 240,
  7, 192, 240, 7, 192, 240, 7, 192, 255, 255, 192, 240, 0, 0, 240, 0,
  0, 240, 0, 0, 240, 0, 128, 120, 0, 128, 120, 0, 128, 120, 1, 128,
  56, 1, 0, 28, 3, 0, 14, 6, 0, 7, 252, 0, 18, 33, 99, 22,
  2, 0, 0, 192, 0, 0, 224, 0, 1, 224, 0, 1, 240, 0, 3, 184,
  0, 7, 24, 0, 4, 12, 0, 24, 2, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 7, 248, 0, 14, 28, 0, 28, 14, 0, 56, 15, 0, 56,
  7, 128, 120, 7, 128, 120, 7, 128, 240, 7, 192, 240, 7, 192, 240, 7,
  192, 255, 255, 192, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 128,
  120, 0, 128, 120, 0, 128, 120, 1, 128, 56, 1, 0, 28, 3, 0, 14,
  6, 0, 7, 252, 0, 18, 32, 96, 22, 2, 0, 28, 7, 0, 62, 15,
  128, 62, 15, 128, 62, 15, 128, 28, 7, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 248, 0, 14, 12, 0, 28,
  14, 0, 60, 7, 0, 56, 7, 128, 120, 3, 128, 120, 3, 128, 240, 3,
  192, 240, 3, 192, 240, 3, 192, 255, 255, 192, 240, 0, 0, 240, 0, 0,
  240, 0, 0, 240, 0, 64, 120, 0, 128, 120, 0, 128, 120, 0, 128, 56,
  1, 128, 28, 1, 0, 14, 6, 0, 7, 252, 0, 12, 33, 66, 14, 0,
  1, 224, 0, 240, 0, 240, 0, 120, 0, 60, 0, 12, 0, 6, 0, 3,
  0, 0, 0, 0, 0, 0, 0, 63, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 63, 240, 11, 33, 66, 13, 2, 1, 0, 224, 1, 224, 1, 224, 3,
  192, 7, 128, 6, 0, 12, 0, 24, 0, 0, 0, 0, 0, 0, 0, 254,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 255, 192, 13, 33, 66, 14, 0,
  0, 7, 0, 7, 0, 7, 128, 15, 128, 29, 192, 24, 96, 48, 48, 192,
  24, 0, 0, 0, 0, 0, 0, 63, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 63, 240, 13, 32, 64, 15, 1, 0, 112, 112, 248, 248, 248, 248, 248,
  248, 112, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 63, 240, 19, 35, 105, 24, 2, 0, 31,
  0, 0, 15, 131, 128, 7, 198, 0, 3, 252, 0, 1, 240, 0, 0, 240,
  0, 1, 248, 0, 7, 124, 0, 12, 60, 0, 24, 30, 0, 0, 31, 0,
  0, 15, 0, 0, 7, 128, 3, 255, 128, 14, 15, 192, 28, 7, 192, 60,
  3, 192, 56, 3, 224, 120, 3, 224, 120, 1, 224, 248, 1, 224, 240, 1,
  224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224,
  240, 1, 224, 120, 1, 192, 120, 3, 192, 56, 3, 192, 60, 3, 128, 28,
  7, 0, 14, 14, 0, 3, 252, 0, 23, 32, 96, 27, 2, 0, 1, 224,
  64, 3, 248, 192, 7, 255, 192, 6, 63, 128, 4, 7, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 31, 128, 30,
  97, 224, 30, 192, 224, 30, 128, 240, 31, 0, 240, 31, 0, 240, 30, 0,
  240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240,
  30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30,
  0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 255, 199, 254, 19, 33,
  99, 24, 2, 1, 28, 0, 0, 30, 0, 0, 30, 0, 0, 15, 0, 0,
  7, 128, 0, 1, 128, 0, 0, 192, 0, 0, 96, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 3, 252, 0, 14, 14, 0, 28, 7, 0, 60, 3,
  128, 56, 3, 192, 120, 3, 192, 120, 1, 224, 248, 1, 224, 240, 1, 224,
  240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240,
  1, 224, 120, 1, 224, 120, 3, 192, 56, 3, 192, 60, 3, 128, 28, 7,
  0, 14, 14, 0, 3, 252, 0, 19, 33, 99, 24, 2, 1, 0, 7, 0,
  0, 7, 128, 0, 15, 0, 0, 30, 0, 0, 28, 0, 0, 56, 0, 0,
  96, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 252,
  0, 14, 14, 0, 28, 7, 0, 60, 3, 128, 56, 3, 192, 120, 3, 192,
  120, 1, 224, 248, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240,
  1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 120, 1, 224, 120, 3,
  192, 56, 3, 192, 60, 3, 128, 28, 7, 0, 14, 14, 0, 3, 252, 0,
  19, 33, 99, 24, 2, 0, 0, 96, 0, 0, 224, 0, 0, 240, 0, 1,
  240, 0, 1, 184, 0, 3, 24, 0, 6, 4, 0, 8, 3, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 3, 252, 0, 14, 14, 0, 28, 7, 0,
  60, 3, 128, 56, 3, 192, 120, 3, 192, 120, 1, 224, 248, 1, 224, 240,
  1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1,
  224, 240, 1, 224, 120, 1, 224, 120, 3, 192, 56, 3, 192, 60, 3, 128,
  28, 7, 0, 14, 14, 0, 3, 252, 0, 19, 32, 96, 24, 2, 0, 7,
  129, 0, 15, 225, 0, 31, 255, 0, 24, 254, 0, 16, 28, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 252, 0,
  14, 14, 0, 28, 7, 0, 60, 3, 128, 56, 3, 192, 120, 3, 192, 120,
  1, 224, 248, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1,
  224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 120, 1, 224, 120, 3, 192,
  56, 3, 192, 60, 3, 128, 28, 7, 0, 14, 14, 0, 3, 252, 0, 19,
  32, 96, 24, 2, 0, 14, 7, 0, 31, 15, 128, 31, 15, 128, 31, 15,
  128, 14, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 3, 252, 0, 14, 14, 0, 28, 7, 0, 60, 3, 128, 56,
  3, 192, 120, 3, 192, 120, 1, 224, 248, 1, 224, 240, 1, 224, 240, 1,
  224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224,
  120, 1, 224, 120, 3, 192, 56, 3, 192, 60, 3, 128, 28, 7, 0, 14,
  14, 0, 3, 252, 0, 41, 31, 186, 45, 2, 253, 0, 0, 30, 0, 0,
  0, 0, 0, 63, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 63,
  0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255,
  255, 255, 255, 255, 128, 255, 255, 255, 255, 255, 128, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 30, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 63,
  0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0,
  0, 30, 0, 0, 0, 19, 22, 66, 24, 2, 1, 3, 252, 96, 14, 14,
  64, 28, 7, 192, 60, 3, 128, 56, 3, 192, 120, 7, 192, 120, 13, 224,
  248, 9, 224, 240, 25, 224, 240, 49, 224, 240, 97, 224, 240, 193, 224, 240,
  129, 224, 241, 129, 224, 243, 1, 224, 126, 1, 224, 124, 3, 192, 56, 3,
  192, 60, 3, 128, 60, 7, 0, 110, 14, 0, 195, 252, 0, 23, 33, 99,
  27, 2, 1, 14, 0, 0, 15, 0, 0, 7, 128, 0, 3, 192, 0, 1,
  192, 0, 0, 224, 0, 0, 48, 0, 0, 16, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 254, 7, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240,
  30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30,
  0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0,
  240, 30, 1, 240, 30, 1, 240, 30, 1, 240, 30, 2, 240, 14, 6, 240,
  15, 12, 240, 3, 240, 254, 23, 33, 99, 27, 2, 1, 0, 1, 192, 0,
  3, 192, 0, 3, 192, 0, 7, 128, 0, 14, 0, 0, 12, 0, 0, 24,
  0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 7, 240,
  30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30,
  0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0,
  240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 1, 240, 30, 1, 240,
  30, 1, 240, 30, 2, 240, 14, 6, 240, 15, 12, 240, 3, 240, 254, 23,
  33, 99, 27, 2, 0, 0, 48, 0, 0, 56, 0, 0, 120, 0, 0, 124,
  0, 0, 204, 0, 1, 134, 0, 3, 3, 0, 6, 0, 128, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 254, 7, 240, 30, 0, 240, 30, 0, 240, 30,
  0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0,
  240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240,
  30, 0, 240, 30, 1, 240, 30, 1, 240, 30, 1, 240, 30, 2, 240, 14,
  6, 240, 15, 12, 240, 3, 240, 254, 23, 32, 96, 27, 2, 0, 7, 3,
  128, 15, 135, 192, 15, 135, 192, 15, 135, 192, 7, 3, 128, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 7, 240, 30,
  0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0,
  240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240,
  30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 1, 240, 30, 1, 240, 30,
  1, 240, 30, 2, 240, 14, 6, 240, 15, 12, 240, 3, 240, 254, 24, 45,
  135, 26, 1, 246, 0, 0, 240, 0, 0, 240, 0, 1, 224, 0, 1, 192,
  0, 3, 128, 0, 7, 0, 0, 6, 0, 0, 12, 0, 0, 24, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 255, 225, 255, 31, 0, 120, 15, 0,
  48, 15, 0, 48, 7, 0, 32, 7, 128, 96, 7, 128, 96, 3, 192, 64,
  3, 192, 192, 3, 192, 192, 1, 224, 128, 1, 225, 128, 0, 225, 128, 0,
  241, 128, 0, 241, 0, 0, 115, 0, 0, 123, 0, 0, 122, 0, 0, 62,
  0, 0, 62, 0, 0, 60, 0, 0, 28, 0, 0, 28, 0, 0, 24, 0,
  0, 24, 0, 0, 24, 0, 24, 48, 0, 60, 48, 0, 60, 48, 0, 60,
  96, 0, 56, 96, 0, 31, 192, 0, 15, 0, 0, 20, 46, 138, 25, 2,
  243, 30, 0, 0, 126, 0, 0, 254, 0, 0, 30, 0, 0, 30, 0, 0,
  30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30,
  0, 0, 30, 15, 192, 30, 63, 224, 30, 97, 240, 30, 192, 240, 30, 128,
  240, 31, 128, 240, 31, 0, 240, 31, 0, 240, 30, 0, 240, 30, 0, 240,
  30, 1, 224, 30, 1, 224, 30, 1, 192, 30, 3, 128, 30, 3, 128, 30,
  7, 0, 30, 6, 0, 30, 12, 0, 30, 24, 0, 30, 48, 0, 30, 192,
  0, 31, 128, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0,
  30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30,
  0, 0, 60, 0, 0, 240, 0, 0, 128, 0, 0, 24, 43, 129, 26, 1,
  245, 1, 192, 224, 3, 225, 240, 3, 225, 240, 3, 225, 240, 1, 192, 224,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255,
  225, 255, 31, 128, 120, 15, 0, 48, 15, 0, 48, 7, 128, 32, 7, 128,
  96, 7, 128, 96, 3, 192, 64, 3, 192, 64, 3, 192, 192, 1, 224, 128,
  1, 224, 128, 0, 225, 128, 0, 241, 128, 0, 241, 0, 0, 115, 0, 0,
  123, 0, 0, 122, 0, 0, 62, 0, 0, 62, 0, 0, 60, 0, 0, 28,
  0, 0, 28, 0, 0, 24, 0, 0, 24, 0, 0, 24, 0, 24, 48, 0,
  60, 48, 0, 60, 48, 0, 60, 96, 0, 56, 96, 0, 31, 192, 0, 15,
  0, 0
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--49-490-72-72-P-256-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 0, '1' Height: 34
  Calculated Max Values w=41 h=46 x= 6 y=14 dx=45 dy= 0 ascent=36 len=246
  Font Bounding box     w=128 h=62 x=-40 y=-15
  Calculated Min Values           x= 0 y=-10 dx= 0 dy= 0
  Pure Font   ascent =34 descent= 0
  X Font      ascent =34 descent= 0
  Max Font    ascent =36 descent=-10
*/
const u8g_fntpgm_uint8_t u8g_font_osr35n[1588] U8G_FONT_SECTION("u8g_font_osr35n") = {
  0, 128, 62, 216, 241, 34, 0, 0, 0, 0, 42, 58, 0, 36, 246, 34,
  0, 18, 20, 60, 25, 4, 14, 0, 224, 0, 1, 224, 0, 1, 224, 0,
  1, 224, 0, 224, 195, 128, 240, 135, 192, 248, 143, 192, 60, 159, 128, 3,
  248, 0, 1, 224, 0, 3, 240, 0, 30, 190, 0, 124, 143, 128, 248, 135,
  192, 240, 195, 192, 97, 193, 128, 1, 224, 0, 1, 224, 0, 1, 224, 0,
  0, 224, 0, 41, 41, 246, 45, 2, 248, 0, 0, 12, 0, 0, 0, 0,
  0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0,
  0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12,
  0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0,
  0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0,
  0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12,
  0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0,
  0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 255, 255, 255, 255, 255,
  128, 255, 255, 255, 255, 255, 128, 0, 0, 12, 0, 0, 0, 0, 0, 12,
  0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0,
  0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0,
  0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12,
  0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0,
  0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0,
  0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12,
  0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 7,
  15, 15, 14, 4, 247, 120, 252, 252, 254, 126, 6, 6, 6, 4, 12, 8,
  24, 48, 96, 64, 12, 3, 6, 18, 3, 11, 255, 240, 255, 240, 255, 240,
  6, 5, 5, 14, 4, 1, 120, 252, 252, 252, 120, 16, 46, 92, 22, 3,
  246, 0, 3, 0, 3, 0, 3, 0, 6, 0, 6, 0, 6, 0, 12, 0,
  12, 0, 12, 0, 24, 0, 24, 0, 24, 0, 48, 0, 48, 0, 48, 0,
  48, 0, 96, 0, 96, 0, 96, 0, 192, 0, 192, 0, 192, 1, 128, 1,
  128, 1, 128, 3, 0, 3, 0, 3, 0, 6, 0, 6, 0, 6, 0, 12,
  0, 12, 0, 12, 0, 24, 0, 24, 0, 24, 0, 48, 0, 48, 0, 48,
  0, 96, 0, 96, 0, 96, 0, 96, 0, 192, 0, 192, 0, 23, 34, 102,
  28, 2, 0, 0, 124, 0, 1, 199, 0, 7, 1, 128, 6, 0, 192, 14,
  0, 224, 28, 0, 112, 60, 0, 120, 60, 0, 120, 56, 0, 56, 120, 0,
  60, 120, 0, 60, 120, 0, 60, 248, 0, 62, 248, 0, 62, 248, 0, 62,
  248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248,
  0, 62, 248, 0, 62, 120, 0, 60, 120, 0, 60, 120, 0, 60, 120, 0,
  60, 60, 0, 120, 60, 0, 120, 28, 0, 112, 28, 0, 112, 14, 0, 224,
  7, 1, 192, 3, 131, 128, 0, 254, 0, 17, 34, 102, 28, 6, 0, 0,
  64, 0, 0, 64, 0, 0, 192, 0, 0, 192, 0, 1, 192, 0, 7, 192,
  0, 255, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0,
  3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192,
  0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0,
  3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 255,
  255, 128, 255, 255, 128, 21, 34, 102, 28, 4, 0, 3, 252, 0, 14, 31,
  0, 16, 7, 192, 32, 3, 224, 96, 1, 240, 64, 1, 240, 192, 0, 240,
  192, 0, 248, 224, 0, 248, 252, 0, 248, 254, 0, 248, 126, 0, 248, 126,
  0, 240, 62, 1, 240, 0, 1, 224, 0, 3, 192, 0, 3, 128, 0, 7,
  0, 0, 14, 0, 0, 28, 0, 0, 112, 0, 0, 224, 0, 1, 192, 0,
  3, 0, 0, 6, 0, 16, 12, 0, 16, 24, 0, 16, 16, 0, 16, 48,
  0, 48, 48, 0, 112, 127, 255, 240, 127, 255, 240, 127, 255, 240, 127, 255,
  240, 21, 34, 102, 28, 4, 0, 3, 248, 0, 14, 31, 0, 24, 7, 128,
  48, 3, 192, 112, 3, 192, 120, 1, 224, 124, 1, 224, 126, 1, 224, 126,
  1, 224, 60, 1, 224, 0, 1, 224, 0, 3, 192, 0, 3, 192, 0, 7,
  128, 0, 14, 0, 15, 248, 0, 31, 143, 0, 14, 3, 128, 0, 3, 224,
  0, 1, 224, 0, 1, 240, 0, 0, 248, 0, 0, 248, 0, 0, 248, 60,
  0, 248, 126, 0, 248, 254, 0, 248, 254, 0, 248, 252, 1, 240, 224, 1,
  240, 224, 3, 224, 96, 3, 192, 48, 15, 0, 15, 254, 0, 23, 34, 102,
  28, 3, 0, 0, 1, 128, 0, 1, 128, 0, 3, 128, 0, 7, 128, 0,
  7, 128, 0, 15, 128, 0, 31, 128, 0, 31, 128, 0, 55, 128, 0, 119,
  128, 0, 231, 128, 0, 199, 128, 1, 199, 128, 3, 135, 128, 3, 7, 128,
  6, 7, 128, 14, 7, 128, 12, 7, 128, 24, 7, 128, 56, 7, 128, 48,
  7, 128, 96, 7, 128, 224, 7, 128, 255, 255, 254, 0, 7, 128, 0, 7,
  128, 0, 7, 128, 0, 7, 128, 0, 7, 128, 0, 7, 128, 0, 7, 128,
  0, 7, 128, 3, 255, 254, 3, 255, 254, 21, 35, 105, 28, 4, 0, 48,
  0, 64, 60, 3, 192, 63, 255, 128, 63, 255, 0, 63, 252, 0, 55, 240,
  0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0,
  48, 0, 0, 48, 0, 0, 51, 254, 0, 60, 7, 128, 56, 3, 192, 48,
  1, 224, 48, 1, 240, 48, 1, 240, 0, 0, 240, 0, 0, 248, 0, 0,
  248, 0, 0, 248, 0, 0, 248, 60, 0, 248, 126, 0, 248, 254, 0, 248,
  254, 0, 240, 252, 1, 240, 248, 1, 224, 240, 1, 224, 112, 3, 192, 112,
  7, 128, 60, 31, 0, 15, 252, 0, 21, 34, 102, 28, 4, 0, 0, 126,
  0, 1, 193, 128, 3, 128, 192, 7, 0, 64, 14, 0, 224, 28, 1, 224,
  28, 3, 224, 56, 3, 224, 56, 3, 192, 120, 0, 0, 120, 0, 0, 120,
  0, 0, 120, 0, 0, 240, 126, 0, 241, 255, 128, 243, 131, 192, 247, 1,
  224, 254, 1, 240, 252, 0, 240, 252, 0, 240, 248, 0, 248, 248, 0, 120,
  248, 0, 120, 248, 0, 120, 120, 0, 120, 120, 0, 120, 120, 0, 248, 120,
  0, 240, 56, 0, 240, 60, 0, 224, 28, 1, 224, 14, 3, 192, 7, 7,
  128, 1, 254, 0, 19, 34, 102, 28, 5, 0, 255, 255, 224, 255, 255, 224,
  255, 255, 224, 255, 255, 224, 224, 0, 224, 192, 0, 64, 128, 0, 64, 128,
  0, 192, 128, 0, 128, 128, 1, 128, 0, 1, 128, 0, 3, 0, 0, 2,
  0, 0, 6, 0, 0, 12, 0, 0, 24, 0, 0, 24, 0, 0, 48, 0,
  0, 112, 0, 0, 112, 0, 0, 224, 0, 0, 224, 0, 1, 224, 0, 1,
  224, 0, 3, 224, 0, 3, 224, 0, 3, 224, 0, 7, 240, 0, 7, 240,
  0, 7, 240, 0, 7, 240, 0, 7, 240, 0, 3, 240, 0, 3, 224, 0,
  23, 34, 102, 28, 3, 0, 1, 254, 0, 7, 135, 128, 30, 1, 192, 56,
  0, 224, 120, 0, 112, 112, 0, 112, 240, 0, 56, 240, 0, 56, 240, 0,
  56, 240, 0, 56, 248, 0, 56, 252, 0, 112, 126, 0, 112, 127, 192, 224,
  63, 241, 192, 31, 255, 0, 7, 255, 128, 7, 255, 224, 12, 63, 248, 56,
  7, 252, 112, 1, 252, 112, 0, 126, 224, 0, 62, 224, 0, 62, 224, 0,
  62, 224, 0, 30, 224, 0, 30, 224, 0, 28, 96, 0, 60, 112, 0, 56,
  48, 0, 120, 24, 0, 240, 14, 1, 192, 3, 255, 0, 21, 34, 102, 28,
  4, 0, 1, 248, 0, 7, 142, 0, 14, 3, 0, 28, 1, 128, 56, 1,
  192, 120, 1, 224, 120, 0, 224, 120, 0, 240, 240, 0, 240, 240, 0, 240,
  240, 0, 240, 240, 0, 248, 240, 0, 248, 248, 0, 248, 120, 1, 248, 120,
  1, 248, 120, 3, 248, 60, 7, 120, 30, 14, 120, 15, 252, 120, 3, 240,
  120, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 60, 0, 224,
  124, 0, 224, 124, 1, 192, 124, 1, 192, 120, 3, 128, 112, 3, 0, 56,
  6, 0, 28, 28, 0, 15, 248, 0, 6, 22, 22, 14, 4, 1, 120, 252,
  252, 252, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120,
  252, 252, 252, 120
};

/*
  Fontname: -FreeType-Old Standard TT-Medium-R-Normal--49-490-72-72-P-256-ISO10646-1
  Copyright: Copyright (C) 2006-2008 Alexey Kryukov <alexios@thessalonica.org.ru>
  Capital A Height: 35, '1' Height: 34
  Calculated Max Values w=49 h=46 x= 6 y=26 dx=52 dy= 0 ascent=37 len=252
  Font Bounding box     w=128 h=62 x=-40 y=-15
  Calculated Min Values           x=-2 y=-11 dx= 0 dy= 0
  Pure Font   ascent =35 descent=-10
  X Font      ascent =36 descent=-10
  Max Font    ascent =37 descent=-11
*/
const u8g_fntpgm_uint8_t u8g_font_osr35r[10371] U8G_FONT_SECTION("u8g_font_osr35r") = {
  0, 128, 62, 216, 241, 35, 12, 236, 30, 116, 32, 127, 246, 37, 245, 36,
  246, 0, 0, 0, 14, 0, 0, 6, 34, 34, 14, 4, 0, 120, 252, 252,
  252, 252, 252, 252, 252, 252, 120, 120, 120, 120, 120, 120, 48, 48, 48, 48,
  48, 48, 48, 48, 48, 48, 48, 0, 0, 0, 120, 252, 252, 252, 120, 11,
  10, 20, 19, 4, 26, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224, 224,
  224, 64, 64, 64, 64, 64, 64, 64, 64, 26, 34, 136, 34, 4, 0, 0,
  48, 24, 0, 0, 48, 24, 0, 0, 112, 24, 0, 0, 96, 24, 0, 0,
  96, 56, 0, 0, 96, 56, 0, 0, 96, 48, 0, 0, 96, 48, 0, 0,
  96, 48, 0, 0, 224, 48, 0, 255, 255, 255, 192, 255, 255, 255, 192, 0,
  192, 96, 0, 0, 192, 96, 0, 0, 192, 96, 0, 1, 192, 96, 0, 1,
  128, 96, 0, 1, 128, 224, 0, 1, 128, 192, 0, 1, 128, 192, 0, 1,
  128, 192, 0, 3, 128, 192, 0, 255, 255, 255, 192, 255, 255, 255, 192, 3,
  1, 128, 0, 3, 1, 128, 0, 3, 1, 128, 0, 7, 1, 128, 0, 7,
  1, 128, 0, 6, 1, 128, 0, 6, 3, 128, 0, 6, 3, 0, 0, 6,
  3, 0, 0, 6, 3, 0, 0, 22, 41, 123, 29, 3, 252, 0, 204, 0,
  0, 204, 0, 0, 204, 0, 1, 254, 0, 7, 207, 192, 12, 204, 96, 24,
  204, 48, 48, 204, 24, 32, 204, 24, 96, 204, 28, 96, 204, 60, 96, 204,
  124, 96, 204, 124, 112, 204, 120, 120, 204, 120, 62, 204, 0, 63, 204, 0,
  31, 252, 0, 15, 252, 0, 7, 255, 128, 1, 255, 192, 0, 255, 224, 0,
  207, 240, 0, 205, 248, 0, 204, 120, 48, 204, 60, 120, 204, 28, 248, 204,
  28, 248, 204, 12, 240, 204, 12, 240, 204, 8, 224, 204, 24, 96, 204, 24,
  96, 204, 48, 48, 204, 96, 28, 205, 192, 7, 255, 128, 0, 204, 0, 0,
  204, 0, 0, 204, 0, 0, 204, 0, 33, 34, 170, 43, 5, 0, 15, 128,
  0, 48, 0, 24, 192, 0, 96, 0, 48, 96, 0, 64, 0, 112, 112, 0,
  192, 0, 96, 48, 1, 128, 0, 224, 56, 1, 128, 0, 224, 56, 3, 0,
  0, 224, 56, 2, 0, 0, 224, 56, 6, 0, 0, 224, 56, 12, 0, 0,
  224, 56, 12, 0, 0, 224, 56, 24, 0, 0, 96, 48, 48, 0, 0, 96,
  112, 48, 0, 0, 48, 96, 96, 0, 0, 24, 192, 64, 0, 0, 15, 128,
  192, 0, 0, 0, 1, 128, 248, 0, 0, 1, 129, 140, 0, 0, 3, 3,
  6, 0, 0, 2, 6, 7, 0, 0, 6, 6, 3, 0, 0, 12, 14, 3,
  128, 0, 8, 14, 3, 128, 0, 24, 14, 3, 128, 0, 48, 14, 3, 128,
  0, 48, 14, 3, 128, 0, 96, 14, 3, 128, 0, 64, 14, 3, 128, 0,
  192, 6, 3, 0, 1, 128, 6, 3, 0, 1, 128, 7, 7, 0, 3, 0,
  3, 14, 0, 6, 0, 1, 252, 0, 33, 34, 170, 39, 3, 0, 0, 63,
  0, 0, 0, 0, 227, 128, 0, 0, 1, 128, 192, 0, 0, 3, 128, 64,
  0, 0, 3, 0, 96, 0, 0, 7, 0, 96, 0, 0, 7, 0, 96, 0,
  0, 7, 0, 224, 0, 0, 7, 0, 192, 0, 0, 7, 129, 192, 0, 0,
  7, 131, 128, 0, 0, 3, 199, 0, 0, 0, 3, 238, 0, 0, 0, 1,
  248, 0, 0, 0, 0, 248, 7, 255, 128, 1, 248, 0, 252, 0, 3, 252,
  0, 112, 0, 7, 62, 0, 112, 0, 14, 63, 0, 96, 0, 28, 31, 0,
  96, 0, 60, 15, 128, 192, 0, 56, 7, 192, 192, 0, 120, 7, 193, 128,
  0, 120, 3, 225, 128, 0, 240, 1, 243, 0, 0, 240, 1, 254, 0, 0,
  240, 0, 254, 0, 0, 240, 0, 124, 0, 0, 248, 0, 62, 0, 0, 248,
  0, 62, 1, 0, 120, 0, 127, 1, 0, 60, 0, 207, 130, 0, 30, 3,
  135, 252, 0, 15, 254, 1, 248, 0, 3, 10, 10, 11, 4, 26, 224, 224,
  224, 224, 224, 224, 64, 64, 64, 64, 11, 46, 92, 18, 5, 246, 0, 64,
  0, 224, 1, 192, 3, 128, 3, 0, 6, 0, 14, 0, 12, 0, 28, 0,
  24, 0, 56, 0, 48, 0, 48, 0, 112, 0, 96, 0, 96, 0, 96, 0,
  224, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0, 192, 0,
  192, 0, 192, 0, 192, 0, 224, 0, 96, 0, 96, 0, 96, 0, 112, 0,
  48, 0, 48, 0, 56, 0, 24, 0, 28, 0, 12, 0, 14, 0, 6, 0,
  3, 0, 3, 128, 1, 192, 0, 224, 0, 64, 11, 45, 90, 18, 2, 246,
  64, 0, 96, 0, 112, 0, 56, 0, 28, 0, 12, 0, 14, 0, 6, 0,
  3, 0, 3, 0, 3, 128, 1, 128, 1, 192, 0, 192, 0, 192, 0, 192,
  0, 224, 0, 96, 0, 96, 0, 96, 0, 96, 0, 96, 0, 96, 0, 96,
  0, 96, 0, 96, 0, 96, 0, 96, 0, 96, 0, 224, 0, 192, 0, 192,
  0, 192, 1, 128, 1, 128, 3, 128, 3, 0, 7, 0, 6, 0, 14, 0,
  12, 0, 24, 0, 56, 0, 112, 0, 224, 0, 18, 20, 60, 25, 4, 14,
  0, 224, 0, 1, 224, 0, 1, 224, 0, 1, 224, 0, 224, 195, 128, 240,
  135, 192, 248, 143, 192, 60, 159, 128, 3, 248, 0, 1, 224, 0, 3, 240,
  0, 30, 190, 0, 124, 143, 128, 248, 135, 192, 240, 195, 192, 97, 193, 128,
  1, 224, 0, 1, 224, 0, 1, 224, 0, 0, 224, 0, 41, 41, 246, 45,
  2, 248, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0,
  12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0,
  0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0,
  0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0,
  12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0,
  0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0,
  0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0,
  12, 0, 0, 0, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255, 255, 128,
  0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0,
  0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0,
  12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0,
  0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0,
  0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0,
  12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0,
  0, 0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 12, 0,
  0, 0, 0, 0, 12, 0, 0, 0, 7, 15, 15, 14, 4, 247, 120, 252,
  252, 254, 126, 6, 6, 6, 4, 12, 8, 24, 48, 96, 64, 12, 3, 6,
  18, 3, 11, 255, 240, 255, 240, 255, 240, 6, 5, 5, 14, 4, 1, 120,
  252, 252, 252, 120, 16, 46, 92, 22, 3, 246, 0, 3, 0, 3, 0, 3,
  0, 6, 0, 6, 0, 6, 0, 12, 0, 12, 0, 12, 0, 24, 0, 24,
  0, 24, 0, 48, 0, 48, 0, 48, 0, 48, 0, 96, 0, 96, 0, 96,
  0, 192, 0, 192, 0, 192, 1, 128, 1, 128, 1, 128, 3, 0, 3, 0,
  3, 0, 6, 0, 6, 0, 6, 0, 12, 0, 12, 0, 12, 0, 24, 0,
  24, 0, 24, 0, 48, 0, 48, 0, 48, 0, 96, 0, 96, 0, 96, 0,
  96, 0, 192, 0, 192, 0, 23, 34, 102, 28, 2, 0, 0, 124, 0, 1,
  199, 0, 7, 1, 128, 6, 0, 192, 14, 0, 224, 28, 0, 112, 60, 0,
  120, 60, 0, 120, 56, 0, 56, 120, 0, 60, 120, 0, 60, 120, 0, 60,
  248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248,
  0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 248, 0, 62, 120, 0,
  60, 120, 0, 60, 120, 0, 60, 120, 0, 60, 60, 0, 120, 60, 0, 120,
  28, 0, 112, 28, 0, 112, 14, 0, 224, 7, 1, 192, 3, 131, 128, 0,
  254, 0, 17, 34, 102, 28, 6, 0, 0, 64, 0, 0, 64, 0, 0, 192,
  0, 0, 192, 0, 1, 192, 0, 7, 192, 0, 255, 192, 0, 3, 192, 0,
  3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192,
  0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0,
  3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 0, 255, 255, 128, 255, 255, 128, 21, 34,
  102, 28, 4, 0, 3, 252, 0, 14, 31, 0, 16, 7, 192, 32, 3, 224,
  96, 1, 240, 64, 1, 240, 192, 0, 240, 192, 0, 248, 224, 0, 248, 252,
  0, 248, 254, 0, 248, 126, 0, 248, 126, 0, 240, 62, 1, 240, 0, 1,
  224, 0, 3, 192, 0, 3, 128, 0, 7, 0, 0, 14, 0, 0, 28, 0,
  0, 112, 0, 0, 224, 0, 1, 192, 0, 3, 0, 0, 6, 0, 16, 12,
  0, 16, 24, 0, 16, 16, 0, 16, 48, 0, 48, 48, 0, 112, 127, 255,
  240, 127, 255, 240, 127, 255, 240, 127, 255, 240, 21, 34, 102, 28, 4, 0,
  3, 248, 0, 14, 31, 0, 24, 7, 128, 48, 3, 192, 112, 3, 192, 120,
  1, 224, 124, 1, 224, 126, 1, 224, 126, 1, 224, 60, 1, 224, 0, 1,
  224, 0, 3, 192, 0, 3, 192, 0, 7, 128, 0, 14, 0, 15, 248, 0,
  31, 143, 0, 14, 3, 128, 0, 3, 224, 0, 1, 224, 0, 1, 240, 0,
  0, 248, 0, 0, 248, 0, 0, 248, 60, 0, 248, 126, 0, 248, 254, 0,
  248, 254, 0, 248, 252, 1, 240, 224, 1, 240, 224, 3, 224, 96, 3, 192,
  48, 15, 0, 15, 254, 0, 23, 34, 102, 28, 3, 0, 0, 1, 128, 0,
  1, 128, 0, 3, 128, 0, 7, 128, 0, 7, 128, 0, 15, 128, 0, 31,
  128, 0, 31, 128, 0, 55, 128, 0, 119, 128, 0, 231, 128, 0, 199, 128,
  1, 199, 128, 3, 135, 128, 3, 7, 128, 6, 7, 128, 14, 7, 128, 12,
  7, 128, 24, 7, 128, 56, 7, 128, 48, 7, 128, 96, 7, 128, 224, 7,
  128, 255, 255, 254, 0, 7, 128, 0, 7, 128, 0, 7, 128, 0, 7, 128,
  0, 7, 128, 0, 7, 128, 0, 7, 128, 0, 7, 128, 3, 255, 254, 3,
  255, 254, 21, 35, 105, 28, 4, 0, 48, 0, 64, 60, 3, 192, 63, 255,
  128, 63, 255, 0, 63, 252, 0, 55, 240, 0, 48, 0, 0, 48, 0, 0,
  48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 48, 0, 0, 51,
  254, 0, 60, 7, 128, 56, 3, 192, 48, 1, 224, 48, 1, 240, 48, 1,
  240, 0, 0, 240, 0, 0, 248, 0, 0, 248, 0, 0, 248, 0, 0, 248,
  60, 0, 248, 126, 0, 248, 254, 0, 248, 254, 0, 240, 252, 1, 240, 248,
  1, 224, 240, 1, 224, 112, 3, 192, 112, 7, 128, 60, 31, 0, 15, 252,
  0, 21, 34, 102, 28, 4, 0, 0, 126, 0, 1, 193, 128, 3, 128, 192,
  7, 0, 64, 14, 0, 224, 28, 1, 224, 28, 3, 224, 56, 3, 224, 56,
  3, 192, 120, 0, 0, 120, 0, 0, 120, 0, 0, 120, 0, 0, 240, 126,
  0, 241, 255, 128, 243, 131, 192, 247, 1, 224, 254, 1, 240, 252, 0, 240,
  252, 0, 240, 248, 0, 248, 248, 0, 120, 248, 0, 120, 248, 0, 120, 120,
  0, 120, 120, 0, 120, 120, 0, 248, 120, 0, 240, 56, 0, 240, 60, 0,
  224, 28, 1, 224, 14, 3, 192, 7, 7, 128, 1, 254, 0, 19, 34, 102,
  28, 5, 0, 255, 255, 224, 255, 255, 224, 255, 255, 224, 255, 255, 224, 224,
  0, 224, 192, 0, 64, 128, 0, 64, 128, 0, 192, 128, 0, 128, 128, 1,
  128, 0, 1, 128, 0, 3, 0, 0, 2, 0, 0, 6, 0, 0, 12, 0,
  0, 24, 0, 0, 24, 0, 0, 48, 0, 0, 112, 0, 0, 112, 0, 0,
  224, 0, 0, 224, 0, 1, 224, 0, 1, 224, 0, 3, 224, 0, 3, 224,
  0, 3, 224, 0, 7, 240, 0, 7, 240, 0, 7, 240, 0, 7, 240, 0,
  7, 240, 0, 3, 240, 0, 3, 224, 0, 23, 34, 102, 28, 3, 0, 1,
  254, 0, 7, 135, 128, 30, 1, 192, 56, 0, 224, 120, 0, 112, 112, 0,
  112, 240, 0, 56, 240, 0, 56, 240, 0, 56, 240, 0, 56, 248, 0, 56,
  252, 0, 112, 126, 0, 112, 127, 192, 224, 63, 241, 192, 31, 255, 0, 7,
  255, 128, 7, 255, 224, 12, 63, 248, 56, 7, 252, 112, 1, 252, 112, 0,
  126, 224, 0, 62, 224, 0, 62, 224, 0, 62, 224, 0, 30, 224, 0, 30,
  224, 0, 28, 96, 0, 60, 112, 0, 56, 48, 0, 120, 24, 0, 240, 14,
  1, 192, 3, 255, 0, 21, 34, 102, 28, 4, 0, 1, 248, 0, 7, 142,
  0, 14, 3, 0, 28, 1, 128, 56, 1, 192, 120, 1, 224, 120, 0, 224,
  120, 0, 240, 240, 0, 240, 240, 0, 240, 240, 0, 240, 240, 0, 248, 240,
  0, 248, 248, 0, 248, 120, 1, 248, 120, 1, 248, 120, 3, 248, 60, 7,
  120, 30, 14, 120, 15, 252, 120, 3, 240, 120, 0, 0, 240, 0, 0, 240,
  0, 0, 240, 0, 0, 240, 60, 0, 224, 124, 0, 224, 124, 1, 192, 124,
  1, 192, 120, 3, 128, 112, 3, 0, 56, 6, 0, 28, 28, 0, 15, 248,
  0, 6, 22, 22, 14, 4, 1, 120, 252, 252, 252, 120, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 120, 252, 252, 252, 120, 7, 31, 31,
  14, 4, 248, 120, 252, 252, 252, 120, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 120, 252, 252, 254, 126, 14, 6, 6, 4, 12, 8, 24, 48,
  96, 64, 38, 40, 200, 46, 4, 249, 0, 0, 0, 0, 28, 0, 0, 0,
  0, 120, 0, 0, 0, 1, 240, 0, 0, 0, 7, 192, 0, 0, 0, 15,
  0, 0, 0, 0, 60, 0, 0, 0, 0, 240, 0, 0, 0, 3, 192, 0,
  0, 0, 15, 0, 0, 0, 0, 62, 0, 0, 0, 0, 248, 0, 0, 0,
  1, 224, 0, 0, 0, 7, 128, 0, 0, 0, 30, 0, 0, 0, 0, 120,
  0, 0, 0, 1, 224, 0, 0, 0, 7, 192, 0, 0, 0, 31, 0, 0,
  0, 0, 60, 0, 0, 0, 0, 240, 0, 0, 0, 0, 240, 0, 0, 0,
  0, 124, 0, 0, 0, 0, 31, 0, 0, 0, 0, 7, 128, 0, 0, 0,
  1, 224, 0, 0, 0, 0, 120, 0, 0, 0, 0, 30, 0, 0, 0, 0,
  7, 128, 0, 0, 0, 3, 224, 0, 0, 0, 0, 248, 0, 0, 0, 0,
  60, 0, 0, 0, 0, 15, 0, 0, 0, 0, 3, 192, 0, 0, 0, 0,
  240, 0, 0, 0, 0, 60, 0, 0, 0, 0, 31, 0, 0, 0, 0, 7,
  192, 0, 0, 0, 1, 224, 0, 0, 0, 0, 120, 0, 0, 0, 0, 28,
  41, 11, 66, 45, 2, 7, 255, 255, 255, 255, 255, 128, 255, 255, 255, 255,
  255, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
  255, 128, 255, 255, 255, 255, 255, 128, 38, 40, 200, 46, 4, 249, 224, 0,
  0, 0, 0, 120, 0, 0, 0, 0, 62, 0, 0, 0, 0, 15, 128, 0,
  0, 0, 3, 192, 0, 0, 0, 0, 240, 0, 0, 0, 0, 60, 0, 0,
  0, 0, 15, 0, 0, 0, 0, 3, 192, 0, 0, 0, 1, 240, 0, 0,
  0, 0, 124, 0, 0, 0, 0, 30, 0, 0, 0, 0, 7, 128, 0, 0,
  0, 1, 224, 0, 0, 0, 0, 120, 0, 0, 0, 0, 30, 0, 0, 0,
  0, 15, 128, 0, 0, 0, 3, 224, 0, 0, 0, 0, 240, 0, 0, 0,
  0, 60, 0, 0, 0, 0, 60, 0, 0, 0, 0, 248, 0, 0, 0, 3,
  224, 0, 0, 0, 7, 128, 0, 0, 0, 30, 0, 0, 0, 0, 120, 0,
  0, 0, 1, 224, 0, 0, 0, 7, 128, 0, 0, 0, 31, 0, 0, 0,
  0, 124, 0, 0, 0, 0, 240, 0, 0, 0, 3, 192, 0, 0, 0, 15,
  0, 0, 0, 0, 60, 0, 0, 0, 0, 240, 0, 0, 0, 3, 224, 0,
  0, 0, 15, 128, 0, 0, 0, 30, 0, 0, 0, 0, 120, 0, 0, 0,
  0, 224, 0, 0, 0, 0, 18, 34, 102, 23, 3, 0, 7, 240, 0, 28,
  60, 0, 48, 15, 0, 96, 7, 128, 192, 7, 128, 192, 3, 192, 192, 3,
  192, 248, 3, 192, 252, 3, 192, 124, 7, 192, 56, 7, 128, 0, 15, 128,
  0, 31, 0, 0, 62, 0, 0, 124, 0, 0, 240, 0, 0, 224, 0, 1,
  192, 0, 3, 0, 0, 6, 0, 0, 14, 8, 0, 12, 8, 0, 12, 8,
  0, 12, 8, 0, 6, 16, 0, 3, 224, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 1, 224, 0, 3, 240, 0, 3, 240, 0, 3, 240, 0, 1,
  224, 0, 35, 36, 180, 40, 2, 0, 0, 3, 254, 0, 0, 0, 30, 7,
  192, 0, 0, 112, 0, 112, 0, 1, 192, 0, 24, 0, 3, 128, 0, 12,
  0, 7, 0, 0, 6, 0, 14, 0, 0, 3, 0, 28, 0, 120, 1, 0,
  24, 1, 196, 225, 128, 56, 7, 7, 224, 128, 48, 14, 3, 224, 192, 112,
  12, 3, 192, 192, 96, 28, 3, 192, 64, 96, 56, 3, 192, 96, 224, 56,
  3, 192, 96, 192, 120, 3, 128, 96, 192, 112, 7, 128, 96, 192, 112, 7,
  128, 96, 192, 240, 7, 128, 96, 192, 224, 7, 0, 96, 192, 224, 15, 0,
  224, 192, 224, 15, 0, 192, 192, 224, 14, 0, 192, 96, 224, 30, 1, 128,
  96, 224, 62, 1, 128, 96, 224, 62, 3, 0, 96, 96, 78, 6, 0, 48,
  49, 143, 12, 0, 48, 31, 7, 240, 0, 24, 0, 0, 0, 0, 12, 0,
  0, 0, 0, 6, 0, 0, 0, 0, 3, 0, 0, 0, 0, 1, 192, 0,
  112, 0, 0, 112, 1, 192, 0, 0, 31, 255, 0, 0, 34, 35, 175, 37,
  2, 0, 0, 0, 192, 0, 0, 0, 0, 192, 0, 0, 0, 0, 224, 0,
  0, 0, 1, 224, 0, 0, 0, 1, 224, 0, 0, 0, 3, 240, 0, 0,
  0, 3, 240, 0, 0, 0, 3, 240, 0, 0, 0, 6, 248, 0, 0, 0,
  6, 248, 0, 0, 0, 6, 248, 0, 0, 0, 12, 124, 0, 0, 0, 12,
  124, 0, 0, 0, 12, 124, 0, 0, 0, 24, 62, 0, 0, 0, 24, 62,
  0, 0, 0, 24, 30, 0, 0, 0, 48, 31, 0, 0, 0, 48, 31, 0,
  0, 0, 48, 15, 0, 0, 0, 96, 15, 128, 0, 0, 96, 15, 128, 0,
  0, 96, 7, 128, 0, 0, 255, 255, 192, 0, 0, 255, 255, 192, 0, 0,
  192, 3, 192, 0, 1, 128, 3, 224, 0, 1, 128, 3, 224, 0, 3, 128,
  1, 224, 0, 3, 0, 1, 240, 0, 3, 0, 1, 240, 0, 7, 0, 0,
  240, 0, 7, 0, 0, 248, 0, 31, 128, 1, 252, 0, 255, 248, 31, 255,
  192, 28, 35, 140, 34, 3, 0, 255, 255, 240, 0, 7, 192, 62, 0, 7,
  128, 15, 0, 7, 128, 7, 128, 7, 128, 3, 192, 7, 128, 1, 224, 7,
  128, 1, 224, 7, 128, 1, 224, 7, 128, 1, 224, 7, 128, 1, 224, 7,
  128, 1, 224, 7, 128, 1, 224, 7, 128, 3, 192, 7, 128, 3, 128, 7,
  128, 7, 0, 7, 128, 30, 0, 7, 255, 240, 0, 7, 128, 62, 0, 7,
  128, 15, 0, 7, 128, 7, 128, 7, 128, 3, 192, 7, 128, 3, 224, 7,
  128, 1, 224, 7, 128, 1, 240, 7, 128, 1, 240, 7, 128, 1, 240, 7,
  128, 1, 240, 7, 128, 1, 240, 7, 128, 1, 240, 7, 128, 3, 224, 7,
  128, 3, 224, 7, 128, 7, 192, 7, 128, 15, 128, 7, 192, 62, 0, 255,
  255, 240, 0, 26, 36, 144, 32, 3, 0, 0, 63, 0, 128, 0, 225, 224,
  128, 3, 128, 113, 128, 7, 0, 63, 128, 14, 0, 31, 128, 30, 0, 15,
  128, 28, 0, 7, 128, 60, 0, 3, 128, 60, 0, 3, 128, 124, 0, 3,
  128, 120, 0, 1, 128, 120, 0, 1, 128, 120, 0, 0, 128, 248, 0, 0,
  128, 248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0,
  0, 248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0,
  0, 248, 0, 0, 0, 120, 0, 0, 192, 120, 0, 0, 192, 120, 0, 0,
  192, 60, 0, 0, 192, 60, 0, 0, 128, 60, 0, 1, 128, 28, 0, 1,
  128, 14, 0, 3, 0, 14, 0, 3, 0, 7, 0, 6, 0, 3, 128, 12,
  0, 0, 224, 56, 0, 0, 127, 224, 0, 33, 35, 175, 38, 3, 0, 255,
  255, 252, 0, 0, 7, 192, 15, 0, 0, 7, 128, 3, 192, 0, 7, 128,
  0, 224, 0, 7, 128, 0, 112, 0, 7, 128, 0, 120, 0, 7, 128, 0,
  60, 0, 7, 128, 0, 62, 0, 7, 128, 0, 30, 0, 7, 128, 0, 31,
  0, 7, 128, 0, 31, 0, 7, 128, 0, 15, 0, 7, 128, 0, 15, 0,
  7, 128, 0, 15, 128, 7, 128, 0, 15, 128, 7, 128, 0, 15, 128, 7,
  128, 0, 15, 128, 7, 128, 0, 15, 128, 7, 128, 0, 15, 128, 7, 128,
  0, 15, 128, 7, 128, 0, 15, 128, 7, 128, 0, 15, 128, 7, 128, 0,
  15, 0, 7, 128, 0, 31, 0, 7, 128, 0, 31, 0, 7, 128, 0, 30,
  0, 7, 128, 0, 30, 0, 7, 128, 0, 60, 0, 7, 128, 0, 60, 0,
  7, 128, 0, 120, 0, 7, 128, 0, 112, 0, 7, 128, 0, 224, 0, 7,
  128, 3, 192, 0, 7, 192, 15, 0, 0, 255, 255, 252, 0, 0, 28, 35,
  140, 34, 3, 0, 255, 255, 255, 240, 7, 192, 7, 240, 7, 128, 1, 240,
  7, 128, 0, 240, 7, 128, 0, 112, 7, 128, 0, 112, 7, 128, 0, 48,
  7, 128, 0, 48, 7, 128, 0, 48, 7, 128, 0, 16, 7, 128, 32, 16,
  7, 128, 32, 16, 7, 128, 32, 0, 7, 128, 96, 0, 7, 128, 96, 0,
  7, 128, 96, 0, 7, 128, 224, 0, 7, 255, 224, 0, 7, 129, 224, 0,
  7, 128, 96, 0, 7, 128, 96, 0, 7, 128, 96, 0, 7, 128, 32, 16,
  7, 128, 32, 16, 7, 128, 32, 16, 7, 128, 0, 16, 7, 128, 0, 48,
  7, 128, 0, 48, 7, 128, 0, 48, 7, 128, 0, 112, 7, 128, 0, 112,
  7, 128, 0, 240, 7, 128, 1, 240, 255, 255, 255, 240, 255, 255, 255, 240,
  27, 35, 140, 34, 4, 0, 255, 255, 255, 224, 15, 128, 15, 224, 7, 128,
  3, 224, 7, 128, 1, 224, 7, 128, 0, 224, 7, 128, 0, 224, 7, 128,
  0, 96, 7, 128, 0, 96, 7, 128, 0, 96, 7, 128, 0, 32, 7, 128,
  32, 32, 7, 128, 32, 32, 7, 128, 32, 0, 7, 128, 96, 0, 7, 128,
  96, 0, 7, 128, 96, 0, 7, 128, 224, 0, 7, 255, 224, 0, 7, 129,
  224, 0, 7, 128, 96, 0, 7, 128, 96, 0, 7, 128, 96, 0, 7, 128,
  32, 0, 7, 128, 32, 0, 7, 128, 32, 0, 7, 128, 0, 0, 7, 128,
  0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128,
  0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 15, 128, 0, 0, 255, 254,
  0, 0, 30, 36, 144, 34, 3, 0, 0, 63, 128, 192, 0, 224, 224, 192,
  3, 128, 56, 192, 7, 0, 29, 192, 14, 0, 15, 192, 14, 0, 7, 192,
  28, 0, 7, 192, 60, 0, 3, 192, 60, 0, 3, 192, 124, 0, 1, 192,
  120, 0, 1, 192, 120, 0, 0, 192, 120, 0, 0, 192, 248, 0, 0, 192,
  248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0, 0, 248, 0, 0, 0,
  248, 0, 255, 252, 248, 0, 255, 252, 248, 0, 7, 192, 248, 0, 7, 192,
  248, 0, 7, 192, 248, 0, 7, 192, 120, 0, 7, 192, 120, 0, 7, 192,
  124, 0, 7, 192, 60, 0, 7, 192, 60, 0, 7, 192, 28, 0, 15, 192,
  30, 0, 15, 192, 14, 0, 28, 192, 7, 0, 24, 192, 3, 0, 48, 192,
  1, 192, 224, 192, 0, 127, 128, 192, 33, 35, 175, 38, 3, 0, 255, 252,
  31, 255, 128, 7, 192, 0, 248, 0, 7, 128, 0, 240, 0, 7, 128, 0,
  240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240,
  0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0,
  7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7,
  128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 255,
  255, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0,
  240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240,
  0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0,
  7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7,
  128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128, 0, 240, 0, 7, 128,
  0, 240, 0, 7, 192, 0, 248, 0, 255, 252, 31, 255, 128, 14, 35, 70,
  19, 3, 0, 255, 252, 7, 192, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7, 128, 7,
  128, 7, 128, 7, 128, 7, 192, 255, 252, 23, 35, 105, 27, 2, 0, 0,
  127, 254, 0, 7, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192,
  0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0,
  3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 60, 3, 192, 126, 3, 192, 254, 3, 192,
  254, 3, 192, 252, 3, 192, 224, 3, 128, 224, 7, 128, 96, 7, 0, 112,
  14, 0, 56, 28, 0, 15, 248, 0, 32, 35, 140, 37, 3, 0, 255, 252,
  63, 254, 7, 192, 15, 240, 7, 128, 7, 192, 7, 128, 3, 128, 7, 128,
  7, 0, 7, 128, 6, 0, 7, 128, 12, 0, 7, 128, 28, 0, 7, 128,
  56, 0, 7, 128, 112, 0, 7, 128, 224, 0, 7, 129, 192, 0, 7, 129,
  128, 0, 7, 131, 128, 0, 7, 135, 128, 0, 7, 143, 192, 0, 7, 155,
  224, 0, 7, 179, 224, 0, 7, 225, 240, 0, 7, 193, 240, 0, 7, 128,
  248, 0, 7, 128, 248, 0, 7, 128, 124, 0, 7, 128, 124, 0, 7, 128,
  62, 0, 7, 128, 62, 0, 7, 128, 31, 0, 7, 128, 31, 0, 7, 128,
  15, 128, 7, 128, 15, 192, 7, 128, 7, 192, 7, 128, 7, 224, 7, 128,
  3, 224, 7, 192, 7, 248, 255, 252, 127, 255, 27, 35, 140, 33, 3, 0,
  255, 254, 0, 0, 7, 192, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0,
  7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 32, 7, 128, 0, 96,
  7, 128, 0, 96, 7, 128, 0, 96, 7, 128, 0, 96, 7, 128, 0, 224,
  7, 128, 0, 224, 7, 128, 0, 224, 7, 128, 1, 224, 7, 128, 3, 224,
  7, 128, 7, 224, 255, 255, 255, 224, 255, 255, 255, 224, 36, 35, 175, 41,
  3, 0, 255, 224, 0, 63, 240, 7, 224, 0, 62, 0, 7, 224, 0, 126,
  0, 7, 240, 0, 94, 0, 7, 240, 0, 94, 0, 6, 240, 0, 222, 0,
  6, 248, 0, 222, 0, 6, 248, 0, 158, 0, 6, 120, 0, 158, 0, 6,
  120, 1, 158, 0, 6, 124, 1, 158, 0, 6, 60, 1, 30, 0, 6, 60,
  1, 30, 0, 6, 62, 3, 30, 0, 6, 62, 3, 30, 0, 6, 30, 2,
  30, 0, 6, 30, 2, 30, 0, 6, 31, 6, 30, 0, 6, 15, 4, 30,
  0, 6, 15, 4, 30, 0, 6, 15, 140, 30, 0, 6, 7, 140, 30, 0,
  6, 7, 136, 30, 0, 6, 7, 200, 30, 0, 6, 7, 216, 30, 0, 6,
  3, 216, 30, 0, 6, 3, 208, 30, 0, 6, 3, 240, 30, 0, 6, 1,
  240, 30, 0, 6, 1, 240, 30, 0, 6, 1, 224, 30, 0, 6, 0, 224,
  30, 0, 15, 0, 224, 30, 0, 31, 128, 192, 62, 0, 255, 240, 195, 255,
  240, 33, 36, 180, 38, 3, 255, 255, 192, 7, 255, 128, 7, 192, 0, 252,
  0, 7, 224, 0, 120, 0, 7, 240, 0, 48, 0, 7, 240, 0, 48, 0,
  7, 248, 0, 48, 0, 6, 248, 0, 48, 0, 6, 124, 0, 48, 0, 6,
  126, 0, 48, 0, 6, 62, 0, 48, 0, 6, 31, 0, 48, 0, 6, 31,
  0, 48, 0, 6, 15, 128, 48, 0, 6, 15, 192, 48, 0, 6, 7, 192,
  48, 0, 6, 3, 224, 48, 0, 6, 3, 224, 48, 0, 6, 1, 240, 48,
  0, 6, 1, 248, 48, 0, 6, 0, 248, 48, 0, 6, 0, 124, 48, 0,
  6, 0, 124, 48, 0, 6, 0, 62, 48, 0, 6, 0, 63, 48, 0, 6,
  0, 31, 48, 0, 6, 0, 15, 176, 0, 6, 0, 15, 176, 0, 6, 0,
  7, 240, 0, 6, 0, 7, 240, 0, 6, 0, 3, 240, 0, 6, 0, 1,
  240, 0, 6, 0, 1, 240, 0, 15, 0, 0, 240, 0, 31, 128, 0, 112,
  0, 255, 240, 0, 112, 0, 0, 0, 0, 48, 0, 28, 36, 144, 33, 3,
  0, 0, 31, 128, 0, 0, 240, 240, 0, 1, 192, 56, 0, 3, 128, 28,
  0, 7, 0, 14, 0, 14, 0, 7, 0, 30, 0, 7, 128, 28, 0, 3,
  128, 60, 0, 3, 192, 60, 0, 3, 192, 124, 0, 3, 224, 120, 0, 1,
  224, 120, 0, 1, 224, 248, 0, 1, 224, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 120, 0, 1,
  224, 120, 0, 1, 224, 124, 0, 3, 224, 124, 0, 3, 224, 60, 0, 3,
  192, 60, 0, 3, 192, 30, 0, 7, 128, 14, 0, 7, 0, 14, 0, 15,
  0, 7, 0, 14, 0, 3, 128, 28, 0, 0, 224, 112, 0, 0, 127, 224,
  0, 28, 35, 140, 33, 3, 0, 255, 255, 240, 0, 7, 192, 30, 0, 7,
  128, 7, 128, 7, 128, 7, 192, 7, 128, 3, 224, 7, 128, 3, 224, 7,
  128, 1, 240, 7, 128, 1, 240, 7, 128, 1, 240, 7, 128, 1, 240, 7,
  128, 1, 240, 7, 128, 1, 240, 7, 128, 3, 224, 7, 128, 3, 224, 7,
  128, 7, 192, 7, 128, 7, 128, 7, 128, 30, 0, 7, 255, 248, 0, 7,
  128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7,
  128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7,
  128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7,
  128, 0, 0, 7, 128, 0, 0, 7, 128, 0, 0, 7, 192, 0, 0, 255,
  254, 0, 0, 28, 44, 176, 33, 3, 248, 0, 31, 128, 0, 0, 240, 240,
  0, 1, 192, 56, 0, 3, 128, 28, 0, 7, 0, 14, 0, 14, 0, 7,
  0, 30, 0, 7, 128, 28, 0, 3, 128, 60, 0, 3, 192, 60, 0, 3,
  192, 124, 0, 3, 224, 120, 0, 1, 224, 120, 0, 1, 224, 248, 0, 1,
  224, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1, 240, 248, 0, 1,
  240, 248, 0, 1, 240, 120, 0, 1, 224, 120, 0, 1, 224, 124, 0, 3,
  224, 124, 0, 3, 224, 60, 15, 3, 192, 60, 25, 195, 192, 30, 48, 199,
  128, 14, 96, 231, 128, 15, 96, 111, 0, 7, 96, 126, 0, 3, 224, 124,
  16, 0, 240, 120, 16, 0, 127, 240, 16, 0, 0, 112, 16, 0, 0, 112,
  16, 0, 0, 120, 48, 0, 0, 120, 32, 0, 0, 124, 96, 0, 0, 63,
  192, 0, 0, 63, 192, 0, 0, 15, 0, 30, 35, 140, 35, 3, 0, 255,
  255, 248, 0, 7, 192, 62, 0, 7, 128, 15, 128, 7, 128, 7, 192, 7,
  128, 7, 192, 7, 128, 3, 224, 7, 128, 3, 224, 7, 128, 3, 224, 7,
  128, 3, 224, 7, 128, 3, 224, 7, 128, 3, 192, 7, 128, 7, 192, 7,
  128, 7, 128, 7, 128, 15, 0, 7, 128, 60, 0, 7, 255, 224, 0, 7,
  128, 240, 0, 7, 128, 56, 0, 7, 128, 28, 0, 7, 128, 30, 0, 7,
  128, 30, 0, 7, 128, 31, 0, 7, 128, 15, 0, 7, 128, 15, 0, 7,
  128, 15, 0, 7, 128, 15, 0, 7, 128, 15, 128, 7, 128, 15, 132, 7,
  128, 15, 132, 7, 128, 15, 132, 7, 128, 15, 132, 7, 128, 15, 140, 7,
  128, 7, 248, 7, 192, 7, 248, 255, 254, 3, 240, 23, 36, 108, 30, 4,
  0, 3, 240, 0, 14, 28, 24, 56, 7, 24, 48, 3, 248, 112, 1, 248,
  96, 0, 248, 224, 0, 120, 224, 0, 56, 224, 0, 56, 224, 0, 56, 224,
  0, 24, 240, 0, 24, 248, 0, 8, 126, 0, 8, 127, 192, 0, 63, 240,
  0, 31, 252, 0, 15, 255, 128, 3, 255, 224, 0, 255, 240, 128, 63, 248,
  128, 7, 252, 128, 1, 252, 192, 0, 126, 192, 0, 62, 192, 0, 30, 224,
  0, 14, 224, 0, 14, 240, 0, 14, 240, 0, 14, 248, 0, 12, 252, 0,
  28, 222, 0, 24, 199, 0, 48, 195, 128, 96, 128, 255, 192, 28, 35, 140,
  35, 4, 0, 255, 255, 255, 240, 254, 15, 131, 240, 248, 15, 1, 240, 240,
  15, 0, 240, 224, 15, 0, 112, 192, 15, 0, 112, 192, 15, 0, 48, 192,
  15, 0, 48, 192, 15, 0, 48, 128, 15, 0, 16, 128, 15, 0, 16, 128,
  15, 0, 16, 128, 15, 0, 16, 0, 15, 0, 0, 0, 15, 0, 0, 0,
  15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0,
  15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0,
  15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0,
  15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0, 15, 0, 0, 0,
  15, 0, 0, 0, 15, 0, 0, 0, 15, 128, 0, 3, 255, 254, 0, 34,
  35, 175, 39, 3, 0, 255, 252, 3, 255, 192, 7, 192, 0, 126, 0, 7,
  128, 0, 60, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128,
  0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0,
  24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24,
  0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0,
  7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7,
  128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128,
  0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 7, 128, 0,
  24, 0, 7, 128, 0, 24, 0, 7, 128, 0, 24, 0, 3, 192, 0, 24,
  0, 3, 192, 0, 48, 0, 3, 192, 0, 48, 0, 1, 224, 0, 96, 0,
  0, 224, 0, 96, 0, 0, 112, 0, 192, 0, 0, 60, 3, 128, 0, 0,
  15, 254, 0, 0, 34, 36, 180, 37, 2, 255, 255, 255, 7, 255, 192, 15,
  240, 0, 126, 0, 3, 224, 0, 56, 0, 3, 224, 0, 56, 0, 3, 240,
  0, 48, 0, 1, 240, 0, 48, 0, 1, 240, 0, 48, 0, 0, 248, 0,
  96, 0, 0, 248, 0, 96, 0, 0, 248, 0, 96, 0, 0, 124, 0, 192,
  0, 0, 124, 0, 192, 0, 0, 124, 0, 192, 0, 0, 62, 0, 192, 0,
  0, 62, 1, 128, 0, 0, 62, 1, 128, 0, 0, 31, 1, 128, 0, 0,
  31, 3, 0, 0, 0, 31, 3, 0, 0, 0, 15, 131, 0, 0, 0, 15,
  134, 0, 0, 0, 15, 134, 0, 0, 0, 7, 198, 0, 0, 0, 7, 204,
  0, 0, 0, 3, 204, 0, 0, 0, 3, 236, 0, 0, 0, 3, 232, 0,
  0, 0, 1, 248, 0, 0, 0, 1, 248, 0, 0, 0, 1, 248, 0, 0,
  0, 0, 240, 0, 0, 0, 0, 240, 0, 0, 0, 0, 240, 0, 0, 0,
  0, 96, 0, 0, 0, 0, 96, 0, 0, 0, 0, 96, 0, 0, 49, 36,
  252, 52, 2, 255, 255, 254, 127, 255, 15, 255, 128, 15, 240, 15, 248, 1,
  248, 0, 3, 224, 3, 240, 0, 240, 0, 3, 224, 3, 224, 0, 96, 0,
  3, 224, 3, 240, 0, 96, 0, 1, 240, 3, 240, 0, 96, 0, 1, 240,
  3, 240, 0, 192, 0, 1, 240, 3, 240, 0, 192, 0, 0, 240, 7, 248,
  0, 192, 0, 0, 248, 6, 248, 0, 128, 0, 0, 248, 6, 248, 1, 128,
  0, 0, 248, 6, 124, 1, 128, 0, 0, 120, 14, 124, 1, 128, 0, 0,
  124, 12, 124, 3, 0, 0, 0, 124, 12, 62, 3, 0, 0, 0, 60, 28,
  62, 3, 0, 0, 0, 60, 24, 62, 6, 0, 0, 0, 60, 24, 30, 6,
  0, 0, 0, 62, 24, 31, 6, 0, 0, 0, 30, 56, 31, 12, 0, 0,
  0, 30, 48, 31, 12, 0, 0, 0, 30, 48, 15, 140, 0, 0, 0, 15,
  48, 15, 152, 0, 0, 0, 15, 112, 15, 152, 0, 0, 0, 15, 96, 7,
  216, 0, 0, 0, 15, 96, 7, 208, 0, 0, 0, 7, 224, 7, 240, 0,
  0, 0, 7, 192, 3, 240, 0, 0, 0, 7, 192, 3, 240, 0, 0, 0,
  3, 192, 3, 224, 0, 0, 0, 3, 192, 3, 224, 0, 0, 0, 3, 128,
  1, 224, 0, 0, 0, 1, 128, 1, 192, 0, 0, 0, 1, 128, 1, 192,
  0, 0, 0, 1, 128, 0, 192, 0, 0, 0, 1, 0, 0, 128, 0, 0,
  33, 35, 175, 36, 2, 0, 127, 255, 31, 255, 0, 3, 240, 3, 240, 0,
  1, 240, 1, 224, 0, 1, 240, 1, 192, 0, 0, 248, 1, 128, 0, 0,
  120, 3, 0, 0, 0, 124, 3, 0, 0, 0, 60, 6, 0, 0, 0, 62,
  14, 0, 0, 0, 31, 12, 0, 0, 0, 31, 24, 0, 0, 0, 15, 152,
  0, 0, 0, 15, 176, 0, 0, 0, 7, 224, 0, 0, 0, 7, 224, 0,
  0, 0, 3, 224, 0, 0, 0, 3, 224, 0, 0, 0, 1, 240, 0, 0,
  0, 3, 240, 0, 0, 0, 3, 248, 0, 0, 0, 6, 248, 0, 0, 0,
  14, 124, 0, 0, 0, 12, 124, 0, 0, 0, 24, 62, 0, 0, 0, 56,
  62, 0, 0, 0, 48, 31, 0, 0, 0, 96, 31, 0, 0, 0, 224, 15,
  128, 0, 0, 192, 15, 128, 0, 1, 128, 7, 192, 0, 3, 128, 7, 192,
  0, 3, 128, 3, 224, 0, 7, 128, 3, 240, 0, 31, 192, 3, 248, 0,
  255, 248, 63, 255, 128, 32, 35, 140, 35, 2, 0, 255, 254, 15, 255, 15,
  224, 1, 248, 7, 224, 0, 240, 3, 224, 0, 96, 3, 240, 0, 64, 1,
  240, 0, 192, 1, 248, 0, 128, 0, 248, 0, 128, 0, 252, 1, 0, 0,
  124, 3, 0, 0, 62, 2, 0, 0, 62, 6, 0, 0, 31, 4, 0, 0,
  31, 12, 0, 0, 15, 136, 0, 0, 7, 216, 0, 0, 7, 208, 0, 0,
  3, 240, 0, 0, 3, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0,
  1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0,
  1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0,
  1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0, 1, 224, 0, 0,
  1, 240, 0, 0, 127, 255, 192, 26, 35, 140, 32, 3, 0, 63, 255, 255,
  192, 63, 128, 15, 128, 62, 0, 31, 128, 60, 0, 31, 0, 56, 0, 62,
  0, 56, 0, 62, 0, 48, 0, 124, 0, 48, 0, 252, 0, 96, 0, 248,
  0, 96, 1, 240, 0, 64, 3, 240, 0, 64, 3, 224, 0, 0, 7, 192,
  0, 0, 7, 192, 0, 0, 15, 128, 0, 0, 31, 128, 0, 0, 31, 0,
  0, 0, 62, 0, 0, 0, 126, 0, 0, 0, 124, 0, 0, 0, 252, 0,
  0, 0, 248, 0, 64, 1, 240, 0, 64, 3, 240, 0, 64, 3, 224, 0,
  192, 7, 192, 0, 192, 7, 192, 0, 192, 15, 128, 1, 192, 31, 128, 1,
  192, 31, 0, 3, 192, 62, 0, 3, 192, 126, 0, 7, 192, 124, 0, 15,
  128, 248, 0, 63, 128, 255, 255, 255, 128, 10, 45, 90, 19, 6, 247, 255,
  192, 254, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240, 0, 240,
  0, 240, 0, 240, 0, 254, 0, 255, 192, 16, 46, 92, 22, 3, 246, 192,
  0, 192, 0, 192, 0, 96, 0, 96, 0, 96, 0, 48, 0, 48, 0, 48,
  0, 24, 0, 24, 0, 24, 0, 12, 0, 12, 0, 12, 0, 6, 0, 6,
  0, 6, 0, 2, 0, 3, 0, 3, 0, 3, 0, 1, 128, 1, 128, 1,
  128, 0, 192, 0, 192, 0, 192, 0, 96, 0, 96, 0, 96, 0, 48, 0,
  48, 0, 48, 0, 24, 0, 24, 0, 24, 0, 12, 0, 12, 0, 12, 0,
  6, 0, 6, 0, 6, 0, 3, 0, 3, 0, 3, 10, 45, 90, 19, 3,
  247, 255, 192, 31, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3, 192, 3,
  192, 3, 192, 3, 192, 3, 192, 31, 192, 255, 192, 22, 18, 54, 28, 3,
  17, 0, 16, 0, 0, 48, 0, 0, 56, 0, 0, 120, 0, 0, 108, 0,
  0, 206, 0, 1, 198, 0, 1, 131, 0, 3, 3, 0, 7, 1, 128, 6,
  1, 192, 14, 0, 192, 28, 0, 96, 24, 0, 112, 56, 0, 48, 48, 0,
  56, 96, 0, 24, 224, 0, 12, 25, 2, 8, 25, 0, 248, 255, 255, 255,
  128, 255, 255, 255, 128, 8, 9, 9, 22, 4, 25, 224, 240, 240, 120, 60,
  12, 6, 3, 1, 21, 22, 66, 24, 2, 1, 7, 248, 0, 24, 30, 0,
  16, 15, 0, 48, 7, 0, 56, 7, 128, 60, 7, 128, 62, 7, 128, 28,
  7, 128, 0, 7, 128, 0, 31, 128, 3, 247, 128, 31, 7, 128, 60, 7,
  128, 120, 7, 128, 248, 7, 128, 240, 7, 128, 240, 15, 136, 240, 15, 136,
  240, 23, 136, 248, 23, 152, 120, 39, 240, 63, 195, 240, 22, 35, 105, 25,
  1, 0, 255, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0,
  0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0,
  15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 31, 128, 15, 32, 224, 15,
  64, 240, 15, 192, 112, 15, 128, 120, 15, 128, 120, 15, 0, 120, 15, 0,
  60, 15, 0, 60, 15, 0, 60, 15, 0, 60, 15, 0, 60, 15, 0, 60,
  15, 0, 60, 15, 0, 60, 15, 0, 120, 15, 0, 120, 15, 128, 120, 13,
  128, 112, 12, 192, 224, 12, 96, 224, 8, 63, 128, 17, 22, 66, 21, 2,
  1, 7, 252, 0, 14, 6, 0, 28, 3, 0, 56, 3, 0, 56, 3, 128,
  120, 15, 128, 120, 15, 128, 240, 15, 128, 240, 7, 0, 240, 0, 0, 240,
  0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 0, 240, 0, 128, 120, 0,
  128, 120, 0, 128, 56, 1, 0, 56, 1, 0, 28, 2, 0, 14, 6, 0,
  7, 248, 0, 22, 35, 105, 25, 2, 0, 0, 63, 192, 0, 3, 192, 0,
  3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192,
  15, 227, 192, 28, 19, 192, 60, 11, 192, 56, 15, 192, 120, 7, 192, 120,
  7, 192, 120, 3, 192, 240, 3, 192, 240, 3, 192, 240, 3, 192, 240, 3,
  192, 240, 3, 192, 240, 3, 192, 240, 3, 192, 240, 3, 192, 120, 3, 192,
  120, 3, 192, 120, 7, 192, 56, 7, 192, 60, 15, 192, 28, 27, 192, 7,
  243, 252, 18, 22, 66, 22, 2, 1, 7, 248, 0, 14, 28, 0, 28, 14,
  0, 56, 15, 0, 56, 7, 128, 120, 7, 128, 120, 7, 128, 240, 7, 192,
  240, 7, 192, 240, 7, 192, 255, 255, 192, 240, 0, 0, 240, 0, 0, 240,
  0, 0, 240, 0, 128, 120, 0, 128, 120, 0, 128, 120, 1, 128, 56, 1,
  0, 28, 3, 0, 14, 6, 0, 7, 252, 0, 16, 35, 70, 16, 1, 0,
  0, 248, 3, 198, 7, 3, 15, 7, 14, 15, 14, 15, 30, 15, 30, 6,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 255, 240, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 255, 240, 23, 33, 99, 27, 3, 246, 7, 252, 124, 30,
  14, 206, 60, 7, 142, 124, 7, 158, 120, 3, 222, 120, 3, 192, 120, 3,
  192, 120, 3, 192, 120, 3, 192, 120, 3, 192, 60, 7, 128, 28, 7, 128,
  14, 14, 0, 3, 248, 0, 28, 0, 0, 96, 0, 0, 192, 0, 0, 192,
  0, 0, 224, 0, 0, 255, 255, 128, 127, 255, 224, 15, 255, 240, 28, 0,
  112, 48, 0, 56, 96, 0, 24, 192, 0, 24, 192, 0, 24, 192, 0, 24,
  192, 0, 48, 96, 0, 48, 120, 0, 96, 30, 7, 192, 3, 254, 0, 24,
  35, 105, 27, 1, 0, 255, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0,
  0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0,
  15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 0, 0, 15, 15, 192, 15,
  48, 240, 15, 96, 112, 15, 64, 120, 15, 128, 120, 15, 128, 120, 15, 0,
  120, 15, 0, 120, 15, 0, 120, 15, 0, 120, 15, 0, 120, 15, 0, 120,
  15, 0, 120, 15, 0, 120, 15, 0, 120, 15, 0, 120, 15, 0, 120, 15,
  0, 120, 15, 0, 120, 15, 0, 120, 15, 0, 120, 255, 195, 255, 10, 34,
  68, 14, 2, 0, 28, 0, 62, 0, 62, 0, 62, 0, 28, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0,
  30, 0, 30, 0, 30, 0, 255, 192, 13, 45, 90, 16, 254, 245, 0, 112,
  0, 248, 0, 248, 0, 248, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 15, 248, 0, 120, 0, 120, 0, 120, 0, 120,
  0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120,
  0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 0, 120,
  0, 120, 0, 120, 0, 120, 0, 120, 0, 120, 240, 120, 240, 120, 240, 112,
  224, 240, 96, 224, 115, 192, 31, 0, 22, 35, 105, 24, 1, 0, 254, 0,
  0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0,
  30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30,
  0, 0, 30, 0, 0, 30, 15, 252, 30, 3, 224, 30, 1, 128, 30, 3,
  0, 30, 6, 0, 30, 6, 0, 30, 12, 0, 30, 24, 0, 30, 48, 0,
  30, 120, 0, 30, 248, 0, 30, 188, 0, 31, 190, 0, 31, 30, 0, 30,
  15, 0, 30, 15, 128, 30, 7, 128, 30, 3, 192, 30, 3, 224, 30, 1,
  224, 30, 3, 240, 255, 207, 252, 11, 35, 70, 13, 1, 0, 254, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 255, 224, 36, 22, 110, 40, 2, 1, 254, 63, 129, 252, 0, 30, 97,
  195, 14, 0, 30, 193, 230, 15, 0, 30, 128, 228, 7, 128, 31, 0, 248,
  7, 128, 31, 0, 248, 7, 128, 30, 0, 240, 7, 128, 30, 0, 240, 7,
  128, 30, 0, 240, 7, 128, 30, 0, 240, 7, 128, 30, 0, 240, 7, 128,
  30, 0, 240, 7, 128, 30, 0, 240, 7, 128, 30, 0, 240, 7, 128, 30,
  0, 240, 7, 128, 30, 0, 240, 7, 128, 30, 0, 240, 7, 128, 30, 0,
  240, 7, 128, 30, 0, 240, 7, 128, 30, 0, 240, 7, 128, 30, 0, 240,
  7, 128, 255, 199, 254, 63, 240, 23, 22, 66, 27, 2, 1, 254, 31, 128,
  30, 97, 224, 30, 192, 224, 30, 128, 240, 31, 0, 240, 31, 0, 240, 30,
  0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0,
  240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240,
  30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 255, 199, 254, 19,
  22, 66, 24, 2, 1, 3, 252, 0, 14, 14, 0, 28, 7, 0, 60, 3,
  128, 56, 3, 192, 120, 3, 192, 120, 1, 224, 248, 1, 224, 240, 1, 224,
  240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240, 1, 224, 240,
  1, 224, 120, 1, 224, 120, 3, 192, 56, 3, 192, 60, 3, 128, 28, 7,
  0, 14, 14, 0, 3, 252, 0, 22, 33, 99, 25, 1, 246, 254, 63, 128,
  30, 97, 192, 30, 192, 224, 31, 128, 112, 31, 0, 120, 31, 0, 120, 30,
  0, 120, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0,
  60, 30, 0, 60, 30, 0, 60, 30, 0, 60, 30, 0, 120, 30, 0, 120,
  31, 0, 120, 31, 0, 112, 31, 128, 224, 30, 192, 192, 30, 127, 128, 30,
  0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0,
  0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 255, 224, 0,
  22, 33, 99, 25, 2, 246, 7, 240, 64, 28, 24, 192, 28, 12, 192, 56,
  12, 192, 120, 7, 192, 120, 7, 192, 120, 3, 192, 240, 3, 192, 240, 3,
  192, 240, 3, 192, 240, 3, 192, 240, 3, 192, 240, 3, 192, 240, 3, 192,
  240, 3, 192, 120, 3, 192, 120, 3, 192, 120, 7, 192, 56, 7, 192, 60,
  15, 192, 28, 27, 192, 7, 243, 192, 0, 3, 192, 0, 3, 192, 0, 3,
  192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192, 0, 3, 192,
  0, 3, 192, 0, 3, 192, 0, 31, 252, 17, 22, 66, 20, 2, 1, 254,
  31, 0, 30, 35, 128, 30, 67, 128, 30, 207, 128, 30, 143, 128, 31, 143,
  0, 31, 2, 0, 31, 0, 0, 31, 0, 0, 30, 0, 0, 30, 0, 0,
  30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30,
  0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 30, 0, 0, 255, 192,
  0, 17, 22, 66, 22, 3, 1, 31, 226, 0, 112, 50, 0, 96, 30, 0,
  192, 14, 0, 192, 6, 0, 224, 2, 0, 240, 2, 0, 252, 0, 0, 127,
  0, 0, 63, 192, 0, 31, 248, 0, 7, 254, 0, 128, 255, 0, 192, 31,
  0, 192, 7, 128, 224, 3, 128, 224, 1, 128, 240, 1, 128, 240, 1, 128,
  248, 3, 0, 198, 7, 0, 131, 252, 0, 14, 32, 64, 17, 1, 0, 2,
  0, 2, 0, 2, 0, 2, 0, 2, 0, 6, 0, 6, 0, 6, 0, 14,
  0, 30, 0, 255, 248, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30, 0, 30,
  0, 30, 4, 30, 4, 30, 4, 30, 12, 15, 8, 15, 248, 7, 240, 23,
  22, 66, 27, 2, 0, 254, 7, 240, 30, 0, 240, 30, 0, 240, 30, 0,
  240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240,
  30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30, 0, 240, 30,
  0, 240, 30, 1, 240, 30, 1, 240, 30, 1, 240, 30, 2, 240, 14, 6,
  240, 15, 12, 240, 3, 240, 254, 24, 23, 69, 26, 1, 255, 255, 225, 255,
  31, 0, 124, 15, 0, 48, 15, 0, 48, 15, 0, 32, 7, 128, 96, 7,
  128, 96, 3, 192, 64, 3, 192, 192, 1, 192, 192, 1, 224, 128, 1, 225,
  128, 0, 241, 128, 0, 241, 0, 0, 113, 0, 0, 123, 0, 0, 58, 0,
  0, 62, 0, 0, 62, 0, 0, 28, 0, 0, 28, 0, 0, 12, 0, 0,
  8, 0, 36, 23, 115, 38, 1, 255, 255, 231, 255, 31, 240, 31, 1, 248,
  7, 128, 31, 0, 240, 3, 0, 15, 0, 120, 3, 0, 15, 0, 120, 2,
  0, 7, 128, 120, 6, 0, 7, 128, 252, 6, 0, 3, 128, 252, 4, 0,
  3, 192, 188, 12, 0, 3, 192, 158, 12, 0, 1, 225, 158, 8, 0, 1,
  225, 14, 24, 0, 0, 225, 15, 24, 0, 0, 243, 15, 16, 0, 0, 242,
  7, 48, 0, 0, 114, 7, 176, 0, 0, 126, 7, 160, 0, 0, 62, 3,
  224, 0, 0, 60, 3, 192, 0, 0, 28, 1, 192, 0, 0, 28, 1, 192,
  0, 0, 24, 1, 128, 0, 0, 8, 0, 128, 0, 22, 22, 66, 26, 2,
  0, 255, 207, 248, 31, 3, 192, 31, 3, 128, 15, 3, 0, 7, 131, 0,
  7, 198, 0, 3, 196, 0, 1, 236, 0, 1, 248, 0, 0, 240, 0, 0,
  112, 0, 0, 120, 0, 0, 124, 0, 0, 220, 0, 1, 158, 0, 1, 15,
  0, 3, 15, 0, 6, 7, 128, 4, 7, 192, 12, 3, 192, 28, 3, 224,
  255, 15, 252, 24, 33, 99, 26, 1, 245, 255, 225, 255, 31, 0, 120, 15,
  0, 48, 15, 0, 48, 7, 0, 32, 7, 128, 96, 7, 128, 96, 3, 192,
  64, 3, 192, 192, 3, 192, 192, 1, 224, 128, 1, 225, 128, 0, 225, 128,
  0, 241, 128, 0, 241, 0, 0, 115, 0, 0, 123, 0, 0, 122, 0, 0,
  62, 0, 0, 62, 0, 0, 60, 0, 0, 28, 0, 0, 28, 0, 0, 24,
  0, 0, 24, 0, 0, 24, 0, 24, 48, 0, 60, 48, 0, 60, 48, 0,
  60, 96, 0, 56, 96, 0, 31, 192, 0, 15, 0, 0, 17, 22, 66, 22,
  2, 0, 255, 255, 128, 248, 7, 128, 224, 15, 0, 224, 31, 0, 192, 30,
  0, 192, 60, 0, 128, 124, 0, 128, 120, 0, 0, 240, 0, 1, 240, 0,
  1, 224, 0, 3, 192, 0, 7, 192, 0, 7, 128, 128, 15, 0, 128, 31,
  0, 128, 30, 0, 128, 60, 1, 128, 124, 1, 128, 120, 3, 128, 240, 15,
  128, 255, 255, 128, 11, 45, 90, 21, 6, 247, 0, 224, 1, 128, 7, 0,
  14, 0, 12, 0, 28, 0, 28, 0, 28, 0, 28, 0, 30, 0, 30, 0,
  14, 0, 14, 0, 15, 0, 15, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  6, 0, 4, 0, 24, 0, 224, 0, 56, 0, 12, 0, 6, 0, 6, 0,
  7, 0, 7, 0, 7, 0, 15, 0, 15, 0, 15, 0, 14, 0, 30, 0,
  30, 0, 28, 0, 28, 0, 28, 0, 28, 0, 12, 0, 12, 0, 6, 0,
  3, 128, 0, 224, 2, 46, 46, 14, 6, 246, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192, 192,
  192, 192, 192, 192, 192, 192, 192, 192, 11, 45, 90, 20, 4, 247, 192, 0,
  112, 0, 28, 0, 12, 0, 6, 0, 7, 0, 7, 0, 7, 0, 7, 0,
  15, 0, 15, 0, 14, 0, 30, 0, 30, 0, 30, 0, 28, 0, 28, 0,
  28, 0, 28, 0, 12, 0, 4, 0, 3, 0, 0, 224, 3, 0, 6, 0,
  12, 0, 28, 0, 28, 0, 28, 0, 28, 0, 30, 0, 30, 0, 30, 0,
  14, 0, 15, 0, 15, 0, 7, 0, 7, 0, 7, 0, 7, 0, 6, 0,
  6, 0, 12, 0, 56, 0, 224, 0, 28, 9, 36, 32, 2, 8, 31, 128,
  0, 192, 127, 240, 0, 96, 127, 252, 0, 48, 227, 255, 0, 48, 192, 127,
  224, 48, 192, 31, 248, 112, 192, 3, 255, 224, 96, 0, 255, 192, 48, 0,
  31, 128, 255
};
