/* This example renders a png or Jpeg file to be stored in a FLASH array

 Image files can be converted to arrays using the tool here:
 https://javl.github.io/image2cpp/

 To use this tool:
  1. Click "Choose Files" button to select file to convert...
  2. Section 2 allows you to modifiy image settings and preview changes in section 3.
  3. Set "Canvas size(s)" to desired image size. 
  4. Final image width >>> MUST BE DIVISABLE BY 8 <<<. Width is the left number of image size.
  5. >>> NOTE: Some images/printers may require "Invert image colors" to be clicked to print as desired. <<<
  6. In section 4, Set "Code Output" to "Plain Bytes". This will prepare the bytes to be pasted in the array below.
  7. Click "Generate Code".
  8. Click "Copy Output"
  9. Paste output inside the image array brackets below (replace existing bytes).
  10. Make sure "#define IMAGE_WIDTH & HEIGHT" are set to final image sizes.
  11. Final image array must alway be defined "static const uint8_t testImage[] PROGMEM  = {....};"  
*/

#define IMAGE_WIDTH 320
#define IMAGE_HEIGHT 200

// array size is 7200
static const uint8_t abletplogo[] PROGMEM = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
  0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x00,
  0x00, 0x00, 0xe3, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xc0, 0x00, 0x00, 0x00, 0x70, 0xe0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xa0, 0x00,
  0x00, 0x00, 0x30, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x1c, 0x00, 0x00, 0x00, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x00,
  0x00, 0x00, 0x38, 0x8e, 0x00, 0x0e, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x07, 0x00, 0x00, 0x00, 0x18, 0xc6, 0x00, 0x1f, 0xc0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x03, 0x80,
  0x02, 0x80, 0x08, 0xc3, 0x00, 0x38, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x01, 0xe0, 0x07, 0xc0, 0x0c, 0x63, 0x00, 0x30, 0x60, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x88, 0xe0,
  0x0f, 0xe0, 0x0e, 0x23, 0x80, 0x20, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc4, 0x38, 0x1f, 0xe0, 0x06, 0x31, 0xc0, 0x20, 0x60, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe2, 0x08,
  0x0f, 0xe0, 0x03, 0x38, 0x80, 0x22, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x8c, 0x0f, 0xe0, 0x03, 0x9c, 0xc0, 0x3f, 0xf0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0xee,
  0x0f, 0xe0, 0x00, 0x8e, 0xe0, 0x3e, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x76, 0x07, 0xe0, 0x00, 0xce, 0xe0, 0x6c, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xbf,
  0x00, 0xf8, 0x00, 0xef, 0xe0, 0x20, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x01, 0xff, 0x80, 0x3c, 0x00, 0x3f, 0xe0, 0x30, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe8, 0xbf,
  0x80, 0x0e, 0x80, 0x0f, 0xe0, 0x38, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1f, 0xf4, 0x7e, 0x05, 0xf0, 0x0f, 0xc0, 0x07, 0xe0, 0x18, 0x40, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xfe, 0x80, 0x0b, 0x82,
  0xfe, 0xab, 0xfa, 0x02, 0xe0, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x15, 0x50, 0x1f, 0xf0, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x70, 0x07, 0x00, 0x03,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xaa, 0xaa, 0xaa, 0xaa,
  0xaa, 0xaa, 0xae, 0xee, 0xee, 0xee, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3f, 0x80, 0x02, 0xff, 0xff,
  0xea, 0xaa, 0xaf, 0xff, 0xf8, 0x03, 0x00, 0x0e, 0x00, 0x00, 0x44, 0x44, 0x44, 0x55, 0x54, 0x44,
  0x5d, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xc0, 0x1f, 0x00, 0x01, 0xff, 0xe0, 0x00, 0x00, 0x07, 0xff, 0xfc, 0x03, 0x00, 0x0f,
  0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaa, 0xaa,
  0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xab, 0xbb, 0xbb, 0xaa, 0xa0, 0x00, 0x0f, 0xa0, 0x00, 0x0f, 0x80,
  0x00, 0x02, 0xae, 0x80, 0xbe, 0x03, 0x80, 0x39, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf5, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0xfc, 0x00, 0x7f, 0x00, 0x00, 0x1f, 0xfc, 0x00, 0x1f, 0x83, 0x00, 0x31,
  0x0e, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xef, 0xf8, 0x00,
  0x00, 0xbf, 0xe8, 0x00, 0x03, 0xe3, 0x80, 0x20, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0xff, 0xc0, 0x00, 0x01, 0xf7, 0xe0, 0x00, 0x01, 0xf1, 0x80, 0x41,
  0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0xaf, 0xe0, 0x00, 0x00, 0x3b, 0x80, 0x81, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x1c, 0xc0, 0x00, 0x00, 0x1f, 0x81, 0x81,
  0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0e, 0x38, 0xc0, 0x00, 0x00, 0x0f, 0x83, 0x83, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x71, 0x80, 0x00, 0xff, 0x07, 0xc3, 0x23,
  0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x38, 0xe3, 0x80, 0x0b, 0xff, 0xe3, 0xc2, 0x62, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x87, 0x00, 0x3f, 0xdf, 0xff, 0xc6, 0xc6,
  0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xe2, 0x0e, 0x00, 0xfa, 0x3f, 0xff, 0xee, 0x8e, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x1c, 0x01, 0xf0, 0xfd, 0xff, 0xe7, 0x8c,
  0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x80, 0xb8, 0x03, 0x83, 0xe8, 0xe0, 0xef, 0xb8, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x01, 0xe0, 0x0f, 0x07, 0x81, 0xc0, 0x7f, 0x30,
  0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
  0x8f, 0x80, 0x0e, 0x0e, 0x0f, 0x80, 0x3e, 0x20, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x1e, 0x00, 0x3c, 0x00, 0x5c, 0x00, 0x1f, 0x60,
  0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
  0xf8, 0x00, 0x38, 0x0a, 0xf8, 0x00, 0x3f, 0xe0, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x60, 0x7f, 0xc0, 0x00, 0x1f, 0x80,
  0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
  0x80, 0x00, 0xef, 0xfe, 0x80, 0x00, 0x0f, 0x80, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0xff, 0xc0, 0x00, 0x00, 0x0f, 0x00,
  0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xa8, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x07, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,
  0x3f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xa0, 0x00, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe,
  0x00, 0x07, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x07, 0x00,
  0x1c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x03, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,
  0x3f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x02, 0x00, 0x1c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x07, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x03, 0x00,
  0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x07, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,
  0x3f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x03, 0x00, 0x1c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x07, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x03, 0x00,
  0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x03, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,
  0x3f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x07, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x03, 0x00,
  0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x80, 0x07, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,
  0x3f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x07, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x01, 0x00,
  0x0c, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x80, 0x03, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00,
  0x3f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff,
  0x00, 0x07, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x01, 0x00,
  0x0c, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0x80, 0x07, 0xff, 0xff, 0x80, 0xaa, 0x00, 0x00,
  0x3f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0xaa, 0x80, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff,
  0x80, 0x07, 0xff, 0xff, 0x07, 0xff, 0xc0, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x00, 0x0f, 0xff, 0xf0,
  0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x01, 0x80,
  0x0c, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0x80, 0x03, 0xff, 0xff, 0x8f, 0xff, 0xe8, 0x00,
  0x3f, 0xff, 0xf8, 0x00, 0x00, 0xbf, 0xff, 0xfe, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff,
  0x80, 0x07, 0xff, 0xff, 0x3f, 0xff, 0xfc, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x01, 0xff, 0xff, 0xff,
  0xc0, 0x01, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x01, 0x00,
  0x0c, 0x00, 0x00, 0x03, 0xff, 0xfe, 0xff, 0xff, 0x80, 0x07, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00,
  0x3f, 0xff, 0xf8, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xe0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xfe, 0xbf, 0xff, 0xfe, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x01, 0xff, 0xfe, 0xff, 0xff,
  0x80, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x0f, 0xff, 0xff, 0xff,
  0xf0, 0x00, 0x44, 0x7f, 0xff, 0xf4, 0x44, 0x0f, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0x00, 0x01, 0x80,
  0x0c, 0x00, 0x00, 0x03, 0xff, 0xfe, 0xff, 0xff, 0x80, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
  0x3f, 0xff, 0xf8, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x0f, 0xff, 0xff, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x03, 0xff, 0xfe, 0xff, 0xff,
  0x80, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x1f, 0xff, 0xfc, 0x00, 0x7f, 0xff, 0xff, 0xff,
  0xfc, 0x00, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0x00, 0x01, 0x80,
  0x0c, 0x00, 0x00, 0x03, 0xff, 0xfe, 0xff, 0xff, 0x80, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
  0x3f, 0xff, 0xf8, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x03, 0xff, 0xff, 0x80, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x03, 0xff, 0xfc, 0xff, 0xff,
  0xc0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x1f, 0xff, 0xfc, 0x00, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x00, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x03, 0xff, 0xff, 0x00, 0x01, 0x80,
  0x0c, 0x00, 0x00, 0x03, 0xff, 0xfe, 0xff, 0xff, 0x80, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x03, 0xff, 0xff, 0x80, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x03, 0xff, 0xfc, 0x7f, 0xff,
  0xc0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x1f, 0xff, 0xfc, 0x01, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x00, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x03, 0xff, 0xff, 0x00, 0x01, 0x80,
  0x0c, 0x00, 0x00, 0x03, 0xff, 0xfe, 0xff, 0xff, 0x80, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x03, 0xff, 0xff, 0x80, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x03, 0xff, 0xfc, 0x7f, 0xff,
  0xc0, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x1f, 0xff, 0xfc, 0x03, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x01, 0xff, 0xff, 0x00, 0x01, 0x80,
  0x18, 0x00, 0x00, 0x03, 0xff, 0xfe, 0x7f, 0xff, 0x80, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x03, 0xff, 0xff, 0xeb, 0xff, 0xff, 0x80, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x03, 0xff, 0xff, 0x80, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x07, 0xff, 0xfc, 0x7f, 0xff,
  0xc0, 0x07, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0x83, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x03, 0xff, 0xff, 0x00, 0x01, 0x80,
  0x1c, 0x00, 0x00, 0x03, 0xff, 0xfc, 0x7f, 0xff, 0xc0, 0x07, 0xff, 0xff, 0x80, 0xff, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x07, 0xff, 0xff, 0x81, 0xff, 0xff, 0xc0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x03, 0xff, 0xff, 0x80, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x07, 0xff, 0xfc, 0x7f, 0xff,
  0xc0, 0x07, 0xff, 0xff, 0x80, 0xff, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0x01, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x01, 0xff, 0xff, 0x00, 0x01, 0x80,
  0x18, 0x00, 0x00, 0x03, 0xff, 0xfc, 0x3f, 0xff, 0xe0, 0x03, 0xff, 0xff, 0x80, 0xff, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x07, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x03, 0xff, 0xff, 0x80, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x07, 0xff, 0xfc, 0x7f, 0xff,
  0xc0, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0x00, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x03, 0xff, 0xff, 0x00, 0x01, 0x80,
  0x18, 0x00, 0x00, 0x07, 0xff, 0xfc, 0x3f, 0xff, 0xe0, 0x07, 0xff, 0xff, 0x80, 0xff, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x03, 0xff, 0xff, 0x80, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x07, 0xff, 0xfc, 0x7f, 0xff,
  0xc0, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x03, 0xff, 0xff, 0x00, 0x01, 0x80,
  0x18, 0x00, 0x00, 0x07, 0xff, 0xf8, 0x3f, 0xff, 0xe0, 0x03, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x03, 0xff, 0xff, 0x80, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x07, 0xff, 0xfc, 0x3f, 0xff,
  0xe0, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0xff,
  0xff, 0xe0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0x00, 0x01, 0x80,
  0x18, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x3f, 0xff, 0xe0, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x0f, 0xff, 0xff, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x07, 0xff, 0xfc, 0x3f, 0xff,
  0xe0, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0x00, 0x01, 0x80,
  0x18, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x3f, 0xff, 0xe0, 0x03, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfe, 0xbf, 0xff, 0xfe, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x07, 0xff, 0xf8, 0x3f, 0xff,
  0xe0, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0xff,
  0xff, 0xe0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x01, 0x80,
  0x18, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x3f, 0xff, 0xe0, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x3f, 0xff,
  0xe0, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x01, 0x80,
  0x38, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x3f, 0xff, 0xe0, 0x03, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x3f, 0xff,
  0xf0, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0xff,
  0xff, 0xe0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x01, 0x80,
  0x18, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x3f, 0xff, 0xe0, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x88, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x1f, 0xff,
  0xf0, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x01, 0x80,
  0x38, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x3f, 0xff, 0xe0, 0x03, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x1f, 0xff, 0xf8, 0x1f, 0xff,
  0xf0, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x01, 0x80,
  0x18, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x1f, 0xff, 0xe0, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x1f, 0xff, 0xf8, 0x1f, 0xff,
  0xf0, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x01, 0x80,
  0x38, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x03, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x1f, 0xff, 0xf0, 0x1f, 0xff,
  0xf0, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x01, 0x80,
  0x18, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x0f, 0xff, 0xf8, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xff, 0xff, 0xfe, 0x80, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x1f, 0xff, 0xf0, 0x1f, 0xff,
  0xf0, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x01, 0x80,
  0x38, 0x00, 0x00, 0x1f, 0xff, 0xf8, 0x0f, 0xff, 0xf8, 0x03, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x22, 0x22, 0x22, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xff, 0xff, 0xe8, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x1f, 0xff, 0xf0, 0x1f, 0xff,
  0xf0, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x18, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x0f, 0xff, 0xf8, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x1f, 0xff, 0xf0, 0x0f, 0xff,
  0xf8, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x38, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x0f, 0xff, 0xf8, 0x03, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x1f, 0xff, 0xf0, 0x0f, 0xff,
  0xf8, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x38, 0x00, 0x00, 0x3f, 0xff, 0xe0, 0x0f, 0xff, 0xf8, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x0f, 0xff,
  0xf8, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x38, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x03, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff,
  0xf8, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0xff,
  0xff, 0xe0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x38, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff,
  0xfc, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x38, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x03, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff,
  0xfc, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x38, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff,
  0xfc, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xfe, 0x00, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x38, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0,
  0x3f, 0xff, 0xf8, 0x0f, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x18, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff,
  0xfc, 0x07, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0x00, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x38, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x07, 0xff, 0xff, 0x80, 0xff, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x07, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xc0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff,
  0xfc, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0x00, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x38, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x03, 0xff, 0xff, 0x80, 0xff, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x03, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xc0, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x18, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff,
  0xfc, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xf0, 0x1f, 0xff, 0xfc, 0x07, 0xff, 0xff, 0x01, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x38, 0x00, 0x00, 0xff, 0xff, 0xea, 0xaf, 0xff, 0xfe, 0x07, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x03, 0xff, 0xff, 0x81, 0xff, 0xff, 0x80, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x7f, 0xff, 0xc0, 0x07, 0xff,
  0xfc, 0x07, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xe0, 0x1f, 0xff, 0xfc, 0x03, 0xff, 0xff, 0xc7, 0xff,
  0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x38, 0x00, 0x00, 0xff, 0xff, 0xe0, 0x03, 0xff, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x18, 0x00, 0x00, 0x7f, 0xff, 0xc0, 0x03, 0xff,
  0xfe, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x1f, 0xff, 0xfc, 0x01, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x80, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x38, 0x00, 0x00, 0xff, 0xff, 0xc0, 0x03, 0xff, 0xfe, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
  0x3f, 0xff, 0xf8, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0xff, 0xff, 0xc0, 0x03, 0xff,
  0xfe, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x1f, 0xff, 0xfc, 0x01, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x00, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x38, 0x00, 0x00, 0xff, 0xff, 0x80, 0x03, 0xff, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
  0x3f, 0xff, 0xf8, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x18, 0x00, 0x00, 0xff, 0xff, 0xc0, 0x03, 0xff,
  0xfe, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x1f, 0xff, 0xfc, 0x00, 0xff, 0xff, 0xff, 0xff,
  0xfe, 0x00, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x38, 0x00, 0x00, 0xff, 0xff, 0x80, 0x03, 0xff, 0xfe, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
  0x3f, 0xff, 0xf8, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0xff, 0xff, 0xc0, 0x03, 0xff,
  0xfe, 0x07, 0xff, 0xff, 0x7f, 0xff, 0xff, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x7f, 0xff, 0xff, 0xff,
  0xfc, 0x00, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x38, 0x00, 0x00, 0xff, 0xff, 0x80, 0x03, 0xff, 0xfe, 0x03, 0xff, 0xff, 0xbf, 0xff, 0xfe, 0x00,
  0x3f, 0xff, 0xf8, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x30, 0x00, 0x00, 0xff, 0xff, 0xc0, 0x03, 0xff,
  0xff, 0x07, 0xff, 0xff, 0x1f, 0xff, 0xfe, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x1f, 0xff, 0xff, 0xff,
  0xf0, 0x00, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x38, 0x00, 0x00, 0xff, 0xff, 0x80, 0x03, 0xff, 0xfe, 0x07, 0xff, 0xff, 0x8f, 0xff, 0xfc, 0x00,
  0x3f, 0xff, 0xf8, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0xff, 0xff, 0xc0, 0x01, 0xff,
  0xff, 0x07, 0xff, 0xff, 0x0f, 0xff, 0xf8, 0x00, 0x1f, 0xff, 0xfc, 0x00, 0x01, 0xff, 0xff, 0xff,
  0x80, 0x00, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x38, 0x00, 0x00, 0xff, 0xff, 0x80, 0x03, 0xff, 0xff, 0x03, 0xff, 0xff, 0x83, 0xff, 0xe0, 0x00,
  0x3f, 0xff, 0xf8, 0x00, 0x00, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xf0, 0x00, 0x0f,
  0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x30, 0x00, 0x00, 0x55, 0x55, 0x00, 0x01, 0x55,
  0x55, 0x01, 0x55, 0x55, 0x01, 0xff, 0x80, 0x00, 0x15, 0x55, 0x50, 0x00, 0x00, 0x1f, 0xff, 0xf0,
  0x00, 0x00, 0x00, 0x15, 0x55, 0x50, 0x00, 0x05, 0x55, 0x54, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x0f, 0x80, 0x0a, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x1d, 0xc0, 0x7f, 0xff, 0xc0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x0c, 0xeb, 0xfa, 0xab, 0xe8, 0x00, 0x00, 0x0b, 0xe0, 0x0b, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x0c, 0x7f, 0xc0, 0x00, 0x7c, 0x00, 0x00, 0x3f,
  0xc0, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x0e, 0x3f, 0xaa, 0x80, 0x3e, 0x00, 0x00, 0xff, 0x80, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x06, 0x0f, 0xff, 0x40, 0xfc, 0x00, 0x07, 0xe7,
  0x00, 0x70, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x02, 0x0f, 0xa8, 0x03, 0xe0, 0x00, 0x0f, 0x8e, 0x00, 0xe0, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x03, 0xf0, 0x1f, 0x80, 0x00, 0x1c, 0x0e,
  0x01, 0xc0, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x03, 0x80, 0xff, 0xfe, 0x00, 0x00, 0xb8, 0x0c, 0x03, 0xe0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x1f, 0xf0, 0x00, 0x00, 0xe0, 0x18,
  0x07, 0x78, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x00, 0xc0, 0x02, 0x00, 0x00, 0x03, 0xe0, 0x38, 0x0e, 0x68, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0xe0, 0x00, 0x03, 0x80, 0x03, 0x80, 0x70,
  0x0c, 0x1d, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x00, 0xe0, 0x00, 0x0f, 0xc0, 0x0e, 0x88, 0xe0, 0x08, 0x1f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x78, 0x00, 0x0f, 0xc0, 0x0e, 0x31, 0xc0,
  0x18, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x00, 0x78, 0x00, 0x0f, 0xe0, 0x0e, 0xe3, 0x80, 0x08, 0x06, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x7f, 0x00, 0x1f, 0xc0, 0x1d, 0xc7, 0x00,
  0x1c, 0x0c, 0x00, 0x07, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
  0x00, 0x3f, 0xea, 0xff, 0x80, 0x3b, 0x8e, 0x00, 0x0e, 0xb8, 0x00, 0xbf, 0xea, 0xfe, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x71, 0xff, 0xc1, 0x00, 0x3f, 0x1c, 0x00,
  0x1f, 0xf0, 0x01, 0xfc, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00,
  0x00, 0x30, 0xfa, 0x80, 0x00, 0x3e, 0xf8, 0x00, 0x38, 0x80, 0x03, 0xa0, 0x00, 0x02, 0xe0, 0x00,
  0x00, 0x00, 0x00, 0x2a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x22, 0x22, 0x2a, 0xaa, 0xaa, 0xaa, 0xaa,
  0xaa, 0xa2, 0x22, 0x22, 0x2a, 0xaa, 0xab, 0x80, 0x00, 0x30, 0xfc, 0x00, 0x00, 0x7f, 0xf0, 0x00,
  0xe0, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x60, 0x01, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
  0x00, 0x30, 0xfe, 0x80, 0x00, 0xff, 0x80, 0x03, 0xc0, 0x00, 0x3c, 0x00, 0xa0, 0x02, 0xe0, 0x07,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x70, 0x7f, 0xc0, 0x01, 0xf4, 0x00, 0x0f,
  0x80, 0x00, 0x7d, 0xff, 0xc0, 0x0f, 0x00, 0x01, 0xff, 0xff, 0xff, 0xdd, 0xdd, 0xdd, 0xd5, 0x5d,
  0xff, 0xfd, 0xdd, 0xdd, 0xdd, 0xdd, 0x55, 0x44, 0x44, 0x44, 0x44, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xf8, 0x7f, 0xfa, 0xab, 0x80, 0x20, 0xbe, 0xaa, 0xab, 0xff, 0xe8, 0x00, 0xba, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xfc, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xfc, 0x2f, 0x8f, 0xff, 0xff, 0xee, 0xee, 0xff, 0xe8, 0x2f, 0xea, 0xfe, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xfc, 0x37, 0xc1, 0xc0, 0x7f, 0xe0, 0x00,
  0x0f, 0xfc, 0x07, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0xfe, 0x36, 0xc0, 0xe0, 0x03, 0xfa, 0x80, 0x03, 0xfe, 0x80, 0x2a, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xfc, 0x37, 0x40, 0x7c, 0x00, 0x7f, 0xf0,
  0x01, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xf8, 0x3a, 0xe0, 0xfe, 0x80, 0x0f, 0xf8, 0x00, 0xfe, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x1b, 0x60, 0x7f, 0xc0, 0x0f, 0xce,
  0x00, 0x6f, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0b, 0x20, 0x7a, 0xe0, 0x0e, 0xe3, 0x80, 0x23, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x30, 0x6c, 0x70, 0x07, 0x71,
  0xc0, 0x38, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xa0, 0x6e, 0x38, 0x03, 0xb8, 0xe0, 0x1c, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x30, 0x66, 0x18, 0x01, 0xcc,
  0x70, 0x0e, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0e, 0x30, 0x23, 0x08, 0x00, 0xe2, 0x38, 0x03, 0x80, 0xe0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x30, 0x31, 0x0c, 0x00, 0x70,
  0x1c, 0x01, 0xe0, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xb8, 0x38, 0x8e, 0x00, 0x38, 0x0e, 0x00, 0xf8, 0x18, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xd8, 0x1c, 0x46, 0x00, 0x1f,
  0x07, 0x00, 0x7f, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xf8, 0x0e, 0x02, 0x00, 0x0f, 0xa3, 0x80, 0x0b, 0xfe, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0e, 0x03, 0x00, 0x01,
  0xff, 0xc0, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x38, 0x0e, 0x83, 0x80, 0x00, 0xbf, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x81, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xe1, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf1, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xb8, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xc0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};