/*
Here is a resource to find,view and download TrueType fonts......
   https://fonts.google.com/

Here is a great resource to convert the .ttf files to a usable header file
so you can define your own custom fonts and add them to your sketch.......
  https://rop.nl/truetype2gfx/

Think of the GFXcanvas1 as a blank sheet of paper that you can write to.
The blank image is defined by canvasWidth x canvasHeight (in pixles).
You can write custom text, shapes, lines, etc as found in the Adafruit GFX library.
Once you are finised drawing to the blank image, you run the PrintDefinedCanvas function.
All of your graphics and text will print out as one image. 
We've printed images as large as 360x1000 but your mileage may vary.*/

const uint8_t PermanentMarker_Regular20pt7bBitmaps[] PROGMEM = {
  0x00, 0x01, 0x80, 0x70, 0x0F, 0x83, 0xE0, 0x7C, 0x0F, 0x83, 0xF8, 0x3E,
  0x0F, 0xC1, 0xF8, 0x3E, 0x0F, 0xC1, 0xF8, 0x3F, 0x07, 0xE0, 0xFC, 0x1F,
  0x03, 0xE0, 0x7C, 0x07, 0x00, 0x00, 0x00, 0x00, 0x01, 0xC0, 0x7E, 0x1F,
  0xC3, 0xF8, 0x3E, 0x07, 0xC0, 0x70, 0x00, 0x18, 0x0E, 0x07, 0xC3, 0xE1,
  0xF8, 0xFC, 0xFE, 0x7F, 0x3F, 0x9F, 0x8F, 0xC7, 0xE7, 0xF3, 0xF1, 0xF8,
  0xFC, 0x7E, 0x3F, 0x1F, 0x9F, 0x8F, 0xE7, 0xE3, 0xF1, 0xF8, 0xFC, 0x7E,
  0x3F, 0x1F, 0x0F, 0xCF, 0xC3, 0xE3, 0xF0, 0x78, 0x7C, 0x1C, 0x0E, 0x01,
  0x03, 0x00, 0x00, 0x10, 0x0C, 0x00, 0x07, 0x03, 0x80, 0x00, 0xF0, 0x78,
  0x00, 0x3E, 0x1F, 0x00, 0x07, 0xE3, 0xF0, 0x00, 0xF8, 0x7E, 0x00, 0x3F,
  0x1F, 0x80, 0x07, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xC7, 0xFF, 0xFF, 0xFC,
  0xFF, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xC1, 0xFF, 0x0F, 0x80, 0x07, 0xC3,
  0xF0, 0x00, 0xF8, 0x7C, 0x00, 0x3F, 0x0F, 0x80, 0x3F, 0xFF, 0xFE, 0x1F,
  0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0x0F, 0xFE, 0x7E,
  0x00, 0x3F, 0x1F, 0x80, 0x07, 0xC3, 0xF0, 0x01, 0xF8, 0xFE, 0x00, 0x3F,
  0x1F, 0x80, 0x07, 0xC3, 0xF0, 0x00, 0xF8, 0x7C, 0x00, 0x0E, 0x03, 0x00,
  0x00, 0x00, 0x08, 0x00, 0x00, 0xE0, 0x00, 0x07, 0x00, 0x00, 0x7C, 0x00,
  0x03, 0xE0, 0x00, 0x1F, 0x00, 0x00, 0xFF, 0x80, 0x3F, 0xFE, 0x0F, 0xFF,
  0xF1, 0xFF, 0xFF, 0xDF, 0xFE, 0xFD, 0xFF, 0x00, 0x0F, 0xFE, 0x00, 0x7F,
  0xF8, 0x01, 0xFF, 0xE0, 0x03, 0xFF, 0x80, 0x00, 0x7C, 0x00, 0x00, 0xF0,
  0x00, 0x07, 0x80, 0x00, 0x7C, 0x00, 0x0F, 0xC0, 0x03, 0xFE, 0x00, 0xFF,
  0xE0, 0x07, 0xFE, 0x00, 0x3F, 0xC0, 0x01, 0xFE, 0x00, 0x03, 0xE0, 0x00,
  0x1F, 0x00, 0x00, 0xF8, 0x00, 0x01, 0x80, 0x00, 0x01, 0x00, 0x01, 0x07,
  0x80, 0x07, 0x0F, 0x80, 0x0E, 0x1F, 0x80, 0x1E, 0x3F, 0xC0, 0x3E, 0x7F,
  0xC0, 0x7E, 0x7B, 0xE0, 0xFC, 0xF1, 0xE1, 0xF8, 0xFF, 0xE3, 0xF0, 0xFF,
  0xE7, 0xE0, 0xFF, 0xCF, 0xC0, 0x7F, 0x1F, 0x80, 0x08, 0x3F, 0x00, 0x00,
  0x7E, 0x00, 0x00, 0xFC, 0x00, 0x01, 0xF8, 0xC0, 0x03, 0xF1, 0xE0, 0x07,
  0xE3, 0xE0, 0x0F, 0xC7, 0xE0, 0x3F, 0x8F, 0xF0, 0x3F, 0x1F, 0xF0, 0x7E,
  0x3E, 0xF8, 0xF8, 0x3C, 0xF8, 0xFC, 0x3F, 0xF8, 0xF8, 0x3F, 0xF8, 0xF8,
  0x3F, 0xF0, 0xF0, 0x1F, 0xC0, 0xE0, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
  0x1C, 0x00, 0x00, 0x7C, 0x00, 0x00, 0xF8, 0x00, 0x23, 0xF0, 0x03, 0xE7,
  0xE0, 0x0F, 0xFF, 0xE0, 0x1F, 0xFF, 0x80, 0x7F, 0xFF, 0xF1, 0xF3, 0xFF,
  0xF3, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0xF7, 0xFF, 0xFF, 0x83, 0xFF, 0xC0,
  0x00, 0x3F, 0x80, 0x00, 0x7E, 0x00, 0x00, 0xFC, 0x00, 0x01, 0xF8, 0x00,
  0x03, 0xE0, 0x00, 0x07, 0xC0, 0x00, 0x02, 0x00, 0x00, 0x18, 0x0F, 0x87,
  0xE7, 0xF3, 0xF9, 0xF9, 0xFC, 0xFC, 0x7E, 0x3F, 0x3F, 0x9F, 0x8F, 0xC7,
  0xE3, 0xF1, 0xF0, 0x78, 0x38, 0x04, 0x00, 0x00, 0x03, 0x80, 0x03, 0xC0,
  0x03, 0xE0, 0x03, 0xF0, 0x03, 0xF8, 0x03, 0xFC, 0x03, 0xFE, 0x03, 0xFE,
  0x03, 0xFC, 0x01, 0xFC, 0x01, 0xFC, 0x01, 0xFC, 0x00, 0xFE, 0x00, 0xFE,
  0x00, 0x7F, 0x00, 0x7F, 0x00, 0x3F, 0x00, 0x1F, 0x80, 0x0F, 0xC0, 0x07,
  0xC0, 0x07, 0xE0, 0x03, 0xF0, 0x03, 0xF8, 0x01, 0xF8, 0x00, 0xFC, 0x00,
  0x7E, 0x00, 0x3F, 0x00, 0x1F, 0x80, 0x0F, 0xC0, 0x07, 0xF0, 0x03, 0xF8,
  0x00, 0xFC, 0x00, 0x7E, 0x00, 0x3F, 0x80, 0x1F, 0xC0, 0x07, 0xC0, 0x01,
  0xE0, 0x00, 0x78, 0x00, 0x3C, 0x00, 0x0E, 0x00, 0x00, 0x30, 0x00, 0x0E,
  0x00, 0x03, 0xC0, 0x00, 0xF8, 0x00, 0x3F, 0x00, 0x0F, 0xC0, 0x03, 0xF8,
  0x00, 0xFE, 0x00, 0x1F, 0x80, 0x07, 0xE0, 0x01, 0xFC, 0x00, 0x7E, 0x00,
  0x1F, 0x80, 0x07, 0xE0, 0x01, 0xF8, 0x00, 0x7E, 0x00, 0x1F, 0x80, 0x07,
  0xE0, 0x01, 0xF0, 0x00, 0x7E, 0x00, 0x3F, 0x00, 0x0F, 0xC0, 0x03, 0xF0,
  0x01, 0xFC, 0x00, 0x7E, 0x00, 0x3F, 0x80, 0x0F, 0xE0, 0x07, 0xF0, 0x03,
  0xFC, 0x00, 0xFE, 0x00, 0x7F, 0x00, 0x7F, 0xC0, 0x3F, 0xE0, 0x1F, 0xF0,
  0x07, 0xF8, 0x03, 0xFC, 0x00, 0x7E, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x03,
  0x80, 0x00, 0x00, 0x80, 0x00, 0x00, 0xE0, 0x78, 0x00, 0xF8, 0x7C, 0x00,
  0xFC, 0x7C, 0x00, 0x7F, 0x7E, 0x00, 0x3F, 0xFE, 0x00, 0x0F, 0xFE, 0x00,
  0x03, 0xFF, 0xE0, 0x7F, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF,
  0xDF, 0xFF, 0xFF, 0x87, 0xFF, 0xF8, 0x00, 0x1F, 0xFE, 0x00, 0x0F, 0xFF,
  0x00, 0x0F, 0xDF, 0x80, 0x0F, 0xE7, 0xC0, 0x07, 0xE1, 0xE0, 0x07, 0xF0,
  0x70, 0x00, 0x60, 0x10, 0x00, 0x00, 0x18, 0x00, 0x01, 0xC0, 0x00, 0x1F,
  0x00, 0x00, 0xFC, 0x00, 0x07, 0xC0, 0x00, 0x7E, 0x00, 0x03, 0xF8, 0x00,
  0x1F, 0x80, 0x1F, 0xFF, 0xC7, 0xFF, 0xFF, 0x1F, 0xFF, 0xFE, 0xFF, 0xFF,
  0xF7, 0xFF, 0xFC, 0x1F, 0xFC, 0x00, 0x0F, 0xE0, 0x00, 0x7E, 0x00, 0x03,
  0xF0, 0x00, 0x1F, 0x80, 0x00, 0xF8, 0x00, 0x03, 0xC0, 0x00, 0x04, 0x03,
  0xC0, 0xF8, 0x3F, 0x1F, 0xC7, 0xF1, 0xF8, 0xFE, 0x3F, 0x1F, 0xC7, 0xE0,
  0xF0, 0x08, 0x00, 0x3F, 0xFF, 0xCF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x7F, 0xFF, 0xC7, 0x80, 0x00, 0x30, 0xFF, 0xFF, 0xEF, 0xCF, 0x8E,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x0E, 0x00, 0x01, 0xF0, 0x00, 0x1F, 0x00,
  0x03, 0xF0, 0x00, 0x7E, 0x00, 0x0F, 0xE0, 0x00, 0xFC, 0x00, 0x1F, 0x80,
  0x03, 0xF0, 0x00, 0x7E, 0x00, 0x0F, 0xC0, 0x00, 0xFC, 0x00, 0x1F, 0x80,
  0x03, 0xF0, 0x00, 0x7E, 0x00, 0x0F, 0xC0, 0x01, 0xFC, 0x00, 0x3F, 0x80,
  0x03, 0xF0, 0x00, 0x7E, 0x00, 0x0F, 0xC0, 0x00, 0xF8, 0x00, 0x0F, 0x80,
  0x00, 0xF8, 0x00, 0x0F, 0x80, 0x00, 0xF8, 0x00, 0x0F, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0xF0, 0x00, 0x00, 0xF8, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, 0xFF, 0xC0, 0x00, 0xFF, 0xE0,
  0x00, 0xFF, 0xF0, 0x00, 0xFF, 0xF8, 0x00, 0xFF, 0xFC, 0x00, 0xFF, 0xFF,
  0x00, 0xFF, 0xDF, 0x80, 0xFF, 0x87, 0xE0, 0x7F, 0x83, 0xF0, 0x7F, 0x80,
  0xF8, 0x7F, 0x80, 0x7E, 0x3F, 0x80, 0x3F, 0x1F, 0xC0, 0x0F, 0x9F, 0xC0,
  0x07, 0xEF, 0xE0, 0x03, 0xF7, 0xE0, 0x03, 0xFB, 0xF0, 0x03, 0xFD, 0xF8,
  0x07, 0xFE, 0xFC, 0x1F, 0xFF, 0x7F, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0x1F,
  0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0x01, 0xFF, 0xFE, 0x00, 0x7F, 0xFC, 0x00,
  0x0F, 0xE0, 0x00, 0x10, 0x07, 0x01, 0xE0, 0xFC, 0x3F, 0x87, 0xE1, 0xF8,
  0x7E, 0x1F, 0x87, 0xE1, 0xFC, 0x7F, 0x1F, 0xC7, 0xF1, 0xF8, 0x7E, 0x3F,
  0x8F, 0xE3, 0xF9, 0xFC, 0x7F, 0x1F, 0xCF, 0xE3, 0xF8, 0xFC, 0x3F, 0x0F,
  0xC3, 0xF0, 0x78, 0x00, 0x1F, 0xFE, 0x00, 0x1F, 0xFF, 0xE0, 0x07, 0xFF,
  0xFC, 0x01, 0xFF, 0xFF, 0x80, 0x7F, 0xFF, 0xF0, 0x1F, 0xFF, 0xFE, 0x07,
  0xFF, 0xFF, 0x80, 0x30, 0x1F, 0xE0, 0x00, 0x0F, 0xF8, 0x00, 0x07, 0xFE,
  0x00, 0x03, 0xFF, 0x00, 0x03, 0xFF, 0x80, 0x01, 0xFF, 0xC0, 0x00, 0xFF,
  0xE0, 0x00, 0x7F, 0xE0, 0x00, 0x3F, 0xF0, 0x00, 0x1F, 0xF8, 0x00, 0x0F,
  0xFC, 0x00, 0x07, 0xFC, 0x00, 0x01, 0xFE, 0x00, 0xFC, 0x7F, 0x0F, 0xFF,
  0xBF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF,
  0xFF, 0x9F, 0xFF, 0xFF, 0x07, 0xFF, 0xF0, 0x00, 0x7F, 0x80, 0x00, 0x00,
  0x3F, 0xE0, 0x3F, 0xFF, 0xC7, 0xFF, 0xFF, 0x3F, 0xFF, 0xFE, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFC, 0xFF, 0xFF, 0xE0,
  0x1F, 0xFF, 0x00, 0x7F, 0xF0, 0x01, 0xFF, 0x00, 0x0F, 0xFF, 0x00, 0x3F,
  0xFE, 0x00, 0x7F, 0xFC, 0x00, 0xFF, 0xF8, 0x00, 0xFF, 0xE0, 0x00, 0x7F,
  0xC0, 0x00, 0x7F, 0x00, 0x01, 0xFC, 0x00, 0x1F, 0xF0, 0xFF, 0xFF, 0xC3,
  0xFF, 0xFE, 0x1F, 0xFF, 0xF8, 0x7F, 0xFF, 0x81, 0xFF, 0xF8, 0x07, 0xFF,
  0x80, 0x0F, 0xC0, 0x00, 0x00, 0x0E, 0x00, 0x00, 0xE0, 0x00, 0x0F, 0x04,
  0x00, 0xF0, 0x60, 0x0F, 0x8F, 0x01, 0xF8, 0xF0, 0x1F, 0x8F, 0x81, 0xF0,
  0xF8, 0x1F, 0x0F, 0xC1, 0xF0, 0xFC, 0x1F, 0xE7, 0xC3, 0xFF, 0x7F, 0xFF,
  0xF7, 0xFF, 0xFF, 0x7F, 0xFF, 0xF7, 0xFF, 0xFE, 0x3F, 0xFF, 0x81, 0xFF,
  0xC0, 0x00, 0xFC, 0x00, 0x0F, 0xC0, 0x00, 0xF8, 0x00, 0x0F, 0x80, 0x01,
  0xF8, 0x00, 0x1F, 0x00, 0x01, 0xF8, 0x00, 0x1F, 0x80, 0x00, 0xFC, 0x00,
  0x0F, 0xC0, 0x00, 0xFC, 0x00, 0x07, 0xC0, 0x00, 0xC0, 0x00, 0x03, 0xE0,
  0x00, 0x07, 0xF0, 0x7C, 0x1F, 0xFF, 0xFE, 0x3F, 0xFF, 0xFE, 0x7F, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFC,
  0x00, 0xFF, 0xC0, 0x00, 0xFF, 0xC0, 0x00, 0xFF, 0xF0, 0x00, 0x7F, 0xF8,
  0x00, 0x3F, 0xFC, 0x00, 0x0F, 0xFE, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x7F,
  0x00, 0x00, 0x1F, 0x80, 0x00, 0x1F, 0x80, 0x00, 0x3F, 0x80, 0xFF, 0xFF,
  0x80, 0xFF, 0xFF, 0x80, 0xFF, 0xFF, 0x80, 0x7F, 0xFF, 0x00, 0x7F, 0xFE,
  0x00, 0x3F, 0xFC, 0x00, 0x03, 0x90, 0x00, 0x00, 0x1E, 0x00, 0x0F, 0xC0,
  0x03, 0xFC, 0x00, 0x7F, 0x80, 0x1F, 0xF8, 0x07, 0xFE, 0x00, 0xFF, 0x00,
  0x3F, 0x80, 0x07, 0xE0, 0x01, 0xFC, 0x00, 0x3F, 0x00, 0x07, 0xE0, 0x01,
  0xF8, 0x00, 0x3F, 0x04, 0x0F, 0xE7, 0xE1, 0xF9, 0xFE, 0x3E, 0x7F, 0xCF,
  0xDF, 0xFD, 0xFB, 0xFF, 0xBE, 0x7F, 0xF7, 0xDF, 0xFE, 0xFB, 0xFF, 0xDF,
  0xFF, 0xF3, 0xFF, 0xFE, 0x7F, 0xFF, 0x8F, 0xFF, 0xC0, 0xFF, 0xE0, 0x1F,
  0xE0, 0x00, 0x40, 0x00, 0x3F, 0xF0, 0x00, 0x7F, 0xFF, 0x00, 0x7F, 0xFF,
  0x80, 0x7F, 0xFF, 0x80, 0x7F, 0xFF, 0xC0, 0xFF, 0xFF, 0xE0, 0x7F, 0xFF,
  0xE0, 0x00, 0x0F, 0xE0, 0x00, 0x03, 0xE0, 0x00, 0x03, 0xE0, 0x00, 0x03,
  0xE0, 0x00, 0x07, 0xE0, 0x00, 0x07, 0xFE, 0x00, 0xFF, 0xFF, 0x0F, 0xFF,
  0xFF, 0x1F, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0x1F, 0xFF, 0xFC, 0x3F, 0xFF,
  0x00, 0x0F, 0xFE, 0x00, 0x00, 0xFE, 0x00, 0x01, 0xFC, 0x00, 0x01, 0xF8,
  0x00, 0x01, 0xF8, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, 0x00, 0x01, 0xF0,
  0x00, 0x01, 0xE0, 0x00, 0x07, 0xF8, 0xC0, 0x7F, 0xC7, 0x0F, 0xFF, 0x7C,
  0x7F, 0xFB, 0xE7, 0xFF, 0xCF, 0x3F, 0xFF, 0x7D, 0xF9, 0xF3, 0xFF, 0x87,
  0xFF, 0xFC, 0x0F, 0xF7, 0xF0, 0xFF, 0x9F, 0xFF, 0xF8, 0xFF, 0xFF, 0x83,
  0xFF, 0xF8, 0x1F, 0xFF, 0x00, 0x7F, 0xE0, 0x07, 0xFE, 0x00, 0x3F, 0xF8,
  0x03, 0xFF, 0xC0, 0x1F, 0xFE, 0x00, 0xF9, 0xF8, 0x07, 0xC7, 0xC0, 0x3E,
  0x3E, 0x01, 0xFF, 0xF0, 0x0F, 0xFF, 0x80, 0x3F, 0xFC, 0x01, 0xFF, 0xC0,
  0x07, 0xFE, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x01,
  0xFF, 0x00, 0x7F, 0xF8, 0x0F, 0xFF, 0x81, 0xFF, 0xFC, 0x3F, 0xFF, 0xC3,
  0xFE, 0x7C, 0x7F, 0x87, 0xE7, 0xF7, 0xFE, 0x7F, 0xFF, 0xF7, 0xFF, 0xFF,
  0x7F, 0xFF, 0xE7, 0xFF, 0xFE, 0x7F, 0xFF, 0xC3, 0xFE, 0xF8, 0x00, 0x0F,
  0x80, 0x00, 0xF8, 0x00, 0x1F, 0x00, 0x01, 0xF0, 0x00, 0x1F, 0x00, 0x01,
  0xF0, 0x00, 0x3F, 0x00, 0x03, 0xE0, 0x00, 0x3E, 0x00, 0x03, 0xE0, 0x00,
  0x3E, 0x00, 0x03, 0xE0, 0x00, 0x3C, 0x00, 0x01, 0x00, 0x1C, 0x0F, 0x8F,
  0xE7, 0xE3, 0xF8, 0xF8, 0x78, 0x00, 0x00, 0x00, 0x00, 0x06, 0x07, 0xE7,
  0xF3, 0xF1, 0xF8, 0x7C, 0x1C, 0x00, 0x07, 0x01, 0xF8, 0x1F, 0x87, 0xF0,
  0xFE, 0x0F, 0xC0, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0xE0,
  0x3F, 0x07, 0xE0, 0xFC, 0x3F, 0x87, 0xE0, 0xFC, 0x3F, 0x0F, 0xE1, 0xF8,
  0x1E, 0x00, 0x80, 0x00, 0x00, 0x04, 0x00, 0x00, 0x3E, 0x00, 0x00, 0xFF,
  0x00, 0x07, 0xFF, 0x00, 0x1F, 0xFE, 0x00, 0xFF, 0xFC, 0x07, 0xFF, 0xF0,
  0x7F, 0xFF, 0x80, 0xFF, 0xFC, 0x00, 0xFF, 0xF0, 0x00, 0x7F, 0xE0, 0x00,
  0x7F, 0xFC, 0x00, 0x1F, 0xFF, 0x80, 0x07, 0xFF, 0xC0, 0x01, 0xFF, 0xE0,
  0x00, 0x3F, 0xF0, 0x00, 0x07, 0xF8, 0x00, 0x00, 0xF0, 0x1F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xCF, 0xFF, 0xFE, 0x3F, 0xFF, 0x00, 0x40,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xE0, 0x7F, 0xFF, 0xE3, 0xFF, 0xFF,
  0x8F, 0xFF, 0xFE, 0x3F, 0xFF, 0xE0, 0x7C, 0x00, 0x00, 0x04, 0x00, 0x00,
  0x07, 0xE0, 0x00, 0x03, 0xFE, 0x00, 0x00, 0xFF, 0xE0, 0x00, 0x3F, 0xFE,
  0x00, 0x0F, 0xFF, 0xC0, 0x01, 0xFF, 0xF0, 0x00, 0x1F, 0xFE, 0x00, 0x03,
  0xFF, 0x00, 0x0F, 0xFF, 0x80, 0x3F, 0xFF, 0xC0, 0x7F, 0xFE, 0xC0, 0xFF,
  0xFC, 0x01, 0xFF, 0xF0, 0x03, 0xFF, 0xC0, 0x00, 0xFF, 0x80, 0x00, 0xFF,
  0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x3F, 0xFE, 0x01,
  0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0x7F, 0xFF, 0xFD, 0xFF, 0xFF, 0xF7, 0xFF,
  0xFF, 0xC7, 0x07, 0xFF, 0x00, 0x03, 0xFC, 0x00, 0x1F, 0xE0, 0x01, 0xFF,
  0x80, 0x0F, 0xFC, 0x00, 0xFF, 0xE0, 0x07, 0xFF, 0x00, 0x3F, 0xF0, 0x01,
  0xFF, 0x00, 0x0F, 0xF8, 0x00, 0x3F, 0x80, 0x01, 0xF8, 0x00, 0x07, 0xC0,
  0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00,
  0xFC, 0x00, 0x03, 0xF0, 0x00, 0x0F, 0xC0, 0x00, 0x3F, 0x00, 0x00, 0x7E,
  0x00, 0x01, 0xC0, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x3F, 0x80,
  0x00, 0x03, 0xFC, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x07, 0xFF, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x3F, 0x9F, 0x80, 0x07, 0xF0, 0xF8, 0x01, 0xFE, 0x07,
  0xC0, 0x3F, 0x81, 0x3C, 0x07, 0xF0, 0x3B, 0xE0, 0xFE, 0x1F, 0x9E, 0x1F,
  0xC7, 0xF9, 0xF3, 0xF8, 0xFF, 0x8F, 0x7F, 0x3F, 0xF1, 0xF7, 0xE7, 0xFF,
  0x1F, 0xFC, 0xFC, 0xF1, 0xFF, 0xCF, 0x8F, 0x1E, 0xF8, 0xF8, 0xF3, 0xEF,
  0x8F, 0xFF, 0xFC, 0xF0, 0xFF, 0xFF, 0x8F, 0x07, 0xFF, 0xF0, 0xF0, 0x3F,
  0xE4, 0x0F, 0xC0, 0x00, 0x00, 0x7F, 0x00, 0x04, 0x03, 0xFF, 0xFF, 0xC0,
  0x1F, 0xFF, 0xFE, 0x00, 0x7F, 0xFF, 0xF0, 0x01, 0xFF, 0xFF, 0x00, 0x00,
  0xFF, 0xC0, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0xFE,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0xFF, 0xC0, 0x00, 0x3F, 0xFE, 0x00,
  0x03, 0xFF, 0xF0, 0x00, 0x1F, 0xFF, 0x80, 0x01, 0xFF, 0xFC, 0x00, 0x0F,
  0xFF, 0xE0, 0x00, 0xFF, 0xBF, 0x80, 0x07, 0xF9, 0xFC, 0x00, 0x3F, 0x8F,
  0xE0, 0x03, 0xFC, 0x3F, 0x00, 0x1F, 0xC1, 0xFF, 0x01, 0xFC, 0x0F, 0xFF,
  0x0F, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xF0, 0x7F,
  0x7F, 0xFF, 0x03, 0xFB, 0xFF, 0xF8, 0x3F, 0x8F, 0x8F, 0xC1, 0xFC, 0x00,
  0x7E, 0x0F, 0xC0, 0x07, 0xF0, 0xFE, 0x00, 0xFF, 0x83, 0xF0, 0x03, 0xFC,
  0x1F, 0x80, 0x0F, 0xC0, 0x70, 0x00, 0x78, 0x00, 0x00, 0x00, 0x40, 0x00,
  0x0F, 0xFF, 0x00, 0x3F, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0x87, 0xFF, 0xFF,
  0xF9, 0xFF, 0xFF, 0xFF, 0x3F, 0xFE, 0x0F, 0xE3, 0xFF, 0x03, 0xFC, 0x7F,
  0xE0, 0xFF, 0x87, 0xBE, 0x7F, 0xE0, 0x27, 0xFF, 0xFC, 0x00, 0xFF, 0xFF,
  0x00, 0x3F, 0xFF, 0xC0, 0x07, 0xFF, 0xF0, 0x00, 0xFF, 0xFF, 0x00, 0x1F,
  0xFF, 0xF0, 0x03, 0xFF, 0xFF, 0x00, 0xFF, 0x81, 0xF0, 0x1F, 0xC0, 0x1F,
  0x07, 0xF0, 0x07, 0xE0, 0xFE, 0x01, 0xFC, 0x1F, 0xC0, 0xFF, 0xC3, 0xF0,
  0xFF, 0xF0, 0xFE, 0x7F, 0xFE, 0x1F, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xE0,
  0x7F, 0xFF, 0xF0, 0x07, 0xFF, 0xF8, 0x00, 0xFF, 0xF8, 0x00, 0x0C, 0x58,
  0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x03, 0xF0, 0x00, 0x1F, 0xF0, 0x00,
  0xFF, 0xF0, 0x03, 0xFF, 0xE0, 0x3F, 0xFF, 0xC0, 0xFF, 0xFF, 0x03, 0xFF,
  0xFC, 0x0F, 0xFF, 0xC0, 0x3F, 0xFC, 0x00, 0xFF, 0xF0, 0x03, 0xFF, 0x80,
  0x07, 0xFC, 0x00, 0x1F, 0xF0, 0x00, 0x3F, 0xC0, 0x00, 0x7F, 0x00, 0x00,
  0xFC, 0x00, 0x01, 0xF8, 0x00, 0x03, 0xF0, 0x00, 0x07, 0xE0, 0x00, 0x07,
  0xF0, 0x00, 0x0F, 0xFF, 0xFE, 0x0F, 0xFF, 0xFE, 0x1F, 0xFF, 0xFE, 0x1F,
  0xFF, 0xFC, 0x0F, 0xFF, 0xF8, 0x0F, 0xFF, 0xE0, 0x01, 0xFF, 0x00, 0x38,
  0x00, 0x01, 0xF0, 0x00, 0x1F, 0xF0, 0x00, 0x7F, 0xE0, 0x03, 0xFF, 0x80,
  0x3F, 0xFF, 0x01, 0xFF, 0xFC, 0x0F, 0x9F, 0xF0, 0x3C, 0x1F, 0xC1, 0xF0,
  0x3F, 0x0F, 0x80, 0xFC, 0x7C, 0x03, 0xE3, 0xE0, 0x0F, 0x9F, 0x00, 0x3C,
  0xF8, 0x03, 0xEF, 0xC0, 0x3F, 0x7E, 0x03, 0xFB, 0xF0, 0x7F, 0xDF, 0x0F,
  0xFD, 0xFB, 0xFF, 0xCF, 0xFF, 0xFC, 0x7F, 0xFF, 0xC3, 0xFF, 0xFC, 0x1F,
  0xFF, 0x80, 0xFF, 0xF0, 0x07, 0xFE, 0x00, 0x3F, 0x80, 0x00, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x3E, 0x00, 0x07, 0xFF, 0x80, 0x3F, 0xFF, 0xE1, 0xFF,
  0xFF, 0xF1, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xE0, 0x3F,
  0xFE, 0x00, 0x1F, 0xF0, 0x00, 0x07, 0xF0, 0x00, 0x03, 0xF8, 0x70, 0x01,
  0xFF, 0xFC, 0x00, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xC0, 0x7F, 0xFF, 0xE0,
  0x7F, 0xFF, 0xC0, 0x3F, 0xFF, 0xC0, 0x3F, 0xC0, 0x00, 0x1F, 0xC0, 0x00,
  0x1F, 0xE0, 0x00, 0x0F, 0xE0, 0x03, 0x87, 0xF0, 0xFF, 0xE1, 0xFF, 0xFF,
  0xF8, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFE, 0x3F, 0xFF, 0xFE, 0x0F, 0xFF,
  0xFC, 0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x07, 0xFE,
  0x00, 0x03, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0xE0, 0x3F, 0xFF, 0xFF, 0x87,
  0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xF0, 0x03, 0xFF, 0xE0, 0x00, 0x0F, 0xFC,
  0x00, 0x00, 0x7F, 0xC0, 0x00, 0x01, 0xFE, 0x00, 0x00, 0x07, 0xF0, 0x00,
  0x00, 0x3F, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0xDF, 0xCF, 0xE0, 0x0F,
  0xFF, 0xFF, 0x80, 0xFF, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xE0, 0x3F, 0xFF,
  0xFE, 0x00, 0xFF, 0xFF, 0xE0, 0x03, 0xFF, 0xC0, 0x00, 0x0F, 0xC0, 0x00,
  0x00, 0xFE, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x01,
  0xF0, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x01, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00,
  0x01, 0xFF, 0x00, 0x00, 0x07, 0xFF, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x3F, 0xFF, 0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x01,
  0xFF, 0xE0, 0x00, 0x03, 0xFF, 0x80, 0x00, 0x07, 0xFF, 0x00, 0x00, 0x0F,
  0xFC, 0x06, 0x00, 0x1F, 0xF8, 0x0F, 0x80, 0x3F, 0xF0, 0x1F, 0xE0, 0x3F,
  0xE0, 0x1F, 0xF8, 0x7F, 0xC0, 0x1F, 0xFC, 0x7F, 0x80, 0x0F, 0xFE, 0xFF,
  0x00, 0x0F, 0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xFC, 0x00, 0x3F, 0xFF, 0xFC,
  0x07, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFC, 0x7F,
  0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0x80, 0x3F, 0xFF, 0xF8, 0x00, 0x1F,
  0xFF, 0xC0, 0x00, 0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x80,
  0x01, 0x80, 0x60, 0x00, 0xF0, 0x1C, 0x00, 0x3C, 0x0F, 0x80, 0x0F, 0x83,
  0xE0, 0x03, 0xE0, 0xFC, 0x00, 0xFC, 0x3F, 0x80, 0x7F, 0x0F, 0xC0, 0x1F,
  0xC7, 0xF0, 0x07, 0xF1, 0xFC, 0x01, 0xFC, 0x7F, 0x00, 0x7F, 0x1F, 0xC0,
  0x1F, 0xC7, 0xF0, 0x07, 0xF1, 0xF8, 0x03, 0xFC, 0x7E, 0x0F, 0xFF, 0x3F,
  0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xFC,
  0x7F, 0xFF, 0xFF, 0x1F, 0xFF, 0xBF, 0xCF, 0xFF, 0x0F, 0xE3, 0xFF, 0x03,
  0xF8, 0xFF, 0x80, 0xFE, 0x3F, 0xC0, 0x3F, 0x8F, 0xF0, 0x07, 0xE3, 0xF8,
  0x01, 0xF0, 0x3C, 0x00, 0x38, 0x04, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF,
  0x00, 0xFF, 0xFF, 0xE0, 0x7F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0x07, 0xFF,
  0xFF, 0xC0, 0xFF, 0xFF, 0x00, 0x1C, 0xFC, 0x00, 0x00, 0x3F, 0x00, 0x00,
  0x1F, 0x80, 0x00, 0x07, 0xE0, 0x00, 0x01, 0xF8, 0x00, 0x00, 0xFC, 0x00,
  0x00, 0x3F, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x07, 0xF0, 0x00, 0x01, 0xF8,
  0x00, 0x00, 0x7E, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x0F, 0xC0, 0x00, 0x07,
  0xF0, 0x00, 0x01, 0xF8, 0x00, 0x00, 0xFF, 0xC0, 0x03, 0xFF, 0xF8, 0x03,
  0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xC0, 0x3F, 0xFF, 0xF0, 0x0F, 0xFF, 0xF8,
  0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE0, 0x01, 0xFF, 0xFF, 0xFC,
  0x0F, 0xFF, 0xFF, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF,
  0x0F, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xBE, 0x07, 0xC0, 0x7E, 0x00,
  0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0xFC, 0x00,
  0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x01, 0xFC, 0x00,
  0x00, 0x01, 0xFC, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x03, 0xF8, 0x00,
  0x00, 0x03, 0xF8, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x07, 0xF0, 0x00,
  0x20, 0x0F, 0xF0, 0x00, 0x7C, 0x1F, 0xE0, 0x00, 0xFF, 0xFF, 0xE0, 0x00,
  0xFF, 0xFF, 0xC0, 0x00, 0x7F, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0x00, 0x00,
  0x3F, 0xFE, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00,
  0x01, 0xF0, 0x00, 0x80, 0x07, 0xF0, 0x07, 0x80, 0x0F, 0xE0, 0x3F, 0x80,
  0x3F, 0xC0, 0xFF, 0x80, 0x7F, 0x87, 0xFF, 0x01, 0xFE, 0x1F, 0xFE, 0x03,
  0xFC, 0x7F, 0xF8, 0x07, 0xF3, 0xFF, 0xE0, 0x1F, 0xEF, 0xFF, 0x00, 0x3F,
  0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0x80, 0x03, 0xFF,
  0xFC, 0x00, 0x0F, 0xFF, 0xF0, 0x00, 0x1F, 0xFF, 0xC0, 0x00, 0x3F, 0xFF,
  0xC0, 0x00, 0x7F, 0xFF, 0x80, 0x01, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF,
  0xFF, 0xC7, 0xFE, 0x3F, 0xFF, 0xDF, 0xFC, 0x3F, 0xFF, 0xDF, 0xF0, 0x3F,
  0xFF, 0xFF, 0xC0, 0x3F, 0xFF, 0x7F, 0x00, 0x1F, 0xFC, 0xFE, 0x00, 0x0F,
  0xF0, 0xF8, 0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
  0x00, 0x01, 0xE0, 0x00, 0x03, 0xF0, 0x00, 0x03, 0xF8, 0x00, 0x03, 0xF8,
  0x00, 0x03, 0xF8, 0x00, 0x07, 0xF8, 0x00, 0x07, 0xF0, 0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xE0, 0x00, 0x0F, 0xE0, 0x00, 0x1F, 0xE0, 0x00, 0x1F, 0xC0,
  0x00, 0x1F, 0xC0, 0x00, 0x3F, 0xC0, 0x00, 0x3F, 0x80, 0x00, 0x3F, 0x80,
  0x00, 0x7F, 0x80, 0x00, 0x7F, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x7F, 0x00,
  0x00, 0xFE, 0x1F, 0xE0, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF,
  0xFE, 0x7F, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0x3F, 0xFF, 0xFE, 0x1F, 0xE0,
  0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x06, 0x00, 0x07,
  0xE0, 0x00, 0x1E, 0x00, 0x1F, 0xE0, 0x00, 0xFC, 0x00, 0xFF, 0x80, 0x07,
  0xF0, 0x03, 0xFF, 0x00, 0x3F, 0xE0, 0x1F, 0xFC, 0x01, 0xFF, 0x80, 0xFF,
  0xF0, 0x0F, 0xFF, 0x03, 0xFF, 0xC0, 0x7F, 0xF8, 0x1F, 0xFF, 0x03, 0xFF,
  0xE0, 0x7F, 0xFC, 0x3F, 0xFF, 0x83, 0xFF, 0xFF, 0xFF, 0xFC, 0x0F, 0xFF,
  0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF,
  0x07, 0xFF, 0xFF, 0xFD, 0xFC, 0x3F, 0xDF, 0xFF, 0xC7, 0xF0, 0xFF, 0x3F,
  0xFE, 0x1F, 0xC7, 0xF8, 0x7F, 0xE0, 0x7F, 0x1F, 0xE0, 0xFE, 0x03, 0xFC,
  0x7F, 0x80, 0x00, 0x0F, 0xF3, 0xFC, 0x00, 0x00, 0x3F, 0x8F, 0xF0, 0x00,
  0x00, 0xFE, 0x3F, 0x80, 0x00, 0x03, 0xF8, 0xFE, 0x00, 0x00, 0x0F, 0xC3,
  0xF0, 0x00, 0x00, 0x3F, 0x07, 0xC0, 0x00, 0x00, 0xF8, 0x1F, 0x00, 0x00,
  0x01, 0xC0, 0x38, 0x00, 0x00, 0x04, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x30, 0x01, 0x80, 0x01, 0xE0, 0x1E, 0x00, 0x1F, 0x80, 0xFC, 0x00,
  0xFE, 0x07, 0xE0, 0x0F, 0xF0, 0x7F, 0x80, 0x7F, 0x83, 0xF8, 0x07, 0xFC,
  0x1F, 0xC0, 0x3F, 0xE0, 0xFE, 0x03, 0xFF, 0x0F, 0xE0, 0x1F, 0xF8, 0x7F,
  0x01, 0xFF, 0x83, 0xF8, 0x0F, 0xFC, 0x1F, 0x80, 0xFF, 0xE0, 0xFC, 0x07,
  0xFF, 0x0F, 0xE0, 0x7F, 0xF8, 0x7F, 0x03, 0xFF, 0xC7, 0xF8, 0x3F, 0xFE,
  0x3F, 0xC1, 0xFF, 0xF3, 0xFE, 0x1F, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF,
  0x0F, 0xFD, 0xFF, 0xF8, 0x3F, 0xCF, 0xFF, 0x81, 0xFC, 0x3F, 0xF8, 0x0F,
  0xE0, 0xFF, 0xC0, 0x3F, 0x03, 0xFC, 0x01, 0xF0, 0x0F, 0xC0, 0x07, 0x80,
  0x3C, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x0F,
  0x80, 0x00, 0x03, 0xFC, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x0F, 0xFE, 0x00,
  0x01, 0xFF, 0xE0, 0x00, 0x3F, 0xFC, 0x00, 0x07, 0xFF, 0xE0, 0x00, 0xFF,
  0xFE, 0x00, 0x3F, 0xFF, 0xF0, 0x03, 0xFF, 0xFF, 0x00, 0x7F, 0xC1, 0xF8,
  0x0F, 0xF8, 0x1F, 0x81, 0xFF, 0x00, 0xFC, 0x1F, 0xE0, 0x0F, 0xC3, 0xFC,
  0x00, 0x7E, 0x7F, 0x80, 0x07, 0xE7, 0xF0, 0x00, 0x3E, 0x7F, 0x00, 0x07,
  0xE7, 0xE0, 0x00, 0x7F, 0xFE, 0x00, 0x1F, 0xFF, 0xE0, 0x0F, 0xFE, 0xFF,
  0x1F, 0xFF, 0xE7, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0x83, 0xFF, 0xFF,
  0xF0, 0x3F, 0xFF, 0xFC, 0x01, 0xFF, 0xFF, 0x00, 0x07, 0xFF, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x80, 0x00, 0x1F, 0xFC, 0x00, 0x3F, 0xFF,
  0x00, 0x3F, 0xFF, 0xC0, 0x1F, 0xFF, 0xE0, 0x1F, 0xFF, 0xF8, 0x1F, 0xFF,
  0xFC, 0x0F, 0xFF, 0xFF, 0x07, 0xF0, 0x7F, 0x87, 0xF0, 0x0F, 0xC7, 0xF0,
  0x1F, 0xE7, 0xF8, 0x7F, 0xF3, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFD, 0xFF,
  0xFF, 0xFC, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xF0, 0x1F,
  0xFF, 0xC0, 0x07, 0xFE, 0x00, 0x03, 0xF0, 0x00, 0x03, 0xF8, 0x00, 0x01,
  0xFC, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x3F, 0x80, 0x00,
  0x3F, 0x80, 0x00, 0x0F, 0xC0, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x03, 0xFC, 0x00,
  0x00, 0x3F, 0xE0, 0x00, 0x07, 0xFF, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x1F,
  0xFF, 0x00, 0x03, 0xFF, 0xF8, 0x00, 0x7F, 0xFF, 0xC0, 0x1F, 0xFF, 0xFC,
  0x01, 0xFF, 0x87, 0xE0, 0x7F, 0xE0, 0x7E, 0x0F, 0xFC, 0x03, 0xF1, 0xFF,
  0x80, 0x3F, 0x3F, 0xF0, 0x01, 0xF7, 0xFC, 0x7C, 0x3F, 0x7F, 0x87, 0xE3,
  0xFF, 0xF0, 0x7F, 0x7F, 0xFF, 0x03, 0xFF, 0xFF, 0xE0, 0x1F, 0xFE, 0xFC,
  0x00, 0xFF, 0xEF, 0xC0, 0x7F, 0xFC, 0xF8, 0x3F, 0xFF, 0x8F, 0xFF, 0xFF,
  0xF0, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0x83,
  0xFF, 0xF8, 0xFC, 0x0F, 0xF8, 0x0F, 0xC0, 0x20, 0x00, 0x7C, 0x00, 0x00,
  0x07, 0x80, 0x00, 0x02, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x07, 0xF0, 0x00,
  0x07, 0xFC, 0x00, 0x07, 0xFF, 0x00, 0x03, 0xFF, 0xC0, 0x03, 0xFF, 0xE0,
  0x03, 0xFF, 0xF8, 0x0F, 0xFF, 0xFC, 0x07, 0xFC, 0xFE, 0x07, 0xFC, 0x3F,
  0x83, 0xFC, 0x1F, 0xC1, 0xFC, 0x1F, 0xE0, 0xFE, 0x7F, 0xF0, 0xFF, 0xFF,
  0xF0, 0x7F, 0xFF, 0xF8, 0x3F, 0xFF, 0xF0, 0x1F, 0xFF, 0xF0, 0x0F, 0xFF,
  0xC0, 0x0F, 0xFF, 0x00, 0x07, 0xFF, 0x00, 0x03, 0xFF, 0xE0, 0x01, 0xFF,
  0xFC, 0x00, 0xFF, 0xFF, 0xE0, 0xFE, 0xFF, 0xFF, 0x3F, 0x3F, 0xFF, 0xDF,
  0x0F, 0xFF, 0xEF, 0x81, 0xFF, 0xF3, 0x80, 0x1F, 0xF8, 0x00, 0x01, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x7F,
  0xFE, 0x00, 0xFF, 0xFF, 0xE0, 0x7F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xCF,
  0xFF, 0xFF, 0xFB, 0xFF, 0xF9, 0xCC, 0x7F, 0xF0, 0x00, 0x1F, 0xFE, 0x00,
  0x01, 0xFF, 0xF0, 0x00, 0x7F, 0xFF, 0x80, 0x07, 0xFF, 0xF8, 0x00, 0x7F,
  0xFF, 0x00, 0x03, 0xFF, 0xF0, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x03, 0xE0,
  0x00, 0x00, 0x3C, 0x00, 0x00, 0x0F, 0x80, 0x00, 0x03, 0xF0, 0x00, 0x00,
  0xFE, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x3F, 0xF0, 0x00, 0xFF, 0xFE, 0x00,
  0x3F, 0xFF, 0x80, 0x07, 0xFF, 0xE0, 0x00, 0xFF, 0xF0, 0x00, 0x1F, 0xF8,
  0x00, 0x01, 0xFC, 0x00, 0x00, 0x00, 0x0E, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD,
  0xFF, 0xFF, 0xFF, 0xC7, 0xFF, 0xFE, 0x00, 0x0F, 0xFF, 0xE0, 0x00, 0x00,
  0x3F, 0x80, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x1F,
  0xC0, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x0F, 0xC0,
  0x00, 0x00, 0x7F, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x0F, 0xE0, 0x00,
  0x00, 0x3F, 0x80, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00,
  0x0F, 0x80, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x03,
  0xE0, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x3E,
  0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x01,
  0xC0, 0x00, 0x00, 0x78, 0x40, 0x00, 0x3E, 0x78, 0x00, 0x0F, 0x9F, 0x00,
  0x03, 0xF7, 0xC0, 0x00, 0xFD, 0xF8, 0x00, 0x7F, 0x7E, 0x00, 0x1F, 0xDF,
  0x80, 0x07, 0xFF, 0xF0, 0x03, 0xFB, 0xF8, 0x00, 0xFE, 0xFE, 0x00, 0x7F,
  0xBF, 0x80, 0x1F, 0xEF, 0xE0, 0x0F, 0xF3, 0xF8, 0x07, 0xF8, 0xFE, 0x03,
  0xFE, 0x3F, 0x83, 0xFF, 0x0F, 0xE3, 0xFF, 0xC3, 0xFF, 0xFF, 0xC0, 0xFF,
  0xFF, 0xE0, 0x1F, 0xFF, 0xF8, 0x07, 0xFF, 0xFC, 0x01, 0xFF, 0xFE, 0x00,
  0x3F, 0xFF, 0x00, 0x0F, 0xFF, 0x00, 0x01, 0xFF, 0x00, 0x00, 0x1F, 0x00,
  0x00, 0x60, 0x00, 0x3D, 0xC0, 0x00, 0xFB, 0xC0, 0x03, 0xF7, 0xC0, 0x0F,
  0xFF, 0x80, 0x3F, 0xDF, 0x80, 0xFF, 0xBF, 0x01, 0xFF, 0x7E, 0x07, 0xFC,
  0xFC, 0x1F, 0xF1, 0xFC, 0x3F, 0xC3, 0xF8, 0xFF, 0x07, 0xF3, 0xFE, 0x0F,
  0xE7, 0xF8, 0x1F, 0xDF, 0xE0, 0x3F, 0xBF, 0x80, 0x7F, 0xFF, 0x00, 0xFF,
  0xFC, 0x00, 0xFF, 0xF0, 0x01, 0xFF, 0xE0, 0x03, 0xFF, 0x80, 0x07, 0xFF,
  0x00, 0x0F, 0xFC, 0x00, 0x0F, 0xF0, 0x00, 0x1F, 0xC0, 0x00, 0x3F, 0x80,
  0x00, 0x3F, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x00, 0x18, 0x03, 0x80, 0x00, 0x00,
  0x3C, 0x07, 0xC0, 0x04, 0x00, 0x3E, 0x0F, 0xE0, 0x0E, 0x00, 0x7E, 0x0F,
  0xE0, 0x1F, 0x00, 0x7E, 0x1F, 0xE0, 0x1F, 0x80, 0xFF, 0x1F, 0xE0, 0x3F,
  0x80, 0xFF, 0x1F, 0xC0, 0x7F, 0x80, 0xFE, 0x3F, 0xC0, 0x7F, 0x81, 0xFE,
  0x3F, 0xC0, 0xFF, 0x81, 0xFC, 0x3F, 0x80, 0xFF, 0x83, 0xFC, 0x3F, 0x81,
  0xFF, 0x03, 0xF8, 0x7F, 0x03, 0xFF, 0x07, 0xF8, 0x7F, 0x03, 0xFF, 0x07,
  0xF8, 0x7F, 0x07, 0xFF, 0x07, 0xF0, 0x7F, 0x0F, 0xFF, 0x0F, 0xF0, 0xFE,
  0x0F, 0xFF, 0x1F, 0xE0, 0xFE, 0x1F, 0xFF, 0x3F, 0xE0, 0xFE, 0x3F, 0xFF,
  0x7F, 0xC0, 0xFE, 0xFF, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xDF, 0xFF, 0x80,
  0xFF, 0xFF, 0x9F, 0xFF, 0x80, 0x7F, 0xFF, 0x0F, 0xFF, 0x00, 0x7F, 0xFE,
  0x0F, 0xFE, 0x00, 0x3F, 0xFC, 0x07, 0xFE, 0x00, 0x3F, 0xF0, 0x03, 0xFC,
  0x00, 0x1F, 0xE0, 0x03, 0xF8, 0x00, 0x07, 0x00, 0x01, 0xF0, 0x00, 0x06,
  0x00, 0x00, 0x00, 0x78, 0x00, 0x1C, 0x0F, 0xC0, 0x07, 0xE0, 0xFE, 0x00,
  0xFE, 0x0F, 0xF0, 0x3F, 0xF0, 0xFF, 0x87, 0xFE, 0x07, 0xFC, 0xFF, 0xE0,
  0x7F, 0xFF, 0xFC, 0x03, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xE0, 0x00, 0xFF,
  0xF8, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x0F, 0xF8, 0x00,
  0x03, 0xFF, 0xC0, 0x00, 0x3F, 0xFC, 0x00, 0x07, 0xFF, 0xE0, 0x00, 0xFF,
  0xFF, 0x00, 0x1F, 0xFF, 0xF0, 0x03, 0xFE, 0x7F, 0x80, 0x7F, 0xC3, 0xFC,
  0x07, 0xF8, 0x1F, 0xC0, 0x7F, 0x01, 0xFC, 0x07, 0xE0, 0x0F, 0xE0, 0xFE,
  0x00, 0xFE, 0x0F, 0xC0, 0x07, 0xC0, 0x7C, 0x00, 0x7C, 0x07, 0x80, 0x03,
  0x80, 0x38, 0x00, 0x00, 0x00, 0x40, 0x00, 0x63, 0xC0, 0x07, 0x8F, 0xC0,
  0x3F, 0xBF, 0x01, 0xFE, 0xFE, 0x0F, 0xFD, 0xF8, 0x7F, 0xE7, 0xE1, 0xFF,
  0x1F, 0x8F, 0xF8, 0x7E, 0x7F, 0xC1, 0xFD, 0xFE, 0x07, 0xFF, 0xF8, 0x1F,
  0xFF, 0x80, 0x3F, 0xFE, 0x00, 0xFF, 0xF0, 0x01, 0xFF, 0x80, 0x07, 0xFE,
  0x00, 0x0F, 0xF8, 0x00, 0x3F, 0xC0, 0x01, 0xFE, 0x00, 0x07, 0xF8, 0x00,
  0x3F, 0xC0, 0x00, 0xFE, 0x00, 0x07, 0xF8, 0x00, 0x1F, 0xC0, 0x00, 0xFF,
  0x00, 0x03, 0xF8, 0x00, 0x0F, 0xE0, 0x00, 0x3F, 0x00, 0x00, 0xFC, 0x00,
  0x01, 0xE0, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xF8, 0x0F,
  0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFE, 0x03, 0xFF, 0xFF,
  0xC0, 0x7F, 0xBF, 0xF0, 0x00, 0x0F, 0xFE, 0x00, 0x03, 0xFF, 0x00, 0x00,
  0xFF, 0xC0, 0x00, 0x3F, 0xF0, 0x00, 0x1F, 0xFC, 0x00, 0x07, 0xFF, 0x00,
  0x03, 0xFF, 0xC0, 0x00, 0xFF, 0xE0, 0x00, 0x3F, 0xF8, 0x00, 0x1F, 0xFE,
  0x00, 0x07, 0xFF, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x7F, 0xE0, 0x04, 0x0F,
  0xF8, 0x07, 0xE1, 0xFE, 0x07, 0xFE, 0x3F, 0xEF, 0xFF, 0xC7, 0xFF, 0xFF,
  0xF8, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0x80, 0x1F,
  0xFD, 0x80, 0x01, 0xFF, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x07,
  0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0xFC, 0x00, 0xFF, 0xFF,
  0xF0, 0x07, 0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0x00, 0x03, 0xF0, 0x00, 0x00,
  0x1F, 0x80, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x3E,
  0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0xFC, 0x00,
  0x00, 0x0F, 0xC0, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00,
  0x1F, 0x80, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x7E,
  0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x01, 0xF8, 0x00,
  0x00, 0x0F, 0xC0, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00,
  0x3F, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0xFC,
  0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x03, 0xF0, 0x00,
  0x00, 0x1F, 0x80, 0x00, 0x01, 0xFF, 0xFE, 0x00, 0x0F, 0xFF, 0xFC, 0x00,
  0x7F, 0xFF, 0xE0, 0x03, 0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xE0, 0x00, 0x7E,
  0x00, 0x00, 0x00, 0x40, 0x78, 0x3E, 0x1F, 0x87, 0xC3, 0xE1, 0xF0, 0xF8,
  0x7C, 0x3E, 0x0F, 0x07, 0xC3, 0xE1, 0xF0, 0xF8, 0x3C, 0x1E, 0x0F, 0x87,
  0xC3, 0xE1, 0xF0, 0x78, 0x3E, 0x1E, 0x0F, 0x87, 0xC3, 0xE1, 0xF0, 0xF8,
  0x38, 0x00, 0x0F, 0xFF, 0x80, 0x07, 0xFF, 0xF8, 0x01, 0xFF, 0xFF, 0x80,
  0x3F, 0xFF, 0xF0, 0x03, 0xFF, 0xFE, 0x00, 0x7F, 0xBF, 0xC0, 0x04, 0x01,
  0xF0, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x01, 0xF8, 0x00,
  0x00, 0x3F, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x3F,
  0x00, 0x00, 0x07, 0xE0, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x3F, 0x00, 0x00,
  0x07, 0xE0, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x07, 0xE0,
  0x00, 0x00, 0xFC, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00,
  0xFC, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x07, 0xF0, 0x00, 0x00, 0xFC, 0x00,
  0x00, 0x1F, 0x80, 0x00, 0x03, 0xF0, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x1F,
  0x80, 0x00, 0x03, 0xF0, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x1F, 0x80, 0x07,
  0xFF, 0xF0, 0x0F, 0xFF, 0xFC, 0x01, 0xFF, 0xFF, 0x80, 0x3F, 0xFF, 0xF0,
  0x03, 0xFF, 0xF8, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x07,
  0x80, 0x01, 0xF0, 0x00, 0xFC, 0x00, 0x7F, 0x00, 0x1F, 0xC0, 0x07, 0xF8,
  0x03, 0xFE, 0x01, 0xFF, 0x80, 0x7F, 0xE0, 0x3F, 0xF8, 0x1F, 0xBF, 0x0F,
  0xCF, 0xC3, 0xF3, 0xF1, 0xF8, 0xFC, 0xFE, 0x1F, 0x7F, 0x07, 0xDF, 0x81,
  0xFF, 0xC0, 0x7F, 0xF0, 0x0F, 0xF8, 0x01, 0xDC, 0x00, 0x60, 0x00, 0xFF,
  0xFE, 0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF,
  0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFC, 0x00, 0x30, 0x03,
  0x80, 0x7E, 0x0F, 0xF0, 0xFF, 0x87, 0xFC, 0x1F, 0xC0, 0xFE, 0x07, 0xF0,
  0x3F, 0x01, 0xE0, 0x06, 0x00, 0x07, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x1F,
  0xC0, 0x00, 0x3F, 0xC0, 0x01, 0xFF, 0xC0, 0x01, 0xFF, 0xC0, 0x03, 0xFF,
  0xC0, 0x03, 0xFF, 0xE0, 0x07, 0xFF, 0xE0, 0x07, 0xF3, 0xE0, 0x0F, 0xE3,
  0xE0, 0x0F, 0xC3, 0xF8, 0x0F, 0xC3, 0xFE, 0x1F, 0xFF, 0xFF, 0x1F, 0xFF,
  0xFE, 0x3F, 0xFF, 0xFC, 0x3F, 0xFF, 0xF8, 0x7E, 0x7F, 0xF8, 0x7E, 0x00,
  0xF8, 0xFC, 0x01, 0xF8, 0xFC, 0x07, 0xF8, 0x7C, 0x01, 0xF0, 0x78, 0x01,
  0xE0, 0x00, 0x00, 0x80, 0x00, 0x06, 0x00, 0x0F, 0xFF, 0x01, 0xFF, 0xFE,
  0x1F, 0xFF, 0xFC, 0xFF, 0xFF, 0xFB, 0xFF, 0x87, 0xE7, 0xF0, 0x3F, 0x9F,
  0xE1, 0xFE, 0x1B, 0xDF, 0xF0, 0x0F, 0xFF, 0x80, 0x7F, 0xFC, 0x01, 0xFF,
  0xE0, 0x07, 0xFF, 0xC0, 0x1F, 0xFF, 0xC0, 0xFF, 0x0F, 0x83, 0xF0, 0x1E,
  0x0F, 0x80, 0xFC, 0x7E, 0x07, 0xF1, 0xF8, 0x7F, 0xC7, 0xCF, 0xFE, 0x3F,
  0xFF, 0xF8, 0xFF, 0xFF, 0x81, 0xFF, 0xF8, 0x07, 0xFF, 0x80, 0x0C, 0xF0,
  0x00, 0x00, 0x03, 0x80, 0x01, 0xF8, 0x00, 0xFF, 0x80, 0x7F, 0xF0, 0x3F,
  0xFE, 0x0F, 0xFF, 0x83, 0xFF, 0xE0, 0xFF, 0xE0, 0x3F, 0xF0, 0x0F, 0xF8,
  0x03, 0xFC, 0x00, 0x7F, 0x00, 0x0F, 0xC0, 0x01, 0xF0, 0x00, 0x3E, 0x00,
  0x07, 0xC0, 0x00, 0x78, 0x00, 0x0F, 0xF8, 0x01, 0xFF, 0xFE, 0x1F, 0xFF,
  0xE1, 0xFF, 0xFC, 0x1F, 0xFF, 0x80, 0x7F, 0xE0, 0x70, 0x00, 0x1F, 0x80,
  0x07, 0xFC, 0x00, 0xFF, 0x80, 0x7F, 0xF0, 0x1F, 0xFF, 0x07, 0x9F, 0xE1,
  0xE0, 0xFC, 0x38, 0x1F, 0x0F, 0x03, 0xE3, 0xC0, 0x38, 0xF0, 0x0F, 0x7C,
  0x07, 0xDF, 0x03, 0xF7, 0x83, 0xFB, 0xE3, 0xFE, 0xFF, 0xFF, 0x3F, 0xFF,
  0x8F, 0xFF, 0x83, 0xFF, 0x80, 0xFF, 0xC0, 0x3F, 0x80, 0x07, 0x80, 0x00,
  0x80, 0x00, 0x00, 0x07, 0xF0, 0x07, 0xFF, 0xC3, 0xFF, 0xFE, 0x3F, 0xFF,
  0xF3, 0xFF, 0xFF, 0x0F, 0xFF, 0x80, 0x7F, 0xE0, 0x03, 0xF0, 0x00, 0x0F,
  0x82, 0x00, 0x7F, 0xF8, 0x07, 0xFF, 0xE0, 0x3F, 0xFF, 0x83, 0xFF, 0xF8,
  0x1F, 0xFF, 0x01, 0xF8, 0x00, 0x0F, 0xC0, 0x00, 0xFC, 0x00, 0x07, 0xE0,
  0x3E, 0x1F, 0xFF, 0xF8, 0xFF, 0xFF, 0xE7, 0xFF, 0xFE, 0x3F, 0xFF, 0xE0,
  0xFF, 0xF8, 0x00, 0x40, 0x00, 0x00, 0x00, 0x78, 0x00, 0x0F, 0xFC, 0x00,
  0x7F, 0xFE, 0x03, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0x1F, 0xFF, 0xC0, 0x1F,
  0xF8, 0x00, 0x1F, 0xE0, 0x00, 0x0F, 0xE0, 0x00, 0x07, 0xE0, 0x00, 0x07,
  0xC0, 0x00, 0x07, 0xC0, 0x40, 0x7F, 0xFF, 0x80, 0xFF, 0xFF, 0xE0, 0xFF,
  0xFF, 0xC0, 0xFF, 0xFF, 0xC0, 0x7F, 0xFE, 0x00, 0x3F, 0xC0, 0x00, 0x3E,
  0x00, 0x00, 0x3E, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x3C,
  0x00, 0x00, 0x1C, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x01, 0xC0, 0x00,
  0x00, 0xFE, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x1F, 0xF8, 0x00, 0x0F, 0xFF,
  0x00, 0x03, 0xFF, 0xC0, 0x00, 0xFF, 0xE0, 0x00, 0x3F, 0xF0, 0x00, 0x0F,
  0xF8, 0x00, 0x03, 0xFE, 0x04, 0x00, 0xFF, 0x83, 0xE0, 0x1F, 0xC0, 0xFF,
  0x07, 0xF0, 0x0F, 0xF8, 0xFC, 0x01, 0xFF, 0xBF, 0x80, 0x1F, 0xFF, 0xE0,
  0x01, 0xFF, 0xF8, 0x03, 0xFF, 0xFF, 0xB7, 0xFF, 0xF9, 0xFF, 0xFF, 0xFE,
  0x3F, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0x00, 0x07, 0xFC,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x10, 0x01, 0x80, 0xC0, 0x07, 0x03, 0x80,
  0x3C, 0x1F, 0x00, 0x78, 0x7C, 0x03, 0xF1, 0xF8, 0x0F, 0xC7, 0xE0, 0x3F,
  0x1F, 0x00, 0xFC, 0x7C, 0x03, 0xF1, 0xF0, 0x0F, 0xCF, 0xC0, 0x7F, 0x3F,
  0x03, 0xF8, 0xFD, 0xFF, 0xE7, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE, 0x7F, 0xFF,
  0xF1, 0xFF, 0xFF, 0xCF, 0xFE, 0x3E, 0x3F, 0xE1, 0xF8, 0xFE, 0x07, 0xF3,
  0xF8, 0x1F, 0x8F, 0xC0, 0x3E, 0x1F, 0x00, 0x70, 0x30, 0x00, 0x00, 0x0E,
  0x0F, 0x07, 0x83, 0xE1, 0xF1, 0xFC, 0xFC, 0x7E, 0x3F, 0x3F, 0x1F, 0x8F,
  0xC7, 0xC7, 0xE3, 0xF1, 0xF8, 0xFC, 0x7E, 0x3F, 0x0F, 0x87, 0xC3, 0xE0,
  0xF0, 0x00, 0x00, 0x0F, 0xFF, 0x81, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF,
  0x0F, 0xFF, 0xFF, 0xF1, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xC0, 0x03, 0x80,
  0xF8, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0xFC, 0x00,
  0x00, 0x1F, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x1F,
  0x80, 0x00, 0x03, 0xE0, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x1F, 0x80, 0x0F,
  0x07, 0xE0, 0x03, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0x00, 0x07, 0xFF, 0xC0,
  0x00, 0xFF, 0xF0, 0x00, 0x05, 0xFC, 0x00, 0x00, 0x01, 0xC0, 0x00, 0x00,
  0xF8, 0x03, 0x00, 0x3F, 0x03, 0xE0, 0x1F, 0xC1, 0xFC, 0x07, 0xE1, 0xFF,
  0x81, 0xF8, 0xFF, 0xC0, 0xFC, 0x7F, 0xE0, 0x3F, 0x7F, 0xF0, 0x1F, 0xFF,
  0xF0, 0x07, 0xFF, 0xF0, 0x01, 0xFF, 0xF8, 0x00, 0xFF, 0xFC, 0x00, 0x3F,
  0xFE, 0x00, 0x0F, 0xFF, 0x80, 0x07, 0xFF, 0xE0, 0x01, 0xFF, 0xFE, 0x00,
  0x7F, 0xDF, 0xFF, 0x9F, 0xE3, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFC, 0x0F,
  0xFF, 0x7E, 0x00, 0x7F, 0x9F, 0x00, 0x07, 0x83, 0x80, 0x00, 0x00, 0x40,
  0x00, 0x00, 0x02, 0x00, 0x00, 0x3C, 0x00, 0x07, 0xE0, 0x00, 0x7E, 0x00,
  0x07, 0xE0, 0x00, 0xFE, 0x00, 0x0F, 0xC0, 0x00, 0xFC, 0x00, 0x1F, 0x80,
  0x01, 0xF8, 0x00, 0x1F, 0x80, 0x03, 0xF0, 0x00, 0x3F, 0x00, 0x03, 0xF0,
  0x00, 0x7E, 0x00, 0x07, 0xE0, 0x00, 0x7E, 0x00, 0x0F, 0xC0, 0x00, 0xFF,
  0xFF, 0x8F, 0xFF, 0xFE, 0x7F, 0xFF, 0xF7, 0xFF, 0xFF, 0x3F, 0xFF, 0xF3,
  0xFC, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0xF0, 0x00,
  0x30, 0x00, 0xFC, 0x00, 0x78, 0x01, 0xFC, 0x00, 0x7C, 0x03, 0xFE, 0x00,
  0xFE, 0x03, 0xFE, 0x01, 0xFE, 0x07, 0xFE, 0x07, 0xFF, 0x07, 0xFE, 0x0F,
  0xFE, 0x0F, 0xFE, 0x1F, 0xFE, 0x0F, 0xFF, 0x7F, 0xFC, 0x1F, 0xFF, 0xFF,
  0xFC, 0x1F, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0x7C, 0x3F, 0xFF, 0xFC,
  0xFC, 0x3F, 0x3F, 0xF8, 0xFC, 0x7F, 0x1F, 0xE0, 0xFC, 0x7F, 0x0F, 0x80,
  0xFC, 0xFE, 0x00, 0x00, 0xFC, 0xFE, 0x00, 0x01, 0xF8, 0xFC, 0x00, 0x01,
  0xF8, 0xFC, 0x00, 0x01, 0xF8, 0xF8, 0x00, 0x00, 0xF0, 0x78, 0x00, 0x00,
  0xF0, 0x70, 0x00, 0x00, 0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x00, 0xE0, 0x18, 0x00, 0xF0, 0x1E, 0x01, 0xF8, 0x3E, 0x01, 0xFC, 0x3F,
  0x03, 0xFC, 0x3F, 0x03, 0xFC, 0x7E, 0x03, 0xF8, 0x7E, 0x07, 0xF8, 0x7E,
  0x07, 0xF8, 0x7C, 0x0F, 0xF8, 0x7C, 0x0F, 0xF8, 0xFC, 0x1F, 0xF8, 0xFC,
  0x1F, 0xF9, 0xFC, 0x3F, 0xF9, 0xFC, 0x3F, 0xFB, 0xF8, 0x7F, 0xFF, 0xF8,
  0x7F, 0x7F, 0xF8, 0xFF, 0x7F, 0xF0, 0x7E, 0x3F, 0xF0, 0x7E, 0x1F, 0xE0,
  0x3C, 0x0F, 0xC0, 0x3C, 0x07, 0x80, 0x1C, 0x02, 0x00, 0x00, 0x03, 0x80,
  0x00, 0x0F, 0x00, 0x00, 0x3F, 0x00, 0x00, 0xFF, 0x00, 0x07, 0xFE, 0x00,
  0x1F, 0xFC, 0x00, 0x7F, 0xF8, 0x01, 0xFF, 0xF8, 0x07, 0xFF, 0xF0, 0x1F,
  0xE1, 0xF0, 0x7F, 0x83, 0xE0, 0xFE, 0x03, 0xE3, 0xF8, 0x07, 0xCF, 0xE0,
  0x07, 0x9F, 0x80, 0x0F, 0xBE, 0x00, 0x1F, 0xFC, 0x00, 0x7F, 0xF8, 0x03,
  0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0x8F, 0xFF, 0xFE,
  0x0F, 0xFF, 0xF0, 0x0F, 0xFF, 0x00, 0x00, 0x40, 0x00, 0x00, 0x1C, 0x00,
  0x07, 0xFC, 0x00, 0xFF, 0xF8, 0x0F, 0xFF, 0xC0, 0x7F, 0xFF, 0x07, 0xFF,
  0xF8, 0x3F, 0xFF, 0xC1, 0xF0, 0x3E, 0x1F, 0x01, 0xF9, 0xF8, 0x7F, 0xDF,
  0xFF, 0xFC, 0xFF, 0xFF, 0xEF, 0xFF, 0xFE, 0x7F, 0xFF, 0xE3, 0xFF, 0xFC,
  0x0F, 0xFF, 0x00, 0x7F, 0x00, 0x03, 0xE0, 0x00, 0x1F, 0x00, 0x01, 0xF8,
  0x00, 0x0F, 0xC0, 0x00, 0x7E, 0x00, 0x03, 0xF0, 0x00, 0x0F, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x3F, 0x80,
  0x00, 0xFF, 0x80, 0x01, 0xFF, 0x00, 0x0F, 0xFE, 0x00, 0x3F, 0xFE, 0x00,
  0xFF, 0xFE, 0x03, 0xFC, 0x7C, 0x1F, 0xF0, 0x7C, 0x7F, 0xC0, 0xF9, 0xFE,
  0x00, 0xF7, 0xF9, 0x81, 0xEF, 0xE3, 0xE7, 0xFF, 0x87, 0xDF, 0xFE, 0x07,
  0xFF, 0xFC, 0x07, 0xFF, 0xF0, 0x0F, 0xFB, 0xE1, 0xFF, 0xE7, 0xFF, 0xFF,
  0x8F, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0x1F, 0xFF, 0xBE, 0x0F, 0xF8, 0x3E,
  0x06, 0x00, 0x7C, 0x00, 0x00, 0x70, 0x00, 0x08, 0x00, 0x01, 0xE0, 0x00,
  0x1F, 0x80, 0x01, 0xFF, 0x00, 0x1F, 0xF8, 0x00, 0xFF, 0xE0, 0x0F, 0xFF,
  0x03, 0xFD, 0xFC, 0x1F, 0xC7, 0xE0, 0xFC, 0x1F, 0x0F, 0xE3, 0xF8, 0x7E,
  0xFF, 0xC3, 0xFF, 0xFC, 0x1F, 0xFF, 0xC1, 0xFF, 0xFC, 0x0F, 0xFF, 0x80,
  0x7F, 0xE0, 0x03, 0xFF, 0x00, 0x1F, 0xFE, 0x00, 0xFF, 0xFE, 0x0F, 0xDF,
  0xFF, 0x3E, 0x7F, 0xFD, 0xE1, 0xFF, 0xE7, 0x01, 0xFF, 0x00, 0x03, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x03, 0xFF, 0xE0,
  0x3F, 0xFF, 0xE1, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0x9F, 0xFE, 0x02, 0x3F,
  0xE0, 0x00, 0xFF, 0xE0, 0x01, 0xFF, 0xF0, 0x01, 0xFF, 0xF0, 0x01, 0xFF,
  0xE0, 0x00, 0x1F, 0xE0, 0x00, 0x03, 0xE0, 0x00, 0x03, 0xC0, 0x00, 0x07,
  0x80, 0x00, 0x1F, 0x00, 0x00, 0xFE, 0x00, 0x07, 0xF8, 0x01, 0xFF, 0xF0,
  0x03, 0xFF, 0xC0, 0x07, 0xFF, 0x00, 0x0F, 0xF8, 0x00, 0x1F, 0xC0, 0x00,
  0x1C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x1F, 0xFF, 0xBF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0xFF, 0xF8,
  0x00, 0x78, 0xF8, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x7E,
  0x00, 0x00, 0x3F, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x0F,
  0x80, 0x00, 0x0F, 0xC0, 0x00, 0x07, 0xE0, 0x00, 0x03, 0xE0, 0x00, 0x01,
  0xF0, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x78, 0x00, 0x00, 0x3C, 0x00, 0x00,
  0x1F, 0x80, 0x00, 0x07, 0xC0, 0x00, 0x01, 0xC0, 0x00, 0x00, 0x00, 0x00,
  0x70, 0x00, 0x01, 0xC2, 0x00, 0x07, 0x9C, 0x00, 0x1E, 0x78, 0x00, 0x79,
  0xE0, 0x03, 0xF7, 0xC0, 0x0F, 0xDF, 0x00, 0x3E, 0xFC, 0x01, 0xFB, 0xF0,
  0x07, 0xEF, 0xC0, 0x3F, 0xBF, 0x00, 0xFC, 0xF8, 0x07, 0xF3, 0xE0, 0x3F,
  0x8F, 0xC3, 0xFE, 0x3F, 0x3F, 0xF0, 0xFF, 0xFF, 0x01, 0xFF, 0xFC, 0x07,
  0xFF, 0xE0, 0x1F, 0xFF, 0x00, 0x3F, 0xF8, 0x00, 0xFF, 0x80, 0x00, 0xF8,
  0x00, 0x00, 0x00, 0x01, 0x18, 0x00, 0x3B, 0x80, 0x0F, 0x78, 0x03, 0xFF,
  0x00, 0xFF, 0xF0, 0x3F, 0xBE, 0x0F, 0xF7, 0xC1, 0xFC, 0xF8, 0x7F, 0x1F,
  0x1F, 0xC3, 0xE3, 0xF8, 0x7E, 0xFE, 0x0F, 0xDF, 0x81, 0xFF, 0xE0, 0x3F,
  0xFC, 0x07, 0xFF, 0x00, 0x7F, 0xE0, 0x0F, 0xF8, 0x01, 0xFE, 0x00, 0x3F,
  0xC0, 0x07, 0xF0, 0x00, 0x7E, 0x00, 0x0F, 0x80, 0x00, 0xF0, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x00, 0x00, 0x03, 0x03, 0xC0,
  0x00, 0x03, 0xC1, 0xF0, 0x0C, 0x01, 0xE1, 0xF8, 0x0F, 0x01, 0xF8, 0xFC,
  0x07, 0xC0, 0xFC, 0xFE, 0x07, 0xE0, 0x7E, 0x7E, 0x07, 0xF0, 0x7E, 0x3F,
  0x03, 0xF8, 0x3F, 0x1F, 0x83, 0xFC, 0x3F, 0x9F, 0x83, 0xFC, 0x1F, 0x8F,
  0xC1, 0xFE, 0x1F, 0xC7, 0xE1, 0xFF, 0x0F, 0xC3, 0xE0, 0xFF, 0x87, 0xE3,
  0xF0, 0xFF, 0xC7, 0xE1, 0xF8, 0xFF, 0xE7, 0xF0, 0xFC, 0xFF, 0xF7, 0xF8,
  0x7F, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0x3F, 0xF8, 0x1F, 0xFF, 0x1F, 0xFC,
  0x07, 0xFF, 0x07, 0xFC, 0x03, 0xFF, 0x01, 0xFC, 0x00, 0xFF, 0x00, 0xFC,
  0x00, 0x1E, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x0C, 0x00,
  0x08, 0x1E, 0x00, 0x78, 0x3E, 0x01, 0xF8, 0x7E, 0x07, 0xF1, 0xFE, 0x3F,
  0xE1, 0xFE, 0xFF, 0x83, 0xFF, 0xFE, 0x03, 0xFF, 0xF0, 0x03, 0xFF, 0xC0,
  0x03, 0xFF, 0x00, 0x07, 0xF8, 0x00, 0x1F, 0xE0, 0x00, 0x7F, 0xE0, 0x01,
  0xFF, 0xE0, 0x07, 0xFF, 0xC0, 0x1F, 0xEF, 0xC0, 0x3F, 0x9F, 0xC0, 0xFE,
  0x1F, 0x81, 0xF8, 0x1F, 0x83, 0xE0, 0x3F, 0x0F, 0x80, 0x3E, 0x0F, 0x00,
  0x7C, 0x1E, 0x00, 0x70, 0x18, 0x00, 0x40, 0x00, 0x03, 0x3C, 0x03, 0xCF,
  0x80, 0xFF, 0xE0, 0x7F, 0xFC, 0x3F, 0xBF, 0x1F, 0xE7, 0xCF, 0xE1, 0xF3,
  0xF8, 0x7D, 0xFC, 0x1F, 0xFE, 0x07, 0xFF, 0x00, 0xFF, 0xC0, 0x3F, 0xE0,
  0x07, 0xF0, 0x01, 0xFC, 0x00, 0x7E, 0x00, 0x3F, 0x80, 0x0F, 0xC0, 0x07,
  0xE0, 0x01, 0xF8, 0x00, 0xFC, 0x00, 0x3F, 0x00, 0x0F, 0x80, 0x03, 0xE0,
  0x00, 0x70, 0x00, 0x00, 0x03, 0xFF, 0xFC, 0x03, 0xFF, 0xFC, 0x03, 0xFF,
  0xFE, 0x03, 0xFF, 0xFF, 0x03, 0xFF, 0xFE, 0x01, 0xC3, 0xFE, 0x00, 0x03,
  0xFC, 0x00, 0x0F, 0xF8, 0x00, 0x1F, 0xE0, 0x00, 0x3F, 0xC0, 0x00, 0xFF,
  0x80, 0x03, 0xFF, 0x00, 0x07, 0xFE, 0x00, 0x0F, 0xF8, 0x00, 0x3F, 0xF0,
  0x00, 0x7F, 0xC0, 0x00, 0x7F, 0x80, 0x60, 0x7F, 0x07, 0xF8, 0x7F, 0x3F,
  0xF8, 0x7F, 0xFF, 0xF8, 0x7F, 0xFF, 0xF0, 0x7F, 0xFF, 0xC0, 0x3F, 0xFE,
  0x00, 0x1F, 0xE0, 0x00, 0x04, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xF0, 0x00,
  0xFF, 0xFF, 0xE0, 0x03, 0xFF, 0xFF, 0xC0, 0x0F, 0xFF, 0xFF, 0x00, 0x3F,
  0xFF, 0xFC, 0x00, 0xFF, 0xFE, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x0F, 0x80,
  0x00, 0x00, 0x3E, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x07, 0xE0, 0x00,
  0x00, 0x1F, 0x80, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00,
  0x3F, 0xC0, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x7F, 0xF8, 0x00, 0x03, 0xFF,
  0xC0, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x01, 0xFF, 0x00, 0x00, 0x03, 0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00,
  0x00, 0x0F, 0xE0, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x7E, 0x00, 0x00,
  0x03, 0xF8, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x01,
  0xFC, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x7E,
  0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0xF0, 0x00, 0x7F, 0xFF,
  0xE0, 0x01, 0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xFE, 0x00, 0x0F, 0xFF, 0xF0,
  0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x20, 0x03, 0x80, 0x1C, 0x01, 0xE0,
  0x0F, 0x80, 0x7C, 0x07, 0xE0, 0x3E, 0x03, 0xF0, 0x1F, 0x00, 0xF8, 0x07,
  0xC0, 0x7C, 0x03, 0xE0, 0x1F, 0x01, 0xF0, 0x0F, 0x80, 0x7C, 0x07, 0xC0,
  0x3E, 0x01, 0xF0, 0x1F, 0x00, 0xF8, 0x0F, 0xC0, 0x7C, 0x07, 0xE0, 0x3E,
  0x01, 0xF0, 0x0F, 0x80, 0x10, 0x00, 0x00, 0x1F, 0xFF, 0x80, 0x03, 0xFF,
  0xFE, 0x00, 0x1F, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFC,
  0x00, 0x1F, 0xCF, 0xE0, 0x00, 0x40, 0x3F, 0x00, 0x00, 0x01, 0xF8, 0x00,
  0x00, 0x0F, 0xC0, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00,
  0x3F, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0xFC,
  0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x03, 0xFE, 0x00,
  0x00, 0x1F, 0xF8, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x03, 0xFC, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0xFF,
  0xF0, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x7F, 0x80, 0x00, 0x03, 0xF0, 0x00,
  0x00, 0x3F, 0x80, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00,
  0xFE, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x01, 0xF8,
  0x00, 0x3F, 0xFF, 0x80, 0x0F, 0xFF, 0xFC, 0x00, 0x7F, 0xFF, 0xE0, 0x03,
  0xFF, 0xFE, 0x00, 0x1F, 0xFF, 0xE0, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0x87, 0xC7, 0xFE, 0x3E, 0x7F, 0xFB, 0xE7, 0xFF, 0xFF,
  0x3E, 0x7F, 0xF3, 0xE1, 0xFF, 0x08, 0x03, 0xE0 };

const GFXglyph PermanentMarker_Regular20pt7bGlyphs[] PROGMEM = {
  {     0,   1,   1,  14,    0,    0 },   // 0x20 ' '
  {     1,  11,  30,  10,    0,  -28 },   // 0x21 '!'
  {    43,  18,  19,  19,    3,  -28 },   // 0x22 '"'
  {    86,  27,  28,  27,    1,  -27 },   // 0x23 '#'
  {   181,  21,  30,  19,    1,  -28 },   // 0x24 '$'
  {   260,  24,  28,  25,    2,  -27 },   // 0x25 '%'
  {   344,  23,  21,  23,    0,  -21 },   // 0x26 '&'
  {   405,   9,  19,  10,    3,  -28 },   // 0x27 '''
  {   427,  17,  40,  14,    1,  -32 },   // 0x28 '('
  {   512,  18,  40,  14,   -5,  -32 },   // 0x29 ')'
  {   602,  25,  20,  26,    3,  -28 },   // 0x2A '*'
  {   665,  21,  20,  23,    0,  -20 },   // 0x2B '+'
  {   718,  10,  13,   8,   -5,   -5 },   // 0x2C ','
  {   735,  20,   6,  24,    1,  -12 },   // 0x2D '-'
  {   750,   7,   7,   9,   -1,   -5 },   // 0x2E '.'
  {   757,  20,  29,  16,   -1,  -27 },   // 0x2F '/'
  {   830,  25,  31,  27,    0,  -29 },   // 0x30 '0'
  {   927,  10,  29,  13,    1,  -28 },   // 0x31 '1'
  {   964,  26,  28,  25,    2,  -27 },   // 0x32 '2'
  {  1055,  22,  28,  22,    0,  -27 },   // 0x33 '3'
  {  1132,  20,  30,  23,    2,  -28 },   // 0x34 '4'
  {  1207,  24,  28,  23,    2,  -27 },   // 0x35 '5'
  {  1291,  19,  29,  20,   -1,  -27 },   // 0x36 '6'
  {  1360,  24,  28,  22,    0,  -27 },   // 0x37 '7'
  {  1444,  21,  28,  21,    2,  -27 },   // 0x38 '8'
  {  1518,  20,  30,  21,    1,  -28 },   // 0x39 '9'
  {  1593,   9,  18,   9,   -1,  -16 },   // 0x3A ':'
  {  1614,  11,  24,  10,   -3,  -16 },   // 0x3B ';'
  {  1647,  24,  18,  24,    0,  -18 },   // 0x3C '<'
  {  1701,  22,  13,  23,    0,  -16 },   // 0x3D '='
  {  1737,  25,  18,  25,   -2,  -18 },   // 0x3E '>'
  {  1794,  22,  30,  22,    2,  -28 },   // 0x3F '?'
  {  1877,  28,  30,  29,    0,  -28 },   // 0x40 '@'
  {  1982,  29,  28,  27,   -1,  -27 },   // 0x41 'A'
  {  2084,  27,  30,  27,   -1,  -28 },   // 0x42 'B'
  {  2186,  23,  28,  24,    0,  -27 },   // 0x43 'C'
  {  2267,  21,  28,  23,    1,  -27 },   // 0x44 'D'
  {  2341,  25,  28,  24,    0,  -27 },   // 0x45 'E'
  {  2429,  29,  29,  22,   -1,  -28 },   // 0x46 'F'
  {  2535,  32,  28,  31,    0,  -27 },   // 0x47 'G'
  {  2647,  26,  30,  27,    0,  -28 },   // 0x48 'H'
  {  2745,  26,  28,  20,   -1,  -27 },   // 0x49 'I'
  {  2836,  32,  28,  26,   -1,  -27 },   // 0x4A 'J'
  {  2948,  31,  29,  30,    0,  -27 },   // 0x4B 'K'
  {  3061,  24,  28,  25,    0,  -27 },   // 0x4C 'L'
  {  3145,  38,  30,  38,    0,  -28 },   // 0x4D 'M'
  {  3288,  29,  28,  27,   -1,  -27 },   // 0x4E 'N'
  {  3390,  28,  30,  29,    0,  -28 },   // 0x4F 'O'
  {  3495,  25,  30,  25,    1,  -28 },   // 0x50 'P'
  {  3589,  28,  31,  29,    0,  -28 },   // 0x51 'Q'
  {  3698,  25,  31,  25,    0,  -28 },   // 0x52 'R'
  {  3795,  27,  29,  22,    0,  -28 },   // 0x53 'S'
  {  3893,  30,  29,  24,    0,  -27 },   // 0x54 'T'
  {  4002,  26,  28,  27,    2,  -27 },   // 0x55 'U'
  {  4093,  23,  28,  23,    3,  -27 },   // 0x56 'V'
  {  4174,  40,  29,  39,    1,  -28 },   // 0x57 'W'
  {  4319,  28,  29,  24,   -1,  -27 },   // 0x58 'X'
  {  4421,  22,  30,  19,    2,  -28 },   // 0x59 'Y'
  {  4504,  27,  30,  26,    0,  -27 },   // 0x5A 'Z'
  {  4606,  29,  41,  15,   -1,  -34 },   // 0x5B '['
  {  4755,   9,  30,  14,    2,  -28 },   // 0x5C '\'
  {  4789,  27,  41,  16,  -11,  -34 },   // 0x5D ']'
  {  4928,  18,  22,  20,    0,  -28 },   // 0x5E '^'
  {  4978,  32,   6,  28,   -4,   -4 },   // 0x5F '_'
  {  5002,  12,  12,  29,   11,  -28 },   // 0x60 '`'
  {  5020,  24,  24,  23,   -1,  -22 },   // 0x61 'a'
  {  5092,  22,  25,  22,   -1,  -23 },   // 0x62 'b'
  {  5161,  19,  23,  20,    0,  -22 },   // 0x63 'c'
  {  5216,  18,  24,  19,    1,  -22 },   // 0x64 'd'
  {  5270,  21,  24,  20,    0,  -22 },   // 0x65 'e'
  {  5333,  24,  25,  18,   -1,  -23 },   // 0x66 'f'
  {  5408,  27,  23,  25,    0,  -22 },   // 0x67 'g'
  {  5486,  22,  25,  23,    0,  -23 },   // 0x68 'h'
  {  5555,   9,  24,  13,    2,  -22 },   // 0x69 'i'
  {  5582,  27,  23,  21,   -1,  -22 },   // 0x6A 'j'
  {  5660,  26,  24,  25,    0,  -22 },   // 0x6B 'k'
  {  5738,  20,  25,  21,    0,  -23 },   // 0x6C 'l'
  {  5801,  32,  25,  32,    0,  -23 },   // 0x6D 'm'
  {  5901,  24,  24,  22,   -1,  -23 },   // 0x6E 'n'
  {  5973,  23,  25,  25,    0,  -23 },   // 0x6F 'o'
  {  6045,  21,  25,  20,    1,  -23 },   // 0x70 'p'
  {  6111,  23,  26,  24,    0,  -23 },   // 0x71 'q'
  {  6186,  21,  26,  21,    0,  -23 },   // 0x72 'r'
  {  6255,  23,  25,  18,    0,  -23 },   // 0x73 's'
  {  6327,  25,  25,  19,    0,  -23 },   // 0x74 't'
  {  6406,  22,  23,  23,    2,  -22 },   // 0x75 'u'
  {  6470,  19,  25,  19,    3,  -23 },   // 0x76 'v'
  {  6530,  33,  25,  32,    1,  -23 },   // 0x77 'w'
  {  6634,  23,  24,  20,   -1,  -22 },   // 0x78 'x'
  {  6703,  18,  25,  16,    2,  -23 },   // 0x79 'y'
  {  6760,  24,  25,  21,   -1,  -22 },   // 0x7A 'z'
  {  6835,  30,  41,  17,    1,  -34 },   // 0x7B '{'
  {  6989,  13,  30,  13,    0,  -28 },   // 0x7C '|'
  {  7038,  29,  41,  19,  -11,  -34 },   // 0x7D '}'
  {  7187,  21,   8,  23,    0,  -15 } }; // 0x7E '~'

const GFXfont PermanentMarker_Regular20pt7b PROGMEM = {
  (uint8_t  *)PermanentMarker_Regular20pt7bBitmaps,
  (GFXglyph *)PermanentMarker_Regular20pt7bGlyphs,
  0x20, 0x7E, 57 };

// Approx. 7880 bytes
