/* This example renders a png or Jpeg file to be stored in a FLASH array

 Image files can be converted to arrays using the tool here:
 https://javl.github.io/image2cpp/

 To use this tool:
  1. Click "Choose Files" button to select file to convert...
  2. Section 2 allows you to modifiy image settings and preview changes in section 3.
  3. Set "Canvas size(s)" to desired image size. 
  4. Final image width >>> MUST BE DIVISABLE BY 8 <<<. Width is the left number of image size.
  5. >>> NOTE: Some images/printers may require "Invert image colors" to be clicked to print as desired. <<<
  6. In section 4, Set "Code Output" to "Plain Bytes". This will prepare the bytes to be pasted in the array below.
  7. Click "Generate Code".
  8. Click "Copy Output"
  9. Paste output inside the image array brackets below (replace existing bytes).
  10. Make sure "#define TESTIMAGE_WIDTH & HEIGHT" are set to final image sizes.
  11. Final image array must alway be defined "static const uint8_t testImage[] PROGMEM  = {....};"

  >> FYI, TESTIMAGE settings were: Invert:yes, Dithering:Atkinson, Brightness / alpha threshold: 128 <<
*/

#define TESTIMAGE_WIDTH 240
#define TESTIMAGE_HEIGHT 240

// array size is 7200
static const uint8_t testImage[] PROGMEM  = {
0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf8, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x07, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xc2, 0x6f, 0x80, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 
0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x01, 0x06, 0xf0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 
0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc2, 0x60, 0x41, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x07, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xc0, 
0x00, 0x00, 0x00, 0x00, 0x07, 0x01, 0x03, 0x01, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 
0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 
0x00, 0x00, 0x1c, 0x41, 0x00, 0x00, 0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 
0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 
0x70, 0x00, 0x40, 0x01, 0xe1, 0xf0, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 
0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 
0x02, 0x21, 0xf9, 0xfc, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 
0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x03, 0x03, 0x86, 0xc0, 0x21, 
0xd8, 0xfe, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x03, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x06, 0xa7, 0x87, 0xd0, 0x01, 0xe4, 0xff, 
0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x0c, 0x8f, 0x0d, 0x60, 0x10, 0xf0, 0x1f, 0x80, 0x00, 
0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xf0, 0x00, 0x00, 0x19, 0x1e, 0x1f, 0xf0, 0x40, 0x30, 0x6f, 0xe0, 0x00, 0x00, 0x7f, 
0xff, 0xff, 0xc0, 0x7f, 0xff, 0xff, 0x80, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xf8, 0x00, 0x00, 0x30, 0x0c, 0x3b, 0xf0, 0x03, 0x60, 0x77, 0xe0, 0x00, 0x00, 0xff, 0xff, 0xff, 
0x80, 0x3f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 
0x00, 0x60, 0x00, 0x3f, 0xf0, 0x02, 0x54, 0x7f, 0xf0, 0x00, 0x01, 0xff, 0xff, 0xff, 0x80, 0x3f, 
0xff, 0xff, 0xe0, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0xcc, 
0x00, 0x2f, 0xf0, 0x04, 0x90, 0x3b, 0xf8, 0x00, 0x03, 0xff, 0xff, 0xff, 0x80, 0x3f, 0xff, 0xff, 
0xf0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x01, 0x90, 0x60, 0x1f, 
0xe0, 0x09, 0x48, 0x8f, 0xfc, 0x00, 0x03, 0xff, 0xff, 0xff, 0x80, 0x3f, 0xff, 0xff, 0xf8, 0x00, 
0x00, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0xff, 0x00, 0x01, 0x64, 0xc0, 0x1f, 0xc0, 0x0a, 
0x00, 0x17, 0xfe, 0x00, 0x07, 0xff, 0xff, 0xff, 0x80, 0x3f, 0xff, 0xff, 0xfc, 0x00, 0x01, 0xff, 
0xff, 0xff, 0xff, 0xf0, 0x3f, 0xff, 0xff, 0x80, 0x03, 0x00, 0xa0, 0x07, 0x00, 0x44, 0x13, 0x5b, 
0xfe, 0x00, 0x0f, 0xff, 0xff, 0xff, 0x80, 0x1f, 0xff, 0xff, 0xfc, 0x00, 0x03, 0xff, 0xff, 0xff, 
0xff, 0xe0, 0x1f, 0xff, 0xff, 0xc0, 0x06, 0x0c, 0x00, 0x00, 0x00, 0x10, 0xa2, 0xa7, 0xff, 0x00, 
0x0f, 0xff, 0xff, 0xfe, 0x00, 0x01, 0xff, 0xff, 0xfe, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xc0, 
0x1f, 0xff, 0xff, 0xc0, 0x0c, 0x84, 0x01, 0x00, 0x00, 0x01, 0x21, 0x53, 0xff, 0x80, 0x1f, 0xff, 
0xff, 0xf8, 0x00, 0x00, 0x3f, 0xff, 0xff, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0x80, 0x3f, 0xff, 
0xff, 0xe0, 0x0a, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa6, 0xff, 0x80, 0x3f, 0xff, 0xff, 0xe0, 
0x00, 0x00, 0x0f, 0xff, 0xff, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x3f, 0xff, 0xff, 0xe0, 
0x19, 0x00, 0x03, 0xfc, 0x32, 0x21, 0xfe, 0x07, 0xff, 0xc0, 0x3f, 0xff, 0xff, 0x80, 0x00, 0x00, 
0x07, 0xff, 0xff, 0x80, 0x0f, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x7f, 0xff, 0xff, 0xf0, 0x14, 0x80, 
0x0f, 0xff, 0x08, 0x2e, 0xff, 0xc3, 0xff, 0xc0, 0x7f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x07, 0xff, 
0xff, 0x80, 0x1f, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x7f, 0xff, 0xff, 0xf0, 0x30, 0x48, 0x38, 0xff, 
0x88, 0x97, 0xf9, 0xfc, 0xff, 0xe0, 0x7f, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xc0, 
0x1f, 0xff, 0xff, 0xff, 0xf8, 0x00, 0xff, 0xff, 0xff, 0xf8, 0x20, 0x24, 0x67, 0x3f, 0x40, 0x3f, 
0xf6, 0x7d, 0xff, 0xe0, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xc0, 0x1f, 0xff, 
0xff, 0xff, 0xf0, 0x00, 0xff, 0xff, 0xff, 0xf8, 0x60, 0x01, 0x83, 0xff, 0xe3, 0x1f, 0xff, 0x2f, 
0xfb, 0xf0, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0xff, 0xff, 
0xe0, 0x01, 0xff, 0xff, 0xff, 0xfc, 0x58, 0x00, 0x18, 0xdf, 0xf0, 0x3f, 0xf9, 0xc7, 0xfb, 0xf0, 
0xff, 0xff, 0xf8, 0x00, 0x1f, 0xc0, 0x1f, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0xff, 0xff, 0xc0, 0x01, 
0xff, 0xff, 0xff, 0xfc, 0x45, 0xc4, 0x4c, 0x0f, 0xe0, 0x7f, 0xc0, 0x75, 0xff, 0xf9, 0xff, 0xff, 
0xf8, 0x00, 0x7f, 0xfc, 0x3f, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 
0xff, 0xfc, 0xc3, 0xc2, 0xb0, 0x3b, 0xf0, 0x7f, 0xc0, 0x3f, 0xfd, 0xf9, 0xff, 0xff, 0xf8, 0x00, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0x80, 0x01, 0xff, 0xff, 0xff, 0xfe, 
0x83, 0xca, 0xe7, 0xf7, 0xe0, 0x7f, 0x3f, 0xb5, 0xfd, 0xf9, 0xff, 0xff, 0xf8, 0x00, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xf0, 0x7f, 0xff, 0x80, 0x7f, 0x00, 0x00, 0x00, 0x07, 0xff, 0xfe, 0x87, 0xc3, 
0xcf, 0xff, 0xe8, 0xfe, 0xf7, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xf0, 0x7f, 0xff, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x01, 0xff, 0xfe, 0xc3, 0xc1, 0xbc, 0xfd, 
0xe0, 0x3f, 0xf7, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf0, 
0x7f, 0xff, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x83, 0x87, 0xf7, 0xff, 0xd0, 0x7f, 
0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 
0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x93, 0x1f, 0xfb, 0x6f, 0xf8, 0x7f, 0x99, 0x7f, 
0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x80, 0x3f, 
0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x40, 0x01, 0x0d, 0xe7, 0xc0, 0x7e, 0x3f, 0x3f, 0xff, 0xff, 
0xff, 0xff, 0xfc, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x00, 0x3f, 0x00, 0x00, 
0x00, 0x00, 0x7f, 0xff, 0x00, 0x0d, 0x00, 0x1f, 0xd0, 0x3f, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xfc, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 
0x7f, 0xff, 0x00, 0x00, 0x93, 0xff, 0xb8, 0x7f, 0xff, 0x7d, 0x7f, 0xff, 0xff, 0xff, 0xfe, 0x00, 
0x00, 0x07, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 
0x04, 0x00, 0x06, 0x3e, 0x28, 0xff, 0x91, 0x74, 0x3f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 
0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x90, 0x00, 
0x08, 0x95, 0x40, 0x3a, 0x91, 0xa0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x7f, 0xff, 
0xff, 0xf8, 0xff, 0xff, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x80, 0x3c, 0x00, 0x10, 
0x30, 0x7d, 0x60, 0x03, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf8, 
0xff, 0xff, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x60, 0xf6, 0x00, 0x00, 0x88, 0x7b, 
0x00, 0x09, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0xff, 0xff, 
0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x10, 0xfd, 0x00, 0x00, 0x68, 0x7c, 0x80, 0x02, 
0x5d, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x00, 0x3f, 
0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xc1, 0xfe, 0x80, 0x00, 0x60, 0x7c, 0x00, 0x0a, 0x7d, 0xdf, 
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x07, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x80, 0x3f, 0x00, 0x00, 
0x00, 0x01, 0xff, 0xff, 0x49, 0xff, 0x80, 0x05, 0xc0, 0x3c, 0x07, 0x0b, 0x6f, 0xf7, 0xff, 0xff, 
0xff, 0xff, 0xe0, 0x00, 0x07, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x01, 
0xff, 0xff, 0x53, 0xff, 0x48, 0x13, 0x88, 0x07, 0x0e, 0xa9, 0xed, 0xef, 0xff, 0xff, 0xff, 0xff, 
0xfc, 0x00, 0x03, 0xff, 0xff, 0xf8, 0xff, 0xff, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 
0x93, 0xff, 0x40, 0x1b, 0x08, 0x6b, 0x86, 0x15, 0xbf, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 
0x03, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0x88, 0xff, 
0x83, 0xe6, 0x7f, 0xdd, 0xe2, 0x16, 0xbe, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x03, 0xff, 
0xff, 0xf8, 0x7f, 0xff, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0x81, 0xbf, 0x88, 0x3f, 
0xff, 0xfd, 0xe0, 0x6b, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x01, 0xff, 0xff, 0xf8, 
0x7f, 0xff, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x03, 0xff, 0xfe, 0x81, 0xbf, 0x00, 0x8f, 0xff, 0xff, 
0xdf, 0xb5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x01, 0xff, 0xff, 0xf0, 0x7f, 0xff, 
0x80, 0x3f, 0x00, 0x00, 0x00, 0x03, 0xff, 0xfe, 0xf9, 0x6f, 0x87, 0xec, 0xff, 0xff, 0xf3, 0xdf, 
0xff, 0x49, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x01, 0xff, 0xff, 0xf0, 0x7f, 0xff, 0x00, 0x3f, 
0x00, 0x00, 0x00, 0x07, 0xff, 0xfe, 0xe4, 0xc2, 0x18, 0x78, 0x1f, 0xff, 0xec, 0x6d, 0xdf, 0xd9, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x01, 0xff, 0xff, 0xf0, 0x3f, 0xff, 0x00, 0x3f, 0x00, 0x00, 
0x00, 0x07, 0xff, 0xfc, 0xf6, 0x21, 0x23, 0x30, 0x07, 0xff, 0xf9, 0xb7, 0xff, 0xe9, 0xff, 0xff, 
0xfe, 0x3f, 0xff, 0xe0, 0x03, 0xff, 0xff, 0xf0, 0x3f, 0xff, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x07, 
0xff, 0xfc, 0x78, 0x02, 0x0f, 0x9c, 0x07, 0x3b, 0x37, 0xbb, 0xff, 0xb9, 0xff, 0xff, 0xfc, 0x0f, 
0xff, 0x80, 0x03, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xfc, 
0x7f, 0x00, 0x58, 0xfa, 0x02, 0x1b, 0xff, 0xff, 0xff, 0x90, 0xff, 0xff, 0xf8, 0x00, 0x7c, 0x00, 
0x03, 0xff, 0xff, 0xe0, 0x1f, 0xff, 0x00, 0x3f, 0x80, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x7f, 0x00, 
0x37, 0xfc, 0x3f, 0xf6, 0xff, 0xff, 0xfe, 0xf0, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x07, 0xff, 
0xff, 0xe0, 0x1f, 0xff, 0x80, 0x3f, 0xc0, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x3b, 0xc1, 0x8f, 0xfc, 
0xff, 0xfc, 0xff, 0xff, 0xff, 0x20, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xc0, 
0x1f, 0xff, 0x80, 0x3f, 0xe0, 0x00, 0x00, 0x1f, 0xff, 0xf0, 0x3f, 0xb2, 0x6b, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xa0, 0x7f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xc0, 0x0f, 0xff, 
0x80, 0x7f, 0xf8, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x1f, 0xe4, 0xb6, 0xf3, 0x87, 0x8f, 0x7f, 0xff, 
0xff, 0x60, 0x7f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0x80, 0x0f, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x1f, 0xb3, 0x6a, 0x80, 0x00, 0x0c, 0x26, 0xff, 0xf7, 0x40, 
0x3f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0x80, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xe0, 0x0f, 0xf8, 0x9d, 0x00, 0x3e, 0xf2, 0x1d, 0x5e, 0xfc, 0xc0, 0x3f, 0xff, 
0xfc, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xc0, 0x0f, 0xfb, 0x6b, 0x00, 0xc0, 0x18, 0x8a, 0xff, 0xbb, 0x80, 0x1f, 0xff, 0xff, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 
0x07, 0xf9, 0xa6, 0x80, 0x3f, 0xfd, 0xd7, 0xff, 0xf9, 0x00, 0x0f, 0xff, 0xff, 0xe0, 0x00, 0x1f, 
0xff, 0xff, 0xfe, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x03, 0xfd, 
0x54, 0x00, 0x3f, 0xf7, 0x3b, 0xff, 0xf7, 0x00, 0x0f, 0xff, 0xff, 0xff, 0x00, 0x3f, 0xff, 0xff, 
0xfc, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x03, 0xfe, 0xb9, 0x04, 
0x0f, 0xf3, 0xb7, 0x7f, 0xe6, 0x00, 0x07, 0xff, 0xff, 0xff, 0x80, 0x3f, 0xff, 0xff, 0xfc, 0x00, 
0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x01, 0xff, 0xd2, 0x2b, 0x00, 0x5b, 
0x6f, 0xff, 0xdc, 0x00, 0x03, 0xff, 0xff, 0xff, 0x00, 0x3f, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x7f, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0xff, 0xe0, 0x50, 0x41, 0x0c, 0xed, 0xfd, 
0xd8, 0x00, 0x03, 0xff, 0xff, 0xff, 0x80, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x3f, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x7f, 0xf8, 0x94, 0x81, 0x67, 0x9f, 0xbf, 0xd0, 0x00, 
0x01, 0xff, 0xff, 0xff, 0x80, 0x3f, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xf8, 0x00, 0x00, 0x3f, 0xf5, 0x4b, 0x0b, 0xf7, 0x7f, 0xf7, 0x30, 0x00, 0x00, 0xff, 
0xff, 0xff, 0x80, 0x3f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xf0, 0x00, 0x00, 0x1f, 0xff, 0xfa, 0x10, 0x39, 0xb7, 0x7d, 0xc0, 0x00, 0x00, 0x7f, 0xff, 0xff, 
0x80, 0x7f, 0xff, 0xff, 0x80, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 
0x00, 0x0f, 0xfe, 0xa6, 0xf4, 0x8e, 0xfe, 0xfd, 0x80, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x07, 
0xf7, 0xed, 0x8f, 0xae, 0xfb, 0xf3, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 
0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x03, 0xff, 0xd9, 
0xba, 0xfb, 0xff, 0xf6, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 
0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xf3, 0x7f, 0xb7, 
0x3f, 0x5c, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 
0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0xc9, 0x75, 0xff, 0x70, 
0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 
0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xbf, 0xfe, 0xdf, 0xf9, 0xc0, 0x00, 0x00, 
0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 
0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xef, 0x67, 0xff, 0xf7, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x1f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xfb, 0xf7, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 
0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x7f, 0xbf, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 
0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x07, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xff, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x7f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x00, 0x08, 
0x80, 0x02, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xfe, 0xfd, 0xbf, 0x20, 0x00, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x26, 0x44, 0x01, 0x89, 0x18, 0x10, 0x00, 
0x00, 0x91, 0x20, 0x82, 0x41, 0x24, 0x25, 0x07, 0xcf, 0xf7, 0xf4, 0xcf, 0x01, 0x00, 0x80, 0x08, 
0x00, 0x00, 0x00, 0x12, 0x01, 0x02, 0x02, 0x10, 0x91, 0x30, 0x4a, 0x46, 0x59, 0x99, 0x24, 0x10, 
0x04, 0x20, 0x14, 0x91, 0x93, 0x66, 0xdf, 0xfd, 0x96, 0x7f, 0x10, 0x04, 0x00, 0x00, 0x40, 0x00, 
0x00, 0x80, 0x90, 0x10, 0x80, 0x00, 0x08, 0xdc, 0x42, 0x48, 0x89, 0x24, 0x81, 0x09, 0x91, 0x09, 
0x04, 0x00, 0x12, 0x7e, 0x7f, 0x7e, 0xfb, 0xb7, 0x00, 0x00, 0x02, 0x10, 0x00, 0x90, 0x10, 0x00, 
0x02, 0x44, 0x24, 0x49, 0x02, 0x15, 0x36, 0x80, 0x24, 0x4c, 0x08, 0x62, 0x01, 0x18, 0x49, 0x48, 
0x40, 0x99, 0xbf, 0xdb, 0x6d, 0xbf, 0x00, 0x40, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x20, 0x01, 
0x01, 0x04, 0x40, 0x04, 0x8c, 0xb3, 0x04, 0x41, 0x02, 0x04, 0x24, 0x84, 0x19, 0x42, 0x4c, 0x23, 
0xf7, 0xf7, 0xf5, 0xfb, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x08, 0x04, 
0x99, 0xa2, 0x00, 0x48, 0x77, 0x30, 0x10, 0x10, 0x08, 0x64, 0x86, 0x22, 0x25, 0x6b, 0x5f, 0xf6, 
0xde, 0x6f, 0x10, 0x06, 0x00, 0x00, 0x40, 0x00, 0x02, 0x10, 0x98, 0x40, 0x80, 0x00, 0x04, 0xcc, 
0x91, 0x00, 0x01, 0x8c, 0x00, 0x88, 0xcb, 0x12, 0x20, 0x88, 0xb1, 0x13, 0xdf, 0xff, 0xfb, 0xbf, 
0x04, 0x00, 0x88, 0x00, 0x00, 0x02, 0x20, 0x00, 0x04, 0x18, 0x81, 0x10, 0x00, 0x4d, 0x99, 0x96, 
0x98, 0x41, 0x20, 0x24, 0x24, 0xc2, 0x08, 0x48, 0x8c, 0x94, 0xf9, 0xef, 0xff, 0xb7, 0x00, 0x20, 
0x00, 0x00, 0x04, 0x60, 0x00, 0x00, 0x00, 0x80, 0x31, 0x96, 0x62, 0x02, 0x62, 0x10, 0x86, 0x5b, 
0x01, 0x01, 0x10, 0x20, 0xca, 0x33, 0x27, 0xa4, 0x7f, 0xfb, 0xf7, 0xff, 0x20, 0x24, 0xc0, 0x00, 
0x00, 0x00, 0x00, 0x04, 0x42, 0x00, 0x00, 0x00, 0x1a, 0x62, 0x00, 0x01, 0x01, 0xac, 0x80, 0x51, 
0x16, 0x30, 0x20, 0x04, 0x4c, 0x6f, 0x97, 0x1e, 0xff, 0xdb, 0x01, 0x04, 0x00, 0x00, 0xc0, 0x00, 
0x00, 0x11, 0x10, 0x00, 0x40, 0x41, 0x09, 0x3f, 0xb2, 0x48, 0x58, 0xa4, 0x22, 0x44, 0x41, 0x8c, 
0x91, 0x12, 0x73, 0x49, 0xf5, 0xff, 0xbe, 0xff, 0x04, 0x00, 0x08, 0x00, 0x00, 0x00, 0x44, 0x00, 
0x11, 0x21, 0x02, 0x08, 0x04, 0x04, 0x9a, 0x4e, 0x46, 0xfd, 0x08, 0x00, 0x48, 0x02, 0x48, 0x99, 
0xb0, 0x6c, 0x6c, 0xff, 0xf7, 0xff, 0x02, 0x20, 0x80, 0x00, 0x00, 0x04, 0x00, 0x00, 0x01, 0x31, 
0x09, 0x93, 0xb0, 0xc0, 0x81, 0x23, 0x01, 0x48, 0x41, 0xa2, 0x26, 0xf3, 0x00, 0x84, 0x8f, 0x8f, 
0x9b, 0xff, 0xf7, 0xef, 0x10, 0x20, 0x80, 0x08, 0x00, 0x10, 0x00, 0x40, 0x40, 0x04, 0x98, 0x90, 
0x8a, 0x39, 0x00, 0x00, 0x24, 0x4a, 0x00, 0x20, 0x82, 0x19, 0xa4, 0x42, 0xdf, 0xf3, 0xf3, 0x7d, 
0xbf, 0x7f, 0x10, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x84, 0x02, 0x04, 0x48, 0x09, 
0xda, 0xdc, 0x93, 0xfd, 0x80, 0x08, 0x10, 0x86, 0xe3, 0x33, 0x36, 0x7c, 0x6f, 0x6f, 0xed, 0xff, 
0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x0a, 0x18, 0x80, 0x00, 0x40, 0x26, 0x45, 0x22, 0x93, 0x32, 
0x00, 0x10, 0x05, 0x92, 0xcc, 0xe6, 0x10, 0x34, 0x8d, 0xbf, 0xcd, 0xef, 0xf7, 0xf7, 0x01, 0x04, 
0x00, 0x00, 0x00, 0x00, 0x2e, 0xed, 0xda, 0x69, 0x01, 0x31, 0x13, 0x68, 0x90, 0x20, 0x09, 0x1e, 
0x40, 0x10, 0xa2, 0x38, 0x04, 0x0e, 0xe9, 0xe7, 0xf3, 0xf7, 0x3f, 0x9f, 0x18, 0x10, 0x00, 0x00, 
0x02, 0x03, 0x26, 0xcf, 0x4f, 0x99, 0x99, 0x89, 0x00, 0x4e, 0xec, 0xcc, 0xc7, 0xfb, 0x00, 0xc7, 
0x22, 0x4e, 0xc9, 0xa3, 0x3e, 0x5e, 0x7e, 0x3d, 0xee, 0xfb, 0x10, 0x20, 0x00, 0x00, 0x00, 0x09, 
0x58, 0x7b, 0xbf, 0x9e, 0x08, 0x88, 0x24, 0x90, 0x23, 0x30, 0x00, 0xc0, 0x03, 0x33, 0x5f, 0xf2, 
0x20, 0x7f, 0x07, 0xbb, 0xff, 0xf3, 0xf7, 0xfb, 0x10, 0x00, 0x00, 0x00, 0x00, 0x90, 0x5b, 0xff, 
0xff, 0xff, 0x64, 0x24, 0x90, 0x03, 0x20, 0x02, 0x13, 0x08, 0x00, 0x40, 0xcc, 0xbf, 0x04, 0x01, 
0xf0, 0xef, 0xff, 0xfe, 0xf7, 0xdd, 0x41, 0x01, 0x00, 0x00, 0x00, 0xf6, 0x8f, 0xb7, 0xed, 0xff, 
0xff, 0x97, 0x93, 0x64, 0xd0, 0x99, 0x83, 0xff, 0x00, 0x4d, 0xa7, 0xef, 0x76, 0xbe, 0x3f, 0xff, 
0xff, 0xfe, 0xdc, 0xfd, 0x81, 0x00, 0x00, 0x80, 0x16, 0x4f, 0xb6, 0xff, 0xdf, 0x6d, 0xdb, 0xdb, 
0x2c, 0x15, 0x9b, 0xe4, 0x20, 0x04, 0x09, 0x9b, 0x7f, 0x79, 0x32, 0x13, 0xcf, 0x3f, 0xff, 0xb7, 
0xf7, 0x76, 0x04, 0x08, 0x00, 0x02, 0x17, 0xd9, 0xff, 0xdf, 0xf7, 0xff, 0xfe, 0x7d, 0xe0, 0x20, 
0x00, 0x00, 0x0b, 0x64, 0x80, 0x03, 0x7b, 0xf2, 0x01, 0x5c, 0x71, 0xef, 0xf9, 0xff, 0xe3, 0xdb, 
0x0c, 0x08, 0x18, 0x00, 0x20, 0xc2, 0x7f, 0xff, 0x6f, 0xff, 0xff, 0xf9, 0x9b, 0x66, 0xed, 0x98, 
0xc1, 0xff, 0x20, 0x6d, 0xcf, 0xfe, 0xed, 0xef, 0x3d, 0xff, 0xff, 0xff, 0xfe, 0xff, 0x00, 0x00, 
0x10, 0x10, 0x7f, 0x19, 0x9e, 0xfb, 0xcd, 0xff, 0xbf, 0xff, 0xb6, 0x49, 0x3f, 0xe4, 0x05, 0x10, 
0x01, 0x9f, 0xff, 0xe4, 0x88, 0x33, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x60, 0x01, 0x00, 0x12, 
0x16, 0x73, 0x3b, 0xcf, 0xbf, 0xff, 0xff, 0xff, 0xed, 0xe9, 0x5a, 0x20, 0x13, 0x7b, 0x80, 0x07, 
0xfb, 0xff, 0xf3, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x3d, 0xc0, 0xc0, 0x01, 0x00, 0xc0, 0xcc, 
0x6f, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x36, 0x73, 0xc0, 0xc0, 0x4a, 0x80, 0xfc, 0xef, 0xdb, 
0xbf, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x03, 0x24, 0x39, 0x3d, 0xfc, 0xf3, 
0x9f, 0xff, 0xff, 0xff, 0xef, 0x76, 0x67, 0x86, 0x37, 0x42, 0x08, 0x0f, 0xff, 0xff, 0x8d, 0x6c, 
0xff, 0xff, 0xff, 0xff, 0xfe, 0xee, 0x04, 0x0c, 0x00, 0x06, 0x47, 0x27, 0xf7, 0x9e, 0x7f, 0xff, 
0xff, 0xff, 0xfe, 0xcd, 0xfd, 0xc0, 0x01, 0x3f, 0xc0, 0xb3, 0xfb, 0xce, 0x7f, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xb7, 0x0c, 0x00, 0x30, 0x11, 0x98, 0xed, 0xfc, 0xf3, 0xff, 0xff, 0xff, 0xff, 
0xff, 0x99, 0x9b, 0x11, 0x61, 0x01, 0x80, 0x97, 0xfe, 0xfb, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x7f, 
0xff, 0xdd, 0x00, 0x00, 0x06, 0x32, 0x79, 0x9f, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x77, 
0xfe, 0xc9, 0x3e, 0xc6, 0x24, 0x4d, 0xbf, 0xff, 0xe7, 0xbf, 0xff, 0x7b, 0xf3, 0xff, 0xfe, 0xfd, 
0x60, 0x60, 0x08, 0x8c, 0xe6, 0xfc, 0xf7, 0xff, 0xff, 0xde, 0xdf, 0xff, 0xe6, 0x44, 0x66, 0x00, 
0x40, 0x1f, 0xc1, 0x3f, 0xed, 0xff, 0xfd, 0xfb, 0xff, 0xcf, 0x9f, 0xfd, 0xff, 0xff, 0x40, 0x01, 
0x11, 0x27, 0x9b, 0xb7, 0xbf, 0xf7, 0xff, 0xfb, 0xd9, 0xfd, 0xff, 0xff, 0xfd, 0x24, 0xd3, 0x01, 
0xc0, 0x22, 0x7f, 0xff, 0xff, 0xff, 0xf3, 0xfd, 0xfd, 0xf7, 0xff, 0xfb, 0x00, 0x02, 0x06, 0xc3, 
0x7a, 0xf4, 0xff, 0xde, 0xfe, 0x7e, 0x7f, 0x37, 0xd9, 0x33, 0x90, 0x04, 0x34, 0x33, 0xc9, 0x3f, 
0xff, 0xff, 0xff, 0xff, 0xdf, 0x7e, 0xdf, 0x3f, 0xff, 0xdf, 0x06, 0x08, 0x20, 0x1c, 0xff, 0xb7, 
0xff, 0xf7, 0xdf, 0x9b, 0xc7, 0xe6, 0x7f, 0xf3, 0x74, 0x10, 0x00, 0x06, 0xc3, 0x70, 0xff, 0xff, 
0xfb, 0xef, 0x7f, 0xe7, 0xcf, 0xff, 0x7f, 0xf7, 0x00, 0x19, 0x30, 0x4f, 0xdd, 0xff, 0x7f, 0xfe, 
0x56, 0xe2, 0x78, 0xdf, 0x64, 0xce, 0xc1, 0x73, 0xe2, 0x49, 0x80, 0x1f, 0xf7, 0xfd, 0xff, 0x7b, 
0xff, 0xbd, 0xf9, 0xf7, 0xff, 0xff, 0x10, 0x10, 0x02, 0xc7, 0x66, 0x7f, 0x71, 0xf3, 0x9d, 0xfe, 
0x6f, 0x99, 0xbc, 0xcc, 0xe0, 0x00, 0x00, 0x6f, 0x9b, 0x79, 0xff, 0x9f, 0xf7, 0xde, 0xfb, 0x7e, 
0xff, 0xbf, 0xdf, 0xfd, 0x20, 0xc0, 0xc2, 0x77, 0x3e, 0xed, 0xd9, 0xbc, 0xff, 0x9f, 0xe4, 0xfb, 
0x03, 0x3f, 0x2e, 0x99, 0x00, 0x06, 0x81, 0xaf, 0xff, 0xfb, 0x3f, 0xff, 0xfb, 0xe7, 0xcf, 0x9e, 
0x7f, 0xfd, 0x00, 0x81, 0x0c, 0x38, 0xe3, 0xe7, 0x0f, 0x0f, 0xff, 0xff, 0xfd, 0xc7, 0xff, 0x32, 
0x00, 0x20, 0x01, 0x1f, 0x80, 0x2b, 0x3f, 0xbb, 0xef, 0xff, 0xfe, 0x7f, 0xf9, 0xf3, 0xfb, 0xff, 
0x00, 0x04, 0x39, 0xdb, 0x1f, 0x38, 0xfa, 0xff, 0xff, 0xff, 0xbf, 0x6c, 0xcd, 0xef, 0x9c, 0x80, 
0x89, 0x89, 0x36, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xf7, 0xfc, 0xff, 0xfb, 0xdf, 0xff, 0x06, 0x0c, 
0x03, 0x8e, 0x76, 0xdf, 0xaf, 0xff, 0xbf, 0xfb, 0x27, 0x3d, 0x88, 0x88, 0x00, 0x90, 0x00, 0x3e, 
0x10, 0x06, 0xff, 0xe7, 0xff, 0xff, 0x7f, 0x67, 0xcf, 0x5e, 0xff, 0xfc, 0x0c, 0xb0, 0xc4, 0xf9, 
0x8d, 0xcd, 0x9d, 0xff, 0xf9, 0x4f, 0xfc, 0xe6, 0x7f, 0xfb, 0x62, 0x00, 0x00, 0x66, 0x6d, 0x37, 
0xff, 0x3f, 0xdf, 0xff, 0xc6, 0x7e, 0xfb, 0xfe, 0x7b, 0xff, 0x00, 0x25, 0xb8, 0xcf, 0x38, 0x79, 
0xef, 0x7d, 0xff, 0xfd, 0x37, 0xbe, 0x66, 0x24, 0x18, 0x00, 0x23, 0x1a, 0x0e, 0xff, 0xdf, 0xfc, 
0xfd, 0xe4, 0xff, 0xce, 0xfb, 0xf3, 0xef, 0xdf, 0x30, 0x80, 0x2f, 0x79, 0x77, 0x8f, 0x7f, 0xcf, 
0xf6, 0xff, 0xf6, 0xf1, 0xfe, 0xcc, 0x00, 0x43, 0x20, 0x6e, 0x92, 0x4e, 0xff, 0xf7, 0xbf, 0x6f, 
0xfd, 0xff, 0x8f, 0x3f, 0xef, 0x7d, 0x61, 0x86, 0xc4, 0x61, 0xe6, 0xf9, 0xf4, 0x00, 0x4b, 0x9b, 
0xfc, 0xf7, 0x11, 0xd9, 0xe8, 0x10, 0x00, 0x08, 0x5b, 0x77, 0xff, 0xfd, 0xff, 0x7f, 0xff, 0xf9, 
0xff, 0xdf, 0xfe, 0x7f, 0x00, 0x0e, 0x1d, 0x8e, 0x3c, 0xdf, 0xe0, 0x10, 0x20, 0x3e, 0x7b, 0x9d, 
0xb3, 0x30, 0x00, 0x80, 0x06, 0x42, 0x09, 0xff, 0xdf, 0xef, 0xfb, 0xff, 0xff, 0xff, 0xf9, 0xe6, 
0x73, 0xff, 0x06, 0x10, 0xe7, 0x9b, 0xe7, 0xdf, 0x0b, 0x36, 0xb7, 0x67, 0xce, 0x66, 0xcf, 0xed, 
0x44, 0x80, 0x60, 0x0f, 0xa2, 0x0f, 0xff, 0x7f, 0xdf, 0xff, 0xcd, 0x98, 0x7f, 0x77, 0xdf, 0xcf, 
0x0c, 0x21, 0xac, 0x72, 0x7c, 0xf8, 0x18, 0x08, 0x90, 0x09, 0x39, 0xf3, 0xbc, 0x80, 0x03, 0x00, 
0x40, 0x10, 0x6e, 0xbf, 0xfb, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0x6f, 0xfd, 0xde, 0x7f, 0x18, 0x47, 
0x31, 0x8e, 0xcf, 0xe1, 0x80, 0xd9, 0x0d, 0xeb, 0x65, 0xce, 0xb7, 0xba, 0x04, 0x1c, 0x01, 0x00, 
0x04, 0xbd, 0xdf, 0xcf, 0xff, 0xff, 0x3b, 0x43, 0xe7, 0xee, 0x7b, 0x7b, 0x30, 0xc6, 0x47, 0x93, 
0xef, 0x9c, 0x16, 0x00, 0x00, 0x1d, 0xcf, 0x3a, 0xce, 0x43, 0x04, 0x10, 0x07, 0x30, 0xb7, 0x0f, 
0xff, 0x7b, 0xff, 0xfd, 0xff, 0xfe, 0x3f, 0xfb, 0xf9, 0xdf, 0x60, 0x19, 0xac, 0x7c, 0x3e, 0x20, 
0x80, 0x01, 0xb7, 0x86, 0xb9, 0xeb, 0xfb, 0xb0, 0x11, 0x60, 0x00, 0x03, 0xb9, 0xff, 0xfb, 0xef, 
0xff, 0xf9, 0xa4, 0x33, 0xe7, 0xff, 0x9f, 0xef, 0x02, 0x32, 0x21, 0x97, 0xfe, 0x41, 0x00, 0x60, 
0x00, 0xf9, 0xcd, 0x6e, 0xf3, 0x24, 0x20, 0x80, 0x60, 0x00, 0x0e, 0x1e, 0xff, 0x7b, 0xef, 0xdf, 
0xbb, 0xe1, 0x63, 0x7c, 0xfe, 0x7f, 0x04, 0x66, 0xc6, 0xb3, 0xfd, 0x4c, 0x10, 0x01, 0x2c, 0x07, 
0x76, 0x33, 0xce, 0xd0, 0xc2, 0x00, 0x80, 0x00, 0x09, 0xe7, 0xff, 0xfe, 0xfe, 0xf2, 0x00, 0x0f, 
0x1e, 0xff, 0xf3, 0xff, 0x00, 0x48, 0x80, 0x8e, 0xb0, 0x30, 0x20, 0x08, 0x01, 0xf2, 0x5b, 0xef, 
0x3b, 0x92, 0x42, 0x06, 0x01, 0xce, 0x4d, 0x3f, 0xdf, 0xdb, 0xdf, 0x90, 0xf9, 0x88, 0xd6, 0x6f, 
0x35, 0xcf, 0x11, 0x39, 0x29, 0x1b, 0xfa, 0xa1, 0x80, 0x26, 0xd8, 0x1e, 0x71, 0xac, 0xff, 0xe1, 
0x04, 0x0c, 0x01, 0x00, 0x61, 0xce, 0xfe, 0x7b, 0xfc, 0x26, 0x12, 0xf0, 0x7b, 0x3f, 0xbf, 0x7d, 
0x01, 0x66, 0x06, 0x76, 0xe1, 0x80, 0x01, 0xff, 0xff, 0xc1, 0x9e, 0x7b, 0xdd, 0x83, 0x08, 0x30, 
0x18, 0x11, 0x0c, 0xbb, 0xfb, 0xcf, 0xb9, 0xa0, 0x02, 0x1f, 0x4d, 0xdf, 0xee, 0x79, 0xc8, 0x58, 
0xc8, 0xcf, 0xc6, 0x48, 0x0f, 0xff, 0xff, 0xf0, 0xe6, 0xef, 0x73, 0xf0, 0x90, 0x60, 0x20, 0x00, 
0x03, 0x1f, 0xdf, 0x7f, 0xe6, 0x08, 0xc9, 0x03, 0xc7, 0x77, 0xe7, 0xef, 0x09, 0x02, 0x63, 0x36, 
0x9c, 0x00, 0x7f, 0xff, 0xff, 0xbe, 0x1f, 0xfc, 0xee, 0xc4, 0x24, 0x41, 0x02, 0x01, 0xc8, 0x66, 
0xff, 0xff, 0xf0, 0x5f, 0x6d, 0xd2, 0x3d, 0xbf, 0xdf, 0xcf, 0x02, 0x01, 0x06, 0x5f, 0x99, 0x63, 
0xff, 0x7d, 0xfd, 0xbf, 0xc9, 0x3f, 0xbd, 0x80, 0x41, 0x13, 0x00, 0x08, 0x0c, 0x8f, 0xfb, 0xdf, 
0x94, 0xc3, 0x74, 0x5f, 0xbc, 0xff, 0xfc, 0x7d, 0x10, 0x09, 0x3c, 0x9f, 0x12, 0x43, 0xff, 0xff, 
0x37, 0xf7, 0xe7, 0xff, 0xf7, 0xc2, 0xd2, 0x0c, 0x40, 0x60, 0x11, 0xcf, 0xde, 0x7f, 0xc6, 0x3f, 
0xdf, 0xe5, 0xe7, 0xed, 0xf7, 0xff, 0x10, 0x10, 0x63, 0x7d, 0x21, 0x8f, 0xfd, 0xb7, 0xfe, 0xfd, 
0xb3, 0x5d, 0xdf, 0x42, 0x00, 0x18, 0x06, 0x00, 0x02, 0x3f, 0xf7, 0xfc, 0xc9, 0xff, 0xff, 0xfd, 
0x7b, 0x9f, 0xf9, 0xe7, 0x48, 0xc1, 0x0c, 0xde, 0xea, 0x1f, 0xf7, 0xfd, 0xfa, 0xef, 0x59, 0x3f, 
0xbb, 0xc6, 0x09, 0x80, 0x20, 0x00, 0xf6, 0x37, 0xbf, 0xfb, 0xb7, 0xff, 0xff, 0xff, 0x9e, 0xdf, 
0x7e, 0x7f, 0x02, 0x03, 0x1b, 0x69, 0x16, 0x7f, 0xdf, 0xff, 0x7a, 0xaf, 0xee, 0xef, 0xef, 0xc0, 
0x10, 0x66, 0x60, 0x00, 0x01, 0x63, 0xff, 0xff, 0x6f, 0xfb, 0xff, 0xff, 0xf6, 0xf7, 0xfe, 0x9d, 
0x06, 0x0c, 0x62, 0xfa, 0xa0, 0xfd, 0xe6, 0xff, 0xfc, 0x57, 0xee, 0xf7, 0xff, 0xc8, 0x00, 0xc0, 
0x84, 0x00, 0x00, 0x1f, 0xff, 0xfe, 0xdf, 0xef, 0xff, 0xff, 0xff, 0xbf, 0xf9, 0xe7, 0x58, 0x61, 
0xe5, 0xf2, 0x9b, 0xff, 0xc7, 0xfc, 0xf5, 0x55, 0xba, 0x77, 0xf7, 0x90, 0x00, 0x83, 0x00, 0x32, 
0x00, 0x8c, 0xff, 0xef, 0xbf, 0xef, 0xff, 0xff, 0xff, 0xfb, 0x77, 0xf7, 0x30, 0x71, 0x1d, 0xd7, 
0x53, 0xff, 0x87, 0xff, 0x7f, 0x2d, 0x37, 0x2f, 0xde, 0x00, 0xc2, 0x06, 0x20, 0x80, 0x64, 0x3f, 
0xff, 0xfb, 0x7f, 0xcb, 0xde, 0xfe, 0xfe, 0x7f, 0xff, 0x3d, 0x43, 0x0e, 0xb1, 0xed, 0x27, 0xfb, 
0xbe, 0xfc, 0x5c, 0xaa, 0x3f, 0xbb, 0xfe, 0x44, 0x06, 0x60, 0x03, 0x00, 0x67, 0x63, 0xff, 0xff, 
0xff, 0x5f, 0xff, 0xfe, 0x6f, 0xf7, 0xff, 0xbf, 0x82, 0x80, 0xff, 0xd5, 0x4f, 0xbf, 0xff, 0xfd, 
0x7e, 0xaa, 0x9c, 0xd3, 0xfa, 0x00, 0x04, 0x18, 0x68, 0x09, 0x00, 0x76, 0x7d, 0xde, 0xf5, 0xdf, 
0xfd, 0x7f, 0x5f, 0x9f, 0x7f, 0xcb, 0x0c, 0x35, 0x8f, 0x52, 0xbf, 0xfd, 0x7f, 0x7d, 0xda, 0xaa, 
0xbf, 0x9d, 0xff, 0x02, 0x10, 0x20, 0x32, 0x40, 0x08, 0x83, 0xff, 0x76, 0xf7, 0x9f, 0xff, 0x5e, 
0x5f, 0xf9, 0xef, 0xff, 0x39, 0x8c, 0xfe, 0x44, 0x9e, 0xef, 0xfb, 0xf3, 0x7a, 0x2a, 0xad, 0xef, 
0xfc, 0x00, 0x10, 0x81, 0x81, 0x80, 0x00, 0x8f, 0x7f, 0xff, 0xf7, 0xff, 0xff, 0x7b, 0xb6, 0xef, 
0xff, 0xbf, 0xa2, 0x3b, 0x99, 0xdb, 0x7f, 0x7a, 0xfe, 0xce, 0xad, 0x8a, 0xae, 0x6d, 0xf6, 0x10, 
0x24, 0xd9, 0x08, 0x31, 0x33, 0x03, 0xff, 0xfd, 0xaf, 0xff, 0xbb, 0x5b, 0xad, 0xf7, 0xff, 0xef, 
0x05, 0xe6, 0xe7, 0x0a, 0x7f, 0xdd, 0xdf, 0xb9, 0xfd, 0x4a, 0x8e, 0x77, 0xf4, 0x10, 0x01, 0x02, 
0x61, 0x80, 0x00, 0x3d, 0xbf, 0xf7, 0x67, 0xfd, 0xf6, 0xff, 0x29, 0xfb, 0xef, 0xb7, 0xf4, 0xbf, 
0x34, 0x23, 0xfb, 0x4f, 0xed, 0xb7, 0xf9, 0x52, 0x2e, 0xdb, 0x6c, 0x00, 0x80, 0x0c, 0x93, 0x00, 
0x06, 0x0b, 0xcf, 0xdd, 0x87, 0xf7, 0xde, 0xbf, 0x2b, 0x7b, 0xff, 0xde, 0x5f, 0xe5, 0xa4, 0x9f, 
0xd9, 0x2b, 0x7b, 0xfb, 0xaa, 0x94, 0xae, 0xd9, 0xf8, 0xc0, 0x84, 0x48, 0x8c, 0x08, 0x00, 0x60, 
0x7f, 0x77, 0xeb, 0xff, 0xf9, 0xbb, 0x6b, 0x7f, 0xbf, 0xf7, 0x4d, 0xba, 0xd3, 0xbe, 0xd5, 0x07, 
0xfe, 0xde, 0xf4, 0xad, 0x2f, 0x5d, 0x60, 0x02, 0x19, 0x90, 0x30, 0xc1, 0x9c, 0x05, 0xbf, 0xdf, 
0x69, 0xff, 0x2f, 0x7f, 0x2d, 0xf6, 0xff, 0xf3, 0x1b, 0x73, 0x1c, 0x8e, 0x18, 0x93, 0xf7, 0xff, 
0xc9, 0x69, 0x5d, 0xee, 0x61, 0x12, 0x00, 0x66, 0x62, 0x04, 0x09, 0xf1, 0xef, 0x7d, 0x55, 0xed, 
0xff, 0xfe, 0xbf, 0x7f, 0xff, 0xdf, 0x0b, 0xcd, 0xf0, 0x10, 0xb4, 0xcc, 0xff, 0xfd, 0x92, 0xd2, 
0xbf, 0xe3, 0xf0, 0x00, 0x20, 0x41, 0x90, 0x30, 0x00, 0x1e, 0x3b, 0xf7, 0xd0, 0xff, 0xff, 0xfe, 
0xf7, 0x7b, 0xff, 0xff, 0xb0, 0x36, 0x00, 0x04, 0x8e, 0x24, 0x3b, 0x76, 0x65, 0xa7, 0x2b, 0x72, 
0xc4, 0x48, 0x60, 0x93, 0x06, 0xc0, 0x01, 0x08, 0xe7, 0xdf, 0x2a, 0x3f, 0xff, 0xfd, 0x57, 0xff, 
0xff, 0x73, 0x05, 0xdb, 0x00, 0x04, 0x65, 0x31, 0x8d, 0xc2, 0x1f, 0x48, 0x00, 0xba, 0x61, 0x00, 
0x02, 0x0c, 0x63, 0x00, 0x60, 0x21, 0x3f, 0x7f, 0xbd, 0x1b, 0xff, 0xb3, 0x5a, 0xbf, 0xff, 0xef, 
0x6c, 0x6c, 0x03, 0x13, 0x03, 0xcc, 0x60, 0x28, 0xfd, 0x22, 0x09, 0x8f, 0xe3, 0x01, 0x06, 0xe8, 
0x8a, 0x42, 0x23, 0x70, 0xdf, 0xfb, 0xb4, 0xc7, 0xb6, 0xf6, 0xef, 0xbb, 0xdf, 0xff, 0x20, 0x80, 
0x18, 0x04, 0x48, 0x19, 0x82, 0x6d, 0xe0, 0x08, 0x62, 0x61, 0xc2, 0x21, 0x04, 0x06, 0x98, 0x10, 
0x00, 0x07, 0xbf, 0x7c, 0xc1, 0x32, 0xff, 0xd9, 0xdd, 0xff, 0xff, 0xf3, 0x12, 0xe0, 0x00, 0x21, 
0x20, 0x80, 0x7f, 0x40, 0x03, 0x00, 0x7e, 0x08, 0x0c, 0x00, 0x00, 0x22, 0x60, 0x00, 0x00, 0x80, 
0x8d, 0xf7, 0xea, 0x6d, 0x11, 0xf6, 0xff, 0xdf, 0xff, 0xff, 0x4a, 0x20, 0x80, 0x21, 0xac, 0x20, 
0x00, 0x00, 0x08, 0x01, 0x9a, 0x98, 0x21, 0x08, 0x13, 0x4c, 0x07, 0x00, 0x00, 0x88, 0x7f, 0xdf, 
0xb2, 0x99, 0xff, 0x1d, 0xbe, 0xf7, 0xdf, 0xdf, 0x80, 0x02, 0x00, 0x00, 0x21, 0x09, 0x00, 0x00, 
0x00, 0x07, 0xee, 0xb3, 0x24, 0x00, 0x00, 0x51, 0x84, 0x0c, 0x26, 0x21, 0x27, 0xf6, 0xec, 0x86, 
0x06, 0xe7, 0xfd, 0xef, 0x7f, 0xf7, 0x00, 0x10, 0x08, 0x03, 0x1c, 0x40, 0x20, 0x00, 0x00, 0x3c, 
0xe9, 0x64, 0x4c, 0x00, 0x01, 0x0f, 0x08, 0xc0, 0x21, 0x7f, 0x77, 0xbf, 0x72, 0x30, 0xf9, 0x7e, 
0x77, 0xff, 0xff, 0xfb, 0x06, 0xc0, 0x00, 0x20, 0x03, 0x36, 0x08, 0x20, 0x03, 0xff, 0x3b, 0x47, 
0xd8, 0x40, 0x03, 0x22, 0x79, 0x80, 0x00, 0x01, 0x1e, 0xfc, 0xd9, 0x8a, 0x0f, 0x7b, 0xff, 0xbf, 
0xdd, 0xef, 0x30, 0x00, 0xc0, 0x08, 0x04, 0xa5, 0x20, 0x01, 0xff, 0xdf, 0xcd, 0x99, 0x20, 0x00, 
0x12, 0x0c, 0x80, 0x10, 0x00, 0x44, 0x33, 0xf7, 0xe7, 0xcb, 0x50, 0x9f, 0x7c, 0xff, 0x77, 0xf7, 
0x00, 0x06, 0x01, 0x03, 0x01, 0x8c, 0x6f, 0xff, 0xe5, 0xd3, 0x63, 0x3b, 0x60, 0x00, 0x00, 0xd1, 
0x19, 0x00, 0x00, 0x00, 0xbf, 0xff, 0xb8, 0x78, 0x12, 0x85, 0x4f, 0xfd, 0xff, 0xfb, 0x02, 0x60, 
0x08, 0x00, 0x20, 0x23, 0xa0, 0x1f, 0x7f, 0x7f, 0x2e, 0x47, 0x80, 0x00, 0x08, 0x31, 0x30, 0x0c, 
0x93, 0xb8, 0x0f, 0x6c, 0xfd, 0xee, 0x50, 0x7d, 0xfb, 0x77, 0xff, 0xde, 0x06, 0x00, 0x60, 0x00, 
0x0c, 0x0c, 0x3f, 0xf3, 0x36, 0xb1, 0xf1, 0xdb, 0x00, 0x00, 0x12, 0x40, 0xc0, 0x10, 0x00, 0x03, 
0xe1, 0xf7, 0xe3, 0x3f, 0xc6, 0x80, 0x49, 0xdf, 0xff, 0x77, 0x30, 0x00, 0x00, 0x60, 0x01, 0x80, 
0xc0, 0x03, 0xc9, 0xec, 0xdc, 0x3f, 0x40, 0x00, 0x00, 0xc9, 0x80, 0xc0, 0x04, 0x41, 0x1f, 0xbf, 
0x39, 0x1f, 0xf8, 0xff, 0xaf, 0xff, 0xff, 0xfb, 0x00, 0x07, 0x02, 0x00, 0x24, 0x30, 0x01, 0x3c, 
0x9e, 0x73, 0x0f, 0x6d, 0x04, 0x40, 0xc5, 0x92, 0x01, 0x80, 0x00, 0x44, 0x0d, 0xec, 0xfe, 0xcd, 
0xff, 0x69, 0xbf, 0xf7, 0x7f, 0xee, 0x00, 0x30, 0x08, 0x01, 0x00, 0x04, 0xc8, 0x84, 0xf3, 0x8f, 
0xb1, 0xfb, 0x00, 0x00, 0x00, 0x14, 0x04, 0x00, 0x08, 0x00, 0x3f, 0xb7, 0xf6, 0x21, 0x77, 0xff, 
0xfd, 0xdf, 0xff, 0xbf, 0x03, 0x02, 0x20, 0x00, 0x00, 0xf0, 0x00, 0x9e, 0x2c, 0xe0, 0x93, 0x36, 
0x00, 0x02, 0x1e, 0x4d, 0x18, 0x03, 0x19, 0xd8, 0x83, 0x9f, 0x9b, 0x31, 0xcf, 0xcb, 0x7f, 0x7d, 
0xef, 0xf3, 0x38, 0x23, 0x00, 0x00, 0x00, 0x06, 0xdd, 0x01, 0xe6, 0x90, 0x0f, 0xec, 0x03, 0x02, 
0x10, 0x18, 0x20, 0x08, 0x10, 0x0d, 0xfc, 0xec, 0xfd, 0xcc, 0x3d, 0xbf, 0xfb, 0xf7, 0xbb, 0xbe, 
0x00, 0x19, 0x01, 0x80, 0x00, 0x60, 0x00, 0x5d, 0x1a, 0x0d, 0xc9, 0xa0, 0x00, 0x00, 0x19, 0x80, 
0x64, 0x30, 0x00, 0x20, 0x07, 0xbf, 0xe6, 0xc6, 0xe7, 0xf6, 0xcf, 0xdd, 0xfe, 0xff, 0x80, 0xc0, 
0x18, 0x40, 0x6c, 0x0d, 0xf6, 0xc0, 0xc0, 0x60, 0x5f, 0x30, 0x00, 0x10, 0x22, 0x64, 0xc0, 0x80, 
0x20, 0x01, 0x03, 0x9f, 0xbf, 0xb3, 0x10, 0x7f, 0x7e, 0xff, 0xfb, 0xf3, 0x00, 0x00, 0xc0, 0x1e, 
0x00, 0x00, 0x00, 0x36, 0x01, 0x99, 0x99, 0xc0, 0x00, 0x00, 0x80, 0xc0, 0x01, 0x80, 0x04, 0xcc, 
0x1c, 0xfc, 0xfc, 0xdd, 0x86, 0x9d, 0xfb, 0xff, 0xbf, 0xfe, 0x04, 0x04, 0x01, 0xc0, 0x03, 0x98, 
0x4d, 0x80, 0x08, 0x06, 0xf9, 0x80, 0x00, 0x00, 0x8c, 0x13, 0x00, 0x00, 0xcc, 0x6e, 0x63, 0xe7, 
0xe7, 0x54, 0xf8, 0x8f, 0xfe, 0xfc, 0xe7, 0xfd, 0x20, 0x00, 0x0c, 0x01, 0x98, 0x20, 0x00, 0x00, 
0xc0, 0x58, 0xcc, 0x00, 0x01, 0x81, 0x83, 0x04, 0x18, 0x06, 0x40, 0x00, 0x32, 0x7f, 0x9b, 0xdb, 
0x1b, 0xc0, 0x33, 0xf7, 0xff, 0xc7, 0x40, 0x40, 0x58, 0x03, 0x00, 0x01, 0x00, 0x0c, 0x05, 0x8f, 
0x84, 0x00, 0x00, 0x00, 0x22, 0x30, 0x13, 0x10, 0x00, 0x04, 0x07, 0xf8, 0xde, 0xfc, 0xcb, 0x1b, 
0xed, 0xbf, 0xff, 0xfb, 0x00, 0x00, 0xc0, 0x18, 0x00, 0x48, 0x00, 0xc0, 0x31, 0x26, 0xf0, 0x00, 
0x08, 0x0e, 0x6c, 0x12, 0x40, 0x20, 0x80, 0x80, 0x09, 0xa6, 0x77, 0x3b, 0x71, 0xc2, 0x00, 0xf6, 
0xff, 0xfe, 0x02, 0x00, 0x01, 0xc0, 0x06, 0x00, 0x1e, 0x00, 0x82, 0x38, 0x00, 0x00, 0x10, 0x00, 
0x18, 0x00, 0x80, 0x8c, 0x19, 0x9b, 0xc1, 0xb3, 0xd9, 0xfe, 0xde, 0x66, 0x1f, 0x97, 0xbf, 0x77, 
0x30, 0x08, 0x05, 0x00, 0x20, 0x01, 0xc0, 0x81, 0x09, 0x33, 0x00, 0x00, 0x80, 0x20, 0x03, 0xc1, 
0x93, 0x01, 0x20, 0x01, 0x9d, 0xff, 0xad, 0xcf, 0xe7, 0xf1, 0xb3, 0x6c, 0xef, 0xb3, 0x00, 0x40, 
0x1c, 0x11, 0x00, 0x0c, 0x08, 0x08, 0x01, 0xdc, 0x00, 0x01, 0x80, 0x61, 0x60, 0x98, 0x02, 0x03, 
0x00, 0x00, 0x00, 0x3c, 0xaf, 0x3f, 0x31, 0x8e, 0x4b, 0x63, 0xbf, 0xfe, 0x00, 0x00, 0xc1, 0x00, 
0x00, 0xc0, 0x00, 0x20, 0x60, 0x98, 0x00, 0x08, 0x02, 0x00, 0x1a, 0x0c, 0x98, 0x98, 0x00, 0x02, 
0x09, 0x13, 0x79, 0x9d, 0x0c, 0xe9, 0xc1, 0x1f, 0xff, 0xef, 0x06, 0x01, 0x80, 0x38, 0x0c, 0x00, 
0x10, 0x02, 0x0c, 0xf0, 0x00, 0x00, 0x06, 0x06, 0x26, 0x49, 0x90, 0x10, 0x00, 0xfb, 0xb0, 0x7f, 
0xd8, 0xc7, 0xc7, 0x1d, 0xbf, 0xfc, 0xff, 0xe7, 0x00, 0x00, 0x09, 0x80, 0x60, 0x01, 0x00, 0x08, 
0x31, 0xc8, 0x00, 0x00, 0x00, 0x08, 0x80, 0x70, 0x40, 0xc6, 0x2c, 0x00, 0x1b, 0xce, 0x96, 0x73, 
0x60, 0xf7, 0x02, 0x27, 0x7d, 0xb8, 0x00, 0x08, 0x03, 0x00, 0x00, 0x08, 0x00, 0x90, 0x23, 0x00, 
0x01, 0x00, 0x60, 0x20, 0xb0, 0x04, 0xc8, 0x00, 0x60, 0x00, 0x02, 0x18, 0xe7, 0x9c, 0x31, 0x29, 
0x6c, 0xfb, 0xef, 0x0c, 0x40, 0x00, 0x18, 0x06, 0x00, 0x80, 0x01, 0x00, 0x1a, 0x40, 0x20, 0x02, 
0x00, 0x64, 0x60, 0x80, 0x04, 0x02, 0x00, 0x00, 0x42, 0x1f, 0x3c, 0xfc, 0x8c, 0x0d, 0x8d, 0x8f, 
0xbf, 0x83, 0x00, 0x20, 0x20, 0x20, 0x04, 0x00, 0x08, 0x03, 0x53, 0x80, 0x00, 0x06, 0x00, 0x01, 
0x03, 0x03, 0x04, 0x46, 0x08, 0x13, 0xf6, 0xc7, 0xf9, 0x63, 0x06, 0xc3, 0x36, 0x7f, 0xff, 0xe7, 
0x00, 0x01, 0x80, 0x60, 0x20, 0x00, 0x80, 0x18, 0xc6, 0x00, 0x00, 0x20, 0x0e, 0x02, 0x00, 0x20, 
0x30, 0x10, 0x41, 0x80, 0x00, 0x7c, 0xce, 0x33, 0xd0, 0xcc, 0x5f, 0xf9, 0xec, 0x38, 0x00, 0x00, 
0x01, 0x00, 0x60, 0x08, 0x00, 0x00, 0x38, 0x02, 0x00, 0x20, 0x28, 0x88, 0x68, 0x18, 0x60, 0x60, 
0x0d, 0x00, 0x04, 0x07, 0xf7, 0xdc, 0x70, 0x21, 0x81, 0x9f, 0x38, 0x4c, 0x04, 0x04, 0x03, 0x02, 
0x00, 0x00, 0x04, 0x8f, 0x60, 0x00, 0x00, 0x04, 0xc0, 0x30, 0x09, 0x13, 0x03, 0x00, 0x60, 0x00, 
0x01, 0x16, 0x5d, 0x96, 0x0c, 0x50, 0x3e, 0xf3, 0xef, 0x07, 0x00, 0x00, 0x00, 0x06, 0x00, 0x04, 
0x08, 0x30, 0x00, 0x40, 0x0c, 0x01, 0x00, 0x00, 0xc0, 0x61, 0x0c, 0x02, 0x40, 0x09, 0xd9, 0xff, 
0xf9, 0xe3, 0xb6, 0x0c, 0x13, 0x3f, 0xf3, 0x99, 0x00, 0x00, 0x30, 0x20, 0x0e, 0x09, 0x03, 0x00, 
0x92, 0x00, 0x10, 0x10, 0x01, 0x80, 0x06, 0x08, 0x48, 0x06, 0x00, 0x08, 0x44, 0x09, 0xee, 0x3e, 
0xc1, 0xa7, 0x01, 0x9f, 0x60, 0xe3, 0x40, 0xc0, 0x00, 0x20, 0x20, 0xc0, 0x18, 0x00, 0x06, 0x03, 
0x80, 0x18, 0x04, 0x02, 0x00, 0x08, 0x10, 0x70, 0x04, 0xc0, 0x00, 0x07, 0x73, 0xf8, 0x78, 0xe0, 
0xfc, 0xf9, 0xe0, 0x70, 0x00, 0x00, 0x01, 0x00, 0xc2, 0x01, 0x20, 0x04, 0x60, 0x09, 0x08, 0x00, 
0x18, 0x10, 0x11, 0x19, 0x21, 0x20, 0x24, 0x00, 0x03, 0xfd, 0xff, 0x9f, 0x39, 0xb8, 0x06, 0x6c, 
0x18, 0x6c, 0x00, 0x01, 0x83, 0x06, 0x10, 0x33, 0x00, 0x40, 0x20, 0x30, 0x01, 0x80, 0x00, 0x20, 
0x80, 0x60, 0x41, 0x80, 0xc0, 0x00, 0x7e, 0x06, 0x3d, 0xe7, 0x3e, 0x0e, 0x00, 0x58, 0x0f, 0x8f, 
0x0c, 0x00, 0x00, 0x0c, 0x61, 0x20, 0x06, 0x18, 0x00, 0x00, 0x02, 0x01, 0x80, 0x00, 0x03, 0xa3, 
0x12, 0x1b, 0x04, 0x26, 0x00, 0x20, 0xf3, 0x79, 0xc7, 0x01, 0xc0, 0x0e, 0x07, 0x8b, 0x00, 0x00, 
0x08, 0x01, 0x89, 0x00, 0x70, 0x41, 0x13, 0x04, 0x00, 0x20, 0x00, 0x04, 0x0c, 0x8e, 0x08, 0x18, 
0x05, 0x00, 0x02, 0xfc, 0x7f, 0xd8, 0xe1, 0xc4, 0x73, 0x03, 0x98, 0xe1, 0x00, 0x00, 0x08, 0x43, 
0x30, 0x03, 0x04, 0x00, 0x10, 0x00, 0x60, 0x10, 0x00, 0x00, 0x33, 0xb0, 0x98, 0xb0, 0x89, 0x00, 
0x00, 0x37, 0xef, 0x8e, 0xba, 0x70, 0x1e, 0x18, 0xf0, 0x7e, 0x40, 0x00, 0x00, 0x08, 0x00, 0x20, 
0x03, 0x00, 0x60, 0x03, 0x00, 0x10, 0x08, 0x60, 0xc3, 0xb0, 0x40, 0x80, 0x48, 0x00, 0x1c, 0x01, 
0x3e, 0x67, 0xbe, 0x7f, 0x1b, 0xc8, 0xdc, 0x7c, 0xc0, 0x80, 0x43, 0x11, 0x80, 0x60, 0x06, 0x06, 
0x00, 0x0e, 0x00, 0x00, 0x40, 0x03, 0x1c, 0x05, 0x03, 0x19, 0x40, 0x00, 0x81, 0xef, 0x77, 0xf9, 
0xc7, 0xc7, 0xc0, 0xf7, 0x0f, 0x07, 0x00, 0x00, 0x02, 0x00, 0x07, 0x00, 0x70, 0x04, 0x04, 0xc0, 
0x06, 0x00, 0xc1, 0x06, 0x70, 0x43, 0x0b, 0x06, 0x00, 0x00, 0x00, 0x4f, 0xdf, 0x9c, 0xf3, 0xca, 
0xe6, 0x3e, 0x63, 0x87, 0x00, 0x04, 0x10, 0x20, 0x00, 0x04, 0x40, 0x60, 0x00, 0x40, 0x04, 0x00, 
0x01, 0x01, 0xc3, 0x60, 0xb0, 0xcc, 0x04, 0x00, 0x00, 0x10, 0xee, 0xe7, 0x38, 0x78, 0x38, 0xc3, 
0xdc, 0xe1, 0x0c, 0x04, 0x40, 0x80, 0x30, 0x74, 0x06, 0x00, 0x18, 0x00, 0x60, 0x08, 0x04, 0x19, 
0x1f, 0x0c, 0x90, 0x60, 0x08, 0x00, 0x19, 0x90, 0x3f, 0x7f, 0x0f, 0x30, 0x1f, 0x89, 0xf2, 0x7e, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x46, 0x04, 0x80, 0x00, 0x80, 0x40, 0x00, 0x00, 0x06, 0x30, 0x42, 
0x40, 0x04, 0x60, 0x00, 0x01, 0xf7, 0x9f, 0xf9, 0xc7, 0x07, 0xd1, 0xe4, 0xbe, 0x5c, 0xe0, 0x00, 
0x86, 0x02, 0x13, 0x01, 0x80, 0x23, 0x80, 0x00, 0x04, 0xc0, 0x20, 0xc9, 0x91, 0xb2, 0x0d, 0x01, 
0x00, 0x00, 0x00, 0x03, 0xff, 0xce, 0xf1, 0xc6, 0xc0, 0x3e, 0x0f, 0xc7, 0xc0, 0x40, 0x30, 0x00, 
0x0e, 0x00, 0x60, 0x10, 0x00, 0x0c, 0x01, 0x00, 0x02, 0x31, 0x8e, 0x24, 0x85, 0x03, 0x01, 0x00, 
0x11, 0x08, 0x3e, 0x6f, 0xb8, 0xf0, 0xf8, 0x37, 0x63, 0xc7, 0x00, 0x00, 0x20, 0x30, 0x60, 0x9e, 
0x08, 0x60, 0x00, 0x40, 0x10, 0x02, 0x06, 0x26, 0x2c, 0x62, 0xd8, 0x98, 0x24, 0x00, 0x09, 0x3c, 
0xcf, 0x79, 0x8e, 0x38, 0x1f, 0x43, 0xee, 0xfb, 0x16, 0x20, 0x01, 0x00, 0x80, 0x60, 0x02, 0x00, 
0x03, 0x01, 0x10, 0x02, 0x0c, 0x48, 0x61, 0x9a, 0x70, 0x60, 0x20, 0x10, 0x00, 0x83, 0x7d, 0xfc, 
0xdf, 0x2f, 0x09, 0x88, 0xf8, 0x78, 0x04, 0x21, 0x04, 0x06, 0x04, 0x48, 0x02, 0x00, 0x10, 0x01, 
0x80, 0x00, 0x18, 0xc1, 0x8b, 0x63, 0x05, 0x40, 0x80, 0x82, 0x40, 0xb1, 0xf7, 0xef, 0xf7, 0x83, 
0xe0, 0xeb, 0x9f, 0x7e, 0x30, 0x10, 0xc0, 0x04, 0x4c, 0x00, 0x00, 0x80, 0x60, 0x01, 0x80, 0x20, 
0x1a, 0x33, 0x38, 0x60, 0x1d, 0x06, 0x82, 0x88, 0x19, 0x1e, 0xff, 0xff, 0x39, 0xe1, 0xf2, 0x3e, 
0x2f, 0x97, 0x20, 0x40, 0x62, 0x41, 0x0a, 0x00, 0x40, 0x06, 0x00, 0x38, 0x00, 0x60, 0x45, 0x04, 
0x24, 0x9a, 0xd8, 0x24, 0x8a, 0x03, 0x01, 0x03, 0xdf, 0xff, 0xde, 0x78, 0x1c, 0x07, 0xaf, 0xe7, 
0x20, 0x00, 0x00, 0xc2, 0x40, 0x80, 0x00, 0x04, 0x00, 0x10, 0x03, 0x01, 0x9d, 0x4c, 0xc4, 0x42, 
0x00, 0xb0, 0x38, 0x72, 0x00, 0x71, 0x7f, 0xce, 0xf3, 0x1c, 0x0f, 0xc1, 0xfc, 0xfd, 0x97, 0x06, 
0x04, 0x11, 0x80, 0x0c, 0x00, 0xc0, 0x03, 0x00, 0x08, 0x06, 0x32, 0x31, 0x93, 0x40, 0x06, 0x49, 
0x24, 0xd8, 0x86, 0x0f, 0xef, 0x7f, 0xb1, 0xe7, 0xa1, 0xe1, 0xfe, 0xfc, 0x0d, 0x40, 0x06, 0x0c, 
0x80, 0x00, 0x02, 0x00, 0x01, 0x00, 0x20, 0x16, 0x66, 0x92, 0x38, 0x20, 0x24, 0x49, 0xc4, 0x80, 
0x93, 0xed, 0xff, 0xfb, 0x9e, 0xe2, 0xc0, 0x3e, 0x0f, 0xcf, 0x18, 0x09, 0x00, 0x08, 0x01, 0x80, 
0x08, 0x00, 0x60, 0x00, 0x60, 0x49, 0xcf, 0xc6, 0x28, 0x20, 0x20, 0x06, 0x04, 0x86, 0x1a, 0x7f, 
0xff, 0xfe, 0xfe, 0x98, 0x12, 0x3e, 0x1f, 0xe7, 0x30, 0x20, 0xc0, 0x10, 0x60, 0x00, 0x80, 0x02, 
0x00, 0x06, 0x01, 0x6f, 0x26, 0x68, 0x80, 0x12, 0x00, 0xb4, 0x70, 0x64, 0xc3, 0xcf, 0xff, 0xf6, 
0xe3, 0x8c, 0x1d, 0x83, 0xf2, 0xff, 0x00, 0x60, 0xc7, 0x90, 0x18, 0x00, 0x00, 0x06, 0x00, 0x0c, 
0x00, 0x9f, 0x36, 0x29, 0x84, 0x80, 0x86, 0x01, 0x29, 0x24, 0x71, 0xbf, 0xb7, 0xdf, 0x9d, 0xc3, 
0x8d, 0xc3, 0xf8, 0x7c, 0x03, 0x00, 0x00, 0x82, 0x00, 0x10, 0x00, 0xe0, 0x00, 0xc0, 0x0c, 0x33, 
0xe4, 0x90, 0x22, 0x20, 0x32, 0x4b, 0x63, 0x27, 0x1f, 0x7f, 0xff, 0xff, 0x7f, 0x70, 0xe0, 0xec, 
0xdd, 0xef, 0x1a, 0x06, 0x00, 0x09, 0x80, 0x10, 0x00, 0x00, 0x00, 0x40, 0x04, 0xfb, 0xe4, 0xf6, 
0x28, 0x09, 0x00, 0x6e, 0x58, 0x99, 0x9b, 0xff, 0xdf, 0xbf, 0xfe, 0x9c, 0x32, 0x78, 0x07, 0xc3, 
0x04, 0x4c, 0x38, 0x00, 0x01, 0x00, 0x04, 0x00, 0x18, 0x01, 0x01, 0x9f, 0x4c, 0x66, 0x40, 0x12, 
0x44, 0x20, 0x94, 0x9c, 0x6d, 0xbf, 0xf9, 0xef, 0xb9, 0x84, 0x18, 0x97, 0x2f, 0xf3, 0x30, 0x30, 
0x88, 0x30, 0x41, 0x01, 0x90, 0x01, 0x80, 0x01, 0x48, 0x73, 0xc7, 0x18, 0xc6, 0xc6, 0x33, 0x93, 
0xe3, 0xe7, 0x8f, 0xff, 0xff, 0x6e, 0xee, 0x70, 0x8f, 0x83, 0xf9, 0xbf, 0x10, 0x20, 0x80, 0x08, 
0x10, 0x20, 0x40, 0x00, 0x00, 0x10, 0x03, 0x73, 0x93, 0xf8, 0x00, 0x19, 0x88, 0xdd, 0x0e, 0x64, 
0xfb, 0xff, 0xdf, 0xdf, 0xfe, 0x98, 0x23, 0x83, 0xd0, 0x7f, 0x00, 0x81, 0x83, 0x00, 0x80, 0x88, 
0x00, 0x60, 0x04, 0x18, 0x03, 0x1f, 0x83, 0x6e, 0x24, 0xdf, 0xee, 0xf6, 0x7b, 0x3e, 0x7e, 0xbf, 
0xff, 0xf7, 0xfb, 0xcb, 0x40, 0x6c, 0x3e, 0x4f, 0x8a, 0x01, 0x40, 0x91, 0x00, 0x90, 0x00, 0x10, 
0x01, 0x80, 0x10, 0x3b, 0x27, 0x67, 0x12, 0x37, 0xff, 0xfb, 0xcb, 0xcf, 0xff, 0xff, 0xff, 0xbf, 
0xef, 0x70, 0x40, 0x4c, 0x0f, 0xc3, 0x07, 0x2c, 0x18, 0x04, 0x06, 0x40, 0x0c, 0x00, 0x22, 0x04, 
0x40, 0xdb, 0x01, 0xd4, 0x43, 0xbf, 0xff, 0xff, 0x9d, 0xf7, 0xf9, 0xff, 0xf9, 0xcf, 0xfd, 0x3c, 
0x3c, 0x83, 0xdf, 0xff, 0x10, 0x36, 0x10, 0x08, 0x83, 0x00, 0x44, 0x00, 0x30, 0x07, 0x22, 0x5f, 
0x03, 0xdc, 0xcd, 0xff, 0xff, 0xff, 0xf5, 0xbf, 0xff, 0xfb, 0xff, 0xff, 0xf9, 0xff, 0x33, 0x03, 
0xf3, 0xfe, 0x10, 0x10, 0x94, 0x90, 0x30, 0x01, 0x00, 0x06, 0x00, 0x01, 0x09, 0x2d, 0x01, 0xfb, 
0x97, 0xff, 0xff, 0xff, 0xfb, 0xfb, 0xcf, 0xff, 0xbe, 0xef, 0xef, 0xe3, 0x81, 0x49, 0x3c, 0x7f, 
0x10, 0xc0, 0x81, 0x90, 0x64, 0x88, 0x80, 0x00, 0x10, 0xb0, 0x1c, 0xec, 0x00, 0xfb, 0x27, 0xff, 
0xff, 0xff, 0xee, 0xfe, 0xff, 0xbf, 0xe7, 0x9f, 0xfe, 0xb8, 0xc0, 0x76, 0x1f, 0xcf, 0x48, 0x40, 
0xc9, 0x42, 0x09, 0x18, 0x00, 0x80, 0x04, 0x20, 0x26, 0xd8, 0x00, 0xdf, 0xe7, 0xff, 0xff, 0xff, 
0xfb, 0xf6, 0xfe, 0xef, 0xf9, 0xff, 0xdc, 0xfc, 0xf0, 0x36, 0x9f, 0xc3, 0x4b, 0x08, 0x32, 0x03, 
0x23, 0x10, 0x18, 0x00, 0x63, 0x01, 0x23, 0x70, 0x20, 0xfe, 0xfa, 0xff, 0xff, 0xff, 0xf7, 0xb7, 
0xef, 0xff, 0xfe, 0x3f, 0xff, 0xce, 0x1f, 0x83, 0xa5, 0xf7, 0x06, 0x2d, 0x34, 0x20, 0x24, 0x00, 
0x00, 0x02, 0x00, 0x10, 0x49, 0x30, 0x00, 0x7e, 0xbb, 0x4d, 0xff, 0xff, 0xed, 0xff, 0x7f, 0xff, 
0xe7, 0xbf, 0xfb, 0xf3, 0x07, 0x01, 0xf0, 0x7f, 0x04, 0x04, 0xcc, 0x30, 0x65, 0x01, 0x00, 0x10, 
0x90, 0x0e, 0x4d, 0x88, 0x00, 0x3f, 0xb5, 0xf6, 0xcd, 0xbf, 0xef, 0xf3, 0xff, 0xff, 0xfb, 0xff, 
0xff, 0x77, 0xc0, 0xe4, 0x7a, 0x7f, 0x10, 0x11, 0xc0, 0x90, 0x30, 0x01, 0x00, 0x4c, 0x00, 0x42, 
0x13, 0xc0, 0x00, 0x3d, 0xf5, 0xbb, 0xf5, 0xbf, 0x7f, 0xb7, 0xff, 0xff, 0x9b, 0xff, 0xff, 0x78, 
0x68, 0x7a, 0x0f, 0xdf, 0x19, 0x61, 0x03, 0x44, 0x80, 0x90, 0x04, 0x00, 0x20, 0x40, 0x92, 0x40, 
0x08, 0x0f, 0x7c, 0xfb, 0xf6, 0x6d, 0xcd, 0xff, 0xff, 0xfe, 0xe7, 0xff, 0xff, 0xcc, 0x3c, 0x0b, 
0x85, 0xe3, 0x24, 0x42, 0x41, 0x0b, 0x02, 0x00, 0x30, 0x80, 0x04, 0x81, 0x89, 0x00, 0x80, 0x03, 
0xff, 0x7e, 0xc8, 0x8e, 0x7f, 0xdb, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xb7, 0x17, 0x81, 0xc1, 0x7b
};