/* This example renders a png or Jpeg file to be stored in a FLASH array

 Image files can be converted to arrays using the tool here:
 https://javl.github.io/image2cpp/

 To use this tool:
  1. Click "Choose Files" button to select file to convert...
  2. Section 2 allows you to modifiy image settings and preview changes in section 3.
  3. Set "Canvas size(s)" to desired image size. 
  4. Final image width >>> MUST BE DIVISABLE BY 8 <<<. Width is the left number of image size.
  5. >>> NOTE: Some images/printers may require "Invert image colors" to be clicked to print as desired. <<<
  6. In section 4, Set "Code Output" to "Plain Bytes". This will prepare the bytes to be pasted in the array below.
  7. Click "Generate Code".
  8. Click "Copy Output"
  9. Paste output inside the image array brackets below (replace existing bytes).
  10. Make sure "#define TESTIMAGE_WIDTH & HEIGHT" are set to final image sizes.
  11. Final image array must alway be defined "static const uint8_t testImage[] PROGMEM  = {....};"

  >> FYI, TESTIMAGE settings were: Invert:yes, Dithering:Atkinson, Brightness / alpha threshold: 128 <<
*/

#define TESTIMAGE_WIDTH 320
#define TESTIMAGE_HEIGHT 194

// array size is 7200
static const uint8_t datalog[] PROGMEM  = {// 'datalog', 320x194px
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf8, 0x00, 0x00, 0x00, 0x1f, 
0xe0, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x01, 0xfc, 0x00, 
0x00, 0x00, 0x07, 0xf0, 0x00, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x0f, 0xfe, 0x00, 0x00, 0x00, 0x3f, 0xf8, 0x00, 0x00, 0x00, 0xff, 0xe0, 0x00, 0x00, 
0x03, 0xff, 0xc0, 0x00, 0x00, 0x07, 0xff, 0x00, 0x00, 0x00, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x7f, 
0xf0, 0x00, 0x00, 0x00, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0x7f, 
0xfc, 0x00, 0x00, 0x01, 0xff, 0xf8, 0x00, 0x00, 0x07, 0xff, 0xe0, 0x00, 0x00, 0x0f, 0xff, 0x80, 
0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0x01, 0xff, 0xf8, 0x00, 0x00, 
0x00, 0x00, 0x3f, 0xff, 0x80, 0x00, 0x00, 0xff, 0xfe, 0x00, 0x00, 0x03, 0xff, 0xfc, 0x00, 0x00, 
0x0f, 0xff, 0xf0, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x01, 0xff, 
0xfe, 0x00, 0x00, 0x03, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xc0, 0x00, 0x01, 0xff, 
0xff, 0x00, 0x00, 0x07, 0xff, 0xfe, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x00, 0x00, 0x3f, 0xff, 0xe0, 
0x00, 0x00, 0xff, 0xff, 0xc0, 0x00, 0x01, 0xff, 0xff, 0x00, 0x00, 0x07, 0xff, 0xfe, 0x00, 0x00, 
0x00, 0x00, 0xff, 0x3f, 0xe0, 0x00, 0x03, 0xfc, 0xff, 0x80, 0x00, 0x07, 0xf9, 0xff, 0x00, 0x00, 
0x1f, 0xe7, 0xfc, 0x00, 0x00, 0x7f, 0x9f, 0xf0, 0x00, 0x00, 0xff, 0x7f, 0xe0, 0x00, 0x03, 0xfc, 
0xff, 0x80, 0x00, 0x07, 0xf9, 0xff, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x0f, 0xf0, 0x00, 0x03, 0xf8, 
0x3f, 0xc0, 0x00, 0x0f, 0xf0, 0xff, 0x00, 0x00, 0x1f, 0xc3, 0xfe, 0x00, 0x00, 0x7f, 0x07, 0xf8, 
0x00, 0x01, 0xfc, 0x1f, 0xe0, 0x00, 0x07, 0xf8, 0x7f, 0xc0, 0x00, 0x0f, 0xf0, 0xff, 0x00, 0x00, 
0x00, 0x01, 0xfc, 0x07, 0xf8, 0x00, 0x07, 0xf0, 0x1f, 0xe0, 0x00, 0x0f, 0xe0, 0x7f, 0x80, 0x00, 
0x3f, 0x80, 0xfe, 0x00, 0x00, 0xfe, 0x03, 0xfc, 0x00, 0x01, 0xfc, 0x0f, 0xf0, 0x00, 0x07, 0xf0, 
0x3f, 0xc0, 0x00, 0x0f, 0xe0, 0x7f, 0x80, 0x00, 0x00, 0x01, 0xfc, 0x03, 0xf8, 0x00, 0x07, 0xf0, 
0x0f, 0xe0, 0x00, 0x1f, 0xc0, 0x3f, 0xc0, 0x00, 0x3f, 0x00, 0xff, 0x00, 0x00, 0xfe, 0x01, 0xfc, 
0x00, 0x03, 0xf8, 0x07, 0xf8, 0x00, 0x07, 0xe0, 0x1f, 0xe0, 0x00, 0x1f, 0xc0, 0x3f, 0xc0, 0x00, 
0x00, 0x03, 0xf8, 0x03, 0xfc, 0x00, 0x07, 0xe0, 0x07, 0xf0, 0x00, 0x1f, 0xc0, 0x1f, 0xc0, 0x00, 
0x7f, 0x00, 0x7f, 0x80, 0x00, 0xfc, 0x00, 0xfe, 0x00, 0x03, 0xf8, 0x03, 0xf8, 0x00, 0x0f, 0xe0, 
0x0f, 0xe0, 0x00, 0x1f, 0xc0, 0x1f, 0xc0, 0x00, 0x00, 0x03, 0xf8, 0x01, 0xfc, 0x00, 0x0f, 0xe0, 
0x07, 0xf8, 0x00, 0x1f, 0x80, 0x0f, 0xe0, 0x00, 0x7f, 0x00, 0x3f, 0x80, 0x01, 0xfc, 0x00, 0xfe, 
0x00, 0x03, 0xf0, 0x01, 0xfc, 0x00, 0x0f, 0xc0, 0x07, 0xf0, 0x00, 0x1f, 0x80, 0x0f, 0xe0, 0x00, 
0x00, 0x03, 0xf0, 0x00, 0xfe, 0x00, 0x0f, 0xe0, 0x03, 0xf8, 0x00, 0x3f, 0x80, 0x0f, 0xe0, 0x00, 
0x7e, 0x00, 0x1f, 0xc0, 0x01, 0xfc, 0x00, 0x7f, 0x00, 0x07, 0xf0, 0x01, 0xfc, 0x00, 0x0f, 0xc0, 
0x07, 0xf0, 0x00, 0x3f, 0x80, 0x0f, 0xe0, 0x00, 0x00, 0x03, 0xf0, 0x00, 0xfe, 0x00, 0x0f, 0xc0, 
0x01, 0xf8, 0x00, 0x3f, 0x80, 0x07, 0xf0, 0x00, 0x7e, 0x00, 0x1f, 0xc0, 0x01, 0xf8, 0x00, 0x7f, 
0x00, 0x07, 0xf0, 0x00, 0xfe, 0x00, 0x1f, 0xc0, 0x03, 0xf8, 0x00, 0x3f, 0x80, 0x07, 0xf0, 0x00, 
0x00, 0x07, 0xf0, 0x00, 0x7f, 0x00, 0x0f, 0xc0, 0x01, 0xfc, 0x00, 0x3f, 0x00, 0x07, 0xf0, 0x00, 
0xfe, 0x00, 0x0f, 0xc0, 0x01, 0xf8, 0x00, 0x3f, 0x80, 0x07, 0xe0, 0x00, 0xfe, 0x00, 0x1f, 0xc0, 
0x01, 0xf8, 0x00, 0x3f, 0x00, 0x07, 0xf0, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 
0x00, 0x7f, 0x00, 0x00, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x0f, 
0xc0, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 
0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 
0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 
0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x0f, 
0xe0, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 
0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 
0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 
0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x0f, 
0xe0, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 
0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 
0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 
0x00, 0x7e, 0x00, 0x00, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x0f, 
0xc0, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x01, 0xfc, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x01, 0xfc, 0x00, 
0x00, 0x00, 0x07, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 
0x00, 0xfe, 0x00, 0x00, 0x00, 0x01, 0xfc, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 
0x00, 0x7e, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x00, 0x00, 0x00, 0x1f, 
0xc0, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x00, 
0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 
0x00, 0xfc, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 
0x00, 0x7c, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x00, 0x00, 0x00, 0x03, 0xe0, 0x00, 0x00, 0x00, 0x0f, 
0x80, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 
0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x60, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x07, 0xff, 0xe0, 0x00, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 
0x1f, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf0, 0x00, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 
0x1f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xf8, 0x00, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 
0x1f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xfc, 0x00, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 
0x1f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xfc, 0x00, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 
0x1f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xfe, 0x00, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 
0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xc0, 0xff, 0xff, 0xff, 0x80, 0x7f, 
0xfe, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 
0x1f, 0xff, 0xc0, 0x07, 0xff, 0xff, 0x80, 0x7f, 0xfe, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0x80, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x01, 0xff, 0xff, 0x80, 0x7f, 
0xfe, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xc0, 0x7f, 0xfe, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xc0, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0xc0, 0x7f, 
0xfe, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0xc0, 0x7f, 0xfe, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xc0, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x3f, 0xff, 0xc0, 0x7f, 
0xfe, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x3f, 0xff, 0xc0, 0x7f, 0xfe, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xe0, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x3f, 0xff, 0xc0, 0x7f, 
0xfe, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x3f, 0xff, 0xc0, 0x7f, 0xfe, 0x00, 0x00, 0x0f, 0xff, 0xe7, 0xff, 0xf0, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x3f, 0xff, 0xc0, 0x7f, 
0xfe, 0x00, 0x00, 0x1f, 0xff, 0xe7, 0xff, 0xf0, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x3f, 0xff, 0xc0, 0x7f, 0xfe, 0x00, 0x00, 0x1f, 0xff, 0xc7, 0xff, 0xf8, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x1e, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x3f, 0xff, 0xc0, 0x7f, 
0xfe, 0x00, 0x00, 0x1f, 0xff, 0xc3, 0xff, 0xf8, 0x00, 0x00, 0x7f, 0xfe, 0x03, 0xff, 0xf0, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0xc0, 0x7f, 0xfe, 0x00, 0x00, 0x3f, 0xff, 0xc3, 0xff, 0xfc, 
0x00, 0x00, 0x7f, 0xfe, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x1f, 0xff, 0xfe, 
0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0xc0, 0x7f, 
0xfe, 0x00, 0x00, 0x3f, 0xff, 0x83, 0xff, 0xfc, 0x00, 0x00, 0x7f, 0xfe, 0x3f, 0xff, 0xff, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x7f, 0xff, 0xff, 0x80, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0xff, 0xff, 0x80, 0x7f, 0xfe, 0x00, 0x00, 0x7f, 0xff, 0x81, 0xff, 0xfc, 
0x00, 0x00, 0x7f, 0xfe, 0x7f, 0xff, 0xff, 0x80, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xff, 0xff, 0xff, 
0xe0, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x03, 0xff, 0xff, 0x80, 0x7f, 
0xfe, 0x00, 0x00, 0x7f, 0xff, 0x81, 0xff, 0xfe, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xc0, 
0x00, 0x7f, 0xfe, 0x00, 0x03, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x0f, 0xff, 0xff, 0x80, 0x7f, 0xfe, 0x00, 0x00, 0x7f, 0xff, 0x00, 0xff, 0xfe, 
0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x7f, 0xfe, 0x00, 0x07, 0xff, 0xff, 0xff, 
0xf8, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf0, 
0x00, 0x7f, 0xfe, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xff, 0xfe, 0x00, 0xff, 0xff, 
0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x7f, 0xfe, 0x00, 0x1f, 0xff, 0xff, 0xff, 
0xfe, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x7f, 
0xfe, 0x00, 0x01, 0xff, 0xfe, 0x00, 0x7f, 0xff, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfc, 
0x00, 0x7f, 0xfe, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x7f, 0xfe, 0x00, 0x01, 0xff, 0xfe, 0x00, 0x7f, 0xff, 
0x80, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x7f, 0xfe, 0x00, 0x7f, 0xff, 0x80, 0x7f, 
0xff, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x7f, 
0xfe, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x3f, 0xff, 0x80, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 
0x00, 0x7f, 0xfe, 0x00, 0x7f, 0xff, 0x00, 0x3f, 0xff, 0x80, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x7f, 0xfe, 0x00, 0x03, 0xff, 0xfc, 0x00, 0x3f, 0xff, 
0xc0, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x7f, 0xfe, 0x00, 0xff, 0xfe, 0x00, 0x1f, 
0xff, 0x80, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x7f, 
0xfe, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x3f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0xf8, 0x07, 0xff, 0xff, 
0x00, 0x7f, 0xfe, 0x00, 0xff, 0xfc, 0x00, 0x0f, 0xff, 0xc0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x7f, 0xfe, 0x00, 0x07, 0xff, 0xf8, 0x00, 0x1f, 0xff, 
0xc0, 0x00, 0x7f, 0xff, 0xe0, 0x03, 0xff, 0xff, 0x00, 0x7f, 0xfe, 0x01, 0xff, 0xfc, 0x00, 0x07, 
0xff, 0xc0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x7f, 
0xfe, 0x00, 0x07, 0xff, 0xf8, 0x00, 0x1f, 0xff, 0xe0, 0x00, 0x7f, 0xff, 0xc0, 0x00, 0xff, 0xff, 
0x80, 0x7f, 0xfe, 0x01, 0xff, 0xf8, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x0f, 0xff, 0xf8, 0x00, 0x1f, 0xff, 
0xe0, 0x00, 0x7f, 0xff, 0x80, 0x00, 0xff, 0xff, 0x80, 0x7f, 0xfe, 0x01, 0xff, 0xfc, 0x00, 0x07, 
0xff, 0xe0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x7f, 0xff, 0x00, 0x00, 0x7f, 0xff, 
0x80, 0x7f, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xf0, 0x00, 0x7f, 0xff, 0x00, 0x00, 0x3f, 0xff, 0x80, 0x7f, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xe0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x3f, 0xff, 
0xc0, 0x7f, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xf8, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x3f, 0xff, 0xc0, 0x7f, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xe0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x3f, 0xff, 
0xc0, 0x7f, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xfc, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x3f, 0xff, 0xc0, 0x7f, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xe0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x3f, 0xff, 
0xc0, 0x7f, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xfc, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x3f, 0xff, 0xc0, 0x7f, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xe0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x3f, 0xff, 
0xc0, 0x7f, 0xfe, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xfe, 0x00, 0x7f, 0xff, 0x00, 0x00, 0x3f, 0xff, 0x80, 0x7f, 0xfe, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x7f, 0xff, 0x00, 0x00, 0x7f, 0xff, 
0x80, 0x7f, 0xfe, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x7f, 0xff, 0x80, 0x7f, 0xfe, 0x01, 0xff, 0xfc, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xc0, 0x00, 0xff, 0xff, 
0x80, 0x7f, 0xfe, 0x01, 0xff, 0xfc, 0x00, 0x01, 0xc0, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x01, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x7f, 
0xff, 0x80, 0x7f, 0xff, 0xe0, 0x01, 0xff, 0xff, 0x00, 0x7f, 0xfe, 0x01, 0xff, 0xfe, 0x00, 0x03, 
0xf0, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x03, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x7f, 0xff, 0x80, 0x7f, 0xff, 0xf0, 0x07, 0xff, 0xff, 
0x00, 0x7f, 0xfe, 0x00, 0xff, 0xff, 0x00, 0x07, 0xfc, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x03, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x3f, 
0xff, 0xc0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x7f, 0xfe, 0x00, 0xff, 0xff, 0xc0, 0x1f, 
0xff, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x03, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xc0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 
0x00, 0x7f, 0xfe, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x07, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x3f, 
0xff, 0xc0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x7f, 0xfe, 0x00, 0x7f, 0xff, 0xff, 0xff, 
0xff, 0xc0, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x07, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xe0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfc, 
0x00, 0x7f, 0xfe, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x0f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x1f, 
0xff, 0xe0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x7f, 0xfe, 0x00, 0x1f, 0xff, 0xff, 0xff, 
0xff, 0x80, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf8, 
0x00, 0x7f, 0xfe, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x0f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 
0xff, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x7f, 0xfe, 0x00, 0x07, 0xff, 0xff, 0xff, 
0xfe, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x1f, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xf8, 0x7f, 0xfe, 0xff, 0xff, 0xff, 0xe0, 
0x00, 0x7f, 0xfe, 0x00, 0x03, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x1f, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x07, 
0xff, 0xf8, 0x7f, 0xfe, 0x7f, 0xff, 0xff, 0x80, 0x00, 0x7f, 0xfe, 0x00, 0x01, 0xff, 0xff, 0xff, 
0xf0, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x3f, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x07, 0xff, 0xf8, 0x7f, 0xfe, 0x3f, 0xff, 0xff, 0x00, 
0x00, 0x7f, 0xfe, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x3f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x07, 
0xff, 0xfc, 0x7f, 0xfe, 0x0f, 0xff, 0xfc, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x1f, 0xff, 0xff, 
0x80, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x3f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x7f, 0xfe, 0x03, 0xff, 0xf0, 0x00, 
0x00, 0x7f, 0xfc, 0x00, 0x00, 0x07, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x00, 
0x1f, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xff, 0xfe, 0x00, 0x00, 0x0f, 
0xf0, 0x03, 0xff, 0xff, 0xf0, 0x01, 0xfc, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x3f, 0xf8, 0x00, 
0x00, 0x7f, 0xf0, 0x00, 0x03, 0xff, 0xc0, 0x07, 0xff, 0xff, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xff, 0xff, 0x80, 0x00, 0x0f, 0xf0, 0x03, 0xff, 0xff, 0xf0, 0x03, 0xfe, 0x00, 
0x00, 0x07, 0xe0, 0x00, 0x00, 0xff, 0xfe, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x0f, 0xff, 0xe0, 0x07, 
0xff, 0xff, 0x03, 0xff, 0xfe, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x1f, 
0xf0, 0x03, 0xff, 0xff, 0xf0, 0x03, 0xfe, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x01, 0xff, 0xff, 0x00, 
0x07, 0xff, 0xfe, 0x00, 0x1f, 0xff, 0xf8, 0x07, 0xff, 0xff, 0x03, 0xff, 0xff, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x00, 0x1f, 0xf8, 0x03, 0xff, 0xff, 0xf0, 0x03, 0xfe, 0x00, 
0x00, 0x07, 0xe0, 0x00, 0x03, 0xff, 0xff, 0x80, 0x0f, 0xff, 0xff, 0x00, 0x3f, 0xff, 0xfc, 0x07, 
0xff, 0xff, 0x03, 0xff, 0xff, 0x80, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xff, 0xff, 0xf8, 0x00, 0x1f, 
0xf8, 0x01, 0xff, 0xff, 0xe0, 0x07, 0xff, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x07, 0xf8, 0x3f, 0xc0, 
0x0f, 0xf0, 0x7f, 0x80, 0x7f, 0x83, 0xfc, 0x07, 0xff, 0xfe, 0x03, 0xe0, 0x3f, 0x80, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xf8, 0x03, 0xfc, 0x00, 0x3f, 0xf8, 0x00, 0x03, 0xf0, 0x00, 0x07, 0xff, 0x00, 
0x00, 0x07, 0xe0, 0x00, 0x0f, 0xe0, 0x0f, 0xe0, 0x1f, 0xc0, 0x1f, 0x80, 0xfe, 0x00, 0xfc, 0x07, 
0xe0, 0x00, 0x03, 0xe0, 0x1f, 0x80, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xf8, 0x00, 0xfc, 0x00, 0x3e, 
0xfc, 0x00, 0x03, 0xf0, 0x00, 0x07, 0xdf, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x0f, 0xc0, 0x07, 0xe0, 
0x3f, 0x80, 0x0e, 0x00, 0xfc, 0x00, 0x78, 0x07, 0xe0, 0x00, 0x03, 0xe0, 0x0f, 0xc0, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xf8, 0x00, 0xfe, 0x00, 0x3e, 0xfc, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0xdf, 0x80, 
0x00, 0x07, 0xe0, 0x00, 0x1f, 0x80, 0x03, 0xf0, 0x3f, 0x00, 0x04, 0x01, 0xf8, 0x00, 0x20, 0x07, 
0xe0, 0x00, 0x03, 0xe0, 0x0f, 0xc0, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xf8, 0x00, 0x7e, 0x00, 0x7c, 
0x7c, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0x8f, 0x80, 0x00, 0x07, 0xe0, 0x00, 0x1f, 0x80, 0x03, 0xf0, 
0x3f, 0x00, 0x00, 0x01, 0xf8, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x03, 0xe0, 0x0f, 0xc0, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xf8, 0x00, 0x7e, 0x00, 0x7c, 0x7e, 0x00, 0x03, 0xf0, 0x00, 0x0f, 0x8f, 0x80, 
0x00, 0x07, 0xe0, 0x00, 0x1f, 0x80, 0x03, 0xf0, 0x3e, 0x00, 0x00, 0x01, 0xf8, 0x00, 0x00, 0x07, 
0xe0, 0x00, 0x03, 0xe0, 0x0f, 0x80, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xf8, 0x00, 0x3e, 0x00, 0xfc, 
0x7e, 0x00, 0x03, 0xf0, 0x00, 0x1f, 0x8f, 0xc0, 0x00, 0x07, 0xe0, 0x00, 0x1f, 0x00, 0x01, 0xf0, 
0x7e, 0x00, 0x00, 0x01, 0xf0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x03, 0xe0, 0x0f, 0x80, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xf8, 0x00, 0x3f, 0x00, 0xf8, 0x3e, 0x00, 0x03, 0xf0, 0x00, 0x1f, 0x07, 0xc0, 
0x00, 0x07, 0xe0, 0x00, 0x1f, 0x00, 0x01, 0xf8, 0x7e, 0x00, 0x00, 0x01, 0xf0, 0x00, 0x00, 0x07, 
0xff, 0xfc, 0x03, 0xe0, 0x3f, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xf8, 0x00, 0x3f, 0x00, 0xf8, 
0x3f, 0x00, 0x03, 0xf0, 0x00, 0x1f, 0x07, 0xc0, 0x00, 0x07, 0xe0, 0x00, 0x1f, 0x00, 0x01, 0xf8, 
0x7e, 0x03, 0xff, 0x81, 0xf0, 0x1f, 0xfc, 0x07, 0xff, 0xfc, 0x03, 0xff, 0xfe, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xf8, 0x00, 0x3f, 0x01, 0xf8, 0x3f, 0x00, 0x03, 0xf0, 0x00, 0x3f, 0x07, 0xe0, 
0x00, 0x07, 0xe0, 0x00, 0x3f, 0x00, 0x01, 0xf8, 0x7e, 0x07, 0xff, 0x83, 0xf0, 0x1f, 0xfe, 0x07, 
0xff, 0xfc, 0x03, 0xff, 0xfc, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xf8, 0x00, 0x3f, 0x01, 0xf8, 
0x1f, 0x00, 0x03, 0xf0, 0x00, 0x3e, 0x07, 0xe0, 0x00, 0x07, 0xe0, 0x00, 0x3f, 0x00, 0x01, 0xf8, 
0x7e, 0x07, 0xff, 0x83, 0xf0, 0x1f, 0xfe, 0x07, 0xff, 0xfc, 0x03, 0xff, 0xf8, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xf8, 0x00, 0x3f, 0x01, 0xf0, 0x1f, 0x80, 0x03, 0xf0, 0x00, 0x7e, 0x03, 0xe0, 
0x00, 0x07, 0xe0, 0x00, 0x1f, 0x00, 0x01, 0xf8, 0x7e, 0x07, 0xff, 0x81, 0xf0, 0x1f, 0xfe, 0x07, 
0xff, 0xfc, 0x03, 0xff, 0xfc, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xf8, 0x00, 0x3f, 0x03, 0xf0, 
0x1f, 0x80, 0x03, 0xf0, 0x00, 0x7e, 0x03, 0xf0, 0x00, 0x07, 0xe0, 0x00, 0x1f, 0x00, 0x01, 0xf8, 
0x7e, 0x07, 0xff, 0x81, 0xf0, 0x1f, 0xfe, 0x07, 0xe0, 0x00, 0x03, 0xe0, 0xfe, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xf8, 0x00, 0x3e, 0x03, 0xff, 0xff, 0x80, 0x03, 0xf0, 0x00, 0x7f, 0xff, 0xf0, 
0x00, 0x07, 0xe0, 0x00, 0x1f, 0x80, 0x01, 0xf0, 0x7e, 0x00, 0x0f, 0x81, 0xf0, 0x00, 0x7e, 0x07, 
0xe0, 0x00, 0x03, 0xe0, 0x7e, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xf8, 0x00, 0x7e, 0x03, 0xff, 
0xff, 0xc0, 0x03, 0xf0, 0x00, 0xff, 0xff, 0xf0, 0x00, 0x07, 0xe0, 0x00, 0x1f, 0x80, 0x03, 0xf0, 
0x7e, 0x00, 0x0f, 0x81, 0xf8, 0x00, 0x7e, 0x07, 0xe0, 0x00, 0x03, 0xe0, 0x3f, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xf8, 0x00, 0x7e, 0x07, 0xff, 0xff, 0xc0, 0x03, 0xf0, 0x00, 0xff, 0xff, 0xf8, 
0x00, 0x07, 0xe0, 0x00, 0x1f, 0x80, 0x03, 0xf0, 0x3f, 0x00, 0x0f, 0x81, 0xf8, 0x00, 0x7e, 0x07, 
0xe0, 0x00, 0x03, 0xe0, 0x3f, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xf8, 0x00, 0xfe, 0x07, 0xff, 
0xff, 0xc0, 0x03, 0xf0, 0x00, 0xff, 0xff, 0xf8, 0x00, 0x07, 0xe0, 0x00, 0x1f, 0xc0, 0x03, 0xf0, 
0x3f, 0x00, 0x0f, 0x81, 0xf8, 0x00, 0x7e, 0x07, 0xe0, 0x00, 0x03, 0xe0, 0x1f, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xf8, 0x01, 0xfc, 0x07, 0xff, 0xff, 0xe0, 0x03, 0xf0, 0x01, 0xff, 0xff, 0xfc, 
0x00, 0x07, 0xe0, 0x00, 0x0f, 0xc0, 0x07, 0xe0, 0x3f, 0x80, 0x1f, 0x80, 0xfc, 0x00, 0xfe, 0x07, 
0xe0, 0x00, 0x03, 0xe0, 0x1f, 0x80, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xf8, 0x03, 0xfc, 0x0f, 0xc0, 
0x07, 0xe0, 0x03, 0xf0, 0x01, 0xf8, 0x00, 0xfc, 0x00, 0x07, 0xe0, 0x00, 0x0f, 0xe0, 0x0f, 0xe0, 
0x1f, 0xc0, 0x3f, 0x80, 0xfe, 0x00, 0xfe, 0x07, 0xe0, 0x00, 0x03, 0xe0, 0x1f, 0x80, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xff, 0xff, 0xf8, 0x0f, 0xc0, 0x03, 0xe0, 0x03, 0xf0, 0x01, 0xf0, 0x00, 0xfc, 
0x00, 0x07, 0xff, 0xfe, 0x07, 0xfc, 0x7f, 0xc0, 0x1f, 0xf0, 0xff, 0x80, 0x7f, 0xc7, 0xfe, 0x07, 
0xff, 0xff, 0x03, 0xe0, 0x0f, 0x80, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x0f, 0x80, 
0x03, 0xf0, 0x03, 0xf0, 0x03, 0xf0, 0x00, 0x7e, 0x00, 0x07, 0xff, 0xfe, 0x03, 0xff, 0xff, 0x80, 
0x0f, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xfe, 0x07, 0xff, 0xff, 0x03, 0xe0, 0x0f, 0xc0, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xff, 0xff, 0xe0, 0x1f, 0x80, 0x03, 0xf0, 0x03, 0xf0, 0x03, 0xf0, 0x00, 0x7e, 
0x00, 0x07, 0xff, 0xfe, 0x01, 0xff, 0xff, 0x00, 0x07, 0xff, 0xef, 0x80, 0x3f, 0xff, 0x7e, 0x07, 
0xff, 0xff, 0x03, 0xe0, 0x0f, 0xc0, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0xff, 0xff, 0x80, 0x1f, 0x80, 
0x01, 0xf0, 0x03, 0xf0, 0x03, 0xe0, 0x00, 0x7e, 0x00, 0x07, 0xff, 0xfe, 0x00, 0xff, 0xfe, 0x00, 
0x03, 0xff, 0xcf, 0x80, 0x1f, 0xfe, 0x7e, 0x07, 0xff, 0xff, 0x03, 0xe0, 0x07, 0xc0, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x1f, 0x00, 0x01, 0xf8, 0x03, 0xf0, 0x07, 0xe0, 0x00, 0x3f, 
0x00, 0x07, 0xff, 0xfe, 0x00, 0x3f, 0xf8, 0x00, 0x00, 0xff, 0x8f, 0x80, 0x07, 0xfc, 0x7e, 0x07, 
0xff, 0xff, 0x03, 0xe0, 0x07, 0xe0, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x02, 0x30, 0x08, 0x00, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x30, 0x1c, 0x00, 0x00, 0x1c, 0x00, 0x0e, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x0c, 0x70, 0x1c, 0x00, 0x00, 0x1c, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x18, 0x00, 0x06, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x18, 0x61, 0x98, 0x46, 0x03, 0x98, 0x39, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x67, 0x18, 0xff, 0x0f, 0xf8, 0xff, 0x86, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x30, 0xee, 0x38, 0xf7, 0x8e, 0x78, 0xe7, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xec, 0x38, 0xe3, 0x9c, 0x39, 0xc3, 0x86, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x70, 0xf8, 0x38, 0xc3, 0x98, 0x31, 0x83, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xf8, 0x31, 0xc3, 0x18, 0x31, 0x83, 0x0e, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x70, 0xf8, 0x31, 0xc3, 0x38, 0x73, 0x87, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0xdc, 0x71, 0x87, 0x38, 0x73, 0x87, 0x0c, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x71, 0xcc, 0x71, 0x87, 0x1f, 0xf1, 0xdf, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x8e, 0x63, 0x86, 0x1f, 0xe1, 0xfe, 0x18, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x31, 0x86, 0x61, 0x06, 0x06, 0x60, 0x66, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};