# Pico MacroPad ライブラリ
[Click here to view the document in English.](/README.md)

Arduinoでマクロパッド(キーボード)の制御ができるようになるライブラリです。

このライブラリはキー入力の処理とマクロの管理を行うだけなので、HIDとして使用するには任意のHIDライブラリが必要です。(例: [Keyboardライブラリ](https://github.com/arduino-libraries/Keyboard))


このREADMEは`Keyboard.h`を使用する前提になっているため、キーボードの詳しい機能については[Keyboard](https://github.com/arduino-libraries/Keyboard)を確認してください。

__このライブラリはSTLを使用するため、STLが利用できる環境でのみ動作します。__
AVRマイコンなどデフォルトで対応していないプラットフォームの場合、別途ライブラリのインストールなどが必要になる場合があります。

## 機能
- `Do`
    - カスタムマクロを完結に定義できるようにするマクロです。
    - `Key`型の`key`という引数をとります。
    - 例: ```Do { Keyboard.print("Hello, world!"); }```
- `After`
    - `macroDelay()`関数で遅延した後に実行する内容を簡単に定義できるようにするマクロです。
    - 外側のスコープの`key`をキャプチャします。
    - 例: ```macroDelay(1000, After { Keyboard.print("Hello, world!"); });```

- `NONE`
    - 単なる`nullptr`の別名です。
    - 無効なキー割当を示すときに使えます。

- `pressTo()`
    - 通常のキーボードのようにそのキーを押している間PCに文字を送信するマクロを返します。
    - 対応しているHIDライブラリ(現在は`Keyboard.h`のみ)でのみ使用できます。

- `PRESS_A, PRESS_B,...`
    - `pressTo()`関数の単純なラッパーです。

## `MacroPad` について
- このライブラリの中心的なクラスです。
    - `init(LayeredKeymap)`
        - マクロパッドにキーマップを登録します。
        - 初期化の際に必ず実行してください。
    - `KEYS`
        - すべてのキーに対応する`Key`オブジェクトの配列です。
    - `LAYERS`
        - レイヤーを管理する`Layer`クラスのオブジェクトです。


## `Key` について
- このライブラリでは各キーに`Key`オブジェクトが割り当てられ、それが各キーの状態を管理します。
- 下記のインターフェースは一部抜粋しています。
    - `Event` 列挙体
        - 各キーで発生しているイベントを表します。
            |イベント名|条件|
            |----|----|
            |SINGLE|短く一回押した時|
            |LONG|長押しした時|
            |DOUBLE|短い間隔で2回連打した時|
            |RISING_EDGE|キーが押された瞬間|
            |FALLING_EDGE|キーが離された瞬間|
            |CHANGE_INPUT|キーの入力が切り替わった瞬間|
            |PRESSED|キーが押されている間|
            |RELEASED|キーが離されている間|

    - `init(longThreshold, doubleThreshold, debounceTime)`
        - 長押しと判定する時間、ダブルクリックと判定する猶予、デバウンス時間を指定します。
        - 例: `Key::init(1000, 500, 10);`
    - `bool hasOccurred(Key::Event)`
        - そのキーで指定したイベントが発生しているかどうかを調べます。
        - 例: `key.hasOccurred(Key::Event::SINGLE)`
    - `uint32_t getStateDuration()`
        - 最後に入力が切り替わってから何ミリ秒経ったかを返します。
        - 例: `key.getStateDuration()`
    - `uint8_t getCountOfClick()`
        - キーが何回連打されたかを表します。
        - `doubleThreshold`以上に間隔が開くとリセットされます。
        - このメソッドを使えば、255連打まで個別にイベントを設定できます。
    - `bool isPressed()`
        - キーが押されているかを返します。
        - `hasOccurred(Key::Event::PRESSED)`と同じです。
    - `uint32_t getPressTime()`
        - キーが押されている時間を返します。
        - 押されていない場合、`0`を返します。
    - `uint16_t getIndex()`
        - キーの番号を返します。

## カスタムマクロについて
※__｢`Do`マクロ｣の｢マクロ｣は`#define`ディレクティブで置換される構文を指します。これ以降、特に断りなく｢マクロ｣といった場合はキーイベントに対応して実行されるプログラムのことを指します。__
- カスタムマクロは`Do`マクロを使用して定義します。
    - マクロは実行される際、実行元の`Key`オブジェクトの参照を`key`引数として受け取ります。
- 内部では好きな処理を行うことが出来ますが、マクロの処理は同期的に行われるため、できるだけ速く処理できるように実装することをおすすめします。
- マクロはインデックスが小さい順に実行されます。
### `macroDelay(ms, func)`関数
- マクロ内で一定時間遅延させたい処理がある場合に使用します。
- 第一引数に待機時間(ミリ秒)、第二引数に実行させたい関数を渡します。
- 第二引数の関数は`After`マクロを使用して定義すると簡潔に表記できます。
- マクロ内で`delay()`関数を使うとすべての処理が止まってしまうため、特別な理由がない限りこの関数で代替してください。
- 時間の経過はポーリング式で判定されるため、精度はあまり高くありません。
- 例: ```macroDelay(1000, After { Keyboard.print("Hello, world!"); });```

### レイヤー機能について
- `MacroPad`のインスタンスを生成したときに指定した数のレイヤーが使用できます。(最大255)
- `MacroPad::init()`メソッドにキーマップを渡す際、指定したレイヤー数分のキーマップの配列が必要です。(サンプルコード参照)
- `Layer`クラスがレイヤーの管理を担当します。
    - `set(layer)`
        - 指定したレイヤーに移動します。
        - 存在しないレイヤーを指定した場合は何もしません。
        - 例: ```macroPad.LAYERS.set(1)```
    - `reset()`
        - 一つ前のレイヤーに戻ります。
        - 同じレイヤーに二度移動した後など、意図したとおりに動作しない場合があります。
    - `uint8_t get()`
        - 現在のレイヤーのインデックスを返します。
- `LayerUtil`クラスを使うことで、レイヤーを切り替えるマクロが簡単に設定できるようになります。
    - `KeyAssign to(layer)`
        - キーを押した時に指定したレイヤーに移動するマクロを返します。
        - 例: ```layer.to(1)```
    - `KeyAssign back(layer)`
        - キーを離したときに指定したレイヤーに移動するマクロを返します。
        - 例: ```layer.back(0)```
    - `KeyAssign reset()`
        - 一つ前のレイヤーに戻るマクロを返します。
        - 例: ```layer.reset()```