#include <Wire.h>
#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1327.h>
#include <Adafruit_BME280.h>

#define SDA_OLED 14  
#define SCL_OLED 10
#define SCREEN_ADDRESS 0x3C
TwoWire I2C_OLED = TwoWire(0);
Adafruit_SSD1327 display(128, 128, &I2C_OLED, -1);

// BME280 Sensor Configuration on I2C bus 1
#define SDA_BME 4
#define SCL_BME 5
#define BME_ADDRESS 0x76
TwoWire I2C_BME = TwoWire(1);
Adafruit_BME280 bme;

// 30x30 Thermometer Icon
const unsigned char thermometer_icon [] PROGMEM = {
0x00, 0x07, 0x80, 0x03, 0x00, 0x0F, 0xC0, 0x03, 
0x00, 0x18, 0x60, 0x03, 0x00, 0x18, 0x60, 0x03,
0x00, 0x18, 0x60, 0x03, 0x00, 0x18, 0x60, 0x03, 
0x00, 0x18, 0x60, 0x03, 0x00, 0x18, 0x60, 0x03,
0x00, 0x1B, 0x60, 0x03, 0x00, 0x1B, 0x60, 0x03, 
0x00, 0x1B, 0x60, 0x03, 0x00, 0x1B, 0x60, 0x03,
0x00, 0x1B, 0x60, 0x03, 0x00, 0x1B, 0x60, 0x03, 
0x00, 0x1B, 0x60, 0x03, 0x00, 0x1B, 0x20, 0x03,
0x00, 0x33, 0x30, 0x03, 0x00, 0x73, 0x18, 0x03, 
0x00, 0x63, 0x18, 0x03, 0x00, 0xC7, 0x8C, 0x03,
0x00, 0xCF, 0xCC, 0x03, 0x00, 0xCF, 0xCC, 0x03, 
0x00, 0xCF, 0xCC, 0x03, 0x00, 0x47, 0x88, 0x03,
0x00, 0x60, 0x18, 0x03, 0x00, 0x30, 0x30, 0x03, 
0x00, 0x1F, 0xE0, 0x03, 0x00, 0x07, 0x80, 0x03


};

// 30x30 Humidity Icon
const unsigned char humidity_icon [] PROGMEM = {
0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 
0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 
0x00, 0x06, 0x00, 0x03, 0x00, 0x06, 0x00, 0x03, 
0x00, 0x09, 0x00, 0x03, 0x00, 0x09, 0x80, 0x03, 
0x00, 0x10, 0x80, 0x03, 0x00, 0x30, 0x40, 0x03, 
0x00, 0x24, 0x40, 0x03, 0x00, 0x44, 0x20, 0x03, 
0x00, 0x48, 0x20, 0x03, 0x00, 0x88, 0x10, 0x03, 
0x00, 0x90, 0x08, 0x03, 0x01, 0x10, 0x08, 0x03, 
0x01, 0x20, 0x00, 0x03, 0x01, 0x21, 0x80, 0x03, 
0x01, 0x22, 0x44, 0x03, 0x01, 0x22, 0x48, 0x03, 
0x01, 0x11, 0x90, 0x03, 0x00, 0x88, 0x20, 0x03, 
0x00, 0xC0, 0x4E, 0x03, 0x00, 0x60, 0x9A, 0x03, 
0x00, 0x19, 0x12, 0x03, 0x00, 0x00, 0x0E, 0x03, 
0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03, 
0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x03
};

// 30x30 Pressure Icon
const unsigned char pressure_icon [] PROGMEM = {
0x00, 0x0f, 0xc0, 0x03, 0x00, 0x7f, 0xf8, 0x03, 
0x01, 0xf8, 0x7e, 0x03, 0x07, 0x80, 0x07, 0x83, 
0x0f, 0x0f, 0xc3, 0xc3, 0x1c, 0x33, 0x30, 0xe3, 
0x18, 0xc0, 0x0c, 0x63, 0x39, 0x88, 0x06, 0x73, 
0x33, 0x08, 0x03, 0x33, 0x62, 0x0c, 0x01, 0x1b, 
0x66, 0x0e, 0x01, 0x9b, 0x64, 0x0e, 0x00, 0x9b, 
0xe8, 0x0f, 0x80, 0x5f, 0xc8, 0x0c, 0xc0, 0x4f, 
0xc8, 0x08, 0x40, 0x4f, 0xc8, 0x08, 0x40, 0x4f, 
0xc8, 0x0c, 0xc0, 0x4f, 0xe8, 0x07, 0x80, 0x5f, 
0x64, 0x00, 0x00, 0x9b, 0x66, 0x00, 0x01, 0x9b, 
0x62, 0x00, 0x01, 0x1b, 0x30, 0x00, 0x00, 0x33, 
0x38, 0x00, 0x00, 0x73, 0x18, 0x00, 0x00, 0x63, 
0x1c, 0x00, 0x00, 0xe3, 0x0f, 0x00, 0x03, 0xc3,
0x07, 0x80, 0x07, 0x83, 0x01, 0xf8, 0x7e, 0x03, 
0x00, 0x7f, 0xf8, 0x03, 0x00, 0x0f, 0xc0, 0x03

};

void setup() {
  Serial.begin(9600);

  I2C_OLED.begin(SDA_OLED, SCL_OLED, 400000);
  I2C_BME.begin(SDA_BME, SCL_BME, 400000);

  if (!display.begin(SCREEN_ADDRESS)) {
    Serial.println("SSD1327 allocation failed.");
    while (1);
  }
  
  display.clearDisplay();
  display.setCursor(0, 10);
  display.println("Initializing...");
  display.display();

  if (!bme.begin(BME_ADDRESS, &I2C_BME)) {
    Serial.println("BME280 not found!");
    display.clearDisplay();
    display.setCursor(0, 20);
    display.println("BME280 Error!");
    display.display();
    while (1);
  }

  Serial.println("BME280 and OLED Initialized Successfully");
}

void loop() {
  sensors_event_t temp_event, pressure_event, humidity_event;
  bme.getTemperatureSensor()->getEvent(&temp_event);
  bme.getPressureSensor()->getEvent(&pressure_event);
  bme.getHumiditySensor()->getEvent(&humidity_event);
  
  Serial.print("Temperature: "); Serial.println(temp_event.temperature);
  Serial.print("Humidity: "); Serial.println(humidity_event.relative_humidity);
  Serial.print("Pressure: "); Serial.println(pressure_event.pressure);
  
  display.clearDisplay();
  
 // Temperature 
display.drawBitmap(5, 10, thermometer_icon, 30, 30, SSD1327_WHITE);
display.setCursor(40, 20);  
display.print(temp_event.temperature);
display.println(" C");

// Humidity 
display.drawBitmap(5, 50, humidity_icon, 30, 30, SSD1327_WHITE);
display.setCursor(40, 60);  
display.print(humidity_event.relative_humidity);
display.println(" %");

// Pressure 
display.drawBitmap(5, 90, pressure_icon, 30, 30, SSD1327_WHITE);
display.setCursor(40, 95);  
display.print(pressure_event.pressure);
display.println(" hPa");


  display.display();
  delay(1000);
}
