# M_RGB
Лёгкая библиотека для RGB светодиода/ленты, работает в цветовом пространстве HUE и RGB.
## Пример использования
### Значения
На вход принимает значения **от 0 до 255**.
Начиная с версии 1.2, можно работать **в пространстве RGB и значения от 0 до 255 надо давать для каждого цвета**.
### Подключение
Подключать **к любым ШИМ пинам(пины без ШИМ не использовать)**.
## Примеры кода
### Пример кода "Радуга" (HUE):
```cpp
#include"M_RGB.h" // обьявляем библиотеку

LED led1(6, 3, 5);  // создаём обьект (указывать в порядке Красный - зелёный - синий)| указывать-подключать только на шим пины

void setup() {
 Serial.begin(9600);  // обьявляем последовательный порт
  }

void loop() {
static byte c;  // переменная цвета
c++; // прибавляем знячение цвета
if(c > 255)c = 0; // обнуляем при переполнении
led1.setHUE(c); // обновляем цвет 
Serial.println(c);  // выводим цвет в порт
delay(100); // небольшая задержка(в настоящем проекте используйте таймер наа миллис)
}
```
https://github.com/user-attachments/assets/83a8e68d-8cdf-4e2d-8876-92eb741d0ef7
### Пример кода "пространство RGB":
```cpp
#include"M_RGB.h" // обьявляем библиотеку

LED led1(6, 3, 5);  // создаём обьект (указывать в порядке Красный - зелёный - синий)| указывать-подключать только на шим пины

void setup() {
 Serial.begin(9600);  // обьявляем последовательный порт
  }

void loop() {
byte R = 100; // уровень красного
byte G = 135; // уровень зелёного
byte B = 200; // уровень синего
led1.setRGB(R, G, B); // обновляем цвет (Получился приятный серо-синий цвет)
 }
```
https://github.com/user-attachments/assets/5af5a9b9-bac8-4c38-822f-5034306c652e
## Примечание
### Важно:
 На ESP подобных платформах надо снизить разрядность ШИМ до 10 бит - analogWriteResolution(8) в сетапе.
### По поводу ошибок:
Библиотека находится в разработке!
Все недостатки будут постепенно исправленны.
