/////////////////////////////////////////////////////////////////

#if !defined(ESP32)
  #error This sketch needs an ESP32
#else

/////////////////////////////////////////////////////////////////
#include "Button2.h"
/////////////////////////////////////////////////////////////////

#define BUTTON_PIN 39

/////////////////////////////////////////////////////////////////

Button2 btn;
hw_timer_t *timer = NULL;

/////////////////////////////////////////////////////////////////

void IRAM_ATTR onTimer() {
  btn.loop();
}

/////////////////////////////////////////////////////////////////

void click(Button2 &b) {
  Serial.println("click");
}

/////////////////////////////////////////////////////////////////

void setup() {
  Serial.begin(115200);

  btn.begin(BUTTON_PIN);
  btn.setTapHandler(click);
  
  timer = timerBegin(0, 80, true);
  timerAttachInterrupt(timer, &onTimer, true);
  timerAlarmWrite(timer, 10000, true); // every 0.1 seconds
  timerAlarmEnable(timer);
}

/////////////////////////////////////////////////////////////////

void loop() { 
}

/////////////////////////////////////////////////////////////////
#endif
/////////////////////////////////////////////////////////////////
