/////////////////////////////////////////////////////////////////

#if !defined(ESP32)
  #error This sketch needs an ESP32
#else

/////////////////////////////////////////////////////////////////

#include "Button2.h"

/////////////////////////////////////////////////////////////////

Button2 button;
byte pin = 4;

/////////////////////////////////////////////////////////////////

byte capStateHandler() {
    int capa = touchRead(pin);
    return capa < button.getDebounceTime() ? LOW : HIGH;
}

/////////////////////////////////////////////////////////////////

void click(Button2& btn) {
    Serial.println("click\n");
}

/////////////////////////////////////////////////////////////////

void setup() {
    Serial.begin(9600);
    delay(50);
    Serial.println("\n\nCapacitive Touch Demo");

    button.setDebounceTime(35);
    button.setButtonStateFunction(capStateHandler);
    button.setClickHandler(click);
    button.begin(BTN_VIRTUAL_PIN);
}

/////////////////////////////////////////////////////////////////

void loop() {
    button.loop();
}

/////////////////////////////////////////////////////////////////
#endif
/////////////////////////////////////////////////////////////////
