/**********************************************************************
  Font_5x7.h

  Robots-For-All (R4A)
  Font data for the Freenove 4WD Car 16x8 LED matrix
**********************************************************************/

#ifndef __R4A_FONT_5X7_H__
#define __R4A_FONT_5X7_H__

//  01234
//       0x01
//  *   *0x02
//   * * 0x04
//  *****0x08
//   * * 0x10
//  *   *0x20
//       0x40
//       0x80
const uint8_t r4a5x7Font_asterisk[5] = {0x2a, 0x1c, 0x08, 0x1c, 0x2a};
//  01234
//       0x01
//       0x02
//       0x04
//  *****0x08
//       0x10
//       0x20
//       0x40
//       0x80
const uint8_t r4a5x7Font_dash[5] = {0x08, 0x08, 0x08, 0x08, 0x08};
//  0
//   0x01
//   0x02
//   0x04
//   0x08
//   0x10
//   0x20
//  *0x40
//   0x80
const uint8_t r4a5x7Font_dp = 0x40;
//  01234
//   *** 0x01
//  *   *0x02
//  *   *0x04
//  *   *0x08
//  *   *0x10
//  *   *0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_0[5] = {0x3e, 0x41, 0x41, 0x41, 0x3e};
//  01234
//    *  0x01
//   **  0x02
//    *  0x04
//    *  0x08
//    *  0x10
//    *  0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_1[5] = {0x00, 0x42, 0x7f, 0x40, 0x00};
//  01234
//   *** 0x01
//  *   *0x02
//      *0x04
//   *** 0x08
//  *    0x10
//  *    0x20
//  *****0x40
//       0x80
const uint8_t r4a5x7Font_2[5] = {0x72, 0x49, 0x49, 0x49, 0x46};
//  01234
//   *** 0x01
//  *   *0x02
//      *0x04
//    ** 0x08
//      *0x10
//  *   *0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_3[5] = {0x22, 0x41, 0x49, 0x49, 0x36};
//  01234
//  *  * 0x01
//  *  * 0x02
//  *  * 0x04
//  *****0x08
//     * 0x10
//     * 0x20
//     * 0x40
//       0x80
const uint8_t r4a5x7Font_4[5] = {0x0f, 0x08, 0x08, 0x7f, 0x08};
//  01234
//  *****0x01
//  *    0x02
//  **** 0x04
//      *0x08
//      *0x10
//  *   *0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_5[5] = {0x27, 0x45, 0x45, 0x45, 0x39};
//  01234
//   *** 0x01
//  *   *0x02
//  *    0x04
//  **** 0x08
//  *   *0x10
//  *   *0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_6[5] = {0x3e, 0x49, 0x49, 0x49, 0x32};
//  01234
//  *****0x01
//      *0x02
//     * 0x04
//   *** 0x08
//   *   0x10
//  *    0x20
//  *    0x40
//       0x80
const uint8_t r4a5x7Font_7[5] = {0x61, 0x19, 0x09, 0x0d, 0x03};
//  01234
//   *** 0x01
//  *   *0x02
//  *   *0x04
//   *** 0x08
//  *   *0x10
//  *   *0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_8[5] = {0x36, 0x49, 0x49, 0x49, 0x36};
//  01234
//   *** 0x01
//  *   *0x02
//  *   *0x04
//   ****0x08
//      *0x10
//  *   *0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_9[5] = {0x26, 0x49, 0x49, 0x49, 0x3e};
//  01234
//   *** 0x01
//  *   *0x02
//  *   *0x04
//  *****0x08
//  *   *0x10
//  *   *0x20
//  *   *0x40
//       0x80
const uint8_t r4a5x7Font_A[5] = {0x7e, 0x09, 0x09, 0x09, 0x7e};
//  01234
//  **** 0x01
//  *   *0x02
//  *   *0x04
//  **** 0x08
//  *   *0x10
//  *   *0x20
//  **** 0x40
//       0x80
const uint8_t r4a5x7Font_B[5] = {0x7f, 0x49, 0x49, 0x49, 0x36};
//  01234
//   *** 0x01
//  *   *0x02
//  *    0x04
//  *    0x08
//  *    0x10
//  *   *0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_C[5] = {0x3e, 0x41, 0x41, 0x41, 0x22};
//  01234
//  ***  0x01
//  *  * 0x02
//  *   *0x04
//  *   *0x08
//  *   *0x10
//  *  * 0x20
//  ***  0x40
//       0x80
const uint8_t r4a5x7Font_D[5] = {0x7f, 0x41, 0x41, 0x22, 0x1c};
//  01234
//  *****0x01
//  *    0x02
//  *    0x04
//  ***  0x08
//  *    0x10
//  *    0x20
//  *****0x40
//       0x80
const uint8_t r4a5x7Font_E[5] = {0x7f, 0x49, 0x49, 0x41, 0x41};
//  01234
//  *****0x01
//  *    0x02
//  *    0x04
//  **** 0x08
//  *    0x10
//  *    0x20
//  *    0x40
//       0x80
const uint8_t r4a5x7Font_F[5] = {0x7f, 0x09, 0x09, 0x09, 0x01};
//  01234
//   *** 0x01
//  *   *0x02
//  *    0x04
//  *    0x08
//  *  **0x10
//  *   *0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_G[5] = {0x3e, 0x41, 0x41, 0x51, 0x32};
//  01234
//  *   *0x01
//  *   *0x02
//  *   *0x04
//  *****0x08
//  *   *0x10
//  *   *0x20
//  *   *0x40
//       0x80
const uint8_t r4a5x7Font_H[5] = {0x7f, 0x08, 0x08, 0x08, 0x7f};
//  01234
//   *** 0x01
//    *  0x02
//    *  0x04
//    *  0x08
//    *  0x10
//    *  0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_I[5] = {0x00, 0x41, 0x7f, 0x41, 0x00};
//  01234
//       0x01
//       0x02
//   *** 0x04
//      *0x08
//   ****0x10
//  *   *0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_a[5] = {0x20, 0x54, 0x54, 0x54, 0x38};
//  01234
//  *    0x01
//  *    0x02
//  *    0x04
//  **** 0x08
//  *   *0x10
//  *   *0x20
//  **** 0x40
//       0x80
const uint8_t r4a5x7Font_b[5] = {0x7f, 0x48, 0x48, 0x48, 0x30};
//  01234
//       0x01
//       0x02
//       0x04
//   *** 0x08
//  *    0x10
//  *    0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_c[5] = {0x30, 0x48, 0x48, 0x48, 0x00};
//  01234
//      *0x01
//      *0x02
//      *0x04
//   ****0x08
//  *   *0x10
//  *   *0x20
//   ***0x40
//       0x80
const uint8_t r4a5x7Font_d[5] = {0x30, 0x48, 0x48, 0x48, 0x7f};
//  01234
//       0x01
//       0x02
//   *** 0x04
//  *   *0x08
//  **** 0x10
//  *    0x20
//   *** 0x40
//       0x80
const uint8_t r4a5x7Font_e[5] = {0x38, 0x54, 0x54, 0x54, 0x08};
//  01234
//   *** 0x01
//  *   *0x02
//  *    0x04
//  **** 0x08
//  *    0x10
//  *    0x20
//  *    0x40
//       0x80
const uint8_t r4a5x7Font_f[5] = {0x7e, 0x09, 0x09, 0x09, 0x02};
//  01234
//       0x01
//       0x02
//   *** 0x04
//  *   *0x08
//  *   *0x10
//   ****0x20
//      *0x40
//   *** 0x80
const uint8_t r4a5x7Font_g[5] = {0x18, 0xa4, 0xa4, 0xa4, 0x78};
//  01234
//  *    0x01
//  *    0x02
//  *    0x04
//  **** 0x08
//  *   *0x10
//  *   *0x20
//  *   *0x40
//       0x80
const uint8_t r4a5x7Font_h[5] = {0x7f, 0x08, 0x08, 0x08, 0x70};
//  0
//  *0x01
//  *0x02
//  *0x04
//  *0x08
//  *0x10
//  *0x20
//  *0x40
//   0x80
const uint8_t r4a5x7Font_l = 0x7f;
//  01234
//   *   0x01
//   *   0x02
//  ***  0x04
//   *   0x08
//   *   0x10
//   *  *0x20
//    ** 0x40
//       0x80
const uint8_t r4a5x7Font_t[5] = {0x04, 0x3f, 0x44, 0x40, 0x20};

// Addresses of the pixel arrays for the hexadecimal numbers
const uint8_t * r4a5x7Numbers[] =
{
    r4a5x7Font_0,   // 0
    r4a5x7Font_1,   // 1
    r4a5x7Font_2,   // 2
    r4a5x7Font_3,   // 3
    r4a5x7Font_4,   // 4
    r4a5x7Font_5,   // 5
    r4a5x7Font_6,   // 6
    r4a5x7Font_7,   // 7
    r4a5x7Font_8,   // 8
    r4a5x7Font_9,   // 9
};

const uint8_t * r4a5x7UcAtoI[] =
{
    r4a5x7Font_A,   // A
    r4a5x7Font_B,   // B
    r4a5x7Font_C,   // C
    r4a5x7Font_D,   // D
    r4a5x7Font_E,   // E
    r4a5x7Font_F,   // F
    r4a5x7Font_G,   // G
    r4a5x7Font_H,   // H
    r4a5x7Font_I,   // I
};

const uint8_t * r4a5x7LcAtoH[] =
{
    r4a5x7Font_a,   // a
    r4a5x7Font_b,   // b
    r4a5x7Font_c,   // c
    r4a5x7Font_d,   // d
    r4a5x7Font_e,   // e
    r4a5x7Font_f,   // f
    r4a5x7Font_g,   // g
    r4a5x7Font_h,   // h
};

#endif  // __R4A_FONT_5X7_H__
