#ifndef AVR_FHT_FHT_WINDOW_H
#define AVR_FHT_FHT_WINDOW_H

#include <AvrFHT.h>

// lookup values for a hann window
// signed 16b format
extern const int16_t __attribute__((used)) _window_func[] PROGMEM = {
#if (FHT_SAMPLES_N ==  256)
    0,5,20,45,80,124,179,243,317,401,495,598,711,833,965,1106,1257,1416,1585,1763,1949,2145,2349,2561,2782,3011,3249,3494,3747,4008,4276,4552,4834,5124,5421,5724,6034,6350,6672,7000,7334,7673,8018,8367,8722,9081,9445,9812,10184,10560,10939,11321,11707,12095,12486,12879,13274,13672,14070,14471,14872,15275,15678,16081,16485,16889,17292,17695,18097,18498,18897,19295,19692,20086,20478,20868,21255,21639,22019,22397,22770,23140,23506,23867,24224,24576,24923,25265,25602,25932,26258,26577,26890,27196,27496,27789,28076,28355,28627,28892,29148,29398,29639,29872,30097,30314,30522,30722,30913,31095,31268,31432,31588,31733,31870,31997,32115,32223,32321,32410,32489,32558,32618,32667,32707,32737,32757,32767,32767,32757,32737,32707,32667,32618,32558,32489,32410,32321,32223,32115,31997,31870,31733,31588,31432,31268,31095,30913,30722,30522,30314,30097,29872,29639,29398,29148,28892,28627,28355,28076,27789,27496,27196,26890,26577,26258,25932,25602,25265,24923,24576,24224,23867,23506,23140,22770,22397,22019,21639,21255,20868,20478,20086,19692,19295,18897,18498,18097,17695,17292,16889,16485,16081,15678,15275,14872,14471,14070,13672,13274,12879,12486,12095,11707,11321,10939,10560,10184,9812,9445,9081,8722,8367,8018,7673,7334,7000,6672,6350,6034,5724,5421,5124,4834,4552,4276,4008,3747,3494,3249,3011,2782,2561,2349,2145,1949,1763,1585,1416,1257,1106,965,833,711,598,495,401,317,243,179,124,80,45,20,5,0
#elif (FHT_SAMPLES_N ==  128)
    0,20,80,180,320,499,717,973,1267,1597,1965,2367,2804,3273,3775,4308,4871,5461,6078,6721,7387,8075,8784,9511,10255,11014,11786,12569,13362,14162,14967,15776,16587,17397,18204,19007,19804,20592,21370,22136,22887,23623,24341,25039,25717,26371,27001,27606,28182,28730,29247,29734,30187,30607,30991,31341,31653,31928,32165,32364,32523,32643,32723,32763,32763,32723,32643,32523,32364,32165,31928,31653,31341,30991,30607,30187,29734,29247,28730,28182,27606,27001,26371,25717,25039,24341,23623,22887,22136,21370,20592,19804,19007,18204,17397,16587,15776,14967,14162,13362,12569,11786,11014,10255,9511,8784,8075,7387,6721,6078,5461,4871,4308,3775,3273,2804,2367,1965,1597,1267,973,717,499,320,180,80,20,0
#elif (FHT_SAMPLES_N ==  64)
    0,81,325,728,1287,1995,2847,3833,4944,6169,7495,8909,10398,11947,13539,15160,16792,18421,20030,21602,23123,24576,25948,27225,28394,29444,30364,31145,31780,32261,32585,32748,32748,32585,32261,31780,31145,30364,29444,28394,27225,25948,24576,23123,21602,20030,18421,16792,15160,13539,11947,10398,8909,7495,6169,4944,3833,2847,1995,1287,728,325,81,0
#elif (FHT_SAMPLES_N ==  32)
    0,335,1328,2937,5096,7717,10694,13903,17214,20491,23599,26413,28815,30709,32017,32684,32684,32017,30709,28815,26413,23599,20491,17214,13903,10694,7717,5096,2937,1328,335,0
#elif (FHT_SAMPLES_N ==  16)
    0,1416,5421,11321,18097,24576,29639,32410,32410,29639,24576,18097,11321,5421,1416,0
#endif
};

static inline void fht_window() {
    // save registers that are getting clobbered
    // avr-gcc requires r2:r17,r28:r29, and r1 cleared
    asm volatile (
        "push r2 \n"
        "push r3 \n"
        "push r4 \n"
        "push r5 \n"
        "push r15 \n"
        "push r16 \n"
        "push r17 \n"
        "push r28 \n"
        "push r29 \n"
    );

    // this applies a window to the data for better frequency resolution
    asm volatile (
        "ldi r28, lo8(fht_input) \n" // set to beginning of data space
        "ldi r29, hi8(fht_input) \n"
        "ldi r30, lo8(_window_func) \n" // set to beginning of lookup table
        "ldi r31, hi8(_window_func) \n"
        "clr r15 \n" // prep null register
        "ldi r20, " STRINGIFY(((FHT_SAMPLES_N) & (0xff))) " \n"

        "1: \n"
        "lpm r22,z+ \n" // fetch window value
        "lpm r23,z+ \n"
        "ld r16,y \n" // fetch data
        "ldd r17,y+1 \n"

        // multiply by window
        "fmuls r17,r23 \n"
        "movw r4,r0 \n"
        "fmul r16,r22 \n"
        "adc r4,r15 \n"
        "movw r2,r0 \n"
        "fmulsu r17,r22 \n"
        "sbc r5,r15 \n"
        "add r3,r0 \n"
        "adc r4,r1 \n"
        "adc r5,r15 \n"
        "fmulsu r23,r16 \n"
        "sbc r5,r15 \n"
        "add r3,r0 \n"
        "adc r4,r1 \n"
        "adc r5,r15 \n"

        "st y+,r4 \n" // restore data
        "st y+,r5 \n"
        "dec r20 \n" // check if done
        "brne 1b \n"
        : :
        : "r0", "r20", "r30", "r31", "r22", "r23" // clobber list
    );

    // get the clobbers off the stack
    asm volatile (
        "pop r29 \n"
        "pop r28 \n"
        "pop r17 \n"
        "pop r16 \n"
        "pop r15 \n"
        "pop r5 \n"
        "pop r4 \n"
        "pop r3 \n"
        "pop r2 \n"
        "clr r1 \n" // reset c compiler null register
    );
}

#endif //AVR_FHT_FHT_WINDOW_H