#ifndef KID_SENSORS_H
#define KID_SENSORS_H

#include <Arduino.h>  // Базовые функции Arduino

class KidSensors {
public:
    KidSensors() = default;  // Конструктор по умолчанию
    ~KidSensors() = default; // Деструктор

    // Базовый абстрактный класс для всех датчиков
    class Sensor {
    public:
        virtual ~Sensor() = default;  // Виртуальный деструктор
        virtual float getValue() = 0; // Получение текущего значения
        virtual void calculate(unsigned int interval = 20) = 0; // Обновление данных
    };

    // Класс для работы с термисторами
    class Termistor : public Sensor {
    public:
        Termistor();  // Добавлен конструктор по умолчанию
        Termistor(uint8_t _pin, int _b = 3950, int _nominal = 25, 
                  int _thermistor = 10000, int _resistor = 10000);

        void begin(uint8_t _pin, int _b = 3950, int _nominal = 25, 
                   int _thermistor = 10000, int _resistor = 10000); // Метод инициализации

        void calculate(unsigned int interval) override;
        float getValue() override;
    
    private:
        uint8_t pin;       // Аналоговый пин
        int b;             // Бета-коэффициент
        int nominal;       // Номинальная температура
        int thermistor;    // Номинальное сопротивление термистора
        int resistor;      // Опорное сопротивление

        unsigned long lastCalculate; // Время последнего обновления
        float temperature;           // Текущая температура
    };

    // Объект термистора (не указатель, а сам объект)
    Termistor termistor;
};

#endif
