#include "kid_Sensors.h"
#include <math.h>

// Конструктор по умолчанию
KidSensors::Termistor::Termistor() 
    : pin(255), b(3950), nominal(25), thermistor(10000), resistor(10000),
      lastCalculate(0), temperature(-273.15) {}

// Конструктор с параметрами
KidSensors::Termistor::Termistor(uint8_t _pin, int _b, int _nominal,
                                 int _thermistor, int _resistor)
    : pin(_pin), b(_b), nominal(_nominal), thermistor(_thermistor),
      resistor(_resistor), lastCalculate(0), temperature(-273.15) {}

// Метод инициализации термистора
void KidSensors::Termistor::begin(uint8_t _pin, int _b, int _nominal,
                                  int _thermistor, int _resistor) {
    pin = _pin;
    b = _b;
    nominal = _nominal;
    thermistor = _thermistor;
    resistor = _resistor;
    lastCalculate = 0;
    temperature = -273.15;
}

void KidSensors::Termistor::calculate(unsigned int interval) {
    unsigned long currentMillis = millis();

    // Проверка необходимости обновления температуры
    if (interval == 0 || (currentMillis - lastCalculate >= interval) || (lastCalculate > currentMillis)) {
        int raw = analogRead(pin);

        // Защита от некорректных значений (0 и 1023)
        if (raw <= 0 || raw >= 1023) {
            temperature = -273.15; // Установка значения по умолчанию
            return;
        }

        // Расчет сопротивления термистора для схемы: [VCC] -- [Резистор] -- [Пин] -- [Термистор] -- [GND]
        float thermistorResistance = resistor * (raw / (1023.0 - raw));

        // Уравнение Стейнхарта-Харта
        float steinhart = log(thermistorResistance / thermistor); // ln(R/Ro)
        steinhart /= b;                                           // (1/B) * ln(R/Ro)
        steinhart += 1.0 / (nominal + 273.15);                    // + (1/To)
        steinhart = 1.0 / steinhart;                              // Инвертирование
        temperature = steinhart - 273.15;                         // Конвертация в °C

        lastCalculate = currentMillis;
    }
}

// Получение значения температуры
float KidSensors::Termistor::getValue() {
    return temperature;
}
