#include <Arduino.h>
#include <kid_Sensors.h>  // Подключаем нашу библиотеку

KidSensors sensors; // Создаем объект менеджера датчиков

void setup() {
  Serial.begin(9600);
  // Инициализируем термистор на пине A0 с параметрами по умолчанию
  sensors.termistor.begin(A0);
  
  // Для кастомных параметров (пример термистора 100K):
  // sensors.termistor = new KidSensors::Termistor(
  //   A0,          // Пин
  //   3950,        // B-коэффициент
  //   25,          // Номинальная температура (25°C)
  //   100000,      // Сопротивление термистора при 25°C (100K)
  //   10000        // Опорный резистор (10K)
  // );

  Serial.println("Termistor example started");
}

void loop() {
  // Вызываем расчет температуры каждые 1000 мс
  sensors.termistor.calculate(1000);
  
  // Получаем и выводим температуру
  float temp = sensors.termistor.getValue();
  
  // Проверяем валидность значения (-273.15 = ошибка измерения)
  if(temp > -273) {
    Serial.print("Temperature: ");
    Serial.print(temp);
    Serial.println(" °C");
  } else {
    Serial.println("Measurement error!");
  }
  
  delay(500); // Общая задержка для стабильности вывода
}

/* Пример использования через полиморфизм:
void advancedExample() {
  KidSensors::Sensor* sensor = new KidSensors::Termistor(A1);
  
  while(true) {
    sensor->calculate(2000);
    float t = sensor->getValue();
    
    if(t > -273) {
      Serial.print("Polymorphic temp: ");
      Serial.println(t);
    }
    
    delay(100);
  }
}
*/
