#include <Adafruit_NeoPixel.h>
#include <kid_LED_Effects.h>

#define LED_PIN 6      // Пин, к которому подключена лента
#define NUM_LEDS 30    // Количество светодиодов

Adafruit_NeoPixel strip(NUM_LEDS, LED_PIN, NEO_GRB + NEO_KHZ800);
KidLedEffects ledEffects(strip, NUM_LEDS);

void setup() {
    strip.begin();
    strip.show();  // Очищаем ленту при запуске
    Serial.begin(9600);

    // Выбираем начальный эффект
    ledEffects.setEffect(&ledEffects.matrix);
    ledEffects.matrix.setSpeed(1);
    ledEffects.matrix.setBrightness(0.05);
    
    ledEffects.rainbow.setSpeed(1);
    ledEffects.rainbow.setBrightness(0.5);
    
    ledEffects.fire.setSpeed(3);
    ledEffects.fire.setBrightness(0.05);

    ledEffects.water.setSpeed(0.5);
    ledEffects.water.setBrightness(0.1);
}

void loop() {
    static unsigned long lastChangeTime = 0; // Время последнего переключения
    static int effectIndex = 0;              // Индекс текущего эффекта
    const unsigned long effectDuration = 60000; // 1 минута (60 000 мс)

    // Проверяем, прошло ли достаточно времени для смены эффекта
    if (millis() - lastChangeTime > effectDuration) {
        lastChangeTime = millis(); // Обновляем время последнего переключения
        effectIndex = (effectIndex + 1) % 4; // Циклически переключаем эффекты

        // Выбираем эффект в зависимости от индекса
        switch (effectIndex) {
            case 0:
                ledEffects.setEffect(&ledEffects.matrix);
                Serial.println("Effect: Matrix");
                break;
            case 1:
                ledEffects.setEffect(&ledEffects.rainbow);
                Serial.println("Effect: Rainbow");
                break;
            case 2:
                ledEffects.setEffect(&ledEffects.fire);
                Serial.println("Effect: Fire");
                break;
            case 3:
                ledEffects.setEffect(&ledEffects.water);
                Serial.println("Effect: Water");
                break;
        }
    }

    // Обрабатываем текущий эффект
    ledEffects.process(1);
}
