// SPDX-FileCopyrightText: 2025 KOINSLOT, Inc.
// SPDX-License-Identifier: GPL-3.0-or-later

/*
 * Auto-generated header file from stone.bmp
 * Sprite sheet: 3x4 frames
 * Frame size: 64x64 pixels
 * Total frames: 12
 * Format: 1-bit packed bitmap (0=black, 1=white)
 * Generated: 2025-06-29 12:14:54
 *
 * Usage in Kywy projects:
 *   #include "stone.h"
 *
 *   // Draw individual frames:
 *   engine.display.drawBitmap(x, y, STONE_FRAME_WIDTH,
 *                            STONE_FRAME_HEIGHT, STONE_frame_0);
 *
 *   // Animate through frames:
 *   const uint8_t* frames[] = {STONE_frame_0, STONE_frame_1, STONE_frame_2,
 * STONE_frame_3, STONE_frame_4, STONE_frame_5, STONE_frame_6, STONE_frame_7,
 * STONE_frame_8, STONE_frame_9, STONE_frame_10, STONE_frame_11};
 *   engine.display.drawBitmap(x, y, STONE_FRAME_WIDTH,
 *                            STONE_FRAME_HEIGHT, frames[currentFrame]);
 */

#ifndef STONE_H
#define STONE_H

#include <stdint.h>

// Sprite sheet information
#define STONE_FRAME_WIDTH 64
#define STONE_FRAME_HEIGHT 64
#define STONE_FRAME_COUNT 12
#define STONE_SPRITE_COLS 3
#define STONE_SPRITE_ROWS 4

// Frame 0 bitmap data (512 bytes)
const uint8_t STONE_frame_0[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xaf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x6f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xf7, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xfe, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x27, 0xfd,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xf9, 0xfb, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xfe, 0xbe, 0x77, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xdf, 0x8f,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x6f, 0x6f, 0xf7, 0xf0, 0x7f, 0xff,
  0xff, 0x1f, 0x76, 0xa7, 0xf7, 0xf7, 0xbf, 0xff, 0xfe, 0xe7, 0xb9, 0xab,
  0xf7, 0xf7, 0xdf, 0xff, 0xfd, 0x99, 0xbb, 0xdd, 0xef, 0xf7, 0xef, 0xff,
  0xfb, 0x7c, 0xd7, 0xee, 0xef, 0xf7, 0x8f, 0xff, 0xfb, 0xf3, 0x6f, 0xef,
  0x6f, 0xc8, 0x5f, 0xff, 0xf7, 0xef, 0x6f, 0xef, 0xaf, 0x3b, 0xdf, 0xff,
  0xf7, 0xff, 0x5f, 0xdf, 0xcc, 0xfb, 0xbf, 0xff, 0xf7, 0xff, 0x5f, 0xdf,
  0xf3, 0xfb, 0xbf, 0xff, 0xfb, 0xff, 0x5f, 0xdf, 0xff, 0xfb, 0x7f, 0xff,
  0xfb, 0xff, 0x6f, 0xe0, 0xbd, 0x88, 0xff, 0xff, 0xfb, 0xff, 0x57, 0xe1,
  0x5b, 0x23, 0xff, 0xff, 0xfd, 0xfc, 0xdb, 0xf0, 0x18, 0x0b, 0xff, 0xff,
  0xfe, 0xf2, 0xdd, 0xf0, 0x3e, 0x0b, 0xff, 0xff, 0xfe, 0x0f, 0x5d, 0xf0,
  0x67, 0x1b, 0xff, 0xff, 0xfe, 0xff, 0x5e, 0xef, 0xe7, 0xfb, 0xff, 0xff,
  0xff, 0x7f, 0x2f, 0x5f, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xbe, 0xc7, 0x5c,
  0x00, 0xf7, 0xff, 0xff, 0xff, 0xcd, 0xf0, 0xbb, 0xff, 0x6f, 0xff, 0xff,
  0xff, 0xf3, 0xef, 0x37, 0xff, 0x5f, 0xe7, 0xff, 0xff, 0xfb, 0xdf, 0xb7,
  0xff, 0x9f, 0xdb, 0xff, 0xff, 0xfc, 0xdf, 0xc7, 0xff, 0x5f, 0xbc, 0x3f,
  0xff, 0xff, 0x5f, 0xd8, 0x00, 0xdc, 0x3d, 0xbf, 0xff, 0xff, 0x9f, 0xdf,
  0xbd, 0x93, 0x3d, 0xdf, 0xff, 0xff, 0xef, 0xbf, 0xbc, 0x6f, 0x3d, 0xdf,
  0xff, 0xff, 0xf0, 0x7f, 0xbd, 0xee, 0xdb, 0x9f, 0xff, 0xff, 0xff, 0x7f,
  0x7e, 0xde, 0xe7, 0x5f, 0xff, 0xff, 0xfe, 0x3c, 0xfe, 0xde, 0xf8, 0xdf,
  0xff, 0xff, 0xfd, 0xc3, 0xf8, 0x2e, 0xf7, 0xdf, 0xff, 0xff, 0xfd, 0xdf,
  0xf7, 0x73, 0x77, 0x9f, 0xff, 0xff, 0xfd, 0xbf, 0xf7, 0x7c, 0x38, 0x3f,
  0xff, 0xff, 0xf8, 0x3f, 0xf7, 0x7f, 0xd7, 0xbf, 0xff, 0xff, 0xc6, 0x1f,
  0xf0, 0x3f, 0xe7, 0x7f, 0xff, 0xff, 0xbf, 0x00, 0x03, 0xcf, 0xf8, 0xff,
  0xff, 0xff, 0xbf, 0x8f, 0xe7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xdf,
  0xdf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xdf, 0xdf, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0x7f, 0xdf, 0xdf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xdf,
  0xdf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x00, 0x1f, 0xe0, 0x03, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 1 bitmap data (512 bytes)
const uint8_t STONE_frame_1[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xaf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xfe,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x27, 0xfd, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xfe, 0xf9, 0xfb, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xbe, 0x77,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xdf, 0x8f, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xe3, 0x6f, 0x6f, 0xf7, 0xf0, 0x7f, 0xff, 0xff, 0xdc, 0xb6, 0xa7,
  0xf7, 0xf7, 0xbf, 0xff, 0xff, 0xb3, 0x19, 0xab, 0xf7, 0xf7, 0xdf, 0xff,
  0xff, 0x6f, 0x8b, 0xdd, 0xef, 0xf7, 0xef, 0xff, 0xff, 0x7e, 0x67, 0xee,
  0xef, 0xf7, 0x8f, 0xff, 0xfe, 0xfd, 0xef, 0xef, 0x6f, 0xc8, 0x5f, 0xff,
  0xfe, 0xff, 0xef, 0xef, 0xaf, 0x3b, 0xdf, 0xff, 0xfe, 0xff, 0xef, 0xdf,
  0xcc, 0xfb, 0xbf, 0xff, 0xff, 0x7f, 0xef, 0xdf, 0xf3, 0xfb, 0xbf, 0xff,
  0xff, 0x7f, 0xef, 0xdf, 0xff, 0xfb, 0x7f, 0xff, 0xff, 0x7f, 0xef, 0xe0,
  0xbd, 0x88, 0xff, 0xff, 0xff, 0xbf, 0x87, 0xe1, 0x5b, 0x23, 0xff, 0xff,
  0xff, 0xde, 0x4b, 0xf0, 0x18, 0x0b, 0xff, 0xff, 0xff, 0xc1, 0xed, 0xf0,
  0x3e, 0x0b, 0xff, 0xff, 0xff, 0xdf, 0xed, 0xf0, 0x67, 0x1b, 0xff, 0xff,
  0xff, 0xef, 0xc6, 0xef, 0xe7, 0xfb, 0xff, 0xff, 0xff, 0xf7, 0xc3, 0x5f,
  0xff, 0xf7, 0xff, 0xff, 0xff, 0xf9, 0xb9, 0x5c, 0x00, 0xf7, 0xff, 0xff,
  0xff, 0xfe, 0x76, 0xbb, 0xff, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x6f, 0x37,
  0xff, 0x5f, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xb7, 0xff, 0x9f, 0xff, 0xff,
  0xff, 0xff, 0xaf, 0xc7, 0xff, 0x5f, 0x9f, 0xff, 0xff, 0xff, 0xcf, 0xd8,
  0x00, 0xdf, 0x6f, 0xff, 0xff, 0xff, 0xf7, 0xbf, 0xbc, 0x26, 0xf1, 0xff,
  0xff, 0xff, 0xf8, 0x7f, 0xbd, 0xc8, 0xf6, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0x7e, 0xdc, 0xf7, 0x7f, 0xff, 0xff, 0xfe, 0x3c, 0xfe, 0xbc, 0xf7, 0x7f,
  0xff, 0xff, 0xfe, 0x03, 0xf8, 0x3b, 0x6e, 0x7f, 0xff, 0xff, 0xfe, 0xfb,
  0xf7, 0x5b, 0x9d, 0x7f, 0xff, 0xff, 0xfd, 0xfd, 0xf7, 0x6b, 0xe3, 0x7f,
  0xff, 0xff, 0xfd, 0xfe, 0xf6, 0xeb, 0xdf, 0x7f, 0xff, 0xff, 0xfb, 0xfe,
  0xe0, 0xf5, 0xde, 0x7f, 0xff, 0xff, 0xfb, 0xfe, 0x1f, 0x38, 0xe0, 0xff,
  0xff, 0xff, 0xfb, 0xfe, 0x3f, 0xdf, 0x5e, 0xff, 0xff, 0xff, 0xfb, 0xfe,
  0x7f, 0xef, 0x9d, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x7f, 0xef, 0xe3, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x7f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x7f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x1f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 2 bitmap data (512 bytes)
const uint8_t STONE_frame_2[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xaf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x6f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xf7, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xfe, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x27, 0xfd,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xf9, 0xfb, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xfe, 0xbe, 0x77, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xdf, 0x8f,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x6f, 0x6f, 0xf7, 0xf0, 0x7f, 0xff,
  0xff, 0xff, 0x76, 0xa7, 0xf7, 0xf7, 0xbf, 0xff, 0xff, 0xc7, 0xb9, 0xab,
  0xf7, 0xf7, 0xdf, 0xff, 0xff, 0xb9, 0xbb, 0xdd, 0xef, 0xf7, 0xef, 0xff,
  0xff, 0x66, 0x57, 0xee, 0xef, 0xf7, 0x8f, 0xff, 0xfe, 0xdf, 0x2f, 0xef,
  0x6f, 0xc8, 0x5f, 0xff, 0xfe, 0xfc, 0xcf, 0xef, 0xaf, 0x3b, 0xdf, 0xff,
  0xfd, 0xfb, 0xdf, 0xdf, 0xcc, 0xfb, 0xbf, 0xff, 0xfd, 0xff, 0xdf, 0xdf,
  0xf3, 0xfb, 0xbf, 0xff, 0xfd, 0xff, 0xdf, 0xdf, 0xff, 0xfb, 0x7f, 0xff,
  0xfe, 0xff, 0xcf, 0xe0, 0xbd, 0x88, 0xff, 0xff, 0xfe, 0xff, 0xd7, 0xe1,
  0x5b, 0x23, 0xff, 0xff, 0xfe, 0xff, 0xdb, 0xf0, 0x18, 0x0b, 0xff, 0xff,
  0xff, 0x7f, 0x1d, 0xf0, 0x3e, 0x0b, 0xff, 0xff, 0xff, 0xbc, 0x9d, 0xf0,
  0x67, 0x1b, 0xff, 0xff, 0xff, 0x83, 0xde, 0xef, 0xe7, 0xfb, 0xff, 0xff,
  0xff, 0xbf, 0xcf, 0x5f, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xdf, 0xc7, 0x5c,
  0x00, 0xf7, 0xff, 0xff, 0xff, 0xef, 0xb0, 0xbb, 0xff, 0x6f, 0xff, 0xff,
  0xff, 0xf3, 0x6f, 0x37, 0xff, 0x5f, 0xcf, 0xff, 0xff, 0xfc, 0xdf, 0xb7,
  0xff, 0x9f, 0xb7, 0xff, 0xff, 0xfe, 0xdf, 0xc7, 0xff, 0x5f, 0x78, 0x7f,
  0xff, 0xff, 0x1f, 0xd8, 0x00, 0xd8, 0x7b, 0x7f, 0xff, 0xff, 0xdf, 0xdf,
  0xbd, 0x86, 0x7b, 0xbf, 0xff, 0xff, 0xef, 0xbf, 0xbc, 0x5e, 0x7b, 0xbf,
  0xff, 0xff, 0xf0, 0x7f, 0xbd, 0xdd, 0xb7, 0x3f, 0xff, 0xff, 0xff, 0x7f,
  0xbe, 0xbd, 0xce, 0xbf, 0xff, 0xff, 0xff, 0x1e, 0x7e, 0xbd, 0xf1, 0xbf,
  0xff, 0xff, 0xfe, 0xe1, 0xf8, 0x1d, 0xef, 0xbf, 0xff, 0xff, 0xfe, 0xef,
  0xf7, 0x66, 0xef, 0x3f, 0xff, 0xff, 0xff, 0x6f, 0xf7, 0x78, 0x70, 0x7f,
  0xff, 0xff, 0xff, 0x87, 0xf7, 0x7f, 0xaf, 0x7f, 0xff, 0xff, 0xff, 0x80,
  0x00, 0xff, 0xce, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x3e, 0x7f, 0xf1, 0xff,
  0xff, 0xff, 0xff, 0x3f, 0xbf, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xdf, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xdf, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x7f, 0xdf, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xdf, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 3 bitmap data (512 bytes)
const uint8_t STONE_frame_3[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xaf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x6f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xf7, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xfe, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x27, 0xfd,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xf9, 0xfb, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xfe, 0xbe, 0x77, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xdf, 0x8f,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x6f, 0x6f, 0xf7, 0xf0, 0x7f, 0xff,
  0xff, 0x1f, 0x76, 0xa7, 0xf7, 0xf7, 0xbf, 0xff, 0xfe, 0xe7, 0xb9, 0xab,
  0xf7, 0xf7, 0xdf, 0xff, 0xfd, 0x99, 0xbb, 0xdd, 0xef, 0xf7, 0xef, 0xff,
  0xfb, 0x7c, 0xd7, 0xee, 0xef, 0xf7, 0x87, 0xff, 0xfb, 0xf3, 0x6f, 0xef,
  0x6f, 0xc8, 0x3b, 0xff, 0xf7, 0xef, 0x6f, 0xef, 0xaf, 0x38, 0xcd, 0xff,
  0xf7, 0xff, 0x5f, 0xdf, 0xcc, 0xf9, 0xf6, 0xff, 0xf7, 0xff, 0x5f, 0xdf,
  0xf3, 0xfa, 0xfe, 0xff, 0xfb, 0xff, 0x5f, 0xdf, 0xff, 0xfb, 0x7f, 0x7f,
  0xfb, 0xff, 0x6f, 0xe0, 0xbd, 0x8b, 0xff, 0x7f, 0xfb, 0xff, 0x57, 0xe1,
  0x5b, 0x23, 0xff, 0x7f, 0xfd, 0xfc, 0xdb, 0xf0, 0x18, 0x0b, 0xfe, 0xff,
  0xfe, 0xf2, 0xdd, 0xf0, 0x3e, 0x0b, 0xfe, 0xff, 0xfe, 0x0f, 0x5d, 0xf0,
  0x67, 0x1b, 0xfe, 0xff, 0xfe, 0xff, 0x5e, 0xef, 0xe7, 0xf9, 0xfd, 0xff,
  0xff, 0x7f, 0x2f, 0x5f, 0xff, 0xf2, 0x7b, 0xff, 0xff, 0xbe, 0xc7, 0x5c,
  0x00, 0xf7, 0x83, 0xff, 0xff, 0xcd, 0xf0, 0xbb, 0xff, 0x67, 0xfb, 0xff,
  0xff, 0xf3, 0xef, 0x37, 0xff, 0x47, 0xf7, 0xff, 0xff, 0xfb, 0xdf, 0xb7,
  0xff, 0x9b, 0xef, 0xff, 0xff, 0xfc, 0xdf, 0xc7, 0xff, 0x7d, 0x9f, 0xff,
  0xff, 0xff, 0x5f, 0xd8, 0x00, 0xbe, 0x7f, 0xff, 0xff, 0xff, 0x9f, 0xdf,
  0xbd, 0xde, 0xff, 0xff, 0xff, 0xff, 0xef, 0xbf, 0xbd, 0xd9, 0xff, 0xff,
  0xff, 0xff, 0xf0, 0x7f, 0xbd, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0x7e, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x3c, 0xfe, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xc3, 0xf8, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xdf,
  0xf7, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xbf, 0xf7, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xf8, 0x3f, 0xf7, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x1f,
  0xf0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x00, 0x03, 0xcf, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0x8f, 0xe7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xdf,
  0xdf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xdf, 0xdf, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0x7f, 0xdf, 0xdf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xdf,
  0xdf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x00, 0x1f, 0xe0, 0x03, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 4 bitmap data (512 bytes)
const uint8_t STONE_frame_4[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xaf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xfe,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x27, 0xfd, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xfe, 0xf9, 0xfb, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xbe, 0x77,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xdf, 0x8f, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0x6f, 0x6f, 0xf7, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0x76, 0xa7,
  0xf7, 0xf7, 0xbf, 0xff, 0xff, 0xff, 0xb9, 0xab, 0xf7, 0xf7, 0xdf, 0xff,
  0xff, 0xff, 0xbb, 0xdd, 0xef, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xd7, 0xee,
  0xef, 0xf7, 0x8f, 0xff, 0xff, 0xff, 0xef, 0xef, 0x6f, 0xc8, 0x5f, 0xff,
  0xff, 0xff, 0xef, 0xef, 0xaf, 0x3b, 0xdf, 0xff, 0xff, 0xff, 0xdf, 0xdf,
  0xcc, 0xfb, 0xbf, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xf3, 0xfb, 0xbf, 0xff,
  0xff, 0xff, 0xdf, 0xdf, 0xff, 0xfb, 0x7f, 0xff, 0xff, 0xff, 0xef, 0xe0,
  0xbd, 0x88, 0xff, 0xff, 0xff, 0xff, 0xd7, 0xe1, 0x5b, 0x23, 0xff, 0xff,
  0xff, 0xff, 0xdb, 0xf0, 0x18, 0x0b, 0xff, 0xff, 0xff, 0xe7, 0xdd, 0xf0,
  0x3e, 0x0b, 0xe7, 0xff, 0xff, 0xdb, 0xdd, 0xf0, 0x67, 0x1b, 0xdb, 0xff,
  0xfc, 0x3d, 0xde, 0xef, 0xe7, 0xfb, 0xbc, 0x3f, 0xfd, 0xbc, 0x2f, 0x5f,
  0xff, 0xf6, 0x3d, 0xbf, 0xfb, 0xbc, 0xd7, 0x5c, 0x00, 0xf1, 0x3d, 0xdf,
  0xfb, 0xbc, 0xe0, 0xbb, 0xff, 0x67, 0x3d, 0xdf, 0xf9, 0xdb, 0x77, 0x37,
  0xff, 0x4e, 0xdb, 0x9f, 0xfa, 0xe7, 0x7b, 0x97, 0xff, 0x9e, 0xe7, 0x5f,
  0xfb, 0x1f, 0x7b, 0xc7, 0xff, 0x5e, 0xf8, 0xdf, 0xfb, 0xef, 0x77, 0xd8,
  0x00, 0x8e, 0xf7, 0xdf, 0xf9, 0xee, 0xc3, 0xbf, 0xbc, 0x73, 0x77, 0x9f,
  0xfc, 0x1c, 0x3c, 0x7f, 0xbd, 0xfc, 0x38, 0x3f, 0xfd, 0xeb, 0xff, 0x7f,
  0x7e, 0xff, 0xd7, 0xbf, 0xfe, 0xe7, 0xfe, 0x3c, 0xfe, 0xff, 0xe7, 0x7f,
  0xff, 0x1f, 0xfd, 0xc3, 0xf8, 0x7f, 0xf8, 0xff, 0xff, 0xff, 0xfd, 0xdf,
  0xf7, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xbf, 0xf7, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xf0, 0x3f, 0xf6, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x8c, 0x3f,
  0xf0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x00, 0x01, 0xe7, 0xff, 0xff,
  0xff, 0xff, 0x7f, 0x0f, 0xf3, 0xfb, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xbf,
  0xef, 0xfd, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xbf, 0xef, 0xfd, 0xff, 0xff,
  0xff, 0xfe, 0xff, 0xbf, 0xef, 0xfd, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xbf,
  0xef, 0xfd, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x3f, 0xf0, 0x01, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 5 bitmap data (512 bytes)
const uint8_t STONE_frame_5[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xaf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x6f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xf7, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xfe, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x27, 0xfd,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xf9, 0xfb, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xfe, 0xbe, 0x77, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xdf, 0x8f,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x6f, 0x6f, 0xf7, 0xf0, 0x7f, 0xff,
  0xff, 0xff, 0x76, 0xa7, 0xf7, 0xf7, 0xbf, 0xff, 0xff, 0xff, 0xb9, 0xab,
  0xf7, 0xf7, 0xdf, 0xff, 0xff, 0xff, 0xbb, 0xdd, 0xef, 0xf7, 0xef, 0xff,
  0xff, 0xff, 0xd7, 0xee, 0xef, 0xf7, 0x8f, 0xff, 0xff, 0xff, 0xef, 0xef,
  0x6f, 0xc8, 0x5f, 0xff, 0xff, 0xff, 0xef, 0xef, 0xaf, 0x3b, 0xdf, 0xff,
  0xff, 0xff, 0xdf, 0xdf, 0xcc, 0xfb, 0xbf, 0xff, 0xff, 0xff, 0xdf, 0xdf,
  0xf3, 0xfb, 0xbf, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xff, 0xfb, 0x7f, 0xff,
  0xff, 0xff, 0xef, 0xe0, 0xbd, 0x88, 0xff, 0xff, 0xff, 0xff, 0xd7, 0xe1,
  0x5b, 0x23, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xf0, 0x18, 0x0b, 0xff, 0xff,
  0xff, 0xff, 0xdd, 0xf0, 0x3e, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xdd, 0xf0,
  0x67, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xde, 0xef, 0xe7, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x5f, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x5c,
  0x00, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xbb, 0xff, 0x6f, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0x37, 0xff, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xb7,
  0xff, 0x8f, 0xff, 0xff, 0xff, 0xf3, 0xe1, 0xc7, 0xfe, 0x53, 0xe7, 0xff,
  0xff, 0xec, 0x1c, 0x58, 0x00, 0xcc, 0x1b, 0xff, 0xfe, 0x1e, 0xfe, 0x5f,
  0x7d, 0x9f, 0xbc, 0x3f, 0xfe, 0xde, 0x7e, 0x3c, 0xfd, 0xbf, 0x3d, 0xbf,
  0xfd, 0xde, 0x7c, 0xc3, 0xf8, 0x3f, 0x3d, 0xdf, 0xfd, 0xde, 0x7d, 0xdf,
  0xf7, 0x1f, 0x3d, 0xdf, 0xfc, 0xed, 0xb9, 0xbf, 0xf7, 0xae, 0xdb, 0x9f,
  0xfd, 0x73, 0xb0, 0x3f, 0xf7, 0xd6, 0xe7, 0x5f, 0xfd, 0x8f, 0x84, 0x1f,
  0xf6, 0x08, 0xf8, 0xdf, 0xfd, 0xf7, 0xbe, 0x00, 0x0c, 0xf2, 0xf7, 0xdf,
  0xfc, 0xf7, 0x3f, 0x3f, 0xf1, 0xfd, 0x77, 0x9f, 0xfe, 0x0e, 0xff, 0xbf,
  0xf7, 0xfe, 0xb8, 0x3f, 0xfe, 0xf4, 0xff, 0xbf, 0xf7, 0xfe, 0xd7, 0xbf,
  0xff, 0x72, 0xff, 0xbf, 0xf7, 0xfe, 0xe7, 0x7f, 0xff, 0x8e, 0xff, 0xbf,
  0xf7, 0xfe, 0xf8, 0xff, 0xff, 0xfe, 0x00, 0x3f, 0xf8, 0x00, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 6 bitmap data (512 bytes)
const uint8_t STONE_frame_6[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xaf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x6f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xf7, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xfe, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x27, 0xfd,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xf9, 0xfb, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xfe, 0xbe, 0x77, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xdf, 0x8f,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x6f, 0x6f, 0xf7, 0xf0, 0x7f, 0xff,
  0xff, 0xff, 0x76, 0xa7, 0xf7, 0xf7, 0xbf, 0xff, 0xff, 0xff, 0xb9, 0xab,
  0xf7, 0xf7, 0xdf, 0xff, 0xff, 0xff, 0xbb, 0xdd, 0xef, 0xf7, 0xef, 0xff,
  0xff, 0xff, 0xd7, 0xee, 0xef, 0xf7, 0x8f, 0xff, 0xff, 0xff, 0xef, 0xef,
  0x6f, 0xc8, 0x5f, 0xff, 0xff, 0xff, 0xef, 0xef, 0xaf, 0x3b, 0xdf, 0xff,
  0xff, 0xff, 0xdf, 0xdf, 0xcc, 0xfb, 0xbf, 0xff, 0xff, 0xff, 0xdf, 0xdf,
  0xf3, 0xfb, 0xbf, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xff, 0xfb, 0x7f, 0xff,
  0xff, 0xff, 0xef, 0xe0, 0xbd, 0x88, 0xff, 0xff, 0xff, 0xff, 0xd7, 0xe1,
  0x5b, 0x23, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xf0, 0x18, 0x0b, 0xff, 0xff,
  0xff, 0xff, 0xdd, 0xf0, 0x3e, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xdd, 0xf0,
  0x67, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xde, 0xef, 0xe7, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x5f, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x5c,
  0x00, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xbb, 0xff, 0x6f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x37, 0xff, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x37,
  0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xc7, 0x8f, 0x5f, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xd8, 0x60, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1e,
  0xf5, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xa6, 0x0e, 0x1f, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x78, 0xf7, 0x67, 0xff, 0xff, 0xff, 0xff, 0xef, 0xf5,
  0xf7, 0xbb, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xed, 0x8f, 0xbd, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xe9, 0x78, 0xbd, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xdc,
  0xf7, 0x3b, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1d, 0xef, 0x7b, 0xff, 0xff,
  0xff, 0xff, 0xf8, 0x1d, 0xee, 0x67, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x0e,
  0xde, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x0e, 0x0e, 0xcf, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0x80, 0x65, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xdf,
  0xd3, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xdf, 0xdf, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0x7f, 0xdf, 0xdf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xdf,
  0xdf, 0xf9, 0xff, 0xff, 0xff, 0xff, 0x00, 0x1f, 0xe0, 0x01, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 7 bitmap data (512 bytes)
const uint8_t STONE_frame_7[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xaf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xfe,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x27, 0xfd, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xfe, 0xf9, 0xfb, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xbe, 0x77,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xdf, 0x8f, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0x6f, 0x6f, 0xf7, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0x76, 0xa7,
  0xf7, 0xf7, 0xbf, 0xff, 0xff, 0xff, 0xb9, 0xab, 0xf7, 0xf7, 0xdf, 0xff,
  0xff, 0xff, 0xbb, 0xdd, 0xef, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xd7, 0xee,
  0xef, 0xf7, 0x8f, 0xff, 0xff, 0xff, 0xef, 0xef, 0x6f, 0xc8, 0x5f, 0xff,
  0xff, 0xff, 0xef, 0xef, 0xaf, 0x3b, 0xdf, 0xff, 0xff, 0xff, 0xdf, 0xdf,
  0xcc, 0xfb, 0xbf, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xf3, 0xfb, 0xbf, 0xff,
  0xff, 0xff, 0xdf, 0xdf, 0xff, 0xfb, 0x7f, 0xff, 0xff, 0xff, 0xef, 0xe0,
  0xbd, 0x88, 0xff, 0xff, 0xff, 0xff, 0xd7, 0xe0, 0x5b, 0x03, 0xff, 0xff,
  0xff, 0xff, 0xdb, 0xf0, 0x18, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xdd, 0xf4,
  0x3e, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xdd, 0xf7, 0xe7, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xde, 0xef, 0xe7, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xef, 0x5f,
  0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x5c, 0x00, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xf8, 0xbb, 0xff, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x37,
  0xff, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x37, 0xff, 0x9f, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xc7, 0x8f, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xd8,
  0x60, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1e, 0xf5, 0x9f, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xa6, 0x0e, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xef, 0x78,
  0xf7, 0x67, 0xff, 0xff, 0xff, 0xff, 0xef, 0xf5, 0xf7, 0xbb, 0xff, 0xff,
  0xff, 0xff, 0xf3, 0xe9, 0x08, 0xbd, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xdc,
  0xf7, 0x3b, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1d, 0xef, 0x7b, 0xff, 0xff,
  0xff, 0xff, 0xf8, 0x1d, 0xee, 0x67, 0xff, 0xff, 0xff, 0xff, 0xe6, 0x0e,
  0xde, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x86, 0x0c, 0xcf, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xc0, 0x43, 0xef, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xef,
  0xa7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xef, 0xbf, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xef, 0xbf, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xef,
  0xbf, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0f, 0xc0, 0x07, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 8 bitmap data (512 bytes)
const uint8_t STONE_frame_8[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xaf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xfe,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x27, 0xfd, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xfe, 0xf9, 0xfb, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xbe, 0x77,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xdf, 0x8f, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0x6f, 0x6f, 0xf7, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0x76, 0xa7,
  0xf7, 0xf7, 0xbf, 0xff, 0xff, 0xff, 0xb9, 0xab, 0xf7, 0xf7, 0xdf, 0xff,
  0xff, 0xff, 0xbb, 0xdd, 0xef, 0xf7, 0xef, 0xff, 0xff, 0xff, 0xd7, 0xee,
  0xef, 0xf7, 0x8f, 0xff, 0xff, 0xff, 0xef, 0xef, 0x6f, 0xc8, 0x5f, 0xff,
  0xff, 0xff, 0xef, 0xef, 0xaf, 0x3b, 0xdf, 0xff, 0xff, 0xff, 0xdf, 0xdf,
  0xcc, 0xfb, 0xbf, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xf3, 0xfb, 0xbf, 0xff,
  0xff, 0xff, 0xdf, 0xdf, 0xff, 0xfb, 0x7f, 0xff, 0xff, 0xff, 0xef, 0xe0,
  0xbd, 0x88, 0xff, 0xff, 0xff, 0xff, 0xd7, 0xe0, 0x5b, 0x03, 0xff, 0xff,
  0xff, 0xff, 0xdb, 0xf0, 0x18, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xdd, 0xf4,
  0x3e, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xdd, 0xf7, 0xe7, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xde, 0xef, 0xe7, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xef, 0x5f,
  0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x5c, 0x00, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xf8, 0xbb, 0xff, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x37,
  0xff, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x37, 0xff, 0x9f, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xc7, 0x8f, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xd8,
  0x06, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1b, 0xd6, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xa0, 0x38, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xef, 0x73,
  0xdd, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xef, 0xf7, 0xde, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xf3, 0xe4, 0x22, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xd3,
  0xdc, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x17, 0xbd, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x17, 0xb9, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0b,
  0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xcc, 0x3f, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xf0, 0x7f, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xef, 0xfd,
  0x7f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xef, 0xfd, 0x7f, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xfd, 0x7f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xef, 0xfd,
  0x7f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x03, 0x80, 0x0f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 9 bitmap data (512 bytes)
const uint8_t STONE_frame_9[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xaf, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x6f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xf7, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xfe, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x27, 0xfd,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xf9, 0xfb, 0xf7, 0xf7, 0xff, 0xff,
  0xff, 0xfe, 0xbe, 0x77, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfe, 0xdf, 0x8f,
  0xf7, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x6f, 0x6f, 0xf7, 0xf0, 0x7f, 0xff,
  0xff, 0xff, 0x76, 0xa7, 0xf7, 0xf7, 0xbf, 0xff, 0xff, 0xff, 0xb9, 0xab,
  0xf7, 0xf7, 0xdf, 0xff, 0xff, 0xff, 0xbb, 0xdd, 0xef, 0xf7, 0xef, 0xff,
  0xff, 0xff, 0xd7, 0xee, 0xef, 0xf7, 0x8f, 0xff, 0xff, 0xff, 0xef, 0xef,
  0x6f, 0xc8, 0x5f, 0xff, 0xff, 0xff, 0xef, 0xef, 0xaf, 0x3b, 0xdf, 0xff,
  0xff, 0xff, 0xdf, 0xdf, 0xcc, 0xfb, 0xbf, 0xff, 0xff, 0xff, 0xdf, 0xdf,
  0xf3, 0xfb, 0xbf, 0xff, 0xff, 0xff, 0xdf, 0xd0, 0x7f, 0x0b, 0x7f, 0xff,
  0xff, 0xff, 0xef, 0xe1, 0xbe, 0x30, 0xff, 0xff, 0xff, 0xff, 0xd7, 0xe1,
  0xbe, 0x33, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xe0, 0x3e, 0x03, 0xff, 0xff,
  0xff, 0xff, 0xdd, 0xe0, 0x3e, 0x03, 0xff, 0xff, 0xff, 0xff, 0xdd, 0x70,
  0x67, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x6f, 0xe7, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x1f, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x9f, 0x5c,
  0x00, 0x37, 0xff, 0xff, 0xff, 0xff, 0x5c, 0xbb, 0xff, 0xcf, 0xff, 0xff,
  0xff, 0xfc, 0xdf, 0x37, 0xff, 0xc7, 0xff, 0xff, 0xff, 0xfb, 0xdf, 0xb7,
  0xff, 0xbb, 0xff, 0xff, 0xff, 0xf3, 0xef, 0xc7, 0xff, 0x79, 0xff, 0xff,
  0xff, 0xcd, 0xf1, 0xb8, 0x00, 0xf6, 0x7f, 0xff, 0xff, 0xbe, 0xc6, 0x7f,
  0xbc, 0x6f, 0xbf, 0xff, 0xff, 0x7f, 0x3f, 0x7f, 0xbc, 0x1f, 0xdf, 0xff,
  0xfe, 0xff, 0x7f, 0x7f, 0xbd, 0xdf, 0xef, 0xff, 0xfe, 0x0f, 0x7e, 0xff,
  0x7e, 0xde, 0x0f, 0xff, 0xfe, 0xf2, 0xfe, 0x3c, 0xfe, 0xe9, 0xef, 0xff,
  0xfd, 0xfc, 0xfd, 0xc3, 0xf8, 0x67, 0xf7, 0xff, 0xfb, 0xff, 0x7d, 0xdf,
  0xf7, 0x5f, 0xfb, 0xff, 0xfb, 0xff, 0x7d, 0xbf, 0xf7, 0x5f, 0xfb, 0xff,
  0xfb, 0xff, 0x78, 0x3f, 0xf7, 0x5f, 0xfb, 0xff, 0xf7, 0xff, 0x46, 0x1f,
  0xf0, 0x1f, 0xfd, 0xff, 0xf7, 0xff, 0x3f, 0x00, 0x03, 0xef, 0xfd, 0xff,
  0xf7, 0xef, 0x3f, 0x8f, 0xe7, 0xf6, 0xfd, 0xff, 0xfb, 0xf3, 0x7f, 0xdf,
  0xdf, 0xf9, 0xfb, 0xff, 0xfb, 0x7c, 0x7f, 0xdf, 0xdf, 0xfb, 0xdb, 0xff,
  0xfd, 0x99, 0x7f, 0xdf, 0xdf, 0xfb, 0x37, 0xff, 0xfe, 0xe7, 0x7f, 0xdf,
  0xdf, 0xf8, 0xef, 0xff, 0xff, 0x1f, 0x00, 0x1f, 0xe0, 0x03, 0x1f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 10 bitmap data (512 bytes)
const uint8_t STONE_frame_10[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 11 bitmap data (512 bytes)
const uint8_t STONE_frame_11[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#endif  // STONE_H
