// SPDX-FileCopyrightText: 2025 KOINSLOT, Inc.
// SPDX-License-Identifier: GPL-3.0-or-later

/*
 * Auto-generated header file from electric.bmp
 * Sprite sheet: 3x4 frames
 * Frame size: 64x64 pixels
 * Total frames: 12
 * Format: 1-bit packed bitmap (0=black, 1=white)
 * Generated: 2025-06-29 12:14:53
 *
 * Usage in Kywy projects:
 *   #include "electric.h"
 *
 *   // Draw individual frames:
 *   engine.display.drawBitmap(x, y, ELECTRIC_FRAME_WIDTH,
 *                            ELECTRIC_FRAME_HEIGHT, ELECTRIC_frame_0);
 *
 *   // Animate through frames:
 *   const uint8_t* frames[] = {ELECTRIC_frame_0, ELECTRIC_frame_1,
 * ELECTRIC_frame_2, ELECTRIC_frame_3, ELECTRIC_frame_4, ELECTRIC_frame_5,
 * ELECTRIC_frame_6, ELECTRIC_frame_7, ELECTRIC_frame_8, ELECTRIC_frame_9,
 * ELECTRIC_frame_10, ELECTRIC_frame_11}; engine.display.drawBitmap(x, y,
 * ELECTRIC_FRAME_WIDTH, ELECTRIC_FRAME_HEIGHT, frames[currentFrame]);
 */

#ifndef ELECTRIC_H
#define ELECTRIC_H

#include <stdint.h>

// Sprite sheet information
#define ELECTRIC_FRAME_WIDTH 64
#define ELECTRIC_FRAME_HEIGHT 64
#define ELECTRIC_FRAME_COUNT 12
#define ELECTRIC_SPRITE_COLS 3
#define ELECTRIC_SPRITE_ROWS 4

// Frame 0 bitmap data (512 bytes)
const uint8_t ELECTRIC_frame_0[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf,
  0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x8f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf3, 0x87, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x79,
  0x23, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x78, 0x79, 0x9f, 0xff, 0xff,
  0xff, 0xff, 0xfc, 0x7c, 0x7e, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7e,
  0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0x8f, 0xff, 0xff,
  0xfd, 0xbf, 0xf8, 0x7f, 0xff, 0x0f, 0xff, 0xff, 0xfd, 0x9f, 0xf8, 0x7f,
  0xff, 0x07, 0xff, 0xff, 0xfe, 0x9f, 0xf8, 0x7f, 0xff, 0x07, 0xff, 0xff,
  0xfe, 0xaf, 0xf0, 0x7f, 0xff, 0x03, 0xff, 0xff, 0xfe, 0x6f, 0xf0, 0x7f,
  0xff, 0x03, 0xff, 0xff, 0xfe, 0x77, 0xf0, 0x7f, 0xff, 0x01, 0xff, 0xff,
  0xff, 0x77, 0xe0, 0x7f, 0x9f, 0x01, 0xff, 0xff, 0xf7, 0x7b, 0xe0, 0x3f,
  0xaf, 0x00, 0xff, 0xff, 0xf7, 0xfd, 0xc0, 0x3d, 0xaf, 0x00, 0xff, 0xff,
  0xf3, 0xfd, 0xc0, 0x3a, 0xb7, 0x00, 0x7f, 0xff, 0xf3, 0xfc, 0xc0, 0x3b,
  0x79, 0x00, 0x7f, 0xef, 0xf1, 0xfa, 0xc0, 0x03, 0xfe, 0x00, 0x3d, 0xef,
  0xf1, 0xdb, 0x40, 0x0f, 0xff, 0x00, 0x3c, 0xef, 0xf1, 0xe7, 0x60, 0x1f,
  0xff, 0x80, 0x3d, 0x5f, 0xf1, 0xf7, 0xe0, 0x3f, 0xff, 0xe0, 0x7d, 0x5f,
  0xf8, 0xff, 0xe0, 0x3f, 0xff, 0xe0, 0xfb, 0x9f, 0xf8, 0xff, 0xf0, 0x7f,
  0xff, 0xf0, 0xfb, 0xdf, 0xf8, 0xff, 0xf0, 0x7f, 0xff, 0x99, 0xfb, 0xff,
  0xf8, 0xff, 0xf0, 0xf9, 0xff, 0x6b, 0xf1, 0xff, 0xf8, 0x7f, 0xf8, 0xf6,
  0xff, 0x65, 0xcd, 0xff, 0xf8, 0x7f, 0xf9, 0xe6, 0x7f, 0x05, 0xbe, 0xff,
  0xf8, 0x7f, 0xfd, 0xe0, 0x7f, 0x05, 0x3e, 0xff, 0xf8, 0x7f, 0xe3, 0xe0,
  0x3f, 0x84, 0xbf, 0x7f, 0xf8, 0x37, 0xef, 0xe0, 0x3f, 0x87, 0x7f, 0xbf,
  0xf8, 0x37, 0xf3, 0xe0, 0x3f, 0xc9, 0x7f, 0xdf, 0xf8, 0x23, 0xf7, 0xf0,
  0x78, 0xf9, 0xbf, 0xff, 0xf8, 0x23, 0xcf, 0x88, 0xfd, 0xff, 0xdf, 0xff,
  0xf8, 0x01, 0xbf, 0x8f, 0xd9, 0xbe, 0x3f, 0xff, 0xf8, 0x01, 0x8f, 0xff,
  0xe6, 0x7c, 0x7f, 0xff, 0xfc, 0x01, 0xf3, 0xff, 0xff, 0xf9, 0xff, 0xff,
  0xfc, 0x00, 0xec, 0x3f, 0xff, 0xf3, 0xff, 0xff, 0xfc, 0x00, 0xef, 0xc7,
  0xff, 0xcd, 0xff, 0xff, 0xfc, 0x00, 0x5d, 0xf8, 0x78, 0x3e, 0xff, 0xff,
  0xfc, 0x08, 0x5d, 0xff, 0xff, 0xbe, 0xff, 0xff, 0xfc, 0x1e, 0x3d, 0xfe,
  0xff, 0x7e, 0xff, 0xff, 0xfc, 0x3f, 0xbe, 0xff, 0x3e, 0xfe, 0xff, 0xff,
  0xfc, 0x7f, 0xbf, 0x7f, 0xdd, 0xfd, 0xff, 0xff, 0xfe, 0xff, 0xbf, 0xbf,
  0xdd, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xcf, 0xdd, 0xee, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xf7, 0xdd, 0xde, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xe8,
  0x3e, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xef, 0xff, 0xbd, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xdf, 0xff, 0x7b, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdf,
  0xff, 0x70, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xbf, 0xfe, 0xff, 0x3f, 0xff,
  0xff, 0xff, 0xbf, 0x87, 0xf1, 0xff, 0xdf, 0xff, 0xff, 0xff, 0x7f, 0x78,
  0x0c, 0x3f, 0xdf, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xc0, 0x3f, 0xff,
  0xff, 0xfd, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 1 bitmap data (512 bytes)
const uint8_t ELECTRIC_frame_1[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
  0x87, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4f, 0x83, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0x63, 0x30, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x70,
  0x7f, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x78, 0x7f, 0x8f, 0xff, 0xff,
  0xff, 0xff, 0xfc, 0x7c, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f,
  0xff, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0x07, 0xff, 0xff,
  0xff, 0xef, 0xf8, 0x7f, 0xff, 0x07, 0xff, 0xff, 0xff, 0xf7, 0xf0, 0x7f,
  0xff, 0x03, 0xff, 0xff, 0xff, 0xf7, 0xf0, 0x7f, 0xff, 0x03, 0xff, 0xff,
  0xff, 0xf7, 0xf0, 0x7f, 0xff, 0x01, 0xff, 0xff, 0xfe, 0x97, 0xe0, 0x7f,
  0x9f, 0x01, 0xff, 0xff, 0xf7, 0x7b, 0xe0, 0x3f, 0xaf, 0x00, 0xff, 0xff,
  0xf7, 0xfc, 0xc0, 0x3d, 0xaf, 0x00, 0xff, 0xff, 0xf3, 0xff, 0x40, 0x3a,
  0xb7, 0x00, 0x7f, 0xff, 0xf3, 0xff, 0x40, 0x3b, 0x79, 0x00, 0x7f, 0xff,
  0xf1, 0xff, 0x40, 0x03, 0xfe, 0x00, 0x3f, 0xff, 0xf1, 0xde, 0xc0, 0x0f,
  0xff, 0x00, 0x3f, 0xff, 0xf1, 0xde, 0xe0, 0x1f, 0xff, 0x80, 0x3f, 0xff,
  0xf1, 0xdc, 0xe0, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xf8, 0xda, 0xe0, 0x3f,
  0xff, 0xe0, 0xff, 0xff, 0xf8, 0xd7, 0x70, 0x7f, 0xff, 0xf0, 0xff, 0x7f,
  0xf8, 0xef, 0x70, 0x7f, 0xff, 0x99, 0xfe, 0x7f, 0xf8, 0xff, 0xb0, 0xf9,
  0xff, 0x6b, 0xfd, 0x7f, 0xf8, 0x7f, 0xb8, 0xf6, 0xff, 0x65, 0xfb, 0x73,
  0xf8, 0x7f, 0xf9, 0xe6, 0x7f, 0x05, 0xf7, 0x0f, 0xf8, 0x7f, 0xfd, 0xe0,
  0x7f, 0x05, 0xcb, 0x7f, 0xf8, 0x7f, 0xe3, 0xe0, 0x3f, 0x84, 0xfb, 0x7f,
  0xf8, 0x37, 0xef, 0xe0, 0x3f, 0x87, 0x7b, 0x7f, 0xf8, 0x37, 0xf3, 0xe0,
  0x3f, 0xc9, 0x7b, 0x7f, 0xf8, 0x23, 0xf7, 0xf0, 0x78, 0xf9, 0xbd, 0x7f,
  0xf8, 0x23, 0xcf, 0x88, 0xfd, 0xff, 0xde, 0x7f, 0xf8, 0x01, 0xbf, 0x8f,
  0xd9, 0xbe, 0x0f, 0x3f, 0xf8, 0x01, 0x8f, 0xff, 0xe6, 0x7c, 0x77, 0xbf,
  0xfc, 0x01, 0xf3, 0xff, 0xff, 0xf8, 0xf7, 0xdf, 0xfc, 0x00, 0xec, 0x3f,
  0xff, 0xf1, 0xf7, 0xdf, 0xfc, 0x00, 0xef, 0xc7, 0xff, 0xc7, 0xf7, 0xff,
  0xfc, 0x00, 0x5d, 0xf8, 0x78, 0x27, 0xef, 0xff, 0xfc, 0x08, 0x5d, 0xff,
  0xff, 0xfb, 0xdf, 0xff, 0xfc, 0x1e, 0x3d, 0xff, 0xff, 0xfd, 0xbf, 0xff,
  0xfc, 0x3f, 0xbd, 0xf7, 0xff, 0xfc, 0x7f, 0xff, 0xfc, 0x7f, 0xbd, 0xf9,
  0xff, 0xfe, 0xff, 0xff, 0xfe, 0xff, 0xbe, 0xfe, 0xff, 0xee, 0xff, 0xff,
  0xff, 0xff, 0xbe, 0xfe, 0xff, 0xee, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x7e,
  0xff, 0xde, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xbe, 0xff, 0xbc, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xc1, 0xff, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xef, 0xdf,
  0xff, 0x7f, 0x3f, 0xff, 0xff, 0xff, 0xe7, 0xdf, 0xff, 0x7f, 0xdf, 0xff,
  0xff, 0xff, 0xdf, 0xbf, 0xfe, 0x3f, 0xdf, 0xff, 0xff, 0xff, 0xdf, 0x87,
  0xf1, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xbf, 0xb8, 0x0f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x7f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x81, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 2 bitmap data (512 bytes)
const uint8_t ELECTRIC_frame_2[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x79, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf8, 0x73, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x71,
  0x27, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x67, 0x87, 0x9f, 0xff, 0xff,
  0xff, 0xff, 0xfc, 0x5f, 0x8f, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f,
  0xdf, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0x8f, 0xff, 0xff,
  0xff, 0xff, 0xf8, 0x7f, 0xff, 0x0f, 0xff, 0xff, 0xff, 0xdf, 0xf8, 0x7f,
  0xff, 0x07, 0xff, 0xff, 0xff, 0xdf, 0xf8, 0x7f, 0xff, 0x07, 0xff, 0xff,
  0xff, 0xef, 0xf0, 0x7f, 0xff, 0x03, 0xff, 0xff, 0xff, 0xf7, 0xf0, 0x7f,
  0xff, 0x03, 0xff, 0xff, 0xff, 0xf7, 0xf0, 0x7f, 0xff, 0x01, 0xff, 0xff,
  0xff, 0xf7, 0xe0, 0x7f, 0x9f, 0x01, 0xff, 0xff, 0xf7, 0xfb, 0xe0, 0x3f,
  0xaf, 0x00, 0xff, 0xff, 0xf7, 0xfd, 0xc0, 0x3d, 0xaf, 0x00, 0xff, 0xff,
  0xf3, 0xfd, 0xc0, 0x3a, 0xb7, 0x00, 0x7f, 0xff, 0xf3, 0xfc, 0xc0, 0x3b,
  0x79, 0x00, 0x7f, 0xff, 0xf1, 0xfa, 0xc0, 0x03, 0xfe, 0x00, 0x3f, 0xff,
  0xf1, 0xdb, 0x40, 0x0f, 0xff, 0x00, 0x3f, 0xff, 0xf1, 0xe7, 0x60, 0x1f,
  0xff, 0x80, 0x3f, 0xff, 0xf1, 0xf7, 0xe0, 0x3f, 0xff, 0xe0, 0x7f, 0xff,
  0xf8, 0xed, 0xe0, 0x3f, 0xff, 0xe0, 0xff, 0xdf, 0xf8, 0xec, 0xf0, 0x7f,
  0xff, 0xf0, 0xff, 0xbf, 0xf8, 0xf4, 0xf0, 0x7f, 0xff, 0x99, 0xff, 0x7f,
  0xf8, 0xf5, 0x70, 0xf9, 0xff, 0x6b, 0xfe, 0xff, 0xf8, 0x73, 0x78, 0xf6,
  0xff, 0x65, 0xfe, 0xff, 0xf8, 0x73, 0xb9, 0xe6, 0x7f, 0x05, 0xf5, 0xff,
  0xf8, 0x7b, 0xbd, 0xe0, 0x7f, 0x05, 0xc9, 0xff, 0xf8, 0x7b, 0xe3, 0xe0,
  0x3f, 0x84, 0xbb, 0xff, 0xf8, 0x37, 0xef, 0xe0, 0x3f, 0x87, 0x3b, 0xdf,
  0xf8, 0x37, 0xf3, 0xe0, 0x3f, 0xc9, 0x3b, 0x9f, 0xf8, 0x23, 0xf7, 0xf0,
  0x78, 0xf9, 0xbd, 0x5f, 0xf8, 0x23, 0xcf, 0x88, 0xfd, 0xff, 0xdd, 0x5f,
  0xf8, 0x01, 0xbf, 0x8f, 0xd9, 0xbe, 0x3c, 0xef, 0xf8, 0x01, 0x80, 0x7f,
  0xe6, 0x7c, 0x7d, 0xef, 0xfc, 0x01, 0xe7, 0xbf, 0xff, 0xf9, 0xff, 0xef,
  0xfc, 0x00, 0xef, 0xcf, 0xff, 0xf7, 0xff, 0xff, 0xfc, 0x00, 0xef, 0xf7,
  0xff, 0xc1, 0xff, 0xff, 0xfc, 0x00, 0x4f, 0xf8, 0x78, 0x3e, 0x7f, 0xff,
  0xfc, 0x08, 0x53, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xfc, 0x1e, 0x3c, 0xff,
  0xff, 0xff, 0xef, 0xff, 0xfc, 0x3f, 0xbf, 0x3f, 0xff, 0xff, 0xef, 0xff,
  0xfc, 0x7f, 0x83, 0xdf, 0xff, 0xff, 0x9f, 0xff, 0xfe, 0xff, 0x7d, 0xff,
  0xff, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0x7e, 0xff, 0xff, 0xef, 0xff, 0xff,
  0xff, 0xff, 0x7f, 0x7f, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xef,
  0xff, 0xb7, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xef, 0xff, 0xb7, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xef, 0xff, 0x77, 0xff, 0xff, 0xff, 0xff, 0xef, 0xef,
  0xff, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xef, 0xfe, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xf9, 0xc7, 0xf1, 0x87, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x18,
  0x0f, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xfe, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xe1, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xfe, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 3 bitmap data (512 bytes)
const uint8_t ELECTRIC_frame_3[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfd, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
  0x87, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xf9, 0x83, 0xff, 0xff, 0xcf,
  0xdf, 0xff, 0xff, 0xf1, 0xc0, 0xff, 0xff, 0xe7, 0x8f, 0xff, 0xff, 0xf1,
  0xc0, 0x7f, 0xff, 0xf3, 0x87, 0xff, 0xff, 0xe3, 0xc0, 0x3f, 0xff, 0x79,
  0x23, 0xbf, 0xff, 0xe3, 0xc0, 0x1f, 0xfe, 0x78, 0x79, 0x9f, 0xff, 0xc3,
  0xf8, 0x1f, 0xfc, 0x7c, 0x7e, 0x9f, 0xff, 0x83, 0xff, 0x8f, 0xfc, 0x7e,
  0xff, 0x8f, 0xff, 0x87, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0x8f, 0xff, 0x0f,
  0xff, 0xff, 0xf8, 0x7f, 0xff, 0x0f, 0xff, 0x1f, 0xff, 0xff, 0xf8, 0x7f,
  0xff, 0x07, 0xfe, 0x7f, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0x07, 0xfe, 0xff,
  0xff, 0xff, 0xf0, 0x7f, 0xff, 0x03, 0xfd, 0xff, 0xff, 0xff, 0xf0, 0x7f,
  0xff, 0x03, 0xff, 0xff, 0xff, 0xef, 0xf0, 0x7f, 0xff, 0x01, 0xff, 0xff,
  0xff, 0xef, 0xe0, 0x7f, 0x9f, 0x01, 0xff, 0xff, 0xf7, 0xe7, 0xe0, 0x3f,
  0xaf, 0x00, 0xff, 0xff, 0xf7, 0xe7, 0xc0, 0x3d, 0xaf, 0x00, 0xff, 0xff,
  0xf3, 0xe7, 0xc0, 0x3a, 0xb7, 0x00, 0x7f, 0xdf, 0xf3, 0xe3, 0xc0, 0x3b,
  0x79, 0x00, 0x7f, 0x9f, 0xf1, 0xe3, 0xc0, 0x03, 0xfe, 0x00, 0x3f, 0xbf,
  0xf1, 0xe3, 0xc0, 0x0f, 0xff, 0x00, 0x3f, 0x3f, 0xf1, 0xe3, 0xa0, 0x1f,
  0xff, 0x80, 0x3e, 0x3f, 0xf1, 0xc1, 0x20, 0x3f, 0xff, 0xe0, 0x7c, 0x3f,
  0xf8, 0xc0, 0x20, 0x3f, 0xff, 0xe0, 0xfc, 0x7e, 0xf8, 0xc0, 0x30, 0x7f,
  0xff, 0xf0, 0xf8, 0x78, 0xf8, 0xc0, 0x10, 0x7f, 0xff, 0x99, 0xf0, 0x71,
  0xf8, 0xc0, 0x10, 0xf9, 0xff, 0x0b, 0xe0, 0x41, 0xf8, 0x40, 0x18, 0xf0,
  0xff, 0x05, 0xe0, 0x83, 0xf8, 0x4c, 0x19, 0xe0, 0x7f, 0x15, 0xc6, 0x07,
  0xf8, 0x4c, 0x1d, 0xe6, 0x7f, 0x35, 0x8e, 0x0f, 0xf8, 0x5c, 0x23, 0xe3,
  0x3f, 0x64, 0xbe, 0x0f, 0xf8, 0x36, 0x6f, 0xe0, 0xbf, 0x87, 0x7e, 0x1f,
  0xf8, 0x36, 0xf3, 0xe0, 0x3f, 0xc9, 0x7e, 0x3f, 0xf8, 0x23, 0xf7, 0xf0,
  0x78, 0xf9, 0xbe, 0x7f, 0xf8, 0x23, 0xcf, 0x88, 0xfd, 0xff, 0xde, 0x7f,
  0xf8, 0x01, 0xbf, 0x8f, 0xd9, 0xbe, 0x3e, 0xff, 0xf8, 0x01, 0x8f, 0xff,
  0xe6, 0x7c, 0x7f, 0xff, 0xfc, 0x01, 0xf3, 0xff, 0xff, 0xf9, 0xff, 0xff,
  0xfc, 0x00, 0xec, 0x3f, 0xff, 0xf3, 0xff, 0xff, 0xfc, 0x00, 0xef, 0xc7,
  0xff, 0xcd, 0xff, 0xff, 0xfc, 0x00, 0x5d, 0xf8, 0x78, 0x3e, 0xff, 0xff,
  0xfc, 0x08, 0x5d, 0xff, 0xff, 0xbe, 0xff, 0xff, 0xfc, 0x1e, 0x3d, 0xfe,
  0xff, 0x7e, 0xff, 0xff, 0xfc, 0x3f, 0xbe, 0xff, 0x3e, 0xfe, 0xff, 0xff,
  0xfc, 0x7f, 0xbf, 0x7f, 0xdd, 0xfd, 0xff, 0xff, 0xfe, 0xff, 0xbf, 0xbf,
  0xdd, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xcf, 0xdd, 0xee, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xf7, 0xdd, 0xde, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xe8,
  0x3e, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xef, 0xff, 0xbd, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xdf, 0xff, 0x7b, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdf,
  0xff, 0x70, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xbf, 0xfe, 0xff, 0x3f, 0xff,
  0xff, 0xff, 0xbf, 0x87, 0xf1, 0xff, 0xdf, 0xff, 0xff, 0xff, 0x7f, 0x78,
  0x0c, 0x3f, 0xdf, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xc0, 0x3f, 0xff,
  0xff, 0xfd, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 4 bitmap data (512 bytes)
const uint8_t ELECTRIC_frame_4[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xbf, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xc7, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x87,
  0x83, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f, 0x80, 0xff, 0xff, 0xbf,
  0x9f, 0xff, 0xfc, 0x0f, 0xc0, 0x3f, 0xff, 0x9f, 0x0f, 0xff, 0xfc, 0x0f,
  0xc0, 0x0f, 0xff, 0xcf, 0x07, 0xff, 0xf8, 0x0f, 0xc0, 0x03, 0xfe, 0xe6,
  0x73, 0x7f, 0xf8, 0x0f, 0xc0, 0x01, 0xfc, 0xf0, 0xfd, 0x3f, 0xf8, 0x1f,
  0xe0, 0x01, 0xf8, 0xf0, 0xff, 0x3f, 0xf0, 0x1f, 0xe0, 0x01, 0xf8, 0xf9,
  0xff, 0x1f, 0xf0, 0x1f, 0xe0, 0x03, 0xf8, 0xff, 0xff, 0x1f, 0xf0, 0x1f,
  0xf0, 0x01, 0xf0, 0xff, 0xfe, 0x1f, 0xe0, 0x1f, 0xf8, 0x01, 0xf0, 0xff,
  0xfe, 0x0f, 0xe0, 0x3f, 0xfe, 0x01, 0xf0, 0xff, 0xfe, 0x0f, 0xe0, 0x3f,
  0xfb, 0x01, 0xe0, 0xff, 0xfe, 0x07, 0xc0, 0x3f, 0xf1, 0x81, 0xe0, 0xff,
  0xfe, 0x07, 0xc0, 0x7f, 0xe1, 0xe1, 0xe0, 0xff, 0xfe, 0x03, 0xc1, 0xff,
  0xe1, 0xf1, 0xc0, 0xff, 0x3e, 0x03, 0x87, 0xff, 0xe1, 0xf1, 0xc0, 0x7f,
  0x5e, 0x01, 0x9f, 0xff, 0xe1, 0xf1, 0x80, 0x7b, 0x5e, 0x01, 0xff, 0xff,
  0xe1, 0xe1, 0x80, 0x75, 0x6e, 0x00, 0xff, 0xff, 0xe1, 0xe1, 0x80, 0x76,
  0xf2, 0x00, 0xff, 0xff, 0xe1, 0xe0, 0x80, 0x07, 0xfc, 0x00, 0x7f, 0xff,
  0xe0, 0xe0, 0x80, 0x1f, 0xfe, 0x00, 0x7f, 0xff, 0xe0, 0xc0, 0xc0, 0x3f,
  0xff, 0x00, 0x7f, 0xff, 0xe0, 0xc0, 0xc0, 0x7f, 0xff, 0xc0, 0xff, 0xff,
  0xe0, 0xf8, 0xc0, 0x7f, 0xff, 0xc1, 0xff, 0xff, 0xe0, 0xfc, 0xe0, 0xff,
  0xff, 0xe1, 0xfe, 0xff, 0xe0, 0xf8, 0x60, 0xff, 0xff, 0x33, 0xfe, 0x7f,
  0xf0, 0xf8, 0x61, 0xf3, 0xfe, 0x17, 0xfc, 0x7d, 0xf0, 0xf8, 0x11, 0xe1,
  0xfe, 0x0b, 0xfc, 0x3d, 0xf0, 0xf0, 0x33, 0xc0, 0xfe, 0x2b, 0xf8, 0x3d,
  0xf0, 0xf0, 0x7b, 0xcc, 0xfe, 0x6b, 0xf8, 0x19, 0xf8, 0xf0, 0xc7, 0xc6,
  0x7e, 0xc9, 0xf8, 0x19, 0xf8, 0xe3, 0xdf, 0xc1, 0x7f, 0x0e, 0xf0, 0x09,
  0xf8, 0xef, 0xe7, 0xc0, 0x7f, 0x92, 0xf1, 0x0b, 0xf8, 0xff, 0xef, 0xe0,
  0xf1, 0xf3, 0x63, 0x83, 0xfc, 0x3c, 0x9f, 0x11, 0xfb, 0xff, 0xa3, 0xc3,
  0xfc, 0x10, 0x7f, 0x1f, 0xb3, 0x7c, 0x47, 0xe7, 0xfc, 0x00, 0x1f, 0xff,
  0xcc, 0xf8, 0xcf, 0xf7, 0xfc, 0x00, 0xe7, 0xff, 0xff, 0xf3, 0xff, 0xff,
  0xfe, 0x00, 0xd8, 0x7f, 0xff, 0xe7, 0xff, 0xff, 0xfe, 0x80, 0x5f, 0x8f,
  0xff, 0x9b, 0xff, 0xff, 0xff, 0x82, 0x3b, 0xf0, 0xf0, 0x7d, 0xff, 0xff,
  0xff, 0x83, 0x3b, 0xff, 0xff, 0x7d, 0xff, 0xff, 0xff, 0xc7, 0x7b, 0xfd,
  0xfe, 0xfd, 0xff, 0xff, 0xff, 0xc7, 0x7d, 0xfe, 0x7d, 0xfd, 0xff, 0xff,
  0xff, 0xef, 0x7e, 0xff, 0xbb, 0xfb, 0xff, 0xff, 0xff, 0xef, 0x7f, 0x7f,
  0xbb, 0xe5, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x9f, 0xbb, 0xdd, 0xff, 0xff,
  0xff, 0xff, 0x7f, 0xef, 0xbb, 0xbd, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xd0,
  0x7c, 0x7d, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xdf, 0xff, 0x7b, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xbf, 0xfe, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xbf,
  0xfe, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x7f, 0xfd, 0xfe, 0x7f, 0xff,
  0xff, 0xff, 0x7f, 0x0f, 0xe3, 0xff, 0xbf, 0xff, 0xff, 0xfe, 0xfe, 0xf0,
  0x18, 0x7f, 0xbf, 0xff, 0xff, 0xfd, 0xfd, 0xff, 0xff, 0x80, 0x7f, 0xff,
  0xff, 0xfb, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x07, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 5 bitmap data (512 bytes)
const uint8_t ELECTRIC_frame_5[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0x3f, 0x7f, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xbc,
  0x3c, 0xdf, 0xff, 0xff, 0xff, 0xe7, 0xff, 0x3c, 0x91, 0xcf, 0xff, 0xff,
  0xff, 0xf1, 0xfe, 0x39, 0xc3, 0xcf, 0xff, 0xff, 0xff, 0xf0, 0xfe, 0x33,
  0xc7, 0xc7, 0xff, 0xff, 0xff, 0xf8, 0x3e, 0x27, 0xef, 0xc7, 0xff, 0xff,
  0xff, 0xfc, 0x0c, 0x2f, 0xff, 0x87, 0xff, 0xbf, 0xff, 0xfe, 0x04, 0x3f,
  0xff, 0x83, 0xfe, 0x3f, 0xff, 0xff, 0x0c, 0x3f, 0xff, 0x83, 0xfc, 0x7f,
  0xff, 0xff, 0x08, 0x3f, 0xff, 0x81, 0xf0, 0x7f, 0xff, 0xff, 0x98, 0x3f,
  0xff, 0x81, 0x40, 0x7f, 0xff, 0xff, 0xd8, 0x3f, 0xff, 0x80, 0x80, 0xff,
  0xff, 0xff, 0xf0, 0x3f, 0xcf, 0x80, 0x80, 0xff, 0xff, 0xff, 0xf0, 0x1f,
  0xd7, 0x80, 0x40, 0xff, 0xff, 0xfd, 0xe0, 0x1e, 0xd7, 0x80, 0x61, 0xff,
  0xff, 0xf8, 0xe0, 0x1d, 0x5b, 0x80, 0x21, 0xff, 0xff, 0xf0, 0xe0, 0x1d,
  0xbc, 0x80, 0x31, 0xff, 0xf9, 0xe0, 0xe0, 0x01, 0xff, 0x00, 0x13, 0xff,
  0xf8, 0x40, 0xe0, 0x07, 0xff, 0x80, 0x1b, 0xff, 0xf8, 0x00, 0xf0, 0x0f,
  0xff, 0xc0, 0x1f, 0xff, 0xfc, 0x00, 0xf0, 0x1f, 0xff, 0xf0, 0x3f, 0xff,
  0xfc, 0x00, 0xf0, 0x1f, 0xff, 0xf0, 0x7f, 0xff, 0xfe, 0x00, 0xf8, 0x3f,
  0xff, 0xf8, 0x7f, 0xff, 0xfe, 0x00, 0x78, 0x3f, 0xff, 0xcc, 0xff, 0xff,
  0xfe, 0x00, 0x78, 0x7c, 0xff, 0x85, 0xff, 0xff, 0xff, 0x10, 0x7c, 0x78,
  0x7f, 0x82, 0xff, 0xff, 0xff, 0x10, 0x7c, 0xf0, 0x3f, 0x8a, 0xff, 0xbf,
  0xff, 0xb0, 0x7e, 0xf3, 0x3f, 0x9a, 0xff, 0x3e, 0xff, 0xb0, 0x71, 0xf1,
  0x9f, 0xb2, 0x7f, 0x38, 0xff, 0xf8, 0x77, 0xf0, 0x5f, 0xc3, 0xbe, 0x21,
  0xff, 0xf8, 0x79, 0xf0, 0x1f, 0xe4, 0xbc, 0x01, 0xff, 0xf8, 0x7b, 0xf8,
  0x3c, 0x7c, 0xdc, 0x03, 0xff, 0xf8, 0x67, 0xc4, 0x7e, 0xff, 0xe8, 0x43,
  0xff, 0xfc, 0x5f, 0xc7, 0xec, 0xdf, 0x1f, 0xc7, 0xff, 0xfc, 0x47, 0xff,
  0xf3, 0x3e, 0x3f, 0xc7, 0xff, 0xfc, 0x79, 0xff, 0xff, 0xfc, 0xff, 0xcf,
  0xff, 0xfc, 0x76, 0x1f, 0xff, 0xf9, 0xff, 0xcf, 0xff, 0xfe, 0x37, 0xe3,
  0xff, 0xe6, 0xff, 0xdf, 0xff, 0xfe, 0x2e, 0xfc, 0x3c, 0x1f, 0x7f, 0xff,
  0xff, 0xfe, 0x2e, 0xff, 0xff, 0xdf, 0x7f, 0xff, 0xff, 0xfe, 0x1e, 0xff,
  0x7f, 0xbf, 0x7f, 0xff, 0xff, 0xff, 0x1f, 0x7f, 0x9f, 0x7f, 0x7f, 0xff,
  0xff, 0xff, 0x1f, 0xbf, 0xee, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xdf,
  0xee, 0xf9, 0x7f, 0xff, 0xff, 0xff, 0x9f, 0xe7, 0xee, 0xf7, 0x7f, 0xff,
  0xff, 0xff, 0xdf, 0xfb, 0xee, 0xef, 0x7f, 0xff, 0xff, 0xff, 0xdf, 0xf4,
  0x1f, 0x1f, 0x7f, 0xff, 0xff, 0xff, 0xef, 0xf7, 0xff, 0xde, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xef, 0xff, 0xbd, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xef,
  0xff, 0xb8, 0x7f, 0xff, 0xff, 0xff, 0xef, 0xdf, 0xff, 0x7f, 0x9f, 0xff,
  0xff, 0xff, 0xdf, 0xc3, 0xf8, 0xff, 0xef, 0xff, 0xff, 0xff, 0xbf, 0xbc,
  0x06, 0x1f, 0xef, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0xff, 0xe0, 0x1f, 0xff,
  0xff, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x01, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 6 bitmap data (512 bytes)
const uint8_t ELECTRIC_frame_6[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff,
  0x9f, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xaf, 0xe3, 0xff, 0xff,
  0xf3, 0xff, 0x07, 0xfd, 0xaf, 0xc0, 0xff, 0xff, 0xf3, 0xfc, 0x00, 0xfa,
  0xb7, 0x00, 0x3f, 0xff, 0xf1, 0xe0, 0x00, 0x1b, 0x78, 0x00, 0x0f, 0xff,
  0xf1, 0x00, 0x00, 0x03, 0xfe, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x00, 0x0f,
  0xff, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x1f, 0xff, 0x80, 0x00, 0x1f,
  0xe0, 0x00, 0x00, 0x3f, 0xff, 0xe0, 0x00, 0x07, 0xf8, 0xfe, 0x00, 0x3f,
  0xff, 0xe0, 0x00, 0x03, 0xf8, 0xff, 0xe0, 0x7f, 0xff, 0xf4, 0x00, 0x7f,
  0xf8, 0xff, 0xff, 0x7f, 0xff, 0xfb, 0xff, 0xff, 0xf8, 0x7f, 0xfe, 0xff,
  0xff, 0xfb, 0xff, 0xff, 0xf8, 0x7f, 0xfe, 0xff, 0xff, 0x85, 0xff, 0xff,
  0xf8, 0x7f, 0xfd, 0xf0, 0xff, 0x05, 0xff, 0xff, 0xf8, 0x7f, 0xfd, 0xe0,
  0x7f, 0x65, 0xff, 0xff, 0xf8, 0x37, 0xe3, 0xe1, 0xbf, 0x24, 0xff, 0xff,
  0xf8, 0x37, 0xef, 0xe1, 0xbf, 0x27, 0x7f, 0xff, 0xf8, 0x23, 0xf3, 0xd9,
  0x3f, 0x89, 0x7f, 0xff, 0xf8, 0x23, 0xf7, 0xbc, 0x78, 0xf9, 0xbf, 0xff,
  0xf8, 0x01, 0xc1, 0x80, 0xfd, 0xff, 0xdf, 0xff, 0xf8, 0x01, 0xbe, 0x8f,
  0xf9, 0xfe, 0x3f, 0xff, 0xfc, 0x01, 0xbf, 0x3f, 0xe6, 0xfc, 0x3f, 0xff,
  0xfc, 0x00, 0xbf, 0xdf, 0xdf, 0x7b, 0xdf, 0xff, 0xfc, 0x00, 0xbf, 0xef,
  0xbf, 0xb7, 0xdf, 0xff, 0xfc, 0x00, 0x4f, 0xf7, 0xc0, 0x4f, 0xdf, 0xff,
  0xfc, 0x08, 0x57, 0xf8, 0x78, 0xff, 0xdf, 0xff, 0xfc, 0x1e, 0x3b, 0xff,
  0xff, 0xff, 0xbf, 0xff, 0xfc, 0x3f, 0xbd, 0xff, 0xff, 0xff, 0x7f, 0xff,
  0xfc, 0x7f, 0xbe, 0x7f, 0xff, 0xfe, 0x7f, 0xff, 0xfe, 0xff, 0xbf, 0xbf,
  0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xfe, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xef,
  0xff, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xef, 0xff, 0xbd, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xdf, 0xff, 0x7b, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdf,
  0xff, 0x70, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xbf, 0xfe, 0xff, 0x3f, 0xff,
  0xff, 0xff, 0xbf, 0x87, 0xf1, 0xff, 0xdf, 0xff, 0xff, 0xff, 0x7f, 0x78,
  0x0c, 0x3f, 0xdf, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xc0, 0x3f, 0xff,
  0xff, 0xfd, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 7 bitmap data (512 bytes)
const uint8_t ELECTRIC_frame_7[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xff,
  0xf3, 0xff, 0xff, 0xff, 0xaf, 0xc7, 0xff, 0xff, 0xf3, 0xff, 0x83, 0xfd,
  0xaf, 0x81, 0xff, 0xff, 0xf1, 0xfe, 0x00, 0x7a, 0xb6, 0x00, 0x7f, 0xff,
  0xf1, 0xf0, 0x00, 0x0b, 0x78, 0x00, 0x1f, 0xff, 0xf1, 0x80, 0x00, 0x03,
  0xfc, 0x00, 0x07, 0xff, 0xf0, 0x00, 0x00, 0x07, 0xff, 0x00, 0x01, 0xff,
  0xf8, 0x00, 0x00, 0x1f, 0xff, 0x80, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x3f,
  0xff, 0xe0, 0x00, 0x0f, 0xf8, 0xff, 0x00, 0x3f, 0xff, 0xe0, 0x00, 0x07,
  0xf8, 0xff, 0xf0, 0x7f, 0xff, 0xf0, 0x00, 0xff, 0xf8, 0x7f, 0xfc, 0x7f,
  0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xfe, 0xff, 0xff, 0xfb, 0xff, 0xff,
  0xf8, 0x7f, 0xfe, 0xff, 0xff, 0xe5, 0xff, 0xff, 0xf8, 0x7f, 0xfd, 0xf1,
  0xff, 0x85, 0xff, 0xff, 0xf8, 0x37, 0xfd, 0xf8, 0xff, 0x3d, 0xff, 0xff,
  0xf8, 0x37, 0xe3, 0xfc, 0x7f, 0x1c, 0xff, 0xff, 0xf8, 0x23, 0xef, 0xe3,
  0x3f, 0xc3, 0x7f, 0xff, 0xf8, 0x23, 0xf3, 0xd8, 0x3f, 0xe9, 0x7f, 0xff,
  0xf8, 0x01, 0xf7, 0xbc, 0x78, 0xf9, 0xbf, 0xff, 0xf8, 0x01, 0xcf, 0x80,
  0xfd, 0xff, 0xdf, 0xff, 0xfc, 0x01, 0xbf, 0x8f, 0xf9, 0xfe, 0x3f, 0xff,
  0xfc, 0x00, 0x8f, 0xff, 0xe6, 0xfc, 0x7f, 0xff, 0xfc, 0x00, 0xe3, 0x3f,
  0xdf, 0x79, 0xff, 0xff, 0xfc, 0x00, 0x5c, 0x1f, 0xbf, 0xb0, 0xff, 0xff,
  0xfc, 0x08, 0x5d, 0xc7, 0xc0, 0x4e, 0xff, 0xff, 0xfc, 0x1e, 0x3b, 0xf0,
  0x78, 0x3e, 0xff, 0xff, 0xfc, 0x3f, 0xbb, 0xf9, 0xff, 0x7e, 0xff, 0xff,
  0xfc, 0x7f, 0xbd, 0xfe, 0xff, 0x7d, 0xff, 0xff, 0xfe, 0xff, 0xbe, 0xfe,
  0xff, 0x72, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x7e, 0xff, 0xae, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xb9, 0xff, 0xde, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xc7,
  0xff, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xef, 0xff, 0xbd, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xdf, 0xff, 0x7b, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdf,
  0xff, 0x70, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xbf, 0xfe, 0xff, 0x3f, 0xff,
  0xff, 0xff, 0xbf, 0x87, 0xf1, 0xff, 0xdf, 0xff, 0xff, 0xff, 0x7f, 0x78,
  0x0c, 0x3f, 0xdf, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xc0, 0x3f, 0xff,
  0xff, 0xfd, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 8 bitmap data (512 bytes)
const uint8_t ELECTRIC_frame_8[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff,
  0x9f, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xaf, 0xc7, 0xff, 0xff,
  0xf3, 0xff, 0xff, 0xfd, 0xaf, 0x81, 0xff, 0xff, 0xf3, 0xff, 0x07, 0xfa,
  0xb6, 0x00, 0x7f, 0xff, 0xf1, 0xfc, 0x00, 0xfb, 0x78, 0x00, 0x1f, 0xff,
  0xf1, 0xe0, 0x00, 0x13, 0xfe, 0x00, 0x07, 0xff, 0xf1, 0x00, 0x00, 0x07,
  0xff, 0x00, 0x01, 0xff, 0xf0, 0x00, 0x00, 0x0f, 0xff, 0x80, 0x00, 0x3f,
  0xf0, 0x00, 0x00, 0x1f, 0xff, 0xc0, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x3f,
  0xff, 0xe0, 0x00, 0x07, 0xf8, 0xfe, 0x00, 0x7f, 0xff, 0xf0, 0x00, 0xff,
  0xf8, 0xff, 0xe0, 0x7f, 0xff, 0x99, 0xff, 0xff, 0xf8, 0x7f, 0xe0, 0xf9,
  0xff, 0x0b, 0xff, 0xff, 0xf8, 0x7f, 0xfc, 0xf0, 0xff, 0x05, 0xff, 0xff,
  0xf8, 0x7f, 0xfd, 0xe0, 0x7f, 0x25, 0xff, 0xff, 0xf8, 0x7f, 0xfd, 0xe1,
  0x7f, 0x75, 0xff, 0xff, 0xf8, 0x37, 0xe3, 0xe3, 0xbf, 0xb4, 0xff, 0xff,
  0xf8, 0x37, 0xef, 0xe3, 0xbf, 0xa7, 0x7f, 0xff, 0xf8, 0x23, 0xf3, 0xd9,
  0x3f, 0xc9, 0x7f, 0xff, 0xf8, 0x23, 0xf7, 0xbc, 0x78, 0xf9, 0xbf, 0xff,
  0xf8, 0x01, 0xcf, 0x80, 0xfd, 0xff, 0xdf, 0xff, 0xf8, 0x01, 0xbf, 0x8f,
  0xf9, 0xfe, 0x3f, 0xff, 0xfc, 0x01, 0x8f, 0xff, 0xe6, 0xfc, 0x7f, 0xff,
  0xfc, 0x00, 0xe3, 0xff, 0xdf, 0x79, 0xff, 0xff, 0xfc, 0x00, 0xec, 0x3f,
  0xbf, 0xb1, 0xff, 0xff, 0xfc, 0x00, 0x5d, 0xc7, 0xc0, 0x4c, 0xff, 0xff,
  0xfc, 0x08, 0x5d, 0xf8, 0x78, 0x3e, 0xff, 0xff, 0xfc, 0x1e, 0x3d, 0xfe,
  0xff, 0x3e, 0xff, 0xff, 0xfc, 0x3f, 0xbe, 0xff, 0x3e, 0xfe, 0xff, 0xff,
  0xfc, 0x7f, 0xbf, 0x7f, 0xdd, 0xfd, 0xff, 0xff, 0xfe, 0xff, 0xbf, 0xbf,
  0xdd, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xcf, 0xdd, 0xee, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xf7, 0xdd, 0xde, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xe8,
  0x3e, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xef, 0xff, 0xbd, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xdf, 0xff, 0x7b, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdf,
  0xff, 0x70, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xbf, 0xfe, 0xff, 0x3f, 0xff,
  0xff, 0xff, 0xbf, 0x87, 0xf1, 0xff, 0xdf, 0xff, 0xff, 0xff, 0x7f, 0x78,
  0x0c, 0x3f, 0xdf, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xc0, 0x3f, 0xff,
  0xff, 0xfd, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 9 bitmap data (512 bytes)
const uint8_t ELECTRIC_frame_9[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
  0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x87, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xe0, 0x83, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
  0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,
  0x03, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60, 0x03, 0x9f, 0xff, 0xff,
  0xff, 0xff, 0xfc, 0x70, 0x07, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x78,
  0x0f, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7c, 0x1f, 0x8f, 0xff, 0xff,
  0xff, 0xff, 0xf8, 0x7e, 0x3f, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f,
  0x7f, 0x07, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0x07, 0xff, 0xff,
  0xff, 0xff, 0xf0, 0x7f, 0xff, 0x03, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f,
  0xff, 0x03, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f, 0xff, 0x01, 0xff, 0xff,
  0xff, 0xff, 0xe0, 0x7f, 0x9f, 0x01, 0xff, 0xff, 0xf7, 0xff, 0xe0, 0x3f,
  0xaf, 0x00, 0xff, 0xff, 0xf7, 0xff, 0xc0, 0x3d, 0xaf, 0x00, 0xff, 0xff,
  0xf3, 0xff, 0xc0, 0x3a, 0xb7, 0x00, 0x7f, 0xff, 0xf3, 0xff, 0xc0, 0x3b,
  0x79, 0x00, 0x7f, 0xff, 0xf1, 0xff, 0xc0, 0x03, 0xfe, 0x00, 0x3f, 0xff,
  0xf1, 0xff, 0xc0, 0x0f, 0xff, 0x00, 0x3f, 0xff, 0xf1, 0xff, 0xe0, 0x1f,
  0xff, 0x80, 0x3f, 0xff, 0xf1, 0xff, 0xe0, 0x3f, 0xff, 0xe0, 0x7f, 0xff,
  0xf8, 0xff, 0xe0, 0x3f, 0xff, 0xe0, 0xff, 0xff, 0xf8, 0xff, 0xf0, 0x7f,
  0xff, 0xf0, 0xff, 0xff, 0xf8, 0xff, 0xf0, 0x7f, 0xff, 0x99, 0xff, 0xff,
  0xf8, 0xff, 0xf0, 0xf9, 0xff, 0x6b, 0xff, 0xff, 0xf8, 0x7f, 0xf8, 0xf6,
  0xff, 0x65, 0xff, 0xff, 0xf8, 0x7f, 0xf9, 0xe6, 0x7f, 0x05, 0xff, 0xff,
  0xf8, 0x7f, 0xfd, 0xe0, 0x7f, 0x05, 0xff, 0xff, 0xf8, 0x7f, 0xe3, 0xe0,
  0x3f, 0x84, 0xff, 0xff, 0xf8, 0x37, 0xef, 0xe0, 0x3f, 0x87, 0x7f, 0xff,
  0xf8, 0x37, 0xf3, 0xe0, 0x3f, 0xc9, 0x7f, 0xff, 0xf8, 0x23, 0xf7, 0xf0,
  0x78, 0xf9, 0xbf, 0xff, 0xf8, 0x23, 0xcf, 0x88, 0xfd, 0xff, 0xdf, 0xff,
  0xf8, 0x01, 0xbf, 0x8f, 0xd9, 0xbe, 0x3f, 0xff, 0xf8, 0x01, 0x8f, 0xff,
  0xe6, 0x7c, 0x7f, 0xff, 0xfc, 0x01, 0xf3, 0xff, 0xff, 0xf9, 0xff, 0xff,
  0xfc, 0x00, 0xec, 0x3f, 0xff, 0xf3, 0xff, 0xff, 0xfc, 0x00, 0xef, 0xc7,
  0xff, 0xcd, 0xff, 0xff, 0xfc, 0x00, 0x5d, 0xf8, 0x78, 0x3e, 0xff, 0xff,
  0xfc, 0x08, 0x5d, 0xff, 0xff, 0xbe, 0xff, 0xff, 0xfc, 0x1e, 0x3d, 0xfe,
  0xff, 0x7e, 0xff, 0xff, 0xfc, 0x3f, 0xbe, 0xff, 0x3e, 0xfe, 0xff, 0xff,
  0xfc, 0x7f, 0xbf, 0x7f, 0xdd, 0xfd, 0xff, 0xff, 0xfe, 0xff, 0xbf, 0xbf,
  0xdd, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xcf, 0xdd, 0xee, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xf7, 0xdd, 0xde, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xe8,
  0x3e, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xef, 0xff, 0xbd, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xdf, 0xff, 0x7b, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdf,
  0xff, 0x70, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xbf, 0xfe, 0xff, 0x3f, 0xff,
  0xff, 0xff, 0xbf, 0x87, 0xf1, 0xff, 0xdf, 0xff, 0xff, 0xff, 0x7f, 0x78,
  0x0c, 0x3f, 0xdf, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff, 0xc0, 0x3f, 0xff,
  0xff, 0xfd, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 10 bitmap data (512 bytes)
const uint8_t ELECTRIC_frame_10[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 11 bitmap data (512 bytes)
const uint8_t ELECTRIC_frame_11[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#endif  // ELECTRIC_H
