// SPDX-FileCopyrightText: 2025 KOINSLOT, Inc.
// SPDX-License-Identifier: GPL-3.0-or-later

/*
 * Auto-generated header file from plant.bmp
 * Sprite sheet: 3x4 frames
 * Frame size: 64x64 pixels
 * Total frames: 12
 * Format: 1-bit packed bitmap (0=black, 1=white)
 * Generated: 2025-06-29 12:14:54
 *
 * Usage in Kywy projects:
 *   #include "plant.h"
 *
 *   // Draw individual frames:
 *   engine.display.drawBitmap(x, y, PLANT_FRAME_WIDTH,
 *                            PLANT_FRAME_HEIGHT, PLANT_frame_0);
 *
 *   // Animate through frames:
 *   const uint8_t* frames[] = {PLANT_frame_0, PLANT_frame_1, PLANT_frame_2,
 * PLANT_frame_3, PLANT_frame_4, PLANT_frame_5, PLANT_frame_6, PLANT_frame_7,
 * PLANT_frame_8, PLANT_frame_9, PLANT_frame_10, PLANT_frame_11};
 *   engine.display.drawBitmap(x, y, PLANT_FRAME_WIDTH,
 *                            PLANT_FRAME_HEIGHT, frames[currentFrame]);
 */

#ifndef PLANT_H
#define PLANT_H

#include <stdint.h>

// Sprite sheet information
#define PLANT_FRAME_WIDTH 64
#define PLANT_FRAME_HEIGHT 64
#define PLANT_FRAME_COUNT 12
#define PLANT_SPRITE_COLS 3
#define PLANT_SPRITE_ROWS 4

// Frame 0 bitmap data (512 bytes)
const uint8_t PLANT_frame_0[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x5f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xe6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde,
  0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0xf7, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xfd, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfd,
  0xbd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xfd, 0x5e, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xfc, 0xdf, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xfd,
  0xd7, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xef, 0x7b, 0xdb, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xfb, 0xeb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xee, 0xf7,
  0xed, 0xef, 0xff, 0xff, 0xff, 0xff, 0xed, 0xef, 0xed, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xed, 0xdf, 0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe5, 0xdf,
  0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xbf, 0xfa, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0x80, 0x3f, 0xfc, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x7f,
  0xfe, 0x37, 0xff, 0xff, 0xff, 0xff, 0xbe, 0xff, 0xfe, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xff, 0xff, 0x77, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff,
  0xff, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xcf,
  0xfc, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x97, 0xf9, 0x5f, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0x87, 0xf8, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x87,
  0xf8, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xcf, 0xfc, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xff, 0x3f, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xd8,
  0xc6, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xe5, 0xe9, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xfb, 0xf7, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,
  0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xbf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xf9, 0xbf, 0xfb, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x7e,
  0xfd, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xde, 0xfe, 0xfe, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xbe, 0xfe, 0xfe, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xfc,
  0x7f, 0x7b, 0xff, 0xff, 0xff, 0xff, 0x79, 0xf8, 0x3f, 0x3d, 0xff, 0xff,
  0xff, 0xff, 0x71, 0xf9, 0x3f, 0x1d, 0xff, 0xff, 0xff, 0xff, 0x61, 0xf1,
  0x1f, 0x0d, 0xff, 0xff, 0xff, 0xff, 0x61, 0xf1, 0x1f, 0x0d, 0xff, 0xff,
  0xff, 0xff, 0x92, 0xe1, 0x0e, 0x93, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xe3,
  0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x1f, 0xf0, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 1 bitmap data (512 bytes)
const uint8_t PLANT_frame_1[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
  0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0xef, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xde, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e,
  0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xfd, 0xb9, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xfd, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xfc,
  0xdf, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xfd, 0xd7, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x7b, 0xdb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xef, 0xfb,
  0xeb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xee, 0xf7, 0xed, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xed, 0xef, 0xed, 0xef, 0xff, 0xff, 0xff, 0xff, 0xed, 0xdf,
  0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe5, 0xdf, 0xf6, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xf4, 0xbf, 0xfa, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3f,
  0xfc, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x00, 0x7f, 0xfe, 0x07, 0xff, 0xff,
  0xff, 0xff, 0x7e, 0xff, 0xfe, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff,
  0xff, 0x7b, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xb7, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff,
  0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xcf, 0xfc, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0x97, 0xf9, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x87,
  0xf8, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x87, 0xf8, 0x5f, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xcf, 0xfc, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff,
  0x3f, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xd8, 0xc6, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xe5, 0xe9, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfb,
  0xf7, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xfe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
  0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xfd, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xbf,
  0xfb, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x7e, 0xfd, 0xcf, 0xff, 0xff,
  0xff, 0xff, 0xde, 0xfe, 0xfe, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xbe, 0xfe,
  0xfe, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xfc, 0x7f, 0x7b, 0xff, 0xff,
  0xff, 0xff, 0x79, 0xf8, 0x3f, 0x3d, 0xff, 0xff, 0xff, 0xfe, 0x71, 0xf1,
  0x1f, 0x1e, 0xff, 0xff, 0xff, 0xfe, 0xc3, 0xe3, 0x8f, 0x86, 0xff, 0xff,
  0xff, 0xff, 0x23, 0xc3, 0x87, 0x49, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x8f,
  0xc7, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xf8, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 2 bitmap data (512 bytes)
const uint8_t PLANT_frame_2[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
  0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0xef, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xde, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e,
  0xb7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xfd, 0x59, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xfc, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xfd,
  0xd7, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xef, 0x7b, 0xeb, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xfb, 0xeb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xee, 0xf7,
  0xed, 0xef, 0xff, 0xff, 0xff, 0xff, 0xed, 0xef, 0xed, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xed, 0xdf, 0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe5, 0xdf,
  0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xbf, 0xfa, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xf8, 0x3f, 0xfc, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x7f,
  0xfe, 0x3b, 0xff, 0xff, 0xff, 0xff, 0xbe, 0xff, 0xfe, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xff, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff,
  0xff, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xcf,
  0xfc, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x97, 0xf9, 0x5f, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0x87, 0xf8, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x87,
  0xf8, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xcf, 0xfc, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xff, 0x3f, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xd8,
  0xc6, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xe5, 0xe9, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xfb, 0xf7, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,
  0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xbf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xf9, 0xbf, 0xfb, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x7e,
  0xfd, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xee, 0xfe, 0xfe, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xde, 0xfc, 0x7f, 0x77, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xf9,
  0x3f, 0xbb, 0xff, 0xff, 0xff, 0xff, 0x7b, 0xf1, 0x1f, 0x9d, 0xff, 0xff,
  0xff, 0xfe, 0xf7, 0xe1, 0x1f, 0x8e, 0xff, 0xff, 0xff, 0xfd, 0xef, 0xc1,
  0x0f, 0xc6, 0xff, 0xff, 0xff, 0xfd, 0x8f, 0x83, 0x87, 0xe3, 0x7f, 0xff,
  0xff, 0xfc, 0x47, 0x47, 0x83, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xff,
  0xc3, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 3 bitmap data (512 bytes)
const uint8_t PLANT_frame_3[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x5f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xe6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde,
  0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e, 0xf7, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xfd, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfd,
  0xbd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xfd, 0x5e, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xfc, 0xdf, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xfd,
  0xd7, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xef, 0x7b, 0xdb, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xfb, 0xeb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xee, 0xf7,
  0xed, 0xef, 0xff, 0xff, 0xff, 0xff, 0xed, 0xef, 0xed, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xed, 0xdf, 0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe5, 0xdf,
  0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xbf, 0xfa, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0x80, 0x3f, 0xfc, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x7f,
  0xfe, 0x37, 0xff, 0xff, 0xff, 0xff, 0xbe, 0xff, 0xfe, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xff, 0xff, 0x77, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff,
  0xff, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xcf,
  0xfc, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xb7, 0xfb, 0x5f, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0x97, 0xfa, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xb7,
  0xfb, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xcf, 0xfc, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xff, 0x3f, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xd8,
  0x06, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xe5, 0x89, 0xbf, 0xff, 0xff,
  0xff, 0xfe, 0x3e, 0xf9, 0xc7, 0x79, 0xff, 0xff, 0xff, 0xfd, 0xdf, 0x3e,
  0x0e, 0xe6, 0xff, 0xff, 0xff, 0xfe, 0xe9, 0xc0, 0x01, 0xdd, 0xff, 0xff,
  0xff, 0xff, 0x59, 0xbf, 0xfb, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x7f,
  0xfd, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xf9, 0xbf, 0xfb, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x7e,
  0xfd, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xde, 0xfe, 0xfe, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xbe, 0xfe, 0xfe, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xfc,
  0x7f, 0x7b, 0xff, 0xff, 0xff, 0xff, 0x79, 0xf8, 0x3f, 0x3d, 0xff, 0xff,
  0xff, 0xff, 0x71, 0xf9, 0x3f, 0x1d, 0xff, 0xff, 0xff, 0xff, 0x61, 0xf1,
  0x1f, 0x0d, 0xff, 0xff, 0xff, 0xff, 0x61, 0xf1, 0x1f, 0x0d, 0xff, 0xff,
  0xff, 0xff, 0x92, 0xe1, 0x0e, 0x93, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xe3,
  0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x1f, 0xf0, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 4 bitmap data (512 bytes)
const uint8_t PLANT_frame_4[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
  0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0xef, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xde, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e,
  0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xfd, 0xb9, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xfd, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xfc,
  0xdf, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xfd, 0xd7, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x7b, 0xdb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xef, 0xfb,
  0xeb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xee, 0xf7, 0xed, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xed, 0xef, 0xed, 0xef, 0xff, 0xff, 0xff, 0xff, 0xed, 0xdf,
  0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe5, 0xdf, 0xf6, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xf4, 0xbf, 0xfa, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3f,
  0xfc, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x00, 0x7f, 0xfe, 0x07, 0xff, 0xff,
  0xff, 0xff, 0x7e, 0xff, 0xfe, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff,
  0xff, 0x7b, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xb7, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff,
  0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xcf, 0xfc, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xb7, 0xfb, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x97,
  0xfa, 0x5f, 0x0f, 0xff, 0xff, 0xc1, 0xf7, 0xb7, 0xfb, 0x5e, 0x77, 0xff,
  0xff, 0xbe, 0xf7, 0xcf, 0xfc, 0xde, 0xf7, 0xff, 0xff, 0xbe, 0xf7, 0xff,
  0x3f, 0xdd, 0xf7, 0xff, 0xff, 0xbe, 0xfb, 0xd8, 0x06, 0xbd, 0xf7, 0xff,
  0xff, 0xbe, 0xfd, 0xe5, 0x09, 0xbd, 0xf7, 0xff, 0xff, 0xde, 0xfe, 0xf9,
  0x97, 0x7e, 0xef, 0xff, 0xff, 0xee, 0xff, 0x3e, 0x1e, 0xff, 0x1f, 0xff,
  0xff, 0xf1, 0xe7, 0xc0, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xbf,
  0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x7f, 0xfd, 0xff, 0xe7, 0xff,
  0xff, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xcb, 0xff, 0xff, 0xff, 0xf9, 0xbf,
  0xfb, 0x3f, 0xc7, 0xff, 0xff, 0xff, 0xe7, 0x7e, 0xfd, 0xcf, 0xff, 0xff,
  0xff, 0xff, 0xde, 0xfe, 0xfe, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xbe, 0xfe,
  0xfe, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xfc, 0x7f, 0x7b, 0xff, 0xff,
  0xff, 0xff, 0x79, 0xf8, 0x3f, 0x3d, 0xff, 0xff, 0xff, 0xfe, 0x71, 0xf1,
  0x1f, 0x1e, 0xff, 0xff, 0xff, 0xfe, 0xc3, 0xe3, 0x8f, 0x86, 0xff, 0xff,
  0xff, 0xff, 0x23, 0xc3, 0x87, 0x49, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x8f,
  0xc7, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xf8, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 5 bitmap data (512 bytes)
const uint8_t PLANT_frame_5[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
  0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0xef, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xde, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e,
  0xb7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xfd, 0x59, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xfc, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xfd,
  0xd7, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xef, 0x7b, 0xeb, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xfb, 0xeb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xee, 0xf7,
  0xed, 0xef, 0xff, 0xff, 0xff, 0xff, 0xed, 0xef, 0xed, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xed, 0xdf, 0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe5, 0xdf,
  0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xbf, 0xfa, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xf8, 0x3f, 0xfc, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x7f,
  0xfe, 0x3b, 0xff, 0xff, 0xff, 0xff, 0xbe, 0xff, 0xfe, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xff, 0xff, 0x73, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff,
  0xff, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xdf, 0xff, 0xff,
  0xff, 0xe3, 0xf7, 0xff, 0xff, 0xdf, 0xe0, 0xff, 0xff, 0xdd, 0xf7, 0xcf,
  0xfc, 0xdf, 0xe7, 0x7f, 0xff, 0xbe, 0xf7, 0xb7, 0xfb, 0x5f, 0xdf, 0xbf,
  0xff, 0xdf, 0x77, 0x97, 0xfa, 0x5f, 0xbf, 0x7f, 0xff, 0xee, 0xf7, 0xb7,
  0xfb, 0x5f, 0xbf, 0x7f, 0xff, 0xf5, 0xf7, 0xcf, 0xfc, 0xdf, 0xbe, 0xff,
  0xff, 0xfb, 0xf7, 0xff, 0x3f, 0xdf, 0xbd, 0xff, 0xff, 0xff, 0xfb, 0xd8,
  0x06, 0xbf, 0xdb, 0xff, 0xff, 0xff, 0xfd, 0xe5, 0x09, 0xbf, 0xe7, 0xff,
  0xff, 0xff, 0x9e, 0xf9, 0xc7, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x6f, 0x3c,
  0x0e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xc0, 0x01, 0xf9, 0xff, 0xff,
  0xff, 0xff, 0x9f, 0xbf, 0xfb, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xfd, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xf9, 0xbf, 0xfb, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x7e,
  0xfd, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xee, 0xfe, 0xfe, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xde, 0xfc, 0x7f, 0x77, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xf9,
  0x3f, 0xbb, 0xff, 0xff, 0xff, 0xff, 0x7b, 0xf1, 0x1f, 0x9d, 0xff, 0xff,
  0xff, 0xfe, 0xf7, 0xe1, 0x1f, 0x8e, 0xff, 0xff, 0xff, 0xfd, 0xef, 0xc1,
  0x0f, 0xc6, 0xff, 0xff, 0xff, 0xfd, 0x8f, 0x83, 0x87, 0xe3, 0x7f, 0xff,
  0xff, 0xfc, 0x47, 0x47, 0x83, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xff,
  0xc3, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 6 bitmap data (512 bytes)
const uint8_t PLANT_frame_6[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
  0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xbf, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xcd, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbd,
  0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7d, 0xef, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xfb, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xfb,
  0x7b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xfa, 0xbd, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xf9, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xfb,
  0xaf, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xde, 0xf7, 0xb7, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xf7, 0xd7, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xdd, 0xef,
  0xdb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xdf, 0xdb, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xdb, 0xbf, 0xed, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xcb, 0xbf,
  0xed, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xe9, 0x7f, 0xf5, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0x00, 0x7f, 0xf9, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x70, 0xff,
  0xfc, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x7d, 0xff, 0xfd, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xff, 0xfe, 0xef, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff,
  0xff, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xef, 0x8f,
  0xf8, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xef, 0x27, 0xf2, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x57, 0xf5, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xef, 0x27,
  0xf2, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xef, 0x8f, 0xf8, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xf1,
  0x8f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xca, 0x53, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xd7, 0xea, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f,
  0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x03, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x7f, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff,
  0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xfd, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xcd, 0xff, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3b, 0xf7,
  0xef, 0x7f, 0xff, 0xff, 0xff, 0xfe, 0xf7, 0xf7, 0xf7, 0xbf, 0xff, 0xff,
  0xff, 0xfd, 0xf7, 0xf7, 0xf7, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0xef, 0xe3,
  0xfb, 0xdf, 0xff, 0xff, 0xff, 0xfb, 0xcf, 0xc1, 0xf9, 0xef, 0xff, 0xff,
  0xff, 0xfb, 0x8f, 0xc9, 0xf8, 0xef, 0xff, 0xff, 0xff, 0xfb, 0x0f, 0x88,
  0xf8, 0x6f, 0xff, 0xff, 0xff, 0xfb, 0x0f, 0x88, 0xf8, 0x6f, 0xff, 0xff,
  0xff, 0xfc, 0x97, 0x08, 0x74, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x1c,
  0x77, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0x87, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 7 bitmap data (512 bytes)
const uint8_t PLANT_frame_7[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x9f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf8, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6,
  0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0xef, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x3e, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfd,
  0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfd, 0xbd, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xfd, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xfc,
  0xdf, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xfd, 0xd7, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x7b, 0xdb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xef, 0xfb,
  0xeb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xee, 0xf7, 0xed, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xed, 0xef, 0xed, 0xef, 0xff, 0xff, 0xff, 0xff, 0xed, 0xdf,
  0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe5, 0xdf, 0xf6, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xf4, 0xbf, 0xfa, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x80, 0x3f,
  0xfc, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xb8, 0x7f, 0xfe, 0x37, 0xff, 0xff,
  0xff, 0xff, 0xbe, 0xff, 0xfe, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff,
  0xff, 0x77, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xaf, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff,
  0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xc7, 0xfc, 0x5f, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0x93, 0xf9, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xab,
  0xfa, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x93, 0xf9, 0x1f, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xc7, 0xfc, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff,
  0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xf8, 0xc7, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xe5, 0x29, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xeb,
  0xf5, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xfe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x80, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xf9, 0xbf, 0xfb, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x7e,
  0xfd, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xde, 0xfe, 0xfe, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xbe, 0xfe, 0xfe, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xfc,
  0x7f, 0x7b, 0xff, 0xff, 0xff, 0xff, 0x79, 0xf8, 0x3f, 0x3d, 0xff, 0xff,
  0xff, 0xff, 0x71, 0xf9, 0x3f, 0x1d, 0xff, 0xff, 0xff, 0xff, 0x61, 0xf1,
  0x1f, 0x0d, 0xff, 0xff, 0xff, 0xff, 0x61, 0xf1, 0x1f, 0x0d, 0xff, 0xff,
  0xff, 0xff, 0x92, 0xe1, 0x0e, 0x93, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xe3,
  0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x1f, 0xf0, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 8 bitmap data (512 bytes)
const uint8_t PLANT_frame_8[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x2f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf3, 0x77, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef,
  0x77, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0x7b, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x7e, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe,
  0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfe, 0xaf, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xfe, 0x6f, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xfe,
  0xeb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xbd, 0xed, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xfd, 0xf5, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x7b,
  0xf6, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xf7, 0xf6, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xf6, 0xef, 0xfb, 0x77, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xef,
  0xfb, 0x77, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x5f, 0xfd, 0x6f, 0xff, 0xff,
  0xff, 0xff, 0xc0, 0x1f, 0xfe, 0x63, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x3f,
  0xff, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x7f, 0xff, 0x7b, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xff, 0xff, 0xbb, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff,
  0xff, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xe3,
  0xfe, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xc9, 0xfc, 0x8f, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xd5, 0xfd, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xc9,
  0xfc, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xe3, 0xfe, 0x2f, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfc,
  0x63, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xf2, 0x94, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x75, 0xfa, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f,
  0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xdf, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
  0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0x6f, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xef,
  0xef, 0x63, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xdf, 0xef, 0xbd, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xdf, 0xef, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xbf,
  0xc7, 0xde, 0xff, 0xff, 0xff, 0xff, 0xef, 0x3f, 0x83, 0xef, 0x7f, 0xff,
  0xff, 0xff, 0xee, 0x3f, 0x13, 0xe7, 0x7f, 0xff, 0xff, 0xff, 0xec, 0x3e,
  0x11, 0xe3, 0x7f, 0xff, 0xff, 0xff, 0xec, 0x3e, 0x11, 0xe3, 0x7f, 0xff,
  0xff, 0xff, 0xf2, 0x5c, 0x30, 0xc4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdc,
  0x78, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xfe, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 9 bitmap data (512 bytes)
const uint8_t PLANT_frame_9[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
  0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe6, 0xef, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xde, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3e,
  0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfd, 0xfb, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xfd, 0xbd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xfd,
  0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xfc, 0xdf, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xfd, 0xd7, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xef, 0x7b,
  0xdb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xef, 0xfb, 0xeb, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xee, 0xf7, 0xed, 0xef, 0xff, 0xff, 0xff, 0xff, 0xed, 0xef,
  0xed, 0xef, 0xff, 0xff, 0xff, 0xff, 0xed, 0xdf, 0xf6, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xe5, 0xdf, 0xf6, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xbf,
  0xfa, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x80, 0x3f, 0xfc, 0xc7, 0xff, 0xff,
  0xff, 0xff, 0xb8, 0x7f, 0xfe, 0x37, 0xff, 0xff, 0xff, 0xff, 0xbe, 0xff,
  0xfe, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0x77, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xff, 0xff, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff,
  0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xc7, 0xfc, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x9b,
  0xf9, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x9b, 0xf9, 0x9f, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0x83, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xc7,
  0xfc, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0x3f, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0xd8, 0x06, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xe4,
  0x09, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xf9, 0x87, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x3e, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
  0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1e, 0xff, 0xfe, 0xf3, 0xff, 0xff,
  0xff, 0xfe, 0xed, 0xbf, 0xfb, 0x0d, 0xff, 0xff, 0xff, 0xfe, 0xf3, 0x7e,
  0xfd, 0xfd, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0xfd, 0xff, 0xff,
  0xff, 0xff, 0x7e, 0xfe, 0xfe, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xbd, 0xfc,
  0x7f, 0x7b, 0xff, 0xff, 0xff, 0xff, 0x99, 0xf8, 0x3f, 0x33, 0xff, 0xff,
  0xff, 0xff, 0x81, 0xf8, 0x3f, 0x03, 0xff, 0xff, 0xff, 0xff, 0xc1, 0xf0,
  0x1f, 0x07, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xf1, 0x1f, 0x4f, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xe3, 0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xe7,
  0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x1f, 0xf0, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 10 bitmap data (512 bytes)
const uint8_t PLANT_frame_10[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 11 bitmap data (512 bytes)
const uint8_t PLANT_frame_11[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#endif  // PLANT_H
