// SPDX-FileCopyrightText: 2025 KOINSLOT, Inc.
// SPDX-License-Identifier: GPL-3.0-or-later

/*
 * Auto-generated header file from water2.bmp
 * Sprite sheet: 3x4 frames
 * Frame size: 64x64 pixels
 * Total frames: 12
 * Format: 1-bit packed bitmap (0=black, 1=white)
 * Generated: 2025-06-29 12:14:54
 *
 * Usage in Kywy projects:
 *   #include "water2.h"
 *
 *   // Draw individual frames:
 *   engine.display.drawBitmap(x, y, WATER2_FRAME_WIDTH,
 *                            WATER2_FRAME_HEIGHT, WATER2_frame_0);
 *
 *   // Animate through frames:
 *   const uint8_t* frames[] = {WATER2_frame_0, WATER2_frame_1, WATER2_frame_2,
 * WATER2_frame_3, WATER2_frame_4, WATER2_frame_5, WATER2_frame_6,
 * WATER2_frame_7, WATER2_frame_8, WATER2_frame_9, WATER2_frame_10,
 * WATER2_frame_11}; engine.display.drawBitmap(x, y, WATER2_FRAME_WIDTH,
 *                            WATER2_FRAME_HEIGHT, frames[currentFrame]);
 */

#ifndef WATER2_H
#define WATER2_H

#include <stdint.h>

// Sprite sheet information
#define WATER2_FRAME_WIDTH 64
#define WATER2_FRAME_HEIGHT 64
#define WATER2_FRAME_COUNT 12
#define WATER2_SPRITE_COLS 3
#define WATER2_SPRITE_ROWS 4

// Frame 0 bitmap data (512 bytes)
const uint8_t WATER2_frame_0[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfc, 0x7f, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xf9, 0xbf, 0xff,
  0xff, 0xef, 0x7f, 0xff, 0xff, 0xf3, 0xdf, 0xff, 0xff, 0xdc, 0xbf, 0xff,
  0xff, 0xe2, 0xcf, 0xf9, 0xff, 0xdc, 0xbf, 0xff, 0xff, 0xe1, 0x8f, 0xf9,
  0xff, 0xdf, 0xbf, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xd7, 0xbf, 0xff,
  0xff, 0xf4, 0x1f, 0xff, 0xff, 0xef, 0x7f, 0xff, 0xff, 0xfa, 0x3f, 0xff,
  0xff, 0xf0, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf,
  0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f,
  0xff, 0xef, 0x83, 0xff, 0xff, 0xfe, 0x0f, 0xbf, 0xff, 0xf0, 0x7b, 0xff,
  0xfe, 0x3c, 0xf8, 0xdf, 0xc0, 0x3b, 0xc5, 0xff, 0xfe, 0xbc, 0xc0, 0x5e,
  0x3f, 0xca, 0x05, 0xff, 0xfe, 0x3b, 0x40, 0x51, 0xc0, 0x32, 0x05, 0xff,
  0xff, 0xfb, 0x40, 0x6e, 0x00, 0x0a, 0x02, 0xff, 0xff, 0xf7, 0x40, 0x20,
  0x00, 0x01, 0x02, 0xff, 0xff, 0xf7, 0x60, 0x20, 0x00, 0x01, 0x02, 0xff,
  0xff, 0xef, 0xa1, 0xf0, 0x00, 0x01, 0x0f, 0x7f, 0xff, 0xef, 0xbf, 0x01,
  0xe0, 0x31, 0xf8, 0x7f, 0xff, 0xdf, 0x80, 0x01, 0xf0, 0x78, 0x00, 0xff,
  0xff, 0xdf, 0x00, 0x01, 0xf0, 0x78, 0x03, 0xff, 0xff, 0xbe, 0x00, 0x00,
  0x15, 0x40, 0x07, 0xff, 0xff, 0xbc, 0x00, 0x50, 0x00, 0x08, 0x0f, 0xff,
  0xff, 0x78, 0x00, 0x5c, 0x00, 0x18, 0x3f, 0xff, 0xff, 0x70, 0x03, 0x5f,
  0xff, 0xf8, 0x7c, 0x7f, 0xff, 0x60, 0x3f, 0x9b, 0xf8, 0xf9, 0xf9, 0xbf,
  0xff, 0x80, 0xff, 0xdd, 0xc7, 0x33, 0xf9, 0xbf, 0xff, 0x83, 0xff, 0xce,
  0x3f, 0xc3, 0xfa, 0x3f, 0xff, 0xa9, 0xff, 0xd1, 0xff, 0xdd, 0xfc, 0x7f,
  0xff, 0x6e, 0x7c, 0x1e, 0x0e, 0x2d, 0xff, 0xff, 0xff, 0x6f, 0x82, 0xef,
  0xf1, 0xea, 0xff, 0xff, 0xfe, 0xef, 0xed, 0xf7, 0xff, 0xe6, 0xff, 0xff,
  0xfc, 0xef, 0x9d, 0x9b, 0xff, 0xd6, 0xff, 0xff, 0xfd, 0x6f, 0x7b, 0x6c,
  0x7e, 0x35, 0xff, 0xff, 0xfd, 0xae, 0x7a, 0xf6, 0x81, 0x75, 0xff, 0xff,
  0xfd, 0xad, 0xba, 0xfb, 0x7f, 0x63, 0xff, 0xff, 0xfd, 0xc1, 0xca, 0xfd,
  0xbe, 0xdb, 0xff, 0xff, 0xfd, 0xdd, 0xf0, 0xfe, 0x86, 0xbb, 0xff, 0xff,
  0xfe, 0xbe, 0xfe, 0xfe, 0xbd, 0xbd, 0xff, 0xff, 0xfe, 0x7f, 0x7e, 0xfe,
  0xbb, 0x7d, 0xff, 0xff, 0xfe, 0x7f, 0x1d, 0xfe, 0xba, 0xfe, 0xff, 0xff,
  0xfe, 0xff, 0x61, 0xfe, 0x04, 0xfe, 0xff, 0xff, 0xfe, 0xff, 0x7d, 0xfe,
  0xef, 0x7f, 0x7f, 0xff, 0xfd, 0xff, 0x7d, 0xfe, 0x9f, 0x7e, 0x7f, 0xff,
  0xfd, 0xff, 0x1c, 0x7c, 0x7f, 0xa5, 0xbf, 0xff, 0xfd, 0x92, 0x61, 0xba,
  0xff, 0x99, 0xbf, 0xff, 0xfd, 0x6d, 0x7d, 0xd6, 0xff, 0xd8, 0x3f, 0xff,
  0xfe, 0x00, 0xfe, 0xd5, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 1 bitmap data (512 bytes)
const uint8_t WATER2_frame_1[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff,
  0xff, 0xf0, 0xff, 0xff, 0xff, 0xf9, 0xbf, 0xff, 0xff, 0xef, 0x7f, 0xff,
  0xff, 0xf3, 0xdf, 0xff, 0xff, 0xdc, 0xbf, 0xff, 0xff, 0xe2, 0xcf, 0xf9,
  0xff, 0xdc, 0xbf, 0xff, 0xff, 0xe1, 0x8f, 0xf9, 0xff, 0xdf, 0xbf, 0xff,
  0xff, 0xe0, 0x0f, 0xff, 0xff, 0xd7, 0xbf, 0xff, 0xff, 0xf4, 0x1f, 0xff,
  0xff, 0xef, 0x7f, 0xff, 0xff, 0xfa, 0x3f, 0xff, 0xff, 0xf0, 0xff, 0xff,
  0xff, 0xfc, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
  0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xfc, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x3f, 0xff, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff,
  0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f, 0xff, 0xef, 0x83, 0xff,
  0xff, 0xfe, 0x0f, 0xbf, 0xff, 0xf0, 0x7b, 0xff, 0xfe, 0x3c, 0xf8, 0xdf,
  0xc0, 0x3b, 0xc5, 0xff, 0xfe, 0xbc, 0xc0, 0x5e, 0x3f, 0xca, 0x05, 0xff,
  0xfe, 0x3b, 0x40, 0x51, 0xc0, 0x32, 0x05, 0xff, 0xff, 0xfb, 0x40, 0x6e,
  0x00, 0x0a, 0x02, 0xff, 0xff, 0xf7, 0x40, 0x20, 0x00, 0x01, 0x02, 0xff,
  0xff, 0xf7, 0x60, 0x20, 0x00, 0x01, 0x02, 0xff, 0xff, 0xef, 0xa1, 0xf0,
  0x00, 0x01, 0x0f, 0x7f, 0xff, 0xef, 0xbf, 0x01, 0xe0, 0x31, 0xf8, 0x7f,
  0xff, 0xdf, 0x80, 0x01, 0xf0, 0x78, 0x00, 0xff, 0xff, 0xdf, 0x00, 0x01,
  0xf0, 0x78, 0x03, 0xff, 0xff, 0xbe, 0x00, 0x00, 0x15, 0x40, 0x07, 0xff,
  0xff, 0xbc, 0x00, 0x50, 0x00, 0x08, 0x0f, 0xff, 0xff, 0x78, 0x00, 0x5c,
  0x00, 0x18, 0x3f, 0xff, 0xff, 0x70, 0x03, 0x5f, 0xff, 0xf8, 0x7c, 0x7f,
  0xff, 0x60, 0x3f, 0x9b, 0xf8, 0xf9, 0xf9, 0xbf, 0xff, 0x80, 0xff, 0xdd,
  0xc7, 0x33, 0xf9, 0xbf, 0xff, 0x83, 0xff, 0xce, 0x3f, 0xc3, 0xfa, 0x3f,
  0xff, 0xa9, 0xff, 0xd1, 0xff, 0xdd, 0xfc, 0x7f, 0xff, 0x6e, 0x7c, 0x1e,
  0x0e, 0x2d, 0xff, 0xff, 0xff, 0x6f, 0x82, 0xef, 0xf1, 0xea, 0xff, 0xff,
  0xfe, 0xef, 0xed, 0xf7, 0xff, 0xe6, 0xff, 0xff, 0xfc, 0xef, 0x9d, 0x9b,
  0xff, 0xd6, 0xff, 0xff, 0xfd, 0x6f, 0x7b, 0x6c, 0x7e, 0x35, 0xff, 0xff,
  0xfd, 0xae, 0x7a, 0xf6, 0x81, 0x74, 0xff, 0xff, 0xfd, 0xad, 0xba, 0xfb,
  0x7f, 0x62, 0xff, 0xff, 0xfd, 0xc1, 0xca, 0xfd, 0xbe, 0xef, 0x7f, 0xff,
  0xfd, 0xbd, 0xf0, 0xfe, 0x86, 0xdf, 0xbf, 0xff, 0xfe, 0x7e, 0xfe, 0xfe,
  0xbd, 0xbf, 0xdf, 0xff, 0xfe, 0xff, 0x7e, 0xfe, 0xbb, 0xbf, 0xef, 0xff,
  0xfc, 0xff, 0x1d, 0xfe, 0xb8, 0x3f, 0xcf, 0xff, 0xfd, 0xfe, 0x61, 0xff,
  0x07, 0xdc, 0xb7, 0xff, 0xfb, 0xfe, 0xfd, 0xff, 0x6f, 0xe3, 0x37, 0xff,
  0xf7, 0xfe, 0x7d, 0xff, 0x1f, 0xfb, 0x07, 0xff, 0xf7, 0xfd, 0x9c, 0x7c,
  0x7f, 0xfc, 0x3f, 0xff, 0xf6, 0x49, 0xe1, 0xbb, 0x3f, 0xff, 0xff, 0xff,
  0xf5, 0xb5, 0xfc, 0xd7, 0xbf, 0xff, 0xff, 0xff, 0xf8, 0x03, 0xff, 0x00,
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 2 bitmap data (512 bytes)
const uint8_t WATER2_frame_2[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfc, 0x7f, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xf9, 0xbf, 0xff,
  0xff, 0xef, 0x7f, 0xff, 0xff, 0xf3, 0xdf, 0xff, 0xff, 0xdc, 0xbf, 0xff,
  0xff, 0xe2, 0xcf, 0xf9, 0xff, 0xdc, 0xbf, 0xff, 0xff, 0xe1, 0x8f, 0xf9,
  0xff, 0xdf, 0xbf, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xd7, 0xbf, 0xff,
  0xff, 0xf4, 0x1f, 0xff, 0xff, 0xef, 0x7f, 0xff, 0xff, 0xfa, 0x3f, 0xff,
  0xff, 0xf0, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf,
  0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f,
  0xff, 0xef, 0x83, 0xff, 0xff, 0xfe, 0x0f, 0xbf, 0xff, 0xf0, 0x7b, 0xff,
  0xfe, 0x3c, 0xf8, 0xdf, 0xc0, 0x3b, 0xc5, 0xff, 0xfe, 0xbc, 0xc0, 0x5e,
  0x3f, 0xca, 0x05, 0xff, 0xfe, 0x3b, 0x40, 0x51, 0xc0, 0x32, 0x05, 0xff,
  0xff, 0xfb, 0x40, 0x6e, 0x00, 0x0a, 0x02, 0xff, 0xff, 0xf7, 0x40, 0x20,
  0x00, 0x01, 0x02, 0xff, 0xff, 0xf7, 0x60, 0x20, 0x00, 0x01, 0x02, 0xff,
  0xff, 0xef, 0xa1, 0xf0, 0x00, 0x01, 0x0f, 0x7f, 0xff, 0xef, 0xbf, 0x01,
  0xe0, 0x31, 0xf8, 0x7f, 0xff, 0xdf, 0x80, 0x01, 0xf0, 0x78, 0x00, 0xff,
  0xff, 0xdf, 0x00, 0x01, 0xf0, 0x78, 0x03, 0xff, 0xff, 0xbe, 0x00, 0x00,
  0x15, 0x40, 0x07, 0xff, 0xff, 0xbc, 0x00, 0x50, 0x00, 0x08, 0x0f, 0xff,
  0xff, 0x78, 0x00, 0x5c, 0x00, 0x18, 0x3f, 0xff, 0xff, 0x70, 0x03, 0x5f,
  0xff, 0xf8, 0x7c, 0x7f, 0xff, 0x60, 0x3f, 0x9b, 0xf8, 0xf9, 0xf9, 0xbf,
  0xff, 0x80, 0xff, 0xdd, 0xc7, 0x33, 0xf9, 0xbf, 0xff, 0x83, 0xff, 0xce,
  0x3f, 0xc3, 0xfa, 0x3f, 0xff, 0xa9, 0xff, 0xd1, 0xff, 0xdd, 0xfc, 0x7f,
  0xff, 0x6e, 0x7c, 0x1e, 0x0e, 0x2d, 0xff, 0xff, 0xff, 0x6f, 0x82, 0xef,
  0xf1, 0xea, 0xff, 0xff, 0xfe, 0xef, 0xed, 0xf7, 0xff, 0xe6, 0xff, 0xff,
  0xfc, 0xef, 0x9d, 0x81, 0xff, 0xd6, 0xff, 0xff, 0xfd, 0x6f, 0x7b, 0x7e,
  0x7e, 0x35, 0xff, 0xff, 0xfd, 0xae, 0x7a, 0xff, 0x81, 0x75, 0xff, 0xff,
  0xfd, 0xad, 0xba, 0xff, 0xef, 0x63, 0xff, 0xff, 0xfd, 0xc1, 0xca, 0xff,
  0xee, 0xdb, 0xff, 0xff, 0xfd, 0xdd, 0xf0, 0xdf, 0xee, 0xbb, 0xff, 0xff,
  0xfe, 0xbe, 0xfe, 0xdf, 0xed, 0xbb, 0xff, 0xff, 0xfe, 0x7f, 0x7e, 0x5f,
  0xeb, 0x7b, 0xff, 0xff, 0xfe, 0x7f, 0x1f, 0x9f, 0xea, 0xf7, 0xff, 0xff,
  0xfe, 0xff, 0x60, 0xc7, 0xe1, 0xf7, 0xff, 0xff, 0xfd, 0xfe, 0xff, 0x1b,
  0xe3, 0xe7, 0xff, 0xff, 0xfb, 0xfe, 0x7f, 0xdd, 0x87, 0xe7, 0xff, 0xff,
  0xf7, 0xfd, 0x9f, 0xed, 0x5a, 0x5b, 0xff, 0xff, 0xf6, 0x49, 0xe0, 0x00,
  0x39, 0x9b, 0xff, 0xff, 0xf5, 0xb5, 0xff, 0xff, 0xfd, 0x83, 0xff, 0xff,
  0xf8, 0x03, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 3 bitmap data (512 bytes)
const uint8_t WATER2_frame_3[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xbb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbb,
  0xff, 0xf1, 0xff, 0xff, 0xff, 0xc3, 0xff, 0x7b, 0xff, 0xe6, 0xff, 0xff,
  0xff, 0xbd, 0xfe, 0xfb, 0xff, 0xcf, 0x7e, 0x7f, 0xff, 0x72, 0xfe, 0xf7,
  0xff, 0x8b, 0x3e, 0xa7, 0xff, 0x72, 0xfe, 0xf7, 0xff, 0x86, 0x3d, 0xa4,
  0x7f, 0x7e, 0xbe, 0xef, 0xff, 0x80, 0x3d, 0xbb, 0xbf, 0x5e, 0x5e, 0xdf,
  0xff, 0xd0, 0x7d, 0xb7, 0xbf, 0xbc, 0xdd, 0xbf, 0xff, 0xe8, 0xfd, 0xaf,
  0x7f, 0xc2, 0xbd, 0xbf, 0xff, 0xf1, 0xfb, 0xde, 0xff, 0xfe, 0xa3, 0x7f,
  0xff, 0xff, 0xfb, 0xfe, 0x0f, 0xfe, 0xde, 0xcf, 0xff, 0xff, 0xfb, 0xff,
  0x33, 0xfe, 0xfe, 0x37, 0xff, 0xff, 0xfb, 0xff, 0xbc, 0xfe, 0xfe, 0xfb,
  0xff, 0xff, 0xf7, 0xff, 0x7f, 0x7e, 0xff, 0xfb, 0xff, 0xff, 0xc7, 0xfc,
  0xff, 0xbe, 0xff, 0xf7, 0xff, 0xf8, 0x27, 0xf3, 0xff, 0xc0, 0xff, 0xef,
  0xf8, 0xf3, 0xef, 0xef, 0x00, 0xee, 0xff, 0xdf, 0xfa, 0xf3, 0x0f, 0xd8,
  0xff, 0x28, 0x7f, 0x3f, 0xf8, 0xed, 0x0f, 0x87, 0x00, 0xc8, 0x3c, 0xff,
  0xff, 0xed, 0x0d, 0x38, 0x00, 0x28, 0x03, 0xff, 0xff, 0xdd, 0x0e, 0x80,
  0x00, 0x04, 0x0b, 0xff, 0xff, 0xdd, 0x88, 0x80, 0x00, 0x04, 0x0b, 0xff,
  0xff, 0xbe, 0x87, 0xc0, 0x00, 0x04, 0x3d, 0xff, 0xff, 0xbe, 0xfc, 0x07,
  0x80, 0xc7, 0xe1, 0xff, 0xff, 0x7e, 0x00, 0x07, 0xc1, 0xe0, 0x03, 0xff,
  0xff, 0x7c, 0x00, 0x07, 0xc1, 0xe0, 0x0f, 0xff, 0xfe, 0xf8, 0x00, 0x00,
  0x55, 0x00, 0x1f, 0xff, 0xfe, 0xf0, 0x01, 0x40, 0x00, 0x20, 0x3f, 0xff,
  0xfd, 0xe0, 0x01, 0x70, 0x00, 0x60, 0xff, 0xff, 0xfd, 0xc0, 0x0d, 0x7f,
  0xff, 0xe1, 0xf1, 0xff, 0xfd, 0x80, 0xfe, 0x6f, 0xe3, 0xe7, 0xe6, 0xff,
  0xfe, 0x03, 0xff, 0x77, 0x1c, 0xcf, 0xe6, 0xff, 0xfe, 0x0f, 0xff, 0x38,
  0xff, 0x0f, 0xe8, 0xff, 0xfe, 0xa7, 0xff, 0x47, 0xff, 0x77, 0xf1, 0xff,
  0xfd, 0xb9, 0xf0, 0x78, 0x38, 0xb7, 0xff, 0xff, 0xfd, 0xbe, 0x0b, 0xbf,
  0xc7, 0xaf, 0xff, 0xff, 0xfb, 0x7f, 0x37, 0xdf, 0xff, 0x8f, 0xff, 0xff,
  0xfb, 0x7e, 0x76, 0x6f, 0xff, 0x4f, 0xff, 0xff, 0xfd, 0xbc, 0xfb, 0x6c,
  0x7e, 0x17, 0xff, 0xff, 0xfd, 0xbd, 0x7a, 0xf6, 0x81, 0x57, 0xff, 0xff,
  0xfd, 0xb9, 0xba, 0xfb, 0x7f, 0x0f, 0xff, 0xff, 0xfd, 0xc1, 0xca, 0xfd,
  0xbe, 0x6f, 0xff, 0xff, 0xfd, 0xdd, 0xf0, 0xfe, 0x86, 0xef, 0xff, 0xff,
  0xfe, 0xbe, 0xfe, 0xfe, 0xbc, 0xf7, 0xff, 0xff, 0xfe, 0x7f, 0x7e, 0xfe,
  0xb9, 0xf7, 0xff, 0xff, 0xfe, 0x7f, 0x1d, 0xfe, 0xbb, 0xfb, 0xff, 0xff,
  0xfe, 0xff, 0x61, 0xfe, 0x03, 0xfb, 0xff, 0xff, 0xfe, 0xff, 0x7d, 0xfe,
  0xed, 0xfd, 0xff, 0xff, 0xfd, 0xff, 0x7d, 0xfe, 0x9d, 0xf9, 0xff, 0xff,
  0xfd, 0xff, 0x1c, 0x7c, 0x7e, 0x96, 0xff, 0xff, 0xfd, 0x92, 0x61, 0xba,
  0xfe, 0x66, 0xff, 0xff, 0xfd, 0x6d, 0x7d, 0xd6, 0xff, 0x60, 0xff, 0xff,
  0xfe, 0x00, 0xfe, 0xd5, 0xff, 0x87, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 4 bitmap data (512 bytes)
const uint8_t WATER2_frame_4[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xfd, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x97, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xfb, 0x97, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xfb, 0xf7, 0xfb, 0xff, 0xff, 0xc7, 0xff, 0x9f, 0xfa, 0xf7, 0xf5, 0xff,
  0xff, 0x9b, 0xff, 0x9f, 0x8d, 0xef, 0xed, 0xff, 0xff, 0x3d, 0xff, 0xff,
  0x76, 0x1f, 0xdd, 0xff, 0xfe, 0x2c, 0xff, 0xbe, 0xfb, 0xff, 0xdd, 0xff,
  0xfe, 0x18, 0xff, 0x5d, 0xfb, 0xff, 0xdb, 0xff, 0xfe, 0x00, 0xfe, 0xdb,
  0xfd, 0xff, 0xb7, 0x3f, 0xff, 0x41, 0xfd, 0xd7, 0xfd, 0xff, 0xb4, 0xdf,
  0xff, 0xa3, 0xfb, 0xcf, 0xfb, 0xff, 0x63, 0xef, 0xff, 0xc7, 0xfb, 0xdf,
  0xf3, 0xfe, 0xff, 0xef, 0xff, 0xff, 0xf7, 0xbf, 0xec, 0xfe, 0xff, 0xef,
  0xff, 0xff, 0xf7, 0xff, 0xdf, 0x7e, 0xff, 0xdf, 0xff, 0xff, 0xc7, 0xfe,
  0x3f, 0xbe, 0xff, 0xbf, 0xff, 0xf8, 0x2f, 0xf9, 0xff, 0xc1, 0xf9, 0x7f,
  0xff, 0xf3, 0xe7, 0xc7, 0x00, 0xee, 0xf6, 0xff, 0xe3, 0xf3, 0x07, 0xb8,
  0xff, 0x29, 0xc7, 0xff, 0xeb, 0xed, 0x02, 0x47, 0x00, 0xc8, 0x97, 0xff,
  0xe3, 0xed, 0x01, 0xb8, 0x00, 0x28, 0x0b, 0xff, 0xff, 0xdd, 0x00, 0x80,
  0x00, 0x04, 0x0b, 0xff, 0xff, 0xdd, 0x80, 0x80, 0x00, 0x04, 0x0b, 0xff,
  0xff, 0xbe, 0x87, 0xc0, 0x00, 0x04, 0x3d, 0xff, 0xff, 0xbe, 0xfc, 0x07,
  0x80, 0xc7, 0xe1, 0xff, 0xff, 0x7e, 0x00, 0x07, 0xc1, 0xe0, 0x03, 0xff,
  0xff, 0x7c, 0x00, 0x07, 0xc1, 0xe0, 0x0f, 0xff, 0xfe, 0xf8, 0x00, 0x00,
  0x55, 0x00, 0x1f, 0xff, 0xfe, 0xf0, 0x01, 0x40, 0x00, 0x20, 0x3f, 0xff,
  0xfd, 0xe0, 0x01, 0x70, 0x00, 0x60, 0xff, 0xff, 0xfd, 0xc0, 0x0d, 0x7f,
  0xff, 0xe1, 0xff, 0xff, 0xfd, 0x80, 0xfe, 0x6f, 0xe3, 0xe7, 0xff, 0xff,
  0xfe, 0x03, 0xff, 0x77, 0x1c, 0xcf, 0xc7, 0xff, 0xfe, 0x0f, 0xff, 0x38,
  0xff, 0x0f, 0x9b, 0xff, 0xfe, 0xa7, 0xff, 0x47, 0xff, 0x77, 0x9b, 0xff,
  0xfd, 0xb9, 0xf0, 0x78, 0x38, 0xb7, 0xa3, 0xff, 0xfd, 0xbe, 0x0b, 0xbf,
  0xc7, 0xaf, 0xc7, 0xff, 0xfb, 0x7f, 0x37, 0xdf, 0xff, 0x8f, 0xff, 0xff,
  0xfb, 0x7e, 0x76, 0x6f, 0xff, 0x4f, 0xff, 0xff, 0xfd, 0xbc, 0xfb, 0x6c,
  0x7e, 0x17, 0xff, 0xff, 0xfd, 0xbd, 0x7a, 0xf6, 0x81, 0x57, 0xff, 0xff,
  0xfd, 0xb9, 0xba, 0xfb, 0x7f, 0x0f, 0xff, 0xff, 0xfd, 0xc1, 0xca, 0xfd,
  0xbe, 0x6f, 0xff, 0xff, 0xfd, 0xdd, 0xf0, 0xfe, 0x86, 0xef, 0xff, 0xff,
  0xfe, 0xbe, 0xfe, 0xfe, 0xbc, 0xf7, 0xff, 0xff, 0xfe, 0x7f, 0x7e, 0xfe,
  0xb9, 0xf7, 0xff, 0xff, 0xfe, 0x7f, 0x1d, 0xfe, 0xbb, 0xfb, 0xff, 0xff,
  0xfe, 0xff, 0x61, 0xfe, 0x03, 0xfb, 0xff, 0xff, 0xfe, 0xff, 0x7d, 0xfe,
  0xed, 0xfd, 0xff, 0xff, 0xfd, 0xff, 0x7d, 0xfe, 0x9d, 0xf9, 0xff, 0xff,
  0xfd, 0xff, 0x1c, 0x7c, 0x7e, 0x96, 0xff, 0xff, 0xfd, 0x92, 0x61, 0xba,
  0xfe, 0x66, 0xff, 0xff, 0xfd, 0x6d, 0x7d, 0xd6, 0xff, 0x60, 0xff, 0xff,
  0xfe, 0x00, 0xfe, 0xd5, 0xff, 0x87, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 5 bitmap data (512 bytes)
const uint8_t WATER2_frame_5[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xde, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb9, 0x7f, 0xbf,
  0xff, 0xc7, 0xff, 0xff, 0xff, 0xb9, 0x7f, 0x5f, 0xff, 0x9b, 0xff, 0xff,
  0xff, 0xbf, 0x7e, 0xdf, 0xff, 0x3d, 0xff, 0xcf, 0xff, 0xaf, 0x7e, 0xdf,
  0xfe, 0x2c, 0xff, 0xcf, 0xff, 0xde, 0xfd, 0xdf, 0xfe, 0x18, 0xff, 0xff,
  0xff, 0xe1, 0xfd, 0xbf, 0xfe, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xbf,
  0xff, 0x41, 0xff, 0xc7, 0xff, 0xff, 0xf7, 0x7f, 0xff, 0xa3, 0xff, 0xbb,
  0xff, 0xff, 0xf7, 0x4f, 0xff, 0xc7, 0xff, 0x77, 0xff, 0xff, 0xee, 0xb7,
  0xff, 0xff, 0xfe, 0xc0, 0x0f, 0xff, 0xdd, 0x7b, 0xff, 0xff, 0xfd, 0xa7,
  0xd3, 0xff, 0xba, 0xfb, 0xff, 0xff, 0xf9, 0xcf, 0xdc, 0xff, 0x75, 0xf7,
  0xff, 0xff, 0xfb, 0xbf, 0xbf, 0x7f, 0x7b, 0xf7, 0xff, 0xff, 0xc7, 0xff,
  0x7f, 0xbe, 0x7f, 0xef, 0xff, 0xf8, 0x2e, 0xfe, 0xff, 0xc0, 0xff, 0xdf,
  0xff, 0xf3, 0xdf, 0xf9, 0x00, 0xee, 0xff, 0xbf, 0xf8, 0xf3, 0x3f, 0xe0,
  0xff, 0x29, 0xf0, 0x7f, 0xfa, 0xed, 0x13, 0x07, 0x00, 0xc8, 0x77, 0xff,
  0xf8, 0xed, 0x0c, 0x38, 0x00, 0x28, 0xcb, 0xff, 0xff, 0xdd, 0x00, 0x80,
  0x00, 0x04, 0x0b, 0xff, 0xff, 0xdd, 0x80, 0x80, 0x00, 0x04, 0x0b, 0xff,
  0xff, 0xbe, 0x87, 0xc0, 0x00, 0x04, 0x3d, 0xff, 0xff, 0xbe, 0xfc, 0x07,
  0x80, 0xc7, 0xe1, 0xff, 0xff, 0x7e, 0x00, 0x07, 0xc1, 0xe0, 0x03, 0xff,
  0xff, 0x7c, 0x00, 0x07, 0xc1, 0xe0, 0x0f, 0xff, 0xfe, 0xf8, 0x00, 0x00,
  0x55, 0x00, 0x1f, 0xff, 0xfe, 0xf0, 0x01, 0x40, 0x00, 0x20, 0x3f, 0xff,
  0xfd, 0xe0, 0x01, 0x70, 0x00, 0x60, 0xff, 0xff, 0xfd, 0xc0, 0x0d, 0x7f,
  0xff, 0xe1, 0xff, 0xff, 0xfd, 0x80, 0xfe, 0x6f, 0xe3, 0xe7, 0xff, 0xff,
  0xfe, 0x03, 0xff, 0x77, 0x1c, 0xcf, 0xff, 0xff, 0xfe, 0x0f, 0xff, 0x38,
  0xff, 0x0f, 0xe3, 0xff, 0xfe, 0xa7, 0xff, 0x47, 0xff, 0x77, 0xcd, 0xff,
  0xfd, 0xb9, 0xf0, 0x78, 0x38, 0xb7, 0xcd, 0xff, 0xfd, 0xbe, 0x0b, 0xbf,
  0xc7, 0xaf, 0xd1, 0xff, 0xfb, 0x7f, 0x37, 0xdf, 0xff, 0x8f, 0xe3, 0xff,
  0xfb, 0x7e, 0x76, 0x6f, 0xff, 0x4f, 0xff, 0xff, 0xfd, 0xbc, 0xfb, 0x6c,
  0x7e, 0x17, 0xff, 0xff, 0xfd, 0xbd, 0x7a, 0xf6, 0x81, 0x57, 0xff, 0xff,
  0xfd, 0xb9, 0xba, 0xfb, 0x7f, 0x0f, 0xff, 0xff, 0xfd, 0xc1, 0xca, 0xfd,
  0xbe, 0x6f, 0xff, 0xff, 0xfd, 0xdd, 0xf0, 0xfe, 0x86, 0xef, 0xff, 0xff,
  0xfe, 0xbe, 0xfe, 0xfe, 0xbc, 0xf7, 0xff, 0xff, 0xfe, 0x7f, 0x7e, 0xfe,
  0xb9, 0xf7, 0xff, 0xff, 0xfe, 0x7f, 0x1d, 0xfe, 0xbb, 0xfb, 0xff, 0xff,
  0xfe, 0xff, 0x61, 0xfe, 0x03, 0xfb, 0xff, 0xff, 0xfe, 0xff, 0x7d, 0xfe,
  0xed, 0xfd, 0xff, 0xff, 0xfd, 0xff, 0x7d, 0xfe, 0x9d, 0xf9, 0xff, 0xff,
  0xfd, 0xff, 0x1c, 0x7c, 0x7e, 0x96, 0xff, 0xff, 0xfd, 0x92, 0x61, 0xba,
  0xfe, 0x66, 0xff, 0xff, 0xfd, 0x6d, 0x7d, 0xd6, 0xff, 0x60, 0xff, 0xff,
  0xfe, 0x00, 0xfe, 0xd5, 0xff, 0x87, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 6 bitmap data (512 bytes)
const uint8_t WATER2_frame_6[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfc, 0x7f, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xf9, 0xbf, 0xff,
  0xff, 0xef, 0x7f, 0xff, 0xff, 0xf3, 0xdf, 0xff, 0xff, 0xdc, 0xbf, 0xff,
  0xff, 0xe2, 0xcf, 0xf9, 0xff, 0xdc, 0xbf, 0xff, 0xff, 0xe1, 0x8f, 0xf9,
  0xff, 0xdf, 0xbf, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xd7, 0xbf, 0xff,
  0xff, 0xf4, 0x1f, 0xff, 0xff, 0xef, 0x7f, 0xff, 0xff, 0xfa, 0x3f, 0xff,
  0xff, 0xf0, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf,
  0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f,
  0xff, 0xef, 0x83, 0xff, 0xff, 0xfe, 0x0f, 0xbf, 0xff, 0xf0, 0x7b, 0xff,
  0xfe, 0x3c, 0xf8, 0xdf, 0xc0, 0x3b, 0xc5, 0xff, 0xfe, 0xbc, 0xc0, 0x5e,
  0x3f, 0xca, 0x05, 0xff, 0xfe, 0x3b, 0x40, 0x51, 0xc0, 0x32, 0x05, 0xff,
  0xff, 0xfb, 0x40, 0x6e, 0x00, 0x0a, 0x02, 0xff, 0xff, 0xf7, 0x40, 0x20,
  0x00, 0x01, 0x02, 0xff, 0xff, 0xf7, 0x60, 0x20, 0x00, 0x01, 0x02, 0xff,
  0xff, 0xef, 0xa1, 0xf0, 0x00, 0x01, 0x0f, 0x7f, 0xff, 0xef, 0xbf, 0x00,
  0x80, 0x09, 0xf8, 0x7f, 0xff, 0xdf, 0x80, 0x00, 0x60, 0x30, 0x00, 0xff,
  0xff, 0xdf, 0x00, 0x00, 0x10, 0x40, 0x03, 0xff, 0xff, 0xbe, 0x00, 0x00,
  0x05, 0x00, 0x07, 0xff, 0xff, 0xbc, 0x00, 0x50, 0x00, 0x08, 0x0f, 0xff,
  0xff, 0x78, 0x00, 0x5c, 0x00, 0x18, 0x3f, 0xff, 0xff, 0x70, 0x03, 0x5f,
  0x00, 0x38, 0x7c, 0x7f, 0xff, 0x60, 0x3f, 0x9e, 0x7e, 0xd9, 0xf9, 0xbf,
  0xff, 0x80, 0xff, 0xdc, 0xae, 0xe3, 0xf9, 0xbf, 0xff, 0x83, 0xff, 0xcf,
  0x00, 0x03, 0xfa, 0x3f, 0xff, 0xa9, 0xff, 0xd1, 0xff, 0xdd, 0xfc, 0x7f,
  0xff, 0x6e, 0x7c, 0x1e, 0x0e, 0x2d, 0xff, 0xff, 0xff, 0x6f, 0x82, 0xef,
  0xf1, 0xea, 0xff, 0xff, 0xfe, 0xef, 0xed, 0xf7, 0xff, 0xe6, 0xff, 0xff,
  0xfc, 0xef, 0x9d, 0x9b, 0xff, 0xd6, 0xff, 0xff, 0xfd, 0x6f, 0x7b, 0x6c,
  0x7e, 0x35, 0xff, 0xff, 0xfd, 0xae, 0x7a, 0xf6, 0x81, 0x75, 0xff, 0xff,
  0xfd, 0xad, 0xba, 0xfb, 0x7f, 0x63, 0xff, 0xff, 0xfd, 0xc1, 0xca, 0xfd,
  0xbe, 0xdb, 0xff, 0xff, 0xfd, 0xdd, 0xf0, 0xfe, 0x86, 0xbb, 0xff, 0xff,
  0xfe, 0xbe, 0xfe, 0xfe, 0xbd, 0xbd, 0xff, 0xff, 0xfe, 0x7f, 0x7e, 0xfe,
  0xbb, 0x7d, 0xff, 0xff, 0xfe, 0x7f, 0x1d, 0xfe, 0xba, 0xfe, 0xff, 0xff,
  0xfe, 0xff, 0x61, 0xfe, 0x04, 0xfe, 0xff, 0xff, 0xfe, 0xff, 0x7d, 0xfe,
  0xef, 0x7f, 0x7f, 0xff, 0xfd, 0xff, 0x7d, 0xfe, 0x9f, 0x7e, 0x7f, 0xff,
  0xfd, 0xff, 0x1c, 0x7c, 0x7f, 0xa5, 0xbf, 0xff, 0xfd, 0x92, 0x61, 0xba,
  0xff, 0x99, 0xbf, 0xff, 0xfd, 0x6d, 0x7d, 0xd6, 0xff, 0xd8, 0x3f, 0xff,
  0xfe, 0x00, 0xfe, 0xd5, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 7 bitmap data (512 bytes)
const uint8_t WATER2_frame_7[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xc3, 0xff, 0xff,
  0xff, 0xf9, 0xbf, 0xe7, 0xff, 0xbd, 0xff, 0xff, 0xff, 0xf3, 0xdf, 0xe7,
  0xff, 0x72, 0xff, 0xff, 0xff, 0xe2, 0xcf, 0xff, 0xff, 0x72, 0xff, 0xff,
  0xff, 0xe1, 0x8f, 0xff, 0xff, 0x7e, 0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff,
  0xff, 0x5e, 0xff, 0xff, 0xff, 0xf4, 0x1f, 0xff, 0xff, 0xbd, 0xff, 0xff,
  0xff, 0xfa, 0x3f, 0xe0, 0x07, 0xc3, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0x9f,
  0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xfe, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xff,
  0xff, 0xdf, 0x07, 0xff, 0xff, 0xfc, 0x1f, 0x7f, 0xff, 0xe0, 0xf7, 0xff,
  0xff, 0xf9, 0xf1, 0xbf, 0x80, 0x77, 0x8b, 0xff, 0xfc, 0x79, 0x80, 0xbc,
  0x7f, 0x94, 0x0b, 0xff, 0xfd, 0x76, 0x80, 0xa3, 0x80, 0x64, 0x0b, 0xff,
  0xfc, 0x76, 0x80, 0xdc, 0x00, 0x14, 0x05, 0xff, 0xff, 0xee, 0x80, 0x40,
  0x00, 0x02, 0x05, 0xff, 0xff, 0xee, 0xc0, 0x40, 0x00, 0x02, 0x05, 0xff,
  0xff, 0xdf, 0x43, 0xe0, 0x00, 0x02, 0x1e, 0xff, 0xff, 0xdf, 0x7e, 0x01,
  0x00, 0x13, 0xf0, 0xff, 0xff, 0xbf, 0x00, 0x00, 0xc0, 0x60, 0x01, 0xff,
  0xff, 0xbe, 0x00, 0x00, 0x20, 0x80, 0x07, 0xff, 0xff, 0x7c, 0x00, 0x00,
  0x0a, 0x00, 0x0f, 0xff, 0xff, 0x78, 0x00, 0xa0, 0x00, 0x10, 0x1f, 0xff,
  0xfe, 0xf0, 0x00, 0xb8, 0x00, 0x30, 0x7f, 0xff, 0xfe, 0xe0, 0x06, 0xbe,
  0x00, 0x70, 0xff, 0xff, 0xfe, 0xc0, 0x7f, 0x3c, 0xfd, 0xb3, 0xf8, 0xff,
  0xff, 0x01, 0xff, 0xb9, 0x5d, 0xc7, 0xf3, 0x7f, 0xff, 0x07, 0xff, 0x9e,
  0x00, 0x07, 0xf3, 0x7f, 0xff, 0x53, 0xff, 0xa3, 0xff, 0xbb, 0xf4, 0x7f,
  0xfe, 0xdc, 0xf8, 0x3c, 0x1c, 0x5b, 0xf8, 0xff, 0xfe, 0xdf, 0x05, 0xdf,
  0xe3, 0xd5, 0xff, 0xff, 0xfd, 0xdf, 0xdb, 0xef, 0xff, 0xcd, 0xff, 0xff,
  0xf9, 0xdf, 0x3b, 0x37, 0xff, 0xad, 0xff, 0xff, 0xfa, 0xde, 0xf6, 0xd8,
  0xfc, 0x6b, 0xff, 0xff, 0xfb, 0x5c, 0xf5, 0xed, 0x02, 0xeb, 0xff, 0xff,
  0xfb, 0x5b, 0x75, 0xf6, 0xfe, 0xc7, 0xff, 0xff, 0xfb, 0x83, 0x95, 0xfb,
  0x7d, 0xb7, 0xff, 0xff, 0xfb, 0xbb, 0xe1, 0xfd, 0x0d, 0x77, 0xff, 0xff,
  0xfd, 0x7d, 0xfd, 0xfd, 0x7b, 0x7b, 0xff, 0xff, 0xfc, 0xfe, 0xfd, 0xfd,
  0x76, 0xfb, 0xff, 0xff, 0xfc, 0xfe, 0x3b, 0xfd, 0x75, 0xfd, 0xff, 0xff,
  0xfd, 0xfe, 0xc3, 0xfc, 0x09, 0xfd, 0xff, 0xff, 0xfd, 0xfe, 0xfb, 0xfd,
  0xde, 0xfe, 0xff, 0xff, 0xfb, 0xfe, 0xfb, 0xfd, 0x3e, 0xfc, 0xff, 0xff,
  0xfb, 0xfe, 0x38, 0xf8, 0xff, 0x4b, 0x7f, 0xff, 0xfb, 0x24, 0xc3, 0x75,
  0xff, 0x33, 0x7f, 0xff, 0xfa, 0xda, 0xfb, 0xad, 0xff, 0xb0, 0x7f, 0xff,
  0xfc, 0x01, 0xfd, 0xab, 0xff, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x07,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 8 bitmap data (512 bytes)
const uint8_t WATER2_frame_8[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0x1f, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfe, 0x6f, 0xff,
  0xff, 0xfb, 0xdf, 0xff, 0xff, 0xfc, 0xf7, 0xff, 0xff, 0xf7, 0x2f, 0xff,
  0xff, 0xf8, 0xb3, 0xfe, 0x7f, 0xf7, 0x2f, 0xff, 0xff, 0xf8, 0x63, 0xfe,
  0x7f, 0xf7, 0xef, 0xff, 0xff, 0xf8, 0x03, 0xff, 0xff, 0xf5, 0xef, 0xff,
  0xff, 0xfd, 0x07, 0xff, 0xff, 0xfb, 0xdf, 0xff, 0xff, 0xfe, 0x8f, 0xff,
  0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
  0xff, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xcf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xbf, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f,
  0xff, 0xfb, 0xe0, 0xff, 0xff, 0xff, 0x83, 0xef, 0xff, 0xfc, 0x1e, 0xff,
  0xff, 0x8f, 0x3e, 0x37, 0xf0, 0x0e, 0xf1, 0x7f, 0xff, 0xaf, 0x30, 0x17,
  0x8f, 0xf2, 0x81, 0x7f, 0xff, 0x8e, 0xd0, 0x14, 0x70, 0x0c, 0x81, 0x7f,
  0xff, 0xfe, 0xd0, 0x1b, 0x80, 0x02, 0x80, 0xbf, 0xff, 0xfd, 0xd0, 0x08,
  0x00, 0x00, 0x40, 0xbf, 0xff, 0xfd, 0xd8, 0x08, 0x00, 0x00, 0x40, 0xbf,
  0xff, 0xfb, 0xe8, 0x7c, 0x00, 0x00, 0x43, 0xdf, 0xff, 0xfb, 0xef, 0xc0,
  0x20, 0x02, 0x7e, 0x1f, 0xff, 0xf7, 0xe0, 0x00, 0x18, 0x0c, 0x00, 0x3f,
  0xff, 0xf7, 0xc0, 0x00, 0x04, 0x10, 0x00, 0xff, 0xff, 0xef, 0x80, 0x00,
  0x01, 0x40, 0x01, 0xff, 0xff, 0xef, 0x00, 0x14, 0x00, 0x02, 0x03, 0xff,
  0xff, 0xde, 0x00, 0x17, 0x00, 0x06, 0x0f, 0xff, 0xff, 0xdc, 0x00, 0xd7,
  0xc0, 0x0e, 0x1f, 0x1f, 0xff, 0xd8, 0x0f, 0xe7, 0x9f, 0xb6, 0x7e, 0x6f,
  0xff, 0xe0, 0x3f, 0xf7, 0x2b, 0xb8, 0xfe, 0x6f, 0xff, 0xe0, 0xff, 0xf3,
  0xc0, 0x00, 0xfe, 0x8f, 0xff, 0xea, 0x7f, 0xf4, 0x7f, 0xf7, 0x7f, 0x1f,
  0xff, 0xdb, 0x9f, 0x07, 0x83, 0x8b, 0x7f, 0xff, 0xff, 0xdb, 0xe0, 0xbb,
  0xfc, 0x7a, 0xbf, 0xff, 0xff, 0xbb, 0xfb, 0x7d, 0xff, 0xf9, 0xbf, 0xff,
  0xff, 0x3b, 0xe7, 0x66, 0xff, 0xf5, 0xbf, 0xff, 0xff, 0x5b, 0xde, 0xdb,
  0x1f, 0x8d, 0x7f, 0xff, 0xff, 0x6b, 0x9e, 0xbd, 0xa0, 0x5d, 0x7f, 0xff,
  0xff, 0x6b, 0x6e, 0xbe, 0xdf, 0xd8, 0xff, 0xff, 0xff, 0x70, 0x72, 0xbf,
  0x6f, 0xb6, 0xff, 0xff, 0xff, 0x77, 0x7c, 0x3f, 0xa1, 0xae, 0xff, 0xff,
  0xff, 0xaf, 0xbf, 0xbf, 0xaf, 0x6f, 0x7f, 0xff, 0xff, 0x9f, 0xdf, 0xbf,
  0xae, 0xdf, 0x7f, 0xff, 0xff, 0x9f, 0xc7, 0x7f, 0xae, 0xbf, 0xbf, 0xff,
  0xff, 0xbf, 0xd8, 0x7f, 0x81, 0x3f, 0xbf, 0xff, 0xff, 0xbf, 0xdf, 0x7f,
  0xbb, 0xdf, 0xdf, 0xff, 0xff, 0x7f, 0xdf, 0x7f, 0xa7, 0xdf, 0x9f, 0xff,
  0xff, 0x7f, 0xc7, 0x1f, 0x1f, 0xe9, 0x6f, 0xff, 0xff, 0x64, 0x98, 0x6e,
  0xbf, 0xe6, 0x6f, 0xff, 0xff, 0x5b, 0x5f, 0x75, 0xbf, 0xf6, 0x0f, 0xff,
  0xff, 0x80, 0x3f, 0xb5, 0x7f, 0xf8, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xc0,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 9 bitmap data (512 bytes)
const uint8_t WATER2_frame_9[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfc, 0x7f, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xf9, 0xbf, 0xff,
  0xff, 0xef, 0x7f, 0xff, 0xff, 0xf3, 0xdf, 0xff, 0xff, 0xdc, 0xbf, 0xff,
  0xff, 0xe2, 0xcf, 0xf9, 0xff, 0xdc, 0xbf, 0xff, 0xff, 0xe1, 0x8f, 0xf9,
  0xff, 0xdf, 0xbf, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xd7, 0xbf, 0xff,
  0xff, 0xf4, 0x1f, 0xff, 0xff, 0xef, 0x7f, 0xff, 0xff, 0xfa, 0x3f, 0xff,
  0xff, 0xf0, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf,
  0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f,
  0xff, 0xef, 0x83, 0xff, 0xff, 0xfe, 0x0f, 0xbf, 0xff, 0xf0, 0x7b, 0xff,
  0xfe, 0x3c, 0xf8, 0xdf, 0xc0, 0x3b, 0xc5, 0xff, 0xfe, 0xbc, 0xc0, 0x5e,
  0x3f, 0xca, 0x05, 0xff, 0xfe, 0x3b, 0x40, 0x51, 0xc0, 0x32, 0x05, 0xff,
  0xff, 0xfb, 0x40, 0x6e, 0x00, 0x0a, 0x02, 0xff, 0xff, 0xf7, 0x40, 0x20,
  0x00, 0x01, 0x02, 0xff, 0xff, 0xf7, 0x60, 0x20, 0x00, 0x01, 0x02, 0xff,
  0xff, 0xef, 0xa1, 0xf0, 0xe0, 0x31, 0x0f, 0x7f, 0xff, 0xef, 0xbf, 0x01,
  0xd0, 0x69, 0xf8, 0x7f, 0xff, 0xdf, 0x80, 0x01, 0xf0, 0x78, 0x00, 0xff,
  0xff, 0xdf, 0x00, 0x01, 0xf0, 0x78, 0x03, 0xff, 0xff, 0xbe, 0x00, 0x00,
  0xe5, 0x30, 0x07, 0xff, 0xff, 0xbc, 0x00, 0x50, 0x00, 0x08, 0x0f, 0xff,
  0xff, 0x78, 0x00, 0x5c, 0x00, 0x18, 0x3f, 0xff, 0xff, 0x70, 0x03, 0x5f,
  0xff, 0xf8, 0x7c, 0x7f, 0xff, 0x60, 0x3f, 0x9b, 0xf8, 0xf9, 0xf9, 0xbf,
  0xff, 0x80, 0xff, 0xdd, 0xc7, 0x33, 0xf9, 0xbf, 0xff, 0x83, 0xff, 0xce,
  0x3f, 0xc3, 0xfa, 0x3f, 0xff, 0xa9, 0xff, 0xd1, 0xff, 0xdd, 0xfc, 0x7f,
  0xff, 0x6e, 0x7c, 0x1e, 0x0e, 0x2d, 0xff, 0xff, 0xff, 0x6f, 0x82, 0xef,
  0xf1, 0xea, 0xff, 0xff, 0xfe, 0xef, 0xed, 0xf7, 0xff, 0xe6, 0xff, 0xff,
  0xfc, 0xef, 0x9d, 0x9b, 0xff, 0xd6, 0xff, 0xff, 0xfd, 0x6f, 0x7b, 0x6c,
  0x7e, 0x35, 0xff, 0xff, 0xfd, 0xae, 0x7a, 0xf6, 0x81, 0x75, 0xff, 0xff,
  0xfd, 0xad, 0xba, 0xfb, 0x7f, 0x63, 0xff, 0xff, 0xfd, 0xc1, 0xca, 0xfd,
  0xbe, 0xdb, 0xff, 0xff, 0xfd, 0xdd, 0xf0, 0xfe, 0x86, 0xbb, 0xff, 0xff,
  0xfe, 0xbe, 0xfe, 0xfe, 0xbd, 0xbd, 0xff, 0xff, 0xfe, 0x7f, 0x7e, 0xfe,
  0xbb, 0x7d, 0xff, 0xff, 0xfe, 0x7f, 0x1d, 0xfe, 0xba, 0xfe, 0xff, 0xff,
  0xfe, 0xff, 0x61, 0xfe, 0x04, 0xfe, 0xff, 0xff, 0xfe, 0xff, 0x7d, 0xfe,
  0xef, 0x7f, 0x7f, 0xff, 0xfd, 0xff, 0x7d, 0xfe, 0x9f, 0x7e, 0x7f, 0xff,
  0xfd, 0xff, 0x1c, 0x7c, 0x7f, 0xa5, 0xbf, 0xff, 0xfd, 0x92, 0x61, 0xba,
  0xff, 0x99, 0xbf, 0xff, 0xfd, 0x6d, 0x7d, 0xd6, 0xff, 0xd8, 0x3f, 0xff,
  0xfe, 0x00, 0xfe, 0xd5, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 10 bitmap data (512 bytes)
const uint8_t WATER2_frame_10[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 11 bitmap data (512 bytes)
const uint8_t WATER2_frame_11[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#endif  // WATER2_H
