// SPDX-FileCopyrightText: 2025 KOINSLOT, Inc.
// SPDX-License-Identifier: GPL-3.0-or-later

/*
 * Auto-generated header file from water.bmp
 * Sprite sheet: 3x4 frames
 * Frame size: 64x64 pixels
 * Total frames: 12
 * Format: 1-bit packed bitmap (0=black, 1=white)
 * Generated: 2025-06-29 12:14:54
 *
 * Usage in Kywy projects:
 *   #include "water.h"
 *
 *   // Draw individual frames:
 *   engine.display.drawBitmap(x, y, WATER_FRAME_WIDTH,
 *                            WATER_FRAME_HEIGHT, WATER_frame_0);
 *
 *   // Animate through frames:
 *   const uint8_t* frames[] = {WATER_frame_0, WATER_frame_1, WATER_frame_2,
 * WATER_frame_3, WATER_frame_4, WATER_frame_5, WATER_frame_6, WATER_frame_7,
 * WATER_frame_8, WATER_frame_9, WATER_frame_10, WATER_frame_11};
 *   engine.display.drawBitmap(x, y, WATER_FRAME_WIDTH,
 *                            WATER_FRAME_HEIGHT, frames[currentFrame]);
 */

#ifndef WATER_H
#define WATER_H

#include <stdint.h>

// Sprite sheet information
#define WATER_FRAME_WIDTH 64
#define WATER_FRAME_HEIGHT 64
#define WATER_FRAME_COUNT 12
#define WATER_SPRITE_COLS 3
#define WATER_SPRITE_ROWS 4

// Frame 0 bitmap data (512 bytes)
const uint8_t WATER_frame_0[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0x0f,
  0xf9, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xef, 0xf0, 0x7a, 0xe2, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x7f, 0x9b, 0x60, 0xff, 0xff, 0xff, 0xff, 0xef, 0x9f,
  0xeb, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xe0, 0x6b, 0xb1, 0xff, 0xff,
  0xff, 0xff, 0xf9, 0xff, 0xb3, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f,
  0xdb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x6b, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf8, 0x13, 0xbf, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf7,
  0xeb, 0xbe, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xf3, 0xbe, 0x1f, 0xff,
  0xff, 0xf9, 0xff, 0xbf, 0xf3, 0x5f, 0x3f, 0xff, 0xff, 0xf9, 0xff, 0x7f,
  0xfa, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfd, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xfe, 0x1f, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfc,
  0x0f, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf8, 0x67, 0xe5, 0xff, 0xff,
  0xff, 0xfe, 0xfd, 0xf8, 0x67, 0xe5, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf8,
  0x07, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf9, 0x07, 0xe9, 0xff, 0xff,
  0xff, 0xff, 0xfa, 0xfc, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x76,
  0x1b, 0xed, 0x7f, 0xff, 0xff, 0xff, 0xf7, 0x79, 0xe4, 0xd1, 0x7f, 0xff,
  0xff, 0xff, 0xfb, 0x7e, 0x1f, 0x3c, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f,
  0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x3f, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xf3, 0xdf, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xed, 0xa7,
  0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xee, 0x40, 0x00, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xd6, 0x8f, 0x7d, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xd9, 0x10,
  0xba, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xba, 0xaf, 0x45, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xb5, 0x9f, 0xbb, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xab, 0x9f,
  0x87, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x9f, 0xae, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xce, 0xdf, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x5f,
  0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0xaf, 0xbe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0x4e, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x46,
  0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 1 bitmap data (512 bytes)
const uint8_t WATER_frame_1[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0x0f,
  0xf9, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xef, 0xf0, 0x7a, 0xe2, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x7f, 0x9b, 0x60, 0xff, 0xff, 0xff, 0xff, 0xef, 0x9f,
  0xeb, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xe0, 0x6b, 0xb1, 0xff, 0xff,
  0xff, 0xff, 0xf9, 0xff, 0xb3, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f,
  0xdb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x6b, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf8, 0x13, 0xbf, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf7,
  0xeb, 0xbe, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xf3, 0xbe, 0x1f, 0xff,
  0xff, 0xf9, 0xff, 0xbf, 0xf3, 0x5f, 0x3f, 0xff, 0xff, 0xf9, 0xff, 0x7f,
  0xfa, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfd, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xfe, 0x1f, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfc,
  0x0f, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf8, 0x67, 0xe5, 0xff, 0xff,
  0xff, 0xfe, 0xfd, 0xf8, 0x67, 0xe5, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf8,
  0x07, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf9, 0x07, 0xe9, 0xff, 0xff,
  0xff, 0xff, 0xfa, 0xfc, 0x0f, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x76,
  0x1b, 0xed, 0x7f, 0xff, 0xff, 0xff, 0xf7, 0x79, 0xe4, 0xd1, 0x7f, 0xff,
  0xff, 0xff, 0xfb, 0x7e, 0x1f, 0x3c, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f,
  0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x3f, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xf3, 0xdf, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xed, 0xa7,
  0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xee, 0x40, 0x00, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xd6, 0x8f, 0x7d, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xd9, 0x10,
  0xba, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xba, 0xaf, 0x45, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xb1, 0x9f, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8a, 0x8f,
  0xc5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x0f, 0xcb, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xde, 0xb7, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x57,
  0x5b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x43, 0x6b, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xde, 0x00, 0x0b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xe0,
  0x6b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x87, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 2 bitmap data (512 bytes)
const uint8_t WATER_frame_2[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0x0f, 0xf9, 0xf1, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xf0, 0x7a, 0xe2, 0xff, 0xff, 0xff, 0xff, 0xef, 0x7f,
  0x9b, 0x60, 0xff, 0xff, 0xff, 0xff, 0xef, 0x9f, 0xeb, 0xa8, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xe0, 0x6b, 0xb1, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff,
  0xb3, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xdb, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x80, 0x6b, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
  0x13, 0xbf, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xeb, 0xbe, 0x5f, 0xff,
  0xff, 0xff, 0xff, 0xcf, 0xf3, 0xbe, 0x1f, 0xff, 0xff, 0xf9, 0xff, 0xbf,
  0xf3, 0x5f, 0x3f, 0xff, 0xff, 0xf9, 0xff, 0x7f, 0xfa, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xff, 0xfd, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe,
  0x1f, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfc, 0x0f, 0xf3, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xf8, 0x67, 0xe5, 0xff, 0xff, 0xff, 0xfe, 0xfd, 0xf8,
  0x67, 0xe5, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf8, 0x07, 0xe1, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xf9, 0x07, 0xe9, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xfc,
  0x0f, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x76, 0x1b, 0xed, 0x7f, 0xff,
  0xff, 0xff, 0xf7, 0x79, 0xe4, 0xd1, 0x7f, 0xff, 0xff, 0xff, 0xfb, 0x7e,
  0x1f, 0x3c, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xfb, 0x3f, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xdf,
  0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xed, 0xa7, 0xff, 0x9f, 0xff, 0xff,
  0xff, 0xff, 0xee, 0x40, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x8f,
  0x7d, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xd9, 0x10, 0xba, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xba, 0xaf, 0x45, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xb5, 0x9f,
  0xbb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x81, 0x9f, 0x87, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xce, 0xdf, 0x97, 0xef, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x4f,
  0xdb, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x87, 0xdd, 0xaf, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xc7, 0x5c, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xef, 0xc3,
  0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x0f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 3 bitmap data (512 bytes)
const uint8_t WATER_frame_3[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0x0f,
  0xf9, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xef, 0xf0, 0x7a, 0xe2, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x7f, 0x9b, 0x60, 0xff, 0xff, 0xff, 0xff, 0xef, 0x9f,
  0xeb, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xe0, 0x6b, 0xb1, 0xff, 0xff,
  0xff, 0xff, 0xf9, 0xff, 0xb3, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f,
  0xdb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x6b, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf8, 0x13, 0xbf, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf7,
  0xeb, 0xbe, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xf3, 0xbe, 0x1f, 0xff,
  0xff, 0xf9, 0xff, 0xbf, 0xf3, 0x5f, 0x3f, 0xff, 0xff, 0xf9, 0xff, 0x7f,
  0xfa, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfd, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xf8, 0xff, 0xfb, 0xf3, 0xff, 0xff, 0xff, 0xfd, 0xf8,
  0x1f, 0xf3, 0xed, 0xff, 0xff, 0xff, 0xfd, 0xf8, 0x07, 0xe1, 0xde, 0xff,
  0xff, 0xfe, 0xfd, 0xf8, 0x07, 0x61, 0xbe, 0xff, 0xff, 0xff, 0xfd, 0xfc,
  0x0e, 0x71, 0x7d, 0xff, 0xff, 0xff, 0xfd, 0xfe, 0x1c, 0x3c, 0xfb, 0xff,
  0xff, 0xff, 0xfa, 0xff, 0xf8, 0x1d, 0xe7, 0xff, 0xff, 0xff, 0xf7, 0x7f,
  0xe0, 0x03, 0xdf, 0x9f, 0xff, 0xff, 0xf7, 0x7e, 0x1c, 0x0f, 0xe0, 0x6f,
  0xff, 0xff, 0xfb, 0x7f, 0x3e, 0x3f, 0xff, 0xf7, 0xff, 0xff, 0xfc, 0x7f,
  0x9f, 0x00, 0x3f, 0xf7, 0xff, 0xff, 0xfb, 0x3f, 0xe7, 0x1b, 0xc3, 0xf7,
  0xff, 0xff, 0xf3, 0xdf, 0xf8, 0x67, 0xfc, 0xef, 0xff, 0xff, 0xed, 0xa7,
  0xff, 0x9f, 0xff, 0x1f, 0xff, 0xff, 0xee, 0x40, 0x00, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xd6, 0x8f, 0x7d, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xd9, 0x10,
  0xba, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xba, 0xaf, 0x45, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xb5, 0x9f, 0xbb, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xab, 0x9f,
  0x87, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x9f, 0xae, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xce, 0xdf, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x5f,
  0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0xaf, 0xbe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0x4e, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x46,
  0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 4 bitmap data (512 bytes)
const uint8_t WATER_frame_4[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
  0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x9f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
  0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0x0f,
  0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xf0, 0x7a, 0xf8, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x7f, 0x9b, 0x71, 0x7f, 0xff, 0xff, 0xff, 0xef, 0x9f,
  0xeb, 0xb0, 0x7f, 0xff, 0xff, 0xff, 0xf7, 0xe0, 0x6b, 0xb4, 0x7f, 0xff,
  0xff, 0xff, 0xf9, 0xff, 0xb3, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f,
  0xdb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x6b, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf8, 0x13, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
  0xeb, 0xbf, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xf3, 0xbf, 0x2f, 0xff,
  0xff, 0xfc, 0xff, 0xbf, 0xf3, 0x5f, 0x0f, 0xff, 0xff, 0xfc, 0xff, 0x7f,
  0xfa, 0xef, 0x9f, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfd, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xf8, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf8,
  0x1f, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf8, 0x07, 0xe1, 0xff, 0xff,
  0xff, 0xff, 0x7d, 0xf8, 0x07, 0x61, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfc,
  0x0e, 0x71, 0x87, 0xff, 0xff, 0xff, 0xfd, 0xfe, 0x1c, 0x3c, 0x7b, 0xff,
  0xff, 0xff, 0xfa, 0xff, 0xf8, 0x18, 0xf7, 0xff, 0xff, 0xff, 0xf7, 0x7f,
  0xe0, 0x07, 0xe0, 0x7f, 0xff, 0xff, 0xf7, 0x7e, 0x1c, 0x3f, 0xff, 0xbf,
  0xff, 0xff, 0xfb, 0x7f, 0x3e, 0x0f, 0xff, 0xcf, 0xff, 0xff, 0xfc, 0x7f,
  0x9f, 0x00, 0xff, 0xf7, 0xff, 0xff, 0xfb, 0x3f, 0xe7, 0x1b, 0x0f, 0xef,
  0xff, 0xff, 0xf3, 0xdf, 0xf8, 0x67, 0xf3, 0xdf, 0xff, 0xff, 0xed, 0xa7,
  0xff, 0x9f, 0xfc, 0x3f, 0xff, 0xff, 0xee, 0x40, 0x00, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xd6, 0x8f, 0x7d, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xd9, 0x10,
  0xba, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xba, 0xaf, 0x45, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xb5, 0x9f, 0xbb, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xab, 0x9f,
  0x87, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x9f, 0xae, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xce, 0xdf, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x5f,
  0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0xaf, 0xbe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0x4e, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x46,
  0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 5 bitmap data (512 bytes)
const uint8_t WATER_frame_5[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfd, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0x0f,
  0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xf0, 0x7a, 0xf8, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x7f, 0x9b, 0x71, 0x7f, 0xff, 0xff, 0xff, 0xef, 0x9f,
  0xeb, 0xb0, 0x7f, 0xff, 0xff, 0xff, 0xf7, 0xe0, 0x6b, 0xb4, 0x7f, 0xff,
  0xff, 0xff, 0xf9, 0xff, 0xb3, 0xd8, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f,
  0xdb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x6b, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf8, 0x13, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
  0xeb, 0xbf, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xf3, 0xbf, 0x2f, 0xff,
  0xff, 0xff, 0xff, 0xbf, 0xf3, 0x5f, 0x0f, 0xff, 0xff, 0xf9, 0xff, 0x7f,
  0xfa, 0xef, 0x9f, 0xff, 0xff, 0xf9, 0xfe, 0xff, 0xfd, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xf8, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf8,
  0x1f, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf8, 0x07, 0xe1, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xf8, 0x07, 0x61, 0xf8, 0x1f, 0xff, 0xfe, 0xfd, 0xfc,
  0x0e, 0x71, 0xe7, 0xef, 0xff, 0xff, 0xfd, 0xfe, 0x1c, 0x3d, 0x0f, 0xef,
  0xff, 0xff, 0xfa, 0xff, 0xf8, 0x00, 0xff, 0xdf, 0xff, 0xff, 0xf7, 0x7f,
  0xe0, 0x01, 0xff, 0xbf, 0xff, 0xff, 0xf7, 0x7e, 0x1c, 0x3f, 0xfe, 0x7f,
  0xff, 0xff, 0xfb, 0x7f, 0x3e, 0x1f, 0xfc, 0x3f, 0xff, 0xff, 0xfc, 0x7f,
  0x9f, 0x07, 0xff, 0xdf, 0xff, 0xff, 0xfb, 0x3f, 0xe7, 0x19, 0xff, 0xbf,
  0xff, 0xff, 0xf3, 0xdf, 0xf8, 0x66, 0x7f, 0x7f, 0xff, 0xff, 0xed, 0xa7,
  0xff, 0x9f, 0x80, 0xff, 0xff, 0xff, 0xee, 0x40, 0x00, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xd6, 0x8f, 0x7d, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xd9, 0x10,
  0xba, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xba, 0xaf, 0x45, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xb5, 0x9f, 0xbb, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xab, 0x9f,
  0x87, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x9f, 0xae, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xce, 0xdf, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x5f,
  0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0xaf, 0xbe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0x4e, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x46,
  0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 6 bitmap data (512 bytes)
const uint8_t WATER_frame_6[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0xff,
  0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xef, 0x0f, 0xf9, 0xe2, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xf0, 0x7a, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xef, 0x7f,
  0x9b, 0x68, 0xff, 0xff, 0xff, 0xff, 0xef, 0x9f, 0xeb, 0xb1, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xe0, 0x6b, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff,
  0xb3, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xdb, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x80, 0x6b, 0xdf, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf8,
  0x13, 0xbe, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xeb, 0xbe, 0x1f, 0xff,
  0xff, 0xf9, 0xff, 0xcf, 0xf3, 0xbf, 0x3f, 0xff, 0xff, 0xf9, 0xff, 0xbf,
  0xf3, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xfa, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xff, 0xfd, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff,
  0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0xfe, 0xfd, 0xfb, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf8,
  0x7f, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfc, 0x07, 0xe1, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xf9, 0x07, 0xe9, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xfc,
  0x0f, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x7e, 0x1b, 0xed, 0x7f, 0xff,
  0xff, 0xff, 0xf7, 0x7f, 0xe0, 0xc1, 0x7f, 0xff, 0xff, 0xff, 0xfb, 0x7f,
  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7e, 0xce, 0x03, 0xff, 0xff,
  0xff, 0xff, 0xf3, 0xbf, 0xe7, 0x83, 0xff, 0xff, 0xff, 0xff, 0xed, 0x9f,
  0xf8, 0x07, 0xff, 0xff, 0xff, 0xff, 0xee, 0x40, 0xff, 0x9f, 0xff, 0xff,
  0xff, 0xff, 0xd6, 0x8f, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xd9, 0x10,
  0xba, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xba, 0xaf, 0x45, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xb5, 0x9f, 0xbb, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xab, 0x9f,
  0x87, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x9f, 0xae, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xce, 0xdf, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x5f,
  0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0xaf, 0xbe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0x4e, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x46,
  0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 7 bitmap data (512 bytes)
const uint8_t WATER_frame_7[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0xff, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x0f, 0xf9, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xef, 0xf0,
  0x7a, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xef, 0x7f, 0x9b, 0x7b, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x9f, 0xeb, 0xbb, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xe0,
  0x6b, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xb3, 0xdf, 0xbf, 0xff,
  0xff, 0xff, 0xfe, 0x7f, 0xdb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
  0x6b, 0xdf, 0xbf, 0xff, 0xff, 0xfd, 0xff, 0xf8, 0x13, 0xbe, 0x57, 0xff,
  0xff, 0xfd, 0xff, 0xf7, 0xeb, 0xbf, 0x9f, 0xff, 0xff, 0xf2, 0x7f, 0xcf,
  0xf3, 0xbf, 0xbf, 0xff, 0xff, 0xfd, 0xff, 0xbf, 0xf3, 0x5f, 0xff, 0xff,
  0xff, 0xfd, 0xff, 0x7f, 0xfa, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff,
  0xfd, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0xfe, 0xfd, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xfd, 0x7d, 0xfb,
  0xff, 0xfd, 0xff, 0xff, 0xff, 0xfe, 0xfd, 0xf8, 0x7f, 0xf1, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xfc, 0x07, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf9,
  0x07, 0xe9, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xfc, 0x0f, 0xf0, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0x7e, 0x1b, 0xed, 0x7f, 0xff, 0xff, 0xff, 0xf7, 0x7f,
  0xe0, 0xc1, 0x7f, 0xff, 0xff, 0xff, 0xfb, 0x7f, 0x00, 0x00, 0xff, 0xff,
  0xff, 0xff, 0xf0, 0x7e, 0xce, 0x03, 0xff, 0xff, 0xff, 0xff, 0xed, 0xbf,
  0xe7, 0x83, 0xff, 0xff, 0xff, 0xff, 0xee, 0x1f, 0xf8, 0x07, 0xff, 0xff,
  0xff, 0xff, 0xd6, 0x80, 0x7f, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xd9, 0x10,
  0x80, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xba, 0xaf, 0x45, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xb5, 0x9f, 0xbb, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xab, 0x9f,
  0x87, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x9f, 0xae, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xce, 0xdf, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x5f,
  0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0xaf, 0xbe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0x4e, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x46,
  0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 8 bitmap data (512 bytes)
const uint8_t WATER_frame_8[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xaf, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x0f, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xf0,
  0x7a, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xef, 0x7f, 0x9b, 0x75, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x9f, 0xeb, 0xbb, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xe0,
  0x6b, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xb3, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0x7f, 0xdb, 0xdf, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x80,
  0x6b, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x13, 0xbf, 0xbf, 0xff,
  0xff, 0xff, 0xff, 0xf7, 0xeb, 0xbf, 0x57, 0xff, 0xff, 0xfd, 0xff, 0xcf,
  0xf3, 0xbf, 0xbf, 0xff, 0xff, 0xfa, 0xff, 0xbf, 0xf3, 0x5f, 0xff, 0xff,
  0xff, 0xfd, 0xff, 0x7f, 0xfa, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff,
  0xfd, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfb,
  0xff, 0xfd, 0xff, 0xff, 0xff, 0xfe, 0xfd, 0xf8, 0x7f, 0xf1, 0xff, 0xff,
  0xff, 0xff, 0xfd, 0xfc, 0x07, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf9,
  0x07, 0xe9, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xfc, 0x0f, 0xf0, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0x7e, 0x1b, 0xed, 0x7f, 0xff, 0xff, 0xff, 0xf7, 0x7f,
  0xe0, 0xc1, 0x7f, 0xff, 0xff, 0xff, 0xfb, 0x7f, 0x00, 0x00, 0xff, 0xff,
  0xff, 0xff, 0xf8, 0x7e, 0xce, 0x03, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xbf,
  0xe7, 0x83, 0xff, 0xff, 0xff, 0xff, 0xed, 0x9f, 0xf8, 0x07, 0xff, 0xff,
  0xff, 0xff, 0xce, 0x40, 0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xd6, 0x8f,
  0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xb9, 0x10, 0xba, 0xbf, 0xff, 0xff,
  0xff, 0xff, 0xb0, 0xaf, 0x45, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xab, 0x9f,
  0xbb, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x9f, 0x86, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xce, 0xdf, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x5f,
  0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0xaf, 0xbe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0x4e, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x46,
  0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 9 bitmap data (512 bytes)
const uint8_t WATER_frame_9[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xec, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0x0f,
  0xf9, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xef, 0xf0, 0x7a, 0xe2, 0xff, 0xff,
  0xff, 0xff, 0xef, 0x7f, 0x9b, 0x60, 0xff, 0xff, 0xff, 0xff, 0xef, 0x9f,
  0xeb, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xe0, 0x6b, 0xb1, 0xff, 0xff,
  0xff, 0xff, 0xf9, 0xff, 0xb3, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f,
  0xdb, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x6b, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf8, 0x13, 0xbf, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf7,
  0xeb, 0xbe, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xf3, 0xbe, 0x1f, 0xff,
  0xff, 0xf9, 0xff, 0xbf, 0xf3, 0x5f, 0x3f, 0xff, 0xff, 0xf9, 0xff, 0x7f,
  0xfa, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfd, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xfe, 0xfe, 0x1f, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfc,
  0x0f, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf8, 0xc7, 0xe1, 0xff, 0xff,
  0xff, 0xfe, 0xfd, 0xf9, 0xe7, 0xe5, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfb,
  0xf7, 0xed, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xfd, 0xff, 0xff,
  0xff, 0xff, 0xfa, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x77,
  0xfb, 0xed, 0x7f, 0xff, 0xff, 0xff, 0xf7, 0x79, 0xe0, 0xc1, 0x7f, 0xff,
  0xff, 0xff, 0xfb, 0x7e, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7e,
  0x1c, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x3f, 0x3e, 0x03, 0xff, 0xff,
  0xff, 0xff, 0xf3, 0xdf, 0xc7, 0x07, 0xff, 0xff, 0xff, 0xff, 0xed, 0xa7,
  0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xee, 0x40, 0x00, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xd6, 0x8f, 0x7d, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xd9, 0x10,
  0xba, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xba, 0xaf, 0x45, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xb5, 0x9f, 0xbb, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xab, 0x9f,
  0x87, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x9f, 0xae, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xce, 0xdf, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x5f,
  0xbe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0xaf, 0xbe, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0x4e, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x46,
  0xda, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 10 bitmap data (512 bytes)
const uint8_t WATER_frame_10[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 11 bitmap data (512 bytes)
const uint8_t WATER_frame_11[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#endif  // WATER_H
